#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-BoldItalic (Noto Serif Bold Italic)
// Generated on Thu Mar 30 22:29:28 CEST 2023
static const uint8_t font_NotoSerif_BoldItalic_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x05, 0xEC,
  0xFD, 0xFE, 0x0F, 0x0C, 0x0A, 0xFD, 0x02, 0x01, 0x10, 0x05, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x04, 0x09, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x07, 0x06, 0x09, 0x06, 0x00, 0x13, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x1E, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x40, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x00, 0x63, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x00, 0x96, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x07, 0x03, 0x09, 0x03, 0x00, 0xC2, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x05, 0x0A, 0x05, 0x00, 0xC8, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFF, 0x04, 0x09, 0x05, 0x00, 0xEB, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x05, 0x06, 0x0A, 0x07, 0x01, 0x0A, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x05, 0x08, 0x07, 0x01, 0x1E, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0xFF, 0x02, 0x02, 0x04, 0x01, 0x30, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x03, 0x04, 0x04, 0x01, 0x3A, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x02, 0x02, 0x04, 0x01, 0x3D, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0xFF, 0x04, 0x0A, 0x03, 0x01, 0x41, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0x5E, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0x81, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x06, 0x09, 0x07, 0x01, 0x9C, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xBE, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xDF, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x00, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x20, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x07, 0x09, 0x07, 0x02, 0x41, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x61, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x84, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0xA5, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x02, 0xB0, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x08, 0x07, 0x02, 0xBF, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x05, 0x07, 0x07, 0x02, 0xD0, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x07, 0x07, 0x02, 0xD9, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x06, 0x09, 0x06, 0x02, 0xEB, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x09, 0x0B, 0x03, 0x05, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x08, 0x09, 0x09, 0x03, 0x40, // "A" (U+0041)
  0x00, 0x42, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x03, 0x68, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x08, 0x09, 0x08, 0x03, 0x92, // "C" (U+0043)
  0x00, 0x44, 0xFF, 0x01, 0x08, 0x09, 0x09, 0x03, 0xB7, // "D" (U+0044)
  0x00, 0x45, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x03, 0xE6, // "E" (U+0045)
  0x00, 0x46, 0xFF, 0x01, 0x07, 0x09, 0x07, 0x04, 0x0D, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x04, 0x2D, // "G" (U+0047)
  0x00, 0x48, 0xFF, 0x01, 0x0A, 0x09, 0x0A, 0x04, 0x5A, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x04, 0x8D, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFE, 0x05, 0x09, 0x05, 0x04, 0xA7, // "J" (U+004A)
  0x00, 0x4B, 0xFF, 0x01, 0x09, 0x09, 0x09, 0x04, 0xC9, // "K" (U+004B)
  0x00, 0x4C, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x04, 0xF6, // "L" (U+004C)
  0x00, 0x4D, 0xFF, 0x01, 0x0C, 0x09, 0x0B, 0x05, 0x17, // "M" (U+004D)
  0x00, 0x4E, 0xFF, 0x01, 0x0A, 0x09, 0x09, 0x05, 0x52, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x05, 0x83, // "O" (U+004F)
  0x00, 0x50, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x05, 0xAF, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x09, 0x09, 0x09, 0x05, 0xD5, // "Q" (U+0051)
  0x00, 0x52, 0xFF, 0x01, 0x08, 0x09, 0x08, 0x06, 0x0B, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x07, 0x09, 0x07, 0x06, 0x37, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x08, 0x09, 0x08, 0x06, 0x5B, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x09, 0x09, 0x09, 0x06, 0x7C, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x09, 0x09, 0x08, 0x06, 0xA8, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x0D, 0x09, 0x0D, 0x06, 0xCD, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x09, 0x09, 0x09, 0x07, 0x0A, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x09, 0x09, 0x08, 0x07, 0x34, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x08, 0x09, 0x08, 0x07, 0x56, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFF, 0x05, 0x0A, 0x05, 0x07, 0x7D, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0xFF, 0x02, 0x0A, 0x03, 0x07, 0xA1, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFF, 0x04, 0x0A, 0x05, 0x07, 0xAF, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x05, 0x09, 0x07, 0x07, 0xD4, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0x04, 0xFF, 0x06, 0x07, 0xE7, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x09, 0x04, 0x0A, 0x04, 0x07, 0xEA, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x07, 0x07, 0x08, 0x07, 0xF0, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x08, 0x0F, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x06, 0x07, 0x06, 0x08, 0x33, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x08, 0x4C, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x07, 0x06, 0x08, 0x74, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x06, 0x0A, 0x05, 0x08, 0x8E, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFE, 0x07, 0x07, 0x07, 0x08, 0xB9, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x08, 0xE5, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x09, 0x0D, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x03, 0x0A, 0x04, 0x09, 0x23, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x09, 0x47, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x09, 0x6E, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0B, 0x07, 0x0C, 0x09, 0x84, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x07, 0x07, 0x08, 0x09, 0xB2, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0xD1, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFE, 0x06, 0x07, 0x07, 0x09, 0xEC, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x0A, 0x13, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x06, 0x07, 0x07, 0x0A, 0x39, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0A, 0x4F, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0A, 0x67, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x07, 0x07, 0x08, 0x0A, 0x80, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x00, 0x06, 0x07, 0x07, 0x0A, 0x9F, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x07, 0x0B, 0x0A, 0xBD, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x07, 0x07, 0x07, 0x0A, 0xE6, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFE, 0x06, 0x07, 0x07, 0x0B, 0x04, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x06, 0x07, 0x07, 0x0B, 0x2A, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x06, 0x0A, 0x05, 0x0B, 0x44, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x0A, 0x07, 0x0B, 0x6A, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFF, 0x04, 0x0A, 0x05, 0x0B, 0x79, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x06, 0x06, 0x07, 0x0B, 0x9D, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x0B, 0xA9, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0B, 0xBC, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0B, 0xDC, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x05, 0x08, 0x07, 0x0B, 0xFC, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x07, 0x09, 0x07, 0x0C, 0x0E, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x0A, 0x07, 0x0C, 0x32, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x00, 0x06, 0x0A, 0x07, 0x0C, 0x40, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x09, 0x06, 0x0A, 0x07, 0x0C, 0x6A, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0C, 0x71, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x06, 0x05, 0x09, 0x05, 0x0C, 0xA5, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x06, 0x06, 0x07, 0x0C, 0xB1, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x05, 0x05, 0x07, 0x0C, 0xC4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0C, 0xCC, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x0B, 0x06, 0x0B, 0x06, 0x0D, 0x01, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x06, 0x05, 0x09, 0x05, 0x0D, 0x05, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x08, 0x07, 0x0D, 0x11, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x06, 0x05, 0x0B, 0x05, 0x0D, 0x27, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x05, 0x05, 0x0A, 0x05, 0x0D, 0x3B, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x09, 0x04, 0x0A, 0x04, 0x0D, 0x4C, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x0D, 0x51, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x07, 0x0A, 0x08, 0x0D, 0x77, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x05, 0x02, 0x06, 0x04, 0x0D, 0xA3, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFE, 0x03, 0x00, 0x04, 0x0D, 0xA6, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x05, 0x04, 0x0A, 0x05, 0x0D, 0xAE, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x05, 0x09, 0x05, 0x0D, 0xBC, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x05, 0x06, 0x07, 0x0D, 0xCA, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x00, 0x0A, 0x09, 0x0B, 0x0D, 0xDB, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x0A, 0x09, 0x0B, 0x0E, 0x0E, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x00, 0x0A, 0x09, 0x0B, 0x0E, 0x3F, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x0E, 0x72, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x0E, 0x8B, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x0E, 0xBA, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x0E, 0xE9, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x0F, 0x19, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x0F, 0x49, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x08, 0x0B, 0x09, 0x0F, 0x7A, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x0C, 0x09, 0x0C, 0x0F, 0xA9, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x08, 0x09, 0x08, 0x0F, 0xE0, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x10, 0x0E, // "È" (U+00C8)
  0x00, 0xC9, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x10, 0x3C, // "É" (U+00C9)
  0x00, 0xCA, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x10, 0x6A, // "Ê" (U+00CA)
  0x00, 0xCB, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x10, 0x99, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x10, 0xC9, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x06, 0x0C, 0x05, 0x10, 0xE9, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x11, 0x09, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x06, 0x0C, 0x05, 0x11, 0x2A, // "Ï" (U+00CF)
  0x00, 0xD0, 0xFF, 0x01, 0x08, 0x09, 0x09, 0x11, 0x4C, // "Ð" (U+00D0)
  0x00, 0xD1, 0xFF, 0x01, 0x0A, 0x0C, 0x09, 0x11, 0x7B, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x11, 0xB5, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x11, 0xE9, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x12, 0x1C, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x12, 0x50, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x12, 0x85, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x05, 0x07, 0x07, 0x12, 0xBA, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x12, 0xC8, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x12, 0xFB, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x13, 0x2E, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x13, 0x61, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x13, 0x95, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x09, 0x0C, 0x08, 0x13, 0xCA, // "Ý" (U+00DD)
  0x00, 0xDE, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x13, 0xF3, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x07, 0x0A, 0x08, 0x14, 0x19, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0x54, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0x79, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0x9E, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0xC4, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0xEB, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x15, 0x12, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x07, 0x0B, 0x15, 0x3B, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x06, 0x07, 0x06, 0x15, 0x64, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x15, 0x86, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x15, 0xA6, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x15, 0xC6, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x15, 0xE7, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x16, 0x09, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x0A, 0x04, 0x16, 0x20, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x16, 0x3A, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x16, 0x54, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0x6F, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x16, 0x98, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0xC0, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x16, 0xE2, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x08, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x2B, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x4E, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x08, 0x07, 0x17, 0x72, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x08, 0x07, 0x17, 0x82, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x17, 0x9F, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x17, 0xC5, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x17, 0xEB, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x18, 0x12, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFE, 0x06, 0x0A, 0x07, 0x18, 0x3A, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x06, 0x0A, 0x07, 0x18, 0x67, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFE, 0x06, 0x0A, 0x07, 0x18, 0x98, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x08, 0x0B, 0x09, 0x18, 0xC7, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x07, 0x09, 0x08, 0x18, 0xF3, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x19, 0x16, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x19, 0x46, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFE, 0x08, 0x09, 0x09, 0x19, 0x6C, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x19, 0x9E, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x19, 0xC6, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x07, 0x0A, 0x06, 0x19, 0xF2, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x1A, 0x14, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1A, 0x41, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x1A, 0x62, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1A, 0x8E, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x1A, 0xAE, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1A, 0xDB, // "č" (U+010D)
  0x01, 0x0E, 0xFF, 0x01, 0x08, 0x0C, 0x09, 0x1A, 0xFC, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0A, 0x0A, 0x08, 0x1B, 0x33, // "ď" (U+010F)
  0x01, 0x10, 0xFF, 0x01, 0x08, 0x09, 0x09, 0x1B, 0x62, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x1B, 0x91, // "đ" (U+0111)
  0x01, 0x12, 0xFF, 0x01, 0x07, 0x0B, 0x08, 0x1B, 0xBE, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x09, 0x06, 0x1B, 0xE9, // "ē" (U+0113)
  0x01, 0x14, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x1C, 0x07, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1C, 0x36, // "ĕ" (U+0115)
  0x01, 0x16, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x1C, 0x57, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1C, 0x85, // "ė" (U+0117)
  0x01, 0x18, 0xFF, 0xFE, 0x07, 0x09, 0x08, 0x1C, 0xA5, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x06, 0x07, 0x06, 0x1C, 0xD5, // "ę" (U+0119)
  0x01, 0x1A, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x1C, 0xF8, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1D, 0x27, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1D, 0x48, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFE, 0x07, 0x0A, 0x07, 0x1D, 0x7D, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1D, 0xB0, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFE, 0x07, 0x0A, 0x07, 0x1D, 0xE5, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1E, 0x18, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFE, 0x07, 0x0A, 0x07, 0x1E, 0x4C, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x09, 0x09, 0x0A, 0x1E, 0x7E, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFE, 0x07, 0x0A, 0x07, 0x1E, 0xB2, // "ģ" (U+0123)
  0x01, 0x24, 0xFF, 0x01, 0x0A, 0x0C, 0x0A, 0x1E, 0xE5, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0x20, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x0A, 0x09, 0x0A, 0x1F, 0x4F, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x1F, 0x83, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x1F, 0xAD, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1F, 0xCF, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x1F, 0xE9, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x03, 0x09, 0x04, 0x20, 0x07, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x20, 0x1B, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x20, 0x3C, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFE, 0x05, 0x09, 0x05, 0x20, 0x56, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x03, 0x0A, 0x04, 0x20, 0x79, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x20, 0x96, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x03, 0x07, 0x04, 0x20, 0xB6, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFE, 0x0A, 0x09, 0x0A, 0x20, 0xC7, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x07, 0x0A, 0x08, 0x21, 0x02, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFE, 0x05, 0x0C, 0x05, 0x21, 0x37, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x04, 0x0A, 0x04, 0x21, 0x61, // "ĵ" (U+0135)
  0x01, 0x36, 0xFF, 0xFE, 0x09, 0x09, 0x09, 0x21, 0x87, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x07, 0x0A, 0x07, 0x21, 0xBB, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x07, 0x07, 0x07, 0x21, 0xE8, // "ĸ" (U+0138)
  0x01, 0x39, 0xFF, 0x01, 0x07, 0x0C, 0x08, 0x22, 0x06, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0C, 0x04, 0x22, 0x2E, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFF, 0xFE, 0x07, 0x09, 0x08, 0x22, 0x53, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFE, 0x03, 0x0A, 0x04, 0x22, 0x7A, // "ļ" (U+013C)
  0x01, 0x3D, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x22, 0x9E, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x06, 0x0A, 0x04, 0x22, 0xC2, // "ľ" (U+013E)
  0x01, 0x3F, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x22, 0xE3, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x23, 0x08, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x23, 0x27, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x23, 0x4B, // "ł" (U+0142)
  0x01, 0x43, 0xFF, 0x01, 0x0A, 0x0C, 0x09, 0x23, 0x69, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x23, 0xA2, // "ń" (U+0144)
  0x01, 0x45, 0xFF, 0xFE, 0x0A, 0x09, 0x09, 0x23, 0xC8, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x24, 0x00, // "ņ" (U+0146)
  0x01, 0x47, 0xFF, 0x01, 0x0A, 0x0C, 0x09, 0x24, 0x26, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x24, 0x60, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x09, 0x09, 0x0B, 0x24, 0x87, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFF, 0xFE, 0x0A, 0x09, 0x09, 0x24, 0xB2, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x24, 0xED, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x25, 0x14, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x09, 0x07, 0x25, 0x45, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x25, 0x64, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x25, 0x98, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x25, 0xBB, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x25, 0xF0, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0C, 0x09, 0x0C, 0x26, 0x18, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x07, 0x0B, 0x26, 0x58, // "œ" (U+0153)
  0x01, 0x54, 0xFF, 0x01, 0x08, 0x0C, 0x08, 0x26, 0x82, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x26, 0xB5, // "ŕ" (U+0155)
  0x01, 0x56, 0xFF, 0xFE, 0x08, 0x09, 0x08, 0x26, 0xD2, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFE, 0x06, 0x07, 0x07, 0x27, 0x05, // "ŗ" (U+0157)
  0x01, 0x58, 0xFF, 0x01, 0x08, 0x0C, 0x08, 0x27, 0x23, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x27, 0x57, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x27, 0x75, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x27, 0xA0, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x27, 0xC2, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x27, 0xEE, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x07, 0x09, 0x07, 0x28, 0x0D, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x28, 0x3A, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x28, 0x5A, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x28, 0x86, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x08, 0x09, 0x08, 0x28, 0xA5, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x28, 0xCF, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x28, 0xEF, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0A, 0x05, 0x29, 0x18, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x08, 0x09, 0x08, 0x29, 0x38, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x09, 0x05, 0x29, 0x5A, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x29, 0x73, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x29, 0xA7, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x09, 0x0B, 0x09, 0x29, 0xCF, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x07, 0x09, 0x08, 0x29, 0xFF, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x2A, 0x23, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x2A, 0x57, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x2A, 0x7E, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x2A, 0xB5, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x2A, 0xDF, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x2B, 0x14, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFE, 0x09, 0x09, 0x09, 0x2B, 0x40, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x2B, 0x75, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x0D, 0x0C, 0x0D, 0x2B, 0x9D, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x2B, 0xE3, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x09, 0x0C, 0x08, 0x2C, 0x14, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFE, 0x06, 0x0A, 0x07, 0x2C, 0x3E, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x09, 0x0C, 0x08, 0x2C, 0x6C, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x2C, 0x97, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2C, 0xC5, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x2C, 0xE6, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2D, 0x14, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x2D, 0x35, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2D, 0x64, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x06, 0x0A, 0x05, 0x2D, 0x86, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x2D, 0xAF, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x2D, 0xDE, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x07, 0x08, 0x2E, 0x04, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x04, 0x06, 0x2E, 0x22, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0C, 0x04, 0x0C, 0x2E, 0x25, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x09, 0x07, 0x2E, 0x29, // "€" (U+20AC)
  0x20, 0xBF, 0xFF, 0x00, 0x06, 0x0B, 0x07, 0x2E, 0x4A, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x06, 0x03, 0x09, 0x03, 0x2E, 0x79, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x06, 0x03, 0x09, 0x03, 0x2E, 0x81, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0xFF, 0x02, 0x02, 0x03, 0x2E, 0x89, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x06, 0x03, 0x09, 0x03, 0x2E, 0x93, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x06, 0x06, 0x09, 0x06, 0x2E, 0x9B, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x06, 0x06, 0x09, 0x06, 0x2E, 0xA9, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x04, 0x02, 0x06, 0x2E, 0xB6, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x06, 0x06, 0x09, 0x06, 0x2E, 0xC2, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x00, 0x05, 0x0A, 0x06, 0x2E, 0xD0, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x00, 0x06, 0x0A, 0x06, 0x2E, 0xEB, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x04, 0x04, 0x07, 0x05, 0x2F, 0x0E, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x09, 0x02, 0x0B, 0x2F, 0x17, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0F, 0x09, 0x10, 0x2F, 0x23, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x03, 0x06, 0x04, 0x2F, 0x69, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x06, 0x04, 0x2F, 0x75, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x09, 0x01, 0x2F, 0x81, // "⁄" (U+2044)
  0x21, 0x22, 0x01, 0x05, 0x0A, 0x09, 0x0A, 0x2F, 0x98, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x00, 0x0E, 0x09, 0x0F, 0x2F, 0xB5, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x07, 0x0A, 0x08, 0x2F, 0xF5, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x08, 0x0A, 0x09, 0x30, 0x2F, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xA9, 0x01, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x01, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x49, 0x01, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x56, 0x01, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x59, 0x01, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x01, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x76, 0x01, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x01, // aŸ (U+0061 U+0178)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x01, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x01, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x01, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x56, 0x01, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x59, 0x01, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x01, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x76, 0x01, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x01, // hŸ (U+0068 U+0178)
  0x00, 0x6D, 0x00, 0x56, 0x01, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x59, 0x01, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x01, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x76, 0x01, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x01, // mŸ (U+006D U+0178)
  0x00, 0x6E, 0x00, 0x56, 0x01, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x59, 0x01, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x01, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x76, 0x01, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x01, // nŸ (U+006E U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x03, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x03, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x20, 0x1A, 0x03, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x03, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x03, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xA9, 0x01, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x01, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x49, 0x01, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xA9, 0x01, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x01, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x49, 0x01, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xA9, 0x01, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x01, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x49, 0x01, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xA9, 0x01, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x01, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x49, 0x01, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xA9, 0x01, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x01, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x49, 0x01, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xA9, 0x01, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x01, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x49, 0x01, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x56, 0x01, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x59, 0x01, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x01, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x76, 0x01, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x01, // àŸ (U+00E0 U+0178)
  0x00, 0xE1, 0x00, 0x56, 0x01, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x59, 0x01, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x01, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x76, 0x01, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x01, // áŸ (U+00E1 U+0178)
  0x00, 0xE2, 0x00, 0x56, 0x01, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x59, 0x01, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x01, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x76, 0x01, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x01, // âŸ (U+00E2 U+0178)
  0x00, 0xE3, 0x00, 0x56, 0x01, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x59, 0x01, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x01, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x76, 0x01, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x01, // ãŸ (U+00E3 U+0178)
  0x00, 0xE4, 0x00, 0x56, 0x01, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x59, 0x01, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x01, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x76, 0x01, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x01, // äŸ (U+00E4 U+0178)
  0x00, 0xE5, 0x00, 0x56, 0x01, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x59, 0x01, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x01, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x76, 0x01, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x01, // åŸ (U+00E5 U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x01, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x01, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x01, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x56, 0x01, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x59, 0x01, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x01, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x76, 0x01, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x01, // ñŸ (U+00F1 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x56, 0x01, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x59, 0x01, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0xDD, 0x01, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x01, 0x76, 0x01, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x78, 0x01, // ùŸ (U+00F9 U+0178)
  0x00, 0xFA, 0x00, 0x56, 0x01, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x59, 0x01, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0xDD, 0x01, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x01, 0x76, 0x01, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x78, 0x01, // úŸ (U+00FA U+0178)
  0x00, 0xFB, 0x00, 0x56, 0x01, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x59, 0x01, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0xDD, 0x01, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x01, 0x76, 0x01, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x78, 0x01, // ûŸ (U+00FB U+0178)
  0x00, 0xFC, 0x00, 0x56, 0x01, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x59, 0x01, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0xDD, 0x01, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x01, 0x76, 0x01, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x78, 0x01, // üŸ (U+00FC U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xA9, 0x01, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x01, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x49, 0x01, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x56, 0x01, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x59, 0x01, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x01, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x76, 0x01, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x01, // āŸ (U+0101 U+0178)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xA9, 0x01, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x01, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x49, 0x01, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x56, 0x01, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x59, 0x01, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0xDD, 0x01, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x01, 0x76, 0x01, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x78, 0x01, // ăŸ (U+0103 U+0178)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xA9, 0x01, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x01, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x49, 0x01, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x56, 0x01, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x59, 0x01, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x01, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x76, 0x01, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x01, // ąŸ (U+0105 U+0178)
  0x01, 0x07, 0x00, 0x56, 0x01, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x01, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x01, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x56, 0x01, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x01, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x01, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x56, 0x01, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x01, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x01, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x56, 0x01, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x01, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x01, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x56, 0x01, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x59, 0x01, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x01, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x76, 0x01, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x01, // ĥŸ (U+0125 U+0178)
  0x01, 0x27, 0x00, 0x56, 0x01, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x59, 0x01, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x01, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x76, 0x01, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x01, // ħŸ (U+0127 U+0178)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x56, 0x01, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x59, 0x01, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x01, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x76, 0x01, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x01, // ńŸ (U+0144 U+0178)
  0x01, 0x46, 0x00, 0x56, 0x01, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x59, 0x01, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x01, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x76, 0x01, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x01, // ņŸ (U+0146 U+0178)
  0x01, 0x48, 0x00, 0x56, 0x01, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x59, 0x01, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x01, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x76, 0x01, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x01, // ňŸ (U+0148 U+0178)
  0x01, 0x49, 0x00, 0x56, 0x01, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x59, 0x01, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x01, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x76, 0x01, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x01, // ŉŸ (U+0149 U+0178)
  0x01, 0x4B, 0x00, 0x56, 0x01, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x59, 0x01, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x01, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x76, 0x01, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x01, // ŋŸ (U+014B U+0178)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x03, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x03, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x20, 0x1A, 0x03, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x03, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x03, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x03, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x03, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x20, 0x1A, 0x03, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x03, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x03, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x03, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x03, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x20, 0x1A, 0x03, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x03, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x03, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x69, 0x00, 0x56, 0x01, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x59, 0x01, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0xDD, 0x01, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x01, 0x76, 0x01, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x78, 0x01, // ũŸ (U+0169 U+0178)
  0x01, 0x6B, 0x00, 0x56, 0x01, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x59, 0x01, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0xDD, 0x01, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x01, 0x76, 0x01, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x78, 0x01, // ūŸ (U+016B U+0178)
  0x01, 0x6D, 0x00, 0x56, 0x01, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x59, 0x01, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0xDD, 0x01, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x01, 0x76, 0x01, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x78, 0x01, // ŭŸ (U+016D U+0178)
  0x01, 0x6F, 0x00, 0x56, 0x01, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x59, 0x01, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0xDD, 0x01, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x01, 0x76, 0x01, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x78, 0x01, // ůŸ (U+016F U+0178)
  0x01, 0x71, 0x00, 0x56, 0x01, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x59, 0x01, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0xDD, 0x01, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x01, 0x76, 0x01, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x78, 0x01, // űŸ (U+0171 U+0178)
  0x01, 0x73, 0x00, 0x56, 0x01, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x59, 0x01, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0xDD, 0x01, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x01, 0x76, 0x01, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x78, 0x01, // ųŸ (U+0173 U+0178)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x18, 0x90, 0x8F, 0x60, 0xAF, 0x10, 0xCB, 0x20, 0xE0, 0x62, 0x98, 0x21, 0x02, 0xB6, 0x0D, 0x0C,
  0x20, 0xD0, 0xA2,
  // """ (U+0022)
  0x18, 0x96, 0xEB, 0x4F, 0x50, 0xF4, 0x6D, 0x01, 0xC0, 0x77, 0x10,
  // "#" (U+0023)
  0x38, 0x2C, 0x0B, 0x22, 0x82, 0x2A, 0x1C, 0x28, 0x4C, 0xEE, 0xEE, 0x92, 0x82, 0xB1, 0xA2, 0x28,
  0x21, 0xC0, 0xC2, 0x84, 0x8E, 0xEE, 0xED, 0x28, 0x29, 0x47, 0x53, 0x82, 0xC0, 0xB2, 0x28, 0x21,
  0xC0, 0xD3,
  // "$" (U+0024)
  0x40, 0xA4, 0x8A, 0x0A, 0xCE, 0xE5, 0x07, 0xF3, 0x7C, 0x80, 0x8F, 0xB3, 0x12, 0x83, 0x1D, 0xFB,
  0x13, 0x8A, 0x71, 0xDF, 0xB0, 0x59, 0x09, 0x9F, 0x09, 0xE5, 0x6A, 0xB0, 0x2B, 0xEB, 0x81, 0x30,
  0x96, 0x05, 0x40,
  // "%" (U+0025)
  0x28, 0x19, 0xEB, 0x20, 0x30, 0xA3, 0x86, 0x7C, 0x0E, 0x40, 0xC1, 0x38, 0x5D, 0x60, 0xE4, 0x85,
  0x38, 0xB7, 0x1F, 0x32, 0xF5, 0xA8, 0xDA, 0x01, 0xF3, 0x9A, 0xC9, 0xC0, 0xF3, 0x07, 0xDA, 0x95,
  0xD6, 0x0E, 0x43, 0x86, 0x3B, 0x1F, 0x32, 0xF1, 0x38, 0x5C, 0x11, 0xF3, 0x9A, 0x30, 0x80, 0x62,
  0x81, 0x9E, 0xB2,
  // "&" (U+0026)
  0x38, 0x2A, 0xEE, 0xA5, 0x84, 0x7F, 0x33, 0xF3, 0x48, 0x36, 0xF2, 0x4A, 0x58, 0xB0, 0x5F, 0xC3,
  0x0E, 0xE6, 0x0A, 0xE8, 0xF9, 0x3E, 0x20, 0x6F, 0x50, 0xAF, 0xB7, 0x28, 0x68, 0xF3, 0x01, 0xEF,
  0x22, 0x86, 0x5F, 0x80, 0x2D, 0xFA, 0x38, 0x68, 0xED, 0xB3, 0xCF, 0xC1,
  // "'" (U+0027)
  0x19, 0x84, 0xA1, 0xF3, 0x2C, 0x10,
  // "(" (U+0028)
  0x50, 0x13, 0x81, 0x5D, 0x42, 0x81, 0x7F, 0x42, 0x81, 0x4F, 0x83, 0x81, 0xCF, 0x12, 0x81, 0x2F,
  0xB3, 0x81, 0x6F, 0x83, 0x81, 0x7F, 0x63, 0x81, 0x6F, 0x63, 0x81, 0x2F, 0x84, 0x81, 0x8E, 0x14,
  0x04, 0x02, 0x20,
  // ")" (U+0029)
  0x28, 0x13, 0xD3, 0x40, 0xA0, 0xE4, 0x81, 0x6F, 0x53, 0x81, 0x5F, 0x73, 0x81, 0x7F, 0x63, 0x81,
  0xAF, 0x43, 0x00, 0xE3, 0x81, 0x5F, 0x73, 0x0D, 0x0C, 0x28, 0x21, 0xCB, 0x12, 0x00, 0x44,
  // "*" (U+002A)
  0x30, 0x40, 0x22, 0x82, 0xA4, 0xB4, 0x28, 0x91, 0x5C, 0xC9, 0xD1, 0xE8, 0xCB, 0x32, 0x82, 0x78,
  0x77, 0x20, 0x03, 0x20,
  // "+" (U+002B)
  0x20, 0x10, 0xC4, 0x01, 0x0C, 0x40, 0x10, 0xC2, 0x84, 0x3D, 0xDF, 0xDC, 0x20, 0x10, 0xC4, 0x01,
  0x0C, 0x20,
  // "," (U+002C)
  0x18, 0x94, 0x5E, 0x30, 0x3F, 0x60, 0x1D, 0x11, 0x92, 0x10,
  // "-" (U+002D)
  0x82, 0xAD, 0xD5,
  // "." (U+002E)
  0x84, 0x6F, 0x46, 0xE3,
  // "/" (U+002F)
  0x40, 0x50, 0x94, 0x0C, 0x02, 0x30, 0x30, 0xA4, 0x0A, 0x03, 0x30, 0x20, 0xC4, 0x08, 0x05, 0x30,
  0x10, 0xD4, 0x00, 0x74, 0x0D, 0x01, 0x30, 0x50, 0x94, 0x0C, 0x02, 0x40, 0x65,
  // "0" (U+0030)
  0x28, 0x24, 0xDE, 0xA2, 0x87, 0x3F, 0x50, 0xE8, 0x0C, 0xD2, 0x83, 0xCB, 0x2F, 0x82, 0x83, 0xDA,
  0x6F, 0x42, 0x98, 0xA3, 0x97, 0xF2, 0x03, 0xF5, 0x7F, 0x10, 0x8E, 0x04, 0xF4, 0x2E, 0x62, 0x82,
  0x7D, 0xD7, 0x20,
  // "1" (U+0031)
  0x38, 0x95, 0x6E, 0x80, 0x4C, 0xBF, 0x50, 0x34, 0x9F, 0x23, 0x0C, 0x0E, 0x49, 0x0B, 0x38, 0x13,
  0xF8, 0x38, 0x16, 0xF5, 0x38, 0x4A, 0xF2, 0x04, 0xBA, 0x0C, 0x05,
  // "2" (U+0032)
  0x28, 0x41, 0xAE, 0xEB, 0x22, 0x84, 0x8F, 0x23, 0xFA, 0x28, 0x44, 0xB0, 0x2F, 0x85, 0x81, 0x7D,
  0x14, 0x81, 0x4C, 0x14, 0x81, 0x5B, 0x14, 0x07, 0x09, 0x20, 0x72, 0x86, 0x9C, 0x66, 0x8D, 0x01,
  0xD0, 0x91,
  // "3" (U+0033)
  0x28, 0xA1, 0x8D, 0xEB, 0x20, 0x9F, 0x23, 0xF9, 0x04, 0x70, 0x3F, 0x93, 0x82, 0x2C, 0xD1, 0x28,
  0x2C, 0xFD, 0x24, 0x84, 0x2E, 0xE0, 0x32, 0x28, 0x95, 0xCF, 0x1E, 0x90, 0x3F, 0xB0, 0x6D, 0xED,
  0x82,
  // "4" (U+0034)
  0x48, 0x19, 0xF5, 0x38, 0x25, 0xEF, 0x22, 0x82, 0x2A, 0xCE, 0x38, 0x2B, 0x2F, 0xB2, 0x8A, 0x29,
  0x42, 0xF8, 0x05, 0x80, 0x6F, 0x50, 0xCD, 0xDE, 0xFD, 0x53, 0x0D, 0x0E, 0x30, 0x50, 0xEA, 0x0B,
  0x10,
  // "5" (U+0035)
  0x28, 0x6C, 0xDD, 0xEB, 0x02, 0x92, 0x83, 0x27, 0x07, 0x45, 0x83, 0xCC, 0xDB, 0x22, 0x83, 0x20,
  0x2E, 0xC5, 0x83, 0xBF, 0x04, 0x22, 0x89, 0x5D, 0xE0, 0xC8, 0x04, 0xF7, 0x05, 0xDD, 0xD6, 0x20,
  // "6" (U+0036)
  0x28, 0x31, 0x9D, 0xE9, 0x28, 0x7C, 0xA0, 0x8D, 0x08, 0xE1, 0x48, 0xB7, 0xEC, 0xBD, 0x70, 0x3F,
  0x90, 0x8F, 0x25, 0xF4, 0x05, 0xF4, 0x5F, 0x40, 0x7F, 0x21, 0xF7, 0x0D, 0xC2, 0x83, 0x5D, 0xDA,
  0x11,
  // "7" (U+0037)
  0x18, 0x90, 0x6E, 0xDD, 0xEF, 0x40, 0xA2, 0x20, 0xD0, 0xC2, 0x02, 0x28, 0x17, 0xF3, 0x48, 0x11,
  0xF9, 0x58, 0x1A, 0xE1, 0x48, 0x14, 0xF5, 0x50, 0x0C, 0x58, 0x16, 0xF2, 0x48, 0x11, 0xE8, 0x50,
  // "8" (U+0038)
  0x28, 0xB3, 0x8D, 0xDC, 0x20, 0x7F, 0x40, 0xDB, 0x09, 0xF1, 0x0C, 0xA0, 0x4F, 0x96, 0xC1, 0x01,
  0xCA, 0x89, 0x12, 0x03, 0xE6, 0x1D, 0xE0, 0xCD, 0x28, 0x96, 0x6F, 0x3B, 0xE1, 0x0A, 0xE0, 0x1B,
  0xEE, 0xB3, 0x10,
  // "9" (U+0039)
  0x28, 0x27, 0xDD, 0xA2, 0x87, 0x8F, 0x31, 0xF7, 0x0E, 0xB2, 0x89, 0x6E, 0x90, 0xFC, 0x05, 0xF8,
  0x06, 0xDC, 0xAF, 0x54, 0x09, 0x90, 0xF1, 0x28, 0x95, 0xE9, 0x09, 0x70, 0x8E, 0x10, 0x4D, 0xCB,
  0x22,
  // ":" (U+003A)
  0x18, 0x53, 0xE6, 0x04, 0xE6, 0x75, 0x85, 0x4F, 0x60, 0x4E, 0x51,
  // ";" (U+003B)
  0x18, 0x53, 0xE6, 0x04, 0xF6, 0x75, 0x85, 0x4D, 0x30, 0x3F, 0x72, 0x83, 0xD2, 0x09, 0x32,
  // "<" (U+003C)
  0x50, 0x13, 0x81, 0x18, 0xB2, 0x85, 0x7C, 0x60, 0x1D, 0x84, 0x81, 0x5C, 0x75, 0x81, 0x6D, 0x65,
  0x07,
  // "=" (U+003D)
  0x84, 0x3D, 0xDD, 0xDC, 0x75, 0x84, 0x3D, 0xDD, 0xDC,
  // ">" (U+003E)
  0x81, 0x2D, 0x64, 0x82, 0x18, 0xC4, 0x48, 0x11, 0xCB, 0x28, 0x62, 0xAB, 0x20, 0x9C, 0x42, 0x02,
  0x05, 0x40,
  // "?" (U+003F)
  0x8A, 0x02, 0xBD, 0xEA, 0x0B, 0xE1, 0x6F, 0x73, 0x60, 0x5F, 0x72, 0x87, 0x1C, 0xD1, 0x05, 0xD8,
  0x12, 0x09, 0x06, 0x72, 0x81, 0x4F, 0x53, 0x81, 0x5E, 0x43,
  // "@" (U+0040)
  0x38, 0x44, 0xBD, 0xDD, 0x74, 0x81, 0x9D, 0x42, 0x81, 0x1A, 0xA2, 0x8F, 0x66, 0xD1, 0x6D, 0xDA,
  0x1D, 0x30, 0xE4, 0x6F, 0x25, 0xE0, 0x86, 0x4D, 0x0D, 0xA0, 0x7B, 0x07, 0x66, 0xB0, 0xF6, 0x0A,
  0x90, 0xA4, 0x6B, 0x0E, 0x81, 0xD9, 0x1C, 0x04, 0xD0, 0x4C, 0x91, 0xBB, 0x22, 0x0D, 0x05, 0x72,
  0x82, 0x3E, 0x71, 0x20, 0x40, 0xA4, 0x85, 0x29, 0xDD, 0xC8, 0x12,
  // "A" (U+0041)
  0x58, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68, 0x27, 0x6D, 0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94,
  0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30, 0xB0, 0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38,
  0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x60,
  // "B" (U+0042)
  0x20, 0x7A, 0x82, 0xEE, 0xC4, 0x38, 0x4A, 0xF3, 0x2F, 0xE3, 0x0C, 0x92, 0xA3, 0x98, 0x3D, 0x06,
  0xF7, 0x28, 0x44, 0xFE, 0xEF, 0x93, 0x85, 0x7F, 0x70, 0xAF, 0x52, 0x85, 0xAF, 0x30, 0x7F, 0x72,
  0x0E, 0x92, 0x83, 0xCF, 0x32, 0xEA, 0x82, 0xDE, 0xC5, 0x10,
  // "C" (U+0043)
  0x38, 0x44, 0xBD, 0xEB, 0x12, 0x89, 0x17, 0xF6, 0x07, 0xF5, 0x04, 0xF9, 0x20, 0x20, 0x72, 0x81,
  0xCF, 0x25, 0x81, 0x1F, 0xE6, 0x81, 0x3F, 0xC6, 0x81, 0x1F, 0xC7, 0x81, 0xBF, 0x52, 0x08, 0x01,
  0x28, 0x41, 0x9D, 0xEC, 0x62,
  // "D" (U+0044)
  0x20, 0x7A, 0x82, 0xEE, 0xC6, 0x48, 0x5A, 0xF3, 0x0A, 0xF7, 0x30, 0xD9, 0x28, 0x12, 0xFD, 0x39,
  0x0C, 0x3A, 0x28, 0x14, 0xF9, 0x28, 0x11, 0xFD, 0x28, 0x17, 0xF6, 0x28, 0x15, 0xFA, 0x28, 0x1A,
  0xF3, 0x28, 0x1C, 0xF3, 0x28, 0x90, 0xEF, 0x01, 0xAF, 0x70, 0x3E, 0xA8, 0x2D, 0xEB, 0x42,
  // "E" (U+0045)
  0x28, 0x55, 0xEF, 0xCA, 0xDE, 0x38, 0x4A, 0xF3, 0x03, 0xC3, 0x0D, 0x92, 0x01, 0x04, 0x28, 0x11,
  0xFD, 0x68, 0x44, 0xFE, 0xDD, 0x53, 0x81, 0x7F, 0x76, 0x81, 0xAF, 0x42, 0x02, 0x30, 0xD9, 0x28,
  0x31, 0xD0, 0x2C, 0xA8, 0x2A, 0xAD, 0xB1,
  // "F" (U+0046)
  0x20, 0x7A, 0x81, 0xED, 0xE9, 0x38, 0x4A, 0xF3, 0x02, 0xD3, 0x0C, 0x93, 0x04, 0x39, 0x0C, 0x68,
  0x44, 0xFE, 0xDD, 0x63, 0x81, 0x7F, 0x66, 0x81, 0xAF, 0x36, 0x0E, 0x95, 0x02, 0x0E, 0xA0, 0xD4,
  // "G" (U+0047)
  0x38, 0x43, 0xAD, 0xED, 0x63, 0x85, 0x7F, 0x60, 0x1E, 0xD2, 0x81, 0x4F, 0x93, 0x03, 0x01, 0x28,
  0x1C, 0xF2, 0x68, 0x11, 0xFD, 0x28, 0x6C, 0xEE, 0xE1, 0x3F, 0xB3, 0x98, 0x4E, 0x10, 0x1F, 0xC2,
  0x81, 0x1F, 0xB3, 0x85, 0xBF, 0x30, 0x4F, 0x93, 0x85, 0x19, 0xDD, 0xDA, 0x32,
  // "H" (U+0048)
  0x20, 0x7B, 0x08, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x42, 0x81, 0x9F, 0x54, 0x81, 0xCF, 0x12, 0x81,
  0xCF, 0x14, 0x90, 0xD3, 0x90, 0xD4, 0x86, 0x4F, 0xED, 0xDD, 0xFA, 0x48, 0x17, 0xF7, 0x28, 0x16,
  0xF6, 0x48, 0x1A, 0xF3, 0x28, 0x19, 0xF3, 0x40, 0xE9, 0x30, 0xD9, 0x30, 0x20, 0xEA, 0x81, 0xD2,
  0xEA, 0x0D, 0x20,
  // "I" (U+0049)
  0x20, 0x7B, 0x08, 0x38, 0x1A, 0xF4, 0x40, 0xC9, 0x59, 0x0C, 0x48, 0x14, 0xF9, 0x48, 0x17, 0xF6,
  0x48, 0x1A, 0xF3, 0x40, 0xE9, 0x30, 0x20, 0xEA, 0x0D, 0x20,
  // "J" (U+004A)
  0x30, 0x7B, 0x08, 0x48, 0x1A, 0xF4, 0x50, 0xD9, 0x69, 0x0D, 0x58, 0x14, 0xFA, 0x58, 0x17, 0xF6,
  0x58, 0x1A, 0xF3, 0x50, 0xD9, 0x58, 0x11, 0xFD, 0x58, 0x15, 0xF9, 0x58, 0x1C, 0xE2, 0x38, 0x2B,
  0xEB, 0x24,
  // "K" (U+004B)
  0x20, 0x7B, 0x00, 0x8A, 0x09, 0x38, 0x5A, 0xF4, 0x04, 0xD4, 0x48, 0x4C, 0xF0, 0x3B, 0x15, 0x98,
  0x2D, 0x4D, 0x15, 0x81, 0x4F, 0xEA, 0x01, 0x58, 0x47, 0xF7, 0x9F, 0x75, 0x84, 0xAF, 0x33, 0xFE,
  0x50, 0xE9, 0x28, 0x1D, 0xF6, 0x20, 0x20, 0xEA, 0x84, 0xD0, 0x3D, 0xF3, 0x10,
  // "L" (U+004C)
  0x28, 0x35, 0xEF, 0xE6, 0x58, 0x1A, 0xF3, 0x60, 0xD9, 0x68, 0x11, 0xFC, 0x68, 0x14, 0xF9, 0x68,
  0x17, 0xF6, 0x68, 0x1A, 0xF3, 0x20, 0x60, 0x42, 0x0D, 0x93, 0x82, 0xC1, 0x2C, 0xA8, 0x2A, 0xAC,
  0xD1,
  // "M" (U+004D)
  0x20, 0x7A, 0x0E, 0x30, 0x7A, 0x0E, 0x02, 0x38, 0x2A, 0xEF, 0x12, 0x81, 0xDF, 0xE5, 0x87, 0xCA,
  0xF3, 0x07, 0xAF, 0xA5, 0x87, 0xD6, 0xF5, 0x1D, 0x6F, 0x74, 0x89, 0x04, 0xA4, 0xF7, 0x87, 0x8F,
  0x44, 0x86, 0x76, 0x2F, 0xAD, 0x0C, 0x95, 0x0A, 0x03, 0x1A, 0x82, 0x60, 0xFD, 0x50, 0xE2, 0x84,
  0xED, 0x04, 0xFA, 0x38, 0x62, 0xEF, 0xB0, 0xC5, 0x7B, 0x07, 0x20,
  // "N" (U+004E)
  0x20, 0x7A, 0x06, 0x20, 0x9A, 0x04, 0x38, 0x1A, 0xFD, 0x30, 0xD0, 0x14, 0x85, 0xCA, 0xF5, 0x01,
  0xD5, 0x85, 0xD2, 0xFC, 0x04, 0x94, 0x86, 0x49, 0x0A, 0xF3, 0x76, 0x48, 0x67, 0x60, 0x3F, 0xAA,
  0x34, 0x0A, 0x03, 0x28, 0x1B, 0xFE, 0x50, 0xE3, 0x81, 0x4F, 0xC3, 0x82, 0x2E, 0xFB, 0x30, 0xC0,
  0x93,
  // "O" (U+004F)
  0x38, 0x34, 0xCD, 0xE9, 0x48, 0x58, 0xF5, 0x03, 0xFA, 0x28, 0x14, 0xF8, 0x38, 0x5D, 0xF1, 0x0C,
  0xF1, 0x38, 0x4C, 0xF2, 0x1F, 0xD4, 0x84, 0xEF, 0x03, 0xFB, 0x38, 0x52, 0xFA, 0x02, 0xFC, 0x38,
  0x19, 0xF3, 0x28, 0x5B, 0xF3, 0x05, 0xF7, 0x38, 0x41, 0x9E, 0xDC, 0x43,
  // "P" (U+0050)
  0x20, 0x7A, 0x82, 0xEE, 0xA1, 0x38, 0x4A, 0xF4, 0x4F, 0xB3, 0x81, 0xCF, 0x11, 0xA3, 0x98, 0x3D,
  0x01, 0xFD, 0x28, 0x54, 0xFA, 0x09, 0xF7, 0x28, 0x47, 0xFE, 0xDC, 0x73, 0x81, 0xAF, 0x46, 0x0E,
  0x95, 0x02, 0x0E, 0xA0, 0xE0, 0x23,
  // "Q" (U+0051)
  0x38, 0x34, 0xCD, 0xE9, 0x48, 0x57, 0xF5, 0x04, 0xFA, 0x28, 0x14, 0xF8, 0x30, 0xD9, 0x28, 0x1B,
  0xF2, 0x38, 0x4C, 0xF2, 0x1F, 0xD4, 0x84, 0xEF, 0x03, 0xFB, 0x38, 0x52, 0xFB, 0x02, 0xFB, 0x38,
  0x17, 0xF4, 0x28, 0x5C, 0xE1, 0x02, 0xE8, 0x38, 0x42, 0xCD, 0xAD, 0x76, 0x81, 0xBF, 0x47, 0x81,
  0x7F, 0x77, 0x18, 0x1A, 0xE9, 0x30,
  // "R" (U+0052)
  0x20, 0x7A, 0x82, 0xEE, 0xD6, 0x48, 0x5A, 0xF3, 0x0E, 0xF1, 0x30, 0xC9, 0x28, 0x1D, 0xF2, 0x39,
  0x83, 0xC0, 0x5F, 0xA3, 0x84, 0x4F, 0xEE, 0xF6, 0x48, 0x47, 0xF5, 0x7F, 0x74, 0x84, 0xAF, 0x23,
  0xFC, 0x40, 0xE9, 0x28, 0x4D, 0xF3, 0x02, 0xEA, 0x83, 0xE2, 0x4D, 0xE1,
  // "S" (U+0053)
  0x28, 0x37, 0xCC, 0xD7, 0x28, 0x94, 0x5F, 0x30, 0xAF, 0x10, 0x9F, 0x30, 0x33, 0x28, 0x26, 0xFD,
  0x55, 0x0A, 0xA0, 0x95, 0x85, 0x5E, 0xF4, 0x07, 0xB2, 0x8A, 0x06, 0xF5, 0x0B, 0xF2, 0x06, 0xE2,
  0x02, 0xBD, 0xBB, 0x32,
  // "T" (U+0054)
  0x18, 0x1B, 0xED, 0xA8, 0xA3, 0xDF, 0xB0, 0xD1, 0x2F, 0xC0, 0x58, 0x15, 0x05, 0xF8, 0x02, 0x33,
  0x81, 0x8F, 0x56, 0x81, 0xBF, 0x26, 0x00, 0xE6, 0x81, 0x2F, 0xB6, 0x81, 0x6F, 0x85, 0x09, 0xB0,
  0x63,
  // "U" (U+0055)
  0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22, 0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F,
  0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81, 0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20,
  0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84, 0x1A, 0xED, 0xB3, 0x30,
  // "V" (U+0056)
  0x0D, 0xA8, 0x1E, 0x08, 0xA8, 0x26, 0x1F, 0xE3, 0x0C, 0x04, 0x20, 0xE9, 0x20, 0x40, 0xA3, 0x84,
  0xCF, 0x10, 0xC2, 0x38, 0x3A, 0xF3, 0x59, 0x48, 0x38, 0xF5, 0xD1, 0x48, 0x26, 0xFB, 0x75, 0x81,
  0x4F, 0xE6, 0x81, 0x2F, 0x65,
  // "W" (U+0057)
  0x0D, 0xA0, 0xE2, 0x89, 0x0B, 0x60, 0x2E, 0xFD, 0x1F, 0xD2, 0x81, 0x3F, 0x92, 0x06, 0x0B, 0x29,
  0x0E, 0x28, 0x1B, 0xFB, 0x20, 0xC0, 0x32, 0x89, 0x0D, 0xF0, 0x3C, 0xED, 0x03, 0xB3, 0x89, 0x0C,
  0xF0, 0xA5, 0xCF, 0x0A, 0x43, 0x87, 0xBF, 0x4C, 0x0A, 0xF4, 0xC4, 0x87, 0x9F, 0xC5, 0x08, 0xFB,
  0x54, 0x81, 0x8F, 0xC2, 0x81, 0x6F, 0xD5, 0x81, 0x7F, 0x52, 0x81, 0x3F, 0x64,
  // "X" (U+0058)
  0x20, 0x7B, 0x06, 0x04, 0xA0, 0x73, 0x81, 0x8F, 0xA2, 0x0D, 0x03, 0x48, 0x41, 0xFE, 0x1A, 0x46,
  0x82, 0xAF, 0xD5, 0x78, 0x15, 0xFD, 0x78, 0x32, 0xBC, 0xF4, 0x58, 0x42, 0xB1, 0x5F, 0xB4, 0x81,
  0x2D, 0x12, 0xA0, 0x32, 0x06, 0xA8, 0x18, 0x0C, 0xB0, 0x11,
  // "Y" (U+0059)
  0x0D, 0xA8, 0x1D, 0x0A, 0xA8, 0x25, 0x1F, 0xE3, 0x0D, 0x04, 0x28, 0x4B, 0xF2, 0x07, 0x73, 0x83,
  0x7F, 0x62, 0xB4, 0x83, 0x2F, 0xAB, 0x15, 0x81, 0xDF, 0x56, 0x00, 0xE6, 0x81, 0x3F, 0xC5, 0x08,
  0xB0, 0xB4,
  // "Z" (U+005A)
  0x29, 0x81, 0xDC, 0xCA, 0x82, 0x50, 0x4B, 0x28, 0x18, 0xFA, 0x28, 0x44, 0x40, 0x5F, 0xD5, 0x82,
  0x2E, 0xE2, 0x58, 0x1D, 0xF5, 0x58, 0x1A, 0xF8, 0x58, 0x17, 0xFB, 0x28, 0x54, 0x30, 0x3F, 0xD1,
  0x28, 0x7C, 0x30, 0xDF, 0xDC, 0xCE, 0x92,
  // "[" (U+005B)
  0x20, 0x9A, 0x0A, 0x28, 0x1B, 0xF2, 0x30, 0xE0, 0xD3, 0x81, 0x2F, 0xA3, 0x81, 0x5F, 0x73, 0x81,
  0x8F, 0x43, 0x81, 0xBF, 0x13, 0x00, 0xE3, 0x81, 0x1F, 0xB3, 0x81, 0x4F, 0x83, 0x81, 0x7F, 0x63,
  0x82, 0x9E, 0xE8, 0x20,
  // "\" (U+005C)
  0x8A, 0x6A, 0x29, 0x38, 0x47, 0x57, 0x66, 0x65, 0x74, 0x83, 0x92, 0xA1, 0xB0, 0x50,
  // "]" (U+005D)
  0x28, 0x26, 0xEF, 0xD3, 0x81, 0x3F, 0xA3, 0x81, 0x5F, 0x73, 0x81, 0x8F, 0x43, 0x81, 0xBF, 0x13,
  0x0E, 0x0D, 0x38, 0x11, 0xFA, 0x38, 0x14, 0xF7, 0x38, 0x17, 0xF5, 0x38, 0x1B, 0xF2, 0x28, 0x11,
  0xEE, 0x28, 0x27, 0xEE, 0xB2,
  // "^" (U+005E)
  0x20, 0x20, 0xC4, 0x81, 0x8D, 0x33, 0x81, 0xC3, 0xA2, 0x89, 0x36, 0x70, 0xC1, 0x0C, 0x10, 0x67,
  0x3A, 0x30, 0xD0,
  // "_" (U+005F)
  0x80, 0x1D, 0x08,
  // "`" (U+0060)
  0x81, 0x1D, 0xB2, 0x81, 0x1C, 0x30,
  // "a" (U+0061)
  0x28, 0x93, 0x5D, 0xDB, 0xD1, 0x06, 0xF5, 0x0D, 0xE2, 0x8B, 0x4E, 0xC0, 0x1F, 0xB0, 0x5F, 0x70,
  0x4F, 0x80, 0x7F, 0x50, 0x9F, 0x50, 0x5F, 0x63, 0xCF, 0x42, 0x85, 0xCD, 0x84, 0xEC, 0x40,
  // "b" (U+0062)
  0x18, 0x1D, 0xFE, 0x48, 0x11, 0xFB, 0x48, 0x14, 0xF8, 0x48, 0xA5, 0x7F, 0x7C, 0xE5, 0x0A, 0xF8,
  0x0E, 0xD0, 0xDF, 0x10, 0xDF, 0x0F, 0xB2, 0x98, 0xA3, 0xC3, 0xF8, 0x04, 0xF6, 0x7F, 0x61, 0xDC,
  0x0A, 0xAD, 0xEA, 0x11,
  // "c" (U+0063)
  0x28, 0xA4, 0x6D, 0xEB, 0x10, 0x7F, 0x35, 0xF4, 0x1E, 0xA0, 0x15, 0x05, 0xF6, 0x48, 0x17, 0xF5,
  0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB, 0x11,
  // "d" (U+0064)
  0x48, 0x22, 0xEF, 0xA5, 0x81, 0x5F, 0x75, 0x81, 0x7F, 0x42, 0x89, 0x36, 0xDD, 0xDF, 0x10, 0x6F,
  0x50, 0xEE, 0x28, 0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x06,
  0xF6, 0x3C, 0xF4, 0x28, 0x5C, 0xE8, 0x4E, 0xC4,
  // "e" (U+0065)
  0x28, 0xB3, 0x5C, 0xEC, 0x10, 0x6F, 0x26, 0xF4, 0x1E, 0x92, 0xCD, 0x16, 0xFE, 0xD9, 0x10, 0x7F,
  0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1, 0x10,
  // "f" (U+0066)
  0x48, 0x31, 0xAD, 0xE5, 0x48, 0x39, 0xF2, 0xB8, 0x40, 0xE0, 0xD5, 0x84, 0x2C, 0xFE, 0xD2, 0x48,
  0x15, 0xF7, 0x68, 0x18, 0xF3, 0x68, 0x1B, 0xF1, 0x60, 0xE0, 0xD6, 0x81, 0x2F, 0xA6, 0x81, 0x5F,
  0x76, 0x81, 0x9F, 0x35, 0x81, 0x1E, 0xB5, 0x82, 0x8E, 0x91, 0x50,
  // "g" (U+0067)
  0x38, 0x47, 0xDE, 0x8C, 0x52, 0x85, 0x7E, 0x19, 0xE2, 0x12, 0x82, 0xDA, 0x09, 0x94, 0x83, 0xCA,
  0x1E, 0x94, 0x82, 0x6F, 0xD9, 0x48, 0x13, 0xE3, 0x60, 0x2B, 0x0C, 0x04, 0x28, 0x52, 0xB7, 0x57,
  0xEB, 0x20, 0xA0, 0xD2, 0x81, 0x1E, 0x72, 0x84, 0x3C, 0xED, 0xC7, 0x30,
  // "h" (U+0068)
  0x18, 0x1D, 0xFE, 0x58, 0x11, 0xFB, 0x58, 0x14, 0xF8, 0x58, 0x47, 0xF7, 0xBE, 0x82, 0x84, 0xAF,
  0xA0, 0xFD, 0x28, 0x4D, 0xF2, 0x1F, 0xC2, 0x98, 0xB4, 0xC0, 0x4F, 0x90, 0x3F, 0x80, 0x7F, 0x60,
  0x7F, 0x50, 0x8F, 0x40, 0xAF, 0x20, 0x4E, 0xC4,
  // "i" (U+0069)
  0x20, 0xC0, 0xB2, 0x0B, 0x08, 0x40, 0x3A, 0x89, 0x28, 0x08, 0xF5, 0x0A, 0xF2, 0x0D, 0xE2, 0x98,
  0x3B, 0x02, 0xFA, 0x28, 0x1C, 0xE8,
  // "j" (U+006A)
  0x40, 0xC0, 0xB4, 0x0B, 0x08, 0x71, 0x03, 0xA0, 0x83, 0x81, 0x8F, 0x53, 0x81, 0xAF, 0x23, 0x0D,
  0x0E, 0x38, 0x11, 0xFB, 0x38, 0x14, 0xF8, 0x38, 0x17, 0xF5, 0x38, 0x1B, 0xF1, 0x28, 0x11, 0xFB,
  0x28, 0x27, 0xEB, 0x12,
  // "k" (U+006B)
  0x18, 0x1D, 0xFE, 0x58, 0x11, 0xFB, 0x58, 0x14, 0xF8, 0x58, 0x27, 0xF5, 0x6A, 0x86, 0x80, 0xAF,
  0x23, 0xD3, 0x28, 0x3D, 0xE3, 0xC1, 0x39, 0x0F, 0xE3, 0x84, 0x3F, 0x98, 0xF6, 0x28, 0x95, 0x7F,
  0x52, 0xFD, 0x10, 0xAF, 0x20, 0x7E, 0xB1,
  // "l" (U+006C)
  0x18, 0xC5, 0xDF, 0xE0, 0x2F, 0xB0, 0x4F, 0x80, 0x7F, 0x50, 0xAF, 0x20, 0xDE, 0x01, 0xFB, 0x04,
  0xF8, 0x05, 0xF7, 0x02, 0xDD, 0x60,
  // "m" (U+006D)
  0x03, 0xA8, 0x68, 0x9E, 0x92, 0xCE, 0x52, 0x89, 0x08, 0xFC, 0x3E, 0xF8, 0x6F, 0xA2, 0x81, 0xAF,
  0x51, 0xA8, 0x21, 0x4F, 0x82, 0x8D, 0x5D, 0xF0, 0x2F, 0xA0, 0x7F, 0x50, 0x1F, 0xB0, 0x5F, 0x70,
  0xAF, 0x20, 0x4F, 0x80, 0x8F, 0x40, 0xCF, 0x10, 0x7F, 0x50, 0xAF, 0x20, 0x7F, 0xC2,
  // "n" (U+006E)
  0x03, 0xA8, 0x27, 0xAE, 0xA2, 0x89, 0x48, 0xFC, 0x0D, 0xF1, 0x0A, 0xF5, 0x0E, 0xE2, 0x8B, 0x5D,
  0xE0, 0x1F, 0xC0, 0x1F, 0xB0, 0x4F, 0x90, 0x4F, 0x80, 0x5F, 0x70, 0x7F, 0x50, 0x2D, 0xD6,
  // "o" (U+006F)
  0x28, 0x95, 0x6D, 0xEB, 0x20, 0x7F, 0x41, 0xFB, 0x1F, 0xB2, 0x83, 0xED, 0x5F, 0x72, 0x98, 0xA3,
  0xC7, 0xF5, 0x04, 0xF8, 0x4F, 0x70, 0xCD, 0x10, 0x8E, 0xDA, 0x11,
  // "p" (U+0070)
  0x10, 0x6A, 0x82, 0x4B, 0xE5, 0x28, 0x4A, 0xE8, 0x0E, 0xD2, 0x84, 0xDF, 0x10, 0xDE, 0x29, 0x0B,
  0x28, 0x97, 0xEC, 0x03, 0xF8, 0x04, 0xF7, 0x07, 0xF6, 0x0C, 0xD2, 0x84, 0xAF, 0xDE, 0xB1, 0x20,
  0xD0, 0xE6, 0x90, 0xB5, 0x04, 0xA0, 0xA4,
  // "q" (U+0071)
  0x28, 0x93, 0x5D, 0xDB, 0xD2, 0x06, 0xF5, 0x0E, 0xE2, 0x8C, 0x3E, 0xC0, 0x1F, 0xB0, 0x5F, 0x70,
  0x4F, 0x80, 0x7F, 0x50, 0x9F, 0x40, 0x6F, 0x63, 0xCF, 0x10, 0x1C, 0xE8, 0xAE, 0x60, 0xD0, 0xB5,
  0x81, 0x1F, 0x85, 0x04, 0xA0, 0x71,
  // "r" (U+0072)
  0x03, 0xA8, 0x97, 0x6A, 0xE7, 0x07, 0xFB, 0x1C, 0x80, 0xAF, 0x60, 0x12, 0x0D, 0x95, 0x90, 0xC4,
  0x81, 0x4F, 0x84, 0x81, 0x7F, 0x54,
  // "s" (U+0073)
  0x18, 0x96, 0x4C, 0xCE, 0x60, 0xE9, 0x0A, 0xB0, 0xEE, 0x51, 0x28, 0xA4, 0x4E, 0xFC, 0x01, 0x31,
  0xAF, 0x5B, 0xA0, 0x3F, 0x35, 0xDC, 0xC6, 0x10,
  // "t" (U+0074)
  0x30, 0x62, 0x89, 0x32, 0xAB, 0x02, 0xEF, 0xED, 0x07, 0xF5, 0x28, 0x1A, 0xF2, 0x20, 0xD0, 0xE2,
  0x81, 0x1F, 0xB2, 0x81, 0x2F, 0xA3, 0x82, 0xBE, 0xA2,
  // "u" (U+0075)
  0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50, 0xAF, 0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0,
  0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F, 0xC5, 0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "v" (U+0076)
  0x89, 0x6A, 0xFB, 0x01, 0xD6, 0x0D, 0xD0, 0x1C, 0x90, 0xB9, 0x28, 0x95, 0x76, 0x08, 0xF2, 0x0B,
  0x10, 0x6F, 0x45, 0x72, 0x82, 0x4F, 0x8B, 0x38, 0x22, 0xFE, 0x24, 0x04, 0x01, 0x30,
  // "w" (U+0077)
  0x06, 0xA2, 0x89, 0x1B, 0xF0, 0x4E, 0x10, 0xBF, 0x01, 0xA1, 0x89, 0x31, 0xF2, 0x09, 0xF0, 0x7B,
  0xF1, 0x0D, 0x28, 0x79, 0xF1, 0xB7, 0xF2, 0x57, 0x28, 0x69, 0xF6, 0x66, 0xF3, 0xB3, 0x86, 0x8F,
  0xB0, 0x6F, 0xC3, 0x38, 0x58, 0xF4, 0x06, 0xF7, 0x30,
  // "x" (U+0078)
  0x28, 0x5E, 0xF7, 0x07, 0xE2, 0x28, 0x41, 0xFC, 0x2C, 0x14, 0x82, 0xAF, 0xB2, 0x58, 0x15, 0xF9,
  0x58, 0x21, 0xBD, 0xE4, 0x84, 0x1C, 0x47, 0xF7, 0x28, 0x32, 0xE8, 0x02, 0xA0, 0x51,
  // "y" (U+0079)
  0x28, 0x5E, 0xF9, 0x02, 0xE6, 0x28, 0x51, 0xFD, 0x01, 0xB9, 0x38, 0x4C, 0xF1, 0x0A, 0x53, 0x83,
  0x8F, 0x40, 0xC4, 0x83, 0x4F, 0x77, 0x55, 0x90, 0xC0, 0xB6, 0x81, 0xBE, 0x26, 0x0C, 0x06, 0x58,
  0x12, 0xC8, 0x48, 0x2C, 0xDC, 0x55,
  // "z" (U+007A)
  0x18, 0x1D, 0xED, 0xA8, 0x54, 0x2B, 0x05, 0xFA, 0x38, 0x11, 0xED, 0x48, 0x1C, 0xF3, 0x38, 0xA1,
  0x8F, 0x70, 0x30, 0x4F, 0xB0, 0x1C, 0x0D, 0xFD, 0xDE, 0x91,
  // "{" (U+007B)
  0x38, 0x28, 0xEE, 0x22, 0x81, 0x3F, 0xB4, 0x81, 0x7F, 0x74, 0x81, 0xAF, 0x33, 0x81, 0x2E, 0xD3,
  0x82, 0x6F, 0xD1, 0x48, 0x17, 0xF7, 0x48, 0x16, 0xF7, 0x48, 0x19, 0xF4, 0x48, 0x1B, 0xF1, 0x48,
  0x1C, 0xF1, 0x48, 0x15, 0xDE, 0x30,
  // "|" (U+007C)
  0x8B, 0x01, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC0,
  // "}" (U+007D)
  0x28, 0x26, 0xFD, 0x23, 0x81, 0x6F, 0x63, 0x81, 0x8F, 0x43, 0x81, 0xCF, 0x13, 0x81, 0xDF, 0x13,
  0x05, 0xA2, 0x81, 0x2F, 0xA3, 0x81, 0x8F, 0x43, 0x81, 0xBF, 0x23, 0x00, 0xE3, 0x81, 0x3F, 0xA2,
  0x82, 0x7E, 0xB2, 0x20,
  // "~" (U+007E)
  0x18, 0xA1, 0xAC, 0x20, 0xB1, 0x39, 0x3C, 0x1D, 0x05, 0x60, 0x5D, 0x61,
  // "¡" (U+00A1)
  0x28, 0x4D, 0x90, 0x1E, 0x96, 0x0C, 0x20, 0x40, 0xB2, 0x0A, 0x09, 0x28, 0x90, 0xE8, 0x05, 0xF6,
  0x0A, 0xF4, 0x10,
  // "¢" (U+00A2)
  0x40, 0x70, 0x43, 0x8A, 0x03, 0xCF, 0xE8, 0x02, 0xE9, 0xAA, 0xB0, 0xBF, 0x2A, 0x12, 0x98, 0x1B,
  0x37, 0x28, 0x32, 0xFA, 0x74, 0x38, 0x3E, 0xDB, 0x19, 0x28, 0x32, 0xBF, 0xD6, 0x30, 0x10, 0xA3,
  // "£" (U+00A3)
  0x28, 0x32, 0xBD, 0xE6, 0x28, 0x96, 0xDA, 0x0B, 0xE0, 0x2F, 0x50, 0x43, 0x03, 0xF6, 0x38, 0x44,
  0xDF, 0xED, 0x63, 0x90, 0x84, 0x81, 0x2F, 0x44, 0x81, 0xBA, 0x32, 0x86, 0x1A, 0xAA, 0xDE, 0xA3,
  // "¤" (U+00A4)
  0x02, 0x38, 0xB0, 0x2B, 0xCD, 0xBC, 0x77, 0x06, 0x89, 0x20, 0x2A, 0x78, 0x07, 0x8B, 0xAD, 0xAC,
  0x40, 0x10,
  // "¥" (U+00A5)
  0x18, 0x94, 0xDF, 0xE4, 0xCF, 0x90, 0x2F, 0x80, 0x69, 0x38, 0x2D, 0xB1, 0xA4, 0x82, 0x9E, 0xA1,
  0x28, 0x41, 0xDE, 0xFE, 0xD4, 0x81, 0x8F, 0x33, 0x05, 0x0D, 0xA0, 0xD0, 0xA4, 0x0E, 0x0D, 0x40,
  0x50, 0xEA, 0x0C, 0x30,
  // "¦" (U+00A6)
  0x89, 0x01, 0xC1, 0xC1, 0xC1, 0xC1, 0xC6, 0x89, 0x01, 0xC1, 0xC1, 0xC1, 0xC1, 0xC0,
  // "§" (U+00A7)
  0x28, 0xA0, 0x3C, 0xEC, 0x10, 0x1E, 0x40, 0xD6, 0x02, 0xF3, 0x03, 0x28, 0x22, 0xFE, 0x53, 0x83,
  0xD3, 0x9F, 0xA2, 0x98, 0x91, 0x70, 0x4F, 0x10, 0x6F, 0xC7, 0xB3, 0x85, 0x2B, 0xF1, 0x04, 0x42,
  0x98, 0x53, 0x0A, 0xB0, 0x3E, 0x28, 0x32, 0xBD, 0xB3, 0x20,
  // "¨" (U+00A8)
  0x89, 0x09, 0x51, 0xB1, 0xB6, 0x2D, 0x20,
  // "©" (U+00A9)
  0x28, 0x42, 0x9D, 0xDA, 0x33, 0x81, 0x2D, 0x42, 0x81, 0x3C, 0x42, 0x8A, 0x5C, 0x24, 0xCD, 0x81,
  0xC0, 0x2A, 0x1E, 0x20, 0x90, 0x84, 0x48, 0x5B, 0x48, 0x45, 0x64, 0x85, 0xB4, 0x8A, 0x35, 0x62,
  0xA1, 0xE3, 0x05, 0x08, 0x40, 0xB2, 0x5C, 0xD7, 0x1C, 0x28, 0x12, 0xD4, 0x28, 0x13, 0xC4, 0x38,
  0x42, 0x9D, 0xDA, 0x32,
  // "ª" (U+00AA)
  0x8A, 0x21, 0xA9, 0xD4, 0xB8, 0x2F, 0x1F, 0x57, 0xD0, 0xCB, 0x5E, 0x50,
  // "«" (U+00AB)
  0x28, 0x97, 0x69, 0x2C, 0x10, 0x7D, 0x3E, 0x50, 0x3F, 0x5C, 0xC3, 0x82, 0xC8, 0x6E, 0x38, 0x33,
  0xC0, 0xC3, 0x10,
  // "¬" (U+00AC)
  0x03, 0x80, 0x1D, 0x50, 0xD5, 0x0D, 0x50, 0x50,
  // "®" (U+00AE)
  0x28, 0x42, 0x9D, 0xDA, 0x33, 0x81, 0x2D, 0x42, 0x81, 0x3C, 0x42, 0x8F, 0x0C, 0x4B, 0xA9, 0x41,
  0xC0, 0x2A, 0x07, 0x70, 0xE0, 0x84, 0x48, 0x07, 0x70, 0xE0, 0x56, 0x48, 0x07, 0xBD, 0x40, 0x56,
  0x2A, 0x07, 0x77, 0x90, 0x84, 0x0B, 0x49, 0x91, 0x96, 0xC2, 0x81, 0x2D, 0x42, 0x81, 0x3C, 0x43,
  0x84, 0x29, 0xDD, 0xA3, 0x20,
  // "¯" (U+00AF)
  0x84, 0x9D, 0xDD, 0xDC,
  // "°" (U+00B0)
  0x18, 0xA0, 0xAD, 0x70, 0x68, 0x0C, 0x26, 0x80, 0xD2, 0x0A, 0xD7, 0x10,
  // "±" (U+00B1)
  0x20, 0x10, 0xC4, 0x01, 0x0C, 0x40, 0x10, 0xC2, 0x84, 0x3D, 0xDF, 0xDC, 0x20, 0x10, 0xC4, 0x01,
  0x0C, 0x71, 0x84, 0x3D, 0xDD, 0xDC,
  // "²" (U+00B2)
  0x28, 0x18, 0x98, 0x28, 0x33, 0xC1, 0xF2, 0x30, 0x60, 0xB3, 0x81, 0x4B, 0x12, 0x89, 0x07, 0x80,
  0x60, 0x3F, 0xEE, 0x91,
  // "³" (U+00B3)
  0x18, 0xB2, 0x7A, 0x80, 0x2D, 0x0F, 0x30, 0x14, 0xE1, 0x06, 0xD5, 0x06, 0x05, 0xE0, 0xAA, 0xA3,
  0x10,
  // "´" (U+00B4)
  0x18, 0x48, 0xE4, 0x5C, 0x21,
  // "µ" (U+00B5)
  0x18, 0xA3, 0x3F, 0x90, 0x6F, 0x60, 0x6F, 0x50, 0x9F, 0x30, 0x9F, 0x20, 0xC9, 0x20, 0xD0, 0xE2,
  0x90, 0xC2, 0x98, 0xA6, 0xC0, 0x4F, 0x90, 0x4F, 0xD2, 0xBF, 0x92, 0x79, 0xDC, 0x2D, 0xE7, 0xB3,
  0x60, 0xE0, 0x76, 0x0D, 0x0C, 0x60,
  // "¶" (U+00B6)
  0x18, 0x69, 0xEF, 0xEE, 0xF4, 0x2B, 0x83, 0x4A, 0x30, 0x3B, 0x81, 0x4A, 0x22, 0x0E, 0xA8, 0x14,
  0xA2, 0x28, 0x44, 0xBD, 0x4A, 0x24, 0x82, 0x84, 0xA2, 0x48, 0x28, 0x4A, 0x24, 0x82, 0x84, 0xA2,
  0x48, 0x28, 0x4A, 0x24, 0x82, 0xA4, 0xA4, 0x38, 0x49, 0xE4, 0x9E, 0x40,
  // "·" (U+00B7)
  0x82, 0xCD, 0xCB,
  // "¸" (U+00B8)
  0x10, 0x70, 0x92, 0x84, 0x1E, 0x48, 0xD9, 0x10,
  // "¹" (U+00B9)
  0x28, 0x93, 0x21, 0x18, 0xF4, 0x03, 0xF1, 0x05, 0xD2, 0x85, 0x99, 0x07, 0xBA, 0x30,
  // "º" (U+00BA)
  0x18, 0xA4, 0x2B, 0xAC, 0x10, 0xC8, 0x0F, 0x51, 0xF4, 0x3F, 0x10, 0x9C, 0xB4, 0x10,
  // "»" (U+00BB)
  0x18, 0x29, 0x62, 0xC2, 0x8A, 0x44, 0xE1, 0xD7, 0x02, 0xF6, 0xBD, 0x0A, 0xA4, 0xE3, 0x69, 0x1C,
  0x21,
  // "¼" (U+00BC)
  0x20, 0x20, 0x12, 0x06, 0x08, 0x28, 0x51, 0x8F, 0x40, 0x2C, 0x48, 0x43, 0xF1, 0x0B, 0x34, 0x83,
  0x5D, 0x07, 0x85, 0x82, 0x99, 0x2C, 0x38, 0x53, 0x07, 0xBA, 0xF3, 0x20, 0xB0, 0xC3, 0x07, 0x08,
  0x28, 0x18, 0xB9, 0x20, 0x30, 0xC2, 0x82, 0x74, 0xB6, 0x28, 0x7C, 0x30, 0x2B, 0xAF, 0xB1, 0x68,
  0x19, 0xB5, 0x10,
  // "½" (U+00BD)
  0x20, 0x20, 0x12, 0x06, 0x08, 0x28, 0x51, 0x8F, 0x40, 0x2C, 0x48, 0x43, 0xF1, 0x0B, 0x34, 0x86,
  0x5D, 0x07, 0x88, 0x98, 0x28, 0x94, 0x99, 0x2C, 0x3C, 0x1F, 0x27, 0xBA, 0xF3, 0x20, 0x60, 0xB3,
  0x07, 0x08, 0x28, 0x14, 0xB1, 0x20, 0x30, 0xC2, 0x82, 0x78, 0x06, 0x28, 0x6C, 0x30, 0x3F, 0xEE,
  0x91,
  // "¾" (U+00BE)
  0x18, 0x17, 0xA8, 0x38, 0x91, 0x68, 0x02, 0xD0, 0xF3, 0x02, 0xC3, 0x85, 0x14, 0xE1, 0x0B, 0x33,
  0x84, 0x6D, 0x50, 0x78, 0x38, 0x46, 0x05, 0xE2, 0xC2, 0x89, 0x13, 0x0A, 0xAA, 0x4C, 0x30, 0xBC,
  0x48, 0x47, 0x80, 0x8B, 0x93, 0x85, 0x3C, 0x07, 0x4B, 0x63, 0x86, 0xC3, 0x2B, 0xAF, 0xB1, 0x68,
  0x19, 0xB5, 0x10,
  // "¿" (U+00BF)
  0x30, 0xA0, 0xD4, 0x0B, 0x0D, 0x73, 0x0C, 0x03, 0x28, 0x64, 0xBB, 0x10, 0x6F, 0x73, 0x89, 0x7D,
  0xE0, 0x18, 0x1D, 0xF1, 0x7F, 0x43, 0xBC, 0xB7, 0x10,
  // "À" (U+00C0)
  0x48, 0x11, 0xDB, 0x71, 0x81, 0x1C, 0x37, 0x73, 0x81, 0x5F, 0xA7, 0x81, 0xBE, 0xC6, 0x82, 0x76,
  0xDE, 0x58, 0x21, 0xC0, 0xB9, 0x58, 0x49, 0x40, 0xAF, 0x33, 0x85, 0x3E, 0xCC, 0xDF, 0x53, 0x0B,
  0x03, 0x28, 0x16, 0xF7, 0x20, 0x50, 0xD3, 0x83, 0x5F, 0xA0, 0x7A, 0x81, 0x80, 0x6B, 0x06,
  // "Á" (U+00C1)
  0x78, 0x18, 0xE4, 0x68, 0x15, 0xC2, 0x77, 0x28, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68, 0x27, 0x6D,
  0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94, 0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30, 0xB0,
  0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38, 0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x60,
  // "Â" (U+00C2)
  0x58, 0x15, 0xFD, 0x68, 0x34, 0xC2, 0x96, 0x77, 0x28, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68, 0x27,
  0x6D, 0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94, 0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30,
  0xB0, 0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38, 0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x60,
  // "Ã" (U+00C3)
  0x58, 0x2B, 0xB3, 0xA5, 0x83, 0x63, 0x6D, 0x67, 0x72, 0x81, 0x5F, 0xA7, 0x81, 0xBE, 0xC6, 0x82,
  0x76, 0xDE, 0x58, 0x21, 0xC0, 0xB9, 0x58, 0x49, 0x40, 0xAF, 0x33, 0x85, 0x3E, 0xCC, 0xDF, 0x53,
  0x0B, 0x03, 0x28, 0x16, 0xF7, 0x20, 0x50, 0xD3, 0x83, 0x5F, 0xA0, 0x7A, 0x81, 0x80, 0x6B, 0x06,
  // "Ä" (U+00C4)
  0x58, 0x39, 0x51, 0xB1, 0x58, 0x3B, 0x62, 0xD2, 0x77, 0x18, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68,
  0x27, 0x6D, 0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94, 0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5,
  0x30, 0xB0, 0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38, 0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0,
  0x60,
  // "Å" (U+00C5)
  0x58, 0x21, 0xCC, 0x26, 0x82, 0x57, 0x57, 0x60, 0x6A, 0x02, 0x68, 0x1B, 0xEC, 0x68, 0x27, 0x6D,
  0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94, 0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30, 0xB0,
  0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38, 0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x60,
  // "Æ" (U+00C6)
  0x60, 0xDA, 0x83, 0xED, 0xEF, 0x16, 0x85, 0xA9, 0xF6, 0x01, 0xE6, 0x83, 0x74, 0xBF, 0x32, 0x05,
  0x58, 0x23, 0x80, 0xE9, 0x72, 0x81, 0xA0, 0x2A, 0x81, 0xDD, 0x75, 0x84, 0x9D, 0xDE, 0xF9, 0x70,
  0x50, 0x72, 0x81, 0x8F, 0x62, 0x04, 0x02, 0x20, 0x20, 0xD3, 0x81, 0xBF, 0x32, 0x87, 0xD1, 0x05,
  0xEF, 0x60, 0xBA, 0x82, 0xAA, 0xDD, 0x20,
  // "Ç" (U+00C7)
  0x38, 0x44, 0xBD, 0xEB, 0x12, 0x89, 0x17, 0xF6, 0x07, 0xF5, 0x04, 0xF9, 0x20, 0x20, 0x72, 0x81,
  0xCF, 0x25, 0x81, 0x1F, 0xE6, 0x81, 0x3F, 0xC6, 0x81, 0x1F, 0xC7, 0x81, 0xBF, 0x52, 0x08, 0x01,
  0x28, 0x41, 0x9D, 0xEC, 0x65, 0x07, 0x09, 0x78, 0x11, 0xE4, 0x58, 0x18, 0xD9, 0x40,
  // "È" (U+00C8)
  0x38, 0x11, 0xDB, 0x78, 0x11, 0xC3, 0x76, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30, 0x3C,
  0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7, 0x68,
  0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "É" (U+00C9)
  0x68, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x75, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30, 0x3C,
  0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7, 0x68,
  0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "Ê" (U+00CA)
  0x58, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x74, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30,
  0x3C, 0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7,
  0x68, 0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "Ë" (U+00CB)
  0x48, 0x39, 0x51, 0xB1, 0x48, 0x3B, 0x62, 0xD2, 0x74, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF,
  0x30, 0x3C, 0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17,
  0xF7, 0x68, 0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "Ì" (U+00CC)
  0x28, 0x11, 0xDB, 0x58, 0x11, 0xC3, 0x73, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x44, 0x0C, 0x95, 0x90,
  0xC4, 0x81, 0x4F, 0x94, 0x81, 0x7F, 0x64, 0x81, 0xAF, 0x34, 0x0E, 0x93, 0x02, 0x0E, 0xA0, 0xD2,
  // "Í" (U+00CD)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x74, 0x07, 0xB0, 0x84, 0x81, 0xAF, 0x45, 0x0C, 0x96, 0x90,
  0xC5, 0x81, 0x4F, 0x95, 0x81, 0x7F, 0x65, 0x81, 0xAF, 0x35, 0x0E, 0x94, 0x02, 0x0E, 0xA0, 0xD3,
  // "Î" (U+00CE)
  0x38, 0x15, 0xFD, 0x38, 0x34, 0xC2, 0x96, 0x72, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x44, 0x0C, 0x95,
  0x90, 0xC4, 0x81, 0x4F, 0x94, 0x81, 0x7F, 0x64, 0x81, 0xAF, 0x34, 0x0E, 0x93, 0x02, 0x0E, 0xA0,
  0xD2,
  // "Ï" (U+00CF)
  0x38, 0x39, 0x51, 0xB1, 0x38, 0x3B, 0x62, 0xD2, 0x73, 0x07, 0xB0, 0x84, 0x81, 0xAF, 0x45, 0x0C,
  0x96, 0x90, 0xC5, 0x81, 0x4F, 0x95, 0x81, 0x7F, 0x65, 0x81, 0xAF, 0x35, 0x0E, 0x94, 0x02, 0x0E,
  0xA0, 0xD3,
  // "Ð" (U+00D0)
  0x20, 0x7A, 0x82, 0xEE, 0xC6, 0x48, 0x5A, 0xF3, 0x0A, 0xF7, 0x30, 0xC9, 0x28, 0x12, 0xFD, 0x39,
  0x0D, 0x3A, 0x18, 0x73, 0xEF, 0xED, 0x21, 0xFD, 0x28, 0x16, 0xF7, 0x28, 0x15, 0xFA, 0x28, 0x1A,
  0xF3, 0x28, 0x1C, 0xF3, 0x28, 0x90, 0xEF, 0x01, 0xAF, 0x70, 0x3E, 0xA8, 0x2D, 0xEB, 0x42,
  // "Ñ" (U+00D1)
  0x68, 0x2B, 0xB3, 0xA7, 0x83, 0x63, 0x6D, 0x67, 0x72, 0x07, 0xA0, 0x62, 0x09, 0xA0, 0x43, 0x81,
  0xAF, 0xD3, 0x0D, 0x01, 0x48, 0x5C, 0xAF, 0x50, 0x1D, 0x58, 0x5D, 0x2F, 0xC0, 0x49, 0x48, 0x64,
  0x90, 0xAF, 0x37, 0x64, 0x86, 0x76, 0x03, 0xFA, 0xA3, 0x40, 0xA0, 0x32, 0x81, 0xBF, 0xE5, 0x0E,
  0x38, 0x14, 0xFC, 0x38, 0x22, 0xEF, 0xB3, 0x0C, 0x09, 0x30,
  // "Ò" (U+00D2)
  0x38, 0x11, 0xDB, 0x71, 0x81, 0x1C, 0x37, 0x72, 0x83, 0x4C, 0xDE, 0x94, 0x85, 0x8F, 0x50, 0x3F,
  0xA2, 0x81, 0x4F, 0x83, 0x85, 0xDF, 0x10, 0xCF, 0x13, 0x84, 0xCF, 0x21, 0xFD, 0x48, 0x4E, 0xF0,
  0x3F, 0xB3, 0x85, 0x2F, 0xA0, 0x2F, 0xC3, 0x81, 0x9F, 0x32, 0x85, 0xBF, 0x30, 0x5F, 0x73, 0x84,
  0x19, 0xED, 0xC4, 0x30,
  // "Ó" (U+00D3)
  0x68, 0x18, 0xE4, 0x68, 0x15, 0xC2, 0x77, 0x18, 0x34, 0xCD, 0xE9, 0x48, 0x58, 0xF5, 0x03, 0xFA,
  0x28, 0x14, 0xF8, 0x38, 0x5D, 0xF1, 0x0C, 0xF1, 0x38, 0x4C, 0xF2, 0x1F, 0xD4, 0x84, 0xEF, 0x03,
  0xFB, 0x38, 0x52, 0xFA, 0x02, 0xFC, 0x38, 0x19, 0xF3, 0x28, 0x5B, 0xF3, 0x05, 0xF7, 0x38, 0x41,
  0x9E, 0xDC, 0x43,
  // "Ô" (U+00D4)
  0x48, 0x15, 0xFD, 0x68, 0x34, 0xC2, 0x96, 0x77, 0x18, 0x34, 0xCD, 0xE9, 0x48, 0x58, 0xF5, 0x03,
  0xFA, 0x28, 0x14, 0xF8, 0x38, 0x5D, 0xF1, 0x0C, 0xF1, 0x38, 0x4C, 0xF2, 0x1F, 0xD4, 0x84, 0xEF,
  0x03, 0xFB, 0x38, 0x52, 0xFA, 0x02, 0xFC, 0x38, 0x19, 0xF3, 0x28, 0x5B, 0xF3, 0x05, 0xF7, 0x38,
  0x41, 0x9E, 0xDC, 0x43,
  // "Õ" (U+00D5)
  0x48, 0x2B, 0xB3, 0xA5, 0x83, 0x63, 0x6D, 0x67, 0x71, 0x83, 0x4C, 0xDE, 0x94, 0x85, 0x8F, 0x50,
  0x3F, 0xA2, 0x81, 0x4F, 0x83, 0x85, 0xDF, 0x10, 0xCF, 0x13, 0x84, 0xCF, 0x21, 0xFD, 0x48, 0x4E,
  0xF0, 0x3F, 0xB3, 0x85, 0x2F, 0xA0, 0x2F, 0xC3, 0x81, 0x9F, 0x32, 0x85, 0xBF, 0x30, 0x5F, 0x73,
  0x84, 0x19, 0xED, 0xC4, 0x30,
  // "Ö" (U+00D6)
  0x48, 0x39, 0x51, 0xB1, 0x58, 0x3B, 0x62, 0xD2, 0x77, 0x83, 0x4C, 0xDE, 0x94, 0x85, 0x8F, 0x50,
  0x3F, 0xA2, 0x81, 0x4F, 0x83, 0x85, 0xDF, 0x10, 0xCF, 0x13, 0x84, 0xCF, 0x21, 0xFD, 0x48, 0x4E,
  0xF0, 0x3F, 0xB3, 0x85, 0x2F, 0xA0, 0x2F, 0xC3, 0x81, 0x9F, 0x32, 0x85, 0xBF, 0x30, 0x5F, 0x73,
  0x84, 0x19, 0xED, 0xC4, 0x30,
  // "×" (U+00D7)
  0x06, 0x28, 0xA4, 0x24, 0x7B, 0x2D, 0x30, 0x8F, 0x30, 0x2D, 0x8B, 0x0B, 0x30, 0x77,
  // "Ø" (U+00D8)
  0x70, 0x10, 0xB4, 0x84, 0x4C, 0xDE, 0xB5, 0x38, 0x58, 0xF5, 0x06, 0xF9, 0x28, 0x15, 0xF8, 0x28,
  0xC4, 0xBD, 0xF1, 0x0C, 0xF1, 0x09, 0x3C, 0xF2, 0x1F, 0xD0, 0x66, 0x0E, 0xF0, 0x3F, 0xB3, 0xA0,
  0x2F, 0xB0, 0x2F, 0xCB, 0x28, 0x19, 0xF3, 0x28, 0x5A, 0xF5, 0x05, 0xF7, 0x38, 0x46, 0xBE, 0xDC,
  0x44, 0x06, 0x71,
  // "Ù" (U+00D9)
  0x28, 0x11, 0xDB, 0x78, 0x11, 0xC3, 0x75, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22, 0x05,
  0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81, 0x9F,
  0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84, 0x1A,
  0xED, 0xB3, 0x30,
  // "Ú" (U+00DA)
  0x58, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x74, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22, 0x05,
  0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81, 0x9F,
  0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84, 0x1A,
  0xED, 0xB3, 0x30,
  // "Û" (U+00DB)
  0x48, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x73, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22,
  0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81,
  0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84,
  0x1A, 0xED, 0xB3, 0x30,
  // "Ü" (U+00DC)
  0x38, 0x39, 0x51, 0xB1, 0x48, 0x3B, 0x62, 0xD2, 0x73, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF,
  0x22, 0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2,
  0x81, 0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12,
  0x84, 0x1A, 0xED, 0xB3, 0x30,
  // "Ý" (U+00DD)
  0x48, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x75, 0x0D, 0xA8, 0x1D, 0x0A, 0xA8, 0x25, 0x1F, 0xE3, 0x0D,
  0x04, 0x28, 0x4B, 0xF2, 0x07, 0x73, 0x83, 0x7F, 0x62, 0xB4, 0x83, 0x2F, 0xAB, 0x15, 0x81, 0xDF,
  0x56, 0x00, 0xE6, 0x81, 0x3F, 0xC5, 0x08, 0xB0, 0xB4,
  // "Þ" (U+00DE)
  0x20, 0x7A, 0x0E, 0x08, 0x58, 0x3A, 0xFE, 0xC6, 0x48, 0x4D, 0xE0, 0xAF, 0x53, 0x98, 0x3B, 0x05,
  0xF9, 0x28, 0x54, 0xF8, 0x06, 0xF8, 0x28, 0x57, 0xF5, 0x1D, 0xF2, 0x28, 0x4A, 0xFD, 0xDB, 0x33,
  0x0E, 0x95, 0x02, 0x0E, 0xA0, 0xD4,
  // "ß" (U+00DF)
  0x58, 0x39, 0xDD, 0xC3, 0x48, 0x4A, 0xF3, 0x0E, 0xC3, 0x81, 0x1F, 0xC2, 0x0C, 0x0D, 0x28, 0x63,
  0xEF, 0x85, 0xDA, 0x63, 0x83, 0x7F, 0x5E, 0xB5, 0x84, 0xAF, 0x2E, 0xE4, 0x48, 0x5D, 0xE0, 0x3E,
  0xF5, 0x28, 0x61, 0xFB, 0x32, 0x2F, 0xB2, 0x86, 0x4F, 0x8C, 0x91, 0xF9, 0x28, 0x67, 0xF5, 0x6E,
  0xEA, 0x12, 0x81, 0xBF, 0x16, 0x81, 0x2F, 0xA6, 0x81, 0x8E, 0x97,
  // "à" (U+00E0)
  0x28, 0x11, 0xDB, 0x68, 0x11, 0xC3, 0x75, 0x89, 0x35, 0xDD, 0xBD, 0x10, 0x6F, 0x50, 0xDE, 0x28,
  0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x05, 0xF6, 0x3C, 0xF4,
  0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "á" (U+00E1)
  0x48, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x75, 0x89, 0x35, 0xDD, 0xBD, 0x10, 0x6F, 0x50, 0xDE, 0x28,
  0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x05, 0xF6, 0x3C, 0xF4,
  0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "â" (U+00E2)
  0x38, 0x15, 0xFD, 0x48, 0x34, 0xC2, 0x96, 0x74, 0x89, 0x35, 0xDD, 0xBD, 0x10, 0x6F, 0x50, 0xDE,
  0x28, 0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x05, 0xF6, 0x3C,
  0xF4, 0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "ã" (U+00E3)
  0x38, 0x2B, 0xB3, 0xA3, 0x83, 0x63, 0x6D, 0x67, 0x48, 0x93, 0x5D, 0xDB, 0xD1, 0x06, 0xF5, 0x0D,
  0xE2, 0x8B, 0x4E, 0xC0, 0x1F, 0xB0, 0x5F, 0x70, 0x4F, 0x80, 0x7F, 0x50, 0x9F, 0x50, 0x5F, 0x63,
  0xCF, 0x42, 0x85, 0xCD, 0x84, 0xEC, 0x40,
  // "ä" (U+00E4)
  0x28, 0x39, 0x51, 0xB1, 0x38, 0x3B, 0x62, 0xD2, 0x74, 0x89, 0x35, 0xDD, 0xBD, 0x10, 0x6F, 0x50,
  0xDE, 0x28, 0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x05, 0xF6,
  0x3C, 0xF4, 0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "å" (U+00E5)
  0x38, 0x21, 0xCC, 0x24, 0x82, 0x57, 0x57, 0x48, 0x21, 0xCC, 0x23, 0x89, 0x35, 0xDD, 0xBD, 0x10,
  0x6F, 0x50, 0xDE, 0x28, 0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5,
  0x05, 0xF6, 0x3C, 0xF4, 0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "æ" (U+00E6)
  0x28, 0xA5, 0x5D, 0xD9, 0x4B, 0xED, 0x20, 0x6F, 0x50, 0xAF, 0x44, 0xF7, 0x0E, 0xC2, 0x8A, 0x6E,
  0xB1, 0xBE, 0x25, 0xF7, 0x04, 0xFE, 0xDA, 0x20, 0x7F, 0x50, 0x9F, 0x74, 0x89, 0x05, 0xF6, 0x38,
  0xFB, 0x01, 0x62, 0x87, 0xCE, 0x70, 0x6D, 0xEB, 0x21,
  // "ç" (U+00E7)
  0x28, 0xA4, 0x6D, 0xEB, 0x10, 0x7F, 0x35, 0xF4, 0x1E, 0xA0, 0x15, 0x05, 0xF6, 0x48, 0x17, 0xF5,
  0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xEB, 0x13, 0x07, 0x09, 0x58, 0x11, 0xE4, 0x38, 0x18,
  0xD9, 0x30,
  // "è" (U+00E8)
  0x28, 0x11, 0xDB, 0x58, 0x11, 0xC3, 0x73, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41, 0xE9,
  0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB, 0x11,
  // "é" (U+00E9)
  0x48, 0x18, 0xE4, 0x38, 0x15, 0xC2, 0x73, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41, 0xE9,
  0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB, 0x11,
  // "ê" (U+00EA)
  0x38, 0x15, 0xFD, 0x38, 0x34, 0xC2, 0x96, 0x72, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41,
  0xE9, 0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB,
  0x11,
  // "ë" (U+00EB)
  0x28, 0x39, 0x51, 0xB1, 0x28, 0x3B, 0x62, 0xD2, 0x72, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F,
  0x41, 0xE9, 0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E,
  0xDB, 0x11,
  // "ì" (U+00EC)
  0x81, 0x1D, 0xB2, 0x81, 0x1C, 0x34, 0x03, 0xA8, 0x92, 0x80, 0x8F, 0x50, 0xAF, 0x20, 0xDE, 0x29,
  0x83, 0xB0, 0x2F, 0xA2, 0x81, 0xCE, 0x80,
  // "í" (U+00ED)
  0x38, 0x18, 0xE4, 0x28, 0x15, 0xC2, 0x70, 0x3A, 0x08, 0x38, 0x18, 0xF5, 0x38, 0x1A, 0xF2, 0x30,
  0xD0, 0xE4, 0x90, 0xB3, 0x81, 0x2F, 0xA4, 0x81, 0xCE, 0x82,
  // "î" (U+00EE)
  0x18, 0x75, 0xFD, 0x04, 0xC2, 0x96, 0x50, 0x3A, 0x08, 0x28, 0x18, 0xF5, 0x28, 0x1A, 0xF2, 0x20,
  0xD0, 0xE3, 0x90, 0xB2, 0x81, 0x2F, 0xA3, 0x81, 0xCE, 0x81,
  // "ï" (U+00EF)
  0x89, 0x09, 0x51, 0xB1, 0xB6, 0x2D, 0x25, 0x03, 0xA0, 0x82, 0x81, 0x8F, 0x52, 0x81, 0xAF, 0x22,
  0x0D, 0x0E, 0x39, 0x0B, 0x28, 0x12, 0xFA, 0x38, 0x1C, 0xE8, 0x10,
  // "ð" (U+00F0)
  0x20, 0x16, 0x83, 0x4D, 0x7A, 0x52, 0x82, 0x2B, 0xDA, 0x38, 0x33, 0x23, 0xF3, 0x28, 0x95, 0x8D,
  0xDF, 0x90, 0x9F, 0x22, 0xFC, 0x2F, 0x92, 0x83, 0xED, 0x6F, 0x52, 0x98, 0x94, 0xB7, 0xF4, 0x04,
  0xF6, 0x3F, 0x70, 0xBD, 0x28, 0x37, 0xED, 0xA1, 0x10,
  // "ñ" (U+00F1)
  0x38, 0x2B, 0xB3, 0xA3, 0x83, 0x63, 0x6D, 0x67, 0x20, 0x3A, 0x82, 0x7A, 0xEA, 0x28, 0x94, 0x8F,
  0xC0, 0xDF, 0x10, 0xAF, 0x50, 0xEE, 0x28, 0xB5, 0xDE, 0x01, 0xFC, 0x01, 0xFB, 0x04, 0xF9, 0x04,
  0xF8, 0x05, 0xF7, 0x07, 0xF5, 0x02, 0xDD, 0x60,
  // "ò" (U+00F2)
  0x28, 0x11, 0xDB, 0x58, 0x11, 0xC3, 0x73, 0x89, 0x56, 0xDE, 0xB2, 0x07, 0xF4, 0x1F, 0xB1, 0xFB,
  0x28, 0x3E, 0xD5, 0xF7, 0x29, 0x8A, 0x3C, 0x7F, 0x50, 0x4F, 0x84, 0xF7, 0x0C, 0xD1, 0x08, 0xED,
  0xA1, 0x10,
  // "ó" (U+00F3)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x74, 0x83, 0x6D, 0xEB, 0x22, 0x89, 0x07, 0xF4, 0x1F, 0xB0,
  0x1F, 0xB2, 0x84, 0xED, 0x05, 0xF7, 0x29, 0x89, 0x7C, 0x07, 0xF5, 0x04, 0xF8, 0x04, 0xF7, 0x0C,
  0xD1, 0x28, 0x38, 0xED, 0xA1, 0x20,
  // "ô" (U+00F4)
  0x38, 0x15, 0xFD, 0x38, 0x34, 0xC2, 0x96, 0x72, 0x89, 0x56, 0xDE, 0xB2, 0x07, 0xF4, 0x1F, 0xB1,
  0xFB, 0x28, 0x3E, 0xD5, 0xF7, 0x29, 0x8A, 0x3C, 0x7F, 0x50, 0x4F, 0x84, 0xF7, 0x0C, 0xD1, 0x08,
  0xED, 0xA1, 0x10,
  // "õ" (U+00F5)
  0x38, 0x2B, 0xB3, 0xA2, 0x83, 0x63, 0x6D, 0x67, 0x28, 0x95, 0x6D, 0xEB, 0x20, 0x7F, 0x41, 0xFB,
  0x1F, 0xB2, 0x83, 0xED, 0x5F, 0x72, 0x98, 0xA3, 0xC7, 0xF5, 0x04, 0xF8, 0x4F, 0x70, 0xCD, 0x10,
  0x8E, 0xDA, 0x11,
  // "ö" (U+00F6)
  0x28, 0x39, 0x51, 0xB1, 0x28, 0x3B, 0x62, 0xD2, 0x72, 0x89, 0x56, 0xDE, 0xB2, 0x07, 0xF4, 0x1F,
  0xB1, 0xFB, 0x28, 0x3E, 0xD5, 0xF7, 0x29, 0x8A, 0x3C, 0x7F, 0x50, 0x4F, 0x84, 0xF7, 0x0C, 0xD1,
  0x08, 0xED, 0xA1, 0x10,
  // "÷" (U+00F7)
  0x20, 0x20, 0xA4, 0x03, 0x0D, 0x71, 0x84, 0x3D, 0xDD, 0xDC, 0x71, 0x02, 0x0A, 0x40, 0x30, 0xD2,
  // "ø" (U+00F8)
  0x60, 0x62, 0x8D, 0x76, 0xDE, 0xD6, 0x07, 0xF4, 0x4F, 0xA1, 0xFB, 0x1B, 0xED, 0x5F, 0x7A, 0x3F,
  0xC7, 0xFC, 0x54, 0xF8, 0x4F, 0xA0, 0xCD, 0x12, 0xDE, 0xEA, 0x20, 0x41, 0x50,
  // "ù" (U+00F9)
  0x28, 0x11, 0xDB, 0x68, 0x11, 0xC3, 0x73, 0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50, 0xAF,
  0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0, 0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F, 0xC5,
  0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "ú" (U+00FA)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x72, 0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50, 0xAF,
  0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0, 0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F, 0xC5,
  0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "û" (U+00FB)
  0x38, 0x15, 0xFD, 0x48, 0x34, 0xC2, 0x96, 0x72, 0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50,
  0xAF, 0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0, 0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F,
  0xC5, 0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "ü" (U+00FC)
  0x38, 0x39, 0x51, 0xB1, 0x38, 0x3B, 0x62, 0xD2, 0x71, 0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F,
  0x50, 0xAF, 0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0, 0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90,
  0x2F, 0xC5, 0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "ý" (U+00FD)
  0x68, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x75, 0x85, 0xEF, 0x90, 0x2E, 0x62, 0x85, 0x1F, 0xD0, 0x1B,
  0x93, 0x84, 0xCF, 0x10, 0xA5, 0x38, 0x38, 0xF4, 0x0C, 0x48, 0x34, 0xF7, 0x75, 0x59, 0x0C, 0x0B,
  0x68, 0x1B, 0xE2, 0x60, 0xC0, 0x65, 0x81, 0x2C, 0x84, 0x82, 0xCD, 0xC5, 0x50,
  // "þ" (U+00FE)
  0x28, 0x1D, 0xFE, 0x58, 0x11, 0xFB, 0x58, 0x14, 0xF8, 0x58, 0x47, 0xF7, 0xBE, 0x52, 0x84, 0xAF,
  0x80, 0xED, 0x28, 0x90, 0xDF, 0x10, 0xDE, 0x01, 0xFB, 0x28, 0x97, 0xEC, 0x04, 0xF8, 0x04, 0xF7,
  0x07, 0xF6, 0x0C, 0xD2, 0x84, 0xAF, 0xDE, 0xB1, 0x20, 0xD0, 0xE5, 0x81, 0x1F, 0xB5, 0x04, 0xA0,
  0xA4,
  // "ÿ" (U+00FF)
  0x48, 0x39, 0x51, 0xB1, 0x48, 0x3B, 0x62, 0xD2, 0x74, 0x85, 0xEF, 0x90, 0x2E, 0x62, 0x85, 0x1F,
  0xD0, 0x1B, 0x93, 0x84, 0xCF, 0x10, 0xA5, 0x38, 0x38, 0xF4, 0x0C, 0x48, 0x34, 0xF7, 0x75, 0x59,
  0x0C, 0x0B, 0x68, 0x1B, 0xE2, 0x60, 0xC0, 0x65, 0x81, 0x2C, 0x84, 0x82, 0xCD, 0xC5, 0x50,
  // "Ā" (U+0100)
  0x58, 0x27, 0xDD, 0xC7, 0x72, 0x81, 0x5F, 0xA7, 0x81, 0xBE, 0xC6, 0x82, 0x76, 0xDE, 0x58, 0x21,
  0xC0, 0xB9, 0x58, 0x49, 0x40, 0xAF, 0x33, 0x85, 0x3E, 0xCC, 0xDF, 0x53, 0x0B, 0x03, 0x28, 0x16,
  0xF7, 0x20, 0x50, 0xD3, 0x83, 0x5F, 0xA0, 0x7A, 0x81, 0x80, 0x6B, 0x06,
  // "ā" (U+0101)
  0x28, 0x27, 0xDD, 0xC7, 0x58, 0x93, 0x5D, 0xDB, 0xD1, 0x06, 0xF5, 0x0D, 0xE2, 0x8B, 0x4E, 0xC0,
  0x1F, 0xB0, 0x5F, 0x70, 0x4F, 0x80, 0x7F, 0x50, 0x9F, 0x50, 0x5F, 0x63, 0xCF, 0x42, 0x85, 0xCD,
  0x84, 0xEC, 0x40,
  // "Ă" (U+0102)
  0x48, 0x32, 0xB0, 0x84, 0x68, 0x19, 0xD7, 0x77, 0x38, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68, 0x27,
  0x6D, 0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94, 0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30,
  0xB0, 0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38, 0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x60,
  // "ă" (U+0103)
  0x28, 0x32, 0xB0, 0x84, 0x48, 0x19, 0xD7, 0x75, 0x89, 0x35, 0xDD, 0xBD, 0x10, 0x6F, 0x50, 0xDE,
  0x28, 0xB4, 0xEC, 0x01, 0xFB, 0x05, 0xF7, 0x04, 0xF8, 0x07, 0xF5, 0x09, 0xF5, 0x05, 0xF6, 0x3C,
  0xF4, 0x28, 0x5C, 0xD8, 0x4E, 0xC4,
  // "Ą" (U+0104)
  0x58, 0x15, 0xFA, 0x78, 0x1B, 0xEC, 0x68, 0x27, 0x6D, 0xE5, 0x82, 0x1C, 0x0B, 0x95, 0x84, 0x94,
  0x0A, 0xF3, 0x38, 0x53, 0xEC, 0xCD, 0xF5, 0x30, 0xB0, 0x32, 0x81, 0x6F, 0x72, 0x05, 0x0D, 0x38,
  0x35, 0xFA, 0x07, 0xA8, 0x18, 0x06, 0xB0, 0x65, 0x81, 0x1B, 0x47, 0x07, 0x0D, 0x71, 0x82, 0x3D,
  0xD1, 0x10,
  // "ą" (U+0105)
  0x28, 0x93, 0x5D, 0xDB, 0xD1, 0x06, 0xF5, 0x0D, 0xE2, 0x8B, 0x4E, 0xC0, 0x1F, 0xB0, 0x5F, 0x70,
  0x4F, 0x80, 0x7F, 0x50, 0x9F, 0x50, 0x5F, 0x63, 0xCF, 0x42, 0x85, 0xCD, 0x84, 0xFC, 0x43, 0x81,
  0x1B, 0x45, 0x07, 0x0D, 0x68, 0x23, 0xDD, 0x11,
  // "Ć" (U+0106)
  0x68, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x76, 0x84, 0x4B, 0xDE, 0xB1, 0x28, 0x91, 0x7F, 0x60, 0x7F,
  0x50, 0x4F, 0x92, 0x02, 0x07, 0x28, 0x1C, 0xF2, 0x58, 0x11, 0xFE, 0x68, 0x13, 0xFC, 0x68, 0x11,
  0xFC, 0x78, 0x1B, 0xF5, 0x20, 0x80, 0x12, 0x84, 0x19, 0xDE, 0xC6, 0x20,
  // "ć" (U+0107)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x74, 0x83, 0x6D, 0xEB, 0x12, 0x89, 0x37, 0xF3, 0x5F, 0x40,
  0x1E, 0xA0, 0x15, 0x28, 0x15, 0xF6, 0x58, 0x17, 0xF5, 0x58, 0x44, 0xF9, 0x02, 0x53, 0x83, 0x7E,
  0xDB, 0x12,
  // "Ĉ" (U+0108)
  0x48, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x76, 0x84, 0x4B, 0xDE, 0xB1, 0x28, 0x91, 0x7F, 0x60,
  0x7F, 0x50, 0x4F, 0x92, 0x02, 0x07, 0x28, 0x1C, 0xF2, 0x58, 0x11, 0xFE, 0x68, 0x13, 0xFC, 0x68,
  0x11, 0xFC, 0x78, 0x1B, 0xF5, 0x20, 0x80, 0x12, 0x84, 0x19, 0xDE, 0xC6, 0x20,
  // "ĉ" (U+0109)
  0x38, 0x15, 0xFD, 0x38, 0x34, 0xC2, 0x96, 0x72, 0x8A, 0x46, 0xDE, 0xB1, 0x07, 0xF3, 0x5F, 0x41,
  0xEA, 0x01, 0x50, 0x5F, 0x64, 0x81, 0x7F, 0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1,
  0x10,
  // "Ċ" (U+010A)
  0x58, 0x12, 0xB6, 0x68, 0x14, 0xE6, 0x76, 0x84, 0x4B, 0xDE, 0xB1, 0x28, 0x91, 0x7F, 0x60, 0x7F,
  0x50, 0x4F, 0x92, 0x02, 0x07, 0x28, 0x1C, 0xF2, 0x58, 0x11, 0xFE, 0x68, 0x13, 0xFC, 0x68, 0x11,
  0xFC, 0x78, 0x1B, 0xF5, 0x20, 0x80, 0x12, 0x84, 0x19, 0xDE, 0xC6, 0x20,
  // "ċ" (U+010B)
  0x38, 0x12, 0xB6, 0x48, 0x14, 0xE6, 0x73, 0x8A, 0x46, 0xDE, 0xB1, 0x07, 0xF3, 0x5F, 0x41, 0xEA,
  0x01, 0x50, 0x5F, 0x64, 0x81, 0x7F, 0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1, 0x10,
  // "Č" (U+010C)
  0x48, 0x31, 0xD2, 0x89, 0x58, 0x19, 0xFA, 0x76, 0x84, 0x4B, 0xDE, 0xB1, 0x28, 0x91, 0x7F, 0x60,
  0x7F, 0x50, 0x4F, 0x92, 0x02, 0x07, 0x28, 0x1C, 0xF2, 0x58, 0x11, 0xFE, 0x68, 0x13, 0xFC, 0x68,
  0x11, 0xFC, 0x78, 0x1B, 0xF5, 0x20, 0x80, 0x12, 0x84, 0x19, 0xDE, 0xC6, 0x20,
  // "č" (U+010D)
  0x28, 0x31, 0xD2, 0x89, 0x38, 0x19, 0xFA, 0x73, 0x8A, 0x46, 0xDE, 0xB1, 0x07, 0xF3, 0x5F, 0x41,
  0xEA, 0x01, 0x50, 0x5F, 0x64, 0x81, 0x7F, 0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1,
  0x10,
  // "Ď" (U+010E)
  0x48, 0x31, 0xD2, 0x89, 0x68, 0x19, 0xFA, 0x77, 0x07, 0xA8, 0x2E, 0xEC, 0x64, 0x85, 0xAF, 0x30,
  0xAF, 0x73, 0x0D, 0x92, 0x81, 0x2F, 0xD3, 0x90, 0xC3, 0xA2, 0x81, 0x4F, 0x92, 0x81, 0x1F, 0xD2,
  0x81, 0x7F, 0x62, 0x81, 0x5F, 0xA2, 0x81, 0xAF, 0x32, 0x81, 0xCF, 0x32, 0x89, 0x0E, 0xF0, 0x1A,
  0xF7, 0x03, 0xEA, 0x82, 0xDE, 0xB4, 0x20,
  // "ď" (U+010F)
  0x48, 0x52, 0xEF, 0xA5, 0xE1, 0x58, 0x35, 0xF7, 0xA5, 0x68, 0x27, 0xF4, 0x34, 0x84, 0x6D, 0xDD,
  0xF1, 0x48, 0x46, 0xF5, 0x0E, 0xE5, 0x84, 0xEC, 0x01, 0xFB, 0x48, 0x55, 0xF7, 0x04, 0xF8, 0x48,
  0x57, 0xF5, 0x09, 0xF5, 0x48, 0x56, 0xF6, 0x3C, 0xF4, 0x58, 0x5C, 0xE8, 0x4E, 0xC4, 0x30,
  // "Đ" (U+0110)
  0x20, 0x7A, 0x82, 0xEE, 0xC6, 0x48, 0x5A, 0xF3, 0x0A, 0xF7, 0x30, 0xC9, 0x28, 0x12, 0xFD, 0x39,
  0x0D, 0x3A, 0x18, 0x73, 0xEF, 0xED, 0x21, 0xFD, 0x28, 0x16, 0xF7, 0x28, 0x15, 0xFA, 0x28, 0x1A,
  0xF3, 0x28, 0x1C, 0xF3, 0x28, 0x90, 0xEF, 0x01, 0xAF, 0x70, 0x3E, 0xA8, 0x2D, 0xEB, 0x42,
  // "đ" (U+0111)
  0x48, 0x22, 0xEF, 0xA6, 0x81, 0x5F, 0x84, 0x84, 0x4D, 0xEF, 0xE5, 0x28, 0x47, 0xED, 0xDF, 0x32,
  0x81, 0x7F, 0x51, 0xA2, 0x85, 0x1E, 0xB0, 0x2F, 0xC2, 0x85, 0x5F, 0x70, 0x5F, 0x82, 0x85, 0x7F,
  0x50, 0xAF, 0x52, 0x85, 0x6F, 0x64, 0xCF, 0x33, 0x85, 0xCE, 0x85, 0xEC, 0x31,
  // "Ē" (U+0112)
  0x48, 0x27, 0xDD, 0xC7, 0x58, 0x55, 0xEF, 0xCA, 0xDE, 0x38, 0x4A, 0xF3, 0x03, 0xC3, 0x0D, 0x92,
  0x01, 0x04, 0x28, 0x11, 0xFD, 0x68, 0x44, 0xFE, 0xDD, 0x53, 0x81, 0x7F, 0x76, 0x81, 0xAF, 0x42,
  0x02, 0x30, 0xD9, 0x28, 0x31, 0xD0, 0x2C, 0xA8, 0x2A, 0xAD, 0xB1,
  // "ē" (U+0113)
  0x28, 0x27, 0xDD, 0xC7, 0x38, 0xB3, 0x5C, 0xEC, 0x10, 0x6F, 0x26, 0xF4, 0x1E, 0x92, 0xCD, 0x16,
  0xFE, 0xD9, 0x10, 0x7F, 0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1, 0x10,
  // "Ĕ" (U+0114)
  0x48, 0x32, 0xB0, 0x84, 0x58, 0x19, 0xD7, 0x75, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30,
  0x3C, 0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7,
  0x68, 0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "ĕ" (U+0115)
  0x28, 0x32, 0xB0, 0x84, 0x38, 0x19, 0xD7, 0x73, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41,
  0xE9, 0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB,
  0x11,
  // "Ė" (U+0116)
  0x58, 0x12, 0xB6, 0x68, 0x14, 0xE6, 0x75, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30, 0x3C,
  0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7, 0x68,
  0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "ė" (U+0117)
  0x38, 0x12, 0xB6, 0x48, 0x14, 0xE6, 0x73, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41, 0xE9,
  0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB, 0x11,
  // "Ę" (U+0118)
  0x28, 0x55, 0xEF, 0xCA, 0xDE, 0x38, 0x4A, 0xF3, 0x03, 0xC3, 0x0D, 0x92, 0x01, 0x04, 0x28, 0x11,
  0xFD, 0x68, 0x44, 0xFE, 0xDD, 0x53, 0x81, 0x7F, 0x76, 0x81, 0xAF, 0x42, 0x02, 0x30, 0xD9, 0x28,
  0x31, 0xD0, 0x2C, 0xA8, 0x2A, 0xAE, 0xB5, 0x81, 0x1B, 0x46, 0x07, 0x0D, 0x78, 0x23, 0xDD, 0x11,
  // "ę" (U+0119)
  0x28, 0xB3, 0x5C, 0xEC, 0x10, 0x6F, 0x26, 0xF4, 0x1E, 0x92, 0xCD, 0x16, 0xFE, 0xD9, 0x10, 0x7F,
  0x54, 0x84, 0x4F, 0x90, 0x25, 0x28, 0x37, 0xED, 0xB1, 0x38, 0x11, 0xB4, 0x40, 0x70, 0xD5, 0x82,
  0x3D, 0xD1, 0x10,
  // "Ě" (U+011A)
  0x48, 0x31, 0xD2, 0x89, 0x58, 0x19, 0xFA, 0x75, 0x85, 0x5E, 0xFC, 0xAD, 0xE3, 0x84, 0xAF, 0x30,
  0x3C, 0x30, 0xD9, 0x20, 0x10, 0x42, 0x81, 0x1F, 0xD6, 0x84, 0x4F, 0xED, 0xD5, 0x38, 0x17, 0xF7,
  0x68, 0x1A, 0xF4, 0x20, 0x23, 0x0D, 0x92, 0x83, 0x1D, 0x02, 0xCA, 0x82, 0xAA, 0xDB, 0x10,
  // "ě" (U+011B)
  0x28, 0x31, 0xD2, 0x89, 0x38, 0x19, 0xFA, 0x73, 0x8B, 0x35, 0xCE, 0xC1, 0x06, 0xF2, 0x6F, 0x41,
  0xE9, 0x2C, 0xD1, 0x6F, 0xED, 0x91, 0x07, 0xF5, 0x48, 0x44, 0xF9, 0x02, 0x52, 0x83, 0x7E, 0xDB,
  0x11,
  // "Ĝ" (U+011C)
  0x58, 0x15, 0xFD, 0x68, 0x34, 0xC2, 0x96, 0x77, 0x84, 0x3A, 0xDE, 0xD6, 0x38, 0x57, 0xF6, 0x01,
  0xED, 0x28, 0x14, 0xF9, 0x30, 0x30, 0x12, 0x81, 0xCF, 0x26, 0x81, 0x1F, 0xD2, 0x86, 0xCE, 0xEE,
  0x13, 0xFB, 0x39, 0x84, 0xE1, 0x01, 0xFC, 0x28, 0x11, 0xFB, 0x38, 0x5B, 0xF3, 0x04, 0xF9, 0x38,
  0x51, 0x9D, 0xDD, 0xA3, 0x20,
  // "ĝ" (U+011D)
  0x48, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x76, 0x84, 0x7D, 0xE8, 0xC5, 0x28, 0x57, 0xE1, 0x9E,
  0x21, 0x28, 0x2D, 0xA0, 0x99, 0x48, 0x3C, 0xA1, 0xE9, 0x48, 0x26, 0xFD, 0x94, 0x81, 0x3E, 0x36,
  0x02, 0xB0, 0xC0, 0x42, 0x85, 0x2B, 0x75, 0x7E, 0xB2, 0x0A, 0x0D, 0x28, 0x11, 0xE7, 0x28, 0x43,
  0xCE, 0xDC, 0x73,
  // "Ğ" (U+011E)
  0x48, 0x32, 0xB0, 0x84, 0x68, 0x19, 0xD7, 0x77, 0x18, 0x43, 0xAD, 0xED, 0x63, 0x85, 0x7F, 0x60,
  0x1E, 0xD2, 0x81, 0x4F, 0x93, 0x03, 0x01, 0x28, 0x1C, 0xF2, 0x68, 0x11, 0xFD, 0x28, 0x6C, 0xEE,
  0xE1, 0x3F, 0xB3, 0x98, 0x4E, 0x10, 0x1F, 0xC2, 0x81, 0x1F, 0xB3, 0x85, 0xBF, 0x30, 0x4F, 0x93,
  0x85, 0x19, 0xDD, 0xDA, 0x32,
  // "ğ" (U+011F)
  0x38, 0x32, 0xB0, 0x84, 0x58, 0x19, 0xD7, 0x77, 0x84, 0x7D, 0xE8, 0xC5, 0x28, 0x57, 0xE1, 0x9E,
  0x21, 0x28, 0x2D, 0xA0, 0x99, 0x48, 0x3C, 0xA1, 0xE9, 0x48, 0x26, 0xFD, 0x94, 0x81, 0x3E, 0x36,
  0x02, 0xB0, 0xC0, 0x42, 0x85, 0x2B, 0x75, 0x7E, 0xB2, 0x0A, 0x0D, 0x28, 0x11, 0xE7, 0x28, 0x43,
  0xCE, 0xDC, 0x73,
  // "Ġ" (U+0120)
  0x58, 0x12, 0xB6, 0x78, 0x14, 0xE6, 0x77, 0x18, 0x43, 0xAD, 0xED, 0x63, 0x85, 0x7F, 0x60, 0x1E,
  0xD2, 0x81, 0x4F, 0x93, 0x03, 0x01, 0x28, 0x1C, 0xF2, 0x68, 0x11, 0xFD, 0x28, 0x6C, 0xEE, 0xE1,
  0x3F, 0xB3, 0x98, 0x4E, 0x10, 0x1F, 0xC2, 0x81, 0x1F, 0xB3, 0x85, 0xBF, 0x30, 0x4F, 0x93, 0x85,
  0x19, 0xDD, 0xDA, 0x32,
  // "ġ" (U+0121)
  0x48, 0x12, 0xB6, 0x68, 0x14, 0xE6, 0x77, 0x84, 0x7D, 0xE8, 0xC5, 0x28, 0x57, 0xE1, 0x9E, 0x21,
  0x28, 0x2D, 0xA0, 0x99, 0x48, 0x3C, 0xA1, 0xE9, 0x48, 0x26, 0xFD, 0x94, 0x81, 0x3E, 0x36, 0x02,
  0xB0, 0xC0, 0x42, 0x85, 0x2B, 0x75, 0x7E, 0xB2, 0x0A, 0x0D, 0x28, 0x11, 0xE7, 0x28, 0x43, 0xCE,
  0xDC, 0x73,
  // "Ģ" (U+0122)
  0x38, 0x43, 0xAD, 0xED, 0x63, 0x85, 0x7F, 0x60, 0x1E, 0xD2, 0x81, 0x4F, 0x93, 0x03, 0x01, 0x28,
  0x1C, 0xF2, 0x68, 0x11, 0xFD, 0x28, 0x6C, 0xEE, 0xE1, 0x3F, 0xB3, 0x98, 0x4E, 0x10, 0x1F, 0xC2,
  0x81, 0x1F, 0xB3, 0x85, 0xBF, 0x30, 0x4F, 0x93, 0x85, 0x19, 0xDD, 0xDA, 0x37, 0x71, 0x09, 0x0B,
  0x78, 0x11, 0xC1, 0x50,
  // "ģ" (U+0123)
  0x50, 0x40, 0x97, 0x0D, 0x04, 0x60, 0x40, 0xA6, 0x84, 0x7D, 0xE8, 0xC5, 0x28, 0x57, 0xE1, 0x9E,
  0x21, 0x28, 0x2D, 0xA0, 0x99, 0x48, 0x3C, 0xA1, 0xE9, 0x48, 0x26, 0xFD, 0x94, 0x81, 0x3E, 0x36,
  0x02, 0xB0, 0xC0, 0x42, 0x85, 0x2B, 0x75, 0x7E, 0xB2, 0x0A, 0x0D, 0x28, 0x11, 0xE7, 0x28, 0x43,
  0xCE, 0xDC, 0x73,
  // "Ĥ" (U+0124)
  0x68, 0x15, 0xFD, 0x71, 0x83, 0x4C, 0x29, 0x67, 0x72, 0x07, 0xB0, 0x80, 0x7B, 0x08, 0x38, 0x1A,
  0xF4, 0x28, 0x19, 0xF5, 0x48, 0x1C, 0xF1, 0x28, 0x1C, 0xF1, 0x49, 0x0D, 0x39, 0x0D, 0x48, 0x64,
  0xFE, 0xDD, 0xDF, 0xA4, 0x81, 0x7F, 0x72, 0x81, 0x6F, 0x64, 0x81, 0xAF, 0x32, 0x81, 0x9F, 0x34,
  0x0E, 0x93, 0x0D, 0x93, 0x02, 0x0E, 0xA8, 0x1D, 0x2E, 0xA0, 0xD2,
  // "ĥ" (U+0125)
  0x38, 0x15, 0xFD, 0x48, 0x34, 0xC2, 0x96, 0x28, 0x1D, 0xFE, 0x58, 0x11, 0xFB, 0x58, 0x14, 0xF8,
  0x58, 0x47, 0xF7, 0xBE, 0x82, 0x84, 0xAF, 0xA0, 0xFD, 0x28, 0x4D, 0xF2, 0x1F, 0xC2, 0x98, 0xB4,
  0xC0, 0x4F, 0x90, 0x3F, 0x80, 0x7F, 0x60, 0x7F, 0x50, 0x8F, 0x40, 0xAF, 0x20, 0x4E, 0xC4,
  // "Ħ" (U+0126)
  0x20, 0x7B, 0x08, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x42, 0x81, 0xAF, 0x42, 0x01, 0x0D, 0xA0, 0xFD,
  0xA0, 0xD0, 0x43, 0x90, 0xD3, 0x90, 0xD4, 0x86, 0x4F, 0xED, 0xDD, 0xFA, 0x48, 0x17, 0xF7, 0x28,
  0x16, 0xF7, 0x48, 0x1A, 0xF3, 0x28, 0x19, 0xF3, 0x40, 0xE9, 0x30, 0xD9, 0x30, 0x20, 0xEA, 0x81,
  0xD2, 0xEA, 0x0D, 0x20,
  // "ħ" (U+0127)
  0x18, 0x1D, 0xFE, 0x58, 0x11, 0xFC, 0x48, 0x43, 0xDF, 0xED, 0x63, 0x84, 0x6F, 0x8B, 0xE7, 0x28,
  0x49, 0xF9, 0x1F, 0xC2, 0x84, 0xCF, 0x22, 0xFB, 0x29, 0x8B, 0x4B, 0x04, 0xF8, 0x03, 0xF8, 0x07,
  0xF6, 0x06, 0xF5, 0x08, 0xF4, 0x0A, 0xF2, 0x04, 0xEC, 0x40,
  // "Ĩ" (U+0128)
  0x38, 0x2B, 0xB3, 0xA2, 0x83, 0x63, 0x6D, 0x67, 0x20, 0x7B, 0x08, 0x38, 0x1A, 0xF4, 0x40, 0xC9,
  0x59, 0x0C, 0x48, 0x14, 0xF9, 0x48, 0x17, 0xF6, 0x48, 0x1A, 0xF3, 0x40, 0xE9, 0x30, 0x20, 0xEA,
  0x0D, 0x20,
  // "ĩ" (U+0129)
  0x18, 0x7B, 0xB3, 0xA6, 0x36, 0xD6, 0x50, 0x3A, 0x08, 0x28, 0x18, 0xF5, 0x28, 0x1A, 0xF2, 0x20,
  0xD0, 0xE3, 0x90, 0xB2, 0x81, 0x2F, 0xA3, 0x81, 0xCE, 0x81,
  // "Ī" (U+012A)
  0x38, 0x27, 0xDD, 0xC7, 0x20, 0x7B, 0x08, 0x38, 0x1A, 0xF4, 0x40, 0xC9, 0x59, 0x0C, 0x48, 0x14,
  0xF9, 0x48, 0x17, 0xF6, 0x48, 0x1A, 0xF3, 0x40, 0xE9, 0x30, 0x20, 0xEA, 0x0D, 0x20,
  // "ī" (U+012B)
  0x82, 0x7D, 0xDC, 0x40, 0x3A, 0x89, 0x28, 0x08, 0xF5, 0x0A, 0xF2, 0x0D, 0xE2, 0x98, 0x3B, 0x02,
  0xFA, 0x28, 0x1C, 0xE8,
  // "Ĭ" (U+012C)
  0x28, 0x32, 0xB0, 0x84, 0x38, 0x19, 0xD7, 0x73, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x44, 0x0C, 0x95,
  0x90, 0xC4, 0x81, 0x4F, 0x94, 0x81, 0x7F, 0x64, 0x81, 0xAF, 0x34, 0x0E, 0x93, 0x02, 0x0E, 0xA0,
  0xD2,
  // "ĭ" (U+012D)
  0x87, 0x2B, 0x08, 0x40, 0x9D, 0x76, 0x03, 0xA0, 0x82, 0x81, 0x8F, 0x52, 0x81, 0xAF, 0x22, 0x0D,
  0x0E, 0x39, 0x0B, 0x28, 0x12, 0xFA, 0x38, 0x1C, 0xE8, 0x10,
  // "Į" (U+012E)
  0x20, 0x7B, 0x08, 0x38, 0x1A, 0xF4, 0x40, 0xC9, 0x59, 0x0C, 0x48, 0x14, 0xF9, 0x48, 0x17, 0xF6,
  0x48, 0x1A, 0xF3, 0x40, 0xE9, 0x30, 0x20, 0xEA, 0x0D, 0x38, 0x11, 0xB4, 0x40, 0x70, 0xD5, 0x82,
  0x3D, 0xD1, 0x20,
  // "į" (U+012F)
  0x20, 0xC0, 0xB2, 0x0B, 0x08, 0x40, 0x3A, 0x89, 0x28, 0x08, 0xF5, 0x0A, 0xF2, 0x0D, 0xE2, 0x98,
  0x3B, 0x02, 0xFA, 0x28, 0x7C, 0xE8, 0x1B, 0x40, 0x7D, 0x28, 0x23, 0xDD, 0x10,
  // "İ" (U+0130)
  0x38, 0x12, 0xB6, 0x48, 0x14, 0xE6, 0x73, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x44, 0x0C, 0x95, 0x90,
  0xC4, 0x81, 0x4F, 0x94, 0x81, 0x7F, 0x64, 0x81, 0xAF, 0x34, 0x0E, 0x93, 0x02, 0x0E, 0xA0, 0xD2,
  // "ı" (U+0131)
  0x03, 0xA8, 0x92, 0x80, 0x8F, 0x50, 0xAF, 0x20, 0xDE, 0x29, 0x83, 0xB0, 0x2F, 0xA2, 0x81, 0xCE,
  0x80,
  // "Ĳ" (U+0132)
  0x20, 0x7B, 0x08, 0x07, 0xB0, 0x83, 0x81, 0xAF, 0x42, 0x81, 0xAF, 0x44, 0x0C, 0x93, 0x0D, 0x95,
  0x90, 0xC3, 0x90, 0xD4, 0x81, 0x4F, 0x92, 0x81, 0x4F, 0xA4, 0x81, 0x7F, 0x62, 0x81, 0x7F, 0x64,
  0x81, 0xAF, 0x32, 0x81, 0xAF, 0x34, 0x0E, 0x93, 0x0D, 0x93, 0x02, 0x0E, 0xA8, 0x3D, 0x01, 0xFD,
  0x72, 0x81, 0x5F, 0x97, 0x28, 0x1C, 0xE2, 0x78, 0x2B, 0xEB, 0x24,
  // "ĳ" (U+0133)
  0x20, 0xC0, 0xB2, 0x0C, 0x0B, 0x20, 0xB0, 0x82, 0x0B, 0x08, 0x71, 0x03, 0xA0, 0x80, 0x3A, 0x8A,
  0x28, 0x08, 0xF5, 0x08, 0xF5, 0x0A, 0xF2, 0x0A, 0xF2, 0x0D, 0xE2, 0x0D, 0x0E, 0x29, 0x89, 0x3B,
  0x01, 0xFB, 0x02, 0xFA, 0x04, 0xF8, 0x28, 0x4C, 0xE8, 0x7F, 0x55, 0x81, 0xBF, 0x14, 0x81, 0x1F,
  0xB4, 0x82, 0x7E, 0xB1, 0x20,
  // "Ĵ" (U+0134)
  0x48, 0x15, 0xFD, 0x48, 0x34, 0xC2, 0x96, 0x74, 0x07, 0xB0, 0x84, 0x81, 0xAF, 0x45, 0x0D, 0x96,
  0x90, 0xD5, 0x81, 0x4F, 0xA5, 0x81, 0x7F, 0x65, 0x81, 0xAF, 0x35, 0x0D, 0x95, 0x81, 0x1F, 0xD5,
  0x81, 0x5F, 0x95, 0x81, 0xCE, 0x23, 0x82, 0xBE, 0xB2, 0x40,
  // "ĵ" (U+0135)
  0x38, 0x15, 0xFD, 0x38, 0x34, 0xC2, 0x96, 0x72, 0x03, 0xA0, 0x84, 0x81, 0x8F, 0x54, 0x81, 0xAF,
  0x24, 0x0D, 0x0E, 0x48, 0x11, 0xFB, 0x48, 0x14, 0xF8, 0x48, 0x17, 0xF5, 0x48, 0x1B, 0xF1, 0x38,
  0x11, 0xFB, 0x38, 0x27, 0xEB, 0x13,
  // "Ķ" (U+0136)
  0x20, 0x7B, 0x00, 0x8A, 0x09, 0x38, 0x5A, 0xF4, 0x04, 0xD4, 0x48, 0x4C, 0xF0, 0x3B, 0x15, 0x98,
  0x2D, 0x4D, 0x15, 0x81, 0x4F, 0xEA, 0x01, 0x58, 0x47, 0xF7, 0x9F, 0x75, 0x84, 0xAF, 0x33, 0xFE,
  0x50, 0xE9, 0x28, 0x1D, 0xF6, 0x20, 0x20, 0xEA, 0x84, 0xD0, 0x3D, 0xF3, 0x77, 0x10, 0x90, 0xB7,
  0x18, 0x11, 0xC1, 0x60,
  // "ķ" (U+0137)
  0x18, 0x1D, 0xFE, 0x58, 0x11, 0xFB, 0x58, 0x14, 0xF8, 0x58, 0x27, 0xF5, 0x6A, 0x86, 0x80, 0xAF,
  0x23, 0xD3, 0x28, 0x3D, 0xE3, 0xC1, 0x39, 0x0F, 0xE3, 0x84, 0x3F, 0x98, 0xF6, 0x28, 0x95, 0x7F,
  0x52, 0xFD, 0x10, 0xAF, 0x20, 0x7E, 0xB7, 0x40, 0x90, 0xB5, 0x81, 0x1C, 0x14,
  // "ĸ" (U+0138)
  0x06, 0xA0, 0x50, 0x6A, 0x86, 0x80, 0xBF, 0x23, 0xD3, 0x28, 0x3D, 0xE3, 0xC1, 0x39, 0x0F, 0xE3,
  0x84, 0x3F, 0x98, 0xF6, 0x28, 0x95, 0x7F, 0x52, 0xFD, 0x10, 0xAF, 0x20, 0x7E, 0xB1,
  // "Ĺ" (U+0139)
  0x58, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x76, 0x83, 0x5E, 0xFE, 0x65, 0x81, 0xAF, 0x36, 0x0D, 0x96,
  0x81, 0x1F, 0xC6, 0x81, 0x4F, 0x96, 0x81, 0x7F, 0x66, 0x81, 0xAF, 0x32, 0x06, 0x04, 0x20, 0xD9,
  0x38, 0x2C, 0x12, 0xCA, 0x82, 0xAA, 0xCD, 0x10,
  // "ĺ" (U+013A)
  0x38, 0x18, 0xE4, 0x28, 0x15, 0xC2, 0x28, 0x1D, 0xFE, 0x38, 0x12, 0xFB, 0x38, 0x14, 0xF8, 0x38,
  0x17, 0xF5, 0x38, 0x1A, 0xF2, 0x30, 0xD0, 0xE3, 0x81, 0x1F, 0xB3, 0x81, 0x4F, 0x83, 0x81, 0x5F,
  0x73, 0x82, 0x2D, 0xD6, 0x20,
  // "Ļ" (U+013B)
  0x28, 0x35, 0xEF, 0xE6, 0x58, 0x1A, 0xF3, 0x60, 0xD9, 0x68, 0x11, 0xFC, 0x68, 0x14, 0xF9, 0x68,
  0x17, 0xF6, 0x68, 0x1A, 0xF3, 0x20, 0x60, 0x42, 0x0D, 0x93, 0x82, 0xC1, 0x2C, 0xA8, 0x2A, 0xAC,
  0xD7, 0x60, 0x90, 0xB6, 0x81, 0x1C, 0x14,
  // "ļ" (U+013C)
  0x28, 0x1D, 0xFE, 0x28, 0x12, 0xFB, 0x28, 0x14, 0xF8, 0x28, 0x17, 0xF5, 0x28, 0x1A, 0xF2, 0x20,
  0xD0, 0xE2, 0x81, 0x1F, 0xB2, 0x81, 0x4F, 0x82, 0x81, 0x5F, 0x72, 0x82, 0x2D, 0xD6, 0x60, 0x90,
  0xB2, 0x81, 0x1C, 0x12,
  // "Ľ" (U+013D)
  0x28, 0x55, 0xEF, 0xE6, 0x9B, 0x38, 0x4A, 0xF3, 0x1C, 0x13, 0x0D, 0x96, 0x81, 0x1F, 0xC6, 0x81,
  0x4F, 0x96, 0x81, 0x7F, 0x66, 0x81, 0xAF, 0x32, 0x06, 0x04, 0x20, 0xD9, 0x38, 0x2C, 0x12, 0xCA,
  0x82, 0xAA, 0xCD, 0x10,
  // "ľ" (U+013E)
  0x18, 0x92, 0xDF, 0xE1, 0xF4, 0x02, 0xFB, 0x79, 0x28, 0x24, 0xF8, 0x23, 0x81, 0x7F, 0x54, 0x81,
  0xAF, 0x24, 0x0D, 0x0E, 0x48, 0x11, 0xFB, 0x48, 0x14, 0xF8, 0x48, 0x15, 0xF7, 0x48, 0x22, 0xDD,
  0x63,
  // "Ŀ" (U+013F)
  0x28, 0x35, 0xEF, 0xE6, 0x58, 0x1A, 0xF3, 0x60, 0xD9, 0x68, 0x51, 0xFC, 0x02, 0xB6, 0x28, 0x54,
  0xF9, 0x04, 0xE6, 0x28, 0x17, 0xF6, 0x68, 0x1A, 0xF3, 0x20, 0x60, 0x42, 0x0D, 0x93, 0x82, 0xC1,
  0x2C, 0xA8, 0x2A, 0xAC, 0xD1,
  // "ŀ" (U+0140)
  0x18, 0x1D, 0xFE, 0x38, 0x12, 0xFB, 0x38, 0x14, 0xF8, 0x38, 0x17, 0xF5, 0x38, 0x94, 0xAF, 0x5B,
  0x60, 0xDE, 0x4E, 0x61, 0xFB, 0x38, 0x14, 0xF8, 0x38, 0x15, 0xF7, 0x38, 0x22, 0xDD, 0x62,
  // "Ł" (U+0141)
  0x28, 0x35, 0xEF, 0xE6, 0x58, 0x1A, 0xF3, 0x68, 0x2D, 0xF0, 0x34, 0x83, 0x1F, 0xEB, 0x54, 0x81,
  0x6F, 0xB5, 0x82, 0x5D, 0xF6, 0x68, 0x1A, 0xF3, 0x20, 0x60, 0x42, 0x0D, 0x93, 0x82, 0xC1, 0x2C,
  0xA8, 0x2A, 0xAC, 0xD1,
  // "ł" (U+0142)
  0x18, 0x1D, 0xFE, 0x28, 0x11, 0xFB, 0x28, 0x14, 0xF8, 0x28, 0x17, 0xF6, 0x28, 0x92, 0xAF, 0xB1,
  0x1D, 0xE3, 0x0C, 0xFB, 0x28, 0x14, 0xF9, 0x28, 0x15, 0xF7, 0x28, 0x22, 0xDD, 0x61,
  // "Ń" (U+0143)
  0x78, 0x18, 0xE4, 0x71, 0x81, 0x5C, 0x27, 0x73, 0x07, 0xA0, 0x62, 0x09, 0xA0, 0x43, 0x81, 0xAF,
  0xD3, 0x0D, 0x01, 0x48, 0x5C, 0xAF, 0x50, 0x1D, 0x58, 0x5D, 0x2F, 0xC0, 0x49, 0x48, 0x64, 0x90,
  0xAF, 0x37, 0x64, 0x86, 0x76, 0x03, 0xFA, 0xA3, 0x40, 0xA0, 0x32, 0x81, 0xBF, 0xE5, 0x0E, 0x38,
  0x14, 0xFC, 0x38, 0x22, 0xEF, 0xB3, 0x0C, 0x09, 0x30,
  // "ń" (U+0144)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x72, 0x03, 0xA8, 0x27, 0xAE, 0xA2, 0x89, 0x48, 0xFC, 0x0D,
  0xF1, 0x0A, 0xF5, 0x0E, 0xE2, 0x8B, 0x5D, 0xE0, 0x1F, 0xC0, 0x1F, 0xB0, 0x4F, 0x90, 0x4F, 0x80,
  0x5F, 0x70, 0x7F, 0x50, 0x2D, 0xD6,
  // "Ņ" (U+0145)
  0x20, 0x7A, 0x06, 0x20, 0x9A, 0x04, 0x38, 0x1A, 0xFD, 0x30, 0xD0, 0x14, 0x85, 0xCA, 0xF5, 0x01,
  0xD5, 0x85, 0xD2, 0xFC, 0x04, 0x94, 0x86, 0x49, 0x0A, 0xF3, 0x76, 0x48, 0x67, 0x60, 0x3F, 0xAA,
  0x34, 0x0A, 0x03, 0x28, 0x1B, 0xFE, 0x50, 0xE3, 0x81, 0x4F, 0xC3, 0x82, 0x2E, 0xFB, 0x30, 0xC0,
  0x97, 0x75, 0x09, 0x0B, 0x72, 0x81, 0x1C, 0x16,
  // "ņ" (U+0146)
  0x03, 0xA8, 0x27, 0xAE, 0xA2, 0x89, 0x48, 0xFC, 0x0D, 0xF1, 0x0A, 0xF5, 0x0E, 0xE2, 0x8B, 0x5D,
  0xE0, 0x1F, 0xC0, 0x1F, 0xB0, 0x4F, 0x90, 0x4F, 0x80, 0x5F, 0x70, 0x7F, 0x50, 0x2D, 0xD6, 0x73,
  0x09, 0x0B, 0x58, 0x11, 0xC1, 0x40,
  // "Ň" (U+0147)
  0x48, 0x31, 0xD2, 0x89, 0x71, 0x81, 0x9F, 0xA7, 0x74, 0x07, 0xA0, 0x62, 0x09, 0xA0, 0x43, 0x81,
  0xAF, 0xD3, 0x0D, 0x01, 0x48, 0x5C, 0xAF, 0x50, 0x1D, 0x58, 0x5D, 0x2F, 0xC0, 0x49, 0x48, 0x64,
  0x90, 0xAF, 0x37, 0x64, 0x86, 0x76, 0x03, 0xFA, 0xA3, 0x40, 0xA0, 0x32, 0x81, 0xBF, 0xE5, 0x0E,
  0x38, 0x14, 0xFC, 0x38, 0x22, 0xEF, 0xB3, 0x0C, 0x09, 0x30,
  // "ň" (U+0148)
  0x28, 0x31, 0xD2, 0x89, 0x48, 0x19, 0xFA, 0x73, 0x03, 0xA8, 0x27, 0xAE, 0xA2, 0x89, 0x48, 0xFC,
  0x0D, 0xF1, 0x0A, 0xF5, 0x0E, 0xE2, 0x8B, 0x5D, 0xE0, 0x1F, 0xC0, 0x1F, 0xB0, 0x4F, 0x90, 0x4F,
  0x80, 0x5F, 0x70, 0x7F, 0x50, 0x2D, 0xD6,
  // "ŉ" (U+0149)
  0x81, 0x2E, 0x67, 0x81, 0x1D, 0x97, 0x10, 0xB0, 0x7A, 0x89, 0x57, 0xAE, 0xA0, 0x84, 0x08, 0xFC,
  0x0D, 0xF1, 0x38, 0x4A, 0xF5, 0x0E, 0xE4, 0x84, 0xDE, 0x01, 0xFC, 0x38, 0x51, 0xFB, 0x04, 0xF9,
  0x38, 0x54, 0xF8, 0x05, 0xF7, 0x38, 0x67, 0xF5, 0x02, 0xDD, 0x60,
  // "Ŋ" (U+014A)
  0x20, 0x7A, 0x06, 0x20, 0x9A, 0x04, 0x38, 0x1A, 0xFD, 0x30, 0xD0, 0x14, 0x85, 0xCA, 0xF5, 0x01,
  0xD5, 0x85, 0xD2, 0xFC, 0x04, 0xA4, 0x86, 0x49, 0x0A, 0xF3, 0x76, 0x48, 0x67, 0x60, 0x3F, 0xAA,
  0x34, 0x0A, 0x03, 0x28, 0x1B, 0xFE, 0x50, 0xE3, 0x81, 0x4F, 0xC3, 0x82, 0x2E, 0xFB, 0x30, 0xC0,
  0x97, 0x30, 0xB0, 0x57, 0x20, 0x50, 0xE7, 0x18, 0x24, 0xDC, 0x34,
  // "ŋ" (U+014B)
  0x03, 0xA8, 0x27, 0x9E, 0xA2, 0x89, 0x48, 0xFC, 0x0D, 0xF1, 0x0A, 0xF5, 0x0D, 0xE2, 0x8B, 0x4D,
  0xE0, 0x1F, 0xB0, 0x1F, 0xB0, 0x4F, 0x80, 0x4F, 0x80, 0x7F, 0x50, 0x7F, 0x50, 0xAF, 0x25, 0x00,
  0xE5, 0x81, 0x4F, 0x84, 0x81, 0xAE, 0xA3,
  // "Ō" (U+014C)
  0x48, 0x27, 0xDD, 0xC7, 0x71, 0x83, 0x4C, 0xDE, 0x94, 0x85, 0x8F, 0x50, 0x3F, 0xA2, 0x81, 0x4F,
  0x83, 0x85, 0xDF, 0x10, 0xCF, 0x13, 0x84, 0xCF, 0x21, 0xFD, 0x48, 0x4E, 0xF0, 0x3F, 0xB3, 0x85,
  0x2F, 0xA0, 0x2F, 0xC3, 0x81, 0x9F, 0x32, 0x85, 0xBF, 0x30, 0x5F, 0x73, 0x84, 0x19, 0xED, 0xC4,
  0x30,
  // "ō" (U+014D)
  0x28, 0x27, 0xDD, 0xC7, 0x38, 0x95, 0x6D, 0xEB, 0x20, 0x7F, 0x41, 0xFB, 0x1F, 0xB2, 0x83, 0xED,
  0x5F, 0x72, 0x98, 0xA3, 0xC7, 0xF5, 0x04, 0xF8, 0x4F, 0x70, 0xCD, 0x10, 0x8E, 0xDA, 0x11,
  // "Ŏ" (U+014E)
  0x48, 0x32, 0xB0, 0x84, 0x68, 0x19, 0xD7, 0x77, 0x18, 0x34, 0xCD, 0xE9, 0x48, 0x58, 0xF5, 0x03,
  0xFA, 0x28, 0x14, 0xF8, 0x38, 0x5D, 0xF1, 0x0C, 0xF1, 0x38, 0x4C, 0xF2, 0x1F, 0xD4, 0x84, 0xEF,
  0x03, 0xFB, 0x38, 0x52, 0xFA, 0x02, 0xFC, 0x38, 0x19, 0xF3, 0x28, 0x5B, 0xF3, 0x05, 0xF7, 0x38,
  0x41, 0x9E, 0xDC, 0x43,
  // "ŏ" (U+014F)
  0x28, 0x32, 0xB0, 0x84, 0x38, 0x19, 0xD7, 0x73, 0x89, 0x56, 0xDE, 0xB2, 0x07, 0xF4, 0x1F, 0xB1,
  0xFB, 0x28, 0x3E, 0xD5, 0xF7, 0x29, 0x8A, 0x3C, 0x7F, 0x50, 0x4F, 0x84, 0xF7, 0x0C, 0xD1, 0x08,
  0xED, 0xA1, 0x10,
  // "Ő" (U+0150)
  0x58, 0x3A, 0xB6, 0xE2, 0x48, 0x35, 0xA2, 0xC2, 0x77, 0x83, 0x4C, 0xDE, 0x94, 0x85, 0x8F, 0x50,
  0x3F, 0xA2, 0x81, 0x4F, 0x83, 0x85, 0xDF, 0x10, 0xCF, 0x13, 0x84, 0xCF, 0x21, 0xFD, 0x48, 0x4E,
  0xF0, 0x3F, 0xB3, 0x85, 0x2F, 0xA0, 0x2F, 0xC3, 0x81, 0x9F, 0x32, 0x85, 0xBF, 0x30, 0x5F, 0x73,
  0x84, 0x19, 0xED, 0xC4, 0x30,
  // "ő" (U+0151)
  0x38, 0x3A, 0xB6, 0xE2, 0x28, 0x35, 0xA2, 0xC2, 0x74, 0x83, 0x6D, 0xEB, 0x22, 0x89, 0x07, 0xF4,
  0x1F, 0xB0, 0x1F, 0xB2, 0x84, 0xED, 0x05, 0xF7, 0x29, 0x89, 0x7C, 0x07, 0xF5, 0x04, 0xF8, 0x04,
  0xF7, 0x0C, 0xD1, 0x28, 0x38, 0xED, 0xA1, 0x20,
  // "Œ" (U+0152)
  0x38, 0x14, 0xCD, 0xA8, 0x3E, 0xDE, 0xF3, 0x28, 0x58, 0xF5, 0x05, 0xF8, 0x28, 0x4E, 0x10, 0x4F,
  0x82, 0x81, 0x8F, 0x52, 0x06, 0x28, 0x1C, 0xF1, 0x28, 0x1B, 0xF2, 0x48, 0x11, 0xFD, 0x38, 0x3E,
  0xFD, 0xD9, 0x28, 0x13, 0xFB, 0x28, 0x13, 0xFB, 0x58, 0x12, 0xFC, 0x28, 0x16, 0xF8, 0x20, 0x20,
  0x12, 0x85, 0xBF, 0x30, 0x9F, 0x42, 0x0C, 0x04, 0x28, 0x21, 0x9E, 0xEA, 0x81, 0xED, 0xE9, 0x20,
  // "œ" (U+0153)
  0x28, 0x94, 0x6D, 0xEB, 0x29, 0xDE, 0x50, 0x7F, 0x41, 0xA8, 0x58, 0x0F, 0xA1, 0xFB, 0x28, 0x7E,
  0xE1, 0x7F, 0x55, 0xF7, 0x2A, 0x89, 0x1D, 0xB4, 0x07, 0xF5, 0x04, 0xFB, 0x48, 0x90, 0x4F, 0x70,
  0xCF, 0xE1, 0x07, 0x28, 0x78, 0xED, 0xA4, 0xCE, 0xC5, 0x10,
  // "Ŕ" (U+0154)
  0x68, 0x18, 0xE4, 0x68, 0x15, 0xC2, 0x77, 0x07, 0xA8, 0x2E, 0xED, 0x64, 0x85, 0xAF, 0x30, 0xEF,
  0x13, 0x0C, 0x92, 0x81, 0xDF, 0x23, 0x98, 0x3C, 0x05, 0xFA, 0x38, 0x44, 0xFE, 0xEF, 0x64, 0x84,
  0x7F, 0x57, 0xF7, 0x48, 0x4A, 0xF2, 0x3F, 0xC4, 0x0E, 0x92, 0x84, 0xDF, 0x30, 0x2E, 0xA8, 0x3E,
  0x24, 0xDE, 0x10,
  // "ŕ" (U+0155)
  0x48, 0x18, 0xE4, 0x38, 0x15, 0xC2, 0x71, 0x03, 0xA8, 0x97, 0x6A, 0xE7, 0x07, 0xFB, 0x1C, 0x80,
  0xAF, 0x60, 0x12, 0x0D, 0x95, 0x90, 0xC4, 0x81, 0x4F, 0x84, 0x81, 0x7F, 0x54,
  // "Ŗ" (U+0156)
  0x20, 0x7A, 0x82, 0xEE, 0xD6, 0x48, 0x5A, 0xF3, 0x0E, 0xF1, 0x30, 0xC9, 0x28, 0x1D, 0xF2, 0x39,
  0x83, 0xC0, 0x5F, 0xA3, 0x84, 0x4F, 0xEE, 0xF6, 0x48, 0x47, 0xF5, 0x7F, 0x74, 0x84, 0xAF, 0x23,
  0xFC, 0x40, 0xE9, 0x28, 0x4D, 0xF3, 0x02, 0xEA, 0x83, 0xE2, 0x4D, 0xE7, 0x71, 0x09, 0x0B, 0x78,
  0x11, 0xC1, 0x40,
  // "ŗ" (U+0157)
  0x10, 0x3A, 0x82, 0x6A, 0xE7, 0x28, 0x47, 0xFB, 0x1C, 0x82, 0x83, 0xAF, 0x60, 0x13, 0x0D, 0x96,
  0x90, 0xC5, 0x81, 0x4F, 0x85, 0x81, 0x7F, 0x57, 0x60, 0x90, 0xB5, 0x81, 0x1C, 0x15,
  // "Ř" (U+0158)
  0x48, 0x31, 0xD2, 0x89, 0x68, 0x19, 0xFA, 0x77, 0x07, 0xA8, 0x2E, 0xED, 0x64, 0x85, 0xAF, 0x30,
  0xEF, 0x13, 0x0C, 0x92, 0x81, 0xDF, 0x23, 0x98, 0x3C, 0x05, 0xFA, 0x38, 0x44, 0xFE, 0xEF, 0x64,
  0x84, 0x7F, 0x57, 0xF7, 0x48, 0x4A, 0xF2, 0x3F, 0xC4, 0x0E, 0x92, 0x84, 0xDF, 0x30, 0x2E, 0xA8,
  0x3E, 0x24, 0xDE, 0x10,
  // "ř" (U+0159)
  0x18, 0x31, 0xD2, 0x89, 0x38, 0x19, 0xFA, 0x72, 0x03, 0xA8, 0x97, 0x6A, 0xE7, 0x07, 0xFB, 0x1C,
  0x80, 0xAF, 0x60, 0x12, 0x0D, 0x95, 0x90, 0xC4, 0x81, 0x4F, 0x84, 0x81, 0x7F, 0x54,
  // "Ś" (U+015A)
  0x58, 0x18, 0xE4, 0x48, 0x15, 0xC2, 0x74, 0x83, 0x7C, 0xCD, 0x72, 0x89, 0x45, 0xF3, 0x0A, 0xF1,
  0x09, 0xF3, 0x03, 0x32, 0x82, 0x6F, 0xD5, 0x50, 0xAA, 0x09, 0x58, 0x55, 0xEF, 0x40, 0x7B, 0x28,
  0xA0, 0x6F, 0x50, 0xBF, 0x20, 0x6E, 0x20, 0x2B, 0xDB, 0xB3, 0x20,
  // "ś" (U+015B)
  0x48, 0x18, 0xE4, 0x38, 0x15, 0xC2, 0x72, 0x83, 0x4C, 0xCE, 0x62, 0x83, 0xE9, 0x0A, 0xB2, 0x82,
  0xEE, 0x51, 0x38, 0x24, 0xEF, 0xC2, 0x8A, 0x11, 0x31, 0xAF, 0x50, 0xBA, 0x03, 0xF3, 0x05, 0xDC,
  0xC6, 0x20,
  // "Ŝ" (U+015C)
  0x38, 0x15, 0xFD, 0x48, 0x34, 0xC2, 0x96, 0x74, 0x83, 0x7C, 0xCD, 0x72, 0x89, 0x45, 0xF3, 0x0A,
  0xF1, 0x09, 0xF3, 0x03, 0x32, 0x82, 0x6F, 0xD5, 0x50, 0xAA, 0x09, 0x58, 0x55, 0xEF, 0x40, 0x7B,
  0x28, 0xA0, 0x6F, 0x50, 0xBF, 0x20, 0x6E, 0x20, 0x2B, 0xDB, 0xB3, 0x20,
  // "ŝ" (U+015D)
  0x28, 0x15, 0xFD, 0x28, 0x34, 0xC2, 0x96, 0x78, 0x96, 0x4C, 0xCE, 0x60, 0xE9, 0x0A, 0xB0, 0xEE,
  0x51, 0x28, 0xA4, 0x4E, 0xFC, 0x01, 0x31, 0xAF, 0x5B, 0xA0, 0x3F, 0x35, 0xDC, 0xC6, 0x10,
  // "Ş" (U+015E)
  0x28, 0x37, 0xCC, 0xD7, 0x28, 0x94, 0x5F, 0x30, 0xAF, 0x10, 0x9F, 0x30, 0x33, 0x28, 0x26, 0xFD,
  0x55, 0x0A, 0xA0, 0x95, 0x85, 0x5E, 0xF4, 0x07, 0xB2, 0x8A, 0x06, 0xF5, 0x0B, 0xF2, 0x06, 0xE2,
  0x02, 0xBD, 0xCB, 0x34, 0x07, 0x09, 0x68, 0x11, 0xE4, 0x48, 0x18, 0xD9, 0x40,
  // "ş" (U+015F)
  0x18, 0x96, 0x4C, 0xCE, 0x60, 0xE9, 0x0A, 0xB0, 0xEE, 0x51, 0x28, 0xA4, 0x4E, 0xFC, 0x01, 0x31,
  0xAF, 0x5B, 0xA0, 0x3F, 0x35, 0xDC, 0xC6, 0x20, 0x70, 0x94, 0x81, 0x1E, 0x42, 0x81, 0x8D, 0x93,
  // "Š" (U+0160)
  0x28, 0x31, 0xD2, 0x89, 0x48, 0x19, 0xFA, 0x75, 0x83, 0x7C, 0xCD, 0x72, 0x89, 0x45, 0xF3, 0x0A,
  0xF1, 0x09, 0xF3, 0x03, 0x32, 0x82, 0x6F, 0xD5, 0x50, 0xAA, 0x09, 0x58, 0x55, 0xEF, 0x40, 0x7B,
  0x28, 0xA0, 0x6F, 0x50, 0xBF, 0x20, 0x6E, 0x20, 0x2B, 0xDB, 0xB3, 0x20,
  // "š" (U+0161)
  0x18, 0x31, 0xD2, 0x89, 0x28, 0x19, 0xFA, 0x71, 0x89, 0x64, 0xCC, 0xE6, 0x0E, 0x90, 0xAB, 0x0E,
  0xE5, 0x12, 0x8A, 0x44, 0xEF, 0xC0, 0x13, 0x1A, 0xF5, 0xBA, 0x03, 0xF3, 0x5D, 0xCC, 0x61,
  // "Ţ" (U+0162)
  0x18, 0x1B, 0xED, 0xA8, 0xA3, 0xDF, 0xB0, 0xD1, 0x2F, 0xC0, 0x58, 0x15, 0x05, 0xF8, 0x02, 0x33,
  0x81, 0x8F, 0x56, 0x81, 0xBF, 0x26, 0x00, 0xE6, 0x81, 0x2F, 0xB6, 0x81, 0x6F, 0x85, 0x09, 0xB0,
  0x65, 0x07, 0x09, 0x78, 0x11, 0xE4, 0x58, 0x18, 0xD9, 0x50,
  // "ţ" (U+0163)
  0x30, 0x62, 0x89, 0x32, 0xAB, 0x02, 0xEF, 0xED, 0x07, 0xF5, 0x28, 0x1A, 0xF2, 0x20, 0xD0, 0xE2,
  0x81, 0x1F, 0xB2, 0x81, 0x2F, 0xA3, 0x85, 0xBF, 0xA2, 0x07, 0x93, 0x85, 0x1E, 0x40, 0x8D, 0x92,
  // "Ť" (U+0164)
  0x38, 0x31, 0xD2, 0x89, 0x58, 0x19, 0xFA, 0x75, 0x81, 0xBE, 0xDA, 0x8A, 0x3D, 0xFB, 0x0D, 0x12,
  0xFC, 0x05, 0x81, 0x50, 0x5F, 0x80, 0x23, 0x38, 0x18, 0xF5, 0x68, 0x1B, 0xF2, 0x60, 0x0E, 0x68,
  0x12, 0xFB, 0x68, 0x16, 0xF8, 0x50, 0x9B, 0x06, 0x30,
  // "ť" (U+0165)
  0x48, 0x11, 0xF4, 0x38, 0x18, 0x78, 0x28, 0x22, 0xBB, 0x12, 0x83, 0x2E, 0xFE, 0xD3, 0x81, 0x7F,
  0x54, 0x81, 0xAF, 0x24, 0x0D, 0x0E, 0x48, 0x11, 0xFB, 0x48, 0x12, 0xFA, 0x58, 0x2B, 0xEA, 0x22,
  // "Ŧ" (U+0166)
  0x81, 0xBE, 0xDA, 0x8A, 0x1D, 0xFB, 0xD1, 0x2F, 0xB0, 0x58, 0x40, 0x5F, 0x80, 0x23, 0x28, 0x18,
  0xF5, 0x30, 0x60, 0xDA, 0x0D, 0x0B, 0x40, 0x0E, 0x58, 0x12, 0xFB, 0x58, 0x16, 0xF8, 0x40, 0x9B,
  0x06, 0x30,
  // "ŧ" (U+0167)
  0x30, 0x62, 0x89, 0x52, 0xAB, 0x02, 0xEF, 0xED, 0x08, 0xF4, 0x08, 0xA8, 0x3D, 0x50, 0xED, 0x28,
  0x11, 0xFB, 0x28, 0x12, 0xFA, 0x38, 0x2A, 0xEA, 0x20,
  // "Ũ" (U+0168)
  0x48, 0x2B, 0xB3, 0xA4, 0x83, 0x63, 0x6D, 0x67, 0x30, 0x9B, 0x06, 0x03, 0xA8, 0x3C, 0x0C, 0xF2,
  0x20, 0x50, 0x92, 0x00, 0xE3, 0x84, 0x85, 0x02, 0xFA, 0x38, 0x4B, 0x20, 0x6F, 0x73, 0x0D, 0x28,
  0x19, 0xF4, 0x20, 0x20, 0xB2, 0x81, 0xCF, 0x12, 0x06, 0x07, 0x28, 0x5A, 0xF4, 0x01, 0xC1, 0x28,
  0x41, 0xAE, 0xDB, 0x33,
  // "ũ" (U+0169)
  0x38, 0x2B, 0xB3, 0xA3, 0x83, 0x63, 0x6D, 0x67, 0x20, 0x3A, 0x8A, 0x28, 0x07, 0xF5, 0x08, 0xF5,
  0x0A, 0xF2, 0x0A, 0xF2, 0x0D, 0xE2, 0x84, 0xDE, 0x01, 0xFB, 0x29, 0x8A, 0x4B, 0x08, 0xF9, 0x02,
  0xFC, 0x5B, 0xF8, 0x10, 0xCE, 0x72, 0xDE, 0x60,
  // "Ū" (U+016A)
  0x38, 0x27, 0xDD, 0xC7, 0x40, 0x9B, 0x06, 0x03, 0xA8, 0x3C, 0x0C, 0xF2, 0x20, 0x50, 0x92, 0x00,
  0xE3, 0x84, 0x85, 0x02, 0xFA, 0x38, 0x4B, 0x20, 0x6F, 0x73, 0x0D, 0x28, 0x19, 0xF4, 0x20, 0x20,
  0xB2, 0x81, 0xCF, 0x12, 0x06, 0x07, 0x28, 0x5A, 0xF4, 0x01, 0xC1, 0x28, 0x41, 0xAE, 0xDB, 0x33,
  // "ū" (U+016B)
  0x38, 0x27, 0xDD, 0xC7, 0x20, 0x3A, 0x8A, 0x28, 0x07, 0xF5, 0x08, 0xF5, 0x0A, 0xF2, 0x0A, 0xF2,
  0x0D, 0xE2, 0x84, 0xDE, 0x01, 0xFB, 0x29, 0x8A, 0x4B, 0x08, 0xF9, 0x02, 0xFC, 0x5B, 0xF8, 0x10,
  0xCE, 0x72, 0xDE, 0x60,
  // "Ŭ" (U+016C)
  0x38, 0x32, 0xB0, 0x84, 0x58, 0x19, 0xD7, 0x74, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22,
  0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81,
  0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84,
  0x1A, 0xED, 0xB3, 0x30,
  // "ŭ" (U+016D)
  0x28, 0x32, 0xB0, 0x84, 0x48, 0x19, 0xD7, 0x73, 0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50,
  0xAF, 0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0, 0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F,
  0xC5, 0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xE6,
  // "Ů" (U+016E)
  0x38, 0x21, 0xCC, 0x25, 0x82, 0x57, 0x57, 0x58, 0x21, 0xCC, 0x22, 0x09, 0xB0, 0x60, 0x3A, 0x83,
  0xC0, 0xCF, 0x22, 0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7,
  0x30, 0xD2, 0x81, 0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40,
  0x1C, 0x12, 0x84, 0x1A, 0xED, 0xB3, 0x30,
  // "ů" (U+016F)
  0x38, 0x21, 0xCC, 0x24, 0x82, 0x57, 0x57, 0x48, 0x41, 0xCC, 0x20, 0x3A, 0x8A, 0x28, 0x07, 0xF5,
  0x08, 0xF5, 0x0A, 0xF2, 0x0A, 0xF2, 0x0D, 0xE2, 0x84, 0xDE, 0x01, 0xFB, 0x29, 0x8A, 0x4B, 0x08,
  0xF9, 0x02, 0xFC, 0x5B, 0xF8, 0x10, 0xCE, 0x72, 0xDE, 0x60,
  // "Ű" (U+0170)
  0x48, 0x3A, 0xB6, 0xE2, 0x38, 0x35, 0xA2, 0xC2, 0x73, 0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF,
  0x22, 0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F, 0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2,
  0x81, 0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20, 0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12,
  0x84, 0x1A, 0xED, 0xB3, 0x30,
  // "ű" (U+0171)
  0x48, 0x3A, 0xB6, 0xE2, 0x38, 0x35, 0xA2, 0xC2, 0x73, 0x03, 0xA8, 0x38, 0x07, 0xF5, 0x28, 0x58,
  0xF5, 0x0A, 0xF2, 0x28, 0x4A, 0xF2, 0x0D, 0xE3, 0x84, 0xDE, 0x01, 0xFB, 0x39, 0x83, 0xB0, 0x8F,
  0x92, 0x86, 0x2F, 0xC5, 0xBF, 0x81, 0x28, 0x5C, 0xE7, 0x2D, 0xE6, 0x10,
  // "Ų" (U+0172)
  0x09, 0xB0, 0x60, 0x3A, 0x83, 0xC0, 0xCF, 0x22, 0x05, 0x09, 0x20, 0x0E, 0x38, 0x48, 0x50, 0x2F,
  0xA3, 0x84, 0xB2, 0x06, 0xF7, 0x30, 0xD2, 0x81, 0x9F, 0x42, 0x02, 0x0B, 0x28, 0x1C, 0xF1, 0x20,
  0x60, 0x72, 0x85, 0xAF, 0x40, 0x1C, 0x12, 0x84, 0x1A, 0xED, 0xB3, 0x48, 0x11, 0xB4, 0x60, 0x70,
  0xD7, 0x82, 0x3D, 0xD1, 0x40,
  // "ų" (U+0173)
  0x03, 0xA8, 0xA2, 0x80, 0x7F, 0x50, 0x8F, 0x50, 0xAF, 0x20, 0xAF, 0x20, 0xDE, 0x28, 0x4D, 0xE0,
  0x1F, 0xB2, 0x98, 0xA4, 0xB0, 0x8F, 0x90, 0x2F, 0xC5, 0xBF, 0x81, 0x0C, 0xE7, 0x2D, 0xF6, 0x48,
  0x11, 0xB4, 0x50, 0x70, 0xD6, 0x82, 0x3D, 0xD1,
  // "Ŵ" (U+0174)
  0x58, 0x15, 0xFD, 0x72, 0x83, 0x4C, 0x29, 0x67, 0x73, 0x0D, 0xA0, 0xE2, 0x89, 0x0B, 0x60, 0x2E,
  0xFD, 0x1F, 0xD2, 0x81, 0x3F, 0x92, 0x06, 0x0B, 0x29, 0x0E, 0x28, 0x1B, 0xFB, 0x20, 0xC0, 0x32,
  0x89, 0x0D, 0xF0, 0x3C, 0xED, 0x03, 0xB3, 0x89, 0x0C, 0xF0, 0xA5, 0xCF, 0x0A, 0x43, 0x87, 0xBF,
  0x4C, 0x0A, 0xF4, 0xC4, 0x87, 0x9F, 0xC5, 0x08, 0xFB, 0x54, 0x81, 0x8F, 0xC2, 0x81, 0x6F, 0xD5,
  0x81, 0x7F, 0x52, 0x81, 0x3F, 0x64,
  // "ŵ" (U+0175)
  0x58, 0x15, 0xFD, 0x78, 0x34, 0xC2, 0x96, 0x76, 0x06, 0xA2, 0x89, 0x1B, 0xF0, 0x4E, 0x10, 0xBF,
  0x01, 0xA1, 0x89, 0x31, 0xF2, 0x09, 0xF0, 0x7B, 0xF1, 0x0D, 0x28, 0x79, 0xF1, 0xB7, 0xF2, 0x57,
  0x28, 0x69, 0xF6, 0x66, 0xF3, 0xB3, 0x86, 0x8F, 0xB0, 0x6F, 0xC3, 0x38, 0x58, 0xF4, 0x06, 0xF7,
  0x30,
  // "Ŷ" (U+0176)
  0x38, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x74, 0x0D, 0xA8, 0x1D, 0x0A, 0xA8, 0x25, 0x1F, 0xE3,
  0x0D, 0x04, 0x28, 0x4B, 0xF2, 0x07, 0x73, 0x83, 0x7F, 0x62, 0xB4, 0x83, 0x2F, 0xAB, 0x15, 0x81,
  0xDF, 0x56, 0x00, 0xE6, 0x81, 0x3F, 0xC5, 0x08, 0xB0, 0xB4,
  // "ŷ" (U+0177)
  0x48, 0x15, 0xFD, 0x58, 0x34, 0xC2, 0x96, 0x75, 0x85, 0xEF, 0x90, 0x2E, 0x62, 0x85, 0x1F, 0xD0,
  0x1B, 0x93, 0x84, 0xCF, 0x10, 0xA5, 0x38, 0x38, 0xF4, 0x0C, 0x48, 0x34, 0xF7, 0x75, 0x59, 0x0C,
  0x0B, 0x68, 0x1B, 0xE2, 0x60, 0xC0, 0x65, 0x81, 0x2C, 0x84, 0x82, 0xCD, 0xC5, 0x50,
  // "Ÿ" (U+0178)
  0x38, 0x39, 0x51, 0xB1, 0x48, 0x3B, 0x62, 0xD2, 0x73, 0x0D, 0xA8, 0x1D, 0x0A, 0xA8, 0x25, 0x1F,
  0xE3, 0x0D, 0x04, 0x28, 0x4B, 0xF2, 0x07, 0x73, 0x83, 0x7F, 0x62, 0xB4, 0x83, 0x2F, 0xAB, 0x15,
  0x81, 0xDF, 0x56, 0x00, 0xE6, 0x81, 0x3F, 0xC5, 0x08, 0xB0, 0xB4,
  // "Ź" (U+0179)
  0x58, 0x18, 0xE4, 0x58, 0x15, 0xC2, 0x76, 0x98, 0x1D, 0xCC, 0xA8, 0x25, 0x04, 0xB2, 0x81, 0x8F,
  0xA2, 0x84, 0x44, 0x05, 0xFD, 0x58, 0x22, 0xEE, 0x25, 0x81, 0xDF, 0x55, 0x81, 0xAF, 0x85, 0x81,
  0x7F, 0xB2, 0x85, 0x43, 0x03, 0xFD, 0x12, 0x87, 0xC3, 0x0D, 0xFD, 0xCC, 0xE9, 0x20,
  // "ź" (U+017A)
  0x48, 0x18, 0xE4, 0x38, 0x15, 0xC2, 0x72, 0x81, 0xDE, 0xDA, 0x85, 0x42, 0xB0, 0x5F, 0xA3, 0x81,
  0x1E, 0xD4, 0x81, 0xCF, 0x33, 0x8A, 0x18, 0xF7, 0x03, 0x04, 0xFB, 0x01, 0xC0, 0xDF, 0xDD, 0xE9,
  0x10,
  // "Ż" (U+017B)
  0x48, 0x12, 0xB6, 0x68, 0x14, 0xE6, 0x76, 0x98, 0x1D, 0xCC, 0xA8, 0x25, 0x04, 0xB2, 0x81, 0x8F,
  0xA2, 0x84, 0x44, 0x05, 0xFD, 0x58, 0x22, 0xEE, 0x25, 0x81, 0xDF, 0x55, 0x81, 0xAF, 0x85, 0x81,
  0x7F, 0xB2, 0x85, 0x43, 0x03, 0xFD, 0x12, 0x87, 0xC3, 0x0D, 0xFD, 0xCC, 0xE9, 0x20,
  // "ż" (U+017C)
  0x28, 0x12, 0xB6, 0x48, 0x14, 0xE6, 0x73, 0x81, 0xDE, 0xDA, 0x85, 0x42, 0xB0, 0x5F, 0xA3, 0x81,
  0x1E, 0xD4, 0x81, 0xCF, 0x33, 0x8A, 0x18, 0xF7, 0x03, 0x04, 0xFB, 0x01, 0xC0, 0xDF, 0xDD, 0xE9,
  0x10,
  // "Ž" (U+017D)
  0x38, 0x31, 0xD2, 0x89, 0x58, 0x19, 0xFA, 0x76, 0x98, 0x1D, 0xCC, 0xA8, 0x25, 0x04, 0xB2, 0x81,
  0x8F, 0xA2, 0x84, 0x44, 0x05, 0xFD, 0x58, 0x22, 0xEE, 0x25, 0x81, 0xDF, 0x55, 0x81, 0xAF, 0x85,
  0x81, 0x7F, 0xB2, 0x85, 0x43, 0x03, 0xFD, 0x12, 0x87, 0xC3, 0x0D, 0xFD, 0xCC, 0xE9, 0x20,
  // "ž" (U+017E)
  0x18, 0x31, 0xD2, 0x89, 0x38, 0x19, 0xFA, 0x73, 0x81, 0xDE, 0xDA, 0x85, 0x42, 0xB0, 0x5F, 0xA3,
  0x81, 0x1E, 0xD4, 0x81, 0xCF, 0x33, 0x8A, 0x18, 0xF7, 0x03, 0x04, 0xFB, 0x01, 0xC0, 0xDF, 0xDD,
  0xE9, 0x10,
  // "ſ" (U+017F)
  0x48, 0x31, 0xAD, 0xE5, 0x48, 0x39, 0xF2, 0xB9, 0x40, 0xE0, 0xD6, 0x81, 0x2F, 0xA6, 0x81, 0x5F,
  0x76, 0x81, 0x8F, 0x46, 0x81, 0xBF, 0x16, 0x0E, 0x0D, 0x68, 0x12, 0xFA, 0x68, 0x15, 0xF7, 0x68,
  0x19, 0xF3, 0x58, 0x11, 0xEB, 0x58, 0x28, 0xE9, 0x15,
  // "Ω" (U+03A9)
  0x38, 0x47, 0xCD, 0xEB, 0x33, 0x89, 0x2C, 0xE3, 0x01, 0xDE, 0x10, 0x7F, 0x83, 0x85, 0x9F, 0x50,
  0xCF, 0x43, 0x85, 0xAF, 0x50, 0xBF, 0x33, 0x85, 0xEE, 0x10, 0x4F, 0x92, 0x8A, 0x79, 0xE4, 0x06,
  0x02, 0xC2, 0xB7, 0x16, 0x0C, 0x75, 0xB1, 0xC5, 0x8B, 0x0D, 0xA0, 0xD0, 0x4B, 0x08, 0x10,
  // "μ" (U+03BC)
  0x18, 0xA3, 0x3F, 0x90, 0x6F, 0x60, 0x6F, 0x50, 0x9F, 0x30, 0x9F, 0x20, 0xC9, 0x20, 0xD0, 0xE2,
  0x90, 0xC2, 0x98, 0xA6, 0xC0, 0x4F, 0x90, 0x4F, 0xD2, 0xBF, 0x92, 0x79, 0xDC, 0x2D, 0xE7, 0xB3,
  0x60, 0xE0, 0x76, 0x0D, 0x0C, 0x60,
  // "π" (U+03C0)
  0x10, 0x60, 0xDC, 0x89, 0x6D, 0x1F, 0xEE, 0xDE, 0xE9, 0x34, 0x84, 0x09, 0x43, 0x83, 0xD1, 0x0E,
  0x12, 0x82, 0x2D, 0x02, 0x93, 0x83, 0xA9, 0x04, 0xE2, 0x86, 0xBD, 0x20, 0x2E, 0xC1,
  // "–" (U+2013)
  0x80, 0x2D, 0x01,
  // "—" (U+2014)
  0x80, 0x90, 0xD0, 0x10,
  // "€" (U+20AC)
  0x38, 0x38, 0xDE, 0xB1, 0x28, 0xA2, 0xBD, 0x16, 0xF3, 0x04, 0xF5, 0x01, 0x20, 0x4E, 0xFD, 0xD4,
  0x30, 0x0D, 0x50, 0x8A, 0x0D, 0x06, 0x49, 0x0B, 0x68, 0x3D, 0xE1, 0x06, 0x38, 0x32, 0xCE, 0xC6,
  0x20,
  // "₿" (U+20BF)
  0x60, 0x15, 0x81, 0x64, 0xA3, 0x0B, 0xA8, 0x1E, 0xD2, 0x39, 0x82, 0x91, 0xFA, 0x28, 0x43, 0xF6,
  0x0F, 0xA2, 0x84, 0x6F, 0x35, 0xF4, 0x28, 0x39, 0xFE, 0xF7, 0x38, 0x4D, 0xD0, 0x9F, 0x12, 0x98,
  0x94, 0x90, 0x6F, 0x20, 0x4F, 0x60, 0xBE, 0x06, 0xA8, 0x2E, 0xEC, 0x33, 0x81, 0x64, 0xA3,
  // "‘" (U+2018)
  0x18, 0x91, 0x38, 0x3B, 0x09, 0xE1, 0x6E, 0x20,
  // "’" (U+2019)
  0x89, 0x12, 0xE6, 0x1D, 0x90, 0xB4, 0x84, 0x10,
  // "‚" (U+201A)
  0x18, 0x94, 0x5E, 0x30, 0x3F, 0x50, 0x1D, 0x11, 0x92, 0x10,
  // "‛" (U+201B)
  0x86, 0x1D, 0x86, 0xE4, 0x49, 0x20, 0x80, 0x30,
  // "“" (U+201C)
  0x18, 0xA4, 0x38, 0x08, 0x43, 0xB0, 0xB4, 0x09, 0xE2, 0xF7, 0x06, 0xE3, 0xD9, 0x10,
  // "”" (U+201D)
  0x8A, 0x42, 0xE6, 0x8D, 0x01, 0xD9, 0x7F, 0x10, 0xB4, 0x4B, 0x08, 0x43, 0x82,
  // "„" (U+201E)
  0x8A, 0x14, 0xE4, 0xBB, 0x2F, 0x7A, 0xE0, 0xD1, 0x68, 0x92, 0x57, 0x10,
  // "‟" (U+201F)
  0x89, 0x71, 0xD8, 0x1D, 0x86, 0xE4, 0x6E, 0x44, 0x90, 0x49, 0x28, 0x38, 0x30, 0x83,
  // "†" (U+2020)
  0x20, 0x90, 0xB3, 0x89, 0x69, 0x60, 0x65, 0xB5, 0x7C, 0xAE, 0xAC, 0x06, 0xE3, 0x0A, 0x0D, 0x30,
  0xB0, 0x73, 0x0D, 0x02, 0x30, 0xC3, 0x01, 0x09, 0x30, 0x40, 0x63,
  // "‡" (U+2021)
  0x30, 0x90, 0xB3, 0x8A, 0x12, 0x18, 0x52, 0x10, 0xCE, 0xED, 0xF1, 0x01, 0x2F, 0x01, 0x30, 0x50,
  0xC5, 0x03, 0x05, 0x50, 0xB0, 0x75, 0x0E, 0x04, 0x38, 0x3E, 0xDE, 0xDD, 0x28, 0x34, 0x4A, 0x23,
  0x30, 0x90, 0xA4,
  // "•" (U+2022)
  0x83, 0x6E, 0xC1, 0xEA, 0x06, 0xB8, 0x25, 0x8E, 0xB1,
  // "…" (U+2026)
  0x84, 0x3E, 0x40, 0x7D, 0x28, 0x6C, 0x83, 0xE3, 0x08, 0xC2, 0x0D, 0x07,
  // "‰" (U+2030)
  0x28, 0x19, 0xEB, 0x20, 0x30, 0xA7, 0x18, 0x67, 0xC0, 0xE4, 0x0C, 0x17, 0x18, 0x5D, 0x60, 0xE4,
  0x85, 0x71, 0x89, 0x01, 0xF3, 0x2F, 0x5A, 0x8D, 0xA2, 0x8C, 0x2A, 0xD8, 0x01, 0xF3, 0x9A, 0xC9,
  0xC0, 0xF3, 0x9B, 0x2F, 0x10, 0x7D, 0xA9, 0x5D, 0x60, 0xE5, 0xF4, 0x1F, 0x23, 0x89, 0x23, 0xB1,
  0xF3, 0x2F, 0x4F, 0x14, 0xE4, 0x89, 0x2C, 0x11, 0xF3, 0x9A, 0x3F, 0x1B, 0x83, 0x08, 0x06, 0x28,
  0x19, 0xEB, 0x28, 0x1A, 0xEA, 0x20,
  // "‹" (U+2039)
  0x28, 0x76, 0x90, 0x7D, 0x02, 0xF5, 0x20, 0xC0, 0x82, 0x03, 0x0C, 0x10,
  // "›" (U+203A)
  0x10, 0x90, 0x62, 0x89, 0x34, 0xE1, 0x02, 0xF6, 0x0A, 0xA0, 0x69, 0x20,
  // "⁄" (U+2044)
  0x50, 0x60, 0x84, 0x02, 0x0C, 0x50, 0xB0, 0x34, 0x07, 0x08, 0x40, 0x20, 0xC5, 0x0C, 0x03, 0x40,
  0x70, 0x84, 0x03, 0x0C, 0x50, 0xC0, 0x35,
  // "™" (U+2122)
  0x84, 0x67, 0x77, 0x76, 0x28, 0x91, 0xA2, 0x24, 0x62, 0x5B, 0x04, 0xC2, 0x86, 0x46, 0x05, 0x74,
  0x5B, 0x28, 0x64, 0x60, 0x51, 0xB3, 0xB2, 0x87, 0x67, 0x07, 0x36, 0x19, 0x20,
  // "⅒" (U+2152)
  0x20, 0x20, 0x12, 0x06, 0x08, 0x68, 0x51, 0x8F, 0x40, 0x2C, 0x71, 0x84, 0x3F, 0x10, 0xB3, 0x71,
  0x83, 0x5D, 0x07, 0x87, 0x28, 0x29, 0x92, 0xC2, 0x8A, 0x32, 0x10, 0x49, 0x80, 0x7B, 0xAF, 0x31,
  0x8F, 0x42, 0xE1, 0xC4, 0x20, 0x70, 0x82, 0x89, 0x13, 0xF1, 0x99, 0x0D, 0x40, 0x3C, 0x38, 0x91,
  0x5D, 0x0B, 0x61, 0xF1, 0x0C, 0x33, 0x85, 0x99, 0x0B, 0x57, 0xA6, 0x85, 0x7B, 0xA3, 0x39, 0x82,
  // "ﬁ" (U+FB01)
  0x58, 0x37, 0xDE, 0xD7, 0x48, 0x47, 0xF4, 0x1F, 0xC4, 0x0E, 0x0D, 0x20, 0x23, 0x86, 0x2C, 0xFE,
  0xDE, 0xF7, 0x38, 0x55, 0xF7, 0x08, 0xF4, 0x38, 0x58, 0xF3, 0x0B, 0xF1, 0x38, 0x4B, 0xF1, 0x0E,
  0xE4, 0x84, 0xED, 0x01, 0xFB, 0x38, 0x52, 0xFA, 0x03, 0xF9, 0x38, 0x15, 0xF7, 0x28, 0x1C, 0xE8,
  0x28, 0x19, 0xF3, 0x68, 0x11, 0xEB, 0x68, 0x28, 0xE9, 0x16,
  // "ﬂ" (U+FB02)
  0x58, 0x47, 0xDE, 0xBD, 0x34, 0x82, 0x7F, 0x41, 0xA5, 0x0E, 0x0D, 0x29, 0x0C, 0x38, 0x62, 0xCF,
  0xED, 0x3F, 0x94, 0x85, 0x5F, 0x70, 0x6F, 0x64, 0x85, 0x8F, 0x30, 0x9F, 0x34, 0x83, 0xBF, 0x10,
  0xC9, 0x50, 0xE0, 0xD2, 0x90, 0xD4, 0x85, 0x2F, 0xA0, 0x1F, 0xB4, 0x81, 0x5F, 0x72, 0x81, 0xBE,
  0x93, 0x81, 0x9F, 0x37, 0x81, 0x1E, 0xB7, 0x82, 0x8E, 0x91, 0x70,
};

const Font& font_NotoSerif_BoldItalic_12() {
  static SmoothFont font(font_NotoSerif_BoldItalic_12_data);
  return font;
}

}  // namespace roo_display
