#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Regular (Noto Sans Regular)
// Generated on Thu Mar 30 23:07:00 CEST 2023
static const uint8_t font_NotoSans_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xE0,
  0xFE, 0xFE, 0x08, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x09, 0x04, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x05, 0x02, 0x07, 0x03, 0x00, 0x09, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x0F, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x04, 0x07, 0x05, 0x00, 0x23, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x07, 0x07, 0x00, 0x37, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x05, 0x07, 0x06, 0x00, 0x54, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x07, 0x02, 0x00, 0x6B, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x01, 0x07, 0x02, 0x00, 0x6E, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x01, 0x07, 0x02, 0x00, 0x78, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x04, 0x00, 0x82, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x8C, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x02, 0x00, 0x95, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 0x99, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0x9C, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x00, 0x9E, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xA9, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x02, 0x07, 0x05, 0x00, 0xBD, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xC9, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x03, 0x07, 0x05, 0x00, 0xDC, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xEB, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x03, 0x07, 0x05, 0x00, 0xFF, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x0F, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x22, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x33, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x47, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x5A, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x5F, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x65, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x05, 0x01, 0x70, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x78, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x03, 0x01, 0x82, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x06, 0x07, 0x07, 0x01, 0x90, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xAE, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xC1, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD4, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x07, 0x06, 0x01, 0xE6, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0xFF, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x10, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x21, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x38, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x52, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0x00, 0x01, 0x07, 0x02, 0x02, 0x5E, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x6C, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x80, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x06, 0x07, 0x07, 0x02, 0x92, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xAC, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xC4, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xDC, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xEE, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x0B, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x1E, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x04, 0x03, 0x2E, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x07, 0x06, 0x03, 0x40, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x59, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x07, 0x07, 0x07, 0x03, 0x6D, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x8B, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x9F, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xB2, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x03, 0xC6, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x03, 0xD4, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x00, 0x01, 0x07, 0x03, 0x03, 0xE0, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x05, 0x03, 0xEA, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x03, 0xFF, 0x04, 0x03, 0xF6, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x07, 0x01, 0x08, 0x02, 0x03, 0xF9, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0xFC, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x08, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x1B, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x27, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x39, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x02, 0x07, 0x03, 0x04, 0x47, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x53, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x66, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x79, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x82, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x04, 0x90, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0xA1, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x05, 0x07, 0x04, 0xAA, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xBD, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xCB, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xD9, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xEB, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x05, 0x03, 0x04, 0xFE, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x0A, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x03, 0x05, 0x15, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x20, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x2E, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x06, 0x05, 0x06, 0x05, 0x3A, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x4E, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x05, 0x5A, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x6A, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x05, 0x76, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x84, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x00, 0x02, 0x07, 0x03, 0x05, 0x8F, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x04, 0x04, 0x05, 0x05, 0x9D, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x00, 0x01, 0x05, 0x02, 0x05, 0xA3, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x05, 0x05, 0xAB, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x05, 0xBB, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x03, 0x05, 0x05, 0x05, 0xCD, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x05, 0xD7, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xEB, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0xF4, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x05, 0x06, 0x05, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x08, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x23, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0x29, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x06, 0x33, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x3B, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x03, 0x08, 0x04, 0x06, 0x55, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x06, 0x57, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x05, 0x05, 0x06, 0x5D, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x6A, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x72, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x07, 0x01, 0x08, 0x02, 0x06, 0x7A, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x7D, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x06, 0x8F, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x01, 0x03, 0x02, 0x06, 0xAA, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x06, 0xAC, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x01, 0x07, 0x03, 0x06, 0xB0, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xB5, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0xBB, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0xC5, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0xDE, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x07, 0x06, 0x06, 0xF6, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFE, 0x02, 0x04, 0x03, 0x07, 0x11, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x1F, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x37, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x4E, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x66, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x7A, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x90, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x06, 0x07, 0x07, 0x07, 0xA4, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x07, 0xBF, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x03, 0x09, 0x04, 0x07, 0xD7, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x03, 0x09, 0x04, 0x07, 0xED, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x03, 0x09, 0x04, 0x08, 0x01, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0x16, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x29, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x39, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x48, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x02, 0x08, 0x03, 0x08, 0x58, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x66, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x7F, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0x96, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xB3, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xCF, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xED, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x05, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x09, 0x20, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0x2A, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x41, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x60, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x7E, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x9D, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x05, 0x09, 0xB9, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xD1, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xE3, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0xF6, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x07, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x17, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0A, 0x27, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x35, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x44, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x05, 0x07, 0x0A, 0x55, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0x68, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x79, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x8C, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x9E, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xB1, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x01, 0x08, 0x02, 0x0A, 0xC2, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x01, 0x08, 0x02, 0x0A, 0xCC, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x01, 0x08, 0x02, 0x0A, 0xD6, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0A, 0xE3, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xEF, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x06, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x17, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x2B, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x3D, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x51, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x62, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0B, 0x73, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0B, 0x7D, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x8B, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x9F, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xB2, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xC6, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x0B, 0xD8, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xED, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x04, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x18, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0C, 0x2C, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x3A, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x50, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x5F, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0C, 0x75, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x84, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x9A, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xAA, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xC2, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xD3, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0xE7, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xF5, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x0D, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x1E, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x3D, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0D, 0x53, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x6C, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x7E, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x8F, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0xA0, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xB2, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0xC4, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xD7, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0xE7, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0D, 0xFC, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0E, 0x0E, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x24, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x38, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0x54, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x6D, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x85, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x9D, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xB5, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x0E, 0xCA, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xE5, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xFB, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x1B, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0F, 0x37, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x51, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x65, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x06, 0x02, 0x0F, 0x73, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x82, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0F, 0x8E, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0F, 0x99, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0F, 0xA6, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0xB2, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x0F, 0xC1, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0F, 0xCC, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x0F, 0xDA, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0F, 0xE1, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0F, 0xF7, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0x00, 0x01, 0x09, 0x02, 0x10, 0x0A, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x01, 0x08, 0x02, 0x10, 0x1B, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x2B, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0x43, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x03, 0x05, 0x04, 0x10, 0x58, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0x64, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x01, 0x0A, 0x02, 0x10, 0x7B, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0x87, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x10, 0x9D, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0xA8, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x02, 0x07, 0x02, 0x10, 0xBA, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0xC6, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x01, 0x07, 0x02, 0x10, 0xD8, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0xE1, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x01, 0x07, 0x02, 0x10, 0xF3, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x09, 0x06, 0x10, 0xFA, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x16, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x11, 0x29, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0x45, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0x57, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x75, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x07, 0x06, 0x11, 0x8A, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x11, 0x9F, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xBC, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x07, 0x06, 0x11, 0xD0, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x11, 0xE8, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0xF9, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x12, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x25, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x40, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x06, 0x07, 0x07, 0x12, 0x53, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x07, 0x05, 0x08, 0x12, 0x6F, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x84, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x03, 0x12, 0x9B, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xAC, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFF, 0x03, 0x05, 0x03, 0x12, 0xC3, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xD3, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x08, 0x03, 0x12, 0xEC, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x12, 0xFD, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x11, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x09, 0x04, 0x13, 0x21, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x35, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x13, 0x45, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x5A, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x03, 0x09, 0x04, 0x13, 0x6A, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x7F, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x13, 0x8F, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x13, 0xA6, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x04, 0x13, 0xB4, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x03, 0x07, 0x03, 0x13, 0xCC, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x07, 0x04, 0x13, 0xDD, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x03, 0x13, 0xF0, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x07, 0x06, 0x13, 0xFB, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x14, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x07, 0x06, 0x14, 0x25, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x3E, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0x4F, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x6A, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0x7C, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x98, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0xAC, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xC8, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x14, 0xDB, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x14, 0xF8, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x09, 0x07, 0x15, 0x0A, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x06, 0x15, 0x2E, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x48, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x15, 0x61, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x76, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x8C, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x15, 0xA4, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xB5, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x15, 0xCB, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0xD9, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x08, 0x04, 0x15, 0xF3, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x16, 0x04, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x05, 0x07, 0x06, 0x16, 0x10, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x16, 0x28, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x16, 0x3A, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x04, 0x16, 0x48, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x16, 0x4B, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x16, 0x4F, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x08, 0x05, 0x16, 0x61, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x05, 0x01, 0x07, 0x01, 0x16, 0x7A, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x05, 0x01, 0x07, 0x01, 0x16, 0x7E, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x00, 0x01, 0x02, 0x02, 0x16, 0x82, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x06, 0x01, 0x07, 0x01, 0x16, 0x86, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x05, 0x02, 0x07, 0x03, 0x16, 0x89, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x05, 0x02, 0x07, 0x03, 0x16, 0x8F, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x02, 0x02, 0x03, 0x16, 0x95, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x05, 0x02, 0x07, 0x03, 0x16, 0x9B, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0xA1, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0xB1, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x04, 0x03, 0x16, 0xC1, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x01, 0x06, 0x16, 0xC5, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x08, 0x07, 0x09, 0x16, 0xC9, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x01, 0x04, 0x02, 0x16, 0xEA, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x01, 0x04, 0x02, 0x16, 0xEF, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x16, 0xF4, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x05, 0x06, 0x06, 0x17, 0x02, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x08, 0x17, 0x10, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x04, 0x07, 0x05, 0x17, 0x2D, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x04, 0x07, 0x05, 0x17, 0x40, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x05, 0x74, 0x64, 0x63, 0x52, 0x42, 0x03, 0x04,
  // """ (U+0022)
  0x84, 0x63, 0xA5, 0x28, 0x20, 0x10,
  // "#" (U+0023)
  0x18, 0xB2, 0x17, 0x52, 0x03, 0x57, 0x05, 0xDC, 0xDB, 0x08, 0x08, 0x09, 0xDB, 0xD8, 0x08, 0x26,
  0x28, 0x18, 0x53, 0x10,
  // "$" (U+0024)
  0x20, 0x82, 0x86, 0x3C, 0xDA, 0x07, 0x47, 0x28, 0x12, 0xCA, 0x48, 0x92, 0xBB, 0x01, 0x07, 0xA1,
  0x4B, 0xD6, 0x30, 0x32,
  // "%" (U+0025)
  0x83, 0x3C, 0x40, 0x82, 0x83, 0x81, 0x91, 0x72, 0x83, 0x80, 0x97, 0x12, 0x89, 0x47, 0x19, 0x89,
  0xA0, 0x2B, 0xA3, 0x86, 0x22, 0x89, 0x19, 0x18, 0x53, 0x05, 0x40, 0xAB, 0x10,
  // "&" (U+0026)
  0x18, 0x19, 0xC6, 0x38, 0x1B, 0x0B, 0x38, 0x1B, 0x39, 0x30, 0x80, 0xD3, 0x8A, 0x04, 0x97, 0x76,
  0x48, 0x30, 0x8C, 0x02, 0xCB, 0x98, 0x60,
  // "'" (U+0027)
  0x82, 0x63, 0x52,
  // "(" (U+0028)
  0x18, 0x95, 0xA4, 0x78, 0x3A, 0x1A, 0x08, 0x24, 0x70, 0xA0,
  // ")" (U+0029)
  0x89, 0x67, 0x31, 0x90, 0xB0, 0xA0, 0xA0, 0xB1, 0xA7, 0x30,
  // "*" (U+002A)
  0x18, 0x95, 0x28, 0x05, 0x69, 0x81, 0x8C, 0x20, 0xA6, 0x40,
  // "+" (U+002B)
  0x20, 0x82, 0x83, 0x6B, 0xDB, 0x12, 0x08, 0x40, 0x82,
  // "," (U+002C)
  0x18, 0x31, 0x55, 0x81,
  // "-" (U+002D)
  0x81, 0x8B, 0x20,
  // "." (U+002E)
  0x03, 0x04,
  // "/" (U+002F)
  0x28, 0x97, 0xA0, 0x36, 0x08, 0x20, 0xA0, 0x28, 0x07, 0x30, 0xA2,
  // "0" (U+0030)
  0x18, 0xB2, 0xBB, 0x50, 0x56, 0x0B, 0x08, 0x20, 0x91, 0x91, 0x08, 0x28, 0x20, 0x91, 0x56, 0x0B,
  0x28, 0x1A, 0xC5, 0x10,
  // "1" (U+0031)
  0x18, 0x34, 0xC1, 0x9A, 0x20, 0xA2, 0x0A, 0x20, 0xA2, 0x0A, 0x20, 0xA0,
  // "2" (U+0032)
  0x87, 0x2B, 0xC5, 0x02, 0x10, 0xB4, 0x0B, 0x30, 0x50, 0x62, 0x02, 0x0A, 0x20, 0x10, 0xA3, 0x83,
  0x8D, 0xBB, 0x10,
  // "3" (U+0033)
  0x83, 0x4B, 0xC6, 0x12, 0x0B, 0x28, 0x41, 0xA0, 0x9E, 0x53, 0x0B, 0x38, 0x3B, 0x7B, 0xC6,
  // "4" (U+0034)
  0x20, 0x60, 0x93, 0x0B, 0x09, 0x28, 0x16, 0x59, 0x28, 0x94, 0x91, 0x90, 0x73, 0x19, 0x0A, 0xBB,
  0xD4, 0x20, 0x10, 0x91,
  // "5" (U+0035)
  0x84, 0x2D, 0xB8, 0x36, 0x20, 0x40, 0x52, 0x82, 0x4C, 0xB6, 0x30, 0xB3, 0x83, 0xB5, 0xBB, 0x60,
  // "6" (U+0036)
  0x18, 0x45, 0xC9, 0x02, 0xB3, 0x06, 0x05, 0x38, 0xA1, 0x88, 0xB7, 0x08, 0x50, 0xA1, 0x55, 0x09,
  0x10, 0xAB, 0x81,
  // "7" (U+0037)
  0x83, 0x7B, 0xBE, 0x23, 0x0B, 0x30, 0x30, 0x73, 0x09, 0x02, 0x30, 0xB3, 0x05, 0x06, 0x30, 0xA0,
  0x12,
  // "8" (U+0038)
  0x89, 0x41, 0xBC, 0x70, 0x55, 0x0B, 0x03, 0x92, 0x92, 0x8A, 0x0B, 0xD4, 0x06, 0x40, 0xA0, 0x82,
  0x09, 0x12, 0xBB, 0x81,
  // "9" (U+0039)
  0x18, 0xA5, 0xBC, 0x50, 0x64, 0x0B, 0x08, 0x10, 0x91, 0x74, 0x0C, 0x11, 0xAB, 0xA3, 0x85, 0x19,
  0x02, 0xBB, 0x11,
  // ":" (U+003A)
  0x03, 0x04, 0x60, 0x30, 0x40,
  // ";" (U+003B)
  0x03, 0x04, 0x58, 0x21, 0x74, 0x81,
  // "<" (U+003C)
  0x28, 0x91, 0x17, 0x11, 0x77, 0x10, 0x59, 0x34, 0x81, 0x59, 0x10,
  // "=" (U+003D)
  0x83, 0x6B, 0xBB, 0x15, 0x83, 0x6B, 0xBB, 0x10,
  // ">" (U+003E)
  0x05, 0x04, 0x48, 0x14, 0x84, 0x38, 0x46, 0x91, 0x58, 0x22,
  // "?" (U+003F)
  0x81, 0x9B, 0xA3, 0x07, 0x03, 0x28, 0x39, 0x20, 0x48, 0x20, 0xA3, 0x03, 0x30, 0x82,
  // "@" (U+0040)
  0x18, 0x31, 0xAB, 0xB6, 0x20, 0xA0, 0x22, 0x8B, 0x77, 0x43, 0x54, 0xCC, 0x08, 0x61, 0xA0, 0x90,
  0x87, 0x1A, 0x0B, 0x18, 0x53, 0x6B, 0x5B, 0x21, 0xB1, 0x58, 0x32, 0xAB, 0xA1, 0x10,
  // "A" (U+0041)
  0x20, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB, 0xD4, 0x83, 0x01,
  0x9B, 0x30, 0xB0,
  // "B" (U+0042)
  0x8C, 0x13, 0xDB, 0xB2, 0x37, 0x04, 0x83, 0x70, 0x56, 0x3D, 0xBD, 0x13, 0x70, 0x29, 0x37, 0x01,
  0xA3, 0xDB, 0xC3,
  // "C" (U+0043)
  0x18, 0x44, 0xCC, 0x81, 0xB3, 0x06, 0x05, 0x30, 0x70, 0x43, 0x06, 0x05, 0x30, 0x20, 0xB4, 0x82,
  0x6C, 0xB6,
  // "D" (U+0044)
  0x89, 0x43, 0xDB, 0xB3, 0x03, 0x70, 0x1C, 0x03, 0x72, 0x82, 0x84, 0x37, 0x28, 0x26, 0x53, 0x72,
  0x89, 0x38, 0x33, 0x70, 0x2C, 0x03, 0xDB, 0xB2, 0x10,
  // "E" (U+0045)
  0x84, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30, 0x72, 0x82, 0x3D,
  0xBB,
  // "F" (U+0046)
  0x84, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30, 0x72, 0x03, 0x07,
  0x20,
  // "G" (U+0047)
  0x18, 0x64, 0xBB, 0xB0, 0x1C, 0x13, 0x06, 0x05, 0x48, 0x67, 0x40, 0x8C, 0x36, 0x62, 0x82, 0x73,
  0x2C, 0x28, 0x67, 0x30, 0x5C, 0xBC, 0x20,
  // "H" (U+0048)
  0x03, 0x07, 0x28, 0x29, 0x23, 0x72, 0x82, 0x92, 0x37, 0x28, 0x90, 0x92, 0x3D, 0xBB, 0xD2, 0x37,
  0x28, 0x29, 0x23, 0x72, 0x82, 0x92, 0x37, 0x20, 0x90, 0x20,
  // "I" (U+0049)
  0x83, 0x7E, 0x30, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x28, 0x3B, 0x06, 0xD3,
  // "J" (U+004A)
  0x18, 0xA5, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x56, 0x7B, 0x10,
  // "K" (U+004B)
  0x8A, 0x03, 0x70, 0x57, 0x37, 0x1A, 0x03, 0x8A, 0x10, 0x3D, 0xC2, 0x89, 0x53, 0x86, 0x60, 0x37,
  0x0B, 0x13, 0x70, 0x39,
  // "L" (U+004C)
  0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x82,
  0x3D, 0xBB,
  // "M" (U+004D)
  0x03, 0x0E, 0x38, 0xD2, 0xB7, 0x3C, 0x40, 0x1C, 0x73, 0x89, 0x05, 0x87, 0x36, 0xA0, 0x94, 0x73,
  0x67, 0x39, 0x37, 0x36, 0x2C, 0x53, 0x73, 0x60, 0xD1, 0x37,
  // "N" (U+004E)
  0x03, 0x0D, 0x28, 0xC0, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36, 0x6C, 0x64, 0x36, 0x0D,
  0xC4, 0x36, 0x05, 0xF4, 0x36, 0x20, 0xC0, 0x40,
  // "O" (U+004F)
  0x18, 0x55, 0xCC, 0x80, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38, 0x1B, 0x65, 0x28,
  0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "P" (U+0050)
  0x8B, 0x13, 0xDB, 0xA0, 0x37, 0x08, 0x43, 0x70, 0x56, 0x37, 0x09, 0x33, 0xDB, 0x70, 0x37, 0x30,
  0x30, 0x73,
  // "Q" (U+0051)
  0x18, 0x55, 0xCC, 0x80, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38, 0x1B, 0x65, 0x28,
  0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x94, 0x04, 0x09, 0x50, 0x50, 0x10,
  // "R" (U+0052)
  0x8C, 0x13, 0xDB, 0xB0, 0x37, 0x06, 0x53, 0x70, 0x74, 0x3D, 0xC9, 0x03, 0x71, 0xA0, 0x37, 0x0A,
  0x23, 0x70, 0x39,
  // "S" (U+0053)
  0x84, 0x1B, 0xB9, 0x64, 0x20, 0x50, 0x83, 0x81, 0x7C, 0x32, 0x01, 0x0C, 0x38, 0x3B, 0x7B, 0xB5,
  // "T" (U+0054)
  0x86, 0xAC, 0xDB, 0x40, 0x29, 0x30, 0x20, 0x93, 0x02, 0x09, 0x30, 0x20, 0x93, 0x02, 0x09, 0x30,
  0x20, 0x92,
  // "U" (U+0055)
  0x04, 0x06, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x47,
  0x28, 0x29, 0x11, 0xA2, 0x0B, 0x28, 0x26, 0xBC, 0x51,
  // "V" (U+0056)
  0x0B, 0x28, 0x96, 0x1A, 0x82, 0x05, 0x54, 0x70, 0xA1, 0x0B, 0x0B, 0x28, 0x1A, 0x47, 0x28, 0x16,
  0xC3, 0x20, 0x10, 0xD2,
  // "W" (U+0057)
  0x0B, 0x28, 0xB2, 0xC2, 0x08, 0x39, 0x20, 0xD6, 0x0A, 0x05, 0x54, 0x7A, 0x0B, 0x02, 0x88, 0x2A,
  0x28, 0x28, 0x4A, 0xA0, 0x87, 0x52, 0x84, 0xA9, 0x04, 0xD2, 0x20, 0x07, 0x20, 0xD2,
  // "X" (U+0058)
  0x87, 0x93, 0x07, 0x31, 0xA0, 0xA2, 0x81, 0x8A, 0x32, 0x03, 0x0D, 0x38, 0x94, 0x97, 0x50, 0x28,
  0x0B, 0x0A, 0x10, 0x66,
  // "Y" (U+0059)
  0x87, 0xB1, 0x08, 0x45, 0x81, 0xC2, 0x81, 0xDA, 0x62, 0x07, 0x0E, 0x30, 0x10, 0xA3, 0x01, 0x09,
  0x30, 0x10, 0x92,
  // "Z" (U+005A)
  0x83, 0x6B, 0xBE, 0x22, 0x01, 0x0A, 0x30, 0x90, 0x32, 0x02, 0x09, 0x30, 0xA0, 0x22, 0x03, 0x08,
  0x38, 0x3A, 0xCB, 0xB3,
  // "[" (U+005B)
  0x8A, 0x65, 0xC5, 0x55, 0x05, 0x50, 0x55, 0x05, 0x50, 0x55, 0x05, 0x50, 0x4C, 0x50,
  // "\" (U+005C)
  0x0A, 0x28, 0x37, 0x30, 0x28, 0x20, 0xA2, 0x83, 0x82, 0x03, 0x62, 0x0A,
  // "]" (U+005D)
  0x89, 0x69, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA9, 0xC0,
  // "^" (U+005E)
  0x10, 0x30, 0x93, 0x89, 0x48, 0x71, 0x01, 0x71, 0x80, 0x72, 0x08, 0x10,
  // "_" (U+005F)
  0x0F, 0x90, 0x50,
  // "`" (U+0060)
  0x82, 0x42, 0x18,
  // "a" (U+0061)
  0x18, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "b" (U+0062)
  0x04, 0x06, 0x30, 0x40, 0x63, 0x8A, 0x64, 0xAB, 0xA0, 0x48, 0x06, 0x54, 0x60, 0x47, 0x48, 0x06,
  0x54, 0x9B, 0xA1,
  // "c" (U+0063)
  0x18, 0x3A, 0xB5, 0x65, 0x20, 0x80, 0x32, 0x06, 0x05, 0x38, 0x1A, 0xB5,
  // "d" (U+0064)
  0x30, 0x70, 0x33, 0x8B, 0x17, 0x30, 0xBB, 0xA3, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31,
  0xBA, 0x93,
  // "e" (U+0065)
  0x18, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA, 0x10,
  // "f" (U+0066)
  0x18, 0xA1, 0xAB, 0x19, 0x09, 0xD7, 0x19, 0x01, 0x90, 0x19, 0x01, 0x91,
  // "g" (U+0067)
  0x18, 0xA6, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBB, 0xA3, 0x38, 0x49,
  0x22, 0xBB, 0x91,
  // "h" (U+0068)
  0x04, 0x06, 0x30, 0x40, 0x63, 0x8A, 0x74, 0xAB, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46, 0x06,
  0x44, 0x60, 0x64,
  // "i" (U+0069)
  0x00, 0x32, 0x89, 0x04, 0x64, 0x64, 0x64, 0x64, 0x60,
  // "j" (U+006A)
  0x10, 0x03, 0x48, 0xA2, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x05, 0x55, 0xC2,
  // "k" (U+006B)
  0x04, 0x05, 0x20, 0x40, 0x52, 0x8A, 0x24, 0x52, 0x94, 0x6A, 0x04, 0xD9, 0x04, 0x69, 0x34, 0x51,
  0xB0,
  // "l" (U+006C)
  0x89, 0x44, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x60,
  // "m" (U+006D)
  0x8C, 0x14, 0x9B, 0x97, 0xC6, 0x48, 0x0A, 0x40, 0xB4, 0x60, 0x91, 0x0A, 0x46, 0x09, 0x10, 0xA4,
  0x60, 0x91, 0x0A,
  // "n" (U+006E)
  0x8A, 0x74, 0x9B, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64,
  // "o" (U+006F)
  0x18, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB, 0x91,
  // "p" (U+0070)
  0x8B, 0x14, 0x9B, 0xA0, 0x48, 0x06, 0x54, 0x60, 0x47, 0x48, 0x07, 0x54, 0xAB, 0xB0, 0x46, 0x30,
  0x40, 0x63,
  // "q" (U+0071)
  0x18, 0xA6, 0xBB, 0x93, 0x65, 0x0A, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBA, 0xA3, 0x30, 0x70,
  0x33, 0x07, 0x03,
  // "r" (U+0072)
  0x84, 0x48, 0xB1, 0x4A, 0x20, 0x40, 0x62, 0x04, 0x06, 0x20, 0x40, 0x62,
  // "s" (U+0073)
  0x84, 0x4C, 0xC3, 0x73, 0x30, 0x70, 0x83, 0x84, 0x56, 0x6B, 0xB2,
  // "t" (U+0074)
  0x8A, 0x01, 0x60, 0x9D, 0x84, 0x60, 0x46, 0x03, 0x70, 0x1C, 0x80,
  // "u" (U+0075)
  0x8A, 0x75, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09, 0x41, 0xCB, 0x94,
  // "v" (U+0076)
  0x0B, 0x28, 0x92, 0xB7, 0x32, 0x82, 0x87, 0x30, 0xAA, 0x20, 0x80, 0x91,
  // "w" (U+0077)
  0x8B, 0x1B, 0x05, 0xA0, 0x91, 0x82, 0x9A, 0x0A, 0x05, 0x59, 0x74, 0x90, 0x1B, 0x73, 0xB5, 0x28,
  0x3D, 0x30, 0xE2, 0x10,
  // "x" (U+0078)
  0x89, 0x17, 0x41, 0xA0, 0xB9, 0x20, 0x7A, 0x28, 0x5A, 0x92, 0x83, 0x1B,
  // "y" (U+0079)
  0x0B, 0x28, 0x92, 0xB7, 0x42, 0x81, 0x97, 0x30, 0xAA, 0x20, 0x60, 0x82, 0x83, 0x83, 0x0A, 0x92,
  // "z" (U+007A)
  0x82, 0x6B, 0xD5, 0x20, 0xA2, 0x83, 0x73, 0x02, 0x92, 0x82, 0x9C, 0xB5,
  // "{" (U+007B)
  0x18, 0x25, 0x90, 0xA2, 0x0A, 0x28, 0x2A, 0x0B, 0x62, 0x0B, 0x20, 0xB2, 0x05, 0x09,
  // "|" (U+007C)
  0x8A, 0x01, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x70,
  // "}" (U+007D)
  0x09, 0x06, 0x20, 0xB2, 0x0A, 0x20, 0xA2, 0x82, 0x5B, 0x0B, 0x28, 0x2B, 0x09, 0x61,
  // "~" (U+007E)
  0x87, 0x4B, 0x64, 0x23, 0x08, 0xA1,
  // "¡" (U+00A1)
  0x89, 0x23, 0x53, 0x43, 0x54, 0x64, 0x65, 0x70,
  // "¢" (U+00A2)
  0x20, 0x82, 0x83, 0x6D, 0x91, 0xA2, 0x03, 0x07, 0x20, 0x20, 0xA3, 0x81, 0x7D, 0x92, 0x08, 0x10,
  // "£" (U+00A3)
  0x18, 0x16, 0xBB, 0x20, 0xB4, 0x0A, 0x38, 0x28, 0xEB, 0x42, 0x0A, 0x30, 0x10, 0x93, 0x83, 0xAC,
  0xBB, 0x30,
  // "¤" (U+00A4)
  0x89, 0x64, 0xBB, 0xB2, 0x60, 0x82, 0x60, 0x94, 0xAB, 0xA0,
  // "¥" (U+00A5)
  0x87, 0xA2, 0x08, 0x34, 0x91, 0xC2, 0x81, 0xDA, 0x72, 0x89, 0x38, 0xF1, 0x03, 0xCE, 0x90, 0x3B,
  0xE9, 0x20, 0x10, 0x92,
  // "¦" (U+00A6)
  0x84, 0x17, 0x17, 0x17, 0x68, 0x41, 0x71, 0x71, 0x70,
  // "§" (U+00A7)
  0x84, 0x2B, 0xB4, 0x56, 0x28, 0x92, 0x2B, 0xA2, 0x64, 0x28, 0x09, 0xB3, 0x28, 0x44, 0x76, 0xBB,
  0x30,
  // "¨" (U+00A8)
  0x81, 0x62, 0x30,
  // "©" (U+00A9)
  0x18, 0x21, 0x67, 0x53, 0x87, 0x75, 0x95, 0x70, 0x60, 0x92, 0x83, 0x61, 0x61, 0x82, 0x83, 0x33,
  0x61, 0x92, 0x86, 0x61, 0x08, 0x69, 0x57, 0x28, 0x21, 0x77, 0x62,
  // "ª" (U+00AA)
  0x87, 0x36, 0x47, 0x67, 0x66, 0x70,
  // "«" (U+00AB)
  0x18, 0x95, 0x61, 0x56, 0x6A, 0x13, 0x88, 0x20, 0x40, 0x40,
  // "¬" (U+00AC)
  0x83, 0x6B, 0xBC, 0x23, 0x06, 0x02, 0x30, 0x21,
  // "®" (U+00AE)
  0x18, 0x21, 0x67, 0x53, 0x8B, 0x77, 0x99, 0x47, 0x06, 0x09, 0x27, 0x61, 0x60, 0xAC, 0x23, 0x36,
  0x09, 0x45, 0x61, 0x08, 0x40, 0x67, 0x28, 0x21, 0x77, 0x62,
  // "¯" (U+00AF)
  0x80, 0x09,
  // "°" (U+00B0)
  0x87, 0x28, 0x67, 0x08, 0x29, 0x60,
  // "±" (U+00B1)
  0x20, 0x82, 0x83, 0x6B, 0xDB, 0x12, 0x08, 0x40, 0x82, 0x83, 0x6B, 0xBB, 0x20,
  // "²" (U+00B2)
  0x89, 0x25, 0x82, 0x03, 0x51, 0x70, 0x87, 0x30,
  // "³" (U+00B3)
  0x89, 0x24, 0x73, 0x2A, 0x30, 0x17, 0x68, 0x20,
  // "´" (U+00B4)
  0x18, 0x16, 0x64,
  // "µ" (U+00B5)
  0x8B, 0x14, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64, 0x47, 0x09, 0x44, 0xDB, 0x94, 0x45, 0x30,
  0x40, 0x63,
  // "¶" (U+00B6)
  0x84, 0x1C, 0xFC, 0x67, 0xA8, 0x12, 0x68, 0xA8, 0x12, 0x66, 0xA8, 0x52, 0x60, 0x8C, 0x26, 0x28,
  0x15, 0x26, 0x28, 0x15, 0x26, 0x28, 0x15, 0x26, 0x28, 0x11, 0x01,
  // "·" (U+00B7)
  0x03, 0x04,
  // "¸" (U+00B8)
  0x84, 0x10, 0x46, 0x75,
  // "¹" (U+00B9)
  0x18, 0x55, 0x4A, 0x08, 0x08,
  // "º" (U+00BA)
  0x87, 0x67, 0x68, 0x08, 0x37, 0x30,
  // "»" (U+00BB)
  0x81, 0x52, 0x72, 0x89, 0x0A, 0x56, 0x29, 0x74, 0x30, 0x41,
  // "¼" (U+00BC)
  0x03, 0x0C, 0x28, 0x59, 0x03, 0x80, 0x35, 0x28, 0x18, 0x09, 0x38, 0x38, 0x35, 0x76, 0x28, 0x92,
  0x93, 0x76, 0x03, 0x58, 0x9A, 0x09, 0x20, 0x30, 0x60,
  // "½" (U+00BD)
  0x89, 0x14, 0xB0, 0x18, 0x04, 0x80, 0x71, 0x28, 0x18, 0x18, 0x38, 0x68, 0x72, 0x86, 0x01, 0x72,
  0x89, 0x38, 0x08, 0x10, 0x71, 0x06, 0x04, 0x97,
  // "¾" (U+00BE)
  0x84, 0x69, 0x20, 0x43, 0x28, 0x23, 0x60, 0x92, 0x83, 0x3C, 0x25, 0x43, 0x89, 0x21, 0x79, 0x3A,
  0x07, 0x97, 0x49, 0x93, 0x86, 0x95, 0x9C, 0x10, 0x53, 0x20, 0x91,
  // "¿" (U+00BF)
  0x20, 0x83, 0x03, 0x30, 0x92, 0x83, 0x84, 0x02, 0x92, 0x03, 0x07, 0x38, 0x1A, 0xB9,
  // "À" (U+00C0)
  0x10, 0x40, 0x23, 0x01, 0x08, 0x40, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A,
  0x03, 0xDB, 0xD4, 0x83, 0x01, 0x9B, 0x30, 0xB0,
  // "Á" (U+00C1)
  0x30, 0x63, 0x06, 0x04, 0x30, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03,
  0xDB, 0xD4, 0x83, 0x01, 0x9B, 0x30, 0xB0,
  // "Â" (U+00C2)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x83, 0x0D, 0x38, 0x13, 0xB5, 0x28, 0x18, 0x3A, 0x28, 0x95, 0xB0,
  0xA0, 0x3D, 0xBD, 0x48, 0x30, 0x19, 0xB3, 0x0B,
  // "Ã" (U+00C3)
  0x18, 0x65, 0xFB, 0x10, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB, 0xD4, 0x83,
  0x01, 0x9B, 0x30, 0xB0,
  // "Ä" (U+00C4)
  0x18, 0x16, 0x23, 0x30, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB,
  0xD4, 0x83, 0x01, 0x9B, 0x30, 0xB0,
  // "Å" (U+00C5)
  0x18, 0x14, 0xF1, 0x28, 0x18, 0xF5, 0x28, 0x18, 0x3A, 0x28, 0x95, 0xB0, 0xA0, 0x3D, 0xBD, 0x48,
  0x30, 0x19, 0xB3, 0x0B,
  // "Æ" (U+00C6)
  0x28, 0x37, 0xDC, 0xB6, 0x28, 0x1B, 0x64, 0x38, 0x24, 0x76, 0x43, 0x89, 0x1A, 0x16, 0xCB, 0x41,
  0xEB, 0xD4, 0x28, 0x36, 0x50, 0x64, 0x20, 0xB2, 0x82, 0x6C, 0xB6,
  // "Ç" (U+00C7)
  0x18, 0x44, 0xCC, 0x81, 0xB3, 0x06, 0x05, 0x30, 0x70, 0x43, 0x06, 0x05, 0x30, 0x20, 0xB4, 0x82,
  0x6D, 0xC6, 0x20, 0x40, 0x63, 0x07, 0x05, 0x10,
  // "È" (U+00C8)
  0x10, 0x40, 0x22, 0x87, 0x18, 0x03, 0xDB, 0xB3, 0x72, 0x03, 0x07, 0x28, 0x43, 0xDB, 0x93, 0x72,
  0x03, 0x07, 0x28, 0x23, 0xDB, 0xB0,
  // "É" (U+00C9)
  0x30, 0x62, 0x86, 0x64, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30,
  0x72, 0x82, 0x3D, 0xBB,
  // "Ê" (U+00CA)
  0x28, 0x92, 0x61, 0x05, 0x68, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20,
  0x30, 0x72, 0x82, 0x3D, 0xBB,
  // "Ë" (U+00CB)
  0x18, 0x76, 0x23, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30, 0x72,
  0x82, 0x3D, 0xBB,
  // "Ì" (U+00CC)
  0x89, 0x14, 0x20, 0x18, 0x07, 0xE3, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "Í" (U+00CD)
  0x28, 0x76, 0x06, 0x47, 0xE3, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "Î" (U+00CE)
  0x18, 0x90, 0x61, 0x56, 0x87, 0xE3, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "Ï" (U+00CF)
  0x86, 0x62, 0x37, 0xE3, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "Ð" (U+00D0)
  0x89, 0x42, 0xDB, 0xB3, 0x02, 0x80, 0x1C, 0x02, 0x82, 0x89, 0x08, 0x49, 0xDB, 0x06, 0x52, 0x82,
  0x89, 0x38, 0x32, 0x80, 0x2C, 0x02, 0xDB, 0xB2, 0x10,
  // "Ñ" (U+00D1)
  0x8C, 0x43, 0xFC, 0xA6, 0x43, 0xC8, 0x05, 0x43, 0x7D, 0x35, 0x43, 0x66, 0xC6, 0x43, 0x60, 0xDC,
  0x43, 0x60, 0x5F, 0x43, 0x62, 0x0C, 0x04,
  // "Ò" (U+00D2)
  0x20, 0x40, 0x24, 0x01, 0x08, 0x38, 0x55, 0xCC, 0x80, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A,
  0x74, 0x38, 0x1B, 0x65, 0x28, 0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "Ó" (U+00D3)
  0x30, 0x64, 0x06, 0x04, 0x38, 0x55, 0xCC, 0x80, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74,
  0x38, 0x1B, 0x65, 0x28, 0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "Ô" (U+00D4)
  0x20, 0x60, 0x13, 0x81, 0x56, 0x83, 0x85, 0x5C, 0xC8, 0x02, 0xB2, 0x82, 0x85, 0x65, 0x28, 0x21,
  0xA7, 0x43, 0x81, 0xB6, 0x52, 0x82, 0x1A, 0x2B, 0x28, 0x58, 0x50, 0x6C, 0xC8, 0x10,
  // "Õ" (U+00D5)
  0x10, 0xBA, 0x82, 0x90, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38, 0x1B, 0x65, 0x28,
  0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "Ö" (U+00D6)
  0x28, 0x16, 0x23, 0x28, 0x55, 0xCC, 0x80, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38,
  0x1B, 0x65, 0x28, 0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "×" (U+00D7)
  0x89, 0x62, 0x20, 0x40, 0x98, 0x50, 0x7B, 0x23, 0x50, 0x80,
  // "Ø" (U+00D8)
  0x18, 0xC6, 0x5C, 0xCC, 0x32, 0xB0, 0x1D, 0x46, 0x50, 0x93, 0x97, 0x43, 0x70, 0xB6, 0x5A, 0x01,
  0xA1, 0xE4, 0x08, 0x50, 0xCC, 0xC8, 0x10,
  // "Ù" (U+00D9)
  0x20, 0x40, 0x24, 0x01, 0x08, 0x20, 0x40, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82,
  0x91, 0x46, 0x28, 0x29, 0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "Ú" (U+00DA)
  0x30, 0x64, 0x06, 0x04, 0x20, 0x40, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91,
  0x46, 0x28, 0x29, 0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "Û" (U+00DB)
  0x20, 0x60, 0x13, 0x81, 0x56, 0x82, 0x04, 0x06, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28,
  0x29, 0x14, 0x62, 0x82, 0x91, 0x47, 0x28, 0x29, 0x11, 0xA2, 0x0B, 0x28, 0x26, 0xBC, 0x51,
  // "Ü" (U+00DC)
  0x28, 0x46, 0x23, 0x04, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28,
  0x29, 0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "Ý" (U+00DD)
  0x20, 0x63, 0x06, 0x04, 0x28, 0x7B, 0x10, 0x84, 0x58, 0x1C, 0x28, 0x1D, 0xA6, 0x20, 0x70, 0xE3,
  0x01, 0x0A, 0x30, 0x10, 0x93, 0x01, 0x09, 0x20,
  // "Þ" (U+00DE)
  0x03, 0x07, 0x38, 0xB1, 0x3D, 0xB8, 0x03, 0x70, 0x94, 0x37, 0x05, 0x63, 0x70, 0x93, 0x3D, 0xB7,
  0x03, 0x73,
  // "ß" (U+00DF)
  0x18, 0xC0, 0xBB, 0xA0, 0x47, 0x09, 0x14, 0x64, 0x80, 0x46, 0x84, 0x04, 0x60, 0x94, 0x46, 0x01,
  0x94, 0x6B, 0xC5,
  // "à" (U+00E0)
  0x10, 0x40, 0x22, 0x01, 0x08, 0x68, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA,
  0x90,
  // "á" (U+00E1)
  0x20, 0x62, 0x06, 0x04, 0x68, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "â" (U+00E2)
  0x28, 0x46, 0x10, 0x56, 0x85, 0x81, 0xBC, 0x73, 0x89, 0x3B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "ã" (U+00E3)
  0x86, 0x5B, 0xA1, 0x0B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "ä" (U+00E4)
  0x18, 0x16, 0x23, 0x58, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "å" (U+00E5)
  0x10, 0x40, 0x72, 0x04, 0x07, 0x28, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA,
  0x90,
  // "æ" (U+00E6)
  0x84, 0x1B, 0xC7, 0xBB, 0x48, 0x95, 0xD0, 0x65, 0x2B, 0xBE, 0xBC, 0x69, 0x31, 0xD3, 0x85, 0x4C,
  0xB5, 0xCB, 0x30,
  // "ç" (U+00E7)
  0x18, 0x3A, 0xB5, 0x65, 0x20, 0x80, 0x32, 0x06, 0x05, 0x38, 0x4C, 0xC5, 0x04, 0x62, 0x07, 0x05,
  0x10,
  // "è" (U+00E8)
  0x10, 0x40, 0x23, 0x01, 0x08, 0x71, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54,
  0x81, 0xAB, 0xA1,
  // "é" (U+00E9)
  0x20, 0x63, 0x06, 0x04, 0x71, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54, 0x81,
  0xAB, 0xA1,
  // "ê" (U+00EA)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x87, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54,
  0x81, 0xAB, 0xA1,
  // "ë" (U+00EB)
  0x18, 0x16, 0x23, 0x78, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA,
  0x10,
  // "ì" (U+00EC)
  0x82, 0x42, 0x18, 0x28, 0x90, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "í" (U+00ED)
  0x18, 0x16, 0x64, 0x28, 0x90, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "î" (U+00EE)
  0x18, 0x36, 0x15, 0x68, 0x48, 0x94, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46,
  // "ï" (U+00EF)
  0x81, 0x62, 0x33, 0x89, 0x44, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x61,
  // "ð" (U+00F0)
  0x18, 0x12, 0x14, 0x28, 0x13, 0xE7, 0x28, 0x14, 0x2A, 0x28, 0xA5, 0x9B, 0xC2, 0x56, 0x08, 0x58,
  0x20, 0x55, 0x55, 0x08, 0x30, 0xAB, 0x81,
  // "ñ" (U+00F1)
  0x18, 0xB3, 0x5B, 0xA1, 0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06,
  0x40,
  // "ò" (U+00F2)
  0x10, 0x40, 0x23, 0x01, 0x08, 0x71, 0x8A, 0x5A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50,
  0x83, 0x0A, 0xB9, 0x10,
  // "ó" (U+00F3)
  0x30, 0x63, 0x06, 0x04, 0x78, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30,
  0xAB, 0x91,
  // "ô" (U+00F4)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x87, 0x8A, 0x5A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50,
  0x83, 0x0A, 0xB9, 0x10,
  // "õ" (U+00F5)
  0x18, 0xB2, 0x5B, 0xA1, 0x0A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83, 0x0A, 0xB9,
  0x10,
  // "ö" (U+00F6)
  0x18, 0x16, 0x23, 0x78, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB,
  0x91,
  // "÷" (U+00F7)
  0x10, 0x10, 0x62, 0x83, 0x6B, 0xBB, 0x26, 0x01, 0x06, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA5, 0xAC, 0xC1, 0x65, 0x3D, 0x38, 0x39, 0x55, 0x5C, 0x28, 0x33, 0xDB, 0x91,
  // "ù" (U+00F9)
  0x10, 0x40, 0x23, 0x01, 0x08, 0x78, 0xA7, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60,
  0x94, 0x1C, 0xB9, 0x40,
  // "ú" (U+00FA)
  0x30, 0x63, 0x06, 0x04, 0x68, 0xA7, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94,
  0x1C, 0xB9, 0x40,
  // "û" (U+00FB)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x86, 0x8A, 0x75, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56,
  0x09, 0x41, 0xCB, 0x94,
  // "ü" (U+00FC)
  0x18, 0x16, 0x23, 0x68, 0xA7, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C,
  0xB9, 0x40,
  // "ý" (U+00FD)
  0x20, 0x62, 0x06, 0x04, 0x50, 0xB2, 0x89, 0x2B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA2, 0x06, 0x08,
  0x28, 0x38, 0x30, 0xA9, 0x20,
  // "þ" (U+00FE)
  0x04, 0x06, 0x30, 0x40, 0x63, 0x8B, 0x14, 0xAB, 0xA0, 0x48, 0x06, 0x54, 0x60, 0x47, 0x48, 0x06,
  0x54, 0xAB, 0xA0, 0x46, 0x30, 0x40, 0x63,
  // "ÿ" (U+00FF)
  0x18, 0x16, 0x23, 0x40, 0xB2, 0x89, 0x2B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA2, 0x06, 0x08, 0x28,
  0x38, 0x30, 0xA9, 0x20,
  // "Ā" (U+0100)
  0x18, 0x18, 0xF9, 0x28, 0x13, 0xB5, 0x28, 0x18, 0x3A, 0x28, 0x95, 0xB0, 0xA0, 0x3D, 0xBD, 0x48,
  0x30, 0x19, 0xB3, 0x0B,
  // "ā" (U+0101)
  0x18, 0x58, 0xB8, 0x0B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "Ă" (U+0102)
  0x30, 0x12, 0x81, 0x5F, 0x72, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB,
  0xD4, 0x83, 0x01, 0x9B, 0x30, 0xB0,
  // "ă" (U+0103)
  0x38, 0x71, 0x05, 0xB6, 0x0B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0x90,
  // "Ą" (U+0104)
  0x20, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB, 0xD4, 0x83, 0x01,
  0x9B, 0x30, 0xD3, 0x08, 0x40, 0x05,
  // "ą" (U+0105)
  0x18, 0x1B, 0xC7, 0x38, 0x93, 0xB2, 0xBB, 0xC9, 0x30, 0xB4, 0xCA, 0xB2, 0x08, 0x30, 0x05,
  // "Ć" (U+0106)
  0x30, 0x63, 0x06, 0x04, 0x28, 0x44, 0xCC, 0x81, 0xB3, 0x06, 0x05, 0x30, 0x70, 0x43, 0x06, 0x05,
  0x30, 0x20, 0xB4, 0x82, 0x6C, 0xB6,
  // "ć" (U+0107)
  0x20, 0x62, 0x06, 0x04, 0x68, 0x3A, 0xB5, 0x65, 0x20, 0x80, 0x32, 0x06, 0x05, 0x38, 0x1A, 0xB5,
  // "Ĉ" (U+0108)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x82, 0x84, 0x4C, 0xC8, 0x1B, 0x30, 0x60, 0x53, 0x07, 0x04, 0x30,
  0x60, 0x53, 0x02, 0x0B, 0x48, 0x26, 0xCB, 0x60,
  // "ĉ" (U+0109)
  0x28, 0x46, 0x10, 0x56, 0x85, 0x83, 0xAB, 0x56, 0x52, 0x08, 0x03, 0x20, 0x60, 0x53, 0x81, 0xAB,
  0x50,
  // "Ċ" (U+010A)
  0x20, 0x63, 0x84, 0x4C, 0xC8, 0x1B, 0x30, 0x60, 0x53, 0x07, 0x04, 0x30, 0x60, 0x53, 0x02, 0x0B,
  0x48, 0x26, 0xCB, 0x60,
  // "ċ" (U+010B)
  0x20, 0x66, 0x83, 0xAB, 0x56, 0x52, 0x08, 0x03, 0x20, 0x60, 0x53, 0x81, 0xAB, 0x50,
  // "Č" (U+010C)
  0x18, 0x14, 0x05, 0x28, 0x11, 0xC5, 0x28, 0x44, 0xCC, 0x81, 0xB3, 0x06, 0x05, 0x30, 0x70, 0x43,
  0x06, 0x05, 0x30, 0x20, 0xB4, 0x82, 0x6C, 0xB6,
  // "č" (U+010D)
  0x18, 0x54, 0x05, 0x01, 0xC5, 0x58, 0x3A, 0xB5, 0x65, 0x20, 0x80, 0x32, 0x06, 0x05, 0x38, 0x1A,
  0xB5,
  // "Ď" (U+010E)
  0x18, 0x14, 0x05, 0x38, 0x11, 0xC5, 0x28, 0x94, 0x3D, 0xBB, 0x30, 0x37, 0x01, 0xC0, 0x37, 0x28,
  0x28, 0x43, 0x72, 0x82, 0x65, 0x37, 0x28, 0x93, 0x83, 0x37, 0x02, 0xC0, 0x3D, 0xBB, 0x21,
  // "ď" (U+010F)
  0x38, 0x17, 0x84, 0x30, 0x70, 0x42, 0x8B, 0x2B, 0xBA, 0x30, 0x65, 0x09, 0x30, 0x83, 0x07, 0x30,
  0x65, 0x09, 0x30, 0x1B, 0xA9, 0x31,
  // "Đ" (U+0110)
  0x89, 0x42, 0xDB, 0xB3, 0x02, 0x80, 0x1C, 0x02, 0x82, 0x89, 0x08, 0x49, 0xDB, 0x06, 0x52, 0x82,
  0x89, 0x38, 0x32, 0x80, 0x2C, 0x02, 0xDB, 0xB2, 0x10,
  // "đ" (U+0111)
  0x38, 0xB6, 0x73, 0x02, 0xBD, 0xA1, 0xBB, 0xA3, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31,
  0xBA, 0xA3,
  // "Ē" (U+0112)
  0x03, 0xB0, 0x30, 0x72, 0x03, 0x07, 0x28, 0x43, 0xDB, 0x93, 0x72, 0x03, 0x07, 0x28, 0x23, 0xDB,
  0xB0,
  // "ē" (U+0113)
  0x18, 0x18, 0xB8, 0x28, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA,
  0x10,
  // "Ĕ" (U+0114)
  0x30, 0x10, 0x3B, 0x03, 0x07, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30, 0x72, 0x82,
  0x3D, 0xBB,
  // "ĕ" (U+0115)
  0x30, 0x12, 0x81, 0x5B, 0x62, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54, 0x81,
  0xAB, 0xA1,
  // "Ė" (U+0116)
  0x28, 0x66, 0x03, 0xDB, 0xB3, 0x72, 0x03, 0x07, 0x28, 0x43, 0xDB, 0x93, 0x72, 0x03, 0x07, 0x28,
  0x23, 0xDB, 0xB0,
  // "ė" (U+0117)
  0x20, 0x67, 0x18, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA, 0x10,
  // "Ę" (U+0118)
  0x84, 0x3D, 0xBB, 0x37, 0x20, 0x30, 0x72, 0x84, 0x3D, 0xB9, 0x37, 0x20, 0x30, 0x72, 0x82, 0x3D,
  0xCD, 0x20, 0x83, 0x00, 0x50,
  // "ę" (U+0119)
  0x18, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBB, 0x30, 0x03, 0x30,
  0x40, 0xA1,
  // "Ě" (U+011A)
  0x18, 0x93, 0x40, 0x50, 0x1C, 0x53, 0xDB, 0xB3, 0x72, 0x03, 0x07, 0x28, 0x43, 0xDB, 0x93, 0x72,
  0x03, 0x07, 0x28, 0x23, 0xDB, 0xB0,
  // "ě" (U+011B)
  0x18, 0x14, 0x05, 0x28, 0x11, 0xC5, 0x78, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65,
  0x48, 0x1A, 0xBA, 0x10,
  // "Ĝ" (U+011C)
  0x30, 0x60, 0x13, 0x81, 0x56, 0x82, 0x86, 0x4B, 0xBB, 0x01, 0xC1, 0x30, 0x60, 0x54, 0x86, 0x74,
  0x08, 0xC3, 0x66, 0x28, 0x27, 0x32, 0xC2, 0x86, 0x73, 0x05, 0xCB, 0xC2,
  // "ĝ" (U+011D)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x87, 0x8A, 0x6B, 0xB9, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50,
  0x93, 0x1B, 0xBA, 0x33, 0x84, 0x92, 0x2B, 0xB9, 0x10,
  // "Ğ" (U+011E)
  0x40, 0x12, 0x04, 0xB1, 0x81, 0x1C, 0x13, 0x06, 0x05, 0x48, 0x67, 0x40, 0x8C, 0x36, 0x62, 0x82,
  0x73, 0x2C, 0x28, 0x67, 0x30, 0x5C, 0xBC, 0x20,
  // "ğ" (U+011F)
  0x30, 0x12, 0x81, 0x5B, 0x62, 0x8A, 0x6B, 0xB9, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50, 0x93,
  0x1B, 0xBA, 0x33, 0x84, 0x92, 0x2B, 0xB9, 0x10,
  // "Ġ" (U+0120)
  0x30, 0x63, 0x86, 0x4B, 0xBB, 0x01, 0xC1, 0x30, 0x60, 0x54, 0x86, 0x74, 0x08, 0xC3, 0x66, 0x28,
  0x27, 0x32, 0xC2, 0x86, 0x73, 0x05, 0xCB, 0xC2,
  // "ġ" (U+0121)
  0x20, 0x67, 0x18, 0xA6, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBB, 0xA3,
  0x38, 0x49, 0x22, 0xBB, 0x91,
  // "Ģ" (U+0122)
  0x18, 0x64, 0xBB, 0xB0, 0x1C, 0x13, 0x06, 0x05, 0x48, 0x67, 0x40, 0x8C, 0x36, 0x62, 0x82, 0x73,
  0x2C, 0x28, 0x67, 0x30, 0x5C, 0xBC, 0x23, 0x01, 0x40, 0x20, 0x62,
  // "ģ" (U+0123)
  0x20, 0x84, 0x01, 0x38, 0xA6, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBB,
  0xA3, 0x38, 0x49, 0x22, 0xBB, 0x91,
  // "Ĥ" (U+0124)
  0x20, 0x60, 0x13, 0x81, 0x56, 0x82, 0x03, 0x07, 0x28, 0x29, 0x23, 0x72, 0x82, 0x92, 0x37, 0x28,
  0x90, 0x92, 0x3D, 0xBB, 0xD2, 0x37, 0x28, 0x29, 0x23, 0x72, 0x82, 0x92, 0x37, 0x20, 0x90, 0x20,
  // "ĥ" (U+0125)
  0x10, 0x60, 0x13, 0x81, 0x56, 0x87, 0x30, 0x40, 0x64, 0x04, 0x06, 0x48, 0x24, 0xAB, 0xB2, 0x8A,
  0x54, 0x80, 0x74, 0x04, 0x60, 0x64, 0x04, 0x60, 0x64, 0x04, 0x60, 0x64,
  // "Ħ" (U+0126)
  0x03, 0x07, 0x28, 0x90, 0x92, 0xCD, 0xBB, 0xDB, 0x37, 0x28, 0x90, 0x92, 0x3D, 0xBB, 0xD2, 0x37,
  0x28, 0x29, 0x23, 0x72, 0x82, 0x92, 0x37, 0x20, 0x90, 0x20,
  // "ħ" (U+0127)
  0x04, 0x06, 0x38, 0x1B, 0xDB, 0x28, 0xA7, 0x4A, 0xBB, 0x04, 0x90, 0x73, 0x46, 0x06, 0x44, 0x60,
  0x64, 0x46, 0x06, 0x40,
  // "Ĩ" (U+0128)
  0x84, 0xCF, 0xE1, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x28, 0x16, 0xD3, 0x10,
  // "ĩ" (U+0129)
  0x85, 0x5B, 0xA1, 0x04, 0x62, 0x04, 0x06, 0x20, 0x40, 0x62, 0x04, 0x06, 0x20, 0x40, 0x61,
  // "Ī" (U+012A)
  0xA8, 0x1B, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "ī" (U+012B)
  0x89, 0x78, 0xB8, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x10,
  // "Ĭ" (U+012C)
  0x28, 0x41, 0xCF, 0xA0, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x28, 0x3B, 0x06, 0xD3,
  // "ĭ" (U+012D)
  0x28, 0xA0, 0x15, 0xB6, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x10,
  // "Į" (U+012E)
  0x83, 0x7E, 0x30, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x28, 0x5B, 0x06, 0xE5, 0x08, 0x20, 0x05,
  // "į" (U+012F)
  0x00, 0x32, 0x89, 0x44, 0x64, 0x64, 0x64, 0x65, 0x78, 0x05, 0x50,
  // "İ" (U+0130)
  0x18, 0x56, 0x07, 0xE3, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "ı" (U+0131)
  0x89, 0x04, 0x64, 0x64, 0x64, 0x64, 0x60,
  // "Ĳ" (U+0132)
  0x8C, 0x17, 0xE3, 0x47, 0x0B, 0x04, 0x70, 0xB0, 0x47, 0x0B, 0x04, 0x70, 0xB0, 0x47, 0x0B, 0x04,
  0x76, 0xD3, 0x56, 0x28, 0x17, 0xB1,
  // "ĳ" (U+0133)
  0x80, 0x03, 0x48, 0xA2, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x28, 0x45,
  0x50, 0x5C, 0x20,
  // "Ĵ" (U+0134)
  0x18, 0xB3, 0x61, 0x56, 0x80, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x56, 0x7B,
  0x10,
  // "ĵ" (U+0135)
  0x18, 0x36, 0x15, 0x68, 0x48, 0xA2, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x05, 0x55, 0xC2,
  // "Ķ" (U+0136)
  0x8A, 0x03, 0x70, 0x57, 0x37, 0x1A, 0x03, 0x8A, 0x10, 0x3D, 0xC2, 0x89, 0x53, 0x86, 0x60, 0x37,
  0x0B, 0x13, 0x70, 0x39, 0x20, 0x14, 0x08, 0x20,
  // "ķ" (U+0137)
  0x04, 0x05, 0x20, 0x40, 0x52, 0x8A, 0x24, 0x52, 0x94, 0x6A, 0x04, 0xD9, 0x04, 0x69, 0x34, 0x51,
  0xB2, 0x01, 0x20, 0x30, 0x51,
  // "ĸ" (U+0138)
  0x8A, 0x24, 0x62, 0xA4, 0x7B, 0x14, 0xDA, 0x04, 0x79, 0x44, 0x60, 0xB0,
  // "Ĺ" (U+0139)
  0x10, 0x62, 0x06, 0x04, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30,
  0x72, 0x03, 0x07, 0x28, 0x23, 0xDB, 0xB0,
  // "ĺ" (U+013A)
  0x18, 0x16, 0x64, 0x28, 0x94, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "Ļ" (U+013B)
  0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x82,
  0x3D, 0xBB, 0x20, 0x13, 0x08, 0x10,
  // "ļ" (U+013C)
  0x8A, 0x04, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x60, 0x15, 0x30,
  // "Ľ" (U+013D)
  0x89, 0x03, 0x70, 0x93, 0x70, 0x13, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x28, 0x23,
  0xDB, 0xB0,
  // "ľ" (U+013E)
  0x8A, 0x24, 0x77, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x61,
  // "Ŀ" (U+013F)
  0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x28, 0x43, 0x76, 0x03, 0x72, 0x03, 0x07, 0x28, 0x23,
  0xDB, 0xB0,
  // "ŀ" (U+0140)
  0x89, 0x44, 0x64, 0x64, 0xC4, 0x64, 0x64, 0x64, 0x60,
  // "Ł" (U+0141)
  0x03, 0x07, 0x20, 0x30, 0x72, 0x89, 0x03, 0x72, 0x03, 0xD6, 0x09, 0x72, 0x03, 0x07, 0x28, 0x23,
  0xDB, 0xB0,
  // "ł" (U+0142)
  0x80, 0x15, 0x82, 0x67, 0xBA, 0x80, 0x15,
  // "Ń" (U+0143)
  0x30, 0x64, 0x06, 0x04, 0x20, 0x30, 0xD2, 0x8C, 0x05, 0x43, 0xC8, 0x05, 0x43, 0x7D, 0x35, 0x43,
  0x66, 0xC6, 0x43, 0x60, 0xDC, 0x43, 0x60, 0x5F, 0x43, 0x62, 0x0C, 0x04,
  // "ń" (U+0144)
  0x30, 0x63, 0x06, 0x04, 0x68, 0xA7, 0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64,
  0x46, 0x06, 0x40,
  // "Ņ" (U+0145)
  0x03, 0x0D, 0x28, 0xC0, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36, 0x6C, 0x64, 0x36, 0x0D,
  0xC4, 0x36, 0x05, 0xF4, 0x36, 0x20, 0xC0, 0x43, 0x01, 0x40, 0x04, 0x20,
  // "ņ" (U+0146)
  0x8A, 0x74, 0x9B, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64, 0x20, 0x14,
  0x08, 0x20,
  // "Ň" (U+0147)
  0x18, 0x14, 0x05, 0x38, 0x11, 0xC5, 0x20, 0x30, 0xD2, 0x8C, 0x05, 0x43, 0xC8, 0x05, 0x43, 0x7D,
  0x35, 0x43, 0x66, 0xC6, 0x43, 0x60, 0xDC, 0x43, 0x60, 0x5F, 0x43, 0x62, 0x0C, 0x04,
  // "ň" (U+0148)
  0x18, 0x14, 0x05, 0x28, 0x11, 0xC5, 0x68, 0xA7, 0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44,
  0x60, 0x64, 0x46, 0x06, 0x40,
  // "ŉ" (U+0149)
  0x09, 0x02, 0x40, 0x95, 0x83, 0x14, 0x9B, 0xB2, 0x8A, 0x54, 0x80, 0x74, 0x04, 0x60, 0x64, 0x04,
  0x60, 0x64, 0x04, 0x60, 0x64,
  // "Ŋ" (U+014A)
  0x03, 0x0D, 0x28, 0xC0, 0x54, 0x3F, 0x60, 0x54, 0x3C, 0xE0, 0x54, 0x36, 0xB7, 0x54, 0x36, 0x1D,
  0x74, 0x36, 0x06, 0xD4, 0x36, 0x20, 0xB0, 0x44, 0x07, 0x03, 0x30, 0x09, 0x10,
  // "ŋ" (U+014B)
  0x8A, 0x74, 0x9B, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64, 0x30, 0x60,
  0x42, 0x81, 0x4C, 0x10,
  // "Ō" (U+014C)
  0x10, 0x5B, 0x10, 0x20, 0xB2, 0x82, 0x85, 0x65, 0x28, 0x21, 0xA7, 0x43, 0x81, 0xB6, 0x52, 0x82,
  0x1A, 0x2B, 0x28, 0x58, 0x50, 0x6C, 0xC8, 0x10,
  // "ō" (U+014D)
  0x18, 0x18, 0xB8, 0x28, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB,
  0x91,
  // "Ŏ" (U+014E)
  0x40, 0x12, 0x05, 0xB1, 0x02, 0x0B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38, 0x1B, 0x65,
  0x28, 0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "ŏ" (U+014F)
  0x30, 0x12, 0x81, 0x5B, 0x62, 0x8A, 0x5A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83,
  0x0A, 0xB9, 0x10,
  // "Ő" (U+0150)
  0x28, 0x14, 0x69, 0x28, 0x55, 0xDC, 0x90, 0x2B, 0x28, 0x28, 0x56, 0x52, 0x82, 0x1A, 0x74, 0x38,
  0x1B, 0x65, 0x28, 0x21, 0xA2, 0xB2, 0x85, 0x85, 0x06, 0xCC, 0x81,
  // "ő" (U+0151)
  0x18, 0x14, 0x69, 0x20, 0x14, 0x8A, 0x5A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83,
  0x0A, 0xB9, 0x10,
  // "Œ" (U+0152)
  0x18, 0x91, 0x6C, 0xCE, 0xBA, 0x2B, 0x01, 0x92, 0x83, 0x65, 0x01, 0x92, 0x89, 0x27, 0x40, 0x1E,
  0xB9, 0x65, 0x01, 0x92, 0x83, 0x2B, 0x01, 0x93, 0x84, 0x6C, 0xCE, 0xBA,
  // "œ" (U+0153)
  0x18, 0xB2, 0xAB, 0x68, 0xB7, 0x06, 0x50, 0x97, 0x0B, 0x08, 0x30, 0x6C, 0xBC, 0x15, 0x50, 0x97,
  0x48, 0x4A, 0xB7, 0x8B, 0xA1,
  // "Ŕ" (U+0154)
  0x30, 0x63, 0x8C, 0x46, 0x40, 0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC, 0x90, 0x37,
  0x1A, 0x03, 0x70, 0xA2, 0x37, 0x03, 0x90,
  // "ŕ" (U+0155)
  0x20, 0x62, 0x06, 0x04, 0x58, 0x44, 0x8B, 0x14, 0xA2, 0x04, 0x06, 0x20, 0x40, 0x62, 0x04, 0x06,
  0x20,
  // "Ŗ" (U+0156)
  0x8C, 0x13, 0xDB, 0xB0, 0x37, 0x06, 0x53, 0x70, 0x74, 0x3D, 0xC9, 0x03, 0x71, 0xA0, 0x37, 0x0A,
  0x23, 0x70, 0x39, 0x20, 0x14, 0x08, 0x20,
  // "ŗ" (U+0157)
  0x84, 0x48, 0xB1, 0x4A, 0x20, 0x40, 0x62, 0x04, 0x06, 0x20, 0x40, 0x63, 0x01, 0x20, 0x50, 0x32,
  // "Ř" (U+0158)
  0x18, 0x14, 0x05, 0x28, 0xC5, 0x1C, 0x50, 0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC,
  0x90, 0x37, 0x1A, 0x03, 0x70, 0xA2, 0x37, 0x03, 0x90,
  // "ř" (U+0159)
  0x85, 0x40, 0x50, 0x1C, 0x55, 0x84, 0x48, 0xB1, 0x4A, 0x20, 0x40, 0x62, 0x04, 0x06, 0x20, 0x40,
  0x62,
  // "Ś" (U+015A)
  0x20, 0x62, 0x87, 0x64, 0x01, 0xBB, 0x96, 0x42, 0x05, 0x08, 0x38, 0x17, 0xC3, 0x20, 0x10, 0xC3,
  0x83, 0xB7, 0xBB, 0x50,
  // "ś" (U+015B)
  0x20, 0x62, 0x06, 0x04, 0x58, 0x44, 0xCC, 0x37, 0x33, 0x07, 0x08, 0x38, 0x45, 0x66, 0xBB, 0x20,
  // "Ŝ" (U+015C)
  0x28, 0x92, 0x61, 0x05, 0x68, 0x1B, 0xB9, 0x64, 0x20, 0x50, 0x83, 0x81, 0x7C, 0x32, 0x01, 0x0C,
  0x38, 0x3B, 0x7B, 0xB5,
  // "ŝ" (U+015D)
  0x18, 0x46, 0x10, 0x56, 0x85, 0x84, 0x4C, 0xC3, 0x73, 0x30, 0x70, 0x83, 0x84, 0x56, 0x6B, 0xB2,
  // "Ş" (U+015E)
  0x84, 0x1B, 0xB9, 0x64, 0x20, 0x50, 0x83, 0x81, 0x7C, 0x32, 0x01, 0x0C, 0x38, 0x6B, 0x7D, 0xC5,
  0x04, 0x62, 0x07, 0x05, 0x10,
  // "ş" (U+015F)
  0x84, 0x4C, 0xC3, 0x73, 0x30, 0x70, 0x83, 0x87, 0x56, 0x6D, 0xC2, 0x04, 0x62, 0x07, 0x05, 0x10,
  // "Š" (U+0160)
  0x18, 0x93, 0x40, 0x50, 0x1C, 0x51, 0xBB, 0x96, 0x42, 0x05, 0x08, 0x38, 0x17, 0xC3, 0x20, 0x10,
  0xC3, 0x83, 0xB7, 0xBB, 0x50,
  // "š" (U+0161)
  0x85, 0x40, 0x50, 0x1C, 0x55, 0x84, 0x4C, 0xC3, 0x73, 0x30, 0x70, 0x83, 0x84, 0x56, 0x6B, 0xB2,
  // "Ţ" (U+0162)
  0x86, 0xAC, 0xDB, 0x40, 0x29, 0x30, 0x20, 0x93, 0x02, 0x09, 0x30, 0x20, 0x93, 0x02, 0x09, 0x30,
  0x30, 0x93, 0x04, 0x06, 0x30, 0x70, 0x52,
  // "ţ" (U+0163)
  0x8A, 0x61, 0x60, 0x9D, 0x84, 0x60, 0x46, 0x03, 0x70, 0x1D, 0x80, 0x46, 0x07, 0x50,
  // "Ť" (U+0164)
  0x18, 0x14, 0x05, 0x28, 0x92, 0x1C, 0x50, 0xAC, 0xDB, 0x40, 0x29, 0x30, 0x20, 0x93, 0x02, 0x09,
  0x30, 0x20, 0x93, 0x02, 0x09, 0x30, 0x20, 0x92,
  // "ť" (U+0165)
  0x18, 0x31, 0x08, 0x26, 0x28, 0x4A, 0xD8, 0x04, 0x62, 0x04, 0x06, 0x20, 0x30, 0x72, 0x81, 0x1C,
  0x81,
  // "Ŧ" (U+0166)
  0x86, 0xAC, 0xDB, 0x40, 0x29, 0x30, 0x20, 0x92, 0x82, 0x4C, 0xD8, 0x20, 0x20, 0x93, 0x02, 0x09,
  0x30, 0x20, 0x92,
  // "ŧ" (U+0167)
  0x8A, 0x01, 0x60, 0x9D, 0x84, 0x60, 0xAD, 0x74, 0x70, 0x1C, 0x80,
  // "Ũ" (U+0168)
  0x86, 0x4B, 0xBA, 0xA1, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x72,
  0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "ũ" (U+0169)
  0x18, 0xB3, 0x5B, 0xA1, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C, 0xB9,
  0x40,
  // "Ū" (U+016A)
  0x86, 0x4E, 0xB8, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x72,
  0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "ū" (U+016B)
  0x18, 0xB3, 0x8B, 0x80, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C, 0xB9,
  0x40,
  // "Ŭ" (U+016C)
  0x30, 0x12, 0x86, 0x4B, 0xB6, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29,
  0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "ŭ" (U+016D)
  0x30, 0x12, 0x8B, 0x35, 0xB6, 0x05, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09, 0x41,
  0xCB, 0x94,
  // "Ů" (U+016E)
  0x20, 0x40, 0x72, 0x86, 0x46, 0x47, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28,
  0x29, 0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "ů" (U+016F)
  0x10, 0x40, 0x73, 0x04, 0x07, 0x28, 0xA7, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60,
  0x94, 0x1C, 0xB9, 0x40,
  // "Ű" (U+0170)
  0x28, 0x92, 0x46, 0x90, 0x46, 0x10, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28,
  0x29, 0x14, 0x72, 0x82, 0x91, 0x1A, 0x20, 0xB2, 0x82, 0x6B, 0xC5, 0x10,
  // "ű" (U+0171)
  0x18, 0x14, 0x69, 0x20, 0x13, 0x8A, 0x75, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09,
  0x41, 0xCB, 0x94,
  // "Ų" (U+0172)
  0x04, 0x06, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x46, 0x28, 0x29, 0x14, 0x62, 0x82, 0x91, 0x47,
  0x28, 0x29, 0x11, 0xA2, 0x0A, 0x28, 0x26, 0xBD, 0x44, 0x07, 0x50, 0x90, 0x51,
  // "ų" (U+0173)
  0x8A, 0x75, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09, 0x41, 0xCB, 0xA5, 0x30, 0x84,
  0x00, 0x50,
  // "Ŵ" (U+0174)
  0x30, 0x60, 0x15, 0x81, 0x56, 0x83, 0x0B, 0x28, 0xB2, 0xC2, 0x08, 0x39, 0x20, 0xD6, 0x0A, 0x05,
  0x54, 0x7A, 0x0B, 0x02, 0x88, 0x2A, 0x28, 0x28, 0x4A, 0xA0, 0x87, 0x52, 0x84, 0xA9, 0x04, 0xD2,
  0x20, 0x07, 0x20, 0xD2,
  // "ŵ" (U+0175)
  0x20, 0x60, 0x14, 0x81, 0x56, 0x87, 0x38, 0xB1, 0xB0, 0x5A, 0x09, 0x18, 0x29, 0xA0, 0xA0, 0x55,
  0x97, 0x49, 0x01, 0xB7, 0x3B, 0x52, 0x83, 0xD3, 0x0E, 0x21,
  // "Ŷ" (U+0176)
  0x20, 0x60, 0x12, 0x89, 0x35, 0x68, 0x0B, 0x10, 0x84, 0x58, 0x1C, 0x28, 0x1D, 0xA6, 0x20, 0x70,
  0xE3, 0x01, 0x0A, 0x30, 0x10, 0x93, 0x01, 0x09, 0x20,
  // "ŷ" (U+0177)
  0x18, 0x46, 0x10, 0x56, 0x85, 0x0B, 0x28, 0x92, 0xB7, 0x42, 0x81, 0x97, 0x30, 0xAA, 0x20, 0x60,
  0x82, 0x83, 0x83, 0x0A, 0x92,
  // "Ÿ" (U+0178)
  0x18, 0x93, 0x62, 0x30, 0xB1, 0x08, 0x45, 0x81, 0xC2, 0x81, 0xDA, 0x62, 0x07, 0x0E, 0x30, 0x10,
  0xA3, 0x01, 0x09, 0x30, 0x10, 0x92,
  // "Ź" (U+0179)
  0x30, 0x63, 0x86, 0x64, 0x06, 0xBB, 0xE2, 0x20, 0x10, 0xA3, 0x09, 0x03, 0x20, 0x20, 0x93, 0x0A,
  0x02, 0x20, 0x30, 0x83, 0x83, 0xAC, 0xBB, 0x30,
  // "ź" (U+017A)
  0x20, 0x62, 0x06, 0x04, 0x58, 0x26, 0xBD, 0x52, 0x0A, 0x28, 0x37, 0x30, 0x29, 0x28, 0x29, 0xCB,
  0x50,
  // "Ż" (U+017B)
  0x20, 0x62, 0x83, 0x6B, 0xBE, 0x22, 0x01, 0x0A, 0x30, 0x90, 0x32, 0x02, 0x09, 0x30, 0xA0, 0x22,
  0x03, 0x08, 0x38, 0x3A, 0xCB, 0xB3,
  // "ż" (U+017C)
  0x10, 0x66, 0x82, 0x6B, 0xD5, 0x20, 0xA2, 0x83, 0x73, 0x02, 0x92, 0x82, 0x9C, 0xB5,
  // "Ž" (U+017D)
  0x18, 0x14, 0x05, 0x28, 0x71, 0xC5, 0x06, 0xBB, 0xE2, 0x20, 0x10, 0xA3, 0x09, 0x03, 0x20, 0x20,
  0x93, 0x0A, 0x02, 0x20, 0x30, 0x83, 0x83, 0xAC, 0xBB, 0x30,
  // "ž" (U+017E)
  0x85, 0x40, 0x50, 0x1C, 0x55, 0x82, 0x6B, 0xD5, 0x20, 0xA2, 0x83, 0x73, 0x02, 0x92, 0x82, 0x9C,
  0xB5,
  // "ſ" (U+017F)
  0x8A, 0x21, 0xC9, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x61,
  // "Ω" (U+03A9)
  0x18, 0x56, 0xCC, 0x90, 0x2A, 0x28, 0x27, 0x66, 0x52, 0x82, 0x1A, 0x74, 0x38, 0x1B, 0x47, 0x28,
  0x23, 0x80, 0xA2, 0x86, 0x92, 0x8D, 0x84, 0xEB,
  // "μ" (U+03BC)
  0x8B, 0x14, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64, 0x47, 0x09, 0x44, 0xDB, 0x94, 0x45, 0x30,
  0x40, 0x63,
  // "π" (U+03C0)
  0x8A, 0x79, 0xEB, 0xDC, 0x0A, 0x08, 0x20, 0xA0, 0x82, 0x0A, 0x07, 0x20, 0xA0, 0x5B,
  // "–" (U+2013)
  0x82, 0x8B, 0xB8,
  // "—" (U+2014)
  0x08, 0x80, 0x2B, 0x08,
  // "€" (U+20AC)
  0x18, 0x52, 0xBC, 0x30, 0xA1, 0x30, 0xA3, 0x87, 0x8C, 0x94, 0x08, 0xC9, 0x22, 0x0B, 0x48, 0x24,
  0xCB, 0x30,
  // "₿" (U+20BF)
  0x18, 0xC4, 0x66, 0x10, 0x3D, 0xC8, 0x03, 0x70, 0xB1, 0x37, 0x0B, 0x03, 0xDC, 0x90, 0x37, 0x09,
  0x23, 0x70, 0x93, 0x3D, 0xCA, 0x28, 0x16, 0x61, 0x10,
  // "‘" (U+2018)
  0x83, 0x63, 0xB0, 0x11,
  // "’" (U+2019)
  0x83, 0x92, 0x90, 0x11,
  // "‚" (U+201A)
  0x83, 0x92, 0x90, 0x11,
  // "‛" (U+201B)
  0x82, 0xB0, 0x72,
  // "“" (U+201C)
  0x86, 0x63, 0x9B, 0x47, 0x11, 0x10,
  // "”" (U+201D)
  0x86, 0x94, 0xA9, 0x45, 0x11, 0x10,
  // "„" (U+201E)
  0x86, 0x94, 0xA9, 0x45, 0x11, 0x10,
  // "‟" (U+201F)
  0x84, 0xB5, 0x77, 0x39, 0x20, 0x10,
  // "†" (U+2020)
  0x18, 0x94, 0x55, 0x01, 0x55, 0x14, 0x99, 0x40, 0x34, 0x20, 0x04, 0x20, 0x05, 0x20, 0x50, 0x61,
  // "‡" (U+2021)
  0x18, 0xB0, 0x55, 0x03, 0x77, 0x32, 0x67, 0x30, 0x46, 0x02, 0x67, 0x33, 0x78, 0x30, 0x45, 0x10,
  // "•" (U+2022)
  0x84, 0x4F, 0x43, 0xE3,
  // "…" (U+2026)
  0x84, 0x34, 0x34, 0x34,
  // "‰" (U+2030)
  0x83, 0x3C, 0x40, 0x84, 0x83, 0x81, 0x91, 0x74, 0x83, 0x80, 0x97, 0x14, 0x8A, 0x07, 0x19, 0x89,
  0xA0, 0xB7, 0x2B, 0xA3, 0x86, 0x74, 0x92, 0x89, 0x69, 0x18, 0x57, 0x49, 0x05, 0x40, 0xAB, 0x1B,
  0x90,
  // "‹" (U+2039)
  0x18, 0x56, 0x65, 0x38, 0x04,
  // "›" (U+203A)
  0x85, 0x51, 0x0A, 0x29, 0x31,
  // "⁄" (U+2044)
  0x30, 0x04, 0x30, 0x93, 0x00, 0x43, 0x09, 0x30, 0x40, 0x53, 0x09, 0x30, 0x40, 0x53,
  // "™" (U+2122)
  0x8A, 0x6B, 0xE9, 0x73, 0x81, 0x76, 0x97, 0x81, 0x76, 0x87, 0x80, 0x22, 0x12, 0x30,
  // "⅒" (U+2152)
  0x30, 0x04, 0x58, 0x15, 0x09, 0x58, 0x24, 0xA4, 0x46, 0x8A, 0x18, 0x90, 0x50, 0x48, 0x20, 0xD5,
  0x4A, 0x09, 0x08, 0x09, 0x28, 0x58, 0x08, 0x08, 0x45, 0x28, 0x38, 0x04, 0x82,
  // "ﬁ" (U+FB01)
  0x18, 0x4A, 0xB3, 0x31, 0x93, 0x8A, 0x79, 0xD7, 0x46, 0x19, 0x04, 0x61, 0x90, 0x46, 0x19, 0x04,
  0x61, 0x90, 0x46,
  // "ﬂ" (U+FB02)
  0x18, 0xC0, 0xAB, 0x56, 0x19, 0x04, 0x69, 0xD7, 0x46, 0x19, 0x04, 0x61, 0x90, 0x46, 0x19, 0x04,
  0x61, 0x90, 0x46,
};

const Font& font_NotoSans_Regular_8() {
  static SmoothFont font(font_NotoSans_Regular_8_data);
  return font;
}

}  // namespace roo_display
