#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Thu Mar 30 22:28:53 CEST 2023
static const uint8_t font_NotoSans_CondensedItalic_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xEA,
  0xFD, 0xFE, 0x09, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x06, 0x03, 0x08, 0x04, 0x00, 0x0E, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x08, 0x05, 0x00, 0x14, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x04, 0x08, 0x04, 0x00, 0x2A, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x08, 0x07, 0x00, 0x42, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x08, 0x05, 0x00, 0x62, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x06, 0x02, 0x08, 0x02, 0x00, 0x79, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x03, 0x08, 0x03, 0x00, 0x7D, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x94, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x05, 0x04, 0x09, 0x04, 0x00, 0xAB, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x06, 0x05, 0x00, 0xB7, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0x00, 0x01, 0x02, 0x02, 0x00, 0xC2, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 0xC8, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0xCB, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x00, 0xCD, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x08, 0x04, 0x00, 0xDF, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x03, 0x08, 0x04, 0x00, 0xF5, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x01, 0x03, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x1B, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x30, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x45, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x58, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x6D, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x80, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x96, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x06, 0x02, 0x01, 0xAC, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x01, 0x06, 0x02, 0x01, 0xB1, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xBA, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x05, 0x01, 0xC7, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xCF, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x08, 0x03, 0x01, 0xDB, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x06, 0x08, 0x07, 0x01, 0xED, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x03, 0x08, 0x05, 0x02, 0x0D, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0x23, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x08, 0x04, 0x02, 0x39, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0x4D, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x08, 0x04, 0x02, 0x64, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x08, 0x04, 0x02, 0x78, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x08, 0x05, 0x02, 0x8A, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x08, 0x05, 0x02, 0xA2, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x02, 0xBD, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFF, 0x02, 0x08, 0x02, 0x02, 0xD0, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x08, 0x05, 0x02, 0xE7, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x02, 0x08, 0x04, 0x03, 0x02, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x07, 0x08, 0x07, 0x03, 0x10, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x34, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x4F, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0x6A, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x03, 0x7E, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0x9E, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x08, 0x04, 0x03, 0xB4, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x08, 0x04, 0x03, 0xC8, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x08, 0x05, 0x03, 0xD9, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x08, 0x04, 0x03, 0xF4, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x07, 0x08, 0x07, 0x04, 0x0D, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x04, 0x2F, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x04, 0x08, 0x04, 0x04, 0x49, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x04, 0x5B, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x04, 0x72, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x02, 0x08, 0x03, 0x04, 0x89, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x93, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x04, 0x08, 0x05, 0x04, 0xA9, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0x02, 0xFF, 0x03, 0x04, 0xB7, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x08, 0x02, 0x09, 0x03, 0x04, 0xBA, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x06, 0x05, 0x04, 0xBD, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0xCE, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x06, 0x04, 0x04, 0xE4, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0xF3, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x06, 0x04, 0x05, 0x06, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x03, 0x08, 0x03, 0x05, 0x15, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x05, 0x31, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0x48, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x02, 0x08, 0x02, 0x05, 0x5E, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x02, 0x08, 0x02, 0x05, 0x6B, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x04, 0x05, 0x82, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x08, 0x02, 0x05, 0x98, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x06, 0x07, 0x05, 0xA6, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0xBD, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0xCE, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFE, 0x04, 0x06, 0x05, 0x05, 0xDF, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x05, 0xFA, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x06, 0x03, 0x06, 0x11, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x1E, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x08, 0x03, 0x06, 0x2C, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x3A, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x06, 0x04, 0x06, 0x4B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x06, 0x06, 0x06, 0x06, 0x5C, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x03, 0x06, 0x04, 0x06, 0x73, // "x" (U+0078)
  0x00, 0x79, 0xFF, 0xFE, 0x04, 0x06, 0x04, 0x06, 0x85, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x03, 0x06, 0x03, 0x06, 0xA1, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x03, 0x08, 0x03, 0x06, 0xB2, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFE, 0x02, 0x08, 0x04, 0x06, 0xC8, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFF, 0x02, 0x08, 0x03, 0x06, 0xD5, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x04, 0x05, 0x05, 0x06, 0xED, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFF, 0x02, 0x06, 0x02, 0x06, 0xF4, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x08, 0x04, 0x07, 0x04, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x07, 0x17, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x03, 0x04, 0x07, 0x05, 0x07, 0x2E, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x08, 0x04, 0x07, 0x3B, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFE, 0x02, 0x08, 0x04, 0x07, 0x52, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0x5D, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x08, 0x04, 0x08, 0x05, 0x07, 0x6F, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x07, 0x08, 0x08, 0x07, 0x72, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x05, 0x03, 0x07, 0x03, 0x07, 0x94, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x05, 0x04, 0x07, 0x9C, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x07, 0xAB, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x07, 0x08, 0x08, 0x07, 0xB4, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x09, 0x04, 0x09, 0x04, 0x07, 0xD5, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x06, 0x03, 0x08, 0x04, 0x07, 0xD7, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0xDF, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x05, 0x03, 0x09, 0x03, 0x07, 0xED, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x05, 0x03, 0x09, 0x03, 0x07, 0xF9, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x08, 0x02, 0x09, 0x03, 0x08, 0x05, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFE, 0x04, 0x06, 0x05, 0x08, 0x08, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x08, 0x23, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x04, 0x02, 0x04, 0x02, 0x08, 0x41, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFE, 0x00, 0x00, 0x02, 0x08, 0x43, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x05, 0x02, 0x09, 0x03, 0x08, 0x47, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x05, 0x03, 0x07, 0x03, 0x08, 0x4D, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x05, 0x04, 0x08, 0x55, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0x61, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0x7F, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0x9E, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFE, 0x02, 0x05, 0x03, 0x08, 0xBD, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x03, 0x0B, 0x05, 0x08, 0xCF, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x08, 0xE9, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x09, 0x07, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x09, 0x26, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x09, 0x46, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x09, 0x62, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x06, 0x08, 0x06, 0x09, 0x84, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x09, 0xA2, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0xBB, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0xD3, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0xEC, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x0A, 0x06, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x1D, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x35, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x4D, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x0A, 0x66, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x7C, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x93, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xB5, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xD5, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xF6, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x17, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x39, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0B, 0x58, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x06, 0x0B, 0x66, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0B, 0x82, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0B, 0xA1, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0B, 0xC1, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x0B, 0xE2, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x04, 0x0B, 0x04, 0x0C, 0x00, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x17, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x04, 0x08, 0x05, 0x0C, 0x2B, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x4E, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x63, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x79, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x8F, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xA5, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xB9, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x06, 0x07, 0x0C, 0xD2, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x0C, 0xE9, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0C, 0xFE, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0D, 0x11, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0D, 0x25, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0D, 0x38, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x01, 0x09, 0x02, 0x0D, 0x4C, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x09, 0x02, 0x0D, 0x57, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x02, 0x09, 0x02, 0x0D, 0x65, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x03, 0x08, 0x02, 0x0D, 0x73, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x84, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x99, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xAF, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xC4, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xDA, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xF0, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x06, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0E, 0x1A, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0E, 0x22, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x35, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x4A, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x60, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x76, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFE, 0x04, 0x09, 0x04, 0x0E, 0x8A, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x04, 0x08, 0x05, 0x0E, 0xAB, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFE, 0x04, 0x08, 0x04, 0x0E, 0xCA, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x0E, 0xE9, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x05, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x0F, 0x19, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x38, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFE, 0x03, 0x08, 0x05, 0x0F, 0x4F, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0F, 0x6B, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0F, 0x82, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x9B, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0F, 0xAF, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0F, 0xC8, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x0F, 0xDC, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xF2, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x10, 0x04, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0x1E, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x10, 0x32, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x06, 0x08, 0x05, 0x10, 0x4F, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x6B, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x08, 0x05, 0x10, 0x82, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x10, 0x9C, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x08, 0x04, 0x10, 0xB3, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x10, 0xC7, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x09, 0x04, 0x10, 0xE1, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x10, 0xF8, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x08, 0x04, 0x11, 0x0F, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x11, 0x20, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x11, 0x3B, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x11, 0x50, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x09, 0x04, 0x11, 0x6A, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x11, 0x7E, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x11, 0x9C, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x11, 0xB9, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x11, 0xD7, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x11, 0xF4, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x12, 0x0F, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x08, 0x05, 0x12, 0x29, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x12, 0x46, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x12, 0x61, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x12, 0x82, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x08, 0x05, 0x12, 0x9D, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0xB8, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0B, 0x03, 0x12, 0xCD, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x03, 0x09, 0x02, 0x12, 0xE7, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x12, 0xF9, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x08, 0x02, 0x13, 0x0F, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x13, 0x1C, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x09, 0x02, 0x13, 0x35, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFE, 0x03, 0x08, 0x03, 0x13, 0x43, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFE, 0x02, 0x08, 0x02, 0x13, 0x5D, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x13, 0x74, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x06, 0x02, 0x13, 0x8A, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFF, 0x05, 0x08, 0x05, 0x13, 0x92, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x13, 0xB6, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFF, 0x03, 0x0B, 0x02, 0x13, 0xD1, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x02, 0x09, 0x02, 0x13, 0xEE, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x05, 0x08, 0x05, 0x14, 0x08, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x04, 0x08, 0x04, 0x14, 0x28, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x06, 0x04, 0x14, 0x43, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x0B, 0x04, 0x14, 0x55, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0B, 0x02, 0x14, 0x6C, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x02, 0x08, 0x04, 0x14, 0x82, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFF, 0x02, 0x08, 0x02, 0x14, 0x93, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x08, 0x04, 0x14, 0xA8, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x08, 0x03, 0x14, 0xBA, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x03, 0x08, 0x04, 0x14, 0xCB, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x08, 0x03, 0x14, 0xDD, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x08, 0x04, 0x14, 0xEE, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x08, 0x02, 0x15, 0x02, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x10, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x30, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x15, 0x46, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x15, 0x66, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x7C, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x9D, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x08, 0x05, 0x15, 0xB4, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x15, 0xCE, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x15, 0xEE, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x16, 0x06, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x25, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x39, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0x5B, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x72, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x05, 0x09, 0x05, 0x16, 0x94, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x06, 0x08, 0x07, 0x16, 0xB0, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x06, 0x06, 0x07, 0x16, 0xCE, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x16, 0xE5, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x09, 0x03, 0x17, 0x00, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x17, 0x12, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFF, 0x03, 0x06, 0x03, 0x17, 0x2D, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x17, 0x41, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x09, 0x03, 0x17, 0x5D, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x17, 0x6F, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x09, 0x04, 0x17, 0x88, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x17, 0x9C, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x09, 0x04, 0x17, 0xB6, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x17, 0xC9, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x17, 0xE3, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x17, 0xF7, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x09, 0x04, 0x18, 0x11, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x18, 0x25, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x02, 0x08, 0x03, 0x18, 0x3C, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x18, 0x4F, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x03, 0x08, 0x03, 0x18, 0x67, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x08, 0x04, 0x18, 0x7A, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x08, 0x03, 0x18, 0x8E, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x18, 0x9C, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x09, 0x05, 0x18, 0xBE, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x18, 0xD4, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x18, 0xF2, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x19, 0x06, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x19, 0x27, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x19, 0x3E, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x19, 0x62, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x19, 0x7B, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x05, 0x09, 0x05, 0x19, 0x9D, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x19, 0xB9, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x19, 0xDA, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x19, 0xF1, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x09, 0x06, 0x1A, 0x1A, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x04, 0x0B, 0x04, 0x1A, 0x37, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFE, 0x04, 0x09, 0x04, 0x1A, 0x4E, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x04, 0x0A, 0x04, 0x1A, 0x70, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x1A, 0x85, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x1A, 0xA2, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x04, 0x0A, 0x04, 0x1A, 0xB8, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x1A, 0xD2, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x1A, 0xE5, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x1B, 0x03, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x03, 0x08, 0x02, 0x1B, 0x1A, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x1B, 0x33, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFE, 0x04, 0x06, 0x05, 0x1B, 0x52, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x06, 0x05, 0x1B, 0x6D, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x04, 0x03, 0x05, 0x1B, 0x7E, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x08, 0x03, 0x09, 0x1B, 0x82, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x08, 0x04, 0x1B, 0x86, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x09, 0x04, 0x1B, 0x9B, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x06, 0x02, 0x08, 0x02, 0x1B, 0xB5, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x02, 0x08, 0x02, 0x1B, 0xBB, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0x00, 0x01, 0x02, 0x02, 0x1B, 0xC1, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x06, 0x01, 0x08, 0x02, 0x1B, 0xC7, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x06, 0x03, 0x08, 0x03, 0x1B, 0xCA, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x06, 0x03, 0x08, 0x03, 0x1B, 0xD2, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0x00, 0x02, 0x02, 0x04, 0x1B, 0xDA, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x06, 0x03, 0x08, 0x03, 0x1B, 0xE2, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x04, 0x08, 0x04, 0x1B, 0xE8, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x04, 0x08, 0x04, 0x1B, 0xFA, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x03, 0x06, 0x04, 0x1C, 0x0E, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x01, 0x07, 0x1C, 0x16, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x1C, 0x1A, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x05, 0x03, 0x1C, 0x43, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x1C, 0x4C, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x08, 0x01, 0x1C, 0x55, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x06, 0x07, 0x07, 0x1C, 0x69, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x08, 0x0A, 0x1C, 0x79, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x1C, 0x9E, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x1C, 0xC3, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x18, 0xA4, 0x77, 0x09, 0x40, 0xB1, 0x0C, 0x01, 0xA0, 0x37, 0x01, 0x10, 0x71, 0x10,
  // """ (U+0022)
  0x87, 0xA4, 0xBB, 0x37, 0x84, 0x30,
  // "#" (U+0023)
  0x28, 0x19, 0x09, 0x28, 0x92, 0x93, 0x62, 0xBC, 0xDB, 0x07, 0x29, 0x28, 0x97, 0x90, 0x90, 0xAD,
  0xCD, 0x43, 0x68, 0x10, 0x81, 0x92,
  // "$" (U+0024)
  0x20, 0x20, 0x42, 0x85, 0x6E, 0xD3, 0x0C, 0x73, 0x0D, 0x08, 0x38, 0x14, 0xD2, 0x28, 0x93, 0x18,
  0xA0, 0x14, 0x79, 0x09, 0xDA, 0x12, 0x07, 0x30,
  // "%" (U+0025)
  0x18, 0xA0, 0x7C, 0x11, 0x80, 0x19, 0x63, 0x81, 0x04, 0x58, 0x38, 0x28, 0x94, 0x64, 0xA9, 0x5A,
  0x12, 0xC6, 0x89, 0x64, 0x28, 0x91, 0x94, 0x67, 0x20, 0x37, 0x54, 0xA2, 0x83, 0xA0, 0x2C, 0x51,
  // "&" (U+0026)
  0x18, 0x11, 0xCC, 0x28, 0x68, 0x3B, 0x10, 0x87, 0x92, 0x08, 0x0C, 0x28, 0xA2, 0x58, 0xC2, 0xAC,
  0x07, 0xD4, 0xD0, 0x5D, 0x08, 0xC9, 0xB2,
  // "'" (U+0027)
  0x83, 0x93, 0xB0, 0x81,
  // "(" (U+0028)
  0x28, 0x39, 0x10, 0x56, 0x20, 0xB2, 0x03, 0x08, 0x20, 0x80, 0x42, 0x0A, 0x01, 0x20, 0xB3, 0x0A,
  0x01, 0x20, 0x70, 0x32, 0x01, 0x03, 0x20,
  // ")" (U+0029)
  0x20, 0xA3, 0x08, 0x03, 0x20, 0x70, 0x42, 0x07, 0x04, 0x20, 0x90, 0x32, 0x0B, 0x20, 0x10, 0xA2,
  0x83, 0x83, 0x02, 0x92, 0x04, 0x01, 0x20,
  // "*" (U+002A)
  0x18, 0xA0, 0x11, 0x02, 0x64, 0x08, 0xDA, 0x55, 0xA5, 0x04, 0x07, 0x10,
  // "+" (U+002B)
  0x20, 0xA4, 0x0A, 0x28, 0x36, 0xBE, 0xB5, 0x20, 0xA4, 0x0A, 0x20,
  // "," (U+002C)
  0x18, 0x54, 0x20, 0xC0, 0x37, 0x10,
  // "-" (U+002D)
  0x81, 0x8B, 0x50,
  // "." (U+002E)
  0x07, 0x01,
  // "/" (U+002F)
  0x40, 0xB3, 0x05, 0x07, 0x30, 0xB3, 0x04, 0x07, 0x30, 0xB3, 0x04, 0x07, 0x30, 0xB0, 0x12, 0x03,
  0x08, 0x30,
  // "0" (U+0030)
  0x18, 0x11, 0xBB, 0x28, 0xB6, 0xA2, 0x84, 0x1A, 0x07, 0x46, 0x60, 0x93, 0x83, 0x0B, 0x0A, 0x21,
  0xB0, 0x92, 0x76, 0x04, 0xC9, 0x20,
  // "1" (U+0031)
  0x18, 0x93, 0x7B, 0x8B, 0x81, 0x75, 0x0A, 0x20, 0xC2, 0x85, 0xB0, 0x39, 0x06, 0x61,
  // "2" (U+0032)
  0x28, 0x17, 0xBB, 0x38, 0x22, 0x09, 0x44, 0x0A, 0x02, 0x30, 0x20, 0xB4, 0x0B, 0x02, 0x30, 0x90,
  0x53, 0x07, 0x08, 0x38, 0x31, 0xFB, 0xB4, 0x10,
  // "3" (U+0033)
  0x18, 0x27, 0xBC, 0x13, 0x09, 0x04, 0x28, 0x51, 0xB1, 0x07, 0xE3, 0x30, 0x50, 0x83, 0x02, 0x0A,
  0x38, 0x47, 0x60, 0xCB, 0xA2,
  // "4" (U+0034)
  0x30, 0xD0, 0x32, 0x08, 0x0D, 0x28, 0x13, 0x8B, 0x28, 0x93, 0xA2, 0xA0, 0x73, 0x57, 0x0D, 0xCD,
  0xC3, 0x0B, 0x01, 0x30, 0xC2,
  // "5" (U+0035)
  0x18, 0x56, 0xCB, 0x30, 0xA1, 0x30, 0xB3, 0x82, 0x2D, 0xC4, 0x30, 0x20, 0xB4, 0x0C, 0x38, 0x46,
  0x80, 0xBB, 0x92,
  // "6" (U+0036)
  0x28, 0x48, 0xC5, 0x07, 0x63, 0x0C, 0x38, 0xA6, 0x4B, 0xA7, 0x07, 0x80, 0xD0, 0x93, 0x0C, 0x08,
  0x33, 0xA0, 0x3C, 0xB1, 0x10,
  // "7" (U+0037)
  0x18, 0x2B, 0xBC, 0x93, 0x09, 0x03, 0x20, 0x10, 0xB3, 0x07, 0x05, 0x30, 0xC3, 0x00, 0x63, 0x0C,
  0x30, 0x50, 0x83,
  // "8" (U+0038)
  0x18, 0xC4, 0x4C, 0xC1, 0x0B, 0x06, 0x60, 0xC1, 0xB3, 0x07, 0xF5, 0x03, 0xB9, 0x60, 0xB1, 0x1B,
  0x0C, 0x02, 0xA0, 0x6C, 0xC2, 0x10,
  // "9" (U+0039)
  0x18, 0x15, 0xCB, 0x28, 0xA0, 0xB0, 0x93, 0x48, 0x09, 0x34, 0x81, 0xD2, 0x0B, 0x9D, 0x30, 0x20,
  0x93, 0x84, 0xA2, 0x0A, 0xC5, 0x20,
  // ":" (U+003A)
  0x18, 0x1C, 0x01, 0x60, 0x81,
  // ";" (U+003B)
  0x20, 0xC7, 0x38, 0x75, 0x20, 0xC0, 0x37, 0x01, 0x20,
  // "<" (U+003C)
  0x38, 0x90, 0x55, 0x04, 0xA6, 0x05, 0xC1, 0x38, 0x23, 0xA8, 0x13, 0x03, 0x04,
  // "=" (U+003D)
  0x83, 0x5B, 0xBB, 0x55, 0x83, 0x5B, 0xBB, 0x50,
  // ">" (U+003E)
  0x00, 0x54, 0x81, 0x6A, 0x43, 0x89, 0x01, 0xD5, 0x18, 0xA3, 0x04, 0x33,
  // "?" (U+003F)
  0x18, 0x1B, 0xD4, 0x20, 0x30, 0xA2, 0x87, 0x57, 0x01, 0xB1, 0x09, 0x32, 0x0A, 0x30, 0x12, 0x05,
  0x03, 0x20,
  // "@" (U+0040)
  0x28, 0x25, 0xBC, 0x82, 0x04, 0x08, 0x28, 0xC5, 0x73, 0x0A, 0x1B, 0xC2, 0x64, 0x59, 0x19, 0x26,
  0x81, 0x91, 0x85, 0x39, 0x19, 0x75, 0x90, 0x90, 0xB6, 0xB4, 0x05, 0x76, 0x82, 0x7B, 0xA1, 0x20,
  // "A" (U+0041)
  0x30, 0x09, 0x30, 0xC0, 0xA2, 0x81, 0x67, 0xB2, 0x89, 0x5C, 0x2B, 0x03, 0xC0, 0xC0, 0x9D, 0xCC,
  0x0D, 0x28, 0x1D, 0x68, 0x20, 0xD0,
  // "B" (U+0042)
  0x18, 0xC4, 0x7C, 0xC6, 0x0A, 0x22, 0xC0, 0xC0, 0x58, 0x0E, 0xCB, 0x03, 0x80, 0xB2, 0x66, 0x09,
  0x49, 0x30, 0xC1, 0xCC, 0xC5, 0x10,
  // "C" (U+0043)
  0x28, 0x48, 0xCB, 0x07, 0x73, 0x0C, 0x30, 0x40, 0x93, 0x07, 0x06, 0x30, 0x70, 0x53, 0x05, 0x08,
  0x48, 0x1B, 0xB7, 0x10,
  // "D" (U+0044)
  0x18, 0x91, 0x7C, 0xC4, 0x0A, 0x21, 0xD0, 0xC2, 0x81, 0xD0, 0xC2, 0x8A, 0x2D, 0x39, 0x01, 0xC6,
  0x60, 0x68, 0x93, 0x1D, 0x1C, 0xCB, 0x21,
  // "E" (U+0045)
  0x18, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60, 0x53, 0x09, 0x03,
  0x38, 0x2C, 0xCB, 0x11,
  // "F" (U+0046)
  0x18, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xD4, 0x0D, 0x38, 0x53, 0xEB, 0x70, 0x67, 0x30, 0x90, 0x43,
  0x0C, 0x40,
  // "G" (U+0047)
  0x28, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48, 0x66, 0x60, 0xAD, 0x07, 0x52, 0x85,
  0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xC4, 0x10,
  // "H" (U+0048)
  0x18, 0x93, 0x75, 0x05, 0x70, 0xA2, 0x08, 0x40, 0xB2, 0x8B, 0x1B, 0x10, 0xEC, 0xCE, 0x03, 0x80,
  0x2B, 0x06, 0x50, 0x58, 0x09, 0x30, 0x75, 0x0C, 0x20, 0xA0, 0x21,
  // "I" (U+0049)
  0x28, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72,
  0x81, 0x3C, 0xB2,
  // "J" (U+004A)
  0x30, 0x70, 0x53, 0x0A, 0x02, 0x30, 0xC4, 0x0C, 0x30, 0x30, 0x93, 0x00, 0x63, 0x09, 0x03, 0x30,
  0xC3, 0x01, 0x0B, 0x28, 0x15, 0xB3, 0x20,
  // "K" (U+004B)
  0x18, 0x90, 0x75, 0x0C, 0x10, 0xA2, 0x95, 0x28, 0x1C, 0x59, 0x30, 0x0D, 0x38, 0x23, 0xDD, 0x12,
  0x82, 0x66, 0x84, 0x28, 0x29, 0x35, 0x82, 0x82, 0xC0, 0x1C, 0x20,
  // "L" (U+004C)
  0x18, 0x57, 0x50, 0xA2, 0x0C, 0x28, 0x90, 0xC0, 0x39, 0x06, 0x60, 0x93, 0x10, 0xFC,
  // "M" (U+004D)
  0x10, 0x70, 0xC2, 0x84, 0x4F, 0x10, 0xAD, 0x20, 0xA0, 0xD2, 0x84, 0xCB, 0x01, 0xBB, 0x28, 0xB3,
  0xBB, 0x08, 0x78, 0x03, 0x8A, 0x1B, 0x75, 0x06, 0x59, 0x75, 0xA2, 0x09, 0x28, 0xC0, 0xC2, 0x84,
  0xB0, 0x87, 0x0C, 0x20,
  // "N" (U+004E)
  0x10, 0x70, 0xA2, 0x8C, 0x4B, 0x0A, 0xC0, 0x39, 0x0C, 0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47,
  0xB0, 0x65, 0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB2, 0x0A, 0x07, 0x10,
  // "O" (U+004F)
  0x28, 0x19, 0xBA, 0x28, 0x57, 0x60, 0x94, 0x0D, 0x28, 0x26, 0x64, 0x92, 0x82, 0x75, 0x76, 0x28,
  0x2A, 0x28, 0x52, 0x85, 0xC0, 0x67, 0x07, 0x62, 0x81, 0xBB, 0x82,
  // "P" (U+0050)
  0x18, 0xB0, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C, 0x0A, 0x43, 0xEB, 0x60, 0x66, 0x30,
  0x90, 0x33, 0x0C, 0x40,
  // "Q" (U+0051)
  0x28, 0x19, 0xBA, 0x28, 0x57, 0x60, 0x94, 0x0D, 0x28, 0x26, 0x64, 0x92, 0x82, 0x75, 0x76, 0x28,
  0x2A, 0x28, 0x52, 0x89, 0x2D, 0x06, 0x70, 0x77, 0x01, 0xBC, 0xA4, 0x06, 0x07, 0x40, 0x10, 0xC2,
  // "R" (U+0052)
  0x18, 0xC4, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C, 0x0A, 0x43, 0xED, 0x70, 0x67, 0x84,
  0x09, 0x35, 0x80, 0xC0, 0x1C, 0x10,
  // "S" (U+0053)
  0x18, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73, 0x81, 0x1D, 0x43, 0x05, 0x08, 0x38,
  0x47, 0x60, 0xCB, 0xA2,
  // "T" (U+0054)
  0x83, 0x1B, 0xEB, 0x72, 0x0C, 0x40, 0xB3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC3,
  // "U" (U+0055)
  0x18, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2, 0x82, 0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48,
  0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x20,
  // "V" (U+0056)
  0x01, 0x0B, 0x28, 0x5B, 0x21, 0xB0, 0x2B, 0x28, 0x2B, 0x08, 0x42, 0x81, 0xC0, 0xC3, 0x81, 0xC5,
  0x73, 0x81, 0xBA, 0x13, 0x0C, 0x0A, 0x40, 0xD0, 0x43,
  // "W" (U+0057)
  0x8D, 0x41, 0xB0, 0x2C, 0x01, 0xB1, 0xB0, 0x7C, 0x06, 0x61, 0xB0, 0xBA, 0x0B, 0x01, 0xA3, 0x7A,
  0x2A, 0x01, 0xA9, 0x1A, 0x84, 0x01, 0xAA, 0x0A, 0xB2, 0x84, 0x1E, 0x60, 0xD8, 0x20, 0x19, 0x20,
  0xE0, 0x22,
  // "X" (U+0058)
  0x28, 0x2C, 0x03, 0x92, 0x82, 0x92, 0xB1, 0x28, 0x16, 0xA8, 0x30, 0x40, 0xE4, 0x09, 0x0C, 0x38,
  0x12, 0xAB, 0x38, 0x90, 0xA2, 0x93, 0x04, 0x90, 0x76, 0x10,
  // "Y" (U+0059)
  0x8A, 0x0B, 0x03, 0xAC, 0x0B, 0x2C, 0x39, 0x0A, 0xC2, 0x08, 0x92, 0x08, 0x04, 0x20, 0xB0, 0x12,
  0x0C, 0x30,
  // "Z" (U+005A)
  0x28, 0x29, 0xBE, 0x63, 0x01, 0x0D, 0x40, 0x80, 0x63, 0x02, 0x0C, 0x40, 0xA0, 0x43, 0x03, 0x0B,
  0x40, 0xB0, 0x33, 0x83, 0x3E, 0xBB, 0x11,
  // "[" (U+005B)
  0x28, 0x16, 0xC5, 0x20, 0x90, 0x13, 0x0B, 0x40, 0xB3, 0x03, 0x08, 0x30, 0x60, 0x53, 0x09, 0x02,
  0x30, 0xB4, 0x0B, 0x38, 0x11, 0xD8, 0x20,
  // "\" (U+005C)
  0x89, 0x6B, 0x0B, 0x0A, 0x08, 0x26, 0x45, 0x63, 0x81, 0xA0,
  // "]" (U+005D)
  0x20, 0xA0, 0xE3, 0x0B, 0x20, 0x20, 0x92, 0x05, 0x06, 0x20, 0x80, 0x32, 0x0A, 0x30, 0xB2, 0x01,
  0x0A, 0x28, 0x44, 0x70, 0x7C, 0x31,
  // "^" (U+005E)
  0x20, 0x53, 0x81, 0x1E, 0x42, 0x89, 0x48, 0x59, 0x01, 0xA0, 0xB0, 0x83, 0x08, 0x30,
  // "_" (U+005F)
  0x82, 0x9B, 0xB5,
  // "`" (U+0060)
  0x82, 0x45, 0x0A,
  // "a" (U+0061)
  0x18, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A, 0x35, 0xB0, 0x5C, 0x88,
  0x10,
  // "b" (U+0062)
  0x10, 0x60, 0x53, 0x09, 0x02, 0x38, 0xB2, 0xB9, 0xD1, 0x0E, 0x18, 0x53, 0x90, 0x84, 0x65, 0x0B,
  0x19, 0x52, 0xB0, 0xA9, 0xC2, 0x10,
  // "c" (U+0063)
  0x18, 0x35, 0xC8, 0x1B, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20, 0x90, 0x32, 0x81, 0x4C, 0xA1,
  // "d" (U+0064)
  0x40, 0xC4, 0x8B, 0x4B, 0x06, 0xC9, 0x81, 0xC0, 0xA5, 0x66, 0x0A, 0x29, 0x30, 0xD0, 0xA3, 0x5B,
  0x05, 0xD8, 0x81,
  // "e" (U+0065)
  0x18, 0x93, 0x5B, 0xA1, 0x91, 0xB7, 0xCA, 0x29, 0x22, 0x09, 0x03, 0x28, 0x23, 0xCB, 0x20,
  // "f" (U+0066)
  0x38, 0x12, 0xC7, 0x30, 0x80, 0x43, 0x81, 0x3D, 0xA4, 0x0C, 0x40, 0x20, 0xA4, 0x05, 0x07, 0x40,
  0x80, 0x44, 0x0A, 0x01, 0x40, 0xC4, 0x01, 0x0A, 0x38, 0x12, 0xC3, 0x30,
  // "g" (U+0067)
  0x18, 0xB2, 0x5C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xB2, 0x93, 0x0D, 0x0A, 0x35, 0xB0, 0x5C, 0x99,
  0x30, 0x06, 0x38, 0x4B, 0x10, 0xCC, 0x72,
  // "h" (U+0068)
  0x10, 0x60, 0x53, 0x09, 0x02, 0x38, 0xB2, 0xB9, 0xD1, 0x0D, 0x19, 0x33, 0x90, 0xB1, 0x65, 0x0C,
  0x09, 0x21, 0xA0, 0xC0, 0x47, 0x10,
  // "i" (U+0069)
  0x10, 0x40, 0x34, 0x89, 0x5C, 0x01, 0xB0, 0x48, 0x07, 0x50, 0x92, 0x0C, 0x20,
  // "j" (U+006A)
  0x30, 0x40, 0x37, 0x10, 0xC4, 0x0B, 0x30, 0x30, 0x83, 0x06, 0x05, 0x30, 0x90, 0x33, 0x0B, 0x40,
  0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "k" (U+006B)
  0x10, 0x06, 0x30, 0x90, 0x23, 0x89, 0x2B, 0x0B, 0x10, 0xB8, 0x40, 0x3C, 0xB2, 0x81, 0x69, 0xC2,
  0x87, 0x92, 0xB1, 0x0C, 0x08, 0x41,
  // "l" (U+006C)
  0x18, 0x56, 0x60, 0x93, 0x0C, 0x28, 0x92, 0xB0, 0x39, 0x06, 0x50, 0x92, 0x0C, 0x20,
  // "m" (U+006D)
  0x18, 0xC6, 0xB9, 0xC6, 0xD5, 0x1E, 0x0A, 0x54, 0x84, 0x90, 0xC0, 0x65, 0x75, 0x0B, 0x09, 0x29,
  0x23, 0x90, 0xC0, 0xC0, 0x66, 0x0B, 0x10,
  // "n" (U+006E)
  0x18, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75, 0x0C, 0x0A, 0x22, 0xA0, 0xC0, 0x57,
  0x10,
  // "o" (U+006F)
  0x18, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92, 0x0C, 0x09, 0x33, 0x90, 0x3C, 0xB1,
  0x10,
  // "p" (U+0070)
  0x28, 0x2B, 0x8C, 0x12, 0x8A, 0x3E, 0x17, 0x50, 0x39, 0x08, 0x40, 0x65, 0x0B, 0x10, 0x95, 0x2B,
  0x28, 0x2B, 0x9C, 0x22, 0x0B, 0x40, 0x20, 0xA4, 0x04, 0x07, 0x40,
  // "q" (U+0071)
  0x18, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xB2, 0x93, 0x0D, 0x0A, 0x35, 0xB0, 0x5D, 0x99,
  0x30, 0x06, 0x30, 0x90, 0x33, 0x0B, 0x20,
  // "r" (U+0072)
  0x18, 0x7A, 0x95, 0x1E, 0x10, 0x49, 0x20, 0x70, 0x52, 0x09, 0x02, 0x20, 0xC3,
  // "s" (U+0073)
  0x84, 0x1B, 0xC4, 0x57, 0x28, 0x12, 0xC1, 0x20, 0x50, 0xA3, 0x83, 0xD0, 0xCC, 0x51,
  // "t" (U+0074)
  0x18, 0xA4, 0x21, 0x09, 0x14, 0xEA, 0x0B, 0x03, 0x80, 0x65, 0x09, 0x20, 0x7C, 0x10,
  // "u" (U+0075)
  0x18, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97,
  0x10,
  // "v" (U+0076)
  0x8A, 0x06, 0x50, 0xC1, 0x56, 0x49, 0x05, 0x6B, 0x30, 0x49, 0xC2, 0x81, 0x4E, 0x52, 0x03, 0x0E,
  0x30,
  // "w" (U+0077)
  0x8B, 0x76, 0x62, 0xE0, 0x93, 0x65, 0x7C, 0x0C, 0x06, 0x5A, 0xA4, 0x70, 0x69, 0x7A, 0xA1, 0x06,
  0xD1, 0xAA, 0x28, 0x36, 0xB0, 0xC5, 0x20,
  // "x" (U+0078)
  0x18, 0x21, 0xA1, 0xC2, 0x81, 0xC8, 0x42, 0x09, 0x0A, 0x30, 0xC0, 0x72, 0x86, 0x85, 0xB0, 0x2B,
  0x0C, 0x10,
  // "y" (U+0079)
  0x18, 0x90, 0x56, 0x0B, 0x10, 0x57, 0x2A, 0x28, 0x24, 0x78, 0x42, 0x81, 0x38, 0xB3, 0x81, 0x2C,
  0x73, 0x81, 0x1F, 0x13, 0x02, 0x0A, 0x40, 0x90, 0x33, 0x0A, 0x09, 0x40,
  // "z" (U+007A)
  0x18, 0x21, 0xBD, 0x63, 0x0B, 0x30, 0x80, 0x52, 0x02, 0x0B, 0x30, 0xA0, 0x32, 0x82, 0x2E, 0xB6,
  0x10,
  // "{" (U+007B)
  0x28, 0x38, 0xA0, 0x1B, 0x20, 0x40, 0x82, 0x83, 0x93, 0x0A, 0x83, 0x0B, 0x30, 0xB2, 0x03, 0x09,
  0x20, 0x40, 0x82, 0x81, 0x1B, 0x21,
  // "|" (U+007C)
  0x8A, 0x43, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x80,
  // "}" (U+007D)
  0x20, 0xB0, 0x62, 0x02, 0x09, 0x20, 0x50, 0x62, 0x07, 0x05, 0x20, 0x30, 0xE2, 0x83, 0xB1, 0x01,
  0xA2, 0x04, 0x07, 0x28, 0x38, 0x40, 0x69, 0x20,
  // "~" (U+007E)
  0x89, 0x03, 0xB8, 0x34, 0x40, 0x6C, 0x20,
  // "¡" (U+00A1)
  0x20, 0xA0, 0x26, 0x09, 0x20, 0x30, 0x72, 0x07, 0x04, 0x20, 0xA0, 0x22, 0x0D, 0x20, 0x10, 0x82,
  // "¢" (U+00A2)
  0x30, 0x82, 0x85, 0x2D, 0xD1, 0x0A, 0x43, 0x0C, 0x30, 0x20, 0x93, 0x02, 0x0A, 0x48, 0x1A, 0xC3,
  0x20, 0x50, 0x32,
  // "£" (U+00A3)
  0x38, 0x18, 0xB7, 0x20, 0x20, 0xA4, 0x05, 0x06, 0x40, 0x80, 0x33, 0x82, 0x5E, 0xB4, 0x30, 0xC4,
  0x04, 0x08, 0x38, 0x31, 0xEB, 0xB5, 0x10,
  // "¤" (U+00A4)
  0x48, 0xA3, 0x12, 0xBB, 0xB8, 0x09, 0x03, 0x60, 0xA0, 0x46, 0x2A, 0xB9, 0x80,
  // "¥" (U+00A5)
  0x18, 0x93, 0xB0, 0x2A, 0x0A, 0x1A, 0x20, 0x85, 0x92, 0x86, 0x6D, 0x20, 0x3B, 0xD7, 0x20, 0x50,
  0x62, 0x82, 0x7D, 0xC4, 0x20, 0xB0, 0x12,
  // "¦" (U+00A6)
  0x86, 0x38, 0x38, 0x38, 0x38, 0x68, 0x63, 0x83, 0x83, 0x83, 0x80,
  // "§" (U+00A7)
  0x18, 0x35, 0xCB, 0x0B, 0x38, 0x94, 0x9A, 0x03, 0x86, 0x74, 0xA6, 0x50, 0x6C, 0x38, 0x3C, 0x0B,
  0xC7, 0x10,
  // "¨" (U+00A8)
  0x81, 0x64, 0x20,
  // "©" (U+00A9)
  0x28, 0x25, 0x99, 0x73, 0x89, 0x17, 0x59, 0xB7, 0x90, 0x36, 0x75, 0x28, 0x42, 0x77, 0x1A, 0x13,
  0x83, 0x86, 0x17, 0x53, 0x89, 0x28, 0x36, 0x1A, 0xB4, 0x27, 0x07, 0x42, 0x01, 0x09, 0x38, 0x25,
  0x88, 0x72,
  // "ª" (U+00AA)
  0x18, 0x90, 0x89, 0x63, 0x56, 0x22, 0x9B, 0x10,
  // "«" (U+00AB)
  0x18, 0xA0, 0x23, 0x41, 0x1B, 0x4A, 0x08, 0x5B, 0x10, 0x29, 0x56, 0x28, 0x13, 0x02, 0x10,
  // "¬" (U+00AC)
  0x83, 0x6B, 0xBC, 0x53, 0x04, 0x06, 0x30, 0x30, 0x50,
  // "®" (U+00AE)
  0x28, 0x25, 0x99, 0x73, 0x8D, 0x07, 0x6C, 0xB5, 0x90, 0x36, 0x28, 0x48, 0x27, 0x71, 0x2C, 0xD2,
  0x08, 0x61, 0x28, 0x83, 0x08, 0x36, 0x28, 0x19, 0x27, 0x07, 0x42, 0x01, 0x09, 0x38, 0x25, 0x88,
  0x72,
  // "¯" (U+00AF)
  0x80, 0x0B,
  // "°" (U+00B0)
  0x89, 0x11, 0x99, 0x07, 0x25, 0x42, 0x99, 0x10,
  // "±" (U+00B1)
  0x20, 0xA4, 0x0A, 0x28, 0x36, 0xBE, 0xB5, 0x20, 0xA4, 0x0A, 0x78, 0x36, 0xBB, 0xB5,
  // "²" (U+00B2)
  0x18, 0x15, 0x92, 0x20, 0x05, 0x20, 0xA2, 0x84, 0x92, 0x05, 0xA8, 0x10,
  // "³" (U+00B3)
  0x18, 0x15, 0x92, 0x28, 0x35, 0x50, 0x4B, 0x38, 0x3A, 0x04, 0x96, 0x10,
  // "´" (U+00B4)
  0x82, 0x1C, 0x82,
  // "µ" (U+00B5)
  0x28, 0x95, 0xC0, 0x56, 0x01, 0xB0, 0x83, 0x03, 0x80, 0xB2, 0x82, 0x65, 0x0C, 0x28, 0x29, 0x35,
  0xA2, 0x82, 0xBB, 0x97, 0x20, 0xB4, 0x02, 0x09, 0x40, 0x50, 0x64,
  // "¶" (U+00B6)
  0x18, 0x27, 0xFC, 0x91, 0xA8, 0x14, 0x82, 0xA0, 0x40, 0x81, 0xA8, 0x54, 0x80, 0xBF, 0x48, 0x28,
  0x16, 0x48, 0x28, 0x14, 0x48, 0x28, 0x14, 0x48, 0x28, 0x14, 0x48, 0x28, 0x13, 0x36,
  // "·" (U+00B7)
  0x07, 0x01,
  // "¸" (U+00B8)
  0x18, 0x35, 0x0B, 0x78,
  // "¹" (U+00B9)
  0x18, 0x75, 0x6C, 0x0A, 0x18, 0x55,
  // "º" (U+00BA)
  0x18, 0x90, 0x8A, 0x22, 0x55, 0x31, 0xA8, 0x10,
  // "»" (U+00BB)
  0x8A, 0x12, 0x34, 0x10, 0xB3, 0x90, 0xC2, 0xC8, 0x4A, 0x22, 0x02, 0x10,
  // "¼" (U+00BC)
  0x20, 0x52, 0x86, 0x64, 0x06, 0xC0, 0x18, 0x38, 0x2A, 0x09, 0x12, 0x89, 0x31, 0x85, 0x55, 0x40,
  0x56, 0x92, 0xC3, 0x28, 0x29, 0x18, 0x92, 0x86, 0x55, 0x49, 0xC2, 0x19, 0x30, 0x61,
  // "½" (U+00BD)
  0x20, 0x52, 0x86, 0x64, 0x06, 0xC0, 0x18, 0x38, 0x2A, 0x09, 0x12, 0x89, 0x31, 0x85, 0xA9, 0x20,
  0x56, 0x90, 0x55, 0x28, 0x29, 0x10, 0xA2, 0x89, 0x25, 0x50, 0x92, 0x01, 0x90, 0x5A, 0x81,
  // "¾" (U+00BE)
  0x18, 0x45, 0x92, 0x06, 0x42, 0x82, 0x55, 0x18, 0x28, 0x34, 0xB0, 0x91, 0x38, 0x92, 0xA6, 0x55,
  0x44, 0x98, 0x92, 0xC3, 0x28, 0x29, 0x18, 0x92, 0x86, 0x55, 0x49, 0xC2, 0x19, 0x30, 0x61,
  // "¿" (U+00BF)
  0x20, 0x30, 0x52, 0x01, 0x30, 0x92, 0x87, 0x39, 0x01, 0xB1, 0x07, 0x52, 0x0A, 0x03, 0x28, 0x15,
  0xCB, 0x10,
  // "À" (U+00C0)
  0x30, 0x40, 0x54, 0x0A, 0x71, 0x00, 0x93, 0x0C, 0x0A, 0x28, 0x16, 0x7B, 0x28, 0x95, 0xC2, 0xB0,
  0x3C, 0x0C, 0x09, 0xDC, 0xC0, 0xD2, 0x81, 0xD6, 0x82, 0x0D,
  // "Á" (U+00C1)
  0x40, 0x10, 0xC4, 0x08, 0x02, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B,
  0x28, 0x23, 0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "Â" (U+00C2)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x20, 0x09, 0x40, 0xC0, 0xA3, 0x81, 0x67, 0xB3, 0x81, 0xC2,
  0xB2, 0x82, 0x3C, 0x0C, 0x28, 0x29, 0xDC, 0xC2, 0x0D, 0x28, 0x2D, 0x06, 0x82, 0x0D, 0x10,
  // "Ã" (U+00C3)
  0x38, 0x25, 0xA6, 0x23, 0x81, 0x73, 0xB7, 0x40, 0x09, 0x50, 0xC0, 0xA4, 0x81, 0x67, 0xB4, 0x81,
  0xC2, 0xB3, 0x82, 0x3C, 0x0C, 0x38, 0x29, 0xDC, 0xC3, 0x0D, 0x20, 0xD2, 0x06, 0x08, 0x20, 0xD2,
  // "Ä" (U+00C4)
  0x38, 0x16, 0x42, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B, 0x28, 0x23,
  0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "Å" (U+00C5)
  0x38, 0x13, 0x81, 0x38, 0x17, 0x16, 0x38, 0x13, 0x81, 0x30, 0x09, 0x40, 0xC0, 0xA3, 0x81, 0x67,
  0xB3, 0x81, 0xC2, 0xB2, 0x82, 0x3C, 0x0C, 0x28, 0x29, 0xDC, 0xC2, 0x0D, 0x28, 0x2D, 0x06, 0x82,
  0x0D, 0x10,
  // "Æ" (U+00C6)
  0x38, 0x32, 0xED, 0xB8, 0x38, 0x19, 0x96, 0x48, 0x21, 0xC8, 0x34, 0x83, 0x86, 0xAB, 0xA3, 0x81,
  0xE1, 0xA4, 0x82, 0x7D, 0xB9, 0x48, 0x2D, 0x14, 0x73, 0x85, 0x68, 0x07, 0xDB, 0x41,
  // "Ç" (U+00C7)
  0x28, 0x48, 0xCB, 0x07, 0x73, 0x0C, 0x30, 0x40, 0x93, 0x07, 0x06, 0x30, 0x70, 0x53, 0x05, 0x08,
  0x48, 0x1B, 0xB7, 0x30, 0x54, 0x0B, 0x30, 0x70, 0x82,
  // "È" (U+00C8)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30,
  0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "É" (U+00C9)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38,
  0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "Ê" (U+00CA)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x85, 0x7C, 0xB5, 0x0A, 0x23, 0x0C, 0x48, 0x4E, 0xB7, 0x03,
  0x83, 0x06, 0x05, 0x30, 0x90, 0x33, 0x82, 0xCC, 0xB1, 0x10,
  // "Ë" (U+00CB)
  0x28, 0x16, 0x42, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60,
  0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "Ì" (U+00CC)
  0x20, 0x40, 0x54, 0x0A, 0x71, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30,
  0x20, 0xA3, 0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "Í" (U+00CD)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3,
  0x02, 0x0A, 0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "Î" (U+00CE)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C,
  0x30, 0x20, 0xA3, 0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "Ï" (U+00CF)
  0x28, 0x16, 0x42, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A,
  0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "Ð" (U+00D0)
  0x18, 0x91, 0x7C, 0xC4, 0x0A, 0x21, 0xD0, 0xD2, 0x8A, 0x7D, 0x8E, 0x90, 0xD4, 0x80, 0x1C, 0x75,
  0x06, 0x89, 0x31, 0xC1, 0xCC, 0xB2, 0x10,
  // "Ñ" (U+00D1)
  0x28, 0x25, 0xA6, 0x22, 0x81, 0x73, 0xB7, 0x10, 0x70, 0xA2, 0x8C, 0x4B, 0x0A, 0xC0, 0x39, 0x0C,
  0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47, 0xB0, 0x65, 0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB2, 0x0A,
  0x07, 0x10,
  // "Ò" (U+00D2)
  0x20, 0x40, 0x55, 0x0A, 0x73, 0x81, 0x9B, 0xA2, 0x85, 0x76, 0x09, 0x40, 0xD2, 0x82, 0x66, 0x49,
  0x28, 0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B, 0xB8, 0x20,
  // "Ó" (U+00D3)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x72, 0x81, 0x9B, 0xA2, 0x85, 0x76, 0x09, 0x40, 0xD2, 0x82, 0x66,
  0x49, 0x28, 0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B, 0xB8,
  0x20,
  // "Ô" (U+00D4)
  0x30, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x28, 0x19, 0xBA, 0x28, 0x57, 0x60, 0x94, 0x0D, 0x28, 0x26,
  0x64, 0x92, 0x82, 0x75, 0x76, 0x28, 0x2A, 0x28, 0x52, 0x85, 0xC0, 0x67, 0x07, 0x62, 0x81, 0xBB,
  0x82,
  // "Õ" (U+00D5)
  0x28, 0x25, 0xA6, 0x22, 0x81, 0x73, 0xB7, 0x28, 0x19, 0xBA, 0x28, 0x57, 0x60, 0x94, 0x0D, 0x28,
  0x26, 0x64, 0x92, 0x82, 0x75, 0x76, 0x28, 0x2A, 0x28, 0x52, 0x85, 0xC0, 0x67, 0x07, 0x62, 0x81,
  0xBB, 0x82,
  // "Ö" (U+00D6)
  0x38, 0x16, 0x42, 0x71, 0x81, 0x9B, 0xA2, 0x85, 0x76, 0x09, 0x40, 0xD2, 0x82, 0x66, 0x49, 0x28,
  0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B, 0xB8, 0x20,
  // "×" (U+00D7)
  0x8A, 0x61, 0x10, 0x21, 0x1B, 0x4B, 0x10, 0x3F, 0x30, 0x2B, 0x3B, 0x11, 0x10, 0x11,
  // "Ø" (U+00D8)
  0x50, 0x22, 0x8D, 0x29, 0xCB, 0x80, 0x76, 0x0D, 0x40, 0xC0, 0x7B, 0x64, 0x82, 0x97, 0x57, 0x6B,
  0x1A, 0x28, 0xD6, 0x0C, 0x06, 0xC0, 0x76, 0x07, 0xBB, 0x82, 0x02, 0x50,
  // "Ù" (U+00D9)
  0x20, 0x40, 0x55, 0x0A, 0x72, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28, 0x2B, 0x11,
  0xB2, 0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC, 0x72,
  // "Ú" (U+00DA)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28, 0x2B,
  0x11, 0xB2, 0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC, 0x72,
  // "Û" (U+00DB)
  0x30, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2, 0x82,
  0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x20,
  // "Ü" (U+00DC)
  0x38, 0x16, 0x42, 0x78, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2, 0x82, 0xB1, 0x1B, 0x28,
  0xA6, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x20,
  // "Ý" (U+00DD)
  0x10, 0x10, 0xC2, 0x08, 0x02, 0x58, 0xA0, 0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89,
  0x20, 0x80, 0x42, 0x0B, 0x01, 0x20, 0xC3,
  // "Þ" (U+00DE)
  0x10, 0x70, 0x53, 0x81, 0xAD, 0xA2, 0x8A, 0x3C, 0x09, 0x50, 0xB0, 0x85, 0x38, 0x1C, 0x16, 0xDB,
  0x30, 0x92, 0x30, 0xC4,
  // "ß" (U+00DF)
  0x38, 0x21, 0xBC, 0x43, 0x82, 0x84, 0x57, 0x38, 0x2C, 0x1B, 0x13, 0x81, 0xB8, 0x43, 0x82, 0x39,
  0x95, 0x38, 0x26, 0x61, 0xC3, 0x82, 0x93, 0x0D, 0x38, 0x2B, 0x8C, 0x73, 0x0C, 0x50, 0x30, 0x84,
  0x81, 0x3C, 0x24,
  // "à" (U+00E0)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A,
  0x35, 0xB0, 0x5C, 0x88, 0x10,
  // "á" (U+00E1)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C,
  0x0A, 0x35, 0xB0, 0x5C, 0x88, 0x10,
  // "â" (U+00E2)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x8B, 0x26, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30,
  0xC0, 0xA3, 0x5B, 0x05, 0xC8, 0x81,
  // "ã" (U+00E3)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x26, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30,
  0xC0, 0xA3, 0x5B, 0x05, 0xC8, 0x81,
  // "ä" (U+00E4)
  0x28, 0x16, 0x42, 0x68, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A, 0x35,
  0xB0, 0x5C, 0x88, 0x10,
  // "å" (U+00E5)
  0x28, 0x13, 0x81, 0x28, 0x17, 0x16, 0x28, 0xB6, 0x38, 0x10, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60,
  0xA1, 0x93, 0x0C, 0x0A, 0x35, 0xB0, 0x5C, 0x88, 0x10,
  // "æ" (U+00E6)
  0x18, 0xA6, 0x6C, 0xAA, 0xC6, 0x1C, 0x0C, 0x55, 0x76, 0x60, 0xCA, 0x80, 0x93, 0x0B, 0x38, 0x2A,
  0x36, 0xD3, 0x84, 0x5C, 0x8A, 0xC9, 0x10,
  // "ç" (U+00E7)
  0x18, 0x35, 0xC8, 0x1B, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20, 0x90, 0x32, 0x81, 0x4C, 0xA2, 0x05,
  0x30, 0xB2, 0x07, 0x08, 0x20,
  // "è" (U+00E8)
  0x10, 0x40, 0x53, 0x0A, 0x68, 0x93, 0x5B, 0xA1, 0x91, 0xB7, 0xCA, 0x29, 0x22, 0x09, 0x03, 0x28,
  0x23, 0xCB, 0x20,
  // "é" (U+00E9)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x58, 0x93, 0x5B, 0xA1, 0x91, 0xB7, 0xCA, 0x29, 0x22, 0x09, 0x03,
  0x28, 0x23, 0xCB, 0x20,
  // "ê" (U+00EA)
  0x28, 0x4D, 0x40, 0x73, 0x85, 0x89, 0x35, 0xBA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x20, 0x90, 0x32,
  0x82, 0x3C, 0xB2,
  // "ë" (U+00EB)
  0x28, 0x16, 0x42, 0x68, 0x96, 0x5B, 0xA0, 0x19, 0x1B, 0x07, 0xCA, 0x20, 0x92, 0x30, 0x90, 0x33,
  0x82, 0x3C, 0xB2, 0x10,
  // "ì" (U+00EC)
  0x82, 0x45, 0x0A, 0x38, 0x90, 0xC1, 0xB4, 0x87, 0x59, 0x2C, 0x10,
  // "í" (U+00ED)
  0x18, 0x31, 0xC0, 0x82, 0x48, 0x95, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC2,
  // "î" (U+00EE)
  0x18, 0x3D, 0x47, 0x38, 0x48, 0x95, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC2,
  // "ï" (U+00EF)
  0x18, 0x16, 0x42, 0x50, 0xC2, 0x01, 0x0B, 0x20, 0x40, 0x82, 0x07, 0x05, 0x20, 0x90, 0x22, 0x0C,
  0x30,
  // "ð" (U+00F0)
  0x28, 0x5B, 0x83, 0x03, 0xA9, 0x40, 0xB2, 0x8A, 0x58, 0xBB, 0x25, 0x80, 0xD1, 0xA1, 0x0C, 0x0B,
  0x13, 0x90, 0x5C, 0xB1, 0x10,
  // "ñ" (U+00F1)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x2B, 0x9D, 0x11, 0xE1, 0x93, 0x49, 0x0B, 0x17, 0x50,
  0xC0, 0xA2, 0x2A, 0x0C, 0x05, 0x71,
  // "ò" (U+00F2)
  0x10, 0x40, 0x54, 0x0A, 0x71, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20, 0xC0,
  0x93, 0x39, 0x03, 0xCB, 0x11,
  // "ó" (U+00F3)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92, 0x0C,
  0x09, 0x33, 0x90, 0x3C, 0xB1, 0x10,
  // "ô" (U+00F4)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20,
  0xC0, 0x93, 0x39, 0x03, 0xCB, 0x11,
  // "õ" (U+00F5)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20,
  0xC0, 0x93, 0x39, 0x03, 0xCB, 0x11,
  // "ö" (U+00F6)
  0x28, 0x16, 0x42, 0x68, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92, 0x0C, 0x09, 0x33,
  0x90, 0x3C, 0xB1, 0x10,
  // "÷" (U+00F7)
  0x20, 0x87, 0x83, 0x6B, 0xBB, 0x57, 0x08, 0x20,
  // "ø" (U+00F8)
  0x48, 0xB6, 0x20, 0x6C, 0xC3, 0x1B, 0x1E, 0x27, 0x5A, 0xB2, 0x98, 0x5B, 0x09, 0xA3, 0x90, 0x9C,
  0xB1, 0x03, 0x40,
  // "ù" (U+00F9)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09,
  0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "ú" (U+00FA)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C,
  0x09, 0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "û" (U+00FB)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x8B, 0x2C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50,
  0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x71,
  // "ü" (U+00FC)
  0x28, 0x16, 0x42, 0x68, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09, 0x36,
  0xA0, 0x6C, 0x97, 0x10,
  // "ý" (U+00FD)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x89, 0x05, 0x60, 0xB1, 0x05, 0x72, 0xA2, 0x82, 0x47, 0x84,
  0x28, 0x13, 0x8B, 0x38, 0x12, 0xC7, 0x38, 0x11, 0xF1, 0x30, 0x20, 0xA4, 0x09, 0x03, 0x30, 0xA0,
  0x94,
  // "þ" (U+00FE)
  0x20, 0x06, 0x40, 0x90, 0x24, 0x82, 0xB8, 0xC1, 0x28, 0xA3, 0xD1, 0x75, 0x02, 0x90, 0x84, 0x05,
  0x50, 0xB1, 0x08, 0x52, 0xB2, 0x82, 0xA9, 0xC2, 0x20, 0xB4, 0x01, 0x09, 0x40, 0x40, 0x74,
  // "ÿ" (U+00FF)
  0x28, 0x16, 0x42, 0x71, 0x89, 0x05, 0x60, 0xB1, 0x05, 0x72, 0xA2, 0x82, 0x47, 0x84, 0x28, 0x13,
  0x8B, 0x38, 0x12, 0xC7, 0x38, 0x11, 0xF1, 0x30, 0x20, 0xA4, 0x09, 0x03, 0x30, 0xA0, 0x94,
  // "Ā" (U+0100)
  0x38, 0x19, 0xB7, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B, 0x28, 0x23,
  0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "ā" (U+0101)
  0x28, 0x19, 0xB7, 0x68, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A, 0x35,
  0xB0, 0x5C, 0x88, 0x10,
  // "Ă" (U+0102)
  0x38, 0x15, 0x05, 0x38, 0x14, 0xC4, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C,
  0x2B, 0x28, 0x23, 0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "ă" (U+0103)
  0x28, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x68, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93,
  0x0C, 0x0A, 0x35, 0xB0, 0x5C, 0x88, 0x10,
  // "Ą" (U+0104)
  0x30, 0x09, 0x30, 0xC0, 0xA2, 0x81, 0x67, 0xB2, 0x89, 0x5C, 0x2B, 0x03, 0xC0, 0xC0, 0x9D, 0xCC,
  0x0D, 0x28, 0x1D, 0x68, 0x20, 0xD4, 0x05, 0x30, 0x40, 0x53, 0x03, 0x0A,
  // "ą" (U+0105)
  0x18, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A, 0x35, 0xB0, 0x5C, 0x88,
  0x30, 0x53, 0x04, 0x05, 0x30, 0x30, 0xA2,
  // "Ć" (U+0106)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x48, 0xCB, 0x07, 0x73, 0x0C, 0x30, 0x40, 0x93, 0x07, 0x06,
  0x30, 0x70, 0x53, 0x05, 0x08, 0x48, 0x1B, 0xB7, 0x10,
  // "ć" (U+0107)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x58, 0x35, 0xC8, 0x1B, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20, 0x90,
  0x32, 0x81, 0x4C, 0xA1,
  // "Ĉ" (U+0108)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x84, 0x8C, 0xB0, 0x77, 0x30, 0xC3, 0x04, 0x09, 0x30, 0x70,
  0x63, 0x07, 0x05, 0x30, 0x50, 0x84, 0x81, 0xBB, 0x71,
  // "ĉ" (U+0109)
  0x28, 0x4D, 0x40, 0x73, 0x85, 0x83, 0x5C, 0x81, 0xB2, 0x06, 0x05, 0x20, 0x90, 0x22, 0x09, 0x03,
  0x28, 0x14, 0xCA, 0x10,
  // "Ċ" (U+010A)
  0x30, 0x60, 0x17, 0x84, 0x8C, 0xB0, 0x77, 0x30, 0xC3, 0x04, 0x09, 0x30, 0x70, 0x63, 0x07, 0x05,
  0x30, 0x50, 0x84, 0x81, 0xBB, 0x71,
  // "ċ" (U+010B)
  0x20, 0x60, 0x15, 0x83, 0x5C, 0x81, 0xB2, 0x06, 0x05, 0x20, 0x90, 0x22, 0x09, 0x03, 0x28, 0x14,
  0xCA, 0x10,
  // "Č" (U+010C)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x78, 0x48, 0xCB, 0x07, 0x73, 0x0C, 0x30, 0x40, 0x93, 0x07,
  0x06, 0x30, 0x70, 0x53, 0x05, 0x08, 0x48, 0x1B, 0xB7, 0x10,
  // "č" (U+010D)
  0x18, 0x56, 0x49, 0x01, 0xE2, 0x58, 0x35, 0xC8, 0x1B, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20, 0x90,
  0x32, 0x81, 0x4C, 0xA1,
  // "Ď" (U+010E)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x91, 0x7C, 0xC4, 0x0A, 0x21, 0xD0, 0xC2, 0x81, 0xD0,
  0xC2, 0x8A, 0x2D, 0x39, 0x01, 0xC6, 0x60, 0x68, 0x93, 0x1D, 0x1C, 0xCB, 0x21,
  // "ď" (U+010F)
  0x48, 0x1C, 0x74, 0x40, 0xB0, 0x42, 0x82, 0x6C, 0x98, 0x28, 0x31, 0xC0, 0xA5, 0x28, 0x36, 0x60,
  0xA2, 0x28, 0x29, 0x30, 0xD3, 0x82, 0xA3, 0x5B, 0x38, 0x25, 0xD8, 0x83,
  // "Đ" (U+0110)
  0x18, 0x91, 0x7C, 0xC4, 0x0A, 0x21, 0xD0, 0xD2, 0x8A, 0x7D, 0x8E, 0x90, 0xD4, 0x80, 0x1C, 0x75,
  0x06, 0x89, 0x31, 0xC1, 0xCC, 0xB2, 0x10,
  // "đ" (U+0111)
  0x28, 0x22, 0xAE, 0x43, 0x02, 0x09, 0x28, 0xA3, 0x6C, 0xA6, 0x01, 0xC0, 0xA3, 0x06, 0x60, 0xA1,
  0x09, 0x30, 0xC2, 0x82, 0xA3, 0x5B, 0x28, 0x25, 0xD8, 0x82,
  // "Ē" (U+0112)
  0x28, 0x19, 0xB7, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60,
  0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ē" (U+0113)
  0x28, 0x19, 0xB7, 0x68, 0x96, 0x5B, 0xA0, 0x19, 0x1B, 0x07, 0xCA, 0x20, 0x92, 0x30, 0x90, 0x33,
  0x82, 0x3C, 0xB2, 0x10,
  // "Ĕ" (U+0114)
  0x28, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70,
  0x38, 0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ĕ" (U+0115)
  0x28, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x68, 0x96, 0x5B, 0xA0, 0x19, 0x1B, 0x07, 0xCA, 0x20, 0x92,
  0x30, 0x90, 0x33, 0x82, 0x3C, 0xB2, 0x10,
  // "Ė" (U+0116)
  0x30, 0x60, 0x16, 0x85, 0x7C, 0xB5, 0x0A, 0x23, 0x0C, 0x48, 0x4E, 0xB7, 0x03, 0x83, 0x06, 0x05,
  0x30, 0x90, 0x33, 0x82, 0xCC, 0xB1, 0x10,
  // "ė" (U+0117)
  0x20, 0x60, 0x15, 0x89, 0x35, 0xBA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x20, 0x90, 0x32, 0x82, 0x3C,
  0xB2,
  // "Ę" (U+0118)
  0x18, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60, 0x53, 0x09, 0x03,
  0x38, 0x2C, 0xCB, 0x13, 0x05, 0x30, 0x40, 0x53, 0x03, 0x0A, 0x20,
  // "ę" (U+0119)
  0x18, 0x97, 0x5C, 0x91, 0xC0, 0xC7, 0x73, 0xA9, 0xC9, 0x19, 0x32, 0x85, 0x3C, 0xC2, 0x02, 0x72,
  0x08, 0x02, 0x20, 0x60, 0x91,
  // "Ě" (U+011A)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70,
  0x38, 0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ě" (U+011B)
  0x18, 0x56, 0x49, 0x01, 0xE2, 0x58, 0x93, 0x5B, 0xA1, 0x91, 0xB7, 0xCA, 0x29, 0x22, 0x09, 0x03,
  0x28, 0x23, 0xCB, 0x20,
  // "Ĝ" (U+011C)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48,
  0x66, 0x60, 0xAD, 0x07, 0x52, 0x85, 0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xC4, 0x10,
  // "ĝ" (U+011D)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x8B, 0x25, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30,
  0xD0, 0xA3, 0x5B, 0x05, 0xC9, 0x93, 0x00, 0x63, 0x84, 0xB1, 0x0C, 0xC7, 0x20,
  // "Ğ" (U+011E)
  0x38, 0x15, 0x05, 0x38, 0x14, 0xC4, 0x71, 0x85, 0x7B, 0xC5, 0x07, 0x84, 0x0C, 0x40, 0x40, 0x94,
  0x86, 0x66, 0x0A, 0xD0, 0x75, 0x28, 0x5B, 0x05, 0x80, 0x38, 0x28, 0x2A, 0xBC, 0x41,
  // "ğ" (U+011F)
  0x18, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x78, 0xB2, 0x5C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xB2, 0x93,
  0x0D, 0x0A, 0x35, 0xB0, 0x5C, 0x99, 0x30, 0x06, 0x38, 0x4B, 0x10, 0xCC, 0x72,
  // "Ġ" (U+0120)
  0x30, 0x60, 0x17, 0x28, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48, 0x66, 0x60, 0xAD,
  0x07, 0x52, 0x85, 0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xC4, 0x10,
  // "ġ" (U+0121)
  0x20, 0x60, 0x17, 0x8B, 0x25, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30, 0xD0, 0xA3, 0x5B,
  0x05, 0xC9, 0x93, 0x00, 0x63, 0x84, 0xB1, 0x0C, 0xC7, 0x20,
  // "Ģ" (U+0122)
  0x28, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48, 0x66, 0x60, 0xAD, 0x07, 0x52, 0x85,
  0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xC4, 0x30, 0xA0, 0x13, 0x01, 0x08, 0x30,
  // "ģ" (U+0123)
  0x20, 0x30, 0x63, 0x0B, 0x38, 0xB2, 0x5C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xB2, 0x93, 0x0D, 0x0A,
  0x35, 0xB0, 0x5C, 0x99, 0x30, 0x06, 0x38, 0x4B, 0x10, 0xCC, 0x72,
  // "Ĥ" (U+0124)
  0x30, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x93, 0x75, 0x05, 0x70, 0xA2, 0x08, 0x40, 0xB2, 0x8B,
  0x1B, 0x10, 0xEC, 0xCE, 0x03, 0x80, 0x2B, 0x06, 0x50, 0x58, 0x09, 0x30, 0x75, 0x0C, 0x20, 0xA0,
  0x21,
  // "ĥ" (U+0125)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x06, 0x05, 0x30, 0x90, 0x23, 0x8B, 0x2B, 0x9D, 0x10, 0xD1,
  0x93, 0x39, 0x0B, 0x16, 0x50, 0xC0, 0x92, 0x1A, 0x0C, 0x04, 0x71,
  // "Ħ" (U+0126)
  0x18, 0x93, 0x75, 0x05, 0x74, 0xEB, 0xBD, 0xC0, 0xC2, 0x8B, 0x1B, 0x11, 0xEB, 0xBD, 0x03, 0x80,
  0x2A, 0x06, 0x50, 0x58, 0x09, 0x30, 0x75, 0x0C, 0x20, 0xA0, 0x21,
  // "ħ" (U+0127)
  0x82, 0x2D, 0xB4, 0x20, 0xB4, 0x8B, 0x2D, 0x9D, 0x11, 0xE0, 0x93, 0x48, 0x0B, 0x17, 0x50, 0xC0,
  0xA2, 0x1A, 0x0C, 0x04, 0x71,
  // "Ĩ" (U+0128)
  0x28, 0x25, 0xA6, 0x22, 0x81, 0x73, 0xB7, 0x28, 0x1B, 0xD3, 0x30, 0x06, 0x40, 0x90, 0x34, 0x0C,
  0x50, 0xC4, 0x02, 0x0A, 0x40, 0x50, 0x73, 0x81, 0x3C, 0xB3,
  // "ĩ" (U+0129)
  0x85, 0x5A, 0x62, 0x73, 0xB6, 0x0C, 0x20, 0x10, 0xB2, 0x04, 0x08, 0x20, 0x70, 0x52, 0x09, 0x02,
  0x20, 0xC3,
  // "Ī" (U+012A)
  0x28, 0x19, 0xB7, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A,
  0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "ī" (U+012B)
  0x81, 0x9B, 0x74, 0x89, 0x5C, 0x01, 0xB0, 0x48, 0x07, 0x50, 0x92, 0x0C, 0x20,
  // "Ĭ" (U+012C)
  0x28, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "ĭ" (U+012D)
  0x84, 0x50, 0x54, 0xC4, 0x48, 0x95, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC2,
  // "Į" (U+012E)
  0x28, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72,
  0x81, 0x3C, 0xB3, 0x05, 0x30, 0x40, 0x53, 0x03, 0x0A, 0x30,
  // "į" (U+012F)
  0x20, 0x40, 0x36, 0x0C, 0x20, 0x10, 0xB2, 0x04, 0x08, 0x20, 0x70, 0x52, 0x09, 0x02, 0x20, 0xC3,
  0x05, 0x20, 0x40, 0x52, 0x03, 0x0A, 0x20,
  // "İ" (U+0130)
  0x30, 0x60, 0x17, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30, 0x20, 0xA3,
  0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "ı" (U+0131)
  0x18, 0x90, 0xC1, 0xB4, 0x87, 0x59, 0x2C, 0x10,
  // "Ĳ" (U+0132)
  0x28, 0x3B, 0xD3, 0x75, 0x28, 0x36, 0x60, 0xA2, 0x28, 0x29, 0x30, 0xC3, 0x0C, 0x20, 0xC3, 0x82,
  0xC0, 0x39, 0x28, 0x32, 0xA0, 0x66, 0x28, 0x91, 0x57, 0x09, 0x30, 0x3C, 0xB0, 0xC5, 0x01, 0x0B,
  0x48, 0x15, 0xB3, 0x20,
  // "ĳ" (U+0133)
  0x18, 0x24, 0x34, 0x36, 0x8B, 0x1C, 0x0C, 0x01, 0xB0, 0xB0, 0x48, 0x38, 0x07, 0x56, 0x50, 0x92,
  0x93, 0x0C, 0x0B, 0x40, 0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "Ĵ" (U+0134)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x20, 0x70, 0x54, 0x0A, 0x02, 0x40, 0xC5, 0x0C, 0x40, 0x30,
  0x94, 0x00, 0x64, 0x09, 0x03, 0x40, 0xC4, 0x01, 0x0B, 0x38, 0x15, 0xB3, 0x30,
  // "ĵ" (U+0135)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x10, 0xC4, 0x0B, 0x30, 0x30, 0x83, 0x06, 0x05, 0x30, 0x90,
  0x33, 0x0B, 0x40, 0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "Ķ" (U+0136)
  0x18, 0x90, 0x75, 0x0C, 0x10, 0xA2, 0x95, 0x28, 0x1C, 0x59, 0x30, 0x0D, 0x38, 0x23, 0xDD, 0x12,
  0x82, 0x66, 0x84, 0x28, 0x29, 0x35, 0x82, 0x82, 0xC0, 0x1C, 0x30, 0xA0, 0x13, 0x01, 0x08, 0x40,
  // "ķ" (U+0137)
  0x10, 0x06, 0x30, 0x90, 0x23, 0x89, 0x2B, 0x0B, 0x10, 0xB8, 0x40, 0x3C, 0xB2, 0x81, 0x69, 0xC2,
  0x87, 0x92, 0xB1, 0x0C, 0x08, 0x42, 0x0A, 0x01, 0x20, 0x10, 0x83,
  // "ĸ" (U+0138)
  0x18, 0x92, 0xC0, 0xB1, 0x1B, 0x84, 0x04, 0xCB, 0x28, 0x17, 0x9C, 0x28, 0x79, 0x2B, 0x10, 0xC0,
  0x84, 0x10,
  // "Ĺ" (U+0139)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x50, 0x70, 0x52, 0x0A, 0x02, 0x20, 0xC3, 0x0C, 0x20, 0x30, 0x92,
  0x00, 0x62, 0x09, 0x03, 0x20, 0xFC, 0x10,
  // "ĺ" (U+013A)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x50, 0x06, 0x20, 0x90, 0x32, 0x0C, 0x30, 0xB2, 0x03, 0x09, 0x20,
  0x60, 0x52, 0x09, 0x02, 0x20, 0xC3,
  // "Ļ" (U+013B)
  0x18, 0x57, 0x50, 0xA2, 0x0C, 0x28, 0xA1, 0xC0, 0x39, 0x06, 0x60, 0x93, 0x0C, 0xCC, 0x0A, 0x11,
  0x81,
  // "ļ" (U+013C)
  0x20, 0x06, 0x20, 0x90, 0x32, 0x0C, 0x30, 0xB2, 0x03, 0x09, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20,
  0xC3, 0x83, 0xA1, 0x01, 0x82,
  // "Ľ" (U+013D)
  0x18, 0x67, 0x57, 0x40, 0xA2, 0x42, 0x0C, 0x40, 0xC3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33,
  0x0F, 0xC2,
  // "ľ" (U+013E)
  0x18, 0x46, 0xD4, 0x09, 0x72, 0x0C, 0x30, 0xB2, 0x03, 0x09, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20,
  0xC3,
  // "Ŀ" (U+013F)
  0x10, 0x70, 0x52, 0x0A, 0x02, 0x20, 0xC3, 0x83, 0xC6, 0x13, 0x92, 0x00, 0x62, 0x09, 0x03, 0x20,
  0xFC, 0x10,
  // "ŀ" (U+0140)
  0x10, 0x06, 0x20, 0x90, 0x32, 0x0C, 0x38, 0x3B, 0x61, 0x39, 0x20, 0x60, 0x52, 0x09, 0x02, 0x20,
  0xC3,
  // "Ł" (U+0141)
  0x10, 0x06, 0x20, 0x90, 0x32, 0x0C, 0x01, 0x28, 0x3E, 0xB0, 0x9B, 0x20, 0x80, 0x72, 0x08, 0x04,
  0x28, 0x2B, 0xCC, 0x10,
  // "ł" (U+0142)
  0x18, 0x55, 0x60, 0x83, 0x0B, 0x28, 0x92, 0xE7, 0xBA, 0x05, 0x60, 0x83, 0x0B, 0x20,
  // "Ń" (U+0143)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x07, 0x0A, 0x28, 0xC4, 0xB0, 0xAC, 0x03, 0x90, 0xCA, 0x15,
  0x60, 0xB7, 0x48, 0x33, 0x84, 0x7B, 0x06, 0x51, 0xAC, 0x09, 0x30, 0xCA, 0x0B, 0x20, 0xA0, 0x71,
  // "ń" (U+0144)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75, 0x0C,
  0x0A, 0x22, 0xA0, 0xC0, 0x57, 0x10,
  // "Ņ" (U+0145)
  0x10, 0x70, 0xA2, 0x8C, 0x4B, 0x0A, 0xC0, 0x39, 0x0C, 0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47,
  0xB0, 0x65, 0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB2, 0x0A, 0x07, 0x30, 0xA0, 0x13, 0x01, 0x08, 0x30,
  // "ņ" (U+0146)
  0x18, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75, 0x0C, 0x0A, 0x22, 0xA0, 0xC0, 0x57,
  0x20, 0xA0, 0x12, 0x01, 0x08, 0x30,
  // "Ň" (U+0147)
  0x28, 0x16, 0x49, 0x38, 0x11, 0xE2, 0x71, 0x07, 0x0A, 0x28, 0xC4, 0xB0, 0xAC, 0x03, 0x90, 0xCA,
  0x15, 0x60, 0xB7, 0x48, 0x33, 0x84, 0x7B, 0x06, 0x51, 0xAC, 0x09, 0x30, 0xCA, 0x0B, 0x20, 0xA0,
  0x71,
  // "ň" (U+0148)
  0x18, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x78, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75,
  0x0C, 0x0A, 0x22, 0xA0, 0xC0, 0x57, 0x10,
  // "ŉ" (U+0149)
  0x10, 0xA0, 0x33, 0x01, 0x0A, 0x48, 0xA5, 0x22, 0xB9, 0xD1, 0x01, 0xE1, 0x93, 0x04, 0x90, 0xB1,
  0x07, 0x50, 0xC2, 0x82, 0xA2, 0x2A, 0x28, 0x2C, 0x05, 0x71,
  // "Ŋ" (U+014A)
  0x10, 0x70, 0xA2, 0x8C, 0x4B, 0x0A, 0xD0, 0x39, 0x0C, 0xA1, 0x66, 0x0B, 0x64, 0x83, 0x38, 0x38,
  0xB0, 0x65, 0x0B, 0xB0, 0x92, 0x0C, 0x90, 0xB2, 0x09, 0x06, 0x40, 0x90, 0x23, 0x0B, 0x08, 0x20,
  // "ŋ" (U+014B)
  0x18, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75, 0x0C, 0x09, 0x21, 0xB0, 0xC0, 0x48,
  0x30, 0x70, 0x53, 0x0A, 0x01, 0x20, 0x90, 0xA2,
  // "Ō" (U+014C)
  0x28, 0x19, 0xB7, 0x72, 0x81, 0x9B, 0xA2, 0x85, 0x76, 0x09, 0x40, 0xD2, 0x82, 0x66, 0x49, 0x28,
  0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B, 0xB8, 0x20,
  // "ō" (U+014D)
  0x18, 0x19, 0xB7, 0x78, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92, 0x0C, 0x09, 0x33,
  0x90, 0x3C, 0xB1, 0x10,
  // "Ŏ" (U+014E)
  0x28, 0x15, 0x05, 0x38, 0x14, 0xC4, 0x72, 0x81, 0x9B, 0xA2, 0x85, 0x76, 0x09, 0x40, 0xD2, 0x82,
  0x66, 0x49, 0x28, 0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B,
  0xB8, 0x20,
  // "ŏ" (U+014F)
  0x18, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x78, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92,
  0x0C, 0x09, 0x33, 0x90, 0x3C, 0xB1, 0x10,
  // "Ő" (U+0150)
  0x28, 0x21, 0xA6, 0x52, 0x81, 0x74, 0x87, 0x28, 0x19, 0xBA, 0x28, 0x57, 0x60, 0x94, 0x0D, 0x28,
  0x26, 0x64, 0x92, 0x82, 0x75, 0x76, 0x28, 0x2A, 0x28, 0x52, 0x85, 0xC0, 0x67, 0x07, 0x62, 0x81,
  0xBB, 0x82,
  // "ő" (U+0151)
  0x28, 0x21, 0xA6, 0x52, 0x81, 0x74, 0x87, 0x18, 0x16, 0xCA, 0x28, 0x96, 0x2B, 0x0A, 0x20, 0x75,
  0x0A, 0x20, 0x92, 0x0C, 0x28, 0x29, 0x33, 0x92, 0x82, 0x3C, 0xB1, 0x20,
  // "Œ" (U+0152)
  0x28, 0x90, 0x9B, 0xEB, 0xB0, 0x86, 0x1A, 0x38, 0x2C, 0x04, 0x72, 0x89, 0x24, 0x90, 0x7C, 0xB2,
  0x76, 0x0A, 0x12, 0x82, 0x85, 0x0C, 0x38, 0x26, 0x70, 0xB4, 0x83, 0xBC, 0xEB, 0x71,
  // "œ" (U+0153)
  0x18, 0xA6, 0x6C, 0x97, 0xC8, 0x1B, 0x0A, 0x72, 0xA7, 0x50, 0xAB, 0x91, 0x92, 0x0D, 0x38, 0x39,
  0x23, 0xE1, 0x28, 0x43, 0xCA, 0x4C, 0xB1,
  // "Ŕ" (U+0154)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x68, 0xC4, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C, 0x0A,
  0x43, 0xED, 0x70, 0x67, 0x84, 0x09, 0x35, 0x80, 0xC0, 0x1C, 0x10,
  // "ŕ" (U+0155)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x58, 0x7A, 0x95, 0x1E, 0x10, 0x49, 0x20, 0x70, 0x52, 0x09, 0x02,
  0x20, 0xC3,
  // "Ŗ" (U+0156)
  0x18, 0xC4, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C, 0x0A, 0x43, 0xED, 0x70, 0x67, 0x84,
  0x09, 0x35, 0x80, 0xC0, 0x1C, 0x20, 0xA0, 0x12, 0x01, 0x08, 0x30,
  // "ŗ" (U+0157)
  0x28, 0x5A, 0x95, 0x01, 0xE1, 0x20, 0x40, 0x93, 0x07, 0x05, 0x30, 0x90, 0x23, 0x0C, 0x40, 0xA0,
  0x12, 0x01, 0x08, 0x30,
  // "Ř" (U+0158)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0xC4, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C,
  0x0A, 0x43, 0xED, 0x70, 0x67, 0x84, 0x09, 0x35, 0x80, 0xC0, 0x1C, 0x10,
  // "ř" (U+0159)
  0x18, 0x56, 0x49, 0x01, 0xE2, 0x58, 0x7A, 0x95, 0x1E, 0x10, 0x49, 0x20, 0x70, 0x52, 0x09, 0x02,
  0x20, 0xC3,
  // "Ś" (U+015A)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73, 0x81,
  0x1D, 0x43, 0x05, 0x08, 0x38, 0x47, 0x60, 0xCB, 0xA2,
  // "ś" (U+015B)
  0x20, 0x10, 0xC2, 0x08, 0x02, 0x48, 0x41, 0xBC, 0x45, 0x72, 0x81, 0x2C, 0x12, 0x05, 0x0A, 0x38,
  0x3D, 0x0C, 0xC5, 0x10,
  // "Ŝ" (U+015C)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x84, 0x5C, 0xC3, 0x0C, 0x30, 0x10, 0xC4, 0x0B, 0x07, 0x38,
  0x11, 0xD4, 0x30, 0x50, 0x83, 0x84, 0x76, 0x0C, 0xBA, 0x20,
  // "ŝ" (U+015D)
  0x28, 0x4D, 0x40, 0x73, 0x84, 0x84, 0x1B, 0xC4, 0x57, 0x28, 0x12, 0xC1, 0x20, 0x50, 0xA3, 0x83,
  0xD0, 0xCC, 0x51,
  // "Ş" (U+015E)
  0x18, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73, 0x81, 0x1D, 0x43, 0x05, 0x08, 0x38,
  0x47, 0x60, 0xCB, 0xA3, 0x05, 0x40, 0xB3, 0x07, 0x08, 0x30,
  // "ş" (U+015F)
  0x84, 0x1B, 0xC4, 0x57, 0x28, 0x12, 0xC1, 0x20, 0x50, 0xA3, 0x83, 0xD0, 0xCC, 0x52, 0x05, 0x30,
  0xB2, 0x07, 0x08, 0x20,
  // "Š" (U+0160)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73,
  0x81, 0x1D, 0x43, 0x05, 0x08, 0x38, 0x47, 0x60, 0xCB, 0xA2,
  // "š" (U+0161)
  0x18, 0x56, 0x49, 0x01, 0xE2, 0x48, 0x41, 0xBC, 0x45, 0x72, 0x81, 0x2C, 0x12, 0x05, 0x0A, 0x38,
  0x3D, 0x0C, 0xC5, 0x10,
  // "Ţ" (U+0162)
  0x83, 0x1B, 0xEB, 0x72, 0x0C, 0x40, 0xB3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC4, 0x05, 0x40, 0xB3, 0x07, 0x08, 0x30,
  // "ţ" (U+0163)
  0x18, 0xA4, 0x21, 0x09, 0x14, 0xEA, 0x0B, 0x03, 0x80, 0x65, 0x09, 0x20, 0x7C, 0x20, 0x52, 0x82,
  0xB0, 0x78, 0x10,
  // "Ť" (U+0164)
  0x18, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x31, 0xBE, 0xB7, 0x20, 0xC4, 0x0B, 0x30, 0x30, 0x93,
  0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30,
  // "ť" (U+0165)
  0x18, 0x90, 0x29, 0x40, 0x96, 0x04, 0xEA, 0x20, 0xB2, 0x03, 0x08, 0x20, 0x60, 0x52, 0x09, 0x02,
  0x20, 0x70, 0xC2,
  // "Ŧ" (U+0166)
  0x83, 0x1B, 0xEB, 0x72, 0x0C, 0x30, 0x10, 0xB2, 0x82, 0x3C, 0xD6, 0x20, 0x70, 0x53, 0x0A, 0x02,
  0x30, 0xC4, 0x0C, 0x30,
  // "ŧ" (U+0167)
  0x18, 0xA4, 0x21, 0x09, 0x14, 0xEA, 0x1B, 0x0A, 0xD5, 0x65, 0x09, 0x20, 0x7C, 0x10,
  // "Ũ" (U+0168)
  0x28, 0x25, 0xA6, 0x22, 0x81, 0x73, 0xB7, 0x18, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2,
  0x82, 0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C,
  0xC7, 0x20,
  // "ũ" (U+0169)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x2C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50,
  0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x71,
  // "Ū" (U+016A)
  0x28, 0x19, 0xB7, 0x71, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28, 0x2B, 0x11, 0xB2,
  0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC, 0x72,
  // "ū" (U+016B)
  0x28, 0x19, 0xB7, 0x68, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09, 0x36,
  0xA0, 0x6C, 0x97, 0x10,
  // "Ŭ" (U+016C)
  0x28, 0x15, 0x05, 0x38, 0x14, 0xC4, 0x71, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28,
  0x2B, 0x11, 0xB2, 0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC,
  0x72,
  // "ŭ" (U+016D)
  0x28, 0x15, 0x05, 0x28, 0x14, 0xC4, 0x68, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75,
  0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "Ů" (U+016E)
  0x28, 0x13, 0x81, 0x38, 0x17, 0x16, 0x38, 0x13, 0x81, 0x28, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08,
  0x30, 0xC2, 0x82, 0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B,
  0x20, 0x2C, 0xC7, 0x20,
  // "ů" (U+016F)
  0x28, 0x13, 0x81, 0x28, 0x17, 0x16, 0x28, 0xB6, 0x38, 0x10, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70,
  0xB0, 0x75, 0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "Ű" (U+0170)
  0x28, 0x21, 0xA6, 0x52, 0x81, 0x74, 0x87, 0x18, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2,
  0x82, 0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C,
  0xC7, 0x20,
  // "ű" (U+0171)
  0x28, 0x21, 0xA6, 0x52, 0x81, 0x74, 0x87, 0x18, 0x95, 0xC0, 0x66, 0x01, 0xB0, 0x93, 0x04, 0x70,
  0xB2, 0x82, 0x75, 0x0C, 0x28, 0x29, 0x36, 0xA2, 0x82, 0x6C, 0x97, 0x20,
  // "Ų" (U+0172)
  0x18, 0x93, 0x84, 0x05, 0x60, 0xB1, 0x08, 0x30, 0xC2, 0x82, 0xB1, 0x1B, 0x28, 0xA6, 0xC0, 0x48,
  0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x40, 0x54, 0x04, 0x05, 0x40, 0x30,
  0xA3,
  // "ų" (U+0173)
  0x18, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97,
  0x30, 0x53, 0x04, 0x05, 0x30, 0x30, 0xA2,
  // "Ŵ" (U+0174)
  0x40, 0xD0, 0x45, 0x81, 0x73, 0x87, 0x38, 0xD4, 0x1B, 0x02, 0xC0, 0x1B, 0x1B, 0x07, 0xC0, 0x66,
  0x1B, 0x0B, 0xA0, 0xB0, 0x1A, 0x37, 0xA2, 0xA0, 0x1A, 0x91, 0xA8, 0x40, 0x1A, 0xA0, 0xAB, 0x28,
  0x41, 0xE6, 0x0D, 0x82, 0x01, 0x92, 0x0E, 0x02, 0x20,
  // "ŵ" (U+0175)
  0x30, 0xD0, 0x44, 0x81, 0x73, 0x87, 0x28, 0xB7, 0x66, 0x2E, 0x09, 0x36, 0x57, 0xC0, 0xC0, 0x65,
  0xAA, 0x47, 0x06, 0x97, 0xAA, 0x10, 0x6D, 0x1A, 0xA2, 0x83, 0x6B, 0x0C, 0x52,
  // "Ŷ" (U+0176)
  0x18, 0x4D, 0x40, 0x73, 0x85, 0x8A, 0x0B, 0x03, 0xAC, 0x0B, 0x2C, 0x39, 0x0A, 0xC2, 0x08, 0x92,
  0x08, 0x04, 0x20, 0xB0, 0x12, 0x0C, 0x30,
  // "ŷ" (U+0177)
  0x30, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x90, 0x56, 0x0B, 0x10, 0x57, 0x2A, 0x28, 0x24, 0x78,
  0x42, 0x81, 0x38, 0xB3, 0x81, 0x2C, 0x73, 0x81, 0x1F, 0x13, 0x02, 0x0A, 0x40, 0x90, 0x33, 0x0A,
  0x09, 0x40,
  // "Ÿ" (U+0178)
  0x18, 0x16, 0x42, 0x48, 0xA0, 0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89, 0x20, 0x80,
  0x42, 0x0B, 0x01, 0x20, 0xC3,
  // "Ź" (U+0179)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x72, 0x82, 0x9B, 0xE6, 0x30, 0x10, 0xD4, 0x08, 0x06, 0x30, 0x20,
  0xC4, 0x0A, 0x04, 0x30, 0x30, 0xB4, 0x0B, 0x03, 0x38, 0x33, 0xEB, 0xB1, 0x10,
  // "ź" (U+017A)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x68, 0x21, 0xBD, 0x63, 0x0B, 0x30, 0x80, 0x52, 0x02, 0x0B, 0x30,
  0xA0, 0x32, 0x82, 0x2E, 0xB6, 0x10,
  // "Ż" (U+017B)
  0x30, 0x60, 0x17, 0x28, 0x29, 0xBE, 0x63, 0x01, 0x0D, 0x40, 0x80, 0x63, 0x02, 0x0C, 0x40, 0xA0,
  0x43, 0x03, 0x0B, 0x40, 0xB0, 0x33, 0x83, 0x3E, 0xBB, 0x11,
  // "ż" (U+017C)
  0x30, 0x60, 0x16, 0x82, 0x1B, 0xD6, 0x30, 0xB3, 0x08, 0x05, 0x20, 0x20, 0xB3, 0x0A, 0x03, 0x28,
  0x22, 0xEB, 0x61,
  // "Ž" (U+017D)
  0x28, 0x16, 0x49, 0x38, 0x11, 0xE2, 0x72, 0x82, 0x9B, 0xE6, 0x30, 0x10, 0xD4, 0x08, 0x06, 0x30,
  0x20, 0xC4, 0x0A, 0x04, 0x30, 0x30, 0xB4, 0x0B, 0x03, 0x38, 0x33, 0xEB, 0xB1, 0x10,
  // "ž" (U+017E)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x21, 0xBD, 0x63, 0x0B, 0x30, 0x80, 0x52, 0x02, 0x0B,
  0x30, 0xA0, 0x32, 0x82, 0x2E, 0xB6, 0x10,
  // "ſ" (U+017F)
  0x38, 0x12, 0xC6, 0x30, 0x80, 0x44, 0x0C, 0x50, 0xC4, 0x02, 0x09, 0x40, 0x50, 0x64, 0x08, 0x03,
  0x40, 0xB5, 0x0C, 0x40, 0x20, 0x93, 0x81, 0x3C, 0x23,
  // "Ω" (U+03A9)
  0x38, 0x1A, 0xBA, 0x38, 0x39, 0x50, 0x85, 0x20, 0xC2, 0x83, 0x67, 0x04, 0x82, 0x83, 0x75, 0x06,
  0x62, 0x86, 0xB2, 0x05, 0x60, 0x1C, 0x28, 0x92, 0x29, 0x09, 0x30, 0x2B, 0xD5, 0xEA, 0x10,
  // "μ" (U+03BC)
  0x28, 0x95, 0xC0, 0x56, 0x01, 0xB0, 0x83, 0x03, 0x80, 0xB2, 0x82, 0x65, 0x0C, 0x28, 0x29, 0x35,
  0xA2, 0x82, 0xBB, 0x97, 0x20, 0xB4, 0x02, 0x09, 0x40, 0x50, 0x64,
  // "π" (U+03C0)
  0x8B, 0x34, 0xEB, 0xEC, 0x0C, 0x0B, 0x01, 0xA0, 0xC0, 0x47, 0x1A, 0x07, 0x44, 0x70, 0xA1, 0x3C,
  0x10,
  // "–" (U+2013)
  0x83, 0x7B, 0xBB, 0x20,
  // "—" (U+2014)
  0x07, 0x80, 0x3B, 0x09,
  // "€" (U+20AC)
  0x28, 0x47, 0xCA, 0x03, 0xA3, 0x0A, 0x02, 0x28, 0x66, 0xEB, 0x60, 0xAE, 0xB2, 0x03, 0x09, 0x30,
  0x10, 0xB4, 0x81, 0x8C, 0x71,
  // "₿" (U+20BF)
  0x20, 0x07, 0x28, 0xD0, 0x7D, 0xD1, 0x0A, 0x27, 0x60, 0xC0, 0xA3, 0x0E, 0xD7, 0x03, 0x81, 0xC0,
  0x66, 0x0D, 0x09, 0x34, 0x90, 0xCC, 0xA1, 0x04, 0x72, 0x20,
  // "‘" (U+2018)
  0x18, 0x57, 0x21, 0xB0, 0x24, 0x10,
  // "’" (U+2019)
  0x18, 0x5A, 0x31, 0xA0, 0x22, 0x10,
  // "‚" (U+201A)
  0x18, 0x54, 0x20, 0xC0, 0x46, 0x10,
  // "‛" (U+201B)
  0x81, 0xCB, 0x80,
  // "“" (U+201C)
  0x18, 0x91, 0x73, 0xA0, 0xC4, 0x83, 0x78, 0x30,
  // "”" (U+201D)
  0x18, 0x90, 0xA3, 0xC0, 0xB5, 0x63, 0x48, 0x10,
  // "„" (U+201E)
  0x18, 0x90, 0xA3, 0x91, 0xB6, 0x56, 0x4A, 0x10,
  // "‟" (U+201F)
  0x87, 0xD6, 0x6B, 0x56, 0x82, 0x60,
  // "†" (U+2020)
  0x10, 0x60, 0x52, 0x87, 0x81, 0x0A, 0xCA, 0x20, 0x82, 0x02, 0x07, 0x20, 0x60, 0x42, 0x0A, 0x02,
  0x20, 0xD3,
  // "‡" (U+2021)
  0x20, 0x60, 0x53, 0x08, 0x01, 0x28, 0x29, 0xC9, 0x22, 0x0A, 0x30, 0x30, 0x72, 0x86, 0x6A, 0xA5,
  0x01, 0x91, 0x30, 0xC3,
  // "•" (U+2022)
  0x18, 0x2B, 0xA0, 0x3A, 0x82, 0x10, 0xDC, 0x10,
  // "…" (U+2026)
  0x84, 0x71, 0x71, 0x71,
  // "‰" (U+2030)
  0x18, 0x37, 0xC1, 0x18, 0x48, 0x41, 0x96, 0x38, 0x14, 0x83, 0x45, 0x83, 0x85, 0x8A, 0x26, 0x4A,
  0x95, 0xA1, 0x6A, 0x02, 0xC6, 0x89, 0x66, 0x88, 0x12, 0x85, 0x94, 0x67, 0x83, 0x92, 0x86, 0x37,
  0x54, 0xA8, 0x2A, 0x28, 0x6A, 0x02, 0xC5, 0x5C, 0x31,
  // "‹" (U+2039)
  0x18, 0x90, 0x23, 0x1B, 0x08, 0x50, 0x29, 0x20, 0x31,
  // "›" (U+203A)
  0x02, 0x03, 0x20, 0xB2, 0x84, 0xC1, 0x84, 0x02, 0x20,
  // "⁄" (U+2044)
  0x50, 0x60, 0x44, 0x01, 0x08, 0x50, 0x90, 0x14, 0x00, 0x54, 0x01, 0x09, 0x50, 0x90, 0x14, 0x00,
  0x54, 0x01, 0x09, 0x50,
  // "™" (U+2122)
  0x8B, 0x26, 0xA6, 0x80, 0x91, 0x08, 0x2C, 0x1C, 0x10, 0x82, 0x7A, 0x71, 0x06, 0x23, 0x74, 0x10,
  // "⅒" (U+2152)
  0x20, 0x52, 0x06, 0x04, 0x38, 0x36, 0xC0, 0x18, 0x58, 0x2A, 0x09, 0x14, 0x89, 0x71, 0x85, 0x55,
  0x4A, 0x30, 0x56, 0x96, 0xCA, 0x28, 0x28, 0xA0, 0x91, 0x0C, 0x83, 0x60, 0x55, 0x01, 0xB6, 0x82,
  0x19, 0x28, 0x25, 0x59, 0x61,
  // "ﬁ" (U+FB01)
  0x38, 0x32, 0xC7, 0x43, 0x30, 0x80, 0x45, 0x83, 0x3D, 0xA0, 0xC4, 0x82, 0xC0, 0x1B, 0x38, 0x32,
  0xA0, 0x48, 0x38, 0x35, 0x70, 0x75, 0x38, 0x38, 0x40, 0x92, 0x38, 0x2A, 0x10, 0xC4, 0x0C, 0x60,
  0x10, 0xA5, 0x81, 0x2C, 0x35,
  // "ﬂ" (U+FB02)
  0x38, 0x32, 0xC7, 0x66, 0x38, 0x38, 0x40, 0x93, 0x28, 0x33, 0xDA, 0x0C, 0x40, 0xC2, 0x0B, 0x38,
  0x32, 0xA0, 0x39, 0x38, 0x35, 0x70, 0x65, 0x38, 0x38, 0x40, 0x92, 0x38, 0x2A, 0x10, 0xC4, 0x0C,
  0x60, 0x10, 0xA5, 0x81, 0x2C, 0x35,
};

const Font& font_NotoSans_CondensedItalic_10() {
  static SmoothFont font(font_NotoSans_CondensedItalic_10_data);
  return font;
}

}  // namespace roo_display
