#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Thu Mar 30 22:28:38 CEST 2023
static const uint8_t font_NotoSans_CondensedBold_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x04, 0x4C,
  0xFD, 0xFD, 0x10, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x11, 0x04, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x07, 0x05, 0x0A, 0x07, 0x00, 0x15, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x00, 0x23, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0B, 0x08, 0x00, 0x49, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x00, 0x73, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x00, 0xB1, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x07, 0x02, 0x0A, 0x04, 0x00, 0xE2, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x00, 0xEA, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x01, 0x0B, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x06, 0x0B, 0x07, 0x01, 0x2C, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x09, 0x08, 0x01, 0x43, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x03, 0x02, 0x04, 0x01, 0x54, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x04, 0x05, 0x05, 0x01, 0x5E, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x03, 0x03, 0x04, 0x01, 0x64, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x01, 0x6C, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x01, 0x89, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x05, 0x0A, 0x08, 0x01, 0xAE, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x01, 0xCC, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x01, 0xEF, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x02, 0x15, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x02, 0x3A, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x02, 0x5B, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x02, 0x80, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x02, 0x9F, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x02, 0xC6, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x02, 0xEB, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x02, 0xFA, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x06, 0x09, 0x08, 0x03, 0x0B, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x06, 0x08, 0x08, 0x03, 0x24, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x06, 0x09, 0x08, 0x03, 0x2E, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x03, 0x49, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x0A, 0x0A, 0x0C, 0x03, 0x68, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x03, 0xA2, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x03, 0xCD, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xF2, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x08, 0x0A, 0x09, 0x04, 0x15, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x04, 0x43, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x04, 0x60, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x04, 0x7D, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x08, 0x0A, 0x0A, 0x04, 0xAC, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x04, 0xD8, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFE, 0x03, 0x0A, 0x04, 0x04, 0xF5, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x08, 0x0A, 0x08, 0x05, 0x1C, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x05, 0x48, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0B, 0x0A, 0x0C, 0x05, 0x66, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x09, 0x0A, 0x0A, 0x05, 0xA0, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x08, 0x0A, 0x0A, 0x05, 0xCF, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x06, 0x00, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x09, 0x0A, 0x0A, 0x06, 0x22, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x08, 0x0A, 0x08, 0x06, 0x60, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x8D, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0xB2, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x08, 0x0A, 0x09, 0x06, 0xD1, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x06, 0xFE, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x07, 0x2A, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x07, 0x6F, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x07, 0x9A, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0xC0, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x04, 0x0A, 0x05, 0x07, 0xE0, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x08, 0x05, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x03, 0x0A, 0x05, 0x08, 0x22, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x07, 0x0B, 0x08, 0x08, 0x3E, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x06, 0x00, 0x07, 0x08, 0x59, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0A, 0x04, 0x0C, 0x05, 0x08, 0x5E, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x08, 0x08, 0x08, 0x67, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x08, 0x85, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x08, 0x07, 0x08, 0xAF, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x08, 0xC9, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0xF6, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x09, 0x13, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x09, 0x36, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x09, 0x65, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x02, 0x0B, 0x04, 0x09, 0x8E, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x02, 0x0B, 0x04, 0x09, 0x9F, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x09, 0xBB, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x0B, 0x04, 0x09, 0xE5, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x09, 0xF6, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0A, 0x2A, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0A, 0x4C, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x0A, 0x70, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x0A, 0x99, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0A, 0xC7, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0A, 0xDB, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0A, 0xF6, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0B, 0x14, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0B, 0x38, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x0B, 0x56, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0B, 0x86, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x0B, 0xA5, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0B, 0xCC, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x0B, 0xE5, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x04, 0x0B, 0x07, 0x0C, 0x0B, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x0C, 0x22, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x05, 0x06, 0x07, 0x08, 0x0C, 0x4B, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x0C, 0x58, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x06, 0x0A, 0x08, 0x0C, 0x6E, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x0C, 0x8C, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x07, 0x09, 0x08, 0x0C, 0xAC, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0C, 0xCF, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x04, 0x0B, 0x07, 0x0C, 0xF5, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0D, 0x0A, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x0A, 0x06, 0x0B, 0x08, 0x0D, 0x2E, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0B, 0x0B, 0x0C, 0x0D, 0x36, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x06, 0x04, 0x0A, 0x05, 0x0D, 0x76, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0D, 0x84, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x06, 0x06, 0x08, 0x0D, 0xA4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x0B, 0x0B, 0x0C, 0x0D, 0xB1, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0C, 0x07, 0x0D, 0x07, 0x0D, 0xF3, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x07, 0x05, 0x0A, 0x06, 0x0D, 0xF8, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x09, 0x08, 0x0E, 0x06, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x06, 0x04, 0x0C, 0x05, 0x0E, 0x1B, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x06, 0x04, 0x0C, 0x05, 0x0E, 0x2F, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0A, 0x03, 0x0C, 0x05, 0x0E, 0x43, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x0E, 0x4A, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x07, 0x0B, 0x08, 0x0E, 0x72, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x05, 0x03, 0x07, 0x04, 0x0E, 0xA8, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFD, 0x02, 0x01, 0x03, 0x0E, 0xB0, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x07, 0x03, 0x0C, 0x05, 0x0E, 0xBC, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x04, 0x0A, 0x05, 0x0E, 0xCB, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0E, 0xD9, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x0B, 0x0A, 0x0C, 0x0E, 0xFB, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x0F, 0x3C, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x0B, 0x0A, 0x0C, 0x0F, 0x79, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x0F, 0xBA, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x0F, 0xD9, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x10, 0x0D, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x10, 0x40, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x10, 0x76, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x10, 0xAD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x10, 0xE1, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0A, 0x0A, 0x0C, 0x11, 0x17, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x11, 0x48, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x11, 0x76, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x11, 0x9C, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x11, 0xC2, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x11, 0xEA, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x12, 0x0F, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x12, 0x37, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x12, 0x5B, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x0D, 0x05, 0x12, 0x85, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x12, 0xAC, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x12, 0xDE, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x13, 0x1A, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x13, 0x54, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x13, 0x8D, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x13, 0xC9, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x14, 0x06, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x03, 0x06, 0x09, 0x08, 0x14, 0x40, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x14, 0x5B, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x14, 0x91, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x14, 0xC8, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x14, 0xFE, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x08, 0x0D, 0x09, 0x15, 0x37, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x15, 0x6E, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x15, 0x9D, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x15, 0xBF, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x15, 0xF3, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0x1A, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0x40, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x16, 0x69, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x16, 0x92, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0xB9, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x16, 0xE2, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x08, 0x07, 0x17, 0x0F, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x33, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x5A, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x80, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0xA9, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x17, 0xCF, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x17, 0xE8, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x04, 0x0C, 0x04, 0x17, 0xFF, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x18, 0x1A, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x18, 0x32, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x18, 0x62, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x18, 0x91, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x18, 0xBF, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x18, 0xEC, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x19, 0x1C, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x19, 0x4D, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x06, 0x08, 0x08, 0x19, 0x7A, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x07, 0x09, 0x08, 0x19, 0x8B, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x19, 0xB4, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x19, 0xE2, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1A, 0x0F, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x1A, 0x3F, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x06, 0x0C, 0x07, 0x1A, 0x6D, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x07, 0x0B, 0x08, 0x1A, 0x9D, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x06, 0x0B, 0x07, 0x1A, 0xCC, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1A, 0xFC, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x1B, 0x2E, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x1B, 0x52, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x1B, 0x8B, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x1B, 0xB5, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x06, 0x08, 0x08, 0x1B, 0xE9, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1C, 0x11, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x1C, 0x3D, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1C, 0x5F, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1C, 0x8E, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1C, 0xB5, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1C, 0xDF, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1C, 0xFF, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1D, 0x2E, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x1D, 0x56, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0A, 0x0B, 0x08, 0x1D, 0x90, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x1D, 0xC8, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x08, 0x0B, 0x08, 0x1D, 0xFA, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x1E, 0x2D, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1E, 0x50, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x1E, 0x73, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1E, 0x9C, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x1E, 0xC6, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1E, 0xEA, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFE, 0x06, 0x0A, 0x07, 0x1F, 0x0E, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x1F, 0x35, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x1F, 0x5B, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1F, 0x83, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x1F, 0xAC, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x07, 0x0C, 0x08, 0x1F, 0xE7, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x20, 0x22, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x07, 0x0C, 0x08, 0x20, 0x5F, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x20, 0x9C, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x07, 0x0B, 0x08, 0x20, 0xD2, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x21, 0x08, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x07, 0x0B, 0x08, 0x21, 0x40, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x21, 0x77, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x07, 0x0F, 0x08, 0x21, 0xB0, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x21, 0xE9, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x22, 0x1E, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x22, 0x48, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x22, 0x72, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x22, 0x8D, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x03, 0x0B, 0x04, 0x22, 0xAF, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x05, 0x0F, 0x05, 0x22, 0xC4, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x04, 0x0C, 0x04, 0x22, 0xEF, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x04, 0x0A, 0x05, 0x23, 0x0B, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x03, 0x0B, 0x04, 0x23, 0x30, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x23, 0x4D, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x02, 0x08, 0x04, 0x23, 0x71, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x23, 0x7D, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x23, 0xB9, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x04, 0x0F, 0x04, 0x23, 0xE7, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x04, 0x0C, 0x04, 0x24, 0x1A, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFE, 0x08, 0x0A, 0x08, 0x24, 0x3F, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x07, 0x0B, 0x08, 0x24, 0x74, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x07, 0x08, 0x08, 0x24, 0xA7, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x24, 0xCB, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0F, 0x04, 0x24, 0xF3, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x06, 0x0A, 0x07, 0x25, 0x10, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x03, 0x0B, 0x04, 0x25, 0x37, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x07, 0x0A, 0x07, 0x25, 0x54, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x05, 0x0B, 0x04, 0x25, 0x75, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x25, 0x90, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x25, 0xAF, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x25, 0xC8, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x25, 0xE9, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x26, 0x0B, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x26, 0x44, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFE, 0x09, 0x0A, 0x0A, 0x26, 0x6F, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x26, 0xA7, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x26, 0xD2, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x27, 0x0E, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x27, 0x3D, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFE, 0x09, 0x0A, 0x0A, 0x27, 0x6C, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x27, 0xA5, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x27, 0xD2, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x28, 0x0A, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x28, 0x34, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x28, 0x73, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x28, 0xA5, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x28, 0xE3, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x29, 0x14, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x29, 0x4C, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x08, 0x0F, 0x08, 0x29, 0x80, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x29, 0xB6, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFE, 0x08, 0x0A, 0x08, 0x29, 0xD3, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x2A, 0x09, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x08, 0x0F, 0x08, 0x2A, 0x26, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2A, 0x5F, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2A, 0x7E, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2A, 0xAC, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2A, 0xCF, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2B, 0x00, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x2B, 0x25, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x05, 0x08, 0x06, 0x2B, 0x55, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2B, 0x7A, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2B, 0xAC, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x2B, 0xD1, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x04, 0x0A, 0x05, 0x2B, 0xFB, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2C, 0x23, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x07, 0x0B, 0x05, 0x2C, 0x4F, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2C, 0x75, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x2C, 0x94, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x2C, 0xB1, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x2C, 0xEC, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x2D, 0x1D, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x2D, 0x51, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x2D, 0x7C, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2D, 0xB8, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x2D, 0xEA, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2E, 0x24, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x2E, 0x54, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2E, 0x8F, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFE, 0x08, 0x0A, 0x09, 0x2E, 0xC0, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x2E, 0xF5, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0C, 0x0F, 0x0D, 0x2F, 0x23, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x2F, 0x77, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x2F, 0xB3, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x06, 0x0C, 0x07, 0x2F, 0xE5, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x30, 0x18, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x30, 0x48, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x30, 0x72, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x30, 0x94, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x30, 0xBC, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x30, 0xDB, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x31, 0x08, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x04, 0x0B, 0x05, 0x31, 0x2B, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x31, 0x43, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x31, 0x78, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x08, 0x08, 0x09, 0x31, 0xA0, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x05, 0x08, 0x31, 0xC6, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0E, 0x05, 0x0F, 0x31, 0xCB, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x31, 0xD3, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x06, 0x0C, 0x08, 0x31, 0xFA, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x07, 0x02, 0x0A, 0x04, 0x32, 0x28, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x07, 0x02, 0x0A, 0x04, 0x32, 0x30, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFE, 0x02, 0x01, 0x04, 0x32, 0x37, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x07, 0x02, 0x0A, 0x04, 0x32, 0x3E, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x07, 0x06, 0x0A, 0x07, 0x32, 0x46, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x07, 0x06, 0x0A, 0x07, 0x32, 0x56, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFE, 0x06, 0x01, 0x07, 0x32, 0x65, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x07, 0x06, 0x0A, 0x07, 0x32, 0x74, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x32, 0x85, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x32, 0xA7, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x04, 0x08, 0x06, 0x32, 0xCD, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x0B, 0x03, 0x0C, 0x32, 0xDA, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x10, 0x0A, 0x11, 0x32, 0xEE, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x04, 0x08, 0x05, 0x33, 0x3F, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x33, 0x52, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x04, 0x0A, 0x02, 0x33, 0x67, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x06, 0x09, 0x0B, 0x0B, 0x33, 0x84, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x00, 0x0F, 0x0A, 0x11, 0x33, 0xA3, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x33, 0xF0, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x34, 0x20, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x02, 0xA0, 0x20, 0x1A, 0x00, 0x1A, 0x2A, 0x29, 0x0E, 0x20, 0xE0, 0xD2, 0x00, 0xD2, 0x89, 0x01,
  0x10, 0x1F, 0xE1, 0x1D, 0xD1,
  // """ (U+0022)
  0x8A, 0x62, 0xFD, 0x1F, 0xE1, 0xFC, 0x0F, 0xD0, 0xFA, 0x0E, 0xC0, 0xF9, 0x0D, 0xB0,
  // "#" (U+0023)
  0x28, 0x23, 0xF4, 0x79, 0x38, 0x35, 0xF1, 0xAC, 0x28, 0x61, 0x8F, 0x1C, 0xA1, 0x4F, 0x89, 0x71,
  0x4E, 0xB6, 0xF7, 0x46, 0x9F, 0xCB, 0xFA, 0x6A, 0xE8, 0x59, 0x05, 0xF1, 0xAC, 0x38, 0x38, 0xE0,
  0xCA, 0x38, 0x3A, 0xC0, 0xF7, 0x20,
  // "$" (U+0024)
  0x30, 0xA0, 0x43, 0x8A, 0x03, 0xAE, 0xDA, 0x31, 0xEF, 0xED, 0xE6, 0x4F, 0x8A, 0x42, 0x83, 0x2F,
  0xCC, 0x43, 0x07, 0xA0, 0xC0, 0x43, 0x02, 0x0D, 0xA0, 0x63, 0x89, 0x2A, 0x6F, 0xD3, 0x62, 0xB7,
  0xFC, 0x4D, 0x85, 0x40, 0x58, 0xD9, 0x24, 0x0A, 0x04, 0x20,
  // "%" (U+0025)
  0x18, 0x29, 0xEC, 0x22, 0x09, 0x0E, 0x38, 0x74, 0xFC, 0xFA, 0x01, 0xF7, 0x38, 0x77, 0xF1, 0xBE,
  0x08, 0xE1, 0x38, 0x67, 0xF1, 0xBE, 0x1E, 0x84, 0x89, 0x14, 0xFC, 0xFA, 0x7F, 0x3C, 0xFB, 0x28,
  0x91, 0x8E, 0xC3, 0xE9, 0x9F, 0x6F, 0x64, 0x86, 0x6F, 0x2B, 0xC0, 0xEA, 0x48, 0x6D, 0xA0, 0xBD,
  0x0F, 0x93, 0x87, 0x5F, 0x30, 0x8F, 0xBF, 0x63, 0x0C, 0x0B, 0x28, 0x21, 0xBE, 0xA1,
  // "&" (U+0026)
  0x28, 0x29, 0xEE, 0x95, 0x84, 0x7F, 0xDD, 0xF6, 0x48, 0x49, 0xF4, 0x5F, 0x84, 0x84, 0x7F, 0x9B,
  0xF4, 0x40, 0x10, 0xEA, 0x08, 0x58, 0xA6, 0xAF, 0xCF, 0x43, 0xFD, 0x05, 0xFA, 0x1D, 0xFB, 0xF8,
  0x07, 0xF9, 0x02, 0xA0, 0xD2, 0x04, 0xA0, 0xA0, 0xCA, 0x0E, 0x03, 0x28, 0x76, 0xDF, 0xD9, 0x8F,
  0xE2,
  // "'" (U+0027)
  0x89, 0x22, 0xFD, 0x1F, 0xC0, 0xFA, 0x0F, 0x90,
  // "(" (U+0028)
  0x28, 0x59, 0xF3, 0x03, 0xF9, 0x28, 0x1A, 0xF3, 0x29, 0x0D, 0x28, 0x13, 0xFA, 0x28, 0x14, 0xF9,
  0x28, 0x14, 0xF9, 0x28, 0x13, 0xFA, 0x39, 0x0D, 0x38, 0x1B, 0xF3, 0x28, 0x13, 0xF9, 0x38, 0x19,
  0xF3,
  // ")" (U+0029)
  0x81, 0x6F, 0x63, 0x81, 0xCE, 0x12, 0x81, 0x6F, 0x72, 0x81, 0x1F, 0xC3, 0x0D, 0x93, 0x81, 0xCF,
  0x12, 0x81, 0xCF, 0x12, 0x0D, 0x92, 0x81, 0x1F, 0xC2, 0x81, 0x6F, 0x82, 0x85, 0xCE, 0x10, 0x6F,
  0x62,
  // "*" (U+002A)
  0x28, 0x14, 0xF6, 0x28, 0xB1, 0x23, 0x3F, 0x43, 0x27, 0xFE, 0xFE, 0xF9, 0x24, 0xDF, 0xE5, 0x20,
  0x7F, 0x9F, 0x92, 0x83, 0x6C, 0x0A, 0x71,
  // "+" (U+002B)
  0x39, 0x09, 0x59, 0x09, 0x59, 0x09, 0x20, 0x7E, 0x85, 0x49, 0x9F, 0xD9, 0x93, 0x90, 0x95, 0x90,
  0x92,
  // "," (U+002C)
  0x18, 0x94, 0xEF, 0x11, 0xFD, 0x03, 0xF9, 0x06, 0xF3, 0x10,
  // "-" (U+002D)
  0x84, 0x59, 0x99, 0x28, 0xB0, 0x30,
  // "." (U+002E)
  0x18, 0x90, 0x11, 0x01, 0xFE, 0x11, 0xDD, 0x10,
  // "/" (U+002F)
  0x40, 0xE0, 0xC3, 0x81, 0x6F, 0x63, 0x0C, 0x0E, 0x38, 0x13, 0xF9, 0x38, 0x1A, 0xF2, 0x28, 0x11,
  0xFB, 0x38, 0x17, 0xF5, 0x30, 0xD0, 0xE3, 0x81, 0x4F, 0x83, 0x81, 0xAF, 0x23,
  // "0" (U+0030)
  0x18, 0x32, 0xBF, 0xD6, 0x28, 0xF3, 0xCF, 0xBE, 0xF3, 0x2F, 0xD0, 0x6F, 0x95, 0xFB, 0x03, 0xFC,
  0x6F, 0xA0, 0x2F, 0xE6, 0xFA, 0x02, 0xFE, 0x5F, 0xB0, 0x3F, 0xC2, 0xFD, 0x06, 0xFA, 0x0C, 0xFB,
  0xEF, 0x40, 0x1B, 0xFD, 0x61,
  // "1" (U+0031)
  0x28, 0x3A, 0xF9, 0x1B, 0xA8, 0x91, 0x9C, 0xFC, 0xF9, 0x76, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81,
  0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x90,
  // "2" (U+0032)
  0x18, 0x90, 0x7D, 0xFD, 0x60, 0x4F, 0xDA, 0xA8, 0x14, 0x05, 0x28, 0x18, 0xF8, 0x48, 0x19, 0xF7,
  0x30, 0x1A, 0x02, 0x38, 0x1B, 0xF7, 0x38, 0x19, 0xFA, 0x38, 0x17, 0xFB, 0x30, 0x4A, 0x83, 0xA9,
  0x97, 0x8D, 0x0C,
  // "3" (U+0033)
  0x89, 0x61, 0x8D, 0xED, 0x70, 0x2E, 0xCA, 0xEF, 0x50, 0x12, 0x81, 0x7F, 0x83, 0x84, 0x2C, 0xF4,
  0x01, 0xA0, 0xE0, 0x52, 0x84, 0x19, 0xBF, 0xE3, 0x48, 0x17, 0xFB, 0x48, 0x57, 0xFB, 0x7D, 0xAB,
  0xA8, 0x56, 0x4C, 0xEE, 0xC6, 0x10,
  // "4" (U+0034)
  0x30, 0x2A, 0x02, 0x40, 0xBA, 0x02, 0x38, 0x35, 0xEE, 0xF2, 0x38, 0x3E, 0x8D, 0xF2, 0x28, 0xA1,
  0x8E, 0x1E, 0xF2, 0x02, 0xF7, 0x0E, 0xF2, 0x0A, 0xFA, 0x9A, 0x81, 0xA2, 0xBE, 0x04, 0x48, 0x1D,
  0xF2, 0x58, 0x1D, 0xF2, 0x10,
  // "5" (U+0035)
  0x10, 0xCC, 0x89, 0x13, 0x0D, 0xF9, 0x99, 0x20, 0xEE, 0x59, 0x84, 0xE8, 0x82, 0x01, 0xD8, 0x63,
  0x02, 0x11, 0xAF, 0xA4, 0x81, 0x5F, 0xC4, 0x85, 0x8F, 0xA4, 0xEA, 0xBA, 0x85, 0x42, 0xBE, 0xEC,
  0x51,
  // "6" (U+0036)
  0x28, 0x96, 0x5C, 0xEF, 0x50, 0x5F, 0xEB, 0xA4, 0x0E, 0xE1, 0x38, 0x63, 0xFA, 0xBE, 0xA1, 0x5A,
  0x8C, 0x4B, 0xDF, 0x96, 0xFC, 0x03, 0xFD, 0x5F, 0xA0, 0x1F, 0xE3, 0xFD, 0x03, 0xFC, 0x0B, 0xFB,
  0xDF, 0x60, 0x1A, 0xED, 0x71,
  // "7" (U+0037)
  0x08, 0xE8, 0x55, 0x99, 0x9B, 0xFD, 0x48, 0x18, 0xF7, 0x48, 0x1E, 0xF1, 0x38, 0x15, 0xFB, 0x48,
  0x1B, 0xF5, 0x38, 0x12, 0xFE, 0x48, 0x19, 0xF8, 0x48, 0x1E, 0xF2, 0x38, 0x16, 0xFC, 0x30,
  // "8" (U+0038)
  0x18, 0xB4, 0x4C, 0xED, 0x80, 0x1E, 0xFA, 0xDF, 0x73, 0xFC, 0x04, 0xFA, 0x0D, 0xF4, 0xAF, 0x60,
  0x3E, 0xA0, 0x82, 0x89, 0x69, 0xFC, 0xFD, 0x25, 0xFA, 0x04, 0xFC, 0x7F, 0x82, 0x90, 0xE0, 0x3A,
  0x89, 0x1A, 0xCF, 0xA0, 0x5C, 0xEE, 0x91,
  // "9" (U+0039)
  0x18, 0xB2, 0x3C, 0xED, 0x50, 0x1E, 0xFA, 0xEF, 0x36, 0xFA, 0x05, 0xFA, 0x6F, 0x90, 0x4F, 0xD3,
  0xA8, 0x91, 0xAD, 0xFE, 0x07, 0xEE, 0x6F, 0xC4, 0x81, 0x4F, 0xA4, 0x87, 0xBF, 0x50, 0xAA, 0xDF,
  0xC2, 0x82, 0xDF, 0xD8, 0x20,
  // ":" (U+003A)
  0x89, 0x11, 0xDD, 0x11, 0xEE, 0x10, 0x11, 0x73, 0x89, 0x01, 0x10, 0x1E, 0xE1, 0x1D, 0xD1,
  // ";" (U+003B)
  0x89, 0x11, 0xDD, 0x11, 0xEE, 0x10, 0x11, 0x77, 0x89, 0x4E, 0xF1, 0x1F, 0xD0, 0x3F, 0x90, 0x6F,
  0x31,
  // "<" (U+003C)
  0x50, 0x50, 0xC3, 0x89, 0x25, 0xCF, 0xD0, 0x5D, 0xFD, 0x50, 0x7A, 0x05, 0x38, 0x42, 0xAF, 0xE9,
  0x23, 0x02, 0x09, 0xA0, 0xA4, 0x81, 0x19, 0xE6, 0x01,
  // "=" (U+003D)
  0x04, 0x80, 0x29, 0x07, 0xE7, 0x04, 0x80, 0x29, 0x07, 0xE0,
  // ">" (U+003E)
  0x81, 0x69, 0x14, 0x05, 0xA0, 0x90, 0x13, 0x02, 0x09, 0xA0, 0x90, 0x23, 0x01, 0x0B, 0xA2, 0x89,
  0x05, 0xCF, 0xD6, 0x4D, 0xFD, 0x62, 0x81, 0x7C, 0x54, 0x01, 0x60,
  // "?" (U+003F)
  0x89, 0x35, 0xBE, 0xE9, 0x09, 0xDA, 0xDF, 0x81, 0x28, 0x14, 0xFA, 0x38, 0x1A, 0xF7, 0x28, 0x19,
  0xFB, 0x28, 0x12, 0xFB, 0x38, 0x13, 0xB4, 0x40, 0x14, 0x81, 0x7F, 0xA3, 0x81, 0x5E, 0x82,
  // "@" (U+0040)
  0x38, 0x45, 0xBE, 0xEC, 0x64, 0x86, 0x9D, 0x51, 0x04, 0xDB, 0x28, 0x98, 0x27, 0xE2, 0x7D, 0xFD,
  0x4E, 0x70, 0xE8, 0x5F, 0x55, 0xF3, 0xAC, 0x3F, 0x4A, 0xD0, 0x6F, 0x27, 0xE4, 0xF2, 0xBC, 0x07,
  0xF1, 0x8D, 0x4F, 0x38, 0xE1, 0xBF, 0x3C, 0x92, 0xF5, 0x1B, 0xE9, 0x8E, 0xB1, 0x0C, 0xD7, 0x28,
  0x62, 0xEB, 0x30, 0x14, 0x74, 0x85, 0x19, 0xDF, 0xED, 0x72,
  // "A" (U+0041)
  0x20, 0x3A, 0x0C, 0x58, 0x37, 0xFE, 0xF1, 0x48, 0x3C, 0xF9, 0xF5, 0x38, 0x41, 0xFD, 0x4F, 0xA3,
  0x84, 0x5F, 0xA0, 0xFE, 0x38, 0x5A, 0xF6, 0x0B, 0xF4, 0x20, 0xED, 0x89, 0x49, 0x04, 0xFE, 0xBB,
  0xCF, 0xD0, 0x8F, 0xA3, 0xA8, 0x22, 0xDF, 0x63, 0x81, 0xCF, 0x70,
  // "B" (U+0042)
  0x0E, 0xA8, 0x6E, 0xD7, 0x0E, 0xFA, 0xAA, 0x89, 0x66, 0xEF, 0x20, 0x8F, 0x9E, 0xF2, 0x0B, 0xF7,
  0xEC, 0x8B, 0x5A, 0x0E, 0xFA, 0xAE, 0xF5, 0xEF, 0x20, 0x6F, 0xCE, 0xF2, 0x06, 0xFC, 0xEF, 0xAA,
  0xEF, 0x7E, 0xB0, 0xD0, 0x71,
  // "C" (U+0043)
  0x28, 0x63, 0xBE, 0xEB, 0x30, 0x3A, 0x86, 0xBB, 0xE2, 0x0C, 0xF8, 0x40, 0x1A, 0x01, 0x40, 0x3A,
  0x58, 0x13, 0xFE, 0x50, 0x2A, 0x01, 0x58, 0x1D, 0xF8, 0x50, 0x5A, 0x82, 0xBA, 0xD2, 0x28, 0x45,
  0xCF, 0xEB, 0x10,
  // "D" (U+0044)
  0x0E, 0xA8, 0x1E, 0xC5, 0x28, 0x2E, 0xFA, 0xBA, 0x85, 0x70, 0xEF, 0x20, 0x5A, 0x82, 0x1E, 0xF2,
  0x28, 0x4D, 0xF5, 0xEF, 0x22, 0x84, 0xBF, 0x7E, 0xF2, 0x28, 0x4B, 0xF6, 0xEF, 0x22, 0x89, 0x5D,
  0xF4, 0xEF, 0x20, 0x6F, 0xE0, 0xEF, 0xAB, 0xA8, 0x15, 0x0E, 0xA8, 0x1E, 0xB4, 0x20,
  // "E" (U+0045)
  0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF,
  0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "F" (U+0046)
  0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x5E, 0xFA, 0x99, 0x0E,
  0xC8, 0x21, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23,
  // "G" (U+0047)
  0x28, 0x95, 0x29, 0xDF, 0xDA, 0x10, 0x2E, 0xFD, 0xAB, 0xD2, 0x81, 0xBF, 0xA5, 0x01, 0xA0, 0x25,
  0x83, 0x3F, 0xE0, 0x3B, 0x89, 0x16, 0x3F, 0xE0, 0x29, 0xDF, 0x61, 0xA0, 0x12, 0x85, 0xAF, 0x60,
  0xDF, 0x82, 0x83, 0xAF, 0x60, 0x4A, 0x83, 0xCA, 0xEF, 0x62, 0x85, 0x4B, 0xEF, 0xDA, 0x30,
  // "H" (U+0048)
  0x81, 0xEF, 0x22, 0x84, 0xAF, 0x6E, 0xF2, 0x28, 0x4A, 0xF6, 0xEF, 0x22, 0x84, 0xAF, 0x6E, 0xF2,
  0x28, 0x2A, 0xF6, 0xEE, 0x89, 0x26, 0xEF, 0xA9, 0x9D, 0xF6, 0xEF, 0x22, 0x84, 0xAF, 0x6E, 0xF2,
  0x28, 0x4A, 0xF6, 0xEF, 0x22, 0x84, 0xAF, 0x6E, 0xF2, 0x28, 0x1A, 0xF6,
  // "I" (U+0049)
  0x08, 0xB8, 0x90, 0xB2, 0xBF, 0xC3, 0x07, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17,
  0xF9, 0x28, 0x17, 0xF9, 0x28, 0x90, 0x7F, 0x90, 0x1A, 0xFC, 0x28, 0xB0, 0xB0,
  // "J" (U+004A)
  0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28,
  0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x3E, 0xF2, 0x01, 0xA8,
  0x90, 0x1B, 0xDF, 0xC0, 0xDF, 0xC2, 0x10,
  // "K" (U+004B)
  0x8A, 0x4E, 0xF2, 0x03, 0xFE, 0x1E, 0xF2, 0x0D, 0xF6, 0x0E, 0xF2, 0x8F, 0xB2, 0x84, 0xEF, 0x6F,
  0xE1, 0x28, 0x3E, 0xFE, 0xF9, 0x30, 0xEB, 0x0E, 0x01, 0x28, 0x4E, 0xF5, 0xBF, 0x82, 0x82, 0xEF,
  0x23, 0xA8, 0x95, 0x10, 0xEF, 0x20, 0xBF, 0x90, 0xEF, 0x20, 0x3A, 0x02,
  // "L" (U+004C)
  0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81,
  0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF, 0xCB, 0xB5, 0xEC, 0x07,
  // "M" (U+004D)
  0x0E, 0xA0, 0x23, 0x0C, 0xA0, 0x40, 0xEA, 0x06, 0x20, 0x1B, 0x83, 0x4E, 0xEF, 0xB2, 0x8E, 0x36,
  0xFE, 0xF4, 0xEE, 0xBF, 0x10, 0xAE, 0xBF, 0x4E, 0xF6, 0xF5, 0x0F, 0xAB, 0xF4, 0xEF, 0x2F, 0xA5,
  0xF5, 0xBF, 0x4E, 0xF0, 0xCE, 0xAF, 0x1B, 0xF4, 0xEF, 0x08, 0xA8, 0x7B, 0x0B, 0xF4, 0xEF, 0x03,
  0xA8, 0x46, 0x0B, 0xF4, 0xE9, 0x28, 0x5E, 0xF1, 0x0B, 0xF4,
  // "N" (U+004E)
  0x81, 0xEF, 0xD3, 0x82, 0xDF, 0x1E, 0xA0, 0x52, 0x82, 0xDF, 0x1E, 0xA0, 0xD2, 0x8C, 0x6D, 0xF1,
  0xEE, 0xBF, 0x60, 0xDF, 0x1E, 0xF3, 0xFD, 0x0D, 0xF1, 0xEF, 0x0B, 0xF6, 0xCF, 0x1E, 0xF0, 0x3F,
  0xDC, 0xF1, 0xE9, 0x20, 0xAB, 0x01, 0x0E, 0x92, 0x03, 0xB0, 0x10, 0xE9, 0x30, 0xAA, 0x01,
  // "O" (U+004F)
  0x28, 0x45, 0xCE, 0xEB, 0x32, 0x05, 0xA8, 0x7B, 0xCF, 0xE2, 0x0D, 0xF7, 0x28, 0x2A, 0xFA, 0x2A,
  0x01, 0x28, 0x44, 0xFE, 0x3F, 0xE3, 0x02, 0xA8, 0x13, 0xFE, 0x30, 0x2A, 0x01, 0xA0, 0x12, 0x85,
  0x4F, 0xE0, 0xDF, 0x72, 0x83, 0xAF, 0xA0, 0x4A, 0x83, 0xBC, 0xFE, 0x22, 0x84, 0x4C, 0xEE, 0xB3,
  0x10,
  // "P" (U+0050)
  0x0E, 0xA8, 0xB7, 0xEB, 0x30, 0xEF, 0xAC, 0xFE, 0x1E, 0xF2, 0x0C, 0xF5, 0xEF, 0x20, 0xAF, 0x6E,
  0xF3, 0x3E, 0xF3, 0xEC, 0x85, 0xA0, 0xEF, 0xA8, 0x52, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81,
  0xEF, 0x24,
  // "Q" (U+0051)
  0x28, 0x45, 0xCE, 0xEB, 0x33, 0x05, 0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x1D, 0xF7, 0x28, 0x3A, 0xFA,
  0x02, 0xA0, 0x12, 0x85, 0x4F, 0xE0, 0x3F, 0xE3, 0x02, 0xA8, 0x21, 0x3F, 0xE3, 0x02, 0xA1, 0x01,
  0xA0, 0x12, 0x81, 0x4F, 0xE2, 0x81, 0xDF, 0x72, 0x81, 0xAF, 0xA2, 0x04, 0xA0, 0xB0, 0xCA, 0x02,
  0x38, 0x14, 0xCE, 0xA0, 0x37, 0x81, 0xBF, 0x97, 0x02, 0xA0, 0x47, 0x81, 0x57, 0x61,
  // "R" (U+0052)
  0x0E, 0xA8, 0x1E, 0xB4, 0x28, 0x2E, 0xFA, 0xBA, 0x8B, 0x12, 0x0E, 0xF2, 0x0B, 0xF6, 0x0E, 0xF2,
  0x0C, 0xF6, 0x0E, 0xFA, 0xCF, 0xD1, 0x0E, 0xB0, 0xE0, 0x12, 0x84, 0xEF, 0x2B, 0xF5, 0x28, 0x4E,
  0xF2, 0x4F, 0xD2, 0x89, 0x6E, 0xF2, 0x0B, 0xF7, 0x0E, 0xF2, 0x04, 0xFE, 0x10,
  // "S" (U+0053)
  0x18, 0x96, 0x3B, 0xEE, 0xB3, 0x1E, 0xFB, 0xBF, 0x34, 0xFC, 0x28, 0x11, 0x04, 0xA0, 0x44, 0x0B,
  0xA0, 0xB0, 0x23, 0x83, 0x7E, 0xFE, 0x13, 0x83, 0x1D, 0xF7, 0x13, 0x85, 0x9F, 0x87, 0xEB, 0xAA,
  0x85, 0x23, 0xCE, 0xFC, 0x41,
  // "T" (U+0054)
  0x0B, 0xD8, 0x6D, 0x79, 0xCF, 0xD9, 0x82, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94,
  0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x92,
  // "U" (U+0055)
  0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D,
  0xF6, 0x01, 0xA0, 0x20, 0x7A, 0x82, 0xCE, 0xFB, 0x28, 0x47, 0xDE, 0xD9, 0x11,
  // "V" (U+0056)
  0x81, 0xDF, 0x43, 0x84, 0xEF, 0x28, 0xF8, 0x28, 0x54, 0xFD, 0x04, 0xFD, 0x28, 0x18, 0xF8, 0x28,
  0x5E, 0xF1, 0x0C, 0xF4, 0x28, 0x4A, 0xF5, 0x1F, 0xE3, 0x84, 0x6F, 0x95, 0xFA, 0x38, 0x41, 0xFD,
  0x8F, 0x64, 0x83, 0xCF, 0xCF, 0x14, 0x07, 0xA0, 0xC5, 0x03, 0xA0, 0x73,
  // "W" (U+0057)
  0x81, 0xDF, 0x22, 0x81, 0xCF, 0x42, 0x84, 0xBF, 0x59, 0xF6, 0x2A, 0x07, 0x28, 0x6E, 0xF1, 0x6F,
  0x90, 0x4A, 0x8A, 0x0B, 0x02, 0xFD, 0x02, 0xFC, 0x07, 0xFC, 0xE0, 0x6F, 0xA2, 0x89, 0x1E, 0xF0,
  0xBE, 0x7F, 0x39, 0xF6, 0x28, 0x91, 0xBF, 0x3E, 0xB4, 0xF6, 0xCF, 0x32, 0x89, 0x07, 0xF8, 0xF8,
  0x1F, 0x9F, 0xE3, 0x89, 0x04, 0xFD, 0xF4, 0x0C, 0xDF, 0xB4, 0xB8, 0x11, 0x09, 0xA0, 0x84, 0x81,
  0xCF, 0xC2, 0x05, 0xA0, 0x42,
  // "X" (U+0058)
  0x81, 0x8F, 0xA2, 0x89, 0x0C, 0xF6, 0x1E, 0xF2, 0x3F, 0xE2, 0x84, 0x7F, 0x9A, 0xF6, 0x20, 0x10,
  0xEA, 0x0D, 0x40, 0x7A, 0x06, 0x40, 0x8A, 0x07, 0x38, 0x42, 0xFE, 0xFE, 0x12, 0x89, 0x2A, 0xF7,
  0x9F, 0x90, 0x2F, 0xE0, 0x1A, 0x82, 0x2B, 0xF7, 0x28, 0x19, 0xFA,
  // "Y" (U+0059)
  0x81, 0xCF, 0x62, 0x84, 0x9F, 0x85, 0xFC, 0x28, 0x90, 0xEF, 0x10, 0xDF, 0x36, 0xF9, 0x28, 0x46,
  0xF8, 0xBF, 0x23, 0x82, 0xEE, 0xFB, 0x40, 0x7A, 0x03, 0x48, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x58,
  0x12, 0xFE, 0x58, 0x12, 0xFE, 0x30,
  // "Z" (U+005A)
  0x08, 0xD8, 0x6A, 0x59, 0x99, 0xEF, 0x83, 0x82, 0x2F, 0xE1, 0x38, 0x1B, 0xF6, 0x38, 0x14, 0xFD,
  0x48, 0x1D, 0xF4, 0x38, 0x16, 0xFB, 0x48, 0x1E, 0xF3, 0x38, 0x68, 0xFE, 0x99, 0x97, 0xAD, 0x0B,
  // "[" (U+005B)
  0x01, 0xB8, 0x75, 0x1F, 0xD9, 0x31, 0xFB, 0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB,
  0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB, 0x28, 0x11, 0xFB, 0x28,
  0x41, 0xFD, 0x93, 0x1B, 0x05,
  // "\" (U+005C)
  0x81, 0xAF, 0x23, 0x81, 0x4F, 0x84, 0x0D, 0x0E, 0x48, 0x17, 0xF5, 0x38, 0x11, 0xFB, 0x48, 0x1A,
  0xF2, 0x38, 0x13, 0xF8, 0x40, 0xD0, 0xE4, 0x81, 0x6F, 0x53, 0x81, 0x1E, 0xC0,
  // "]" (U+005D)
  0x09, 0xA8, 0x3C, 0x69, 0xFC, 0x29, 0x0C, 0x29, 0x0C, 0x29, 0x0C, 0x29, 0x0C, 0x29, 0x0C, 0x29,
  0x0C, 0x29, 0x0C, 0x29, 0x0C, 0x29, 0x84, 0xC6, 0x9F, 0xC9, 0xA0, 0xC0,
  // "^" (U+005E)
  0x30, 0x60, 0x35, 0x81, 0x2F, 0xD5, 0x09, 0xA0, 0x53, 0x83, 0x2F, 0x9D, 0xD3, 0x89, 0x09, 0xF2,
  0x5F, 0x60, 0x1F, 0xA2, 0x84, 0xDD, 0x08, 0xF3, 0x28, 0x16, 0xF6,
  // "_" (U+005F)
  0x80, 0x29, 0x08, 0xE0, 0xD0,
  // "`" (U+0060)
  0x81, 0x27, 0x73, 0x81, 0xAF, 0x73, 0x81, 0xAE, 0x10,
  // "a" (U+0061)
  0x18, 0x35, 0xCE, 0xE9, 0x28, 0x47, 0xDA, 0xEF, 0x64, 0x84, 0x6F, 0x90, 0x7D, 0xB8, 0xB3, 0xA4,
  0xFC, 0x15, 0xFA, 0x7F, 0x90, 0x7F, 0xA5, 0xFE, 0xAE, 0xFA, 0x0A, 0xED, 0x3E, 0xA0,
  // "b" (U+0062)
  0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5, 0x87, 0x1F, 0xE6, 0xED, 0x50, 0x1A, 0x84, 0xDB, 0xFE, 0x01,
  0xA8, 0x42, 0x0C, 0xF5, 0x1A, 0x28, 0x29, 0xF7, 0x1A, 0x28, 0x29, 0xF7, 0x1A, 0x84, 0x20, 0xCF,
  0x51, 0xA8, 0x92, 0xDB, 0xFE, 0x01, 0xFA, 0x7E, 0xD4, 0x10,
  // "c" (U+0063)
  0x18, 0x94, 0x1A, 0xEE, 0xB0, 0xBF, 0xCB, 0xB3, 0xFD, 0x38, 0x15, 0xFA, 0x38, 0x16, 0xFA, 0x38,
  0x14, 0xFD, 0x48, 0x91, 0xDF, 0xCA, 0xD0, 0x2B, 0xEE, 0x90,
  // "d" (U+0064)
  0x58, 0x1D, 0xF2, 0x58, 0x1D, 0xF2, 0x58, 0x96, 0xDF, 0x20, 0x3D, 0xE7, 0xCF, 0x20, 0xDF, 0xBD,
  0xA8, 0x42, 0x3F, 0xD0, 0x1A, 0x82, 0x25, 0xFA, 0x28, 0x4D, 0xF2, 0x5F, 0xA2, 0x86, 0xDF, 0x23,
  0xFD, 0x01, 0xA8, 0x42, 0x0D, 0xFB, 0xCA, 0x87, 0x20, 0x3D, 0xE8, 0x9F, 0x20,
  // "e" (U+0065)
  0x18, 0x32, 0xBE, 0xD7, 0x28, 0x94, 0xCF, 0xBD, 0xF6, 0x3F, 0xB0, 0x1F, 0xC5, 0xD8, 0x91, 0xE5,
  0xFD, 0x99, 0x99, 0x3F, 0xC5, 0x89, 0x3C, 0xFC, 0xAC, 0x80, 0x1A, 0xEE, 0xC4,
  // "f" (U+0066)
  0x18, 0x90, 0x2C, 0xFD, 0x20, 0x9F, 0xCA, 0x28, 0x1B, 0xF3, 0x20, 0x8B, 0x85, 0xB0, 0x7E, 0xFB,
  0x72, 0x81, 0xCF, 0x33, 0x81, 0xCF, 0x33, 0x81, 0xCF, 0x33, 0x81, 0xCF, 0x33, 0x81, 0xCF, 0x33,
  0x81, 0xCF, 0x32,
  // "g" (U+0067)
  0x18, 0x92, 0x3D, 0xE8, 0xAF, 0x20, 0xDF, 0xBD, 0xA8, 0x42, 0x3F, 0xD0, 0x1A, 0x82, 0x25, 0xFA,
  0x28, 0x4D, 0xF2, 0x5F, 0xA2, 0x84, 0xDF, 0x23, 0xFD, 0x2A, 0x84, 0x20, 0xDF, 0xBC, 0xA8, 0x72,
  0x04, 0xDE, 0x7D, 0xF1, 0x50, 0xE9, 0x28, 0x4E, 0xBA, 0xDF, 0x92, 0x83, 0xAE, 0xFD, 0x82,
  // "h" (U+0068)
  0x01, 0xA5, 0x01, 0xA5, 0x81, 0x1F, 0xE5, 0x87, 0x1F, 0xE7, 0xED, 0x50, 0x1A, 0x0D, 0x0B, 0xA0,
  0x01, 0xA8, 0x43, 0x0D, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B,
  0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x1B, 0xF4,
  // "i" (U+0069)
  0x84, 0x1D, 0xD0, 0x77, 0x30, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01,
  0xA0,
  // "j" (U+006A)
  0x18, 0x11, 0xDD, 0x20, 0x07, 0x50, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x86, 0x6C, 0xFC, 0x8F, 0xC3,
  // "k" (U+006B)
  0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA2, 0x82, 0xDF, 0x41, 0xA1, 0x89, 0x09, 0xF8, 0x01,
  0xFE, 0x5F, 0xC2, 0x84, 0x1F, 0xEE, 0xF5, 0x20, 0x1A, 0x81, 0xEF, 0xC2, 0x01, 0xA8, 0x41, 0xCF,
  0x50, 0x1A, 0x18, 0x34, 0xFD, 0x01, 0xA2, 0x81, 0xBF, 0x70,
  // "l" (U+006C)
  0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01,
  0xA0,
  // "m" (U+006D)
  0x89, 0x31, 0xFA, 0x8E, 0xE6, 0x6D, 0xE7, 0x01, 0xA0, 0xD0, 0xBA, 0x0E, 0x0B, 0xA0, 0x20, 0x1A,
  0x89, 0x03, 0x0E, 0xF5, 0x0C, 0xF4, 0x1A, 0x28, 0x6D, 0xF3, 0x0A, 0xF5, 0x1A, 0x28, 0x6D, 0xF2,
  0x0A, 0xF5, 0x1A, 0x28, 0x6D, 0xF2, 0x0A, 0xF5, 0x1A, 0x28, 0x6D, 0xF2, 0x0A, 0xF5, 0x1A, 0x28,
  0x5D, 0xF2, 0x0A, 0xF5,
  // "n" (U+006E)
  0x87, 0x1F, 0x98, 0xED, 0x50, 0x1A, 0x0D, 0x0B, 0xA0, 0x01, 0xA8, 0x43, 0x0D, 0xF4, 0x1A, 0x28,
  0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28,
  0x1B, 0xF4,
  // "o" (U+006F)
  0x18, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xCF, 0xCC, 0xFA, 0x03, 0xFD, 0x28, 0x4E, 0xF1, 0x5F, 0xA2,
  0x84, 0xCF, 0x45, 0xFA, 0x28, 0x4C, 0xF4, 0x3F, 0xD2, 0x89, 0x0E, 0xF1, 0x0B, 0xFC, 0xCF, 0xA2,
  0x83, 0x1A, 0xEE, 0x92,
  // "p" (U+0070)
  0x87, 0x1F, 0xA6, 0xED, 0x50, 0x1A, 0x84, 0xDB, 0xFE, 0x01, 0xA8, 0x42, 0x0C, 0xF5, 0x1A, 0x28,
  0x29, 0xF7, 0x1A, 0x28, 0x29, 0xF7, 0x1A, 0x84, 0x20, 0xCF, 0x51, 0xA8, 0x94, 0xDB, 0xFE, 0x01,
  0xFE, 0x6E, 0xD4, 0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5,
  // "q" (U+0071)
  0x18, 0x92, 0x3D, 0xE8, 0xAF, 0x20, 0xDF, 0xBD, 0xA8, 0x42, 0x3F, 0xD0, 0x1A, 0x82, 0x25, 0xFA,
  0x28, 0x4D, 0xF2, 0x5F, 0xA2, 0x86, 0xDF, 0x23, 0xFD, 0x01, 0xA8, 0x42, 0x0D, 0xFB, 0xCA, 0x87,
  0x20, 0x4D, 0xE7, 0xDF, 0x25, 0x81, 0xDF, 0x25, 0x81, 0xDF, 0x25, 0x81, 0xDF, 0x20,
  // "r" (U+0072)
  0x85, 0x1F, 0x96, 0xE6, 0x1A, 0x82, 0xEA, 0x41, 0xA0, 0x42, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3,
  0x01, 0xA3, 0x01, 0xA3,
  // "s" (U+0073)
  0x18, 0x94, 0x8E, 0xEC, 0x45, 0xFE, 0xAE, 0x46, 0xFA, 0x38, 0x31, 0xEF, 0xD4, 0x20, 0x10, 0x9A,
  0x05, 0x38, 0x94, 0x7F, 0xA7, 0xDA, 0xDF, 0x84, 0xDF, 0xE9, 0x10,
  // "t" (U+0074)
  0x18, 0x12, 0x71, 0x28, 0x48, 0xF2, 0x06, 0xEA, 0x89, 0x0D, 0x7E, 0xFA, 0x80, 0xDF, 0x22, 0x81,
  0xDF, 0x22, 0x81, 0xDF, 0x22, 0x81, 0xDF, 0x22, 0x87, 0xBF, 0xDB, 0x03, 0xDF, 0xC0,
  // "u" (U+0075)
  0x81, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE,
  0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74,
  0x03, 0xCE, 0xA7, 0xF4,
  // "v" (U+0076)
  0x83, 0xCF, 0x40, 0x1A, 0x8B, 0x17, 0xF8, 0x05, 0xFB, 0x3F, 0xC0, 0x9F, 0x60, 0xDF, 0x0D, 0xF1,
  0x08, 0xF6, 0xFC, 0x28, 0x34, 0xFC, 0xF7, 0x30, 0xEA, 0x02, 0x38, 0x19, 0xFD, 0x20,
  // "w" (U+0077)
  0x89, 0x6C, 0xF3, 0x0B, 0xFC, 0x03, 0xFC, 0x8F, 0x70, 0xEA, 0x18, 0xC1, 0x6F, 0x84, 0xFA, 0x2F,
  0xBF, 0x39, 0xF4, 0x1F, 0xD6, 0xF5, 0xF6, 0xDF, 0x10, 0xCF, 0x9F, 0x0F, 0x9F, 0xC2, 0x87, 0x9F,
  0xDC, 0x0C, 0xDF, 0x92, 0x05, 0xA8, 0x19, 0x09, 0xA0, 0x52, 0x01, 0xA8, 0x16, 0x06, 0xA0, 0x11,
  // "x" (U+0078)
  0x8A, 0x28, 0xFA, 0x07, 0xFA, 0x1E, 0xF3, 0xEF, 0x20, 0x7F, 0xEF, 0x93, 0x0E, 0xA0, 0x22, 0x01,
  0x0E, 0xA0, 0x32, 0x8A, 0x28, 0xFC, 0xFB, 0x01, 0xFE, 0x1D, 0xF4, 0x9F, 0x80, 0x6F, 0xC0,
  // "y" (U+0079)
  0x83, 0xCF, 0x50, 0x1A, 0x8B, 0x16, 0xF9, 0x05, 0xFA, 0x1F, 0xE0, 0xAF, 0x50, 0xBF, 0x3E, 0xF1,
  0x06, 0xFA, 0xFB, 0x20, 0x1B, 0x06, 0x30, 0xBA, 0x01, 0x38, 0x16, 0xFB, 0x48, 0x1B, 0xF6, 0x28,
  0x25, 0xBF, 0xE3, 0x82, 0x6F, 0xC3, 0x30,
  // "z" (U+007A)
  0x07, 0xC8, 0x58, 0x49, 0x9E, 0xF6, 0x28, 0x13, 0xFD, 0x38, 0x1C, 0xF4, 0x28, 0x15, 0xFB, 0x38,
  0x1D, 0xF3, 0x28, 0x57, 0xFE, 0x99, 0x6A, 0xC0, 0xA0,
  // "{" (U+007B)
  0x28, 0x25, 0xDF, 0x12, 0x82, 0xEF, 0xB1, 0x29, 0x0D, 0x49, 0x0C, 0x38, 0x12, 0xFC, 0x28, 0x27,
  0xDF, 0x72, 0x82, 0xAF, 0xC3, 0x38, 0x16, 0xFB, 0x49, 0x0C, 0x49, 0x0C, 0x49, 0x0E, 0x01, 0x30,
  0xCA, 0x01, 0x28, 0x21, 0x79, 0x10,
  // "|" (U+007C)
  0x8D, 0x06, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x46, 0xF4, 0x6F,
  0x46, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x40,
  // "}" (U+007D)
  0x82, 0x7E, 0xB1, 0x28, 0x25, 0xDF, 0x83, 0x81, 0x3F, 0xA3, 0x81, 0x3F, 0xA3, 0x81, 0x3F, 0xB4,
  0x82, 0xDF, 0xB2, 0x20, 0x7A, 0x84, 0x40, 0x2F, 0xD2, 0x28, 0x13, 0xFA, 0x38, 0x13, 0xFA, 0x38,
  0x16, 0xF9, 0x20, 0x8A, 0x06, 0x28, 0x14, 0x85, 0x30,
  // "~" (U+007E)
  0x18, 0x16, 0x84, 0x20, 0x30, 0x7B, 0x89, 0x0D, 0xAE, 0x63, 0x17, 0xDE, 0x80,
  // "¡" (U+00A1)
  0x89, 0x01, 0xDD, 0x01, 0xEE, 0x10, 0x13, 0x00, 0xD2, 0x0E, 0x0D, 0x29, 0x0E, 0x2A, 0x10, 0x1A,
  0x10, 0x1A, 0x01, 0x02, 0xA0, 0x20,
  // "¢" (U+00A2)
  0x18, 0x52, 0xAD, 0x71, 0x3E, 0xB8, 0x90, 0x4B, 0xF8, 0x04, 0x0E, 0xF2, 0x3A, 0x01, 0x38, 0x1E,
  0xF2, 0x38, 0x5B, 0xF7, 0x02, 0x24, 0xC8, 0x44, 0x03, 0xBD, 0x73, 0x06, 0x0B, 0x20,
  // "£" (U+00A3)
  0x28, 0x96, 0x4C, 0xFD, 0x70, 0x1E, 0xFB, 0xB7, 0x03, 0xFC, 0x48, 0x14, 0xFC, 0x30, 0x5C, 0x86,
  0xE0, 0x3B, 0xFE, 0x98, 0x28, 0x14, 0xFC, 0x48, 0x16, 0xF8, 0x38, 0x63, 0xEF, 0x99, 0x99, 0x5E,
  // "¤" (U+00A4)
  0x10, 0x34, 0x89, 0x73, 0x01, 0xFA, 0xDE, 0x9F, 0x50, 0x8F, 0xCB, 0xFC, 0x20, 0xA0, 0xB2, 0x07,
  0x0E, 0x20, 0xA0, 0xB2, 0x06, 0x0E, 0x28, 0x97, 0x8F, 0xCA, 0xFC, 0x01, 0xFB, 0xDE, 0xAF, 0x50,
  0x34, 0x03, 0x10,
  // "¥" (U+00A5)
  0x81, 0x9F, 0x72, 0xA8, 0x61, 0x2F, 0xC0, 0x5F, 0x92, 0x84, 0xBF, 0x2A, 0xF2, 0x28, 0x34, 0xF8,
  0xEB, 0x40, 0xDA, 0x04, 0x20, 0x1D, 0x08, 0x28, 0x63, 0x6F, 0xC3, 0x10, 0x1D, 0x08, 0x28, 0x49,
  0xBF, 0xE9, 0x53, 0x81, 0x4F, 0xB3,
  // "¦" (U+00A6)
  0x8A, 0x06, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x46, 0xF4, 0x6F, 0x47, 0x28, 0x95, 0x6F, 0x46, 0xF4,
  0x6F, 0x46, 0xF4, 0x6F, 0x40,
  // "§" (U+00A7)
  0x18, 0x94, 0x5D, 0xEC, 0x51, 0xFE, 0xAD, 0x61, 0xFA, 0x48, 0xA5, 0x9F, 0xD5, 0x01, 0xDA, 0xAF,
  0x74, 0xF6, 0x0C, 0xB0, 0xCF, 0xAF, 0x62, 0x82, 0x6D, 0xF4, 0x38, 0x94, 0x1F, 0xA4, 0xEA, 0xBF,
  0x81, 0xBE, 0xE9, 0x10,
  // "¨" (U+00A8)
  0x89, 0x21, 0x82, 0x38, 0x04, 0xE4, 0x7E, 0x20,
  // "©" (U+00A9)
  0x38, 0x54, 0xBE, 0xFD, 0x81, 0x48, 0x79, 0xD5, 0x10, 0x39, 0xD2, 0x20, 0x70, 0xC6, 0x07, 0x0D,
  0x28, 0xA1, 0xE3, 0x06, 0xDF, 0xD3, 0x0C, 0x53, 0xD0, 0x4F, 0x60, 0x22, 0x85, 0x7A, 0x5C, 0x09,
  0xD5, 0x85, 0x5B, 0x3D, 0x09, 0xD5, 0x8A, 0x77, 0xA0, 0xE2, 0x4F, 0x50, 0x21, 0x0C, 0x60, 0x7C,
  0x06, 0xDF, 0xD2, 0x6D, 0x38, 0x7A, 0xD5, 0x10, 0x29, 0xD2, 0x48, 0x55, 0xBE, 0xFD, 0x81, 0x20,
  // "ª" (U+00AA)
  0x8A, 0x72, 0xCE, 0xC1, 0x03, 0x2E, 0x74, 0xEC, 0xE8, 0x9D, 0x1F, 0x84, 0xEC, 0xA8,
  // "«" (U+00AB)
  0x20, 0x02, 0x20, 0x43, 0x8B, 0x3C, 0xF1, 0x6F, 0x70, 0x9F, 0x83, 0xFD, 0x04, 0xFD, 0x1D, 0xF5,
  0x03, 0xFE, 0x1B, 0xF7, 0x28, 0x56, 0xFA, 0x1E, 0xE2, 0x28, 0x4A, 0xD1, 0x4F, 0x66, 0x01, 0x10,
  // "¬" (U+00AC)
  0x04, 0x80, 0x29, 0x07, 0xD0, 0xE5, 0x0A, 0x0E, 0x50, 0xA0, 0xE5, 0x05, 0x07,
  // "®" (U+00AE)
  0x38, 0x54, 0xBE, 0xFD, 0x81, 0x48, 0x79, 0xD5, 0x10, 0x39, 0xD2, 0x20, 0x70, 0xC6, 0x07, 0x0D,
  0x20, 0xE0, 0x31, 0xA8, 0x6E, 0xB1, 0x0C, 0x53, 0xD2, 0x98, 0x76, 0x3F, 0x60, 0x7A, 0x5C, 0x2C,
  0x84, 0x30, 0x5B, 0x3D, 0x29, 0x81, 0xCE, 0xA2, 0x8A, 0x77, 0xA0, 0xE2, 0x0F, 0x65, 0xF3, 0x0C,
  0x60, 0x7C, 0x0C, 0x50, 0xA8, 0x6D, 0x38, 0x7A, 0xD5, 0x10, 0x29, 0xD2, 0x48, 0x55, 0xBE, 0xFD,
  0x81, 0x20,
  // "¯" (U+00AF)
  0x80, 0x39, 0x02, 0xF0, 0x30,
  // "°" (U+00B0)
  0x18, 0xA4, 0x9E, 0xD6, 0x06, 0xE1, 0x4F, 0x16, 0xE1, 0x4F, 0x10, 0x9E, 0xD6, 0x10,
  // "±" (U+00B1)
  0x39, 0x09, 0x59, 0x09, 0x28, 0x64, 0x99, 0xFD, 0x99, 0x7E, 0x39, 0x09, 0x59, 0x09, 0x59, 0x09,
  0x20, 0x48, 0x02, 0x90, 0x7E,
  // "²" (U+00B2)
  0x89, 0x03, 0xDF, 0xC1, 0x38, 0x6F, 0x62, 0x89, 0x45, 0xF3, 0x03, 0xE8, 0x02, 0xEA, 0x10, 0x9B,
  0x84, 0xA2, 0x33, 0x32,
  // "³" (U+00B3)
  0x89, 0x43, 0xDF, 0xD2, 0x17, 0x7F, 0x50, 0x9F, 0xC2, 0x89, 0x02, 0x5E, 0x74, 0x32, 0xE9, 0x7A,
  0x83, 0xE2, 0x02, 0x32,
  // "´" (U+00B4)
  0x28, 0x72, 0x20, 0x6F, 0xB2, 0xF9, 0x10,
  // "µ" (U+00B5)
  0x01, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF,
  0x41, 0xA2, 0x82, 0xCF, 0x41, 0xA8, 0x41, 0x0E, 0xF4, 0x1A, 0x00, 0xCA, 0x89, 0x24, 0x1F, 0xED,
  0xD7, 0xF4, 0x1F, 0xE5, 0x01, 0xA5, 0x01, 0xA5,
  // "¶" (U+00B6)
  0x10, 0x30, 0xCC, 0x81, 0x20, 0xDB, 0x82, 0x9F, 0x23, 0xC1, 0x90, 0x20, 0x4C, 0x19, 0x02, 0x04,
  0xC1, 0x90, 0x20, 0x1C, 0x19, 0x81, 0x20, 0xBB, 0x19, 0x02, 0x28, 0x46, 0x8F, 0x0F, 0x23, 0x83,
  0x1F, 0x0F, 0x23, 0x83, 0x1F, 0x0F, 0x23, 0x83, 0x1F, 0x0F, 0x23, 0x83, 0x1F, 0x0F, 0x23, 0x83,
  0x1F, 0x0F, 0x24, 0x81, 0x10, 0x11,
  // "·" (U+00B7)
  0x18, 0x90, 0x11, 0x01, 0xFE, 0x11, 0xDD, 0x10,
  // "¸" (U+00B8)
  0x10, 0x20, 0x32, 0x81, 0xAD, 0x32, 0x86, 0xDB, 0x3E, 0xF6, 0x01, 0x20,
  // "¹" (U+00B9)
  0x18, 0x91, 0x2C, 0xE2, 0xEE, 0xE0, 0x49, 0xE2, 0x09, 0x0E, 0x20, 0x90, 0xE2, 0x09, 0x0E,
  // "º" (U+00BA)
  0x18, 0xA6, 0xAE, 0xC1, 0x6E, 0x1C, 0x98, 0xC0, 0x9C, 0x6E, 0x1C, 0x90, 0xAE, 0xB1,
  // "»" (U+00BB)
  0x18, 0x33, 0x10, 0x13, 0x28, 0x53, 0xFA, 0x0C, 0xE2, 0x28, 0x4A, 0xF6, 0x4F, 0xC2, 0x8B, 0x31,
  0xEF, 0x2A, 0xF8, 0x03, 0xFE, 0x1C, 0xF6, 0x0C, 0xF4, 0x6F, 0xA0, 0x3E, 0x80, 0xBD, 0x30, 0x13,
  0x01, 0x20,
  // "¼" (U+00BC)
  0x18, 0x13, 0xDB, 0x38, 0x13, 0xF6, 0x28, 0x24, 0xFE, 0xB3, 0x0B, 0x0D, 0x48, 0x13, 0xCB, 0x28,
  0x14, 0xF5, 0x50, 0xC0, 0xB2, 0x00, 0xC6, 0x89, 0x0C, 0xB0, 0x5F, 0x40, 0xCF, 0x12, 0x89, 0x0C,
  0xB0, 0xDB, 0x07, 0xEF, 0x14, 0x86, 0x6F, 0x32, 0xD7, 0xF1, 0x48, 0x6E, 0xA0, 0xBB, 0xAF, 0x73,
  0x83, 0x7F, 0x20, 0xEB, 0x0E, 0x28, 0x11, 0xE8, 0x28, 0x32, 0x28, 0xF3, 0x30, 0x25, 0x01, 0x02,
  0x10,
  // "½" (U+00BD)
  0x18, 0x13, 0xDB, 0x38, 0x15, 0xF4, 0x28, 0x24, 0xFE, 0xB3, 0x0D, 0x0B, 0x48, 0x14, 0xCB, 0x28,
  0x16, 0xF3, 0x58, 0x4C, 0xB0, 0x1E, 0x96, 0x89, 0x0C, 0xB0, 0x8F, 0x3B, 0xFD, 0x42, 0x89, 0x0C,
  0xB1, 0xF8, 0x07, 0x4E, 0x94, 0x81, 0x9E, 0x12, 0x81, 0x4F, 0x43, 0x81, 0x3F, 0x62, 0x81, 0x4E,
  0x64, 0x0B, 0x0D, 0x28, 0x33, 0xFD, 0x98, 0x28, 0x14, 0xF5, 0x20, 0x5B, 0x0D,
  // "¾" (U+00BE)
  0x83, 0x3C, 0xEB, 0x12, 0x81, 0x1E, 0x92, 0x83, 0x16, 0x1F, 0x72, 0x81, 0x8F, 0x14, 0x85, 0x2F,
  0x40, 0x1F, 0x84, 0x86, 0x6D, 0xD2, 0x09, 0xE1, 0x38, 0xA6, 0x21, 0x0E, 0x92, 0xF7, 0x08, 0xC2,
  0x5E, 0xFC, 0x3B, 0xD0, 0x4E, 0xF3, 0x48, 0x63, 0xF5, 0x1D, 0x7F, 0x34, 0x86, 0xCC, 0x09, 0xC9,
  0xF8, 0x38, 0x35, 0xF4, 0x0C, 0xC3, 0x0D, 0x0B, 0x28, 0x32, 0x26, 0xF5, 0x30, 0x20, 0x15, 0x02,
  0x10,
  // "¿" (U+00BF)
  0x28, 0x18, 0xE5, 0x38, 0x1A, 0xF7, 0x40, 0x14, 0x81, 0x4B, 0x33, 0x81, 0xBF, 0x22, 0x81, 0xBF,
  0x92, 0x81, 0x7F, 0x93, 0x81, 0xBF, 0x42, 0x89, 0x31, 0x8F, 0xDA, 0xD9, 0x09, 0xEE, 0xB5,
  // "À" (U+00C0)
  0x18, 0x12, 0x77, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xE1, 0x77, 0x03, 0xA0, 0xC5, 0x83, 0x7F, 0xEF,
  0x14, 0x83, 0xCF, 0x9F, 0x53, 0x84, 0x1F, 0xD4, 0xFA, 0x38, 0x45, 0xFA, 0x0F, 0xE3, 0x85, 0xAF,
  0x60, 0xBF, 0x42, 0x0E, 0xD8, 0x94, 0x90, 0x4F, 0xEB, 0xBC, 0xFD, 0x08, 0xFA, 0x3A, 0x82, 0x2D,
  0xF6, 0x38, 0x1C, 0xF7,
  // "Á" (U+00C1)
  0x50, 0x02, 0x68, 0x16, 0xFB, 0x58, 0x12, 0xF9, 0x77, 0x03, 0xA0, 0xC5, 0x83, 0x7F, 0xEF, 0x14,
  0x83, 0xCF, 0x9F, 0x53, 0x84, 0x1F, 0xD4, 0xFA, 0x38, 0x45, 0xFA, 0x0F, 0xE3, 0x85, 0xAF, 0x60,
  0xBF, 0x42, 0x0E, 0xD8, 0x94, 0x90, 0x4F, 0xEB, 0xBC, 0xFD, 0x08, 0xFA, 0x3A, 0x82, 0x2D, 0xF6,
  0x38, 0x1C, 0xF7,
  // "Â" (U+00C2)
  0x38, 0x17, 0x72, 0x58, 0x27, 0xFE, 0xC4, 0x84, 0x2F, 0x62, 0xE7, 0x76, 0x03, 0xA0, 0xC5, 0x83,
  0x7F, 0xEF, 0x14, 0x83, 0xCF, 0x9F, 0x53, 0x84, 0x1F, 0xD4, 0xFA, 0x38, 0x45, 0xFA, 0x0F, 0xE3,
  0x85, 0xAF, 0x60, 0xBF, 0x42, 0x0E, 0xD8, 0x94, 0x90, 0x4F, 0xEB, 0xBC, 0xFD, 0x08, 0xFA, 0x3A,
  0x82, 0x2D, 0xF6, 0x38, 0x1C, 0xF7,
  // "Ã" (U+00C3)
  0x28, 0x3B, 0xE8, 0x9C, 0x38, 0x14, 0xFB, 0xA0, 0x73, 0x83, 0x13, 0x01, 0x35, 0x03, 0xA0, 0xC5,
  0x83, 0x7F, 0xEF, 0x14, 0x83, 0xCF, 0x9F, 0x53, 0x84, 0x1F, 0xD4, 0xFA, 0x38, 0x45, 0xFA, 0x0F,
  0xE3, 0x85, 0xAF, 0x60, 0xBF, 0x42, 0x0E, 0xD8, 0x94, 0x90, 0x4F, 0xEB, 0xBC, 0xFD, 0x08, 0xFA,
  0x3A, 0x82, 0x2D, 0xF6, 0x38, 0x1C, 0xF7,
  // "Ä" (U+00C4)
  0x18, 0x31, 0x82, 0x38, 0x48, 0x44, 0xE4, 0x7E, 0x27, 0x60, 0x3A, 0x0C, 0x58, 0x37, 0xFE, 0xF1,
  0x48, 0x3C, 0xF9, 0xF5, 0x38, 0x41, 0xFD, 0x4F, 0xA3, 0x84, 0x5F, 0xA0, 0xFE, 0x38, 0x5A, 0xF6,
  0x0B, 0xF4, 0x20, 0xED, 0x89, 0x49, 0x04, 0xFE, 0xBB, 0xCF, 0xD0, 0x8F, 0xA3, 0xA8, 0x22, 0xDF,
  0x63, 0x81, 0xCF, 0x70,
  // "Å" (U+00C5)
  0x28, 0x21, 0xCE, 0x95, 0x83, 0x5C, 0x2F, 0x14, 0x82, 0x1C, 0xE9, 0x50, 0x3A, 0x0C, 0x58, 0x37,
  0xFE, 0xF1, 0x48, 0x3C, 0xF9, 0xF5, 0x38, 0x41, 0xFD, 0x4F, 0xA3, 0x84, 0x5F, 0xA0, 0xFE, 0x38,
  0x5A, 0xF6, 0x0B, 0xF4, 0x20, 0xED, 0x89, 0x49, 0x04, 0xFE, 0xBB, 0xCF, 0xD0, 0x8F, 0xA3, 0xA8,
  0x22, 0xDF, 0x63, 0x81, 0xCF, 0x70,
  // "Æ" (U+00C6)
  0x30, 0x7E, 0x0D, 0x38, 0x6D, 0xFC, 0xFD, 0x99, 0x82, 0x84, 0x3F, 0xC6, 0xFA, 0x58, 0x49, 0xF7,
  0x6F, 0xA5, 0x82, 0xEF, 0x26, 0xC8, 0x94, 0x90, 0x5F, 0xC0, 0x6F, 0xD9, 0x96, 0x0B, 0xD0, 0xA3,
  0x01, 0xA8, 0x39, 0x9C, 0xFA, 0x38, 0x17, 0xFB, 0x28, 0x76, 0xFD, 0x99, 0x8D, 0xF6, 0x20, 0x6C,
  0x0D,
  // "Ç" (U+00C7)
  0x28, 0x63, 0xBE, 0xEB, 0x30, 0x3A, 0x86, 0xBB, 0xE2, 0x0C, 0xF8, 0x40, 0x1A, 0x01, 0x40, 0x3A,
  0x58, 0x13, 0xFE, 0x50, 0x2A, 0x01, 0x58, 0x1D, 0xF8, 0x50, 0x5A, 0x82, 0xBA, 0xD2, 0x28, 0x45,
  0xEF, 0xEB, 0x13, 0x81, 0xAD, 0x36, 0x0D, 0x0B, 0x48, 0x23, 0xEF, 0x65, 0x01, 0x40,
  // "È" (U+00C8)
  0x81, 0x27, 0x74, 0x81, 0xAF, 0x74, 0x81, 0xAE, 0x17, 0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E,
  0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23,
  0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "É" (U+00C9)
  0x30, 0x02, 0x38, 0x16, 0xFB, 0x28, 0x12, 0xF9, 0x71, 0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E,
  0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23,
  0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "Ê" (U+00CA)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x76, 0x0E, 0xC8, 0x90, 0x4E, 0xFA,
  0x99, 0x2E, 0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81,
  0xEF, 0x23, 0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "Ë" (U+00CB)
  0x89, 0x21, 0x82, 0x38, 0x04, 0xE4, 0x7E, 0x26, 0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2,
  0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85,
  0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "Ì" (U+00CC)
  0x81, 0x27, 0x74, 0x81, 0xAF, 0x74, 0x81, 0xAE, 0x17, 0x10, 0x8B, 0x85, 0xB0, 0x2B, 0xFC, 0x32,
  0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81,
  0x7F, 0x92, 0x85, 0x1A, 0xFC, 0x20, 0x8B, 0x0B,
  // "Í" (U+00CD)
  0x30, 0x02, 0x28, 0x56, 0xFB, 0x02, 0xF9, 0x60, 0x8B, 0x89, 0x0B, 0x2B, 0xFC, 0x30, 0x7F, 0x92,
  0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x89, 0x07, 0xF9, 0x01,
  0xAF, 0xC2, 0x8B, 0x0B,
  // "Î" (U+00CE)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x77, 0x08, 0xB8, 0x5B, 0x02, 0xBF,
  0xC3, 0x28, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9,
  0x38, 0x17, 0xF9, 0x28, 0x51, 0xAF, 0xC2, 0x08, 0xB0, 0xB0,
  // "Ï" (U+00CF)
  0x89, 0x21, 0x82, 0x38, 0x04, 0xE4, 0x7E, 0x26, 0x08, 0xB8, 0x5B, 0x02, 0xBF, 0xC3, 0x28, 0x17,
  0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9,
  0x28, 0x51, 0xAF, 0xC2, 0x08, 0xB0, 0xB1,
  // "Ð" (U+00D0)
  0x10, 0xEA, 0x81, 0xEC, 0x53, 0x82, 0xEF, 0xAB, 0xA0, 0x72, 0x83, 0xEF, 0x20, 0x5A, 0x83, 0x10,
  0xEF, 0x22, 0x82, 0xDF, 0x5C, 0xB8, 0x48, 0x0B, 0xF7, 0x7A, 0x89, 0x0A, 0x50, 0xBF, 0x60, 0xEF,
  0x22, 0x89, 0x1E, 0xF4, 0x0E, 0xF2, 0x06, 0xFE, 0x28, 0x2E, 0xFA, 0xBA, 0x05, 0x20, 0xEA, 0x81,
  0xEB, 0x42,
  // "Ñ" (U+00D1)
  0x28, 0x3B, 0xE8, 0x9C, 0x38, 0x14, 0xFB, 0xA0, 0x73, 0x83, 0x13, 0x01, 0x33, 0x81, 0xEF, 0xD3,
  0x82, 0xDF, 0x1E, 0xA0, 0x52, 0x82, 0xDF, 0x1E, 0xA0, 0xD2, 0x8C, 0x6D, 0xF1, 0xEE, 0xBF, 0x60,
  0xDF, 0x1E, 0xF3, 0xFD, 0x0D, 0xF1, 0xEF, 0x0B, 0xF6, 0xCF, 0x1E, 0xF0, 0x3F, 0xDC, 0xF1, 0xE9,
  0x20, 0xAB, 0x01, 0x0E, 0x92, 0x03, 0xB0, 0x10, 0xE9, 0x30, 0xAA, 0x01,
  // "Ò" (U+00D2)
  0x28, 0x12, 0x77, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xE1, 0x76, 0x84, 0x5C, 0xEE, 0xB3, 0x20, 0x5A,
  0x87, 0xBC, 0xFE, 0x20, 0xDF, 0x72, 0x82, 0xAF, 0xA2, 0xA0, 0x12, 0x84, 0x4F, 0xE3, 0xFE, 0x30,
  0x2A, 0x81, 0x3F, 0xE3, 0x02, 0xA0, 0x1A, 0x01, 0x28, 0x54, 0xFE, 0x0D, 0xF7, 0x28, 0x3A, 0xFA,
  0x04, 0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x44, 0xCE, 0xEB, 0x31,
  // "Ó" (U+00D3)
  0x50, 0x02, 0x68, 0x16, 0xFB, 0x58, 0x12, 0xF9, 0x77, 0x84, 0x5C, 0xEE, 0xB3, 0x20, 0x5A, 0x87,
  0xBC, 0xFE, 0x20, 0xDF, 0x72, 0x82, 0xAF, 0xA2, 0xA0, 0x12, 0x84, 0x4F, 0xE3, 0xFE, 0x30, 0x2A,
  0x81, 0x3F, 0xE3, 0x02, 0xA0, 0x1A, 0x01, 0x28, 0x54, 0xFE, 0x0D, 0xF7, 0x28, 0x3A, 0xFA, 0x04,
  0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x44, 0xCE, 0xEB, 0x31,
  // "Ô" (U+00D4)
  0x48, 0x17, 0x72, 0x58, 0x27, 0xFE, 0xC4, 0x84, 0x2F, 0x62, 0xE7, 0x75, 0x84, 0x5C, 0xEE, 0xB3,
  0x20, 0x5A, 0x87, 0xBC, 0xFE, 0x20, 0xDF, 0x72, 0x82, 0xAF, 0xA2, 0xA0, 0x12, 0x84, 0x4F, 0xE3,
  0xFE, 0x30, 0x2A, 0x81, 0x3F, 0xE3, 0x02, 0xA0, 0x1A, 0x01, 0x28, 0x54, 0xFE, 0x0D, 0xF7, 0x28,
  0x3A, 0xFA, 0x04, 0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x44, 0xCE, 0xEB, 0x31,
  // "Õ" (U+00D5)
  0x38, 0x3B, 0xE8, 0x9C, 0x38, 0x14, 0xFB, 0xA0, 0x73, 0x83, 0x13, 0x01, 0x34, 0x84, 0x5C, 0xEE,
  0xB3, 0x20, 0x5A, 0x87, 0xBC, 0xFE, 0x20, 0xDF, 0x72, 0x82, 0xAF, 0xA2, 0xA0, 0x12, 0x84, 0x4F,
  0xE3, 0xFE, 0x30, 0x2A, 0x81, 0x3F, 0xE3, 0x02, 0xA0, 0x1A, 0x01, 0x28, 0x54, 0xFE, 0x0D, 0xF7,
  0x28, 0x3A, 0xFA, 0x04, 0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x44, 0xCE, 0xEB, 0x31,
  // "Ö" (U+00D6)
  0x28, 0x31, 0x82, 0x38, 0x48, 0x44, 0xE4, 0x7E, 0x27, 0x58, 0x45, 0xCE, 0xEB, 0x32, 0x05, 0xA8,
  0x7B, 0xCF, 0xE2, 0x0D, 0xF7, 0x28, 0x2A, 0xFA, 0x2A, 0x01, 0x28, 0x44, 0xFE, 0x3F, 0xE3, 0x02,
  0xA8, 0x13, 0xFE, 0x30, 0x2A, 0x01, 0xA0, 0x12, 0x85, 0x4F, 0xE0, 0xDF, 0x72, 0x83, 0xAF, 0xA0,
  0x4A, 0x83, 0xBC, 0xFE, 0x22, 0x84, 0x4C, 0xEE, 0xB3, 0x10,
  // "×" (U+00D7)
  0x10, 0x23, 0x89, 0x62, 0x01, 0xE9, 0x03, 0xE9, 0x08, 0xFB, 0xEE, 0x22, 0x0A, 0xA0, 0x22, 0x89,
  0x63, 0xEE, 0xF9, 0x01, 0xED, 0x28, 0xF8, 0x07, 0x22, 0x07, 0x02,
  // "Ø" (U+00D8)
  0x70, 0x23, 0x87, 0x5C, 0xEE, 0xAE, 0x50, 0x5A, 0x0B, 0x0C, 0xA8, 0x52, 0x0D, 0xF7, 0x02, 0xA0,
  0xA0, 0x2A, 0x28, 0x91, 0xBC, 0xFE, 0x3F, 0xE0, 0x5E, 0x2A, 0x85, 0x3F, 0xE1, 0xE5, 0x1A, 0x02,
  0xA8, 0x6A, 0xB0, 0x3F, 0xE0, 0xDA, 0x85, 0x20, 0x9F, 0xA0, 0x5A, 0x89, 0x3B, 0xCF, 0xE2, 0x06,
  0xDB, 0xEE, 0xB3, 0x20, 0x20, 0x36,
  // "Ù" (U+00D9)
  0x18, 0x12, 0x77, 0x68, 0x1A, 0xF7, 0x68, 0x1A, 0xE1, 0x73, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02,
  0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF,
  0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D, 0xF6, 0x01, 0xA0, 0x20, 0x7A, 0x82,
  0xCE, 0xFB, 0x28, 0x47, 0xDE, 0xD9, 0x11,
  // "Ú" (U+00DA)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x74, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A,
  0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D, 0xF6, 0x01, 0xA0, 0x20, 0x7A, 0x82, 0xCE,
  0xFB, 0x28, 0x47, 0xDE, 0xD9, 0x11,
  // "Û" (U+00DB)
  0x28, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x73, 0xA0, 0x22, 0x81, 0xCF,
  0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22,
  0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D, 0xF6, 0x01, 0xA0, 0x20,
  0x7A, 0x82, 0xCE, 0xFB, 0x28, 0x47, 0xDE, 0xD9, 0x11,
  // "Ü" (U+00DC)
  0x18, 0x31, 0x82, 0x38, 0x38, 0x44, 0xE4, 0x7E, 0x27, 0x2A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22,
  0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4,
  0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x6C, 0xF4, 0xDF, 0x60, 0x1A, 0x02, 0x07, 0xA8, 0x2C,
  0xEF, 0xB2, 0x84, 0x7D, 0xED, 0x91, 0x10,
  // "Ý" (U+00DD)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x74, 0x81, 0xCF, 0x62, 0x84, 0x9F, 0x85, 0xFC,
  0x28, 0x90, 0xEF, 0x10, 0xDF, 0x36, 0xF9, 0x28, 0x46, 0xF8, 0xBF, 0x23, 0x82, 0xEE, 0xFB, 0x40,
  0x7A, 0x03, 0x48, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x30,
  // "Þ" (U+00DE)
  0x81, 0xEF, 0x24, 0x83, 0xEF, 0xA8, 0x52, 0x0E, 0xC8, 0xB5, 0xB0, 0xEF, 0x22, 0xEF, 0x3E, 0xF2,
  0x0B, 0xF5, 0xEF, 0x20, 0xDF, 0x3E, 0xFA, 0xCF, 0xD0, 0xEA, 0x85, 0xEB, 0x20, 0xEF, 0x24, 0x81,
  0xEF, 0x24,
  // "ß" (U+00DF)
  0x28, 0x38, 0xDF, 0xD7, 0x38, 0x59, 0xFD, 0xAE, 0xF5, 0x28, 0x5E, 0xF1, 0x08, 0xF8, 0x2A, 0x18,
  0x41, 0xDF, 0x30, 0x1A, 0x18, 0x1C, 0xF5, 0x20, 0x1A, 0x1A, 0x02, 0x20, 0x1A, 0x18, 0x49, 0xFE,
  0x40, 0x1A, 0x20, 0x8A, 0x02, 0x01, 0xA3, 0x82, 0xCF, 0x51, 0xA8, 0x14, 0xCA, 0xA0, 0x20, 0x1A,
  0x83, 0x2D, 0xFD, 0x61,
  // "à" (U+00E0)
  0x18, 0x12, 0x77, 0x58, 0x1A, 0xF7, 0x58, 0x1A, 0xE1, 0x72, 0x83, 0x5C, 0xEE, 0x92, 0x84, 0x7D,
  0xAE, 0xF6, 0x48, 0x46, 0xF9, 0x07, 0xDB, 0x8B, 0x3A, 0x4F, 0xC1, 0x5F, 0xA7, 0xF9, 0x07, 0xFA,
  0x5F, 0xEA, 0xEF, 0xA0, 0xAE, 0xD3, 0xEA,
  // "á" (U+00E1)
  0x40, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x73, 0x83, 0x5C, 0xEE, 0x92, 0x84, 0x7D, 0xAE,
  0xF6, 0x48, 0x46, 0xF9, 0x07, 0xDB, 0x8B, 0x3A, 0x4F, 0xC1, 0x5F, 0xA7, 0xF9, 0x07, 0xFA, 0x5F,
  0xEA, 0xEF, 0xA0, 0xAE, 0xD3, 0xEA,
  // "â" (U+00E2)
  0x38, 0x17, 0x72, 0x38, 0x27, 0xFE, 0xC2, 0x84, 0x2F, 0x62, 0xE7, 0x71, 0x83, 0x5C, 0xEE, 0x92,
  0x84, 0x7D, 0xAE, 0xF6, 0x48, 0x46, 0xF9, 0x07, 0xDB, 0x8B, 0x3A, 0x4F, 0xC1, 0x5F, 0xA7, 0xF9,
  0x07, 0xFA, 0x5F, 0xEA, 0xEF, 0xA0, 0xAE, 0xD3, 0xEA,
  // "ã" (U+00E3)
  0x28, 0x7B, 0xE8, 0x9C, 0x04, 0xFB, 0xA8, 0x57, 0x01, 0x30, 0x13, 0x28, 0x35, 0xCE, 0xE9, 0x28,
  0x47, 0xDA, 0xEF, 0x64, 0x84, 0x6F, 0x90, 0x7D, 0xB8, 0xB3, 0xA4, 0xFC, 0x15, 0xFA, 0x7F, 0x90,
  0x7F, 0xA5, 0xFE, 0xAE, 0xFA, 0x0A, 0xED, 0x3E, 0xA0,
  // "ä" (U+00E4)
  0x18, 0x31, 0x82, 0x38, 0x28, 0x44, 0xE4, 0x7E, 0x27, 0x18, 0x35, 0xCE, 0xE9, 0x28, 0x47, 0xDA,
  0xEF, 0x64, 0x84, 0x6F, 0x90, 0x7D, 0xB8, 0xB3, 0xA4, 0xFC, 0x15, 0xFA, 0x7F, 0x90, 0x7F, 0xA5,
  0xFE, 0xAE, 0xFA, 0x0A, 0xED, 0x3E, 0xA0,
  // "å" (U+00E5)
  0x28, 0x21, 0xCE, 0x93, 0x83, 0x5C, 0x2F, 0x12, 0x82, 0x1C, 0xE9, 0x72, 0x83, 0x5C, 0xEE, 0x92,
  0x84, 0x7D, 0xAE, 0xF6, 0x48, 0x46, 0xF9, 0x07, 0xDB, 0x8B, 0x3A, 0x4F, 0xC1, 0x5F, 0xA7, 0xF9,
  0x07, 0xFA, 0x5F, 0xEA, 0xEF, 0xA0, 0xAE, 0xD3, 0xEA,
  // "æ" (U+00E6)
  0x18, 0x75, 0xCE, 0xD5, 0x9E, 0xD7, 0x28, 0x27, 0xDA, 0xEA, 0x82, 0xBD, 0xF5, 0x48, 0x90, 0x6F,
  0xA0, 0x1F, 0xB0, 0x7D, 0xF0, 0xD0, 0x4A, 0x89, 0x5A, 0xBF, 0xD9, 0x99, 0x87, 0xF9, 0x07, 0xFC,
  0x48, 0xA4, 0x4F, 0xEA, 0xEC, 0xFC, 0xAC, 0x70, 0x9E, 0xD5, 0x09, 0xEE, 0xC3,
  // "ç" (U+00E7)
  0x18, 0x94, 0x1A, 0xEE, 0xB0, 0xBF, 0xCB, 0xB3, 0xFD, 0x38, 0x15, 0xFA, 0x38, 0x16, 0xFA, 0x38,
  0x14, 0xFD, 0x48, 0x6D, 0xFC, 0xAD, 0x02, 0xBA, 0x09, 0x38, 0x1A, 0xD3, 0x40, 0xD0, 0xB2, 0x82,
  0x3E, 0xF6, 0x30, 0x12,
  // "è" (U+00E8)
  0x18, 0x12, 0x77, 0x58, 0x1A, 0xF7, 0x58, 0x1A, 0xE1, 0x72, 0x83, 0x2B, 0xED, 0x72, 0x89, 0x4C,
  0xFB, 0xDF, 0x63, 0xFB, 0x01, 0xFC, 0x5D, 0x89, 0x1E, 0x5F, 0xD9, 0x99, 0x93, 0xFC, 0x58, 0x93,
  0xCF, 0xCA, 0xC8, 0x01, 0xAE, 0xEC, 0x40,
  // "é" (U+00E9)
  0x40, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x73, 0x83, 0x2B, 0xED, 0x72, 0x89, 0x4C, 0xFB,
  0xDF, 0x63, 0xFB, 0x01, 0xFC, 0x5D, 0x89, 0x1E, 0x5F, 0xD9, 0x99, 0x93, 0xFC, 0x58, 0x93, 0xCF,
  0xCA, 0xC8, 0x01, 0xAE, 0xEC, 0x40,
  // "ê" (U+00EA)
  0x38, 0x17, 0x72, 0x38, 0x27, 0xFE, 0xC2, 0x84, 0x2F, 0x62, 0xE7, 0x71, 0x83, 0x2B, 0xED, 0x72,
  0x89, 0x4C, 0xFB, 0xDF, 0x63, 0xFB, 0x01, 0xFC, 0x5D, 0x89, 0x1E, 0x5F, 0xD9, 0x99, 0x93, 0xFC,
  0x58, 0x93, 0xCF, 0xCA, 0xC8, 0x01, 0xAE, 0xEC, 0x40,
  // "ë" (U+00EB)
  0x18, 0x31, 0x82, 0x38, 0x28, 0x44, 0xE4, 0x7E, 0x27, 0x18, 0x32, 0xBE, 0xD7, 0x28, 0x94, 0xCF,
  0xBD, 0xF6, 0x3F, 0xB0, 0x1F, 0xC5, 0xD8, 0x91, 0xE5, 0xFD, 0x99, 0x99, 0x3F, 0xC5, 0x89, 0x3C,
  0xFC, 0xAC, 0x80, 0x1A, 0xEE, 0xC4,
  // "ì" (U+00EC)
  0x81, 0x27, 0x73, 0x81, 0xAF, 0x73, 0x81, 0xAE, 0x16, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01,
  0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA1,
  // "í" (U+00ED)
  0x28, 0x72, 0x20, 0x6F, 0xB2, 0xF9, 0x50, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  // "î" (U+00EE)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x77, 0x01, 0xA3, 0x01, 0xA3, 0x01,
  0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA2,
  // "ï" (U+00EF)
  0x89, 0x21, 0x82, 0x38, 0x04, 0xE4, 0x7E, 0x27, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3,
  0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA2,
  // "ð" (U+00F0)
  0x28, 0x36, 0xB5, 0xB1, 0x30, 0x5A, 0x0A, 0x48, 0x3A, 0xDF, 0xE1, 0x38, 0x32, 0x06, 0xF9, 0x28,
  0x42, 0xBE, 0xCF, 0xE2, 0x82, 0xDF, 0xBC, 0xA8, 0x23, 0x4F, 0xC2, 0x84, 0xDF, 0x46, 0xFA, 0x28,
  0x4B, 0xF4, 0x4F, 0xC2, 0x89, 0x0D, 0xF1, 0x0D, 0xFB, 0xCF, 0xA2, 0x84, 0x1A, 0xEE, 0xA1, 0x10,
  // "ñ" (U+00F1)
  0x28, 0x3B, 0xE8, 0x9C, 0x28, 0x14, 0xFB, 0xA0, 0x72, 0x83, 0x13, 0x01, 0x32, 0x87, 0x1F, 0x98,
  0xED, 0x50, 0x1A, 0x0D, 0x0B, 0xA0, 0x01, 0xA8, 0x43, 0x0D, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A,
  0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x1B, 0xF4,
  // "ò" (U+00F2)
  0x18, 0x12, 0x77, 0x68, 0x1A, 0xF7, 0x68, 0x1A, 0xE1, 0x74, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0C,
  0xFC, 0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4, 0x5F, 0xA2, 0x84, 0xCF,
  0x43, 0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "ó" (U+00F3)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x75, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0C, 0xFC,
  0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4, 0x5F, 0xA2, 0x84, 0xCF, 0x43,
  0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "ô" (U+00F4)
  0x38, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x73, 0x83, 0x1A, 0xEE, 0x93,
  0x89, 0x0C, 0xFC, 0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4, 0x5F, 0xA2,
  0x84, 0xCF, 0x43, 0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "õ" (U+00F5)
  0x28, 0x3B, 0xE8, 0x9C, 0x28, 0x14, 0xFB, 0xA0, 0x72, 0x83, 0x13, 0x01, 0x33, 0x83, 0x1A, 0xEE,
  0x93, 0x89, 0x0C, 0xFC, 0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4, 0x5F,
  0xA2, 0x84, 0xCF, 0x43, 0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE, 0xE9,
  0x20,
  // "ö" (U+00F6)
  0x18, 0x31, 0x82, 0x38, 0x38, 0x44, 0xE4, 0x7E, 0x27, 0x38, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xCF,
  0xCC, 0xFA, 0x03, 0xFD, 0x28, 0x4E, 0xF1, 0x5F, 0xA2, 0x84, 0xCF, 0x45, 0xFA, 0x28, 0x4C, 0xF4,
  0x3F, 0xD2, 0x89, 0x0E, 0xF1, 0x0B, 0xFC, 0xCF, 0xA2, 0x83, 0x1A, 0xEE, 0x92,
  // "÷" (U+00F7)
  0x28, 0x12, 0xE9, 0x50, 0x80, 0x42, 0x04, 0x80, 0x29, 0x07, 0xE7, 0x30, 0x80, 0x44, 0x81, 0x2E,
  0x92,
  // "ø" (U+00F8)
  0x50, 0x01, 0x28, 0x41, 0xAE, 0xEC, 0xA2, 0x89, 0x2C, 0xFB, 0xDF, 0x90, 0x3F, 0xC0, 0xAA, 0x8A,
  0x01, 0x5F, 0x94, 0xDB, 0xF3, 0x5F, 0xAD, 0x4B, 0xF4, 0x2A, 0x89, 0x2A, 0x0D, 0xF1, 0x0B, 0xFC,
  0xCF, 0xA2, 0x84, 0xBD, 0xEE, 0xA1, 0x20, 0x60, 0x15,
  // "ù" (U+00F9)
  0x18, 0x12, 0x77, 0x68, 0x1A, 0xF7, 0x68, 0x1A, 0xE1, 0x73, 0x81, 0x1F, 0xE2, 0x84, 0xBF, 0x41,
  0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x81,
  0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7, 0xF4,
  // "ú" (U+00FA)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x74, 0x81, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE,
  0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x81, 0xCF,
  0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7, 0xF4,
  // "û" (U+00FB)
  0x38, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x72, 0x81, 0x1F, 0xE2, 0x84,
  0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F,
  0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7, 0xF4,
  // "ü" (U+00FC)
  0x18, 0x31, 0x82, 0x38, 0x38, 0x44, 0xE4, 0x7E, 0x27, 0x28, 0x11, 0xFE, 0x28, 0x4B, 0xF4, 0x1F,
  0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x1C,
  0xF4, 0x1A, 0x28, 0x6E, 0xF4, 0x0C, 0xFB, 0xBA, 0x87, 0x40, 0x3C, 0xEA, 0x7F, 0x40,
  // "ý" (U+00FD)
  0x40, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x72, 0x83, 0xCF, 0x50, 0x1A, 0x8B, 0x16, 0xF9,
  0x05, 0xFA, 0x1F, 0xE0, 0xAF, 0x50, 0xBF, 0x3E, 0xF1, 0x06, 0xFA, 0xFB, 0x20, 0x1B, 0x06, 0x30,
  0xBA, 0x01, 0x38, 0x16, 0xFB, 0x48, 0x1B, 0xF6, 0x28, 0x25, 0xBF, 0xE3, 0x82, 0x6F, 0xC3, 0x30,
  // "þ" (U+00FE)
  0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5, 0x87, 0x1F, 0xE6, 0xED, 0x40, 0x1A, 0x84, 0xDB, 0xFE, 0x01,
  0xA8, 0x42, 0x0C, 0xF5, 0x1A, 0x28, 0x29, 0xF7, 0x1A, 0x28, 0x29, 0xF7, 0x1A, 0x84, 0x20, 0xCF,
  0x51, 0xA8, 0x94, 0xDB, 0xFE, 0x01, 0xFE, 0x6E, 0xE5, 0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5,
  // "ÿ" (U+00FF)
  0x18, 0x31, 0x82, 0x38, 0x28, 0x44, 0xE4, 0x7E, 0x27, 0x83, 0xCF, 0x50, 0x1A, 0x8B, 0x16, 0xF9,
  0x05, 0xFA, 0x1F, 0xE0, 0xAF, 0x50, 0xBF, 0x3E, 0xF1, 0x06, 0xFA, 0xFB, 0x20, 0x1B, 0x06, 0x30,
  0xBA, 0x01, 0x38, 0x16, 0xFB, 0x48, 0x1B, 0xF6, 0x28, 0x25, 0xBF, 0xE3, 0x82, 0x6F, 0xC3, 0x30,
  // "Ā" (U+0100)
  0x20, 0x38, 0x00, 0x94, 0x06, 0xC7, 0x77, 0x10, 0x3A, 0x0C, 0x58, 0x37, 0xFE, 0xF1, 0x48, 0x3C,
  0xF9, 0xF5, 0x38, 0x41, 0xFD, 0x4F, 0xA3, 0x84, 0x5F, 0xA0, 0xFE, 0x38, 0x5A, 0xF6, 0x0B, 0xF4,
  0x20, 0xED, 0x89, 0x49, 0x04, 0xFE, 0xBB, 0xCF, 0xD0, 0x8F, 0xA3, 0xA8, 0x22, 0xDF, 0x63, 0x81,
  0xCF, 0x70,
  // "ā" (U+0101)
  0x10, 0x38, 0x00, 0x92, 0x06, 0xC7, 0x28, 0x35, 0xCE, 0xE9, 0x28, 0x47, 0xDA, 0xEF, 0x64, 0x84,
  0x6F, 0x90, 0x7D, 0xB8, 0xB3, 0xA4, 0xFC, 0x15, 0xFA, 0x7F, 0x90, 0x7F, 0xA5, 0xFE, 0xAE, 0xFA,
  0x0A, 0xED, 0x3E, 0xA0,
  // "Ă" (U+0102)
  0x10, 0x20, 0x62, 0x07, 0x02, 0x38, 0x43, 0xFB, 0xBF, 0x24, 0x82, 0x7E, 0xD6, 0x77, 0x72, 0x03,
  0xA0, 0xC5, 0x83, 0x7F, 0xEF, 0x14, 0x83, 0xCF, 0x9F, 0x53, 0x84, 0x1F, 0xD4, 0xFA, 0x38, 0x45,
  0xFA, 0x0F, 0xE3, 0x85, 0xAF, 0x60, 0xBF, 0x42, 0x0E, 0xD8, 0x94, 0x90, 0x4F, 0xEB, 0xBC, 0xFD,
  0x08, 0xFA, 0x3A, 0x82, 0x2D, 0xF6, 0x38, 0x1C, 0xF7,
  // "ă" (U+0103)
  0x10, 0x20, 0x62, 0x87, 0x72, 0x03, 0xFB, 0xBF, 0x22, 0x82, 0x7E, 0xD6, 0x72, 0x83, 0x5C, 0xEE,
  0x92, 0x84, 0x7D, 0xAE, 0xF6, 0x48, 0x46, 0xF9, 0x07, 0xDB, 0x8B, 0x3A, 0x4F, 0xC1, 0x5F, 0xA7,
  0xF9, 0x07, 0xFA, 0x5F, 0xEA, 0xEF, 0xA0, 0xAE, 0xD3, 0xEA,
  // "Ą" (U+0104)
  0x20, 0x3A, 0x0C, 0x58, 0x37, 0xFE, 0xF1, 0x48, 0x3C, 0xF9, 0xF5, 0x38, 0x41, 0xFD, 0x4F, 0xA3,
  0x84, 0x5F, 0xA0, 0xFE, 0x38, 0x5A, 0xF6, 0x0B, 0xF4, 0x20, 0xED, 0x89, 0x49, 0x04, 0xFE, 0xBB,
  0xCF, 0xD0, 0x8F, 0xA3, 0xA8, 0x22, 0xDF, 0x63, 0xA0, 0x75, 0x81, 0x3F, 0x36, 0x82, 0x5F, 0xB4,
  0x58, 0x21, 0xCF, 0x40,
  // "ą" (U+0105)
  0x18, 0x35, 0xCE, 0xE9, 0x28, 0x47, 0xDA, 0xEF, 0x64, 0x84, 0x6F, 0x90, 0x7D, 0xB8, 0xB3, 0xA4,
  0xFC, 0x15, 0xFA, 0x7F, 0x90, 0x7F, 0xA5, 0xFE, 0xAE, 0xFA, 0x0A, 0xED, 0xBF, 0xA3, 0x81, 0x3F,
  0x34, 0x82, 0x5F, 0xB4, 0x38, 0x21, 0xCF, 0x40,
  // "Ć" (U+0106)
  0x50, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x77, 0x68, 0x63, 0xBE, 0xEB, 0x30, 0x3A, 0x86,
  0xBB, 0xE2, 0x0C, 0xF8, 0x40, 0x1A, 0x01, 0x40, 0x3A, 0x58, 0x13, 0xFE, 0x50, 0x2A, 0x01, 0x58,
  0x1D, 0xF8, 0x50, 0x5A, 0x82, 0xBA, 0xD2, 0x28, 0x45, 0xCF, 0xEB, 0x10,
  // "ć" (U+0107)
  0x40, 0x02, 0x38, 0x16, 0xFB, 0x28, 0x12, 0xF9, 0x71, 0x89, 0x41, 0xAE, 0xEB, 0x0B, 0xFC, 0xBB,
  0x3F, 0xD3, 0x81, 0x5F, 0xA3, 0x81, 0x6F, 0xA3, 0x81, 0x4F, 0xD4, 0x89, 0x1D, 0xFC, 0xAD, 0x02,
  0xBE, 0xE9,
  // "Ĉ" (U+0108)
  0x48, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x48, 0x63, 0xBE, 0xEB,
  0x30, 0x3A, 0x86, 0xBB, 0xE2, 0x0C, 0xF8, 0x40, 0x1A, 0x01, 0x40, 0x3A, 0x58, 0x13, 0xFE, 0x50,
  0x2A, 0x01, 0x58, 0x1D, 0xF8, 0x50, 0x5A, 0x82, 0xBA, 0xD2, 0x28, 0x45, 0xCF, 0xEB, 0x10,
  // "ĉ" (U+0109)
  0x38, 0x17, 0x72, 0x38, 0x27, 0xFE, 0xC2, 0x84, 0x2F, 0x62, 0xE7, 0x71, 0x83, 0x1A, 0xEE, 0xB2,
  0x87, 0xBF, 0xCB, 0xB0, 0x3F, 0xD4, 0x81, 0x5F, 0xA4, 0x81, 0x6F, 0xA4, 0x81, 0x4F, 0xD5, 0x83,
  0xDF, 0xCA, 0xD2, 0x83, 0x2B, 0xEE, 0x91,
  // "Ċ" (U+010A)
  0x38, 0x11, 0x85, 0x58, 0x14, 0xE9, 0x77, 0x68, 0x63, 0xBE, 0xEB, 0x30, 0x3A, 0x86, 0xBB, 0xE2,
  0x0C, 0xF8, 0x40, 0x1A, 0x01, 0x40, 0x3A, 0x58, 0x13, 0xFE, 0x50, 0x2A, 0x01, 0x58, 0x1D, 0xF8,
  0x50, 0x5A, 0x82, 0xBA, 0xD2, 0x28, 0x45, 0xCF, 0xEB, 0x10,
  // "ċ" (U+010B)
  0x28, 0x11, 0x85, 0x38, 0x14, 0xE9, 0x71, 0x89, 0x41, 0xAE, 0xEB, 0x0B, 0xFC, 0xBB, 0x3F, 0xD3,
  0x81, 0x5F, 0xA3, 0x81, 0x6F, 0xA3, 0x81, 0x4F, 0xD4, 0x89, 0x1D, 0xFC, 0xAD, 0x02, 0xBE, 0xE9,
  // "Č" (U+010C)
  0x28, 0x42, 0x71, 0x06, 0x53, 0x83, 0xCC, 0x9F, 0x33, 0x02, 0xA0, 0x77, 0x75, 0x86, 0x3B, 0xEE,
  0xB3, 0x03, 0xA8, 0x6B, 0xBE, 0x20, 0xCF, 0x84, 0x01, 0xA0, 0x14, 0x03, 0xA5, 0x81, 0x3F, 0xE5,
  0x02, 0xA0, 0x15, 0x81, 0xDF, 0x85, 0x05, 0xA8, 0x2B, 0xAD, 0x22, 0x84, 0x5C, 0xFE, 0xB1,
  // "č" (U+010D)
  0x18, 0x42, 0x71, 0x06, 0x52, 0x83, 0xCC, 0x9F, 0x32, 0x02, 0xA0, 0x77, 0x28, 0x31, 0xAE, 0xEB,
  0x28, 0x7B, 0xFC, 0xBB, 0x03, 0xFD, 0x48, 0x15, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x14, 0xFD, 0x58,
  0x3D, 0xFC, 0xAD, 0x28, 0x32, 0xBE, 0xE9, 0x10,
  // "Ď" (U+010E)
  0x84, 0x27, 0x10, 0x65, 0x38, 0x3C, 0xC9, 0xF3, 0x30, 0x2A, 0x07, 0x77, 0x50, 0xEA, 0x81, 0xEC,
  0x52, 0x82, 0xEF, 0xAB, 0xA8, 0x57, 0x0E, 0xF2, 0x05, 0xA8, 0x21, 0xEF, 0x22, 0x84, 0xDF, 0x5E,
  0xF2, 0x28, 0x4B, 0xF7, 0xEF, 0x22, 0x84, 0xBF, 0x6E, 0xF2, 0x28, 0x95, 0xDF, 0x4E, 0xF2, 0x06,
  0xFE, 0x0E, 0xFA, 0xBA, 0x81, 0x50, 0xEA, 0x81, 0xEB, 0x42,
  // "ď" (U+010F)
  0x58, 0x4D, 0xF2, 0x9F, 0x45, 0x83, 0xDF, 0x2B, 0xC6, 0x83, 0xDF, 0x22, 0x12, 0x85, 0x3D, 0xE7,
  0xCF, 0x24, 0x82, 0xDF, 0xBD, 0xA0, 0x23, 0x83, 0x3F, 0xD0, 0x1A, 0x02, 0x38, 0x15, 0xFA, 0x28,
  0x1D, 0xF2, 0x38, 0x15, 0xFA, 0x28, 0x1D, 0xF2, 0x38, 0x33, 0xFD, 0x01, 0xA0, 0x24, 0x82, 0xDF,
  0xBC, 0xA0, 0x24, 0x85, 0x3D, 0xE8, 0x9F, 0x23,
  // "Đ" (U+0110)
  0x10, 0xEA, 0x81, 0xEC, 0x53, 0x82, 0xEF, 0xAB, 0xA0, 0x72, 0x83, 0xEF, 0x20, 0x5A, 0x83, 0x10,
  0xEF, 0x22, 0x82, 0xDF, 0x5C, 0xB8, 0x48, 0x0B, 0xF7, 0x7A, 0x89, 0x0A, 0x50, 0xBF, 0x60, 0xEF,
  0x22, 0x89, 0x1E, 0xF4, 0x0E, 0xF2, 0x06, 0xFE, 0x28, 0x2E, 0xFA, 0xBA, 0x05, 0x20, 0xEA, 0x81,
  0xEB, 0x42,
  // "đ" (U+0111)
  0x58, 0x1D, 0xF2, 0x40, 0x8C, 0x01, 0x38, 0x94, 0x59, 0xEF, 0xA1, 0x03, 0xDE, 0x7D, 0xF2, 0x28,
  0x2D, 0xFB, 0xDA, 0x85, 0x20, 0x3F, 0xD0, 0x1A, 0x83, 0x20, 0x5F, 0xA2, 0x85, 0xDF, 0x20, 0x5F,
  0xA2, 0x87, 0xDF, 0x20, 0x3F, 0xD0, 0x1A, 0x02, 0x28, 0x2D, 0xFB, 0xDA, 0x02, 0x28, 0x53, 0xDE,
  0x89, 0xF2, 0x10,
  // "Ē" (U+0112)
  0x85, 0x39, 0x99, 0x90, 0x6C, 0x76, 0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2, 0x38, 0x1E,
  0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF, 0xA9,
  0x92, 0xEC, 0x04,
  // "ē" (U+0113)
  0x10, 0x38, 0x00, 0x92, 0x06, 0xC7, 0x28, 0x32, 0xBE, 0xD7, 0x28, 0x94, 0xCF, 0xBD, 0xF6, 0x3F,
  0xB0, 0x1F, 0xC5, 0xD8, 0x91, 0xE5, 0xFD, 0x99, 0x99, 0x3F, 0xC5, 0x89, 0x3C, 0xFC, 0xAC, 0x80,
  0x1A, 0xEE, 0xC4,
  // "Ĕ" (U+0114)
  0x02, 0x06, 0x28, 0x93, 0x72, 0x3F, 0xBB, 0xF2, 0x07, 0xED, 0x67, 0x60, 0xEC, 0x89, 0x04, 0xEF,
  0xA9, 0x92, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x0E, 0xC8, 0x90, 0x1E, 0xFA, 0x99, 0x0E, 0xF2, 0x38,
  0x1E, 0xF2, 0x38, 0x5E, 0xFA, 0x99, 0x2E, 0xC0, 0x40,
  // "ĕ" (U+0115)
  0x10, 0x20, 0x62, 0x87, 0x72, 0x03, 0xFB, 0xBF, 0x22, 0x82, 0x7E, 0xD6, 0x72, 0x83, 0x2B, 0xED,
  0x72, 0x89, 0x4C, 0xFB, 0xDF, 0x63, 0xFB, 0x01, 0xFC, 0x5D, 0x89, 0x1E, 0x5F, 0xD9, 0x99, 0x93,
  0xFC, 0x58, 0x93, 0xCF, 0xCA, 0xC8, 0x01, 0xAE, 0xEC, 0x40,
  // "Ė" (U+0116)
  0x18, 0x11, 0x85, 0x38, 0x14, 0xE9, 0x77, 0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2, 0x38,
  0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF,
  0xA9, 0x92, 0xEC, 0x04,
  // "ė" (U+0117)
  0x28, 0x11, 0x85, 0x48, 0x14, 0xE9, 0x73, 0x83, 0x2B, 0xED, 0x72, 0x89, 0x4C, 0xFB, 0xDF, 0x63,
  0xFB, 0x01, 0xFC, 0x5D, 0x89, 0x1E, 0x5F, 0xD9, 0x99, 0x93, 0xFC, 0x58, 0x93, 0xCF, 0xCA, 0xC8,
  0x01, 0xAE, 0xEC, 0x40,
  // "Ę" (U+0118)
  0x0E, 0xC8, 0x90, 0x4E, 0xFA, 0x99, 0x2E, 0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF,
  0xA9, 0x90, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04, 0x28, 0x13, 0xF3,
  0x38, 0x25, 0xFB, 0x42, 0x82, 0x1C, 0xF4,
  // "ę" (U+0119)
  0x18, 0x32, 0xBE, 0xD7, 0x28, 0x94, 0xCF, 0xBD, 0xF6, 0x3F, 0xB0, 0x1F, 0xC5, 0xD8, 0x91, 0xE5,
  0xFD, 0x99, 0x99, 0x3F, 0xC5, 0x89, 0x0C, 0xFC, 0xAC, 0x80, 0x1A, 0xEA, 0x05, 0x40, 0xB0, 0x64,
  0x82, 0x3F, 0xC5, 0x48, 0x1C, 0xF7,
  // "Ě" (U+011A)
  0x89, 0x42, 0x71, 0x06, 0x50, 0xCC, 0x9F, 0x30, 0x2A, 0x07, 0x76, 0x0E, 0xC8, 0x90, 0x4E, 0xFA,
  0x99, 0x2E, 0xF2, 0x38, 0x1E, 0xF2, 0x30, 0xEC, 0x89, 0x01, 0xEF, 0xA9, 0x90, 0xEF, 0x23, 0x81,
  0xEF, 0x23, 0x85, 0xEF, 0xA9, 0x92, 0xEC, 0x04,
  // "ě" (U+011B)
  0x18, 0x42, 0x71, 0x06, 0x52, 0x83, 0xCC, 0x9F, 0x32, 0x02, 0xA0, 0x77, 0x28, 0x32, 0xBE, 0xD7,
  0x28, 0x94, 0xCF, 0xBD, 0xF6, 0x3F, 0xB0, 0x1F, 0xC5, 0xD8, 0x91, 0xE5, 0xFD, 0x99, 0x99, 0x3F,
  0xC5, 0x89, 0x3C, 0xFC, 0xAC, 0x80, 0x1A, 0xEE, 0xC4,
  // "Ĝ" (U+011C)
  0x48, 0x17, 0x72, 0x58, 0x27, 0xFE, 0xC4, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x78, 0x95, 0x29, 0xDF,
  0xDA, 0x10, 0x2E, 0xFD, 0xAB, 0xD2, 0x81, 0xBF, 0xA5, 0x01, 0xA0, 0x25, 0x83, 0x3F, 0xE0, 0x3B,
  0x89, 0x16, 0x3F, 0xE0, 0x29, 0xDF, 0x61, 0xA0, 0x12, 0x85, 0xAF, 0x60, 0xDF, 0x82, 0x83, 0xAF,
  0x60, 0x4A, 0x83, 0xCA, 0xEF, 0x62, 0x85, 0x4B, 0xEF, 0xDA, 0x30,
  // "ĝ" (U+011D)
  0x38, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x73, 0x89, 0x23, 0xDE, 0x8A,
  0xF2, 0x0D, 0xFB, 0xDA, 0x84, 0x23, 0xFD, 0x01, 0xA8, 0x22, 0x5F, 0xA2, 0x84, 0xDF, 0x25, 0xFA,
  0x28, 0x4D, 0xF2, 0x3F, 0xD2, 0xA8, 0x42, 0x0D, 0xFB, 0xCA, 0x87, 0x20, 0x4D, 0xE7, 0xDF, 0x15,
  0x0E, 0x92, 0x84, 0xEB, 0xAD, 0xF9, 0x28, 0x3A, 0xEF, 0xD8, 0x20,
  // "Ğ" (U+011E)
  0x20, 0x20, 0x62, 0x07, 0x02, 0x38, 0x43, 0xFB, 0xBF, 0x24, 0x82, 0x7E, 0xD6, 0x77, 0x71, 0x89,
  0x52, 0x9D, 0xFD, 0xA1, 0x02, 0xEF, 0xDA, 0xBD, 0x28, 0x1B, 0xFA, 0x50, 0x1A, 0x02, 0x58, 0x33,
  0xFE, 0x03, 0xB8, 0x91, 0x63, 0xFE, 0x02, 0x9D, 0xF6, 0x1A, 0x01, 0x28, 0x5A, 0xF6, 0x0D, 0xF8,
  0x28, 0x3A, 0xF6, 0x04, 0xA8, 0x3C, 0xAE, 0xF6, 0x28, 0x54, 0xBE, 0xFD, 0xA3,
  // "ğ" (U+011F)
  0x10, 0x20, 0x62, 0x07, 0x02, 0x28, 0x43, 0xFB, 0xBF, 0x23, 0x82, 0x7E, 0xD6, 0x74, 0x89, 0x23,
  0xDE, 0x8A, 0xF2, 0x0D, 0xFB, 0xDA, 0x84, 0x23, 0xFD, 0x01, 0xA8, 0x22, 0x5F, 0xA2, 0x84, 0xDF,
  0x25, 0xFA, 0x28, 0x4D, 0xF2, 0x3F, 0xD2, 0xA8, 0x42, 0x0D, 0xFB, 0xCA, 0x87, 0x20, 0x4D, 0xE7,
  0xDF, 0x15, 0x0E, 0x92, 0x84, 0xEB, 0xAD, 0xF9, 0x28, 0x3A, 0xEF, 0xD8, 0x20,
  // "Ġ" (U+0120)
  0x48, 0x11, 0x85, 0x68, 0x14, 0xE9, 0x77, 0x71, 0x89, 0x52, 0x9D, 0xFD, 0xA1, 0x02, 0xEF, 0xDA,
  0xBD, 0x28, 0x1B, 0xFA, 0x50, 0x1A, 0x02, 0x58, 0x33, 0xFE, 0x03, 0xB8, 0x91, 0x63, 0xFE, 0x02,
  0x9D, 0xF6, 0x1A, 0x01, 0x28, 0x5A, 0xF6, 0x0D, 0xF8, 0x28, 0x3A, 0xF6, 0x04, 0xA8, 0x3C, 0xAE,
  0xF6, 0x28, 0x54, 0xBE, 0xFD, 0xA3,
  // "ġ" (U+0121)
  0x38, 0x11, 0x85, 0x58, 0x14, 0xE9, 0x74, 0x89, 0x23, 0xDE, 0x8A, 0xF2, 0x0D, 0xFB, 0xDA, 0x84,
  0x23, 0xFD, 0x01, 0xA8, 0x22, 0x5F, 0xA2, 0x84, 0xDF, 0x25, 0xFA, 0x28, 0x4D, 0xF2, 0x3F, 0xD2,
  0xA8, 0x42, 0x0D, 0xFB, 0xCA, 0x87, 0x20, 0x4D, 0xE7, 0xDF, 0x15, 0x0E, 0x92, 0x84, 0xEB, 0xAD,
  0xF9, 0x28, 0x3A, 0xEF, 0xD8, 0x20,
  // "Ģ" (U+0122)
  0x28, 0x95, 0x29, 0xDF, 0xDA, 0x10, 0x2E, 0xFD, 0xAB, 0xD2, 0x81, 0xBF, 0xA5, 0x01, 0xA0, 0x25,
  0x83, 0x3F, 0xE0, 0x3B, 0x89, 0x16, 0x3F, 0xE0, 0x29, 0xDF, 0x61, 0xA0, 0x12, 0x85, 0xAF, 0x60,
  0xDF, 0x82, 0x83, 0xAF, 0x60, 0x4A, 0x83, 0xCA, 0xEF, 0x62, 0x85, 0x4B, 0xEF, 0xDA, 0x34, 0x81,
  0x12, 0x16, 0x81, 0x9F, 0x36, 0x0C, 0x0A, 0x30,
  // "ģ" (U+0123)
  0x38, 0x13, 0xF4, 0x58, 0x1B, 0xF1, 0x50, 0x02, 0x48, 0x92, 0x3D, 0xE8, 0xAF, 0x20, 0xDF, 0xBD,
  0xA8, 0x42, 0x3F, 0xD0, 0x1A, 0x82, 0x25, 0xFA, 0x28, 0x4D, 0xF2, 0x5F, 0xA2, 0x84, 0xDF, 0x23,
  0xFD, 0x2A, 0x84, 0x20, 0xDF, 0xBC, 0xA8, 0x72, 0x04, 0xDE, 0x7D, 0xF1, 0x50, 0xE9, 0x28, 0x4E,
  0xBA, 0xDF, 0x92, 0x83, 0xAE, 0xFD, 0x82,
  // "Ĥ" (U+0124)
  0x38, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x38, 0x1E, 0xF2, 0x28,
  0x4A, 0xF6, 0xEF, 0x22, 0x84, 0xAF, 0x6E, 0xF2, 0x28, 0x4A, 0xF6, 0xEF, 0x22, 0x82, 0xAF, 0x6E,
  0xE8, 0x92, 0x6E, 0xFA, 0x99, 0xDF, 0x6E, 0xF2, 0x28, 0x4A, 0xF6, 0xEF, 0x22, 0x84, 0xAF, 0x6E,
  0xF2, 0x28, 0x4A, 0xF6, 0xEF, 0x22, 0x81, 0xAF, 0x60,
  // "ĥ" (U+0125)
  0x28, 0x17, 0x72, 0x58, 0x27, 0xFE, 0xC4, 0x84, 0x2F, 0x62, 0xE7, 0x76, 0x01, 0xA6, 0x01, 0xA6,
  0x81, 0x1F, 0xE6, 0x85, 0x1F, 0xE7, 0xED, 0x52, 0x01, 0xA0, 0xD0, 0xBA, 0x81, 0x10, 0x1A, 0x85,
  0x30, 0xDF, 0x40, 0x1A, 0x28, 0x3B, 0xF4, 0x01, 0xA2, 0x83, 0xBF, 0x40, 0x1A, 0x28, 0x3B, 0xF4,
  0x01, 0xA2, 0x83, 0xBF, 0x40, 0x1A, 0x28, 0x1B, 0xF4,
  // "Ħ" (U+0126)
  0x18, 0x1E, 0xF2, 0x28, 0x1A, 0xF7, 0x1F, 0xA0, 0x80, 0x9A, 0x89, 0x1A, 0x99, 0xDF, 0xC5, 0x0E,
  0xF2, 0x28, 0x1A, 0xF7, 0x20, 0xEE, 0x07, 0x28, 0x6E, 0xFA, 0x99, 0xDF, 0x72, 0x81, 0xEF, 0x22,
  0x81, 0xAF, 0x72, 0x81, 0xEF, 0x22, 0x81, 0xAF, 0x72, 0x81, 0xEF, 0x22, 0x81, 0xAF, 0x72, 0x81,
  0xEF, 0x22, 0x81, 0xAF, 0x71,
  // "ħ" (U+0127)
  0x01, 0xA5, 0xC0, 0xA3, 0x0A, 0xA0, 0x90, 0x63, 0x87, 0x1F, 0xE7, 0xED, 0x50, 0x1A, 0x0D, 0x0B,
  0xA0, 0x01, 0xA8, 0x43, 0x0D, 0xF3, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28,
  0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x1B, 0xF4,
  // "Ĩ" (U+0128)
  0x18, 0x6B, 0xE8, 0x9C, 0x4F, 0xBA, 0x84, 0x71, 0x30, 0x13, 0x71, 0x08, 0xB8, 0x5B, 0x02, 0xBF,
  0xC3, 0x28, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9,
  0x38, 0x17, 0xF9, 0x28, 0x51, 0xAF, 0xC2, 0x08, 0xB0, 0xB0,
  // "ĩ" (U+0129)
  0x18, 0x6B, 0xE8, 0x9C, 0x4F, 0xBA, 0x84, 0x71, 0x30, 0x13, 0x20, 0x1A, 0x30, 0x1A, 0x30, 0x1A,
  0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x20,
  // "Ī" (U+012A)
  0x84, 0x39, 0x99, 0x96, 0xC7, 0x30, 0x8B, 0x89, 0x0B, 0x2B, 0xFC, 0x30, 0x7F, 0x92, 0x81, 0x7F,
  0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x89, 0x07, 0xF9, 0x01, 0xAF, 0xC2,
  0x8B, 0x0B,
  // "ī" (U+012B)
  0x84, 0x39, 0x99, 0x96, 0xC6, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01, 0xA2, 0x01,
  0xA2, 0x01, 0xA2, 0x01, 0xA1,
  // "Ĭ" (U+012C)
  0x02, 0x06, 0x28, 0x93, 0x72, 0x3F, 0xBB, 0xF2, 0x07, 0xED, 0x67, 0x60, 0x8B, 0x85, 0xB0, 0x2B,
  0xFC, 0x32, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x93, 0x81, 0x7F,
  0x93, 0x81, 0x7F, 0x92, 0x85, 0x1A, 0xFC, 0x20, 0x8B, 0x0B, 0x10,
  // "ĭ" (U+012D)
  0x02, 0x06, 0x28, 0x93, 0x72, 0x3F, 0xBB, 0xF2, 0x07, 0xED, 0x67, 0x10, 0x1A, 0x30, 0x1A, 0x30,
  0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x20,
  // "Į" (U+012E)
  0x08, 0xB8, 0x90, 0xB2, 0xBF, 0xC3, 0x07, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17,
  0xF9, 0x28, 0x17, 0xF9, 0x28, 0x90, 0x7F, 0x90, 0x1A, 0xFC, 0x28, 0xB8, 0x3B, 0x03, 0xF3, 0x28,
  0x75, 0xFB, 0x40, 0x1C, 0xF4,
  // "į" (U+012F)
  0x81, 0x1D, 0xD2, 0x00, 0x75, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01,
  0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x89, 0x23, 0xF3, 0x05, 0xFB, 0x41, 0xCF, 0x40,
  // "İ" (U+0130)
  0x18, 0x11, 0x85, 0x28, 0x14, 0xE9, 0x74, 0x08, 0xB8, 0x90, 0xB2, 0xBF, 0xC3, 0x07, 0xF9, 0x28,
  0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x90, 0x7F, 0x90, 0x1A,
  0xFC, 0x28, 0xB0, 0xB0,
  // "ı" (U+0131)
  0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x1A,
  // "Ĳ" (U+0132)
  0x08, 0xB8, 0xA0, 0xB0, 0xEF, 0x22, 0xBF, 0xC3, 0x0E, 0xF2, 0x07, 0xF9, 0x28, 0x5E, 0xF2, 0x07,
  0xF9, 0x28, 0x5E, 0xF2, 0x07, 0xF9, 0x28, 0x5E, 0xF2, 0x07, 0xF9, 0x28, 0x5E, 0xF2, 0x07, 0xF9,
  0x28, 0x5E, 0xF2, 0x07, 0xF9, 0x28, 0x93, 0xEF, 0x21, 0xAF, 0xC2, 0x0E, 0xF2, 0x8B, 0x83, 0xB0,
  0xEF, 0x25, 0x01, 0xA0, 0x14, 0x82, 0xBD, 0xFC, 0x58, 0x2D, 0xFC, 0x21,
  // "ĳ" (U+0133)
  0x89, 0x01, 0xDD, 0x01, 0xDD, 0x07, 0x72, 0x00, 0x77, 0x01, 0xA1, 0x01, 0xA0, 0x1A, 0x10, 0x1A,
  0x01, 0xA1, 0x01, 0xA0, 0x1A, 0x10, 0x1A, 0x01, 0xA1, 0x01, 0xA0, 0x1A, 0x10, 0x1A, 0x01, 0xA1,
  0x01, 0xA0, 0x1A, 0x10, 0x1A, 0x40, 0x1A, 0x38, 0x26, 0xCF, 0xC3, 0x82, 0x8F, 0xC3,
  // "Ĵ" (U+0134)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x77, 0x78, 0x1E, 0xF2, 0x38, 0x1E,
  0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2,
  0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x20, 0x1A, 0x84, 0x10, 0xBD, 0xFC, 0x28,
  0x2D, 0xFC, 0x22,
  // "ĵ" (U+0135)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x77, 0x01, 0xA3, 0x01, 0xA3, 0x01,
  0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x81, 0x1F, 0xE2, 0x82, 0x6C,
  0xFC, 0x28, 0x28, 0xFC, 0x32,
  // "Ķ" (U+0136)
  0x8A, 0x4E, 0xF2, 0x03, 0xFE, 0x1E, 0xF2, 0x0D, 0xF6, 0x0E, 0xF2, 0x8F, 0xB2, 0x84, 0xEF, 0x6F,
  0xE1, 0x28, 0x3E, 0xFE, 0xF9, 0x30, 0xEB, 0x0E, 0x01, 0x28, 0x4E, 0xF5, 0xBF, 0x82, 0x82, 0xEF,
  0x23, 0xA8, 0x95, 0x10, 0xEF, 0x20, 0xBF, 0x90, 0xEF, 0x20, 0x3A, 0x02, 0x28, 0x11, 0x21, 0x58,
  0x19, 0xF3, 0x50, 0xC0, 0xA4,
  // "ķ" (U+0137)
  0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA5, 0x01, 0xA2, 0x82, 0xDF, 0x41, 0xA1, 0x89, 0x09, 0xF8, 0x01,
  0xFE, 0x5F, 0xC2, 0x84, 0x1F, 0xEE, 0xF5, 0x20, 0x1A, 0x81, 0xEF, 0xC2, 0x01, 0xA8, 0x41, 0xCF,
  0x50, 0x1A, 0x18, 0x34, 0xFD, 0x01, 0xA2, 0x81, 0xBF, 0x73, 0x81, 0x12, 0x15, 0x81, 0x9F, 0x35,
  0x0C, 0x0A, 0x30,
  // "ĸ" (U+0138)
  0x01, 0xA2, 0x82, 0xDF, 0x41, 0xA1, 0x89, 0x09, 0xF8, 0x01, 0xFE, 0x4F, 0xC2, 0x84, 0x1F, 0xED,
  0xF5, 0x20, 0x1A, 0x81, 0xEF, 0xC2, 0x01, 0xA8, 0x42, 0xCF, 0x50, 0x1A, 0x18, 0x34, 0xFD, 0x01,
  0xA2, 0x81, 0xBF, 0x70,
  // "Ĺ" (U+0139)
  0x20, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x77, 0x58, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48,
  0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E,
  0xF2, 0x48, 0x6E, 0xFC, 0xBB, 0x50, 0xEC, 0x07,
  // "ĺ" (U+013A)
  0x28, 0x72, 0x20, 0x6F, 0xB2, 0xF9, 0x50, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  // "Ļ" (U+013B)
  0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81,
  0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x85, 0xEF, 0xCB, 0xB5, 0xEC, 0x83, 0x70, 0x12,
  0x13, 0x81, 0x9F, 0x33, 0x0C, 0x0A, 0x30,
  // "ļ" (U+013C)
  0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA1,
  0x01, 0xA1, 0x01, 0xA1, 0x01, 0xA2, 0x89, 0x01, 0x21, 0x09, 0xF3, 0x0C, 0xA1,
  // "Ľ" (U+013D)
  0x8A, 0x6E, 0xF2, 0x09, 0xF4, 0xEF, 0x20, 0xBC, 0x0E, 0xF2, 0x02, 0x10, 0xEF, 0x24, 0x81, 0xEF,
  0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x86, 0xEF, 0xCB, 0xB5, 0x0E, 0xC0,
  0x71,
  // "ľ" (U+013E)
  0x01, 0xA8, 0x29, 0xF4, 0x1A, 0x82, 0xBC, 0x01, 0xA8, 0x22, 0x10, 0x1A, 0x30, 0x1A, 0x30, 0x1A,
  0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30,
  // "Ŀ" (U+013F)
  0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x89, 0x5E, 0xF2, 0x18, 0x5E, 0xF2, 0x4E,
  0x9E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x5E, 0xFC, 0xBB, 0x5E, 0xC0, 0x70,
  // "ŀ" (U+0140)
  0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA8, 0x21, 0x85, 0x1A, 0x82,
  0x4E, 0x91, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3,
  // "Ł" (U+0141)
  0x18, 0x1B, 0xF5, 0x48, 0x1B, 0xF5, 0x48, 0x2B, 0xF5, 0x13, 0x83, 0xBF, 0xDF, 0x22, 0x0B, 0xA0,
  0x72, 0x0A, 0xA0, 0x63, 0x82, 0x8E, 0xF5, 0x48, 0x1B, 0xF5, 0x48, 0x6B, 0xFD, 0xBB, 0x70, 0xBC,
  0x0A,
  // "ł" (U+0142)
  0x28, 0x1C, 0xF3, 0x38, 0x1C, 0xF3, 0x38, 0x1C, 0xF3, 0x38, 0x1C, 0xF4, 0x30, 0xCA, 0x87, 0x50,
  0x1E, 0xFC, 0x21, 0xEA, 0x03, 0x28, 0x27, 0xDF, 0x33, 0x81, 0xCF, 0x33, 0x81, 0xCF, 0x33, 0x81,
  0xCF, 0x31,
  // "Ń" (U+0143)
  0x40, 0x02, 0x68, 0x16, 0xFB, 0x58, 0x12, 0xF9, 0x77, 0x71, 0x81, 0xEF, 0xD3, 0x82, 0xDF, 0x1E,
  0xA0, 0x52, 0x82, 0xDF, 0x1E, 0xA0, 0xD2, 0x8C, 0x6D, 0xF1, 0xEE, 0xBF, 0x60, 0xDF, 0x1E, 0xF3,
  0xFD, 0x0D, 0xF1, 0xEF, 0x0B, 0xF6, 0xCF, 0x1E, 0xF0, 0x3F, 0xDC, 0xF1, 0xE9, 0x20, 0xAB, 0x01,
  0x0E, 0x92, 0x03, 0xB0, 0x10, 0xE9, 0x30, 0xAA, 0x01,
  // "ń" (U+0144)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x74, 0x87, 0x1F, 0x98, 0xED, 0x50, 0x1A, 0x0D,
  0x0B, 0xA0, 0x01, 0xA8, 0x43, 0x0D, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A,
  0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x1B, 0xF4,
  // "Ņ" (U+0145)
  0x81, 0xEF, 0xD3, 0x82, 0xDF, 0x1E, 0xA0, 0x52, 0x82, 0xDF, 0x1E, 0xA0, 0xD2, 0x8C, 0x6D, 0xF1,
  0xEE, 0xBF, 0x60, 0xDF, 0x1E, 0xF3, 0xFD, 0x0D, 0xF1, 0xEF, 0x0B, 0xF6, 0xCF, 0x1E, 0xF0, 0x3F,
  0xDC, 0xF1, 0xE9, 0x20, 0xAB, 0x01, 0x0E, 0x92, 0x03, 0xB0, 0x10, 0xE9, 0x30, 0xAA, 0x01, 0x38,
  0x11, 0x21, 0x68, 0x19, 0xF3, 0x60, 0xC0, 0xA4,
  // "ņ" (U+0146)
  0x87, 0x1F, 0x98, 0xED, 0x50, 0x1A, 0x0D, 0x0B, 0xA0, 0x01, 0xA8, 0x43, 0x0D, 0xF4, 0x1A, 0x28,
  0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28,
  0x1B, 0xF4, 0x38, 0x11, 0x21, 0x58, 0x19, 0xF3, 0x50, 0xC0, 0xA3,
  // "Ň" (U+0147)
  0x18, 0x42, 0x71, 0x06, 0x54, 0x83, 0xCC, 0x9F, 0x34, 0x02, 0xA0, 0x77, 0x77, 0x81, 0xEF, 0xD3,
  0x82, 0xDF, 0x1E, 0xA0, 0x52, 0x82, 0xDF, 0x1E, 0xA0, 0xD2, 0x8C, 0x6D, 0xF1, 0xEE, 0xBF, 0x60,
  0xDF, 0x1E, 0xF3, 0xFD, 0x0D, 0xF1, 0xEF, 0x0B, 0xF6, 0xCF, 0x1E, 0xF0, 0x3F, 0xDC, 0xF1, 0xE9,
  0x20, 0xAB, 0x01, 0x0E, 0x92, 0x03, 0xB0, 0x10, 0xE9, 0x30, 0xAA, 0x01,
  // "ň" (U+0148)
  0x18, 0x42, 0x71, 0x06, 0x53, 0x83, 0xCC, 0x9F, 0x33, 0x02, 0xA0, 0x77, 0x38, 0x71, 0xF9, 0x8E,
  0xD5, 0x01, 0xA0, 0xD0, 0xBA, 0x00, 0x1A, 0x84, 0x30, 0xDF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2,
  0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x81, 0xBF, 0x40,
  // "ŉ" (U+0149)
  0x1A, 0x78, 0x12, 0xFC, 0x78, 0x93, 0x4F, 0x8F, 0x98, 0xED, 0x50, 0x7F, 0x3A, 0x0D, 0x0B, 0xA0,
  0x12, 0x01, 0xA8, 0x33, 0x0D, 0xF4, 0x20, 0x1A, 0x28, 0x1B, 0xF4, 0x20, 0x1A, 0x28, 0x1B, 0xF4,
  0x20, 0x1A, 0x28, 0x1B, 0xF4, 0x20, 0x1A, 0x28, 0x1B, 0xF4, 0x20, 0x1A, 0x28, 0x1B, 0xF4,
  // "Ŋ" (U+014A)
  0x81, 0xEF, 0xD3, 0x82, 0xDF, 0x1E, 0xA0, 0x72, 0x82, 0xDF, 0x1E, 0xA8, 0xC0, 0xE1, 0x0D, 0xF1,
  0xEE, 0x9F, 0x90, 0xDF, 0x1E, 0xF1, 0xEF, 0x3D, 0xF1, 0xEF, 0x06, 0xFC, 0xCF, 0x1E, 0x92, 0x0C,
  0xB0, 0x10, 0xE9, 0x20, 0x4B, 0x01, 0x0E, 0x93, 0x0A, 0xA0, 0x10, 0xE9, 0x30, 0x1A, 0x01, 0x60,
  0xE9, 0x58, 0x2B, 0xCF, 0xC5, 0x82, 0xDE, 0xB2, 0x10,
  // "ŋ" (U+014B)
  0x87, 0x1F, 0xA7, 0xED, 0x50, 0x1A, 0x0D, 0x0B, 0xA0, 0x01, 0xA8, 0x43, 0x0C, 0xF4, 0x1A, 0x28,
  0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28, 0x2B, 0xF4, 0x1A, 0x28,
  0x1B, 0xF4, 0x58, 0x1B, 0xF4, 0x30, 0x10, 0xAA, 0x01, 0x38, 0x22, 0xEE, 0x71,
  // "Ō" (U+014C)
  0x20, 0x38, 0x00, 0x94, 0x06, 0xC7, 0x77, 0x18, 0x45, 0xCE, 0xEB, 0x32, 0x05, 0xA8, 0x7B, 0xCF,
  0xE2, 0x0D, 0xF7, 0x28, 0x2A, 0xFA, 0x2A, 0x01, 0x28, 0x44, 0xFE, 0x3F, 0xE3, 0x02, 0xA8, 0x13,
  0xFE, 0x30, 0x2A, 0x01, 0xA0, 0x12, 0x85, 0x4F, 0xE0, 0xDF, 0x72, 0x83, 0xAF, 0xA0, 0x4A, 0x83,
  0xBC, 0xFE, 0x22, 0x84, 0x4C, 0xEE, 0xB3, 0x10,
  // "ō" (U+014D)
  0x10, 0x38, 0x00, 0x93, 0x06, 0xC7, 0x48, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xCF, 0xCC, 0xFA, 0x03,
  0xFD, 0x28, 0x4E, 0xF1, 0x5F, 0xA2, 0x84, 0xCF, 0x45, 0xFA, 0x28, 0x4C, 0xF4, 0x3F, 0xD2, 0x89,
  0x0E, 0xF1, 0x0B, 0xFC, 0xCF, 0xA2, 0x83, 0x1A, 0xEE, 0x92,
  // "Ŏ" (U+014E)
  0x20, 0x20, 0x62, 0x07, 0x02, 0x38, 0x43, 0xFB, 0xBF, 0x24, 0x82, 0x7E, 0xD6, 0x77, 0x71, 0x84,
  0x5C, 0xEE, 0xB3, 0x20, 0x5A, 0x87, 0xBC, 0xFE, 0x20, 0xDF, 0x72, 0x82, 0xAF, 0xA2, 0xA0, 0x12,
  0x84, 0x4F, 0xE3, 0xFE, 0x30, 0x2A, 0x81, 0x3F, 0xE3, 0x02, 0xA0, 0x1A, 0x01, 0x28, 0x54, 0xFE,
  0x0D, 0xF7, 0x28, 0x3A, 0xFA, 0x04, 0xA8, 0x3B, 0xCF, 0xE2, 0x28, 0x44, 0xCE, 0xEB, 0x31,
  // "ŏ" (U+014F)
  0x10, 0x20, 0x62, 0x07, 0x02, 0x28, 0x43, 0xFB, 0xBF, 0x23, 0x82, 0x7E, 0xD6, 0x74, 0x83, 0x1A,
  0xEE, 0x93, 0x89, 0x0C, 0xFC, 0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4,
  0x5F, 0xA2, 0x84, 0xCF, 0x43, 0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE,
  0xE9, 0x20,
  // "Ő" (U+0150)
  0x48, 0x22, 0x11, 0x24, 0x83, 0x8F, 0x5E, 0xC3, 0x84, 0x3E, 0x49, 0xC1, 0x77, 0x78, 0x45, 0xCE,
  0xEB, 0x32, 0x05, 0xA8, 0x7B, 0xCF, 0xE2, 0x0D, 0xF7, 0x28, 0x2A, 0xFA, 0x2A, 0x01, 0x28, 0x44,
  0xFE, 0x3F, 0xE3, 0x02, 0xA8, 0x13, 0xFE, 0x30, 0x2A, 0x01, 0xA0, 0x12, 0x85, 0x4F, 0xE0, 0xDF,
  0x72, 0x83, 0xAF, 0xA0, 0x4A, 0x83, 0xBC, 0xFE, 0x22, 0x84, 0x4C, 0xEE, 0xB3, 0x10,
  // "ő" (U+0151)
  0x38, 0x22, 0x11, 0x23, 0x83, 0x8F, 0x5E, 0xC2, 0x84, 0x3E, 0x49, 0xC1, 0x73, 0x83, 0x1A, 0xEE,
  0x93, 0x89, 0x0C, 0xFC, 0xCF, 0xA0, 0x3F, 0xD2, 0x84, 0xEF, 0x15, 0xFA, 0x28, 0x4C, 0xF4, 0x5F,
  0xA2, 0x84, 0xCF, 0x43, 0xFD, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0xCC, 0xFA, 0x28, 0x31, 0xAE, 0xE9,
  0x20,
  // "Œ" (U+0152)
  0x28, 0x14, 0xCE, 0xE8, 0x11, 0x05, 0xA0, 0x0B, 0xA0, 0xF9, 0x87, 0x10, 0xDF, 0x70, 0x2F, 0xE4,
  0x02, 0xA8, 0x31, 0x02, 0xFE, 0x48, 0x13, 0xFE, 0x20, 0x2C, 0x83, 0xE0, 0x3F, 0xE2, 0x02, 0xA8,
  0x39, 0x98, 0x01, 0xA8, 0x31, 0x02, 0xFE, 0x58, 0x5D, 0xF7, 0x02, 0xFE, 0x50, 0x5A, 0x0B, 0x0A,
  0xA0, 0xF9, 0x01, 0x28, 0x15, 0xCE, 0xE0, 0x10,
  // "œ" (U+0153)
  0x18, 0x90, 0x1A, 0xEE, 0x83, 0xCE, 0xC4, 0x28, 0x2C, 0xFC, 0xCA, 0x86, 0xEA, 0xEF, 0x13, 0xFD,
  0x28, 0x90, 0xEF, 0x50, 0x6F, 0x75, 0xFA, 0x20, 0xCD, 0x82, 0x95, 0xFA, 0x28, 0x90, 0xCF, 0xB9,
  0x99, 0x53, 0xFD, 0x28, 0x1E, 0xF7, 0x58, 0x2C, 0xFC, 0xCB, 0x89, 0x6A, 0xAD, 0x30, 0x1A, 0xEE,
  0x82, 0xBF, 0xEA, 0x10,
  // "Ŕ" (U+0154)
  0x40, 0x02, 0x58, 0x16, 0xFB, 0x48, 0x12, 0xF9, 0x77, 0x50, 0xEA, 0x81, 0xEB, 0x42, 0x82, 0xEF,
  0xAB, 0xA8, 0xB1, 0x20, 0xEF, 0x20, 0xBF, 0x60, 0xEF, 0x20, 0xCF, 0x60, 0xEF, 0xAC, 0xFD, 0x10,
  0xEB, 0x0E, 0x01, 0x28, 0x4E, 0xF2, 0xBF, 0x52, 0x84, 0xEF, 0x24, 0xFD, 0x28, 0x96, 0xEF, 0x20,
  0xBF, 0x70, 0xEF, 0x20, 0x4F, 0xE1,
  // "ŕ" (U+0155)
  0x30, 0x02, 0x38, 0x16, 0xFB, 0x28, 0x12, 0xF9, 0x71, 0x85, 0x1F, 0x96, 0xE6, 0x1A, 0x82, 0xEA,
  0x41, 0xA0, 0x42, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3,
  // "Ŗ" (U+0156)
  0x0E, 0xA8, 0x1E, 0xB4, 0x28, 0x2E, 0xFA, 0xBA, 0x8B, 0x12, 0x0E, 0xF2, 0x0B, 0xF6, 0x0E, 0xF2,
  0x0C, 0xF6, 0x0E, 0xFA, 0xCF, 0xD1, 0x0E, 0xB0, 0xE0, 0x12, 0x84, 0xEF, 0x2B, 0xF5, 0x28, 0x4E,
  0xF2, 0x4F, 0xD2, 0x89, 0x6E, 0xF2, 0x0B, 0xF7, 0x0E, 0xF2, 0x04, 0xFE, 0x12, 0x81, 0x12, 0x15,
  0x81, 0x9F, 0x35, 0x0C, 0x0A, 0x40,
  // "ŗ" (U+0157)
  0x85, 0x1F, 0x96, 0xE6, 0x1A, 0x82, 0xEA, 0x41, 0xA0, 0x42, 0x01, 0xA3, 0x01, 0xA3, 0x01, 0xA3,
  0x01, 0xA3, 0x01, 0xA4, 0x81, 0x12, 0x13, 0x81, 0x9F, 0x33, 0x0C, 0x0A, 0x30,
  // "Ř" (U+0158)
  0x84, 0x27, 0x10, 0x65, 0x38, 0x3C, 0xC9, 0xF3, 0x30, 0x2A, 0x07, 0x77, 0x50, 0xEA, 0x81, 0xEB,
  0x42, 0x82, 0xEF, 0xAB, 0xA8, 0xB1, 0x20, 0xEF, 0x20, 0xBF, 0x60, 0xEF, 0x20, 0xCF, 0x60, 0xEF,
  0xAC, 0xFD, 0x10, 0xEB, 0x0E, 0x01, 0x28, 0x4E, 0xF2, 0xBF, 0x52, 0x84, 0xEF, 0x24, 0xFD, 0x28,
  0x96, 0xEF, 0x20, 0xBF, 0x70, 0xEF, 0x20, 0x4F, 0xE1,
  // "ř" (U+0159)
  0x89, 0x42, 0x71, 0x06, 0x50, 0xCC, 0x9F, 0x30, 0x2A, 0x07, 0x78, 0x51, 0xF9, 0x6E, 0x61, 0xA8,
  0x2E, 0xA4, 0x1A, 0x04, 0x20, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30,
  // "Ś" (U+015A)
  0x40, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x77, 0x38, 0x96, 0x3B, 0xEE, 0xB3, 0x1E, 0xFB,
  0xBF, 0x34, 0xFC, 0x28, 0x11, 0x04, 0xA0, 0x44, 0x0B, 0xA0, 0xB0, 0x23, 0x83, 0x7E, 0xFE, 0x13,
  0x83, 0x1D, 0xF7, 0x13, 0x85, 0x9F, 0x87, 0xEB, 0xAA, 0x85, 0x23, 0xCE, 0xFC, 0x41,
  // "ś" (U+015B)
  0x30, 0x02, 0x38, 0x16, 0xFB, 0x28, 0x12, 0xF9, 0x72, 0x89, 0x48, 0xEE, 0xC4, 0x5F, 0xEA, 0xE4,
  0x6F, 0xA3, 0x83, 0x1E, 0xFD, 0x42, 0x01, 0x09, 0xA0, 0x53, 0x89, 0x47, 0xFA, 0x7D, 0xAD, 0xF8,
  0x4D, 0xFE, 0x91,
  // "Ŝ" (U+015C)
  0x38, 0x17, 0x72, 0x38, 0x27, 0xFE, 0xC2, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x18, 0x96, 0x3B, 0xEE,
  0xB3, 0x1E, 0xFB, 0xBF, 0x34, 0xFC, 0x28, 0x11, 0x04, 0xA0, 0x44, 0x0B, 0xA0, 0xB0, 0x23, 0x83,
  0x7E, 0xFE, 0x13, 0x83, 0x1D, 0xF7, 0x13, 0x85, 0x9F, 0x87, 0xEB, 0xAA, 0x85, 0x23, 0xCE, 0xFC,
  0x41,
  // "ŝ" (U+015D)
  0x28, 0x17, 0x72, 0x28, 0x91, 0x7F, 0xEC, 0x02, 0xF6, 0x2E, 0x77, 0x89, 0x48, 0xEE, 0xC4, 0x5F,
  0xEA, 0xE4, 0x6F, 0xA3, 0x83, 0x1E, 0xFD, 0x42, 0x01, 0x09, 0xA0, 0x53, 0x89, 0x47, 0xFA, 0x7D,
  0xAD, 0xF8, 0x4D, 0xFE, 0x91,
  // "Ş" (U+015E)
  0x18, 0x96, 0x3B, 0xEE, 0xB3, 0x1E, 0xFB, 0xBF, 0x34, 0xFC, 0x28, 0x11, 0x04, 0xA0, 0x44, 0x0B,
  0xA0, 0xB0, 0x23, 0x83, 0x7E, 0xFE, 0x13, 0x83, 0x1D, 0xF7, 0x13, 0x85, 0x9F, 0x87, 0xEB, 0xAA,
  0x81, 0x23, 0xCA, 0x0C, 0x04, 0x38, 0x1A, 0xD3, 0x50, 0xD0, 0xB3, 0x82, 0x3E, 0xF6, 0x40, 0x14,
  // "ş" (U+015F)
  0x18, 0x94, 0x8E, 0xEC, 0x45, 0xFE, 0xAE, 0x46, 0xFA, 0x38, 0x31, 0xEF, 0xD4, 0x20, 0x10, 0x9A,
  0x05, 0x38, 0x91, 0x7F, 0xA7, 0xDA, 0xDF, 0x84, 0xDA, 0x09, 0x38, 0x1A, 0xD3, 0x40, 0xD0, 0xB2,
  0x82, 0x3E, 0xF6, 0x30, 0x13,
  // "Š" (U+0160)
  0x18, 0x42, 0x71, 0x06, 0x52, 0x83, 0xCC, 0x9F, 0x32, 0x02, 0xA0, 0x77, 0x72, 0x89, 0x63, 0xBE,
  0xEB, 0x31, 0xEF, 0xBB, 0xF3, 0x4F, 0xC2, 0x81, 0x10, 0x4A, 0x04, 0x40, 0xBA, 0x0B, 0x02, 0x38,
  0x37, 0xEF, 0xE1, 0x38, 0x31, 0xDF, 0x71, 0x38, 0x59, 0xF8, 0x7E, 0xBA, 0xA8, 0x52, 0x3C, 0xEF,
  0xC4, 0x10,
  // "š" (U+0161)
  0x89, 0x42, 0x71, 0x06, 0x50, 0xCC, 0x9F, 0x30, 0x2A, 0x07, 0x71, 0x89, 0x48, 0xEE, 0xC4, 0x5F,
  0xEA, 0xE4, 0x6F, 0xA3, 0x83, 0x1E, 0xFD, 0x42, 0x01, 0x09, 0xA0, 0x53, 0x89, 0x47, 0xFA, 0x7D,
  0xAD, 0xF8, 0x4D, 0xFE, 0x91,
  // "Ţ" (U+0162)
  0x0B, 0xD8, 0x6D, 0x79, 0xCF, 0xD9, 0x82, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94,
  0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0xAF, 0x94, 0x81,
  0xAD, 0x35, 0x0D, 0x0B, 0x38, 0x23, 0xEF, 0x64, 0x01, 0x40,
  // "ţ" (U+0163)
  0x18, 0x12, 0x71, 0x28, 0x48, 0xF2, 0x06, 0xEA, 0x89, 0x0D, 0x7E, 0xFA, 0x80, 0xDF, 0x22, 0x81,
  0xDF, 0x22, 0x81, 0xDF, 0x22, 0x81, 0xDF, 0x22, 0x84, 0xBF, 0xDB, 0x03, 0xA0, 0xC2, 0x81, 0xAD,
  0x33, 0x85, 0xDB, 0x03, 0xEF, 0x62, 0x01, 0x20,
  // "Ť" (U+0164)
  0x84, 0x27, 0x10, 0x65, 0x28, 0x3C, 0xC9, 0xF3, 0x20, 0x2A, 0x07, 0x77, 0x20, 0xBD, 0x86, 0xD7,
  0x9C, 0xFD, 0x98, 0x28, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48,
  0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x20,
  // "ť" (U+0165)
  0x58, 0x90, 0x9F, 0x40, 0x27, 0x10, 0xBC, 0x28, 0x78, 0xF2, 0x02, 0x10, 0x6E, 0xA0, 0xD3, 0x83,
  0x7E, 0xFA, 0x84, 0x81, 0xDF, 0x25, 0x81, 0xDF, 0x25, 0x81, 0xDF, 0x25, 0x81, 0xDF, 0x25, 0x82,
  0xBF, 0xDB, 0x48, 0x23, 0xDF, 0xC3,
  // "Ŧ" (U+0166)
  0x0B, 0xD8, 0x6D, 0x79, 0xCF, 0xD9, 0x82, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x93, 0xD8, 0x51, 0x09,
  0xCF, 0xD9, 0x38, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x48, 0x17, 0xF9, 0x20,
  // "ŧ" (U+0167)
  0x18, 0x12, 0x71, 0x28, 0x48, 0xF2, 0x06, 0xEA, 0x89, 0x2D, 0x7E, 0xFA, 0x80, 0xDF, 0x20, 0xAB,
  0x89, 0x0A, 0x6E, 0xFA, 0x60, 0xDF, 0x22, 0x87, 0xBF, 0xCB, 0x03, 0xDF, 0xC0,
  // "Ũ" (U+0168)
  0x18, 0x3B, 0xE8, 0x9C, 0x28, 0x14, 0xFB, 0xA0, 0x72, 0x83, 0x13, 0x01, 0x37, 0x4A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A,
  0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x6C, 0xF4, 0xDF, 0x60, 0x1A,
  0x02, 0x07, 0xA8, 0x2C, 0xEF, 0xB2, 0x84, 0x7D, 0xED, 0x91, 0x10,
  // "ũ" (U+0169)
  0x28, 0x3B, 0xE8, 0x9C, 0x28, 0x14, 0xFB, 0xA0, 0x72, 0x83, 0x13, 0x01, 0x32, 0x81, 0x1F, 0xE2,
  0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4,
  0x1F, 0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7,
  0xF4,
  // "Ū" (U+016A)
  0x10, 0x38, 0x00, 0x93, 0x06, 0xC7, 0x74, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4,
  0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D, 0xF6, 0x01, 0xA0, 0x20, 0x7A, 0x82, 0xCE, 0xFB, 0x28,
  0x47, 0xDE, 0xD9, 0x11,
  // "ū" (U+016B)
  0x10, 0x38, 0x00, 0x93, 0x06, 0xC7, 0x38, 0x11, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF,
  0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x1C, 0xF4, 0x1A, 0x28,
  0x6E, 0xF4, 0x0C, 0xFB, 0xBA, 0x87, 0x40, 0x3C, 0xEA, 0x7F, 0x40,
  // "Ŭ" (U+016C)
  0x10, 0x20, 0x62, 0x07, 0x02, 0x28, 0x43, 0xFB, 0xBF, 0x23, 0x82, 0x7E, 0xD6, 0x77, 0x4A, 0x02,
  0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF,
  0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x6C, 0xF4, 0xDF, 0x60,
  0x1A, 0x02, 0x07, 0xA8, 0x2C, 0xEF, 0xB2, 0x84, 0x7D, 0xED, 0x91, 0x10,
  // "ŭ" (U+016D)
  0x10, 0x20, 0x62, 0x07, 0x02, 0x28, 0x43, 0xFB, 0xBF, 0x23, 0x82, 0x7E, 0xD6, 0x73, 0x81, 0x1F,
  0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B,
  0xF4, 0x1F, 0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE,
  0xA7, 0xF4,
  // "Ů" (U+016E)
  0x18, 0x21, 0xCE, 0x94, 0x83, 0x5C, 0x2F, 0x13, 0x82, 0x1C, 0xE9, 0x77, 0x5A, 0x02, 0x28, 0x1C,
  0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02,
  0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x6C, 0xF4, 0xDF, 0x60, 0x1A, 0x02,
  0x07, 0xA8, 0x2C, 0xEF, 0xB2, 0x84, 0x7D, 0xED, 0x91, 0x10,
  // "ů" (U+016F)
  0x28, 0x21, 0xCE, 0x94, 0x83, 0x5C, 0x2F, 0x13, 0x82, 0x1C, 0xE9, 0x73, 0x81, 0x1F, 0xE2, 0x84,
  0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F,
  0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7, 0xF4,
  // "Ű" (U+0170)
  0x38, 0x22, 0x11, 0x23, 0x83, 0x8F, 0x5E, 0xC2, 0x84, 0x3E, 0x49, 0xC1, 0x77, 0x3A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A,
  0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x6C, 0xF4, 0xDF, 0x60, 0x1A,
  0x02, 0x07, 0xA8, 0x2C, 0xEF, 0xB2, 0x84, 0x7D, 0xED, 0x91, 0x10,
  // "ű" (U+0171)
  0x38, 0x22, 0x11, 0x23, 0x83, 0x8F, 0x5E, 0xC2, 0x84, 0x3E, 0x49, 0xC1, 0x72, 0x81, 0x1F, 0xE2,
  0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4,
  0x1F, 0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x74, 0x03, 0xCE, 0xA7,
  0xF4,
  // "Ų" (U+0172)
  0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28,
  0x1C, 0xF4, 0xA0, 0x22, 0x81, 0xCF, 0x4A, 0x02, 0x28, 0x1C, 0xF4, 0xA0, 0x22, 0x86, 0xCF, 0x4D,
  0xF6, 0x01, 0xA0, 0x10, 0x7A, 0x82, 0xCE, 0xF7, 0x20, 0x70, 0xDA, 0x08, 0x50, 0x40, 0xD6, 0x81,
  0xAF, 0xA5, 0x81, 0x5E, 0xD2,
  // "ų" (U+0173)
  0x81, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE, 0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x84, 0xBF, 0x41, 0xFE,
  0x28, 0x4B, 0xF4, 0x1F, 0xE2, 0x81, 0xCF, 0x41, 0xA2, 0x86, 0xEF, 0x40, 0xCF, 0xBB, 0xA8, 0x44,
  0x03, 0xCE, 0xAA, 0x04, 0x48, 0x13, 0xF3, 0x58, 0x25, 0xFB, 0x44, 0x82, 0x1C, 0xF4,
  // "Ŵ" (U+0174)
  0x58, 0x17, 0x72, 0x72, 0x82, 0x7F, 0xEC, 0x71, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x77, 0x28, 0x1D,
  0xF2, 0x28, 0x1C, 0xF4, 0x28, 0x4B, 0xF5, 0x9F, 0x62, 0xA0, 0x72, 0x86, 0xEF, 0x16, 0xF9, 0x04,
  0xA8, 0xA0, 0xB0, 0x2F, 0xD0, 0x2F, 0xC0, 0x7F, 0xCE, 0x06, 0xFA, 0x28, 0x91, 0xEF, 0x0B, 0xE7,
  0xF3, 0x9F, 0x62, 0x89, 0x1B, 0xF3, 0xEB, 0x4F, 0x6C, 0xF3, 0x28, 0x90, 0x7F, 0x8F, 0x81, 0xF9,
  0xFE, 0x38, 0x90, 0x4F, 0xDF, 0x40, 0xCD, 0xFB, 0x4B, 0x81, 0x10, 0x9A, 0x08, 0x48, 0x1C, 0xFC,
  0x20, 0x5A, 0x04, 0x20,
  // "ŵ" (U+0175)
  0x48, 0x17, 0x72, 0x78, 0x27, 0xFE, 0xC6, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x89, 0x6C, 0xF3, 0x0B,
  0xFC, 0x03, 0xFC, 0x8F, 0x70, 0xEA, 0x18, 0xC1, 0x6F, 0x84, 0xFA, 0x2F, 0xBF, 0x39, 0xF4, 0x1F,
  0xD6, 0xF5, 0xF6, 0xDF, 0x10, 0xCF, 0x9F, 0x0F, 0x9F, 0xC2, 0x87, 0x9F, 0xDC, 0x0C, 0xDF, 0x92,
  0x05, 0xA8, 0x19, 0x09, 0xA0, 0x52, 0x01, 0xA8, 0x16, 0x06, 0xA0, 0x11,
  // "Ŷ" (U+0176)
  0x38, 0x17, 0x72, 0x48, 0x27, 0xFE, 0xC3, 0x84, 0x2F, 0x62, 0xE7, 0x77, 0x38, 0x1C, 0xF6, 0x28,
  0x49, 0xF8, 0x5F, 0xC2, 0x89, 0x0E, 0xF1, 0x0D, 0xF3, 0x6F, 0x92, 0x84, 0x6F, 0x8B, 0xF2, 0x38,
  0x2E, 0xEF, 0xB4, 0x07, 0xA0, 0x34, 0x81, 0x2F, 0xE5, 0x81, 0x2F, 0xE5, 0x81, 0x2F, 0xE5, 0x81,
  0x2F, 0xE3,
  // "ŷ" (U+0177)
  0x28, 0x17, 0x72, 0x38, 0x27, 0xFE, 0xC2, 0x84, 0x2F, 0x62, 0xE7, 0x71, 0x83, 0xCF, 0x50, 0x1A,
  0x8B, 0x16, 0xF9, 0x05, 0xFA, 0x1F, 0xE0, 0xAF, 0x50, 0xBF, 0x3E, 0xF1, 0x06, 0xFA, 0xFB, 0x20,
  0x1B, 0x06, 0x30, 0xBA, 0x01, 0x38, 0x16, 0xFB, 0x48, 0x1B, 0xF6, 0x28, 0x25, 0xBF, 0xE3, 0x82,
  0x6F, 0xC3, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x31, 0x82, 0x38, 0x38, 0x44, 0xE4, 0x7E, 0x27, 0x73, 0x81, 0xCF, 0x62, 0x84, 0x9F, 0x85,
  0xFC, 0x28, 0x90, 0xEF, 0x10, 0xDF, 0x36, 0xF9, 0x28, 0x46, 0xF8, 0xBF, 0x23, 0x82, 0xEE, 0xFB,
  0x40, 0x7A, 0x03, 0x48, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x58, 0x12, 0xFE, 0x30,
  // "Ź" (U+0179)
  0x40, 0x02, 0x48, 0x16, 0xFB, 0x38, 0x12, 0xF9, 0x77, 0x20, 0x8D, 0x86, 0xA5, 0x99, 0x9E, 0xF8,
  0x38, 0x22, 0xFE, 0x13, 0x81, 0xBF, 0x63, 0x81, 0x4F, 0xD4, 0x81, 0xDF, 0x43, 0x81, 0x6F, 0xB4,
  0x81, 0xEF, 0x33, 0x86, 0x8F, 0xE9, 0x99, 0x7A, 0xD0, 0xB0,
  // "ź" (U+017A)
  0x30, 0x02, 0x38, 0x16, 0xFB, 0x28, 0x12, 0xF9, 0x71, 0x07, 0xC8, 0x58, 0x49, 0x9E, 0xF6, 0x28,
  0x13, 0xFD, 0x38, 0x1C, 0xF4, 0x28, 0x15, 0xFB, 0x38, 0x1D, 0xF3, 0x28, 0x57, 0xFE, 0x99, 0x6A,
  0xC0, 0xA0,
  // "Ż" (U+017B)
  0x28, 0x11, 0x85, 0x48, 0x14, 0xE9, 0x77, 0x20, 0x8D, 0x86, 0xA5, 0x99, 0x9E, 0xF8, 0x38, 0x22,
  0xFE, 0x13, 0x81, 0xBF, 0x63, 0x81, 0x4F, 0xD4, 0x81, 0xDF, 0x43, 0x81, 0x6F, 0xB4, 0x81, 0xEF,
  0x33, 0x86, 0x8F, 0xE9, 0x99, 0x7A, 0xD0, 0xB0,
  // "ż" (U+017C)
  0x28, 0x11, 0x85, 0x38, 0x14, 0xE9, 0x70, 0x7C, 0x85, 0x84, 0x99, 0xEF, 0x62, 0x81, 0x3F, 0xD3,
  0x81, 0xCF, 0x42, 0x81, 0x5F, 0xB3, 0x81, 0xDF, 0x32, 0x85, 0x7F, 0xE9, 0x96, 0xAC, 0x0A,
  // "Ž" (U+017D)
  0x84, 0x27, 0x10, 0x65, 0x28, 0x3C, 0xC9, 0xF3, 0x20, 0x2A, 0x07, 0x77, 0x20, 0x8D, 0x86, 0xA5,
  0x99, 0x9E, 0xF8, 0x38, 0x22, 0xFE, 0x13, 0x81, 0xBF, 0x63, 0x81, 0x4F, 0xD4, 0x81, 0xDF, 0x43,
  0x81, 0x6F, 0xB4, 0x81, 0xEF, 0x33, 0x86, 0x8F, 0xE9, 0x99, 0x7A, 0xD0, 0xB0,
  // "ž" (U+017E)
  0x89, 0x42, 0x71, 0x06, 0x50, 0xCC, 0x9F, 0x30, 0x2A, 0x07, 0x70, 0x7C, 0x85, 0x84, 0x99, 0xEF,
  0x62, 0x81, 0x3F, 0xD3, 0x81, 0xCF, 0x42, 0x81, 0x5F, 0xB3, 0x81, 0xDF, 0x32, 0x85, 0x7F, 0xE9,
  0x96, 0xAC, 0x0A,
  // "ſ" (U+017F)
  0x8D, 0x13, 0xCF, 0xDB, 0xFB, 0xAE, 0xF2, 0x0E, 0xF1, 0x0E, 0xF1, 0x0E, 0xF1, 0x0E, 0xF1, 0x0E,
  0xF1, 0x0E, 0xF1, 0x0E, 0xF1, 0x0E, 0xF1, 0x10,
  // "Ω" (U+03A9)
  0x28, 0x45, 0xCF, 0xEB, 0x33, 0x07, 0xA0, 0x0B, 0xA0, 0x42, 0x81, 0xEF, 0x52, 0x85, 0x8F, 0xC0,
  0x3F, 0xE3, 0x02, 0xA1, 0x81, 0x4F, 0xD3, 0x01, 0xA8, 0x21, 0x2F, 0xE3, 0x81, 0x1F, 0xE2, 0x81,
  0xDF, 0x22, 0x81, 0x5F, 0xA2, 0x81, 0x4F, 0x92, 0x89, 0x5C, 0xE2, 0x06, 0x9D, 0xF4, 0x7F, 0xC9,
  0x49, 0xB0, 0x40, 0x8B, 0x07,
  // "μ" (U+03BC)
  0x01, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF, 0x41, 0xA2, 0x82, 0xBF,
  0x41, 0xA2, 0x82, 0xCF, 0x41, 0xA8, 0x41, 0x0E, 0xF4, 0x1A, 0x00, 0xCA, 0x89, 0x24, 0x1F, 0xED,
  0xD7, 0xF4, 0x1F, 0xE5, 0x01, 0xA5, 0x01, 0xA5,
  // "π" (U+03C0)
  0x07, 0xF8, 0xA0, 0xD8, 0xCF, 0xC9, 0xDF, 0xC8, 0x08, 0xF8, 0x08, 0xF7, 0x28, 0x58, 0xF8, 0x08,
  0xF7, 0x28, 0x58, 0xF8, 0x08, 0xF7, 0x28, 0x58, 0xF8, 0x08, 0xF7, 0x28, 0x97, 0x8F, 0x80, 0x7F,
  0xD9, 0x08, 0xF8, 0x01, 0xCF, 0xA0,
  // "–" (U+2013)
  0x04, 0x80, 0x29, 0x07, 0xE0,
  // "—" (U+2014)
  0x04, 0x80, 0x91, 0x90, 0x40, 0x7F, 0xE0, 0x70,
  // "€" (U+20AC)
  0x28, 0x63, 0xBE, 0xEA, 0x10, 0x2A, 0x81, 0xAB, 0xC2, 0x81, 0x9F, 0x74, 0x0B, 0xC0, 0xA2, 0x84,
  0x7E, 0xFA, 0x96, 0x20, 0xBC, 0x04, 0x28, 0x47, 0xDF, 0xB9, 0x23, 0x81, 0x7F, 0x95, 0x84, 0x1E,
  0xFB, 0xAD, 0x38, 0x32, 0xBE, 0xEA, 0x10,
  // "₿" (U+20BF)
  0x18, 0x25, 0x26, 0x12, 0x84, 0x94, 0xC1, 0x0E, 0xB8, 0xA3, 0xA1, 0xEF, 0xAD, 0xFA, 0xEF, 0x13,
  0xFD, 0xEF, 0x16, 0xFA, 0xEB, 0x89, 0x2D, 0x2E, 0xFA, 0xDF, 0x9E, 0xF1, 0x1A, 0x82, 0xEF, 0x11,
  0xA8, 0x5E, 0xFA, 0xCF, 0xBE, 0xB8, 0x5A, 0x10, 0x94, 0xC1, 0x28, 0x14, 0x26, 0x20,
  // "‘" (U+2018)
  0x18, 0x91, 0xAF, 0x0E, 0xC4, 0xFA, 0x7F, 0x80,
  // "’" (U+2019)
  0x1A, 0x87, 0x2F, 0xC4, 0xF7, 0x7F, 0x20,
  // "‚" (U+201A)
  0x1A, 0x87, 0x2F, 0xC4, 0xF7, 0x7F, 0x20,
  // "‛" (U+201B)
  0x89, 0x17, 0xF8, 0x4F, 0xA0, 0xEC, 0x0A, 0x90,
  // "“" (U+201C)
  0x18, 0xB0, 0xAF, 0x07, 0xF2, 0x0E, 0xC0, 0xCF, 0x04, 0xFA, 0x1F, 0xD0, 0x7F, 0x85, 0xFB, 0x10,
  // "”" (U+201D)
  0x1A, 0x18, 0xA5, 0xDF, 0x22, 0xFC, 0x0F, 0xE0, 0x5F, 0x72, 0xFA, 0x08, 0xF2, 0x5F, 0x51,
  // "„" (U+201E)
  0x1A, 0x18, 0xA5, 0xDF, 0x22, 0xFC, 0x0F, 0xE0, 0x5F, 0x72, 0xFA, 0x08, 0xF2, 0x5F, 0x51,
  // "‟" (U+201F)
  0x89, 0x37, 0xF8, 0x5F, 0xB0, 0x4F, 0xA1, 0xFD, 0x28, 0x2E, 0xC0, 0xC9, 0x28, 0x4A, 0xF0, 0x7F,
  0x20,
  // "†" (U+2020)
  0x28, 0x14, 0xF9, 0x48, 0x12, 0xF7, 0x38, 0x51, 0x0F, 0x51, 0x13, 0xD8, 0x69, 0x16, 0x4F, 0x85,
  0x33, 0x90, 0x54, 0x81, 0x1F, 0x64, 0x81, 0x2F, 0x74, 0x81, 0x3F, 0x84, 0x81, 0x4F, 0x94, 0x81,
  0x4F, 0x92,
  // "‡" (U+2021)
  0x28, 0x13, 0xFA, 0x48, 0x11, 0xF7, 0x28, 0x61, 0x64, 0xF8, 0x54, 0x3D, 0x86, 0x90, 0x11, 0xF6,
  0x11, 0x28, 0x12, 0xF9, 0x59, 0x06, 0x28, 0x94, 0x3F, 0xEF, 0xEF, 0x92, 0x75, 0xF9, 0x64, 0x28,
  0x11, 0xF7, 0x48, 0x13, 0xFA, 0x20,
  // "•" (U+2022)
  0x18, 0x37, 0xED, 0x41, 0xB0, 0xD0, 0x3C, 0x01, 0xB8, 0x4D, 0x07, 0xED, 0x40,
  // "…" (U+2026)
  0x10, 0x01, 0x20, 0x01, 0x28, 0xB0, 0x11, 0x01, 0xFE, 0x11, 0xFE, 0x11, 0xFE, 0x11, 0xDD, 0x01,
  0xDD, 0x01, 0xDD, 0x10,
  // "‰" (U+2030)
  0x18, 0x29, 0xEC, 0x22, 0x09, 0x0E, 0x71, 0x87, 0x4F, 0xCF, 0xA0, 0x1F, 0x77, 0x18, 0x77, 0xF1,
  0xBE, 0x08, 0xE1, 0x71, 0x86, 0x7F, 0x1B, 0xE1, 0xE8, 0x72, 0x89, 0x14, 0xFC, 0xFA, 0x7F, 0x3C,
  0xFB, 0x28, 0xA3, 0xBF, 0xC1, 0x08, 0xEC, 0x3E, 0x99, 0xF6, 0xF6, 0x6F, 0x6F, 0x94, 0x89, 0x36,
  0xF2, 0xBC, 0x0E, 0xA9, 0xF0, 0xCC, 0x48, 0x93, 0xDA, 0x0B, 0xD0, 0xF9, 0x9F, 0x0D, 0xC3, 0x89,
  0x45, 0xF3, 0x08, 0xFB, 0xF6, 0x6F, 0xBF, 0x83, 0x0C, 0x0B, 0x28, 0x21, 0xBE, 0xA2, 0x82, 0xAE,
  0xB1,
  // "‹" (U+2039)
  0x20, 0x02, 0x38, 0x91, 0xCF, 0x10, 0x9F, 0x80, 0x4F, 0xD2, 0x82, 0x3F, 0xE1, 0x28, 0x16, 0xFA,
  0x38, 0x1A, 0xD1,
  // "›" (U+203A)
  0x10, 0x30, 0x12, 0x81, 0x3F, 0xA3, 0x81, 0xAF, 0x62, 0x89, 0x71, 0xEF, 0x20, 0x3F, 0xE1, 0x0C,
  0xF4, 0x03, 0xE8, 0x30, 0x13,
  // "⁄" (U+2044)
  0x58, 0x18, 0xE1, 0x48, 0x11, 0xF8, 0x50, 0xA0, 0xE5, 0x81, 0x3F, 0x65, 0x0B, 0x0D, 0x58, 0x14,
  0xF5, 0x50, 0xD0, 0xC5, 0x81, 0x6F, 0x35, 0x0E, 0x0A, 0x58, 0x17, 0xF2, 0x50,
  // "™" (U+2122)
  0x8E, 0x5C, 0xEE, 0xC9, 0xE1, 0x0D, 0xB1, 0xAA, 0x19, 0xE6, 0x3E, 0xC0, 0x99, 0x09, 0xAB, 0x9A,
  0xC0, 0x99, 0x09, 0x7D, 0xD5, 0xC0, 0x99, 0x09, 0x78, 0xA5, 0xC0, 0x11, 0x01, 0x40, 0x10,
  // "⅒" (U+2152)
  0x18, 0x12, 0xCE, 0x38, 0x18, 0xE1, 0x60, 0x20, 0xFE, 0x28, 0x11, 0xF8, 0x71, 0x81, 0x49, 0xE2,
  0x0A, 0x0E, 0x73, 0x84, 0x9E, 0x03, 0xF6, 0x73, 0x89, 0x49, 0xE0, 0xBD, 0x02, 0xCE, 0x0B, 0xFC,
  0x22, 0x89, 0x49, 0xE4, 0xF5, 0x2E, 0xEE, 0x7F, 0x6E, 0xA4, 0x0D, 0x0C, 0x28, 0x64, 0x9E, 0x9E,
  0x0A, 0xD3, 0x81, 0x6F, 0x33, 0x85, 0x9E, 0x9E, 0x0A, 0xD3, 0x0E, 0x0A, 0x48, 0x59, 0xE7, 0xF3,
  0xDB, 0x28, 0x17, 0xF2, 0x48, 0x59, 0xE1, 0xDF, 0xE3, 0x76, 0x03, 0x01, 0x10,
  // "ﬁ" (U+FB01)
  0x18, 0xA1, 0x2C, 0xFD, 0x3D, 0xD0, 0x9F, 0xCA, 0x07, 0x70, 0xBF, 0x34, 0x08, 0xB0, 0xB0, 0x1A,
  0x84, 0x7E, 0xFB, 0x71, 0xA1, 0x83, 0xCF, 0x30, 0x1A, 0x18, 0x3C, 0xF3, 0x01, 0xA1, 0x83, 0xCF,
  0x30, 0x1A, 0x18, 0x3C, 0xF3, 0x01, 0xA1, 0x83, 0xCF, 0x30, 0x1A, 0x18, 0x3C, 0xF3, 0x01, 0xA0,
  // "ﬂ" (U+FB02)
  0x18, 0x32, 0xCF, 0xD3, 0xA1, 0x83, 0x9F, 0xCA, 0x1A, 0x18, 0x3B, 0xF3, 0x01, 0xA0, 0x8B, 0x0B,
  0x01, 0xA8, 0x47, 0xEF, 0xB7, 0x1A, 0x18, 0x3C, 0xF3, 0x01, 0xA1, 0x83, 0xCF, 0x30, 0x1A, 0x18,
  0x3C, 0xF3, 0x01, 0xA1, 0x83, 0xCF, 0x30, 0x1A, 0x18, 0x3C, 0xF3, 0x01, 0xA1, 0x83, 0xCF, 0x30,
  0x1A,
};

const Font& font_NotoSans_CondensedBold_15() {
  static SmoothFont font(font_NotoSans_CondensedBold_15_data);
  return font;
}

}  // namespace roo_display
