#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Bold (Noto Sans Bold)
// Generated on Thu Mar 30 22:28:08 CEST 2023
static const uint8_t font_NotoSans_Bold_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x0A,
  0xFD, 0xFD, 0x12, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x13, 0x05, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x07, 0x06, 0x0A, 0x07, 0x00, 0x16, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x00, 0x23, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x07, 0x0B, 0x09, 0x00, 0x50, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0C, 0x0A, 0x0E, 0x00, 0x7C, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x00, 0xC0, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x07, 0x02, 0x0A, 0x04, 0x00, 0xF8, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x00, 0xFD, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x01, 0x1F, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x05, 0x07, 0x0B, 0x08, 0x01, 0x41, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x07, 0x09, 0x09, 0x01, 0x5D, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x03, 0x02, 0x04, 0x01, 0x74, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x04, 0x05, 0x05, 0x01, 0x7E, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x03, 0x03, 0x04, 0x01, 0x84, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x01, 0x8A, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x01, 0xA9, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x06, 0x0A, 0x09, 0x01, 0xD7, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x01, 0xF6, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x02, 0x1E, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x02, 0x48, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x02, 0x68, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x02, 0x8E, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x02, 0xB9, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x02, 0xD9, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x03, 0x06, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x03, 0x08, 0x04, 0x03, 0x30, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x03, 0x3B, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x07, 0x0A, 0x09, 0x03, 0x4C, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x07, 0x08, 0x09, 0x03, 0x69, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x07, 0x0A, 0x09, 0x03, 0x77, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x03, 0x94, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0C, 0x0A, 0x0D, 0x03, 0xB5, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x04, 0x00, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x09, 0x0A, 0x0A, 0x04, 0x2F, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x08, 0x0A, 0x0A, 0x04, 0x5F, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x04, 0x88, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x04, 0xBC, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x04, 0xDB, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x04, 0xF9, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x05, 0x2D, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x05, 0x5E, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFE, 0x03, 0x0A, 0x05, 0x05, 0x77, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x09, 0x0A, 0x0A, 0x05, 0x9F, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x05, 0xD2, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0C, 0x0A, 0x0E, 0x05, 0xF0, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x0A, 0x0A, 0x0C, 0x06, 0x30, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x0A, 0x0A, 0x0C, 0x06, 0x64, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x08, 0x0A, 0x09, 0x06, 0x99, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x0A, 0x0A, 0x0C, 0x06, 0xBF, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x09, 0x0A, 0x0A, 0x06, 0xFF, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x07, 0x31, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x07, 0x59, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x07, 0x7A, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x07, 0xAE, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0E, 0x0A, 0x0F, 0x07, 0xDD, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x08, 0x2A, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x08, 0x5B, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x08, 0x84, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFE, 0x04, 0x0A, 0x05, 0x08, 0xA8, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x08, 0xC4, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x03, 0x0A, 0x05, 0x08, 0xE2, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x07, 0x0B, 0x09, 0x08, 0xFE, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x06, 0xFF, 0x06, 0x09, 0x19, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0A, 0x04, 0x0C, 0x05, 0x09, 0x1B, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x07, 0x08, 0x09, 0x09, 0x24, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x09, 0x48, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x07, 0x08, 0x08, 0x09, 0x75, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x08, 0x0B, 0x0A, 0x09, 0x92, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x08, 0x08, 0x09, 0x09, 0xC3, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x09, 0xE7, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x08, 0x08, 0x0A, 0x0A, 0x0C, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x0A, 0x42, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x03, 0x0B, 0x05, 0x0A, 0x70, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x03, 0x0B, 0x05, 0x0A, 0x82, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x08, 0x0B, 0x09, 0x0A, 0xA9, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x03, 0x0B, 0x05, 0x0A, 0xD6, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x0D, 0x08, 0x0F, 0x0A, 0xE8, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x08, 0x08, 0x0A, 0x0B, 0x24, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x08, 0x08, 0x09, 0x0B, 0x49, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x0B, 0x6F, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x08, 0x08, 0x0A, 0x0B, 0x9C, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x06, 0x08, 0x07, 0x0B, 0xCE, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0B, 0xE7, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x0C, 0x07, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x08, 0x08, 0x0A, 0x0C, 0x27, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x08, 0x08, 0x09, 0x0C, 0x4C, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0C, 0x08, 0x0D, 0x0C, 0x6F, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x08, 0x08, 0x09, 0x0C, 0xA8, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x08, 0x08, 0x09, 0x0C, 0xCD, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0C, 0xFB, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x0D, 0x15, // "{" (U+007B)
  0x00, 0x7C, 0x03, 0xFE, 0x04, 0x0B, 0x08, 0x0D, 0x3B, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x0D, 0x4B, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x05, 0x07, 0x07, 0x09, 0x0D, 0x74, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x0D, 0x82, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x0D, 0x99, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0D, 0xBB, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x07, 0x09, 0x09, 0x0D, 0xE0, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0D, 0xFD, // "¥" (U+00A5)
  0x00, 0xA6, 0x03, 0xFE, 0x04, 0x0B, 0x08, 0x0E, 0x28, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0E, 0x38, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0A, 0x06, 0x0B, 0x09, 0x0E, 0x63, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0B, 0x0B, 0x0C, 0x0E, 0x6A, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x05, 0x05, 0x0A, 0x06, 0x0E, 0xAB, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x08, 0x08, 0x09, 0x0E, 0xBF, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x07, 0x06, 0x09, 0x0E, 0xE4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x0B, 0x0B, 0x0C, 0x0E, 0xF2, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0C, 0x07, 0x0D, 0x08, 0x0F, 0x38, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x07, 0x05, 0x0B, 0x06, 0x0F, 0x3D, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x07, 0x09, 0x09, 0x0F, 0x4E, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x07, 0x05, 0x0D, 0x06, 0x0F, 0x6C, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x07, 0x04, 0x0D, 0x06, 0x0F, 0x82, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0A, 0x04, 0x0C, 0x05, 0x0F, 0x96, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x0F, 0x9E, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x08, 0x0B, 0x0A, 0x0F, 0xCC, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x05, 0x03, 0x07, 0x04, 0x10, 0x02, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFD, 0x02, 0x01, 0x03, 0x10, 0x08, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x07, 0x04, 0x0C, 0x06, 0x10, 0x15, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x05, 0x0A, 0x06, 0x10, 0x27, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x08, 0x08, 0x09, 0x10, 0x38, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0C, 0x0A, 0x0C, 0x10, 0x5D, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x10, 0x9A, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x10, 0xDA, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x06, 0x08, 0x07, 0x11, 0x1A, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0A, 0x0F, 0x0A, 0x11, 0x3B, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0A, 0x0F, 0x0A, 0x11, 0x76, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0A, 0x0F, 0x0A, 0x11, 0xB0, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x11, 0xED, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x12, 0x27, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x12, 0x5F, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0D, 0x0A, 0x0E, 0x12, 0x99, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x08, 0x0A, 0x0A, 0x12, 0xCE, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x13, 0x03, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x13, 0x2C, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x13, 0x56, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x13, 0x82, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x05, 0x0F, 0x06, 0x13, 0xAA, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x05, 0x0F, 0x06, 0x13, 0xCF, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x05, 0x0F, 0x06, 0x13, 0xF2, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x14, 0x1A, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x14, 0x3B, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x14, 0x74, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x0A, 0x0F, 0x0C, 0x14, 0xB4, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x0A, 0x0F, 0x0C, 0x14, 0xF5, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x0A, 0x0F, 0x0C, 0x15, 0x36, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x15, 0x79, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x15, 0xB9, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x07, 0x09, 0x09, 0x15, 0xF8, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0A, 0x0B, 0x0C, 0x16, 0x13, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x16, 0x53, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x16, 0x93, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x16, 0xD3, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x17, 0x16, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x09, 0x0F, 0x09, 0x17, 0x54, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x08, 0x0A, 0x09, 0x17, 0x88, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0A, 0x0B, 0x0B, 0x17, 0xAE, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x17, 0xEB, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x18, 0x19, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x18, 0x47, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x18, 0x78, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x18, 0xA5, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x18, 0xD1, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0D, 0x08, 0x0E, 0x19, 0x00, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x07, 0x08, 0x08, 0x19, 0x3A, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x19, 0x61, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x19, 0x8F, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x19, 0xBD, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x19, 0xEE, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x03, 0x0C, 0x05, 0x1A, 0x1A, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x1A, 0x3B, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0x5C, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1A, 0x81, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1A, 0xA0, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x1A, 0xD5, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x04, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x34, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x64, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1B, 0x97, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1B, 0xC7, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x07, 0x09, 0x09, 0x1B, 0xF5, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x08, 0x08, 0x09, 0x1C, 0x09, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x1C, 0x33, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x1C, 0x62, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x1C, 0x91, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x1C, 0xC3, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x08, 0x0C, 0x09, 0x1C, 0xF1, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFE, 0x08, 0x0B, 0x0A, 0x1D, 0x2A, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x08, 0x0B, 0x09, 0x1D, 0x60, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x1D, 0x97, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x1D, 0xCF, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0A, 0x0F, 0x0A, 0x1D, 0xFB, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x1E, 0x39, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x0A, 0x0A, 0x0A, 0x1E, 0x6B, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x08, 0x08, 0x09, 0x1E, 0xA5, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x1E, 0xD4, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0x08, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x1F, 0x2F, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0x66, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x1F, 0x90, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x1F, 0xC1, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x1F, 0xE4, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x20, 0x1B, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x20, 0x45, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0B, 0x0B, 0x0A, 0x20, 0x88, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x20, 0xC0, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x20, 0xF9, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x21, 0x30, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x21, 0x57, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x21, 0x83, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x21, 0xAF, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x21, 0xE1, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x22, 0x07, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x22, 0x31, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x08, 0x08, 0x09, 0x22, 0x59, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x22, 0x82, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x22, 0xAE, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x22, 0xDF, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x08, 0x0C, 0x0A, 0x23, 0x21, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x23, 0x64, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x08, 0x0C, 0x0A, 0x23, 0xA7, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x23, 0xEB, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x08, 0x0B, 0x0A, 0x24, 0x26, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x09, 0x0A, 0x0B, 0x24, 0x62, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x08, 0x0B, 0x0A, 0x24, 0x9D, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x24, 0xD9, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x08, 0x0F, 0x0A, 0x25, 0x19, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0B, 0x0A, 0x0B, 0x25, 0x5E, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x08, 0x0B, 0x0A, 0x25, 0x95, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x05, 0x0E, 0x06, 0x25, 0xC8, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x25, 0xED, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x26, 0x0F, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x26, 0x2F, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x05, 0x0F, 0x06, 0x26, 0x4E, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x26, 0x76, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x26, 0x9B, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x03, 0x0B, 0x05, 0x26, 0xBE, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x26, 0xDC, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x03, 0x08, 0x05, 0x26, 0xFC, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x09, 0x0A, 0x0B, 0x27, 0x0A, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFE, 0x08, 0x0B, 0x09, 0x27, 0x46, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFE, 0x05, 0x0F, 0x05, 0x27, 0x81, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x05, 0x0C, 0x05, 0x27, 0xB9, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFE, 0x09, 0x0A, 0x0A, 0x27, 0xE9, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFE, 0x08, 0x0B, 0x09, 0x28, 0x22, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x08, 0x08, 0x09, 0x28, 0x56, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x28, 0x79, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x28, 0xA2, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x28, 0xCC, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFE, 0x03, 0x0B, 0x05, 0x28, 0xF1, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x08, 0x0A, 0x08, 0x29, 0x08, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x06, 0x0B, 0x05, 0x29, 0x2A, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x29, 0x4C, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x05, 0x0B, 0x05, 0x29, 0x6B, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x29, 0x8C, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x29, 0xAD, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x0A, 0x0F, 0x0C, 0x29, 0xCE, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x2A, 0x0E, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFE, 0x0A, 0x0A, 0x0C, 0x2A, 0x3E, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x2A, 0x78, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x0A, 0x0F, 0x0C, 0x2A, 0xA3, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x2A, 0xE6, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0A, 0x0A, 0x0C, 0x2B, 0x18, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFE, 0x0A, 0x0A, 0x0C, 0x2B, 0x4F, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x2B, 0x8E, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x2B, 0xBE, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x2B, 0xFC, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x0A, 0x0F, 0x0C, 0x2C, 0x2A, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x2C, 0x6F, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x2C, 0xA3, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x2C, 0xE3, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0D, 0x0A, 0x0F, 0x2D, 0x12, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0D, 0x08, 0x0F, 0x2D, 0x52, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x2D, 0x8B, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x2D, 0xC8, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFE, 0x09, 0x0A, 0x0A, 0x2D, 0xEB, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x2E, 0x22, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x2E, 0x41, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2E, 0x80, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x2E, 0xA7, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2E, 0xDA, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x2F, 0x04, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2F, 0x3A, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x2F, 0x67, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x2F, 0x9A, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x2F, 0xC6, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2F, 0xFC, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x30, 0x28, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x05, 0x0A, 0x07, 0x30, 0x53, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x30, 0x7E, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x08, 0x0B, 0x07, 0x30, 0xAD, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x30, 0xD4, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x30, 0xF7, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x31, 0x17, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x31, 0x57, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x31, 0x86, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x31, 0xC4, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x31, 0xF1, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x32, 0x35, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x32, 0x68, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x32, 0xA9, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x32, 0xDA, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x33, 0x19, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFE, 0x0A, 0x0A, 0x0B, 0x33, 0x47, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x33, 0x84, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0E, 0x0F, 0x0F, 0x33, 0xB2, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0C, 0x0C, 0x0D, 0x34, 0x0F, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x09, 0x0F, 0x09, 0x34, 0x56, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x08, 0x0C, 0x09, 0x34, 0x8D, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x34, 0xC9, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x34, 0xFC, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x35, 0x2B, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x35, 0x50, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x35, 0x7B, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x35, 0x9C, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x35, 0xCE, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x05, 0x0B, 0x06, 0x35, 0xF5, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x36, 0x16, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFE, 0x08, 0x08, 0x0A, 0x36, 0x53, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x36, 0x81, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x05, 0x08, 0x36, 0xAE, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0E, 0x05, 0x0F, 0x36, 0xB5, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x36, 0xBD, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x07, 0x0C, 0x09, 0x36, 0xE5, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x37, 0x17, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x37, 0x1D, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x02, 0x01, 0x04, 0x37, 0x23, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x37, 0x29, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x08, 0x06, 0x0A, 0x07, 0x37, 0x2F, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x08, 0x06, 0x0A, 0x07, 0x37, 0x3B, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x06, 0x01, 0x08, 0x37, 0x47, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x08, 0x06, 0x0A, 0x07, 0x37, 0x53, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x37, 0x5F, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x37, 0x7F, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x04, 0x07, 0x06, 0x37, 0xA4, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0C, 0x03, 0x0D, 0x37, 0xAF, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x12, 0x0A, 0x13, 0x37, 0xC2, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x04, 0x08, 0x06, 0x38, 0x20, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x04, 0x08, 0x06, 0x38, 0x34, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x04, 0x0A, 0x02, 0x38, 0x4A, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x06, 0x0A, 0x0B, 0x0C, 0x38, 0x68, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x11, 0x0A, 0x11, 0x38, 0x8C, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x38, 0xE0, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x39, 0x18, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x01, 0xA0, 0x61, 0xA0, 0x51, 0xA8, 0x97, 0x40, 0xEF, 0x30, 0xDF, 0x20, 0xCF, 0x10, 0xBF, 0x12,
  0x01, 0x28, 0x5E, 0xF4, 0x0C, 0xD3,
  // """ (U+0022)
  0xA1, 0x8A, 0x2E, 0xF1, 0xED, 0x0C, 0xF0, 0xDC, 0x0B, 0xE0, 0xBB, 0x0A, 0xD1,
  // "#" (U+0023)
  0x38, 0x29, 0xF0, 0x89, 0x58, 0x3D, 0xB0, 0xCC, 0x28, 0x91, 0x1B, 0xBF, 0xDB, 0xFE, 0xB4, 0x2F,
  0x90, 0x52, 0x84, 0x6F, 0x26, 0xF2, 0x28, 0x91, 0x7B, 0xDF, 0xBD, 0xFB, 0x90, 0xAF, 0x0D, 0x39,
  0x82, 0x80, 0xF9, 0x48, 0x43, 0xF5, 0x3F, 0x64, 0x84, 0x5F, 0x36, 0xF3, 0x30,
  // "$" (U+0024)
  0x30, 0x30, 0xC4, 0x87, 0x18, 0xCF, 0xC9, 0x41, 0xDD, 0x89, 0x08, 0x4F, 0xE4, 0xC0, 0x41, 0x3A,
  0x09, 0x0C, 0x40, 0x8B, 0x09, 0x02, 0x30, 0x30, 0xAB, 0x05, 0x38, 0x94, 0x3D, 0xAF, 0xE4, 0x73,
  0x3C, 0x7F, 0xD5, 0xE8, 0x66, 0x06, 0x9B, 0xE8, 0x34, 0x03, 0x0C, 0x30,
  // "%" (U+0025)
  0x18, 0x28, 0xEE, 0x73, 0x81, 0x7F, 0x42, 0x89, 0x04, 0xFE, 0xEF, 0x30, 0x1E, 0xA3, 0x89, 0x07,
  0xF5, 0x5F, 0x70, 0xAF, 0x23, 0x8A, 0x47, 0xF5, 0x5F, 0x73, 0xF8, 0x7A, 0x70, 0x3F, 0xEE, 0xF4,
  0xCD, 0x9B, 0x89, 0x48, 0x07, 0xEE, 0x76, 0xF5, 0xEE, 0x1E, 0xE4, 0x86, 0x1E, 0xB0, 0xFC, 0x0C,
  0x94, 0x87, 0x9F, 0x20, 0xEE, 0x0D, 0xE3, 0x81, 0x3F, 0x82, 0x83, 0xAF, 0xDF, 0xA3, 0x0C, 0x0D,
  0x38, 0x31, 0xBE, 0xB1,
  // "&" (U+0026)
  0x28, 0x47, 0xCE, 0xD9, 0x14, 0x05, 0xA8, 0x2C, 0xEF, 0x84, 0x85, 0x5F, 0xA0, 0x9F, 0x75, 0x83,
  0xCF, 0xDF, 0xA5, 0x04, 0x0E, 0xA0, 0xC2, 0x82, 0xAF, 0x91, 0xA8, 0x7B, 0xDF, 0xB1, 0xEF, 0x45,
  0xA8, 0x71, 0x1D, 0xFE, 0xFC, 0x05, 0xA8, 0x22, 0x01, 0xEA, 0x04, 0x20, 0xDA, 0x0B, 0x0D, 0xB0,
  0xA2, 0x89, 0x01, 0x9D, 0xFD, 0xA5, 0xDF, 0xB0,
  // "'" (U+0027)
  0xA8, 0x4E, 0xDD, 0xCB, 0xB0,
  // "(" (U+0028)
  0x28, 0x58, 0xF4, 0x03, 0xFA, 0x28, 0x1B, 0xF3, 0x29, 0x0E, 0x28, 0x14, 0xFA, 0x28, 0x15, 0xF9,
  0x28, 0x15, 0xF9, 0x28, 0x14, 0xFA, 0x28, 0x11, 0xFD, 0x38, 0x1B, 0xF3, 0x28, 0x14, 0xFA, 0x38,
  0x18, 0xF4,
  // ")" (U+0029)
  0x81, 0x3F, 0xA3, 0x81, 0x9F, 0x52, 0x81, 0x2F, 0xC3, 0x81, 0xDF, 0x12, 0x81, 0x9F, 0x52, 0x81,
  0x8F, 0x62, 0x81, 0x7F, 0x62, 0x81, 0x9F, 0x52, 0x85, 0xCF, 0x20, 0x2F, 0xC2, 0x85, 0x9F, 0x50,
  0x3F, 0xA2,
  // "*" (U+002A)
  0x30, 0xC9, 0x60, 0xA0, 0xD3, 0x89, 0x15, 0xEA, 0xCD, 0x9D, 0x84, 0xAC, 0xA8, 0x1D, 0xB6, 0x28,
  0x29, 0xFE, 0xB3, 0x84, 0x5F, 0x97, 0xF8, 0x38, 0x37, 0x20, 0x81, 0x10,
  // "+" (U+002B)
  0x38, 0x18, 0xF1, 0x58, 0x18, 0xF1, 0x58, 0x18, 0xF1, 0x20, 0x5E, 0x87, 0xE4, 0xBB, 0xDF, 0xBB,
  0xA3, 0x81, 0x8F, 0x15, 0x81, 0x8F, 0x12,
  // "," (U+002C)
  0x18, 0x94, 0xDF, 0x30, 0xFE, 0x03, 0xF9, 0x06, 0xF3, 0x10,
  // "-" (U+002D)
  0x84, 0x6B, 0xBB, 0x48, 0xB0, 0x50,
  // "." (U+002E)
  0x18, 0x61, 0x0E, 0xF4, 0xCD, 0x30,
  // "/" (U+002F)
  0x38, 0x11, 0xFE, 0x38, 0x17, 0xF8, 0x38, 0x1D, 0xF2, 0x28, 0x14, 0xFB, 0x38, 0x1A, 0xF5, 0x28,
  0x11, 0xFE, 0x38, 0x17, 0xF8, 0x38, 0x1D, 0xF2, 0x28, 0x14, 0xFB, 0x38, 0x1A, 0xF5, 0x30,
  // "0" (U+0030)
  0x28, 0x39, 0xEF, 0xC4, 0x28, 0x2A, 0xFE, 0xCA, 0x03, 0x01, 0xA8, 0x63, 0x0A, 0xFA, 0x5F, 0xE2,
  0x84, 0x5F, 0xE6, 0xFC, 0x20, 0x3A, 0x81, 0x6F, 0xC2, 0x03, 0xA8, 0x15, 0xFE, 0x28, 0x25, 0xFE,
  0x1A, 0x89, 0x03, 0x0A, 0xFA, 0x09, 0xFE, 0xCA, 0x03, 0x28, 0x39, 0xEF, 0xC5, 0x10,
  // "1" (U+0031)
  0x28, 0x45, 0xEF, 0x20, 0x9B, 0x82, 0x2C, 0xFA, 0xA8, 0x12, 0x57, 0x1A, 0x02, 0x20, 0x1A, 0x02,
  0x20, 0x1A, 0x02, 0x20, 0x1A, 0x02, 0x20, 0x1A, 0x02, 0x20, 0x1A, 0x02, 0x20, 0x1A, 0x02,
  // "2" (U+0032)
  0x18, 0x43, 0xAE, 0xFD, 0x62, 0x02, 0xA0, 0xD0, 0xCA, 0x06, 0x20, 0x60, 0x52, 0x81, 0x9F, 0xB6,
  0x81, 0x9F, 0xA5, 0x03, 0xA0, 0x34, 0x82, 0x3E, 0xF7, 0x48, 0x23, 0xEF, 0x64, 0x82, 0x4E, 0xF5,
  0x40, 0x3A, 0x85, 0xDB, 0xBB, 0xB0, 0x6F, 0x01,
  // "3" (U+0033)
  0x18, 0x92, 0x6C, 0xEE, 0xC6, 0x01, 0xEF, 0xCC, 0xA8, 0x26, 0x02, 0x12, 0x81, 0xAF, 0x94, 0x82,
  0x2D, 0xF4, 0x20, 0xCA, 0x0D, 0x04, 0x38, 0x48, 0xBD, 0xFE, 0x45, 0x82, 0x8F, 0xD1, 0x48, 0x69,
  0xFE, 0x6F, 0xCB, 0xDA, 0x86, 0x73, 0xBD, 0xFE, 0xC6, 0x10,
  // "4" (U+0034)
  0x40, 0x6A, 0x50, 0x2B, 0x50, 0x0C, 0xA4, 0x81, 0x9E, 0x4A, 0x38, 0x25, 0xF6, 0x2A, 0x28, 0x31,
  0xEB, 0x02, 0xA2, 0x83, 0xAF, 0xCB, 0xCA, 0x81, 0xB3, 0xBF, 0x05, 0x40, 0x2A, 0x60, 0x2A, 0x20,
  // "5" (U+0035)
  0x10, 0xAD, 0x89, 0x32, 0x0C, 0xFC, 0xBB, 0xB1, 0x0D, 0xF3, 0x58, 0x4E, 0xFA, 0xB9, 0x32, 0x0E,
  0xD8, 0x74, 0x01, 0x10, 0x2C, 0xFB, 0x58, 0x36, 0xFD, 0x12, 0x38, 0x6A, 0xFB, 0x4F, 0xDB, 0xDA,
  0x86, 0x42, 0xAE, 0xFE, 0xB4, 0x10,
  // "6" (U+0036)
  0x28, 0x12, 0x9D, 0xA8, 0x93, 0x40, 0x3E, 0xFE, 0xCB, 0x40, 0xCF, 0x74, 0x89, 0x12, 0xFD, 0x4A,
  0xA5, 0x05, 0xFD, 0xC0, 0x70, 0x6A, 0x86, 0x50, 0x7F, 0xE6, 0xFD, 0x20, 0x2A, 0x02, 0xA8, 0x90,
  0x20, 0x5F, 0xE0, 0xAF, 0xEC, 0xA0, 0x72, 0x83, 0x8D, 0xFC, 0x61,
  // "7" (U+0037)
  0x09, 0xF8, 0x71, 0x6B, 0xBB, 0xBC, 0xFE, 0x68, 0x1A, 0xF8, 0x50, 0x2A, 0x01, 0x58, 0x1A, 0xF9,
  0x50, 0x2A, 0x02, 0x58, 0x19, 0xFA, 0x50, 0x2A, 0x03, 0x58, 0x19, 0xFB, 0x50, 0x1A, 0x04, 0x40,
  // "8" (U+0038)
  0x18, 0x42, 0xAE, 0xFD, 0x72, 0x82, 0xDF, 0xEC, 0xA0, 0x70, 0x1A, 0x89, 0x61, 0x08, 0xFA, 0x0C,
  0xF7, 0x2C, 0xF5, 0x01, 0xCB, 0x05, 0x28, 0xA0, 0x7F, 0xEC, 0xFC, 0x13, 0xFD, 0x10, 0x7F, 0xC6,
  0xFB, 0x20, 0x3A, 0x02, 0xA8, 0x92, 0xDB, 0xEF, 0xA0, 0x3B, 0xEF, 0xD8, 0x10,
  // "9" (U+0039)
  0x18, 0x92, 0x2A, 0xEE, 0xB3, 0x01, 0xEF, 0xDC, 0xA8, 0x23, 0x6F, 0xC2, 0x84, 0x7F, 0xB7, 0xFC,
  0x20, 0x6A, 0x03, 0xA8, 0x1D, 0xCE, 0xA1, 0x85, 0x5C, 0xFD, 0x5F, 0xE5, 0x81, 0x6F, 0xB4, 0x86,
  0x3E, 0xF6, 0x09, 0xBD, 0xA0, 0xB2, 0x83, 0xBF, 0xEC, 0x62,
  // ":" (U+003A)
  0x86, 0xCD, 0x3E, 0xF4, 0x01, 0x71, 0x86, 0x10, 0xEF, 0x4C, 0xD3,
  // ";" (U+003B)
  0x18, 0x5C, 0xD3, 0x0E, 0xF4, 0x20, 0x17, 0x78, 0x94, 0xDF, 0x30, 0xFE, 0x03, 0xF9, 0x06, 0xF3,
  0x10,
  // "<" (U+003C)
  0x70, 0x25, 0x81, 0x2A, 0xE3, 0x89, 0x42, 0xAF, 0xE8, 0x02, 0xAF, 0xE7, 0x10, 0x4A, 0x07, 0x40,
  0x20, 0xAA, 0x09, 0x03, 0x48, 0x42, 0x8E, 0xFC, 0x65, 0x81, 0x7D, 0xE7, 0x04,
  // "=" (U+003D)
  0x04, 0x80, 0x2B, 0x0A, 0x05, 0xE0, 0xE7, 0x10, 0x48, 0x02, 0xB0, 0xA0, 0x5E, 0x0E,
  // ">" (U+003E)
  0x01, 0x78, 0x15, 0xE6, 0x58, 0x32, 0xCF, 0xE7, 0x58, 0x33, 0xAF, 0xE7, 0x58, 0x22, 0xCF, 0xD3,
  0x89, 0x16, 0xCF, 0xE7, 0x19, 0xEF, 0xC5, 0x28, 0x25, 0xFA, 0x44, 0x00, 0x26,
  // "?" (U+003F)
  0x89, 0x14, 0xAD, 0xFD, 0x80, 0x9F, 0xDB, 0xA8, 0x18, 0x12, 0x28, 0x16, 0xFB, 0x48, 0x1B, 0xF7,
  0x28, 0x22, 0xDF, 0x83, 0x81, 0xCF, 0x54, 0x00, 0xA7, 0x48, 0x21, 0xEF, 0x33, 0x82, 0x1C, 0xD2,
  0x20,
  // "@" (U+0040)
  0x48, 0x57, 0xCE, 0xED, 0x81, 0x48, 0x90, 0x3D, 0xFE, 0xCB, 0xEF, 0xE4, 0x28, 0x98, 0x31, 0xEE,
  0x7A, 0xEE, 0xCB, 0xEE, 0x10, 0x9F, 0x4C, 0xFD, 0xBF, 0x94, 0xF6, 0x0E, 0xA4, 0xF9, 0x01, 0xF9,
  0x0E, 0x92, 0xF7, 0x7F, 0x30, 0x2F, 0x80, 0xEA, 0x3F, 0x65, 0xF7, 0x08, 0xF9, 0x4F, 0x71, 0xF8,
  0x0E, 0xB0, 0xCA, 0x89, 0x4E, 0x10, 0xDE, 0x12, 0x9A, 0x41, 0x9A, 0x22, 0x89, 0x05, 0xFD, 0x62,
  0x01, 0x36, 0x14, 0x06, 0xF0, 0x15, 0x85, 0x16, 0x9B, 0x97, 0x23,
  // "A" (U+0041)
  0x30, 0x6A, 0x0B, 0x78, 0x3C, 0xFE, 0xF2, 0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD,
  0x58, 0x5E, 0xF4, 0x0E, 0xF4, 0x38, 0x14, 0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A,
  0x0D, 0x0F, 0xCA, 0x83, 0x60, 0x6F, 0xE4, 0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x04, 0xA0, 0x20,
  // "B" (U+0042)
  0x0A, 0xB8, 0x90, 0xED, 0x91, 0x0A, 0xFD, 0xBC, 0xA8, 0x3B, 0x0A, 0xF9, 0x20, 0x6A, 0x18, 0x1A,
  0xF9, 0x28, 0x39, 0xFC, 0x0A, 0xD8, 0x6C, 0x20, 0xAF, 0xDB, 0xCA, 0x83, 0x90, 0xAF, 0x92, 0x03,
  0xA8, 0x23, 0xAF, 0x92, 0x03, 0xA8, 0x43, 0xAF, 0xDB, 0xCA, 0x81, 0xD0, 0xAC, 0x81, 0xD8, 0x11,
  // "C" (U+0043)
  0x38, 0x47, 0xCE, 0xEC, 0x72, 0x0C, 0xA8, 0x7C, 0xDF, 0xA0, 0x8F, 0xE2, 0x28, 0x41, 0x20, 0xEF,
  0x75, 0x01, 0xA0, 0x45, 0x01, 0xA0, 0x36, 0x81, 0xEF, 0x66, 0x82, 0xAF, 0xD2, 0x38, 0x21, 0x01,
  0xEA, 0x82, 0xCC, 0xE9, 0x28, 0x51, 0x9D, 0xFE, 0xC5,
  // "D" (U+0044)
  0x0A, 0xB8, 0x1E, 0xC7, 0x38, 0x3A, 0xFD, 0xBD, 0xA8, 0x4C, 0x10, 0xAF, 0x92, 0x86, 0x2D, 0xFA,
  0x0A, 0xF9, 0x30, 0x5A, 0x18, 0x1A, 0xF9, 0x30, 0x2A, 0x82, 0x2A, 0xF9, 0x30, 0x3A, 0x82, 0x2A,
  0xF9, 0x30, 0x6A, 0x18, 0x1A, 0xF9, 0x28, 0x90, 0x3E, 0xF9, 0x0A, 0xFD, 0xBD, 0xA8, 0x2C, 0x10,
  0xAB, 0x81, 0xEB, 0x63,
  // "E" (U+0045)
  0x0A, 0xD8, 0x91, 0x8A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A,
  0xFD, 0xBB, 0xB2, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "F" (U+0046)
  0x0A, 0xD8, 0x91, 0x7A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB,
  0x2A, 0xD8, 0x23, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94,
  // "G" (U+0047)
  0x38, 0x55, 0xBE, 0xFD, 0xB4, 0x20, 0xBA, 0x85, 0xDB, 0xDF, 0x30, 0x8A, 0x05, 0x30, 0x12, 0x81,
  0xEF, 0x86, 0x01, 0xA8, 0x14, 0x09, 0xB0, 0xA0, 0x1A, 0x89, 0x13, 0x06, 0xBD, 0xFA, 0x0E, 0xF6,
  0x38, 0x68, 0xFA, 0x09, 0xFE, 0x22, 0x84, 0x8F, 0xA0, 0x1D, 0xA8, 0x3C, 0xBE, 0xFA, 0x28, 0x61,
  0x8D, 0xFE, 0xDB, 0x50,
  // "H" (U+0048)
  0x81, 0xAF, 0x93, 0x02, 0xA8, 0x21, 0xAF, 0x93, 0x02, 0xA8, 0x21, 0xAF, 0x93, 0x02, 0xA8, 0x21,
  0xAF, 0x93, 0x02, 0xA0, 0x10, 0xAF, 0x98, 0x21, 0xAF, 0xD8, 0x00, 0xBA, 0x82, 0x1A, 0xF9, 0x30,
  0x2A, 0x82, 0x1A, 0xF9, 0x30, 0x2A, 0x82, 0x1A, 0xF9, 0x30, 0x2A, 0x82, 0x1A, 0xF9, 0x30, 0x2A,
  0x01,
  // "I" (U+0049)
  0x08, 0xC8, 0x15, 0x2B, 0xA8, 0x29, 0x10, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A,
  0x30, 0x3A, 0x20, 0x20, 0xAA, 0x81, 0x91, 0x8C, 0x05,
  // "J" (U+004A)
  0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38,
  0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x1A, 0xF9, 0x38, 0x4D,
  0xF7, 0x1B, 0xDA, 0x84, 0x21, 0xEF, 0xC4, 0x10,
  // "K" (U+004B)
  0x81, 0xAF, 0x92, 0x85, 0x1E, 0xF7, 0xAF, 0x92, 0x89, 0x1C, 0xFA, 0x0A, 0xF9, 0x0A, 0xFC, 0x28,
  0x5A, 0xF9, 0x8F, 0xD1, 0x28, 0x1A, 0xFD, 0xA0, 0x53, 0x0A, 0xA8, 0x1E, 0xFD, 0x38, 0x5A, 0xFB,
  0x1D, 0xF9, 0x28, 0x3A, 0xF9, 0x04, 0xA8, 0x34, 0x0A, 0xF9, 0x28, 0x59, 0xFD, 0x0A, 0xF9, 0x28,
  0x21, 0xDF, 0x90,
  // "L" (U+004C)
  0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81,
  0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xEC, 0xCC, 0xCA, 0xE0,
  // "M" (U+004D)
  0x0A, 0xA0, 0x94, 0x07, 0xA8, 0x3C, 0xAF, 0xEE, 0x40, 0xCA, 0x84, 0xCA, 0xFB, 0xF4, 0x28, 0x90,
  0x2F, 0xDF, 0xCA, 0xF7, 0xF9, 0x28, 0x90, 0x8F, 0x8F, 0xCA, 0xF5, 0xCE, 0x28, 0xD4, 0xDD, 0x4F,
  0xCA, 0xF5, 0x7F, 0x33, 0xF8, 0x4F, 0xCA, 0xF5, 0x3F, 0x99, 0xF3, 0x4F, 0xCA, 0xF5, 0x0D, 0xEE,
  0xD0, 0x4F, 0xCA, 0xF5, 0x09, 0xA8, 0x90, 0x70, 0x4F, 0xCA, 0xF5, 0x04, 0xA8, 0x32, 0x04, 0xFC,
  // "N" (U+004E)
  0x0A, 0xA0, 0x83, 0x82, 0x2F, 0xDA, 0xB0, 0x22, 0x86, 0x2F, 0xDA, 0xFD, 0xFB, 0x28, 0xC4, 0x2F,
  0xDA, 0xF6, 0xEF, 0x50, 0x2F, 0xDA, 0xF5, 0x7F, 0xE1, 0x2F, 0xDA, 0xF5, 0x0C, 0xF9, 0x2F, 0xDA,
  0xF5, 0x03, 0xA8, 0x45, 0xFD, 0xAF, 0x52, 0x86, 0x9F, 0xEF, 0xDA, 0xF5, 0x30, 0xEA, 0x82, 0xDA,
  0xF5, 0x30, 0x5A, 0x0D,
  // "O" (U+004F)
  0x38, 0x48, 0xCE, 0xEC, 0x73, 0x01, 0x0D, 0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63,
  0xEF, 0x80, 0xEF, 0x74, 0x82, 0x8F, 0xD1, 0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18,
  0x1E, 0xF7, 0x48, 0x68, 0xFD, 0x09, 0xFE, 0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C,
  0x48, 0x48, 0xDE, 0xEC, 0x72,
  // "P" (U+0050)
  0x0A, 0xB8, 0x7E, 0xC5, 0x0A, 0xFD, 0xBD, 0xA8, 0x25, 0xAF, 0x92, 0x84, 0xAF, 0xAA, 0xF9, 0x28,
  0x6B, 0xFA, 0xAF, 0xDB, 0xDA, 0x04, 0x0A, 0xB8, 0x5E, 0xB4, 0x0A, 0xF9, 0x58, 0x1A, 0xF9, 0x58,
  0x1A, 0xF9, 0x58, 0x1A, 0xF9, 0x50,
  // "Q" (U+0051)
  0x38, 0x48, 0xCE, 0xEC, 0x73, 0x01, 0x0D, 0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63,
  0xEF, 0x80, 0xEF, 0x74, 0x82, 0x8F, 0xD1, 0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18,
  0x1E, 0xF7, 0x48, 0x68, 0xFD, 0x09, 0xFE, 0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C,
  0x48, 0x18, 0xDE, 0xA0, 0xB7, 0x10, 0x7A, 0x04, 0x71, 0x82, 0xAF, 0xE3, 0x71, 0x81, 0x77, 0x60,
  // "R" (U+0052)
  0x0A, 0xB8, 0x1E, 0xB5, 0x28, 0x3A, 0xFD, 0xBD, 0xA8, 0x35, 0x0A, 0xF9, 0x28, 0x5B, 0xFA, 0x0A,
  0xF9, 0x28, 0x94, 0xBF, 0xA0, 0xAF, 0xDB, 0xDF, 0xE2, 0x0A, 0xC0, 0xE0, 0x12, 0x85, 0xAF, 0x90,
  0xCF, 0x72, 0x83, 0xAF, 0x90, 0x3A, 0x83, 0x20, 0xAF, 0x92, 0x85, 0x9F, 0xC0, 0xAF, 0x93, 0x81,
  0xDF, 0x80,
  // "S" (U+0053)
  0x18, 0x96, 0x19, 0xDF, 0xDA, 0x30, 0xCF, 0xEB, 0xDF, 0x31, 0xA0, 0x22, 0x02, 0x2A, 0x08, 0x50,
  0x6A, 0x0E, 0x07, 0x40, 0x30, 0xBA, 0x0D, 0x01, 0x48, 0x43, 0xDF, 0x82, 0x33, 0x86, 0xAF, 0x94,
  0xFE, 0xCC, 0xA8, 0x64, 0x2A, 0xDF, 0xEB, 0x41,
  // "T" (U+0054)
  0x0A, 0xF8, 0x90, 0x68, 0xBB, 0xEF, 0xDB, 0xB4, 0x38, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C,
  0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7,
  0x30,
  // "U" (U+0055)
  0x81, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21,
  0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF,
  0x93, 0x04, 0xA1, 0x82, 0x8F, 0xE1, 0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85,
  0x29, 0xDF, 0xEB, 0x42,
  // "V" (U+0056)
  0x81, 0xCF, 0x74, 0x84, 0xBF, 0x87, 0xFC, 0x30, 0x1A, 0x03, 0x01, 0xA0, 0x22, 0x81, 0x6F, 0xD2,
  0x81, 0xBF, 0x72, 0x81, 0xBF, 0x72, 0x83, 0x5F, 0xC0, 0x1A, 0x01, 0x38, 0x4E, 0xF2, 0x6F, 0xB4,
  0x84, 0xAF, 0x7B, 0xF5, 0x48, 0x34, 0xFB, 0xEE, 0x60, 0xEA, 0x0A, 0x60, 0x8A, 0x04, 0x30,
  // "W" (U+0057)
  0x81, 0xDF, 0x53, 0x81, 0xEF, 0x73, 0x84, 0xDF, 0x59, 0xF9, 0x20, 0x3A, 0x0B, 0x20, 0x1A, 0x82,
  0x15, 0xFD, 0x28, 0x17, 0xFE, 0x92, 0x81, 0x5F, 0xC2, 0xA8, 0x91, 0x10, 0xCF, 0x9F, 0x40, 0x9F,
  0x82, 0x89, 0x3C, 0xF5, 0x1F, 0xC5, 0xF9, 0x0D, 0xF4, 0x28, 0x90, 0x7F, 0x95, 0xF8, 0x1F, 0xD1,
  0xA3, 0x89, 0x23, 0xFD, 0x9F, 0x40, 0xCF, 0x6F, 0xB4, 0x81, 0xEF, 0xC9, 0x28, 0x37, 0xFC, 0xF7,
  0x40, 0xAA, 0x0B, 0x20, 0x3B, 0x02, 0x40, 0x6A, 0x07, 0x38, 0x1E, 0xFE, 0x30,
  // "X" (U+0058)
  0x82, 0x6F, 0xE1, 0x28, 0x61, 0xEF, 0x60, 0xBF, 0xA2, 0x81, 0x9F, 0xB2, 0x86, 0x1E, 0xF5, 0x3F,
  0xE1, 0x38, 0x45, 0xFD, 0xDF, 0x55, 0x0A, 0xA0, 0xB6, 0x0D, 0xA0, 0xB5, 0x84, 0x8F, 0xBD, 0xF7,
  0x38, 0x34, 0xFE, 0x23, 0xA8, 0x43, 0x01, 0xDF, 0x62, 0x85, 0x9F, 0xD0, 0xAF, 0xB4, 0x81, 0xDF,
  0x90,
  // "Y" (U+0059)
  0x81, 0xBF, 0xA3, 0x83, 0x5F, 0xE1, 0x2A, 0x03, 0x28, 0x1C, 0xF7, 0x28, 0x58, 0xFB, 0x05, 0xFD,
  0x38, 0x51, 0xEF, 0x3D, 0xF5, 0x48, 0x36, 0xFE, 0xFB, 0x60, 0xCA, 0x02, 0x68, 0x16, 0xFC, 0x78,
  0x16, 0xFC, 0x78, 0x16, 0xFC, 0x78, 0x16, 0xFC, 0x40,
  // "Z" (U+005A)
  0x07, 0xF8, 0x90, 0x25, 0xBB, 0xBB, 0xDF, 0xE1, 0x48, 0x22, 0xEF, 0x55, 0x81, 0xCF, 0x95, 0x81,
  0x8F, 0xC5, 0x82, 0x4F, 0xE2, 0x48, 0x21, 0xEF, 0x55, 0x81, 0xCF, 0x95, 0x07, 0xA8, 0x5C, 0xBB,
  0xBB, 0x39, 0xF0, 0x50,
  // "[" (U+005B)
  0x0E, 0xA8, 0x59, 0xEF, 0xB6, 0xEE, 0x20, 0x0E, 0x20, 0x0E, 0x20, 0x0E, 0x20, 0x0E, 0x20, 0x0E,
  0x20, 0x0E, 0x20, 0x0E, 0x20, 0x0E, 0x28, 0x3E, 0xFB, 0x6E, 0xA0, 0x90,
  // "\" (U+005C)
  0x81, 0xBF, 0x43, 0x81, 0x4F, 0xB4, 0x81, 0xDF, 0x13, 0x81, 0x8F, 0x73, 0x81, 0x1F, 0xD4, 0x81,
  0xBF, 0x43, 0x81, 0x5F, 0xB4, 0x81, 0xEF, 0x13, 0x81, 0x8F, 0x73, 0x81, 0x2F, 0xD0,
  // "]" (U+005D)
  0x09, 0xA8, 0x3E, 0x7B, 0xFE, 0x29, 0x0E, 0x29, 0x0E, 0x29, 0x0E, 0x29, 0x0E, 0x29, 0x0E, 0x29,
  0x0E, 0x29, 0x0E, 0x29, 0x0E, 0x29, 0x84, 0xE7, 0xBF, 0xE9, 0xA0, 0xE0,
  // "^" (U+005E)
  0x30, 0x40, 0x56, 0x81, 0xDF, 0x24, 0x82, 0x6F, 0xEB, 0x48, 0x3D, 0xB6, 0xF4, 0x28, 0x46, 0xF3,
  0x0D, 0xC2, 0x0D, 0x0B, 0x28, 0x45, 0xF6, 0x6F, 0x43, 0x0C, 0x0E,
  // "_" (U+005F)
  0xE0, 0x20,
  // "`" (U+0060)
  0x82, 0x27, 0x72, 0x28, 0x17, 0xFC, 0x38, 0x15, 0xE8,
  // "a" (U+0061)
  0x18, 0x43, 0x9D, 0xFD, 0x92, 0x85, 0x3F, 0xDB, 0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE,
  0xB0, 0xE0, 0x2A, 0x84, 0x50, 0x4F, 0xE5, 0xA2, 0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0,
  0x6D, 0xFB, 0x2C, 0xE0,
  // "b" (U+0062)
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x87, 0xCF, 0x6B, 0xFD, 0x50, 0xCA, 0x00,
  0xDA, 0x82, 0x3C, 0xFA, 0x28, 0x4C, 0xF9, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF7, 0x28, 0x47, 0xFB,
  0xCF, 0xB2, 0x82, 0xCF, 0x9C, 0xA0, 0x0D, 0xA8, 0x63, 0xCF, 0x3C, 0xFD, 0x51,
  // "c" (U+0063)
  0x28, 0x67, 0xDF, 0xEA, 0x10, 0x9A, 0x83, 0xCD, 0xD0, 0x1A, 0x05, 0x40, 0x4A, 0x50, 0x4A, 0x50,
  0x2A, 0x05, 0x20, 0x22, 0x0B, 0xA0, 0xC0, 0xD9, 0x38, 0x38, 0xDF, 0xE9, 0x10,
  // "d" (U+0064)
  0x68, 0x1E, 0xF5, 0x68, 0x1E, 0xF5, 0x68, 0x94, 0xDF, 0x50, 0x1A, 0xEE, 0x6D, 0xF5, 0x0A, 0xA0,
  0xC0, 0xEA, 0x05, 0x01, 0xA8, 0x14, 0x02, 0xA0, 0x50, 0x4A, 0x38, 0x2C, 0xF5, 0x4A, 0x38, 0x2C,
  0xF5, 0x2A, 0x86, 0x40, 0x1E, 0xF5, 0x0B, 0xA0, 0xC0, 0xEA, 0x89, 0x05, 0x01, 0xAE, 0xD5, 0x8F,
  0x50,
  // "e" (U+0065)
  0x28, 0x37, 0xDF, 0xD7, 0x38, 0x79, 0xFE, 0xBE, 0xF8, 0x01, 0xA8, 0x52, 0x01, 0xEF, 0x04, 0xF0,
  0x20, 0x4A, 0x80, 0x1B, 0x02, 0x01, 0xA0, 0x33, 0x01, 0x20, 0x9A, 0x82, 0xCB, 0xDB, 0x30, 0x60,
  0xCA, 0x0C, 0x06, 0x10,
  // "f" (U+0066)
  0x28, 0x58, 0xDF, 0xD4, 0x04, 0xA8, 0x5C, 0xC1, 0x07, 0xFC, 0x30, 0x50, 0xEB, 0x86, 0xA0, 0x8D,
  0xFE, 0xB8, 0x28, 0x17, 0xFB, 0x48, 0x17, 0xFB, 0x48, 0x17, 0xFB, 0x48, 0x17, 0xFB, 0x48, 0x17,
  0xFB, 0x48, 0x17, 0xFB, 0x30,
  // "g" (U+0067)
  0x18, 0x90, 0x1A, 0xEE, 0x7A, 0xF5, 0x0A, 0xA0, 0xC0, 0xEA, 0x05, 0x01, 0xA8, 0x14, 0x01, 0xA0,
  0x50, 0x4A, 0x38, 0x2C, 0xF5, 0x4A, 0x38, 0x2C, 0xF5, 0x2A, 0x86, 0x40, 0x1E, 0xF5, 0x0B, 0xA0,
  0xC0, 0xEA, 0x89, 0x05, 0x01, 0xBF, 0xD6, 0xEF, 0x55, 0x02, 0xA8, 0x73, 0x0C, 0xDC, 0xBE, 0xFC,
  0x28, 0x58, 0xDE, 0xED, 0x81, 0x10,
  // "h" (U+0068)
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x87, 0xCF, 0x7B, 0xFD, 0x80, 0xCA, 0x0D,
  0x0C, 0xA8, 0x26, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F,
  0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x17, 0xFB,
  // "i" (U+0069)
  0x84, 0xBE, 0x57, 0xA3, 0x38, 0xA6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF,
  0x6C, 0xF6,
  // "j" (U+006A)
  0x28, 0x1B, 0xE5, 0x28, 0x17, 0xA3, 0x78, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28,
  0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x3D,
  0xF6, 0xBD, 0xA8, 0x32, 0xDF, 0xD6, 0x10,
  // "k" (U+006B)
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x8A, 0x4C, 0xF6, 0x01, 0xCF, 0x9C, 0xF6,
  0x0C, 0xFA, 0x0C, 0xF6, 0xBF, 0xB2, 0x81, 0xCF, 0xDA, 0x01, 0x20, 0xCA, 0x81, 0xEF, 0x92, 0x8A,
  0x1C, 0xF8, 0x2E, 0xF5, 0x0C, 0xF6, 0x05, 0xFE, 0x2C, 0xF6, 0x28, 0x1A, 0xFD,
  // "l" (U+006C)
  0x8B, 0x7C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF,
  0x6C, 0xF6,
  // "m" (U+006D)
  0x89, 0x4C, 0xF4, 0xCE, 0xE8, 0x3B, 0xED, 0x80, 0xCA, 0x00, 0xDB, 0x0D, 0x0C, 0xA8, 0x25, 0xCF,
  0xB2, 0x81, 0xDF, 0xC2, 0x84, 0xCF, 0x8C, 0xF7, 0x28, 0x1B, 0xF8, 0x28, 0x49, 0xF9, 0xCF, 0x62,
  0x81, 0xBF, 0x72, 0x84, 0x9F, 0x9C, 0xF6, 0x28, 0x1B, 0xF7, 0x28, 0x49, 0xF9, 0xCF, 0x62, 0x81,
  0xBF, 0x72, 0x84, 0x9F, 0x9C, 0xF6, 0x28, 0x1B, 0xF7, 0x28, 0x19, 0xF9,
  // "n" (U+006E)
  0x89, 0x3C, 0xF3, 0xBF, 0xD8, 0x0C, 0xFE, 0xDC, 0xA8, 0x26, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7,
  0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F,
  0xBC, 0xF6, 0x28, 0x17, 0xFB,
  // "o" (U+006F)
  0x28, 0x47, 0xDF, 0xD9, 0x12, 0x09, 0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A,
  0x38, 0x2B, 0xF8, 0x4A, 0x38, 0x2B, 0xF8, 0x1A, 0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF,
  0xD3, 0x84, 0x6D, 0xFE, 0x91, 0x10,
  // "p" (U+0070)
  0x89, 0x3C, 0xF2, 0xBF, 0xD5, 0x0C, 0xFE, 0xDD, 0xA8, 0x23, 0xCF, 0xA2, 0x84, 0xBF, 0x9C, 0xF6,
  0x28, 0x47, 0xFB, 0xCF, 0x72, 0x84, 0x7F, 0xBC, 0xFB, 0x28, 0x2C, 0xF9, 0xCA, 0x00, 0xDA, 0x89,
  0x22, 0xCF, 0x7C, 0xFD, 0x50, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65,
  // "q" (U+0071)
  0x18, 0x90, 0x1A, 0xEE, 0x6A, 0xF5, 0x0A, 0xA0, 0xC0, 0xEA, 0x05, 0x01, 0xA8, 0x14, 0x01, 0xA0,
  0x50, 0x4A, 0x38, 0x2C, 0xF5, 0x4A, 0x38, 0x2C, 0xF5, 0x2A, 0x86, 0x40, 0x1E, 0xF5, 0x0B, 0xA0,
  0xC0, 0xEA, 0x89, 0x05, 0x01, 0xAE, 0xD5, 0xDF, 0x56, 0x81, 0xEF, 0x56, 0x81, 0xEF, 0x56, 0x81,
  0xEF, 0x50,
  // "r" (U+0072)
  0x89, 0x6C, 0xE2, 0xAF, 0x6C, 0xFE, 0xEC, 0x4C, 0xFC, 0x12, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63,
  0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63,
  // "s" (U+0073)
  0x18, 0x55, 0xCE, 0xEB, 0x52, 0xA8, 0x3C, 0xCF, 0x73, 0xA8, 0x12, 0x01, 0x20, 0xAA, 0x0B, 0x04,
  0x30, 0x40, 0xAA, 0x81, 0x71, 0x12, 0x89, 0x76, 0xFD, 0x4F, 0xDB, 0xEF, 0xA2, 0xBE, 0xFD, 0x91,
  // "t" (U+0074)
  0x20, 0x60, 0x53, 0x81, 0x2F, 0x92, 0x04, 0x0D, 0xB8, 0x91, 0xE7, 0xDF, 0xEB, 0xA0, 0x9F, 0x93,
  0x81, 0x9F, 0x93, 0x81, 0x9F, 0x93, 0x81, 0x9F, 0xA3, 0x06, 0xA0, 0x0C, 0x28, 0x2A, 0xEE, 0xC0,
  // "u" (U+0075)
  0x81, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5,
  0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x9F, 0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87,
  0xA1, 0x9E, 0xEB, 0x5F, 0xA0,
  // "v" (U+0076)
  0x81, 0xCF, 0x73, 0x84, 0xEF, 0x56, 0xFD, 0x28, 0x92, 0x5F, 0xE0, 0x1E, 0xF3, 0x0A, 0xF8, 0x28,
  0x59, 0xF8, 0x0E, 0xF2, 0x28, 0x43, 0xFD, 0x5F, 0xC4, 0x83, 0xDF, 0xBF, 0x64, 0x07, 0xA0, 0xE5,
  0x01, 0xA0, 0x93,
  // "w" (U+0077)
  0x81, 0xAF, 0x72, 0x81, 0xEF, 0xC2, 0x89, 0x09, 0xF8, 0x6F, 0xB0, 0x2F, 0xE9, 0x28, 0x2E, 0xF3,
  0x1A, 0x18, 0x67, 0xF8, 0xF4, 0x2F, 0xE2, 0x89, 0x1D, 0xF4, 0xBE, 0x2F, 0x87, 0xFA, 0x28, 0x91,
  0x8F, 0x7E, 0xA0, 0xDB, 0xAF, 0x52, 0x89, 0x14, 0xFB, 0xF7, 0x0A, 0xED, 0xF1, 0x30, 0xEA, 0x81,
  0x30, 0x6A, 0x0B, 0x40, 0xAA, 0x20, 0x3A, 0x07, 0x20,
  // "x" (U+0078)
  0x84, 0x7F, 0xE1, 0x05, 0xA8, 0x72, 0x0B, 0xFA, 0x1E, 0xF7, 0x28, 0x42, 0xEF, 0xCF, 0xB4, 0x06,
  0xA0, 0xE0, 0x24, 0x08, 0xB0, 0x33, 0x03, 0xA8, 0x1A, 0xFD, 0x38, 0x91, 0xDF, 0x80, 0xDF, 0x80,
  0x9F, 0xD2, 0x03, 0xA0, 0x30,
  // "y" (U+0079)
  0x81, 0xCF, 0x92, 0x01, 0xA8, 0x25, 0x5F, 0xE2, 0x81, 0x6F, 0xE2, 0x85, 0xEF, 0x50, 0xBF, 0x82,
  0x82, 0x7F, 0xA1, 0xA0, 0x22, 0x01, 0xA8, 0x17, 0xFB, 0x48, 0x39, 0xFE, 0xF4, 0x40, 0x3A, 0x0D,
  0x68, 0x1D, 0xF7, 0x50, 0x3A, 0x01, 0x30, 0x50, 0xBA, 0x08, 0x48, 0x27, 0xFD, 0x75,
  // "z" (U+007A)
  0x05, 0xD0, 0xB0, 0x40, 0xFB, 0xA0, 0x93, 0x82, 0x6F, 0xD1, 0x20, 0x2A, 0x03, 0x38, 0x1D, 0xF6,
  0x38, 0x1A, 0xF9, 0x30, 0x6A, 0x83, 0xCB, 0xB9, 0x9D, 0x0D,
  // "{" (U+007B)
  0x28, 0x24, 0xCE, 0x42, 0x82, 0xDF, 0xE3, 0x28, 0x1E, 0xF1, 0x30, 0xE9, 0x30, 0x1A, 0x28, 0x29,
  0xEF, 0x92, 0x82, 0xCF, 0xC4, 0x38, 0x15, 0xFE, 0x40, 0xE9, 0x40, 0xE9, 0x48, 0x1D, 0xF4, 0x30,
  0xBA, 0x04, 0x28, 0x21, 0x8A, 0x30,
  // "|" (U+007C)
  0x8B, 0x2A, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xE0,
  // "}" (U+007D)
  0x82, 0x6E, 0xC3, 0x28, 0x24, 0xEF, 0xB3, 0x81, 0x2F, 0xC3, 0x81, 0x1F, 0xC3, 0x81, 0x1F, 0xE4,
  0x82, 0xAF, 0xE8, 0x28, 0x46, 0xDF, 0xA0, 0x1A, 0x04, 0x28, 0x11, 0xFC, 0x38, 0x11, 0xFC, 0x38,
  0x15, 0xFC, 0x20, 0x6A, 0x0A, 0x28, 0x24, 0xA8, 0x12,
  // "~" (U+007E)
  0x18, 0x26, 0xA8, 0x32, 0x04, 0x05, 0xC8, 0x91, 0xDC, 0xE4, 0x50, 0x4A, 0xEE, 0x60,
  // "¡" (U+00A1)
  0x18, 0x5C, 0xD3, 0x0E, 0xF4, 0x20, 0x12, 0x0C, 0x92, 0x89, 0x1D, 0xF1, 0x0E, 0xF2, 0x0E, 0xF3,
  0x1A, 0x03, 0x01, 0xA0, 0x40, 0x1A, 0x05,
  // "¢" (U+00A2)
  0x30, 0xD0, 0x63, 0x85, 0x3A, 0xFE, 0xB4, 0x4A, 0x85, 0xEE, 0xF4, 0xBF, 0xB2, 0x83, 0x20, 0xEF,
  0x54, 0x81, 0xDF, 0x64, 0x87, 0xAF, 0xC1, 0x03, 0x23, 0xEC, 0x86, 0x50, 0x28, 0xEC, 0x81, 0x30,
  0xD0, 0x62,
  // "£" (U+00A3)
  0x28, 0x41, 0xAE, 0xEC, 0x83, 0x84, 0xCF, 0xEC, 0xE9, 0x3A, 0x03, 0x50, 0x1A, 0x01, 0x40, 0x6D,
  0x0D, 0x20, 0x40, 0xBA, 0x81, 0xBB, 0x93, 0x01, 0xA0, 0x15, 0x81, 0x4F, 0xC5, 0x04, 0xA8, 0x5C,
  0xBB, 0xBB, 0x36, 0xF0, 0x40,
  // "¤" (U+00A4)
  0x02, 0x01, 0x38, 0xD4, 0x30, 0xDC, 0xCE, 0xAF, 0x77, 0xFE, 0xCF, 0xE1, 0x8F, 0x10, 0x7F, 0x18,
  0xF1, 0x07, 0xF1, 0x7F, 0xEC, 0xFE, 0x1D, 0xDD, 0xEB, 0xF7, 0x21, 0x30, 0x31,
  // "¥" (U+00A5)
  0x81, 0xAF, 0x83, 0x84, 0xEF, 0x32, 0xFE, 0x28, 0x17, 0xFA, 0x28, 0x58, 0xF6, 0x0D, 0xF2, 0x28,
  0x41, 0xED, 0x5F, 0x84, 0x82, 0x7F, 0xEE, 0x40, 0x9D, 0x01, 0x28, 0x56, 0xBE, 0xFC, 0xB1, 0x20,
  0x9D, 0x01, 0x28, 0x56, 0xBE, 0xFC, 0xB1, 0x48, 0x1C, 0xF5, 0x30,
  // "¦" (U+00A6)
  0x89, 0x2A, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xE4, 0x89, 0x2A, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xE0,
  // "§" (U+00A7)
  0x18, 0x96, 0x3B, 0xED, 0xA2, 0x0E, 0xFB, 0xDF, 0x30, 0xFC, 0x20, 0x22, 0x83, 0x7F, 0xE8, 0x12,
  0x8A, 0x2C, 0xD8, 0xEE, 0x21, 0xFA, 0x03, 0xF8, 0x08, 0xFC, 0xAF, 0x32, 0x85, 0x29, 0xEE, 0x21,
  0x12, 0x89, 0x65, 0xF7, 0x3F, 0xDB, 0xEF, 0x51, 0x9D, 0xFD, 0x61,
  // "¨" (U+00A8)
  0x89, 0x07, 0x90, 0x88, 0xBD, 0x0C, 0xD0,
  // "©" (U+00A9)
  0x38, 0x53, 0xAE, 0xFD, 0x71, 0x48, 0x77, 0xD5, 0x10, 0x39, 0xD2, 0x28, 0x90, 0x5C, 0x04, 0xCF,
  0xD2, 0x7D, 0x28, 0x5D, 0x31, 0xE6, 0x03, 0x28, 0x5C, 0x52, 0xD0, 0x7D, 0x58, 0x56, 0x93, 0xC0,
  0x8B, 0x58, 0x55, 0xB2, 0xD0, 0x6C, 0x58, 0x90, 0x6A, 0x0D, 0x31, 0xF5, 0x02, 0x28, 0x93, 0xC6,
  0x06, 0xC0, 0x4C, 0xFD, 0x06, 0xD3, 0x87, 0x9D, 0x51, 0x03, 0x9E, 0x24, 0x85, 0x4B, 0xEF, 0xD8,
  0x12,
  // "ª" (U+00AA)
  0x83, 0x2B, 0xEE, 0x62, 0x8A, 0x05, 0x19, 0xF0, 0x2B, 0xEE, 0xF1, 0x9E, 0x29, 0xF1, 0x4A, 0x81,
  0x9F, 0x14, 0x01, 0x10,
  // "«" (U+00AB)
  0x30, 0x52, 0x01, 0x04, 0x38, 0xA5, 0x8F, 0x90, 0xCF, 0x50, 0x5F, 0xD1, 0x9F, 0xA0, 0x2E, 0xF3,
  0x6F, 0xD2, 0x86, 0x1D, 0xF5, 0x4F, 0xE2, 0x20, 0x3A, 0x82, 0x37, 0xFC, 0x38, 0x55, 0xF8, 0x0A,
  0xE4, 0x30, 0x23, 0x01, 0x10,
  // "¬" (U+00AC)
  0x04, 0x80, 0x2B, 0x0A, 0x05, 0xE0, 0xE6, 0x0A, 0x0E, 0x60, 0xA0, 0xE6, 0x05, 0x06,
  // "®" (U+00AE)
  0x38, 0x53, 0xAE, 0xFD, 0x71, 0x48, 0x77, 0xD5, 0x10, 0x39, 0xD2, 0x28, 0x90, 0x5C, 0x0D, 0xFE,
  0xA0, 0x7D, 0x28, 0x93, 0xD3, 0x0D, 0x51, 0xD6, 0x0C, 0x52, 0xD2, 0x89, 0x0D, 0x51, 0xD5, 0x06,
  0x93, 0xC2, 0x0D, 0xA0, 0x92, 0x82, 0x5B, 0x2D, 0x28, 0x2D, 0x57, 0xC2, 0x8A, 0x76, 0xA0, 0xD3,
  0x0D, 0x50, 0xE5, 0x0C, 0x60, 0x6C, 0x09, 0x30, 0x59, 0x6D, 0x38, 0x79, 0xD5, 0x10, 0x39, 0xE2,
  0x48, 0x54, 0xBE, 0xFD, 0x81, 0x20,
  // "¯" (U+00AF)
  0x80, 0x3B, 0x06, 0xF0, 0x80,
  // "°" (U+00B0)
  0x18, 0xB3, 0x5D, 0xEA, 0x12, 0xFE, 0xCF, 0x96, 0xF2, 0x0B, 0xC3, 0xFE, 0xCF, 0x90, 0x5D, 0xEA,
  0x10,
  // "±" (U+00B1)
  0x38, 0x18, 0xF1, 0x58, 0x18, 0xF1, 0x28, 0x74, 0xBB, 0xDF, 0xBB, 0xA5, 0xE0, 0xE3, 0x81, 0x8F,
  0x15, 0x81, 0x8F, 0x15, 0x81, 0x8F, 0x12, 0x04, 0x80, 0x2B, 0x0A, 0x05, 0xE0, 0xE0,
  // "²" (U+00B2)
  0x18, 0x13, 0x76, 0x20, 0x5B, 0x0B, 0x28, 0x26, 0x1D, 0xE3, 0x81, 0x4F, 0x82, 0x81, 0x4F, 0x92,
  0x85, 0x5F, 0xE8, 0x81, 0x9C, 0x02,
  // "³" (U+00B3)
  0x89, 0x01, 0xAF, 0xD3, 0x3D, 0x9E, 0xC3, 0x8A, 0x4D, 0xB0, 0x9F, 0xE2, 0x04, 0x8D, 0xC7, 0x98,
  0xDF, 0x4D, 0xFD, 0x50,
  // "´" (U+00B4)
  0x28, 0x91, 0x67, 0x50, 0x5F, 0xC1, 0x2E, 0xA2,
  // "µ" (U+00B5)
  0x81, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6,
  0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x8F, 0xBC, 0xF9, 0x28, 0x2D, 0xFB, 0xCA, 0x0C, 0x0D, 0xA8,
  0x92, 0xBC, 0xFC, 0xED, 0x4F, 0xBC, 0xF6, 0x58, 0x1C, 0xF6, 0x58, 0x1C, 0xF6, 0x50,
  // "¶" (U+00B6)
  0x18, 0x11, 0x9E, 0xC8, 0x18, 0x0A, 0xC8, 0x1C, 0xE8, 0x1D, 0x82, 0x29, 0x82, 0xD8, 0x22, 0x98,
  0x1D, 0x83, 0x29, 0x80, 0xEC, 0x83, 0x29, 0x80, 0x7C, 0x81, 0x29, 0x82, 0x85, 0x47, 0x7F, 0x29,
  0x85, 0x98, 0x12, 0x98, 0x59, 0x81, 0x29, 0x85, 0x98, 0x12, 0x98, 0x59, 0x81, 0x29, 0x85, 0x98,
  0x12, 0x98, 0x58, 0x23, 0x02, 0x10,
  // "·" (U+00B7)
  0x18, 0x61, 0x0E, 0xF4, 0xCD, 0x30,
  // "¸" (U+00B8)
  0x10, 0x20, 0x52, 0x81, 0xAF, 0x72, 0x81, 0xCF, 0x4A, 0x82, 0xA0, 0x21, 0x10,
  // "¹" (U+00B9)
  0x18, 0x94, 0x1B, 0xF4, 0x1D, 0xDF, 0x40, 0x47, 0xF4, 0x28, 0x17, 0xF4, 0x28, 0x17, 0xF4, 0x28,
  0x17, 0xF4,
  // "º" (U+00BA)
  0x18, 0xA7, 0x9E, 0xD6, 0x05, 0xF3, 0x6F, 0x28, 0xE0, 0x1F, 0x56, 0xF1, 0x4F, 0x30, 0xAA, 0x08,
  0x10,
  // "»" (U+00BB)
  0x10, 0x20, 0x32, 0x04, 0x01, 0x28, 0x52, 0xFE, 0x16, 0xFB, 0x38, 0x57, 0xFC, 0x0B, 0xF8, 0x38,
  0x5A, 0xFA, 0x1D, 0xF5, 0x28, 0xA5, 0xCF, 0x72, 0xEF, 0x30, 0xAF, 0xA1, 0xDF, 0x60, 0x2D, 0xC0,
  0x5F, 0x84, 0x01, 0x20, 0x13,
  // "¼" (U+00BC)
  0x18, 0x13, 0xDE, 0x38, 0x11, 0xEB, 0x30, 0x50, 0xFE, 0x38, 0x19, 0xF2, 0x48, 0x13, 0xCE, 0x28,
  0x13, 0xF8, 0x60, 0xC0, 0xE2, 0x0C, 0x0D, 0x78, 0x90, 0xCE, 0x06, 0xF5, 0x0A, 0xF6, 0x38, 0x90,
  0xCE, 0x1E, 0xB0, 0x5E, 0xF6, 0x58, 0x69, 0xF2, 0x1E, 0x8F, 0x64, 0x87, 0x2F, 0x80, 0xB8, 0x5F,
  0x64, 0x82, 0xBE, 0x12, 0xD0, 0x42, 0x81, 0x5F, 0x62, 0x83, 0x22, 0x7F, 0x71,
  // "½" (U+00BD)
  0x18, 0x13, 0xDE, 0x38, 0x11, 0xEB, 0x30, 0x50, 0xFE, 0x38, 0x19, 0xF2, 0x48, 0x13, 0xCE, 0x28,
  0x13, 0xF8, 0x60, 0xC0, 0xE2, 0x0C, 0x0D, 0x78, 0x91, 0xCE, 0x06, 0xF6, 0x9E, 0xFC, 0x12, 0x89,
  0x1C, 0xE1, 0xEB, 0x08, 0x69, 0xF5, 0x48, 0x19, 0xF2, 0x38, 0x1B, 0xD1, 0x38, 0x12, 0xF8, 0x28,
  0x21, 0xCC, 0x24, 0x89, 0x0B, 0xE1, 0x01, 0xDF, 0xCB, 0x62, 0x81, 0x5F, 0x62, 0x02, 0xC0, 0x80,
  // "¾" (U+00BE)
  0x83, 0x1A, 0xEE, 0x83, 0x81, 0x7F, 0x43, 0x81, 0x53, 0xB9, 0x28, 0x11, 0xEA, 0x40, 0x5A, 0x05,
  0x28, 0x1A, 0xE1, 0x58, 0x52, 0xAF, 0x24, 0xF7, 0x48, 0x95, 0x23, 0x07, 0xF4, 0xDD, 0x06, 0xF9,
  0x04, 0xEA, 0x86, 0xA7, 0xF4, 0x2E, 0xF9, 0x38, 0x90, 0x21, 0x1E, 0xA0, 0xC8, 0xF9, 0x58, 0x6A,
  0xF2, 0x7B, 0x1F, 0x94, 0x83, 0x3F, 0x70, 0xEC, 0x08, 0x30, 0xC0, 0xD2, 0x84, 0x22, 0x4F, 0xA1,
  // "¿" (U+00BF)
  0x28, 0x22, 0xDC, 0x13, 0x82, 0x3F, 0xE1, 0x74, 0x00, 0xA4, 0x81, 0x5F, 0xC3, 0x82, 0x8F, 0xD2,
  0x28, 0x27, 0xFB, 0x13, 0x81, 0xBF, 0x62, 0x89, 0x62, 0x18, 0xFE, 0xBD, 0xF9, 0x08, 0xDF, 0xDA,
  0x40,
  // "À" (U+00C0)
  0x28, 0x22, 0x77, 0x27, 0x18, 0x17, 0xFC, 0x72, 0x81, 0x5E, 0x87, 0x77, 0x71, 0x06, 0xA0, 0xB7,
  0x83, 0xCF, 0xEF, 0x25, 0x84, 0x2F, 0xE8, 0xF7, 0x58, 0x48, 0xF9, 0x3F, 0xD5, 0x85, 0xEF, 0x40,
  0xEF, 0x43, 0x81, 0x4F, 0xE2, 0x81, 0x9F, 0x93, 0x0A, 0xE0, 0xE2, 0x01, 0xA0, 0xD0, 0xFC, 0xA8,
  0x36, 0x06, 0xFE, 0x48, 0x59, 0xFC, 0x0C, 0xF9, 0x40, 0x4A, 0x02,
  // "Á" (U+00C1)
  0x58, 0x16, 0x75, 0x78, 0x25, 0xFC, 0x16, 0x81, 0x2E, 0xA7, 0x77, 0x72, 0x06, 0xA0, 0xB7, 0x83,
  0xCF, 0xEF, 0x25, 0x84, 0x2F, 0xE8, 0xF7, 0x58, 0x48, 0xF9, 0x3F, 0xD5, 0x85, 0xEF, 0x40, 0xEF,
  0x43, 0x81, 0x4F, 0xE2, 0x81, 0x9F, 0x93, 0x0A, 0xE0, 0xE2, 0x01, 0xA0, 0xD0, 0xFC, 0xA8, 0x36,
  0x06, 0xFE, 0x48, 0x59, 0xFC, 0x0C, 0xF9, 0x40, 0x4A, 0x02,
  // "Â" (U+00C2)
  0x38, 0x25, 0x77, 0x16, 0x83, 0x4F, 0xDF, 0xC5, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x70, 0x6A,
  0x0B, 0x78, 0x3C, 0xFE, 0xF2, 0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD, 0x58, 0x5E,
  0xF4, 0x0E, 0xF4, 0x38, 0x14, 0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A, 0x0D, 0x0F,
  0xCA, 0x83, 0x60, 0x6F, 0xE4, 0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x04, 0xA0, 0x20,
  // "Ã" (U+00C3)
  0x38, 0x49, 0xED, 0xBE, 0x84, 0x85, 0x4F, 0xBD, 0xFC, 0x17, 0x77, 0x60, 0x6A, 0x0B, 0x78, 0x3C,
  0xFE, 0xF2, 0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD, 0x58, 0x5E, 0xF4, 0x0E, 0xF4,
  0x38, 0x14, 0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A, 0x0D, 0x0F, 0xCA, 0x83, 0x60,
  0x6F, 0xE4, 0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x04, 0xA0, 0x20,
  // "Ä" (U+00C4)
  0x38, 0x37, 0x90, 0x88, 0x68, 0x3B, 0xD0, 0xCD, 0x77, 0x77, 0x06, 0xA0, 0xB7, 0x83, 0xCF, 0xEF,
  0x25, 0x84, 0x2F, 0xE8, 0xF7, 0x58, 0x48, 0xF9, 0x3F, 0xD5, 0x85, 0xEF, 0x40, 0xEF, 0x43, 0x81,
  0x4F, 0xE2, 0x81, 0x9F, 0x93, 0x0A, 0xE0, 0xE2, 0x01, 0xA0, 0xD0, 0xFC, 0xA8, 0x36, 0x06, 0xFE,
  0x48, 0x59, 0xFC, 0x0C, 0xF9, 0x40, 0x4A, 0x02,
  // "Å" (U+00C5)
  0x38, 0x21, 0xCE, 0xA7, 0x83, 0x5D, 0x2F, 0x36, 0x82, 0x1C, 0xFA, 0x70, 0x6A, 0x0B, 0x78, 0x3C,
  0xFE, 0xF2, 0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD, 0x58, 0x5E, 0xF4, 0x0E, 0xF4,
  0x38, 0x14, 0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A, 0x0D, 0x0F, 0xCA, 0x83, 0x60,
  0x6F, 0xE4, 0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x04, 0xA0, 0x20,
  // "Æ" (U+00C6)
  0x40, 0x6F, 0x90, 0x64, 0x81, 0xDF, 0xBA, 0x83, 0xCB, 0xBB, 0x43, 0x81, 0x6F, 0xB1, 0xA0, 0x47,
  0x81, 0xDF, 0x41, 0xA0, 0x46, 0x81, 0x5F, 0xD2, 0xE0, 0x12, 0x81, 0xCF, 0x72, 0xA8, 0x5C, 0xBB,
  0xB1, 0x05, 0xF0, 0x45, 0x81, 0xCF, 0xC0, 0xFB, 0xA0, 0x44, 0x82, 0x4F, 0xE1, 0x3A, 0x86, 0xCB,
  0xBB, 0x4B, 0xF8, 0x4E, 0x06,
  // "Ç" (U+00C7)
  0x38, 0x47, 0xCE, 0xEC, 0x72, 0x0C, 0xA8, 0x7C, 0xDF, 0xA0, 0x8F, 0xE2, 0x28, 0x41, 0x20, 0xEF,
  0x75, 0x01, 0xA0, 0x45, 0x01, 0xA0, 0x36, 0x81, 0xEF, 0x66, 0x82, 0xAF, 0xD2, 0x38, 0x21, 0x01,
  0xEA, 0x82, 0xCC, 0xE9, 0x20, 0x10, 0x9A, 0x81, 0xEC, 0x54, 0x81, 0xAF, 0x77, 0x0C, 0x95, 0x04,
  0xA0, 0xA6, 0x02, 0x01, 0x30,
  // "È" (U+00C8)
  0x82, 0x27, 0x72, 0x48, 0x17, 0xFC, 0x58, 0x15, 0xE8, 0x77, 0x20, 0xAD, 0x89, 0x18, 0xAF, 0xDB,
  0xBB, 0x5A, 0xF9, 0x48, 0x1A, 0xF9, 0x40, 0xAD, 0x89, 0x13, 0xAF, 0xDB, 0xBB, 0x2A, 0xF9, 0x48,
  0x1A, 0xF9, 0x48, 0x6A, 0xFD, 0xBB, 0xB5, 0xAD, 0x08,
  // "É" (U+00C9)
  0x48, 0x16, 0x75, 0x38, 0x25, 0xFC, 0x12, 0x81, 0x2E, 0xA7, 0x72, 0x0A, 0xD8, 0x91, 0x8A, 0xFD,
  0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A, 0xFD, 0xBB, 0xB2, 0xAF, 0x94,
  0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "Ê" (U+00CA)
  0x28, 0x25, 0x77, 0x12, 0x89, 0x34, 0xFD, 0xFC, 0x02, 0xEB, 0x14, 0xEA, 0x77, 0x0A, 0xD8, 0x91,
  0x8A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A, 0xFD, 0xBB, 0xB2,
  0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "Ë" (U+00CB)
  0x18, 0x37, 0x90, 0x88, 0x28, 0x3B, 0xD0, 0xCD, 0x77, 0x10, 0xAD, 0x89, 0x18, 0xAF, 0xDB, 0xBB,
  0x5A, 0xF9, 0x48, 0x1A, 0xF9, 0x40, 0xAD, 0x89, 0x13, 0xAF, 0xDB, 0xBB, 0x2A, 0xF9, 0x48, 0x1A,
  0xF9, 0x48, 0x6A, 0xFD, 0xBB, 0xB5, 0xAD, 0x08,
  // "Ì" (U+00CC)
  0x82, 0x27, 0x72, 0x48, 0x17, 0xFC, 0x58, 0x15, 0xE8, 0x77, 0x30, 0x8C, 0x82, 0x50, 0x2B, 0xA0,
  0x90, 0x12, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA3, 0x02, 0x0A,
  0xA8, 0x29, 0x10, 0x8C, 0x05,
  // "Í" (U+00CD)
  0x38, 0x16, 0x75, 0x28, 0x65, 0xFC, 0x10, 0x2E, 0xA7, 0x70, 0x8C, 0x81, 0x52, 0xBA, 0x82, 0x91,
  0x03, 0xA3, 0x03, 0xA3, 0x03, 0xA3, 0x03, 0xA3, 0x03, 0xA3, 0x03, 0xA2, 0x02, 0x0A, 0xA8, 0x19,
  0x18, 0xC0, 0x50,
  // "Î" (U+00CE)
  0x28, 0x25, 0x77, 0x12, 0x89, 0x34, 0xFD, 0xFC, 0x02, 0xEB, 0x14, 0xEA, 0x77, 0x10, 0x8C, 0x82,
  0x50, 0x2B, 0xA0, 0x90, 0x12, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03, 0xA4, 0x03,
  0xA3, 0x02, 0x0A, 0xA8, 0x29, 0x10, 0x8C, 0x05,
  // "Ï" (U+00CF)
  0x89, 0x17, 0x90, 0x88, 0x0B, 0xD0, 0xCD, 0x76, 0x08, 0xC8, 0x15, 0x2B, 0xA8, 0x29, 0x10, 0x3A,
  0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x20, 0x20, 0xAA, 0x81, 0x91, 0x8C,
  0x05,
  // "Ð" (U+00D0)
  0x10, 0xAB, 0x81, 0xEC, 0x74, 0x83, 0xAF, 0xDB, 0xDA, 0x0C, 0x01, 0x28, 0x1A, 0xF9, 0x28, 0x22,
  0xDF, 0xA2, 0x81, 0xAF, 0x93, 0x06, 0xA1, 0x0A, 0xC8, 0x15, 0x02, 0xA8, 0x72, 0x7E, 0xFD, 0xB4,
  0x03, 0xA8, 0x32, 0x0A, 0xF9, 0x30, 0x6A, 0x28, 0x1A, 0xF9, 0x28, 0x23, 0xEF, 0x92, 0x83, 0xAF,
  0xDB, 0xDA, 0x0C, 0x01, 0x20, 0xAB, 0x81, 0xEB, 0x63,
  // "Ñ" (U+00D1)
  0x28, 0x49, 0xED, 0xBE, 0x83, 0x85, 0x4F, 0xBD, 0xFC, 0x17, 0x77, 0x10, 0xAA, 0x08, 0x38, 0x22,
  0xFD, 0xAB, 0x02, 0x28, 0x62, 0xFD, 0xAF, 0xDF, 0xB2, 0x8C, 0x42, 0xFD, 0xAF, 0x6E, 0xF5, 0x02,
  0xFD, 0xAF, 0x57, 0xFE, 0x12, 0xFD, 0xAF, 0x50, 0xCF, 0x92, 0xFD, 0xAF, 0x50, 0x3A, 0x84, 0x5F,
  0xDA, 0xF5, 0x28, 0x69, 0xFE, 0xFD, 0xAF, 0x53, 0x0E, 0xA8, 0x2D, 0xAF, 0x53, 0x05, 0xA0, 0xD0,
  // "Ò" (U+00D2)
  0x38, 0x22, 0x77, 0x27, 0x18, 0x17, 0xFC, 0x72, 0x81, 0x5E, 0x87, 0x77, 0x78, 0x48, 0xCE, 0xEC,
  0x73, 0x01, 0x0D, 0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63, 0xEF, 0x80, 0xEF, 0x74,
  0x82, 0x8F, 0xD1, 0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18, 0x1E, 0xF7, 0x48, 0x68,
  0xFD, 0x09, 0xFE, 0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C, 0x48, 0x48, 0xDE, 0xEC,
  0x72,
  // "Ó" (U+00D3)
  0x68, 0x16, 0x75, 0x78, 0x25, 0xFC, 0x16, 0x81, 0x2E, 0xA7, 0x77, 0x71, 0x84, 0x8C, 0xEE, 0xC7,
  0x30, 0x10, 0xDA, 0x00, 0xCA, 0x0C, 0x28, 0x29, 0xFE, 0x22, 0x86, 0x3E, 0xF8, 0x0E, 0xF7, 0x48,
  0x28, 0xFD, 0x1A, 0x04, 0x40, 0x5A, 0x01, 0xA0, 0x44, 0x05, 0xA1, 0x81, 0xEF, 0x74, 0x86, 0x8F,
  0xD0, 0x9F, 0xE2, 0x28, 0x53, 0xEF, 0x80, 0x1D, 0xA0, 0x0C, 0xA0, 0xC4, 0x84, 0x8D, 0xEE, 0xC7,
  0x20,
  // "Ô" (U+00D4)
  0x48, 0x25, 0x77, 0x16, 0x83, 0x4F, 0xDF, 0xC5, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x68, 0x48,
  0xCE, 0xEC, 0x73, 0x01, 0x0D, 0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63, 0xEF, 0x80,
  0xEF, 0x74, 0x82, 0x8F, 0xD1, 0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18, 0x1E, 0xF7,
  0x48, 0x68, 0xFD, 0x09, 0xFE, 0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C, 0x48, 0x48,
  0xDE, 0xEC, 0x72,
  // "Õ" (U+00D5)
  0x38, 0x49, 0xED, 0xBE, 0x84, 0x85, 0x4F, 0xBD, 0xFC, 0x17, 0x77, 0x68, 0x48, 0xCE, 0xEC, 0x73,
  0x01, 0x0D, 0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63, 0xEF, 0x80, 0xEF, 0x74, 0x82,
  0x8F, 0xD1, 0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18, 0x1E, 0xF7, 0x48, 0x68, 0xFD,
  0x09, 0xFE, 0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C, 0x48, 0x48, 0xDE, 0xEC, 0x72,
  // "Ö" (U+00D6)
  0x38, 0x37, 0x90, 0x88, 0x68, 0x3B, 0xD0, 0xCD, 0x77, 0x77, 0x84, 0x8C, 0xEE, 0xC7, 0x30, 0x10,
  0xDA, 0x00, 0xCA, 0x0C, 0x28, 0x29, 0xFE, 0x22, 0x86, 0x3E, 0xF8, 0x0E, 0xF7, 0x48, 0x28, 0xFD,
  0x1A, 0x04, 0x40, 0x5A, 0x01, 0xA0, 0x44, 0x05, 0xA1, 0x81, 0xEF, 0x74, 0x86, 0x8F, 0xD0, 0x9F,
  0xE2, 0x28, 0x53, 0xEF, 0x80, 0x1D, 0xA0, 0x0C, 0xA0, 0xC4, 0x84, 0x8D, 0xEE, 0xC7, 0x20,
  // "×" (U+00D7)
  0x02, 0x03, 0x38, 0x95, 0x50, 0xCE, 0x30, 0x9F, 0x52, 0xEE, 0xBF, 0x92, 0x02, 0xA0, 0xA3, 0x09,
  0xA8, 0x92, 0xE3, 0x09, 0xF9, 0x2D, 0xE3, 0x78, 0x28, 0x12, 0xC2,
  // "Ø" (U+00D8)
  0x72, 0x02, 0x48, 0x91, 0x8C, 0xEE, 0xCB, 0xE1, 0x01, 0xDA, 0x00, 0xCA, 0x0D, 0x28, 0x59, 0xFE,
  0x20, 0x1D, 0xA8, 0x38, 0x0E, 0xF7, 0x28, 0x4B, 0xD9, 0xFD, 0x1A, 0x84, 0x40, 0x7F, 0x35, 0xA0,
  0x1A, 0x84, 0x43, 0xF7, 0x05, 0xA1, 0x83, 0xEF, 0x8D, 0xB2, 0x83, 0x8F, 0xD0, 0x9A, 0x89, 0x0E,
  0x10, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C, 0x28, 0x61, 0xFB, 0xDE, 0xEC, 0x74, 0x03, 0x71,
  // "Ù" (U+00D9)
  0x18, 0x22, 0x77, 0x27, 0x81, 0x7F, 0xC7, 0x18, 0x15, 0xE8, 0x77, 0x73, 0x81, 0xBF, 0x83, 0x03,
  0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8,
  0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF, 0x93, 0x04, 0xA1, 0x82,
  0x8F, 0xE1, 0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85, 0x29, 0xDF, 0xEB, 0x42,
  // "Ú" (U+00DA)
  0x58, 0x16, 0x75, 0x68, 0x25, 0xFC, 0x15, 0x81, 0x2E, 0xA7, 0x77, 0x38, 0x1B, 0xF8, 0x30, 0x3A,
  0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82,
  0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1A, 0xF9, 0x30, 0x4A, 0x18, 0x28,
  0xFE, 0x12, 0x84, 0xAF, 0xD0, 0x1E, 0xA0, 0xD0, 0xEA, 0x05, 0x28, 0x52, 0x9D, 0xFE, 0xB4, 0x20,
  // "Û" (U+00DB)
  0x38, 0x25, 0x77, 0x15, 0x83, 0x4F, 0xDF, 0xC4, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x18, 0x1B,
  0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8,
  0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1A, 0xF9, 0x30,
  0x4A, 0x18, 0x28, 0xFE, 0x12, 0x84, 0xAF, 0xD0, 0x1E, 0xA0, 0xD0, 0xEA, 0x05, 0x28, 0x52, 0x9D,
  0xFE, 0xB4, 0x20,
  // "Ü" (U+00DC)
  0x28, 0x37, 0x90, 0x88, 0x58, 0x3B, 0xD0, 0xCD, 0x77, 0x72, 0x81, 0xBF, 0x83, 0x03, 0xA8, 0x21,
  0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF,
  0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF, 0x93, 0x04, 0xA1, 0x82, 0x8F, 0xE1,
  0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85, 0x29, 0xDF, 0xEB, 0x42,
  // "Ý" (U+00DD)
  0x58, 0x16, 0x75, 0x68, 0x25, 0xFC, 0x15, 0x81, 0x2E, 0xA7, 0x77, 0x38, 0x1B, 0xFA, 0x38, 0x35,
  0xFE, 0x12, 0xA0, 0x32, 0x81, 0xCF, 0x72, 0x85, 0x8F, 0xB0, 0x5F, 0xD3, 0x85, 0x1E, 0xF3, 0xDF,
  0x54, 0x83, 0x6F, 0xEF, 0xB6, 0x0C, 0xA0, 0x26, 0x81, 0x6F, 0xC7, 0x81, 0x6F, 0xC7, 0x81, 0x6F,
  0xC7, 0x81, 0x6F, 0xC4,
  // "Þ" (U+00DE)
  0x81, 0xAF, 0x95, 0x87, 0xAF, 0xDB, 0xA8, 0x10, 0xAD, 0x89, 0x3E, 0x1A, 0xF9, 0x02, 0xDF, 0x8A,
  0xF9, 0x28, 0x49, 0xFB, 0xAF, 0x92, 0x86, 0xCF, 0x9A, 0xFD, 0xBE, 0xA0, 0x30, 0xAB, 0x85, 0xEB,
  0x30, 0xAF, 0x95, 0x81, 0xAF, 0x95,
  // "ß" (U+00DF)
  0x18, 0x55, 0xBE, 0xFD, 0x91, 0x20, 0x5A, 0x0D, 0x0B, 0xA0, 0xD2, 0x81, 0xBF, 0x92, 0x03, 0xA8,
  0x31, 0x0C, 0xF6, 0x28, 0x19, 0xFA, 0x28, 0x5C, 0xF6, 0x0C, 0xF8, 0x38, 0x2C, 0xF6, 0x1A, 0x06,
  0x38, 0x3C, 0xF6, 0x07, 0xA8, 0x4B, 0x10, 0xCF, 0x62, 0x87, 0x2C, 0xFC, 0x0C, 0xF6, 0x12, 0x03,
  0xA8, 0xA2, 0x1C, 0xF6, 0x7E, 0xBE, 0xFE, 0x0C, 0xF6, 0x4D, 0xFE, 0xB3, 0x10,
  // "à" (U+00E0)
  0x18, 0x22, 0x77, 0x25, 0x81, 0x7F, 0xC6, 0x81, 0x5E, 0x87, 0x48, 0x43, 0x9D, 0xFD, 0x92, 0x85,
  0x3F, 0xDB, 0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE, 0xB0, 0xE0, 0x2A, 0x84, 0x50, 0x4F,
  0xE5, 0xA2, 0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0, 0x6D, 0xFB, 0x2C, 0xE0,
  // "á" (U+00E1)
  0x58, 0x16, 0x75, 0x48, 0x25, 0xFC, 0x13, 0x81, 0x2E, 0xA7, 0x48, 0x43, 0x9D, 0xFD, 0x92, 0x85,
  0x3F, 0xDB, 0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE, 0xB0, 0xE0, 0x2A, 0x84, 0x50, 0x4F,
  0xE5, 0xA2, 0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0, 0x6D, 0xFB, 0x2C, 0xE0,
  // "â" (U+00E2)
  0x38, 0x25, 0x77, 0x13, 0x83, 0x4F, 0xDF, 0xC2, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x28, 0x43, 0x9D,
  0xFD, 0x92, 0x85, 0x3F, 0xDB, 0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE, 0xB0, 0xE0, 0x2A,
  0x84, 0x50, 0x4F, 0xE5, 0xA2, 0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0, 0x6D, 0xFB, 0x2C,
  0xE0,
  // "ã" (U+00E3)
  0x28, 0x94, 0x9E, 0xDB, 0xE8, 0x04, 0xFB, 0xDF, 0xC1, 0x72, 0x84, 0x39, 0xDF, 0xD9, 0x28, 0x53,
  0xFD, 0xBE, 0xF9, 0x20, 0x12, 0x85, 0x5F, 0xD0, 0x4B, 0xEB, 0x0E, 0x02, 0xA8, 0x45, 0x04, 0xFE,
  0x5A, 0x28, 0x28, 0xFE, 0x2A, 0x89, 0x3D, 0xDE, 0xFE, 0x06, 0xDF, 0xB2, 0xCE,
  // "ä" (U+00E4)
  0x28, 0x37, 0x90, 0x88, 0x38, 0x3B, 0xD0, 0xCD, 0x73, 0x84, 0x39, 0xDF, 0xD9, 0x28, 0x53, 0xFD,
  0xBE, 0xF9, 0x20, 0x12, 0x85, 0x5F, 0xD0, 0x4B, 0xEB, 0x0E, 0x02, 0xA8, 0x45, 0x04, 0xFE, 0x5A,
  0x28, 0x28, 0xFE, 0x2A, 0x89, 0x3D, 0xDE, 0xFE, 0x06, 0xDF, 0xB2, 0xCE,
  // "å" (U+00E5)
  0x28, 0x21, 0xCE, 0xA4, 0x83, 0x5D, 0x2F, 0x33, 0x82, 0x1C, 0xFA, 0x74, 0x84, 0x39, 0xDF, 0xD9,
  0x28, 0x53, 0xFD, 0xBE, 0xF9, 0x20, 0x12, 0x85, 0x5F, 0xD0, 0x4B, 0xEB, 0x0E, 0x02, 0xA8, 0x45,
  0x04, 0xFE, 0x5A, 0x28, 0x28, 0xFE, 0x2A, 0x89, 0x3D, 0xDE, 0xFE, 0x06, 0xDF, 0xB2, 0xCE,
  // "æ" (U+00E6)
  0x18, 0x91, 0x3A, 0xDF, 0xD6, 0x6C, 0xED, 0x73, 0x82, 0x3F, 0xCB, 0xB8, 0x3E, 0xBE, 0xF7, 0x30,
  0x12, 0x07, 0xA8, 0x31, 0x02, 0xFE, 0x28, 0x14, 0xCE, 0xFA, 0x01, 0x02, 0xA8, 0x3E, 0xBD, 0xFE,
  0x80, 0x1B, 0x01, 0x05, 0xA2, 0x08, 0xA0, 0x23, 0x81, 0x10, 0x2A, 0x82, 0xCC, 0xFB, 0xA8, 0x2C,
  0xCE, 0x92, 0x89, 0x26, 0xDF, 0xD6, 0x05, 0xCF, 0xEC, 0x51,
  // "ç" (U+00E7)
  0x28, 0x67, 0xDF, 0xEA, 0x10, 0x9A, 0x83, 0xCD, 0xD0, 0x1A, 0x05, 0x40, 0x4A, 0x50, 0x4A, 0x50,
  0x2A, 0x05, 0x20, 0x22, 0x0B, 0xA0, 0xC0, 0xD9, 0x30, 0x8A, 0x0E, 0x09, 0x48, 0x1A, 0xF7, 0x60,
  0xC9, 0x40, 0x4A, 0x0A, 0x50, 0x20, 0x13,
  // "è" (U+00E8)
  0x18, 0x22, 0x77, 0x26, 0x81, 0x7F, 0xC7, 0x81, 0x5E, 0x87, 0x78, 0x37, 0xDF, 0xD7, 0x38, 0x79,
  0xFE, 0xBE, 0xF8, 0x01, 0xA8, 0x52, 0x01, 0xEF, 0x04, 0xF0, 0x20, 0x4A, 0x80, 0x1B, 0x02, 0x01,
  0xA0, 0x33, 0x01, 0x20, 0x9A, 0x82, 0xCB, 0xDB, 0x30, 0x60, 0xCA, 0x0C, 0x06, 0x10,
  // "é" (U+00E9)
  0x48, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x71, 0x83, 0x7D, 0xFD, 0x73, 0x87,
  0x9F, 0xEB, 0xEF, 0x80, 0x1A, 0x85, 0x20, 0x1E, 0xF0, 0x4F, 0x02, 0x04, 0xA8, 0x01, 0xB0, 0x20,
  0x1A, 0x03, 0x30, 0x12, 0x09, 0xA8, 0x2C, 0xBD, 0xB3, 0x06, 0x0C, 0xA0, 0xC0, 0x61,
  // "ê" (U+00EA)
  0x38, 0x25, 0x77, 0x14, 0x83, 0x4F, 0xDF, 0xC3, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x58, 0x37, 0xDF,
  0xD7, 0x38, 0x79, 0xFE, 0xBE, 0xF8, 0x01, 0xA8, 0x52, 0x01, 0xEF, 0x04, 0xF0, 0x20, 0x4A, 0x80,
  0x1B, 0x02, 0x01, 0xA0, 0x33, 0x01, 0x20, 0x9A, 0x82, 0xCB, 0xDB, 0x30, 0x60, 0xCA, 0x0C, 0x06,
  0x10,
  // "ë" (U+00EB)
  0x28, 0x37, 0x90, 0x88, 0x48, 0x3B, 0xD0, 0xCD, 0x76, 0x83, 0x7D, 0xFD, 0x73, 0x87, 0x9F, 0xEB,
  0xEF, 0x80, 0x1A, 0x85, 0x20, 0x1E, 0xF0, 0x4F, 0x02, 0x04, 0xA8, 0x01, 0xB0, 0x20, 0x1A, 0x03,
  0x30, 0x12, 0x09, 0xA8, 0x2C, 0xBD, 0xB3, 0x06, 0x0C, 0xA0, 0xC0, 0x61,
  // "ì" (U+00EC)
  0x82, 0x27, 0x72, 0x28, 0x17, 0xFC, 0x38, 0x15, 0xE8, 0x78, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28,
  0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C,
  0xF6,
  // "í" (U+00ED)
  0x28, 0x91, 0x67, 0x50, 0x5F, 0xC1, 0x2E, 0xA7, 0x18, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C,
  0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6,
  0x10,
  // "î" (U+00EE)
  0x28, 0x25, 0x77, 0x12, 0x89, 0x34, 0xFD, 0xFC, 0x02, 0xEB, 0x14, 0xEA, 0x72, 0x81, 0xCF, 0x64,
  0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81,
  0xCF, 0x64, 0x81, 0xCF, 0x62,
  // "ï" (U+00EF)
  0x89, 0x07, 0x90, 0x88, 0xBD, 0x0C, 0xD6, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62,
  0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x61,
  // "ð" (U+00F0)
  0x38, 0x3C, 0x73, 0xB3, 0x30, 0x10, 0xBA, 0x0C, 0x02, 0x38, 0x43, 0xEE, 0xFD, 0x13, 0x84, 0x17,
  0x07, 0xFB, 0x28, 0x94, 0x19, 0xEE, 0xBE, 0xF3, 0x0B, 0xFE, 0xCE, 0xA0, 0x70, 0x2A, 0x03, 0x28,
  0x2D, 0xF8, 0x4A, 0x38, 0x2B, 0xF8, 0x2A, 0x03, 0x28, 0x3E, 0xF5, 0x0A, 0xA8, 0x2C, 0xEF, 0xC3,
  0x84, 0x8D, 0xFE, 0x91, 0x10,
  // "ñ" (U+00F1)
  0x18, 0x94, 0x9E, 0xDB, 0xE8, 0x04, 0xFB, 0xDF, 0xC1, 0x72, 0x89, 0x3C, 0xF3, 0xBF, 0xD8, 0x0C,
  0xFE, 0xDC, 0xA8, 0x26, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84,
  0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x17, 0xFB,
  // "ò" (U+00F2)
  0x18, 0x22, 0x77, 0x26, 0x81, 0x7F, 0xC7, 0x81, 0x5E, 0x87, 0x78, 0x47, 0xDF, 0xD9, 0x12, 0x09,
  0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A, 0x38, 0x2B, 0xF8, 0x4A, 0x38, 0x2B,
  0xF8, 0x1A, 0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF, 0xD3, 0x84, 0x6D, 0xFE, 0x91, 0x10,
  // "ó" (U+00F3)
  0x58, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x78, 0x47, 0xDF, 0xD9, 0x12, 0x09,
  0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A, 0x38, 0x2B, 0xF8, 0x4A, 0x38, 0x2B,
  0xF8, 0x1A, 0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF, 0xD3, 0x84, 0x6D, 0xFE, 0x91, 0x10,
  // "ô" (U+00F4)
  0x38, 0x25, 0x77, 0x14, 0x83, 0x4F, 0xDF, 0xC3, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x58, 0x47, 0xDF,
  0xD9, 0x12, 0x09, 0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A, 0x38, 0x2B, 0xF8,
  0x4A, 0x38, 0x2B, 0xF8, 0x1A, 0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF, 0xD3, 0x84, 0x6D,
  0xFE, 0x91, 0x10,
  // "õ" (U+00F5)
  0x28, 0x49, 0xED, 0xBE, 0x82, 0x85, 0x4F, 0xBD, 0xFC, 0x17, 0x58, 0x47, 0xDF, 0xD9, 0x12, 0x09,
  0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A, 0x38, 0x2B, 0xF8, 0x4A, 0x38, 0x2B,
  0xF8, 0x1A, 0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF, 0xD3, 0x84, 0x6D, 0xFE, 0x91, 0x10,
  // "ö" (U+00F6)
  0x28, 0x37, 0x90, 0x88, 0x48, 0x3B, 0xD0, 0xCD, 0x76, 0x84, 0x7D, 0xFD, 0x91, 0x20, 0x9A, 0x84,
  0xCE, 0xFC, 0x01, 0xA8, 0x54, 0x01, 0xEF, 0x54, 0xA3, 0x82, 0xBF, 0x84, 0xA3, 0x82, 0xBF, 0x81,
  0xA8, 0x64, 0x01, 0xEF, 0x50, 0x8A, 0x82, 0xCE, 0xFD, 0x38, 0x46, 0xDF, 0xE9, 0x11,
  // "÷" (U+00F7)
  0x38, 0x15, 0xA1, 0x58, 0x18, 0xE2, 0x20, 0x48, 0x02, 0xB0, 0xA0, 0x5E, 0x0E, 0x74, 0x81, 0x5A,
  0x15, 0x81, 0x8E, 0x22,
  // "ø" (U+00F8)
  0x28, 0x47, 0xDF, 0xEC, 0xA2, 0x09, 0xA8, 0x4C, 0xEF, 0xC0, 0x1A, 0x81, 0x41, 0xDA, 0x05, 0x04,
  0xA1, 0x84, 0xAD, 0xCF, 0x84, 0xA8, 0x57, 0xF3, 0xBF, 0x81, 0xB8, 0x57, 0x1E, 0xF5, 0x07, 0xA8,
  0x2C, 0xEF, 0xD2, 0x85, 0x7E, 0xDF, 0xE9, 0x13, 0x02, 0x60,
  // "ù" (U+00F9)
  0x82, 0x27, 0x72, 0x58, 0x17, 0xFC, 0x68, 0x15, 0xE8, 0x74, 0x81, 0xDF, 0x52, 0x84, 0x8F, 0xAD,
  0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84,
  0x9F, 0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87, 0xA1, 0x9E, 0xEB, 0x5F, 0xA0,
  // "ú" (U+00FA)
  0x48, 0x16, 0x75, 0x48, 0x25, 0xFC, 0x13, 0x81, 0x2E, 0xA7, 0x48, 0x1D, 0xF5, 0x28, 0x48, 0xFA,
  0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28,
  0x49, 0xFA, 0xCF, 0x72, 0x86, 0xDF, 0xA9, 0xFE, 0x9C, 0xA8, 0x7A, 0x19, 0xEE, 0xB5, 0xFA,
  // "û" (U+00FB)
  0x28, 0x25, 0x77, 0x13, 0x83, 0x4F, 0xDF, 0xC2, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x28, 0x1D, 0xF5,
  0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F,
  0xAD, 0xF5, 0x28, 0x49, 0xFA, 0xCF, 0x72, 0x86, 0xDF, 0xA9, 0xFE, 0x9C, 0xA8, 0x7A, 0x19, 0xEE,
  0xB5, 0xFA,
  // "ü" (U+00FC)
  0x18, 0x37, 0x90, 0x88, 0x38, 0x3B, 0xD0, 0xCD, 0x73, 0x81, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5,
  0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x9F,
  0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87, 0xA1, 0x9E, 0xEB, 0x5F, 0xA0,
  // "ý" (U+00FD)
  0x48, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x68, 0x1C, 0xF9, 0x20, 0x1A, 0x82,
  0x55, 0xFE, 0x28, 0x16, 0xFE, 0x28, 0x5E, 0xF5, 0x0B, 0xF8, 0x28, 0x27, 0xFA, 0x1A, 0x02, 0x20,
  0x1A, 0x81, 0x7F, 0xB4, 0x83, 0x9F, 0xEF, 0x44, 0x03, 0xA0, 0xD6, 0x81, 0xDF, 0x75, 0x03, 0xA0,
  0x13, 0x05, 0x0B, 0xA0, 0x84, 0x82, 0x7F, 0xD7, 0x50,
  // "þ" (U+00FE)
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x89, 0x3C, 0xF6, 0xBF, 0xD5, 0x0C, 0xFE,
  0xDD, 0xA8, 0x23, 0xCF, 0xA2, 0x84, 0xBF, 0x9C, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x72, 0x84, 0x7F,
  0xBC, 0xFB, 0x28, 0x2C, 0xF9, 0xCA, 0x00, 0xDA, 0x89, 0x23, 0xCF, 0x8B, 0xFD, 0x50, 0xCF, 0x65,
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65,
  // "ÿ" (U+00FF)
  0x28, 0x37, 0x90, 0x88, 0x48, 0x3B, 0xD0, 0xCD, 0x74, 0x81, 0xCF, 0x92, 0x01, 0xA8, 0x25, 0x5F,
  0xE2, 0x81, 0x6F, 0xE2, 0x85, 0xEF, 0x50, 0xBF, 0x82, 0x82, 0x7F, 0xA1, 0xA0, 0x22, 0x01, 0xA8,
  0x17, 0xFB, 0x48, 0x39, 0xFE, 0xF4, 0x40, 0x3A, 0x0D, 0x68, 0x1D, 0xF7, 0x50, 0x3A, 0x01, 0x30,
  0x50, 0xBA, 0x08, 0x48, 0x27, 0xFD, 0x75,
  // "Ā" (U+0100)
  0x28, 0x44, 0xBB, 0xBB, 0x65, 0x06, 0xC0, 0x87, 0x77, 0x70, 0x6A, 0x0B, 0x78, 0x3C, 0xFE, 0xF2,
  0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD, 0x58, 0x5E, 0xF4, 0x0E, 0xF4, 0x38, 0x14,
  0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A, 0x0D, 0x0F, 0xCA, 0x83, 0x60, 0x6F, 0xE4,
  0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x04, 0xA0, 0x20,
  // "ā" (U+0101)
  0x18, 0x44, 0xBB, 0xBB, 0x62, 0x06, 0xC0, 0x87, 0x38, 0x43, 0x9D, 0xFD, 0x92, 0x85, 0x3F, 0xDB,
  0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE, 0xB0, 0xE0, 0x2A, 0x84, 0x50, 0x4F, 0xE5, 0xA2,
  0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0, 0x6D, 0xFB, 0x2C, 0xE0,
  // "Ă" (U+0102)
  0x20, 0x20, 0x73, 0x07, 0x02, 0x48, 0x52, 0xFD, 0xBD, 0xE1, 0x58, 0x35, 0xDE, 0xC3, 0x77, 0x77,
  0x06, 0xA0, 0xB7, 0x83, 0xCF, 0xEF, 0x25, 0x84, 0x2F, 0xE8, 0xF7, 0x58, 0x48, 0xF9, 0x3F, 0xD5,
  0x85, 0xEF, 0x40, 0xEF, 0x43, 0x81, 0x4F, 0xE2, 0x81, 0x9F, 0x93, 0x0A, 0xE0, 0xE2, 0x01, 0xA0,
  0xD0, 0xFC, 0xA8, 0x36, 0x06, 0xFE, 0x48, 0x59, 0xFC, 0x0C, 0xF9, 0x40, 0x4A, 0x02,
  // "ă" (U+0103)
  0x10, 0x20, 0x73, 0x89, 0x07, 0x20, 0x2F, 0xDB, 0xDE, 0x12, 0x83, 0x5D, 0xEC, 0x37, 0x38, 0x43,
  0x9D, 0xFD, 0x92, 0x85, 0x3F, 0xDB, 0xEF, 0x92, 0x01, 0x28, 0x55, 0xFD, 0x04, 0xBE, 0xB0, 0xE0,
  0x2A, 0x84, 0x50, 0x4F, 0xE5, 0xA2, 0x82, 0x8F, 0xE2, 0xA8, 0x93, 0xDD, 0xEF, 0xE0, 0x6D, 0xFB,
  0x2C, 0xE0,
  // "Ą" (U+0104)
  0x30, 0x6A, 0x0B, 0x78, 0x3C, 0xFE, 0xF2, 0x58, 0x42, 0xFE, 0x8F, 0x75, 0x84, 0x8F, 0x93, 0xFD,
  0x58, 0x5E, 0xF4, 0x0E, 0xF4, 0x38, 0x14, 0xFE, 0x28, 0x19, 0xF9, 0x30, 0xAE, 0x0E, 0x20, 0x1A,
  0x0D, 0x0F, 0xCA, 0x83, 0x60, 0x6F, 0xE4, 0x85, 0x9F, 0xC0, 0xCF, 0x94, 0x0B, 0xA0, 0x26, 0x81,
  0x3F, 0x37, 0x18, 0x25, 0xFD, 0x67, 0x18, 0x1B, 0xF7, 0x10,
  // "ą" (U+0105)
  0x18, 0x43, 0x9D, 0xFD, 0x93, 0x85, 0x3F, 0xDB, 0xEF, 0x93, 0x01, 0x28, 0x15, 0xFD, 0x28, 0x14,
  0xBE, 0xB8, 0x1E, 0x02, 0xA8, 0x55, 0x04, 0xFE, 0x05, 0xA2, 0x83, 0x8F, 0xE0, 0x2A, 0x81, 0xDD,
  0xEA, 0x28, 0x36, 0xDF, 0xB2, 0xA6, 0x81, 0x3F, 0x36, 0x82, 0x5F, 0xD6, 0x68, 0x1B, 0xF7,
  // "Ć" (U+0106)
  0x68, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x77, 0x28, 0x47, 0xCE, 0xEC, 0x72,
  0x0C, 0xA8, 0x7C, 0xDF, 0xA0, 0x8F, 0xE2, 0x28, 0x41, 0x20, 0xEF, 0x75, 0x01, 0xA0, 0x45, 0x01,
  0xA0, 0x36, 0x81, 0xEF, 0x66, 0x82, 0xAF, 0xD2, 0x38, 0x21, 0x01, 0xEA, 0x82, 0xCC, 0xE9, 0x28,
  0x51, 0x9D, 0xFE, 0xC5,
  // "ć" (U+0107)
  0x48, 0x16, 0x75, 0x48, 0x25, 0xFC, 0x13, 0x81, 0x2E, 0xA7, 0x68, 0x67, 0xDF, 0xEA, 0x10, 0x9A,
  0x83, 0xCD, 0xD0, 0x1A, 0x05, 0x40, 0x4A, 0x50, 0x4A, 0x50, 0x2A, 0x05, 0x20, 0x22, 0x0B, 0xA0,
  0xC0, 0xD9, 0x38, 0x38, 0xDF, 0xE9, 0x10,
  // "Ĉ" (U+0108)
  0x48, 0x25, 0x77, 0x14, 0x83, 0x4F, 0xDF, 0xC3, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x84, 0x7C,
  0xEE, 0xC7, 0x20, 0xCA, 0x87, 0xCD, 0xFA, 0x08, 0xFE, 0x22, 0x84, 0x12, 0x0E, 0xF7, 0x50, 0x1A,
  0x04, 0x50, 0x1A, 0x03, 0x68, 0x1E, 0xF6, 0x68, 0x2A, 0xFD, 0x23, 0x82, 0x10, 0x1E, 0xA8, 0x2C,
  0xCE, 0x92, 0x85, 0x19, 0xDF, 0xEC, 0x50,
  // "ĉ" (U+0109)
  0x38, 0x25, 0x77, 0x13, 0x83, 0x4F, 0xDF, 0xC2, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x38, 0x67, 0xDF,
  0xEA, 0x10, 0x9A, 0x83, 0xCD, 0xD0, 0x1A, 0x05, 0x40, 0x4A, 0x50, 0x4A, 0x50, 0x2A, 0x05, 0x20,
  0x22, 0x0B, 0xA0, 0xC0, 0xD9, 0x38, 0x38, 0xDF, 0xE9, 0x10,
  // "Ċ" (U+010A)
  0x48, 0x12, 0xA8, 0x68, 0x13, 0xEC, 0x77, 0x72, 0x84, 0x7C, 0xEE, 0xC7, 0x20, 0xCA, 0x87, 0xCD,
  0xFA, 0x08, 0xFE, 0x22, 0x84, 0x12, 0x0E, 0xF7, 0x50, 0x1A, 0x04, 0x50, 0x1A, 0x03, 0x68, 0x1E,
  0xF6, 0x68, 0x2A, 0xFD, 0x23, 0x82, 0x10, 0x1E, 0xA8, 0x2C, 0xCE, 0x92, 0x85, 0x19, 0xDF, 0xEC,
  0x50,
  // "ċ" (U+010B)
  0x38, 0x12, 0xA8, 0x58, 0x13, 0xEC, 0x75, 0x86, 0x7D, 0xFE, 0xA1, 0x09, 0xA8, 0x3C, 0xDD, 0x01,
  0xA0, 0x54, 0x04, 0xA5, 0x04, 0xA5, 0x02, 0xA0, 0x52, 0x02, 0x20, 0xBA, 0x0C, 0x0D, 0x93, 0x83,
  0x8D, 0xFE, 0x91,
  // "Č" (U+010C)
  0x28, 0x12, 0x73, 0x20, 0x06, 0x38, 0x4A, 0xF6, 0xBF, 0x34, 0x0D, 0xA0, 0x67, 0x77, 0x18, 0x47,
  0xCE, 0xEC, 0x72, 0x0C, 0xA8, 0x7C, 0xDF, 0xA0, 0x8F, 0xE2, 0x28, 0x41, 0x20, 0xEF, 0x75, 0x01,
  0xA0, 0x45, 0x01, 0xA0, 0x36, 0x81, 0xEF, 0x66, 0x82, 0xAF, 0xD2, 0x38, 0x21, 0x01, 0xEA, 0x82,
  0xCC, 0xE9, 0x28, 0x51, 0x9D, 0xFE, 0xC5,
  // "č" (U+010D)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x28, 0x4A, 0xF6, 0xBF, 0x33, 0x0D, 0xA0, 0x67, 0x48, 0x67, 0xDF,
  0xEA, 0x10, 0x9A, 0x83, 0xCD, 0xD0, 0x1A, 0x05, 0x40, 0x4A, 0x50, 0x4A, 0x50, 0x2A, 0x05, 0x20,
  0x22, 0x0B, 0xA0, 0xC0, 0xD9, 0x38, 0x38, 0xDF, 0xE9, 0x10,
  // "Ď" (U+010E)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x48, 0x4A, 0xF6, 0xBF, 0x35, 0x0D, 0xA0, 0x67, 0x77, 0x20, 0xAB,
  0x81, 0xEC, 0x73, 0x83, 0xAF, 0xDB, 0xDA, 0x84, 0xC1, 0x0A, 0xF9, 0x28, 0x62, 0xDF, 0xA0, 0xAF,
  0x93, 0x05, 0xA1, 0x81, 0xAF, 0x93, 0x02, 0xA8, 0x22, 0xAF, 0x93, 0x03, 0xA8, 0x22, 0xAF, 0x93,
  0x06, 0xA1, 0x81, 0xAF, 0x92, 0x89, 0x03, 0xEF, 0x90, 0xAF, 0xDB, 0xDA, 0x82, 0xC1, 0x0A, 0xB8,
  0x1E, 0xB6, 0x30,
  // "ď" (U+010F)
  0x68, 0x4E, 0xF5, 0xDE, 0x26, 0x83, 0xEF, 0x6B, 0x57, 0x81, 0xDF, 0x54, 0x86, 0x1A, 0xEE, 0x6D,
  0xF5, 0x40, 0xAA, 0x0C, 0x0E, 0xA0, 0x53, 0x01, 0xA8, 0x14, 0x02, 0xA0, 0x53, 0x04, 0xA3, 0x81,
  0xCF, 0x53, 0x04, 0xA3, 0x81, 0xCF, 0x53, 0x02, 0xA8, 0x44, 0x01, 0xEF, 0x54, 0x0B, 0xA0, 0xC0,
  0xEA, 0x05, 0x48, 0x61, 0xAE, 0xD5, 0x8F, 0x53,
  // "Đ" (U+0110)
  0x10, 0xAB, 0x81, 0xEC, 0x74, 0x83, 0xAF, 0xDB, 0xDA, 0x0C, 0x01, 0x28, 0x1A, 0xF9, 0x28, 0x22,
  0xDF, 0xA2, 0x81, 0xAF, 0x93, 0x06, 0xA1, 0x0A, 0xC8, 0x15, 0x02, 0xA8, 0x72, 0x7E, 0xFD, 0xB4,
  0x03, 0xA8, 0x32, 0x0A, 0xF9, 0x30, 0x6A, 0x28, 0x1A, 0xF9, 0x28, 0x23, 0xEF, 0x92, 0x83, 0xAF,
  0xDB, 0xDA, 0x0C, 0x01, 0x20, 0xAB, 0x81, 0xEB, 0x63,
  // "đ" (U+0111)
  0x68, 0x1E, 0xF5, 0x40, 0x3D, 0x07, 0x38, 0x12, 0xBB, 0xA8, 0x91, 0xC5, 0x01, 0xAE, 0xE6, 0xDF,
  0x52, 0x0A, 0xA0, 0xC0, 0xEA, 0x81, 0x50, 0x1A, 0x81, 0x40, 0x2A, 0x81, 0x50, 0x4A, 0x38, 0x3C,
  0xF5, 0x04, 0xA3, 0x83, 0xCF, 0x50, 0x2A, 0x84, 0x40, 0x1E, 0xF5, 0x20, 0xBA, 0x0C, 0x0E, 0xA0,
  0x52, 0x86, 0x1A, 0xFD, 0x58, 0xF5, 0x10,
  // "Ē" (U+0112)
  0x86, 0x4B, 0xBB, 0xB6, 0x06, 0xC0, 0x87, 0x71, 0x0A, 0xD8, 0x91, 0x8A, 0xFD, 0xBB, 0xB5, 0xAF,
  0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A, 0xFD, 0xBB, 0xB2, 0xAF, 0x94, 0x81, 0xAF, 0x94,
  0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "ē" (U+0113)
  0x18, 0x44, 0xBB, 0xBB, 0x63, 0x06, 0xC0, 0x87, 0x68, 0x37, 0xDF, 0xD7, 0x38, 0x79, 0xFE, 0xBE,
  0xF8, 0x01, 0xA8, 0x52, 0x01, 0xEF, 0x04, 0xF0, 0x20, 0x4A, 0x80, 0x1B, 0x02, 0x01, 0xA0, 0x33,
  0x01, 0x20, 0x9A, 0x82, 0xCB, 0xDB, 0x30, 0x60, 0xCA, 0x0C, 0x06, 0x10,
  // "Ĕ" (U+0114)
  0x02, 0x07, 0x38, 0x95, 0x72, 0x2F, 0xDB, 0xDE, 0x10, 0x5D, 0xEC, 0x37, 0x71, 0x0A, 0xD8, 0x91,
  0x8A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A, 0xFD, 0xBB, 0xB2,
  0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "ĕ" (U+0115)
  0x10, 0x20, 0x73, 0x07, 0x02, 0x28, 0x52, 0xFD, 0xBD, 0xE1, 0x38, 0x35, 0xDE, 0xC3, 0x76, 0x83,
  0x7D, 0xFD, 0x73, 0x87, 0x9F, 0xEB, 0xEF, 0x80, 0x1A, 0x85, 0x20, 0x1E, 0xF0, 0x4F, 0x02, 0x04,
  0xA8, 0x01, 0xB0, 0x20, 0x1A, 0x03, 0x30, 0x12, 0x09, 0xA8, 0x2C, 0xBD, 0xB3, 0x06, 0x0C, 0xA0,
  0xC0, 0x61,
  // "Ė" (U+0116)
  0x28, 0x12, 0xA8, 0x48, 0x13, 0xEC, 0x77, 0x20, 0xAD, 0x89, 0x18, 0xAF, 0xDB, 0xBB, 0x5A, 0xF9,
  0x48, 0x1A, 0xF9, 0x40, 0xAD, 0x89, 0x13, 0xAF, 0xDB, 0xBB, 0x2A, 0xF9, 0x48, 0x1A, 0xF9, 0x48,
  0x6A, 0xFD, 0xBB, 0xB5, 0xAD, 0x08,
  // "ė" (U+0117)
  0x38, 0x12, 0xA8, 0x68, 0x13, 0xEC, 0x77, 0x83, 0x7D, 0xFD, 0x73, 0x87, 0x9F, 0xEB, 0xEF, 0x80,
  0x1A, 0x85, 0x20, 0x1E, 0xF0, 0x4F, 0x02, 0x04, 0xA8, 0x01, 0xB0, 0x20, 0x1A, 0x03, 0x30, 0x12,
  0x09, 0xA8, 0x2C, 0xBD, 0xB3, 0x06, 0x0C, 0xA0, 0xC0, 0x61,
  // "Ę" (U+0118)
  0x0A, 0xD8, 0x91, 0x8A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A,
  0xFD, 0xBB, 0xB2, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBC, 0x5A, 0xD0, 0x83, 0x81,
  0x3F, 0x34, 0x82, 0x5F, 0xD6, 0x48, 0x1B, 0xF7,
  // "ę" (U+0119)
  0x28, 0x47, 0xDF, 0xD8, 0x12, 0x87, 0x9F, 0xDB, 0xDF, 0xB0, 0x1A, 0x0F, 0xBA, 0x01, 0x04, 0xF0,
  0x30, 0x4A, 0x60, 0x1A, 0x07, 0x30, 0x32, 0x09, 0xA8, 0x2C, 0xCE, 0xB3, 0x06, 0x0C, 0xB0, 0x76,
  0x0B, 0x06, 0x68, 0x24, 0xFD, 0x76, 0x81, 0xBF, 0x81,
  // "Ě" (U+011A)
  0x81, 0x27, 0x32, 0x87, 0x66, 0x0A, 0xF6, 0xBF, 0x32, 0x0D, 0xA0, 0x67, 0x71, 0x0A, 0xD8, 0x91,
  0x8A, 0xFD, 0xBB, 0xB5, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x0A, 0xD8, 0x91, 0x3A, 0xFD, 0xBB, 0xB2,
  0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xDB, 0xBB, 0x5A, 0xD0, 0x80,
  // "ě" (U+011B)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x38, 0x4A, 0xF6, 0xBF, 0x34, 0x0D, 0xA0, 0x67, 0x68, 0x37, 0xDF,
  0xD7, 0x38, 0x79, 0xFE, 0xBE, 0xF8, 0x01, 0xA8, 0x52, 0x01, 0xEF, 0x04, 0xF0, 0x20, 0x4A, 0x80,
  0x1B, 0x02, 0x01, 0xA0, 0x33, 0x01, 0x20, 0x9A, 0x82, 0xCB, 0xDB, 0x30, 0x60, 0xCA, 0x0C, 0x06,
  0x10,
  // "Ĝ" (U+011C)
  0x48, 0x25, 0x77, 0x15, 0x83, 0x4F, 0xDF, 0xC4, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x38, 0x55,
  0xBE, 0xFD, 0xB4, 0x20, 0xBA, 0x85, 0xDB, 0xDF, 0x30, 0x8A, 0x05, 0x30, 0x12, 0x81, 0xEF, 0x86,
  0x01, 0xA8, 0x14, 0x09, 0xB0, 0xA0, 0x1A, 0x89, 0x13, 0x06, 0xBD, 0xFA, 0x0E, 0xF6, 0x38, 0x68,
  0xFA, 0x09, 0xFE, 0x22, 0x84, 0x8F, 0xA0, 0x1D, 0xA8, 0x3C, 0xBE, 0xFA, 0x28, 0x61, 0x8D, 0xFE,
  0xDB, 0x50,
  // "ĝ" (U+011D)
  0x38, 0x25, 0x77, 0x14, 0x83, 0x4F, 0xDF, 0xC3, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x48, 0x90, 0x1A,
  0xEE, 0x7A, 0xF5, 0x0A, 0xA0, 0xC0, 0xEA, 0x05, 0x01, 0xA8, 0x14, 0x01, 0xA0, 0x50, 0x4A, 0x38,
  0x2C, 0xF5, 0x4A, 0x38, 0x2C, 0xF5, 0x2A, 0x86, 0x40, 0x1E, 0xF5, 0x0B, 0xA0, 0xC0, 0xEA, 0x89,
  0x05, 0x01, 0xBF, 0xD6, 0xEF, 0x55, 0x02, 0xA8, 0x73, 0x0C, 0xDC, 0xBE, 0xFC, 0x28, 0x58, 0xDE,
  0xED, 0x81, 0x10,
  // "Ğ" (U+011E)
  0x30, 0x20, 0x73, 0x07, 0x02, 0x38, 0x52, 0xFD, 0xBD, 0xE1, 0x48, 0x35, 0xDE, 0xC3, 0x77, 0x73,
  0x85, 0x5B, 0xEF, 0xDB, 0x42, 0x0B, 0xA8, 0x5D, 0xBD, 0xF3, 0x08, 0xA0, 0x53, 0x01, 0x28, 0x1E,
  0xF8, 0x60, 0x1A, 0x81, 0x40, 0x9B, 0x0A, 0x01, 0xA8, 0x91, 0x30, 0x6B, 0xDF, 0xA0, 0xEF, 0x63,
  0x86, 0x8F, 0xA0, 0x9F, 0xE2, 0x28, 0x48, 0xFA, 0x01, 0xDA, 0x83, 0xCB, 0xEF, 0xA2, 0x86, 0x18,
  0xDF, 0xED, 0xB5,
  // "ğ" (U+011F)
  0x10, 0x20, 0x73, 0x07, 0x02, 0x28, 0x52, 0xFD, 0xBD, 0xE1, 0x38, 0x35, 0xDE, 0xC3, 0x75, 0x89,
  0x01, 0xAE, 0xE7, 0xAF, 0x50, 0xAA, 0x0C, 0x0E, 0xA0, 0x50, 0x1A, 0x81, 0x40, 0x1A, 0x05, 0x04,
  0xA3, 0x82, 0xCF, 0x54, 0xA3, 0x82, 0xCF, 0x52, 0xA8, 0x64, 0x01, 0xEF, 0x50, 0xBA, 0x0C, 0x0E,
  0xA8, 0x90, 0x50, 0x1B, 0xFD, 0x6E, 0xF5, 0x50, 0x2A, 0x87, 0x30, 0xCD, 0xCB, 0xEF, 0xC2, 0x85,
  0x8D, 0xEE, 0xD8, 0x11,
  // "Ġ" (U+0120)
  0x48, 0x12, 0xA8, 0x78, 0x13, 0xEC, 0x77, 0x75, 0x85, 0x5B, 0xEF, 0xDB, 0x42, 0x0B, 0xA8, 0x5D,
  0xBD, 0xF3, 0x08, 0xA0, 0x53, 0x01, 0x28, 0x1E, 0xF8, 0x60, 0x1A, 0x81, 0x40, 0x9B, 0x0A, 0x01,
  0xA8, 0x91, 0x30, 0x6B, 0xDF, 0xA0, 0xEF, 0x63, 0x86, 0x8F, 0xA0, 0x9F, 0xE2, 0x28, 0x48, 0xFA,
  0x01, 0xDA, 0x83, 0xCB, 0xEF, 0xA2, 0x86, 0x18, 0xDF, 0xED, 0xB5,
  // "ġ" (U+0121)
  0x38, 0x12, 0xA8, 0x68, 0x13, 0xEC, 0x76, 0x89, 0x01, 0xAE, 0xE7, 0xAF, 0x50, 0xAA, 0x0C, 0x0E,
  0xA0, 0x50, 0x1A, 0x81, 0x40, 0x1A, 0x05, 0x04, 0xA3, 0x82, 0xCF, 0x54, 0xA3, 0x82, 0xCF, 0x52,
  0xA8, 0x64, 0x01, 0xEF, 0x50, 0xBA, 0x0C, 0x0E, 0xA8, 0x90, 0x50, 0x1B, 0xFD, 0x6E, 0xF5, 0x50,
  0x2A, 0x87, 0x30, 0xCD, 0xCB, 0xEF, 0xC2, 0x85, 0x8D, 0xEE, 0xD8, 0x11,
  // "Ģ" (U+0122)
  0x38, 0x55, 0xBE, 0xFD, 0xB4, 0x20, 0xBA, 0x85, 0xDB, 0xDF, 0x30, 0x8A, 0x05, 0x30, 0x12, 0x81,
  0xEF, 0x86, 0x01, 0xA8, 0x14, 0x09, 0xB0, 0xA0, 0x1A, 0x89, 0x13, 0x06, 0xBD, 0xFA, 0x0E, 0xF6,
  0x38, 0x68, 0xFA, 0x09, 0xFE, 0x22, 0x84, 0x8F, 0xA0, 0x1D, 0xA8, 0x3C, 0xBE, 0xFA, 0x28, 0x61,
  0x8D, 0xFE, 0xDB, 0x57, 0x71, 0x0B, 0x0A, 0x78, 0x14, 0xF4, 0x30,
  // "ģ" (U+0123)
  0x40, 0xC0, 0xB6, 0x81, 0x5B, 0x57, 0x68, 0x90, 0x1A, 0xEE, 0x7A, 0xF5, 0x0A, 0xA0, 0xC0, 0xEA,
  0x05, 0x01, 0xA8, 0x14, 0x01, 0xA0, 0x50, 0x4A, 0x38, 0x2C, 0xF5, 0x4A, 0x38, 0x2C, 0xF5, 0x2A,
  0x86, 0x40, 0x1E, 0xF5, 0x0B, 0xA0, 0xC0, 0xEA, 0x89, 0x05, 0x01, 0xBF, 0xD6, 0xEF, 0x55, 0x02,
  0xA8, 0x73, 0x0C, 0xDC, 0xBE, 0xFC, 0x28, 0x58, 0xDE, 0xED, 0x81, 0x10,
  // "Ĥ" (U+0124)
  0x38, 0x25, 0x77, 0x15, 0x83, 0x4F, 0xDF, 0xC4, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x18, 0x1A,
  0xF9, 0x30, 0x2A, 0x82, 0x1A, 0xF9, 0x30, 0x2A, 0x82, 0x1A, 0xF9, 0x30, 0x2A, 0x82, 0x1A, 0xF9,
  0x30, 0x2A, 0x01, 0x0A, 0xF9, 0x82, 0x1A, 0xFD, 0x80, 0x0B, 0xA8, 0x21, 0xAF, 0x93, 0x02, 0xA8,
  0x21, 0xAF, 0x93, 0x02, 0xA8, 0x21, 0xAF, 0x93, 0x02, 0xA8, 0x21, 0xAF, 0x93, 0x02, 0xA0, 0x10,
  // "ĥ" (U+0125)
  0x28, 0x25, 0x77, 0x15, 0x83, 0x4F, 0xDF, 0xC4, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x71, 0x81, 0xCF,
  0x67, 0x81, 0xCF, 0x67, 0x81, 0xCF, 0x67, 0x85, 0xCF, 0x7B, 0xFD, 0x83, 0x0C, 0xA0, 0xD0, 0xCA,
  0x06, 0x28, 0x1C, 0xFC, 0x28, 0x1A, 0xFA, 0x28, 0x1C, 0xF7, 0x28, 0x17, 0xFB, 0x28, 0x1C, 0xF6,
  0x28, 0x17, 0xFB, 0x28, 0x1C, 0xF6, 0x28, 0x17, 0xFB, 0x28, 0x1C, 0xF6, 0x28, 0x17, 0xFB, 0x28,
  0x1C, 0xF6, 0x28, 0x17, 0xFB,
  // "Ħ" (U+0126)
  0x18, 0x1A, 0xF9, 0x30, 0x2A, 0x01, 0x1F, 0xC8, 0x37, 0xBE, 0xFD, 0x80, 0x0B, 0xA8, 0x4B, 0x50,
  0xAF, 0x93, 0x02, 0xA0, 0x12, 0x0A, 0xF9, 0x01, 0x28, 0x1A, 0xFD, 0x80, 0x0B, 0xA0, 0x12, 0x81,
  0xAF, 0x93, 0x02, 0xA0, 0x12, 0x81, 0xAF, 0x93, 0x02, 0xA0, 0x12, 0x81, 0xAF, 0x93, 0x02, 0xA0,
  0x12, 0x81, 0xAF, 0x93, 0x02, 0xA0, 0x11,
  // "ħ" (U+0127)
  0x18, 0x1C, 0xF6, 0x5D, 0x0B, 0x38, 0x4B, 0xEF, 0xDB, 0x84, 0x85, 0xCF, 0x57, 0xED, 0x82, 0x83,
  0xCF, 0xAD, 0xCA, 0x83, 0x60, 0xCF, 0xC2, 0x85, 0xBF, 0xA0, 0xCF, 0x72, 0x85, 0x8F, 0xB0, 0xCF,
  0x62, 0x85, 0x7F, 0xB0, 0xCF, 0x62, 0x85, 0x7F, 0xB0, 0xCF, 0x62, 0x85, 0x7F, 0xB0, 0xCF, 0x62,
  0x81, 0x7F, 0xB0,
  // "Ĩ" (U+0128)
  0x18, 0x93, 0x9E, 0xDB, 0xE8, 0x4F, 0xBD, 0xFC, 0x17, 0x71, 0x08, 0xC8, 0x25, 0x02, 0xBA, 0x09,
  0x01, 0x20, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x30, 0x20, 0xAA,
  0x82, 0x91, 0x08, 0xC0, 0x50,
  // "ĩ" (U+0129)
  0x18, 0x93, 0x9E, 0xDB, 0xE8, 0x4F, 0xBD, 0xFC, 0x17, 0x28, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48,
  0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C,
  0xF6, 0x20,
  // "Ī" (U+012A)
  0x85, 0x4B, 0xBB, 0xB6, 0x6C, 0x08, 0x75, 0x08, 0xC8, 0x15, 0x2B, 0xA8, 0x29, 0x10, 0x3A, 0x30,
  0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x20, 0x20, 0xAA, 0x81, 0x91, 0x8C, 0x05,
  // "ī" (U+012B)
  0x85, 0x4B, 0xBB, 0xB6, 0x6C, 0x08, 0x71, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63,
  0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x61,
  // "Ĭ" (U+012C)
  0x02, 0x07, 0x38, 0x95, 0x72, 0x2F, 0xDB, 0xDE, 0x10, 0x5D, 0xEC, 0x37, 0x72, 0x08, 0xC8, 0x25,
  0x02, 0xBA, 0x09, 0x01, 0x20, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A, 0x40, 0x3A,
  0x30, 0x20, 0xAA, 0x82, 0x91, 0x08, 0xC0, 0x50,
  // "ĭ" (U+012D)
  0x02, 0x07, 0x38, 0x95, 0x72, 0x2F, 0xDB, 0xDE, 0x10, 0x5D, 0xEC, 0x37, 0x38, 0x1C, 0xF6, 0x48,
  0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C,
  0xF6, 0x48, 0x1C, 0xF6, 0x20,
  // "Į" (U+012E)
  0x08, 0xC8, 0x15, 0x2B, 0xA8, 0x29, 0x10, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A,
  0x30, 0x3A, 0x20, 0x20, 0xAA, 0x81, 0xA1, 0x8C, 0x06, 0x28, 0x13, 0xF3, 0x38, 0x25, 0xFD, 0x63,
  0x81, 0xBF, 0x70,
  // "į" (U+012F)
  0x18, 0x5B, 0xE5, 0x07, 0xA3, 0x58, 0xB1, 0xCF, 0x60, 0xCF, 0x60, 0xCF, 0x60, 0xCF, 0x60, 0xCF,
  0x60, 0xCF, 0x60, 0xCF, 0x61, 0xA8, 0x93, 0x63, 0xF3, 0x05, 0xFD, 0x60, 0xBF, 0x70,
  // "İ" (U+0130)
  0x18, 0x12, 0xA8, 0x38, 0x13, 0xEC, 0x77, 0x08, 0xC8, 0x15, 0x2B, 0xA8, 0x29, 0x10, 0x3A, 0x30,
  0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x30, 0x3A, 0x20, 0x20, 0xAA, 0x81, 0x91, 0x8C, 0x05,
  // "ı" (U+0131)
  0x8A, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x60,
  // "Ĳ" (U+0132)
  0x08, 0xC8, 0x55, 0x0A, 0xF9, 0x2B, 0xA8, 0x69, 0x10, 0xAF, 0x90, 0x3A, 0x38, 0x3A, 0xF9, 0x03,
  0xA3, 0x83, 0xAF, 0x90, 0x3A, 0x38, 0x3A, 0xF9, 0x03, 0xA3, 0x83, 0xAF, 0x90, 0x3A, 0x38, 0x3A,
  0xF9, 0x03, 0xA3, 0x83, 0xAF, 0x92, 0xAA, 0x85, 0x91, 0x0A, 0xF9, 0x8C, 0x83, 0x50, 0xAF, 0x97,
  0x81, 0xDF, 0x74, 0x81, 0x1B, 0xDA, 0x02, 0x48, 0x31, 0xEF, 0xC4, 0x10,
  // "ĳ" (U+0133)
  0x81, 0xBE, 0x52, 0x84, 0xBE, 0x57, 0xA3, 0x28, 0x17, 0xA3, 0x71, 0x81, 0xCF, 0x62, 0x84, 0xCF,
  0x6C, 0xF6, 0x28, 0x4C, 0xF6, 0xCF, 0x62, 0x84, 0xCF, 0x6C, 0xF6, 0x28, 0x4C, 0xF6, 0xCF, 0x62,
  0x84, 0xCF, 0x6C, 0xF6, 0x28, 0x4C, 0xF6, 0xCF, 0x62, 0x84, 0xCF, 0x6C, 0xF6, 0x28, 0x1C, 0xF6,
  0x58, 0x1D, 0xF6, 0x30, 0xB0, 0xDA, 0x02, 0x38, 0x2D, 0xFD, 0x61,
  // "Ĵ" (U+0134)
  0x38, 0x25, 0x77, 0x13, 0x83, 0x4F, 0xDF, 0xC2, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x75, 0x81, 0xAF,
  0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95,
  0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xDF, 0x72, 0x81,
  0x1B, 0xDA, 0x02, 0x28, 0x31, 0xEF, 0xC4, 0x30,
  // "ĵ" (U+0135)
  0x28, 0x25, 0x77, 0x12, 0x89, 0x34, 0xFD, 0xFC, 0x02, 0xEB, 0x14, 0xEA, 0x72, 0x81, 0xCF, 0x64,
  0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81,
  0xCF, 0x64, 0x81, 0xCF, 0x64, 0x81, 0xDF, 0x62, 0x0B, 0x0D, 0xA0, 0x22, 0x82, 0xDF, 0xD6, 0x30,
  // "Ķ" (U+0136)
  0x81, 0xAF, 0x92, 0x85, 0x1E, 0xF7, 0xAF, 0x92, 0x89, 0x1C, 0xFA, 0x0A, 0xF9, 0x0A, 0xFC, 0x28,
  0x5A, 0xF9, 0x8F, 0xD1, 0x28, 0x1A, 0xFD, 0xA0, 0x53, 0x0A, 0xA8, 0x1E, 0xFD, 0x38, 0x5A, 0xFB,
  0x1D, 0xF9, 0x28, 0x3A, 0xF9, 0x04, 0xA8, 0x34, 0x0A, 0xF9, 0x28, 0x59, 0xFD, 0x0A, 0xF9, 0x28,
  0x21, 0xDF, 0x97, 0x58, 0x17, 0xB3, 0x60, 0xE0, 0xA4,
  // "ķ" (U+0137)
  0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x81, 0xCF, 0x65, 0x8A, 0x4C, 0xF6, 0x01, 0xCF, 0x9C, 0xF6,
  0x0C, 0xFA, 0x0C, 0xF6, 0xBF, 0xB2, 0x81, 0xCF, 0xDA, 0x01, 0x20, 0xCA, 0x81, 0xEF, 0x92, 0x8A,
  0x1C, 0xF8, 0x2E, 0xF5, 0x0C, 0xF6, 0x05, 0xFE, 0x2C, 0xF6, 0x28, 0x1A, 0xFD, 0x73, 0x81, 0x2B,
  0x85, 0x81, 0x7E, 0x23,
  // "ĸ" (U+0138)
  0x81, 0xCF, 0x62, 0x8A, 0x4A, 0xFA, 0xCF, 0x60, 0x9F, 0xB0, 0xCF, 0x67, 0xFD, 0x10, 0xCF, 0xAA,
  0x02, 0x20, 0xCC, 0x08, 0x28, 0xA1, 0xCF, 0xA3, 0xEF, 0x50, 0xCF, 0x60, 0x5F, 0xE2, 0xCF, 0x62,
  0x81, 0x9F, 0xD0,
  // "Ĺ" (U+0139)
  0x28, 0x16, 0x75, 0x38, 0x25, 0xFC, 0x12, 0x81, 0x2E, 0xA7, 0x74, 0x81, 0xAF, 0x94, 0x81, 0xAF,
  0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94,
  0x81, 0xAF, 0x94, 0x86, 0xAF, 0xEC, 0xCC, 0xCA, 0xE0,
  // "ĺ" (U+013A)
  0x28, 0x91, 0x67, 0x50, 0x5F, 0xC1, 0x2E, 0xA7, 0x18, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C,
  0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6,
  0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x10,
  // "Ļ" (U+013B)
  0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81,
  0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x86, 0xAF, 0xEC, 0xCC, 0xCA, 0xE7, 0x28, 0x13,
  0xB8, 0x48, 0x18, 0xE2, 0x20,
  // "ļ" (U+013C)
  0x8B, 0x7C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF, 0x6C, 0xF6, 0xCF,
  0x6C, 0xF6, 0x38, 0x36, 0xB4, 0xDB, 0x10,
  // "Ľ" (U+013D)
  0x81, 0xAF, 0x92, 0x84, 0xCF, 0x2A, 0xF9, 0x28, 0x4B, 0x50, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81,
  0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x81, 0xAF, 0x95, 0x87, 0xAF, 0xEC, 0xCC, 0xC0,
  0xAE, 0x10,
  // "ľ" (U+013E)
  0x89, 0x5C, 0xF6, 0xDE, 0x1C, 0xF7, 0xB4, 0x0C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38,
  0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C,
  0xF6, 0x30,
  // "Ŀ" (U+013F)
  0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x94, 0x89, 0x7A, 0xF9, 0x02, 0xA8, 0xAF, 0x90,
  0x3E, 0xCA, 0xF9, 0x48, 0x1A, 0xF9, 0x48, 0x1A, 0xF9, 0x48, 0x6A, 0xFE, 0xCC, 0xCC, 0xAE,
  // "ŀ" (U+0140)
  0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x89,
  0x3C, 0xF8, 0xA8, 0xCF, 0xAE, 0xCC, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6,
  0x20,
  // "Ł" (U+0141)
  0x18, 0x1A, 0xF9, 0x58, 0x1A, 0xF9, 0x58, 0x1A, 0xF9, 0x58, 0x3A, 0xFC, 0xC1, 0x30, 0xAA, 0x0D,
  0x03, 0x20, 0x9A, 0x0B, 0x48, 0x25, 0xEF, 0x95, 0x81, 0xAF, 0x95, 0x87, 0xAF, 0xEC, 0xCC, 0xC0,
  0xAE,
  // "ł" (U+0142)
  0x18, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x4C, 0xFC, 0x20,
  0xDA, 0x07, 0x0C, 0xA8, 0x47, 0x08, 0xEF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF, 0x62, 0x81, 0xCF,
  0x61,
  // "Ń" (U+0143)
  0x58, 0x16, 0x75, 0x68, 0x25, 0xFC, 0x15, 0x81, 0x2E, 0xA7, 0x77, 0x30, 0xAA, 0x08, 0x38, 0x22,
  0xFD, 0xAB, 0x02, 0x28, 0x62, 0xFD, 0xAF, 0xDF, 0xB2, 0x8C, 0x42, 0xFD, 0xAF, 0x6E, 0xF5, 0x02,
  0xFD, 0xAF, 0x57, 0xFE, 0x12, 0xFD, 0xAF, 0x50, 0xCF, 0x92, 0xFD, 0xAF, 0x50, 0x3A, 0x84, 0x5F,
  0xDA, 0xF5, 0x28, 0x69, 0xFE, 0xFD, 0xAF, 0x53, 0x0E, 0xA8, 0x2D, 0xAF, 0x53, 0x05, 0xA0, 0xD0,
  // "ń" (U+0144)
  0x48, 0x16, 0x75, 0x48, 0x25, 0xFC, 0x13, 0x81, 0x2E, 0xA7, 0x48, 0x93, 0xCF, 0x3B, 0xFD, 0x80,
  0xCF, 0xED, 0xCA, 0x82, 0x6C, 0xFC, 0x28, 0x4A, 0xFA, 0xCF, 0x72, 0x84, 0x7F, 0xBC, 0xF6, 0x28,
  0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x81, 0x7F, 0xB0,
  // "Ņ" (U+0145)
  0x0A, 0xA0, 0x83, 0x82, 0x2F, 0xDA, 0xB0, 0x22, 0x86, 0x2F, 0xDA, 0xFD, 0xFB, 0x28, 0xC4, 0x2F,
  0xDA, 0xF6, 0xEF, 0x50, 0x2F, 0xDA, 0xF5, 0x7F, 0xE1, 0x2F, 0xDA, 0xF5, 0x0C, 0xF9, 0x2F, 0xDA,
  0xF5, 0x03, 0xA8, 0x45, 0xFD, 0xAF, 0x52, 0x86, 0x9F, 0xEF, 0xDA, 0xF5, 0x30, 0xEA, 0x82, 0xDA,
  0xF5, 0x30, 0x5A, 0x0D, 0x77, 0x81, 0x9B, 0x27, 0x90, 0x84,
  // "ņ" (U+0146)
  0x89, 0x3C, 0xF3, 0xBF, 0xD8, 0x0C, 0xFE, 0xDC, 0xA8, 0x26, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7,
  0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F,
  0xBC, 0xF6, 0x28, 0x17, 0xFB, 0x74, 0x00, 0xA5, 0x81, 0x3F, 0x63,
  // "Ň" (U+0147)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x48, 0x4A, 0xF6, 0xBF, 0x35, 0x0D, 0xA0, 0x67, 0x77, 0x20, 0xAA,
  0x08, 0x38, 0x22, 0xFD, 0xAB, 0x02, 0x28, 0x62, 0xFD, 0xAF, 0xDF, 0xB2, 0x8C, 0x42, 0xFD, 0xAF,
  0x6E, 0xF5, 0x02, 0xFD, 0xAF, 0x57, 0xFE, 0x12, 0xFD, 0xAF, 0x50, 0xCF, 0x92, 0xFD, 0xAF, 0x50,
  0x3A, 0x84, 0x5F, 0xDA, 0xF5, 0x28, 0x69, 0xFE, 0xFD, 0xAF, 0x53, 0x0E, 0xA8, 0x2D, 0xAF, 0x53,
  0x05, 0xA0, 0xD0,
  // "ň" (U+0148)
  0x81, 0x27, 0x32, 0x00, 0x62, 0x84, 0xAF, 0x6B, 0xF3, 0x30, 0xDA, 0x06, 0x73, 0x89, 0x3C, 0xF3,
  0xBF, 0xD8, 0x0C, 0xFE, 0xDC, 0xA8, 0x26, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7, 0x28, 0x47, 0xFB,
  0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28,
  0x17, 0xFB,
  // "ŉ" (U+0149)
  0x81, 0x3F, 0xE7, 0x18, 0x16, 0xF8, 0x71, 0x89, 0x0A, 0xE1, 0xCF, 0x3B, 0xFD, 0x84, 0x83, 0xCF,
  0xED, 0xCA, 0x06, 0x38, 0x1C, 0xFC, 0x28, 0x1A, 0xFA, 0x38, 0x1C, 0xF7, 0x28, 0x17, 0xFB, 0x38,
  0x1C, 0xF6, 0x28, 0x17, 0xFB, 0x38, 0x1C, 0xF6, 0x28, 0x17, 0xFB, 0x38, 0x1C, 0xF6, 0x28, 0x17,
  0xFB, 0x38, 0x1C, 0xF6, 0x28, 0x17, 0xFB,
  // "Ŋ" (U+014A)
  0x0A, 0xA0, 0x93, 0x82, 0x2F, 0xDA, 0xB0, 0x52, 0x8B, 0x12, 0xFD, 0xAF, 0xDF, 0xE2, 0x02, 0xFD,
  0xAF, 0x5D, 0xFC, 0x02, 0xFD, 0xAF, 0x53, 0xA8, 0x79, 0x2F, 0xDA, 0xF5, 0x07, 0xA8, 0x47, 0xFD,
  0xAF, 0x52, 0x0B, 0xB8, 0x2D, 0xAF, 0x52, 0x01, 0x0D, 0xA8, 0x2D, 0xAF, 0x53, 0x03, 0xA8, 0x2D,
  0xAF, 0x54, 0x81, 0x7F, 0xD7, 0x81, 0x4F, 0xB5, 0x00, 0xBA, 0x07, 0x58, 0x2E, 0xFD, 0x71,
  // "ŋ" (U+014B)
  0x87, 0xCF, 0x4B, 0xEE, 0x80, 0xCA, 0x0D, 0x0C, 0xA8, 0x27, 0xCF, 0xC2, 0x84, 0xAF, 0xAC, 0xF7,
  0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F,
  0xBC, 0xF6, 0x28, 0x17, 0xFB, 0x58, 0x18, 0xFB, 0x30, 0x30, 0xBA, 0x08, 0x38, 0x33, 0xEE, 0xA1,
  // "Ō" (U+014C)
  0x38, 0x44, 0xBB, 0xBB, 0x65, 0x06, 0xC0, 0x87, 0x77, 0x68, 0x48, 0xCE, 0xEC, 0x73, 0x01, 0x0D,
  0xA0, 0x0C, 0xA0, 0xC2, 0x82, 0x9F, 0xE2, 0x28, 0x63, 0xEF, 0x80, 0xEF, 0x74, 0x82, 0x8F, 0xD1,
  0xA0, 0x44, 0x05, 0xA0, 0x1A, 0x04, 0x40, 0x5A, 0x18, 0x1E, 0xF7, 0x48, 0x68, 0xFD, 0x09, 0xFE,
  0x22, 0x85, 0x3E, 0xF8, 0x01, 0xDA, 0x00, 0xCA, 0x0C, 0x48, 0x48, 0xDE, 0xEC, 0x72,
  // "ō" (U+014D)
  0x28, 0x44, 0xBB, 0xBB, 0x63, 0x06, 0xC0, 0x87, 0x58, 0x47, 0xDF, 0xD9, 0x12, 0x09, 0xA8, 0x4C,
  0xEF, 0xC0, 0x1A, 0x85, 0x40, 0x1E, 0xF5, 0x4A, 0x38, 0x2B, 0xF8, 0x4A, 0x38, 0x2B, 0xF8, 0x1A,
  0x86, 0x40, 0x1E, 0xF5, 0x08, 0xA8, 0x2C, 0xEF, 0xD3, 0x84, 0x6D, 0xFE, 0x91, 0x10,
  // "Ŏ" (U+014E)
  0x30, 0x20, 0x73, 0x07, 0x02, 0x48, 0x52, 0xFD, 0xBD, 0xE1, 0x58, 0x35, 0xDE, 0xC3, 0x77, 0x76,
  0x84, 0x8C, 0xEE, 0xC7, 0x30, 0x10, 0xDA, 0x00, 0xCA, 0x0C, 0x28, 0x29, 0xFE, 0x22, 0x86, 0x3E,
  0xF8, 0x0E, 0xF7, 0x48, 0x28, 0xFD, 0x1A, 0x04, 0x40, 0x5A, 0x01, 0xA0, 0x44, 0x05, 0xA1, 0x81,
  0xEF, 0x74, 0x86, 0x8F, 0xD0, 0x9F, 0xE2, 0x28, 0x53, 0xEF, 0x80, 0x1D, 0xA0, 0x0C, 0xA0, 0xC4,
  0x84, 0x8D, 0xEE, 0xC7, 0x20,
  // "ŏ" (U+014F)
  0x10, 0x20, 0x73, 0x07, 0x02, 0x28, 0x52, 0xFD, 0xBD, 0xE1, 0x38, 0x35, 0xDE, 0xC3, 0x76, 0x84,
  0x7D, 0xFD, 0x91, 0x20, 0x9A, 0x84, 0xCE, 0xFC, 0x01, 0xA8, 0x54, 0x01, 0xEF, 0x54, 0xA3, 0x82,
  0xBF, 0x84, 0xA3, 0x82, 0xBF, 0x81, 0xA8, 0x64, 0x01, 0xEF, 0x50, 0x8A, 0x82, 0xCE, 0xFD, 0x38,
  0x46, 0xDF, 0xE9, 0x11,
  // "Ő" (U+0150)
  0x48, 0x43, 0xB9, 0x4B, 0x94, 0x84, 0x2D, 0x93, 0xE8, 0x77, 0x76, 0x84, 0x8C, 0xEE, 0xC7, 0x30,
  0x10, 0xDA, 0x00, 0xCA, 0x0C, 0x28, 0x29, 0xFE, 0x22, 0x86, 0x3E, 0xF8, 0x0E, 0xF7, 0x48, 0x28,
  0xFD, 0x1A, 0x04, 0x40, 0x5A, 0x01, 0xA0, 0x44, 0x05, 0xA1, 0x81, 0xEF, 0x74, 0x86, 0x8F, 0xD0,
  0x9F, 0xE2, 0x28, 0x53, 0xEF, 0x80, 0x1D, 0xA0, 0x0C, 0xA0, 0xC4, 0x84, 0x8D, 0xEE, 0xC7, 0x20,
  // "ő" (U+0151)
  0x38, 0x43, 0xB9, 0x4B, 0x92, 0x84, 0x2D, 0x93, 0xE8, 0x75, 0x84, 0x7D, 0xFD, 0x91, 0x20, 0x9A,
  0x84, 0xCE, 0xFC, 0x01, 0xA8, 0x54, 0x01, 0xEF, 0x54, 0xA3, 0x82, 0xBF, 0x84, 0xA3, 0x82, 0xBF,
  0x81, 0xA8, 0x64, 0x01, 0xEF, 0x50, 0x8A, 0x82, 0xCE, 0xFD, 0x38, 0x46, 0xDF, 0xE9, 0x11,
  // "Œ" (U+0152)
  0x28, 0x11, 0x9D, 0xF9, 0x8A, 0x2A, 0x01, 0xDF, 0xEC, 0xCE, 0xFD, 0xBB, 0xB8, 0x09, 0xFD, 0x12,
  0x81, 0xAF, 0x95, 0x81, 0xEF, 0x63, 0x81, 0xAF, 0x94, 0x01, 0xA0, 0x33, 0x0A, 0xD0, 0x60, 0x1A,
  0x03, 0x38, 0x91, 0xAF, 0xDB, 0xBB, 0x50, 0xEF, 0x63, 0x81, 0xAF, 0x95, 0x82, 0x9F, 0xD1, 0x28,
  0x1A, 0xF9, 0x58, 0x93, 0x1D, 0xFE, 0xCC, 0xEF, 0xDB, 0xBB, 0x82, 0x81, 0x19, 0xDF, 0x90, 0xA0,
  // "œ" (U+0153)
  0x28, 0x91, 0x7D, 0xFD, 0x71, 0x9E, 0xEC, 0x52, 0x09, 0xA8, 0x5C, 0xEF, 0xEF, 0xDB, 0xA0, 0x60,
  0x1A, 0x84, 0x40, 0x1E, 0xFC, 0x28, 0x24, 0xFD, 0x4A, 0x30, 0xBF, 0x04, 0xA3, 0x81, 0xBF, 0xD8,
  0x01, 0xB0, 0x1A, 0x84, 0x40, 0x1E, 0xFD, 0x48, 0x11, 0x08, 0xA0, 0xC0, 0xEB, 0x83, 0xEB, 0xCE,
  0x82, 0x89, 0x26, 0xDF, 0xE9, 0x18, 0xDF, 0xEB, 0x40,
  // "Ŕ" (U+0154)
  0x48, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x77, 0x10, 0xAB, 0x81, 0xEB, 0x52,
  0x83, 0xAF, 0xDB, 0xDA, 0x83, 0x50, 0xAF, 0x92, 0x85, 0xBF, 0xA0, 0xAF, 0x92, 0x89, 0x4B, 0xFA,
  0x0A, 0xFD, 0xBD, 0xFE, 0x20, 0xAC, 0x0E, 0x01, 0x28, 0x5A, 0xF9, 0x0C, 0xF7, 0x28, 0x3A, 0xF9,
  0x03, 0xA8, 0x32, 0x0A, 0xF9, 0x28, 0x59, 0xFC, 0x0A, 0xF9, 0x38, 0x1D, 0xF8,
  // "ŕ" (U+0155)
  0x38, 0x16, 0x75, 0x28, 0x65, 0xFC, 0x10, 0x2E, 0xA7, 0x18, 0x96, 0xCE, 0x2A, 0xF6, 0xCF, 0xEE,
  0xC4, 0xCF, 0xC1, 0x28, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38, 0x1C, 0xF6, 0x38,
  0x1C, 0xF6, 0x30,
  // "Ŗ" (U+0156)
  0x0A, 0xB8, 0x1E, 0xC6, 0x28, 0x3A, 0xFD, 0xBD, 0xA8, 0x36, 0x0A, 0xF9, 0x28, 0x94, 0xAF, 0xB0,
  0xAF, 0x90, 0x2C, 0xF9, 0x0A, 0xD8, 0x7C, 0x10, 0xAF, 0xDB, 0xFE, 0x38, 0x5A, 0xF9, 0x0B, 0xF9,
  0x28, 0x3A, 0xF9, 0x02, 0xA8, 0x34, 0x0A, 0xF9, 0x28, 0x58, 0xFD, 0x0A, 0xF9, 0x38, 0x1D, 0xF8,
  0x75, 0x81, 0x6B, 0x56, 0x0B, 0x0C, 0x40,
  // "ŗ" (U+0157)
  0x89, 0x6C, 0xE2, 0xAF, 0x6C, 0xFE, 0xEC, 0x4C, 0xFC, 0x12, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63,
  0x81, 0xCF, 0x63, 0x81, 0xCF, 0x63, 0x81, 0xCF, 0x67, 0x28, 0x16, 0xB4, 0x30, 0x0C, 0x40,
  // "Ř" (U+0158)
  0x81, 0x27, 0x32, 0x00, 0x63, 0x84, 0xAF, 0x6B, 0xF3, 0x40, 0xDA, 0x06, 0x77, 0x70, 0xAB, 0x81,
  0xEB, 0x52, 0x83, 0xAF, 0xDB, 0xDA, 0x83, 0x50, 0xAF, 0x92, 0x85, 0xBF, 0xA0, 0xAF, 0x92, 0x89,
  0x4B, 0xFA, 0x0A, 0xFD, 0xBD, 0xFE, 0x20, 0xAC, 0x0E, 0x01, 0x28, 0x5A, 0xF9, 0x0C, 0xF7, 0x28,
  0x3A, 0xF9, 0x03, 0xA8, 0x32, 0x0A, 0xF9, 0x28, 0x59, 0xFC, 0x0A, 0xF9, 0x38, 0x1D, 0xF8,
  // "ř" (U+0159)
  0x81, 0x27, 0x32, 0x87, 0x66, 0x0A, 0xF6, 0xBF, 0x32, 0x0D, 0xA0, 0x67, 0x28, 0xA0, 0xCE, 0x2A,
  0xF6, 0x0C, 0xFE, 0xEC, 0x40, 0xCF, 0xC1, 0x38, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6,
  0x48, 0x1C, 0xF6, 0x48, 0x1C, 0xF6, 0x30,
  // "Ś" (U+015A)
  0x48, 0x16, 0x75, 0x48, 0x25, 0xFC, 0x13, 0x81, 0x2E, 0xA7, 0x76, 0x89, 0x61, 0x9D, 0xFD, 0xA3,
  0x0C, 0xFE, 0xBD, 0xF3, 0x1A, 0x02, 0x20, 0x22, 0xA0, 0x85, 0x06, 0xA0, 0xE0, 0x74, 0x03, 0x0B,
  0xA0, 0xD0, 0x14, 0x84, 0x3D, 0xF8, 0x23, 0x38, 0x6A, 0xF9, 0x4F, 0xEC, 0xCA, 0x86, 0x42, 0xAD,
  0xFE, 0xB4, 0x10,
  // "ś" (U+015B)
  0x48, 0x16, 0x75, 0x38, 0x25, 0xFC, 0x12, 0x81, 0x2E, 0xA7, 0x38, 0x55, 0xCE, 0xEB, 0x52, 0xA8,
  0x3C, 0xCF, 0x73, 0xA8, 0x12, 0x01, 0x20, 0xAA, 0x0B, 0x04, 0x30, 0x40, 0xAA, 0x81, 0x71, 0x12,
  0x89, 0x76, 0xFD, 0x4F, 0xDB, 0xEF, 0xA2, 0xBE, 0xFD, 0x91,
  // "Ŝ" (U+015C)
  0x38, 0x25, 0x77, 0x13, 0x83, 0x4F, 0xDF, 0xC2, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x73, 0x89, 0x61,
  0x9D, 0xFD, 0xA3, 0x0C, 0xFE, 0xBD, 0xF3, 0x1A, 0x02, 0x20, 0x22, 0xA0, 0x85, 0x06, 0xA0, 0xE0,
  0x74, 0x03, 0x0B, 0xA0, 0xD0, 0x14, 0x84, 0x3D, 0xF8, 0x23, 0x38, 0x6A, 0xF9, 0x4F, 0xEC, 0xCA,
  0x86, 0x42, 0xAD, 0xFE, 0xB4, 0x10,
  // "ŝ" (U+015D)
  0x28, 0x25, 0x77, 0x12, 0x89, 0x34, 0xFD, 0xFC, 0x02, 0xEB, 0x14, 0xEA, 0x71, 0x85, 0x5C, 0xEE,
  0xB5, 0x2A, 0x83, 0xCC, 0xF7, 0x3A, 0x81, 0x20, 0x12, 0x0A, 0xA0, 0xB0, 0x43, 0x04, 0x0A, 0xA8,
  0x17, 0x11, 0x28, 0x97, 0x6F, 0xD4, 0xFD, 0xBE, 0xFA, 0x2B, 0xEF, 0xD9, 0x10,
  // "Ş" (U+015E)
  0x18, 0x96, 0x19, 0xDF, 0xDA, 0x30, 0xCF, 0xEB, 0xDF, 0x31, 0xA0, 0x22, 0x02, 0x2A, 0x08, 0x50,
  0x6A, 0x0E, 0x07, 0x40, 0x30, 0xBA, 0x0D, 0x01, 0x48, 0x43, 0xDF, 0x82, 0x33, 0x86, 0xAF, 0x94,
  0xFE, 0xCC, 0xA8, 0x24, 0x2A, 0xDA, 0x0B, 0x04, 0x48, 0x1A, 0xF7, 0x60, 0xC9, 0x40, 0x4A, 0x0A,
  0x50, 0x20, 0x13,
  // "ş" (U+015F)
  0x18, 0x55, 0xCE, 0xEB, 0x52, 0xA8, 0x3C, 0xCF, 0x73, 0xA8, 0x12, 0x01, 0x20, 0xAA, 0x0B, 0x04,
  0x30, 0x40, 0xAA, 0x81, 0x71, 0x12, 0x89, 0x26, 0xFD, 0x4F, 0xDB, 0xEF, 0xA2, 0xBA, 0x81, 0xD9,
  0x12, 0x81, 0xAF, 0x75, 0x0C, 0x93, 0x04, 0xA0, 0xA4, 0x02, 0x01, 0x30,
  // "Š" (U+0160)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x28, 0x4A, 0xF6, 0xBF, 0x33, 0x0D, 0xA0, 0x67, 0x74, 0x89, 0x61,
  0x9D, 0xFD, 0xA3, 0x0C, 0xFE, 0xBD, 0xF3, 0x1A, 0x02, 0x20, 0x22, 0xA0, 0x85, 0x06, 0xA0, 0xE0,
  0x74, 0x03, 0x0B, 0xA0, 0xD0, 0x14, 0x84, 0x3D, 0xF8, 0x23, 0x38, 0x6A, 0xF9, 0x4F, 0xEC, 0xCA,
  0x86, 0x42, 0xAD, 0xFE, 0xB4, 0x10,
  // "š" (U+0161)
  0x81, 0x27, 0x32, 0x87, 0x66, 0x0A, 0xF6, 0xBF, 0x32, 0x0D, 0xA0, 0x67, 0x28, 0x55, 0xCE, 0xEB,
  0x52, 0xA8, 0x3C, 0xCF, 0x73, 0xA8, 0x12, 0x01, 0x20, 0xAA, 0x0B, 0x04, 0x30, 0x40, 0xAA, 0x81,
  0x71, 0x12, 0x89, 0x76, 0xFD, 0x4F, 0xDB, 0xEF, 0xA2, 0xBE, 0xFD, 0x91,
  // "Ţ" (U+0162)
  0x0A, 0xF8, 0x90, 0x68, 0xBB, 0xEF, 0xDB, 0xB4, 0x38, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C,
  0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1E, 0xF7,
  0x68, 0x1A, 0xF7, 0x70, 0xC9, 0x50, 0x4A, 0x0A, 0x60, 0x20, 0x14,
  // "ţ" (U+0163)
  0x20, 0x60, 0x53, 0x81, 0x2F, 0x92, 0x04, 0x0D, 0xB8, 0x91, 0xE7, 0xDF, 0xEB, 0xA0, 0x9F, 0x93,
  0x81, 0x9F, 0x93, 0x81, 0x9F, 0x93, 0x81, 0x9F, 0xA3, 0x06, 0xA0, 0x0C, 0x28, 0x2C, 0xFE, 0xC2,
  0x81, 0xAF, 0x74, 0x0C, 0x92, 0x04, 0xA0, 0xA3, 0x02, 0x01, 0x20,
  // "Ť" (U+0164)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x38, 0x4A, 0xF6, 0xBF, 0x34, 0x0D, 0xA0, 0x67, 0x76, 0x0A, 0xF8,
  0x90, 0x68, 0xBB, 0xEF, 0xDB, 0xB4, 0x38, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68,
  0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x30,
  // "ť" (U+0165)
  0x68, 0x19, 0xF4, 0x20, 0xD0, 0x92, 0x0A, 0x07, 0x28, 0x14, 0xF9, 0x50, 0x40, 0xEB, 0x0E, 0x38,
  0x47, 0xDF, 0xEB, 0xA4, 0x81, 0x9F, 0x96, 0x81, 0x9F, 0x96, 0x81, 0x9F, 0x96, 0x81, 0x9F, 0xA6,
  0x06, 0xA0, 0x0C, 0x58, 0x2A, 0xEE, 0xC3,
  // "Ŧ" (U+0166)
  0x0A, 0xF8, 0x90, 0x68, 0xBB, 0xEF, 0xDB, 0xB4, 0x38, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x40, 0x9D,
  0x04, 0x28, 0x56, 0xBE, 0xFD, 0xB3, 0x48, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68, 0x1C, 0xF7, 0x68,
  0x1C, 0xF7, 0x30,
  // "ŧ" (U+0167)
  0x20, 0x60, 0x53, 0x81, 0x2F, 0x92, 0x04, 0x0D, 0xB8, 0x91, 0xE7, 0xDF, 0xEB, 0xA0, 0x9F, 0x92,
  0x08, 0xC8, 0x91, 0xA5, 0xDF, 0xEB, 0x70, 0x9F, 0xA3, 0x07, 0xA0, 0xB0, 0xC2, 0x82, 0xAE, 0xEC,
  // "Ũ" (U+0168)
  0x28, 0x49, 0xED, 0xBE, 0x83, 0x85, 0x4F, 0xBD, 0xFC, 0x17, 0x77, 0x18, 0x1B, 0xF8, 0x30, 0x3A,
  0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82,
  0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1A, 0xF9, 0x30, 0x4A, 0x18, 0x28,
  0xFE, 0x12, 0x84, 0xAF, 0xD0, 0x1E, 0xA0, 0xD0, 0xEA, 0x05, 0x28, 0x52, 0x9D, 0xFE, 0xB4, 0x20,
  // "ũ" (U+0169)
  0x18, 0x94, 0x9E, 0xDB, 0xE8, 0x04, 0xFB, 0xDF, 0xC1, 0x72, 0x81, 0xDF, 0x52, 0x84, 0x8F, 0xAD,
  0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84,
  0x9F, 0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87, 0xA1, 0x9E, 0xEB, 0x5F, 0xA0,
  // "Ū" (U+016A)
  0x28, 0x44, 0xBB, 0xBB, 0x64, 0x06, 0xC0, 0x87, 0x77, 0x18, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B,
  0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1B, 0xF8,
  0x30, 0x3A, 0x82, 0x1B, 0xF8, 0x30, 0x3A, 0x82, 0x1A, 0xF9, 0x30, 0x4A, 0x18, 0x28, 0xFE, 0x12,
  0x84, 0xAF, 0xD0, 0x1E, 0xA0, 0xD0, 0xEA, 0x05, 0x28, 0x52, 0x9D, 0xFE, 0xB4, 0x20,
  // "ū" (U+016B)
  0x18, 0x44, 0xBB, 0xBB, 0x62, 0x06, 0xC0, 0x87, 0x28, 0x1D, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52,
  0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x49, 0xFA,
  0xCF, 0x72, 0x86, 0xDF, 0xA9, 0xFE, 0x9C, 0xA8, 0x7A, 0x19, 0xEE, 0xB5, 0xFA,
  // "Ŭ" (U+016C)
  0x10, 0x20, 0x73, 0x07, 0x02, 0x38, 0x52, 0xFD, 0xBD, 0xE1, 0x48, 0x35, 0xDE, 0xC3, 0x77, 0x72,
  0x81, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21,
  0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF,
  0x93, 0x04, 0xA1, 0x82, 0x8F, 0xE1, 0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85,
  0x29, 0xDF, 0xEB, 0x42,
  // "ŭ" (U+016D)
  0x10, 0x20, 0x73, 0x89, 0x07, 0x20, 0x2F, 0xDB, 0xDE, 0x12, 0x83, 0x5D, 0xEC, 0x37, 0x28, 0x1D,
  0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84,
  0x8F, 0xAD, 0xF5, 0x28, 0x49, 0xFA, 0xCF, 0x72, 0x86, 0xDF, 0xA9, 0xFE, 0x9C, 0xA8, 0x7A, 0x19,
  0xEE, 0xB5, 0xFA,
  // "Ů" (U+016E)
  0x28, 0x21, 0xCE, 0xA6, 0x83, 0x5D, 0x2F, 0x35, 0x82, 0x1C, 0xFA, 0x77, 0x73, 0x81, 0xBF, 0x83,
  0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03,
  0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF, 0x93, 0x04, 0xA1,
  0x82, 0x8F, 0xE1, 0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85, 0x29, 0xDF, 0xEB,
  0x42,
  // "ů" (U+016F)
  0x28, 0x21, 0xCE, 0xA4, 0x83, 0x5D, 0x2F, 0x33, 0x82, 0x1C, 0xFA, 0x73, 0x81, 0xDF, 0x52, 0x84,
  0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF,
  0x52, 0x84, 0x9F, 0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87, 0xA1, 0x9E, 0xEB, 0x5F,
  0xA0,
  // "Ű" (U+0170)
  0x38, 0x43, 0xB9, 0x4B, 0x93, 0x84, 0x2D, 0x93, 0xE8, 0x77, 0x71, 0x81, 0xBF, 0x83, 0x03, 0xA8,
  0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21,
  0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF, 0x93, 0x04, 0xA1, 0x82, 0x8F,
  0xE1, 0x28, 0x4A, 0xFD, 0x01, 0xEA, 0x0D, 0x0E, 0xA0, 0x52, 0x85, 0x29, 0xDF, 0xEB, 0x42,
  // "ű" (U+0171)
  0x28, 0x93, 0x3B, 0x94, 0xB9, 0x02, 0xD9, 0x3E, 0x87, 0x28, 0x1D, 0xF5, 0x28, 0x48, 0xFA, 0xDF,
  0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x49,
  0xFA, 0xCF, 0x72, 0x86, 0xDF, 0xA9, 0xFE, 0x9C, 0xA8, 0x7A, 0x19, 0xEE, 0xB5, 0xFA,
  // "Ų" (U+0172)
  0x81, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21,
  0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xBF, 0x83, 0x03, 0xA8, 0x21, 0xAF,
  0x93, 0x04, 0xA1, 0x82, 0x8F, 0xE1, 0x28, 0x4A, 0xFA, 0x01, 0xEA, 0x83, 0xDE, 0xFC, 0x12, 0x81,
  0x29, 0xDA, 0x0C, 0x71, 0x0D, 0x05, 0x78, 0x23, 0xFD, 0x87, 0x81, 0xBF, 0x92,
  // "ų" (U+0173)
  0x81, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5, 0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x8F, 0xAD, 0xF5,
  0x28, 0x48, 0xFA, 0xDF, 0x52, 0x84, 0x9F, 0xAC, 0xF7, 0x28, 0x6D, 0xFA, 0x9F, 0xE9, 0xCA, 0x87,
  0xA1, 0x9E, 0xEB, 0xCF, 0xB4, 0x81, 0x3F, 0x35, 0x82, 0x5F, 0xD6, 0x58, 0x1B, 0xF7,
  // "Ŵ" (U+0174)
  0x68, 0x25, 0x77, 0x17, 0x38, 0x34, 0xFD, 0xFC, 0x72, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x76,
  0x81, 0xDF, 0x53, 0x81, 0xEF, 0x73, 0x84, 0xDF, 0x59, 0xF9, 0x20, 0x3A, 0x0B, 0x20, 0x1A, 0x82,
  0x15, 0xFD, 0x28, 0x17, 0xFE, 0x92, 0x81, 0x5F, 0xC2, 0xA8, 0x91, 0x10, 0xCF, 0x9F, 0x40, 0x9F,
  0x82, 0x89, 0x3C, 0xF5, 0x1F, 0xC5, 0xF9, 0x0D, 0xF4, 0x28, 0x90, 0x7F, 0x95, 0xF8, 0x1F, 0xD1,
  0xA3, 0x89, 0x23, 0xFD, 0x9F, 0x40, 0xCF, 0x6F, 0xB4, 0x81, 0xEF, 0xC9, 0x28, 0x37, 0xFC, 0xF7,
  0x40, 0xAA, 0x0B, 0x20, 0x3B, 0x02, 0x40, 0x6A, 0x07, 0x38, 0x1E, 0xFE, 0x30,
  // "ŵ" (U+0175)
  0x58, 0x25, 0x77, 0x17, 0x18, 0x34, 0xFD, 0xFC, 0x78, 0x52, 0xEB, 0x14, 0xEA, 0x77, 0x28, 0x1A,
  0xF7, 0x28, 0x1E, 0xFC, 0x28, 0x90, 0x9F, 0x86, 0xFB, 0x02, 0xFE, 0x92, 0x82, 0xEF, 0x31, 0xA1,
  0x86, 0x7F, 0x8F, 0x42, 0xFE, 0x28, 0x91, 0xDF, 0x4B, 0xE2, 0xF8, 0x7F, 0xA2, 0x89, 0x18, 0xF7,
  0xEA, 0x0D, 0xBA, 0xF5, 0x28, 0x91, 0x4F, 0xBF, 0x70, 0xAE, 0xDF, 0x13, 0x0E, 0xA8, 0x13, 0x06,
  0xA0, 0xB4, 0x0A, 0xA2, 0x03, 0xA0, 0x72,
  // "Ŷ" (U+0176)
  0x38, 0x25, 0x77, 0x15, 0x83, 0x4F, 0xDF, 0xC4, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x77, 0x18, 0x1B,
  0xFA, 0x38, 0x35, 0xFE, 0x12, 0xA0, 0x32, 0x81, 0xCF, 0x72, 0x85, 0x8F, 0xB0, 0x5F, 0xD3, 0x85,
  0x1E, 0xF3, 0xDF, 0x54, 0x83, 0x6F, 0xEF, 0xB6, 0x0C, 0xA0, 0x26, 0x81, 0x6F, 0xC7, 0x81, 0x6F,
  0xC7, 0x81, 0x6F, 0xC7, 0x81, 0x6F, 0xC4,
  // "ŷ" (U+0177)
  0x38, 0x25, 0x77, 0x14, 0x83, 0x4F, 0xDF, 0xC3, 0x85, 0x2E, 0xB1, 0x4E, 0xA7, 0x38, 0x1C, 0xF9,
  0x20, 0x1A, 0x82, 0x55, 0xFE, 0x28, 0x16, 0xFE, 0x28, 0x5E, 0xF5, 0x0B, 0xF8, 0x28, 0x27, 0xFA,
  0x1A, 0x02, 0x20, 0x1A, 0x81, 0x7F, 0xB4, 0x83, 0x9F, 0xEF, 0x44, 0x03, 0xA0, 0xD6, 0x81, 0xDF,
  0x75, 0x03, 0xA0, 0x13, 0x05, 0x0B, 0xA0, 0x84, 0x82, 0x7F, 0xD7, 0x50,
  // "Ÿ" (U+0178)
  0x28, 0x37, 0x90, 0x88, 0x58, 0x3B, 0xD0, 0xCD, 0x77, 0x72, 0x81, 0xBF, 0xA3, 0x83, 0x5F, 0xE1,
  0x2A, 0x03, 0x28, 0x1C, 0xF7, 0x28, 0x58, 0xFB, 0x05, 0xFD, 0x38, 0x51, 0xEF, 0x3D, 0xF5, 0x48,
  0x36, 0xFE, 0xFB, 0x60, 0xCA, 0x02, 0x68, 0x16, 0xFC, 0x78, 0x16, 0xFC, 0x78, 0x16, 0xFC, 0x78,
  0x16, 0xFC, 0x40,
  // "Ź" (U+0179)
  0x48, 0x16, 0x75, 0x58, 0x25, 0xFC, 0x14, 0x81, 0x2E, 0xA7, 0x77, 0x10, 0x7F, 0x89, 0x02, 0x5B,
  0xBB, 0xBD, 0xFE, 0x14, 0x82, 0x2E, 0xF5, 0x58, 0x1C, 0xF9, 0x58, 0x18, 0xFC, 0x58, 0x24, 0xFE,
  0x24, 0x82, 0x1E, 0xF5, 0x58, 0x1C, 0xF9, 0x50, 0x7A, 0x85, 0xCB, 0xBB, 0xB3, 0x9F, 0x05,
  // "ź" (U+017A)
  0x48, 0x16, 0x75, 0x38, 0x25, 0xFC, 0x12, 0x81, 0x2E, 0xA7, 0x20, 0x5D, 0x0B, 0x04, 0x0F, 0xBA,
  0x09, 0x38, 0x26, 0xFD, 0x12, 0x02, 0xA0, 0x33, 0x81, 0xDF, 0x63, 0x81, 0xAF, 0x93, 0x06, 0xA8,
  0x3C, 0xBB, 0x99, 0xD0, 0xD0,
  // "Ż" (U+017B)
  0x38, 0x12, 0xA8, 0x68, 0x13, 0xEC, 0x77, 0x70, 0x7F, 0x89, 0x02, 0x5B, 0xBB, 0xBD, 0xFE, 0x14,
  0x82, 0x2E, 0xF5, 0x58, 0x1C, 0xF9, 0x58, 0x18, 0xFC, 0x58, 0x24, 0xFE, 0x24, 0x82, 0x1E, 0xF5,
  0x58, 0x1C, 0xF9, 0x50, 0x7A, 0x85, 0xCB, 0xBB, 0xB3, 0x9F, 0x05,
  // "ż" (U+017C)
  0x28, 0x12, 0xA8, 0x48, 0x13, 0xEC, 0x72, 0x05, 0xD0, 0xB0, 0x40, 0xFB, 0xA0, 0x93, 0x82, 0x6F,
  0xD1, 0x20, 0x2A, 0x03, 0x38, 0x1D, 0xF6, 0x38, 0x1A, 0xF9, 0x30, 0x6A, 0x83, 0xCB, 0xB9, 0x9D,
  0x0D,
  // "Ž" (U+017D)
  0x18, 0x12, 0x73, 0x20, 0x06, 0x38, 0x4A, 0xF6, 0xBF, 0x34, 0x0D, 0xA0, 0x67, 0x76, 0x07, 0xF8,
  0x90, 0x25, 0xBB, 0xBB, 0xDF, 0xE1, 0x48, 0x22, 0xEF, 0x55, 0x81, 0xCF, 0x95, 0x81, 0x8F, 0xC5,
  0x82, 0x4F, 0xE2, 0x48, 0x21, 0xEF, 0x55, 0x81, 0xCF, 0x95, 0x07, 0xA8, 0x5C, 0xBB, 0xBB, 0x39,
  0xF0, 0x50,
  // "ž" (U+017E)
  0x81, 0x27, 0x32, 0x87, 0x66, 0x0A, 0xF6, 0xBF, 0x32, 0x0D, 0xA0, 0x67, 0x10, 0x5D, 0x0B, 0x04,
  0x0F, 0xBA, 0x09, 0x38, 0x26, 0xFD, 0x12, 0x02, 0xA0, 0x33, 0x81, 0xDF, 0x63, 0x81, 0xAF, 0x93,
  0x06, 0xA8, 0x3C, 0xBB, 0x99, 0xD0, 0xD0,
  // "ſ" (U+017F)
  0x89, 0x31, 0xBE, 0xEC, 0xAF, 0xEC, 0xAC, 0xF7, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C,
  0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6, 0x28, 0x1C, 0xF6,
  0x20,
  // "Ω" (U+03A9)
  0x28, 0x51, 0x8D, 0xEE, 0xC7, 0x40, 0x30, 0xEA, 0x00, 0xCA, 0x0D, 0x01, 0x28, 0x2C, 0xFC, 0x12,
  0x84, 0x3E, 0xF9, 0x01, 0xA0, 0x54, 0x83, 0x8F, 0xE0, 0x2A, 0x02, 0x48, 0x15, 0xFE, 0x28, 0x1E,
  0xF3, 0x48, 0x17, 0xFC, 0x28, 0x19, 0xF8, 0x48, 0x1B, 0xF5, 0x38, 0x1B, 0xF4, 0x28, 0x17, 0xF9,
  0x28, 0x16, 0xBB, 0xA8, 0x61, 0x4F, 0xEB, 0xB4, 0x9C, 0x01, 0x05, 0xC0, 0x60,
  // "μ" (U+03BC)
  0x81, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6, 0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x7F, 0xBC, 0xF6,
  0x28, 0x47, 0xFB, 0xCF, 0x62, 0x84, 0x8F, 0xBC, 0xF9, 0x28, 0x2D, 0xFB, 0xCA, 0x0C, 0x0D, 0xA8,
  0x92, 0xBC, 0xFC, 0xED, 0x4F, 0xBC, 0xF6, 0x58, 0x1C, 0xF6, 0x58, 0x1C, 0xF6, 0x50,
  // "π" (U+03C0)
  0x05, 0x0E, 0xF9, 0x81, 0x89, 0xBA, 0x87, 0xBB, 0xDF, 0xEB, 0x60, 0x1A, 0x83, 0x10, 0x6F, 0xC3,
  0x01, 0xA8, 0x31, 0x06, 0xFC, 0x30, 0x1A, 0x83, 0x10, 0x6F, 0xC3, 0x01, 0xA8, 0x31, 0x06, 0xFD,
  0x30, 0x1A, 0x81, 0x10, 0x4A, 0x82, 0xC6, 0x01, 0xA0, 0x12, 0x82, 0x9E, 0xE5,
  // "–" (U+2013)
  0x04, 0x80, 0x1B, 0x0A, 0x06, 0xD0, 0xE0,
  // "—" (U+2014)
  0x04, 0x80, 0x91, 0xB0, 0x40, 0x6F, 0xE0, 0x60,
  // "€" (U+20AC)
  0x38, 0x47, 0xCF, 0xEB, 0x22, 0x0C, 0xA8, 0x1C, 0xCE, 0x28, 0x26, 0xFD, 0x14, 0x08, 0xD0, 0x92,
  0x85, 0x2B, 0xFA, 0x33, 0x22, 0x08, 0xD0, 0x22, 0x84, 0x18, 0xFD, 0x33, 0x40, 0x1A, 0x04, 0x60,
  0x7A, 0x81, 0xCC, 0xE4, 0x83, 0x5C, 0xEE, 0xB1,
  // "₿" (U+20BF)
  0x28, 0x17, 0x06, 0x38, 0x21, 0xE1, 0xD2, 0x0A, 0xC8, 0x48, 0x0A, 0xFD, 0xCA, 0x89, 0x69, 0xAF,
  0x90, 0x9F, 0xCA, 0xF9, 0x0B, 0xFA, 0xAC, 0x84, 0xD2, 0xAF, 0xDB, 0xA8, 0x48, 0xAF, 0x90, 0x5A,
  0x83, 0xAF, 0x90, 0x6A, 0x82, 0xAF, 0xDB, 0xA0, 0xB0, 0xAC, 0x09, 0x28, 0x21, 0xE1, 0xD4, 0x81,
  0x60, 0x62,
  // "‘" (U+2018)
  0x18, 0x6C, 0xE4, 0xFA, 0xAF, 0x70,
  // "’" (U+2019)
  0x87, 0x3F, 0xE6, 0xF8, 0xAE, 0x10,
  // "‚" (U+201A)
  0x87, 0x3F, 0xE6, 0xF8, 0xAE, 0x10,
  // "‛" (U+201B)
  0x87, 0xAF, 0x64, 0xFA, 0x0C, 0xE0,
  // "“" (U+201C)
  0x18, 0xA1, 0xCE, 0x05, 0xF5, 0x4F, 0xA0, 0xDF, 0x1A, 0xF7, 0x3F, 0xD1,
  // "”" (U+201D)
  0x8A, 0x23, 0xFE, 0x0C, 0xF5, 0x6F, 0x80, 0xFE, 0x0A, 0xE1, 0x4F, 0x71,
  // "„" (U+201E)
  0x8A, 0x23, 0xFE, 0x0C, 0xF5, 0x6F, 0x80, 0xFE, 0x0A, 0xE1, 0x4F, 0x71,
  // "‟" (U+201F)
  0x8A, 0x3A, 0xF6, 0x3F, 0xD0, 0x4F, 0xA0, 0xDF, 0x10, 0xCE, 0x05, 0xF5,
  // "†" (U+2020)
  0x28, 0x12, 0xFB, 0x59, 0x09, 0x38, 0x52, 0x1D, 0x71, 0x21, 0xD8, 0x6D, 0x06, 0x5D, 0x95, 0x53,
  0x0D, 0x07, 0x50, 0xE0, 0x85, 0x90, 0x94, 0x81, 0x1F, 0xA4, 0x81, 0x2F, 0xB4, 0x81, 0x2F, 0xC2,
  // "‡" (U+2021)
  0x28, 0x11, 0xFC, 0x50, 0xE0, 0xA2, 0x86, 0x16, 0x5D, 0xA5, 0x62, 0xD8, 0x6E, 0x02, 0x0D, 0x91,
  0x23, 0x90, 0xB3, 0x85, 0x10, 0xD9, 0x01, 0x2B, 0x89, 0x0E, 0xFE, 0x17, 0x6D, 0xA6, 0x73, 0x0E,
  0x0A, 0x48, 0x11, 0xFC, 0x20,
  // "•" (U+2022)
  0x18, 0x38, 0xED, 0x43, 0xB0, 0xD0, 0x3B, 0x84, 0xC0, 0x8E, 0xD4,
  // "…" (U+2026)
  0x10, 0x13, 0x01, 0x48, 0x71, 0x0E, 0xF4, 0x0E, 0xF4, 0x28, 0x90, 0xEF, 0x4C, 0xD3, 0x0C, 0xD3,
  0x28, 0x1C, 0xD3,
  // "‰" (U+2030)
  0x18, 0x28, 0xEE, 0x73, 0x81, 0x7F, 0x47, 0x18, 0x90, 0x4F, 0xEE, 0xF3, 0x01, 0xEA, 0x72, 0x89,
  0x07, 0xF5, 0x5F, 0x70, 0xAF, 0x27, 0x28, 0x92, 0x7F, 0x55, 0xF7, 0x3F, 0x87, 0xA7, 0x28, 0x94,
  0x29, 0xA4, 0x03, 0xFE, 0xEF, 0x4C, 0xD9, 0xB8, 0x18, 0x0D, 0xB8, 0xA2, 0x30, 0x7E, 0xE7, 0x6F,
  0x5E, 0xE1, 0xEE, 0x3F, 0xA4, 0xF9, 0x48, 0x95, 0x1E, 0xB0, 0xFC, 0x0C, 0xF4, 0xF8, 0x1F, 0xB4,
  0x89, 0x59, 0xF2, 0x0E, 0xE0, 0xDE, 0x3F, 0x93, 0xFA, 0x38, 0x13, 0xF8, 0x28, 0x91, 0xAF, 0xDF,
  0xA0, 0xEF, 0xDF, 0x63, 0x0C, 0x0D, 0x38, 0x90, 0x1B, 0xEB, 0x10, 0x4D, 0xE9, 0x10,
  // "‹" (U+2039)
  0x30, 0x53, 0x89, 0x78, 0xF9, 0x05, 0xFD, 0x12, 0xEF, 0x30, 0x1D, 0xF5, 0x20, 0x3A, 0x03, 0x28,
  0x15, 0xF8, 0x30, 0x21,
  // "›" (U+203A)
  0x10, 0x20, 0x32, 0x82, 0x2F, 0xE1, 0x28, 0x17, 0xFC, 0x38, 0x1A, 0xFA, 0x28, 0x91, 0xCF, 0x70,
  0xAF, 0xA0, 0x2D, 0xC4, 0x01, 0x20,
  // "⁄" (U+2044)
  0x58, 0x13, 0xF7, 0x50, 0xC0, 0xD5, 0x81, 0x6F, 0x54, 0x81, 0x1E, 0xB5, 0x81, 0x9F, 0x24, 0x81,
  0x3F, 0x85, 0x0C, 0x0D, 0x58, 0x16, 0xF5, 0x48, 0x11, 0xEB, 0x58, 0x19, 0xF2, 0x50,
  // "™" (U+2122)
  0x85, 0x9C, 0xDC, 0x4E, 0x62, 0x8D, 0x7D, 0x70, 0x3B, 0x01, 0xDB, 0x05, 0xD8, 0x03, 0xB0, 0x1C,
  0xC1, 0xA8, 0x80, 0x3B, 0x01, 0xC6, 0x8B, 0x68, 0x03, 0xB0, 0x1C, 0x1F, 0x56, 0x80, 0x14, 0x28,
  0x44, 0x04, 0x02, 0x30,
  // "⅒" (U+2152)
  0x18, 0x21, 0xBF, 0x42, 0x81, 0x3F, 0x77, 0x18, 0x31, 0xDD, 0xF4, 0x20, 0xC0, 0xD7, 0x38, 0x64,
  0x7F, 0x40, 0x6F, 0x57, 0x48, 0x47, 0xF4, 0x1E, 0xB5, 0x81, 0x26, 0x54, 0x89, 0x27, 0xF4, 0x9F,
  0x21, 0xBF, 0x42, 0xEA, 0x0B, 0x38, 0x96, 0x7F, 0x7F, 0x81, 0xDD, 0xF4, 0x8F, 0x5A, 0xF3, 0x40,
  0xC0, 0xD2, 0x89, 0x04, 0x7F, 0x4A, 0xF2, 0x7F, 0x53, 0x81, 0x6F, 0x53, 0x87, 0x7F, 0x49, 0xF3,
  0x8F, 0x42, 0x81, 0x1E, 0xB4, 0x87, 0x7F, 0x45, 0xFB, 0xDF, 0x12, 0x81, 0x9F, 0x24, 0x86, 0x7F,
  0x40, 0x8E, 0xD5, 0x10,
  // "ﬁ" (U+FB01)
  0x28, 0x90, 0x8D, 0xFD, 0x4B, 0xE5, 0x04, 0xA8, 0x90, 0xCC, 0x17, 0xA3, 0x07, 0xFC, 0x60, 0x50,
  0xEB, 0x8A, 0x1A, 0x0C, 0xF6, 0x8D, 0xFE, 0xB8, 0x0C, 0xF6, 0x07, 0xFB, 0x38, 0x5C, 0xF6, 0x07,
  0xFB, 0x38, 0x5C, 0xF6, 0x07, 0xFB, 0x38, 0x5C, 0xF6, 0x07, 0xFB, 0x38, 0x5C, 0xF6, 0x07, 0xFB,
  0x38, 0x5C, 0xF6, 0x07, 0xFB, 0x38, 0x1C, 0xF6,
  // "ﬂ" (U+FB02)
  0x28, 0x90, 0x8D, 0xFD, 0x4C, 0xF6, 0x04, 0xA8, 0x90, 0xCC, 0x1C, 0xF6, 0x07, 0xFC, 0x38, 0x3C,
  0xF6, 0x5E, 0xB8, 0xA1, 0xA0, 0xCF, 0x68, 0xDF, 0xEB, 0x80, 0xCF, 0x60, 0x7F, 0xB3, 0x85, 0xCF,
  0x60, 0x7F, 0xB3, 0x85, 0xCF, 0x60, 0x7F, 0xB3, 0x85, 0xCF, 0x60, 0x7F, 0xB3, 0x85, 0xCF, 0x60,
  0x7F, 0xB3, 0x85, 0xCF, 0x60, 0x7F, 0xB3, 0x81, 0xCF, 0x60,
};

const Font& font_NotoSans_Bold_15() {
  static SmoothFont font(font_NotoSans_Bold_15_data);
  return font;
}

}  // namespace roo_display
