#include "90.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:07 CET 2022
static const uint8_t font_NotoSansMono_Bold_90_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x02, 0x03, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFF, 0xEE, 0xFF, 0xEB, 0x00, 0x8D, 0x00, 0x5B, 0x00, 0x44, 0xFF, 0xEA, 0x00, 0x17, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x18, 0x00, 0x36, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x12, 0x00, 0x00, 0x00, 0x22, 0x00, 0x40, 0x00, 0x36, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x0B, 0x00, 0x2A, 0x00, 0x2A, 0x00, 0x40, 0x00, 0x36, 0x00, 0x00, 0xCC, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x01, 0x65, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x07, 0xFF, 0xFC, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x00, 0x03, 0x22, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x41, 0x00, 0x36, 0x00, 0x05, 0x1A, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x02, 0x00, 0x00, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x00, 0x07, 0xB2, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x14, 0x00, 0x2A, 0x00, 0x21, 0x00, 0x40, 0x00, 0x36, 0x00, 0x09, 0xC9, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x11, 0xFF, 0xF2, 0x00, 0x28, 0x00, 0x40, 0x00, 0x36, 0x00, 0x0A, 0x12, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x0D, 0xFF, 0xF2, 0x00, 0x24, 0x00, 0x40, 0x00, 0x36, 0x00, 0x0B, 0x4F, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x00, 0x1E, 0x00, 0x2F, 0x00, 0x44, 0x00, 0x36, 0x00, 0x0C, 0x8B, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x2F, 0x00, 0x36, 0x00, 0x36, 0x00, 0x0D, 0xAA, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x11, 0xFF, 0xF3, 0x00, 0x23, 0x00, 0x0C, 0x00, 0x36, 0x00, 0x0E, 0x89, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x0D, 0x00, 0x13, 0x00, 0x28, 0x00, 0x1D, 0x00, 0x36, 0x00, 0x0E, 0xE8, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x12, 0x00, 0x00, 0x00, 0x22, 0x00, 0x0F, 0x00, 0x36, 0x00, 0x0F, 0x0F, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x00, 0x0F, 0x4C, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x10, 0x8F, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x12, 0xA2, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x14, 0x0C, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x15, 0x93, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x17, 0x47, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x18, 0xE8, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0x1A, 0x6E, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x1C, 0x3D, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x1D, 0x95, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x1F, 0x79, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x12, 0x00, 0x00, 0x00, 0x22, 0x00, 0x32, 0x00, 0x36, 0x00, 0x21, 0x46, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x11, 0xFF, 0xF3, 0x00, 0x24, 0x00, 0x32, 0x00, 0x36, 0x00, 0x21, 0xC1, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x07, 0x00, 0x0B, 0x00, 0x2E, 0x00, 0x37, 0x00, 0x36, 0x00, 0x22, 0x66, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x06, 0x00, 0x11, 0x00, 0x2F, 0x00, 0x2E, 0x00, 0x36, 0x00, 0x23, 0x8D, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x07, 0x00, 0x0B, 0x00, 0x2E, 0x00, 0x37, 0x00, 0x36, 0x00, 0x23, 0xEA, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x41, 0x00, 0x36, 0x00, 0x25, 0x0E, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0xFF, 0xF9, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x00, 0x26, 0x73, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x29, 0x5D, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x07, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x2B, 0x2D, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x04, 0x00, 0x00, 0x00, 0x32, 0x00, 0x41, 0x00, 0x36, 0x00, 0x2C, 0xF0, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x04, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x2E, 0x9F, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x30, 0x80, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x31, 0xB5, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x02, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x32, 0xF0, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x34, 0xD8, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x00, 0x36, 0x78, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x00, 0x37, 0xBA, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x04, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x39, 0x18, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3B, 0x0D, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3C, 0x47, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3E, 0xC6, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0x40, 0xEF, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x07, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x42, 0xDF, // "P" (U+0050)
  0x00, 0x51, 0x00, 0x02, 0xFF, 0xF0, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0x44, 0x7D, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x07, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x46, 0xC2, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x48, 0x9C, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4A, 0x57, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4B, 0xA8, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4D, 0x7A, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4F, 0x62, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x51, 0xE9, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x53, 0xCE, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x55, 0x7D, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x14, 0xFF, 0xF2, 0x00, 0x2A, 0x00, 0x40, 0x00, 0x36, 0x00, 0x56, 0xC3, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x00, 0x57, 0xEE, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x0B, 0xFF, 0xF4, 0x00, 0x21, 0x00, 0x42, 0x00, 0x36, 0x00, 0x59, 0x2C, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x00, 0x19, 0x00, 0x32, 0x00, 0x41, 0x00, 0x36, 0x00, 0x5A, 0x57, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x35, 0xFF, 0xFA, 0x00, 0x36, 0x00, 0x5B, 0x89, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0C, 0x00, 0x38, 0x00, 0x23, 0x00, 0x46, 0x00, 0x36, 0x00, 0x5B, 0x8F, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x36, 0x00, 0x5B, 0xD1, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x05, 0x00, 0x00, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x00, 0x5D, 0x4D, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x36, 0x00, 0x5F, 0x04, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x03, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x60, 0x42, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x00, 0x61, 0xF6, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x06, 0x00, 0x01, 0x00, 0x33, 0x00, 0x45, 0x00, 0x36, 0x00, 0x63, 0x53, // "f" (U+0066)
  0x00, 0x67, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x32, 0x00, 0x36, 0x00, 0x64, 0xED, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x00, 0x66, 0xDE, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x00, 0x68, 0x57, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x27, 0x00, 0x46, 0x00, 0x36, 0x00, 0x69, 0xD0, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x05, 0x00, 0x01, 0x00, 0x34, 0x00, 0x44, 0x00, 0x36, 0x00, 0x6B, 0xA4, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x00, 0x6D, 0x95, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x32, 0x00, 0x36, 0x00, 0x6F, 0x16, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x00, 0x70, 0xF8, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x00, 0x36, 0x00, 0x72, 0x30, // "o" (U+006F)
  0x00, 0x70, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x32, 0x00, 0x32, 0x00, 0x36, 0x00, 0x73, 0xB1, // "p" (U+0070)
  0x00, 0x71, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x32, 0x00, 0x36, 0x00, 0x75, 0x7A, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x03, 0x00, 0x01, 0x00, 0x34, 0x00, 0x32, 0x00, 0x36, 0x00, 0x77, 0x41, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x36, 0x00, 0x78, 0x8F, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x3D, 0x00, 0x36, 0x00, 0x79, 0xEB, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x7B, 0x35, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x7C, 0x6C, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x31, 0x00, 0x36, 0x00, 0x7D, 0xDA, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x7F, 0xCF, // "x" (U+0078)
  0x00, 0x79, 0x00, 0x02, 0xFF, 0xEB, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x81, 0x44, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x83, 0x3C, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x0C, 0xFF, 0xF1, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x00, 0x84, 0x3F, // "{" (U+007B)
  0x00, 0x7C, 0x00, 0x16, 0xFF, 0xEB, 0x00, 0x1F, 0x00, 0x44, 0x00, 0x36, 0x00, 0x85, 0xC0, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x0C, 0xFF, 0xF3, 0x00, 0x29, 0x00, 0x42, 0x00, 0x36, 0x00, 0x86, 0x74, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x06, 0x00, 0x19, 0x00, 0x2F, 0x00, 0x29, 0x00, 0x36, 0x00, 0x87, 0xF5, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x13, 0xFF, 0xF1, 0x00, 0x23, 0x00, 0x31, 0x00, 0x36, 0x00, 0x88, 0x93, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x89, 0x60, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x8A, 0xEE, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x05, 0x00, 0x0D, 0x00, 0x30, 0x00, 0x36, 0x00, 0x36, 0x00, 0x8C, 0x60, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x8D, 0xC4, // "¥" (U+00A5)
  0x00, 0xA6, 0x00, 0x16, 0xFF, 0xEC, 0x00, 0x1F, 0x00, 0x44, 0x00, 0x36, 0x00, 0x8F, 0x6D, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x45, 0x00, 0x36, 0x00, 0x90, 0x00, // "§" (U+00A7)
  0x00, 0xA8, 0x00, 0x0A, 0x00, 0x38, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x00, 0x91, 0xD5, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x02, 0x00, 0x08, 0x00, 0x33, 0x00, 0x38, 0x00, 0x36, 0x00, 0x92, 0x3F, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0C, 0x00, 0x22, 0x00, 0x28, 0x00, 0x41, 0x00, 0x36, 0x00, 0x94, 0x3A, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x05, 0x00, 0x05, 0x00, 0x30, 0x00, 0x2D, 0x00, 0x36, 0x00, 0x94, 0xFA, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x2E, 0x00, 0x25, 0x00, 0x36, 0x00, 0x96, 0x56, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x02, 0x00, 0x08, 0x00, 0x33, 0x00, 0x38, 0x00, 0x36, 0x00, 0x96, 0xDB, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0D, 0x00, 0x39, 0x00, 0x28, 0x00, 0x41, 0x00, 0x36, 0x00, 0x98, 0xE7, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x0C, 0x00, 0x26, 0x00, 0x29, 0x00, 0x41, 0x00, 0x36, 0x00, 0x99, 0x0B, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x38, 0x00, 0x36, 0x00, 0x99, 0xBB, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0D, 0x00, 0x26, 0x00, 0x29, 0x00, 0x4C, 0x00, 0x36, 0x00, 0x9A, 0xC3, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0D, 0x00, 0x26, 0x00, 0x28, 0x00, 0x4D, 0x00, 0x36, 0x00, 0x9B, 0x92, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x14, 0x00, 0x38, 0x00, 0x2B, 0x00, 0x46, 0x00, 0x36, 0x00, 0x9C, 0x7F, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x9C, 0xC8, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x03, 0xFF, 0xF6, 0x00, 0x31, 0x00, 0x45, 0x00, 0x36, 0x00, 0x9E, 0x6D, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x12, 0x00, 0x18, 0x00, 0x22, 0x00, 0x27, 0x00, 0x36, 0x00, 0xA0, 0xCF, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0x11, 0xFF, 0xEB, 0x00, 0x24, 0x00, 0x00, 0x00, 0x36, 0x00, 0xA1, 0x0C, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x0D, 0x00, 0x26, 0x00, 0x29, 0x00, 0x4C, 0x00, 0x36, 0x00, 0xA1, 0x6F, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x0D, 0x00, 0x22, 0x00, 0x28, 0x00, 0x41, 0x00, 0x36, 0x00, 0xA2, 0x1D, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x05, 0x00, 0x05, 0x00, 0x30, 0x00, 0x2D, 0x00, 0x36, 0x00, 0xA2, 0xE3, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x00, 0x01, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0xA4, 0x3F, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0xA6, 0x49, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x03, 0x00, 0x01, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0xA8, 0x56, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0x05, 0xFF, 0xF0, 0x00, 0x2C, 0x00, 0x31, 0x00, 0x36, 0x00, 0xAA, 0x84, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xAB, 0xEA, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xAE, 0x13, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xB0, 0x43, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x53, 0x00, 0x36, 0x00, 0xB2, 0x89, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x53, 0x00, 0x36, 0x00, 0xB4, 0xC9, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x5B, 0x00, 0x36, 0x00, 0xB7, 0x13, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0xB9, 0x84, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x32, 0x00, 0x41, 0x00, 0x36, 0x00, 0xBB, 0x59, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xBD, 0x8A, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xBF, 0x16, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC0, 0xA6, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x53, 0x00, 0x36, 0x00, 0xC2, 0x48, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC3, 0xEE, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC5, 0x83, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC7, 0x1E, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x53, 0x00, 0x36, 0x00, 0xC8, 0xC9, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0xCA, 0x79, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x53, 0x00, 0x36, 0x00, 0xCC, 0x63, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x00, 0xCE, 0xF8, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x00, 0xD1, 0x41, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x00, 0xD3, 0x90, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x53, 0x00, 0x36, 0x00, 0xD5, 0xF4, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x53, 0x00, 0x36, 0x00, 0xD8, 0x52, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x07, 0x00, 0x0D, 0x00, 0x2E, 0x00, 0x34, 0x00, 0x36, 0x00, 0xDA, 0xBB, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x01, 0xFF, 0xFD, 0x00, 0x34, 0x00, 0x43, 0x00, 0x36, 0x00, 0xDB, 0xE5, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xDE, 0x3F, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xE0, 0x6C, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xE2, 0x9F, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x53, 0x00, 0x36, 0x00, 0xE4, 0xE3, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x00, 0xE7, 0x2B, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x07, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0xE9, 0x3B, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x05, 0x00, 0x00, 0x00, 0x33, 0x00, 0x45, 0x00, 0x36, 0x00, 0xEA, 0xD9, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x00, 0xEC, 0xE3, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x00, 0xEE, 0xB8, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x00, 0xF0, 0x93, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0xF2, 0x7F, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0xF4, 0x65, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x4C, 0x00, 0x36, 0x00, 0xF6, 0x55, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x32, 0x00, 0x36, 0x00, 0xF8, 0x6A, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x36, 0x00, 0xFA, 0x20, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x00, 0xFB, 0xDB, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x00, 0xFD, 0x91, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x00, 0xFF, 0x4E, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x01, 0x1C, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x02, 0xED, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x04, 0x5F, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x05, 0xD8, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x07, 0x61, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x45, 0x00, 0x36, 0x01, 0x08, 0xEE, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x0B, 0x18, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x46, 0x00, 0x36, 0x01, 0x0C, 0xBA, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x46, 0x00, 0x36, 0x01, 0x0E, 0x94, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x46, 0x00, 0x36, 0x01, 0x10, 0x75, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x01, 0x12, 0x69, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x01, 0x14, 0x59, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x06, 0x00, 0x0A, 0x00, 0x2F, 0x00, 0x37, 0x00, 0x36, 0x01, 0x16, 0x50, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x03, 0xFF, 0xFD, 0x00, 0x32, 0x00, 0x34, 0x00, 0x36, 0x01, 0x17, 0x1B, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x18, 0xE5, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x1A, 0x76, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x1C, 0x0D, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x1D, 0xB5, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0x02, 0xFF, 0xEB, 0x00, 0x33, 0x00, 0x46, 0x00, 0x36, 0x01, 0x1F, 0x61, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x01, 0x21, 0xBA, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0x02, 0xFF, 0xEB, 0x00, 0x33, 0x00, 0x44, 0x00, 0x36, 0x01, 0x23, 0xD5, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x50, 0x00, 0x36, 0x01, 0x26, 0x47, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x01, 0x28, 0x4E, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x01, 0x29, 0xFD, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x2C, 0x45, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0x01, 0xFF, 0xEC, 0x00, 0x36, 0x00, 0x40, 0x00, 0x36, 0x01, 0x2E, 0x33, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0x04, 0xFF, 0xEC, 0x00, 0x30, 0x00, 0x32, 0x00, 0x36, 0x01, 0x30, 0x88, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x04, 0x00, 0x00, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0x32, 0x7B, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0x34, 0x89, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0x36, 0x20, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0x38, 0x40, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0x39, 0xE9, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0x3B, 0xF3, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0x3D, 0x86, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0x3F, 0xAA, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x04, 0x00, 0x01, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x01, 0x41, 0x57, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x3D, 0x00, 0x44, 0x00, 0x36, 0x01, 0x43, 0xB0, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x01, 0x46, 0x07, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x03, 0x00, 0x00, 0x00, 0x35, 0x00, 0x44, 0x00, 0x36, 0x01, 0x47, 0xF1, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x50, 0x00, 0x36, 0x01, 0x49, 0xB7, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x01, 0x4B, 0x1C, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x4C, 0xAC, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x4E, 0x4F, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x50, 0x1F, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x51, 0xAB, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0x07, 0xFF, 0xEC, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0x53, 0x64, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x01, 0x55, 0x12, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x56, 0xEC, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x58, 0x92, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x02, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x5A, 0x63, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x5C, 0xBD, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x02, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x5F, 0x1F, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x61, 0x7B, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x63, 0xDF, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0x66, 0x23, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0x02, 0xFF, 0xED, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x01, 0x68, 0x70, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x6A, 0xA5, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x6C, 0xE2, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x31, 0x00, 0x59, 0x00, 0x36, 0x01, 0x6E, 0xF4, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x01, 0x71, 0x11, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x72, 0xC7, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x53, 0x00, 0x36, 0x01, 0x74, 0x5E, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x76, 0x05, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x50, 0x00, 0x36, 0x01, 0x77, 0x88, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x01, 0x78, 0xF9, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x01, 0x7A, 0x45, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x7B, 0xF2, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0x08, 0xFF, 0xEC, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x01, 0x7D, 0x7D, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0x05, 0xFF, 0xEC, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0x7F, 0x2F, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x01, 0x81, 0x23, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x31, 0x00, 0x36, 0x01, 0x82, 0xBA, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x01, 0x83, 0xD3, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x2F, 0x00, 0x46, 0x00, 0x36, 0x01, 0x85, 0x77, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x07, 0x00, 0x00, 0x00, 0x35, 0x00, 0x55, 0x00, 0x36, 0x01, 0x87, 0xC9, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0x03, 0xFF, 0xEB, 0x00, 0x2F, 0x00, 0x46, 0x00, 0x36, 0x01, 0x89, 0xBB, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0x04, 0xFF, 0xED, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x01, 0x8B, 0xD0, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0x05, 0xFF, 0xED, 0x00, 0x34, 0x00, 0x44, 0x00, 0x36, 0x01, 0x8E, 0x14, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x05, 0x00, 0x01, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x01, 0x90, 0x53, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x91, 0xDB, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x59, 0x00, 0x36, 0x01, 0x93, 0x6F, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0x08, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0x95, 0x50, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0x05, 0xFF, 0xED, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0x96, 0xD5, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0x98, 0xA5, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x05, 0x00, 0x01, 0x00, 0x35, 0x00, 0x44, 0x00, 0x36, 0x01, 0x9A, 0x04, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x08, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x01, 0x9B, 0xAC, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x05, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x44, 0x00, 0x36, 0x01, 0x9D, 0x16, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x03, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x01, 0x9E, 0xE3, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x01, 0xA0, 0x66, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0xA2, 0x06, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0xA4, 0x90, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0x04, 0xFF, 0xED, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xA6, 0x27, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0x05, 0xFF, 0xED, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x01, 0xA8, 0x9F, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0xAA, 0x26, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x46, 0x00, 0x36, 0x01, 0xAC, 0xC4, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0xF5, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xAE, 0x6E, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0x04, 0xFF, 0xEF, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xB0, 0x97, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x01, 0xB3, 0x35, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x50, 0x00, 0x36, 0x01, 0xB4, 0xF4, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x41, 0x00, 0x36, 0x01, 0xB7, 0x1A, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x01, 0xB8, 0xCE, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x46, 0x00, 0x36, 0x01, 0xBB, 0x33, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x02, 0x00, 0x00, 0x00, 0x33, 0x00, 0x54, 0x00, 0x36, 0x01, 0xBD, 0x28, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x45, 0x00, 0x36, 0x01, 0xBF, 0x94, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x02, 0x00, 0x00, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x01, 0xC1, 0x8F, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x00, 0x00, 0x00, 0x35, 0x00, 0x32, 0x00, 0x36, 0x01, 0xC3, 0x83, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x07, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x01, 0xC5, 0x6A, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x03, 0x00, 0x01, 0x00, 0x34, 0x00, 0x46, 0x00, 0x36, 0x01, 0xC7, 0xA5, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0x07, 0xFF, 0xED, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x01, 0xC9, 0x52, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0x03, 0xFF, 0xED, 0x00, 0x34, 0x00, 0x32, 0x00, 0x36, 0x01, 0xCB, 0x7A, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x07, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x01, 0xCD, 0x16, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x03, 0x00, 0x01, 0x00, 0x34, 0x00, 0x46, 0x00, 0x36, 0x01, 0xCF, 0x65, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x55, 0x00, 0x36, 0x01, 0xD1, 0x2A, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0xD3, 0x40, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x55, 0x00, 0x36, 0x01, 0xD4, 0xF6, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0xD7, 0x1E, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x01, 0xD8, 0xE5, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x36, 0x01, 0xDB, 0x20, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x06, 0x00, 0x00, 0x00, 0x30, 0x00, 0x55, 0x00, 0x36, 0x01, 0xDC, 0xF9, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x46, 0x00, 0x36, 0x01, 0xDF, 0x24, // "š" (U+0161)
  0x01, 0x62, 0x00, 0x02, 0xFF, 0xEB, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x01, 0xE0, 0xEF, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x2F, 0x00, 0x3D, 0x00, 0x36, 0x01, 0xE2, 0xCC, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x01, 0xE4, 0x98, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x04, 0x00, 0x00, 0x00, 0x33, 0x00, 0x45, 0x00, 0x36, 0x01, 0xE6, 0x62, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x01, 0xE7, 0xF4, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x3D, 0x00, 0x36, 0x01, 0xE9, 0x4A, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x53, 0x00, 0x36, 0x01, 0xEA, 0x8B, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0xEC, 0xC9, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x50, 0x00, 0x36, 0x01, 0xEE, 0x6B, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x01, 0xF0, 0x71, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0xF1, 0xDC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x01, 0xF4, 0x23, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x5B, 0x00, 0x36, 0x01, 0xF5, 0xCD, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x4C, 0x00, 0x36, 0x01, 0xF8, 0x3B, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x54, 0x00, 0x36, 0x01, 0xFA, 0x0C, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0xFC, 0x59, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xFE, 0x0A, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0x04, 0xFF, 0xEC, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x02, 0x00, 0x5A, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x02, 0x02, 0x09, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x46, 0x00, 0x36, 0x02, 0x05, 0x07, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x02, 0x07, 0x75, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0x02, 0xFF, 0xEB, 0x00, 0x33, 0x00, 0x46, 0x00, 0x36, 0x02, 0x09, 0x9A, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x53, 0x00, 0x36, 0x02, 0x0C, 0x07, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x02, 0x0E, 0x31, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x02, 0x0F, 0xD1, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x02, 0x11, 0x32, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x02, 0x12, 0xCE, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x02, 0x14, 0x2A, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x46, 0x00, 0x36, 0x02, 0x15, 0xE0, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x11, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x02, 0x17, 0x56, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x02, 0x18, 0x9F, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x02, 0x1A, 0xB0, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x31, 0x00, 0x36, 0x02, 0x1C, 0x55, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x09, 0x00, 0x13, 0x00, 0x2C, 0x00, 0x1D, 0x00, 0x36, 0x02, 0x1D, 0xE9, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x00, 0x00, 0x13, 0x00, 0x35, 0x00, 0x1D, 0x00, 0x36, 0x02, 0x1D, 0xEC, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x03, 0x00, 0x00, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x02, 0x1D, 0xF0, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x32, 0x00, 0x4A, 0x00, 0x36, 0x02, 0x1F, 0x9F, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x12, 0x00, 0x2B, 0x00, 0x23, 0x00, 0x40, 0x00, 0x36, 0x02, 0x21, 0xF0, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x13, 0x00, 0x2B, 0x00, 0x24, 0x00, 0x40, 0x00, 0x36, 0x02, 0x22, 0x3D, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x11, 0xFF, 0xF3, 0x00, 0x23, 0x00, 0x0C, 0x00, 0x36, 0x02, 0x22, 0x8C, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x12, 0x00, 0x2B, 0x00, 0x23, 0x00, 0x40, 0x00, 0x36, 0x02, 0x22, 0xEB, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x08, 0x00, 0x2B, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x02, 0x23, 0x38, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x08, 0x00, 0x2B, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x02, 0x23, 0xD7, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x0A, 0xFF, 0xF3, 0x00, 0x2F, 0x00, 0x0C, 0x00, 0x36, 0x02, 0x24, 0x76, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x08, 0x00, 0x2B, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x02, 0x25, 0x33, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x02, 0x25, 0xD2, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x44, 0x00, 0x36, 0x02, 0x27, 0x2D, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x0E, 0x00, 0x14, 0x00, 0x27, 0x00, 0x2E, 0x00, 0x36, 0x02, 0x28, 0xBC, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x0F, 0x00, 0x36, 0x02, 0x29, 0x40, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x02, 0x29, 0xFC, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x0E, 0x00, 0x05, 0x00, 0x27, 0x00, 0x2D, 0x00, 0x36, 0x02, 0x2C, 0x55, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x27, 0x00, 0x2E, 0x00, 0x36, 0x02, 0x2D, 0x10, // "›" (U+203A)
  0x20, 0x44, 0xFF, 0xEE, 0x00, 0x01, 0x00, 0x11, 0x00, 0x40, 0x00, 0x00, 0x02, 0x2D, 0xCC, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x00, 0x00, 0x22, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x02, 0x2F, 0x10, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x16, 0x00, 0x01, 0x00, 0x8D, 0x00, 0x40, 0x00, 0xA2, 0x02, 0x30, 0x78, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x02, 0x34, 0x71, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x02, 0x36, 0x5E, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x02, 0x00, 0x01, 0x00, 0x36, 0x00, 0x4E, 0x00, 0x36, 0x02, 0x38, 0x31, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x01, 0x00, 0x12, 0x00, 0x34, 0x00, 0x2F, 0x00, 0x36, 0x02, 0x3A, 0x2C, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x05, 0x00, 0x11, 0x00, 0x30, 0x00, 0x30, 0x00, 0x36, 0x02, 0x3B, 0x6C, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x06, 0x00, 0x06, 0x00, 0x2F, 0x00, 0x3A, 0x00, 0x36, 0x02, 0x3C, 0x6D, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x3B, 0x00, 0x36, 0x02, 0x3D, 0x82, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x3B, 0x00, 0x36, 0x02, 0x3E, 0xF1, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x10, 0x8F, 0xF8, 0x19, 0x07, 0xFF, 0x81, 0x90, 0x7F, 0xF8, 0x18, 0x06, 0xFF, 0x81, 0x70, 0x5F,
  0xF8, 0x17, 0x05, 0xFF, 0x81, 0x60, 0x4F, 0xF8, 0x15, 0x03, 0xFF, 0x81, 0x50, 0x2F, 0xF8, 0x14,
  0x02, 0xFF, 0x81, 0x30, 0x1F, 0xF0, 0x32, 0xFF, 0x02, 0x2F, 0xF0, 0x12, 0xFF, 0x30, 0xEF, 0xE3,
  0x0D, 0xFE, 0x30, 0xDF, 0xD0, 0xE3, 0x0C, 0xFD, 0x0D, 0x30, 0xBF, 0xD0, 0xD3, 0x0B, 0xFD, 0x0C,
  0x30, 0xAF, 0xD0, 0xB3, 0x09, 0xFD, 0x0B, 0x30, 0x8F, 0xD0, 0xA3, 0x08, 0xFD, 0x09, 0x30, 0x7F,
  0xD0, 0x83, 0x06, 0xFD, 0x08, 0x30, 0x6F, 0xD0, 0x73, 0x05, 0xFD, 0x06, 0x30, 0x4F, 0xD0, 0x63,
  0x04, 0xFD, 0x05, 0x30, 0x3F, 0xD0, 0x43, 0x02, 0xFD, 0x04, 0x30, 0x2F, 0xD0, 0x33, 0x01, 0xFD,
  0x02, 0x4F, 0xD0, 0x24, 0xFD, 0x01, 0x40, 0xEF, 0xC5, 0x0E, 0xFC, 0x50, 0xDF, 0xB0, 0xE5, 0x0C,
  0xFB, 0x0E, 0x50, 0xCF, 0xB0, 0xD5, 0x0B, 0xFB, 0x0C, 0x50, 0xAF, 0xB0, 0xC8, 0x09, 0xD0, 0x08,
  0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x70, 0x7F, 0xA0, 0xE0, 0x44, 0x08, 0xFD, 0x04, 0x20, 0x3F, 0xE8,
  0x2E, 0x10, 0xAF, 0xF8, 0x17, 0x0E, 0xFF, 0x0C, 0x01, 0xFF, 0xA0, 0x2F, 0xFA, 0x02, 0xFF, 0xA0,
  0x1F, 0xFA, 0x10, 0xDF, 0xF8, 0x1B, 0x08, 0xFF, 0x81, 0x60, 0x1F, 0xE0, 0xD3, 0x05, 0xFD, 0x03,
  0x40, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x40,
  // """ (U+0022)
  0x04, 0xFD, 0x02, 0x40, 0x2F, 0xD0, 0x40, 0x2F, 0xD0, 0x14, 0x01, 0xFD, 0x02, 0x01, 0xFD, 0x6F,
  0xD0, 0x11, 0xFC, 0x0E, 0x60, 0xEF, 0xC2, 0xFC, 0x0D, 0x60, 0xDF, 0xB0, 0xE2, 0x0D, 0xFB, 0x0C,
  0x60, 0xCF, 0xB0, 0xD2, 0x0C, 0xFB, 0x0B, 0x60, 0xBF, 0xB0, 0xC2, 0x0B, 0xFB, 0x0A, 0x60, 0xAF,
  0xB0, 0xB2, 0x0A, 0xFB, 0x08, 0x60, 0x8F, 0xB0, 0xA2, 0x09, 0xFB, 0x07, 0x60, 0x7F, 0xB0, 0x92,
  0x08, 0xFB, 0x06, 0x60, 0x6F, 0xB0, 0x82, 0x06, 0xFB, 0x05, 0x60, 0x5F, 0xB0, 0x62, 0x05, 0xFB,
  0x04, 0x60, 0x4F, 0xB0, 0x52, 0x04, 0xFB, 0x03, 0x60, 0x3F, 0xB0, 0x42, 0x03, 0xFB, 0x01, 0x60,
  0x2F, 0xB0, 0x32, 0x02, 0xFB, 0x71, 0xFB, 0x02, 0x20, 0x1F, 0xB7, 0x1F, 0xB0, 0x13, 0xFA, 0x0E,
  0x71, 0x0E, 0xFA, 0x40, 0xEF, 0x90, 0xC7, 0x10, 0xCF, 0x90, 0xE4, 0x0D, 0xF9, 0x0B, 0x71, 0x0B,
  0xF9, 0x0D, 0x40, 0xCF, 0x90, 0xA7, 0x10, 0xAF, 0x90, 0xC4, 0x0A, 0xF9, 0x09, 0x71, 0x09, 0xF9,
  0x0A, 0x40, 0x9F, 0x90, 0x87, 0x10, 0x8F, 0x90, 0x92,
  // "#" (U+0023)
  0x77, 0x40, 0xCF, 0x90, 0x37, 0xFA, 0x77, 0x75, 0xFA, 0x01, 0x60, 0x2F, 0x90, 0xD7, 0x77, 0x40,
  0x2F, 0x90, 0xE7, 0x05, 0xF9, 0x0A, 0x77, 0x74, 0x05, 0xF9, 0x0B, 0x70, 0x7F, 0x90, 0x77, 0x77,
  0x40, 0x8F, 0x90, 0x87, 0x0A, 0xF9, 0x05, 0x77, 0x74, 0x0A, 0xF9, 0x05, 0x70, 0xDF, 0x90, 0x27,
  0x77, 0x40, 0xDF, 0x90, 0x37, 0xFA, 0x77, 0x75, 0xFA, 0x70, 0x2F, 0x90, 0xC7, 0x77, 0x40, 0x3F,
  0x90, 0xD7, 0x05, 0xF9, 0x0A, 0x77, 0x74, 0x06, 0xF9, 0x0A, 0x70, 0x8F, 0x90, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0x77, 0x0A, 0xF9, 0x04, 0x77, 0x74, 0x0B, 0xF9, 0x05, 0x70, 0xDF, 0x90, 0x27, 0x77,
  0x40, 0xEF, 0x90, 0x27, 0xF9, 0x0E, 0x77, 0x74, 0x01, 0xFA, 0x70, 0x3F, 0x90, 0xC7, 0x77, 0x40,
  0x4F, 0x90, 0xC7, 0x05, 0xF9, 0x09, 0x77, 0x74, 0x06, 0xF9, 0x09, 0x70, 0x8F, 0x90, 0x77, 0x77,
  0x40, 0x9F, 0x90, 0x77, 0x0B, 0xF9, 0x04, 0x76, 0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA3,
  0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA3,
  0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA3, 0x80, 0xD4, 0xF0, 0xA7, 0x60, 0x2F, 0x90, 0xE7,
  0x04, 0xF9, 0x0A, 0x77, 0x74, 0x04, 0xF9, 0x0C, 0x70, 0x7F, 0x90, 0x87, 0x77, 0x40, 0x7F, 0x90,
  0x97, 0x0A, 0xF9, 0x05, 0x77, 0x74, 0x09, 0xF9, 0x07, 0x70, 0xCF, 0x90, 0x37, 0x77, 0x40, 0xCF,
  0x90, 0x47, 0x0E, 0xF9, 0x77, 0x75, 0x0E, 0xF9, 0x02, 0x60, 0x2F, 0x90, 0xD7, 0x77, 0x40, 0x1F,
  0x90, 0xE7, 0x04, 0xF9, 0x0A, 0x77, 0x74, 0x04, 0xF9, 0x0C, 0x70, 0x7F, 0x90, 0x87, 0x77, 0x40,
  0x7F, 0x90, 0x97, 0x09, 0xF9, 0x05, 0x77, 0x74, 0x09, 0xF9, 0x07, 0x70, 0xCF, 0x90, 0x37, 0x77,
  0x40, 0xCF, 0x90, 0x47, 0x0E, 0xF9, 0x77, 0x0A, 0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF3, 0x0A,
  0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF3, 0x0A,
  0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF3, 0x0A, 0x80, 0xD4, 0xF7, 0x60, 0x5F, 0x90, 0x97, 0x0A,
  0xF9, 0x08, 0x77, 0x74, 0x08, 0xF9, 0x07, 0x70, 0xCF, 0x90, 0x57, 0x77, 0x40, 0xAF, 0x90, 0x47,
  0xFA, 0x03, 0x77, 0x74, 0x0D, 0xF9, 0x02, 0x60, 0x2F, 0xA7, 0x77, 0x5F, 0xA7, 0x04, 0xF9, 0x0D,
  0x77, 0x74, 0x02, 0xF9, 0x0D, 0x70, 0x7F, 0x90, 0xB7, 0x77, 0x40, 0x4F, 0x90, 0xA7, 0x09, 0xF9,
  0x08, 0x77, 0x74, 0x07, 0xF9, 0x08, 0x70, 0xCF, 0x90, 0x67, 0x77, 0x40, 0x9F, 0x90, 0x57, 0x0E,
  0xF9, 0x03, 0x77, 0x74, 0x0C, 0xF9, 0x03, 0x60, 0x2F, 0xA7, 0x77, 0x50, 0xEF, 0x90, 0x16, 0x04,
  0xF9, 0x0D, 0x77, 0x74, 0x01, 0xF9, 0x0E, 0x70, 0x7F, 0x90, 0xB7, 0x77, 0x40, 0x3F, 0x90, 0xB7,
  0x09, 0xF9, 0x08, 0x77, 0x74, 0x06, 0xF9, 0x09, 0x70, 0xCF, 0x90, 0x67, 0x77, 0x40, 0x8F, 0x90,
  0x77, 0x0E, 0xF9, 0x03, 0x77, 0x74, 0x0B, 0xF9, 0x04, 0x60, 0x1F, 0xA0, 0x17, 0x77, 0x40, 0xDF,
  0x90, 0x26, 0x04, 0xF9, 0x0E, 0x77, 0x75, 0xFA, 0x70, 0x7F, 0x90, 0xB7, 0x74,
  // "$" (U+0024)
  0x77, 0x30, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77,
  0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x18,
  0x32, 0x58, 0xAE, 0xD8, 0x5D, 0xCB, 0xA8, 0x63, 0x77, 0x68, 0x12, 0x8D, 0xFF, 0xC8, 0x1B, 0x61,
  0x77, 0x03, 0x0A, 0xFF, 0xFB, 0x0C, 0x06, 0x73, 0x01, 0x0A, 0xFF, 0xFF, 0x0E, 0x07, 0x70, 0x30,
  0xDF, 0xFF, 0xFB, 0x0D, 0x50, 0x5F, 0xFF, 0xFD, 0x09, 0x40, 0x5F, 0xFF, 0xFE, 0x04, 0x30, 0x20,
  0xEF, 0xFF, 0xFD, 0x0D, 0x40, 0xBF, 0xFF, 0xFE, 0x08, 0x30, 0x4F, 0xFF, 0xFF, 0x02, 0x30, 0xAF,
  0xE8, 0x1E, 0xBD, 0xD8, 0x29, 0xAC, 0xEF, 0xA0, 0xC4, 0xFD, 0x0D, 0x05, 0x20, 0xAD, 0x02, 0x38,
  0x22, 0x59, 0xDD, 0x07, 0x30, 0x4F, 0xC0, 0xD0, 0x13, 0x0A, 0xD0, 0x27, 0x81, 0x27, 0xDA, 0x01,
  0x30, 0x7F, 0xC0, 0x44, 0x0A, 0xD0, 0x27, 0x30, 0x40, 0x74, 0x09, 0xFB, 0x0D, 0x50, 0xAD, 0x02,
  0x77, 0x20, 0xAF, 0xB0, 0xA5, 0x0A, 0xD0, 0x27, 0x72, 0x0A, 0xFB, 0x0A, 0x50, 0xAD, 0x02, 0x77,
  0x20, 0x9F, 0xB0, 0xB5, 0x0A, 0xD0, 0x27, 0x72, 0x08, 0xFC, 0x02, 0x40, 0xAD, 0x02, 0x77, 0x20,
  0x6F, 0xC0, 0xB4, 0x0A, 0xD0, 0x27, 0x72, 0x02, 0xFD, 0x0C, 0x02, 0x20, 0xAD, 0x02, 0x77, 0x30,
  0xDF, 0xD8, 0x2E, 0x70, 0xAD, 0x02, 0x77, 0x30, 0x8F, 0xF0, 0xE0, 0xDD, 0x02, 0x77, 0x40, 0xEF,
  0xFE, 0x02, 0x77, 0x40, 0x6F, 0xFE, 0x03, 0x77, 0x50, 0x9F, 0xFE, 0x0A, 0x03, 0x77, 0x40, 0xBF,
  0xFF, 0x0C, 0x05, 0x77, 0x30, 0x9F, 0xFF, 0x90, 0xD0, 0x67, 0x72, 0x06, 0x0E, 0xFF, 0xF9, 0x0D,
  0x05, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xA0, 0xB0, 0x27, 0x71, 0x04, 0x0D, 0xFF, 0xF9, 0x0E, 0x05,
  0x77, 0x20, 0x60, 0xDF, 0xFF, 0x90, 0x67, 0x73, 0x05, 0x0C, 0xFF, 0xF0, 0x67, 0x74, 0x81, 0x39,
  0xEF, 0xFD, 0x03, 0x77, 0x50, 0xAF, 0xFD, 0x0D, 0x77, 0x50, 0xAF, 0xFE, 0x07, 0x77, 0x40, 0xAD,
  0x08, 0x0D, 0xFE, 0x0D, 0x77, 0x40, 0xAD, 0x81, 0x20, 0x7F, 0xE0, 0x37, 0x73, 0x0A, 0xD0, 0x22,
  0x03, 0x0E, 0xFC, 0x06, 0x77, 0x30, 0xAD, 0x02, 0x30, 0x3F, 0xC0, 0x97, 0x73, 0x0A, 0xD0, 0x24,
  0x0B, 0xFB, 0x0B, 0x77, 0x30, 0xAD, 0x02, 0x40, 0x8F, 0xB0, 0xB7, 0x73, 0x0A, 0xD0, 0x24, 0x07,
  0xFB, 0x0B, 0x77, 0x30, 0xAD, 0x02, 0x40, 0x8F, 0xB8, 0x1B, 0x85, 0x77, 0x10, 0xAD, 0x02, 0x40,
  0xBF, 0xB8, 0x39, 0xAF, 0xC5, 0x76, 0x0A, 0xD0, 0x23, 0x02, 0xFC, 0x07, 0x0A, 0xB8, 0x1E, 0x82,
  0x73, 0x0A, 0xD0, 0x22, 0x01, 0x0C, 0xFC, 0x03, 0x0A, 0xE8, 0x1C, 0x73, 0x70, 0xAD, 0x82, 0x20,
  0x3D, 0xFC, 0x81, 0xE0, 0xAF, 0xA8, 0x6E, 0xA7, 0x42, 0x10, 0xAD, 0x09, 0x0C, 0xFE, 0x81, 0x80,
  0xA8, 0x0C, 0x1F, 0x81, 0x20, 0xA8, 0x0C, 0x0F, 0x09, 0x20, 0xAF, 0xFF, 0xFF, 0x0D, 0x30, 0xAF,
  0xFF, 0xFF, 0x03, 0x30, 0xAF, 0xFF, 0xFE, 0x04, 0x40, 0xAF, 0xFF, 0xFC, 0x0E, 0x04, 0x50, 0x60,
  0xEF, 0xFF, 0xFA, 0x0B, 0x02, 0x71, 0x05, 0x0B, 0xFF, 0xFD, 0x0D, 0x05, 0x75, 0x82, 0x16, 0xAE,
  0xFF, 0xD8, 0x1E, 0xA4, 0x77, 0x48, 0x62, 0x47, 0x9B, 0xCD, 0xEF, 0x82, 0xDB, 0x84, 0x77, 0x77,
  0x20, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50,
  0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x77, 0x50, 0xAD,
  0x02, 0x77, 0x77, 0x50, 0xAD, 0x02, 0x77, 0x20,
  // "%" (U+0025)
  0x71, 0x82, 0x59, 0xCE, 0xA8, 0x2D, 0xB8, 0x48, 0x0C, 0x60, 0x06, 0x0E, 0xFB, 0x0D, 0x05, 0x77,
  0x30, 0x1F, 0xA0, 0x87, 0x30, 0x10, 0xCF, 0xF0, 0xA7, 0x72, 0x09, 0xF9, 0x0E, 0x01, 0x72, 0x01,
  0x0D, 0xFF, 0xA0, 0xB7, 0x70, 0x2F, 0xA0, 0x77, 0x30, 0xCF, 0xFC, 0x09, 0x76, 0x09, 0xF9, 0x0E,
  0x01, 0x72, 0x07, 0xFF, 0xE0, 0x47, 0x40, 0x2F, 0xA0, 0x77, 0x20, 0x1F, 0xFF, 0x0D, 0x74, 0x0A,
  0xF9, 0x0E, 0x73, 0x08, 0xFF, 0xF9, 0x04, 0x72, 0x02, 0xFA, 0x07, 0x73, 0x0E, 0xF9, 0x83, 0xD4,
  0x01, 0x6F, 0xA0, 0xA7, 0x20, 0xAF, 0x90, 0xE7, 0x30, 0x3F, 0x90, 0xE0, 0x14, 0x05, 0xFA, 0x71,
  0x03, 0xFA, 0x06, 0x73, 0x06, 0xF9, 0x07, 0x60, 0xDF, 0x90, 0x27, 0x0B, 0xF9, 0x0D, 0x74, 0x0A,
  0xF9, 0x03, 0x60, 0x8F, 0x90, 0x66, 0x03, 0xFA, 0x06, 0x74, 0x0C, 0xF9, 0x70, 0x4F, 0x90, 0x86,
  0x0B, 0xF9, 0x0D, 0x75, 0x0D, 0xF0, 0xE7, 0x02, 0xF9, 0x09, 0x50, 0x4F, 0xA0, 0x67, 0x50, 0xEF,
  0x0D, 0x70, 0x1F, 0x90, 0xA5, 0x0B, 0xF9, 0x0D, 0x76, 0xF9, 0x0C, 0x70, 0x1F, 0x90, 0xB4, 0x04,
  0xFA, 0x05, 0x76, 0x0E, 0xF0, 0xD7, 0x01, 0xF9, 0x0A, 0x40, 0xCF, 0x90, 0xD7, 0x70, 0xDF, 0x0D,
  0x70, 0x2F, 0x90, 0x93, 0x04, 0xFA, 0x05, 0x77, 0x0C, 0xF9, 0x70, 0x4F, 0x90, 0x83, 0x0C, 0xF9,
  0x0C, 0x77, 0x10, 0xBF, 0x90, 0x26, 0x07, 0xF9, 0x06, 0x20, 0x5F, 0xA0, 0x57, 0x71, 0x07, 0xF9,
  0x07, 0x60, 0xCF, 0x90, 0x32, 0x0D, 0xF9, 0x0C, 0x77, 0x20, 0x4F, 0x90, 0xD0, 0x14, 0x04, 0xFA,
  0x20, 0x5F, 0xA0, 0x47, 0x73, 0x0E, 0xF9, 0x84, 0xC4, 0x01, 0x6E, 0xF9, 0x0B, 0x20, 0xDF, 0x90,
  0xC7, 0x74, 0x09, 0xFF, 0xF9, 0x81, 0x50, 0x6F, 0xA0, 0x47, 0x74, 0x02, 0xFF, 0xF0, 0xE2, 0x0D,
  0xF9, 0x0B, 0x77, 0x60, 0x8F, 0xFE, 0x81, 0x50, 0x6F, 0xA0, 0x37, 0x77, 0x0C, 0xFF, 0xC0, 0xA2,
  0x0D, 0xF9, 0x0B, 0x77, 0x71, 0x01, 0x0D, 0xFF, 0xA0, 0xB2, 0x06, 0xFA, 0x03, 0x77, 0x72, 0x01,
  0x0C, 0xFF, 0x0A, 0x30, 0xEF, 0x90, 0xB7, 0x77, 0x50, 0x60, 0xEF, 0xB0, 0xD0, 0x43, 0x07, 0xFA,
  0x03, 0x77, 0x77, 0x89, 0x04, 0x9C, 0xDF, 0xED, 0xB8, 0x35, 0x0E, 0xF9, 0x0A, 0x80, 0xC7, 0x00,
  0x7F, 0xA0, 0x28, 0x0C, 0x60, 0x01, 0x0E, 0xF9, 0x0A, 0x80, 0xC7, 0x00, 0x8F, 0xA0, 0x28, 0x0C,
  0x60, 0x01, 0x0E, 0xF9, 0x09, 0x80, 0xC7, 0x00, 0x8F, 0xA0, 0x25, 0x82, 0x38, 0xBE, 0xA8, 0x2E,
  0xC9, 0x57, 0x77, 0x60, 0x10, 0xEF, 0x90, 0x94, 0x04, 0x0C, 0xFB, 0x0E, 0x07, 0x77, 0x74, 0x08,
  0xFA, 0x02, 0x30, 0x9F, 0xF0, 0xD0, 0x27, 0x77, 0x10, 0x1F, 0xA0, 0x93, 0x0B, 0xFF, 0xA0, 0xE0,
  0x27, 0x77, 0x09, 0xFA, 0x01, 0x20, 0x8F, 0xFC, 0x0D, 0x77, 0x60, 0x2F, 0xA0, 0x82, 0x03, 0xFF,
  0xE0, 0x87, 0x75, 0x09, 0xF9, 0x0E, 0x01, 0x20, 0xDF, 0xFF, 0x02, 0x77, 0x30, 0x2F, 0xA0, 0x82,
  0x04, 0xFF, 0xF9, 0x08, 0x77, 0x30, 0xAF, 0x90, 0xE0, 0x12, 0x0A, 0xF9, 0x84, 0xE6, 0x10, 0x4D,
  0xF9, 0x0E, 0x77, 0x20, 0x2F, 0xA0, 0x83, 0x0E, 0xF9, 0x04, 0x40, 0x20, 0xEF, 0x90, 0x37, 0x71,
  0x0A, 0xF9, 0x0E, 0x01, 0x20, 0x2F, 0x90, 0xC6, 0x09, 0xF9, 0x07, 0x77, 0x03, 0xFA, 0x07, 0x30,
  0x5F, 0x90, 0x76, 0x04, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x0E, 0x40, 0x8F, 0x90, 0x47, 0xF9, 0x0C,
  0x76, 0x03, 0xFA, 0x07, 0x40, 0x9F, 0x90, 0x27, 0x0E, 0xF0, 0xD7, 0x60, 0xBF, 0x90, 0xE5, 0x0A,
  0xF9, 0x01, 0x70, 0xDF, 0x0E, 0x75, 0x03, 0xFA, 0x07, 0x50, 0xBF, 0x90, 0x17, 0x0C, 0xF9, 0x75,
  0x0B, 0xF9, 0x0E, 0x60, 0xAF, 0x90, 0x17, 0x0D, 0xF0, 0xE7, 0x40, 0x4F, 0xA0, 0x66, 0x09, 0xF9,
  0x02, 0x70, 0xDF, 0x0D, 0x74, 0x0C, 0xF9, 0x0D, 0x70, 0x8F, 0x90, 0x47, 0xF9, 0x0C, 0x73, 0x04,
  0xFA, 0x06, 0x70, 0x6F, 0x90, 0x76, 0x03, 0xF9, 0x0B, 0x73, 0x0C, 0xF9, 0x0D, 0x71, 0x03, 0xF9,
  0x0B, 0x60, 0x8F, 0x90, 0x77, 0x20, 0x5F, 0xA0, 0x57, 0x2F, 0xA0, 0x34, 0x01, 0x0E, 0xF9, 0x04,
  0x72, 0x0C, 0xF9, 0x0D, 0x73, 0x0B, 0xF9, 0x84, 0xE6, 0x10, 0x4D, 0xF9, 0x0E, 0x72, 0x05, 0xFA,
  0x05, 0x73, 0x04, 0xFF, 0xF9, 0x09, 0x72, 0x0D, 0xF9, 0x0D, 0x75, 0x0D, 0xFF, 0xF0, 0x37, 0x10,
  0x5F, 0xA0, 0x57, 0x50, 0x4F, 0xFE, 0x09, 0x72, 0x0D, 0xF9, 0x0C, 0x77, 0x09, 0xFF, 0xC0, 0xD7,
  0x20, 0x6F, 0xA0, 0x47, 0x71, 0x0A, 0xFF, 0xA0, 0xE0, 0x27, 0x20, 0xDF, 0x90, 0xC7, 0x73, 0x09,
  0xFF, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x04, 0x77, 0x40, 0x40, 0xCF, 0xB0, 0xE0, 0x78, 0x0C, 0x60,
  0x89, 0x03, 0x8B, 0xDE, 0xED, 0xC9, 0x47, 0x10,
  // "&" (U+0026)
  0x77, 0x18, 0x92, 0x48, 0xBD, 0xEF, 0xED, 0xB8, 0x51, 0x80, 0xC0, 0x08, 0x11, 0x8E, 0xFD, 0x0A,
  0x03, 0x77, 0x77, 0x50, 0x50, 0xEF, 0xFA, 0x0A, 0x77, 0x77, 0x30, 0x8F, 0xFD, 0x0D, 0x02, 0x77,
  0x77, 0x08, 0xFF, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0x5F, 0xFF, 0xA0, 0xB7, 0x77, 0x40, 0x10, 0xEF,
  0xFF, 0xB0, 0x67, 0x77, 0x30, 0x8F, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0x10, 0xEF, 0xFF, 0xD0, 0x57,
  0x77, 0x10, 0x5F, 0xC0, 0xB0, 0x32, 0x05, 0x0D, 0xFB, 0x0A, 0x77, 0x71, 0x09, 0xFB, 0x0B, 0x50,
  0x20, 0xEF, 0xA0, 0xE7, 0x77, 0x10, 0xDF, 0xB0, 0x26, 0x08, 0xFB, 0x01, 0x77, 0x7F, 0xB0, 0xD7,
  0x04, 0xFB, 0x03, 0x77, 0x7F, 0xB0, 0xA7, 0x02, 0xFB, 0x04, 0x77, 0x60, 0x1F, 0xB0, 0x97, 0x01,
  0xFB, 0x05, 0x77, 0x60, 0x2F, 0xB0, 0xA7, 0x02, 0xFB, 0x03, 0x77, 0x60, 0x1F, 0xB0, 0xB7, 0x05,
  0xFB, 0x02, 0x77, 0x7F, 0xB0, 0xD7, 0x0A, 0xFA, 0x0E, 0x77, 0x71, 0x0E, 0xFB, 0x02, 0x50, 0x2F,
  0xB0, 0xB7, 0x77, 0x10, 0xBF, 0xB0, 0x65, 0x0B, 0xFB, 0x06, 0x77, 0x71, 0x08, 0xFB, 0x0C, 0x40,
  0x8F, 0xB0, 0xE7, 0x77, 0x20, 0x3F, 0xC0, 0x32, 0x06, 0xFC, 0x08, 0x77, 0x73, 0x0D, 0xFB, 0x81,
  0xB0, 0x6F, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x7F, 0xC0, 0x9F, 0xD0, 0x67, 0x77, 0x40, 0x10, 0xEF,
  0xFF, 0x90, 0xB7, 0x77, 0x60, 0x7F, 0xFF, 0x0E, 0x02, 0x77, 0x77, 0x0E, 0xFF, 0xE0, 0x47, 0x77,
  0x71, 0x06, 0xFF, 0xD0, 0x77, 0x77, 0x73, 0x0C, 0xFF, 0xB0, 0x97, 0x77, 0x74, 0x03, 0xFF, 0xA0,
  0xA7, 0x77, 0x75, 0x08, 0xFF, 0x90, 0xA7, 0x77, 0x75, 0x09, 0xFF, 0x90, 0xA7, 0x30, 0x7F, 0xC7,
  0x40, 0xAF, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x0D, 0x73, 0x0A, 0xFF, 0xC0, 0xA7, 0x20, 0xDF, 0xB0,
  0xB7, 0x20, 0x8F, 0xFE, 0x06, 0x70, 0x1F, 0xC0, 0x87, 0x10, 0x5F, 0xFF, 0x90, 0x36, 0x05, 0xFC,
  0x05, 0x70, 0x3F, 0xFF, 0xA0, 0xD0, 0x15, 0x09, 0xFC, 0x01, 0x70, 0xCF, 0xFF, 0xB0, 0xA5, 0x0D,
  0xFB, 0x0D, 0x70, 0x7F, 0xE0, 0xDF, 0xD0, 0x73, 0x03, 0xFC, 0x09, 0x60, 0x10, 0xEF, 0xD8, 0x17,
  0x1E, 0xFD, 0x03, 0x20, 0x7F, 0xC0, 0x56, 0x07, 0xFD, 0x08, 0x20, 0x5F, 0xD8, 0x2D, 0x10, 0xDF,
  0xC7, 0x0E, 0xFC, 0x0A, 0x40, 0x9F, 0xD0, 0xB0, 0x3F, 0xC0, 0xB6, 0x04, 0xFC, 0x0D, 0x01, 0x50,
  0xDF, 0xD0, 0xEF, 0xC0, 0x66, 0x09, 0xFC, 0x05, 0x60, 0x3F, 0xFF, 0xB0, 0x16, 0x0C, 0xFB, 0x0D,
  0x71, 0x06, 0xFF, 0xF9, 0x0A, 0x7F, 0xC0, 0x87, 0x20, 0xBF, 0xFF, 0x03, 0x60, 0x2F, 0xC0, 0x57,
  0x20, 0x10, 0xEF, 0xFD, 0x0C, 0x70, 0x3F, 0xC0, 0x37, 0x30, 0x4F, 0xFD, 0x05, 0x70, 0x4F, 0xC0,
  0x37, 0x40, 0x8F, 0xFB, 0x0D, 0x71, 0x04, 0xFC, 0x05, 0x75, 0x0C, 0xFF, 0xA0, 0x57, 0x10, 0x3F,
  0xC0, 0x87, 0x50, 0x20, 0xEF, 0xF0, 0xC7, 0x20, 0x2F, 0xC0, 0xE7, 0x60, 0x6F, 0xF0, 0x37, 0x3F,
  0xD0, 0x77, 0x50, 0x6F, 0xF0, 0x27, 0x30, 0xDF, 0xC0, 0xE0, 0x37, 0x20, 0x10, 0xAF, 0xF9, 0x0C,
  0x73, 0x09, 0xFD, 0x0E, 0x06, 0x68, 0x12, 0x8E, 0xFF, 0xB0, 0x97, 0x20, 0x5F, 0xF8, 0x4E, 0xA8,
  0x9A, 0xDF, 0xFF, 0x06, 0x72, 0x0E, 0x80, 0xC5, 0xF0, 0x37, 0x10, 0x88, 0x0C, 0x5F, 0x0D, 0x01,
  0x70, 0x10, 0xE8, 0x0C, 0x5F, 0x0A, 0x71, 0x06, 0x80, 0xC6, 0xF0, 0x77, 0x10, 0xAF, 0xFF, 0xE0,
  0x0E, 0xFE, 0x03, 0x71, 0x0B, 0xFF, 0xFC, 0x81, 0xB2, 0x3F, 0xE0, 0xD0, 0x17, 0x10, 0xAF, 0xFF,
  0x90, 0xE0, 0x63, 0x06, 0xFE, 0x0B, 0x72, 0x05, 0x0E, 0xFF, 0xC8, 0x1E, 0x71, 0x50, 0xAF, 0xE0,
  0x77, 0x30, 0x70, 0xDF, 0xF0, 0xB0, 0x67, 0x10, 0x10, 0xDF, 0xE0, 0x47, 0x48, 0x43, 0x7A, 0xCD,
  0xEA, 0x84, 0xEC, 0xA8, 0x51, 0x77, 0x75,
  // "'" (U+0027)
  0x04, 0xFD, 0x00, 0x2F, 0xD0, 0x01, 0xFD, 0x2F, 0xC0, 0xE2, 0xFC, 0x0D, 0x20, 0xDF, 0xB0, 0xC2,
  0x0C, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0xA2, 0x0A, 0xFB, 0x08, 0x20, 0x9F, 0xB0, 0x72, 0x08, 0xFB,
  0x06, 0x20, 0x6F, 0xB0, 0x52, 0x05, 0xFB, 0x04, 0x20, 0x4F, 0xB0, 0x32, 0x03, 0xFB, 0x01, 0x20,
  0x2F, 0xB3, 0x01, 0xFB, 0x4F, 0xA0, 0xE4, 0x0E, 0xF9, 0x0C, 0x40, 0xDF, 0x90, 0xB4, 0x0C, 0xF9,
  0x0A, 0x40, 0xAF, 0x90, 0x94, 0x09, 0xF9, 0x08, 0x20,
  // "(" (U+0028)
  0x75, 0x08, 0xFB, 0x03, 0x74, 0x04, 0xFB, 0x08, 0x74, 0x01, 0x0D, 0xFA, 0x0D, 0x75, 0x0A, 0xFB,
  0x03, 0x74, 0x05, 0xFB, 0x09, 0x75, 0x0D, 0xFA, 0x0E, 0x01, 0x74, 0x07, 0xFB, 0x08, 0x74, 0x01,
  0x0E, 0xFA, 0x0E, 0x75, 0x09, 0xFB, 0x07, 0x74, 0x01, 0xFB, 0x0E, 0x75, 0x08, 0xFB, 0x08, 0x74,
  0x01, 0x0E, 0xFB, 0x01, 0x74, 0x07, 0xFB, 0x0A, 0x75, 0x0E, 0xFB, 0x03, 0x74, 0x04, 0xFB, 0x0D,
  0x75, 0x0A, 0xFB, 0x08, 0x74, 0x01, 0xFC, 0x02, 0x74, 0x06, 0xFB, 0x0D, 0x75, 0x0B, 0xFB, 0x07,
  0x75, 0xFC, 0x03, 0x74, 0x04, 0xFB, 0x0E, 0x75, 0x09, 0xFB, 0x0B, 0x75, 0x0D, 0xFB, 0x07, 0x74,
  0x01, 0xFC, 0x03, 0x74, 0x04, 0xFC, 0x75, 0x07, 0xFB, 0x0C, 0x75, 0x0A, 0xFB, 0x09, 0x75, 0x0D,
  0xFB, 0x07, 0x74, 0x01, 0xFC, 0x04, 0x74, 0x03, 0xFC, 0x02, 0x74, 0x04, 0xFC, 0x75, 0x06, 0xFB,
  0x0E, 0x75, 0x08, 0xFB, 0x0C, 0x75, 0x09, 0xFB, 0x0B, 0x75, 0x0B, 0xFB, 0x09, 0x75, 0x0B, 0xFB,
  0x09, 0x75, 0x0C, 0xFB, 0x08, 0x75, 0x0C, 0xFB, 0x07, 0x75, 0x0D, 0xFB, 0x07, 0x75, 0x0D, 0xFB,
  0x06, 0x75, 0x0D, 0xFB, 0x07, 0x75, 0x0D, 0xFB, 0x07, 0x75, 0x0C, 0xFB, 0x08, 0x75, 0x0C, 0xFB,
  0x08, 0x75, 0x0B, 0xFB, 0x09, 0x75, 0x0A, 0xFB, 0x0A, 0x75, 0x09, 0xFB, 0x0C, 0x75, 0x07, 0xFB,
  0x0E, 0x75, 0x05, 0xFC, 0x75, 0x03, 0xFC, 0x02, 0x74, 0x02, 0xFC, 0x04, 0x75, 0x0E, 0xFB, 0x07,
  0x75, 0x0C, 0xFB, 0x09, 0x75, 0x09, 0xFB, 0x0C, 0x75, 0x06, 0xFC, 0x75, 0x03, 0xFC, 0x03, 0x75,
  0x0E, 0xFB, 0x07, 0x75, 0x0B, 0xFB, 0x0B, 0x75, 0x06, 0xFC, 0x75, 0x02, 0xFC, 0x04, 0x75, 0x0D,
  0xFB, 0x09, 0x75, 0x08, 0xFB, 0x0E, 0x75, 0x03, 0xFC, 0x04, 0x75, 0x0C, 0xFB, 0x09, 0x75, 0x07,
  0xFB, 0x0E, 0x75, 0x01, 0xFC, 0x05, 0x75, 0x0A, 0xFB, 0x0C, 0x75, 0x02, 0xFC, 0x03, 0x75, 0x0B,
  0xFB, 0x0A, 0x75, 0x03, 0xFC, 0x01, 0x75, 0x0B, 0xFB, 0x08, 0x75, 0x02, 0xFC, 0x01, 0x75, 0x09,
  0xFB, 0x09, 0x75, 0x01, 0x0E, 0xFB, 0x02, 0x75, 0x06, 0xFB, 0x0A, 0x76, 0x0B, 0xFB, 0x03, 0x75,
  0x01, 0x0E, 0xFA, 0x0D, 0x76, 0x04, 0xFB, 0x07, 0x76, 0x08, 0xFA, 0x0E, 0x02,
  // ")" (U+0029)
  0x02, 0x0E, 0xFA, 0x08, 0x76, 0x07, 0xFB, 0x04, 0x76, 0x0D, 0xFA, 0x0E, 0x01, 0x75, 0x03, 0xFB,
  0x0B, 0x76, 0x0A, 0xFB, 0x06, 0x75, 0x02, 0xFB, 0x0E, 0x01, 0x75, 0x09, 0xFB, 0x08, 0x75, 0x01,
  0xFC, 0x02, 0x75, 0x08, 0xFB, 0x0B, 0x75, 0x01, 0xFC, 0x03, 0x75, 0x0A, 0xFB, 0x0A, 0x75, 0x03,
  0xFC, 0x02, 0x75, 0x0C, 0xFB, 0x09, 0x75, 0x05, 0xFC, 0x01, 0x75, 0x0E, 0xFB, 0x06, 0x75, 0x09,
  0xFB, 0x0C, 0x75, 0x04, 0xFC, 0x02, 0x75, 0x0E, 0xFB, 0x08, 0x75, 0x09, 0xFB, 0x0D, 0x75, 0x04,
  0xFC, 0x02, 0x75, 0xFC, 0x06, 0x75, 0x0B, 0xFB, 0x0A, 0x75, 0x07, 0xFB, 0x0E, 0x75, 0x03, 0xFC,
  0x03, 0x75, 0xFC, 0x06, 0x75, 0x0D, 0xFB, 0x09, 0x75, 0x0A, 0xFB, 0x0C, 0x75, 0x07, 0xFB, 0x0E,
  0x75, 0x04, 0xFC, 0x02, 0x74, 0x02, 0xFC, 0x03, 0x75, 0xFC, 0x05, 0x75, 0x0E, 0xFB, 0x07, 0x75,
  0x0C, 0xFB, 0x09, 0x75, 0x0A, 0xFB, 0x0A, 0x75, 0x09, 0xFB, 0x0B, 0x75, 0x09, 0xFB, 0x0B, 0x75,
  0x08, 0xFB, 0x0C, 0x75, 0x07, 0xFB, 0x0D, 0x75, 0x07, 0xFB, 0x0D, 0x75, 0x06, 0xFB, 0x0D, 0x75,
  0x07, 0xFB, 0x0D, 0x75, 0x08, 0xFB, 0x0C, 0x75, 0x08, 0xFB, 0x0C, 0x75, 0x09, 0xFB, 0x0B, 0x75,
  0x09, 0xFB, 0x0B, 0x75, 0x0B, 0xFB, 0x09, 0x75, 0x0C, 0xFB, 0x08, 0x75, 0x0E, 0xFB, 0x06, 0x75,
  0xFC, 0x04, 0x74, 0x02, 0xFC, 0x02, 0x74, 0x04, 0xFC, 0x75, 0x07, 0xFB, 0x0D, 0x75, 0x09, 0xFB,
  0x0A, 0x75, 0x0C, 0xFB, 0x07, 0x75, 0xFC, 0x04, 0x74, 0x03, 0xFC, 0x01, 0x74, 0x07, 0xFB, 0x0D,
  0x75, 0x0B, 0xFB, 0x08, 0x75, 0x0E, 0xFB, 0x04, 0x74, 0x03, 0xFC, 0x75, 0x07, 0xFB, 0x0B, 0x75,
  0x0D, 0xFB, 0x06, 0x74, 0x02, 0xFC, 0x01, 0x74, 0x08, 0xFB, 0x0A, 0x75, 0x0D, 0xFB, 0x04, 0x74,
  0x03, 0xFB, 0x0E, 0x75, 0x0A, 0xFB, 0x07, 0x74, 0x01, 0xFB, 0x0E, 0x01, 0x74, 0x08, 0xFB, 0x08,
  0x75, 0x0E, 0xFB, 0x01, 0x74, 0x07, 0xFB, 0x09, 0x75, 0x0E, 0xFA, 0x0E, 0x01, 0x74, 0x08, 0xFB,
  0x07, 0x74, 0x01, 0x0E, 0xFA, 0x0D, 0x75, 0x09, 0xFB, 0x04, 0x74, 0x03, 0xFB, 0x0A, 0x75, 0x0D,
  0xFA, 0x0D, 0x01, 0x74, 0x08, 0xFB, 0x04, 0x74, 0x03, 0xFB, 0x08, 0x75,
  // "*" (U+002A)
  0x77, 0x10, 0x2F, 0xB0, 0x47, 0x77, 0x72, 0x01, 0xFB, 0x02, 0x77, 0x77, 0x3F, 0xB0, 0x17, 0x77,
  0x73, 0x0E, 0xFA, 0x77, 0x77, 0x40, 0xDF, 0x90, 0xE7, 0x77, 0x74, 0x0C, 0xF9, 0x0D, 0x77, 0x77,
  0x40, 0xAF, 0x90, 0xB7, 0x77, 0x74, 0x09, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x97, 0x77,
  0x74, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x6F, 0x90, 0x67, 0x74, 0x82, 0x2B, 0x73, 0x73, 0x04,
  0xF9, 0x05, 0x72, 0x83, 0x15, 0x9D, 0x64, 0x06, 0xB8, 0x2E, 0xB7, 0x26, 0x03, 0xF9, 0x03, 0x68,
  0x13, 0x7C, 0xC0, 0x94, 0x0A, 0xF8, 0x2E, 0xA6, 0x22, 0x02, 0xF9, 0x02, 0x28, 0x21, 0x5A, 0xEF,
  0x0C, 0x40, 0xDF, 0xC8, 0x1D, 0x96, 0xF9, 0x81, 0x58, 0xCF, 0xD3, 0x01, 0x80, 0xC2, 0xF0, 0x32,
  0x05, 0x80, 0xC2, 0xF0, 0x62, 0x08, 0x80, 0xC2, 0xF0, 0x92, 0x0C, 0x80, 0xC2, 0xF0, 0xC2, 0x80,
  0xC4, 0xF1, 0x82, 0x19, 0xBD, 0xFF, 0xFF, 0xF8, 0x1D, 0xC1, 0x58, 0x52, 0x46, 0x8A, 0xCE, 0xFF,
  0xD8, 0x5D, 0xB9, 0x75, 0x42, 0x77, 0x28, 0x11, 0x3E, 0xFD, 0x81, 0xE3, 0x17, 0x77, 0x40, 0x8F,
  0xF0, 0x97, 0x77, 0x40, 0x5F, 0xFA, 0x05, 0x77, 0x72, 0x02, 0x0E, 0xFF, 0xA0, 0xE0, 0x27, 0x77,
  0x10, 0xCF, 0x90, 0xB0, 0xDF, 0x90, 0xD7, 0x77, 0x09, 0xFA, 0x02, 0x05, 0xFA, 0x0A, 0x77, 0x50,
  0x6F, 0xA0, 0x92, 0x0C, 0xFA, 0x07, 0x77, 0x30, 0x3F, 0xB0, 0x22, 0x04, 0xFB, 0x04, 0x77, 0x10,
  0x10, 0xDF, 0xA0, 0x94, 0x0B, 0xFA, 0x0E, 0x01, 0x77, 0x0A, 0xFA, 0x0E, 0x01, 0x40, 0x3F, 0xB0,
  0xC7, 0x60, 0x7F, 0xB0, 0x86, 0x0A, 0xFB, 0x09, 0x74, 0x03, 0xFB, 0x0E, 0x01, 0x60, 0x2F, 0xC0,
  0x47, 0x40, 0x60, 0xEF, 0x90, 0x77, 0x10, 0x9F, 0x90, 0xE0, 0x57, 0x60, 0x10, 0x9E, 0x0E, 0x72,
  0x01, 0x0E, 0xE0, 0x90, 0x17, 0x72, 0x03, 0x0C, 0xC0, 0x67, 0x30, 0x8C, 0x0C, 0x03, 0x77, 0x68,
  0x25, 0xEF, 0xD7, 0x58, 0x2E, 0xFE, 0x67, 0x77, 0x30, 0x80, 0x57, 0x58, 0x17, 0xA1, 0x75,
  // "+" (U+002B)
  0x77, 0x20, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7,
  0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E,
  0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90,
  0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9,
  0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF,
  0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x72, 0x0A, 0x80,
  0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80,
  0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80,
  0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x72, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90,
  0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9,
  0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF,
  0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A,
  0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40,
  0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x72,
  // "," (U+002C)
  0x50, 0xBF, 0xC0, 0xE0, 0x15, 0x0E, 0xFD, 0x02, 0x40, 0x1F, 0xD0, 0xD5, 0x03, 0xFD, 0x09, 0x50,
  0x6F, 0xD0, 0x55, 0x08, 0xFD, 0x01, 0x50, 0xBF, 0xC0, 0xC6, 0x0E, 0xFC, 0x08, 0x50, 0x1F, 0xD0,
  0x45, 0x04, 0xFC, 0x0E, 0x60, 0x6F, 0xC0, 0xA6, 0x09, 0xFC, 0x05, 0x60, 0xCF, 0xC0, 0x16, 0x0E,
  0xFB, 0x0B, 0x60, 0x2F, 0xC0, 0x66, 0x05, 0xFC, 0x01, 0x60, 0x7F, 0xB0, 0xC7, 0x0A, 0xFB, 0x07,
  0x70, 0xDF, 0xB0, 0x16, 0x01, 0xFB, 0x0B, 0x70, 0x4F, 0xB0, 0x57, 0x07, 0xFA, 0x0E, 0x71, 0x0B,
  0xFA, 0x09, 0x71, 0x0E, 0xFA, 0x02, 0x70, 0x3F, 0xA0, 0xB7, 0x10, 0x6F, 0xA0, 0x47, 0x10,
  // "-" (U+002D)
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07,
  // "." (U+002E)
  0x48, 0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x70, 0x7F, 0xA0, 0xE0, 0x44, 0x08, 0xFD, 0x04, 0x20, 0x3F,
  0xE8, 0x2E, 0x10, 0xAF, 0xF8, 0x17, 0x0E, 0xFF, 0x0C, 0x01, 0xFF, 0xA0, 0x2F, 0xFA, 0x02, 0xFF,
  0xA0, 0x1F, 0xFA, 0x10, 0xDF, 0xF8, 0x1B, 0x08, 0xFF, 0x81, 0x60, 0x1F, 0xE0, 0xD3, 0x05, 0xFD,
  0x03, 0x40, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x40,
  // "/" (U+002F)
  0x77, 0x73, 0x06, 0xFB, 0x0C, 0x77, 0x73, 0x0C, 0xFB, 0x06, 0x77, 0x72, 0x03, 0xFC, 0x01, 0x77,
  0x72, 0x09, 0xFB, 0x0A, 0x77, 0x73, 0x0E, 0xFB, 0x04, 0x77, 0x72, 0x05, 0xFB, 0x0D, 0x77, 0x73,
  0x0B, 0xFB, 0x07, 0x77, 0x72, 0x02, 0xFC, 0x01, 0x77, 0x72, 0x08, 0xFB, 0x0B, 0x77, 0x73, 0x0E,
  0xFB, 0x05, 0x77, 0x72, 0x04, 0xFB, 0x0E, 0x77, 0x73, 0x0A, 0xFB, 0x08, 0x77, 0x72, 0x01, 0xFC,
  0x02, 0x77, 0x72, 0x07, 0xFB, 0x0C, 0x77, 0x73, 0x0D, 0xFB, 0x06, 0x77, 0x72, 0x03, 0xFB, 0x0E,
  0x01, 0x77, 0x72, 0x09, 0xFB, 0x09, 0x77, 0x73, 0x0E, 0xFB, 0x03, 0x77, 0x72, 0x06, 0xFB, 0x0D,
  0x77, 0x73, 0x0C, 0xFB, 0x07, 0x77, 0x72, 0x02, 0xFC, 0x01, 0x77, 0x72, 0x08, 0xFB, 0x0B, 0x77,
  0x73, 0x0E, 0xFB, 0x05, 0x77, 0x72, 0x05, 0xFB, 0x0E, 0x77, 0x73, 0x0B, 0xFB, 0x08, 0x77, 0x72,
  0x01, 0xFC, 0x02, 0x77, 0x72, 0x07, 0xFB, 0x0C, 0x77, 0x73, 0x0D, 0xFB, 0x06, 0x77, 0x72, 0x04,
  0xFB, 0x0E, 0x77, 0x73, 0x0A, 0xFB, 0x09, 0x77, 0x72, 0x01, 0xFC, 0x03, 0x77, 0x72, 0x06, 0xFB,
  0x0D, 0x77, 0x73, 0x0C, 0xFB, 0x07, 0x77, 0x72, 0x03, 0xFC, 0x01, 0x77, 0x72, 0x09, 0xFB, 0x0B,
  0x77, 0x73, 0x0E, 0xFB, 0x05, 0x77, 0x72, 0x05, 0xFB, 0x0E, 0x77, 0x73, 0x0B, 0xFB, 0x08, 0x77,
  0x72, 0x02, 0xFC, 0x02, 0x77, 0x72, 0x08, 0xFB, 0x0C, 0x77, 0x73, 0x0D, 0xFB, 0x06, 0x77, 0x72,
  0x04, 0xFB, 0x0E, 0x77, 0x73, 0x0A, 0xFB, 0x09, 0x77, 0x72, 0x01, 0xFC, 0x03, 0x77, 0x72, 0x07,
  0xFB, 0x0D, 0x77, 0x73, 0x0D, 0xFB, 0x07, 0x77, 0x72, 0x03, 0xFC, 0x01, 0x77, 0x72, 0x09, 0xFB,
  0x0A, 0x77, 0x73, 0x0E, 0xFB, 0x04, 0x77, 0x72, 0x06, 0xFB, 0x0E, 0x77, 0x73, 0x0C, 0xFB, 0x08,
  0x77, 0x72, 0x02, 0xFC, 0x02, 0x77, 0x72, 0x08, 0xFB, 0x0B, 0x77, 0x73, 0x0E, 0xFB, 0x06, 0x77,
  0x72, 0x05, 0xFB, 0x0E, 0x77, 0x73, 0x0B, 0xFB, 0x09, 0x77, 0x72, 0x01, 0xFC, 0x03, 0x77, 0x72,
  0x07, 0xFB, 0x0D, 0x77, 0x73, 0x0D, 0xFB, 0x07, 0x77, 0x72, 0x04, 0xFC, 0x01, 0x77, 0x72, 0x0A,
  0xFB, 0x0A, 0x77, 0x72, 0x01, 0xFC, 0x04, 0x77, 0x72, 0x06, 0xFB, 0x0E, 0x77, 0x73, 0x0C, 0xFB,
  0x08, 0x77, 0x73,
  // "0" (U+0030)
  0x77, 0x28, 0x94, 0x37, 0xAC, 0xDE, 0xFE, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x18, 0x13, 0x9E, 0xFF,
  0x0C, 0x06, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xD0, 0xE0, 0x77, 0x77, 0x10, 0x8F, 0xFF, 0xA0, 0xD0,
  0x37, 0x74, 0x01, 0x0B, 0xFF, 0xFD, 0x06, 0x77, 0x30, 0xCF, 0xFF, 0xF0, 0x77, 0x71, 0x0B, 0xFF,
  0xFF, 0xA0, 0x67, 0x60, 0x8F, 0xFF, 0xFC, 0x02, 0x74, 0x03, 0xFF, 0xFF, 0xD0, 0xD7, 0x40, 0xCF,
  0xFF, 0xFE, 0x07, 0x72, 0x05, 0xFF, 0x98, 0x3D, 0xA8, 0x9B, 0xFF, 0x90, 0xE0, 0x17, 0x10, 0xCF,
  0xE0, 0xC0, 0x46, 0x07, 0xFF, 0x08, 0x70, 0x4F, 0xE0, 0xA7, 0x20, 0x30, 0xEF, 0xD0, 0xE7, 0x0A,
  0xFD, 0x0C, 0x74, 0x04, 0xFE, 0x06, 0x6F, 0xE0, 0x27, 0x40, 0x8F, 0xE0, 0xC5, 0x05, 0xFD, 0x09,
  0x74, 0x02, 0xFF, 0x90, 0x14, 0x09, 0xFD, 0x03, 0x74, 0x0B, 0xFF, 0x90, 0x64, 0x0D, 0xFC, 0x0D,
  0x74, 0x05, 0xFF, 0xA0, 0xA3, 0x02, 0xFD, 0x09, 0x74, 0x0D, 0xFF, 0xA0, 0xE3, 0x05, 0xFD, 0x05,
  0x73, 0x08, 0xFF, 0xC0, 0x32, 0x08, 0xFD, 0x02, 0x72, 0x02, 0xFF, 0xD0, 0x52, 0x0B, 0xFC, 0x0E,
  0x73, 0x0B, 0xFF, 0xD0, 0x82, 0x0D, 0xFC, 0x0C, 0x72, 0x05, 0xFF, 0xE0, 0xB2, 0xFD, 0x0A, 0x71,
  0x01, 0x0E, 0xFF, 0xE8, 0x1D, 0x01, 0xFD, 0x08, 0x71, 0x09, 0xFF, 0xF9, 0x10, 0x3F, 0xD0, 0x67,
  0x03, 0xFF, 0xFA, 0x01, 0x04, 0xFD, 0x05, 0x70, 0xCF, 0xA0, 0xD0, 0xAF, 0xD0, 0x30, 0x5F, 0xD0,
  0x46, 0x06, 0xFB, 0x04, 0x08, 0xFD, 0x04, 0x06, 0xFD, 0x03, 0x50, 0x10, 0xEF, 0xA8, 0x1A, 0x08,
  0xFD, 0x05, 0x06, 0xFD, 0x02, 0x50, 0x9F, 0xA8, 0x2E, 0x10, 0x7F, 0xD0, 0x60, 0x7F, 0xD0, 0x24,
  0x03, 0xFB, 0x07, 0x20, 0x7F, 0xD0, 0x60, 0x7F, 0xD0, 0x14, 0x0C, 0xFA, 0x0C, 0x30, 0x6F, 0xD0,
  0x07, 0xFD, 0x01, 0x30, 0x6F, 0xB0, 0x33, 0x06, 0xFD, 0x00, 0x7F, 0xD0, 0x12, 0x01, 0x0E, 0xFA,
  0x09, 0x40, 0x5F, 0xD0, 0x07, 0xFD, 0x01, 0x20, 0x9F, 0xA0, 0xE0, 0x14, 0x06, 0xFD, 0x07, 0x06,
  0xFD, 0x81, 0x10, 0x3F, 0xB0, 0x55, 0x06, 0xFD, 0x00, 0x6F, 0xD8, 0x12, 0x0C, 0xFA, 0x0B, 0x60,
  0x6F, 0xD0, 0x60, 0x5F, 0xD0, 0x20, 0x6F, 0xB0, 0x26, 0x07, 0xFD, 0x05, 0x04, 0xFD, 0x05, 0x0E,
  0xFA, 0x08, 0x70, 0x7F, 0xD0, 0x50, 0x3F, 0xD0, 0xDF, 0xA0, 0xD7, 0x10, 0x8F, 0xD0, 0x30, 0x2F,
  0xFF, 0x90, 0x47, 0x10, 0x9F, 0xD0, 0x21, 0xFF, 0xF0, 0xA7, 0x20, 0xBF, 0xD2, 0x0D, 0xFF, 0xD0,
  0xE0, 0x17, 0x20, 0xCF, 0xC0, 0xE2, 0x0B, 0xFF, 0xD0, 0x77, 0x30, 0xEF, 0xC0, 0xC2, 0x09, 0xFF,
  0xC0, 0xC7, 0x30, 0x1F, 0xD0, 0x92, 0x06, 0xFF, 0xC0, 0x37, 0x30, 0x4F, 0xD0, 0x72, 0x03, 0xFF,
  0xB0, 0x97, 0x40, 0x7F, 0xD0, 0x43, 0x0E, 0xFF, 0x90, 0xE0, 0x17, 0x40, 0xAF, 0xD0, 0x13, 0x0B,
  0xFF, 0x90, 0x57, 0x50, 0xEF, 0xC0, 0xC4, 0x07, 0xFF, 0x0B, 0x75, 0x04, 0xFD, 0x09, 0x40, 0x2F,
  0xF0, 0x27, 0x50, 0xAF, 0xD0, 0x45, 0x0C, 0xFD, 0x08, 0x75, 0x02, 0xFD, 0x0E, 0x60, 0x7F, 0xD0,
  0xA7, 0x50, 0xCF, 0xD0, 0x96, 0x01, 0x0E, 0xFD, 0x09, 0x73, 0x0A, 0xFE, 0x04, 0x70, 0x9F, 0xE0,
  0xC0, 0x36, 0x04, 0x0C, 0xFE, 0x0C, 0x71, 0x02, 0xFF, 0x98, 0x4D, 0xA8, 0x8A, 0xDF, 0xF9, 0x04,
  0x72, 0x08, 0xFF, 0xFF, 0xE0, 0xC7, 0x40, 0xDF, 0xFF, 0xFD, 0x03, 0x74, 0x03, 0xFF, 0xFF, 0xC0,
  0x77, 0x60, 0x7F, 0xFF, 0xFA, 0x0B, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0xB7, 0x73, 0x07, 0xFF, 0xFD,
  0x0B, 0x77, 0x50, 0x40, 0xEF, 0xFF, 0xA0, 0x87, 0x77, 0x10, 0x8F, 0xFE, 0x0C, 0x03, 0x77, 0x73,
  0x81, 0x17, 0xDF, 0xF9, 0x0A, 0x04, 0x77, 0x77, 0x18, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xEE, 0xCA,
  0x74, 0x77, 0x20,
  // "1" (U+0031)
  0x77, 0x30, 0x20, 0xAF, 0xB0, 0x97, 0x77, 0x60, 0x10, 0x8F, 0xD0, 0x97, 0x77, 0x50, 0x60, 0xEF,
  0xE0, 0x97, 0x77, 0x30, 0x40, 0xDF, 0xF9, 0x09, 0x77, 0x71, 0x03, 0x0B, 0xFF, 0xB0, 0x97, 0x76,
  0x01, 0x09, 0xFF, 0xD0, 0x97, 0x75, 0x07, 0x0E, 0xFF, 0xE0, 0x97, 0x73, 0x05, 0x0D, 0xFF, 0xF9,
  0x09, 0x77, 0x10, 0x30, 0xCF, 0xFF, 0xB0, 0x97, 0x60, 0x10, 0xAF, 0xFF, 0xD0, 0x97, 0x50, 0x7F,
  0xFF, 0xF0, 0x97, 0x50, 0x6F, 0xFF, 0xF0, 0x97, 0x60, 0xDF, 0xFF, 0xE0, 0x97, 0x60, 0x4F, 0xFF,
  0xE0, 0x97, 0x70, 0xBF, 0xFF, 0xD0, 0x97, 0x70, 0x2F, 0xD0, 0xB0, 0x3F, 0xD0, 0x97, 0x71, 0x09,
  0xFA, 0x82, 0xE5, 0x01, 0xFD, 0x09, 0x77, 0x10, 0x10, 0xEF, 0x08, 0x30, 0x2F, 0xD0, 0x97, 0x72,
  0x07, 0xD0, 0x90, 0x14, 0x03, 0xFD, 0x09, 0x77, 0x30, 0xDA, 0x0A, 0x02, 0x60, 0x4F, 0xD0, 0x97,
  0x73, 0x81, 0x5B, 0x37, 0x10, 0x4F, 0xD0, 0x97, 0x77, 0x70, 0x5F, 0xD0, 0x97, 0x77, 0x70, 0x5F,
  0xD0, 0x97, 0x77, 0x70, 0x5F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0,
  0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97,
  0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77,
  0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70,
  0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F,
  0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0,
  0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97,
  0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77,
  0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x70,
  0x6F, 0xD0, 0x97, 0x77, 0x70, 0x6F, 0xD0, 0x97, 0x77, 0x60, 0x20, 0x8F, 0xD8, 0x1B, 0x21, 0x77,
  0x18, 0x71, 0x34, 0x68, 0x9B, 0xDE, 0xFF, 0xC8, 0x7E, 0xDB, 0x98, 0x64, 0x31, 0x50, 0xC8, 0x0C,
  0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F,
  0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A,
  0x40, 0xC8, 0x0C, 0x0F, 0x0A, 0x40, 0xC8, 0x0C, 0x0F, 0x0A,
  // "2" (U+0032)
  0x77, 0x85, 0x36, 0x9B, 0xCD, 0xEA, 0x85, 0xEE, 0xDB, 0x86, 0x27, 0x77, 0x58, 0x14, 0x9E, 0xFF,
  0xA8, 0x1D, 0x82, 0x77, 0x70, 0x70, 0xEF, 0xFF, 0x90, 0xB0, 0x27, 0x73, 0x07, 0x0E, 0xFF, 0xFD,
  0x09, 0x77, 0x04, 0x0D, 0xFF, 0xFF, 0x90, 0xC0, 0x27, 0x40, 0x9F, 0xFF, 0xFC, 0x0E, 0x03, 0x71,
  0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0xE0, 0x26, 0x05, 0x80, 0xC1, 0xF0, 0xD5, 0x08, 0x80, 0xC3, 0xF0,
  0x94, 0x08, 0x80, 0xC4, 0xF0, 0x24, 0x0B, 0x80, 0xC3, 0xF0, 0xA4, 0x01, 0x0D, 0xFE, 0x82, 0xD8,
  0x52, 0x28, 0x21, 0x37, 0xDF, 0xFA, 0x01, 0x40, 0x20, 0xEF, 0xB0, 0xB0, 0x47, 0x30, 0x7F, 0xF9,
  0x07, 0x50, 0x4F, 0x90, 0xD0, 0x47, 0x60, 0x4F, 0xF0, 0xB6, 0x07, 0xE0, 0x87, 0x72, 0x08, 0xFE,
  0x0E, 0x70, 0xAB, 0x0E, 0x04, 0x77, 0x30, 0x10, 0xEF, 0xE0, 0x17, 0x82, 0xCF, 0xD2, 0x77, 0x50,
  0xAF, 0xE0, 0x27, 0x81, 0x1A, 0x17, 0x76, 0x07, 0xFE, 0x03, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x37,
  0x77, 0x72, 0x05, 0xFE, 0x02, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x17, 0x77, 0x72, 0x08, 0xFD, 0x0E,
  0x77, 0x77, 0x30, 0xCF, 0xD0, 0xB7, 0x77, 0x72, 0x01, 0xFE, 0x08, 0x77, 0x77, 0x20, 0x7F, 0xE0,
  0x37, 0x77, 0x72, 0x0E, 0xFD, 0x0E, 0x77, 0x77, 0x20, 0x7F, 0xE0, 0x87, 0x77, 0x71, 0x02, 0xFF,
  0x01, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x97, 0x77, 0x71, 0x08, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x04,
  0xFF, 0x06, 0x77, 0x77, 0x03, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0E, 0x02, 0x77,
  0x76, 0x01, 0x0D, 0xFF, 0x05, 0x77, 0x76, 0x01, 0x0D, 0xFF, 0x08, 0x77, 0x76, 0x01, 0x0C, 0xFF,
  0x0A, 0x77, 0x77, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x0C, 0xFF, 0x0C, 0x01, 0x77, 0x76, 0x0B, 0xFF,
  0x0C, 0x01, 0x77, 0x76, 0x0B, 0xFF, 0x0C, 0x01, 0x77, 0x76, 0x0B, 0xFF, 0x0C, 0x77, 0x77, 0x0B,
  0xFF, 0x0B, 0x77, 0x77, 0x0B, 0xFF, 0x0A, 0x77, 0x77, 0x0B, 0xFF, 0x09, 0x77, 0x77, 0x0B, 0xFF,
  0x08, 0x77, 0x77, 0x0B, 0xFF, 0x07, 0x77, 0x77, 0x0B, 0xFF, 0x05, 0x77, 0x77, 0x0B, 0xFE, 0x0E,
  0x04, 0x77, 0x77, 0x0A, 0xFE, 0x0D, 0x02, 0x77, 0x77, 0x0A, 0xFE, 0x0C, 0x01, 0x77, 0x77, 0x0A,
  0xFE, 0x0B, 0x01, 0x77, 0x77, 0x0A, 0xFE, 0x0A, 0x77, 0x77, 0x10, 0xAF, 0xE0, 0x87, 0x77, 0x71,
  0x0A, 0xFE, 0x0D, 0x77, 0x77, 0x10, 0xA8, 0x0C, 0x6F, 0x0E, 0x09, 0x80, 0xC7, 0xF0, 0xE0, 0xD8,
  0x0C, 0x7F, 0x0E, 0x0D, 0x80, 0xC7, 0xF0, 0xE0, 0xD8, 0x0C, 0x7F, 0x0E, 0x0D, 0x80, 0xC7, 0xF0,
  0xE0, 0xD8, 0x0C, 0x7F, 0x0E, 0x0D, 0x80, 0xC7, 0xF0, 0xE0, 0xD8, 0x0C, 0x7F, 0x0E, 0x0D, 0x80,
  0xC7, 0xF0, 0xE0, 0xD8, 0x0C, 0x7F, 0x0E,
  // "3" (U+0033)
  0x75, 0x86, 0x14, 0x79, 0xBD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x38, 0x14, 0x8C, 0xFF,
  0xA8, 0x1E, 0xA4, 0x77, 0x48, 0x12, 0x8E, 0xFF, 0xF9, 0x0D, 0x06, 0x77, 0x03, 0x0B, 0xFF, 0xFE,
  0x0D, 0x03, 0x73, 0x03, 0x0B, 0xFF, 0xFF, 0xB0, 0x67, 0x10, 0x9F, 0xFF, 0xFE, 0x08, 0x60, 0x88,
  0x0C, 0x0F, 0x06, 0x50, 0x10, 0xE8, 0x0C, 0x0F, 0x02, 0x50, 0x58, 0x0C, 0x0F, 0x0B, 0x60, 0xB8,
  0x0C, 0x0F, 0x02, 0x50, 0x28, 0x0C, 0x0F, 0x08, 0x60, 0x7F, 0xB8, 0x3D, 0x96, 0x31, 0x28, 0x21,
  0x37, 0xDF, 0xF0, 0xC7, 0x0D, 0xE8, 0x1E, 0x83, 0x74, 0x08, 0xFF, 0x70, 0x3C, 0x0C, 0x05, 0x77,
  0x10, 0x9F, 0xE0, 0x27, 0x82, 0x9F, 0xC4, 0x77, 0x40, 0xEF, 0xD0, 0x37, 0x01, 0x05, 0x77, 0x60,
  0x9F, 0xD0, 0x37, 0x77, 0x71, 0x05, 0xFD, 0x02, 0x77, 0x77, 0x10, 0x3F, 0xD0, 0x17, 0x77, 0x71,
  0x02, 0xFD, 0x77, 0x77, 0x20, 0x4F, 0xC0, 0xB7, 0x77, 0x72, 0x07, 0xFC, 0x08, 0x77, 0x77, 0x20,
  0xCF, 0xC0, 0x27, 0x77, 0x71, 0x04, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0x10, 0xDF, 0xC0, 0x47, 0x77,
  0x70, 0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x60, 0x20, 0x9F, 0xD0, 0xE0, 0x17, 0x77, 0x84, 0x11, 0x36,
  0x8C, 0xFF, 0x03, 0x77, 0x10, 0x3F, 0xFF, 0xC0, 0x57, 0x72, 0x03, 0xFF, 0xFA, 0x0D, 0x03, 0x77,
  0x30, 0x3F, 0xFF, 0x90, 0x90, 0x17, 0x74, 0x03, 0xFF, 0xD8, 0x1E, 0x91, 0x77, 0x60, 0x3F, 0xFB,
  0x0E, 0x05, 0x77, 0x72, 0x03, 0xFF, 0xD8, 0x2E, 0xA7, 0x27, 0x75, 0x03, 0xFF, 0xFA, 0x0C, 0x05,
  0x77, 0x30, 0x3F, 0xFF, 0xC0, 0xD0, 0x47, 0x71, 0x03, 0xFF, 0xFE, 0x08, 0x77, 0x03, 0xFF, 0xFF,
  0x09, 0x76, 0x02, 0x80, 0x38, 0x82, 0x9A, 0xCE, 0xFF, 0xC0, 0x67, 0x77, 0x38, 0x21, 0x48, 0xEF,
  0xF0, 0xE0, 0x27, 0x77, 0x60, 0x6F, 0xF0, 0x97, 0x77, 0x70, 0x30, 0xEF, 0xE0, 0x17, 0x77, 0x70,
  0x5F, 0xE0, 0x67, 0x77, 0x71, 0x0D, 0xFD, 0x0A, 0x77, 0x77, 0x10, 0x7F, 0xD0, 0xE7, 0x77, 0x71,
  0x05, 0xFE, 0x77, 0x77, 0x10, 0x3F, 0xE0, 0x17, 0x77, 0x70, 0x3F, 0xE0, 0x27, 0x77, 0x70, 0x4F,
  0xE0, 0x17, 0x77, 0x70, 0x6F, 0xE7, 0x77, 0x71, 0x0A, 0xFE, 0x77, 0x77, 0x01, 0x0E, 0xFD, 0x82,
  0xC0, 0x42, 0x77, 0x74, 0x09, 0xFE, 0x84, 0x90, 0x9F, 0xB4, 0x77, 0x71, 0x06, 0xFF, 0x81, 0x60,
  0x9B, 0x81, 0xD9, 0x57, 0x74, 0x08, 0xFF, 0x98, 0x11, 0x09, 0xF8, 0x2B, 0x74, 0x17, 0x38, 0x12,
  0x7D, 0xFF, 0x90, 0xA2, 0x09, 0xFC, 0x89, 0x0E, 0xCA, 0x98, 0x89, 0x9B, 0xEF, 0xFC, 0x03, 0x20,
  0x98, 0x0C, 0x2F, 0x0A, 0x30, 0x98, 0x0C, 0x1F, 0x0E, 0x01, 0x30, 0x98, 0x0C, 0x1F, 0x03, 0x40,
  0x98, 0x0C, 0x0F, 0x05, 0x50, 0x9F, 0xFF, 0xFE, 0x0E, 0x04, 0x60, 0x9F, 0xFF, 0xFD, 0x0D, 0x03,
  0x70, 0x7F, 0xFF, 0xFC, 0x08, 0x74, 0x81, 0x5A, 0xEF, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x18, 0x23,
  0x7A, 0xEF, 0xFC, 0x81, 0xE9, 0x47, 0x77, 0x18, 0x72, 0x46, 0x8B, 0xCD, 0xEE, 0xA8, 0x5E, 0xDC,
  0xA8, 0x52, 0x77, 0x20,
  // "4" (U+0034)
  0x77, 0x75, 0x05, 0xFD, 0x01, 0x77, 0x77, 0x50, 0x10, 0xEF, 0xD0, 0x17, 0x77, 0x75, 0x09, 0xFE,
  0x01, 0x77, 0x77, 0x40, 0x4F, 0xF0, 0x17, 0x77, 0x74, 0x0D, 0xFF, 0x01, 0x77, 0x77, 0x30, 0x8F,
  0xF9, 0x01, 0x77, 0x77, 0x20, 0x3F, 0xFA, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xFA, 0x01, 0x77, 0x77,
  0x10, 0x7F, 0xFB, 0x01, 0x77, 0x77, 0x02, 0xFF, 0xC0, 0x17, 0x77, 0x70, 0xBF, 0xFC, 0x01, 0x77,
  0x76, 0x06, 0xFF, 0xD0, 0x17, 0x77, 0x50, 0x10, 0xEF, 0xFD, 0x01, 0x77, 0x75, 0x0A, 0xFF, 0xE0,
  0x17, 0x77, 0x40, 0x5F, 0xFF, 0x01, 0x77, 0x73, 0x01, 0x0E, 0xF9, 0x0D, 0x0C, 0xFC, 0x01, 0x77,
  0x73, 0x09, 0xFA, 0x05, 0x0C, 0xFC, 0x01, 0x77, 0x72, 0x04, 0xFA, 0x81, 0xD0, 0xDF, 0xC0, 0x17,
  0x77, 0x20, 0xDF, 0xA8, 0x15, 0x0E, 0xFC, 0x01, 0x77, 0x71, 0x08, 0xFA, 0x0C, 0x20, 0xEF, 0xC0,
  0x17, 0x77, 0x03, 0xFB, 0x03, 0x2F, 0xD0, 0x17, 0x77, 0x0C, 0xFA, 0x09, 0x3F, 0xD0, 0x17, 0x76,
  0x07, 0xFA, 0x0E, 0x01, 0x20, 0x1F, 0xD0, 0x17, 0x75, 0x02, 0xFB, 0x06, 0x30, 0x1F, 0xD0, 0x17,
  0x75, 0x0B, 0xFA, 0x0C, 0x40, 0x2F, 0xD0, 0x17, 0x74, 0x06, 0xFB, 0x03, 0x40, 0x3F, 0xD0, 0x17,
  0x73, 0x01, 0x0E, 0xFA, 0x09, 0x50, 0x3F, 0xD0, 0x17, 0x73, 0x0A, 0xFA, 0x0E, 0x01, 0x50, 0x4F,
  0xD0, 0x17, 0x72, 0x05, 0xFB, 0x06, 0x60, 0x4F, 0xD0, 0x17, 0x71, 0x01, 0x0E, 0xFA, 0x0C, 0x70,
  0x4F, 0xD0, 0x17, 0x71, 0x09, 0xFB, 0x03, 0x70, 0x4F, 0xD0, 0x17, 0x70, 0x4F, 0xB0, 0x97, 0x10,
  0x4F, 0xD0, 0x17, 0x70, 0xDF, 0xA0, 0xE0, 0x17, 0x10, 0x4F, 0xD0, 0x17, 0x60, 0x8F, 0xB0, 0x67,
  0x20, 0x4F, 0xD0, 0x17, 0x50, 0x3F, 0xB0, 0xC7, 0x30, 0x4F, 0xD0, 0x17, 0x50, 0xCF, 0xB0, 0x37,
  0x30, 0x4F, 0xD0, 0x17, 0x40, 0x7F, 0xB0, 0xA7, 0x40, 0x4F, 0xD0, 0x17, 0x30, 0x2F, 0xB0, 0xE0,
  0x17, 0x40, 0x4F, 0xD0, 0x17, 0x30, 0xBF, 0xB0, 0x77, 0x50, 0x4F, 0xD0, 0x17, 0x20, 0x6F, 0xB0,
  0xD7, 0x60, 0x4F, 0xD0, 0x17, 0x10, 0x10, 0xE8, 0x0D, 0x1F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68,
  0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68,
  0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x00, 0x68, 0x0D, 0x2F, 0x06, 0x03,
  0x80, 0xA5, 0x80, 0xAF, 0xD0, 0x98, 0x03, 0x80, 0x37, 0x77, 0x50, 0x4F, 0xD0, 0x17, 0x77, 0x76,
  0x04, 0xFD, 0x01, 0x77, 0x77, 0x60, 0x4F, 0xD0, 0x17, 0x77, 0x76, 0x04, 0xFD, 0x01, 0x77, 0x77,
  0x60, 0x4F, 0xD0, 0x17, 0x77, 0x76, 0x04, 0xFD, 0x01, 0x77, 0x77, 0x60, 0x4F, 0xD0, 0x17, 0x77,
  0x76, 0x04, 0xFD, 0x01, 0x77, 0x77, 0x60, 0x4F, 0xD0, 0x17, 0x77, 0x76, 0x04, 0xFD, 0x01, 0x77,
  0x77, 0x60, 0x4F, 0xD0, 0x17, 0x77, 0x76, 0x04, 0xFD, 0x01, 0x77, 0x77, 0x60, 0x4F, 0xD0, 0x17,
  0x10,
  // "5" (U+0035)
  0x40, 0x9F, 0xFF, 0xFC, 0x0B, 0x71, 0x0A, 0xFF, 0xFF, 0xC0, 0xB7, 0x10, 0xBF, 0xFF, 0xFC, 0x0B,
  0x71, 0x0C, 0xFF, 0xFF, 0xC0, 0xB7, 0x10, 0xEF, 0xFF, 0xFC, 0x0B, 0x71, 0xFF, 0xFF, 0xD0, 0xB7,
  0x01, 0xFF, 0xFF, 0xD0, 0xB7, 0x02, 0xFF, 0xFF, 0xD0, 0xB7, 0x03, 0xFF, 0xFF, 0xD0, 0xB7, 0x04,
  0xFF, 0xFF, 0xD0, 0xB7, 0x05, 0xFF, 0xFF, 0xD0, 0xB7, 0x06, 0xFD, 0x01, 0x77, 0x77, 0x08, 0xFD,
  0x77, 0x77, 0x10, 0x9F, 0xC0, 0xE7, 0x77, 0x71, 0x0A, 0xFC, 0x0D, 0x77, 0x77, 0x10, 0xBF, 0xC0,
  0xC7, 0x77, 0x71, 0x0C, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0xEF, 0xC0, 0xA7, 0x77, 0x71, 0xFD, 0x08,
  0x77, 0x77, 0x1F, 0xD0, 0x77, 0x77, 0x70, 0x2F, 0xD0, 0x67, 0x77, 0x70, 0x3F, 0xD0, 0x57, 0x77,
  0x70, 0x4F, 0xD0, 0x47, 0x77, 0x70, 0x5F, 0xD8, 0x92, 0x32, 0x57, 0x89, 0xA9, 0x98, 0x53, 0x77,
  0x30, 0x6F, 0xD0, 0xEF, 0xD0, 0xA0, 0x67, 0x70, 0x8F, 0xFF, 0xE0, 0xE0, 0x87, 0x50, 0x9F, 0xFF,
  0xF9, 0x0E, 0x05, 0x73, 0x0A, 0xFF, 0xFF, 0xB0, 0x97, 0x20, 0xBF, 0xFF, 0xFC, 0x0B, 0x71, 0x0C,
  0xFF, 0xFF, 0xD0, 0xA7, 0x0E, 0xFF, 0xFF, 0xE0, 0x76, 0x80, 0xC0, 0xF0, 0x25, 0x80, 0xC0, 0xF0,
  0xB5, 0x01, 0x09, 0xFF, 0xFF, 0xF0, 0x36, 0x02, 0x0A, 0xB8, 0x4E, 0xA7, 0x42, 0x13, 0x82, 0x13,
  0x7C, 0xFF, 0xB0, 0xB7, 0x18, 0x13, 0x83, 0x76, 0x02, 0x0B, 0xFF, 0xA0, 0x17, 0x77, 0x40, 0x7F,
  0xF9, 0x05, 0x77, 0x75, 0x08, 0xFF, 0x09, 0x77, 0x76, 0x0C, 0xFE, 0x0C, 0x77, 0x76, 0x04, 0xFF,
  0x77, 0x77, 0x0E, 0xFE, 0x01, 0x77, 0x76, 0x0B, 0xFE, 0x02, 0x77, 0x76, 0x08, 0xFE, 0x03, 0x77,
  0x76, 0x07, 0xFE, 0x03, 0x77, 0x76, 0x07, 0xFE, 0x02, 0x77, 0x76, 0x08, 0xFE, 0x01, 0x77, 0x76,
  0x09, 0xFE, 0x77, 0x77, 0x0C, 0xFD, 0x0D, 0x77, 0x76, 0x01, 0xFE, 0x0A, 0x77, 0x76, 0x08, 0xFE,
  0x83, 0x70, 0x28, 0x17, 0x77, 0x10, 0x30, 0xEF, 0xE8, 0x13, 0x02, 0xA0, 0xA0, 0x47, 0x75, 0x02,
  0x0D, 0xFE, 0x0D, 0x20, 0x2C, 0x82, 0xE9, 0x51, 0x77, 0x06, 0x0E, 0xFF, 0x07, 0x20, 0x2F, 0x98,
  0x5D, 0xA7, 0x53, 0x21, 0x28, 0x31, 0x25, 0x9E, 0xFF, 0x90, 0xE0, 0x12, 0x02, 0x80, 0xC1, 0xF0,
  0x63, 0x02, 0x80, 0xC0, 0xF0, 0xC4, 0x02, 0xFF, 0xFF, 0xF0, 0xE0, 0x24, 0x02, 0xFF, 0xFF, 0xF0,
  0x45, 0x02, 0xFF, 0xFF, 0xE0, 0x46, 0x02, 0xFF, 0xFF, 0xC0, 0xE0, 0x47, 0x02, 0xFF, 0xFF, 0xB0,
  0xB0, 0x17, 0x10, 0x10, 0xDF, 0xFF, 0xF0, 0xD0, 0x67, 0x50, 0x40, 0xAF, 0xFF, 0xB0, 0xD0, 0x67,
  0x72, 0x82, 0x15, 0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x71, 0x86, 0x24, 0x79, 0xBC, 0xDE, 0xA8,
  0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x30,
  // "6" (U+0036)
  0x77, 0x71, 0x87, 0x14, 0x78, 0xAC, 0xDE, 0xED, 0x82, 0xED, 0xB4, 0x77, 0x72, 0x81, 0x49, 0xDF,
  0xFB, 0x08, 0x77, 0x68, 0x13, 0x9E, 0xFF, 0xE0, 0x87, 0x74, 0x04, 0x0B, 0xFF, 0xFA, 0x08, 0x77,
  0x20, 0x20, 0xAF, 0xFF, 0xC0, 0x87, 0x71, 0x05, 0x0E, 0xFF, 0xFD, 0x08, 0x77, 0x09, 0xFF, 0xFF,
  0x08, 0x76, 0x0B, 0xFF, 0xFF, 0x90, 0x87, 0x50, 0xBF, 0xFF, 0xFA, 0x08, 0x74, 0x09, 0xFF, 0xFF,
  0xB0, 0x87, 0x30, 0x6F, 0xFD, 0x89, 0x1E, 0xCA, 0x98, 0x89, 0xAB, 0xCE, 0xA0, 0x87, 0x20, 0x2F,
  0xFB, 0x81, 0xB6, 0x27, 0x48, 0x12, 0x54, 0x72, 0x0B, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x40, 0x5F,
  0xF0, 0xD0, 0x37, 0x77, 0x60, 0xDF, 0xE0, 0xB7, 0x77, 0x70, 0x5F, 0xE0, 0xB7, 0x77, 0x71, 0x0C,
  0xFD, 0x0D, 0x77, 0x77, 0x10, 0x3F, 0xE0, 0x37, 0x77, 0x71, 0x09, 0xFD, 0x08, 0x77, 0x77, 0x20,
  0xEF, 0xC0, 0xE0, 0x17, 0x77, 0x71, 0x03, 0xFD, 0x09, 0x77, 0x77, 0x20, 0x7F, 0xD0, 0x37, 0x77,
  0x72, 0x0B, 0xFC, 0x0D, 0x71, 0x87, 0x14, 0x67, 0x77, 0x75, 0x37, 0x70, 0xEF, 0xC0, 0x85, 0x81,
  0x18, 0xDF, 0xB8, 0x1B, 0x61, 0x72, 0x02, 0xFD, 0x04, 0x30, 0x10, 0x9F, 0xF9, 0x0E, 0x07, 0x71,
  0x04, 0xFD, 0x01, 0x20, 0x30, 0xDF, 0xFC, 0x0D, 0x03, 0x60, 0x7F, 0xC0, 0xE2, 0x04, 0xFF, 0xF0,
  0xE0, 0x45, 0x09, 0xFC, 0x81, 0xB0, 0x3F, 0xFF, 0xB0, 0x44, 0x0A, 0xFC, 0x81, 0x91, 0xEF, 0xFF,
  0xB0, 0xE0, 0x13, 0x0C, 0xFC, 0x07, 0x0A, 0xFF, 0xFD, 0x0B, 0x30, 0xD8, 0x0C, 0x4F, 0x05, 0x20,
  0xE8, 0x0C, 0x4F, 0x0C, 0x28, 0x0C, 0x6F, 0x04, 0x1F, 0xFD, 0x86, 0x95, 0x10, 0x12, 0x6B, 0xFF,
  0x90, 0xA1, 0xFF, 0xB0, 0xB0, 0x27, 0x10, 0x50, 0xEF, 0xE0, 0xE1, 0xFF, 0xA0, 0x97, 0x40, 0x4F,
  0xF0, 0x3F, 0xF9, 0x0A, 0x76, 0x09, 0xFE, 0x07, 0xFF, 0x0E, 0x77, 0x01, 0xFE, 0x09, 0x0E, 0xFE,
  0x07, 0x77, 0x10, 0xBF, 0xD0, 0xC0, 0xDF, 0xE0, 0x17, 0x71, 0x07, 0xFD, 0x0D, 0x0C, 0xFD, 0x0C,
  0x77, 0x20, 0x4F, 0xE0, 0xAF, 0xD0, 0x97, 0x72, 0x02, 0xFE, 0x09, 0xFD, 0x08, 0x77, 0x20, 0x2F,
  0xE0, 0x6F, 0xD0, 0x77, 0x72, 0x01, 0xFE, 0x04, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xE0, 0x1F, 0xD0,
  0x97, 0x72, 0x03, 0xFD, 0x81, 0xE0, 0xDF, 0xC0, 0xB7, 0x72, 0x05, 0xFD, 0x81, 0xC0, 0x9F, 0xC0,
  0xE7, 0x72, 0x08, 0xFD, 0x81, 0xA0, 0x5F, 0xD0, 0x57, 0x71, 0x0C, 0xFD, 0x08, 0x20, 0xEF, 0xC0,
  0xC7, 0x70, 0x2F, 0xE0, 0x52, 0x0A, 0xFD, 0x07, 0x76, 0x0B, 0xFE, 0x01, 0x20, 0x4F, 0xE0, 0x47,
  0x40, 0x6F, 0xE0, 0xC4, 0x0C, 0xFE, 0x07, 0x72, 0x07, 0xFF, 0x06, 0x40, 0x5F, 0xF8, 0x7D, 0x73,
  0x10, 0x13, 0x7D, 0xFF, 0x0E, 0x01, 0x50, 0xC8, 0x0C, 0x0F, 0x08, 0x60, 0x3F, 0xFF, 0xFF, 0x0E,
  0x01, 0x70, 0x7F, 0xFF, 0xFE, 0x06, 0x72, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x40, 0xBF, 0xFF, 0xFA,
  0x0C, 0x75, 0x01, 0x0B, 0xFF, 0xFF, 0x0D, 0x01, 0x77, 0x0A, 0xFF, 0xFD, 0x0B, 0x01, 0x77, 0x20,
  0x50, 0xEF, 0xFF, 0xA0, 0x87, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xB0, 0x27, 0x77, 0x18, 0x11, 0x7D,
  0xFF, 0x81, 0xE9, 0x27, 0x77, 0x68, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77,
  // "7" (U+0037)
  0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0,
  0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0,
  0x07, 0x80, 0xD0, 0xF0, 0x50, 0x78, 0x0C, 0x7F, 0x81, 0xD0, 0x48, 0x0B, 0x28, 0xFE, 0x07, 0x77,
  0x77, 0x30, 0x5F, 0xE0, 0x17, 0x77, 0x73, 0x0C, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x3F, 0xE0, 0x27,
  0x77, 0x73, 0x0A, 0xFD, 0x0B, 0x77, 0x77, 0x30, 0x2F, 0xE0, 0x47, 0x77, 0x73, 0x09, 0xFD, 0x0D,
  0x77, 0x77, 0x30, 0x1F, 0xE0, 0x67, 0x77, 0x73, 0x07, 0xFD, 0x0E, 0x77, 0x77, 0x40, 0xEF, 0xD0,
  0x87, 0x77, 0x73, 0x06, 0xFE, 0x02, 0x77, 0x77, 0x30, 0xDF, 0xD0, 0xA7, 0x77, 0x73, 0x04, 0xFE,
  0x04, 0x77, 0x77, 0x30, 0xBF, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFE, 0x06, 0x77, 0x77, 0x30, 0xAF,
  0xD0, 0xE7, 0x77, 0x73, 0x01, 0xFE, 0x08, 0x77, 0x77, 0x30, 0x8F, 0xE0, 0x17, 0x77, 0x73, 0x0E,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x7F, 0xE0, 0x37, 0x77, 0x73, 0x0D, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x5F, 0xE0, 0x57, 0x77, 0x73, 0x0C, 0xFD, 0x0D, 0x77, 0x77, 0x30, 0x4F, 0xE0, 0x77, 0x77, 0x73,
  0x0B, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x2F, 0xE0, 0x97, 0x77, 0x73, 0x09, 0xFE, 0x02, 0x77,
  0x77, 0x20, 0x1F, 0xE0, 0xB7, 0x77, 0x73, 0x08, 0xFE, 0x04, 0x77, 0x77, 0x30, 0xEF, 0xD0, 0xD7,
  0x77, 0x73, 0x06, 0xFE, 0x06, 0x77, 0x77, 0x30, 0xDF, 0xD0, 0xE7, 0x77, 0x73, 0x05, 0xFE, 0x08,
  0x77, 0x77, 0x30, 0xCF, 0xE0, 0x27, 0x77, 0x72, 0x03, 0xFE, 0x0A, 0x77, 0x77, 0x30, 0xAF, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0xFE, 0x0C, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0x57, 0x77, 0x72, 0x01, 0x0E,
  0xFD, 0x0E, 0x77, 0x77, 0x30, 0x7F, 0xE0, 0x77, 0x77, 0x73, 0x0D, 0xFE, 0x01, 0x77, 0x77, 0x20,
  0x5F, 0xE0, 0x97, 0x77, 0x73, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x20, 0x4F, 0xE0, 0xB7, 0x77, 0x73,
  0x0B, 0xFE, 0x05, 0x77, 0x77, 0x20, 0x2F, 0xE0, 0xD7, 0x77, 0x73, 0x09, 0xFE, 0x07, 0x77, 0x77,
  0x20, 0x1F, 0xE0, 0xE0, 0x17, 0x77, 0x72, 0x08, 0xFE, 0x09, 0x77, 0x77, 0x30, 0xEF, 0xE0, 0x27,
  0x77, 0x72, 0x06, 0xFE, 0x0B, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x47, 0x77, 0x72, 0x05, 0xFE, 0x0D,
  0x77, 0x77, 0x30, 0xCF, 0xE0, 0x67, 0x77, 0x30,
  // "8" (U+0038)
  0x77, 0x18, 0x43, 0x79, 0xBD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x76, 0x81, 0x5A, 0xEF, 0xF9,
  0x81, 0xB6, 0x17, 0x77, 0x07, 0x0D, 0xFF, 0xE8, 0x1E, 0x81, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0xB0,
  0xE0, 0x67, 0x71, 0x08, 0xFF, 0xFF, 0x0A, 0x76, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x40, 0x9F, 0xFF,
  0xFC, 0x0B, 0x72, 0x05, 0xFF, 0xFF, 0xE0, 0x77, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xE0, 0x16, 0x07,
  0x80, 0xC0, 0xF0, 0x86, 0x0D, 0xFF, 0x98, 0x4D, 0xA8, 0x8A, 0xDF, 0xF9, 0x0E, 0x50, 0x3F, 0xF0,
  0xB0, 0x36, 0x03, 0x0B, 0xFF, 0x03, 0x40, 0x6F, 0xE0, 0x97, 0x30, 0x9F, 0xE0, 0x64, 0x08, 0xFD,
  0x0C, 0x75, 0x0C, 0xFD, 0x08, 0x40, 0x9F, 0xD0, 0x57, 0x50, 0x5F, 0xD0, 0x94, 0x0A, 0xFD, 0x02,
  0x75, 0x02, 0xFD, 0x0A, 0x40, 0x9F, 0xD0, 0x17, 0x50, 0x1F, 0xD0, 0x94, 0x08, 0xFD, 0x02, 0x75,
  0x02, 0xFD, 0x08, 0x40, 0x6F, 0xD0, 0x57, 0x50, 0x5F, 0xD0, 0x64, 0x03, 0xFD, 0x0A, 0x75, 0x0A,
  0xFD, 0x03, 0x50, 0xEF, 0xD0, 0x27, 0x30, 0x2F, 0xD0, 0xE6, 0x0A, 0xFD, 0x0D, 0x01, 0x72, 0x0C,
  0xFD, 0x08, 0x60, 0x4F, 0xE0, 0xC0, 0x17, 0x0B, 0xFE, 0x02, 0x70, 0xCF, 0xE0, 0xE0, 0x34, 0x02,
  0x0C, 0xFE, 0x09, 0x71, 0x03, 0xFF, 0x90, 0x82, 0x07, 0xFF, 0x0D, 0x01, 0x72, 0x09, 0xFF, 0x90,
  0x0D, 0xFF, 0x90, 0x37, 0x40, 0xCF, 0xFF, 0xFA, 0x05, 0x75, 0x01, 0x0D, 0xFF, 0xFF, 0x04, 0x77,
  0x02, 0x0D, 0xFF, 0xFC, 0x0D, 0x03, 0x77, 0x20, 0x10, 0xCF, 0xFF, 0xA0, 0x97, 0x76, 0x09, 0xFF,
  0xE0, 0xD0, 0x47, 0x77, 0x10, 0x9F, 0xFD, 0x08, 0x77, 0x70, 0x20, 0xBF, 0xFF, 0x0D, 0x04, 0x77,
  0x40, 0x7F, 0xFF, 0xC0, 0x97, 0x71, 0x01, 0x0A, 0xFF, 0xFE, 0x0C, 0x02, 0x75, 0x01, 0x0D, 0xFF,
  0xFF, 0x90, 0xE0, 0x47, 0x30, 0x10, 0xDF, 0xFF, 0xFC, 0x04, 0x72, 0x0C, 0xFF, 0x98, 0x19, 0x4C,
  0xFF, 0xA0, 0x47, 0x09, 0xFF, 0x0C, 0x03, 0x30, 0x60, 0xEF, 0xF0, 0xE0, 0x25, 0x04, 0xFF, 0x08,
  0x60, 0x20, 0xBF, 0xF0, 0xD5, 0x0C, 0xFE, 0x06, 0x72, 0x08, 0xFF, 0x07, 0x30, 0x4F, 0xE0, 0x77,
  0x40, 0x6F, 0xE0, 0xE0, 0x12, 0x09, 0xFD, 0x0A, 0x76, 0x05, 0xFE, 0x07, 0x20, 0xEF, 0xC0, 0xE0,
  0x17, 0x70, 0x8F, 0xD8, 0x1D, 0x03, 0xFD, 0x09, 0x77, 0x20, 0xDF, 0xD0, 0x20, 0x6F, 0xD0, 0x47,
  0x72, 0x06, 0xFD, 0x05, 0x08, 0xFD, 0x77, 0x30, 0x1F, 0xD0, 0x80, 0x9F, 0xC0, 0xE7, 0x74, 0xFD,
  0x09, 0x0A, 0xFC, 0x0E, 0x77, 0x40, 0xEF, 0xC0, 0x0A, 0xFD, 0x77, 0x4F, 0xD0, 0x09, 0xFD, 0x05,
  0x77, 0x20, 0x4F, 0xD0, 0x80, 0x7F, 0xD0, 0xB7, 0x72, 0x0B, 0xFD, 0x06, 0x05, 0xFE, 0x06, 0x77,
  0x06, 0xFE, 0x03, 0x02, 0xFF, 0x06, 0x75, 0x06, 0xFF, 0x20, 0xDF, 0xF0, 0xB0, 0x47, 0x10, 0x40,
  0xBF, 0xF0, 0xA2, 0x07, 0xFF, 0xA8, 0x6E, 0xB9, 0x88, 0x9B, 0xEF, 0xFA, 0x03, 0x20, 0x18, 0x0C,
  0x3F, 0x0B, 0x40, 0x78, 0x0C, 0x2F, 0x02, 0x50, 0xC8, 0x0C, 0x0F, 0x06, 0x60, 0x10, 0xDF, 0xFF,
  0xFE, 0x08, 0x71, 0x02, 0x0D, 0xFF, 0xFF, 0xC0, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0xF9, 0x0E, 0x05,
  0x76, 0x07, 0x0E, 0xFF, 0xFD, 0x0A, 0x01, 0x77, 0x18, 0x11, 0x8E, 0xFF, 0xF9, 0x0A, 0x03, 0x77,
  0x68, 0x15, 0xAE, 0xFF, 0xA8, 0x1C, 0x71, 0x77, 0x74, 0x85, 0x36, 0x9B, 0xCE, 0xEA, 0x85, 0xED,
  0xCA, 0x84, 0x17, 0x70,
  // "9" (U+0039)
  0x77, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x68, 0x12, 0x8D, 0xFF, 0x81,
  0xD7, 0x17, 0x77, 0x10, 0x20, 0xAF, 0xFE, 0x09, 0x01, 0x77, 0x50, 0x7F, 0xFF, 0xA0, 0xE0, 0x57,
  0x73, 0x0A, 0xFF, 0xFD, 0x09, 0x77, 0x10, 0xCF, 0xFF, 0xF0, 0xB7, 0x60, 0xBF, 0xFF, 0xFA, 0x0B,
  0x74, 0x09, 0xFF, 0xFF, 0xC0, 0xA7, 0x20, 0x4F, 0xFF, 0xFE, 0x06, 0x71, 0x0D, 0xFF, 0xFF, 0xF0,
  0x26, 0x07, 0x80, 0xC0, 0xF0, 0xB6, 0x0E, 0xFF, 0x87, 0xD7, 0x31, 0x01, 0x38, 0xDF, 0xF0, 0x54,
  0x05, 0xFF, 0x08, 0x72, 0x08, 0xFE, 0x0C, 0x40, 0xAF, 0xE0, 0x77, 0x40, 0x6F, 0xE0, 0x33, 0x0E,
  0xFD, 0x0C, 0x76, 0x08, 0xFD, 0x0A, 0x20, 0x4F, 0xE0, 0x37, 0x70, 0xDF, 0xC0, 0xE2, 0x07, 0xFD,
  0x0D, 0x77, 0x10, 0x7F, 0xD8, 0x15, 0x0A, 0xFD, 0x09, 0x77, 0x10, 0x1F, 0xD8, 0x19, 0x0C, 0xFD,
  0x06, 0x77, 0x20, 0xDF, 0xC8, 0x1D, 0x0D, 0xFD, 0x03, 0x77, 0x20, 0xAF, 0xD0, 0x1F, 0xE0, 0x27,
  0x72, 0x08, 0xFD, 0x04, 0xFE, 0x02, 0x77, 0x20, 0x7F, 0xD0, 0x6F, 0xE0, 0x17, 0x72, 0x07, 0xFD,
  0x09, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xD0, 0xAF, 0xE0, 0x37, 0x72, 0x0A, 0xFD, 0x0C, 0x0E, 0xFD,
  0x05, 0x77, 0x20, 0xEF, 0xD0, 0xD0, 0xCF, 0xD0, 0x97, 0x71, 0x03, 0xFE, 0x0E, 0x0B, 0xFD, 0x0D,
  0x77, 0x10, 0xAF, 0xF0, 0x8F, 0xE0, 0x47, 0x60, 0x4F, 0xF9, 0x05, 0xFE, 0x0D, 0x75, 0x02, 0x0E,
  0xFF, 0x90, 0x1F, 0xF0, 0xB7, 0x30, 0x40, 0xEF, 0xFA, 0x10, 0xCF, 0xF0, 0xC0, 0x46, 0x02, 0x0A,
  0xFF, 0xC1, 0x06, 0xFF, 0xA8, 0x4E, 0xA9, 0x8A, 0xDF, 0xFE, 0x10, 0x10, 0xE8, 0x0C, 0x4F, 0x0E,
  0x20, 0x88, 0x0C, 0x4F, 0x0D, 0x20, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0xDF, 0xC0, 0xC3, 0x05, 0xFF,
  0xFD, 0x06, 0x09, 0xFC, 0x0A, 0x40, 0x9F, 0xFF, 0xB8, 0x1A, 0x0B, 0xFC, 0x09, 0x50, 0xAF, 0xFF,
  0x90, 0xC2, 0x0D, 0xFC, 0x07, 0x60, 0x9F, 0xFE, 0x0B, 0x01, 0x2F, 0xD0, 0x57, 0x05, 0x0E, 0xFF,
  0xB0, 0x73, 0x03, 0xFD, 0x02, 0x72, 0x07, 0x0D, 0xFD, 0x81, 0xE9, 0x24, 0x06, 0xFD, 0x75, 0x83,
  0x37, 0xAC, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x0A, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xEF, 0xC0, 0x87,
  0x77, 0x72, 0x05, 0xFD, 0x04, 0x77, 0x77, 0x20, 0xBF, 0xD0, 0x17, 0x77, 0x71, 0x02, 0xFD, 0x0B,
  0x77, 0x77, 0x20, 0xAF, 0xD0, 0x67, 0x77, 0x71, 0x04, 0xFE, 0x01, 0x77, 0x77, 0x01, 0x0D, 0xFD,
  0x09, 0x77, 0x77, 0x10, 0xBF, 0xE0, 0x27, 0x77, 0x70, 0xAF, 0xE0, 0xB7, 0x77, 0x60, 0x20, 0xCF,
  0xF0, 0x27, 0x77, 0x40, 0x20, 0x9F, 0xF9, 0x08, 0x72, 0x00, 0x37, 0x58, 0x12, 0x6B, 0xFF, 0xA0,
  0xD7, 0x30, 0xBA, 0x89, 0x1D, 0xBA, 0x98, 0x88, 0x9A, 0xCE, 0xFF, 0xD0, 0x37, 0x30, 0xBF, 0xFF,
  0xFB, 0x06, 0x74, 0x0B, 0xFF, 0xFF, 0xA0, 0x87, 0x50, 0xBF, 0xFF, 0xF9, 0x08, 0x76, 0x0B, 0xFF,
  0xFF, 0x06, 0x77, 0x0B, 0xFF, 0xFD, 0x0D, 0x03, 0x77, 0x10, 0xBF, 0xFF, 0xC0, 0x87, 0x73, 0x0B,
  0xFF, 0xFA, 0x0A, 0x02, 0x77, 0x40, 0xBF, 0xFE, 0x81, 0xE8, 0x17, 0x76, 0x0B, 0xFF, 0xB8, 0x1C,
  0x83, 0x77, 0x72, 0x81, 0x6C, 0xEE, 0x86, 0xEE, 0xDC, 0xA8, 0x63, 0x77, 0x72,
  // ":" (U+003A)
  0x48, 0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x70, 0x7F, 0xA0, 0xE0, 0x44, 0x08, 0xFD, 0x04, 0x20, 0x3F,
  0xE8, 0x2E, 0x10, 0xAF, 0xF8, 0x17, 0x0E, 0xFF, 0x0C, 0x01, 0xFF, 0xA0, 0x2F, 0xFA, 0x02, 0xFF,
  0xA0, 0x1F, 0xFA, 0x10, 0xDF, 0xF8, 0x1B, 0x08, 0xFF, 0x81, 0x60, 0x1F, 0xE0, 0xD3, 0x05, 0xFD,
  0x03, 0x40, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x80, 0xD8, 0x70, 0x87,
  0x17, 0xBD, 0xFE, 0xDA, 0x67, 0x07, 0xFA, 0x0E, 0x04, 0x40, 0x8F, 0xD0, 0x42, 0x03, 0xFE, 0x82,
  0xE1, 0x0A, 0xFF, 0x81, 0x70, 0xEF, 0xF0, 0xC0, 0x1F, 0xFA, 0x02, 0xFF, 0xA0, 0x2F, 0xFA, 0x01,
  0xFF, 0xA1, 0x0D, 0xFF, 0x81, 0xB0, 0x8F, 0xF8, 0x16, 0x01, 0xFE, 0x0D, 0x30, 0x5F, 0xD0, 0x34,
  0x05, 0x0E, 0xF9, 0x0D, 0x03, 0x78, 0x66, 0xBD, 0xFE, 0xDA, 0x54,
  // ";" (U+003B)
  0x78, 0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x73, 0x07, 0xFA, 0x0E, 0x04, 0x70, 0x8F, 0xD0, 0x45, 0x03,
  0xFE, 0x0E, 0x50, 0xAF, 0xF0, 0x74, 0x0E, 0xFF, 0x0B, 0x30, 0x1F, 0xF9, 0x0E, 0x30, 0x2F, 0xFA,
  0x30, 0x2F, 0xFA, 0x30, 0x1F, 0xF9, 0x0E, 0x40, 0xDF, 0xF0, 0xB4, 0x09, 0xFF, 0x06, 0x40, 0x2F,
  0xE0, 0xD6, 0x05, 0xFC, 0x0E, 0x03, 0x70, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x38, 0x66, 0xBD, 0xFE,
  0xDA, 0x58, 0x0E, 0xF5, 0x00, 0xBF, 0xC0, 0xE0, 0x16, 0x0E, 0xFD, 0x02, 0x50, 0x1F, 0xD0, 0xD6,
  0x03, 0xFD, 0x09, 0x60, 0x6F, 0xD0, 0x56, 0x08, 0xFD, 0x01, 0x60, 0xBF, 0xC0, 0xC7, 0x0E, 0xFC,
  0x08, 0x60, 0x1F, 0xD0, 0x46, 0x04, 0xFC, 0x0E, 0x70, 0x6F, 0xC0, 0xA7, 0x09, 0xFC, 0x05, 0x70,
  0xCF, 0xC0, 0x17, 0x0E, 0xFB, 0x0B, 0x70, 0x2F, 0xC0, 0x67, 0x05, 0xFC, 0x01, 0x70, 0x7F, 0xB0,
  0xC7, 0x10, 0xAF, 0xB0, 0x77, 0x10, 0xDF, 0xB0, 0x17, 0x01, 0xFB, 0x0B, 0x71, 0x04, 0xFB, 0x05,
  0x71, 0x07, 0xFA, 0x0E, 0x72, 0x0B, 0xFA, 0x09, 0x72, 0x0E, 0xFA, 0x02, 0x71, 0x03, 0xFA, 0x0B,
  0x72, 0x06, 0xFA, 0x04, 0x72,
  // "<" (U+003C)
  0x80, 0xC1, 0x08, 0x11, 0x84, 0x77, 0x77, 0x78, 0x31, 0x7E, 0xF5, 0x77, 0x77, 0x60, 0x70, 0xEB,
  0x05, 0x77, 0x77, 0x40, 0x60, 0xED, 0x05, 0x77, 0x77, 0x20, 0x60, 0xDF, 0x05, 0x77, 0x77, 0x05,
  0x0D, 0xFA, 0x05, 0x77, 0x75, 0x05, 0x0D, 0xFC, 0x05, 0x77, 0x73, 0x04, 0x0C, 0xFE, 0x05, 0x77,
  0x71, 0x04, 0x0C, 0xFF, 0x90, 0x57, 0x76, 0x03, 0x0C, 0xFF, 0xB0, 0x57, 0x74, 0x03, 0x0B, 0xFF,
  0xC0, 0xE0, 0x37, 0x72, 0x03, 0x0A, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x10, 0x20, 0xAF, 0xFC, 0x81,
  0xE8, 0x17, 0x71, 0x02, 0x09, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x10, 0x10, 0x9F, 0xFC, 0x81, 0xE7,
  0x17, 0x71, 0x01, 0x08, 0xFF, 0xC0, 0xE0, 0x77, 0x72, 0x81, 0x18, 0xEF, 0xFB, 0x0E, 0x07, 0x77,
  0x28, 0x11, 0x7E, 0xFF, 0xB0, 0xE0, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xB0, 0xD0, 0x67, 0x73, 0x06,
  0x0E, 0xFF, 0xB0, 0xD0, 0x67, 0x74, 0x05, 0xFF, 0xB0, 0xD0, 0x67, 0x76, 0x05, 0xFF, 0x90, 0xD0,
  0x67, 0x77, 0x10, 0x5F, 0xE0, 0xD0, 0x57, 0x77, 0x30, 0x5F, 0xE8, 0x1E, 0x71, 0x77, 0x72, 0x05,
  0xFF, 0x98, 0x1E, 0x81, 0x77, 0x70, 0x5F, 0xFC, 0x09, 0x02, 0x77, 0x50, 0x10, 0xAF, 0xFD, 0x0B,
  0x03, 0x77, 0x50, 0x20, 0xAF, 0xFD, 0x0C, 0x05, 0x77, 0x50, 0x20, 0x9F, 0xFD, 0x0D, 0x06, 0x77,
  0x50, 0x20, 0x9F, 0xFD, 0x0E, 0x07, 0x77, 0x50, 0x10, 0x9F, 0xFD, 0x81, 0xE8, 0x17, 0x74, 0x81,
  0x18, 0xEF, 0xFD, 0x09, 0x02, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xD0, 0xA0, 0x37, 0x74, 0x81, 0x17,
  0xEF, 0xFD, 0x0B, 0x04, 0x77, 0x50, 0x70, 0xEF, 0xFD, 0x0C, 0x02, 0x77, 0x50, 0x60, 0xDF, 0xFC,
  0x05, 0x77, 0x70, 0x60, 0xDF, 0xFA, 0x05, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0x05, 0x77, 0x74, 0x05,
  0x0D, 0xFD, 0x05, 0x77, 0x76, 0x05, 0x0C, 0xFB, 0x05, 0x77, 0x77, 0x10, 0x40, 0xCF, 0x90, 0x57,
  0x77, 0x73, 0x04, 0x0B, 0xE0, 0x57, 0x77, 0x75, 0x03, 0x0B, 0xC0, 0x57, 0x77, 0x77, 0x03, 0x0B,
  0xA0, 0x58, 0x0C, 0x10, 0x81, 0x3A, 0x50,
  // "=" (U+003D)
  0x05, 0x80, 0xC4, 0x80, 0x50, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A, 0x80, 0xD9, 0x40,
  0x05, 0x80, 0xC4, 0x80, 0x50, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A,
  // ">" (U+003E)
  0x81, 0x48, 0x18, 0x0C, 0x10, 0x83, 0x5F, 0xE8, 0x17, 0x77, 0x77, 0x05, 0xB0, 0xE0, 0x77, 0x77,
  0x76, 0x05, 0xD0, 0xE0, 0x77, 0x77, 0x74, 0x05, 0xF0, 0xD0, 0x67, 0x77, 0x72, 0x05, 0xFA, 0x0D,
  0x06, 0x77, 0x77, 0x05, 0xFC, 0x0D, 0x05, 0x77, 0x75, 0x05, 0xFE, 0x0C, 0x05, 0x77, 0x73, 0x05,
  0xFF, 0x90, 0xC0, 0x47, 0x77, 0x10, 0x5F, 0xFB, 0x0B, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xFC, 0x0B,
  0x03, 0x77, 0x58, 0x11, 0x8E, 0xFF, 0xC0, 0xB0, 0x37, 0x75, 0x81, 0x18, 0xEF, 0xFC, 0x0A, 0x02,
  0x77, 0x58, 0x11, 0x8E, 0xFF, 0xC0, 0xA0, 0x27, 0x75, 0x81, 0x17, 0xEF, 0xFC, 0x09, 0x01, 0x77,
  0x60, 0x70, 0xEF, 0xFC, 0x09, 0x01, 0x77, 0x60, 0x70, 0xEF, 0xFB, 0x81, 0xE8, 0x17, 0x76, 0x07,
  0x0E, 0xFF, 0xB8, 0x1E, 0x71, 0x77, 0x60, 0x60, 0xDF, 0xFB, 0x0E, 0x07, 0x77, 0x70, 0x60, 0xDF,
  0xFB, 0x0E, 0x07, 0x77, 0x70, 0x60, 0xDF, 0xFB, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0x90, 0x57,
  0x77, 0x30, 0x50, 0xDF, 0xE0, 0x57, 0x77, 0x28, 0x11, 0x7E, 0xFE, 0x05, 0x77, 0x78, 0x11, 0x8E,
  0xFF, 0x90, 0x57, 0x75, 0x02, 0x0A, 0xFF, 0xC0, 0x57, 0x73, 0x03, 0x0B, 0xFF, 0xD0, 0xA0, 0x17,
  0x71, 0x05, 0x0C, 0xFF, 0xD0, 0xA0, 0x27, 0x71, 0x06, 0x0D, 0xFF, 0xD0, 0x90, 0x27, 0x71, 0x07,
  0x0E, 0xFF, 0xD0, 0x90, 0x27, 0x78, 0x11, 0x8E, 0xFF, 0xD0, 0x90, 0x17, 0x70, 0x20, 0x9F, 0xFD,
  0x81, 0xE8, 0x17, 0x70, 0x30, 0xAF, 0xFD, 0x81, 0xE8, 0x17, 0x70, 0x40, 0xBF, 0xFD, 0x81, 0xE7,
  0x17, 0x70, 0x20, 0xCF, 0xFD, 0x0E, 0x07, 0x77, 0x30, 0x5F, 0xFC, 0x0D, 0x06, 0x77, 0x50, 0x5F,
  0xFA, 0x0D, 0x06, 0x77, 0x70, 0x5F, 0xF0, 0xD0, 0x67, 0x77, 0x20, 0x5F, 0xD0, 0xD0, 0x57, 0x77,
  0x40, 0x5F, 0xB0, 0xC0, 0x57, 0x77, 0x60, 0x5F, 0x90, 0xC0, 0x47, 0x77, 0x71, 0x05, 0xE0, 0xB0,
  0x47, 0x77, 0x73, 0x05, 0xC0, 0xB0, 0x37, 0x77, 0x75, 0x05, 0xA0, 0xB0, 0x37, 0x77, 0x77, 0x81,
  0x5A, 0x38, 0x0C, 0x10,
  // "?" (U+003F)
  0x75, 0x85, 0x35, 0x8A, 0xCD, 0xEA, 0x85, 0xEE, 0xDB, 0x95, 0x27, 0x76, 0x82, 0x26, 0xBE, 0xFF,
  0xA8, 0x1D, 0x72, 0x77, 0x81, 0x16, 0xCF, 0xFF, 0xA0, 0x90, 0x27, 0x30, 0x30, 0xAF, 0xFF, 0xF0,
  0x77, 0x04, 0x0B, 0xFF, 0xFF, 0xB0, 0xB5, 0x08, 0xFF, 0xFF, 0xE0, 0xC4, 0x03, 0xFF, 0xFF, 0xF0,
  0xA4, 0x0B, 0xFF, 0xFF, 0xF0, 0x73, 0x03, 0xFF, 0xFF, 0xF0, 0xE0, 0x13, 0x0B, 0xFF, 0xFF, 0xF0,
  0x83, 0x03, 0xFD, 0x86, 0xEC, 0xA9, 0x89, 0xAD, 0xFF, 0x90, 0xE4, 0x0B, 0xF9, 0x81, 0xC7, 0x37,
  0x10, 0x30, 0xAF, 0xF0, 0x33, 0x03, 0xD8, 0x1D, 0x71, 0x76, 0x06, 0xFE, 0x07, 0x40, 0xBA, 0x0B,
  0x04, 0x77, 0x30, 0x9F, 0xD0, 0x94, 0x81, 0x3A, 0x27, 0x75, 0x03, 0xFD, 0x0B, 0x77, 0x76, 0xFD,
  0x0B, 0x77, 0x76, 0x0E, 0xFC, 0x0B, 0x77, 0x76, 0xFD, 0x0B, 0x77, 0x75, 0x02, 0xFD, 0x09, 0x77,
  0x75, 0x06, 0xFD, 0x07, 0x77, 0x75, 0x0D, 0xFD, 0x04, 0x77, 0x74, 0x08, 0xFE, 0x01, 0x77, 0x73,
  0x06, 0xFE, 0x0A, 0x77, 0x73, 0x06, 0xFF, 0x04, 0x77, 0x72, 0x08, 0xFF, 0x0A, 0x77, 0x71, 0x01,
  0x0B, 0xFF, 0x0E, 0x01, 0x77, 0x70, 0x30, 0xDF, 0xF0, 0xE0, 0x37, 0x77, 0x07, 0xFF, 0x90, 0xE0,
  0x47, 0x77, 0x09, 0xFF, 0x90, 0xE0, 0x37, 0x77, 0x0B, 0xFF, 0x90, 0xD0, 0x27, 0x77, 0x0A, 0xFF,
  0x90, 0xA7, 0x77, 0x10, 0x8F, 0xF9, 0x07, 0x77, 0x71, 0x04, 0xFF, 0x0D, 0x03, 0x77, 0x72, 0x0D,
  0xFE, 0x0B, 0x01, 0x77, 0x72, 0x05, 0xFE, 0x09, 0x77, 0x74, 0x0A, 0xFD, 0x07, 0x77, 0x75, 0x0E,
  0xFC, 0x08, 0x77, 0x75, 0x02, 0xFC, 0x0E, 0x77, 0x76, 0x04, 0xFC, 0x08, 0x77, 0x76, 0x05, 0xFC,
  0x05, 0x77, 0x76, 0x05, 0xFC, 0x04, 0x77, 0x76, 0x05, 0xFC, 0x03, 0x77, 0x76, 0x05, 0xFC, 0x03,
  0x77, 0x76, 0x03, 0x80, 0x79, 0x02, 0x80, 0xC9, 0x10, 0x87, 0x49, 0xCE, 0xFE, 0xC9, 0x37, 0x77,
  0x71, 0x01, 0x0C, 0xFA, 0x0A, 0x01, 0x77, 0x75, 0x01, 0x0D, 0xFC, 0x0C, 0x77, 0x75, 0x0A, 0xFE,
  0x09, 0x77, 0x73, 0x01, 0xFF, 0x90, 0x17, 0x77, 0x20, 0x5F, 0xF9, 0x05, 0x77, 0x72, 0x08, 0xFF,
  0x90, 0x87, 0x77, 0x20, 0x9F, 0xF9, 0x09, 0x77, 0x72, 0x09, 0xFF, 0x90, 0x97, 0x77, 0x20, 0x7F,
  0xF9, 0x08, 0x77, 0x72, 0x04, 0xFF, 0x90, 0x57, 0x77, 0x30, 0xEF, 0xE0, 0xE7, 0x77, 0x40, 0x8F,
  0xE0, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xB7, 0x77, 0x70, 0x9F, 0xA0, 0x97, 0x77, 0x72, 0x87, 0x28,
  0xCE, 0xFE, 0xC8, 0x27, 0x74,
  // "@" (U+0040)
  0x77, 0x71, 0x89, 0x42, 0x68, 0xBD, 0xDE, 0xFE, 0xDC, 0x96, 0x38, 0x0C, 0x10, 0x81, 0x38, 0xDF,
  0xF8, 0x1E, 0x82, 0x77, 0x77, 0x40, 0x50, 0xCF, 0xFE, 0x0B, 0x02, 0x77, 0x77, 0x03, 0x0C, 0xFF,
  0xFB, 0x08, 0x77, 0x75, 0x08, 0xFF, 0xFE, 0x0D, 0x02, 0x77, 0x71, 0x01, 0x0C, 0xFF, 0xFF, 0x90,
  0xE0, 0x47, 0x76, 0x03, 0x0E, 0xFF, 0xFF, 0xC0, 0x57, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x2E, 0xB6,
  0x32, 0x10, 0x12, 0x59, 0xEF, 0xC0, 0x47, 0x72, 0x03, 0x0E, 0xFB, 0x0D, 0x06, 0x75, 0x06, 0x0E,
  0xFA, 0x0E, 0x02, 0x77, 0x01, 0x0D, 0xFB, 0x06, 0x77, 0x10, 0x10, 0xAF, 0xA0, 0xC7, 0x70, 0xBF,
  0xA0, 0xD0, 0x27, 0x74, 0x08, 0xFA, 0x08, 0x75, 0x07, 0xFA, 0x0C, 0x77, 0x70, 0x8F, 0xA0, 0x37,
  0x30, 0x2F, 0xA0, 0xC7, 0x77, 0x20, 0xAF, 0x90, 0xB7, 0x30, 0xCF, 0x90, 0xD0, 0x17, 0x77, 0x30,
  0xDF, 0x90, 0x47, 0x10, 0x5F, 0xA0, 0x37, 0x77, 0x40, 0x4F, 0x90, 0xC7, 0x10, 0xDF, 0x90, 0x77,
  0x77, 0x60, 0xBF, 0x90, 0x26, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x03, 0xF9, 0x08, 0x60, 0xDF, 0x90,
  0x47, 0x28, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x63, 0x71, 0x0C, 0xF0, 0xE5, 0x04, 0xF9, 0x0B,
  0x71, 0x01, 0x09, 0xFD, 0x82, 0xEB, 0x61, 0x40, 0x7F, 0x90, 0x44, 0x0A, 0xF9, 0x04, 0x70, 0x50,
  0xEF, 0xFB, 0x0C, 0x01, 0x20, 0x2F, 0x90, 0x83, 0x01, 0xF9, 0x0D, 0x70, 0x6F, 0xFE, 0x01, 0x30,
  0xDF, 0x0C, 0x30, 0x6F, 0x90, 0x76, 0x05, 0xFF, 0xF4, 0x0A, 0xF9, 0x30, 0xBF, 0x90, 0x25, 0x03,
  0xFF, 0xF9, 0x40, 0x7F, 0x90, 0x32, 0xF9, 0x0D, 0x60, 0xCF, 0xFF, 0x0E, 0x40, 0x4F, 0x98, 0x16,
  0x04, 0xF9, 0x08, 0x50, 0x6F, 0xFF, 0x90, 0xD4, 0x02, 0xF9, 0x81, 0x80, 0x8F, 0x90, 0x45, 0x0D,
  0xFA, 0x84, 0x82, 0x01, 0x6E, 0xF0, 0xC5, 0xF9, 0x81, 0xA0, 0xBF, 0x95, 0x05, 0xFA, 0x04, 0x50,
  0xDF, 0x0C, 0x50, 0xEF, 0x81, 0xC0, 0xEF, 0x0D, 0x50, 0xAF, 0x90, 0x86, 0x0E, 0xF0, 0xB5, 0x0D,
  0xF0, 0xD0, 0x2F, 0x90, 0xA5, 0xF9, 0x0D, 0x7F, 0x90, 0xA5, 0x0C, 0xF0, 0xD0, 0x4F, 0x90, 0x74,
  0x04, 0xF9, 0x08, 0x7F, 0x90, 0x95, 0x0C, 0xF0, 0xE0, 0x7F, 0x90, 0x54, 0x07, 0xF9, 0x03, 0x60,
  0x1F, 0x90, 0x85, 0x0B, 0xF9, 0x09, 0xF9, 0x03, 0x40, 0xBF, 0x0E, 0x70, 0x2F, 0x90, 0x85, 0x0B,
  0xF9, 0x0A, 0xF9, 0x01, 0x40, 0xDF, 0x0C, 0x70, 0x3F, 0x90, 0x75, 0x0B, 0xF0, 0xE0, 0xBF, 0x95,
  0x0E, 0xF0, 0x97, 0x04, 0xF9, 0x06, 0x50, 0xCF, 0x0E, 0x0D, 0xF0, 0xE5, 0xF9, 0x08, 0x70, 0x4F,
  0x90, 0x55, 0x0C, 0xF0, 0xD0, 0xEF, 0x0E, 0x40, 0x1F, 0x90, 0x77, 0x06, 0xF9, 0x04, 0x50, 0xDF,
  0x0B, 0x0E, 0xF0, 0xD4, 0x01, 0xF9, 0x06, 0x70, 0x7F, 0x90, 0x45, 0xF9, 0x0A, 0xF9, 0x0C, 0x40,
  0x1F, 0x90, 0x67, 0x08, 0xF9, 0x03, 0x40, 0x1F, 0x90, 0x8F, 0x90, 0xC5, 0xF9, 0x06, 0x70, 0xAF,
  0x90, 0x24, 0x03, 0xF9, 0x05, 0xF9, 0x0D, 0x5F, 0x90, 0x77, 0x0D, 0xF9, 0x02, 0x40, 0x5F, 0x90,
  0x30, 0xEF, 0x0D, 0x50, 0xEF, 0x08, 0x7F, 0xA0, 0x24, 0x08, 0xF9, 0x10, 0xDF, 0x0E, 0x50, 0xCF,
  0x0A, 0x60, 0x4F, 0xA0, 0x24, 0x0B, 0xF8, 0x1B, 0x0D, 0xF9, 0x50, 0x9F, 0x0D, 0x60, 0x8F, 0xA0,
  0x34, 0x0E, 0xF8, 0x17, 0x0C, 0xF9, 0x01, 0x40, 0x7F, 0x90, 0x25, 0x0E, 0xFA, 0x05, 0x30, 0x4F,
  0x98, 0x12, 0x0A, 0xF9, 0x02, 0x40, 0x3F, 0x90, 0x94, 0x07, 0xFB, 0x09, 0x30, 0xBF, 0x0C, 0x20,
  0x8F, 0x90, 0x45, 0x0D, 0xF9, 0x82, 0x81, 0x17, 0xFD, 0x81, 0x50, 0x7F, 0x90, 0x62, 0x06, 0xF9,
  0x07, 0x50, 0x8F, 0xFF, 0xFE, 0x0E, 0x30, 0x4F, 0x90, 0x95, 0x02, 0xFF, 0xFF, 0xE0, 0x73, 0x01,
  0xF9, 0x0D, 0x60, 0x9F, 0xFF, 0xFC, 0x0D, 0x50, 0xDF, 0x90, 0x15, 0x02, 0x0E, 0xFF, 0x0C, 0x03,
  0xFF, 0x90, 0x35, 0x09, 0xF9, 0x05, 0x60, 0x5F, 0xE8, 0x2E, 0x20, 0x9F, 0xE0, 0x56, 0x05, 0xF9,
  0x0A, 0x70, 0x7F, 0xC0, 0xD0, 0x23, 0x0B, 0xFC, 0x06, 0x70, 0x1F, 0x90, 0xE7, 0x10, 0x50, 0xEF,
  0x90, 0xB0, 0x15, 0x0B, 0xF9, 0x0C, 0x03, 0x72, 0x0B, 0xF9, 0x06, 0x72, 0x86, 0x6B, 0xDF, 0xED,
  0x94, 0x71, 0x86, 0x4A, 0xDF, 0xED, 0x94, 0x74, 0x05, 0xF9, 0x0D, 0x80, 0xD1, 0x00, 0xEF, 0x90,
  0x58, 0x0D, 0x00, 0x08, 0xF9, 0x0D, 0x80, 0xD0, 0x00, 0x10, 0xEF, 0x90, 0x88, 0x0D, 0x00, 0x07,
  0xFA, 0x04, 0x80, 0xD0, 0x00, 0xEF, 0x90, 0xE0, 0x38, 0x0C, 0x70, 0x04, 0xFA, 0x0E, 0x03, 0x80,
  0xC7, 0x00, 0x8F, 0xA0, 0xE0, 0x57, 0x77, 0x40, 0x60, 0x77, 0x72, 0x0C, 0xFB, 0x0A, 0x01, 0x77,
  0x68, 0x33, 0x9E, 0xF9, 0x77, 0x20, 0x10, 0xDF, 0xB8, 0x1E, 0x82, 0x77, 0x18, 0x14, 0x9E, 0xC0,
  0x97, 0x73, 0x01, 0x0D, 0xFD, 0x83, 0xC8, 0x53, 0x13, 0x84, 0x12, 0x46, 0x9C, 0xF9, 0x09, 0x77,
  0x40, 0x10, 0xDF, 0xFF, 0xFD, 0x09, 0x77, 0x60, 0xAF, 0xFF, 0xFC, 0x09, 0x77, 0x70, 0x50, 0xEF,
  0xFF, 0xFA, 0x09, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xFF, 0x90, 0x87, 0x77, 0x38, 0x12, 0x9E, 0xFF,
  0xFA, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xAF, 0xFC, 0x81, 0xD8, 0x47, 0x77, 0x76, 0x85, 0x35,
  0x8B, 0xCD, 0xEA, 0x86, 0xED, 0xCB, 0x96, 0x41, 0x77, 0x20,
  // "A" (U+0041)
  0x77, 0x30, 0x8F, 0xFA, 0x06, 0x77, 0x77, 0x60, 0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0xFB,
  0x0E, 0x77, 0x77, 0x50, 0x5F, 0xFC, 0x03, 0x77, 0x77, 0x40, 0x9F, 0xFC, 0x08, 0x77, 0x77, 0x40,
  0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xFE, 0x01, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x05, 0x77,
  0x77, 0x20, 0xBF, 0xFE, 0x0A, 0x77, 0x77, 0x2F, 0xFF, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0x0D,
  0xFB, 0x03, 0x77, 0x77, 0x08, 0xFB, 0x00, 0xAF, 0xB0, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0x06, 0xFB,
  0x0B, 0x77, 0x76, 0x01, 0xFC, 0x00, 0x3F, 0xC7, 0x77, 0x60, 0x6F, 0xC2, 0x0E, 0xFB, 0x04, 0x77,
  0x75, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0x97, 0x77, 0x50, 0xEF, 0xB0, 0x82, 0x07, 0xFB, 0x0D,
  0x77, 0x74, 0x03, 0xFC, 0x04, 0x20, 0x3F, 0xC0, 0x27, 0x77, 0x30, 0x7F, 0xC4, 0xFC, 0x06, 0x77,
  0x73, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0, 0xA7, 0x77, 0x20, 0x1F, 0xC0, 0x84, 0x08, 0xFB, 0x0E,
  0x77, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0, 0x47, 0x77, 0x10, 0x9F, 0xC5, 0x01, 0xFC, 0x08,
  0x77, 0x71, 0x0D, 0xFB, 0x0C, 0x60, 0xCF, 0xB0, 0xC7, 0x77, 0x02, 0xFC, 0x08, 0x60, 0x8F, 0xC0,
  0x17, 0x76, 0x06, 0xFC, 0x04, 0x60, 0x5F, 0xC0, 0x57, 0x76, 0x0B, 0xFC, 0x70, 0x1F, 0xC0, 0xA7,
  0x76, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB, 0x0E, 0x77, 0x50, 0x4F, 0xC0, 0x87, 0x10, 0x9F, 0xC0,
  0x37, 0x74, 0x08, 0xFC, 0x04, 0x71, 0x05, 0xFC, 0x07, 0x77, 0x40, 0xCF, 0xC7, 0x20, 0x1F, 0xC0,
  0xB7, 0x73, 0x01, 0xFC, 0x0B, 0x73, 0x0D, 0xFC, 0x77, 0x30, 0x5F, 0xC0, 0x77, 0x30, 0x9F, 0xC0,
  0x57, 0x72, 0x0A, 0xFC, 0x03, 0x73, 0x06, 0xFC, 0x09, 0x77, 0x20, 0xEF, 0xC7, 0x40, 0x2F, 0xC0,
  0xD7, 0x71, 0x03, 0xFC, 0x0B, 0x75, 0x0E, 0xFC, 0x02, 0x77, 0x07, 0xFC, 0x07, 0x75, 0x0A, 0xFC,
  0x06, 0x77, 0x0B, 0xFC, 0x0A, 0x80, 0x90, 0x80, 0xBF, 0xC0, 0xB7, 0x78, 0x0C, 0x1F, 0x0E, 0x76,
  0x04, 0x80, 0xC2, 0xF0, 0x47, 0x50, 0x98, 0x0C, 0x2F, 0x08, 0x75, 0x0D, 0x80, 0xC2, 0xF0, 0xC7,
  0x40, 0x28, 0x0C, 0x4F, 0x01, 0x73, 0x06, 0x80, 0xC4, 0xF0, 0x57, 0x30, 0xA8, 0x0C, 0x4F, 0x0A,
  0x73, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x20, 0x38, 0x0C, 0x6F, 0x03, 0x71, 0x08, 0x80, 0xC6, 0xF0,
  0x77, 0x10, 0xCF, 0xC0, 0x67, 0x74, 0x0A, 0xFC, 0x0C, 0x70, 0x1F, 0xD0, 0x27, 0x74, 0x07, 0xFD,
  0x01, 0x60, 0x5F, 0xC0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0x60, 0x9F, 0xC0, 0xA7, 0x76, 0x0E, 0xFC,
  0x09, 0x60, 0xEF, 0xC0, 0x67, 0x76, 0x0B, 0xFC, 0x0D, 0x50, 0x2F, 0xD0, 0x27, 0x76, 0x07, 0xFD,
  0x02, 0x40, 0x7F, 0xC0, 0xE7, 0x77, 0x03, 0xFD, 0x06, 0x40, 0xBF, 0xC0, 0xA7, 0x77, 0x1F, 0xD0,
  0xB4, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD, 0x30, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x42,
  0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x08, 0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD8, 0x1D,
  0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD, 0x01, 0x06, 0xFD, 0x03, 0x77, 0x73, 0x08, 0xFD, 0x06,
  0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD, 0x0A, 0x0E, 0xFC, 0x0B, 0x77, 0x74, 0x01, 0xFD, 0x0E,
  // "B" (U+0042)
  0x0C, 0xFF, 0xF8, 0x6E, 0xDC, 0xB9, 0x74, 0x17, 0x70, 0xCF, 0xFF, 0xF9, 0x81, 0xC8, 0x37, 0x40,
  0xCF, 0xFF, 0xFC, 0x0C, 0x05, 0x72, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x37, 0x0C, 0x80, 0xC0, 0xF0,
  0x66, 0x0C, 0x80, 0xC1, 0xF0, 0x75, 0x0C, 0x80, 0xC2, 0xF0, 0x54, 0x0C, 0x80, 0xC2, 0xF0, 0xE0,
  0x13, 0x0C, 0x80, 0xC3, 0xF0, 0x83, 0x0C, 0x80, 0xC3, 0xF0, 0xE3, 0x0C, 0xFC, 0x0A, 0x80, 0x48,
  0x81, 0x9B, 0xDF, 0xFB, 0x05, 0x20, 0xCF, 0xC0, 0x57, 0x40, 0x20, 0x8F, 0xF9, 0x09, 0x20, 0xCF,
  0xC0, 0x57, 0x60, 0x20, 0xEF, 0xE0, 0xC2, 0x0C, 0xFC, 0x05, 0x77, 0x04, 0xFE, 0x0E, 0x20, 0xCF,
  0xC0, 0x57, 0x71, 0x0B, 0xFE, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x07, 0xFE, 0x20, 0xCF, 0xC0, 0x57,
  0x71, 0x04, 0xFE, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x03, 0xFD, 0x0E, 0x20, 0xCF, 0xC0, 0x57, 0x71,
  0x03, 0xFD, 0x0D, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x04, 0xFD, 0x0A, 0x20, 0xCF, 0xC0, 0x57, 0x71,
  0x07, 0xFD, 0x07, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x0B, 0xFD, 0x03, 0x20, 0xCF, 0xC0, 0x57, 0x70,
  0x3F, 0xD0, 0xD3, 0x0C, 0xFC, 0x05, 0x76, 0x01, 0x0D, 0xFD, 0x07, 0x30, 0xCF, 0xC0, 0x57, 0x48,
  0x11, 0x7E, 0xFD, 0x0E, 0x40, 0xCF, 0xC0, 0xA8, 0x04, 0x88, 0x19, 0xAD, 0xFF, 0x90, 0x54, 0x0C,
  0x80, 0xC1, 0xF0, 0x85, 0x0C, 0x80, 0xC0, 0xF0, 0x86, 0x0C, 0xFF, 0xFF, 0xE0, 0xE0, 0x57, 0x0C,
  0xFF, 0xFF, 0xC0, 0xD0, 0x77, 0x20, 0xCF, 0xFF, 0xFB, 0x09, 0x74, 0x0C, 0xFF, 0xFF, 0xD0, 0xB0,
  0x47, 0x10, 0xCF, 0xFF, 0xFF, 0x0C, 0x03, 0x60, 0xC8, 0x0C, 0x1F, 0x07, 0x50, 0xC8, 0x0C, 0x2F,
  0x09, 0x40, 0xC8, 0x0C, 0x3F, 0x08, 0x30, 0xCF, 0xC0, 0x57, 0x28, 0x21, 0x36, 0xAF, 0xF9, 0x03,
  0x20, 0xCF, 0xC0, 0x57, 0x60, 0x20, 0xCF, 0xE0, 0xC2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0xDF, 0xE8,
  0x13, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0x3F, 0xE8, 0x19, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0xCF, 0xD8,
  0x1D, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0x8F, 0xE0, 0x10, 0xCF, 0xC0, 0x57, 0x72, 0x05, 0xFE, 0x03,
  0x0C, 0xFC, 0x05, 0x77, 0x20, 0x3F, 0xE0, 0x40, 0xCF, 0xC0, 0x57, 0x72, 0x03, 0xFE, 0x05, 0x0C,
  0xFC, 0x05, 0x77, 0x20, 0x3F, 0xE0, 0x60, 0xCF, 0xC0, 0x57, 0x72, 0x05, 0xFE, 0x05, 0x0C, 0xFC,
  0x05, 0x77, 0x20, 0x7F, 0xE0, 0x40, 0xCF, 0xC0, 0x57, 0x72, 0x0B, 0xFE, 0x02, 0x0C, 0xFC, 0x05,
  0x77, 0x10, 0x2F, 0xF1, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0xAF, 0xE8, 0x1C, 0x0C, 0xFC, 0x05, 0x77,
  0x08, 0xFF, 0x81, 0x80, 0xCF, 0xC0, 0x57, 0x50, 0x30, 0xBF, 0xF9, 0x81, 0x30, 0xCF, 0xC0, 0xA8,
  0x05, 0x88, 0x19, 0xBE, 0xFF, 0xA0, 0xD2, 0x0C, 0x80, 0xC4, 0xF0, 0x52, 0x0C, 0x80, 0xC3, 0xF0,
  0xC3, 0x0C, 0x80, 0xC2, 0xF0, 0xE0, 0x23, 0x0C, 0x80, 0xC2, 0xF0, 0x54, 0x0C, 0x80, 0xC1, 0xF0,
  0x65, 0x0C, 0xFF, 0xFF, 0xF0, 0xE0, 0x56, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x27, 0x0C, 0xFF, 0xFF,
  0xC0, 0xD0, 0x57, 0x20, 0xCF, 0xFF, 0xF9, 0x81, 0xEA, 0x47, 0x40, 0xCF, 0xFF, 0xA8, 0x4E, 0xDB,
  0x96, 0x37, 0x70,
  // "C" (U+0043)
  0x77, 0x71, 0x86, 0x15, 0x79, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xB9, 0x63, 0x77, 0x76, 0x81, 0x49,
  0xDF, 0xFB, 0x81, 0xE9, 0x47, 0x77, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x20, 0x10,
  0x8F, 0xFF, 0xF9, 0x0B, 0x02, 0x76, 0x05, 0x0E, 0xFF, 0xFF, 0xB0, 0x17, 0x50, 0x9F, 0xFF, 0xFC,
  0x09, 0x74, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0x37, 0x30, 0x20, 0xDF, 0xFF, 0xFD, 0x0C, 0x73, 0x02,
  0x0E, 0xFF, 0xFF, 0xE0, 0x67, 0x20, 0x10, 0xDF, 0xFF, 0xFE, 0x0E, 0x73, 0x0B, 0xFF, 0xFF, 0xF0,
  0x97, 0x20, 0x7F, 0xFB, 0x83, 0xD9, 0x63, 0x12, 0x84, 0x12, 0x36, 0x9D, 0xE0, 0x27, 0x10, 0x2F,
  0xFA, 0x0A, 0x03, 0x76, 0x81, 0x27, 0xDA, 0x0B, 0x72, 0x0B, 0xFF, 0x0D, 0x04, 0x77, 0x48, 0x15,
  0xD5, 0x71, 0x03, 0xFF, 0x0C, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xE0, 0xB7, 0x77, 0x73, 0x03, 0xFE,
  0x0D, 0x01, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0x47, 0x77, 0x74, 0x0E, 0xFD, 0x0B, 0x77, 0x77, 0x40,
  0x5F, 0xE0, 0x37, 0x77, 0x74, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x67, 0x77, 0x74,
  0x02, 0xFE, 0x01, 0x77, 0x77, 0x40, 0x6F, 0xD0, 0xD7, 0x77, 0x75, 0x09, 0xFD, 0x09, 0x77, 0x77,
  0x50, 0xCF, 0xD0, 0x67, 0x77, 0x75, 0x0E, 0xFD, 0x04, 0x77, 0x77, 0x5F, 0xE0, 0x17, 0x77, 0x74,
  0x03, 0xFE, 0x77, 0x77, 0x50, 0x4F, 0xD0, 0xE7, 0x77, 0x75, 0x05, 0xFD, 0x0D, 0x77, 0x77, 0x50,
  0x5F, 0xD0, 0xC7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75,
  0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75, 0x06, 0xFD, 0x0C, 0x77, 0x77,
  0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xE7, 0x77, 0x75,
  0x01, 0xFE, 0x02, 0x77, 0x77, 0x5F, 0xE0, 0x57, 0x77, 0x75, 0x0D, 0xFD, 0x08, 0x77, 0x77, 0x50,
  0xBF, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFE, 0x77, 0x77, 0x50, 0x4F, 0xE0, 0x57, 0x77, 0x75, 0xFE,
  0x0B, 0x77, 0x77, 0x50, 0xCF, 0xE0, 0x27, 0x77, 0x74, 0x07, 0xFE, 0x0A, 0x77, 0x77, 0x40, 0x1F,
  0xF0, 0x47, 0x77, 0x74, 0x0B, 0xFE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x5F, 0xF0, 0xD0, 0x27, 0x77,
  0x10, 0x10, 0x67, 0x0D, 0xFF, 0x0E, 0x05, 0x77, 0x58, 0x23, 0x9F, 0xD7, 0x05, 0xFF, 0xA0, 0xB0,
  0x47, 0x78, 0x12, 0x7D, 0xB0, 0xD7, 0x10, 0xCF, 0xFB, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x12, 0x47,
  0xAD, 0xE0, 0xD7, 0x10, 0x38, 0x0C, 0x1F, 0x0D, 0x72, 0x07, 0x80, 0xC0, 0xF0, 0xD7, 0x30, 0xBF,
  0xFF, 0xFF, 0x0D, 0x74, 0x0C, 0xFF, 0xFF, 0xE0, 0xD7, 0x40, 0x10, 0xCF, 0xFF, 0xFD, 0x0D, 0x76,
  0x0A, 0xFF, 0xFF, 0xC0, 0xD7, 0x70, 0x7F, 0xFF, 0xFB, 0x0D, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xF9,
  0x0C, 0x77, 0x30, 0x40, 0xBF, 0xFF, 0xC0, 0xA0, 0x57, 0x76, 0x81, 0x27, 0xCF, 0xFC, 0x82, 0xC9,
  0x51, 0x77, 0x74, 0x8A, 0x01, 0x47, 0x9C, 0xCD, 0xEF, 0xEE, 0xDC, 0xA8, 0x64, 0x17, 0x30,
  // "D" (U+0044)
  0x0E, 0xFF, 0xE8, 0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x60, 0xEF, 0xFF, 0xE8, 0x1D, 0x93, 0x77, 0x30,
  0xEF, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x10, 0xEF, 0xFF, 0xFC, 0x0D, 0x05, 0x76, 0x0E, 0xFF, 0xFF,
  0xE0, 0xB0, 0x17, 0x40, 0xEF, 0xFF, 0xFF, 0x0E, 0x04, 0x73, 0x0E, 0x80, 0xC1, 0xF0, 0x57, 0x20,
  0xE8, 0x0C, 0x2F, 0x06, 0x71, 0x0E, 0x80, 0xC3, 0xF0, 0x57, 0x0E, 0x80, 0xC3, 0xF0, 0xE0, 0x36,
  0x0E, 0xFC, 0x0E, 0x80, 0x38, 0x81, 0x9A, 0xCF, 0xFC, 0x0D, 0x60, 0xEF, 0xC0, 0xE7, 0x40, 0x40,
  0xAF, 0xFA, 0x08, 0x50, 0xEF, 0xC0, 0xE7, 0x60, 0x20, 0xBF, 0xF9, 0x02, 0x40, 0xEF, 0xC0, 0xE7,
  0x71, 0x08, 0xFF, 0x0A, 0x40, 0xEF, 0xC0, 0xE7, 0x72, 0x07, 0xFF, 0x02, 0x30, 0xEF, 0xC0, 0xE7,
  0x73, 0x0A, 0xFE, 0x09, 0x30, 0xEF, 0xC0, 0xE7, 0x73, 0x01, 0x0E, 0xFD, 0x0E, 0x30, 0xEF, 0xC0,
  0xE7, 0x74, 0x07, 0xFE, 0x05, 0x20, 0xEF, 0xC0, 0xE7, 0x75, 0x0E, 0xFD, 0x09, 0x20, 0xEF, 0xC0,
  0xE7, 0x75, 0x09, 0xFD, 0x0D, 0x20, 0xEF, 0xC0, 0xE7, 0x75, 0x04, 0xFE, 0x81, 0x20, 0xEF, 0xC0,
  0xE7, 0x76, 0xFE, 0x81, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x0B, 0xFD, 0x81, 0x80, 0xEF, 0xC0, 0xE7,
  0x76, 0x09, 0xFD, 0x81, 0xB0, 0xEF, 0xC0, 0xE7, 0x76, 0x06, 0xFD, 0x81, 0xD0, 0xEF, 0xC0, 0xE7,
  0x76, 0x04, 0xFD, 0x81, 0xE0, 0xEF, 0xC0, 0xE7, 0x76, 0x02, 0xFE, 0x10, 0xEF, 0xC0, 0xE7, 0x76,
  0x01, 0xFE, 0x02, 0x0E, 0xFC, 0x0E, 0x77, 0x7F, 0xE0, 0x30, 0xEF, 0xC0, 0xE7, 0x77, 0xFE, 0x03,
  0x0E, 0xFC, 0x0E, 0x77, 0x70, 0xEF, 0xD0, 0x40, 0xEF, 0xC0, 0xE7, 0x77, 0x0E, 0xFD, 0x04, 0x0E,
  0xFC, 0x0E, 0x77, 0x70, 0xEF, 0xD0, 0x40, 0xEF, 0xC0, 0xE7, 0x77, 0xFE, 0x03, 0x0E, 0xFC, 0x0E,
  0x77, 0x7F, 0xE0, 0x30, 0xEF, 0xC0, 0xE7, 0x76, 0x01, 0xFE, 0x02, 0x0E, 0xFC, 0x0E, 0x77, 0x60,
  0x2F, 0xE1, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x4F, 0xD8, 0x1E, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x6F,
  0xD8, 0x1D, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x8F, 0xD8, 0x1A, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0xBF,
  0xD8, 0x18, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0xEF, 0xD8, 0x15, 0x0E, 0xFC, 0x0E, 0x77, 0x50, 0x3F,
  0xE8, 0x12, 0x0E, 0xFC, 0x0E, 0x77, 0x50, 0x8F, 0xD0, 0xD2, 0x0E, 0xFC, 0x0E, 0x77, 0x50, 0xDF,
  0xD0, 0x92, 0x0E, 0xFC, 0x0E, 0x77, 0x40, 0x5F, 0xE0, 0x52, 0x0E, 0xFC, 0x0E, 0x77, 0x40, 0xCF,
  0xD0, 0xE3, 0x0E, 0xFC, 0x0E, 0x77, 0x30, 0x6F, 0xE0, 0x93, 0x0E, 0xFC, 0x0E, 0x77, 0x20, 0x20,
  0xEF, 0xE0, 0x33, 0x0E, 0xFC, 0x0E, 0x77, 0x10, 0x10, 0xDF, 0xE0, 0xA4, 0x0E, 0xFC, 0x0E, 0x77,
  0x03, 0x0D, 0xFF, 0x03, 0x40, 0xEF, 0xC0, 0xE7, 0x60, 0x7F, 0xF9, 0x0A, 0x50, 0xEF, 0xC0, 0xE7,
  0x38, 0x13, 0x8E, 0xFF, 0x90, 0xE0, 0x15, 0x0E, 0xFC, 0x0E, 0x80, 0x28, 0x82, 0x9A, 0xCE, 0xFF,
  0xC0, 0x56, 0x0E, 0x80, 0xC3, 0xF0, 0x87, 0x0E, 0x80, 0xC2, 0xF0, 0xB7, 0x10, 0xE8, 0x0C, 0x1F,
  0x0B, 0x72, 0x0E, 0x80, 0xC0, 0xF0, 0xA7, 0x30, 0xEF, 0xFF, 0xFF, 0x07, 0x74, 0x0E, 0xFF, 0xFF,
  0xD0, 0xD0, 0x47, 0x50, 0xEF, 0xFF, 0xFB, 0x0E, 0x08, 0x77, 0x0E, 0xFF, 0xFF, 0x98, 0x1E, 0x81,
  0x77, 0x10, 0xEF, 0xFF, 0xD8, 0x1E, 0xA4, 0x77, 0x40, 0xEF, 0xFD, 0x85, 0xED, 0xCA, 0x86, 0x27,
  0x77,
  // "E" (U+0045)
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F,
  0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81,
  0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50,
  0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  // "F" (U+0046)
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81,
  0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50,
  0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8,
  0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  // "G" (U+0047)
  0x77, 0x71, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x86, 0xEE, 0xCB, 0x97, 0x41, 0x77, 0x76, 0x81, 0x27,
  0xCF, 0xFC, 0x81, 0xD8, 0x47, 0x77, 0x10, 0x50, 0xCF, 0xFF, 0xB8, 0x1E, 0xA4, 0x77, 0x30, 0x40,
  0xDF, 0xFF, 0xF9, 0x0D, 0x06, 0x76, 0x01, 0x0A, 0xFF, 0xFF, 0xD0, 0x27, 0x40, 0x30, 0xEF, 0xFF,
  0xFD, 0x0C, 0x74, 0x06, 0xFF, 0xFF, 0xF0, 0x67, 0x30, 0x6F, 0xFF, 0xFF, 0x0E, 0x73, 0x05, 0x80,
  0xC0, 0xF0, 0x97, 0x20, 0x38, 0x0C, 0x1F, 0x03, 0x71, 0x01, 0x0D, 0x80, 0xC0, 0xF0, 0xC7, 0x20,
  0xAF, 0xFC, 0x83, 0xB7, 0x42, 0x12, 0x84, 0x12, 0x36, 0x9C, 0xE0, 0x67, 0x10, 0x4F, 0xFA, 0x81,
  0xE7, 0x17, 0x68, 0x12, 0x7C, 0xA0, 0xE0, 0x17, 0x10, 0xDF, 0xF9, 0x09, 0x01, 0x77, 0x48, 0x14,
  0xB9, 0x71, 0x05, 0xFF, 0x90, 0x57, 0x77, 0x73, 0x0C, 0xFF, 0x04, 0x77, 0x77, 0x30, 0x4F, 0xF0,
  0x67, 0x77, 0x74, 0x0A, 0xFE, 0x0B, 0x77, 0x77, 0x5F, 0xE0, 0xE0, 0x17, 0x77, 0x74, 0x05, 0xFE,
  0x08, 0x77, 0x77, 0x50, 0xAF, 0xE0, 0x17, 0x77, 0x75, 0x0D, 0xFD, 0x0A, 0x77, 0x77, 0x50, 0x2F,
  0xE0, 0x47, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77, 0x76, 0x0A,
  0xFD, 0x08, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x47, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x77, 0x6F,
  0xE7, 0x77, 0x76, 0x02, 0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF,
  0xFD, 0x0E, 0x03, 0xFD, 0x0C, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60, 0xBF, 0xFD,
  0x0E, 0x04, 0xFD, 0x0B, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60, 0xBF, 0xFD, 0x0E,
  0x03, 0xFD, 0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF, 0xFD, 0x0E, 0x02,
  0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x1F, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x1F, 0xE0, 0x27,
  0x50, 0x68, 0x04, 0x80, 0xEF, 0xB8, 0x1E, 0x0D, 0xFD, 0x05, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x0B,
  0xFD, 0x07, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x09, 0xFD, 0x0A, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x06,
  0xFD, 0x0E, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x03, 0xFE, 0x04, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x0E,
  0xFD, 0x09, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x0A, 0xFD, 0x0E, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x06,
  0xFE, 0x07, 0x77, 0x50, 0xDF, 0xB0, 0xE2, 0x01, 0xFE, 0x0E, 0x01, 0x77, 0x40, 0xDF, 0xB0, 0xE3,
  0x0B, 0xFE, 0x08, 0x77, 0x40, 0xDF, 0xB0, 0xE3, 0x05, 0xFF, 0x03, 0x77, 0x30, 0xDF, 0xB0, 0xE4,
  0x0D, 0xFE, 0x0E, 0x02, 0x77, 0x20, 0xDF, 0xB0, 0xE4, 0x06, 0xFF, 0x0E, 0x03, 0x77, 0x10, 0xDF,
  0xB0, 0xE5, 0x0D, 0xFF, 0x90, 0x77, 0x70, 0xDF, 0xB0, 0xE5, 0x04, 0xFF, 0xA8, 0x1E, 0x72, 0x72,
  0x81, 0x25, 0xEF, 0xB0, 0xE6, 0x0A, 0xFF, 0xC8, 0x7E, 0xB9, 0x88, 0x9A, 0xBE, 0xFE, 0x0E, 0x70,
  0xD8, 0x0C, 0x3F, 0x0E, 0x70, 0x30, 0xE8, 0x0C, 0x2F, 0x0E, 0x71, 0x04, 0x80, 0xC2, 0xF0, 0xE7,
  0x20, 0x58, 0x0C, 0x1F, 0x0E, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0xF0, 0xE7, 0x40, 0x10, 0xAF, 0xFF,
  0xFE, 0x0E, 0x76, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xA7, 0x71, 0x05, 0x0C, 0xFF, 0xFE, 0x81, 0xC7,
  0x17, 0x74, 0x81, 0x38, 0xDF, 0xFE, 0x82, 0xEA, 0x62, 0x77, 0x73, 0x86, 0x14, 0x79, 0xBD, 0xEE,
  0xA8, 0x90, 0xEE, 0xDC, 0xB9, 0x86, 0x41, 0x71,
  // "H" (U+0048)
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E,
  0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E,
  0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0xE0,
  // "I" (U+0049)
  0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF8, 0x2E, 0x9C, 0xEF, 0xFF, 0xFC, 0x81, 0xDC, 0x94, 0x86, 0x23, 0x57, 0x9B,
  0xCE, 0xFF, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x77, 0x20, 0x6F, 0xD0, 0x27, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x20, 0x20, 0x8F, 0xD0, 0x50, 0x17,
  0x68, 0x62, 0x35, 0x79, 0xAC, 0xEF, 0xFC, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x20, 0xC8, 0x0C, 0x0F,
  0x0C, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0xE0,
  // "J" (U+004A)
  0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77,
  0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73,
  0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A,
  0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD,
  0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01,
  0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77,
  0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73,
  0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A,
  0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD,
  0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01,
  0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77,
  0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73,
  0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0A,
  0xFD, 0x01, 0x77, 0x73, 0x0A, 0xFD, 0x01, 0x77, 0x73, 0x0B, 0xFD, 0x77, 0x74, 0x0C, 0xFD, 0x77,
  0x74, 0x0E, 0xFC, 0x0E, 0x77, 0x73, 0x01, 0xFD, 0x0C, 0x77, 0x73, 0x04, 0xFD, 0x0B, 0x77, 0x73,
  0x0A, 0xFD, 0x08, 0x77, 0x72, 0x01, 0xFE, 0x05, 0x77, 0x72, 0x0B, 0xFE, 0x01, 0x77, 0x71, 0x08,
  0xFE, 0x0D, 0x28, 0x23, 0x85, 0x27, 0x71, 0x02, 0x0B, 0xFF, 0x08, 0x20, 0x5B, 0x86, 0xEC, 0xA8,
  0x54, 0x21, 0x38, 0x21, 0x37, 0xBF, 0xFA, 0x02, 0x20, 0x5F, 0xFF, 0xFD, 0x0B, 0x30, 0x5F, 0xFF,
  0xFD, 0x03, 0x30, 0x5F, 0xFF, 0xFC, 0x0A, 0x40, 0x5F, 0xFF, 0xFB, 0x0E, 0x01, 0x40, 0x5F, 0xFF,
  0xFB, 0x03, 0x50, 0x5F, 0xFF, 0xFA, 0x05, 0x60, 0x5F, 0xFF, 0xF0, 0xE0, 0x47, 0x05, 0xFF, 0xFE,
  0x0B, 0x01, 0x71, 0x05, 0xFF, 0xFC, 0x0C, 0x04, 0x73, 0x82, 0x16, 0x9D, 0xFF, 0xD8, 0x1D, 0x83,
  0x77, 0x28, 0x71, 0x36, 0x8A, 0xBD, 0xEE, 0xA8, 0x6E, 0xED, 0xBA, 0x75, 0x17, 0x71,
  // "K" (U+004B)
  0x0E, 0xFC, 0x0C, 0x77, 0x50, 0xAF, 0xE0, 0x90, 0xEF, 0xC0, 0xC7, 0x74, 0x05, 0xFE, 0x81, 0xD0,
  0xEF, 0xC0, 0xC7, 0x73, 0x01, 0x0E, 0xFE, 0x81, 0x30, 0xEF, 0xC0, 0xC7, 0x73, 0x0A, 0xFE, 0x07,
  0x20, 0xEF, 0xC0, 0xC7, 0x72, 0x05, 0xFE, 0x0C, 0x30, 0xEF, 0xC0, 0xC7, 0x71, 0x01, 0x0E, 0xFD,
  0x0E, 0x02, 0x30, 0xEF, 0xC0, 0xC7, 0x71, 0x0A, 0xFE, 0x06, 0x40, 0xEF, 0xC0, 0xC7, 0x70, 0x5F,
  0xE0, 0xA5, 0x0E, 0xFC, 0x0C, 0x76, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x50, 0xEF, 0xC0, 0xC7, 0x60,
  0xAF, 0xE0, 0x46, 0x0E, 0xFC, 0x0C, 0x75, 0x04, 0xFE, 0x09, 0x70, 0xEF, 0xC0, 0xC7, 0x40, 0x10,
  0xDF, 0xD0, 0xD7, 0x10, 0xEF, 0xC0, 0xC7, 0x40, 0x9F, 0xE0, 0x37, 0x10, 0xEF, 0xC0, 0xC7, 0x30,
  0x4F, 0xE0, 0x87, 0x20, 0xEF, 0xC0, 0xC7, 0x30, 0xDF, 0xD0, 0xC7, 0x30, 0xEF, 0xC0, 0xC7, 0x20,
  0x9F, 0xD0, 0xE0, 0x27, 0x30, 0xEF, 0xC0, 0xC7, 0x10, 0x4F, 0xE0, 0x67, 0x40, 0xEF, 0xC0, 0xC7,
  0x10, 0xDF, 0xD0, 0xB7, 0x50, 0xEF, 0xC0, 0xC7, 0x09, 0xFD, 0x0E, 0x01, 0x75, 0x0E, 0xFC, 0x0C,
  0x60, 0x3F, 0xE0, 0x57, 0x60, 0xEF, 0xC0, 0xC6, 0x0D, 0xFD, 0x09, 0x77, 0x0E, 0xFC, 0x0C, 0x50,
  0x8F, 0xD0, 0xD7, 0x71, 0x0E, 0xFC, 0x0C, 0x40, 0x3F, 0xE0, 0x37, 0x71, 0x0E, 0xFC, 0x0C, 0x40,
  0xCF, 0xD0, 0x87, 0x72, 0x0E, 0xFC, 0x0C, 0x30, 0x7F, 0xD0, 0xC7, 0x73, 0x0E, 0xFC, 0x0C, 0x20,
  0x10, 0xEF, 0xD0, 0x27, 0x73, 0x0E, 0xFC, 0x0C, 0x20, 0xAF, 0xD0, 0x77, 0x74, 0x0E, 0xFC, 0x81,
  0xC0, 0x3F, 0xD0, 0xB7, 0x75, 0x0E, 0xFC, 0x81, 0xC0, 0xBF, 0xC0, 0xE0, 0x17, 0x75, 0x0E, 0xFC,
  0x0C, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xC0, 0x0D, 0xFE, 0x07, 0x77, 0x50, 0xEF, 0xFF, 0xD0,
  0xE0, 0x17, 0x74, 0x0E, 0xFF, 0xFE, 0x09, 0x77, 0x40, 0xEF, 0xFF, 0xF0, 0x37, 0x73, 0x0E, 0xFF,
  0xFF, 0x0B, 0x77, 0x30, 0xEF, 0xFF, 0xF9, 0x05, 0x77, 0x20, 0xEF, 0xFF, 0xF9, 0x0D, 0x77, 0x20,
  0xEF, 0xFF, 0xFA, 0x07, 0x77, 0x10, 0xEF, 0xFA, 0x0C, 0x0A, 0xFD, 0x0E, 0x01, 0x77, 0x0E, 0xFF,
  0x98, 0x1C, 0x11, 0xFE, 0x09, 0x77, 0x0E, 0xFF, 0x0B, 0x30, 0x8F, 0xE0, 0x27, 0x60, 0xEF, 0xE0,
  0x94, 0x01, 0x0E, 0xFD, 0x0B, 0x76, 0x0E, 0xFD, 0x08, 0x60, 0x7F, 0xE0, 0x47, 0x50, 0xEF, 0xC0,
  0xD7, 0x10, 0xDF, 0xD0, 0xC7, 0x50, 0xEF, 0xC0, 0xC7, 0x10, 0x6F, 0xE0, 0x67, 0x40, 0xEF, 0xC0,
  0xC7, 0x20, 0xDF, 0xD0, 0xE7, 0x40, 0xEF, 0xC0, 0xC7, 0x20, 0x5F, 0xE0, 0x87, 0x30, 0xEF, 0xC0,
  0xC7, 0x30, 0xCF, 0xE0, 0x27, 0x20, 0xEF, 0xC0, 0xC7, 0x30, 0x3F, 0xE0, 0xA7, 0x20, 0xEF, 0xC0,
  0xC7, 0x40, 0xBF, 0xE0, 0x37, 0x10, 0xEF, 0xC0, 0xC7, 0x40, 0x2F, 0xE0, 0xC7, 0x10, 0xEF, 0xC0,
  0xC7, 0x50, 0x9F, 0xE0, 0x57, 0x0E, 0xFC, 0x0C, 0x75, 0x01, 0xFE, 0x0D, 0x70, 0xEF, 0xC0, 0xC7,
  0x60, 0x8F, 0xE0, 0x76, 0x0E, 0xFC, 0x0C, 0x76, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x50, 0xEF, 0xC0,
  0xC7, 0x70, 0x7F, 0xE0, 0x95, 0x0E, 0xFC, 0x0C, 0x77, 0x10, 0xDF, 0xE0, 0x24, 0x0E, 0xFC, 0x0C,
  0x77, 0x10, 0x6F, 0xE0, 0xB4, 0x0E, 0xFC, 0x0C, 0x77, 0x20, 0xDF, 0xE0, 0x43, 0x0E, 0xFC, 0x0C,
  0x77, 0x20, 0x5F, 0xE0, 0xD3, 0x0E, 0xFC, 0x0C, 0x77, 0x30, 0xCF, 0xE0, 0x62, 0x0E, 0xFC, 0x0C,
  0x77, 0x30, 0x3F, 0xE8, 0x2E, 0x10, 0xEF, 0xC0, 0xC7, 0x74, 0x0B, 0xFE, 0x81, 0x80, 0xEF, 0xC0,
  0xC7, 0x74, 0x02, 0xFF, 0x02,
  // "L" (U+004C)
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2,
  0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E,
  0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F,
  0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A,
  // "M" (U+004D)
  0x06, 0xFF, 0xB0, 0x47, 0x40, 0x8F, 0xFA, 0x04, 0x06, 0xFF, 0xB0, 0x77, 0x40, 0xAF, 0xFA, 0x04,
  0x06, 0xFF, 0xB0, 0x97, 0x40, 0xDF, 0xFA, 0x04, 0x06, 0xFF, 0xB0, 0xB7, 0x4F, 0xFB, 0x04, 0x06,
  0xFF, 0xB0, 0xE7, 0x30, 0x3F, 0xFB, 0x04, 0x06, 0xFF, 0xC7, 0x30, 0x6F, 0xFB, 0x04, 0x06, 0xFF,
  0xC0, 0x37, 0x20, 0x9F, 0xFB, 0x04, 0x06, 0xFF, 0xC0, 0x57, 0x20, 0xBF, 0xFB, 0x04, 0x06, 0xFF,
  0xC0, 0x77, 0x20, 0xEF, 0xFB, 0x04, 0x06, 0xFF, 0xC0, 0xA7, 0x10, 0x1F, 0xFC, 0x04, 0x06, 0xFF,
  0xC0, 0xC7, 0x10, 0x4F, 0xFC, 0x04, 0x06, 0xFF, 0xC0, 0xE7, 0x10, 0x7F, 0x90, 0xDF, 0xA0, 0x40,
  0x6F, 0xA0, 0x8F, 0xA0, 0x17, 0x0A, 0xF0, 0xC0, 0x8F, 0xA0, 0x40, 0x6F, 0xA0, 0x4F, 0xA0, 0x47,
  0x0C, 0xF0, 0x09, 0xFA, 0x04, 0x06, 0xFA, 0x03, 0x0E, 0xF9, 0x06, 0x7F, 0x90, 0x70, 0xAF, 0xA0,
  0x40, 0x6F, 0xA0, 0x40, 0xCF, 0x90, 0x86, 0x02, 0xF9, 0x04, 0x0B, 0xFA, 0x04, 0x06, 0xFA, 0x06,
  0x09, 0xF9, 0x0B, 0x60, 0x5F, 0x90, 0x10, 0xCF, 0xA0, 0x40, 0x6F, 0xA0, 0x70, 0x6F, 0x90, 0xD6,
  0x08, 0xF8, 0x1E, 0x0D, 0xFA, 0x04, 0x06, 0xFA, 0x08, 0x03, 0xFA, 0x60, 0xBF, 0x81, 0xB0, 0xEF,
  0xA0, 0x40, 0x6F, 0xA0, 0xA1, 0xFA, 0x02, 0x50, 0xDF, 0x09, 0x1F, 0xB0, 0x40, 0x6F, 0xA8, 0x1B,
  0x0C, 0xF9, 0x04, 0x40, 0x1F, 0x90, 0x61, 0xFB, 0x04, 0x06, 0xFA, 0x81, 0xC0, 0x9F, 0x90, 0x74,
  0x03, 0xF9, 0x03, 0x01, 0xFB, 0x04, 0x06, 0xFA, 0x81, 0xD0, 0x6F, 0x90, 0x94, 0x06, 0xF9, 0x10,
  0x2F, 0xB0, 0x40, 0x6F, 0xA8, 0x1E, 0x03, 0xF9, 0x0B, 0x40, 0x9F, 0x81, 0xD0, 0x3F, 0xB0, 0x40,
  0x6F, 0xB2, 0xF9, 0x0E, 0x40, 0xCF, 0x81, 0xA0, 0x4F, 0xB0, 0x40, 0x6F, 0xB8, 0x11, 0x0D, 0xF9,
  0x01, 0x30, 0xEF, 0x81, 0x80, 0x5F, 0xB0, 0x40, 0x6F, 0xB8, 0x12, 0x0A, 0xF9, 0x03, 0x20, 0x2F,
  0x98, 0x15, 0x06, 0xFB, 0x04, 0x06, 0xFB, 0x81, 0x30, 0x7F, 0x90, 0x52, 0x04, 0xF9, 0x81, 0x20,
  0x7F, 0xB0, 0x40, 0x6F, 0xB8, 0x15, 0x04, 0xF9, 0x08, 0x20, 0x7F, 0x92, 0x08, 0xFB, 0x04, 0x06,
  0xFB, 0x81, 0x60, 0x1F, 0x90, 0xA2, 0x0A, 0xF0, 0xC2, 0x09, 0xFB, 0x04, 0x06, 0xFB, 0x07, 0x20,
  0xDF, 0x0C, 0x20, 0xDF, 0x0A, 0x20, 0xAF, 0xB0, 0x40, 0x6F, 0xB0, 0x82, 0x0A, 0xF9, 0x2F, 0x90,
  0x72, 0x0B, 0xFB, 0x04, 0x06, 0xFB, 0x09, 0x20, 0x7F, 0x90, 0x10, 0x3F, 0x90, 0x42, 0x0C, 0xFB,
  0x04, 0x06, 0xFB, 0x0A, 0x20, 0x4F, 0x90, 0x40, 0x5F, 0x90, 0x12, 0x0C, 0xFB, 0x04, 0x06, 0xFB,
  0x0B, 0x20, 0x1F, 0x90, 0x60, 0x8F, 0x0E, 0x30, 0xDF, 0xB0, 0x40, 0x6F, 0xB0, 0xB3, 0x0E, 0xF0,
  0x80, 0xBF, 0x0B, 0x30, 0xEF, 0xB0, 0x40, 0x6F, 0xB0, 0xC3, 0x0B, 0xF0, 0xD0, 0xEF, 0x09, 0x3F,
  0xC0, 0x40, 0x6F, 0xB0, 0xD3, 0x08, 0xFF, 0xA0, 0x63, 0xFC, 0x04, 0x06, 0xFB, 0x0E, 0x30, 0x5F,
  0xFA, 0x03, 0x20, 0x1F, 0xC0, 0x40, 0x6F, 0xC3, 0x02, 0xFF, 0xA0, 0x12, 0x02, 0xFC, 0x04, 0x06,
  0xFC, 0x40, 0xEF, 0xF0, 0xD3, 0x02, 0xFC, 0x04, 0x06, 0xFC, 0x01, 0x30, 0xBF, 0xF0, 0xB3, 0x03,
  0xFC, 0x04, 0x06, 0xFC, 0x01, 0x30, 0x8F, 0xF0, 0x83, 0x03, 0xFC, 0x04, 0x06, 0xFC, 0x02, 0x30,
  0x5F, 0xF0, 0x53, 0x04, 0xFC, 0x04, 0x06, 0xFC, 0x02, 0x30, 0x2F, 0xF0, 0x23, 0x04, 0xFC, 0x04,
  0x06, 0xFC, 0x03, 0x40, 0xEF, 0xE4, 0x05, 0xFC, 0x04, 0x06, 0xFC, 0x03, 0x40, 0xCF, 0xD0, 0xC4,
  0x05, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x40, 0x9F, 0xD0, 0xA4, 0x05, 0xFC, 0x04, 0x06, 0xFC, 0x04,
  0x40, 0x6F, 0xD0, 0x74, 0x05, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06,
  0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x06, 0xFC, 0x04, 0x77, 0x71, 0x06, 0xFC, 0x04,
  // "N" (U+004E)
  0x0E, 0xFF, 0xA0, 0xE7, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04, 0x77, 0x10, 0xAF, 0xB0, 0x0E,
  0xFF, 0xB0, 0x97, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF,
  0xC0, 0x37, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0xD7,
  0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x87, 0x60, 0xAF,
  0xB0, 0x0E, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x37, 0x50, 0xAF, 0xB0, 0x0E,
  0xFF, 0xE0, 0x87, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xD7, 0x50, 0xAF, 0xB0, 0x0E,
  0xFA, 0x0C, 0x09, 0xFB, 0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xD0, 0x4F, 0xB0, 0x87, 0x40,
  0xAF, 0xB0, 0x0E, 0xFA, 0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF, 0xB0, 0x0E, 0xFB, 0x10, 0x9F,
  0xB0, 0x27, 0x30, 0xAF, 0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07, 0x73, 0x0A, 0xFB, 0x00, 0xEF,
  0xB8, 0x12, 0x0E, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x09, 0xFB, 0x02, 0x72,
  0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x42,
  0x0E, 0xFA, 0x0C, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09, 0xFB, 0x02, 0x71, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0x52, 0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x63, 0x0E, 0xFA,
  0x0C, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02, 0x70, 0xAF, 0xB0, 0x0E, 0xFB,
  0x07, 0x30, 0x4F, 0xB0, 0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84, 0x0E, 0xFA, 0x0C, 0x70, 0xAF,
  0xB0, 0x0E, 0xFB, 0x08, 0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x94, 0x05, 0xFB,
  0x06, 0x60, 0xAF, 0xB0, 0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6, 0x0A, 0xFB, 0x00, 0xEF, 0xB0,
  0xA5, 0x0A, 0xFB, 0x01, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50, 0x5F, 0xB0, 0x65, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0xA6, 0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x60, 0xAF, 0xB0,
  0x14, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A,
  0x7F, 0xB0, 0xB4, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB, 0x01, 0x30, 0x9F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x70, 0x5F, 0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x1F, 0xB0, 0xB3, 0x08,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10,
  0x5F, 0xB0, 0x52, 0x07, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0, 0xA2, 0x06, 0xFB, 0x00, 0xEF,
  0xB0, 0xA7, 0x20, 0xBF, 0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x5F, 0xB8, 0x15, 0x05,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30,
  0xBF, 0xA8, 0x1E, 0x04, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F, 0xB0, 0x50, 0x3F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x73, 0x01, 0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0xBF, 0xA0, 0xE0,
  0x2F, 0xB0, 0x0E, 0xFB, 0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0x1F,
  0xB0, 0xBF, 0xB0, 0x0E, 0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x06, 0xFF,
  0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x76, 0x0B, 0xFF, 0xD0, 0x0E,
  0xFB, 0x0A, 0x76, 0x06, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A,
  0x77, 0x0B, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x01,
  0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x71, 0x07, 0xFF,
  0xB0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0x1F, 0xFB, 0x0E,
  // "O" (U+004F)
  0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x77, 0x50, 0x50, 0xBF, 0xFA,
  0x0B, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0xB0,
  0xD0, 0x47, 0x77, 0x07, 0xFF, 0xFF, 0x08, 0x77, 0x50, 0x9F, 0xFF, 0xFA, 0x0A, 0x77, 0x30, 0xAF,
  0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x7F, 0xFF, 0xFE, 0x07, 0x76, 0x03, 0x80, 0xC0, 0xF0, 0x37, 0x50,
  0xD8, 0x0C, 0x0F, 0x0D, 0x74, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x20, 0x10, 0xEF, 0xF9, 0x81, 0x94,
  0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x71, 0x08, 0xFF, 0x0B, 0x02, 0x71, 0x02, 0x0B, 0xFF,
  0x07, 0x71, 0x0E, 0xFE, 0x0A, 0x75, 0x0A, 0xFE, 0x0E, 0x70, 0x5F, 0xE0, 0xC7, 0x70, 0xCF, 0xE0,
  0x56, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x50, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01,
  0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09,
  0x40, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x30, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01,
  0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20, 0x7F, 0xD0, 0xC7, 0x76, 0x0B, 0xFD, 0x07,
  0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20, 0xCF, 0xD0, 0x77, 0x76, 0x07, 0xFD, 0x0B,
  0x20, 0xEF, 0xD0, 0x57, 0x76, 0x04, 0xFD, 0x0D, 0x2F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x10, 0x1F,
  0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x3F, 0xE7,
  0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD,
  0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00,
  0x4F, 0xD0, 0xE7, 0x77, 0x1F, 0xE0, 0x40, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x03, 0x02, 0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE,
  0x01, 0x1F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x47, 0x76, 0x05, 0xFD, 0x0E, 0x20,
  0xCF, 0xD0, 0x67, 0x76, 0x07, 0xFD, 0x0B, 0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20,
  0x7F, 0xD0, 0xB7, 0x76, 0x0C, 0xFD, 0x07, 0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20,
  0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01, 0x30, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x40,
  0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09, 0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40,
  0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01, 0x50, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB6, 0x05,
  0xFE, 0x0B, 0x77, 0x0C, 0xFE, 0x05, 0x70, 0xEF, 0xE0, 0x97, 0x50, 0x9F, 0xE0, 0xE7, 0x10, 0x8F,
  0xF0, 0xB0, 0x17, 0x10, 0x10, 0xBF, 0xF0, 0x77, 0x10, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81,
  0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x40, 0xD8, 0x0C, 0x0F, 0x0D,
  0x75, 0x04, 0x80, 0xC0, 0xF0, 0x47, 0x60, 0x7F, 0xFF, 0xFE, 0x07, 0x77, 0x10, 0xAF, 0xFF, 0xFC,
  0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFA, 0x0A, 0x77, 0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x77, 0x04, 0x0D,
  0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x70, 0x50, 0xBF,
  0xFA, 0x0B, 0x05, 0x77, 0x77, 0x58, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x40,
  // "P" (U+0050)
  0x0C, 0xFF, 0xF9, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x70, 0xCF, 0xFF, 0xF9, 0x81, 0xD9, 0x37, 0x40,
  0xCF, 0xFF, 0xFC, 0x0C, 0x05, 0x72, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0x27, 0x0C, 0xFF, 0xFF, 0xF0,
  0xE0, 0x46, 0x0C, 0x80, 0xC1, 0xF0, 0x55, 0x0C, 0x80, 0xC2, 0xF0, 0x44, 0x0C, 0x80, 0xC2, 0xF0,
  0xE0, 0x13, 0x0C, 0x80, 0xC3, 0xF0, 0xA3, 0x0C, 0x80, 0xC4, 0xF0, 0x32, 0x0C, 0xFC, 0x0E, 0x80,
  0x58, 0x81, 0x9B, 0xEF, 0xFA, 0x0A, 0x20, 0xCF, 0xC0, 0xC7, 0x50, 0x30, 0xBF, 0xF9, 0x81, 0x10,
  0xCF, 0xC0, 0xC7, 0x70, 0x6F, 0xF8, 0x16, 0x0C, 0xFC, 0x0C, 0x77, 0x10, 0x6F, 0xE8, 0x1A, 0x0C,
  0xFC, 0x0C, 0x77, 0x20, 0xBF, 0xD8, 0x1D, 0x0C, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xE0, 0x10, 0xCF,
  0xC0, 0xC7, 0x73, 0xFE, 0x03, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0xCF, 0xD0, 0x40, 0xCF, 0xC0, 0xC7,
  0x73, 0x0A, 0xFD, 0x05, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0x9F, 0xD0, 0x60, 0xCF, 0xC0, 0xC7, 0x73,
  0x09, 0xFD, 0x05, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0xAF, 0xD0, 0x50, 0xCF, 0xC0, 0xC7, 0x73, 0x0B,
  0xFD, 0x04, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0xEF, 0xD0, 0x20, 0xCF, 0xC0, 0xC7, 0x72, 0x03, 0xFE,
  0x10, 0xCF, 0xC0, 0xC7, 0x72, 0x0A, 0xFD, 0x81, 0xD0, 0xCF, 0xC0, 0xC7, 0x71, 0x04, 0xFE, 0x81,
  0x90, 0xCF, 0xC0, 0xC7, 0x70, 0x20, 0xEF, 0xE8, 0x15, 0x0C, 0xFC, 0x0C, 0x76, 0x04, 0x0E, 0xFF,
  0x81, 0x10, 0xCF, 0xC0, 0xC7, 0x40, 0x40, 0xBF, 0xF9, 0x0A, 0x20, 0xCF, 0xC0, 0xE8, 0x03, 0x88,
  0x19, 0xAC, 0xFF, 0xC0, 0x42, 0x0C, 0x80, 0xC3, 0xF0, 0xB3, 0x0C, 0x80, 0xC3, 0xF0, 0x23, 0x0C,
  0x80, 0xC2, 0xF0, 0x74, 0x0C, 0x80, 0xC1, 0xF0, 0xA5, 0x0C, 0x80, 0xC0, 0xF0, 0xA6, 0x0C, 0xFF,
  0xFF, 0xF0, 0x87, 0x0C, 0xFF, 0xFF, 0xD0, 0xD0, 0x47, 0x10, 0xCF, 0xFF, 0xFB, 0x0D, 0x07, 0x73,
  0x0C, 0xFF, 0xFF, 0x81, 0xEA, 0x57, 0x50, 0xCF, 0xFF, 0x85, 0xED, 0xCA, 0x86, 0x37, 0x71, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30,
  0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77,
  0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7,
  0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30,
  // "Q" (U+0051)
  0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x77, 0x50, 0x50, 0xBF, 0xFA,
  0x0B, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0xB0,
  0xD0, 0x47, 0x77, 0x07, 0xFF, 0xFF, 0x08, 0x77, 0x50, 0x9F, 0xFF, 0xFA, 0x09, 0x77, 0x30, 0xAF,
  0xFF, 0xFC, 0x09, 0x77, 0x10, 0x7F, 0xFF, 0xFE, 0x07, 0x76, 0x03, 0x80, 0xC0, 0xF0, 0x37, 0x50,
  0xD8, 0x0C, 0x0F, 0x0D, 0x74, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x20, 0x10, 0xEF, 0xF9, 0x81, 0x94,
  0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x71, 0x08, 0xFF, 0x0B, 0x02, 0x71, 0x02, 0x0B, 0xFF,
  0x07, 0x71, 0x0E, 0xFE, 0x0A, 0x75, 0x0A, 0xFE, 0x0E, 0x70, 0x5F, 0xE0, 0xC7, 0x70, 0xCF, 0xE0,
  0x56, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x50, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01,
  0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09,
  0x40, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x30, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01,
  0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20, 0x7F, 0xD0, 0xC7, 0x76, 0x0B, 0xFD, 0x07,
  0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20, 0xCF, 0xD0, 0x77, 0x76, 0x07, 0xFD, 0x0B,
  0x20, 0xEF, 0xD0, 0x57, 0x76, 0x04, 0xFD, 0x0D, 0x2F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x10, 0x1F,
  0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x3F, 0xE7,
  0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD,
  0x03, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0,
  0x04, 0xFD, 0x0E, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x00, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0,
  0x11, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD, 0x04, 0x77, 0x60, 0x5F, 0xD0, 0xD2, 0x0C,
  0xFD, 0x06, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0xA2, 0x07,
  0xFD, 0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x82, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01,
  0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xE4, 0x0A,
  0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0xB4, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x64, 0x01,
  0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0C, 0x60, 0x5F,
  0xE0, 0xB7, 0x70, 0xCF, 0xE0, 0x77, 0x0E, 0xFE, 0x09, 0x75, 0x09, 0xFF, 0x01, 0x70, 0x8F, 0xF0,
  0xB0, 0x17, 0x10, 0x10, 0xBF, 0xF0, 0x97, 0x10, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14,
  0x9F, 0xFA, 0x02, 0x72, 0x07, 0x80, 0xC2, 0xF0, 0x97, 0x40, 0xD8, 0x0C, 0x0F, 0x0E, 0x01, 0x74,
  0x04, 0x80, 0xC0, 0xF0, 0x57, 0x60, 0x7F, 0xFF, 0xFE, 0x09, 0x77, 0x10, 0xAF, 0xFF, 0xFC, 0x0A,
  0x77, 0x30, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x77, 0x04, 0x0D, 0xFF,
  0xFB, 0x0E, 0x04, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xF9, 0x0D, 0x77, 0x76, 0x05, 0x0B, 0xFF, 0xF0,
  0x67, 0x77, 0x71, 0x84, 0x47, 0xAC, 0xDE, 0xFF, 0x0E, 0x80, 0xC1, 0x00, 0xAF, 0xD0, 0x78, 0x0C,
  0x00, 0x02, 0xFD, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0xAF, 0xD0, 0x98, 0x0C, 0x00, 0x03, 0xFE, 0x02,
  0x80, 0xC0, 0x00, 0xAF, 0xD0, 0xA8, 0x0C, 0x00, 0x03, 0xFE, 0x03, 0x80, 0xC0, 0x00, 0xBF, 0xD0,
  0xB8, 0x0C, 0x00, 0x03, 0xFE, 0x04, 0x80, 0xC0, 0x00, 0xBF, 0xD0, 0xC8, 0x0C, 0x00, 0x03, 0xFE,
  0x05, 0x80, 0xC0, 0x00, 0xBF, 0xD0, 0xD8, 0x0C, 0x00, 0x03, 0xFE, 0x06, 0x80, 0xC0, 0x00, 0xBF,
  0xD0, 0xE8, 0x0C, 0x00, 0x03, 0xFE, 0x08, 0x80, 0xC0, 0x00, 0xBF, 0xD0, 0xE0, 0x17, 0x77, 0x77,
  0x02, 0x80, 0x91, 0x70, 0x32,
  // "R" (U+0052)
  0x0C, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x60, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x30,
  0xCF, 0xFF, 0xF8, 0x1E, 0x81, 0x77, 0x0C, 0xFF, 0xFF, 0xB0, 0x87, 0x60, 0xCF, 0xFF, 0xFC, 0x0D,
  0x02, 0x74, 0x0C, 0xFF, 0xFF, 0xD0, 0xE0, 0x47, 0x30, 0xCF, 0xFF, 0xFF, 0x04, 0x72, 0x0C, 0xFF,
  0xFF, 0xF0, 0xE0, 0x27, 0x10, 0xC8, 0x0C, 0x0F, 0x0C, 0x71, 0x0C, 0x80, 0xC1, 0xF0, 0x77, 0x0C,
  0xFD, 0x86, 0xA8, 0x88, 0x89, 0xAD, 0xFF, 0xB0, 0xE7, 0x0C, 0xFD, 0x03, 0x71, 0x05, 0x0B, 0xFF,
  0x90, 0x66, 0x0C, 0xFD, 0x03, 0x73, 0x04, 0x0E, 0xFE, 0x0C, 0x60, 0xCF, 0xD0, 0x37, 0x40, 0x20,
  0xEF, 0xE0, 0x15, 0x0C, 0xFD, 0x03, 0x75, 0x06, 0xFE, 0x04, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0xEF,
  0xD0, 0x75, 0x0C, 0xFD, 0x03, 0x76, 0x0A, 0xFD, 0x09, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x7F, 0xD0,
  0xB5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x5F, 0xD0, 0xC5,
  0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x8F, 0xD0, 0xA5, 0x0C,
  0xFD, 0x03, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0xEF, 0xD0, 0x55, 0x0C, 0xFD,
  0x03, 0x75, 0x07, 0xFE, 0x02, 0x50, 0xCF, 0xD0, 0x37, 0x40, 0x20, 0xEF, 0xD0, 0xE6, 0x0C, 0xFD,
  0x03, 0x73, 0x01, 0x0D, 0xFE, 0x08, 0x60, 0xCF, 0xD0, 0x37, 0x20, 0x50, 0xEF, 0xF0, 0x36, 0x0C,
  0xFD, 0x03, 0x48, 0x31, 0x25, 0x8D, 0xFF, 0x90, 0xA7, 0x0C, 0x80, 0xC1, 0xF0, 0x27, 0x0C, 0x80,
  0xC0, 0xF0, 0x77, 0x10, 0xCF, 0xFF, 0xFF, 0x0A, 0x72, 0x0C, 0xFF, 0xFF, 0xE0, 0xB7, 0x30, 0xCF,
  0xFF, 0xFD, 0x0B, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x87, 0x50, 0xCF, 0xFF, 0xFA, 0x0D, 0x04, 0x76,
  0x0C, 0xFF, 0xFF, 0x90, 0x67, 0x71, 0x0C, 0xFF, 0xFF, 0x90, 0x57, 0x71, 0x0C, 0xFF, 0xFF, 0x90,
  0xD7, 0x71, 0x0C, 0xFD, 0x84, 0xA8, 0x88, 0x8B, 0xFD, 0x07, 0x77, 0x0C, 0xFD, 0x03, 0x40, 0x1F,
  0xD0, 0xE0, 0x17, 0x60, 0xCF, 0xD0, 0x35, 0x08, 0xFD, 0x0A, 0x76, 0x0C, 0xFD, 0x03, 0x50, 0x10,
  0xEF, 0xD0, 0x37, 0x50, 0xCF, 0xD0, 0x36, 0x07, 0xFD, 0x0C, 0x75, 0x0C, 0xFD, 0x03, 0x70, 0xDF,
  0xD0, 0x57, 0x40, 0xCF, 0xD0, 0x37, 0x05, 0xFD, 0x0E, 0x74, 0x0C, 0xFD, 0x03, 0x71, 0x0C, 0xFD,
  0x08, 0x73, 0x0C, 0xFD, 0x03, 0x71, 0x03, 0xFE, 0x02, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x0B, 0xFD,
  0x0A, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x02, 0xFE, 0x04, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x09, 0xFD,
  0x0C, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0x0E, 0xFD, 0x06, 0x70, 0xCF, 0xD0, 0x37, 0x40, 0x7F,
  0xD0, 0xE0, 0x16, 0x0C, 0xFD, 0x03, 0x75, 0x0E, 0xFD, 0x09, 0x60, 0xCF, 0xD0, 0x37, 0x50, 0x6F,
  0xE0, 0x25, 0x0C, 0xFD, 0x03, 0x76, 0x0D, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x4F, 0xE0,
  0x54, 0x0C, 0xFD, 0x03, 0x77, 0x0B, 0xFD, 0x0D, 0x40, 0xCF, 0xD0, 0x37, 0x70, 0x3F, 0xE0, 0x73,
  0x0C, 0xFD, 0x03, 0x77, 0x10, 0xAF, 0xD0, 0xE0, 0x12, 0x0C, 0xFD, 0x03, 0x77, 0x10, 0x2F, 0xE0,
  0x92, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x8F, 0xE8, 0x13, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x10, 0xEF,
  0xD8, 0x1C, 0x0C, 0xFD, 0x03, 0x77, 0x30, 0x7F, 0xE0, 0x50,
  // "S" (U+0053)
  0x77, 0x18, 0x44, 0x79, 0xBD, 0xEB, 0x86, 0xED, 0xCA, 0x97, 0x42, 0x77, 0x71, 0x81, 0x16, 0xBF,
  0xFC, 0x82, 0xEC, 0x84, 0x77, 0x28, 0x11, 0x9E, 0xFF, 0xFC, 0x0A, 0x04, 0x75, 0x07, 0xFF, 0xFF,
  0xA8, 0x1E, 0x81, 0x70, 0x10, 0xCF, 0xFF, 0xFD, 0x0A, 0x60, 0x20, 0xEF, 0xFF, 0xFE, 0x04, 0x50,
  0x10, 0xEF, 0xFF, 0xFE, 0x0D, 0x60, 0xBF, 0xFF, 0xFF, 0x08, 0x50, 0x68, 0x0C, 0x0F, 0x02, 0x50,
  0xDF, 0xFF, 0xFF, 0x0B, 0x50, 0x5F, 0xFB, 0x85, 0xC9, 0x98, 0x9A, 0xCF, 0xD0, 0x55, 0x0A, 0xFF,
  0x0D, 0x05, 0x72, 0x82, 0x36, 0xAE, 0xE0, 0xE6, 0x0E, 0xFE, 0x0B, 0x77, 0x10, 0x50, 0xAC, 0x08,
  0x50, 0x2F, 0xE0, 0xD7, 0x74, 0x83, 0x18, 0xEF, 0x25, 0x04, 0xFE, 0x06, 0x77, 0x70, 0x56, 0x05,
  0xFE, 0x01, 0x77, 0x77, 0x06, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD0, 0xD7, 0x77, 0x71, 0x05,
  0xFD, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xE0, 0x17, 0x77, 0x70, 0x2F, 0xE0, 0x67, 0x77, 0x71, 0xFE,
  0x0E, 0x01, 0x77, 0x77, 0x0B, 0xFE, 0x0C, 0x01, 0x77, 0x76, 0x07, 0xFF, 0x0D, 0x03, 0x77, 0x75,
  0x01, 0xFF, 0xA0, 0x80, 0x17, 0x77, 0x40, 0x9F, 0xFA, 0x0E, 0x07, 0x77, 0x73, 0x01, 0x0E, 0xFF,
  0xB0, 0xE0, 0x77, 0x77, 0x20, 0x5F, 0xFD, 0x0E, 0x06, 0x77, 0x71, 0x09, 0xFF, 0xE0, 0xD0, 0x67,
  0x77, 0x0B, 0xFF, 0xF0, 0xD0, 0x57, 0x76, 0x0B, 0xFF, 0xF9, 0x0C, 0x04, 0x77, 0x50, 0x9F, 0xFF,
  0xA0, 0xA0, 0x27, 0x74, 0x05, 0x0E, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x40, 0x20, 0xBF, 0xFF, 0xA0,
  0xC0, 0x27, 0x74, 0x07, 0x0E, 0xFF, 0xF9, 0x0E, 0x04, 0x77, 0x40, 0x10, 0xAF, 0xFF, 0xA0, 0x57,
  0x75, 0x04, 0x0D, 0xFF, 0xF9, 0x05, 0x77, 0x60, 0x60, 0xDF, 0xFF, 0x02, 0x77, 0x70, 0x60, 0xEF,
  0xFD, 0x0C, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xC0, 0x67, 0x77, 0x30, 0x70, 0xEF, 0xFA, 0x0D, 0x77,
  0x74, 0x01, 0x09, 0xFF, 0xA0, 0x37, 0x77, 0x50, 0x40, 0xEF, 0xF0, 0x87, 0x77, 0x60, 0x20, 0xDF,
  0xE0, 0xB7, 0x77, 0x70, 0x3F, 0xE0, 0xD7, 0x77, 0x71, 0x0B, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F,
  0xE7, 0x77, 0x71, 0x04, 0xFE, 0x77, 0x77, 0x10, 0x4F, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFD, 0x0D,
  0x03, 0x77, 0x77, 0x09, 0xFD, 0x82, 0xCA, 0xD6, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x0A, 0xA8, 0x1E,
  0x92, 0x77, 0x71, 0x09, 0xFE, 0x05, 0x0A, 0xD8, 0x1C, 0x72, 0x77, 0x40, 0xAF, 0xF0, 0x10, 0xAF,
  0x98, 0x2D, 0x96, 0x27, 0x48, 0x13, 0x8E, 0xFF, 0x81, 0xA0, 0xAF, 0xE8, 0x90, 0xDB, 0x99, 0x88,
  0x9A, 0xCE, 0xFF, 0xB8, 0x13, 0x0A, 0x80, 0xC3, 0xF0, 0xA2, 0x0A, 0x80, 0xC2, 0xF0, 0xE0, 0x12,
  0x0A, 0x80, 0xC2, 0xF0, 0x43, 0x0A, 0x80, 0xC1, 0xF0, 0x54, 0x0A, 0xFF, 0xFF, 0xF0, 0xE0, 0x45,
  0x0A, 0xFF, 0xFF, 0xE0, 0xC0, 0x26, 0x04, 0x0B, 0xFF, 0xFF, 0xB0, 0xE0, 0x67, 0x38, 0x11, 0x7D,
  0xFF, 0xFD, 0x0D, 0x06, 0x77, 0x18, 0x22, 0x6A, 0xEF, 0xFD, 0x81, 0xD8, 0x37, 0x77, 0x87, 0x24,
  0x68, 0xBC, 0xDD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41, 0x77, 0x10,
  // "T" (U+0054)
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x47, 0x74, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80,
  0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78,
  0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x77,
  0x40,
  // "U" (U+0055)
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F, 0xD0, 0x0E, 0xFD, 0x03,
  0x77, 0x40, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x0D, 0x0C, 0xFD, 0x07, 0x77,
  0x40, 0x7F, 0xD0, 0xC0, 0xAF, 0xD0, 0xA7, 0x74, 0x0A, 0xFD, 0x0A, 0x08, 0xFD, 0x0E, 0x77, 0x40,
  0xEF, 0xD0, 0x80, 0x5F, 0xE0, 0x37, 0x72, 0x03, 0xFE, 0x05, 0x02, 0xFE, 0x0A, 0x77, 0x20, 0xAF,
  0xE8, 0x11, 0x0E, 0xFE, 0x04, 0x77, 0x03, 0xFE, 0x0D, 0x20, 0x9F, 0xE0, 0xE0, 0x37, 0x50, 0x20,
  0xEF, 0xE0, 0x82, 0x04, 0xFF, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xFF, 0x02, 0x30, 0xDF, 0xF9, 0x82,
  0xD8, 0x31, 0x28, 0x21, 0x37, 0xCF, 0xF9, 0x0B, 0x40, 0x68, 0x0C, 0x4F, 0x03, 0x50, 0xD8, 0x0C,
  0x2F, 0x0A, 0x60, 0x38, 0x0C, 0x1F, 0x0E, 0x01, 0x70, 0x78, 0x0C, 0x0F, 0x05, 0x72, 0x0A, 0xFF,
  0xFF, 0xE0, 0x77, 0x40, 0xAF, 0xFF, 0xFC, 0x07, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x04,
  0x0D, 0xFF, 0xFD, 0x0C, 0x02, 0x77, 0x40, 0x60, 0xDF, 0xFF, 0x90, 0xC0, 0x57, 0x77, 0x18, 0x14,
  0xAE, 0xFF, 0xA8, 0x1D, 0x93, 0x77, 0x76, 0x85, 0x36, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85,
  0x27, 0x71,
  // "V" (U+0056)
  0x0E, 0xFD, 0x02, 0x77, 0x73, 0x05, 0xFD, 0x0E, 0x0A, 0xFD, 0x06, 0x77, 0x73, 0x09, 0xFD, 0x0A,
  0x05, 0xFD, 0x0A, 0x77, 0x73, 0x0D, 0xFD, 0x05, 0x01, 0xFD, 0x0E, 0x77, 0x72, 0x01, 0xFE, 0x81,
  0x10, 0xCF, 0xD0, 0x37, 0x77, 0x10, 0x5F, 0xD0, 0xB2, 0x07, 0xFD, 0x07, 0x77, 0x71, 0x09, 0xFD,
  0x07, 0x20, 0x2F, 0xD0, 0xB7, 0x77, 0x10, 0xDF, 0xD0, 0x23, 0x0D, 0xFC, 0x0E, 0x77, 0x70, 0x1F,
  0xD0, 0xD4, 0x09, 0xFD, 0x03, 0x77, 0x60, 0x5F, 0xD0, 0x94, 0x04, 0xFD, 0x07, 0x77, 0x60, 0x9F,
  0xD0, 0x45, 0xFD, 0x0B, 0x77, 0x60, 0xDF, 0xD6, 0x0B, 0xFD, 0x77, 0x50, 0x1F, 0xD0, 0xB6, 0x06,
  0xFD, 0x04, 0x77, 0x40, 0x5F, 0xD0, 0x66, 0x02, 0xFD, 0x08, 0x77, 0x40, 0x9F, 0xD0, 0x17, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xDF, 0xC0, 0xC7, 0x10, 0x8F, 0xD0, 0x17, 0x72, 0x01, 0xFD, 0x08, 0x71,
  0x03, 0xFD, 0x05, 0x77, 0x20, 0x5F, 0xD0, 0x37, 0x20, 0xEF, 0xC0, 0x97, 0x72, 0x09, 0xFC, 0x0E,
  0x73, 0x0A, 0xFC, 0x0D, 0x77, 0x20, 0xDF, 0xC0, 0xA7, 0x30, 0x5F, 0xD0, 0x17, 0x70, 0x1F, 0xD0,
  0x57, 0x30, 0x1F, 0xD0, 0x57, 0x70, 0x5F, 0xD0, 0x17, 0x40, 0xCF, 0xC0, 0x97, 0x70, 0x9F, 0xC0,
  0xC7, 0x50, 0x7F, 0xC0, 0xD7, 0x70, 0xDF, 0xC0, 0x77, 0x50, 0x3F, 0xD0, 0x27, 0x50, 0x1F, 0xD0,
  0x27, 0x60, 0xDF, 0xC0, 0x67, 0x50, 0x5F, 0xC0, 0xD7, 0x70, 0x9F, 0xC0, 0xA7, 0x50, 0x9F, 0xC0,
  0x97, 0x70, 0x4F, 0xC0, 0xE7, 0x50, 0xDF, 0xC0, 0x47, 0x71, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x77,
  0x20, 0xBF, 0xC0, 0x67, 0x30, 0x5F, 0xC0, 0xB7, 0x72, 0x06, 0xFC, 0x0A, 0x73, 0x09, 0xFC, 0x06,
  0x77, 0x20, 0x2F, 0xC0, 0xE7, 0x30, 0xDF, 0xC0, 0x27, 0x73, 0x0D, 0xFC, 0x03, 0x71, 0x01, 0xFC,
  0x0D, 0x77, 0x40, 0x8F, 0xC0, 0x77, 0x10, 0x5F, 0xC0, 0x87, 0x74, 0x03, 0xFC, 0x0B, 0x71, 0x09,
  0xFC, 0x03, 0x77, 0x50, 0xEF, 0xC7, 0x10, 0xDF, 0xB0, 0xE7, 0x76, 0x0A, 0xFC, 0x04, 0x60, 0x1F,
  0xC0, 0xA7, 0x76, 0x05, 0xFC, 0x08, 0x60, 0x5F, 0xC0, 0x57, 0x76, 0x01, 0xFC, 0x0C, 0x60, 0x9F,
  0xC0, 0x17, 0x77, 0x0C, 0xFC, 0x01, 0x50, 0xDF, 0xB0, 0xC7, 0x77, 0x10, 0x7F, 0xC0, 0x55, 0xFC,
  0x07, 0x77, 0x71, 0x03, 0xFC, 0x08, 0x40, 0x4F, 0xC0, 0x37, 0x77, 0x20, 0xDF, 0xB0, 0xC4, 0x07,
  0xFB, 0x0D, 0x77, 0x73, 0x09, 0xFC, 0x40, 0xAF, 0xB0, 0x97, 0x77, 0x30, 0x4F, 0xC0, 0x33, 0x0D,
  0xFB, 0x04, 0x77, 0x74, 0xFC, 0x06, 0x20, 0x1F, 0xC7, 0x77, 0x50, 0xBF, 0xB0, 0x92, 0x04, 0xFB,
  0x0B, 0x77, 0x75, 0x06, 0xFB, 0x0D, 0x20, 0x7F, 0xB0, 0x67, 0x77, 0x50, 0x2F, 0xC2, 0x09, 0xFB,
  0x02, 0x77, 0x76, 0x0D, 0xFB, 0x81, 0x30, 0xCF, 0xA0, 0xD7, 0x77, 0x70, 0x8F, 0xB0, 0x61, 0xFB,
  0x08, 0x77, 0x77, 0x04, 0xFB, 0x09, 0x02, 0xFB, 0x04, 0x77, 0x77, 0x10, 0xEF, 0xA0, 0xB0, 0x4F,
  0xA0, 0xE7, 0x77, 0x72, 0x0A, 0xFF, 0xE0, 0xA7, 0x77, 0x72, 0x05, 0xFF, 0xE0, 0x57, 0x77, 0x72,
  0x01, 0xFF, 0xE0, 0x17, 0x77, 0x73, 0x0C, 0xFF, 0xC0, 0xC7, 0x77, 0x74, 0x07, 0xFF, 0xC0, 0x77,
  0x77, 0x74, 0x03, 0xFF, 0xC0, 0x37, 0x77, 0x75, 0x0E, 0xFF, 0xA0, 0xE7, 0x77, 0x76, 0x09, 0xFF,
  0xA0, 0x97, 0x77, 0x76, 0x05, 0xFF, 0xA0, 0x57, 0x77, 0x77, 0xFF, 0xA8, 0x0C, 0x00, 0x0B, 0xFF,
  0x0B, 0x80, 0xC0, 0x00, 0x6F, 0xF0, 0x67, 0x74,
  // "W" (U+0057)
  0xFC, 0x04, 0x77, 0x77, 0x04, 0xFF, 0xF9, 0x05, 0x77, 0x77, 0x05, 0xFC, 0x0E, 0xFB, 0x07, 0x77,
  0x77, 0x06, 0xFB, 0x0E, 0x0C, 0xFB, 0x09, 0x77, 0x77, 0x07, 0xFB, 0x0D, 0x0B, 0xFB, 0x0A, 0x77,
  0x77, 0x08, 0xFB, 0x0C, 0x0A, 0xFB, 0x0C, 0x77, 0x77, 0x0A, 0xFB, 0x0A, 0x09, 0xFB, 0x0D, 0x77,
  0x77, 0x0B, 0xFB, 0x09, 0x08, 0xFC, 0x77, 0x77, 0x0C, 0xFB, 0x08, 0x07, 0xFC, 0x01, 0x77, 0x76,
  0x0D, 0xFB, 0x07, 0x06, 0xFC, 0x02, 0x77, 0x76, 0x0E, 0xFB, 0x06, 0x04, 0xFC, 0x04, 0x77, 0x76,
  0xFC, 0x05, 0x03, 0xFC, 0x05, 0x77, 0x75, 0x01, 0xFC, 0x04, 0x02, 0xFC, 0x06, 0x77, 0x75, 0x02,
  0xFC, 0x03, 0x01, 0xFC, 0x08, 0x77, 0x75, 0x03, 0xFC, 0x02, 0x1F, 0xC0, 0x97, 0x77, 0x50, 0x4F,
  0xC8, 0x11, 0x0E, 0xFB, 0x0A, 0x60, 0x3F, 0xD0, 0x56, 0x05, 0xFC, 0x20, 0xDF, 0xB0, 0xC6, 0x05,
  0xFD, 0x08, 0x60, 0x6F, 0xB0, 0xE2, 0x0C, 0xFB, 0x0D, 0x60, 0x7F, 0xD0, 0xA6, 0x08, 0xFB, 0x0D,
  0x20, 0xBF, 0xB0, 0xE6, 0x0A, 0xFD, 0x0C, 0x60, 0x9F, 0xB0, 0xC2, 0x09, 0xFC, 0x60, 0xCF, 0xE6,
  0x0A, 0xFB, 0x0B, 0x20, 0x8F, 0xC0, 0x15, 0xFF, 0x01, 0x50, 0xBF, 0xB0, 0xA2, 0x07, 0xFC, 0x02,
  0x40, 0x2F, 0xF0, 0x45, 0x0C, 0xFB, 0x09, 0x20, 0x6F, 0xC0, 0x34, 0x04, 0xFF, 0x06, 0x50, 0xDF,
  0xB0, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x6F, 0xF0, 0x85, 0x0E, 0xFB, 0x06, 0x20, 0x4F, 0xC0, 0x54,
  0x09, 0xFF, 0x0B, 0x5F, 0xC0, 0x52, 0x03, 0xFC, 0x06, 0x40, 0xBF, 0xF0, 0xD4, 0x01, 0xFC, 0x04,
  0x20, 0x1F, 0xC0, 0x74, 0x0D, 0xFF, 0x94, 0x02, 0xFC, 0x03, 0x3F, 0xC0, 0x84, 0xFF, 0xA0, 0x23,
  0x03, 0xFC, 0x02, 0x3F, 0xC0, 0x93, 0x03, 0xF9, 0x0E, 0xF0, 0x53, 0x04, 0xFC, 0x01, 0x30, 0xDF,
  0xB0, 0xA3, 0x05, 0xF0, 0xB0, 0x8F, 0x07, 0x30, 0x5F, 0xC4, 0x0C, 0xFB, 0x0A, 0x30, 0x8F, 0x09,
  0x06, 0xF0, 0x93, 0x06, 0xFB, 0x0E, 0x40, 0xBF, 0xB0, 0xB3, 0x0A, 0xF0, 0x70, 0x4F, 0x0C, 0x30,
  0x7F, 0xB0, 0xD4, 0x0A, 0xFB, 0x0B, 0x30, 0xCF, 0x05, 0x02, 0xF0, 0xE3, 0x07, 0xFB, 0x0C, 0x40,
  0x9F, 0xB0, 0xC3, 0xF9, 0x03, 0x1F, 0x90, 0x12, 0x08, 0xFB, 0x0B, 0x40, 0x8F, 0xB0, 0xC2, 0x02,
  0xF9, 0x81, 0x10, 0xEF, 0x03, 0x20, 0x8F, 0xB0, 0xA4, 0x07, 0xFB, 0x0C, 0x20, 0x4F, 0x92, 0x0C,
  0xF0, 0x52, 0x08, 0xFB, 0x09, 0x40, 0x5F, 0xB0, 0xC2, 0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0x82, 0x08,
  0xFB, 0x08, 0x40, 0x4F, 0xB0, 0xC2, 0x08, 0xF0, 0xA2, 0x08, 0xF0, 0xA2, 0x09, 0xFB, 0x07, 0x40,
  0x3F, 0xB0, 0xC2, 0x0B, 0xF0, 0x82, 0x05, 0xF0, 0xD2, 0x08, 0xFB, 0x05, 0x40, 0x2F, 0xB0, 0xD2,
  0x0D, 0xF0, 0x62, 0x03, 0xF9, 0x20, 0x8F, 0xB0, 0x44, 0x01, 0xFB, 0x0D, 0x2F, 0x90, 0x32, 0x01,
  0xF9, 0x81, 0x20, 0x8F, 0xB0, 0x35, 0xFB, 0x81, 0xD0, 0x2F, 0x90, 0x13, 0xF9, 0x81, 0x50, 0x8F,
  0xB0, 0x25, 0x0E, 0xFA, 0x81, 0xD0, 0x4F, 0x0E, 0x40, 0xCF, 0x81, 0x80, 0x7F, 0xB0, 0x15, 0x0D,
  0xFA, 0x81, 0xD0, 0x6F, 0x0B, 0x40, 0xAF, 0x81, 0xA0, 0x7F, 0xB6, 0x0C, 0xFA, 0x81, 0xD0, 0x8F,
  0x09, 0x40, 0x8F, 0x81, 0xD0, 0x7F, 0xA0, 0xE6, 0x0B, 0xFA, 0x81, 0xD0, 0xAF, 0x07, 0x40, 0x5F,
  0x91, 0x06, 0xFA, 0x0D, 0x60, 0x9F, 0xA8, 0x1D, 0x0C, 0xF0, 0x44, 0x03, 0xF9, 0x02, 0x06, 0xFA,
  0x0C, 0x60, 0x8F, 0xA8, 0x1C, 0x0E, 0xF0, 0x24, 0x01, 0xF9, 0x00, 0x5F, 0xA0, 0xB6, 0x07, 0xFA,
  0x0C, 0x1F, 0x96, 0x0E, 0xF0, 0x70, 0x4F, 0xA0, 0xA6, 0x06, 0xFA, 0x0C, 0x03, 0xF0, 0xD6, 0x0C,
  0xF0, 0xA0, 0x4F, 0xA0, 0x96, 0x05, 0xFA, 0x0C, 0x05, 0xF0, 0xB6, 0x09, 0xF0, 0xC0, 0x3F, 0xA0,
  0x86, 0x04, 0xFA, 0x0B, 0x07, 0xF0, 0x86, 0x07, 0xF0, 0xE0, 0x3F, 0xA0, 0x76, 0x02, 0xFA, 0x0A,
  0x09, 0xF0, 0x66, 0x05, 0xF9, 0x04, 0xFA, 0x06, 0x60, 0x1F, 0xA0, 0x0E, 0xF0, 0x46, 0x02, 0xF9,
  0x0B, 0xFA, 0x05, 0x7F, 0xFC, 0x01, 0x7F, 0xFC, 0x04, 0x70, 0xEF, 0xFA, 0x0E, 0x71, 0x0D, 0xFF,
  0xB0, 0x27, 0x0D, 0xFF, 0xA0, 0xC7, 0x10, 0xBF, 0xFB, 0x01, 0x70, 0xCF, 0xFA, 0x0A, 0x71, 0x08,
  0xFF, 0xB7, 0x10, 0xBF, 0xFA, 0x07, 0x71, 0x06, 0xFF, 0xB7, 0x10, 0xAF, 0xFA, 0x05, 0x71, 0x04,
  0xFF, 0xA0, 0xE7, 0x10, 0x9F, 0xFA, 0x03, 0x71, 0x01, 0xFF, 0xA0, 0xD7, 0x10, 0x8F, 0xFA, 0x01,
  0x72, 0x0E, 0xFF, 0x90, 0xB7, 0x10, 0x6F, 0xF9, 0x0E, 0x73, 0x0C, 0xFF, 0x90, 0xA7, 0x10, 0x5F,
  0xF9, 0x0B, 0x73, 0x0A, 0xFF, 0x90, 0x94,
  // "X" (U+0058)
  0x10, 0xAF, 0xD0, 0x97, 0x76, 0x0C, 0xFD, 0x0A, 0x20, 0x10, 0xEF, 0xD0, 0x27, 0x74, 0x05, 0xFD,
  0x0E, 0x01, 0x30, 0x7F, 0xD0, 0xA7, 0x74, 0x0C, 0xFD, 0x07, 0x50, 0xDF, 0xD0, 0x27, 0x72, 0x05,
  0xFD, 0x0D, 0x60, 0x5F, 0xD0, 0xA7, 0x72, 0x0C, 0xFD, 0x05, 0x70, 0xCF, 0xD0, 0x37, 0x70, 0x5F,
  0xD0, 0xB7, 0x10, 0x3F, 0xD0, 0xB7, 0x70, 0xCF, 0xD0, 0x37, 0x20, 0x9F, 0xD0, 0x37, 0x50, 0x5F,
  0xD0, 0x97, 0x30, 0x10, 0xEF, 0xC0, 0xB7, 0x50, 0xDF, 0xC0, 0xE0, 0x17, 0x40, 0x7F, 0xD0, 0x37,
  0x30, 0x5F, 0xD0, 0x77, 0x60, 0xDF, 0xC0, 0xB7, 0x30, 0xDF, 0xC0, 0xD7, 0x70, 0x5F, 0xD0, 0x47,
  0x10, 0x5F, 0xD0, 0x57, 0x71, 0x0B, 0xFC, 0x0C, 0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x20, 0x3F, 0xD0,
  0x46, 0x05, 0xFD, 0x02, 0x77, 0x30, 0x9F, 0xC0, 0xC6, 0x0D, 0xFC, 0x09, 0x77, 0x40, 0x10, 0xEF,
  0xC0, 0x54, 0x05, 0xFC, 0x0E, 0x01, 0x77, 0x50, 0x7F, 0xC0, 0xD4, 0x0D, 0xFC, 0x07, 0x77, 0x70,
  0xDF, 0xC0, 0x52, 0x06, 0xFC, 0x0D, 0x77, 0x71, 0x05, 0xFC, 0x0D, 0x20, 0xDF, 0xC0, 0x47, 0x77,
  0x20, 0xBF, 0xC0, 0x06, 0xFC, 0x0B, 0x77, 0x73, 0x03, 0xFC, 0x00, 0xDF, 0xC0, 0x27, 0x77, 0x40,
  0x9F, 0xFF, 0x90, 0x97, 0x77, 0x50, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x77, 0x76, 0x07, 0xFF, 0xE0,
  0x67, 0x77, 0x71, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x72, 0x05, 0xFF, 0xC0, 0x47, 0x77, 0x73, 0x0B,
  0xFF, 0xA0, 0xB7, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0x27, 0x77, 0x75, 0x09, 0xFF, 0x08, 0x77, 0x77,
  0x60, 0x10, 0xEF, 0xD0, 0xE0, 0x17, 0x77, 0x77, 0x07, 0xFD, 0x06, 0x80, 0xC0, 0x00, 0x1F, 0xD0,
  0x18, 0x0C, 0x00, 0x09, 0xFD, 0x09, 0x77, 0x77, 0x70, 0x2F, 0xF0, 0x37, 0x77, 0x76, 0x0B, 0xFF,
  0x0C, 0x77, 0x77, 0x50, 0x5F, 0xFA, 0x06, 0x77, 0x77, 0x40, 0xDF, 0xFA, 0x0E, 0x01, 0x77, 0x77,
  0x20, 0x8F, 0xFC, 0x08, 0x77, 0x77, 0x10, 0x2F, 0xFE, 0x02, 0x77, 0x77, 0x0B, 0xFF, 0xE0, 0xB7,
  0x77, 0x60, 0x4F, 0xFF, 0x90, 0x57, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0xD7, 0x77, 0x40, 0x7F, 0xC0,
  0xA0, 0xDF, 0xC0, 0x87, 0x77, 0x20, 0x10, 0xEF, 0xC0, 0x20, 0x5F, 0xD0, 0x27, 0x77, 0x10, 0xAF,
  0xC0, 0x92, 0x0C, 0xFC, 0x0A, 0x77, 0x70, 0x4F, 0xC0, 0xE0, 0x12, 0x04, 0xFD, 0x04, 0x77, 0x60,
  0xDF, 0xC0, 0x74, 0x0B, 0xFC, 0x0D, 0x77, 0x50, 0x7F, 0xC0, 0xE5, 0x03, 0xFD, 0x07, 0x77, 0x30,
  0x10, 0xEF, 0xC0, 0x66, 0x0A, 0xFC, 0x0E, 0x01, 0x77, 0x20, 0x9F, 0xC0, 0xD7, 0x02, 0xFD, 0x0A,
  0x77, 0x10, 0x3F, 0xD0, 0x57, 0x10, 0xAF, 0xD0, 0x37, 0x70, 0xCF, 0xC0, 0xC7, 0x20, 0x2F, 0xD0,
  0xC7, 0x60, 0x6F, 0xD0, 0x47, 0x30, 0x9F, 0xD0, 0x67, 0x40, 0x10, 0xEF, 0xC0, 0xB7, 0x40, 0x1F,
  0xD0, 0xE0, 0x17, 0x30, 0x9F, 0xD0, 0x37, 0x50, 0x8F, 0xD0, 0x97, 0x20, 0x2F, 0xD0, 0xA7, 0x60,
  0x10, 0xEF, 0xD0, 0x37, 0x10, 0xBF, 0xD0, 0x27, 0x70, 0x7F, 0xD0, 0xC7, 0x05, 0xFD, 0x09, 0x77,
  0x20, 0xEF, 0xD0, 0x56, 0x0D, 0xFD, 0x01, 0x77, 0x20, 0x7F, 0xD0, 0xE5, 0x08, 0xFD, 0x08, 0x77,
  0x40, 0xDF, 0xD0, 0x83, 0x02, 0xFD, 0x0E, 0x01, 0x77, 0x40, 0x6F, 0xE0, 0x22, 0x0B, 0xFD, 0x07,
  0x77, 0x60, 0xDF, 0xD8, 0x1B, 0x04, 0xFD, 0x0D, 0x77, 0x70, 0x5F, 0xE0, 0x40, 0xDF, 0xD0, 0x67,
  0x77, 0x10, 0xCF, 0xD0, 0xD0,
  // "Y" (U+0059)
  0x0E, 0xFD, 0x0B, 0x77, 0x71, 0x0A, 0xFD, 0x0E, 0x07, 0xFE, 0x02, 0x77, 0x60, 0x1F, 0xE8, 0x17,
  0x1E, 0xFD, 0x09, 0x77, 0x60, 0x8F, 0xD8, 0x2E, 0x10, 0x8F, 0xD0, 0xE0, 0x17, 0x75, 0x0E, 0xFD,
  0x08, 0x20, 0x1F, 0xE0, 0x67, 0x74, 0x05, 0xFE, 0x01, 0x30, 0x9F, 0xD0, 0xD7, 0x74, 0x0B, 0xFD,
  0x09, 0x40, 0x2F, 0xE0, 0x47, 0x72, 0x02, 0xFE, 0x02, 0x50, 0xAF, 0xD0, 0xA7, 0x72, 0x09, 0xFD,
  0x0A, 0x60, 0x2F, 0xE0, 0x17, 0x71, 0x0E, 0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x87, 0x70, 0x6F, 0xD0,
  0xB7, 0x10, 0x3F, 0xD0, 0xE7, 0x70, 0xCF, 0xD0, 0x37, 0x20, 0xBF, 0xD0, 0x57, 0x50, 0x3F, 0xD0,
  0xB7, 0x30, 0x4F, 0xD0, 0xC7, 0x50, 0xAF, 0xD0, 0x47, 0x40, 0xCF, 0xD0, 0x37, 0x30, 0x1F, 0xD0,
  0xC7, 0x50, 0x5F, 0xD0, 0x97, 0x30, 0x7F, 0xD0, 0x57, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x20, 0xDF,
  0xC0, 0xD7, 0x70, 0x5F, 0xD0, 0x77, 0x10, 0x4F, 0xD0, 0x67, 0x71, 0x0D, 0xFC, 0x0D, 0x71, 0x0B,
  0xFC, 0x0E, 0x77, 0x20, 0x6F, 0xD0, 0x46, 0x02, 0xFD, 0x07, 0x77, 0x30, 0xEF, 0xC0, 0xA6, 0x08,
  0xFC, 0x0E, 0x77, 0x40, 0x7F, 0xD0, 0x25, 0x0E, 0xFC, 0x07, 0x77, 0x50, 0xEF, 0xC0, 0x84, 0x05,
  0xFC, 0x0E, 0x01, 0x77, 0x50, 0x8F, 0xC0, 0xE4, 0x0C, 0xFC, 0x08, 0x77, 0x60, 0x10, 0xEF, 0xC0,
  0x52, 0x03, 0xFD, 0x01, 0x77, 0x70, 0x9F, 0xC0, 0xC2, 0x09, 0xFC, 0x09, 0x77, 0x71, 0x01, 0xFD,
  0x81, 0x31, 0xEF, 0xC0, 0x27, 0x77, 0x20, 0x9F, 0xC0, 0x90, 0x7F, 0xC0, 0xA7, 0x77, 0x30, 0x2F,
  0xD0, 0xDF, 0xC0, 0x37, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0xB7, 0x77, 0x50, 0x3F, 0xFF, 0x90, 0x47,
  0x77, 0x60, 0xBF, 0xFE, 0x0C, 0x77, 0x77, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x71, 0x0C, 0xFF, 0xC0,
  0xD7, 0x77, 0x72, 0x04, 0xFF, 0xC0, 0x57, 0x77, 0x73, 0x0C, 0xFF, 0xA0, 0xD7, 0x77, 0x74, 0x05,
  0xFF, 0xA0, 0x67, 0x77, 0x75, 0x0D, 0xFF, 0x0E, 0x77, 0x77, 0x60, 0x6F, 0xF0, 0x77, 0x77, 0x77,
  0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80,
  0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88,
  0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08,
  0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0,
  0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD,
  0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F,
  0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x87, 0x74,
  // "Z" (U+005A)
  0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20,
  0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88,
  0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x06, 0x20, 0x88, 0x0C,
  0x0F, 0x0D, 0x30, 0x48, 0x0A, 0x28, 0x09, 0xFE, 0x04, 0x77, 0x75, 0x09, 0xFD, 0x0B, 0x77, 0x75,
  0x03, 0xFE, 0x02, 0x77, 0x75, 0x0B, 0xFD, 0x08, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x76, 0x0D,
  0xFD, 0x05, 0x77, 0x75, 0x07, 0xFD, 0x0C, 0x77, 0x75, 0x01, 0x0E, 0xFD, 0x03, 0x77, 0x75, 0x09,
  0xFD, 0x09, 0x77, 0x75, 0x03, 0xFD, 0x0E, 0x01, 0x77, 0x75, 0x0B, 0xFD, 0x07, 0x77, 0x75, 0x05,
  0xFD, 0x0D, 0x77, 0x76, 0x0D, 0xFD, 0x04, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x75, 0x01, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x08, 0x77, 0x75, 0x03, 0xFD, 0x0E, 0x77, 0x76, 0x0C, 0xFD,
  0x06, 0x77, 0x75, 0x05, 0xFD, 0x0C, 0x77, 0x76, 0x0D, 0xFD, 0x03, 0x77, 0x75, 0x07, 0xFD, 0x09,
  0x77, 0x75, 0x01, 0x0E, 0xFC, 0x0E, 0x01, 0x77, 0x75, 0x0A, 0xFD, 0x07, 0x77, 0x75, 0x03, 0xFD,
  0x0D, 0x77, 0x76, 0x0C, 0xFD, 0x04, 0x77, 0x75, 0x05, 0xFD, 0x0B, 0x77, 0x76, 0x0D, 0xFD, 0x02,
  0x77, 0x75, 0x07, 0xFD, 0x08, 0x77, 0x75, 0x01, 0x0E, 0xFC, 0x0E, 0x77, 0x76, 0x0A, 0xFD, 0x06,
  0x77, 0x75, 0x03, 0xFD, 0x0C, 0x77, 0x76, 0x0C, 0xFD, 0x03, 0x77, 0x75, 0x05, 0xFD, 0x09, 0x77,
  0x76, 0x0D, 0xFC, 0x0E, 0x01, 0x77, 0x75, 0x08, 0xFD, 0x07, 0x77, 0x75, 0x01, 0xFD, 0x0D, 0x77,
  0x76, 0x0A, 0xFD, 0x04, 0x77, 0x75, 0x03, 0xFD, 0x0B, 0x77, 0x76, 0x0C, 0xFD, 0x02, 0x77, 0x75,
  0x05, 0xFD, 0x08, 0x77, 0x76, 0x0E, 0xFC, 0x0E, 0x77, 0x76, 0x08, 0xFD, 0x06, 0x77, 0x75, 0x02,
  0xFD, 0x0C, 0x77, 0x76, 0x0A, 0x80, 0xC2, 0xF0, 0xA0, 0x38, 0x0C, 0x3F, 0x0A, 0x0B, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "[" (U+005B)
  0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04,
  0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04, 0xFB, 0x0D, 0x74, 0x04,
  0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF,
  0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x40,
  // "\" (U+005C)
  0x0C, 0xFB, 0x06, 0x77, 0x73, 0x06, 0xFB, 0x0C, 0x77, 0x73, 0x01, 0xFC, 0x03, 0x77, 0x73, 0x0A,
  0xFB, 0x09, 0x77, 0x73, 0x04, 0xFB, 0x0E, 0x77, 0x74, 0x0D, 0xFB, 0x05, 0x77, 0x73, 0x07, 0xFB,
  0x0B, 0x77, 0x73, 0x01, 0xFC, 0x02, 0x77, 0x73, 0x0B, 0xFB, 0x08, 0x77, 0x73, 0x05, 0xFB, 0x0E,
  0x77, 0x74, 0x0E, 0xFB, 0x04, 0x77, 0x73, 0x08, 0xFB, 0x0A, 0x77, 0x73, 0x02, 0xFC, 0x01, 0x77,
  0x73, 0x0C, 0xFB, 0x07, 0x77, 0x73, 0x06, 0xFB, 0x0D, 0x77, 0x73, 0x01, 0xFC, 0x03, 0x77, 0x73,
  0x0A, 0xFB, 0x09, 0x77, 0x73, 0x04, 0xFB, 0x0E, 0x77, 0x74, 0x0D, 0xFB, 0x06, 0x77, 0x73, 0x07,
  0xFB, 0x0C, 0x77, 0x73, 0x01, 0xFC, 0x02, 0x77, 0x73, 0x0B, 0xFB, 0x08, 0x77, 0x73, 0x05, 0xFB,
  0x0E, 0x77, 0x74, 0x0E, 0xFB, 0x05, 0x77, 0x73, 0x08, 0xFB, 0x0B, 0x77, 0x73, 0x02, 0xFC, 0x01,
  0x77, 0x73, 0x0C, 0xFB, 0x07, 0x77, 0x73, 0x06, 0xFB, 0x0D, 0x77, 0x74, 0x0E, 0xFB, 0x04, 0x77,
  0x73, 0x09, 0xFB, 0x0A, 0x77, 0x73, 0x03, 0xFC, 0x01, 0x77, 0x73, 0x0D, 0xFB, 0x06, 0x77, 0x73,
  0x07, 0xFB, 0x0C, 0x77, 0x73, 0x01, 0xFC, 0x03, 0x77, 0x73, 0x0B, 0xFB, 0x09, 0x77, 0x73, 0x05,
  0xFB, 0x0E, 0x77, 0x74, 0x0E, 0xFB, 0x05, 0x77, 0x73, 0x08, 0xFB, 0x0B, 0x77, 0x73, 0x02, 0xFC,
  0x02, 0x77, 0x73, 0x0C, 0xFB, 0x08, 0x77, 0x73, 0x06, 0xFB, 0x0D, 0x77, 0x74, 0x0E, 0xFB, 0x04,
  0x77, 0x73, 0x09, 0xFB, 0x0A, 0x77, 0x73, 0x03, 0xFC, 0x01, 0x77, 0x73, 0x0D, 0xFB, 0x07, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x77, 0x73, 0x01, 0xFC, 0x03, 0x77, 0x73, 0x0A, 0xFB, 0x09, 0x77, 0x73,
  0x04, 0xFB, 0x0E, 0x77, 0x74, 0x0E, 0xFB, 0x06, 0x77, 0x73, 0x08, 0xFB, 0x0C, 0x77, 0x73, 0x02,
  0xFC, 0x02, 0x77, 0x73, 0x0C, 0xFB, 0x08, 0x77, 0x73, 0x06, 0xFB, 0x0E, 0x77, 0x74, 0x0E, 0xFB,
  0x05, 0x77, 0x73, 0x09, 0xFB, 0x0B, 0x77, 0x73, 0x03, 0xFC, 0x01, 0x77, 0x73, 0x0D, 0xFB, 0x07,
  0x77, 0x73, 0x07, 0xFB, 0x0D, 0x77, 0x73, 0x01, 0xFC, 0x03, 0x77, 0x73, 0x0A, 0xFB, 0x09, 0x77,
  0x73, 0x04, 0xFC, 0x01, 0x77, 0x73, 0x0E, 0xFB, 0x06, 0x77, 0x73, 0x08, 0xFB, 0x0C,
  // "]" (U+005D)
  0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04,
  0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47,
  0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x47, 0x40, 0xDF, 0xB0, 0x04,
  0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF,
  0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x04, 0xFF, 0xF0, 0x40,
  // "^" (U+005E)
  0x77, 0x68, 0x02, 0x70, 0x48, 0x0C, 0x40, 0x04, 0xE0, 0xE8, 0x0C, 0x40, 0x0B, 0xF0, 0x78, 0x0C,
  0x20, 0x03, 0xF9, 0x0E, 0x80, 0xC2, 0x00, 0xBF, 0xA0, 0x78, 0x0C, 0x00, 0x03, 0xFB, 0x0E, 0x01,
  0x77, 0x77, 0x70, 0xAF, 0xC0, 0x87, 0x77, 0x76, 0x02, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xAF,
  0xE0, 0x97, 0x77, 0x74, 0x02, 0xFF, 0x90, 0x17, 0x77, 0x73, 0x09, 0xFF, 0x90, 0x97, 0x77, 0x72,
  0x02, 0xFF, 0xB0, 0x27, 0x77, 0x71, 0x09, 0xFF, 0xB0, 0xA7, 0x77, 0x70, 0x1F, 0xFD, 0x02, 0x77,
  0x76, 0x08, 0xFF, 0xD0, 0xA7, 0x77, 0x50, 0x10, 0xEF, 0xA0, 0x9F, 0xB0, 0x37, 0x77, 0x40, 0x8F,
  0xA8, 0x1C, 0x0C, 0xFA, 0x0B, 0x77, 0x73, 0x01, 0x0E, 0xFA, 0x81, 0x40, 0x4F, 0xB0, 0x37, 0x77,
  0x20, 0x7F, 0xA0, 0xD3, 0x0C, 0xFA, 0x0B, 0x77, 0x72, 0x0E, 0xFA, 0x05, 0x30, 0x4F, 0xB0, 0x47,
  0x77, 0x07, 0xFA, 0x0D, 0x50, 0xBF, 0xA0, 0xC7, 0x77, 0x0E, 0xFA, 0x06, 0x50, 0x3F, 0xB0, 0x47,
  0x75, 0x06, 0xFA, 0x0E, 0x70, 0xBF, 0xA0, 0xC7, 0x75, 0x0D, 0xFA, 0x07, 0x70, 0x3F, 0xB0, 0x57,
  0x73, 0x06, 0xFA, 0x0E, 0x01, 0x71, 0x0B, 0xFA, 0x0D, 0x77, 0x30, 0xDF, 0xA0, 0x87, 0x20, 0x3F,
  0xB0, 0x57, 0x71, 0x05, 0xFB, 0x01, 0x73, 0x0A, 0xFA, 0x0D, 0x77, 0x10, 0xDF, 0xA0, 0x97, 0x40,
  0x2F, 0xB0, 0x67, 0x60, 0x5F, 0xB0, 0x27, 0x50, 0xAF, 0xA0, 0xD7, 0x60, 0xCF, 0xA0, 0xA7, 0x60,
  0x2F, 0xB0, 0x77, 0x40, 0x5F, 0xB0, 0x27, 0x70, 0x9F, 0xA0, 0xE7, 0x40, 0xCF, 0xA0, 0xA7, 0x71,
  0x02, 0xFB, 0x07, 0x72, 0x04, 0xFB, 0x03, 0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x17, 0x10, 0xBF, 0xA0,
  0xB7, 0x73, 0x01, 0xFB, 0x08, 0x70, 0x4F, 0xB0, 0x47, 0x74, 0x08, 0xFA, 0x0E, 0x01, 0x60, 0xBF,
  0xA0, 0xC7, 0x75, 0x01, 0x0E, 0xFA, 0x08, 0x50, 0x3F, 0xB0, 0x57, 0x76, 0x08, 0xFB, 0x01, 0x40,
  0xBF, 0xA0, 0xD7, 0x77, 0x01, 0x0E, 0xFA, 0x09, 0x30, 0x3F, 0xB0, 0x67, 0x77, 0x10, 0x7F, 0xB0,
  0x22, 0x0A, 0xFA, 0x0D, 0x77, 0x73, 0x0E, 0xFA, 0x81, 0x90, 0x2F, 0xB0, 0x77, 0x77, 0x30, 0x7F,
  0xB0, 0x20,
  // "_" (U+005F)
  0x80, 0xE2, 0x88, 0x09, 0x8B, 0x0F,
  // "`" (U+0060)
  0x05, 0x80, 0x91, 0x70, 0x47, 0x20, 0x9F, 0xE0, 0xE0, 0x17, 0x20, 0xBF, 0xE0, 0x97, 0x30, 0xCF,
  0xE0, 0x37, 0x20, 0x10, 0xCF, 0xD0, 0xD7, 0x40, 0xCF, 0xD0, 0x87, 0x40, 0xBF, 0xD0, 0x37, 0x40,
  0xBF, 0xC0, 0xD7, 0x50, 0xAF, 0xC0, 0x87, 0x50, 0x9F, 0xC0, 0x37, 0x50, 0x8F, 0xB0, 0xD7, 0x60,
  0x6F, 0xB0, 0xA7, 0x60, 0x5F, 0xB0, 0x57, 0x60, 0x30, 0xEF, 0x90, 0xE0, 0x27, 0x60, 0x10, 0xCF,
  0x90, 0x50,
  // "a" (U+0061)
  0x76, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72, 0x82, 0x15, 0x9D,
  0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFF,
  0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xC7,
  0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8, 0x0C, 0x0F, 0x02,
  0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A, 0xDF, 0xFB, 0x01,
  0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C, 0xFE, 0xA4, 0x77,
  0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0xD7,
  0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73, 0x04, 0xFD, 0x02,
  0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86, 0x15, 0x7A, 0xCD,
  0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40, 0xBF, 0xFF, 0xFF,
  0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02, 0x30, 0x20, 0xE8,
  0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81, 0x20, 0x1F, 0xF9,
  0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67, 0x70, 0x4F, 0xD8,
  0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02, 0x77, 0x20, 0x4F,
  0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77, 0x30, 0x7F, 0xD0,
  0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x20,
  0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B, 0xFF, 0x02, 0x04,
  0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05, 0x0B, 0xFF, 0xB8,
  0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80, 0xC6, 0xF8, 0x12,
  0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05, 0xFF, 0xFE, 0x81,
  0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40, 0xDF, 0xFF, 0xA0,
  0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F, 0xB0, 0x26, 0x09,
  0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57, 0x20, 0xEF, 0xA0,
  0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "b" (U+0062)
  0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7,
  0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F,
  0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77,
  0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD,
  0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xA7, 0x77,
  0x75, 0xFD, 0x09, 0x71, 0x83, 0x27, 0xAC, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x6F, 0xD0, 0x95, 0x81,
  0x17, 0xDF, 0xD8, 0x1D, 0x71, 0x73, 0xFD, 0x08, 0x40, 0x70, 0xEF, 0xFA, 0x0E, 0x04, 0x72, 0xFD,
  0x07, 0x20, 0x10, 0xCF, 0xFE, 0x09, 0x71, 0xFD, 0x82, 0x60, 0x2E, 0xFF, 0xF9, 0x0A, 0x7F, 0xD8,
  0x14, 0x1E, 0xFF, 0xFB, 0x09, 0x6F, 0xD0, 0x30, 0xCF, 0xFF, 0xD0, 0x55, 0xFD, 0x0E, 0xFF, 0xFE,
  0x0E, 0x02, 0x48, 0x0C, 0x5F, 0x0A, 0x48, 0x0C, 0x6F, 0x03, 0x3F, 0xFD, 0x84, 0xEB, 0x98, 0xAB,
  0xFF, 0xB0, 0xA3, 0xFF, 0xB0, 0xD0, 0x56, 0x81, 0x16, 0xEF, 0xF9, 0x01, 0x2F, 0xFA, 0x0A, 0x73,
  0x01, 0x0B, 0xFF, 0x07, 0x2F, 0xF9, 0x0A, 0x76, 0x0C, 0xFE, 0x0B, 0x2F, 0xF0, 0xD7, 0x70, 0x20,
  0xEF, 0xE0, 0x11, 0xFF, 0x05, 0x77, 0x10, 0x8F, 0xE0, 0x51, 0xFE, 0x0E, 0x77, 0x20, 0x1F, 0xE0,
  0x81, 0xFE, 0x09, 0x77, 0x30, 0xBF, 0xD0, 0xB1, 0xFE, 0x05, 0x77, 0x30, 0x7F, 0xD0, 0xE1, 0xFE,
  0x02, 0x77, 0x30, 0x4F, 0xE1, 0xFE, 0x77, 0x40, 0x2F, 0xE0, 0x2F, 0xD0, 0xD7, 0x75, 0xFE, 0x03,
  0xFD, 0x0C, 0x77, 0x50, 0xEF, 0xD0, 0x4F, 0xD0, 0xB7, 0x75, 0x0D, 0xFD, 0x05, 0xFD, 0x0B, 0x77,
  0x50, 0xDF, 0xD0, 0x5F, 0xD0, 0xB7, 0x75, 0x0D, 0xFD, 0x06, 0xFD, 0x0B, 0x77, 0x50, 0xDF, 0xD0,
  0x5F, 0xD0, 0xC7, 0x75, 0x0E, 0xFD, 0x05, 0xFD, 0x0D, 0x77, 0x5F, 0xE0, 0x4F, 0xE7, 0x74, 0x01,
  0xFE, 0x03, 0xFE, 0x01, 0x77, 0x30, 0x3F, 0xE0, 0x1F, 0xE0, 0x47, 0x73, 0x05, 0xFE, 0x1F, 0xE0,
  0x77, 0x73, 0x09, 0xFD, 0x0D, 0x1F, 0xE0, 0xC7, 0x73, 0x0D, 0xFD, 0x0A, 0x1F, 0xF0, 0x27, 0x71,
  0x03, 0xFE, 0x07, 0x1F, 0xF0, 0x97, 0x71, 0x0A, 0xFE, 0x03, 0x1F, 0xF9, 0x02, 0x76, 0x03, 0xFE,
  0x0E, 0x2F, 0xF9, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xFE, 0x0A, 0x2F, 0xFA, 0x0C, 0x01, 0x72, 0x01,
  0x0C, 0xFF, 0x05, 0x2F, 0xFB, 0x81, 0xE6, 0x15, 0x81, 0x16, 0xEF, 0xF0, 0xE3, 0xFF, 0xE8, 0x3B,
  0x98, 0x9B, 0xFF, 0xB0, 0x83, 0x80, 0xC5, 0xF0, 0xE0, 0x13, 0x80, 0xC5, 0xF0, 0x74, 0x80, 0xC4,
  0xF0, 0xD5, 0x80, 0xC4, 0xF0, 0x35, 0xFC, 0x81, 0x90, 0xBF, 0xFF, 0xC0, 0x66, 0xFC, 0x03, 0x20,
  0xBF, 0xFF, 0xA0, 0x77, 0xFB, 0x0C, 0x40, 0x8F, 0xFF, 0x06, 0x71, 0xFB, 0x06, 0x50, 0x20, 0xBF,
  0xFB, 0x0C, 0x02, 0x72, 0xFB, 0x01, 0x78, 0x13, 0xAE, 0xFD, 0x0C, 0x05, 0x77, 0x77, 0x48, 0x92,
  0x48, 0xBD, 0xEF, 0xED, 0xCA, 0x62, 0x76,
  // "c" (U+0063)
  0x77, 0x38, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x6E, 0xDD, 0xB9, 0x75, 0x27, 0x76, 0x81, 0x16, 0xBF,
  0xFD, 0x81, 0xB7, 0x37, 0x70, 0x20, 0x9F, 0xFF, 0xC8, 0x1D, 0x71, 0x73, 0x08, 0xFF, 0xFF, 0x90,
  0x97, 0x10, 0x30, 0xDF, 0xFF, 0xFA, 0x03, 0x70, 0x5F, 0xFF, 0xFB, 0x0D, 0x70, 0x5F, 0xFF, 0xFC,
  0x07, 0x60, 0x3F, 0xFF, 0xFD, 0x02, 0x50, 0x10, 0xEF, 0xFF, 0xFC, 0x0B, 0x60, 0xAF, 0xFF, 0xFD,
  0x06, 0x50, 0x4F, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBD, 0xF0, 0xE6, 0x0C, 0xFF, 0x98, 0x1E, 0x72,
  0x71, 0x82, 0x14, 0x8C, 0xB0, 0xA5, 0x04, 0xFF, 0x90, 0x87, 0x71, 0x82, 0x28, 0xE4, 0x50, 0xAF,
  0xF0, 0x67, 0x77, 0x4F, 0xF0, 0x77, 0x77, 0x40, 0x5F, 0xE0, 0xC7, 0x77, 0x50, 0x9F, 0xE0, 0x37,
  0x77, 0x50, 0xDF, 0xD0, 0xD7, 0x77, 0x6F, 0xE0, 0x77, 0x77, 0x50, 0x3F, 0xE0, 0x37, 0x77, 0x50,
  0x5F, 0xE7, 0x77, 0x60, 0x7F, 0xD0, 0xC7, 0x77, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x60, 0x9F, 0xD0,
  0xA7, 0x77, 0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77, 0x60, 0xAF, 0xD0, 0x87,
  0x77, 0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77,
  0x60, 0x7F, 0xD0, 0xE7, 0x77, 0x60, 0x5F, 0xE0, 0x17, 0x77, 0x50, 0x3F, 0xE0, 0x57, 0x77, 0x6F,
  0xE0, 0xA7, 0x77, 0x60, 0xDF, 0xE0, 0x27, 0x77, 0x50, 0x9F, 0xE0, 0xA7, 0x77, 0x50, 0x5F, 0xF0,
  0x57, 0x77, 0x03, 0x02, 0x3F, 0xF9, 0x05, 0x77, 0x48, 0x22, 0xAF, 0x43, 0x0A, 0xFF, 0x90, 0x87,
  0x71, 0x03, 0x0A, 0xB0, 0x43, 0x03, 0xFF, 0xA8, 0x1E, 0x72, 0x71, 0x82, 0x14, 0x8D, 0xD0, 0x44,
  0x0B, 0xFF, 0xC8, 0x6D, 0xB9, 0x88, 0xAB, 0xDF, 0xA0, 0x44, 0x03, 0xFF, 0xFF, 0xF0, 0x45, 0x08,
  0xFF, 0xFF, 0xE0, 0x46, 0x0C, 0xFF, 0xFF, 0xD0, 0x46, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x47, 0x02,
  0x0D, 0xFF, 0xFF, 0xB0, 0x47, 0x10, 0x10, 0xBF, 0xFF, 0xFA, 0x04, 0x73, 0x06, 0x0E, 0xFF, 0xFF,
  0x03, 0x74, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x18, 0x15, 0xAE, 0xFF, 0xB8, 0x1E,
  0xA5, 0x77, 0x78, 0x53, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x85, 0x37, 0x10,
  // "d" (U+0064)
  0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75,
  0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7,
  0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50,
  0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77,
  0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xAF, 0xD7, 0x77, 0x75, 0x0A,
  0xFD, 0x76, 0x84, 0x14, 0x8B, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x70, 0x8F, 0xD7, 0x40, 0x30, 0x9F,
  0xE0, 0xD0, 0x65, 0x07, 0xFD, 0x72, 0x01, 0x0A, 0xFF, 0xB0, 0xD0, 0x43, 0x05, 0xFD, 0x71, 0x04,
  0x0E, 0xFF, 0xE0, 0x82, 0x03, 0xFD, 0x70, 0x5F, 0xFF, 0xA8, 0x1A, 0x01, 0xFD, 0x60, 0x5F, 0xFF,
  0xC8, 0x19, 0x0E, 0xFC, 0x50, 0x30, 0xEF, 0xFF, 0xD0, 0x60, 0xCF, 0xC5, 0x0D, 0x80, 0xC4, 0xF4,
  0x08, 0x80, 0xC5, 0xF3, 0x02, 0x80, 0xC6, 0xF3, 0x08, 0xFF, 0xB8, 0x5E, 0xB9, 0x89, 0xBE, 0xFF,
  0xC3, 0x0E, 0xFF, 0x90, 0xB0, 0x47, 0x04, 0x0C, 0xFF, 0xA2, 0x06, 0xFF, 0x0E, 0x05, 0x74, 0x09,
  0xFF, 0x92, 0x0B, 0xFF, 0x04, 0x76, 0x0A, 0xFF, 0x2F, 0xF0, 0x77, 0x71, 0x0D, 0xFE, 0x10, 0x4F,
  0xE0, 0xD7, 0x72, 0x06, 0xFE, 0x10, 0x7F, 0xE0, 0x67, 0x73, 0xFE, 0x10, 0xAF, 0xE7, 0x74, 0x0A,
  0xFD, 0x10, 0xDF, 0xD0, 0xB7, 0x74, 0x07, 0xFD, 0x1F, 0xE0, 0x77, 0x74, 0x04, 0xFD, 0x01, 0xFE,
  0x04, 0x77, 0x40, 0x2F, 0xD0, 0x3F, 0xE0, 0x27, 0x75, 0x0E, 0xFC, 0x04, 0xFE, 0x77, 0x60, 0xDF,
  0xC0, 0x5F, 0xD0, 0xE7, 0x76, 0x0D, 0xFC, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xCF, 0xC0, 0x6F, 0xD0,
  0xD7, 0x76, 0x0B, 0xFC, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xBF, 0xC0, 0x5F, 0xD0, 0xD7, 0x76, 0x0B,
  0xFC, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xCF, 0xC0, 0x3F, 0xE7, 0x76, 0x0D, 0xFC, 0x02, 0xFE, 0x01,
  0x77, 0x50, 0xEF, 0xC1, 0xFE, 0x03, 0x77, 0x40, 0x1F, 0xD1, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x4F,
  0xD1, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0x8F, 0xD1, 0x08, 0xFE, 0x01, 0x77, 0x30, 0xDF, 0xD1, 0x05,
  0xFE, 0x07, 0x77, 0x20, 0x5F, 0xE1, 0x01, 0xFE, 0x0E, 0x01, 0x77, 0x10, 0xDF, 0xE2, 0x0C, 0xFE,
  0x0B, 0x77, 0x0A, 0xFF, 0x20, 0x7F, 0xF0, 0xB0, 0x17, 0x40, 0xAF, 0xF9, 0x20, 0x1F, 0xF9, 0x81,
  0xE6, 0x16, 0x81, 0x16, 0xEF, 0xFA, 0x30, 0xBF, 0xFB, 0x84, 0xCA, 0x88, 0xAC, 0xFF, 0xD3, 0x04,
  0x80, 0xC6, 0xF4, 0x0B, 0x80, 0xC5, 0xF4, 0x02, 0xFF, 0xFF, 0x0E, 0xFD, 0x50, 0x6F, 0xFF, 0xD0,
  0x70, 0x4F, 0xD6, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xDF, 0xC7, 0x0A, 0xFF, 0xF9, 0x0B, 0x30, 0x6F,
  0xC7, 0x10, 0xAF, 0xFE, 0x09, 0x50, 0xEF, 0xB7, 0x20, 0x50, 0xEF, 0xFA, 0x0D, 0x05, 0x60, 0x7F,
  0xB7, 0x38, 0x11, 0x7D, 0xFD, 0x0D, 0x06, 0x71, 0x01, 0xFB, 0x76, 0x83, 0x37, 0xBD, 0xEA, 0x83,
  0xEC, 0xA7, 0x27, 0x77,
  // "e" (U+0065)
  0x77, 0x28, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x78, 0x11, 0x7C, 0xFF,
  0x98, 0x1E, 0xA4, 0x77, 0x72, 0x01, 0x08, 0xFF, 0xF0, 0xC0, 0x47, 0x76, 0x07, 0xFF, 0xFC, 0x0B,
  0x01, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xE0, 0xE0, 0x47, 0x70, 0x20, 0xDF, 0xFF, 0xFA, 0x05, 0x75,
  0x02, 0x0E, 0xFF, 0xFF, 0xC0, 0x47, 0x30, 0x10, 0xDF, 0xFF, 0xFD, 0x0E, 0x02, 0x72, 0x0B, 0xFF,
  0xFF, 0xF0, 0xC7, 0x10, 0x68, 0x0C, 0x1F, 0x06, 0x60, 0x10, 0xEF, 0xFA, 0x84, 0xCA, 0x88, 0xAC,
  0xFF, 0x90, 0xE6, 0x08, 0xFF, 0x81, 0xD6, 0x16, 0x81, 0x17, 0xEF, 0xE0, 0x64, 0x01, 0xFF, 0x08,
  0x74, 0x01, 0x0B, 0xFD, 0x0C, 0x40, 0x6F, 0xE0, 0x57, 0x70, 0xAF, 0xD0, 0x23, 0x0C, 0xFD, 0x06,
  0x77, 0x20, 0xCF, 0xC0, 0x72, 0x02, 0xFD, 0x0C, 0x77, 0x30, 0x4F, 0xC0, 0xB2, 0x06, 0xFD, 0x05,
  0x77, 0x40, 0xDF, 0xB0, 0xE2, 0x0A, 0xFC, 0x0E, 0x77, 0x50, 0x8F, 0xC8, 0x11, 0x0D, 0xFC, 0x0B,
  0x77, 0x50, 0x5F, 0xC0, 0x31, 0xFD, 0x08, 0x77, 0x50, 0x3F, 0xC0, 0x50, 0x28, 0x0D, 0x0F, 0x06,
  0x04, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0,
  0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x07, 0x05, 0x80,
  0xD0, 0xF0, 0x70, 0x3F, 0xD0, 0x37, 0x77, 0x74, 0x02, 0xFD, 0x05, 0x77, 0x77, 0x50, 0xEF, 0xC0,
  0x87, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x50, 0x8F, 0xD0, 0x47, 0x77, 0x74, 0x04, 0xFD,
  0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x87, 0x77, 0x74, 0x09, 0xFE, 0x07, 0x77, 0x77, 0x30, 0x2F,
  0xF0, 0x97, 0x77, 0x28, 0x11, 0x6C, 0x50, 0xBF, 0xF0, 0xD0, 0x67, 0x74, 0x81, 0x26, 0xBB, 0x01,
  0x40, 0x3F, 0xFA, 0x81, 0xE9, 0x47, 0x48, 0x23, 0x59, 0xDE, 0x01, 0x50, 0x9F, 0xFD, 0x87, 0xDB,
  0x98, 0x89, 0xAB, 0xDF, 0xC0, 0x16, 0x0D, 0x80, 0xC2, 0xF0, 0x16, 0x02, 0x0E, 0x80, 0xC1, 0xF0,
  0x17, 0x04, 0x80, 0xC1, 0xF0, 0x17, 0x10, 0x40, 0xEF, 0xFF, 0xFF, 0x01, 0x72, 0x02, 0x0D, 0xFF,
  0xFF, 0xE0, 0x17, 0x30, 0x10, 0x9F, 0xFF, 0xFD, 0x01, 0x75, 0x04, 0x0C, 0xFF, 0xFF, 0xA0, 0xD7,
  0x71, 0x04, 0x0B, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x48, 0x11, 0x6B, 0xFF, 0xD8, 0x2E, 0xA5, 0x17,
  0x77, 0x38, 0x53, 0x69, 0xAC, 0xDE, 0xA8, 0x7E, 0xED, 0xCB, 0x97, 0x42, 0x72,
  // "f" (U+0066)
  0x77, 0x75, 0x89, 0x21, 0x45, 0x67, 0x87, 0x76, 0x64, 0x27, 0x77, 0x72, 0x82, 0x27, 0xBE, 0xFE,
  0x83, 0xEB, 0x85, 0x27, 0x77, 0x10, 0x40, 0xBF, 0xFF, 0x90, 0xD0, 0x97, 0x74, 0x01, 0x0B, 0xFF,
  0xFC, 0x0D, 0x77, 0x30, 0x40, 0xEF, 0xFF, 0xD0, 0x87, 0x72, 0x03, 0xFF, 0xFF, 0x02, 0x77, 0x10,
  0x10, 0xEF, 0xFF, 0xE0, 0xC7, 0x72, 0x0A, 0xFF, 0xFF, 0x07, 0x77, 0x10, 0x3F, 0xFF, 0xF9, 0x02,
  0x77, 0x10, 0x9F, 0xFF, 0xF0, 0xC7, 0x72, 0x0E, 0xFF, 0xFF, 0x06, 0x77, 0x10, 0x3F, 0xF9, 0x83,
  0xE9, 0x52, 0x12, 0x83, 0x13, 0x58, 0xBA, 0x01, 0x77, 0x10, 0x7F, 0xF0, 0xA0, 0x17, 0x50, 0x37,
  0x72, 0x09, 0xFE, 0x0A, 0x77, 0x77, 0x30, 0xBF, 0xD0, 0xE0, 0x17, 0x77, 0x73, 0x0C, 0xFD, 0x09,
  0x77, 0x77, 0x40, 0xCF, 0xD0, 0x57, 0x77, 0x74, 0x0C, 0xFD, 0x04, 0x77, 0x77, 0x40, 0xCF, 0xD0,
  0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x82, 0x36, 0xAD, 0xFF, 0xFF, 0x90, 0x17, 0x82,
  0x36, 0x9C, 0xFF, 0xFF, 0xE0, 0x13, 0x81, 0x59, 0xC8, 0x0C, 0x3F, 0x01, 0x30, 0xD8, 0x0C, 0x5F,
  0x01, 0x30, 0xD8, 0x0C, 0x5F, 0x01, 0x30, 0xD8, 0x0C, 0x5F, 0x01, 0x30, 0xD8, 0x0C, 0x5F, 0x01,
  0x30, 0xD8, 0x0C, 0x5F, 0x01, 0x30, 0xD8, 0x0C, 0x5F, 0x01, 0x30, 0xD8, 0x0C, 0x5F, 0x01, 0x30,
  0x78, 0x09, 0x08, 0x0E, 0xFD, 0x09, 0x80, 0x93, 0x87, 0x73, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40,
  0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74,
  0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77,
  0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77,
  0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77,
  0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37,
  0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03,
  0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0,
  0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD,
  0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF,
  0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C,
  0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40,
  0xCF, 0xD0, 0x37, 0x77, 0x74, 0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x77, 0x74,
  0x0C, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x37, 0x75,
  // "g" (U+0067)
  0x76, 0x83, 0x26, 0xAC, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x77, 0x74, 0x05, 0x0C, 0xFD, 0x0D, 0x06,
  0x71, 0x01, 0xFB, 0x72, 0x03, 0x0C, 0xFF, 0xA0, 0xD0, 0x56, 0x07, 0xFB, 0x71, 0x06, 0xFF, 0xE0,
  0x95, 0x0E, 0xFB, 0x70, 0x8F, 0xFF, 0x90, 0xB3, 0x06, 0xFC, 0x60, 0x7F, 0xFF, 0xB0, 0xB2, 0x0D,
  0xFC, 0x50, 0x4F, 0xFF, 0xD0, 0x90, 0x4F, 0xD4, 0x01, 0x0E, 0xFF, 0xFE, 0x0E, 0xFD, 0x40, 0x98,
  0x0C, 0x5F, 0x30, 0x28, 0x0C, 0x6F, 0x30, 0xAF, 0xFB, 0x84, 0xCA, 0x89, 0xAD, 0xFF, 0xD2, 0x01,
  0xFF, 0x98, 0x1E, 0x71, 0x60, 0x20, 0x8F, 0xFB, 0x20, 0x7F, 0xF0, 0xC0, 0x27, 0x30, 0x20, 0xDF,
  0xF9, 0x20, 0xCF, 0xE0, 0xD0, 0x17, 0x50, 0x20, 0xEF, 0xF1, 0x01, 0xFF, 0x03, 0x77, 0x05, 0xFF,
  0x10, 0x5F, 0xE0, 0xA7, 0x72, 0x0C, 0xFE, 0x10, 0x8F, 0xE0, 0x37, 0x72, 0x06, 0xFE, 0x10, 0xBF,
  0xD0, 0xD7, 0x73, 0x01, 0xFE, 0x10, 0xEF, 0xD0, 0x97, 0x74, 0x0D, 0xFD, 0x1F, 0xE0, 0x57, 0x74,
  0x0A, 0xFD, 0x02, 0xFE, 0x03, 0x77, 0x40, 0x7F, 0xD0, 0x3F, 0xE0, 0x17, 0x74, 0x06, 0xFD, 0x04,
  0xFD, 0x0E, 0x77, 0x50, 0x4F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D, 0x77,
  0x50, 0x3F, 0xD0, 0x6F, 0xD0, 0xD7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D, 0x77, 0x50, 0x2F, 0xD0,
  0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x3F, 0xE0, 0x17,
  0x74, 0x04, 0xFD, 0x02, 0xFE, 0x03, 0x77, 0x40, 0x5F, 0xD1, 0xFE, 0x05, 0x77, 0x40, 0x8F, 0xD1,
  0x0E, 0xFD, 0x09, 0x77, 0x40, 0xBF, 0xD1, 0x0B, 0xFD, 0x0E, 0x77, 0x40, 0xEF, 0xD1, 0x08, 0xFE,
  0x03, 0x77, 0x20, 0x4F, 0xE1, 0x05, 0xFE, 0x0B, 0x77, 0x20, 0xAF, 0xE1, 0x01, 0xFF, 0x04, 0x77,
  0x03, 0xFF, 0x20, 0xCF, 0xE0, 0xE0, 0x17, 0x50, 0x10, 0xDF, 0xF2, 0x07, 0xFF, 0x0D, 0x02, 0x73,
  0x01, 0x0C, 0xFF, 0x92, 0x01, 0xFF, 0xA0, 0x80, 0x26, 0x81, 0x16, 0xEF, 0xFA, 0x30, 0x9F, 0xFB,
  0x84, 0xCA, 0x98, 0xAC, 0xFF, 0xD3, 0x02, 0x80, 0xC6, 0xF4, 0x09, 0x80, 0xC5, 0xF4, 0x01, 0x0D,
  0x80, 0xC4, 0xF5, 0x04, 0xFF, 0xFD, 0x0B, 0x0C, 0xFD, 0x60, 0x6F, 0xFF, 0xB8, 0x1D, 0x1C, 0xFD,
  0x70, 0x7F, 0xFF, 0x98, 0x2D, 0x10, 0xEF, 0xD7, 0x10, 0x6F, 0xFE, 0x0C, 0x01, 0x2F, 0xE7, 0x20,
  0x20, 0xBF, 0xFB, 0x08, 0x4F, 0xE7, 0x40, 0x40, 0xBF, 0xD8, 0x1E, 0x91, 0x40, 0x1F, 0xE7, 0x68,
  0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xDB, 0x84, 0x70, 0x1F, 0xE7, 0x77, 0x74, 0x02, 0xFE, 0x77, 0x77,
  0x40, 0x3F, 0xD0, 0xE7, 0x77, 0x74, 0x04, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0x8F, 0xD0, 0xB7, 0x77,
  0x74, 0x0C, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x4F, 0xE0, 0x54, 0x09, 0x04, 0x77, 0x74, 0x0C, 0xFE,
  0x01, 0x4A, 0x81, 0xD8, 0x27, 0x77, 0x0B, 0xFE, 0x0C, 0x5D, 0x82, 0xD9, 0x51, 0x77, 0x10, 0x50,
  0xDF, 0xF0, 0x65, 0xFA, 0x85, 0xDA, 0x85, 0x32, 0x13, 0x83, 0x13, 0x69, 0xEF, 0xF9, 0x0E, 0x68,
  0x0C, 0x3F, 0x07, 0x68, 0x0C, 0x2F, 0x0D, 0x78, 0x0C, 0x2F, 0x04, 0x78, 0x0C, 0x1F, 0x07, 0x71,
  0x80, 0xC0, 0xF0, 0x87, 0x2F, 0xFF, 0xFF, 0x08, 0x73, 0xFF, 0xFF, 0xD0, 0xE0, 0x57, 0x4F, 0xFF,
  0xFC, 0x09, 0x01, 0x75, 0x05, 0x0A, 0xFF, 0xFE, 0x81, 0xE9, 0x27, 0x73, 0x81, 0x59, 0xCF, 0xFE,
  0x81, 0xDA, 0x57, 0x77, 0x38, 0x63, 0x68, 0x9B, 0xDD, 0xEB, 0x86, 0xEE, 0xCB, 0x97, 0x52, 0x77,
  0x20,
  // "h" (U+0068)
  0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFE, 0x77,
  0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFE, 0x77, 0x77, 0x4F,
  0xE7, 0x77, 0x74, 0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77,
  0x74, 0xFE, 0x77, 0x77, 0x4F, 0xE7, 0x77, 0x74, 0xFD, 0x0E, 0x77, 0x77, 0x4F, 0xD0, 0xE7, 0x77,
  0x74, 0xFD, 0x0E, 0x71, 0x89, 0x33, 0x7A, 0xCE, 0xEF, 0xEE, 0xCA, 0x73, 0x74, 0xFD, 0x0E, 0x60,
  0x60, 0xDF, 0xE8, 0x1D, 0x71, 0x71, 0xFD, 0x0D, 0x40, 0x40, 0xDF, 0xFB, 0x0E, 0x07, 0x7F, 0xD0,
  0xD3, 0x06, 0xFF, 0xF0, 0xB0, 0x15, 0xFD, 0x0C, 0x20, 0x7F, 0xFF, 0xA0, 0xC0, 0x14, 0xFD, 0x81,
  0xC0, 0x6F, 0xFF, 0xC0, 0xC4, 0xFD, 0x0B, 0x02, 0xFF, 0xFE, 0x08, 0x38, 0x0C, 0x6F, 0x02, 0x28,
  0x0C, 0x6F, 0x0A, 0x28, 0x0C, 0x7F, 0x01, 0x1F, 0xFE, 0x84, 0xCA, 0x98, 0xAC, 0xFF, 0xB0, 0x71,
  0xFF, 0xC0, 0x80, 0x26, 0x01, 0x08, 0xFF, 0x90, 0xB1, 0xFF, 0xA0, 0xD0, 0x37, 0x30, 0x30, 0xEF,
  0xE0, 0xE1, 0xFF, 0x90, 0xE0, 0x27, 0x50, 0x4F, 0xF0, 0x2F, 0xF9, 0x05, 0x77, 0x0A, 0xFE, 0x04,
  0xFF, 0x0C, 0x77, 0x10, 0x4F, 0xE0, 0x6F, 0xF0, 0x67, 0x72, 0xFE, 0x07, 0xFF, 0x01, 0x77, 0x20,
  0xDF, 0xD0, 0x7F, 0xE0, 0xC7, 0x73, 0x0A, 0xFD, 0x07, 0xFE, 0x09, 0x77, 0x30, 0x9F, 0xD0, 0x7F,
  0xE0, 0x67, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x04, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE0, 0x27, 0x73,
  0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x70,
  // "i" (U+0069)
  0x77, 0x58, 0x74, 0x9D, 0xEF, 0xED, 0x94, 0x77, 0x77, 0x60, 0x20, 0xCF, 0xA0, 0xC0, 0x27, 0x77,
  0x73, 0x01, 0x0D, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x9F, 0xE0, 0x97, 0x77, 0x71, 0x01, 0xFF,
  0x97, 0x77, 0x71, 0x04, 0xFF, 0x90, 0x47, 0x77, 0x70, 0x6F, 0xF9, 0x06, 0x77, 0x77, 0x07, 0xFF,
  0x90, 0x67, 0x77, 0x70, 0x6F, 0xF9, 0x05, 0x77, 0x77, 0x04, 0xFF, 0x90, 0x37, 0x77, 0x70, 0x1F,
  0xF0, 0xE7, 0x77, 0x72, 0x0A, 0xFE, 0x08, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xC0, 0xD0, 0x17, 0x77,
  0x73, 0x02, 0x0D, 0xFA, 0x0B, 0x01, 0x77, 0x77, 0x68, 0x75, 0xAD, 0xEF, 0xEC, 0x94, 0x80, 0xCB,
  0x50, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0,
  0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD,
  0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45, 0x79, 0xAC, 0xEF, 0xF9,
  0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8, 0x2E, 0x75, 0x27,
  0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF,
  0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80,
  0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  // "j" (U+006A)
  0x77, 0x73, 0x87, 0x6A, 0xDE, 0xFE, 0xC8, 0x37, 0x77, 0x50, 0x50, 0xEF, 0xA0, 0x97, 0x77, 0x30,
  0x4F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xE0, 0x57, 0x77, 0x05, 0xFF, 0x0B, 0x77, 0x70, 0x9F, 0xF0,
  0xE7, 0x77, 0x0B, 0xFF, 0x90, 0x17, 0x76, 0x0B, 0xFF, 0x90, 0x27, 0x76, 0x0B, 0xFF, 0x90, 0x17,
  0x76, 0x09, 0xFF, 0x0E, 0x77, 0x70, 0x5F, 0xF0, 0xA7, 0x77, 0x10, 0xEF, 0xE0, 0x47, 0x77, 0x10,
  0x5F, 0xD0, 0x97, 0x77, 0x30, 0x50, 0xEF, 0xA0, 0x87, 0x77, 0x58, 0x21, 0x7B, 0xDA, 0x82, 0xEB,
  0x82, 0x80, 0xBC, 0x60, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF,
  0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD,
  0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09, 0x72, 0x06, 0xFF, 0xFD, 0x09,
  0x72, 0x83, 0x28, 0xAC, 0xDF, 0xFF, 0x90, 0x97, 0x71, 0x86, 0x13, 0x56, 0x8A, 0xBD, 0xFE, 0x09,
  0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77,
  0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72,
  0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06,
  0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD,
  0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09,
  0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77,
  0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72,
  0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06,
  0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD,
  0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09,
  0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77,
  0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72, 0x06, 0xFD, 0x09, 0x77, 0x72,
  0x07, 0xFD, 0x09, 0x77, 0x72, 0x08, 0xFD, 0x09, 0x77, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C,
  0xFD, 0x08, 0x77, 0x72, 0x0E, 0xFD, 0x07, 0x77, 0x71, 0x03, 0xFE, 0x06, 0x77, 0x71, 0x09, 0xFE,
  0x04, 0x77, 0x70, 0x2F, 0xF0, 0x17, 0x76, 0x01, 0x0C, 0xFE, 0x0E, 0x28, 0x14, 0x73, 0x77, 0x10,
  0x40, 0xDF, 0xF0, 0xA2, 0x06, 0xB8, 0x5C, 0x97, 0x53, 0x21, 0x38, 0x21, 0x37, 0xCF, 0xFA, 0x05,
  0x20, 0x6F, 0xFF, 0xFC, 0x0E, 0x30, 0x6F, 0xFF, 0xFC, 0x09, 0x30, 0x6F, 0xFF, 0xFC, 0x01, 0x30,
  0x6F, 0xFF, 0xFB, 0x07, 0x40, 0x6F, 0xFF, 0xFA, 0x0B, 0x50, 0x6F, 0xFF, 0xF9, 0x0D, 0x01, 0x50,
  0x6F, 0xFF, 0xF0, 0xC0, 0x16, 0x06, 0xFF, 0xFE, 0x08, 0x71, 0x06, 0xFF, 0xFC, 0x0A, 0x02, 0x73,
  0x81, 0x48, 0xCF, 0xFD, 0x81, 0xD8, 0x27, 0x72, 0x87, 0x25, 0x79, 0xBC, 0xDE, 0xEA, 0x85, 0xED,
  0xCA, 0x85, 0x17, 0x70,
  // "k" (U+006B)
  0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77,
  0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77,
  0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77,
  0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07,
  0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0,
  0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x72, 0x02, 0x0E, 0xFE,
  0x82, 0xE2, 0x09, 0xFD, 0x07, 0x77, 0x20, 0xDF, 0xE0, 0xE0, 0x32, 0x09, 0xFD, 0x07, 0x77, 0x10,
  0xBF, 0xF0, 0x53, 0x09, 0xFD, 0x07, 0x77, 0x08, 0xFF, 0x07, 0x40, 0x9F, 0xD0, 0x77, 0x60, 0x6F,
  0xF0, 0x95, 0x09, 0xFD, 0x07, 0x75, 0x04, 0xFF, 0x0A, 0x60, 0x9F, 0xD0, 0x77, 0x40, 0x20, 0xEF,
  0xE0, 0xC7, 0x09, 0xFD, 0x07, 0x73, 0x01, 0x0D, 0xFE, 0x0D, 0x01, 0x70, 0x9F, 0xD0, 0x77, 0x30,
  0xBF, 0xE0, 0xE0, 0x27, 0x10, 0x9F, 0xD0, 0x77, 0x20, 0x9F, 0xF0, 0x47, 0x20, 0x9F, 0xD0, 0x77,
  0x10, 0x6F, 0xF0, 0x57, 0x30, 0x9F, 0xD0, 0x77, 0x04, 0xFF, 0x08, 0x74, 0x09, 0xFD, 0x07, 0x60,
  0x20, 0xEF, 0xE0, 0xA7, 0x50, 0x9F, 0xD0, 0x65, 0x01, 0x0D, 0xFE, 0x0B, 0x76, 0x09, 0xFD, 0x06,
  0x50, 0xBF, 0xE0, 0xD0, 0x17, 0x60, 0x9F, 0xD0, 0x64, 0x09, 0xFE, 0x0E, 0x02, 0x77, 0x09, 0xFD,
  0x05, 0x30, 0x5F, 0xE0, 0xE0, 0x37, 0x71, 0x09, 0xFD, 0x04, 0x20, 0x20, 0xEF, 0xE0, 0x57, 0x72,
  0x09, 0xFD, 0x82, 0x30, 0x1D, 0xFE, 0x06, 0x77, 0x30, 0x9F, 0xD8, 0x11, 0x0A, 0xFE, 0x09, 0x77,
  0x40, 0x9F, 0xD1, 0x06, 0xFE, 0x0B, 0x77, 0x50, 0x9F, 0xC0, 0xD0, 0x2F, 0xF0, 0xE0, 0x17, 0x74,
  0x09, 0xFC, 0x00, 0xCF, 0xF9, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xF9, 0x05, 0x77, 0x30, 0x9F, 0xFF,
  0xF9, 0x0E, 0x01, 0x77, 0x20, 0x9F, 0xFF, 0xFA, 0x0A, 0x77, 0x20, 0x9F, 0xFF, 0xFB, 0x05, 0x77,
  0x10, 0x9F, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xB7, 0x70, 0x9F, 0xFC, 0x08,
  0x03, 0xFE, 0x06, 0x76, 0x09, 0xFF, 0xA0, 0xE0, 0x42, 0x08, 0xFD, 0x0E, 0x02, 0x75, 0x09, 0xFF,
  0x90, 0xC0, 0x14, 0x0D, 0xFD, 0x0B, 0x75, 0x09, 0xFF, 0x08, 0x60, 0x3F, 0xE0, 0x77, 0x40, 0x9F,
  0xD0, 0xE0, 0x57, 0x10, 0x9F, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x77, 0x30, 0xDF, 0xD0, 0xC7, 0x30,
  0x9F, 0xD0, 0x77, 0x30, 0x4F, 0xE0, 0x77, 0x20, 0x9F, 0xD0, 0x77, 0x40, 0x9F, 0xE0, 0x27, 0x10,
  0x9F, 0xD0, 0x77, 0x50, 0xDF, 0xD0, 0xC7, 0x10, 0x9F, 0xD0, 0x77, 0x50, 0x4F, 0xE0, 0x87, 0x09,
  0xFD, 0x07, 0x76, 0x09, 0xFE, 0x03, 0x60, 0x9F, 0xD0, 0x77, 0x60, 0x10, 0xEF, 0xD0, 0xD6, 0x09,
  0xFD, 0x07, 0x77, 0x05, 0xFE, 0x08, 0x50, 0x9F, 0xD0, 0x77, 0x71, 0x0A, 0xFE, 0x03, 0x40, 0x9F,
  0xD0, 0x77, 0x71, 0x01, 0x0E, 0xFD, 0x0D, 0x40, 0x9F, 0xD0, 0x77, 0x72, 0x05, 0xFE, 0x09, 0x30,
  0x9F, 0xD0, 0x77, 0x73, 0x0A, 0xFE, 0x04, 0x20, 0x9F, 0xD0, 0x77, 0x73, 0x01, 0x0E, 0xFD, 0x82,
  0xD1, 0x09, 0xFD, 0x07, 0x77, 0x40, 0x5F, 0xE8, 0x19, 0x09, 0xFD, 0x07, 0x77, 0x50, 0xBF, 0xE0,
  0x40,
  // "l" (U+006C)
  0x30, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7,
  0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A,
  0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x50, 0xDF, 0xFF,
  0xB0, 0xA7, 0x76, 0x83, 0x14, 0x7A, 0xDF, 0xFD, 0x0A, 0x77, 0x74, 0x83, 0x14, 0x7B, 0xEF, 0xF0,
  0xA7, 0x77, 0x72, 0x01, 0x08, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77,
  0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7,
  0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A,
  0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0,
  0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD,
  0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F,
  0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x78, 0x21, 0x46, 0xBF, 0xD8, 0x2D, 0x74, 0x17, 0x75, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xE8, 0x3E,
  0xB9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7,
  0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09,
  0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F,
  0x07,
  // "m" (U+006D)
  0x77, 0x28, 0x72, 0x8B, 0xEF, 0xED, 0xA5, 0x73, 0x89, 0x01, 0x6B, 0xDE, 0xFD, 0xB7, 0x15, 0x04,
  0xF9, 0x09, 0x50, 0x9F, 0xA0, 0xD0, 0x37, 0x06, 0x0E, 0xF9, 0x0E, 0x05, 0x40, 0x4F, 0x90, 0xD4,
  0x0B, 0xFD, 0x03, 0x50, 0x8F, 0xD0, 0x53, 0x04, 0xFA, 0x01, 0x20, 0x8F, 0xE0, 0xD4, 0x06, 0xFE,
  0x0E, 0x01, 0x20, 0x4F, 0xA8, 0x15, 0x03, 0xFF, 0x90, 0x72, 0x02, 0xFF, 0x90, 0x82, 0x04, 0xFA,
  0x81, 0x90, 0xAF, 0xF9, 0x0D, 0x20, 0xBF, 0xF9, 0x0D, 0x20, 0x4F, 0xA0, 0xD0, 0x3F, 0xFB, 0x03,
  0x04, 0xFF, 0xB8, 0x12, 0x04, 0xFF, 0xFF, 0x07, 0x0B, 0xFF, 0xB8, 0x16, 0x04, 0x80, 0xD3, 0xF8,
  0x19, 0x04, 0x80, 0xD3, 0xF8, 0x1B, 0x04, 0xFE, 0x82, 0xC9, 0x8C, 0xFF, 0x98, 0x2B, 0x89, 0xDF,
  0xC8, 0x1D, 0x04, 0xFD, 0x06, 0x40, 0x8F, 0xE0, 0x44, 0x0B, 0xFC, 0x10, 0x4F, 0xC0, 0xB6, 0xFD,
  0x08, 0x50, 0x4F, 0xC0, 0x10, 0x4F, 0xC0, 0x56, 0x0C, 0xFC, 0x03, 0x50, 0x1F, 0xC0, 0x20, 0x4F,
  0xC0, 0x26, 0x0A, 0xFC, 0x7F, 0xC0, 0x30, 0x4F, 0xC0, 0x16, 0x0A, 0xFB, 0x0D, 0x70, 0xEF, 0xB0,
  0x30, 0x4F, 0xC7, 0x0A, 0xFB, 0x0C, 0x70, 0xEF, 0xB0, 0x04, 0xFC, 0x70, 0xAF, 0xB0, 0xC7, 0x0E,
  0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF,
  0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB,
  0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF,
  0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB,
  0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0,
  0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB,
  0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0,
  0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E,
  0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0,
  0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B,
  0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7,
  0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00,
  0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7,
  0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70,
  0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04,
  0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70,
  0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F, 0xB0, 0xE7, 0x0A,
  0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E, 0xFB, 0x00, 0x4F,
  0xB0, 0xE7, 0x0A, 0xFB, 0x0B, 0x70, 0xEF, 0xB0, 0x04, 0xFB, 0x0E, 0x70, 0xAF, 0xB0, 0xB7, 0x0E,
  0xFB, 0x04,
  // "n" (U+006E)
  0x77, 0x78, 0x43, 0x7A, 0xCE, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x4F, 0xA0, 0xE7, 0x18, 0x12, 0x8E,
  0xFE, 0x81, 0xE8, 0x27, 0x1F, 0xB0, 0x56, 0x08, 0xFF, 0xD0, 0x87, 0xFB, 0x0B, 0x40, 0x20, 0xDF,
  0xFF, 0x0C, 0x01, 0x5F, 0xC0, 0x12, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x01, 0x4F, 0xC8, 0x26, 0x02,
  0xEF, 0xFF, 0xC0, 0xC4, 0xFC, 0x81, 0xC0, 0xCF, 0xFF, 0xE0, 0x93, 0xFD, 0x0E, 0xFF, 0xFF, 0x90,
  0x32, 0x80, 0xC6, 0xF0, 0xB2, 0x80, 0xC7, 0xF0, 0x11, 0xFF, 0xE8, 0x4D, 0xA8, 0x8A, 0xDF, 0xFB,
  0x07, 0x1F, 0xFC, 0x09, 0x02, 0x60, 0x20, 0xAF, 0xF9, 0x0B, 0x1F, 0xFB, 0x05, 0x73, 0x05, 0xFF,
  0x0E, 0x1F, 0xFA, 0x05, 0x75, 0x07, 0xFF, 0x02, 0xFF, 0x90, 0x97, 0x70, 0xCF, 0xE0, 0x4F, 0xF9,
  0x01, 0x77, 0x06, 0xFE, 0x06, 0xFF, 0x0A, 0x77, 0x10, 0x1F, 0xE0, 0x7F, 0xF0, 0x47, 0x72, 0x0D,
  0xFD, 0x07, 0xFF, 0x77, 0x30, 0xBF, 0xD0, 0x7F, 0xE0, 0xB7, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x08,
  0x77, 0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x57, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x03, 0x77, 0x30, 0x8F,
  0xD0, 0x7F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  // "o" (U+006F)
  0x77, 0x38, 0x95, 0x36, 0x9B, 0xDE, 0xEF, 0xEE, 0xCA, 0x84, 0x17, 0x77, 0x72, 0x81, 0x39, 0xEF,
  0xF9, 0x0B, 0x06, 0x77, 0x75, 0x04, 0x0C, 0xFF, 0xE0, 0xE0, 0x87, 0x77, 0x10, 0x20, 0xBF, 0xFF,
  0xB0, 0xE0, 0x57, 0x75, 0x06, 0x0E, 0xFF, 0xFE, 0x09, 0x77, 0x30, 0x8F, 0xFF, 0xFA, 0x0C, 0x01,
  0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x8F, 0xFF, 0xFE, 0x0B, 0x74, 0x05, 0x80, 0xC0,
  0xF0, 0x97, 0x20, 0x10, 0xE8, 0x0C, 0x1F, 0x04, 0x71, 0x0A, 0xFF, 0xA8, 0x4D, 0xB9, 0x89, 0xCF,
  0xFA, 0x0D, 0x70, 0x3F, 0xF9, 0x0A, 0x03, 0x68, 0x11, 0x7E, 0xFF, 0x06, 0x60, 0xBF, 0xE0, 0xE0,
  0x57, 0x30, 0x10, 0xCF, 0xE0, 0xE5, 0x02, 0xFF, 0x04, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x40, 0x8F,
  0xE0, 0x77, 0x70, 0x4F, 0xE0, 0xB4, 0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xE3, 0x03, 0xFE, 0x06,
  0x77, 0x20, 0x4F, 0xE0, 0x52, 0x07, 0xFE, 0x77, 0x40, 0xEF, 0xD0, 0x82, 0x0B, 0xFD, 0x0B, 0x77,
  0x40, 0xAF, 0xD0, 0xB2, 0x0D, 0xFD, 0x06, 0x77, 0x40, 0x6F, 0xD0, 0xE2, 0xFE, 0x04, 0x77, 0x40,
  0x3F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x74, 0x01, 0xFE, 0x02, 0x04, 0xFE, 0x77, 0x6F, 0xE0, 0x04,
  0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x50, 0x6F, 0xD0,
  0xD7, 0x76, 0x0D, 0xFD, 0x06, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x05, 0xFD, 0x0E, 0x77,
  0x60, 0xEF, 0xD0, 0x04, 0xFE, 0x77, 0x6F, 0xE0, 0x40, 0x3F, 0xE0, 0x17, 0x74, 0x01, 0xFE, 0x02,
  0x01, 0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE2, 0x0E, 0xFD, 0x07, 0x77, 0x40, 0x6F, 0xD0, 0xD2, 0x0B,
  0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2, 0x08, 0xFE, 0x01, 0x77, 0x30, 0xEF, 0xD0, 0x72, 0x04,
  0xFE, 0x06, 0x77, 0x20, 0x5F, 0xE0, 0x33, 0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xD0, 0xE4, 0x0A,
  0xFE, 0x07, 0x77, 0x05, 0xFE, 0x09, 0x40, 0x3F, 0xF0, 0x47, 0x50, 0x20, 0xEF, 0xE0, 0x35, 0x0C,
  0xFE, 0x0E, 0x05, 0x73, 0x03, 0x0D, 0xFE, 0x0C, 0x60, 0x5F, 0xF9, 0x0A, 0x03, 0x60, 0x10, 0x7F,
  0xF9, 0x05, 0x70, 0xBF, 0xFA, 0x84, 0xDA, 0x98, 0xAC, 0xFF, 0xA0, 0xC7, 0x10, 0x28, 0x0C, 0x2F,
  0x03, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0xAF, 0xFF, 0xFE, 0x0B, 0x76, 0x0B, 0xFF, 0xFF,
  0xC0, 0xC7, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xB7, 0x73, 0x07, 0xFF, 0xFF, 0x09, 0x77, 0x50, 0x30,
  0xDF, 0xFF, 0xB0, 0xE0, 0x57, 0x77, 0x10, 0x60, 0xDF, 0xFE, 0x0E, 0x07, 0x77, 0x75, 0x81, 0x5A,
  0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x77, 0x38, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17,
  0x72,
  // "p" (U+0070)
  0x77, 0x78, 0x92, 0x26, 0x9C, 0xEE, 0xFE, 0xDB, 0x74, 0x76, 0xFB, 0x72, 0x06, 0x0C, 0xFD, 0x81,
  0xE7, 0x17, 0x3F, 0xB0, 0x66, 0x06, 0x0E, 0xFF, 0xA0, 0xE0, 0x57, 0x2F, 0xB0, 0xB4, 0x01, 0x0B,
  0xFF, 0xE0, 0x97, 0x1F, 0xC0, 0x12, 0x02, 0x0D, 0xFF, 0xF9, 0x0A, 0x7F, 0xC8, 0x27, 0x01, 0xDF,
  0xFF, 0xB0, 0x96, 0xFC, 0x81, 0xD0, 0xBF, 0xFF, 0xD0, 0x65, 0xFD, 0x0D, 0xFF, 0xFF, 0x02, 0x48,
  0x0C, 0x5F, 0x0A, 0x48, 0x0C, 0x6F, 0x03, 0x3F, 0xFE, 0x84, 0xBA, 0x89, 0xBE, 0xFF, 0xA0, 0xA3,
  0xFF, 0xB8, 0x1E, 0x61, 0x60, 0x50, 0xDF, 0xF9, 0x01, 0x2F, 0xFA, 0x0B, 0x01, 0x72, 0x01, 0x0B,
  0xFF, 0x07, 0x2F, 0xF9, 0x0C, 0x75, 0x01, 0x0D, 0xFE, 0x0B, 0x2F, 0xF0, 0xE0, 0x17, 0x60, 0x3F,
  0xF0, 0x11, 0xFF, 0x07, 0x77, 0x10, 0xBF, 0xE0, 0x51, 0xFE, 0x0E, 0x77, 0x20, 0x5F, 0xE0, 0x81,
  0xFE, 0x0A, 0x77, 0x3F, 0xE0, 0xB1, 0xFE, 0x05, 0x77, 0x30, 0xBF, 0xD0, 0xD1, 0xFE, 0x02, 0x77,
  0x30, 0x8F, 0xE1, 0xFD, 0x0E, 0x77, 0x40, 0x6F, 0xE0, 0x2F, 0xD0, 0xD7, 0x74, 0x04, 0xFE, 0x03,
  0xFD, 0x0C, 0x77, 0x40, 0x3F, 0xE0, 0x4F, 0xD0, 0xB7, 0x74, 0x02, 0xFE, 0x05, 0xFD, 0x0B, 0x77,
  0x40, 0x1F, 0xE0, 0x5F, 0xD0, 0xB7, 0x74, 0x01, 0xFE, 0x06, 0xFD, 0x0B, 0x77, 0x40, 0x1F, 0xE0,
  0x5F, 0xD0, 0xC7, 0x74, 0x02, 0xFE, 0x05, 0xFD, 0x0D, 0x77, 0x40, 0x3F, 0xE0, 0x4F, 0xD0, 0xE7,
  0x74, 0x04, 0xFE, 0x03, 0xFE, 0x01, 0x77, 0x30, 0x6F, 0xE0, 0x2F, 0xE0, 0x47, 0x73, 0x08, 0xFE,
  0x1F, 0xE0, 0x77, 0x73, 0x0B, 0xFD, 0x0D, 0x1F, 0xE0, 0xB7, 0x73, 0x0E, 0xFD, 0x0B, 0x1F, 0xF0,
  0x27, 0x71, 0x04, 0xFE, 0x08, 0x1F, 0xF0, 0x97, 0x71, 0x0A, 0xFE, 0x04, 0x1F, 0xF9, 0x02, 0x76,
  0x02, 0xFF, 0x2F, 0xF9, 0x0D, 0x01, 0x75, 0x0C, 0xFE, 0x0B, 0x2F, 0xFA, 0x0C, 0x02, 0x73, 0x0A,
  0xFF, 0x06, 0x2F, 0xFB, 0x81, 0xE7, 0x16, 0x04, 0x0D, 0xFF, 0x0E, 0x3F, 0xFE, 0x84, 0xCA, 0x89,
  0xBE, 0xFF, 0xA0, 0x83, 0x80, 0xC5, 0xF0, 0xE0, 0x13, 0x80, 0xC5, 0xF0, 0x74, 0x80, 0xC4, 0xF0,
  0xC5, 0xFD, 0x0E, 0xFF, 0xFD, 0x0E, 0x02, 0x5F, 0xD0, 0x20, 0xAF, 0xFF, 0xC0, 0x56, 0xFD, 0x81,
  0x40, 0xAF, 0xFF, 0xA0, 0x57, 0xFD, 0x06, 0x20, 0x7F, 0xFE, 0x0E, 0x04, 0x71, 0xFD, 0x08, 0x30,
  0x20, 0xBF, 0xFB, 0x0A, 0x01, 0x72, 0xFD, 0x09, 0x58, 0x13, 0x9E, 0xFD, 0x0B, 0x04, 0x74, 0xFD,
  0x0A, 0x71, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xEC, 0x96, 0x17, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0xFD,
  0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77,
  0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0,
  0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77,
  0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B,
  0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75,
  0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75,
  // "q" (U+0071)
  0x76, 0x89, 0x22, 0x69, 0xCD, 0xEF, 0xED, 0xB8, 0x47, 0x77, 0x74, 0x05, 0x0C, 0xFD, 0x81, 0xE9,
  0x37, 0x10, 0xEF, 0xA7, 0x20, 0x30, 0xDF, 0xFB, 0x0A, 0x02, 0x50, 0x4F, 0xB7, 0x10, 0x7F, 0xFE,
  0x0E, 0x05, 0x40, 0x9F, 0xB7, 0x08, 0xFF, 0xFA, 0x07, 0x30, 0xEF, 0xB6, 0x07, 0xFF, 0xFC, 0x81,
  0x70, 0x3F, 0xC5, 0x04, 0xFF, 0xFE, 0x05, 0x08, 0xFC, 0x40, 0x10, 0xE8, 0x0C, 0x4F, 0x40, 0x98,
  0x0C, 0x5F, 0x30, 0x28, 0x0C, 0x6F, 0x30, 0xAF, 0xFB, 0x84, 0xCA, 0x89, 0xAD, 0xFF, 0xD2, 0x01,
  0xFF, 0xA0, 0x80, 0x26, 0x03, 0x0B, 0xFF, 0xB2, 0x06, 0xFF, 0x0E, 0x04, 0x73, 0x05, 0xFF, 0xA2,
  0x0B, 0xFF, 0x03, 0x75, 0x05, 0xFF, 0x92, 0xFF, 0x07, 0x77, 0x08, 0xFF, 0x10, 0x4F, 0xE0, 0xE7,
  0x72, 0x0E, 0xFE, 0x10, 0x7F, 0xE0, 0x77, 0x72, 0x07, 0xFE, 0x10, 0xAF, 0xE0, 0x27, 0x72, 0x02,
  0xFE, 0x10, 0xDF, 0xD0, 0xD7, 0x74, 0x0D, 0xFD, 0x1F, 0xE0, 0xA7, 0x74, 0x09, 0xFD, 0x01, 0xFE,
  0x07, 0x77, 0x40, 0x7F, 0xD0, 0x3F, 0xE0, 0x57, 0x74, 0x05, 0xFD, 0x04, 0xFE, 0x03, 0x77, 0x40,
  0x3F, 0xD0, 0x5F, 0xE0, 0x27, 0x74, 0x02, 0xFD, 0x05, 0xFE, 0x02, 0x77, 0x40, 0x1F, 0xD0, 0x6F,
  0xE0, 0x17, 0x74, 0x01, 0xFD, 0x05, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x5F, 0xE0, 0x27, 0x74,
  0x01, 0xFD, 0x04, 0xFE, 0x03, 0x77, 0x40, 0x2F, 0xD0, 0x3F, 0xE0, 0x47, 0x74, 0x03, 0xFD, 0x02,
  0xFE, 0x06, 0x77, 0x40, 0x4F, 0xD1, 0xFE, 0x09, 0x77, 0x40, 0x7F, 0xD1, 0x0E, 0xFD, 0x0C, 0x77,
  0x40, 0xAF, 0xD1, 0x0B, 0xFE, 0x01, 0x77, 0x30, 0xEF, 0xD1, 0x08, 0xFE, 0x06, 0x77, 0x20, 0x4F,
  0xE1, 0x05, 0xFE, 0x0D, 0x77, 0x20, 0xBF, 0xE1, 0x01, 0xFF, 0x05, 0x77, 0x04, 0xFF, 0x20, 0xCF,
  0xE0, 0xE0, 0x27, 0x50, 0x10, 0xDF, 0xF2, 0x07, 0xFF, 0x0D, 0x02, 0x73, 0x02, 0x0C, 0xFF, 0x92,
  0x01, 0xFF, 0xA0, 0x70, 0x16, 0x81, 0x17, 0xEF, 0xFA, 0x30, 0xBF, 0xFB, 0x84, 0xCA, 0x89, 0xAC,
  0xFF, 0xD3, 0x04, 0x80, 0xC6, 0xF4, 0x0B, 0x80, 0xC5, 0xF4, 0x02, 0x80, 0xC5, 0xF5, 0x06, 0xFF,
  0xFD, 0x0C, 0x04, 0xFD, 0x60, 0xAF, 0xFF, 0xB8, 0x1E, 0x25, 0xFD, 0x70, 0xAF, 0xFF, 0x98, 0x2E,
  0x30, 0x7F, 0xD7, 0x10, 0xAF, 0xFE, 0x0C, 0x02, 0x20, 0x8F, 0xD7, 0x20, 0x50, 0xEF, 0xFA, 0x0E,
  0x07, 0x40, 0x9F, 0xD7, 0x38, 0x11, 0x7D, 0xFD, 0x81, 0xD7, 0x15, 0x0A, 0xFD, 0x76, 0x83, 0x47,
  0xBD, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x10, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50,
  0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77,
  0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B,
  0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77,
  0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF,
  0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x77,
  0x50, 0xBF, 0xD7, 0x77, 0x75, 0x0B, 0xFD,
  // "r" (U+0072)
  0x77, 0x77, 0x78, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xCB, 0x85, 0x15, 0x0D, 0xFF, 0xD0, 0x77, 0x20,
  0x50, 0xCF, 0xE0, 0xA0, 0x23, 0x0D, 0xFF, 0xD0, 0xA7, 0x02, 0x0B, 0xFF, 0xA0, 0x33, 0x0D, 0xFF,
  0xD0, 0xE6, 0x04, 0x0E, 0xFF, 0xA0, 0xE4, 0x0D, 0xFF, 0xE0, 0x24, 0x05, 0xFF, 0xC0, 0xA4, 0x0D,
  0xFF, 0xE0, 0x53, 0x04, 0xFF, 0xD0, 0x64, 0x0D, 0xFF, 0xE0, 0x92, 0x02, 0x0E, 0xFF, 0xD0, 0x14,
  0x0D, 0xFF, 0xE0, 0xC2, 0x0C, 0xFF, 0xD0, 0xC5, 0x0D, 0xFF, 0xF1, 0x07, 0xFF, 0xE0, 0x85, 0x0D,
  0xFF, 0xF0, 0x80, 0xEF, 0xFE, 0x04, 0x58, 0x18, 0xCE, 0x80, 0xC4, 0xF0, 0xE7, 0x28, 0x41, 0x36,
  0x8A, 0xDF, 0xFF, 0xFE, 0x0B, 0x77, 0x20, 0x9F, 0xFF, 0xFC, 0x06, 0x77, 0x20, 0x8F, 0xFD, 0x83,
  0xEA, 0x53, 0x12, 0x85, 0x12, 0x58, 0xBF, 0x27, 0x72, 0x08, 0xFF, 0xC0, 0x87, 0x50, 0x17, 0x73,
  0x08, 0xFF, 0xA0, 0xD0, 0x27, 0x77, 0x73, 0x08, 0xFF, 0x90, 0xD0, 0x27, 0x77, 0x74, 0x08, 0xFF,
  0x90, 0x37, 0x77, 0x75, 0x08, 0xFF, 0x09, 0x77, 0x77, 0x60, 0x8F, 0xF0, 0x17, 0x77, 0x76, 0x08,
  0xFE, 0x09, 0x77, 0x77, 0x70, 0x8F, 0xE0, 0x47, 0x77, 0x77, 0x08, 0xFE, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0xC8, 0x0C, 0x00, 0x08, 0xFD, 0x0A, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x08,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00,
  0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C,
  0x00, 0x08, 0xFD, 0x08, 0x77, 0x77, 0x68, 0x13, 0x6C, 0xFD, 0x81, 0xC6, 0x37, 0x77, 0x68, 0x22,
  0x59, 0xCF, 0xFE, 0x82, 0xC9, 0x62, 0x77, 0x38, 0x32, 0x58, 0xBE, 0xFF, 0xFF, 0x83, 0xEB, 0x85,
  0x27, 0x40, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F,
  0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2,
  0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30,
  // "s" (U+0073)
  0x75, 0x8A, 0x02, 0x58, 0xAC, 0xDE, 0xEF, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x75, 0x81, 0x39, 0xDF,
  0xFD, 0x81, 0xB8, 0x47, 0x60, 0x50, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x71, 0x01, 0x0B, 0xFF, 0xFF,
  0xA8, 0x1E, 0x92, 0x40, 0x30, 0xEF, 0xFF, 0xFD, 0x07, 0x30, 0x30, 0xEF, 0xFF, 0xFE, 0x01, 0x20,
  0x10, 0xEF, 0xFF, 0xFE, 0x0A, 0x30, 0xAF, 0xFF, 0xFF, 0x03, 0x20, 0x3F, 0xFF, 0xFF, 0x0C, 0x30,
  0x9F, 0xFF, 0xFF, 0x06, 0x30, 0xEF, 0xF8, 0x7E, 0xB9, 0x88, 0x9A, 0xBC, 0xFC, 0x0E, 0x01, 0x20,
  0x2F, 0xE0, 0xD0, 0x47, 0x38, 0x22, 0x59, 0xDE, 0x09, 0x30, 0x4F, 0xE0, 0x37, 0x71, 0x81, 0x26,
  0xBB, 0x03, 0x30, 0x5F, 0xD0, 0xE7, 0x75, 0x81, 0x17, 0xA4, 0x06, 0xFE, 0x77, 0x75, 0x06, 0xFE,
  0x05, 0x77, 0x74, 0x04, 0xFE, 0x0E, 0x03, 0x77, 0x73, 0x02, 0xFF, 0x90, 0xA0, 0x37, 0x77, 0x20,
  0xEF, 0xFA, 0x81, 0xC6, 0x17, 0x76, 0x09, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x02, 0xFF, 0xF8, 0x1E,
  0x93, 0x77, 0x20, 0x8F, 0xFF, 0xA0, 0xC0, 0x67, 0x71, 0x0C, 0xFF, 0xFB, 0x81, 0xE8, 0x17, 0x50,
  0x10, 0xCF, 0xFF, 0xC8, 0x1E, 0x81, 0x75, 0x0A, 0xFF, 0xFD, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFF,
  0xFD, 0x0B, 0x01, 0x74, 0x81, 0x17, 0xEF, 0xFF, 0xC0, 0xC0, 0x17, 0x58, 0x11, 0x8E, 0xFF, 0xFB,
  0x0C, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xA0, 0x97, 0x72, 0x04, 0x0A, 0xFF, 0xF9, 0x03, 0x77, 0x38,
  0x11, 0x7D, 0xFF, 0xD0, 0xB7, 0x76, 0x04, 0x0A, 0xFF, 0xC0, 0x17, 0x77, 0x81, 0x18, 0xEF, 0xF9,
  0x05, 0x77, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x74, 0x06, 0xFE, 0x0A, 0x77, 0x75, 0x0D, 0xFD, 0x81,
  0xB7, 0x37, 0x77, 0x30, 0xAF, 0xD8, 0x4C, 0xCF, 0xC6, 0x17, 0x77, 0x0B, 0xFD, 0x0B, 0x0C, 0xC8,
  0x1C, 0x72, 0x77, 0x30, 0x3F, 0xE0, 0xA0, 0xCF, 0x82, 0xD9, 0x63, 0x74, 0x81, 0x17, 0xEF, 0xE0,
  0x80, 0xCF, 0xD8, 0x90, 0xDC, 0xA9, 0x88, 0x89, 0xAD, 0xFF, 0xA0, 0x40, 0xC8, 0x0C, 0x1F, 0x81,
  0xE0, 0xC8, 0x0C, 0x1F, 0x81, 0x90, 0xC8, 0x0C, 0x0F, 0x82, 0xE1, 0x0C, 0x80, 0xC0, 0xF0, 0x62,
  0x0C, 0xFF, 0xFF, 0xF0, 0x93, 0x0C, 0xFF, 0xFF, 0xE0, 0x84, 0x0C, 0xFF, 0xFF, 0xC0, 0xD0, 0x45,
  0x81, 0x4A, 0xEF, 0xFF, 0xF0, 0xD0, 0x67, 0x38, 0x24, 0x8B, 0xEF, 0xFF, 0x81, 0xC8, 0x37, 0x72,
  0x87, 0x25, 0x79, 0xAC, 0xDD, 0xEB, 0x86, 0xEE, 0xDC, 0xA8, 0x63, 0x76,
  // "t" (U+0074)
  0x77, 0x10, 0xEF, 0xA0, 0x17, 0x77, 0x74, 0x01, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x4F, 0xB0, 0x17,
  0x77, 0x74, 0x07, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x9F, 0xB0, 0x17, 0x77, 0x74, 0x0C, 0xFB, 0x01,
  0x77, 0x77, 0x4F, 0xC0, 0x17, 0x77, 0x73, 0x02, 0xFC, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xC0, 0x17,
  0x77, 0x73, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0x17, 0x77, 0x73, 0x0D, 0xFC, 0x01,
  0x77, 0x76, 0x82, 0x36, 0x9D, 0xFF, 0xFF, 0xA0, 0x84, 0x82, 0x15, 0x8B, 0xFF, 0xFF, 0xF8, 0x38,
  0x17, 0xAE, 0x80, 0xC3, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38,
  0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0,
  0x80, 0x38, 0x0C, 0x6F, 0x08, 0x01, 0x80, 0x78, 0xFE, 0x80, 0x96, 0x80, 0x47, 0x5F, 0xE0, 0x17,
  0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F,
  0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77,
  0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE,
  0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77,
  0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0,
  0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77,
  0x20, 0xEF, 0xD0, 0x37, 0x77, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x77, 0x20, 0xCF, 0xD0, 0xC7, 0x77,
  0x72, 0x0A, 0xFE, 0x05, 0x77, 0x77, 0x10, 0x7F, 0xE0, 0xE0, 0x37, 0x77, 0x70, 0x4F, 0xF9, 0x08,
  0x02, 0x72, 0x83, 0x14, 0x79, 0xC7, 0x60, 0xEF, 0xFA, 0x87, 0xEA, 0x98, 0x89, 0xAC, 0xED, 0x76,
  0x0A, 0xFF, 0xFF, 0xA7, 0x60, 0x3F, 0xFF, 0xFA, 0x77, 0x0B, 0xFF, 0xFF, 0x97, 0x70, 0x20, 0xEF,
  0xFF, 0xF7, 0x71, 0x05, 0xFF, 0xFF, 0x77, 0x20, 0x6F, 0xFF, 0xE7, 0x73, 0x04, 0x0E, 0xFF, 0xFC,
  0x77, 0x40, 0x10, 0x8F, 0xFF, 0xB7, 0x76, 0x81, 0x17, 0xCF, 0xFC, 0x81, 0xC8, 0x37, 0x77, 0x28,
  0x51, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x86, 0x34,
  // "u" (U+0075)
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F, 0xE0,
  0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7, 0x72,
  0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x02,
  0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02, 0x0D, 0xFF, 0xA1, 0x0B,
  0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0xFE,
  0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F, 0x30, 0x9F, 0xFF, 0xE8,
  0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01, 0x0D, 0xFF, 0xFA, 0x0E,
  0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB, 0x70, 0x8F, 0xFC, 0x0E,
  0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72, 0xFB, 0x74, 0x83, 0x48, 0xBD,
  0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x70,
  // "v" (U+0076)
  0x0E, 0xFD, 0x0E, 0x77, 0x71, 0x0B, 0xFD, 0x0E, 0x0A, 0xFE, 0x04, 0x77, 0x7F, 0xE0, 0x90, 0x4F,
  0xE0, 0x97, 0x76, 0x05, 0xFE, 0x81, 0x40, 0xDF, 0xD0, 0xE7, 0x76, 0x0A, 0xFD, 0x0D, 0x20, 0x8F,
  0xE0, 0x47, 0x75, 0x0E, 0xFD, 0x08, 0x20, 0x2F, 0xE0, 0x97, 0x74, 0x04, 0xFE, 0x02, 0x30, 0xCF,
  0xD0, 0xD7, 0x74, 0x09, 0xFD, 0x0B, 0x40, 0x6F, 0xE0, 0x37, 0x73, 0x0E, 0xFD, 0x06, 0x40, 0x1F,
  0xE0, 0x87, 0x72, 0x03, 0xFD, 0x0E, 0x60, 0xAF, 0xD0, 0xD7, 0x72, 0x08, 0xFD, 0x09, 0x60, 0x4F,
  0xE0, 0x27, 0x71, 0x0D, 0xFD, 0x04, 0x70, 0xEF, 0xD0, 0x77, 0x70, 0x2F, 0xD0, 0xD7, 0x10, 0x8F,
  0xD0, 0xC7, 0x70, 0x7F, 0xD0, 0x87, 0x10, 0x2F, 0xE0, 0x27, 0x60, 0xCF, 0xD0, 0x27, 0x20, 0xCF,
  0xD0, 0x77, 0x50, 0x1F, 0xD0, 0xB7, 0x30, 0x6F, 0xD0, 0xB7, 0x50, 0x6F, 0xD0, 0x67, 0x30, 0x1F,
  0xE0, 0x17, 0x40, 0xBF, 0xC0, 0xE7, 0x50, 0xAF, 0xD0, 0x67, 0x30, 0x1F, 0xD0, 0xA7, 0x50, 0x4F,
  0xD0, 0xB7, 0x30, 0x5F, 0xD0, 0x47, 0x60, 0xEF, 0xD0, 0x17, 0x20, 0xAF, 0xC0, 0xD7, 0x70, 0x8F,
  0xD0, 0x57, 0x20, 0xEF, 0xC0, 0x87, 0x70, 0x3F, 0xD0, 0xA7, 0x10, 0x4F, 0xD0, 0x27, 0x71, 0x0C,
  0xFC, 0x0E, 0x71, 0x09, 0xFC, 0x0B, 0x77, 0x20, 0x6F, 0xD0, 0x47, 0x0E, 0xFC, 0x06, 0x77, 0x20,
  0x1F, 0xD0, 0x96, 0x04, 0xFC, 0x0E, 0x77, 0x40, 0xAF, 0xC0, 0xE6, 0x08, 0xFC, 0x0A, 0x77, 0x40,
  0x5F, 0xD0, 0x45, 0x0D, 0xFC, 0x04, 0x77, 0x50, 0xEF, 0xC0, 0x94, 0x03, 0xFC, 0x0D, 0x77, 0x60,
  0x9F, 0xC0, 0xD4, 0x07, 0xFC, 0x08, 0x77, 0x60, 0x3F, 0xD0, 0x23, 0x0C, 0xFC, 0x02, 0x77, 0x70,
  0xCF, 0xC0, 0x62, 0x01, 0xFC, 0x0C, 0x77, 0x71, 0x07, 0xFC, 0x0B, 0x20, 0x5F, 0xC0, 0x67, 0x77,
  0x10, 0x1F, 0xC0, 0xE2, 0x09, 0xFB, 0x0E, 0x77, 0x73, 0x0B, 0xFC, 0x81, 0x30, 0xDF, 0xB0, 0xA7,
  0x77, 0x30, 0x5F, 0xC0, 0x71, 0xFC, 0x04, 0x77, 0x74, 0x0E, 0xFB, 0x0A, 0x03, 0xFB, 0x0D, 0x77,
  0x75, 0x09, 0xFB, 0x0D, 0x06, 0xFB, 0x08, 0x77, 0x75, 0x03, 0xFC, 0x08, 0xFB, 0x02, 0x77, 0x76,
  0x0D, 0xFF, 0xE0, 0xC7, 0x77, 0x70, 0x7F, 0xFE, 0x06, 0x77, 0x77, 0x01, 0xFF, 0xE7, 0x77, 0x72,
  0x0B, 0xFF, 0xC0, 0xA7, 0x77, 0x72, 0x05, 0xFF, 0xC0, 0x47, 0x77, 0x73, 0x0E, 0xFF, 0xA0, 0xD7,
  0x77, 0x74, 0x09, 0xFF, 0xA0, 0x87, 0x77, 0x74, 0x03, 0xFF, 0xA0, 0x27, 0x77, 0x75, 0x0D, 0xFF,
  0x0C, 0x77, 0x77, 0x60, 0x7F, 0xF0, 0x67, 0x77, 0x76, 0x02, 0xFF, 0x01, 0x77, 0x30,
  // "w" (U+0077)
  0x0A, 0xFC, 0x03, 0x77, 0x77, 0x10, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x47, 0x77, 0x71, 0xFC, 0x09,
  0x05, 0xFC, 0x05, 0x77, 0x77, 0x01, 0xFC, 0x07, 0x03, 0xFC, 0x07, 0x77, 0x77, 0x02, 0xFC, 0x04,
  0x01, 0xFC, 0x08, 0x77, 0x77, 0x04, 0xFC, 0x81, 0x20, 0xEF, 0xB0, 0x97, 0x77, 0x70, 0x5F, 0xC2,
  0x0C, 0xFB, 0x0B, 0x77, 0x77, 0x07, 0xFB, 0x0D, 0x20, 0xAF, 0xB0, 0xC7, 0x10, 0x9F, 0xB0, 0xB7,
  0x10, 0x8F, 0xB0, 0xB2, 0x08, 0xFB, 0x0E, 0x71, 0x0C, 0xFB, 0x0E, 0x71, 0x09, 0xFB, 0x09, 0x20,
  0x6F, 0xC7, 0x1F, 0xD0, 0x27, 0x0B, 0xFB, 0x07, 0x20, 0x3F, 0xC0, 0x16, 0x02, 0xFD, 0x05, 0x70,
  0xCF, 0xB0, 0x52, 0x01, 0xFC, 0x02, 0x60, 0x6F, 0xD0, 0x87, 0x0E, 0xFB, 0x02, 0x30, 0xEF, 0xB0,
  0x46, 0x09, 0xFD, 0x0B, 0x7F, 0xC4, 0x0C, 0xFB, 0x05, 0x60, 0xCF, 0xD0, 0xE6, 0x01, 0xFB, 0x0E,
  0x40, 0xAF, 0xB0, 0x66, 0xFF, 0x02, 0x50, 0x2F, 0xB0, 0xB4, 0x08, 0xFB, 0x08, 0x50, 0x2F, 0xF0,
  0x55, 0x04, 0xFB, 0x09, 0x40, 0x6F, 0xB0, 0x95, 0x06, 0xFF, 0x08, 0x50, 0x5F, 0xB0, 0x74, 0x04,
  0xFB, 0x0B, 0x50, 0x9F, 0xF0, 0xB5, 0x06, 0xFB, 0x05, 0x40, 0x1F, 0xB0, 0xC5, 0x0C, 0xFF, 0x0E,
  0x50, 0x8F, 0xB0, 0x35, 0xFB, 0x0D, 0x5F, 0xFA, 0x02, 0x40, 0x9F, 0xB6, 0x0C, 0xFB, 0x40, 0x2F,
  0xFA, 0x05, 0x40, 0xAF, 0xA0, 0xE6, 0x0A, 0xFB, 0x01, 0x30, 0x6F, 0x00, 0xBF, 0x08, 0x40, 0xCF,
  0xA0, 0xC6, 0x08, 0xFB, 0x02, 0x30, 0x9F, 0x00, 0x8F, 0x0B, 0x40, 0xDF, 0xA0, 0x96, 0x06, 0xFB,
  0x03, 0x30, 0xCF, 0x00, 0x6F, 0x0E, 0x4F, 0xB0, 0x76, 0x04, 0xFB, 0x05, 0x3F, 0x90, 0x04, 0xF9,
  0x02, 0x3F, 0xB0, 0x56, 0x01, 0xFB, 0x06, 0x20, 0x2F, 0x90, 0x01, 0xF9, 0x05, 0x20, 0x2F, 0xB0,
  0x37, 0xFB, 0x08, 0x20, 0x5F, 0x0E, 0x20, 0xEF, 0x08, 0x20, 0x3F, 0xB0, 0x17, 0x0D, 0xFA, 0x09,
  0x20, 0x8F, 0x0C, 0x20, 0xCF, 0x0B, 0x20, 0x4F, 0xA0, 0xE7, 0x10, 0xAF, 0xA0, 0xB2, 0x0B, 0xF0,
  0x92, 0x09, 0xF0, 0xE2, 0x05, 0xFA, 0x0C, 0x71, 0x08, 0xFA, 0x0C, 0x20, 0xDF, 0x07, 0x20, 0x7F,
  0x98, 0x11, 0x06, 0xFA, 0x0A, 0x71, 0x06, 0xFA, 0x0E, 0x2F, 0x90, 0x42, 0x04, 0xF9, 0x81, 0x30,
  0x8F, 0xA0, 0x77, 0x10, 0x4F, 0xB1, 0x03, 0xF9, 0x01, 0x20, 0x1F, 0x98, 0x16, 0x09, 0xFA, 0x05,
  0x71, 0x02, 0xFB, 0x01, 0x05, 0xF0, 0xD4, 0x0E, 0xF8, 0x18, 0x0A, 0xFA, 0x03, 0x72, 0xFB, 0x02,
  0x07, 0xF0, 0xB4, 0x0B, 0xF8, 0x1B, 0x0B, 0xFA, 0x01, 0x72, 0x0D, 0xFA, 0x04, 0x09, 0xF0, 0x84,
  0x08, 0xF8, 0x1D, 0x0D, 0xF9, 0x0E, 0x73, 0x0B, 0xFA, 0x05, 0x0B, 0xF0, 0x54, 0x05, 0xF9, 0x10,
  0xEF, 0x90, 0xC7, 0x30, 0x8F, 0xA0, 0x60, 0xDF, 0x02, 0x40, 0x3F, 0x90, 0x4F, 0xA0, 0xA7, 0x30,
  0x6F, 0xA0, 0x9F, 0x96, 0xF9, 0x09, 0xFA, 0x07, 0x73, 0x04, 0xFF, 0xB0, 0xC6, 0x0D, 0xFF, 0xB0,
  0x57, 0x30, 0x2F, 0xFB, 0x09, 0x60, 0xAF, 0xFB, 0x03, 0x74, 0xFF, 0xB0, 0x66, 0x07, 0xFF, 0xB0,
  0x17, 0x40, 0xDF, 0xFA, 0x03, 0x60, 0x4F, 0xFA, 0x0E, 0x75, 0x0B, 0xFF, 0xA0, 0x16, 0x01, 0xFF,
  0xA0, 0xC7, 0x50, 0x9F, 0xF9, 0x0D, 0x71, 0x0E, 0xFF, 0x90, 0xA7, 0x50, 0x6F, 0xF9, 0x0A, 0x71,
  0x0B, 0xFF, 0x90, 0x87, 0x50, 0x4F, 0xF9, 0x07, 0x71, 0x09, 0xFF, 0x90, 0x57, 0x50, 0x2F, 0xF9,
  0x05, 0x71, 0x06, 0xFF, 0x90, 0x37, 0x6F, 0xF9, 0x02, 0x71, 0x03, 0xFF, 0x90, 0x17, 0x60, 0xDF,
  0xE0, 0xE7, 0x3F, 0xF0, 0xE7,
  // "x" (U+0078)
  0x01, 0x0E, 0xFF, 0x08, 0x77, 0x30, 0xBF, 0xF8, 0x1C, 0x05, 0xFF, 0x90, 0x27, 0x71, 0x05, 0xFF,
  0x90, 0x22, 0x0A, 0xFF, 0x0A, 0x77, 0x10, 0xDF, 0xF0, 0x73, 0x01, 0x0E, 0xFF, 0x03, 0x76, 0x08,
  0xFF, 0x0B, 0x50, 0x5F, 0xF0, 0xC7, 0x50, 0x2F, 0xF0, 0xE0, 0x26, 0x0A, 0xFF, 0x05, 0x74, 0x0A,
  0xFF, 0x05, 0x70, 0x10, 0xEF, 0xE0, 0xD7, 0x30, 0x4F, 0xF0, 0xA7, 0x20, 0x4F, 0xF0, 0x77, 0x20,
  0xDF, 0xE0, 0xE0, 0x17, 0x30, 0x9F, 0xE0, 0xE0, 0x17, 0x07, 0xFF, 0x04, 0x75, 0x0D, 0xFE, 0x09,
  0x60, 0x10, 0xEF, 0xE0, 0x97, 0x60, 0x4F, 0xF0, 0x25, 0x09, 0xFE, 0x0D, 0x77, 0x10, 0x9F, 0xE0,
  0xB4, 0x03, 0xFF, 0x03, 0x77, 0x20, 0xDF, 0xE0, 0x43, 0x0C, 0xFE, 0x08, 0x77, 0x30, 0x3F, 0xE0,
  0xC2, 0x06, 0xFE, 0x0C, 0x77, 0x50, 0x8F, 0xE8, 0x16, 0x1E, 0xFE, 0x02, 0x77, 0x60, 0xCF, 0xD0,
  0xE0, 0x9F, 0xE0, 0x67, 0x77, 0x03, 0xFF, 0xFD, 0x0B, 0x77, 0x72, 0x07, 0xFF, 0xFB, 0x0E, 0x01,
  0x77, 0x73, 0x0C, 0xFF, 0xFA, 0x05, 0x77, 0x74, 0x02, 0xFF, 0xF9, 0x0A, 0x77, 0x76, 0x07, 0xFF,
  0xE0, 0xD0, 0x17, 0x77, 0x70, 0xBF, 0xFD, 0x04, 0x77, 0x77, 0x10, 0x20, 0xEF, 0xFB, 0x09, 0x77,
  0x77, 0x30, 0x6F, 0xFA, 0x0D, 0x77, 0x77, 0x50, 0xEF, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x9F, 0xFA,
  0x0E, 0x01, 0x77, 0x77, 0x20, 0x5F, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0x10, 0xEF, 0xFD, 0x06, 0x77,
  0x77, 0x0B, 0xFF, 0xE0, 0xE0, 0x27, 0x77, 0x50, 0x6F, 0xFF, 0x90, 0xC7, 0x77, 0x40, 0x2F, 0xFF,
  0xB0, 0x77, 0x77, 0x30, 0xCF, 0xFF, 0xC0, 0x37, 0x77, 0x10, 0x8F, 0xFF, 0xD0, 0xC7, 0x77, 0x04,
  0xFE, 0x0E, 0x08, 0xFE, 0x08, 0x77, 0x50, 0x10, 0xDF, 0xE8, 0x15, 0x0D, 0xFE, 0x03, 0x77, 0x40,
  0xAF, 0xE0, 0xB2, 0x04, 0xFE, 0x0D, 0x77, 0x30, 0x5F, 0xF0, 0x23, 0x0B, 0xFE, 0x09, 0x77, 0x10,
  0x20, 0xEF, 0xE0, 0x84, 0x02, 0xFF, 0x04, 0x77, 0x0C, 0xFE, 0x0D, 0x60, 0x8F, 0xE0, 0xE0, 0x17,
  0x50, 0x7F, 0xF0, 0x46, 0x01, 0x0E, 0xFE, 0x0A, 0x74, 0x03, 0xFF, 0x0A, 0x71, 0x06, 0xFF, 0x05,
  0x73, 0x0D, 0xFE, 0x0E, 0x01, 0x72, 0x0C, 0xFE, 0x0E, 0x01, 0x71, 0x09, 0xFF, 0x07, 0x73, 0x03,
  0xFF, 0x0B, 0x70, 0x5F, 0xF0, 0xC7, 0x50, 0xAF, 0xF0, 0x65, 0x01, 0x0E, 0xFF, 0x03, 0x75, 0x01,
  0x0E, 0xFE, 0x0E, 0x02, 0x40, 0xBF, 0xF0, 0x97, 0x70, 0x7F, 0xF0, 0xC3, 0x06, 0xFF, 0x0E, 0x01,
  0x77, 0x10, 0xDF, 0xF8, 0x17, 0x02, 0xFF, 0x90, 0x57, 0x72, 0x05, 0xFF, 0x90, 0x30, 0xCF, 0xF0,
  0xB7, 0x74, 0x0B, 0xFF, 0x0C,
  // "y" (U+0079)
  0x0E, 0xFE, 0x02, 0x77, 0x70, 0xEF, 0xD0, 0xE0, 0x9F, 0xE0, 0x77, 0x76, 0x04, 0xFE, 0x0A, 0x03,
  0xFE, 0x0D, 0x77, 0x60, 0x9F, 0xE8, 0x14, 0x0C, 0xFE, 0x02, 0x77, 0x50, 0xDF, 0xD0, 0xE2, 0x06,
  0xFE, 0x07, 0x77, 0x40, 0x2F, 0xE0, 0x82, 0x01, 0x0E, 0xFD, 0x0D, 0x77, 0x40, 0x7F, 0xE0, 0x33,
  0x09, 0xFE, 0x02, 0x77, 0x30, 0xBF, 0xD0, 0xC4, 0x03, 0xFE, 0x07, 0x77, 0x20, 0x1F, 0xE0, 0x75,
  0x0D, 0xFD, 0x0D, 0x77, 0x20, 0x5F, 0xE0, 0x15, 0x06, 0xFE, 0x02, 0x77, 0x10, 0x9F, 0xD0, 0xB6,
  0x01, 0xFE, 0x07, 0x77, 0x10, 0xEF, 0xD0, 0x57, 0x0A, 0xFD, 0x0D, 0x77, 0x03, 0xFD, 0x0E, 0x71,
  0x04, 0xFE, 0x02, 0x76, 0x08, 0xFD, 0x0A, 0x72, 0x0D, 0xFD, 0x07, 0x76, 0x0C, 0xFD, 0x04, 0x72,
  0x07, 0xFD, 0x0D, 0x75, 0x01, 0xFD, 0x0E, 0x73, 0x01, 0xFE, 0x02, 0x74, 0x06, 0xFD, 0x08, 0x74,
  0x0A, 0xFD, 0x07, 0x74, 0x0A, 0xFD, 0x02, 0x74, 0x04, 0xFD, 0x0D, 0x74, 0x0E, 0xFC, 0x0C, 0x76,
  0x0D, 0xFD, 0x02, 0x72, 0x04, 0xFD, 0x07, 0x76, 0x07, 0xFD, 0x07, 0x72, 0x09, 0xFD, 0x01, 0x76,
  0x01, 0xFD, 0x0D, 0x72, 0x0D, 0xFC, 0x0B, 0x77, 0x10, 0xAF, 0xD0, 0x27, 0x02, 0xFD, 0x05, 0x77,
  0x10, 0x4F, 0xD0, 0x77, 0x07, 0xFC, 0x0E, 0x77, 0x30, 0xDF, 0xC0, 0xD7, 0x0B, 0xFC, 0x09, 0x77,
  0x30, 0x8F, 0xD0, 0x25, 0x01, 0xFD, 0x04, 0x77, 0x30, 0x1F, 0xD0, 0x75, 0x05, 0xFC, 0x0D, 0x77,
  0x50, 0xBF, 0xC0, 0xD5, 0x0A, 0xFC, 0x08, 0x77, 0x50, 0x5F, 0xD0, 0x24, 0x0E, 0xFC, 0x02, 0x77,
  0x60, 0xEF, 0xC0, 0x73, 0x03, 0xFC, 0x0C, 0x77, 0x70, 0x8F, 0xC0, 0xC3, 0x08, 0xFC, 0x06, 0x77,
  0x70, 0x2F, 0xD0, 0x12, 0x0C, 0xFC, 0x01, 0x77, 0x71, 0x0B, 0xFC, 0x81, 0x50, 0x1F, 0xC0, 0xB7,
  0x77, 0x20, 0x5F, 0xC8, 0x19, 0x05, 0xFC, 0x05, 0x77, 0x73, 0x0E, 0xFB, 0x81, 0xD0, 0x9F, 0xB0,
  0xE7, 0x77, 0x40, 0x8F, 0xC1, 0x0C, 0xFB, 0x09, 0x77, 0x74, 0x02, 0xFC, 0x03, 0xFC, 0x04, 0x77,
  0x75, 0x0B, 0xFB, 0x08, 0xFB, 0x0D, 0x77, 0x76, 0x05, 0xFF, 0xF0, 0x87, 0x77, 0x70, 0xEF, 0xFE,
  0x02, 0x77, 0x77, 0x09, 0xFF, 0xD0, 0xC7, 0x77, 0x71, 0x02, 0xFF, 0xD0, 0x67, 0x77, 0x72, 0x0C,
  0xFF, 0xC0, 0x17, 0x77, 0x72, 0x06, 0xFF, 0xB0, 0xB7, 0x77, 0x74, 0x0E, 0xFF, 0xA0, 0x57, 0x77,
  0x74, 0x09, 0xFF, 0x90, 0xE7, 0x77, 0x75, 0x03, 0xFF, 0x90, 0x97, 0x77, 0x76, 0x0C, 0xFF, 0x03,
  0x77, 0x77, 0x60, 0x6F, 0xE0, 0xD8, 0x0C, 0x00, 0x0E, 0xFD, 0x08, 0x80, 0xC0, 0x0F, 0xE0, 0x27,
  0x77, 0x77, 0x05, 0xFD, 0x0C, 0x80, 0xC0, 0x00, 0xBF, 0xD0, 0x67, 0x77, 0x77, 0x01, 0xFE, 0x01,
  0x77, 0x77, 0x70, 0x8F, 0xD0, 0xA7, 0x77, 0x77, 0x01, 0x0E, 0xFD, 0x04, 0x77, 0x77, 0x70, 0xAF,
  0xD0, 0xC7, 0x77, 0x77, 0x05, 0xFE, 0x05, 0x77, 0x77, 0x60, 0x4F, 0xE0, 0xD7, 0x77, 0x76, 0x07,
  0xFF, 0x06, 0x77, 0x73, 0x82, 0x45, 0x21, 0x28, 0x21, 0x48, 0xDF, 0xF0, 0xC7, 0x77, 0x40, 0xAF,
  0xFF, 0xA0, 0x47, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0x97, 0x77, 0x50, 0xAF, 0xFF, 0x0D, 0x01, 0x77,
  0x75, 0x0A, 0xFF, 0xF0, 0x37, 0x77, 0x60, 0xAF, 0xFE, 0x06, 0x77, 0x77, 0x0A, 0xFF, 0xD0, 0x77,
  0x77, 0x71, 0x0A, 0xFF, 0xC0, 0x77, 0x77, 0x72, 0x0A, 0xFF, 0xA0, 0xE0, 0x47, 0x77, 0x73, 0x0A,
  0xFF, 0x90, 0x90, 0x17, 0x77, 0x74, 0x0A, 0xFD, 0x81, 0xE9, 0x27, 0x77, 0x76, 0x84, 0x37, 0xAC,
  0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x77, 0x60,
  // "z" (U+007A)
  0x20, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30,
  0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8,
  0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C,
  0x2F, 0x0D, 0x40, 0x68, 0x0A, 0x28, 0x0A, 0xFF, 0x0E, 0x02, 0x77, 0x75, 0x01, 0x0D, 0xFF, 0x03,
  0x77, 0x76, 0x0B, 0xFF, 0x05, 0x77, 0x76, 0x08, 0xFF, 0x08, 0x77, 0x76, 0x06, 0xFF, 0x0A, 0x77,
  0x76, 0x03, 0xFF, 0x0C, 0x77, 0x76, 0x01, 0x0E, 0xFE, 0x0D, 0x01, 0x77, 0x76, 0x0C, 0xFE, 0x0E,
  0x03, 0x77, 0x76, 0x0A, 0xFF, 0x05, 0x77, 0x76, 0x07, 0xFF, 0x07, 0x77, 0x76, 0x05, 0xFF, 0x09,
  0x77, 0x76, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x76, 0x01, 0x0D, 0xFE, 0x0D, 0x01, 0x77, 0x76, 0x0B,
  0xFE, 0x0E, 0x02, 0x77, 0x76, 0x09, 0xFF, 0x04, 0x77, 0x76, 0x06, 0xFF, 0x06, 0x77, 0x76, 0x04,
  0xFF, 0x09, 0x77, 0x76, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x76, 0x01, 0x0D, 0xFE, 0x0D, 0x77, 0x77,
  0x0B, 0xFE, 0x0E, 0x02, 0x77, 0x76, 0x08, 0xFF, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x05, 0x77, 0x76,
  0x03, 0xFF, 0x08, 0x77, 0x76, 0x01, 0x0E, 0xFE, 0x0A, 0x77, 0x77, 0x0C, 0xFE, 0x0C, 0x77, 0x77,
  0x0A, 0xFE, 0x0D, 0x01, 0x77, 0x76, 0x07, 0xFE, 0x0E, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x05, 0x77,
  0x76, 0x02, 0x0E, 0xFE, 0x0D, 0x80, 0xA5, 0x88, 0x21, 0x01, 0xD8, 0x0C, 0x4F, 0x81, 0x20, 0xB8,
  0x0C, 0x5F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28,
  0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28,
  0x0C, 0x6F, 0x02,
  // "{" (U+007B)
  0x77, 0x68, 0x90, 0x36, 0x8A, 0xCD, 0xEE, 0xFA, 0x77, 0x30, 0x60, 0xBF, 0xB0, 0xA7, 0x71, 0x06,
  0x0E, 0xFD, 0x0A, 0x76, 0x01, 0x0C, 0xFF, 0x0A, 0x76, 0x0C, 0xFF, 0x90, 0xA7, 0x50, 0x9F, 0xFA,
  0x0A, 0x74, 0x02, 0xFF, 0xB0, 0xA7, 0x40, 0x8F, 0xFB, 0x0A, 0x74, 0x0D, 0xFF, 0xB0, 0xA7, 0x30,
  0x1F, 0xFC, 0x0A, 0x73, 0x04, 0xFE, 0x82, 0xE8, 0x42, 0x75, 0x06, 0xFD, 0x08, 0x77, 0x20, 0x7F,
  0xC0, 0xA7, 0x73, 0x07, 0xFC, 0x03, 0x77, 0x30, 0x7F, 0xC7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40,
  0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D,
  0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07,
  0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7,
  0x74, 0x08, 0xFB, 0x0D, 0x77, 0x40, 0x9F, 0xB0, 0xD7, 0x74, 0x0C, 0xFB, 0x0C, 0x77, 0x30, 0x2F,
  0xC0, 0xB7, 0x73, 0x0A, 0xFC, 0x0A, 0x77, 0x20, 0x7F, 0xD0, 0x77, 0x70, 0x10, 0xAF, 0xE0, 0x27,
  0x38, 0x21, 0x36, 0xBF, 0xF0, 0xB7, 0x20, 0xAF, 0xFD, 0x03, 0x72, 0x0A, 0xFF, 0xC0, 0x67, 0x30,
  0xAF, 0xFA, 0x0E, 0x05, 0x74, 0x0A, 0xFF, 0x81, 0xE9, 0x17, 0x50, 0xAF, 0xC8, 0x1E, 0x95, 0x77,
  0x10, 0xAF, 0xC8, 0x1D, 0x74, 0x77, 0x10, 0xAF, 0xF8, 0x1E, 0x81, 0x75, 0x0A, 0xFF, 0xA0, 0xE0,
  0x57, 0x40, 0xAF, 0xFC, 0x06, 0x73, 0x0A, 0xFF, 0xD0, 0x37, 0x38, 0x31, 0x14, 0x7B, 0xFF, 0x0B,
  0x77, 0x10, 0x20, 0xBF, 0xE0, 0x27, 0x72, 0x08, 0xFD, 0x07, 0x77, 0x30, 0xBF, 0xC0, 0xA7, 0x73,
  0x02, 0xFC, 0x0B, 0x77, 0x40, 0xDF, 0xB0, 0xC7, 0x74, 0x09, 0xFB, 0x0D, 0x77, 0x40, 0x8F, 0xB0,
  0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40,
  0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D,
  0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07,
  0xFB, 0x0D, 0x77, 0x40, 0x7F, 0xB0, 0xD7, 0x74, 0x07, 0xFC, 0x77, 0x40, 0x7F, 0xC0, 0x37, 0x73,
  0x07, 0xFC, 0x0A, 0x77, 0x30, 0x6F, 0xD0, 0x87, 0x72, 0x04, 0xFE, 0x82, 0xD8, 0x41, 0x75, 0x01,
  0xFF, 0xC0, 0xA7, 0x40, 0xDF, 0xFB, 0x0A, 0x74, 0x08, 0xFF, 0xB0, 0xA7, 0x40, 0x2F, 0xFB, 0x0A,
  0x75, 0x09, 0xFF, 0xA0, 0xA7, 0x60, 0xDF, 0xF9, 0x0A, 0x76, 0x01, 0x0C, 0xFF, 0x0A, 0x77, 0x10,
  0x70, 0xEF, 0xD0, 0xA7, 0x73, 0x06, 0x0B, 0xFB, 0x0A, 0x77, 0x68, 0x90, 0x36, 0x8A, 0xCD, 0xEE,
  0xFA,
  // "|" (U+007C)
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E,
  // "}" (U+007D)
  0x89, 0x0A, 0xFE, 0xED, 0xCA, 0x86, 0x37, 0x76, 0x0A, 0xFB, 0x0B, 0x06, 0x77, 0x30, 0xAF, 0xD0,
  0xE0, 0x77, 0x71, 0x0A, 0xFF, 0x0C, 0x01, 0x76, 0x0A, 0xFF, 0x90, 0xC7, 0x60, 0xAF, 0xFA, 0x09,
  0x75, 0x0A, 0xFF, 0xB0, 0x27, 0x40, 0xAF, 0xFB, 0x08, 0x74, 0x0A, 0xFF, 0xB0, 0xD7, 0x40, 0xAF,
  0xFC, 0x01, 0x75, 0x82, 0x24, 0x8D, 0xFE, 0x04, 0x77, 0x20, 0x8F, 0xD0, 0x67, 0x73, 0x0A, 0xFC,
  0x06, 0x77, 0x30, 0x3F, 0xC0, 0x77, 0x74, 0xFC, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D,
  0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77,
  0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF,
  0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77,
  0x40, 0xDF, 0xB0, 0x87, 0x74, 0x0D, 0xFB, 0x09, 0x77, 0x40, 0xCF, 0xB0, 0xD7, 0x74, 0x0B, 0xFC,
  0x02, 0x77, 0x30, 0xAF, 0xC0, 0xB7, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x20, 0x3F, 0xE0, 0xB0, 0x27,
  0x71, 0x0B, 0xFF, 0x82, 0xB7, 0x41, 0x74, 0x03, 0xFF, 0xD0, 0xA7, 0x30, 0x6F, 0xFC, 0x0A, 0x74,
  0x05, 0x0E, 0xFF, 0xA0, 0xA7, 0x58, 0x11, 0x8E, 0xFF, 0x0A, 0x77, 0x18, 0x14, 0x7D, 0xFC, 0x0A,
  0x77, 0x18, 0x15, 0x8E, 0xFC, 0x0A, 0x75, 0x81, 0x19, 0xEF, 0xF0, 0xA7, 0x40, 0x50, 0xEF, 0xFA,
  0x0A, 0x73, 0x06, 0xFF, 0xC0, 0xA7, 0x20, 0x3F, 0xFD, 0x0A, 0x72, 0x0B, 0xFF, 0x82, 0xB6, 0x41,
  0x73, 0x02, 0xFE, 0x0A, 0x01, 0x77, 0x07, 0xFD, 0x07, 0x77, 0x20, 0xAF, 0xC0, 0xA7, 0x73, 0x0B,
  0xFC, 0x02, 0x77, 0x30, 0xCF, 0xB0, 0xC7, 0x74, 0x0D, 0xFB, 0x09, 0x77, 0x40, 0xDF, 0xB0, 0x87,
  0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF,
  0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77,
  0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB, 0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0x0D, 0xFB,
  0x07, 0x77, 0x40, 0xDF, 0xB0, 0x77, 0x74, 0xFC, 0x07, 0x77, 0x30, 0x3F, 0xC0, 0x77, 0x73, 0x0A,
  0xFC, 0x06, 0x77, 0x20, 0x8F, 0xD0, 0x67, 0x58, 0x22, 0x48, 0xEF, 0xE0, 0x47, 0x30, 0xAF, 0xFC,
  0x01, 0x73, 0x0A, 0xFF, 0xB0, 0xD7, 0x40, 0xAF, 0xFB, 0x08, 0x74, 0x0A, 0xFF, 0xB0, 0x27, 0x40,
  0xAF, 0xFA, 0x09, 0x75, 0x0A, 0xFF, 0x90, 0xC7, 0x60, 0xAF, 0xF0, 0xC0, 0x17, 0x60, 0xAF, 0xD0,
  0xE0, 0x77, 0x71, 0x0A, 0xFB, 0x0B, 0x06, 0x77, 0x38, 0x90, 0xAF, 0xEE, 0xDC, 0xA8, 0x63, 0x77,
  0x60,
  // "~" (U+007E)
  0x78, 0x90, 0x48, 0xCE, 0xFE, 0xDB, 0x72, 0x77, 0x40, 0xCD, 0x0C, 0x50, 0x30, 0xCF, 0xB0, 0xA0,
  0x27, 0x72, 0x0D, 0xD0, 0xB4, 0x05, 0xFF, 0x06, 0x77, 0x10, 0xED, 0x0A, 0x30, 0x4F, 0xFA, 0x0A,
  0x76, 0x01, 0xE0, 0x82, 0x01, 0x0E, 0xFF, 0xB0, 0xC0, 0x17, 0x40, 0x4E, 0x07, 0x20, 0xAF, 0xFD,
  0x0D, 0x02, 0x73, 0x08, 0xE8, 0x13, 0x02, 0xFF, 0xF0, 0xE0, 0x37, 0x20, 0xCE, 0x20, 0x8F, 0x84,
  0xB3, 0x01, 0x4C, 0xFA, 0x0E, 0x04, 0x70, 0x4E, 0x0C, 0x20, 0xDE, 0x09, 0x60, 0x8F, 0xB0, 0x75,
  0x01, 0x0D, 0xE8, 0x19, 0x02, 0xE0, 0xD7, 0x10, 0x5F, 0xB8, 0x4C, 0x51, 0x04, 0xDF, 0x81, 0x40,
  0x6E, 0x06, 0x72, 0x03, 0x0E, 0xFF, 0xE0, 0xD2, 0x09, 0xE0, 0x17, 0x30, 0x20, 0xDF, 0xFD, 0x06,
  0x20, 0xBD, 0x0D, 0x75, 0x01, 0x0B, 0xFF, 0xB0, 0xC3, 0x0D, 0xD0, 0xB7, 0x70, 0x9F, 0xF9, 0x0E,
  0x02, 0x30, 0xED, 0x09, 0x77, 0x10, 0x40, 0xEF, 0xD0, 0xE0, 0x34, 0xE0, 0x87, 0x72, 0x81, 0x18,
  0xEF, 0xA0, 0xB0, 0x25, 0xE0, 0x87, 0x74, 0x89, 0x01, 0x6A, 0xDE, 0xFE, 0xC8, 0x37,
  // "¡" (U+00A1)
  0x48, 0x65, 0xAD, 0xEE, 0xDA, 0x67, 0x03, 0x0D, 0xF9, 0x0E, 0x04, 0x40, 0x30, 0xEF, 0xC0, 0x53,
  0x0D, 0xFE, 0x81, 0x10, 0x6F, 0xF8, 0x18, 0x0B, 0xFF, 0x0D, 0x1F, 0xFA, 0x01, 0xFF, 0xA0, 0x2F,
  0xFA, 0x02, 0xFF, 0xA0, 0x10, 0xCF, 0xF8, 0x1E, 0x07, 0xFF, 0x82, 0xA0, 0x1E, 0xFE, 0x03, 0x20,
  0x4F, 0xD0, 0x84, 0x04, 0x0E, 0xFA, 0x07, 0x78, 0x16, 0xBD, 0xA8, 0x2E, 0xB7, 0x18, 0x09, 0xD0,
  0x00, 0xCF, 0xB0, 0xA5, 0x0C, 0xFB, 0x0B, 0x50, 0xDF, 0xB0, 0xC5, 0x0E, 0xFB, 0x0C, 0x5F, 0xC0,
  0xD5, 0xFC, 0x0E, 0x5F, 0xC0, 0xE4, 0x01, 0xFD, 0x40, 0x2F, 0xD4, 0x02, 0xFD, 0x01, 0x30, 0x3F,
  0xD0, 0x23, 0x04, 0xFD, 0x02, 0x30, 0x4F, 0xD0, 0x33, 0x05, 0xFD, 0x04, 0x30, 0x6F, 0xD0, 0x43,
  0x07, 0xFD, 0x05, 0x30, 0x7F, 0xD0, 0x63, 0x08, 0xFD, 0x06, 0x30, 0x9F, 0xD0, 0x73, 0x09, 0xFD,
  0x08, 0x30, 0xAF, 0xD0, 0x83, 0x0B, 0xFD, 0x09, 0x30, 0xBF, 0xD0, 0xA3, 0x0C, 0xFD, 0x0A, 0x30,
  0xDF, 0xD0, 0xB3, 0x0D, 0xFD, 0x0C, 0x30, 0xEF, 0xD0, 0xC3, 0xFE, 0x0D, 0x3F, 0xE0, 0xE2, 0x01,
  0xFF, 0x20, 0x1F, 0xF2, 0x02, 0xFF, 0x20, 0x3F, 0xF8, 0x11, 0x03, 0xFF, 0x81, 0x20, 0x4F, 0xF8,
  0x12, 0x05, 0xFF, 0x81, 0x30, 0x5F, 0xF8, 0x14, 0x06, 0xFF, 0x81, 0x40, 0x7F, 0xF8, 0x15, 0x07,
  0xFF, 0x81, 0x60, 0x8F, 0xF8, 0x17, 0x09, 0xFF, 0x81, 0x70, 0x9F, 0xF0, 0x81,
  // "¢" (U+00A2)
  0x77, 0x60, 0x1F, 0x01, 0x77, 0x77, 0x50, 0x1F, 0x01, 0x77, 0x77, 0x50, 0x1F, 0x01, 0x77, 0x77,
  0x50, 0x1F, 0x01, 0x77, 0x77, 0x50, 0x1F, 0x01, 0x77, 0x77, 0x50, 0x1F, 0x01, 0x77, 0x77, 0x50,
  0x1F, 0x02, 0x77, 0x77, 0x28, 0x23, 0x79, 0xCF, 0xA8, 0x4E, 0xDC, 0x96, 0x47, 0x76, 0x81, 0x5A,
  0xEF, 0xFE, 0x81, 0xB6, 0x17, 0x68, 0x11, 0x8E, 0xFF, 0xFD, 0x0A, 0x02, 0x73, 0x06, 0x0E, 0xFF,
  0xFF, 0x90, 0x77, 0x10, 0x10, 0xBF, 0xFF, 0xFB, 0x02, 0x70, 0x30, 0xDF, 0xFF, 0xFB, 0x0C, 0x70,
  0x30, 0xEF, 0xFF, 0xFC, 0x07, 0x60, 0x20, 0xEF, 0xFF, 0xFD, 0x01, 0x60, 0xDF, 0xFF, 0xFD, 0x0B,
  0x60, 0x9F, 0xFF, 0xFE, 0x06, 0x50, 0x3F, 0xFA, 0x89, 0x3E, 0xA6, 0x32, 0x10, 0x12, 0x47, 0xAD,
  0xE0, 0x15, 0x0B, 0xFF, 0x0D, 0x06, 0x76, 0x81, 0x27, 0xCA, 0x0B, 0x50, 0x3F, 0xF0, 0x97, 0x74,
  0x81, 0x4B, 0x55, 0x09, 0xFE, 0x06, 0x77, 0x76, 0x0E, 0xFD, 0x07, 0x77, 0x76, 0x04, 0xFD, 0x0C,
  0x77, 0x77, 0x09, 0xFD, 0x04, 0x77, 0x77, 0x0D, 0xFC, 0x0D, 0x77, 0x77, 0x1F, 0xD0, 0x87, 0x77,
  0x70, 0x3F, 0xD0, 0x47, 0x77, 0x70, 0x5F, 0xD0, 0x17, 0x77, 0x70, 0x7F, 0xC0, 0xE7, 0x77, 0x71,
  0x08, 0xFC, 0x0D, 0x77, 0x77, 0x10, 0x9F, 0xC0, 0xB7, 0x77, 0x71, 0x0A, 0xFC, 0x0B, 0x77, 0x77,
  0x10, 0xAF, 0xC0, 0xB7, 0x77, 0x71, 0x0A, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0x9F, 0xC0, 0xC7, 0x77,
  0x71, 0x08, 0xFC, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD7, 0x77, 0x71, 0x04, 0xFD, 0x03, 0x77, 0x77,
  0x02, 0xFD, 0x07, 0x77, 0x77, 0x10, 0xEF, 0xC0, 0xC7, 0x77, 0x71, 0x0B, 0xFD, 0x03, 0x77, 0x77,
  0x07, 0xFD, 0x0B, 0x77, 0x77, 0x03, 0xFE, 0x06, 0x77, 0x77, 0x0D, 0xFE, 0x05, 0x77, 0x71, 0x01,
  0x02, 0x30, 0x8F, 0xF0, 0x87, 0x75, 0x82, 0x18, 0xE6, 0x30, 0x1F, 0xF9, 0x0C, 0x05, 0x77, 0x81,
  0x26, 0xBB, 0x06, 0x40, 0x9F, 0xFA, 0x83, 0xD9, 0x63, 0x12, 0x85, 0x12, 0x34, 0x7A, 0xDE, 0x06,
  0x40, 0x10, 0xEF, 0xFF, 0xFF, 0x06, 0x50, 0x6F, 0xFF, 0xFF, 0x06, 0x60, 0xAF, 0xFF, 0xFE, 0x06,
  0x70, 0xCF, 0xFF, 0xFD, 0x06, 0x70, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x72, 0x0B, 0xFF, 0xFF, 0xB0,
  0x67, 0x30, 0x60, 0xEF, 0xFF, 0xF9, 0x06, 0x74, 0x01, 0x09, 0xFF, 0xFE, 0x0A, 0x02, 0x76, 0x81,
  0x17, 0xDF, 0xFF, 0x81, 0xD8, 0x27, 0x74, 0x82, 0x37, 0xAD, 0xFE, 0x82, 0xDA, 0x62, 0x77, 0x75,
  0x03, 0xF8, 0x28, 0x53, 0x17, 0x77, 0x72, 0x01, 0xF0, 0x17, 0x77, 0x75, 0x01, 0xF0, 0x17, 0x77,
  0x75, 0x01, 0xF0, 0x17, 0x77, 0x75, 0x01, 0xF0, 0x17, 0x77, 0x75, 0x01, 0xF0, 0x17, 0x77, 0x75,
  0x01, 0xF0, 0x17, 0x77, 0x75, 0x01, 0xF0, 0x17, 0x77, 0x75, 0x01, 0xF0, 0x17, 0x60,
  // "£" (U+00A3)
  0x77, 0x58, 0x43, 0x69, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x38, 0x12, 0x8E, 0xFF,
  0x98, 0x1D, 0x83, 0x77, 0x50, 0x10, 0xAF, 0xFF, 0x81, 0xD7, 0x17, 0x71, 0x06, 0x0E, 0xFF, 0xFC,
  0x08, 0x76, 0x09, 0xFF, 0xFE, 0x08, 0x75, 0x0A, 0xFF, 0xFF, 0x02, 0x74, 0x08, 0xFF, 0xFF, 0x0C,
  0x74, 0x03, 0xFF, 0xFF, 0x90, 0x67, 0x40, 0xCF, 0xFF, 0xF9, 0x01, 0x73, 0x03, 0xFF, 0xFF, 0x90,
  0xA7, 0x40, 0xAF, 0xF9, 0x85, 0xEA, 0x88, 0x9B, 0xEF, 0x04, 0x74, 0x0E, 0xFE, 0x0E, 0x06, 0x78,
  0x12, 0x6C, 0xB0, 0xD7, 0x40, 0x3F, 0xE0, 0xC0, 0x17, 0x48, 0x22, 0x9F, 0x87, 0x40, 0x6F, 0xD0,
  0xE0, 0x17, 0x70, 0x20, 0x17, 0x40, 0x9F, 0xD0, 0x77, 0x77, 0x70, 0xBF, 0xD0, 0x17, 0x77, 0x70,
  0xCF, 0xC0, 0xD7, 0x77, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71,
  0x0D, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x77,
  0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77,
  0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0D, 0xFC, 0x0B, 0x77,
  0x71, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67,
  0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C,
  0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0xFF, 0xFF, 0xD0, 0x67, 0x70, 0xDF,
  0xC0, 0xB7, 0x77, 0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0D,
  0xFC, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0D, 0xFC, 0x0B, 0x77, 0x77, 0x10,
  0xDF, 0xC0, 0xB7, 0x77, 0x71, 0x0E, 0xFC, 0x0A, 0x77, 0x77, 0x1F, 0xD0, 0x97, 0x77, 0x70, 0x1F,
  0xD0, 0x67, 0x77, 0x70, 0x4F, 0xD0, 0x27, 0x77, 0x70, 0x8F, 0xC0, 0xD7, 0x77, 0x71, 0x0D, 0xFC,
  0x05, 0x77, 0x77, 0x06, 0xFC, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFB, 0x0D, 0x01, 0x77, 0x76, 0x02,
  0x0E, 0xFB, 0x0D, 0x02, 0x77, 0x76, 0x04, 0x0E, 0xFB, 0x0C, 0x01, 0x77, 0x75, 0x01, 0x09, 0xFC,
  0x0E, 0x80, 0xA7, 0x80, 0x40, 0xA8, 0x0C, 0x4F, 0x09, 0x0A, 0x80, 0xC4, 0xF0, 0x90, 0xA8, 0x0C,
  0x4F, 0x09, 0x0A, 0x80, 0xC4, 0xF0, 0x90, 0xA8, 0x0C, 0x4F, 0x09, 0x0A, 0x80, 0xC4, 0xF0, 0x90,
  0xA8, 0x0C, 0x4F, 0x09, 0x0A, 0x80, 0xC4, 0xF0, 0x90, 0xA8, 0x0C, 0x4F, 0x09, 0x0A, 0x80, 0xC4,
  0xF0, 0x90,
  // "¤" (U+00A4)
  0x58, 0x12, 0xD4, 0x77, 0x77, 0x81, 0x7C, 0x17, 0x20, 0x20, 0xEA, 0x04, 0x77, 0x75, 0x06, 0xA0,
  0xD0, 0x17, 0x02, 0x0E, 0xC0, 0x47, 0x77, 0x30, 0x6C, 0x0D, 0x02, 0x50, 0x20, 0xEE, 0x04, 0x58,
  0x92, 0x26, 0xAC, 0xEF, 0xED, 0xC9, 0x51, 0x50, 0x6E, 0x0D, 0x02, 0x30, 0x20, 0xEF, 0x90, 0x42,
  0x05, 0x0C, 0xFD, 0x0A, 0x03, 0x20, 0x6F, 0x98, 0x3E, 0x30, 0x3E, 0xFA, 0x81, 0xE7, 0xDF, 0xFA,
  0x09, 0x07, 0xFB, 0x82, 0xE3, 0x2D, 0x80, 0xC4, 0xF0, 0xB2, 0x01, 0x0D, 0x80, 0xC2, 0xF0, 0xB4,
  0x01, 0x0D, 0x80, 0xC0, 0xF0, 0xA6, 0x01, 0x0C, 0xFF, 0xFF, 0xE0, 0xA7, 0x10, 0x10, 0xCF, 0xFF,
  0xFC, 0x0A, 0x74, 0x0C, 0xFF, 0xFF, 0xA0, 0xB7, 0x50, 0xEF, 0xB8, 0x2E, 0x84, 0x12, 0x82, 0x14,
  0x9E, 0xFB, 0x0E, 0x74, 0x08, 0xFB, 0x09, 0x01, 0x71, 0x01, 0x09, 0xFB, 0x07, 0x73, 0x0E, 0xFA,
  0x07, 0x75, 0x07, 0xFA, 0x0D, 0x72, 0x05, 0xFA, 0x0A, 0x77, 0x09, 0xFA, 0x04, 0x71, 0x0A, 0xF9,
  0x0E, 0x01, 0x77, 0x10, 0xEF, 0x90, 0x97, 0x10, 0xEF, 0x90, 0x87, 0x72, 0x08, 0xF9, 0x0C, 0x70,
  0x2F, 0xA0, 0x37, 0x72, 0x03, 0xFA, 0x70, 0x3F, 0xA7, 0x74, 0xFA, 0x02, 0x60, 0x5F, 0x90, 0xE7,
  0x74, 0x0E, 0xF9, 0x03, 0x60, 0x5F, 0x90, 0xE7, 0x74, 0x0E, 0xF9, 0x03, 0x60, 0x4F, 0xA7, 0x74,
  0xFA, 0x02, 0x60, 0x2F, 0xA0, 0x37, 0x72, 0x03, 0xFA, 0x01, 0x7F, 0xA0, 0x77, 0x72, 0x07, 0xF9,
  0x0D, 0x71, 0x0B, 0xF9, 0x0E, 0x77, 0x20, 0xEF, 0x90, 0xA7, 0x10, 0x7F, 0xA0, 0x87, 0x70, 0x9F,
  0xA0, 0x57, 0x10, 0x1F, 0xB0, 0x77, 0x50, 0x7F, 0xA0, 0xE7, 0x30, 0xAF, 0xB0, 0xA0, 0x17, 0x10,
  0x10, 0xAF, 0xB0, 0x97, 0x30, 0x2F, 0xC8, 0x2E, 0x94, 0x12, 0x81, 0x15, 0x9F, 0xD0, 0x17, 0x40,
  0xBF, 0xFF, 0xFA, 0x0A, 0x74, 0x09, 0xFF, 0xFF, 0xC0, 0x67, 0x20, 0x9F, 0xFF, 0xFE, 0x06, 0x70,
  0xA8, 0x0C, 0x0F, 0x06, 0x50, 0xB8, 0x0C, 0x2F, 0x07, 0x20, 0x10, 0xC8, 0x0C, 0x4F, 0x82, 0x70,
  0x2E, 0xFB, 0x09, 0x0E, 0xFF, 0xA0, 0xB0, 0xAF, 0xB0, 0xD2, 0x03, 0x0E, 0xF9, 0x83, 0x50, 0x18,
  0xDF, 0xD0, 0xA0, 0x42, 0x09, 0xF9, 0x0D, 0x01, 0x30, 0x20, 0xEE, 0x05, 0x58, 0x92, 0x37, 0xAD,
  0xEF, 0xED, 0xC8, 0x51, 0x50, 0x9E, 0x0D, 0x01, 0x50, 0x20, 0xEC, 0x04, 0x77, 0x73, 0x08, 0xC0,
  0xD0, 0x17, 0x02, 0x0E, 0xA0, 0x47, 0x77, 0x50, 0x8A, 0x0D, 0x01, 0x72, 0x81, 0x2D, 0x47, 0x77,
  0x78, 0x18, 0xD1, 0x50,
  // "¥" (U+00A5)
  0x07, 0xFD, 0x0B, 0x77, 0x71, 0x0B, 0xFD, 0x81, 0x70, 0xEF, 0xD0, 0x27, 0x76, 0x02, 0xFD, 0x0E,
  0x20, 0x7F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x07, 0x30, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x0D,
  0x40, 0x7F, 0xD0, 0x87, 0x74, 0x08, 0xFD, 0x06, 0x50, 0xEF, 0xC0, 0xE7, 0x74, 0x0E, 0xFC, 0x0D,
  0x60, 0x6F, 0xD0, 0x67, 0x72, 0x06, 0xFD, 0x05, 0x70, 0xDF, 0xC0, 0xD7, 0x72, 0x0D, 0xFC, 0x0D,
  0x71, 0x06, 0xFD, 0x05, 0x77, 0x05, 0xFD, 0x05, 0x72, 0x0D, 0xFC, 0x0C, 0x77, 0x0C, 0xFC, 0x0C,
  0x73, 0x06, 0xFD, 0x03, 0x75, 0x03, 0xFD, 0x04, 0x74, 0x0D, 0xFC, 0x0A, 0x75, 0x0A, 0xFC, 0x0C,
  0x75, 0x06, 0xFD, 0x02, 0x73, 0x02, 0xFD, 0x04, 0x76, 0x0D, 0xFC, 0x09, 0x73, 0x09, 0xFC, 0x0B,
  0x77, 0x05, 0xFC, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xFC, 0x03, 0x77, 0x10, 0xDF, 0xC0, 0x77, 0x10,
  0x7F, 0xC0, 0xB7, 0x72, 0x05, 0xFC, 0x0E, 0x71, 0x0E, 0xFC, 0x03, 0x77, 0x30, 0xCF, 0xC0, 0x66,
  0x06, 0xFC, 0x0A, 0x77, 0x40, 0x5F, 0xC0, 0xD6, 0x0D, 0xFC, 0x02, 0x77, 0x50, 0xCF, 0xC0, 0x44,
  0x04, 0xFC, 0x0A, 0x77, 0x60, 0x4F, 0xC0, 0xB4, 0x0B, 0xFC, 0x02, 0x77, 0x70, 0xCF, 0xC0, 0x32,
  0x03, 0xFC, 0x09, 0x77, 0x71, 0x04, 0xFC, 0x0A, 0x20, 0xAF, 0xC0, 0x17, 0x77, 0x20, 0xCF, 0xC0,
  0x10, 0x2F, 0xC0, 0x97, 0x77, 0x30, 0x4F, 0xC0, 0x08, 0xFC, 0x01, 0x77, 0x74, 0x0B, 0xFB, 0x00,
  0xEF, 0xB0, 0x87, 0x77, 0x50, 0x3F, 0xFF, 0x0E, 0x01, 0x77, 0x76, 0x0B, 0xFF, 0xE0, 0x77, 0x77,
  0x70, 0x3F, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x10, 0xBF, 0xFC, 0x07, 0x77, 0x77, 0x20, 0x3F, 0xFB,
  0x0E, 0x77, 0x77, 0x40, 0xBF, 0xFA, 0x06, 0x77, 0x70, 0x18, 0x0C, 0x2F, 0x01, 0x73, 0x01, 0x80,
  0xC2, 0xF0, 0x17, 0x30, 0x18, 0x0C, 0x2F, 0x01, 0x73, 0x01, 0x80, 0xC2, 0xF0, 0x17, 0x30, 0x18,
  0x0C, 0x2F, 0x01, 0x73, 0x01, 0x80, 0xC2, 0xF0, 0x17, 0x30, 0x18, 0x0C, 0x2F, 0x01, 0x73, 0x01,
  0x80, 0xC2, 0xF0, 0x17, 0x77, 0x20, 0x1F, 0xD0, 0x18, 0x0C, 0x00, 0x01, 0xFD, 0x01, 0x80, 0xC0,
  0x00, 0x1F, 0xD0, 0x18, 0x0C, 0x00, 0x01, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x1F, 0xD0, 0x18, 0x0C,
  0x00, 0x01, 0xFD, 0x01, 0x77, 0x72, 0x01, 0x80, 0xC2, 0xF0, 0x17, 0x30, 0x18, 0x0C, 0x2F, 0x01,
  0x73, 0x01, 0x80, 0xC2, 0xF0, 0x17, 0x30, 0x18, 0x0C, 0x2F, 0x01, 0x73, 0x01, 0x80, 0xC2, 0xF0,
  0x17, 0x30, 0x18, 0x0C, 0x2F, 0x01, 0x73, 0x01, 0x80, 0xC2, 0xF0, 0x17, 0x30, 0x18, 0x0C, 0x2F,
  0x01, 0x77, 0x72, 0x01, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x1F, 0xD0, 0x18, 0x0C, 0x00, 0x01, 0xFD,
  0x01, 0x80, 0xC0, 0x00, 0x1F, 0xD0, 0x18, 0x0C, 0x00, 0x01, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x1F,
  0xD0, 0x18, 0x0C, 0x00, 0x01, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x1F, 0xD0, 0x18, 0x0C, 0x00, 0x01,
  0xFD, 0x01, 0x80, 0xC0, 0x00, 0x1F, 0xD0, 0x17, 0x74,
  // "¦" (U+00A6)
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E,
  0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0x80, 0xAC, 0x60, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA,
  0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA,
  0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA,
  0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA,
  0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA, 0x0E, 0xFA,
  0x0E, 0xFA, 0x0E,
  // "§" (U+00A7)
  0x74, 0x89, 0x61, 0x47, 0xAC, 0xDE, 0xEF, 0xED, 0xCB, 0x96, 0x37, 0x73, 0x81, 0x15, 0xBF, 0xFB,
  0x81, 0xC7, 0x37, 0x50, 0x70, 0xEF, 0xFF, 0x98, 0x1E, 0x82, 0x70, 0x40, 0xDF, 0xFF, 0xE0, 0xC5,
  0x07, 0xFF, 0xFF, 0x90, 0xA4, 0x07, 0xFF, 0xFF, 0xA0, 0x33, 0x04, 0xFF, 0xFF, 0xA0, 0xC4, 0x0D,
  0xFF, 0xFF, 0xA0, 0x43, 0x05, 0xFD, 0x82, 0xD7, 0x31, 0x38, 0x22, 0x48, 0xCF, 0x0D, 0x40, 0xAF,
  0xC0, 0x97, 0x48, 0x11, 0x7D, 0xC0, 0x64, 0x0E, 0xFB, 0x0C, 0x77, 0x18, 0x24, 0xBF, 0xE5, 0xFC,
  0x07, 0x77, 0x30, 0x30, 0x54, 0x01, 0xFC, 0x07, 0x77, 0x73, 0xFC, 0x0A, 0x77, 0x73, 0x0D, 0xFC,
  0x02, 0x77, 0x72, 0x0A, 0xFC, 0x0D, 0x02, 0x77, 0x71, 0x05, 0xFE, 0x07, 0x77, 0x71, 0x0D, 0xFE,
  0x0D, 0x06, 0x77, 0x60, 0x4F, 0xF9, 0x81, 0xE7, 0x17, 0x74, 0x08, 0xFF, 0xB0, 0x90, 0x37, 0x73,
  0x09, 0xFF, 0xC0, 0xB0, 0x47, 0x72, 0x07, 0xFF, 0xD0, 0xC0, 0x37, 0x71, 0x03, 0x0E, 0xFF, 0xD0,
  0xB0, 0x17, 0x50, 0x10, 0xAF, 0xFF, 0x0E, 0x06, 0x73, 0x03, 0x0D, 0xFF, 0xFB, 0x0A, 0x71, 0x03,
  0x0E, 0xFF, 0xFD, 0x0C, 0x01, 0x50, 0x10, 0xEF, 0xB0, 0x0E, 0xFF, 0xA0, 0xC5, 0x0B, 0xFB, 0x09,
  0x20, 0x50, 0xBF, 0xF9, 0x0B, 0x30, 0x5F, 0xB0, 0x85, 0x03, 0x0A, 0xFF, 0x04, 0x20, 0xCF, 0xA0,
  0xC7, 0x10, 0x30, 0xCF, 0xD8, 0x1C, 0x02, 0xFB, 0x05, 0x73, 0x08, 0xFD, 0x02, 0x05, 0xFB, 0x02,
  0x74, 0x08, 0xFC, 0x07, 0x08, 0xFB, 0x01, 0x75, 0x0C, 0xFB, 0x00, 0x9F, 0xB0, 0x37, 0x50, 0x5F,
  0xB0, 0xB0, 0x9F, 0xB0, 0x87, 0x50, 0x1F, 0xB0, 0xC0, 0x8F, 0xB0, 0xE0, 0x17, 0x5F, 0xB0, 0xB0,
  0x6F, 0xC0, 0xD0, 0x17, 0x30, 0x1F, 0xB0, 0xA0, 0x2F, 0xD0, 0xD0, 0x37, 0x20, 0x4F, 0xB8, 0x17,
  0x0D, 0xFE, 0x09, 0x01, 0x70, 0xAF, 0xB8, 0x13, 0x06, 0xFF, 0x0E, 0x07, 0x50, 0x3F, 0xB0, 0xD3,
  0x0D, 0xFF, 0x98, 0x4E, 0x71, 0x02, 0xDF, 0xB0, 0x63, 0x02, 0x0E, 0xFF, 0xA8, 0x1E, 0x9D, 0xFB,
  0x0C, 0x50, 0x30, 0xEF, 0xFF, 0xE0, 0xE0, 0x26, 0x01, 0x0C, 0xFF, 0xFD, 0x04, 0x72, 0x08, 0xFF,
  0xFA, 0x0E, 0x03, 0x74, 0x03, 0x0C, 0xFF, 0xE0, 0xD0, 0x17, 0x70, 0x50, 0xDF, 0xFD, 0x09, 0x77,
  0x20, 0x60, 0xDF, 0xFC, 0x0B, 0x77, 0x30, 0x50, 0xDF, 0xFB, 0x0A, 0x77, 0x40, 0x40, 0xBF, 0xFA,
  0x07, 0x77, 0x50, 0x30, 0xAF, 0xF9, 0x01, 0x77, 0x60, 0x30, 0xCF, 0xE0, 0x87, 0x77, 0x10, 0x7F,
  0xD0, 0xD7, 0x77, 0x20, 0x6F, 0xD0, 0x17, 0x77, 0x20, 0xBF, 0xC0, 0x47, 0x77, 0x20, 0x6F, 0xC0,
  0x57, 0x77, 0x20, 0x4F, 0xC0, 0x50, 0x37, 0x77, 0x10, 0x4F, 0xC8, 0x24, 0xBD, 0x57, 0x76, 0x08,
  0xFC, 0x02, 0x0B, 0xA8, 0x1E, 0x82, 0x77, 0x20, 0x2F, 0xC8, 0x1D, 0x0B, 0xD8, 0x1C, 0x72, 0x75,
  0x03, 0x0E, 0xFC, 0x81, 0x90, 0xBF, 0x98, 0x3D, 0xA6, 0x42, 0x38, 0x21, 0x36, 0xBF, 0xE8, 0x12,
  0x0B, 0xFF, 0xFF, 0xC0, 0x92, 0x0B, 0xFF, 0xFF, 0xB0, 0xD3, 0x0B, 0xFF, 0xFF, 0xA0, 0xE0, 0x23,
  0x0B, 0xFF, 0xFF, 0x90, 0xD0, 0x24, 0x09, 0xFF, 0xFF, 0x08, 0x70, 0x20, 0x9F, 0xFF, 0xB0, 0xB0,
  0x27, 0x38, 0x21, 0x59, 0xEF, 0xFB, 0x81, 0xD7, 0x27, 0x72, 0x86, 0x25, 0x7A, 0xCD, 0xDE, 0xA8,
  0x5E, 0xDC, 0xA7, 0x52, 0x75,
  // "¨" (U+00A8)
  0x38, 0x65, 0xAE, 0xFE, 0xC7, 0x17, 0x68, 0x65, 0xAD, 0xFE, 0xC7, 0x14, 0x01, 0x0B, 0xF0, 0xE0,
  0x37, 0x40, 0xBF, 0x0E, 0x04, 0x30, 0xBF, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xB8, 0x13, 0x03, 0xFC,
  0x0A, 0x71, 0x03, 0xFC, 0x81, 0xB0, 0x8F, 0xC0, 0xE7, 0x10, 0x8F, 0xD1, 0x0A, 0xFD, 0x02, 0x70,
  0xAF, 0xD0, 0x30, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04, 0x0A, 0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x30,
  0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD1, 0x02, 0xFC, 0x09, 0x71, 0x02, 0xFC, 0x0A, 0x20, 0xAF, 0xA0,
  0xE0, 0x17, 0x20, 0x9F, 0xA0, 0xE0, 0x23, 0x0A, 0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x58,
  0x54, 0xAE, 0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x74,
  // "©" (U+00A9)
  0x77, 0x48, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x74, 0x05, 0x0A, 0xFF,
  0xA8, 0x1B, 0x61, 0x77, 0x75, 0x81, 0x18, 0xEF, 0xFE, 0x81, 0xE8, 0x17, 0x77, 0x20, 0x70, 0xEF,
  0xFF, 0xB0, 0xE0, 0x77, 0x76, 0x02, 0x0C, 0xFF, 0xFF, 0x0B, 0x02, 0x77, 0x30, 0x40, 0xEF, 0xFF,
  0xFA, 0x0E, 0x03, 0x77, 0x10, 0x6F, 0xC8, 0x3A, 0x74, 0x21, 0x28, 0x31, 0x24, 0x7B, 0xFC, 0x05,
  0x76, 0x05, 0xFA, 0x0D, 0x05, 0x77, 0x05, 0x0C, 0xFA, 0x04, 0x74, 0x03, 0xF9, 0x0E, 0x06, 0x77,
  0x40, 0x50, 0xEF, 0x0E, 0x02, 0x72, 0x01, 0x0E, 0xF0, 0xB0, 0x15, 0x83, 0x16, 0xAC, 0xEA, 0x83,
  0xEC, 0x96, 0x13, 0x01, 0x0A, 0xF0, 0xD7, 0x20, 0xAF, 0x0A, 0x50, 0x20, 0xAF, 0xD0, 0xC0, 0x53,
  0x08, 0xF0, 0x97, 0x05, 0xF0, 0xA5, 0x07, 0xFF, 0xA0, 0x73, 0x08, 0xF0, 0x36, 0x0D, 0xE0, 0xC5,
  0x0A, 0xFF, 0xB0, 0x14, 0x0A, 0xE0, 0xC5, 0x05, 0xE0, 0xE0, 0x14, 0x08, 0xFF, 0xB0, 0xB5, 0x01,
  0x0D, 0xE0, 0x34, 0x0C, 0xE0, 0x74, 0x04, 0xFF, 0xC0, 0x56, 0x04, 0xE0, 0xA3, 0x02, 0xE0, 0xE5,
  0x0E, 0xF9, 0x89, 0x09, 0x41, 0x01, 0x48, 0xDF, 0xE7, 0x10, 0xCE, 0x01, 0x20, 0x7E, 0x07, 0x40,
  0x6F, 0x0E, 0x03, 0x71, 0x05, 0x07, 0x71, 0x05, 0xE0, 0x62, 0x0C, 0xE0, 0x14, 0x0D, 0xF0, 0x37,
  0x76, 0x0E, 0xD0, 0xA2, 0xE0, 0xC4, 0x03, 0xF0, 0x87, 0x77, 0x0A, 0xD8, 0x1E, 0x03, 0xE0, 0x74,
  0x06, 0xF0, 0x17, 0x77, 0x06, 0xE0, 0x20, 0x5E, 0x04, 0x40, 0xAE, 0x0B, 0x77, 0x71, 0x03, 0xE0,
  0x40, 0x7E, 0x02, 0x40, 0xCE, 0x07, 0x77, 0x71, 0x01, 0xE0, 0x70, 0x8E, 0x50, 0xEE, 0x04, 0x77,
  0x72, 0xE0, 0x80, 0x9D, 0x0E, 0x5F, 0x03, 0x77, 0x72, 0x0E, 0xD0, 0x09, 0xD0, 0xE5, 0xF0, 0x27,
  0x77, 0x20, 0xED, 0x00, 0x9D, 0x0E, 0x5F, 0x02, 0x77, 0x72, 0xE0, 0x90, 0x8E, 0x50, 0xEE, 0x03,
  0x77, 0x72, 0xE0, 0x80, 0x7E, 0x01, 0x40, 0xDE, 0x05, 0x77, 0x71, 0x02, 0xE0, 0x70, 0x5E, 0x04,
  0x40, 0xBE, 0x08, 0x77, 0x71, 0x04, 0xE0, 0x60, 0x2E, 0x07, 0x40, 0x7E, 0x0C, 0x77, 0x71, 0x07,
  0xE0, 0x31, 0xE0, 0xB4, 0x04, 0xF0, 0x37, 0x77, 0x0C, 0xE2, 0x0B, 0xE0, 0x14, 0x0E, 0xE0, 0xC7,
  0x76, 0x01, 0xE0, 0xD2, 0x06, 0xE0, 0x74, 0x07, 0xF0, 0xB0, 0x17, 0x20, 0x20, 0x37, 0x07, 0xE0,
  0x82, 0x02, 0xE0, 0xD4, 0x01, 0x0E, 0xF8, 0x2E, 0x73, 0x12, 0x84, 0x24, 0x8C, 0xF8, 0x70, 0xEE,
  0x03, 0x30, 0xBE, 0x06, 0x40, 0x6F, 0xFC, 0x08, 0x60, 0x7E, 0x0D, 0x40, 0x5E, 0x0E, 0x01, 0x40,
  0xBF, 0xFB, 0x08, 0x50, 0x2F, 0x07, 0x50, 0xDE, 0x0B, 0x50, 0xCF, 0xFA, 0x08, 0x50, 0xCE, 0x0E,
  0x60, 0x5F, 0x08, 0x50, 0x9F, 0xF9, 0x08, 0x40, 0xAF, 0x06, 0x70, 0xBF, 0x08, 0x50, 0x40, 0xBF,
  0xD0, 0xC0, 0x43, 0x0A, 0xF0, 0xC7, 0x10, 0x20, 0xEF, 0x0A, 0x01, 0x58, 0x32, 0x7A, 0xDE, 0xA8,
  0x3E, 0xCA, 0x62, 0x30, 0x20, 0xCF, 0x90, 0x27, 0x20, 0x4F, 0x90, 0xD0, 0x47, 0x74, 0x06, 0x0E,
  0xF9, 0x05, 0x74, 0x07, 0xFA, 0x0C, 0x05, 0x76, 0x81, 0x16, 0xDF, 0xA0, 0x77, 0x60, 0x7F, 0xB8,
  0x4E, 0xA7, 0x42, 0x12, 0x83, 0x12, 0x57, 0xBF, 0xC0, 0x77, 0x71, 0x07, 0xFF, 0xFF, 0xC0, 0x57,
  0x73, 0x04, 0x0D, 0xFF, 0xFF, 0x0C, 0x03, 0x77, 0x50, 0x10, 0xAF, 0xFF, 0xD0, 0x77, 0x77, 0x20,
  0x20, 0xAF, 0xFF, 0x81, 0xE8, 0x17, 0x77, 0x58, 0x12, 0x7D, 0xFF, 0xA0, 0xB0, 0x67, 0x77, 0x74,
  0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77, 0x40,
  // "ª" (U+00AA)
  0x72, 0x89, 0x33, 0x68, 0xBD, 0xDE, 0xFE, 0xDB, 0x85, 0x76, 0x81, 0x49, 0xEF, 0xE8, 0x1E, 0x81,
  0x71, 0x07, 0x0D, 0xFF, 0xC0, 0xD0, 0x36, 0x04, 0xFF, 0xF9, 0x03, 0x60, 0xCF, 0xFF, 0x0E, 0x01,
  0x50, 0x5F, 0xFF, 0x90, 0x96, 0x0D, 0xD8, 0x5C, 0x86, 0x55, 0x7B, 0xFB, 0x01, 0x50, 0x6A, 0x81,
  0xD7, 0x17, 0x04, 0x0E, 0xF9, 0x06, 0x60, 0xC0, 0x57, 0x40, 0x5F, 0x90, 0xA7, 0x76, 0x0D, 0xF0,
  0xD7, 0x76, 0x0A, 0xF0, 0xE7, 0x76, 0x08, 0xF9, 0x77, 0x60, 0x8F, 0x97, 0x18, 0x52, 0x68, 0xAC,
  0xDE, 0xFF, 0x58, 0x12, 0x8D, 0xFF, 0xF4, 0x09, 0xFF, 0xFB, 0x20, 0x10, 0xCF, 0xFF, 0xC2, 0x0A,
  0xFF, 0xFD, 0x10, 0x4F, 0xA8, 0x2C, 0x63, 0x15, 0x08, 0xF9, 0x10, 0x9F, 0x90, 0xA7, 0x20, 0x8F,
  0x91, 0x0E, 0xF0, 0xE7, 0x30, 0x9F, 0x91, 0xF9, 0x09, 0x73, 0x0D, 0xF9, 0x01, 0xF9, 0x08, 0x72,
  0x04, 0xFA, 0x1F, 0x90, 0xB7, 0x10, 0x20, 0xEF, 0xA1, 0xFA, 0x04, 0x60, 0x40, 0xEF, 0xB1, 0x0B,
  0xFA, 0x84, 0x96, 0x45, 0x8C, 0xFD, 0x10, 0x7F, 0xFF, 0xE1, 0x01, 0x0E, 0xFF, 0xC0, 0x60, 0xDE,
  0x20, 0x5F, 0xFB, 0x81, 0x70, 0x9E, 0x30, 0x6F, 0xF0, 0xE0, 0x52, 0x04, 0xE4, 0x03, 0x0C, 0xFB,
  0x81, 0xE9, 0x14, 0x0E, 0xD6, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x60, 0x58, 0x01, 0x70,
  // "«" (U+00AB)
  0x77, 0x81, 0x1C, 0x67, 0x73, 0x0B, 0x08, 0x77, 0x71, 0x0B, 0xA0, 0xD0, 0x57, 0x70, 0x8A, 0x0E,
  0x07, 0x77, 0x50, 0x8D, 0x0C, 0x04, 0x74, 0x04, 0xD0, 0xD0, 0x67, 0x72, 0x04, 0xF9, 0x0B, 0x03,
  0x71, 0x01, 0x0E, 0xF0, 0xD0, 0x57, 0x60, 0x20, 0xEF, 0xB0, 0xA0, 0x16, 0x0C, 0xFB, 0x0C, 0x03,
  0x74, 0x0C, 0xFC, 0x0C, 0x60, 0x8F, 0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x25, 0x05, 0xFD, 0x06,
  0x73, 0x05, 0xFD, 0x06, 0x50, 0x20, 0xEF, 0xC0, 0xB7, 0x30, 0x20, 0xEF, 0xC0, 0xB6, 0x0C, 0xFC,
  0x0E, 0x01, 0x73, 0x0C, 0xFC, 0x0E, 0x01, 0x50, 0x9F, 0xD0, 0x57, 0x30, 0x9F, 0xD0, 0x55, 0x05,
  0xFD, 0x0A, 0x73, 0x05, 0xFD, 0x0A, 0x50, 0x20, 0xEF, 0xC0, 0xD0, 0x17, 0x20, 0x20, 0xEF, 0xC0,
  0xE0, 0x15, 0x0C, 0xFD, 0x04, 0x73, 0x0D, 0xFD, 0x04, 0x50, 0x9F, 0xD0, 0x97, 0x30, 0x9F, 0xD0,
  0x95, 0x06, 0xFD, 0x0D, 0x73, 0x06, 0xFD, 0x0D, 0x50, 0x20, 0xEF, 0xD0, 0x37, 0x20, 0x2F, 0xE0,
  0x35, 0x0D, 0xFD, 0x08, 0x73, 0x0D, 0xFD, 0x08, 0x50, 0xAF, 0xD0, 0xC7, 0x30, 0xAF, 0xD0, 0xC5,
  0x06, 0xFE, 0x02, 0x72, 0x06, 0xFE, 0x02, 0x40, 0x2F, 0xE0, 0x77, 0x30, 0x9F, 0xD0, 0xB5, 0x05,
  0xFE, 0x01, 0x73, 0x03, 0xFE, 0x05, 0x40, 0x10, 0xDF, 0xD0, 0xA7, 0x40, 0x6F, 0xD0, 0xE0, 0x14,
  0x03, 0xFE, 0x05, 0x74, 0x0A, 0xFD, 0x0B, 0x50, 0x6F, 0xD0, 0xE0, 0x17, 0x40, 0xDF, 0xD0, 0x65,
  0x0A, 0xFD, 0x0B, 0x74, 0x03, 0xFE, 0x02, 0x50, 0xDF, 0xD0, 0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x02,
  0xFE, 0x02, 0x74, 0x0A, 0xFD, 0x08, 0x50, 0x6F, 0xD0, 0xC7, 0x50, 0xDF, 0xD0, 0x35, 0x09, 0xFD,
  0x08, 0x74, 0x02, 0x0E, 0xFC, 0x0D, 0x60, 0xDF, 0xD0, 0x37, 0x40, 0x5F, 0xD0, 0x95, 0x02, 0x0E,
  0xFC, 0x0D, 0x75, 0x09, 0xFD, 0x05, 0x50, 0x5F, 0xD0, 0x97, 0x50, 0xCF, 0xC0, 0xE0, 0x15, 0x09,
  0xFD, 0x04, 0x74, 0x02, 0x0E, 0xFC, 0x0B, 0x60, 0xCF, 0xC0, 0xE0, 0x17, 0x40, 0x5F, 0xD0, 0x65,
  0x02, 0x0E, 0xFC, 0x0A, 0x75, 0x09, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xD0, 0x57, 0x50, 0xCF, 0xA0,
  0xC0, 0x47, 0x09, 0xFA, 0x0E, 0x06, 0x76, 0x02, 0x0E, 0xE0, 0xD0, 0x57, 0x30, 0xCE, 0x0E, 0x07,
  0x77, 0x20, 0x4C, 0x0E, 0x06, 0x75, 0x02, 0x0E, 0xC0, 0x90, 0x17, 0x74, 0x82, 0x8F, 0xE8, 0x77,
  0x10, 0x4A, 0x0A, 0x02, 0x77, 0x70, 0x70, 0x17, 0x73, 0x06, 0x03, 0x71,
  // "¬" (U+00AC)
  0x0A, 0x80, 0xC3, 0xF0, 0xC0, 0xA8, 0x0C, 0x3F, 0x0C, 0x0A, 0x80, 0xC3, 0xF0, 0xC0, 0xA8, 0x0C,
  0x3F, 0x0C, 0x0A, 0x80, 0xC3, 0xF0, 0xC0, 0xA8, 0x0C, 0x3F, 0x0C, 0x0A, 0x80, 0xC3, 0xF0, 0xC0,
  0xA8, 0x0C, 0x3F, 0x0C, 0x0A, 0x80, 0xC3, 0xF0, 0xC0, 0xA8, 0x0C, 0x3F, 0x0C, 0x77, 0x77, 0x30,
  0xCF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7, 0x77, 0x73,
  0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77,
  0x30, 0xCF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7, 0x77,
  0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77,
  0x77, 0x30, 0xCF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7,
  0x77, 0x73, 0x0C, 0xF9, 0x0C,
  // "®" (U+00AE)
  0x77, 0x48, 0x44, 0x79, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77, 0x77, 0x50, 0x50, 0xAF, 0xFA,
  0x0A, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x30, 0x60, 0xEF, 0xFF, 0xB0,
  0xE0, 0x67, 0x76, 0x01, 0x0B, 0xFF, 0xFF, 0x0A, 0x01, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0xFA, 0x0E,
  0x02, 0x77, 0x10, 0x5F, 0xC8, 0x3A, 0x74, 0x21, 0x28, 0x31, 0x24, 0x7B, 0xFB, 0x0E, 0x03, 0x76,
  0x04, 0xFA, 0x81, 0xD6, 0x17, 0x60, 0x50, 0xCF, 0xA0, 0x37, 0x40, 0x30, 0xEF, 0x0E, 0x06, 0x77,
  0x40, 0x50, 0xEF, 0x0E, 0x01, 0x72, 0x01, 0x0D, 0xF0, 0xC0, 0x27, 0x76, 0x01, 0x0A, 0xF0, 0xC7,
  0x20, 0x9F, 0x0B, 0x20, 0xBF, 0xA8, 0x3E, 0xDB, 0x84, 0x70, 0x8F, 0x07, 0x70, 0x3F, 0x0B, 0x30,
  0xBF, 0xF0, 0xD0, 0x66, 0x08, 0xF0, 0x26, 0x0C, 0xE0, 0xD0, 0x13, 0x0B, 0xFF, 0xA0, 0xB6, 0x0A,
  0xE0, 0xA5, 0x04, 0xF0, 0x34, 0x0B, 0xFF, 0xB0, 0xA5, 0x01, 0x0E, 0xE0, 0x24, 0x0B, 0xE0, 0x95,
  0x0B, 0xFF, 0xC0, 0x45, 0x05, 0xE0, 0x93, 0x01, 0xF0, 0x15, 0x0B, 0xD0, 0xB3, 0x81, 0x26, 0xEE,
  0x0B, 0x60, 0xDD, 0x0E, 0x30, 0x6E, 0x09, 0x60, 0xBD, 0x0B, 0x50, 0x2F, 0x60, 0x5E, 0x04, 0x20,
  0xBE, 0x03, 0x60, 0xBD, 0x0B, 0x60, 0xCE, 0x02, 0x6E, 0x09, 0x20, 0xED, 0x0D, 0x70, 0xBD, 0x0B,
  0x60, 0xAE, 0x03, 0x60, 0xBD, 0x81, 0xD0, 0x1E, 0x09, 0x70, 0xBD, 0x0B, 0x60, 0xBE, 0x03, 0x60,
  0x7E, 0x10, 0x4E, 0x06, 0x70, 0xBD, 0x0B, 0x60, 0xEE, 0x02, 0x60, 0x4E, 0x03, 0x06, 0xE0, 0x37,
  0x0B, 0xD0, 0xB5, 0x07, 0xE0, 0xE7, 0x02, 0xE0, 0x50, 0x7E, 0x01, 0x70, 0xBD, 0x0B, 0x28, 0x11,
  0x3A, 0xF0, 0xA7, 0x01, 0xE0, 0x60, 0x8E, 0x71, 0x0B, 0xFF, 0xC0, 0x37, 0x1E, 0x07, 0x08, 0xE7,
  0x10, 0xBF, 0xFB, 0x08, 0x72, 0xE0, 0x80, 0x7E, 0x71, 0x0B, 0xFF, 0xA0, 0x97, 0x20, 0x1E, 0x08,
  0x07, 0xE0, 0x17, 0x0B, 0xFF, 0x90, 0x57, 0x30, 0x1E, 0x07, 0x06, 0xE0, 0x37, 0x0B, 0xFF, 0x90,
  0x47, 0x30, 0x3E, 0x06, 0x03, 0xE0, 0x57, 0x0B, 0xD0, 0xB3, 0x0B, 0xD0, 0xB7, 0x30, 0x6E, 0x04,
  0x01, 0xE0, 0x87, 0x0B, 0xD0, 0xB3, 0x04, 0xE0, 0x37, 0x20, 0x9E, 0x81, 0x20, 0xDD, 0x0C, 0x70,
  0xBD, 0x0B, 0x40, 0xDD, 0x0A, 0x72, 0x0D, 0xD0, 0xE2, 0x09, 0xE0, 0x16, 0x0B, 0xD0, 0xB4, 0x08,
  0xE0, 0x17, 0x02, 0xE0, 0xC2, 0x05, 0xE0, 0x76, 0x0B, 0xD0, 0xB4, 0x01, 0xE0, 0x87, 0x08, 0xE0,
  0x72, 0x01, 0xE0, 0xD6, 0x0B, 0xD0, 0xB5, 0x0B, 0xD0, 0xE0, 0x15, 0x01, 0x0E, 0xE0, 0x23, 0x0A,
  0xE0, 0x65, 0x0B, 0xD0, 0xB5, 0x05, 0xE0, 0x75, 0x08, 0xE0, 0xD4, 0x03, 0xE0, 0xE0, 0x14, 0x0B,
  0xD0, 0xB6, 0x0E, 0xD0, 0xD4, 0x02, 0xF0, 0x65, 0x0C, 0xE0, 0xB4, 0x0B, 0xD0, 0xB6, 0x08, 0xE0,
  0x53, 0x0C, 0xE0, 0xD6, 0x03, 0xF0, 0x83, 0x0B, 0xD0, 0xB6, 0x02, 0xE0, 0xC2, 0x0A, 0xF0, 0x67,
  0x09, 0xF0, 0x82, 0x04, 0x80, 0x16, 0x05, 0x70, 0x58, 0x02, 0x60, 0x10, 0xAF, 0x0B, 0x71, 0x01,
  0x0D, 0xF0, 0xA0, 0x17, 0x76, 0x02, 0x0C, 0xF9, 0x02, 0x72, 0x03, 0xF9, 0x0D, 0x04, 0x77, 0x40,
  0x60, 0xEF, 0x90, 0x57, 0x40, 0x6F, 0xA0, 0xC0, 0x57, 0x68, 0x11, 0x6D, 0xFA, 0x07, 0x76, 0x06,
  0xFB, 0x84, 0xEA, 0x74, 0x21, 0x28, 0x31, 0x25, 0x7B, 0xFC, 0x08, 0x77, 0x10, 0x5F, 0xFF, 0xFC,
  0x06, 0x77, 0x30, 0x30, 0xDF, 0xFF, 0xF0, 0xD0, 0x37, 0x76, 0x09, 0xFF, 0xFD, 0x08, 0x77, 0x72,
  0x02, 0x0A, 0xFF, 0xF8, 0x1E, 0x81, 0x77, 0x75, 0x81, 0x27, 0xCF, 0xFA, 0x81, 0xB6, 0x17, 0x77,
  0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77, 0x40,
  // "¯" (U+00AF)
  0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A,
  0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A, 0x09, 0xFF, 0xFD, 0x0A,
  0x09, 0xFF, 0xFD, 0x0A,
  // "°" (U+00B0)
  0x73, 0x82, 0x49, 0xBE, 0xA8, 0x2E, 0xC9, 0x47, 0x74, 0x07, 0x0E, 0xFB, 0x81, 0xE7, 0x17, 0x60,
  0x40, 0xDF, 0xF0, 0xE0, 0x57, 0x40, 0x7F, 0xFC, 0x08, 0x72, 0x08, 0xFF, 0xE0, 0x97, 0x05, 0xFF,
  0xF9, 0x07, 0x50, 0x20, 0xEF, 0xFF, 0xA0, 0x34, 0x0A, 0xFF, 0xFB, 0x0C, 0x30, 0x3F, 0xA8, 0x1E,
  0x72, 0x28, 0x12, 0x7E, 0xFA, 0x04, 0x20, 0x8F, 0x90, 0xC0, 0x16, 0x01, 0x0B, 0xF9, 0x0A, 0x20,
  0xDF, 0x0D, 0x01, 0x72, 0x0C, 0xF8, 0x1E, 0x01, 0xF9, 0x05, 0x73, 0x03, 0xF9, 0x02, 0x03, 0xF0,
  0xE7, 0x50, 0xDF, 0x00, 0x4F, 0x0D, 0x75, 0x0B, 0xF0, 0x50, 0x4F, 0x0D, 0x75, 0x0B, 0xF0, 0x50,
  0x3F, 0x0E, 0x75, 0x0D, 0xF0, 0x40, 0x1F, 0x90, 0x47, 0x30, 0x3F, 0x98, 0x12, 0x0D, 0xF0, 0xC7,
  0x30, 0xBF, 0x92, 0x09, 0xF9, 0x0B, 0x71, 0x09, 0xF9, 0x0A, 0x20, 0x3F, 0xA8, 0x1D, 0x62, 0x28,
  0x12, 0x6C, 0xFA, 0x05, 0x30, 0xBF, 0xFF, 0xB0, 0xD4, 0x03, 0xFF, 0xFB, 0x05, 0x50, 0x7F, 0xFF,
  0x90, 0xA7, 0x0A, 0xFF, 0xE0, 0xC7, 0x20, 0x9F, 0xFC, 0x0C, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0x90,
  0x97, 0x60, 0x10, 0x8F, 0xD0, 0xB0, 0x37, 0x73, 0x82, 0x59, 0xCE, 0xA8, 0x3E, 0xCA, 0x61, 0x72,
  // "±" (U+00B1)
  0x77, 0x20, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7,
  0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E,
  0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90,
  0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9,
  0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF,
  0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x20, 0x88, 0x0C, 0x4F, 0x0A, 0x08, 0x80, 0xC4,
  0xF0, 0xA0, 0x88, 0x0C, 0x4F, 0x0A, 0x08, 0x80, 0xC4, 0xF0, 0xA0, 0x88, 0x0C, 0x4F, 0x0A, 0x08,
  0x80, 0xC4, 0xF0, 0xA0, 0x88, 0x0C, 0x4F, 0x0A, 0x08, 0x80, 0xC4, 0xF0, 0xA0, 0x88, 0x0C, 0x4F,
  0x0A, 0x08, 0x80, 0xC4, 0xF0, 0xA7, 0x72, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7,
  0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E,
  0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90,
  0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9,
  0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF,
  0x90, 0xE7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xE8, 0x0A, 0xE4, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A,
  // "²" (U+00B2)
  0x71, 0x89, 0x22, 0x6A, 0xCE, 0xEF, 0xED, 0xB7, 0x37, 0x78, 0x11, 0x7D, 0xFD, 0x0D, 0x06, 0x74,
  0x08, 0x0E, 0xFF, 0xA0, 0xB0, 0x17, 0x04, 0x0D, 0xFF, 0xD0, 0xD0, 0x15, 0x08, 0xFF, 0xF9, 0x0C,
  0x40, 0x4F, 0xFF, 0xB0, 0x54, 0x0A, 0xFF, 0xFA, 0x0B, 0x40, 0x10, 0xDF, 0x83, 0xEB, 0x9A, 0xCF,
  0xC5, 0x03, 0xD0, 0xC0, 0x45, 0x03, 0x0D, 0xFA, 0x04, 0x50, 0x8B, 0x07, 0x71, 0x02, 0xFA, 0x05,
  0x68, 0x1C, 0xE4, 0x73, 0x0C, 0xF9, 0x07, 0x60, 0x20, 0x37, 0x40, 0xAF, 0x90, 0x77, 0x75, 0x0B,
  0xF9, 0x07, 0x77, 0x50, 0xCF, 0x90, 0x57, 0x74, 0x01, 0xFA, 0x03, 0x77, 0x40, 0x7F, 0x90, 0xE7,
  0x74, 0x01, 0x0E, 0xF9, 0x09, 0x77, 0x40, 0xBF, 0xA0, 0x27, 0x73, 0x07, 0xFA, 0x09, 0x77, 0x30,
  0x6F, 0xA0, 0xD0, 0x17, 0x72, 0x06, 0xFB, 0x03, 0x77, 0x20, 0x7F, 0xB0, 0x57, 0x72, 0x08, 0xFB,
  0x05, 0x77, 0x20, 0x8F, 0xB0, 0x57, 0x72, 0x09, 0xFB, 0x04, 0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x37,
  0x72, 0x09, 0xFA, 0x0E, 0x03, 0x77, 0x20, 0xAF, 0xA0, 0xE0, 0x37, 0x72, 0x0A, 0xFA, 0x0E, 0x02,
  0x77, 0x20, 0xAF, 0xA0, 0xD0, 0x27, 0x72, 0x0A, 0xFA, 0x0D, 0x01, 0x77, 0x20, 0xBF, 0xB0, 0xA8,
  0x09, 0x38, 0x03, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02,
  0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06,
  // "³" (U+00B3)
  0x71, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0x96, 0x17, 0x68, 0x12, 0xAE, 0xFD, 0x0B, 0x03, 0x72,
  0x03, 0x0A, 0xFF, 0xB0, 0x97, 0x07, 0xFF, 0xE0, 0xB4, 0x01, 0x0B, 0xFF, 0xF9, 0x0A, 0x30, 0x20,
  0xEF, 0xFF, 0xA0, 0x43, 0x06, 0xFF, 0xFA, 0x0B, 0x40, 0xAF, 0x83, 0xDA, 0x99, 0xBF, 0xC0, 0x13,
  0x01, 0x0D, 0xB8, 0x1E, 0x72, 0x50, 0x10, 0xBF, 0xA0, 0x34, 0x04, 0xA0, 0x87, 0x30, 0xEF, 0x90,
  0x45, 0x06, 0x03, 0x74, 0x09, 0xF9, 0x04, 0x77, 0x40, 0x7F, 0x90, 0x27, 0x74, 0x09, 0xF0, 0xE7,
  0x74, 0x01, 0x0E, 0xF0, 0x87, 0x74, 0x0B, 0xF0, 0xE0, 0x17, 0x78, 0x21, 0x37, 0xDF, 0x90, 0x47,
  0x30, 0xEF, 0xF0, 0xE0, 0x57, 0x40, 0xEF, 0xE0, 0xB0, 0x27, 0x50, 0xEF, 0xC0, 0xC0, 0x47, 0x70,
  0xEF, 0xC8, 0x1C, 0x72, 0x76, 0x0E, 0xFF, 0x0A, 0x02, 0x74, 0x0E, 0xFF, 0x90, 0xE0, 0x57, 0x30,
  0xEF, 0xFB, 0x04, 0x77, 0x18, 0x12, 0x49, 0xFA, 0x0E, 0x01, 0x77, 0x30, 0x20, 0xDF, 0x90, 0x87,
  0x74, 0x03, 0xF9, 0x0E, 0x77, 0x50, 0xCF, 0x90, 0x37, 0x74, 0x09, 0xF9, 0x06, 0x01, 0x77, 0x30,
  0xAF, 0x98, 0x27, 0x4C, 0x37, 0x71, 0x0D, 0xF9, 0x06, 0x04, 0xA0, 0xA0, 0x37, 0x50, 0x5F, 0xA0,
  0x50, 0x4C, 0x81, 0xC7, 0x37, 0x10, 0x7F, 0xB0, 0x20, 0x4F, 0x86, 0xEC, 0xB9, 0x89, 0xBE, 0xFB,
  0x81, 0xD0, 0x4F, 0xFF, 0xC8, 0x17, 0x04, 0xFF, 0xFB, 0x0D, 0x20, 0x4F, 0xFF, 0xA0, 0xE0, 0x32,
  0x04, 0xFF, 0xF9, 0x0E, 0x03, 0x38, 0x11, 0x8E, 0xFF, 0xD0, 0xA0, 0x16, 0x81, 0x17, 0xCF, 0xF8,
  0x1E, 0xA3, 0x74, 0x89, 0x41, 0x58, 0xBD, 0xDE, 0xFE, 0xDC, 0xA7, 0x47, 0x20,
  // "´" (U+00B4)
  0x71, 0x01, 0x80, 0x92, 0x70, 0x17, 0x10, 0x9F, 0xE0, 0xE0, 0x17, 0x03, 0xFF, 0x04, 0x71, 0x0C,
  0xFE, 0x05, 0x71, 0x06, 0xFE, 0x05, 0x71, 0x01, 0x0E, 0xFD, 0x05, 0x72, 0x0B, 0xFC, 0x0E, 0x04,
  0x72, 0x06, 0xFC, 0x0E, 0x03, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x73, 0x0C, 0xFB, 0x0D, 0x02,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x73, 0x03, 0xFB, 0x0B, 0x01, 0x73, 0x01, 0x0D, 0xFA, 0x0A, 0x75,
  0x0A, 0xFA, 0x08, 0x76, 0x0E, 0xF0, 0xE0, 0x57, 0x70,
  // "µ" (U+00B5)
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F, 0xE0,
  0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7, 0x72,
  0x05, 0xFF, 0x07, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x7F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x07,
  0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x90, 0x7F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x07,
  0xFF, 0x90, 0xD0, 0x57, 0x01, 0x08, 0xFF, 0xC0, 0x7F, 0xFB, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0xFE,
  0x07, 0x80, 0xD0, 0xF0, 0x78, 0x0D, 0x0F, 0x07, 0x80, 0xD0, 0xF0, 0x7F, 0xFF, 0xFA, 0x81, 0xD0,
  0xDF, 0xC0, 0x7F, 0xFF, 0xF9, 0x82, 0xE2, 0x07, 0xFC, 0x07, 0xFF, 0xFF, 0x0E, 0x03, 0x20, 0x1F,
  0xC0, 0x7F, 0xFF, 0xE0, 0xB0, 0x14, 0x0B, 0xFB, 0x07, 0xFF, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB0,
  0x7F, 0xFF, 0xA0, 0xC0, 0x67, 0x2F, 0xB0, 0x7F, 0xD8, 0x1D, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x77, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77,
  0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87,
  0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08,
  0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0,
  0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD,
  0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F,
  0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07,
  0xFD, 0x08, 0x77, 0x77, 0x30,
  // "¶" (U+00B6)
  0x77, 0x85, 0x26, 0x9B, 0xDE, 0xEF, 0xFF, 0xC0, 0x77, 0x48, 0x12, 0x9D, 0xFF, 0xFF, 0xC0, 0x77,
  0x20, 0x30, 0xBF, 0xFF, 0xFF, 0x07, 0x71, 0x09, 0x80, 0xC1, 0xF0, 0x76, 0x02, 0x0D, 0x80, 0xC2,
  0xF0, 0x75, 0x02, 0x0E, 0x80, 0xC3, 0xF0, 0x74, 0x01, 0x0D, 0x80, 0xC4, 0xF0, 0x74, 0x0B, 0x80,
  0xC5, 0xF0, 0x73, 0x05, 0xFF, 0xFF, 0x90, 0x25, 0x06, 0xE0, 0x73, 0x0D, 0xFF, 0xFF, 0x90, 0x25,
  0x06, 0xE0, 0x72, 0x05, 0xFF, 0xFF, 0xA0, 0x25, 0x06, 0xE0, 0x72, 0x0B, 0xFF, 0xFF, 0xA0, 0x25,
  0x06, 0xE8, 0x17, 0x01, 0xFF, 0xFF, 0xB0, 0x25, 0x06, 0xE8, 0x17, 0x05, 0xFF, 0xFF, 0xB0, 0x25,
  0x06, 0xE8, 0x17, 0x09, 0xFF, 0xFF, 0xB0, 0x25, 0x06, 0xE8, 0x17, 0x0C, 0xFF, 0xFF, 0xB0, 0x25,
  0x06, 0xE8, 0x17, 0x0E, 0xFF, 0xFF, 0xB0, 0x25, 0x06, 0xE0, 0x70, 0x1F, 0xFF, 0xFC, 0x02, 0x50,
  0x6E, 0x07, 0x03, 0xFF, 0xFF, 0xC0, 0x25, 0x06, 0xE0, 0x70, 0x4F, 0xFF, 0xFC, 0x02, 0x50, 0x6E,
  0x07, 0x05, 0xFF, 0xFF, 0xC0, 0x25, 0x06, 0xE0, 0x70, 0x5F, 0xFF, 0xFC, 0x02, 0x50, 0x6E, 0x07,
  0x06, 0xFF, 0xFF, 0xC0, 0x25, 0x06, 0xE0, 0x70, 0x6F, 0xFF, 0xFC, 0x02, 0x50, 0x6E, 0x07, 0x05,
  0xFF, 0xFF, 0xC0, 0x25, 0x06, 0xE0, 0x70, 0x5F, 0xFF, 0xFC, 0x02, 0x50, 0x6E, 0x07, 0x03, 0xFF,
  0xFF, 0xC0, 0x25, 0x06, 0xE0, 0x70, 0x2F, 0xFF, 0xFC, 0x02, 0x50, 0x6E, 0x07, 0x1F, 0xFF, 0xFC,
  0x02, 0x50, 0x6E, 0x81, 0x70, 0xDF, 0xFF, 0xFB, 0x02, 0x50, 0x6E, 0x81, 0x70, 0xBF, 0xFF, 0xFB,
  0x02, 0x50, 0x6E, 0x81, 0x70, 0x7F, 0xFF, 0xFB, 0x02, 0x50, 0x6E, 0x81, 0x70, 0x3F, 0xFF, 0xFB,
  0x02, 0x50, 0x6E, 0x07, 0x20, 0xDF, 0xFF, 0xFA, 0x02, 0x50, 0x6E, 0x07, 0x20, 0x8F, 0xFF, 0xFA,
  0x02, 0x50, 0x6E, 0x07, 0x20, 0x2F, 0xFF, 0xFA, 0x02, 0x50, 0x6E, 0x07, 0x30, 0x9F, 0xFF, 0xF9,
  0x02, 0x50, 0x6E, 0x07, 0x30, 0x10, 0xEF, 0xFF, 0xF0, 0x25, 0x06, 0xE0, 0x74, 0x05, 0xFF, 0xFF,
  0x02, 0x50, 0x6E, 0x07, 0x50, 0x7F, 0xFF, 0xE0, 0x25, 0x06, 0xE0, 0x76, 0x07, 0xFF, 0xFD, 0x02,
  0x50, 0x6E, 0x07, 0x70, 0x40, 0xEF, 0xFF, 0xB0, 0x25, 0x06, 0xE0, 0x77, 0x20, 0x80, 0xEF, 0xFF,
  0x90, 0x25, 0x06, 0xE0, 0x77, 0x38, 0x11, 0x6C, 0xFF, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x68, 0x94,
  0x15, 0x8A, 0xCD, 0xDD, 0xDC, 0xB8, 0x5B, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02,
  0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50,
  0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E,
  0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07,
  0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77,
  0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75,
  0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A,
  0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0,
  0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25,
  0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06,
  0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0,
  0x77, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77,
  0x77, 0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77,
  0x50, 0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50,
  0xAE, 0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE,
  0x02, 0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02,
  0x50, 0x6E, 0x07, 0x77, 0x75, 0x0A, 0xE0, 0x25, 0x06, 0xE0, 0x77, 0x77, 0x50, 0xAE, 0x02, 0x50,
  0x6E, 0x07,
  // "·" (U+00B7)
  0x48, 0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x70, 0x7F, 0xA0, 0xE0, 0x44, 0x08, 0xFD, 0x04, 0x20, 0x3F,
  0xE8, 0x2E, 0x10, 0xAF, 0xF8, 0x17, 0x0E, 0xFF, 0x0C, 0x01, 0xFF, 0xA0, 0x2F, 0xFA, 0x02, 0xFF,
  0xA0, 0x1F, 0xFA, 0x10, 0xDF, 0xF8, 0x1B, 0x08, 0xFF, 0x81, 0x60, 0x1F, 0xE0, 0xD3, 0x05, 0xFD,
  0x03, 0x40, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x40,
  // "¸" (U+00B8)
  0x60, 0x4E, 0x07, 0x75, 0x0B, 0xE0, 0x27, 0x40, 0x2E, 0x0B, 0x75, 0x09, 0xE0, 0x97, 0x40, 0x10,
  0xEF, 0x90, 0x90, 0x27, 0x10, 0x7F, 0xB0, 0xE0, 0x67, 0x0D, 0xFD, 0x08, 0x58, 0x21, 0x8A, 0xDF,
  0xC0, 0x67, 0x10, 0x20, 0x8F, 0xA0, 0xE7, 0x30, 0x4F, 0xA0, 0x57, 0x30, 0xBF, 0x90, 0x97, 0x30,
  0x8F, 0x90, 0xB7, 0x30, 0xAF, 0x90, 0xC7, 0x20, 0x3F, 0xA8, 0x91, 0xB1, 0x95, 0x21, 0x01, 0x38,
  0xEF, 0xA0, 0x90, 0x1F, 0xFC, 0x05, 0x01, 0xFF, 0xB8, 0x1E, 0x11, 0xFF, 0xB8, 0x17, 0x01, 0xFF,
  0xA0, 0xB2, 0x01, 0xFF, 0x90, 0xA3, 0x01, 0xFE, 0x0C, 0x05, 0x58, 0x35, 0x8B, 0xDE, 0xA8, 0x4E,
  0xDC, 0xA7, 0x36,
  // "¹" (U+00B9)
  0x75, 0x08, 0xF7, 0x75, 0x02, 0x0C, 0xF9, 0x77, 0x40, 0x7F, 0xB7, 0x72, 0x02, 0x0B, 0xFC, 0x77,
  0x10, 0x60, 0xEF, 0xD7, 0x60, 0x10, 0xBF, 0xF7, 0x50, 0x50, 0xEF, 0xF9, 0x73, 0x01, 0x0A, 0xFF,
  0xB7, 0x20, 0x40, 0xDF, 0xFC, 0x72, 0x0A, 0xFF, 0xD7, 0x20, 0x10, 0xEF, 0x90, 0xE0, 0xAF, 0x97,
  0x30, 0x6F, 0x81, 0xB1, 0x6F, 0x97, 0x40, 0xBC, 0x0E, 0x06, 0x20, 0x6F, 0x97, 0x40, 0x2B, 0x0B,
  0x01, 0x30, 0x7F, 0x97, 0x58, 0x17, 0xE5, 0x50, 0x8F, 0x97, 0x60, 0x16, 0x08, 0xF9, 0x77, 0x60,
  0x8F, 0x97, 0x76, 0x09, 0xF9, 0x77, 0x60, 0x9F, 0x97, 0x76, 0x09, 0xF9, 0x77, 0x60, 0x9F, 0x97,
  0x76, 0x09, 0xF9, 0x77, 0x60, 0x9F, 0x97, 0x76, 0x09, 0xF9, 0x77, 0x60, 0x9F, 0x97, 0x76, 0x09,
  0xF9, 0x77, 0x60, 0x9F, 0x97, 0x76, 0x09, 0xF9, 0x77, 0x60, 0x9F, 0x97, 0x76, 0x09, 0xF9, 0x77,
  0x60, 0x9F, 0x97, 0x76, 0x09, 0xF9, 0x77, 0x18, 0x42, 0x34, 0x67, 0xCF, 0x98, 0x49, 0x76, 0x43,
  0x15, 0x81, 0x7D, 0xEF, 0xFF, 0x90, 0xD0, 0xA2, 0x09, 0xFF, 0xFC, 0x0D, 0x20, 0x9F, 0xFF, 0xC0,
  0xD2, 0x09, 0xFF, 0xFC, 0x0D, 0x20, 0x9F, 0xFF, 0xC0, 0xD2, 0x09, 0xFF, 0xFC, 0x0D,
  // "º" (U+00BA)
  0x71, 0x83, 0x16, 0x9C, 0xEA, 0x82, 0xEC, 0x84, 0x77, 0x10, 0x20, 0x9F, 0xC0, 0xD0, 0x67, 0x50,
  0x60, 0xEF, 0xF0, 0xC0, 0x27, 0x20, 0x9F, 0xFB, 0x0E, 0x04, 0x70, 0x7F, 0xFE, 0x03, 0x50, 0x3F,
  0xFF, 0x0D, 0x01, 0x40, 0xDF, 0xFF, 0x90, 0xA3, 0x05, 0xFA, 0x84, 0xA3, 0x01, 0x4B, 0xFA, 0x02,
  0x20, 0xCF, 0x90, 0x76, 0x0A, 0xF9, 0x81, 0x90, 0x2F, 0x90, 0xC7, 0x10, 0xEF, 0x91, 0x06, 0xF9,
  0x05, 0x71, 0x08, 0xF9, 0x03, 0x09, 0xF9, 0x01, 0x71, 0x04, 0xF9, 0x07, 0x0C, 0xF0, 0xD7, 0x3F,
  0x90, 0xA0, 0xDF, 0x0B, 0x73, 0x0E, 0xF0, 0xC0, 0xEF, 0x0A, 0x73, 0x0D, 0xF0, 0xDF, 0x90, 0x97,
  0x30, 0xCF, 0x0E, 0xF9, 0x09, 0x73, 0x0C, 0xF0, 0x0E, 0xF0, 0xA7, 0x30, 0xDF, 0x00, 0xDF, 0x0B,
  0x73, 0x0E, 0xF0, 0x0C, 0xF0, 0xD7, 0x3F, 0x90, 0xA0, 0x9F, 0x90, 0x17, 0x10, 0x4F, 0x90, 0x70,
  0x5F, 0x90, 0x57, 0x10, 0x8F, 0x90, 0x40, 0x1F, 0x90, 0xC7, 0x01, 0x0E, 0xF9, 0x81, 0x10, 0xBF,
  0x90, 0x76, 0x0A, 0xF9, 0x0A, 0x20, 0x4F, 0xA8, 0x4A, 0x30, 0x14, 0xBF, 0xA0, 0x33, 0x0C, 0xFF,
  0xF9, 0x0B, 0x40, 0x20, 0xEF, 0xFE, 0x0E, 0x02, 0x50, 0x5F, 0xFE, 0x05, 0x70, 0x6F, 0xFC, 0x06,
  0x72, 0x04, 0x0E, 0xFF, 0x0E, 0x04, 0x74, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x77, 0x18, 0x25,
  0x9C, 0xEA, 0x82, 0xEC, 0x95, 0x72,
  // "»" (U+00BB)
  0x71, 0x03, 0x06, 0x77, 0x30, 0x10, 0x77, 0x77, 0x02, 0x0A, 0xA0, 0x47, 0x71, 0x82, 0x8E, 0xF8,
  0x77, 0x40, 0x10, 0x8C, 0x0E, 0x01, 0x75, 0x06, 0x0E, 0xC0, 0x47, 0x72, 0x07, 0x0E, 0xE0, 0xC7,
  0x30, 0x50, 0xDE, 0x0E, 0x02, 0x76, 0x06, 0x0E, 0xFA, 0x09, 0x70, 0x40, 0xCF, 0xA0, 0xC7, 0x50,
  0x5F, 0xD0, 0x55, 0x01, 0x0E, 0xFC, 0x09, 0x75, 0x0A, 0xFC, 0x0E, 0x02, 0x50, 0x6F, 0xD0, 0x57,
  0x40, 0x10, 0xEF, 0xC0, 0xC6, 0x0B, 0xFC, 0x0E, 0x02, 0x74, 0x04, 0xFD, 0x09, 0x50, 0x10, 0xEF,
  0xC0, 0xC7, 0x50, 0x9F, 0xD0, 0x55, 0x05, 0xFD, 0x09, 0x75, 0x0D, 0xFC, 0x0E, 0x02, 0x50, 0x9F,
  0xD0, 0x57, 0x40, 0x3F, 0xD0, 0xC6, 0x0D, 0xFC, 0x0E, 0x02, 0x74, 0x08, 0xFD, 0x09, 0x50, 0x3F,
  0xD0, 0xD7, 0x50, 0xCF, 0xD0, 0x65, 0x08, 0xFD, 0x09, 0x74, 0x02, 0xFE, 0x02, 0x50, 0xCF, 0xD0,
  0x67, 0x40, 0x7F, 0xD0, 0xD5, 0x02, 0xFE, 0x03, 0x74, 0x0B, 0xFD, 0x0A, 0x50, 0x6F, 0xD0, 0xD7,
  0x40, 0x10, 0xEF, 0xD0, 0x65, 0x0B, 0xFD, 0x0A, 0x74, 0x05, 0xFE, 0x03, 0x40, 0x10, 0xEF, 0xD0,
  0x67, 0x40, 0xAF, 0xD0, 0xD0, 0x14, 0x05, 0xFE, 0x03, 0x73, 0x01, 0xFE, 0x05, 0x50, 0xBF, 0xD0,
  0x97, 0x30, 0x7F, 0xE0, 0x24, 0x02, 0xFE, 0x06, 0x72, 0x02, 0xFE, 0x06, 0x50, 0xCF, 0xD0, 0xA7,
  0x30, 0xCF, 0xD0, 0xA5, 0x08, 0xFD, 0x0D, 0x73, 0x08, 0xFD, 0x0D, 0x50, 0x3F, 0xE0, 0x27, 0x20,
  0x3F, 0xD0, 0xE0, 0x25, 0x0D, 0xFD, 0x06, 0x73, 0x0D, 0xFD, 0x06, 0x50, 0x9F, 0xD0, 0x97, 0x30,
  0x9F, 0xD0, 0x95, 0x04, 0xFD, 0x0D, 0x73, 0x04, 0xFD, 0x0C, 0x50, 0x10, 0xEF, 0xC0, 0xE0, 0x27,
  0x20, 0x10, 0xDF, 0xC0, 0xE0, 0x25, 0x0A, 0xFD, 0x05, 0x73, 0x0A, 0xFD, 0x05, 0x50, 0x5F, 0xD0,
  0x97, 0x30, 0x5F, 0xD0, 0x95, 0x01, 0x0E, 0xFC, 0x0C, 0x73, 0x01, 0x0E, 0xFC, 0x0C, 0x60, 0xBF,
  0xC0, 0xE0, 0x27, 0x30, 0xBF, 0xC0, 0xE0, 0x25, 0x07, 0xFD, 0x05, 0x73, 0x06, 0xFD, 0x05, 0x50,
  0x2F, 0xD0, 0x97, 0x30, 0x20, 0xEF, 0xC0, 0x86, 0x0C, 0xFC, 0x0C, 0x74, 0x03, 0x0C, 0xFB, 0x0C,
  0x60, 0x10, 0xAF, 0xB0, 0xE0, 0x27, 0x60, 0x50, 0xDF, 0x0E, 0x01, 0x71, 0x03, 0x0B, 0xF9, 0x04,
  0x77, 0x20, 0x60, 0xDD, 0x04, 0x74, 0x04, 0x0C, 0xD0, 0x87, 0x75, 0x07, 0x0E, 0xA0, 0x87, 0x70,
  0x50, 0xDA, 0x0B, 0x77, 0x71, 0x08, 0x0B, 0x77, 0x38, 0x16, 0xC1, 0x77,
  // "¼" (U+00BC)
  0x71, 0x03, 0x0B, 0xE8, 0x0C, 0x50, 0x01, 0x09, 0xF9, 0x80, 0xC4, 0x00, 0x60, 0xEF, 0xA8, 0x0C,
  0x20, 0x04, 0x0C, 0xFC, 0x80, 0xC0, 0x00, 0x10, 0xAF, 0xE7, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0x77,
  0x77, 0x70, 0xEF, 0xF9, 0x77, 0x77, 0x70, 0x6F, 0xF9, 0x80, 0xC0, 0x00, 0xCE, 0x06, 0x0E, 0xE7,
  0x77, 0x38, 0x05, 0x40, 0x32, 0x03, 0xC0, 0xD0, 0x31, 0xF7, 0x77, 0x20, 0x8F, 0xA0, 0x53, 0x0A,
  0xA0, 0x83, 0xF7, 0x77, 0x10, 0x4F, 0xA0, 0x94, 0x81, 0x2A, 0x23, 0x01, 0xF7, 0x77, 0x01, 0x0E,
  0xF9, 0x0C, 0x74, 0x02, 0xF7, 0x77, 0x0C, 0xF9, 0x0E, 0x02, 0x74, 0x02, 0xF7, 0x76, 0x08, 0xFA,
  0x05, 0x75, 0x02, 0xF7, 0x75, 0x04, 0xFA, 0x09, 0x76, 0x02, 0xF7, 0x74, 0x01, 0x0E, 0xF9, 0x0C,
  0x77, 0x02, 0xF7, 0x74, 0x0C, 0xF9, 0x0E, 0x02, 0x77, 0x02, 0xF7, 0x73, 0x08, 0xFA, 0x05, 0x77,
  0x10, 0x2F, 0x77, 0x20, 0x4F, 0xA0, 0x97, 0x72, 0x02, 0xF7, 0x71, 0x01, 0x0E, 0xF9, 0x0C, 0x77,
  0x30, 0x2F, 0x77, 0x10, 0xCF, 0x90, 0xE0, 0x27, 0x73, 0x02, 0xF7, 0x70, 0x8F, 0xA0, 0x57, 0x74,
  0x02, 0xF7, 0x60, 0x4F, 0xA0, 0x97, 0x75, 0x03, 0xF0, 0x17, 0x40, 0x10, 0xEF, 0x90, 0xC7, 0x78,
  0x48, 0x9A, 0xBD, 0xEF, 0xB8, 0x3D, 0xCA, 0x96, 0x50, 0xCF, 0x90, 0xE0, 0x27, 0x60, 0x1F, 0xFE,
  0x0B, 0x40, 0x8F, 0xA0, 0x57, 0x70, 0x1F, 0xFE, 0x0B, 0x30, 0x4F, 0xA0, 0x97, 0x71, 0x01, 0xFF,
  0xE0, 0xB2, 0x01, 0x0E, 0xF9, 0x0C, 0x77, 0x20, 0x1F, 0xFE, 0x0B, 0x20, 0xCF, 0x90, 0xE0, 0x27,
  0x72, 0x01, 0xFF, 0xE8, 0x1B, 0x08, 0xFA, 0x05, 0x80, 0xC3, 0x00, 0x4F, 0xA0, 0x98, 0x0C, 0x30,
  0x01, 0x0E, 0xF9, 0x0C, 0x80, 0xC4, 0x00, 0xCF, 0x90, 0xE0, 0x28, 0x0C, 0x30, 0x08, 0xFA, 0x05,
  0x80, 0xC3, 0x00, 0x4F, 0xA0, 0x97, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0x20, 0xEF, 0x90, 0xD7, 0x07,
  0xF9, 0x05, 0x77, 0x72, 0x0C, 0xF9, 0x0E, 0x02, 0x60, 0x2F, 0xA0, 0x57, 0x77, 0x10, 0x8F, 0xA0,
  0x67, 0x0B, 0xFA, 0x05, 0x77, 0x70, 0x4F, 0xA0, 0x97, 0x06, 0xFB, 0x05, 0x77, 0x60, 0x20, 0xEF,
  0x90, 0xD7, 0x01, 0x0E, 0xFB, 0x05, 0x77, 0x60, 0xCF, 0xA0, 0x27, 0x0B, 0xFC, 0x05, 0x77, 0x50,
  0x8F, 0xA0, 0x67, 0x05, 0xFD, 0x05, 0x77, 0x40, 0x4F, 0xA0, 0xA7, 0x01, 0x0E, 0xC0, 0xE0, 0xCE,
  0x05, 0x77, 0x30, 0x20, 0xEF, 0x90, 0xD7, 0x10, 0xAD, 0x08, 0x0C, 0xE0, 0x57, 0x73, 0x0C, 0xFA,
  0x02, 0x70, 0x4D, 0x81, 0xE1, 0xDE, 0x05, 0x77, 0x20, 0x8F, 0xA0, 0x67, 0x01, 0x0D, 0xD8, 0x15,
  0x0E, 0xE0, 0x57, 0x71, 0x04, 0xFA, 0x0A, 0x71, 0x09, 0xD0, 0xB2, 0x0E, 0xE0, 0x57, 0x70, 0x20,
  0xEF, 0x90, 0xD7, 0x10, 0x4D, 0x0E, 0x01, 0x20, 0xEE, 0x05, 0x77, 0x0C, 0xFA, 0x03, 0x71, 0x0D,
  0xD0, 0x63, 0x0E, 0xE0, 0x57, 0x60, 0x8F, 0xA0, 0x67, 0x10, 0x8D, 0x0B, 0x40, 0xEE, 0x05, 0x75,
  0x04, 0xFA, 0x0A, 0x71, 0x03, 0xE0, 0x24, 0x0E, 0xE0, 0x57, 0x40, 0x20, 0xEF, 0x90, 0xD7, 0x20,
  0xCD, 0x07, 0x50, 0xEE, 0x05, 0x74, 0x0C, 0xFA, 0x03, 0x71, 0x07, 0xD0, 0xC6, 0x0E, 0xE0, 0x57,
  0x30, 0x8F, 0xA0, 0x67, 0x2F, 0xFF, 0xC5, 0x04, 0xFA, 0x0A, 0x72, 0x01, 0xFF, 0xFC, 0x40, 0x20,
  0xEF, 0x90, 0xD7, 0x30, 0x1F, 0xFF, 0xC4, 0x0C, 0xFA, 0x03, 0x73, 0x01, 0xFF, 0xFC, 0x30, 0x8F,
  0xA0, 0x67, 0x40, 0x1F, 0xFF, 0xC7, 0x77, 0x40, 0x1F, 0xFF, 0xC8, 0x0C, 0x30, 0x0E, 0xE0, 0x58,
  0x0C, 0x70, 0x0E, 0xE0, 0x58, 0x0C, 0x70, 0x0E, 0xE0, 0x58, 0x0C, 0x70, 0x0E, 0xE0, 0x58, 0x0C,
  0x70, 0x0E, 0xE0, 0x58, 0x0C, 0x70, 0x80, 0x37, 0x02, 0x40,
  // "½" (U+00BD)
  0x71, 0x03, 0x0B, 0xE8, 0x0C, 0x60, 0x01, 0x09, 0xF9, 0x80, 0xC5, 0x00, 0x60, 0xEF, 0xA8, 0x0C,
  0x30, 0x04, 0x0C, 0xFC, 0x80, 0xC1, 0x00, 0x10, 0xAF, 0xE8, 0x0C, 0x00, 0x07, 0x0E, 0xFF, 0x80,
  0xC0, 0x00, 0xEF, 0xF9, 0x80, 0xC0, 0x00, 0x6F, 0xF9, 0x80, 0xC1, 0x00, 0xCE, 0x06, 0x0E, 0xE7,
  0x77, 0x38, 0x05, 0x40, 0x33, 0x03, 0xC0, 0xD0, 0x31, 0xF7, 0x77, 0x20, 0x9F, 0xA0, 0x44, 0x0A,
  0xA0, 0x83, 0xF7, 0x77, 0x10, 0x5F, 0xA0, 0x85, 0x81, 0x2A, 0x23, 0x01, 0xF7, 0x77, 0x02, 0x0E,
  0xF9, 0x0B, 0x75, 0x02, 0xF7, 0x77, 0x0C, 0xF9, 0x0E, 0x01, 0x75, 0x02, 0xF7, 0x76, 0x09, 0xFA,
  0x04, 0x76, 0x02, 0xF7, 0x75, 0x06, 0xFA, 0x07, 0x77, 0x02, 0xF7, 0x74, 0x03, 0xFA, 0x0B, 0x77,
  0x10, 0x2F, 0x77, 0x30, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x71, 0x02, 0xF7, 0x73, 0x0A, 0xFA, 0x03,
  0x77, 0x20, 0x2F, 0x77, 0x20, 0x7F, 0xA0, 0x67, 0x73, 0x02, 0xF7, 0x71, 0x03, 0xFA, 0x0A, 0x77,
  0x40, 0x2F, 0x77, 0x01, 0x0E, 0xF9, 0x0D, 0x77, 0x50, 0x2F, 0x77, 0x0B, 0xFA, 0x02, 0x77, 0x50,
  0x2F, 0x76, 0x08, 0xFA, 0x06, 0x77, 0x60, 0x3F, 0x01, 0x74, 0x04, 0xFA, 0x09, 0x77, 0x18, 0x48,
  0x9A, 0xBD, 0xEF, 0xB8, 0x3D, 0xCA, 0x96, 0x40, 0x20, 0xEF, 0x90, 0xC7, 0x71, 0x01, 0xFF, 0xE0,
  0xB4, 0x0C, 0xF9, 0x0E, 0x02, 0x77, 0x10, 0x1F, 0xFE, 0x0B, 0x30, 0x9F, 0xA0, 0x57, 0x72, 0x01,
  0xFF, 0xE0, 0xB2, 0x05, 0xFA, 0x08, 0x77, 0x30, 0x1F, 0xFE, 0x82, 0xB0, 0x2E, 0xF9, 0x0C, 0x77,
  0x40, 0x1F, 0xFE, 0x81, 0xB0, 0xDF, 0x90, 0xE0, 0x18, 0x0C, 0x40, 0x0A, 0xFA, 0x04, 0x80, 0xC4,
  0x00, 0x6F, 0xA0, 0x88, 0x0C, 0x40, 0x03, 0xFA, 0x0B, 0x80, 0xC4, 0x00, 0x10, 0xDF, 0x90, 0xD0,
  0x13, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDA, 0x71, 0x77, 0x75, 0x0B, 0xFA, 0x03, 0x20, 0x60, 0xDF,
  0xC0, 0x97, 0x77, 0x30, 0x7F, 0xA8, 0x27, 0x03, 0xCF, 0xF0, 0xD0, 0x17, 0x77, 0x04, 0xFA, 0x81,
  0xA0, 0x6F, 0xFB, 0x0C, 0x77, 0x60, 0x10, 0xEF, 0x98, 0x2D, 0x11, 0xEF, 0xFC, 0x06, 0x77, 0x50,
  0xBF, 0xA0, 0x32, 0x04, 0xFF, 0xC0, 0xD7, 0x74, 0x08, 0xFA, 0x06, 0x40, 0x7C, 0x84, 0xB4, 0x10,
  0x29, 0xF9, 0x02, 0x77, 0x20, 0x4F, 0xA0, 0xA6, 0x82, 0xAF, 0xE5, 0x60, 0xAF, 0x04, 0x77, 0x10,
  0x20, 0xEF, 0x90, 0xD7, 0x10, 0xB0, 0x27, 0x05, 0xF0, 0x57, 0x71, 0x0C, 0xF9, 0x0E, 0x02, 0x77,
  0x30, 0x4F, 0x04, 0x77, 0x09, 0xFA, 0x05, 0x77, 0x40, 0x7F, 0x03, 0x76, 0x05, 0xFA, 0x09, 0x77,
  0x50, 0xDE, 0x0E, 0x76, 0x02, 0x0E, 0xF9, 0x0C, 0x77, 0x50, 0x8F, 0x09, 0x76, 0x0D, 0xF9, 0x0E,
  0x02, 0x77, 0x40, 0x5F, 0x90, 0x27, 0x50, 0xAF, 0xA0, 0x47, 0x74, 0x04, 0xF9, 0x07, 0x75, 0x06,
  0xFA, 0x08, 0x77, 0x40, 0x4F, 0x90, 0xB7, 0x50, 0x3F, 0xA0, 0xB7, 0x74, 0x04, 0xF9, 0x0D, 0x01,
  0x74, 0x01, 0x0D, 0xF9, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90, 0xD0, 0x17, 0x50, 0xBF, 0xA0, 0x37,
  0x73, 0x03, 0x0E, 0xF0, 0xD0, 0x27, 0x50, 0x7F, 0xA0, 0x77, 0x73, 0x03, 0x0E, 0xF0, 0xD0, 0x27,
  0x50, 0x4F, 0xA0, 0xB7, 0x73, 0x03, 0x0E, 0xF0, 0xD0, 0x27, 0x50, 0x10, 0xEF, 0x90, 0xD0, 0x17,
  0x72, 0x03, 0x0E, 0xF0, 0xD0, 0x17, 0x60, 0xCF, 0xA0, 0x37, 0x72, 0x02, 0x0E, 0xF0, 0xB0, 0x17,
  0x60, 0x8F, 0xA0, 0x67, 0x72, 0x02, 0x0E, 0xF0, 0x98, 0x0C, 0x60, 0x0E, 0xFF, 0xE0, 0x87, 0x77,
  0x72, 0xFF, 0xF0, 0x87, 0x77, 0x72, 0xFF, 0xF0, 0x87, 0x77, 0x72, 0xFF, 0xF0, 0x87, 0x77, 0x72,
  0xFF, 0xF0, 0x87, 0x77, 0x72, 0xFF, 0xF0, 0x87, 0x77, 0x72, 0xFF, 0xF0, 0x80,
  // "¾" (U+00BE)
  0x58, 0x91, 0x38, 0xBD, 0xEF, 0xED, 0xB7, 0x27, 0x77, 0x77, 0x81, 0x17, 0xEF, 0xC0, 0xB0, 0x37,
  0x77, 0x74, 0x06, 0x0E, 0xFF, 0x90, 0x57, 0x77, 0x72, 0x0B, 0xFF, 0xC0, 0x47, 0x77, 0x71, 0x09,
  0xFF, 0xC0, 0xD7, 0x77, 0x72, 0x0D, 0xFF, 0xC0, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xB8, 0x5A, 0x51,
  0x01, 0x5D, 0xF0, 0x77, 0x77, 0x72, 0x82, 0x5F, 0xA2, 0x60, 0x2F, 0x08, 0x77, 0x77, 0x30, 0x37,
  0x20, 0xDE, 0x07, 0x80, 0xC5, 0x00, 0xDE, 0x05, 0x77, 0x20, 0x38, 0x05, 0xD0, 0x87, 0x60, 0x4F,
  0x01, 0x77, 0x10, 0x10, 0xDF, 0x90, 0xD7, 0x48, 0x11, 0x38, 0xF0, 0x97, 0x72, 0x0B, 0xFA, 0x03,
  0x7F, 0xE0, 0xC7, 0x72, 0x07, 0xFA, 0x06, 0x71, 0xFD, 0x0A, 0x01, 0x77, 0x10, 0x3F, 0xA0, 0xA7,
  0x2F, 0xC0, 0x47, 0x72, 0x01, 0x0E, 0xF9, 0x0D, 0x73, 0xFD, 0x0A, 0x02, 0x77, 0x0B, 0xFA, 0x02,
  0x73, 0xFE, 0x0E, 0x04, 0x75, 0x08, 0xFA, 0x06, 0x74, 0xFF, 0x90, 0x37, 0x30, 0x4F, 0xA0, 0x97,
  0x73, 0x81, 0x25, 0xBF, 0x0B, 0x72, 0x01, 0x0E, 0xF9, 0x0D, 0x77, 0x70, 0xAF, 0x01, 0x71, 0x0B,
  0xF9, 0x0E, 0x02, 0x77, 0x70, 0x3F, 0x04, 0x70, 0x8F, 0xA0, 0x57, 0x77, 0x10, 0x1F, 0x05, 0x60,
  0x4F, 0xA0, 0x97, 0x30, 0x60, 0x27, 0x40, 0x4F, 0x05, 0x50, 0x10, 0xEF, 0x90, 0xC7, 0x48, 0x2A,
  0xF8, 0x17, 0x20, 0xBF, 0x03, 0x50, 0xCF, 0x90, 0xE0, 0x27, 0x40, 0xAB, 0x82, 0xB7, 0x31, 0x28,
  0x11, 0x5C, 0xF0, 0xE5, 0x08, 0xFA, 0x05, 0x75, 0x0A, 0xFF, 0xD0, 0x94, 0x05, 0xFA, 0x09, 0x76,
  0x0A, 0xFF, 0xC0, 0xE0, 0x13, 0x02, 0x0E, 0xF9, 0x0C, 0x77, 0x0A, 0xFF, 0xC0, 0x54, 0x0C, 0xF9,
  0x0E, 0x02, 0x77, 0x0A, 0xFF, 0xA0, 0xE0, 0x44, 0x09, 0xFA, 0x05, 0x77, 0x18, 0x11, 0x8E, 0xFD,
  0x81, 0xE9, 0x14, 0x05, 0xFA, 0x08, 0x77, 0x58, 0x92, 0x48, 0xAC, 0xEE, 0xFE, 0xDC, 0x95, 0x60,
  0x20, 0xEF, 0x90, 0xC8, 0x0C, 0x20, 0x0C, 0xF9, 0x0E, 0x02, 0x80, 0xC1, 0x00, 0x9F, 0xA0, 0x48,
  0x0C, 0x10, 0x06, 0xFA, 0x08, 0x80, 0xC1, 0x00, 0x20, 0xEF, 0x90, 0xC7, 0x06, 0x80, 0x39, 0x03,
  0x77, 0x71, 0x0D, 0xF9, 0x0E, 0x01, 0x60, 0x3F, 0x90, 0x57, 0x77, 0x0A, 0xFA, 0x04, 0x70, 0xDF,
  0x90, 0x57, 0x76, 0x06, 0xFA, 0x08, 0x70, 0x8F, 0xA0, 0x57, 0x75, 0x03, 0xFA, 0x0B, 0x70, 0x3F,
  0xB0, 0x57, 0x74, 0x01, 0x0D, 0xF9, 0x0E, 0x01, 0x70, 0xCF, 0xB0, 0x57, 0x74, 0x0A, 0xFA, 0x04,
  0x70, 0x8F, 0xC0, 0x57, 0x73, 0x07, 0xFA, 0x07, 0x70, 0x3F, 0xD0, 0x57, 0x72, 0x03, 0xFA, 0x0B,
  0x71, 0x0C, 0xD0, 0xDE, 0x05, 0x77, 0x10, 0x10, 0xDF, 0x90, 0xE0, 0x17, 0x08, 0xD0, 0xA0, 0xCE,
  0x05, 0x77, 0x10, 0xBF, 0xA0, 0x47, 0x03, 0xE0, 0x20, 0xDE, 0x05, 0x77, 0x07, 0xFA, 0x07, 0x71,
  0x0C, 0xD8, 0x17, 0x0E, 0xE0, 0x57, 0x60, 0x3F, 0xA0, 0xB7, 0x10, 0x7D, 0x0C, 0x20, 0xEE, 0x05,
  0x75, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x70, 0x3E, 0x03, 0x20, 0xEE, 0x05, 0x75, 0x0B, 0xFA, 0x03,
  0x71, 0x0C, 0xD0, 0x73, 0x0E, 0xE0, 0x57, 0x40, 0x7F, 0xA0, 0x77, 0x10, 0x7D, 0x0C, 0x40, 0xEE,
  0x05, 0x73, 0x04, 0xFA, 0x0B, 0x71, 0x02, 0xE0, 0x24, 0x0E, 0xE0, 0x57, 0x20, 0x10, 0xEF, 0x90,
  0xD0, 0x17, 0x10, 0xCD, 0x07, 0x50, 0xEE, 0x05, 0x72, 0x0B, 0xFA, 0x03, 0x71, 0x07, 0xD0, 0xC6,
  0x0E, 0xE0, 0x57, 0x10, 0x8F, 0xA0, 0x77, 0x2F, 0xFF, 0xC3, 0x04, 0xFA, 0x0A, 0x72, 0x01, 0xFF,
  0xFC, 0x20, 0x10, 0xEF, 0x90, 0xD0, 0x17, 0x20, 0x1F, 0xFF, 0xC2, 0x0C, 0xFA, 0x03, 0x73, 0x01,
  0xFF, 0xFC, 0x10, 0x8F, 0xA0, 0x67, 0x40, 0x1F, 0xFF, 0xC7, 0x77, 0x20, 0x1F, 0xFF, 0xC8, 0x0C,
  0x10, 0x0E, 0xE0, 0x58, 0x0C, 0x50, 0x0E, 0xE0, 0x58, 0x0C, 0x50, 0x0E, 0xE0, 0x58, 0x0C, 0x50,
  0x0E, 0xE0, 0x58, 0x0C, 0x50, 0x0E, 0xE0, 0x58, 0x0C, 0x50, 0x80, 0x37, 0x02, 0x40,
  // "¿" (U+00BF)
  0x77, 0x48, 0x72, 0x8C, 0xEF, 0xEC, 0x82, 0x77, 0x77, 0x20, 0x9F, 0xA0, 0x97, 0x77, 0x70, 0xBF,
  0xC0, 0xB7, 0x77, 0x50, 0x7F, 0xE0, 0x87, 0x77, 0x30, 0x10, 0xEF, 0xE0, 0xE7, 0x77, 0x30, 0x5F,
  0xF9, 0x04, 0x77, 0x72, 0x08, 0xFF, 0x90, 0x77, 0x77, 0x20, 0x9F, 0xF9, 0x09, 0x77, 0x72, 0x09,
  0xFF, 0x90, 0x97, 0x77, 0x20, 0x8F, 0xF9, 0x08, 0x77, 0x72, 0x05, 0xFF, 0x90, 0x57, 0x77, 0x20,
  0x1F, 0xF9, 0x01, 0x77, 0x73, 0x09, 0xFE, 0x09, 0x77, 0x75, 0x0C, 0xFC, 0x0D, 0x01, 0x77, 0x75,
  0x01, 0x0B, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x18, 0x73, 0x9C, 0xEF, 0xEC, 0x94, 0x80, 0xC9, 0x10,
  0x02, 0x80, 0x79, 0x03, 0x77, 0x76, 0x03, 0xFC, 0x05, 0x77, 0x76, 0x03, 0xFC, 0x05, 0x77, 0x76,
  0x04, 0xFC, 0x05, 0x77, 0x76, 0x05, 0xFC, 0x05, 0x77, 0x76, 0x08, 0xFC, 0x04, 0x77, 0x76, 0x0E,
  0xFC, 0x02, 0x77, 0x75, 0x09, 0xFC, 0x0E, 0x77, 0x75, 0x07, 0xFD, 0x0A, 0x77, 0x74, 0x09, 0xFE,
  0x05, 0x77, 0x72, 0x01, 0x0B, 0xFE, 0x0D, 0x77, 0x72, 0x03, 0x0D, 0xFF, 0x04, 0x77, 0x71, 0x07,
  0xFF, 0x90, 0x87, 0x77, 0x10, 0xAF, 0xF9, 0x0A, 0x77, 0x70, 0x20, 0xDF, 0xF9, 0x0B, 0x77, 0x70,
  0x30, 0xEF, 0xF9, 0x09, 0x77, 0x70, 0x40, 0xEF, 0xF9, 0x07, 0x77, 0x70, 0x30, 0xEF, 0xF0, 0xD0,
  0x37, 0x77, 0x01, 0x0E, 0xFF, 0x0B, 0x01, 0x77, 0x71, 0x0A, 0xFF, 0x08, 0x77, 0x72, 0x04, 0xFF,
  0x06, 0x77, 0x73, 0x0A, 0xFE, 0x06, 0x77, 0x73, 0x01, 0xFE, 0x08, 0x77, 0x74, 0x04, 0xFD, 0x0D,
  0x77, 0x75, 0x07, 0xFD, 0x06, 0x77, 0x75, 0x0A, 0xFD, 0x02, 0x77, 0x75, 0x0B, 0xFD, 0x77, 0x76,
  0x0C, 0xFC, 0x0E, 0x77, 0x76, 0x0C, 0xFD, 0x77, 0x76, 0x0B, 0xFD, 0x02, 0x77, 0x58, 0x12, 0xA3,
  0x40, 0x9F, 0xD0, 0x97, 0x73, 0x04, 0x0B, 0xA0, 0xB4, 0x07, 0xFE, 0x06, 0x76, 0x81, 0x17, 0xDD,
  0x03, 0x30, 0x3F, 0xF0, 0xA0, 0x27, 0x18, 0x12, 0x7B, 0xF9, 0x0B, 0x40, 0xEF, 0xF9, 0x86, 0xDA,
  0x98, 0x8A, 0xCE, 0xFD, 0x03, 0x30, 0x8F, 0xFF, 0xFF, 0x0B, 0x30, 0x10, 0xEF, 0xFF, 0xFF, 0x03,
  0x30, 0x7F, 0xFF, 0xFF, 0x0B, 0x40, 0xBF, 0xFF, 0xFF, 0x03, 0x40, 0xCF, 0xFF, 0xFE, 0x08, 0x50,
  0xBF, 0xFF, 0xFB, 0x0B, 0x04, 0x70, 0x7F, 0xFF, 0xF0, 0xA0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xA8,
  0x1C, 0x71, 0x77, 0x81, 0x28, 0xDF, 0xFA, 0x82, 0xEB, 0x72, 0x77, 0x68, 0x52, 0x59, 0xBD, 0xEE,
  0xA8, 0x5E, 0xDC, 0xA8, 0x53, 0x75,
  // "À" (U+00C0)
  0x74, 0x05, 0x80, 0x91, 0x70, 0x48, 0x0C, 0x10, 0x09, 0xFE, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0xBF,
  0xE0, 0x98, 0x0C, 0x20, 0x0C, 0xFE, 0x03, 0x80, 0xC1, 0x00, 0x10, 0xCF, 0xD0, 0xD8, 0x0C, 0x30,
  0x0C, 0xFD, 0x08, 0x80, 0xC3, 0x00, 0xBF, 0xD0, 0x38, 0x0C, 0x30, 0x0B, 0xFC, 0x0D, 0x80, 0xC4,
  0x00, 0xAF, 0xC0, 0x88, 0x0C, 0x40, 0x09, 0xFC, 0x03, 0x80, 0xC4, 0x00, 0x8F, 0xB0, 0xD8, 0x0C,
  0x50, 0x06, 0xFB, 0x0A, 0x80, 0xC5, 0x00, 0x5F, 0xB0, 0x58, 0x0C, 0x50, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x80, 0xC5, 0x00, 0x10, 0xCF, 0x90, 0x58, 0x0D, 0xA6, 0x00, 0x8F, 0xFA, 0x06, 0x77, 0x77,
  0x60, 0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0xFB, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xFC, 0x03,
  0x77, 0x77, 0x40, 0x9F, 0xFC, 0x08, 0x77, 0x77, 0x40, 0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0x2F,
  0xFE, 0x01, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x05, 0x77, 0x77, 0x20, 0xBF, 0xFE, 0x0A, 0x77, 0x77,
  0x2F, 0xFF, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0x0D, 0xFB, 0x03, 0x77, 0x77, 0x08, 0xFB, 0x00,
  0xAF, 0xB0, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0x06, 0xFB, 0x0B, 0x77, 0x76, 0x01, 0xFC, 0x00, 0x3F,
  0xC7, 0x77, 0x60, 0x6F, 0xC2, 0x0E, 0xFB, 0x04, 0x77, 0x75, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0,
  0x97, 0x77, 0x50, 0xEF, 0xB0, 0x82, 0x07, 0xFB, 0x0D, 0x77, 0x74, 0x03, 0xFC, 0x04, 0x20, 0x3F,
  0xC0, 0x27, 0x77, 0x30, 0x7F, 0xC4, 0xFC, 0x06, 0x77, 0x73, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0,
  0xA7, 0x77, 0x20, 0x1F, 0xC0, 0x84, 0x08, 0xFB, 0x0E, 0x77, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x4F,
  0xC0, 0x47, 0x77, 0x10, 0x9F, 0xC5, 0x01, 0xFC, 0x08, 0x77, 0x71, 0x0D, 0xFB, 0x0C, 0x60, 0xCF,
  0xB0, 0xC7, 0x77, 0x02, 0xFC, 0x08, 0x60, 0x8F, 0xC0, 0x17, 0x76, 0x06, 0xFC, 0x04, 0x60, 0x5F,
  0xC0, 0x57, 0x76, 0x0B, 0xFC, 0x70, 0x1F, 0xC0, 0xA7, 0x76, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB,
  0x0E, 0x77, 0x50, 0x4F, 0xC0, 0x87, 0x10, 0x9F, 0xC0, 0x37, 0x74, 0x08, 0xFC, 0x04, 0x71, 0x05,
  0xFC, 0x07, 0x77, 0x40, 0xCF, 0xC7, 0x20, 0x1F, 0xC0, 0xB7, 0x73, 0x01, 0xFC, 0x0B, 0x73, 0x0D,
  0xFC, 0x77, 0x30, 0x5F, 0xC0, 0x77, 0x30, 0x9F, 0xC0, 0x57, 0x72, 0x0A, 0xFC, 0x03, 0x73, 0x06,
  0xFC, 0x09, 0x77, 0x20, 0xEF, 0xC7, 0x40, 0x2F, 0xC0, 0xD7, 0x71, 0x03, 0xFC, 0x0B, 0x75, 0x0E,
  0xFC, 0x02, 0x77, 0x07, 0xFC, 0x07, 0x75, 0x0A, 0xFC, 0x06, 0x77, 0x0B, 0xFC, 0x0A, 0x80, 0x90,
  0x80, 0xBF, 0xC0, 0xB7, 0x78, 0x0C, 0x1F, 0x0E, 0x76, 0x04, 0x80, 0xC2, 0xF0, 0x47, 0x50, 0x98,
  0x0C, 0x2F, 0x08, 0x75, 0x0D, 0x80, 0xC2, 0xF0, 0xC7, 0x40, 0x28, 0x0C, 0x4F, 0x01, 0x73, 0x06,
  0x80, 0xC4, 0xF0, 0x57, 0x30, 0xA8, 0x0C, 0x4F, 0x0A, 0x73, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x20,
  0x38, 0x0C, 0x6F, 0x03, 0x71, 0x08, 0x80, 0xC6, 0xF0, 0x77, 0x10, 0xCF, 0xC0, 0x67, 0x74, 0x0A,
  0xFC, 0x0C, 0x70, 0x1F, 0xD0, 0x27, 0x74, 0x07, 0xFD, 0x01, 0x60, 0x5F, 0xC0, 0xE7, 0x75, 0x03,
  0xFD, 0x05, 0x60, 0x9F, 0xC0, 0xA7, 0x76, 0x0E, 0xFC, 0x09, 0x60, 0xEF, 0xC0, 0x67, 0x76, 0x0B,
  0xFC, 0x0D, 0x50, 0x2F, 0xD0, 0x27, 0x76, 0x07, 0xFD, 0x02, 0x40, 0x7F, 0xC0, 0xE7, 0x77, 0x03,
  0xFD, 0x06, 0x40, 0xBF, 0xC0, 0xA7, 0x77, 0x1F, 0xD0, 0xB4, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD,
  0x30, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x42, 0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD,
  0x08, 0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD8, 0x1D, 0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD,
  0x01, 0x06, 0xFD, 0x03, 0x77, 0x73, 0x08, 0xFD, 0x06, 0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD,
  0x0A, 0x0E, 0xFC, 0x0B, 0x77, 0x74, 0x01, 0xFD, 0x0E,
  // "Á" (U+00C1)
  0x77, 0x77, 0x01, 0x80, 0x92, 0x70, 0x18, 0x0C, 0x00, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x70,
  0x3F, 0xF0, 0x48, 0x0C, 0x00, 0x0C, 0xFE, 0x05, 0x80, 0xC0, 0x00, 0x6F, 0xE0, 0x58, 0x0C, 0x00,
  0x01, 0x0E, 0xFD, 0x05, 0x80, 0xC1, 0x00, 0xBF, 0xC0, 0xE0, 0x48, 0x0C, 0x10, 0x06, 0xFC, 0x0E,
  0x03, 0x80, 0xC1, 0x00, 0x20, 0xEF, 0xB0, 0xE0, 0x28, 0x0C, 0x20, 0x0C, 0xFB, 0x0D, 0x02, 0x80,
  0xC2, 0x00, 0x7F, 0xB0, 0xD0, 0x18, 0x0C, 0x20, 0x03, 0xFB, 0x0B, 0x01, 0x80, 0xC2, 0x00, 0x10,
  0xDF, 0xA0, 0xA8, 0x0C, 0x40, 0x0A, 0xFA, 0x08, 0x80, 0xC5, 0x00, 0xEF, 0x0E, 0x05, 0x80, 0xDB,
  0x30, 0x08, 0xFF, 0xA0, 0x67, 0x77, 0x76, 0x0C, 0xFF, 0xA0, 0xA7, 0x77, 0x75, 0x01, 0xFF, 0xB0,
  0xE7, 0x77, 0x75, 0x05, 0xFF, 0xC0, 0x37, 0x77, 0x74, 0x09, 0xFF, 0xC0, 0x87, 0x77, 0x74, 0x0D,
  0xFF, 0xC0, 0xC7, 0x77, 0x73, 0x02, 0xFF, 0xE0, 0x17, 0x77, 0x72, 0x07, 0xFF, 0xE0, 0x57, 0x77,
  0x72, 0x0B, 0xFF, 0xE0, 0xA7, 0x77, 0x72, 0xFF, 0xF0, 0xE7, 0x77, 0x71, 0x04, 0xFB, 0x00, 0xDF,
  0xB0, 0x37, 0x77, 0x70, 0x8F, 0xB0, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x0D, 0xFB, 0x00, 0x6F, 0xB0,
  0xB7, 0x77, 0x60, 0x1F, 0xC0, 0x03, 0xFC, 0x77, 0x76, 0x06, 0xFC, 0x20, 0xEF, 0xB0, 0x47, 0x77,
  0x50, 0xAF, 0xB0, 0xB2, 0x0B, 0xFB, 0x09, 0x77, 0x75, 0x0E, 0xFB, 0x08, 0x20, 0x7F, 0xB0, 0xD7,
  0x77, 0x40, 0x3F, 0xC0, 0x42, 0x03, 0xFC, 0x02, 0x77, 0x73, 0x07, 0xFC, 0x4F, 0xC0, 0x67, 0x77,
  0x30, 0xCF, 0xB0, 0xC4, 0x0B, 0xFB, 0x0A, 0x77, 0x72, 0x01, 0xFC, 0x08, 0x40, 0x8F, 0xB0, 0xE7,
  0x77, 0x20, 0x5F, 0xC0, 0x44, 0x04, 0xFC, 0x04, 0x77, 0x71, 0x09, 0xFC, 0x50, 0x1F, 0xC0, 0x87,
  0x77, 0x10, 0xDF, 0xB0, 0xC6, 0x0C, 0xFB, 0x0C, 0x77, 0x70, 0x2F, 0xC0, 0x86, 0x08, 0xFC, 0x01,
  0x77, 0x60, 0x6F, 0xC0, 0x46, 0x05, 0xFC, 0x05, 0x77, 0x60, 0xBF, 0xC7, 0x01, 0xFC, 0x0A, 0x77,
  0x60, 0xEF, 0xB0, 0xC7, 0x10, 0xDF, 0xB0, 0xE7, 0x75, 0x04, 0xFC, 0x08, 0x71, 0x09, 0xFC, 0x03,
  0x77, 0x40, 0x8F, 0xC0, 0x47, 0x10, 0x5F, 0xC0, 0x77, 0x74, 0x0C, 0xFC, 0x72, 0x01, 0xFC, 0x0B,
  0x77, 0x30, 0x1F, 0xC0, 0xB7, 0x30, 0xDF, 0xC7, 0x73, 0x05, 0xFC, 0x07, 0x73, 0x09, 0xFC, 0x05,
  0x77, 0x20, 0xAF, 0xC0, 0x37, 0x30, 0x6F, 0xC0, 0x97, 0x72, 0x0E, 0xFC, 0x74, 0x02, 0xFC, 0x0D,
  0x77, 0x10, 0x3F, 0xC0, 0xB7, 0x50, 0xEF, 0xC0, 0x27, 0x70, 0x7F, 0xC0, 0x77, 0x50, 0xAF, 0xC0,
  0x67, 0x70, 0xBF, 0xC0, 0xA8, 0x09, 0x08, 0x0B, 0xFC, 0x0B, 0x77, 0x80, 0xC1, 0xF0, 0xE7, 0x60,
  0x48, 0x0C, 0x2F, 0x04, 0x75, 0x09, 0x80, 0xC2, 0xF0, 0x87, 0x50, 0xD8, 0x0C, 0x2F, 0x0C, 0x74,
  0x02, 0x80, 0xC4, 0xF0, 0x17, 0x30, 0x68, 0x0C, 0x4F, 0x05, 0x73, 0x0A, 0x80, 0xC4, 0xF0, 0xA7,
  0x30, 0xE8, 0x0C, 0x4F, 0x0E, 0x72, 0x03, 0x80, 0xC6, 0xF0, 0x37, 0x10, 0x88, 0x0C, 0x6F, 0x07,
  0x71, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xAF, 0xC0, 0xC7, 0x01, 0xFD, 0x02, 0x77, 0x40, 0x7F, 0xD0,
  0x16, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x56, 0x09, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xC0,
  0x96, 0x0E, 0xFC, 0x06, 0x77, 0x60, 0xBF, 0xC0, 0xD5, 0x02, 0xFD, 0x02, 0x77, 0x60, 0x7F, 0xD0,
  0x24, 0x07, 0xFC, 0x0E, 0x77, 0x70, 0x3F, 0xD0, 0x64, 0x0B, 0xFC, 0x0A, 0x77, 0x71, 0xFD, 0x0B,
  0x4F, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xD3, 0x04, 0xFD, 0x03, 0x77, 0x71, 0x08, 0xFD, 0x04, 0x20,
  0x8F, 0xC0, 0xE7, 0x77, 0x20, 0x4F, 0xD0, 0x82, 0x0D, 0xFC, 0x0A, 0x77, 0x73, 0xFD, 0x81, 0xD0,
  0x1F, 0xD0, 0x77, 0x77, 0x30, 0xCF, 0xD0, 0x10, 0x6F, 0xD0, 0x37, 0x77, 0x30, 0x8F, 0xD0, 0x60,
  0xAF, 0xC0, 0xE7, 0x77, 0x40, 0x4F, 0xD0, 0xA0, 0xEF, 0xC0, 0xB7, 0x77, 0x40, 0x1F, 0xD0, 0xE0,
  // "Â" (U+00C2)
  0x77, 0x50, 0x38, 0x09, 0x17, 0x80, 0xC2, 0x00, 0xDF, 0xE0, 0x88, 0x0C, 0x00, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x76, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x74, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x0E, 0x0B,
  0xFB, 0x0A, 0x77, 0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xB0, 0x43,
  0x0B, 0xFB, 0x03, 0x77, 0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x77, 0x10,
  0x3F, 0xA0, 0xE0, 0x37, 0x09, 0xFA, 0x0C, 0x77, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F,
  0xA0, 0x97, 0x76, 0x0D, 0xF9, 0x0B, 0x75, 0x03, 0x0E, 0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x77,
  0x70, 0x10, 0xBF, 0x0B, 0x80, 0xD9, 0x60, 0x08, 0xFF, 0xA0, 0x67, 0x77, 0x76, 0x0C, 0xFF, 0xA0,
  0xA7, 0x77, 0x75, 0x01, 0xFF, 0xB0, 0xE7, 0x77, 0x75, 0x05, 0xFF, 0xC0, 0x37, 0x77, 0x74, 0x09,
  0xFF, 0xC0, 0x87, 0x77, 0x74, 0x0D, 0xFF, 0xC0, 0xC7, 0x77, 0x73, 0x02, 0xFF, 0xE0, 0x17, 0x77,
  0x72, 0x07, 0xFF, 0xE0, 0x57, 0x77, 0x72, 0x0B, 0xFF, 0xE0, 0xA7, 0x77, 0x72, 0xFF, 0xF0, 0xE7,
  0x77, 0x71, 0x04, 0xFB, 0x00, 0xDF, 0xB0, 0x37, 0x77, 0x70, 0x8F, 0xB0, 0x0A, 0xFB, 0x07, 0x77,
  0x77, 0x0D, 0xFB, 0x00, 0x6F, 0xB0, 0xB7, 0x77, 0x60, 0x1F, 0xC0, 0x03, 0xFC, 0x77, 0x76, 0x06,
  0xFC, 0x20, 0xEF, 0xB0, 0x47, 0x77, 0x50, 0xAF, 0xB0, 0xB2, 0x0B, 0xFB, 0x09, 0x77, 0x75, 0x0E,
  0xFB, 0x08, 0x20, 0x7F, 0xB0, 0xD7, 0x77, 0x40, 0x3F, 0xC0, 0x42, 0x03, 0xFC, 0x02, 0x77, 0x73,
  0x07, 0xFC, 0x4F, 0xC0, 0x67, 0x77, 0x30, 0xCF, 0xB0, 0xC4, 0x0B, 0xFB, 0x0A, 0x77, 0x72, 0x01,
  0xFC, 0x08, 0x40, 0x8F, 0xB0, 0xE7, 0x77, 0x20, 0x5F, 0xC0, 0x44, 0x04, 0xFC, 0x04, 0x77, 0x71,
  0x09, 0xFC, 0x50, 0x1F, 0xC0, 0x87, 0x77, 0x10, 0xDF, 0xB0, 0xC6, 0x0C, 0xFB, 0x0C, 0x77, 0x70,
  0x2F, 0xC0, 0x86, 0x08, 0xFC, 0x01, 0x77, 0x60, 0x6F, 0xC0, 0x46, 0x05, 0xFC, 0x05, 0x77, 0x60,
  0xBF, 0xC7, 0x01, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xB0, 0xC7, 0x10, 0xDF, 0xB0, 0xE7, 0x75, 0x04,
  0xFC, 0x08, 0x71, 0x09, 0xFC, 0x03, 0x77, 0x40, 0x8F, 0xC0, 0x47, 0x10, 0x5F, 0xC0, 0x77, 0x74,
  0x0C, 0xFC, 0x72, 0x01, 0xFC, 0x0B, 0x77, 0x30, 0x1F, 0xC0, 0xB7, 0x30, 0xDF, 0xC7, 0x73, 0x05,
  0xFC, 0x07, 0x73, 0x09, 0xFC, 0x05, 0x77, 0x20, 0xAF, 0xC0, 0x37, 0x30, 0x6F, 0xC0, 0x97, 0x72,
  0x0E, 0xFC, 0x74, 0x02, 0xFC, 0x0D, 0x77, 0x10, 0x3F, 0xC0, 0xB7, 0x50, 0xEF, 0xC0, 0x27, 0x70,
  0x7F, 0xC0, 0x77, 0x50, 0xAF, 0xC0, 0x67, 0x70, 0xBF, 0xC0, 0xA8, 0x09, 0x08, 0x0B, 0xFC, 0x0B,
  0x77, 0x80, 0xC1, 0xF0, 0xE7, 0x60, 0x48, 0x0C, 0x2F, 0x04, 0x75, 0x09, 0x80, 0xC2, 0xF0, 0x87,
  0x50, 0xD8, 0x0C, 0x2F, 0x0C, 0x74, 0x02, 0x80, 0xC4, 0xF0, 0x17, 0x30, 0x68, 0x0C, 0x4F, 0x05,
  0x73, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x30, 0xE8, 0x0C, 0x4F, 0x0E, 0x72, 0x03, 0x80, 0xC6, 0xF0,
  0x37, 0x10, 0x88, 0x0C, 0x6F, 0x07, 0x71, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xAF, 0xC0, 0xC7, 0x01,
  0xFD, 0x02, 0x77, 0x40, 0x7F, 0xD0, 0x16, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x56, 0x09,
  0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xC0, 0x96, 0x0E, 0xFC, 0x06, 0x77, 0x60, 0xBF, 0xC0, 0xD5, 0x02,
  0xFD, 0x02, 0x77, 0x60, 0x7F, 0xD0, 0x24, 0x07, 0xFC, 0x0E, 0x77, 0x70, 0x3F, 0xD0, 0x64, 0x0B,
  0xFC, 0x0A, 0x77, 0x71, 0xFD, 0x0B, 0x4F, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xD3, 0x04, 0xFD, 0x03,
  0x77, 0x71, 0x08, 0xFD, 0x04, 0x20, 0x8F, 0xC0, 0xE7, 0x77, 0x20, 0x4F, 0xD0, 0x82, 0x0D, 0xFC,
  0x0A, 0x77, 0x73, 0xFD, 0x81, 0xD0, 0x1F, 0xD0, 0x77, 0x77, 0x30, 0xCF, 0xD0, 0x10, 0x6F, 0xD0,
  0x37, 0x77, 0x30, 0x8F, 0xD0, 0x60, 0xAF, 0xC0, 0xE7, 0x77, 0x40, 0x4F, 0xD0, 0xA0, 0xEF, 0xC0,
  0xB7, 0x77, 0x40, 0x1F, 0xD0, 0xE0,
  // "Ã" (U+00C3)
  0x77, 0x18, 0x75, 0xAD, 0xEE, 0xDA, 0x61, 0x75, 0x08, 0xE7, 0x77, 0x10, 0x30, 0xDF, 0xA0, 0xA0,
  0x47, 0x30, 0xDD, 0x0E, 0x77, 0x70, 0x4F, 0xE0, 0xC0, 0x67, 0x05, 0xE0, 0xC7, 0x76, 0x01, 0x0E,
  0xFF, 0x98, 0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x76, 0x0A, 0xFF, 0xFF, 0xA0, 0x67, 0x75,
  0x03, 0xFF, 0xFF, 0xB0, 0x27, 0x75, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x76, 0xFF, 0xFF, 0xB0, 0x57,
  0x75, 0x05, 0xFF, 0xFF, 0xA0, 0xC7, 0x76, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0,
  0x27, 0x76, 0x0C, 0xE0, 0x46, 0x81, 0x18, 0xEF, 0xD0, 0xE0, 0x37, 0x77, 0x0E, 0xD0, 0xC7, 0x30,
  0x50, 0xBF, 0xA0, 0xC0, 0x27, 0x77, 0x1E, 0x07, 0x75, 0x87, 0x26, 0xAD, 0xEF, 0xDA, 0x48, 0x0D,
  0xA4, 0x00, 0x8F, 0xFA, 0x06, 0x77, 0x77, 0x60, 0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0xFB,
  0x0E, 0x77, 0x77, 0x50, 0x5F, 0xFC, 0x03, 0x77, 0x77, 0x40, 0x9F, 0xFC, 0x08, 0x77, 0x77, 0x40,
  0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xFE, 0x01, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x05, 0x77,
  0x77, 0x20, 0xBF, 0xFE, 0x0A, 0x77, 0x77, 0x2F, 0xFF, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0x0D,
  0xFB, 0x03, 0x77, 0x77, 0x08, 0xFB, 0x00, 0xAF, 0xB0, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0x06, 0xFB,
  0x0B, 0x77, 0x76, 0x01, 0xFC, 0x00, 0x3F, 0xC7, 0x77, 0x60, 0x6F, 0xC2, 0x0E, 0xFB, 0x04, 0x77,
  0x75, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0x97, 0x77, 0x50, 0xEF, 0xB0, 0x82, 0x07, 0xFB, 0x0D,
  0x77, 0x74, 0x03, 0xFC, 0x04, 0x20, 0x3F, 0xC0, 0x27, 0x77, 0x30, 0x7F, 0xC4, 0xFC, 0x06, 0x77,
  0x73, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0, 0xA7, 0x77, 0x20, 0x1F, 0xC0, 0x84, 0x08, 0xFB, 0x0E,
  0x77, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0, 0x47, 0x77, 0x10, 0x9F, 0xC5, 0x01, 0xFC, 0x08,
  0x77, 0x71, 0x0D, 0xFB, 0x0C, 0x60, 0xCF, 0xB0, 0xC7, 0x77, 0x02, 0xFC, 0x08, 0x60, 0x8F, 0xC0,
  0x17, 0x76, 0x06, 0xFC, 0x04, 0x60, 0x5F, 0xC0, 0x57, 0x76, 0x0B, 0xFC, 0x70, 0x1F, 0xC0, 0xA7,
  0x76, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB, 0x0E, 0x77, 0x50, 0x4F, 0xC0, 0x87, 0x10, 0x9F, 0xC0,
  0x37, 0x74, 0x08, 0xFC, 0x04, 0x71, 0x05, 0xFC, 0x07, 0x77, 0x40, 0xCF, 0xC7, 0x20, 0x1F, 0xC0,
  0xB7, 0x73, 0x01, 0xFC, 0x0B, 0x73, 0x0D, 0xFC, 0x77, 0x30, 0x5F, 0xC0, 0x77, 0x30, 0x9F, 0xC0,
  0x57, 0x72, 0x0A, 0xFC, 0x03, 0x73, 0x06, 0xFC, 0x09, 0x77, 0x20, 0xEF, 0xC7, 0x40, 0x2F, 0xC0,
  0xD7, 0x71, 0x03, 0xFC, 0x0B, 0x75, 0x0E, 0xFC, 0x02, 0x77, 0x07, 0xFC, 0x07, 0x75, 0x0A, 0xFC,
  0x06, 0x77, 0x0B, 0xFC, 0x0A, 0x80, 0x90, 0x80, 0xBF, 0xC0, 0xB7, 0x78, 0x0C, 0x1F, 0x0E, 0x76,
  0x04, 0x80, 0xC2, 0xF0, 0x47, 0x50, 0x98, 0x0C, 0x2F, 0x08, 0x75, 0x0D, 0x80, 0xC2, 0xF0, 0xC7,
  0x40, 0x28, 0x0C, 0x4F, 0x01, 0x73, 0x06, 0x80, 0xC4, 0xF0, 0x57, 0x30, 0xA8, 0x0C, 0x4F, 0x0A,
  0x73, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x20, 0x38, 0x0C, 0x6F, 0x03, 0x71, 0x08, 0x80, 0xC6, 0xF0,
  0x77, 0x10, 0xCF, 0xC0, 0x67, 0x74, 0x0A, 0xFC, 0x0C, 0x70, 0x1F, 0xD0, 0x27, 0x74, 0x07, 0xFD,
  0x01, 0x60, 0x5F, 0xC0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0x60, 0x9F, 0xC0, 0xA7, 0x76, 0x0E, 0xFC,
  0x09, 0x60, 0xEF, 0xC0, 0x67, 0x76, 0x0B, 0xFC, 0x0D, 0x50, 0x2F, 0xD0, 0x27, 0x76, 0x07, 0xFD,
  0x02, 0x40, 0x7F, 0xC0, 0xE7, 0x77, 0x03, 0xFD, 0x06, 0x40, 0xBF, 0xC0, 0xA7, 0x77, 0x1F, 0xD0,
  0xB4, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD, 0x30, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x42,
  0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x08, 0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD8, 0x1D,
  0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD, 0x01, 0x06, 0xFD, 0x03, 0x77, 0x73, 0x08, 0xFD, 0x06,
  0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD, 0x0A, 0x0E, 0xFC, 0x0B, 0x77, 0x74, 0x01, 0xFD, 0x0E,
  // "Ä" (U+00C4)
  0x75, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x70, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x76, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03,
  0x77, 0x40, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x74, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD,
  0x77, 0x40, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x30, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04,
  0x77, 0x30, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x30, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7,
  0x74, 0x02, 0xFC, 0x09, 0x71, 0x02, 0xFC, 0x0A, 0x77, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F,
  0xA0, 0xE0, 0x27, 0x76, 0x0A, 0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x71, 0x85, 0x4A,
  0xEF, 0xEB, 0x67, 0x78, 0x54, 0xAD, 0xFE, 0xC7, 0x80, 0xDA, 0x10, 0x08, 0xFF, 0xA0, 0x67, 0x77,
  0x76, 0x0C, 0xFF, 0xA0, 0xA7, 0x77, 0x75, 0x01, 0xFF, 0xB0, 0xE7, 0x77, 0x75, 0x05, 0xFF, 0xC0,
  0x37, 0x77, 0x74, 0x09, 0xFF, 0xC0, 0x87, 0x77, 0x74, 0x0D, 0xFF, 0xC0, 0xC7, 0x77, 0x73, 0x02,
  0xFF, 0xE0, 0x17, 0x77, 0x72, 0x07, 0xFF, 0xE0, 0x57, 0x77, 0x72, 0x0B, 0xFF, 0xE0, 0xA7, 0x77,
  0x72, 0xFF, 0xF0, 0xE7, 0x77, 0x71, 0x04, 0xFB, 0x00, 0xDF, 0xB0, 0x37, 0x77, 0x70, 0x8F, 0xB0,
  0x0A, 0xFB, 0x07, 0x77, 0x77, 0x0D, 0xFB, 0x00, 0x6F, 0xB0, 0xB7, 0x77, 0x60, 0x1F, 0xC0, 0x03,
  0xFC, 0x77, 0x76, 0x06, 0xFC, 0x20, 0xEF, 0xB0, 0x47, 0x77, 0x50, 0xAF, 0xB0, 0xB2, 0x0B, 0xFB,
  0x09, 0x77, 0x75, 0x0E, 0xFB, 0x08, 0x20, 0x7F, 0xB0, 0xD7, 0x77, 0x40, 0x3F, 0xC0, 0x42, 0x03,
  0xFC, 0x02, 0x77, 0x73, 0x07, 0xFC, 0x4F, 0xC0, 0x67, 0x77, 0x30, 0xCF, 0xB0, 0xC4, 0x0B, 0xFB,
  0x0A, 0x77, 0x72, 0x01, 0xFC, 0x08, 0x40, 0x8F, 0xB0, 0xE7, 0x77, 0x20, 0x5F, 0xC0, 0x44, 0x04,
  0xFC, 0x04, 0x77, 0x71, 0x09, 0xFC, 0x50, 0x1F, 0xC0, 0x87, 0x77, 0x10, 0xDF, 0xB0, 0xC6, 0x0C,
  0xFB, 0x0C, 0x77, 0x70, 0x2F, 0xC0, 0x86, 0x08, 0xFC, 0x01, 0x77, 0x60, 0x6F, 0xC0, 0x46, 0x05,
  0xFC, 0x05, 0x77, 0x60, 0xBF, 0xC7, 0x01, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xB0, 0xC7, 0x10, 0xDF,
  0xB0, 0xE7, 0x75, 0x04, 0xFC, 0x08, 0x71, 0x09, 0xFC, 0x03, 0x77, 0x40, 0x8F, 0xC0, 0x47, 0x10,
  0x5F, 0xC0, 0x77, 0x74, 0x0C, 0xFC, 0x72, 0x01, 0xFC, 0x0B, 0x77, 0x30, 0x1F, 0xC0, 0xB7, 0x30,
  0xDF, 0xC7, 0x73, 0x05, 0xFC, 0x07, 0x73, 0x09, 0xFC, 0x05, 0x77, 0x20, 0xAF, 0xC0, 0x37, 0x30,
  0x6F, 0xC0, 0x97, 0x72, 0x0E, 0xFC, 0x74, 0x02, 0xFC, 0x0D, 0x77, 0x10, 0x3F, 0xC0, 0xB7, 0x50,
  0xEF, 0xC0, 0x27, 0x70, 0x7F, 0xC0, 0x77, 0x50, 0xAF, 0xC0, 0x67, 0x70, 0xBF, 0xC0, 0xA8, 0x09,
  0x08, 0x0B, 0xFC, 0x0B, 0x77, 0x80, 0xC1, 0xF0, 0xE7, 0x60, 0x48, 0x0C, 0x2F, 0x04, 0x75, 0x09,
  0x80, 0xC2, 0xF0, 0x87, 0x50, 0xD8, 0x0C, 0x2F, 0x0C, 0x74, 0x02, 0x80, 0xC4, 0xF0, 0x17, 0x30,
  0x68, 0x0C, 0x4F, 0x05, 0x73, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x30, 0xE8, 0x0C, 0x4F, 0x0E, 0x72,
  0x03, 0x80, 0xC6, 0xF0, 0x37, 0x10, 0x88, 0x0C, 0x6F, 0x07, 0x71, 0x0C, 0xFC, 0x06, 0x77, 0x40,
  0xAF, 0xC0, 0xC7, 0x01, 0xFD, 0x02, 0x77, 0x40, 0x7F, 0xD0, 0x16, 0x05, 0xFC, 0x0E, 0x77, 0x50,
  0x3F, 0xD0, 0x56, 0x09, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xC0, 0x96, 0x0E, 0xFC, 0x06, 0x77, 0x60,
  0xBF, 0xC0, 0xD5, 0x02, 0xFD, 0x02, 0x77, 0x60, 0x7F, 0xD0, 0x24, 0x07, 0xFC, 0x0E, 0x77, 0x70,
  0x3F, 0xD0, 0x64, 0x0B, 0xFC, 0x0A, 0x77, 0x71, 0xFD, 0x0B, 0x4F, 0xD0, 0x67, 0x77, 0x10, 0xBF,
  0xD3, 0x04, 0xFD, 0x03, 0x77, 0x71, 0x08, 0xFD, 0x04, 0x20, 0x8F, 0xC0, 0xE7, 0x77, 0x20, 0x4F,
  0xD0, 0x82, 0x0D, 0xFC, 0x0A, 0x77, 0x73, 0xFD, 0x81, 0xD0, 0x1F, 0xD0, 0x77, 0x77, 0x30, 0xCF,
  0xD0, 0x10, 0x6F, 0xD0, 0x37, 0x77, 0x30, 0x8F, 0xD0, 0x60, 0xAF, 0xC0, 0xE7, 0x77, 0x40, 0x4F,
  0xD0, 0xA0, 0xEF, 0xC0, 0xB7, 0x77, 0x40, 0x1F, 0xD0, 0xE0,
  // "Å" (U+00C5)
  0x77, 0x78, 0x90, 0x48, 0xCD, 0xFE, 0xDA, 0x61, 0x80, 0xC4, 0x00, 0x30, 0xCF, 0xB0, 0x90, 0x18,
  0x0C, 0x10, 0x07, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x70, 0x6F, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x50,
  0x3F, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x40, 0xBF, 0xFC, 0x08, 0x77, 0x77, 0x30, 0x2F, 0x0B, 0x03,
  0x20, 0x50, 0xDF, 0x77, 0x77, 0x30, 0x6E, 0x0A, 0x50, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x20, 0x9E,
  0x01, 0x60, 0x5E, 0x08, 0x77, 0x77, 0x20, 0xBD, 0x0C, 0x71, 0xE0, 0x97, 0x77, 0x72, 0x0C, 0xD0,
  0xA7, 0x1E, 0x0A, 0x77, 0x77, 0x20, 0xBD, 0x0C, 0x71, 0xE0, 0x97, 0x77, 0x72, 0x09, 0xE0, 0x16,
  0x05, 0xE0, 0x77, 0x77, 0x72, 0x06, 0xE0, 0x85, 0x01, 0x0D, 0xE0, 0x47, 0x77, 0x72, 0x02, 0xF0,
  0x90, 0x32, 0x04, 0x0D, 0xE0, 0xE7, 0x77, 0x74, 0x0A, 0xFF, 0xC0, 0x77, 0x77, 0x74, 0x02, 0xFF,
  0xB0, 0xD7, 0x77, 0x76, 0x06, 0xFF, 0x90, 0xE0, 0x27, 0x77, 0x77, 0x06, 0xFE, 0x0D, 0x03, 0x80,
  0xC1, 0x00, 0x30, 0xCF, 0xB0, 0x90, 0x18, 0x0C, 0x40, 0x89, 0x03, 0x8C, 0xDF, 0xED, 0xB6, 0x18,
  0x0D, 0xB2, 0x00, 0x8F, 0xFA, 0x06, 0x77, 0x77, 0x60, 0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x50, 0x1F,
  0xFB, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xFC, 0x03, 0x77, 0x77, 0x40, 0x9F, 0xFC, 0x08, 0x77, 0x77,
  0x40, 0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xFE, 0x01, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x05,
  0x77, 0x77, 0x20, 0xBF, 0xFE, 0x0A, 0x77, 0x77, 0x2F, 0xFF, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xB0,
  0x0D, 0xFB, 0x03, 0x77, 0x77, 0x08, 0xFB, 0x00, 0xAF, 0xB0, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0x06,
  0xFB, 0x0B, 0x77, 0x76, 0x01, 0xFC, 0x00, 0x3F, 0xC7, 0x77, 0x60, 0x6F, 0xC2, 0x0E, 0xFB, 0x04,
  0x77, 0x75, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0x97, 0x77, 0x50, 0xEF, 0xB0, 0x82, 0x07, 0xFB,
  0x0D, 0x77, 0x74, 0x03, 0xFC, 0x04, 0x20, 0x3F, 0xC0, 0x27, 0x77, 0x30, 0x7F, 0xC4, 0xFC, 0x06,
  0x77, 0x73, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0, 0xA7, 0x77, 0x20, 0x1F, 0xC0, 0x84, 0x08, 0xFB,
  0x0E, 0x77, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0, 0x47, 0x77, 0x10, 0x9F, 0xC5, 0x01, 0xFC,
  0x08, 0x77, 0x71, 0x0D, 0xFB, 0x0C, 0x60, 0xCF, 0xB0, 0xC7, 0x77, 0x02, 0xFC, 0x08, 0x60, 0x8F,
  0xC0, 0x17, 0x76, 0x06, 0xFC, 0x04, 0x60, 0x5F, 0xC0, 0x57, 0x76, 0x0B, 0xFC, 0x70, 0x1F, 0xC0,
  0xA7, 0x76, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB, 0x0E, 0x77, 0x50, 0x4F, 0xC0, 0x87, 0x10, 0x9F,
  0xC0, 0x37, 0x74, 0x08, 0xFC, 0x04, 0x71, 0x05, 0xFC, 0x07, 0x77, 0x40, 0xCF, 0xC7, 0x20, 0x1F,
  0xC0, 0xB7, 0x73, 0x01, 0xFC, 0x0B, 0x73, 0x0D, 0xFC, 0x77, 0x30, 0x5F, 0xC0, 0x77, 0x30, 0x9F,
  0xC0, 0x57, 0x72, 0x0A, 0xFC, 0x03, 0x73, 0x06, 0xFC, 0x09, 0x77, 0x20, 0xEF, 0xC7, 0x40, 0x2F,
  0xC0, 0xD7, 0x71, 0x03, 0xFC, 0x0B, 0x75, 0x0E, 0xFC, 0x02, 0x77, 0x07, 0xFC, 0x07, 0x75, 0x0A,
  0xFC, 0x06, 0x77, 0x0B, 0xFC, 0x0A, 0x80, 0x90, 0x80, 0xBF, 0xC0, 0xB7, 0x78, 0x0C, 0x1F, 0x0E,
  0x76, 0x04, 0x80, 0xC2, 0xF0, 0x47, 0x50, 0x98, 0x0C, 0x2F, 0x08, 0x75, 0x0D, 0x80, 0xC2, 0xF0,
  0xC7, 0x40, 0x28, 0x0C, 0x4F, 0x01, 0x73, 0x06, 0x80, 0xC4, 0xF0, 0x57, 0x30, 0xA8, 0x0C, 0x4F,
  0x0A, 0x73, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x20, 0x38, 0x0C, 0x6F, 0x03, 0x71, 0x08, 0x80, 0xC6,
  0xF0, 0x77, 0x10, 0xCF, 0xC0, 0x67, 0x74, 0x0A, 0xFC, 0x0C, 0x70, 0x1F, 0xD0, 0x27, 0x74, 0x07,
  0xFD, 0x01, 0x60, 0x5F, 0xC0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0x60, 0x9F, 0xC0, 0xA7, 0x76, 0x0E,
  0xFC, 0x09, 0x60, 0xEF, 0xC0, 0x67, 0x76, 0x0B, 0xFC, 0x0D, 0x50, 0x2F, 0xD0, 0x27, 0x76, 0x07,
  0xFD, 0x02, 0x40, 0x7F, 0xC0, 0xE7, 0x77, 0x03, 0xFD, 0x06, 0x40, 0xBF, 0xC0, 0xA7, 0x77, 0x1F,
  0xD0, 0xB4, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD, 0x30, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0,
  0x42, 0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x08, 0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD8,
  0x1D, 0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD, 0x01, 0x06, 0xFD, 0x03, 0x77, 0x73, 0x08, 0xFD,
  0x06, 0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD, 0x0A, 0x0E, 0xFC, 0x0B, 0x77, 0x74, 0x01, 0xFD,
  0x0E,
  // "Æ" (U+00C6)
  0x77, 0x10, 0xEF, 0xFF, 0xFE, 0x04, 0x77, 0x02, 0xFF, 0xFF, 0xF0, 0x47, 0x70, 0x6F, 0xFF, 0xFF,
  0x04, 0x77, 0x09, 0xFF, 0xFF, 0xF0, 0x47, 0x70, 0xDF, 0xFF, 0xFF, 0x04, 0x76, 0x01, 0x80, 0xC0,
  0xF0, 0x47, 0x60, 0x58, 0x0C, 0x0F, 0x04, 0x76, 0x09, 0x80, 0xC0, 0xF0, 0x47, 0x60, 0xC8, 0x0C,
  0x0F, 0x04, 0x75, 0x01, 0x80, 0xC1, 0xF0, 0x47, 0x50, 0x48, 0x0C, 0x1F, 0x04, 0x75, 0x08, 0xFB,
  0x08, 0x20, 0x2F, 0xB0, 0xA7, 0x77, 0x40, 0xCF, 0xB0, 0x52, 0x02, 0xFB, 0x0A, 0x77, 0x74, 0xFC,
  0x01, 0x20, 0x2F, 0xB0, 0xA7, 0x77, 0x30, 0x4F, 0xB0, 0xD3, 0x02, 0xFB, 0x0A, 0x77, 0x73, 0x07,
  0xFB, 0x0A, 0x30, 0x2F, 0xB0, 0xA7, 0x77, 0x30, 0xBF, 0xB0, 0x63, 0x02, 0xFB, 0x0A, 0x77, 0x73,
  0x0E, 0xFB, 0x03, 0x30, 0x2F, 0xB0, 0xA7, 0x77, 0x20, 0x3F, 0xC4, 0x02, 0xFB, 0x0A, 0x77, 0x72,
  0x07, 0xFB, 0x0C, 0x40, 0x2F, 0xB0, 0xA7, 0x77, 0x20, 0xAF, 0xB0, 0x84, 0x02, 0xFB, 0x0A, 0x77,
  0x72, 0x0E, 0xFB, 0x05, 0x40, 0x2F, 0xB0, 0xA7, 0x77, 0x10, 0x2F, 0xC0, 0x14, 0x02, 0xFB, 0x0A,
  0x77, 0x71, 0x06, 0xFB, 0x0D, 0x50, 0x2F, 0xB0, 0xA7, 0x77, 0x10, 0xAF, 0xB0, 0xA5, 0x02, 0xFB,
  0x0A, 0x77, 0x71, 0x0D, 0xFB, 0x06, 0x50, 0x2F, 0xFF, 0x0A, 0x73, 0x02, 0xFC, 0x03, 0x50, 0x2F,
  0xFF, 0x0A, 0x73, 0x05, 0xFC, 0x60, 0x2F, 0xFF, 0x0A, 0x73, 0x09, 0xFB, 0x0C, 0x60, 0x2F, 0xFF,
  0x0A, 0x73, 0x0D, 0xFB, 0x08, 0x60, 0x2F, 0xFF, 0x0A, 0x72, 0x01, 0xFC, 0x05, 0x60, 0x2F, 0xFF,
  0x0A, 0x72, 0x05, 0xFC, 0x01, 0x60, 0x2F, 0xFF, 0x0A, 0x72, 0x08, 0xFB, 0x0D, 0x70, 0x2F, 0xFF,
  0x0A, 0x72, 0x0C, 0xFB, 0x0A, 0x70, 0x2F, 0xFF, 0x0A, 0x72, 0xFC, 0x07, 0x70, 0x2F, 0xFF, 0x0A,
  0x71, 0x04, 0xFC, 0x03, 0x70, 0x2F, 0xFF, 0x0A, 0x71, 0x08, 0xFC, 0x71, 0x02, 0xFB, 0x0A, 0x77,
  0x50, 0xBF, 0xFF, 0xFA, 0x0A, 0x77, 0x5F, 0xFF, 0xFB, 0x0A, 0x77, 0x40, 0x3F, 0xFF, 0xFB, 0x0A,
  0x77, 0x40, 0x7F, 0xFF, 0xFB, 0x0A, 0x77, 0x40, 0xBF, 0xFF, 0xFB, 0x0A, 0x77, 0x40, 0xEF, 0xFF,
  0xFB, 0x0A, 0x77, 0x30, 0x3F, 0xFF, 0xFC, 0x0A, 0x77, 0x30, 0x6F, 0xFF, 0xFC, 0x0A, 0x77, 0x30,
  0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x30, 0xEF, 0xFF, 0xFC, 0x0A, 0x77, 0x20, 0x2F, 0xFF, 0xFD, 0x0A,
  0x77, 0x20, 0x6F, 0xC0, 0x57, 0x30, 0x2F, 0xB0, 0xA7, 0x72, 0x09, 0xFC, 0x02, 0x73, 0x02, 0xFB,
  0x0A, 0x77, 0x20, 0xDF, 0xB0, 0xE7, 0x40, 0x2F, 0xB0, 0xA7, 0x71, 0x01, 0xFC, 0x0A, 0x74, 0x02,
  0xFB, 0x0A, 0x77, 0x10, 0x5F, 0xC0, 0x77, 0x40, 0x2F, 0xB0, 0xA7, 0x71, 0x09, 0xFC, 0x04, 0x74,
  0x02, 0xFF, 0xFA, 0x04, 0x20, 0xCF, 0xC7, 0x50, 0x2F, 0xFF, 0xA8, 0x14, 0x01, 0xFC, 0x0C, 0x75,
  0x02, 0xFF, 0xFA, 0x81, 0x40, 0x4F, 0xC0, 0x97, 0x50, 0x2F, 0xFF, 0xA8, 0x14, 0x08, 0xFC, 0x05,
  0x75, 0x02, 0xFF, 0xFA, 0x81, 0x40, 0xCF, 0xC0, 0x27, 0x50, 0x2F, 0xFF, 0xA0, 0x41, 0xFC, 0x0E,
  0x76, 0x02, 0xFF, 0xFA, 0x00, 0x4F, 0xC0, 0xB7, 0x60, 0x2F, 0xFF, 0xA0, 0x40, 0x7F, 0xC0, 0x77,
  0x60, 0x2F, 0xFF, 0xA0, 0x40, 0xBF, 0xC0, 0x47, 0x60, 0x2F, 0xFF, 0xA0, 0x40, 0xEF, 0xC0, 0x17,
  0x60, 0x2F, 0xFF, 0xA0, 0x40,
  // "Ç" (U+00C7)
  0x77, 0x71, 0x86, 0x15, 0x79, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xB9, 0x63, 0x77, 0x76, 0x81, 0x49,
  0xDF, 0xFB, 0x81, 0xE9, 0x47, 0x77, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x20, 0x10,
  0x8F, 0xFF, 0xF9, 0x0B, 0x02, 0x76, 0x05, 0x0E, 0xFF, 0xFF, 0xB0, 0x17, 0x50, 0x9F, 0xFF, 0xFC,
  0x09, 0x74, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0x37, 0x30, 0x20, 0xDF, 0xFF, 0xFD, 0x0C, 0x73, 0x02,
  0x0E, 0xFF, 0xFF, 0xE0, 0x67, 0x20, 0x10, 0xDF, 0xFF, 0xFE, 0x0E, 0x73, 0x0B, 0xFF, 0xFF, 0xF0,
  0x97, 0x20, 0x7F, 0xFB, 0x83, 0xD9, 0x63, 0x12, 0x84, 0x12, 0x36, 0x9D, 0xE0, 0x27, 0x10, 0x2F,
  0xFA, 0x0A, 0x03, 0x76, 0x81, 0x27, 0xDA, 0x0B, 0x72, 0x0B, 0xFF, 0x0D, 0x04, 0x77, 0x48, 0x15,
  0xD5, 0x71, 0x03, 0xFF, 0x0C, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xE0, 0xB7, 0x77, 0x73, 0x03, 0xFE,
  0x0D, 0x01, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0x47, 0x77, 0x74, 0x0E, 0xFD, 0x0B, 0x77, 0x77, 0x40,
  0x5F, 0xE0, 0x37, 0x77, 0x74, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x67, 0x77, 0x74,
  0x02, 0xFE, 0x01, 0x77, 0x77, 0x40, 0x6F, 0xD0, 0xD7, 0x77, 0x75, 0x09, 0xFD, 0x09, 0x77, 0x77,
  0x50, 0xCF, 0xD0, 0x67, 0x77, 0x75, 0x0E, 0xFD, 0x04, 0x77, 0x77, 0x5F, 0xE0, 0x17, 0x77, 0x74,
  0x03, 0xFE, 0x77, 0x77, 0x50, 0x4F, 0xD0, 0xE7, 0x77, 0x75, 0x05, 0xFD, 0x0D, 0x77, 0x77, 0x50,
  0x5F, 0xD0, 0xC7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75,
  0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75, 0x06, 0xFD, 0x0C, 0x77, 0x77,
  0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xE7, 0x77, 0x75,
  0x01, 0xFE, 0x02, 0x77, 0x77, 0x5F, 0xE0, 0x57, 0x77, 0x75, 0x0D, 0xFD, 0x08, 0x77, 0x77, 0x50,
  0xBF, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFE, 0x77, 0x77, 0x50, 0x4F, 0xE0, 0x57, 0x77, 0x75, 0xFE,
  0x0B, 0x77, 0x77, 0x50, 0xCF, 0xE0, 0x27, 0x77, 0x74, 0x07, 0xFE, 0x0A, 0x77, 0x77, 0x40, 0x1F,
  0xF0, 0x47, 0x77, 0x74, 0x0B, 0xFE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x5F, 0xF0, 0xD0, 0x27, 0x77,
  0x10, 0x10, 0x67, 0x0D, 0xFF, 0x0E, 0x05, 0x77, 0x58, 0x23, 0x9F, 0xD7, 0x05, 0xFF, 0xA0, 0xB0,
  0x47, 0x78, 0x12, 0x7D, 0xB0, 0xD7, 0x10, 0xCF, 0xFB, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x12, 0x47,
  0xAD, 0xE0, 0xD7, 0x10, 0x38, 0x0C, 0x1F, 0x0D, 0x72, 0x07, 0x80, 0xC0, 0xF0, 0xD7, 0x30, 0xBF,
  0xFF, 0xFF, 0x0D, 0x74, 0x0C, 0xFF, 0xFF, 0xE0, 0xD7, 0x40, 0x10, 0xCF, 0xFF, 0xFD, 0x0D, 0x76,
  0x0A, 0xFF, 0xFF, 0xC0, 0xD7, 0x70, 0x7F, 0xFF, 0xFB, 0x0D, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xF9,
  0x0C, 0x77, 0x30, 0x40, 0xBF, 0xFF, 0xC0, 0xA0, 0x57, 0x76, 0x81, 0x27, 0xCF, 0xFC, 0x82, 0xC9,
  0x51, 0x77, 0x74, 0x82, 0x14, 0x7E, 0xF8, 0x5D, 0xCA, 0x86, 0x41, 0x77, 0x77, 0x40, 0xBE, 0x02,
  0x80, 0xC2, 0x00, 0x2E, 0x0B, 0x80, 0xC3, 0x00, 0x9E, 0x09, 0x80, 0xC2, 0x00, 0x10, 0xEF, 0x90,
  0x90, 0x27, 0x77, 0x77, 0x07, 0xFB, 0x0E, 0x06, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x87, 0x77, 0x74,
  0x82, 0x18, 0xAD, 0xFC, 0x06, 0x77, 0x77, 0x70, 0x20, 0x8F, 0xA0, 0xE8, 0x0C, 0x10, 0x04, 0xFA,
  0x05, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x98, 0x0C, 0x10, 0x08, 0xF9, 0x0B, 0x80, 0xC1, 0x00, 0xAF,
  0x90, 0xC8, 0x0C, 0x00, 0x03, 0xFA, 0x0B, 0x77, 0x76, 0x89, 0x01, 0x95, 0x21, 0x01, 0x38, 0xEF,
  0xA0, 0x97, 0x77, 0x60, 0x1F, 0xFC, 0x05, 0x77, 0x76, 0x01, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x60,
  0x1F, 0xFB, 0x07, 0x77, 0x77, 0x01, 0xFF, 0xA0, 0xB7, 0x77, 0x71, 0x01, 0xFF, 0x90, 0xA7, 0x77,
  0x72, 0x01, 0xFE, 0x0C, 0x05, 0x77, 0x77, 0x48, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37,
  0x73,
  // "È" (U+00C8)
  0x60, 0x58, 0x09, 0x17, 0x04, 0x77, 0x75, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x75, 0x0B, 0xFE, 0x09,
  0x77, 0x76, 0x0C, 0xFE, 0x03, 0x77, 0x75, 0x01, 0x0C, 0xFD, 0x0D, 0x77, 0x77, 0x0C, 0xFD, 0x08,
  0x77, 0x77, 0x0B, 0xFD, 0x03, 0x77, 0x77, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x10, 0xAF, 0xC0, 0x87,
  0x77, 0x71, 0x09, 0xFC, 0x03, 0x77, 0x77, 0x10, 0x8F, 0xB0, 0xD7, 0x77, 0x72, 0x06, 0xFB, 0x0A,
  0x77, 0x77, 0x20, 0x5F, 0xB0, 0x57, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x20,
  0x10, 0xCF, 0x90, 0x58, 0x0B, 0xF5, 0x00, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80,
  0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2,
  0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8,
  0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15,
  0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "É" (U+00C9)
  0x77, 0x72, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x40, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x30, 0x3F,
  0xF0, 0x47, 0x77, 0x40, 0xCF, 0xE0, 0x57, 0x77, 0x40, 0x6F, 0xE0, 0x57, 0x77, 0x40, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x50, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x50, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x50,
  0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x60, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x60, 0x7F, 0xB0, 0xD0,
  0x17, 0x77, 0x60, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x60, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x71, 0x0A,
  0xFA, 0x08, 0x77, 0x77, 0x20, 0xEF, 0x0E, 0x05, 0x80, 0xC8, 0x20, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F,
  0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81,
  0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50,
  0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  // "Ê" (U+00CA)
  0x77, 0x03, 0x80, 0x91, 0x77, 0x77, 0x60, 0xDF, 0xE0, 0x87, 0x77, 0x40, 0x7F, 0xF9, 0x02, 0x77,
  0x72, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x20, 0xCF, 0xFB, 0x07, 0x77, 0x70, 0x8F, 0xFD, 0x03, 0x77,
  0x50, 0x4F, 0xFE, 0x0D, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7, 0x73, 0x0C, 0xFB,
  0x81, 0x40, 0xBF, 0xB0, 0x77, 0x71, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37, 0x60, 0x5F, 0xA0,
  0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x74, 0x03, 0xFA, 0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x30,
  0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x20, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF,
  0x90, 0x67, 0x03, 0xF9, 0x07, 0x77, 0x01, 0x0B, 0xF0, 0xB8, 0x0B, 0xE5, 0x00, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80,
  0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2,
  0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8,
  0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0,
  // "Ë" (U+00CB)
  0x78, 0x65, 0xAE, 0xFE, 0xC7, 0x17, 0x68, 0x65, 0xAD, 0xFE, 0xC7, 0x17, 0x30, 0x10, 0xBF, 0x0E,
  0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x20, 0xBF, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xB0, 0x37, 0x03,
  0xFC, 0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x70, 0x8F, 0xC0, 0xE7, 0x10, 0x8F, 0xD7, 0x0A, 0xFD, 0x02,
  0x70, 0xAF, 0xD0, 0x36, 0x0B, 0xFD, 0x03, 0x70, 0xBF, 0xD0, 0x46, 0x0A, 0xFD, 0x02, 0x70, 0xAF,
  0xD0, 0x36, 0x07, 0xFC, 0x0E, 0x71, 0x07, 0xFD, 0x70, 0x2F, 0xC0, 0x97, 0x10, 0x2F, 0xC0, 0xA7,
  0x10, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F, 0xA0, 0xE0, 0x27, 0x20, 0xAF, 0x0D, 0x03, 0x74, 0x09,
  0xF0, 0xD0, 0x37, 0x48, 0x54, 0xAE, 0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x78, 0x0B, 0xF0,
  0x00, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2,
  0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8,
  0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15,
  0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "Ì" (U+00CC)
  0x40, 0x58, 0x09, 0x17, 0x04, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x72, 0x0B, 0xFE, 0x09,
  0x77, 0x73, 0x0C, 0xFE, 0x03, 0x77, 0x72, 0x01, 0x0C, 0xFD, 0x0D, 0x77, 0x74, 0x0C, 0xFD, 0x08,
  0x77, 0x74, 0x0B, 0xFD, 0x03, 0x77, 0x74, 0x0B, 0xFC, 0x0D, 0x77, 0x75, 0x0A, 0xFC, 0x08, 0x77,
  0x75, 0x09, 0xFC, 0x03, 0x77, 0x75, 0x08, 0xFB, 0x0D, 0x77, 0x76, 0x06, 0xFB, 0x0A, 0x77, 0x76,
  0x05, 0xFB, 0x05, 0x77, 0x76, 0x03, 0x0E, 0xF9, 0x0E, 0x02, 0x77, 0x76, 0x01, 0x0C, 0xF9, 0x05,
  0x80, 0xBD, 0x20, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E,
  0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E,
  0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF8, 0x2E, 0x9C, 0xEF, 0xFF, 0xFC, 0x81, 0xDC, 0x94, 0x86,
  0x23, 0x57, 0x9B, 0xCE, 0xFF, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x77, 0x20, 0x6F, 0xD0, 0x27, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x20, 0x20, 0x8F,
  0xD0, 0x50, 0x17, 0x68, 0x62, 0x35, 0x79, 0xAC, 0xEF, 0xFC, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x20,
  0xC8, 0x0C, 0x0F, 0x0C, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF0, 0xE0,
  // "Í" (U+00CD)
  0x77, 0x70, 0x18, 0x09, 0x27, 0x01, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x70, 0x3F, 0xF0,
  0x47, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x10, 0x6F, 0xE0, 0x57, 0x77, 0x10, 0x10, 0xEF, 0xD0,
  0x57, 0x77, 0x20, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x20, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0x20,
  0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x30, 0x7F, 0xB0, 0xD0, 0x17,
  0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x50, 0xAF, 0xA0,
  0x87, 0x77, 0x60, 0xEF, 0x0E, 0x05, 0x80, 0xBD, 0x70, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF8, 0x2E, 0x9C, 0xEF,
  0xFF, 0xFC, 0x81, 0xDC, 0x94, 0x86, 0x23, 0x57, 0x9B, 0xCE, 0xFF, 0x86, 0xEC, 0xA8, 0x75, 0x31,
  0x77, 0x20, 0x6F, 0xD0, 0x27, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x20, 0x20, 0x8F, 0xD0, 0x50, 0x17, 0x68, 0x62, 0x35, 0x79, 0xAC, 0xEF, 0xFC,
  0x86, 0xEC, 0xA8, 0x75, 0x31, 0x20, 0xC8, 0x0C, 0x0F, 0x0C, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0xE0,
  // "Î" (U+00CE)
  0x75, 0x03, 0x80, 0x91, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x87, 0x77, 0x10, 0x7F, 0xF9, 0x02, 0x77,
  0x60, 0x2F, 0xFA, 0x0C, 0x77, 0x60, 0xCF, 0xFB, 0x07, 0x77, 0x40, 0x8F, 0xFD, 0x03, 0x77, 0x20,
  0x4F, 0xFE, 0x0D, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7, 0x70, 0xCF, 0xB8, 0x14,
  0x0B, 0xFB, 0x07, 0x75, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37, 0x30, 0x5F, 0xA0, 0xE0, 0x45,
  0x0A, 0xFA, 0x0E, 0x01, 0x71, 0x03, 0xFA, 0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x02, 0x0E, 0xF9,
  0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x60, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x64, 0x03,
  0xF9, 0x07, 0x77, 0x01, 0x0B, 0xF0, 0xB8, 0x0B, 0xC2, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C,
  0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C,
  0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x82, 0xE9, 0xCE,
  0xFF, 0xFF, 0xC8, 0x1D, 0xC9, 0x48, 0x62, 0x35, 0x79, 0xBC, 0xEF, 0xF8, 0x6E, 0xCA, 0x87, 0x53,
  0x17, 0x72, 0x06, 0xFD, 0x02, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x72, 0x02, 0x08, 0xFD, 0x05, 0x01, 0x76, 0x86, 0x23, 0x57, 0x9A, 0xCE, 0xFF,
  0xC8, 0x6E, 0xCA, 0x87, 0x53, 0x12, 0x0C, 0x80, 0xC0, 0xF0, 0xC0, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "Ï" (U+00CF)
  0x58, 0x65, 0xAE, 0xFE, 0xC7, 0x17, 0x68, 0x65, 0xAD, 0xFE, 0xC7, 0x17, 0x01, 0x0B, 0xF0, 0xE0,
  0x37, 0x40, 0xBF, 0x0E, 0x04, 0x60, 0xBF, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xB0, 0x34, 0x03, 0xFC,
  0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x40, 0x8F, 0xC0, 0xE7, 0x10, 0x8F, 0xD4, 0x0A, 0xFD, 0x02, 0x70,
  0xAF, 0xD0, 0x33, 0x0B, 0xFD, 0x03, 0x70, 0xBF, 0xD0, 0x43, 0x0A, 0xFD, 0x02, 0x70, 0xAF, 0xD0,
  0x33, 0x07, 0xFC, 0x0E, 0x71, 0x07, 0xFD, 0x40, 0x2F, 0xC0, 0x97, 0x10, 0x2F, 0xC0, 0xA5, 0x0A,
  0xFA, 0x0E, 0x01, 0x72, 0x09, 0xFA, 0x0E, 0x02, 0x60, 0xAF, 0x0D, 0x03, 0x74, 0x09, 0xF0, 0xD0,
  0x37, 0x18, 0x54, 0xAE, 0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x78, 0x0B, 0xC5, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x82, 0xE9, 0xCE, 0xFF, 0xFF, 0xC8, 0x1D, 0xC9, 0x48, 0x62, 0x35, 0x79, 0xBC, 0xEF,
  0xF8, 0x6E, 0xCA, 0x87, 0x53, 0x17, 0x72, 0x06, 0xFD, 0x02, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x72, 0x02, 0x08, 0xFD, 0x05, 0x01, 0x76, 0x86,
  0x23, 0x57, 0x9A, 0xCE, 0xFF, 0xC8, 0x6E, 0xCA, 0x87, 0x53, 0x12, 0x0C, 0x80, 0xC0, 0xF0, 0xC0,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "Ð" (U+00D0)
  0x40, 0xEF, 0xFE, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x77, 0x30, 0xEF, 0xFF, 0xE8, 0x1D, 0x93, 0x77,
  0x70, 0xEF, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x50, 0xEF, 0xFF, 0xFC, 0x0D, 0x05, 0x77, 0x30, 0xEF,
  0xFF, 0xFE, 0x0B, 0x01, 0x77, 0x10, 0xEF, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x0E, 0x80, 0xC1, 0xF0,
  0x57, 0x60, 0xE8, 0x0C, 0x2F, 0x06, 0x75, 0x0E, 0x80, 0xC3, 0xF0, 0x57, 0x40, 0xE8, 0x0C, 0x3F,
  0x0E, 0x03, 0x73, 0x0E, 0xFC, 0x0E, 0x80, 0x38, 0x81, 0x9A, 0xCF, 0xFC, 0x0D, 0x73, 0x0E, 0xFC,
  0x0E, 0x74, 0x04, 0x0A, 0xFF, 0xA0, 0x87, 0x20, 0xEF, 0xC0, 0xE7, 0x60, 0x20, 0xBF, 0xF9, 0x02,
  0x71, 0x0E, 0xFC, 0x0E, 0x77, 0x10, 0x8F, 0xF0, 0xA7, 0x10, 0xEF, 0xC0, 0xE7, 0x72, 0x07, 0xFF,
  0x02, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x0A, 0xFE, 0x09, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x01, 0x0E,
  0xFD, 0x0E, 0x70, 0xEF, 0xC0, 0xE7, 0x74, 0x07, 0xFE, 0x05, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x0E,
  0xFD, 0x09, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x09, 0xFD, 0x0D, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x04,
  0xFE, 0x02, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0xFE, 0x05, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x0B, 0xFD,
  0x08, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x09, 0xFD, 0x0B, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x06, 0xFD,
  0x0D, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x04, 0xFD, 0x0E, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x02, 0xFE,
  0x1F, 0xFF, 0xD0, 0x77, 0x30, 0x1F, 0xE0, 0x2F, 0xFF, 0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0,
  0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0, 0x77, 0x40, 0xEF, 0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x40, 0xEF,
  0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x40, 0xEF, 0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF,
  0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0, 0x77, 0x30, 0x1F, 0xE0, 0x2F, 0xFF, 0xD0, 0x77, 0x30,
  0x2F, 0xE1, 0x80, 0x08, 0xFD, 0x0E, 0x80, 0x58, 0x03, 0x73, 0x04, 0xFD, 0x0E, 0x50, 0xEF, 0xC0,
  0xE7, 0x76, 0x06, 0xFD, 0x0D, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x08, 0xFD, 0x0A, 0x50, 0xEF, 0xC0,
  0xE7, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x0E, 0xFD, 0x05, 0x50, 0xEF, 0xC0,
  0xE7, 0x75, 0x03, 0xFE, 0x02, 0x50, 0xEF, 0xC0, 0xE7, 0x75, 0x08, 0xFD, 0x0D, 0x60, 0xEF, 0xC0,
  0xE7, 0x75, 0x0D, 0xFD, 0x09, 0x60, 0xEF, 0xC0, 0xE7, 0x74, 0x05, 0xFE, 0x05, 0x60, 0xEF, 0xC0,
  0xE7, 0x74, 0x0C, 0xFD, 0x0E, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x06, 0xFE, 0x09, 0x70, 0xEF, 0xC0,
  0xE7, 0x72, 0x02, 0x0E, 0xFE, 0x03, 0x70, 0xEF, 0xC0, 0xE7, 0x71, 0x01, 0x0D, 0xFE, 0x0A, 0x71,
  0x0E, 0xFC, 0x0E, 0x77, 0x03, 0x0D, 0xFF, 0x03, 0x71, 0x0E, 0xFC, 0x0E, 0x76, 0x07, 0xFF, 0x90,
  0xA7, 0x20, 0xEF, 0xC0, 0xE7, 0x38, 0x13, 0x8E, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0xEF, 0xC0, 0xE8,
  0x02, 0x88, 0x29, 0xAC, 0xEF, 0xFC, 0x05, 0x73, 0x0E, 0x80, 0xC3, 0xF0, 0x87, 0x40, 0xE8, 0x0C,
  0x2F, 0x0B, 0x75, 0x0E, 0x80, 0xC1, 0xF0, 0xB7, 0x60, 0xE8, 0x0C, 0x0F, 0x0A, 0x77, 0x0E, 0xFF,
  0xFF, 0xF0, 0x77, 0x71, 0x0E, 0xFF, 0xFF, 0xD0, 0xD0, 0x47, 0x72, 0x0E, 0xFF, 0xFF, 0xB0, 0xE0,
  0x87, 0x74, 0x0E, 0xFF, 0xFF, 0x98, 0x1E, 0x81, 0x77, 0x50, 0xEF, 0xFF, 0xD8, 0x1E, 0xA4, 0x77,
  0x71, 0x0E, 0xFF, 0xD8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x70,
  // "Ñ" (U+00D1)
  0x75, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x20, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x10, 0x4F, 0xE0, 0xC0, 0x67, 0x05, 0xE0, 0xC7, 0x70, 0x10, 0xEF, 0xF9,
  0x82, 0xEA, 0x52, 0x20, 0x50, 0xEE, 0x0A, 0x77, 0x0A, 0xFF, 0xFF, 0xA0, 0x67, 0x60, 0x3F, 0xFF,
  0xFB, 0x02, 0x76, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x7F, 0xFF, 0xFB, 0x05, 0x76, 0x05, 0xFF, 0xFF,
  0xA0, 0xC7, 0x70, 0x8E, 0x85, 0xE5, 0x10, 0x26, 0xBF, 0xFA, 0x0E, 0x02, 0x77, 0x0C, 0xE0, 0x46,
  0x81, 0x18, 0xEF, 0xD0, 0xE0, 0x37, 0x71, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27,
  0x72, 0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xCB, 0x40, 0x0E, 0xFF, 0xA0, 0xE7,
  0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04, 0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF, 0xB0, 0x97, 0x71,
  0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x37, 0x70, 0xAF,
  0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0xD7, 0x70, 0xAF, 0xB0, 0x0E,
  0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x87, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0,
  0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x37, 0x50, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x87, 0x50,
  0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xD7, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x0C, 0x09, 0xFB,
  0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xD0, 0x4F, 0xB0, 0x87, 0x40, 0xAF, 0xB0, 0x0E, 0xFA,
  0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF, 0xB0, 0x0E, 0xFB, 0x10, 0x9F, 0xB0, 0x27, 0x30, 0xAF,
  0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x0E, 0xFA,
  0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x09, 0xFB, 0x02, 0x72, 0x0A, 0xFB, 0x00, 0xEF,
  0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x42, 0x0E, 0xFA, 0x0C, 0x72,
  0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09, 0xFB, 0x02, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52,
  0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x63, 0x0E, 0xFA, 0x0C, 0x71, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02, 0x70, 0xAF, 0xB0, 0x0E, 0xFB, 0x07, 0x30, 0x4F, 0xB0,
  0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84, 0x0E, 0xFA, 0x0C, 0x70, 0xAF, 0xB0, 0x0E, 0xFB, 0x08,
  0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x94, 0x05, 0xFB, 0x06, 0x60, 0xAF, 0xB0,
  0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0xA5, 0x0A, 0xFB, 0x01,
  0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50, 0x5F, 0xB0, 0x65, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0xA6,
  0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x60, 0xAF, 0xB0, 0x14, 0x09, 0xFB, 0x00,
  0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A, 0x7F, 0xB0, 0xB4, 0x09,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB, 0x01, 0x30, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A, 0x70, 0x5F,
  0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x1F, 0xB0, 0xB3, 0x08, 0xFB, 0x00, 0xEF, 0xB0,
  0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0x5F, 0xB0, 0x52, 0x07,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0, 0xA2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0xBF,
  0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x5F, 0xB8, 0x15, 0x05, 0xFB, 0x00, 0xEF, 0xB0,
  0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0xBF, 0xA8, 0x1E, 0x04,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F, 0xB0, 0x50, 0x3F, 0xB0, 0x0E, 0xFB, 0x0A, 0x73, 0x01,
  0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0xBF, 0xA0, 0xE0, 0x2F, 0xB0, 0x0E, 0xFB,
  0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0x1F, 0xB0, 0xBF, 0xB0, 0x0E,
  0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x06, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A,
  0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x76, 0x0B, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x06,
  0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x77, 0x0B, 0xFF, 0xC0,
  0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x01, 0xFF, 0xC0, 0x0E, 0xFB,
  0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x71, 0x07, 0xFF, 0xB0, 0x0E, 0xFB, 0x0A,
  0x77, 0x10, 0x1F, 0xFB, 0x0E,
  // "Ò" (U+00D2)
  0x73, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x77, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x70, 0xBF,
  0xE0, 0x98, 0x0C, 0x00, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x70, 0x10, 0xCF, 0xD0, 0xD8, 0x0C, 0x10,
  0x0C, 0xFD, 0x08, 0x80, 0xC1, 0x00, 0xBF, 0xD0, 0x38, 0x0C, 0x10, 0x0B, 0xFC, 0x0D, 0x80, 0xC2,
  0x00, 0xAF, 0xC0, 0x88, 0x0C, 0x20, 0x09, 0xFC, 0x03, 0x80, 0xC2, 0x00, 0x8F, 0xB0, 0xD8, 0x0C,
  0x30, 0x06, 0xFB, 0x0A, 0x80, 0xC3, 0x00, 0x5F, 0xB0, 0x58, 0x0C, 0x30, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x80, 0xC3, 0x00, 0x10, 0xCF, 0x90, 0x58, 0x0C, 0xB0, 0x08, 0x44, 0x7A, 0xCD, 0xEA, 0x84,
  0xED, 0xCA, 0x74, 0x77, 0x77, 0x50, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF,
  0xE0, 0xE0, 0x77, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x07, 0xFF, 0xFF, 0x08,
  0x77, 0x50, 0x9F, 0xFF, 0xFA, 0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x7F, 0xFF,
  0xFE, 0x07, 0x76, 0x03, 0x80, 0xC0, 0xF0, 0x37, 0x50, 0xD8, 0x0C, 0x0F, 0x0D, 0x74, 0x07, 0x80,
  0xC2, 0xF0, 0x77, 0x20, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01,
  0x71, 0x08, 0xFF, 0x0B, 0x02, 0x71, 0x02, 0x0B, 0xFF, 0x07, 0x71, 0x0E, 0xFE, 0x0A, 0x75, 0x0A,
  0xFE, 0x0E, 0x70, 0x5F, 0xE0, 0xC7, 0x70, 0xCF, 0xE0, 0x56, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE,
  0x0B, 0x50, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01, 0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE,
  0x05, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09, 0x40, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD,
  0x0D, 0x30, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01, 0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD,
  0x04, 0x20, 0x7F, 0xD0, 0xC7, 0x76, 0x0B, 0xFD, 0x07, 0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD,
  0x09, 0x20, 0xCF, 0xD0, 0x77, 0x76, 0x07, 0xFD, 0x0B, 0x20, 0xEF, 0xD0, 0x57, 0x76, 0x04, 0xFD,
  0x0D, 0x2F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x10, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x02,
  0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x03, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF,
  0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x1F, 0xE0, 0x40,
  0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x02, 0xFE, 0x01, 0x77, 0x60,
  0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x1F, 0xE0, 0x37, 0x76, 0x03, 0xFE,
  0x20, 0xEF, 0xD0, 0x47, 0x76, 0x05, 0xFD, 0x0E, 0x20, 0xCF, 0xD0, 0x67, 0x76, 0x07, 0xFD, 0x0B,
  0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20, 0x7F, 0xD0, 0xB7, 0x76, 0x0C, 0xFD, 0x07,
  0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01,
  0x30, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09,
  0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01,
  0x50, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB6, 0x05, 0xFE, 0x0B, 0x77, 0x0C, 0xFE, 0x05, 0x70,
  0xEF, 0xE0, 0x97, 0x50, 0x9F, 0xE0, 0xE7, 0x10, 0x8F, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xBF, 0xF0,
  0x77, 0x10, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x72, 0x07,
  0x80, 0xC2, 0xF0, 0x77, 0x40, 0xD8, 0x0C, 0x0F, 0x0D, 0x75, 0x04, 0x80, 0xC0, 0xF0, 0x47, 0x60,
  0x7F, 0xFF, 0xFE, 0x07, 0x77, 0x10, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFA, 0x0A,
  0x77, 0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x73, 0x07,
  0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x70, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x58, 0x44,
  0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x40,
  // "Ó" (U+00D3)
  0x77, 0x76, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x76, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x50,
  0x3F, 0xF0, 0x47, 0x77, 0x76, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x60, 0x6F, 0xE0, 0x57, 0x77, 0x76,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x70, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x77, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x70, 0x20, 0xEF, 0xB0, 0xE0, 0x28, 0x0C, 0x00, 0x0C, 0xFB, 0x0D, 0x02, 0x80,
  0xC0, 0x00, 0x7F, 0xB0, 0xD0, 0x18, 0x0C, 0x00, 0x03, 0xFB, 0x0B, 0x01, 0x80, 0xC0, 0x00, 0x10,
  0xDF, 0xA0, 0xA8, 0x0C, 0x20, 0x0A, 0xFA, 0x08, 0x80, 0xC3, 0x00, 0xEF, 0x0E, 0x05, 0x80, 0xCB,
  0x50, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xA0,
  0xB0, 0x57, 0x77, 0x70, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x73, 0x04, 0x0D, 0xFF, 0xFB, 0x0D,
  0x04, 0x77, 0x70, 0x7F, 0xFF, 0xF0, 0x87, 0x75, 0x09, 0xFF, 0xFF, 0xA0, 0xA7, 0x73, 0x0A, 0xFF,
  0xFF, 0xC0, 0xA7, 0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x60, 0x38, 0x0C, 0x0F, 0x03, 0x75, 0x0D,
  0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x78, 0x0C, 0x2F, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41,
  0x28, 0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x10, 0x8F, 0xF0, 0xB0, 0x27, 0x10, 0x20, 0xBF, 0xF0,
  0x77, 0x10, 0xEF, 0xE0, 0xA7, 0x50, 0xAF, 0xE0, 0xE7, 0x05, 0xFE, 0x0C, 0x77, 0x0C, 0xFE, 0x05,
  0x60, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB5, 0x01, 0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x14,
  0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94,
  0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD3, 0x01, 0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x12,
  0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x07, 0xFD, 0x0C, 0x77, 0x60, 0xBF, 0xD0, 0x72,
  0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x0C, 0xFD, 0x07, 0x77, 0x60, 0x7F, 0xD0, 0xB2,
  0x0E, 0xFD, 0x05, 0x77, 0x60, 0x4F, 0xD0, 0xD2, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE1, 0x01, 0xFE,
  0x02, 0x77, 0x60, 0x2F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x03, 0xFE, 0x77,
  0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0,
  0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04,
  0xFD, 0x0E, 0x77, 0x71, 0xFE, 0x04, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F,
  0xE0, 0x30, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0,
  0x11, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD, 0x04, 0x77, 0x60, 0x5F, 0xD0, 0xE2, 0x0C,
  0xFD, 0x06, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x07,
  0xFD, 0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x72, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01,
  0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD4, 0x0A,
  0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x01,
  0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x60, 0x5F,
  0xE0, 0xB7, 0x70, 0xCF, 0xE0, 0x57, 0x0E, 0xFE, 0x09, 0x75, 0x09, 0xFE, 0x0E, 0x71, 0x08, 0xFF,
  0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0x07, 0x71, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11,
  0x49, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C, 0x2F, 0x07, 0x74, 0x0D, 0x80, 0xC0, 0xF0, 0xD7,
  0x50, 0x48, 0x0C, 0x0F, 0x04, 0x76, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x71, 0x0A, 0xFF, 0xFF, 0xC0,
  0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x75, 0x08, 0xFF, 0xFF, 0x08, 0x77, 0x70, 0x40, 0xDF,
  0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x30, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x05, 0x0B, 0xFF,
  0xA0, 0xB0, 0x57, 0x77, 0x75, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x74,
  // "Ô" (U+00D4)
  0x77, 0x40, 0x38, 0x09, 0x17, 0x80, 0xC0, 0x00, 0xDF, 0xE0, 0x87, 0x77, 0x76, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x74, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x72, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x70, 0x4F, 0xFE, 0x0D, 0x77, 0x76, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB,
  0x0A, 0x77, 0x75, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x30, 0x8F, 0xB0, 0x43, 0x0B,
  0xFB, 0x03, 0x77, 0x71, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x76, 0x03, 0xFA,
  0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x75, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09,
  0x77, 0x40, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x72, 0x03, 0xF9, 0x07, 0x77, 0x01,
  0x0B, 0xF0, 0xB8, 0x0C, 0xA0, 0x08, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x77,
  0x50, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x30,
  0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x07, 0xFF, 0xFF, 0x08, 0x77, 0x50, 0x9F, 0xFF, 0xFA,
  0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x7F, 0xFF, 0xFE, 0x07, 0x76, 0x03, 0x80,
  0xC0, 0xF0, 0x37, 0x50, 0xD8, 0x0C, 0x0F, 0x0D, 0x74, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x20, 0x10,
  0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x71, 0x08, 0xFF, 0x0B, 0x02,
  0x71, 0x02, 0x0B, 0xFF, 0x07, 0x71, 0x0E, 0xFE, 0x0A, 0x75, 0x0A, 0xFE, 0x0E, 0x70, 0x5F, 0xE0,
  0xC7, 0x70, 0xCF, 0xE0, 0x56, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x50, 0x1F, 0xE0, 0x97,
  0x72, 0x09, 0xFE, 0x01, 0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40, 0xAF, 0xD0, 0xC7,
  0x74, 0x0C, 0xFD, 0x09, 0x40, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x30, 0x1F, 0xE0, 0x37,
  0x74, 0x03, 0xFE, 0x01, 0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20, 0x7F, 0xD0, 0xC7,
  0x76, 0x0B, 0xFD, 0x07, 0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20, 0xCF, 0xD0, 0x77,
  0x76, 0x07, 0xFD, 0x0B, 0x20, 0xEF, 0xD0, 0x57, 0x76, 0x04, 0xFD, 0x0D, 0x2F, 0xE0, 0x37, 0x76,
  0x03, 0xFE, 0x10, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x60, 0x1F,
  0xE0, 0x20, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x04, 0xFD, 0x0E,
  0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77,
  0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x1F, 0xE0, 0x40, 0x3F, 0xE7, 0x77, 0x1F, 0xE0,
  0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x02, 0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x1F, 0xE0,
  0x27, 0x76, 0x02, 0xFE, 0x01, 0x1F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x47, 0x76,
  0x05, 0xFD, 0x0E, 0x20, 0xCF, 0xD0, 0x67, 0x76, 0x07, 0xFD, 0x0B, 0x20, 0x9F, 0xD0, 0x97, 0x76,
  0x09, 0xFD, 0x09, 0x20, 0x7F, 0xD0, 0xB7, 0x76, 0x0C, 0xFD, 0x07, 0x20, 0x4F, 0xD0, 0xE7, 0x76,
  0x0E, 0xFD, 0x04, 0x20, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01, 0x30, 0xDF, 0xD0, 0x77, 0x74,
  0x07, 0xFD, 0x0D, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09, 0x40, 0x5F, 0xE0, 0x27, 0x72,
  0x02, 0xFE, 0x05, 0x40, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01, 0x50, 0xBF, 0xE0, 0x27, 0x70,
  0x2F, 0xE0, 0xB6, 0x05, 0xFE, 0x0B, 0x77, 0x0C, 0xFE, 0x05, 0x70, 0xEF, 0xE0, 0x97, 0x50, 0x9F,
  0xE0, 0xE7, 0x10, 0x8F, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xBF, 0xF0, 0x77, 0x10, 0x10, 0xEF, 0xF9,
  0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x40,
  0xD8, 0x0C, 0x0F, 0x0D, 0x75, 0x04, 0x80, 0xC0, 0xF0, 0x47, 0x60, 0x7F, 0xFF, 0xFE, 0x07, 0x77,
  0x10, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFA, 0x0A, 0x77, 0x50, 0x8F, 0xFF, 0xF0,
  0x87, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xE0, 0xE0, 0x77,
  0x77, 0x70, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x58, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED,
  0xCA, 0x74, 0x77, 0x40,
  // "Õ" (U+00D5)
  0x77, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x60, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x50, 0x4F, 0xE0, 0xC0, 0x67, 0x05, 0xE0, 0xC7, 0x74, 0x01, 0x0E, 0xFF,
  0x98, 0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x74, 0x0A, 0xFF, 0xFF, 0xA0, 0x67, 0x73, 0x03,
  0xFF, 0xFF, 0xB0, 0x27, 0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x74, 0xFF, 0xFF, 0xB0, 0x57, 0x73,
  0x05, 0xFF, 0xFF, 0xA0, 0xC7, 0x74, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27,
  0x74, 0x0C, 0xE0, 0x46, 0x81, 0x18, 0xEF, 0xD0, 0xE0, 0x37, 0x75, 0x0E, 0xD0, 0xC7, 0x30, 0x50,
  0xBF, 0xA0, 0xC0, 0x27, 0x76, 0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xCA, 0x60,
  0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xA0, 0xB0,
  0x57, 0x77, 0x70, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x73, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04,
  0x77, 0x70, 0x7F, 0xFF, 0xF0, 0x87, 0x75, 0x09, 0xFF, 0xFF, 0xA0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF,
  0xC0, 0xA7, 0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x60, 0x38, 0x0C, 0x0F, 0x03, 0x75, 0x0D, 0x80,
  0xC0, 0xF0, 0xD7, 0x40, 0x78, 0x0C, 0x2F, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28,
  0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x10, 0x8F, 0xF0, 0xB0, 0x27, 0x10, 0x20, 0xBF, 0xF0, 0x77,
  0x10, 0xEF, 0xE0, 0xA7, 0x50, 0xAF, 0xE0, 0xE7, 0x05, 0xFE, 0x0C, 0x77, 0x0C, 0xFE, 0x05, 0x60,
  0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB5, 0x01, 0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x14, 0x05,
  0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x0D,
  0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD3, 0x01, 0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x12, 0x04,
  0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x07, 0xFD, 0x0C, 0x77, 0x60, 0xBF, 0xD0, 0x72, 0x09,
  0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x0C, 0xFD, 0x07, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x0E,
  0xFD, 0x05, 0x77, 0x60, 0x4F, 0xD0, 0xD2, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE1, 0x01, 0xFE, 0x02,
  0x77, 0x60, 0x2F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04,
  0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD,
  0x0E, 0x77, 0x71, 0xFE, 0x04, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0,
  0x30, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x11,
  0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD, 0x04, 0x77, 0x60, 0x5F, 0xD0, 0xE2, 0x0C, 0xFD,
  0x06, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x07, 0xFD,
  0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x72, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01, 0xFE,
  0x03, 0x77, 0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD4, 0x0A, 0xFD,
  0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x01, 0xFE,
  0x09, 0x77, 0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x60, 0x5F, 0xE0,
  0xB7, 0x70, 0xCF, 0xE0, 0x57, 0x0E, 0xFE, 0x09, 0x75, 0x09, 0xFE, 0x0E, 0x71, 0x08, 0xFF, 0x0B,
  0x01, 0x71, 0x01, 0x0B, 0xFF, 0x07, 0x71, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49,
  0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C, 0x2F, 0x07, 0x74, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x50,
  0x48, 0x0C, 0x0F, 0x04, 0x76, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x71, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7,
  0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x75, 0x08, 0xFF, 0xFF, 0x08, 0x77, 0x70, 0x40, 0xDF, 0xFF,
  0xB0, 0xD0, 0x47, 0x77, 0x30, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x05, 0x0B, 0xFF, 0xA0,
  0xB0, 0x57, 0x77, 0x75, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x74,
  // "Ö" (U+00D6)
  0x74, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x50, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x74, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03,
  0x77, 0x20, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x72, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD,
  0x77, 0x20, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04,
  0x77, 0x10, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7,
  0x72, 0x02, 0xFC, 0x09, 0x71, 0x02, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F,
  0xA0, 0xE0, 0x27, 0x74, 0x0A, 0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x68, 0x54, 0xAE,
  0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x78, 0x0C, 0xA3, 0x08, 0x44, 0x7A, 0xCD, 0xEA, 0x84,
  0xED, 0xCA, 0x74, 0x77, 0x77, 0x50, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x07, 0x0E, 0xFF,
  0xE0, 0xE0, 0x77, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x07, 0xFF, 0xFF, 0x08,
  0x77, 0x50, 0x9F, 0xFF, 0xFA, 0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x7F, 0xFF,
  0xFE, 0x07, 0x76, 0x03, 0x80, 0xC0, 0xF0, 0x37, 0x50, 0xD8, 0x0C, 0x0F, 0x0D, 0x74, 0x07, 0x80,
  0xC2, 0xF0, 0x77, 0x20, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01,
  0x71, 0x08, 0xFF, 0x0B, 0x02, 0x71, 0x02, 0x0B, 0xFF, 0x07, 0x71, 0x0E, 0xFE, 0x0A, 0x75, 0x0A,
  0xFE, 0x0E, 0x70, 0x5F, 0xE0, 0xC7, 0x70, 0xCF, 0xE0, 0x56, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE,
  0x0B, 0x50, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01, 0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE,
  0x05, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09, 0x40, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD,
  0x0D, 0x30, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01, 0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD,
  0x04, 0x20, 0x7F, 0xD0, 0xC7, 0x76, 0x0B, 0xFD, 0x07, 0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD,
  0x09, 0x20, 0xCF, 0xD0, 0x77, 0x76, 0x07, 0xFD, 0x0B, 0x20, 0xEF, 0xD0, 0x57, 0x76, 0x04, 0xFD,
  0x0D, 0x2F, 0xE0, 0x37, 0x76, 0x03, 0xFE, 0x10, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x02,
  0xFE, 0x01, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x03, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF,
  0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x1F, 0xE0, 0x40,
  0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x03, 0x02, 0xFE, 0x01, 0x77, 0x60,
  0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x27, 0x76, 0x02, 0xFE, 0x01, 0x1F, 0xE0, 0x37, 0x76, 0x03, 0xFE,
  0x20, 0xEF, 0xD0, 0x47, 0x76, 0x05, 0xFD, 0x0E, 0x20, 0xCF, 0xD0, 0x67, 0x76, 0x07, 0xFD, 0x0B,
  0x20, 0x9F, 0xD0, 0x97, 0x76, 0x09, 0xFD, 0x09, 0x20, 0x7F, 0xD0, 0xB7, 0x76, 0x0C, 0xFD, 0x07,
  0x20, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x04, 0x20, 0x1F, 0xE0, 0x37, 0x74, 0x03, 0xFE, 0x01,
  0x30, 0xDF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0D, 0x40, 0xAF, 0xD0, 0xC7, 0x74, 0x0C, 0xFD, 0x09,
  0x40, 0x5F, 0xE0, 0x27, 0x72, 0x02, 0xFE, 0x05, 0x40, 0x1F, 0xE0, 0x97, 0x72, 0x09, 0xFE, 0x01,
  0x50, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB6, 0x05, 0xFE, 0x0B, 0x77, 0x0C, 0xFE, 0x05, 0x70,
  0xEF, 0xE0, 0x97, 0x50, 0x9F, 0xE0, 0xE7, 0x10, 0x8F, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xBF, 0xF0,
  0x77, 0x10, 0x10, 0xEF, 0xF9, 0x81, 0x94, 0x12, 0x81, 0x14, 0x9F, 0xF9, 0x0E, 0x01, 0x72, 0x07,
  0x80, 0xC2, 0xF0, 0x77, 0x40, 0xD8, 0x0C, 0x0F, 0x0D, 0x75, 0x04, 0x80, 0xC0, 0xF0, 0x47, 0x60,
  0x7F, 0xFF, 0xFE, 0x07, 0x77, 0x10, 0xAF, 0xFF, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xFF, 0xFA, 0x0A,
  0x77, 0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x73, 0x07,
  0x0E, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x70, 0x50, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x58, 0x44,
  0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x40,
  // "×" (U+00D7)
  0x60, 0x02, 0x77, 0x73, 0x00, 0x27, 0x48, 0x21, 0xDE, 0x37, 0x77, 0x18, 0x23, 0xED, 0x27, 0x20,
  0x10, 0xDA, 0x0E, 0x03, 0x77, 0x60, 0x30, 0xEA, 0x0D, 0x02, 0x70, 0x10, 0xDC, 0x0E, 0x03, 0x77,
  0x40, 0x30, 0xEC, 0x0D, 0x02, 0x50, 0x10, 0xCE, 0x0E, 0x03, 0x77, 0x20, 0x30, 0xEE, 0x0E, 0x02,
  0x30, 0x10, 0xCF, 0x90, 0xE0, 0x37, 0x70, 0x40, 0xEF, 0x98, 0x3E, 0x20, 0x1C, 0xFB, 0x0E, 0x04,
  0x75, 0x04, 0x0E, 0xFB, 0x81, 0xE2, 0x8F, 0xE0, 0x47, 0x30, 0x4F, 0xE8, 0x19, 0x0B, 0xFE, 0x04,
  0x71, 0x04, 0xFE, 0x0A, 0x30, 0xBF, 0xE0, 0x56, 0x05, 0xFE, 0x0A, 0x50, 0xBF, 0xE0, 0x54, 0x05,
  0xFE, 0x0A, 0x70, 0xBF, 0xE0, 0x52, 0x05, 0xFE, 0x0A, 0x72, 0x0B, 0xFE, 0x00, 0x5F, 0xE0, 0xA7,
  0x40, 0xBF, 0xFF, 0xD0, 0xA7, 0x60, 0xBF, 0xFF, 0xB0, 0xA7, 0x71, 0x0B, 0xFF, 0xF9, 0x0A, 0x77,
  0x30, 0xBF, 0xFE, 0x0A, 0x77, 0x50, 0xBF, 0xFC, 0x0A, 0x77, 0x70, 0xBF, 0xFA, 0x0A, 0x77, 0x72,
  0x0B, 0xFF, 0x0A, 0x77, 0x73, 0x05, 0xFF, 0x03, 0x77, 0x72, 0x04, 0xFF, 0x90, 0xE0, 0x37, 0x77,
  0x04, 0xFF, 0xB0, 0xE0, 0x37, 0x75, 0x04, 0xFF, 0xD0, 0xE0, 0x37, 0x73, 0x03, 0x0E, 0xFF, 0xE0,
  0xE0, 0x37, 0x71, 0x03, 0x0E, 0xFF, 0xF9, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xFF, 0xFB, 0x0E, 0x02,
  0x74, 0x03, 0x0E, 0xFD, 0x09, 0x0A, 0xFD, 0x0E, 0x02, 0x72, 0x03, 0x0E, 0xFD, 0x09, 0x20, 0xAF,
  0xD0, 0xE0, 0x27, 0x03, 0x0E, 0xFD, 0x09, 0x40, 0xAF, 0xD0, 0xE0, 0x25, 0x03, 0x0E, 0xFD, 0x09,
  0x60, 0xAF, 0xD0, 0xD0, 0x23, 0x02, 0x0E, 0xFD, 0x09, 0x71, 0x0A, 0xFD, 0x83, 0xD2, 0x02, 0xEF,
  0xD0, 0x97, 0x30, 0xAF, 0xD8, 0x1D, 0x25, 0xFD, 0x09, 0x75, 0x0A, 0xFD, 0x81, 0x50, 0x5F, 0xB0,
  0x97, 0x70, 0xAF, 0xB0, 0x63, 0x05, 0xF9, 0x09, 0x77, 0x20, 0xAF, 0x90, 0x65, 0x06, 0xE0, 0x97,
  0x74, 0x0A, 0xE0, 0x67, 0x06, 0xC0, 0x97, 0x76, 0x0A, 0xC0, 0x67, 0x20, 0x7A, 0x09, 0x77, 0x71,
  0x0A, 0xA0, 0x67, 0x40, 0x70, 0x97, 0x77, 0x30, 0x90, 0x66,
  // "Ø" (U+00D8)
  0x80, 0xD0, 0x08, 0x16, 0xD4, 0x80, 0xD4, 0x00, 0x20, 0xEA, 0x0A, 0x01, 0x77, 0x71, 0x84, 0x47,
  0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x30, 0xCC, 0x0E, 0x05, 0x77, 0x40, 0x50, 0xBF, 0xFA,
  0x0B, 0x05, 0x60, 0x7F, 0x0A, 0x01, 0x77, 0x07, 0x0E, 0xFF, 0xE0, 0xD0, 0x73, 0x03, 0xFA, 0x0A,
  0x75, 0x04, 0x0D, 0xFF, 0xFB, 0x82, 0xD3, 0x0C, 0xF9, 0x0E, 0x01, 0x74, 0x07, 0xFF, 0xFF, 0x0C,
  0xFA, 0x05, 0x74, 0x09, 0x80, 0xC2, 0xF0, 0xA7, 0x40, 0x98, 0x0C, 0x2F, 0x0D, 0x01, 0x73, 0x07,
  0x80, 0xC3, 0xF0, 0x47, 0x30, 0x38, 0x0C, 0x3F, 0x08, 0x74, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x40,
  0x78, 0x0C, 0x3F, 0x03, 0x74, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x12, 0x5B, 0xFF, 0xA0, 0x27,
  0x30, 0x7F, 0xF0, 0xB0, 0x27, 0x10, 0x30, 0xDF, 0xF0, 0xA7, 0x30, 0xEF, 0xE0, 0xA7, 0x50, 0xCF,
  0xF0, 0x17, 0x10, 0x5F, 0xE0, 0xC7, 0x60, 0x10, 0xDF, 0xE0, 0x77, 0x10, 0xAF, 0xE0, 0x27, 0x70,
  0xCF, 0xE0, 0xD7, 0x01, 0xFE, 0x09, 0x77, 0x07, 0xFF, 0x90, 0x26, 0x05, 0xFE, 0x02, 0x76, 0x03,
  0xFF, 0xA0, 0x76, 0x09, 0xFD, 0x0C, 0x77, 0x0C, 0xFF, 0xA0, 0xB6, 0x0D, 0xFD, 0x07, 0x76, 0x08,
  0xFF, 0xB0, 0xE5, 0x01, 0xFE, 0x03, 0x75, 0x03, 0xFF, 0xD0, 0x34, 0x04, 0xFD, 0x0E, 0x76, 0x0C,
  0xFF, 0xD0, 0x54, 0x07, 0xFD, 0x0C, 0x75, 0x08, 0xFF, 0xE0, 0x84, 0x09, 0xFD, 0x09, 0x74, 0x03,
  0xFF, 0xF0, 0xA4, 0x0B, 0xFD, 0x07, 0x74, 0x0D, 0xFF, 0xF0, 0xC4, 0x0D, 0xFD, 0x05, 0x73, 0x08,
  0xFA, 0x0A, 0xFD, 0x0E, 0x4F, 0xE0, 0x37, 0x20, 0x3F, 0xA0, 0xA0, 0x3F, 0xE3, 0x01, 0xFE, 0x02,
  0x72, 0x0D, 0xF9, 0x81, 0xE1, 0x2F, 0xE0, 0x12, 0x02, 0xFE, 0x01, 0x71, 0x08, 0xFA, 0x81, 0x50,
  0x1F, 0xE0, 0x22, 0x03, 0xFE, 0x71, 0x03, 0xFA, 0x0A, 0x3F, 0xE0, 0x32, 0x03, 0xFE, 0x71, 0x0D,
  0xF9, 0x0E, 0x01, 0x3F, 0xE0, 0x32, 0x04, 0xFD, 0x0E, 0x70, 0x9F, 0xA0, 0x54, 0x0E, 0xFD, 0x04,
  0x20, 0x4F, 0xD0, 0xE6, 0x03, 0xFA, 0x0A, 0x50, 0xEF, 0xD0, 0x42, 0x04, 0xFD, 0x0E, 0x60, 0xDF,
  0x90, 0xE0, 0x15, 0x0E, 0xFD, 0x04, 0x20, 0x4F, 0xD0, 0xE5, 0x09, 0xFA, 0x05, 0x60, 0xEF, 0xD0,
  0x32, 0x03, 0xFE, 0x40, 0x4F, 0xA0, 0xA7, 0xFE, 0x03, 0x20, 0x3F, 0xE4, 0x0D, 0xF9, 0x0E, 0x01,
  0x7F, 0xE0, 0x32, 0x02, 0xFE, 0x30, 0x9F, 0xA0, 0x57, 0x01, 0xFE, 0x02, 0x20, 0x1F, 0xE8, 0x11,
  0x04, 0xFA, 0x0A, 0x71, 0x02, 0xFE, 0x4F, 0xE8, 0x13, 0x0D, 0xF9, 0x0E, 0x01, 0x71, 0x03, 0xFE,
  0x40, 0xEF, 0xD0, 0x40, 0x9F, 0xA0, 0x57, 0x20, 0x4F, 0xD0, 0xD4, 0x0C, 0xFD, 0x0B, 0xFA, 0x0A,
  0x73, 0x06, 0xFD, 0x0B, 0x40, 0xAF, 0xFF, 0x0E, 0x01, 0x73, 0x08, 0xFD, 0x09, 0x40, 0x8F, 0xFF,
  0x05, 0x74, 0x0B, 0xFD, 0x07, 0x40, 0x6F, 0xFE, 0x0A, 0x75, 0x0E, 0xFD, 0x04, 0x40, 0x3F, 0xFD,
  0x0E, 0x01, 0x74, 0x02, 0xFE, 0x01, 0x5F, 0xFD, 0x05, 0x75, 0x06, 0xFD, 0x0D, 0x60, 0xBF, 0xFB,
  0x0A, 0x76, 0x0B, 0xFD, 0x09, 0x60, 0x8F, 0xFA, 0x0E, 0x01, 0x75, 0x02, 0xFE, 0x05, 0x60, 0x3F,
  0xFA, 0x05, 0x76, 0x08, 0xFE, 0x01, 0x70, 0xEF, 0xF0, 0xA7, 0x60, 0x1F, 0xE0, 0xB7, 0x10, 0x8F,
  0xF0, 0x17, 0x60, 0xBF, 0xE0, 0x57, 0x10, 0x2F, 0xF0, 0xA7, 0x50, 0x9F, 0xE0, 0xE7, 0x30, 0xBF,
  0xF0, 0xB0, 0x27, 0x10, 0x10, 0xBF, 0xF0, 0x77, 0x30, 0x3F, 0xFA, 0x81, 0xA5, 0x22, 0x81, 0x14,
  0x9F, 0xF9, 0x0E, 0x01, 0x74, 0x0D, 0x80, 0xC2, 0xF0, 0x77, 0x40, 0x58, 0x0C, 0x2F, 0x0D, 0x74,
  0x01, 0x0E, 0x80, 0xC2, 0xF0, 0x37, 0x40, 0xB8, 0x0C, 0x2F, 0x07, 0x74, 0x07, 0x80, 0xC2, 0xF0,
  0xA7, 0x40, 0x28, 0x0C, 0x2F, 0x0A, 0x75, 0x0C, 0x80, 0xC1, 0xF0, 0x87, 0x50, 0x8F, 0xA8, 0x17,
  0x5E, 0xFF, 0xFB, 0x0D, 0x04, 0x75, 0x03, 0xFA, 0x0C, 0x30, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77,
  0x07, 0xFA, 0x02, 0x50, 0x60, 0xBF, 0xFA, 0x0B, 0x05, 0x77, 0x30, 0x30, 0xDE, 0x07, 0x71, 0x85,
  0x14, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x74, 0x77, 0x71, 0x09, 0xC0, 0xC8, 0x0D, 0x30, 0x04,
  0x0D, 0xA0, 0x28, 0x0D, 0x40, 0x81, 0x19, 0x68, 0x0D, 0x00,
  // "Ù" (U+00D9)
  0x71, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x73, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x30, 0xBF,
  0xE0, 0x97, 0x77, 0x74, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x30, 0x10, 0xCF, 0xD0, 0xD7, 0x77, 0x75,
  0x0C, 0xFD, 0x08, 0x77, 0x77, 0x50, 0xBF, 0xD0, 0x37, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x77,
  0x60, 0xAF, 0xC0, 0x87, 0x77, 0x76, 0x09, 0xFC, 0x03, 0x77, 0x77, 0x60, 0x8F, 0xB0, 0xD7, 0x77,
  0x77, 0x06, 0xFB, 0x0A, 0x77, 0x77, 0x70, 0x5F, 0xB0, 0x57, 0x77, 0x77, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x70, 0x10, 0xCF, 0x90, 0x58, 0x0C, 0xB6, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x27, 0x74, 0x02, 0xFD, 0x00, 0xEF, 0xD0, 0x37, 0x74, 0x03, 0xFD, 0x0E, 0x0D,
  0xFD, 0x05, 0x77, 0x40, 0x5F, 0xD0, 0xD0, 0xCF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0C, 0x0A, 0xFD,
  0x0A, 0x77, 0x40, 0xAF, 0xD0, 0xA0, 0x8F, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x05, 0xFE, 0x03,
  0x77, 0x20, 0x3F, 0xE0, 0x50, 0x2F, 0xE0, 0xA7, 0x72, 0x0A, 0xFE, 0x81, 0x10, 0xEF, 0xE0, 0x47,
  0x70, 0x3F, 0xE0, 0xD2, 0x09, 0xFE, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFE, 0x08, 0x20, 0x4F, 0xF0,
  0xE0, 0x67, 0x30, 0x50, 0xEF, 0xF0, 0x23, 0x0D, 0xFF, 0x98, 0x2D, 0x83, 0x12, 0x82, 0x13, 0x7C,
  0xFF, 0x90, 0xB4, 0x06, 0x80, 0xC4, 0xF0, 0x35, 0x0D, 0x80, 0xC2, 0xF0, 0xA6, 0x03, 0x80, 0xC1,
  0xF0, 0xE0, 0x17, 0x07, 0x80, 0xC0, 0xF0, 0x57, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x74, 0x0A, 0xFF,
  0xFF, 0xC0, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x40, 0xDF, 0xFF, 0xD0, 0xC0, 0x27,
  0x74, 0x06, 0x0D, 0xFF, 0xF9, 0x0C, 0x05, 0x77, 0x71, 0x81, 0x4A, 0xEF, 0xFA, 0x81, 0xD9, 0x37,
  0x77, 0x68, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77, 0x10,
  // "Ú" (U+00DA)
  0x77, 0x74, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0xF0, 0x47, 0x77, 0x72, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x57, 0x77, 0x72,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x73, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x74, 0x0C, 0xFB, 0x0D, 0x02, 0x77,
  0x77, 0x40, 0x7F, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x10,
  0xDF, 0xA0, 0xA7, 0x77, 0x76, 0x0A, 0xFA, 0x08, 0x77, 0x77, 0x70, 0xEF, 0x0E, 0x05, 0x80, 0xCC,
  0x30, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F, 0xD0, 0x0E, 0xFD,
  0x03, 0x77, 0x40, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x0D, 0x0C, 0xFD, 0x07,
  0x77, 0x40, 0x7F, 0xD0, 0xC0, 0xAF, 0xD0, 0xA7, 0x74, 0x0A, 0xFD, 0x0A, 0x08, 0xFD, 0x0E, 0x77,
  0x40, 0xEF, 0xD0, 0x80, 0x5F, 0xE0, 0x37, 0x72, 0x03, 0xFE, 0x05, 0x02, 0xFE, 0x0A, 0x77, 0x20,
  0xAF, 0xE8, 0x11, 0x0E, 0xFE, 0x04, 0x77, 0x03, 0xFE, 0x0D, 0x20, 0x9F, 0xE0, 0xE0, 0x37, 0x50,
  0x20, 0xEF, 0xE0, 0x82, 0x04, 0xFF, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xFF, 0x02, 0x30, 0xDF, 0xF9,
  0x82, 0xD8, 0x31, 0x28, 0x21, 0x37, 0xCF, 0xF9, 0x0B, 0x40, 0x68, 0x0C, 0x4F, 0x03, 0x50, 0xD8,
  0x0C, 0x2F, 0x0A, 0x60, 0x38, 0x0C, 0x1F, 0x0E, 0x01, 0x70, 0x78, 0x0C, 0x0F, 0x05, 0x72, 0x0A,
  0xFF, 0xFF, 0xE0, 0x77, 0x40, 0xAF, 0xFF, 0xFC, 0x07, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71,
  0x04, 0x0D, 0xFF, 0xFD, 0x0C, 0x02, 0x77, 0x40, 0x60, 0xDF, 0xFF, 0x90, 0xC0, 0x57, 0x77, 0x18,
  0x14, 0xAE, 0xFF, 0xA8, 0x1D, 0x93, 0x77, 0x76, 0x85, 0x36, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA,
  0x85, 0x27, 0x71,
  // "Û" (U+00DB)
  0x77, 0x20, 0x38, 0x09, 0x17, 0x77, 0x77, 0x40, 0xDF, 0xE0, 0x87, 0x77, 0x72, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x70, 0x2F, 0xFA, 0x0C, 0x77, 0x77, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xFD,
  0x03, 0x77, 0x73, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x20, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x10, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x60, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03,
  0x77, 0x40, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0x3F, 0xA0, 0xE0, 0x37,
  0x09, 0xFA, 0x0C, 0x77, 0x10, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x70, 0xDF,
  0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x50, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80,
  0xCA, 0x60, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F, 0xD0, 0x0E,
  0xFD, 0x03, 0x77, 0x40, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x0D, 0x0C, 0xFD,
  0x07, 0x77, 0x40, 0x7F, 0xD0, 0xC0, 0xAF, 0xD0, 0xA7, 0x74, 0x0A, 0xFD, 0x0A, 0x08, 0xFD, 0x0E,
  0x77, 0x40, 0xEF, 0xD0, 0x80, 0x5F, 0xE0, 0x37, 0x72, 0x03, 0xFE, 0x05, 0x02, 0xFE, 0x0A, 0x77,
  0x20, 0xAF, 0xE8, 0x11, 0x0E, 0xFE, 0x04, 0x77, 0x03, 0xFE, 0x0D, 0x20, 0x9F, 0xE0, 0xE0, 0x37,
  0x50, 0x20, 0xEF, 0xE0, 0x82, 0x04, 0xFF, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xFF, 0x02, 0x30, 0xDF,
  0xF9, 0x82, 0xD8, 0x31, 0x28, 0x21, 0x37, 0xCF, 0xF9, 0x0B, 0x40, 0x68, 0x0C, 0x4F, 0x03, 0x50,
  0xD8, 0x0C, 0x2F, 0x0A, 0x60, 0x38, 0x0C, 0x1F, 0x0E, 0x01, 0x70, 0x78, 0x0C, 0x0F, 0x05, 0x72,
  0x0A, 0xFF, 0xFF, 0xE0, 0x77, 0x40, 0xAF, 0xFF, 0xFC, 0x07, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67,
  0x71, 0x04, 0x0D, 0xFF, 0xFD, 0x0C, 0x02, 0x77, 0x40, 0x60, 0xDF, 0xFF, 0x90, 0xC0, 0x57, 0x77,
  0x18, 0x14, 0xAE, 0xFF, 0xA8, 0x1D, 0x93, 0x77, 0x76, 0x85, 0x36, 0x9B, 0xDE, 0xEA, 0x85, 0xEE,
  0xCA, 0x85, 0x27, 0x71,
  // "Ü" (U+00DC)
  0x72, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x10, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x70, 0xBF, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xB0, 0x37,
  0x50, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x50, 0x8F, 0xC0, 0xE7, 0x10, 0x8F, 0xD7, 0x50,
  0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x74, 0x0B, 0xFD, 0x03, 0x70, 0xBF, 0xD0, 0x47, 0x40, 0xAF,
  0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x74, 0x07, 0xFC, 0x0E, 0x71, 0x07, 0xFD, 0x75, 0x02, 0xFC, 0x09,
  0x71, 0x02, 0xFC, 0x0A, 0x76, 0x0A, 0xFA, 0x0E, 0x01, 0x72, 0x09, 0xFA, 0x0E, 0x02, 0x77, 0x0A,
  0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x28, 0x54, 0xAE, 0xFE, 0xB6, 0x77, 0x85, 0x4A,
  0xDF, 0xEC, 0x78, 0x0C, 0xB1, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x27, 0x74,
  0x02, 0xFD, 0x00, 0xEF, 0xD0, 0x37, 0x74, 0x03, 0xFD, 0x0E, 0x0D, 0xFD, 0x05, 0x77, 0x40, 0x5F,
  0xD0, 0xD0, 0xCF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0C, 0x0A, 0xFD, 0x0A, 0x77, 0x40, 0xAF, 0xD0,
  0xA0, 0x8F, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x05, 0xFE, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x50,
  0x2F, 0xE0, 0xA7, 0x72, 0x0A, 0xFE, 0x81, 0x10, 0xEF, 0xE0, 0x47, 0x70, 0x3F, 0xE0, 0xD2, 0x09,
  0xFE, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFE, 0x08, 0x20, 0x4F, 0xF0, 0xE0, 0x67, 0x30, 0x50, 0xEF,
  0xF0, 0x23, 0x0D, 0xFF, 0x98, 0x2D, 0x83, 0x12, 0x82, 0x13, 0x7C, 0xFF, 0x90, 0xB4, 0x06, 0x80,
  0xC4, 0xF0, 0x35, 0x0D, 0x80, 0xC2, 0xF0, 0xA6, 0x03, 0x80, 0xC1, 0xF0, 0xE0, 0x17, 0x07, 0x80,
  0xC0, 0xF0, 0x57, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0x77, 0x60, 0x8F,
  0xFF, 0xFA, 0x06, 0x77, 0x10, 0x40, 0xDF, 0xFF, 0xD0, 0xC0, 0x27, 0x74, 0x06, 0x0D, 0xFF, 0xF9,
  0x0C, 0x05, 0x77, 0x71, 0x81, 0x4A, 0xEF, 0xFA, 0x81, 0xD9, 0x37, 0x77, 0x68, 0x53, 0x69, 0xBD,
  0xEE, 0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77, 0x10,
  // "Ý" (U+00DD)
  0x77, 0x76, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x76, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x50,
  0x3F, 0xF0, 0x47, 0x77, 0x76, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x60, 0x6F, 0xE0, 0x57, 0x77, 0x76,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x70, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x77, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x70, 0x20, 0xEF, 0xB0, 0xE0, 0x28, 0x0C, 0x00, 0x0C, 0xFB, 0x0D, 0x02, 0x80,
  0xC0, 0x00, 0x7F, 0xB0, 0xD0, 0x18, 0x0C, 0x00, 0x03, 0xFB, 0x0B, 0x01, 0x80, 0xC0, 0x00, 0x10,
  0xDF, 0xA0, 0xA8, 0x0C, 0x20, 0x0A, 0xFA, 0x08, 0x80, 0xC3, 0x00, 0xEF, 0x0E, 0x05, 0x80, 0xCF,
  0x50, 0x0E, 0xFD, 0x0B, 0x77, 0x71, 0x0A, 0xFD, 0x0E, 0x07, 0xFE, 0x02, 0x77, 0x60, 0x1F, 0xE8,
  0x17, 0x1E, 0xFD, 0x09, 0x77, 0x60, 0x8F, 0xD8, 0x2E, 0x10, 0x8F, 0xD0, 0xE0, 0x17, 0x75, 0x0E,
  0xFD, 0x08, 0x20, 0x1F, 0xE0, 0x67, 0x74, 0x05, 0xFE, 0x01, 0x30, 0x9F, 0xD0, 0xD7, 0x74, 0x0B,
  0xFD, 0x09, 0x40, 0x2F, 0xE0, 0x47, 0x72, 0x02, 0xFE, 0x02, 0x50, 0xAF, 0xD0, 0xA7, 0x72, 0x09,
  0xFD, 0x0A, 0x60, 0x2F, 0xE0, 0x17, 0x71, 0x0E, 0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x87, 0x70, 0x6F,
  0xD0, 0xB7, 0x10, 0x3F, 0xD0, 0xE7, 0x70, 0xCF, 0xD0, 0x37, 0x20, 0xBF, 0xD0, 0x57, 0x50, 0x3F,
  0xD0, 0xB7, 0x30, 0x4F, 0xD0, 0xC7, 0x50, 0xAF, 0xD0, 0x47, 0x40, 0xCF, 0xD0, 0x37, 0x30, 0x1F,
  0xD0, 0xC7, 0x50, 0x5F, 0xD0, 0x97, 0x30, 0x7F, 0xD0, 0x57, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x20,
  0xDF, 0xC0, 0xD7, 0x70, 0x5F, 0xD0, 0x77, 0x10, 0x4F, 0xD0, 0x67, 0x71, 0x0D, 0xFC, 0x0D, 0x71,
  0x0B, 0xFC, 0x0E, 0x77, 0x20, 0x6F, 0xD0, 0x46, 0x02, 0xFD, 0x07, 0x77, 0x30, 0xEF, 0xC0, 0xA6,
  0x08, 0xFC, 0x0E, 0x77, 0x40, 0x7F, 0xD0, 0x25, 0x0E, 0xFC, 0x07, 0x77, 0x50, 0xEF, 0xC0, 0x84,
  0x05, 0xFC, 0x0E, 0x01, 0x77, 0x50, 0x8F, 0xC0, 0xE4, 0x0C, 0xFC, 0x08, 0x77, 0x60, 0x10, 0xEF,
  0xC0, 0x52, 0x03, 0xFD, 0x01, 0x77, 0x70, 0x9F, 0xC0, 0xC2, 0x09, 0xFC, 0x09, 0x77, 0x71, 0x01,
  0xFD, 0x81, 0x31, 0xEF, 0xC0, 0x27, 0x77, 0x20, 0x9F, 0xC0, 0x90, 0x7F, 0xC0, 0xA7, 0x77, 0x30,
  0x2F, 0xD0, 0xDF, 0xC0, 0x37, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0xB7, 0x77, 0x50, 0x3F, 0xFF, 0x90,
  0x47, 0x77, 0x60, 0xBF, 0xFE, 0x0C, 0x77, 0x77, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x71, 0x0C, 0xFF,
  0xC0, 0xD7, 0x77, 0x72, 0x04, 0xFF, 0xC0, 0x57, 0x77, 0x73, 0x0C, 0xFF, 0xA0, 0xD7, 0x77, 0x74,
  0x05, 0xFF, 0xA0, 0x67, 0x77, 0x75, 0x0D, 0xFF, 0x0E, 0x77, 0x77, 0x60, 0x6F, 0xF0, 0x77, 0x77,
  0x77, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x07, 0xFD, 0x08,
  0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0,
  0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD,
  0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F,
  0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00,
  0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0,
  0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x87, 0x74,
  // "Þ" (U+00DE)
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77,
  0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xFF, 0x98,
  0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x0C, 0xFF, 0xFF, 0x98, 0x1D, 0x93, 0x74, 0x0C, 0xFF, 0xFF, 0xC0,
  0xC0, 0x57, 0x20, 0xCF, 0xFF, 0xFE, 0x0C, 0x02, 0x70, 0xCF, 0xFF, 0xFF, 0x0E, 0x05, 0x60, 0xC8,
  0x0C, 0x1F, 0x06, 0x50, 0xC8, 0x0C, 0x2F, 0x05, 0x40, 0xC8, 0x0C, 0x2F, 0x0E, 0x02, 0x30, 0xC8,
  0x0C, 0x3F, 0x0B, 0x30, 0xC8, 0x0C, 0x4F, 0x04, 0x20, 0xCF, 0xC0, 0xE8, 0x05, 0x88, 0x19, 0xBE,
  0xFF, 0xA0, 0xB2, 0x0C, 0xFC, 0x0C, 0x75, 0x03, 0x0A, 0xFF, 0x98, 0x12, 0x0C, 0xFC, 0x0C, 0x77,
  0x05, 0xFF, 0x81, 0x70, 0xCF, 0xC0, 0xC7, 0x71, 0x05, 0xFE, 0x81, 0xB0, 0xCF, 0xC0, 0xC7, 0x72,
  0x0B, 0xFD, 0x81, 0xE0, 0xCF, 0xC0, 0xC7, 0x72, 0x04, 0xFE, 0x01, 0x0C, 0xFC, 0x0C, 0x77, 0x3F,
  0xE0, 0x30, 0xCF, 0xC0, 0xC7, 0x73, 0x0C, 0xFD, 0x05, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0xAF, 0xD0,
  0x50, 0xCF, 0xC0, 0xC7, 0x73, 0x09, 0xFD, 0x06, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0x9F, 0xD0, 0x50,
  0xCF, 0xC0, 0xC7, 0x73, 0x0A, 0xFD, 0x04, 0x0C, 0xFC, 0x0C, 0x77, 0x30, 0xCF, 0xD0, 0x30, 0xCF,
  0xC0, 0xC7, 0x73, 0xFE, 0x01, 0x0C, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xD8, 0x1E, 0x0C, 0xFC, 0x0C,
  0x77, 0x20, 0xDF, 0xD8, 0x1C, 0x0C, 0xFC, 0x0C, 0x77, 0x10, 0x8F, 0xE8, 0x18, 0x0C, 0xFC, 0x0C,
  0x77, 0x07, 0xFF, 0x81, 0x40, 0xCF, 0xC0, 0xC7, 0x50, 0x20, 0xBF, 0xF0, 0xE2, 0x0C, 0xFC, 0x0C,
  0x78, 0x31, 0x24, 0x7B, 0xFF, 0xA0, 0x82, 0x0C, 0x80, 0xC4, 0xF0, 0x12, 0x0C, 0x80, 0xC3, 0xF0,
  0x83, 0x0C, 0x80, 0xC2, 0xF0, 0xD4, 0x0C, 0x80, 0xC1, 0xF0, 0xE0, 0x34, 0x0C, 0x80, 0xC1, 0xF0,
  0x55, 0x0C, 0xFF, 0xFF, 0xF0, 0xE0, 0x46, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x27, 0x0C, 0xFF, 0xFF,
  0xC0, 0xE0, 0x77, 0x20, 0xCF, 0xFF, 0xFA, 0x81, 0xD7, 0x17, 0x30, 0xCF, 0xFF, 0xD8, 0x2E, 0xB7,
  0x37, 0x60, 0xCF, 0xC0, 0xE8, 0x04, 0x88, 0x47, 0x76, 0x53, 0x17, 0x73, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7,
  0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0,
  0xC7, 0x77, 0x73, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0xC0, 0xC7, 0x77, 0x73,
  // "ß" (U+00DF)
  0x77, 0x28, 0x91, 0x35, 0x67, 0x77, 0x76, 0x53, 0x17, 0x77, 0x74, 0x81, 0x59, 0xDF, 0xD8, 0x2D,
  0xA6, 0x17, 0x77, 0x48, 0x12, 0x9E, 0xFF, 0xD0, 0xB0, 0x57, 0x77, 0x01, 0x09, 0xFF, 0xFB, 0x0D,
  0x04, 0x77, 0x40, 0x50, 0xEF, 0xFF, 0xE0, 0xA7, 0x72, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x17, 0x60,
  0x8F, 0xFF, 0xFC, 0x0D, 0x01, 0x74, 0x06, 0xFF, 0xFF, 0xE0, 0xC7, 0x30, 0x28, 0x0C, 0x0F, 0x07,
  0x72, 0x0B, 0x80, 0xC0, 0xF0, 0xE7, 0x10, 0x48, 0x0C, 0x2F, 0x06, 0x70, 0xAF, 0xF9, 0x81, 0x95,
  0x22, 0x82, 0x13, 0x7C, 0xFF, 0x0B, 0x60, 0x1F, 0xF0, 0xB0, 0x17, 0x20, 0x6F, 0xE0, 0xE6, 0x05,
  0xFE, 0x0B, 0x75, 0x05, 0xFE, 0x02, 0x50, 0x8F, 0xD0, 0xE0, 0x17, 0x60, 0xDF, 0xD0, 0x35, 0x0B,
  0xFD, 0x07, 0x77, 0x08, 0xFD, 0x03, 0x50, 0xDF, 0xD0, 0x27, 0x70, 0x7F, 0xD0, 0x35, 0xFD, 0x0E,
  0x77, 0x10, 0x7F, 0xD0, 0x15, 0xFD, 0x0B, 0x77, 0x10, 0xAF, 0xC0, 0xE6, 0xFD, 0x0A, 0x77, 0x10,
  0xEF, 0xC0, 0xA6, 0xFD, 0x09, 0x77, 0x08, 0xFD, 0x04, 0x6F, 0xD0, 0x97, 0x60, 0x5F, 0xD0, 0xC7,
  0xFD, 0x09, 0x75, 0x04, 0xFE, 0x03, 0x7F, 0xD0, 0x97, 0x40, 0x5F, 0xE0, 0x77, 0x1F, 0xD0, 0x97,
  0x30, 0x6F, 0xE0, 0xA7, 0x2F, 0xD0, 0x97, 0x20, 0x8F, 0xE0, 0xB7, 0x3F, 0xD0, 0x97, 0x10, 0x8F,
  0xE0, 0xB7, 0x4F, 0xD0, 0x97, 0x06, 0xFE, 0x09, 0x75, 0xFD, 0x09, 0x60, 0x2F, 0xE0, 0x87, 0x6F,
  0xD0, 0x96, 0x0B, 0xFD, 0x07, 0x77, 0xFD, 0x09, 0x50, 0x3F, 0xD0, 0x87, 0x71, 0xFD, 0x09, 0x50,
  0x8F, 0xC0, 0xE7, 0x72, 0xFD, 0x09, 0x50, 0xBF, 0xC0, 0xA7, 0x72, 0xFD, 0x09, 0x50, 0xCF, 0xC0,
  0xB7, 0x72, 0xFD, 0x09, 0x50, 0xDF, 0xD0, 0x17, 0x71, 0xFD, 0x09, 0x50, 0xCF, 0xD0, 0xB7, 0x71,
  0xFD, 0x09, 0x50, 0xAF, 0xE0, 0xB0, 0x17, 0x6F, 0xD0, 0x95, 0x06, 0xFF, 0x0E, 0x04, 0x75, 0xFD,
  0x09, 0x50, 0x1F, 0xFA, 0x08, 0x74, 0xFD, 0x09, 0x60, 0x8F, 0xFA, 0x0B, 0x01, 0x72, 0xFD, 0x09,
  0x70, 0xDF, 0xFA, 0x0E, 0x04, 0x71, 0xFD, 0x09, 0x70, 0x3F, 0xFC, 0x07, 0x7F, 0xD0, 0x97, 0x10,
  0x4F, 0xFC, 0x09, 0x6F, 0xD0, 0x97, 0x20, 0x40, 0xEF, 0xFB, 0x0A, 0x5F, 0xD0, 0x97, 0x30, 0x30,
  0xDF, 0xFB, 0x09, 0x4F, 0xD0, 0x97, 0x40, 0x10, 0xBF, 0xFB, 0x07, 0x3F, 0xD0, 0x97, 0x60, 0x7F,
  0xFB, 0x03, 0x2F, 0xD0, 0x97, 0x70, 0x20, 0xCF, 0xF9, 0x0C, 0x2F, 0xD0, 0x97, 0x72, 0x09, 0xFF,
  0x90, 0x41, 0xFD, 0x09, 0x77, 0x30, 0x5F, 0xF0, 0xA1, 0xFD, 0x09, 0x77, 0x40, 0x30, 0xEF, 0xD0,
  0xE1, 0xFD, 0x09, 0x77, 0x50, 0x5F, 0xE0, 0x1F, 0xD0, 0x97, 0x76, 0x0C, 0xFD, 0x04, 0xFD, 0x09,
  0x77, 0x60, 0x8F, 0xD0, 0x4F, 0xD0, 0x97, 0x76, 0x07, 0xFD, 0x05, 0xFD, 0x09, 0x77, 0x60, 0x9F,
  0xD0, 0x5F, 0xD0, 0x93, 0x81, 0x1B, 0x27, 0x70, 0xDF, 0xD0, 0x4F, 0xD0, 0x93, 0x01, 0xA0, 0x90,
  0x27, 0x40, 0x6F, 0xE0, 0x3F, 0xD0, 0x93, 0x01, 0xC8, 0x1B, 0x61, 0x70, 0x7F, 0xF1, 0xFD, 0x09,
  0x30, 0x1F, 0x85, 0xDA, 0x98, 0x9B, 0xEF, 0xF0, 0xC1, 0xFD, 0x09, 0x30, 0x1F, 0xFF, 0xF0, 0x81,
  0xFD, 0x09, 0x30, 0x1F, 0xFF, 0xF0, 0x21, 0xFD, 0x09, 0x30, 0x1F, 0xFF, 0xE0, 0xA2, 0xFD, 0x09,
  0x30, 0x1F, 0xFF, 0xD0, 0xE0, 0x22, 0xFD, 0x09, 0x30, 0x1F, 0xFF, 0xD0, 0x53, 0xFD, 0x09, 0x30,
  0x1F, 0xFF, 0xC0, 0x74, 0xFD, 0x09, 0x30, 0x1F, 0xFF, 0xA0, 0xE0, 0x55, 0xFD, 0x09, 0x40, 0x70,
  0xEF, 0xFE, 0x0A, 0x02, 0x6F, 0xD0, 0x96, 0x06, 0x0C, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x77, 0x18,
  0x51, 0x58, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x97, 0x37, 0x40,
  // "à" (U+00E0)
  0x72, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x20, 0xBF,
  0xE0, 0x97, 0x77, 0x73, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x20, 0x10, 0xCF, 0xD0, 0xD7, 0x77, 0x74,
  0x0C, 0xFD, 0x08, 0x77, 0x77, 0x40, 0xBF, 0xD0, 0x37, 0x77, 0x74, 0x0B, 0xFC, 0x0D, 0x77, 0x77,
  0x50, 0xAF, 0xC0, 0x87, 0x77, 0x75, 0x09, 0xFC, 0x03, 0x77, 0x77, 0x50, 0x8F, 0xB0, 0xD7, 0x77,
  0x76, 0x06, 0xFB, 0x0A, 0x77, 0x77, 0x60, 0x5F, 0xB0, 0x57, 0x77, 0x76, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x60, 0x10, 0xCF, 0x90, 0x58, 0x0B, 0xE6, 0x08, 0x61, 0x47, 0x9B, 0xCD, 0xEB,
  0x85, 0xED, 0xCA, 0x86, 0x27, 0x77, 0x28, 0x21, 0x59, 0xDF, 0xFC, 0x81, 0xEA, 0x57, 0x74, 0x05,
  0x0B, 0xFF, 0xFC, 0x0E, 0x07, 0x76, 0x81, 0x18, 0xEF, 0xFF, 0xF9, 0x0E, 0x05, 0x73, 0x04, 0xFF,
  0xFF, 0xE0, 0xA7, 0x20, 0x10, 0xEF, 0xFF, 0xFE, 0x0C, 0x72, 0x08, 0xFF, 0xFF, 0xF0, 0xB7, 0x10,
  0x18, 0x0C, 0x0F, 0x08, 0x71, 0x0A, 0x80, 0xC0, 0xF0, 0x27, 0x02, 0x80, 0xC0, 0xF0, 0xA7, 0x10,
  0xBF, 0xB8, 0x7E, 0xBA, 0x98, 0x89, 0xAD, 0xFF, 0xB0, 0x17, 0x04, 0xE8, 0x2B, 0x74, 0x17, 0x28,
  0x11, 0x6D, 0xFF, 0x05, 0x71, 0x83, 0xCF, 0xEA, 0x47, 0x73, 0x08, 0xFE, 0x09, 0x71, 0x03, 0x05,
  0x77, 0x70, 0x9F, 0xD0, 0xD7, 0x77, 0x74, 0x0E, 0xFD, 0x77, 0x77, 0x40, 0x9F, 0xD0, 0x17, 0x77,
  0x73, 0x05, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x77,
  0x77, 0x30, 0x4F, 0xD0, 0x27, 0x58, 0x61, 0x57, 0xAC, 0xDE, 0xEF, 0xFF, 0xB0, 0x27, 0x28, 0x12,
  0x8D, 0xFF, 0xFF, 0xC0, 0x27, 0x04, 0x0B, 0xFF, 0xFF, 0xF0, 0x25, 0x01, 0x0A, 0x80, 0xC1, 0xF0,
  0x24, 0x03, 0x0D, 0x80, 0xC2, 0xF0, 0x23, 0x02, 0x0E, 0x80, 0xC3, 0xF0, 0x23, 0x0D, 0x80, 0xC4,
  0xF0, 0x22, 0x08, 0x80, 0xC5, 0xF8, 0x12, 0x01, 0xFF, 0x98, 0x4E, 0xA6, 0x42, 0x17, 0x10, 0x4F,
  0xD8, 0x12, 0x07, 0xFE, 0x0E, 0x06, 0x77, 0x04, 0xFD, 0x81, 0x20, 0xCF, 0xD0, 0xD0, 0x27, 0x71,
  0x04, 0xFD, 0x02, 0x1F, 0xD0, 0xE0, 0x27, 0x72, 0x04, 0xFD, 0x02, 0x03, 0xFD, 0x09, 0x77, 0x30,
  0x5F, 0xD0, 0x20, 0x5F, 0xD0, 0x57, 0x73, 0x07, 0xFD, 0x02, 0x06, 0xFD, 0x03, 0x77, 0x30, 0xBF,
  0xD0, 0x20, 0x7F, 0xD0, 0x37, 0x72, 0x03, 0xFE, 0x02, 0x07, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xE0,
  0x20, 0x5F, 0xD0, 0xC7, 0x70, 0x10, 0xBF, 0xF0, 0x20, 0x4F, 0xE0, 0x87, 0x50, 0x40, 0xDF, 0xF9,
  0x00, 0x2F, 0xF0, 0xC0, 0x47, 0x10, 0x50, 0xBF, 0xFB, 0x81, 0x20, 0xEF, 0xF9, 0x85, 0xEB, 0x98,
  0x9A, 0xCF, 0xFE, 0x81, 0x20, 0xA8, 0x0C, 0x6F, 0x81, 0x20, 0x58, 0x0C, 0x6F, 0x02, 0x20, 0xDF,
  0xFF, 0xF0, 0x0E, 0xFC, 0x02, 0x20, 0x5F, 0xFF, 0xE8, 0x1E, 0x28, 0xFC, 0x02, 0x30, 0xAF, 0xFF,
  0xC8, 0x2E, 0x30, 0x3F, 0xC0, 0x24, 0x0D, 0xFF, 0xFA, 0x0D, 0x02, 0x30, 0xDF, 0xB0, 0x24, 0x01,
  0x0D, 0xFF, 0xF0, 0xA0, 0x14, 0x08, 0xFB, 0x02, 0x60, 0x9F, 0xFC, 0x0D, 0x04, 0x60, 0x3F, 0xB0,
  0x27, 0x03, 0x0A, 0xFF, 0x0B, 0x05, 0x72, 0x0E, 0xFA, 0x02, 0x73, 0x83, 0x58, 0xBD, 0xEA, 0x84,
  0xED, 0xB8, 0x51, 0x77, 0x71,
  // "á" (U+00E1)
  0x77, 0x75, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x03,
  0xFF, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xFE, 0x05, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xD0, 0x57, 0x77, 0x72, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x20, 0x6F, 0xC0, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x73, 0x01, 0x0D,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0xAF, 0xA0, 0x87, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x58, 0x0B, 0xF3,
  0x08, 0x61, 0x47, 0x9B, 0xCD, 0xEB, 0x85, 0xED, 0xCA, 0x86, 0x27, 0x77, 0x28, 0x21, 0x59, 0xDF,
  0xFC, 0x81, 0xEA, 0x57, 0x74, 0x05, 0x0B, 0xFF, 0xFC, 0x0E, 0x07, 0x76, 0x81, 0x18, 0xEF, 0xFF,
  0xF9, 0x0E, 0x05, 0x73, 0x04, 0xFF, 0xFF, 0xE0, 0xA7, 0x20, 0x10, 0xEF, 0xFF, 0xFE, 0x0C, 0x72,
  0x08, 0xFF, 0xFF, 0xF0, 0xB7, 0x10, 0x18, 0x0C, 0x0F, 0x08, 0x71, 0x0A, 0x80, 0xC0, 0xF0, 0x27,
  0x02, 0x80, 0xC0, 0xF0, 0xA7, 0x10, 0xBF, 0xB8, 0x7E, 0xBA, 0x98, 0x89, 0xAD, 0xFF, 0xB0, 0x17,
  0x04, 0xE8, 0x2B, 0x74, 0x17, 0x28, 0x11, 0x6D, 0xFF, 0x05, 0x71, 0x83, 0xCF, 0xEA, 0x47, 0x73,
  0x08, 0xFE, 0x09, 0x71, 0x03, 0x05, 0x77, 0x70, 0x9F, 0xD0, 0xD7, 0x77, 0x74, 0x0E, 0xFD, 0x77,
  0x77, 0x40, 0x9F, 0xD0, 0x17, 0x77, 0x73, 0x05, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27,
  0x77, 0x73, 0x04, 0xFD, 0x02, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x58, 0x61, 0x57, 0xAC, 0xDE,
  0xEF, 0xFF, 0xB0, 0x27, 0x28, 0x12, 0x8D, 0xFF, 0xFF, 0xC0, 0x27, 0x04, 0x0B, 0xFF, 0xFF, 0xF0,
  0x25, 0x01, 0x0A, 0x80, 0xC1, 0xF0, 0x24, 0x03, 0x0D, 0x80, 0xC2, 0xF0, 0x23, 0x02, 0x0E, 0x80,
  0xC3, 0xF0, 0x23, 0x0D, 0x80, 0xC4, 0xF0, 0x22, 0x08, 0x80, 0xC5, 0xF8, 0x12, 0x01, 0xFF, 0x98,
  0x4E, 0xA6, 0x42, 0x17, 0x10, 0x4F, 0xD8, 0x12, 0x07, 0xFE, 0x0E, 0x06, 0x77, 0x04, 0xFD, 0x81,
  0x20, 0xCF, 0xD0, 0xD0, 0x27, 0x71, 0x04, 0xFD, 0x02, 0x1F, 0xD0, 0xE0, 0x27, 0x72, 0x04, 0xFD,
  0x02, 0x03, 0xFD, 0x09, 0x77, 0x30, 0x5F, 0xD0, 0x20, 0x5F, 0xD0, 0x57, 0x73, 0x07, 0xFD, 0x02,
  0x06, 0xFD, 0x03, 0x77, 0x30, 0xBF, 0xD0, 0x20, 0x7F, 0xD0, 0x37, 0x72, 0x03, 0xFE, 0x02, 0x07,
  0xFD, 0x06, 0x77, 0x20, 0xCF, 0xE0, 0x20, 0x5F, 0xD0, 0xC7, 0x70, 0x10, 0xBF, 0xF0, 0x20, 0x4F,
  0xE0, 0x87, 0x50, 0x40, 0xDF, 0xF9, 0x00, 0x2F, 0xF0, 0xC0, 0x47, 0x10, 0x50, 0xBF, 0xFB, 0x81,
  0x20, 0xEF, 0xF9, 0x85, 0xEB, 0x98, 0x9A, 0xCF, 0xFE, 0x81, 0x20, 0xA8, 0x0C, 0x6F, 0x81, 0x20,
  0x58, 0x0C, 0x6F, 0x02, 0x20, 0xDF, 0xFF, 0xF0, 0x0E, 0xFC, 0x02, 0x20, 0x5F, 0xFF, 0xE8, 0x1E,
  0x28, 0xFC, 0x02, 0x30, 0xAF, 0xFF, 0xC8, 0x2E, 0x30, 0x3F, 0xC0, 0x24, 0x0D, 0xFF, 0xFA, 0x0D,
  0x02, 0x30, 0xDF, 0xB0, 0x24, 0x01, 0x0D, 0xFF, 0xF0, 0xA0, 0x14, 0x08, 0xFB, 0x02, 0x60, 0x9F,
  0xFC, 0x0D, 0x04, 0x60, 0x3F, 0xB0, 0x27, 0x03, 0x0A, 0xFF, 0x0B, 0x05, 0x72, 0x0E, 0xFA, 0x02,
  0x73, 0x83, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x71,
  // "â" (U+00E2)
  0x77, 0x30, 0x38, 0x09, 0x17, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x87, 0x77, 0x71, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x60, 0x2F, 0xFA, 0x0C, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x40, 0x8F, 0xFD,
  0x03, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x75, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37,
  0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x71, 0x03, 0xFA, 0x0E, 0x03, 0x70,
  0x9F, 0xA0, 0xC7, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x60, 0xDF, 0x90,
  0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x40, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xBD,
  0x60, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72, 0x82, 0x15, 0x9D,
  0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFF,
  0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xC7,
  0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8, 0x0C, 0x0F, 0x02,
  0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A, 0xDF, 0xFB, 0x01,
  0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C, 0xFE, 0xA4, 0x77,
  0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0xD7,
  0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73, 0x04, 0xFD, 0x02,
  0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86, 0x15, 0x7A, 0xCD,
  0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40, 0xBF, 0xFF, 0xFF,
  0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02, 0x30, 0x20, 0xE8,
  0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81, 0x20, 0x1F, 0xF9,
  0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67, 0x70, 0x4F, 0xD8,
  0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02, 0x77, 0x20, 0x4F,
  0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77, 0x30, 0x7F, 0xD0,
  0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x20,
  0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B, 0xFF, 0x02, 0x04,
  0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05, 0x0B, 0xFF, 0xB8,
  0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80, 0xC6, 0xF8, 0x12,
  0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05, 0xFF, 0xFE, 0x81,
  0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40, 0xDF, 0xFF, 0xA0,
  0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F, 0xB0, 0x26, 0x09,
  0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57, 0x20, 0xEF, 0xA0,
  0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "ã" (U+00E3)
  0x76, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x10, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x04, 0xFE, 0x0C, 0x06, 0x70, 0x5E, 0x0C, 0x76, 0x01, 0x0E, 0xFF, 0x98,
  0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x60, 0xAF, 0xFF, 0xFA, 0x06, 0x75, 0x03, 0xFF, 0xFF,
  0xB0, 0x27, 0x50, 0xAF, 0xFF, 0xFA, 0x0C, 0x76, 0xFF, 0xFF, 0xB0, 0x57, 0x50, 0x5F, 0xFF, 0xFA,
  0x0C, 0x76, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27, 0x60, 0xCE, 0x04, 0x68,
  0x11, 0x8E, 0xFD, 0x0E, 0x03, 0x77, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27, 0x71,
  0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xBE, 0x40, 0x86, 0x14, 0x79, 0xBC, 0xDE,
  0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72, 0x82, 0x15, 0x9D, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40,
  0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F,
  0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xC7, 0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71,
  0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8, 0x0C, 0x0F, 0x02, 0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71,
  0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A, 0xDF, 0xFB, 0x01, 0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72,
  0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C, 0xFE, 0xA4, 0x77, 0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30,
  0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0xD7, 0x77, 0x74, 0x09, 0xFD, 0x01, 0x77,
  0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27,
  0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86, 0x15, 0x7A, 0xCD, 0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81,
  0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40, 0xBF, 0xFF, 0xFF, 0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F,
  0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02, 0x30, 0x20, 0xE8, 0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C,
  0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81, 0x20, 0x1F, 0xF9, 0x84, 0xEA, 0x64, 0x21, 0x71, 0x04,
  0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67, 0x70, 0x4F, 0xD8, 0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77,
  0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02, 0x77, 0x20, 0x4F, 0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73,
  0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77, 0x30, 0x7F, 0xD0, 0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B,
  0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x20, 0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE,
  0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B, 0xFF, 0x02, 0x04, 0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF,
  0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05, 0x0B, 0xFF, 0xB8, 0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9,
  0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80, 0xC6, 0xF8, 0x12, 0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D,
  0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05, 0xFF, 0xFE, 0x81, 0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF,
  0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40, 0xDF, 0xFF, 0xA0, 0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40,
  0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F, 0xB0, 0x26, 0x09, 0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB,
  0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57, 0x20, 0xEF, 0xA0, 0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8,
  0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "ä" (U+00E4)
  0x73, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x01, 0x0B, 0xF0,
  0xE0, 0x37, 0x40, 0xBF, 0x0E, 0x04, 0x76, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03, 0x74,
  0x03, 0xFC, 0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x74, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD, 0x74, 0x0A,
  0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04, 0x73, 0x0A, 0xFD,
  0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7, 0x40, 0x2F, 0xC0, 0x97,
  0x10, 0x2F, 0xC0, 0xA7, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F, 0xA0, 0xE0, 0x27, 0x60, 0xAF,
  0x0D, 0x03, 0x74, 0x09, 0xF0, 0xD0, 0x37, 0x71, 0x85, 0x4A, 0xEF, 0xEB, 0x67, 0x78, 0x54, 0xAD,
  0xFE, 0xC7, 0x80, 0xBE, 0x10, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77,
  0x72, 0x82, 0x15, 0x9D, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77,
  0x68, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E,
  0xFF, 0xFF, 0xE0, 0xC7, 0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10,
  0xA8, 0x0C, 0x0F, 0x02, 0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88,
  0x9A, 0xDF, 0xFB, 0x01, 0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18,
  0x3C, 0xFE, 0xA4, 0x77, 0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77,
  0x77, 0x40, 0xEF, 0xD7, 0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77,
  0x73, 0x04, 0xFD, 0x02, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75,
  0x86, 0x15, 0x7A, 0xCD, 0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70,
  0x40, 0xBF, 0xFF, 0xFF, 0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F,
  0x02, 0x30, 0x20, 0xE8, 0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F,
  0x81, 0x20, 0x1F, 0xF9, 0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0,
  0x67, 0x70, 0x4F, 0xD8, 0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E,
  0x02, 0x77, 0x20, 0x4F, 0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05,
  0x77, 0x30, 0x7F, 0xD0, 0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77,
  0x20, 0x3F, 0xE0, 0x20, 0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01,
  0x0B, 0xFF, 0x02, 0x04, 0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71,
  0x05, 0x0B, 0xFF, 0xB8, 0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A,
  0x80, 0xC6, 0xF8, 0x12, 0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22,
  0x05, 0xFF, 0xFE, 0x81, 0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02,
  0x40, 0xDF, 0xFF, 0xA0, 0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40,
  0x8F, 0xB0, 0x26, 0x09, 0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0,
  0x57, 0x20, 0xEF, 0xA0, 0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "å" (U+00E5)
  0x77, 0x58, 0x90, 0x48, 0xCD, 0xFE, 0xDA, 0x61, 0x77, 0x77, 0x50, 0x30, 0xCF, 0xB0, 0x90, 0x17,
  0x77, 0x72, 0x07, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x06, 0xFF, 0x90, 0xE0, 0x27, 0x77, 0x50, 0x3F,
  0xFB, 0x0D, 0x01, 0x77, 0x74, 0x0B, 0xFF, 0xC0, 0x87, 0x77, 0x30, 0x2F, 0x0B, 0x03, 0x20, 0x50,
  0xDF, 0x77, 0x73, 0x06, 0xE0, 0xA5, 0x01, 0x0D, 0xE0, 0x47, 0x77, 0x20, 0x9E, 0x01, 0x60, 0x5E,
  0x08, 0x77, 0x72, 0x0B, 0xD0, 0xC7, 0x1E, 0x09, 0x77, 0x72, 0x0C, 0xD0, 0xA7, 0x1E, 0x0A, 0x77,
  0x72, 0x0B, 0xD0, 0xC7, 0x1E, 0x09, 0x77, 0x72, 0x09, 0xE0, 0x16, 0x05, 0xE0, 0x77, 0x77, 0x20,
  0x6E, 0x08, 0x50, 0x10, 0xDE, 0x04, 0x77, 0x72, 0x02, 0xF0, 0x90, 0x32, 0x04, 0x0D, 0xE0, 0xE7,
  0x77, 0x40, 0xAF, 0xFC, 0x07, 0x77, 0x74, 0x02, 0xFF, 0xB0, 0xD7, 0x77, 0x60, 0x6F, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x06, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x20, 0x30, 0xCF, 0xB0, 0x90, 0x17, 0x77,
  0x75, 0x89, 0x03, 0x8C, 0xDF, 0xED, 0xB6, 0x18, 0x0B, 0xF2, 0x08, 0x61, 0x47, 0x9B, 0xCD, 0xEB,
  0x85, 0xED, 0xCA, 0x86, 0x27, 0x77, 0x28, 0x21, 0x59, 0xDF, 0xFC, 0x81, 0xEA, 0x57, 0x74, 0x05,
  0x0B, 0xFF, 0xFC, 0x0E, 0x07, 0x76, 0x81, 0x18, 0xEF, 0xFF, 0xF9, 0x0E, 0x05, 0x73, 0x04, 0xFF,
  0xFF, 0xE0, 0xA7, 0x20, 0x10, 0xEF, 0xFF, 0xFE, 0x0C, 0x72, 0x08, 0xFF, 0xFF, 0xF0, 0xB7, 0x10,
  0x18, 0x0C, 0x0F, 0x08, 0x71, 0x0A, 0x80, 0xC0, 0xF0, 0x27, 0x02, 0x80, 0xC0, 0xF0, 0xA7, 0x10,
  0xBF, 0xB8, 0x7E, 0xBA, 0x98, 0x89, 0xAD, 0xFF, 0xB0, 0x17, 0x04, 0xE8, 0x2B, 0x74, 0x17, 0x28,
  0x11, 0x6D, 0xFF, 0x05, 0x71, 0x83, 0xCF, 0xEA, 0x47, 0x73, 0x08, 0xFE, 0x09, 0x71, 0x03, 0x05,
  0x77, 0x70, 0x9F, 0xD0, 0xD7, 0x77, 0x74, 0x0E, 0xFD, 0x77, 0x77, 0x40, 0x9F, 0xD0, 0x17, 0x77,
  0x73, 0x05, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x77,
  0x77, 0x30, 0x4F, 0xD0, 0x27, 0x58, 0x61, 0x57, 0xAC, 0xDE, 0xEF, 0xFF, 0xB0, 0x27, 0x28, 0x12,
  0x8D, 0xFF, 0xFF, 0xC0, 0x27, 0x04, 0x0B, 0xFF, 0xFF, 0xF0, 0x25, 0x01, 0x0A, 0x80, 0xC1, 0xF0,
  0x24, 0x03, 0x0D, 0x80, 0xC2, 0xF0, 0x23, 0x02, 0x0E, 0x80, 0xC3, 0xF0, 0x23, 0x0D, 0x80, 0xC4,
  0xF0, 0x22, 0x08, 0x80, 0xC5, 0xF8, 0x12, 0x01, 0xFF, 0x98, 0x4E, 0xA6, 0x42, 0x17, 0x10, 0x4F,
  0xD8, 0x12, 0x07, 0xFE, 0x0E, 0x06, 0x77, 0x04, 0xFD, 0x81, 0x20, 0xCF, 0xD0, 0xD0, 0x27, 0x71,
  0x04, 0xFD, 0x02, 0x1F, 0xD0, 0xE0, 0x27, 0x72, 0x04, 0xFD, 0x02, 0x03, 0xFD, 0x09, 0x77, 0x30,
  0x5F, 0xD0, 0x20, 0x5F, 0xD0, 0x57, 0x73, 0x07, 0xFD, 0x02, 0x06, 0xFD, 0x03, 0x77, 0x30, 0xBF,
  0xD0, 0x20, 0x7F, 0xD0, 0x37, 0x72, 0x03, 0xFE, 0x02, 0x07, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xE0,
  0x20, 0x5F, 0xD0, 0xC7, 0x70, 0x10, 0xBF, 0xF0, 0x20, 0x4F, 0xE0, 0x87, 0x50, 0x40, 0xDF, 0xF9,
  0x00, 0x2F, 0xF0, 0xC0, 0x47, 0x10, 0x50, 0xBF, 0xFB, 0x81, 0x20, 0xEF, 0xF9, 0x85, 0xEB, 0x98,
  0x9A, 0xCF, 0xFE, 0x81, 0x20, 0xA8, 0x0C, 0x6F, 0x81, 0x20, 0x58, 0x0C, 0x6F, 0x02, 0x20, 0xDF,
  0xFF, 0xF0, 0x0E, 0xFC, 0x02, 0x20, 0x5F, 0xFF, 0xE8, 0x1E, 0x28, 0xFC, 0x02, 0x30, 0xAF, 0xFF,
  0xC8, 0x2E, 0x30, 0x3F, 0xC0, 0x24, 0x0D, 0xFF, 0xFA, 0x0D, 0x02, 0x30, 0xDF, 0xB0, 0x24, 0x01,
  0x0D, 0xFF, 0xF0, 0xA0, 0x14, 0x08, 0xFB, 0x02, 0x60, 0x9F, 0xFC, 0x0D, 0x04, 0x60, 0x3F, 0xB0,
  0x27, 0x03, 0x0A, 0xFF, 0x0B, 0x05, 0x72, 0x0E, 0xFA, 0x02, 0x73, 0x83, 0x58, 0xBD, 0xEA, 0x84,
  0xED, 0xB8, 0x51, 0x77, 0x71,
  // "æ" (U+00E6)
  0x73, 0x89, 0x23, 0x7A, 0xCD, 0xEF, 0xED, 0xB8, 0x57, 0x48, 0x91, 0x26, 0xAD, 0xEF, 0xED, 0xA6,
  0x17, 0x73, 0x04, 0x0A, 0xFF, 0x09, 0x02, 0x60, 0x40, 0xBF, 0xC0, 0x90, 0x17, 0x60, 0x70, 0xEF,
  0xFC, 0x08, 0x30, 0x10, 0xAF, 0xF0, 0xE0, 0x57, 0x30, 0x40, 0xDF, 0xFF, 0x82, 0xC1, 0x2D, 0xFF,
  0xB0, 0x67, 0x20, 0x4F, 0xFF, 0xA0, 0xD0, 0xEF, 0xFD, 0x05, 0x72, 0x0C, 0x80, 0xC7, 0xF0, 0xE0,
  0x17, 0x10, 0x58, 0x0D, 0x0F, 0x0B, 0x72, 0x0D, 0x80, 0xD0, 0xF0, 0x37, 0x10, 0x68, 0x0D, 0x0F,
  0x0B, 0x72, 0x0E, 0x80, 0xD0, 0xF0, 0x17, 0x10, 0x7D, 0x84, 0xCA, 0x88, 0x9C, 0xFF, 0xC8, 0x1B,
  0x8A, 0xFD, 0x07, 0x71, 0x83, 0x1E, 0xE9, 0x47, 0x01, 0x09, 0xFF, 0x0E, 0x03, 0x30, 0x20, 0xEF,
  0xB0, 0xB7, 0x20, 0x37, 0x50, 0x8F, 0xE0, 0x45, 0x05, 0xFC, 0x77, 0x72, 0x0D, 0xFC, 0x0C, 0x70,
  0xDF, 0xB0, 0x47, 0x77, 0x10, 0x9F, 0xC0, 0x67, 0x07, 0xFB, 0x06, 0x77, 0x71, 0x07, 0xFC, 0x03,
  0x70, 0x4F, 0xB0, 0x97, 0x77, 0x10, 0x6F, 0xC7, 0x10, 0x1F, 0xB0, 0xB7, 0x77, 0x10, 0x6F, 0xB0,
  0xD7, 0x20, 0xEF, 0xA0, 0xD7, 0x77, 0x10, 0x6F, 0xB0, 0xC7, 0x20, 0xDF, 0xA0, 0xE7, 0x77, 0x10,
  0x6F, 0xB0, 0xC7, 0x20, 0xCF, 0xB7, 0x48, 0x44, 0x8B, 0xCD, 0xE8, 0x0C, 0x1F, 0x71, 0x02, 0x09,
  0x80, 0xD0, 0xF0, 0x16, 0x08, 0x80, 0xD2, 0xF0, 0x14, 0x01, 0x0B, 0x80, 0xD3, 0xF0, 0x14, 0x0C,
  0x80, 0xD4, 0xF0, 0x13, 0x09, 0x80, 0xD5, 0xF0, 0x12, 0x03, 0x80, 0xD6, 0xF0, 0x12, 0x0A, 0xFD,
  0x81, 0xB5, 0x13, 0x06, 0xFF, 0xFF, 0xB8, 0x11, 0x01, 0xFD, 0x08, 0x60, 0x6F, 0xB0, 0x87, 0x77,
  0x10, 0x5F, 0xC0, 0xA7, 0x06, 0xFB, 0x09, 0x77, 0x71, 0x09, 0xFC, 0x02, 0x70, 0x6F, 0xB0, 0xA7,
  0x77, 0x10, 0xBF, 0xB0, 0xC7, 0x10, 0x6F, 0xB0, 0xD7, 0x77, 0x10, 0xEF, 0xB0, 0x87, 0x10, 0x7F,
  0xC0, 0x17, 0x77, 0xFC, 0x06, 0x71, 0x08, 0xFC, 0x04, 0x77, 0x7F, 0xC0, 0x57, 0x10, 0xAF, 0xC0,
  0xA7, 0x76, 0x01, 0xFC, 0x05, 0x71, 0x0C, 0xFD, 0x01, 0x77, 0x6F, 0xC0, 0x67, 0x01, 0xFE, 0x09,
  0x77, 0x6F, 0xC0, 0x97, 0x06, 0xFF, 0x04, 0x77, 0x01, 0x40, 0xEF, 0xB0, 0xE7, 0x0C, 0xFF, 0x90,
  0x47, 0x50, 0x30, 0xD4, 0x0D, 0xFC, 0x08, 0x50, 0x7F, 0xFB, 0x08, 0x72, 0x01, 0x09, 0xA4, 0x0A,
  0xFD, 0x83, 0x92, 0x02, 0x9F, 0xFD, 0x87, 0xE8, 0x41, 0x01, 0x25, 0xAC, 0x40, 0x78, 0x0D, 0x5F,
  0x40, 0x38, 0x0D, 0x5F, 0x50, 0xCF, 0xFF, 0x90, 0xD0, 0x8F, 0xFF, 0xB5, 0x07, 0xFF, 0xF9, 0x81,
  0x30, 0xCF, 0xFF, 0xA6, 0x0D, 0xFF, 0xE0, 0x72, 0x01, 0x0D, 0xFF, 0xF9, 0x60, 0x4F, 0xFD, 0x0A,
  0x40, 0x20, 0xDF, 0xFF, 0x70, 0x7F, 0xFB, 0x0A, 0x60, 0x10, 0xCF, 0xFD, 0x0D, 0x71, 0x06, 0xFF,
  0x90, 0x77, 0x20, 0x70, 0xEF, 0xFA, 0x09, 0x01, 0x72, 0x02, 0x0B, 0xFC, 0x0B, 0x03, 0x74, 0x81,
  0x17, 0xEF, 0xD0, 0xA0, 0x37, 0x68, 0x91, 0x27, 0xBD, 0xEF, 0xED, 0xA7, 0x27, 0x72, 0x89, 0x23,
  0x7A, 0xDE, 0xFE, 0xDC, 0x95, 0x17,
  // "ç" (U+00E7)
  0x77, 0x38, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x6E, 0xDD, 0xB9, 0x75, 0x27, 0x76, 0x81, 0x16, 0xBF,
  0xFD, 0x81, 0xB7, 0x37, 0x70, 0x20, 0x9F, 0xFF, 0xC8, 0x1D, 0x71, 0x73, 0x08, 0xFF, 0xFF, 0x90,
  0x97, 0x10, 0x30, 0xDF, 0xFF, 0xFA, 0x03, 0x70, 0x5F, 0xFF, 0xFB, 0x0D, 0x70, 0x5F, 0xFF, 0xFC,
  0x07, 0x60, 0x3F, 0xFF, 0xFD, 0x02, 0x50, 0x10, 0xEF, 0xFF, 0xFC, 0x0B, 0x60, 0xAF, 0xFF, 0xFD,
  0x06, 0x50, 0x4F, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBD, 0xF0, 0xE6, 0x0C, 0xFF, 0x98, 0x1E, 0x72,
  0x71, 0x82, 0x14, 0x8C, 0xB0, 0xA5, 0x04, 0xFF, 0x90, 0x87, 0x71, 0x82, 0x28, 0xE4, 0x50, 0xAF,
  0xF0, 0x67, 0x77, 0x4F, 0xF0, 0x77, 0x77, 0x40, 0x5F, 0xE0, 0xC7, 0x77, 0x50, 0x9F, 0xE0, 0x37,
  0x77, 0x50, 0xDF, 0xD0, 0xD7, 0x77, 0x6F, 0xE0, 0x77, 0x77, 0x50, 0x3F, 0xE0, 0x37, 0x77, 0x50,
  0x5F, 0xE7, 0x77, 0x60, 0x7F, 0xD0, 0xC7, 0x77, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x60, 0x9F, 0xD0,
  0xA7, 0x77, 0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77, 0x60, 0xAF, 0xD0, 0x87,
  0x77, 0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77,
  0x60, 0x7F, 0xD0, 0xE7, 0x77, 0x60, 0x5F, 0xE0, 0x17, 0x77, 0x50, 0x3F, 0xE0, 0x57, 0x77, 0x6F,
  0xE0, 0xA7, 0x77, 0x60, 0xDF, 0xE0, 0x27, 0x77, 0x50, 0x9F, 0xE0, 0xA7, 0x77, 0x50, 0x5F, 0xF0,
  0x57, 0x77, 0x03, 0x02, 0x3F, 0xF9, 0x05, 0x77, 0x48, 0x22, 0xAF, 0x43, 0x0A, 0xFF, 0x90, 0x87,
  0x71, 0x03, 0x0A, 0xB0, 0x43, 0x03, 0xFF, 0xA8, 0x1E, 0x72, 0x71, 0x82, 0x14, 0x8D, 0xD0, 0x44,
  0x0B, 0xFF, 0xC8, 0x6D, 0xB9, 0x88, 0xAB, 0xDF, 0xA0, 0x44, 0x03, 0xFF, 0xFF, 0xF0, 0x45, 0x08,
  0xFF, 0xFF, 0xE0, 0x46, 0x0C, 0xFF, 0xFF, 0xD0, 0x46, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x47, 0x02,
  0x0D, 0xFF, 0xFF, 0xB0, 0x47, 0x10, 0x10, 0xBF, 0xFF, 0xFA, 0x04, 0x73, 0x06, 0x0E, 0xFF, 0xFF,
  0x03, 0x74, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x18, 0x15, 0xAE, 0xFF, 0xB8, 0x1E,
  0xA5, 0x77, 0x78, 0x23, 0x58, 0xAF, 0x98, 0x3C, 0xA8, 0x53, 0x77, 0x77, 0x0B, 0xE0, 0x27, 0x77,
  0x74, 0x02, 0xE0, 0xB7, 0x77, 0x75, 0x09, 0xE0, 0x97, 0x77, 0x74, 0x01, 0x0E, 0xF9, 0x09, 0x02,
  0x77, 0x77, 0x10, 0x7F, 0xB0, 0xE0, 0x67, 0x77, 0x70, 0xDF, 0xD0, 0x87, 0x77, 0x58, 0x21, 0x8A,
  0xDF, 0xC0, 0x67, 0x77, 0x71, 0x02, 0x08, 0xFA, 0x0E, 0x77, 0x77, 0x30, 0x4F, 0xA0, 0x57, 0x77,
  0x73, 0x0B, 0xF9, 0x09, 0x77, 0x77, 0x30, 0x8F, 0x90, 0xB7, 0x77, 0x73, 0x0A, 0xF9, 0x0C, 0x77,
  0x77, 0x20, 0x3F, 0xA0, 0xB7, 0x77, 0x89, 0x01, 0x95, 0x21, 0x01, 0x38, 0xEF, 0xA0, 0x97, 0x77,
  0x01, 0xFF, 0xC0, 0x57, 0x77, 0x01, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x01, 0xFF, 0xB0, 0x77, 0x77,
  0x10, 0x1F, 0xFA, 0x0B, 0x77, 0x72, 0x01, 0xFF, 0x90, 0xA7, 0x77, 0x30, 0x1F, 0xE0, 0xC0, 0x57,
  0x77, 0x58, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x60,
  // "è" (U+00E8)
  0x72, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x73, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x30, 0xBF,
  0xE0, 0x97, 0x77, 0x74, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x30, 0x10, 0xCF, 0xD0, 0xD7, 0x77, 0x75,
  0x0C, 0xFD, 0x08, 0x77, 0x77, 0x50, 0xBF, 0xD0, 0x37, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x77,
  0x60, 0xAF, 0xC0, 0x87, 0x77, 0x76, 0x09, 0xFC, 0x03, 0x77, 0x77, 0x60, 0x8F, 0xB0, 0xD7, 0x77,
  0x77, 0x06, 0xFB, 0x0A, 0x77, 0x77, 0x70, 0x5F, 0xB0, 0x57, 0x77, 0x77, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x70, 0x10, 0xCF, 0x90, 0x58, 0x0B, 0xF7, 0x08, 0x51, 0x57, 0xAC, 0xDE, 0xA8,
  0x4E, 0xDB, 0x96, 0x37, 0x77, 0x78, 0x11, 0x7C, 0xFF, 0x98, 0x1E, 0xA4, 0x77, 0x72, 0x01, 0x08,
  0xFF, 0xF0, 0xC0, 0x47, 0x76, 0x07, 0xFF, 0xFC, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xE0,
  0xE0, 0x47, 0x70, 0x20, 0xDF, 0xFF, 0xFA, 0x05, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xC0, 0x47, 0x30,
  0x10, 0xDF, 0xFF, 0xFD, 0x0E, 0x02, 0x72, 0x0B, 0xFF, 0xFF, 0xF0, 0xC7, 0x10, 0x68, 0x0C, 0x1F,
  0x06, 0x60, 0x10, 0xEF, 0xFA, 0x84, 0xCA, 0x88, 0xAC, 0xFF, 0x90, 0xE6, 0x08, 0xFF, 0x81, 0xD6,
  0x16, 0x81, 0x17, 0xEF, 0xE0, 0x64, 0x01, 0xFF, 0x08, 0x74, 0x01, 0x0B, 0xFD, 0x0C, 0x40, 0x6F,
  0xE0, 0x57, 0x70, 0xAF, 0xD0, 0x23, 0x0C, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xC0, 0x72, 0x02, 0xFD,
  0x0C, 0x77, 0x30, 0x4F, 0xC0, 0xB2, 0x06, 0xFD, 0x05, 0x77, 0x40, 0xDF, 0xB0, 0xE2, 0x0A, 0xFC,
  0x0E, 0x77, 0x50, 0x8F, 0xC8, 0x11, 0x0D, 0xFC, 0x0B, 0x77, 0x50, 0x5F, 0xC0, 0x31, 0xFD, 0x08,
  0x77, 0x50, 0x3F, 0xC0, 0x50, 0x28, 0x0D, 0x0F, 0x06, 0x04, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D,
  0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80,
  0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x3F, 0xD0, 0x37, 0x77,
  0x74, 0x02, 0xFD, 0x05, 0x77, 0x77, 0x50, 0xEF, 0xC0, 0x87, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77,
  0x77, 0x50, 0x8F, 0xD0, 0x47, 0x77, 0x74, 0x04, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x87,
  0x77, 0x74, 0x09, 0xFE, 0x07, 0x77, 0x77, 0x30, 0x2F, 0xF0, 0x97, 0x77, 0x28, 0x11, 0x6C, 0x50,
  0xBF, 0xF0, 0xD0, 0x67, 0x74, 0x81, 0x26, 0xBB, 0x01, 0x40, 0x3F, 0xFA, 0x81, 0xE9, 0x47, 0x48,
  0x23, 0x59, 0xDE, 0x01, 0x50, 0x9F, 0xFD, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xDF, 0xC0, 0x16, 0x0D,
  0x80, 0xC2, 0xF0, 0x16, 0x02, 0x0E, 0x80, 0xC1, 0xF0, 0x17, 0x04, 0x80, 0xC1, 0xF0, 0x17, 0x10,
  0x40, 0xEF, 0xFF, 0xFF, 0x01, 0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0x17, 0x30, 0x10, 0x9F, 0xFF,
  0xFD, 0x01, 0x75, 0x04, 0x0C, 0xFF, 0xFF, 0xA0, 0xD7, 0x71, 0x04, 0x0B, 0xFF, 0xFD, 0x0A, 0x04,
  0x77, 0x48, 0x11, 0x6B, 0xFF, 0xD8, 0x2E, 0xA5, 0x17, 0x77, 0x38, 0x53, 0x69, 0xAC, 0xDE, 0xA8,
  0x7E, 0xED, 0xCB, 0x97, 0x42, 0x72,
  // "é" (U+00E9)
  0x77, 0x75, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0xF0, 0x47, 0x77, 0x72, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x57, 0x77, 0x72,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x73, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x74, 0x0C, 0xFB, 0x0D, 0x02, 0x77,
  0x77, 0x40, 0x7F, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x10,
  0xDF, 0xA0, 0xA7, 0x77, 0x76, 0x0A, 0xFA, 0x08, 0x77, 0x77, 0x70, 0xEF, 0x0E, 0x05, 0x80, 0xC8,
  0x40, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77, 0x77, 0x81, 0x17, 0xCF, 0xF9,
  0x81, 0xEA, 0x47, 0x77, 0x20, 0x10, 0x8F, 0xFF, 0x0C, 0x04, 0x77, 0x60, 0x7F, 0xFF, 0xC0, 0xB0,
  0x17, 0x72, 0x01, 0x0B, 0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x02, 0x0D, 0xFF, 0xFF, 0xA0, 0x57, 0x50,
  0x20, 0xEF, 0xFF, 0xFC, 0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xE0, 0x27, 0x20, 0xBF, 0xFF,
  0xFF, 0x0C, 0x71, 0x06, 0x80, 0xC1, 0xF0, 0x66, 0x01, 0x0E, 0xFF, 0xA8, 0x4C, 0xA8, 0x8A, 0xCF,
  0xF9, 0x0E, 0x60, 0x8F, 0xF8, 0x1D, 0x61, 0x68, 0x11, 0x7E, 0xFE, 0x06, 0x40, 0x1F, 0xF0, 0x87,
  0x40, 0x10, 0xBF, 0xD0, 0xC4, 0x06, 0xFE, 0x05, 0x77, 0x0A, 0xFD, 0x02, 0x30, 0xCF, 0xD0, 0x67,
  0x72, 0x0C, 0xFC, 0x07, 0x20, 0x2F, 0xD0, 0xC7, 0x73, 0x04, 0xFC, 0x0B, 0x20, 0x6F, 0xD0, 0x57,
  0x74, 0x0D, 0xFB, 0x0E, 0x20, 0xAF, 0xC0, 0xE7, 0x75, 0x08, 0xFC, 0x81, 0x10, 0xDF, 0xC0, 0xB7,
  0x75, 0x05, 0xFC, 0x03, 0x1F, 0xD0, 0x87, 0x75, 0x03, 0xFC, 0x05, 0x02, 0x80, 0xD0, 0xF0, 0x60,
  0x48, 0x0D, 0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F,
  0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D,
  0x0F, 0x07, 0x03, 0xFD, 0x03, 0x77, 0x77, 0x40, 0x2F, 0xD0, 0x57, 0x77, 0x75, 0x0E, 0xFC, 0x08,
  0x77, 0x77, 0x50, 0xBF, 0xC0, 0xD7, 0x77, 0x75, 0x08, 0xFD, 0x04, 0x77, 0x77, 0x40, 0x4F, 0xD0,
  0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x77, 0x77, 0x40, 0x9F, 0xE0, 0x77, 0x77, 0x73, 0x02, 0xFF,
  0x09, 0x77, 0x72, 0x81, 0x16, 0xC5, 0x0B, 0xFF, 0x0D, 0x06, 0x77, 0x48, 0x12, 0x6B, 0xB0, 0x14,
  0x03, 0xFF, 0xA8, 0x1E, 0x94, 0x74, 0x82, 0x35, 0x9D, 0xE0, 0x15, 0x09, 0xFF, 0xD8, 0x7D, 0xB9,
  0x88, 0x9A, 0xBD, 0xFC, 0x01, 0x60, 0xD8, 0x0C, 0x2F, 0x01, 0x60, 0x20, 0xE8, 0x0C, 0x1F, 0x01,
  0x70, 0x48, 0x0C, 0x1F, 0x01, 0x71, 0x04, 0x0E, 0xFF, 0xFF, 0xF0, 0x17, 0x20, 0x20, 0xDF, 0xFF,
  0xFE, 0x01, 0x73, 0x01, 0x09, 0xFF, 0xFF, 0xD0, 0x17, 0x50, 0x40, 0xCF, 0xFF, 0xFA, 0x0D, 0x77,
  0x10, 0x40, 0xBF, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x81, 0x16, 0xBF, 0xFD, 0x82, 0xEA, 0x51, 0x77,
  0x73, 0x85, 0x36, 0x9A, 0xCD, 0xEA, 0x87, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x20,
  // "ê" (U+00EA)
  0x77, 0x30, 0x38, 0x09, 0x17, 0x77, 0x77, 0x40, 0xDF, 0xE0, 0x87, 0x77, 0x72, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x70, 0x2F, 0xFA, 0x0C, 0x77, 0x77, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xFD,
  0x03, 0x77, 0x73, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x20, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x10, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x60, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03,
  0x77, 0x40, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0x3F, 0xA0, 0xE0, 0x37,
  0x09, 0xFA, 0x0C, 0x77, 0x10, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x70, 0xDF,
  0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x50, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80,
  0xBE, 0x70, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77, 0x77, 0x81, 0x17, 0xCF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x20, 0x10, 0x8F, 0xFF, 0x0C, 0x04, 0x77, 0x60, 0x7F, 0xFF, 0xC0,
  0xB0, 0x17, 0x72, 0x01, 0x0B, 0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x02, 0x0D, 0xFF, 0xFF, 0xA0, 0x57,
  0x50, 0x20, 0xEF, 0xFF, 0xFC, 0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xE0, 0x27, 0x20, 0xBF,
  0xFF, 0xFF, 0x0C, 0x71, 0x06, 0x80, 0xC1, 0xF0, 0x66, 0x01, 0x0E, 0xFF, 0xA8, 0x4C, 0xA8, 0x8A,
  0xCF, 0xF9, 0x0E, 0x60, 0x8F, 0xF8, 0x1D, 0x61, 0x68, 0x11, 0x7E, 0xFE, 0x06, 0x40, 0x1F, 0xF0,
  0x87, 0x40, 0x10, 0xBF, 0xD0, 0xC4, 0x06, 0xFE, 0x05, 0x77, 0x0A, 0xFD, 0x02, 0x30, 0xCF, 0xD0,
  0x67, 0x72, 0x0C, 0xFC, 0x07, 0x20, 0x2F, 0xD0, 0xC7, 0x73, 0x04, 0xFC, 0x0B, 0x20, 0x6F, 0xD0,
  0x57, 0x74, 0x0D, 0xFB, 0x0E, 0x20, 0xAF, 0xC0, 0xE7, 0x75, 0x08, 0xFC, 0x81, 0x10, 0xDF, 0xC0,
  0xB7, 0x75, 0x05, 0xFC, 0x03, 0x1F, 0xD0, 0x87, 0x75, 0x03, 0xFC, 0x05, 0x02, 0x80, 0xD0, 0xF0,
  0x60, 0x48, 0x0D, 0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x00, 0x78, 0x0D,
  0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0, 0x70, 0x58,
  0x0D, 0x0F, 0x07, 0x03, 0xFD, 0x03, 0x77, 0x77, 0x40, 0x2F, 0xD0, 0x57, 0x77, 0x75, 0x0E, 0xFC,
  0x08, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xD7, 0x77, 0x75, 0x08, 0xFD, 0x04, 0x77, 0x77, 0x40, 0x4F,
  0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x77, 0x77, 0x40, 0x9F, 0xE0, 0x77, 0x77, 0x73, 0x02,
  0xFF, 0x09, 0x77, 0x72, 0x81, 0x16, 0xC5, 0x0B, 0xFF, 0x0D, 0x06, 0x77, 0x48, 0x12, 0x6B, 0xB0,
  0x14, 0x03, 0xFF, 0xA8, 0x1E, 0x94, 0x74, 0x82, 0x35, 0x9D, 0xE0, 0x15, 0x09, 0xFF, 0xD8, 0x7D,
  0xB9, 0x88, 0x9A, 0xBD, 0xFC, 0x01, 0x60, 0xD8, 0x0C, 0x2F, 0x01, 0x60, 0x20, 0xE8, 0x0C, 0x1F,
  0x01, 0x70, 0x48, 0x0C, 0x1F, 0x01, 0x71, 0x04, 0x0E, 0xFF, 0xFF, 0xF0, 0x17, 0x20, 0x20, 0xDF,
  0xFF, 0xFE, 0x01, 0x73, 0x01, 0x09, 0xFF, 0xFF, 0xD0, 0x17, 0x50, 0x40, 0xCF, 0xFF, 0xFA, 0x0D,
  0x77, 0x10, 0x40, 0xBF, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x81, 0x16, 0xBF, 0xFD, 0x82, 0xEA, 0x51,
  0x77, 0x73, 0x85, 0x36, 0x9A, 0xCD, 0xEA, 0x87, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x20,
  // "ë" (U+00EB)
  0x73, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x10, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x70, 0xBF, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xB0, 0x37,
  0x50, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x50, 0x8F, 0xC0, 0xE7, 0x10, 0x8F, 0xD7, 0x50,
  0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x74, 0x0B, 0xFD, 0x03, 0x70, 0xBF, 0xD0, 0x47, 0x40, 0xAF,
  0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x74, 0x07, 0xFC, 0x0E, 0x71, 0x07, 0xFD, 0x75, 0x02, 0xFC, 0x09,
  0x71, 0x02, 0xFC, 0x0A, 0x76, 0x0A, 0xFA, 0x0E, 0x01, 0x72, 0x09, 0xFA, 0x0E, 0x02, 0x77, 0x0A,
  0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x28, 0x54, 0xAE, 0xFE, 0xB6, 0x77, 0x85, 0x4A,
  0xDF, 0xEC, 0x78, 0x0B, 0xF2, 0x08, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77,
  0x78, 0x11, 0x7C, 0xFF, 0x98, 0x1E, 0xA4, 0x77, 0x72, 0x01, 0x08, 0xFF, 0xF0, 0xC0, 0x47, 0x76,
  0x07, 0xFF, 0xFC, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xE0, 0xE0, 0x47, 0x70, 0x20, 0xDF,
  0xFF, 0xFA, 0x05, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xC0, 0x47, 0x30, 0x10, 0xDF, 0xFF, 0xFD, 0x0E,
  0x02, 0x72, 0x0B, 0xFF, 0xFF, 0xF0, 0xC7, 0x10, 0x68, 0x0C, 0x1F, 0x06, 0x60, 0x10, 0xEF, 0xFA,
  0x84, 0xCA, 0x88, 0xAC, 0xFF, 0x90, 0xE6, 0x08, 0xFF, 0x81, 0xD6, 0x16, 0x81, 0x17, 0xEF, 0xE0,
  0x64, 0x01, 0xFF, 0x08, 0x74, 0x01, 0x0B, 0xFD, 0x0C, 0x40, 0x6F, 0xE0, 0x57, 0x70, 0xAF, 0xD0,
  0x23, 0x0C, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xC0, 0x72, 0x02, 0xFD, 0x0C, 0x77, 0x30, 0x4F, 0xC0,
  0xB2, 0x06, 0xFD, 0x05, 0x77, 0x40, 0xDF, 0xB0, 0xE2, 0x0A, 0xFC, 0x0E, 0x77, 0x50, 0x8F, 0xC8,
  0x11, 0x0D, 0xFC, 0x0B, 0x77, 0x50, 0x5F, 0xC0, 0x31, 0xFD, 0x08, 0x77, 0x50, 0x3F, 0xC0, 0x50,
  0x28, 0x0D, 0x0F, 0x06, 0x04, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0,
  0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D,
  0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x3F, 0xD0, 0x37, 0x77, 0x74, 0x02, 0xFD, 0x05, 0x77,
  0x77, 0x50, 0xEF, 0xC0, 0x87, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x50, 0x8F, 0xD0, 0x47,
  0x77, 0x74, 0x04, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x87, 0x77, 0x74, 0x09, 0xFE, 0x07,
  0x77, 0x77, 0x30, 0x2F, 0xF0, 0x97, 0x77, 0x28, 0x11, 0x6C, 0x50, 0xBF, 0xF0, 0xD0, 0x67, 0x74,
  0x81, 0x26, 0xBB, 0x01, 0x40, 0x3F, 0xFA, 0x81, 0xE9, 0x47, 0x48, 0x23, 0x59, 0xDE, 0x01, 0x50,
  0x9F, 0xFD, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xDF, 0xC0, 0x16, 0x0D, 0x80, 0xC2, 0xF0, 0x16, 0x02,
  0x0E, 0x80, 0xC1, 0xF0, 0x17, 0x04, 0x80, 0xC1, 0xF0, 0x17, 0x10, 0x40, 0xEF, 0xFF, 0xFF, 0x01,
  0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0x17, 0x30, 0x10, 0x9F, 0xFF, 0xFD, 0x01, 0x75, 0x04, 0x0C,
  0xFF, 0xFF, 0xA0, 0xD7, 0x71, 0x04, 0x0B, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x48, 0x11, 0x6B, 0xFF,
  0xD8, 0x2E, 0xA5, 0x17, 0x77, 0x38, 0x53, 0x69, 0xAC, 0xDE, 0xA8, 0x7E, 0xED, 0xCB, 0x97, 0x42,
  0x72,
  // "ì" (U+00EC)
  0x70, 0x58, 0x09, 0x17, 0x04, 0x77, 0x77, 0x20, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x72, 0x0B, 0xFE,
  0x09, 0x77, 0x77, 0x30, 0xCF, 0xE0, 0x37, 0x77, 0x72, 0x01, 0x0C, 0xFD, 0x0D, 0x77, 0x77, 0x40,
  0xCF, 0xD0, 0x87, 0x77, 0x74, 0x0B, 0xFD, 0x03, 0x77, 0x77, 0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x75,
  0x0A, 0xFC, 0x08, 0x77, 0x77, 0x50, 0x9F, 0xC0, 0x37, 0x77, 0x75, 0x08, 0xFB, 0x0D, 0x77, 0x77,
  0x60, 0x6F, 0xB0, 0xA7, 0x77, 0x76, 0x05, 0xFB, 0x05, 0x77, 0x77, 0x60, 0x30, 0xEF, 0x90, 0xE0,
  0x27, 0x77, 0x76, 0x01, 0x0C, 0xF9, 0x05, 0x80, 0xCB, 0x20, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30,
  0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73,
  0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77,
  0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB,
  0x0C, 0x77, 0x78, 0x62, 0x45, 0x79, 0xAC, 0xEF, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F,
  0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8, 0x2E, 0x75, 0x27, 0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8,
  0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80,
  0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C,
  0x7F, 0x07,
  // "í" (U+00ED)
  0x77, 0x73, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x03,
  0xFF, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xFE, 0x05, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xD0, 0x57, 0x77, 0x72, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x20, 0x6F, 0xC0, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x73, 0x01, 0x0D,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0xAF, 0xA0, 0x87, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0xB7,
  0x00, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7,
  0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0,
  0xC7, 0x73, 0x81, 0x2D, 0xEF, 0xFF, 0xB0, 0xC7, 0x77, 0x86, 0x24, 0x57, 0x9A, 0xCE, 0xFF, 0x90,
  0xC7, 0x77, 0x72, 0x02, 0x06, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x82, 0x13, 0x6A, 0xFD, 0x82, 0xE7, 0x52, 0x77,
  0x58, 0x41, 0x46, 0x9B, 0xEF, 0xFE, 0x83, 0xEC, 0x96, 0x37, 0x18, 0x42, 0x47, 0x9C, 0xEF, 0xFF,
  0xFC, 0x85, 0xDA, 0x75, 0x20, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C,
  0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  // "î" (U+00EE)
  0x77, 0x10, 0x38, 0x09, 0x17, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x87, 0x77, 0x71, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x60, 0x2F, 0xFA, 0x0C, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x40, 0x8F, 0xFD,
  0x03, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x75, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37,
  0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x71, 0x03, 0xFA, 0x0E, 0x03, 0x70,
  0x9F, 0xA0, 0xC7, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x60, 0xDF, 0x90,
  0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x40, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xCA,
  0x20, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0,
  0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD,
  0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45, 0x79, 0xAC, 0xEF, 0xF9,
  0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8, 0x2E, 0x75, 0x27,
  0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF,
  0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80,
  0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  // "ï" (U+00EF)
  0x71, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x01, 0x0B, 0xF0,
  0xE0, 0x37, 0x40, 0xBF, 0x0E, 0x04, 0x76, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03, 0x74,
  0x03, 0xFC, 0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x74, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD, 0x74, 0x0A,
  0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04, 0x73, 0x0A, 0xFD,
  0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7, 0x40, 0x2F, 0xC0, 0x97,
  0x10, 0x2F, 0xC0, 0xA7, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F, 0xA0, 0xE0, 0x27, 0x60, 0xAF,
  0x0D, 0x03, 0x74, 0x09, 0xF0, 0xD0, 0x37, 0x71, 0x85, 0x4A, 0xEF, 0xEB, 0x67, 0x78, 0x54, 0xAD,
  0xFE, 0xC7, 0x80, 0xCA, 0x50, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73,
  0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77,
  0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7,
  0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45,
  0x79, 0xAC, 0xEF, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F,
  0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF,
  0xD8, 0x2E, 0x75, 0x27, 0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84,
  0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C,
  0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  // "ð" (U+00F0)
  0x77, 0x18, 0x26, 0xE7, 0x17, 0x72, 0x81, 0x19, 0xA7, 0x77, 0x30, 0x10, 0xEA, 0x81, 0xE8, 0x17,
  0x60, 0x60, 0xEA, 0x05, 0x77, 0x72, 0x08, 0xD8, 0x1E, 0x81, 0x72, 0x03, 0x0C, 0xC0, 0xE0, 0x17,
  0x77, 0x02, 0xF9, 0x0E, 0x06, 0x60, 0x10, 0x9F, 0x0A, 0x77, 0x70, 0xBF, 0xB0, 0xD0, 0x33, 0x05,
  0x0E, 0xFA, 0x05, 0x77, 0x50, 0x4F, 0xE8, 0x19, 0x3B, 0xFC, 0x0E, 0x01, 0x77, 0x40, 0xDF, 0xFF,
  0xF0, 0x57, 0x73, 0x01, 0x0C, 0xFF, 0xFD, 0x0C, 0x03, 0x77, 0x60, 0x60, 0xEF, 0xFF, 0x90, 0xE0,
  0x67, 0x77, 0x20, 0x10, 0x9F, 0xFE, 0x09, 0x01, 0x77, 0x75, 0x04, 0x0D, 0xFF, 0xA0, 0xC0, 0x37,
  0x77, 0x71, 0x02, 0x0E, 0xFF, 0x90, 0x27, 0x77, 0x71, 0x06, 0x0E, 0xFF, 0xA0, 0xD0, 0x17, 0x77,
  0x50, 0x30, 0xCF, 0xFD, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x09, 0xFF, 0xF9, 0x0C, 0x77, 0x71, 0x05,
  0x0E, 0xFF, 0xFB, 0x0A, 0x77, 0x60, 0x2F, 0xE0, 0xDF, 0xE0, 0x67, 0x76, 0x09, 0xFC, 0x81, 0x80,
  0x4F, 0xE0, 0x37, 0x76, 0x0D, 0xF9, 0x0B, 0x02, 0x30, 0x5F, 0xD0, 0xD7, 0x76, 0x04, 0xE0, 0xE0,
  0x56, 0x06, 0xFD, 0x08, 0x77, 0x60, 0xAC, 0x09, 0x72, 0x09, 0xFD, 0x03, 0x77, 0x58, 0x31, 0xEF,
  0xC3, 0x74, 0x0C, 0xFC, 0x0C, 0x77, 0x60, 0x50, 0x67, 0x60, 0x10, 0xEF, 0xC0, 0x57, 0x77, 0x77,
  0x05, 0xFC, 0x0C, 0x80, 0xC0, 0x00, 0xBF, 0xC0, 0x47, 0x75, 0x89, 0x34, 0x7A, 0xDD, 0xEF, 0xEE,
  0xCA, 0x73, 0x30, 0x2F, 0xC0, 0xC7, 0x72, 0x04, 0x0A, 0xFF, 0x83, 0xE7, 0x10, 0x9F, 0xC0, 0x37,
  0x60, 0x50, 0xCF, 0xFC, 0x81, 0xE5, 0x2F, 0xC0, 0x87, 0x40, 0x10, 0xAF, 0xFF, 0x90, 0x70, 0x9F,
  0xB0, 0xE7, 0x30, 0x30, 0xEF, 0xFF, 0xB0, 0xAF, 0xC0, 0x47, 0x10, 0x40, 0xE8, 0x0C, 0x1F, 0x09,
  0x70, 0x38, 0x0C, 0x3F, 0x0C, 0x60, 0x10, 0xE8, 0x0C, 0x4F, 0x01, 0x50, 0xB8, 0x0C, 0x5F, 0x05,
  0x40, 0x58, 0x0C, 0x6F, 0x08, 0x40, 0xDF, 0xF9, 0x89, 0x0A, 0x62, 0x10, 0x12, 0x48, 0xDF, 0xFB,
  0x0A, 0x30, 0x5F, 0xF0, 0xB0, 0x27, 0x30, 0x60, 0xEF, 0xF9, 0x0D, 0x30, 0xBF, 0xE0, 0xA7, 0x60,
  0x20, 0xEF, 0xF9, 0x20, 0x1F, 0xE0, 0xC7, 0x71, 0x02, 0xFF, 0x98, 0x11, 0x06, 0xFE, 0x03, 0x77,
  0x20, 0x7F, 0xF8, 0x13, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xDF, 0xE8, 0x14, 0x0D, 0xFD, 0x07, 0x77,
  0x40, 0x7F, 0xE0, 0x41, 0xFE, 0x03, 0x77, 0x40, 0x2F, 0xE0, 0x50, 0x2F, 0xE0, 0x17, 0x75, 0x0E,
  0xFD, 0x06, 0x04, 0xFD, 0x0D, 0x77, 0x60, 0xCF, 0xD0, 0x50, 0x4F, 0xD0, 0xC7, 0x76, 0x0B, 0xFD,
  0x00, 0x5F, 0xD0, 0xC7, 0x76, 0x0C, 0xFD, 0x04, 0x06, 0xFD, 0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x30,
  0x5F, 0xD0, 0xC7, 0x76, 0x0D, 0xFD, 0x01, 0x04, 0xFD, 0x0D, 0x77, 0x6F, 0xE1, 0x03, 0xFD, 0x0E,
  0x77, 0x50, 0x2F, 0xD8, 0x1D, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x4F, 0xD0, 0xA2, 0x0E, 0xFD, 0x05,
  0x77, 0x40, 0x8F, 0xD0, 0x72, 0x0C, 0xFD, 0x0A, 0x77, 0x40, 0xDF, 0xD0, 0x22, 0x08, 0xFD, 0x0E,
  0x77, 0x30, 0x3F, 0xD0, 0xD3, 0x03, 0xFE, 0x08, 0x77, 0x20, 0xBF, 0xD0, 0x84, 0x0E, 0xFD, 0x0E,
  0x02, 0x77, 0x05, 0xFE, 0x02, 0x40, 0x8F, 0xE0, 0xD0, 0x17, 0x50, 0x4F, 0xE0, 0xB5, 0x01, 0xFF,
  0x0D, 0x04, 0x73, 0x07, 0xFF, 0x03, 0x60, 0x8F, 0xF9, 0x89, 0x0B, 0x73, 0x10, 0x12, 0x49, 0xDF,
  0xF0, 0xA7, 0x10, 0xD8, 0x0C, 0x1F, 0x0E, 0x01, 0x71, 0x04, 0x80, 0xC1, 0xF0, 0x57, 0x30, 0x7F,
  0xFF, 0xFF, 0x08, 0x75, 0x08, 0xFF, 0xFF, 0xD0, 0x97, 0x70, 0x8F, 0xFF, 0xFB, 0x08, 0x77, 0x20,
  0x50, 0xEF, 0xFF, 0xE0, 0xE0, 0x57, 0x74, 0x01, 0x0A, 0xFF, 0xFC, 0x0B, 0x02, 0x77, 0x70, 0x40,
  0xBF, 0xFF, 0x0C, 0x04, 0x77, 0x74, 0x81, 0x28, 0xDF, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x72, 0x85,
  0x25, 0x8B, 0xDD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x30,
  // "ñ" (U+00F1)
  0x74, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x10, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x04, 0xFE, 0x0C, 0x06, 0x70, 0x5E, 0x0C, 0x76, 0x01, 0x0E, 0xFF, 0x98,
  0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x60, 0xAF, 0xFF, 0xFA, 0x06, 0x75, 0x03, 0xFF, 0xFF,
  0xB0, 0x27, 0x50, 0xAF, 0xFF, 0xFA, 0x0C, 0x76, 0xFF, 0xFF, 0xB0, 0x57, 0x50, 0x5F, 0xFF, 0xFA,
  0x0C, 0x76, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27, 0x60, 0xCE, 0x04, 0x68,
  0x11, 0x8E, 0xFD, 0x0E, 0x03, 0x77, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27, 0x71,
  0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xBF, 0x60, 0x84, 0x37, 0xAC, 0xEE, 0xA8,
  0x3E, 0xCA, 0x73, 0x74, 0xFA, 0x0E, 0x71, 0x81, 0x28, 0xEF, 0xE8, 0x1E, 0x82, 0x71, 0xFB, 0x05,
  0x60, 0x8F, 0xFD, 0x08, 0x7F, 0xB0, 0xB4, 0x02, 0x0D, 0xFF, 0xF0, 0xC0, 0x15, 0xFC, 0x01, 0x20,
  0x30, 0xEF, 0xFF, 0xA0, 0xD0, 0x14, 0xFC, 0x82, 0x60, 0x2E, 0xFF, 0xFC, 0x0C, 0x4F, 0xC8, 0x1C,
  0x0C, 0xFF, 0xFE, 0x09, 0x3F, 0xD0, 0xEF, 0xFF, 0xF9, 0x03, 0x28, 0x0C, 0x6F, 0x0B, 0x28, 0x0C,
  0x7F, 0x01, 0x1F, 0xFE, 0x84, 0xDA, 0x88, 0xAD, 0xFF, 0xB0, 0x71, 0xFF, 0xC0, 0x90, 0x26, 0x02,
  0x0A, 0xFF, 0x90, 0xB1, 0xFF, 0xB0, 0x57, 0x30, 0x5F, 0xF0, 0xE1, 0xFF, 0xA0, 0x57, 0x50, 0x7F,
  0xF0, 0x2F, 0xF9, 0x09, 0x77, 0x0C, 0xFE, 0x04, 0xFF, 0x90, 0x17, 0x70, 0x6F, 0xE0, 0x6F, 0xF0,
  0xA7, 0x71, 0x01, 0xFE, 0x07, 0xFF, 0x04, 0x77, 0x20, 0xDF, 0xD0, 0x7F, 0xF7, 0x73, 0x0B, 0xFD,
  0x07, 0xFE, 0x0B, 0x77, 0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x87, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x05,
  0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE0, 0x37, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x02, 0x77, 0x30, 0x8F,
  0xD0, 0x7F, 0xE0, 0x17, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77,
  0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x70,
  // "ò" (U+00F2)
  0x72, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x75, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xBF,
  0xE0, 0x97, 0x77, 0x76, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x50, 0x10, 0xCF, 0xD0, 0xD7, 0x77, 0x77,
  0x0C, 0xFD, 0x08, 0x77, 0x77, 0x70, 0xBF, 0xD0, 0x37, 0x77, 0x77, 0x0B, 0xFC, 0x0D, 0x80, 0xC0,
  0x00, 0xAF, 0xC0, 0x88, 0x0C, 0x00, 0x09, 0xFC, 0x03, 0x80, 0xC0, 0x00, 0x8F, 0xB0, 0xD8, 0x0C,
  0x10, 0x06, 0xFB, 0x0A, 0x80, 0xC1, 0x00, 0x5F, 0xB0, 0x58, 0x0C, 0x10, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x80, 0xC1, 0x00, 0x10, 0xCF, 0x90, 0x58, 0x0C, 0x94, 0x08, 0x95, 0x36, 0x9B, 0xDE, 0xEF,
  0xEE, 0xCA, 0x84, 0x17, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x75, 0x04, 0x0C,
  0xFF, 0xE0, 0xE0, 0x87, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xB0, 0xE0, 0x57, 0x75, 0x06, 0x0E, 0xFF,
  0xFE, 0x09, 0x77, 0x30, 0x8F, 0xFF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xC0, 0x17,
  0x50, 0x8F, 0xFF, 0xFE, 0x0B, 0x74, 0x05, 0x80, 0xC0, 0xF0, 0x97, 0x20, 0x10, 0xE8, 0x0C, 0x1F,
  0x04, 0x71, 0x0A, 0xFF, 0xA8, 0x4D, 0xB9, 0x89, 0xCF, 0xFA, 0x0D, 0x70, 0x3F, 0xF9, 0x0A, 0x03,
  0x68, 0x11, 0x7E, 0xFF, 0x06, 0x60, 0xBF, 0xE0, 0xE0, 0x57, 0x30, 0x10, 0xCF, 0xE0, 0xE5, 0x02,
  0xFF, 0x04, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x40, 0x8F, 0xE0, 0x77, 0x70, 0x4F, 0xE0, 0xB4, 0x0E,
  0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xE3, 0x03, 0xFE, 0x06, 0x77, 0x20, 0x4F, 0xE0, 0x52, 0x07, 0xFE,
  0x77, 0x40, 0xEF, 0xD0, 0x82, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2, 0x0D, 0xFD, 0x06,
  0x77, 0x40, 0x6F, 0xD0, 0xE2, 0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x74,
  0x01, 0xFE, 0x02, 0x04, 0xFE, 0x77, 0x6F, 0xE0, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x05,
  0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x50, 0x6F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x06, 0x05, 0xFD,
  0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x04, 0xFE, 0x77, 0x6F,
  0xE0, 0x40, 0x3F, 0xE0, 0x17, 0x74, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE2,
  0x0E, 0xFD, 0x07, 0x77, 0x40, 0x6F, 0xD0, 0xD2, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2,
  0x08, 0xFE, 0x01, 0x77, 0x30, 0xEF, 0xD0, 0x72, 0x04, 0xFE, 0x06, 0x77, 0x20, 0x5F, 0xE0, 0x33,
  0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xD0, 0xE4, 0x0A, 0xFE, 0x07, 0x77, 0x05, 0xFE, 0x09, 0x40,
  0x3F, 0xF0, 0x47, 0x50, 0x20, 0xEF, 0xE0, 0x35, 0x0C, 0xFE, 0x0E, 0x05, 0x73, 0x03, 0x0D, 0xFE,
  0x0C, 0x60, 0x5F, 0xF9, 0x0A, 0x03, 0x60, 0x10, 0x7F, 0xF9, 0x05, 0x70, 0xBF, 0xFA, 0x84, 0xDA,
  0x98, 0xAC, 0xFF, 0xA0, 0xC7, 0x10, 0x28, 0x0C, 0x2F, 0x03, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77,
  0x40, 0xAF, 0xFF, 0xFE, 0x0B, 0x76, 0x0B, 0xFF, 0xFF, 0xC0, 0xC7, 0x71, 0x0A, 0xFF, 0xFF, 0xA0,
  0xB7, 0x73, 0x07, 0xFF, 0xFF, 0x09, 0x77, 0x50, 0x30, 0xDF, 0xFF, 0xB0, 0xE0, 0x57, 0x77, 0x10,
  0x60, 0xDF, 0xFE, 0x0E, 0x07, 0x77, 0x75, 0x81, 0x5A, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x77, 0x38,
  0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x72,
  // "ó" (U+00F3)
  0x77, 0x75, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x74, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x30,
  0x3F, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x40, 0x6F, 0xE0, 0x57, 0x77, 0x74,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x75, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x76, 0x0C, 0xFB, 0x0D, 0x02, 0x77,
  0x77, 0x60, 0x7F, 0xB0, 0xD0, 0x17, 0x77, 0x76, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x60, 0x10,
  0xDF, 0xA0, 0xA8, 0x0C, 0x00, 0x0A, 0xFA, 0x08, 0x80, 0xC1, 0x00, 0xEF, 0x0E, 0x05, 0x80, 0xCA,
  0x10, 0x89, 0x53, 0x69, 0xBD, 0xEE, 0xFE, 0xEC, 0xA8, 0x41, 0x77, 0x77, 0x28, 0x13, 0x9E, 0xFF,
  0x90, 0xB0, 0x67, 0x77, 0x50, 0x40, 0xCF, 0xFE, 0x0E, 0x08, 0x77, 0x71, 0x02, 0x0B, 0xFF, 0xFB,
  0x0E, 0x05, 0x77, 0x50, 0x60, 0xEF, 0xFF, 0xE0, 0x97, 0x73, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x17,
  0x70, 0x9F, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x08, 0xFF, 0xFF, 0xE0, 0xB7, 0x40, 0x58, 0x0C, 0x0F,
  0x09, 0x72, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0xAF, 0xFA, 0x84, 0xDB, 0x98, 0x9C, 0xFF,
  0xA0, 0xD7, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x81, 0x17, 0xEF, 0xF0, 0x66, 0x0B, 0xFE, 0x0E, 0x05,
  0x73, 0x01, 0x0C, 0xFE, 0x0E, 0x50, 0x2F, 0xF0, 0x47, 0x50, 0x10, 0xDF, 0xE0, 0x54, 0x08, 0xFE,
  0x07, 0x77, 0x04, 0xFE, 0x0B, 0x40, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFE, 0x30, 0x3F, 0xE0, 0x67,
  0x72, 0x04, 0xFE, 0x05, 0x20, 0x7F, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x20, 0xBF, 0xD0, 0xB7, 0x74,
  0x0A, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x74, 0x06, 0xFD, 0x0E, 0x2F, 0xE0, 0x47, 0x74, 0x03,
  0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x4F, 0xE7, 0x76, 0xFE, 0x00, 0x4F,
  0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0D,
  0x77, 0x60, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x00, 0x5F, 0xD0, 0xE7, 0x76,
  0x0E, 0xFD, 0x00, 0x4F, 0xE7, 0x76, 0xFE, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20,
  0x1F, 0xE0, 0x47, 0x74, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x77, 0x74, 0x06, 0xFD, 0x0D, 0x20, 0xBF,
  0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0x8F, 0xE0, 0x17, 0x73, 0x0E, 0xFD, 0x07, 0x20, 0x4F,
  0xE0, 0x67, 0x72, 0x05, 0xFE, 0x03, 0x30, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFD, 0x0E, 0x40, 0xAF,
  0xE0, 0x77, 0x70, 0x5F, 0xE0, 0x94, 0x03, 0xFF, 0x04, 0x75, 0x02, 0x0E, 0xFE, 0x03, 0x50, 0xCF,
  0xE0, 0xE0, 0x57, 0x30, 0x30, 0xDF, 0xE0, 0xC6, 0x05, 0xFF, 0x90, 0xA0, 0x36, 0x01, 0x07, 0xFF,
  0x90, 0x57, 0x0B, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA, 0x0C, 0x71, 0x02, 0x80, 0xC2, 0xF0,
  0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xE0, 0xB7, 0x60, 0xBF, 0xFF, 0xFC,
  0x0C, 0x77, 0x10, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x97, 0x75, 0x03, 0x0D,
  0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x58, 0x15, 0xAE,
  0xFF, 0x90, 0xB0, 0x67, 0x77, 0x73, 0x84, 0x47, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77,
  0x20,
  // "ô" (U+00F4)
  0x77, 0x30, 0x38, 0x09, 0x17, 0x77, 0x77, 0x60, 0xDF, 0xE0, 0x87, 0x77, 0x74, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x72, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x72, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x70, 0x8F,
  0xFD, 0x03, 0x77, 0x75, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0,
  0xA7, 0x77, 0x30, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x71, 0x08, 0xFB, 0x04, 0x30, 0xBF,
  0xB0, 0x37, 0x76, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x74, 0x03, 0xFA, 0x0E,
  0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x73, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x77,
  0x20, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x70, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF,
  0x0B, 0x80, 0xC8, 0x40, 0x89, 0x53, 0x69, 0xBD, 0xEE, 0xFE, 0xEC, 0xA8, 0x41, 0x77, 0x77, 0x28,
  0x13, 0x9E, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x50, 0x40, 0xCF, 0xFE, 0x0E, 0x08, 0x77, 0x71, 0x02,
  0x0B, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x50, 0x60, 0xEF, 0xFF, 0xE0, 0x97, 0x73, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x08, 0xFF, 0xFF, 0xE0, 0xB7, 0x40,
  0x58, 0x0C, 0x0F, 0x09, 0x72, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0xAF, 0xFA, 0x84, 0xDB,
  0x98, 0x9C, 0xFF, 0xA0, 0xD7, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x81, 0x17, 0xEF, 0xF0, 0x66, 0x0B,
  0xFE, 0x0E, 0x05, 0x73, 0x01, 0x0C, 0xFE, 0x0E, 0x50, 0x2F, 0xF0, 0x47, 0x50, 0x10, 0xDF, 0xE0,
  0x54, 0x08, 0xFE, 0x07, 0x77, 0x04, 0xFE, 0x0B, 0x40, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFE, 0x30,
  0x3F, 0xE0, 0x67, 0x72, 0x04, 0xFE, 0x05, 0x20, 0x7F, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x20, 0xBF,
  0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x74, 0x06, 0xFD, 0x0E, 0x2F, 0xE0,
  0x47, 0x74, 0x03, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x4F, 0xE7, 0x76,
  0xFE, 0x00, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x05,
  0x06, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x00, 0x5F,
  0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x4F, 0xE7, 0x76, 0xFE, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40,
  0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x47, 0x74, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x77, 0x74, 0x06, 0xFD,
  0x0D, 0x20, 0xBF, 0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0x8F, 0xE0, 0x17, 0x73, 0x0E, 0xFD,
  0x07, 0x20, 0x4F, 0xE0, 0x67, 0x72, 0x05, 0xFE, 0x03, 0x30, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFD,
  0x0E, 0x40, 0xAF, 0xE0, 0x77, 0x70, 0x5F, 0xE0, 0x94, 0x03, 0xFF, 0x04, 0x75, 0x02, 0x0E, 0xFE,
  0x03, 0x50, 0xCF, 0xE0, 0xE0, 0x57, 0x30, 0x30, 0xDF, 0xE0, 0xC6, 0x05, 0xFF, 0x90, 0xA0, 0x36,
  0x01, 0x07, 0xFF, 0x90, 0x57, 0x0B, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA, 0x0C, 0x71, 0x02,
  0x80, 0xC2, 0xF0, 0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xE0, 0xB7, 0x60,
  0xBF, 0xFF, 0xFC, 0x0C, 0x77, 0x10, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x97,
  0x75, 0x03, 0x0D, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xE0, 0xE0, 0x77, 0x77,
  0x58, 0x15, 0xAE, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x73, 0x84, 0x47, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC,
  0xA7, 0x41, 0x77, 0x20,
  // "õ" (U+00F5)
  0x76, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x40, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x30, 0x4F, 0xE0, 0xC0, 0x67, 0x05, 0xE0, 0xC7, 0x72, 0x01, 0x0E, 0xFF,
  0x98, 0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x72, 0x0A, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x03,
  0xFF, 0xFF, 0xB0, 0x27, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x72, 0xFF, 0xFF, 0xB0, 0x57, 0x71,
  0x05, 0xFF, 0xFF, 0xA0, 0xC7, 0x72, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27,
  0x72, 0x0C, 0xE0, 0x46, 0x81, 0x18, 0xEF, 0xD0, 0xE0, 0x37, 0x73, 0x0E, 0xD0, 0xC7, 0x30, 0x50,
  0xBF, 0xA0, 0xC0, 0x27, 0x74, 0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xC9, 0x20,
  0x89, 0x53, 0x69, 0xBD, 0xEE, 0xFE, 0xEC, 0xA8, 0x41, 0x77, 0x77, 0x28, 0x13, 0x9E, 0xFF, 0x90,
  0xB0, 0x67, 0x77, 0x50, 0x40, 0xCF, 0xFE, 0x0E, 0x08, 0x77, 0x71, 0x02, 0x0B, 0xFF, 0xFB, 0x0E,
  0x05, 0x77, 0x50, 0x60, 0xEF, 0xFF, 0xE0, 0x97, 0x73, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x17, 0x70,
  0x9F, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x08, 0xFF, 0xFF, 0xE0, 0xB7, 0x40, 0x58, 0x0C, 0x0F, 0x09,
  0x72, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0xAF, 0xFA, 0x84, 0xDB, 0x98, 0x9C, 0xFF, 0xA0,
  0xD7, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x81, 0x17, 0xEF, 0xF0, 0x66, 0x0B, 0xFE, 0x0E, 0x05, 0x73,
  0x01, 0x0C, 0xFE, 0x0E, 0x50, 0x2F, 0xF0, 0x47, 0x50, 0x10, 0xDF, 0xE0, 0x54, 0x08, 0xFE, 0x07,
  0x77, 0x04, 0xFE, 0x0B, 0x40, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFE, 0x30, 0x3F, 0xE0, 0x67, 0x72,
  0x04, 0xFE, 0x05, 0x20, 0x7F, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x20, 0xBF, 0xD0, 0xB7, 0x74, 0x0A,
  0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x74, 0x06, 0xFD, 0x0E, 0x2F, 0xE0, 0x47, 0x74, 0x03, 0xFE,
  0x01, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x4F, 0xE7, 0x76, 0xFE, 0x00, 0x4F, 0xD0,
  0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0D, 0x77,
  0x60, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x00, 0x5F, 0xD0, 0xE7, 0x76, 0x0E,
  0xFD, 0x00, 0x4F, 0xE7, 0x76, 0xFE, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x1F,
  0xE0, 0x47, 0x74, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x77, 0x74, 0x06, 0xFD, 0x0D, 0x20, 0xBF, 0xD0,
  0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0x8F, 0xE0, 0x17, 0x73, 0x0E, 0xFD, 0x07, 0x20, 0x4F, 0xE0,
  0x67, 0x72, 0x05, 0xFE, 0x03, 0x30, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFD, 0x0E, 0x40, 0xAF, 0xE0,
  0x77, 0x70, 0x5F, 0xE0, 0x94, 0x03, 0xFF, 0x04, 0x75, 0x02, 0x0E, 0xFE, 0x03, 0x50, 0xCF, 0xE0,
  0xE0, 0x57, 0x30, 0x30, 0xDF, 0xE0, 0xC6, 0x05, 0xFF, 0x90, 0xA0, 0x36, 0x01, 0x07, 0xFF, 0x90,
  0x57, 0x0B, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA, 0x0C, 0x71, 0x02, 0x80, 0xC2, 0xF0, 0x37,
  0x20, 0x68, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xE0, 0xB7, 0x60, 0xBF, 0xFF, 0xFC, 0x0C,
  0x77, 0x10, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x97, 0x75, 0x03, 0x0D, 0xFF,
  0xFB, 0x0E, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x58, 0x15, 0xAE, 0xFF,
  0x90, 0xB0, 0x67, 0x77, 0x73, 0x84, 0x47, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77, 0x20,
  // "ö" (U+00F6)
  0x73, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x30, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x72, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03,
  0x77, 0x03, 0xFC, 0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x77, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD, 0x77,
  0x0A, 0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x37, 0x60, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04, 0x76, 0x0A,
  0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x37, 0x60, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7, 0x70, 0x2F, 0xC0,
  0x97, 0x10, 0x2F, 0xC0, 0xA7, 0x71, 0x0A, 0xFA, 0x0E, 0x01, 0x72, 0x09, 0xFA, 0x0E, 0x02, 0x77,
  0x20, 0xAF, 0x0D, 0x03, 0x74, 0x09, 0xF0, 0xD0, 0x37, 0x74, 0x85, 0x4A, 0xEF, 0xEB, 0x67, 0x78,
  0x54, 0xAD, 0xFE, 0xC7, 0x80, 0xC8, 0x70, 0x89, 0x53, 0x69, 0xBD, 0xEE, 0xFE, 0xEC, 0xA8, 0x41,
  0x77, 0x77, 0x28, 0x13, 0x9E, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x50, 0x40, 0xCF, 0xFE, 0x0E, 0x08,
  0x77, 0x71, 0x02, 0x0B, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x50, 0x60, 0xEF, 0xFF, 0xE0, 0x97, 0x73,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x08, 0xFF, 0xFF,
  0xE0, 0xB7, 0x40, 0x58, 0x0C, 0x0F, 0x09, 0x72, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0xAF,
  0xFA, 0x84, 0xDB, 0x98, 0x9C, 0xFF, 0xA0, 0xD7, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x81, 0x17, 0xEF,
  0xF0, 0x66, 0x0B, 0xFE, 0x0E, 0x05, 0x73, 0x01, 0x0C, 0xFE, 0x0E, 0x50, 0x2F, 0xF0, 0x47, 0x50,
  0x10, 0xDF, 0xE0, 0x54, 0x08, 0xFE, 0x07, 0x77, 0x04, 0xFE, 0x0B, 0x40, 0xEF, 0xD0, 0xD7, 0x72,
  0x0C, 0xFE, 0x30, 0x3F, 0xE0, 0x67, 0x72, 0x04, 0xFE, 0x05, 0x20, 0x7F, 0xE7, 0x74, 0x0E, 0xFD,
  0x08, 0x20, 0xBF, 0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x74, 0x06, 0xFD,
  0x0E, 0x2F, 0xE0, 0x47, 0x74, 0x03, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20,
  0x4F, 0xE7, 0x76, 0xFE, 0x00, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD7, 0x76,
  0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x0D,
  0xFD, 0x00, 0x5F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x4F, 0xE7, 0x76, 0xFE, 0x04, 0x03, 0xFE,
  0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x47, 0x74, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x77,
  0x74, 0x06, 0xFD, 0x0D, 0x20, 0xBF, 0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0x8F, 0xE0, 0x17,
  0x73, 0x0E, 0xFD, 0x07, 0x20, 0x4F, 0xE0, 0x67, 0x72, 0x05, 0xFE, 0x03, 0x30, 0xEF, 0xD0, 0xD7,
  0x72, 0x0C, 0xFD, 0x0E, 0x40, 0xAF, 0xE0, 0x77, 0x70, 0x5F, 0xE0, 0x94, 0x03, 0xFF, 0x04, 0x75,
  0x02, 0x0E, 0xFE, 0x03, 0x50, 0xCF, 0xE0, 0xE0, 0x57, 0x30, 0x30, 0xDF, 0xE0, 0xC6, 0x05, 0xFF,
  0x90, 0xA0, 0x36, 0x01, 0x07, 0xFF, 0x90, 0x57, 0x0B, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA,
  0x0C, 0x71, 0x02, 0x80, 0xC2, 0xF0, 0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF,
  0xE0, 0xB7, 0x60, 0xBF, 0xFF, 0xFC, 0x0C, 0x77, 0x10, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x7F,
  0xFF, 0xF0, 0x97, 0x75, 0x03, 0x0D, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xE0,
  0xE0, 0x77, 0x77, 0x58, 0x15, 0xAE, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x73, 0x84, 0x47, 0x9C, 0xDE,
  0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77, 0x20,
  // "÷" (U+00F7)
  0x77, 0x38, 0x61, 0x8C, 0xEF, 0xD9, 0x27, 0x77, 0x75, 0x04, 0x0E, 0xF0, 0x57, 0x77, 0x73, 0x02,
  0x0E, 0xFA, 0x02, 0x77, 0x77, 0x20, 0x8F, 0xB0, 0xA7, 0x77, 0x72, 0x0C, 0xFB, 0x0E, 0x77, 0x77,
  0x2F, 0xD7, 0x77, 0x72, 0xFD, 0x01, 0x77, 0x77, 0x1F, 0xD7, 0x77, 0x72, 0x0C, 0xFB, 0x0E, 0x77,
  0x77, 0x20, 0x8F, 0xB0, 0x97, 0x77, 0x72, 0x01, 0x0E, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x30,
  0xEE, 0x0E, 0x04, 0x77, 0x77, 0x58, 0x61, 0x8C, 0xEF, 0xD8, 0x18, 0x0B, 0xB7, 0x00, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A, 0x80, 0xAE, 0x50, 0x86, 0x18, 0xCE, 0xED, 0x81, 0x77, 0x77,
  0x50, 0x30, 0xEE, 0x0E, 0x04, 0x77, 0x77, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x77, 0x72, 0x07,
  0xFB, 0x08, 0x77, 0x77, 0x20, 0xBF, 0xB0, 0xD7, 0x77, 0x72, 0x0E, 0xFC, 0x77, 0x77, 0x2F, 0xD0,
  0x17, 0x77, 0x71, 0xFD, 0x01, 0x77, 0x77, 0x10, 0xEF, 0xC7, 0x77, 0x72, 0x0B, 0xFB, 0x0C, 0x77,
  0x77, 0x20, 0x6F, 0xB0, 0x77, 0x77, 0x73, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x20, 0xDE,
  0x0D, 0x03, 0x77, 0x77, 0x68, 0x57, 0xCE, 0xEC, 0x81, 0x77, 0x30,
  // "ø" (U+00F8)
  0x80, 0xC1, 0x00, 0x30, 0x68, 0x0D, 0x20, 0x82, 0xDF, 0xA1, 0x77, 0x73, 0x89, 0x43, 0x69, 0xBD,
  0xEE, 0xFE, 0xDC, 0xA7, 0x45, 0x09, 0xB0, 0xD0, 0x47, 0x76, 0x81, 0x39, 0xEF, 0xF9, 0x82, 0xB5,
  0x04, 0xE0, 0x87, 0x73, 0x04, 0x0C, 0xFF, 0xE0, 0x0E, 0xF0, 0xC0, 0x27, 0x60, 0x20, 0xBF, 0xFF,
  0xFB, 0x0E, 0x02, 0x75, 0x06, 0x0E, 0xFF, 0xFF, 0xC0, 0x67, 0x50, 0x8F, 0xFF, 0xFD, 0x0B, 0x75,
  0x09, 0xFF, 0xFF, 0xD0, 0xE0, 0x17, 0x40, 0x8F, 0xFF, 0xFE, 0x0C, 0x74, 0x05, 0x80, 0xC0, 0xF0,
  0x87, 0x20, 0x10, 0xE8, 0x0C, 0x1F, 0x03, 0x71, 0x0A, 0xFF, 0xA8, 0x4D, 0xB9, 0x89, 0xCF, 0xFA,
  0x0C, 0x70, 0x3F, 0xF9, 0x0A, 0x03, 0x60, 0x10, 0x9F, 0xF9, 0x05, 0x60, 0xBF, 0xE0, 0xE0, 0x57,
  0x20, 0x9F, 0xF9, 0x0C, 0x50, 0x2F, 0xF0, 0x47, 0x20, 0x4F, 0xFB, 0x03, 0x40, 0x8F, 0xE0, 0x77,
  0x20, 0x10, 0xEF, 0xFB, 0x09, 0x40, 0xEF, 0xD0, 0xD7, 0x30, 0xAF, 0xFC, 0x0E, 0x30, 0x3F, 0xE0,
  0x67, 0x20, 0x5F, 0xFE, 0x03, 0x20, 0x7F, 0xE7, 0x20, 0x10, 0xEF, 0xFE, 0x08, 0x20, 0xBF, 0xD0,
  0xB7, 0x20, 0xAF, 0xFF, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x10, 0x5F, 0xA0, 0xAF, 0xD0, 0xE2, 0xFE,
  0x04, 0x70, 0x10, 0xEF, 0x90, 0x90, 0x3F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x0B, 0xF9, 0x81, 0xD0,
  0x1F, 0xE0, 0x20, 0x4F, 0xE7, 0x06, 0xFA, 0x04, 0x2F, 0xE0, 0x04, 0xFD, 0x0E, 0x60, 0x20, 0xEF,
  0x90, 0x93, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD6, 0x0B, 0xF9, 0x0D, 0x40, 0xDF, 0xD0, 0x50, 0x6F,
  0xD0, 0xD5, 0x06, 0xFA, 0x03, 0x40, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD4, 0x02, 0x0E, 0xF9, 0x08,
  0x50, 0xDF, 0xD0, 0x05, 0xFD, 0x0E, 0x40, 0xCF, 0x90, 0xC6, 0x0E, 0xFD, 0x00, 0x4F, 0xE3, 0x07,
  0xFA, 0x03, 0x6F, 0xE0, 0x40, 0x3F, 0xE8, 0x11, 0x02, 0xFA, 0x07, 0x60, 0x1F, 0xE0, 0x20, 0x1F,
  0xE8, 0x14, 0x0C, 0xF9, 0x0C, 0x70, 0x3F, 0xE2, 0x0E, 0xFD, 0x00, 0x7F, 0xA0, 0x27, 0x06, 0xFD,
  0x0D, 0x20, 0xBF, 0xD0, 0xDF, 0xA0, 0x67, 0x10, 0xAF, 0xD0, 0xB2, 0x08, 0xFF, 0xF0, 0xB7, 0x20,
  0xEF, 0xD0, 0x72, 0x04, 0xFF, 0xE0, 0xE0, 0x27, 0x10, 0x4F, 0xE0, 0x33, 0xFF, 0xE0, 0x67, 0x20,
  0xCF, 0xD0, 0xE4, 0x0A, 0xFF, 0xC0, 0xB7, 0x20, 0x5F, 0xE0, 0x94, 0x04, 0xFF, 0xB0, 0xE0, 0x17,
  0x10, 0x20, 0xEF, 0xE0, 0x35, 0x0D, 0xFF, 0xA0, 0x57, 0x10, 0x20, 0xDF, 0xE0, 0xC6, 0x05, 0xFF,
  0x90, 0xE0, 0x36, 0x01, 0x07, 0xFF, 0x90, 0x57, 0x0C, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA,
  0x0C, 0x71, 0x03, 0x80, 0xC2, 0xF0, 0x37, 0x20, 0x78, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF,
  0xE0, 0xB7, 0x50, 0x5F, 0xFF, 0xFD, 0x0C, 0x75, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xB7, 0x60, 0xAF,
  0xFF, 0xFC, 0x09, 0x76, 0x05, 0xFF, 0xFF, 0xB0, 0xE0, 0x57, 0x60, 0x10, 0xEF, 0x90, 0xEF, 0xFE,
  0x0E, 0x07, 0x77, 0x20, 0x8F, 0x83, 0xC0, 0x4A, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x50, 0x30, 0xDD,
  0x03, 0x48, 0x43, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x20, 0x8B, 0x08, 0x80,
  0xD0, 0x08, 0x13, 0xDC, 0x80, 0xD3, 0x00, 0x28, 0x0C, 0x10,
  // "ù" (U+00F9)
  0x71, 0x05, 0x80, 0x91, 0x70, 0x47, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x20, 0xBF,
  0xE0, 0x97, 0x77, 0x73, 0x0C, 0xFE, 0x03, 0x77, 0x77, 0x20, 0x10, 0xCF, 0xD0, 0xD7, 0x77, 0x74,
  0x0C, 0xFD, 0x08, 0x77, 0x77, 0x40, 0xBF, 0xD0, 0x37, 0x77, 0x74, 0x0B, 0xFC, 0x0D, 0x77, 0x77,
  0x50, 0xAF, 0xC0, 0x87, 0x77, 0x75, 0x09, 0xFC, 0x03, 0x77, 0x77, 0x50, 0x8F, 0xB0, 0xD7, 0x77,
  0x76, 0x06, 0xFB, 0x0A, 0x77, 0x77, 0x60, 0x5F, 0xB0, 0x57, 0x77, 0x76, 0x03, 0x0E, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x60, 0x10, 0xCF, 0x90, 0x58, 0x0C, 0xA7, 0x00, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x01, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x30, 0x2F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x04, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x30, 0x6F, 0xE0, 0x7F, 0xD0, 0x97, 0x73, 0x09, 0xFE, 0x07, 0xFD, 0x0A, 0x77, 0x30, 0xCF,
  0xE0, 0x7F, 0xD0, 0xD7, 0x72, 0x01, 0xFF, 0x07, 0xFE, 0x77, 0x20, 0x5F, 0xF0, 0x6F, 0xE0, 0x47,
  0x71, 0x0C, 0xFF, 0x04, 0xFE, 0x0A, 0x77, 0x05, 0xFF, 0x90, 0x2F, 0xF0, 0x27, 0x50, 0x20, 0xEF,
  0xF9, 0x1F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x10, 0xBF, 0xF0, 0xD0, 0x57, 0x01, 0x08,
  0xFF, 0xC1, 0x07, 0xFF, 0xA8, 0x5E, 0xB9, 0x89, 0xAD, 0xFF, 0xE1, 0x01, 0x80, 0xC7, 0xF2, 0x0A,
  0x80, 0xC6, 0xF2, 0x03, 0x80, 0xC6, 0xF3, 0x09, 0xFF, 0xFE, 0x81, 0xD0, 0xDF, 0xC4, 0x0C, 0xFF,
  0xFC, 0x82, 0xE2, 0x07, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xA0, 0xE0, 0x32, 0x01, 0xFC, 0x50, 0x10,
  0xCF, 0xFF, 0x0B, 0x01, 0x40, 0xBF, 0xB7, 0x08, 0xFF, 0xC0, 0xE0, 0x66, 0x06, 0xFB, 0x71, 0x81,
  0x29, 0xEF, 0xE0, 0xC0, 0x67, 0x2F, 0xB7, 0x48, 0x34, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x77,
  // "ú" (U+00FA)
  0x77, 0x74, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x03,
  0xFF, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xFE, 0x05, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xD0, 0x57, 0x77, 0x72, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x20, 0x6F, 0xC0, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x73, 0x01, 0x0D,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0xAF, 0xA0, 0x87, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0xB4,
  0x00, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0,
  0x7F, 0xD0, 0x87, 0x73, 0x01, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x2F, 0xE0, 0x7F, 0xD0, 0x87,
  0x73, 0x04, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x6F, 0xE0, 0x7F, 0xD0, 0x97, 0x73, 0x09, 0xFE,
  0x07, 0xFD, 0x0A, 0x77, 0x30, 0xCF, 0xE0, 0x7F, 0xD0, 0xD7, 0x72, 0x01, 0xFF, 0x07, 0xFE, 0x77,
  0x20, 0x5F, 0xF0, 0x6F, 0xE0, 0x47, 0x71, 0x0C, 0xFF, 0x04, 0xFE, 0x0A, 0x77, 0x05, 0xFF, 0x90,
  0x2F, 0xF0, 0x27, 0x50, 0x20, 0xEF, 0xF9, 0x1F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x10,
  0xBF, 0xF0, 0xD0, 0x57, 0x01, 0x08, 0xFF, 0xC1, 0x07, 0xFF, 0xA8, 0x5E, 0xB9, 0x89, 0xAD, 0xFF,
  0xE1, 0x01, 0x80, 0xC7, 0xF2, 0x0A, 0x80, 0xC6, 0xF2, 0x03, 0x80, 0xC6, 0xF3, 0x09, 0xFF, 0xFE,
  0x81, 0xD0, 0xDF, 0xC4, 0x0C, 0xFF, 0xFC, 0x82, 0xE2, 0x07, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xA0,
  0xE0, 0x32, 0x01, 0xFC, 0x50, 0x10, 0xCF, 0xFF, 0x0B, 0x01, 0x40, 0xBF, 0xB7, 0x08, 0xFF, 0xC0,
  0xE0, 0x66, 0x06, 0xFB, 0x71, 0x81, 0x29, 0xEF, 0xE0, 0xC0, 0x67, 0x2F, 0xB7, 0x48, 0x34, 0x8B,
  0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17, 0x77,
  // "û" (U+00FB)
  0x77, 0x20, 0x38, 0x09, 0x17, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x87, 0x77, 0x71, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x60, 0x2F, 0xFA, 0x0C, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x40, 0x8F, 0xFD,
  0x03, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x75, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37,
  0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x71, 0x03, 0xFA, 0x0E, 0x03, 0x70,
  0x9F, 0xA0, 0xC7, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x60, 0xDF, 0x90,
  0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x40, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xC9,
  0x70, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0,
  0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F,
  0xE0, 0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7,
  0x72, 0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9,
  0x02, 0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02, 0x0D, 0xFF, 0xA1,
  0x0B, 0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB, 0x98, 0x9A, 0xDF,
  0xFE, 0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F, 0x30, 0x9F, 0xFF,
  0xE8, 0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01, 0x0D, 0xFF, 0xFA,
  0x0E, 0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB, 0x70, 0x8F, 0xFC,
  0x0E, 0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72, 0xFB, 0x74, 0x83, 0x48,
  0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x70,
  // "ü" (U+00FC)
  0x72, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x01, 0x0B, 0xF0,
  0xE0, 0x37, 0x40, 0xBF, 0x0E, 0x04, 0x76, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03, 0x74,
  0x03, 0xFC, 0x0A, 0x71, 0x03, 0xFC, 0x0B, 0x74, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD, 0x74, 0x0A,
  0xFD, 0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04, 0x73, 0x0A, 0xFD,
  0x02, 0x70, 0xAF, 0xD0, 0x37, 0x30, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7, 0x40, 0x2F, 0xC0, 0x97,
  0x10, 0x2F, 0xC0, 0xA7, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F, 0xA0, 0xE0, 0x27, 0x60, 0xAF,
  0x0D, 0x03, 0x74, 0x09, 0xF0, 0xD0, 0x37, 0x71, 0x85, 0x4A, 0xEF, 0xEB, 0x67, 0x78, 0x54, 0xAD,
  0xFE, 0xC7, 0x80, 0xCA, 0x20, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD,
  0x09, 0x77, 0x30, 0x9F, 0xE0, 0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20,
  0x1F, 0xF0, 0x7F, 0xE7, 0x72, 0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0,
  0xA7, 0x70, 0x5F, 0xF9, 0x02, 0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73,
  0x02, 0x0D, 0xFF, 0xA1, 0x0B, 0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85,
  0xEB, 0x98, 0x9A, 0xDF, 0xFE, 0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C,
  0x6F, 0x30, 0x9F, 0xFF, 0xE8, 0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4,
  0x01, 0x0D, 0xFF, 0xFA, 0x0E, 0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B,
  0xFB, 0x70, 0x8F, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72,
  0xFB, 0x74, 0x83, 0x48, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x70,
  // "ý" (U+00FD)
  0x77, 0x76, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x76, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x50,
  0x3F, 0xF0, 0x47, 0x77, 0x76, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x60, 0x6F, 0xE0, 0x57, 0x77, 0x76,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x70, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x77, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x70, 0x20, 0xEF, 0xB0, 0xE0, 0x28, 0x0C, 0x00, 0x0C, 0xFB, 0x0D, 0x02, 0x80,
  0xC0, 0x00, 0x7F, 0xB0, 0xD0, 0x18, 0x0C, 0x00, 0x03, 0xFB, 0x0B, 0x01, 0x80, 0xC0, 0x00, 0x10,
  0xDF, 0xA0, 0xA8, 0x0C, 0x20, 0x0A, 0xFA, 0x08, 0x80, 0xC3, 0x00, 0xEF, 0x0E, 0x05, 0x80, 0xCF,
  0x50, 0x0E, 0xFE, 0x02, 0x77, 0x70, 0xEF, 0xD0, 0xE0, 0x9F, 0xE0, 0x77, 0x76, 0x04, 0xFE, 0x0A,
  0x03, 0xFE, 0x0D, 0x77, 0x60, 0x9F, 0xE8, 0x14, 0x0C, 0xFE, 0x02, 0x77, 0x50, 0xDF, 0xD0, 0xE2,
  0x06, 0xFE, 0x07, 0x77, 0x40, 0x2F, 0xE0, 0x82, 0x01, 0x0E, 0xFD, 0x0D, 0x77, 0x40, 0x7F, 0xE0,
  0x33, 0x09, 0xFE, 0x02, 0x77, 0x30, 0xBF, 0xD0, 0xC4, 0x03, 0xFE, 0x07, 0x77, 0x20, 0x1F, 0xE0,
  0x75, 0x0D, 0xFD, 0x0D, 0x77, 0x20, 0x5F, 0xE0, 0x15, 0x06, 0xFE, 0x02, 0x77, 0x10, 0x9F, 0xD0,
  0xB6, 0x01, 0xFE, 0x07, 0x77, 0x10, 0xEF, 0xD0, 0x57, 0x0A, 0xFD, 0x0D, 0x77, 0x03, 0xFD, 0x0E,
  0x71, 0x04, 0xFE, 0x02, 0x76, 0x08, 0xFD, 0x0A, 0x72, 0x0D, 0xFD, 0x07, 0x76, 0x0C, 0xFD, 0x04,
  0x72, 0x07, 0xFD, 0x0D, 0x75, 0x01, 0xFD, 0x0E, 0x73, 0x01, 0xFE, 0x02, 0x74, 0x06, 0xFD, 0x08,
  0x74, 0x0A, 0xFD, 0x07, 0x74, 0x0A, 0xFD, 0x02, 0x74, 0x04, 0xFD, 0x0D, 0x74, 0x0E, 0xFC, 0x0C,
  0x76, 0x0D, 0xFD, 0x02, 0x72, 0x04, 0xFD, 0x07, 0x76, 0x07, 0xFD, 0x07, 0x72, 0x09, 0xFD, 0x01,
  0x76, 0x01, 0xFD, 0x0D, 0x72, 0x0D, 0xFC, 0x0B, 0x77, 0x10, 0xAF, 0xD0, 0x27, 0x02, 0xFD, 0x05,
  0x77, 0x10, 0x4F, 0xD0, 0x77, 0x07, 0xFC, 0x0E, 0x77, 0x30, 0xDF, 0xC0, 0xD7, 0x0B, 0xFC, 0x09,
  0x77, 0x30, 0x8F, 0xD0, 0x25, 0x01, 0xFD, 0x04, 0x77, 0x30, 0x1F, 0xD0, 0x75, 0x05, 0xFC, 0x0D,
  0x77, 0x50, 0xBF, 0xC0, 0xD5, 0x0A, 0xFC, 0x08, 0x77, 0x50, 0x5F, 0xD0, 0x24, 0x0E, 0xFC, 0x02,
  0x77, 0x60, 0xEF, 0xC0, 0x73, 0x03, 0xFC, 0x0C, 0x77, 0x70, 0x8F, 0xC0, 0xC3, 0x08, 0xFC, 0x06,
  0x77, 0x70, 0x2F, 0xD0, 0x12, 0x0C, 0xFC, 0x01, 0x77, 0x71, 0x0B, 0xFC, 0x81, 0x50, 0x1F, 0xC0,
  0xB7, 0x77, 0x20, 0x5F, 0xC8, 0x19, 0x05, 0xFC, 0x05, 0x77, 0x73, 0x0E, 0xFB, 0x81, 0xD0, 0x9F,
  0xB0, 0xE7, 0x77, 0x40, 0x8F, 0xC1, 0x0C, 0xFB, 0x09, 0x77, 0x74, 0x02, 0xFC, 0x03, 0xFC, 0x04,
  0x77, 0x75, 0x0B, 0xFB, 0x08, 0xFB, 0x0D, 0x77, 0x76, 0x05, 0xFF, 0xF0, 0x87, 0x77, 0x70, 0xEF,
  0xFE, 0x02, 0x77, 0x77, 0x09, 0xFF, 0xD0, 0xC7, 0x77, 0x71, 0x02, 0xFF, 0xD0, 0x67, 0x77, 0x72,
  0x0C, 0xFF, 0xC0, 0x17, 0x77, 0x72, 0x06, 0xFF, 0xB0, 0xB7, 0x77, 0x74, 0x0E, 0xFF, 0xA0, 0x57,
  0x77, 0x74, 0x09, 0xFF, 0x90, 0xE7, 0x77, 0x75, 0x03, 0xFF, 0x90, 0x97, 0x77, 0x76, 0x0C, 0xFF,
  0x03, 0x77, 0x77, 0x60, 0x6F, 0xE0, 0xD8, 0x0C, 0x00, 0x0E, 0xFD, 0x08, 0x80, 0xC0, 0x0F, 0xE0,
  0x27, 0x77, 0x77, 0x05, 0xFD, 0x0C, 0x80, 0xC0, 0x00, 0xBF, 0xD0, 0x67, 0x77, 0x77, 0x01, 0xFE,
  0x01, 0x77, 0x77, 0x70, 0x8F, 0xD0, 0xA7, 0x77, 0x77, 0x01, 0x0E, 0xFD, 0x04, 0x77, 0x77, 0x70,
  0xAF, 0xD0, 0xC7, 0x77, 0x77, 0x05, 0xFE, 0x05, 0x77, 0x77, 0x60, 0x4F, 0xE0, 0xD7, 0x77, 0x76,
  0x07, 0xFF, 0x06, 0x77, 0x73, 0x82, 0x45, 0x21, 0x28, 0x21, 0x48, 0xDF, 0xF0, 0xC7, 0x77, 0x40,
  0xAF, 0xFF, 0xA0, 0x47, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0x97, 0x77, 0x50, 0xAF, 0xFF, 0x0D, 0x01,
  0x77, 0x75, 0x0A, 0xFF, 0xF0, 0x37, 0x77, 0x60, 0xAF, 0xFE, 0x06, 0x77, 0x77, 0x0A, 0xFF, 0xD0,
  0x77, 0x77, 0x71, 0x0A, 0xFF, 0xC0, 0x77, 0x77, 0x72, 0x0A, 0xFF, 0xA0, 0xE0, 0x47, 0x77, 0x73,
  0x0A, 0xFF, 0x90, 0x90, 0x17, 0x77, 0x74, 0x0A, 0xFD, 0x81, 0xE9, 0x27, 0x77, 0x76, 0x84, 0x37,
  0xAC, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x77, 0x60,
  // "þ" (U+00FE)
  0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7,
  0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F,
  0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77,
  0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD,
  0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77,
  0x75, 0xFD, 0x0A, 0x71, 0x89, 0x22, 0x6A, 0xCE, 0xEF, 0xED, 0xB7, 0x47, 0x6F, 0xD0, 0xA5, 0x81,
  0x17, 0xDF, 0xD8, 0x1E, 0x71, 0x73, 0xFD, 0x09, 0x40, 0x70, 0xEF, 0xFA, 0x0E, 0x05, 0x72, 0xFD,
  0x08, 0x20, 0x10, 0xCF, 0xFE, 0x09, 0x71, 0xFD, 0x82, 0x70, 0x2E, 0xFF, 0xF9, 0x0A, 0x7F, 0xD8,
  0x16, 0x1E, 0xFF, 0xFB, 0x09, 0x6F, 0xD0, 0x50, 0xCF, 0xFF, 0xD0, 0x65, 0xFD, 0x0E, 0xFF, 0xFF,
  0x02, 0x48, 0x0C, 0x5F, 0x0A, 0x48, 0x0C, 0x6F, 0x03, 0x3F, 0xFE, 0x84, 0xBA, 0x89, 0xBE, 0xFF,
  0xA0, 0xA3, 0xFF, 0xB8, 0x1E, 0x61, 0x60, 0x50, 0xDF, 0xF9, 0x01, 0x2F, 0xFA, 0x0B, 0x01, 0x72,
  0x01, 0x0B, 0xFF, 0x07, 0x2F, 0xF9, 0x0C, 0x75, 0x01, 0x0D, 0xFE, 0x0B, 0x2F, 0xF0, 0xE0, 0x17,
  0x60, 0x3F, 0xF0, 0x11, 0xFF, 0x07, 0x77, 0x10, 0xBF, 0xE0, 0x51, 0xFE, 0x0E, 0x77, 0x20, 0x5F,
  0xE0, 0x81, 0xFE, 0x0A, 0x77, 0x3F, 0xE0, 0xB1, 0xFE, 0x05, 0x77, 0x30, 0xBF, 0xD0, 0xD1, 0xFE,
  0x02, 0x77, 0x30, 0x8F, 0xE1, 0xFD, 0x0E, 0x77, 0x40, 0x6F, 0xE0, 0x2F, 0xD0, 0xD7, 0x74, 0x04,
  0xFE, 0x03, 0xFD, 0x0C, 0x77, 0x40, 0x3F, 0xE0, 0x4F, 0xD0, 0xB7, 0x74, 0x02, 0xFE, 0x05, 0xFD,
  0x0B, 0x77, 0x40, 0x1F, 0xE0, 0x5F, 0xD0, 0xB7, 0x74, 0x01, 0xFE, 0x06, 0xFD, 0x0B, 0x77, 0x40,
  0x1F, 0xE0, 0x5F, 0xD0, 0xC7, 0x74, 0x02, 0xFE, 0x05, 0xFD, 0x0D, 0x77, 0x40, 0x3F, 0xE0, 0x4F,
  0xD0, 0xE7, 0x74, 0x04, 0xFE, 0x03, 0xFE, 0x01, 0x77, 0x30, 0x6F, 0xE0, 0x2F, 0xE0, 0x47, 0x73,
  0x08, 0xFE, 0x1F, 0xE0, 0x77, 0x73, 0x0B, 0xFD, 0x0D, 0x1F, 0xE0, 0xB7, 0x73, 0x0E, 0xFD, 0x0B,
  0x1F, 0xF0, 0x27, 0x71, 0x04, 0xFE, 0x08, 0x1F, 0xF0, 0x97, 0x71, 0x0A, 0xFE, 0x04, 0x1F, 0xF9,
  0x02, 0x76, 0x02, 0xFF, 0x2F, 0xF9, 0x0D, 0x01, 0x75, 0x0C, 0xFE, 0x0B, 0x2F, 0xFA, 0x0C, 0x02,
  0x73, 0x0A, 0xFF, 0x06, 0x2F, 0xFB, 0x81, 0xE7, 0x16, 0x04, 0x0D, 0xFF, 0x0E, 0x3F, 0xFE, 0x84,
  0xCA, 0x89, 0xBE, 0xFF, 0xA0, 0x83, 0x80, 0xC5, 0xF0, 0xE0, 0x13, 0x80, 0xC5, 0xF0, 0x74, 0x80,
  0xC4, 0xF0, 0xC5, 0xFD, 0x0E, 0xFF, 0xFD, 0x0E, 0x02, 0x5F, 0xD0, 0x20, 0xAF, 0xFF, 0xC0, 0x56,
  0xFD, 0x81, 0x40, 0xAF, 0xFF, 0xA0, 0x57, 0xFD, 0x06, 0x20, 0x7F, 0xFE, 0x0E, 0x04, 0x71, 0xFD,
  0x08, 0x30, 0x20, 0xBF, 0xFB, 0x0A, 0x01, 0x72, 0xFD, 0x09, 0x58, 0x13, 0x9E, 0xFD, 0x0B, 0x04,
  0x74, 0xFD, 0x0A, 0x71, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xEC, 0x96, 0x17, 0x6F, 0xD0, 0xB7, 0x77,
  0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0,
  0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77,
  0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B,
  0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75,
  0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7,
  0x77, 0x75, 0xFD, 0x0B, 0x77, 0x77, 0x5F, 0xD0, 0xB7, 0x77, 0x75,
  // "ÿ" (U+00FF)
  0x74, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x50, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x74, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03,
  0x77, 0x20, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x72, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD,
  0x77, 0x20, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04,
  0x77, 0x10, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7,
  0x72, 0x02, 0xFC, 0x09, 0x71, 0x02, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F,
  0xA0, 0xE0, 0x27, 0x74, 0x0A, 0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x68, 0x54, 0xAE,
  0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x78, 0x0C, 0xE3, 0x00, 0xEF, 0xE0, 0x27, 0x77, 0x0E,
  0xFD, 0x0E, 0x09, 0xFE, 0x07, 0x77, 0x60, 0x4F, 0xE0, 0xA0, 0x3F, 0xE0, 0xD7, 0x76, 0x09, 0xFE,
  0x81, 0x40, 0xCF, 0xE0, 0x27, 0x75, 0x0D, 0xFD, 0x0E, 0x20, 0x6F, 0xE0, 0x77, 0x74, 0x02, 0xFE,
  0x08, 0x20, 0x10, 0xEF, 0xD0, 0xD7, 0x74, 0x07, 0xFE, 0x03, 0x30, 0x9F, 0xE0, 0x27, 0x73, 0x0B,
  0xFD, 0x0C, 0x40, 0x3F, 0xE0, 0x77, 0x72, 0x01, 0xFE, 0x07, 0x50, 0xDF, 0xD0, 0xD7, 0x72, 0x05,
  0xFE, 0x01, 0x50, 0x6F, 0xE0, 0x27, 0x71, 0x09, 0xFD, 0x0B, 0x60, 0x1F, 0xE0, 0x77, 0x71, 0x0E,
  0xFD, 0x05, 0x70, 0xAF, 0xD0, 0xD7, 0x70, 0x3F, 0xD0, 0xE7, 0x10, 0x4F, 0xE0, 0x27, 0x60, 0x8F,
  0xD0, 0xA7, 0x20, 0xDF, 0xD0, 0x77, 0x60, 0xCF, 0xD0, 0x47, 0x20, 0x7F, 0xD0, 0xD7, 0x50, 0x1F,
  0xD0, 0xE7, 0x30, 0x1F, 0xE0, 0x27, 0x40, 0x6F, 0xD0, 0x87, 0x40, 0xAF, 0xD0, 0x77, 0x40, 0xAF,
  0xD0, 0x27, 0x40, 0x4F, 0xD0, 0xD7, 0x40, 0xEF, 0xC0, 0xC7, 0x60, 0xDF, 0xD0, 0x27, 0x20, 0x4F,
  0xD0, 0x77, 0x60, 0x7F, 0xD0, 0x77, 0x20, 0x9F, 0xD0, 0x17, 0x60, 0x1F, 0xD0, 0xD7, 0x20, 0xDF,
  0xC0, 0xB7, 0x71, 0x0A, 0xFD, 0x02, 0x70, 0x2F, 0xD0, 0x57, 0x71, 0x04, 0xFD, 0x07, 0x70, 0x7F,
  0xC0, 0xE7, 0x73, 0x0D, 0xFC, 0x0D, 0x70, 0xBF, 0xC0, 0x97, 0x73, 0x08, 0xFD, 0x02, 0x50, 0x1F,
  0xD0, 0x47, 0x73, 0x01, 0xFD, 0x07, 0x50, 0x5F, 0xC0, 0xD7, 0x75, 0x0B, 0xFC, 0x0D, 0x50, 0xAF,
  0xC0, 0x87, 0x75, 0x05, 0xFD, 0x02, 0x40, 0xEF, 0xC0, 0x27, 0x76, 0x0E, 0xFC, 0x07, 0x30, 0x3F,
  0xC0, 0xC7, 0x77, 0x08, 0xFC, 0x0C, 0x30, 0x8F, 0xC0, 0x67, 0x77, 0x02, 0xFD, 0x01, 0x20, 0xCF,
  0xC0, 0x17, 0x77, 0x10, 0xBF, 0xC8, 0x15, 0x01, 0xFC, 0x0B, 0x77, 0x72, 0x05, 0xFC, 0x81, 0x90,
  0x5F, 0xC0, 0x57, 0x77, 0x30, 0xEF, 0xB8, 0x1D, 0x09, 0xFB, 0x0E, 0x77, 0x74, 0x08, 0xFC, 0x10,
  0xCF, 0xB0, 0x97, 0x77, 0x40, 0x2F, 0xC0, 0x3F, 0xC0, 0x47, 0x77, 0x50, 0xBF, 0xB0, 0x8F, 0xB0,
  0xD7, 0x77, 0x60, 0x5F, 0xFF, 0x08, 0x77, 0x77, 0x0E, 0xFF, 0xE0, 0x27, 0x77, 0x70, 0x9F, 0xFD,
  0x0C, 0x77, 0x77, 0x10, 0x2F, 0xFD, 0x06, 0x77, 0x77, 0x20, 0xCF, 0xFC, 0x01, 0x77, 0x77, 0x20,
  0x6F, 0xFB, 0x0B, 0x77, 0x77, 0x40, 0xEF, 0xFA, 0x05, 0x77, 0x77, 0x40, 0x9F, 0xF9, 0x0E, 0x77,
  0x77, 0x50, 0x3F, 0xF9, 0x09, 0x77, 0x77, 0x60, 0xCF, 0xF0, 0x37, 0x77, 0x76, 0x06, 0xFE, 0x0D,
  0x80, 0xC0, 0x00, 0xEF, 0xD0, 0x88, 0x0C, 0x00, 0xFE, 0x02, 0x77, 0x77, 0x70, 0x5F, 0xD0, 0xC8,
  0x0C, 0x00, 0x0B, 0xFD, 0x06, 0x77, 0x77, 0x70, 0x1F, 0xE0, 0x17, 0x77, 0x77, 0x08, 0xFD, 0x0A,
  0x77, 0x77, 0x70, 0x10, 0xEF, 0xD0, 0x47, 0x77, 0x77, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x70, 0x5F,
  0xE0, 0x57, 0x77, 0x76, 0x04, 0xFE, 0x0D, 0x77, 0x77, 0x60, 0x7F, 0xF0, 0x67, 0x77, 0x38, 0x24,
  0x52, 0x12, 0x82, 0x14, 0x8D, 0xFF, 0x0C, 0x77, 0x74, 0x0A, 0xFF, 0xFA, 0x04, 0x77, 0x74, 0x0A,
  0xFF, 0xF9, 0x09, 0x77, 0x75, 0x0A, 0xFF, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0xAF, 0xFF, 0x03, 0x77,
  0x76, 0x0A, 0xFF, 0xE0, 0x67, 0x77, 0x70, 0xAF, 0xFD, 0x07, 0x77, 0x77, 0x10, 0xAF, 0xFC, 0x07,
  0x77, 0x77, 0x20, 0xAF, 0xFA, 0x0E, 0x04, 0x77, 0x77, 0x30, 0xAF, 0xF9, 0x09, 0x01, 0x77, 0x77,
  0x40, 0xAF, 0xD8, 0x1E, 0x92, 0x77, 0x77, 0x68, 0x43, 0x7A, 0xCD, 0xEA, 0x83, 0xED, 0xB8, 0x47,
  0x77, 0x76,
  // "Ā" (U+0100)
  0x75, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD,
  0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09,
  0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77,
  0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x80, 0xE8, 0x50, 0x08, 0xFF, 0xA0, 0x67, 0x77, 0x76, 0x0C, 0xFF,
  0xA0, 0xA7, 0x77, 0x75, 0x01, 0xFF, 0xB0, 0xE7, 0x77, 0x75, 0x05, 0xFF, 0xC0, 0x37, 0x77, 0x74,
  0x09, 0xFF, 0xC0, 0x87, 0x77, 0x74, 0x0D, 0xFF, 0xC0, 0xC7, 0x77, 0x73, 0x02, 0xFF, 0xE0, 0x17,
  0x77, 0x72, 0x07, 0xFF, 0xE0, 0x57, 0x77, 0x72, 0x0B, 0xFF, 0xE0, 0xA7, 0x77, 0x72, 0xFF, 0xF0,
  0xE7, 0x77, 0x71, 0x04, 0xFB, 0x00, 0xDF, 0xB0, 0x37, 0x77, 0x70, 0x8F, 0xB0, 0x0A, 0xFB, 0x07,
  0x77, 0x77, 0x0D, 0xFB, 0x00, 0x6F, 0xB0, 0xB7, 0x77, 0x60, 0x1F, 0xC0, 0x03, 0xFC, 0x77, 0x76,
  0x06, 0xFC, 0x20, 0xEF, 0xB0, 0x47, 0x77, 0x50, 0xAF, 0xB0, 0xB2, 0x0B, 0xFB, 0x09, 0x77, 0x75,
  0x0E, 0xFB, 0x08, 0x20, 0x7F, 0xB0, 0xD7, 0x77, 0x40, 0x3F, 0xC0, 0x42, 0x03, 0xFC, 0x02, 0x77,
  0x73, 0x07, 0xFC, 0x4F, 0xC0, 0x67, 0x77, 0x30, 0xCF, 0xB0, 0xC4, 0x0B, 0xFB, 0x0A, 0x77, 0x72,
  0x01, 0xFC, 0x08, 0x40, 0x8F, 0xB0, 0xE7, 0x77, 0x20, 0x5F, 0xC0, 0x44, 0x04, 0xFC, 0x04, 0x77,
  0x71, 0x09, 0xFC, 0x50, 0x1F, 0xC0, 0x87, 0x77, 0x10, 0xDF, 0xB0, 0xC6, 0x0C, 0xFB, 0x0C, 0x77,
  0x70, 0x2F, 0xC0, 0x86, 0x08, 0xFC, 0x01, 0x77, 0x60, 0x6F, 0xC0, 0x46, 0x05, 0xFC, 0x05, 0x77,
  0x60, 0xBF, 0xC7, 0x01, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xB0, 0xC7, 0x10, 0xDF, 0xB0, 0xE7, 0x75,
  0x04, 0xFC, 0x08, 0x71, 0x09, 0xFC, 0x03, 0x77, 0x40, 0x8F, 0xC0, 0x47, 0x10, 0x5F, 0xC0, 0x77,
  0x74, 0x0C, 0xFC, 0x72, 0x01, 0xFC, 0x0B, 0x77, 0x30, 0x1F, 0xC0, 0xB7, 0x30, 0xDF, 0xC7, 0x73,
  0x05, 0xFC, 0x07, 0x73, 0x09, 0xFC, 0x05, 0x77, 0x20, 0xAF, 0xC0, 0x37, 0x30, 0x6F, 0xC0, 0x97,
  0x72, 0x0E, 0xFC, 0x74, 0x02, 0xFC, 0x0D, 0x77, 0x10, 0x3F, 0xC0, 0xB7, 0x50, 0xEF, 0xC0, 0x27,
  0x70, 0x7F, 0xC0, 0x77, 0x50, 0xAF, 0xC0, 0x67, 0x70, 0xBF, 0xC0, 0xA8, 0x09, 0x08, 0x0B, 0xFC,
  0x0B, 0x77, 0x80, 0xC1, 0xF0, 0xE7, 0x60, 0x48, 0x0C, 0x2F, 0x04, 0x75, 0x09, 0x80, 0xC2, 0xF0,
  0x87, 0x50, 0xD8, 0x0C, 0x2F, 0x0C, 0x74, 0x02, 0x80, 0xC4, 0xF0, 0x17, 0x30, 0x68, 0x0C, 0x4F,
  0x05, 0x73, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x30, 0xE8, 0x0C, 0x4F, 0x0E, 0x72, 0x03, 0x80, 0xC6,
  0xF0, 0x37, 0x10, 0x88, 0x0C, 0x6F, 0x07, 0x71, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xAF, 0xC0, 0xC7,
  0x01, 0xFD, 0x02, 0x77, 0x40, 0x7F, 0xD0, 0x16, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x56,
  0x09, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xC0, 0x96, 0x0E, 0xFC, 0x06, 0x77, 0x60, 0xBF, 0xC0, 0xD5,
  0x02, 0xFD, 0x02, 0x77, 0x60, 0x7F, 0xD0, 0x24, 0x07, 0xFC, 0x0E, 0x77, 0x70, 0x3F, 0xD0, 0x64,
  0x0B, 0xFC, 0x0A, 0x77, 0x71, 0xFD, 0x0B, 0x4F, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xD3, 0x04, 0xFD,
  0x03, 0x77, 0x71, 0x08, 0xFD, 0x04, 0x20, 0x8F, 0xC0, 0xE7, 0x77, 0x20, 0x4F, 0xD0, 0x82, 0x0D,
  0xFC, 0x0A, 0x77, 0x73, 0xFD, 0x81, 0xD0, 0x1F, 0xD0, 0x77, 0x77, 0x30, 0xCF, 0xD0, 0x10, 0x6F,
  0xD0, 0x37, 0x77, 0x30, 0x8F, 0xD0, 0x60, 0xAF, 0xC0, 0xE7, 0x77, 0x40, 0x4F, 0xD0, 0xA0, 0xEF,
  0xC0, 0xB7, 0x77, 0x40, 0x1F, 0xD0, 0xE0,
  // "ā" (U+0101)
  0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0,
  0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xCB, 0x60, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72,
  0x82, 0x15, 0x9D, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68,
  0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF,
  0xFF, 0xE0, 0xC7, 0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8,
  0x0C, 0x0F, 0x02, 0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A,
  0xDF, 0xFB, 0x01, 0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C,
  0xFE, 0xA4, 0x77, 0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77,
  0x40, 0xEF, 0xD7, 0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73,
  0x04, 0xFD, 0x02, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86,
  0x15, 0x7A, 0xCD, 0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40,
  0xBF, 0xFF, 0xFF, 0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02,
  0x30, 0x20, 0xE8, 0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81,
  0x20, 0x1F, 0xF9, 0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67,
  0x70, 0x4F, 0xD8, 0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02,
  0x77, 0x20, 0x4F, 0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77,
  0x30, 0x7F, 0xD0, 0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20,
  0x3F, 0xE0, 0x20, 0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B,
  0xFF, 0x02, 0x04, 0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05,
  0x0B, 0xFF, 0xB8, 0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80,
  0xC6, 0xF8, 0x12, 0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05,
  0xFF, 0xFE, 0x81, 0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40,
  0xDF, 0xFF, 0xA0, 0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F,
  0xB0, 0x26, 0x09, 0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57,
  0x20, 0xEF, 0xA0, 0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "Ă" (U+0102)
  0x74, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x70, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x77, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x70, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x77, 0x10, 0x4F, 0x90, 0x97, 0x30, 0x30, 0xDF, 0x0B, 0x77, 0x72, 0xFA, 0x82, 0xE9, 0x41,
  0x28, 0x21, 0x36, 0xBF, 0xA0, 0x77, 0x77, 0x20, 0xAF, 0xFF, 0xE0, 0x27, 0x77, 0x20, 0x3F, 0xFF,
  0xD0, 0x97, 0x77, 0x40, 0xAF, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x40, 0x10, 0xDF, 0xFF, 0xA0, 0x47,
  0x77, 0x60, 0x30, 0xEF, 0xFF, 0x06, 0x77, 0x77, 0x10, 0x30, 0xDF, 0xFD, 0x06, 0x77, 0x77, 0x30,
  0x10, 0xBF, 0xFA, 0x0D, 0x03, 0x77, 0x77, 0x60, 0x40, 0xBF, 0xD0, 0xD0, 0x58, 0x0C, 0x20, 0x89,
  0x22, 0x6A, 0xCD, 0xEF, 0xDC, 0xA6, 0x28, 0x0D, 0xB1, 0x00, 0x8F, 0xFA, 0x06, 0x77, 0x77, 0x60,
  0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0xFB, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xFC, 0x03, 0x77,
  0x77, 0x40, 0x9F, 0xFC, 0x08, 0x77, 0x77, 0x40, 0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xFE,
  0x01, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x05, 0x77, 0x77, 0x20, 0xBF, 0xFE, 0x0A, 0x77, 0x77, 0x2F,
  0xFF, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0x0D, 0xFB, 0x03, 0x77, 0x77, 0x08, 0xFB, 0x00, 0xAF,
  0xB0, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0x06, 0xFB, 0x0B, 0x77, 0x76, 0x01, 0xFC, 0x00, 0x3F, 0xC7,
  0x77, 0x60, 0x6F, 0xC2, 0x0E, 0xFB, 0x04, 0x77, 0x75, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0x97,
  0x77, 0x50, 0xEF, 0xB0, 0x82, 0x07, 0xFB, 0x0D, 0x77, 0x74, 0x03, 0xFC, 0x04, 0x20, 0x3F, 0xC0,
  0x27, 0x77, 0x30, 0x7F, 0xC4, 0xFC, 0x06, 0x77, 0x73, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0, 0xA7,
  0x77, 0x20, 0x1F, 0xC0, 0x84, 0x08, 0xFB, 0x0E, 0x77, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0,
  0x47, 0x77, 0x10, 0x9F, 0xC5, 0x01, 0xFC, 0x08, 0x77, 0x71, 0x0D, 0xFB, 0x0C, 0x60, 0xCF, 0xB0,
  0xC7, 0x77, 0x02, 0xFC, 0x08, 0x60, 0x8F, 0xC0, 0x17, 0x76, 0x06, 0xFC, 0x04, 0x60, 0x5F, 0xC0,
  0x57, 0x76, 0x0B, 0xFC, 0x70, 0x1F, 0xC0, 0xA7, 0x76, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB, 0x0E,
  0x77, 0x50, 0x4F, 0xC0, 0x87, 0x10, 0x9F, 0xC0, 0x37, 0x74, 0x08, 0xFC, 0x04, 0x71, 0x05, 0xFC,
  0x07, 0x77, 0x40, 0xCF, 0xC7, 0x20, 0x1F, 0xC0, 0xB7, 0x73, 0x01, 0xFC, 0x0B, 0x73, 0x0D, 0xFC,
  0x77, 0x30, 0x5F, 0xC0, 0x77, 0x30, 0x9F, 0xC0, 0x57, 0x72, 0x0A, 0xFC, 0x03, 0x73, 0x06, 0xFC,
  0x09, 0x77, 0x20, 0xEF, 0xC7, 0x40, 0x2F, 0xC0, 0xD7, 0x71, 0x03, 0xFC, 0x0B, 0x75, 0x0E, 0xFC,
  0x02, 0x77, 0x07, 0xFC, 0x07, 0x75, 0x0A, 0xFC, 0x06, 0x77, 0x0B, 0xFC, 0x0A, 0x80, 0x90, 0x80,
  0xBF, 0xC0, 0xB7, 0x78, 0x0C, 0x1F, 0x0E, 0x76, 0x04, 0x80, 0xC2, 0xF0, 0x47, 0x50, 0x98, 0x0C,
  0x2F, 0x08, 0x75, 0x0D, 0x80, 0xC2, 0xF0, 0xC7, 0x40, 0x28, 0x0C, 0x4F, 0x01, 0x73, 0x06, 0x80,
  0xC4, 0xF0, 0x57, 0x30, 0xA8, 0x0C, 0x4F, 0x0A, 0x73, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x20, 0x38,
  0x0C, 0x6F, 0x03, 0x71, 0x08, 0x80, 0xC6, 0xF0, 0x77, 0x10, 0xCF, 0xC0, 0x67, 0x74, 0x0A, 0xFC,
  0x0C, 0x70, 0x1F, 0xD0, 0x27, 0x74, 0x07, 0xFD, 0x01, 0x60, 0x5F, 0xC0, 0xE7, 0x75, 0x03, 0xFD,
  0x05, 0x60, 0x9F, 0xC0, 0xA7, 0x76, 0x0E, 0xFC, 0x09, 0x60, 0xEF, 0xC0, 0x67, 0x76, 0x0B, 0xFC,
  0x0D, 0x50, 0x2F, 0xD0, 0x27, 0x76, 0x07, 0xFD, 0x02, 0x40, 0x7F, 0xC0, 0xE7, 0x77, 0x03, 0xFD,
  0x06, 0x40, 0xBF, 0xC0, 0xA7, 0x77, 0x1F, 0xD0, 0xB4, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD, 0x30,
  0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x42, 0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x08,
  0x20, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD8, 0x1D, 0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD, 0x01,
  0x06, 0xFD, 0x03, 0x77, 0x73, 0x08, 0xFD, 0x06, 0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD, 0x0A,
  0x0E, 0xFC, 0x0B, 0x77, 0x74, 0x01, 0xFD, 0x0E,
  // "ă" (U+0103)
  0x72, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x0B, 0xE0, 0xC7, 0x70, 0x4F,
  0x04, 0x77, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x08, 0xF0, 0xA7, 0x50, 0x20, 0xEF, 0x77,
  0x10, 0x4F, 0x90, 0x97, 0x30, 0x30, 0xDF, 0x0B, 0x77, 0x2F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x13,
  0x6B, 0xFA, 0x07, 0x77, 0x20, 0xAF, 0xFF, 0xE0, 0x27, 0x72, 0x03, 0xFF, 0xFD, 0x09, 0x77, 0x40,
  0xAF, 0xFF, 0xB0, 0xE0, 0x17, 0x74, 0x01, 0x0D, 0xFF, 0xFA, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xFF,
  0x06, 0x77, 0x71, 0x03, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x30, 0x10, 0xBF, 0xFA, 0x0D, 0x03, 0x77,
  0x76, 0x04, 0x0B, 0xFD, 0x0D, 0x05, 0x77, 0x77, 0x38, 0x92, 0x26, 0xAC, 0xDE, 0xFD, 0xCA, 0x62,
  0x80, 0xBF, 0x10, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72, 0x82,
  0x15, 0x9D, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68, 0x11,
  0x8E, 0xFF, 0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF, 0xFF,
  0xE0, 0xC7, 0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8, 0x0C,
  0x0F, 0x02, 0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A, 0xDF,
  0xFB, 0x01, 0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C, 0xFE,
  0xA4, 0x77, 0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77, 0x40,
  0xEF, 0xD7, 0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73, 0x04,
  0xFD, 0x02, 0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86, 0x15,
  0x7A, 0xCD, 0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40, 0xBF,
  0xFF, 0xFF, 0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02, 0x30,
  0x20, 0xE8, 0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81, 0x20,
  0x1F, 0xF9, 0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67, 0x70,
  0x4F, 0xD8, 0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02, 0x77,
  0x20, 0x4F, 0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77, 0x30,
  0x7F, 0xD0, 0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20, 0x3F,
  0xE0, 0x20, 0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B, 0xFF,
  0x02, 0x04, 0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05, 0x0B,
  0xFF, 0xB8, 0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80, 0xC6,
  0xF8, 0x12, 0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05, 0xFF,
  0xFE, 0x81, 0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40, 0xDF,
  0xFF, 0xA0, 0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F, 0xB0,
  0x26, 0x09, 0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57, 0x20,
  0xEF, 0xA0, 0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x10,
  // "Ą" (U+0104)
  0x77, 0x30, 0x8F, 0xFA, 0x06, 0x80, 0xC0, 0x00, 0xCF, 0xFA, 0x0A, 0x77, 0x77, 0x70, 0x1F, 0xFB,
  0x0E, 0x77, 0x77, 0x70, 0x5F, 0xFC, 0x03, 0x77, 0x77, 0x60, 0x9F, 0xFC, 0x08, 0x77, 0x77, 0x60,
  0xDF, 0xFC, 0x0C, 0x77, 0x77, 0x50, 0x2F, 0xFE, 0x01, 0x77, 0x77, 0x40, 0x7F, 0xFE, 0x05, 0x77,
  0x77, 0x40, 0xBF, 0xFE, 0x0A, 0x77, 0x77, 0x4F, 0xFF, 0x0E, 0x77, 0x77, 0x30, 0x4F, 0xB0, 0x0D,
  0xFB, 0x03, 0x77, 0x77, 0x20, 0x8F, 0xB0, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x20, 0xDF, 0xB0, 0x06,
  0xFB, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xC0, 0x03, 0xFC, 0x77, 0x77, 0x10, 0x6F, 0xC2, 0x0E, 0xFB,
  0x04, 0x77, 0x77, 0x0A, 0xFB, 0x0B, 0x20, 0xBF, 0xB0, 0x97, 0x77, 0x70, 0xEF, 0xB0, 0x82, 0x07,
  0xFB, 0x0D, 0x77, 0x76, 0x03, 0xFC, 0x04, 0x20, 0x3F, 0xC0, 0x27, 0x77, 0x50, 0x7F, 0xC4, 0xFC,
  0x06, 0x77, 0x75, 0x0C, 0xFB, 0x0C, 0x40, 0xBF, 0xB0, 0xA7, 0x77, 0x40, 0x1F, 0xC0, 0x84, 0x08,
  0xFB, 0x0E, 0x77, 0x74, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0, 0x47, 0x77, 0x30, 0x9F, 0xC5, 0x01,
  0xFC, 0x08, 0x77, 0x73, 0x0D, 0xFB, 0x0C, 0x60, 0xCF, 0xB0, 0xC7, 0x77, 0x20, 0x2F, 0xC0, 0x86,
  0x08, 0xFC, 0x01, 0x77, 0x71, 0x06, 0xFC, 0x04, 0x60, 0x5F, 0xC0, 0x57, 0x77, 0x10, 0xBF, 0xC7,
  0x01, 0xFC, 0x0A, 0x77, 0x71, 0x0E, 0xFB, 0x0C, 0x71, 0x0D, 0xFB, 0x0E, 0x77, 0x70, 0x4F, 0xC0,
  0x87, 0x10, 0x9F, 0xC0, 0x37, 0x76, 0x08, 0xFC, 0x04, 0x71, 0x05, 0xFC, 0x07, 0x77, 0x60, 0xCF,
  0xC7, 0x20, 0x1F, 0xC0, 0xB7, 0x75, 0x01, 0xFC, 0x0B, 0x73, 0x0D, 0xFC, 0x77, 0x50, 0x5F, 0xC0,
  0x77, 0x30, 0x9F, 0xC0, 0x57, 0x74, 0x0A, 0xFC, 0x03, 0x73, 0x06, 0xFC, 0x09, 0x77, 0x40, 0xEF,
  0xC7, 0x40, 0x2F, 0xC0, 0xD7, 0x73, 0x03, 0xFC, 0x0B, 0x75, 0x0E, 0xFC, 0x02, 0x77, 0x20, 0x7F,
  0xC0, 0x77, 0x50, 0xAF, 0xC0, 0x67, 0x72, 0x0B, 0xFC, 0x0A, 0x80, 0x90, 0x80, 0xBF, 0xC0, 0xB7,
  0x72, 0x80, 0xC1, 0xF0, 0xE7, 0x71, 0x04, 0x80, 0xC2, 0xF0, 0x47, 0x70, 0x98, 0x0C, 0x2F, 0x08,
  0x77, 0x0D, 0x80, 0xC2, 0xF0, 0xC7, 0x60, 0x28, 0x0C, 0x4F, 0x01, 0x75, 0x06, 0x80, 0xC4, 0xF0,
  0x57, 0x50, 0xA8, 0x0C, 0x4F, 0x0A, 0x75, 0x0E, 0x80, 0xC4, 0xF0, 0xE7, 0x40, 0x38, 0x0C, 0x6F,
  0x03, 0x73, 0x08, 0x80, 0xC6, 0xF0, 0x77, 0x30, 0xCF, 0xC0, 0x67, 0x74, 0x0A, 0xFC, 0x0C, 0x72,
  0x01, 0xFD, 0x02, 0x77, 0x40, 0x7F, 0xD0, 0x17, 0x10, 0x5F, 0xC0, 0xE7, 0x75, 0x03, 0xFD, 0x05,
  0x71, 0x09, 0xFC, 0x0A, 0x77, 0x60, 0xEF, 0xC0, 0x97, 0x10, 0xEF, 0xC0, 0x67, 0x76, 0x0B, 0xFC,
  0x0D, 0x70, 0x2F, 0xD0, 0x27, 0x76, 0x07, 0xFD, 0x02, 0x60, 0x7F, 0xC0, 0xE7, 0x77, 0x03, 0xFD,
  0x06, 0x60, 0xBF, 0xC0, 0xA7, 0x77, 0x1F, 0xD0, 0xB6, 0xFD, 0x06, 0x77, 0x71, 0x0B, 0xFD, 0x50,
  0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x44, 0x08, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x08,
  0x40, 0xDF, 0xC0, 0xA7, 0x77, 0x3F, 0xD0, 0xD3, 0x01, 0xFD, 0x07, 0x77, 0x73, 0x0C, 0xFD, 0x01,
  0x20, 0x6F, 0xD0, 0x37, 0x77, 0x30, 0x8F, 0xD0, 0x62, 0x0A, 0xFC, 0x0E, 0x77, 0x74, 0x04, 0xFD,
  0x0A, 0x20, 0xEF, 0xC0, 0xB7, 0x77, 0x40, 0x1F, 0xE8, 0x0D, 0x00, 0x03, 0x0E, 0xE0, 0xE0, 0x28,
  0x0C, 0x70, 0x03, 0x0E, 0xE0, 0xE0, 0x38, 0x0C, 0x70, 0x03, 0x0E, 0xF0, 0x48, 0x0C, 0x70, 0x01,
  0x0D, 0xF0, 0x78, 0x0D, 0x00, 0x0A, 0xF0, 0xC8, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00,
  0xCF, 0x0C, 0x80, 0xD0, 0x00, 0x3F, 0x90, 0x78, 0x0D, 0x00, 0x08, 0xF9, 0x04, 0x80, 0xD0, 0x00,
  0xBF, 0x90, 0x48, 0x0D, 0x00, 0x0D, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0xDF, 0x90, 0xC8, 0x0D, 0x00,
  0x0C, 0xFA, 0x0B, 0x03, 0x28, 0x12, 0x59, 0x80, 0xC1, 0x00, 0xAF, 0xFA, 0x80, 0xC1, 0x00, 0x6F,
  0xFA, 0x80, 0xC1, 0x00, 0x1F, 0xFA, 0x80, 0xC2, 0x00, 0x9F, 0xF9, 0x80, 0xC3, 0x00, 0xCF, 0xF8,
  0x0C, 0x30, 0x01, 0x0C, 0xFE, 0x80, 0xC5, 0x00, 0x80, 0xEF, 0xC8, 0x0C, 0x60, 0x83, 0x16, 0xAD,
  0xEA, 0x83, 0xEC, 0x96, 0x10,
  // "ą" (U+0105)
  0x76, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x72, 0x82, 0x15, 0x9D,
  0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x40, 0x50, 0xBF, 0xFF, 0xC0, 0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFF,
  0xFF, 0x90, 0xE0, 0x57, 0x30, 0x4F, 0xFF, 0xFE, 0x0A, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xC7,
  0x20, 0x8F, 0xFF, 0xFF, 0x0B, 0x71, 0x01, 0x80, 0xC0, 0xF0, 0x87, 0x10, 0xA8, 0x0C, 0x0F, 0x02,
  0x70, 0x28, 0x0C, 0x0F, 0x0A, 0x71, 0x0B, 0xFB, 0x87, 0xEB, 0xA9, 0x88, 0x9A, 0xDF, 0xFB, 0x01,
  0x70, 0x4E, 0x82, 0xB7, 0x41, 0x72, 0x81, 0x16, 0xDF, 0xF0, 0x57, 0x18, 0x3C, 0xFE, 0xA4, 0x77,
  0x30, 0x8F, 0xE0, 0x97, 0x10, 0x30, 0x57, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0xD7,
  0x77, 0x74, 0x09, 0xFD, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xD0, 0x17, 0x77, 0x73, 0x04, 0xFD, 0x02,
  0x77, 0x77, 0x30, 0x4F, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xFD, 0x02, 0x75, 0x86, 0x15, 0x7A, 0xCD,
  0xEE, 0xFF, 0xFB, 0x02, 0x72, 0x81, 0x28, 0xDF, 0xFF, 0xFC, 0x02, 0x70, 0x40, 0xBF, 0xFF, 0xFF,
  0x02, 0x50, 0x10, 0xA8, 0x0C, 0x1F, 0x02, 0x40, 0x30, 0xD8, 0x0C, 0x2F, 0x02, 0x30, 0x20, 0xE8,
  0x0C, 0x3F, 0x02, 0x30, 0xD8, 0x0C, 0x4F, 0x02, 0x20, 0x88, 0x0C, 0x5F, 0x81, 0x20, 0x1F, 0xF9,
  0x84, 0xEA, 0x64, 0x21, 0x71, 0x04, 0xFD, 0x81, 0x20, 0x7F, 0xE0, 0xE0, 0x67, 0x70, 0x4F, 0xD8,
  0x12, 0x0C, 0xFD, 0x0D, 0x02, 0x77, 0x10, 0x4F, 0xD0, 0x21, 0xFD, 0x0E, 0x02, 0x77, 0x20, 0x4F,
  0xD0, 0x20, 0x3F, 0xD0, 0x97, 0x73, 0x05, 0xFD, 0x02, 0x05, 0xFD, 0x05, 0x77, 0x30, 0x7F, 0xD0,
  0x20, 0x6F, 0xD0, 0x37, 0x73, 0x0B, 0xFD, 0x02, 0x07, 0xFD, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x20,
  0x7F, 0xD0, 0x67, 0x72, 0x0C, 0xFE, 0x02, 0x05, 0xFD, 0x0C, 0x77, 0x01, 0x0B, 0xFF, 0x02, 0x04,
  0xFE, 0x08, 0x75, 0x04, 0x0D, 0xFF, 0x90, 0x02, 0xFF, 0x0C, 0x04, 0x71, 0x05, 0x0B, 0xFF, 0xB8,
  0x12, 0x0E, 0xFF, 0x98, 0x5E, 0xB9, 0x89, 0xAC, 0xFF, 0xE8, 0x12, 0x0A, 0x80, 0xC6, 0xF8, 0x12,
  0x05, 0x80, 0xC6, 0xF0, 0x22, 0x0D, 0xFF, 0xFF, 0x00, 0xEF, 0xC0, 0x22, 0x05, 0xFF, 0xFE, 0x81,
  0xE2, 0x8F, 0xC0, 0x23, 0x0A, 0xFF, 0xFC, 0x82, 0xE3, 0x03, 0xFC, 0x02, 0x40, 0xDF, 0xFF, 0xA0,
  0xD0, 0x23, 0x0D, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0x0A, 0x01, 0x40, 0x8F, 0xB0, 0x26, 0x09,
  0xFF, 0xC0, 0xD0, 0x46, 0x03, 0xFB, 0x02, 0x70, 0x30, 0xAF, 0xF0, 0xB0, 0x57, 0x10, 0x2F, 0xB0,
  0x27, 0x38, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x20, 0x30, 0xEE, 0x0E, 0x02, 0x77,
  0x77, 0x60, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77, 0x60, 0x30, 0xEF, 0x04, 0x77, 0x77, 0x60, 0x10,
  0xDF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x0C, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x37, 0x77, 0x77, 0x0C,
  0xF0, 0xC7, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x77, 0x70, 0x8F, 0x90, 0x47, 0x77, 0x77, 0x0B,
  0xF9, 0x04, 0x77, 0x77, 0x70, 0xDF, 0x90, 0x67, 0x77, 0x77, 0x0D, 0xF9, 0x0C, 0x77, 0x77, 0x70,
  0xCF, 0xA0, 0xB0, 0x32, 0x81, 0x25, 0x97, 0x77, 0x70, 0xAF, 0xFA, 0x77, 0x77, 0x06, 0xFF, 0xA7,
  0x77, 0x70, 0x1F, 0xFA, 0x77, 0x77, 0x10, 0x9F, 0xF9, 0x77, 0x77, 0x20, 0xCF, 0xF7, 0x77, 0x72,
  0x01, 0x0C, 0xFE, 0x77, 0x77, 0x40, 0x80, 0xEF, 0xC7, 0x77, 0x75, 0x83, 0x16, 0xAD, 0xEA, 0x83,
  0xEC, 0x96, 0x11,
  // "Ć" (U+0106)
  0x77, 0x77, 0x20, 0x18, 0x09, 0x27, 0x01, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x72,
  0x03, 0xFF, 0x04, 0x77, 0x77, 0x30, 0xCF, 0xE0, 0x57, 0x77, 0x73, 0x06, 0xFE, 0x05, 0x77, 0x77,
  0x30, 0x10, 0xEF, 0xD0, 0x57, 0x77, 0x74, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x40, 0x6F, 0xC0,
  0xE0, 0x37, 0x77, 0x74, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x50, 0xCF, 0xB0, 0xD0, 0x27,
  0x77, 0x75, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x50, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x75, 0x01,
  0x0D, 0xFA, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0xA0, 0x88, 0x0C, 0x00, 0x0E, 0xF0, 0xE0, 0x58, 0x0C,
  0x94, 0x08, 0x61, 0x57, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCB, 0x96, 0x37, 0x77, 0x68, 0x14, 0x9D,
  0xFF, 0xB8, 0x1E, 0x94, 0x77, 0x78, 0x11, 0x8E, 0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x72, 0x01, 0x08,
  0xFF, 0xFF, 0x90, 0xB0, 0x27, 0x60, 0x50, 0xEF, 0xFF, 0xFB, 0x01, 0x75, 0x09, 0xFF, 0xFF, 0xC0,
  0x97, 0x40, 0x20, 0xDF, 0xFF, 0xFD, 0x03, 0x73, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0xC7, 0x30, 0x20,
  0xEF, 0xFF, 0xFE, 0x06, 0x72, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE7, 0x30, 0xBF, 0xFF, 0xFF, 0x09,
  0x72, 0x07, 0xFF, 0xB8, 0x3D, 0x96, 0x31, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x02, 0x71, 0x02, 0xFF,
  0xA0, 0xA0, 0x37, 0x68, 0x12, 0x7D, 0xA0, 0xB7, 0x20, 0xBF, 0xF0, 0xD0, 0x47, 0x74, 0x81, 0x5D,
  0x57, 0x10, 0x3F, 0xF0, 0xC0, 0x17, 0x77, 0x72, 0x0C, 0xFE, 0x0B, 0x77, 0x77, 0x30, 0x3F, 0xE0,
  0xD0, 0x17, 0x77, 0x73, 0x09, 0xFE, 0x04, 0x77, 0x77, 0x40, 0xEF, 0xD0, 0xB7, 0x77, 0x74, 0x05,
  0xFE, 0x03, 0x77, 0x77, 0x40, 0xAF, 0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x06, 0x77, 0x77, 0x40,
  0x2F, 0xE0, 0x17, 0x77, 0x74, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0xD0, 0x97, 0x77, 0x75,
  0x0C, 0xFD, 0x06, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x47, 0x77, 0x75, 0xFE, 0x01, 0x77, 0x77, 0x40,
  0x3F, 0xE7, 0x77, 0x75, 0x04, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x05,
  0xFD, 0x0C, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50,
  0x7F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xC7, 0x77, 0x75,
  0x05, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x75, 0x03, 0xFE, 0x77, 0x77, 0x50,
  0x1F, 0xE0, 0x27, 0x77, 0x75, 0xFE, 0x05, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0x87, 0x77, 0x75, 0x0B,
  0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xE7, 0x77, 0x75, 0x04, 0xFE, 0x05, 0x77, 0x77, 0x5F, 0xE0,
  0xB7, 0x77, 0x75, 0x0C, 0xFE, 0x02, 0x77, 0x77, 0x40, 0x7F, 0xE0, 0xA7, 0x77, 0x74, 0x01, 0xFF,
  0x04, 0x77, 0x77, 0x40, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x73, 0x05, 0xFF, 0x0D, 0x02, 0x77, 0x71,
  0x01, 0x06, 0x70, 0xDF, 0xF0, 0xE0, 0x57, 0x75, 0x82, 0x39, 0xFD, 0x70, 0x5F, 0xFA, 0x0B, 0x04,
  0x77, 0x81, 0x27, 0xDB, 0x0D, 0x71, 0x0C, 0xFF, 0xB8, 0x3E, 0x96, 0x31, 0x38, 0x41, 0x24, 0x7A,
  0xDE, 0x0D, 0x71, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x20, 0x78, 0x0C, 0x0F, 0x0D, 0x73, 0x0B, 0xFF,
  0xFF, 0xF0, 0xD7, 0x40, 0xCF, 0xFF, 0xFE, 0x0D, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0xD0, 0xD7, 0x60,
  0xAF, 0xFF, 0xFC, 0x0D, 0x77, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x71, 0x02, 0x0B, 0xFF, 0xFF, 0x90,
  0xC7, 0x73, 0x04, 0x0B, 0xFF, 0xFC, 0x0A, 0x05, 0x77, 0x68, 0x12, 0x7C, 0xFF, 0xC8, 0x2C, 0x95,
  0x17, 0x77, 0x48, 0xA0, 0x14, 0x79, 0xCC, 0xDE, 0xFE, 0xED, 0xCA, 0x86, 0x41, 0x73,
  // "ć" (U+0107)
  0x77, 0x74, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x40, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x30, 0x3F,
  0xF0, 0x47, 0x77, 0x40, 0xCF, 0xE0, 0x57, 0x77, 0x40, 0x6F, 0xE0, 0x57, 0x77, 0x40, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x50, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x50, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x50,
  0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x60, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x60, 0x7F, 0xB0, 0xD0,
  0x17, 0x77, 0x60, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x60, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x71, 0x0A,
  0xFA, 0x08, 0x77, 0x77, 0x20, 0xEF, 0x0E, 0x05, 0x80, 0xBD, 0x00, 0x85, 0x36, 0x9B, 0xDE, 0xEA,
  0x86, 0xED, 0xDB, 0x97, 0x52, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xD8, 0x1B, 0x73, 0x77, 0x02, 0x09,
  0xFF, 0xFC, 0x81, 0xD7, 0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x09, 0x71, 0x03, 0x0D, 0xFF, 0xFF, 0xA0,
  0x37, 0x05, 0xFF, 0xFF, 0xB0, 0xD7, 0x05, 0xFF, 0xFF, 0xC0, 0x76, 0x03, 0xFF, 0xFF, 0xD0, 0x25,
  0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xB6, 0x0A, 0xFF, 0xFF, 0xD0, 0x65, 0x04, 0xFF, 0xC8, 0x6D, 0xB9,
  0x88, 0x9B, 0xDF, 0x0E, 0x60, 0xCF, 0xF9, 0x81, 0xE7, 0x27, 0x18, 0x21, 0x48, 0xCB, 0x0A, 0x50,
  0x4F, 0xF9, 0x08, 0x77, 0x18, 0x22, 0x8E, 0x45, 0x0A, 0xFF, 0x06, 0x77, 0x74, 0xFF, 0x07, 0x77,
  0x74, 0x05, 0xFE, 0x0C, 0x77, 0x75, 0x09, 0xFE, 0x03, 0x77, 0x75, 0x0D, 0xFD, 0x0D, 0x77, 0x76,
  0xFE, 0x07, 0x77, 0x75, 0x03, 0xFE, 0x03, 0x77, 0x75, 0x05, 0xFE, 0x77, 0x76, 0x07, 0xFD, 0x0C,
  0x77, 0x76, 0x08, 0xFD, 0x0A, 0x77, 0x76, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0A, 0xFD, 0x09, 0x77,
  0x76, 0x0A, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x09, 0x77, 0x76,
  0x09, 0xFD, 0x0A, 0x77, 0x76, 0x08, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x0E, 0x77, 0x76, 0x05,
  0xFE, 0x01, 0x77, 0x75, 0x03, 0xFE, 0x05, 0x77, 0x76, 0xFE, 0x0A, 0x77, 0x76, 0x0D, 0xFE, 0x02,
  0x77, 0x75, 0x09, 0xFE, 0x0A, 0x77, 0x75, 0x05, 0xFF, 0x05, 0x77, 0x70, 0x30, 0x23, 0xFF, 0x90,
  0x57, 0x74, 0x82, 0x2A, 0xF4, 0x30, 0xAF, 0xF9, 0x08, 0x77, 0x10, 0x30, 0xAB, 0x04, 0x30, 0x3F,
  0xFA, 0x81, 0xE7, 0x27, 0x18, 0x21, 0x48, 0xDD, 0x04, 0x40, 0xBF, 0xFC, 0x86, 0xDB, 0x98, 0x8A,
  0xBD, 0xFA, 0x04, 0x40, 0x3F, 0xFF, 0xFF, 0x04, 0x50, 0x8F, 0xFF, 0xFE, 0x04, 0x60, 0xCF, 0xFF,
  0xFD, 0x04, 0x60, 0x10, 0xDF, 0xFF, 0xFC, 0x04, 0x70, 0x20, 0xDF, 0xFF, 0xFB, 0x04, 0x71, 0x01,
  0x0B, 0xFF, 0xFF, 0xA0, 0x47, 0x30, 0x60, 0xEF, 0xFF, 0xF0, 0x37, 0x48, 0x11, 0x8E, 0xFF, 0xFA,
  0x81, 0xE9, 0x27, 0x71, 0x81, 0x5A, 0xEF, 0xFB, 0x81, 0xEA, 0x57, 0x77, 0x85, 0x35, 0x8A, 0xCD,
  0xEA, 0x86, 0xEE, 0xDC, 0xA8, 0x53, 0x71,
  // "Ĉ" (U+0108)
  0x77, 0x70, 0x38, 0x09, 0x17, 0x77, 0x77, 0x50, 0xDF, 0xE0, 0x87, 0x77, 0x73, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x71, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x71, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x60, 0x8F,
  0xFD, 0x03, 0x77, 0x74, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x30, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0,
  0xA7, 0x77, 0x20, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x70, 0x8F, 0xB0, 0x43, 0x0B, 0xFB,
  0x03, 0x77, 0x50, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x30, 0x3F, 0xA0, 0xE0,
  0x37, 0x09, 0xFA, 0x0C, 0x77, 0x20, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x71,
  0x0D, 0xF9, 0x0B, 0x75, 0x03, 0x0E, 0xF9, 0x06, 0x76, 0x03, 0xF9, 0x07, 0x77, 0x01, 0x0B, 0xF0,
  0xB8, 0x0B, 0xF7, 0x08, 0x61, 0x57, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCB, 0x96, 0x37, 0x77, 0x68,
  0x14, 0x9D, 0xFF, 0xB8, 0x1E, 0x94, 0x77, 0x78, 0x11, 0x8E, 0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x72,
  0x01, 0x08, 0xFF, 0xFF, 0x90, 0xB0, 0x27, 0x60, 0x50, 0xEF, 0xFF, 0xFB, 0x01, 0x75, 0x09, 0xFF,
  0xFF, 0xC0, 0x97, 0x40, 0x20, 0xDF, 0xFF, 0xFD, 0x03, 0x73, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0xC7,
  0x30, 0x20, 0xEF, 0xFF, 0xFE, 0x06, 0x72, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE7, 0x30, 0xBF, 0xFF,
  0xFF, 0x09, 0x72, 0x07, 0xFF, 0xB8, 0x3D, 0x96, 0x31, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x02, 0x71,
  0x02, 0xFF, 0xA0, 0xA0, 0x37, 0x68, 0x12, 0x7D, 0xA0, 0xB7, 0x20, 0xBF, 0xF0, 0xD0, 0x47, 0x74,
  0x81, 0x5D, 0x57, 0x10, 0x3F, 0xF0, 0xC0, 0x17, 0x77, 0x72, 0x0C, 0xFE, 0x0B, 0x77, 0x77, 0x30,
  0x3F, 0xE0, 0xD0, 0x17, 0x77, 0x73, 0x09, 0xFE, 0x04, 0x77, 0x77, 0x40, 0xEF, 0xD0, 0xB7, 0x77,
  0x74, 0x05, 0xFE, 0x03, 0x77, 0x77, 0x40, 0xAF, 0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x06, 0x77,
  0x77, 0x40, 0x2F, 0xE0, 0x17, 0x77, 0x74, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0xD0, 0x97,
  0x77, 0x75, 0x0C, 0xFD, 0x06, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x47, 0x77, 0x75, 0xFE, 0x01, 0x77,
  0x77, 0x40, 0x3F, 0xE7, 0x77, 0x75, 0x04, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77,
  0x75, 0x05, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77,
  0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xC7,
  0x77, 0x75, 0x05, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x75, 0x03, 0xFE, 0x77,
  0x77, 0x50, 0x1F, 0xE0, 0x27, 0x77, 0x75, 0xFE, 0x05, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0x87, 0x77,
  0x75, 0x0B, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xE7, 0x77, 0x75, 0x04, 0xFE, 0x05, 0x77, 0x77,
  0x5F, 0xE0, 0xB7, 0x77, 0x75, 0x0C, 0xFE, 0x02, 0x77, 0x77, 0x40, 0x7F, 0xE0, 0xA7, 0x77, 0x74,
  0x01, 0xFF, 0x04, 0x77, 0x77, 0x40, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x73, 0x05, 0xFF, 0x0D, 0x02,
  0x77, 0x71, 0x01, 0x06, 0x70, 0xDF, 0xF0, 0xE0, 0x57, 0x75, 0x82, 0x39, 0xFD, 0x70, 0x5F, 0xFA,
  0x0B, 0x04, 0x77, 0x81, 0x27, 0xDB, 0x0D, 0x71, 0x0C, 0xFF, 0xB8, 0x3E, 0x96, 0x31, 0x38, 0x41,
  0x24, 0x7A, 0xDE, 0x0D, 0x71, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x20, 0x78, 0x0C, 0x0F, 0x0D, 0x73,
  0x0B, 0xFF, 0xFF, 0xF0, 0xD7, 0x40, 0xCF, 0xFF, 0xFE, 0x0D, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0xD0,
  0xD7, 0x60, 0xAF, 0xFF, 0xFC, 0x0D, 0x77, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x71, 0x02, 0x0B, 0xFF,
  0xFF, 0x90, 0xC7, 0x73, 0x04, 0x0B, 0xFF, 0xFC, 0x0A, 0x05, 0x77, 0x68, 0x12, 0x7C, 0xFF, 0xC8,
  0x2C, 0x95, 0x17, 0x77, 0x48, 0xA0, 0x14, 0x79, 0xCC, 0xDE, 0xFE, 0xED, 0xCA, 0x86, 0x41, 0x73,
  // "ĉ" (U+0109)
  0x77, 0x20, 0x38, 0x09, 0x17, 0x77, 0x76, 0x0D, 0xFE, 0x08, 0x77, 0x74, 0x07, 0xFF, 0x90, 0x27,
  0x77, 0x20, 0x2F, 0xFA, 0x0C, 0x77, 0x72, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x08, 0xFF, 0xD0, 0x37,
  0x75, 0x04, 0xFF, 0xE0, 0xD7, 0x74, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB, 0x0A, 0x77, 0x30, 0xCF,
  0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x10, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03, 0x76, 0x05, 0xFA,
  0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x40, 0x3F, 0xA0, 0xE0, 0x37, 0x09, 0xFA, 0x0C, 0x73,
  0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x72, 0x0D, 0xF9, 0x0B, 0x75, 0x03, 0x0E,
  0xF9, 0x06, 0x70, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xBB, 0x30, 0x85, 0x36, 0x9B,
  0xDE, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x52, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xD8, 0x1B, 0x73, 0x77,
  0x02, 0x09, 0xFF, 0xFC, 0x81, 0xD7, 0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x09, 0x71, 0x03, 0x0D, 0xFF,
  0xFF, 0xA0, 0x37, 0x05, 0xFF, 0xFF, 0xB0, 0xD7, 0x05, 0xFF, 0xFF, 0xC0, 0x76, 0x03, 0xFF, 0xFF,
  0xD0, 0x25, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xB6, 0x0A, 0xFF, 0xFF, 0xD0, 0x65, 0x04, 0xFF, 0xC8,
  0x6D, 0xB9, 0x88, 0x9B, 0xDF, 0x0E, 0x60, 0xCF, 0xF9, 0x81, 0xE7, 0x27, 0x18, 0x21, 0x48, 0xCB,
  0x0A, 0x50, 0x4F, 0xF9, 0x08, 0x77, 0x18, 0x22, 0x8E, 0x45, 0x0A, 0xFF, 0x06, 0x77, 0x74, 0xFF,
  0x07, 0x77, 0x74, 0x05, 0xFE, 0x0C, 0x77, 0x75, 0x09, 0xFE, 0x03, 0x77, 0x75, 0x0D, 0xFD, 0x0D,
  0x77, 0x76, 0xFE, 0x07, 0x77, 0x75, 0x03, 0xFE, 0x03, 0x77, 0x75, 0x05, 0xFE, 0x77, 0x76, 0x07,
  0xFD, 0x0C, 0x77, 0x76, 0x08, 0xFD, 0x0A, 0x77, 0x76, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0A, 0xFD,
  0x09, 0x77, 0x76, 0x0A, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x09,
  0x77, 0x76, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x08, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x0E, 0x77,
  0x76, 0x05, 0xFE, 0x01, 0x77, 0x75, 0x03, 0xFE, 0x05, 0x77, 0x76, 0xFE, 0x0A, 0x77, 0x76, 0x0D,
  0xFE, 0x02, 0x77, 0x75, 0x09, 0xFE, 0x0A, 0x77, 0x75, 0x05, 0xFF, 0x05, 0x77, 0x70, 0x30, 0x23,
  0xFF, 0x90, 0x57, 0x74, 0x82, 0x2A, 0xF4, 0x30, 0xAF, 0xF9, 0x08, 0x77, 0x10, 0x30, 0xAB, 0x04,
  0x30, 0x3F, 0xFA, 0x81, 0xE7, 0x27, 0x18, 0x21, 0x48, 0xDD, 0x04, 0x40, 0xBF, 0xFC, 0x86, 0xDB,
  0x98, 0x8A, 0xBD, 0xFA, 0x04, 0x40, 0x3F, 0xFF, 0xFF, 0x04, 0x50, 0x8F, 0xFF, 0xFE, 0x04, 0x60,
  0xCF, 0xFF, 0xFD, 0x04, 0x60, 0x10, 0xDF, 0xFF, 0xFC, 0x04, 0x70, 0x20, 0xDF, 0xFF, 0xFB, 0x04,
  0x71, 0x01, 0x0B, 0xFF, 0xFF, 0xA0, 0x47, 0x30, 0x60, 0xEF, 0xFF, 0xF0, 0x37, 0x48, 0x11, 0x8E,
  0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x71, 0x81, 0x5A, 0xEF, 0xFB, 0x81, 0xEA, 0x57, 0x77, 0x85, 0x35,
  0x8A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC, 0xA8, 0x53, 0x71,
  // "Ċ" (U+010A)
  0x77, 0x72, 0x82, 0x17, 0xBE, 0xA8, 0x2D, 0xB7, 0x18, 0x0C, 0x00, 0x07, 0xFB, 0x07, 0x77, 0x77,
  0x60, 0x8F, 0xD0, 0x77, 0x77, 0x74, 0x02, 0xFF, 0x01, 0x77, 0x77, 0x30, 0x9F, 0xF0, 0x77, 0x77,
  0x73, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x30, 0xEF, 0xF0, 0xD7, 0x77, 0x73, 0xFF, 0x90, 0xD7, 0x77,
  0x73, 0x0E, 0xFF, 0x0D, 0x77, 0x77, 0x30, 0xCF, 0xF0, 0xB7, 0x77, 0x73, 0x09, 0xFF, 0x07, 0x77,
  0x77, 0x30, 0x2F, 0xE0, 0xE0, 0x17, 0x77, 0x74, 0x08, 0xFD, 0x06, 0x77, 0x77, 0x60, 0x8F, 0xA0,
  0xE0, 0x68, 0x0C, 0x00, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB7, 0x18, 0x0C, 0x93, 0x08, 0x61, 0x57,
  0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCB, 0x96, 0x37, 0x77, 0x68, 0x14, 0x9D, 0xFF, 0xB8, 0x1E, 0x94,
  0x77, 0x78, 0x11, 0x8E, 0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x72, 0x01, 0x08, 0xFF, 0xFF, 0x90, 0xB0,
  0x27, 0x60, 0x50, 0xEF, 0xFF, 0xFB, 0x01, 0x75, 0x09, 0xFF, 0xFF, 0xC0, 0x97, 0x40, 0x20, 0xDF,
  0xFF, 0xFD, 0x03, 0x73, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0xC7, 0x30, 0x20, 0xEF, 0xFF, 0xFE, 0x06,
  0x72, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE7, 0x30, 0xBF, 0xFF, 0xFF, 0x09, 0x72, 0x07, 0xFF, 0xB8,
  0x3D, 0x96, 0x31, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x02, 0x71, 0x02, 0xFF, 0xA0, 0xA0, 0x37, 0x68,
  0x12, 0x7D, 0xA0, 0xB7, 0x20, 0xBF, 0xF0, 0xD0, 0x47, 0x74, 0x81, 0x5D, 0x57, 0x10, 0x3F, 0xF0,
  0xC0, 0x17, 0x77, 0x72, 0x0C, 0xFE, 0x0B, 0x77, 0x77, 0x30, 0x3F, 0xE0, 0xD0, 0x17, 0x77, 0x73,
  0x09, 0xFE, 0x04, 0x77, 0x77, 0x40, 0xEF, 0xD0, 0xB7, 0x77, 0x74, 0x05, 0xFE, 0x03, 0x77, 0x77,
  0x40, 0xAF, 0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x06, 0x77, 0x77, 0x40, 0x2F, 0xE0, 0x17, 0x77,
  0x74, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0xD0, 0x97, 0x77, 0x75, 0x0C, 0xFD, 0x06, 0x77,
  0x77, 0x50, 0xEF, 0xD0, 0x47, 0x77, 0x75, 0xFE, 0x01, 0x77, 0x77, 0x40, 0x3F, 0xE7, 0x77, 0x75,
  0x04, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x05, 0xFD, 0x0C, 0x77, 0x77,
  0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77,
  0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xC7, 0x77, 0x75, 0x05, 0xFD, 0x0D, 0x77,
  0x77, 0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x75, 0x03, 0xFE, 0x77, 0x77, 0x50, 0x1F, 0xE0, 0x27, 0x77,
  0x75, 0xFE, 0x05, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0x87, 0x77, 0x75, 0x0B, 0xFD, 0x0B, 0x77, 0x77,
  0x50, 0x7F, 0xE7, 0x77, 0x75, 0x04, 0xFE, 0x05, 0x77, 0x77, 0x5F, 0xE0, 0xB7, 0x77, 0x75, 0x0C,
  0xFE, 0x02, 0x77, 0x77, 0x40, 0x7F, 0xE0, 0xA7, 0x77, 0x74, 0x01, 0xFF, 0x04, 0x77, 0x77, 0x40,
  0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x73, 0x05, 0xFF, 0x0D, 0x02, 0x77, 0x71, 0x01, 0x06, 0x70, 0xDF,
  0xF0, 0xE0, 0x57, 0x75, 0x82, 0x39, 0xFD, 0x70, 0x5F, 0xFA, 0x0B, 0x04, 0x77, 0x81, 0x27, 0xDB,
  0x0D, 0x71, 0x0C, 0xFF, 0xB8, 0x3E, 0x96, 0x31, 0x38, 0x41, 0x24, 0x7A, 0xDE, 0x0D, 0x71, 0x03,
  0x80, 0xC1, 0xF0, 0xD7, 0x20, 0x78, 0x0C, 0x0F, 0x0D, 0x73, 0x0B, 0xFF, 0xFF, 0xF0, 0xD7, 0x40,
  0xCF, 0xFF, 0xFE, 0x0D, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xFF, 0xFC, 0x0D,
  0x77, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x71, 0x02, 0x0B, 0xFF, 0xFF, 0x90, 0xC7, 0x73, 0x04, 0x0B,
  0xFF, 0xFC, 0x0A, 0x05, 0x77, 0x68, 0x12, 0x7C, 0xFF, 0xC8, 0x2C, 0x95, 0x17, 0x77, 0x48, 0xA0,
  0x14, 0x79, 0xCC, 0xDE, 0xFE, 0xED, 0xCA, 0x86, 0x41, 0x73,
  // "ċ" (U+010B)
  0x77, 0x48, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x20, 0x7F, 0xB0, 0x77, 0x77, 0x70,
  0x8F, 0xD0, 0x77, 0x77, 0x50, 0x2F, 0xF0, 0x17, 0x77, 0x40, 0x9F, 0xF0, 0x77, 0x77, 0x40, 0xCF,
  0xF0, 0xB7, 0x77, 0x40, 0xEF, 0xF0, 0xD7, 0x77, 0x4F, 0xF9, 0x0D, 0x77, 0x74, 0x0E, 0xFF, 0x0D,
  0x77, 0x74, 0x0C, 0xFF, 0x0B, 0x77, 0x74, 0x09, 0xFF, 0x07, 0x77, 0x74, 0x02, 0xFE, 0x0E, 0x01,
  0x77, 0x75, 0x08, 0xFD, 0x06, 0x77, 0x77, 0x08, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x28, 0x90, 0x28,
  0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xBC, 0x70, 0x85, 0x36, 0x9B, 0xDE, 0xEA, 0x86, 0xED, 0xDB, 0x97,
  0x52, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xD8, 0x1B, 0x73, 0x77, 0x02, 0x09, 0xFF, 0xFC, 0x81, 0xD7,
  0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x09, 0x71, 0x03, 0x0D, 0xFF, 0xFF, 0xA0, 0x37, 0x05, 0xFF, 0xFF,
  0xB0, 0xD7, 0x05, 0xFF, 0xFF, 0xC0, 0x76, 0x03, 0xFF, 0xFF, 0xD0, 0x25, 0x01, 0x0E, 0xFF, 0xFF,
  0xC0, 0xB6, 0x0A, 0xFF, 0xFF, 0xD0, 0x65, 0x04, 0xFF, 0xC8, 0x6D, 0xB9, 0x88, 0x9B, 0xDF, 0x0E,
  0x60, 0xCF, 0xF9, 0x81, 0xE7, 0x27, 0x18, 0x21, 0x48, 0xCB, 0x0A, 0x50, 0x4F, 0xF9, 0x08, 0x77,
  0x18, 0x22, 0x8E, 0x45, 0x0A, 0xFF, 0x06, 0x77, 0x74, 0xFF, 0x07, 0x77, 0x74, 0x05, 0xFE, 0x0C,
  0x77, 0x75, 0x09, 0xFE, 0x03, 0x77, 0x75, 0x0D, 0xFD, 0x0D, 0x77, 0x76, 0xFE, 0x07, 0x77, 0x75,
  0x03, 0xFE, 0x03, 0x77, 0x75, 0x05, 0xFE, 0x77, 0x76, 0x07, 0xFD, 0x0C, 0x77, 0x76, 0x08, 0xFD,
  0x0A, 0x77, 0x76, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0A, 0xFD, 0x09, 0x77, 0x76, 0x0A, 0xFD, 0x08,
  0x77, 0x76, 0x0A, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x09, 0x77, 0x76, 0x09, 0xFD, 0x0A, 0x77,
  0x76, 0x08, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x0E, 0x77, 0x76, 0x05, 0xFE, 0x01, 0x77, 0x75,
  0x03, 0xFE, 0x05, 0x77, 0x76, 0xFE, 0x0A, 0x77, 0x76, 0x0D, 0xFE, 0x02, 0x77, 0x75, 0x09, 0xFE,
  0x0A, 0x77, 0x75, 0x05, 0xFF, 0x05, 0x77, 0x70, 0x30, 0x23, 0xFF, 0x90, 0x57, 0x74, 0x82, 0x2A,
  0xF4, 0x30, 0xAF, 0xF9, 0x08, 0x77, 0x10, 0x30, 0xAB, 0x04, 0x30, 0x3F, 0xFA, 0x81, 0xE7, 0x27,
  0x18, 0x21, 0x48, 0xDD, 0x04, 0x40, 0xBF, 0xFC, 0x86, 0xDB, 0x98, 0x8A, 0xBD, 0xFA, 0x04, 0x40,
  0x3F, 0xFF, 0xFF, 0x04, 0x50, 0x8F, 0xFF, 0xFE, 0x04, 0x60, 0xCF, 0xFF, 0xFD, 0x04, 0x60, 0x10,
  0xDF, 0xFF, 0xFC, 0x04, 0x70, 0x20, 0xDF, 0xFF, 0xFB, 0x04, 0x71, 0x01, 0x0B, 0xFF, 0xFF, 0xA0,
  0x47, 0x30, 0x60, 0xEF, 0xFF, 0xF0, 0x37, 0x48, 0x11, 0x8E, 0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x71,
  0x81, 0x5A, 0xEF, 0xFB, 0x81, 0xEA, 0x57, 0x77, 0x85, 0x35, 0x8A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC,
  0xA8, 0x53, 0x71,
  // "Č" (U+010C)
  0x74, 0x03, 0x80, 0x37, 0x06, 0x77, 0x20, 0x68, 0x03, 0x70, 0x37, 0x60, 0x6F, 0x90, 0xB0, 0x17,
  0x50, 0x10, 0xBF, 0x90, 0x67, 0x70, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7, 0x71,
  0x01, 0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x20, 0x20, 0xEF, 0xA0, 0x56,
  0x08, 0xFB, 0x03, 0x77, 0x40, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x60, 0x8F, 0xB0, 0x62,
  0x09, 0xFB, 0x09, 0x77, 0x71, 0x0B, 0xFB, 0x05, 0x08, 0xFB, 0x0C, 0x77, 0x72, 0x01, 0x0E, 0xFF,
  0xE0, 0xE0, 0x27, 0x77, 0x30, 0x4F, 0xFE, 0x04, 0x77, 0x75, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x70,
  0xCF, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0x2F, 0xFA, 0x02, 0x77, 0x77, 0x20, 0x7F, 0xF0, 0x77, 0x77,
  0x74, 0x0D, 0xFD, 0x0D, 0x80, 0xC9, 0x10, 0x86, 0x15, 0x79, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xB9,
  0x63, 0x77, 0x76, 0x81, 0x49, 0xDF, 0xFB, 0x81, 0xE9, 0x47, 0x77, 0x81, 0x18, 0xEF, 0xFF, 0xA8,
  0x1E, 0x92, 0x77, 0x20, 0x10, 0x8F, 0xFF, 0xF9, 0x0B, 0x02, 0x76, 0x05, 0x0E, 0xFF, 0xFF, 0xB0,
  0x17, 0x50, 0x9F, 0xFF, 0xFC, 0x09, 0x74, 0x02, 0x0D, 0xFF, 0xFF, 0xD0, 0x37, 0x30, 0x20, 0xDF,
  0xFF, 0xFD, 0x0C, 0x73, 0x02, 0x0E, 0xFF, 0xFF, 0xE0, 0x67, 0x20, 0x10, 0xDF, 0xFF, 0xFE, 0x0E,
  0x73, 0x0B, 0xFF, 0xFF, 0xF0, 0x97, 0x20, 0x7F, 0xFB, 0x83, 0xD9, 0x63, 0x12, 0x84, 0x12, 0x36,
  0x9D, 0xE0, 0x27, 0x10, 0x2F, 0xFA, 0x0A, 0x03, 0x76, 0x81, 0x27, 0xDA, 0x0B, 0x72, 0x0B, 0xFF,
  0x0D, 0x04, 0x77, 0x48, 0x15, 0xD5, 0x71, 0x03, 0xFF, 0x0C, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xE0,
  0xB7, 0x77, 0x73, 0x03, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0x47, 0x77, 0x74, 0x0E,
  0xFD, 0x0B, 0x77, 0x77, 0x40, 0x5F, 0xE0, 0x37, 0x77, 0x74, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x50,
  0xEF, 0xD0, 0x67, 0x77, 0x74, 0x02, 0xFE, 0x01, 0x77, 0x77, 0x40, 0x6F, 0xD0, 0xD7, 0x77, 0x75,
  0x09, 0xFD, 0x09, 0x77, 0x77, 0x50, 0xCF, 0xD0, 0x67, 0x77, 0x75, 0x0E, 0xFD, 0x04, 0x77, 0x77,
  0x5F, 0xE0, 0x17, 0x77, 0x74, 0x03, 0xFE, 0x77, 0x77, 0x50, 0x4F, 0xD0, 0xE7, 0x77, 0x75, 0x05,
  0xFD, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xC7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50,
  0x7F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x75,
  0x06, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77,
  0x50, 0x3F, 0xE7, 0x77, 0x75, 0x01, 0xFE, 0x02, 0x77, 0x77, 0x5F, 0xE0, 0x57, 0x77, 0x75, 0x0D,
  0xFD, 0x08, 0x77, 0x77, 0x50, 0xBF, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFE, 0x77, 0x77, 0x50, 0x4F,
  0xE0, 0x57, 0x77, 0x75, 0xFE, 0x0B, 0x77, 0x77, 0x50, 0xCF, 0xE0, 0x27, 0x77, 0x74, 0x07, 0xFE,
  0x0A, 0x77, 0x77, 0x40, 0x1F, 0xF0, 0x47, 0x77, 0x74, 0x0B, 0xFE, 0x0E, 0x02, 0x77, 0x77, 0x30,
  0x5F, 0xF0, 0xD0, 0x27, 0x77, 0x10, 0x10, 0x67, 0x0D, 0xFF, 0x0E, 0x05, 0x77, 0x58, 0x23, 0x9F,
  0xD7, 0x05, 0xFF, 0xA0, 0xB0, 0x47, 0x78, 0x12, 0x7D, 0xB0, 0xD7, 0x10, 0xCF, 0xFB, 0x83, 0xE9,
  0x63, 0x13, 0x84, 0x12, 0x47, 0xAD, 0xE0, 0xD7, 0x10, 0x38, 0x0C, 0x1F, 0x0D, 0x72, 0x07, 0x80,
  0xC0, 0xF0, 0xD7, 0x30, 0xBF, 0xFF, 0xFF, 0x0D, 0x74, 0x0C, 0xFF, 0xFF, 0xE0, 0xD7, 0x40, 0x10,
  0xCF, 0xFF, 0xFD, 0x0D, 0x76, 0x0A, 0xFF, 0xFF, 0xC0, 0xD7, 0x70, 0x7F, 0xFF, 0xFB, 0x0D, 0x77,
  0x10, 0x20, 0xBF, 0xFF, 0xF9, 0x0C, 0x77, 0x30, 0x40, 0xBF, 0xFF, 0xC0, 0xA0, 0x57, 0x76, 0x81,
  0x27, 0xCF, 0xFC, 0x82, 0xC9, 0x51, 0x77, 0x74, 0x8A, 0x01, 0x47, 0x9C, 0xCD, 0xEF, 0xEE, 0xDC,
  0xA8, 0x64, 0x17, 0x30,
  // "č" (U+010D)
  0x60, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x70, 0x6F, 0x90, 0xB0, 0x17, 0x50,
  0x10, 0xBF, 0x90, 0x67, 0x10, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7, 0x20, 0x10,
  0xDF, 0x90, 0xE0, 0x47, 0x10, 0x6F, 0xA0, 0xD0, 0x17, 0x30, 0x20, 0xEF, 0xA0, 0x56, 0x08, 0xFB,
  0x03, 0x75, 0x04, 0xFB, 0x07, 0x40, 0x9F, 0xB0, 0x57, 0x70, 0x8F, 0xB0, 0x62, 0x09, 0xFB, 0x09,
  0x77, 0x20, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x73, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x74,
  0x04, 0xFF, 0xE0, 0x47, 0x76, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x10, 0xCF, 0xFA, 0x0C, 0x77, 0x72,
  0x02, 0xFF, 0xA0, 0x27, 0x77, 0x30, 0x7F, 0xF0, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xD8, 0x0B, 0xC5,
  0x08, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x6E, 0xDD, 0xB9, 0x75, 0x27, 0x76, 0x81, 0x16, 0xBF, 0xFD,
  0x81, 0xB7, 0x37, 0x70, 0x20, 0x9F, 0xFF, 0xC8, 0x1D, 0x71, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0x97,
  0x10, 0x30, 0xDF, 0xFF, 0xFA, 0x03, 0x70, 0x5F, 0xFF, 0xFB, 0x0D, 0x70, 0x5F, 0xFF, 0xFC, 0x07,
  0x60, 0x3F, 0xFF, 0xFD, 0x02, 0x50, 0x10, 0xEF, 0xFF, 0xFC, 0x0B, 0x60, 0xAF, 0xFF, 0xFD, 0x06,
  0x50, 0x4F, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBD, 0xF0, 0xE6, 0x0C, 0xFF, 0x98, 0x1E, 0x72, 0x71,
  0x82, 0x14, 0x8C, 0xB0, 0xA5, 0x04, 0xFF, 0x90, 0x87, 0x71, 0x82, 0x28, 0xE4, 0x50, 0xAF, 0xF0,
  0x67, 0x77, 0x4F, 0xF0, 0x77, 0x77, 0x40, 0x5F, 0xE0, 0xC7, 0x77, 0x50, 0x9F, 0xE0, 0x37, 0x77,
  0x50, 0xDF, 0xD0, 0xD7, 0x77, 0x6F, 0xE0, 0x77, 0x77, 0x50, 0x3F, 0xE0, 0x37, 0x77, 0x50, 0x5F,
  0xE7, 0x77, 0x60, 0x7F, 0xD0, 0xC7, 0x77, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x60, 0x9F, 0xD0, 0xA7,
  0x77, 0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77,
  0x60, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77, 0x60,
  0x7F, 0xD0, 0xE7, 0x77, 0x60, 0x5F, 0xE0, 0x17, 0x77, 0x50, 0x3F, 0xE0, 0x57, 0x77, 0x6F, 0xE0,
  0xA7, 0x77, 0x60, 0xDF, 0xE0, 0x27, 0x77, 0x50, 0x9F, 0xE0, 0xA7, 0x77, 0x50, 0x5F, 0xF0, 0x57,
  0x77, 0x03, 0x02, 0x3F, 0xF9, 0x05, 0x77, 0x48, 0x22, 0xAF, 0x43, 0x0A, 0xFF, 0x90, 0x87, 0x71,
  0x03, 0x0A, 0xB0, 0x43, 0x03, 0xFF, 0xA8, 0x1E, 0x72, 0x71, 0x82, 0x14, 0x8D, 0xD0, 0x44, 0x0B,
  0xFF, 0xC8, 0x6D, 0xB9, 0x88, 0xAB, 0xDF, 0xA0, 0x44, 0x03, 0xFF, 0xFF, 0xF0, 0x45, 0x08, 0xFF,
  0xFF, 0xE0, 0x46, 0x0C, 0xFF, 0xFF, 0xD0, 0x46, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x47, 0x02, 0x0D,
  0xFF, 0xFF, 0xB0, 0x47, 0x10, 0x10, 0xBF, 0xFF, 0xFA, 0x04, 0x73, 0x06, 0x0E, 0xFF, 0xFF, 0x03,
  0x74, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x18, 0x15, 0xAE, 0xFF, 0xB8, 0x1E, 0xA5,
  0x77, 0x78, 0x53, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x85, 0x37, 0x10,
  // "Ď" (U+010E)
  0x50, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x77, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x77, 0x10, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7, 0x72,
  0x01, 0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x30, 0x20, 0xEF, 0xA0, 0x56,
  0x08, 0xFB, 0x03, 0x77, 0x50, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x70, 0x8F, 0xB0, 0x62,
  0x09, 0xFB, 0x09, 0x77, 0x72, 0x0B, 0xFB, 0x05, 0x08, 0xFB, 0x0C, 0x77, 0x73, 0x01, 0x0E, 0xFF,
  0xE0, 0xE0, 0x27, 0x77, 0x40, 0x4F, 0xFE, 0x04, 0x77, 0x76, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x71,
  0x0C, 0xFF, 0xA0, 0xC7, 0x77, 0x72, 0x02, 0xFF, 0xA0, 0x27, 0x77, 0x73, 0x07, 0xFF, 0x07, 0x77,
  0x77, 0x50, 0xDF, 0xD0, 0xD8, 0x0C, 0xD7, 0x00, 0xEF, 0xFE, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x76,
  0x0E, 0xFF, 0xFE, 0x81, 0xD9, 0x37, 0x73, 0x0E, 0xFF, 0xFF, 0xA0, 0xD0, 0x67, 0x71, 0x0E, 0xFF,
  0xFF, 0xC0, 0xD0, 0x57, 0x60, 0xEF, 0xFF, 0xFE, 0x0B, 0x01, 0x74, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0,
  0x47, 0x30, 0xE8, 0x0C, 0x1F, 0x05, 0x72, 0x0E, 0x80, 0xC2, 0xF0, 0x67, 0x10, 0xE8, 0x0C, 0x3F,
  0x05, 0x70, 0xE8, 0x0C, 0x3F, 0x0E, 0x03, 0x60, 0xEF, 0xC0, 0xE8, 0x03, 0x88, 0x19, 0xAC, 0xFF,
  0xC0, 0xD6, 0x0E, 0xFC, 0x0E, 0x74, 0x04, 0x0A, 0xFF, 0xA0, 0x85, 0x0E, 0xFC, 0x0E, 0x76, 0x02,
  0x0B, 0xFF, 0x90, 0x24, 0x0E, 0xFC, 0x0E, 0x77, 0x10, 0x8F, 0xF0, 0xA4, 0x0E, 0xFC, 0x0E, 0x77,
  0x20, 0x7F, 0xF0, 0x23, 0x0E, 0xFC, 0x0E, 0x77, 0x30, 0xAF, 0xE0, 0x93, 0x0E, 0xFC, 0x0E, 0x77,
  0x30, 0x10, 0xEF, 0xD0, 0xE3, 0x0E, 0xFC, 0x0E, 0x77, 0x40, 0x7F, 0xE0, 0x52, 0x0E, 0xFC, 0x0E,
  0x77, 0x50, 0xEF, 0xD0, 0x92, 0x0E, 0xFC, 0x0E, 0x77, 0x50, 0x9F, 0xD0, 0xD2, 0x0E, 0xFC, 0x0E,
  0x77, 0x50, 0x4F, 0xE8, 0x12, 0x0E, 0xFC, 0x0E, 0x77, 0x6F, 0xE8, 0x15, 0x0E, 0xFC, 0x0E, 0x77,
  0x60, 0xBF, 0xD8, 0x18, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x9F, 0xD8, 0x1B, 0x0E, 0xFC, 0x0E, 0x77,
  0x60, 0x6F, 0xD8, 0x1D, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x4F, 0xD8, 0x1E, 0x0E, 0xFC, 0x0E, 0x77,
  0x60, 0x2F, 0xE1, 0x0E, 0xFC, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x20, 0xEF, 0xC0, 0xE7, 0x77, 0xFE,
  0x03, 0x0E, 0xFC, 0x0E, 0x77, 0x7F, 0xE0, 0x30, 0xEF, 0xC0, 0xE7, 0x77, 0x0E, 0xFD, 0x04, 0x0E,
  0xFC, 0x0E, 0x77, 0x70, 0xEF, 0xD0, 0x40, 0xEF, 0xC0, 0xE7, 0x77, 0x0E, 0xFD, 0x04, 0x0E, 0xFC,
  0x0E, 0x77, 0x7F, 0xE0, 0x30, 0xEF, 0xC0, 0xE7, 0x77, 0xFE, 0x03, 0x0E, 0xFC, 0x0E, 0x77, 0x60,
  0x1F, 0xE0, 0x20, 0xEF, 0xC0, 0xE7, 0x76, 0x02, 0xFE, 0x10, 0xEF, 0xC0, 0xE7, 0x76, 0x04, 0xFD,
  0x81, 0xE0, 0xEF, 0xC0, 0xE7, 0x76, 0x06, 0xFD, 0x81, 0xD0, 0xEF, 0xC0, 0xE7, 0x76, 0x08, 0xFD,
  0x81, 0xA0, 0xEF, 0xC0, 0xE7, 0x76, 0x0B, 0xFD, 0x81, 0x80, 0xEF, 0xC0, 0xE7, 0x76, 0x0E, 0xFD,
  0x81, 0x50, 0xEF, 0xC0, 0xE7, 0x75, 0x03, 0xFE, 0x81, 0x20, 0xEF, 0xC0, 0xE7, 0x75, 0x08, 0xFD,
  0x0D, 0x20, 0xEF, 0xC0, 0xE7, 0x75, 0x0D, 0xFD, 0x09, 0x20, 0xEF, 0xC0, 0xE7, 0x74, 0x05, 0xFE,
  0x05, 0x20, 0xEF, 0xC0, 0xE7, 0x74, 0x0C, 0xFD, 0x0E, 0x30, 0xEF, 0xC0, 0xE7, 0x73, 0x06, 0xFE,
  0x09, 0x30, 0xEF, 0xC0, 0xE7, 0x72, 0x02, 0x0E, 0xFE, 0x03, 0x30, 0xEF, 0xC0, 0xE7, 0x71, 0x01,
  0x0D, 0xFE, 0x0A, 0x40, 0xEF, 0xC0, 0xE7, 0x70, 0x30, 0xDF, 0xF0, 0x34, 0x0E, 0xFC, 0x0E, 0x76,
  0x07, 0xFF, 0x90, 0xA5, 0x0E, 0xFC, 0x0E, 0x73, 0x81, 0x38, 0xEF, 0xF9, 0x0E, 0x01, 0x50, 0xEF,
  0xC0, 0xE8, 0x02, 0x88, 0x29, 0xAC, 0xEF, 0xFC, 0x05, 0x60, 0xE8, 0x0C, 0x3F, 0x08, 0x70, 0xE8,
  0x0C, 0x2F, 0x0B, 0x71, 0x0E, 0x80, 0xC1, 0xF0, 0xB7, 0x20, 0xE8, 0x0C, 0x0F, 0x0A, 0x73, 0x0E,
  0xFF, 0xFF, 0xF0, 0x77, 0x40, 0xEF, 0xFF, 0xFD, 0x0D, 0x04, 0x75, 0x0E, 0xFF, 0xFF, 0xB0, 0xE0,
  0x87, 0x70, 0xEF, 0xFF, 0xF9, 0x81, 0xE8, 0x17, 0x71, 0x0E, 0xFF, 0xFD, 0x81, 0xEA, 0x47, 0x74,
  0x0E, 0xFF, 0xD8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x70,
  // "ď" (U+010F)
  0x77, 0x77, 0x10, 0x3F, 0xD0, 0x84, 0x0D, 0xFC, 0x03, 0x77, 0x77, 0x10, 0x3F, 0xD0, 0x84, 0xFC,
  0x0D, 0x77, 0x77, 0x20, 0x3F, 0xD0, 0x83, 0x02, 0xFC, 0x07, 0x77, 0x77, 0x20, 0x3F, 0xD0, 0x83,
  0x05, 0xFB, 0x0E, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0x83, 0x08, 0xFB, 0x07, 0x77, 0x77, 0x30, 0x3F,
  0xD0, 0x83, 0x0B, 0xFA, 0x0E, 0x77, 0x77, 0x40, 0x3F, 0xD0, 0x83, 0x0E, 0xFA, 0x07, 0x77, 0x77,
  0x40, 0x3F, 0xD0, 0x82, 0x02, 0xFA, 0x0D, 0x77, 0x77, 0x50, 0x3F, 0xD0, 0x82, 0x05, 0xFA, 0x05,
  0x77, 0x77, 0x50, 0x3F, 0xD0, 0x82, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x60, 0x3F, 0xD0, 0x82, 0x0D,
  0xF9, 0x03, 0x77, 0x77, 0x60, 0x3F, 0xD8, 0x18, 0x01, 0xF9, 0x09, 0x77, 0x77, 0x70, 0x3F, 0xD8,
  0x18, 0x05, 0xF0, 0xE0, 0x17, 0x77, 0x77, 0x03, 0xFD, 0x81, 0x80, 0x7F, 0x05, 0x80, 0xC0, 0x00,
  0x3F, 0xD0, 0x88, 0x0D, 0x20, 0x03, 0xFD, 0x08, 0x80, 0xD2, 0x00, 0x2F, 0xD0, 0x88, 0x0D, 0x20,
  0x02, 0xFD, 0x08, 0x77, 0x77, 0x18, 0x92, 0x16, 0x9C, 0xDE, 0xFE, 0xC9, 0x51, 0x50, 0x1F, 0xD0,
  0x87, 0x77, 0x60, 0x30, 0xAF, 0xD0, 0x80, 0x14, 0xFD, 0x08, 0x77, 0x75, 0x09, 0xFF, 0x90, 0xD0,
  0x33, 0x0D, 0xFC, 0x08, 0x77, 0x73, 0x01, 0x0D, 0xFF, 0xC0, 0x52, 0x0B, 0xFC, 0x08, 0x77, 0x72,
  0x01, 0x0D, 0xFF, 0xE8, 0x14, 0x09, 0xFC, 0x08, 0x77, 0x72, 0x0C, 0xFF, 0xF8, 0x1E, 0x27, 0xFC,
  0x08, 0x77, 0x71, 0x09, 0xFF, 0xFA, 0x0D, 0x05, 0xFC, 0x08, 0x77, 0x70, 0x48, 0x0C, 0x1F, 0x08,
  0x77, 0x70, 0xC8, 0x0C, 0x1F, 0x08, 0x77, 0x60, 0x58, 0x0C, 0x2F, 0x08, 0x77, 0x60, 0xBF, 0xF9,
  0x84, 0xEA, 0x98, 0xAD, 0xFF, 0xB0, 0x87, 0x75, 0x02, 0xFF, 0x0D, 0x05, 0x60, 0x30, 0xBF, 0xF9,
  0x08, 0x77, 0x50, 0x7F, 0xE0, 0xD0, 0x17, 0x20, 0x8F, 0xF0, 0x87, 0x75, 0x0B, 0xFE, 0x02, 0x74,
  0x0B, 0xFE, 0x08, 0x77, 0x5F, 0xE0, 0x97, 0x50, 0x2F, 0xE0, 0x87, 0x74, 0x04, 0xFE, 0x02, 0x76,
  0x0B, 0xFD, 0x08, 0x77, 0x40, 0x7F, 0xD0, 0xD7, 0x70, 0x6F, 0xD0, 0x87, 0x74, 0x0A, 0xFD, 0x09,
  0x77, 0x01, 0xFD, 0x08, 0x77, 0x40, 0xCF, 0xD0, 0x77, 0x71, 0x0D, 0xFC, 0x08, 0x77, 0x40, 0xEF,
  0xD0, 0x47, 0x71, 0x0A, 0xFC, 0x08, 0x77, 0x4F, 0xE0, 0x27, 0x71, 0x08, 0xFC, 0x08, 0x77, 0x30,
  0x2F, 0xE0, 0x17, 0x71, 0x07, 0xFC, 0x08, 0x77, 0x30, 0x3F, 0xE7, 0x72, 0x05, 0xFC, 0x08, 0x77,
  0x30, 0x3F, 0xE7, 0x72, 0x04, 0xFC, 0x08, 0x77, 0x30, 0x4F, 0xD0, 0xE7, 0x72, 0x04, 0xFC, 0x08,
  0x77, 0x30, 0x4F, 0xD0, 0xE7, 0x72, 0x03, 0xFC, 0x08, 0x77, 0x30, 0x4F, 0xD0, 0xE7, 0x72, 0x03,
  0xFC, 0x08, 0x77, 0x30, 0x3F, 0xE7, 0x72, 0x03, 0xFC, 0x08, 0x77, 0x30, 0x3F, 0xE7, 0x72, 0x04,
  0xFC, 0x08, 0x77, 0x30, 0x2F, 0xE0, 0x27, 0x71, 0x05, 0xFC, 0x08, 0x77, 0x4F, 0xE0, 0x37, 0x71,
  0x06, 0xFC, 0x08, 0x77, 0x40, 0xEF, 0xD0, 0x57, 0x71, 0x09, 0xFC, 0x08, 0x77, 0x40, 0xCF, 0xD0,
  0x87, 0x71, 0x0B, 0xFC, 0x08, 0x77, 0x40, 0xAF, 0xD0, 0xB7, 0x71, 0x0E, 0xFC, 0x08, 0x77, 0x40,
  0x7F, 0xE7, 0x70, 0x4F, 0xD0, 0x87, 0x74, 0x04, 0xFE, 0x05, 0x76, 0x0A, 0xFD, 0x08, 0x77, 0x40,
  0x1F, 0xE0, 0xC7, 0x50, 0x3F, 0xE0, 0x87, 0x75, 0x0C, 0xFE, 0x06, 0x74, 0x0C, 0xFE, 0x08, 0x77,
  0x50, 0x8F, 0xF0, 0x47, 0x20, 0xBF, 0xF0, 0x87, 0x75, 0x03, 0xFF, 0x90, 0x76, 0x04, 0x0D, 0xFF,
  0x90, 0x87, 0x76, 0x0D, 0xFF, 0x98, 0x4E, 0xB9, 0x9A, 0xEF, 0xFB, 0x08, 0x77, 0x60, 0x68, 0x0C,
  0x2F, 0x08, 0x77, 0x70, 0xD8, 0x0C, 0x1F, 0x08, 0x77, 0x70, 0x6F, 0xFF, 0xB0, 0xEF, 0xD0, 0x87,
  0x77, 0x10, 0xBF, 0xFF, 0x98, 0x1D, 0x1C, 0xFC, 0x08, 0x77, 0x71, 0x02, 0x0E, 0xFF, 0xF8, 0x14,
  0x05, 0xFC, 0x08, 0x77, 0x72, 0x03, 0xFF, 0xE0, 0x53, 0x0D, 0xFB, 0x08, 0x77, 0x73, 0x04, 0x0E,
  0xFF, 0xB0, 0x54, 0x07, 0xFB, 0x08, 0x77, 0x74, 0x02, 0x0D, 0xFF, 0x0D, 0x03, 0x60, 0xEF, 0xA0,
  0x87, 0x77, 0x60, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x10, 0x8F, 0xA0, 0x87, 0x77, 0x71, 0x89, 0x04,
  0x8C, 0xDE, 0xFE, 0xC9, 0x48, 0x0C, 0x20,
  // "Đ" (U+0110)
  0x40, 0xEF, 0xFE, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x77, 0x30, 0xEF, 0xFF, 0xE8, 0x1D, 0x93, 0x77,
  0x70, 0xEF, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x50, 0xEF, 0xFF, 0xFC, 0x0D, 0x05, 0x77, 0x30, 0xEF,
  0xFF, 0xFE, 0x0B, 0x01, 0x77, 0x10, 0xEF, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x0E, 0x80, 0xC1, 0xF0,
  0x57, 0x60, 0xE8, 0x0C, 0x2F, 0x06, 0x75, 0x0E, 0x80, 0xC3, 0xF0, 0x57, 0x40, 0xE8, 0x0C, 0x3F,
  0x0E, 0x03, 0x73, 0x0E, 0xFC, 0x0E, 0x80, 0x38, 0x81, 0x9A, 0xCF, 0xFC, 0x0D, 0x73, 0x0E, 0xFC,
  0x0E, 0x74, 0x04, 0x0A, 0xFF, 0xA0, 0x87, 0x20, 0xEF, 0xC0, 0xE7, 0x60, 0x20, 0xBF, 0xF9, 0x02,
  0x71, 0x0E, 0xFC, 0x0E, 0x77, 0x10, 0x8F, 0xF0, 0xA7, 0x10, 0xEF, 0xC0, 0xE7, 0x72, 0x07, 0xFF,
  0x02, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x0A, 0xFE, 0x09, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x01, 0x0E,
  0xFD, 0x0E, 0x70, 0xEF, 0xC0, 0xE7, 0x74, 0x07, 0xFE, 0x05, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x0E,
  0xFD, 0x09, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x09, 0xFD, 0x0D, 0x60, 0xEF, 0xC0, 0xE7, 0x75, 0x04,
  0xFE, 0x02, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0xFE, 0x05, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x0B, 0xFD,
  0x08, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x09, 0xFD, 0x0B, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x06, 0xFD,
  0x0D, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x04, 0xFD, 0x0E, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x02, 0xFE,
  0x1F, 0xFF, 0xD0, 0x77, 0x30, 0x1F, 0xE0, 0x2F, 0xFF, 0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0,
  0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0, 0x77, 0x40, 0xEF, 0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x40, 0xEF,
  0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x40, 0xEF, 0xD0, 0x4F, 0xFF, 0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF,
  0xD0, 0x77, 0x4F, 0xE0, 0x3F, 0xFF, 0xD0, 0x77, 0x30, 0x1F, 0xE0, 0x2F, 0xFF, 0xD0, 0x77, 0x30,
  0x2F, 0xE1, 0x80, 0x08, 0xFD, 0x0E, 0x80, 0x58, 0x03, 0x73, 0x04, 0xFD, 0x0E, 0x50, 0xEF, 0xC0,
  0xE7, 0x76, 0x06, 0xFD, 0x0D, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x08, 0xFD, 0x0A, 0x50, 0xEF, 0xC0,
  0xE7, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xEF, 0xC0, 0xE7, 0x76, 0x0E, 0xFD, 0x05, 0x50, 0xEF, 0xC0,
  0xE7, 0x75, 0x03, 0xFE, 0x02, 0x50, 0xEF, 0xC0, 0xE7, 0x75, 0x08, 0xFD, 0x0D, 0x60, 0xEF, 0xC0,
  0xE7, 0x75, 0x0D, 0xFD, 0x09, 0x60, 0xEF, 0xC0, 0xE7, 0x74, 0x05, 0xFE, 0x05, 0x60, 0xEF, 0xC0,
  0xE7, 0x74, 0x0C, 0xFD, 0x0E, 0x70, 0xEF, 0xC0, 0xE7, 0x73, 0x06, 0xFE, 0x09, 0x70, 0xEF, 0xC0,
  0xE7, 0x72, 0x02, 0x0E, 0xFE, 0x03, 0x70, 0xEF, 0xC0, 0xE7, 0x71, 0x01, 0x0D, 0xFE, 0x0A, 0x71,
  0x0E, 0xFC, 0x0E, 0x77, 0x03, 0x0D, 0xFF, 0x03, 0x71, 0x0E, 0xFC, 0x0E, 0x76, 0x07, 0xFF, 0x90,
  0xA7, 0x20, 0xEF, 0xC0, 0xE7, 0x38, 0x13, 0x8E, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0xEF, 0xC0, 0xE8,
  0x02, 0x88, 0x29, 0xAC, 0xEF, 0xFC, 0x05, 0x73, 0x0E, 0x80, 0xC3, 0xF0, 0x87, 0x40, 0xE8, 0x0C,
  0x2F, 0x0B, 0x75, 0x0E, 0x80, 0xC1, 0xF0, 0xB7, 0x60, 0xE8, 0x0C, 0x0F, 0x0A, 0x77, 0x0E, 0xFF,
  0xFF, 0xF0, 0x77, 0x71, 0x0E, 0xFF, 0xFF, 0xD0, 0xD0, 0x47, 0x72, 0x0E, 0xFF, 0xFF, 0xB0, 0xE0,
  0x87, 0x74, 0x0E, 0xFF, 0xFF, 0x98, 0x1E, 0x81, 0x77, 0x50, 0xEF, 0xFF, 0xD8, 0x1E, 0xA4, 0x77,
  0x71, 0x0E, 0xFF, 0xD8, 0x5E, 0xDC, 0xA8, 0x62, 0x77, 0x70,
  // "đ" (U+0111)
  0x77, 0x77, 0x50, 0xBF, 0xD8, 0x0C, 0x20, 0x0B, 0xFD, 0x80, 0xC2, 0x00, 0xBF, 0xD8, 0x0C, 0x20,
  0x0B, 0xFD, 0x80, 0xC2, 0x00, 0xBF, 0xD8, 0x0C, 0x20, 0x0B, 0xFD, 0x80, 0xC2, 0x00, 0xBF, 0xD7,
  0x77, 0x40, 0x8F, 0xFF, 0xFA, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x77,
  0x60, 0x8F, 0xFF, 0xFA, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x77, 0x60,
  0x8F, 0xFF, 0xFA, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x77, 0x77, 0x50, 0xBF, 0xD8, 0x0C, 0x20, 0x0A,
  0xFD, 0x80, 0xC2, 0x00, 0xAF, 0xD8, 0x0C, 0x20, 0x09, 0xFD, 0x77, 0x48, 0x41, 0x58, 0xBD, 0xEA,
  0x83, 0xEC, 0xA7, 0x37, 0x08, 0xFD, 0x77, 0x20, 0x40, 0xAF, 0xE0, 0xD0, 0x65, 0x07, 0xFD, 0x77,
  0x02, 0x0B, 0xFF, 0xB0, 0xD0, 0x43, 0x05, 0xFD, 0x76, 0x06, 0xFF, 0xF0, 0x82, 0x03, 0xFD, 0x75,
  0x07, 0xFF, 0xFA, 0x81, 0xA0, 0x1F, 0xD7, 0x40, 0x7F, 0xFF, 0xC8, 0x19, 0x0E, 0xFC, 0x73, 0x04,
  0xFF, 0xFE, 0x06, 0x0C, 0xFC, 0x72, 0x01, 0x0E, 0x80, 0xC4, 0xF7, 0x20, 0xA8, 0x0C, 0x5F, 0x71,
  0x03, 0x80, 0xC6, 0xF7, 0x10, 0xAF, 0xFB, 0x85, 0xEB, 0x98, 0x9A, 0xEF, 0xFC, 0x70, 0x1F, 0xFA,
  0x0A, 0x03, 0x70, 0x40, 0xBF, 0xFA, 0x70, 0x7F, 0xF0, 0xE0, 0x47, 0x40, 0x8F, 0xF9, 0x70, 0xCF,
  0xE0, 0xE0, 0x37, 0x60, 0x9F, 0xF6, 0x01, 0xFF, 0x05, 0x77, 0x10, 0xDF, 0xE6, 0x05, 0xFE, 0x0C,
  0x77, 0x20, 0x5F, 0xE6, 0x08, 0xFE, 0x04, 0x77, 0x30, 0xEF, 0xD6, 0x0B, 0xFD, 0x0E, 0x77, 0x40,
  0x9F, 0xD6, 0x0E, 0xFD, 0x0A, 0x77, 0x40, 0x6F, 0xD6, 0xFE, 0x06, 0x77, 0x40, 0x3F, 0xD5, 0x02,
  0xFE, 0x03, 0x77, 0x5F, 0xD5, 0x04, 0xFE, 0x01, 0x77, 0x50, 0xEF, 0xC5, 0x04, 0xFE, 0x77, 0x60,
  0xDF, 0xC5, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0xCF, 0xC5, 0x06, 0xFD, 0x0D, 0x77, 0x60, 0xBF, 0xC5,
  0x06, 0xFD, 0x0D, 0x77, 0x60, 0xBF, 0xC5, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xBF, 0xC5, 0x05, 0xFD,
  0x0E, 0x77, 0x60, 0xCF, 0xC5, 0x04, 0xFE, 0x77, 0x60, 0xDF, 0xC5, 0x02, 0xFE, 0x01, 0x77, 0x50,
  0xDF, 0xC5, 0x01, 0xFE, 0x03, 0x77, 0x5F, 0xD6, 0x0E, 0xFD, 0x06, 0x77, 0x40, 0x3F, 0xD6, 0x0C,
  0xFD, 0x0A, 0x77, 0x40, 0x7F, 0xD6, 0x09, 0xFD, 0x0E, 0x77, 0x40, 0xCF, 0xD6, 0x06, 0xFE, 0x06,
  0x77, 0x20, 0x3F, 0xE6, 0x02, 0xFE, 0x0E, 0x01, 0x77, 0x10, 0xCF, 0xE7, 0x0D, 0xFE, 0x0A, 0x77,
  0x08, 0xFF, 0x70, 0x8F, 0xF0, 0xA7, 0x50, 0x9F, 0xF9, 0x70, 0x2F, 0xF9, 0x81, 0xE6, 0x17, 0x05,
  0x0D, 0xFF, 0xA7, 0x10, 0xCF, 0xFB, 0x84, 0xCA, 0x88, 0xAC, 0xFF, 0xD7, 0x10, 0x58, 0x0C, 0x6F,
  0x72, 0x0C, 0x80, 0xC5, 0xF7, 0x20, 0x3F, 0xFF, 0xF0, 0xEF, 0xD7, 0x30, 0x8F, 0xFF, 0xD0, 0x70,
  0x4F, 0xD7, 0x40, 0xBF, 0xFF, 0xB0, 0xA2, 0x0D, 0xFC, 0x75, 0x0B, 0xFF, 0xF9, 0x0B, 0x30, 0x6F,
  0xC7, 0x60, 0xAF, 0xFE, 0x09, 0x50, 0xEF, 0xB7, 0x70, 0x60, 0xEF, 0xFA, 0x0D, 0x05, 0x60, 0x7F,
  0xB7, 0x71, 0x81, 0x17, 0xEF, 0xD0, 0xD0, 0x67, 0x10, 0x1F, 0xB7, 0x74, 0x83, 0x47, 0xBD, 0xEA,
  0x83, 0xEC, 0xA7, 0x27, 0x77, 0x50,
  // "Ē" (U+0112)
  0x70, 0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x60,
  0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F,
  0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xD0, 0xA8, 0x0C, 0xC1, 0x00,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8,
  0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15,
  0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C,
  0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "ē" (U+0113)
  0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0,
  0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xCD, 0x00, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77, 0x77, 0x81,
  0x17, 0xCF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x20, 0x10, 0x8F, 0xFF, 0x0C, 0x04, 0x77, 0x60, 0x7F,
  0xFF, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x02, 0x0D, 0xFF, 0xFF,
  0xA0, 0x57, 0x50, 0x20, 0xEF, 0xFF, 0xFC, 0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xE0, 0x27,
  0x20, 0xBF, 0xFF, 0xFF, 0x0C, 0x71, 0x06, 0x80, 0xC1, 0xF0, 0x66, 0x01, 0x0E, 0xFF, 0xA8, 0x4C,
  0xA8, 0x8A, 0xCF, 0xF9, 0x0E, 0x60, 0x8F, 0xF8, 0x1D, 0x61, 0x68, 0x11, 0x7E, 0xFE, 0x06, 0x40,
  0x1F, 0xF0, 0x87, 0x40, 0x10, 0xBF, 0xD0, 0xC4, 0x06, 0xFE, 0x05, 0x77, 0x0A, 0xFD, 0x02, 0x30,
  0xCF, 0xD0, 0x67, 0x72, 0x0C, 0xFC, 0x07, 0x20, 0x2F, 0xD0, 0xC7, 0x73, 0x04, 0xFC, 0x0B, 0x20,
  0x6F, 0xD0, 0x57, 0x74, 0x0D, 0xFB, 0x0E, 0x20, 0xAF, 0xC0, 0xE7, 0x75, 0x08, 0xFC, 0x81, 0x10,
  0xDF, 0xC0, 0xB7, 0x75, 0x05, 0xFC, 0x03, 0x1F, 0xD0, 0x87, 0x75, 0x03, 0xFC, 0x05, 0x02, 0x80,
  0xD0, 0xF0, 0x60, 0x48, 0x0D, 0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x00,
  0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0,
  0x70, 0x58, 0x0D, 0x0F, 0x07, 0x03, 0xFD, 0x03, 0x77, 0x77, 0x40, 0x2F, 0xD0, 0x57, 0x77, 0x75,
  0x0E, 0xFC, 0x08, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xD7, 0x77, 0x75, 0x08, 0xFD, 0x04, 0x77, 0x77,
  0x40, 0x4F, 0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x77, 0x77, 0x40, 0x9F, 0xE0, 0x77, 0x77,
  0x73, 0x02, 0xFF, 0x09, 0x77, 0x72, 0x81, 0x16, 0xC5, 0x0B, 0xFF, 0x0D, 0x06, 0x77, 0x48, 0x12,
  0x6B, 0xB0, 0x14, 0x03, 0xFF, 0xA8, 0x1E, 0x94, 0x74, 0x82, 0x35, 0x9D, 0xE0, 0x15, 0x09, 0xFF,
  0xD8, 0x7D, 0xB9, 0x88, 0x9A, 0xBD, 0xFC, 0x01, 0x60, 0xD8, 0x0C, 0x2F, 0x01, 0x60, 0x20, 0xE8,
  0x0C, 0x1F, 0x01, 0x70, 0x48, 0x0C, 0x1F, 0x01, 0x71, 0x04, 0x0E, 0xFF, 0xFF, 0xF0, 0x17, 0x20,
  0x20, 0xDF, 0xFF, 0xFE, 0x01, 0x73, 0x01, 0x09, 0xFF, 0xFF, 0xD0, 0x17, 0x50, 0x40, 0xCF, 0xFF,
  0xFA, 0x0D, 0x77, 0x10, 0x40, 0xBF, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x81, 0x16, 0xBF, 0xFD, 0x82,
  0xEA, 0x51, 0x77, 0x73, 0x85, 0x36, 0x9A, 0xCD, 0xEA, 0x87, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x20,
  // "Ĕ" (U+0114)
  0x60, 0x68, 0x02, 0x70, 0x57, 0x70, 0x18, 0x03, 0x70, 0x27, 0x30, 0xBE, 0x0C, 0x77, 0x04, 0xF0,
  0x47, 0x30, 0xAF, 0x01, 0x76, 0x09, 0xF0, 0x27, 0x30, 0x8F, 0x0A, 0x75, 0x02, 0x0E, 0xF7, 0x40,
  0x4F, 0x90, 0x97, 0x30, 0x30, 0xDF, 0x0B, 0x75, 0xFA, 0x82, 0xE9, 0x41, 0x28, 0x21, 0x36, 0xBF,
  0xA0, 0x77, 0x50, 0xAF, 0xFF, 0xE0, 0x27, 0x50, 0x3F, 0xFF, 0xD0, 0x97, 0x70, 0xAF, 0xFF, 0xB0,
  0xE0, 0x17, 0x70, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x72, 0x03, 0x0E, 0xFF, 0xF0, 0x67, 0x74, 0x03,
  0x0D, 0xFF, 0xD0, 0x67, 0x76, 0x01, 0x0B, 0xFF, 0xA0, 0xD0, 0x37, 0x77, 0x20, 0x40, 0xBF, 0xD0,
  0xD0, 0x57, 0x77, 0x68, 0x92, 0x26, 0xAC, 0xDE, 0xFD, 0xCA, 0x62, 0x80, 0xC8, 0x00, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50,
  0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8,
  0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C,
  0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A,
  // "ĕ" (U+0115)
  0x72, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x10, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x71, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x10, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x72, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x73, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x73, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x30, 0x3F, 0xFF, 0xD0, 0x97,
  0x75, 0x0A, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x03, 0x0E,
  0xFF, 0xF0, 0x67, 0x77, 0x20, 0x30, 0xDF, 0xFD, 0x06, 0x77, 0x74, 0x01, 0x0B, 0xFF, 0xA0, 0xD0,
  0x37, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x74, 0x89, 0x22, 0x6A, 0xCD, 0xEF, 0xDC,
  0xA6, 0x28, 0x0C, 0x82, 0x08, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x78,
  0x11, 0x7C, 0xFF, 0x98, 0x1E, 0xA4, 0x77, 0x72, 0x01, 0x08, 0xFF, 0xF0, 0xC0, 0x47, 0x76, 0x07,
  0xFF, 0xFC, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xE0, 0xE0, 0x47, 0x70, 0x20, 0xDF, 0xFF,
  0xFA, 0x05, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xC0, 0x47, 0x30, 0x10, 0xDF, 0xFF, 0xFD, 0x0E, 0x02,
  0x72, 0x0B, 0xFF, 0xFF, 0xF0, 0xC7, 0x10, 0x68, 0x0C, 0x1F, 0x06, 0x60, 0x10, 0xEF, 0xFA, 0x84,
  0xCA, 0x88, 0xAC, 0xFF, 0x90, 0xE6, 0x08, 0xFF, 0x81, 0xD6, 0x16, 0x81, 0x17, 0xEF, 0xE0, 0x64,
  0x01, 0xFF, 0x08, 0x74, 0x01, 0x0B, 0xFD, 0x0C, 0x40, 0x6F, 0xE0, 0x57, 0x70, 0xAF, 0xD0, 0x23,
  0x0C, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xC0, 0x72, 0x02, 0xFD, 0x0C, 0x77, 0x30, 0x4F, 0xC0, 0xB2,
  0x06, 0xFD, 0x05, 0x77, 0x40, 0xDF, 0xB0, 0xE2, 0x0A, 0xFC, 0x0E, 0x77, 0x50, 0x8F, 0xC8, 0x11,
  0x0D, 0xFC, 0x0B, 0x77, 0x50, 0x5F, 0xC0, 0x31, 0xFD, 0x08, 0x77, 0x50, 0x3F, 0xC0, 0x50, 0x28,
  0x0D, 0x0F, 0x06, 0x04, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0,
  0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x07, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F,
  0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x3F, 0xD0, 0x37, 0x77, 0x74, 0x02, 0xFD, 0x05, 0x77, 0x77,
  0x50, 0xEF, 0xC0, 0x87, 0x77, 0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x50, 0x8F, 0xD0, 0x47, 0x77,
  0x74, 0x04, 0xFD, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0xD0, 0x87, 0x77, 0x74, 0x09, 0xFE, 0x07, 0x77,
  0x77, 0x30, 0x2F, 0xF0, 0x97, 0x77, 0x28, 0x11, 0x6C, 0x50, 0xBF, 0xF0, 0xD0, 0x67, 0x74, 0x81,
  0x26, 0xBB, 0x01, 0x40, 0x3F, 0xFA, 0x81, 0xE9, 0x47, 0x48, 0x23, 0x59, 0xDE, 0x01, 0x50, 0x9F,
  0xFD, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xDF, 0xC0, 0x16, 0x0D, 0x80, 0xC2, 0xF0, 0x16, 0x02, 0x0E,
  0x80, 0xC1, 0xF0, 0x17, 0x04, 0x80, 0xC1, 0xF0, 0x17, 0x10, 0x40, 0xEF, 0xFF, 0xFF, 0x01, 0x72,
  0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0x17, 0x30, 0x10, 0x9F, 0xFF, 0xFD, 0x01, 0x75, 0x04, 0x0C, 0xFF,
  0xFF, 0xA0, 0xD7, 0x71, 0x04, 0x0B, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x48, 0x11, 0x6B, 0xFF, 0xD8,
  0x2E, 0xA5, 0x17, 0x77, 0x38, 0x53, 0x69, 0xAC, 0xDE, 0xA8, 0x7E, 0xED, 0xCB, 0x97, 0x42, 0x72,
  // "Ė" (U+0116)
  0x77, 0x28, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x20, 0x7F, 0xB0, 0x77, 0x77, 0x70,
  0x8F, 0xD0, 0x77, 0x77, 0x50, 0x2F, 0xF0, 0x17, 0x77, 0x40, 0x9F, 0xF0, 0x77, 0x77, 0x40, 0xCF,
  0xF0, 0xB7, 0x77, 0x40, 0xEF, 0xF0, 0xD7, 0x77, 0x4F, 0xF9, 0x0D, 0x77, 0x74, 0x0E, 0xFF, 0x0D,
  0x77, 0x74, 0x0C, 0xFF, 0x0B, 0x77, 0x74, 0x09, 0xFF, 0x07, 0x77, 0x74, 0x02, 0xFE, 0x0E, 0x01,
  0x77, 0x75, 0x08, 0xFD, 0x06, 0x77, 0x77, 0x08, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x28, 0x90, 0x28,
  0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xC8, 0x10, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8,
  0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C,
  0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F,
  0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81,
  0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  // "ė" (U+0117)
  0x77, 0x58, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x70, 0x7F, 0xB0, 0x77, 0x77, 0x75,
  0x08, 0xFD, 0x07, 0x77, 0x77, 0x30, 0x2F, 0xF0, 0x17, 0x77, 0x72, 0x09, 0xFF, 0x07, 0x77, 0x77,
  0x20, 0xCF, 0xF0, 0xB7, 0x77, 0x72, 0x0E, 0xFF, 0x0D, 0x77, 0x77, 0x2F, 0xF9, 0x0D, 0x77, 0x77,
  0x20, 0xEF, 0xF0, 0xD7, 0x77, 0x72, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x20, 0x9F, 0xF0, 0x77, 0x77,
  0x72, 0x02, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x30, 0x8F, 0xD0, 0x67, 0x77, 0x75, 0x08, 0xFA, 0x0E,
  0x06, 0x77, 0x77, 0x78, 0x90, 0x28, 0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xC8, 0x30, 0x85, 0x15, 0x7A,
  0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77, 0x77, 0x81, 0x17, 0xCF, 0xF9, 0x81, 0xEA, 0x47, 0x77,
  0x20, 0x10, 0x8F, 0xFF, 0x0C, 0x04, 0x77, 0x60, 0x7F, 0xFF, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B,
  0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x02, 0x0D, 0xFF, 0xFF, 0xA0, 0x57, 0x50, 0x20, 0xEF, 0xFF, 0xFC,
  0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xE0, 0x27, 0x20, 0xBF, 0xFF, 0xFF, 0x0C, 0x71, 0x06,
  0x80, 0xC1, 0xF0, 0x66, 0x01, 0x0E, 0xFF, 0xA8, 0x4C, 0xA8, 0x8A, 0xCF, 0xF9, 0x0E, 0x60, 0x8F,
  0xF8, 0x1D, 0x61, 0x68, 0x11, 0x7E, 0xFE, 0x06, 0x40, 0x1F, 0xF0, 0x87, 0x40, 0x10, 0xBF, 0xD0,
  0xC4, 0x06, 0xFE, 0x05, 0x77, 0x0A, 0xFD, 0x02, 0x30, 0xCF, 0xD0, 0x67, 0x72, 0x0C, 0xFC, 0x07,
  0x20, 0x2F, 0xD0, 0xC7, 0x73, 0x04, 0xFC, 0x0B, 0x20, 0x6F, 0xD0, 0x57, 0x74, 0x0D, 0xFB, 0x0E,
  0x20, 0xAF, 0xC0, 0xE7, 0x75, 0x08, 0xFC, 0x81, 0x10, 0xDF, 0xC0, 0xB7, 0x75, 0x05, 0xFC, 0x03,
  0x1F, 0xD0, 0x87, 0x75, 0x03, 0xFC, 0x05, 0x02, 0x80, 0xD0, 0xF0, 0x60, 0x48, 0x0D, 0x0F, 0x07,
  0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F,
  0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0, 0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x03, 0xFD,
  0x03, 0x77, 0x77, 0x40, 0x2F, 0xD0, 0x57, 0x77, 0x75, 0x0E, 0xFC, 0x08, 0x77, 0x77, 0x50, 0xBF,
  0xC0, 0xD7, 0x77, 0x75, 0x08, 0xFD, 0x04, 0x77, 0x77, 0x40, 0x4F, 0xD0, 0xC7, 0x77, 0x75, 0x0E,
  0xFD, 0x08, 0x77, 0x77, 0x40, 0x9F, 0xE0, 0x77, 0x77, 0x73, 0x02, 0xFF, 0x09, 0x77, 0x72, 0x81,
  0x16, 0xC5, 0x0B, 0xFF, 0x0D, 0x06, 0x77, 0x48, 0x12, 0x6B, 0xB0, 0x14, 0x03, 0xFF, 0xA8, 0x1E,
  0x94, 0x74, 0x82, 0x35, 0x9D, 0xE0, 0x15, 0x09, 0xFF, 0xD8, 0x7D, 0xB9, 0x88, 0x9A, 0xBD, 0xFC,
  0x01, 0x60, 0xD8, 0x0C, 0x2F, 0x01, 0x60, 0x20, 0xE8, 0x0C, 0x1F, 0x01, 0x70, 0x48, 0x0C, 0x1F,
  0x01, 0x71, 0x04, 0x0E, 0xFF, 0xFF, 0xF0, 0x17, 0x20, 0x20, 0xDF, 0xFF, 0xFE, 0x01, 0x73, 0x01,
  0x09, 0xFF, 0xFF, 0xD0, 0x17, 0x50, 0x40, 0xCF, 0xFF, 0xFA, 0x0D, 0x77, 0x10, 0x40, 0xBF, 0xFF,
  0xD0, 0xA0, 0x47, 0x74, 0x81, 0x16, 0xBF, 0xFD, 0x82, 0xEA, 0x51, 0x77, 0x73, 0x85, 0x36, 0x9A,
  0xCD, 0xEA, 0x87, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x20,
  // "Ę" (U+0118)
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F,
  0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81,
  0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50,
  0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xC8, 0x0C, 0x2F, 0x81, 0x50, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0,
  0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7,
  0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77,
  0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70,
  0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF, 0xC0, 0xC7, 0x77, 0x70, 0xCF,
  0xC0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0xE0, 0x27, 0x77, 0x72, 0x03, 0x0E,
  0xE0, 0xE0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xF0, 0x47, 0x77, 0x72, 0x01, 0x0D, 0xF0, 0x77, 0x77,
  0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x30, 0xCF, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0x90, 0x77, 0x77, 0x73, 0x08, 0xF9, 0x04, 0x77, 0x77, 0x30, 0xBF, 0x90, 0x47, 0x77,
  0x73, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xC7, 0x77, 0x73, 0x0C, 0xFA, 0x0B, 0x03,
  0x28, 0x12, 0x59, 0x77, 0x73, 0x0A, 0xFF, 0xA7, 0x77, 0x30, 0x6F, 0xFA, 0x77, 0x73, 0x01, 0xFF,
  0xA7, 0x77, 0x40, 0x9F, 0xF9, 0x77, 0x75, 0x0C, 0xFF, 0x77, 0x75, 0x01, 0x0C, 0xFE, 0x77, 0x77,
  0x08, 0x0E, 0xFC, 0x77, 0x77, 0x18, 0x31, 0x6A, 0xDE, 0xA8, 0x3E, 0xC9, 0x61, 0x30,
  // "ę" (U+0119)
  0x77, 0x28, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x78, 0x11, 0x7C, 0xFF,
  0x98, 0x1E, 0x93, 0x77, 0x72, 0x01, 0x08, 0xFF, 0xF0, 0xB0, 0x37, 0x76, 0x07, 0xFF, 0xFC, 0x09,
  0x77, 0x30, 0x10, 0xBF, 0xFF, 0xE0, 0xD0, 0x27, 0x70, 0x20, 0xDF, 0xFF, 0xF9, 0x0E, 0x03, 0x75,
  0x02, 0x0E, 0xFF, 0xFF, 0xB0, 0xE0, 0x27, 0x30, 0x10, 0xDF, 0xFF, 0xFD, 0x0D, 0x73, 0x0B, 0xFF,
  0xFF, 0xF0, 0x97, 0x10, 0x68, 0x0C, 0x1F, 0x03, 0x60, 0x10, 0xEF, 0xFA, 0x84, 0xCA, 0x89, 0xAD,
  0xFF, 0x90, 0xB6, 0x08, 0xFF, 0x81, 0xE8, 0x16, 0x02, 0x09, 0xFF, 0x04, 0x40, 0x1F, 0xF0, 0xB0,
  0x17, 0x30, 0x20, 0xDF, 0xD0, 0xA4, 0x06, 0xFE, 0x09, 0x76, 0x01, 0x0D, 0xFD, 0x01, 0x30, 0xCF,
  0xD0, 0xB7, 0x71, 0x02, 0x0E, 0xFC, 0x05, 0x20, 0x2F, 0xE0, 0x27, 0x72, 0x08, 0xFC, 0x09, 0x20,
  0x6F, 0xD0, 0x87, 0x73, 0x01, 0xFC, 0x0C, 0x20, 0xAF, 0xD0, 0x37, 0x74, 0x0B, 0xFC, 0x20, 0xDF,
  0xC0, 0xD7, 0x75, 0x07, 0xFC, 0x02, 0x1F, 0xD0, 0xA7, 0x75, 0x05, 0xFC, 0x04, 0x02, 0xFD, 0x08,
  0x77, 0x50, 0x3F, 0xC0, 0x50, 0x48, 0x0D, 0x0F, 0x06, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D,
  0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80,
  0xD0, 0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x03, 0x80, 0xD0, 0xF0, 0x70, 0x2F, 0xD0, 0x37, 0x77,
  0x75, 0x0E, 0xFC, 0x05, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0x97, 0x77, 0x75, 0x08, 0xFC, 0x0E, 0x77,
  0x77, 0x50, 0x4F, 0xD0, 0x77, 0x77, 0x75, 0x0E, 0xFD, 0x03, 0x77, 0x77, 0x40, 0x9F, 0xD0, 0xE0,
  0x27, 0x77, 0x73, 0x02, 0xFE, 0x0E, 0x05, 0x77, 0x73, 0x02, 0x07, 0x50, 0xBF, 0xF0, 0xB0, 0x37,
  0x75, 0x81, 0x38, 0xDA, 0x01, 0x40, 0x3F, 0xFA, 0x81, 0xC7, 0x37, 0x48, 0x22, 0x47, 0xBE, 0x01,
  0x50, 0x9F, 0xFD, 0x87, 0xCA, 0x98, 0x89, 0xAB, 0xCF, 0xC0, 0x16, 0x0D, 0x80, 0xC2, 0xF0, 0x16,
  0x02, 0x0E, 0x80, 0xC1, 0xF0, 0x17, 0x04, 0x80, 0xC1, 0xF0, 0x17, 0x10, 0x40, 0xEF, 0xFF, 0xFF,
  0x01, 0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0x17, 0x30, 0x10, 0x9F, 0xFF, 0xFD, 0x01, 0x75, 0x04,
  0x0C, 0xFF, 0xFF, 0xA0, 0xE7, 0x71, 0x04, 0x0B, 0xFF, 0xFE, 0x0A, 0x01, 0x77, 0x38, 0x11, 0x6B,
  0xFF, 0xFA, 0x06, 0x77, 0x72, 0x85, 0x36, 0x9A, 0xCD, 0xEF, 0xE0, 0xE0, 0x37, 0x77, 0x77, 0x0A,
  0xF0, 0xE0, 0x37, 0x77, 0x77, 0x07, 0xF0, 0xE0, 0x37, 0x77, 0x77, 0x04, 0xF9, 0x05, 0x80, 0xC0,
  0x00, 0xDF, 0x0A, 0x80, 0xC0, 0x00, 0x7F, 0x90, 0x28, 0x0C, 0x00, 0x0E, 0xF0, 0xA8, 0x0C, 0x00,
  0x06, 0xF9, 0x05, 0x80, 0xC0, 0x00, 0xBF, 0x90, 0x28, 0x0C, 0x00, 0x0E, 0xF9, 0x01, 0x80, 0xC0,
  0x0F, 0xA0, 0x17, 0x77, 0x77, 0x01, 0xFA, 0x04, 0x77, 0x77, 0x70, 0x1F, 0xA0, 0xB8, 0x0C, 0x00,
  0xFB, 0x0A, 0x02, 0x28, 0x12, 0x68, 0x77, 0x77, 0x10, 0xCF, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x8F,
  0xF9, 0x0C, 0x77, 0x77, 0x10, 0x2F, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x9F, 0xF0, 0xC7, 0x77, 0x73,
  0x0D, 0xFE, 0x0C, 0x77, 0x77, 0x30, 0x10, 0xCF, 0xD0, 0xC7, 0x77, 0x75, 0x08, 0x0E, 0xFB, 0x0C,
  0x77, 0x77, 0x68, 0x31, 0x69, 0xDE, 0xA8, 0x2E, 0xC9, 0x54,
  // "Ě" (U+011A)
  0x40, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x70, 0x6F, 0x90, 0xB0, 0x17, 0x50,
  0x10, 0xBF, 0x90, 0x67, 0x10, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7, 0x20, 0x10,
  0xDF, 0x90, 0xE0, 0x47, 0x10, 0x6F, 0xA0, 0xD0, 0x17, 0x30, 0x20, 0xEF, 0xA0, 0x56, 0x08, 0xFB,
  0x03, 0x75, 0x04, 0xFB, 0x07, 0x40, 0x9F, 0xB0, 0x57, 0x70, 0x8F, 0xB0, 0x62, 0x09, 0xFB, 0x09,
  0x77, 0x20, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x73, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x74,
  0x04, 0xFF, 0xE0, 0x47, 0x76, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x10, 0xCF, 0xFA, 0x0C, 0x77, 0x72,
  0x02, 0xFF, 0xA0, 0x27, 0x77, 0x30, 0x7F, 0xF0, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xD8, 0x0B, 0xF7,
  0x00, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C,
  0x3F, 0x0A, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2,
  0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8,
  0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15,
  0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C, 0x80, 0xC2, 0xF8, 0x15, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC,
  0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77,
  0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77,
  0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C, 0xFC, 0x0C, 0x77, 0x77, 0x0C,
  0xFC, 0x0C, 0x77, 0x77, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "ě" (U+011B)
  0x70, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x75, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x76, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x77, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0x56, 0x08,
  0xFB, 0x03, 0x77, 0x30, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x50, 0x8F, 0xB0, 0x62, 0x09,
  0xFB, 0x09, 0x77, 0x70, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x77, 0x10, 0x10, 0xEF, 0xFE, 0x0E,
  0x02, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x40, 0x8F, 0xFC, 0x08, 0x77, 0x76, 0x0C, 0xFF,
  0xA0, 0xC7, 0x77, 0x70, 0x2F, 0xFA, 0x02, 0x77, 0x77, 0x10, 0x7F, 0xF0, 0x77, 0x77, 0x73, 0x0D,
  0xFD, 0x0D, 0x80, 0xC8, 0x10, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x63, 0x77, 0x77,
  0x81, 0x17, 0xCF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x20, 0x10, 0x8F, 0xFF, 0x0C, 0x04, 0x77, 0x60,
  0x7F, 0xFF, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x02, 0x0D, 0xFF,
  0xFF, 0xA0, 0x57, 0x50, 0x20, 0xEF, 0xFF, 0xFC, 0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xE0,
  0x27, 0x20, 0xBF, 0xFF, 0xFF, 0x0C, 0x71, 0x06, 0x80, 0xC1, 0xF0, 0x66, 0x01, 0x0E, 0xFF, 0xA8,
  0x4C, 0xA8, 0x8A, 0xCF, 0xF9, 0x0E, 0x60, 0x8F, 0xF8, 0x1D, 0x61, 0x68, 0x11, 0x7E, 0xFE, 0x06,
  0x40, 0x1F, 0xF0, 0x87, 0x40, 0x10, 0xBF, 0xD0, 0xC4, 0x06, 0xFE, 0x05, 0x77, 0x0A, 0xFD, 0x02,
  0x30, 0xCF, 0xD0, 0x67, 0x72, 0x0C, 0xFC, 0x07, 0x20, 0x2F, 0xD0, 0xC7, 0x73, 0x04, 0xFC, 0x0B,
  0x20, 0x6F, 0xD0, 0x57, 0x74, 0x0D, 0xFB, 0x0E, 0x20, 0xAF, 0xC0, 0xE7, 0x75, 0x08, 0xFC, 0x81,
  0x10, 0xDF, 0xC0, 0xB7, 0x75, 0x05, 0xFC, 0x03, 0x1F, 0xD0, 0x87, 0x75, 0x03, 0xFC, 0x05, 0x02,
  0x80, 0xD0, 0xF0, 0x60, 0x48, 0x0D, 0x0F, 0x07, 0x05, 0x80, 0xD0, 0xF0, 0x70, 0x68, 0x0D, 0x0F,
  0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07, 0x06, 0x80, 0xD0,
  0xF0, 0x70, 0x58, 0x0D, 0x0F, 0x07, 0x03, 0xFD, 0x03, 0x77, 0x77, 0x40, 0x2F, 0xD0, 0x57, 0x77,
  0x75, 0x0E, 0xFC, 0x08, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xD7, 0x77, 0x75, 0x08, 0xFD, 0x04, 0x77,
  0x77, 0x40, 0x4F, 0xD0, 0xC7, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x77, 0x77, 0x40, 0x9F, 0xE0, 0x77,
  0x77, 0x73, 0x02, 0xFF, 0x09, 0x77, 0x72, 0x81, 0x16, 0xC5, 0x0B, 0xFF, 0x0D, 0x06, 0x77, 0x48,
  0x12, 0x6B, 0xB0, 0x14, 0x03, 0xFF, 0xA8, 0x1E, 0x94, 0x74, 0x82, 0x35, 0x9D, 0xE0, 0x15, 0x09,
  0xFF, 0xD8, 0x7D, 0xB9, 0x88, 0x9A, 0xBD, 0xFC, 0x01, 0x60, 0xD8, 0x0C, 0x2F, 0x01, 0x60, 0x20,
  0xE8, 0x0C, 0x1F, 0x01, 0x70, 0x48, 0x0C, 0x1F, 0x01, 0x71, 0x04, 0x0E, 0xFF, 0xFF, 0xF0, 0x17,
  0x20, 0x20, 0xDF, 0xFF, 0xFE, 0x01, 0x73, 0x01, 0x09, 0xFF, 0xFF, 0xD0, 0x17, 0x50, 0x40, 0xCF,
  0xFF, 0xFA, 0x0D, 0x77, 0x10, 0x40, 0xBF, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x81, 0x16, 0xBF, 0xFD,
  0x82, 0xEA, 0x51, 0x77, 0x73, 0x85, 0x36, 0x9A, 0xCD, 0xEA, 0x87, 0xEE, 0xDC, 0xB9, 0x74, 0x27,
  0x20,
  // "Ĝ" (U+011C)
  0x77, 0x60, 0x38, 0x09, 0x17, 0x77, 0x77, 0x60, 0xDF, 0xE0, 0x87, 0x77, 0x74, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x72, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x72, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x70, 0x8F,
  0xFD, 0x03, 0x77, 0x75, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0,
  0xA7, 0x77, 0x30, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x71, 0x08, 0xFB, 0x04, 0x30, 0xBF,
  0xB0, 0x37, 0x76, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x74, 0x03, 0xFA, 0x0E,
  0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x73, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x77,
  0x20, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x70, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF,
  0x0B, 0x80, 0xC8, 0x60, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x86, 0xEE, 0xCB, 0x97, 0x41, 0x77, 0x76,
  0x81, 0x27, 0xCF, 0xFC, 0x81, 0xD8, 0x47, 0x77, 0x10, 0x50, 0xCF, 0xFF, 0xB8, 0x1E, 0xA4, 0x77,
  0x30, 0x40, 0xDF, 0xFF, 0xF9, 0x0D, 0x06, 0x76, 0x01, 0x0A, 0xFF, 0xFF, 0xD0, 0x27, 0x40, 0x30,
  0xEF, 0xFF, 0xFD, 0x0C, 0x74, 0x06, 0xFF, 0xFF, 0xF0, 0x67, 0x30, 0x6F, 0xFF, 0xFF, 0x0E, 0x73,
  0x05, 0x80, 0xC0, 0xF0, 0x97, 0x20, 0x38, 0x0C, 0x1F, 0x03, 0x71, 0x01, 0x0D, 0x80, 0xC0, 0xF0,
  0xC7, 0x20, 0xAF, 0xFC, 0x83, 0xB7, 0x42, 0x12, 0x84, 0x12, 0x36, 0x9C, 0xE0, 0x67, 0x10, 0x4F,
  0xFA, 0x81, 0xE7, 0x17, 0x68, 0x12, 0x7C, 0xA0, 0xE0, 0x17, 0x10, 0xDF, 0xF9, 0x09, 0x01, 0x77,
  0x48, 0x14, 0xB9, 0x71, 0x05, 0xFF, 0x90, 0x57, 0x77, 0x73, 0x0C, 0xFF, 0x04, 0x77, 0x77, 0x30,
  0x4F, 0xF0, 0x67, 0x77, 0x74, 0x0A, 0xFE, 0x0B, 0x77, 0x77, 0x5F, 0xE0, 0xE0, 0x17, 0x77, 0x74,
  0x05, 0xFE, 0x08, 0x77, 0x77, 0x50, 0xAF, 0xE0, 0x17, 0x77, 0x75, 0x0D, 0xFD, 0x0A, 0x77, 0x77,
  0x50, 0x2F, 0xE0, 0x47, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77,
  0x76, 0x0A, 0xFD, 0x08, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x47, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77,
  0x77, 0x6F, 0xE7, 0x77, 0x76, 0x02, 0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7,
  0x60, 0xBF, 0xFD, 0x0E, 0x03, 0xFD, 0x0C, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60,
  0xBF, 0xFD, 0x0E, 0x04, 0xFD, 0x0B, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60, 0xBF,
  0xFD, 0x0E, 0x03, 0xFD, 0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF, 0xFD,
  0x0E, 0x02, 0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x1F, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x1F,
  0xE0, 0x27, 0x50, 0x68, 0x04, 0x80, 0xEF, 0xB8, 0x1E, 0x0D, 0xFD, 0x05, 0x77, 0x70, 0xDF, 0xB8,
  0x1E, 0x0B, 0xFD, 0x07, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x09, 0xFD, 0x0A, 0x77, 0x70, 0xDF, 0xB8,
  0x1E, 0x06, 0xFD, 0x0E, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x03, 0xFE, 0x04, 0x77, 0x60, 0xDF, 0xB0,
  0xE2, 0x0E, 0xFD, 0x09, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x0A, 0xFD, 0x0E, 0x77, 0x60, 0xDF, 0xB0,
  0xE2, 0x06, 0xFE, 0x07, 0x77, 0x50, 0xDF, 0xB0, 0xE2, 0x01, 0xFE, 0x0E, 0x01, 0x77, 0x40, 0xDF,
  0xB0, 0xE3, 0x0B, 0xFE, 0x08, 0x77, 0x40, 0xDF, 0xB0, 0xE3, 0x05, 0xFF, 0x03, 0x77, 0x30, 0xDF,
  0xB0, 0xE4, 0x0D, 0xFE, 0x0E, 0x02, 0x77, 0x20, 0xDF, 0xB0, 0xE4, 0x06, 0xFF, 0x0E, 0x03, 0x77,
  0x10, 0xDF, 0xB0, 0xE5, 0x0D, 0xFF, 0x90, 0x77, 0x70, 0xDF, 0xB0, 0xE5, 0x04, 0xFF, 0xA8, 0x1E,
  0x72, 0x72, 0x81, 0x25, 0xEF, 0xB0, 0xE6, 0x0A, 0xFF, 0xC8, 0x7E, 0xB9, 0x88, 0x9A, 0xBE, 0xFE,
  0x0E, 0x70, 0xD8, 0x0C, 0x3F, 0x0E, 0x70, 0x30, 0xE8, 0x0C, 0x2F, 0x0E, 0x71, 0x04, 0x80, 0xC2,
  0xF0, 0xE7, 0x20, 0x58, 0x0C, 0x1F, 0x0E, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0xF0, 0xE7, 0x40, 0x10,
  0xAF, 0xFF, 0xFE, 0x0E, 0x76, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xA7, 0x71, 0x05, 0x0C, 0xFF, 0xFE,
  0x81, 0xC7, 0x17, 0x74, 0x81, 0x38, 0xDF, 0xFE, 0x82, 0xEA, 0x62, 0x77, 0x73, 0x86, 0x14, 0x79,
  0xBD, 0xEE, 0xA8, 0x90, 0xEE, 0xDC, 0xB9, 0x86, 0x41, 0x71,
  // "ĝ" (U+011D)
  0x77, 0x30, 0x38, 0x09, 0x17, 0x77, 0x77, 0x40, 0xDF, 0xE0, 0x87, 0x77, 0x72, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x70, 0x2F, 0xFA, 0x0C, 0x77, 0x77, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xFD,
  0x03, 0x77, 0x73, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x20, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x10, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x60, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03,
  0x77, 0x40, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0x3F, 0xA0, 0xE0, 0x37,
  0x09, 0xFA, 0x0C, 0x77, 0x10, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x70, 0xDF,
  0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x50, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80,
  0xBE, 0x40, 0x83, 0x26, 0xAC, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x77, 0x74, 0x05, 0x0C, 0xFD, 0x0D,
  0x06, 0x71, 0x01, 0xFB, 0x72, 0x03, 0x0C, 0xFF, 0xA0, 0xD0, 0x56, 0x07, 0xFB, 0x71, 0x06, 0xFF,
  0xE0, 0x95, 0x0E, 0xFB, 0x70, 0x8F, 0xFF, 0x90, 0xB3, 0x06, 0xFC, 0x60, 0x7F, 0xFF, 0xB0, 0xB2,
  0x0D, 0xFC, 0x50, 0x4F, 0xFF, 0xD0, 0x90, 0x4F, 0xD4, 0x01, 0x0E, 0xFF, 0xFE, 0x0E, 0xFD, 0x40,
  0x98, 0x0C, 0x5F, 0x30, 0x28, 0x0C, 0x6F, 0x30, 0xAF, 0xFB, 0x84, 0xCA, 0x89, 0xAD, 0xFF, 0xD2,
  0x01, 0xFF, 0x98, 0x1E, 0x71, 0x60, 0x20, 0x8F, 0xFB, 0x20, 0x7F, 0xF0, 0xC0, 0x27, 0x30, 0x20,
  0xDF, 0xF9, 0x20, 0xCF, 0xE0, 0xD0, 0x17, 0x50, 0x20, 0xEF, 0xF1, 0x01, 0xFF, 0x03, 0x77, 0x05,
  0xFF, 0x10, 0x5F, 0xE0, 0xA7, 0x72, 0x0C, 0xFE, 0x10, 0x8F, 0xE0, 0x37, 0x72, 0x06, 0xFE, 0x10,
  0xBF, 0xD0, 0xD7, 0x73, 0x01, 0xFE, 0x10, 0xEF, 0xD0, 0x97, 0x74, 0x0D, 0xFD, 0x1F, 0xE0, 0x57,
  0x74, 0x0A, 0xFD, 0x02, 0xFE, 0x03, 0x77, 0x40, 0x7F, 0xD0, 0x3F, 0xE0, 0x17, 0x74, 0x06, 0xFD,
  0x04, 0xFD, 0x0E, 0x77, 0x50, 0x4F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D,
  0x77, 0x50, 0x3F, 0xD0, 0x6F, 0xD0, 0xD7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D, 0x77, 0x50, 0x2F,
  0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x3F, 0xE0,
  0x17, 0x74, 0x04, 0xFD, 0x02, 0xFE, 0x03, 0x77, 0x40, 0x5F, 0xD1, 0xFE, 0x05, 0x77, 0x40, 0x8F,
  0xD1, 0x0E, 0xFD, 0x09, 0x77, 0x40, 0xBF, 0xD1, 0x0B, 0xFD, 0x0E, 0x77, 0x40, 0xEF, 0xD1, 0x08,
  0xFE, 0x03, 0x77, 0x20, 0x4F, 0xE1, 0x05, 0xFE, 0x0B, 0x77, 0x20, 0xAF, 0xE1, 0x01, 0xFF, 0x04,
  0x77, 0x03, 0xFF, 0x20, 0xCF, 0xE0, 0xE0, 0x17, 0x50, 0x10, 0xDF, 0xF2, 0x07, 0xFF, 0x0D, 0x02,
  0x73, 0x01, 0x0C, 0xFF, 0x92, 0x01, 0xFF, 0xA0, 0x80, 0x26, 0x81, 0x16, 0xEF, 0xFA, 0x30, 0x9F,
  0xFB, 0x84, 0xCA, 0x98, 0xAC, 0xFF, 0xD3, 0x02, 0x80, 0xC6, 0xF4, 0x09, 0x80, 0xC5, 0xF4, 0x01,
  0x0D, 0x80, 0xC4, 0xF5, 0x04, 0xFF, 0xFD, 0x0B, 0x0C, 0xFD, 0x60, 0x6F, 0xFF, 0xB8, 0x1D, 0x1C,
  0xFD, 0x70, 0x7F, 0xFF, 0x98, 0x2D, 0x10, 0xEF, 0xD7, 0x10, 0x6F, 0xFE, 0x0C, 0x01, 0x2F, 0xE7,
  0x20, 0x20, 0xBF, 0xFB, 0x08, 0x4F, 0xE7, 0x40, 0x40, 0xBF, 0xD8, 0x1E, 0x91, 0x40, 0x1F, 0xE7,
  0x68, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xDB, 0x84, 0x70, 0x1F, 0xE7, 0x77, 0x74, 0x02, 0xFE, 0x77,
  0x77, 0x40, 0x3F, 0xD0, 0xE7, 0x77, 0x74, 0x04, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0x8F, 0xD0, 0xB7,
  0x77, 0x74, 0x0C, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x4F, 0xE0, 0x54, 0x09, 0x04, 0x77, 0x74, 0x0C,
  0xFE, 0x01, 0x4A, 0x81, 0xD8, 0x27, 0x77, 0x0B, 0xFE, 0x0C, 0x5D, 0x82, 0xD9, 0x51, 0x77, 0x10,
  0x50, 0xDF, 0xF0, 0x65, 0xFA, 0x85, 0xDA, 0x85, 0x32, 0x13, 0x83, 0x13, 0x69, 0xEF, 0xF9, 0x0E,
  0x68, 0x0C, 0x3F, 0x07, 0x68, 0x0C, 0x2F, 0x0D, 0x78, 0x0C, 0x2F, 0x04, 0x78, 0x0C, 0x1F, 0x07,
  0x71, 0x80, 0xC0, 0xF0, 0x87, 0x2F, 0xFF, 0xFF, 0x08, 0x73, 0xFF, 0xFF, 0xD0, 0xE0, 0x57, 0x4F,
  0xFF, 0xFC, 0x09, 0x01, 0x75, 0x05, 0x0A, 0xFF, 0xFE, 0x81, 0xE9, 0x27, 0x73, 0x81, 0x59, 0xCF,
  0xFE, 0x81, 0xDA, 0x57, 0x77, 0x38, 0x63, 0x68, 0x9B, 0xDD, 0xEB, 0x86, 0xEE, 0xCB, 0x97, 0x52,
  0x77, 0x20,
  // "Ğ" (U+011E)
  0x75, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x30, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x73, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x30, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x74, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x75, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x75, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x50, 0x3F, 0xFF, 0xD0, 0x97,
  0x77, 0x0A, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x70, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x20, 0x30,
  0xEF, 0xFF, 0x06, 0x77, 0x74, 0x03, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x60, 0x10, 0xBF, 0xFA, 0x0D,
  0x03, 0x77, 0x77, 0x20, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x76, 0x89, 0x22, 0x6A, 0xCD, 0xEF,
  0xDC, 0xA6, 0x28, 0x0C, 0xA1, 0x08, 0x54, 0x79, 0xBD, 0xEE, 0xA8, 0x6E, 0xEC, 0xB9, 0x74, 0x17,
  0x77, 0x68, 0x12, 0x7C, 0xFF, 0xC8, 0x1D, 0x84, 0x77, 0x71, 0x05, 0x0C, 0xFF, 0xFB, 0x81, 0xEA,
  0x47, 0x73, 0x04, 0x0D, 0xFF, 0xFF, 0x90, 0xD0, 0x67, 0x60, 0x10, 0xAF, 0xFF, 0xFD, 0x02, 0x74,
  0x03, 0x0E, 0xFF, 0xFF, 0xD0, 0xC7, 0x40, 0x6F, 0xFF, 0xFF, 0x06, 0x73, 0x06, 0xFF, 0xFF, 0xF0,
  0xE7, 0x30, 0x58, 0x0C, 0x0F, 0x09, 0x72, 0x03, 0x80, 0xC1, 0xF0, 0x37, 0x10, 0x10, 0xD8, 0x0C,
  0x0F, 0x0C, 0x72, 0x0A, 0xFF, 0xC8, 0x3B, 0x74, 0x21, 0x28, 0x41, 0x23, 0x69, 0xCE, 0x06, 0x71,
  0x04, 0xFF, 0xA8, 0x1E, 0x71, 0x76, 0x81, 0x27, 0xCA, 0x0E, 0x01, 0x71, 0x0D, 0xFF, 0x90, 0x90,
  0x17, 0x74, 0x81, 0x4B, 0x97, 0x10, 0x5F, 0xF9, 0x05, 0x77, 0x77, 0x30, 0xCF, 0xF0, 0x47, 0x77,
  0x73, 0x04, 0xFF, 0x06, 0x77, 0x77, 0x40, 0xAF, 0xE0, 0xB7, 0x77, 0x75, 0xFE, 0x0E, 0x01, 0x77,
  0x77, 0x40, 0x5F, 0xE0, 0x87, 0x77, 0x75, 0x0A, 0xFE, 0x01, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xA7,
  0x77, 0x75, 0x02, 0xFE, 0x04, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x76, 0x08, 0xFD, 0x0B,
  0x77, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77, 0x76, 0x0D, 0xFD, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xD0,
  0x27, 0x77, 0x76, 0xFE, 0x77, 0x77, 0x60, 0x2F, 0xD0, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x03, 0xFD,
  0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xC7, 0x60, 0xBF, 0xFD, 0x0E, 0x04, 0xFD, 0x0C,
  0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xB7, 0x60, 0xBF, 0xFD, 0x0E, 0x04, 0xFD, 0x0C, 0x76,
  0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF, 0xFD, 0x0E, 0x03, 0xFD, 0x0D, 0x76, 0x0B,
  0xFF, 0xD0, 0xE0, 0x2F, 0xD0, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x01, 0xFE, 0x76, 0x0B, 0xFF, 0xD0,
  0xE1, 0xFE, 0x02, 0x75, 0x06, 0x80, 0x48, 0x0E, 0xFB, 0x81, 0xE0, 0xDF, 0xD0, 0x57, 0x77, 0x0D,
  0xFB, 0x81, 0xE0, 0xBF, 0xD0, 0x77, 0x77, 0x0D, 0xFB, 0x81, 0xE0, 0x9F, 0xD0, 0xA7, 0x77, 0x0D,
  0xFB, 0x81, 0xE0, 0x6F, 0xD0, 0xE7, 0x77, 0x0D, 0xFB, 0x81, 0xE0, 0x3F, 0xE0, 0x47, 0x76, 0x0D,
  0xFB, 0x0E, 0x20, 0xEF, 0xD0, 0x97, 0x76, 0x0D, 0xFB, 0x0E, 0x20, 0xAF, 0xD0, 0xE7, 0x76, 0x0D,
  0xFB, 0x0E, 0x20, 0x6F, 0xE0, 0x77, 0x75, 0x0D, 0xFB, 0x0E, 0x20, 0x1F, 0xE0, 0xE0, 0x17, 0x74,
  0x0D, 0xFB, 0x0E, 0x30, 0xBF, 0xE0, 0x87, 0x74, 0x0D, 0xFB, 0x0E, 0x30, 0x5F, 0xF0, 0x37, 0x73,
  0x0D, 0xFB, 0x0E, 0x40, 0xDF, 0xE0, 0xE0, 0x27, 0x72, 0x0D, 0xFB, 0x0E, 0x40, 0x6F, 0xF0, 0xE0,
  0x37, 0x71, 0x0D, 0xFB, 0x0E, 0x50, 0xDF, 0xF9, 0x07, 0x77, 0x0D, 0xFB, 0x0E, 0x50, 0x4F, 0xFA,
  0x81, 0xE7, 0x27, 0x28, 0x12, 0x5E, 0xFB, 0x0E, 0x60, 0xAF, 0xFC, 0x87, 0xEB, 0x98, 0x89, 0xAB,
  0xEF, 0xE0, 0xE7, 0x0D, 0x80, 0xC3, 0xF0, 0xE7, 0x03, 0x0E, 0x80, 0xC2, 0xF0, 0xE7, 0x10, 0x48,
  0x0C, 0x2F, 0x0E, 0x72, 0x05, 0x80, 0xC1, 0xF0, 0xE7, 0x30, 0x30, 0xEF, 0xFF, 0xFF, 0x0E, 0x74,
  0x01, 0x0A, 0xFF, 0xFF, 0xE0, 0xE7, 0x60, 0x50, 0xDF, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x50, 0xCF,
  0xFF, 0xE8, 0x1C, 0x71, 0x77, 0x48, 0x13, 0x8D, 0xFF, 0xE8, 0x2E, 0xA6, 0x27, 0x77, 0x38, 0x61,
  0x47, 0x9B, 0xDE, 0xEA, 0x89, 0x0E, 0xED, 0xCB, 0x98, 0x64, 0x17, 0x10,
  // "ğ" (U+011F)
  0x72, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x10, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x71, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x10, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x72, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x73, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x73, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x30, 0x3F, 0xFF, 0xD0, 0x97,
  0x75, 0x0A, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x03, 0x0E,
  0xFF, 0xF0, 0x67, 0x77, 0x20, 0x30, 0xDF, 0xFD, 0x06, 0x77, 0x74, 0x01, 0x0B, 0xFF, 0xA0, 0xD0,
  0x37, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x74, 0x89, 0x22, 0x6A, 0xCD, 0xEF, 0xDC,
  0xA6, 0x28, 0x0B, 0xF7, 0x08, 0x32, 0x6A, 0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x77, 0x77, 0x40, 0x50,
  0xCF, 0xD0, 0xD0, 0x67, 0x10, 0x1F, 0xB7, 0x20, 0x30, 0xCF, 0xFA, 0x0D, 0x05, 0x60, 0x7F, 0xB7,
  0x10, 0x6F, 0xFE, 0x09, 0x50, 0xEF, 0xB7, 0x08, 0xFF, 0xF9, 0x0B, 0x30, 0x6F, 0xC6, 0x07, 0xFF,
  0xFB, 0x0B, 0x20, 0xDF, 0xC5, 0x04, 0xFF, 0xFD, 0x09, 0x04, 0xFD, 0x40, 0x10, 0xEF, 0xFF, 0xE0,
  0xEF, 0xD4, 0x09, 0x80, 0xC5, 0xF3, 0x02, 0x80, 0xC6, 0xF3, 0x0A, 0xFF, 0xB8, 0x4C, 0xA8, 0x9A,
  0xDF, 0xFD, 0x20, 0x1F, 0xF9, 0x81, 0xE7, 0x16, 0x02, 0x08, 0xFF, 0xB2, 0x07, 0xFF, 0x0C, 0x02,
  0x73, 0x02, 0x0D, 0xFF, 0x92, 0x0C, 0xFE, 0x0D, 0x01, 0x75, 0x02, 0x0E, 0xFF, 0x10, 0x1F, 0xF0,
  0x37, 0x70, 0x5F, 0xF1, 0x05, 0xFE, 0x0A, 0x77, 0x20, 0xCF, 0xE1, 0x08, 0xFE, 0x03, 0x77, 0x20,
  0x6F, 0xE1, 0x0B, 0xFD, 0x0D, 0x77, 0x30, 0x1F, 0xE1, 0x0E, 0xFD, 0x09, 0x77, 0x40, 0xDF, 0xD1,
  0xFE, 0x05, 0x77, 0x40, 0xAF, 0xD0, 0x2F, 0xE0, 0x37, 0x74, 0x07, 0xFD, 0x03, 0xFE, 0x01, 0x77,
  0x40, 0x6F, 0xD0, 0x4F, 0xD0, 0xE7, 0x75, 0x04, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0,
  0x5F, 0xD0, 0xD7, 0x75, 0x03, 0xFD, 0x06, 0xFD, 0x0D, 0x77, 0x50, 0x3F, 0xD0, 0x5F, 0xD0, 0xD7,
  0x75, 0x02, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD,
  0x03, 0xFE, 0x01, 0x77, 0x40, 0x4F, 0xD0, 0x2F, 0xE0, 0x37, 0x74, 0x05, 0xFD, 0x1F, 0xE0, 0x57,
  0x74, 0x08, 0xFD, 0x10, 0xEF, 0xD0, 0x97, 0x74, 0x0B, 0xFD, 0x10, 0xBF, 0xD0, 0xE7, 0x74, 0x0E,
  0xFD, 0x10, 0x8F, 0xE0, 0x37, 0x72, 0x04, 0xFE, 0x10, 0x5F, 0xE0, 0xB7, 0x72, 0x0A, 0xFE, 0x10,
  0x1F, 0xF0, 0x47, 0x70, 0x3F, 0xF2, 0x0C, 0xFE, 0x0E, 0x01, 0x75, 0x01, 0x0D, 0xFF, 0x20, 0x7F,
  0xF0, 0xD0, 0x27, 0x30, 0x10, 0xCF, 0xF9, 0x20, 0x1F, 0xFA, 0x08, 0x02, 0x68, 0x11, 0x6E, 0xFF,
  0xA3, 0x09, 0xFF, 0xB8, 0x4C, 0xA9, 0x8A, 0xCF, 0xFD, 0x30, 0x28, 0x0C, 0x6F, 0x40, 0x98, 0x0C,
  0x5F, 0x40, 0x10, 0xD8, 0x0C, 0x4F, 0x50, 0x4F, 0xFF, 0xD0, 0xB0, 0xCF, 0xD6, 0x06, 0xFF, 0xFB,
  0x81, 0xD1, 0xCF, 0xD7, 0x07, 0xFF, 0xF9, 0x82, 0xD1, 0x0E, 0xFD, 0x71, 0x06, 0xFF, 0xE0, 0xC0,
  0x12, 0xFE, 0x72, 0x02, 0x0B, 0xFF, 0xB0, 0x84, 0xFE, 0x74, 0x04, 0x0B, 0xFD, 0x81, 0xE9, 0x14,
  0x01, 0xFE, 0x76, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x01, 0xFE, 0x77, 0x77, 0x40,
  0x2F, 0xE7, 0x77, 0x74, 0x03, 0xFD, 0x0E, 0x77, 0x77, 0x40, 0x4F, 0xD0, 0xD7, 0x77, 0x74, 0x08,
  0xFD, 0x0B, 0x77, 0x77, 0x40, 0xCF, 0xD0, 0x87, 0x77, 0x73, 0x04, 0xFE, 0x05, 0x40, 0x90, 0x47,
  0x77, 0x40, 0xCF, 0xE0, 0x14, 0xA8, 0x1D, 0x82, 0x77, 0x70, 0xBF, 0xE0, 0xC5, 0xD8, 0x2D, 0x95,
  0x17, 0x71, 0x05, 0x0D, 0xFF, 0x06, 0x5F, 0xA8, 0x5D, 0xA8, 0x53, 0x21, 0x38, 0x31, 0x36, 0x9E,
  0xFF, 0x90, 0xE6, 0x80, 0xC3, 0xF0, 0x76, 0x80, 0xC2, 0xF0, 0xD7, 0x80, 0xC2, 0xF0, 0x47, 0x80,
  0xC1, 0xF0, 0x77, 0x18, 0x0C, 0x0F, 0x08, 0x72, 0xFF, 0xFF, 0xF0, 0x87, 0x3F, 0xFF, 0xFD, 0x0E,
  0x05, 0x74, 0xFF, 0xFF, 0xC0, 0x90, 0x17, 0x50, 0x50, 0xAF, 0xFF, 0xE8, 0x1E, 0x92, 0x77, 0x38,
  0x15, 0x9C, 0xFF, 0xE8, 0x1D, 0xA5, 0x77, 0x73, 0x86, 0x36, 0x89, 0xBD, 0xDE, 0xB8, 0x6E, 0xEC,
  0xB9, 0x75, 0x27, 0x72,
  // "Ġ" (U+0120)
  0x77, 0x71, 0x82, 0x17, 0xBE, 0xA8, 0x2D, 0xB7, 0x18, 0x0C, 0x10, 0x07, 0xFB, 0x07, 0x77, 0x77,
  0x70, 0x8F, 0xD0, 0x77, 0x77, 0x75, 0x02, 0xFF, 0x01, 0x77, 0x77, 0x40, 0x9F, 0xF0, 0x77, 0x77,
  0x74, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x40, 0xEF, 0xF0, 0xD7, 0x77, 0x74, 0xFF, 0x90, 0xD7, 0x77,
  0x74, 0x0E, 0xFF, 0x0D, 0x77, 0x77, 0x40, 0xCF, 0xF0, 0xB7, 0x77, 0x74, 0x09, 0xFF, 0x07, 0x77,
  0x77, 0x40, 0x2F, 0xE0, 0xE0, 0x17, 0x77, 0x75, 0x08, 0xFD, 0x06, 0x77, 0x77, 0x70, 0x8F, 0xA0,
  0xE0, 0x68, 0x0C, 0x10, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB7, 0x18, 0x0C, 0xA2, 0x08, 0x54, 0x79,
  0xBD, 0xEE, 0xA8, 0x6E, 0xEC, 0xB9, 0x74, 0x17, 0x77, 0x68, 0x12, 0x7C, 0xFF, 0xC8, 0x1D, 0x84,
  0x77, 0x71, 0x05, 0x0C, 0xFF, 0xFB, 0x81, 0xEA, 0x47, 0x73, 0x04, 0x0D, 0xFF, 0xFF, 0x90, 0xD0,
  0x67, 0x60, 0x10, 0xAF, 0xFF, 0xFD, 0x02, 0x74, 0x03, 0x0E, 0xFF, 0xFF, 0xD0, 0xC7, 0x40, 0x6F,
  0xFF, 0xFF, 0x06, 0x73, 0x06, 0xFF, 0xFF, 0xF0, 0xE7, 0x30, 0x58, 0x0C, 0x0F, 0x09, 0x72, 0x03,
  0x80, 0xC1, 0xF0, 0x37, 0x10, 0x10, 0xD8, 0x0C, 0x0F, 0x0C, 0x72, 0x0A, 0xFF, 0xC8, 0x3B, 0x74,
  0x21, 0x28, 0x41, 0x23, 0x69, 0xCE, 0x06, 0x71, 0x04, 0xFF, 0xA8, 0x1E, 0x71, 0x76, 0x81, 0x27,
  0xCA, 0x0E, 0x01, 0x71, 0x0D, 0xFF, 0x90, 0x90, 0x17, 0x74, 0x81, 0x4B, 0x97, 0x10, 0x5F, 0xF9,
  0x05, 0x77, 0x77, 0x30, 0xCF, 0xF0, 0x47, 0x77, 0x73, 0x04, 0xFF, 0x06, 0x77, 0x77, 0x40, 0xAF,
  0xE0, 0xB7, 0x77, 0x75, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x40, 0x5F, 0xE0, 0x87, 0x77, 0x75, 0x0A,
  0xFE, 0x01, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xA7, 0x77, 0x75, 0x02, 0xFE, 0x04, 0x77, 0x77, 0x50,
  0x5F, 0xD0, 0xE7, 0x77, 0x76, 0x08, 0xFD, 0x0B, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x87, 0x77, 0x76,
  0x0D, 0xFD, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xD0, 0x27, 0x77, 0x76, 0xFE, 0x77, 0x77, 0x60, 0x2F,
  0xD0, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x03, 0xFD, 0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0,
  0xC7, 0x60, 0xBF, 0xFD, 0x0E, 0x04, 0xFD, 0x0C, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xB7,
  0x60, 0xBF, 0xFD, 0x0E, 0x04, 0xFD, 0x0C, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60,
  0xBF, 0xFD, 0x0E, 0x03, 0xFD, 0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x2F, 0xD0, 0xE7, 0x60, 0xBF,
  0xFD, 0x0E, 0x01, 0xFE, 0x76, 0x0B, 0xFF, 0xD0, 0xE1, 0xFE, 0x02, 0x75, 0x06, 0x80, 0x48, 0x0E,
  0xFB, 0x81, 0xE0, 0xDF, 0xD0, 0x57, 0x77, 0x0D, 0xFB, 0x81, 0xE0, 0xBF, 0xD0, 0x77, 0x77, 0x0D,
  0xFB, 0x81, 0xE0, 0x9F, 0xD0, 0xA7, 0x77, 0x0D, 0xFB, 0x81, 0xE0, 0x6F, 0xD0, 0xE7, 0x77, 0x0D,
  0xFB, 0x81, 0xE0, 0x3F, 0xE0, 0x47, 0x76, 0x0D, 0xFB, 0x0E, 0x20, 0xEF, 0xD0, 0x97, 0x76, 0x0D,
  0xFB, 0x0E, 0x20, 0xAF, 0xD0, 0xE7, 0x76, 0x0D, 0xFB, 0x0E, 0x20, 0x6F, 0xE0, 0x77, 0x75, 0x0D,
  0xFB, 0x0E, 0x20, 0x1F, 0xE0, 0xE0, 0x17, 0x74, 0x0D, 0xFB, 0x0E, 0x30, 0xBF, 0xE0, 0x87, 0x74,
  0x0D, 0xFB, 0x0E, 0x30, 0x5F, 0xF0, 0x37, 0x73, 0x0D, 0xFB, 0x0E, 0x40, 0xDF, 0xE0, 0xE0, 0x27,
  0x72, 0x0D, 0xFB, 0x0E, 0x40, 0x6F, 0xF0, 0xE0, 0x37, 0x71, 0x0D, 0xFB, 0x0E, 0x50, 0xDF, 0xF9,
  0x07, 0x77, 0x0D, 0xFB, 0x0E, 0x50, 0x4F, 0xFA, 0x81, 0xE7, 0x27, 0x28, 0x12, 0x5E, 0xFB, 0x0E,
  0x60, 0xAF, 0xFC, 0x87, 0xEB, 0x98, 0x89, 0xAB, 0xEF, 0xE0, 0xE7, 0x0D, 0x80, 0xC3, 0xF0, 0xE7,
  0x03, 0x0E, 0x80, 0xC2, 0xF0, 0xE7, 0x10, 0x48, 0x0C, 0x2F, 0x0E, 0x72, 0x05, 0x80, 0xC1, 0xF0,
  0xE7, 0x30, 0x30, 0xEF, 0xFF, 0xFF, 0x0E, 0x74, 0x01, 0x0A, 0xFF, 0xFF, 0xE0, 0xE7, 0x60, 0x50,
  0xDF, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x50, 0xCF, 0xFF, 0xE8, 0x1C, 0x71, 0x77, 0x48, 0x13, 0x8D,
  0xFF, 0xE8, 0x2E, 0xA6, 0x27, 0x77, 0x38, 0x61, 0x47, 0x9B, 0xDE, 0xEA, 0x89, 0x0E, 0xED, 0xCB,
  0x98, 0x64, 0x17, 0x10,
  // "ġ" (U+0121)
  0x77, 0x58, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x70, 0x7F, 0xB0, 0x77, 0x77, 0x75,
  0x08, 0xFD, 0x07, 0x77, 0x77, 0x30, 0x2F, 0xF0, 0x17, 0x77, 0x72, 0x09, 0xFF, 0x07, 0x77, 0x77,
  0x20, 0xCF, 0xF0, 0xB7, 0x77, 0x72, 0x0E, 0xFF, 0x0D, 0x77, 0x77, 0x2F, 0xF9, 0x0D, 0x77, 0x77,
  0x20, 0xEF, 0xF0, 0xD7, 0x77, 0x72, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x20, 0x9F, 0xF0, 0x77, 0x77,
  0x72, 0x02, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x30, 0x8F, 0xD0, 0x67, 0x77, 0x75, 0x08, 0xFA, 0x0E,
  0x06, 0x77, 0x77, 0x78, 0x90, 0x28, 0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xC8, 0x00, 0x83, 0x26, 0xAC,
  0xEA, 0x83, 0xED, 0xA7, 0x37, 0x77, 0x74, 0x05, 0x0C, 0xFD, 0x0D, 0x06, 0x71, 0x01, 0xFB, 0x72,
  0x03, 0x0C, 0xFF, 0xA0, 0xD0, 0x56, 0x07, 0xFB, 0x71, 0x06, 0xFF, 0xE0, 0x95, 0x0E, 0xFB, 0x70,
  0x8F, 0xFF, 0x90, 0xB3, 0x06, 0xFC, 0x60, 0x7F, 0xFF, 0xB0, 0xB2, 0x0D, 0xFC, 0x50, 0x4F, 0xFF,
  0xD0, 0x90, 0x4F, 0xD4, 0x01, 0x0E, 0xFF, 0xFE, 0x0E, 0xFD, 0x40, 0x98, 0x0C, 0x5F, 0x30, 0x28,
  0x0C, 0x6F, 0x30, 0xAF, 0xFB, 0x84, 0xCA, 0x89, 0xAD, 0xFF, 0xD2, 0x01, 0xFF, 0x98, 0x1E, 0x71,
  0x60, 0x20, 0x8F, 0xFB, 0x20, 0x7F, 0xF0, 0xC0, 0x27, 0x30, 0x20, 0xDF, 0xF9, 0x20, 0xCF, 0xE0,
  0xD0, 0x17, 0x50, 0x20, 0xEF, 0xF1, 0x01, 0xFF, 0x03, 0x77, 0x05, 0xFF, 0x10, 0x5F, 0xE0, 0xA7,
  0x72, 0x0C, 0xFE, 0x10, 0x8F, 0xE0, 0x37, 0x72, 0x06, 0xFE, 0x10, 0xBF, 0xD0, 0xD7, 0x73, 0x01,
  0xFE, 0x10, 0xEF, 0xD0, 0x97, 0x74, 0x0D, 0xFD, 0x1F, 0xE0, 0x57, 0x74, 0x0A, 0xFD, 0x02, 0xFE,
  0x03, 0x77, 0x40, 0x7F, 0xD0, 0x3F, 0xE0, 0x17, 0x74, 0x06, 0xFD, 0x04, 0xFD, 0x0E, 0x77, 0x50,
  0x4F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D, 0x77, 0x50, 0x3F, 0xD0, 0x6F,
  0xD0, 0xD7, 0x75, 0x03, 0xFD, 0x05, 0xFD, 0x0D, 0x77, 0x50, 0x2F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75,
  0x03, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x3F, 0xE0, 0x17, 0x74, 0x04, 0xFD, 0x02,
  0xFE, 0x03, 0x77, 0x40, 0x5F, 0xD1, 0xFE, 0x05, 0x77, 0x40, 0x8F, 0xD1, 0x0E, 0xFD, 0x09, 0x77,
  0x40, 0xBF, 0xD1, 0x0B, 0xFD, 0x0E, 0x77, 0x40, 0xEF, 0xD1, 0x08, 0xFE, 0x03, 0x77, 0x20, 0x4F,
  0xE1, 0x05, 0xFE, 0x0B, 0x77, 0x20, 0xAF, 0xE1, 0x01, 0xFF, 0x04, 0x77, 0x03, 0xFF, 0x20, 0xCF,
  0xE0, 0xE0, 0x17, 0x50, 0x10, 0xDF, 0xF2, 0x07, 0xFF, 0x0D, 0x02, 0x73, 0x01, 0x0C, 0xFF, 0x92,
  0x01, 0xFF, 0xA0, 0x80, 0x26, 0x81, 0x16, 0xEF, 0xFA, 0x30, 0x9F, 0xFB, 0x84, 0xCA, 0x98, 0xAC,
  0xFF, 0xD3, 0x02, 0x80, 0xC6, 0xF4, 0x09, 0x80, 0xC5, 0xF4, 0x01, 0x0D, 0x80, 0xC4, 0xF5, 0x04,
  0xFF, 0xFD, 0x0B, 0x0C, 0xFD, 0x60, 0x6F, 0xFF, 0xB8, 0x1D, 0x1C, 0xFD, 0x70, 0x7F, 0xFF, 0x98,
  0x2D, 0x10, 0xEF, 0xD7, 0x10, 0x6F, 0xFE, 0x0C, 0x01, 0x2F, 0xE7, 0x20, 0x20, 0xBF, 0xFB, 0x08,
  0x4F, 0xE7, 0x40, 0x40, 0xBF, 0xD8, 0x1E, 0x91, 0x40, 0x1F, 0xE7, 0x68, 0x31, 0x69, 0xCE, 0xA8,
  0x3E, 0xDB, 0x84, 0x70, 0x1F, 0xE7, 0x77, 0x74, 0x02, 0xFE, 0x77, 0x77, 0x40, 0x3F, 0xD0, 0xE7,
  0x77, 0x74, 0x04, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0x8F, 0xD0, 0xB7, 0x77, 0x74, 0x0C, 0xFD, 0x08,
  0x77, 0x77, 0x30, 0x4F, 0xE0, 0x54, 0x09, 0x04, 0x77, 0x74, 0x0C, 0xFE, 0x01, 0x4A, 0x81, 0xD8,
  0x27, 0x77, 0x0B, 0xFE, 0x0C, 0x5D, 0x82, 0xD9, 0x51, 0x77, 0x10, 0x50, 0xDF, 0xF0, 0x65, 0xFA,
  0x85, 0xDA, 0x85, 0x32, 0x13, 0x83, 0x13, 0x69, 0xEF, 0xF9, 0x0E, 0x68, 0x0C, 0x3F, 0x07, 0x68,
  0x0C, 0x2F, 0x0D, 0x78, 0x0C, 0x2F, 0x04, 0x78, 0x0C, 0x1F, 0x07, 0x71, 0x80, 0xC0, 0xF0, 0x87,
  0x2F, 0xFF, 0xFF, 0x08, 0x73, 0xFF, 0xFF, 0xD0, 0xE0, 0x57, 0x4F, 0xFF, 0xFC, 0x09, 0x01, 0x75,
  0x05, 0x0A, 0xFF, 0xFE, 0x81, 0xE9, 0x27, 0x73, 0x81, 0x59, 0xCF, 0xFE, 0x81, 0xDA, 0x57, 0x77,
  0x38, 0x63, 0x68, 0x9B, 0xDD, 0xEB, 0x86, 0xEE, 0xCB, 0x97, 0x52, 0x77, 0x20,
  // "Ģ" (U+0122)
  0x77, 0x71, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x86, 0xEE, 0xCB, 0x97, 0x41, 0x77, 0x76, 0x81, 0x27,
  0xCF, 0xFC, 0x81, 0xD8, 0x47, 0x77, 0x10, 0x50, 0xCF, 0xFF, 0xB8, 0x1E, 0xA4, 0x77, 0x30, 0x40,
  0xDF, 0xFF, 0xF9, 0x0D, 0x06, 0x76, 0x01, 0x0A, 0xFF, 0xFF, 0xD0, 0x27, 0x40, 0x30, 0xEF, 0xFF,
  0xFD, 0x0C, 0x74, 0x06, 0xFF, 0xFF, 0xF0, 0x67, 0x30, 0x6F, 0xFF, 0xFF, 0x0E, 0x73, 0x05, 0x80,
  0xC0, 0xF0, 0x97, 0x20, 0x38, 0x0C, 0x1F, 0x03, 0x71, 0x01, 0x0D, 0x80, 0xC0, 0xF0, 0xC7, 0x20,
  0xAF, 0xFC, 0x83, 0xB7, 0x42, 0x12, 0x84, 0x12, 0x36, 0x9C, 0xE0, 0x67, 0x10, 0x4F, 0xFA, 0x81,
  0xE7, 0x17, 0x68, 0x12, 0x7C, 0xA0, 0xE0, 0x17, 0x10, 0xDF, 0xF9, 0x09, 0x01, 0x77, 0x48, 0x14,
  0xB9, 0x71, 0x05, 0xFF, 0x90, 0x57, 0x77, 0x73, 0x0C, 0xFF, 0x04, 0x77, 0x77, 0x30, 0x4F, 0xF0,
  0x67, 0x77, 0x74, 0x0A, 0xFE, 0x0B, 0x77, 0x77, 0x5F, 0xE0, 0xE0, 0x17, 0x77, 0x74, 0x05, 0xFE,
  0x08, 0x77, 0x77, 0x50, 0xAF, 0xE0, 0x17, 0x77, 0x75, 0x0D, 0xFD, 0x0A, 0x77, 0x77, 0x50, 0x2F,
  0xE0, 0x47, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0xD0, 0xB7, 0x77, 0x76, 0x0A,
  0xFD, 0x08, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x47, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x77, 0x6F,
  0xE7, 0x77, 0x76, 0x02, 0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF,
  0xFD, 0x0E, 0x03, 0xFD, 0x0C, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60, 0xBF, 0xFD,
  0x0E, 0x04, 0xFD, 0x0B, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x4F, 0xD0, 0xC7, 0x60, 0xBF, 0xFD, 0x0E,
  0x03, 0xFD, 0x0D, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x3F, 0xD0, 0xD7, 0x60, 0xBF, 0xFD, 0x0E, 0x02,
  0xFD, 0x0E, 0x76, 0x0B, 0xFF, 0xD0, 0xE0, 0x1F, 0xE7, 0x60, 0xBF, 0xFD, 0x0E, 0x1F, 0xE0, 0x27,
  0x50, 0x68, 0x04, 0x80, 0xEF, 0xB8, 0x1E, 0x0D, 0xFD, 0x05, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x0B,
  0xFD, 0x07, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x09, 0xFD, 0x0A, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x06,
  0xFD, 0x0E, 0x77, 0x70, 0xDF, 0xB8, 0x1E, 0x03, 0xFE, 0x04, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x0E,
  0xFD, 0x09, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x0A, 0xFD, 0x0E, 0x77, 0x60, 0xDF, 0xB0, 0xE2, 0x06,
  0xFE, 0x07, 0x77, 0x50, 0xDF, 0xB0, 0xE2, 0x01, 0xFE, 0x0E, 0x01, 0x77, 0x40, 0xDF, 0xB0, 0xE3,
  0x0B, 0xFE, 0x08, 0x77, 0x40, 0xDF, 0xB0, 0xE3, 0x05, 0xFF, 0x03, 0x77, 0x30, 0xDF, 0xB0, 0xE4,
  0x0D, 0xFE, 0x0E, 0x02, 0x77, 0x20, 0xDF, 0xB0, 0xE4, 0x06, 0xFF, 0x0E, 0x03, 0x77, 0x10, 0xDF,
  0xB0, 0xE5, 0x0D, 0xFF, 0x90, 0x77, 0x70, 0xDF, 0xB0, 0xE5, 0x04, 0xFF, 0xA8, 0x1E, 0x72, 0x72,
  0x81, 0x25, 0xEF, 0xB0, 0xE6, 0x0A, 0xFF, 0xC8, 0x7E, 0xB9, 0x88, 0x9A, 0xBE, 0xFE, 0x0E, 0x70,
  0xD8, 0x0C, 0x3F, 0x0E, 0x70, 0x30, 0xE8, 0x0C, 0x2F, 0x0E, 0x71, 0x04, 0x80, 0xC2, 0xF0, 0xE7,
  0x20, 0x58, 0x0C, 0x1F, 0x0E, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0xF0, 0xE7, 0x40, 0x10, 0xAF, 0xFF,
  0xFE, 0x0E, 0x76, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xA7, 0x71, 0x05, 0x0C, 0xFF, 0xFE, 0x81, 0xC7,
  0x17, 0x74, 0x81, 0x38, 0xDF, 0xFE, 0x82, 0xEA, 0x62, 0x77, 0x73, 0x86, 0x14, 0x79, 0xBD, 0xEE,
  0xA8, 0x90, 0xEE, 0xDC, 0xB9, 0x86, 0x41, 0x80, 0xC9, 0x10, 0x03, 0xFC, 0x0D, 0x77, 0x77, 0x70,
  0x5F, 0xC0, 0x87, 0x77, 0x77, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x70, 0xAF, 0xB0, 0x98, 0x0C, 0x00,
  0x0E, 0xFB, 0x02, 0x77, 0x77, 0x70, 0x1F, 0xB0, 0x98, 0x0C, 0x00, 0x05, 0xFB, 0x01, 0x80, 0xC0,
  0x00, 0x8F, 0xA0, 0x88, 0x0C, 0x10, 0x0C, 0xF9, 0x0E, 0x01, 0x80, 0xC1, 0x0F, 0xA0, 0x68, 0x0C,
  0x10, 0x04, 0xF9, 0x0C, 0x80, 0xC2, 0x00, 0x8F, 0x90, 0x38, 0x0C, 0x20, 0x0C, 0xF0, 0x88, 0x0C,
  0x30, 0x0E, 0xE0, 0xD7, 0x77,
  // "ģ" (U+0123)
  0x77, 0x72, 0x06, 0xF0, 0x58, 0x0C, 0x00, 0x01, 0x0E, 0xF0, 0x48, 0x0C, 0x00, 0x0A, 0xF9, 0x80,
  0xC0, 0x00, 0x4F, 0x90, 0xB8, 0x0C, 0x00, 0x0D, 0xF9, 0x07, 0x77, 0x77, 0x70, 0x6F, 0xA0, 0x37,
  0x77, 0x76, 0x01, 0x0E, 0xFA, 0x77, 0x77, 0x70, 0x8F, 0xA0, 0xC7, 0x77, 0x76, 0x01, 0xFB, 0x08,
  0x77, 0x77, 0x60, 0x9F, 0xB0, 0x57, 0x77, 0x75, 0x02, 0xFC, 0x02, 0x77, 0x77, 0x50, 0x9F, 0xC7,
  0x77, 0x75, 0x01, 0xFC, 0x0C, 0x77, 0x77, 0x50, 0x5F, 0xC0, 0xA8, 0x0C, 0x80, 0x08, 0x32, 0x6A,
  0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x77, 0x77, 0x40, 0x50, 0xCF, 0xD0, 0xD0, 0x67, 0x10, 0x1F, 0xB7,
  0x20, 0x30, 0xCF, 0xFA, 0x0D, 0x05, 0x60, 0x7F, 0xB7, 0x10, 0x6F, 0xFE, 0x09, 0x50, 0xEF, 0xB7,
  0x08, 0xFF, 0xF9, 0x0B, 0x30, 0x6F, 0xC6, 0x07, 0xFF, 0xFB, 0x0B, 0x20, 0xDF, 0xC5, 0x04, 0xFF,
  0xFD, 0x09, 0x04, 0xFD, 0x40, 0x10, 0xEF, 0xFF, 0xE0, 0xEF, 0xD4, 0x09, 0x80, 0xC5, 0xF3, 0x02,
  0x80, 0xC6, 0xF3, 0x0A, 0xFF, 0xB8, 0x4C, 0xA8, 0x9A, 0xDF, 0xFD, 0x20, 0x1F, 0xF9, 0x81, 0xE7,
  0x16, 0x02, 0x08, 0xFF, 0xB2, 0x07, 0xFF, 0x0C, 0x02, 0x73, 0x02, 0x0D, 0xFF, 0x92, 0x0C, 0xFE,
  0x0D, 0x01, 0x75, 0x02, 0x0E, 0xFF, 0x10, 0x1F, 0xF0, 0x37, 0x70, 0x5F, 0xF1, 0x05, 0xFE, 0x0A,
  0x77, 0x20, 0xCF, 0xE1, 0x08, 0xFE, 0x03, 0x77, 0x20, 0x6F, 0xE1, 0x0B, 0xFD, 0x0D, 0x77, 0x30,
  0x1F, 0xE1, 0x0E, 0xFD, 0x09, 0x77, 0x40, 0xDF, 0xD1, 0xFE, 0x05, 0x77, 0x40, 0xAF, 0xD0, 0x2F,
  0xE0, 0x37, 0x74, 0x07, 0xFD, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x6F, 0xD0, 0x4F, 0xD0, 0xE7, 0x75,
  0x04, 0xFD, 0x05, 0xFD, 0x0E, 0x77, 0x50, 0x3F, 0xD0, 0x5F, 0xD0, 0xD7, 0x75, 0x03, 0xFD, 0x06,
  0xFD, 0x0D, 0x77, 0x50, 0x3F, 0xD0, 0x5F, 0xD0, 0xD7, 0x75, 0x02, 0xFD, 0x05, 0xFD, 0x0E, 0x77,
  0x50, 0x3F, 0xD0, 0x5F, 0xD0, 0xE7, 0x75, 0x03, 0xFD, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x4F, 0xD0,
  0x2F, 0xE0, 0x37, 0x74, 0x05, 0xFD, 0x1F, 0xE0, 0x57, 0x74, 0x08, 0xFD, 0x10, 0xEF, 0xD0, 0x97,
  0x74, 0x0B, 0xFD, 0x10, 0xBF, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x10, 0x8F, 0xE0, 0x37, 0x72, 0x04,
  0xFE, 0x10, 0x5F, 0xE0, 0xB7, 0x72, 0x0A, 0xFE, 0x10, 0x1F, 0xF0, 0x47, 0x70, 0x3F, 0xF2, 0x0C,
  0xFE, 0x0E, 0x01, 0x75, 0x01, 0x0D, 0xFF, 0x20, 0x7F, 0xF0, 0xD0, 0x27, 0x30, 0x10, 0xCF, 0xF9,
  0x20, 0x1F, 0xFA, 0x08, 0x02, 0x68, 0x11, 0x6E, 0xFF, 0xA3, 0x09, 0xFF, 0xB8, 0x4C, 0xA9, 0x8A,
  0xCF, 0xFD, 0x30, 0x28, 0x0C, 0x6F, 0x40, 0x98, 0x0C, 0x5F, 0x40, 0x10, 0xD8, 0x0C, 0x4F, 0x50,
  0x4F, 0xFF, 0xD0, 0xB0, 0xCF, 0xD6, 0x06, 0xFF, 0xFB, 0x81, 0xD1, 0xCF, 0xD7, 0x07, 0xFF, 0xF9,
  0x82, 0xD1, 0x0E, 0xFD, 0x71, 0x06, 0xFF, 0xE0, 0xC0, 0x12, 0xFE, 0x72, 0x02, 0x0B, 0xFF, 0xB0,
  0x84, 0xFE, 0x74, 0x04, 0x0B, 0xFD, 0x81, 0xE9, 0x14, 0x01, 0xFE, 0x76, 0x83, 0x16, 0x9C, 0xEA,
  0x83, 0xED, 0xB8, 0x47, 0x01, 0xFE, 0x77, 0x77, 0x40, 0x2F, 0xE7, 0x77, 0x74, 0x03, 0xFD, 0x0E,
  0x77, 0x77, 0x40, 0x4F, 0xD0, 0xD7, 0x77, 0x74, 0x08, 0xFD, 0x0B, 0x77, 0x77, 0x40, 0xCF, 0xD0,
  0x87, 0x77, 0x73, 0x04, 0xFE, 0x05, 0x40, 0x90, 0x47, 0x77, 0x40, 0xCF, 0xE0, 0x14, 0xA8, 0x1D,
  0x82, 0x77, 0x70, 0xBF, 0xE0, 0xC5, 0xD8, 0x2D, 0x95, 0x17, 0x71, 0x05, 0x0D, 0xFF, 0x06, 0x5F,
  0xA8, 0x5D, 0xA8, 0x53, 0x21, 0x38, 0x31, 0x36, 0x9E, 0xFF, 0x90, 0xE6, 0x80, 0xC3, 0xF0, 0x76,
  0x80, 0xC2, 0xF0, 0xD7, 0x80, 0xC2, 0xF0, 0x47, 0x80, 0xC1, 0xF0, 0x77, 0x18, 0x0C, 0x0F, 0x08,
  0x72, 0xFF, 0xFF, 0xF0, 0x87, 0x3F, 0xFF, 0xFD, 0x0E, 0x05, 0x74, 0xFF, 0xFF, 0xC0, 0x90, 0x17,
  0x50, 0x50, 0xAF, 0xFF, 0xE8, 0x1E, 0x92, 0x77, 0x38, 0x15, 0x9C, 0xFF, 0xE8, 0x1D, 0xA5, 0x77,
  0x73, 0x86, 0x36, 0x89, 0xBD, 0xDE, 0xB8, 0x6E, 0xEC, 0xB9, 0x75, 0x27, 0x72,
  // "Ĥ" (U+0124)
  0x77, 0x20, 0x38, 0x09, 0x17, 0x77, 0x77, 0x40, 0xDF, 0xE0, 0x87, 0x77, 0x72, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x70, 0x2F, 0xFA, 0x0C, 0x77, 0x77, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xFD,
  0x03, 0x77, 0x73, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x20, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x10, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x60, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03,
  0x77, 0x40, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0x3F, 0xA0, 0xE0, 0x37,
  0x09, 0xFA, 0x0C, 0x77, 0x10, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x70, 0xDF,
  0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x50, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80,
  0xCA, 0x60, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0,
  0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0,
  0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0xE0,
  // "ĥ" (U+0125)
  0x73, 0x03, 0x80, 0x91, 0x78, 0x0C, 0x50, 0x0D, 0xFE, 0x08, 0x80, 0xC3, 0x00, 0x7F, 0xF9, 0x02,
  0x80, 0xC1, 0x00, 0x2F, 0xFA, 0x0C, 0x80, 0xC1, 0x00, 0xCF, 0xFB, 0x07, 0x77, 0x77, 0x70, 0x8F,
  0xFD, 0x03, 0x77, 0x77, 0x50, 0x4F, 0xFE, 0x0D, 0x77, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xE0, 0xBF,
  0xB0, 0xA7, 0x77, 0x73, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x71, 0x08, 0xFB, 0x04,
  0x30, 0xBF, 0xB0, 0x37, 0x77, 0x60, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x74,
  0x03, 0xFA, 0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x77, 0x30, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20,
  0x6F, 0xA0, 0x97, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x77, 0x03, 0xF9,
  0x07, 0x77, 0x01, 0x0B, 0xF0, 0xB8, 0x0D, 0xC5, 0x0F, 0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6, 0x0F,
  0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6, 0x0F, 0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6, 0x0F, 0xE8, 0x0C,
  0x60, 0xFE, 0x80, 0xC6, 0x0F, 0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6, 0x0F, 0xE8, 0x0C, 0x60, 0xFE,
  0x80, 0xC6, 0x0F, 0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6, 0x0F, 0xE8, 0x0C, 0x60, 0xFE, 0x80, 0xC6,
  0x0F, 0xD0, 0xE8, 0x0C, 0x60, 0xFD, 0x0E, 0x80, 0xC6, 0x0F, 0xD0, 0xE7, 0x18, 0x93, 0x37, 0xAC,
  0xEE, 0xFE, 0xEC, 0xA7, 0x37, 0x77, 0xFD, 0x0E, 0x60, 0x60, 0xDF, 0xE8, 0x1D, 0x71, 0x77, 0x4F,
  0xD0, 0xD4, 0x04, 0x0D, 0xFF, 0xB0, 0xE0, 0x77, 0x73, 0xFD, 0x0D, 0x30, 0x6F, 0xFF, 0x0B, 0x01,
  0x77, 0x1F, 0xD0, 0xC2, 0x07, 0xFF, 0xFA, 0x0C, 0x01, 0x77, 0xFD, 0x81, 0xC0, 0x6F, 0xFF, 0xC0,
  0xC7, 0x7F, 0xD0, 0xB0, 0x2F, 0xFF, 0xE0, 0x87, 0x68, 0x0C, 0x6F, 0x02, 0x75, 0x80, 0xC6, 0xF0,
  0xA7, 0x58, 0x0C, 0x7F, 0x01, 0x74, 0xFF, 0xE8, 0x4C, 0xA9, 0x8A, 0xCF, 0xFB, 0x07, 0x74, 0xFF,
  0xC0, 0x80, 0x26, 0x01, 0x08, 0xFF, 0x90, 0xB7, 0x4F, 0xFA, 0x0D, 0x03, 0x73, 0x03, 0x0E, 0xFE,
  0x0E, 0x74, 0xFF, 0x90, 0xE0, 0x27, 0x50, 0x4F, 0xF0, 0x27, 0x3F, 0xF9, 0x05, 0x77, 0x0A, 0xFE,
  0x04, 0x73, 0xFF, 0x0C, 0x77, 0x10, 0x4F, 0xE0, 0x67, 0x3F, 0xF0, 0x67, 0x72, 0xFE, 0x07, 0x73,
  0xFF, 0x01, 0x77, 0x20, 0xDF, 0xD0, 0x77, 0x3F, 0xE0, 0xC7, 0x73, 0x0A, 0xFD, 0x07, 0x73, 0xFE,
  0x09, 0x77, 0x30, 0x9F, 0xD0, 0x77, 0x3F, 0xE0, 0x67, 0x73, 0x09, 0xFD, 0x07, 0x73, 0xFE, 0x04,
  0x77, 0x30, 0x8F, 0xD0, 0x77, 0x3F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x01, 0x77,
  0x30, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x77, 0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x77,
  0x3F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x73, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x70,
  // "Ħ" (U+0126)
  0x50, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0,
  0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F,
  0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20,
  0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77,
  0x20, 0x1F, 0xD0, 0xE5, 0x80, 0xFC, 0x2F, 0x50, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73,
  0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E,
  0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD,
  0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01,
  0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xD8, 0x0C, 0x6F, 0x0E,
  0x73, 0x0D, 0x80, 0xC6, 0xF0, 0xE7, 0x30, 0xD8, 0x0C, 0x6F, 0x0E, 0x73, 0x0D, 0x80, 0xC6, 0xF0,
  0xE7, 0x30, 0xD8, 0x0C, 0x6F, 0x0E, 0x73, 0x0D, 0x80, 0xC6, 0xF0, 0xE7, 0x30, 0xD8, 0x0C, 0x6F,
  0x0E, 0x73, 0x0D, 0x80, 0xC6, 0xF0, 0xE7, 0x30, 0xD8, 0x0C, 0x6F, 0x0E, 0x73, 0x0D, 0x80, 0xC6,
  0xF0, 0xE7, 0x30, 0xD8, 0x0C, 0x6F, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7,
  0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0,
  0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F,
  0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20,
  0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77,
  0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02,
  0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD,
  0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D,
  0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E, 0x73,
  0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD, 0x0E,
  0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01, 0xFD,
  0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72, 0x01,
  0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27, 0x72,
  0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0, 0x27,
  0x72, 0x01, 0xFD, 0x0E, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x30, 0xDF, 0xD0,
  0x27, 0x72, 0x01, 0xFD, 0x0E, 0x50,
  // "ħ" (U+0127)
  0x5F, 0xE8, 0x0C, 0x10, 0xFE, 0x80, 0xC1, 0x0F, 0xE8, 0x0C, 0x10, 0xFE, 0x80, 0xC1, 0x0F, 0xE8,
  0x0C, 0x10, 0xFE, 0x80, 0xC1, 0x0F, 0xE7, 0x77, 0x74, 0xFF, 0xFF, 0xB0, 0x47, 0x74, 0xFF, 0xFF,
  0xB0, 0x47, 0x74, 0xFF, 0xFF, 0xB0, 0x47, 0x74, 0xFF, 0xFF, 0xB0, 0x47, 0x74, 0xFF, 0xFF, 0xB0,
  0x47, 0x74, 0xFF, 0xFF, 0xB0, 0x47, 0x74, 0xFF, 0xFF, 0xB0, 0x47, 0x74, 0xFF, 0xFF, 0xB0, 0x47,
  0x77, 0x2F, 0xE8, 0x0C, 0x10, 0xFE, 0x80, 0xC1, 0x0F, 0xE8, 0x0C, 0x10, 0xFD, 0x0E, 0x80, 0xC1,
  0x0F, 0xD0, 0xE7, 0x18, 0x93, 0x37, 0xAC, 0xEE, 0xFE, 0xEC, 0xA7, 0x37, 0x72, 0xFD, 0x0E, 0x60,
  0x60, 0xDF, 0xE8, 0x1D, 0x71, 0x76, 0xFD, 0x0D, 0x40, 0x40, 0xDF, 0xFB, 0x0E, 0x07, 0x75, 0xFD,
  0x0D, 0x30, 0x6F, 0xFF, 0x0B, 0x01, 0x73, 0xFD, 0x0C, 0x20, 0x7F, 0xFF, 0xA0, 0xD0, 0x17, 0x2F,
  0xD8, 0x1C, 0x06, 0xFF, 0xFC, 0x0C, 0x72, 0xFD, 0x0B, 0x02, 0xFF, 0xFE, 0x08, 0x71, 0x80, 0xC6,
  0xF0, 0x27, 0x80, 0xC6, 0xF0, 0xA7, 0x80, 0xC7, 0xF0, 0x16, 0xFF, 0xE8, 0x4C, 0xA9, 0x8A, 0xCF,
  0xFB, 0x07, 0x6F, 0xFC, 0x08, 0x02, 0x60, 0x10, 0x8F, 0xF9, 0x0B, 0x6F, 0xFA, 0x0D, 0x03, 0x73,
  0x03, 0x0E, 0xFE, 0x0E, 0x6F, 0xF9, 0x0E, 0x02, 0x75, 0x04, 0xFF, 0x02, 0x5F, 0xF9, 0x05, 0x77,
  0x0A, 0xFE, 0x04, 0x5F, 0xF0, 0xC7, 0x71, 0x04, 0xFE, 0x06, 0x5F, 0xF0, 0x57, 0x72, 0xFE, 0x07,
  0x5F, 0xF0, 0x17, 0x72, 0x0D, 0xFD, 0x07, 0x5F, 0xE0, 0xC7, 0x73, 0x0A, 0xFD, 0x07, 0x5F, 0xE0,
  0x87, 0x73, 0x09, 0xFD, 0x07, 0x5F, 0xE0, 0x67, 0x73, 0x09, 0xFD, 0x07, 0x5F, 0xE0, 0x47, 0x73,
  0x08, 0xFD, 0x07, 0x5F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0x5F, 0xE0, 0x17, 0x73, 0x08, 0xFD,
  0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0x5F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  // "Ĩ" (U+0128)
  0x71, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x71, 0x03, 0x0D, 0xFA, 0x0A, 0x04, 0x73,
  0x0D, 0xD0, 0xE7, 0x04, 0xFE, 0x0C, 0x06, 0x70, 0x5E, 0x0C, 0x60, 0x10, 0xEF, 0xF9, 0x82, 0xEA,
  0x52, 0x20, 0x50, 0xEE, 0x0A, 0x60, 0xAF, 0xFF, 0xFA, 0x06, 0x50, 0x3F, 0xFF, 0xFB, 0x02, 0x50,
  0xAF, 0xFF, 0xFA, 0x0C, 0x6F, 0xFF, 0xFB, 0x05, 0x50, 0x5F, 0xFF, 0xFA, 0x0C, 0x60, 0x8E, 0x85,
  0xE5, 0x10, 0x26, 0xBF, 0xFA, 0x0E, 0x02, 0x60, 0xCE, 0x04, 0x68, 0x11, 0x8E, 0xFD, 0x0E, 0x03,
  0x70, 0xED, 0x0C, 0x73, 0x05, 0x0B, 0xFA, 0x0C, 0x02, 0x71, 0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE,
  0xFD, 0xA4, 0x80, 0xBD, 0x00, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF8, 0x2E, 0x9C, 0xEF, 0xFF, 0xFC, 0x81, 0xDC,
  0x94, 0x86, 0x23, 0x57, 0x9B, 0xCE, 0xFF, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x77, 0x20, 0x6F, 0xD0,
  0x27, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x20,
  0x20, 0x8F, 0xD0, 0x50, 0x17, 0x68, 0x62, 0x35, 0x79, 0xAC, 0xEF, 0xFC, 0x86, 0xEC, 0xA8, 0x75,
  0x31, 0x20, 0xC8, 0x0C, 0x0F, 0x0C, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0xE0,
  // "ĩ" (U+0129)
  0x74, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x10, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x04, 0xFE, 0x0C, 0x06, 0x70, 0x5E, 0x0C, 0x76, 0x01, 0x0E, 0xFF, 0x98,
  0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x60, 0xAF, 0xFF, 0xFA, 0x06, 0x75, 0x03, 0xFF, 0xFF,
  0xB0, 0x27, 0x50, 0xAF, 0xFF, 0xFA, 0x0C, 0x76, 0xFF, 0xFF, 0xB0, 0x57, 0x50, 0x5F, 0xFF, 0xFA,
  0x0C, 0x76, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27, 0x60, 0xCE, 0x04, 0x68,
  0x11, 0x8E, 0xFD, 0x0E, 0x03, 0x77, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27, 0x71,
  0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xCB, 0x00, 0x02, 0xFF, 0xFD, 0x0C, 0x77,
  0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7,
  0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF,
  0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45, 0x79, 0xAC, 0xEF, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F,
  0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8, 0x2E, 0x75, 0x27, 0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF,
  0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09,
  0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F,
  0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98,
  0x0C, 0x7F, 0x07,
  // "Ī" (U+012A)
  0x50, 0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x30,
  0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F,
  0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x30, 0x9F, 0xFF, 0xD0, 0xA8, 0x0C, 0x93, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x82, 0xE9, 0xCE, 0xFF, 0xFF, 0xC8, 0x1D, 0xC9, 0x48, 0x62, 0x35, 0x79, 0xBC,
  0xEF, 0xF8, 0x6E, 0xCA, 0x87, 0x53, 0x17, 0x72, 0x06, 0xFD, 0x02, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x72, 0x02, 0x08, 0xFD, 0x05, 0x01, 0x76,
  0x86, 0x23, 0x57, 0x9A, 0xCE, 0xFF, 0xC8, 0x6E, 0xCA, 0x87, 0x53, 0x12, 0x0C, 0x80, 0xC0, 0xF0,
  0xC0, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F,
  0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F,
  0x0E,
  // "ī" (U+012B)
  0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0,
  0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xD8, 0x20, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02,
  0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30,
  0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73,
  0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45, 0x79,
  0xAC, 0xEF, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F,
  0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8,
  0x2E, 0x75, 0x27, 0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24,
  0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F,
  0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98,
  0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  // "Ĭ" (U+012C)
  0x40, 0x68, 0x02, 0x70, 0x57, 0x70, 0x18, 0x03, 0x70, 0x27, 0x0B, 0xE0, 0xC7, 0x70, 0x4F, 0x04,
  0x70, 0xAF, 0x01, 0x76, 0x09, 0xF0, 0x27, 0x08, 0xF0, 0xA7, 0x50, 0x20, 0xEF, 0x71, 0x04, 0xF9,
  0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x2F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x13, 0x6B, 0xFA, 0x07,
  0x72, 0x0A, 0xFF, 0xFE, 0x02, 0x72, 0x03, 0xFF, 0xFD, 0x09, 0x74, 0x0A, 0xFF, 0xFB, 0x0E, 0x01,
  0x74, 0x01, 0x0D, 0xFF, 0xFA, 0x04, 0x76, 0x03, 0x0E, 0xFF, 0xF0, 0x67, 0x71, 0x03, 0x0D, 0xFF,
  0xD0, 0x67, 0x73, 0x01, 0x0B, 0xFF, 0xA0, 0xD0, 0x37, 0x76, 0x04, 0x0B, 0xFD, 0x0D, 0x05, 0x77,
  0x73, 0x89, 0x22, 0x6A, 0xCD, 0xEF, 0xDC, 0xA6, 0x28, 0x0B, 0xD5, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x82,
  0xE9, 0xCE, 0xFF, 0xFF, 0xC8, 0x1D, 0xC9, 0x48, 0x62, 0x35, 0x79, 0xBC, 0xEF, 0xF8, 0x6E, 0xCA,
  0x87, 0x53, 0x17, 0x72, 0x06, 0xFD, 0x02, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x72, 0x02, 0x08, 0xFD, 0x05, 0x01, 0x76, 0x86, 0x23, 0x57, 0x9A,
  0xCE, 0xFF, 0xC8, 0x6E, 0xCA, 0x87, 0x53, 0x12, 0x0C, 0x80, 0xC0, 0xF0, 0xC0, 0xE8, 0x0C, 0x0F,
  0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F,
  0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "ĭ" (U+012D)
  0x70, 0x68, 0x02, 0x70, 0x57, 0x70, 0x18, 0x03, 0x70, 0x27, 0x70, 0xBE, 0x0C, 0x77, 0x04, 0xF0,
  0x47, 0x70, 0xAF, 0x01, 0x76, 0x09, 0xF0, 0x27, 0x70, 0x8F, 0x0A, 0x75, 0x02, 0x0E, 0xF7, 0x71,
  0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x72, 0xFA, 0x82, 0xE9, 0x41, 0x28, 0x21, 0x36,
  0xBF, 0xA0, 0x77, 0x72, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x3F, 0xFF, 0xD0, 0x97, 0x74, 0x0A,
  0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x40, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x76, 0x03, 0x0E, 0xFF, 0xF0,
  0x67, 0x77, 0x10, 0x30, 0xDF, 0xFD, 0x06, 0x77, 0x73, 0x01, 0x0B, 0xFF, 0xA0, 0xD0, 0x37, 0x77,
  0x60, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x73, 0x89, 0x22, 0x6A, 0xCD, 0xEF, 0xDC, 0xA6, 0x28,
  0x0C, 0xB5, 0x00, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF,
  0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF,
  0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F,
  0xFF, 0xD0, 0xC7, 0x73, 0x81, 0x2D, 0xEF, 0xFF, 0xB0, 0xC7, 0x77, 0x86, 0x24, 0x57, 0x9A, 0xCE,
  0xFF, 0x90, 0xC7, 0x77, 0x72, 0x02, 0x06, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F,
  0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x82, 0x13, 0x6A, 0xFD, 0x82, 0xE7,
  0x52, 0x77, 0x58, 0x41, 0x46, 0x9B, 0xEF, 0xFE, 0x83, 0xEC, 0x96, 0x37, 0x18, 0x42, 0x47, 0x9C,
  0xEF, 0xFF, 0xFC, 0x85, 0xDA, 0x75, 0x20, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7,
  0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  // "Į" (U+012E)
  0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0,
  0x0E, 0x80, 0xC0, 0xF8, 0x2E, 0x9C, 0xEF, 0xFF, 0xFC, 0x81, 0xDC, 0x94, 0x86, 0x23, 0x57, 0x9B,
  0xCE, 0xFF, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x77, 0x20, 0x6F, 0xD0, 0x27, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30,
  0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F,
  0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0,
  0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77,
  0x30, 0x6F, 0xD0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x17, 0x77, 0x20, 0x20, 0x8F, 0xD0, 0x50, 0x17,
  0x68, 0x62, 0x35, 0x79, 0xAC, 0xEF, 0xFC, 0x86, 0xEC, 0xA8, 0x75, 0x31, 0x20, 0xC8, 0x0C, 0x0F,
  0x0C, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0,
  0xF0, 0xE7, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x76,
  0x03, 0x0E, 0xF0, 0x47, 0x77, 0x60, 0x10, 0xDF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0xC7, 0x77, 0x70,
  0x4F, 0x90, 0x37, 0x77, 0x70, 0xCF, 0x0C, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x77, 0x08, 0xF9,
  0x04, 0x77, 0x77, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x0D, 0xF9, 0x0C,
  0x77, 0x77, 0x0C, 0xFA, 0x0B, 0x03, 0x28, 0x12, 0x59, 0x77, 0x70, 0xAF, 0xFA, 0x77, 0x70, 0x6F,
  0xFA, 0x77, 0x70, 0x1F, 0xFA, 0x77, 0x71, 0x09, 0xFF, 0x97, 0x77, 0x20, 0xCF, 0xF7, 0x77, 0x20,
  0x10, 0xCF, 0xE7, 0x77, 0x40, 0x80, 0xEF, 0xC7, 0x77, 0x58, 0x31, 0x6A, 0xDE, 0xA8, 0x3E, 0xC9,
  0x61, 0x50,
  // "į" (U+012F)
  0x77, 0x58, 0x74, 0x9D, 0xEF, 0xED, 0x94, 0x77, 0x77, 0x60, 0x20, 0xCF, 0xA0, 0xC0, 0x27, 0x77,
  0x73, 0x01, 0x0D, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x9F, 0xE0, 0x97, 0x77, 0x71, 0x01, 0xFF,
  0x97, 0x77, 0x71, 0x04, 0xFF, 0x90, 0x47, 0x77, 0x70, 0x6F, 0xF9, 0x06, 0x77, 0x77, 0x07, 0xFF,
  0x90, 0x67, 0x77, 0x70, 0x6F, 0xF9, 0x05, 0x77, 0x77, 0x04, 0xFF, 0x90, 0x37, 0x77, 0x70, 0x1F,
  0xF0, 0xE7, 0x77, 0x72, 0x0A, 0xFE, 0x08, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xC0, 0xD0, 0x17, 0x77,
  0x73, 0x02, 0x0D, 0xFA, 0x0B, 0x01, 0x77, 0x77, 0x68, 0x75, 0xAD, 0xEF, 0xEC, 0x94, 0x80, 0xCB,
  0x50, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0,
  0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD,
  0x0C, 0x77, 0x38, 0x12, 0xDE, 0xFF, 0xFB, 0x0C, 0x77, 0x78, 0x62, 0x45, 0x79, 0xAC, 0xEF, 0xF9,
  0x0C, 0x77, 0x77, 0x20, 0x20, 0x6F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD,
  0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x78, 0x21, 0x36, 0xAF, 0xD8, 0x2E, 0x75, 0x27,
  0x75, 0x84, 0x14, 0x69, 0xBE, 0xFF, 0xE8, 0x3E, 0xC9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF,
  0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80,
  0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x27,
  0x77, 0x76, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x76, 0x03, 0x0E, 0xF0, 0x47, 0x77, 0x76, 0x01,
  0x0D, 0xF0, 0x77, 0x77, 0x77, 0x0A, 0xF0, 0xC7, 0x77, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x70,
  0xCF, 0x0C, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x77, 0x08, 0xF9, 0x04, 0x77, 0x77, 0x70,
  0xBF, 0x90, 0x47, 0x77, 0x77, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x90, 0xC7, 0x77, 0x77,
  0x0C, 0xFA, 0x0B, 0x03, 0x28, 0x12, 0x59, 0x77, 0x77, 0x0A, 0xFF, 0xA7, 0x77, 0x70, 0x6F, 0xFA,
  0x77, 0x77, 0x01, 0xFF, 0xA7, 0x77, 0x71, 0x09, 0xFF, 0x97, 0x77, 0x72, 0x0C, 0xFF, 0x77, 0x77,
  0x20, 0x10, 0xCF, 0xE7, 0x77, 0x74, 0x08, 0x0E, 0xFC, 0x77, 0x77, 0x58, 0x31, 0x6A, 0xDE, 0xA8,
  0x3E, 0xC9, 0x61, 0x50,
  // "İ" (U+0130)
  0x77, 0x82, 0x17, 0xBE, 0xA8, 0x2D, 0xB7, 0x17, 0x77, 0x60, 0x7F, 0xB0, 0x77, 0x77, 0x40, 0x8F,
  0xD0, 0x77, 0x77, 0x20, 0x2F, 0xF0, 0x17, 0x77, 0x10, 0x9F, 0xF0, 0x77, 0x77, 0x10, 0xCF, 0xF0,
  0xB7, 0x77, 0x10, 0xEF, 0xF0, 0xD7, 0x77, 0x1F, 0xF9, 0x0D, 0x77, 0x71, 0x0E, 0xFF, 0x0D, 0x77,
  0x71, 0x0C, 0xFF, 0x0B, 0x77, 0x71, 0x09, 0xFF, 0x07, 0x77, 0x71, 0x02, 0xFE, 0x0E, 0x01, 0x77,
  0x72, 0x08, 0xFD, 0x06, 0x77, 0x74, 0x08, 0xFA, 0x0E, 0x06, 0x77, 0x76, 0x89, 0x02, 0x8C, 0xEF,
  0xED, 0xB7, 0x18, 0x0B, 0xD6, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C,
  0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C,
  0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x82, 0xE9, 0xCE, 0xFF, 0xFF, 0xC8, 0x1D,
  0xC9, 0x48, 0x62, 0x35, 0x79, 0xBC, 0xEF, 0xF8, 0x6E, 0xCA, 0x87, 0x53, 0x17, 0x72, 0x06, 0xFD,
  0x02, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73,
  0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06,
  0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD,
  0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01,
  0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77,
  0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x73, 0x06, 0xFD, 0x01, 0x77, 0x72,
  0x02, 0x08, 0xFD, 0x05, 0x01, 0x76, 0x86, 0x23, 0x57, 0x9A, 0xCE, 0xFF, 0xC8, 0x6E, 0xCA, 0x87,
  0x53, 0x12, 0x0C, 0x80, 0xC0, 0xF0, 0xC0, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "ı" (U+0131)
  0x20, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7,
  0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C,
  0x77, 0x30, 0x2F, 0xFF, 0xD0, 0xC7, 0x73, 0x02, 0xFF, 0xFD, 0x0C, 0x77, 0x30, 0x2F, 0xFF, 0xD0,
  0xC7, 0x73, 0x81, 0x2D, 0xEF, 0xFF, 0xB0, 0xC7, 0x77, 0x86, 0x24, 0x57, 0x9A, 0xCE, 0xFF, 0x90,
  0xC7, 0x77, 0x72, 0x02, 0x06, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03,
  0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30,
  0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73,
  0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77,
  0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77,
  0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77,
  0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7,
  0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C,
  0x77, 0x77, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0xD0,
  0xC7, 0x77, 0x73, 0x03, 0xFD, 0x0C, 0x77, 0x77, 0x82, 0x13, 0x6A, 0xFD, 0x82, 0xE7, 0x52, 0x77,
  0x58, 0x41, 0x46, 0x9B, 0xEF, 0xFE, 0x83, 0xEC, 0x96, 0x37, 0x18, 0x42, 0x47, 0x9C, 0xEF, 0xFF,
  0xFC, 0x85, 0xDA, 0x75, 0x20, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C,
  0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70,
  // "Ĳ" (U+0132)
  0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02,
  0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD,
  0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0,
  0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F,
  0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD,
  0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06,
  0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F,
  0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50,
  0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05,
  0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75,
  0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00,
  0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27,
  0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0,
  0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02,
  0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD,
  0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0,
  0x27, 0x50, 0x6F, 0xD0, 0x05, 0xFD, 0x02, 0x75, 0x06, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x6F,
  0xD0, 0x05, 0xFD, 0x02, 0x75, 0x07, 0xFD, 0x00, 0x5F, 0xD0, 0x27, 0x50, 0x7F, 0xD0, 0x40, 0x5F,
  0xD0, 0x27, 0x50, 0x8F, 0xD0, 0x47, 0x77, 0x50, 0xAF, 0xD0, 0x27, 0x77, 0x50, 0xDF, 0xD0, 0x17,
  0x77, 0x40, 0x1F, 0xD0, 0xE7, 0x77, 0x50, 0x7F, 0xD0, 0xC7, 0x77, 0x50, 0xDF, 0xD0, 0x97, 0x77,
  0x40, 0x9F, 0xE0, 0x57, 0x77, 0x30, 0x8F, 0xF8, 0x41, 0x02, 0x86, 0x37, 0x73, 0x03, 0x0B, 0xFF,
  0x0B, 0x20, 0x4C, 0x86, 0xDB, 0x97, 0x53, 0x21, 0x38, 0x31, 0x25, 0x8C, 0xFF, 0xA0, 0x52, 0x04,
  0xFF, 0xFF, 0xF0, 0xE3, 0x04, 0xFF, 0xFF, 0xF0, 0x63, 0x04, 0xFF, 0xFF, 0xE0, 0xC4, 0x04, 0xFF,
  0xFF, 0xE0, 0x34, 0x04, 0xFF, 0xFF, 0xD0, 0x55, 0x04, 0xFF, 0xFF, 0xC0, 0x76, 0x04, 0xFF, 0xFF,
  0xA0, 0xE0, 0x57, 0x04, 0xFF, 0xFF, 0x90, 0xB0, 0x27, 0x10, 0x4F, 0xFF, 0xE0, 0xC0, 0x47, 0x48,
  0x15, 0x8C, 0xFF, 0xF8, 0x1C, 0x82, 0x77, 0x38, 0x72, 0x47, 0x9A, 0xBD, 0xDE, 0xB8, 0x6E, 0xED,
  0xB9, 0x74, 0x17, 0x71,
  // "ĳ" (U+0133)
  0x48, 0x73, 0x8C, 0xEF, 0xED, 0xA6, 0x77, 0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x93, 0x70, 0xAF, 0xA0,
  0xE0, 0x47, 0x50, 0x40, 0xDF, 0xA0, 0xA0, 0x14, 0x0B, 0xFD, 0x04, 0x73, 0x03, 0xFD, 0x0C, 0x30,
  0x6F, 0xE0, 0xD7, 0x30, 0xCF, 0xE0, 0x62, 0x0C, 0xFF, 0x04, 0x71, 0x03, 0xFF, 0x81, 0xC0, 0x1F,
  0xF9, 0x07, 0x71, 0x07, 0xFF, 0x90, 0x10, 0x2F, 0xF9, 0x09, 0x71, 0x09, 0xFF, 0x90, 0x20, 0x3F,
  0xF9, 0x0A, 0x71, 0x0A, 0xFF, 0x90, 0x30, 0x2F, 0xF9, 0x09, 0x71, 0x09, 0xFF, 0x90, 0x20, 0x1F,
  0xF9, 0x07, 0x71, 0x07, 0xFF, 0x92, 0x0C, 0xFF, 0x03, 0x71, 0x04, 0xFF, 0x0C, 0x20, 0x6F, 0xE0,
  0xC7, 0x30, 0xDF, 0xE0, 0x53, 0x0C, 0xFC, 0x0E, 0x03, 0x73, 0x03, 0xFD, 0x0B, 0x40, 0x10, 0xBF,
  0xA0, 0xD0, 0x37, 0x50, 0x40, 0xEF, 0xA0, 0x97, 0x87, 0x39, 0xCE, 0xFE, 0xDA, 0x57, 0x72, 0x87,
  0x6A, 0xDE, 0xFE, 0xC8, 0x28, 0x0B, 0xF6, 0x0F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01,
  0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD,
  0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0,
  0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F,
  0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE,
  0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03,
  0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F,
  0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30,
  0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4,
  0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73,
  0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C,
  0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17,
  0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0,
  0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01,
  0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD,
  0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0,
  0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F,
  0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE,
  0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03,
  0xFD, 0x0C, 0x4F, 0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC4, 0xFE, 0x01, 0x73, 0x03, 0xFD, 0x0C, 0x4F,
  0xE0, 0x17, 0x30, 0x3F, 0xD0, 0xC7, 0x77, 0x70, 0x4F, 0xD0, 0xC7, 0x77, 0x70, 0x5F, 0xD0, 0xC7,
  0x77, 0x70, 0x6F, 0xD0, 0xC7, 0x77, 0x70, 0x8F, 0xD0, 0xB7, 0x77, 0x70, 0xBF, 0xD0, 0xA7, 0x77,
  0x60, 0x1F, 0xE0, 0x97, 0x77, 0x60, 0x6F, 0xE0, 0x77, 0x77, 0x60, 0xDF, 0xE0, 0x47, 0x77, 0x50,
  0xAF, 0xF0, 0x16, 0x82, 0x28, 0x41, 0x77, 0x02, 0x0B, 0xFF, 0x0D, 0x70, 0x3B, 0x85, 0xDA, 0x85,
  0x42, 0x13, 0x82, 0x13, 0x6B, 0xFF, 0xA0, 0x87, 0x03, 0xFF, 0xFF, 0xD0, 0x37, 0x03, 0xFF, 0xFF,
  0xC0, 0xC7, 0x10, 0x3F, 0xFF, 0xFC, 0x04, 0x71, 0x03, 0xFF, 0xFF, 0xB0, 0xA7, 0x20, 0x3F, 0xFF,
  0xFA, 0x0D, 0x01, 0x72, 0x03, 0xFF, 0xFF, 0x90, 0xE0, 0x27, 0x30, 0x3F, 0xFF, 0xF0, 0xD0, 0x27,
  0x40, 0x3F, 0xFF, 0xE0, 0xA0, 0x17, 0x50, 0x3F, 0xFF, 0xC0, 0xC0, 0x47, 0x71, 0x82, 0x47, 0xBE,
  0xFF, 0xC8, 0x1E, 0x93, 0x77, 0x78, 0x72, 0x47, 0x9A, 0xCD, 0xEE, 0xA8, 0x5E, 0xEC, 0xB8, 0x62,
  0x77, 0x10,
  // "Ĵ" (U+0134)
  0x77, 0x72, 0x03, 0x80, 0x91, 0x77, 0x77, 0x75, 0x0D, 0xFE, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xF9,
  0x02, 0x77, 0x77, 0x10, 0x2F, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0xCF, 0xFB, 0x07, 0x77, 0x76, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x40, 0x4F, 0xFE, 0x0D, 0x77, 0x73, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB,
  0x0A, 0x77, 0x72, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x08, 0xFB, 0x04, 0x30, 0xBF,
  0xB0, 0x37, 0x75, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x73, 0x03, 0xFA, 0x0E,
  0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x72, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x77,
  0x10, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x60, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF,
  0x0B, 0x80, 0xCD, 0x60, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A,
  0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50,
  0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75,
  0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77,
  0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77,
  0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77,
  0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17,
  0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01,
  0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0,
  0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD,
  0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF,
  0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A,
  0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50,
  0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75,
  0x0A, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xD0, 0x17, 0x77, 0x75, 0x0A, 0xFD, 0x01, 0x77, 0x77,
  0x50, 0xBF, 0xD7, 0x77, 0x76, 0x0C, 0xFD, 0x77, 0x77, 0x60, 0xEF, 0xC0, 0xE7, 0x77, 0x75, 0x01,
  0xFD, 0x0C, 0x77, 0x77, 0x50, 0x4F, 0xD0, 0xB7, 0x77, 0x75, 0x0A, 0xFD, 0x08, 0x77, 0x77, 0x40,
  0x1F, 0xE0, 0x57, 0x77, 0x74, 0x0B, 0xFE, 0x01, 0x77, 0x77, 0x30, 0x8F, 0xE0, 0xD7, 0x48, 0x23,
  0x85, 0x27, 0x71, 0x02, 0x0B, 0xFF, 0x08, 0x74, 0x05, 0xB8, 0x6E, 0xCA, 0x85, 0x42, 0x13, 0x82,
  0x13, 0x7B, 0xFF, 0xA0, 0x27, 0x40, 0x5F, 0xFF, 0xFD, 0x0B, 0x75, 0x05, 0xFF, 0xFF, 0xD0, 0x37,
  0x50, 0x5F, 0xFF, 0xFC, 0x0A, 0x76, 0x05, 0xFF, 0xFF, 0xB0, 0xE0, 0x17, 0x60, 0x5F, 0xFF, 0xFB,
  0x03, 0x77, 0x05, 0xFF, 0xFF, 0xA0, 0x57, 0x71, 0x05, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x20, 0x5F,
  0xFF, 0xE0, 0xB0, 0x17, 0x73, 0x05, 0xFF, 0xFC, 0x0C, 0x04, 0x77, 0x58, 0x21, 0x69, 0xDF, 0xFD,
  0x81, 0xD8, 0x37, 0x77, 0x48, 0x71, 0x36, 0x8A, 0xBD, 0xEE, 0xA8, 0x6E, 0xED, 0xBA, 0x75, 0x17,
  0x77, 0x30,
  // "ĵ" (U+0135)
  0x77, 0x70, 0x38, 0x09, 0x17, 0x77, 0x77, 0x30, 0xDF, 0xE0, 0x87, 0x77, 0x71, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x60, 0x2F, 0xFA, 0x0C, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x40, 0x8F, 0xFD,
  0x03, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7,
  0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x75, 0x08, 0xFB, 0x04, 0x30, 0xBF, 0xB0, 0x37,
  0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x71, 0x03, 0xFA, 0x0E, 0x03, 0x70,
  0x9F, 0xA0, 0xC7, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x60, 0xDF, 0x90,
  0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x40, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xCA,
  0x20, 0x06, 0xFF, 0xFD, 0x09, 0x77, 0x30, 0x6F, 0xFF, 0xD0, 0x97, 0x73, 0x06, 0xFF, 0xFD, 0x09,
  0x77, 0x30, 0x6F, 0xFF, 0xD0, 0x97, 0x73, 0x06, 0xFF, 0xFD, 0x09, 0x77, 0x30, 0x6F, 0xFF, 0xD0,
  0x97, 0x73, 0x06, 0xFF, 0xFD, 0x09, 0x77, 0x30, 0x6F, 0xFF, 0xD0, 0x97, 0x73, 0x06, 0xFF, 0xFD,
  0x09, 0x77, 0x38, 0x32, 0x8A, 0xCD, 0xFF, 0xF9, 0x09, 0x77, 0x72, 0x86, 0x13, 0x56, 0x8A, 0xBD,
  0xFE, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73,
  0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77,
  0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77,
  0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97,
  0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09,
  0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0,
  0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD,
  0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F,
  0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06,
  0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0x97, 0x77, 0x73, 0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0x97, 0x77, 0x73,
  0x06, 0xFD, 0x09, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x97, 0x77, 0x73, 0x08, 0xFD, 0x09, 0x77, 0x77,
  0x30, 0x9F, 0xD0, 0x97, 0x77, 0x73, 0x0C, 0xFD, 0x08, 0x77, 0x77, 0x30, 0xEF, 0xD0, 0x77, 0x77,
  0x72, 0x03, 0xFE, 0x06, 0x77, 0x77, 0x20, 0x9F, 0xE0, 0x47, 0x77, 0x71, 0x02, 0xFF, 0x01, 0x77,
  0x77, 0x01, 0x0C, 0xFE, 0x0E, 0x73, 0x81, 0x47, 0x37, 0x71, 0x04, 0x0D, 0xFF, 0x0A, 0x73, 0x06,
  0xB8, 0x5C, 0x97, 0x53, 0x21, 0x38, 0x21, 0x37, 0xCF, 0xFA, 0x05, 0x73, 0x06, 0xFF, 0xFF, 0xC0,
  0xE7, 0x40, 0x6F, 0xFF, 0xFC, 0x09, 0x74, 0x06, 0xFF, 0xFF, 0xC0, 0x17, 0x40, 0x6F, 0xFF, 0xFB,
  0x07, 0x75, 0x06, 0xFF, 0xFF, 0xA0, 0xB7, 0x60, 0x6F, 0xFF, 0xF9, 0x0D, 0x01, 0x76, 0x06, 0xFF,
  0xFF, 0x0C, 0x01, 0x77, 0x06, 0xFF, 0xFE, 0x08, 0x77, 0x20, 0x6F, 0xFF, 0xC0, 0xA0, 0x27, 0x74,
  0x81, 0x48, 0xCF, 0xFD, 0x81, 0xD8, 0x27, 0x77, 0x38, 0x72, 0x57, 0x9B, 0xCD, 0xEE, 0xA8, 0x5E,
  0xDC, 0xA8, 0x51, 0x77, 0x71,
  // "Ķ" (U+0136)
  0x0E, 0xFC, 0x0C, 0x77, 0x50, 0xAF, 0xE0, 0x90, 0xEF, 0xC0, 0xC7, 0x74, 0x05, 0xFE, 0x81, 0xD0,
  0xEF, 0xC0, 0xC7, 0x73, 0x01, 0x0E, 0xFE, 0x81, 0x30, 0xEF, 0xC0, 0xC7, 0x73, 0x0A, 0xFE, 0x07,
  0x20, 0xEF, 0xC0, 0xC7, 0x72, 0x05, 0xFE, 0x0C, 0x30, 0xEF, 0xC0, 0xC7, 0x71, 0x01, 0x0E, 0xFD,
  0x0E, 0x02, 0x30, 0xEF, 0xC0, 0xC7, 0x71, 0x0A, 0xFE, 0x06, 0x40, 0xEF, 0xC0, 0xC7, 0x70, 0x5F,
  0xE0, 0xA5, 0x0E, 0xFC, 0x0C, 0x76, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x50, 0xEF, 0xC0, 0xC7, 0x60,
  0xAF, 0xE0, 0x46, 0x0E, 0xFC, 0x0C, 0x75, 0x04, 0xFE, 0x09, 0x70, 0xEF, 0xC0, 0xC7, 0x40, 0x10,
  0xDF, 0xD0, 0xD7, 0x10, 0xEF, 0xC0, 0xC7, 0x40, 0x9F, 0xE0, 0x37, 0x10, 0xEF, 0xC0, 0xC7, 0x30,
  0x4F, 0xE0, 0x87, 0x20, 0xEF, 0xC0, 0xC7, 0x30, 0xDF, 0xD0, 0xC7, 0x30, 0xEF, 0xC0, 0xC7, 0x20,
  0x9F, 0xD0, 0xE0, 0x27, 0x30, 0xEF, 0xC0, 0xC7, 0x10, 0x4F, 0xE0, 0x67, 0x40, 0xEF, 0xC0, 0xC7,
  0x10, 0xDF, 0xD0, 0xB7, 0x50, 0xEF, 0xC0, 0xC7, 0x09, 0xFD, 0x0E, 0x01, 0x75, 0x0E, 0xFC, 0x0C,
  0x60, 0x3F, 0xE0, 0x57, 0x60, 0xEF, 0xC0, 0xC6, 0x0D, 0xFD, 0x09, 0x77, 0x0E, 0xFC, 0x0C, 0x50,
  0x8F, 0xD0, 0xD7, 0x71, 0x0E, 0xFC, 0x0C, 0x40, 0x3F, 0xE0, 0x37, 0x71, 0x0E, 0xFC, 0x0C, 0x40,
  0xCF, 0xD0, 0x87, 0x72, 0x0E, 0xFC, 0x0C, 0x30, 0x7F, 0xD0, 0xC7, 0x73, 0x0E, 0xFC, 0x0C, 0x20,
  0x10, 0xEF, 0xD0, 0x27, 0x73, 0x0E, 0xFC, 0x0C, 0x20, 0xAF, 0xD0, 0x77, 0x74, 0x0E, 0xFC, 0x81,
  0xC0, 0x3F, 0xD0, 0xB7, 0x75, 0x0E, 0xFC, 0x81, 0xC0, 0xBF, 0xC0, 0xE0, 0x17, 0x75, 0x0E, 0xFC,
  0x0C, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xC0, 0x0D, 0xFE, 0x07, 0x77, 0x50, 0xEF, 0xFF, 0xD0,
  0xE0, 0x17, 0x74, 0x0E, 0xFF, 0xFE, 0x09, 0x77, 0x40, 0xEF, 0xFF, 0xF0, 0x37, 0x73, 0x0E, 0xFF,
  0xFF, 0x0B, 0x77, 0x30, 0xEF, 0xFF, 0xF9, 0x05, 0x77, 0x20, 0xEF, 0xFF, 0xF9, 0x0D, 0x77, 0x20,
  0xEF, 0xFF, 0xFA, 0x07, 0x77, 0x10, 0xEF, 0xFA, 0x0C, 0x0A, 0xFD, 0x0E, 0x01, 0x77, 0x0E, 0xFF,
  0x98, 0x1C, 0x11, 0xFE, 0x09, 0x77, 0x0E, 0xFF, 0x0B, 0x30, 0x8F, 0xE0, 0x27, 0x60, 0xEF, 0xE0,
  0x94, 0x01, 0x0E, 0xFD, 0x0B, 0x76, 0x0E, 0xFD, 0x08, 0x60, 0x7F, 0xE0, 0x47, 0x50, 0xEF, 0xC0,
  0xD7, 0x10, 0xDF, 0xD0, 0xC7, 0x50, 0xEF, 0xC0, 0xC7, 0x10, 0x6F, 0xE0, 0x67, 0x40, 0xEF, 0xC0,
  0xC7, 0x20, 0xDF, 0xD0, 0xE7, 0x40, 0xEF, 0xC0, 0xC7, 0x20, 0x5F, 0xE0, 0x87, 0x30, 0xEF, 0xC0,
  0xC7, 0x30, 0xCF, 0xE0, 0x27, 0x20, 0xEF, 0xC0, 0xC7, 0x30, 0x3F, 0xE0, 0xA7, 0x20, 0xEF, 0xC0,
  0xC7, 0x40, 0xBF, 0xE0, 0x37, 0x10, 0xEF, 0xC0, 0xC7, 0x40, 0x2F, 0xE0, 0xC7, 0x10, 0xEF, 0xC0,
  0xC7, 0x50, 0x9F, 0xE0, 0x57, 0x0E, 0xFC, 0x0C, 0x75, 0x01, 0xFE, 0x0D, 0x70, 0xEF, 0xC0, 0xC7,
  0x60, 0x8F, 0xE0, 0x76, 0x0E, 0xFC, 0x0C, 0x76, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x50, 0xEF, 0xC0,
  0xC7, 0x70, 0x7F, 0xE0, 0x95, 0x0E, 0xFC, 0x0C, 0x77, 0x10, 0xDF, 0xE0, 0x24, 0x0E, 0xFC, 0x0C,
  0x77, 0x10, 0x6F, 0xE0, 0xB4, 0x0E, 0xFC, 0x0C, 0x77, 0x20, 0xDF, 0xE0, 0x43, 0x0E, 0xFC, 0x0C,
  0x77, 0x20, 0x5F, 0xE0, 0xD3, 0x0E, 0xFC, 0x0C, 0x77, 0x30, 0xCF, 0xE0, 0x62, 0x0E, 0xFC, 0x0C,
  0x77, 0x30, 0x3F, 0xE8, 0x2E, 0x10, 0xEF, 0xC0, 0xC7, 0x74, 0x0B, 0xFE, 0x81, 0x80, 0xEF, 0xC0,
  0xC7, 0x74, 0x02, 0xFF, 0x02, 0x80, 0xCC, 0x70, 0x03, 0xFC, 0x0D, 0x77, 0x77, 0x60, 0x5F, 0xC0,
  0x87, 0x77, 0x76, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x60, 0xAF, 0xB0, 0x97, 0x77, 0x77, 0x0E, 0xFB,
  0x02, 0x77, 0x77, 0x60, 0x1F, 0xB0, 0x97, 0x77, 0x77, 0x05, 0xFB, 0x01, 0x77, 0x77, 0x70, 0x8F,
  0xA0, 0x88, 0x0C, 0x00, 0x0C, 0xF9, 0x0E, 0x01, 0x80, 0xC0, 0x0F, 0xA0, 0x68, 0x0C, 0x00, 0x04,
  0xF9, 0x0C, 0x80, 0xC1, 0x00, 0x8F, 0x90, 0x38, 0x0C, 0x10, 0x0C, 0xF0, 0x88, 0x0C, 0x20, 0x0E,
  0xE0, 0xD7, 0x77, 0x30,
  // "ķ" (U+0137)
  0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77,
  0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77,
  0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77,
  0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07,
  0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0,
  0x77, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x72, 0x02, 0x0E, 0xFE,
  0x82, 0xE2, 0x09, 0xFD, 0x07, 0x77, 0x20, 0xDF, 0xE0, 0xE0, 0x32, 0x09, 0xFD, 0x07, 0x77, 0x10,
  0xBF, 0xF0, 0x53, 0x09, 0xFD, 0x07, 0x77, 0x08, 0xFF, 0x07, 0x40, 0x9F, 0xD0, 0x77, 0x60, 0x6F,
  0xF0, 0x95, 0x09, 0xFD, 0x07, 0x75, 0x04, 0xFF, 0x0A, 0x60, 0x9F, 0xD0, 0x77, 0x40, 0x20, 0xEF,
  0xE0, 0xC7, 0x09, 0xFD, 0x07, 0x73, 0x01, 0x0D, 0xFE, 0x0D, 0x01, 0x70, 0x9F, 0xD0, 0x77, 0x30,
  0xBF, 0xE0, 0xE0, 0x27, 0x10, 0x9F, 0xD0, 0x77, 0x20, 0x9F, 0xF0, 0x47, 0x20, 0x9F, 0xD0, 0x77,
  0x10, 0x6F, 0xF0, 0x57, 0x30, 0x9F, 0xD0, 0x77, 0x04, 0xFF, 0x08, 0x74, 0x09, 0xFD, 0x07, 0x60,
  0x20, 0xEF, 0xE0, 0xA7, 0x50, 0x9F, 0xD0, 0x65, 0x01, 0x0D, 0xFE, 0x0B, 0x76, 0x09, 0xFD, 0x06,
  0x50, 0xBF, 0xE0, 0xD0, 0x17, 0x60, 0x9F, 0xD0, 0x64, 0x09, 0xFE, 0x0E, 0x02, 0x77, 0x09, 0xFD,
  0x05, 0x30, 0x5F, 0xE0, 0xE0, 0x37, 0x71, 0x09, 0xFD, 0x04, 0x20, 0x20, 0xEF, 0xE0, 0x57, 0x72,
  0x09, 0xFD, 0x82, 0x30, 0x1D, 0xFE, 0x06, 0x77, 0x30, 0x9F, 0xD8, 0x11, 0x0A, 0xFE, 0x09, 0x77,
  0x40, 0x9F, 0xD1, 0x06, 0xFE, 0x0B, 0x77, 0x50, 0x9F, 0xC0, 0xD0, 0x2F, 0xF0, 0xE0, 0x17, 0x74,
  0x09, 0xFC, 0x00, 0xCF, 0xF9, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xF9, 0x05, 0x77, 0x30, 0x9F, 0xFF,
  0xF9, 0x0E, 0x01, 0x77, 0x20, 0x9F, 0xFF, 0xFA, 0x0A, 0x77, 0x20, 0x9F, 0xFF, 0xFB, 0x05, 0x77,
  0x10, 0x9F, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xB7, 0x70, 0x9F, 0xFC, 0x08,
  0x03, 0xFE, 0x06, 0x76, 0x09, 0xFF, 0xA0, 0xE0, 0x42, 0x08, 0xFD, 0x0E, 0x02, 0x75, 0x09, 0xFF,
  0x90, 0xC0, 0x14, 0x0D, 0xFD, 0x0B, 0x75, 0x09, 0xFF, 0x08, 0x60, 0x3F, 0xE0, 0x77, 0x40, 0x9F,
  0xD0, 0xE0, 0x57, 0x10, 0x9F, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x77, 0x30, 0xDF, 0xD0, 0xC7, 0x30,
  0x9F, 0xD0, 0x77, 0x30, 0x4F, 0xE0, 0x77, 0x20, 0x9F, 0xD0, 0x77, 0x40, 0x9F, 0xE0, 0x27, 0x10,
  0x9F, 0xD0, 0x77, 0x50, 0xDF, 0xD0, 0xC7, 0x10, 0x9F, 0xD0, 0x77, 0x50, 0x4F, 0xE0, 0x87, 0x09,
  0xFD, 0x07, 0x76, 0x09, 0xFE, 0x03, 0x60, 0x9F, 0xD0, 0x77, 0x60, 0x10, 0xEF, 0xD0, 0xD6, 0x09,
  0xFD, 0x07, 0x77, 0x05, 0xFE, 0x08, 0x50, 0x9F, 0xD0, 0x77, 0x71, 0x0A, 0xFE, 0x03, 0x40, 0x9F,
  0xD0, 0x77, 0x71, 0x01, 0x0E, 0xFD, 0x0D, 0x40, 0x9F, 0xD0, 0x77, 0x72, 0x05, 0xFE, 0x09, 0x30,
  0x9F, 0xD0, 0x77, 0x73, 0x0A, 0xFE, 0x04, 0x20, 0x9F, 0xD0, 0x77, 0x73, 0x01, 0x0E, 0xFD, 0x82,
  0xD1, 0x09, 0xFD, 0x07, 0x77, 0x40, 0x5F, 0xE8, 0x19, 0x09, 0xFD, 0x07, 0x77, 0x50, 0xBF, 0xE0,
  0x48, 0x0C, 0xD5, 0x00, 0x3F, 0xC0, 0xD7, 0x77, 0x77, 0x05, 0xFC, 0x08, 0x77, 0x77, 0x70, 0x8F,
  0xC0, 0x17, 0x77, 0x77, 0x0A, 0xFB, 0x09, 0x80, 0xC0, 0x00, 0xEF, 0xB0, 0x27, 0x77, 0x77, 0x01,
  0xFB, 0x09, 0x80, 0xC0, 0x00, 0x5F, 0xB0, 0x18, 0x0C, 0x00, 0x08, 0xFA, 0x08, 0x80, 0xC1, 0x00,
  0xCF, 0x90, 0xE0, 0x18, 0x0C, 0x10, 0xFA, 0x06, 0x80, 0xC1, 0x00, 0x4F, 0x90, 0xC8, 0x0C, 0x20,
  0x08, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x08, 0x80, 0xC3, 0x00, 0xEE, 0x0D, 0x77, 0x74,
  // "ĸ" (U+0138)
  0x09, 0xFD, 0x07, 0x77, 0x20, 0x20, 0xEF, 0xE8, 0x2E, 0x20, 0x9F, 0xD0, 0x77, 0x72, 0x0D, 0xFE,
  0x0E, 0x03, 0x20, 0x9F, 0xD0, 0x77, 0x71, 0x0B, 0xFF, 0x05, 0x30, 0x9F, 0xD0, 0x77, 0x70, 0x8F,
  0xF0, 0x74, 0x09, 0xFD, 0x07, 0x76, 0x06, 0xFF, 0x09, 0x50, 0x9F, 0xD0, 0x77, 0x50, 0x4F, 0xF0,
  0xA6, 0x09, 0xFD, 0x07, 0x74, 0x02, 0x0E, 0xFE, 0x0C, 0x70, 0x9F, 0xD0, 0x77, 0x30, 0x10, 0xDF,
  0xE0, 0xD0, 0x17, 0x09, 0xFD, 0x07, 0x73, 0x0B, 0xFE, 0x0E, 0x02, 0x71, 0x09, 0xFD, 0x07, 0x72,
  0x09, 0xFF, 0x04, 0x72, 0x09, 0xFD, 0x07, 0x71, 0x06, 0xFF, 0x05, 0x73, 0x09, 0xFD, 0x07, 0x70,
  0x4F, 0xF0, 0x87, 0x40, 0x9F, 0xD0, 0x76, 0x02, 0x0E, 0xFE, 0x0A, 0x75, 0x09, 0xFD, 0x06, 0x50,
  0x10, 0xDF, 0xE0, 0xB7, 0x60, 0x9F, 0xD0, 0x65, 0x0B, 0xFE, 0x0D, 0x01, 0x76, 0x09, 0xFD, 0x06,
  0x40, 0x9F, 0xE0, 0xE0, 0x27, 0x70, 0x9F, 0xD0, 0x53, 0x05, 0xFE, 0x0E, 0x03, 0x77, 0x10, 0x9F,
  0xD0, 0x42, 0x02, 0x0E, 0xFE, 0x05, 0x77, 0x20, 0x9F, 0xD8, 0x23, 0x01, 0xDF, 0xE0, 0x67, 0x73,
  0x09, 0xFD, 0x81, 0x10, 0xAF, 0xE0, 0x97, 0x74, 0x09, 0xFD, 0x10, 0x6F, 0xE0, 0xB7, 0x75, 0x09,
  0xFC, 0x0D, 0x02, 0xFF, 0x0E, 0x01, 0x77, 0x40, 0x9F, 0xC0, 0x0C, 0xFF, 0x90, 0xA7, 0x74, 0x09,
  0xFF, 0xFF, 0x90, 0x57, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0xE0, 0x17, 0x72, 0x09, 0xFF, 0xFF, 0xA0,
  0xA7, 0x72, 0x09, 0xFF, 0xFF, 0xB0, 0x57, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xE0, 0x17, 0x70, 0x9F,
  0xFF, 0xFC, 0x0B, 0x77, 0x09, 0xFF, 0xC0, 0x80, 0x3F, 0xE0, 0x67, 0x60, 0x9F, 0xFA, 0x0E, 0x04,
  0x20, 0x8F, 0xD0, 0xE0, 0x27, 0x50, 0x9F, 0xF9, 0x0C, 0x01, 0x40, 0xDF, 0xD0, 0xB7, 0x50, 0x9F,
  0xF0, 0x86, 0x03, 0xFE, 0x07, 0x74, 0x09, 0xFD, 0x0E, 0x05, 0x71, 0x09, 0xFE, 0x02, 0x73, 0x09,
  0xFD, 0x07, 0x73, 0x0D, 0xFD, 0x0C, 0x73, 0x09, 0xFD, 0x07, 0x73, 0x04, 0xFE, 0x07, 0x72, 0x09,
  0xFD, 0x07, 0x74, 0x09, 0xFE, 0x02, 0x71, 0x09, 0xFD, 0x07, 0x75, 0x0D, 0xFD, 0x0C, 0x71, 0x09,
  0xFD, 0x07, 0x75, 0x04, 0xFE, 0x08, 0x70, 0x9F, 0xD0, 0x77, 0x60, 0x9F, 0xE0, 0x36, 0x09, 0xFD,
  0x07, 0x76, 0x01, 0x0E, 0xFD, 0x0D, 0x60, 0x9F, 0xD0, 0x77, 0x70, 0x5F, 0xE0, 0x85, 0x09, 0xFD,
  0x07, 0x77, 0x10, 0xAF, 0xE0, 0x34, 0x09, 0xFD, 0x07, 0x77, 0x10, 0x10, 0xEF, 0xD0, 0xD4, 0x09,
  0xFD, 0x07, 0x77, 0x20, 0x5F, 0xE0, 0x93, 0x09, 0xFD, 0x07, 0x77, 0x30, 0xAF, 0xE0, 0x42, 0x09,
  0xFD, 0x07, 0x77, 0x30, 0x10, 0xEF, 0xD8, 0x2D, 0x10, 0x9F, 0xD0, 0x77, 0x74, 0x05, 0xFE, 0x81,
  0x90, 0x9F, 0xD0, 0x77, 0x75, 0x0B, 0xFE, 0x04,
  // "Ĺ" (U+0139)
  0x71, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x30, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x20, 0x3F, 0xF0,
  0x47, 0x77, 0x30, 0xCF, 0xE0, 0x57, 0x77, 0x30, 0x6F, 0xE0, 0x57, 0x77, 0x30, 0x10, 0xEF, 0xD0,
  0x57, 0x77, 0x40, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x40, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x20,
  0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x50, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x50, 0x7F, 0xB0, 0xD0, 0x17,
  0x77, 0x50, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x50, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x70, 0xAF, 0xA0,
  0x87, 0x77, 0x71, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0x92, 0x00, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF,
  0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0,
  0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27,
  0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77,
  0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50,
  0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF,
  0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0,
  0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27,
  0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77,
  0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50,
  0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF,
  0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0,
  0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27,
  0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77,
  0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50,
  0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF,
  0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0xE8, 0x0C,
  0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0,
  0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2,
  0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E,
  0x80, 0xC2, 0xF0, 0xA0,
  // "ĺ" (U+013A)
  0x77, 0x73, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x03,
  0xFF, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xFE, 0x05, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xD0, 0x57, 0x77, 0x72, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x20, 0x6F, 0xC0, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x73, 0x01, 0x0D,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0xAF, 0xA0, 0x87, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0xC0,
  0x00, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7,
  0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A,
  0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x50, 0xDF, 0xFF,
  0xB0, 0xA7, 0x76, 0x83, 0x14, 0x7A, 0xDF, 0xFD, 0x0A, 0x77, 0x74, 0x83, 0x14, 0x7B, 0xEF, 0xF0,
  0xA7, 0x77, 0x72, 0x01, 0x08, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77,
  0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7,
  0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A,
  0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0,
  0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD,
  0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F,
  0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x78, 0x21, 0x46, 0xBF, 0xD8, 0x2D, 0x74, 0x17, 0x75, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xE8, 0x3E,
  0xB9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7,
  0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09,
  0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F,
  0x07,
  // "Ļ" (U+013B)
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2,
  0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E,
  0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F,
  0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x80, 0xBF, 0x30, 0x03, 0xFC, 0x0D,
  0x77, 0x76, 0x05, 0xFC, 0x08, 0x77, 0x76, 0x08, 0xFC, 0x01, 0x77, 0x76, 0x0A, 0xFB, 0x09, 0x77,
  0x77, 0x0E, 0xFB, 0x02, 0x77, 0x76, 0x01, 0xFB, 0x09, 0x77, 0x77, 0x05, 0xFB, 0x01, 0x77, 0x77,
  0x08, 0xFA, 0x08, 0x77, 0x77, 0x10, 0xCF, 0x90, 0xE0, 0x17, 0x77, 0x71, 0xFA, 0x06, 0x77, 0x77,
  0x10, 0x4F, 0x90, 0xC7, 0x77, 0x72, 0x08, 0xF9, 0x03, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77,
  0x30, 0xEE, 0x0D, 0x77, 0x50,
  // "ļ" (U+013C)
  0x30, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7,
  0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A,
  0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x50, 0xDF, 0xFF,
  0xB0, 0xA7, 0x76, 0x83, 0x14, 0x7A, 0xDF, 0xFD, 0x0A, 0x77, 0x74, 0x83, 0x14, 0x7B, 0xEF, 0xF0,
  0xA7, 0x77, 0x72, 0x01, 0x08, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77,
  0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7,
  0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A,
  0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0,
  0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD,
  0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F,
  0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77,
  0x78, 0x21, 0x46, 0xBF, 0xD8, 0x2D, 0x74, 0x17, 0x75, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xE8, 0x3E,
  0xB9, 0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7,
  0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09,
  0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F,
  0x07, 0x80, 0xCB, 0x20, 0x03, 0xFC, 0x0D, 0x77, 0x77, 0x40, 0x5F, 0xC0, 0x87, 0x77, 0x74, 0x08,
  0xFC, 0x01, 0x77, 0x77, 0x40, 0xAF, 0xB0, 0x97, 0x77, 0x75, 0x0E, 0xFB, 0x02, 0x77, 0x77, 0x40,
  0x1F, 0xB0, 0x97, 0x77, 0x75, 0x05, 0xFB, 0x01, 0x77, 0x77, 0x50, 0x8F, 0xA0, 0x87, 0x77, 0x76,
  0x0C, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x6F, 0xA0, 0x67, 0x77, 0x76, 0x04, 0xF9, 0x0C, 0x77, 0x77,
  0x70, 0x8F, 0x90, 0x37, 0x77, 0x77, 0x0C, 0xF0, 0x88, 0x0C, 0x00, 0x0E, 0xE0, 0xD7, 0x77, 0x20,
  // "Ľ" (U+013D)
  0x0E, 0xFD, 0x02, 0x76, 0x0C, 0xFC, 0x03, 0x0E, 0xFD, 0x02, 0x76, 0x0E, 0xFB, 0x81, 0xE0, 0xEF,
  0xD0, 0x27, 0x50, 0x1F, 0xC8, 0x17, 0x0E, 0xFD, 0x02, 0x75, 0x04, 0xFB, 0x82, 0xE1, 0x0E, 0xFD,
  0x02, 0x75, 0x07, 0xFB, 0x08, 0x20, 0xEF, 0xD0, 0x27, 0x50, 0xAF, 0xA0, 0xE0, 0x12, 0x0E, 0xFD,
  0x02, 0x75, 0x0D, 0xFA, 0x08, 0x30, 0xEF, 0xD0, 0x27, 0x40, 0x1F, 0xA0, 0xE0, 0x13, 0x0E, 0xFD,
  0x02, 0x74, 0x05, 0xFA, 0x06, 0x40, 0xEF, 0xD0, 0x27, 0x40, 0x8F, 0x90, 0xD5, 0x0E, 0xFD, 0x02,
  0x74, 0x0C, 0xF9, 0x04, 0x50, 0xEF, 0xD0, 0x27, 0x30, 0x1F, 0x90, 0xA6, 0x0E, 0xFD, 0x02, 0x73,
  0x05, 0xF0, 0xE0, 0x16, 0x0E, 0xFD, 0x02, 0x73, 0x06, 0xF0, 0x57, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD,
  0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02,
  0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77,
  0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75,
  0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x0E, 0xFD, 0x02, 0x77, 0x75, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C,
  0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0,
  0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2,
  0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0A,
  // "ľ" (U+013E)
  0x30, 0x7F, 0xFF, 0xC0, 0xA6, 0x07, 0xFC, 0x08, 0x30, 0x7F, 0xFF, 0xC0, 0xA6, 0x0A, 0xFC, 0x04,
  0x30, 0x7F, 0xFF, 0xC0, 0xA6, 0x0C, 0xFB, 0x0C, 0x40, 0x7F, 0xFF, 0xC0, 0xA6, 0xFC, 0x05, 0x40,
  0x7F, 0xFF, 0xC0, 0xA5, 0x02, 0xFB, 0x0C, 0x50, 0x7F, 0xFF, 0xC0, 0xA5, 0x05, 0xFB, 0x05, 0x50,
  0x7F, 0xFF, 0xC0, 0xA5, 0x09, 0xFA, 0x0C, 0x60, 0x6F, 0xFF, 0xC0, 0xA5, 0x0C, 0xFA, 0x04, 0x78,
  0x31, 0x47, 0xAD, 0xFF, 0xE0, 0xA5, 0xFA, 0x0B, 0x76, 0x83, 0x14, 0x7A, 0xDF, 0xF9, 0x0A, 0x40,
  0x4F, 0xA0, 0x27, 0x74, 0x81, 0x14, 0xAF, 0xD0, 0xA4, 0x07, 0xF9, 0x09, 0x77, 0x70, 0x6F, 0xD0,
  0xA4, 0x0B, 0xF0, 0xD7, 0x77, 0x10, 0x6F, 0xD0, 0xA4, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xFD, 0x0A,
  0x30, 0x1F, 0x0A, 0x77, 0x72, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77,
  0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77,
  0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7,
  0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A,
  0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0,
  0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD,
  0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F,
  0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70,
  0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77,
  0x77, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0xD0, 0xA7, 0x77, 0x77, 0x06, 0xFD, 0x0A, 0x77,
  0x77, 0x38, 0x31, 0x46, 0x9D, 0xFD, 0x83, 0xE9, 0x74, 0x17, 0x77, 0x84, 0x14, 0x69, 0xCE, 0xFF,
  0xF9, 0x83, 0xEB, 0x85, 0x27, 0x38, 0x41, 0x46, 0x9C, 0xEF, 0xFF, 0xFE, 0x83, 0xC9, 0x74, 0x14,
  0x09, 0x80, 0xC7, 0xF0, 0x74, 0x09, 0x80, 0xC7, 0xF0, 0x74, 0x09, 0x80, 0xC7, 0xF0, 0x74, 0x09,
  0x80, 0xC7, 0xF0, 0x74, 0x09, 0x80, 0xC7, 0xF0, 0x74, 0x09, 0x80, 0xC7, 0xF0, 0x74, 0x09, 0x80,
  0xC7, 0xF0, 0x74, 0x09, 0x80, 0xC7, 0xF0, 0x74,
  // "Ŀ" (U+013F)
  0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E,
  0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD,
  0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02,
  0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77,
  0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76,
  0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E,
  0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x87, 0x17, 0xBD,
  0xFE, 0xDA, 0x64, 0x0E, 0xFD, 0x02, 0x76, 0x07, 0xFA, 0x0E, 0x04, 0x20, 0xEF, 0xD0, 0x27, 0x50,
  0x8F, 0xD8, 0x14, 0x0E, 0xFD, 0x02, 0x74, 0x03, 0xFE, 0x81, 0xE1, 0xEF, 0xD0, 0x27, 0x40, 0xAF,
  0xF0, 0x70, 0xEF, 0xD0, 0x27, 0x40, 0xEF, 0xF0, 0xC0, 0xEF, 0xD0, 0x27, 0x30, 0x1F, 0xFA, 0x0E,
  0xFD, 0x02, 0x73, 0x02, 0xFF, 0xA0, 0xEF, 0xD0, 0x27, 0x30, 0x2F, 0xFA, 0x0E, 0xFD, 0x02, 0x73,
  0x01, 0xFF, 0xA0, 0xEF, 0xD0, 0x27, 0x40, 0xDF, 0xF0, 0xB0, 0xEF, 0xD0, 0x27, 0x40, 0x8F, 0xF0,
  0x60, 0xEF, 0xD0, 0x27, 0x40, 0x1F, 0xE8, 0x1D, 0x0E, 0xFD, 0x02, 0x75, 0x05, 0xFD, 0x81, 0x30,
  0xEF, 0xD0, 0x27, 0x60, 0x50, 0xEF, 0x90, 0xD0, 0x32, 0x0E, 0xFD, 0x02, 0x77, 0x18, 0x66, 0xBD,
  0xFE, 0xDA, 0x54, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02,
  0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77,
  0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76,
  0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E,
  0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0xFD, 0x02, 0x77, 0x76, 0x0E, 0x80,
  0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2,
  0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8,
  0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF8, 0x1A,
  0x0E, 0x80, 0xC2, 0xF8, 0x1A, 0x0E, 0x80, 0xC2, 0xF0, 0xA1,
  // "ŀ" (U+0140)
  0x30, 0x7F, 0xFF, 0xC0, 0xA7, 0x77, 0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF,
  0xC0, 0xA7, 0x77, 0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xC0, 0xA7, 0x77,
  0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xC0, 0xA7, 0x77, 0x72, 0x07, 0xFF,
  0xFC, 0x0A, 0x77, 0x77, 0x20, 0x50, 0xDF, 0xFF, 0xB0, 0xA7, 0x77, 0x74, 0x83, 0x14, 0x7A, 0xDF,
  0xFD, 0x0A, 0x80, 0xC1, 0x08, 0x31, 0x47, 0xBE, 0xFF, 0x0A, 0x80, 0xC6, 0x00, 0x10, 0x8F, 0xD0,
  0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD,
  0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F,
  0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06,
  0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00,
  0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70,
  0x06, 0xFD, 0x0A, 0x77, 0x87, 0x17, 0xBD, 0xFE, 0xDA, 0x67, 0x76, 0x06, 0xFD, 0x0A, 0x76, 0x07,
  0xFA, 0x0E, 0x04, 0x77, 0x40, 0x6F, 0xD0, 0xA7, 0x50, 0x8F, 0xD0, 0x47, 0x73, 0x06, 0xFD, 0x0A,
  0x74, 0x03, 0xFE, 0x0E, 0x01, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x40, 0xAF, 0xF0, 0x77, 0x72, 0x06,
  0xFD, 0x0A, 0x74, 0x0E, 0xFF, 0x0C, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x30, 0x1F, 0xFA, 0x77, 0x20,
  0x6F, 0xD0, 0xA7, 0x30, 0x2F, 0xFA, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x30, 0x2F, 0xFA, 0x77, 0x20,
  0x6F, 0xD0, 0xA7, 0x30, 0x1F, 0xFA, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x40, 0xDF, 0xF0, 0xB7, 0x72,
  0x06, 0xFD, 0x0A, 0x74, 0x08, 0xFF, 0x06, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x40, 0x1F, 0xE0, 0xD7,
  0x73, 0x06, 0xFD, 0x0A, 0x75, 0x05, 0xFD, 0x03, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x60, 0x50, 0xEF,
  0x90, 0xD0, 0x37, 0x74, 0x06, 0xFD, 0x0A, 0x77, 0x18, 0x66, 0xBD, 0xFE, 0xDA, 0x57, 0x76, 0x06,
  0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00,
  0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70,
  0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7,
  0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C,
  0x70, 0x06, 0xFD, 0x0A, 0x80, 0xC7, 0x00, 0x6F, 0xD0, 0xA8, 0x0C, 0x70, 0x06, 0xFD, 0x0A, 0x80,
  0xC4, 0x08, 0x21, 0x46, 0xBF, 0xD8, 0x2D, 0x74, 0x17, 0x77, 0x73, 0x84, 0x24, 0x79, 0xCE, 0xFF,
  0xE8, 0x3E, 0xB9, 0x63, 0x77, 0x68, 0x42, 0x47, 0x9C, 0xEF, 0xFF, 0xFC, 0x83, 0xDA, 0x75, 0x27,
  0x60, 0x98, 0x0C, 0x7F, 0x07, 0x75, 0x09, 0x80, 0xC7, 0xF0, 0x77, 0x50, 0x98, 0x0C, 0x7F, 0x07,
  0x75, 0x09, 0x80, 0xC7, 0xF0, 0x77, 0x50, 0x98, 0x0C, 0x7F, 0x07, 0x75, 0x09, 0x80, 0xC7, 0xF0,
  0x77, 0x50, 0x98, 0x0C, 0x7F, 0x07, 0x75, 0x09, 0x80, 0xC7, 0xF0, 0x77, 0x50,
  // "Ł" (U+0141)
  0x71, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77,
  0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7,
  0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B,
  0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0,
  0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD,
  0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F,
  0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB5, 0x06, 0x0B, 0x77,
  0x77, 0x04, 0xFD, 0x0B, 0x30, 0x30, 0xCA, 0x06, 0x77, 0x76, 0x04, 0xFD, 0x82, 0xB0, 0x19, 0xC0,
  0xE0, 0x17, 0x77, 0x50, 0x4F, 0xD8, 0x1B, 0x6E, 0xE0, 0x97, 0x77, 0x50, 0x4F, 0xFF, 0x90, 0x37,
  0x77, 0x40, 0x4F, 0xFF, 0x90, 0xC7, 0x77, 0x40, 0x4F, 0xFF, 0xA0, 0x67, 0x77, 0x30, 0x4F, 0xFF,
  0xA0, 0xE0, 0x17, 0x77, 0x20, 0x4F, 0xFF, 0xA0, 0xB0, 0x27, 0x77, 0x20, 0x4F, 0xFF, 0x0D, 0x05,
  0x77, 0x74, 0x04, 0xFF, 0xE0, 0x87, 0x77, 0x60, 0x5F, 0xFC, 0x0B, 0x02, 0x77, 0x76, 0x06, 0x0E,
  0xFF, 0xA0, 0xD0, 0x47, 0x77, 0x60, 0x30, 0xCF, 0xFA, 0x0E, 0x07, 0x77, 0x76, 0x01, 0x09, 0xFF,
  0xB0, 0xA0, 0x17, 0x77, 0x60, 0x60, 0xEF, 0xFB, 0x0B, 0x77, 0x76, 0x02, 0x0C, 0xFF, 0xD0, 0xB7,
  0x77, 0x70, 0xDF, 0xFD, 0x0B, 0x77, 0x77, 0x05, 0xFF, 0xD0, 0xB7, 0x77, 0x71, 0x0B, 0xFF, 0xC0,
  0xB7, 0x77, 0x71, 0x03, 0xFF, 0xC0, 0xB7, 0x77, 0x72, 0x09, 0xFF, 0xB0, 0xB7, 0x77, 0x72, 0x01,
  0x0E, 0xFF, 0xA0, 0xB7, 0x77, 0x73, 0x06, 0xA0, 0x90, 0x5F, 0xD0, 0xB7, 0x77, 0x74, 0x82, 0x93,
  0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77,
  0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77,
  0x77, 0x04, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0xB7, 0x77, 0x77, 0x04, 0xFD, 0x0B, 0x77,
  0x77, 0x70, 0x48, 0x0C, 0x3F, 0x04, 0x71, 0x04, 0x80, 0xC3, 0xF0, 0x47, 0x10, 0x48, 0x0C, 0x3F,
  0x04, 0x71, 0x04, 0x80, 0xC3, 0xF0, 0x47, 0x10, 0x48, 0x0C, 0x3F, 0x04, 0x71, 0x04, 0x80, 0xC3,
  0xF0, 0x47, 0x10, 0x48, 0x0C, 0x3F, 0x04, 0x71, 0x04, 0x80, 0xC3, 0xF0, 0x47, 0x10, 0x48, 0x0C,
  0x3F, 0x04, 0x71, 0x04, 0x80, 0xC3, 0xF0, 0x47, 0x10, 0x48, 0x0C, 0x3F, 0x04, 0x71, 0x04, 0x80,
  0xC3, 0xF0, 0x40,
  // "ł" (U+0142)
  0x30, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7,
  0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A,
  0x77, 0x40, 0x7F, 0xFF, 0xC0, 0xA7, 0x74, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x40, 0x50, 0xDF, 0xFF,
  0xB0, 0xA7, 0x76, 0x83, 0x14, 0x7A, 0xDF, 0xFD, 0x0A, 0x77, 0x74, 0x83, 0x14, 0x7B, 0xEF, 0xF0,
  0xA7, 0x77, 0x72, 0x01, 0x08, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73,
  0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x40, 0x30, 0x57, 0x77, 0x40, 0x6F, 0xD0,
  0xA2, 0x83, 0x19, 0xFE, 0x17, 0x77, 0x30, 0x6F, 0xD8, 0x2A, 0x06, 0xEB, 0x0A, 0x77, 0x73, 0x06,
  0xFD, 0x00, 0xCE, 0x04, 0x77, 0x72, 0x06, 0xFF, 0xE0, 0xD7, 0x77, 0x20, 0x6F, 0xFF, 0x07, 0x77,
  0x71, 0x06, 0xFF, 0xF0, 0xE0, 0x27, 0x77, 0x06, 0xFF, 0xF9, 0x0A, 0x77, 0x70, 0x6F, 0xFF, 0x90,
  0xD0, 0x17, 0x76, 0x06, 0xFF, 0xE0, 0xE0, 0x77, 0x77, 0x10, 0x6F, 0xFD, 0x0A, 0x01, 0x77, 0x72,
  0x08, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x20, 0x20, 0xBF, 0xFB, 0x07, 0x77, 0x73, 0x08, 0xFF, 0xB0,
  0xA0, 0x27, 0x77, 0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x77, 0x72, 0x02, 0x0B, 0xFF, 0xC0, 0xA7,
  0x77, 0x20, 0x7F, 0xFE, 0x0A, 0x77, 0x70, 0x40, 0xDF, 0xFF, 0x0A, 0x77, 0x60, 0x5F, 0xFF, 0xA0,
  0xA7, 0x77, 0x0D, 0xFF, 0xF9, 0x0A, 0x77, 0x70, 0x4F, 0xFF, 0x90, 0xA7, 0x77, 0x10, 0xBF, 0xFF,
  0x0A, 0x77, 0x71, 0x02, 0xF9, 0x0E, 0xFD, 0x0A, 0x77, 0x72, 0x08, 0xD8, 0x1D, 0x56, 0xFD, 0x0A,
  0x77, 0x73, 0x0E, 0xB0, 0x82, 0x06, 0xFD, 0x0A, 0x77, 0x73, 0x82, 0x5F, 0xB2, 0x30, 0x6F, 0xD0,
  0xA7, 0x77, 0x40, 0x45, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06,
  0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x6F, 0xD0, 0xA7, 0x77, 0x73, 0x06, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x6F, 0xD0, 0xA7, 0x77, 0x78,
  0x21, 0x46, 0xBF, 0xD8, 0x2D, 0x74, 0x17, 0x75, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xE8, 0x3E, 0xB9,
  0x63, 0x71, 0x84, 0x24, 0x79, 0xCE, 0xFF, 0xFF, 0xC8, 0x5D, 0xA7, 0x52, 0x09, 0x80, 0xC7, 0xF0,
  0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80,
  0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07, 0x09, 0x80, 0xC7, 0xF0, 0x70, 0x98, 0x0C, 0x7F, 0x07,
  // "Ń" (U+0143)
  0x77, 0x74, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0xF0, 0x47, 0x77, 0x72, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x57, 0x77, 0x72,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x73, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x74, 0x0C, 0xFB, 0x0D, 0x02, 0x77,
  0x77, 0x40, 0x7F, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x10,
  0xDF, 0xA0, 0xA7, 0x77, 0x76, 0x0A, 0xFA, 0x08, 0x77, 0x77, 0x70, 0xEF, 0x0E, 0x05, 0x80, 0xCC,
  0x30, 0x0E, 0xFF, 0xA0, 0xE7, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04, 0x77, 0x10, 0xAF, 0xB0,
  0x0E, 0xFF, 0xB0, 0x97, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77, 0x10, 0xAF, 0xB0, 0x0E,
  0xFF, 0xC0, 0x37, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0,
  0xD7, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x87, 0x60,
  0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x37, 0x50, 0xAF, 0xB0,
  0x0E, 0xFF, 0xE0, 0x87, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xD7, 0x50, 0xAF, 0xB0,
  0x0E, 0xFA, 0x0C, 0x09, 0xFB, 0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xD0, 0x4F, 0xB0, 0x87,
  0x40, 0xAF, 0xB0, 0x0E, 0xFA, 0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF, 0xB0, 0x0E, 0xFB, 0x10,
  0x9F, 0xB0, 0x27, 0x30, 0xAF, 0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07, 0x73, 0x0A, 0xFB, 0x00,
  0xEF, 0xB8, 0x12, 0x0E, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x09, 0xFB, 0x02,
  0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0,
  0x42, 0x0E, 0xFA, 0x0C, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09, 0xFB, 0x02, 0x71, 0x0A,
  0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x63, 0x0E,
  0xFA, 0x0C, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02, 0x70, 0xAF, 0xB0, 0x0E,
  0xFB, 0x07, 0x30, 0x4F, 0xB0, 0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84, 0x0E, 0xFA, 0x0C, 0x70,
  0xAF, 0xB0, 0x0E, 0xFB, 0x08, 0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x94, 0x05,
  0xFB, 0x06, 0x60, 0xAF, 0xB0, 0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6, 0x0A, 0xFB, 0x00, 0xEF,
  0xB0, 0xA5, 0x0A, 0xFB, 0x01, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50, 0x5F, 0xB0, 0x65, 0x0A,
  0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x60, 0xAF,
  0xB0, 0x14, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40, 0x9F, 0xB0, 0x0E, 0xFB,
  0x0A, 0x7F, 0xB0, 0xB4, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB, 0x01, 0x30, 0x9F, 0xB0,
  0x0E, 0xFB, 0x0A, 0x70, 0x5F, 0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x1F, 0xB0, 0xB3,
  0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7,
  0x10, 0x5F, 0xB0, 0x52, 0x07, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0, 0xA2, 0x06, 0xFB, 0x00,
  0xEF, 0xB0, 0xA7, 0x20, 0xBF, 0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x5F, 0xB8, 0x15,
  0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7,
  0x30, 0xBF, 0xA8, 0x1E, 0x04, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F, 0xB0, 0x50, 0x3F, 0xB0,
  0x0E, 0xFB, 0x0A, 0x73, 0x01, 0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0xBF, 0xA0,
  0xE0, 0x2F, 0xB0, 0x0E, 0xFB, 0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40,
  0x1F, 0xB0, 0xBF, 0xB0, 0x0E, 0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x06,
  0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x76, 0x0B, 0xFF, 0xD0,
  0x0E, 0xFB, 0x0A, 0x76, 0x06, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01, 0xFF, 0xD0, 0x0E, 0xFB,
  0x0A, 0x77, 0x0B, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77,
  0x01, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x71, 0x07,
  0xFF, 0xB0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0x1F, 0xFB, 0x0E,
  // "ń" (U+0144)
  0x77, 0x73, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x71, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x03,
  0xFF, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xFE, 0x05, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xD0, 0x57, 0x77, 0x72, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x20, 0x6F, 0xC0, 0xE0,
  0x37, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x30, 0xCF, 0xB0, 0xD0, 0x27, 0x77,
  0x73, 0x07, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x30, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x73, 0x01, 0x0D,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0xAF, 0xA0, 0x87, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0x85,
  0x08, 0x43, 0x7A, 0xCE, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x4F, 0xA0, 0xE7, 0x18, 0x12, 0x8E, 0xFE,
  0x81, 0xE8, 0x27, 0x1F, 0xB0, 0x56, 0x08, 0xFF, 0xD0, 0x87, 0xFB, 0x0B, 0x40, 0x20, 0xDF, 0xFF,
  0x0C, 0x01, 0x5F, 0xC0, 0x12, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x01, 0x4F, 0xC8, 0x26, 0x02, 0xEF,
  0xFF, 0xC0, 0xC4, 0xFC, 0x81, 0xC0, 0xCF, 0xFF, 0xE0, 0x93, 0xFD, 0x0E, 0xFF, 0xFF, 0x90, 0x32,
  0x80, 0xC6, 0xF0, 0xB2, 0x80, 0xC7, 0xF0, 0x11, 0xFF, 0xE8, 0x4D, 0xA8, 0x8A, 0xDF, 0xFB, 0x07,
  0x1F, 0xFC, 0x09, 0x02, 0x60, 0x20, 0xAF, 0xF9, 0x0B, 0x1F, 0xFB, 0x05, 0x73, 0x05, 0xFF, 0x0E,
  0x1F, 0xFA, 0x05, 0x75, 0x07, 0xFF, 0x02, 0xFF, 0x90, 0x97, 0x70, 0xCF, 0xE0, 0x4F, 0xF9, 0x01,
  0x77, 0x06, 0xFE, 0x06, 0xFF, 0x0A, 0x77, 0x10, 0x1F, 0xE0, 0x7F, 0xF0, 0x47, 0x72, 0x0D, 0xFD,
  0x07, 0xFF, 0x77, 0x30, 0xBF, 0xD0, 0x7F, 0xE0, 0xB7, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x08, 0x77,
  0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x57, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x03, 0x77, 0x30, 0x8F, 0xD0,
  0x7F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77,
  0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  // "Ņ" (U+0145)
  0x0E, 0xFF, 0xA0, 0xE7, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04, 0x77, 0x10, 0xAF, 0xB0, 0x0E,
  0xFF, 0xB0, 0x97, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF,
  0xC0, 0x37, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0xD7,
  0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x87, 0x60, 0xAF,
  0xB0, 0x0E, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x37, 0x50, 0xAF, 0xB0, 0x0E,
  0xFF, 0xE0, 0x87, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xD7, 0x50, 0xAF, 0xB0, 0x0E,
  0xFA, 0x0C, 0x09, 0xFB, 0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xD0, 0x4F, 0xB0, 0x87, 0x40,
  0xAF, 0xB0, 0x0E, 0xFA, 0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF, 0xB0, 0x0E, 0xFB, 0x10, 0x9F,
  0xB0, 0x27, 0x30, 0xAF, 0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07, 0x73, 0x0A, 0xFB, 0x00, 0xEF,
  0xB8, 0x12, 0x0E, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x09, 0xFB, 0x02, 0x72,
  0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x42,
  0x0E, 0xFA, 0x0C, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09, 0xFB, 0x02, 0x71, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0x52, 0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x63, 0x0E, 0xFA,
  0x0C, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02, 0x70, 0xAF, 0xB0, 0x0E, 0xFB,
  0x07, 0x30, 0x4F, 0xB0, 0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84, 0x0E, 0xFA, 0x0C, 0x70, 0xAF,
  0xB0, 0x0E, 0xFB, 0x08, 0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x94, 0x05, 0xFB,
  0x06, 0x60, 0xAF, 0xB0, 0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6, 0x0A, 0xFB, 0x00, 0xEF, 0xB0,
  0xA5, 0x0A, 0xFB, 0x01, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50, 0x5F, 0xB0, 0x65, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0xA6, 0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x60, 0xAF, 0xB0,
  0x14, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A,
  0x7F, 0xB0, 0xB4, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB, 0x01, 0x30, 0x9F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x70, 0x5F, 0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x1F, 0xB0, 0xB3, 0x08,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10,
  0x5F, 0xB0, 0x52, 0x07, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0, 0xA2, 0x06, 0xFB, 0x00, 0xEF,
  0xB0, 0xA7, 0x20, 0xBF, 0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x5F, 0xB8, 0x15, 0x05,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30,
  0xBF, 0xA8, 0x1E, 0x04, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F, 0xB0, 0x50, 0x3F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x73, 0x01, 0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0xBF, 0xA0, 0xE0,
  0x2F, 0xB0, 0x0E, 0xFB, 0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0x1F,
  0xB0, 0xBF, 0xB0, 0x0E, 0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x06, 0xFF,
  0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x76, 0x0B, 0xFF, 0xD0, 0x0E,
  0xFB, 0x0A, 0x76, 0x06, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A,
  0x77, 0x0B, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x01,
  0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x71, 0x07, 0xFF,
  0xB0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0x1F, 0xFB, 0x0E, 0x80, 0xCC, 0x00, 0x03, 0xFC, 0x0D, 0x77,
  0x77, 0x50, 0x5F, 0xC0, 0x87, 0x77, 0x75, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x50, 0xAF, 0xB0, 0x97,
  0x77, 0x76, 0x0E, 0xFB, 0x02, 0x77, 0x77, 0x50, 0x1F, 0xB0, 0x97, 0x77, 0x76, 0x05, 0xFB, 0x01,
  0x77, 0x77, 0x60, 0x8F, 0xA0, 0x87, 0x77, 0x77, 0x0C, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x7F, 0xA0,
  0x67, 0x77, 0x77, 0x04, 0xF9, 0x0C, 0x80, 0xC0, 0x00, 0x8F, 0x90, 0x38, 0x0C, 0x00, 0x0C, 0xF0,
  0x88, 0x0C, 0x10, 0x0E, 0xE0, 0xD7, 0x77, 0x30,
  // "ņ" (U+0146)
  0x77, 0x78, 0x43, 0x7A, 0xCE, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x4F, 0xA0, 0xE7, 0x18, 0x12, 0x8E,
  0xFE, 0x81, 0xE8, 0x27, 0x1F, 0xB0, 0x56, 0x08, 0xFF, 0xD0, 0x87, 0xFB, 0x0B, 0x40, 0x20, 0xDF,
  0xFF, 0x0C, 0x01, 0x5F, 0xC0, 0x12, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x01, 0x4F, 0xC8, 0x26, 0x02,
  0xEF, 0xFF, 0xC0, 0xC4, 0xFC, 0x81, 0xC0, 0xCF, 0xFF, 0xE0, 0x93, 0xFD, 0x0E, 0xFF, 0xFF, 0x90,
  0x32, 0x80, 0xC6, 0xF0, 0xB2, 0x80, 0xC7, 0xF0, 0x11, 0xFF, 0xE8, 0x4D, 0xA8, 0x8A, 0xDF, 0xFB,
  0x07, 0x1F, 0xFC, 0x09, 0x02, 0x60, 0x20, 0xAF, 0xF9, 0x0B, 0x1F, 0xFB, 0x05, 0x73, 0x05, 0xFF,
  0x0E, 0x1F, 0xFA, 0x05, 0x75, 0x07, 0xFF, 0x02, 0xFF, 0x90, 0x97, 0x70, 0xCF, 0xE0, 0x4F, 0xF9,
  0x01, 0x77, 0x06, 0xFE, 0x06, 0xFF, 0x0A, 0x77, 0x10, 0x1F, 0xE0, 0x7F, 0xF0, 0x47, 0x72, 0x0D,
  0xFD, 0x07, 0xFF, 0x77, 0x30, 0xBF, 0xD0, 0x7F, 0xE0, 0xB7, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x08,
  0x77, 0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x57, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x03, 0x77, 0x30, 0x8F,
  0xD0, 0x7F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x80, 0xCB, 0x10, 0x03, 0xFC, 0x0D, 0x77, 0x77,
  0x40, 0x5F, 0xC0, 0x87, 0x77, 0x74, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x40, 0xAF, 0xB0, 0x97, 0x77,
  0x75, 0x0E, 0xFB, 0x02, 0x77, 0x77, 0x40, 0x1F, 0xB0, 0x97, 0x77, 0x75, 0x05, 0xFB, 0x01, 0x77,
  0x77, 0x50, 0x8F, 0xA0, 0x87, 0x77, 0x76, 0x0C, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x6F, 0xA0, 0x67,
  0x77, 0x76, 0x04, 0xF9, 0x0C, 0x77, 0x77, 0x70, 0x8F, 0x90, 0x37, 0x77, 0x77, 0x0C, 0xF0, 0x88,
  0x0C, 0x00, 0x0E, 0xE0, 0xD7, 0x77, 0x30,
  // "Ň" (U+0147)
  0x60, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x75, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x76, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x77, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0x56, 0x08,
  0xFB, 0x03, 0x77, 0x30, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x50, 0x8F, 0xB0, 0x62, 0x09,
  0xFB, 0x09, 0x77, 0x70, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x77, 0x10, 0x10, 0xEF, 0xFE, 0x0E,
  0x02, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x40, 0x8F, 0xFC, 0x08, 0x77, 0x76, 0x0C, 0xFF,
  0xA0, 0xC7, 0x77, 0x70, 0x2F, 0xFA, 0x02, 0x77, 0x77, 0x10, 0x7F, 0xF0, 0x77, 0x77, 0x73, 0x0D,
  0xFD, 0x0D, 0x80, 0xCC, 0x00, 0x0E, 0xFF, 0xA0, 0xE7, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04,
  0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF, 0xB0, 0x97, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77,
  0x10, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x37, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF,
  0xB0, 0x0E, 0xFF, 0xC0, 0xD7, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E,
  0xFF, 0xD0, 0x87, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0,
  0x37, 0x50, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x87, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0,
  0xD7, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x0C, 0x09, 0xFB, 0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0,
  0xD0, 0x4F, 0xB0, 0x87, 0x40, 0xAF, 0xB0, 0x0E, 0xFA, 0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF,
  0xB0, 0x0E, 0xFB, 0x10, 0x9F, 0xB0, 0x27, 0x30, 0xAF, 0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07,
  0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x0E, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8,
  0x12, 0x09, 0xFB, 0x02, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A,
  0xFB, 0x00, 0xEF, 0xB0, 0x42, 0x0E, 0xFA, 0x0C, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09,
  0xFB, 0x02, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00,
  0xEF, 0xB0, 0x63, 0x0E, 0xFA, 0x0C, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02,
  0x70, 0xAF, 0xB0, 0x0E, 0xFB, 0x07, 0x30, 0x4F, 0xB0, 0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84,
  0x0E, 0xFA, 0x0C, 0x70, 0xAF, 0xB0, 0x0E, 0xFB, 0x08, 0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00,
  0xEF, 0xB0, 0x94, 0x05, 0xFB, 0x06, 0x60, 0xAF, 0xB0, 0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6,
  0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0xA5, 0x0A, 0xFB, 0x01, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50,
  0x5F, 0xB0, 0x65, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E,
  0xFB, 0x0A, 0x60, 0xAF, 0xB0, 0x14, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40,
  0x9F, 0xB0, 0x0E, 0xFB, 0x0A, 0x7F, 0xB0, 0xB4, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB,
  0x01, 0x30, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A, 0x70, 0x5F, 0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0,
  0xA7, 0x1F, 0xB0, 0xB3, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB,
  0x00, 0xEF, 0xB0, 0xA7, 0x10, 0x5F, 0xB0, 0x52, 0x07, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0,
  0xA2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0xBF, 0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7,
  0x20, 0x5F, 0xB8, 0x15, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB,
  0x00, 0xEF, 0xB0, 0xA7, 0x30, 0xBF, 0xA8, 0x1E, 0x04, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F,
  0xB0, 0x50, 0x3F, 0xB0, 0x0E, 0xFB, 0x0A, 0x73, 0x01, 0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0,
  0xA7, 0x40, 0xBF, 0xA0, 0xE0, 0x2F, 0xB0, 0x0E, 0xFB, 0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00,
  0xEF, 0xB0, 0xA7, 0x40, 0x1F, 0xB0, 0xBF, 0xB0, 0x0E, 0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E,
  0xFB, 0x0A, 0x75, 0x06, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A,
  0x76, 0x0B, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x06, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01,
  0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x77, 0x0B, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0,
  0x0E, 0xFB, 0x0A, 0x77, 0x01, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF,
  0xB0, 0xA7, 0x71, 0x07, 0xFF, 0xB0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0x1F, 0xFB, 0x0E,
  // "ň" (U+0148)
  0x50, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x74, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x75, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x76, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x02, 0x0E, 0xFA, 0x05, 0x60, 0x8F,
  0xB0, 0x37, 0x72, 0x04, 0xFB, 0x07, 0x40, 0x9F, 0xB0, 0x57, 0x74, 0x08, 0xFB, 0x06, 0x20, 0x9F,
  0xB0, 0x97, 0x76, 0x0B, 0xFB, 0x05, 0x08, 0xFB, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0xFE, 0x0E, 0x02,
  0x77, 0x71, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x30, 0x8F, 0xFC, 0x08, 0x77, 0x75, 0x0C, 0xFF, 0xA0,
  0xC7, 0x77, 0x60, 0x2F, 0xFA, 0x02, 0x77, 0x77, 0x07, 0xFF, 0x07, 0x77, 0x77, 0x20, 0xDF, 0xD0,
  0xD8, 0x0C, 0x82, 0x08, 0x43, 0x7A, 0xCE, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x4F, 0xA0, 0xE7, 0x18,
  0x12, 0x8E, 0xFE, 0x81, 0xE8, 0x27, 0x1F, 0xB0, 0x56, 0x08, 0xFF, 0xD0, 0x87, 0xFB, 0x0B, 0x40,
  0x20, 0xDF, 0xFF, 0x0C, 0x01, 0x5F, 0xC0, 0x12, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x01, 0x4F, 0xC8,
  0x26, 0x02, 0xEF, 0xFF, 0xC0, 0xC4, 0xFC, 0x81, 0xC0, 0xCF, 0xFF, 0xE0, 0x93, 0xFD, 0x0E, 0xFF,
  0xFF, 0x90, 0x32, 0x80, 0xC6, 0xF0, 0xB2, 0x80, 0xC7, 0xF0, 0x11, 0xFF, 0xE8, 0x4D, 0xA8, 0x8A,
  0xDF, 0xFB, 0x07, 0x1F, 0xFC, 0x09, 0x02, 0x60, 0x20, 0xAF, 0xF9, 0x0B, 0x1F, 0xFB, 0x05, 0x73,
  0x05, 0xFF, 0x0E, 0x1F, 0xFA, 0x05, 0x75, 0x07, 0xFF, 0x02, 0xFF, 0x90, 0x97, 0x70, 0xCF, 0xE0,
  0x4F, 0xF9, 0x01, 0x77, 0x06, 0xFE, 0x06, 0xFF, 0x0A, 0x77, 0x10, 0x1F, 0xE0, 0x7F, 0xF0, 0x47,
  0x72, 0x0D, 0xFD, 0x07, 0xFF, 0x77, 0x30, 0xBF, 0xD0, 0x7F, 0xE0, 0xB7, 0x73, 0x09, 0xFD, 0x07,
  0xFE, 0x08, 0x77, 0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x57, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x03, 0x77,
  0x30, 0x8F, 0xD0, 0x7F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74,
  0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77,
  0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  // "ŉ" (U+0149)
  0x50, 0xEF, 0xC0, 0xC8, 0x0D, 0x30, 0x01, 0xFD, 0x0E, 0x80, 0xD3, 0x00, 0x3F, 0xD0, 0xA8, 0x0D,
  0x30, 0x06, 0xFD, 0x06, 0x80, 0xD3, 0x00, 0x8F, 0xD0, 0x18, 0x0D, 0x30, 0x0B, 0xFC, 0x0C, 0x80,
  0xD4, 0x00, 0xEF, 0xC0, 0x78, 0x0D, 0x30, 0x01, 0xFD, 0x02, 0x80, 0xD3, 0x00, 0x4F, 0xC0, 0xC8,
  0x0D, 0x40, 0x07, 0xFC, 0x07, 0x80, 0xD4, 0x00, 0xBF, 0xC0, 0x18, 0x0D, 0x40, 0x0E, 0xFB, 0x0B,
  0x80, 0xD4, 0x00, 0x2F, 0xC0, 0x58, 0x0D, 0x40, 0x05, 0xFB, 0x0E, 0x80, 0xD5, 0x00, 0x8F, 0xB0,
  0x87, 0x77, 0x38, 0x34, 0x8B, 0xDE, 0xA8, 0x3E, 0xDB, 0x85, 0x76, 0x0C, 0xFB, 0x02, 0x20, 0x2F,
  0xA0, 0xE7, 0x10, 0x30, 0x9F, 0xF0, 0xA0, 0x37, 0x3F, 0xB0, 0xB3, 0x02, 0xFB, 0x03, 0x50, 0x10,
  0x9F, 0xFC, 0x09, 0x01, 0x70, 0x3F, 0xB0, 0x43, 0x02, 0xFB, 0x09, 0x40, 0x30, 0xDF, 0xFE, 0x0D,
  0x02, 0x60, 0x7F, 0xA0, 0xD4, 0x02, 0xFB, 0x0E, 0x30, 0x30, 0xEF, 0xFF, 0x90, 0xE0, 0x25, 0x0A,
  0xFA, 0x07, 0x40, 0x2F, 0xC8, 0x24, 0x02, 0xEF, 0xFF, 0xB0, 0xD0, 0x14, 0x0E, 0xF9, 0x0E, 0x01,
  0x40, 0x2F, 0xC8, 0x19, 0x0C, 0xFF, 0xFD, 0x0A, 0x30, 0x2F, 0xA0, 0x95, 0x02, 0xFC, 0x0E, 0x0B,
  0xFF, 0xFF, 0x03, 0x77, 0x40, 0x28, 0x0C, 0x5F, 0x0B, 0x77, 0x40, 0x28, 0x0C, 0x6F, 0x02, 0x77,
  0x30, 0x2F, 0xFE, 0x83, 0xB9, 0x89, 0xBF, 0xFB, 0x07, 0x77, 0x30, 0x2F, 0xFB, 0x81, 0xE7, 0x16,
  0x07, 0x0E, 0xFF, 0x0B, 0x77, 0x30, 0x2F, 0xFA, 0x0D, 0x02, 0x72, 0x03, 0x0E, 0xFF, 0x77, 0x30,
  0x2F, 0xF9, 0x0E, 0x02, 0x74, 0x05, 0xFF, 0x02, 0x77, 0x20, 0x2F, 0xF9, 0x06, 0x76, 0x0B, 0xFE,
  0x04, 0x77, 0x20, 0x2F, 0xF0, 0xD7, 0x70, 0x5F, 0xE0, 0x67, 0x72, 0x02, 0xFF, 0x07, 0x77, 0x01,
  0xFE, 0x07, 0x77, 0x20, 0x2F, 0xF0, 0x17, 0x71, 0x0D, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xE0, 0xD7,
  0x72, 0x0A, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xE0, 0x97, 0x72, 0x09, 0xFD, 0x07, 0x77, 0x20, 0x2F,
  0xE0, 0x67, 0x72, 0x09, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xE0, 0x47, 0x72, 0x08, 0xFD, 0x07, 0x77,
  0x20, 0x2F, 0xE0, 0x27, 0x72, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xE7, 0x73, 0x08, 0xFD, 0x07,
  0x77, 0x20, 0x2F, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD,
  0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73,
  0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0,
  0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20,
  0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07,
  0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08,
  0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7,
  0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F,
  0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77,
  0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD,
  0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73,
  0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0,
  0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20,
  0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07,
  0x77, 0x20, 0x2F, 0xD0, 0xE7, 0x73, 0x08, 0xFD, 0x07,
  // "Ŋ" (U+014A)
  0x0E, 0xFF, 0xA0, 0xE7, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x04, 0x77, 0x10, 0xAF, 0xB0, 0x0E,
  0xFF, 0xB0, 0x97, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xFB, 0x0E, 0x77, 0x10, 0xAF, 0xB0, 0x0E, 0xFF,
  0xC0, 0x37, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0x97, 0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xC0, 0xD7,
  0x70, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x37, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xD0, 0x87, 0x60, 0xAF,
  0xB0, 0x0E, 0xFF, 0xD0, 0xD7, 0x60, 0xAF, 0xB0, 0x0E, 0xFF, 0xE0, 0x37, 0x50, 0xAF, 0xB0, 0x0E,
  0xFF, 0xE0, 0x87, 0x50, 0xAF, 0xB0, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xD7, 0x50, 0xAF, 0xB0, 0x0E,
  0xFA, 0x0C, 0x09, 0xFB, 0x03, 0x74, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xD0, 0x4F, 0xB0, 0x87, 0x40,
  0xAF, 0xB0, 0x0E, 0xFA, 0x81, 0xE0, 0xEF, 0xA0, 0xD7, 0x40, 0xAF, 0xB0, 0x0E, 0xFB, 0x10, 0x9F,
  0xB0, 0x27, 0x30, 0xAF, 0xB0, 0x0E, 0xFB, 0x01, 0x04, 0xFB, 0x07, 0x73, 0x0A, 0xFB, 0x00, 0xEF,
  0xB8, 0x12, 0x0E, 0xFA, 0x0D, 0x73, 0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x12, 0x09, 0xFB, 0x02, 0x72,
  0x0A, 0xFB, 0x00, 0xEF, 0xB8, 0x13, 0x04, 0xFB, 0x07, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x42,
  0x0E, 0xFA, 0x0C, 0x72, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x52, 0x09, 0xFB, 0x02, 0x71, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0x52, 0x04, 0xFB, 0x07, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x63, 0x0E, 0xFA,
  0x0C, 0x71, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x73, 0x09, 0xFB, 0x02, 0x70, 0xAF, 0xB0, 0x0E, 0xFB,
  0x07, 0x30, 0x4F, 0xB0, 0x77, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x84, 0x0E, 0xFA, 0x0C, 0x70, 0xAF,
  0xB0, 0x0E, 0xFB, 0x08, 0x40, 0xAF, 0xB0, 0x16, 0x0A, 0xFB, 0x00, 0xEF, 0xB0, 0x94, 0x05, 0xFB,
  0x06, 0x60, 0xAF, 0xB0, 0x0E, 0xFB, 0x09, 0x50, 0xEF, 0xA0, 0xB6, 0x0A, 0xFB, 0x00, 0xEF, 0xB0,
  0xA5, 0x0A, 0xFB, 0x01, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x50, 0x5F, 0xB0, 0x65, 0x0A, 0xFB,
  0x00, 0xEF, 0xB0, 0xA6, 0x0E, 0xFA, 0x0B, 0x50, 0xAF, 0xB0, 0x0E, 0xFB, 0x0A, 0x60, 0xAF, 0xB0,
  0x14, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA6, 0x05, 0xFB, 0x06, 0x40, 0x9F, 0xB0, 0x0E, 0xFB, 0x0A,
  0x7F, 0xB0, 0xB4, 0x09, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x0A, 0xFB, 0x01, 0x30, 0x9F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x70, 0x5F, 0xB0, 0x53, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x1F, 0xB0, 0xB3, 0x08,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10, 0xAF, 0xB0, 0x12, 0x08, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x10,
  0x5F, 0xB0, 0x52, 0x07, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x2F, 0xB0, 0xA2, 0x06, 0xFB, 0x00, 0xEF,
  0xB0, 0xA7, 0x20, 0xBF, 0xB2, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x5F, 0xB8, 0x15, 0x05,
  0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x20, 0x1F, 0xB8, 0x1A, 0x05, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30,
  0xBF, 0xA8, 0x1E, 0x04, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x30, 0x6F, 0xB0, 0x50, 0x3F, 0xB0, 0x0E,
  0xFB, 0x0A, 0x73, 0x01, 0xFB, 0x0A, 0x03, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0xBF, 0xA0, 0xE0,
  0x2F, 0xB0, 0x0E, 0xFB, 0x0A, 0x74, 0x06, 0xFB, 0x06, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x40, 0x1F,
  0xB0, 0xBF, 0xB0, 0x0E, 0xFB, 0x0A, 0x75, 0x0B, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x06, 0xFF,
  0xE0, 0x0E, 0xFB, 0x0A, 0x75, 0x01, 0xFF, 0xE0, 0x0E, 0xFB, 0x0A, 0x76, 0x0B, 0xFF, 0xD0, 0x0E,
  0xFB, 0x0A, 0x76, 0x06, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A, 0x76, 0x01, 0xFF, 0xD0, 0x0E, 0xFB, 0x0A,
  0x77, 0x0B, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x06, 0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x01,
  0xFF, 0xC0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0xCF, 0xFB, 0x00, 0xEF, 0xB0, 0xA7, 0x71, 0x07, 0xFF,
  0xB0, 0x0E, 0xFB, 0x0A, 0x77, 0x10, 0x1F, 0xFB, 0x0E, 0x77, 0x77, 0x70, 0xCF, 0xA0, 0xE7, 0x77,
  0x77, 0x0D, 0xFA, 0x0D, 0x77, 0x77, 0x7F, 0xB0, 0xB7, 0x77, 0x76, 0x04, 0xFB, 0x09, 0x77, 0x77,
  0x60, 0x9F, 0xB0, 0x77, 0x77, 0x75, 0x03, 0xFC, 0x03, 0x77, 0x77, 0x40, 0x20, 0xEF, 0xB0, 0xE7,
  0x77, 0x74, 0x07, 0x0E, 0xFC, 0x09, 0x77, 0x48, 0x47, 0xA7, 0x42, 0x13, 0x83, 0x13, 0x59, 0xEF,
  0xE0, 0x27, 0x74, 0x09, 0xFF, 0xFC, 0x0A, 0x77, 0x50, 0x9F, 0xFF, 0xB0, 0xE0, 0x17, 0x75, 0x09,
  0xFF, 0xFB, 0x05, 0x77, 0x60, 0x9F, 0xFF, 0xA0, 0x77, 0x77, 0x09, 0xFF, 0xF9, 0x06, 0x77, 0x71,
  0x09, 0xFF, 0xE0, 0xC0, 0x27, 0x77, 0x20, 0x9F, 0xFC, 0x0D, 0x06, 0x77, 0x74, 0x09, 0xFF, 0xA0,
  0xA0, 0x57, 0x77, 0x68, 0x51, 0x47, 0x9B, 0xDE, 0xB8, 0x4E, 0xDC, 0x97, 0x37, 0x60,
  // "ŋ" (U+014B)
  0x77, 0x78, 0x43, 0x7A, 0xCE, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x4F, 0xA0, 0xE7, 0x18, 0x12, 0x8E,
  0xFE, 0x81, 0xE8, 0x17, 0x1F, 0xB0, 0x56, 0x08, 0xFF, 0xD0, 0x87, 0xFB, 0x0B, 0x40, 0x20, 0xDF,
  0xFF, 0x0C, 0x01, 0x5F, 0xC0, 0x12, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x01, 0x4F, 0xC8, 0x26, 0x02,
  0xEF, 0xFF, 0xC0, 0xC4, 0xFC, 0x81, 0xC0, 0xCF, 0xFF, 0xE0, 0x93, 0xFD, 0x0E, 0xFF, 0xFF, 0x90,
  0x32, 0x80, 0xC6, 0xF0, 0xA2, 0x80, 0xC7, 0xF0, 0x11, 0xFF, 0xE8, 0x4D, 0xA8, 0x8A, 0xDF, 0xFB,
  0x07, 0x1F, 0xFC, 0x09, 0x02, 0x60, 0x20, 0xAF, 0xF9, 0x0B, 0x1F, 0xFB, 0x05, 0x73, 0x06, 0xFF,
  0x0E, 0x1F, 0xFA, 0x05, 0x75, 0x07, 0xFF, 0x02, 0xFF, 0x90, 0x97, 0x70, 0xCF, 0xE0, 0x4F, 0xF9,
  0x01, 0x77, 0x06, 0xFE, 0x05, 0xFF, 0x0A, 0x77, 0x10, 0x1F, 0xE0, 0x6F, 0xF0, 0x47, 0x72, 0x0D,
  0xFD, 0x07, 0xFF, 0x77, 0x30, 0xBF, 0xD0, 0x7F, 0xE0, 0xB7, 0x73, 0x09, 0xFD, 0x07, 0xFE, 0x08,
  0x77, 0x30, 0x9F, 0xD0, 0x7F, 0xE0, 0x57, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x03, 0x77, 0x30, 0x8F,
  0xD0, 0x7F, 0xE0, 0x27, 0x73, 0x08, 0xFD, 0x07, 0xFE, 0x01, 0x77, 0x30, 0x8F, 0xD0, 0x7F, 0xE7,
  0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE,
  0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F,
  0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07,
  0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0,
  0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD,
  0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F,
  0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08,
  0xFD, 0x07, 0xFE, 0x77, 0x40, 0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0xFE, 0x77, 0x40,
  0x8F, 0xD0, 0x7F, 0xE7, 0x74, 0x08, 0xFD, 0x07, 0x77, 0x77, 0x30, 0x8F, 0xD0, 0x77, 0x77, 0x73,
  0x08, 0xFD, 0x07, 0x77, 0x77, 0x30, 0x8F, 0xD0, 0x77, 0x77, 0x73, 0x08, 0xFD, 0x07, 0x77, 0x77,
  0x30, 0x8F, 0xD0, 0x77, 0x77, 0x73, 0x09, 0xFD, 0x07, 0x77, 0x77, 0x30, 0xBF, 0xD0, 0x77, 0x77,
  0x73, 0x0E, 0xFD, 0x06, 0x77, 0x77, 0x20, 0x4F, 0xE0, 0x57, 0x77, 0x72, 0x0C, 0xFE, 0x02, 0x77,
  0x60, 0x10, 0x26, 0x02, 0x0C, 0xFF, 0x77, 0x78, 0x64, 0xFE, 0xB9, 0x89, 0xCF, 0xF9, 0x0B, 0x77,
  0x70, 0x4F, 0xFF, 0x90, 0x67, 0x77, 0x04, 0xFF, 0xF9, 0x01, 0x77, 0x70, 0x4F, 0xFF, 0x09, 0x77,
  0x71, 0x04, 0xFF, 0xE0, 0xE0, 0x17, 0x77, 0x10, 0x4F, 0xFE, 0x05, 0x77, 0x72, 0x04, 0xFF, 0xD0,
  0x87, 0x77, 0x30, 0x4F, 0xFC, 0x08, 0x77, 0x74, 0x04, 0xFF, 0xA0, 0xE0, 0x47, 0x77, 0x50, 0x3F,
  0xF0, 0xE0, 0x77, 0x77, 0x71, 0x89, 0x41, 0x58, 0xAC, 0xEE, 0xFE, 0xEC, 0xA7, 0x37, 0x30,
  // "Ō" (U+014C)
  0x74, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD,
  0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09,
  0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x77,
  0x71, 0x09, 0xFF, 0xFD, 0x0A, 0x80, 0xD8, 0x50, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7,
  0x47, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x77, 0x70, 0x70, 0xEF, 0xFE, 0x0E, 0x07,
  0x77, 0x73, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x70, 0x7F, 0xFF, 0xF0, 0x87, 0x75, 0x09,
  0xFF, 0xFF, 0xA0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77,
  0x60, 0x38, 0x0C, 0x0F, 0x03, 0x75, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x78, 0x0C, 0x2F, 0x07,
  0x72, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x10, 0x8F,
  0xF0, 0xB0, 0x27, 0x10, 0x20, 0xBF, 0xF0, 0x77, 0x10, 0xEF, 0xE0, 0xA7, 0x50, 0xAF, 0xE0, 0xE7,
  0x05, 0xFE, 0x0C, 0x77, 0x0C, 0xFE, 0x05, 0x60, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB5, 0x01,
  0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x14, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x0A,
  0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD3, 0x01,
  0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x12, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x07,
  0xFD, 0x0C, 0x77, 0x60, 0xBF, 0xD0, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x0C,
  0xFD, 0x07, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x0E, 0xFD, 0x05, 0x77, 0x60, 0x4F, 0xD0, 0xD2, 0xFE,
  0x03, 0x77, 0x60, 0x3F, 0xE1, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x10, 0x2F, 0xE0, 0x17,
  0x76, 0x01, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30,
  0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F,
  0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0xFE, 0x04, 0x03, 0xFE, 0x77,
  0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02,
  0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x11, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD,
  0x04, 0x77, 0x60, 0x5F, 0xD0, 0xE2, 0x0C, 0xFD, 0x06, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD,
  0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x07, 0xFD, 0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x72, 0x04, 0xFD,
  0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01, 0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD,
  0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD4, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x05, 0xFE,
  0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x01, 0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE,
  0x02, 0x77, 0x02, 0xFE, 0x0B, 0x60, 0x5F, 0xE0, 0xB7, 0x70, 0xCF, 0xE0, 0x57, 0x0E, 0xFE, 0x09,
  0x75, 0x09, 0xFE, 0x0E, 0x71, 0x08, 0xFF, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0x07, 0x71, 0x01,
  0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C, 0x2F,
  0x07, 0x74, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x50, 0x48, 0x0C, 0x0F, 0x04, 0x76, 0x07, 0xFF, 0xFF,
  0xE0, 0x77, 0x71, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x75, 0x08,
  0xFF, 0xFF, 0x08, 0x77, 0x70, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x30, 0x70, 0xEF, 0xFE,
  0x0E, 0x07, 0x77, 0x77, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x77, 0x75, 0x84, 0x47, 0xAC, 0xDE,
  0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x74,
  // "ō" (U+014D)
  0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x76, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x76, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x60, 0x9F, 0xFF, 0xD0,
  0xA7, 0x76, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x60, 0x9F, 0xFF, 0xD0, 0xA7, 0x76, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xCE, 0x70, 0x89, 0x53, 0x69, 0xBD, 0xEE, 0xFE, 0xEC, 0xA8, 0x41, 0x77, 0x77, 0x28,
  0x13, 0x9E, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x50, 0x40, 0xCF, 0xFE, 0x0E, 0x08, 0x77, 0x71, 0x02,
  0x0B, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x50, 0x60, 0xEF, 0xFF, 0xE0, 0x97, 0x73, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x08, 0xFF, 0xFF, 0xE0, 0xB7, 0x40,
  0x58, 0x0C, 0x0F, 0x09, 0x72, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0xAF, 0xFA, 0x84, 0xDB,
  0x98, 0x9C, 0xFF, 0xA0, 0xD7, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x81, 0x17, 0xEF, 0xF0, 0x66, 0x0B,
  0xFE, 0x0E, 0x05, 0x73, 0x01, 0x0C, 0xFE, 0x0E, 0x50, 0x2F, 0xF0, 0x47, 0x50, 0x10, 0xDF, 0xE0,
  0x54, 0x08, 0xFE, 0x07, 0x77, 0x04, 0xFE, 0x0B, 0x40, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFE, 0x30,
  0x3F, 0xE0, 0x67, 0x72, 0x04, 0xFE, 0x05, 0x20, 0x7F, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x20, 0xBF,
  0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0x67, 0x74, 0x06, 0xFD, 0x0E, 0x2F, 0xE0,
  0x47, 0x74, 0x03, 0xFE, 0x01, 0x02, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xE0, 0x20, 0x4F, 0xE7, 0x76,
  0xFE, 0x00, 0x4F, 0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x05,
  0x06, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x00, 0x5F,
  0xD0, 0xE7, 0x76, 0x0E, 0xFD, 0x00, 0x4F, 0xE7, 0x76, 0xFE, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40,
  0x1F, 0xE0, 0x20, 0x1F, 0xE0, 0x47, 0x74, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x77, 0x74, 0x06, 0xFD,
  0x0D, 0x20, 0xBF, 0xD0, 0xB7, 0x74, 0x0A, 0xFD, 0x0B, 0x20, 0x8F, 0xE0, 0x17, 0x73, 0x0E, 0xFD,
  0x07, 0x20, 0x4F, 0xE0, 0x67, 0x72, 0x05, 0xFE, 0x03, 0x30, 0xEF, 0xD0, 0xD7, 0x72, 0x0C, 0xFD,
  0x0E, 0x40, 0xAF, 0xE0, 0x77, 0x70, 0x5F, 0xE0, 0x94, 0x03, 0xFF, 0x04, 0x75, 0x02, 0x0E, 0xFE,
  0x03, 0x50, 0xCF, 0xE0, 0xE0, 0x57, 0x30, 0x30, 0xDF, 0xE0, 0xC6, 0x05, 0xFF, 0x90, 0xA0, 0x36,
  0x01, 0x07, 0xFF, 0x90, 0x57, 0x0B, 0xFF, 0xA8, 0x4D, 0xA9, 0x8A, 0xCF, 0xFA, 0x0C, 0x71, 0x02,
  0x80, 0xC2, 0xF0, 0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xE0, 0xB7, 0x60,
  0xBF, 0xFF, 0xFC, 0x0C, 0x77, 0x10, 0xAF, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x97,
  0x75, 0x03, 0x0D, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xE0, 0xE0, 0x77, 0x77,
  0x58, 0x15, 0xAE, 0xFF, 0x90, 0xB0, 0x67, 0x77, 0x73, 0x84, 0x47, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC,
  0xA7, 0x41, 0x77, 0x20,
  // "Ŏ" (U+014E)
  0x73, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x50, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x75, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x50, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x76, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x77, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x77, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x70, 0x3F, 0xFF, 0xD0, 0x97,
  0x77, 0x20, 0xAF, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x20, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x40,
  0x30, 0xEF, 0xFF, 0x06, 0x77, 0x76, 0x03, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x71, 0x01, 0x0B, 0xFF,
  0xA0, 0xD0, 0x37, 0x77, 0x74, 0x04, 0x0B, 0xFD, 0x0D, 0x05, 0x80, 0xC0, 0x08, 0x92, 0x26, 0xAC,
  0xDE, 0xFD, 0xCA, 0x62, 0x80, 0xCB, 0x30, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47,
  0x77, 0x75, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x77, 0x70, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77,
  0x73, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x70, 0x7F, 0xFF, 0xF0, 0x87, 0x75, 0x09, 0xFF,
  0xFF, 0xA0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x60,
  0x38, 0x0C, 0x0F, 0x03, 0x75, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x78, 0x0C, 0x2F, 0x07, 0x72,
  0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x10, 0x8F, 0xF0,
  0xB0, 0x27, 0x10, 0x20, 0xBF, 0xF0, 0x77, 0x10, 0xEF, 0xE0, 0xA7, 0x50, 0xAF, 0xE0, 0xE7, 0x05,
  0xFE, 0x0C, 0x77, 0x0C, 0xFE, 0x05, 0x60, 0xBF, 0xE0, 0x27, 0x70, 0x2F, 0xE0, 0xB5, 0x01, 0xFE,
  0x09, 0x77, 0x20, 0x9F, 0xE0, 0x14, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x0A, 0xFD,
  0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD3, 0x01, 0xFE,
  0x03, 0x77, 0x40, 0x3F, 0xE0, 0x12, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x07, 0xFD,
  0x0C, 0x77, 0x60, 0xBF, 0xD0, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x0C, 0xFD,
  0x07, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x0E, 0xFD, 0x05, 0x77, 0x60, 0x4F, 0xD0, 0xD2, 0xFE, 0x03,
  0x77, 0x60, 0x3F, 0xE1, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x76,
  0x01, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x4F,
  0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0,
  0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77, 0x71, 0xFE, 0x04, 0x03, 0xFE, 0x77, 0x71,
  0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x01,
  0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x11, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD, 0x04,
  0x77, 0x60, 0x5F, 0xD0, 0xE2, 0x0C, 0xFD, 0x06, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD, 0x09,
  0x77, 0x60, 0x9F, 0xD0, 0x92, 0x07, 0xFD, 0x0B, 0x77, 0x60, 0xCF, 0xD0, 0x72, 0x04, 0xFD, 0x0E,
  0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01, 0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD, 0x07,
  0x77, 0x40, 0x7F, 0xD0, 0xD4, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x05, 0xFE, 0x02,
  0x77, 0x20, 0x2F, 0xE0, 0x54, 0x01, 0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE, 0x02,
  0x77, 0x02, 0xFE, 0x0B, 0x60, 0x5F, 0xE0, 0xB7, 0x70, 0xCF, 0xE0, 0x57, 0x0E, 0xFE, 0x09, 0x75,
  0x09, 0xFE, 0x0E, 0x71, 0x08, 0xFF, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0x07, 0x71, 0x01, 0x0E,
  0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C, 0x2F, 0x07,
  0x74, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x50, 0x48, 0x0C, 0x0F, 0x04, 0x76, 0x07, 0xFF, 0xFF, 0xE0,
  0x77, 0x71, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x75, 0x08, 0xFF,
  0xFF, 0x08, 0x77, 0x70, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x77, 0x30, 0x70, 0xEF, 0xFE, 0x0E,
  0x07, 0x77, 0x77, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x77, 0x75, 0x84, 0x47, 0xAC, 0xDE, 0xA8,
  0x4E, 0xDC, 0xA7, 0x47, 0x74,
  // "ŏ" (U+014F)
  0x72, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x30, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x73, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x30, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x74, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x75, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x75, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x50, 0x3F, 0xFF, 0xD0, 0x97,
  0x77, 0x0A, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x70, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x20, 0x30,
  0xEF, 0xFF, 0x06, 0x77, 0x74, 0x03, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x60, 0x10, 0xBF, 0xFA, 0x0D,
  0x03, 0x77, 0x77, 0x20, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x76, 0x89, 0x22, 0x6A, 0xCD, 0xEF,
  0xDC, 0xA6, 0x28, 0x0C, 0x97, 0x08, 0x95, 0x36, 0x9B, 0xDE, 0xEF, 0xEE, 0xCA, 0x84, 0x17, 0x77,
  0x72, 0x81, 0x39, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x75, 0x04, 0x0C, 0xFF, 0xE0, 0xE0, 0x87, 0x77,
  0x10, 0x20, 0xBF, 0xFF, 0xB0, 0xE0, 0x57, 0x75, 0x06, 0x0E, 0xFF, 0xFE, 0x09, 0x77, 0x30, 0x8F,
  0xFF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x8F, 0xFF, 0xFE, 0x0B,
  0x74, 0x05, 0x80, 0xC0, 0xF0, 0x97, 0x20, 0x10, 0xE8, 0x0C, 0x1F, 0x04, 0x71, 0x0A, 0xFF, 0xA8,
  0x4D, 0xB9, 0x89, 0xCF, 0xFA, 0x0D, 0x70, 0x3F, 0xF9, 0x0A, 0x03, 0x68, 0x11, 0x7E, 0xFF, 0x06,
  0x60, 0xBF, 0xE0, 0xE0, 0x57, 0x30, 0x10, 0xCF, 0xE0, 0xE5, 0x02, 0xFF, 0x04, 0x75, 0x01, 0x0D,
  0xFE, 0x05, 0x40, 0x8F, 0xE0, 0x77, 0x70, 0x4F, 0xE0, 0xB4, 0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF,
  0xE3, 0x03, 0xFE, 0x06, 0x77, 0x20, 0x4F, 0xE0, 0x52, 0x07, 0xFE, 0x77, 0x40, 0xEF, 0xD0, 0x82,
  0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2, 0x0D, 0xFD, 0x06, 0x77, 0x40, 0x6F, 0xD0, 0xE2,
  0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x74, 0x01, 0xFE, 0x02, 0x04, 0xFE,
  0x77, 0x6F, 0xE0, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xDF,
  0xD0, 0x50, 0x6F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x06, 0x05, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0,
  0x05, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x04, 0xFE, 0x77, 0x6F, 0xE0, 0x40, 0x3F, 0xE0, 0x17,
  0x74, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE2, 0x0E, 0xFD, 0x07, 0x77, 0x40,
  0x6F, 0xD0, 0xD2, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2, 0x08, 0xFE, 0x01, 0x77, 0x30,
  0xEF, 0xD0, 0x72, 0x04, 0xFE, 0x06, 0x77, 0x20, 0x5F, 0xE0, 0x33, 0x0E, 0xFD, 0x0D, 0x77, 0x20,
  0xCF, 0xD0, 0xE4, 0x0A, 0xFE, 0x07, 0x77, 0x05, 0xFE, 0x09, 0x40, 0x3F, 0xF0, 0x47, 0x50, 0x20,
  0xEF, 0xE0, 0x35, 0x0C, 0xFE, 0x0E, 0x05, 0x73, 0x03, 0x0D, 0xFE, 0x0C, 0x60, 0x5F, 0xF9, 0x0A,
  0x03, 0x60, 0x10, 0x7F, 0xF9, 0x05, 0x70, 0xBF, 0xFA, 0x84, 0xDA, 0x98, 0xAC, 0xFF, 0xA0, 0xC7,
  0x10, 0x28, 0x0C, 0x2F, 0x03, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0xAF, 0xFF, 0xFE, 0x0B,
  0x76, 0x0B, 0xFF, 0xFF, 0xC0, 0xC7, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xB7, 0x73, 0x07, 0xFF, 0xFF,
  0x09, 0x77, 0x50, 0x30, 0xDF, 0xFF, 0xB0, 0xE0, 0x57, 0x77, 0x10, 0x60, 0xDF, 0xFE, 0x0E, 0x07,
  0x77, 0x75, 0x81, 0x5A, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x77, 0x38, 0x44, 0x79, 0xCD, 0xEA, 0x85,
  0xED, 0xCA, 0x74, 0x17, 0x72,
  // "Ő" (U+0150)
  0x77, 0x20, 0x4F, 0xD3, 0x02, 0xFD, 0x02, 0x77, 0x60, 0xCF, 0xC0, 0xA3, 0x0A, 0xFC, 0x0B, 0x77,
  0x60, 0x5F, 0xC0, 0xD0, 0x12, 0x03, 0xFC, 0x0E, 0x01, 0x77, 0x60, 0xDF, 0xB0, 0xE0, 0x23, 0x0C,
  0xFC, 0x04, 0x77, 0x60, 0x7F, 0xC0, 0x43, 0x06, 0xFC, 0x05, 0x77, 0x60, 0x2F, 0xC0, 0x53, 0x01,
  0x0E, 0xFB, 0x06, 0x77, 0x70, 0xBF, 0xB0, 0x54, 0x09, 0xFB, 0x06, 0x77, 0x70, 0x5F, 0xB0, 0x54,
  0x03, 0xFB, 0x06, 0x77, 0x71, 0x0D, 0xF9, 0x0E, 0x04, 0x50, 0xCF, 0xA0, 0x57, 0x77, 0x10, 0x8F,
  0x90, 0xE0, 0x35, 0x07, 0xFA, 0x04, 0x77, 0x71, 0x03, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0xEF, 0x0E,
  0x03, 0x77, 0x72, 0x0C, 0xF0, 0xB0, 0x16, 0x0A, 0xF0, 0xD0, 0x27, 0x77, 0x20, 0x6F, 0x09, 0x70,
  0x4F, 0x0B, 0x01, 0x77, 0x73, 0x0A, 0xE0, 0x67, 0x10, 0x8E, 0x09, 0x80, 0xCB, 0x10, 0x84, 0x47,
  0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x77,
  0x70, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x73, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x70,
  0x7F, 0xFF, 0xF0, 0x87, 0x75, 0x09, 0xFF, 0xFF, 0xA0, 0xA7, 0x73, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7,
  0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x60, 0x38, 0x0C, 0x0F, 0x03, 0x75, 0x0D, 0x80, 0xC0, 0xF0,
  0xD7, 0x40, 0x78, 0x0C, 0x2F, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49,
  0xFF, 0x90, 0xE0, 0x17, 0x10, 0x8F, 0xF0, 0xB0, 0x27, 0x10, 0x20, 0xBF, 0xF0, 0x77, 0x10, 0xEF,
  0xE0, 0xA7, 0x50, 0xAF, 0xE0, 0xE7, 0x05, 0xFE, 0x0C, 0x77, 0x0C, 0xFE, 0x05, 0x60, 0xBF, 0xE0,
  0x27, 0x70, 0x2F, 0xE0, 0xB5, 0x01, 0xFE, 0x09, 0x77, 0x20, 0x9F, 0xE0, 0x14, 0x05, 0xFE, 0x02,
  0x77, 0x20, 0x2F, 0xE0, 0x54, 0x0A, 0xFD, 0x0C, 0x77, 0x40, 0xCF, 0xD0, 0x94, 0x0D, 0xFD, 0x07,
  0x77, 0x40, 0x7F, 0xD0, 0xD3, 0x01, 0xFE, 0x03, 0x77, 0x40, 0x3F, 0xE0, 0x12, 0x04, 0xFD, 0x0E,
  0x77, 0x60, 0xEF, 0xD0, 0x42, 0x07, 0xFD, 0x0C, 0x77, 0x60, 0xBF, 0xD0, 0x72, 0x09, 0xFD, 0x09,
  0x77, 0x60, 0x9F, 0xD0, 0x92, 0x0C, 0xFD, 0x07, 0x77, 0x60, 0x7F, 0xD0, 0xB2, 0x0E, 0xFD, 0x05,
  0x77, 0x60, 0x4F, 0xD0, 0xD2, 0xFE, 0x03, 0x77, 0x60, 0x3F, 0xE1, 0x01, 0xFE, 0x02, 0x77, 0x60,
  0x2F, 0xE0, 0x10, 0x2F, 0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00,
  0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E,
  0x77, 0x71, 0x0E, 0xFD, 0x00, 0x4F, 0xD0, 0xE7, 0x77, 0x10, 0xEF, 0xD0, 0x04, 0xFD, 0x0E, 0x77,
  0x71, 0xFE, 0x04, 0x03, 0xFE, 0x77, 0x71, 0xFE, 0x00, 0x3F, 0xE7, 0x77, 0x1F, 0xE0, 0x30, 0x2F,
  0xE0, 0x17, 0x76, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x02, 0x77, 0x60, 0x2F, 0xE0, 0x11, 0xFE, 0x03,
  0x77, 0x60, 0x3F, 0xE2, 0x0E, 0xFD, 0x04, 0x77, 0x60, 0x5F, 0xD0, 0xE2, 0x0C, 0xFD, 0x06, 0x77,
  0x60, 0x7F, 0xD0, 0xB2, 0x09, 0xFD, 0x09, 0x77, 0x60, 0x9F, 0xD0, 0x92, 0x07, 0xFD, 0x0B, 0x77,
  0x60, 0xCF, 0xD0, 0x72, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x42, 0x01, 0xFE, 0x03, 0x77,
  0x40, 0x3F, 0xE0, 0x13, 0x0D, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xD4, 0x0A, 0xFD, 0x0C, 0x77,
  0x40, 0xCF, 0xD0, 0x94, 0x05, 0xFE, 0x02, 0x77, 0x20, 0x2F, 0xE0, 0x54, 0x01, 0xFE, 0x09, 0x77,
  0x20, 0x9F, 0xE0, 0x15, 0x0B, 0xFE, 0x02, 0x77, 0x02, 0xFE, 0x0B, 0x60, 0x5F, 0xE0, 0xB7, 0x70,
  0xCF, 0xE0, 0x57, 0x0E, 0xFE, 0x09, 0x75, 0x09, 0xFE, 0x0E, 0x71, 0x08, 0xFF, 0x0B, 0x01, 0x71,
  0x01, 0x0B, 0xFF, 0x07, 0x71, 0x01, 0x0E, 0xFF, 0x98, 0x19, 0x41, 0x28, 0x11, 0x49, 0xFF, 0x90,
  0xE0, 0x17, 0x20, 0x78, 0x0C, 0x2F, 0x07, 0x74, 0x0D, 0x80, 0xC0, 0xF0, 0xD7, 0x50, 0x48, 0x0C,
  0x0F, 0x04, 0x76, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x71, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x73, 0x0A,
  0xFF, 0xFF, 0xA0, 0xA7, 0x75, 0x08, 0xFF, 0xFF, 0x08, 0x77, 0x70, 0x40, 0xDF, 0xFF, 0xB0, 0xD0,
  0x47, 0x77, 0x30, 0x70, 0xEF, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x05, 0x0B, 0xFF, 0xA0, 0xB0, 0x57,
  0x77, 0x75, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x47, 0x74,
  // "ő" (U+0151)
  0x77, 0x10, 0x4F, 0xD3, 0x02, 0xFD, 0x02, 0x77, 0x40, 0xCF, 0xC0, 0xA3, 0x0A, 0xFC, 0x0B, 0x77,
  0x40, 0x5F, 0xC0, 0xD0, 0x12, 0x03, 0xFC, 0x0E, 0x01, 0x77, 0x40, 0xDF, 0xB0, 0xE0, 0x23, 0x0C,
  0xFC, 0x04, 0x77, 0x40, 0x7F, 0xC0, 0x43, 0x06, 0xFC, 0x05, 0x77, 0x40, 0x2F, 0xC0, 0x53, 0x01,
  0x0E, 0xFB, 0x06, 0x77, 0x50, 0xBF, 0xB0, 0x54, 0x09, 0xFB, 0x06, 0x77, 0x50, 0x5F, 0xB0, 0x54,
  0x03, 0xFB, 0x06, 0x77, 0x60, 0xDF, 0x90, 0xE0, 0x45, 0x0C, 0xFA, 0x05, 0x77, 0x60, 0x8F, 0x90,
  0xE0, 0x35, 0x07, 0xFA, 0x04, 0x77, 0x60, 0x3F, 0x90, 0xD0, 0x25, 0x01, 0x0E, 0xF0, 0xE0, 0x37,
  0x77, 0x0C, 0xF0, 0xB0, 0x16, 0x0A, 0xF0, 0xD0, 0x27, 0x77, 0x06, 0xF0, 0x97, 0x04, 0xF0, 0xB0,
  0x17, 0x77, 0x10, 0xAE, 0x06, 0x71, 0x08, 0xE0, 0x98, 0x0C, 0x95, 0x08, 0x95, 0x36, 0x9B, 0xDE,
  0xEF, 0xEE, 0xCA, 0x84, 0x17, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x75, 0x04,
  0x0C, 0xFF, 0xE0, 0xE0, 0x87, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xB0, 0xE0, 0x57, 0x75, 0x06, 0x0E,
  0xFF, 0xFE, 0x09, 0x77, 0x30, 0x8F, 0xFF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xC0,
  0x17, 0x50, 0x8F, 0xFF, 0xFE, 0x0B, 0x74, 0x05, 0x80, 0xC0, 0xF0, 0x97, 0x20, 0x10, 0xE8, 0x0C,
  0x1F, 0x04, 0x71, 0x0A, 0xFF, 0xA8, 0x4D, 0xB9, 0x89, 0xCF, 0xFA, 0x0D, 0x70, 0x3F, 0xF9, 0x0A,
  0x03, 0x68, 0x11, 0x7E, 0xFF, 0x06, 0x60, 0xBF, 0xE0, 0xE0, 0x57, 0x30, 0x10, 0xCF, 0xE0, 0xE5,
  0x02, 0xFF, 0x04, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x40, 0x8F, 0xE0, 0x77, 0x70, 0x4F, 0xE0, 0xB4,
  0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xE3, 0x03, 0xFE, 0x06, 0x77, 0x20, 0x4F, 0xE0, 0x52, 0x07,
  0xFE, 0x77, 0x40, 0xEF, 0xD0, 0x82, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0xB2, 0x0D, 0xFD,
  0x06, 0x77, 0x40, 0x6F, 0xD0, 0xE2, 0xFE, 0x04, 0x77, 0x40, 0x3F, 0xE0, 0x10, 0x2F, 0xE0, 0x17,
  0x74, 0x01, 0xFE, 0x02, 0x04, 0xFE, 0x77, 0x6F, 0xE0, 0x04, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0,
  0x05, 0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x50, 0x6F, 0xD0, 0xD7, 0x76, 0x0D, 0xFD, 0x06, 0x05,
  0xFD, 0x0D, 0x77, 0x60, 0xDF, 0xD0, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0xEF, 0xD0, 0x04, 0xFE, 0x77,
  0x6F, 0xE0, 0x40, 0x3F, 0xE0, 0x17, 0x74, 0x01, 0xFE, 0x02, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x3F,
  0xE2, 0x0E, 0xFD, 0x07, 0x77, 0x40, 0x6F, 0xD0, 0xD2, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0xAF, 0xD0,
  0xB2, 0x08, 0xFE, 0x01, 0x77, 0x30, 0xEF, 0xD0, 0x72, 0x04, 0xFE, 0x06, 0x77, 0x20, 0x5F, 0xE0,
  0x33, 0x0E, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xD0, 0xE4, 0x0A, 0xFE, 0x07, 0x77, 0x05, 0xFE, 0x09,
  0x40, 0x3F, 0xF0, 0x47, 0x50, 0x20, 0xEF, 0xE0, 0x35, 0x0C, 0xFE, 0x0E, 0x05, 0x73, 0x03, 0x0D,
  0xFE, 0x0C, 0x60, 0x5F, 0xF9, 0x0A, 0x03, 0x60, 0x10, 0x7F, 0xF9, 0x05, 0x70, 0xBF, 0xFA, 0x84,
  0xDA, 0x98, 0xAC, 0xFF, 0xA0, 0xC7, 0x10, 0x28, 0x0C, 0x2F, 0x03, 0x72, 0x06, 0x80, 0xC0, 0xF0,
  0x77, 0x40, 0xAF, 0xFF, 0xFE, 0x0B, 0x76, 0x0B, 0xFF, 0xFF, 0xC0, 0xC7, 0x71, 0x0A, 0xFF, 0xFF,
  0xA0, 0xB7, 0x73, 0x07, 0xFF, 0xFF, 0x09, 0x77, 0x50, 0x30, 0xDF, 0xFF, 0xB0, 0xE0, 0x57, 0x77,
  0x10, 0x60, 0xDF, 0xFE, 0x0E, 0x07, 0x77, 0x75, 0x81, 0x5A, 0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x77,
  0x38, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x72,
  // "Œ" (U+0152)
  0x77, 0x18, 0x43, 0x7B, 0xCD, 0xEB, 0x82, 0xDB, 0x61, 0x77, 0x77, 0x78, 0x11, 0x8E, 0xFF, 0xFF,
  0xF0, 0x37, 0x40, 0x88, 0x0C, 0x2F, 0x03, 0x72, 0x02, 0x0C, 0x80, 0xC3, 0xF0, 0x37, 0x10, 0x30,
  0xE8, 0x0C, 0x4F, 0x03, 0x70, 0x20, 0xE8, 0x0C, 0x5F, 0x03, 0x60, 0x10, 0xD8, 0x0C, 0x6F, 0x03,
  0x60, 0x98, 0x0C, 0x7F, 0x03, 0x50, 0x58, 0x0D, 0x0F, 0x03, 0x50, 0xD8, 0x0D, 0x0F, 0x03, 0x40,
  0x58, 0x0D, 0x1F, 0x03, 0x40, 0xDF, 0xF0, 0x90, 0x32, 0x81, 0x25, 0xEF, 0xFF, 0xB0, 0x33, 0x04,
  0xFE, 0x0E, 0x04, 0x60, 0x6F, 0xC0, 0xD7, 0x72, 0x09, 0xFE, 0x04, 0x70, 0x5F, 0xC0, 0xD7, 0x72,
  0x0E, 0xFD, 0x08, 0x71, 0x05, 0xFC, 0x0D, 0x77, 0x10, 0x4F, 0xD0, 0xE0, 0x17, 0x10, 0x5F, 0xC0,
  0xD7, 0x71, 0x07, 0xFD, 0x09, 0x72, 0x05, 0xFC, 0x0D, 0x77, 0x10, 0xBF, 0xD0, 0x47, 0x20, 0x5F,
  0xC0, 0xD7, 0x71, 0x0E, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0D, 0x77, 0x02, 0xFD, 0x0A, 0x73, 0x05,
  0xFC, 0x0D, 0x77, 0x05, 0xFD, 0x07, 0x73, 0x05, 0xFC, 0x0D, 0x77, 0x07, 0xFD, 0x04, 0x73, 0x05,
  0xFC, 0x0D, 0x77, 0x0A, 0xFD, 0x02, 0x73, 0x05, 0xFC, 0x0D, 0x77, 0x0C, 0xFD, 0x74, 0x05, 0xFC,
  0x0D, 0x77, 0x0D, 0xFC, 0x0D, 0x74, 0x05, 0xFC, 0x0D, 0x77, 0x0E, 0xFC, 0x0C, 0x74, 0x05, 0xFC,
  0x0D, 0x77, 0xFD, 0x0A, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x2F, 0xD0, 0x97, 0x40, 0x5F, 0xFF,
  0x90, 0x92, 0x02, 0xFD, 0x09, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x3F, 0xD0, 0x87, 0x40, 0x5F,
  0xFF, 0x90, 0x92, 0x03, 0xFD, 0x07, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x4F, 0xD0, 0x77, 0x40,
  0x5F, 0xFF, 0x90, 0x92, 0x04, 0xFD, 0x07, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x4F, 0xD0, 0x77,
  0x40, 0x5F, 0xFF, 0x90, 0x92, 0x04, 0xFD, 0x07, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x3F, 0xD0,
  0x77, 0x40, 0x5F, 0xFF, 0x90, 0x92, 0x03, 0xFD, 0x08, 0x74, 0x05, 0xFF, 0xF9, 0x09, 0x20, 0x2F,
  0xD0, 0x87, 0x40, 0x5F, 0xC0, 0xD7, 0x60, 0x1F, 0xD0, 0x97, 0x40, 0x5F, 0xC0, 0xD7, 0x7F, 0xD0,
  0xA7, 0x40, 0x5F, 0xC0, 0xD7, 0x70, 0xEF, 0xC0, 0xB7, 0x40, 0x5F, 0xC0, 0xD7, 0x70, 0xDF, 0xC0,
  0xC7, 0x40, 0x5F, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xE7, 0x40, 0x5F, 0xC0, 0xD7, 0x70, 0x9F, 0xD7,
  0x40, 0x5F, 0xC0, 0xD7, 0x70, 0x7F, 0xD0, 0x27, 0x30, 0x5F, 0xC0, 0xD7, 0x70, 0x5F, 0xD0, 0x57,
  0x30, 0x5F, 0xC0, 0xD7, 0x70, 0x3F, 0xD0, 0x87, 0x30, 0x5F, 0xC0, 0xD7, 0x71, 0xFD, 0x0B, 0x73,
  0x05, 0xFC, 0x0D, 0x77, 0x10, 0xCF, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x04,
  0x72, 0x05, 0xFC, 0x0D, 0x77, 0x10, 0x4F, 0xD0, 0xA7, 0x20, 0x5F, 0xC0, 0xD7, 0x72, 0x0E, 0xFD,
  0x02, 0x71, 0x05, 0xFC, 0x0D, 0x77, 0x20, 0xAF, 0xD0, 0xB7, 0x10, 0x5F, 0xC0, 0xD7, 0x72, 0x05,
  0xFE, 0x0A, 0x70, 0x6F, 0xC0, 0xD7, 0x73, 0x0E, 0xFE, 0x81, 0xD6, 0x22, 0x03, 0x08, 0xFF, 0xFC,
  0x03, 0x40, 0x78, 0x0D, 0x1F, 0x03, 0x50, 0xE8, 0x0D, 0x0F, 0x03, 0x50, 0x78, 0x0D, 0x0F, 0x03,
  0x60, 0xC8, 0x0C, 0x7F, 0x03, 0x60, 0x20, 0xE8, 0x0C, 0x6F, 0x03, 0x70, 0x48, 0x0C, 0x6F, 0x03,
  0x71, 0x05, 0x80, 0xC5, 0xF0, 0x37, 0x20, 0x40, 0xE8, 0x0C, 0x3F, 0x03, 0x73, 0x01, 0x0B, 0x80,
  0xC2, 0xF0, 0x37, 0x50, 0x30, 0xA8, 0x0C, 0x0F, 0x03, 0x77, 0x89, 0x31, 0x48, 0xBD, 0xEF, 0xED,
  0xCA, 0x73, 0x77, 0x73,
  // "œ" (U+0153)
  0x74, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xC9, 0x47, 0x68, 0x75, 0xAD, 0xEF, 0xEC, 0x94, 0x77, 0x50,
  0x50, 0xCF, 0xB0, 0xD0, 0x67, 0x20, 0x60, 0xEF, 0xA0, 0xD0, 0x57, 0x71, 0x01, 0x0A, 0xFF, 0x0B,
  0x01, 0x60, 0xAF, 0xE0, 0x97, 0x60, 0x10, 0xCF, 0xFA, 0x0D, 0x01, 0x40, 0xCF, 0xF9, 0x0A, 0x75,
  0x0C, 0xFF, 0xC0, 0xC3, 0x0A, 0xFF, 0xB0, 0x87, 0x30, 0x9F, 0xFE, 0x81, 0x90, 0x6F, 0xFD, 0x03,
  0x71, 0x04, 0xFF, 0xF9, 0x05, 0x0E, 0xFF, 0xD0, 0xC7, 0x10, 0xC8, 0x0D, 0x0F, 0x05, 0x60, 0x58,
  0x0D, 0x1F, 0x0C, 0x60, 0xBF, 0xB8, 0x39, 0x20, 0x3C, 0xFF, 0xA8, 0x3E, 0x61, 0x17, 0xFB, 0x02,
  0x40, 0x2F, 0xB0, 0x95, 0x0D, 0xFF, 0x0E, 0x03, 0x40, 0x6F, 0xA0, 0x74, 0x07, 0xFA, 0x0E, 0x60,
  0x3F, 0xF0, 0x66, 0x0D, 0xF9, 0x0C, 0x40, 0xCF, 0xA0, 0x97, 0x0B, 0xFD, 0x0D, 0x70, 0x7F, 0xA3,
  0x01, 0xFB, 0x04, 0x70, 0x6F, 0xD0, 0x77, 0x03, 0xFA, 0x04, 0x20, 0x4F, 0xB7, 0x10, 0x2F, 0xD0,
  0x37, 0x1F, 0xA0, 0x72, 0x08, 0xFA, 0x0D, 0x72, 0x0D, 0xFC, 0x72, 0x0D, 0xF9, 0x09, 0x20, 0xBF,
  0xA0, 0xB7, 0x20, 0xBF, 0xB0, 0xC7, 0x20, 0xBF, 0x90, 0xB2, 0x0D, 0xFA, 0x09, 0x72, 0x08, 0xFB,
  0x0A, 0x72, 0x0A, 0xF9, 0x0D, 0x2F, 0xB0, 0x77, 0x20, 0x6F, 0xB0, 0x97, 0x20, 0x9F, 0x98, 0x1E,
  0x01, 0xFB, 0x06, 0x72, 0x04, 0xFB, 0x08, 0x72, 0x08, 0xFA, 0x10, 0x2F, 0xB0, 0x57, 0x20, 0x3F,
  0xB0, 0x77, 0x20, 0x8F, 0xA1, 0x04, 0xFB, 0x04, 0x72, 0x02, 0xFF, 0xFF, 0xA0, 0x10, 0x4F, 0xB0,
  0x47, 0x20, 0x1F, 0xFF, 0xFA, 0x01, 0x05, 0xFB, 0x03, 0x72, 0x01, 0xFF, 0xFF, 0xA0, 0x10, 0x5F,
  0xB0, 0x37, 0x20, 0x1F, 0xFF, 0xFA, 0x01, 0x05, 0xFB, 0x03, 0x73, 0xFF, 0xFF, 0xA0, 0x10, 0x5F,
  0xB0, 0x37, 0x20, 0x1F, 0xFF, 0xFA, 0x01, 0x04, 0xFB, 0x03, 0x72, 0x01, 0xFF, 0xFF, 0xA0, 0x10,
  0x4F, 0xB0, 0x47, 0x20, 0x1F, 0xFF, 0xFA, 0x01, 0x03, 0xFB, 0x04, 0x72, 0x02, 0xFB, 0x07, 0x77,
  0x60, 0x1F, 0xB0, 0x57, 0x20, 0x3F, 0xB0, 0x87, 0x77, 0xFB, 0x06, 0x72, 0x05, 0xFB, 0x08, 0x77,
  0x70, 0xEF, 0xA0, 0x87, 0x20, 0x6F, 0xB0, 0xA7, 0x77, 0x0B, 0xFA, 0x09, 0x72, 0x08, 0xFB, 0x0B,
  0x77, 0x70, 0x9F, 0xA0, 0xB7, 0x20, 0xBF, 0xB0, 0xE7, 0x77, 0x06, 0xFA, 0x0D, 0x72, 0x0D, 0xFC,
  0x02, 0x77, 0x60, 0x3F, 0xB0, 0x17, 0x02, 0xFD, 0x07, 0x77, 0x70, 0xEF, 0xA0, 0x57, 0x06, 0xFD,
  0x0D, 0x77, 0x70, 0xAF, 0xA0, 0xA7, 0x0C, 0xFE, 0x06, 0x77, 0x10, 0x24, 0x05, 0xFB, 0x01, 0x50,
  0x3F, 0xF0, 0xE0, 0x27, 0x58, 0x12, 0xAD, 0x50, 0xEF, 0xA0, 0xA5, 0x0D, 0xFF, 0x90, 0xE0, 0x47,
  0x20, 0x40, 0xAA, 0x0D, 0x50, 0x9F, 0xB8, 0x3A, 0x20, 0x3C, 0xFF, 0xC8, 0x7B, 0x51, 0x01, 0x25,
  0x9D, 0xC0, 0xD5, 0x02, 0x80, 0xD2, 0xF0, 0xD6, 0x0A, 0x80, 0xD1, 0xF0, 0xD6, 0x01, 0x0E, 0xFF,
  0xF0, 0x50, 0xDF, 0xFF, 0x0D, 0x70, 0x6F, 0xFE, 0x81, 0xA0, 0x4F, 0xFF, 0x0D, 0x71, 0x09, 0xFF,
  0xC0, 0xD0, 0x12, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xAF, 0xFA, 0x0D, 0x02, 0x40, 0xAF, 0xFD, 0x0B,
  0x73, 0x07, 0xFF, 0x0B, 0x01, 0x60, 0x9F, 0xFA, 0x0D, 0x06, 0x75, 0x03, 0x0B, 0xFB, 0x0D, 0x06,
  0x72, 0x04, 0x0C, 0xFD, 0x0B, 0x05, 0x77, 0x28, 0x90, 0x27, 0xBD, 0xEF, 0xEC, 0x94, 0x76, 0x89,
  0x23, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x17,
  // "Ŕ" (U+0154)
  0x77, 0x71, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x72, 0x09, 0xFE, 0x0E, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0xF0, 0x47, 0x77, 0x72, 0x0C, 0xFE, 0x05, 0x77, 0x77, 0x20, 0x6F, 0xE0, 0x57, 0x77, 0x72,
  0x01, 0x0E, 0xFD, 0x05, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x73, 0x06, 0xFC, 0x0E,
  0x03, 0x77, 0x77, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x74, 0x0C, 0xFB, 0x0D, 0x02, 0x77,
  0x77, 0x40, 0x7F, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x10,
  0xDF, 0xA0, 0xA7, 0x77, 0x76, 0x0A, 0xFA, 0x08, 0x77, 0x77, 0x70, 0xEF, 0x0E, 0x05, 0x80, 0xCC,
  0x60, 0x0C, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x60, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77,
  0x30, 0xCF, 0xFF, 0xF8, 0x1E, 0x81, 0x77, 0x0C, 0xFF, 0xFF, 0xB0, 0x87, 0x60, 0xCF, 0xFF, 0xFC,
  0x0D, 0x02, 0x74, 0x0C, 0xFF, 0xFF, 0xD0, 0xE0, 0x47, 0x30, 0xCF, 0xFF, 0xFF, 0x04, 0x72, 0x0C,
  0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x10, 0xC8, 0x0C, 0x0F, 0x0C, 0x71, 0x0C, 0x80, 0xC1, 0xF0, 0x77,
  0x0C, 0xFD, 0x86, 0xA8, 0x88, 0x89, 0xAD, 0xFF, 0xB0, 0xE7, 0x0C, 0xFD, 0x03, 0x71, 0x05, 0x0B,
  0xFF, 0x90, 0x66, 0x0C, 0xFD, 0x03, 0x73, 0x04, 0x0E, 0xFE, 0x0C, 0x60, 0xCF, 0xD0, 0x37, 0x40,
  0x20, 0xEF, 0xE0, 0x15, 0x0C, 0xFD, 0x03, 0x75, 0x06, 0xFE, 0x04, 0x50, 0xCF, 0xD0, 0x37, 0x60,
  0xEF, 0xD0, 0x75, 0x0C, 0xFD, 0x03, 0x76, 0x0A, 0xFD, 0x09, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x7F,
  0xD0, 0xB5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x5F, 0xD0,
  0xC5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x8F, 0xD0, 0xA5,
  0x0C, 0xFD, 0x03, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0xEF, 0xD0, 0x55, 0x0C,
  0xFD, 0x03, 0x75, 0x07, 0xFE, 0x02, 0x50, 0xCF, 0xD0, 0x37, 0x40, 0x20, 0xEF, 0xD0, 0xE6, 0x0C,
  0xFD, 0x03, 0x73, 0x01, 0x0D, 0xFE, 0x08, 0x60, 0xCF, 0xD0, 0x37, 0x20, 0x50, 0xEF, 0xF0, 0x36,
  0x0C, 0xFD, 0x03, 0x48, 0x31, 0x25, 0x8D, 0xFF, 0x90, 0xA7, 0x0C, 0x80, 0xC1, 0xF0, 0x27, 0x0C,
  0x80, 0xC0, 0xF0, 0x77, 0x10, 0xCF, 0xFF, 0xFF, 0x0A, 0x72, 0x0C, 0xFF, 0xFF, 0xE0, 0xB7, 0x30,
  0xCF, 0xFF, 0xFD, 0x0B, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x87, 0x50, 0xCF, 0xFF, 0xFA, 0x0D, 0x04,
  0x76, 0x0C, 0xFF, 0xFF, 0x90, 0x67, 0x71, 0x0C, 0xFF, 0xFF, 0x90, 0x57, 0x71, 0x0C, 0xFF, 0xFF,
  0x90, 0xD7, 0x71, 0x0C, 0xFD, 0x84, 0xA8, 0x88, 0x8B, 0xFD, 0x07, 0x77, 0x0C, 0xFD, 0x03, 0x40,
  0x1F, 0xD0, 0xE0, 0x17, 0x60, 0xCF, 0xD0, 0x35, 0x08, 0xFD, 0x0A, 0x76, 0x0C, 0xFD, 0x03, 0x50,
  0x10, 0xEF, 0xD0, 0x37, 0x50, 0xCF, 0xD0, 0x36, 0x07, 0xFD, 0x0C, 0x75, 0x0C, 0xFD, 0x03, 0x70,
  0xDF, 0xD0, 0x57, 0x40, 0xCF, 0xD0, 0x37, 0x05, 0xFD, 0x0E, 0x74, 0x0C, 0xFD, 0x03, 0x71, 0x0C,
  0xFD, 0x08, 0x73, 0x0C, 0xFD, 0x03, 0x71, 0x03, 0xFE, 0x02, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x0B,
  0xFD, 0x0A, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x02, 0xFE, 0x04, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x09,
  0xFD, 0x0C, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0x0E, 0xFD, 0x06, 0x70, 0xCF, 0xD0, 0x37, 0x40,
  0x7F, 0xD0, 0xE0, 0x16, 0x0C, 0xFD, 0x03, 0x75, 0x0E, 0xFD, 0x09, 0x60, 0xCF, 0xD0, 0x37, 0x50,
  0x6F, 0xE0, 0x25, 0x0C, 0xFD, 0x03, 0x76, 0x0D, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x4F,
  0xE0, 0x54, 0x0C, 0xFD, 0x03, 0x77, 0x0B, 0xFD, 0x0D, 0x40, 0xCF, 0xD0, 0x37, 0x70, 0x3F, 0xE0,
  0x73, 0x0C, 0xFD, 0x03, 0x77, 0x10, 0xAF, 0xD0, 0xE0, 0x12, 0x0C, 0xFD, 0x03, 0x77, 0x10, 0x2F,
  0xE0, 0x92, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x8F, 0xE8, 0x13, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x10,
  0xEF, 0xD8, 0x1C, 0x0C, 0xFD, 0x03, 0x77, 0x30, 0x7F, 0xE0, 0x50,
  // "ŕ" (U+0155)
  0x77, 0x77, 0x10, 0x18, 0x09, 0x27, 0x01, 0x77, 0x77, 0x60, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x75,
  0x03, 0xFF, 0x04, 0x77, 0x77, 0x60, 0xCF, 0xE0, 0x57, 0x77, 0x76, 0x06, 0xFE, 0x05, 0x77, 0x77,
  0x60, 0x10, 0xEF, 0xD0, 0x57, 0x77, 0x77, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x70, 0x6F, 0xC0,
  0xE0, 0x37, 0x77, 0x77, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x80, 0xC0, 0x00, 0xCF, 0xB0, 0xD0, 0x28,
  0x0C, 0x00, 0x07, 0xFB, 0x0D, 0x01, 0x80, 0xC0, 0x00, 0x3F, 0xB0, 0xB0, 0x18, 0x0C, 0x00, 0x01,
  0x0D, 0xFA, 0x0A, 0x80, 0xC2, 0x00, 0xAF, 0xA0, 0x88, 0x0C, 0x30, 0x0E, 0xF0, 0xE0, 0x58, 0x0C,
  0xD4, 0x08, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xCB, 0x85, 0x15, 0x0D, 0xFF, 0xD0, 0x77, 0x20, 0x50,
  0xCF, 0xE0, 0xA0, 0x23, 0x0D, 0xFF, 0xD0, 0xA7, 0x02, 0x0B, 0xFF, 0xA0, 0x33, 0x0D, 0xFF, 0xD0,
  0xE6, 0x04, 0x0E, 0xFF, 0xA0, 0xE4, 0x0D, 0xFF, 0xE0, 0x24, 0x05, 0xFF, 0xC0, 0xA4, 0x0D, 0xFF,
  0xE0, 0x53, 0x04, 0xFF, 0xD0, 0x64, 0x0D, 0xFF, 0xE0, 0x92, 0x02, 0x0E, 0xFF, 0xD0, 0x14, 0x0D,
  0xFF, 0xE0, 0xC2, 0x0C, 0xFF, 0xD0, 0xC5, 0x0D, 0xFF, 0xF1, 0x07, 0xFF, 0xE0, 0x85, 0x0D, 0xFF,
  0xF0, 0x80, 0xEF, 0xFE, 0x04, 0x58, 0x18, 0xCE, 0x80, 0xC4, 0xF0, 0xE7, 0x28, 0x41, 0x36, 0x8A,
  0xDF, 0xFF, 0xFE, 0x0B, 0x77, 0x20, 0x9F, 0xFF, 0xFC, 0x06, 0x77, 0x20, 0x8F, 0xFD, 0x83, 0xEA,
  0x53, 0x12, 0x85, 0x12, 0x58, 0xBF, 0x27, 0x72, 0x08, 0xFF, 0xC0, 0x87, 0x50, 0x17, 0x73, 0x08,
  0xFF, 0xA0, 0xD0, 0x27, 0x77, 0x73, 0x08, 0xFF, 0x90, 0xD0, 0x27, 0x77, 0x74, 0x08, 0xFF, 0x90,
  0x37, 0x77, 0x75, 0x08, 0xFF, 0x09, 0x77, 0x77, 0x60, 0x8F, 0xF0, 0x17, 0x77, 0x76, 0x08, 0xFE,
  0x09, 0x77, 0x77, 0x70, 0x8F, 0xE0, 0x47, 0x77, 0x77, 0x08, 0xFE, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0xC8, 0x0C, 0x00, 0x08, 0xFD, 0x0A, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x08, 0xFD,
  0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00,
  0x08, 0xFD, 0x08, 0x77, 0x77, 0x68, 0x13, 0x6C, 0xFD, 0x81, 0xC6, 0x37, 0x77, 0x68, 0x22, 0x59,
  0xCF, 0xFE, 0x82, 0xC9, 0x62, 0x77, 0x38, 0x32, 0x58, 0xBE, 0xFF, 0xFF, 0x83, 0xEB, 0x85, 0x27,
  0x40, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06,
  0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0,
  0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30,
  // "Ŗ" (U+0156)
  0x0C, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x60, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x30,
  0xCF, 0xFF, 0xF8, 0x1E, 0x81, 0x77, 0x0C, 0xFF, 0xFF, 0xB0, 0x87, 0x60, 0xCF, 0xFF, 0xFC, 0x0D,
  0x02, 0x74, 0x0C, 0xFF, 0xFF, 0xD0, 0xE0, 0x47, 0x30, 0xCF, 0xFF, 0xFF, 0x04, 0x72, 0x0C, 0xFF,
  0xFF, 0xF0, 0xE0, 0x27, 0x10, 0xC8, 0x0C, 0x0F, 0x0C, 0x71, 0x0C, 0x80, 0xC1, 0xF0, 0x77, 0x0C,
  0xFD, 0x86, 0xA8, 0x88, 0x89, 0xAD, 0xFF, 0xB0, 0xE7, 0x0C, 0xFD, 0x03, 0x71, 0x05, 0x0B, 0xFF,
  0x90, 0x66, 0x0C, 0xFD, 0x03, 0x73, 0x04, 0x0E, 0xFE, 0x0C, 0x60, 0xCF, 0xD0, 0x37, 0x40, 0x20,
  0xEF, 0xE0, 0x15, 0x0C, 0xFD, 0x03, 0x75, 0x06, 0xFE, 0x04, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0xEF,
  0xD0, 0x75, 0x0C, 0xFD, 0x03, 0x76, 0x0A, 0xFD, 0x09, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x7F, 0xD0,
  0xB5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x5F, 0xD0, 0xC5,
  0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x8F, 0xD0, 0xA5, 0x0C,
  0xFD, 0x03, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0xEF, 0xD0, 0x55, 0x0C, 0xFD,
  0x03, 0x75, 0x07, 0xFE, 0x02, 0x50, 0xCF, 0xD0, 0x37, 0x40, 0x20, 0xEF, 0xD0, 0xE6, 0x0C, 0xFD,
  0x03, 0x73, 0x01, 0x0D, 0xFE, 0x08, 0x60, 0xCF, 0xD0, 0x37, 0x20, 0x50, 0xEF, 0xF0, 0x36, 0x0C,
  0xFD, 0x03, 0x48, 0x31, 0x25, 0x8D, 0xFF, 0x90, 0xA7, 0x0C, 0x80, 0xC1, 0xF0, 0x27, 0x0C, 0x80,
  0xC0, 0xF0, 0x77, 0x10, 0xCF, 0xFF, 0xFF, 0x0A, 0x72, 0x0C, 0xFF, 0xFF, 0xE0, 0xB7, 0x30, 0xCF,
  0xFF, 0xFD, 0x0B, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x87, 0x50, 0xCF, 0xFF, 0xFA, 0x0D, 0x04, 0x76,
  0x0C, 0xFF, 0xFF, 0x90, 0x67, 0x71, 0x0C, 0xFF, 0xFF, 0x90, 0x57, 0x71, 0x0C, 0xFF, 0xFF, 0x90,
  0xD7, 0x71, 0x0C, 0xFD, 0x84, 0xA8, 0x88, 0x8B, 0xFD, 0x07, 0x77, 0x0C, 0xFD, 0x03, 0x40, 0x1F,
  0xD0, 0xE0, 0x17, 0x60, 0xCF, 0xD0, 0x35, 0x08, 0xFD, 0x0A, 0x76, 0x0C, 0xFD, 0x03, 0x50, 0x10,
  0xEF, 0xD0, 0x37, 0x50, 0xCF, 0xD0, 0x36, 0x07, 0xFD, 0x0C, 0x75, 0x0C, 0xFD, 0x03, 0x70, 0xDF,
  0xD0, 0x57, 0x40, 0xCF, 0xD0, 0x37, 0x05, 0xFD, 0x0E, 0x74, 0x0C, 0xFD, 0x03, 0x71, 0x0C, 0xFD,
  0x08, 0x73, 0x0C, 0xFD, 0x03, 0x71, 0x03, 0xFE, 0x02, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x0B, 0xFD,
  0x0A, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x02, 0xFE, 0x04, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x09, 0xFD,
  0x0C, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0x0E, 0xFD, 0x06, 0x70, 0xCF, 0xD0, 0x37, 0x40, 0x7F,
  0xD0, 0xE0, 0x16, 0x0C, 0xFD, 0x03, 0x75, 0x0E, 0xFD, 0x09, 0x60, 0xCF, 0xD0, 0x37, 0x50, 0x6F,
  0xE0, 0x25, 0x0C, 0xFD, 0x03, 0x76, 0x0D, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37, 0x60, 0x4F, 0xE0,
  0x54, 0x0C, 0xFD, 0x03, 0x77, 0x0B, 0xFD, 0x0D, 0x40, 0xCF, 0xD0, 0x37, 0x70, 0x3F, 0xE0, 0x73,
  0x0C, 0xFD, 0x03, 0x77, 0x10, 0xAF, 0xD0, 0xE0, 0x12, 0x0C, 0xFD, 0x03, 0x77, 0x10, 0x2F, 0xE0,
  0x92, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x8F, 0xE8, 0x13, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x10, 0xEF,
  0xD8, 0x1C, 0x0C, 0xFD, 0x03, 0x77, 0x30, 0x7F, 0xE0, 0x58, 0x0C, 0xB7, 0x00, 0x3F, 0xC0, 0xD7,
  0x77, 0x75, 0x05, 0xFC, 0x08, 0x77, 0x77, 0x50, 0x8F, 0xC0, 0x17, 0x77, 0x75, 0x0A, 0xFB, 0x09,
  0x77, 0x77, 0x60, 0xEF, 0xB0, 0x27, 0x77, 0x75, 0x01, 0xFB, 0x09, 0x77, 0x77, 0x60, 0x5F, 0xB0,
  0x17, 0x77, 0x76, 0x08, 0xFA, 0x08, 0x77, 0x77, 0x70, 0xCF, 0x90, 0xE0, 0x17, 0x77, 0x77, 0xFA,
  0x06, 0x77, 0x77, 0x70, 0x4F, 0x90, 0xC8, 0x0C, 0x00, 0x08, 0xF9, 0x03, 0x80, 0xC0, 0x00, 0xCF,
  0x08, 0x80, 0xC1, 0x00, 0xEE, 0x0D, 0x77, 0x74,
  // "ŗ" (U+0157)
  0x77, 0x77, 0x78, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xCB, 0x85, 0x15, 0x0D, 0xFF, 0xD0, 0x77, 0x20,
  0x50, 0xCF, 0xE0, 0xA0, 0x23, 0x0D, 0xFF, 0xD0, 0xA7, 0x02, 0x0B, 0xFF, 0xA0, 0x33, 0x0D, 0xFF,
  0xD0, 0xE6, 0x04, 0x0E, 0xFF, 0xA0, 0xE4, 0x0D, 0xFF, 0xE0, 0x24, 0x05, 0xFF, 0xC0, 0xA4, 0x0D,
  0xFF, 0xE0, 0x53, 0x04, 0xFF, 0xD0, 0x64, 0x0D, 0xFF, 0xE0, 0x92, 0x02, 0x0E, 0xFF, 0xD0, 0x14,
  0x0D, 0xFF, 0xE0, 0xC2, 0x0C, 0xFF, 0xD0, 0xC5, 0x0D, 0xFF, 0xF1, 0x07, 0xFF, 0xE0, 0x85, 0x0D,
  0xFF, 0xF0, 0x80, 0xEF, 0xFE, 0x04, 0x58, 0x18, 0xCE, 0x80, 0xC4, 0xF0, 0xE7, 0x28, 0x41, 0x36,
  0x8A, 0xDF, 0xFF, 0xFE, 0x0B, 0x77, 0x20, 0x9F, 0xFF, 0xFC, 0x06, 0x77, 0x20, 0x8F, 0xFD, 0x83,
  0xEA, 0x53, 0x12, 0x85, 0x12, 0x58, 0xBF, 0x27, 0x72, 0x08, 0xFF, 0xC0, 0x87, 0x50, 0x17, 0x73,
  0x08, 0xFF, 0xA0, 0xD0, 0x27, 0x77, 0x73, 0x08, 0xFF, 0x90, 0xD0, 0x27, 0x77, 0x74, 0x08, 0xFF,
  0x90, 0x37, 0x77, 0x75, 0x08, 0xFF, 0x09, 0x77, 0x77, 0x60, 0x8F, 0xF0, 0x17, 0x77, 0x76, 0x08,
  0xFE, 0x09, 0x77, 0x77, 0x70, 0x8F, 0xE0, 0x47, 0x77, 0x77, 0x08, 0xFE, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0xC8, 0x0C, 0x00, 0x08, 0xFD, 0x0A, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x08,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00,
  0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C,
  0x00, 0x08, 0xFD, 0x08, 0x77, 0x77, 0x68, 0x13, 0x6C, 0xFD, 0x81, 0xC6, 0x37, 0x77, 0x68, 0x22,
  0x59, 0xCF, 0xFE, 0x82, 0xC9, 0x62, 0x77, 0x38, 0x32, 0x58, 0xBE, 0xFF, 0xFF, 0x83, 0xEB, 0x85,
  0x27, 0x40, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F,
  0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2,
  0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x68, 0x0C, 0xF7, 0x00,
  0x3F, 0xC0, 0xD8, 0x0C, 0x10, 0x05, 0xFC, 0x08, 0x80, 0xC1, 0x00, 0x8F, 0xC0, 0x18, 0x0C, 0x10,
  0x0A, 0xFB, 0x09, 0x80, 0xC2, 0x00, 0xEF, 0xB0, 0x28, 0x0C, 0x10, 0x01, 0xFB, 0x09, 0x80, 0xC2,
  0x00, 0x5F, 0xB0, 0x18, 0x0C, 0x20, 0x08, 0xFA, 0x08, 0x80, 0xC3, 0x00, 0xCF, 0x90, 0xE0, 0x18,
  0x0C, 0x30, 0xFA, 0x06, 0x80, 0xC3, 0x00, 0x4F, 0x90, 0xC8, 0x0C, 0x40, 0x08, 0xF9, 0x03, 0x80,
  0xC4, 0x00, 0xCF, 0x08, 0x80, 0xC5, 0x00, 0xEE, 0x0D, 0x77, 0x77, 0x30,
  // "Ř" (U+0158)
  0x30, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x75, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x76, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x77, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x10, 0x20, 0xEF, 0xA0, 0x56, 0x08,
  0xFB, 0x03, 0x77, 0x30, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x50, 0x8F, 0xB0, 0x62, 0x09,
  0xFB, 0x09, 0x77, 0x70, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x77, 0x10, 0x10, 0xEF, 0xFE, 0x0E,
  0x02, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x40, 0x8F, 0xFC, 0x08, 0x77, 0x76, 0x0C, 0xFF,
  0xA0, 0xC7, 0x77, 0x70, 0x2F, 0xFA, 0x02, 0x77, 0x77, 0x10, 0x7F, 0xF0, 0x77, 0x77, 0x73, 0x0D,
  0xFD, 0x0D, 0x80, 0xCC, 0x30, 0x0C, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x60, 0xCF, 0xFF,
  0xC8, 0x1E, 0xA5, 0x77, 0x30, 0xCF, 0xFF, 0xF8, 0x1E, 0x81, 0x77, 0x0C, 0xFF, 0xFF, 0xB0, 0x87,
  0x60, 0xCF, 0xFF, 0xFC, 0x0D, 0x02, 0x74, 0x0C, 0xFF, 0xFF, 0xD0, 0xE0, 0x47, 0x30, 0xCF, 0xFF,
  0xFF, 0x04, 0x72, 0x0C, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x10, 0xC8, 0x0C, 0x0F, 0x0C, 0x71, 0x0C,
  0x80, 0xC1, 0xF0, 0x77, 0x0C, 0xFD, 0x86, 0xA8, 0x88, 0x89, 0xAD, 0xFF, 0xB0, 0xE7, 0x0C, 0xFD,
  0x03, 0x71, 0x05, 0x0B, 0xFF, 0x90, 0x66, 0x0C, 0xFD, 0x03, 0x73, 0x04, 0x0E, 0xFE, 0x0C, 0x60,
  0xCF, 0xD0, 0x37, 0x40, 0x20, 0xEF, 0xE0, 0x15, 0x0C, 0xFD, 0x03, 0x75, 0x06, 0xFE, 0x04, 0x50,
  0xCF, 0xD0, 0x37, 0x60, 0xEF, 0xD0, 0x75, 0x0C, 0xFD, 0x03, 0x76, 0x0A, 0xFD, 0x09, 0x50, 0xCF,
  0xD0, 0x37, 0x60, 0x7F, 0xD0, 0xB5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0,
  0x37, 0x60, 0x5F, 0xD0, 0xC5, 0x0C, 0xFD, 0x03, 0x76, 0x06, 0xFD, 0x0B, 0x50, 0xCF, 0xD0, 0x37,
  0x60, 0x8F, 0xD0, 0xA5, 0x0C, 0xFD, 0x03, 0x76, 0x0B, 0xFD, 0x08, 0x50, 0xCF, 0xD0, 0x37, 0x60,
  0xEF, 0xD0, 0x55, 0x0C, 0xFD, 0x03, 0x75, 0x07, 0xFE, 0x02, 0x50, 0xCF, 0xD0, 0x37, 0x40, 0x20,
  0xEF, 0xD0, 0xE6, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0x0D, 0xFE, 0x08, 0x60, 0xCF, 0xD0, 0x37, 0x20,
  0x50, 0xEF, 0xF0, 0x36, 0x0C, 0xFD, 0x03, 0x48, 0x31, 0x25, 0x8D, 0xFF, 0x90, 0xA7, 0x0C, 0x80,
  0xC1, 0xF0, 0x27, 0x0C, 0x80, 0xC0, 0xF0, 0x77, 0x10, 0xCF, 0xFF, 0xFF, 0x0A, 0x72, 0x0C, 0xFF,
  0xFF, 0xE0, 0xB7, 0x30, 0xCF, 0xFF, 0xFD, 0x0B, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x87, 0x50, 0xCF,
  0xFF, 0xFA, 0x0D, 0x04, 0x76, 0x0C, 0xFF, 0xFF, 0x90, 0x67, 0x71, 0x0C, 0xFF, 0xFF, 0x90, 0x57,
  0x71, 0x0C, 0xFF, 0xFF, 0x90, 0xD7, 0x71, 0x0C, 0xFD, 0x84, 0xA8, 0x88, 0x8B, 0xFD, 0x07, 0x77,
  0x0C, 0xFD, 0x03, 0x40, 0x1F, 0xD0, 0xE0, 0x17, 0x60, 0xCF, 0xD0, 0x35, 0x08, 0xFD, 0x0A, 0x76,
  0x0C, 0xFD, 0x03, 0x50, 0x10, 0xEF, 0xD0, 0x37, 0x50, 0xCF, 0xD0, 0x36, 0x07, 0xFD, 0x0C, 0x75,
  0x0C, 0xFD, 0x03, 0x70, 0xDF, 0xD0, 0x57, 0x40, 0xCF, 0xD0, 0x37, 0x05, 0xFD, 0x0E, 0x74, 0x0C,
  0xFD, 0x03, 0x71, 0x0C, 0xFD, 0x08, 0x73, 0x0C, 0xFD, 0x03, 0x71, 0x03, 0xFE, 0x02, 0x72, 0x0C,
  0xFD, 0x03, 0x72, 0x0B, 0xFD, 0x0A, 0x72, 0x0C, 0xFD, 0x03, 0x72, 0x02, 0xFE, 0x04, 0x71, 0x0C,
  0xFD, 0x03, 0x73, 0x09, 0xFD, 0x0C, 0x71, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0x0E, 0xFD, 0x06, 0x70,
  0xCF, 0xD0, 0x37, 0x40, 0x7F, 0xD0, 0xE0, 0x16, 0x0C, 0xFD, 0x03, 0x75, 0x0E, 0xFD, 0x09, 0x60,
  0xCF, 0xD0, 0x37, 0x50, 0x6F, 0xE0, 0x25, 0x0C, 0xFD, 0x03, 0x76, 0x0D, 0xFD, 0x0B, 0x50, 0xCF,
  0xD0, 0x37, 0x60, 0x4F, 0xE0, 0x54, 0x0C, 0xFD, 0x03, 0x77, 0x0B, 0xFD, 0x0D, 0x40, 0xCF, 0xD0,
  0x37, 0x70, 0x3F, 0xE0, 0x73, 0x0C, 0xFD, 0x03, 0x77, 0x10, 0xAF, 0xD0, 0xE0, 0x12, 0x0C, 0xFD,
  0x03, 0x77, 0x10, 0x2F, 0xE0, 0x92, 0x0C, 0xFD, 0x03, 0x77, 0x20, 0x8F, 0xE8, 0x13, 0x0C, 0xFD,
  0x03, 0x77, 0x20, 0x10, 0xEF, 0xD8, 0x1C, 0x0C, 0xFD, 0x03, 0x77, 0x30, 0x7F, 0xE0, 0x50,
  // "ř" (U+0159)
  0x73, 0x03, 0x80, 0x37, 0x06, 0x77, 0x20, 0x68, 0x03, 0x70, 0x37, 0x72, 0x06, 0xF9, 0x0B, 0x01,
  0x75, 0x01, 0x0B, 0xF9, 0x06, 0x77, 0x30, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7,
  0x74, 0x01, 0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x50, 0x20, 0xEF, 0xA0,
  0x56, 0x08, 0xFB, 0x03, 0x77, 0x70, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x72, 0x08, 0xFB,
  0x06, 0x20, 0x9F, 0xB0, 0x97, 0x77, 0x40, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x77, 0x50, 0x10,
  0xEF, 0xFE, 0x0E, 0x02, 0x77, 0x76, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x71, 0x08, 0xFF, 0xC0, 0x87,
  0x77, 0x73, 0x0C, 0xFF, 0xA0, 0xC7, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0x27, 0x77, 0x75, 0x07, 0xFF,
  0x07, 0x77, 0x77, 0x70, 0xDF, 0xD0, 0xD8, 0x0C, 0xD1, 0x08, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xCB,
  0x85, 0x15, 0x0D, 0xFF, 0xD0, 0x77, 0x20, 0x50, 0xCF, 0xE0, 0xA0, 0x23, 0x0D, 0xFF, 0xD0, 0xA7,
  0x02, 0x0B, 0xFF, 0xA0, 0x33, 0x0D, 0xFF, 0xD0, 0xE6, 0x04, 0x0E, 0xFF, 0xA0, 0xE4, 0x0D, 0xFF,
  0xE0, 0x24, 0x05, 0xFF, 0xC0, 0xA4, 0x0D, 0xFF, 0xE0, 0x53, 0x04, 0xFF, 0xD0, 0x64, 0x0D, 0xFF,
  0xE0, 0x92, 0x02, 0x0E, 0xFF, 0xD0, 0x14, 0x0D, 0xFF, 0xE0, 0xC2, 0x0C, 0xFF, 0xD0, 0xC5, 0x0D,
  0xFF, 0xF1, 0x07, 0xFF, 0xE0, 0x85, 0x0D, 0xFF, 0xF0, 0x80, 0xEF, 0xFE, 0x04, 0x58, 0x18, 0xCE,
  0x80, 0xC4, 0xF0, 0xE7, 0x28, 0x41, 0x36, 0x8A, 0xDF, 0xFF, 0xFE, 0x0B, 0x77, 0x20, 0x9F, 0xFF,
  0xFC, 0x06, 0x77, 0x20, 0x8F, 0xFD, 0x83, 0xEA, 0x53, 0x12, 0x85, 0x12, 0x58, 0xBF, 0x27, 0x72,
  0x08, 0xFF, 0xC0, 0x87, 0x50, 0x17, 0x73, 0x08, 0xFF, 0xA0, 0xD0, 0x27, 0x77, 0x73, 0x08, 0xFF,
  0x90, 0xD0, 0x27, 0x77, 0x74, 0x08, 0xFF, 0x90, 0x37, 0x77, 0x75, 0x08, 0xFF, 0x09, 0x77, 0x77,
  0x60, 0x8F, 0xF0, 0x17, 0x77, 0x76, 0x08, 0xFE, 0x09, 0x77, 0x77, 0x70, 0x8F, 0xE0, 0x47, 0x77,
  0x77, 0x08, 0xFE, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0xC8, 0x0C, 0x00, 0x08, 0xFD, 0x0A, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x98, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C,
  0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80,
  0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88,
  0x0C, 0x00, 0x08, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x88, 0x0C, 0x00, 0x08, 0xFD, 0x08, 0x77, 0x77, 0x68, 0x13, 0x6C,
  0xFD, 0x81, 0xC6, 0x37, 0x77, 0x68, 0x22, 0x59, 0xCF, 0xFE, 0x82, 0xC9, 0x62, 0x77, 0x38, 0x32,
  0x58, 0xBE, 0xFF, 0xFF, 0x83, 0xEB, 0x85, 0x27, 0x40, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80,
  0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48,
  0x0C, 0x2F, 0x06, 0x73, 0x04, 0x80, 0xC2, 0xF0, 0x67, 0x30, 0x48, 0x0C, 0x2F, 0x06, 0x73, 0x04,
  0x80, 0xC2, 0xF0, 0x67, 0x30,
  // "Ś" (U+015A)
  0x77, 0x73, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x60, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x50, 0x3F,
  0xF0, 0x47, 0x77, 0x60, 0xCF, 0xE0, 0x57, 0x77, 0x60, 0x6F, 0xE0, 0x57, 0x77, 0x60, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x70, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x70, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x70,
  0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x71, 0x0C, 0xFB, 0x0D, 0x02, 0x77, 0x77, 0x10, 0x7F, 0xB0,
  0xD0, 0x17, 0x77, 0x71, 0x03, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x10, 0x10, 0xDF, 0xA0, 0xA7, 0x77,
  0x73, 0x0A, 0xFA, 0x08, 0x77, 0x77, 0x40, 0xEF, 0x0E, 0x05, 0x80, 0xBE, 0x30, 0x84, 0x47, 0x9B,
  0xDE, 0xB8, 0x6E, 0xDC, 0xA9, 0x74, 0x27, 0x77, 0x18, 0x11, 0x6B, 0xFF, 0xC8, 0x2E, 0xC8, 0x47,
  0x72, 0x81, 0x19, 0xEF, 0xFF, 0xC0, 0xA0, 0x47, 0x50, 0x7F, 0xFF, 0xFA, 0x81, 0xE8, 0x17, 0x01,
  0x0C, 0xFF, 0xFF, 0xD0, 0xA6, 0x02, 0x0E, 0xFF, 0xFF, 0xE0, 0x45, 0x01, 0x0E, 0xFF, 0xFF, 0xE0,
  0xD6, 0x0B, 0xFF, 0xFF, 0xF0, 0x85, 0x06, 0x80, 0xC0, 0xF0, 0x25, 0x0D, 0xFF, 0xFF, 0xF0, 0xB5,
  0x05, 0xFF, 0xB8, 0x5C, 0x99, 0x89, 0xAC, 0xFD, 0x05, 0x50, 0xAF, 0xF0, 0xD0, 0x57, 0x28, 0x23,
  0x6A, 0xEE, 0x0E, 0x60, 0xEF, 0xE0, 0xB7, 0x71, 0x05, 0x0A, 0xC0, 0x85, 0x02, 0xFE, 0x0D, 0x77,
  0x48, 0x31, 0x8E, 0xF2, 0x50, 0x4F, 0xE0, 0x67, 0x77, 0x05, 0x60, 0x5F, 0xE0, 0x17, 0x77, 0x70,
  0x6F, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x10, 0x5F, 0xD0, 0xE7, 0x77, 0x71,
  0x04, 0xFE, 0x01, 0x77, 0x77, 0x02, 0xFE, 0x06, 0x77, 0x77, 0x1F, 0xE0, 0xE0, 0x17, 0x77, 0x70,
  0xBF, 0xE0, 0xC0, 0x17, 0x77, 0x60, 0x7F, 0xF0, 0xD0, 0x37, 0x77, 0x50, 0x1F, 0xFA, 0x08, 0x01,
  0x77, 0x74, 0x09, 0xFF, 0xA0, 0xE0, 0x77, 0x77, 0x30, 0x10, 0xEF, 0xFB, 0x0E, 0x07, 0x77, 0x72,
  0x05, 0xFF, 0xD0, 0xE0, 0x67, 0x77, 0x10, 0x9F, 0xFE, 0x0D, 0x06, 0x77, 0x70, 0xBF, 0xFF, 0x0D,
  0x05, 0x77, 0x60, 0xBF, 0xFF, 0x90, 0xC0, 0x47, 0x75, 0x09, 0xFF, 0xFA, 0x0A, 0x02, 0x77, 0x40,
  0x50, 0xEF, 0xFF, 0x90, 0xE0, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xFA, 0x0C, 0x02, 0x77, 0x40, 0x70,
  0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x74, 0x01, 0x0A, 0xFF, 0xFA, 0x05, 0x77, 0x50, 0x40, 0xDF, 0xFF,
  0x90, 0x57, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0x27, 0x77, 0x06, 0x0E, 0xFF, 0xD0, 0xC7, 0x77, 0x20,
  0x70, 0xEF, 0xFC, 0x06, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xA0, 0xD7, 0x77, 0x40, 0x10, 0x9F, 0xFA,
  0x03, 0x77, 0x75, 0x04, 0x0E, 0xFF, 0x08, 0x77, 0x76, 0x02, 0x0D, 0xFE, 0x0B, 0x77, 0x77, 0x03,
  0xFE, 0x0D, 0x77, 0x77, 0x10, 0xBF, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFE, 0x77, 0x77, 0x10, 0x4F,
  0xE7, 0x77, 0x71, 0x04, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD0, 0xD0, 0x37, 0x77, 0x70, 0x9F,
  0xD8, 0x2C, 0xAD, 0x67, 0x77, 0x50, 0xEF, 0xD0, 0x80, 0xAA, 0x81, 0xE9, 0x27, 0x77, 0x10, 0x9F,
  0xE0, 0x50, 0xAD, 0x81, 0xC7, 0x27, 0x74, 0x0A, 0xFF, 0x01, 0x0A, 0xF9, 0x82, 0xD9, 0x62, 0x74,
  0x81, 0x38, 0xEF, 0xF8, 0x1A, 0x0A, 0xFE, 0x89, 0x0D, 0xB9, 0x98, 0x89, 0xAC, 0xEF, 0xFB, 0x81,
  0x30, 0xA8, 0x0C, 0x3F, 0x0A, 0x20, 0xA8, 0x0C, 0x2F, 0x0E, 0x01, 0x20, 0xA8, 0x0C, 0x2F, 0x04,
  0x30, 0xA8, 0x0C, 0x1F, 0x05, 0x40, 0xAF, 0xFF, 0xFF, 0x0E, 0x04, 0x50, 0xAF, 0xFF, 0xFE, 0x0C,
  0x02, 0x60, 0x40, 0xBF, 0xFF, 0xFB, 0x0E, 0x06, 0x73, 0x81, 0x17, 0xDF, 0xFF, 0xD0, 0xD0, 0x67,
  0x71, 0x82, 0x26, 0xAE, 0xFF, 0xD8, 0x1D, 0x83, 0x77, 0x78, 0x72, 0x46, 0x8B, 0xCD, 0xDE, 0xA8,
  0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x71,
  // "ś" (U+015B)
  0x77, 0x71, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x30, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x20, 0x3F,
  0xF0, 0x47, 0x77, 0x30, 0xCF, 0xE0, 0x57, 0x77, 0x30, 0x6F, 0xE0, 0x57, 0x77, 0x30, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x40, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x40, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x40,
  0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x50, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x50, 0x7F, 0xB0, 0xD0,
  0x17, 0x77, 0x50, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x50, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x70, 0xAF,
  0xA0, 0x87, 0x77, 0x71, 0x0E, 0xF0, 0xE0, 0x58, 0x0B, 0xC0, 0x08, 0xA0, 0x25, 0x8A, 0xCD, 0xEE,
  0xFE, 0xED, 0xCB, 0x97, 0x42, 0x77, 0x58, 0x13, 0x9D, 0xFF, 0xD8, 0x1B, 0x84, 0x76, 0x05, 0x0C,
  0xFF, 0xFC, 0x81, 0xEA, 0x57, 0x10, 0x10, 0xBF, 0xFF, 0xFA, 0x81, 0xE9, 0x24, 0x03, 0x0E, 0xFF,
  0xFF, 0xD0, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0xE0, 0x12, 0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xA3, 0x0A,
  0xFF, 0xFF, 0xF0, 0x32, 0x03, 0xFF, 0xFF, 0xF0, 0xC3, 0x09, 0xFF, 0xFF, 0xF0, 0x63, 0x0E, 0xFF,
  0x87, 0xEB, 0x98, 0x89, 0xAB, 0xCF, 0xC0, 0xE0, 0x12, 0x02, 0xFE, 0x0D, 0x04, 0x73, 0x82, 0x25,
  0x9D, 0xE0, 0x93, 0x04, 0xFE, 0x03, 0x77, 0x18, 0x12, 0x6B, 0xB0, 0x33, 0x05, 0xFD, 0x0E, 0x77,
  0x58, 0x11, 0x7A, 0x40, 0x6F, 0xE7, 0x77, 0x50, 0x6F, 0xE0, 0x57, 0x77, 0x40, 0x4F, 0xE0, 0xE0,
  0x37, 0x77, 0x30, 0x2F, 0xF9, 0x0A, 0x03, 0x77, 0x72, 0x0E, 0xFF, 0xA8, 0x1C, 0x61, 0x77, 0x60,
  0x9F, 0xFD, 0x0A, 0x04, 0x77, 0x40, 0x2F, 0xFF, 0x81, 0xE9, 0x37, 0x72, 0x08, 0xFF, 0xFA, 0x0C,
  0x06, 0x77, 0x10, 0xCF, 0xFF, 0xB8, 0x1E, 0x81, 0x75, 0x01, 0x0C, 0xFF, 0xFC, 0x81, 0xE8, 0x17,
  0x50, 0xAF, 0xFF, 0xD0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xFF, 0xD0, 0xB0, 0x17, 0x48, 0x11, 0x7E,
  0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x81, 0x18, 0xEF, 0xFF, 0xB0, 0xC7, 0x71, 0x06, 0x0D, 0xFF, 0xFA,
  0x09, 0x77, 0x20, 0x40, 0xAF, 0xFF, 0x90, 0x37, 0x73, 0x81, 0x17, 0xDF, 0xFD, 0x0B, 0x77, 0x60,
  0x40, 0xAF, 0xFC, 0x01, 0x77, 0x78, 0x11, 0x8E, 0xFF, 0x90, 0x57, 0x77, 0x30, 0x8F, 0xF0, 0x87,
  0x77, 0x40, 0x6F, 0xE0, 0xA7, 0x77, 0x50, 0xDF, 0xD8, 0x1B, 0x73, 0x77, 0x73, 0x0A, 0xFD, 0x84,
  0xCC, 0xFC, 0x61, 0x77, 0x70, 0xBF, 0xD0, 0xB0, 0xCC, 0x81, 0xC7, 0x27, 0x73, 0x03, 0xFE, 0x0A,
  0x0C, 0xF8, 0x2D, 0x96, 0x37, 0x48, 0x11, 0x7E, 0xFE, 0x08, 0x0C, 0xFD, 0x89, 0x0D, 0xCA, 0x98,
  0x88, 0x9A, 0xDF, 0xFA, 0x04, 0x0C, 0x80, 0xC1, 0xF8, 0x1E, 0x0C, 0x80, 0xC1, 0xF8, 0x19, 0x0C,
  0x80, 0xC0, 0xF8, 0x2E, 0x10, 0xC8, 0x0C, 0x0F, 0x06, 0x20, 0xCF, 0xFF, 0xFF, 0x09, 0x30, 0xCF,
  0xFF, 0xFE, 0x08, 0x40, 0xCF, 0xFF, 0xFC, 0x0D, 0x04, 0x58, 0x14, 0xAE, 0xFF, 0xFF, 0x0D, 0x06,
  0x73, 0x82, 0x48, 0xBE, 0xFF, 0xF8, 0x1C, 0x83, 0x77, 0x28, 0x72, 0x57, 0x9A, 0xCD, 0xDE, 0xB8,
  0x6E, 0xED, 0xCA, 0x86, 0x37, 0x60,
  // "Ŝ" (U+015C)
  0x77, 0x10, 0x38, 0x09, 0x17, 0x77, 0x77, 0x10, 0xDF, 0xE0, 0x87, 0x77, 0x60, 0x7F, 0xF9, 0x02,
  0x77, 0x74, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x40, 0xCF, 0xFB, 0x07, 0x77, 0x72, 0x08, 0xFF, 0xD0,
  0x37, 0x77, 0x04, 0xFF, 0xE0, 0xD7, 0x76, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB, 0x0A, 0x77, 0x50,
  0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x30, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03, 0x77, 0x10,
  0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x76, 0x03, 0xFA, 0x0E, 0x03, 0x70, 0x9F, 0xA0,
  0xC7, 0x50, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F, 0xA0, 0x97, 0x40, 0xDF, 0x90, 0xB7, 0x50,
  0x30, 0xEF, 0x90, 0x67, 0x20, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xBC, 0x60, 0x84,
  0x47, 0x9B, 0xDE, 0xB8, 0x6E, 0xDC, 0xA9, 0x74, 0x27, 0x77, 0x18, 0x11, 0x6B, 0xFF, 0xC8, 0x2E,
  0xC8, 0x47, 0x72, 0x81, 0x19, 0xEF, 0xFF, 0xC0, 0xA0, 0x47, 0x50, 0x7F, 0xFF, 0xFA, 0x81, 0xE8,
  0x17, 0x01, 0x0C, 0xFF, 0xFF, 0xD0, 0xA6, 0x02, 0x0E, 0xFF, 0xFF, 0xE0, 0x45, 0x01, 0x0E, 0xFF,
  0xFF, 0xE0, 0xD6, 0x0B, 0xFF, 0xFF, 0xF0, 0x85, 0x06, 0x80, 0xC0, 0xF0, 0x25, 0x0D, 0xFF, 0xFF,
  0xF0, 0xB5, 0x05, 0xFF, 0xB8, 0x5C, 0x99, 0x89, 0xAC, 0xFD, 0x05, 0x50, 0xAF, 0xF0, 0xD0, 0x57,
  0x28, 0x23, 0x6A, 0xEE, 0x0E, 0x60, 0xEF, 0xE0, 0xB7, 0x71, 0x05, 0x0A, 0xC0, 0x85, 0x02, 0xFE,
  0x0D, 0x77, 0x48, 0x31, 0x8E, 0xF2, 0x50, 0x4F, 0xE0, 0x67, 0x77, 0x05, 0x60, 0x5F, 0xE0, 0x17,
  0x77, 0x70, 0x6F, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x10, 0x5F, 0xD0, 0xE7,
  0x77, 0x71, 0x04, 0xFE, 0x01, 0x77, 0x77, 0x02, 0xFE, 0x06, 0x77, 0x77, 0x1F, 0xE0, 0xE0, 0x17,
  0x77, 0x70, 0xBF, 0xE0, 0xC0, 0x17, 0x77, 0x60, 0x7F, 0xF0, 0xD0, 0x37, 0x77, 0x50, 0x1F, 0xFA,
  0x08, 0x01, 0x77, 0x74, 0x09, 0xFF, 0xA0, 0xE0, 0x77, 0x77, 0x30, 0x10, 0xEF, 0xFB, 0x0E, 0x07,
  0x77, 0x72, 0x05, 0xFF, 0xD0, 0xE0, 0x67, 0x77, 0x10, 0x9F, 0xFE, 0x0D, 0x06, 0x77, 0x70, 0xBF,
  0xFF, 0x0D, 0x05, 0x77, 0x60, 0xBF, 0xFF, 0x90, 0xC0, 0x47, 0x75, 0x09, 0xFF, 0xFA, 0x0A, 0x02,
  0x77, 0x40, 0x50, 0xEF, 0xFF, 0x90, 0xE0, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xFA, 0x0C, 0x02, 0x77,
  0x40, 0x70, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x74, 0x01, 0x0A, 0xFF, 0xFA, 0x05, 0x77, 0x50, 0x40,
  0xDF, 0xFF, 0x90, 0x57, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0x27, 0x77, 0x06, 0x0E, 0xFF, 0xD0, 0xC7,
  0x77, 0x20, 0x70, 0xEF, 0xFC, 0x06, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xA0, 0xD7, 0x77, 0x40, 0x10,
  0x9F, 0xFA, 0x03, 0x77, 0x75, 0x04, 0x0E, 0xFF, 0x08, 0x77, 0x76, 0x02, 0x0D, 0xFE, 0x0B, 0x77,
  0x77, 0x03, 0xFE, 0x0D, 0x77, 0x77, 0x10, 0xBF, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFE, 0x77, 0x77,
  0x10, 0x4F, 0xE7, 0x77, 0x71, 0x04, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD0, 0xD0, 0x37, 0x77,
  0x70, 0x9F, 0xD8, 0x2C, 0xAD, 0x67, 0x77, 0x50, 0xEF, 0xD0, 0x80, 0xAA, 0x81, 0xE9, 0x27, 0x77,
  0x10, 0x9F, 0xE0, 0x50, 0xAD, 0x81, 0xC7, 0x27, 0x74, 0x0A, 0xFF, 0x01, 0x0A, 0xF9, 0x82, 0xD9,
  0x62, 0x74, 0x81, 0x38, 0xEF, 0xF8, 0x1A, 0x0A, 0xFE, 0x89, 0x0D, 0xB9, 0x98, 0x89, 0xAC, 0xEF,
  0xFB, 0x81, 0x30, 0xA8, 0x0C, 0x3F, 0x0A, 0x20, 0xA8, 0x0C, 0x2F, 0x0E, 0x01, 0x20, 0xA8, 0x0C,
  0x2F, 0x04, 0x30, 0xA8, 0x0C, 0x1F, 0x05, 0x40, 0xAF, 0xFF, 0xFF, 0x0E, 0x04, 0x50, 0xAF, 0xFF,
  0xFE, 0x0C, 0x02, 0x60, 0x40, 0xBF, 0xFF, 0xFB, 0x0E, 0x06, 0x73, 0x81, 0x17, 0xDF, 0xFF, 0xD0,
  0xD0, 0x67, 0x71, 0x82, 0x26, 0xAE, 0xFF, 0xD8, 0x1D, 0x83, 0x77, 0x78, 0x72, 0x46, 0x8B, 0xCD,
  0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x71,
  // "ŝ" (U+015D)
  0x76, 0x03, 0x80, 0x91, 0x77, 0x77, 0x50, 0xDF, 0xE0, 0x87, 0x77, 0x30, 0x7F, 0xF9, 0x02, 0x77,
  0x71, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x10, 0xCF, 0xFB, 0x07, 0x77, 0x60, 0x8F, 0xFD, 0x03, 0x77,
  0x40, 0x4F, 0xFE, 0x0D, 0x77, 0x30, 0x20, 0xEF, 0xA0, 0xE0, 0xBF, 0xB0, 0xA7, 0x72, 0x0C, 0xFB,
  0x81, 0x40, 0xBF, 0xB0, 0x77, 0x70, 0x8F, 0xB0, 0x43, 0x0B, 0xFB, 0x03, 0x75, 0x05, 0xFA, 0x0E,
  0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x30, 0x3F, 0xA0, 0xE0, 0x37, 0x09, 0xFA, 0x0C, 0x72, 0x02,
  0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09, 0x71, 0x0D, 0xF9, 0x0B, 0x75, 0x03, 0x0E, 0xF9,
  0x06, 0x60, 0x3F, 0x90, 0x77, 0x70, 0x10, 0xBF, 0x0B, 0x80, 0xBA, 0x30, 0x8A, 0x02, 0x58, 0xAC,
  0xDE, 0xEF, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x75, 0x81, 0x39, 0xDF, 0xFD, 0x81, 0xB8, 0x47, 0x60,
  0x50, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x71, 0x01, 0x0B, 0xFF, 0xFF, 0xA8, 0x1E, 0x92, 0x40, 0x30,
  0xEF, 0xFF, 0xFD, 0x07, 0x30, 0x30, 0xEF, 0xFF, 0xFE, 0x01, 0x20, 0x10, 0xEF, 0xFF, 0xFE, 0x0A,
  0x30, 0xAF, 0xFF, 0xFF, 0x03, 0x20, 0x3F, 0xFF, 0xFF, 0x0C, 0x30, 0x9F, 0xFF, 0xFF, 0x06, 0x30,
  0xEF, 0xF8, 0x7E, 0xB9, 0x88, 0x9A, 0xBC, 0xFC, 0x0E, 0x01, 0x20, 0x2F, 0xE0, 0xD0, 0x47, 0x38,
  0x22, 0x59, 0xDE, 0x09, 0x30, 0x4F, 0xE0, 0x37, 0x71, 0x81, 0x26, 0xBB, 0x03, 0x30, 0x5F, 0xD0,
  0xE7, 0x75, 0x81, 0x17, 0xA4, 0x06, 0xFE, 0x77, 0x75, 0x06, 0xFE, 0x05, 0x77, 0x74, 0x04, 0xFE,
  0x0E, 0x03, 0x77, 0x73, 0x02, 0xFF, 0x90, 0xA0, 0x37, 0x77, 0x20, 0xEF, 0xFA, 0x81, 0xC6, 0x17,
  0x76, 0x09, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x02, 0xFF, 0xF8, 0x1E, 0x93, 0x77, 0x20, 0x8F, 0xFF,
  0xA0, 0xC0, 0x67, 0x71, 0x0C, 0xFF, 0xFB, 0x81, 0xE8, 0x17, 0x50, 0x10, 0xCF, 0xFF, 0xC8, 0x1E,
  0x81, 0x75, 0x0A, 0xFF, 0xFD, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFF, 0xFD, 0x0B, 0x01, 0x74, 0x81,
  0x17, 0xEF, 0xFF, 0xC0, 0xC0, 0x17, 0x58, 0x11, 0x8E, 0xFF, 0xFB, 0x0C, 0x77, 0x10, 0x60, 0xDF,
  0xFF, 0xA0, 0x97, 0x72, 0x04, 0x0A, 0xFF, 0xF9, 0x03, 0x77, 0x38, 0x11, 0x7D, 0xFF, 0xD0, 0xB7,
  0x76, 0x04, 0x0A, 0xFF, 0xC0, 0x17, 0x77, 0x81, 0x18, 0xEF, 0xF9, 0x05, 0x77, 0x73, 0x08, 0xFF,
  0x08, 0x77, 0x74, 0x06, 0xFE, 0x0A, 0x77, 0x75, 0x0D, 0xFD, 0x81, 0xB7, 0x37, 0x77, 0x30, 0xAF,
  0xD8, 0x4C, 0xCF, 0xC6, 0x17, 0x77, 0x0B, 0xFD, 0x0B, 0x0C, 0xC8, 0x1C, 0x72, 0x77, 0x30, 0x3F,
  0xE0, 0xA0, 0xCF, 0x82, 0xD9, 0x63, 0x74, 0x81, 0x17, 0xEF, 0xE0, 0x80, 0xCF, 0xD8, 0x90, 0xDC,
  0xA9, 0x88, 0x89, 0xAD, 0xFF, 0xA0, 0x40, 0xC8, 0x0C, 0x1F, 0x81, 0xE0, 0xC8, 0x0C, 0x1F, 0x81,
  0x90, 0xC8, 0x0C, 0x0F, 0x82, 0xE1, 0x0C, 0x80, 0xC0, 0xF0, 0x62, 0x0C, 0xFF, 0xFF, 0xF0, 0x93,
  0x0C, 0xFF, 0xFF, 0xE0, 0x84, 0x0C, 0xFF, 0xFF, 0xC0, 0xD0, 0x45, 0x81, 0x4A, 0xEF, 0xFF, 0xF0,
  0xD0, 0x67, 0x38, 0x24, 0x8B, 0xEF, 0xFF, 0x81, 0xC8, 0x37, 0x72, 0x87, 0x25, 0x79, 0xAC, 0xDD,
  0xEB, 0x86, 0xEE, 0xDC, 0xA8, 0x63, 0x76,
  // "Ş" (U+015E)
  0x77, 0x18, 0x44, 0x79, 0xBD, 0xEB, 0x86, 0xED, 0xCA, 0x97, 0x42, 0x77, 0x71, 0x81, 0x16, 0xBF,
  0xFC, 0x82, 0xEC, 0x84, 0x77, 0x28, 0x11, 0x9E, 0xFF, 0xFC, 0x0A, 0x04, 0x75, 0x07, 0xFF, 0xFF,
  0xA8, 0x1E, 0x81, 0x70, 0x10, 0xCF, 0xFF, 0xFD, 0x0A, 0x60, 0x20, 0xEF, 0xFF, 0xFE, 0x04, 0x50,
  0x10, 0xEF, 0xFF, 0xFE, 0x0D, 0x60, 0xBF, 0xFF, 0xFF, 0x08, 0x50, 0x68, 0x0C, 0x0F, 0x02, 0x50,
  0xDF, 0xFF, 0xFF, 0x0B, 0x50, 0x5F, 0xFB, 0x85, 0xC9, 0x98, 0x9A, 0xCF, 0xD0, 0x55, 0x0A, 0xFF,
  0x0D, 0x05, 0x72, 0x82, 0x36, 0xAE, 0xE0, 0xE6, 0x0E, 0xFE, 0x0B, 0x77, 0x10, 0x50, 0xAC, 0x08,
  0x50, 0x2F, 0xE0, 0xD7, 0x74, 0x83, 0x18, 0xEF, 0x25, 0x04, 0xFE, 0x06, 0x77, 0x70, 0x56, 0x05,
  0xFE, 0x01, 0x77, 0x77, 0x06, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD0, 0xD7, 0x77, 0x71, 0x05,
  0xFD, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0xE0, 0x17, 0x77, 0x70, 0x2F, 0xE0, 0x67, 0x77, 0x71, 0xFE,
  0x0E, 0x01, 0x77, 0x77, 0x0B, 0xFE, 0x0C, 0x01, 0x77, 0x76, 0x07, 0xFF, 0x0D, 0x03, 0x77, 0x75,
  0x01, 0xFF, 0xA0, 0x80, 0x17, 0x77, 0x40, 0x9F, 0xFA, 0x0E, 0x07, 0x77, 0x73, 0x01, 0x0E, 0xFF,
  0xB0, 0xE0, 0x77, 0x77, 0x20, 0x5F, 0xFD, 0x0E, 0x06, 0x77, 0x71, 0x09, 0xFF, 0xE0, 0xD0, 0x67,
  0x77, 0x0B, 0xFF, 0xF0, 0xD0, 0x57, 0x76, 0x0B, 0xFF, 0xF9, 0x0C, 0x04, 0x77, 0x50, 0x9F, 0xFF,
  0xA0, 0xA0, 0x27, 0x74, 0x05, 0x0E, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x40, 0x20, 0xBF, 0xFF, 0xA0,
  0xC0, 0x27, 0x74, 0x07, 0x0E, 0xFF, 0xF9, 0x0E, 0x04, 0x77, 0x40, 0x10, 0xAF, 0xFF, 0xA0, 0x57,
  0x75, 0x04, 0x0D, 0xFF, 0xF9, 0x05, 0x77, 0x60, 0x60, 0xDF, 0xFF, 0x02, 0x77, 0x70, 0x60, 0xEF,
  0xFD, 0x0C, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xC0, 0x67, 0x77, 0x30, 0x70, 0xEF, 0xFA, 0x0D, 0x77,
  0x74, 0x01, 0x09, 0xFF, 0xA0, 0x37, 0x77, 0x50, 0x40, 0xEF, 0xF0, 0x87, 0x77, 0x60, 0x20, 0xDF,
  0xE0, 0xB7, 0x77, 0x70, 0x3F, 0xE0, 0xD7, 0x77, 0x71, 0x0B, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F,
  0xE7, 0x77, 0x71, 0x04, 0xFE, 0x77, 0x77, 0x10, 0x4F, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFD, 0x0D,
  0x03, 0x77, 0x77, 0x09, 0xFD, 0x82, 0xCA, 0xD6, 0x77, 0x75, 0x0E, 0xFD, 0x08, 0x0A, 0xA8, 0x1E,
  0x92, 0x77, 0x71, 0x09, 0xFE, 0x05, 0x0A, 0xD8, 0x1C, 0x72, 0x77, 0x40, 0xAF, 0xF0, 0x10, 0xAF,
  0x98, 0x2D, 0x96, 0x27, 0x48, 0x13, 0x8E, 0xFF, 0x81, 0xA0, 0xAF, 0xE8, 0x90, 0xDB, 0x99, 0x88,
  0x9A, 0xCE, 0xFF, 0xB8, 0x13, 0x0A, 0x80, 0xC3, 0xF0, 0xA2, 0x0A, 0x80, 0xC2, 0xF0, 0xE0, 0x12,
  0x0A, 0x80, 0xC2, 0xF0, 0x43, 0x0A, 0x80, 0xC1, 0xF0, 0x54, 0x0A, 0xFF, 0xFF, 0xF0, 0xE0, 0x45,
  0x0A, 0xFF, 0xFF, 0xE0, 0xC0, 0x26, 0x04, 0x0B, 0xFF, 0xFF, 0xB0, 0xE0, 0x67, 0x38, 0x11, 0x7D,
  0xFF, 0xFD, 0x0D, 0x06, 0x77, 0x18, 0x22, 0x6A, 0xEF, 0xFD, 0x81, 0xD8, 0x37, 0x77, 0x86, 0x24,
  0x68, 0xBC, 0xDD, 0xF9, 0x81, 0x74, 0x17, 0x77, 0x74, 0x0B, 0xE0, 0x27, 0x77, 0x76, 0x02, 0xE0,
  0xB7, 0x77, 0x77, 0x09, 0xE0, 0x97, 0x77, 0x76, 0x01, 0x0E, 0xF9, 0x09, 0x02, 0x77, 0x77, 0x30,
  0x7F, 0xB0, 0xE0, 0x67, 0x77, 0x72, 0x0D, 0xFD, 0x08, 0x77, 0x77, 0x82, 0x18, 0xAD, 0xFC, 0x06,
  0x77, 0x77, 0x30, 0x20, 0x8F, 0xA0, 0xE7, 0x77, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x77, 0x50, 0xBF,
  0x90, 0x97, 0x77, 0x75, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0xAF, 0x90, 0xC7, 0x77, 0x74, 0x03,
  0xFA, 0x0B, 0x77, 0x72, 0x89, 0x01, 0x95, 0x21, 0x01, 0x38, 0xEF, 0xA0, 0x97, 0x77, 0x20, 0x1F,
  0xFC, 0x05, 0x77, 0x72, 0x01, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x20, 0x1F, 0xFB, 0x07, 0x77, 0x73,
  0x01, 0xFF, 0xA0, 0xB7, 0x77, 0x40, 0x1F, 0xF9, 0x0A, 0x77, 0x75, 0x01, 0xFE, 0x0C, 0x05, 0x77,
  0x77, 0x83, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xCA, 0x73, 0x77, 0x40,
  // "ş" (U+015F)
  0x75, 0x8A, 0x02, 0x58, 0xAC, 0xDE, 0xEF, 0xEE, 0xDC, 0xB9, 0x74, 0x27, 0x75, 0x81, 0x39, 0xDF,
  0xFD, 0x81, 0xB8, 0x47, 0x60, 0x50, 0xCF, 0xFF, 0xC8, 0x1E, 0xA5, 0x71, 0x01, 0x0B, 0xFF, 0xFF,
  0xA8, 0x1E, 0x92, 0x40, 0x30, 0xEF, 0xFF, 0xFD, 0x07, 0x30, 0x30, 0xEF, 0xFF, 0xFE, 0x01, 0x20,
  0x10, 0xEF, 0xFF, 0xFE, 0x0A, 0x30, 0xAF, 0xFF, 0xFF, 0x03, 0x20, 0x3F, 0xFF, 0xFF, 0x0C, 0x30,
  0x9F, 0xFF, 0xFF, 0x06, 0x30, 0xEF, 0xF8, 0x7E, 0xB9, 0x88, 0x9A, 0xBC, 0xFC, 0x0E, 0x01, 0x20,
  0x2F, 0xE0, 0xD0, 0x47, 0x38, 0x22, 0x59, 0xDE, 0x09, 0x30, 0x4F, 0xE0, 0x37, 0x71, 0x81, 0x26,
  0xBB, 0x03, 0x30, 0x5F, 0xD0, 0xE7, 0x75, 0x81, 0x17, 0xA4, 0x06, 0xFE, 0x77, 0x75, 0x06, 0xFE,
  0x05, 0x77, 0x74, 0x04, 0xFE, 0x0E, 0x03, 0x77, 0x73, 0x02, 0xFF, 0x90, 0xA0, 0x37, 0x77, 0x20,
  0xEF, 0xFA, 0x81, 0xC6, 0x17, 0x76, 0x09, 0xFF, 0xD0, 0xA0, 0x47, 0x74, 0x02, 0xFF, 0xF8, 0x1E,
  0x93, 0x77, 0x20, 0x8F, 0xFF, 0xA0, 0xC0, 0x67, 0x71, 0x0C, 0xFF, 0xFB, 0x81, 0xE8, 0x17, 0x50,
  0x10, 0xCF, 0xFF, 0xC8, 0x1E, 0x81, 0x75, 0x0A, 0xFF, 0xFD, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFF,
  0xFD, 0x0B, 0x01, 0x74, 0x81, 0x17, 0xEF, 0xFF, 0xC0, 0xC0, 0x17, 0x58, 0x11, 0x8E, 0xFF, 0xFB,
  0x0C, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xA0, 0x97, 0x72, 0x04, 0x0A, 0xFF, 0xF9, 0x03, 0x77, 0x38,
  0x11, 0x7D, 0xFF, 0xD0, 0xB7, 0x76, 0x04, 0x0A, 0xFF, 0xC0, 0x17, 0x77, 0x81, 0x18, 0xEF, 0xF9,
  0x05, 0x77, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x74, 0x06, 0xFE, 0x0A, 0x77, 0x75, 0x0D, 0xFD, 0x81,
  0xB7, 0x37, 0x77, 0x30, 0xAF, 0xD8, 0x4C, 0xCF, 0xC6, 0x17, 0x77, 0x0B, 0xFD, 0x0B, 0x0C, 0xC8,
  0x1C, 0x72, 0x77, 0x30, 0x3F, 0xE0, 0xA0, 0xCF, 0x82, 0xD9, 0x63, 0x74, 0x81, 0x17, 0xEF, 0xE0,
  0x80, 0xCF, 0xD8, 0x90, 0xDC, 0xA9, 0x88, 0x89, 0xAD, 0xFF, 0xA0, 0x40, 0xC8, 0x0C, 0x1F, 0x81,
  0xE0, 0xC8, 0x0C, 0x1F, 0x81, 0x90, 0xC8, 0x0C, 0x0F, 0x82, 0xE1, 0x0C, 0x80, 0xC0, 0xF0, 0x62,
  0x0C, 0xFF, 0xFF, 0xF0, 0x93, 0x0C, 0xFF, 0xFF, 0xE0, 0x84, 0x0C, 0xFF, 0xFF, 0xC0, 0xD0, 0x45,
  0x81, 0x4A, 0xEF, 0xFF, 0xF0, 0xD0, 0x67, 0x38, 0x24, 0x8B, 0xEF, 0xFF, 0x81, 0xC8, 0x37, 0x72,
  0x87, 0x25, 0x79, 0xAC, 0xDD, 0xEF, 0x98, 0x18, 0x63, 0x77, 0x77, 0x10, 0xBE, 0x02, 0x77, 0x77,
  0x30, 0x2E, 0x0B, 0x77, 0x77, 0x40, 0x9E, 0x09, 0x77, 0x77, 0x30, 0x10, 0xEF, 0x90, 0x90, 0x27,
  0x77, 0x70, 0x7F, 0xB0, 0xE0, 0x67, 0x77, 0x60, 0xDF, 0xD0, 0x87, 0x77, 0x48, 0x21, 0x8A, 0xDF,
  0xC0, 0x67, 0x77, 0x70, 0x20, 0x8F, 0xA0, 0xE7, 0x77, 0x72, 0x04, 0xFA, 0x05, 0x77, 0x77, 0x20,
  0xBF, 0x90, 0x97, 0x77, 0x72, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x20, 0xAF, 0x90, 0xC7, 0x77, 0x71,
  0x03, 0xFA, 0x0B, 0x77, 0x68, 0x90, 0x19, 0x52, 0x10, 0x13, 0x8E, 0xFA, 0x09, 0x77, 0x60, 0x1F,
  0xFC, 0x05, 0x77, 0x60, 0x1F, 0xFB, 0x0E, 0x01, 0x77, 0x60, 0x1F, 0xFB, 0x07, 0x77, 0x70, 0x1F,
  0xFA, 0x0B, 0x77, 0x71, 0x01, 0xFF, 0x90, 0xA7, 0x77, 0x20, 0x1F, 0xE0, 0xC0, 0x57, 0x77, 0x48,
  0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x72,
  // "Š" (U+0160)
  0x50, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x72, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x73, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x74, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x75, 0x02, 0x0E, 0xFA, 0x05, 0x60, 0x8F,
  0xB0, 0x37, 0x70, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x20, 0x8F, 0xB0, 0x62, 0x09, 0xFB,
  0x09, 0x77, 0x40, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x75, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27,
  0x76, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x10, 0x8F, 0xFC, 0x08, 0x77, 0x73, 0x0C, 0xFF, 0xA0, 0xC7,
  0x77, 0x40, 0x2F, 0xFA, 0x02, 0x77, 0x75, 0x07, 0xFF, 0x07, 0x77, 0x77, 0x0D, 0xFD, 0x0D, 0x80,
  0xBE, 0x00, 0x84, 0x47, 0x9B, 0xDE, 0xB8, 0x6E, 0xDC, 0xA9, 0x74, 0x27, 0x77, 0x18, 0x11, 0x6B,
  0xFF, 0xC8, 0x2E, 0xC8, 0x47, 0x72, 0x81, 0x19, 0xEF, 0xFF, 0xC0, 0xA0, 0x47, 0x50, 0x7F, 0xFF,
  0xFA, 0x81, 0xE8, 0x17, 0x01, 0x0C, 0xFF, 0xFF, 0xD0, 0xA6, 0x02, 0x0E, 0xFF, 0xFF, 0xE0, 0x45,
  0x01, 0x0E, 0xFF, 0xFF, 0xE0, 0xD6, 0x0B, 0xFF, 0xFF, 0xF0, 0x85, 0x06, 0x80, 0xC0, 0xF0, 0x25,
  0x0D, 0xFF, 0xFF, 0xF0, 0xB5, 0x05, 0xFF, 0xB8, 0x5C, 0x99, 0x89, 0xAC, 0xFD, 0x05, 0x50, 0xAF,
  0xF0, 0xD0, 0x57, 0x28, 0x23, 0x6A, 0xEE, 0x0E, 0x60, 0xEF, 0xE0, 0xB7, 0x71, 0x05, 0x0A, 0xC0,
  0x85, 0x02, 0xFE, 0x0D, 0x77, 0x48, 0x31, 0x8E, 0xF2, 0x50, 0x4F, 0xE0, 0x67, 0x77, 0x05, 0x60,
  0x5F, 0xE0, 0x17, 0x77, 0x70, 0x6F, 0xD0, 0xE7, 0x77, 0x71, 0x06, 0xFD, 0x0D, 0x77, 0x77, 0x10,
  0x5F, 0xD0, 0xE7, 0x77, 0x71, 0x04, 0xFE, 0x01, 0x77, 0x77, 0x02, 0xFE, 0x06, 0x77, 0x77, 0x1F,
  0xE0, 0xE0, 0x17, 0x77, 0x70, 0xBF, 0xE0, 0xC0, 0x17, 0x77, 0x60, 0x7F, 0xF0, 0xD0, 0x37, 0x77,
  0x50, 0x1F, 0xFA, 0x08, 0x01, 0x77, 0x74, 0x09, 0xFF, 0xA0, 0xE0, 0x77, 0x77, 0x30, 0x10, 0xEF,
  0xFB, 0x0E, 0x07, 0x77, 0x72, 0x05, 0xFF, 0xD0, 0xE0, 0x67, 0x77, 0x10, 0x9F, 0xFE, 0x0D, 0x06,
  0x77, 0x70, 0xBF, 0xFF, 0x0D, 0x05, 0x77, 0x60, 0xBF, 0xFF, 0x90, 0xC0, 0x47, 0x75, 0x09, 0xFF,
  0xFA, 0x0A, 0x02, 0x77, 0x40, 0x50, 0xEF, 0xFF, 0x90, 0xE0, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xFA,
  0x0C, 0x02, 0x77, 0x40, 0x70, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x74, 0x01, 0x0A, 0xFF, 0xFA, 0x05,
  0x77, 0x50, 0x40, 0xDF, 0xFF, 0x90, 0x57, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0x27, 0x77, 0x06, 0x0E,
  0xFF, 0xD0, 0xC7, 0x77, 0x20, 0x70, 0xEF, 0xFC, 0x06, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xA0, 0xD7,
  0x77, 0x40, 0x10, 0x9F, 0xFA, 0x03, 0x77, 0x75, 0x04, 0x0E, 0xFF, 0x08, 0x77, 0x76, 0x02, 0x0D,
  0xFE, 0x0B, 0x77, 0x77, 0x03, 0xFE, 0x0D, 0x77, 0x77, 0x10, 0xBF, 0xD0, 0xE7, 0x77, 0x71, 0x06,
  0xFE, 0x77, 0x77, 0x10, 0x4F, 0xE7, 0x77, 0x71, 0x04, 0xFD, 0x0E, 0x77, 0x77, 0x10, 0x6F, 0xD0,
  0xD0, 0x37, 0x77, 0x70, 0x9F, 0xD8, 0x2C, 0xAD, 0x67, 0x77, 0x50, 0xEF, 0xD0, 0x80, 0xAA, 0x81,
  0xE9, 0x27, 0x77, 0x10, 0x9F, 0xE0, 0x50, 0xAD, 0x81, 0xC7, 0x27, 0x74, 0x0A, 0xFF, 0x01, 0x0A,
  0xF9, 0x82, 0xD9, 0x62, 0x74, 0x81, 0x38, 0xEF, 0xF8, 0x1A, 0x0A, 0xFE, 0x89, 0x0D, 0xB9, 0x98,
  0x89, 0xAC, 0xEF, 0xFB, 0x81, 0x30, 0xA8, 0x0C, 0x3F, 0x0A, 0x20, 0xA8, 0x0C, 0x2F, 0x0E, 0x01,
  0x20, 0xA8, 0x0C, 0x2F, 0x04, 0x30, 0xA8, 0x0C, 0x1F, 0x05, 0x40, 0xAF, 0xFF, 0xFF, 0x0E, 0x04,
  0x50, 0xAF, 0xFF, 0xFE, 0x0C, 0x02, 0x60, 0x40, 0xBF, 0xFF, 0xFB, 0x0E, 0x06, 0x73, 0x81, 0x17,
  0xDF, 0xFF, 0xD0, 0xD0, 0x67, 0x71, 0x82, 0x26, 0xAE, 0xFF, 0xD8, 0x1D, 0x83, 0x77, 0x78, 0x72,
  0x46, 0x8B, 0xCD, 0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x71,
  // "š" (U+0161)
  0x30, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x60, 0x6F, 0x90, 0xB0, 0x17, 0x50,
  0x10, 0xBF, 0x90, 0x67, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x71, 0x01, 0x0D,
  0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x72, 0x02, 0x0E, 0xFA, 0x05, 0x60, 0x8F, 0xB0,
  0x37, 0x40, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x76, 0x08, 0xFB, 0x06, 0x20, 0x9F, 0xB0, 0x97,
  0x71, 0x0B, 0xFB, 0x05, 0x08, 0xFB, 0x0C, 0x77, 0x20, 0x10, 0xEF, 0xFE, 0x0E, 0x02, 0x77, 0x30,
  0x4F, 0xFE, 0x04, 0x77, 0x50, 0x8F, 0xFC, 0x08, 0x77, 0x70, 0xCF, 0xFA, 0x0C, 0x77, 0x71, 0x02,
  0xFF, 0xA0, 0x27, 0x77, 0x20, 0x7F, 0xF0, 0x77, 0x77, 0x40, 0xDF, 0xD0, 0xD8, 0x0B, 0xB5, 0x08,
  0xA0, 0x25, 0x8A, 0xCD, 0xEE, 0xFE, 0xED, 0xCB, 0x97, 0x42, 0x77, 0x58, 0x13, 0x9D, 0xFF, 0xD8,
  0x1B, 0x84, 0x76, 0x05, 0x0C, 0xFF, 0xFC, 0x81, 0xEA, 0x57, 0x10, 0x10, 0xBF, 0xFF, 0xFA, 0x81,
  0xE9, 0x24, 0x03, 0x0E, 0xFF, 0xFF, 0xD0, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0xE0, 0x12, 0x01, 0x0E,
  0xFF, 0xFF, 0xE0, 0xA3, 0x0A, 0xFF, 0xFF, 0xF0, 0x32, 0x03, 0xFF, 0xFF, 0xF0, 0xC3, 0x09, 0xFF,
  0xFF, 0xF0, 0x63, 0x0E, 0xFF, 0x87, 0xEB, 0x98, 0x89, 0xAB, 0xCF, 0xC0, 0xE0, 0x12, 0x02, 0xFE,
  0x0D, 0x04, 0x73, 0x82, 0x25, 0x9D, 0xE0, 0x93, 0x04, 0xFE, 0x03, 0x77, 0x18, 0x12, 0x6B, 0xB0,
  0x33, 0x05, 0xFD, 0x0E, 0x77, 0x58, 0x11, 0x7A, 0x40, 0x6F, 0xE7, 0x77, 0x50, 0x6F, 0xE0, 0x57,
  0x77, 0x40, 0x4F, 0xE0, 0xE0, 0x37, 0x77, 0x30, 0x2F, 0xF9, 0x0A, 0x03, 0x77, 0x72, 0x0E, 0xFF,
  0xA8, 0x1C, 0x61, 0x77, 0x60, 0x9F, 0xFD, 0x0A, 0x04, 0x77, 0x40, 0x2F, 0xFF, 0x81, 0xE9, 0x37,
  0x72, 0x08, 0xFF, 0xFA, 0x0C, 0x06, 0x77, 0x10, 0xCF, 0xFF, 0xB8, 0x1E, 0x81, 0x75, 0x01, 0x0C,
  0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x50, 0xAF, 0xFF, 0xD0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xFF, 0xD0,
  0xB0, 0x17, 0x48, 0x11, 0x7E, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x81, 0x18, 0xEF, 0xFF, 0xB0, 0xC7,
  0x71, 0x06, 0x0D, 0xFF, 0xFA, 0x09, 0x77, 0x20, 0x40, 0xAF, 0xFF, 0x90, 0x37, 0x73, 0x81, 0x17,
  0xDF, 0xFD, 0x0B, 0x77, 0x60, 0x40, 0xAF, 0xFC, 0x01, 0x77, 0x78, 0x11, 0x8E, 0xFF, 0x90, 0x57,
  0x77, 0x30, 0x8F, 0xF0, 0x87, 0x77, 0x40, 0x6F, 0xE0, 0xA7, 0x77, 0x50, 0xDF, 0xD8, 0x1B, 0x73,
  0x77, 0x73, 0x0A, 0xFD, 0x84, 0xCC, 0xFC, 0x61, 0x77, 0x70, 0xBF, 0xD0, 0xB0, 0xCC, 0x81, 0xC7,
  0x27, 0x73, 0x03, 0xFE, 0x0A, 0x0C, 0xF8, 0x2D, 0x96, 0x37, 0x48, 0x11, 0x7E, 0xFE, 0x08, 0x0C,
  0xFD, 0x89, 0x0D, 0xCA, 0x98, 0x88, 0x9A, 0xDF, 0xFA, 0x04, 0x0C, 0x80, 0xC1, 0xF8, 0x1E, 0x0C,
  0x80, 0xC1, 0xF8, 0x19, 0x0C, 0x80, 0xC0, 0xF8, 0x2E, 0x10, 0xC8, 0x0C, 0x0F, 0x06, 0x20, 0xCF,
  0xFF, 0xFF, 0x09, 0x30, 0xCF, 0xFF, 0xFE, 0x08, 0x40, 0xCF, 0xFF, 0xFC, 0x0D, 0x04, 0x58, 0x14,
  0xAE, 0xFF, 0xFF, 0x0D, 0x06, 0x73, 0x82, 0x48, 0xBE, 0xFF, 0xF8, 0x1C, 0x83, 0x77, 0x28, 0x72,
  0x57, 0x9A, 0xCD, 0xDE, 0xB8, 0x6E, 0xED, 0xCA, 0x86, 0x37, 0x60,
  // "Ţ" (U+0162)
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x47, 0x74, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80,
  0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78,
  0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80,
  0xC3, 0x00, 0x4E, 0x07, 0x80, 0xC6, 0x00, 0xBE, 0x02, 0x80, 0xC5, 0x00, 0x2E, 0x0B, 0x80, 0xC6,
  0x00, 0x9E, 0x09, 0x80, 0xC5, 0x00, 0x10, 0xEF, 0x90, 0x90, 0x28, 0x0C, 0x20, 0x07, 0xFB, 0x0E,
  0x06, 0x80, 0xC1, 0x00, 0xDF, 0xD0, 0x87, 0x77, 0x77, 0x82, 0x18, 0xAD, 0xFC, 0x06, 0x80, 0xC2,
  0x00, 0x20, 0x8F, 0xA0, 0xE8, 0x0C, 0x40, 0x04, 0xFA, 0x05, 0x80, 0xC4, 0x00, 0xBF, 0x90, 0x98,
  0x0C, 0x40, 0x08, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0xAF, 0x90, 0xC8, 0x0C, 0x30, 0x03, 0xFA, 0x0B,
  0x77, 0x77, 0x28, 0x90, 0x19, 0x52, 0x10, 0x13, 0x8E, 0xFA, 0x09, 0x77, 0x77, 0x20, 0x1F, 0xFC,
  0x05, 0x77, 0x77, 0x20, 0x1F, 0xFB, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x1F, 0xFB, 0x07, 0x77, 0x77,
  0x30, 0x1F, 0xFA, 0x0B, 0x77, 0x77, 0x40, 0x1F, 0xF9, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0xE0, 0xC0,
  0x57, 0x77, 0x77, 0x83, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xCA, 0x73, 0x77, 0x70,
  // "ţ" (U+0163)
  0x77, 0x10, 0xEF, 0xA0, 0x17, 0x77, 0x74, 0x01, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x4F, 0xB0, 0x17,
  0x77, 0x74, 0x07, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x9F, 0xB0, 0x17, 0x77, 0x74, 0x0C, 0xFB, 0x01,
  0x77, 0x77, 0x4F, 0xC0, 0x17, 0x77, 0x73, 0x02, 0xFC, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xC0, 0x17,
  0x77, 0x73, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0x17, 0x77, 0x73, 0x0D, 0xFC, 0x01,
  0x77, 0x76, 0x82, 0x36, 0x9D, 0xFF, 0xFF, 0xA0, 0x84, 0x82, 0x15, 0x8B, 0xFF, 0xFF, 0xF8, 0x38,
  0x17, 0xAE, 0x80, 0xC3, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38,
  0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0,
  0x80, 0x38, 0x0C, 0x6F, 0x08, 0x01, 0x80, 0x78, 0xFE, 0x80, 0x96, 0x80, 0x47, 0x5F, 0xE0, 0x17,
  0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F,
  0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77,
  0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE,
  0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77,
  0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0,
  0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77,
  0x20, 0xEF, 0xD0, 0x37, 0x77, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x77, 0x20, 0xCF, 0xD0, 0xC7, 0x77,
  0x72, 0x0A, 0xFE, 0x05, 0x77, 0x77, 0x10, 0x7F, 0xE0, 0xE0, 0x37, 0x77, 0x70, 0x4F, 0xF9, 0x08,
  0x02, 0x72, 0x83, 0x14, 0x79, 0xC7, 0x60, 0xEF, 0xFA, 0x87, 0xEA, 0x98, 0x89, 0xAC, 0xED, 0x76,
  0x0A, 0xFF, 0xFF, 0xA7, 0x60, 0x3F, 0xFF, 0xFA, 0x77, 0x0B, 0xFF, 0xFF, 0x97, 0x70, 0x20, 0xEF,
  0xFF, 0xF7, 0x71, 0x05, 0xFF, 0xFF, 0x77, 0x20, 0x6F, 0xFF, 0xE7, 0x73, 0x04, 0x0E, 0xFF, 0xFC,
  0x77, 0x40, 0x10, 0x8F, 0xFF, 0xB7, 0x76, 0x81, 0x17, 0xCF, 0xFC, 0x81, 0xC8, 0x37, 0x77, 0x28,
  0x11, 0x5C, 0xF8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x77, 0x10, 0xBE, 0x02, 0x77, 0x77, 0x70, 0x2E,
  0x0B, 0x80, 0xC0, 0x00, 0x9E, 0x09, 0x77, 0x77, 0x70, 0x10, 0xEF, 0x90, 0x90, 0x27, 0x77, 0x74,
  0x07, 0xFB, 0x0E, 0x06, 0x77, 0x77, 0x30, 0xDF, 0xD0, 0x87, 0x77, 0x71, 0x82, 0x18, 0xAD, 0xFC,
  0x06, 0x77, 0x77, 0x40, 0x20, 0x8F, 0xA0, 0xE7, 0x77, 0x76, 0x04, 0xFA, 0x05, 0x77, 0x77, 0x60,
  0xBF, 0x90, 0x97, 0x77, 0x76, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x60, 0xAF, 0x90, 0xC7, 0x77, 0x75,
  0x03, 0xFA, 0x0B, 0x77, 0x73, 0x89, 0x01, 0x95, 0x21, 0x01, 0x38, 0xEF, 0xA0, 0x97, 0x77, 0x30,
  0x1F, 0xFC, 0x05, 0x77, 0x73, 0x01, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x30, 0x1F, 0xFB, 0x07, 0x77,
  0x74, 0x01, 0xFF, 0xA0, 0xB7, 0x77, 0x50, 0x1F, 0xF9, 0x0A, 0x77, 0x76, 0x01, 0xFE, 0x0C, 0x05,
  0x77, 0x77, 0x18, 0x35, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x40,
  // "Ť" (U+0164)
  0x71, 0x03, 0x80, 0x37, 0x06, 0x77, 0x20, 0x68, 0x03, 0x70, 0x37, 0x72, 0x06, 0xF9, 0x0B, 0x01,
  0x75, 0x01, 0x0B, 0xF9, 0x06, 0x77, 0x30, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7,
  0x74, 0x01, 0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x77, 0x50, 0x20, 0xEF, 0xA0,
  0x56, 0x08, 0xFB, 0x03, 0x77, 0x70, 0x4F, 0xB0, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x72, 0x08, 0xFB,
  0x06, 0x20, 0x9F, 0xB0, 0x97, 0x77, 0x40, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x77, 0x50, 0x10,
  0xEF, 0xFE, 0x0E, 0x02, 0x77, 0x76, 0x04, 0xFF, 0xE0, 0x47, 0x77, 0x71, 0x08, 0xFF, 0xC0, 0x87,
  0x77, 0x73, 0x0C, 0xFF, 0xA0, 0xC7, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0x27, 0x77, 0x75, 0x07, 0xFF,
  0x07, 0x77, 0x77, 0x70, 0xDF, 0xD0, 0xD8, 0x0C, 0xF2, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D,
  0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D,
  0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x00, 0x48, 0x0D,
  0x4F, 0x00, 0x48, 0x0D, 0x4F, 0x04, 0x77, 0x40, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80,
  0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78,
  0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x77, 0x74,
  // "ť" (U+0165)
  0x77, 0x77, 0x70, 0x7F, 0xC0, 0x87, 0x77, 0x77, 0x09, 0xFC, 0x04, 0x77, 0x77, 0x70, 0xCF, 0xB0,
  0xC8, 0x0C, 0x00, 0x0E, 0xFB, 0x05, 0x77, 0x77, 0x70, 0x2F, 0xB0, 0xC8, 0x0C, 0x00, 0x05, 0xFB,
  0x05, 0x80, 0xC0, 0x00, 0x8F, 0xA0, 0xC7, 0x74, 0x02, 0x80, 0x53, 0x72, 0x0C, 0xFA, 0x04, 0x77,
  0x40, 0xEF, 0xA0, 0x17, 0x1F, 0xA0, 0xB7, 0x74, 0x02, 0xFB, 0x01, 0x70, 0x3F, 0xA0, 0x27, 0x74,
  0x04, 0xFB, 0x01, 0x70, 0x7F, 0x90, 0x97, 0x75, 0x07, 0xFB, 0x01, 0x70, 0xBF, 0x0E, 0x01, 0x77,
  0x50, 0xAF, 0xB0, 0x17, 0x0E, 0xF0, 0x57, 0x76, 0x0D, 0xFB, 0x01, 0x60, 0x1F, 0x0A, 0x77, 0x7F,
  0xC0, 0x17, 0x77, 0x77, 0x03, 0xFC, 0x01, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0x17, 0x77, 0x77, 0x08,
  0xFC, 0x01, 0x77, 0x77, 0x70, 0xBF, 0xC0, 0x17, 0x77, 0x77, 0x0D, 0xFC, 0x01, 0x77, 0x77, 0x38,
  0x23, 0x6A, 0xDF, 0xFF, 0xFA, 0x08, 0x71, 0x82, 0x25, 0x8C, 0xFF, 0xFF, 0xF0, 0x84, 0x82, 0x17,
  0xAE, 0x80, 0xC3, 0xF0, 0x84, 0x03, 0x80, 0xC6, 0xF0, 0x84, 0x03, 0x80, 0xC6, 0xF0, 0x84, 0x03,
  0x80, 0xC6, 0xF0, 0x84, 0x03, 0x80, 0xC6, 0xF0, 0x84, 0x03, 0x80, 0xC6, 0xF0, 0x84, 0x03, 0x80,
  0xC6, 0xF0, 0x84, 0x03, 0x80, 0xC6, 0xF0, 0x84, 0x01, 0x80, 0x78, 0xFE, 0x80, 0x96, 0x80, 0x47,
  0x72, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0,
  0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77,
  0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01,
  0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76,
  0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17,
  0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x77, 0x6F,
  0xE0, 0x17, 0x77, 0x76, 0x0E, 0xFD, 0x03, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x77, 0x77, 0x76, 0x0C,
  0xFD, 0x0C, 0x77, 0x77, 0x60, 0xAF, 0xE0, 0x57, 0x77, 0x75, 0x07, 0xFE, 0x0E, 0x03, 0x77, 0x77,
  0x40, 0x4F, 0xF9, 0x08, 0x02, 0x72, 0x83, 0x14, 0x79, 0xC7, 0x73, 0x0E, 0xFF, 0xA8, 0x7E, 0xA9,
  0x88, 0x9A, 0xCE, 0xD7, 0x73, 0x0A, 0xFF, 0xFF, 0xA7, 0x73, 0x03, 0xFF, 0xFF, 0xA7, 0x74, 0x0B,
  0xFF, 0xFF, 0x97, 0x74, 0x02, 0x0E, 0xFF, 0xFF, 0x77, 0x50, 0x5F, 0xFF, 0xF7, 0x76, 0x06, 0xFF,
  0xFE, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0xC7, 0x77, 0x10, 0x10, 0x8F, 0xFF, 0xB7, 0x77, 0x38, 0x11,
  0x7C, 0xFF, 0xC8, 0x1C, 0x83, 0x77, 0x76, 0x85, 0x15, 0x8A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC, 0xA8,
  0x63, 0x71,
  // "Ŧ" (U+0166)
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0,
  0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x04, 0x80, 0xD4, 0xF0, 0x47, 0x74, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x77, 0x77, 0x40, 0x9F, 0xFF, 0xFE, 0x09, 0x77, 0x09, 0xFF, 0xFF, 0xE0, 0x97,
  0x70, 0x9F, 0xFF, 0xFE, 0x09, 0x77, 0x09, 0xFF, 0xFF, 0xE0, 0x97, 0x70, 0x9F, 0xFF, 0xFE, 0x09,
  0x77, 0x09, 0xFF, 0xFF, 0xE0, 0x97, 0x70, 0x9F, 0xFF, 0xFE, 0x09, 0x77, 0x09, 0xFF, 0xFF, 0xE0,
  0x97, 0x70, 0x9F, 0xFF, 0xFE, 0x09, 0x77, 0x09, 0xFF, 0xFF, 0xE0, 0x97, 0x70, 0x58, 0x06, 0x80,
  0xCF, 0xD0, 0xB8, 0x06, 0x80, 0x57, 0x77, 0x40, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07,
  0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0,
  0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD,
  0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F,
  0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08,
  0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00,
  0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00,
  0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0,
  0x00, 0x8F, 0xD0, 0x78, 0x0C, 0x00, 0x08, 0xFD, 0x07, 0x80, 0xC0, 0x00, 0x8F, 0xD0, 0x78, 0x0C,
  0x00, 0x08, 0xFD, 0x07, 0x77, 0x40,
  // "ŧ" (U+0167)
  0x77, 0x10, 0xEF, 0xA0, 0x17, 0x77, 0x74, 0x01, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x4F, 0xB0, 0x17,
  0x77, 0x74, 0x07, 0xFB, 0x01, 0x77, 0x77, 0x40, 0x9F, 0xB0, 0x17, 0x77, 0x74, 0x0C, 0xFB, 0x01,
  0x77, 0x77, 0x4F, 0xC0, 0x17, 0x77, 0x73, 0x02, 0xFC, 0x01, 0x77, 0x77, 0x30, 0x5F, 0xC0, 0x17,
  0x77, 0x73, 0x08, 0xFC, 0x01, 0x77, 0x77, 0x30, 0xBF, 0xC0, 0x17, 0x77, 0x73, 0x0D, 0xFC, 0x01,
  0x77, 0x76, 0x82, 0x36, 0x9D, 0xFF, 0xFF, 0xA0, 0x84, 0x82, 0x15, 0x8B, 0xFF, 0xFF, 0xF8, 0x38,
  0x17, 0xAE, 0x80, 0xC3, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38,
  0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0, 0x80, 0x38, 0x0C, 0x6F, 0x08, 0x03, 0x80, 0xC6, 0xF0,
  0x80, 0x38, 0x0C, 0x6F, 0x08, 0x01, 0x80, 0x78, 0xFE, 0x80, 0x96, 0x80, 0x47, 0x5F, 0xE0, 0x17,
  0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F,
  0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77,
  0x40, 0x38, 0x0C, 0x7F, 0x03, 0x80, 0xC7, 0xF0, 0x38, 0x0C, 0x7F, 0x03, 0x80, 0xC7, 0xF0, 0x38,
  0x0C, 0x7F, 0x03, 0x80, 0xC7, 0xF0, 0x38, 0x0C, 0x7F, 0x03, 0x80, 0xC7, 0xF7, 0x5F, 0xE0, 0x17,
  0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F, 0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x2F,
  0xE0, 0x17, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x77, 0x20, 0xEF, 0xD0, 0x37, 0x77, 0x72, 0x0E, 0xFD,
  0x07, 0x77, 0x77, 0x20, 0xCF, 0xD0, 0xC7, 0x77, 0x72, 0x0A, 0xFE, 0x05, 0x77, 0x77, 0x10, 0x8F,
  0xE0, 0xE0, 0x37, 0x77, 0x70, 0x4F, 0xF9, 0x08, 0x02, 0x72, 0x83, 0x14, 0x79, 0xC7, 0x6F, 0xFB,
  0x87, 0xEA, 0x98, 0x89, 0xAC, 0xED, 0x76, 0x0A, 0xFF, 0xFF, 0xA7, 0x60, 0x4F, 0xFF, 0xFA, 0x77,
  0x0C, 0xFF, 0xFF, 0x97, 0x70, 0x3F, 0xFF, 0xF9, 0x77, 0x10, 0x6F, 0xFF, 0xF7, 0x72, 0x07, 0xFF,
  0xFE, 0x77, 0x30, 0x50, 0xEF, 0xFF, 0xC7, 0x74, 0x01, 0x09, 0xFF, 0xFB, 0x77, 0x68, 0x11, 0x7C,
  0xFF, 0xC8, 0x1C, 0x83, 0x77, 0x72, 0x85, 0x15, 0x8A, 0xCE, 0xEA, 0x86, 0xEE, 0xDC, 0xA8, 0x63,
  0x40,
  // "Ũ" (U+0168)
  0x75, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x20, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x10, 0x4F, 0xE0, 0xC0, 0x67, 0x05, 0xE0, 0xC7, 0x70, 0x10, 0xEF, 0xF9,
  0x82, 0xEA, 0x52, 0x20, 0x50, 0xEE, 0x0A, 0x77, 0x0A, 0xFF, 0xFF, 0xA0, 0x67, 0x60, 0x3F, 0xFF,
  0xFB, 0x02, 0x76, 0x0A, 0xFF, 0xFF, 0xA0, 0xC7, 0x7F, 0xFF, 0xFB, 0x05, 0x76, 0x05, 0xFF, 0xFF,
  0xA0, 0xC7, 0x70, 0x8E, 0x85, 0xE5, 0x10, 0x26, 0xBF, 0xFA, 0x0E, 0x02, 0x77, 0x0C, 0xE0, 0x46,
  0x81, 0x18, 0xEF, 0xD0, 0xE0, 0x37, 0x71, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27,
  0x72, 0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xCB, 0x40, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F, 0xD0, 0x0E, 0xFD, 0x03, 0x77, 0x40, 0x3F, 0xD0,
  0xE0, 0xDF, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x0D, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xC0,
  0xAF, 0xD0, 0xA7, 0x74, 0x0A, 0xFD, 0x0A, 0x08, 0xFD, 0x0E, 0x77, 0x40, 0xEF, 0xD0, 0x80, 0x5F,
  0xE0, 0x37, 0x72, 0x03, 0xFE, 0x05, 0x02, 0xFE, 0x0A, 0x77, 0x20, 0xAF, 0xE8, 0x11, 0x0E, 0xFE,
  0x04, 0x77, 0x03, 0xFE, 0x0D, 0x20, 0x9F, 0xE0, 0xE0, 0x37, 0x50, 0x20, 0xEF, 0xE0, 0x82, 0x04,
  0xFF, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xFF, 0x02, 0x30, 0xDF, 0xF9, 0x82, 0xD8, 0x31, 0x28, 0x21,
  0x37, 0xCF, 0xF9, 0x0B, 0x40, 0x68, 0x0C, 0x4F, 0x03, 0x50, 0xD8, 0x0C, 0x2F, 0x0A, 0x60, 0x38,
  0x0C, 0x1F, 0x0E, 0x01, 0x70, 0x78, 0x0C, 0x0F, 0x05, 0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x77, 0x40,
  0xAF, 0xFF, 0xFC, 0x07, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x04, 0x0D, 0xFF, 0xFD, 0x0C,
  0x02, 0x77, 0x40, 0x60, 0xDF, 0xFF, 0x90, 0xC0, 0x57, 0x77, 0x18, 0x14, 0xAE, 0xFF, 0xA8, 0x1D,
  0x93, 0x77, 0x76, 0x85, 0x36, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x27, 0x71,
  // "ũ" (U+0169)
  0x75, 0x87, 0x5A, 0xDE, 0xED, 0xA6, 0x17, 0x50, 0x8E, 0x77, 0x10, 0x30, 0xDF, 0xA0, 0xA0, 0x47,
  0x30, 0xDD, 0x0E, 0x77, 0x04, 0xFE, 0x0C, 0x06, 0x70, 0x5E, 0x0C, 0x76, 0x01, 0x0E, 0xFF, 0x98,
  0x2E, 0xA5, 0x22, 0x05, 0x0E, 0xE0, 0xA7, 0x60, 0xAF, 0xFF, 0xFA, 0x06, 0x75, 0x03, 0xFF, 0xFF,
  0xB0, 0x27, 0x50, 0xAF, 0xFF, 0xFA, 0x0C, 0x76, 0xFF, 0xFF, 0xB0, 0x57, 0x50, 0x5F, 0xFF, 0xFA,
  0x0C, 0x76, 0x08, 0xE8, 0x5E, 0x51, 0x02, 0x6B, 0xFF, 0xA0, 0xE0, 0x27, 0x60, 0xCE, 0x04, 0x68,
  0x11, 0x8E, 0xFD, 0x0E, 0x03, 0x77, 0x0E, 0xD0, 0xC7, 0x30, 0x50, 0xBF, 0xA0, 0xC0, 0x27, 0x71,
  0xE0, 0x77, 0x58, 0x72, 0x6A, 0xDE, 0xFD, 0xA4, 0x80, 0xCA, 0x50, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x1F,
  0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F, 0xE0, 0x7F, 0xD0, 0xA7, 0x73, 0x0C,
  0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7, 0x72, 0x05, 0xFF, 0x06, 0xFE, 0x04,
  0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x02, 0xFF, 0x02, 0x75, 0x02, 0x0E,
  0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02, 0x0D, 0xFF, 0xA1, 0x0B, 0xFF, 0x0D, 0x05, 0x70, 0x10,
  0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0xFE, 0x10, 0x18, 0x0C, 0x7F, 0x20,
  0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F, 0x30, 0x9F, 0xFF, 0xE8, 0x1D, 0x0D, 0xFC, 0x40, 0xCF,
  0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01, 0x0D, 0xFF, 0xFA, 0x0E, 0x03, 0x20, 0x1F, 0xC5, 0x01,
  0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB, 0x70, 0x8F, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB7, 0x18,
  0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72, 0xFB, 0x74, 0x83, 0x48, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51,
  0x77, 0x70,
  // "Ū" (U+016A)
  0x72, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0,
  0xA7, 0x74, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x40, 0x9F, 0xFF, 0xD0, 0xA7, 0x74, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xD8, 0x70, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F,
  0xD0, 0x0E, 0xFD, 0x03, 0x77, 0x40, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x0D,
  0x0C, 0xFD, 0x07, 0x77, 0x40, 0x7F, 0xD0, 0xC0, 0xAF, 0xD0, 0xA7, 0x74, 0x0A, 0xFD, 0x0A, 0x08,
  0xFD, 0x0E, 0x77, 0x40, 0xEF, 0xD0, 0x80, 0x5F, 0xE0, 0x37, 0x72, 0x03, 0xFE, 0x05, 0x02, 0xFE,
  0x0A, 0x77, 0x20, 0xAF, 0xE8, 0x11, 0x0E, 0xFE, 0x04, 0x77, 0x03, 0xFE, 0x0D, 0x20, 0x9F, 0xE0,
  0xE0, 0x37, 0x50, 0x20, 0xEF, 0xE0, 0x82, 0x04, 0xFF, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xFF, 0x02,
  0x30, 0xDF, 0xF9, 0x82, 0xD8, 0x31, 0x28, 0x21, 0x37, 0xCF, 0xF9, 0x0B, 0x40, 0x68, 0x0C, 0x4F,
  0x03, 0x50, 0xD8, 0x0C, 0x2F, 0x0A, 0x60, 0x38, 0x0C, 0x1F, 0x0E, 0x01, 0x70, 0x78, 0x0C, 0x0F,
  0x05, 0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x77, 0x40, 0xAF, 0xFF, 0xFC, 0x07, 0x76, 0x08, 0xFF, 0xFF,
  0xA0, 0x67, 0x71, 0x04, 0x0D, 0xFF, 0xFD, 0x0C, 0x02, 0x77, 0x40, 0x60, 0xDF, 0xFF, 0x90, 0xC0,
  0x57, 0x77, 0x18, 0x14, 0xAE, 0xFF, 0xA8, 0x1D, 0x93, 0x77, 0x76, 0x85, 0x36, 0x9B, 0xDE, 0xEA,
  0x85, 0xEE, 0xCA, 0x85, 0x27, 0x71,
  // "ū" (U+016B)
  0x72, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A,
  0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0,
  0xA7, 0x73, 0x09, 0xFF, 0xFD, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0xD0, 0xA7, 0x73, 0x09, 0xFF, 0xFD,
  0x0A, 0x80, 0xCF, 0x70, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0,
  0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09,
  0x77, 0x30, 0x9F, 0xE0, 0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F,
  0xF0, 0x7F, 0xE7, 0x72, 0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7,
  0x70, 0x5F, 0xF9, 0x02, 0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02,
  0x0D, 0xFF, 0xA1, 0x0B, 0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB,
  0x98, 0x9A, 0xDF, 0xFE, 0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F,
  0x30, 0x9F, 0xFF, 0xE8, 0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01,
  0x0D, 0xFF, 0xFA, 0x0E, 0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB,
  0x70, 0x8F, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72, 0xFB,
  0x74, 0x83, 0x48, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x70,
  // "Ŭ" (U+016C)
  0x71, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x10, 0xBE, 0x0C, 0x77, 0x04,
  0xF0, 0x47, 0x71, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x10, 0x8F, 0x0A, 0x75, 0x02, 0x0E,
  0xF7, 0x72, 0x04, 0xF9, 0x09, 0x73, 0x03, 0x0D, 0xF0, 0xB7, 0x73, 0xFA, 0x82, 0xE9, 0x41, 0x28,
  0x21, 0x36, 0xBF, 0xA0, 0x77, 0x73, 0x0A, 0xFF, 0xFE, 0x02, 0x77, 0x30, 0x3F, 0xFF, 0xD0, 0x97,
  0x75, 0x0A, 0xFF, 0xFB, 0x0E, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xFF, 0xA0, 0x47, 0x77, 0x03, 0x0E,
  0xFF, 0xF0, 0x67, 0x77, 0x20, 0x30, 0xDF, 0xFD, 0x06, 0x77, 0x74, 0x01, 0x0B, 0xFF, 0xA0, 0xD0,
  0x37, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x74, 0x89, 0x22, 0x6A, 0xCD, 0xEF, 0xDC,
  0xA6, 0x28, 0x0C, 0xC1, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x27, 0x74, 0x02,
  0xFD, 0x00, 0xEF, 0xD0, 0x37, 0x74, 0x03, 0xFD, 0x0E, 0x0D, 0xFD, 0x05, 0x77, 0x40, 0x5F, 0xD0,
  0xD0, 0xCF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0C, 0x0A, 0xFD, 0x0A, 0x77, 0x40, 0xAF, 0xD0, 0xA0,
  0x8F, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x05, 0xFE, 0x03, 0x77, 0x20, 0x3F, 0xE0, 0x50, 0x2F,
  0xE0, 0xA7, 0x72, 0x0A, 0xFE, 0x81, 0x10, 0xEF, 0xE0, 0x47, 0x70, 0x3F, 0xE0, 0xD2, 0x09, 0xFE,
  0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFE, 0x08, 0x20, 0x4F, 0xF0, 0xE0, 0x67, 0x30, 0x50, 0xEF, 0xF0,
  0x23, 0x0D, 0xFF, 0x98, 0x2D, 0x83, 0x12, 0x82, 0x13, 0x7C, 0xFF, 0x90, 0xB4, 0x06, 0x80, 0xC4,
  0xF0, 0x35, 0x0D, 0x80, 0xC2, 0xF0, 0xA6, 0x03, 0x80, 0xC1, 0xF0, 0xE0, 0x17, 0x07, 0x80, 0xC0,
  0xF0, 0x57, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0x77, 0x60, 0x8F, 0xFF,
  0xFA, 0x06, 0x77, 0x10, 0x40, 0xDF, 0xFF, 0xD0, 0xC0, 0x27, 0x74, 0x06, 0x0D, 0xFF, 0xF9, 0x0C,
  0x05, 0x77, 0x71, 0x81, 0x4A, 0xEF, 0xFA, 0x81, 0xD9, 0x37, 0x77, 0x68, 0x53, 0x69, 0xBD, 0xEE,
  0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77, 0x10,
  // "ŭ" (U+016D)
  0x71, 0x06, 0x80, 0x27, 0x05, 0x77, 0x01, 0x80, 0x37, 0x02, 0x77, 0x0B, 0xE0, 0xC7, 0x70, 0x4F,
  0x04, 0x77, 0x0A, 0xF0, 0x17, 0x60, 0x9F, 0x02, 0x77, 0x08, 0xF0, 0xA7, 0x50, 0x20, 0xEF, 0x77,
  0x10, 0x4F, 0x90, 0x97, 0x30, 0x30, 0xDF, 0x0B, 0x77, 0x2F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x13,
  0x6B, 0xFA, 0x07, 0x77, 0x20, 0xAF, 0xFF, 0xE0, 0x27, 0x72, 0x03, 0xFF, 0xFD, 0x09, 0x77, 0x40,
  0xAF, 0xFF, 0xB0, 0xE0, 0x17, 0x74, 0x01, 0x0D, 0xFF, 0xFA, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xFF,
  0x06, 0x77, 0x71, 0x03, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x30, 0x10, 0xBF, 0xFA, 0x0D, 0x03, 0x77,
  0x76, 0x04, 0x0B, 0xFD, 0x0D, 0x05, 0x77, 0x77, 0x38, 0x92, 0x26, 0xAC, 0xDE, 0xFD, 0xCA, 0x62,
  0x80, 0xCB, 0x20, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0,
  0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77,
  0x30, 0x9F, 0xE0, 0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0,
  0x7F, 0xE7, 0x72, 0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7, 0x70,
  0x5F, 0xF9, 0x02, 0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02, 0x0D,
  0xFF, 0xA1, 0x0B, 0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB, 0x98,
  0x9A, 0xDF, 0xFE, 0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F, 0x30,
  0x9F, 0xFF, 0xE8, 0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01, 0x0D,
  0xFF, 0xFA, 0x0E, 0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB, 0x70,
  0x8F, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x72, 0xFB, 0x74,
  0x83, 0x48, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x70,
  // "Ů" (U+016E)
  0x77, 0x48, 0x90, 0x48, 0xCD, 0xFE, 0xDA, 0x61, 0x77, 0x77, 0x60, 0x30, 0xCF, 0xB0, 0x90, 0x17,
  0x77, 0x73, 0x07, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x10, 0x6F, 0xF9, 0x0E, 0x02, 0x77, 0x76, 0x03,
  0xFF, 0xB0, 0xD0, 0x17, 0x77, 0x50, 0xBF, 0xFC, 0x08, 0x77, 0x74, 0x02, 0xF0, 0xB0, 0x32, 0x05,
  0x0D, 0xF7, 0x77, 0x40, 0x6E, 0x0A, 0x50, 0x10, 0xDE, 0x04, 0x77, 0x73, 0x09, 0xE0, 0x16, 0x05,
  0xE0, 0x87, 0x77, 0x30, 0xBD, 0x0C, 0x71, 0xE0, 0x97, 0x77, 0x30, 0xCD, 0x0A, 0x71, 0xE0, 0xA7,
  0x77, 0x30, 0xBD, 0x0C, 0x71, 0xE0, 0x97, 0x77, 0x30, 0x9E, 0x01, 0x60, 0x5E, 0x07, 0x77, 0x73,
  0x06, 0xE0, 0x85, 0x01, 0x0D, 0xE0, 0x47, 0x77, 0x30, 0x2F, 0x09, 0x03, 0x20, 0x40, 0xDE, 0x0E,
  0x77, 0x75, 0x0A, 0xFF, 0xC0, 0x77, 0x77, 0x50, 0x2F, 0xFB, 0x0D, 0x77, 0x77, 0x06, 0xFF, 0x90,
  0xE0, 0x27, 0x77, 0x71, 0x06, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x30, 0x30, 0xCF, 0xB0, 0x90, 0x17,
  0x77, 0x76, 0x89, 0x03, 0x8C, 0xDF, 0xED, 0xB6, 0x18, 0x0C, 0xC2, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x27, 0x74, 0x02, 0xFD, 0x00, 0xEF, 0xD0, 0x37, 0x74, 0x03, 0xFD, 0x0E,
  0x0D, 0xFD, 0x05, 0x77, 0x40, 0x5F, 0xD0, 0xD0, 0xCF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0C, 0x0A,
  0xFD, 0x0A, 0x77, 0x40, 0xAF, 0xD0, 0xA0, 0x8F, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x05, 0xFE,
  0x03, 0x77, 0x20, 0x3F, 0xE0, 0x50, 0x2F, 0xE0, 0xA7, 0x72, 0x0A, 0xFE, 0x81, 0x10, 0xEF, 0xE0,
  0x47, 0x70, 0x3F, 0xE0, 0xD2, 0x09, 0xFE, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFE, 0x08, 0x20, 0x4F,
  0xF0, 0xE0, 0x67, 0x30, 0x50, 0xEF, 0xF0, 0x23, 0x0D, 0xFF, 0x98, 0x2D, 0x83, 0x12, 0x82, 0x13,
  0x7C, 0xFF, 0x90, 0xB4, 0x06, 0x80, 0xC4, 0xF0, 0x35, 0x0D, 0x80, 0xC2, 0xF0, 0xA6, 0x03, 0x80,
  0xC1, 0xF0, 0xE0, 0x17, 0x07, 0x80, 0xC0, 0xF0, 0x57, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x74, 0x0A,
  0xFF, 0xFF, 0xC0, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x40, 0xDF, 0xFF, 0xD0, 0xC0,
  0x27, 0x74, 0x06, 0x0D, 0xFF, 0xF9, 0x0C, 0x05, 0x77, 0x71, 0x81, 0x4A, 0xEF, 0xFA, 0x81, 0xD9,
  0x37, 0x77, 0x68, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77, 0x10,
  // "ů" (U+016F)
  0x77, 0x48, 0x90, 0x48, 0xCD, 0xFE, 0xDA, 0x61, 0x77, 0x77, 0x50, 0x30, 0xCF, 0xB0, 0x90, 0x17,
  0x77, 0x72, 0x07, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x06, 0xFF, 0x90, 0xE0, 0x27, 0x77, 0x50, 0x3F,
  0xFB, 0x0D, 0x01, 0x77, 0x74, 0x0B, 0xFF, 0xC0, 0x87, 0x77, 0x30, 0x2F, 0x0B, 0x03, 0x20, 0x50,
  0xDF, 0x77, 0x73, 0x06, 0xE0, 0xA5, 0x01, 0x0D, 0xE0, 0x47, 0x77, 0x20, 0x9E, 0x01, 0x60, 0x5E,
  0x08, 0x77, 0x72, 0x0B, 0xD0, 0xC7, 0x1E, 0x09, 0x77, 0x72, 0x0C, 0xD0, 0xA7, 0x1E, 0x0A, 0x77,
  0x72, 0x0B, 0xD0, 0xC7, 0x1E, 0x09, 0x77, 0x72, 0x09, 0xE0, 0x16, 0x05, 0xE0, 0x77, 0x77, 0x20,
  0x6E, 0x08, 0x50, 0x10, 0xDE, 0x04, 0x77, 0x72, 0x02, 0xF0, 0x90, 0x32, 0x04, 0x0D, 0xE0, 0xE7,
  0x77, 0x40, 0xAF, 0xFC, 0x07, 0x77, 0x74, 0x02, 0xFF, 0xB0, 0xD7, 0x77, 0x60, 0x6F, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x06, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x20, 0x30, 0xCF, 0xB0, 0x90, 0x17, 0x77,
  0x75, 0x89, 0x03, 0x8C, 0xDF, 0xED, 0xB6, 0x18, 0x0C, 0xB3, 0x00, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x01, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x30, 0x2F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x04, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x30, 0x6F, 0xE0, 0x7F, 0xD0, 0x97, 0x73, 0x09, 0xFE, 0x07, 0xFD, 0x0A, 0x77, 0x30, 0xCF,
  0xE0, 0x7F, 0xD0, 0xD7, 0x72, 0x01, 0xFF, 0x07, 0xFE, 0x77, 0x20, 0x5F, 0xF0, 0x6F, 0xE0, 0x47,
  0x71, 0x0C, 0xFF, 0x04, 0xFE, 0x0A, 0x77, 0x05, 0xFF, 0x90, 0x2F, 0xF0, 0x27, 0x50, 0x20, 0xEF,
  0xF9, 0x1F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x10, 0xBF, 0xF0, 0xD0, 0x57, 0x01, 0x08,
  0xFF, 0xC1, 0x07, 0xFF, 0xA8, 0x5E, 0xB9, 0x89, 0xAD, 0xFF, 0xE1, 0x01, 0x80, 0xC7, 0xF2, 0x0A,
  0x80, 0xC6, 0xF2, 0x03, 0x80, 0xC6, 0xF3, 0x09, 0xFF, 0xFE, 0x81, 0xD0, 0xDF, 0xC4, 0x0C, 0xFF,
  0xFC, 0x82, 0xE2, 0x07, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xA0, 0xE0, 0x32, 0x01, 0xFC, 0x50, 0x10,
  0xCF, 0xFF, 0x0B, 0x01, 0x40, 0xBF, 0xB7, 0x08, 0xFF, 0xC0, 0xE0, 0x66, 0x06, 0xFB, 0x71, 0x81,
  0x29, 0xEF, 0xE0, 0xC0, 0x67, 0x2F, 0xB7, 0x48, 0x34, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x77,
  // "Ű" (U+0170)
  0x77, 0x04, 0xFD, 0x30, 0x2F, 0xD0, 0x27, 0x72, 0x0C, 0xFC, 0x0A, 0x30, 0xAF, 0xC0, 0xB7, 0x72,
  0x05, 0xFC, 0x0D, 0x01, 0x20, 0x3F, 0xC0, 0xE0, 0x17, 0x72, 0x0D, 0xFB, 0x0E, 0x02, 0x30, 0xCF,
  0xC0, 0x47, 0x72, 0x07, 0xFC, 0x04, 0x30, 0x6F, 0xC0, 0x57, 0x72, 0x02, 0xFC, 0x05, 0x30, 0x10,
  0xEF, 0xB0, 0x67, 0x73, 0x0B, 0xFB, 0x05, 0x40, 0x9F, 0xB0, 0x67, 0x73, 0x05, 0xFB, 0x05, 0x40,
  0x3F, 0xB0, 0x67, 0x74, 0x0D, 0xF9, 0x0E, 0x04, 0x50, 0xCF, 0xA0, 0x57, 0x74, 0x08, 0xF9, 0x0E,
  0x03, 0x50, 0x7F, 0xA0, 0x47, 0x74, 0x03, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0xEF, 0x0E, 0x03, 0x77,
  0x50, 0xCF, 0x0B, 0x01, 0x60, 0xAF, 0x0D, 0x02, 0x77, 0x50, 0x6F, 0x09, 0x70, 0x4F, 0x0B, 0x01,
  0x77, 0x60, 0xAE, 0x06, 0x71, 0x08, 0xE0, 0x98, 0x0C, 0xB7, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF,
  0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17,
  0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01,
  0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00,
  0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0,
  0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74,
  0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD, 0x00, 0xEF, 0xD0, 0x17, 0x74, 0x01, 0xFD,
  0x00, 0xEF, 0xD0, 0x27, 0x74, 0x02, 0xFD, 0x00, 0xEF, 0xD0, 0x37, 0x74, 0x03, 0xFD, 0x0E, 0x0D,
  0xFD, 0x05, 0x77, 0x40, 0x5F, 0xD0, 0xD0, 0xCF, 0xD0, 0x77, 0x74, 0x07, 0xFD, 0x0C, 0x0A, 0xFD,
  0x0A, 0x77, 0x40, 0xAF, 0xD0, 0xA0, 0x8F, 0xD0, 0xE7, 0x74, 0x0E, 0xFD, 0x08, 0x05, 0xFE, 0x03,
  0x77, 0x20, 0x3F, 0xE0, 0x50, 0x2F, 0xE0, 0xA7, 0x72, 0x0A, 0xFE, 0x81, 0x10, 0xEF, 0xE0, 0x47,
  0x70, 0x3F, 0xE0, 0xD2, 0x09, 0xFE, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFE, 0x08, 0x20, 0x4F, 0xF0,
  0xE0, 0x67, 0x30, 0x50, 0xEF, 0xF0, 0x23, 0x0D, 0xFF, 0x98, 0x2D, 0x83, 0x12, 0x82, 0x13, 0x7C,
  0xFF, 0x90, 0xB4, 0x06, 0x80, 0xC4, 0xF0, 0x35, 0x0D, 0x80, 0xC2, 0xF0, 0xA6, 0x03, 0x80, 0xC1,
  0xF0, 0xE0, 0x17, 0x07, 0x80, 0xC0, 0xF0, 0x57, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x74, 0x0A, 0xFF,
  0xFF, 0xC0, 0x77, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x40, 0xDF, 0xFF, 0xD0, 0xC0, 0x27,
  0x74, 0x06, 0x0D, 0xFF, 0xF9, 0x0C, 0x05, 0x77, 0x71, 0x81, 0x4A, 0xEF, 0xFA, 0x81, 0xD9, 0x37,
  0x77, 0x68, 0x53, 0x69, 0xBD, 0xEE, 0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77, 0x10,
  // "ű" (U+0171)
  0x77, 0x04, 0xFD, 0x30, 0x2F, 0xD0, 0x27, 0x71, 0x0C, 0xFC, 0x0A, 0x30, 0xAF, 0xC0, 0xB7, 0x71,
  0x05, 0xFC, 0x0D, 0x01, 0x20, 0x3F, 0xC0, 0xE0, 0x17, 0x71, 0x0D, 0xFB, 0x0E, 0x02, 0x30, 0xCF,
  0xC0, 0x47, 0x71, 0x07, 0xFC, 0x04, 0x30, 0x6F, 0xC0, 0x57, 0x71, 0x02, 0xFC, 0x05, 0x30, 0x10,
  0xEF, 0xB0, 0x67, 0x72, 0x0B, 0xFB, 0x05, 0x40, 0x9F, 0xB0, 0x67, 0x72, 0x05, 0xFB, 0x05, 0x40,
  0x3F, 0xB0, 0x67, 0x73, 0x0D, 0xF9, 0x0E, 0x04, 0x50, 0xCF, 0xA0, 0x57, 0x73, 0x08, 0xF9, 0x0E,
  0x03, 0x50, 0x7F, 0xA0, 0x47, 0x73, 0x03, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0xEF, 0x0E, 0x03, 0x77,
  0x40, 0xCF, 0x0B, 0x01, 0x60, 0xAF, 0x0D, 0x02, 0x77, 0x40, 0x6F, 0x09, 0x70, 0x4F, 0x0B, 0x01,
  0x77, 0x50, 0xAE, 0x06, 0x71, 0x08, 0xE0, 0x98, 0x0C, 0xB0, 0x00, 0x7F, 0xD0, 0x87, 0x74, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x01, 0xFE,
  0x07, 0xFD, 0x08, 0x77, 0x30, 0x2F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x04, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x30, 0x6F, 0xE0, 0x7F, 0xD0, 0x97, 0x73, 0x09, 0xFE, 0x07, 0xFD, 0x0A, 0x77, 0x30, 0xCF,
  0xE0, 0x7F, 0xD0, 0xD7, 0x72, 0x01, 0xFF, 0x07, 0xFE, 0x77, 0x20, 0x5F, 0xF0, 0x6F, 0xE0, 0x47,
  0x71, 0x0C, 0xFF, 0x04, 0xFE, 0x0A, 0x77, 0x05, 0xFF, 0x90, 0x2F, 0xF0, 0x27, 0x50, 0x20, 0xEF,
  0xF9, 0x1F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x10, 0xBF, 0xF0, 0xD0, 0x57, 0x01, 0x08,
  0xFF, 0xC1, 0x07, 0xFF, 0xA8, 0x5E, 0xB9, 0x89, 0xAD, 0xFF, 0xE1, 0x01, 0x80, 0xC7, 0xF2, 0x0A,
  0x80, 0xC6, 0xF2, 0x03, 0x80, 0xC6, 0xF3, 0x09, 0xFF, 0xFE, 0x81, 0xD0, 0xDF, 0xC4, 0x0C, 0xFF,
  0xFC, 0x82, 0xE2, 0x07, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xA0, 0xE0, 0x32, 0x01, 0xFC, 0x50, 0x10,
  0xCF, 0xFF, 0x0B, 0x01, 0x40, 0xBF, 0xB7, 0x08, 0xFF, 0xC0, 0xE0, 0x66, 0x06, 0xFB, 0x71, 0x81,
  0x29, 0xEF, 0xE0, 0xC0, 0x67, 0x2F, 0xB7, 0x48, 0x34, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x77,
  // "Ų" (U+0172)
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01,
  0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40,
  0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0,
  0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD,
  0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F,
  0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E,
  0xFD, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x02, 0x77, 0x40, 0x2F, 0xD0, 0x0E, 0xFD, 0x03,
  0x77, 0x40, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x47, 0x74, 0x04, 0xFD, 0x0D, 0x0C, 0xFD, 0x06, 0x77,
  0x40, 0x6F, 0xD0, 0xC0, 0xBF, 0xD0, 0x97, 0x74, 0x09, 0xFD, 0x0A, 0x09, 0xFD, 0x0C, 0x77, 0x40,
  0xCF, 0xD0, 0x80, 0x6F, 0xE0, 0x17, 0x72, 0x01, 0xFE, 0x06, 0x03, 0xFE, 0x07, 0x77, 0x20, 0x7F,
  0xE8, 0x13, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x10, 0xEF, 0xD0, 0xE2, 0x0B, 0xFE, 0x0A, 0x77, 0x0A,
  0xFE, 0x09, 0x20, 0x5F, 0xF0, 0xA7, 0x50, 0x9F, 0xF0, 0x43, 0x0E, 0xFF, 0x81, 0xD6, 0x17, 0x05,
  0x0D, 0xFF, 0x0D, 0x40, 0x8F, 0xFB, 0x84, 0xCA, 0x88, 0xAB, 0xFF, 0xB0, 0x64, 0x01, 0x0E, 0x80,
  0xC2, 0xF0, 0xD6, 0x06, 0x80, 0xC2, 0xF0, 0x47, 0x0B, 0x80, 0xC0, 0xF0, 0x97, 0x10, 0x10, 0xDF,
  0xFF, 0xFE, 0x0B, 0x73, 0x02, 0x0D, 0xFF, 0xFF, 0xC0, 0xC0, 0x17, 0x40, 0x20, 0xDF, 0xFF, 0xFA,
  0x0A, 0x77, 0x10, 0x9F, 0xFF, 0xF0, 0x77, 0x73, 0x03, 0x0B, 0xFF, 0xFB, 0x0A, 0x02, 0x77, 0x68,
  0x13, 0x9E, 0xFF, 0xD0, 0xD0, 0x47, 0x77, 0x48, 0x43, 0x69, 0xBD, 0xEF, 0xD0, 0x87, 0x77, 0x75,
  0x03, 0x0E, 0xF9, 0x0D, 0x03, 0x77, 0x77, 0x50, 0x4F, 0xA0, 0xB7, 0x77, 0x76, 0x04, 0xFA, 0x08,
  0x77, 0x77, 0x60, 0x20, 0xEF, 0x90, 0x77, 0x77, 0x77, 0x0B, 0xF9, 0x08, 0x77, 0x77, 0x70, 0x4F,
  0x90, 0xC8, 0x0C, 0x00, 0x0B, 0xF9, 0x03, 0x77, 0x77, 0x70, 0x1F, 0x90, 0xC8, 0x0C, 0x00, 0x06,
  0xF9, 0x08, 0x80, 0xC0, 0x00, 0x9F, 0x90, 0x78, 0x0C, 0x00, 0x0A, 0xF9, 0x09, 0x80, 0xC0, 0x00,
  0xBF, 0x90, 0xE0, 0x27, 0x77, 0x77, 0x09, 0xFA, 0x86, 0xD5, 0x10, 0x14, 0x92, 0x77, 0x77, 0x07,
  0xFF, 0xA0, 0x27, 0x77, 0x70, 0x3F, 0xFA, 0x02, 0x77, 0x77, 0x10, 0xDF, 0xF9, 0x02, 0x77, 0x77,
  0x10, 0x5F, 0xF9, 0x02, 0x77, 0x77, 0x20, 0x9F, 0xF0, 0x27, 0x77, 0x73, 0x09, 0xFE, 0x02, 0x77,
  0x77, 0x40, 0x50, 0xDF, 0xC0, 0x27, 0x77, 0x76, 0x89, 0x14, 0x8C, 0xDE, 0xFE, 0xCA, 0x62, 0x77,
  // "ų" (U+0173)
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F, 0xE0,
  0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7, 0x72,
  0x05, 0xFF, 0x06, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x4F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x02,
  0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x91, 0xFF, 0x0D, 0x01, 0x73, 0x02, 0x0D, 0xFF, 0xA1, 0x0B,
  0xFF, 0x0D, 0x05, 0x70, 0x10, 0x8F, 0xFC, 0x10, 0x7F, 0xFA, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0xFE,
  0x10, 0x18, 0x0C, 0x7F, 0x20, 0xA8, 0x0C, 0x6F, 0x20, 0x38, 0x0C, 0x6F, 0x30, 0x9F, 0xFF, 0xE8,
  0x1D, 0x0D, 0xFC, 0x40, 0xCF, 0xFF, 0xC8, 0x2E, 0x20, 0x7F, 0xC4, 0x01, 0x0D, 0xFF, 0xFA, 0x0E,
  0x03, 0x20, 0x1F, 0xC5, 0x01, 0x0C, 0xFF, 0xF0, 0xB0, 0x14, 0x0B, 0xFB, 0x70, 0x8F, 0xFC, 0x0E,
  0x06, 0x60, 0x6F, 0xB7, 0x18, 0x12, 0x9E, 0xFE, 0x0C, 0x06, 0x71, 0x02, 0xFB, 0x74, 0x83, 0x48,
  0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x72, 0x03, 0x0E, 0xE0, 0xE0, 0x27, 0x77, 0x76, 0x03, 0x0E,
  0xE0, 0xE0, 0x37, 0x77, 0x76, 0x03, 0x0E, 0xF0, 0x47, 0x77, 0x76, 0x01, 0x0D, 0xF0, 0x77, 0x77,
  0x77, 0x0A, 0xF0, 0xC7, 0x77, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x70, 0xCF, 0x0C, 0x77, 0x77,
  0x70, 0x3F, 0x90, 0x77, 0x77, 0x77, 0x08, 0xF9, 0x04, 0x77, 0x77, 0x70, 0xBF, 0x90, 0x47, 0x77,
  0x77, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x90, 0xC7, 0x77, 0x77, 0x0C, 0xFA, 0x0B, 0x03,
  0x28, 0x12, 0x59, 0x77, 0x77, 0x0A, 0xFF, 0xA7, 0x77, 0x70, 0x6F, 0xFA, 0x77, 0x77, 0x01, 0xFF,
  0xA7, 0x77, 0x71, 0x09, 0xFF, 0x97, 0x77, 0x72, 0x0C, 0xFF, 0x77, 0x77, 0x20, 0x10, 0xCF, 0xE7,
  0x77, 0x74, 0x08, 0x0E, 0xFC, 0x77, 0x77, 0x58, 0x31, 0x6A, 0xDE, 0xA8, 0x3E, 0xC9, 0x61,
  // "Ŵ" (U+0174)
  0x77, 0x50, 0x38, 0x09, 0x17, 0x80, 0xC2, 0x00, 0xDF, 0xE0, 0x88, 0x0C, 0x00, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x76, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x76, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x74, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x72, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x0E, 0x0B,
  0xFB, 0x0A, 0x77, 0x77, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xB0, 0x43,
  0x0B, 0xFB, 0x03, 0x77, 0x73, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x77, 0x10,
  0x3F, 0xA0, 0xE0, 0x37, 0x09, 0xFA, 0x0C, 0x77, 0x70, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20, 0x6F,
  0xA0, 0x97, 0x76, 0x0D, 0xF9, 0x0B, 0x75, 0x03, 0x0E, 0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x77,
  0x70, 0x10, 0xBF, 0x0B, 0x80, 0xCF, 0x50, 0xFC, 0x04, 0x77, 0x77, 0x04, 0xFF, 0xF9, 0x05, 0x77,
  0x77, 0x05, 0xFC, 0x0E, 0xFB, 0x07, 0x77, 0x77, 0x06, 0xFB, 0x0E, 0x0C, 0xFB, 0x09, 0x77, 0x77,
  0x07, 0xFB, 0x0D, 0x0B, 0xFB, 0x0A, 0x77, 0x77, 0x08, 0xFB, 0x0C, 0x0A, 0xFB, 0x0C, 0x77, 0x77,
  0x0A, 0xFB, 0x0A, 0x09, 0xFB, 0x0D, 0x77, 0x77, 0x0B, 0xFB, 0x09, 0x08, 0xFC, 0x77, 0x77, 0x0C,
  0xFB, 0x08, 0x07, 0xFC, 0x01, 0x77, 0x76, 0x0D, 0xFB, 0x07, 0x06, 0xFC, 0x02, 0x77, 0x76, 0x0E,
  0xFB, 0x06, 0x04, 0xFC, 0x04, 0x77, 0x76, 0xFC, 0x05, 0x03, 0xFC, 0x05, 0x77, 0x75, 0x01, 0xFC,
  0x04, 0x02, 0xFC, 0x06, 0x77, 0x75, 0x02, 0xFC, 0x03, 0x01, 0xFC, 0x08, 0x77, 0x75, 0x03, 0xFC,
  0x02, 0x1F, 0xC0, 0x97, 0x77, 0x50, 0x4F, 0xC8, 0x11, 0x0E, 0xFB, 0x0A, 0x60, 0x3F, 0xD0, 0x56,
  0x05, 0xFC, 0x20, 0xDF, 0xB0, 0xC6, 0x05, 0xFD, 0x08, 0x60, 0x6F, 0xB0, 0xE2, 0x0C, 0xFB, 0x0D,
  0x60, 0x7F, 0xD0, 0xA6, 0x08, 0xFB, 0x0D, 0x20, 0xBF, 0xB0, 0xE6, 0x0A, 0xFD, 0x0C, 0x60, 0x9F,
  0xB0, 0xC2, 0x09, 0xFC, 0x60, 0xCF, 0xE6, 0x0A, 0xFB, 0x0B, 0x20, 0x8F, 0xC0, 0x15, 0xFF, 0x01,
  0x50, 0xBF, 0xB0, 0xA2, 0x07, 0xFC, 0x02, 0x40, 0x2F, 0xF0, 0x45, 0x0C, 0xFB, 0x09, 0x20, 0x6F,
  0xC0, 0x34, 0x04, 0xFF, 0x06, 0x50, 0xDF, 0xB0, 0x72, 0x05, 0xFC, 0x04, 0x40, 0x6F, 0xF0, 0x85,
  0x0E, 0xFB, 0x06, 0x20, 0x4F, 0xC0, 0x54, 0x09, 0xFF, 0x0B, 0x5F, 0xC0, 0x52, 0x03, 0xFC, 0x06,
  0x40, 0xBF, 0xF0, 0xD4, 0x01, 0xFC, 0x04, 0x20, 0x1F, 0xC0, 0x74, 0x0D, 0xFF, 0x94, 0x02, 0xFC,
  0x03, 0x3F, 0xC0, 0x84, 0xFF, 0xA0, 0x23, 0x03, 0xFC, 0x02, 0x3F, 0xC0, 0x93, 0x03, 0xF9, 0x0E,
  0xF0, 0x53, 0x04, 0xFC, 0x01, 0x30, 0xDF, 0xB0, 0xA3, 0x05, 0xF0, 0xB0, 0x8F, 0x07, 0x30, 0x5F,
  0xC4, 0x0C, 0xFB, 0x0A, 0x30, 0x8F, 0x09, 0x06, 0xF0, 0x93, 0x06, 0xFB, 0x0E, 0x40, 0xBF, 0xB0,
  0xB3, 0x0A, 0xF0, 0x70, 0x4F, 0x0C, 0x30, 0x7F, 0xB0, 0xD4, 0x0A, 0xFB, 0x0B, 0x30, 0xCF, 0x05,
  0x02, 0xF0, 0xE3, 0x07, 0xFB, 0x0C, 0x40, 0x9F, 0xB0, 0xC3, 0xF9, 0x03, 0x1F, 0x90, 0x12, 0x08,
  0xFB, 0x0B, 0x40, 0x8F, 0xB0, 0xC2, 0x02, 0xF9, 0x81, 0x10, 0xEF, 0x03, 0x20, 0x8F, 0xB0, 0xA4,
  0x07, 0xFB, 0x0C, 0x20, 0x4F, 0x92, 0x0C, 0xF0, 0x52, 0x08, 0xFB, 0x09, 0x40, 0x5F, 0xB0, 0xC2,
  0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0x82, 0x08, 0xFB, 0x08, 0x40, 0x4F, 0xB0, 0xC2, 0x08, 0xF0, 0xA2,
  0x08, 0xF0, 0xA2, 0x09, 0xFB, 0x07, 0x40, 0x3F, 0xB0, 0xC2, 0x0B, 0xF0, 0x82, 0x05, 0xF0, 0xD2,
  0x08, 0xFB, 0x05, 0x40, 0x2F, 0xB0, 0xD2, 0x0D, 0xF0, 0x62, 0x03, 0xF9, 0x20, 0x8F, 0xB0, 0x44,
  0x01, 0xFB, 0x0D, 0x2F, 0x90, 0x32, 0x01, 0xF9, 0x81, 0x20, 0x8F, 0xB0, 0x35, 0xFB, 0x81, 0xD0,
  0x2F, 0x90, 0x13, 0xF9, 0x81, 0x50, 0x8F, 0xB0, 0x25, 0x0E, 0xFA, 0x81, 0xD0, 0x4F, 0x0E, 0x40,
  0xCF, 0x81, 0x80, 0x7F, 0xB0, 0x15, 0x0D, 0xFA, 0x81, 0xD0, 0x6F, 0x0B, 0x40, 0xAF, 0x81, 0xA0,
  0x7F, 0xB6, 0x0C, 0xFA, 0x81, 0xD0, 0x8F, 0x09, 0x40, 0x8F, 0x81, 0xD0, 0x7F, 0xA0, 0xE6, 0x0B,
  0xFA, 0x81, 0xD0, 0xAF, 0x07, 0x40, 0x5F, 0x91, 0x06, 0xFA, 0x0D, 0x60, 0x9F, 0xA8, 0x1D, 0x0C,
  0xF0, 0x44, 0x03, 0xF9, 0x02, 0x06, 0xFA, 0x0C, 0x60, 0x8F, 0xA8, 0x1C, 0x0E, 0xF0, 0x24, 0x01,
  0xF9, 0x00, 0x5F, 0xA0, 0xB6, 0x07, 0xFA, 0x0C, 0x1F, 0x96, 0x0E, 0xF0, 0x70, 0x4F, 0xA0, 0xA6,
  0x06, 0xFA, 0x0C, 0x03, 0xF0, 0xD6, 0x0C, 0xF0, 0xA0, 0x4F, 0xA0, 0x96, 0x05, 0xFA, 0x0C, 0x05,
  0xF0, 0xB6, 0x09, 0xF0, 0xC0, 0x3F, 0xA0, 0x86, 0x04, 0xFA, 0x0B, 0x07, 0xF0, 0x86, 0x07, 0xF0,
  0xE0, 0x3F, 0xA0, 0x76, 0x02, 0xFA, 0x0A, 0x09, 0xF0, 0x66, 0x05, 0xF9, 0x04, 0xFA, 0x06, 0x60,
  0x1F, 0xA0, 0x0E, 0xF0, 0x46, 0x02, 0xF9, 0x0B, 0xFA, 0x05, 0x7F, 0xFC, 0x01, 0x7F, 0xFC, 0x04,
  0x70, 0xEF, 0xFA, 0x0E, 0x71, 0x0D, 0xFF, 0xB0, 0x27, 0x0D, 0xFF, 0xA0, 0xC7, 0x10, 0xBF, 0xFB,
  0x01, 0x70, 0xCF, 0xFA, 0x0A, 0x71, 0x08, 0xFF, 0xB7, 0x10, 0xBF, 0xFA, 0x07, 0x71, 0x06, 0xFF,
  0xB7, 0x10, 0xAF, 0xFA, 0x05, 0x71, 0x04, 0xFF, 0xA0, 0xE7, 0x10, 0x9F, 0xFA, 0x03, 0x71, 0x01,
  0xFF, 0xA0, 0xD7, 0x10, 0x8F, 0xFA, 0x01, 0x72, 0x0E, 0xFF, 0x90, 0xB7, 0x10, 0x6F, 0xF9, 0x0E,
  0x73, 0x0C, 0xFF, 0x90, 0xA7, 0x10, 0x5F, 0xF9, 0x0B, 0x73, 0x0A, 0xFF, 0x90, 0x94,
  // "ŵ" (U+0175)
  0x77, 0x60, 0x38, 0x09, 0x17, 0x80, 0xC4, 0x00, 0xDF, 0xE0, 0x88, 0x0C, 0x20, 0x07, 0xFF, 0x90,
  0x28, 0x0C, 0x00, 0x02, 0xFF, 0xA0, 0xC8, 0x0C, 0x00, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x76, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x74, 0x04, 0xFF, 0xE0, 0xD7, 0x77, 0x73, 0x02, 0x0E, 0xFA, 0x0E, 0x0B,
  0xFB, 0x0A, 0x77, 0x77, 0x20, 0xCF, 0xB8, 0x14, 0x0B, 0xFB, 0x07, 0x77, 0x77, 0x08, 0xFB, 0x04,
  0x30, 0xBF, 0xB0, 0x37, 0x77, 0x50, 0x5F, 0xA0, 0xE0, 0x45, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x73,
  0x03, 0xFA, 0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x77, 0x20, 0x20, 0xEF, 0x90, 0xD0, 0x27, 0x20,
  0x6F, 0xA0, 0x97, 0x77, 0x10, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x76, 0x03, 0xF9,
  0x07, 0x77, 0x01, 0x0B, 0xF0, 0xB8, 0x0D, 0x92, 0x00, 0xAF, 0xC0, 0x37, 0x77, 0x71, 0x0E, 0xFB,
  0x0B, 0x08, 0xFC, 0x04, 0x77, 0x77, 0x1F, 0xC0, 0x90, 0x5F, 0xC0, 0x57, 0x77, 0x70, 0x1F, 0xC0,
  0x70, 0x3F, 0xC0, 0x77, 0x77, 0x70, 0x2F, 0xC0, 0x40, 0x1F, 0xC0, 0x87, 0x77, 0x70, 0x4F, 0xC8,
  0x12, 0x0E, 0xFB, 0x09, 0x77, 0x77, 0x05, 0xFC, 0x20, 0xCF, 0xB0, 0xB7, 0x77, 0x70, 0x7F, 0xB0,
  0xD2, 0x0A, 0xFB, 0x0C, 0x71, 0x09, 0xFB, 0x0B, 0x71, 0x08, 0xFB, 0x0B, 0x20, 0x8F, 0xB0, 0xE7,
  0x10, 0xCF, 0xB0, 0xE7, 0x10, 0x9F, 0xB0, 0x92, 0x06, 0xFC, 0x71, 0xFD, 0x02, 0x70, 0xBF, 0xB0,
  0x72, 0x03, 0xFC, 0x01, 0x60, 0x2F, 0xD0, 0x57, 0x0C, 0xFB, 0x05, 0x20, 0x1F, 0xC0, 0x26, 0x06,
  0xFD, 0x08, 0x70, 0xEF, 0xB0, 0x23, 0x0E, 0xFB, 0x04, 0x60, 0x9F, 0xD0, 0xB7, 0xFC, 0x40, 0xCF,
  0xB0, 0x56, 0x0C, 0xFD, 0x0E, 0x60, 0x1F, 0xB0, 0xE4, 0x0A, 0xFB, 0x06, 0x6F, 0xF0, 0x25, 0x02,
  0xFB, 0x0B, 0x40, 0x8F, 0xB0, 0x85, 0x02, 0xFF, 0x05, 0x50, 0x4F, 0xB0, 0x94, 0x06, 0xFB, 0x09,
  0x50, 0x6F, 0xF0, 0x85, 0x05, 0xFB, 0x07, 0x40, 0x4F, 0xB0, 0xB5, 0x09, 0xFF, 0x0B, 0x50, 0x6F,
  0xB0, 0x54, 0x01, 0xFB, 0x0C, 0x50, 0xCF, 0xF0, 0xE5, 0x08, 0xFB, 0x03, 0x5F, 0xB0, 0xD5, 0xFF,
  0xA0, 0x24, 0x09, 0xFB, 0x60, 0xCF, 0xB4, 0x02, 0xFF, 0xA0, 0x54, 0x0A, 0xFA, 0x0E, 0x60, 0xAF,
  0xB0, 0x13, 0x06, 0xF0, 0x0B, 0xF0, 0x84, 0x0C, 0xFA, 0x0C, 0x60, 0x8F, 0xB0, 0x23, 0x09, 0xF0,
  0x08, 0xF0, 0xB4, 0x0D, 0xFA, 0x09, 0x60, 0x6F, 0xB0, 0x33, 0x0C, 0xF0, 0x06, 0xF0, 0xE4, 0xFB,
  0x07, 0x60, 0x4F, 0xB0, 0x53, 0xF9, 0x00, 0x4F, 0x90, 0x23, 0xFB, 0x05, 0x60, 0x1F, 0xB0, 0x62,
  0x02, 0xF9, 0x00, 0x1F, 0x90, 0x52, 0x02, 0xFB, 0x03, 0x7F, 0xB0, 0x82, 0x05, 0xF0, 0xE2, 0x0E,
  0xF0, 0x82, 0x03, 0xFB, 0x01, 0x70, 0xDF, 0xA0, 0x92, 0x08, 0xF0, 0xC2, 0x0C, 0xF0, 0xB2, 0x04,
  0xFA, 0x0E, 0x71, 0x0A, 0xFA, 0x0B, 0x20, 0xBF, 0x09, 0x20, 0x9F, 0x0E, 0x20, 0x5F, 0xA0, 0xC7,
  0x10, 0x8F, 0xA0, 0xC2, 0x0D, 0xF0, 0x72, 0x07, 0xF9, 0x81, 0x10, 0x6F, 0xA0, 0xA7, 0x10, 0x6F,
  0xA0, 0xE2, 0xF9, 0x04, 0x20, 0x4F, 0x98, 0x13, 0x08, 0xFA, 0x07, 0x71, 0x04, 0xFB, 0x10, 0x3F,
  0x90, 0x12, 0x01, 0xF9, 0x81, 0x60, 0x9F, 0xA0, 0x57, 0x10, 0x2F, 0xB0, 0x10, 0x5F, 0x0D, 0x40,
  0xEF, 0x81, 0x80, 0xAF, 0xA0, 0x37, 0x2F, 0xB0, 0x20, 0x7F, 0x0B, 0x40, 0xBF, 0x81, 0xB0, 0xBF,
  0xA0, 0x17, 0x20, 0xDF, 0xA0, 0x40, 0x9F, 0x08, 0x40, 0x8F, 0x81, 0xD0, 0xDF, 0x90, 0xE7, 0x30,
  0xBF, 0xA0, 0x50, 0xBF, 0x05, 0x40, 0x5F, 0x91, 0x0E, 0xF9, 0x0C, 0x73, 0x08, 0xFA, 0x06, 0x0D,
  0xF0, 0x24, 0x03, 0xF9, 0x04, 0xFA, 0x0A, 0x73, 0x06, 0xFA, 0x09, 0xF9, 0x6F, 0x90, 0x9F, 0xA0,
  0x77, 0x30, 0x4F, 0xFB, 0x0C, 0x60, 0xDF, 0xFB, 0x05, 0x73, 0x02, 0xFF, 0xB0, 0x96, 0x0A, 0xFF,
  0xB0, 0x37, 0x4F, 0xFB, 0x06, 0x60, 0x7F, 0xFB, 0x01, 0x74, 0x0D, 0xFF, 0xA0, 0x36, 0x04, 0xFF,
  0xA0, 0xE7, 0x50, 0xBF, 0xFA, 0x01, 0x60, 0x1F, 0xFA, 0x0C, 0x75, 0x09, 0xFF, 0x90, 0xD7, 0x10,
  0xEF, 0xF9, 0x0A, 0x75, 0x06, 0xFF, 0x90, 0xA7, 0x10, 0xBF, 0xF9, 0x08, 0x75, 0x04, 0xFF, 0x90,
  0x77, 0x10, 0x9F, 0xF9, 0x05, 0x75, 0x02, 0xFF, 0x90, 0x57, 0x10, 0x6F, 0xF9, 0x03, 0x76, 0xFF,
  0x90, 0x27, 0x10, 0x3F, 0xF9, 0x01, 0x76, 0x0D, 0xFE, 0x0E, 0x73, 0xFF, 0x0E, 0x70,
  // "Ŷ" (U+0176)
  0x77, 0x40, 0x38, 0x09, 0x17, 0x80, 0xC0, 0x00, 0xDF, 0xE0, 0x87, 0x77, 0x76, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x74, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x72, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x70, 0x4F, 0xFE, 0x0D, 0x77, 0x76, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB,
  0x0A, 0x77, 0x75, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x30, 0x8F, 0xB0, 0x43, 0x0B,
  0xFB, 0x03, 0x77, 0x71, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x76, 0x03, 0xFA,
  0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x75, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09,
  0x77, 0x40, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x72, 0x03, 0xF9, 0x07, 0x77, 0x01,
  0x0B, 0xF0, 0xB8, 0x0C, 0xE0, 0x00, 0xEF, 0xD0, 0xB7, 0x77, 0x10, 0xAF, 0xD0, 0xE0, 0x7F, 0xE0,
  0x27, 0x76, 0x01, 0xFE, 0x81, 0x71, 0xEF, 0xD0, 0x97, 0x76, 0x08, 0xFD, 0x82, 0xE1, 0x08, 0xFD,
  0x0E, 0x01, 0x77, 0x50, 0xEF, 0xD0, 0x82, 0x01, 0xFE, 0x06, 0x77, 0x40, 0x5F, 0xE0, 0x13, 0x09,
  0xFD, 0x0D, 0x77, 0x40, 0xBF, 0xD0, 0x94, 0x02, 0xFE, 0x04, 0x77, 0x20, 0x2F, 0xE0, 0x25, 0x0A,
  0xFD, 0x0A, 0x77, 0x20, 0x9F, 0xD0, 0xA6, 0x02, 0xFE, 0x01, 0x77, 0x10, 0xEF, 0xD0, 0x27, 0x0A,
  0xFD, 0x08, 0x77, 0x06, 0xFD, 0x0B, 0x71, 0x03, 0xFD, 0x0E, 0x77, 0x0C, 0xFD, 0x03, 0x72, 0x0B,
  0xFD, 0x05, 0x75, 0x03, 0xFD, 0x0B, 0x73, 0x04, 0xFD, 0x0C, 0x75, 0x0A, 0xFD, 0x04, 0x74, 0x0C,
  0xFD, 0x03, 0x73, 0x01, 0xFD, 0x0C, 0x75, 0x05, 0xFD, 0x09, 0x73, 0x07, 0xFD, 0x05, 0x76, 0x0D,
  0xFC, 0x0E, 0x01, 0x72, 0x0D, 0xFC, 0x0D, 0x77, 0x05, 0xFD, 0x07, 0x71, 0x04, 0xFD, 0x06, 0x77,
  0x10, 0xDF, 0xC0, 0xD7, 0x10, 0xBF, 0xC0, 0xE7, 0x72, 0x06, 0xFD, 0x04, 0x60, 0x2F, 0xD0, 0x77,
  0x73, 0x0E, 0xFC, 0x0A, 0x60, 0x8F, 0xC0, 0xE7, 0x74, 0x07, 0xFD, 0x02, 0x50, 0xEF, 0xC0, 0x77,
  0x75, 0x0E, 0xFC, 0x08, 0x40, 0x5F, 0xC0, 0xE0, 0x17, 0x75, 0x08, 0xFC, 0x0E, 0x40, 0xCF, 0xC0,
  0x87, 0x76, 0x01, 0x0E, 0xFC, 0x05, 0x20, 0x3F, 0xD0, 0x17, 0x77, 0x09, 0xFC, 0x0C, 0x20, 0x9F,
  0xC0, 0x97, 0x77, 0x10, 0x1F, 0xD8, 0x13, 0x1E, 0xFC, 0x02, 0x77, 0x72, 0x09, 0xFC, 0x09, 0x07,
  0xFC, 0x0A, 0x77, 0x73, 0x02, 0xFD, 0x0D, 0xFC, 0x03, 0x77, 0x74, 0x0A, 0xFF, 0xF9, 0x0B, 0x77,
  0x75, 0x03, 0xFF, 0xF9, 0x04, 0x77, 0x76, 0x0B, 0xFF, 0xE0, 0xC7, 0x77, 0x70, 0x4F, 0xFE, 0x04,
  0x77, 0x77, 0x10, 0xCF, 0xFC, 0x0D, 0x77, 0x77, 0x20, 0x4F, 0xFC, 0x05, 0x77, 0x77, 0x30, 0xCF,
  0xFA, 0x0D, 0x77, 0x77, 0x40, 0x5F, 0xFA, 0x06, 0x77, 0x77, 0x50, 0xDF, 0xF0, 0xE7, 0x77, 0x76,
  0x06, 0xFF, 0x07, 0x77, 0x77, 0x70, 0xEF, 0xD0, 0xE0, 0x17, 0x77, 0x77, 0x08, 0xFD, 0x09, 0x80,
  0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88,
  0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08,
  0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0,
  0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD,
  0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F,
  0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00,
  0x07, 0xFD, 0x08, 0x77, 0x40,
  // "ŷ" (U+0177)
  0x77, 0x40, 0x38, 0x09, 0x17, 0x80, 0xC0, 0x00, 0xDF, 0xE0, 0x87, 0x77, 0x76, 0x07, 0xFF, 0x90,
  0x27, 0x77, 0x74, 0x02, 0xFF, 0xA0, 0xC7, 0x77, 0x74, 0x0C, 0xFF, 0xB0, 0x77, 0x77, 0x72, 0x08,
  0xFF, 0xD0, 0x37, 0x77, 0x70, 0x4F, 0xFE, 0x0D, 0x77, 0x76, 0x02, 0x0E, 0xFA, 0x0E, 0x0B, 0xFB,
  0x0A, 0x77, 0x75, 0x0C, 0xFB, 0x81, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x30, 0x8F, 0xB0, 0x43, 0x0B,
  0xFB, 0x03, 0x77, 0x71, 0x05, 0xFA, 0x0E, 0x04, 0x50, 0xAF, 0xA0, 0xE0, 0x17, 0x76, 0x03, 0xFA,
  0x0E, 0x03, 0x70, 0x9F, 0xA0, 0xC7, 0x75, 0x02, 0x0E, 0xF9, 0x0D, 0x02, 0x72, 0x06, 0xFA, 0x09,
  0x77, 0x40, 0xDF, 0x90, 0xB7, 0x50, 0x30, 0xEF, 0x90, 0x67, 0x72, 0x03, 0xF9, 0x07, 0x77, 0x01,
  0x0B, 0xF0, 0xB8, 0x0C, 0xE0, 0x00, 0xEF, 0xE0, 0x27, 0x77, 0x0E, 0xFD, 0x0E, 0x09, 0xFE, 0x07,
  0x77, 0x60, 0x4F, 0xE0, 0xA0, 0x3F, 0xE0, 0xD7, 0x76, 0x09, 0xFE, 0x81, 0x40, 0xCF, 0xE0, 0x27,
  0x75, 0x0D, 0xFD, 0x0E, 0x20, 0x6F, 0xE0, 0x77, 0x74, 0x02, 0xFE, 0x08, 0x20, 0x10, 0xEF, 0xD0,
  0xD7, 0x74, 0x07, 0xFE, 0x03, 0x30, 0x9F, 0xE0, 0x27, 0x73, 0x0B, 0xFD, 0x0C, 0x40, 0x3F, 0xE0,
  0x77, 0x72, 0x01, 0xFE, 0x07, 0x50, 0xDF, 0xD0, 0xD7, 0x72, 0x05, 0xFE, 0x01, 0x50, 0x6F, 0xE0,
  0x27, 0x71, 0x09, 0xFD, 0x0B, 0x60, 0x1F, 0xE0, 0x77, 0x71, 0x0E, 0xFD, 0x05, 0x70, 0xAF, 0xD0,
  0xD7, 0x70, 0x3F, 0xD0, 0xE7, 0x10, 0x4F, 0xE0, 0x27, 0x60, 0x8F, 0xD0, 0xA7, 0x20, 0xDF, 0xD0,
  0x77, 0x60, 0xCF, 0xD0, 0x47, 0x20, 0x7F, 0xD0, 0xD7, 0x50, 0x1F, 0xD0, 0xE7, 0x30, 0x1F, 0xE0,
  0x27, 0x40, 0x6F, 0xD0, 0x87, 0x40, 0xAF, 0xD0, 0x77, 0x40, 0xAF, 0xD0, 0x27, 0x40, 0x4F, 0xD0,
  0xD7, 0x40, 0xEF, 0xC0, 0xC7, 0x60, 0xDF, 0xD0, 0x27, 0x20, 0x4F, 0xD0, 0x77, 0x60, 0x7F, 0xD0,
  0x77, 0x20, 0x9F, 0xD0, 0x17, 0x60, 0x1F, 0xD0, 0xD7, 0x20, 0xDF, 0xC0, 0xB7, 0x71, 0x0A, 0xFD,
  0x02, 0x70, 0x2F, 0xD0, 0x57, 0x71, 0x04, 0xFD, 0x07, 0x70, 0x7F, 0xC0, 0xE7, 0x73, 0x0D, 0xFC,
  0x0D, 0x70, 0xBF, 0xC0, 0x97, 0x73, 0x08, 0xFD, 0x02, 0x50, 0x1F, 0xD0, 0x47, 0x73, 0x01, 0xFD,
  0x07, 0x50, 0x5F, 0xC0, 0xD7, 0x75, 0x0B, 0xFC, 0x0D, 0x50, 0xAF, 0xC0, 0x87, 0x75, 0x05, 0xFD,
  0x02, 0x40, 0xEF, 0xC0, 0x27, 0x76, 0x0E, 0xFC, 0x07, 0x30, 0x3F, 0xC0, 0xC7, 0x77, 0x08, 0xFC,
  0x0C, 0x30, 0x8F, 0xC0, 0x67, 0x77, 0x02, 0xFD, 0x01, 0x20, 0xCF, 0xC0, 0x17, 0x77, 0x10, 0xBF,
  0xC8, 0x15, 0x01, 0xFC, 0x0B, 0x77, 0x72, 0x05, 0xFC, 0x81, 0x90, 0x5F, 0xC0, 0x57, 0x77, 0x30,
  0xEF, 0xB8, 0x1D, 0x09, 0xFB, 0x0E, 0x77, 0x74, 0x08, 0xFC, 0x10, 0xCF, 0xB0, 0x97, 0x77, 0x40,
  0x2F, 0xC0, 0x3F, 0xC0, 0x47, 0x77, 0x50, 0xBF, 0xB0, 0x8F, 0xB0, 0xD7, 0x77, 0x60, 0x5F, 0xFF,
  0x08, 0x77, 0x77, 0x0E, 0xFF, 0xE0, 0x27, 0x77, 0x70, 0x9F, 0xFD, 0x0C, 0x77, 0x77, 0x10, 0x2F,
  0xFD, 0x06, 0x77, 0x77, 0x20, 0xCF, 0xFC, 0x01, 0x77, 0x77, 0x20, 0x6F, 0xFB, 0x0B, 0x77, 0x77,
  0x40, 0xEF, 0xFA, 0x05, 0x77, 0x77, 0x40, 0x9F, 0xF9, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xF9, 0x09,
  0x77, 0x77, 0x60, 0xCF, 0xF0, 0x37, 0x77, 0x76, 0x06, 0xFE, 0x0D, 0x80, 0xC0, 0x00, 0xEF, 0xD0,
  0x88, 0x0C, 0x00, 0xFE, 0x02, 0x77, 0x77, 0x70, 0x5F, 0xD0, 0xC8, 0x0C, 0x00, 0x0B, 0xFD, 0x06,
  0x77, 0x77, 0x70, 0x1F, 0xE0, 0x17, 0x77, 0x77, 0x08, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x10, 0xEF,
  0xD0, 0x47, 0x77, 0x77, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xE0, 0x57, 0x77, 0x76, 0x04,
  0xFE, 0x0D, 0x77, 0x77, 0x60, 0x7F, 0xF0, 0x67, 0x77, 0x38, 0x24, 0x52, 0x12, 0x82, 0x14, 0x8D,
  0xFF, 0x0C, 0x77, 0x74, 0x0A, 0xFF, 0xFA, 0x04, 0x77, 0x74, 0x0A, 0xFF, 0xF9, 0x09, 0x77, 0x75,
  0x0A, 0xFF, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0xAF, 0xFF, 0x03, 0x77, 0x76, 0x0A, 0xFF, 0xE0, 0x67,
  0x77, 0x70, 0xAF, 0xFD, 0x07, 0x77, 0x77, 0x10, 0xAF, 0xFC, 0x07, 0x77, 0x77, 0x20, 0xAF, 0xFA,
  0x0E, 0x04, 0x77, 0x77, 0x30, 0xAF, 0xF9, 0x09, 0x01, 0x77, 0x77, 0x40, 0xAF, 0xD8, 0x1E, 0x92,
  0x77, 0x77, 0x68, 0x43, 0x7A, 0xCD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x77, 0x76,
  // "Ÿ" (U+0178)
  0x74, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x76, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x77, 0x50, 0x10, 0xBF,
  0x0E, 0x03, 0x74, 0x0B, 0xF0, 0xE0, 0x47, 0x74, 0x0B, 0xFA, 0x0E, 0x02, 0x72, 0x0B, 0xFB, 0x03,
  0x77, 0x20, 0x3F, 0xC0, 0xA7, 0x10, 0x3F, 0xC0, 0xB7, 0x72, 0x08, 0xFC, 0x0E, 0x71, 0x08, 0xFD,
  0x77, 0x20, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0xBF, 0xD0, 0x37, 0x0B, 0xFD, 0x04,
  0x77, 0x10, 0xAF, 0xD0, 0x27, 0x0A, 0xFD, 0x03, 0x77, 0x10, 0x7F, 0xC0, 0xE7, 0x10, 0x7F, 0xD7,
  0x72, 0x02, 0xFC, 0x09, 0x71, 0x02, 0xFC, 0x0A, 0x77, 0x30, 0xAF, 0xA0, 0xE0, 0x17, 0x20, 0x9F,
  0xA0, 0xE0, 0x27, 0x74, 0x0A, 0xF0, 0xD0, 0x37, 0x40, 0x9F, 0x0D, 0x03, 0x77, 0x68, 0x54, 0xAE,
  0xFE, 0xB6, 0x77, 0x85, 0x4A, 0xDF, 0xEC, 0x78, 0x0C, 0xE3, 0x00, 0xEF, 0xD0, 0xB7, 0x77, 0x10,
  0xAF, 0xD0, 0xE0, 0x7F, 0xE0, 0x27, 0x76, 0x01, 0xFE, 0x81, 0x71, 0xEF, 0xD0, 0x97, 0x76, 0x08,
  0xFD, 0x82, 0xE1, 0x08, 0xFD, 0x0E, 0x01, 0x77, 0x50, 0xEF, 0xD0, 0x82, 0x01, 0xFE, 0x06, 0x77,
  0x40, 0x5F, 0xE0, 0x13, 0x09, 0xFD, 0x0D, 0x77, 0x40, 0xBF, 0xD0, 0x94, 0x02, 0xFE, 0x04, 0x77,
  0x20, 0x2F, 0xE0, 0x25, 0x0A, 0xFD, 0x0A, 0x77, 0x20, 0x9F, 0xD0, 0xA6, 0x02, 0xFE, 0x01, 0x77,
  0x10, 0xEF, 0xD0, 0x27, 0x0A, 0xFD, 0x08, 0x77, 0x06, 0xFD, 0x0B, 0x71, 0x03, 0xFD, 0x0E, 0x77,
  0x0C, 0xFD, 0x03, 0x72, 0x0B, 0xFD, 0x05, 0x75, 0x03, 0xFD, 0x0B, 0x73, 0x04, 0xFD, 0x0C, 0x75,
  0x0A, 0xFD, 0x04, 0x74, 0x0C, 0xFD, 0x03, 0x73, 0x01, 0xFD, 0x0C, 0x75, 0x05, 0xFD, 0x09, 0x73,
  0x07, 0xFD, 0x05, 0x76, 0x0D, 0xFC, 0x0E, 0x01, 0x72, 0x0D, 0xFC, 0x0D, 0x77, 0x05, 0xFD, 0x07,
  0x71, 0x04, 0xFD, 0x06, 0x77, 0x10, 0xDF, 0xC0, 0xD7, 0x10, 0xBF, 0xC0, 0xE7, 0x72, 0x06, 0xFD,
  0x04, 0x60, 0x2F, 0xD0, 0x77, 0x73, 0x0E, 0xFC, 0x0A, 0x60, 0x8F, 0xC0, 0xE7, 0x74, 0x07, 0xFD,
  0x02, 0x50, 0xEF, 0xC0, 0x77, 0x75, 0x0E, 0xFC, 0x08, 0x40, 0x5F, 0xC0, 0xE0, 0x17, 0x75, 0x08,
  0xFC, 0x0E, 0x40, 0xCF, 0xC0, 0x87, 0x76, 0x01, 0x0E, 0xFC, 0x05, 0x20, 0x3F, 0xD0, 0x17, 0x77,
  0x09, 0xFC, 0x0C, 0x20, 0x9F, 0xC0, 0x97, 0x77, 0x10, 0x1F, 0xD8, 0x13, 0x1E, 0xFC, 0x02, 0x77,
  0x72, 0x09, 0xFC, 0x09, 0x07, 0xFC, 0x0A, 0x77, 0x73, 0x02, 0xFD, 0x0D, 0xFC, 0x03, 0x77, 0x74,
  0x0A, 0xFF, 0xF9, 0x0B, 0x77, 0x75, 0x03, 0xFF, 0xF9, 0x04, 0x77, 0x76, 0x0B, 0xFF, 0xE0, 0xC7,
  0x77, 0x70, 0x4F, 0xFE, 0x04, 0x77, 0x77, 0x10, 0xCF, 0xFC, 0x0D, 0x77, 0x77, 0x20, 0x4F, 0xFC,
  0x05, 0x77, 0x77, 0x30, 0xCF, 0xFA, 0x0D, 0x77, 0x77, 0x40, 0x5F, 0xFA, 0x06, 0x77, 0x77, 0x50,
  0xDF, 0xF0, 0xE7, 0x77, 0x76, 0x06, 0xFF, 0x07, 0x77, 0x77, 0x70, 0xEF, 0xD0, 0xE0, 0x17, 0x77,
  0x77, 0x08, 0xFD, 0x09, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80,
  0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88,
  0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08,
  0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0,
  0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD,
  0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F,
  0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07,
  0xFD, 0x08, 0x80, 0xC0, 0x00, 0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x80, 0xC0, 0x00,
  0x7F, 0xD0, 0x88, 0x0C, 0x00, 0x07, 0xFD, 0x08, 0x77, 0x40,
  // "Ź" (U+0179)
  0x77, 0x72, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x40, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x30, 0x3F,
  0xF0, 0x47, 0x77, 0x40, 0xCF, 0xE0, 0x57, 0x77, 0x40, 0x6F, 0xE0, 0x57, 0x77, 0x40, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x50, 0xBF, 0xC0, 0xE0, 0x47, 0x77, 0x50, 0x6F, 0xC0, 0xE0, 0x37, 0x77, 0x50,
  0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x77, 0x60, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x60, 0x7F, 0xB0, 0xD0,
  0x17, 0x77, 0x60, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x60, 0x10, 0xDF, 0xA0, 0xA7, 0x77, 0x71, 0x0A,
  0xFA, 0x08, 0x77, 0x77, 0x20, 0xEF, 0x0E, 0x05, 0x80, 0xC8, 0x40, 0x08, 0x80, 0xC1, 0xF0, 0x82,
  0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08,
  0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80,
  0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x62, 0x08, 0x80, 0xC0, 0xF0, 0xD3, 0x04, 0x80, 0xA2,
  0x80, 0x9F, 0xE0, 0x47, 0x77, 0x50, 0x9F, 0xD0, 0xB7, 0x77, 0x50, 0x3F, 0xE0, 0x27, 0x77, 0x50,
  0xBF, 0xD0, 0x87, 0x77, 0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x60, 0xDF, 0xD0, 0x57, 0x77, 0x50, 0x7F,
  0xD0, 0xC7, 0x77, 0x50, 0x10, 0xEF, 0xD0, 0x37, 0x77, 0x50, 0x9F, 0xD0, 0x97, 0x77, 0x50, 0x3F,
  0xD0, 0xE0, 0x17, 0x77, 0x50, 0xBF, 0xD0, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x60, 0xDF,
  0xD0, 0x47, 0x77, 0x50, 0x7F, 0xD0, 0xB7, 0x77, 0x50, 0x10, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0x9F,
  0xD0, 0x87, 0x77, 0x50, 0x3F, 0xD0, 0xE7, 0x77, 0x60, 0xCF, 0xD0, 0x67, 0x77, 0x50, 0x5F, 0xD0,
  0xC7, 0x77, 0x60, 0xDF, 0xD0, 0x37, 0x77, 0x50, 0x7F, 0xD0, 0x97, 0x77, 0x50, 0x10, 0xEF, 0xC0,
  0xE0, 0x17, 0x77, 0x50, 0xAF, 0xD0, 0x77, 0x77, 0x50, 0x3F, 0xD0, 0xD7, 0x77, 0x60, 0xCF, 0xD0,
  0x47, 0x77, 0x50, 0x5F, 0xD0, 0xB7, 0x77, 0x60, 0xDF, 0xD0, 0x27, 0x77, 0x50, 0x7F, 0xD0, 0x87,
  0x77, 0x50, 0x10, 0xEF, 0xC0, 0xE7, 0x77, 0x60, 0xAF, 0xD0, 0x67, 0x77, 0x50, 0x3F, 0xD0, 0xC7,
  0x77, 0x60, 0xCF, 0xD0, 0x37, 0x77, 0x50, 0x5F, 0xD0, 0x97, 0x77, 0x60, 0xDF, 0xC0, 0xE0, 0x17,
  0x77, 0x50, 0x8F, 0xD0, 0x77, 0x77, 0x50, 0x1F, 0xD0, 0xD7, 0x77, 0x60, 0xAF, 0xD0, 0x47, 0x77,
  0x50, 0x3F, 0xD0, 0xB7, 0x77, 0x60, 0xCF, 0xD0, 0x27, 0x77, 0x50, 0x5F, 0xD0, 0x87, 0x77, 0x60,
  0xEF, 0xC0, 0xE7, 0x77, 0x60, 0x8F, 0xD0, 0x67, 0x77, 0x50, 0x2F, 0xD0, 0xC7, 0x77, 0x60, 0xA8,
  0x0C, 0x2F, 0x0A, 0x03, 0x80, 0xC3, 0xF0, 0xA0, 0xB8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0,
  0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80,
  0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  // "ź" (U+017A)
  0x77, 0x74, 0x01, 0x80, 0x92, 0x70, 0x17, 0x77, 0x70, 0x9F, 0xE0, 0xE0, 0x17, 0x77, 0x60, 0x3F,
  0xF0, 0x47, 0x77, 0x70, 0xCF, 0xE0, 0x57, 0x77, 0x70, 0x6F, 0xE0, 0x57, 0x77, 0x70, 0x10, 0xEF,
  0xD0, 0x57, 0x77, 0x71, 0x0B, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x6F, 0xC0, 0xE0, 0x37, 0x77,
  0x71, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x20, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x72, 0x07,
  0xFB, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x3F, 0xB0, 0xB0, 0x17, 0x77, 0x72, 0x01, 0x0D, 0xFA, 0x0A,
  0x77, 0x77, 0x40, 0xAF, 0xA0, 0x87, 0x77, 0x75, 0x0E, 0xF0, 0xE0, 0x58, 0x0C, 0xA7, 0x00, 0xC8,
  0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C,
  0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F,
  0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x3F, 0x05, 0x30, 0xC8, 0x0C, 0x2F, 0x0D,
  0x40, 0x68, 0x0A, 0x28, 0x0A, 0xFF, 0x0E, 0x02, 0x77, 0x75, 0x01, 0x0D, 0xFF, 0x03, 0x77, 0x76,
  0x0B, 0xFF, 0x05, 0x77, 0x76, 0x08, 0xFF, 0x08, 0x77, 0x76, 0x06, 0xFF, 0x0A, 0x77, 0x76, 0x03,
  0xFF, 0x0C, 0x77, 0x76, 0x01, 0x0E, 0xFE, 0x0D, 0x01, 0x77, 0x76, 0x0C, 0xFE, 0x0E, 0x03, 0x77,
  0x76, 0x0A, 0xFF, 0x05, 0x77, 0x76, 0x07, 0xFF, 0x07, 0x77, 0x76, 0x05, 0xFF, 0x09, 0x77, 0x76,
  0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x76, 0x01, 0x0D, 0xFE, 0x0D, 0x01, 0x77, 0x76, 0x0B, 0xFE, 0x0E,
  0x02, 0x77, 0x76, 0x09, 0xFF, 0x04, 0x77, 0x76, 0x06, 0xFF, 0x06, 0x77, 0x76, 0x04, 0xFF, 0x09,
  0x77, 0x76, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x76, 0x01, 0x0D, 0xFE, 0x0D, 0x77, 0x77, 0x0B, 0xFE,
  0x0E, 0x02, 0x77, 0x76, 0x08, 0xFF, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x05, 0x77, 0x76, 0x03, 0xFF,
  0x08, 0x77, 0x76, 0x01, 0x0E, 0xFE, 0x0A, 0x77, 0x77, 0x0C, 0xFE, 0x0C, 0x77, 0x77, 0x0A, 0xFE,
  0x0D, 0x01, 0x77, 0x76, 0x07, 0xFE, 0x0E, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x05, 0x77, 0x76, 0x02,
  0x0E, 0xFE, 0x0D, 0x80, 0xA5, 0x88, 0x21, 0x01, 0xD8, 0x0C, 0x4F, 0x81, 0x20, 0xB8, 0x0C, 0x5F,
  0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F,
  0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F, 0x00, 0x28, 0x0C, 0x6F,
  0x02,
  // "Ż" (U+017B)
  0x77, 0x28, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x20, 0x7F, 0xB0, 0x77, 0x77, 0x70,
  0x8F, 0xD0, 0x77, 0x77, 0x50, 0x2F, 0xF0, 0x17, 0x77, 0x40, 0x9F, 0xF0, 0x77, 0x77, 0x40, 0xCF,
  0xF0, 0xB7, 0x77, 0x40, 0xEF, 0xF0, 0xD7, 0x77, 0x4F, 0xF9, 0x0D, 0x77, 0x74, 0x0E, 0xFF, 0x0D,
  0x77, 0x74, 0x0C, 0xFF, 0x0B, 0x77, 0x74, 0x09, 0xFF, 0x07, 0x77, 0x74, 0x02, 0xFE, 0x0E, 0x01,
  0x77, 0x75, 0x08, 0xFD, 0x06, 0x77, 0x77, 0x08, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x28, 0x90, 0x28,
  0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xC8, 0x30, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0,
  0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82,
  0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08, 0x80, 0xC1, 0xF0, 0x82, 0x08,
  0x80, 0xC1, 0xF0, 0x62, 0x08, 0x80, 0xC0, 0xF0, 0xD3, 0x04, 0x80, 0xA2, 0x80, 0x9F, 0xE0, 0x47,
  0x77, 0x50, 0x9F, 0xD0, 0xB7, 0x77, 0x50, 0x3F, 0xE0, 0x27, 0x77, 0x50, 0xBF, 0xD0, 0x87, 0x77,
  0x50, 0x5F, 0xD0, 0xE7, 0x77, 0x60, 0xDF, 0xD0, 0x57, 0x77, 0x50, 0x7F, 0xD0, 0xC7, 0x77, 0x50,
  0x10, 0xEF, 0xD0, 0x37, 0x77, 0x50, 0x9F, 0xD0, 0x97, 0x77, 0x50, 0x3F, 0xD0, 0xE0, 0x17, 0x77,
  0x50, 0xBF, 0xD0, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x60, 0xDF, 0xD0, 0x47, 0x77, 0x50,
  0x7F, 0xD0, 0xB7, 0x77, 0x50, 0x10, 0xEF, 0xD0, 0x27, 0x77, 0x50, 0x9F, 0xD0, 0x87, 0x77, 0x50,
  0x3F, 0xD0, 0xE7, 0x77, 0x60, 0xCF, 0xD0, 0x67, 0x77, 0x50, 0x5F, 0xD0, 0xC7, 0x77, 0x60, 0xDF,
  0xD0, 0x37, 0x77, 0x50, 0x7F, 0xD0, 0x97, 0x77, 0x50, 0x10, 0xEF, 0xC0, 0xE0, 0x17, 0x77, 0x50,
  0xAF, 0xD0, 0x77, 0x77, 0x50, 0x3F, 0xD0, 0xD7, 0x77, 0x60, 0xCF, 0xD0, 0x47, 0x77, 0x50, 0x5F,
  0xD0, 0xB7, 0x77, 0x60, 0xDF, 0xD0, 0x27, 0x77, 0x50, 0x7F, 0xD0, 0x87, 0x77, 0x50, 0x10, 0xEF,
  0xC0, 0xE7, 0x77, 0x60, 0xAF, 0xD0, 0x67, 0x77, 0x50, 0x3F, 0xD0, 0xC7, 0x77, 0x60, 0xCF, 0xD0,
  0x37, 0x77, 0x50, 0x5F, 0xD0, 0x97, 0x77, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x77, 0x50, 0x8F, 0xD0,
  0x77, 0x77, 0x50, 0x1F, 0xD0, 0xD7, 0x77, 0x60, 0xAF, 0xD0, 0x47, 0x77, 0x50, 0x3F, 0xD0, 0xB7,
  0x77, 0x60, 0xCF, 0xD0, 0x27, 0x77, 0x50, 0x5F, 0xD0, 0x87, 0x77, 0x60, 0xEF, 0xC0, 0xE7, 0x77,
  0x60, 0x8F, 0xD0, 0x67, 0x77, 0x50, 0x2F, 0xD0, 0xC7, 0x77, 0x60, 0xA8, 0x0C, 0x2F, 0x0A, 0x03,
  0x80, 0xC3, 0xF0, 0xA0, 0xB8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8,
  0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A,
  // "ż" (U+017C)
  0x77, 0x48, 0x21, 0x7B, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x50, 0x7F, 0xB0, 0x77, 0x77, 0x73,
  0x08, 0xFD, 0x07, 0x77, 0x77, 0x10, 0x2F, 0xF0, 0x17, 0x77, 0x70, 0x9F, 0xF0, 0x77, 0x77, 0x70,
  0xCF, 0xF0, 0xB7, 0x77, 0x70, 0xEF, 0xF0, 0xD7, 0x77, 0x7F, 0xF9, 0x0D, 0x77, 0x77, 0x0E, 0xFF,
  0x0D, 0x77, 0x77, 0x0C, 0xFF, 0x0B, 0x77, 0x77, 0x09, 0xFF, 0x07, 0x77, 0x77, 0x02, 0xFE, 0x0E,
  0x01, 0x77, 0x77, 0x10, 0x8F, 0xD0, 0x67, 0x77, 0x73, 0x08, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x58,
  0x90, 0x28, 0xCE, 0xFE, 0xDB, 0x71, 0x80, 0xCA, 0x60, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80,
  0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3,
  0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0,
  0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC2, 0xF0, 0xD4, 0x06, 0x80, 0xA2, 0x80, 0xAF,
  0xF0, 0xE0, 0x27, 0x77, 0x50, 0x10, 0xDF, 0xF0, 0x37, 0x77, 0x60, 0xBF, 0xF0, 0x57, 0x77, 0x60,
  0x8F, 0xF0, 0x87, 0x77, 0x60, 0x6F, 0xF0, 0xA7, 0x77, 0x60, 0x3F, 0xF0, 0xC7, 0x77, 0x60, 0x10,
  0xEF, 0xE0, 0xD0, 0x17, 0x77, 0x60, 0xCF, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0xAF, 0xF0, 0x57, 0x77,
  0x60, 0x7F, 0xF0, 0x77, 0x77, 0x60, 0x5F, 0xF0, 0x97, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0xB7, 0x77,
  0x60, 0x10, 0xDF, 0xE0, 0xD0, 0x17, 0x77, 0x60, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x9F, 0xF0,
  0x47, 0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77, 0x60, 0x4F, 0xF0, 0x97, 0x77, 0x60, 0x20, 0xEF, 0xE0,
  0xB7, 0x77, 0x60, 0x10, 0xDF, 0xE0, 0xD7, 0x77, 0x70, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x8F,
  0xF0, 0x37, 0x77, 0x60, 0x5F, 0xF0, 0x57, 0x77, 0x60, 0x3F, 0xF0, 0x87, 0x77, 0x60, 0x10, 0xEF,
  0xE0, 0xA7, 0x77, 0x70, 0xCF, 0xE0, 0xC7, 0x77, 0x70, 0xAF, 0xE0, 0xD0, 0x17, 0x77, 0x60, 0x7F,
  0xE0, 0xE0, 0x37, 0x77, 0x60, 0x5F, 0xF0, 0x57, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0xD8, 0x0A, 0x58,
  0x82, 0x10, 0x1D, 0x80, 0xC4, 0xF8, 0x12, 0x0B, 0x80, 0xC5, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02,
  0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02,
  0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x20,
  // "Ž" (U+017D)
  0x40, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x70, 0x6F, 0x90, 0xB0, 0x17, 0x50,
  0x10, 0xBF, 0x90, 0x67, 0x10, 0xCF, 0x90, 0xD0, 0x27, 0x30, 0x30, 0xEF, 0x90, 0xC7, 0x20, 0x10,
  0xDF, 0x90, 0xE0, 0x47, 0x10, 0x6F, 0xA0, 0xD0, 0x17, 0x30, 0x20, 0xEF, 0xA0, 0x56, 0x08, 0xFB,
  0x03, 0x75, 0x04, 0xFB, 0x07, 0x40, 0x9F, 0xB0, 0x57, 0x70, 0x8F, 0xB0, 0x62, 0x09, 0xFB, 0x09,
  0x77, 0x20, 0xBF, 0xB0, 0x50, 0x8F, 0xB0, 0xC7, 0x73, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x74,
  0x04, 0xFF, 0xE0, 0x47, 0x76, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x10, 0xCF, 0xFA, 0x0C, 0x77, 0x72,
  0x02, 0xFF, 0xA0, 0x27, 0x77, 0x30, 0x7F, 0xF0, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xD8, 0x0C, 0x81,
  0x00, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20,
  0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88,
  0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x08, 0x20, 0x88, 0x0C, 0x1F, 0x06, 0x20, 0x88, 0x0C,
  0x0F, 0x0D, 0x30, 0x48, 0x0A, 0x28, 0x09, 0xFE, 0x04, 0x77, 0x75, 0x09, 0xFD, 0x0B, 0x77, 0x75,
  0x03, 0xFE, 0x02, 0x77, 0x75, 0x0B, 0xFD, 0x08, 0x77, 0x75, 0x05, 0xFD, 0x0E, 0x77, 0x76, 0x0D,
  0xFD, 0x05, 0x77, 0x75, 0x07, 0xFD, 0x0C, 0x77, 0x75, 0x01, 0x0E, 0xFD, 0x03, 0x77, 0x75, 0x09,
  0xFD, 0x09, 0x77, 0x75, 0x03, 0xFD, 0x0E, 0x01, 0x77, 0x75, 0x0B, 0xFD, 0x07, 0x77, 0x75, 0x05,
  0xFD, 0x0D, 0x77, 0x76, 0x0D, 0xFD, 0x04, 0x77, 0x75, 0x07, 0xFD, 0x0B, 0x77, 0x75, 0x01, 0x0E,
  0xFD, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x08, 0x77, 0x75, 0x03, 0xFD, 0x0E, 0x77, 0x76, 0x0C, 0xFD,
  0x06, 0x77, 0x75, 0x05, 0xFD, 0x0C, 0x77, 0x76, 0x0D, 0xFD, 0x03, 0x77, 0x75, 0x07, 0xFD, 0x09,
  0x77, 0x75, 0x01, 0x0E, 0xFC, 0x0E, 0x01, 0x77, 0x75, 0x0A, 0xFD, 0x07, 0x77, 0x75, 0x03, 0xFD,
  0x0D, 0x77, 0x76, 0x0C, 0xFD, 0x04, 0x77, 0x75, 0x05, 0xFD, 0x0B, 0x77, 0x76, 0x0D, 0xFD, 0x02,
  0x77, 0x75, 0x07, 0xFD, 0x08, 0x77, 0x75, 0x01, 0x0E, 0xFC, 0x0E, 0x77, 0x76, 0x0A, 0xFD, 0x06,
  0x77, 0x75, 0x03, 0xFD, 0x0C, 0x77, 0x76, 0x0C, 0xFD, 0x03, 0x77, 0x75, 0x05, 0xFD, 0x09, 0x77,
  0x76, 0x0D, 0xFC, 0x0E, 0x01, 0x77, 0x75, 0x08, 0xFD, 0x07, 0x77, 0x75, 0x01, 0xFD, 0x0D, 0x77,
  0x76, 0x0A, 0xFD, 0x04, 0x77, 0x75, 0x03, 0xFD, 0x0B, 0x77, 0x76, 0x0C, 0xFD, 0x02, 0x77, 0x75,
  0x05, 0xFD, 0x08, 0x77, 0x76, 0x0E, 0xFC, 0x0E, 0x77, 0x76, 0x08, 0xFD, 0x06, 0x77, 0x75, 0x02,
  0xFD, 0x0C, 0x77, 0x76, 0x0A, 0x80, 0xC2, 0xF0, 0xA0, 0x38, 0x0C, 0x3F, 0x0A, 0x0B, 0x80, 0xC3,
  0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C,
  0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F, 0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0, 0xC8, 0x0C, 0x3F,
  0x0A, 0x0C, 0x80, 0xC3, 0xF0, 0xA0,
  // "ž" (U+017E)
  0x60, 0x38, 0x03, 0x70, 0x67, 0x72, 0x06, 0x80, 0x37, 0x03, 0x73, 0x06, 0xF9, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0xF9, 0x06, 0x74, 0x0C, 0xF9, 0x0D, 0x02, 0x73, 0x03, 0x0E, 0xF9, 0x0C, 0x75, 0x01,
  0x0D, 0xF9, 0x0E, 0x04, 0x71, 0x06, 0xFA, 0x0D, 0x01, 0x76, 0x02, 0x0E, 0xFA, 0x05, 0x60, 0x8F,
  0xB0, 0x37, 0x71, 0x04, 0xFB, 0x07, 0x40, 0x9F, 0xB0, 0x57, 0x73, 0x08, 0xFB, 0x06, 0x20, 0x9F,
  0xB0, 0x97, 0x75, 0x0B, 0xFB, 0x05, 0x08, 0xFB, 0x0C, 0x77, 0x60, 0x10, 0xEF, 0xFE, 0x0E, 0x02,
  0x77, 0x70, 0x4F, 0xFE, 0x04, 0x77, 0x72, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x40, 0xCF, 0xFA, 0x0C,
  0x77, 0x75, 0x02, 0xFF, 0xA0, 0x27, 0x77, 0x60, 0x7F, 0xF0, 0x77, 0x77, 0x71, 0x0D, 0xFD, 0x0D,
  0x80, 0xCA, 0x40, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3,
  0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0,
  0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53, 0x0C, 0x80, 0xC3, 0xF0, 0x53,
  0x0C, 0x80, 0xC2, 0xF0, 0xD4, 0x06, 0x80, 0xA2, 0x80, 0xAF, 0xF0, 0xE0, 0x27, 0x77, 0x50, 0x10,
  0xDF, 0xF0, 0x37, 0x77, 0x60, 0xBF, 0xF0, 0x57, 0x77, 0x60, 0x8F, 0xF0, 0x87, 0x77, 0x60, 0x6F,
  0xF0, 0xA7, 0x77, 0x60, 0x3F, 0xF0, 0xC7, 0x77, 0x60, 0x10, 0xEF, 0xE0, 0xD0, 0x17, 0x77, 0x60,
  0xCF, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0xAF, 0xF0, 0x57, 0x77, 0x60, 0x7F, 0xF0, 0x77, 0x77, 0x60,
  0x5F, 0xF0, 0x97, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0xB7, 0x77, 0x60, 0x10, 0xDF, 0xE0, 0xD0, 0x17,
  0x77, 0x60, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x9F, 0xF0, 0x47, 0x77, 0x60, 0x6F, 0xF0, 0x67,
  0x77, 0x60, 0x4F, 0xF0, 0x97, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0xB7, 0x77, 0x60, 0x10, 0xDF, 0xE0,
  0xD7, 0x77, 0x70, 0xBF, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x8F, 0xF0, 0x37, 0x77, 0x60, 0x5F, 0xF0,
  0x57, 0x77, 0x60, 0x3F, 0xF0, 0x87, 0x77, 0x60, 0x10, 0xEF, 0xE0, 0xA7, 0x77, 0x70, 0xCF, 0xE0,
  0xC7, 0x77, 0x70, 0xAF, 0xE0, 0xD0, 0x17, 0x77, 0x60, 0x7F, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0x5F,
  0xF0, 0x57, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0xD8, 0x0A, 0x58, 0x82, 0x10, 0x1D, 0x80, 0xC4, 0xF8,
  0x12, 0x0B, 0x80, 0xC5, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6,
  0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x02, 0x80, 0xC6,
  0xF0, 0x02, 0x80, 0xC6, 0xF0, 0x20,
  // "ſ" (U+017F)
  0x76, 0x89, 0x13, 0x46, 0x77, 0x87, 0x76, 0x42, 0x77, 0x18, 0x13, 0x8C, 0xFE, 0x81, 0xC8, 0x47,
  0x20, 0x60, 0xDF, 0xFD, 0x0E, 0x09, 0x50, 0x20, 0xCF, 0xFF, 0x90, 0xA4, 0x02, 0x0E, 0xFF, 0xFA,
  0x06, 0x30, 0x10, 0xEF, 0xFF, 0xB0, 0x13, 0x0B, 0xFF, 0xFB, 0x0D, 0x30, 0x4F, 0xFF, 0xC0, 0x83,
  0x0C, 0xFF, 0xFC, 0x04, 0x20, 0x1F, 0xFF, 0xC0, 0xE3, 0x06, 0xFF, 0xFC, 0x0A, 0x30, 0x9F, 0xF8,
  0x1A, 0x41, 0x28, 0x12, 0x5A, 0xB0, 0x63, 0x0C, 0xFE, 0x05, 0x71, 0x82, 0x17, 0xD1, 0x30, 0xEF,
  0xD0, 0x97, 0x72, 0xFE, 0x03, 0x77, 0x2F, 0xD0, 0xE7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F,
  0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77,
  0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD,
  0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72,
  0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0,
  0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20,
  0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C,
  0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01,
  0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7,
  0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F,
  0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77,
  0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD,
  0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72,
  0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0,
  0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20, 0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20,
  0x1F, 0xD0, 0xC7, 0x72, 0x01, 0xFD, 0x0C, 0x77, 0x20,
  // "Ω" (U+03A9)
  0x77, 0x58, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x73, 0x77, 0x77, 0x70, 0x50, 0xBF, 0xF9,
  0x81, 0xE9, 0x47, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xE0, 0xC0, 0x47, 0x77, 0x50, 0x40, 0xDF, 0xFF,
  0xB0, 0xB0, 0x27, 0x77, 0x20, 0x8F, 0xFF, 0xE0, 0xE0, 0x47, 0x77, 0x0B, 0xFF, 0xFF, 0xA0, 0x77,
  0x75, 0x0B, 0xFF, 0xFF, 0xC0, 0x77, 0x73, 0x09, 0xFF, 0xFF, 0xE0, 0x57, 0x71, 0x05, 0xFF, 0xFF,
  0xF0, 0xE0, 0x27, 0x60, 0x10, 0xE8, 0x0C, 0x0F, 0x0C, 0x76, 0x0A, 0xFF, 0xA8, 0x4C, 0x98, 0x89,
  0xCF, 0xFA, 0x06, 0x74, 0x02, 0xFF, 0x81, 0xE7, 0x16, 0x81, 0x16, 0xEF, 0xE0, 0xE7, 0x40, 0xAF,
  0xE0, 0xC0, 0x17, 0x30, 0x10, 0xBF, 0xE0, 0x67, 0x20, 0x1F, 0xE0, 0xC7, 0x70, 0xAF, 0xD0, 0xD7,
  0x20, 0x6F, 0xD0, 0xE0, 0x17, 0x71, 0x0D, 0xFD, 0x03, 0x71, 0x0B, 0xFD, 0x06, 0x77, 0x20, 0x5F,
  0xD0, 0x87, 0x1F, 0xD0, 0xE7, 0x74, 0x0D, 0xFC, 0x0D, 0x70, 0x4F, 0xD0, 0x87, 0x74, 0x06, 0xFD,
  0x01, 0x60, 0x8F, 0xD0, 0x37, 0x74, 0x01, 0xFD, 0x05, 0x60, 0xBF, 0xC0, 0xE7, 0x76, 0x0C, 0xFC,
  0x07, 0x60, 0xDF, 0xC0, 0xA7, 0x76, 0x09, 0xFC, 0x0A, 0x6F, 0xD0, 0x77, 0x76, 0x06, 0xFC, 0x0C,
  0x50, 0x1F, 0xD0, 0x57, 0x76, 0x03, 0xFC, 0x0E, 0x50, 0x3F, 0xD0, 0x37, 0x76, 0x01, 0xFD, 0x50,
  0x4F, 0xD0, 0x17, 0x77, 0xFD, 0x01, 0x40, 0x5F, 0xD7, 0x77, 0x10, 0xEF, 0xC0, 0x24, 0x05, 0xFC,
  0x0E, 0x77, 0x71, 0x0D, 0xFC, 0x02, 0x40, 0x6F, 0xC0, 0xD7, 0x77, 0x10, 0xCF, 0xC0, 0x34, 0x06,
  0xFC, 0x0D, 0x77, 0x71, 0x0C, 0xFC, 0x03, 0x40, 0x5F, 0xC0, 0xD7, 0x77, 0x10, 0xBF, 0xC0, 0x24,
  0x04, 0xFC, 0x0D, 0x77, 0x71, 0x0C, 0xFC, 0x01, 0x40, 0x4F, 0xC0, 0xD7, 0x77, 0x10, 0xCF, 0xC0,
  0x14, 0x03, 0xFC, 0x0E, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x1F, 0xC0, 0xE7, 0x77, 0x10, 0xDF, 0xB0,
  0xE6, 0xFD, 0x77, 0x71, 0x0E, 0xFB, 0x0C, 0x60, 0xDF, 0xC0, 0x17, 0x77, 0xFC, 0x0A, 0x60, 0xBF,
  0xC0, 0x27, 0x76, 0x02, 0xFC, 0x08, 0x60, 0x8F, 0xC0, 0x47, 0x76, 0x03, 0xFC, 0x05, 0x60, 0x4F,
  0xC0, 0x67, 0x76, 0x06, 0xFC, 0x01, 0x60, 0x1F, 0xC0, 0x87, 0x76, 0x08, 0xFB, 0x0D, 0x71, 0x0D,
  0xFB, 0x0B, 0x77, 0x60, 0xBF, 0xB0, 0xA7, 0x10, 0x8F, 0xB0, 0xE7, 0x76, 0x0E, 0xFB, 0x05, 0x71,
  0x02, 0xFC, 0x02, 0x77, 0x40, 0x3F, 0xB0, 0xE7, 0x30, 0xDF, 0xB0, 0x67, 0x74, 0x07, 0xFB, 0x0A,
  0x73, 0x06, 0xFB, 0x0A, 0x77, 0x40, 0xCF, 0xB0, 0x37, 0x40, 0xEF, 0xA0, 0xE7, 0x73, 0x02, 0xFB,
  0x0C, 0x75, 0x08, 0xFB, 0x05, 0x77, 0x20, 0x8F, 0xB0, 0x47, 0x50, 0x10, 0xEF, 0xA0, 0xB7, 0x71,
  0x01, 0x0E, 0xFA, 0x0C, 0x77, 0x06, 0xFB, 0x04, 0x77, 0x08, 0xFB, 0x02, 0x77, 0x10, 0xCF, 0xA0,
  0xC7, 0x60, 0x10, 0xEF, 0xA0, 0x87, 0x72, 0x02, 0x0E, 0xFA, 0x07, 0x75, 0x0B, 0xFA, 0x0B, 0x77,
  0x40, 0x4F, 0xB0, 0x37, 0x30, 0x7F, 0xA0, 0xD0, 0x17, 0x75, 0x06, 0xFA, 0x0D, 0x02, 0x71, 0x04,
  0xFA, 0x0E, 0x02, 0x77, 0x70, 0x5F, 0xA0, 0xD0, 0x26, 0x04, 0xFA, 0x0D, 0x02, 0x74, 0x05, 0x80,
  0x78, 0x0C, 0xFA, 0x07, 0x60, 0xAF, 0xA0, 0x98, 0x07, 0x80, 0x50, 0xAF, 0xFF, 0x07, 0x60, 0xAF,
  0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00,
  0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF,
  0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60,
  0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF, 0x00, 0xAF, 0xFF, 0x07, 0x60, 0xAF, 0xFF,
  0x0A,
  // "μ" (U+03BC)
  0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F,
  0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74,
  0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87,
  0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08,
  0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0,
  0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD,
  0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F,
  0xD0, 0x87, 0x74, 0xFE, 0x07, 0xFD, 0x08, 0x77, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x74, 0xFE, 0x07,
  0xFD, 0x08, 0x77, 0x30, 0x1F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x02, 0xFE, 0x07, 0xFD, 0x08, 0x77,
  0x30, 0x4F, 0xE0, 0x7F, 0xD0, 0x87, 0x73, 0x06, 0xFE, 0x07, 0xFD, 0x09, 0x77, 0x30, 0x9F, 0xE0,
  0x7F, 0xD0, 0xA7, 0x73, 0x0C, 0xFE, 0x07, 0xFD, 0x0D, 0x77, 0x20, 0x1F, 0xF0, 0x7F, 0xE7, 0x72,
  0x05, 0xFF, 0x07, 0xFE, 0x04, 0x77, 0x10, 0xCF, 0xF0, 0x7F, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x07,
  0xFF, 0x02, 0x75, 0x02, 0x0E, 0xFF, 0x90, 0x7F, 0xF0, 0xD0, 0x17, 0x30, 0x20, 0xDF, 0xFA, 0x07,
  0xFF, 0x90, 0xD0, 0x57, 0x01, 0x08, 0xFF, 0xC0, 0x7F, 0xFB, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0xFE,
  0x07, 0x80, 0xD0, 0xF0, 0x78, 0x0D, 0x0F, 0x07, 0x80, 0xD0, 0xF0, 0x7F, 0xFF, 0xFA, 0x81, 0xD0,
  0xDF, 0xC0, 0x7F, 0xFF, 0xF9, 0x82, 0xE2, 0x07, 0xFC, 0x07, 0xFF, 0xFF, 0x0E, 0x03, 0x20, 0x1F,
  0xC0, 0x7F, 0xFF, 0xE0, 0xB0, 0x14, 0x0B, 0xFB, 0x07, 0xFF, 0xFC, 0x0E, 0x06, 0x60, 0x6F, 0xB0,
  0x7F, 0xFF, 0xA0, 0xC0, 0x67, 0x2F, 0xB0, 0x7F, 0xD8, 0x1D, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x77, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77,
  0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87,
  0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08,
  0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0,
  0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD,
  0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F,
  0xD0, 0x87, 0x77, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD0, 0x87, 0x77, 0x73, 0x07,
  0xFD, 0x08, 0x77, 0x77, 0x30,
  // "π" (U+03C0)
  0x70, 0x60, 0xE8, 0x0D, 0x0F, 0x04, 0x50, 0x40, 0xD8, 0x0D, 0x2F, 0x04, 0x30, 0x20, 0xA8, 0x0D,
  0x4F, 0x04, 0x20, 0x88, 0x0D, 0x6F, 0x81, 0x42, 0xE8, 0x0D, 0x7F, 0x00, 0x48, 0x0E, 0x0F, 0x00,
  0x48, 0x0E, 0x0F, 0x00, 0x48, 0x0E, 0x0F, 0x00, 0x48, 0x0E, 0x0F, 0x00, 0x48, 0x0E, 0x0F, 0x04,
  0x72, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0,
  0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF,
  0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20,
  0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0,
  0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50,
  0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC, 0x07,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D, 0xFC,
  0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72, 0x0D,
  0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E, 0x72,
  0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC, 0x0E,
  0x72, 0x0D, 0xFC, 0x07, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xDF, 0xC0, 0x77, 0x75, 0x05, 0xFC,
  0x0E, 0x72, 0x0C, 0xFC, 0x09, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x20, 0xBF, 0xC0, 0xE0, 0x17, 0x74,
  0x05, 0xFC, 0x0E, 0x72, 0x0A, 0xFD, 0x0B, 0x01, 0x58, 0x13, 0x92, 0x72, 0x05, 0xFC, 0x0E, 0x72,
  0x09, 0xFF, 0x83, 0xA8, 0x8A, 0xDA, 0x02, 0x72, 0x05, 0xFC, 0x0E, 0x72, 0x06, 0xFF, 0xF0, 0x27,
  0x20, 0x5F, 0xC0, 0xE7, 0x20, 0x2F, 0xFF, 0x02, 0x72, 0x05, 0xFC, 0x0E, 0x73, 0x0D, 0xFF, 0xE0,
  0x27, 0x20, 0x5F, 0xC0, 0xE7, 0x30, 0x7F, 0xFE, 0x02, 0x72, 0x05, 0xFC, 0x0E, 0x73, 0x01, 0x0E,
  0xFF, 0xD0, 0x27, 0x20, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xFD, 0x02, 0x72, 0x05, 0xFC, 0x0E, 0x75,
  0x08, 0xFF, 0xC0, 0x27, 0x20, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xFA, 0x0E, 0x01, 0x72, 0x05, 0xFC,
  0x0E, 0x77, 0x02, 0x0A, 0xFD, 0x0C, 0x06, 0x75, 0x80, 0x90, 0x17, 0x72, 0x89, 0x21, 0x6A, 0xDE,
  0xFE, 0xDC, 0x96, 0x24,
  // "–" (U+2013)
  0x80, 0xE9, 0x0F,
  // "—" (U+2014)
  0x80, 0x99, 0x96, 0xF0,
  // "€" (U+20AC)
  0x77, 0x74, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x86, 0x37, 0x77, 0x72, 0x81, 0x38,
  0xDF, 0xFB, 0x81, 0xB6, 0x17, 0x77, 0x30, 0x50, 0xCF, 0xFF, 0xA0, 0xB0, 0x47, 0x76, 0x04, 0x0D,
  0xFF, 0xFE, 0x0C, 0x04, 0x77, 0x20, 0x10, 0xAF, 0xFF, 0xFA, 0x04, 0x77, 0x10, 0x30, 0xDF, 0xFF,
  0xFA, 0x0D, 0x77, 0x10, 0x5F, 0xFF, 0xFC, 0x06, 0x77, 0x06, 0xFF, 0xFF, 0xC0, 0xE7, 0x70, 0x5F,
  0xFF, 0xFD, 0x08, 0x76, 0x02, 0xFF, 0xFF, 0xE0, 0x17, 0x60, 0xDF, 0xFB, 0x86, 0xEB, 0xA8, 0x89,
  0xAD, 0xF9, 0x0A, 0x76, 0x08, 0xFF, 0x98, 0x1E, 0x82, 0x72, 0x81, 0x38, 0xDC, 0x03, 0x75, 0x02,
  0xFF, 0x90, 0x77, 0x71, 0x82, 0x28, 0xEC, 0x76, 0x0A, 0xFE, 0x0D, 0x02, 0x77, 0x50, 0x17, 0x50,
  0x2F, 0xE0, 0xD0, 0x27, 0x77, 0x75, 0x09, 0xFE, 0x02, 0x77, 0x77, 0x60, 0xEF, 0xD0, 0x77, 0x77,
  0x76, 0x04, 0xFD, 0x0D, 0x77, 0x77, 0x70, 0x9F, 0xD0, 0x77, 0x77, 0x77, 0x0D, 0xFD, 0x01, 0x77,
  0x77, 0x60, 0x1F, 0xD0, 0xC7, 0x77, 0x77, 0x04, 0xFD, 0x08, 0x77, 0x77, 0x10, 0x48, 0x0C, 0x0F,
  0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x48, 0x0C, 0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0,
  0xF0, 0x77, 0x40, 0x48, 0x0C, 0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x48, 0x0C,
  0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x72, 0x01, 0xFD, 0x0B, 0x77, 0x77, 0x70, 0x1F,
  0xD0, 0xB7, 0x77, 0x77, 0x01, 0xFD, 0x0A, 0x77, 0x77, 0x70, 0x1F, 0xD0, 0xA8, 0x0C, 0x00, 0xFD,
  0x0B, 0x77, 0x77, 0x20, 0x48, 0x0C, 0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x48,
  0x0C, 0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x48, 0x0C, 0x0F, 0x07, 0x74, 0x04,
  0x80, 0xC0, 0xF0, 0x77, 0x40, 0x48, 0x0C, 0x0F, 0x07, 0x74, 0x04, 0x80, 0xC0, 0xF0, 0x77, 0x73,
  0x01, 0xFD, 0x09, 0x80, 0xC0, 0x00, 0xDF, 0xC0, 0xD8, 0x0C, 0x00, 0x09, 0xFD, 0x02, 0x77, 0x77,
  0x70, 0x5F, 0xD0, 0x97, 0x77, 0x77, 0x01, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x70, 0xBF, 0xD0, 0x97,
  0x77, 0x77, 0x05, 0xFE, 0x04, 0x77, 0x77, 0x70, 0xDF, 0xD0, 0xE0, 0x37, 0x77, 0x76, 0x07, 0xFE,
  0x0E, 0x05, 0x77, 0x77, 0x60, 0xDF, 0xF0, 0xA0, 0x17, 0x72, 0x82, 0x28, 0xE2, 0x75, 0x05, 0xFF,
  0xA8, 0x1A, 0x41, 0x72, 0x82, 0x14, 0x8D, 0xB0, 0x27, 0x60, 0xBF, 0xFC, 0x87, 0xDA, 0x98, 0x89,
  0xAB, 0xEF, 0x02, 0x76, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0x27, 0x70, 0x30, 0xEF, 0xFF, 0xFC, 0x02,
  0x77, 0x10, 0x4F, 0xFF, 0xFC, 0x02, 0x77, 0x20, 0x40, 0xEF, 0xFF, 0xFA, 0x02, 0x77, 0x30, 0x30,
  0xDF, 0xFF, 0xF9, 0x02, 0x77, 0x40, 0x10, 0xAF, 0xFF, 0xF0, 0x27, 0x76, 0x04, 0x0D, 0xFF, 0xFD,
  0x02, 0x77, 0x71, 0x05, 0x0C, 0xFF, 0xFA, 0x0C, 0x01, 0x77, 0x73, 0x81, 0x38, 0xDF, 0xFB, 0x81,
  0xC8, 0x27, 0x77, 0x71, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC, 0x97, 0x51, 0x70,
  // "₿" (U+20BF)
  0x72, 0x04, 0x80, 0x17, 0x03, 0x60, 0x58, 0x01, 0x70, 0x27, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD,
  0x04, 0x77, 0x73, 0x09, 0xD0, 0x66, 0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04,
  0x77, 0x73, 0x09, 0xD0, 0x66, 0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77,
  0x73, 0x09, 0xD0, 0x66, 0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x73,
  0x09, 0xD0, 0x66, 0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x10, 0xCF,
  0xFF, 0xE0, 0x67, 0x71, 0x0C, 0xFF, 0xFF, 0x82, 0xEB, 0x71, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0xB0,
  0x47, 0x20, 0xCF, 0xFF, 0xFE, 0x0A, 0x02, 0x70, 0xCF, 0xFF, 0xFF, 0x0E, 0x04, 0x60, 0xC8, 0x0C,
  0x1F, 0x05, 0x50, 0xC8, 0x0C, 0x2F, 0x03, 0x40, 0xC8, 0x0C, 0x2F, 0x0D, 0x40, 0xC8, 0x0C, 0x3F,
  0x07, 0x30, 0xC8, 0x0C, 0x3F, 0x0E, 0x30, 0xCF, 0xC0, 0xA8, 0x04, 0x88, 0x19, 0xBD, 0xFF, 0xB0,
  0x42, 0x0C, 0xFC, 0x05, 0x74, 0x02, 0x08, 0xFF, 0x90, 0x82, 0x0C, 0xFC, 0x05, 0x76, 0x02, 0x0E,
  0xFE, 0x0B, 0x20, 0xCF, 0xC0, 0x57, 0x70, 0x4F, 0xE0, 0xD2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0xBF,
  0xD0, 0xE2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0x7F, 0xE2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0x4F, 0xE2,
  0x0C, 0xFC, 0x05, 0x77, 0x10, 0x3F, 0xD0, 0xE2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0x3F, 0xD0, 0xD2,
  0x0C, 0xFC, 0x05, 0x77, 0x10, 0x4F, 0xD0, 0xB2, 0x0C, 0xFC, 0x05, 0x77, 0x10, 0x7F, 0xD0, 0x82,
  0x0C, 0xFC, 0x05, 0x77, 0x10, 0xBF, 0xD0, 0x42, 0x0C, 0xFC, 0x05, 0x77, 0x03, 0xFD, 0x0D, 0x30,
  0xCF, 0xC0, 0x57, 0x60, 0x10, 0xDF, 0xD0, 0x83, 0x0C, 0xFC, 0x05, 0x74, 0x81, 0x17, 0xEF, 0xD0,
  0xE4, 0x0C, 0xFC, 0x0A, 0x80, 0x48, 0x81, 0x9A, 0xDF, 0xF9, 0x05, 0x40, 0xC8, 0x0C, 0x1F, 0x08,
  0x50, 0xC8, 0x0C, 0x0F, 0x09, 0x60, 0xCF, 0xFF, 0xFE, 0x0E, 0x05, 0x70, 0xCF, 0xFF, 0xFC, 0x0D,
  0x07, 0x72, 0x0C, 0xFF, 0xFF, 0xB0, 0x97, 0x40, 0xCF, 0xFF, 0xFD, 0x0B, 0x04, 0x71, 0x0C, 0xFF,
  0xFF, 0xF0, 0xC0, 0x36, 0x0C, 0x80, 0xC1, 0xF0, 0x75, 0x0C, 0x80, 0xC2, 0xF0, 0x94, 0x0C, 0x80,
  0xC3, 0xF0, 0x83, 0x0C, 0xFC, 0x05, 0x72, 0x82, 0x13, 0x6A, 0xFF, 0x90, 0x32, 0x0C, 0xFC, 0x05,
  0x76, 0x02, 0x0C, 0xFE, 0x0C, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x0D, 0xFE, 0x81, 0x30, 0xCF, 0xC0,
  0x57, 0x71, 0x03, 0xFE, 0x81, 0x90, 0xCF, 0xC0, 0x57, 0x72, 0x0C, 0xFD, 0x81, 0xD0, 0xCF, 0xC0,
  0x57, 0x72, 0x08, 0xFE, 0x01, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0x5F, 0xE0, 0x30, 0xCF, 0xC0, 0x57,
  0x72, 0x03, 0xFE, 0x04, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0x3F, 0xE0, 0x50, 0xCF, 0xC0, 0x57, 0x72,
  0x03, 0xFE, 0x06, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0x5F, 0xE0, 0x50, 0xCF, 0xC0, 0x57, 0x72, 0x07,
  0xFE, 0x03, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0xBF, 0xE0, 0x20, 0xCF, 0xC0, 0x57, 0x71, 0x02, 0xFF,
  0x10, 0xCF, 0xC0, 0x57, 0x71, 0x0A, 0xFE, 0x81, 0xC0, 0xCF, 0xC0, 0x57, 0x70, 0x8F, 0xF8, 0x18,
  0x0C, 0xFC, 0x05, 0x75, 0x03, 0x0B, 0xFF, 0x98, 0x13, 0x0C, 0xFC, 0x0A, 0x80, 0x58, 0x81, 0x9B,
  0xEF, 0xFA, 0x0C, 0x20, 0xC8, 0x0C, 0x4F, 0x05, 0x20, 0xC8, 0x0C, 0x3F, 0x0B, 0x30, 0xC8, 0x0C,
  0x2F, 0x0E, 0x02, 0x30, 0xC8, 0x0C, 0x2F, 0x05, 0x40, 0xC8, 0x0C, 0x1F, 0x05, 0x50, 0xCF, 0xFF,
  0xFF, 0x0E, 0x05, 0x60, 0xCF, 0xFF, 0xFE, 0x0B, 0x02, 0x70, 0xCF, 0xFF, 0xFC, 0x0C, 0x05, 0x72,
  0x0C, 0xFF, 0xFF, 0x98, 0x1D, 0x93, 0x74, 0x0C, 0xFF, 0xFE, 0x08, 0x02, 0x77, 0x72, 0x09, 0xD0,
  0x66, 0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x73, 0x09, 0xD0, 0x66,
  0x0B, 0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x73, 0x09, 0xD0, 0x66, 0x0B,
  0xD0, 0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x73, 0x09, 0xD0, 0x66, 0x0B, 0xD0,
  0x47, 0x77, 0x30, 0x9D, 0x06, 0x60, 0xBD, 0x04, 0x77, 0x73, 0x09, 0xD0, 0x66, 0x0B, 0xD0, 0x47,
  0x71,
  // "‘" (U+2018)
  0x70, 0x10, 0xEF, 0x90, 0x57, 0x07, 0xFA, 0x01, 0x70, 0xDF, 0x90, 0xD7, 0x05, 0xFA, 0x0A, 0x70,
  0xBF, 0xA0, 0x66, 0x02, 0xFB, 0x03, 0x60, 0x8F, 0xB7, 0x0E, 0xFA, 0x0C, 0x60, 0x5F, 0xB0, 0x86,
  0x0B, 0xFB, 0x05, 0x50, 0x2F, 0xC0, 0x25, 0x07, 0xFB, 0x0E, 0x60, 0xDF, 0xB0, 0xB5, 0x03, 0xFC,
  0x08, 0x50, 0x8F, 0xC0, 0x55, 0x0D, 0xFC, 0x02, 0x40, 0x3F, 0xD5, 0x08, 0xFC, 0x0C, 0x50, 0xCF,
  0xC0, 0x94, 0x01, 0xFD, 0x07, 0x40, 0x6F, 0xD0, 0x44, 0x03, 0xFD, 0x01, 0x40,
  // "’" (U+2019)
  0x40, 0xBF, 0xC0, 0xD5, 0x0E, 0xFD, 0x01, 0x30, 0x1F, 0xD0, 0xC4, 0x03, 0xFD, 0x08, 0x40, 0x6F,
  0xD0, 0x44, 0x08, 0xFC, 0x0E, 0x50, 0xBF, 0xC0, 0x95, 0x0E, 0xFC, 0x04, 0x40, 0x2F, 0xC0, 0xE5,
  0x05, 0xFC, 0x09, 0x50, 0x8F, 0xC0, 0x45, 0x0B, 0xFB, 0x0D, 0x60, 0xEF, 0xB0, 0x75, 0x02, 0xFC,
  0x01, 0x50, 0x6F, 0xB0, 0xA6, 0x09, 0xFB, 0x04, 0x60, 0xCF, 0xA0, 0xD6, 0x01, 0xFB, 0x07, 0x60,
  0x4F, 0xA0, 0xE0, 0x16, 0x08, 0xFA, 0x09, 0x70, 0xBF, 0xA0, 0x27, 0x0E, 0xF9, 0x0B, 0x71,
  // "‚" (U+201A)
  0x50, 0xBF, 0xC0, 0xE0, 0x15, 0x0E, 0xFD, 0x02, 0x40, 0x1F, 0xD0, 0xD5, 0x03, 0xFD, 0x09, 0x50,
  0x6F, 0xD0, 0x55, 0x08, 0xFD, 0x01, 0x50, 0xBF, 0xC0, 0xC6, 0x0E, 0xFC, 0x08, 0x50, 0x1F, 0xD0,
  0x45, 0x04, 0xFC, 0x0E, 0x60, 0x6F, 0xC0, 0xA6, 0x09, 0xFC, 0x05, 0x60, 0xCF, 0xC0, 0x16, 0x0E,
  0xFB, 0x0B, 0x60, 0x2F, 0xC0, 0x66, 0x05, 0xFC, 0x01, 0x60, 0x7F, 0xB0, 0xC7, 0x0A, 0xFB, 0x07,
  0x70, 0xDF, 0xB0, 0x16, 0x01, 0xFB, 0x0B, 0x70, 0x4F, 0xB0, 0x57, 0x07, 0xFA, 0x0E, 0x71, 0x0B,
  0xFA, 0x09, 0x71, 0x0E, 0xFA, 0x02, 0x70, 0x3F, 0xA0, 0xB7, 0x10, 0x6F, 0xA0, 0x47, 0x10,
  // "‛" (U+201B)
  0x03, 0xFD, 0x01, 0x40, 0x6F, 0xD0, 0x44, 0x01, 0xFD, 0x07, 0x50, 0xCF, 0xC0, 0x95, 0x08, 0xFC,
  0x0C, 0x50, 0x3F, 0xD6, 0x0D, 0xFC, 0x02, 0x50, 0x8F, 0xC0, 0x55, 0x03, 0xFC, 0x08, 0x60, 0xDF,
  0xB0, 0xB6, 0x07, 0xFB, 0x0E, 0x60, 0x2F, 0xC0, 0x26, 0x0B, 0xFB, 0x05, 0x60, 0x5F, 0xB0, 0x87,
  0x0E, 0xFA, 0x0C, 0x70, 0x8F, 0xB7, 0x02, 0xFB, 0x03, 0x70, 0xBF, 0xA0, 0x67, 0x05, 0xFA, 0x0A,
  0x71, 0x0D, 0xF9, 0x0D, 0x71, 0x07, 0xFA, 0x01, 0x70, 0x10, 0xEF, 0x90, 0x50,
  // "“" (U+201C)
  0x70, 0x10, 0xEF, 0x90, 0x57, 0x20, 0x10, 0xEF, 0x90, 0x57, 0x07, 0xFA, 0x01, 0x72, 0x07, 0xFA,
  0x01, 0x70, 0xDF, 0x90, 0xD7, 0x30, 0xDF, 0x90, 0xD7, 0x05, 0xFA, 0x0A, 0x72, 0x05, 0xFA, 0x0A,
  0x70, 0xBF, 0xA0, 0x67, 0x20, 0xBF, 0xA0, 0x66, 0x02, 0xFB, 0x03, 0x71, 0x02, 0xFB, 0x03, 0x60,
  0x8F, 0xB7, 0x20, 0x8F, 0xB7, 0x0E, 0xFA, 0x0C, 0x72, 0x0E, 0xFA, 0x0C, 0x60, 0x5F, 0xB0, 0x87,
  0x10, 0x5F, 0xB0, 0x86, 0x0B, 0xFB, 0x05, 0x71, 0x0B, 0xFB, 0x05, 0x50, 0x2F, 0xC0, 0x27, 0x02,
  0xFC, 0x02, 0x50, 0x7F, 0xB0, 0xE7, 0x10, 0x7F, 0xB0, 0xE6, 0x0D, 0xFB, 0x0B, 0x71, 0x0D, 0xFB,
  0x0B, 0x50, 0x3F, 0xC0, 0x87, 0x03, 0xFC, 0x08, 0x50, 0x8F, 0xC0, 0x57, 0x08, 0xFC, 0x05, 0x50,
  0xDF, 0xC0, 0x27, 0x0D, 0xFC, 0x02, 0x40, 0x3F, 0xD7, 0x03, 0xFD, 0x50, 0x8F, 0xC0, 0xC7, 0x08,
  0xFC, 0x0C, 0x50, 0xCF, 0xC0, 0x97, 0x0C, 0xFC, 0x09, 0x40, 0x1F, 0xD0, 0x76, 0x01, 0xFD, 0x07,
  0x40, 0x6F, 0xD0, 0x46, 0x06, 0xFD, 0x04, 0x40, 0x3F, 0xD0, 0x16, 0x03, 0xFD, 0x01, 0x40,
  // "”" (U+201D)
  0x40, 0x2F, 0xD0, 0x36, 0x02, 0xFD, 0x03, 0x40, 0x4F, 0xD0, 0x66, 0x04, 0xFD, 0x06, 0x40, 0x7F,
  0xD0, 0x16, 0x07, 0xFD, 0x01, 0x40, 0x9F, 0xC0, 0xC7, 0x09, 0xFC, 0x0C, 0x50, 0xCF, 0xC0, 0x77,
  0x0C, 0xFC, 0x07, 0x5F, 0xD0, 0x37, 0xFD, 0x03, 0x40, 0x2F, 0xC0, 0xD7, 0x02, 0xFC, 0x0D, 0x50,
  0x5F, 0xC0, 0x87, 0x05, 0xFC, 0x08, 0x50, 0x8F, 0xC0, 0x27, 0x08, 0xFC, 0x02, 0x50, 0xBF, 0xB0,
  0xD7, 0x10, 0xBF, 0xB0, 0xD6, 0x0E, 0xFB, 0x07, 0x71, 0x0E, 0xFB, 0x07, 0x50, 0x2F, 0xC0, 0x27,
  0x02, 0xFC, 0x02, 0x50, 0x5F, 0xB0, 0xB7, 0x10, 0x5F, 0xB0, 0xB6, 0x09, 0xFB, 0x05, 0x71, 0x09,
  0xFB, 0x05, 0x60, 0xCF, 0xA0, 0xE7, 0x20, 0xCF, 0xA0, 0xE7, 0xFB, 0x08, 0x72, 0xFB, 0x08, 0x60,
  0x3F, 0xB0, 0x27, 0x10, 0x3F, 0xB0, 0x26, 0x06, 0xFA, 0x0B, 0x72, 0x06, 0xFA, 0x0B, 0x70, 0xAF,
  0xA0, 0x57, 0x20, 0xAF, 0xA0, 0x57, 0x0D, 0xF9, 0x0D, 0x73, 0x0D, 0xF9, 0x0D, 0x70, 0x1F, 0xA0,
  0x77, 0x20, 0x1F, 0xA0, 0x77, 0x05, 0xF9, 0x0E, 0x01, 0x72, 0x05, 0xF9, 0x0E, 0x01, 0x70,
  // "„" (U+201E)
  0x50, 0xBF, 0xC0, 0xE0, 0x15, 0x0B, 0xFC, 0x0E, 0x01, 0x50, 0xEF, 0xD0, 0x25, 0x0E, 0xFD, 0x02,
  0x40, 0x1F, 0xD0, 0xD5, 0x01, 0xFD, 0x0D, 0x50, 0x3F, 0xD0, 0x95, 0x03, 0xFD, 0x09, 0x50, 0x6F,
  0xD0, 0x55, 0x06, 0xFD, 0x05, 0x50, 0x8F, 0xD0, 0x15, 0x08, 0xFD, 0x01, 0x50, 0xBF, 0xC0, 0xC6,
  0x0B, 0xFC, 0x0C, 0x60, 0xEF, 0xC0, 0x86, 0x0E, 0xFC, 0x08, 0x50, 0x1F, 0xD0, 0x45, 0x01, 0xFD,
  0x04, 0x50, 0x4F, 0xC0, 0xE6, 0x04, 0xFC, 0x0E, 0x60, 0x6F, 0xC0, 0xA6, 0x06, 0xFC, 0x0A, 0x60,
  0x9F, 0xC0, 0x56, 0x09, 0xFC, 0x05, 0x60, 0xCF, 0xC0, 0x16, 0x0C, 0xFC, 0x01, 0x60, 0xEF, 0xB0,
  0xB7, 0x0E, 0xFB, 0x0B, 0x60, 0x2F, 0xC0, 0x66, 0x02, 0xFC, 0x06, 0x60, 0x5F, 0xC0, 0x16, 0x05,
  0xFC, 0x01, 0x60, 0x7F, 0xB0, 0xC7, 0x07, 0xFB, 0x0C, 0x70, 0xAF, 0xB0, 0x77, 0x0A, 0xFB, 0x07,
  0x70, 0xDF, 0xB0, 0x17, 0x0D, 0xFB, 0x01, 0x60, 0x1F, 0xB0, 0xB7, 0x01, 0xFB, 0x0B, 0x70, 0x4F,
  0xB0, 0x57, 0x04, 0xFB, 0x05, 0x70, 0x7F, 0xA0, 0xE7, 0x10, 0x7F, 0xA0, 0xE7, 0x10, 0xBF, 0xA0,
  0x97, 0x10, 0xBF, 0xA0, 0x97, 0x10, 0xEF, 0xA0, 0x27, 0x10, 0xEF, 0xA0, 0x27, 0x03, 0xFA, 0x0B,
  0x71, 0x03, 0xFA, 0x0B, 0x71, 0x06, 0xFA, 0x04, 0x71, 0x06, 0xFA, 0x04, 0x71,
  // "‟" (U+201F)
  0x03, 0xFD, 0x01, 0x60, 0x3F, 0xD0, 0x14, 0x06, 0xFD, 0x04, 0x60, 0x6F, 0xD0, 0x44, 0x01, 0xFD,
  0x07, 0x60, 0x1F, 0xD0, 0x75, 0x0C, 0xFC, 0x09, 0x70, 0xCF, 0xC0, 0x95, 0x08, 0xFC, 0x0C, 0x70,
  0x8F, 0xC0, 0xC5, 0x03, 0xFD, 0x70, 0x3F, 0xD6, 0x0D, 0xFC, 0x02, 0x70, 0xDF, 0xC0, 0x25, 0x08,
  0xFC, 0x05, 0x70, 0x8F, 0xC0, 0x55, 0x03, 0xFC, 0x08, 0x70, 0x3F, 0xC0, 0x86, 0x0D, 0xFB, 0x0B,
  0x71, 0x0D, 0xFB, 0x0B, 0x60, 0x7F, 0xB0, 0xE7, 0x10, 0x7F, 0xB0, 0xE6, 0x02, 0xFC, 0x02, 0x70,
  0x2F, 0xC0, 0x26, 0x0B, 0xFB, 0x05, 0x71, 0x0B, 0xFB, 0x05, 0x60, 0x5F, 0xB0, 0x87, 0x10, 0x5F,
  0xB0, 0x87, 0x0E, 0xFA, 0x0C, 0x72, 0x0E, 0xFA, 0x0C, 0x70, 0x8F, 0xB7, 0x20, 0x8F, 0xB7, 0x02,
  0xFB, 0x03, 0x71, 0x02, 0xFB, 0x03, 0x70, 0xBF, 0xA0, 0x67, 0x20, 0xBF, 0xA0, 0x67, 0x05, 0xFA,
  0x0A, 0x72, 0x05, 0xFA, 0x0A, 0x71, 0x0D, 0xF9, 0x0D, 0x73, 0x0D, 0xF9, 0x0D, 0x71, 0x07, 0xFA,
  0x01, 0x72, 0x07, 0xFA, 0x01, 0x70, 0x10, 0xEF, 0x90, 0x57, 0x20, 0x10, 0xEF, 0x90, 0x50,
  // "†" (U+2020)
  0x74, 0x05, 0xFC, 0x06, 0x77, 0x72, 0x03, 0xFC, 0x04, 0x77, 0x72, 0x01, 0xFC, 0x02, 0x77, 0x73,
  0x0E, 0xFB, 0x77, 0x74, 0x0C, 0xFA, 0x0D, 0x77, 0x74, 0x0B, 0xFA, 0x0B, 0x77, 0x74, 0x09, 0xFA,
  0x09, 0x77, 0x74, 0x07, 0xFA, 0x07, 0x77, 0x74, 0x05, 0xFA, 0x05, 0x77, 0x74, 0x03, 0xFA, 0x03,
  0x77, 0x74, 0x01, 0xFA, 0x01, 0x77, 0x75, 0x0E, 0xF9, 0x77, 0x76, 0x0C, 0xF0, 0xD7, 0x77, 0x60,
  0xBF, 0x0B, 0x77, 0x76, 0x09, 0xF0, 0x97, 0x77, 0x60, 0x7F, 0x07, 0x77, 0x76, 0x05, 0xF0, 0x57,
  0x78, 0x46, 0x75, 0x32, 0x17, 0x03, 0xF0, 0x37, 0x18, 0x51, 0x34, 0x57, 0x6C, 0xE8, 0x5D, 0xCA,
  0x97, 0x65, 0xF8, 0x65, 0x57, 0x8A, 0xBC, 0xEE, 0x0B, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0xCF, 0xFF,
  0xFE, 0x0B, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0xCF, 0xFF, 0xFE, 0x0B, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0,
  0xCF, 0xFF, 0xFE, 0x0B, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0xCE, 0x85, 0xEC, 0xB9, 0x86, 0x5F, 0x86,
  0x56, 0x79, 0xAC, 0xDE, 0xE8, 0x5B, 0x77, 0x64, 0x31, 0x70, 0x1F, 0x02, 0x71, 0x84, 0x23, 0x46,
  0x76, 0x76, 0x02, 0xF0, 0x27, 0x77, 0x60, 0x3F, 0x03, 0x77, 0x76, 0x04, 0xF0, 0x47, 0x77, 0x60,
  0x5F, 0x05, 0x77, 0x76, 0x06, 0xF0, 0x67, 0x77, 0x60, 0x7F, 0x07, 0x77, 0x76, 0x07, 0xF0, 0x87,
  0x77, 0x60, 0x8F, 0x09, 0x77, 0x76, 0x09, 0xF0, 0xA7, 0x77, 0x60, 0xAF, 0x0B, 0x77, 0x76, 0x0B,
  0xF0, 0xB7, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x76, 0x0D, 0xF0, 0xD7, 0x77, 0x60, 0xEF, 0x0E, 0x77,
  0x76, 0x0E, 0xF9, 0x77, 0x76, 0xFA, 0x77, 0x75, 0x01, 0xFA, 0x01, 0x77, 0x74, 0x02, 0xFA, 0x02,
  0x77, 0x74, 0x02, 0xFA, 0x03, 0x77, 0x74, 0x03, 0xFA, 0x04, 0x77, 0x74, 0x04, 0xFA, 0x05, 0x77,
  0x74, 0x05, 0xFA, 0x06, 0x77, 0x74, 0x06, 0xFA, 0x07, 0x77, 0x74, 0x07, 0xFA, 0x08, 0x77, 0x74,
  0x08, 0xFA, 0x09, 0x77, 0x74, 0x09, 0xFA, 0x09, 0x77, 0x74, 0x09, 0xFA, 0x0A, 0x77, 0x74, 0x0A,
  0xFA, 0x0B, 0x77, 0x74, 0x0B, 0xFA, 0x0C, 0x77, 0x74, 0x0C, 0xFA, 0x0D, 0x77, 0x74, 0x0D, 0xFA,
  0x0E, 0x77, 0x74, 0x0E, 0xFB, 0x77, 0x74, 0xFC, 0x77, 0x74, 0xFC, 0x01, 0x77, 0x72, 0x01, 0xFC,
  0x02, 0x77, 0x72, 0x02, 0xFC, 0x03, 0x77, 0x72, 0x03, 0xFC, 0x04, 0x77, 0x72, 0x03, 0xFC, 0x05,
  0x77, 0x72, 0x04, 0xFC, 0x06, 0x77, 0x72, 0x05, 0xFC, 0x07, 0x75,
  // "‡" (U+2021)
  0x76, 0x0E, 0xFB, 0x0D, 0x77, 0x75, 0x0C, 0xFB, 0x0B, 0x77, 0x75, 0x0A, 0xFB, 0x09, 0x77, 0x75,
  0x08, 0xFB, 0x06, 0x77, 0x75, 0x06, 0xFB, 0x04, 0x77, 0x75, 0x03, 0xFB, 0x02, 0x77, 0x75, 0x01,
  0xFB, 0x77, 0x77, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x0C, 0xF9, 0x0B, 0x77, 0x77, 0x0A, 0xF9, 0x09,
  0x77, 0x77, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x05, 0xF9, 0x04, 0x77, 0x77, 0x03, 0xF9, 0x02, 0x77,
  0x77, 0x01, 0xF9, 0x77, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x18, 0x21, 0x32, 0x17, 0x40, 0xCE, 0x0B,
  0x74, 0x83, 0x12, 0x40, 0x4C, 0x89, 0x1D, 0xCB, 0x98, 0x65, 0x42, 0x1A, 0xE8, 0x91, 0x91, 0x24,
  0x57, 0x89, 0xBC, 0xDC, 0x02, 0x04, 0x80, 0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F, 0x02, 0x04, 0x80,
  0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F, 0x02, 0x04, 0x80, 0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F, 0x02,
  0x04, 0x80, 0xC0, 0xF0, 0x20, 0x4F, 0xA8, 0x4E, 0xDC, 0xA9, 0xDE, 0x83, 0xC9, 0xAC, 0xDF, 0xB8,
  0x90, 0x23, 0xCA, 0x97, 0x65, 0x32, 0x60, 0xCE, 0x0B, 0x68, 0x72, 0x35, 0x67, 0x9A, 0xC2, 0x77,
  0x1F, 0x0E, 0x77, 0x77, 0x10, 0x3F, 0x90, 0x27, 0x77, 0x70, 0x7F, 0x90, 0x57, 0x77, 0x70, 0xAF,
  0x90, 0x97, 0x77, 0x70, 0xEF, 0x90, 0xC7, 0x77, 0x60, 0x1F, 0xB7, 0x77, 0x60, 0x5F, 0xB0, 0x37,
  0x77, 0x50, 0x8F, 0xB0, 0x77, 0x77, 0x50, 0x8F, 0xB0, 0x77, 0x77, 0x50, 0x5F, 0xB0, 0x47, 0x77,
  0x50, 0x2F, 0xB0, 0x17, 0x77, 0x60, 0xEF, 0x90, 0xD7, 0x77, 0x70, 0xBF, 0x90, 0xA7, 0x77, 0x70,
  0x8F, 0x90, 0x77, 0x77, 0x70, 0x5F, 0x90, 0x47, 0x77, 0x70, 0x2F, 0x97, 0x72, 0x01, 0x76, 0x0E,
  0xE0, 0xD7, 0x68, 0x11, 0x04, 0xA8, 0x90, 0xEC, 0xB9, 0x87, 0x54, 0x21, 0x20, 0xBE, 0x0A, 0x28,
  0x90, 0x12, 0x45, 0x78, 0x9B, 0xCE, 0xA0, 0x20, 0x4F, 0xE0, 0x0E, 0xE0, 0x0E, 0xFE, 0x02, 0x04,
  0x80, 0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F, 0x02, 0x04, 0x80, 0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F,
  0x02, 0x04, 0x80, 0xC0, 0xF0, 0x20, 0x48, 0x0C, 0x0F, 0x02, 0x04, 0xFD, 0x81, 0xDC, 0xDE, 0x81,
  0xDC, 0xDF, 0xD8, 0x92, 0x24, 0xED, 0xCA, 0x97, 0x65, 0x32, 0x40, 0xBE, 0x09, 0x38, 0x92, 0x12,
  0x35, 0x68, 0x9A, 0xCD, 0xF2, 0x77, 0x10, 0xDE, 0x0C, 0x77, 0x77, 0x2F, 0x0E, 0x77, 0x77, 0x10,
  0x2F, 0x90, 0x17, 0x77, 0x70, 0x4F, 0x90, 0x37, 0x77, 0x70, 0x7F, 0x90, 0x57, 0x77, 0x70, 0x9F,
  0x90, 0x87, 0x77, 0x70, 0xBF, 0x90, 0xA7, 0x77, 0x70, 0xEF, 0x90, 0xC7, 0x77, 0x7F, 0xA0, 0xE7,
  0x77, 0x60, 0x3F, 0xB0, 0x17, 0x77, 0x50, 0x5F, 0xB0, 0x47, 0x77, 0x50, 0x7F, 0xB0, 0x67, 0x77,
  0x50, 0xAF, 0xB0, 0x87, 0x77, 0x50, 0xCF, 0xB0, 0xB7, 0x77, 0x50, 0xEF, 0xB0, 0xD7, 0x60,
  // "•" (U+2022)
  0x71, 0x89, 0x04, 0x8C, 0xDE, 0xED, 0xC8, 0x47, 0x70, 0x70, 0xDF, 0xB0, 0xD0, 0x67, 0x30, 0x20,
  0xCF, 0xF0, 0xC0, 0x27, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x35, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x14,
  0x0A, 0xFF, 0xE0, 0xA3, 0x02, 0xFF, 0xF9, 0x02, 0x20, 0x8F, 0xFF, 0x90, 0x72, 0x0C, 0xFF, 0xF9,
  0x0C, 0x2F, 0xFF, 0xB1, 0x02, 0xFF, 0xFB, 0x02, 0x03, 0xFF, 0xFB, 0x03, 0x04, 0xFF, 0xFB, 0x00,
  0x4F, 0xFF, 0xB0, 0x04, 0xFF, 0xFB, 0x04, 0x03, 0xFF, 0xFB, 0x00, 0x2F, 0xFF, 0xB8, 0x11, 0x0E,
  0xFF, 0xF9, 0x0E, 0x20, 0xBF, 0xFF, 0x90, 0xA2, 0x07, 0xFF, 0xF9, 0x07, 0x20, 0x1F, 0xFF, 0x0E,
  0x01, 0x30, 0x9F, 0xFE, 0x08, 0x40, 0x10, 0xDF, 0xFC, 0x0C, 0x60, 0x20, 0xEF, 0xFA, 0x0D, 0x01,
  0x70, 0x10, 0xBF, 0xF0, 0xB0, 0x17, 0x30, 0x60, 0xDF, 0xB0, 0xD0, 0x57, 0x78, 0x90, 0x48, 0xCD,
  0xEE, 0xDC, 0x84, 0x71,
  // "…" (U+2026)
  0x48, 0x71, 0x7B, 0xDF, 0xED, 0xA6, 0x72, 0x87, 0x17, 0xBD, 0xFE, 0xDA, 0x67, 0x28, 0x71, 0x7B,
  0xDF, 0xED, 0xA6, 0x70, 0x7F, 0xA0, 0xE0, 0x46, 0x07, 0xFA, 0x0E, 0x04, 0x60, 0x7F, 0xA0, 0xE0,
  0x44, 0x08, 0xFD, 0x04, 0x40, 0x8F, 0xD0, 0x44, 0x08, 0xFD, 0x04, 0x20, 0x3F, 0xE0, 0xE0, 0x12,
  0x03, 0xFE, 0x0E, 0x01, 0x20, 0x3F, 0xE8, 0x2E, 0x10, 0xAF, 0xF0, 0x72, 0x0A, 0xFF, 0x07, 0x20,
  0xAF, 0xF8, 0x17, 0x0E, 0xFF, 0x0C, 0x20, 0xEF, 0xF0, 0xC2, 0x0E, 0xFF, 0x0C, 0x01, 0xFF, 0xA1,
  0x01, 0xFF, 0xA1, 0x01, 0xFF, 0xA0, 0x2F, 0xFA, 0x10, 0x2F, 0xFA, 0x10, 0x2F, 0xFA, 0x02, 0xFF,
  0xA1, 0x02, 0xFF, 0xA1, 0x02, 0xFF, 0xA0, 0x1F, 0xFA, 0x10, 0x1F, 0xFA, 0x10, 0x1F, 0xFA, 0x10,
  0xDF, 0xF0, 0xB2, 0x0D, 0xFF, 0x0B, 0x20, 0xDF, 0xF8, 0x1B, 0x08, 0xFF, 0x06, 0x20, 0x8F, 0xF0,
  0x62, 0x08, 0xFF, 0x81, 0x60, 0x1F, 0xE0, 0xD3, 0x01, 0xFE, 0x0D, 0x30, 0x1F, 0xE0, 0xD3, 0x05,
  0xFD, 0x03, 0x40, 0x5F, 0xD0, 0x34, 0x05, 0xFD, 0x03, 0x40, 0x50, 0xEF, 0x90, 0xD0, 0x36, 0x05,
  0x0E, 0xF9, 0x0D, 0x03, 0x60, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x73,
  0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x73, 0x86, 0x6B, 0xDF, 0xED, 0xA5, 0x40,
  // "‰" (U+2030)
  0x68, 0x72, 0x8C, 0xEF, 0xDB, 0x71, 0x80, 0xC6, 0x00, 0x8F, 0x90, 0xE0, 0x68, 0x0C, 0x40, 0x0B,
  0xFC, 0x09, 0x80, 0xC2, 0x00, 0xAF, 0xE0, 0x78, 0x0C, 0x00, 0x04, 0xFF, 0x90, 0x27, 0x77, 0x77,
  0x0D, 0xFF, 0x90, 0xB7, 0x77, 0x76, 0x03, 0xFF, 0xB0, 0x17, 0x77, 0x75, 0x08, 0xF8, 0x16, 0x06,
  0xF0, 0x77, 0x77, 0x75, 0x0C, 0xE0, 0xA3, 0x0C, 0xE0, 0xB7, 0x77, 0x75, 0xF0, 0x53, 0x07, 0xE0,
  0xE7, 0x77, 0x74, 0x02, 0xF0, 0x33, 0x05, 0xF0, 0x17, 0x77, 0x73, 0x03, 0xF0, 0x13, 0x03, 0xF0,
  0x37, 0x77, 0x73, 0x04, 0xF4, 0x02, 0xF0, 0x37, 0x77, 0x73, 0x05, 0xF4, 0x02, 0xF0, 0x47, 0x77,
  0x73, 0x05, 0xF4, 0x02, 0xF0, 0x47, 0x77, 0x73, 0x04, 0xF4, 0x02, 0xF0, 0x37, 0x77, 0x73, 0x03,
  0xF0, 0x13, 0x03, 0xF0, 0x37, 0x77, 0x73, 0x02, 0xF0, 0x33, 0x05, 0xF0, 0x17, 0x48, 0x06, 0x17,
  0x40, 0xEE, 0x05, 0x30, 0x7E, 0x0E, 0x73, 0x02, 0x0C, 0xF9, 0x0E, 0x05, 0x74, 0x0C, 0xE0, 0xB3,
  0x0C, 0xE0, 0xB7, 0x20, 0x50, 0xEF, 0x90, 0xC0, 0x27, 0x50, 0x7F, 0x81, 0x60, 0x6F, 0x07, 0x71,
  0x0A, 0xFA, 0x08, 0x77, 0x02, 0xFF, 0xB0, 0x26, 0x03, 0x0D, 0xF9, 0x0E, 0x04, 0x77, 0x20, 0xBF,
  0xF9, 0x0C, 0x60, 0x7F, 0xA0, 0xB0, 0x17, 0x73, 0x03, 0xFF, 0x90, 0x34, 0x01, 0x0B, 0xFA, 0x07,
  0x77, 0x60, 0x8F, 0xE0, 0x94, 0x04, 0x0E, 0xF9, 0x0D, 0x03, 0x77, 0x71, 0x0A, 0xFC, 0x0B, 0x40,
  0x8F, 0xA0, 0xA7, 0x77, 0x40, 0x7F, 0xA0, 0x83, 0x02, 0x0C, 0xF9, 0x0E, 0x05, 0x77, 0x76, 0x87,
  0x27, 0xCE, 0xFD, 0xB7, 0x23, 0x05, 0x0E, 0xF9, 0x0C, 0x02, 0x80, 0xC3, 0x00, 0x9F, 0xA0, 0x88,
  0x0C, 0x30, 0x03, 0x0D, 0xF9, 0x0E, 0x04, 0x80, 0xC3, 0x00, 0x6F, 0xA0, 0xB0, 0x18, 0x0C, 0x20,
  0x01, 0x0B, 0xFA, 0x07, 0x80, 0xC3, 0x00, 0x40, 0xDF, 0x90, 0xD0, 0x38, 0x0C, 0x30, 0x08, 0xFA,
  0x0A, 0x01, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0xE0, 0x68, 0x0C, 0x30, 0x05, 0x0E, 0xF9, 0x0C,
  0x02, 0x80, 0xC3, 0x00, 0x9F, 0xA0, 0x98, 0x0C, 0x30, 0x02, 0x0D, 0xF9, 0x0E, 0x04, 0x80, 0xC3,
  0x00, 0x6F, 0xA0, 0xB0, 0x18, 0x0C, 0x20, 0x01, 0x0A, 0xFA, 0x07, 0x38, 0x73, 0x8C, 0xEF, 0xDB,
  0x71, 0x75, 0x87, 0x38, 0xCE, 0xFD, 0xB7, 0x17, 0x05, 0x80, 0x57, 0x03, 0x20, 0x10, 0xAF, 0xA0,
  0x77, 0x20, 0x10, 0xAF, 0xA0, 0x77, 0x74, 0x01, 0x0D, 0xFC, 0x0A, 0x70, 0x10, 0xDF, 0xC0, 0xB7,
  0x73, 0x0D, 0xFE, 0x09, 0x60, 0xCF, 0xE0, 0xA7, 0x71, 0x07, 0xFF, 0x90, 0x34, 0x06, 0xFF, 0x90,
  0x47, 0x70, 0xEF, 0xF9, 0x0C, 0x40, 0xEF, 0xF9, 0x0D, 0x76, 0x05, 0xFF, 0xB0, 0x22, 0x04, 0xFF,
  0xB0, 0x37, 0x50, 0xAF, 0x81, 0x50, 0x5F, 0x08, 0x20, 0x9F, 0x81, 0x60, 0x5F, 0x09, 0x75, 0x0E,
  0xE0, 0xA3, 0x0B, 0xE0, 0xC2, 0x0D, 0xE0, 0xA3, 0x0B, 0xE0, 0xD7, 0x40, 0x1F, 0x05, 0x30, 0x7E,
  0x0E, 0x2F, 0x05, 0x30, 0x6F, 0x74, 0x03, 0xF0, 0x33, 0x04, 0xF0, 0x02, 0xF0, 0x33, 0x03, 0xF0,
  0x37, 0x30, 0x4F, 0x02, 0x30, 0x3F, 0x00, 0x3F, 0x01, 0x30, 0x2F, 0x04, 0x73, 0x05, 0xF0, 0x13,
  0x02, 0xF0, 0x04, 0xF0, 0x13, 0x01, 0xF0, 0x57, 0x30, 0x5F, 0x01, 0x30, 0x2F, 0x00, 0x4F, 0x40,
  0x1F, 0x05, 0x73, 0x05, 0xF0, 0x13, 0x02, 0xF0, 0x30, 0x4F, 0x01, 0x30, 0x1F, 0x04, 0x73, 0x04,
  0xF0, 0x23, 0x03, 0xF0, 0x03, 0xF0, 0x13, 0x02, 0xF0, 0x47, 0x30, 0x3F, 0x03, 0x30, 0x4F, 0x00,
  0x2F, 0x03, 0x30, 0x3F, 0x03, 0x74, 0xF0, 0x63, 0x07, 0xE0, 0xE2, 0x0E, 0xE0, 0x63, 0x06, 0xF7,
  0x50, 0xDE, 0x0A, 0x30, 0xBE, 0x0C, 0x20, 0xCE, 0x0A, 0x30, 0xBE, 0x0D, 0x75, 0x09, 0xF8, 0x15,
  0x05, 0xF0, 0x82, 0x08, 0xF8, 0x16, 0x05, 0xF0, 0x97, 0x50, 0x4F, 0xFB, 0x03, 0x20, 0x3F, 0xFB,
  0x04, 0x76, 0x0D, 0xFF, 0x90, 0xC4, 0x0C, 0xFF, 0x90, 0xD7, 0x70, 0x5F, 0xF9, 0x04, 0x40, 0x4F,
  0xF9, 0x05, 0x77, 0x10, 0xAF, 0xE0, 0xA6, 0x09, 0xFE, 0x0B, 0x77, 0x30, 0xCF, 0xC0, 0xB7, 0x10,
  0xBF, 0xC0, 0xC7, 0x75, 0x08, 0xFA, 0x08, 0x73, 0x08, 0xFA, 0x08, 0x77, 0x78, 0x72, 0x8C, 0xEF,
  0xDB, 0x72, 0x75, 0x87, 0x28, 0xCE, 0xFD, 0xC7, 0x26,
  // "‹" (U+2039)
  0x77, 0x20, 0xA0, 0x57, 0x77, 0x20, 0x9A, 0x0C, 0x04, 0x77, 0x60, 0x7D, 0x0B, 0x02, 0x77, 0x30,
  0x4F, 0x90, 0x90, 0x17, 0x70, 0x20, 0xEF, 0xA0, 0xE0, 0x87, 0x60, 0xDF, 0xD0, 0x57, 0x40, 0xBF,
  0xD0, 0x97, 0x40, 0x8F, 0xD0, 0xB7, 0x40, 0x5F, 0xD0, 0xD0, 0x17, 0x30, 0x3F, 0xE0, 0x37, 0x30,
  0x10, 0xDF, 0xD0, 0x67, 0x40, 0xCF, 0xD0, 0x97, 0x40, 0x9F, 0xD0, 0xB7, 0x40, 0x7F, 0xD0, 0xD0,
  0x17, 0x30, 0x4F, 0xE0, 0x37, 0x30, 0x20, 0xEF, 0xD0, 0x67, 0x30, 0x10, 0xDF, 0xD0, 0x97, 0x40,
  0xBF, 0xD0, 0xB7, 0x40, 0x8F, 0xD0, 0xD0, 0x17, 0x30, 0x5F, 0xE0, 0x37, 0x40, 0xAF, 0xD0, 0xA7,
  0x50, 0x5F, 0xE0, 0x47, 0x50, 0x7F, 0xD0, 0xE0, 0x27, 0x50, 0xAF, 0xD0, 0xD7, 0x60, 0xCF, 0xD0,
  0xA7, 0x50, 0x10, 0xEF, 0xD0, 0x77, 0x50, 0x3F, 0xE0, 0x47, 0x50, 0x6F, 0xD0, 0xE0, 0x27, 0x50,
  0x8F, 0xD0, 0xD7, 0x60, 0xBF, 0xD0, 0xA7, 0x50, 0x10, 0xDF, 0xD0, 0x77, 0x50, 0x20, 0xEF, 0xD0,
  0x47, 0x50, 0x4F, 0xD0, 0xE0, 0x27, 0x50, 0x7F, 0xD0, 0xD7, 0x60, 0x9F, 0xD0, 0xA7, 0x60, 0xCF,
  0xD0, 0x67, 0x50, 0x10, 0xDF, 0xA0, 0xD0, 0x67, 0x70, 0x3F, 0x0E, 0x07, 0x77, 0x30, 0x5D, 0x09,
  0x01, 0x77, 0x50, 0x8A, 0x0A, 0x02, 0x77, 0x71, 0x08, 0x03, 0x71,
  // "›" (U+203A)
  0x71, 0x03, 0x08, 0x77, 0x71, 0x02, 0x0A, 0xA0, 0x87, 0x75, 0x01, 0x09, 0xD0, 0x57, 0x73, 0x07,
  0x0E, 0xE0, 0xE0, 0x37, 0x70, 0x50, 0xDF, 0xA0, 0xD0, 0x17, 0x50, 0x6F, 0xD0, 0xC7, 0x60, 0xAF,
  0xD0, 0x97, 0x60, 0xDF, 0xD0, 0x77, 0x50, 0x20, 0xEF, 0xD0, 0x47, 0x50, 0x4F, 0xD0, 0xE0, 0x27,
  0x50, 0x7F, 0xD0, 0xD0, 0x17, 0x50, 0xAF, 0xD0, 0xB7, 0x60, 0xDF, 0xD0, 0x87, 0x50, 0x20, 0xEF,
  0xD0, 0x67, 0x50, 0x4F, 0xE0, 0x37, 0x50, 0x7F, 0xD0, 0xE0, 0x17, 0x50, 0xAF, 0xD0, 0xC7, 0x60,
  0xDF, 0xD0, 0xA7, 0x50, 0x20, 0xEF, 0xD0, 0x77, 0x50, 0x4F, 0xE0, 0x57, 0x50, 0xAF, 0xD0, 0xA7,
  0x40, 0x3F, 0xE0, 0x57, 0x30, 0x10, 0xDF, 0xD0, 0x87, 0x40, 0xBF, 0xD0, 0xB7, 0x40, 0x9F, 0xD0,
  0xD0, 0x17, 0x30, 0x6F, 0xD0, 0xE0, 0x27, 0x30, 0x3F, 0xE0, 0x47, 0x30, 0x10, 0xDF, 0xD0, 0x77,
  0x40, 0xBF, 0xD0, 0x97, 0x40, 0x9F, 0xD0, 0xC7, 0x40, 0x6F, 0xD0, 0xD0, 0x17, 0x30, 0x3F, 0xE0,
  0x37, 0x30, 0x10, 0xDF, 0xD0, 0x57, 0x40, 0xBF, 0xD0, 0x87, 0x40, 0x9F, 0xD0, 0xB7, 0x40, 0x5F,
  0xD0, 0xD7, 0x60, 0x80, 0xEF, 0xA0, 0xE0, 0x27, 0x70, 0x10, 0x9F, 0x90, 0x47, 0x73, 0x02, 0x0B,
  0xD0, 0x77, 0x76, 0x04, 0x0C, 0xA0, 0x97, 0x77, 0x20, 0x50, 0xA7, 0x72,
  // "⁄" (U+2044)
  0x77, 0x75, 0x0C, 0xF9, 0x0C, 0x77, 0x74, 0x03, 0xFA, 0x05, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77,
  0x74, 0x01, 0xFA, 0x08, 0x77, 0x74, 0x07, 0xFA, 0x02, 0x77, 0x74, 0x0D, 0xF9, 0x0B, 0x77, 0x74,
  0x04, 0xFA, 0x05, 0x77, 0x74, 0x0B, 0xF9, 0x0D, 0x77, 0x74, 0x02, 0xFA, 0x07, 0x77, 0x74, 0x08,
  0xFA, 0x01, 0x77, 0x74, 0x0E, 0xF9, 0x0A, 0x77, 0x74, 0x05, 0xFA, 0x04, 0x77, 0x74, 0x0C, 0xF9,
  0x0D, 0x77, 0x74, 0x02, 0xFA, 0x07, 0x77, 0x74, 0x09, 0xFA, 0x01, 0x77, 0x74, 0x0E, 0xF9, 0x09,
  0x77, 0x74, 0x06, 0xFA, 0x03, 0x77, 0x74, 0x0C, 0xF9, 0x0C, 0x77, 0x74, 0x03, 0xFA, 0x06, 0x77,
  0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x74, 0x01, 0xFA, 0x09, 0x77, 0x74, 0x07, 0xFA, 0x02, 0x77, 0x74,
  0x0D, 0xF9, 0x0B, 0x77, 0x74, 0x04, 0xFA, 0x05, 0x77, 0x74, 0x0B, 0xF9, 0x0E, 0x77, 0x74, 0x02,
  0xFA, 0x08, 0x77, 0x74, 0x08, 0xFA, 0x01, 0x77, 0x74, 0x0E, 0xF9, 0x0A, 0x77, 0x74, 0x05, 0xFA,
  0x04, 0x77, 0x74, 0x0C, 0xF9, 0x0D, 0x77, 0x74, 0x03, 0xFA, 0x07, 0x77, 0x74, 0x09, 0xFA, 0x01,
  0x77, 0x74, 0x0E, 0xF9, 0x0A, 0x77, 0x74, 0x06, 0xFA, 0x03, 0x77, 0x74, 0x0D, 0xF9, 0x0C, 0x77,
  0x74, 0x04, 0xFA, 0x06, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x77, 0x74, 0x01, 0xFA, 0x09, 0x77, 0x74,
  0x07, 0xFA, 0x02, 0x77, 0x74, 0x0D, 0xF9, 0x0C, 0x77, 0x74, 0x04, 0xFA, 0x05, 0x77, 0x74, 0x0B,
  0xF9, 0x0E, 0x77, 0x74, 0x02, 0xFA, 0x08, 0x77, 0x74, 0x08, 0xFA, 0x02, 0x77, 0x74, 0x0E, 0xF9,
  0x0B, 0x77, 0x74, 0x05, 0xFA, 0x04, 0x77, 0x74, 0x0C, 0xF9, 0x0D, 0x77, 0x74, 0x03, 0xFA, 0x07,
  0x77, 0x74, 0x09, 0xFA, 0x01, 0x77, 0x73, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x74, 0x06, 0xFA, 0x04,
  0x77, 0x74, 0x0D, 0xF9, 0x0D, 0x77, 0x74, 0x04, 0xFA, 0x06, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x01,
  0x77, 0x73, 0x01, 0xFA, 0x09, 0x77, 0x74, 0x07, 0xFA, 0x03, 0x77, 0x74, 0x0D, 0xF9, 0x0C, 0x77,
  0x74, 0x05, 0xFA, 0x05, 0x77, 0x74, 0x0B, 0xF9, 0x0E, 0x77, 0x74, 0x02, 0xFA, 0x08, 0x77, 0x74,
  0x08, 0xFA, 0x02, 0x77, 0x74, 0x0E, 0xF9, 0x0B, 0x77, 0x74, 0x05, 0xFA, 0x05, 0x77, 0x74, 0x0C,
  0xF9, 0x0E, 0x77, 0x75,
  // "™" (U+2122)
  0xFF, 0xF9, 0x81, 0x20, 0x6F, 0xA0, 0x27, 0x20, 0x8F, 0xFF, 0xFB, 0x81, 0x20, 0x6F, 0xA0, 0x77,
  0x20, 0xDF, 0xFF, 0xFB, 0x81, 0x20, 0x6F, 0xA0, 0xC7, 0x10, 0x3F, 0xFF, 0xFC, 0x81, 0x20, 0x6F,
  0xB0, 0x27, 0x08, 0xFF, 0xFF, 0xC8, 0x12, 0x06, 0xFB, 0x07, 0x70, 0xDF, 0xFF, 0xFC, 0x81, 0x20,
  0x6F, 0xB0, 0xC6, 0x03, 0xFC, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6F, 0xC0, 0x15, 0x09, 0xFC, 0x71,
  0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0B, 0x0E, 0xC0, 0x65, 0x0E, 0xC0, 0xBE, 0x71, 0x0C, 0xD0, 0xB7,
  0x20, 0x6D, 0x00, 0xAC, 0x0B, 0x40, 0x4C, 0x0D, 0x07, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0,
  0xB0, 0x5D, 0x01, 0x30, 0x9C, 0x00, 0x8E, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0C, 0x01, 0xD0,
  0x53, 0x0E, 0xC0, 0x20, 0x8E, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x81, 0xC0, 0xBC, 0x0A, 0x20,
  0x4C, 0x81, 0xC0, 0x9E, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x81, 0xD0, 0x6D, 0x20, 0x9C, 0x81,
  0x70, 0x9E, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x81, 0xD0, 0x1D, 0x81, 0x50, 0xEC, 0x81, 0x20,
  0xAE, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x20, 0xBC, 0x0A, 0x05, 0xC0, 0xC2, 0x0A, 0xE7,
  0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD2, 0x06, 0xC0, 0xE0, 0xAC, 0x07, 0x20, 0xAE, 0x71, 0x0C,
  0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x20, 0x1F, 0xB0, 0x12, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06,
  0xD0, 0xD3, 0x0C, 0xF9, 0x0C, 0x30, 0xAE, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x30, 0x7F,
  0x90, 0x63, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD3, 0x02, 0xF9, 0x01, 0x30, 0xAE,
  0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x40, 0xDE, 0x0B, 0x40, 0xAE, 0x71, 0x0C, 0xD0, 0xB7,
  0x20, 0x6D, 0x0D, 0x40, 0x8E, 0x06, 0x40, 0xAE, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x40,
  0x3E, 0x01, 0x40, 0xAE, 0x71, 0x0C, 0xD0, 0xB7, 0x20, 0x6D, 0x0D, 0x58, 0x45, 0x66, 0x66, 0x55,
  0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72,
  0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE7,
  0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0,
  0xD7, 0x72, 0x0A, 0xE7, 0x10, 0xCD, 0x0B, 0x72, 0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE7, 0x10, 0xCD,
  0x0B, 0x72, 0x06, 0xD0, 0xD7, 0x72, 0x0A, 0xE0,
  // "⅒" (U+2152)
  0x75, 0x08, 0xF7, 0x77, 0x75, 0x0C, 0xF9, 0x0C, 0x80, 0xF7, 0x00, 0x20, 0xCF, 0x97, 0x77, 0x74,
  0x03, 0xFA, 0x05, 0x80, 0xF6, 0x00, 0x7F, 0xB7, 0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x80, 0xF5, 0x00,
  0x20, 0xBF, 0xC7, 0x77, 0x73, 0x01, 0xFA, 0x08, 0x80, 0xF4, 0x00, 0x60, 0xEF, 0xD7, 0x77, 0x73,
  0x07, 0xFA, 0x02, 0x80, 0xF2, 0x00, 0x10, 0xBF, 0xF7, 0x77, 0x73, 0x0D, 0xF9, 0x0B, 0x80, 0xF2,
  0x00, 0x50, 0xEF, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0xA0, 0x58, 0x0F, 0x00, 0x01, 0x0A, 0xFF, 0xB7,
  0x77, 0x72, 0x0B, 0xF9, 0x0D, 0x80, 0xF0, 0x00, 0x40, 0xDF, 0xFC, 0x77, 0x77, 0x10, 0x2F, 0xA0,
  0x78, 0x0F, 0x00, 0x0A, 0xFF, 0xD7, 0x77, 0x71, 0x08, 0xFA, 0x01, 0x80, 0xF0, 0x00, 0x10, 0xEF,
  0x90, 0xE0, 0xAF, 0x97, 0x77, 0x71, 0x0E, 0xF9, 0x0A, 0x80, 0xF2, 0x00, 0x6F, 0x81, 0xB1, 0x6F,
  0x97, 0x77, 0x70, 0x5F, 0xA0, 0x48, 0x0F, 0x30, 0x0B, 0xC0, 0xE0, 0x62, 0x06, 0xF9, 0x77, 0x77,
  0x0C, 0xF9, 0x0D, 0x80, 0xF4, 0x00, 0x2B, 0x0B, 0x01, 0x30, 0x7F, 0x97, 0x77, 0x60, 0x2F, 0xA0,
  0x78, 0x0F, 0x50, 0x81, 0x7E, 0x55, 0x08, 0xF9, 0x77, 0x76, 0x09, 0xFA, 0x01, 0x80, 0xF6, 0x00,
  0x16, 0x08, 0xF9, 0x77, 0x76, 0x0E, 0xF9, 0x09, 0x80, 0x98, 0x60, 0x08, 0xF9, 0x77, 0x75, 0x06,
  0xFA, 0x03, 0x80, 0x98, 0x60, 0x09, 0xF9, 0x77, 0x75, 0x0C, 0xF9, 0x0C, 0x80, 0x98, 0x70, 0x09,
  0xF9, 0x77, 0x74, 0x03, 0xFA, 0x06, 0x80, 0x98, 0x70, 0x09, 0xF9, 0x77, 0x74, 0x0A, 0xF9, 0x0E,
  0x80, 0x99, 0x00, 0x09, 0xF9, 0x77, 0x73, 0x01, 0xFA, 0x09, 0x80, 0x99, 0x00, 0x09, 0xF9, 0x77,
  0x73, 0x07, 0xFA, 0x02, 0x80, 0x99, 0x00, 0x09, 0xF9, 0x77, 0x73, 0x0D, 0xF9, 0x0B, 0x80, 0x99,
  0x10, 0x09, 0xF9, 0x77, 0x72, 0x04, 0xFA, 0x05, 0x80, 0x99, 0x10, 0x09, 0xF9, 0x77, 0x72, 0x0B,
  0xF9, 0x0E, 0x80, 0xD1, 0x08, 0x92, 0x48, 0xBD, 0xEF, 0xEE, 0xC9, 0x51, 0x77, 0x70, 0x9F, 0x97,
  0x77, 0x10, 0x2F, 0xA0, 0x87, 0x72, 0x08, 0xF7, 0x74, 0x81, 0x18, 0xEF, 0xD0, 0xA0, 0x37, 0x75,
  0x09, 0xF9, 0x77, 0x71, 0x08, 0xFA, 0x01, 0x77, 0x02, 0x0C, 0xF9, 0x77, 0x30, 0x40, 0xEF, 0xFA,
  0x09, 0x77, 0x40, 0x9F, 0x97, 0x77, 0x10, 0xEF, 0x90, 0xA7, 0x70, 0x7F, 0xB7, 0x72, 0x07, 0xFF,
  0xD0, 0xC0, 0x17, 0x72, 0x09, 0xF9, 0x77, 0x70, 0x5F, 0xA0, 0x47, 0x50, 0x20, 0xBF, 0xC7, 0x71,
  0x06, 0xFF, 0xF0, 0xD0, 0x17, 0x71, 0x09, 0xF9, 0x77, 0x70, 0xCF, 0x90, 0xD7, 0x50, 0x60, 0xEF,
  0xD7, 0x70, 0x2F, 0xFF, 0xA0, 0xC7, 0x71, 0x09, 0xF9, 0x77, 0x60, 0x3F, 0xA0, 0x77, 0x30, 0x10,
  0xBF, 0xF7, 0x70, 0xCF, 0xFF, 0xB0, 0x77, 0x70, 0x9F, 0x97, 0x76, 0x09, 0xFA, 0x01, 0x72, 0x05,
  0x0E, 0xFF, 0x97, 0x60, 0x5F, 0xC8, 0x2B, 0x99, 0xBF, 0xB0, 0xE0, 0x17, 0x18, 0x42, 0x34, 0x67,
  0xCF, 0x98, 0x49, 0x76, 0x43, 0x17, 0x70, 0xEF, 0x90, 0xA7, 0x10, 0x10, 0xAF, 0xFB, 0x76, 0x0C,
  0xFA, 0x0A, 0x01, 0x40, 0x10, 0x9F, 0xA0, 0x94, 0x81, 0x7D, 0xEF, 0xFF, 0x90, 0xD0, 0xA7, 0x30,
  0x6F, 0xA0, 0x37, 0x04, 0x0D, 0xFF, 0xC7, 0x50, 0x3F, 0xA0, 0x97, 0x10, 0x6F, 0x90, 0xE4, 0x09,
  0xFF, 0xFC, 0x0D, 0x73, 0x0D, 0xF9, 0x0C, 0x71, 0x0A, 0xFF, 0xD7, 0x50, 0x8F, 0x90, 0xC7, 0x30,
  0xAF, 0x90, 0x53, 0x09, 0xFF, 0xFC, 0x0D, 0x72, 0x04, 0xFA, 0x06, 0x71, 0x01, 0x0E, 0xF9, 0x0E,
  0x0A, 0xF9, 0x75, 0x0C, 0xF9, 0x05, 0x73, 0x02, 0xF9, 0x0A, 0x30, 0x9F, 0xFF, 0xC0, 0xD7, 0x20,
  0xAF, 0x90, 0xE7, 0x30, 0x6F, 0x81, 0xB1, 0x6F, 0x97, 0x5F, 0x90, 0xE7, 0x50, 0xAF, 0x0E, 0x30,
  0x9F, 0xFF, 0xC0, 0xD7, 0x10, 0x1F, 0xA0, 0x97, 0x40, 0xBC, 0x0E, 0x06, 0x20, 0x6F, 0x97, 0x40,
  0x3F, 0x90, 0xB7, 0x50, 0x6F, 0x90, 0x22, 0x09, 0xFF, 0xFC, 0x0D, 0x71, 0x07, 0xFA, 0x02, 0x74,
  0x02, 0xB0, 0xB0, 0x13, 0x07, 0xF9, 0x74, 0x06, 0xF9, 0x07, 0x75, 0x02, 0xF9, 0x05, 0x80, 0xC1,
  0x00, 0xDF, 0x90, 0xC7, 0x68, 0x17, 0xE5, 0x50, 0x8F, 0x97, 0x40, 0x8F, 0x90, 0x57, 0x6F, 0x90,
  0x78, 0x0C, 0x00, 0x04, 0xFA, 0x05, 0x77, 0x01, 0x60, 0x8F, 0x97, 0x40, 0x9F, 0x90, 0x37, 0x60,
  0xDF, 0x08, 0x80, 0xC0, 0x00, 0xBF, 0x90, 0xE7, 0x77, 0x10, 0x8F, 0x97, 0x40, 0xAF, 0x90, 0x27,
  0x60, 0xCF, 0x0A, 0x77, 0x77, 0x70, 0x2F, 0xA0, 0x87, 0x77, 0x10, 0x9F, 0x97, 0x40, 0xBF, 0x90,
  0x17, 0x60, 0xBF, 0x0A, 0x77, 0x77, 0x70, 0x8F, 0xA0, 0x27, 0x77, 0x10, 0x9F, 0x97, 0x40, 0xBF,
  0x90, 0x17, 0x60, 0xBF, 0x0B, 0x77, 0x77, 0x70, 0xEF, 0x90, 0xB7, 0x77, 0x20, 0x9F, 0x97, 0x40,
  0xBF, 0x90, 0x17, 0x60, 0xBF, 0x0B, 0x77, 0x77, 0x60, 0x5F, 0xA0, 0x47, 0x77, 0x20, 0x9F, 0x97,
  0x40, 0xAF, 0x90, 0x17, 0x60, 0xBF, 0x0A, 0x77, 0x77, 0x60, 0xCF, 0x90, 0xD7, 0x77, 0x30, 0x9F,
  0x97, 0x40, 0xAF, 0x90, 0x27, 0x60, 0xCF, 0x09, 0x77, 0x77, 0x50, 0x3F, 0xA0, 0x77, 0x77, 0x30,
  0x9F, 0x97, 0x40, 0x8F, 0x90, 0x37, 0x60, 0xEF, 0x08, 0x77, 0x77, 0x50, 0x9F, 0xA0, 0x17, 0x77,
  0x30, 0x9F, 0x97, 0x40, 0x7F, 0x90, 0x57, 0x6F, 0x90, 0x77, 0x77, 0x74, 0x01, 0x0E, 0xF9, 0x0A,
  0x77, 0x74, 0x09, 0xF9, 0x74, 0x04, 0xF9, 0x07, 0x75, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x40, 0x6F,
  0xA0, 0x47, 0x77, 0x40, 0x9F, 0x97, 0x40, 0x2F, 0x90, 0xB7, 0x50, 0x7F, 0x90, 0x17, 0x77, 0x74,
  0x0D, 0xF9, 0x0D, 0x77, 0x75, 0x09, 0xF9, 0x75, 0x0E, 0xF0, 0xE7, 0x50, 0xBF, 0x0E, 0x77, 0x77,
  0x40, 0x4F, 0xA0, 0x67, 0x77, 0x50, 0x9F, 0x97, 0x50, 0xAF, 0x90, 0x57, 0x30, 0x2F, 0x90, 0xB7,
  0x77, 0x74, 0x0A, 0xF9, 0x0E, 0x01, 0x77, 0x75, 0x09, 0xF9, 0x75, 0x05, 0xF9, 0x0D, 0x73, 0x0A,
  0xF9, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xA0, 0x97, 0x77, 0x60, 0x9F, 0x97, 0x60, 0xEF, 0x90, 0x97,
  0x10, 0x7F, 0x90, 0xE7, 0x77, 0x74, 0x07, 0xFA, 0x03, 0x77, 0x76, 0x09, 0xF9, 0x76, 0x09, 0xFA,
  0x0A, 0x01, 0x40, 0x10, 0x9F, 0xA0, 0x97, 0x77, 0x74, 0x0D, 0xF9, 0x0C, 0x77, 0x77, 0x09, 0xF9,
  0x76, 0x02, 0xFC, 0x82, 0xB9, 0x9B, 0xFC, 0x02, 0x77, 0x77, 0x30, 0x5F, 0xA0, 0x57, 0x77, 0x28,
  0x42, 0x34, 0x67, 0xCF, 0x98, 0x49, 0x76, 0x43, 0x17, 0x10, 0x8F, 0xFF, 0xB0, 0x87, 0x77, 0x74,
  0x0B, 0xF9, 0x0E, 0x77, 0x68, 0x17, 0xDE, 0xFF, 0xF9, 0x0D, 0x0A, 0x60, 0xCF, 0xFF, 0x90, 0xD7,
  0x77, 0x74, 0x02, 0xFA, 0x08, 0x77, 0x60, 0x9F, 0xFF, 0xC0, 0xD6, 0x02, 0x0E, 0xFF, 0xE0, 0xE0,
  0x37, 0x77, 0x74, 0x08, 0xFA, 0x02, 0x77, 0x60, 0x9F, 0xFF, 0xC0, 0xD7, 0x02, 0x0D, 0xFF, 0xC0,
  0xE0, 0x37, 0x77, 0x75, 0x0E, 0xF9, 0x0B, 0x77, 0x70, 0x9F, 0xFF, 0xC0, 0xD7, 0x10, 0x10, 0xBF,
  0xFA, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x5F, 0xA0, 0x57, 0x77, 0x09, 0xFF, 0xFC, 0x0D, 0x73, 0x04,
  0x0C, 0xFD, 0x0D, 0x05, 0x77, 0x77, 0x70, 0xCF, 0x90, 0xE7, 0x77, 0x10, 0x9F, 0xFF, 0xC0, 0xD7,
  0x58, 0x32, 0x7A, 0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x73,
  // "∂" (U+2202)
  0x77, 0x48, 0x94, 0x14, 0x8A, 0xCE, 0xEF, 0xEE, 0xDA, 0x84, 0x77, 0x77, 0x18, 0x11, 0x6C, 0xFF,
  0x90, 0xA0, 0x37, 0x77, 0x30, 0x40, 0xBF, 0xFE, 0x0A, 0x01, 0x77, 0x60, 0x60, 0xDF, 0xFF, 0xA0,
  0xE0, 0x57, 0x74, 0x01, 0xFF, 0xFE, 0x07, 0x77, 0x30, 0x1F, 0xFF, 0xF0, 0x77, 0x72, 0x01, 0xFF,
  0xFF, 0x90, 0x47, 0x71, 0x01, 0xFF, 0xFF, 0x90, 0xE0, 0x17, 0x70, 0x1F, 0xFF, 0xFA, 0x09, 0x77,
  0x01, 0xFF, 0xFF, 0xB0, 0x27, 0x60, 0x1F, 0xA8, 0x4C, 0xA9, 0x89, 0xBF, 0xFA, 0x09, 0x76, 0x01,
  0xE8, 0x1B, 0x51, 0x68, 0x11, 0x6E, 0xFF, 0x01, 0x75, 0x01, 0xC0, 0x90, 0x27, 0x40, 0x10, 0xBF,
  0xE0, 0x67, 0x50, 0x1A, 0x0A, 0x02, 0x77, 0x10, 0xBF, 0xD0, 0xB7, 0x58, 0x11, 0xC3, 0x77, 0x30,
  0x10, 0xEF, 0xD7, 0x77, 0x75, 0x06, 0xFD, 0x03, 0x77, 0x77, 0x50, 0xEF, 0xC0, 0x67, 0x77, 0x75,
  0x09, 0xFC, 0x08, 0x77, 0x77, 0x50, 0x6F, 0xC0, 0xB7, 0x75, 0x89, 0x01, 0x47, 0x89, 0x99, 0x74,
  0x14, 0x03, 0xFC, 0x0D, 0x77, 0x28, 0x12, 0x8D, 0xFB, 0x0A, 0x03, 0x20, 0x1F, 0xD7, 0x70, 0x20,
  0xBF, 0xF9, 0x81, 0x80, 0x1F, 0xD7, 0x60, 0x8F, 0xFC, 0x0A, 0x1F, 0xD0, 0x17, 0x30, 0x10, 0xCF,
  0xFE, 0x09, 0xFD, 0x02, 0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xE0, 0x37, 0x10, 0x20, 0xEF, 0xFF, 0xFF,
  0x03, 0x70, 0x10, 0xD8, 0x0C, 0x0F, 0x02, 0x70, 0xC8, 0x0C, 0x1F, 0x01, 0x60, 0x78, 0x0C, 0x2F,
  0x01, 0x50, 0x2F, 0xF9, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xDF, 0xFA, 0x60, 0xBF, 0xF0, 0x67, 0x10,
  0x7F, 0xF9, 0x50, 0x4F, 0xE0, 0xE0, 0x37, 0x30, 0x7F, 0xE0, 0xD5, 0x0B, 0xFE, 0x04, 0x75, 0x0D,
  0xFD, 0x0B, 0x40, 0x3F, 0xE0, 0x77, 0x60, 0x6F, 0xD0, 0x94, 0x09, 0xFD, 0x0C, 0x77, 0x04, 0xFD,
  0x07, 0x40, 0xEF, 0xD0, 0x47, 0x70, 0x6F, 0xD0, 0x53, 0x05, 0xFD, 0x0C, 0x77, 0x10, 0x9F, 0xD0,
  0x23, 0x0A, 0xFD, 0x06, 0x77, 0x10, 0xDF, 0xD4, 0x0E, 0xFD, 0x01, 0x77, 0x01, 0xFD, 0x0C, 0x30,
  0x3F, 0xD0, 0xA7, 0x71, 0x05, 0xFD, 0x08, 0x30, 0x7F, 0xD0, 0x67, 0x71, 0x09, 0xFD, 0x04, 0x30,
  0xAF, 0xD0, 0x27, 0x71, 0x0E, 0xFD, 0x01, 0x30, 0xCF, 0xC0, 0xE7, 0x71, 0x03, 0xFD, 0x0B, 0x4F,
  0xD0, 0xB7, 0x71, 0x09, 0xFD, 0x07, 0x30, 0x1F, 0xD0, 0x97, 0x71, 0x0E, 0xFD, 0x02, 0x30, 0x3F,
  0xD0, 0x77, 0x70, 0x5F, 0xD0, 0xC4, 0x04, 0xFD, 0x06, 0x77, 0x0C, 0xFD, 0x06, 0x40, 0x4F, 0xD0,
  0x57, 0x60, 0x4F, 0xD0, 0xE0, 0x14, 0x04, 0xFD, 0x04, 0x76, 0x0C, 0xFD, 0x09, 0x50, 0x3F, 0xD0,
  0x57, 0x50, 0x6F, 0xE0, 0x25, 0x02, 0xFD, 0x06, 0x74, 0x01, 0x0E, 0xFD, 0x0A, 0x7F, 0xD0, 0x97,
  0x40, 0xBF, 0xE0, 0x27, 0x0D, 0xFC, 0x0D, 0x73, 0x09, 0xFE, 0x09, 0x71, 0x0A, 0xFD, 0x04, 0x71,
  0x09, 0xFE, 0x0E, 0x01, 0x71, 0x06, 0xFD, 0x0E, 0x02, 0x50, 0x20, 0xCF, 0xF0, 0x57, 0x20, 0x1F,
  0xF8, 0x39, 0x65, 0x7C, 0xFF, 0x90, 0xA7, 0x40, 0xBF, 0xFF, 0xFC, 0x0D, 0x75, 0x05, 0xFF, 0xFF,
  0xB0, 0xE0, 0x27, 0x60, 0xDF, 0xFF, 0xFA, 0x03, 0x77, 0x03, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x20,
  0x8F, 0xFF, 0xD0, 0xE0, 0x37, 0x74, 0x0A, 0xFF, 0xFB, 0x0B, 0x01, 0x77, 0x60, 0x9F, 0xFF, 0x0E,
  0x07, 0x77, 0x72, 0x06, 0x0E, 0xFF, 0xC0, 0xA0, 0x17, 0x77, 0x48, 0x11, 0x8E, 0xFE, 0x81, 0xD8,
  0x17, 0x77, 0x72, 0x89, 0x34, 0x7A, 0xDE, 0xEF, 0xED, 0xC9, 0x62, 0x77, 0x71,
  // "∆" (U+2206)
  0x77, 0x50, 0x7F, 0xF0, 0x88, 0x0C, 0x20, 0x0C, 0xFF, 0x0D, 0x80, 0xC1, 0x00, 0x1F, 0xFA, 0x02,
  0x80, 0xC0, 0x00, 0x6F, 0xFA, 0x07, 0x80, 0xC0, 0x00, 0xCF, 0xFA, 0x0D, 0x77, 0x77, 0x70, 0x1F,
  0xFC, 0x02, 0x77, 0x77, 0x60, 0x6F, 0xFC, 0x07, 0x77, 0x77, 0x60, 0xBF, 0xFC, 0x0C, 0x77, 0x77,
  0x50, 0x1F, 0xFE, 0x02, 0x77, 0x77, 0x40, 0x6F, 0xFE, 0x07, 0x77, 0x77, 0x40, 0xBF, 0xFE, 0x0C,
  0x77, 0x77, 0x30, 0x1F, 0xB0, 0x0E, 0xFB, 0x01, 0x77, 0x77, 0x20, 0x6F, 0xB0, 0x0B, 0xFB, 0x07,
  0x77, 0x77, 0x20, 0xBF, 0xB0, 0x08, 0xFB, 0x0C, 0x77, 0x77, 0x10, 0x1F, 0xC0, 0x04, 0xFC, 0x01,
  0x77, 0x77, 0x05, 0xFC, 0x2F, 0xC0, 0x67, 0x77, 0x70, 0xBF, 0xB0, 0xB2, 0x0B, 0xFB, 0x0B, 0x77,
  0x77, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x17, 0x77, 0x50, 0x5F, 0xC0, 0x22, 0x02, 0xFC, 0x06, 0x77,
  0x75, 0x0A, 0xFB, 0x0D, 0x40, 0xDF, 0xB0, 0xB7, 0x77, 0x5F, 0xC0, 0x94, 0x09, 0xFC, 0x01, 0x77,
  0x73, 0x05, 0xFC, 0x04, 0x40, 0x4F, 0xC0, 0x57, 0x77, 0x30, 0xAF, 0xB0, 0xE6, 0x0E, 0xFB, 0x0B,
  0x77, 0x73, 0x0E, 0xFB, 0x0A, 0x60, 0xAF, 0xC7, 0x77, 0x20, 0x5F, 0xC0, 0x56, 0x05, 0xFC, 0x05,
  0x77, 0x71, 0x0A, 0xFC, 0x01, 0x7F, 0xC0, 0xA7, 0x77, 0x10, 0xEF, 0xB0, 0xB7, 0x10, 0xBF, 0xC7,
  0x77, 0x04, 0xFC, 0x06, 0x71, 0x06, 0xFC, 0x05, 0x77, 0x60, 0xAF, 0xC0, 0x17, 0x10, 0x1F, 0xC0,
  0xA7, 0x76, 0x0E, 0xFB, 0x0C, 0x73, 0x0C, 0xFB, 0x0E, 0x77, 0x50, 0x4F, 0xC0, 0x77, 0x30, 0x7F,
  0xC0, 0x47, 0x74, 0x09, 0xFC, 0x03, 0x73, 0x02, 0xFC, 0x0A, 0x77, 0x40, 0xEF, 0xB0, 0xD7, 0x50,
  0xDF, 0xB0, 0xE7, 0x73, 0x04, 0xFC, 0x09, 0x75, 0x08, 0xFC, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0x47,
  0x50, 0x3F, 0xC0, 0x97, 0x72, 0x0E, 0xFB, 0x0E, 0x77, 0x0E, 0xFB, 0x0E, 0x77, 0x10, 0x4F, 0xC0,
  0xA7, 0x70, 0x9F, 0xC0, 0x47, 0x70, 0x9F, 0xC0, 0x57, 0x70, 0x5F, 0xC0, 0x97, 0x70, 0xEF, 0xC0,
  0x17, 0x71, 0xFC, 0x0E, 0x76, 0x03, 0xFC, 0x0B, 0x77, 0x20, 0xAF, 0xC0, 0x37, 0x50, 0x9F, 0xC0,
  0x67, 0x72, 0x06, 0xFC, 0x09, 0x75, 0x0D, 0xFC, 0x02, 0x77, 0x20, 0x1F, 0xC0, 0xD7, 0x40, 0x3F,
  0xC0, 0xD7, 0x74, 0x0C, 0xFC, 0x03, 0x73, 0x08, 0xFC, 0x08, 0x77, 0x40, 0x7F, 0xC0, 0x87, 0x30,
  0xDF, 0xC0, 0x37, 0x74, 0x02, 0xFC, 0x0D, 0x72, 0x03, 0xFC, 0x0E, 0x77, 0x60, 0xDF, 0xC0, 0x37,
  0x10, 0x8F, 0xC0, 0x97, 0x76, 0x08, 0xFC, 0x08, 0x71, 0x0D, 0xFC, 0x04, 0x77, 0x60, 0x3F, 0xC0,
  0xD7, 0x03, 0xFC, 0x0E, 0x77, 0x71, 0x0E, 0xFC, 0x02, 0x60, 0x8F, 0xC0, 0xA7, 0x77, 0x10, 0x9F,
  0xC0, 0x76, 0x0D, 0xFC, 0x05, 0x77, 0x71, 0x04, 0xFC, 0x0D, 0x50, 0x2F, 0xD0, 0x17, 0x77, 0x20,
  0xEF, 0xC0, 0x24, 0x07, 0xFC, 0x0B, 0x77, 0x73, 0x0A, 0xFC, 0x07, 0x40, 0xDF, 0xC0, 0x77, 0x77,
  0x30, 0x5F, 0xC0, 0xC3, 0x02, 0x80, 0xD6, 0xF0, 0x22, 0x07, 0x80, 0xD6, 0xF0, 0x72, 0x0C, 0x80,
  0xD6, 0xF8, 0x1C, 0x01, 0x80, 0xE0, 0xF0, 0x01, 0x80, 0xE0, 0xF0, 0x01, 0x80, 0xE0, 0xF0, 0x01,
  0x80, 0xE0, 0xF0, 0x01, 0x80, 0xE0, 0xF0, 0x01, 0x80, 0xE0, 0xF0, 0x01, 0x80, 0xE0, 0xF0, 0x11,
  0x80, 0xE0, 0x81,
  // "√" (U+221A)
  0x80, 0xC6, 0x00, 0x48, 0x05, 0x70, 0x58, 0x0C, 0x60, 0x0D, 0xFA, 0x07, 0x80, 0xC5, 0x00, 0x2F,
  0xB0, 0x28, 0x0C, 0x50, 0x07, 0xFA, 0x0D, 0x80, 0xC6, 0x00, 0xBF, 0xA0, 0x88, 0x0C, 0x50, 0x01,
  0xFB, 0x04, 0x80, 0xC5, 0x00, 0x5F, 0xA0, 0xE8, 0x0C, 0x60, 0x0A, 0xFA, 0x09, 0x80, 0xC6, 0x00,
  0xEF, 0xA0, 0x58, 0x0C, 0x50, 0x04, 0xFB, 0x80, 0xC6, 0x00, 0x9F, 0xA0, 0xB8, 0x0C, 0x60, 0x0D,
  0xFA, 0x06, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x50, 0x07, 0xFA, 0x0C, 0x80, 0xC6, 0x00,
  0xCF, 0xA0, 0x78, 0x0C, 0x50, 0x01, 0xFB, 0x02, 0x80, 0xC5, 0x00, 0x6F, 0xA0, 0xD8, 0x0C, 0x60,
  0x0A, 0xFA, 0x08, 0x80, 0xC6, 0x00, 0xEF, 0xA0, 0x38, 0x0C, 0x50, 0x04, 0xFA, 0x0E, 0x80, 0xC6,
  0x00, 0x9F, 0xA0, 0x98, 0x0C, 0x60, 0x0E, 0xFA, 0x04, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0xE8, 0x0C,
  0x60, 0x08, 0xFA, 0x0A, 0x80, 0xC6, 0x00, 0xCF, 0xA0, 0x58, 0x0C, 0x50, 0x01, 0xFB, 0x01, 0x80,
  0xC5, 0x00, 0x6F, 0xA0, 0xB8, 0x0C, 0x60, 0x0B, 0xFA, 0x06, 0x80, 0xC6, 0x0F, 0xB0, 0x28, 0x0C,
  0x50, 0x05, 0xFA, 0x0C, 0x80, 0xC6, 0x00, 0x9F, 0xA0, 0x78, 0x0C, 0x60, 0x0E, 0xFA, 0x03, 0x80,
  0xC5, 0x00, 0x3F, 0xA0, 0xD8, 0x0C, 0x60, 0x08, 0xFA, 0x09, 0x80, 0xC6, 0x00, 0xDF, 0xA0, 0x48,
  0x0C, 0x50, 0x02, 0xFA, 0x0E, 0x74, 0x03, 0xFF, 0x01, 0x77, 0x10, 0x7F, 0xA0, 0xA7, 0x40, 0x3F,
  0xF0, 0x77, 0x71, 0x0B, 0xFA, 0x05, 0x74, 0x03, 0xFF, 0x0C, 0x77, 0x01, 0xFB, 0x75, 0x03, 0xFF,
  0x90, 0x37, 0x60, 0x5F, 0xA0, 0xB7, 0x50, 0x3F, 0xF9, 0x08, 0x76, 0x0A, 0xFA, 0x06, 0x75, 0x03,
  0xFF, 0x90, 0xE7, 0x60, 0xEF, 0xA0, 0x17, 0x50, 0x3F, 0xFA, 0x04, 0x74, 0x04, 0xFA, 0x0C, 0x76,
  0x03, 0xFF, 0xA0, 0xA7, 0x40, 0x9F, 0xA0, 0x77, 0x60, 0x3F, 0xFB, 0x74, 0x0D, 0xFA, 0x02, 0x76,
  0x03, 0xFF, 0xB0, 0x67, 0x20, 0x2F, 0xA0, 0xD7, 0x77, 0x10, 0x4F, 0xA0, 0xB7, 0x20, 0x7F, 0xA0,
  0x87, 0x77, 0x20, 0xDF, 0xA0, 0x17, 0x10, 0xCF, 0xA0, 0x37, 0x77, 0x20, 0x8F, 0xA0, 0x77, 0x01,
  0xFA, 0x0E, 0x77, 0x73, 0x02, 0xFA, 0x0D, 0x70, 0x6F, 0xA0, 0x97, 0x77, 0x40, 0xCF, 0xA0, 0x36,
  0x0A, 0xFA, 0x04, 0x77, 0x74, 0x06, 0xFA, 0x09, 0x60, 0xEF, 0x90, 0xE7, 0x77, 0x50, 0x1F, 0xA0,
  0xE5, 0x04, 0xFA, 0x0A, 0x77, 0x76, 0x0A, 0xFA, 0x04, 0x40, 0x9F, 0xA0, 0x57, 0x77, 0x60, 0x4F,
  0xA0, 0xA4, 0x0E, 0xFA, 0x01, 0x77, 0x77, 0x0E, 0xFA, 0x01, 0x20, 0x3F, 0xA0, 0xB7, 0x77, 0x71,
  0x08, 0xFA, 0x06, 0x20, 0x8F, 0xA0, 0x67, 0x77, 0x71, 0x03, 0xFA, 0x0C, 0x20, 0xCF, 0xA0, 0x27,
  0x77, 0x72, 0x0C, 0xFA, 0x02, 0x01, 0xFA, 0x0C, 0x77, 0x77, 0x30, 0x7F, 0xA0, 0x70, 0x6F, 0xA0,
  0x87, 0x77, 0x73, 0x01, 0xFA, 0x0D, 0x0B, 0xFA, 0x03, 0x77, 0x77, 0x40, 0xBF, 0xFC, 0x0D, 0x77,
  0x77, 0x50, 0x5F, 0xFC, 0x09, 0x77, 0x77, 0x60, 0xEF, 0xFB, 0x04, 0x77, 0x77, 0x60, 0x9F, 0xFA,
  0x0E, 0x77, 0x77, 0x70, 0x3F, 0xFA, 0x0A, 0x80, 0xC0, 0x00, 0xDF, 0xF9, 0x05, 0x80, 0xC0, 0x00,
  0x7F, 0xF9, 0x80, 0xC1, 0x00, 0x1F, 0xF0, 0xB8, 0x0C, 0x20, 0x0B, 0xFE, 0x06, 0x80, 0xC2, 0x00,
  0x5F, 0xE0, 0x18, 0x0C, 0x30, 0x0E, 0xFC, 0x0C, 0x80, 0xC4, 0x00, 0x9F, 0xC0, 0x78, 0x0C, 0x40,
  0x04, 0xFC, 0x02, 0x80, 0xC5, 0x00, 0xDF, 0xA0, 0xD8, 0x0C, 0x60, 0x08, 0xFA, 0x08, 0x80, 0xC6,
  0x00, 0x2F, 0xA0, 0x38, 0x0C, 0x70, 0x0C, 0xF0, 0xE7, 0x77, 0x30,
  // "∞" (U+221E)
  0x72, 0x85, 0x14, 0x78, 0x76, 0x37, 0x76, 0x85, 0x46, 0x78, 0x74, 0x17, 0x72, 0x04, 0x0B, 0xF9,
  0x0A, 0x03, 0x77, 0x03, 0x0A, 0xF9, 0x0B, 0x05, 0x75, 0x01, 0x0B, 0xFD, 0x0A, 0x01, 0x74, 0x09,
  0xFD, 0x0C, 0x02, 0x72, 0x03, 0x0E, 0xFF, 0x0E, 0x03, 0x71, 0x01, 0x0C, 0xFF, 0x0E, 0x04, 0x70,
  0x30, 0xEF, 0xFB, 0x05, 0x60, 0x20, 0xDF, 0xFB, 0x03, 0x50, 0x10, 0xDF, 0xFD, 0x07, 0x40, 0x10,
  0xDF, 0xFC, 0x0E, 0x01, 0x40, 0xAF, 0xFF, 0x07, 0x20, 0x10, 0xDF, 0xFE, 0x0A, 0x30, 0x3F, 0xFF,
  0xA8, 0x16, 0x0B, 0xFF, 0xF9, 0x03, 0x20, 0xAF, 0xFF, 0xB0, 0xBF, 0xFF, 0xA8, 0x1A, 0x01, 0xFB,
  0x84, 0x72, 0x02, 0x7E, 0xFF, 0xC8, 0x4C, 0x51, 0x02, 0x9F, 0xB0, 0x10, 0x6F, 0xA0, 0x45, 0x01,
  0x0C, 0xFF, 0xA0, 0xA6, 0x06, 0xFA, 0x05, 0x09, 0xF9, 0x09, 0x71, 0x0C, 0xFF, 0x0B, 0x71, 0x0A,
  0xF9, 0x08, 0x0C, 0xF9, 0x02, 0x71, 0x01, 0x0D, 0xFD, 0x0C, 0x72, 0x03, 0xF9, 0x0B, 0x0E, 0xF0,
  0xD7, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x30, 0xEF, 0x0C, 0xF9, 0x0B, 0x74, 0x06, 0xFB, 0x06,
  0x74, 0x0D, 0xF0, 0xDF, 0x90, 0xB7, 0x50, 0xEF, 0xA0, 0x17, 0x40, 0xDF, 0x0D, 0x0E, 0xF0, 0xC7,
  0x40, 0x9F, 0xB0, 0xB7, 0x40, 0xEF, 0x00, 0xDF, 0x97, 0x30, 0x5F, 0xD0, 0x77, 0x20, 0x2F, 0x90,
  0x0B, 0xF9, 0x06, 0x71, 0x03, 0xFF, 0x05, 0x71, 0x08, 0xF9, 0x09, 0x07, 0xF9, 0x0D, 0x01, 0x60,
  0x30, 0xEF, 0xF0, 0xE0, 0x36, 0x02, 0xFA, 0x05, 0x03, 0xFA, 0x0C, 0x02, 0x40, 0x60, 0xEF, 0xFB,
  0x07, 0x40, 0x30, 0xDF, 0xA8, 0x11, 0x0E, 0xFB, 0x82, 0xCA, 0xBE, 0xFF, 0xE8, 0x2E, 0xBA, 0xCF,
  0xB0, 0xB2, 0x07, 0xFF, 0xFA, 0x09, 0xFF, 0xFB, 0x04, 0x30, 0xEF, 0xFF, 0x81, 0x80, 0x6F, 0xFF,
  0x90, 0xC4, 0x04, 0xFF, 0xE0, 0xA3, 0x09, 0xFF, 0xF0, 0x25, 0x08, 0xFF, 0xC0, 0xA5, 0x0A, 0xFF,
  0xD0, 0x67, 0x0A, 0xFF, 0xA0, 0x97, 0x0A, 0xFF, 0xB0, 0x77, 0x20, 0x7F, 0xF0, 0x77, 0x20, 0x9F,
  0xF0, 0xE0, 0x57, 0x40, 0x30, 0xBF, 0xB0, 0xB0, 0x37, 0x40, 0x50, 0xDF, 0xC0, 0x90, 0x17, 0x78,
  0x22, 0x7B, 0xDA, 0x82, 0xEC, 0x83, 0x77, 0x18, 0x91, 0x48, 0xCD, 0xEF, 0xEC, 0x96, 0x17, 0x10,
  // "≈" (U+2248)
  0x68, 0x35, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17, 0x77, 0x20, 0x10, 0x73, 0x81, 0x18, 0xEF,
  0xE8, 0x1B, 0x61, 0x77, 0x58, 0x13, 0xDA, 0x20, 0x60, 0xEF, 0xFC, 0x0A, 0x04, 0x77, 0x20, 0x7A,
  0x81, 0xA0, 0x9F, 0xFF, 0x98, 0x1E, 0x94, 0x74, 0x05, 0x0D, 0xB0, 0x0A, 0xFF, 0xFD, 0x83, 0xEA,
  0x63, 0x12, 0x82, 0x14, 0x8D, 0xD0, 0xA0, 0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0,
  0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xCD, 0x82, 0xC7, 0x41, 0x28, 0x31, 0x36,
  0x9E, 0xFF, 0xFD, 0x08, 0x0C, 0xB0, 0xD0, 0x47, 0x48, 0x13, 0x9E, 0xFF, 0xF9, 0x81, 0x80, 0xCA,
  0x08, 0x77, 0x20, 0x50, 0xBF, 0xFC, 0x0E, 0x04, 0x28, 0x1C, 0xE3, 0x77, 0x58, 0x11, 0x7C, 0xFE,
  0x0E, 0x08, 0x40, 0x90, 0x27, 0x77, 0x28, 0x42, 0x69, 0xCD, 0xEA, 0x83, 0xED, 0xB8, 0x48, 0x0A,
  0xF0, 0x08, 0x35, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17, 0x77, 0x20, 0x10, 0x73, 0x81, 0x18,
  0xEF, 0xE8, 0x1B, 0x61, 0x77, 0x58, 0x13, 0xDA, 0x20, 0x50, 0xEF, 0xFC, 0x0A, 0x04, 0x77, 0x20,
  0x7A, 0x81, 0xA0, 0x9F, 0xFF, 0x98, 0x1E, 0x94, 0x74, 0x05, 0x0D, 0xB0, 0xA0, 0x9F, 0xFF, 0xD8,
  0x3E, 0xA6, 0x31, 0x28, 0x21, 0x48, 0xDD, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xC8, 0x0C, 0x6F,
  0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0xD8, 0x2C, 0x74, 0x12, 0x83,
  0x13, 0x69, 0xEF, 0xFF, 0xD0, 0x70, 0xCB, 0x0C, 0x04, 0x74, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x17,
  0x0C, 0xA0, 0x77, 0x72, 0x05, 0x0B, 0xFF, 0xC0, 0xD0, 0x42, 0x81, 0xCE, 0x37, 0x75, 0x81, 0x17,
  0xCF, 0xE0, 0xE0, 0x74, 0x09, 0x01, 0x77, 0x72, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB, 0x84,
  0x60,
  // "≠" (U+2260)
  0x77, 0x74, 0x01, 0x05, 0x80, 0xC4, 0x08, 0x37, 0xFE, 0x93, 0x80, 0xC1, 0x00, 0xCC, 0x81, 0xD7,
  0x17, 0x77, 0x75, 0x03, 0xF9, 0x0A, 0x04, 0x77, 0x77, 0x30, 0x9F, 0xB0, 0x67, 0x77, 0x72, 0x0E,
  0xFB, 0x01, 0x77, 0x77, 0x10, 0x5F, 0xB0, 0xA7, 0x77, 0x72, 0x0A, 0xFB, 0x04, 0x77, 0x77, 0x10,
  0x1F, 0xB0, 0xD7, 0x77, 0x72, 0x06, 0xFB, 0x08, 0x77, 0x77, 0x20, 0xCF, 0xB0, 0x27, 0x77, 0x71,
  0x03, 0xFB, 0x0C, 0x72, 0x08, 0x80, 0xA0, 0xC0, 0xDF, 0xB0, 0xE8, 0x04, 0xC0, 0x80, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C,
  0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A, 0x77, 0x30, 0xAF, 0xB0, 0x27, 0x77, 0x71, 0x01, 0xFB, 0x0C,
  0x77, 0x77, 0x20, 0x6F, 0xB0, 0x67, 0x77, 0x72, 0x0C, 0xFB, 0x01, 0x77, 0x77, 0x10, 0x2F, 0xB0,
  0xA7, 0x77, 0x72, 0x08, 0xFB, 0x05, 0x77, 0x77, 0x20, 0xEF, 0xA0, 0xE7, 0x77, 0x72, 0x04, 0xFB,
  0x08, 0x77, 0x20, 0x88, 0x09, 0x1C, 0x0E, 0xFB, 0x0D, 0x80, 0x93, 0xC0, 0x80, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x0A, 0x73, 0x0D, 0xFB, 0x01, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0xA7, 0x77,
  0x72, 0x09, 0xFB, 0x04, 0x77, 0x77, 0x20, 0xEF, 0xA0, 0xE7, 0x77, 0x72, 0x05, 0xFB, 0x08, 0x77,
  0x77, 0x20, 0xBF, 0xB0, 0x27, 0x77, 0x71, 0x01, 0xFB, 0x0C, 0x77, 0x77, 0x28, 0x12, 0x9E, 0xF9,
  0x06, 0x77, 0x77, 0x50, 0x50, 0xBE, 0x01, 0x77, 0x77, 0x78, 0x12, 0x8D, 0xA0, 0xA8, 0x0C, 0x30,
  0x81, 0x4A, 0x47, 0x77, 0x30,
  // "≤" (U+2264)
  0x80, 0xC7, 0x00, 0x48, 0x0C, 0x50, 0x81, 0x6E, 0xC8, 0x0C, 0x30, 0x06, 0x0E, 0xA0, 0xC8, 0x0C,
  0x10, 0x06, 0x0E, 0xC0, 0xC7, 0x77, 0x77, 0x06, 0x0E, 0xE0, 0xC7, 0x77, 0x75, 0x06, 0x0E, 0xF9,
  0x0C, 0x77, 0x77, 0x30, 0x60, 0xEF, 0xB0, 0xC7, 0x77, 0x71, 0x06, 0x0E, 0xFD, 0x0C, 0x77, 0x76,
  0x06, 0x0D, 0xFF, 0x0C, 0x77, 0x74, 0x06, 0x0D, 0xFF, 0xA0, 0xC7, 0x77, 0x20, 0x60, 0xDF, 0xFC,
  0x09, 0x77, 0x70, 0x60, 0xDF, 0xFC, 0x0A, 0x02, 0x77, 0x60, 0x60, 0xDF, 0xFB, 0x81, 0xE9, 0x17,
  0x76, 0x06, 0x0D, 0xFF, 0xB8, 0x1E, 0x71, 0x77, 0x60, 0x60, 0xDF, 0xFB, 0x0D, 0x07, 0x77, 0x70,
  0x60, 0xDF, 0xFB, 0x0D, 0x05, 0x77, 0x70, 0x60, 0xDF, 0xFB, 0x0C, 0x04, 0x77, 0x70, 0x60, 0xDF,
  0xFB, 0x0B, 0x03, 0x77, 0x70, 0x60, 0xDF, 0xFB, 0x0A, 0x02, 0x77, 0x70, 0x60, 0xDF, 0xFB, 0x09,
  0x02, 0x77, 0x70, 0x60, 0xDF, 0xFA, 0x81, 0xE8, 0x17, 0x77, 0x06, 0x0D, 0xFF, 0xA0, 0xD0, 0x77,
  0x77, 0x20, 0xAF, 0xFA, 0x0D, 0x06, 0x77, 0x74, 0x0A, 0xFF, 0x0C, 0x05, 0x77, 0x76, 0x0A, 0xFD,
  0x0C, 0x04, 0x77, 0x77, 0x10, 0xAF, 0xE0, 0xB0, 0x47, 0x77, 0x70, 0xAF, 0xF9, 0x81, 0xD7, 0x17,
  0x77, 0x40, 0xAF, 0xFC, 0x0A, 0x04, 0x77, 0x72, 0x04, 0x0C, 0xFF, 0xD8, 0x1D, 0x61, 0x77, 0x71,
  0x04, 0x0B, 0xFF, 0xD8, 0x1E, 0x93, 0x77, 0x71, 0x81, 0x29, 0xEF, 0xFD, 0x0C, 0x05, 0x77, 0x71,
  0x81, 0x17, 0xDF, 0xFD, 0x81, 0xE8, 0x27, 0x77, 0x10, 0x50, 0xCF, 0xFE, 0x0B, 0x05, 0x77, 0x71,
  0x03, 0x0A, 0xFF, 0xE8, 0x1D, 0x71, 0x77, 0x78, 0x12, 0x8E, 0xFF, 0xE0, 0xA0, 0x47, 0x77, 0x10,
  0x70, 0xDF, 0xFE, 0x81, 0xD6, 0x17, 0x77, 0x05, 0x0C, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x70, 0x30,
  0xAF, 0xFF, 0x0A, 0x77, 0x71, 0x81, 0x18, 0xEF, 0xFC, 0x0C, 0x77, 0x74, 0x06, 0x0D, 0xFF, 0xA0,
  0xC7, 0x77, 0x60, 0x40, 0xBF, 0xF0, 0xC7, 0x77, 0x71, 0x02, 0x09, 0xFD, 0x0C, 0x77, 0x77, 0x38,
  0x11, 0x7E, 0xFA, 0x0C, 0x77, 0x77, 0x60, 0x60, 0xCF, 0x0C, 0x80, 0xC0, 0x00, 0x40, 0xBD, 0x0C,
  0x80, 0xC2, 0x08, 0x12, 0x9E, 0xA0, 0xC8, 0x0C, 0x40, 0x82, 0x17, 0xDC, 0x80, 0xC7, 0x00, 0x38,
  0x0D, 0x00, 0x02, 0x80, 0xC6, 0x40, 0x30, 0xA8, 0x0C, 0x6F, 0x0C, 0x0A, 0x80, 0xC6, 0xF0, 0xC0,
  0xA8, 0x0C, 0x6F, 0x0C, 0x0A, 0x80, 0xC6, 0xF0, 0xC0, 0xA8, 0x0C, 0x6F, 0x0C, 0x0A, 0x80, 0xC6,
  0xF0, 0xC0, 0xA8, 0x0C, 0x6F, 0x0C, 0x0A, 0x80, 0xC6, 0xF0, 0xC0, 0xA8, 0x0C, 0x6F, 0x0C,
  // "≥" (U+2265)
  0x04, 0x80, 0xC7, 0x08, 0x1C, 0xE7, 0x80, 0xC5, 0x00, 0xCA, 0x0E, 0x06, 0x80, 0xC3, 0x00, 0xCC,
  0x0E, 0x06, 0x80, 0xC1, 0x00, 0xCE, 0x0E, 0x06, 0x77, 0x77, 0x70, 0xCF, 0x90, 0xE0, 0x67, 0x77,
  0x75, 0x0C, 0xFB, 0x0E, 0x06, 0x77, 0x77, 0x30, 0xCF, 0xD0, 0xE0, 0x67, 0x77, 0x71, 0x0C, 0xFF,
  0x0D, 0x06, 0x77, 0x76, 0x0C, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x40, 0x9F, 0xFC, 0x0D, 0x06, 0x77,
  0x73, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x67, 0x77, 0x38, 0x12, 0x9E, 0xFF, 0xB0, 0xD0, 0x67, 0x77,
  0x38, 0x11, 0x8E, 0xFF, 0xB0, 0xD0, 0x67, 0x77, 0x40, 0x70, 0xDF, 0xFB, 0x0D, 0x06, 0x77, 0x74,
  0x05, 0x0D, 0xFF, 0xB0, 0xD0, 0x67, 0x77, 0x40, 0x50, 0xCF, 0xFB, 0x0D, 0x06, 0x77, 0x74, 0x03,
  0x0B, 0xFF, 0xB0, 0xD0, 0x67, 0x77, 0x40, 0x20, 0xAF, 0xFB, 0x0D, 0x06, 0x77, 0x74, 0x02, 0x09,
  0xFF, 0xB0, 0xD0, 0x67, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x50, 0x70, 0xDF,
  0xFA, 0x0D, 0x06, 0x77, 0x75, 0x06, 0x0D, 0xFF, 0xA0, 0xA7, 0x77, 0x60, 0x50, 0xCF, 0xF0, 0xA7,
  0x77, 0x71, 0x04, 0x0C, 0xFD, 0x0A, 0x77, 0x77, 0x05, 0x0B, 0xFE, 0x0A, 0x77, 0x74, 0x81, 0x17,
  0xDF, 0xF9, 0x0A, 0x77, 0x72, 0x04, 0x0A, 0xFF, 0xC0, 0xA7, 0x76, 0x81, 0x16, 0xDF, 0xFD, 0x0C,
  0x04, 0x77, 0x48, 0x13, 0x9E, 0xFF, 0xD0, 0xB0, 0x47, 0x74, 0x05, 0x0C, 0xFF, 0xD8, 0x1E, 0x92,
  0x77, 0x38, 0x12, 0x8E, 0xFF, 0xD8, 0x1D, 0x71, 0x77, 0x30, 0x50, 0xBF, 0xFE, 0x0C, 0x05, 0x77,
  0x38, 0x11, 0x7D, 0xFF, 0xE0, 0xA0, 0x37, 0x73, 0x04, 0x0A, 0xFF, 0xE8, 0x1E, 0x82, 0x77, 0x28,
  0x11, 0x6D, 0xFF, 0xE0, 0xD0, 0x77, 0x73, 0x03, 0x09, 0xFF, 0xF0, 0xC0, 0x57, 0x74, 0x0A, 0xFF,
  0xF0, 0xA0, 0x37, 0x76, 0x0C, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x71, 0x0C, 0xFF, 0xA0, 0xD0, 0x67,
  0x77, 0x40, 0xCF, 0xF0, 0xB0, 0x47, 0x77, 0x60, 0xCF, 0xD0, 0x90, 0x27, 0x77, 0x71, 0x0C, 0xFA,
  0x81, 0xE7, 0x17, 0x77, 0x73, 0x0C, 0xF0, 0xC0, 0x67, 0x77, 0x76, 0x0C, 0xD0, 0xB0, 0x48, 0x0C,
  0x00, 0x0C, 0xA8, 0x1E, 0x92, 0x80, 0xC2, 0x08, 0x2C, 0xD7, 0x18, 0x0C, 0x40, 0x03, 0x80, 0x9A,
  0x30, 0x03, 0x80, 0xC6, 0x40, 0x20, 0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xC8,
  0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0,
  0xA0, 0xC8, 0x0C, 0x6F, 0x0A, 0x0C, 0x80, 0xC6, 0xF0, 0xA0, 0xC8, 0x0C, 0x6F, 0x0A,
};

const Font& font_NotoSansMono_Bold_90() {
  static SmoothFont font(font_NotoSansMono_Bold_90_data);
  return font;
}

}  // namespace roo_display
