#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Thu Mar 30 22:28:53 CEST 2023
static const uint8_t font_NotoSans_CondensedItalic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x00, 0x36,
  0xFE, 0xFE, 0x07, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x08, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x05, 0x02, 0x07, 0x03, 0x00, 0x09, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x0F, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x1F, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x2F, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x42, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x07, 0x02, 0x00, 0x53, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x07, 0x02, 0x00, 0x56, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0x00, 0x01, 0x07, 0x02, 0x00, 0x64, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x03, 0x00, 0x71, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x03, 0x05, 0x04, 0x00, 0x7A, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0x00, 0x00, 0x01, 0x02, 0x00, 0x84, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x01, 0x03, 0x02, 0x00, 0x87, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x00, 0x01, 0x02, 0x00, 0x89, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x00, 0x8A, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x99, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x02, 0x07, 0x04, 0x00, 0xA9, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x00, 0xB2, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC5, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xD5, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xE4, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xF4, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x05, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x15, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x25, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x35, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0x00, 0x01, 0x05, 0x02, 0x01, 0x39, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x41, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x03, 0x05, 0x04, 0x01, 0x4A, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x51, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x01, 0x5A, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x05, 0x07, 0x05, 0x01, 0x66, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x01, 0x7F, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x93, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0xA3, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0xB5, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x03, 0x07, 0x03, 0x01, 0xC5, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x03, 0x07, 0x03, 0x01, 0xD5, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0xE4, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0xF8, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x02, 0x07, 0x02, 0x02, 0x0B, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0x00, 0x01, 0x07, 0x02, 0x02, 0x1B, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x07, 0x04, 0x02, 0x2C, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x41, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x4E, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x65, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x78, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x8C, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x02, 0x9B, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0xB2, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x07, 0x03, 0x02, 0xC2, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x03, 0x07, 0x03, 0x02, 0xD1, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x04, 0x07, 0x04, 0x02, 0xE0, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x07, 0x04, 0x02, 0xF3, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x06, 0x07, 0x06, 0x03, 0x07, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x03, 0x22, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x03, 0x07, 0x03, 0x03, 0x36, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x03, 0x46, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0x00, 0x02, 0x07, 0x02, 0x03, 0x5A, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x03, 0x6C, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0x00, 0x02, 0x07, 0x02, 0x03, 0x78, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x03, 0x07, 0x04, 0x03, 0x89, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0x01, 0xFF, 0x03, 0x03, 0x93, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x07, 0x02, 0x08, 0x02, 0x03, 0x96, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0x99, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xA5, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x02, 0x05, 0x03, 0x03, 0xB4, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xBD, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x05, 0x03, 0x03, 0xCB, // "e" (U+0065)
  0x00, 0x66, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x03, 0xD7, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xEA, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xFA, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x09, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x11, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x03, 0x04, 0x1F, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x2E, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x05, 0x05, 0x06, 0x04, 0x37, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x48, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x54, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x60, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x72, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x82, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x8B, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x02, 0x04, 0x94, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x9F, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x03, 0x05, 0x03, 0x04, 0xAB, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xB7, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x03, 0x05, 0x03, 0x04, 0xC5, // "x" (U+0078)
  0x00, 0x79, 0xFF, 0xFF, 0x03, 0x05, 0x03, 0x04, 0xD3, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x02, 0x05, 0x03, 0x04, 0xE6, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x00, 0x03, 0x07, 0x03, 0x04, 0xF2, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x01, 0x07, 0x03, 0x05, 0x04, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0x00, 0x02, 0x07, 0x03, 0x05, 0x06, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x03, 0x03, 0x04, 0x05, 0x16, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x01, 0x05, 0x02, 0x05, 0x19, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0x22, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x05, 0x31, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x03, 0x05, 0x04, 0x05, 0x44, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0x4E, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x01, 0x07, 0x03, 0x05, 0x5E, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x03, 0x05, 0x62, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x04, 0x05, 0x73, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0x76, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x02, 0x05, 0x92, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x03, 0x05, 0x98, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x03, 0x04, 0x04, 0x05, 0xA2, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0xA8, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x03, 0x08, 0x03, 0x05, 0xC3, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x05, 0xC6, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0xCC, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x02, 0x05, 0xD8, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x02, 0x05, 0xE0, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x07, 0x02, 0x08, 0x02, 0x05, 0xE8, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFF, 0x03, 0x05, 0x04, 0x05, 0xEB, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x05, 0xFE, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x00, 0x03, 0x02, 0x06, 0x13, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFF, 0x00, 0x01, 0x02, 0x06, 0x14, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x04, 0x02, 0x07, 0x02, 0x06, 0x18, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x02, 0x06, 0x1D, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0x23, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x06, 0x2C, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x3F, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x55, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x02, 0x04, 0x03, 0x06, 0x6B, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x06, 0x77, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x06, 0x8F, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x06, 0xA7, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x04, 0x07, 0x04, 0x06, 0xC0, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x03, 0x08, 0x04, 0x06, 0xD6, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x03, 0x08, 0x04, 0x06, 0xED, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x07, 0x04, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x07, 0x1C, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x03, 0x09, 0x03, 0x07, 0x32, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x03, 0x09, 0x03, 0x07, 0x45, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x03, 0x09, 0x03, 0x07, 0x59, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x03, 0x08, 0x03, 0x07, 0x6D, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x02, 0x09, 0x02, 0x07, 0x7F, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x03, 0x09, 0x02, 0x07, 0x92, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x02, 0x09, 0x02, 0x07, 0xA7, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x03, 0x08, 0x02, 0x07, 0xBB, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x03, 0x07, 0x04, 0x07, 0xCE, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0xDE, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0xF1, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x09, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x21, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x3A, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x4D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x08, 0x63, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x08, 0x05, 0x08, 0x6D, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x04, 0x09, 0x04, 0x08, 0x82, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x04, 0x09, 0x04, 0x08, 0x99, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x04, 0x09, 0x04, 0x08, 0xB0, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0xC8, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x03, 0x09, 0x03, 0x08, 0xDD, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xF1, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x08, 0xFF, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x18, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x28, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x38, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x03, 0x06, 0x04, 0x09, 0x49, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x57, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x66, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x05, 0x05, 0x05, 0x09, 0x76, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x09, 0x87, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x08, 0x03, 0x09, 0x93, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x08, 0x03, 0x09, 0xA3, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x08, 0x03, 0x09, 0xB3, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x03, 0x07, 0x03, 0x09, 0xC4, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x01, 0x08, 0x02, 0x09, 0xD3, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x08, 0x02, 0x09, 0xDD, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x01, 0x08, 0x02, 0x09, 0xEA, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x02, 0x09, 0xF4, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x00, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0A, 0x12, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x20, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x30, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x40, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0A, 0x51, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x5F, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x0A, 0x6E, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x03, 0x06, 0x04, 0x0A, 0x76, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x84, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x94, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xA4, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xB5, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x0A, 0xC4, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0xDB, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x0A, 0xF0, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x06, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0B, 0x1A, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x27, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x3E, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x4E, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0B, 0x67, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0B, 0x78, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0B, 0x8E, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0B, 0x9D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0xB3, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0xC0, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0B, 0xD3, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0B, 0xDE, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0B, 0xF5, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0C, 0x04, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x1C, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x2E, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x3E, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0C, 0x4F, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x03, 0x06, 0x03, 0x0C, 0x5F, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0C, 0x6D, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0C, 0x7F, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0C, 0x8F, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0C, 0xA1, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x0C, 0xAE, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x03, 0x05, 0x03, 0x0C, 0xC2, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x09, 0x03, 0x0C, 0xD2, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0C, 0xE9, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0C, 0xF9, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x0D, 0x12, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0D, 0x27, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x3D, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0D, 0x52, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x67, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0D, 0x79, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x91, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0D, 0xA5, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x0D, 0xBD, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0D, 0xD1, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0xE4, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x03, 0x07, 0x02, 0x0D, 0xF4, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x05, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x02, 0x07, 0x02, 0x0E, 0x0F, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x01, 0x06, 0x02, 0x0E, 0x1F, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x02, 0x08, 0x02, 0x0E, 0x27, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x01, 0x07, 0x02, 0x0E, 0x39, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x0E, 0x42, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0x56, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x02, 0x08, 0x02, 0x0E, 0x64, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x75, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0x00, 0x03, 0x07, 0x04, 0x0E, 0x7B, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x0E, 0x92, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0x00, 0x02, 0x09, 0x02, 0x0E, 0xA6, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x01, 0x08, 0x02, 0x0E, 0xBD, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0xCE, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x0E, 0xE7, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x03, 0x05, 0x03, 0x0E, 0xFA, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x09, 0x03, 0x0F, 0x06, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x0A, 0x02, 0x0F, 0x1A, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0x29, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x0F, 0x39, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x48, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x58, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x64, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x71, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x7D, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x01, 0x07, 0x02, 0x0F, 0x89, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x92, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xA9, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0xB9, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0xD0, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xE0, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xF8, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0x09, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x19, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x10, 0x31, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x42, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x03, 0x06, 0x04, 0x10, 0x55, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x63, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0x78, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x88, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x04, 0x10, 0x9E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x05, 0x07, 0x05, 0x10, 0xB1, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x05, 0x05, 0x06, 0x10, 0xCA, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0xDB, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x03, 0x10, 0xEF, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0xFE, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFF, 0x02, 0x05, 0x03, 0x11, 0x12, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x09, 0x04, 0x11, 0x21, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x08, 0x03, 0x11, 0x3A, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x09, 0x03, 0x11, 0x49, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x03, 0x11, 0x5C, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x09, 0x03, 0x11, 0x6C, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x02, 0x08, 0x03, 0x11, 0x80, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x11, 0x8E, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x11, 0xA1, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x09, 0x03, 0x11, 0xAE, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x08, 0x03, 0x11, 0xC3, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x11, 0xD4, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x02, 0x11, 0xE7, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x03, 0x09, 0x03, 0x11, 0xF5, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x02, 0x07, 0x02, 0x12, 0x08, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x03, 0x07, 0x03, 0x12, 0x15, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x02, 0x12, 0x24, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x04, 0x07, 0x04, 0x12, 0x2F, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x03, 0x06, 0x04, 0x12, 0x42, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x04, 0x07, 0x04, 0x12, 0x50, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x03, 0x06, 0x04, 0x12, 0x63, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x04, 0x08, 0x04, 0x12, 0x71, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x86, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x04, 0x08, 0x04, 0x12, 0x96, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0xAB, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x04, 0x08, 0x04, 0x12, 0xBB, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x04, 0x12, 0xD0, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x12, 0xE3, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x12, 0xFB, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x06, 0x09, 0x06, 0x13, 0x0C, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0x2C, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x03, 0x09, 0x03, 0x13, 0x40, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x13, 0x54, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0x6C, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x13, 0x7E, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x13, 0x96, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x13, 0xA8, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x02, 0x07, 0x03, 0x13, 0xBD, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x13, 0xCB, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x13, 0xE4, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x13, 0xF7, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x14, 0x0B, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFF, 0x03, 0x05, 0x04, 0x14, 0x22, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x03, 0x05, 0x04, 0x14, 0x35, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x04, 0x14, 0x41, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x06, 0x03, 0x07, 0x14, 0x44, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x47, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x03, 0x08, 0x04, 0x14, 0x58, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x06, 0x01, 0x07, 0x01, 0x14, 0x6B, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x01, 0x07, 0x01, 0x14, 0x6E, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0x00, 0x00, 0x01, 0x02, 0x14, 0x71, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x05, 0x01, 0x07, 0x01, 0x14, 0x74, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x05, 0x03, 0x07, 0x03, 0x14, 0x78, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x05, 0x03, 0x07, 0x03, 0x14, 0x80, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0x00, 0x02, 0x02, 0x03, 0x14, 0x86, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x05, 0x02, 0x07, 0x03, 0x14, 0x8D, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x03, 0x14, 0x93, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x03, 0x14, 0xA1, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x14, 0xB0, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x04, 0x01, 0x05, 0x14, 0xB6, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x07, 0x07, 0x08, 0x14, 0xBA, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x01, 0x04, 0x02, 0x14, 0xD7, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x01, 0x04, 0x02, 0x14, 0xDC, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x14, 0xE1, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x04, 0x06, 0x05, 0x14, 0xF0, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x06, 0x07, 0x08, 0x14, 0xFC, // "⅒" (U+2152)
  0xFB, 0x01, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x15, 0x14, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x15, 0x2B, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x18, 0x92, 0xB0, 0xA0, 0x93, 0x65, 0x32, 0x07, 0x10,
  // """ (U+0022)
  0x18, 0x3A, 0x91, 0x78, 0x20, 0x10,
  // "#" (U+0023)
  0x18, 0xB0, 0x26, 0x70, 0x53, 0x73, 0xCA, 0xA0, 0x77, 0x0A, 0xDD, 0x65, 0x27, 0x07, 0x43, 0x10,
  // "$" (U+0024)
  0x18, 0x90, 0x29, 0x11, 0x97, 0x21, 0xC3, 0x20, 0x60, 0x82, 0x84, 0x5A, 0x09, 0xD6, 0x20, 0x42,
  // "%" (U+0025)
  0x18, 0xC0, 0xA6, 0x16, 0x34, 0x77, 0x06, 0x18, 0x70, 0x74, 0xB5, 0x84, 0xB7, 0x77, 0x07, 0x27,
  0x80, 0x70, 0xC5,
  // "&" (U+0026)
  0x18, 0x90, 0x6C, 0x10, 0x96, 0x30, 0xBC, 0x28, 0x95, 0xC4, 0x08, 0x68, 0x9A, 0x0D, 0x2A, 0xB9,
  0x40,
  // "'" (U+0027)
  0x18, 0x1A, 0x17,
  // "(" (U+0028)
  0x18, 0x92, 0x35, 0x09, 0x03, 0x50, 0x81, 0x09, 0x20, 0x92, 0x09, 0x20, 0x70, 0x11,
  // ")" (U+0029)
  0x20, 0x82, 0x09, 0x20, 0x92, 0x09, 0x28, 0x79, 0x04, 0x50, 0x90, 0x44, 0x10,
  // "*" (U+002A)
  0x28, 0x77, 0x01, 0x9B, 0x50, 0x98, 0x20, 0x10, 0x31,
  // "+" (U+002B)
  0x18, 0x90, 0x44, 0x07, 0xCC, 0x60, 0x44, 0x20, 0x04, 0x10,
  // "," (U+002C)
  0x18, 0x1A, 0x26,
  // "-" (U+002D)
  0x09, 0x0B,
  // "." (U+002E)
  0x07,
  // "/" (U+002F)
  0x30, 0x70, 0x23, 0x09, 0x30, 0x60, 0x33, 0x09, 0x30, 0x40, 0x53, 0x09, 0x30, 0x20, 0x73,
  // "0" (U+0030)
  0x18, 0xB0, 0x6C, 0x21, 0x93, 0x65, 0x43, 0x69, 0x15, 0x4A, 0x08, 0x1A, 0x0A, 0x06, 0xC3, 0x10,
  // "1" (U+0031)
  0x89, 0x32, 0xD9, 0xA0, 0x93, 0x66, 0x48, 0x1A, 0x10,
  // "2" (U+0032)
  0x28, 0x1A, 0xC2, 0x28, 0x11, 0x46, 0x30, 0x60, 0x33, 0x0A, 0x30, 0x90, 0x22, 0x06, 0x04, 0x28,
  0x21, 0xEB, 0x81,
  // "3" (U+0033)
  0x18, 0x1A, 0xC2, 0x20, 0x40, 0x62, 0x83, 0x83, 0x0C, 0x83, 0x0B, 0x38, 0x3A, 0x0B, 0xC4, 0x10,
  // "4" (U+0034)
  0x28, 0xA7, 0x76, 0x01, 0xC3, 0x08, 0x91, 0x17, 0x90, 0x80, 0x90, 0xBA, 0xD2, 0x03, 0x51,
  // "5" (U+0035)
  0x18, 0x3A, 0xB5, 0x09, 0x20, 0x20, 0x72, 0x81, 0x4D, 0x93, 0x0B, 0x38, 0x3B, 0x0B, 0xC5, 0x10,
  // "6" (U+0036)
  0x18, 0x33, 0xC7, 0x0B, 0x20, 0x40, 0x72, 0x89, 0x58, 0xAB, 0x0A, 0x28, 0x29, 0x09, 0x05, 0xC7,
  0x10,
  // "7" (U+0037)
  0x82, 0x1B, 0xBA, 0x20, 0x05, 0x20, 0xA2, 0x02, 0x07, 0x20, 0x80, 0x12, 0x09, 0x20, 0x60, 0x42,
  // "8" (U+0038)
  0x18, 0xB0, 0x8C, 0x41, 0x92, 0x80, 0xCA, 0x31, 0xB8, 0x09, 0x1A, 0x0A, 0x0A, 0x08, 0xC7, 0x10,
  // "9" (U+0039)
  0x18, 0xA0, 0x8C, 0x22, 0x74, 0x66, 0x34, 0x56, 0x38, 0x32, 0xBB, 0x28, 0x41, 0x80, 0xAB, 0x11,
  // ":" (U+003A)
  0x01, 0x05, 0x60, 0x71,
  // ";" (U+003B)
  0x10, 0x10, 0x67, 0x05, 0x28, 0x29, 0x03, 0x31,
  // "<" (U+003C)
  0x28, 0x72, 0x41, 0x87, 0x04, 0x92, 0x30, 0x60, 0x50,
  // "=" (U+003D)
  0x82, 0x6B, 0xB6, 0x48, 0x26, 0xBB, 0x60,
  // ">" (U+003E)
  0x05, 0x02, 0x38, 0x77, 0x81, 0x02, 0x94, 0x56, 0x20,
  // "?" (U+003F)
  0x81, 0x2B, 0xA2, 0x89, 0x4A, 0x01, 0x90, 0x91, 0x26, 0x02, 0x10, 0x62,
  // "@" (U+0040)
  0x18, 0x21, 0xAB, 0x72, 0x8B, 0x59, 0x10, 0x70, 0x35, 0x9C, 0x52, 0x74, 0x57, 0x61, 0x76, 0x37,
  0x80, 0x74, 0x9A, 0x40, 0x72, 0x48, 0x21, 0xAB, 0x32,
  // "A" (U+0041)
  0x20, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81, 0x8B, 0xD2, 0x87, 0xA0,
  0x91, 0x46, 0x08, 0x10,
  // "B" (U+0042)
  0x18, 0xB0, 0xBC, 0x70, 0xA0, 0xB2, 0x81, 0x94, 0xDD, 0x17, 0x35, 0x59, 0x06, 0x4C, 0xB9, 0x10,
  // "C" (U+0043)
  0x18, 0x32, 0xBB, 0x0B, 0x20, 0x40, 0x62, 0x07, 0x02, 0x20, 0x90, 0x12, 0x08, 0x03, 0x28, 0x12,
  0xCA, 0x10,
  // "D" (U+0044)
  0x18, 0xB0, 0xBC, 0x60, 0xA0, 0xB2, 0x80, 0xA4, 0x50, 0xB7, 0x20, 0xA9, 0x08, 0x4C, 0xB7, 0x10,
  // "E" (U+0045)
  0x18, 0x3B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20, 0x93, 0x81, 0xCB, 0x51,
  // "F" (U+0046)
  0x18, 0x3B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4C, 0xA0, 0x72, 0x20, 0x93, 0x0A, 0x30,
  // "G" (U+0047)
  0x18, 0x53, 0xBC, 0x30, 0xB1, 0x20, 0x40, 0x63, 0x8A, 0x17, 0x25, 0xC0, 0x91, 0x0A, 0x08, 0x30,
  0x90, 0x2C, 0xC5, 0x10,
  // "H" (U+0048)
  0x18, 0xB7, 0xA0, 0x45, 0x0A, 0x06, 0x31, 0x80, 0x90, 0x4C, 0xAC, 0x07, 0x30, 0x90, 0x90, 0x27,
  0x0A, 0x04, 0x51,
  // "I" (U+0049)
  0x18, 0x11, 0xD6, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28, 0x47, 0x30, 0x2C, 0x51,
  // "J" (U+004A)
  0x30, 0xA3, 0x09, 0x20, 0x20, 0x72, 0x05, 0x04, 0x20, 0x90, 0x12, 0x0A, 0x28, 0x41, 0xA0, 0x1C,
  0x31,
  // "K" (U+004B)
  0x18, 0x92, 0xA0, 0xA1, 0x0A, 0x65, 0x02, 0xAA, 0x28, 0x14, 0xE5, 0x28, 0x17, 0x58, 0x28, 0x19,
  0x0A, 0x28, 0x1A, 0x0A, 0x20,
  // "L" (U+004C)
  0x10, 0xA2, 0x89, 0x2A, 0x02, 0x80, 0x45, 0x07, 0x20, 0x92, 0x81, 0xCA, 0x40,
  // "M" (U+004D)
  0x18, 0xC6, 0xC3, 0x06, 0xA0, 0xD4, 0x0B, 0x82, 0xB5, 0x3B, 0x54, 0x76, 0x88, 0x27, 0x47, 0x89,
  0x09, 0x1D, 0x3A, 0x09, 0x0C, 0x09, 0x10,
  // "N" (U+004E)
  0x18, 0xB7, 0xC2, 0x09, 0x0D, 0x52, 0x72, 0x98, 0x54, 0x45, 0x98, 0x17, 0x29, 0x90, 0x90, 0x8A,
  0x09, 0x05, 0x91,
  // "O" (U+004F)
  0x18, 0x13, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22,
  0x90, 0x2C, 0xB1, 0x10,
  // "P" (U+0050)
  0x18, 0xA3, 0xBC, 0x40, 0xA0, 0xA2, 0x90, 0x94, 0x65, 0x67, 0xC9, 0x0A, 0x12, 0x0A, 0x30,
  // "Q" (U+0051)
  0x18, 0x13, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22,
  0x90, 0x2C, 0xC1, 0x30, 0xB4, 0x04, 0x20,
  // "R" (U+0052)
  0x18, 0xB0, 0xBC, 0x50, 0xA0, 0xA2, 0x73, 0x84, 0xDC, 0x17, 0x39, 0x09, 0x0A, 0x0A, 0x0A, 0x10,
  // "S" (U+0053)
  0x18, 0x39, 0xB5, 0x37, 0x20, 0x30, 0x83, 0x09, 0x04, 0x30, 0xA3, 0x83, 0xB0, 0xCC, 0x41,
  // "T" (U+0054)
  0x85, 0x3C, 0xD8, 0x05, 0x52, 0x07, 0x02, 0x20, 0xA3, 0x0A, 0x30, 0xA2, 0x02, 0x07, 0x20,
  // "U" (U+0055)
  0x18, 0xB6, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91, 0x45,
  0x04, 0xB9, 0x20,
  // "V" (U+0056)
  0x8A, 0x04, 0x50, 0x91, 0x36, 0x0A, 0x03, 0x65, 0x50, 0x36, 0xA2, 0x81, 0x28, 0x82, 0x81, 0x2D,
  0x32, 0x01, 0x0D, 0x30,
  // "W" (U+0057)
  0x8B, 0x73, 0x50, 0xB0, 0x72, 0x45, 0x4C, 0x0A, 0x04, 0x58, 0x92, 0x70, 0x45, 0x88, 0x72, 0x04,
  0x94, 0x89, 0x28, 0x34, 0xD0, 0x97, 0x28, 0x34, 0x90, 0xB2, 0x20,
  // "X" (U+0058)
  0x28, 0x19, 0x19, 0x28, 0x1A, 0x72, 0x20, 0x09, 0x30, 0xA0, 0x42, 0x81, 0x2B, 0x52, 0x86, 0x92,
  0x80, 0x37, 0x0A, 0x10,
  // "Y" (U+0059)
  0x89, 0x13, 0x61, 0x91, 0x87, 0x30, 0x99, 0x20, 0xD0, 0x42, 0x0A, 0x30, 0xA2, 0x02, 0x08, 0x20,
  // "Z" (U+005A)
  0x28, 0x1B, 0xD7, 0x30, 0x90, 0x12, 0x02, 0x08, 0x30, 0x90, 0x12, 0x03, 0x08, 0x30, 0x90, 0x12,
  0x82, 0x2E, 0xB6, 0x10,
  // "[" (U+005B)
  0x20, 0xB0, 0x92, 0x09, 0x20, 0x20, 0x72, 0x05, 0x04, 0x20, 0x80, 0x12, 0x09, 0x30, 0x92, 0x81,
  0x1C, 0x41,
  // "\" (U+005C)
  0x01, 0x07, 0x20, 0x82, 0x09, 0x20, 0x92, 0x09, 0x20, 0x82, 0x07, 0x01,
  // "]" (U+005D)
  0x18, 0x11, 0xC5, 0x20, 0x60, 0x22, 0x08, 0x30, 0x93, 0x09, 0x20, 0x30, 0x62, 0x83, 0x63, 0x05,
  0xC2,
  // "^" (U+005E)
  0x10, 0x10, 0x32, 0x89, 0x17, 0x90, 0x17, 0x80, 0x81, 0x45,
  // "_" (U+005F)
  0x81, 0x59, 0x80,
  // "`" (U+0060)
  0x82, 0x50, 0x62,
  // "a" (U+0061)
  0x18, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "b" (U+0062)
  0x10, 0x93, 0x09, 0x28, 0xA1, 0x1B, 0xC3, 0x48, 0x37, 0x72, 0x45, 0xA1, 0x91, 0x9B, 0x71,
  // "c" (U+0063)
  0x18, 0x4A, 0xB5, 0x50, 0x92, 0x0A, 0x28, 0x16, 0xC3,
  // "d" (U+0064)
  0x30, 0x93, 0x8A, 0x29, 0x0A, 0x99, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7A, 0xA1,
  // "e" (U+0065)
  0x18, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x10,
  // "f" (U+0066)
  0x20, 0x60, 0xA2, 0x0A, 0x28, 0x44, 0xD3, 0x03, 0x62, 0x06, 0x03, 0x20, 0x93, 0x0A, 0x30, 0x92,
  0x0B, 0x03, 0x20,
  // "g" (U+0067)
  0x18, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBB, 0x28, 0x41, 0x90, 0xBB, 0x21,
  // "h" (U+0068)
  0x10, 0xA3, 0x0A, 0x28, 0xA1, 0x1B, 0xC3, 0x47, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0x91,
  // "i" (U+0069)
  0x10, 0x62, 0x87, 0x18, 0x45, 0x72, 0x90, 0x91,
  // "j" (U+006A)
  0x20, 0x64, 0x89, 0x02, 0x70, 0x45, 0x07, 0x20, 0x92, 0x85, 0xA0, 0x18, 0x0C, 0x31,
  // "k" (U+006B)
  0x10, 0x93, 0x09, 0x28, 0xA1, 0x18, 0x83, 0x49, 0x70, 0x7D, 0x20, 0x94, 0x60, 0xA1, 0x91,
  // "l" (U+006C)
  0x18, 0x92, 0x90, 0x91, 0x84, 0x57, 0x29, 0x09, 0x10,
  // "m" (U+006D)
  0x8B, 0x31, 0xAC, 0x7C, 0x14, 0x75, 0x67, 0x37, 0x28, 0x19, 0x09, 0x09, 0x09, 0x0A, 0x09, 0x09,
  0x10,
  // "n" (U+006E)
  0x8A, 0x11, 0xAC, 0x34, 0x84, 0x57, 0x37, 0x2A, 0x09, 0x0A, 0x0A, 0x10,
  // "o" (U+006F)
  0x18, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "p" (U+0070)
  0x18, 0xA5, 0x1A, 0xC3, 0x04, 0x83, 0x70, 0x72, 0x45, 0x0A, 0x18, 0x10, 0xA9, 0x72, 0x09, 0x30,
  0x30, 0x63,
  // "q" (U+0071)
  0x18, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBB, 0x30, 0x92, 0x02, 0x07, 0x10,
  // "r" (U+0072)
  0x89, 0x01, 0xA8, 0x48, 0x07, 0x20, 0x92, 0x0A, 0x20,
  // "s" (U+0073)
  0x86, 0x3C, 0x87, 0x30, 0x1A, 0x28, 0x36, 0x4B, 0xC1,
  // "t" (U+0074)
  0x18, 0x92, 0x80, 0x5D, 0x34, 0x50, 0x72, 0x09, 0x20, 0x80, 0x71,
  // "u" (U+0075)
  0x8A, 0x12, 0x72, 0x85, 0x44, 0x58, 0x27, 0x2A, 0x0B, 0x08, 0x8A, 0x10,
  // "v" (U+0076)
  0x89, 0x48, 0x17, 0x37, 0x2B, 0x07, 0x86, 0x06, 0xD2, 0x05, 0x09, 0x20,
  // "w" (U+0077)
  0x8A, 0x68, 0x1B, 0x29, 0x83, 0xC3, 0x88, 0x87, 0x83, 0x89, 0x6A, 0x08, 0x66, 0x81,
  // "x" (U+0078)
  0x18, 0x24, 0x59, 0x12, 0x0B, 0x07, 0x30, 0xD3, 0x86, 0x7A, 0x20, 0x19, 0x46, 0x10,
  // "y" (U+0079)
  0x18, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C, 0x30, 0x40, 0x83, 0x08, 0x02,
  0x20, 0x08, 0x30,
  // "z" (U+007A)
  0x18, 0x13, 0xBA, 0x28, 0x36, 0x20, 0x18, 0x28, 0x48, 0x10, 0x1D, 0xB1,
  // "{" (U+007B)
  0x18, 0x41, 0xC1, 0x06, 0x32, 0x09, 0x30, 0x92, 0x0B, 0x04, 0x20, 0x30, 0x62, 0x05, 0x03, 0x20,
  0x30, 0x92,
  // "|" (U+007C)
  0x80, 0x58,
  // "}" (U+007D)
  0x20, 0xC3, 0x08, 0x01, 0x20, 0x93, 0x09, 0x38, 0x39, 0x60, 0x37, 0x28, 0x38, 0x20, 0x59, 0x20,
  // "~" (U+007E)
  0x82, 0x7B, 0xB7,
  // "¡" (U+00A1)
  0x18, 0x92, 0x71, 0x25, 0x38, 0x0A, 0x0A, 0x02, 0x10,
  // "¢" (U+00A2)
  0x28, 0x68, 0x10, 0x83, 0x11, 0x72, 0x04, 0x05, 0x20, 0x05, 0x28, 0x11, 0xC7, 0x20, 0x72,
  // "£" (U+00A3)
  0x28, 0x13, 0xC8, 0x20, 0x90, 0x13, 0x09, 0x38, 0x16, 0xE8, 0x20, 0x20, 0x73, 0x06, 0x03, 0x28,
  0x21, 0xEB, 0x91,
  // "¤" (U+00A4)
  0x89, 0x64, 0xBB, 0x83, 0x40, 0x72, 0x51, 0x74, 0xAB, 0x70,
  // "¥" (U+00A5)
  0x18, 0x90, 0x90, 0xA0, 0x94, 0x50, 0x99, 0x28, 0x90, 0x97, 0x04, 0xD9, 0x08, 0xE8, 0x20, 0x92,
  // "¦" (U+00A6)
  0x80, 0x08, 0x20, 0xF8,
  // "§" (U+00A7)
  0x18, 0x3A, 0xC1, 0x09, 0x28, 0x91, 0x1B, 0x60, 0x63, 0x90, 0x1C, 0x52, 0x84, 0x46, 0x0A, 0xC1,
  0x10,
  // "¨" (U+00A8)
  0x81, 0x42, 0x40,
  // "©" (U+00A9)
  0x18, 0x21, 0x77, 0x62, 0x89, 0x01, 0x85, 0x95, 0x70, 0x61, 0x92, 0x83, 0x51, 0x61, 0x72, 0x83,
  0x33, 0x61, 0x92, 0x86, 0x51, 0x07, 0x58, 0x47, 0x28, 0x21, 0x66, 0x52,
  // "ª" (U+00AA)
  0x87, 0x18, 0x95, 0x17, 0x47, 0x50,
  // "«" (U+00AB)
  0x18, 0x90, 0x62, 0x36, 0x59, 0x07, 0x48, 0x20, 0x03, 0x10,
  // "¬" (U+00AC)
  0x82, 0x7B, 0xB7, 0x30, 0x83, 0x07,
  // "®" (U+00AE)
  0x18, 0x21, 0x77, 0x62, 0x8C, 0x01, 0x88, 0x94, 0x70, 0x60, 0x93, 0x65, 0x16, 0x0A, 0xB1, 0x33,
  0x60, 0x94, 0x45, 0x10, 0x73, 0x05, 0x72, 0x82, 0x16, 0x65, 0x20,
  // "¯" (U+00AF)
  0x01, 0x0F, 0x80,
  // "°" (U+00B0)
  0x87, 0x38, 0x37, 0x08, 0x38, 0x30,
  // "±" (U+00B1)
  0x18, 0x90, 0x44, 0x07, 0xCC, 0x60, 0x44, 0x28, 0x54, 0x40, 0x7B, 0xB6,
  // "²" (U+00B2)
  0x10, 0x60, 0x52, 0x85, 0x70, 0x70, 0x58, 0x20,
  // "³" (U+00B3)
  0x18, 0x91, 0x65, 0x07, 0x40, 0x16, 0x47, 0x10,
  // "´" (U+00B4)
  0x81, 0x23, 0x81,
  // "µ" (U+00B5)
  0x18, 0xA0, 0x28, 0x18, 0x04, 0x54, 0x50, 0x72, 0x72, 0x0A, 0x0B, 0x28, 0x4C, 0x9A, 0x01, 0x93,
  0x03, 0x05, 0x30,
  // "¶" (U+00B6)
  0x18, 0xA1, 0xCE, 0x93, 0xF9, 0x74, 0xF9, 0x72, 0xF9, 0x70, 0x57, 0x72, 0x06, 0x07, 0x20, 0x60,
  0x72, 0x06, 0x07, 0x20, 0x01,
  // "·" (U+00B7)
  0x07,
  // "¸" (U+00B8)
  0x18, 0x31, 0x08, 0x45,
  // "¹" (U+00B9)
  0x85, 0x23, 0x84, 0x61, 0x71,
  // "º" (U+00BA)
  0x87, 0x18, 0x65, 0x17, 0x38, 0x30,
  // "»" (U+00BB)
  0x89, 0x43, 0x15, 0x01, 0x89, 0x16, 0x59, 0x03, 0x32,
  // "¼" (U+00BC)
  0x48, 0x90, 0x70, 0x23, 0x71, 0x08, 0x75, 0x28, 0xA0, 0x6A, 0x17, 0x0D, 0x37, 0x60, 0x74, 0x96,
  0x71, 0x03, 0x10,
  // "½" (U+00BD)
  0x40, 0x72, 0x82, 0x23, 0x71, 0x28, 0x18, 0x75, 0x38, 0x66, 0xA0, 0x65, 0x0D, 0x32, 0x81, 0x70,
  0x72, 0x86, 0x70, 0x71, 0x05, 0x82,
  // "¾" (U+00BE)
  0x58, 0x92, 0x70, 0x65, 0x07, 0x10, 0x74, 0x25, 0x28, 0x91, 0x16, 0x81, 0x74, 0x77, 0x37, 0x62,
  0x87, 0x74, 0x96, 0x07, 0x10, 0x31,
  // "¿" (U+00BF)
  0x28, 0x94, 0x60, 0x12, 0x06, 0x21, 0x90, 0x91, 0x0A, 0x28, 0x1A, 0xB2,
  // "À" (U+00C0)
  0x30, 0x54, 0x06, 0x02, 0x20, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81,
  0x8B, 0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Á" (U+00C1)
  0x30, 0x20, 0x33, 0x08, 0x30, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81,
  0x8B, 0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Â" (U+00C2)
  0x30, 0x10, 0x43, 0x07, 0x08, 0x20, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92,
  0x81, 0x8B, 0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Ã" (U+00C3)
  0x28, 0x21, 0xFA, 0x22, 0x07, 0x0B, 0x40, 0xA0, 0x93, 0x81, 0x37, 0x93, 0x81, 0x8B, 0xD3, 0x89,
  0x0A, 0x09, 0x10, 0x46, 0x08, 0x11,
  // "Ä" (U+00C4)
  0x28, 0x14, 0x24, 0x20, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81, 0x8B,
  0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Å" (U+00C5)
  0x30, 0x50, 0x42, 0x81, 0x1F, 0x42, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81, 0x8B,
  0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Æ" (U+00C6)
  0x38, 0x2A, 0xEB, 0x42, 0x81, 0x29, 0x84, 0x81, 0x86, 0x54, 0x82, 0xA7, 0xC8, 0x28, 0x16, 0xCD,
  0x48, 0x1B, 0x0A, 0x38, 0x44, 0x60, 0xEB, 0x31,
  // "Ç" (U+00C7)
  0x18, 0x32, 0xBB, 0x0B, 0x20, 0x40, 0x62, 0x07, 0x02, 0x20, 0x90, 0x12, 0x08, 0x03, 0x28, 0x12,
  0xEA, 0x20, 0x82, 0x04, 0x05, 0x20,
  // "È" (U+00C8)
  0x20, 0x53, 0x86, 0x62, 0x0B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20, 0x93,
  0x81, 0xCB, 0x51,
  // "É" (U+00C9)
  0x20, 0x20, 0x32, 0x08, 0x28, 0x3B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20,
  0x93, 0x81, 0xCB, 0x51,
  // "Ê" (U+00CA)
  0x20, 0x10, 0x42, 0x86, 0x78, 0x0B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20,
  0x93, 0x81, 0xCB, 0x51,
  // "Ë" (U+00CB)
  0x18, 0x74, 0x24, 0x0B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20, 0x93, 0x81,
  0xCB, 0x51,
  // "Ì" (U+00CC)
  0x20, 0x53, 0x84, 0x62, 0x01, 0xD6, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28, 0x47,
  0x30, 0x2C, 0x51,
  // "Í" (U+00CD)
  0x30, 0x20, 0x33, 0x08, 0x28, 0x11, 0xD6, 0x30, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30,
  0x70, 0x32, 0x81, 0x2C, 0x52,
  // "Î" (U+00CE)
  0x20, 0x10, 0x42, 0x84, 0x78, 0x01, 0xD6, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28,
  0x47, 0x30, 0x2C, 0x51,
  // "Ï" (U+00CF)
  0x28, 0x54, 0x24, 0x01, 0xD6, 0x30, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30, 0x70, 0x32,
  0x81, 0x2C, 0x52,
  // "Ð" (U+00D0)
  0x18, 0xB0, 0xBC, 0x60, 0xA0, 0xB2, 0x80, 0xA9, 0xD2, 0xB7, 0x30, 0xA9, 0x08, 0x4C, 0xC7, 0x10,
  // "Ñ" (U+00D1)
  0x18, 0xB7, 0xCA, 0xBB, 0x0D, 0x52, 0x72, 0x98, 0x54, 0x45, 0x98, 0x17, 0x29, 0x90, 0x90, 0x8A,
  0x09, 0x05, 0x91,
  // "Ò" (U+00D2)
  0x20, 0x54, 0x06, 0x02, 0x28, 0x13, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73,
  0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x10,
  // "Ó" (U+00D3)
  0x30, 0x20, 0x33, 0x08, 0x28, 0x13, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73,
  0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x10,
  // "Ô" (U+00D4)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x28, 0x13, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20,
  0x73, 0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x10,
  // "Õ" (U+00D5)
  0x10, 0x3A, 0x8B, 0x42, 0x0B, 0x06, 0x44, 0x60, 0x55, 0x72, 0x07, 0x39, 0x10, 0xA0, 0x82, 0x29,
  0x02, 0xCB, 0x11,
  // "Ö" (U+00D6)
  0x28, 0x54, 0x24, 0x03, 0xBB, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A,
  0x08, 0x22, 0x90, 0x2C, 0xB1, 0x10,
  // "×" (U+00D7)
  0x01, 0x28, 0x93, 0x12, 0x99, 0x20, 0x99, 0x04, 0x22, 0x30,
  // "Ø" (U+00D8)
  0x48, 0xC3, 0x10, 0x3B, 0xB6, 0x0B, 0x0B, 0x44, 0x56, 0x95, 0x84, 0x97, 0x39, 0xC1, 0xA0, 0x87,
  0x29, 0x08, 0xCB, 0x10, 0x14,
  // "Ù" (U+00D9)
  0x20, 0x54, 0x06, 0x02, 0x28, 0xB6, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08,
  0x20, 0x90, 0x91, 0x45, 0x04, 0xB9, 0x20,
  // "Ú" (U+00DA)
  0x30, 0x20, 0x33, 0x08, 0x28, 0xB6, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08,
  0x20, 0x90, 0x91, 0x45, 0x04, 0xB9, 0x20,
  // "Û" (U+00DB)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x28, 0xB6, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A,
  0x08, 0x20, 0x90, 0x91, 0x45, 0x04, 0xB9, 0x20,
  // "Ü" (U+00DC)
  0x28, 0xC2, 0x42, 0x40, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90,
  0x91, 0x45, 0x04, 0xB9, 0x20,
  // "Ý" (U+00DD)
  0x20, 0x20, 0x32, 0x89, 0x38, 0x03, 0x61, 0x91, 0x87, 0x30, 0x99, 0x20, 0xD0, 0x42, 0x0A, 0x30,
  0xA2, 0x02, 0x08, 0x20,
  // "Þ" (U+00DE)
  0x10, 0xA3, 0x8A, 0x2D, 0xA1, 0x28, 0x47, 0x45, 0x36, 0x73, 0x83, 0xAC, 0x70, 0xA3,
  // "ß" (U+00DF)
  0x28, 0x16, 0xC6, 0x28, 0x92, 0xA1, 0x80, 0x27, 0x91, 0x05, 0x68, 0x28, 0x18, 0x1A, 0x28, 0x91,
  0xA0, 0x73, 0x0A, 0xBB, 0x02, 0x83, 0x0C, 0x02, 0x30,
  // "à" (U+00E0)
  0x10, 0x53, 0x06, 0x02, 0x68, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "á" (U+00E1)
  0x20, 0x20, 0x32, 0x08, 0x68, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "â" (U+00E2)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x68, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA,
  0x10,
  // "ã" (U+00E3)
  0x18, 0xA4, 0x8A, 0x20, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "ä" (U+00E4)
  0x18, 0x14, 0x24, 0x58, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "å" (U+00E5)
  0x20, 0x50, 0x42, 0x8A, 0x35, 0x40, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBA, 0x10,
  // "æ" (U+00E6)
  0x18, 0xA3, 0xA9, 0xBC, 0x15, 0x56, 0x66, 0x39, 0x08, 0x96, 0x0A, 0x0D, 0x12, 0x83, 0x7A, 0xAC,
  0x71,
  // "ç" (U+00E7)
  0x18, 0x4A, 0xB5, 0x50, 0x92, 0x0A, 0x28, 0x66, 0xD3, 0x08, 0x04, 0x51,
  // "è" (U+00E8)
  0x10, 0x53, 0x06, 0x02, 0x68, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x10,
  // "é" (U+00E9)
  0x20, 0x20, 0x32, 0x08, 0x68, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x10,
  // "ê" (U+00EA)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x68, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6,
  0x10,
  // "ë" (U+00EB)
  0x18, 0x14, 0x24, 0x58, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x10,
  // "ì" (U+00EC)
  0x82, 0x50, 0x62, 0x28, 0x71, 0x84, 0x57, 0x29, 0x09, 0x10,
  // "í" (U+00ED)
  0x18, 0x22, 0x30, 0x84, 0x89, 0x01, 0x80, 0x45, 0x07, 0x20, 0x92, 0x09, 0x20,
  // "î" (U+00EE)
  0x82, 0x14, 0x78, 0x28, 0x71, 0x84, 0x57, 0x29, 0x09, 0x10,
  // "ï" (U+00EF)
  0x81, 0x42, 0x43, 0x89, 0x01, 0x80, 0x45, 0x07, 0x20, 0x92, 0x09, 0x20,
  // "ð" (U+00F0)
  0x18, 0xB4, 0x32, 0x30, 0x4D, 0x10, 0x27, 0x20, 0xAB, 0x47, 0x37, 0x4A, 0x07, 0x2A, 0x0A, 0x07,
  0xC5, 0x10,
  // "ñ" (U+00F1)
  0x18, 0xA4, 0x8A, 0x21, 0xAC, 0x34, 0x84, 0x57, 0x37, 0x2A, 0x09, 0x0A, 0x0A, 0x10,
  // "ò" (U+00F2)
  0x10, 0x53, 0x06, 0x02, 0x68, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "ó" (U+00F3)
  0x20, 0x20, 0x32, 0x08, 0x68, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "ô" (U+00F4)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x68, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6,
  0x10,
  // "õ" (U+00F5)
  0x18, 0xA4, 0x8A, 0x20, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "ö" (U+00F6)
  0x18, 0x14, 0x24, 0x58, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "÷" (U+00F7)
  0x18, 0x53, 0x30, 0x7B, 0xB6, 0x50, 0x03, 0x10,
  // "ø" (U+00F8)
  0x38, 0xA4, 0x10, 0xAC, 0x56, 0x5A, 0x49, 0x67, 0x4A, 0x69, 0x09, 0xC6, 0x02, 0x30,
  // "ù" (U+00F9)
  0x10, 0x53, 0x06, 0x02, 0x58, 0xA1, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x88, 0xA1,
  // "ú" (U+00FA)
  0x20, 0x20, 0x32, 0x08, 0x58, 0xA1, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x88, 0xA1,
  // "û" (U+00FB)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x58, 0xA1, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x88,
  0xA1,
  // "ü" (U+00FC)
  0x18, 0x14, 0x24, 0x48, 0xA1, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x88, 0xA1,
  // "ý" (U+00FD)
  0x30, 0x20, 0x33, 0x08, 0x78, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C, 0x30,
  0x40, 0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "þ" (U+00FE)
  0x20, 0xA4, 0x0A, 0x38, 0xA5, 0x1B, 0xC3, 0x04, 0x83, 0x70, 0x72, 0x45, 0x0A, 0x19, 0x10, 0xAB,
  0x72, 0x08, 0x30, 0x30, 0x63,
  // "ÿ" (U+00FF)
  0x28, 0x14, 0x24, 0x68, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C, 0x30, 0x40,
  0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "Ā" (U+0100)
  0x28, 0x11, 0xF8, 0x20, 0x70, 0xB3, 0x0A, 0x09, 0x28, 0x13, 0x79, 0x28, 0x18, 0xBD, 0x28, 0x7A,
  0x09, 0x14, 0x60, 0x81,
  // "ā" (U+0101)
  0x28, 0xA3, 0x88, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA1,
  // "Ă" (U+0102)
  0x30, 0x30, 0x22, 0x81, 0x1F, 0x72, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81, 0x8B,
  0xD2, 0x87, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "ă" (U+0103)
  0x10, 0x30, 0x22, 0x00, 0x72, 0x8A, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA1,
  // "Ą" (U+0104)
  0x20, 0x10, 0xD3, 0x07, 0x0B, 0x30, 0xA0, 0x92, 0x81, 0x37, 0x92, 0x81, 0x8B, 0xD2, 0x87, 0xA0,
  0x91, 0x46, 0x0A, 0x12, 0x02, 0x05, 0x30, 0x20, 0x61,
  // "ą" (U+0105)
  0x18, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBB, 0x20, 0x20, 0x52, 0x02, 0x06,
  0x10,
  // "Ć" (U+0106)
  0x20, 0x20, 0x32, 0x08, 0x28, 0x32, 0xBB, 0x0B, 0x20, 0x40, 0x62, 0x07, 0x02, 0x20, 0x90, 0x12,
  0x08, 0x03, 0x28, 0x12, 0xCA, 0x10,
  // "ć" (U+0107)
  0x20, 0x20, 0x32, 0x08, 0x68, 0x3A, 0xB0, 0x55, 0x20, 0x93, 0x0A, 0x38, 0x16, 0xC3, 0x10,
  // "Ĉ" (U+0108)
  0x20, 0x10, 0x42, 0x86, 0x78, 0x02, 0xBB, 0x0B, 0x20, 0x40, 0x62, 0x07, 0x02, 0x20, 0x90, 0x12,
  0x08, 0x03, 0x28, 0x12, 0xCA, 0x10,
  // "ĉ" (U+0109)
  0x18, 0x31, 0x40, 0x78, 0x48, 0x4A, 0xB5, 0x50, 0x92, 0x0A, 0x28, 0x16, 0xC3,
  // "Ċ" (U+010A)
  0x38, 0x56, 0x02, 0xBB, 0x0B, 0x20, 0x40, 0x62, 0x07, 0x02, 0x20, 0x90, 0x12, 0x08, 0x03, 0x28,
  0x12, 0xCA, 0x10,
  // "ċ" (U+010B)
  0x20, 0x64, 0x84, 0xAB, 0x55, 0x09, 0x20, 0xA2, 0x81, 0x6C, 0x30,
  // "Č" (U+010C)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x12, 0xBB, 0x20, 0xB3, 0x04, 0x06, 0x30, 0x70, 0x23, 0x09,
  0x01, 0x30, 0x80, 0x33, 0x81, 0x2C, 0xA2,
  // "č" (U+010D)
  0x18, 0x43, 0x31, 0x07, 0x76, 0x83, 0xAB, 0x05, 0x52, 0x09, 0x30, 0xA3, 0x81, 0x6C, 0x31,
  // "Ď" (U+010E)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x1B, 0xC6, 0x28, 0xB1, 0xA0, 0xB0, 0x28, 0x0A, 0x04, 0x50,
  0xB0, 0x72, 0x0A, 0x09, 0x08, 0x40, 0xCB, 0x72,
  // "ď" (U+010F)
  0x30, 0xA0, 0x93, 0x8A, 0x2B, 0x10, 0xA9, 0x90, 0x55, 0x56, 0x09, 0x06, 0x30, 0xA0, 0xC2, 0x81,
  0x7A, 0xA2,
  // "Đ" (U+0110)
  0x18, 0xB0, 0xBC, 0x60, 0xA0, 0xB2, 0x80, 0xA9, 0xD2, 0xB7, 0x30, 0xA9, 0x08, 0x4C, 0xC7, 0x10,
  // "đ" (U+0111)
  0x30, 0x93, 0x8B, 0x06, 0xD3, 0x0A, 0x99, 0x05, 0x55, 0x70, 0x90, 0x64, 0x0A, 0x0C, 0x10, 0x7A,
  0xA2,
  // "Ē" (U+0112)
  0x18, 0x3B, 0xFE, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20, 0x93, 0x81, 0xCB, 0x51,
  // "ē" (U+0113)
  0x10, 0x08, 0x28, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x10,
  // "Ĕ" (U+0114)
  0x28, 0x63, 0x20, 0xBF, 0xE0, 0xA2, 0x02, 0x08, 0x28, 0x44, 0xDA, 0x07, 0x32, 0x09, 0x38, 0x1C,
  0xB5, 0x10,
  // "ĕ" (U+0115)
  0x10, 0x30, 0x22, 0x00, 0x72, 0x89, 0x2A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA3, 0x81, 0x6C, 0x61,
  // "Ė" (U+0116)
  0x20, 0x62, 0x83, 0xBB, 0x60, 0xA2, 0x02, 0x08, 0x28, 0x44, 0xDA, 0x07, 0x32, 0x09, 0x38, 0x1C,
  0xB5, 0x10,
  // "ė" (U+0117)
  0x20, 0x66, 0x89, 0x2A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA3, 0x81, 0x6C, 0x61,
  // "Ę" (U+0118)
  0x18, 0x3B, 0xB6, 0x0A, 0x20, 0x20, 0x82, 0x84, 0x4D, 0xA0, 0x73, 0x20, 0x93, 0x84, 0xCD, 0x50,
  0x25, 0x20, 0x20, 0x62,
  // "ę" (U+0119)
  0x18, 0x92, 0xAC, 0x05, 0x59, 0x19, 0xB6, 0x0A, 0x38, 0x16, 0xC6, 0x20, 0x73, 0x0A, 0x02, 0x10,
  // "Ě" (U+011A)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x1B, 0xB6, 0x20, 0xA3, 0x02, 0x08, 0x38, 0x14, 0xDA, 0x20,
  0x70, 0x33, 0x09, 0x48, 0x1C, 0xB5, 0x20,
  // "ě" (U+011B)
  0x18, 0x43, 0x31, 0x07, 0x76, 0x89, 0x2A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA3, 0x81, 0x6C, 0x61,
  // "Ĝ" (U+011C)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x28, 0x53, 0xBC, 0x30, 0xB1, 0x20, 0x40, 0x63, 0x8A, 0x17, 0x25,
  0xC0, 0x91, 0x0A, 0x08, 0x30, 0x90, 0x2C, 0xC5, 0x10,
  // "ĝ" (U+011D)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x68, 0xA0, 0xA9, 0x85, 0x55, 0x69, 0x06, 0x3A, 0x0C, 0x07, 0xBB,
  0x28, 0x41, 0x90, 0xBB, 0x21,
  // "Ğ" (U+011E)
  0x20, 0x30, 0x22, 0x03, 0xA8, 0x23, 0x0B, 0x12, 0x04, 0x06, 0x38, 0xA1, 0x72, 0x5C, 0x09, 0x10,
  0xA0, 0x83, 0x09, 0x02, 0xCC, 0x51,
  // "ğ" (U+011F)
  0x10, 0x30, 0x22, 0x00, 0x72, 0x8A, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB2,
  0x84, 0x19, 0x0B, 0xB2, 0x10,
  // "Ġ" (U+0120)
  0x30, 0x62, 0x85, 0x3B, 0xC3, 0x0B, 0x12, 0x04, 0x06, 0x38, 0xA1, 0x72, 0x5C, 0x09, 0x10, 0xA0,
  0x83, 0x09, 0x02, 0xCC, 0x51,
  // "ġ" (U+0121)
  0x20, 0x66, 0x8A, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB2, 0x84, 0x19, 0x0B,
  0xB2, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x53, 0xBC, 0x30, 0xB1, 0x20, 0x40, 0x63, 0x8A, 0x17, 0x25, 0xC0, 0x91, 0x0A, 0x08, 0x30,
  0x90, 0x2C, 0xC5, 0x20, 0x53, 0x03, 0x04, 0x30,
  // "ģ" (U+0123)
  0x20, 0x72, 0x00, 0x22, 0x8A, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB2, 0x84,
  0x19, 0x0B, 0xB2, 0x10,
  // "Ĥ" (U+0124)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x28, 0xB7, 0xA0, 0x45, 0x0A, 0x06, 0x31, 0x80, 0x90, 0x4C, 0xAC,
  0x07, 0x30, 0x90, 0x90, 0x27, 0x0A, 0x04, 0x51,
  // "ĥ" (U+0125)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x60, 0xA3, 0x0A, 0x28, 0xA1, 0x1B, 0xC3, 0x47, 0x45, 0x73, 0x72,
  0x90, 0x90, 0xA0, 0x91,
  // "Ħ" (U+0126)
  0x18, 0xB7, 0xA0, 0x45, 0x5D, 0x9C, 0x82, 0x80, 0x90, 0x4D, 0xBC, 0x07, 0x30, 0x90, 0x90, 0x27,
  0x0A, 0x04, 0x51,
  // "ħ" (U+0127)
  0x10, 0x92, 0x81, 0x3D, 0x62, 0x8A, 0x0C, 0xC3, 0x37, 0x45, 0x62, 0x72, 0x90, 0x90, 0xA0, 0x91,
  // "Ĩ" (U+0128)
  0x10, 0x1A, 0x02, 0x20, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30, 0x70, 0x32, 0x81, 0x2C,
  0x52,
  // "ĩ" (U+0129)
  0x89, 0x38, 0xA2, 0x18, 0x04, 0x50, 0x72, 0x09, 0x20, 0x92,
  // "Ī" (U+012A)
  0x18, 0x11, 0xFE, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28, 0x47, 0x30, 0x2C, 0x51,
  // "ī" (U+012B)
  0x89, 0x18, 0x81, 0x84, 0x57, 0x29, 0x09, 0x10,
  // "Ĭ" (U+012C)
  0x28, 0x43, 0x20, 0x1F, 0xD2, 0x0A, 0x30, 0xA2, 0x01, 0x08, 0x20, 0x40, 0x52, 0x84, 0x73, 0x02,
  0xC5, 0x10,
  // "ĭ" (U+012D)
  0x89, 0x33, 0x27, 0x71, 0x84, 0x57, 0x29, 0x09, 0x10,
  // "Į" (U+012E)
  0x18, 0x11, 0xD6, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28, 0x77, 0x30, 0x2E, 0x50,
  0x25, 0x20, 0x20, 0x62,
  // "į" (U+012F)
  0x20, 0x64, 0x89, 0x01, 0x80, 0x45, 0x07, 0x20, 0x92, 0x85, 0xB0, 0x25, 0x02, 0x61,
  // "İ" (U+0130)
  0x38, 0x36, 0x01, 0xD6, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x82, 0x04, 0x05, 0x28, 0x47, 0x30, 0x2C,
  0x51,
  // "ı" (U+0131)
  0x87, 0x18, 0x45, 0x72, 0x90, 0x91,
  // "Ĳ" (U+0132)
  0x18, 0x21, 0xD6, 0xA2, 0x81, 0xA0, 0x92, 0x8A, 0x4A, 0x27, 0x01, 0x85, 0x40, 0x45, 0x91, 0x07,
  0x3A, 0x02, 0xC6, 0xA2, 0x81, 0x1C, 0x31,
  // "ĳ" (U+0133)
  0x18, 0x16, 0x06, 0x48, 0xA1, 0x18, 0x27, 0x45, 0x45, 0x72, 0x72, 0x90, 0x90, 0x90, 0xA2, 0x01,
  0x08, 0x20, 0xC0, 0x31,
  // "Ĵ" (U+0134)
  0x30, 0x10, 0x43, 0x07, 0x08, 0x30, 0xA4, 0x09, 0x30, 0x20, 0x73, 0x05, 0x04, 0x30, 0x90, 0x13,
  0x0A, 0x30, 0x10, 0xA2, 0x81, 0x1C, 0x32,
  // "ĵ" (U+0135)
  0x18, 0x31, 0x40, 0x78, 0x48, 0x90, 0x27, 0x04, 0x50, 0x72, 0x09, 0x28, 0x5A, 0x01, 0x80, 0xC3,
  0x10,
  // "Ķ" (U+0136)
  0x18, 0x92, 0xA0, 0xA1, 0x0A, 0x65, 0x02, 0xAA, 0x28, 0x14, 0xE5, 0x28, 0x17, 0x58, 0x28, 0x19,
  0x0A, 0x28, 0x1A, 0x0A, 0x30, 0x53, 0x03, 0x04, 0x30,
  // "ķ" (U+0137)
  0x10, 0x93, 0x09, 0x28, 0xA1, 0x18, 0x83, 0x49, 0x70, 0x7D, 0x20, 0x94, 0x60, 0xA1, 0x92, 0x05,
  0x20, 0x30, 0x42,
  // "ĸ" (U+0138)
  0x8A, 0x11, 0x88, 0x34, 0x97, 0x07, 0xD2, 0x09, 0x46, 0x0A, 0x19, 0x10,
  // "Ĺ" (U+0139)
  0x20, 0x20, 0x32, 0x08, 0x20, 0xA3, 0x0A, 0x20, 0x20, 0x82, 0x04, 0x05, 0x20, 0x70, 0x22, 0x09,
  0x38, 0x1C, 0xA4, 0x10,
  // "ĺ" (U+013A)
  0x18, 0x22, 0x30, 0x85, 0x09, 0x28, 0x92, 0x90, 0x18, 0x04, 0x50, 0x72, 0x09, 0x20, 0x92,
  // "Ļ" (U+013B)
  0x10, 0xA2, 0x89, 0x2A, 0x02, 0x80, 0x45, 0x07, 0x20, 0x92, 0x86, 0xCA, 0x40, 0x50, 0x34, 0x10,
  // "ļ" (U+013C)
  0x20, 0x92, 0x89, 0x29, 0x01, 0x80, 0x45, 0x07, 0x20, 0x92, 0x09, 0x28, 0x25, 0x03, 0x41,
  // "Ľ" (U+013D)
  0x18, 0x7A, 0x09, 0x0A, 0x11, 0x28, 0x20, 0x40, 0x52, 0x07, 0x02, 0x20, 0x93, 0x81, 0xCA, 0x41,
  // "ľ" (U+013E)
  0x18, 0x95, 0xA9, 0x0B, 0x11, 0x80, 0x45, 0x07, 0x20, 0x92, 0x09, 0x20,
  // "Ŀ" (U+013F)
  0x10, 0xA2, 0x89, 0x2A, 0x02, 0x80, 0x45, 0x67, 0x20, 0x92, 0x81, 0xCA, 0x40,
  // "ŀ" (U+0140)
  0x10, 0x92, 0x89, 0x29, 0x01, 0x80, 0x45, 0x67, 0x20, 0x92, 0x09, 0x20,
  // "Ł" (U+0141)
  0x10, 0xA2, 0x89, 0x7A, 0x01, 0x92, 0x5B, 0x1C, 0x30, 0x91, 0x0B, 0xA5,
  // "ł" (U+0142)
  0x18, 0x92, 0x90, 0x90, 0xA6, 0xA9, 0x39, 0x09, 0x10,
  // "Ń" (U+0143)
  0x30, 0x20, 0x33, 0x08, 0x28, 0xB7, 0xC2, 0x09, 0x0D, 0x52, 0x72, 0x98, 0x54, 0x45, 0x98, 0x17,
  0x29, 0x90, 0x90, 0x8A, 0x09, 0x05, 0x91,
  // "ń" (U+0144)
  0x20, 0x20, 0x32, 0x08, 0x58, 0xA1, 0x1A, 0xC3, 0x48, 0x45, 0x73, 0x72, 0xA0, 0x90, 0xA0, 0xA1,
  // "Ņ" (U+0145)
  0x18, 0xB7, 0xC2, 0x09, 0x0D, 0x52, 0x72, 0x98, 0x54, 0x45, 0x98, 0x17, 0x29, 0x90, 0x90, 0x8A,
  0x09, 0x05, 0x92, 0x05, 0x30, 0x30, 0x43,
  // "ņ" (U+0146)
  0x8A, 0x11, 0xAC, 0x34, 0x84, 0x57, 0x37, 0x2A, 0x09, 0x0A, 0x0A, 0x20, 0x52, 0x03, 0x04, 0x20,
  // "Ň" (U+0147)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0xB7, 0xC2, 0x09, 0x0D, 0x52, 0x72, 0x98, 0x54, 0x45, 0x98,
  0x17, 0x29, 0x90, 0x90, 0x8A, 0x09, 0x05, 0x91,
  // "ň" (U+0148)
  0x18, 0x43, 0x31, 0x07, 0x75, 0x8A, 0x11, 0xAC, 0x34, 0x84, 0x57, 0x37, 0x2A, 0x09, 0x0A, 0x0A,
  0x10,
  // "ŉ" (U+0149)
  0x10, 0xA2, 0x05, 0x03, 0x28, 0xA1, 0x1A, 0xC3, 0x48, 0x45, 0x73, 0x72, 0xA0, 0x90, 0xA0, 0xA1,
  // "Ŋ" (U+014A)
  0x18, 0xB7, 0xC2, 0x09, 0x0D, 0x53, 0x72, 0x88, 0x54, 0x45, 0x98, 0x17, 0x29, 0x90, 0x90, 0x7A,
  0x09, 0x04, 0x83, 0x04, 0x05, 0x20, 0x40, 0xB2,
  // "ŋ" (U+014B)
  0x8A, 0x11, 0xAC, 0x34, 0x74, 0x57, 0x27, 0x29, 0x09, 0x0A, 0x0A, 0x20, 0x10, 0x82, 0x0C, 0x03,
  0x10,
  // "Ō" (U+014C)
  0x10, 0x4A, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22, 0x90,
  0x2C, 0xB1, 0x10,
  // "ō" (U+014D)
  0x10, 0x08, 0x28, 0xA0, 0xAC, 0x15, 0x55, 0x59, 0x06, 0x4A, 0x0A, 0x06, 0xC6, 0x10,
  // "Ŏ" (U+014E)
  0x20, 0x30, 0x22, 0x03, 0xA2, 0x8B, 0x2B, 0x06, 0x44, 0x60, 0x55, 0x72, 0x07, 0x39, 0x10, 0xA0,
  0x82, 0x29, 0x02, 0xCB, 0x11,
  // "ŏ" (U+014F)
  0x10, 0x30, 0x22, 0x00, 0x72, 0x8A, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x61,
  // "Ő" (U+0150)
  0x28, 0x57, 0x74, 0x03, 0xCC, 0x28, 0xB2, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A,
  0x08, 0x22, 0x90, 0x2C, 0xB1, 0x10,
  // "ő" (U+0151)
  0x28, 0x17, 0x74, 0x30, 0x12, 0x89, 0x7A, 0xC1, 0x05, 0x55, 0x50, 0x90, 0x64, 0x0A, 0x0A, 0x28,
  0x16, 0xC6, 0x20,
  // "Œ" (U+0152)
  0x18, 0x74, 0xCE, 0xB7, 0x0B, 0x0A, 0x28, 0x24, 0x61, 0x92, 0x89, 0x08, 0x23, 0xDB, 0x09, 0x16,
  0x32, 0x82, 0x82, 0x91, 0x28, 0x32, 0xCE, 0xB6, 0x10,
  // "œ" (U+0153)
  0x18, 0xA3, 0xAB, 0x6C, 0x45, 0x55, 0x95, 0x59, 0x05, 0xC9, 0x0A, 0x0A, 0x32, 0x83, 0x6C, 0x6C,
  0x91,
  // "Ŕ" (U+0154)
  0x20, 0x20, 0x32, 0x08, 0x28, 0xB0, 0xBC, 0x50, 0xA0, 0xA2, 0x73, 0x84, 0xDC, 0x17, 0x39, 0x09,
  0x0A, 0x0A, 0x0A, 0x10,
  // "ŕ" (U+0155)
  0x20, 0x20, 0x32, 0x08, 0x58, 0x41, 0xA8, 0x04, 0x82, 0x07, 0x02, 0x20, 0x93, 0x0A, 0x30,
  // "Ŗ" (U+0156)
  0x18, 0xB0, 0xBC, 0x50, 0xA0, 0xA2, 0x73, 0x84, 0xDC, 0x17, 0x39, 0x09, 0x0A, 0x0A, 0x0A, 0x20,
  0x52, 0x03, 0x04, 0x20,
  // "ŗ" (U+0157)
  0x18, 0x41, 0xA8, 0x04, 0x82, 0x07, 0x02, 0x20, 0x93, 0x0A, 0x30, 0x52, 0x03, 0x04, 0x20,
  // "Ř" (U+0158)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x1B, 0xC5, 0x28, 0x97, 0xA0, 0xA0, 0x27, 0x38, 0x04, 0xDC,
  0x10, 0x73, 0x92, 0x81, 0x90, 0xA2, 0x81, 0xA0, 0xA2,
  // "ř" (U+0159)
  0x18, 0x43, 0x31, 0x07, 0x75, 0x84, 0x1A, 0x80, 0x48, 0x20, 0x70, 0x22, 0x09, 0x30, 0xA3,
  // "Ś" (U+015A)
  0x20, 0x20, 0x32, 0x08, 0x28, 0x39, 0xB5, 0x37, 0x20, 0x30, 0x83, 0x09, 0x04, 0x30, 0xA3, 0x83,
  0xB0, 0xCC, 0x41,
  // "ś" (U+015B)
  0x20, 0x20, 0x32, 0x08, 0x58, 0x43, 0xC8, 0x07, 0x32, 0x01, 0x0A, 0x38, 0x46, 0x40, 0xBC, 0x11,
  // "Ŝ" (U+015C)
  0x10, 0x10, 0x42, 0x07, 0x08, 0x28, 0x39, 0xB5, 0x37, 0x20, 0x30, 0x83, 0x09, 0x04, 0x30, 0xA3,
  0x83, 0xB0, 0xCC, 0x41,
  // "ŝ" (U+015D)
  0x18, 0x31, 0x40, 0x78, 0x38, 0x63, 0xC8, 0x73, 0x01, 0xA2, 0x83, 0x64, 0xBC, 0x10,
  // "Ş" (U+015E)
  0x18, 0x39, 0xB5, 0x37, 0x20, 0x30, 0x83, 0x09, 0x04, 0x30, 0xA3, 0x83, 0xB0, 0xCD, 0x42, 0x08,
  0x20, 0x40, 0x52,
  // "ş" (U+015F)
  0x86, 0x3C, 0x87, 0x30, 0x1A, 0x28, 0x90, 0x64, 0xBD, 0x10, 0x80, 0x45, 0x10,
  // "Š" (U+0160)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x49, 0xB5, 0x03, 0x73, 0x03, 0x08, 0x40, 0x90, 0x44, 0x0A,
  0x40, 0xB2, 0x81, 0xCC, 0x42,
  // "š" (U+0161)
  0x18, 0x43, 0x31, 0x07, 0x75, 0x84, 0x3C, 0x80, 0x73, 0x20, 0x10, 0xA3, 0x84, 0x64, 0x0B, 0xC1,
  0x10,
  // "Ţ" (U+0162)
  0x85, 0x3C, 0xD8, 0x05, 0x52, 0x07, 0x02, 0x20, 0xA3, 0x0A, 0x30, 0xA2, 0x02, 0x09, 0x30, 0x82,
  0x04, 0x05, 0x20,
  // "ţ" (U+0163)
  0x18, 0x92, 0x80, 0x5D, 0x34, 0x50, 0x72, 0x09, 0x20, 0x08, 0x28, 0x28, 0x04, 0x51,
  // "Ť" (U+0164)
  0x18, 0x94, 0x33, 0x10, 0x77, 0x03, 0xCD, 0x80, 0x55, 0x20, 0x70, 0x22, 0x0A, 0x30, 0xA3, 0x0A,
  0x20, 0x20, 0x72,
  // "ť" (U+0165)
  0x18, 0x95, 0x19, 0x09, 0x15, 0xD3, 0x45, 0x07, 0x20, 0x92, 0x08, 0x07, 0x10,
  // "Ŧ" (U+0166)
  0x85, 0x3C, 0xD8, 0x04, 0x52, 0x84, 0x72, 0x05, 0xEA, 0x20, 0xA3, 0x09, 0x20, 0x20, 0x72,
  // "ŧ" (U+0167)
  0x18, 0x92, 0x70, 0x5D, 0x33, 0x60, 0xBC, 0x08, 0x20, 0x90, 0x71,
  // "Ũ" (U+0168)
  0x18, 0xB6, 0xA8, 0xF7, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91, 0x45,
  0x04, 0xB9, 0x20,
  // "ũ" (U+0169)
  0x18, 0xA4, 0x8A, 0x22, 0x72, 0x85, 0x44, 0x58, 0x27, 0x2A, 0x0B, 0x08, 0x8A, 0x10,
  // "Ū" (U+016A)
  0x18, 0xB6, 0xA8, 0xD5, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91, 0x45,
  0x04, 0xB9, 0x20,
  // "ū" (U+016B)
  0x18, 0xA4, 0x88, 0x02, 0x72, 0x85, 0x44, 0x58, 0x27, 0x2A, 0x0B, 0x08, 0x8A, 0x10,
  // "Ŭ" (U+016C)
  0x20, 0x30, 0x22, 0x8B, 0x6A, 0x7C, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09,
  0x09, 0x14, 0x50, 0x4B, 0x92,
  // "ŭ" (U+016D)
  0x10, 0x30, 0x22, 0x8A, 0x47, 0x70, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x88, 0xA1,
  // "Ů" (U+016E)
  0x20, 0x50, 0x42, 0x8B, 0x6A, 0x59, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09,
  0x09, 0x14, 0x50, 0x4B, 0x92,
  // "ů" (U+016F)
  0x20, 0x50, 0x42, 0x8A, 0x35, 0x42, 0x72, 0x85, 0x44, 0x58, 0x27, 0x2A, 0x0B, 0x08, 0x8A, 0x10,
  // "Ű" (U+0170)
  0x28, 0xC2, 0x77, 0x40, 0xA0, 0x55, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90,
  0x91, 0x45, 0x04, 0xB9, 0x20,
  // "ű" (U+0171)
  0x28, 0x17, 0x74, 0x38, 0xA2, 0x10, 0x27, 0x28, 0x05, 0x44, 0x50, 0x82, 0x72, 0x0A, 0x0B, 0x28,
  0x18, 0x8A, 0x20,
  // "Ų" (U+0172)
  0x18, 0xB6, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91, 0x45,
  0x04, 0xD9, 0x20, 0x20, 0x53, 0x02, 0x06, 0x30,
  // "ų" (U+0173)
  0x8A, 0x12, 0x72, 0x85, 0x44, 0x58, 0x27, 0x2A, 0x0B, 0x08, 0x8B, 0x20, 0x20, 0x52, 0x02, 0x06,
  0x10,
  // "Ŵ" (U+0174)
  0x30, 0x10, 0x45, 0x07, 0x08, 0x28, 0xB7, 0x35, 0x0B, 0x07, 0x24, 0x54, 0xC0, 0xA0, 0x45, 0x89,
  0x27, 0x04, 0x58, 0x87, 0x20, 0x49, 0x48, 0x92, 0x83, 0x4D, 0x09, 0x72, 0x83, 0x49, 0x0B, 0x22,
  // "ŵ" (U+0175)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x68, 0xA6, 0x81, 0xB2, 0x98, 0x3C, 0x38, 0x88, 0x78, 0x38, 0x96,
  0xA0, 0x86, 0x68, 0x10,
  // "Ŷ" (U+0176)
  0x10, 0x10, 0x42, 0x89, 0x47, 0x80, 0x36, 0x19, 0x18, 0x73, 0x09, 0x92, 0x0D, 0x04, 0x20, 0xA3,
  0x0A, 0x20, 0x20, 0x82,
  // "ŷ" (U+0177)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x78, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C,
  0x30, 0x40, 0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x94, 0x42, 0x43, 0x61, 0x91, 0x87, 0x30, 0x99, 0x20, 0xD0, 0x42, 0x0A, 0x30, 0xA2, 0x02,
  0x08, 0x20,
  // "Ź" (U+0179)
  0x30, 0x20, 0x33, 0x08, 0x38, 0x1B, 0xD7, 0x30, 0x90, 0x12, 0x02, 0x08, 0x30, 0x90, 0x12, 0x03,
  0x08, 0x30, 0x90, 0x12, 0x82, 0x2E, 0xB6, 0x10,
  // "ź" (U+017A)
  0x30, 0x20, 0x33, 0x08, 0x78, 0x13, 0xBA, 0x30, 0x60, 0x22, 0x01, 0x08, 0x30, 0x80, 0x12, 0x81,
  0x1D, 0xB2,
  // "Ż" (U+017B)
  0x30, 0x63, 0x81, 0xBD, 0x73, 0x09, 0x01, 0x20, 0x20, 0x83, 0x09, 0x01, 0x20, 0x30, 0x83, 0x09,
  0x01, 0x28, 0x22, 0xEB, 0x61,
  // "ż" (U+017C)
  0x30, 0x65, 0x81, 0x3B, 0xA2, 0x83, 0x62, 0x01, 0x82, 0x84, 0x81, 0x01, 0xDB, 0x10,
  // "Ž" (U+017D)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x38, 0x1B, 0xD7, 0x30, 0x90, 0x12, 0x02, 0x08, 0x30, 0x90, 0x12,
  0x03, 0x08, 0x30, 0x90, 0x12, 0x82, 0x2E, 0xB6, 0x10,
  // "ž" (U+017E)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x78, 0x13, 0xBA, 0x30, 0x60, 0x22, 0x01, 0x08, 0x30, 0x80, 0x12,
  0x81, 0x1D, 0xB2,
  // "ſ" (U+017F)
  0x20, 0x80, 0x92, 0x0A, 0x20, 0x20, 0x82, 0x00, 0x52, 0x08, 0x02, 0x20, 0xA3, 0x0A, 0x20, 0x10,
  0x82, 0x0C, 0x03, 0x20,
  // "Ω" (U+03A9)
  0x28, 0x14, 0xCB, 0x38, 0xA3, 0xB0, 0x64, 0x05, 0x60, 0x55, 0x07, 0x20, 0x73, 0x08, 0x20, 0xA2,
  0x89, 0x05, 0x43, 0x60, 0x2C, 0x8C, 0xA1,
  // "μ" (U+03BC)
  0x18, 0xA0, 0x28, 0x18, 0x04, 0x54, 0x50, 0x72, 0x72, 0x0A, 0x0B, 0x28, 0x4C, 0x9A, 0x01, 0x93,
  0x03, 0x05, 0x30,
  // "π" (U+03C0)
  0x8A, 0x26, 0xDC, 0xD2, 0x76, 0x35, 0x49, 0x08, 0x19, 0x09, 0x0B, 0x20,
  // "–" (U+2013)
  0x82, 0x8B, 0xB4,
  // "—" (U+2014)
  0x08, 0x80, 0x2B,
  // "€" (U+20AC)
  0x18, 0x41, 0xBA, 0x09, 0x22, 0x09, 0x28, 0x90, 0x8D, 0x90, 0xBC, 0x50, 0x55, 0x28, 0x11, 0xC9,
  0x10,
  // "₿" (U+20BF)
  0x28, 0xB6, 0x82, 0x0B, 0xD3, 0x0A, 0x28, 0x28, 0x55, 0x4D, 0xC0, 0x73, 0xA1, 0x90, 0xA0, 0xCC,
  0x60, 0x55, 0x20,
  // "‘" (U+2018)
  0x18, 0x18, 0x55,
  // "’" (U+2019)
  0x18, 0x1A, 0x53,
  // "‚" (U+201A)
  0x18, 0x1A, 0x26,
  // "‛" (U+201B)
  0x84, 0x37, 0x17, 0x01,
  // "“" (U+201C)
  0x18, 0x90, 0x87, 0x14, 0x69, 0x01, 0x01, 0x10,
  // "”" (U+201D)
  0x18, 0x6A, 0x91, 0x44, 0x80, 0x13,
  // "„" (U+201E)
  0x10, 0x01, 0x28, 0x4A, 0x91, 0x44, 0x81,
  // "‟" (U+201F)
  0x87, 0x27, 0xA1, 0x78, 0x01, 0x10,
  // "†" (U+2020)
  0x20, 0x92, 0x87, 0x27, 0x01, 0x98, 0x20, 0x63, 0x08, 0x30, 0x92, 0x01, 0x08, 0x20,
  // "‡" (U+2021)
  0x20, 0x92, 0x8A, 0x34, 0x91, 0x17, 0x61, 0x07, 0x10, 0x39, 0x30, 0x49, 0x40, 0x18, 0x20,
  // "•" (U+2022)
  0x18, 0x61, 0x04, 0xF6, 0x3E, 0x40,
  // "…" (U+2026)
  0x83, 0x70, 0x70, 0x70,
  // "‰" (U+2030)
  0x18, 0x2A, 0x61, 0x63, 0x82, 0x34, 0x77, 0x48, 0x26, 0x18, 0x74, 0x8B, 0x57, 0x4B, 0x58, 0x19,
  0x14, 0xB7, 0x77, 0x74, 0x40, 0x72, 0x78, 0x77, 0x10, 0x70, 0xC5, 0x98, 0x10,
  // "‹" (U+2039)
  0x18, 0x56, 0x64, 0x72, 0x03,
  // "›" (U+203A)
  0x85, 0x31, 0x18, 0x64, 0x31,
  // "⁄" (U+2044)
  0x40, 0x73, 0x07, 0x01, 0x20, 0x20, 0x53, 0x08, 0x30, 0x50, 0x33, 0x07, 0x30, 0x70, 0x13,
  // "™" (U+2122)
  0x8A, 0x2C, 0xDA, 0x0A, 0x24, 0x95, 0xC2, 0x46, 0xB7, 0x11, 0x23, 0x20,
  // "⅒" (U+2152)
  0x40, 0x73, 0x82, 0x23, 0x71, 0x38, 0x18, 0x75, 0x48, 0xB1, 0x6A, 0x23, 0x65, 0x0D, 0x38, 0x75,
  0x70, 0x70, 0x67, 0x28, 0x71, 0x07, 0x28, 0x10,
  // "ﬁ" (U+FB01)
  0x28, 0x16, 0xA6, 0x20, 0xA3, 0x8A, 0x04, 0xD5, 0x80, 0x36, 0x45, 0x06, 0x37, 0x20, 0x90, 0x92,
  0x81, 0xA0, 0x92, 0x09, 0x30, 0xB0, 0x33,
  // "ﬂ" (U+FB02)
  0x28, 0x16, 0xA9, 0x28, 0xA4, 0xA0, 0x90, 0x4D, 0x58, 0x03, 0x64, 0x50, 0x63, 0x72, 0x09, 0x09,
  0x28, 0x1A, 0x09, 0x20, 0x93, 0x0B, 0x03, 0x30,
};

const Font& font_NotoSans_CondensedItalic_8() {
  static SmoothFont font(font_NotoSans_CondensedItalic_8_data);
  return font;
}

}  // namespace roo_display
