#include "90.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Thu Mar 30 22:28:43 CEST 2023
static const uint8_t font_NotoSans_CondensedBold_90_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x57, 0x11, 0x36,
  0xEF, 0xEB, 0x64, 0x5A, 0x44, 0xEA, 0x16, 0x0A, 0x68, 0x11, 0x18, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x04, 0x00, 0x12, 0x40, 0x18, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x04, 0x2A, 0x23, 0x40, 0x29, 0x00, 0x00, 0xC6, // """ (U+0022)
  0x00, 0x23, 0x01, 0x01, 0x30, 0x40, 0x32, 0x00, 0x01, 0x60, // "#" (U+0023)
  0x00, 0x24, 0x03, 0xFC, 0x29, 0x44, 0x2D, 0x00, 0x03, 0x26, // "$" (U+0024)
  0x00, 0x25, 0x02, 0x00, 0x46, 0x41, 0x49, 0x00, 0x05, 0x14, // "%" (U+0025)
  0x00, 0x26, 0x02, 0x00, 0x38, 0x41, 0x39, 0x00, 0x08, 0x36, // "&" (U+0026)
  0x00, 0x27, 0x04, 0x2A, 0x11, 0x40, 0x16, 0x00, 0x0A, 0x67, // "'" (U+0027)
  0x00, 0x28, 0x04, 0xF3, 0x1A, 0x41, 0x1D, 0x00, 0x0A, 0xB2, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xF3, 0x18, 0x41, 0x1D, 0x00, 0x0B, 0xE9, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x1F, 0x28, 0x44, 0x2B, 0x00, 0x0D, 0x26, // "*" (U+002A)
  0x00, 0x2B, 0x03, 0x0B, 0x29, 0x35, 0x2D, 0x00, 0x0E, 0x34, // "+" (U+002B)
  0x00, 0x2C, 0x03, 0xF5, 0x13, 0x0C, 0x18, 0x00, 0x0F, 0x06, // "," (U+002C)
  0x00, 0x2D, 0x02, 0x14, 0x19, 0x1E, 0x1C, 0x00, 0x0F, 0x57, // "-" (U+002D)
  0x00, 0x2E, 0x04, 0x00, 0x12, 0x0E, 0x18, 0x00, 0x0F, 0x83, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x23, 0x40, 0x25, 0x00, 0x0F, 0xB7, // "/" (U+002F)
  0x00, 0x30, 0x03, 0x00, 0x29, 0x41, 0x2D, 0x00, 0x10, 0xF9, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x21, 0x40, 0x2D, 0x00, 0x12, 0xB3, // "1" (U+0031)
  0x00, 0x32, 0x02, 0x01, 0x28, 0x41, 0x2D, 0x00, 0x13, 0xEB, // "2" (U+0032)
  0x00, 0x33, 0x03, 0x00, 0x29, 0x41, 0x2D, 0x00, 0x15, 0x59, // "3" (U+0033)
  0x00, 0x34, 0x01, 0x01, 0x2B, 0x40, 0x2D, 0x00, 0x16, 0xF5, // "4" (U+0034)
  0x00, 0x35, 0x04, 0x00, 0x28, 0x40, 0x2D, 0x00, 0x18, 0x8A, // "5" (U+0035)
  0x00, 0x36, 0x03, 0x00, 0x29, 0x41, 0x2D, 0x00, 0x1A, 0x00, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x29, 0x40, 0x2D, 0x00, 0x1B, 0xB3, // "7" (U+0037)
  0x00, 0x38, 0x02, 0x00, 0x29, 0x41, 0x2D, 0x00, 0x1C, 0xF0, // "8" (U+0038)
  0x00, 0x39, 0x03, 0x00, 0x29, 0x41, 0x2D, 0x00, 0x1E, 0xC0, // "9" (U+0039)
  0x00, 0x3A, 0x04, 0x00, 0x13, 0x32, 0x18, 0x00, 0x20, 0x79, // ":" (U+003A)
  0x00, 0x3B, 0x03, 0xF5, 0x13, 0x32, 0x18, 0x00, 0x20, 0xE9, // ";" (U+003B)
  0x00, 0x3C, 0x03, 0x0B, 0x29, 0x37, 0x2D, 0x00, 0x21, 0x74, // "<" (U+003C)
  0x00, 0x3D, 0x03, 0x12, 0x29, 0x2E, 0x2D, 0x00, 0x22, 0x89, // "=" (U+003D)
  0x00, 0x3E, 0x03, 0x0B, 0x2A, 0x37, 0x2D, 0x00, 0x22, 0xE6, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x00, 0x22, 0x41, 0x24, 0x00, 0x24, 0x03, // "?" (U+003F)
  0x00, 0x40, 0x03, 0xFA, 0x41, 0x41, 0x46, 0x00, 0x25, 0x47, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x33, 0x40, 0x34, 0x00, 0x28, 0x7D, // "A" (U+0041)
  0x00, 0x42, 0x06, 0x01, 0x2F, 0x40, 0x33, 0x00, 0x2A, 0x4C, // "B" (U+0042)
  0x00, 0x43, 0x04, 0x00, 0x2C, 0x41, 0x30, 0x00, 0x2C, 0x05, // "C" (U+0043)
  0x00, 0x44, 0x06, 0x01, 0x32, 0x40, 0x37, 0x00, 0x2D, 0x8A, // "D" (U+0044)
  0x00, 0x45, 0x06, 0x01, 0x25, 0x40, 0x2A, 0x00, 0x2F, 0x58, // "E" (U+0045)
  0x00, 0x46, 0x06, 0x01, 0x25, 0x40, 0x29, 0x00, 0x30, 0x82, // "F" (U+0046)
  0x00, 0x47, 0x04, 0x00, 0x32, 0x41, 0x38, 0x00, 0x31, 0xAB, // "G" (U+0047)
  0x00, 0x48, 0x06, 0x01, 0x32, 0x40, 0x39, 0x00, 0x33, 0x8C, // "H" (U+0048)
  0x00, 0x49, 0x02, 0x01, 0x1C, 0x40, 0x1F, 0x00, 0x35, 0x16, // "I" (U+0049)
  0x00, 0x4A, 0xFA, 0xEE, 0x13, 0x40, 0x1A, 0x00, 0x36, 0x24, // "J" (U+004A)
  0x00, 0x4B, 0x06, 0x01, 0x32, 0x40, 0x32, 0x00, 0x37, 0x7E, // "K" (U+004B)
  0x00, 0x4C, 0x06, 0x01, 0x26, 0x40, 0x29, 0x00, 0x39, 0x5B, // "L" (U+004C)
  0x00, 0x4D, 0x06, 0x01, 0x43, 0x40, 0x4A, 0x00, 0x3A, 0x70, // "M" (U+004D)
  0x00, 0x4E, 0x06, 0x01, 0x36, 0x40, 0x3D, 0x00, 0x3D, 0x4E, // "N" (U+004E)
  0x00, 0x4F, 0x04, 0x00, 0x36, 0x41, 0x3B, 0x00, 0x3F, 0x83, // "O" (U+004F)
  0x00, 0x50, 0x06, 0x01, 0x2C, 0x40, 0x30, 0x00, 0x41, 0x8B, // "P" (U+0050)
  0x00, 0x51, 0x04, 0xF1, 0x36, 0x41, 0x3B, 0x00, 0x43, 0x0F, // "Q" (U+0051)
  0x00, 0x52, 0x06, 0x01, 0x31, 0x40, 0x32, 0x00, 0x45, 0x62, // "R" (U+0052)
  0x00, 0x53, 0x03, 0x00, 0x27, 0x41, 0x2A, 0x00, 0x47, 0x28, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x29, 0x40, 0x2B, 0x00, 0x48, 0xBB, // "T" (U+0054)
  0x00, 0x55, 0x06, 0x00, 0x31, 0x40, 0x38, 0x00, 0x49, 0xC1, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x31, 0x40, 0x32, 0x00, 0x4B, 0x9F, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x4A, 0x40, 0x4B, 0x00, 0x4D, 0x7A, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x2F, 0x40, 0x30, 0x00, 0x50, 0x9E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x2E, 0x40, 0x2F, 0x00, 0x52, 0x78, // "Y" (U+0059)
  0x00, 0x5A, 0x02, 0x01, 0x28, 0x40, 0x2B, 0x00, 0x54, 0x01, // "Z" (U+005A)
  0x00, 0x5B, 0x05, 0xF2, 0x1A, 0x41, 0x1C, 0x00, 0x55, 0x45, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x23, 0x40, 0x25, 0x00, 0x56, 0x7C, // "\" (U+005C)
  0x00, 0x5D, 0x02, 0xF2, 0x16, 0x41, 0x1C, 0x00, 0x57, 0xBA, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x19, 0x2D, 0x40, 0x2F, 0x00, 0x58, 0xB3, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xF2, 0x29, 0xF9, 0x29, 0x00, 0x59, 0xD4, // "_" (U+005F)
  0x00, 0x60, 0x03, 0x37, 0x19, 0x45, 0x1D, 0x00, 0x59, 0xF8, // "`" (U+0060)
  0x00, 0x61, 0x03, 0x00, 0x27, 0x32, 0x2E, 0x00, 0x5A, 0x36, // "a" (U+0061)
  0x00, 0x62, 0x05, 0x00, 0x2D, 0x44, 0x31, 0x00, 0x5B, 0x67, // "b" (U+0062)
  0x00, 0x63, 0x03, 0x00, 0x24, 0x32, 0x27, 0x00, 0x5D, 0x3C, // "c" (U+0063)
  0x00, 0x64, 0x03, 0x00, 0x2A, 0x44, 0x31, 0x00, 0x5E, 0x52, // "d" (U+0064)
  0x00, 0x65, 0x03, 0x00, 0x29, 0x32, 0x2D, 0x00, 0x60, 0x24, // "e" (U+0065)
  0x00, 0x66, 0x01, 0x01, 0x1F, 0x44, 0x1D, 0x00, 0x61, 0x69, // "f" (U+0066)
  0x00, 0x67, 0x03, 0xEB, 0x2A, 0x32, 0x31, 0x00, 0x62, 0xAC, // "g" (U+0067)
  0x00, 0x68, 0x05, 0x01, 0x2B, 0x44, 0x31, 0x00, 0x64, 0xAF, // "h" (U+0068)
  0x00, 0x69, 0x05, 0x01, 0x12, 0x44, 0x18, 0x00, 0x66, 0x6C, // "i" (U+0069)
  0x00, 0x6A, 0xFC, 0xEB, 0x12, 0x44, 0x18, 0x00, 0x67, 0x4C, // "j" (U+006A)
  0x00, 0x6B, 0x05, 0x01, 0x2E, 0x44, 0x2F, 0x00, 0x68, 0xAE, // "k" (U+006B)
  0x00, 0x6C, 0x05, 0x01, 0x11, 0x44, 0x17, 0x00, 0x6A, 0x85, // "l" (U+006C)
  0x00, 0x6D, 0x05, 0x01, 0x44, 0x32, 0x4A, 0x00, 0x6B, 0x51, // "m" (U+006D)
  0x00, 0x6E, 0x05, 0x01, 0x2B, 0x32, 0x31, 0x00, 0x6D, 0x44, // "n" (U+006E)
  0x00, 0x6F, 0x03, 0x00, 0x2B, 0x32, 0x2F, 0x00, 0x6E, 0xAA, // "o" (U+006F)
  0x00, 0x70, 0x05, 0xEB, 0x2D, 0x32, 0x31, 0x00, 0x70, 0x0D, // "p" (U+0070)
  0x00, 0x71, 0x03, 0xEB, 0x2A, 0x32, 0x31, 0x00, 0x71, 0xF3, // "q" (U+0071)
  0x00, 0x72, 0x05, 0x01, 0x20, 0x32, 0x22, 0x00, 0x73, 0xD2, // "r" (U+0072)
  0x00, 0x73, 0x03, 0x00, 0x22, 0x32, 0x25, 0x00, 0x74, 0xC2, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x00, 0x1D, 0x3C, 0x20, 0x00, 0x75, 0xE6, // "t" (U+0074)
  0x00, 0x75, 0x05, 0x00, 0x2B, 0x31, 0x31, 0x00, 0x77, 0x06, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x2A, 0x31, 0x2B, 0x00, 0x78, 0x6B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x41, 0x31, 0x42, 0x00, 0x79, 0xBC, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x2A, 0x31, 0x2B, 0x00, 0x7C, 0x00, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xEB, 0x2A, 0x31, 0x2B, 0x00, 0x7D, 0x54, // "y" (U+0079)
  0x00, 0x7A, 0x02, 0x01, 0x21, 0x31, 0x24, 0x00, 0x7F, 0x28, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xF1, 0x1E, 0x40, 0x22, 0x00, 0x80, 0x0C, // "{" (U+007B)
  0x00, 0x7C, 0x0F, 0xEC, 0x19, 0x44, 0x29, 0x00, 0x81, 0x8B, // "|" (U+007C)
  0x00, 0x7D, 0x02, 0xF1, 0x1F, 0x40, 0x22, 0x00, 0x82, 0x96, // "}" (U+007D)
  0x00, 0x7E, 0x02, 0x19, 0x2A, 0x27, 0x2D, 0x00, 0x84, 0x20, // "~" (U+007E)
  0x00, 0xA1, 0x04, 0xF0, 0x13, 0x31, 0x18, 0x00, 0x84, 0xA1, // "¡" (U+00A1)
  0x00, 0xA2, 0x05, 0x00, 0x26, 0x41, 0x2D, 0x00, 0x85, 0x6F, // "¢" (U+00A2)
  0x00, 0xA3, 0x03, 0x01, 0x2A, 0x41, 0x2D, 0x00, 0x86, 0xC8, // "£" (U+00A3)
  0x00, 0xA4, 0x04, 0x0C, 0x2D, 0x34, 0x32, 0x00, 0x88, 0x1F, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x2B, 0x40, 0x2D, 0x00, 0x89, 0x6F, // "¥" (U+00A5)
  0x00, 0xA6, 0x0F, 0xEB, 0x19, 0x44, 0x29, 0x00, 0x8B, 0x06, // "¦" (U+00A6)
  0x00, 0xA7, 0x04, 0x01, 0x22, 0x44, 0x27, 0x00, 0x8B, 0xE1, // "§" (U+00A7)
  0x00, 0xA8, 0x09, 0x38, 0x25, 0x43, 0x2F, 0x00, 0x8D, 0x88, // "¨" (U+00A8)
  0x00, 0xA9, 0x04, 0x00, 0x46, 0x41, 0x4B, 0x00, 0x8D, 0xE8, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x22, 0x1B, 0x41, 0x1F, 0x00, 0x90, 0xFE, // "ª" (U+00AA)
  0x00, 0xAB, 0x02, 0x05, 0x2E, 0x2D, 0x31, 0x00, 0x91, 0xC7, // "«" (U+00AB)
  0x00, 0xAC, 0x03, 0x0C, 0x29, 0x25, 0x2D, 0x00, 0x93, 0x24, // "¬" (U+00AC)
  0x00, 0xAE, 0x04, 0x00, 0x46, 0x41, 0x4B, 0x00, 0x93, 0xA1, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x45, 0x2B, 0x4D, 0x2B, 0x00, 0x96, 0xD3, // "¯" (U+00AF)
  0x00, 0xB0, 0x03, 0x27, 0x1F, 0x41, 0x22, 0x00, 0x96, 0xFC, // "°" (U+00B0)
  0x00, 0xB1, 0x03, 0x01, 0x29, 0x39, 0x2D, 0x00, 0x97, 0xA7, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x26, 0x1B, 0x4D, 0x1F, 0x00, 0x98, 0xA8, // "²" (U+00B2)
  0x00, 0xB3, 0x02, 0x26, 0x1B, 0x4D, 0x1F, 0x00, 0x99, 0x6A, // "³" (U+00B3)
  0x00, 0xB4, 0x03, 0x37, 0x19, 0x44, 0x1D, 0x00, 0x9A, 0x43, // "´" (U+00B4)
  0x00, 0xB5, 0x05, 0xEB, 0x2B, 0x31, 0x31, 0x00, 0x9A, 0x81, // "µ" (U+00B5)
  0x00, 0xB6, 0x04, 0xF5, 0x2A, 0x44, 0x31, 0x00, 0x9C, 0x50, // "¶" (U+00B6)
  0x00, 0xB7, 0x04, 0x19, 0x12, 0x27, 0x18, 0x00, 0x9E, 0x89, // "·" (U+00B7)
  0x00, 0xB8, 0xFE, 0xEB, 0x10, 0x00, 0x10, 0x00, 0x9E, 0xBD, // "¸" (U+00B8)
  0x00, 0xB9, 0x03, 0x26, 0x17, 0x4C, 0x1F, 0x00, 0x9F, 0x20, // "¹" (U+00B9)
  0x00, 0xBA, 0x02, 0x22, 0x1C, 0x41, 0x1F, 0x00, 0x9F, 0xCE, // "º" (U+00BA)
  0x00, 0xBB, 0x03, 0x05, 0x2E, 0x2D, 0x31, 0x00, 0xA0, 0x8A, // "»" (U+00BB)
  0x00, 0xBC, 0x02, 0x01, 0x47, 0x40, 0x49, 0x00, 0xA1, 0xE7, // "¼" (U+00BC)
  0x00, 0xBD, 0x02, 0x01, 0x47, 0x40, 0x4B, 0x00, 0xA4, 0xC2, // "½" (U+00BD)
  0x00, 0xBE, 0x03, 0x01, 0x48, 0x41, 0x49, 0x00, 0xA7, 0x8F, // "¾" (U+00BE)
  0x00, 0xBF, 0x01, 0xF1, 0x23, 0x32, 0x24, 0x00, 0xAA, 0x84, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x33, 0x54, 0x34, 0x00, 0xAB, 0xC9, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x33, 0x53, 0x34, 0x00, 0xAD, 0xED, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x33, 0x54, 0x34, 0x00, 0xB0, 0x10, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x33, 0x52, 0x34, 0x00, 0xB2, 0x55, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x33, 0x52, 0x34, 0x00, 0xB4, 0x93, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x33, 0x4F, 0x34, 0x00, 0xB6, 0xD7, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x41, 0x40, 0x45, 0x00, 0xB9, 0x1B, // "Æ" (U+00C6)
  0x00, 0xC7, 0x04, 0xEB, 0x2C, 0x41, 0x30, 0x00, 0xBB, 0x2A, // "Ç" (U+00C7)
  0x00, 0xC8, 0x06, 0x01, 0x25, 0x54, 0x2A, 0x00, 0xBD, 0x2A, // "È" (U+00C8)
  0x00, 0xC9, 0x06, 0x01, 0x25, 0x53, 0x2A, 0x00, 0xBE, 0x9D, // "É" (U+00C9)
  0x00, 0xCA, 0x06, 0x01, 0x25, 0x54, 0x2A, 0x00, 0xC0, 0x0F, // "Ê" (U+00CA)
  0x00, 0xCB, 0x06, 0x01, 0x25, 0x52, 0x2A, 0x00, 0xC1, 0x9D, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x1C, 0x54, 0x1F, 0x00, 0xC3, 0x2C, // "Ì" (U+00CC)
  0x00, 0xCD, 0x02, 0x01, 0x1F, 0x53, 0x1F, 0x00, 0xC4, 0x9F, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x1F, 0x54, 0x1F, 0x00, 0xC6, 0x13, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x1D, 0x52, 0x1F, 0x00, 0xC7, 0xA5, // "Ï" (U+00CF)
  0x00, 0xD0, 0x01, 0x01, 0x32, 0x40, 0x37, 0x00, 0xC9, 0x33, // "Ð" (U+00D0)
  0x00, 0xD1, 0x06, 0x01, 0x36, 0x52, 0x3D, 0x00, 0xCB, 0x1A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x04, 0x00, 0x36, 0x54, 0x3B, 0x00, 0xCD, 0xBA, // "Ò" (U+00D2)
  0x00, 0xD3, 0x04, 0x00, 0x36, 0x53, 0x3B, 0x00, 0xD0, 0x17, // "Ó" (U+00D3)
  0x00, 0xD4, 0x04, 0x00, 0x36, 0x54, 0x3B, 0x00, 0xD2, 0x73, // "Ô" (U+00D4)
  0x00, 0xD5, 0x04, 0x00, 0x36, 0x52, 0x3B, 0x00, 0xD4, 0xF1, // "Õ" (U+00D5)
  0x00, 0xD6, 0x04, 0x00, 0x36, 0x52, 0x3B, 0x00, 0xD7, 0x65, // "Ö" (U+00D6)
  0x00, 0xD7, 0x04, 0x0E, 0x29, 0x33, 0x2D, 0x00, 0xD9, 0xE2, // "×" (U+00D7)
  0x00, 0xD8, 0x04, 0xFC, 0x36, 0x44, 0x3B, 0x00, 0xDA, 0xF6, // "Ø" (U+00D8)
  0x00, 0xD9, 0x06, 0x00, 0x31, 0x54, 0x38, 0x00, 0xDD, 0x68, // "Ù" (U+00D9)
  0x00, 0xDA, 0x06, 0x00, 0x31, 0x53, 0x38, 0x00, 0xDF, 0x9C, // "Ú" (U+00DA)
  0x00, 0xDB, 0x06, 0x00, 0x31, 0x54, 0x38, 0x00, 0xE1, 0xCF, // "Û" (U+00DB)
  0x00, 0xDC, 0x06, 0x00, 0x31, 0x52, 0x38, 0x00, 0xE4, 0x1E, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x2E, 0x53, 0x2F, 0x00, 0xE6, 0x6D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x06, 0x01, 0x2C, 0x40, 0x2F, 0x00, 0xE8, 0x4B, // "Þ" (U+00DE)
  0x00, 0xDF, 0x05, 0x00, 0x32, 0x44, 0x35, 0x00, 0xE9, 0xCF, // "ß" (U+00DF)
  0x00, 0xE0, 0x03, 0x00, 0x27, 0x45, 0x2E, 0x00, 0xEC, 0x01, // "à" (U+00E0)
  0x00, 0xE1, 0x03, 0x00, 0x27, 0x44, 0x2E, 0x00, 0xED, 0x80, // "á" (U+00E1)
  0x00, 0xE2, 0x03, 0x00, 0x27, 0x45, 0x2E, 0x00, 0xEE, 0xFE, // "â" (U+00E2)
  0x00, 0xE3, 0x03, 0x00, 0x27, 0x43, 0x2E, 0x00, 0xF0, 0x98, // "ã" (U+00E3)
  0x00, 0xE4, 0x03, 0x00, 0x27, 0x43, 0x2E, 0x00, 0xF2, 0x29, // "ä" (U+00E4)
  0x00, 0xE5, 0x03, 0x00, 0x27, 0x4B, 0x2E, 0x00, 0xF3, 0xC4, // "å" (U+00E5)
  0x00, 0xE6, 0x03, 0x00, 0x41, 0x32, 0x45, 0x00, 0xF5, 0x84, // "æ" (U+00E6)
  0x00, 0xE7, 0x03, 0xEB, 0x24, 0x32, 0x27, 0x00, 0xF7, 0x73, // "ç" (U+00E7)
  0x00, 0xE8, 0x03, 0x00, 0x29, 0x45, 0x2D, 0x00, 0xF8, 0xFB, // "è" (U+00E8)
  0x00, 0xE9, 0x03, 0x00, 0x29, 0x44, 0x2D, 0x00, 0xFA, 0x8F, // "é" (U+00E9)
  0x00, 0xEA, 0x03, 0x00, 0x29, 0x45, 0x2D, 0x00, 0xFC, 0x22, // "ê" (U+00EA)
  0x00, 0xEB, 0x03, 0x00, 0x29, 0x43, 0x2D, 0x00, 0xFD, 0xD2, // "ë" (U+00EB)
  0x00, 0xEC, 0xFD, 0x01, 0x13, 0x45, 0x18, 0x00, 0xFF, 0x81, // "ì" (U+00EC)
  0x00, 0xED, 0x04, 0x01, 0x1A, 0x44, 0x18, 0x01, 0x00, 0x85, // "í" (U+00ED)
  0x00, 0xEE, 0xFC, 0x01, 0x1B, 0x45, 0x18, 0x01, 0x01, 0x89, // "î" (U+00EE)
  0x00, 0xEF, 0xFD, 0x01, 0x19, 0x43, 0x18, 0x01, 0x02, 0xC9, // "ï" (U+00EF)
  0x00, 0xF0, 0x03, 0x00, 0x2B, 0x45, 0x30, 0x01, 0x04, 0x07, // "ð" (U+00F0)
  0x00, 0xF1, 0x05, 0x01, 0x2B, 0x43, 0x31, 0x01, 0x05, 0xEF, // "ñ" (U+00F1)
  0x00, 0xF2, 0x03, 0x00, 0x2B, 0x45, 0x2F, 0x01, 0x07, 0xB8, // "ò" (U+00F2)
  0x00, 0xF3, 0x03, 0x00, 0x2B, 0x44, 0x2F, 0x01, 0x09, 0x6D, // "ó" (U+00F3)
  0x00, 0xF4, 0x03, 0x00, 0x2B, 0x45, 0x2F, 0x01, 0x0B, 0x1E, // "ô" (U+00F4)
  0x00, 0xF5, 0x03, 0x00, 0x2B, 0x43, 0x2F, 0x01, 0x0C, 0xEE, // "õ" (U+00F5)
  0x00, 0xF6, 0x03, 0x00, 0x2B, 0x43, 0x2F, 0x01, 0x0E, 0xB5, // "ö" (U+00F6)
  0x00, 0xF7, 0x03, 0x09, 0x29, 0x37, 0x2D, 0x01, 0x10, 0x84, // "÷" (U+00F7)
  0x00, 0xF8, 0x03, 0xFC, 0x2B, 0x35, 0x2F, 0x01, 0x11, 0x4B, // "ø" (U+00F8)
  0x00, 0xF9, 0x05, 0x00, 0x2B, 0x45, 0x31, 0x01, 0x12, 0xFE, // "ù" (U+00F9)
  0x00, 0xFA, 0x05, 0x00, 0x2B, 0x44, 0x31, 0x01, 0x14, 0xB3, // "ú" (U+00FA)
  0x00, 0xFB, 0x05, 0x00, 0x2B, 0x45, 0x31, 0x01, 0x16, 0x67, // "û" (U+00FB)
  0x00, 0xFC, 0x05, 0x00, 0x2B, 0x43, 0x31, 0x01, 0x18, 0x38, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xEB, 0x2A, 0x44, 0x2B, 0x01, 0x1A, 0x08, // "ý" (U+00FD)
  0x00, 0xFE, 0x05, 0xEB, 0x2D, 0x44, 0x31, 0x01, 0x1C, 0x2F, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xEB, 0x2A, 0x43, 0x2B, 0x01, 0x1E, 0x70, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x33, 0x4F, 0x34, 0x01, 0x20, 0xB2, // "Ā" (U+0100)
  0x01, 0x01, 0x03, 0x00, 0x27, 0x40, 0x2E, 0x01, 0x22, 0xB8, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x33, 0x55, 0x34, 0x01, 0x24, 0x18, // "Ă" (U+0102)
  0x01, 0x03, 0x03, 0x00, 0x27, 0x46, 0x2E, 0x01, 0x26, 0x5E, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xEC, 0x33, 0x40, 0x34, 0x01, 0x27, 0xF8, // "Ą" (U+0104)
  0x01, 0x05, 0x03, 0xEC, 0x29, 0x32, 0x2E, 0x01, 0x2A, 0x40, // "ą" (U+0105)
  0x01, 0x06, 0x04, 0x00, 0x2C, 0x53, 0x30, 0x01, 0x2B, 0xEE, // "Ć" (U+0106)
  0x01, 0x07, 0x03, 0x00, 0x25, 0x44, 0x27, 0x01, 0x2D, 0xC1, // "ć" (U+0107)
  0x01, 0x08, 0x04, 0x00, 0x2C, 0x54, 0x30, 0x01, 0x2F, 0x27, // "Ĉ" (U+0108)
  0x01, 0x09, 0x03, 0x00, 0x25, 0x45, 0x27, 0x01, 0x31, 0x18, // "ĉ" (U+0109)
  0x01, 0x0A, 0x04, 0x00, 0x2C, 0x53, 0x30, 0x01, 0x32, 0x9C, // "Ċ" (U+010A)
  0x01, 0x0B, 0x03, 0x00, 0x24, 0x44, 0x27, 0x01, 0x34, 0x6B, // "ċ" (U+010B)
  0x01, 0x0C, 0x04, 0x00, 0x2C, 0x54, 0x30, 0x01, 0x35, 0xC6, // "Č" (U+010C)
  0x01, 0x0D, 0x03, 0x00, 0x25, 0x45, 0x27, 0x01, 0x37, 0xB7, // "č" (U+010D)
  0x01, 0x0E, 0x06, 0x01, 0x32, 0x54, 0x37, 0x01, 0x39, 0x3A, // "Ď" (U+010E)
  0x01, 0x0F, 0x03, 0x00, 0x3B, 0x44, 0x31, 0x01, 0x3B, 0x79, // "ď" (U+010F)
  0x01, 0x10, 0x01, 0x01, 0x32, 0x40, 0x37, 0x01, 0x3D, 0xBF, // "Đ" (U+0110)
  0x01, 0x11, 0x03, 0x00, 0x30, 0x44, 0x31, 0x01, 0x3F, 0xA6, // "đ" (U+0111)
  0x01, 0x12, 0x06, 0x01, 0x25, 0x4F, 0x2A, 0x01, 0x41, 0x8C, // "Ē" (U+0112)
  0x01, 0x13, 0x03, 0x00, 0x29, 0x40, 0x2D, 0x01, 0x42, 0xE1, // "ē" (U+0113)
  0x01, 0x14, 0x06, 0x01, 0x25, 0x55, 0x2A, 0x01, 0x44, 0x55, // "Ĕ" (U+0114)
  0x01, 0x15, 0x03, 0x00, 0x29, 0x46, 0x2D, 0x01, 0x45, 0xE4, // "ĕ" (U+0115)
  0x01, 0x16, 0x06, 0x01, 0x25, 0x53, 0x2A, 0x01, 0x47, 0x94, // "Ė" (U+0116)
  0x01, 0x17, 0x03, 0x00, 0x29, 0x44, 0x2D, 0x01, 0x49, 0x02, // "ė" (U+0117)
  0x01, 0x18, 0x06, 0xEC, 0x26, 0x40, 0x2A, 0x01, 0x4A, 0x91, // "Ę" (U+0118)
  0x01, 0x19, 0x03, 0xEB, 0x29, 0x32, 0x2D, 0x01, 0x4C, 0x30, // "ę" (U+0119)
  0x01, 0x1A, 0x06, 0x01, 0x25, 0x54, 0x2A, 0x01, 0x4D, 0xEA, // "Ě" (U+011A)
  0x01, 0x1B, 0x03, 0x00, 0x29, 0x45, 0x2D, 0x01, 0x4F, 0x77, // "ě" (U+011B)
  0x01, 0x1C, 0x04, 0x00, 0x32, 0x54, 0x38, 0x01, 0x51, 0x27, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x03, 0xEB, 0x2A, 0x45, 0x31, 0x01, 0x53, 0x7A, // "ĝ" (U+011D)
  0x01, 0x1E, 0x04, 0x00, 0x32, 0x55, 0x38, 0x01, 0x55, 0xE9, // "Ğ" (U+011E)
  0x01, 0x1F, 0x03, 0xEB, 0x2A, 0x46, 0x31, 0x01, 0x58, 0x3C, // "ğ" (U+011F)
  0x01, 0x20, 0x04, 0x00, 0x32, 0x53, 0x38, 0x01, 0x5A, 0xAA, // "Ġ" (U+0120)
  0x01, 0x21, 0x03, 0xEB, 0x2A, 0x44, 0x31, 0x01, 0x5C, 0xD9, // "ġ" (U+0121)
  0x01, 0x22, 0x04, 0xED, 0x32, 0x41, 0x38, 0x01, 0x5F, 0x26, // "Ģ" (U+0122)
  0x01, 0x23, 0x03, 0xEB, 0x2A, 0x44, 0x31, 0x01, 0x61, 0x53, // "ģ" (U+0123)
  0x01, 0x24, 0x06, 0x01, 0x32, 0x54, 0x39, 0x01, 0x63, 0x9F, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFC, 0x01, 0x2B, 0x58, 0x31, 0x01, 0x65, 0x9B, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x39, 0x40, 0x39, 0x01, 0x68, 0x02, // "Ħ" (U+0126)
  0x01, 0x27, 0xFF, 0x01, 0x2B, 0x44, 0x31, 0x01, 0x69, 0xB1, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x1E, 0x52, 0x1F, 0x01, 0x6B, 0x8B, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFB, 0x01, 0x1A, 0x43, 0x18, 0x01, 0x6D, 0x17, // "ĩ" (U+0129)
  0x01, 0x2A, 0x02, 0x01, 0x1C, 0x4F, 0x1F, 0x01, 0x6E, 0x51, // "Ī" (U+012A)
  0x01, 0x2B, 0xFE, 0x01, 0x18, 0x40, 0x18, 0x01, 0x6F, 0x86, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x1E, 0x55, 0x1F, 0x01, 0x70, 0x71, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFD, 0x01, 0x1A, 0x46, 0x18, 0x01, 0x72, 0x00, // "ĭ" (U+012D)
  0x01, 0x2E, 0x02, 0xEC, 0x1C, 0x40, 0x1F, 0x01, 0x73, 0x3E, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xEC, 0x12, 0x44, 0x18, 0x01, 0x74, 0xAD, // "į" (U+012F)
  0x01, 0x30, 0x02, 0x01, 0x1C, 0x53, 0x1F, 0x01, 0x75, 0xE4, // "İ" (U+0130)
  0x01, 0x31, 0x05, 0x01, 0x11, 0x31, 0x18, 0x01, 0x77, 0x32, // "ı" (U+0131)
  0x01, 0x32, 0x02, 0xEE, 0x32, 0x40, 0x38, 0x01, 0x77, 0xC5, // "Ĳ" (U+0132)
  0x01, 0x33, 0x05, 0xEB, 0x2A, 0x44, 0x2F, 0x01, 0x7A, 0x48, // "ĳ" (U+0133)
  0x01, 0x34, 0xFA, 0xEE, 0x1C, 0x54, 0x1A, 0x01, 0x7C, 0x9F, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFC, 0xEB, 0x1B, 0x45, 0x18, 0x01, 0x7E, 0x8B, // "ĵ" (U+0135)
  0x01, 0x36, 0x06, 0xED, 0x32, 0x40, 0x32, 0x01, 0x80, 0x3A, // "Ķ" (U+0136)
  0x01, 0x37, 0x05, 0xED, 0x2E, 0x44, 0x2F, 0x01, 0x82, 0x65, // "ķ" (U+0137)
  0x01, 0x38, 0x05, 0x01, 0x2E, 0x31, 0x2F, 0x01, 0x84, 0x89, // "ĸ" (U+0138)
  0x01, 0x39, 0x05, 0x01, 0x26, 0x53, 0x29, 0x01, 0x85, 0xF4, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x04, 0x01, 0x1A, 0x57, 0x17, 0x01, 0x87, 0x56, // "ĺ" (U+013A)
  0x01, 0x3B, 0x06, 0xED, 0x26, 0x40, 0x29, 0x01, 0x88, 0xA6, // "Ļ" (U+013B)
  0x01, 0x3C, 0x04, 0xED, 0x12, 0x44, 0x17, 0x01, 0x89, 0xFF, // "ļ" (U+013C)
  0x01, 0x3D, 0x06, 0x01, 0x2A, 0x40, 0x29, 0x01, 0x8B, 0x1F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x05, 0x01, 0x22, 0x44, 0x17, 0x01, 0x8C, 0x75, // "ľ" (U+013E)
  0x01, 0x3F, 0x06, 0x01, 0x27, 0x40, 0x29, 0x01, 0x8D, 0xC8, // "Ŀ" (U+013F)
  0x01, 0x40, 0x05, 0x01, 0x21, 0x44, 0x1F, 0x01, 0x8F, 0x07, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x27, 0x40, 0x2A, 0x01, 0x90, 0x5B, // "Ł" (U+0141)
  0x01, 0x42, 0xFE, 0x01, 0x1B, 0x44, 0x1A, 0x01, 0x91, 0xB8, // "ł" (U+0142)
  0x01, 0x43, 0x06, 0x01, 0x36, 0x53, 0x3D, 0x01, 0x92, 0xC8, // "Ń" (U+0143)
  0x01, 0x44, 0x05, 0x01, 0x2B, 0x44, 0x31, 0x01, 0x95, 0x53, // "ń" (U+0144)
  0x01, 0x45, 0x06, 0xED, 0x36, 0x40, 0x3D, 0x01, 0x97, 0x06, // "Ņ" (U+0145)
  0x01, 0x46, 0x05, 0xED, 0x2B, 0x32, 0x31, 0x01, 0x99, 0x89, // "ņ" (U+0146)
  0x01, 0x47, 0x06, 0x01, 0x36, 0x54, 0x3D, 0x01, 0x9B, 0x37, // "Ň" (U+0147)
  0x01, 0x48, 0x05, 0x01, 0x2B, 0x45, 0x31, 0x01, 0x9D, 0xE2, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x35, 0x40, 0x3C, 0x01, 0x9F, 0xB2, // "ŉ" (U+0149)
  0x01, 0x4A, 0x06, 0xEE, 0x36, 0x40, 0x3D, 0x01, 0xA1, 0xBF, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x05, 0xEB, 0x2B, 0x32, 0x31, 0x01, 0xA4, 0x64, // "ŋ" (U+014B)
  0x01, 0x4C, 0x04, 0x00, 0x36, 0x4F, 0x3B, 0x01, 0xA6, 0x44, // "Ō" (U+014C)
  0x01, 0x4D, 0x03, 0x00, 0x2B, 0x40, 0x2F, 0x01, 0xA8, 0x83, // "ō" (U+014D)
  0x01, 0x4E, 0x04, 0x00, 0x36, 0x55, 0x3B, 0x01, 0xAA, 0x15, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x03, 0x00, 0x2B, 0x46, 0x2F, 0x01, 0xAC, 0x93, // "ŏ" (U+014F)
  0x01, 0x50, 0x04, 0x00, 0x36, 0x53, 0x3B, 0x01, 0xAE, 0x62, // "Ő" (U+0150)
  0x01, 0x51, 0x03, 0x00, 0x2D, 0x44, 0x2F, 0x01, 0xB0, 0xEB, // "ő" (U+0151)
  0x01, 0x52, 0x04, 0x00, 0x42, 0x41, 0x47, 0x01, 0xB2, 0xD2, // "Œ" (U+0152)
  0x01, 0x53, 0x03, 0x00, 0x45, 0x32, 0x49, 0x01, 0xB4, 0xF9, // "œ" (U+0153)
  0x01, 0x54, 0x06, 0x01, 0x31, 0x53, 0x32, 0x01, 0xB7, 0x0F, // "Ŕ" (U+0154)
  0x01, 0x55, 0x05, 0x01, 0x22, 0x44, 0x22, 0x01, 0xB9, 0x29, // "ŕ" (U+0155)
  0x01, 0x56, 0x06, 0xED, 0x31, 0x40, 0x32, 0x01, 0xBA, 0x6A, // "Ŗ" (U+0156)
  0x01, 0x57, 0x04, 0xED, 0x20, 0x32, 0x22, 0x01, 0xBC, 0x7D, // "ŗ" (U+0157)
  0x01, 0x58, 0x06, 0x01, 0x31, 0x54, 0x32, 0x01, 0xBD, 0xB5, // "Ř" (U+0158)
  0x01, 0x59, 0x03, 0x01, 0x22, 0x45, 0x22, 0x01, 0xBF, 0xEB, // "ř" (U+0159)
  0x01, 0x5A, 0x03, 0x00, 0x27, 0x53, 0x2A, 0x01, 0xC1, 0x49, // "Ś" (U+015A)
  0x01, 0x5B, 0x03, 0x00, 0x22, 0x44, 0x25, 0x01, 0xC3, 0x28, // "ś" (U+015B)
  0x01, 0x5C, 0x03, 0x00, 0x27, 0x54, 0x2A, 0x01, 0xC4, 0x93, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x03, 0x00, 0x22, 0x45, 0x25, 0x01, 0xC6, 0x8E, // "ŝ" (U+015D)
  0x01, 0x5E, 0x03, 0xEB, 0x27, 0x41, 0x2A, 0x01, 0xC8, 0x15, // "Ş" (U+015E)
  0x01, 0x5F, 0x03, 0xEB, 0x22, 0x32, 0x25, 0x01, 0xCA, 0x1D, // "ş" (U+015F)
  0x01, 0x60, 0x03, 0x00, 0x27, 0x54, 0x2A, 0x01, 0xCB, 0xAE, // "Š" (U+0160)
  0x01, 0x61, 0x03, 0x00, 0x22, 0x45, 0x25, 0x01, 0xCD, 0xA9, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xEB, 0x29, 0x40, 0x2B, 0x01, 0xCF, 0x2F, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xEB, 0x1D, 0x3C, 0x20, 0x01, 0xD0, 0xBA, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x29, 0x54, 0x2B, 0x01, 0xD2, 0x42, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x00, 0x2B, 0x44, 0x20, 0x01, 0xD3, 0xB5, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x29, 0x40, 0x2B, 0x01, 0xD5, 0x4D, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x00, 0x1D, 0x3C, 0x20, 0x01, 0xD6, 0x66, // "ŧ" (U+0167)
  0x01, 0x68, 0x06, 0x00, 0x31, 0x52, 0x38, 0x01, 0xD7, 0x85, // "Ũ" (U+0168)
  0x01, 0x69, 0x05, 0x00, 0x2B, 0x43, 0x31, 0x01, 0xD9, 0xCA, // "ũ" (U+0169)
  0x01, 0x6A, 0x06, 0x00, 0x31, 0x4F, 0x38, 0x01, 0xDB, 0x94, // "Ū" (U+016A)
  0x01, 0x6B, 0x05, 0x00, 0x2B, 0x40, 0x31, 0x01, 0xDD, 0xA6, // "ū" (U+016B)
  0x01, 0x6C, 0x06, 0x00, 0x31, 0x55, 0x38, 0x01, 0xDF, 0x3B, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x05, 0x00, 0x2B, 0x46, 0x31, 0x01, 0xE1, 0x8A, // "ŭ" (U+016D)
  0x01, 0x6E, 0x06, 0x00, 0x31, 0x5A, 0x38, 0x01, 0xE3, 0x5B, // "Ů" (U+016E)
  0x01, 0x6F, 0x05, 0x00, 0x2B, 0x4B, 0x31, 0x01, 0xE5, 0xD3, // "ů" (U+016F)
  0x01, 0x70, 0x06, 0x00, 0x31, 0x53, 0x38, 0x01, 0xE7, 0xC9, // "Ű" (U+0170)
  0x01, 0x71, 0x05, 0x00, 0x2E, 0x44, 0x31, 0x01, 0xEA, 0x23, // "ű" (U+0171)
  0x01, 0x72, 0x06, 0xEB, 0x31, 0x40, 0x38, 0x01, 0xEC, 0x15, // "Ų" (U+0172)
  0x01, 0x73, 0x05, 0xEC, 0x2B, 0x31, 0x31, 0x01, 0xEE, 0x69, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x4A, 0x54, 0x4B, 0x01, 0xF0, 0x3F, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x41, 0x45, 0x42, 0x01, 0xF3, 0xDF, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x2E, 0x54, 0x2F, 0x01, 0xF6, 0x9F, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xEB, 0x2A, 0x45, 0x2B, 0x01, 0xF8, 0x9C, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x2E, 0x52, 0x2F, 0x01, 0xFA, 0xE0, // "Ÿ" (U+0178)
  0x01, 0x79, 0x02, 0x01, 0x28, 0x53, 0x2B, 0x01, 0xFC, 0xDA, // "Ź" (U+0179)
  0x01, 0x7A, 0x02, 0x01, 0x21, 0x44, 0x24, 0x01, 0xFE, 0x6D, // "ź" (U+017A)
  0x01, 0x7B, 0x02, 0x01, 0x28, 0x53, 0x2B, 0x01, 0xFF, 0x98, // "Ż" (U+017B)
  0x01, 0x7C, 0x02, 0x01, 0x21, 0x44, 0x24, 0x02, 0x01, 0x27, // "ż" (U+017C)
  0x01, 0x7D, 0x02, 0x01, 0x28, 0x54, 0x2B, 0x02, 0x02, 0x4E, // "Ž" (U+017D)
  0x01, 0x7E, 0x02, 0x01, 0x21, 0x45, 0x24, 0x02, 0x03, 0xFE, // "ž" (U+017E)
  0x01, 0x7F, 0x06, 0x01, 0x1E, 0x44, 0x1C, 0x02, 0x05, 0x44, // "ſ" (U+017F)
  0x03, 0xA9, 0x02, 0x01, 0x38, 0x41, 0x3B, 0x02, 0x06, 0x63, // "Ω" (U+03A9)
  0x03, 0xBC, 0x05, 0xEB, 0x2B, 0x31, 0x31, 0x02, 0x08, 0x8C, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x00, 0x35, 0x31, 0x37, 0x02, 0x0A, 0x5B, // "π" (U+03C0)
  0x20, 0x13, 0x03, 0x14, 0x29, 0x1E, 0x2D, 0x02, 0x0B, 0xEF, // "–" (U+2013)
  0x20, 0x14, 0x03, 0x14, 0x56, 0x1E, 0x5A, 0x02, 0x0C, 0x1F, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x00, 0x2B, 0x41, 0x2D, 0x02, 0x0C, 0x50, // "€" (U+20AC)
  0x20, 0xBF, 0x06, 0xF8, 0x2A, 0x49, 0x2D, 0x02, 0x0D, 0xE5, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x29, 0x12, 0x40, 0x15, 0x02, 0x0F, 0xF2, // "‘" (U+2018)
  0x20, 0x19, 0x02, 0x29, 0x12, 0x40, 0x15, 0x02, 0x10, 0x44, // "’" (U+2019)
  0x20, 0x1A, 0x03, 0xF3, 0x13, 0x0A, 0x18, 0x02, 0x10, 0x95, // "‚" (U+201A)
  0x20, 0x1B, 0x02, 0x29, 0x12, 0x40, 0x15, 0x02, 0x10, 0xE6, // "‛" (U+201B)
  0x20, 0x1C, 0x02, 0x29, 0x25, 0x40, 0x28, 0x02, 0x11, 0x36, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x29, 0x25, 0x40, 0x28, 0x02, 0x11, 0xDC, // "”" (U+201D)
  0x20, 0x1E, 0x02, 0xF4, 0x25, 0x0B, 0x2A, 0x02, 0x12, 0x83, // "„" (U+201E)
  0x20, 0x1F, 0x02, 0x29, 0x25, 0x40, 0x28, 0x02, 0x13, 0x2A, // "‟" (U+201F)
  0x20, 0x20, 0x04, 0x01, 0x27, 0x44, 0x2C, 0x02, 0x13, 0xCF, // "†" (U+2020)
  0x20, 0x21, 0x04, 0x01, 0x27, 0x44, 0x2C, 0x02, 0x15, 0x32, // "‡" (U+2021)
  0x20, 0x22, 0x04, 0x14, 0x1E, 0x30, 0x23, 0x02, 0x16, 0xB1, // "•" (U+2022)
  0x20, 0x26, 0x04, 0x00, 0x42, 0x0E, 0x47, 0x02, 0x17, 0x3A, // "…" (U+2026)
  0x20, 0x30, 0x02, 0x00, 0x64, 0x41, 0x68, 0x02, 0x17, 0xEA, // "‰" (U+2030)
  0x20, 0x39, 0x02, 0x05, 0x19, 0x2D, 0x1D, 0x02, 0x1C, 0x16, // "‹" (U+2039)
  0x20, 0x3A, 0x03, 0x05, 0x1A, 0x2D, 0x1D, 0x02, 0x1C, 0xCD, // "›" (U+203A)
  0x20, 0x44, 0xEF, 0x01, 0x19, 0x40, 0x0A, 0x02, 0x1D, 0x84, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x21, 0x3A, 0x41, 0x40, 0x02, 0x1E, 0xF0, // "™" (U+2122)
  0x21, 0x52, 0x03, 0x00, 0x61, 0x40, 0x63, 0x02, 0x20, 0xA2, // "⅒" (U+2152)
  0xFB, 0x01, 0x01, 0x01, 0x2F, 0x44, 0x35, 0x02, 0x24, 0x61, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x01, 0x01, 0x2E, 0x44, 0x35, 0x02, 0x26, 0x75, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x05, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x03, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x04, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x04, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x04, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x02, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x02, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x02, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x04, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x02, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x04, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x02, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x02, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x02, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x05, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x05, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x05, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x05, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x05, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x05, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x06, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x04, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x03, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x03, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x03, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x03, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x03, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x03, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x04, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x04, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x04, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x04, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x04, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x04, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x04, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x04, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x04, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x04, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x04, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x02, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x02, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x02, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x02, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x05, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x03, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x05, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x03, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x05, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x03, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x04, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x04, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x04, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x04, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x04, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x04, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x04, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x04, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x04, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x04, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x04, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x02, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x02, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x02, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x02, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x02, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x02, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x02, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x02, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x04, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x04, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x04, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x04, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x02, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x02, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x02, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x02, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x02, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x02, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x02, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x02, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x02, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x02, // "ų (U+0022 U+0173)
  0x00, 0x22, 0x03, 0xBC, 0x01, // "μ (U+0022 U+03BC)
  0x00, 0x26, 0x00, 0x54, 0x03, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x02, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x02, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x03, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x03, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x03, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x02, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x02, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x05, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x03, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x04, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x04, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x04, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x02, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x02, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x02, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x04, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x02, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x04, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x02, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x02, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x02, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x05, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x05, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x05, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x05, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x05, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x05, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x06, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x04, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x03, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x03, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x03, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x03, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x03, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x03, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x04, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x04, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x04, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x04, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x04, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x04, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x04, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x04, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x04, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x04, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x04, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x02, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x02, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x02, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x02, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x05, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x03, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x05, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x03, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x05, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x03, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x04, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x04, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x04, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x04, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x04, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x04, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x04, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x04, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x04, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x04, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x04, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x02, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x02, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x02, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x02, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x02, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x02, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x02, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x02, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x04, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x04, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x04, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x04, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x02, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x02, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x02, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x02, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x02, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x02, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x02, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x02, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x02, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x02, // 'ų (U+0027 U+0173)
  0x00, 0x27, 0x03, 0xBC, 0x01, // 'μ (U+0027 U+03BC)
  0x00, 0x2C, 0x00, 0x43, 0x03, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x03, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x03, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x03, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x05, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x01, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x04, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x04, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x04, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x03, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x03, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x03, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x03, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x03, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x03, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x03, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x01, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x01, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x01, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x01, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x04, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x03, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x03, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x03, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x03, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x03, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x03, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x03, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x03, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x03, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x03, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x03, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x03, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x05, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x05, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x05, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x01, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x01, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x01, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x01, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x01, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x01, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x04, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x04, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x04, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x03, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x03, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x03, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x03, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x03, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x03, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x03, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x03, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x05, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x01, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x04, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x04, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x04, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x03, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x03, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x03, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x03, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x03, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x03, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x03, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x01, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x01, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x01, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x01, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x04, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x03, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x03, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x03, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x03, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x03, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x03, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x03, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x03, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x03, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x03, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x03, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x03, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x05, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x05, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x05, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x01, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x01, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x01, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x01, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x01, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x01, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x04, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x04, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x04, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x0E, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x0E, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x0E, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x0E, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x0E, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x0E, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x0E, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x0E, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x0E, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x0E, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x05, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x05, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x43, 0x01, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x01, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x01, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x01, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x03, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x03, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xC7, 0x01, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x01, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x01, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x01, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x01, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x01, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x01, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xDD, 0x03, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x06, 0x01, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x08, 0x01, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x0A, 0x01, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0C, 0x01, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x1C, 0x01, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1E, 0x01, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x20, 0x01, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x22, 0x01, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x4C, 0x01, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4E, 0x01, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x50, 0x01, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x52, 0x01, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x62, 0x03, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x03, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x03, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x03, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x03, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x05, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x05, // A” (U+0041 U+201D)
  0x00, 0x42, 0x00, 0x2C, 0x01, // B, (U+0042 U+002C)
  0x00, 0x42, 0x00, 0x2E, 0x01, // B. (U+0042 U+002E)
  0x00, 0x42, 0x20, 0x1A, 0x01, // B‚ (U+0042 U+201A)
  0x00, 0x42, 0x20, 0x1E, 0x01, // B„ (U+0042 U+201E)
  0x00, 0x42, 0x20, 0x26, 0x01, // B… (U+0042 U+2026)
  0x00, 0x43, 0x00, 0x43, 0x02, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x02, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x02, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x02, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xAB, 0x01, // C« (U+0043 U+00AB)
  0x00, 0x43, 0x00, 0xC7, 0x02, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x02, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x02, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x02, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x02, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x02, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x02, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x02, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x02, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x02, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x02, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x02, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x02, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x02, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x02, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x02, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x02, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x02, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x02, // CŒ (U+0043 U+0152)
  0x00, 0x43, 0x20, 0x39, 0x01, // C‹ (U+0043 U+2039)
  0x00, 0x44, 0x00, 0x2C, 0x03, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x03, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x41, 0x01, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x58, 0x01, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC0, 0x01, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x01, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x01, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x01, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x01, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x01, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x01, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x01, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x01, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x20, 0x1A, 0x03, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x03, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x03, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x05, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x05, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x05, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x05, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x05, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x43, 0x01, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x01, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x01, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x01, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0xAB, 0x01, // K« (U+004B U+00AB)
  0x00, 0x4B, 0x00, 0xC7, 0x01, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x01, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x01, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x01, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x01, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x01, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x01, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x01, 0x06, 0x01, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x08, 0x01, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x0A, 0x01, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0C, 0x01, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x1C, 0x01, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1E, 0x01, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x20, 0x01, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x22, 0x01, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x4C, 0x01, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4E, 0x01, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x50, 0x01, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x52, 0x01, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x20, 0x39, 0x01, // K‹ (U+004B U+2039)
  0x00, 0x4C, 0x00, 0x22, 0x05, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x05, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x43, 0x01, // LC (U+004C U+0043)
  0x00, 0x4C, 0x00, 0x47, 0x01, // LG (U+004C U+0047)
  0x00, 0x4C, 0x00, 0x4F, 0x01, // LO (U+004C U+004F)
  0x00, 0x4C, 0x00, 0x51, 0x01, // LQ (U+004C U+0051)
  0x00, 0x4C, 0x00, 0x54, 0x03, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x55, 0x01, // LU (U+004C U+0055)
  0x00, 0x4C, 0x00, 0x56, 0x03, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x03, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x03, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xC7, 0x01, // LÇ (U+004C U+00C7)
  0x00, 0x4C, 0x00, 0xD2, 0x01, // LÒ (U+004C U+00D2)
  0x00, 0x4C, 0x00, 0xD3, 0x01, // LÓ (U+004C U+00D3)
  0x00, 0x4C, 0x00, 0xD4, 0x01, // LÔ (U+004C U+00D4)
  0x00, 0x4C, 0x00, 0xD5, 0x01, // LÕ (U+004C U+00D5)
  0x00, 0x4C, 0x00, 0xD6, 0x01, // LÖ (U+004C U+00D6)
  0x00, 0x4C, 0x00, 0xD8, 0x01, // LØ (U+004C U+00D8)
  0x00, 0x4C, 0x00, 0xD9, 0x01, // LÙ (U+004C U+00D9)
  0x00, 0x4C, 0x00, 0xDA, 0x01, // LÚ (U+004C U+00DA)
  0x00, 0x4C, 0x00, 0xDB, 0x01, // LÛ (U+004C U+00DB)
  0x00, 0x4C, 0x00, 0xDC, 0x01, // LÜ (U+004C U+00DC)
  0x00, 0x4C, 0x00, 0xDD, 0x03, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x06, 0x01, // LĆ (U+004C U+0106)
  0x00, 0x4C, 0x01, 0x08, 0x01, // LĈ (U+004C U+0108)
  0x00, 0x4C, 0x01, 0x0A, 0x01, // LĊ (U+004C U+010A)
  0x00, 0x4C, 0x01, 0x0C, 0x01, // LČ (U+004C U+010C)
  0x00, 0x4C, 0x01, 0x1C, 0x01, // LĜ (U+004C U+011C)
  0x00, 0x4C, 0x01, 0x1E, 0x01, // LĞ (U+004C U+011E)
  0x00, 0x4C, 0x01, 0x20, 0x01, // LĠ (U+004C U+0120)
  0x00, 0x4C, 0x01, 0x22, 0x01, // LĢ (U+004C U+0122)
  0x00, 0x4C, 0x01, 0x4C, 0x01, // LŌ (U+004C U+014C)
  0x00, 0x4C, 0x01, 0x4E, 0x01, // LŎ (U+004C U+014E)
  0x00, 0x4C, 0x01, 0x50, 0x01, // LŐ (U+004C U+0150)
  0x00, 0x4C, 0x01, 0x52, 0x01, // LŒ (U+004C U+0152)
  0x00, 0x4C, 0x01, 0x62, 0x03, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x03, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x03, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x68, 0x01, // LŨ (U+004C U+0168)
  0x00, 0x4C, 0x01, 0x6A, 0x01, // LŪ (U+004C U+016A)
  0x00, 0x4C, 0x01, 0x6C, 0x01, // LŬ (U+004C U+016C)
  0x00, 0x4C, 0x01, 0x6E, 0x01, // LŮ (U+004C U+016E)
  0x00, 0x4C, 0x01, 0x70, 0x01, // LŰ (U+004C U+0170)
  0x00, 0x4C, 0x01, 0x72, 0x01, // LŲ (U+004C U+0172)
  0x00, 0x4C, 0x01, 0x74, 0x03, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x03, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x03, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x05, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x05, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x03, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x03, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x41, 0x01, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x58, 0x01, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC0, 0x01, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x01, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x01, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x01, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x01, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x01, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x01, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x01, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x01, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x20, 0x1A, 0x03, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x03, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x03, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x01, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x08, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x08, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x03, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0x58, 0x01, // PX (U+0050 U+0058)
  0x00, 0x50, 0x00, 0x5A, 0x01, // PZ (U+0050 U+005A)
  0x00, 0x50, 0x00, 0xAB, 0x01, // P« (U+0050 U+00AB)
  0x00, 0x50, 0x00, 0xC0, 0x03, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x03, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x03, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x03, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x03, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x03, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x03, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x03, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x03, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x03, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x01, 0x79, 0x01, // PŹ (U+0050 U+0179)
  0x00, 0x50, 0x01, 0x7B, 0x01, // PŻ (U+0050 U+017B)
  0x00, 0x50, 0x01, 0x7D, 0x01, // PŽ (U+0050 U+017D)
  0x00, 0x50, 0x20, 0x1A, 0x08, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x08, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x08, // P… (U+0050 U+2026)
  0x00, 0x50, 0x20, 0x39, 0x01, // P‹ (U+0050 U+2039)
  0x00, 0x51, 0x00, 0x2C, 0x03, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x03, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x41, 0x01, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x58, 0x01, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC0, 0x01, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x01, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x01, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x01, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x01, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x01, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x01, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x01, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x01, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x20, 0x1A, 0x03, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x03, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x03, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0xAB, 0x01, // R« (U+0052 U+00AB)
  0x00, 0x52, 0x20, 0x39, 0x01, // R‹ (U+0052 U+2039)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x04, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x03, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x04, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x03, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x01, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x01, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x01, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x01, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x05, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x05, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x05, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x05, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x05, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x03, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x03, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x05, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x03, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x05, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x03, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x04, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x03, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x76, 0x01, // Tv (U+0054 U+0076)
  0x00, 0x54, 0x00, 0x77, 0x01, // Tw (U+0054 U+0077)
  0x00, 0x54, 0x00, 0x78, 0x01, // Tx (U+0054 U+0078)
  0x00, 0x54, 0x00, 0x79, 0x01, // Ty (U+0054 U+0079)
  0x00, 0x54, 0x00, 0x7A, 0x03, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x04, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x02, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x03, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x03, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x03, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x03, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x03, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x03, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC7, 0x01, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x01, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x01, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x01, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x01, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x01, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x01, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x05, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x05, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x05, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x05, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x05, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x05, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x05, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x05, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x05, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x05, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x05, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x05, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x05, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x05, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x05, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x05, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x05, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x05, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x03, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x03, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x03, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x03, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x00, 0xFD, 0x01, // Tý (U+0054 U+00FD)
  0x00, 0x54, 0x00, 0xFF, 0x01, // Tÿ (U+0054 U+00FF)
  0x00, 0x54, 0x01, 0x00, 0x03, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x05, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x03, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x05, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x03, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x05, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x01, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x05, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x01, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x05, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x01, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x05, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x01, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x05, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x05, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x05, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x05, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x05, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x05, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x05, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x05, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x01, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x05, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x01, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x05, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x01, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x05, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x01, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x05, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x03, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x03, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x03, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x03, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4C, 0x01, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x05, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x01, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x05, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x01, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x05, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x01, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x05, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x03, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x03, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x04, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x04, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x03, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x03, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x03, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x03, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x03, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x03, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x75, 0x01, // Tŵ (U+0054 U+0175)
  0x00, 0x54, 0x01, 0x77, 0x01, // Tŷ (U+0054 U+0177)
  0x00, 0x54, 0x01, 0x7A, 0x03, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x03, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x03, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x03, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x03, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x04, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x04, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x04, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x04, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x02, // T› (U+0054 U+203A)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x41, 0x01, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x01, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x01, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x01, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x01, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x01, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x01, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x01, 0x00, 0x01, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x01, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x01, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x03, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x03, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x01, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x01, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x01, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x01, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6D, 0x01, // Vm (U+0056 U+006D)
  0x00, 0x56, 0x00, 0x6E, 0x01, // Vn (U+0056 U+006E)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x70, 0x01, // Vp (U+0056 U+0070)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x72, 0x01, // Vr (U+0056 U+0072)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0x75, 0x01, // Vu (U+0056 U+0075)
  0x00, 0x56, 0x00, 0xAB, 0x02, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xBB, 0x01, // V» (U+0056 U+00BB)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC7, 0x01, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x01, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x01, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x01, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x01, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x01, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x01, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x00, 0xF9, 0x01, // Vù (U+0056 U+00F9)
  0x00, 0x56, 0x00, 0xFA, 0x01, // Vú (U+0056 U+00FA)
  0x00, 0x56, 0x00, 0xFB, 0x01, // Vû (U+0056 U+00FB)
  0x00, 0x56, 0x00, 0xFC, 0x01, // Vü (U+0056 U+00FC)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x01, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x01, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x01, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x01, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x01, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x01, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x01, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x01, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x38, 0x01, // Vĸ (U+0056 U+0138)
  0x00, 0x56, 0x01, 0x44, 0x01, // Vń (U+0056 U+0144)
  0x00, 0x56, 0x01, 0x46, 0x01, // Vņ (U+0056 U+0146)
  0x00, 0x56, 0x01, 0x4B, 0x01, // Vŋ (U+0056 U+014B)
  0x00, 0x56, 0x01, 0x4C, 0x01, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x01, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x01, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x01, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x55, 0x01, // Vŕ (U+0056 U+0155)
  0x00, 0x56, 0x01, 0x57, 0x01, // Vŗ (U+0056 U+0157)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x69, 0x01, // Vũ (U+0056 U+0169)
  0x00, 0x56, 0x01, 0x6B, 0x01, // Vū (U+0056 U+016B)
  0x00, 0x56, 0x01, 0x6D, 0x01, // Vŭ (U+0056 U+016D)
  0x00, 0x56, 0x01, 0x6F, 0x01, // Vů (U+0056 U+016F)
  0x00, 0x56, 0x01, 0x71, 0x01, // Vű (U+0056 U+0171)
  0x00, 0x56, 0x01, 0x73, 0x01, // Vų (U+0056 U+0173)
  0x00, 0x56, 0x20, 0x1A, 0x03, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x03, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x03, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x02, // V‹ (U+0056 U+2039)
  0x00, 0x56, 0x20, 0x3A, 0x01, // V› (U+0056 U+203A)
  0x00, 0x57, 0x00, 0x2C, 0x03, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x03, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x01, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x01, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x01, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x01, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6D, 0x01, // Wm (U+0057 U+006D)
  0x00, 0x57, 0x00, 0x6E, 0x01, // Wn (U+0057 U+006E)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x70, 0x01, // Wp (U+0057 U+0070)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x72, 0x01, // Wr (U+0057 U+0072)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x75, 0x01, // Wu (U+0057 U+0075)
  0x00, 0x57, 0x00, 0xAB, 0x02, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xBB, 0x01, // W» (U+0057 U+00BB)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC7, 0x01, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x01, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x01, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x01, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x01, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x01, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x01, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x00, 0xF9, 0x01, // Wù (U+0057 U+00F9)
  0x00, 0x57, 0x00, 0xFA, 0x01, // Wú (U+0057 U+00FA)
  0x00, 0x57, 0x00, 0xFB, 0x01, // Wû (U+0057 U+00FB)
  0x00, 0x57, 0x00, 0xFC, 0x01, // Wü (U+0057 U+00FC)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x01, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x01, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x01, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x01, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x01, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x01, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x01, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x01, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x38, 0x01, // Wĸ (U+0057 U+0138)
  0x00, 0x57, 0x01, 0x44, 0x01, // Wń (U+0057 U+0144)
  0x00, 0x57, 0x01, 0x46, 0x01, // Wņ (U+0057 U+0146)
  0x00, 0x57, 0x01, 0x4B, 0x01, // Wŋ (U+0057 U+014B)
  0x00, 0x57, 0x01, 0x4C, 0x01, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x01, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x01, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x01, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x55, 0x01, // Wŕ (U+0057 U+0155)
  0x00, 0x57, 0x01, 0x57, 0x01, // Wŗ (U+0057 U+0157)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x69, 0x01, // Wũ (U+0057 U+0169)
  0x00, 0x57, 0x01, 0x6B, 0x01, // Wū (U+0057 U+016B)
  0x00, 0x57, 0x01, 0x6D, 0x01, // Wŭ (U+0057 U+016D)
  0x00, 0x57, 0x01, 0x6F, 0x01, // Wů (U+0057 U+016F)
  0x00, 0x57, 0x01, 0x71, 0x01, // Wű (U+0057 U+0171)
  0x00, 0x57, 0x01, 0x73, 0x01, // Wų (U+0057 U+0173)
  0x00, 0x57, 0x20, 0x1A, 0x03, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x03, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x03, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x02, // W‹ (U+0057 U+2039)
  0x00, 0x57, 0x20, 0x3A, 0x01, // W› (U+0057 U+203A)
  0x00, 0x58, 0x00, 0x43, 0x01, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x01, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x01, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x01, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0xAB, 0x01, // X« (U+0058 U+00AB)
  0x00, 0x58, 0x00, 0xC7, 0x01, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x01, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x01, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x01, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x01, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x01, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x01, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x01, 0x06, 0x01, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x01, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x01, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x01, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x01, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x01, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x01, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x01, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x01, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x01, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x01, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x01, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x20, 0x39, 0x01, // X‹ (U+0058 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x04, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x04, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x03, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x03, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x03, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x03, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x03, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x03, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x02, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x02, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x03, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x02, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x03, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x02, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x03, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x02, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xAB, 0x05, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x02, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x03, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x03, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x03, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x03, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x03, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x03, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x03, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x03, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x03, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x03, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x03, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x03, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x03, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x03, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x03, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x03, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x03, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x03, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x03, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x03, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x03, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x03, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x03, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x03, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x02, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x02, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x02, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x02, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x03, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x03, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x03, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x03, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x03, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x03, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x03, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x03, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x03, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x03, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x03, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x03, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x03, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x03, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x03, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x03, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x03, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x03, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x03, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x03, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x03, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x02, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x02, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x02, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x02, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x03, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x03, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x03, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x03, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x02, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x02, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x03, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x03, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x02, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x02, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x02, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x02, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x02, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x02, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x04, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x04, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x04, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x05, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x02, // Y› (U+0059 U+203A)
  0x00, 0x5A, 0x00, 0x43, 0x01, // ZC (U+005A U+0043)
  0x00, 0x5A, 0x00, 0x47, 0x01, // ZG (U+005A U+0047)
  0x00, 0x5A, 0x00, 0x4F, 0x01, // ZO (U+005A U+004F)
  0x00, 0x5A, 0x00, 0x51, 0x01, // ZQ (U+005A U+0051)
  0x00, 0x5A, 0x00, 0xAB, 0x01, // Z« (U+005A U+00AB)
  0x00, 0x5A, 0x00, 0xC7, 0x01, // ZÇ (U+005A U+00C7)
  0x00, 0x5A, 0x00, 0xD2, 0x01, // ZÒ (U+005A U+00D2)
  0x00, 0x5A, 0x00, 0xD3, 0x01, // ZÓ (U+005A U+00D3)
  0x00, 0x5A, 0x00, 0xD4, 0x01, // ZÔ (U+005A U+00D4)
  0x00, 0x5A, 0x00, 0xD5, 0x01, // ZÕ (U+005A U+00D5)
  0x00, 0x5A, 0x00, 0xD6, 0x01, // ZÖ (U+005A U+00D6)
  0x00, 0x5A, 0x00, 0xD8, 0x01, // ZØ (U+005A U+00D8)
  0x00, 0x5A, 0x01, 0x06, 0x01, // ZĆ (U+005A U+0106)
  0x00, 0x5A, 0x01, 0x08, 0x01, // ZĈ (U+005A U+0108)
  0x00, 0x5A, 0x01, 0x0A, 0x01, // ZĊ (U+005A U+010A)
  0x00, 0x5A, 0x01, 0x0C, 0x01, // ZČ (U+005A U+010C)
  0x00, 0x5A, 0x01, 0x1C, 0x01, // ZĜ (U+005A U+011C)
  0x00, 0x5A, 0x01, 0x1E, 0x01, // ZĞ (U+005A U+011E)
  0x00, 0x5A, 0x01, 0x20, 0x01, // ZĠ (U+005A U+0120)
  0x00, 0x5A, 0x01, 0x22, 0x01, // ZĢ (U+005A U+0122)
  0x00, 0x5A, 0x01, 0x4C, 0x01, // ZŌ (U+005A U+014C)
  0x00, 0x5A, 0x01, 0x4E, 0x01, // ZŎ (U+005A U+014E)
  0x00, 0x5A, 0x01, 0x50, 0x01, // ZŐ (U+005A U+0150)
  0x00, 0x5A, 0x01, 0x52, 0x01, // ZŒ (U+005A U+0152)
  0x00, 0x5A, 0x20, 0x39, 0x01, // Z‹ (U+005A U+2039)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x61, 0x20, 0x19, 0x01, // a’ (U+0061 U+2019)
  0x00, 0x61, 0x20, 0x1D, 0x01, // a” (U+0061 U+201D)
  0x00, 0x62, 0x00, 0x22, 0x01, // b" (U+0062 U+0022)
  0x00, 0x62, 0x00, 0x27, 0x01, // b' (U+0062 U+0027)
  0x00, 0x62, 0x00, 0x76, 0x01, // bv (U+0062 U+0076)
  0x00, 0x62, 0x00, 0x77, 0x01, // bw (U+0062 U+0077)
  0x00, 0x62, 0x00, 0x78, 0x01, // bx (U+0062 U+0078)
  0x00, 0x62, 0x00, 0x79, 0x01, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xFD, 0x01, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x01, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x75, 0x01, // bŵ (U+0062 U+0175)
  0x00, 0x62, 0x01, 0x77, 0x01, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x20, 0x19, 0x01, // b’ (U+0062 U+2019)
  0x00, 0x62, 0x20, 0x1D, 0x01, // b” (U+0062 U+201D)
  0x00, 0x65, 0x00, 0x22, 0x01, // e" (U+0065 U+0022)
  0x00, 0x65, 0x00, 0x27, 0x01, // e' (U+0065 U+0027)
  0x00, 0x65, 0x00, 0x76, 0x01, // ev (U+0065 U+0076)
  0x00, 0x65, 0x00, 0x77, 0x01, // ew (U+0065 U+0077)
  0x00, 0x65, 0x00, 0x78, 0x01, // ex (U+0065 U+0078)
  0x00, 0x65, 0x00, 0x79, 0x01, // ey (U+0065 U+0079)
  0x00, 0x65, 0x00, 0xFD, 0x01, // eý (U+0065 U+00FD)
  0x00, 0x65, 0x00, 0xFF, 0x01, // eÿ (U+0065 U+00FF)
  0x00, 0x65, 0x01, 0x75, 0x01, // eŵ (U+0065 U+0175)
  0x00, 0x65, 0x01, 0x77, 0x01, // eŷ (U+0065 U+0177)
  0x00, 0x65, 0x20, 0x19, 0x01, // e’ (U+0065 U+2019)
  0x00, 0x65, 0x20, 0x1D, 0x01, // e” (U+0065 U+201D)
  0x00, 0x66, 0x00, 0x2C, 0x01, // f, (U+0066 U+002C)
  0x00, 0x66, 0x00, 0x2E, 0x01, // f. (U+0066 U+002E)
  0x00, 0x66, 0x20, 0x1A, 0x01, // f‚ (U+0066 U+201A)
  0x00, 0x66, 0x20, 0x1E, 0x01, // f„ (U+0066 U+201E)
  0x00, 0x66, 0x20, 0x26, 0x01, // f… (U+0066 U+2026)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x68, 0x20, 0x19, 0x01, // h’ (U+0068 U+2019)
  0x00, 0x68, 0x20, 0x1D, 0x01, // h” (U+0068 U+201D)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6D, 0x20, 0x19, 0x01, // m’ (U+006D U+2019)
  0x00, 0x6D, 0x20, 0x1D, 0x01, // m” (U+006D U+201D)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6E, 0x20, 0x19, 0x01, // n’ (U+006E U+2019)
  0x00, 0x6E, 0x20, 0x1D, 0x01, // n” (U+006E U+201D)
  0x00, 0x6F, 0x00, 0x22, 0x01, // o" (U+006F U+0022)
  0x00, 0x6F, 0x00, 0x27, 0x01, // o' (U+006F U+0027)
  0x00, 0x6F, 0x00, 0x76, 0x01, // ov (U+006F U+0076)
  0x00, 0x6F, 0x00, 0x77, 0x01, // ow (U+006F U+0077)
  0x00, 0x6F, 0x00, 0x78, 0x01, // ox (U+006F U+0078)
  0x00, 0x6F, 0x00, 0x79, 0x01, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xFD, 0x01, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x01, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x75, 0x01, // oŵ (U+006F U+0175)
  0x00, 0x6F, 0x01, 0x77, 0x01, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x20, 0x19, 0x01, // o’ (U+006F U+2019)
  0x00, 0x6F, 0x20, 0x1D, 0x01, // o” (U+006F U+201D)
  0x00, 0x70, 0x00, 0x22, 0x01, // p" (U+0070 U+0022)
  0x00, 0x70, 0x00, 0x27, 0x01, // p' (U+0070 U+0027)
  0x00, 0x70, 0x00, 0x76, 0x01, // pv (U+0070 U+0076)
  0x00, 0x70, 0x00, 0x77, 0x01, // pw (U+0070 U+0077)
  0x00, 0x70, 0x00, 0x78, 0x01, // px (U+0070 U+0078)
  0x00, 0x70, 0x00, 0x79, 0x01, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xFD, 0x01, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x01, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x75, 0x01, // pŵ (U+0070 U+0175)
  0x00, 0x70, 0x01, 0x77, 0x01, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x20, 0x19, 0x01, // p’ (U+0070 U+2019)
  0x00, 0x70, 0x20, 0x1D, 0x01, // p” (U+0070 U+201D)
  0x00, 0x72, 0x00, 0x2C, 0x05, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x05, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x61, 0x01, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0x63, 0x01, // rc (U+0072 U+0063)
  0x00, 0x72, 0x00, 0x64, 0x01, // rd (U+0072 U+0064)
  0x00, 0x72, 0x00, 0x65, 0x01, // re (U+0072 U+0065)
  0x00, 0x72, 0x00, 0x67, 0x01, // rg (U+0072 U+0067)
  0x00, 0x72, 0x00, 0x6F, 0x01, // ro (U+0072 U+006F)
  0x00, 0x72, 0x00, 0x71, 0x01, // rq (U+0072 U+0071)
  0x00, 0x72, 0x00, 0xE0, 0x01, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x01, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x01, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x01, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x01, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x01, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x01, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x00, 0xE7, 0x01, // rç (U+0072 U+00E7)
  0x00, 0x72, 0x00, 0xE8, 0x01, // rè (U+0072 U+00E8)
  0x00, 0x72, 0x00, 0xE9, 0x01, // ré (U+0072 U+00E9)
  0x00, 0x72, 0x00, 0xEA, 0x01, // rê (U+0072 U+00EA)
  0x00, 0x72, 0x00, 0xEB, 0x01, // rë (U+0072 U+00EB)
  0x00, 0x72, 0x00, 0xF2, 0x01, // rò (U+0072 U+00F2)
  0x00, 0x72, 0x00, 0xF3, 0x01, // ró (U+0072 U+00F3)
  0x00, 0x72, 0x00, 0xF4, 0x01, // rô (U+0072 U+00F4)
  0x00, 0x72, 0x00, 0xF5, 0x01, // rõ (U+0072 U+00F5)
  0x00, 0x72, 0x00, 0xF6, 0x01, // rö (U+0072 U+00F6)
  0x00, 0x72, 0x00, 0xF8, 0x01, // rø (U+0072 U+00F8)
  0x00, 0x72, 0x01, 0x01, 0x01, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x03, 0x01, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x05, 0x01, // rą (U+0072 U+0105)
  0x00, 0x72, 0x01, 0x07, 0x01, // rć (U+0072 U+0107)
  0x00, 0x72, 0x01, 0x09, 0x01, // rĉ (U+0072 U+0109)
  0x00, 0x72, 0x01, 0x0B, 0x01, // rċ (U+0072 U+010B)
  0x00, 0x72, 0x01, 0x0D, 0x01, // rč (U+0072 U+010D)
  0x00, 0x72, 0x01, 0x0F, 0x01, // rď (U+0072 U+010F)
  0x00, 0x72, 0x01, 0x11, 0x01, // rđ (U+0072 U+0111)
  0x00, 0x72, 0x01, 0x13, 0x01, // rē (U+0072 U+0113)
  0x00, 0x72, 0x01, 0x15, 0x01, // rĕ (U+0072 U+0115)
  0x00, 0x72, 0x01, 0x17, 0x01, // rė (U+0072 U+0117)
  0x00, 0x72, 0x01, 0x19, 0x01, // rę (U+0072 U+0119)
  0x00, 0x72, 0x01, 0x1B, 0x01, // rě (U+0072 U+011B)
  0x00, 0x72, 0x01, 0x1D, 0x01, // rĝ (U+0072 U+011D)
  0x00, 0x72, 0x01, 0x1F, 0x01, // rğ (U+0072 U+011F)
  0x00, 0x72, 0x01, 0x21, 0x01, // rġ (U+0072 U+0121)
  0x00, 0x72, 0x01, 0x23, 0x01, // rģ (U+0072 U+0123)
  0x00, 0x72, 0x01, 0x4D, 0x01, // rō (U+0072 U+014D)
  0x00, 0x72, 0x01, 0x4F, 0x01, // rŏ (U+0072 U+014F)
  0x00, 0x72, 0x01, 0x51, 0x01, // rő (U+0072 U+0151)
  0x00, 0x72, 0x01, 0x53, 0x01, // rœ (U+0072 U+0153)
  0x00, 0x72, 0x20, 0x1A, 0x05, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x05, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x05, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x03, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x03, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x03, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x03, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x03, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x03, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x03, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x03, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x03, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x03, // w… (U+0077 U+2026)
  0x00, 0x78, 0x00, 0x63, 0x01, // xc (U+0078 U+0063)
  0x00, 0x78, 0x00, 0x64, 0x01, // xd (U+0078 U+0064)
  0x00, 0x78, 0x00, 0x65, 0x01, // xe (U+0078 U+0065)
  0x00, 0x78, 0x00, 0x6F, 0x01, // xo (U+0078 U+006F)
  0x00, 0x78, 0x00, 0x71, 0x01, // xq (U+0078 U+0071)
  0x00, 0x78, 0x00, 0xE0, 0x01, // xà (U+0078 U+00E0)
  0x00, 0x78, 0x00, 0xE7, 0x01, // xç (U+0078 U+00E7)
  0x00, 0x78, 0x00, 0xE8, 0x01, // xè (U+0078 U+00E8)
  0x00, 0x78, 0x00, 0xE9, 0x01, // xé (U+0078 U+00E9)
  0x00, 0x78, 0x00, 0xEA, 0x01, // xê (U+0078 U+00EA)
  0x00, 0x78, 0x00, 0xEB, 0x01, // xë (U+0078 U+00EB)
  0x00, 0x78, 0x00, 0xF2, 0x01, // xò (U+0078 U+00F2)
  0x00, 0x78, 0x00, 0xF3, 0x01, // xó (U+0078 U+00F3)
  0x00, 0x78, 0x00, 0xF4, 0x01, // xô (U+0078 U+00F4)
  0x00, 0x78, 0x00, 0xF5, 0x01, // xõ (U+0078 U+00F5)
  0x00, 0x78, 0x00, 0xF6, 0x01, // xö (U+0078 U+00F6)
  0x00, 0x78, 0x00, 0xF8, 0x01, // xø (U+0078 U+00F8)
  0x00, 0x78, 0x01, 0x07, 0x01, // xć (U+0078 U+0107)
  0x00, 0x78, 0x01, 0x09, 0x01, // xĉ (U+0078 U+0109)
  0x00, 0x78, 0x01, 0x0B, 0x01, // xċ (U+0078 U+010B)
  0x00, 0x78, 0x01, 0x0D, 0x01, // xč (U+0078 U+010D)
  0x00, 0x78, 0x01, 0x0F, 0x01, // xď (U+0078 U+010F)
  0x00, 0x78, 0x01, 0x11, 0x01, // xđ (U+0078 U+0111)
  0x00, 0x78, 0x01, 0x13, 0x01, // xē (U+0078 U+0113)
  0x00, 0x78, 0x01, 0x15, 0x01, // xĕ (U+0078 U+0115)
  0x00, 0x78, 0x01, 0x17, 0x01, // xė (U+0078 U+0117)
  0x00, 0x78, 0x01, 0x19, 0x01, // xę (U+0078 U+0119)
  0x00, 0x78, 0x01, 0x1B, 0x01, // xě (U+0078 U+011B)
  0x00, 0x78, 0x01, 0x4D, 0x01, // xō (U+0078 U+014D)
  0x00, 0x78, 0x01, 0x4F, 0x01, // xŏ (U+0078 U+014F)
  0x00, 0x78, 0x01, 0x51, 0x01, // xő (U+0078 U+0151)
  0x00, 0x78, 0x01, 0x53, 0x01, // xœ (U+0078 U+0153)
  0x00, 0x79, 0x00, 0x2C, 0x03, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x03, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x03, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x03, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x03, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x01, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x02, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x02, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x62, 0x01, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x01, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x01, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xA1, 0x01, 0x74, 0x01, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x02, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x02, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x02, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x56, 0x01, // «V (U+00AB U+0056)
  0x00, 0xAB, 0x00, 0x57, 0x01, // «W (U+00AB U+0057)
  0x00, 0xAB, 0x00, 0x59, 0x02, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x02, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x02, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x02, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x02, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x74, 0x01, // «Ŵ (U+00AB U+0174)
  0x00, 0xAB, 0x01, 0x76, 0x02, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x02, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x04, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x02, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x02, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x58, 0x01, // »X (U+00BB U+0058)
  0x00, 0xBB, 0x00, 0x59, 0x05, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x05, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x04, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x04, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x04, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x02, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x05, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x05, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x03, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x02, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x02, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x03, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x03, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x03, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x03, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x03, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x02, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x03, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x03, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x05, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x05, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x43, 0x01, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x01, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x01, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x01, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x03, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x03, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xC7, 0x01, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x01, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x01, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x01, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x01, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x01, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x01, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xDD, 0x03, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x06, 0x01, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x08, 0x01, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x0A, 0x01, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0C, 0x01, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x1C, 0x01, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1E, 0x01, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x20, 0x01, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x22, 0x01, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x4C, 0x01, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4E, 0x01, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x50, 0x01, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x52, 0x01, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x62, 0x03, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x03, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x03, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x03, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x03, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x05, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x05, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x05, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x05, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x43, 0x01, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x01, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x01, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x01, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x03, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x03, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xC7, 0x01, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x01, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x01, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x01, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x01, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x01, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x01, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xDD, 0x03, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x06, 0x01, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x08, 0x01, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x0A, 0x01, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0C, 0x01, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x1C, 0x01, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1E, 0x01, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x20, 0x01, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x22, 0x01, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x4C, 0x01, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4E, 0x01, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x50, 0x01, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x52, 0x01, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x62, 0x03, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x03, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x03, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x03, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x03, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x05, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x05, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x05, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x05, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x43, 0x01, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x01, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x01, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x01, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x03, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x03, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xC7, 0x01, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x01, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x01, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x01, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x01, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x01, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x01, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xDD, 0x03, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x06, 0x01, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x08, 0x01, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x0A, 0x01, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0C, 0x01, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x1C, 0x01, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1E, 0x01, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x20, 0x01, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x22, 0x01, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x4C, 0x01, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4E, 0x01, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x50, 0x01, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x52, 0x01, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x62, 0x03, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x03, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x03, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x03, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x03, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x05, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x05, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x05, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x05, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x43, 0x01, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x01, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x01, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x01, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x03, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x03, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xC7, 0x01, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x01, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x01, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x01, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x01, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x01, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x01, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xDD, 0x03, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x06, 0x01, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x08, 0x01, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x0A, 0x01, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0C, 0x01, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x1C, 0x01, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1E, 0x01, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x20, 0x01, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x22, 0x01, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x4C, 0x01, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4E, 0x01, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x50, 0x01, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x52, 0x01, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x62, 0x03, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x03, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x03, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x03, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x03, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x05, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x05, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x05, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x05, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x43, 0x01, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x01, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x01, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x01, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x03, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x03, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xC7, 0x01, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x01, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x01, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x01, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x01, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x01, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x01, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xDD, 0x03, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x06, 0x01, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x08, 0x01, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x0A, 0x01, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0C, 0x01, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x1C, 0x01, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1E, 0x01, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x20, 0x01, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x22, 0x01, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x4C, 0x01, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4E, 0x01, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x50, 0x01, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x52, 0x01, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x62, 0x03, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x03, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x03, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x03, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x03, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x05, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x05, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x05, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x05, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x43, 0x01, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x01, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x01, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x01, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x03, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x03, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xC7, 0x01, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x01, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x01, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x01, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x01, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x01, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x01, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xDD, 0x03, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x06, 0x01, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x08, 0x01, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x0A, 0x01, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0C, 0x01, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x1C, 0x01, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1E, 0x01, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x20, 0x01, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x22, 0x01, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x4C, 0x01, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4E, 0x01, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x50, 0x01, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x52, 0x01, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x62, 0x03, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x03, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x03, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x03, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x03, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x05, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x05, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x02, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x02, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x02, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x02, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xAB, 0x01, // Ç« (U+00C7 U+00AB)
  0x00, 0xC7, 0x00, 0xC7, 0x02, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x02, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x02, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x02, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x02, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x02, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x02, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x02, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x02, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x02, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x02, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x02, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x02, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x02, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x02, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x02, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x02, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x02, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x02, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC7, 0x20, 0x39, 0x01, // Ç‹ (U+00C7 U+2039)
  0x00, 0xD0, 0x00, 0x2C, 0x03, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x03, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x41, 0x01, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x58, 0x01, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC0, 0x01, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x01, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x01, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x01, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x01, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x01, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x01, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x01, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x01, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x20, 0x1A, 0x03, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x03, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x03, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x03, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x03, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x41, 0x01, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x58, 0x01, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC0, 0x01, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x01, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x01, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x01, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x01, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x01, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x01, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x01, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x01, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x20, 0x1A, 0x03, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x03, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x03, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x03, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x03, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x41, 0x01, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x58, 0x01, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC0, 0x01, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x01, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x01, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x01, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x01, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x01, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x01, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x01, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x01, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x20, 0x1A, 0x03, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x03, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x03, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x03, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x03, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x41, 0x01, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x58, 0x01, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC0, 0x01, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x01, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x01, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x01, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x01, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x01, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x01, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x01, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x01, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x20, 0x1A, 0x03, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x03, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x03, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x03, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x03, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x41, 0x01, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x58, 0x01, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC0, 0x01, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x01, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x01, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x01, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x01, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x01, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x01, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x01, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x01, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x20, 0x1A, 0x03, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x03, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x03, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x03, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x03, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x41, 0x01, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x58, 0x01, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC0, 0x01, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x01, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x01, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x01, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x01, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x01, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x01, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x01, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x01, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x20, 0x1A, 0x03, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x03, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x03, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x03, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x03, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x41, 0x01, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x58, 0x01, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC0, 0x01, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x01, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x01, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x01, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x01, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x01, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x01, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x01, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x01, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x20, 0x1A, 0x03, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x03, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x03, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x41, 0x01, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x01, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x01, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x01, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x01, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x01, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x01, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x01, 0x00, 0x01, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x01, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x01, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x41, 0x01, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x01, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x01, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x01, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x01, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x01, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x01, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x01, 0x00, 0x01, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x01, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x01, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x41, 0x01, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x01, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x01, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x01, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x01, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x01, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x01, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x01, 0x00, 0x01, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x01, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x01, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x41, 0x01, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x01, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x01, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x01, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x01, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x01, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x01, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x01, 0x00, 0x01, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x01, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x01, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x04, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x04, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x03, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x03, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x03, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x03, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x03, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x03, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x02, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x02, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x03, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x02, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x03, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x02, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x03, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x02, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xAB, 0x05, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x02, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x03, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x03, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x03, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x03, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x03, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x03, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x03, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x03, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x03, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x03, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x03, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x03, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x03, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x03, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x03, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x03, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x03, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x03, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x03, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x03, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x03, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x03, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x03, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x03, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x02, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x02, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x02, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x02, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x03, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x03, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x03, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x03, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x03, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x03, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x03, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x03, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x03, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x03, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x03, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x03, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x03, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x03, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x03, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x03, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x03, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x03, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x03, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x03, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x03, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x02, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x02, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x02, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x02, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x03, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x03, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x03, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x03, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x02, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x02, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x03, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x03, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x02, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x02, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x02, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x02, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x02, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x02, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x04, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x04, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x04, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x05, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x02, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x26, 0x01, // Þ& (U+00DE U+0026)
  0x00, 0xDE, 0x00, 0x2C, 0x08, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x08, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x03, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x5A, 0x01, // ÞZ (U+00DE U+005A)
  0x00, 0xDE, 0x00, 0xAB, 0x01, // Þ« (U+00DE U+00AB)
  0x00, 0xDE, 0x00, 0xC0, 0x03, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x03, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x03, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x03, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x03, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x03, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x03, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x03, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x03, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x03, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x79, 0x01, // ÞŹ (U+00DE U+0179)
  0x00, 0xDE, 0x01, 0x7B, 0x01, // ÞŻ (U+00DE U+017B)
  0x00, 0xDE, 0x01, 0x7D, 0x01, // ÞŽ (U+00DE U+017D)
  0x00, 0xDE, 0x20, 0x1A, 0x08, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x08, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x08, // Þ… (U+00DE U+2026)
  0x00, 0xDE, 0x20, 0x39, 0x01, // Þ‹ (U+00DE U+2039)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x20, 0x19, 0x01, // à’ (U+00E0 U+2019)
  0x00, 0xE0, 0x20, 0x1D, 0x01, // à” (U+00E0 U+201D)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x20, 0x19, 0x01, // á’ (U+00E1 U+2019)
  0x00, 0xE1, 0x20, 0x1D, 0x01, // á” (U+00E1 U+201D)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x20, 0x19, 0x01, // â’ (U+00E2 U+2019)
  0x00, 0xE2, 0x20, 0x1D, 0x01, // â” (U+00E2 U+201D)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x20, 0x19, 0x01, // ã’ (U+00E3 U+2019)
  0x00, 0xE3, 0x20, 0x1D, 0x01, // ã” (U+00E3 U+201D)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x20, 0x19, 0x01, // ä’ (U+00E4 U+2019)
  0x00, 0xE4, 0x20, 0x1D, 0x01, // ä” (U+00E4 U+201D)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x20, 0x19, 0x01, // å’ (U+00E5 U+2019)
  0x00, 0xE5, 0x20, 0x1D, 0x01, // å” (U+00E5 U+201D)
  0x00, 0xE6, 0x00, 0x22, 0x01, // æ" (U+00E6 U+0022)
  0x00, 0xE6, 0x00, 0x27, 0x01, // æ' (U+00E6 U+0027)
  0x00, 0xE6, 0x00, 0x76, 0x01, // æv (U+00E6 U+0076)
  0x00, 0xE6, 0x00, 0x77, 0x01, // æw (U+00E6 U+0077)
  0x00, 0xE6, 0x00, 0x78, 0x01, // æx (U+00E6 U+0078)
  0x00, 0xE6, 0x00, 0x79, 0x01, // æy (U+00E6 U+0079)
  0x00, 0xE6, 0x00, 0xFD, 0x01, // æý (U+00E6 U+00FD)
  0x00, 0xE6, 0x00, 0xFF, 0x01, // æÿ (U+00E6 U+00FF)
  0x00, 0xE6, 0x01, 0x75, 0x01, // æŵ (U+00E6 U+0175)
  0x00, 0xE6, 0x01, 0x77, 0x01, // æŷ (U+00E6 U+0177)
  0x00, 0xE6, 0x20, 0x19, 0x01, // æ’ (U+00E6 U+2019)
  0x00, 0xE6, 0x20, 0x1D, 0x01, // æ” (U+00E6 U+201D)
  0x00, 0xE8, 0x00, 0x22, 0x01, // è" (U+00E8 U+0022)
  0x00, 0xE8, 0x00, 0x27, 0x01, // è' (U+00E8 U+0027)
  0x00, 0xE8, 0x00, 0x76, 0x01, // èv (U+00E8 U+0076)
  0x00, 0xE8, 0x00, 0x77, 0x01, // èw (U+00E8 U+0077)
  0x00, 0xE8, 0x00, 0x78, 0x01, // èx (U+00E8 U+0078)
  0x00, 0xE8, 0x00, 0x79, 0x01, // èy (U+00E8 U+0079)
  0x00, 0xE8, 0x00, 0xFD, 0x01, // èý (U+00E8 U+00FD)
  0x00, 0xE8, 0x00, 0xFF, 0x01, // èÿ (U+00E8 U+00FF)
  0x00, 0xE8, 0x01, 0x75, 0x01, // èŵ (U+00E8 U+0175)
  0x00, 0xE8, 0x01, 0x77, 0x01, // èŷ (U+00E8 U+0177)
  0x00, 0xE8, 0x20, 0x19, 0x01, // è’ (U+00E8 U+2019)
  0x00, 0xE8, 0x20, 0x1D, 0x01, // è” (U+00E8 U+201D)
  0x00, 0xE9, 0x00, 0x22, 0x01, // é" (U+00E9 U+0022)
  0x00, 0xE9, 0x00, 0x27, 0x01, // é' (U+00E9 U+0027)
  0x00, 0xE9, 0x00, 0x76, 0x01, // év (U+00E9 U+0076)
  0x00, 0xE9, 0x00, 0x77, 0x01, // éw (U+00E9 U+0077)
  0x00, 0xE9, 0x00, 0x78, 0x01, // éx (U+00E9 U+0078)
  0x00, 0xE9, 0x00, 0x79, 0x01, // éy (U+00E9 U+0079)
  0x00, 0xE9, 0x00, 0xFD, 0x01, // éý (U+00E9 U+00FD)
  0x00, 0xE9, 0x00, 0xFF, 0x01, // éÿ (U+00E9 U+00FF)
  0x00, 0xE9, 0x01, 0x75, 0x01, // éŵ (U+00E9 U+0175)
  0x00, 0xE9, 0x01, 0x77, 0x01, // éŷ (U+00E9 U+0177)
  0x00, 0xE9, 0x20, 0x19, 0x01, // é’ (U+00E9 U+2019)
  0x00, 0xE9, 0x20, 0x1D, 0x01, // é” (U+00E9 U+201D)
  0x00, 0xEA, 0x00, 0x22, 0x01, // ê" (U+00EA U+0022)
  0x00, 0xEA, 0x00, 0x27, 0x01, // ê' (U+00EA U+0027)
  0x00, 0xEA, 0x00, 0x76, 0x01, // êv (U+00EA U+0076)
  0x00, 0xEA, 0x00, 0x77, 0x01, // êw (U+00EA U+0077)
  0x00, 0xEA, 0x00, 0x78, 0x01, // êx (U+00EA U+0078)
  0x00, 0xEA, 0x00, 0x79, 0x01, // êy (U+00EA U+0079)
  0x00, 0xEA, 0x00, 0xFD, 0x01, // êý (U+00EA U+00FD)
  0x00, 0xEA, 0x00, 0xFF, 0x01, // êÿ (U+00EA U+00FF)
  0x00, 0xEA, 0x01, 0x75, 0x01, // êŵ (U+00EA U+0175)
  0x00, 0xEA, 0x01, 0x77, 0x01, // êŷ (U+00EA U+0177)
  0x00, 0xEA, 0x20, 0x19, 0x01, // ê’ (U+00EA U+2019)
  0x00, 0xEA, 0x20, 0x1D, 0x01, // ê” (U+00EA U+201D)
  0x00, 0xEB, 0x00, 0x22, 0x01, // ë" (U+00EB U+0022)
  0x00, 0xEB, 0x00, 0x27, 0x01, // ë' (U+00EB U+0027)
  0x00, 0xEB, 0x00, 0x76, 0x01, // ëv (U+00EB U+0076)
  0x00, 0xEB, 0x00, 0x77, 0x01, // ëw (U+00EB U+0077)
  0x00, 0xEB, 0x00, 0x78, 0x01, // ëx (U+00EB U+0078)
  0x00, 0xEB, 0x00, 0x79, 0x01, // ëy (U+00EB U+0079)
  0x00, 0xEB, 0x00, 0xFD, 0x01, // ëý (U+00EB U+00FD)
  0x00, 0xEB, 0x00, 0xFF, 0x01, // ëÿ (U+00EB U+00FF)
  0x00, 0xEB, 0x01, 0x75, 0x01, // ëŵ (U+00EB U+0175)
  0x00, 0xEB, 0x01, 0x77, 0x01, // ëŷ (U+00EB U+0177)
  0x00, 0xEB, 0x20, 0x19, 0x01, // ë’ (U+00EB U+2019)
  0x00, 0xEB, 0x20, 0x1D, 0x01, // ë” (U+00EB U+201D)
  0x00, 0xF0, 0x00, 0x22, 0x01, // ð" (U+00F0 U+0022)
  0x00, 0xF0, 0x00, 0x27, 0x01, // ð' (U+00F0 U+0027)
  0x00, 0xF0, 0x00, 0x76, 0x01, // ðv (U+00F0 U+0076)
  0x00, 0xF0, 0x00, 0x77, 0x01, // ðw (U+00F0 U+0077)
  0x00, 0xF0, 0x00, 0x78, 0x01, // ðx (U+00F0 U+0078)
  0x00, 0xF0, 0x00, 0x79, 0x01, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xFD, 0x01, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x01, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x75, 0x01, // ðŵ (U+00F0 U+0175)
  0x00, 0xF0, 0x01, 0x77, 0x01, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x20, 0x19, 0x01, // ð’ (U+00F0 U+2019)
  0x00, 0xF0, 0x20, 0x1D, 0x01, // ð” (U+00F0 U+201D)
  0x00, 0xF2, 0x00, 0x22, 0x01, // ò" (U+00F2 U+0022)
  0x00, 0xF2, 0x00, 0x27, 0x01, // ò' (U+00F2 U+0027)
  0x00, 0xF2, 0x00, 0x76, 0x01, // òv (U+00F2 U+0076)
  0x00, 0xF2, 0x00, 0x77, 0x01, // òw (U+00F2 U+0077)
  0x00, 0xF2, 0x00, 0x78, 0x01, // òx (U+00F2 U+0078)
  0x00, 0xF2, 0x00, 0x79, 0x01, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xFD, 0x01, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x01, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x75, 0x01, // òŵ (U+00F2 U+0175)
  0x00, 0xF2, 0x01, 0x77, 0x01, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x20, 0x19, 0x01, // ò’ (U+00F2 U+2019)
  0x00, 0xF2, 0x20, 0x1D, 0x01, // ò” (U+00F2 U+201D)
  0x00, 0xF3, 0x00, 0x22, 0x01, // ó" (U+00F3 U+0022)
  0x00, 0xF3, 0x00, 0x27, 0x01, // ó' (U+00F3 U+0027)
  0x00, 0xF3, 0x00, 0x76, 0x01, // óv (U+00F3 U+0076)
  0x00, 0xF3, 0x00, 0x77, 0x01, // ów (U+00F3 U+0077)
  0x00, 0xF3, 0x00, 0x78, 0x01, // óx (U+00F3 U+0078)
  0x00, 0xF3, 0x00, 0x79, 0x01, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xFD, 0x01, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x01, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x75, 0x01, // óŵ (U+00F3 U+0175)
  0x00, 0xF3, 0x01, 0x77, 0x01, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x20, 0x19, 0x01, // ó’ (U+00F3 U+2019)
  0x00, 0xF3, 0x20, 0x1D, 0x01, // ó” (U+00F3 U+201D)
  0x00, 0xF4, 0x00, 0x22, 0x01, // ô" (U+00F4 U+0022)
  0x00, 0xF4, 0x00, 0x27, 0x01, // ô' (U+00F4 U+0027)
  0x00, 0xF4, 0x00, 0x76, 0x01, // ôv (U+00F4 U+0076)
  0x00, 0xF4, 0x00, 0x77, 0x01, // ôw (U+00F4 U+0077)
  0x00, 0xF4, 0x00, 0x78, 0x01, // ôx (U+00F4 U+0078)
  0x00, 0xF4, 0x00, 0x79, 0x01, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xFD, 0x01, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x01, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x75, 0x01, // ôŵ (U+00F4 U+0175)
  0x00, 0xF4, 0x01, 0x77, 0x01, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x20, 0x19, 0x01, // ô’ (U+00F4 U+2019)
  0x00, 0xF4, 0x20, 0x1D, 0x01, // ô” (U+00F4 U+201D)
  0x00, 0xF5, 0x00, 0x22, 0x01, // õ" (U+00F5 U+0022)
  0x00, 0xF5, 0x00, 0x27, 0x01, // õ' (U+00F5 U+0027)
  0x00, 0xF5, 0x00, 0x76, 0x01, // õv (U+00F5 U+0076)
  0x00, 0xF5, 0x00, 0x77, 0x01, // õw (U+00F5 U+0077)
  0x00, 0xF5, 0x00, 0x78, 0x01, // õx (U+00F5 U+0078)
  0x00, 0xF5, 0x00, 0x79, 0x01, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xFD, 0x01, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x01, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x75, 0x01, // õŵ (U+00F5 U+0175)
  0x00, 0xF5, 0x01, 0x77, 0x01, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x20, 0x19, 0x01, // õ’ (U+00F5 U+2019)
  0x00, 0xF5, 0x20, 0x1D, 0x01, // õ” (U+00F5 U+201D)
  0x00, 0xF6, 0x00, 0x22, 0x01, // ö" (U+00F6 U+0022)
  0x00, 0xF6, 0x00, 0x27, 0x01, // ö' (U+00F6 U+0027)
  0x00, 0xF6, 0x00, 0x76, 0x01, // öv (U+00F6 U+0076)
  0x00, 0xF6, 0x00, 0x77, 0x01, // öw (U+00F6 U+0077)
  0x00, 0xF6, 0x00, 0x78, 0x01, // öx (U+00F6 U+0078)
  0x00, 0xF6, 0x00, 0x79, 0x01, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xFD, 0x01, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x01, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x75, 0x01, // öŵ (U+00F6 U+0175)
  0x00, 0xF6, 0x01, 0x77, 0x01, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x20, 0x19, 0x01, // ö’ (U+00F6 U+2019)
  0x00, 0xF6, 0x20, 0x1D, 0x01, // ö” (U+00F6 U+201D)
  0x00, 0xF8, 0x00, 0x22, 0x01, // ø" (U+00F8 U+0022)
  0x00, 0xF8, 0x00, 0x27, 0x01, // ø' (U+00F8 U+0027)
  0x00, 0xF8, 0x00, 0x76, 0x01, // øv (U+00F8 U+0076)
  0x00, 0xF8, 0x00, 0x77, 0x01, // øw (U+00F8 U+0077)
  0x00, 0xF8, 0x00, 0x78, 0x01, // øx (U+00F8 U+0078)
  0x00, 0xF8, 0x00, 0x79, 0x01, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xFD, 0x01, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x01, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x75, 0x01, // øŵ (U+00F8 U+0175)
  0x00, 0xF8, 0x01, 0x77, 0x01, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x20, 0x19, 0x01, // ø’ (U+00F8 U+2019)
  0x00, 0xF8, 0x20, 0x1D, 0x01, // ø” (U+00F8 U+201D)
  0x00, 0xFD, 0x00, 0x2C, 0x03, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x03, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x03, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x03, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x03, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x22, 0x01, // þ" (U+00FE U+0022)
  0x00, 0xFE, 0x00, 0x27, 0x01, // þ' (U+00FE U+0027)
  0x00, 0xFE, 0x00, 0x76, 0x01, // þv (U+00FE U+0076)
  0x00, 0xFE, 0x00, 0x77, 0x01, // þw (U+00FE U+0077)
  0x00, 0xFE, 0x00, 0x78, 0x01, // þx (U+00FE U+0078)
  0x00, 0xFE, 0x00, 0x79, 0x01, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xFD, 0x01, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x01, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x75, 0x01, // þŵ (U+00FE U+0175)
  0x00, 0xFE, 0x01, 0x77, 0x01, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x20, 0x19, 0x01, // þ’ (U+00FE U+2019)
  0x00, 0xFE, 0x20, 0x1D, 0x01, // þ” (U+00FE U+201D)
  0x00, 0xFF, 0x00, 0x2C, 0x03, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x03, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x03, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x03, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x03, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x05, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x05, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x43, 0x01, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x01, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x01, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x01, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x03, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x03, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xC7, 0x01, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x01, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x01, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x01, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x01, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x01, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x01, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xDD, 0x03, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x06, 0x01, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x08, 0x01, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x0A, 0x01, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0C, 0x01, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x1C, 0x01, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1E, 0x01, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x20, 0x01, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x22, 0x01, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x4C, 0x01, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4E, 0x01, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x50, 0x01, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x52, 0x01, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x62, 0x03, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x03, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x03, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x03, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x03, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x05, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x05, // Ā” (U+0100 U+201D)
  0x01, 0x01, 0x00, 0x22, 0x01, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x01, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x20, 0x19, 0x01, // ā’ (U+0101 U+2019)
  0x01, 0x01, 0x20, 0x1D, 0x01, // ā” (U+0101 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x05, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x05, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x43, 0x01, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x01, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x01, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x01, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x03, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x03, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xC7, 0x01, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x01, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x01, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x01, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x01, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x01, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x01, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xDD, 0x03, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x06, 0x01, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x08, 0x01, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x0A, 0x01, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0C, 0x01, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x1C, 0x01, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1E, 0x01, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x20, 0x01, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x22, 0x01, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x4C, 0x01, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4E, 0x01, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x50, 0x01, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x52, 0x01, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x62, 0x03, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x03, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x03, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x03, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x03, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x05, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x05, // Ă” (U+0102 U+201D)
  0x01, 0x03, 0x00, 0x22, 0x01, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x01, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x20, 0x19, 0x01, // ă’ (U+0103 U+2019)
  0x01, 0x03, 0x20, 0x1D, 0x01, // ă” (U+0103 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x05, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x05, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x43, 0x01, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x01, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x01, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x01, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x03, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x03, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xC7, 0x01, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x01, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x01, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x01, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x01, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x01, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x01, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xDD, 0x03, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x06, 0x01, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x08, 0x01, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x0A, 0x01, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0C, 0x01, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x1C, 0x01, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1E, 0x01, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x20, 0x01, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x22, 0x01, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x4C, 0x01, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4E, 0x01, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x50, 0x01, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x52, 0x01, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x62, 0x03, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x03, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x03, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x03, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x03, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x05, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x05, // Ą” (U+0104 U+201D)
  0x01, 0x05, 0x00, 0x22, 0x01, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x01, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x20, 0x19, 0x01, // ą’ (U+0105 U+2019)
  0x01, 0x05, 0x20, 0x1D, 0x01, // ą” (U+0105 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x02, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x02, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x02, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x02, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xAB, 0x01, // Ć« (U+0106 U+00AB)
  0x01, 0x06, 0x00, 0xC7, 0x02, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x02, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x02, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x02, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x02, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x02, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x02, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x02, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x02, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x02, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x02, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x02, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x02, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x02, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x02, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x02, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x02, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x02, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x02, // ĆŒ (U+0106 U+0152)
  0x01, 0x06, 0x20, 0x39, 0x01, // Ć‹ (U+0106 U+2039)
  0x01, 0x08, 0x00, 0x43, 0x02, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x02, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x02, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x02, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xAB, 0x01, // Ĉ« (U+0108 U+00AB)
  0x01, 0x08, 0x00, 0xC7, 0x02, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x02, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x02, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x02, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x02, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x02, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x02, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x02, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x02, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x02, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x02, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x02, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x02, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x02, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x02, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x02, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x02, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x02, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x02, // ĈŒ (U+0108 U+0152)
  0x01, 0x08, 0x20, 0x39, 0x01, // Ĉ‹ (U+0108 U+2039)
  0x01, 0x0A, 0x00, 0x43, 0x02, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x02, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x02, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x02, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xAB, 0x01, // Ċ« (U+010A U+00AB)
  0x01, 0x0A, 0x00, 0xC7, 0x02, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x02, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x02, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x02, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x02, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x02, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x02, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x02, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x02, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x02, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x02, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x02, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x02, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x02, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x02, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x02, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x02, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x02, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x02, // ĊŒ (U+010A U+0152)
  0x01, 0x0A, 0x20, 0x39, 0x01, // Ċ‹ (U+010A U+2039)
  0x01, 0x0C, 0x00, 0x43, 0x02, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x02, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x02, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x02, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xAB, 0x01, // Č« (U+010C U+00AB)
  0x01, 0x0C, 0x00, 0xC7, 0x02, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x02, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x02, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x02, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x02, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x02, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x02, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x02, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x02, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x02, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x02, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x02, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x02, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x02, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x02, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x02, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x02, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x02, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x02, // ČŒ (U+010C U+0152)
  0x01, 0x0C, 0x20, 0x39, 0x01, // Č‹ (U+010C U+2039)
  0x01, 0x0E, 0x00, 0x2C, 0x03, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x03, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x41, 0x01, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x58, 0x01, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC0, 0x01, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x01, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x01, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x01, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x01, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x01, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x01, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x01, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x01, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x20, 0x1A, 0x03, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x03, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x03, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x03, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x03, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x41, 0x01, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x58, 0x01, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC0, 0x01, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x01, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x01, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x01, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x01, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x01, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x01, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x01, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x01, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x20, 0x1A, 0x03, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x03, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x03, // Đ… (U+0110 U+2026)
  0x01, 0x13, 0x00, 0x22, 0x01, // ē" (U+0113 U+0022)
  0x01, 0x13, 0x00, 0x27, 0x01, // ē' (U+0113 U+0027)
  0x01, 0x13, 0x00, 0x76, 0x01, // ēv (U+0113 U+0076)
  0x01, 0x13, 0x00, 0x77, 0x01, // ēw (U+0113 U+0077)
  0x01, 0x13, 0x00, 0x78, 0x01, // ēx (U+0113 U+0078)
  0x01, 0x13, 0x00, 0x79, 0x01, // ēy (U+0113 U+0079)
  0x01, 0x13, 0x00, 0xFD, 0x01, // ēý (U+0113 U+00FD)
  0x01, 0x13, 0x00, 0xFF, 0x01, // ēÿ (U+0113 U+00FF)
  0x01, 0x13, 0x01, 0x75, 0x01, // ēŵ (U+0113 U+0175)
  0x01, 0x13, 0x01, 0x77, 0x01, // ēŷ (U+0113 U+0177)
  0x01, 0x13, 0x20, 0x19, 0x01, // ē’ (U+0113 U+2019)
  0x01, 0x13, 0x20, 0x1D, 0x01, // ē” (U+0113 U+201D)
  0x01, 0x15, 0x00, 0x22, 0x01, // ĕ" (U+0115 U+0022)
  0x01, 0x15, 0x00, 0x27, 0x01, // ĕ' (U+0115 U+0027)
  0x01, 0x15, 0x00, 0x76, 0x01, // ĕv (U+0115 U+0076)
  0x01, 0x15, 0x00, 0x77, 0x01, // ĕw (U+0115 U+0077)
  0x01, 0x15, 0x00, 0x78, 0x01, // ĕx (U+0115 U+0078)
  0x01, 0x15, 0x00, 0x79, 0x01, // ĕy (U+0115 U+0079)
  0x01, 0x15, 0x00, 0xFD, 0x01, // ĕý (U+0115 U+00FD)
  0x01, 0x15, 0x00, 0xFF, 0x01, // ĕÿ (U+0115 U+00FF)
  0x01, 0x15, 0x01, 0x75, 0x01, // ĕŵ (U+0115 U+0175)
  0x01, 0x15, 0x01, 0x77, 0x01, // ĕŷ (U+0115 U+0177)
  0x01, 0x15, 0x20, 0x19, 0x01, // ĕ’ (U+0115 U+2019)
  0x01, 0x15, 0x20, 0x1D, 0x01, // ĕ” (U+0115 U+201D)
  0x01, 0x17, 0x00, 0x22, 0x01, // ė" (U+0117 U+0022)
  0x01, 0x17, 0x00, 0x27, 0x01, // ė' (U+0117 U+0027)
  0x01, 0x17, 0x00, 0x76, 0x01, // ėv (U+0117 U+0076)
  0x01, 0x17, 0x00, 0x77, 0x01, // ėw (U+0117 U+0077)
  0x01, 0x17, 0x00, 0x78, 0x01, // ėx (U+0117 U+0078)
  0x01, 0x17, 0x00, 0x79, 0x01, // ėy (U+0117 U+0079)
  0x01, 0x17, 0x00, 0xFD, 0x01, // ėý (U+0117 U+00FD)
  0x01, 0x17, 0x00, 0xFF, 0x01, // ėÿ (U+0117 U+00FF)
  0x01, 0x17, 0x01, 0x75, 0x01, // ėŵ (U+0117 U+0175)
  0x01, 0x17, 0x01, 0x77, 0x01, // ėŷ (U+0117 U+0177)
  0x01, 0x17, 0x20, 0x19, 0x01, // ė’ (U+0117 U+2019)
  0x01, 0x17, 0x20, 0x1D, 0x01, // ė” (U+0117 U+201D)
  0x01, 0x19, 0x00, 0x22, 0x01, // ę" (U+0119 U+0022)
  0x01, 0x19, 0x00, 0x27, 0x01, // ę' (U+0119 U+0027)
  0x01, 0x19, 0x00, 0x76, 0x01, // ęv (U+0119 U+0076)
  0x01, 0x19, 0x00, 0x77, 0x01, // ęw (U+0119 U+0077)
  0x01, 0x19, 0x00, 0x78, 0x01, // ęx (U+0119 U+0078)
  0x01, 0x19, 0x00, 0x79, 0x01, // ęy (U+0119 U+0079)
  0x01, 0x19, 0x00, 0xFD, 0x01, // ęý (U+0119 U+00FD)
  0x01, 0x19, 0x00, 0xFF, 0x01, // ęÿ (U+0119 U+00FF)
  0x01, 0x19, 0x01, 0x75, 0x01, // ęŵ (U+0119 U+0175)
  0x01, 0x19, 0x01, 0x77, 0x01, // ęŷ (U+0119 U+0177)
  0x01, 0x19, 0x20, 0x19, 0x01, // ę’ (U+0119 U+2019)
  0x01, 0x19, 0x20, 0x1D, 0x01, // ę” (U+0119 U+201D)
  0x01, 0x1B, 0x00, 0x22, 0x01, // ě" (U+011B U+0022)
  0x01, 0x1B, 0x00, 0x27, 0x01, // ě' (U+011B U+0027)
  0x01, 0x1B, 0x00, 0x76, 0x01, // ěv (U+011B U+0076)
  0x01, 0x1B, 0x00, 0x77, 0x01, // ěw (U+011B U+0077)
  0x01, 0x1B, 0x00, 0x78, 0x01, // ěx (U+011B U+0078)
  0x01, 0x1B, 0x00, 0x79, 0x01, // ěy (U+011B U+0079)
  0x01, 0x1B, 0x00, 0xFD, 0x01, // ěý (U+011B U+00FD)
  0x01, 0x1B, 0x00, 0xFF, 0x01, // ěÿ (U+011B U+00FF)
  0x01, 0x1B, 0x01, 0x75, 0x01, // ěŵ (U+011B U+0175)
  0x01, 0x1B, 0x01, 0x77, 0x01, // ěŷ (U+011B U+0177)
  0x01, 0x1B, 0x20, 0x19, 0x01, // ě’ (U+011B U+2019)
  0x01, 0x1B, 0x20, 0x1D, 0x01, // ě” (U+011B U+201D)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x20, 0x19, 0x01, // ĥ’ (U+0125 U+2019)
  0x01, 0x25, 0x20, 0x1D, 0x01, // ĥ” (U+0125 U+201D)
  0x01, 0x36, 0x00, 0x43, 0x01, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x01, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x01, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x01, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0xAB, 0x01, // Ķ« (U+0136 U+00AB)
  0x01, 0x36, 0x00, 0xC7, 0x01, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x01, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x01, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x01, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x01, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x01, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x01, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x01, 0x06, 0x01, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x08, 0x01, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x0A, 0x01, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0C, 0x01, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x1C, 0x01, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1E, 0x01, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x20, 0x01, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x22, 0x01, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x4C, 0x01, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4E, 0x01, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x50, 0x01, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x52, 0x01, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x20, 0x39, 0x01, // Ķ‹ (U+0136 U+2039)
  0x01, 0x38, 0x00, 0x63, 0x01, // ĸc (U+0138 U+0063)
  0x01, 0x38, 0x00, 0x64, 0x01, // ĸd (U+0138 U+0064)
  0x01, 0x38, 0x00, 0x65, 0x01, // ĸe (U+0138 U+0065)
  0x01, 0x38, 0x00, 0x6F, 0x01, // ĸo (U+0138 U+006F)
  0x01, 0x38, 0x00, 0x71, 0x01, // ĸq (U+0138 U+0071)
  0x01, 0x38, 0x00, 0xE0, 0x01, // ĸà (U+0138 U+00E0)
  0x01, 0x38, 0x00, 0xE7, 0x01, // ĸç (U+0138 U+00E7)
  0x01, 0x38, 0x00, 0xE8, 0x01, // ĸè (U+0138 U+00E8)
  0x01, 0x38, 0x00, 0xE9, 0x01, // ĸé (U+0138 U+00E9)
  0x01, 0x38, 0x00, 0xEA, 0x01, // ĸê (U+0138 U+00EA)
  0x01, 0x38, 0x00, 0xEB, 0x01, // ĸë (U+0138 U+00EB)
  0x01, 0x38, 0x00, 0xF2, 0x01, // ĸò (U+0138 U+00F2)
  0x01, 0x38, 0x00, 0xF3, 0x01, // ĸó (U+0138 U+00F3)
  0x01, 0x38, 0x00, 0xF4, 0x01, // ĸô (U+0138 U+00F4)
  0x01, 0x38, 0x00, 0xF5, 0x01, // ĸõ (U+0138 U+00F5)
  0x01, 0x38, 0x00, 0xF6, 0x01, // ĸö (U+0138 U+00F6)
  0x01, 0x38, 0x00, 0xF8, 0x01, // ĸø (U+0138 U+00F8)
  0x01, 0x38, 0x01, 0x07, 0x01, // ĸć (U+0138 U+0107)
  0x01, 0x38, 0x01, 0x09, 0x01, // ĸĉ (U+0138 U+0109)
  0x01, 0x38, 0x01, 0x0B, 0x01, // ĸċ (U+0138 U+010B)
  0x01, 0x38, 0x01, 0x0D, 0x01, // ĸč (U+0138 U+010D)
  0x01, 0x38, 0x01, 0x0F, 0x01, // ĸď (U+0138 U+010F)
  0x01, 0x38, 0x01, 0x11, 0x01, // ĸđ (U+0138 U+0111)
  0x01, 0x38, 0x01, 0x13, 0x01, // ĸē (U+0138 U+0113)
  0x01, 0x38, 0x01, 0x15, 0x01, // ĸĕ (U+0138 U+0115)
  0x01, 0x38, 0x01, 0x17, 0x01, // ĸė (U+0138 U+0117)
  0x01, 0x38, 0x01, 0x19, 0x01, // ĸę (U+0138 U+0119)
  0x01, 0x38, 0x01, 0x1B, 0x01, // ĸě (U+0138 U+011B)
  0x01, 0x38, 0x01, 0x4D, 0x01, // ĸō (U+0138 U+014D)
  0x01, 0x38, 0x01, 0x4F, 0x01, // ĸŏ (U+0138 U+014F)
  0x01, 0x38, 0x01, 0x51, 0x01, // ĸő (U+0138 U+0151)
  0x01, 0x38, 0x01, 0x53, 0x01, // ĸœ (U+0138 U+0153)
  0x01, 0x39, 0x00, 0x22, 0x05, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x05, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x43, 0x01, // ĹC (U+0139 U+0043)
  0x01, 0x39, 0x00, 0x47, 0x01, // ĹG (U+0139 U+0047)
  0x01, 0x39, 0x00, 0x4F, 0x01, // ĹO (U+0139 U+004F)
  0x01, 0x39, 0x00, 0x51, 0x01, // ĹQ (U+0139 U+0051)
  0x01, 0x39, 0x00, 0x54, 0x03, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x55, 0x01, // ĹU (U+0139 U+0055)
  0x01, 0x39, 0x00, 0x56, 0x03, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x03, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x03, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xC7, 0x01, // ĹÇ (U+0139 U+00C7)
  0x01, 0x39, 0x00, 0xD2, 0x01, // ĹÒ (U+0139 U+00D2)
  0x01, 0x39, 0x00, 0xD3, 0x01, // ĹÓ (U+0139 U+00D3)
  0x01, 0x39, 0x00, 0xD4, 0x01, // ĹÔ (U+0139 U+00D4)
  0x01, 0x39, 0x00, 0xD5, 0x01, // ĹÕ (U+0139 U+00D5)
  0x01, 0x39, 0x00, 0xD6, 0x01, // ĹÖ (U+0139 U+00D6)
  0x01, 0x39, 0x00, 0xD8, 0x01, // ĹØ (U+0139 U+00D8)
  0x01, 0x39, 0x00, 0xD9, 0x01, // ĹÙ (U+0139 U+00D9)
  0x01, 0x39, 0x00, 0xDA, 0x01, // ĹÚ (U+0139 U+00DA)
  0x01, 0x39, 0x00, 0xDB, 0x01, // ĹÛ (U+0139 U+00DB)
  0x01, 0x39, 0x00, 0xDC, 0x01, // ĹÜ (U+0139 U+00DC)
  0x01, 0x39, 0x00, 0xDD, 0x03, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x06, 0x01, // ĹĆ (U+0139 U+0106)
  0x01, 0x39, 0x01, 0x08, 0x01, // ĹĈ (U+0139 U+0108)
  0x01, 0x39, 0x01, 0x0A, 0x01, // ĹĊ (U+0139 U+010A)
  0x01, 0x39, 0x01, 0x0C, 0x01, // ĹČ (U+0139 U+010C)
  0x01, 0x39, 0x01, 0x1C, 0x01, // ĹĜ (U+0139 U+011C)
  0x01, 0x39, 0x01, 0x1E, 0x01, // ĹĞ (U+0139 U+011E)
  0x01, 0x39, 0x01, 0x20, 0x01, // ĹĠ (U+0139 U+0120)
  0x01, 0x39, 0x01, 0x22, 0x01, // ĹĢ (U+0139 U+0122)
  0x01, 0x39, 0x01, 0x4C, 0x01, // ĹŌ (U+0139 U+014C)
  0x01, 0x39, 0x01, 0x4E, 0x01, // ĹŎ (U+0139 U+014E)
  0x01, 0x39, 0x01, 0x50, 0x01, // ĹŐ (U+0139 U+0150)
  0x01, 0x39, 0x01, 0x52, 0x01, // ĹŒ (U+0139 U+0152)
  0x01, 0x39, 0x01, 0x62, 0x03, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x03, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x03, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x68, 0x01, // ĹŨ (U+0139 U+0168)
  0x01, 0x39, 0x01, 0x6A, 0x01, // ĹŪ (U+0139 U+016A)
  0x01, 0x39, 0x01, 0x6C, 0x01, // ĹŬ (U+0139 U+016C)
  0x01, 0x39, 0x01, 0x6E, 0x01, // ĹŮ (U+0139 U+016E)
  0x01, 0x39, 0x01, 0x70, 0x01, // ĹŰ (U+0139 U+0170)
  0x01, 0x39, 0x01, 0x72, 0x01, // ĹŲ (U+0139 U+0172)
  0x01, 0x39, 0x01, 0x74, 0x03, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x03, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x03, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x05, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x05, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x05, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x05, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x43, 0x01, // ĻC (U+013B U+0043)
  0x01, 0x3B, 0x00, 0x47, 0x01, // ĻG (U+013B U+0047)
  0x01, 0x3B, 0x00, 0x4F, 0x01, // ĻO (U+013B U+004F)
  0x01, 0x3B, 0x00, 0x51, 0x01, // ĻQ (U+013B U+0051)
  0x01, 0x3B, 0x00, 0x54, 0x03, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x55, 0x01, // ĻU (U+013B U+0055)
  0x01, 0x3B, 0x00, 0x56, 0x03, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x03, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x03, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xC7, 0x01, // ĻÇ (U+013B U+00C7)
  0x01, 0x3B, 0x00, 0xD2, 0x01, // ĻÒ (U+013B U+00D2)
  0x01, 0x3B, 0x00, 0xD3, 0x01, // ĻÓ (U+013B U+00D3)
  0x01, 0x3B, 0x00, 0xD4, 0x01, // ĻÔ (U+013B U+00D4)
  0x01, 0x3B, 0x00, 0xD5, 0x01, // ĻÕ (U+013B U+00D5)
  0x01, 0x3B, 0x00, 0xD6, 0x01, // ĻÖ (U+013B U+00D6)
  0x01, 0x3B, 0x00, 0xD8, 0x01, // ĻØ (U+013B U+00D8)
  0x01, 0x3B, 0x00, 0xD9, 0x01, // ĻÙ (U+013B U+00D9)
  0x01, 0x3B, 0x00, 0xDA, 0x01, // ĻÚ (U+013B U+00DA)
  0x01, 0x3B, 0x00, 0xDB, 0x01, // ĻÛ (U+013B U+00DB)
  0x01, 0x3B, 0x00, 0xDC, 0x01, // ĻÜ (U+013B U+00DC)
  0x01, 0x3B, 0x00, 0xDD, 0x03, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x06, 0x01, // ĻĆ (U+013B U+0106)
  0x01, 0x3B, 0x01, 0x08, 0x01, // ĻĈ (U+013B U+0108)
  0x01, 0x3B, 0x01, 0x0A, 0x01, // ĻĊ (U+013B U+010A)
  0x01, 0x3B, 0x01, 0x0C, 0x01, // ĻČ (U+013B U+010C)
  0x01, 0x3B, 0x01, 0x1C, 0x01, // ĻĜ (U+013B U+011C)
  0x01, 0x3B, 0x01, 0x1E, 0x01, // ĻĞ (U+013B U+011E)
  0x01, 0x3B, 0x01, 0x20, 0x01, // ĻĠ (U+013B U+0120)
  0x01, 0x3B, 0x01, 0x22, 0x01, // ĻĢ (U+013B U+0122)
  0x01, 0x3B, 0x01, 0x4C, 0x01, // ĻŌ (U+013B U+014C)
  0x01, 0x3B, 0x01, 0x4E, 0x01, // ĻŎ (U+013B U+014E)
  0x01, 0x3B, 0x01, 0x50, 0x01, // ĻŐ (U+013B U+0150)
  0x01, 0x3B, 0x01, 0x52, 0x01, // ĻŒ (U+013B U+0152)
  0x01, 0x3B, 0x01, 0x62, 0x03, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x03, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x03, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x68, 0x01, // ĻŨ (U+013B U+0168)
  0x01, 0x3B, 0x01, 0x6A, 0x01, // ĻŪ (U+013B U+016A)
  0x01, 0x3B, 0x01, 0x6C, 0x01, // ĻŬ (U+013B U+016C)
  0x01, 0x3B, 0x01, 0x6E, 0x01, // ĻŮ (U+013B U+016E)
  0x01, 0x3B, 0x01, 0x70, 0x01, // ĻŰ (U+013B U+0170)
  0x01, 0x3B, 0x01, 0x72, 0x01, // ĻŲ (U+013B U+0172)
  0x01, 0x3B, 0x01, 0x74, 0x03, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x03, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x03, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x05, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x05, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x05, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x05, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x43, 0x01, // ĽC (U+013D U+0043)
  0x01, 0x3D, 0x00, 0x47, 0x01, // ĽG (U+013D U+0047)
  0x01, 0x3D, 0x00, 0x4F, 0x01, // ĽO (U+013D U+004F)
  0x01, 0x3D, 0x00, 0x51, 0x01, // ĽQ (U+013D U+0051)
  0x01, 0x3D, 0x00, 0x54, 0x03, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x55, 0x01, // ĽU (U+013D U+0055)
  0x01, 0x3D, 0x00, 0x56, 0x03, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x03, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x03, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xC7, 0x01, // ĽÇ (U+013D U+00C7)
  0x01, 0x3D, 0x00, 0xD2, 0x01, // ĽÒ (U+013D U+00D2)
  0x01, 0x3D, 0x00, 0xD3, 0x01, // ĽÓ (U+013D U+00D3)
  0x01, 0x3D, 0x00, 0xD4, 0x01, // ĽÔ (U+013D U+00D4)
  0x01, 0x3D, 0x00, 0xD5, 0x01, // ĽÕ (U+013D U+00D5)
  0x01, 0x3D, 0x00, 0xD6, 0x01, // ĽÖ (U+013D U+00D6)
  0x01, 0x3D, 0x00, 0xD8, 0x01, // ĽØ (U+013D U+00D8)
  0x01, 0x3D, 0x00, 0xD9, 0x01, // ĽÙ (U+013D U+00D9)
  0x01, 0x3D, 0x00, 0xDA, 0x01, // ĽÚ (U+013D U+00DA)
  0x01, 0x3D, 0x00, 0xDB, 0x01, // ĽÛ (U+013D U+00DB)
  0x01, 0x3D, 0x00, 0xDC, 0x01, // ĽÜ (U+013D U+00DC)
  0x01, 0x3D, 0x00, 0xDD, 0x03, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x06, 0x01, // ĽĆ (U+013D U+0106)
  0x01, 0x3D, 0x01, 0x08, 0x01, // ĽĈ (U+013D U+0108)
  0x01, 0x3D, 0x01, 0x0A, 0x01, // ĽĊ (U+013D U+010A)
  0x01, 0x3D, 0x01, 0x0C, 0x01, // ĽČ (U+013D U+010C)
  0x01, 0x3D, 0x01, 0x1C, 0x01, // ĽĜ (U+013D U+011C)
  0x01, 0x3D, 0x01, 0x1E, 0x01, // ĽĞ (U+013D U+011E)
  0x01, 0x3D, 0x01, 0x20, 0x01, // ĽĠ (U+013D U+0120)
  0x01, 0x3D, 0x01, 0x22, 0x01, // ĽĢ (U+013D U+0122)
  0x01, 0x3D, 0x01, 0x4C, 0x01, // ĽŌ (U+013D U+014C)
  0x01, 0x3D, 0x01, 0x4E, 0x01, // ĽŎ (U+013D U+014E)
  0x01, 0x3D, 0x01, 0x50, 0x01, // ĽŐ (U+013D U+0150)
  0x01, 0x3D, 0x01, 0x52, 0x01, // ĽŒ (U+013D U+0152)
  0x01, 0x3D, 0x01, 0x62, 0x03, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x03, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x03, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x68, 0x01, // ĽŨ (U+013D U+0168)
  0x01, 0x3D, 0x01, 0x6A, 0x01, // ĽŪ (U+013D U+016A)
  0x01, 0x3D, 0x01, 0x6C, 0x01, // ĽŬ (U+013D U+016C)
  0x01, 0x3D, 0x01, 0x6E, 0x01, // ĽŮ (U+013D U+016E)
  0x01, 0x3D, 0x01, 0x70, 0x01, // ĽŰ (U+013D U+0170)
  0x01, 0x3D, 0x01, 0x72, 0x01, // ĽŲ (U+013D U+0172)
  0x01, 0x3D, 0x01, 0x74, 0x03, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x03, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x03, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x05, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x05, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x05, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x05, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x43, 0x01, // ĿC (U+013F U+0043)
  0x01, 0x3F, 0x00, 0x47, 0x01, // ĿG (U+013F U+0047)
  0x01, 0x3F, 0x00, 0x4F, 0x01, // ĿO (U+013F U+004F)
  0x01, 0x3F, 0x00, 0x51, 0x01, // ĿQ (U+013F U+0051)
  0x01, 0x3F, 0x00, 0x54, 0x03, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x55, 0x01, // ĿU (U+013F U+0055)
  0x01, 0x3F, 0x00, 0x56, 0x03, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x03, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x03, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xC7, 0x01, // ĿÇ (U+013F U+00C7)
  0x01, 0x3F, 0x00, 0xD2, 0x01, // ĿÒ (U+013F U+00D2)
  0x01, 0x3F, 0x00, 0xD3, 0x01, // ĿÓ (U+013F U+00D3)
  0x01, 0x3F, 0x00, 0xD4, 0x01, // ĿÔ (U+013F U+00D4)
  0x01, 0x3F, 0x00, 0xD5, 0x01, // ĿÕ (U+013F U+00D5)
  0x01, 0x3F, 0x00, 0xD6, 0x01, // ĿÖ (U+013F U+00D6)
  0x01, 0x3F, 0x00, 0xD8, 0x01, // ĿØ (U+013F U+00D8)
  0x01, 0x3F, 0x00, 0xD9, 0x01, // ĿÙ (U+013F U+00D9)
  0x01, 0x3F, 0x00, 0xDA, 0x01, // ĿÚ (U+013F U+00DA)
  0x01, 0x3F, 0x00, 0xDB, 0x01, // ĿÛ (U+013F U+00DB)
  0x01, 0x3F, 0x00, 0xDC, 0x01, // ĿÜ (U+013F U+00DC)
  0x01, 0x3F, 0x00, 0xDD, 0x03, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x06, 0x01, // ĿĆ (U+013F U+0106)
  0x01, 0x3F, 0x01, 0x08, 0x01, // ĿĈ (U+013F U+0108)
  0x01, 0x3F, 0x01, 0x0A, 0x01, // ĿĊ (U+013F U+010A)
  0x01, 0x3F, 0x01, 0x0C, 0x01, // ĿČ (U+013F U+010C)
  0x01, 0x3F, 0x01, 0x1C, 0x01, // ĿĜ (U+013F U+011C)
  0x01, 0x3F, 0x01, 0x1E, 0x01, // ĿĞ (U+013F U+011E)
  0x01, 0x3F, 0x01, 0x20, 0x01, // ĿĠ (U+013F U+0120)
  0x01, 0x3F, 0x01, 0x22, 0x01, // ĿĢ (U+013F U+0122)
  0x01, 0x3F, 0x01, 0x4C, 0x01, // ĿŌ (U+013F U+014C)
  0x01, 0x3F, 0x01, 0x4E, 0x01, // ĿŎ (U+013F U+014E)
  0x01, 0x3F, 0x01, 0x50, 0x01, // ĿŐ (U+013F U+0150)
  0x01, 0x3F, 0x01, 0x52, 0x01, // ĿŒ (U+013F U+0152)
  0x01, 0x3F, 0x01, 0x62, 0x03, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x03, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x03, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x68, 0x01, // ĿŨ (U+013F U+0168)
  0x01, 0x3F, 0x01, 0x6A, 0x01, // ĿŪ (U+013F U+016A)
  0x01, 0x3F, 0x01, 0x6C, 0x01, // ĿŬ (U+013F U+016C)
  0x01, 0x3F, 0x01, 0x6E, 0x01, // ĿŮ (U+013F U+016E)
  0x01, 0x3F, 0x01, 0x70, 0x01, // ĿŰ (U+013F U+0170)
  0x01, 0x3F, 0x01, 0x72, 0x01, // ĿŲ (U+013F U+0172)
  0x01, 0x3F, 0x01, 0x74, 0x03, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x03, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x03, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x05, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x05, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x05, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x05, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x43, 0x01, // ŁC (U+0141 U+0043)
  0x01, 0x41, 0x00, 0x47, 0x01, // ŁG (U+0141 U+0047)
  0x01, 0x41, 0x00, 0x4F, 0x01, // ŁO (U+0141 U+004F)
  0x01, 0x41, 0x00, 0x51, 0x01, // ŁQ (U+0141 U+0051)
  0x01, 0x41, 0x00, 0x54, 0x03, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x55, 0x01, // ŁU (U+0141 U+0055)
  0x01, 0x41, 0x00, 0x56, 0x03, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x03, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x03, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xC7, 0x01, // ŁÇ (U+0141 U+00C7)
  0x01, 0x41, 0x00, 0xD2, 0x01, // ŁÒ (U+0141 U+00D2)
  0x01, 0x41, 0x00, 0xD3, 0x01, // ŁÓ (U+0141 U+00D3)
  0x01, 0x41, 0x00, 0xD4, 0x01, // ŁÔ (U+0141 U+00D4)
  0x01, 0x41, 0x00, 0xD5, 0x01, // ŁÕ (U+0141 U+00D5)
  0x01, 0x41, 0x00, 0xD6, 0x01, // ŁÖ (U+0141 U+00D6)
  0x01, 0x41, 0x00, 0xD8, 0x01, // ŁØ (U+0141 U+00D8)
  0x01, 0x41, 0x00, 0xD9, 0x01, // ŁÙ (U+0141 U+00D9)
  0x01, 0x41, 0x00, 0xDA, 0x01, // ŁÚ (U+0141 U+00DA)
  0x01, 0x41, 0x00, 0xDB, 0x01, // ŁÛ (U+0141 U+00DB)
  0x01, 0x41, 0x00, 0xDC, 0x01, // ŁÜ (U+0141 U+00DC)
  0x01, 0x41, 0x00, 0xDD, 0x03, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x06, 0x01, // ŁĆ (U+0141 U+0106)
  0x01, 0x41, 0x01, 0x08, 0x01, // ŁĈ (U+0141 U+0108)
  0x01, 0x41, 0x01, 0x0A, 0x01, // ŁĊ (U+0141 U+010A)
  0x01, 0x41, 0x01, 0x0C, 0x01, // ŁČ (U+0141 U+010C)
  0x01, 0x41, 0x01, 0x1C, 0x01, // ŁĜ (U+0141 U+011C)
  0x01, 0x41, 0x01, 0x1E, 0x01, // ŁĞ (U+0141 U+011E)
  0x01, 0x41, 0x01, 0x20, 0x01, // ŁĠ (U+0141 U+0120)
  0x01, 0x41, 0x01, 0x22, 0x01, // ŁĢ (U+0141 U+0122)
  0x01, 0x41, 0x01, 0x4C, 0x01, // ŁŌ (U+0141 U+014C)
  0x01, 0x41, 0x01, 0x4E, 0x01, // ŁŎ (U+0141 U+014E)
  0x01, 0x41, 0x01, 0x50, 0x01, // ŁŐ (U+0141 U+0150)
  0x01, 0x41, 0x01, 0x52, 0x01, // ŁŒ (U+0141 U+0152)
  0x01, 0x41, 0x01, 0x62, 0x03, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x03, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x03, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x68, 0x01, // ŁŨ (U+0141 U+0168)
  0x01, 0x41, 0x01, 0x6A, 0x01, // ŁŪ (U+0141 U+016A)
  0x01, 0x41, 0x01, 0x6C, 0x01, // ŁŬ (U+0141 U+016C)
  0x01, 0x41, 0x01, 0x6E, 0x01, // ŁŮ (U+0141 U+016E)
  0x01, 0x41, 0x01, 0x70, 0x01, // ŁŰ (U+0141 U+0170)
  0x01, 0x41, 0x01, 0x72, 0x01, // ŁŲ (U+0141 U+0172)
  0x01, 0x41, 0x01, 0x74, 0x03, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x03, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x03, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x05, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x05, // Ł” (U+0141 U+201D)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x20, 0x19, 0x01, // ń’ (U+0144 U+2019)
  0x01, 0x44, 0x20, 0x1D, 0x01, // ń” (U+0144 U+201D)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x20, 0x19, 0x01, // ņ’ (U+0146 U+2019)
  0x01, 0x46, 0x20, 0x1D, 0x01, // ņ” (U+0146 U+201D)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x20, 0x19, 0x01, // ŉ’ (U+0149 U+2019)
  0x01, 0x49, 0x20, 0x1D, 0x01, // ŉ” (U+0149 U+201D)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x20, 0x19, 0x01, // ŋ’ (U+014B U+2019)
  0x01, 0x4B, 0x20, 0x1D, 0x01, // ŋ” (U+014B U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x03, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x03, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x41, 0x01, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x58, 0x01, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC0, 0x01, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x01, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x01, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x01, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x01, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x01, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x01, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x01, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x01, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x20, 0x1A, 0x03, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x03, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x03, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x22, 0x01, // ō" (U+014D U+0022)
  0x01, 0x4D, 0x00, 0x27, 0x01, // ō' (U+014D U+0027)
  0x01, 0x4D, 0x00, 0x76, 0x01, // ōv (U+014D U+0076)
  0x01, 0x4D, 0x00, 0x77, 0x01, // ōw (U+014D U+0077)
  0x01, 0x4D, 0x00, 0x78, 0x01, // ōx (U+014D U+0078)
  0x01, 0x4D, 0x00, 0x79, 0x01, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xFD, 0x01, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x01, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x75, 0x01, // ōŵ (U+014D U+0175)
  0x01, 0x4D, 0x01, 0x77, 0x01, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x20, 0x19, 0x01, // ō’ (U+014D U+2019)
  0x01, 0x4D, 0x20, 0x1D, 0x01, // ō” (U+014D U+201D)
  0x01, 0x4E, 0x00, 0x2C, 0x03, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x03, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x41, 0x01, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x58, 0x01, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC0, 0x01, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x01, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x01, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x01, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x01, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x01, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x01, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x01, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x01, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x20, 0x1A, 0x03, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x03, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x03, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x22, 0x01, // ŏ" (U+014F U+0022)
  0x01, 0x4F, 0x00, 0x27, 0x01, // ŏ' (U+014F U+0027)
  0x01, 0x4F, 0x00, 0x76, 0x01, // ŏv (U+014F U+0076)
  0x01, 0x4F, 0x00, 0x77, 0x01, // ŏw (U+014F U+0077)
  0x01, 0x4F, 0x00, 0x78, 0x01, // ŏx (U+014F U+0078)
  0x01, 0x4F, 0x00, 0x79, 0x01, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xFD, 0x01, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x01, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x75, 0x01, // ŏŵ (U+014F U+0175)
  0x01, 0x4F, 0x01, 0x77, 0x01, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x20, 0x19, 0x01, // ŏ’ (U+014F U+2019)
  0x01, 0x4F, 0x20, 0x1D, 0x01, // ŏ” (U+014F U+201D)
  0x01, 0x50, 0x00, 0x2C, 0x03, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x03, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x41, 0x01, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x58, 0x01, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC0, 0x01, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x01, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x01, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x01, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x01, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x01, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x01, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x01, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x01, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x20, 0x1A, 0x03, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x03, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x03, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x22, 0x01, // ő" (U+0151 U+0022)
  0x01, 0x51, 0x00, 0x27, 0x01, // ő' (U+0151 U+0027)
  0x01, 0x51, 0x00, 0x76, 0x01, // őv (U+0151 U+0076)
  0x01, 0x51, 0x00, 0x77, 0x01, // őw (U+0151 U+0077)
  0x01, 0x51, 0x00, 0x78, 0x01, // őx (U+0151 U+0078)
  0x01, 0x51, 0x00, 0x79, 0x01, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xFD, 0x01, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x01, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x75, 0x01, // őŵ (U+0151 U+0175)
  0x01, 0x51, 0x01, 0x77, 0x01, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x20, 0x19, 0x01, // ő’ (U+0151 U+2019)
  0x01, 0x51, 0x20, 0x1D, 0x01, // ő” (U+0151 U+201D)
  0x01, 0x53, 0x00, 0x22, 0x01, // œ" (U+0153 U+0022)
  0x01, 0x53, 0x00, 0x27, 0x01, // œ' (U+0153 U+0027)
  0x01, 0x53, 0x00, 0x76, 0x01, // œv (U+0153 U+0076)
  0x01, 0x53, 0x00, 0x77, 0x01, // œw (U+0153 U+0077)
  0x01, 0x53, 0x00, 0x78, 0x01, // œx (U+0153 U+0078)
  0x01, 0x53, 0x00, 0x79, 0x01, // œy (U+0153 U+0079)
  0x01, 0x53, 0x00, 0xFD, 0x01, // œý (U+0153 U+00FD)
  0x01, 0x53, 0x00, 0xFF, 0x01, // œÿ (U+0153 U+00FF)
  0x01, 0x53, 0x01, 0x75, 0x01, // œŵ (U+0153 U+0175)
  0x01, 0x53, 0x01, 0x77, 0x01, // œŷ (U+0153 U+0177)
  0x01, 0x53, 0x20, 0x19, 0x01, // œ’ (U+0153 U+2019)
  0x01, 0x53, 0x20, 0x1D, 0x01, // œ” (U+0153 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x05, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x05, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x61, 0x01, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0x63, 0x01, // ŕc (U+0155 U+0063)
  0x01, 0x55, 0x00, 0x64, 0x01, // ŕd (U+0155 U+0064)
  0x01, 0x55, 0x00, 0x65, 0x01, // ŕe (U+0155 U+0065)
  0x01, 0x55, 0x00, 0x67, 0x01, // ŕg (U+0155 U+0067)
  0x01, 0x55, 0x00, 0x6F, 0x01, // ŕo (U+0155 U+006F)
  0x01, 0x55, 0x00, 0x71, 0x01, // ŕq (U+0155 U+0071)
  0x01, 0x55, 0x00, 0xE0, 0x01, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x01, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x01, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x01, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x01, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x01, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x01, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x00, 0xE7, 0x01, // ŕç (U+0155 U+00E7)
  0x01, 0x55, 0x00, 0xE8, 0x01, // ŕè (U+0155 U+00E8)
  0x01, 0x55, 0x00, 0xE9, 0x01, // ŕé (U+0155 U+00E9)
  0x01, 0x55, 0x00, 0xEA, 0x01, // ŕê (U+0155 U+00EA)
  0x01, 0x55, 0x00, 0xEB, 0x01, // ŕë (U+0155 U+00EB)
  0x01, 0x55, 0x00, 0xF2, 0x01, // ŕò (U+0155 U+00F2)
  0x01, 0x55, 0x00, 0xF3, 0x01, // ŕó (U+0155 U+00F3)
  0x01, 0x55, 0x00, 0xF4, 0x01, // ŕô (U+0155 U+00F4)
  0x01, 0x55, 0x00, 0xF5, 0x01, // ŕõ (U+0155 U+00F5)
  0x01, 0x55, 0x00, 0xF6, 0x01, // ŕö (U+0155 U+00F6)
  0x01, 0x55, 0x00, 0xF8, 0x01, // ŕø (U+0155 U+00F8)
  0x01, 0x55, 0x01, 0x01, 0x01, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x03, 0x01, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x05, 0x01, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x01, 0x07, 0x01, // ŕć (U+0155 U+0107)
  0x01, 0x55, 0x01, 0x09, 0x01, // ŕĉ (U+0155 U+0109)
  0x01, 0x55, 0x01, 0x0B, 0x01, // ŕċ (U+0155 U+010B)
  0x01, 0x55, 0x01, 0x0D, 0x01, // ŕč (U+0155 U+010D)
  0x01, 0x55, 0x01, 0x0F, 0x01, // ŕď (U+0155 U+010F)
  0x01, 0x55, 0x01, 0x11, 0x01, // ŕđ (U+0155 U+0111)
  0x01, 0x55, 0x01, 0x13, 0x01, // ŕē (U+0155 U+0113)
  0x01, 0x55, 0x01, 0x15, 0x01, // ŕĕ (U+0155 U+0115)
  0x01, 0x55, 0x01, 0x17, 0x01, // ŕė (U+0155 U+0117)
  0x01, 0x55, 0x01, 0x19, 0x01, // ŕę (U+0155 U+0119)
  0x01, 0x55, 0x01, 0x1B, 0x01, // ŕě (U+0155 U+011B)
  0x01, 0x55, 0x01, 0x1D, 0x01, // ŕĝ (U+0155 U+011D)
  0x01, 0x55, 0x01, 0x1F, 0x01, // ŕğ (U+0155 U+011F)
  0x01, 0x55, 0x01, 0x21, 0x01, // ŕġ (U+0155 U+0121)
  0x01, 0x55, 0x01, 0x23, 0x01, // ŕģ (U+0155 U+0123)
  0x01, 0x55, 0x01, 0x4D, 0x01, // ŕō (U+0155 U+014D)
  0x01, 0x55, 0x01, 0x4F, 0x01, // ŕŏ (U+0155 U+014F)
  0x01, 0x55, 0x01, 0x51, 0x01, // ŕő (U+0155 U+0151)
  0x01, 0x55, 0x01, 0x53, 0x01, // ŕœ (U+0155 U+0153)
  0x01, 0x55, 0x20, 0x1A, 0x05, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x05, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x05, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x05, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x05, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x61, 0x01, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0x63, 0x01, // ŗc (U+0157 U+0063)
  0x01, 0x57, 0x00, 0x64, 0x01, // ŗd (U+0157 U+0064)
  0x01, 0x57, 0x00, 0x65, 0x01, // ŗe (U+0157 U+0065)
  0x01, 0x57, 0x00, 0x67, 0x01, // ŗg (U+0157 U+0067)
  0x01, 0x57, 0x00, 0x6F, 0x01, // ŗo (U+0157 U+006F)
  0x01, 0x57, 0x00, 0x71, 0x01, // ŗq (U+0157 U+0071)
  0x01, 0x57, 0x00, 0xE0, 0x01, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x01, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x01, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x01, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x01, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x01, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x01, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x00, 0xE7, 0x01, // ŗç (U+0157 U+00E7)
  0x01, 0x57, 0x00, 0xE8, 0x01, // ŗè (U+0157 U+00E8)
  0x01, 0x57, 0x00, 0xE9, 0x01, // ŗé (U+0157 U+00E9)
  0x01, 0x57, 0x00, 0xEA, 0x01, // ŗê (U+0157 U+00EA)
  0x01, 0x57, 0x00, 0xEB, 0x01, // ŗë (U+0157 U+00EB)
  0x01, 0x57, 0x00, 0xF2, 0x01, // ŗò (U+0157 U+00F2)
  0x01, 0x57, 0x00, 0xF3, 0x01, // ŗó (U+0157 U+00F3)
  0x01, 0x57, 0x00, 0xF4, 0x01, // ŗô (U+0157 U+00F4)
  0x01, 0x57, 0x00, 0xF5, 0x01, // ŗõ (U+0157 U+00F5)
  0x01, 0x57, 0x00, 0xF6, 0x01, // ŗö (U+0157 U+00F6)
  0x01, 0x57, 0x00, 0xF8, 0x01, // ŗø (U+0157 U+00F8)
  0x01, 0x57, 0x01, 0x01, 0x01, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x03, 0x01, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x05, 0x01, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x01, 0x07, 0x01, // ŗć (U+0157 U+0107)
  0x01, 0x57, 0x01, 0x09, 0x01, // ŗĉ (U+0157 U+0109)
  0x01, 0x57, 0x01, 0x0B, 0x01, // ŗċ (U+0157 U+010B)
  0x01, 0x57, 0x01, 0x0D, 0x01, // ŗč (U+0157 U+010D)
  0x01, 0x57, 0x01, 0x0F, 0x01, // ŗď (U+0157 U+010F)
  0x01, 0x57, 0x01, 0x11, 0x01, // ŗđ (U+0157 U+0111)
  0x01, 0x57, 0x01, 0x13, 0x01, // ŗē (U+0157 U+0113)
  0x01, 0x57, 0x01, 0x15, 0x01, // ŗĕ (U+0157 U+0115)
  0x01, 0x57, 0x01, 0x17, 0x01, // ŗė (U+0157 U+0117)
  0x01, 0x57, 0x01, 0x19, 0x01, // ŗę (U+0157 U+0119)
  0x01, 0x57, 0x01, 0x1B, 0x01, // ŗě (U+0157 U+011B)
  0x01, 0x57, 0x01, 0x1D, 0x01, // ŗĝ (U+0157 U+011D)
  0x01, 0x57, 0x01, 0x1F, 0x01, // ŗğ (U+0157 U+011F)
  0x01, 0x57, 0x01, 0x21, 0x01, // ŗġ (U+0157 U+0121)
  0x01, 0x57, 0x01, 0x23, 0x01, // ŗģ (U+0157 U+0123)
  0x01, 0x57, 0x01, 0x4D, 0x01, // ŗō (U+0157 U+014D)
  0x01, 0x57, 0x01, 0x4F, 0x01, // ŗŏ (U+0157 U+014F)
  0x01, 0x57, 0x01, 0x51, 0x01, // ŗő (U+0157 U+0151)
  0x01, 0x57, 0x01, 0x53, 0x01, // ŗœ (U+0157 U+0153)
  0x01, 0x57, 0x20, 0x1A, 0x05, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x05, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x05, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x05, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x05, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x61, 0x01, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0x63, 0x01, // řc (U+0159 U+0063)
  0x01, 0x59, 0x00, 0x64, 0x01, // řd (U+0159 U+0064)
  0x01, 0x59, 0x00, 0x65, 0x01, // ře (U+0159 U+0065)
  0x01, 0x59, 0x00, 0x67, 0x01, // řg (U+0159 U+0067)
  0x01, 0x59, 0x00, 0x6F, 0x01, // řo (U+0159 U+006F)
  0x01, 0x59, 0x00, 0x71, 0x01, // řq (U+0159 U+0071)
  0x01, 0x59, 0x00, 0xE0, 0x01, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x01, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x01, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x01, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x01, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x01, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x01, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x00, 0xE7, 0x01, // řç (U+0159 U+00E7)
  0x01, 0x59, 0x00, 0xE8, 0x01, // řè (U+0159 U+00E8)
  0x01, 0x59, 0x00, 0xE9, 0x01, // řé (U+0159 U+00E9)
  0x01, 0x59, 0x00, 0xEA, 0x01, // řê (U+0159 U+00EA)
  0x01, 0x59, 0x00, 0xEB, 0x01, // řë (U+0159 U+00EB)
  0x01, 0x59, 0x00, 0xF2, 0x01, // řò (U+0159 U+00F2)
  0x01, 0x59, 0x00, 0xF3, 0x01, // řó (U+0159 U+00F3)
  0x01, 0x59, 0x00, 0xF4, 0x01, // řô (U+0159 U+00F4)
  0x01, 0x59, 0x00, 0xF5, 0x01, // řõ (U+0159 U+00F5)
  0x01, 0x59, 0x00, 0xF6, 0x01, // řö (U+0159 U+00F6)
  0x01, 0x59, 0x00, 0xF8, 0x01, // řø (U+0159 U+00F8)
  0x01, 0x59, 0x01, 0x01, 0x01, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x03, 0x01, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x05, 0x01, // řą (U+0159 U+0105)
  0x01, 0x59, 0x01, 0x07, 0x01, // řć (U+0159 U+0107)
  0x01, 0x59, 0x01, 0x09, 0x01, // řĉ (U+0159 U+0109)
  0x01, 0x59, 0x01, 0x0B, 0x01, // řċ (U+0159 U+010B)
  0x01, 0x59, 0x01, 0x0D, 0x01, // řč (U+0159 U+010D)
  0x01, 0x59, 0x01, 0x0F, 0x01, // řď (U+0159 U+010F)
  0x01, 0x59, 0x01, 0x11, 0x01, // řđ (U+0159 U+0111)
  0x01, 0x59, 0x01, 0x13, 0x01, // řē (U+0159 U+0113)
  0x01, 0x59, 0x01, 0x15, 0x01, // řĕ (U+0159 U+0115)
  0x01, 0x59, 0x01, 0x17, 0x01, // řė (U+0159 U+0117)
  0x01, 0x59, 0x01, 0x19, 0x01, // řę (U+0159 U+0119)
  0x01, 0x59, 0x01, 0x1B, 0x01, // řě (U+0159 U+011B)
  0x01, 0x59, 0x01, 0x1D, 0x01, // řĝ (U+0159 U+011D)
  0x01, 0x59, 0x01, 0x1F, 0x01, // řğ (U+0159 U+011F)
  0x01, 0x59, 0x01, 0x21, 0x01, // řġ (U+0159 U+0121)
  0x01, 0x59, 0x01, 0x23, 0x01, // řģ (U+0159 U+0123)
  0x01, 0x59, 0x01, 0x4D, 0x01, // řō (U+0159 U+014D)
  0x01, 0x59, 0x01, 0x4F, 0x01, // řŏ (U+0159 U+014F)
  0x01, 0x59, 0x01, 0x51, 0x01, // řő (U+0159 U+0151)
  0x01, 0x59, 0x01, 0x53, 0x01, // řœ (U+0159 U+0153)
  0x01, 0x59, 0x20, 0x1A, 0x05, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x05, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x05, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x04, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x03, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x04, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x03, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x01, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x01, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x01, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x01, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x05, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x05, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x05, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x05, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x05, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x03, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x03, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x05, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x03, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x05, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x03, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x04, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x03, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x76, 0x01, // Ţv (U+0162 U+0076)
  0x01, 0x62, 0x00, 0x77, 0x01, // Ţw (U+0162 U+0077)
  0x01, 0x62, 0x00, 0x78, 0x01, // Ţx (U+0162 U+0078)
  0x01, 0x62, 0x00, 0x79, 0x01, // Ţy (U+0162 U+0079)
  0x01, 0x62, 0x00, 0x7A, 0x03, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x04, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x02, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x03, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x03, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x03, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x03, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x03, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x03, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC7, 0x01, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x01, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x01, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x01, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x01, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x01, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x01, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x05, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x05, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x05, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x05, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x05, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x05, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x05, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x05, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x05, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x05, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x05, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x05, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x05, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x05, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x05, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x05, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x05, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x05, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x03, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x03, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x03, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x03, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x00, 0xFD, 0x01, // Ţý (U+0162 U+00FD)
  0x01, 0x62, 0x00, 0xFF, 0x01, // Ţÿ (U+0162 U+00FF)
  0x01, 0x62, 0x01, 0x00, 0x03, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x05, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x03, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x05, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x03, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x05, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x01, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x05, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x01, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x05, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x01, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x05, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x01, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x05, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x05, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x05, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x05, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x05, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x05, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x05, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x05, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x01, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x05, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x01, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x05, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x01, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x05, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x01, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x05, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x03, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x03, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x03, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x03, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4C, 0x01, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x05, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x01, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x05, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x01, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x05, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x01, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x05, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x03, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x03, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x04, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x04, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x03, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x03, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x03, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x03, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x03, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x03, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x75, 0x01, // Ţŵ (U+0162 U+0175)
  0x01, 0x62, 0x01, 0x77, 0x01, // Ţŷ (U+0162 U+0177)
  0x01, 0x62, 0x01, 0x7A, 0x03, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x03, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x03, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x03, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x03, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x04, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x04, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x04, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x04, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x02, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x04, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x03, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x04, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x03, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x01, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x01, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x01, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x01, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x05, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x05, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x05, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x05, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x05, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x03, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x03, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x05, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x03, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x05, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x03, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x04, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x03, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x76, 0x01, // Ťv (U+0164 U+0076)
  0x01, 0x64, 0x00, 0x77, 0x01, // Ťw (U+0164 U+0077)
  0x01, 0x64, 0x00, 0x78, 0x01, // Ťx (U+0164 U+0078)
  0x01, 0x64, 0x00, 0x79, 0x01, // Ťy (U+0164 U+0079)
  0x01, 0x64, 0x00, 0x7A, 0x03, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x04, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x02, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x03, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x03, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x03, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x03, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x03, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x03, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC7, 0x01, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x01, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x01, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x01, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x01, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x01, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x01, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x05, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x05, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x05, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x05, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x05, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x05, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x05, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x05, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x05, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x05, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x05, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x05, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x05, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x05, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x05, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x05, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x05, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x05, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x03, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x03, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x03, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x03, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x00, 0xFD, 0x01, // Ťý (U+0164 U+00FD)
  0x01, 0x64, 0x00, 0xFF, 0x01, // Ťÿ (U+0164 U+00FF)
  0x01, 0x64, 0x01, 0x00, 0x03, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x05, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x03, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x05, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x03, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x05, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x01, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x05, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x01, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x05, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x01, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x05, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x01, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x05, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x05, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x05, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x05, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x05, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x05, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x05, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x05, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x01, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x05, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x01, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x05, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x01, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x05, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x01, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x05, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x03, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x03, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x03, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x03, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4C, 0x01, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x05, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x01, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x05, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x01, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x05, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x01, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x05, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x03, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x03, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x04, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x04, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x03, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x03, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x03, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x03, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x03, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x03, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x75, 0x01, // Ťŵ (U+0164 U+0175)
  0x01, 0x64, 0x01, 0x77, 0x01, // Ťŷ (U+0164 U+0177)
  0x01, 0x64, 0x01, 0x7A, 0x03, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x03, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x03, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x03, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x03, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x04, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x04, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x04, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x04, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x02, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x04, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x03, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x04, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x03, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x01, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x01, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x01, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x01, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x05, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x05, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x05, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x05, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x05, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x03, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x03, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x05, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x03, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x05, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x03, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x04, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x03, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x76, 0x01, // Ŧv (U+0166 U+0076)
  0x01, 0x66, 0x00, 0x77, 0x01, // Ŧw (U+0166 U+0077)
  0x01, 0x66, 0x00, 0x78, 0x01, // Ŧx (U+0166 U+0078)
  0x01, 0x66, 0x00, 0x79, 0x01, // Ŧy (U+0166 U+0079)
  0x01, 0x66, 0x00, 0x7A, 0x03, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x04, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x02, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x03, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x03, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x03, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x03, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x03, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x03, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC7, 0x01, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x01, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x01, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x01, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x01, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x01, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x01, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x05, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x05, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x05, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x05, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x05, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x05, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x05, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x05, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x05, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x05, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x05, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x05, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x05, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x05, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x05, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x05, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x05, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x05, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x03, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x03, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x03, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x03, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x00, 0xFD, 0x01, // Ŧý (U+0166 U+00FD)
  0x01, 0x66, 0x00, 0xFF, 0x01, // Ŧÿ (U+0166 U+00FF)
  0x01, 0x66, 0x01, 0x00, 0x03, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x05, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x03, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x05, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x03, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x05, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x01, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x05, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x01, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x05, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x01, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x05, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x01, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x05, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x05, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x05, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x05, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x05, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x05, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x05, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x05, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x01, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x05, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x01, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x05, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x01, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x05, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x01, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x05, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x03, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x03, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x03, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x03, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4C, 0x01, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x05, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x01, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x05, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x01, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x05, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x01, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x05, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x03, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x03, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x04, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x04, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x03, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x03, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x03, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x03, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x03, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x03, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x75, 0x01, // Ŧŵ (U+0166 U+0175)
  0x01, 0x66, 0x01, 0x77, 0x01, // Ŧŷ (U+0166 U+0177)
  0x01, 0x66, 0x01, 0x7A, 0x03, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x03, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x03, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x03, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x03, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x04, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x04, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x04, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x04, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x02, // Ŧ› (U+0166 U+203A)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x41, 0x01, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x01, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x01, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x01, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x01, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x01, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x01, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x01, 0x00, 0x01, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x01, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x01, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x41, 0x01, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x01, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x01, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x01, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x01, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x01, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x01, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x01, 0x00, 0x01, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x01, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x01, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x41, 0x01, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x01, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x01, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x01, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x01, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x01, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x01, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x01, 0x00, 0x01, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x01, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x01, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x41, 0x01, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x01, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x01, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x01, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x01, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x01, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x01, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x01, 0x00, 0x01, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x01, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x01, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x41, 0x01, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x01, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x01, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x01, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x01, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x01, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x01, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x01, 0x00, 0x01, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x01, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x01, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x41, 0x01, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x01, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x01, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x01, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x01, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x01, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x01, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x01, 0x00, 0x01, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x01, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x01, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x03, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x03, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x01, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x01, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x01, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x01, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6D, 0x01, // Ŵm (U+0174 U+006D)
  0x01, 0x74, 0x00, 0x6E, 0x01, // Ŵn (U+0174 U+006E)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x70, 0x01, // Ŵp (U+0174 U+0070)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x72, 0x01, // Ŵr (U+0174 U+0072)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x75, 0x01, // Ŵu (U+0174 U+0075)
  0x01, 0x74, 0x00, 0xAB, 0x02, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xBB, 0x01, // Ŵ» (U+0174 U+00BB)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC7, 0x01, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x01, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x01, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x01, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x01, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x01, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x01, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x00, 0xF9, 0x01, // Ŵù (U+0174 U+00F9)
  0x01, 0x74, 0x00, 0xFA, 0x01, // Ŵú (U+0174 U+00FA)
  0x01, 0x74, 0x00, 0xFB, 0x01, // Ŵû (U+0174 U+00FB)
  0x01, 0x74, 0x00, 0xFC, 0x01, // Ŵü (U+0174 U+00FC)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x01, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x01, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x01, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x01, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x01, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x01, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x01, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x01, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x38, 0x01, // Ŵĸ (U+0174 U+0138)
  0x01, 0x74, 0x01, 0x44, 0x01, // Ŵń (U+0174 U+0144)
  0x01, 0x74, 0x01, 0x46, 0x01, // Ŵņ (U+0174 U+0146)
  0x01, 0x74, 0x01, 0x4B, 0x01, // Ŵŋ (U+0174 U+014B)
  0x01, 0x74, 0x01, 0x4C, 0x01, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x01, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x01, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x01, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x55, 0x01, // Ŵŕ (U+0174 U+0155)
  0x01, 0x74, 0x01, 0x57, 0x01, // Ŵŗ (U+0174 U+0157)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x69, 0x01, // Ŵũ (U+0174 U+0169)
  0x01, 0x74, 0x01, 0x6B, 0x01, // Ŵū (U+0174 U+016B)
  0x01, 0x74, 0x01, 0x6D, 0x01, // Ŵŭ (U+0174 U+016D)
  0x01, 0x74, 0x01, 0x6F, 0x01, // Ŵů (U+0174 U+016F)
  0x01, 0x74, 0x01, 0x71, 0x01, // Ŵű (U+0174 U+0171)
  0x01, 0x74, 0x01, 0x73, 0x01, // Ŵų (U+0174 U+0173)
  0x01, 0x74, 0x20, 0x1A, 0x03, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x03, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x03, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x02, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x74, 0x20, 0x3A, 0x01, // Ŵ› (U+0174 U+203A)
  0x01, 0x75, 0x00, 0x2C, 0x03, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x03, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x03, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x03, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x03, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x04, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x04, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x03, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x03, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x03, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x03, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x03, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x03, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x02, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x02, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x03, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x02, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x03, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x02, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x03, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x02, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xAB, 0x05, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x02, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x03, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x03, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x03, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x03, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x03, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x03, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x03, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x03, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x03, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x03, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x03, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x03, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x03, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x03, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x03, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x03, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x03, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x03, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x03, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x03, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x03, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x03, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x03, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x03, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x02, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x02, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x02, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x02, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x03, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x03, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x03, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x03, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x03, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x03, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x03, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x03, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x03, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x03, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x03, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x03, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x03, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x03, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x03, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x03, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x03, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x03, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x03, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x03, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x03, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x02, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x02, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x02, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x02, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x03, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x03, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x03, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x03, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x02, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x02, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x03, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x03, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x02, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x02, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x02, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x02, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x02, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x02, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x04, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x04, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x04, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x05, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x02, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x03, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x03, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x03, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x03, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x03, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x04, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x04, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x03, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x03, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x03, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x03, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x03, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x03, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x02, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x02, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x03, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x02, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x03, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x02, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x03, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x02, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xAB, 0x05, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x02, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x03, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x03, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x03, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x03, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x03, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x03, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x03, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x03, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x03, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x03, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x03, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x03, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x03, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x03, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x03, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x03, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x03, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x03, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x03, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x03, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x03, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x03, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x03, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x03, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x02, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x02, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x02, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x02, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x03, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x03, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x03, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x03, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x03, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x03, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x03, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x03, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x03, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x03, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x03, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x03, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x03, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x03, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x03, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x03, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x03, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x03, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x03, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x03, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x03, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x02, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x02, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x02, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x02, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x03, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x03, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x03, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x03, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x02, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x02, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x03, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x03, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x02, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x02, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x02, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x02, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x02, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x02, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x04, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x04, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x04, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x05, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x02, // Ÿ› (U+0178 U+203A)
  0x01, 0x79, 0x00, 0x43, 0x01, // ŹC (U+0179 U+0043)
  0x01, 0x79, 0x00, 0x47, 0x01, // ŹG (U+0179 U+0047)
  0x01, 0x79, 0x00, 0x4F, 0x01, // ŹO (U+0179 U+004F)
  0x01, 0x79, 0x00, 0x51, 0x01, // ŹQ (U+0179 U+0051)
  0x01, 0x79, 0x00, 0xAB, 0x01, // Ź« (U+0179 U+00AB)
  0x01, 0x79, 0x00, 0xC7, 0x01, // ŹÇ (U+0179 U+00C7)
  0x01, 0x79, 0x00, 0xD2, 0x01, // ŹÒ (U+0179 U+00D2)
  0x01, 0x79, 0x00, 0xD3, 0x01, // ŹÓ (U+0179 U+00D3)
  0x01, 0x79, 0x00, 0xD4, 0x01, // ŹÔ (U+0179 U+00D4)
  0x01, 0x79, 0x00, 0xD5, 0x01, // ŹÕ (U+0179 U+00D5)
  0x01, 0x79, 0x00, 0xD6, 0x01, // ŹÖ (U+0179 U+00D6)
  0x01, 0x79, 0x00, 0xD8, 0x01, // ŹØ (U+0179 U+00D8)
  0x01, 0x79, 0x01, 0x06, 0x01, // ŹĆ (U+0179 U+0106)
  0x01, 0x79, 0x01, 0x08, 0x01, // ŹĈ (U+0179 U+0108)
  0x01, 0x79, 0x01, 0x0A, 0x01, // ŹĊ (U+0179 U+010A)
  0x01, 0x79, 0x01, 0x0C, 0x01, // ŹČ (U+0179 U+010C)
  0x01, 0x79, 0x01, 0x1C, 0x01, // ŹĜ (U+0179 U+011C)
  0x01, 0x79, 0x01, 0x1E, 0x01, // ŹĞ (U+0179 U+011E)
  0x01, 0x79, 0x01, 0x20, 0x01, // ŹĠ (U+0179 U+0120)
  0x01, 0x79, 0x01, 0x22, 0x01, // ŹĢ (U+0179 U+0122)
  0x01, 0x79, 0x01, 0x4C, 0x01, // ŹŌ (U+0179 U+014C)
  0x01, 0x79, 0x01, 0x4E, 0x01, // ŹŎ (U+0179 U+014E)
  0x01, 0x79, 0x01, 0x50, 0x01, // ŹŐ (U+0179 U+0150)
  0x01, 0x79, 0x01, 0x52, 0x01, // ŹŒ (U+0179 U+0152)
  0x01, 0x79, 0x20, 0x39, 0x01, // Ź‹ (U+0179 U+2039)
  0x01, 0x7B, 0x00, 0x43, 0x01, // ŻC (U+017B U+0043)
  0x01, 0x7B, 0x00, 0x47, 0x01, // ŻG (U+017B U+0047)
  0x01, 0x7B, 0x00, 0x4F, 0x01, // ŻO (U+017B U+004F)
  0x01, 0x7B, 0x00, 0x51, 0x01, // ŻQ (U+017B U+0051)
  0x01, 0x7B, 0x00, 0xAB, 0x01, // Ż« (U+017B U+00AB)
  0x01, 0x7B, 0x00, 0xC7, 0x01, // ŻÇ (U+017B U+00C7)
  0x01, 0x7B, 0x00, 0xD2, 0x01, // ŻÒ (U+017B U+00D2)
  0x01, 0x7B, 0x00, 0xD3, 0x01, // ŻÓ (U+017B U+00D3)
  0x01, 0x7B, 0x00, 0xD4, 0x01, // ŻÔ (U+017B U+00D4)
  0x01, 0x7B, 0x00, 0xD5, 0x01, // ŻÕ (U+017B U+00D5)
  0x01, 0x7B, 0x00, 0xD6, 0x01, // ŻÖ (U+017B U+00D6)
  0x01, 0x7B, 0x00, 0xD8, 0x01, // ŻØ (U+017B U+00D8)
  0x01, 0x7B, 0x01, 0x06, 0x01, // ŻĆ (U+017B U+0106)
  0x01, 0x7B, 0x01, 0x08, 0x01, // ŻĈ (U+017B U+0108)
  0x01, 0x7B, 0x01, 0x0A, 0x01, // ŻĊ (U+017B U+010A)
  0x01, 0x7B, 0x01, 0x0C, 0x01, // ŻČ (U+017B U+010C)
  0x01, 0x7B, 0x01, 0x1C, 0x01, // ŻĜ (U+017B U+011C)
  0x01, 0x7B, 0x01, 0x1E, 0x01, // ŻĞ (U+017B U+011E)
  0x01, 0x7B, 0x01, 0x20, 0x01, // ŻĠ (U+017B U+0120)
  0x01, 0x7B, 0x01, 0x22, 0x01, // ŻĢ (U+017B U+0122)
  0x01, 0x7B, 0x01, 0x4C, 0x01, // ŻŌ (U+017B U+014C)
  0x01, 0x7B, 0x01, 0x4E, 0x01, // ŻŎ (U+017B U+014E)
  0x01, 0x7B, 0x01, 0x50, 0x01, // ŻŐ (U+017B U+0150)
  0x01, 0x7B, 0x01, 0x52, 0x01, // ŻŒ (U+017B U+0152)
  0x01, 0x7B, 0x20, 0x39, 0x01, // Ż‹ (U+017B U+2039)
  0x01, 0x7D, 0x00, 0x43, 0x01, // ŽC (U+017D U+0043)
  0x01, 0x7D, 0x00, 0x47, 0x01, // ŽG (U+017D U+0047)
  0x01, 0x7D, 0x00, 0x4F, 0x01, // ŽO (U+017D U+004F)
  0x01, 0x7D, 0x00, 0x51, 0x01, // ŽQ (U+017D U+0051)
  0x01, 0x7D, 0x00, 0xAB, 0x01, // Ž« (U+017D U+00AB)
  0x01, 0x7D, 0x00, 0xC7, 0x01, // ŽÇ (U+017D U+00C7)
  0x01, 0x7D, 0x00, 0xD2, 0x01, // ŽÒ (U+017D U+00D2)
  0x01, 0x7D, 0x00, 0xD3, 0x01, // ŽÓ (U+017D U+00D3)
  0x01, 0x7D, 0x00, 0xD4, 0x01, // ŽÔ (U+017D U+00D4)
  0x01, 0x7D, 0x00, 0xD5, 0x01, // ŽÕ (U+017D U+00D5)
  0x01, 0x7D, 0x00, 0xD6, 0x01, // ŽÖ (U+017D U+00D6)
  0x01, 0x7D, 0x00, 0xD8, 0x01, // ŽØ (U+017D U+00D8)
  0x01, 0x7D, 0x01, 0x06, 0x01, // ŽĆ (U+017D U+0106)
  0x01, 0x7D, 0x01, 0x08, 0x01, // ŽĈ (U+017D U+0108)
  0x01, 0x7D, 0x01, 0x0A, 0x01, // ŽĊ (U+017D U+010A)
  0x01, 0x7D, 0x01, 0x0C, 0x01, // ŽČ (U+017D U+010C)
  0x01, 0x7D, 0x01, 0x1C, 0x01, // ŽĜ (U+017D U+011C)
  0x01, 0x7D, 0x01, 0x1E, 0x01, // ŽĞ (U+017D U+011E)
  0x01, 0x7D, 0x01, 0x20, 0x01, // ŽĠ (U+017D U+0120)
  0x01, 0x7D, 0x01, 0x22, 0x01, // ŽĢ (U+017D U+0122)
  0x01, 0x7D, 0x01, 0x4C, 0x01, // ŽŌ (U+017D U+014C)
  0x01, 0x7D, 0x01, 0x4E, 0x01, // ŽŎ (U+017D U+014E)
  0x01, 0x7D, 0x01, 0x50, 0x01, // ŽŐ (U+017D U+0150)
  0x01, 0x7D, 0x01, 0x52, 0x01, // ŽŒ (U+017D U+0152)
  0x01, 0x7D, 0x20, 0x39, 0x01, // Ž‹ (U+017D U+2039)
  0x20, 0x13, 0x00, 0x54, 0x03, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x03, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x03, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x03, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x03, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x03, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x03, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x03, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x05, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x03, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x04, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x04, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x04, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x02, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x02, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x02, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x04, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x02, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x04, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x02, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x02, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x02, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x05, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x05, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x05, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x05, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x05, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x05, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x06, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x04, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x03, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x03, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x03, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x03, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x03, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x03, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x04, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x04, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x04, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x04, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x04, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x04, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x04, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x04, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x04, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x04, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x04, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x02, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x02, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x02, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x02, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x05, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x03, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x05, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x03, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x05, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x03, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x04, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x04, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x04, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x04, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x04, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x04, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x04, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x04, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x04, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x04, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x04, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x02, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x02, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x02, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x02, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x02, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x02, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x02, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x02, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x04, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x04, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x04, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x04, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x02, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x02, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x02, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x02, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x02, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x02, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x02, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x02, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x02, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x02, // ‘ų (U+2018 U+0173)
  0x20, 0x18, 0x03, 0xBC, 0x01, // ‘μ (U+2018 U+03BC)
  0x20, 0x19, 0x00, 0x41, 0x05, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x03, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x04, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x04, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x04, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x02, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x02, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x02, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x04, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x02, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x04, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x02, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x02, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x02, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x05, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x05, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x05, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x05, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x05, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x05, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x06, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x04, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x03, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x03, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x03, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x03, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x03, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x03, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x04, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x04, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x04, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x04, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x04, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x04, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x04, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x04, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x04, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x04, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x04, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x02, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x02, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x02, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x02, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x05, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x03, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x05, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x03, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x05, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x03, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x04, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x04, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x04, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x04, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x04, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x04, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x04, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x04, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x04, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x04, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x04, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x02, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x02, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x02, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x02, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x02, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x02, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x02, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x02, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x04, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x04, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x04, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x04, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x02, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x02, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x02, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x02, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x02, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x02, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x02, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x02, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x02, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x02, // ’ų (U+2019 U+0173)
  0x20, 0x19, 0x03, 0xBC, 0x01, // ’μ (U+2019 U+03BC)
  0x20, 0x1A, 0x00, 0x43, 0x03, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x03, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x03, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x03, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x05, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x01, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x04, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x04, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x04, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x03, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x03, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x03, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x03, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x03, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x03, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x03, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x01, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x01, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x01, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x01, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x04, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x03, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x03, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x03, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x03, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x03, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x03, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x03, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x03, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x03, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x03, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x03, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x03, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x05, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x05, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x05, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x01, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x01, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x01, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x01, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x01, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x01, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x04, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x04, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x04, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x05, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x03, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x04, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x04, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x04, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x02, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x02, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x02, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x04, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x02, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x04, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x02, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x02, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x02, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x05, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x05, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x05, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x05, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x05, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x05, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x06, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x04, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x03, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x03, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x03, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x03, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x03, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x03, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x04, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x04, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x04, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x04, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x04, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x04, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x04, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x04, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x04, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x04, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x04, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x02, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x02, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x02, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x02, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x05, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x03, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x05, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x03, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x05, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x03, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x04, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x04, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x04, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x04, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x04, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x04, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x04, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x04, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x04, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x04, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x04, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x02, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x02, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x02, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x02, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x02, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x02, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x02, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x02, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x04, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x04, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x04, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x04, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x02, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x02, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x02, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x02, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x02, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x02, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x02, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x02, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x02, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x02, // “ų (U+201C U+0173)
  0x20, 0x1C, 0x03, 0xBC, 0x01, // “μ (U+201C U+03BC)
  0x20, 0x1D, 0x00, 0x41, 0x05, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x03, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x04, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x04, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x04, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x02, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x02, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x02, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x04, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x02, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x04, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x02, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x02, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x02, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x05, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x05, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x05, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x05, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x05, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x05, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x06, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x04, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x03, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x03, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x03, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x03, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x03, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x03, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x04, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x04, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x04, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x04, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x04, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x04, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x04, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x04, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x04, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x04, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x04, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x02, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x02, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x02, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x02, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x05, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x03, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x05, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x03, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x05, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x03, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x04, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x04, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x04, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x04, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x04, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x04, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x04, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x04, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x04, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x04, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x04, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x02, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x02, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x02, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x02, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x02, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x02, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x02, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x02, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x04, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x04, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x04, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x04, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x02, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x02, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x02, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x02, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x02, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x02, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x02, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x02, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x02, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x02, // ”ų (U+201D U+0173)
  0x20, 0x1D, 0x03, 0xBC, 0x01, // ”μ (U+201D U+03BC)
  0x20, 0x1E, 0x00, 0x43, 0x03, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x03, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x03, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x03, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x05, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x01, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x04, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x04, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x04, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x03, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x03, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x03, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x03, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x03, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x03, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x03, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x01, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x01, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x01, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x01, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x04, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x03, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x03, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x03, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x03, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x03, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x03, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x03, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x03, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x03, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x03, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x03, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x03, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x05, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x05, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x05, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x01, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x01, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x01, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x01, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x01, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x01, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x04, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x04, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x04, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x02, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x56, 0x01, // ‹V (U+2039 U+0056)
  0x20, 0x39, 0x00, 0x57, 0x01, // ‹W (U+2039 U+0057)
  0x20, 0x39, 0x00, 0x59, 0x02, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x02, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x02, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x02, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x02, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x74, 0x01, // ‹Ŵ (U+2039 U+0174)
  0x20, 0x39, 0x01, 0x76, 0x02, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x02, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x04, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x02, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x02, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x58, 0x01, // ›X (U+203A U+0058)
  0x20, 0x3A, 0x00, 0x59, 0x05, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x05, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x04, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x04, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x04, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x02, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x05, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x05, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x0E, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x0E, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x0E, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x0E, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x0E, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x0E, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x0E, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x0E, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x0E, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x0E, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x01, 0xFE, 0x0E, 0x01, 0xFE, 0x0E, 0x1F, 0xE0, 0xD1, 0xFE, 0x81, 0xC0, 0xEF, 0xD8, 0x1C, 0x0D,
  0xFD, 0x81, 0xB0, 0xCF, 0xD8, 0x1A, 0x0C, 0xFD, 0x81, 0x90, 0xBF, 0xD8, 0x19, 0x0A, 0xFD, 0x81,
  0x80, 0x9F, 0xD8, 0x17, 0x09, 0xFD, 0x81, 0x70, 0x8F, 0xD8, 0x16, 0x07, 0xFD, 0x81, 0x50, 0x6F,
  0xD8, 0x14, 0x06, 0xFD, 0x81, 0x40, 0x5F, 0xD8, 0x13, 0x04, 0xFD, 0x81, 0x20, 0x3F, 0xD8, 0x12,
  0x03, 0xFD, 0x81, 0x10, 0x2F, 0xD2, 0x01, 0xFD, 0x3F, 0xC0, 0xE3, 0xFC, 0x0E, 0x30, 0xEF, 0xB0,
  0xD3, 0x0E, 0xFB, 0x0C, 0x30, 0xDF, 0xB0, 0xB3, 0x0C, 0xFB, 0x0B, 0x30, 0xBF, 0xB0, 0xA3, 0x0B,
  0xFB, 0x09, 0x30, 0xAF, 0xB0, 0x93, 0x09, 0xFB, 0x08, 0x30, 0x8F, 0xB0, 0x73, 0x08, 0xFB, 0x07,
  0x30, 0x7F, 0xB0, 0x63, 0x06, 0xFB, 0x05, 0x30, 0x5F, 0xB0, 0x43, 0x05, 0xFB, 0x04, 0x30, 0x4F,
  0xB0, 0x33, 0x03, 0xFB, 0x02, 0x30, 0x2F, 0xB0, 0x23, 0x02, 0xFB, 0x01, 0x30, 0x1F, 0xB8, 0x09,
  0xD3, 0x08, 0x65, 0xAD, 0xFE, 0xD9, 0x35, 0x01, 0x0B, 0xF9, 0x0A, 0x40, 0xCF, 0xB0, 0xA2, 0x06,
  0xFD, 0x81, 0x40, 0xCF, 0xD0, 0xA0, 0x1F, 0xE0, 0xE0, 0x2F, 0xF0, 0x3F, 0xF0, 0x2F, 0xF1, 0xFE,
  0x81, 0xD0, 0xCF, 0xD8, 0x19, 0x06, 0xFD, 0x03, 0x20, 0xBF, 0xB0, 0x83, 0x01, 0x0B, 0xF9, 0x08,
  0x68, 0x64, 0xAD, 0xFE, 0xD9, 0x33,
  // """ (U+0022)
  0x04, 0xFD, 0x05, 0x50, 0xAF, 0xC0, 0xE0, 0x3F, 0xD0, 0x35, 0x09, 0xFC, 0x0D, 0x02, 0xFD, 0x02,
  0x50, 0x7F, 0xC0, 0xC1, 0xFD, 0x01, 0x50, 0x6F, 0xC0, 0xB1, 0xFD, 0x60, 0x5F, 0xC8, 0x1A, 0x0E,
  0xFB, 0x0E, 0x60, 0x4F, 0xC8, 0x19, 0x0C, 0xFB, 0x0D, 0x60, 0x3F, 0xC8, 0x18, 0x0B, 0xFB, 0x0C,
  0x60, 0x2F, 0xC8, 0x16, 0x0A, 0xFB, 0x0A, 0x7F, 0xC8, 0x15, 0x09, 0xFB, 0x09, 0x7F, 0xC8, 0x14,
  0x08, 0xFB, 0x08, 0x70, 0xEF, 0xB8, 0x13, 0x07, 0xFB, 0x07, 0x70, 0xDF, 0xB8, 0x12, 0x06, 0xFB,
  0x06, 0x70, 0xBF, 0xB8, 0x11, 0x04, 0xFB, 0x04, 0x70, 0xAF, 0xB2, 0x03, 0xFB, 0x03, 0x70, 0x9F,
  0xA0, 0xE2, 0x02, 0xFB, 0x02, 0x70, 0x8F, 0xA0, 0xD2, 0x01, 0xFB, 0x01, 0x70, 0x7F, 0xA0, 0xC3,
  0xFB, 0x71, 0x06, 0xFA, 0x0A, 0x30, 0xEF, 0x90, 0xE7, 0x10, 0x4F, 0xA0, 0x93, 0x0D, 0xF9, 0x0D,
  0x71, 0x03, 0xFA, 0x08, 0x30, 0xCF, 0x90, 0xB7, 0x10, 0x2F, 0xA0, 0x73, 0x0B, 0xF9, 0x0A, 0x71,
  0x01, 0xFA, 0x06, 0x30, 0xAF, 0x90, 0x97, 0x2F, 0xA0, 0x51,
  // "#" (U+0023)
  0x77, 0x20, 0xCF, 0x97, 0x08, 0xF9, 0x04, 0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x0A, 0xF9, 0x02, 0x77,
  0x70, 0x1F, 0x90, 0xA7, 0x0C, 0xF9, 0x77, 0x71, 0x04, 0xF9, 0x08, 0x7F, 0x90, 0xC7, 0x77, 0x10,
  0x6F, 0x90, 0x56, 0x02, 0xF9, 0x0A, 0x77, 0x71, 0x09, 0xF9, 0x03, 0x60, 0x4F, 0x90, 0x77, 0x77,
  0x10, 0xBF, 0x90, 0x16, 0x07, 0xF9, 0x05, 0x77, 0x71, 0x0E, 0xF0, 0xE7, 0x09, 0xF9, 0x02, 0x77,
  0x70, 0x1F, 0x90, 0xB7, 0x0C, 0xF9, 0x77, 0x71, 0x03, 0xF9, 0x09, 0x70, 0xEF, 0x0C, 0x77, 0x71,
  0x06, 0xF9, 0x06, 0x60, 0x1F, 0x90, 0xA7, 0x77, 0x10, 0x8F, 0x90, 0x46, 0x04, 0xF9, 0x07, 0x77,
  0x71, 0x0B, 0xF9, 0x01, 0x60, 0x6F, 0x90, 0x57, 0x77, 0x10, 0xDF, 0x0E, 0x70, 0x8F, 0x90, 0x27,
  0x77, 0x1F, 0x90, 0xC7, 0x0B, 0xF9, 0x77, 0x71, 0x02, 0xF9, 0x09, 0x70, 0xDF, 0x0D, 0x77, 0x71,
  0x05, 0xF9, 0x07, 0x7F, 0x90, 0xA7, 0x50, 0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8, 0x0C, 0x7F, 0x02,
  0x30, 0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8, 0x0C, 0x7F, 0x02, 0x30,
  0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8, 0x0C, 0x7F, 0x02, 0x30, 0xB8,
  0x0C, 0x7F, 0x02, 0x75, 0x0D, 0xF9, 0x70, 0x8F, 0x90, 0x47, 0x77, 0x1F, 0x90, 0xE7, 0x0B, 0xF9,
  0x01, 0x77, 0x70, 0x2F, 0x90, 0xB7, 0x0D, 0xF9, 0x77, 0x71, 0x04, 0xF9, 0x09, 0x7F, 0x90, 0xC7,
  0x77, 0x10, 0x7F, 0x90, 0x66, 0x02, 0xF9, 0x0A, 0x77, 0x71, 0x09, 0xF9, 0x04, 0x60, 0x5F, 0x90,
  0x87, 0x77, 0x10, 0xCF, 0x90, 0x26, 0x07, 0xF9, 0x05, 0x77, 0x71, 0x0E, 0xF9, 0x70, 0xAF, 0x90,
  0x37, 0x77, 0x01, 0xF9, 0x0C, 0x70, 0xCF, 0x90, 0x17, 0x77, 0x03, 0xF9, 0x0A, 0x70, 0xEF, 0x0E,
  0x77, 0x71, 0x06, 0xF9, 0x07, 0x60, 0x1F, 0x90, 0xC7, 0x50, 0x18, 0x0C, 0x7F, 0x0B, 0x30, 0x18,
  0x0C, 0x7F, 0x0B, 0x30, 0x18, 0x0C, 0x7F, 0x0B, 0x30, 0x18, 0x0C, 0x7F, 0x0B, 0x30, 0x18, 0x0C,
  0x7F, 0x0B, 0x30, 0x18, 0x0C, 0x7F, 0x0B, 0x30, 0x18, 0x0C, 0x7F, 0x0B, 0x30, 0x18, 0x0C, 0x7F,
  0x0B, 0x30, 0x18, 0x0C, 0x7F, 0x0B, 0x75, 0x0C, 0xF9, 0x70, 0x9F, 0x90, 0x57, 0x77, 0x10, 0xEF,
  0x0D, 0x70, 0xCF, 0x90, 0x37, 0x77, 0x01, 0xF9, 0x0A, 0x70, 0xEF, 0x90, 0x17, 0x77, 0x04, 0xF9,
  0x08, 0x60, 0x1F, 0x90, 0xE7, 0x77, 0x10, 0x6F, 0x90, 0x66, 0x03, 0xF9, 0x0B, 0x77, 0x71, 0x08,
  0xF9, 0x03, 0x60, 0x6F, 0x90, 0x97, 0x77, 0x10, 0xBF, 0x90, 0x16, 0x08, 0xF9, 0x06, 0x77, 0x71,
  0x0D, 0xF0, 0xE7, 0x0B, 0xF9, 0x04, 0x77, 0x71, 0xF9, 0x0C, 0x70, 0xDF, 0x90, 0x27, 0x77, 0x02,
  0xF9, 0x0A, 0x7F, 0xA7, 0x77, 0x10, 0x4F, 0x90, 0x76, 0x02, 0xF9, 0x0C, 0x77, 0x71, 0x07, 0xF9,
  0x05, 0x60, 0x5F, 0x90, 0xA7, 0x77, 0x10, 0x9F, 0x90, 0x36, 0x07, 0xF9, 0x08, 0x77, 0x71, 0x0B,
  0xF9, 0x70, 0x9F, 0x90, 0x57, 0x77, 0x10, 0xEF, 0x0D, 0x70, 0xCF, 0x90, 0x37, 0x77, 0x01, 0xF9,
  0x0B, 0x70, 0xEF, 0x97, 0x77, 0x10, 0x3F, 0x90, 0x96, 0x01, 0xF9, 0x0E, 0x77, 0x71, 0x05, 0xF9,
  0x07, 0x60, 0x3F, 0x90, 0xB7, 0x72,
  // "$" (U+0024)
  0x77, 0x20, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77,
  0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x30,
  0x20, 0x6D, 0x81, 0xA3, 0x27, 0x77, 0x48, 0x21, 0x7B, 0xEF, 0xC8, 0x2E, 0xB8, 0x47, 0x74, 0x04,
  0x0C, 0xFF, 0xE0, 0xA0, 0x47, 0x60, 0x30, 0xCF, 0xFF, 0xB0, 0xD0, 0x67, 0x30, 0x7F, 0xFF, 0xF0,
  0xD0, 0x47, 0x0A, 0xFF, 0xFF, 0xA0, 0xE6, 0x0B, 0xFF, 0xFF, 0xB0, 0xA5, 0x08, 0xFF, 0xFF, 0xC0,
  0x54, 0x03, 0xFF, 0xFF, 0xC0, 0xE5, 0x0B, 0xFF, 0xFF, 0xC0, 0xA4, 0x02, 0xFF, 0xFF, 0xD0, 0x44,
  0x07, 0xFD, 0x81, 0xC6, 0x5D, 0x84, 0x82, 0x46, 0x9D, 0xE0, 0xE5, 0x0B, 0xFC, 0x06, 0x20, 0x3D,
  0x08, 0x58, 0x11, 0x6B, 0xB0, 0x95, 0x0E, 0xFB, 0x07, 0x30, 0x3D, 0x08, 0x71, 0x82, 0x17, 0xE4,
  0x5F, 0xB0, 0xE4, 0x03, 0xD0, 0x87, 0x72, 0x01, 0xFB, 0x0B, 0x40, 0x3D, 0x08, 0x77, 0x20, 0x1F,
  0xB0, 0x94, 0x03, 0xD0, 0x87, 0x73, 0xFB, 0x09, 0x40, 0x3D, 0x08, 0x77, 0x30, 0xEF, 0xA0, 0xC4,
  0x03, 0xD0, 0x87, 0x73, 0x0D, 0xFB, 0x03, 0x30, 0x3D, 0x08, 0x77, 0x30, 0x9F, 0xB0, 0xD0, 0x12,
  0x03, 0xD0, 0x87, 0x73, 0x05, 0xFC, 0x82, 0xE4, 0x03, 0xD0, 0x87, 0x73, 0x01, 0x0E, 0xFD, 0x0A,
  0x05, 0xD0, 0x87, 0x74, 0x08, 0xFF, 0xD0, 0x87, 0x74, 0x01, 0x0E, 0xFF, 0xC0, 0x87, 0x75, 0x05,
  0xFF, 0xC0, 0xC0, 0x37, 0x75, 0x08, 0xFF, 0xD0, 0xC0, 0x67, 0x74, 0x08, 0xFF, 0xE8, 0x1E, 0x71,
  0x77, 0x20, 0x5F, 0xFF, 0x0E, 0x07, 0x77, 0x20, 0x20, 0xCF, 0xFF, 0x0D, 0x04, 0x77, 0x20, 0x60,
  0xEF, 0xFF, 0x09, 0x77, 0x28, 0x11, 0x8E, 0xFF, 0xE0, 0xC0, 0x17, 0x72, 0x81, 0x18, 0xEF, 0xFD,
  0x0C, 0x01, 0x77, 0x40, 0x60, 0xDF, 0xFC, 0x0B, 0x77, 0x50, 0x3F, 0xFD, 0x06, 0x77, 0x40, 0x3F,
  0xFD, 0x0E, 0x77, 0x40, 0x3D, 0x0B, 0x0C, 0xFE, 0x06, 0x77, 0x30, 0x3D, 0x82, 0x80, 0x6E, 0xFC,
  0x0B, 0x77, 0x30, 0x3D, 0x08, 0x20, 0x20, 0xEF, 0xB0, 0xE7, 0x73, 0x03, 0xD0, 0x83, 0x03, 0xFC,
  0x02, 0x77, 0x20, 0x3D, 0x08, 0x40, 0x9F, 0xB0, 0x37, 0x72, 0x03, 0xD0, 0x84, 0x05, 0xFB, 0x04,
  0x77, 0x20, 0x3D, 0x08, 0x40, 0x3F, 0xB0, 0x37, 0x72, 0x03, 0xD0, 0x84, 0x04, 0xFB, 0x82, 0x20,
  0x93, 0x76, 0x03, 0xD0, 0x84, 0x08, 0xFB, 0x84, 0x10, 0xDF, 0xA3, 0x74, 0x03, 0xD0, 0x83, 0x01,
  0x0E, 0xFA, 0x0D, 0x20, 0xDB, 0x0B, 0x05, 0x72, 0x03, 0xD0, 0x83, 0x0B, 0xFB, 0x09, 0x20, 0xDD,
  0x81, 0xE8, 0x36, 0x03, 0xD8, 0x28, 0x03, 0xCF, 0xC0, 0x42, 0x0D, 0xF9, 0x85, 0xEA, 0x64, 0x20,
  0x3D, 0x00, 0xCF, 0xD0, 0xC3, 0x0D, 0xFF, 0xFF, 0xE0, 0x53, 0x0D, 0xFF, 0xFF, 0xD0, 0xB4, 0x0D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x14, 0x0D, 0xFF, 0xFF, 0xB0, 0xE0, 0x35, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0,
  0x26, 0x0C, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x10, 0x40, 0xBF, 0xFF, 0xC0, 0xD0, 0x47, 0x58, 0x21,
  0x6A, 0xEF, 0xFD, 0x0A, 0x04, 0x77, 0x48, 0x62, 0x57, 0xAC, 0xDD, 0xEE, 0x83, 0xEB, 0x84, 0x17,
  0x77, 0x70, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77,
  0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40,
  0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x20,
  // "%" (U+0025)
  0x72, 0x82, 0x38, 0xBD, 0xA8, 0x2E, 0xC8, 0x48, 0x0E, 0x50, 0x03, 0x0B, 0xFB, 0x0D, 0x04, 0x77,
  0x71, 0x07, 0xF9, 0x0D, 0x77, 0x71, 0x07, 0xFF, 0x09, 0x77, 0x70, 0xEF, 0x90, 0x67, 0x77, 0x08,
  0xFF, 0xA0, 0xA7, 0x75, 0x05, 0xF9, 0x0E, 0x77, 0x70, 0x5F, 0xFC, 0x09, 0x77, 0x40, 0xCF, 0x90,
  0x87, 0x76, 0x01, 0x0E, 0xFF, 0xD0, 0x57, 0x72, 0x04, 0xFA, 0x01, 0x77, 0x60, 0x9F, 0xFE, 0x0D,
  0x77, 0x20, 0xAF, 0x90, 0xA7, 0x76, 0x02, 0xFF, 0xF9, 0x06, 0x77, 0x02, 0xFA, 0x03, 0x77, 0x60,
  0x8F, 0xFF, 0x90, 0xD7, 0x70, 0x8F, 0x90, 0xC7, 0x77, 0x0D, 0xFA, 0x82, 0xC2, 0x17, 0xFB, 0x04,
  0x76, 0x0E, 0xF9, 0x05, 0x77, 0x60, 0x2F, 0xA0, 0xE0, 0x13, 0x09, 0xFA, 0x09, 0x75, 0x07, 0xF9,
  0x0D, 0x77, 0x70, 0x6F, 0xA0, 0x94, 0x01, 0xFA, 0x0D, 0x75, 0x0D, 0xF9, 0x07, 0x77, 0x70, 0xAF,
  0xA0, 0x45, 0x0C, 0xFA, 0x01, 0x73, 0x05, 0xF9, 0x0E, 0x01, 0x77, 0x70, 0xCF, 0xA6, 0x08, 0xFA,
  0x04, 0x73, 0x0B, 0xF9, 0x09, 0x77, 0x71, 0x0E, 0xF9, 0x0D, 0x60, 0x6F, 0xA0, 0x67, 0x20, 0x3F,
  0xA0, 0x27, 0x77, 0x01, 0xFA, 0x0B, 0x60, 0x4F, 0xA0, 0x87, 0x20, 0xAF, 0x90, 0xB7, 0x77, 0x10,
  0x2F, 0xA0, 0xA6, 0x02, 0xFA, 0x0A, 0x71, 0x01, 0xFA, 0x04, 0x77, 0x71, 0x03, 0xFA, 0x09, 0x60,
  0x1F, 0xA0, 0xB7, 0x10, 0x8F, 0x90, 0xC7, 0x77, 0x20, 0x4F, 0xA0, 0x86, 0x01, 0xFA, 0x0B, 0x71,
  0x0E, 0xF9, 0x06, 0x77, 0x72, 0x04, 0xFA, 0x08, 0x7F, 0xA0, 0xC7, 0x06, 0xF9, 0x0E, 0x77, 0x73,
  0x04, 0xFA, 0x08, 0x7F, 0xA0, 0xC7, 0x0C, 0xF9, 0x08, 0x77, 0x73, 0x03, 0xFA, 0x08, 0x7F, 0xA0,
  0xB6, 0x04, 0xFA, 0x01, 0x77, 0x73, 0x02, 0xFA, 0x08, 0x7F, 0xA0, 0xB6, 0x0B, 0xF9, 0x0A, 0x77,
  0x74, 0x01, 0xFA, 0x09, 0x60, 0x1F, 0xA0, 0xA5, 0x02, 0xFA, 0x03, 0x77, 0x75, 0xFA, 0x0A, 0x60,
  0x2F, 0xA0, 0x85, 0x09, 0xF9, 0x0B, 0x77, 0x76, 0x0D, 0xF9, 0x0B, 0x60, 0x3F, 0xA0, 0x64, 0x01,
  0x0E, 0xF9, 0x05, 0x77, 0x76, 0x0B, 0xF9, 0x0D, 0x60, 0x5F, 0xA0, 0x44, 0x07, 0xF9, 0x0D, 0x78,
  0x91, 0x16, 0xAD, 0xEF, 0xED, 0xA6, 0x17, 0x30, 0x8F, 0xA0, 0x15, 0x07, 0xFA, 0x01, 0x40, 0xDF,
  0x90, 0x75, 0x01, 0x09, 0xFB, 0x0E, 0x08, 0x72, 0x05, 0xFA, 0x04, 0x50, 0xBF, 0x90, 0xD4, 0x05,
  0xF9, 0x0E, 0x50, 0x30, 0xEF, 0xE0, 0xD0, 0x27, 0x1F, 0xA0, 0x95, 0x0E, 0xF9, 0x09, 0x40, 0xCF,
  0x90, 0x84, 0x03, 0x0E, 0xFF, 0x90, 0xE0, 0x37, 0x0B, 0xFA, 0x02, 0x30, 0x7F, 0xA0, 0x53, 0x03,
  0xFA, 0x02, 0x30, 0x10, 0xEF, 0xFB, 0x0E, 0x01, 0x60, 0x6F, 0xA8, 0x2C, 0x30, 0x5F, 0xA0, 0xE4,
  0x0A, 0xF9, 0x0A, 0x40, 0xBF, 0xFD, 0x0B, 0x70, 0xDF, 0xFF, 0x08, 0x30, 0x1F, 0xA0, 0x33, 0x04,
  0xFF, 0xF0, 0x56, 0x06, 0xFF, 0xE0, 0xE0, 0x13, 0x08, 0xF9, 0x0C, 0x40, 0xBF, 0xFF, 0x0D, 0x70,
  0xDF, 0xFD, 0x07, 0x40, 0xEF, 0x90, 0x53, 0x02, 0xFB, 0x82, 0x50, 0x3D, 0xFA, 0x04, 0x60, 0x3F,
  0xFC, 0x0B, 0x40, 0x6F, 0x90, 0xE4, 0x08, 0xFA, 0x07, 0x30, 0x2F, 0xA0, 0xA7, 0x05, 0xFF, 0xA0,
  0xC0, 0x14, 0x0D, 0xF9, 0x07, 0x40, 0xCF, 0x90, 0xE5, 0x0B, 0xF9, 0x0E, 0x71, 0x04, 0x0E, 0xFE,
  0x0B, 0x01, 0x40, 0x4F, 0xA0, 0x13, 0x01, 0xFA, 0x0A, 0x50, 0x6F, 0xA0, 0x47, 0x10, 0x10, 0xAF,
  0xB0, 0xD0, 0x66, 0x0B, 0xF9, 0x09, 0x40, 0x4F, 0xA0, 0x75, 0x02, 0xFA, 0x07, 0x73, 0x82, 0x27,
  0xBD, 0xA8, 0x2E, 0xC9, 0x47, 0x02, 0xFA, 0x02, 0x40, 0x6F, 0xA0, 0x46, 0xFA, 0x0A, 0x77, 0x76,
  0x09, 0xF9, 0x0B, 0x50, 0x8F, 0xA0, 0x26, 0x0D, 0xF9, 0x0D, 0x77, 0x75, 0x01, 0xFA, 0x04, 0x50,
  0xAF, 0xA0, 0x16, 0x0C, 0xFA, 0x77, 0x75, 0x07, 0xF9, 0x0D, 0x60, 0xBF, 0xA7, 0x0A, 0xFA, 0x77,
  0x75, 0x0E, 0xF9, 0x06, 0x60, 0xCF, 0x90, 0xE7, 0x0A, 0xFA, 0x02, 0x77, 0x73, 0x05, 0xF9, 0x0E,
  0x70, 0xDF, 0x90, 0xE7, 0x09, 0xFA, 0x02, 0x77, 0x73, 0x0C, 0xF9, 0x08, 0x70, 0xDF, 0x90, 0xE7,
  0x09, 0xFA, 0x03, 0x77, 0x72, 0x03, 0xFA, 0x01, 0x70, 0xDF, 0x90, 0xE7, 0x09, 0xFA, 0x02, 0x77,
  0x72, 0x0A, 0xF9, 0x0A, 0x71, 0x0C, 0xF9, 0x0E, 0x70, 0xAF, 0xA0, 0x27, 0x77, 0x10, 0x2F, 0xA0,
  0x37, 0x10, 0xBF, 0xA7, 0x0A, 0xFA, 0x01, 0x77, 0x71, 0x08, 0xF9, 0x0C, 0x72, 0x0B, 0xFA, 0x01,
  0x60, 0xBF, 0xA7, 0x77, 0x20, 0xEF, 0x90, 0x57, 0x20, 0x9F, 0xA0, 0x26, 0x0D, 0xF9, 0x0E, 0x77,
  0x71, 0x06, 0xF9, 0x0D, 0x73, 0x07, 0xFA, 0x04, 0x6F, 0xA0, 0xD7, 0x77, 0x10, 0xDF, 0x90, 0x77,
  0x30, 0x4F, 0xA0, 0x65, 0x01, 0xFA, 0x0A, 0x77, 0x70, 0x4F, 0xA0, 0x17, 0x30, 0x2F, 0xA0, 0xA5,
  0x05, 0xFA, 0x07, 0x77, 0x70, 0xBF, 0x90, 0x97, 0x50, 0xEF, 0x90, 0xE5, 0x0A, 0xFA, 0x04, 0x77,
  0x60, 0x3F, 0xA0, 0x27, 0x50, 0x9F, 0xA0, 0x73, 0x02, 0xFB, 0x77, 0x70, 0x9F, 0x90, 0xB7, 0x60,
  0x4F, 0xB8, 0x25, 0x03, 0xCF, 0xA0, 0xB7, 0x76, 0x01, 0xFA, 0x04, 0x77, 0x0E, 0xFF, 0xF9, 0x05,
  0x77, 0x60, 0x7F, 0x90, 0xD7, 0x71, 0x07, 0xFF, 0xF0, 0xD7, 0x77, 0x0E, 0xF9, 0x06, 0x77, 0x20,
  0xEF, 0xFE, 0x06, 0x77, 0x60, 0x6F, 0x90, 0xE7, 0x73, 0x06, 0xFF, 0xD0, 0xC7, 0x77, 0x0C, 0xF9,
  0x08, 0x77, 0x40, 0xBF, 0xFB, 0x0E, 0x02, 0x77, 0x60, 0x4F, 0xA0, 0x17, 0x74, 0x01, 0x0C, 0xFF,
  0xA0, 0x47, 0x77, 0x0A, 0xF9, 0x0A, 0x77, 0x60, 0x10, 0xBF, 0xE0, 0xE0, 0x47, 0x77, 0x02, 0xFA,
  0x03, 0x77, 0x71, 0x06, 0x0E, 0xFB, 0x09, 0x01, 0x80, 0xE5, 0x08, 0x90, 0x5A, 0xDE, 0xFE, 0xDA,
  0x61, 0x72,
  // "&" (U+0026)
  0x77, 0x28, 0x92, 0x37, 0xAC, 0xDE, 0xFD, 0xCB, 0x74, 0x80, 0xC4, 0x08, 0x11, 0x8E, 0xFD, 0x81,
  0xE8, 0x18, 0x0C, 0x00, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x75, 0x02, 0x0C, 0xFF, 0xE0, 0xC0, 0x17,
  0x77, 0x72, 0x02, 0x0E, 0xFF, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x01, 0x0E, 0xFF, 0xFB, 0x0C, 0x77,
  0x77, 0x0B, 0xFF, 0xFD, 0x07, 0x77, 0x75, 0x06, 0xFF, 0xFF, 0x01, 0x77, 0x74, 0x0D, 0xFF, 0xFF,
  0x07, 0x77, 0x73, 0x04, 0xFD, 0x0C, 0x04, 0x20, 0x50, 0xDF, 0xC0, 0xC7, 0x77, 0x30, 0x8F, 0xC0,
  0xA5, 0x01, 0x0D, 0xFC, 0x01, 0x77, 0x72, 0x0C, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x47, 0x77, 0x20,
  0xEF, 0xB0, 0xA7, 0x1F, 0xC0, 0x67, 0x77, 0x2F, 0xC0, 0x87, 0x10, 0xDF, 0xB0, 0x77, 0x77, 0x10,
  0x1F, 0xC0, 0x77, 0x10, 0xDF, 0xB0, 0x77, 0x77, 0x2F, 0xC0, 0x77, 0x10, 0xDF, 0xB0, 0x77, 0x77,
  0x2F, 0xC0, 0x97, 0x1F, 0xC0, 0x57, 0x77, 0x20, 0xDF, 0xB0, 0xB7, 0x04, 0xFC, 0x04, 0x77, 0x72,
  0x0B, 0xFC, 0x01, 0x60, 0x9F, 0xC0, 0x17, 0x77, 0x20, 0x8F, 0xC0, 0x55, 0x01, 0x0E, 0xFB, 0x0D,
  0x77, 0x73, 0x05, 0xFC, 0x0D, 0x50, 0x9F, 0xC0, 0x77, 0x77, 0x30, 0x1F, 0xD0, 0x53, 0x05, 0xFD,
  0x02, 0x77, 0x74, 0x0A, 0xFC, 0x82, 0xE1, 0x04, 0xFD, 0x0A, 0x77, 0x75, 0x04, 0xFD, 0x0A, 0x05,
  0xFE, 0x02, 0x77, 0x76, 0x0C, 0xFF, 0xFC, 0x07, 0x77, 0x77, 0x04, 0xFF, 0xFB, 0x0B, 0x77, 0x77,
  0x20, 0xAF, 0xFF, 0x90, 0xD0, 0x17, 0x77, 0x72, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x77, 0x74,
  0x05, 0xFF, 0xD0, 0xD0, 0x27, 0x77, 0x76, 0x0A, 0xFF, 0xB0, 0xD0, 0x27, 0x77, 0x76, 0x06, 0x0E,
  0xFF, 0xA0, 0xB0, 0x17, 0x77, 0x75, 0x01, 0x0B, 0xFF, 0xB0, 0xA7, 0x40, 0x8F, 0xD0, 0x47, 0x20,
  0x30, 0xEF, 0xFC, 0x0D, 0x01, 0x73, 0x0B, 0xFD, 0x01, 0x71, 0x04, 0xFF, 0xF0, 0xB7, 0x30, 0xEF,
  0xC0, 0xD7, 0x10, 0x4F, 0xFF, 0xA0, 0x87, 0x10, 0x2F, 0xD0, 0x97, 0x03, 0xFF, 0xFC, 0x04, 0x70,
  0x6F, 0xD0, 0x67, 0x0D, 0xFF, 0xFC, 0x0E, 0x02, 0x60, 0xAF, 0xD0, 0x26, 0x09, 0xFF, 0xFE, 0x0C,
  0x60, 0xEF, 0xC0, 0xD6, 0x02, 0xFE, 0x81, 0xE3, 0xBF, 0xE0, 0x94, 0x03, 0xFD, 0x09, 0x60, 0xAF,
  0xD8, 0x3E, 0x30, 0x1D, 0xFE, 0x06, 0x30, 0x9F, 0xD0, 0x45, 0x01, 0xFE, 0x05, 0x30, 0x3F, 0xF0,
  0x32, 0x0E, 0xFC, 0x0E, 0x60, 0x6F, 0xD0, 0xB5, 0x06, 0xFE, 0x81, 0xD1, 0x5F, 0xD0, 0x96, 0x0A,
  0xFD, 0x03, 0x60, 0x9F, 0xE0, 0xB0, 0xCF, 0xD0, 0x46, 0x0D, 0xFC, 0x0D, 0x71, 0x0C, 0xFF, 0xFC,
  0x0D, 0x7F, 0xD0, 0x97, 0x10, 0x10, 0xEF, 0xFF, 0xB0, 0x76, 0x02, 0xFD, 0x06, 0x72, 0x04, 0xFF,
  0xFB, 0x01, 0x60, 0x3F, 0xD0, 0x57, 0x30, 0x7F, 0xFF, 0x90, 0x97, 0x04, 0xFD, 0x04, 0x74, 0x0A,
  0xFF, 0xF0, 0x27, 0x04, 0xFD, 0x05, 0x74, 0x01, 0x0D, 0xFF, 0xD0, 0x97, 0x10, 0x3F, 0xD0, 0x77,
  0x50, 0x20, 0xEF, 0xFC, 0x01, 0x71, 0x02, 0xFD, 0x0B, 0x76, 0x05, 0xFF, 0xB0, 0x87, 0x3F, 0xE0,
  0x27, 0x60, 0x9F, 0xF9, 0x0D, 0x74, 0x0D, 0xFD, 0x0A, 0x76, 0x06, 0xFF, 0x90, 0x57, 0x40, 0x9F,
  0xE0, 0x67, 0x40, 0x8F, 0xFA, 0x0C, 0x74, 0x05, 0xFF, 0x07, 0x71, 0x04, 0x0D, 0xFF, 0xC0, 0xB7,
  0x40, 0xEF, 0xF8, 0x6D, 0x74, 0x23, 0x58, 0xDF, 0xFF, 0x09, 0x73, 0x09, 0x80, 0xD0, 0xF0, 0x77,
  0x20, 0x28, 0x0D, 0x1F, 0x05, 0x72, 0x08, 0x80, 0xD1, 0xF0, 0x37, 0x20, 0xC8, 0x0D, 0x0F, 0x0E,
  0x02, 0x71, 0x02, 0x0E, 0xFF, 0xFF, 0x90, 0xBF, 0xF0, 0xD0, 0x17, 0x10, 0x30, 0xEF, 0xFF, 0xD8,
  0x2E, 0x60, 0x5F, 0xF0, 0xC7, 0x20, 0x20, 0xCF, 0xFF, 0xB0, 0xA0, 0x13, 0x08, 0xFF, 0x0A, 0x73,
  0x07, 0x0E, 0xFF, 0xE0, 0xA0, 0x26, 0x0A, 0xFF, 0x08, 0x73, 0x81, 0x17, 0xDF, 0xF9, 0x81, 0xC7,
  0x17, 0x20, 0xCF, 0xF0, 0x67, 0x58, 0x42, 0x69, 0xBD, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x77,
  0x70,
  // "'" (U+0027)
  0x04, 0xFD, 0x05, 0x03, 0xFD, 0x03, 0x02, 0xFD, 0x02, 0x1F, 0xD0, 0x11, 0xFD, 0x20, 0xEF, 0xB0,
  0xE2, 0x0C, 0xFB, 0x0D, 0x20, 0xBF, 0xB0, 0xC2, 0x0A, 0xFB, 0x0A, 0x20, 0x9F, 0xB0, 0x92, 0x08,
  0xFB, 0x08, 0x20, 0x7F, 0xB0, 0x72, 0x06, 0xFB, 0x06, 0x20, 0x4F, 0xB0, 0x42, 0x03, 0xFB, 0x03,
  0x20, 0x2F, 0xB0, 0x22, 0x01, 0xFB, 0x01, 0x3F, 0xB4, 0x0E, 0xF9, 0x0E, 0x40, 0xDF, 0x90, 0xD4,
  0x0C, 0xF9, 0x0B, 0x40, 0xBF, 0x90, 0xA4, 0x0A, 0xF9, 0x09, 0x20,
  // "(" (U+0028)
  0x75, 0x0D, 0xFA, 0x0D, 0x74, 0x08, 0xFB, 0x04, 0x73, 0x03, 0xFB, 0x0A, 0x74, 0x0D, 0xFA, 0x0E,
  0x01, 0x73, 0x08, 0xFB, 0x06, 0x73, 0x02, 0xFB, 0x0D, 0x74, 0x0A, 0xFB, 0x05, 0x73, 0x03, 0xFB,
  0x0C, 0x74, 0x0C, 0xFB, 0x04, 0x73, 0x04, 0xFB, 0x0C, 0x74, 0x0B, 0xFB, 0x05, 0x73, 0x02, 0xFB,
  0x0E, 0x74, 0x0A, 0xFB, 0x07, 0x73, 0x01, 0xFC, 0x01, 0x73, 0x06, 0xFB, 0x0B, 0x74, 0x0C, 0xFB,
  0x05, 0x73, 0x02, 0xFC, 0x01, 0x73, 0x08, 0xFB, 0x0A, 0x74, 0x0D, 0xFB, 0x05, 0x73, 0x02, 0xFC,
  0x01, 0x73, 0x06, 0xFB, 0x0D, 0x74, 0x0B, 0xFB, 0x09, 0x74, 0x0E, 0xFB, 0x05, 0x73, 0x03, 0xFC,
  0x01, 0x73, 0x06, 0xFB, 0x0D, 0x74, 0x09, 0xFB, 0x0B, 0x74, 0x0C, 0xFB, 0x08, 0x74, 0xFC, 0x05,
  0x73, 0x03, 0xFC, 0x03, 0x73, 0x05, 0xFC, 0x74, 0x06, 0xFB, 0x0E, 0x74, 0x08, 0xFB, 0x0D, 0x74,
  0x0A, 0xFB, 0x0B, 0x74, 0x0C, 0xFB, 0x0A, 0x74, 0x0D, 0xFB, 0x08, 0x74, 0x0D, 0xFB, 0x08, 0x74,
  0x0E, 0xFB, 0x07, 0x74, 0x0E, 0xFB, 0x07, 0x74, 0xFC, 0x06, 0x74, 0xFC, 0x06, 0x74, 0xFC, 0x06,
  0x74, 0xFC, 0x07, 0x74, 0x0E, 0xFB, 0x07, 0x74, 0x0E, 0xFB, 0x08, 0x74, 0x0D, 0xFB, 0x08, 0x74,
  0x0D, 0xFB, 0x09, 0x74, 0x0B, 0xFB, 0x0B, 0x74, 0x09, 0xFB, 0x0C, 0x74, 0x08, 0xFB, 0x0E, 0x74,
  0x06, 0xFC, 0x74, 0x04, 0xFC, 0x02, 0x73, 0x02, 0xFC, 0x05, 0x74, 0x0E, 0xFB, 0x08, 0x74, 0x0C,
  0xFB, 0x0B, 0x74, 0x09, 0xFB, 0x0E, 0x74, 0x06, 0xFC, 0x01, 0x73, 0x03, 0xFC, 0x05, 0x74, 0x0E,
  0xFB, 0x09, 0x74, 0x09, 0xFB, 0x0D, 0x74, 0x05, 0xFC, 0x02, 0x73, 0x01, 0xFC, 0x06, 0x74, 0x0B,
  0xFB, 0x0C, 0x74, 0x06, 0xFC, 0x02, 0x74, 0xFC, 0x07, 0x74, 0x0A, 0xFB, 0x0C, 0x74, 0x04, 0xFC,
  0x03, 0x74, 0x0D, 0xFB, 0x09, 0x74, 0x06, 0xFC, 0x01, 0x74, 0x0D, 0xFB, 0x07, 0x74, 0x06, 0xFB,
  0x0D, 0x75, 0x0E, 0xFB, 0x05, 0x74, 0x06, 0xFB, 0x0D, 0x75, 0x0C, 0xFB, 0x06, 0x74, 0x03, 0xFB,
  0x0D, 0x75, 0x0A, 0xFB, 0x07, 0x74, 0x01, 0x0E, 0xFA, 0x0E, 0x01, 0x74, 0x04, 0xFB, 0x0A, 0x75,
  0x09, 0xFB, 0x04, 0x75, 0x0D, 0xFA, 0x0D,
  // ")" (U+0029)
  0x01, 0x0E, 0xFA, 0x0A, 0x76, 0x06, 0xFB, 0x05, 0x76, 0x0C, 0xFA, 0x0E, 0x01, 0x75, 0x03, 0xFB,
  0x0B, 0x76, 0x08, 0xFB, 0x06, 0x75, 0x01, 0x0E, 0xFA, 0x0E, 0x76, 0x07, 0xFB, 0x08, 0x76, 0x0E,
  0xFB, 0x02, 0x75, 0x07, 0xFB, 0x0A, 0x76, 0x0E, 0xFB, 0x02, 0x75, 0x08, 0xFB, 0x09, 0x75, 0x02,
  0xFC, 0x01, 0x75, 0x0B, 0xFB, 0x08, 0x75, 0x04, 0xFB, 0x0E, 0x76, 0x0E, 0xFB, 0x04, 0x75, 0x09,
  0xFB, 0x0A, 0x75, 0x03, 0xFC, 0x01, 0x75, 0x0D, 0xFB, 0x06, 0x75, 0x09, 0xFB, 0x0B, 0x75, 0x04,
  0xFC, 0x75, 0x01, 0xFC, 0x04, 0x75, 0x0C, 0xFB, 0x09, 0x75, 0x08, 0xFB, 0x0D, 0x75, 0x04, 0xFC,
  0x01, 0x74, 0x01, 0xFC, 0x04, 0x75, 0x0E, 0xFB, 0x07, 0x75, 0x0B, 0xFB, 0x0B, 0x75, 0x09, 0xFB,
  0x0E, 0x75, 0x06, 0xFC, 0x01, 0x74, 0x04, 0xFC, 0x03, 0x74, 0x02, 0xFC, 0x05, 0x74, 0x01, 0xFC,
  0x06, 0x75, 0x0E, 0xFB, 0x08, 0x75, 0x0D, 0xFB, 0x0A, 0x75, 0x0B, 0xFB, 0x0B, 0x75, 0x0B, 0xFB,
  0x0C, 0x75, 0x0A, 0xFB, 0x0C, 0x75, 0x0A, 0xFB, 0x0D, 0x75, 0x09, 0xFB, 0x0D, 0x75, 0x09, 0xFB,
  0x0E, 0x75, 0x09, 0xFB, 0x0E, 0x75, 0x0A, 0xFB, 0x0D, 0x75, 0x0A, 0xFB, 0x0D, 0x75, 0x0B, 0xFB,
  0x0C, 0x75, 0x0B, 0xFB, 0x0B, 0x75, 0x0C, 0xFB, 0x0B, 0x75, 0x0E, 0xFB, 0x09, 0x75, 0xFC, 0x07,
  0x74, 0x02, 0xFC, 0x06, 0x74, 0x04, 0xFC, 0x04, 0x74, 0x05, 0xFC, 0x02, 0x74, 0x08, 0xFC, 0x75,
  0x0B, 0xFB, 0x0C, 0x75, 0x0E, 0xFB, 0x09, 0x74, 0x01, 0xFC, 0x06, 0x74, 0x04, 0xFC, 0x03, 0x74,
  0x08, 0xFC, 0x75, 0x0D, 0xFB, 0x0B, 0x74, 0x01, 0xFC, 0x07, 0x74, 0x05, 0xFC, 0x02, 0x74, 0x0A,
  0xFB, 0x0D, 0x75, 0x0E, 0xFB, 0x09, 0x74, 0x05, 0xFC, 0x03, 0x74, 0x0A, 0xFB, 0x0D, 0x75, 0xFC,
  0x07, 0x74, 0x06, 0xFC, 0x01, 0x74, 0x0C, 0xFB, 0x0A, 0x74, 0x03, 0xFC, 0x03, 0x74, 0x0A, 0xFB,
  0x0B, 0x74, 0x01, 0xFC, 0x04, 0x74, 0x09, 0xFB, 0x0C, 0x74, 0x01, 0xFC, 0x03, 0x74, 0x09, 0xFB,
  0x0A, 0x74, 0x02, 0xFB, 0x0E, 0x01, 0x74, 0x0A, 0xFB, 0x07, 0x74, 0x03, 0xFB, 0x0C, 0x75, 0x0C,
  0xFA, 0x0E, 0x02, 0x74, 0x07, 0xFB, 0x06, 0x74, 0x01, 0x0E, 0xFA, 0x0A, 0x75,
  // "*" (U+002A)
  0x76, 0x03, 0xFB, 0x0E, 0x77, 0x76, 0x01, 0xFB, 0x0C, 0x77, 0x77, 0x0E, 0xFA, 0x0A, 0x77, 0x77,
  0x0D, 0xFA, 0x08, 0x77, 0x77, 0x0B, 0xFA, 0x06, 0x77, 0x77, 0x09, 0xFA, 0x04, 0x77, 0x77, 0x07,
  0xFA, 0x03, 0x77, 0x77, 0x05, 0xFA, 0x01, 0x77, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x30, 0x40, 0x37,
  0x30, 0x2F, 0x90, 0xC7, 0x40, 0x40, 0x34, 0x83, 0xCF, 0xD8, 0x37, 0x1F, 0x90, 0xA7, 0x18, 0x34,
  0x9E, 0xF8, 0x4D, 0x81, 0xD8, 0x35, 0x0D, 0xF0, 0x85, 0x81, 0x4A, 0xEC, 0x0B, 0x30, 0x3F, 0x98,
  0x1D, 0x83, 0x20, 0xCF, 0x07, 0x28, 0x15, 0xAE, 0xF0, 0xE3, 0x07, 0xFC, 0x81, 0xD8, 0xCF, 0x81,
  0x9A, 0xEF, 0xC0, 0x22, 0x0A, 0xFF, 0xFF, 0xF0, 0x52, 0x0D, 0xFF, 0xFF, 0xF8, 0x19, 0x01, 0x80,
  0xC0, 0xF8, 0x1C, 0x04, 0x80, 0xC1, 0xF1, 0x08, 0x80, 0xC1, 0xF0, 0x30, 0xB8, 0x0C, 0x1F, 0x89,
  0x15, 0x02, 0x35, 0x68, 0x9A, 0xCD, 0xFF, 0xC8, 0x7E, 0xCB, 0x98, 0x65, 0x31, 0x76, 0x01, 0x09,
  0xFE, 0x04, 0x77, 0x72, 0x04, 0xFF, 0x0D, 0x77, 0x71, 0x02, 0x0E, 0xFF, 0x90, 0xB7, 0x76, 0x01,
  0x0D, 0xFF, 0xB0, 0x87, 0x75, 0x0B, 0xFF, 0xD0, 0x57, 0x73, 0x09, 0xFA, 0x0D, 0x06, 0xFB, 0x03,
  0x77, 0x10, 0x6F, 0xB8, 0x15, 0x0D, 0xFA, 0x0E, 0x01, 0x76, 0x04, 0xFB, 0x0D, 0x20, 0x5F, 0xB0,
  0xC7, 0x50, 0x20, 0xEF, 0xB0, 0x63, 0x0C, 0xFB, 0x0A, 0x74, 0x0C, 0xFB, 0x0D, 0x40, 0x4F, 0xC0,
  0x87, 0x20, 0xAF, 0xC0, 0x65, 0x0C, 0xFC, 0x05, 0x71, 0x07, 0x0E, 0xFA, 0x0D, 0x60, 0x3F, 0xB0,
  0xD0, 0x37, 0x20, 0x20, 0xBF, 0x90, 0x67, 0x0B, 0xF9, 0x07, 0x76, 0x05, 0x0E, 0xD0, 0xD7, 0x10,
  0x3E, 0x0B, 0x02, 0x77, 0x10, 0x10, 0x9C, 0x06, 0x72, 0x0A, 0xB0, 0xE0, 0x67, 0x75, 0x82, 0x4D,
  0xFD, 0x73, 0x02, 0xA0, 0xA0, 0x17, 0x77, 0x10, 0x80, 0x67, 0x40, 0x80, 0x47, 0x50,
  // "+" (U+002B)
  0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77,
  0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02,
  0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA,
  0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07,
  0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77,
  0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C,
  0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0,
  0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x77, 0x02, 0xFA,
  0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07,
  0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77,
  0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77,
  0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02,
  0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA,
  0x07, 0x77,
  // "," (U+002C)
  0x30, 0x4F, 0xC0, 0xC4, 0x06, 0xFD, 0x01, 0x30, 0x7F, 0xC0, 0xD4, 0x09, 0xFC, 0x09, 0x40, 0xBF,
  0xC0, 0x64, 0x0D, 0xFC, 0x03, 0x4F, 0xD4, 0x02, 0xFC, 0x0B, 0x40, 0x4F, 0xC0, 0x74, 0x07, 0xFC,
  0x03, 0x40, 0x9F, 0xB0, 0xE5, 0x0C, 0xFB, 0x0B, 0x50, 0xEF, 0xB0, 0x64, 0x02, 0xFC, 0x02, 0x40,
  0x4F, 0xB0, 0xD5, 0x07, 0xFB, 0x08, 0x50, 0x9F, 0xB0, 0x35, 0x0C, 0xFA, 0x0D, 0x6F, 0xB0, 0x85,
  0x02, 0xFB, 0x03, 0x50, 0x5F, 0xA0, 0xC6, 0x09, 0xFA, 0x07, 0x60, 0xCF, 0xA0, 0x16, 0xFA, 0x0A,
  0x70,
  // "-" (U+002D)
  0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05,
  0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05,
  0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05, 0x06, 0xFF, 0xF9, 0x05,
  // "." (U+002E)
  0x48, 0x64, 0xAD, 0xEE, 0xD9, 0x35, 0x01, 0x0B, 0xF9, 0x0A, 0x40, 0xCF, 0xB0, 0xA2, 0x06, 0xFD,
  0x81, 0x40, 0xCF, 0xD0, 0xA0, 0x1F, 0xE0, 0xE0, 0x2F, 0xF0, 0x3F, 0xF0, 0x2F, 0xF1, 0xFE, 0x81,
  0xD0, 0xCF, 0xD8, 0x19, 0x05, 0xFD, 0x03, 0x20, 0xBF, 0xB0, 0x84, 0x0A, 0xF9, 0x08, 0x68, 0x64,
  0x9D, 0xFE, 0xD9, 0x33,
  // "/" (U+002F)
  0x77, 0x73, 0x01, 0xFB, 0x0C, 0x77, 0x73, 0x07, 0xFB, 0x06, 0x77, 0x73, 0x0D, 0xFB, 0x01, 0x77,
  0x72, 0x03, 0xFB, 0x0A, 0x77, 0x73, 0x09, 0xFB, 0x04, 0x77, 0x73, 0x0E, 0xFA, 0x0D, 0x77, 0x73,
  0x05, 0xFB, 0x08, 0x77, 0x73, 0x0B, 0xFB, 0x02, 0x77, 0x72, 0x02, 0xFB, 0x0B, 0x77, 0x73, 0x07,
  0xFB, 0x06, 0x77, 0x73, 0x0D, 0xFA, 0x0E, 0x77, 0x73, 0x04, 0xFB, 0x09, 0x77, 0x73, 0x0A, 0xFB,
  0x03, 0x77, 0x72, 0x01, 0xFB, 0x0D, 0x77, 0x73, 0x06, 0xFB, 0x07, 0x77, 0x73, 0x0C, 0xFB, 0x01,
  0x77, 0x72, 0x02, 0xFB, 0x0B, 0x77, 0x73, 0x08, 0xFB, 0x05, 0x77, 0x73, 0x0E, 0xFA, 0x0E, 0x77,
  0x73, 0x05, 0xFB, 0x09, 0x77, 0x73, 0x0A, 0xFB, 0x03, 0x77, 0x72, 0x01, 0xFB, 0x0C, 0x77, 0x73,
  0x07, 0xFB, 0x07, 0x77, 0x73, 0x0D, 0xFB, 0x01, 0x77, 0x72, 0x03, 0xFB, 0x0A, 0x77, 0x73, 0x09,
  0xFB, 0x04, 0x77, 0x73, 0x0E, 0xFA, 0x0E, 0x77, 0x73, 0x05, 0xFB, 0x08, 0x77, 0x73, 0x0B, 0xFB,
  0x02, 0x77, 0x72, 0x02, 0xFB, 0x0C, 0x77, 0x73, 0x08, 0xFB, 0x06, 0x77, 0x73, 0x0D, 0xFB, 0x01,
  0x77, 0x72, 0x04, 0xFB, 0x0A, 0x77, 0x73, 0x0A, 0xFB, 0x04, 0x77, 0x72, 0x01, 0xFB, 0x0D, 0x77,
  0x73, 0x06, 0xFB, 0x08, 0x77, 0x73, 0x0C, 0xFB, 0x02, 0x77, 0x72, 0x02, 0xFB, 0x0B, 0x77, 0x73,
  0x08, 0xFB, 0x05, 0x77, 0x73, 0x0E, 0xFA, 0x0E, 0x77, 0x73, 0x05, 0xFB, 0x09, 0x77, 0x73, 0x0B,
  0xFB, 0x03, 0x77, 0x72, 0x01, 0xFB, 0x0D, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x73, 0x0D, 0xFB,
  0x01, 0x77, 0x72, 0x03, 0xFB, 0x0B, 0x77, 0x73, 0x09, 0xFB, 0x05, 0x77, 0x73, 0x0E, 0xFA, 0x0E,
  0x77, 0x73, 0x05, 0xFB, 0x09, 0x77, 0x73, 0x0B, 0xFB, 0x03, 0x77, 0x72, 0x02, 0xFB, 0x0C, 0x77,
  0x73, 0x08, 0xFB, 0x06, 0x77, 0x73, 0x0D, 0xFB, 0x01, 0x77, 0x72, 0x04, 0xFB, 0x0A, 0x77, 0x73,
  0x0A, 0xFB, 0x04, 0x77, 0x72, 0x01, 0xFB, 0x0E, 0x77, 0x73, 0x06, 0xFB, 0x08, 0x77, 0x73, 0x0C,
  0xFB, 0x02, 0x77, 0x72, 0x02, 0xFB, 0x0C, 0x77, 0x73, 0x08, 0xFB, 0x06, 0x77, 0x73, 0x0E, 0xFB,
  0x01, 0x77, 0x72, 0x05, 0xFB, 0x0A, 0x77, 0x73, 0x0B, 0xFB, 0x04, 0x77, 0x72, 0x01, 0xFB, 0x0D,
  0x77, 0x73,
  // "0" (U+0030)
  0x76, 0x89, 0x21, 0x69, 0xCD, 0xEF, 0xED, 0xB8, 0x47, 0x77, 0x40, 0x40, 0xBF, 0xD8, 0x1E, 0x81,
  0x77, 0x60, 0x20, 0xBF, 0xFA, 0x0E, 0x06, 0x77, 0x40, 0x40, 0xEF, 0xFD, 0x0B, 0x77, 0x20, 0x5F,
  0xFF, 0x90, 0xC0, 0x17, 0x60, 0x3F, 0xFF, 0xB0, 0xB7, 0x50, 0x10, 0xEF, 0xFF, 0xC0, 0x87, 0x40,
  0xAF, 0xFF, 0xE0, 0x37, 0x20, 0x3F, 0xFF, 0xF0, 0xC7, 0x20, 0xBF, 0xFF, 0xF9, 0x05, 0x70, 0x3F,
  0xE8, 0x39, 0x42, 0x4B, 0xFD, 0x0D, 0x70, 0x9F, 0xD0, 0x55, 0x07, 0xFD, 0x04, 0x60, 0xEF, 0xC0,
  0x97, 0x0B, 0xFC, 0x0A, 0x50, 0x4F, 0xD0, 0x17, 0x02, 0xFD, 0x50, 0x9F, 0xC0, 0xA7, 0x20, 0xCF,
  0xC0, 0x44, 0x0D, 0xFC, 0x05, 0x72, 0x07, 0xFC, 0x09, 0x30, 0x1F, 0xD0, 0x17, 0x20, 0x3F, 0xC0,
  0xD3, 0x04, 0xFC, 0x0D, 0x74, 0xFD, 0x01, 0x20, 0x8F, 0xC0, 0xB7, 0x40, 0xCF, 0xC0, 0x52, 0x0A,
  0xFC, 0x08, 0x74, 0x0A, 0xFC, 0x07, 0x20, 0xDF, 0xC0, 0x67, 0x40, 0x8F, 0xC0, 0xA2, 0xFD, 0x05,
  0x74, 0x06, 0xFC, 0x81, 0xC0, 0x1F, 0xD0, 0x37, 0x40, 0x5F, 0xC8, 0x1E, 0x03, 0xFD, 0x02, 0x74,
  0x03, 0xFD, 0x01, 0x04, 0xFD, 0x01, 0x74, 0x02, 0xFD, 0x02, 0x06, 0xFD, 0x75, 0x01, 0xFD, 0x04,
  0x07, 0xFD, 0x75, 0x01, 0xFD, 0x05, 0x08, 0xFC, 0x0E, 0x76, 0xFD, 0x06, 0x08, 0xFC, 0x0D, 0x76,
  0xFD, 0x07, 0x09, 0xFC, 0x0D, 0x76, 0xFD, 0x07, 0x09, 0xFC, 0x0D, 0x76, 0x0E, 0xFC, 0x08, 0x0A,
  0xFC, 0x0D, 0x76, 0x0E, 0xFC, 0x08, 0x0A, 0xFC, 0x0D, 0x76, 0x0E, 0xFC, 0x08, 0x0A, 0xFC, 0x0D,
  0x76, 0x0E, 0xFC, 0x08, 0x0A, 0xFC, 0x0D, 0x76, 0x0E, 0xFC, 0x08, 0x09, 0xFC, 0x0D, 0x76, 0xFD,
  0x08, 0x09, 0xFC, 0x0D, 0x76, 0xFD, 0x07, 0x09, 0xFC, 0x0E, 0x76, 0xFD, 0x07, 0x08, 0xFC, 0x0E,
  0x76, 0xFD, 0x06, 0x07, 0xFD, 0x75, 0x01, 0xFD, 0x05, 0x06, 0xFD, 0x75, 0x02, 0xFD, 0x00, 0x4F,
  0xD0, 0x17, 0x40, 0x3F, 0xD0, 0x03, 0xFD, 0x02, 0x74, 0x04, 0xFD, 0x00, 0x1F, 0xD0, 0x47, 0x40,
  0x6F, 0xD2, 0xFD, 0x05, 0x74, 0x07, 0xFC, 0x0D, 0x20, 0xDF, 0xC0, 0x77, 0x40, 0x9F, 0xC0, 0xB2,
  0x0A, 0xFC, 0x0A, 0x74, 0x0B, 0xFC, 0x08, 0x20, 0x8F, 0xC0, 0xC7, 0x40, 0xEF, 0xC0, 0x52, 0x04,
  0xFD, 0x73, 0x02, 0xFD, 0x02, 0x20, 0x1F, 0xD0, 0x37, 0x20, 0x5F, 0xC0, 0xE4, 0x0D, 0xFC, 0x08,
  0x72, 0x0A, 0xFC, 0x0B, 0x40, 0x9F, 0xC0, 0xD7, 0x10, 0x1F, 0xD0, 0x74, 0x04, 0xFD, 0x06, 0x70,
  0x9F, 0xD0, 0x25, 0x0E, 0xFC, 0x0E, 0x02, 0x50, 0x5F, 0xD0, 0xD6, 0x09, 0xFD, 0x84, 0xE6, 0x10,
  0x28, 0xFE, 0x07, 0x60, 0x2F, 0xFF, 0xFB, 0x01, 0x70, 0xAF, 0xFF, 0xF9, 0x09, 0x71, 0x03, 0xFF,
  0xFF, 0x0E, 0x02, 0x72, 0x09, 0xFF, 0xFE, 0x07, 0x74, 0x0D, 0xFF, 0xFC, 0x0C, 0x75, 0x02, 0x0E,
  0xFF, 0xFA, 0x0E, 0x02, 0x76, 0x04, 0x0E, 0xFF, 0xF9, 0x03, 0x77, 0x10, 0x30, 0xEF, 0xFD, 0x0E,
  0x03, 0x77, 0x30, 0x10, 0xAF, 0xFB, 0x0B, 0x01, 0x77, 0x60, 0x30, 0xAF, 0xE0, 0xB0, 0x47, 0x77,
  0x38, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0x96, 0x17, 0x60,
  // "1" (U+0031)
  0x77, 0x40, 0x9F, 0xB0, 0xA7, 0x73, 0x09, 0xFC, 0x0A, 0x77, 0x20, 0xAF, 0xD0, 0xA7, 0x71, 0x0A,
  0xFE, 0x0A, 0x77, 0x0A, 0xFF, 0x0A, 0x76, 0x0A, 0xFF, 0x90, 0xA7, 0x50, 0xAF, 0xFA, 0x0A, 0x74,
  0x0A, 0xFF, 0xB0, 0xA7, 0x30, 0xAF, 0xFC, 0x0A, 0x72, 0x0A, 0xFF, 0xD0, 0xA7, 0x10, 0xAF, 0xFE,
  0x0A, 0x70, 0xAF, 0xFF, 0x0A, 0x60, 0xAF, 0xFF, 0x90, 0xA5, 0x0A, 0xFF, 0xFA, 0x0A, 0x40, 0xBF,
  0xFF, 0xB0, 0xA3, 0x0B, 0xFE, 0x0D, 0xFC, 0x0A, 0x20, 0xBF, 0xE0, 0xA0, 0x8F, 0xC8, 0x1A, 0x0B,
  0xFE, 0x81, 0xB0, 0x8F, 0xC8, 0x1A, 0x2E, 0xFD, 0x0C, 0x20, 0x9F, 0xC8, 0x2A, 0x02, 0xEF, 0xB0,
  0xC0, 0x12, 0x09, 0xFC, 0x0A, 0x20, 0x30, 0xEF, 0x90, 0xB4, 0x0A, 0xFC, 0x0A, 0x30, 0x4F, 0x0B,
  0x50, 0xBF, 0xC0, 0xA4, 0x04, 0xD0, 0xA6, 0x0B, 0xFC, 0x0A, 0x50, 0x5B, 0x09, 0x70, 0xCF, 0xC0,
  0xA6, 0x81, 0x6F, 0x87, 0x10, 0xCF, 0xC0, 0xA7, 0x03, 0x72, 0x0C, 0xFC, 0x0A, 0x77, 0x30, 0xDF,
  0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77,
  0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC,
  0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73,
  0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0,
  0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30,
  0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A,
  0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D,
  0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7,
  0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF,
  0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A, 0x77,
  0x30, 0xDF, 0xC0, 0xA7, 0x73, 0x0D, 0xFC, 0x0A,
  // "2" (U+0032)
  0x75, 0x89, 0x41, 0x58, 0xBD, 0xEE, 0xFE, 0xDC, 0x97, 0x37, 0x77, 0x18, 0x11, 0x7D, 0xFF, 0x81,
  0xD7, 0x17, 0x73, 0x01, 0x09, 0xFF, 0xE0, 0x87, 0x71, 0x07, 0x0E, 0xFF, 0xF9, 0x0D, 0x03, 0x74,
  0x02, 0x0C, 0xFF, 0xFC, 0x0E, 0x05, 0x72, 0x04, 0x0E, 0xFF, 0xFF, 0x04, 0x70, 0x6F, 0xFF, 0xFA,
  0x0E, 0x03, 0x50, 0x7F, 0xFF, 0xFC, 0x0C, 0x40, 0x10, 0xEF, 0xFF, 0xFD, 0x07, 0x40, 0x5F, 0xFF,
  0xFD, 0x0E, 0x50, 0x8F, 0xC8, 0x6D, 0x85, 0x32, 0x47, 0xCF, 0xF0, 0x65, 0x0B, 0xF9, 0x0C, 0x04,
  0x71, 0x07, 0xFE, 0x0C, 0x50, 0x10, 0xEE, 0x07, 0x74, 0x06, 0xFE, 0x01, 0x50, 0x3C, 0x0E, 0x04,
  0x76, 0x0C, 0xFD, 0x04, 0x60, 0x7A, 0x0D, 0x02, 0x77, 0x06, 0xFD, 0x07, 0x78, 0x1A, 0xD2, 0x77,
  0x10, 0x2F, 0xD0, 0x97, 0x10, 0x27, 0x73, 0xFD, 0x09, 0x77, 0x75, 0x0E, 0xFC, 0x0A, 0x77, 0x75,
  0xFD, 0x09, 0x77, 0x75, 0xFD, 0x09, 0x77, 0x74, 0x01, 0xFD, 0x07, 0x77, 0x74, 0x05, 0xFD, 0x05,
  0x77, 0x74, 0x08, 0xFD, 0x03, 0x77, 0x74, 0x0C, 0xFD, 0x77, 0x74, 0x02, 0xFD, 0x0B, 0x77, 0x74,
  0x08, 0xFD, 0x07, 0x77, 0x73, 0x01, 0x0E, 0xFD, 0x02, 0x77, 0x73, 0x08, 0xFD, 0x0B, 0x77, 0x73,
  0x02, 0xFE, 0x04, 0x77, 0x73, 0x0A, 0xFD, 0x0D, 0x77, 0x73, 0x05, 0xFE, 0x05, 0x77, 0x72, 0x01,
  0x0E, 0xFD, 0x0B, 0x77, 0x73, 0x0A, 0xFE, 0x03, 0x77, 0x72, 0x06, 0xFE, 0x08, 0x77, 0x72, 0x02,
  0x0E, 0xFD, 0x0C, 0x77, 0x73, 0x0C, 0xFE, 0x02, 0x77, 0x72, 0x09, 0xFE, 0x06, 0x77, 0x72, 0x06,
  0xFE, 0x0A, 0x77, 0x72, 0x03, 0xFE, 0x0D, 0x77, 0x72, 0x01, 0x0D, 0xFD, 0x0E, 0x02, 0x77, 0x72,
  0x0B, 0xFE, 0x04, 0x77, 0x72, 0x08, 0xFE, 0x06, 0x77, 0x72, 0x04, 0xFE, 0x09, 0x77, 0x72, 0x02,
  0x0E, 0xFD, 0x0B, 0x77, 0x73, 0x0C, 0xFD, 0x0D, 0x77, 0x73, 0x0A, 0xFD, 0x0E, 0x02, 0x77, 0x72,
  0x07, 0xFE, 0x04, 0x77, 0x72, 0x03, 0xFE, 0x06, 0x77, 0x72, 0x01, 0x0E, 0xFD, 0x09, 0x77, 0x73,
  0x0C, 0xFD, 0x0B, 0x77, 0x73, 0x09, 0xFD, 0x0D, 0x01, 0x77, 0x72, 0x05, 0xFD, 0x0E, 0x02, 0x77,
  0x72, 0x03, 0xFE, 0x05, 0x77, 0x72, 0x01, 0x0D, 0xFD, 0x07, 0x77, 0x73, 0x0B, 0xFF, 0xFF, 0xF8,
  0x1D, 0x08, 0x80, 0xC0, 0xF0, 0xD0, 0x18, 0x0C, 0x1F, 0x0D, 0x01, 0x80, 0xC1, 0xF0, 0xD0, 0x18,
  0x0C, 0x1F, 0x0D, 0x01, 0x80, 0xC1, 0xF0, 0xD0, 0x18, 0x0C, 0x1F, 0x0D, 0x01, 0x80, 0xC1, 0xF0,
  0xD0, 0x18, 0x0C, 0x1F, 0x0D, 0x01, 0x80, 0xC1, 0xF0, 0xD0, 0x18, 0x0C, 0x1F, 0x0D,
  // "3" (U+0033)
  0x73, 0x85, 0x25, 0x8A, 0xCD, 0xEB, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x68, 0x13, 0x9D, 0xFF, 0xA0,
  0xC0, 0x67, 0x72, 0x06, 0x0D, 0xFF, 0xF0, 0xE0, 0x77, 0x50, 0x50, 0xDF, 0xFF, 0xC0, 0xC0, 0x27,
  0x10, 0x20, 0xCF, 0xFF, 0xF0, 0xE0, 0x36, 0x06, 0xFF, 0xFF, 0xB0, 0xE0, 0x35, 0x07, 0xFF, 0xFF,
  0xC0, 0xD0, 0x15, 0x0D, 0xFF, 0xFF, 0xC0, 0x95, 0x04, 0xFF, 0xFF, 0xD0, 0x25, 0x0B, 0xFF, 0xFF,
  0xC0, 0x85, 0x02, 0xFA, 0x87, 0xB7, 0x53, 0x23, 0x47, 0xCF, 0xF0, 0xE6, 0x08, 0xE0, 0x80, 0x17,
  0x20, 0x50, 0xEF, 0xE0, 0x25, 0x01, 0x0E, 0xB0, 0xA0, 0x17, 0x50, 0x3F, 0xE0, 0x66, 0x82, 0x6F,
  0xE4, 0x77, 0x10, 0x8F, 0xD0, 0x87, 0x09, 0x01, 0x77, 0x20, 0x1F, 0xD0, 0x97, 0x77, 0x50, 0xDF,
  0xC0, 0xA7, 0x77, 0x50, 0xBF, 0xC0, 0xA7, 0x77, 0x50, 0xAF, 0xC0, 0x97, 0x77, 0x50, 0xBF, 0xC0,
  0x77, 0x77, 0x50, 0xCF, 0xC0, 0x47, 0x77, 0x40, 0x1F, 0xD0, 0x17, 0x77, 0x40, 0x6F, 0xC0, 0xC7,
  0x77, 0x50, 0xEF, 0xC0, 0x57, 0x77, 0x40, 0xAF, 0xC0, 0xD7, 0x77, 0x40, 0x9F, 0xD0, 0x47, 0x77,
  0x20, 0x50, 0xDF, 0xD0, 0x97, 0x74, 0x84, 0x11, 0x36, 0x9E, 0xFE, 0x0B, 0x77, 0x0B, 0xFF, 0xF9,
  0x0B, 0x77, 0x10, 0xBF, 0xFF, 0x08, 0x77, 0x20, 0xBF, 0xFD, 0x0C, 0x04, 0x77, 0x30, 0xBF, 0xFB,
  0x0C, 0x05, 0x77, 0x50, 0xBF, 0xFA, 0x05, 0x77, 0x70, 0xBF, 0xFB, 0x81, 0xEA, 0x57, 0x74, 0x0B,
  0xFF, 0xE0, 0xE0, 0x87, 0x72, 0x0B, 0xFF, 0xF9, 0x0D, 0x04, 0x77, 0x0B, 0xFF, 0xFB, 0x07, 0x76,
  0x0B, 0xFF, 0xFC, 0x08, 0x75, 0x89, 0x11, 0x22, 0x22, 0x33, 0x57, 0x9D, 0xFF, 0xA0, 0x57, 0x77,
  0x18, 0x12, 0x8E, 0xFE, 0x0E, 0x01, 0x77, 0x72, 0x02, 0x0C, 0xFE, 0x08, 0x77, 0x73, 0x01, 0x0D,
  0xFD, 0x0E, 0x77, 0x74, 0x03, 0xFE, 0x05, 0x77, 0x74, 0x0B, 0xFD, 0x09, 0x77, 0x74, 0x06, 0xFD,
  0x0C, 0x77, 0x74, 0x02, 0xFD, 0x0E, 0x77, 0x74, 0x01, 0xFE, 0x77, 0x75, 0xFE, 0x01, 0x77, 0x73,
  0x01, 0xFE, 0x01, 0x77, 0x73, 0x03, 0xFE, 0x77, 0x74, 0x06, 0xFD, 0x0E, 0x77, 0x74, 0x0B, 0xFD,
  0x81, 0xC0, 0x17, 0x77, 0x10, 0x3F, 0xE8, 0x3A, 0x0D, 0x81, 0x77, 0x60, 0xCF, 0xE8, 0x16, 0x0E,
  0xA0, 0x90, 0x37, 0x73, 0x0A, 0xFF, 0x81, 0x10, 0xEC, 0x81, 0xD7, 0x27, 0x50, 0x50, 0xDF, 0xF0,
  0xB2, 0x0E, 0xF8, 0x92, 0xEA, 0x75, 0x32, 0x23, 0x46, 0x9D, 0xFF, 0xA0, 0x42, 0x0E, 0xFF, 0xFF,
  0xE0, 0xC3, 0x0E, 0xFF, 0xFF, 0xE0, 0x33, 0x0E, 0xFF, 0xFF, 0xD0, 0x74, 0x0E, 0xFF, 0xFF, 0xC0,
  0xA5, 0x0E, 0xFF, 0xFF, 0xB0, 0xA6, 0x0E, 0xFF, 0xFF, 0xA0, 0x87, 0x0E, 0xFF, 0xFF, 0x0D, 0x04,
  0x71, 0x81, 0x17, 0xDF, 0xFF, 0xB0, 0xE0, 0x77, 0x68, 0x13, 0x8C, 0xFF, 0xC8, 0x1E, 0xA5, 0x77,
  0x58, 0x63, 0x68, 0xAC, 0xDD, 0xEA, 0x85, 0xEE, 0xDB, 0x96, 0x37, 0x71,
  // "4" (U+0034)
  0x77, 0x72, 0x08, 0xFC, 0x0E, 0x77, 0x77, 0x10, 0x1F, 0xD0, 0xE7, 0x77, 0x71, 0x0A, 0xFD, 0x0E,
  0x77, 0x77, 0x03, 0xFE, 0x0E, 0x77, 0x77, 0x0B, 0xFE, 0x0E, 0x77, 0x76, 0x05, 0xFF, 0x0E, 0x77,
  0x76, 0x0D, 0xFF, 0x0E, 0x77, 0x75, 0x07, 0xFF, 0x90, 0xE7, 0x77, 0x40, 0x10, 0xEF, 0xF9, 0x0E,
  0x77, 0x74, 0x09, 0xFF, 0xA0, 0xE7, 0x77, 0x30, 0x2F, 0xFB, 0x0E, 0x77, 0x73, 0x0A, 0xFF, 0xB0,
  0xE7, 0x77, 0x20, 0x4F, 0xFC, 0x0E, 0x77, 0x72, 0x0C, 0xFF, 0xC0, 0xE7, 0x77, 0x10, 0x6F, 0xFD,
  0x0E, 0x77, 0x71, 0x0D, 0xFF, 0xD0, 0xE7, 0x77, 0x07, 0xF9, 0x09, 0xFC, 0x0E, 0x77, 0x60, 0x10,
  0xEF, 0x90, 0x4F, 0xC0, 0xE7, 0x76, 0x09, 0xF9, 0x0B, 0x02, 0xFC, 0x0E, 0x77, 0x50, 0x3F, 0xA0,
  0x40, 0x3F, 0xC0, 0xE7, 0x75, 0x0B, 0xF9, 0x81, 0xC0, 0x3F, 0xC0, 0xE7, 0x74, 0x04, 0xFA, 0x81,
  0x40, 0x4F, 0xC0, 0xE7, 0x74, 0x0D, 0xF9, 0x0C, 0x20, 0x4F, 0xC0, 0xE7, 0x73, 0x06, 0xFA, 0x04,
  0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x01, 0x0E, 0xF9, 0x0B, 0x30, 0x5F, 0xC0, 0xE7, 0x72, 0x08, 0xFA,
  0x03, 0x30, 0x6F, 0xC0, 0xE7, 0x71, 0x02, 0xFA, 0x0A, 0x40, 0x6F, 0xC0, 0xE7, 0x71, 0x0A, 0xFA,
  0x02, 0x40, 0x6F, 0xC0, 0xE7, 0x70, 0x3F, 0xA0, 0x95, 0x06, 0xFC, 0x0E, 0x77, 0x0C, 0xF9, 0x0E,
  0x01, 0x50, 0x6F, 0xC0, 0xE7, 0x60, 0x5F, 0xA0, 0x76, 0x06, 0xFC, 0x0E, 0x76, 0x0D, 0xF9, 0x0E,
  0x70, 0x6F, 0xC0, 0xE7, 0x50, 0x7F, 0xA0, 0x67, 0x06, 0xFC, 0x0E, 0x74, 0x01, 0x0E, 0xF9, 0x0D,
  0x71, 0x06, 0xFC, 0x0E, 0x74, 0x09, 0xFA, 0x05, 0x71, 0x06, 0xFC, 0x0E, 0x73, 0x02, 0xFA, 0x0C,
  0x72, 0x06, 0xFC, 0x0E, 0x73, 0x0B, 0xFA, 0x04, 0x72, 0x06, 0xFC, 0x0E, 0x72, 0x04, 0xFA, 0x0B,
  0x73, 0x06, 0xFC, 0x0E, 0x72, 0x0C, 0xFA, 0x03, 0x73, 0x06, 0xFC, 0x0E, 0x71, 0x06, 0xFA, 0x0A,
  0x74, 0x06, 0xFC, 0x0E, 0x71, 0x0E, 0xFA, 0x05, 0x80, 0x72, 0x08, 0xFC, 0x0E, 0x80, 0x22, 0x01,
  0x06, 0x80, 0xC5, 0xF0, 0xB0, 0x78, 0x0C, 0x5F, 0x0B, 0x07, 0x80, 0xC5, 0xF0, 0xB0, 0x78, 0x0C,
  0x5F, 0x0B, 0x07, 0x80, 0xC5, 0xF0, 0xB0, 0x78, 0x0C, 0x5F, 0x0B, 0x07, 0x80, 0xC5, 0xF0, 0xB0,
  0x78, 0x0C, 0x5F, 0x0B, 0x07, 0x80, 0xC5, 0xF0, 0xB0, 0x78, 0x0C, 0x5F, 0x0B, 0x77, 0x72, 0x05,
  0xFC, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x77, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x77, 0x20,
  0x5F, 0xC0, 0xE7, 0x77, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x77, 0x72,
  0x05, 0xFC, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x77, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x77,
  0x20, 0x5F, 0xC0, 0xE7, 0x77, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x77,
  0x72, 0x05, 0xFC, 0x0E, 0x70,
  // "5" (U+0035)
  0x30, 0xAF, 0xFF, 0xF9, 0x05, 0x60, 0xBF, 0xFF, 0xF9, 0x05, 0x60, 0xCF, 0xFF, 0xF9, 0x05, 0x60,
  0xDF, 0xFF, 0xF9, 0x05, 0x60, 0xEF, 0xFF, 0xF9, 0x05, 0x6F, 0xFF, 0xFA, 0x05, 0x6F, 0xFF, 0xFA,
  0x05, 0x50, 0x1F, 0xFF, 0xFA, 0x05, 0x50, 0x2F, 0xFF, 0xFA, 0x05, 0x50, 0x3F, 0xFF, 0xFA, 0x05,
  0x50, 0x4F, 0xFF, 0xFA, 0x05, 0x50, 0x5F, 0xB0, 0xE7, 0x77, 0x40, 0x6F, 0xB0, 0xD7, 0x77, 0x40,
  0x7F, 0xB0, 0xC7, 0x77, 0x40, 0x8F, 0xB0, 0xB7, 0x77, 0x40, 0x9F, 0xB0, 0xA7, 0x77, 0x40, 0xAF,
  0xB0, 0x97, 0x77, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x40, 0xCF, 0xB0, 0x67, 0x77, 0x40, 0xDF, 0xB0,
  0x57, 0x77, 0x40, 0xEF, 0xB0, 0x47, 0x77, 0x4F, 0xC0, 0x37, 0x77, 0x30, 0x1F, 0xC0, 0x17, 0x77,
  0x30, 0x2F, 0xC8, 0x93, 0x24, 0x8B, 0xCD, 0xFE, 0xDC, 0x96, 0x17, 0x50, 0x3F, 0xFF, 0xB0, 0xB0,
  0x37, 0x30, 0x4F, 0xFF, 0xD0, 0xA0, 0x17, 0x10, 0x5F, 0xFF, 0xE0, 0xD0, 0x37, 0x06, 0xFF, 0xFF,
  0x90, 0x46, 0x07, 0xFF, 0xFF, 0xA0, 0x35, 0x08, 0xFF, 0xFF, 0xA0, 0xE0, 0x14, 0x09, 0xFF, 0xFF,
  0xB0, 0xA4, 0x09, 0xFF, 0xFF, 0xC0, 0x44, 0x08, 0xFF, 0xFF, 0xB0, 0xC5, 0x04, 0x0D, 0xB8, 0x91,
  0xEB, 0x85, 0x32, 0x34, 0x59, 0xDF, 0xFA, 0x03, 0x58, 0x21, 0xA9, 0x37, 0x40, 0x40, 0xCF, 0xF0,
  0x97, 0x77, 0x10, 0x9F, 0xE0, 0xE7, 0x77, 0x20, 0xBF, 0xE0, 0x37, 0x77, 0x10, 0x1F, 0xE0, 0x67,
  0x77, 0x20, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0x4F, 0xD0, 0xB7, 0x77, 0x3F, 0xD0, 0xD7, 0x77, 0x30,
  0xDF, 0xC0, 0xD7, 0x77, 0x30, 0xCF, 0xC0, 0xE7, 0x77, 0x30, 0xBF, 0xC0, 0xE7, 0x77, 0x30, 0xCF,
  0xC0, 0xD7, 0x77, 0x30, 0xDF, 0xC0, 0xD7, 0x77, 0x3F, 0xD0, 0xB7, 0x77, 0x20, 0x3F, 0xD0, 0x97,
  0x77, 0x20, 0x7F, 0xD0, 0x77, 0x77, 0x20, 0xDF, 0xD0, 0x47, 0x77, 0x10, 0x6F, 0xE1, 0x81, 0x9A,
  0x27, 0x74, 0x02, 0x0E, 0xFD, 0x81, 0xB0, 0x9A, 0x0A, 0x04, 0x77, 0x10, 0x20, 0xDF, 0xE8, 0x16,
  0x09, 0xC8, 0x1D, 0x82, 0x74, 0x06, 0x0E, 0xFF, 0x81, 0x10, 0x9F, 0x89, 0x1E, 0xA7, 0x53, 0x22,
  0x45, 0x9E, 0xFF, 0x90, 0x92, 0x09, 0xFF, 0xFF, 0xC0, 0xE0, 0x12, 0x09, 0xFF, 0xFF, 0xC0, 0x73,
  0x09, 0xFF, 0xFF, 0xB0, 0xB4, 0x09, 0xFF, 0xFF, 0xA0, 0xD0, 0x14, 0x09, 0xFF, 0xFF, 0x90, 0xD0,
  0x25, 0x09, 0xFF, 0xFF, 0x0C, 0x01, 0x60, 0x9F, 0xFF, 0xE0, 0x87, 0x20, 0x60, 0xCF, 0xFF, 0xA0,
  0xA0, 0x27, 0x58, 0x13, 0x8C, 0xFF, 0xB8, 0x1D, 0x82, 0x77, 0x38, 0x61, 0x47, 0x9B, 0xDD, 0xEA,
  0x85, 0xEE, 0xCA, 0x85, 0x27, 0x70,
  // "6" (U+0036)
  0x77, 0x58, 0x52, 0x58, 0xAC, 0xDE, 0xE8, 0x2D, 0xC8, 0x27, 0x75, 0x81, 0x38, 0xDF, 0xFA, 0x06,
  0x77, 0x30, 0x40, 0xCF, 0xFD, 0x06, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0x06, 0x77, 0x06, 0x0E, 0xFF,
  0xF9, 0x06, 0x76, 0x09, 0xFF, 0xFB, 0x06, 0x75, 0x0A, 0xFF, 0xFC, 0x06, 0x74, 0x09, 0xFF, 0xFD,
  0x06, 0x73, 0x07, 0xFF, 0xFE, 0x06, 0x72, 0x03, 0xFF, 0xFF, 0x06, 0x72, 0x0C, 0xFF, 0x98, 0x94,
  0xD9, 0x64, 0x32, 0x23, 0x46, 0x9C, 0xE6, 0x71, 0x07, 0xFF, 0x09, 0x03, 0x77, 0x71, 0x0E, 0xFD,
  0x0B, 0x02, 0x77, 0x72, 0x07, 0xFD, 0x09, 0x77, 0x74, 0x0D, 0xFC, 0x09, 0x77, 0x74, 0x04, 0xFC,
  0x0C, 0x77, 0x75, 0x0B, 0xFC, 0x03, 0x77, 0x74, 0x01, 0xFC, 0x0A, 0x77, 0x75, 0x05, 0xFC, 0x03,
  0x77, 0x75, 0x0A, 0xFB, 0x0C, 0x77, 0x76, 0x0E, 0xFB, 0x07, 0x77, 0x75, 0x02, 0xFC, 0x02, 0x77,
  0x75, 0x05, 0xFB, 0x0E, 0x77, 0x76, 0x08, 0xFB, 0x0A, 0x68, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x83,
  0x74, 0x0B, 0xFB, 0x07, 0x40, 0x70, 0xEF, 0xB0, 0xC0, 0x57, 0x20, 0xDF, 0xB0, 0x52, 0x02, 0x0C,
  0xFF, 0x0B, 0x01, 0x7F, 0xC8, 0x23, 0x02, 0xEF, 0xFA, 0x0D, 0x02, 0x50, 0x2F, 0xC8, 0x11, 0x0D,
  0xFF, 0xC0, 0xD0, 0x14, 0x03, 0xFC, 0x10, 0x9F, 0xFE, 0x0B, 0x40, 0x5F, 0xC0, 0x3F, 0xFF, 0x90,
  0x63, 0x07, 0xFC, 0x0D, 0xFF, 0xF9, 0x0E, 0x01, 0x20, 0x8F, 0xFF, 0xFF, 0x08, 0x20, 0x9F, 0xFF,
  0xFF, 0x0E, 0x20, 0xAF, 0xFA, 0x84, 0xB5, 0x33, 0x5A, 0xFF, 0x81, 0x50, 0xAF, 0xF0, 0xE0, 0x56,
  0x04, 0x0E, 0xFD, 0x81, 0xA0, 0xBF, 0xF0, 0x47, 0x10, 0x5F, 0xE1, 0x0B, 0xFE, 0x08, 0x73, 0x0B,
  0xFD, 0x02, 0x0B, 0xFD, 0x0E, 0x74, 0x05, 0xFD, 0x05, 0x0B, 0xFD, 0x09, 0x75, 0xFD, 0x08, 0x0B,
  0xFD, 0x04, 0x75, 0x0C, 0xFC, 0x00, 0xAF, 0xD0, 0x17, 0x50, 0x9F, 0xC0, 0xB0, 0xAF, 0xD7, 0x60,
  0x7F, 0xC0, 0xC0, 0x8F, 0xC0, 0xE7, 0x60, 0x7F, 0xC0, 0xD0, 0x7F, 0xD7, 0x60, 0x6F, 0xC0, 0xE0,
  0x6F, 0xD7, 0x60, 0x6F, 0xC0, 0xE0, 0x3F, 0xD0, 0x17, 0x50, 0x7F, 0xC0, 0xD0, 0x1F, 0xD0, 0x47,
  0x50, 0x7F, 0xC8, 0x1C, 0x0E, 0xFC, 0x06, 0x75, 0x09, 0xFC, 0x81, 0xB0, 0xAF, 0xC0, 0x97, 0x50,
  0xBF, 0xC8, 0x19, 0x07, 0xFC, 0x0D, 0x75, 0x0E, 0xFC, 0x81, 0x70, 0x3F, 0xD0, 0x37, 0x30, 0x2F,
  0xD0, 0x42, 0x0D, 0xFC, 0x09, 0x73, 0x07, 0xFD, 0x30, 0x9F, 0xD0, 0x17, 0x20, 0xEF, 0xC0, 0xC3,
  0x02, 0xFD, 0x0B, 0x71, 0x09, 0xFD, 0x07, 0x40, 0xBF, 0xD0, 0x86, 0x08, 0xFE, 0x01, 0x40, 0x4F,
  0xE8, 0x4C, 0x53, 0x36, 0xCF, 0xE0, 0xA6, 0x0B, 0xFF, 0xFF, 0xB0, 0x36, 0x02, 0xFF, 0xFF, 0xA0,
  0xA7, 0x10, 0x6F, 0xFF, 0xF0, 0xE0, 0x17, 0x20, 0xAF, 0xFF, 0xE0, 0x57, 0x40, 0xBF, 0xFF, 0xC0,
  0x77, 0x60, 0xBF, 0xFF, 0xA0, 0x87, 0x71, 0x08, 0xFF, 0xF0, 0x67, 0x73, 0x04, 0x0C, 0xFF, 0xB0,
  0xB0, 0x27, 0x76, 0x05, 0x0C, 0xFE, 0x0B, 0x04, 0x77, 0x73, 0x83, 0x26, 0x9C, 0xEA, 0x84, 0xED,
  0xB9, 0x51, 0x75,
  // "7" (U+0037)
  0x01, 0x80, 0xC2, 0xF0, 0xD0, 0x18, 0x0C, 0x2F, 0x0D, 0x01, 0x80, 0xC2, 0xF0, 0xD0, 0x18, 0x0C,
  0x2F, 0x0D, 0x01, 0x80, 0xC2, 0xF0, 0xD0, 0x18, 0x0C, 0x2F, 0x0D, 0x01, 0x80, 0xC2, 0xF0, 0xD0,
  0x18, 0x0C, 0x2F, 0x0D, 0x01, 0x80, 0xC2, 0xF0, 0xC0, 0x18, 0x0C, 0x2F, 0x07, 0x01, 0x80, 0xC2,
  0xF0, 0x27, 0x77, 0x50, 0x4F, 0xC0, 0xC7, 0x77, 0x60, 0xAF, 0xC0, 0x67, 0x77, 0x50, 0x1F, 0xD0,
  0x17, 0x77, 0x50, 0x7F, 0xC0, 0xA7, 0x77, 0x60, 0xDF, 0xC0, 0x57, 0x77, 0x50, 0x3F, 0xC0, 0xE7,
  0x77, 0x60, 0x9F, 0xC0, 0x97, 0x77, 0x60, 0xEF, 0xC0, 0x37, 0x77, 0x50, 0x6F, 0xC0, 0xD7, 0x77,
  0x60, 0xCF, 0xC0, 0x77, 0x77, 0x50, 0x2F, 0xD0, 0x27, 0x77, 0x50, 0x8F, 0xC0, 0xC7, 0x77, 0x60,
  0xEF, 0xC0, 0x67, 0x77, 0x50, 0x4F, 0xD0, 0x17, 0x77, 0x50, 0xAF, 0xC0, 0xA7, 0x77, 0x50, 0x1F,
  0xD0, 0x57, 0x77, 0x50, 0x7F, 0xC0, 0xE7, 0x77, 0x60, 0xDF, 0xC0, 0x97, 0x77, 0x50, 0x3F, 0xD0,
  0x37, 0x77, 0x50, 0x9F, 0xC0, 0xD7, 0x77, 0x60, 0xEF, 0xC0, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0x27,
  0x77, 0x50, 0xCF, 0xC0, 0xC7, 0x77, 0x50, 0x2F, 0xD0, 0x67, 0x77, 0x50, 0x8F, 0xD0, 0x17, 0x77,
  0x50, 0xEF, 0xC0, 0xA7, 0x77, 0x50, 0x5F, 0xD0, 0x57, 0x77, 0x50, 0xBF, 0xC0, 0xE7, 0x77, 0x50,
  0x1F, 0xD0, 0x97, 0x77, 0x50, 0x7F, 0xD0, 0x37, 0x77, 0x50, 0xDF, 0xC0, 0xD7, 0x77, 0x50, 0x4F,
  0xD0, 0x77, 0x77, 0x50, 0x9F, 0xD0, 0x27, 0x77, 0x40, 0x10, 0xEF, 0xC0, 0xC7, 0x77, 0x50, 0x6F,
  0xD0, 0x67, 0x77, 0x50, 0xCF, 0xD0, 0x17, 0x77, 0x40, 0x2F, 0xD0, 0xA7, 0x77, 0x50, 0x8F, 0xD0,
  0x57, 0x77, 0x50, 0xEF, 0xC0, 0xE7, 0x77, 0x50, 0x5F, 0xD0, 0x97, 0x77, 0x50, 0xBF, 0xD0, 0x37,
  0x77, 0x40, 0x1F, 0xD0, 0xD7, 0x77, 0x50, 0x7F, 0xD0, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0x27, 0x77,
  0x40, 0x4F, 0xD0, 0xC7, 0x77, 0x50, 0xAF, 0xD0, 0x67, 0x77, 0x40, 0x1F, 0xE0, 0x17, 0x77, 0x40,
  0x6F, 0xD0, 0xA7, 0x77, 0x50, 0xCF, 0xD0, 0x57, 0x77, 0x40, 0x3F, 0xD0, 0xE7, 0x77, 0x50, 0x9F,
  0xD0, 0x97, 0x77, 0x50, 0xEF, 0xD0, 0x37, 0x77, 0x40, 0x5F, 0xD0, 0xD7, 0x76,
  // "8" (U+0038)
  0x77, 0x84, 0x37, 0xAC, 0xDE, 0xA8, 0x4E, 0xCB, 0x85, 0x17, 0x77, 0x20, 0x30, 0x9F, 0xF9, 0x0B,
  0x05, 0x77, 0x50, 0x30, 0xCF, 0xFD, 0x0D, 0x04, 0x77, 0x20, 0x8F, 0xFF, 0xA0, 0xA7, 0x60, 0x10,
  0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x30, 0x10, 0xDF, 0xFF, 0xE0, 0xD7, 0x30, 0xBF, 0xFF, 0xF9, 0x0A,
  0x71, 0x06, 0xFF, 0xFF, 0xB0, 0x57, 0x0E, 0xFF, 0xFF, 0xB0, 0xD6, 0x05, 0xFF, 0xFF, 0xD0, 0x45,
  0x0B, 0xFE, 0x85, 0xD7, 0x32, 0x37, 0xDF, 0xE0, 0x95, 0x0E, 0xFD, 0x0A, 0x70, 0x9F, 0xD0, 0xD4,
  0x02, 0xFD, 0x0B, 0x72, 0x0A, 0xFD, 0x01, 0x30, 0x4F, 0xD0, 0x27, 0x20, 0x1F, 0xD0, 0x33, 0x05,
  0xFC, 0x0D, 0x74, 0x0B, 0xFC, 0x04, 0x30, 0x6F, 0xC0, 0xA7, 0x40, 0x8F, 0xC0, 0x43, 0x05, 0xFC,
  0x09, 0x74, 0x07, 0xFC, 0x03, 0x30, 0x4F, 0xC0, 0x97, 0x40, 0x8F, 0xC0, 0x23, 0x02, 0xFC, 0x0B,
  0x74, 0x0A, 0xFC, 0x01, 0x40, 0xEF, 0xB0, 0xE7, 0x40, 0xDF, 0xB0, 0xD5, 0x0B, 0xFC, 0x06, 0x72,
  0x04, 0xFC, 0x09, 0x50, 0x6F, 0xC0, 0xE0, 0x17, 0x10, 0xDF, 0xC0, 0x45, 0x01, 0x0E, 0xFC, 0x0B,
  0x70, 0xAF, 0xC0, 0xE7, 0x08, 0xFD, 0x0B, 0x50, 0xAF, 0xD0, 0x67, 0x01, 0x0E, 0xFD, 0x83, 0xC1,
  0x01, 0xCF, 0xD0, 0xD7, 0x20, 0x5F, 0xE8, 0x1E, 0x8E, 0xFE, 0x03, 0x73, 0x0A, 0xFF, 0xFE, 0x06,
  0x75, 0x0C, 0xFF, 0xFC, 0x07, 0x76, 0x01, 0x0D, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x10, 0xDF, 0xFE,
  0x0E, 0x04, 0x77, 0x30, 0x10, 0xBF, 0xFC, 0x0A, 0x01, 0x77, 0x60, 0xBF, 0xFA, 0x0C, 0x77, 0x60,
  0x10, 0xAF, 0xFC, 0x0D, 0x03, 0x77, 0x30, 0x40, 0xEF, 0xFF, 0x06, 0x77, 0x10, 0x6F, 0xFF, 0xB0,
  0x97, 0x60, 0x8F, 0xFF, 0xD0, 0xB7, 0x40, 0x7F, 0xFF, 0xF0, 0xB7, 0x20, 0x5F, 0xF0, 0xA0, 0x9F,
  0xF0, 0xB7, 0x02, 0x0E, 0xFD, 0x0E, 0x05, 0x20, 0x50, 0xEF, 0xE0, 0x96, 0x0B, 0xFD, 0x0D, 0x02,
  0x40, 0x20, 0xDF, 0xE0, 0x54, 0x04, 0xFD, 0x0D, 0x01, 0x60, 0x10, 0xCF, 0xD0, 0xE0, 0x13, 0x0B,
  0xFC, 0x0E, 0x02, 0x72, 0x0C, 0xFD, 0x07, 0x20, 0x1F, 0xD0, 0x57, 0x30, 0x10, 0xDF, 0xC0, 0xE2,
  0x06, 0xFC, 0x0C, 0x75, 0x04, 0xFD, 0x81, 0x40, 0xAF, 0xC0, 0x57, 0x60, 0xAF, 0xC8, 0x18, 0x0D,
  0xFC, 0x01, 0x76, 0x04, 0xFC, 0x0C, 0x1F, 0xC0, 0xD7, 0x71, 0xFC, 0x0D, 0x1F, 0xC0, 0xC7, 0x71,
  0x0D, 0xFB, 0x0E, 0x01, 0xFC, 0x0C, 0x77, 0x10, 0xDF, 0xC0, 0x1F, 0xC0, 0xD7, 0x71, 0x0E, 0xFC,
  0x1F, 0xD0, 0x17, 0x60, 0x2F, 0xC8, 0x1E, 0x0E, 0xFC, 0x05, 0x76, 0x06, 0xFC, 0x81, 0xC0, 0xCF,
  0xC0, 0xC7, 0x60, 0xDF, 0xC8, 0x19, 0x09, 0xFD, 0x08, 0x74, 0x09, 0xFD, 0x81, 0x60, 0x5F, 0xE0,
  0x97, 0x10, 0x10, 0x9F, 0xE0, 0x12, 0x0E, 0xFE, 0x87, 0xE8, 0x53, 0x23, 0x59, 0xEF, 0xE0, 0xB3,
  0x09, 0xFF, 0xFF, 0xF0, 0x53, 0x02, 0xFF, 0xFF, 0xE0, 0xC5, 0x07, 0xFF, 0xFF, 0xD0, 0x36, 0x0B,
  0xFF, 0xFF, 0xB0, 0x67, 0x01, 0x0D, 0xFF, 0xFF, 0x90, 0x87, 0x20, 0x10, 0xCF, 0xFF, 0xE0, 0x77,
  0x50, 0x9F, 0xFF, 0xB0, 0xD0, 0x47, 0x70, 0x30, 0xBF, 0xFE, 0x0E, 0x08, 0x77, 0x48, 0x13, 0x9E,
  0xFF, 0x98, 0x1C, 0x61, 0x77, 0x71, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x4E, 0xDB, 0x85, 0x17, 0x50,
  // "9" (U+0039)
  0x75, 0x89, 0x31, 0x59, 0xBD, 0xEF, 0xEE, 0xC9, 0x62, 0x77, 0x73, 0x04, 0x0B, 0xFE, 0x0C, 0x05,
  0x77, 0x60, 0x30, 0xCF, 0xFB, 0x0C, 0x04, 0x77, 0x30, 0x7F, 0xFF, 0x08, 0x77, 0x10, 0x9F, 0xFF,
  0xA0, 0xB7, 0x60, 0x8F, 0xFF, 0xC0, 0xB7, 0x40, 0x6F, 0xFF, 0xE0, 0x97, 0x20, 0x20, 0xEF, 0xFF,
  0xF0, 0x67, 0x10, 0xBF, 0xFF, 0xF9, 0x0E, 0x01, 0x60, 0x4F, 0xFF, 0xFB, 0x0A, 0x60, 0xCF, 0xE8,
  0x4C, 0x53, 0x36, 0xCF, 0xE0, 0x34, 0x03, 0xFE, 0x07, 0x60, 0xAF, 0xD0, 0xA4, 0x08, 0xFD, 0x08,
  0x71, 0x0C, 0xFD, 0x01, 0x30, 0xDF, 0xC0, 0xD7, 0x20, 0x2F, 0xD0, 0x72, 0x02, 0xFD, 0x06, 0x73,
  0x0A, 0xFC, 0x0C, 0x20, 0x5F, 0xD0, 0x17, 0x30, 0x4F, 0xD8, 0x11, 0x08, 0xFC, 0x0C, 0x75, 0x0E,
  0xFC, 0x81, 0x50, 0xBF, 0xC0, 0x97, 0x50, 0xAF, 0xC8, 0x18, 0x0C, 0xFC, 0x07, 0x75, 0x07, 0xFC,
  0x81, 0xC0, 0xEF, 0xC0, 0x67, 0x50, 0x4F, 0xC0, 0xE1, 0xFD, 0x05, 0x75, 0x03, 0xFD, 0x01, 0xFD,
  0x04, 0x75, 0x01, 0xFD, 0x03, 0xFD, 0x04, 0x76, 0xFD, 0x04, 0xFD, 0x05, 0x76, 0xFD, 0x06, 0x0E,
  0xFC, 0x06, 0x75, 0x01, 0xFD, 0x07, 0x0D, 0xFC, 0x08, 0x75, 0x03, 0xFD, 0x07, 0x0C, 0xFC, 0x0A,
  0x75, 0x07, 0xFD, 0x08, 0x0A, 0xFC, 0x0E, 0x75, 0x0B, 0xFD, 0x08, 0x07, 0xFD, 0x03, 0x73, 0x03,
  0xFE, 0x08, 0x04, 0xFD, 0x0A, 0x73, 0x0B, 0xFE, 0x08, 0x01, 0xFE, 0x04, 0x71, 0x07, 0xFF, 0x81,
  0x80, 0xCF, 0xD0, 0xE0, 0x36, 0x06, 0xFF, 0x98, 0x17, 0x06, 0xFF, 0x84, 0x94, 0x33, 0x6B, 0xFF,
  0xA8, 0x16, 0x01, 0x80, 0xC0, 0xF0, 0x52, 0x0A, 0xFF, 0xFF, 0xF0, 0x42, 0x02, 0xFF, 0xFA, 0x0D,
  0xFC, 0x03, 0x30, 0x8F, 0xFF, 0x90, 0x3F, 0xC0, 0x23, 0x01, 0x0D, 0xFF, 0xE0, 0x80, 0x2F, 0xC5,
  0x03, 0x0E, 0xFF, 0xC8, 0x1C, 0x03, 0xFB, 0x0E, 0x60, 0x40, 0xEF, 0xFA, 0x82, 0xD1, 0x05, 0xFB,
  0x0C, 0x70, 0x20, 0xDF, 0xF0, 0xC0, 0x12, 0x07, 0xFB, 0x09, 0x72, 0x07, 0x0D, 0xFB, 0x0E, 0x07,
  0x40, 0x9F, 0xB0, 0x77, 0x48, 0x24, 0x8B, 0xEA, 0x82, 0xEC, 0x95, 0x60, 0xDF, 0xB0, 0x47, 0x77,
  0x50, 0x1F, 0xC0, 0x17, 0x77, 0x50, 0x4F, 0xB0, 0xD7, 0x77, 0x60, 0x9F, 0xB0, 0x97, 0x77, 0x60,
  0xEF, 0xB0, 0x57, 0x77, 0x50, 0x5F, 0xC7, 0x77, 0x60, 0xCF, 0xB0, 0xB7, 0x77, 0x50, 0x5F, 0xC0,
  0x57, 0x77, 0x40, 0x10, 0xEF, 0xB0, 0xE7, 0x77, 0x50, 0xCF, 0xC0, 0x87, 0x77, 0x30, 0x10, 0xCF,
  0xD0, 0x27, 0x77, 0x20, 0x40, 0xDF, 0xD0, 0x97, 0x77, 0x10, 0x40, 0xBF, 0xF0, 0x17, 0x18, 0x94,
  0x8E, 0xB7, 0x54, 0x32, 0x33, 0x47, 0xAE, 0xFF, 0x90, 0x77, 0x20, 0x8F, 0xFF, 0xE0, 0xC7, 0x30,
  0x8F, 0xFF, 0xD0, 0xE0, 0x27, 0x30, 0x8F, 0xFF, 0xD0, 0x47, 0x40, 0x8F, 0xFF, 0xC0, 0x57, 0x50,
  0x8F, 0xFF, 0xA0, 0xE0, 0x47, 0x60, 0x8F, 0xFF, 0x90, 0xD0, 0x37, 0x70, 0x8F, 0xFF, 0x08, 0x77,
  0x20, 0x8F, 0xFD, 0x09, 0x02, 0x77, 0x30, 0x8F, 0xFA, 0x81, 0xC7, 0x17, 0x75, 0x86, 0x26, 0x9B,
  0xCD, 0xEE, 0xA8, 0x5E, 0xDC, 0xA7, 0x51, 0x77, 0x50,
  // ":" (U+003A)
  0x48, 0x63, 0x9D, 0xEF, 0xDA, 0x47, 0x09, 0xF9, 0x0B, 0x50, 0xAF, 0xB0, 0xB3, 0x04, 0xFD, 0x05,
  0x20, 0xAF, 0xD0, 0xB2, 0x0E, 0xFD, 0x81, 0xE0, 0x1F, 0xF0, 0x01, 0xFF, 0x02, 0x01, 0xFF, 0x81,
  0x10, 0xEF, 0xE2, 0x0B, 0xFD, 0x0B, 0x20, 0x4F, 0xD0, 0x53, 0x0A, 0xFB, 0x0B, 0x50, 0xAF, 0x90,
  0xA7, 0x86, 0x39, 0xDE, 0xFD, 0xA4, 0x80, 0xDA, 0x40, 0x86, 0x39, 0xDE, 0xFD, 0xA4, 0x70, 0xAF,
  0x90, 0xB0, 0x14, 0x0A, 0xFB, 0x0B, 0x30, 0x5F, 0xD0, 0x52, 0x0B, 0xFD, 0x0B, 0x20, 0xEF, 0xE1,
  0x01, 0xFF, 0x00, 0x1F, 0xF0, 0x20, 0x1F, 0xF8, 0x11, 0x0E, 0xFD, 0x0E, 0x20, 0xAF, 0xD0, 0xB2,
  0x04, 0xFD, 0x05, 0x30, 0xAF, 0xB0, 0xA5, 0x09, 0xF9, 0x0A, 0x78, 0x63, 0x9D, 0xEF, 0xDA, 0x44,
  // ";" (U+003B)
  0x58, 0x63, 0x9D, 0xEF, 0xDA, 0x47, 0x10, 0x9F, 0x90, 0xB6, 0x0A, 0xFB, 0x0B, 0x40, 0x4F, 0xD0,
  0x53, 0x0A, 0xFD, 0x0B, 0x30, 0xEF, 0xD0, 0xE2, 0x01, 0xFF, 0x81, 0x10, 0x1F, 0xF8, 0x12, 0x01,
  0xFF, 0x01, 0x20, 0xEF, 0xE3, 0x0B, 0xFD, 0x0B, 0x30, 0x4F, 0xD0, 0x54, 0x0A, 0xFB, 0x0B, 0x60,
  0xAF, 0x90, 0xA7, 0x18, 0x63, 0x9D, 0xEF, 0xDA, 0x48, 0x0E, 0x92, 0x00, 0x6F, 0xC0, 0xC4, 0x08,
  0xFD, 0x01, 0x30, 0x9F, 0xC0, 0xD4, 0x0B, 0xFC, 0x09, 0x40, 0xDF, 0xC0, 0x64, 0xFD, 0x03, 0x30,
  0x1F, 0xD4, 0x03, 0xFC, 0x0B, 0x40, 0x6F, 0xC0, 0x74, 0x08, 0xFC, 0x03, 0x40, 0xAF, 0xB0, 0xE5,
  0x0D, 0xFB, 0x0B, 0x5F, 0xC0, 0x64, 0x02, 0xFC, 0x02, 0x40, 0x4F, 0xB0, 0xD5, 0x07, 0xFB, 0x08,
  0x50, 0x9F, 0xB0, 0x35, 0x0C, 0xFA, 0x0D, 0x6F, 0xB0, 0x85, 0x03, 0xFB, 0x03, 0x50, 0x6F, 0xA0,
  0xC6, 0x09, 0xFA, 0x07, 0x60, 0xCF, 0xA0, 0x16, 0xFA, 0x0A, 0x70,
  // "<" (U+003C)
  0x80, 0xC2, 0x00, 0x38, 0x0C, 0x00, 0x81, 0x3B, 0xE7, 0x77, 0x76, 0x04, 0x0B, 0xA0, 0xE7, 0x77,
  0x74, 0x04, 0x0B, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0x0C, 0xE0, 0xE7, 0x77, 0x70, 0x40, 0xCF, 0x90,
  0xE7, 0x77, 0x50, 0x40, 0xCF, 0xB0, 0xE7, 0x77, 0x30, 0x40, 0xCF, 0xD0, 0xE7, 0x77, 0x10, 0x50,
  0xCF, 0xF0, 0xE7, 0x76, 0x05, 0x0C, 0xFF, 0xA0, 0xE7, 0x74, 0x05, 0x0C, 0xFF, 0xC0, 0xE7, 0x72,
  0x05, 0x0D, 0xFF, 0xD0, 0xC0, 0x57, 0x70, 0x50, 0xDF, 0xFD, 0x0B, 0x04, 0x77, 0x05, 0x0D, 0xFF,
  0xD0, 0xA0, 0x37, 0x70, 0x60, 0xDF, 0xFD, 0x09, 0x02, 0x77, 0x06, 0x0D, 0xFF, 0xC8, 0x1E, 0x81,
  0x77, 0x06, 0x0D, 0xFF, 0xC0, 0xD0, 0x77, 0x71, 0x06, 0x0D, 0xFF, 0xC0, 0xD0, 0x67, 0x71, 0x06,
  0x0D, 0xFF, 0xC0, 0xB0, 0x47, 0x71, 0x06, 0x0E, 0xFF, 0xC0, 0xA0, 0x37, 0x73, 0xFF, 0xC0, 0x90,
  0x27, 0x75, 0xFF, 0x98, 0x1E, 0x81, 0x77, 0x7F, 0xE0, 0xE0, 0x77, 0x77, 0x3F, 0xF0, 0xB0, 0x47,
  0x77, 0x2F, 0xFA, 0x0D, 0x06, 0x77, 0x7F, 0xFC, 0x81, 0xE8, 0x17, 0x74, 0x05, 0x0C, 0xFF, 0xD0,
  0x90, 0x27, 0x74, 0x05, 0x0C, 0xFF, 0xD0, 0xB0, 0x47, 0x74, 0x04, 0x0B, 0xFF, 0xD0, 0xC0, 0x57,
  0x74, 0x03, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x77, 0x30, 0x30, 0xAF, 0xFD, 0x81, 0xE9, 0x27, 0x73,
  0x02, 0x09, 0xFF, 0xE0, 0xA0, 0x37, 0x73, 0x01, 0x09, 0xFF, 0xE0, 0xC0, 0x57, 0x73, 0x81, 0x18,
  0xEF, 0xFD, 0x0D, 0x06, 0x77, 0x38, 0x11, 0x7E, 0xFF, 0xD0, 0xD7, 0x75, 0x06, 0x0D, 0xFF, 0xB0,
  0xE7, 0x77, 0x06, 0x0D, 0xFF, 0x90, 0xE7, 0x77, 0x20, 0x50, 0xCF, 0xE0, 0xE7, 0x77, 0x40, 0x40,
  0xCF, 0xC0, 0xE7, 0x77, 0x60, 0x40, 0xBF, 0xA0, 0xE7, 0x77, 0x71, 0x03, 0x0A, 0xF0, 0xE7, 0x77,
  0x73, 0x02, 0x0A, 0xD0, 0xE7, 0x77, 0x75, 0x02, 0x09, 0xB0, 0xE7, 0x77, 0x77, 0x82, 0x18, 0xEE,
  0x80, 0xC1, 0x00, 0x10, 0x70,
  // "=" (U+003D)
  0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C,
  0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0,
  0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x80, 0xDB, 0x30,
  0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C,
  0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0,
  0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E,
  // ">" (U+003E)
  0x03, 0x80, 0xC3, 0x08, 0x1D, 0xC4, 0x80, 0xC1, 0x00, 0xDA, 0x0C, 0x04, 0x77, 0x77, 0x70, 0xDC,
  0x0C, 0x04, 0x77, 0x77, 0x50, 0xDE, 0x0C, 0x05, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xC0, 0x57, 0x77,
  0x71, 0x0D, 0xFB, 0x0C, 0x05, 0x77, 0x76, 0x0D, 0xFD, 0x0D, 0x05, 0x77, 0x74, 0x0D, 0xFF, 0x0D,
  0x05, 0x77, 0x72, 0x0D, 0xFF, 0xA0, 0xD0, 0x57, 0x77, 0x0D, 0xFF, 0xC0, 0xD0, 0x67, 0x75, 0x04,
  0x0C, 0xFF, 0xD0, 0xD0, 0x67, 0x75, 0x03, 0x0B, 0xFF, 0xD0, 0xD0, 0x67, 0x75, 0x02, 0x09, 0xFF,
  0xD0, 0xD0, 0x67, 0x75, 0x81, 0x18, 0xEF, 0xFC, 0x0D, 0x06, 0x77, 0x58, 0x11, 0x7E, 0xFF, 0xC0,
  0xE0, 0x77, 0x76, 0x06, 0x0D, 0xFF, 0xC0, 0xE0, 0x77, 0x76, 0x05, 0x0C, 0xFF, 0xC0, 0xE0, 0x77,
  0x76, 0x03, 0x0A, 0xFF, 0xC0, 0xE0, 0x77, 0x76, 0x02, 0x09, 0xFF, 0xC0, 0xE0, 0x77, 0x76, 0x81,
  0x18, 0xEF, 0xFB, 0x01, 0x77, 0x71, 0x07, 0x0D, 0xFF, 0x90, 0x17, 0x77, 0x30, 0x60, 0xDF, 0xE0,
  0x17, 0x77, 0x20, 0x30, 0xAF, 0xF0, 0x17, 0x77, 0x05, 0x0C, 0xFF, 0xA0, 0x17, 0x75, 0x06, 0x0D,
  0xFF, 0xC0, 0x17, 0x72, 0x81, 0x18, 0xEF, 0xFC, 0x0D, 0x06, 0x77, 0x10, 0x30, 0xAF, 0xFD, 0x0C,
  0x05, 0x77, 0x10, 0x40, 0xBF, 0xFD, 0x0C, 0x05, 0x77, 0x10, 0x60, 0xDF, 0xFD, 0x0B, 0x04, 0x77,
  0x81, 0x18, 0xEF, 0xFD, 0x0B, 0x03, 0x77, 0x02, 0x09, 0xFF, 0xE0, 0xA0, 0x27, 0x70, 0x40, 0xBF,
  0xFE, 0x09, 0x02, 0x77, 0x06, 0x0D, 0xFF, 0xD8, 0x1E, 0x91, 0x77, 0x10, 0xCF, 0xFD, 0x81, 0xE8,
  0x17, 0x73, 0x0D, 0xFF, 0xB8, 0x1E, 0x71, 0x77, 0x50, 0xDF, 0xF9, 0x0D, 0x06, 0x77, 0x71, 0x0D,
  0xFE, 0x0D, 0x06, 0x77, 0x73, 0x0D, 0xFC, 0x0C, 0x05, 0x77, 0x75, 0x0D, 0xFA, 0x0C, 0x04, 0x77,
  0x77, 0x0D, 0xF0, 0xB0, 0x47, 0x77, 0x72, 0x0D, 0xD0, 0xA0, 0x37, 0x77, 0x74, 0x0D, 0xB0, 0xA0,
  0x27, 0x77, 0x76, 0x82, 0xDF, 0x92, 0x80, 0xC0, 0x00, 0x70, 0x18, 0x0C, 0x20,
  // "?" (U+003F)
  0x73, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x74, 0x81, 0x39, 0xEF, 0xF8, 0x1E,
  0x92, 0x75, 0x81, 0x17, 0xDF, 0xFE, 0x09, 0x01, 0x71, 0x81, 0x18, 0xEF, 0xFF, 0xA0, 0xE0, 0x36,
  0x07, 0x0E, 0xFF, 0xFE, 0x04, 0x40, 0x7F, 0xFF, 0xFA, 0x03, 0x30, 0x10, 0xEF, 0xFF, 0xF9, 0x0D,
  0x40, 0x9F, 0xFF, 0xFA, 0x08, 0x30, 0x2F, 0xFF, 0xFB, 0x01, 0x30, 0xAF, 0xFF, 0xFA, 0x07, 0x30,
  0x3F, 0x98, 0x7E, 0xA6, 0x43, 0x23, 0x6B, 0xFE, 0x0C, 0x40, 0xBD, 0x0B, 0x04, 0x72, 0x04, 0x0E,
  0xFD, 0x40, 0x4B, 0x0B, 0x03, 0x75, 0x05, 0xFD, 0x03, 0x48, 0x1C, 0xD4, 0x77, 0x10, 0xDF, 0xC0,
  0x54, 0x02, 0x77, 0x30, 0x8F, 0xC0, 0x67, 0x77, 0x10, 0x7F, 0xC0, 0x77, 0x77, 0x10, 0x6F, 0xC0,
  0x67, 0x77, 0x10, 0x7F, 0xC0, 0x57, 0x77, 0x10, 0xAF, 0xC0, 0x37, 0x77, 0x10, 0xEF, 0xC0, 0x17,
  0x77, 0x05, 0xFC, 0x0D, 0x77, 0x71, 0x0D, 0xFC, 0x09, 0x77, 0x70, 0x9F, 0xD0, 0x37, 0x76, 0x06,
  0xFD, 0x0C, 0x77, 0x60, 0x4F, 0xE0, 0x57, 0x75, 0x04, 0xFE, 0x0A, 0x77, 0x50, 0x4F, 0xE0, 0xE0,
  0x17, 0x74, 0x05, 0xFF, 0x04, 0x77, 0x40, 0x4F, 0xF0, 0x67, 0x74, 0x03, 0x0E, 0xFE, 0x08, 0x77,
  0x50, 0xDF, 0xE0, 0x87, 0x75, 0x09, 0xFE, 0x08, 0x77, 0x50, 0x2F, 0xE0, 0x77, 0x76, 0x09, 0xFD,
  0x07, 0x77, 0x70, 0xEF, 0xC0, 0x77, 0x77, 0x04, 0xFC, 0x09, 0x77, 0x71, 0x07, 0xFB, 0x0C, 0x77,
  0x72, 0x09, 0xFB, 0x04, 0x77, 0x72, 0x0B, 0xFA, 0x0D, 0x77, 0x73, 0x0C, 0xFA, 0x0A, 0x77, 0x73,
  0x0C, 0xFA, 0x08, 0x77, 0x73, 0x0C, 0xFA, 0x08, 0x77, 0x73, 0x0C, 0xFA, 0x08, 0x77, 0x73, 0x09,
  0x80, 0x5A, 0x05, 0x80, 0xC9, 0x20, 0x87, 0x17, 0xBE, 0xFE, 0xC7, 0x17, 0x77, 0x40, 0x40, 0xEF,
  0x0E, 0x04, 0x77, 0x72, 0x04, 0xFC, 0x04, 0x77, 0x71, 0x0D, 0xFC, 0x0D, 0x77, 0x70, 0x4F, 0xE0,
  0x47, 0x76, 0x08, 0xFE, 0x07, 0x77, 0x60, 0xAF, 0xE0, 0x97, 0x76, 0x0A, 0xFE, 0x0A, 0x77, 0x60,
  0xAF, 0xE0, 0x97, 0x76, 0x08, 0xFE, 0x07, 0x77, 0x60, 0x4F, 0xE0, 0x37, 0x77, 0x0C, 0xFC, 0x0C,
  0x77, 0x71, 0x03, 0xFC, 0x03, 0x77, 0x72, 0x04, 0x0E, 0xF0, 0xE0, 0x47, 0x77, 0x58, 0x56, 0xBE,
  0xFE, 0xB7, 0x77, 0x20,
  // "@" (U+0040)
  0x77, 0x74, 0x85, 0x14, 0x79, 0xBD, 0xEB, 0x84, 0xED, 0xB9, 0x74, 0x80, 0xD0, 0x08, 0x12, 0x7C,
  0xFF, 0xB8, 0x1C, 0x71, 0x80, 0xC2, 0x00, 0x50, 0xCF, 0xFF, 0xA0, 0xB0, 0x37, 0x77, 0x76, 0x06,
  0x0D, 0xFF, 0xFE, 0x0B, 0x03, 0x77, 0x77, 0x20, 0x30, 0xCF, 0xFF, 0xFB, 0x08, 0x77, 0x77, 0x07,
  0xFF, 0xFF, 0xE0, 0xC0, 0x27, 0x77, 0x40, 0xA8, 0x0C, 0x0F, 0x0E, 0x05, 0x77, 0x71, 0x02, 0x0D,
  0x80, 0xC3, 0xF0, 0x57, 0x76, 0x02, 0x0D, 0xFE, 0x89, 0x4E, 0xB8, 0x43, 0x21, 0x01, 0x13, 0x58,
  0xCF, 0xF0, 0x67, 0x74, 0x01, 0x0D, 0xFD, 0x0B, 0x05, 0x77, 0x81, 0x17, 0xDF, 0xD0, 0x47, 0x72,
  0x01, 0x0D, 0xFC, 0x0A, 0x02, 0x77, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x27, 0x71, 0x0B, 0xFB, 0x0D,
  0x05, 0x77, 0x71, 0x01, 0x0B, 0xFB, 0x0C, 0x77, 0x07, 0xFB, 0x0C, 0x01, 0x77, 0x74, 0x08, 0xFB,
  0x08, 0x75, 0x03, 0xFB, 0x0A, 0x77, 0x77, 0x07, 0xFB, 0x02, 0x74, 0x0D, 0xFA, 0x0A, 0x77, 0x77,
  0x20, 0x8F, 0xA0, 0xB7, 0x30, 0x6F, 0xA0, 0xC7, 0x77, 0x74, 0x0B, 0xFA, 0x04, 0x72, 0x0E, 0xF9,
  0x0D, 0x01, 0x77, 0x77, 0x40, 0x10, 0xEF, 0x90, 0xB7, 0x10, 0x8F, 0xA0, 0x47, 0x58, 0x33, 0x7B,
  0xDE, 0xA8, 0x5E, 0xDC, 0x97, 0x41, 0x71, 0x07, 0xFA, 0x02, 0x60, 0x1F, 0xA0, 0xA7, 0x38, 0x11,
  0x8D, 0xFF, 0x81, 0xDA, 0x56, 0x0D, 0xF9, 0x08, 0x60, 0x7F, 0x90, 0xE0, 0x17, 0x20, 0x60, 0xEF,
  0xFE, 0x05, 0x40, 0x6F, 0x90, 0xE6, 0x0E, 0xF9, 0x08, 0x72, 0x0A, 0xFF, 0xF9, 0x07, 0x50, 0xEF,
  0x90, 0x34, 0x04, 0xFA, 0x01, 0x71, 0x0C, 0xFF, 0xFA, 0x06, 0x50, 0x9F, 0x90, 0x74, 0x0A, 0xF9,
  0x09, 0x71, 0x0B, 0xFF, 0xFB, 0x05, 0x50, 0x4F, 0x90, 0xC4, 0x0E, 0xF9, 0x03, 0x70, 0x8F, 0xFF,
  0xC0, 0x56, 0xFA, 0x30, 0x4F, 0x90, 0xE7, 0x04, 0xFB, 0x85, 0xD6, 0x20, 0x13, 0x8F, 0xA0, 0x46,
  0x0B, 0xF9, 0x02, 0x20, 0x8F, 0x90, 0x97, 0x0D, 0xFA, 0x09, 0x7F, 0xA0, 0x36, 0x08, 0xF9, 0x05,
  0x20, 0xCF, 0x90, 0x46, 0x05, 0xFA, 0x09, 0x71, 0xFA, 0x03, 0x60, 0x5F, 0x90, 0x72, 0xFA, 0x70,
  0xCF, 0x90, 0xD7, 0x10, 0x1F, 0xA0, 0x26, 0x03, 0xF9, 0x81, 0x90, 0x3F, 0x90, 0xC6, 0x03, 0xFA,
  0x06, 0x71, 0x02, 0xFA, 0x02, 0x60, 0x1F, 0x98, 0x1A, 0x06, 0xF9, 0x09, 0x60, 0x8F, 0x90, 0xE7,
  0x20, 0x3F, 0xA0, 0x17, 0xF9, 0x81, 0xB0, 0x8F, 0x90, 0x66, 0x0C, 0xF9, 0x09, 0x72, 0x03, 0xFA,
  0x71, 0xF9, 0x81, 0xC0, 0xAF, 0x90, 0x46, 0xFA, 0x05, 0x72, 0x04, 0xFA, 0x71, 0x0E, 0xF8, 0x1D,
  0x0C, 0xF9, 0x02, 0x50, 0x3F, 0xA0, 0x27, 0x20, 0x5F, 0xA7, 0x10, 0xEF, 0x81, 0xD0, 0xEF, 0x96,
  0x05, 0xFA, 0x73, 0x06, 0xF9, 0x0E, 0x71, 0xF9, 0x0C, 0x1F, 0x90, 0xE6, 0x07, 0xF9, 0x0D, 0x73,
  0x07, 0xF9, 0x0D, 0x71, 0xF9, 0x0C, 0x1F, 0x90, 0xD6, 0x09, 0xF9, 0x0C, 0x73, 0x08, 0xF9, 0x0D,
  0x71, 0xF9, 0x0B, 0x01, 0xF9, 0x0D, 0x60, 0x9F, 0x90, 0xB7, 0x30, 0x9F, 0x90, 0xC7, 0x01, 0xF9,
  0x09, 0x01, 0xF9, 0x0C, 0x60, 0xAF, 0x90, 0xB7, 0x30, 0xAF, 0x90, 0xC7, 0x03, 0xF9, 0x08, 0x01,
  0xF9, 0x0C, 0x60, 0x9F, 0x90, 0xB7, 0x30, 0xCF, 0x90, 0xA7, 0x04, 0xF9, 0x06, 0x01, 0xF9, 0x0C,
  0x60, 0x8F, 0x90, 0xC7, 0x30, 0xEF, 0x90, 0x97, 0x06, 0xF9, 0x03, 0x01, 0xF9, 0x0D, 0x60, 0x7F,
  0x90, 0xD7, 0x20, 0x2F, 0xA0, 0x97, 0x09, 0xF9, 0x2F, 0x90, 0xE6, 0x06, 0xFA, 0x72, 0x05, 0xFA,
  0x09, 0x70, 0xCF, 0x0C, 0x2F, 0xA6, 0x04, 0xFA, 0x03, 0x71, 0x09, 0xFA, 0x09, 0x60, 0x1F, 0x90,
  0x82, 0x0D, 0xF9, 0x01, 0x50, 0x1F, 0xA0, 0x87, 0x10, 0xDF, 0xA0, 0xA6, 0x06, 0xF9, 0x03, 0x20,
  0xCF, 0x90, 0x36, 0x0D, 0xF9, 0x0E, 0x01, 0x60, 0x5F, 0xB0, 0xD6, 0x0D, 0xF0, 0xD3, 0x0A, 0xF9,
  0x06, 0x60, 0x8F, 0xA0, 0xA5, 0x01, 0x0D, 0xFC, 0x03, 0x40, 0x8F, 0x90, 0x73, 0x08, 0xF9, 0x09,
  0x60, 0x3F, 0xB8, 0x4B, 0x30, 0x15, 0xDF, 0xD8, 0x3D, 0x40, 0x29, 0xFA, 0x01, 0x30, 0x5F, 0x90,
  0xD7, 0x0C, 0x80, 0xC4, 0xF0, 0x84, 0x02, 0xFA, 0x01, 0x60, 0x4F, 0xFE, 0x03, 0x0E, 0xFF, 0xB0,
  0xE0, 0x15, 0x0E, 0xF9, 0x06, 0x70, 0xBF, 0xFC, 0x81, 0x80, 0x8F, 0xFB, 0x05, 0x60, 0xAF, 0x90,
  0xB7, 0x02, 0x0E, 0xFF, 0xA0, 0xD2, 0x01, 0xFF, 0xA0, 0x97, 0x06, 0xFA, 0x02, 0x70, 0x30, 0xEF,
  0xF0, 0xE0, 0x23, 0x07, 0xFF, 0x0B, 0x71, 0x02, 0xFA, 0x08, 0x71, 0x03, 0x0D, 0xFD, 0x0E, 0x03,
  0x50, 0x9F, 0xD0, 0x97, 0x30, 0xBF, 0x90, 0xE0, 0x17, 0x10, 0x10, 0x8F, 0xB0, 0xB0, 0x17, 0x07,
  0xFA, 0x0D, 0x05, 0x74, 0x06, 0xFA, 0x09, 0x73, 0x89, 0x01, 0x6A, 0xDE, 0xFE, 0xC9, 0x37, 0x38,
  0x71, 0x7B, 0xEF, 0xED, 0xA5, 0x77, 0x0E, 0xFA, 0x03, 0x80, 0xE0, 0x00, 0x7F, 0xA0, 0xD8, 0x0E,
  0x00, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xE0, 0x00, 0x7F, 0xB0, 0x98, 0x0E, 0x00, 0x0C, 0xFB, 0x0A,
  0x80, 0xD7, 0x00, 0x3F, 0xC0, 0xC0, 0x37, 0x77, 0x70, 0x30, 0x57, 0x76, 0x06, 0xFD, 0x09, 0x01,
  0x77, 0x72, 0x83, 0x27, 0xDF, 0xA7, 0x77, 0x09, 0xFE, 0x09, 0x04, 0x77, 0x38, 0x22, 0x69, 0xDC,
  0x0A, 0x77, 0x71, 0x0A, 0xFF, 0x84, 0xEB, 0x75, 0x31, 0x38, 0x61, 0x23, 0x46, 0x9B, 0xEF, 0x90,
  0xA7, 0x77, 0x20, 0xA8, 0x0C, 0x2F, 0x0A, 0x77, 0x73, 0x08, 0x80, 0xC1, 0xF0, 0xA7, 0x77, 0x40,
  0x50, 0xEF, 0xFF, 0xFF, 0x0A, 0x77, 0x75, 0x01, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x77, 0x70, 0x40,
  0xCF, 0xFF, 0xFB, 0x0C, 0x05, 0x77, 0x77, 0x20, 0x30, 0xAF, 0xFF, 0xD8, 0x1E, 0x93, 0x77, 0x77,
  0x78, 0x15, 0xAE, 0xFF, 0xD8, 0x1C, 0x73, 0x80, 0xC5, 0x08, 0x62, 0x58, 0x9B, 0xDE, 0xEA, 0x86,
  0xED, 0xDC, 0xA8, 0x53, 0x77, 0x71,
  // "A" (U+0041)
  0x77, 0x30, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xFA,
  0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F, 0xFC, 0x01, 0x77, 0x77, 0x40,
  0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x5F, 0xFD, 0x0E, 0x77,
  0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07, 0x77, 0x77, 0x10, 0x2F, 0xB0,
  0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB, 0x01, 0x77, 0x77, 0x0B, 0xFB,
  0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09, 0x77, 0x76, 0x04, 0xFC, 0x01,
  0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27, 0x77, 0x50, 0xDF, 0xB0, 0xA2,
  0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0,
  0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0, 0x47, 0x77, 0x30, 0xEF, 0xB0,
  0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF, 0xB0, 0xD7, 0x77, 0x20, 0x7F,
  0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F, 0xC0, 0x67, 0x77, 0x01, 0xFC,
  0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF, 0xB0, 0xE7, 0x77, 0x09, 0xFC,
  0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x87, 0x75, 0x02, 0xFC,
  0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D, 0xFC, 0x01, 0x77, 0x40, 0xBF,
  0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71, 0x06, 0xFC, 0x0A, 0x77, 0x30,
  0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B, 0x73, 0x0E, 0xFC, 0x03, 0x77,
  0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD, 0x04, 0x73, 0x07, 0xFC, 0x0C,
  0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xC7, 0x5F, 0xD0, 0x57, 0x70,
  0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60, 0x78, 0x0C, 0x2F, 0x02, 0x75,
  0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05, 0x80, 0xC4, 0xF7, 0x40, 0x98,
  0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28, 0x0C, 0x5F, 0x0D, 0x72, 0x06,
  0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E, 0xFD, 0x03, 0x77, 0x20, 0x6F,
  0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD, 0x0B, 0x77, 0x40, 0xEF, 0xD0,
  0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x6F, 0xD0,
  0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C, 0x77, 0x60, 0xEF, 0xD0, 0x54,
  0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04, 0x77, 0x60, 0x6F, 0xD0, 0xE3,
  0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77, 0x71, 0x0E, 0xFD, 0x07, 0x2F,
  0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77, 0x71, 0x07, 0xFE, 0x01, 0x09,
  0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77, 0x73, 0x0E, 0xFD, 0x09,
  // "B" (U+0042)
  0x08, 0xFF, 0xD8, 0x6E, 0xDC, 0xB9, 0x74, 0x17, 0x70, 0x8F, 0xFF, 0xE8, 0x1C, 0x83, 0x74, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x57, 0x20, 0x8F, 0xFF, 0xFC, 0x0C, 0x03, 0x70, 0x8F, 0xFF, 0xFE, 0x06,
  0x60, 0x8F, 0xFF, 0xFF, 0x06, 0x50, 0x88, 0x0C, 0x0F, 0x03, 0x40, 0x88, 0x0C, 0x0F, 0x0D, 0x40,
  0x88, 0x0C, 0x1F, 0x07, 0x30, 0x88, 0x0C, 0x1F, 0x0D, 0x30, 0x8F, 0xD0, 0x48, 0x01, 0x28, 0x23,
  0x47, 0xBF, 0xFA, 0x03, 0x20, 0x8F, 0xD0, 0x27, 0x20, 0x20, 0xBF, 0xF0, 0x72, 0x08, 0xFD, 0x02,
  0x74, 0x09, 0xFE, 0x0A, 0x20, 0x8F, 0xD0, 0x27, 0x50, 0xDF, 0xD0, 0xC2, 0x08, 0xFD, 0x02, 0x75,
  0x06, 0xFD, 0x0E, 0x20, 0x8F, 0xD0, 0x27, 0x50, 0x1F, 0xD0, 0xE2, 0x08, 0xFD, 0x02, 0x76, 0x0E,
  0xFC, 0x0E, 0x20, 0x8F, 0xD0, 0x27, 0x60, 0xDF, 0xC0, 0xD2, 0x08, 0xFD, 0x02, 0x76, 0x0E, 0xFC,
  0x0D, 0x20, 0x8F, 0xD0, 0x27, 0x6F, 0xD0, 0xA2, 0x08, 0xFD, 0x02, 0x75, 0x03, 0xFD, 0x07, 0x20,
  0x8F, 0xD0, 0x27, 0x50, 0x8F, 0xD0, 0x42, 0x08, 0xFD, 0x02, 0x74, 0x01, 0x0E, 0xFC, 0x0E, 0x30,
  0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD0, 0x83, 0x08, 0xFD, 0x02, 0x72, 0x01, 0x0B, 0xFD, 0x0E, 0x01,
  0x30, 0x8F, 0xD0, 0x48, 0x01, 0x28, 0x23, 0x46, 0xAF, 0xF0, 0x74, 0x08, 0xFF, 0xFF, 0xF0, 0xB5,
  0x08, 0xFF, 0xFF, 0xE0, 0xC0, 0x15, 0x08, 0xFF, 0xFF, 0xD0, 0x97, 0x08, 0xFF, 0xFF, 0xA8, 0x1E,
  0xA3, 0x71, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x37, 0x30, 0x8F, 0xFF, 0xFB, 0x0D, 0x07, 0x71, 0x08,
  0xFF, 0xFF, 0xD0, 0xE0, 0x66, 0x08, 0xFF, 0xFF, 0xF0, 0xA5, 0x08, 0x80, 0xC0, 0xF0, 0xB4, 0x08,
  0x80, 0xC1, 0xF0, 0x93, 0x08, 0xFD, 0x02, 0x68, 0x21, 0x26, 0xAF, 0xF9, 0x03, 0x20, 0x8F, 0xD0,
  0x27, 0x30, 0x20, 0xCF, 0xE0, 0xB2, 0x08, 0xFD, 0x02, 0x75, 0x0C, 0xFE, 0x81, 0x20, 0x8F, 0xD0,
  0x27, 0x50, 0x10, 0xEF, 0xD8, 0x17, 0x08, 0xFD, 0x02, 0x76, 0x08, 0xFD, 0x81, 0xB0, 0x8F, 0xD0,
  0x27, 0x60, 0x3F, 0xD8, 0x1E, 0x08, 0xFD, 0x02, 0x77, 0xFE, 0x01, 0x08, 0xFD, 0x02, 0x77, 0x0D,
  0xFD, 0x02, 0x08, 0xFD, 0x02, 0x77, 0x0C, 0xFD, 0x03, 0x08, 0xFD, 0x02, 0x77, 0x0D, 0xFD, 0x03,
  0x08, 0xFD, 0x02, 0x77, 0x0E, 0xFD, 0x03, 0x08, 0xFD, 0x02, 0x76, 0x01, 0xFE, 0x02, 0x08, 0xFD,
  0x02, 0x76, 0x04, 0xFE, 0x10, 0x8F, 0xD0, 0x27, 0x60, 0xAF, 0xD8, 0x1E, 0x08, 0xFD, 0x02, 0x75,
  0x02, 0xFE, 0x81, 0xA0, 0x8F, 0xD0, 0x27, 0x50, 0xCF, 0xE8, 0x17, 0x08, 0xFD, 0x02, 0x73, 0x03,
  0x0C, 0xFF, 0x81, 0x20, 0x8F, 0xD0, 0x48, 0x02, 0x28, 0x23, 0x47, 0xBF, 0xF9, 0x0B, 0x20, 0x88,
  0x0C, 0x2F, 0x04, 0x20, 0x88, 0x0C, 0x1F, 0x0B, 0x30, 0x88, 0x0C, 0x0F, 0x0E, 0x02, 0x30, 0x88,
  0x0C, 0x0F, 0x04, 0x40, 0x8F, 0xFF, 0xFF, 0x05, 0x50, 0x8F, 0xFF, 0xFD, 0x0E, 0x05, 0x60, 0x8F,
  0xFF, 0xFC, 0x0C, 0x02, 0x70, 0x8F, 0xFF, 0xFA, 0x0D, 0x06, 0x72, 0x08, 0xFF, 0xFF, 0x0B, 0x05,
  0x74, 0x08, 0xFF, 0xF8, 0x4E, 0xDC, 0xA7, 0x47, 0x70,
  // "C" (U+0043)
  0x77, 0x48, 0x41, 0x58, 0xBC, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x37, 0x77, 0x30, 0x60, 0xBF, 0xF9,
  0x82, 0xEA, 0x51, 0x77, 0x40, 0x70, 0xEF, 0xFF, 0x0B, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFC, 0x0C,
  0x05, 0x74, 0x07, 0xFF, 0xFF, 0x0E, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x97, 0x20, 0xAF, 0xFF, 0xFA,
  0x04, 0x71, 0x09, 0xFF, 0xFF, 0xA0, 0xD7, 0x10, 0x7F, 0xFF, 0xFB, 0x08, 0x70, 0x4F, 0xFF, 0xFC,
  0x03, 0x70, 0xDF, 0xF9, 0x87, 0xC7, 0x43, 0x23, 0x69, 0xDF, 0x0D, 0x70, 0x8F, 0xF0, 0xC0, 0x47,
  0x20, 0x40, 0xBD, 0x07, 0x60, 0x2F, 0xF0, 0xA7, 0x60, 0x30, 0xBB, 0x02, 0x60, 0x9F, 0xE0, 0xA7,
  0x72, 0x81, 0x5D, 0xB6, 0x01, 0xFE, 0x0C, 0x77, 0x50, 0x36, 0x08, 0xFE, 0x03, 0x77, 0x75, 0x0E,
  0xFD, 0x09, 0x77, 0x75, 0x04, 0xFE, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0E, 0xFD,
  0x05, 0x77, 0x75, 0x02, 0xFE, 0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x76, 0x0D, 0xFD, 0x04, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x75, 0x02, 0xFD, 0x0E, 0x77, 0x76, 0x04,
  0xFD, 0x0C, 0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x09, 0x77, 0x76, 0x08, 0xFD,
  0x08, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07,
  0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x76, 0x09, 0xFD, 0x08, 0x77, 0x76, 0x08, 0xFD, 0x09, 0x77, 0x76, 0x07, 0xFD, 0x0B, 0x77, 0x76,
  0x05, 0xFD, 0x0D, 0x77, 0x76, 0x04, 0xFD, 0x0E, 0x77, 0x76, 0x02, 0xFE, 0x02, 0x77, 0x76, 0xFE,
  0x05, 0x77, 0x76, 0x0D, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x0C, 0x77, 0x76, 0x06, 0xFE, 0x01,
  0x77, 0x75, 0x03, 0xFE, 0x07, 0x77, 0x76, 0x0E, 0xFD, 0x0D, 0x77, 0x76, 0x09, 0xFE, 0x05, 0x77,
  0x75, 0x05, 0xFE, 0x0D, 0x77, 0x76, 0x0E, 0xFE, 0x08, 0x77, 0x75, 0x08, 0xFF, 0x05, 0x77, 0x50,
  0x25, 0x02, 0xFF, 0x90, 0x67, 0x72, 0x82, 0x4B, 0xF1, 0x50, 0xAF, 0xF9, 0x0A, 0x01, 0x74, 0x81,
  0x28, 0xDB, 0x01, 0x50, 0x2F, 0xFB, 0x81, 0xA5, 0x22, 0x84, 0x12, 0x36, 0x9D, 0xE0, 0x16, 0x09,
  0xFF, 0xFF, 0xD0, 0x17, 0x0D, 0xFF, 0xFF, 0xC0, 0x17, 0x04, 0xFF, 0xFF, 0xC0, 0x17, 0x10, 0x7F,
  0xFF, 0xFB, 0x01, 0x72, 0x09, 0xFF, 0xFF, 0xA0, 0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x01, 0x74, 0x06,
  0xFF, 0xFF, 0x01, 0x75, 0x03, 0x0C, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x06, 0x0D, 0xFF, 0xF8, 0x1D,
  0x71, 0x77, 0x30, 0x40, 0xBF, 0xFA, 0x81, 0xD9, 0x47, 0x77, 0x28, 0x44, 0x7A, 0xCD, 0xEA, 0x85,
  0xED, 0xCA, 0x85, 0x27, 0x10,
  // "D" (U+0044)
  0x08, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x50, 0x8F, 0xFF, 0xC8, 0x1D, 0x83, 0x77, 0x20,
  0x8F, 0xFF, 0xF0, 0xD0, 0x57, 0x70, 0x8F, 0xFF, 0xFA, 0x0D, 0x05, 0x75, 0x08, 0xFF, 0xFF, 0xC0,
  0xA0, 0x17, 0x30, 0x8F, 0xFF, 0xFD, 0x0D, 0x03, 0x72, 0x08, 0xFF, 0xFF, 0xF0, 0x47, 0x10, 0x88,
  0x0C, 0x0F, 0x04, 0x70, 0x88, 0x0C, 0x1F, 0x03, 0x60, 0x88, 0x0C, 0x1F, 0x0D, 0x01, 0x50, 0x88,
  0x0C, 0x2F, 0x0B, 0x50, 0x8F, 0xD0, 0x25, 0x82, 0x13, 0x6B, 0xFF, 0xB0, 0x54, 0x08, 0xFD, 0x02,
  0x72, 0x01, 0x09, 0xFF, 0x90, 0xE4, 0x08, 0xFD, 0x02, 0x74, 0x03, 0x0E, 0xFF, 0x06, 0x30, 0x8F,
  0xD0, 0x27, 0x50, 0x20, 0xDF, 0xE0, 0xD3, 0x08, 0xFD, 0x02, 0x76, 0x03, 0x0E, 0xFE, 0x05, 0x20,
  0x8F, 0xD0, 0x27, 0x70, 0x6F, 0xE0, 0xB2, 0x08, 0xFD, 0x02, 0x77, 0x10, 0xDF, 0xE8, 0x11, 0x08,
  0xFD, 0x02, 0x77, 0x10, 0x5F, 0xE8, 0x15, 0x08, 0xFD, 0x02, 0x77, 0x20, 0xEF, 0xD8, 0x19, 0x08,
  0xFD, 0x02, 0x77, 0x20, 0x9F, 0xD8, 0x1D, 0x08, 0xFD, 0x02, 0x77, 0x20, 0x5F, 0xE0, 0x10, 0x8F,
  0xD0, 0x27, 0x72, 0x01, 0xFE, 0x03, 0x08, 0xFD, 0x02, 0x77, 0x30, 0xDF, 0xD0, 0x60, 0x8F, 0xD0,
  0x27, 0x73, 0x0A, 0xFD, 0x00, 0x8F, 0xD0, 0x27, 0x73, 0x08, 0xFD, 0x09, 0x08, 0xFD, 0x02, 0x77,
  0x30, 0x6F, 0xD0, 0xB0, 0x8F, 0xD0, 0x27, 0x73, 0x05, 0xFD, 0x0C, 0x08, 0xFD, 0x02, 0x77, 0x30,
  0x4F, 0xD0, 0xD0, 0x8F, 0xD0, 0x27, 0x73, 0x03, 0xFD, 0x0D, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x3F,
  0xD0, 0xE0, 0x8F, 0xD0, 0x27, 0x73, 0x03, 0xFD, 0x0E, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x3F, 0xD0,
  0xD0, 0x8F, 0xD0, 0x27, 0x73, 0x03, 0xFD, 0x0D, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x4F, 0xD0, 0xC0,
  0x8F, 0xD0, 0x27, 0x73, 0x05, 0xFD, 0x0B, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x6F, 0xD0, 0xA0, 0x8F,
  0xD0, 0x27, 0x73, 0x08, 0xFD, 0x00, 0x8F, 0xD0, 0x27, 0x73, 0x0A, 0xFD, 0x07, 0x08, 0xFD, 0x02,
  0x77, 0x30, 0xCF, 0xD0, 0x40, 0x8F, 0xD0, 0x27, 0x73, 0xFE, 0x02, 0x08, 0xFD, 0x02, 0x77, 0x20,
  0x3F, 0xE1, 0x08, 0xFD, 0x02, 0x77, 0x20, 0x7F, 0xD8, 0x1B, 0x08, 0xFD, 0x02, 0x77, 0x20, 0xCF,
  0xD8, 0x17, 0x08, 0xFD, 0x02, 0x77, 0x10, 0x2F, 0xE8, 0x14, 0x08, 0xFD, 0x02, 0x77, 0x10, 0x9F,
  0xD0, 0xE2, 0x08, 0xFD, 0x02, 0x77, 0x02, 0xFE, 0x09, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0xBF, 0xE0,
  0x42, 0x08, 0xFD, 0x02, 0x76, 0x07, 0xFE, 0x0D, 0x30, 0x8F, 0xD0, 0x27, 0x50, 0x6F, 0xF0, 0x63,
  0x08, 0xFD, 0x02, 0x74, 0x08, 0xFF, 0x0E, 0x40, 0x8F, 0xD0, 0x27, 0x20, 0x50, 0xDF, 0xF9, 0x05,
  0x40, 0x8F, 0xD0, 0x24, 0x83, 0x13, 0x59, 0xEF, 0xFA, 0x0B, 0x50, 0x88, 0x0C, 0x1F, 0x0E, 0x02,
  0x50, 0x88, 0x0C, 0x1F, 0x05, 0x60, 0x88, 0x0C, 0x0F, 0x08, 0x70, 0x8F, 0xFF, 0xFF, 0x09, 0x71,
  0x08, 0xFF, 0xFF, 0xE0, 0x97, 0x20, 0x8F, 0xFF, 0xFD, 0x06, 0x73, 0x08, 0xFF, 0xFF, 0xB0, 0xC0,
  0x37, 0x40, 0x8F, 0xFF, 0xF9, 0x0E, 0x07, 0x76, 0x08, 0xFF, 0xFE, 0x0D, 0x07, 0x77, 0x10, 0x8F,
  0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x30, 0x8F, 0xFB, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x76,
  // "E" (U+0045)
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFD, 0x04,
  0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F,
  0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF,
  0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F,
  0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "F" (U+0046)
  0x08, 0xFF, 0xFF, 0xA0, 0x90, 0x8F, 0xFF, 0xFA, 0x09, 0x08, 0xFF, 0xFF, 0xA0, 0x90, 0x8F, 0xFF,
  0xFA, 0x09, 0x08, 0xFF, 0xFF, 0xA0, 0x90, 0x8F, 0xFF, 0xFA, 0x09, 0x08, 0xFF, 0xFF, 0xA0, 0x90,
  0x8F, 0xFF, 0xFA, 0x09, 0x08, 0xFF, 0xFF, 0xA0, 0x90, 0x8F, 0xFF, 0xFA, 0x09, 0x08, 0xFD, 0x03,
  0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17,
  0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F,
  0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77,
  0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD,
  0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74,
  0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08,
  0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF,
  0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF, 0x98, 0x15, 0x08, 0xFF, 0xFF,
  0x98, 0x15, 0x08, 0xFD, 0x03, 0x80, 0x94, 0x22, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17,
  0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F,
  0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77,
  0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD,
  0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74,
  0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0,
  0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40, 0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40,
  0x8F, 0xD0, 0x17, 0x74, 0x08, 0xFD, 0x01, 0x77, 0x40,
  // "G" (U+0047)
  0x77, 0x78, 0x53, 0x69, 0xBC, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x63, 0x77, 0x77, 0x05, 0x0B, 0xFF,
  0xC8, 0x1B, 0x72, 0x77, 0x70, 0x20, 0xAF, 0xFF, 0xB8, 0x1D, 0x71, 0x77, 0x20, 0x10, 0x9F, 0xFF,
  0xF9, 0x0A, 0x03, 0x76, 0x06, 0xFF, 0xFF, 0xC0, 0x67, 0x50, 0xAF, 0xFF, 0xFD, 0x01, 0x73, 0x01,
  0x0D, 0xFF, 0xFF, 0xD0, 0xA7, 0x30, 0x10, 0xDF, 0xFF, 0xFE, 0x04, 0x72, 0x01, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD7, 0x30, 0xBF, 0xFF, 0xFF, 0x08, 0x72, 0x07, 0xFF, 0xB8, 0x91, 0xD8, 0x53, 0x22, 0x34,
  0x69, 0xCF, 0x90, 0x27, 0x10, 0x3F, 0xFA, 0x09, 0x02, 0x74, 0x81, 0x17, 0xDC, 0x0B, 0x72, 0x0C,
  0xFF, 0x0D, 0x03, 0x77, 0x20, 0x30, 0xBA, 0x06, 0x71, 0x05, 0xFF, 0x0B, 0x77, 0x60, 0x40, 0xC7,
  0x20, 0xDF, 0xE0, 0xB7, 0x77, 0x73, 0x06, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xE0, 0x47,
  0x77, 0x73, 0x02, 0xFE, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0xE0, 0x27, 0x77, 0x74, 0x0D, 0xFD, 0x0A,
  0x77, 0x77, 0x40, 0x2F, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x9F, 0xD0,
  0xA7, 0x77, 0x75, 0x0D, 0xFD, 0x06, 0x77, 0x77, 0x5F, 0xE0, 0x37, 0x77, 0x74, 0x02, 0xFE, 0x77,
  0x77, 0x50, 0x4F, 0xD0, 0xD7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xA7,
  0x77, 0x75, 0x08, 0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x77, 0x30, 0x5F, 0xFF,
  0x04, 0x09, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0xAF, 0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04,
  0x0A, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09,
  0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x97, 0x30, 0x5F, 0xFF, 0x04, 0x07, 0xFD,
  0x0A, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x6F, 0xD0, 0xC7, 0x30, 0x5F, 0xFF, 0x04, 0x05, 0xFD, 0x0E,
  0x74, 0x80, 0x42, 0x03, 0xFD, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xE0,
  0x37, 0x74, 0x01, 0xFD, 0x81, 0x40, 0xEF, 0xD0, 0x67, 0x74, 0x01, 0xFD, 0x81, 0x40, 0xBF, 0xD0,
  0xA7, 0x74, 0x01, 0xFD, 0x81, 0x40, 0x8F, 0xD0, 0xE7, 0x74, 0x01, 0xFD, 0x81, 0x40, 0x5F, 0xE0,
  0x37, 0x73, 0x01, 0xFD, 0x81, 0x40, 0x1F, 0xE0, 0x97, 0x73, 0x01, 0xFD, 0x04, 0x20, 0xCF, 0xE0,
  0x17, 0x72, 0x01, 0xFD, 0x04, 0x20, 0x7F, 0xE0, 0x77, 0x72, 0x01, 0xFD, 0x04, 0x20, 0x2F, 0xE0,
  0xE0, 0x17, 0x71, 0x01, 0xFD, 0x04, 0x30, 0xBF, 0xE0, 0x97, 0x71, 0x01, 0xFD, 0x04, 0x30, 0x5F,
  0xF0, 0x67, 0x70, 0x1F, 0xD0, 0x44, 0x0D, 0xFF, 0x07, 0x76, 0x01, 0xFD, 0x04, 0x40, 0x6F, 0xF9,
  0x0B, 0x02, 0x74, 0x01, 0xFD, 0x04, 0x50, 0xDF, 0xFA, 0x82, 0xB6, 0x31, 0x38, 0x32, 0x37, 0xAE,
  0xFD, 0x04, 0x50, 0x38, 0x0C, 0x4F, 0x04, 0x60, 0x98, 0x0C, 0x3F, 0x04, 0x70, 0xC8, 0x0C, 0x2F,
  0x04, 0x70, 0x10, 0xE8, 0x0C, 0x1F, 0x04, 0x71, 0x03, 0x0E, 0x80, 0xC0, 0xF0, 0x47, 0x20, 0x20,
  0xDF, 0xFF, 0xFF, 0x04, 0x73, 0x01, 0x0B, 0xFF, 0xFF, 0xE0, 0x47, 0x50, 0x60, 0xEF, 0xFF, 0xFA,
  0x81, 0xEA, 0x27, 0x68, 0x11, 0x8E, 0xFF, 0xFC, 0x81, 0xEA, 0x57, 0x75, 0x06, 0x0B, 0xFF, 0xD8,
  0x2D, 0xA6, 0x37, 0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x89, 0x0E, 0xED, 0xCB, 0xA8, 0x53, 0x17,
  0x30,
  // "H" (U+0048)
  0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02,
  0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0,
  0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0,
  0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD,
  0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F,
  0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F,
  0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74,
  0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08,
  0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77,
  0x4F, 0xD0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A,
  0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C,
  0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0,
  0x88, 0x0C, 0x7F, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD,
  0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F,
  0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F,
  0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74,
  0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08,
  0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77,
  0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0,
  0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27,
  0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A,
  0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02,
  0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A,
  // "I" (U+0049)
  0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06,
  0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x03, 0xFF, 0xFC, 0x83,
  0x60, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x25, 0x06, 0x0C, 0xFF, 0x90, 0xD0, 0x67, 0x30, 0x30, 0xDF,
  0xC0, 0xE0, 0x47, 0x60, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x60,
  0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x28, 0x11, 0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x40, 0x30, 0xAF, 0xFF,
  0x82, 0xA4, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF,
  0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06,
  // "J" (U+004A)
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02,
  0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x02, 0x75, 0x08, 0xFD, 0x01, 0x75, 0x08, 0xFD, 0x01,
  0x75, 0x09, 0xFD, 0x76, 0x0B, 0xFC, 0x0E, 0x76, 0x0D, 0xFC, 0x0C, 0x76, 0xFD, 0x0B, 0x75, 0x04,
  0xFD, 0x08, 0x75, 0x0A, 0xFD, 0x05, 0x74, 0x03, 0xFE, 0x02, 0x73, 0x03, 0x0E, 0xFD, 0x0D, 0x28,
  0x77, 0xC8, 0x53, 0x23, 0x5A, 0xFF, 0x08, 0x20, 0x7F, 0xFF, 0x90, 0x32, 0x07, 0xFF, 0xF0, 0xB3,
  0x07, 0xFF, 0xF0, 0x33, 0x07, 0xFF, 0xE0, 0xA4, 0x07, 0xFF, 0xD0, 0xD5, 0x07, 0xFF, 0xC0, 0xE0,
  0x25, 0x07, 0xFF, 0xB0, 0xD0, 0x26, 0x07, 0xFF, 0xA0, 0x87, 0x10, 0x7F, 0xE8, 0x1E, 0x82, 0x72,
  0x89, 0x41, 0x59, 0xBC, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x50,
  // "K" (U+004B)
  0x08, 0xFD, 0x02, 0x77, 0x20, 0xBF, 0xD8, 0x1E, 0x28, 0xFD, 0x02, 0x77, 0x10, 0x5F, 0xE8, 0x17,
  0x08, 0xFD, 0x02, 0x77, 0x01, 0x0E, 0xFD, 0x0D, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0x9F, 0xE0, 0x42,
  0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x09, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0xCF, 0xD0, 0xE0, 0x13,
  0x08, 0xFD, 0x02, 0x75, 0x06, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27, 0x40, 0x10, 0xEF, 0xD0, 0xC5,
  0x08, 0xFD, 0x02, 0x74, 0x09, 0xFE, 0x03, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x3F, 0xE0, 0x86, 0x08,
  0xFD, 0x02, 0x73, 0x0C, 0xFD, 0x0E, 0x70, 0x8F, 0xD0, 0x27, 0x20, 0x6F, 0xE0, 0x57, 0x08, 0xFD,
  0x02, 0x71, 0x01, 0x0E, 0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x0A, 0xFE, 0x02, 0x71, 0x08,
  0xFD, 0x02, 0x70, 0x4F, 0xE0, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x0D, 0xFD, 0x0D, 0x73, 0x08, 0xFD,
  0x02, 0x60, 0x7F, 0xE0, 0x47, 0x30, 0x8F, 0xD0, 0x25, 0x01, 0x0E, 0xFD, 0x0A, 0x74, 0x08, 0xFD,
  0x02, 0x50, 0xAF, 0xD0, 0xE0, 0x17, 0x40, 0x8F, 0xD0, 0x24, 0x04, 0xFE, 0x06, 0x75, 0x08, 0xFD,
  0x02, 0x40, 0xDF, 0xD0, 0xC7, 0x60, 0x8F, 0xD0, 0x23, 0x07, 0xFE, 0x03, 0x76, 0x08, 0xFD, 0x02,
  0x20, 0x1F, 0xE0, 0x97, 0x70, 0x8F, 0xD0, 0x22, 0x0A, 0xFD, 0x0E, 0x01, 0x77, 0x08, 0xFD, 0x81,
  0x20, 0x3F, 0xE0, 0x57, 0x71, 0x08, 0xFD, 0x81, 0x20, 0xCF, 0xD0, 0xB7, 0x72, 0x08, 0xFD, 0x02,
  0x05, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xD0, 0x20, 0xCF, 0xD0, 0x87, 0x73, 0x08, 0xFD, 0x06, 0xFD,
  0x0D, 0x77, 0x40, 0x8F, 0xD0, 0xDF, 0xD0, 0xE7, 0x74, 0x08, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x8F,
  0xFF, 0xD0, 0xE7, 0x73, 0x08, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0x8F, 0xFF, 0xE0, 0xE0, 0x17, 0x71,
  0x08, 0xFF, 0xFF, 0x08, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0xE0, 0x17, 0x70, 0x8F, 0xFF, 0xF9, 0x08,
  0x77, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x17, 0x60, 0x8F, 0xF9, 0x0D, 0x04, 0xFE, 0x08, 0x76, 0x08,
  0xFF, 0x82, 0xC1, 0x09, 0xFE, 0x01, 0x75, 0x08, 0xFE, 0x09, 0x30, 0x2F, 0xE0, 0x97, 0x50, 0x8F,
  0xD0, 0x75, 0x09, 0xFE, 0x01, 0x74, 0x08, 0xFD, 0x02, 0x50, 0x2F, 0xE0, 0x97, 0x40, 0x8F, 0xD0,
  0x26, 0x0A, 0xFE, 0x02, 0x73, 0x08, 0xFD, 0x02, 0x60, 0x2F, 0xE0, 0x97, 0x30, 0x8F, 0xD0, 0x27,
  0x0A, 0xFE, 0x02, 0x72, 0x08, 0xFD, 0x02, 0x70, 0x2F, 0xE0, 0xA7, 0x20, 0x8F, 0xD0, 0x27, 0x10,
  0xAF, 0xE0, 0x27, 0x10, 0x8F, 0xD0, 0x27, 0x10, 0x3F, 0xE0, 0xA7, 0x10, 0x8F, 0xD0, 0x27, 0x20,
  0xBF, 0xE0, 0x27, 0x08, 0xFD, 0x02, 0x72, 0x03, 0xFE, 0x0A, 0x70, 0x8F, 0xD0, 0x27, 0x30, 0xBF,
  0xE0, 0x36, 0x08, 0xFD, 0x02, 0x73, 0x03, 0xFE, 0x0B, 0x60, 0x8F, 0xD0, 0x27, 0x40, 0xBF, 0xE0,
  0x35, 0x08, 0xFD, 0x02, 0x74, 0x04, 0xFE, 0x0B, 0x50, 0x8F, 0xD0, 0x27, 0x50, 0xCF, 0xE0, 0x34,
  0x08, 0xFD, 0x02, 0x75, 0x04, 0xFE, 0x0B, 0x40, 0x8F, 0xD0, 0x27, 0x60, 0xCF, 0xE0, 0x43, 0x08,
  0xFD, 0x02, 0x76, 0x05, 0xFE, 0x0B, 0x30, 0x8F, 0xD0, 0x27, 0x70, 0xCF, 0xE0, 0x42, 0x08, 0xFD,
  0x02, 0x77, 0x05, 0xFE, 0x0C, 0x20, 0x8F, 0xD0, 0x27, 0x71, 0x0D, 0xFE, 0x81, 0x40, 0x8F, 0xD0,
  0x27, 0x71, 0x05, 0xFE, 0x81, 0xC0, 0x8F, 0xD0, 0x27, 0x72, 0x0D, 0xFE, 0x05,
  // "L" (U+004C)
  0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0,
  0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50,
  0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02,
  0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08,
  0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27,
  0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F,
  0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77,
  0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD,
  0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75,
  0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0,
  0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50,
  0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02,
  0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08,
  0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27,
  0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F,
  0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC,
  0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF,
  0xFF, 0xC0, 0x8F, 0xFF, 0xFC,
  // "M" (U+004D)
  0x08, 0xFF, 0xB0, 0x17, 0x77, 0x40, 0xEF, 0xFA, 0x0A, 0x08, 0xFF, 0xB0, 0x57, 0x77, 0x30, 0x3F,
  0xFB, 0x0A, 0x08, 0xFF, 0xB0, 0x97, 0x77, 0x30, 0x7F, 0xFB, 0x0A, 0x08, 0xFF, 0xB0, 0xE7, 0x77,
  0x30, 0xCF, 0xFB, 0x0A, 0x08, 0xFF, 0xC0, 0x37, 0x77, 0x10, 0x1F, 0xFC, 0x0A, 0x08, 0xFF, 0xC0,
  0x77, 0x77, 0x10, 0x5F, 0xFC, 0x0A, 0x08, 0xFF, 0xC0, 0xB7, 0x77, 0x10, 0xAF, 0xFC, 0x0A, 0x08,
  0xFF, 0xD0, 0x17, 0x77, 0x0E, 0xFF, 0xC0, 0xA0, 0x8F, 0xFD, 0x05, 0x77, 0x60, 0x3F, 0xFD, 0x0A,
  0x08, 0xFF, 0xD0, 0x97, 0x76, 0x08, 0xFF, 0xD0, 0xA0, 0x8F, 0xFD, 0x0D, 0x77, 0x60, 0xCF, 0xFD,
  0x0A, 0x08, 0xFF, 0xE0, 0x27, 0x74, 0x01, 0xFF, 0xE0, 0xA0, 0x8F, 0xFE, 0x07, 0x77, 0x40, 0x5F,
  0xFE, 0x0A, 0x08, 0xFF, 0xE0, 0xB7, 0x74, 0x0A, 0xFF, 0xE0, 0xA0, 0x8F, 0xFF, 0x77, 0x40, 0xEF,
  0xFE, 0x0A, 0x08, 0xFF, 0xF0, 0x47, 0x72, 0x03, 0xFF, 0xF0, 0xA0, 0x8F, 0xB0, 0xCF, 0xB0, 0x97,
  0x72, 0x08, 0xFA, 0x00, 0xEF, 0xB0, 0xA0, 0x8F, 0xB0, 0x80, 0xEF, 0xA0, 0xD7, 0x72, 0x0C, 0xFA,
  0x08, 0x0D, 0xFB, 0x0A, 0x08, 0xFB, 0x00, 0x9F, 0xB0, 0x27, 0x70, 0x1F, 0xB0, 0x30, 0xEF, 0xB0,
  0xA0, 0x8F, 0xB0, 0xA0, 0x5F, 0xB0, 0x67, 0x70, 0x6F, 0xA0, 0xE1, 0xFC, 0x0A, 0x08, 0xFB, 0x0B,
  0x01, 0xFB, 0x0B, 0x77, 0x0A, 0xFA, 0x0A, 0x01, 0xFC, 0x0A, 0x08, 0xFB, 0x81, 0xC0, 0xBF, 0xB7,
  0x70, 0xEF, 0xA0, 0x50, 0x1F, 0xC0, 0xA0, 0x8F, 0xB8, 0x1C, 0x07, 0xFB, 0x04, 0x75, 0x04, 0xFB,
  0x01, 0x02, 0xFC, 0x0A, 0x08, 0xFB, 0x81, 0xD0, 0x3F, 0xB0, 0x87, 0x50, 0x8F, 0xA8, 0x1B, 0x03,
  0xFC, 0x0A, 0x08, 0xFB, 0x0E, 0x20, 0xEF, 0xA0, 0xD7, 0x50, 0xDF, 0xA8, 0x17, 0x03, 0xFC, 0x0A,
  0x08, 0xFC, 0x20, 0x9F, 0xB0, 0x27, 0x30, 0x1F, 0xB8, 0x12, 0x04, 0xFC, 0x0A, 0x08, 0xFC, 0x20,
  0x5F, 0xB0, 0x67, 0x30, 0x6F, 0xA0, 0xD2, 0x04, 0xFC, 0x0A, 0x08, 0xFC, 0x81, 0x10, 0x1F, 0xB0,
  0xA7, 0x30, 0xBF, 0xA0, 0x92, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x01, 0x20, 0xBF, 0xA0, 0xE7, 0x30,
  0xEF, 0xA0, 0x42, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x20, 0x7F, 0xB0, 0x47, 0x10, 0x4F, 0xB3,
  0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x20, 0x2F, 0xB0, 0x87, 0x10, 0x8F, 0xA0, 0xB3, 0x05, 0xFC,
  0x0A, 0x08, 0xFC, 0x02, 0x30, 0xDF, 0xA0, 0xC7, 0x10, 0xDF, 0xA0, 0x63, 0x05, 0xFC, 0x0A, 0x08,
  0xFC, 0x02, 0x30, 0x9F, 0xB0, 0x16, 0x02, 0xFB, 0x01, 0x30, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x23,
  0x05, 0xFB, 0x06, 0x60, 0x6F, 0xA0, 0xC4, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x4F, 0xB0, 0xA6,
  0x0B, 0xFA, 0x08, 0x40, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x24, 0x0B, 0xFA, 0x0E, 0x6F, 0xB0, 0x34,
  0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x40, 0x7F, 0xB0, 0x34, 0x04, 0xFA, 0x0E, 0x50, 0x5F, 0xC0,
  0xA0, 0x8F, 0xC0, 0x24, 0x02, 0xFB, 0x08, 0x40, 0x9F, 0xA0, 0xA5, 0x05, 0xFC, 0x0A, 0x08, 0xFC,
  0x02, 0x50, 0xDF, 0xA0, 0xC4, 0x0D, 0xFA, 0x05, 0x50, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x25, 0x09,
  0xFB, 0x01, 0x20, 0x2F, 0xB0, 0x15, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x50, 0x5F, 0xB0, 0x52,
  0x07, 0xFA, 0x0B, 0x60, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x26, 0xFB, 0x0A, 0x20, 0xBF, 0xA0, 0x76,
  0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x60, 0xBF, 0xA0, 0xE2, 0xFB, 0x02, 0x60, 0x5F, 0xC0, 0xA0,
  0x8F, 0xC0, 0x26, 0x07, 0xFB, 0x03, 0x04, 0xFA, 0x0D, 0x70, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x26,
  0x02, 0xFB, 0x07, 0x09, 0xFA, 0x09, 0x70, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x0D, 0xFA, 0x0C,
  0x0D, 0xFA, 0x04, 0x70, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x09, 0xFF, 0xD0, 0xE7, 0x10, 0x5F,
  0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x05, 0xFF, 0xD0, 0xA7, 0x10, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27,
  0x1F, 0xFD, 0x06, 0x71, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x71, 0x0B, 0xFF, 0xC0, 0x17, 0x10,
  0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x10, 0x7F, 0xFB, 0x0C, 0x72, 0x05, 0xFC, 0x0A, 0x08, 0xFC,
  0x02, 0x71, 0x02, 0xFF, 0xB0, 0x87, 0x20, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x20, 0xDF, 0xFA,
  0x03, 0x72, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x72, 0x09, 0xFF, 0x90, 0xE7, 0x30, 0x5F, 0xC0,
  0xA0, 0x8F, 0xC0, 0x27, 0x20, 0x4F, 0xF9, 0x09, 0x73, 0x05, 0xFC, 0x0A, 0x08, 0xFC, 0x02, 0x73,
  0xFF, 0x90, 0x57, 0x30, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x30, 0xBF, 0xF0, 0x17, 0x30, 0x5F,
  0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x30, 0x7F, 0xE0, 0xB7, 0x40, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27,
  0x30, 0x2F, 0xE0, 0x77, 0x40, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x40, 0xDF, 0xD0, 0x27, 0x40,
  0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x40, 0x9F, 0xC0, 0xD7, 0x50, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0,
  0x27, 0x40, 0x4F, 0xC0, 0x97, 0x50, 0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x5F, 0xC0, 0x47, 0x50,
  0x5F, 0xC0, 0xA0, 0x8F, 0xC0, 0x27, 0x50, 0xBF, 0xA0, 0xE7, 0x60, 0x5F, 0xC0, 0xA0,
  // "N" (U+004E)
  0x08, 0xFF, 0x0D, 0x77, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xF9, 0x06, 0x77, 0x50, 0x2F, 0xC0, 0xB0,
  0x8F, 0xF9, 0x0D, 0x77, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFA, 0x05, 0x77, 0x40, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFA, 0x0C, 0x77, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xFB, 0x04, 0x77, 0x30, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFB, 0x0C, 0x77, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xFC, 0x04, 0x77, 0x20, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFC, 0x0B, 0x77, 0x20, 0x2F, 0xC0, 0xB0, 0x8F, 0xFD, 0x03, 0x77, 0x10, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFD, 0x0A, 0x77, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xFE, 0x02, 0x77, 0x02, 0xFC, 0x0B, 0x08,
  0xFF, 0xE0, 0x97, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x02, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF,
  0xF0, 0x97, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x90, 0x17, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF,
  0x90, 0x87, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x90, 0xE0, 0x17, 0x40, 0x2F, 0xC0, 0xB0, 0x8F,
  0xB0, 0xEF, 0xD0, 0x77, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0x70, 0xDF, 0xC0, 0xE7, 0x40, 0x2F,
  0xC0, 0xB0, 0x8F, 0xB0, 0x80, 0x6F, 0xD0, 0x77, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xB8, 0x19, 0x0D,
  0xFC, 0x0D, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x81, 0xA0, 0x7F, 0xD0, 0x67, 0x20, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xB2, 0x0E, 0xFC, 0x0D, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0C, 0x20, 0x7F,
  0xD0, 0x57, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xD2, 0x01, 0x0E, 0xFC, 0x0C, 0x71, 0x02, 0xFC,
  0x0B, 0x08, 0xFB, 0x0E, 0x30, 0x8F, 0xD0, 0x47, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0x30, 0x1F,
  0xD0, 0xC7, 0x02, 0xFC, 0x0B, 0x08, 0xFC, 0x40, 0x9F, 0xD0, 0x46, 0x02, 0xFC, 0x0B, 0x08, 0xFC,
  0x40, 0x2F, 0xD0, 0xB6, 0x02, 0xFC, 0x0B, 0x08, 0xFC, 0x50, 0x9F, 0xD0, 0x35, 0x02, 0xFC, 0x0B,
  0x08, 0xFC, 0x01, 0x40, 0x2F, 0xD0, 0xA5, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x50, 0xAF, 0xD0,
  0x24, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x50, 0x3F, 0xD0, 0x95, 0xFC, 0x0B, 0x08, 0xFC, 0x02,
  0x60, 0xBF, 0xD0, 0x24, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x60, 0x3F, 0xD0, 0x94, 0x0E, 0xFB, 0x0B,
  0x08, 0xFC, 0x02, 0x70, 0xCF, 0xD0, 0x13, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x70, 0x4F, 0xD0,
  0x83, 0x0D, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x71, 0x0C, 0xFC, 0x0E, 0x01, 0x20, 0xCF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x10, 0x5F, 0xD0, 0x72, 0x0B, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x72, 0x0D, 0xFC,
  0x0E, 0x20, 0xBF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x20, 0x6F, 0xD8, 0x17, 0x0A, 0xFB, 0x0B, 0x08,
  0xFC, 0x02, 0x73, 0x0D, 0xFC, 0x81, 0xD0, 0x9F, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x30, 0x6F, 0xD0,
  0x60, 0x9F, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x40, 0xEF, 0xC0, 0xD0, 0x8F, 0xB0, 0xB0, 0x8F, 0xC0,
  0x27, 0x40, 0x7F, 0xD0, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x40, 0x10, 0xEF, 0xFF, 0x90, 0xB0,
  0x8F, 0xC0, 0x27, 0x50, 0x8F, 0xFF, 0x90, 0xB0, 0x8F, 0xC0, 0x27, 0x50, 0x1F, 0xFF, 0x90, 0xB0,
  0x8F, 0xC0, 0x27, 0x60, 0x9F, 0xFF, 0x0B, 0x08, 0xFC, 0x02, 0x76, 0x01, 0xFF, 0xF0, 0xB0, 0x8F,
  0xC0, 0x27, 0x70, 0x9F, 0xFE, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x02, 0xFF, 0xE0, 0xB0, 0x8F, 0xC0,
  0x27, 0x71, 0x0A, 0xFF, 0xD0, 0xB0, 0x8F, 0xC0, 0x27, 0x71, 0x03, 0xFF, 0xD0, 0xB0, 0x8F, 0xC0,
  0x27, 0x72, 0x0B, 0xFF, 0xC0, 0xB0, 0x8F, 0xC0, 0x27, 0x72, 0x03, 0xFF, 0xC0, 0xB0, 0x8F, 0xC0,
  0x27, 0x73, 0x0B, 0xFF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x73, 0x04, 0xFF, 0xB0, 0xB0, 0x8F, 0xC0,
  0x27, 0x74, 0x0C, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0, 0x27, 0x74, 0x05, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0,
  0x27, 0x75, 0x0D, 0xFF, 0x90, 0xB0, 0x8F, 0xC0, 0x27, 0x75, 0x06, 0xFF, 0x90, 0xB0, 0x8F, 0xC0,
  0x27, 0x76, 0x0D, 0xFF, 0x0B,
  // "O" (U+004F)
  0x77, 0x48, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85, 0x27, 0x77, 0x75, 0x81, 0x39, 0xEF,
  0xF9, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C, 0x03, 0x77, 0x73, 0x02, 0x0C, 0xFF,
  0xFC, 0x0A, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x75, 0x08, 0xFF, 0xFF, 0xB0,
  0x57, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF, 0xFF, 0xF0, 0x47, 0x60, 0x48, 0x0C,
  0x0F, 0x0E, 0x02, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7, 0x40, 0xA8, 0x0C, 0x3F, 0x06, 0x72,
  0x03, 0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9, 0x0E, 0x01, 0x71, 0x0B, 0xFF, 0x0D,
  0x04, 0x72, 0x03, 0x0D, 0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x09, 0xFE,
  0x0D, 0x77, 0x10, 0xCF, 0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02, 0x77, 0x10, 0x2F, 0xE0, 0xD5, 0x05,
  0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01, 0x77, 0x30, 0x1F, 0xE0, 0x74, 0x0E,
  0xFD, 0x0A, 0x77, 0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77, 0x50, 0x5F, 0xE0, 0x12, 0x07,
  0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77, 0x70, 0xCF, 0xD0, 0x72, 0x0D,
  0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77, 0x70, 0x6F, 0xD8, 0x1D, 0x02, 0xFE,
  0x02, 0x77, 0x70, 0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x01, 0x05, 0xFD, 0x0D, 0x77,
  0x72, 0xFE, 0x03, 0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x08, 0xFD, 0x0A, 0x77, 0x72,
  0x0D, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72,
  0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72,
  0x0A, 0xFD, 0x08, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x09, 0xFD, 0x08, 0x77, 0x72,
  0x0B, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x08, 0xFD, 0x09, 0x77, 0x72,
  0x0C, 0xFD, 0x06, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0B, 0x77, 0x72,
  0x0E, 0xFD, 0x04, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0x01, 0xFE,
  0x00, 0x1F, 0xE0, 0x17, 0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0x47, 0x77, 0x06, 0xFD, 0x0D,
  0x20, 0xCF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F, 0xD0, 0xA7, 0x77, 0x0C, 0xFD, 0x06,
  0x20, 0x5F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F, 0xE0, 0x47, 0x75, 0x05, 0xFE, 0x40,
  0xDF, 0xD0, 0x97, 0x75, 0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFE, 0x06,
  0x40, 0x4F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF, 0xE0, 0x27, 0x71, 0x03, 0xFE, 0x0C,
  0x60, 0x8F, 0xE0, 0xC7, 0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7,
  0x10, 0x9F, 0xF0, 0xD0, 0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87, 0x10, 0x20, 0xEF, 0xF9, 0x81, 0xB6,
  0x23, 0x81, 0x36, 0xBF, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC3, 0xF0, 0x57, 0x40, 0xD8, 0x0C,
  0x1F, 0x0B, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x60, 0x4F, 0xFF, 0xFF, 0x03, 0x77,
  0x10, 0x6F, 0xFF, 0xFD, 0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x50, 0x40, 0xEF,
  0xFF, 0xE0, 0xE0, 0x37, 0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09, 0x01, 0x77, 0x73, 0x04, 0x0C, 0xFF,
  0xF0, 0xB0, 0x37, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D, 0x82, 0x77, 0x77, 0x58, 0x43, 0x69,
  0xBD, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x27, 0x74,
  // "P" (U+0050)
  0x08, 0xFF, 0xC8, 0x5E, 0xEC, 0xB9, 0x63, 0x76, 0x08, 0xFF, 0xFC, 0x81, 0xE9, 0x37, 0x30, 0x8F,
  0xFF, 0xF0, 0xC0, 0x47, 0x10, 0x8F, 0xFF, 0xFA, 0x0A, 0x01, 0x60, 0x8F, 0xFF, 0xFB, 0x0D, 0x02,
  0x50, 0x8F, 0xFF, 0xFC, 0x0D, 0x01, 0x40, 0x8F, 0xFF, 0xFD, 0x0C, 0x40, 0x8F, 0xFF, 0xFE, 0x08,
  0x30, 0x8F, 0xFF, 0xFF, 0x02, 0x20, 0x8F, 0xFF, 0xFF, 0x0A, 0x20, 0x8F, 0xD8, 0x74, 0x22, 0x22,
  0x35, 0x9E, 0xFF, 0x98, 0x12, 0x08, 0xFD, 0x02, 0x71, 0x07, 0xFF, 0x81, 0x70, 0x8F, 0xD0, 0x27,
  0x20, 0x4F, 0xE8, 0x1C, 0x08, 0xFD, 0x02, 0x73, 0x08, 0xFE, 0x01, 0x08, 0xFD, 0x02, 0x74, 0x0E,
  0xFD, 0x04, 0x08, 0xFD, 0x02, 0x74, 0x08, 0xFD, 0x06, 0x08, 0xFD, 0x02, 0x74, 0x05, 0xFD, 0x00,
  0x8F, 0xD0, 0x27, 0x40, 0x1F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27,
  0x5F, 0xD0, 0xB0, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xA0, 0x8F,
  0xD0, 0x27, 0x40, 0x1F, 0xD0, 0x90, 0x8F, 0xD0, 0x27, 0x40, 0x4F, 0xD0, 0x70, 0x8F, 0xD0, 0x27,
  0x40, 0x8F, 0xD0, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0xDF, 0xD0, 0x20, 0x8F, 0xD0, 0x27, 0x30, 0x4F,
  0xD8, 0x1E, 0x08, 0xFD, 0x02, 0x72, 0x01, 0x0D, 0xFD, 0x81, 0xA0, 0x8F, 0xD0, 0x27, 0x10, 0x10,
  0xBF, 0xE8, 0x15, 0x08, 0xFD, 0x02, 0x70, 0x50, 0xDF, 0xE0, 0xE2, 0x08, 0xFD, 0x86, 0x42, 0x22,
  0x35, 0x9D, 0xFF, 0x90, 0x92, 0x08, 0xFF, 0xFF, 0xE0, 0xE0, 0x12, 0x08, 0xFF, 0xFF, 0xE0, 0x73,
  0x08, 0xFF, 0xFF, 0xD0, 0xC4, 0x08, 0xFF, 0xFF, 0xC0, 0xE0, 0x14, 0x08, 0xFF, 0xFF, 0xB0, 0xE0,
  0x35, 0x08, 0xFF, 0xFF, 0xA0, 0xD0, 0x26, 0x08, 0xFF, 0xFF, 0x90, 0x97, 0x10, 0x8F, 0xFF, 0xE0,
  0xB0, 0x37, 0x20, 0x8F, 0xFF, 0xB8, 0x1D, 0x93, 0x74, 0x08, 0xFF, 0xB8, 0x5E, 0xDD, 0xB8, 0x63,
  0x77, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x74,
  // "Q" (U+0051)
  0x77, 0x48, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xEE, 0xDB, 0x96, 0x27, 0x77, 0x75, 0x81, 0x39, 0xEF,
  0xF9, 0x81, 0xE9, 0x37, 0x77, 0x70, 0x40, 0xCF, 0xFF, 0x0C, 0x04, 0x77, 0x73, 0x02, 0x0C, 0xFF,
  0xFC, 0x0B, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x57, 0x75, 0x08, 0xFF, 0xFF, 0xB0,
  0x77, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x77, 0x71, 0x07, 0xFF, 0xFF, 0xF0, 0x57, 0x60, 0x48, 0x0C,
  0x1F, 0x03, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xD7, 0x40, 0x98, 0x0C, 0x3F, 0x07, 0x72, 0x03,
  0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xFA, 0x01, 0x71, 0x0B, 0xFF, 0x0D, 0x04, 0x72,
  0x03, 0x0D, 0xFF, 0x09, 0x70, 0x3F, 0xF0, 0xB7, 0x60, 0xBF, 0xF0, 0x16, 0x09, 0xFE, 0x0D, 0x77,
  0x10, 0xCF, 0xE0, 0x76, 0x0E, 0xFE, 0x02, 0x77, 0x10, 0x2F, 0xE0, 0xD5, 0x05, 0xFE, 0x08, 0x77,
  0x30, 0x9F, 0xE0, 0x34, 0x0A, 0xFE, 0x01, 0x77, 0x30, 0x1F, 0xE0, 0x84, 0x0E, 0xFD, 0x0A, 0x77,
  0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77, 0x50, 0x5F, 0xE0, 0x12, 0x07, 0xFD, 0x0E, 0x77,
  0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77, 0x70, 0xCF, 0xD0, 0x82, 0x0D, 0xFD, 0x07, 0x77,
  0x70, 0x9F, 0xD0, 0xB2, 0xFE, 0x04, 0x77, 0x70, 0x6F, 0xD8, 0x1D, 0x02, 0xFE, 0x02, 0x77, 0x70,
  0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x02, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x03,
  0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x06,
  0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07,
  0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08,
  0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x09, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07,
  0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x08, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06,
  0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0B, 0x77, 0x72, 0x0E, 0xFD, 0x00,
  0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x03, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x17,
  0x77, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0x47, 0x77, 0x06, 0xFD, 0x0D, 0x20, 0xBF, 0xD0, 0x77, 0x77,
  0x09, 0xFD, 0x0B, 0x20, 0x8F, 0xD0, 0xA7, 0x77, 0x0C, 0xFD, 0x07, 0x20, 0x5F, 0xD0, 0xE7, 0x76,
  0x01, 0xFE, 0x04, 0x20, 0x2F, 0xE0, 0x47, 0x75, 0x05, 0xFE, 0x01, 0x30, 0xDF, 0xD0, 0x97, 0x75,
  0x0B, 0xFD, 0x0D, 0x40, 0x8F, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFE, 0x08, 0x40, 0x3F, 0xE0, 0x87,
  0x73, 0x09, 0xFE, 0x03, 0x50, 0xDF, 0xE0, 0x27, 0x71, 0x03, 0xFE, 0x0D, 0x60, 0x7F, 0xE0, 0xC7,
  0x71, 0x0D, 0xFE, 0x08, 0x60, 0x1F, 0xF0, 0xB7, 0x60, 0xBF, 0xF0, 0x27, 0x09, 0xFF, 0x0D, 0x03,
  0x72, 0x04, 0x0D, 0xFF, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0x98, 0x1B, 0x62, 0x38, 0x13, 0x6B, 0xFF,
  0xA0, 0x27, 0x20, 0x78, 0x0C, 0x3F, 0x09, 0x74, 0x0D, 0x80, 0xC1, 0xF0, 0xE0, 0x17, 0x40, 0x30,
  0xE8, 0x0C, 0x0F, 0x04, 0x76, 0x05, 0xFF, 0xFF, 0xF0, 0x77, 0x71, 0x08, 0xFF, 0xFF, 0xD0, 0x97,
  0x73, 0x07, 0xFF, 0xFF, 0xB0, 0x87, 0x75, 0x05, 0xFF, 0xFF, 0x0E, 0x05, 0x77, 0x70, 0x30, 0xDF,
  0xFF, 0xC0, 0xB0, 0x27, 0x77, 0x30, 0x60, 0xEF, 0xFF, 0xA0, 0x27, 0x77, 0x60, 0x50, 0xBF, 0xFF,
  0x0B, 0x77, 0x77, 0x18, 0x41, 0x48, 0xAC, 0xEF, 0xFA, 0x07, 0x80, 0xC1, 0x00, 0xDF, 0xE0, 0x28,
  0x0C, 0x00, 0x04, 0xFE, 0x0C, 0x80, 0xC1, 0x00, 0xAF, 0xE0, 0x88, 0x0C, 0x00, 0x01, 0x0E, 0xFE,
  0x03, 0x80, 0xC0, 0x00, 0x6F, 0xE0, 0xD8, 0x0C, 0x10, 0x0C, 0xFE, 0x09, 0x80, 0xC0, 0x00, 0x2F,
  0xF0, 0x48, 0x0C, 0x00, 0x08, 0xFE, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0xDF, 0xE0, 0xA8, 0x0C, 0x00,
  0x04, 0xFF, 0x05, 0x80, 0xC0, 0x00, 0xAF, 0xE0, 0xE0, 0x17, 0x77, 0x77, 0x01, 0x0E, 0xFE, 0x0B,
  0x80, 0xC0, 0x00, 0x6F, 0xF0, 0x68, 0x0C, 0x00, 0x0C, 0xFF, 0x02, 0x77, 0x77, 0x70, 0x28, 0x09,
  0x27, 0x04, 0x10,
  // "R" (U+0052)
  0x08, 0xFF, 0xB8, 0x5E, 0xEC, 0xB9, 0x74, 0x77, 0x50, 0x8F, 0xFF, 0xC8, 0x1C, 0x72, 0x77, 0x10,
  0x8F, 0xFF, 0xF0, 0xB0, 0x47, 0x60, 0x8F, 0xFF, 0xFA, 0x0B, 0x01, 0x74, 0x08, 0xFF, 0xFF, 0xB0,
  0xE0, 0x47, 0x30, 0x8F, 0xFF, 0xFD, 0x05, 0x72, 0x08, 0xFF, 0xFF, 0xE0, 0x47, 0x10, 0x8F, 0xFF,
  0xFE, 0x0E, 0x01, 0x70, 0x8F, 0xFF, 0xFF, 0x09, 0x70, 0x88, 0x0C, 0x0F, 0x02, 0x60, 0x8F, 0xD8,
  0x64, 0x22, 0x23, 0x47, 0xBF, 0xFA, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x01, 0x08, 0xFF, 0x0E, 0x60,
  0x8F, 0xD0, 0x27, 0x20, 0x4F, 0xF0, 0x35, 0x08, 0xFD, 0x02, 0x73, 0x05, 0xFE, 0x07, 0x50, 0x8F,
  0xD0, 0x27, 0x40, 0xCF, 0xD0, 0xA5, 0x08, 0xFD, 0x02, 0x74, 0x06, 0xFD, 0x0C, 0x50, 0x8F, 0xD0,
  0x27, 0x40, 0x3F, 0xD0, 0xE5, 0x08, 0xFD, 0x02, 0x74, 0x01, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27,
  0x5F, 0xE5, 0x08, 0xFD, 0x02, 0x75, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xD5, 0x08,
  0xFD, 0x02, 0x74, 0x02, 0xFD, 0x0C, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0x5F, 0xD0, 0xA5, 0x08, 0xFD,
  0x02, 0x74, 0x0A, 0xFD, 0x07, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x1F, 0xE0, 0x45, 0x08, 0xFD, 0x02,
  0x73, 0x0A, 0xFD, 0x0E, 0x60, 0x8F, 0xD0, 0x27, 0x20, 0x8F, 0xE0, 0x96, 0x08, 0xFD, 0x02, 0x70,
  0x20, 0xBF, 0xF0, 0x26, 0x08, 0xFD, 0x86, 0x42, 0x22, 0x34, 0x7B, 0xFF, 0x90, 0xA7, 0x08, 0xFF,
  0xFF, 0xE0, 0xE0, 0x17, 0x08, 0xFF, 0xFF, 0xE0, 0x57, 0x10, 0x8F, 0xFF, 0xFD, 0x07, 0x72, 0x08,
  0xFF, 0xFF, 0xC0, 0x87, 0x30, 0x8F, 0xFF, 0xFB, 0x07, 0x74, 0x08, 0xFF, 0xFF, 0x90, 0xD0, 0x47,
  0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x70, 0x8F, 0xFF, 0xF0, 0x57, 0x70, 0x8F, 0xFF, 0xF0, 0xD7, 0x70,
  0x8F, 0xFF, 0xF9, 0x06, 0x76, 0x08, 0xFD, 0x02, 0x40, 0xCF, 0xC0, 0xE7, 0x60, 0x8F, 0xD0, 0x24,
  0x05, 0xFD, 0x07, 0x75, 0x08, 0xFD, 0x02, 0x50, 0xDF, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0xD0, 0x25,
  0x06, 0xFD, 0x08, 0x74, 0x08, 0xFD, 0x02, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x30, 0x8F, 0xD0, 0x26,
  0x06, 0xFD, 0x09, 0x73, 0x08, 0xFD, 0x02, 0x70, 0xEF, 0xD0, 0x27, 0x20, 0x8F, 0xD0, 0x27, 0x07,
  0xFD, 0x0A, 0x72, 0x08, 0xFD, 0x02, 0x71, 0x0E, 0xFD, 0x03, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x08,
  0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x01, 0x0E, 0xFD, 0x03, 0x70, 0x8F, 0xD0, 0x27, 0x20,
  0x8F, 0xD0, 0xC7, 0x08, 0xFD, 0x02, 0x72, 0x01, 0xFE, 0x04, 0x60, 0x8F, 0xD0, 0x27, 0x30, 0x9F,
  0xD0, 0xC6, 0x08, 0xFD, 0x02, 0x73, 0x02, 0xFE, 0x05, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD0,
  0xD5, 0x08, 0xFD, 0x02, 0x74, 0x02, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27, 0x50, 0xAF, 0xD0, 0xE4,
  0x08, 0xFD, 0x02, 0x75, 0x03, 0xFE, 0x07, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0xBF, 0xD0, 0xE0, 0x12,
  0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x08, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0xBF, 0xE8, 0x11, 0x08,
  0xFD, 0x02, 0x77, 0x04, 0xFE, 0x81, 0x90, 0x8F, 0xD0, 0x27, 0x71, 0x0C, 0xFE, 0x02, 0x08, 0xFD,
  0x02, 0x77, 0x10, 0x5F, 0xE0, 0xA0,
  // "S" (U+0053)
  0x76, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x58, 0x12, 0x8D, 0xFF, 0x98,
  0x1D, 0x83, 0x77, 0x01, 0x09, 0xFF, 0xF8, 0x1D, 0x82, 0x73, 0x05, 0x0E, 0xFF, 0xFC, 0x0A, 0x03,
  0x70, 0x9F, 0xFF, 0xF9, 0x02, 0x50, 0x9F, 0xFF, 0xF9, 0x0D, 0x50, 0x8F, 0xFF, 0xFA, 0x08, 0x40,
  0x4F, 0xFF, 0xFB, 0x03, 0x40, 0xDF, 0xFF, 0xFA, 0x0D, 0x40, 0x6F, 0xFF, 0xFB, 0x08, 0x40, 0xDF,
  0xFF, 0xFB, 0x02, 0x30, 0x3F, 0xF8, 0x1D, 0x62, 0x28, 0x31, 0x25, 0x9E, 0xF0, 0xD4, 0x08, 0xFE,
  0x08, 0x73, 0x04, 0x0A, 0xD0, 0x84, 0x0B, 0xFD, 0x08, 0x76, 0x02, 0x0A, 0xB0, 0x24, 0x0E, 0xFC,
  0x0E, 0x77, 0x28, 0x13, 0xCD, 0x40, 0x1F, 0xD0, 0x97, 0x74, 0x02, 0x40, 0x2F, 0xD0, 0x67, 0x77,
  0x20, 0x3F, 0xD0, 0x67, 0x77, 0x20, 0x3F, 0xD0, 0x77, 0x77, 0x20, 0x2F, 0xD0, 0xA7, 0x77, 0x20,
  0x1F, 0xD0, 0xE7, 0x77, 0x3F, 0xE0, 0x77, 0x77, 0x20, 0xDF, 0xE0, 0x47, 0x77, 0x10, 0xAF, 0xF0,
  0x57, 0x77, 0x06, 0xFF, 0x90, 0x97, 0x76, 0x01, 0xFF, 0xA0, 0xD0, 0x57, 0x75, 0x0A, 0xFF, 0xB0,
  0xB0, 0x27, 0x73, 0x03, 0xFF, 0xD0, 0x90, 0x17, 0x72, 0x09, 0xFF, 0xD0, 0xE0, 0x67, 0x71, 0x01,
  0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x70, 0x30, 0xEF, 0xFF, 0x07, 0x77, 0x04, 0xFF, 0xF9, 0x0B, 0x01,
  0x76, 0x03, 0x0E, 0xFF, 0xF0, 0xD0, 0x27, 0x60, 0x10, 0xBF, 0xFF, 0x0E, 0x03, 0x77, 0x07, 0xFF,
  0xF0, 0xE0, 0x27, 0x70, 0x30, 0xCF, 0xFE, 0x0E, 0x01, 0x77, 0x10, 0x60, 0xEF, 0xFD, 0x0B, 0x77,
  0x20, 0x10, 0x9F, 0xFD, 0x05, 0x77, 0x30, 0x30, 0xCF, 0xFB, 0x0D, 0x77, 0x50, 0x7F, 0xFB, 0x04,
  0x77, 0x50, 0x20, 0xDF, 0xF9, 0x0A, 0x77, 0x70, 0xAF, 0xF0, 0xE7, 0x77, 0x10, 0x8F, 0xF0, 0x17,
  0x77, 0x10, 0xAF, 0xE0, 0x47, 0x77, 0x10, 0x1F, 0xE0, 0x57, 0x77, 0x20, 0xAF, 0xD0, 0x67, 0x77,
  0x20, 0x6F, 0xD0, 0x77, 0x77, 0x20, 0x4F, 0xD0, 0x77, 0x77, 0x20, 0x4F, 0xD0, 0x67, 0x77, 0x20,
  0x6F, 0xD8, 0x14, 0x73, 0x77, 0x70, 0xAF, 0xD8, 0x32, 0xBF, 0xB3, 0x77, 0x40, 0x2F, 0xD8, 0x1E,
  0x0B, 0xB0, 0xB0, 0x57, 0x72, 0x0B, 0xFD, 0x81, 0xB0, 0xBD, 0x81, 0xE9, 0x47, 0x50, 0xAF, 0xE8,
  0x16, 0x0B, 0xF9, 0x84, 0xEA, 0x74, 0x21, 0x28, 0x21, 0x48, 0xEF, 0xF8, 0x11, 0x0B, 0xFF, 0xFF,
  0xD0, 0x92, 0x0B, 0xFF, 0xFF, 0xD0, 0x22, 0x0B, 0xFF, 0xFF, 0xC0, 0x73, 0x0B, 0xFF, 0xFF, 0xB0,
  0xC4, 0x0B, 0xFF, 0xFF, 0xA0, 0xE0, 0x24, 0x0B, 0xFF, 0xFF, 0x90, 0xE0, 0x35, 0x0B, 0xFF, 0xFF,
  0x0D, 0x02, 0x60, 0x8F, 0xFF, 0xE0, 0x90, 0x17, 0x18, 0x12, 0x8E, 0xFF, 0xF9, 0x0C, 0x04, 0x76,
  0x81, 0x49, 0xDF, 0xFA, 0x81, 0xEA, 0x37, 0x74, 0x86, 0x14, 0x79, 0xBC, 0xDE, 0xA8, 0x4E, 0xDC,
  0x97, 0x37, 0x70,
  // "T" (U+0054)
  0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C,
  0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30,
  0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3,
  0xF0, 0x37, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x70,
  // "U" (U+0055)
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0D, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xD7, 0x74, 0xFD, 0x0B, 0x0C, 0xFC, 0x0E, 0x77, 0x4F, 0xD0, 0xA0,
  0xBF, 0xD7, 0x73, 0x02, 0xFD, 0x09, 0x0A, 0xFD, 0x03, 0x77, 0x20, 0x5F, 0xD0, 0x08, 0xFD, 0x06,
  0x77, 0x20, 0x8F, 0xD0, 0x06, 0xFD, 0x0B, 0x77, 0x20, 0xDF, 0xD0, 0x03, 0xFE, 0x01, 0x77, 0x03,
  0xFE, 0x20, 0xEF, 0xD0, 0xA7, 0x70, 0xBF, 0xD0, 0xC2, 0x0A, 0xFE, 0x06, 0x75, 0x08, 0xFE, 0x08,
  0x20, 0x5F, 0xF0, 0x87, 0x20, 0x10, 0x9F, 0xF0, 0x33, 0x0E, 0xFF, 0x82, 0xE8, 0x41, 0x28, 0x21,
  0x48, 0xEF, 0xF0, 0xC4, 0x08, 0x80, 0xC2, 0xF0, 0x54, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xD6, 0x07,
  0x80, 0xC0, 0xF0, 0x37, 0x0C, 0xFF, 0xFF, 0xE0, 0x87, 0x10, 0x10, 0xDF, 0xFF, 0xFC, 0x0B, 0x73,
  0x02, 0x0E, 0xFF, 0xFF, 0xA0, 0xB7, 0x50, 0x20, 0xDF, 0xFF, 0xF0, 0xA7, 0x71, 0x09, 0xFF, 0xFC,
  0x0E, 0x06, 0x77, 0x30, 0x30, 0xBF, 0xFF, 0x90, 0x90, 0x17, 0x76, 0x81, 0x28, 0xDF, 0xFA, 0x81,
  0xC7, 0x17, 0x77, 0x48, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77,
  // "V" (U+0056)
  0x0D, 0xFD, 0x04, 0x77, 0x71, 0x04, 0xFD, 0x0B, 0x09, 0xFD, 0x07, 0x77, 0x71, 0x08, 0xFD, 0x06,
  0x04, 0xFD, 0x0B, 0x77, 0x71, 0x0C, 0xFD, 0x02, 0x1F, 0xE7, 0x77, 0x01, 0xFD, 0x0D, 0x20, 0xBF,
  0xD0, 0x37, 0x76, 0x04, 0xFD, 0x09, 0x20, 0x7F, 0xD0, 0x77, 0x76, 0x08, 0xFD, 0x05, 0x20, 0x3F,
  0xD0, 0xB7, 0x76, 0x0C, 0xFD, 0x01, 0x30, 0xEF, 0xC0, 0xE7, 0x75, 0x01, 0xFD, 0x0C, 0x40, 0xAF,
  0xD0, 0x37, 0x74, 0x04, 0xFD, 0x07, 0x40, 0x5F, 0xD0, 0x77, 0x74, 0x08, 0xFD, 0x03, 0x40, 0x1F,
  0xD0, 0xA7, 0x74, 0x0C, 0xFC, 0x0E, 0x60, 0xCF, 0xC0, 0xE7, 0x73, 0x01, 0xFD, 0x0A, 0x60, 0x8F,
  0xD0, 0x27, 0x72, 0x04, 0xFD, 0x06, 0x60, 0x4F, 0xD0, 0x67, 0x72, 0x08, 0xFD, 0x01, 0x7F, 0xD0,
  0xA7, 0x72, 0x0C, 0xFC, 0x0D, 0x71, 0x0B, 0xFC, 0x0E, 0x77, 0x2F, 0xD0, 0x87, 0x10, 0x7F, 0xD0,
  0x27, 0x70, 0x4F, 0xD0, 0x47, 0x10, 0x2F, 0xD0, 0x67, 0x70, 0x8F, 0xD7, 0x30, 0xDF, 0xC0, 0xA7,
  0x70, 0xCF, 0xC0, 0xB7, 0x30, 0x9F, 0xC0, 0xD7, 0x7F, 0xD0, 0x77, 0x30, 0x5F, 0xD0, 0x27, 0x50,
  0x4F, 0xD0, 0x27, 0x30, 0x1F, 0xD0, 0x67, 0x50, 0x8F, 0xC0, 0xD7, 0x50, 0xCF, 0xC0, 0x97, 0x50,
  0xCF, 0xC0, 0x97, 0x50, 0x8F, 0xC0, 0xD7, 0x5F, 0xD0, 0x57, 0x50, 0x3F, 0xD0, 0x17, 0x30, 0x4F,
  0xD0, 0x17, 0x60, 0xEF, 0xC0, 0x57, 0x30, 0x8F, 0xC0, 0xC7, 0x70, 0xAF, 0xC0, 0x97, 0x30, 0xCF,
  0xC0, 0x77, 0x70, 0x6F, 0xC0, 0xD7, 0x3F, 0xD0, 0x37, 0x70, 0x2F, 0xD0, 0x17, 0x10, 0x4F, 0xC0,
  0xE7, 0x72, 0x0D, 0xFC, 0x05, 0x71, 0x08, 0xFC, 0x0A, 0x77, 0x20, 0x9F, 0xC0, 0x97, 0x10, 0xCF,
  0xC0, 0x67, 0x72, 0x05, 0xFC, 0x0C, 0x71, 0xFD, 0x02, 0x77, 0x3F, 0xD0, 0x16, 0x04, 0xFC, 0x0D,
  0x77, 0x40, 0xBF, 0xC0, 0x46, 0x08, 0xFC, 0x08, 0x77, 0x40, 0x7F, 0xC0, 0x86, 0x0C, 0xFC, 0x04,
  0x77, 0x40, 0x3F, 0xC0, 0xC6, 0xFD, 0x77, 0x60, 0xEF, 0xC5, 0x04, 0xFC, 0x0B, 0x77, 0x60, 0xAF,
  0xC0, 0x44, 0x08, 0xFC, 0x07, 0x77, 0x60, 0x6F, 0xC0, 0x84, 0x0B, 0xFC, 0x02, 0x77, 0x60, 0x1F,
  0xC0, 0xB4, 0x0E, 0xFB, 0x0E, 0x77, 0x71, 0x0D, 0xFB, 0x0E, 0x30, 0x2F, 0xC0, 0x97, 0x77, 0x10,
  0x8F, 0xC0, 0x22, 0x06, 0xFC, 0x05, 0x77, 0x71, 0x04, 0xFC, 0x05, 0x20, 0x9F, 0xC0, 0x17, 0x77,
  0x2F, 0xC0, 0x82, 0x0B, 0xFB, 0x0C, 0x77, 0x73, 0x0B, 0xFB, 0x0B, 0x20, 0xEF, 0xB0, 0x87, 0x77,
  0x30, 0x7F, 0xB8, 0x1E, 0x02, 0xFC, 0x03, 0x77, 0x73, 0x02, 0xFC, 0x01, 0x04, 0xFB, 0x0E, 0x77,
  0x75, 0x0E, 0xFB, 0x04, 0x07, 0xFB, 0x0A, 0x77, 0x75, 0x09, 0xFB, 0x07, 0x09, 0xFB, 0x06, 0x77,
  0x75, 0x05, 0xFB, 0x09, 0x0C, 0xFB, 0x02, 0x77, 0x75, 0x01, 0xFB, 0x0C, 0x0E, 0xFA, 0x0D, 0x77,
  0x77, 0x0C, 0xFF, 0xE0, 0x97, 0x77, 0x70, 0x8F, 0xFE, 0x04, 0x77, 0x77, 0x03, 0xFF, 0xE7, 0x77,
  0x72, 0x0E, 0xFF, 0xC0, 0xB7, 0x77, 0x72, 0x0A, 0xFF, 0xC0, 0x77, 0x77, 0x72, 0x06, 0xFF, 0xC0,
  0x37, 0x77, 0x72, 0x02, 0xFF, 0xB0, 0xE7, 0x77, 0x74, 0x0D, 0xFF, 0xA0, 0xA7, 0x77, 0x74, 0x09,
  0xFF, 0xA0, 0x57, 0x77, 0x74, 0x05, 0xFF, 0xA0, 0x17, 0x77, 0x74, 0x01, 0xFF, 0x90, 0xC7, 0x77,
  0x76, 0x0C, 0xFF, 0x08, 0x77, 0x77, 0x60, 0x7F, 0xF0, 0x47, 0x73,
  // "W" (U+0057)
  0x0C, 0xFC, 0x09, 0x77, 0x40, 0x2F, 0xC0, 0x17, 0x74, 0x0E, 0xFC, 0x0A, 0x09, 0xFC, 0x0C, 0x77,
  0x40, 0x5F, 0xC0, 0x57, 0x73, 0x01, 0xFD, 0x07, 0x05, 0xFD, 0x77, 0x40, 0x9F, 0xC0, 0x87, 0x73,
  0x04, 0xFD, 0x04, 0x02, 0xFD, 0x03, 0x77, 0x30, 0xCF, 0xC0, 0xB7, 0x73, 0x07, 0xFD, 0x20, 0xEF,
  0xC0, 0x67, 0x73, 0xFD, 0x0E, 0x77, 0x30, 0xBF, 0xC0, 0xC2, 0x0B, 0xFC, 0x09, 0x77, 0x20, 0x4F,
  0xE0, 0x27, 0x72, 0x0E, 0xFC, 0x09, 0x20, 0x7F, 0xC0, 0xC7, 0x72, 0x07, 0xFE, 0x06, 0x77, 0x10,
  0x1F, 0xD0, 0x62, 0x04, 0xFD, 0x77, 0x20, 0xBF, 0xE0, 0x97, 0x71, 0x04, 0xFD, 0x02, 0x20, 0x1F,
  0xD0, 0x27, 0x71, 0x0E, 0xFE, 0x0C, 0x77, 0x10, 0x7F, 0xC0, 0xE4, 0x0D, 0xFC, 0x06, 0x77, 0x02,
  0xFF, 0x97, 0x71, 0x0B, 0xFC, 0x0B, 0x40, 0xAF, 0xC0, 0x97, 0x70, 0x5F, 0xF9, 0x03, 0x77, 0x0E,
  0xFC, 0x08, 0x40, 0x6F, 0xC0, 0xC7, 0x70, 0x9F, 0xF9, 0x07, 0x76, 0x01, 0xFD, 0x05, 0x40, 0x3F,
  0xC0, 0xE7, 0x70, 0xCF, 0xF9, 0x0A, 0x76, 0x04, 0xFD, 0x01, 0x5F, 0xD0, 0x27, 0x6F, 0xFA, 0x0D,
  0x76, 0x07, 0xFC, 0x0E, 0x60, 0xCF, 0xC0, 0x57, 0x50, 0x4F, 0xFB, 0x01, 0x75, 0x0B, 0xFC, 0x0A,
  0x60, 0x8F, 0xC0, 0x87, 0x50, 0x7F, 0xFB, 0x04, 0x75, 0x0E, 0xFC, 0x07, 0x60, 0x5F, 0xC0, 0xB7,
  0x50, 0xBF, 0xFB, 0x07, 0x74, 0x01, 0xFD, 0x04, 0x60, 0x2F, 0xC0, 0xE7, 0x50, 0xEF, 0xFB, 0x0B,
  0x74, 0x04, 0xFD, 0x71, 0x0E, 0xFC, 0x02, 0x73, 0x02, 0xFA, 0x0D, 0xF9, 0x0E, 0x74, 0x07, 0xFC,
  0x0D, 0x71, 0x0B, 0xFC, 0x05, 0x73, 0x05, 0xFA, 0x09, 0xFA, 0x02, 0x73, 0x0B, 0xFC, 0x09, 0x71,
  0x07, 0xFC, 0x08, 0x73, 0x09, 0xFA, 0x06, 0xFA, 0x05, 0x73, 0x0E, 0xFC, 0x06, 0x71, 0x04, 0xFC,
  0x0B, 0x73, 0x0C, 0xFA, 0x02, 0xFA, 0x08, 0x72, 0x01, 0xFD, 0x03, 0x71, 0x01, 0xFC, 0x0E, 0x73,
  0xFA, 0x0D, 0x1F, 0xA0, 0xC7, 0x20, 0x4F, 0xC0, 0xE7, 0x30, 0xDF, 0xC0, 0x27, 0x10, 0x4F, 0xA8,
  0x1B, 0x0D, 0xFA, 0x72, 0x07, 0xFC, 0x0B, 0x73, 0x09, 0xFC, 0x05, 0x71, 0x07, 0xFA, 0x81, 0x80,
  0xAF, 0xA0, 0x37, 0x10, 0xBF, 0xC0, 0x87, 0x30, 0x6F, 0xC0, 0x87, 0x10, 0xBF, 0xA8, 0x15, 0x08,
  0xFA, 0x06, 0x71, 0x0E, 0xFC, 0x05, 0x73, 0x03, 0xFC, 0x0B, 0x71, 0x0E, 0xFA, 0x81, 0x30, 0x6F,
  0xA0, 0x97, 0x01, 0xFD, 0x01, 0x74, 0xFC, 0x0E, 0x70, 0x2F, 0xB2, 0x03, 0xFA, 0x0D, 0x70, 0x4F,
  0xC0, 0xE7, 0x50, 0xCF, 0xC0, 0x26, 0x05, 0xFA, 0x0D, 0x3F, 0xB7, 0x07, 0xFC, 0x0A, 0x75, 0x08,
  0xFC, 0x05, 0x60, 0x9F, 0xA0, 0xB3, 0x0D, 0xFA, 0x04, 0x60, 0xBF, 0xC0, 0x77, 0x50, 0x5F, 0xC0,
  0x86, 0x0C, 0xFA, 0x08, 0x30, 0xAF, 0xA0, 0x76, 0x0E, 0xFC, 0x04, 0x75, 0x02, 0xFC, 0x0B, 0x6F,
  0xB0, 0x53, 0x07, 0xFA, 0x0A, 0x50, 0x1F, 0xD0, 0x17, 0x60, 0xEF, 0xB0, 0xE5, 0x04, 0xFB, 0x02,
  0x30, 0x5F, 0xA0, 0xD5, 0x04, 0xFC, 0x0D, 0x77, 0x0A, 0xFC, 0x01, 0x40, 0x7F, 0xA0, 0xE4, 0x01,
  0xFB, 0x01, 0x40, 0x7F, 0xC0, 0x97, 0x70, 0x7F, 0xC0, 0x44, 0x0A, 0xFA, 0x0B, 0x50, 0xEF, 0xA0,
  0x44, 0x0A, 0xFC, 0x06, 0x77, 0x04, 0xFC, 0x07, 0x40, 0xDF, 0xA0, 0x85, 0x0A, 0xFA, 0x07, 0x40,
  0xDF, 0xC0, 0x37, 0x71, 0xFC, 0x0A, 0x4F, 0xB0, 0x55, 0x07, 0xFA, 0x0A, 0x4F, 0xD7, 0x72, 0x0D,
  0xFB, 0x0C, 0x30, 0x3F, 0xB0, 0x15, 0x03, 0xFA, 0x0D, 0x30, 0x3F, 0xC0, 0xC7, 0x72, 0x09, 0xFC,
  0x30, 0x6F, 0xA0, 0xD7, 0xFB, 0x30, 0x6F, 0xC0, 0x87, 0x72, 0x06, 0xFC, 0x02, 0x20, 0x9F, 0xA0,
  0xA7, 0x0C, 0xFA, 0x03, 0x20, 0x8F, 0xC0, 0x57, 0x72, 0x03, 0xFC, 0x04, 0x20, 0xBF, 0xA0, 0x77,
  0x09, 0xFA, 0x05, 0x20, 0xBF, 0xC0, 0x27, 0x73, 0x0E, 0xFB, 0x06, 0x20, 0xEF, 0xA0, 0x37, 0x05,
  0xFA, 0x08, 0x20, 0xDF, 0xB0, 0xE7, 0x74, 0x0B, 0xFB, 0x81, 0x90, 0x1F, 0xB7, 0x10, 0x2F, 0xA0,
  0xA2, 0xFC, 0x0A, 0x77, 0x40, 0x8F, 0xB8, 0x1B, 0x04, 0xFA, 0x0C, 0x72, 0x0E, 0xF9, 0x81, 0xD0,
  0x3F, 0xC0, 0x77, 0x74, 0x05, 0xFB, 0x81, 0xD0, 0x6F, 0xA0, 0x97, 0x20, 0xBF, 0xA1, 0x05, 0xFC,
  0x04, 0x77, 0x40, 0x1F, 0xC1, 0x09, 0xFA, 0x05, 0x72, 0x07, 0xFA, 0x02, 0x07, 0xFC, 0x01, 0x77,
  0x50, 0xEF, 0xB0, 0x20, 0xBF, 0xA0, 0x27, 0x20, 0x4F, 0xA0, 0x50, 0x9F, 0xB0, 0xD7, 0x76, 0x0A,
  0xFB, 0x04, 0x0D, 0xF9, 0x0E, 0x73, 0x01, 0xFA, 0x07, 0x0B, 0xFB, 0x09, 0x77, 0x60, 0x7F, 0xB0,
  0x7F, 0xA0, 0xB7, 0x40, 0xDF, 0x90, 0x90, 0xDF, 0xB0, 0x67, 0x76, 0x04, 0xFB, 0x0B, 0xFA, 0x07,
  0x74, 0x09, 0xF9, 0x0B, 0xFC, 0x03, 0x77, 0x7F, 0xB0, 0xEF, 0xA0, 0x47, 0x40, 0x6F, 0x90, 0xEF,
  0xC7, 0x77, 0x10, 0xCF, 0xFD, 0x01, 0x74, 0x03, 0xFF, 0xD0, 0xC7, 0x77, 0x10, 0x9F, 0xFC, 0x0D,
  0x76, 0x0E, 0xFF, 0xC0, 0x87, 0x77, 0x10, 0x6F, 0xFC, 0x09, 0x76, 0x0B, 0xFF, 0xC0, 0x57, 0x77,
  0x10, 0x2F, 0xFC, 0x06, 0x76, 0x08, 0xFF, 0xC0, 0x27, 0x77, 0x20, 0xEF, 0xFB, 0x03, 0x76, 0x05,
  0xFF, 0xB0, 0xE7, 0x77, 0x30, 0xBF, 0xFA, 0x0E, 0x77, 0x01, 0xFF, 0xB0, 0xB7, 0x77, 0x30, 0x8F,
  0xFA, 0x0B, 0x77, 0x10, 0xDF, 0xFA, 0x07, 0x77, 0x73, 0x05, 0xFF, 0xA0, 0x87, 0x71, 0x0A, 0xFF,
  0xA0, 0x47, 0x77, 0x30, 0x1F, 0xFA, 0x05, 0x77, 0x10, 0x7F, 0xFA, 0x01, 0x77, 0x74, 0x0D, 0xFF,
  0x90, 0x17, 0x71, 0x03, 0xFF, 0x90, 0xD7, 0x77, 0x50, 0xAF, 0xF0, 0xD7, 0x73, 0xFF, 0x90, 0x97,
  0x77, 0x50, 0x7F, 0xF0, 0xA7, 0x73, 0x0C, 0xFF, 0x06, 0x77, 0x75, 0x03, 0xFF, 0x07, 0x77, 0x30,
  0x9F, 0xF0, 0x37, 0x60,
  // "X" (U+0058)
  0x10, 0x7F, 0xD0, 0xE7, 0x73, 0x06, 0xFD, 0x0E, 0x01, 0x20, 0x10, 0xEF, 0xD0, 0x67, 0x72, 0x0D,
  0xFD, 0x08, 0x40, 0x8F, 0xD0, 0xC7, 0x71, 0x04, 0xFE, 0x01, 0x40, 0x1F, 0xE0, 0x37, 0x70, 0xAF,
  0xD0, 0x96, 0x09, 0xFD, 0x0A, 0x76, 0x01, 0xFE, 0x02, 0x60, 0x2F, 0xE0, 0x17, 0x50, 0x7F, 0xD0,
  0xA7, 0x10, 0xAF, 0xD0, 0x77, 0x50, 0xDF, 0xD0, 0x27, 0x10, 0x2F, 0xD0, 0xD7, 0x40, 0x5F, 0xD0,
  0xB7, 0x30, 0xAF, 0xD0, 0x57, 0x30, 0xBF, 0xD0, 0x37, 0x30, 0x3F, 0xD0, 0xB7, 0x20, 0x2F, 0xD0,
  0xB7, 0x50, 0xBF, 0xD0, 0x27, 0x10, 0x8F, 0xD0, 0x47, 0x50, 0x4F, 0xD0, 0x97, 0x10, 0xEF, 0xC0,
  0xC7, 0x70, 0xCF, 0xC0, 0xE7, 0x06, 0xFD, 0x05, 0x77, 0x05, 0xFD, 0x06, 0x60, 0xCF, 0xC0, 0xD7,
  0x72, 0x0D, 0xFC, 0x0D, 0x50, 0x3F, 0xD0, 0x67, 0x72, 0x05, 0xFD, 0x04, 0x40, 0x9F, 0xC0, 0xD7,
  0x74, 0x0D, 0xFC, 0x0A, 0x30, 0x10, 0xEF, 0xC0, 0x67, 0x74, 0x06, 0xFD, 0x01, 0x20, 0x6F, 0xC0,
  0xE7, 0x76, 0x0E, 0xFC, 0x08, 0x20, 0xDF, 0xC0, 0x77, 0x76, 0x07, 0xFC, 0x81, 0xE0, 0x4F, 0xC0,
  0xE0, 0x17, 0x77, 0x0E, 0xFC, 0x05, 0x0A, 0xFC, 0x08, 0x77, 0x71, 0x08, 0xFC, 0x0D, 0xFD, 0x01,
  0x77, 0x71, 0x01, 0x0E, 0xFF, 0xF9, 0x09, 0x77, 0x73, 0x09, 0xFF, 0xF9, 0x02, 0x77, 0x73, 0x01,
  0xFF, 0xF0, 0xA7, 0x77, 0x50, 0x9F, 0xFE, 0x02, 0x77, 0x75, 0x02, 0xFF, 0xD0, 0xB7, 0x77, 0x70,
  0xAF, 0xFC, 0x03, 0x77, 0x77, 0x03, 0xFF, 0xB0, 0xB7, 0x77, 0x72, 0x0B, 0xFF, 0xA0, 0x47, 0x77,
  0x72, 0x04, 0xFF, 0x90, 0xC7, 0x77, 0x74, 0x0C, 0xFF, 0x05, 0x77, 0x77, 0x40, 0xEF, 0xF0, 0x67,
  0x77, 0x73, 0x07, 0xFF, 0x90, 0xE7, 0x77, 0x73, 0x0E, 0xFF, 0xA0, 0x77, 0x77, 0x71, 0x07, 0xFF,
  0xB0, 0xE7, 0x77, 0x71, 0x0E, 0xFF, 0xC0, 0x77, 0x77, 0x60, 0x7F, 0xFD, 0x0E, 0x01, 0x77, 0x74,
  0x01, 0x0E, 0xFF, 0xE0, 0x87, 0x77, 0x40, 0x7F, 0xFF, 0x0E, 0x01, 0x77, 0x72, 0x01, 0x0E, 0xFF,
  0xF9, 0x08, 0x77, 0x72, 0x08, 0xFF, 0xFB, 0x01, 0x77, 0x70, 0x10, 0xEF, 0xC0, 0x90, 0xEF, 0xC0,
  0x97, 0x77, 0x08, 0xFD, 0x01, 0x09, 0xFD, 0x02, 0x77, 0x50, 0x10, 0xEF, 0xC8, 0x19, 0x02, 0xFD,
  0x09, 0x77, 0x50, 0x8F, 0xD0, 0x22, 0x0A, 0xFD, 0x02, 0x77, 0x30, 0x10, 0xEF, 0xC0, 0xA3, 0x03,
  0xFD, 0x0A, 0x77, 0x30, 0x8F, 0xD0, 0x34, 0x0B, 0xFD, 0x02, 0x77, 0x10, 0x10, 0xEF, 0xC0, 0xB5,
  0x04, 0xFD, 0x0A, 0x77, 0x10, 0x8F, 0xD0, 0x36, 0x0C, 0xFD, 0x03, 0x76, 0x01, 0xFD, 0x0C, 0x70,
  0x5F, 0xD0, 0xB7, 0x60, 0x9F, 0xD0, 0x47, 0x10, 0xDF, 0xD0, 0x37, 0x40, 0x1F, 0xD0, 0xC7, 0x20,
  0x6F, 0xD0, 0xB7, 0x40, 0x9F, 0xD0, 0x57, 0x30, 0xEF, 0xD0, 0x47, 0x20, 0x1F, 0xD0, 0xD7, 0x40,
  0x8F, 0xD0, 0xC7, 0x20, 0x9F, 0xD0, 0x67, 0x40, 0x1F, 0xE0, 0x47, 0x02, 0xFD, 0x0E, 0x76, 0x09,
  0xFD, 0x0C, 0x70, 0x9F, 0xD0, 0x77, 0x60, 0x2F, 0xE0, 0x55, 0x02, 0xFD, 0x0E, 0x77, 0x10, 0xAF,
  0xD0, 0xD5, 0x09, 0xFD, 0x08, 0x77, 0x10, 0x3F, 0xE0, 0x53, 0x02, 0xFE, 0x01, 0x77, 0x20, 0xBF,
  0xD0, 0xD3, 0x09, 0xFD, 0x09, 0x77, 0x30, 0x4F, 0xE8, 0x16, 0x02, 0xFE, 0x02, 0x77, 0x40, 0xDF,
  0xD8, 0x1D, 0x0A, 0xFD, 0x09, 0x77, 0x50, 0x6F, 0xE0, 0x60,
  // "Y" (U+0059)
  0x0C, 0xFD, 0x09, 0x77, 0x50, 0xCF, 0xD0, 0x70, 0x5F, 0xD0, 0xE7, 0x74, 0x02, 0xFE, 0x81, 0x10,
  0xEF, 0xD0, 0x57, 0x73, 0x08, 0xFD, 0x09, 0x20, 0x7F, 0xD0, 0xB7, 0x73, 0x0E, 0xFD, 0x03, 0x20,
  0x1F, 0xE0, 0x17, 0x71, 0x05, 0xFD, 0x0B, 0x40, 0xAF, 0xD0, 0x77, 0x71, 0x0B, 0xFD, 0x05, 0x40,
  0x3F, 0xD0, 0xD7, 0x70, 0x1F, 0xD0, 0xD6, 0x0C, 0xFD, 0x04, 0x76, 0x07, 0xFD, 0x07, 0x60, 0x5F,
  0xD0, 0xA7, 0x60, 0xDF, 0xD0, 0x17, 0x0E, 0xFD, 0x01, 0x74, 0x03, 0xFD, 0x09, 0x71, 0x08, 0xFD,
  0x06, 0x74, 0x09, 0xFD, 0x03, 0x71, 0x01, 0xFD, 0x0C, 0x74, 0x0E, 0xFC, 0x0B, 0x73, 0x0A, 0xFD,
  0x02, 0x72, 0x05, 0xFD, 0x05, 0x73, 0x03, 0xFD, 0x08, 0x72, 0x0B, 0xFC, 0x0D, 0x75, 0x0C, 0xFC,
  0x0E, 0x71, 0x02, 0xFD, 0x07, 0x75, 0x06, 0xFD, 0x05, 0x70, 0x8F, 0xD0, 0x17, 0x60, 0xEF, 0xC0,
  0xA7, 0x0D, 0xFC, 0x09, 0x77, 0x08, 0xFD, 0x01, 0x50, 0x4F, 0xD0, 0x27, 0x70, 0x2F, 0xD0, 0x75,
  0x0A, 0xFC, 0x0B, 0x77, 0x20, 0xAF, 0xC0, 0xD4, 0x01, 0xFD, 0x05, 0x77, 0x20, 0x4F, 0xD0, 0x33,
  0x06, 0xFC, 0x0D, 0x77, 0x40, 0xDF, 0xC0, 0x93, 0x0C, 0xFC, 0x07, 0x77, 0x40, 0x6F, 0xC0, 0xE2,
  0x02, 0xFD, 0x01, 0x77, 0x50, 0xEF, 0xC8, 0x15, 0x08, 0xFC, 0x09, 0x77, 0x60, 0x8F, 0xC8, 0x1B,
  0x0E, 0xFC, 0x02, 0x77, 0x60, 0x2F, 0xD0, 0x7F, 0xC0, 0xB7, 0x77, 0x10, 0xBF, 0xFF, 0xA0, 0x57,
  0x77, 0x10, 0x4F, 0xFF, 0x90, 0xD7, 0x77, 0x30, 0xDF, 0xFF, 0x07, 0x77, 0x73, 0x06, 0xFF, 0xE0,
  0xE0, 0x17, 0x77, 0x40, 0xEF, 0xFD, 0x09, 0x77, 0x75, 0x09, 0xFF, 0xD0, 0x27, 0x77, 0x50, 0x2F,
  0xFC, 0x0B, 0x77, 0x77, 0x0B, 0xFF, 0xB0, 0x47, 0x77, 0x70, 0x4F, 0xFA, 0x0D, 0x77, 0x77, 0x20,
  0xDF, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x7F, 0xF0, 0xE0, 0x17, 0x77, 0x72, 0x01, 0x0E, 0xFE, 0x09,
  0x77, 0x77, 0x40, 0x9F, 0xE0, 0x27, 0x77, 0x74, 0x02, 0xFD, 0x0C, 0x77, 0x77, 0x6F, 0xD0, 0xA7,
  0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F,
  0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77,
  0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD,
  0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77,
  0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0,
  0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77,
  0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x30,
  // "Z" (U+005A)
  0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06,
  0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80,
  0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0, 0xF8, 0x1E, 0x06, 0x80, 0xC0,
  0xF8, 0x1A, 0x06, 0x80, 0xC0, 0xF0, 0x27, 0x77, 0x30, 0x5F, 0xD0, 0x97, 0x77, 0x40, 0xDF, 0xC0,
  0xE0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x87, 0x77, 0x40, 0xEF, 0xC0, 0xE7, 0x77, 0x40, 0x7F, 0xD0,
  0x67, 0x77, 0x30, 0x10, 0xEF, 0xC0, 0xD7, 0x77, 0x40, 0x9F, 0xD0, 0x57, 0x77, 0x30, 0x2F, 0xD0,
  0xC7, 0x77, 0x40, 0xAF, 0xD0, 0x47, 0x77, 0x30, 0x3F, 0xD0, 0xB7, 0x77, 0x40, 0xBF, 0xD0, 0x37,
  0x77, 0x30, 0x4F, 0xD0, 0xA7, 0x77, 0x40, 0xCF, 0xD0, 0x27, 0x77, 0x30, 0x5F, 0xD0, 0x97, 0x77,
  0x40, 0xDF, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x6F, 0xD0, 0x77, 0x77, 0x40, 0xEF, 0xC0, 0xE7, 0x77,
  0x40, 0x8F, 0xD0, 0x67, 0x77, 0x30, 0x10, 0xEF, 0xC0, 0xD7, 0x77, 0x40, 0x9F, 0xD0, 0x57, 0x77,
  0x30, 0x2F, 0xD0, 0xC7, 0x77, 0x40, 0xAF, 0xD0, 0x47, 0x77, 0x30, 0x3F, 0xD0, 0xB7, 0x77, 0x40,
  0xBF, 0xD0, 0x27, 0x77, 0x30, 0x4F, 0xD0, 0xA7, 0x77, 0x40, 0xCF, 0xD0, 0x27, 0x77, 0x30, 0x5F,
  0xD0, 0x87, 0x77, 0x40, 0xDF, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x7F, 0xD0, 0x77, 0x77, 0x30, 0x10,
  0xEF, 0xC0, 0xE7, 0x77, 0x40, 0x8F, 0xD0, 0x67, 0x77, 0x30, 0x1F, 0xD0, 0xD7, 0x77, 0x40, 0x9F,
  0xD0, 0x57, 0x77, 0x30, 0x2F, 0xD0, 0xC7, 0x77, 0x40, 0xAF, 0xD0, 0x37, 0x77, 0x30, 0x3F, 0xD0,
  0xB7, 0x77, 0x40, 0xCF, 0xD0, 0x27, 0x77, 0x30, 0x5F, 0xD0, 0x97, 0x77, 0x40, 0xDF, 0xD0, 0x17,
  0x77, 0x30, 0x6F, 0xD0, 0x87, 0x77, 0x40, 0xDF, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x7F, 0xD0, 0x77,
  0x77, 0x30, 0x10, 0xE8, 0x0C, 0x0F, 0x09, 0x08, 0x80, 0xC1, 0xF0, 0x90, 0xE8, 0x0C, 0x1F, 0x09,
  0x0E, 0x80, 0xC1, 0xF0, 0x90, 0xE8, 0x0C, 0x1F, 0x09, 0x0E, 0x80, 0xC1, 0xF0, 0x90, 0xE8, 0x0C,
  0x1F, 0x09, 0x0E, 0x80, 0xC1, 0xF0, 0x90, 0xE8, 0x0C, 0x1F, 0x09, 0x0E, 0x80, 0xC1, 0xF0, 0x90,
  0xE8, 0x0C, 0x1F, 0x09,
  // "[" (U+005B)
  0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02, 0x0C, 0xFF,
  0xE0, 0x20, 0xCF, 0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30,
  0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xB0, 0x57, 0x30, 0xCF, 0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20, 0xCF,
  0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02, 0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02,
  0x0C, 0xFF, 0xE0, 0x20, 0xCF, 0xFE, 0x02,
  // "\" (U+005C)
  0x02, 0xFB, 0x0C, 0x77, 0x74, 0x0C, 0xFB, 0x02, 0x77, 0x73, 0x06, 0xFB, 0x08, 0x77, 0x73, 0x01,
  0xFB, 0x0E, 0x77, 0x74, 0x0A, 0xFB, 0x04, 0x77, 0x73, 0x04, 0xFB, 0x0A, 0x77, 0x74, 0x0D, 0xFB,
  0x01, 0x77, 0x73, 0x08, 0xFB, 0x07, 0x77, 0x73, 0x02, 0xFB, 0x0C, 0x77, 0x74, 0x0B, 0xFB, 0x03,
  0x77, 0x73, 0x05, 0xFB, 0x09, 0x77, 0x74, 0x0E, 0xFA, 0x0E, 0x77, 0x74, 0x09, 0xFB, 0x05, 0x77,
  0x73, 0x03, 0xFB, 0x0B, 0x77, 0x74, 0x0D, 0xFB, 0x01, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x73,
  0x01, 0xFB, 0x0D, 0x77, 0x74, 0x0B, 0xFB, 0x03, 0x77, 0x73, 0x05, 0xFB, 0x09, 0x77, 0x74, 0x0E,
  0xFA, 0x0E, 0x77, 0x74, 0x08, 0xFB, 0x06, 0x77, 0x73, 0x02, 0xFB, 0x0B, 0x77, 0x74, 0x0C, 0xFB,
  0x02, 0x77, 0x73, 0x06, 0xFB, 0x08, 0x77, 0x73, 0x01, 0xFB, 0x0D, 0x77, 0x74, 0x0A, 0xFB, 0x04,
  0x77, 0x73, 0x04, 0xFB, 0x0A, 0x77, 0x74, 0x0D, 0xFB, 0x01, 0x77, 0x73, 0x08, 0xFB, 0x06, 0x77,
  0x73, 0x02, 0xFB, 0x0C, 0x77, 0x74, 0x0B, 0xFB, 0x02, 0x77, 0x73, 0x05, 0xFB, 0x08, 0x77, 0x74,
  0x0E, 0xFA, 0x0E, 0x77, 0x74, 0x09, 0xFB, 0x05, 0x77, 0x73, 0x03, 0xFB, 0x0A, 0x77, 0x74, 0x0D,
  0xFB, 0x01, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x73, 0x01, 0xFB, 0x0D, 0x77, 0x74, 0x0A, 0xFB,
  0x03, 0x77, 0x73, 0x05, 0xFB, 0x09, 0x77, 0x74, 0x0E, 0xFA, 0x0E, 0x77, 0x74, 0x08, 0xFB, 0x05,
  0x77, 0x73, 0x02, 0xFB, 0x0B, 0x77, 0x74, 0x0C, 0xFB, 0x01, 0x77, 0x73, 0x06, 0xFB, 0x07, 0x77,
  0x73, 0x01, 0xFB, 0x0D, 0x77, 0x74, 0x0A, 0xFB, 0x04, 0x77, 0x73, 0x04, 0xFB, 0x09, 0x77, 0x74,
  0x0D, 0xFA, 0x0E, 0x77, 0x74, 0x07, 0xFB, 0x06, 0x77, 0x73, 0x02, 0xFB, 0x0C, 0x77, 0x74, 0x0B,
  0xFB, 0x02, 0x77, 0x73, 0x05, 0xFB, 0x08, 0x77, 0x74, 0x0E, 0xFA, 0x0E, 0x77, 0x74, 0x09, 0xFB,
  0x04, 0x77, 0x73, 0x03, 0xFB, 0x0A, 0x77, 0x74, 0x0D, 0xFB, 0x01, 0x77, 0x73, 0x07, 0xFB, 0x06,
  0x77, 0x73, 0x01, 0xFB, 0x0C, 0x77, 0x74, 0x0A, 0xFB, 0x03, 0x77, 0x73, 0x05, 0xFB, 0x08, 0x77,
  0x74, 0x0E, 0xFA, 0x0E, 0x77, 0x74, 0x08, 0xFB, 0x05, 0x77, 0x73, 0x02, 0xFB, 0x0B,
  // "]" (U+005D)
  0x0D, 0xFF, 0xD0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF,
  0xD0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE7,
  0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F,
  0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0,
  0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7,
  0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F,
  0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0,
  0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7,
  0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F,
  0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0,
  0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7,
  0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F,
  0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0,
  0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE7, 0x3F, 0xB0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0,
  0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE0, 0xDF, 0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE0, 0xDF,
  0xFD, 0x0E, 0x0D, 0xFF, 0xD0, 0xE0, 0xDF, 0xFD, 0x0E,
  // "^" (U+005E)
  0x77, 0x40, 0x3E, 0x08, 0x80, 0xC1, 0x00, 0xBE, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x77,
  0x77, 0x77, 0x0A, 0xF9, 0x0E, 0x77, 0x77, 0x60, 0x2F, 0xB0, 0x77, 0x77, 0x75, 0x09, 0xFB, 0x0E,
  0x77, 0x77, 0x40, 0x1F, 0xD0, 0x77, 0x77, 0x73, 0x08, 0xFD, 0x0E, 0x77, 0x77, 0x20, 0x10, 0xEF,
  0xE0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0x0E, 0x77, 0x77, 0x10, 0xEF, 0xF9, 0x06, 0x77, 0x76, 0x06,
  0xFF, 0xA0, 0xD7, 0x77, 0x60, 0xDF, 0xFB, 0x06, 0x77, 0x74, 0x05, 0xFF, 0xC0, 0xD7, 0x77, 0x40,
  0xCF, 0xFD, 0x06, 0x77, 0x72, 0x04, 0xFA, 0x0E, 0x09, 0xFA, 0x0D, 0x77, 0x72, 0x0C, 0xFA, 0x08,
  0x01, 0xFB, 0x05, 0x77, 0x70, 0x3F, 0xB8, 0x11, 0x09, 0xFA, 0x0D, 0x77, 0x70, 0xBF, 0xA0, 0xA2,
  0x02, 0xFB, 0x05, 0x77, 0x50, 0x2F, 0xB0, 0x33, 0x0A, 0xFA, 0x0D, 0x77, 0x50, 0xAF, 0xA0, 0xB4,
  0x02, 0xFB, 0x05, 0x77, 0x30, 0x2F, 0xB0, 0x45, 0x0A, 0xFA, 0x0C, 0x77, 0x30, 0x9F, 0xA0, 0xC6,
  0x03, 0xFB, 0x04, 0x77, 0x10, 0x1F, 0xB0, 0x57, 0x0B, 0xFA, 0x0C, 0x77, 0x10, 0x8F, 0xA0, 0xD7,
  0x10, 0x3F, 0xB0, 0x47, 0x60, 0x10, 0xEF, 0xA0, 0x77, 0x20, 0xBF, 0xA0, 0xC7, 0x60, 0x7F, 0xA0,
  0xE0, 0x17, 0x20, 0x4F, 0xB0, 0x47, 0x50, 0xEF, 0xA0, 0x87, 0x40, 0xCF, 0xA0, 0xB7, 0x40, 0x6F,
  0xB0, 0x17, 0x40, 0x5F, 0xB0, 0x47, 0x30, 0xDF, 0xA0, 0xA7, 0x60, 0xDF, 0xA0, 0xB7, 0x20, 0x5F,
  0xB0, 0x37, 0x60, 0x5F, 0xB0, 0x37, 0x10, 0xCF, 0xA0, 0xB7, 0x71, 0x0D, 0xFA, 0x0B, 0x70, 0x4F,
  0xB0, 0x47, 0x71, 0x06, 0xFB, 0x03, 0x60, 0xBF, 0xA0, 0xC7, 0x73, 0x0D, 0xFA, 0x0B, 0x50, 0x3F,
  0xB0, 0x57, 0x73, 0x07, 0xFB, 0x03, 0x40, 0xBF, 0xA0, 0xD7, 0x75, 0x0E, 0xFA, 0x0A, 0x30, 0x2F,
  0xB0, 0x77, 0x75, 0x07, 0xFB, 0x02, 0x20, 0xAF, 0xA0, 0xE0, 0x17, 0x75, 0x01, 0x0E, 0xFA, 0x81,
  0xA0, 0x2F, 0xB0, 0x87, 0x77, 0x08, 0xFB, 0x02, 0x09, 0xFB, 0x01, 0x77, 0x70, 0x10, 0xEF, 0xA0,
  0xA0,
  // "_" (U+005F)
  0x02, 0x80, 0xC5, 0xF0, 0x30, 0x28, 0x0C, 0x5F, 0x03, 0x02, 0x80, 0xC5, 0xF0, 0x30, 0x28, 0x0C,
  0x5F, 0x03, 0x02, 0x80, 0xC5, 0xF0, 0x30, 0x28, 0x0C, 0x5F, 0x03, 0x02, 0x80, 0xC5, 0xF0, 0x30,
  0x28, 0x0C, 0x5F, 0x03,
  // "`" (U+0060)
  0x03, 0x80, 0x91, 0x70, 0x47, 0x10, 0x4F, 0xE0, 0xE7, 0x20, 0x8F, 0xE0, 0x77, 0x20, 0x9F, 0xD0,
  0xE0, 0x17, 0x20, 0xAF, 0xD0, 0xA7, 0x30, 0xBF, 0xD0, 0x47, 0x30, 0xBF, 0xC0, 0xD7, 0x40, 0xBF,
  0xC0, 0x87, 0x40, 0xBF, 0xC0, 0x27, 0x40, 0xBF, 0xB0, 0xC7, 0x50, 0xAF, 0xB0, 0x77, 0x50, 0xAF,
  0xB0, 0x27, 0x50, 0x9F, 0xA0, 0xC7, 0x60, 0x7F, 0xA0, 0x77, 0x60, 0x5F, 0x90, 0xB0,
  // "a" (U+0061)
  0x76, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x83, 0xEC, 0xA7, 0x47, 0x75, 0x81, 0x27, 0xCF, 0xF9, 0x81,
  0xE9, 0x27, 0x70, 0x50, 0xBF, 0xFF, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0xFB, 0x0C, 0x01, 0x71, 0x0B,
  0xFF, 0xFE, 0x0D, 0x01, 0x70, 0x9F, 0xFF, 0xF0, 0xC7, 0x02, 0xFF, 0xFF, 0x90, 0x77, 0x0C, 0xFF,
  0xFF, 0x0E, 0x01, 0x60, 0x6F, 0xFF, 0xF9, 0x07, 0x70, 0xEF, 0xFF, 0xF0, 0xD7, 0x09, 0xF8, 0x6B,
  0x85, 0x42, 0x35, 0xAF, 0xF0, 0x26, 0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F, 0xE0, 0x67, 0x82, 0xCF,
  0x91, 0x75, 0x06, 0xFD, 0x09, 0x70, 0x30, 0x17, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x73, 0x08, 0xFC,
  0x0D, 0x77, 0x73, 0x04, 0xFD, 0x77, 0x73, 0x02, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01,
  0xFD, 0x77, 0x73, 0x01, 0xFD, 0x73, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xFE, 0x71, 0x06, 0x0B, 0xFF,
  0xFE, 0x60, 0x60, 0xEF, 0xFF, 0xF9, 0x40, 0x10, 0xCF, 0xFF, 0xFB, 0x30, 0x20, 0xDF, 0xFF, 0xFC,
  0x20, 0x10, 0xDF, 0xFF, 0xFD, 0x20, 0xAF, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xFF, 0x10, 0xBF, 0xF8,
  0x2A, 0x52, 0x14, 0x01, 0xFD, 0x02, 0xFE, 0x0B, 0x02, 0x71, 0x01, 0xFD, 0x06, 0xFD, 0x0B, 0x73,
  0x01, 0xFD, 0x0A, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x0E, 0xFC,
  0x07, 0x74, 0x03, 0xFF, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFB, 0x04, 0x74, 0x08, 0xFF, 0xFB, 0x06,
  0x74, 0x0E, 0xFD, 0x0E, 0xFC, 0x08, 0x73, 0x07, 0xFE, 0x0D, 0xFC, 0x0E, 0x72, 0x03, 0xFF, 0x0A,
  0xFD, 0x09, 0x70, 0x40, 0xEF, 0xF0, 0x7F, 0xE8, 0x5B, 0x41, 0x01, 0x5B, 0xFF, 0xA0, 0x38, 0x0C,
  0x0F, 0x10, 0xDF, 0xFF, 0xFF, 0x10, 0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB1, 0x01, 0x0E, 0xFF, 0xF8,
  0x1E, 0x17, 0xFB, 0x20, 0x7F, 0xFF, 0x81, 0x40, 0x2F, 0xB3, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA,
  0x30, 0x20, 0xEF, 0xFB, 0x06, 0x40, 0x8F, 0xA4, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA5,
  0x01, 0x09, 0xFD, 0x09, 0x01, 0x70, 0xEF, 0x97, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x17,
  0x74,
  // "b" (U+0062)
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05,
  0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC,
  0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x68, 0x91, 0x16,
  0xAD, 0xEF, 0xED, 0xA6, 0x17, 0x40, 0x5F, 0xC0, 0xB4, 0x01, 0x08, 0xFC, 0x09, 0x01, 0x72, 0x05,
  0xFC, 0x0B, 0x30, 0x30, 0xDF, 0xE0, 0xE0, 0x47, 0x10, 0x5F, 0xC0, 0xA2, 0x04, 0xFF, 0xB0, 0x67,
  0x05, 0xFC, 0x81, 0x90, 0x3F, 0xFD, 0x05, 0x60, 0x5F, 0xC8, 0x18, 0x1E, 0xFF, 0xE0, 0x25, 0x05,
  0xFC, 0x07, 0x0A, 0xFF, 0xF0, 0xC5, 0x05, 0xFC, 0x0E, 0xFF, 0xFA, 0x06, 0x40, 0x5F, 0xFF, 0xFF,
  0x0E, 0x40, 0x58, 0x0C, 0x0F, 0x06, 0x30, 0x5F, 0xFA, 0x85, 0xC6, 0x42, 0x48, 0xEF, 0xE0, 0xC3,
  0x05, 0xFF, 0x90, 0x56, 0x01, 0x0C, 0xFE, 0x02, 0x20, 0x5F, 0xF0, 0x57, 0x10, 0x10, 0xEF, 0xD0,
  0x72, 0x05, 0xFE, 0x0A, 0x73, 0x05, 0xFD, 0x0B, 0x20, 0x5F, 0xE0, 0x47, 0x40, 0xDF, 0xD2, 0x05,
  0xFD, 0x0D, 0x75, 0x08, 0xFD, 0x81, 0x30, 0x5F, 0xD0, 0x97, 0x50, 0x3F, 0xD8, 0x16, 0x05, 0xFD,
  0x06, 0x76, 0xFD, 0x81, 0x80, 0x5F, 0xD0, 0x37, 0x60, 0xCF, 0xC8, 0x1A, 0x05, 0xFD, 0x01, 0x76,
  0x0A, 0xFC, 0x81, 0xC0, 0x5F, 0xD7, 0x70, 0x8F, 0xC8, 0x1D, 0x05, 0xFC, 0x0E, 0x77, 0x07, 0xFD,
  0x10, 0x5F, 0xC0, 0xD7, 0x70, 0x6F, 0xD1, 0x05, 0xFC, 0x0C, 0x77, 0x05, 0xFD, 0x10, 0x5F, 0xC0,
  0xC7, 0x70, 0x5F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x70, 0x5F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x70,
  0x5F, 0xD0, 0x10, 0x5F, 0xC0, 0xD7, 0x70, 0x6F, 0xD1, 0x05, 0xFC, 0x0D, 0x77, 0x06, 0xFD, 0x10,
  0x5F, 0xC0, 0xE7, 0x70, 0x7F, 0xC8, 0x1E, 0x05, 0xFD, 0x77, 0x09, 0xFC, 0x81, 0xD0, 0x5F, 0xD0,
  0x27, 0x60, 0xBF, 0xC8, 0x1C, 0x05, 0xFD, 0x04, 0x76, 0x0D, 0xFC, 0x81, 0xA0, 0x5F, 0xD0, 0x77,
  0x50, 0x1F, 0xD8, 0x18, 0x05, 0xFD, 0x0A, 0x75, 0x04, 0xFD, 0x81, 0x50, 0x5F, 0xD0, 0xE7, 0x50,
  0x9F, 0xD8, 0x12, 0x05, 0xFE, 0x05, 0x74, 0x0E, 0xFC, 0x0E, 0x20, 0x5F, 0xE0, 0xC7, 0x30, 0x6F,
  0xD0, 0xB2, 0x05, 0xFF, 0x07, 0x71, 0x01, 0x0E, 0xFD, 0x06, 0x20, 0x5F, 0xF9, 0x07, 0x60, 0x10,
  0xCF, 0xE0, 0x12, 0x05, 0xFF, 0xA8, 0x5D, 0x74, 0x24, 0x8E, 0xFE, 0x0B, 0x30, 0x58, 0x0C, 0x0F,
  0x05, 0x30, 0x5F, 0xFF, 0xFF, 0x0D, 0x40, 0x5F, 0xFF, 0xFF, 0x05, 0x40, 0x5F, 0xC0, 0xCF, 0xFF,
  0x90, 0xB5, 0x05, 0xFB, 0x81, 0xE0, 0x8F, 0xFE, 0x0E, 0x01, 0x50, 0x5F, 0xB0, 0x82, 0x0A, 0xFF,
  0xD0, 0x46, 0x05, 0xFB, 0x03, 0x30, 0xBF, 0xFB, 0x05, 0x70, 0x5F, 0xA0, 0xD5, 0x09, 0xFF, 0x0D,
  0x03, 0x71, 0x05, 0xFA, 0x07, 0x60, 0x40, 0xCF, 0xB0, 0xE0, 0x87, 0x77, 0x71, 0x89, 0x03, 0x8B,
  0xDE, 0xFE, 0xC9, 0x57, 0x50,
  // "c" (U+0063)
  0x77, 0x89, 0x42, 0x69, 0xBD, 0xEF, 0xED, 0xCB, 0x95, 0x27, 0x73, 0x81, 0x17, 0xDF, 0xF8, 0x1D,
  0x83, 0x76, 0x07, 0x0E, 0xFF, 0xD0, 0xC0, 0x47, 0x20, 0x20, 0xCF, 0xFF, 0xA0, 0x97, 0x03, 0x0E,
  0xFF, 0xFB, 0x06, 0x60, 0x30, 0xEF, 0xFF, 0xC0, 0x15, 0x01, 0x0D, 0xFF, 0xFC, 0x0A, 0x60, 0xBF,
  0xFF, 0xD0, 0x55, 0x06, 0xFF, 0xFD, 0x0E, 0x60, 0xEF, 0xFF, 0xD0, 0x95, 0x07, 0xFF, 0x86, 0xC6,
  0x42, 0x45, 0x9E, 0xD0, 0x45, 0x0E, 0xFD, 0x0E, 0x04, 0x71, 0x05, 0x0B, 0xA0, 0xD5, 0x05, 0xFE,
  0x03, 0x74, 0x81, 0x3B, 0x85, 0x0A, 0xFD, 0x06, 0x77, 0x6F, 0xD0, 0xD7, 0x76, 0x04, 0xFD, 0x06,
  0x77, 0x60, 0x8F, 0xD0, 0x17, 0x76, 0x0B, 0xFC, 0x0C, 0x77, 0x70, 0xEF, 0xC0, 0x87, 0x76, 0x01,
  0xFD, 0x06, 0x77, 0x60, 0x3F, 0xD0, 0x47, 0x76, 0x04, 0xFD, 0x02, 0x77, 0x60, 0x5F, 0xD7, 0x77,
  0x06, 0xFD, 0x77, 0x70, 0x7F, 0xD7, 0x77, 0x07, 0xFC, 0x0E, 0x77, 0x70, 0x7F, 0xD7, 0x77, 0x06,
  0xFD, 0x77, 0x70, 0x6F, 0xD7, 0x77, 0x05, 0xFD, 0x01, 0x77, 0x60, 0x4F, 0xD0, 0x37, 0x76, 0x03,
  0xFD, 0x05, 0x77, 0x60, 0x1F, 0xD0, 0x77, 0x77, 0x0E, 0xFC, 0x0B, 0x77, 0x70, 0xBF, 0xD7, 0x77,
  0x08, 0xFD, 0x05, 0x77, 0x60, 0x5F, 0xD0, 0xC7, 0x76, 0x01, 0xFE, 0x06, 0x77, 0x10, 0x30, 0x73,
  0x0C, 0xFD, 0x0E, 0x02, 0x75, 0x82, 0x19, 0xF9, 0x30, 0x6F, 0xE0, 0xE0, 0x47, 0x20, 0x30, 0xAB,
  0x09, 0x30, 0x10, 0xEF, 0xF8, 0x7C, 0x64, 0x23, 0x56, 0xAE, 0xD0, 0x94, 0x09, 0xFF, 0xFF, 0x09,
  0x40, 0x10, 0xEF, 0xFF, 0xE0, 0x95, 0x07, 0xFF, 0xFE, 0x09, 0x60, 0xBF, 0xFF, 0xD0, 0x96, 0x01,
  0x0C, 0xFF, 0xFC, 0x09, 0x70, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x20, 0xAF, 0xFF, 0xA0, 0x67, 0x30,
  0x40, 0xDF, 0xFD, 0x0A, 0x01, 0x76, 0x05, 0x0B, 0xFF, 0x81, 0xE8, 0x27, 0x73, 0x84, 0x15, 0x8B,
  0xDE, 0xA8, 0x4E, 0xDC, 0x96, 0x37,
  // "d" (U+0064)
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77,
  0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76,
  0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03,
  0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC,
  0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E,
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xFE,
  0xC9, 0x46, 0x02, 0xFC, 0x0E, 0x72, 0x03, 0x0B, 0xFB, 0x0D, 0x06, 0x40, 0x1F, 0xC0, 0xE7, 0x10,
  0x8F, 0xF0, 0xB0, 0x13, 0xFC, 0x0E, 0x70, 0xBF, 0xFA, 0x0D, 0x02, 0x20, 0xEF, 0xB0, 0xE6, 0x0A,
  0xFF, 0xC8, 0x2E, 0x10, 0xDF, 0xB0, 0xE5, 0x07, 0xFF, 0xE8, 0x1C, 0x0C, 0xFB, 0x0E, 0x40, 0x3F,
  0xFF, 0x90, 0x80, 0xBF, 0xB0, 0xE4, 0x0C, 0xFF, 0xFF, 0xE0, 0xE3, 0x05, 0xFF, 0xFF, 0xF0, 0xE3,
  0x0C, 0xFF, 0xFF, 0xF0, 0xE2, 0x02, 0xFF, 0x85, 0xC6, 0x33, 0x58, 0xEF, 0xF9, 0x0E, 0x20, 0x8F,
  0xE0, 0x87, 0x0A, 0xFF, 0x0E, 0x20, 0xDF, 0xD0, 0x97, 0x20, 0x9F, 0xE8, 0x1E, 0x02, 0xFD, 0x0E,
  0x01, 0x73, 0x0D, 0xFD, 0x81, 0xE0, 0x5F, 0xD0, 0x77, 0x40, 0x7F, 0xD8, 0x1E, 0x09, 0xFD, 0x01,
  0x74, 0x01, 0xFD, 0x81, 0xE0, 0xCF, 0xC0, 0xC7, 0x60, 0xCF, 0xC8, 0x1E, 0x0E, 0xFC, 0x09, 0x76,
  0x08, 0xFC, 0x0E, 0x01, 0xFD, 0x05, 0x76, 0x05, 0xFC, 0x0E, 0x03, 0xFD, 0x03, 0x76, 0x04, 0xFC,
  0x0E, 0x04, 0xFD, 0x01, 0x76, 0x02, 0xFC, 0x0E, 0x05, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x6F, 0xC0,
  0xE7, 0x71, 0xFC, 0x0E, 0x06, 0xFC, 0x0D, 0x77, 0x1F, 0xC0, 0xE0, 0x7F, 0xC0, 0xD7, 0x71, 0x0E,
  0xFB, 0x0E, 0x07, 0xFC, 0x0D, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xC0, 0xD7, 0x71, 0x0E, 0xFB,
  0x0E, 0x06, 0xFC, 0x0E, 0x77, 0x1F, 0xC0, 0xE0, 0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x05, 0xFD,
  0x77, 0x01, 0xFC, 0x0E, 0x04, 0xFD, 0x01, 0x76, 0x02, 0xFC, 0x0E, 0x03, 0xFD, 0x03, 0x76, 0x04,
  0xFC, 0x0E, 0x01, 0xFD, 0x05, 0x76, 0x06, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0x97, 0x60, 0x9F, 0xC8,
  0x1E, 0x0C, 0xFC, 0x0C, 0x76, 0x0C, 0xFC, 0x81, 0xE0, 0x9F, 0xD0, 0x27, 0x40, 0x1F, 0xD8, 0x1E,
  0x06, 0xFD, 0x07, 0x74, 0x07, 0xFD, 0x81, 0xE0, 0x2F, 0xD0, 0xE0, 0x17, 0x30, 0xDF, 0xD0, 0xE2,
  0x0D, 0xFD, 0x09, 0x72, 0x09, 0xFE, 0x0E, 0x20, 0x8F, 0xE0, 0x87, 0x09, 0xFF, 0x0E, 0x20, 0x3F,
  0xF8, 0x5D, 0x63, 0x34, 0x8E, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0xFF, 0xF0, 0xE3, 0x05, 0xFF, 0xFF,
  0xF0, 0xE4, 0x0C, 0xFF, 0xFF, 0xE0, 0xE4, 0x03, 0xFF, 0xF9, 0x00, 0xBF, 0xB0, 0xE5, 0x07, 0xFF,
  0xE8, 0x1D, 0x13, 0xFB, 0x0E, 0x60, 0xAF, 0xFC, 0x0E, 0x03, 0x20, 0xDF, 0xA0, 0xE7, 0x0A, 0xFF,
  0xA0, 0xE0, 0x33, 0x08, 0xFA, 0x0E, 0x71, 0x08, 0xFF, 0x0D, 0x03, 0x40, 0x3F, 0xA0, 0xE7, 0x20,
  0x30, 0xBF, 0xC0, 0x80, 0x16, 0x0D, 0xF9, 0x0E, 0x74, 0x89, 0x12, 0x7B, 0xDE, 0xFE, 0xDA, 0x61,
  0x77, 0x40,
  // "e" (U+0065)
  0x77, 0x83, 0x48, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x77, 0x30, 0x30, 0xAF, 0xE8, 0x1E, 0x92,
  0x77, 0x50, 0x20, 0xAF, 0xFC, 0x09, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x0D, 0x03, 0x77, 0x07, 0xFF,
  0xFA, 0x0E, 0x04, 0x75, 0x07, 0xFF, 0xFD, 0x03, 0x73, 0x05, 0xFF, 0xFE, 0x0E, 0x01, 0x71, 0x01,
  0x0E, 0xFF, 0xFF, 0x0B, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0x56, 0x03, 0xFE, 0x85, 0x83, 0x10, 0x27,
  0xEF, 0xC0, 0xD6, 0x0B, 0xFC, 0x0D, 0x02, 0x60, 0x10, 0xCF, 0xC0, 0x54, 0x02, 0xFC, 0x0E, 0x02,
  0x71, 0x01, 0x0E, 0xFB, 0x0C, 0x40, 0x8F, 0xC0, 0x67, 0x30, 0x6F, 0xC0, 0x23, 0x0D, 0xFB, 0x0E,
  0x75, 0x0E, 0xFB, 0x07, 0x20, 0x2F, 0xC0, 0x87, 0x50, 0x9F, 0xB0, 0xB2, 0x06, 0xFC, 0x04, 0x75,
  0x04, 0xFB, 0x0E, 0x20, 0x9F, 0xC0, 0x17, 0x50, 0x2F, 0xC8, 0x11, 0x0C, 0xFB, 0x0E, 0x77, 0xFC,
  0x81, 0x40, 0xEF, 0xB0, 0xD7, 0x70, 0xEF, 0xB0, 0x50, 0x1F, 0xC0, 0xC7, 0x70, 0xDF, 0xB0, 0x70,
  0x38, 0x0C, 0x1F, 0x08, 0x04, 0x80, 0xC1, 0xF0, 0x80, 0x58, 0x0C, 0x1F, 0x08, 0x06, 0x80, 0xC1,
  0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x06,
  0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F, 0x09, 0x05, 0xFC, 0x0A, 0x77, 0x75, 0x03, 0xFC, 0x0B,
  0x77, 0x75, 0x02, 0xFC, 0x0D, 0x77, 0x76, 0xFD, 0x77, 0x76, 0x0D, 0xFC, 0x03, 0x77, 0x75, 0x09,
  0xFC, 0x07, 0x77, 0x75, 0x06, 0xFC, 0x0D, 0x77, 0x75, 0x02, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFC,
  0x0E, 0x01, 0x77, 0x50, 0x30, 0x14, 0x07, 0xFD, 0x0D, 0x01, 0x77, 0x28, 0x24, 0xBF, 0x24, 0x01,
  0xFE, 0x0E, 0x06, 0x75, 0x81, 0x27, 0xDB, 0x02, 0x50, 0xAF, 0xF8, 0x92, 0xD9, 0x54, 0x23, 0x34,
  0x58, 0xBE, 0xE0, 0x25, 0x02, 0xFF, 0xFF, 0xC0, 0x26, 0x08, 0xFF, 0xFF, 0xB0, 0x27, 0x0D, 0xFF,
  0xFF, 0xA0, 0x27, 0x02, 0x0E, 0xFF, 0xFF, 0x90, 0x27, 0x10, 0x4F, 0xFF, 0xF9, 0x02, 0x72, 0x04,
  0x0E, 0xFF, 0xFE, 0x02, 0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x06, 0x0E, 0xFF, 0xF0,
  0xC0, 0x57, 0x72, 0x06, 0x0B, 0xFF, 0xA8, 0x1D, 0x83, 0x77, 0x68, 0x96, 0x15, 0x8B, 0xDE, 0xEF,
  0xEE, 0xDC, 0xA7, 0x52, 0x72,
  // "f" (U+0066)
  0x77, 0x89, 0x31, 0x59, 0xCD, 0xEF, 0xEE, 0xCA, 0x84, 0x77, 0x20, 0x20, 0xAF, 0xF0, 0xB0, 0x57,
  0x50, 0x9F, 0xFC, 0x09, 0x73, 0x0B, 0xFF, 0xD0, 0x57, 0x20, 0xAF, 0xFE, 0x72, 0x05, 0xFF, 0xE0,
  0xB7, 0x20, 0xDF, 0xFE, 0x06, 0x71, 0x05, 0xFF, 0xF0, 0x17, 0x10, 0xAF, 0xFE, 0x0C, 0x72, 0xFF,
  0xF0, 0x77, 0x10, 0x3F, 0xE8, 0x7A, 0x42, 0x35, 0x8C, 0xF3, 0x71, 0x06, 0xFD, 0x08, 0x70, 0x17,
  0x20, 0x8F, 0xC0, 0xE7, 0x74, 0x09, 0xFC, 0x0B, 0x77, 0x40, 0xBF, 0xC0, 0x87, 0x74, 0x0B, 0xFC,
  0x07, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x72,
  0x01, 0x08, 0xFF, 0xF0, 0x66, 0x05, 0x0E, 0xFF, 0xF9, 0x06, 0x40, 0x30, 0xCF, 0xFF, 0xB0, 0x63,
  0x08, 0xFF, 0xFD, 0x06, 0x30, 0xEF, 0xFF, 0xD0, 0x63, 0x0E, 0xFF, 0xFD, 0x06, 0x30, 0xEF, 0xFF,
  0xD0, 0x63, 0x0E, 0xFF, 0xFD, 0x06, 0x30, 0xEF, 0xFF, 0xD0, 0x63, 0x0E, 0xFF, 0xFD, 0x06, 0x38,
  0x02, 0x20, 0xCF, 0xC0, 0x88, 0x04, 0x20, 0x17, 0x20, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06,
  0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C,
  0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67,
  0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF,
  0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77,
  0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC,
  0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74,
  0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0,
  0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40,
  0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06,
  0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C, 0xFC, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0x67, 0x74, 0x0C,
  0xFC, 0x06, 0x75,
  // "g" (U+0067)
  0x74, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDA, 0x61, 0x77, 0x76, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x50,
  0x9F, 0xA0, 0xE7, 0x10, 0x7F, 0xF0, 0xD0, 0x34, 0x0B, 0xFA, 0x0E, 0x70, 0xAF, 0xFA, 0x0E, 0x04,
  0x30, 0xEF, 0xA0, 0xE6, 0x09, 0xFF, 0xC8, 0x2E, 0x20, 0x1F, 0xB0, 0xE5, 0x06, 0xFF, 0xE8, 0x1D,
  0x03, 0xFB, 0x0E, 0x40, 0x2F, 0xFF, 0x90, 0x70, 0x6F, 0xB0, 0xE4, 0x0B, 0xFF, 0xFF, 0xE0, 0xE3,
  0x04, 0xFF, 0xFF, 0xF0, 0xE3, 0x0B, 0xFF, 0xFF, 0xF0, 0xE2, 0x02, 0xFF, 0x85, 0xD6, 0x33, 0x59,
  0xEF, 0xF9, 0x0E, 0x20, 0x7F, 0xE0, 0x86, 0x01, 0x0B, 0xFF, 0x0E, 0x20, 0xCF, 0xD0, 0xA7, 0x20,
  0xBF, 0xE8, 0x1E, 0x01, 0xFD, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xFD, 0x81, 0xE0, 0x5F, 0xD0, 0x87,
  0x40, 0x7F, 0xD8, 0x1E, 0x08, 0xFD, 0x03, 0x74, 0x01, 0xFD, 0x81, 0xE0, 0xBF, 0xC0, 0xD7, 0x60,
  0xCF, 0xC8, 0x1E, 0x0E, 0xFC, 0x0A, 0x76, 0x09, 0xFC, 0x0E, 0x1F, 0xD0, 0x77, 0x60, 0x6F, 0xC0,
  0xE0, 0x2F, 0xD0, 0x57, 0x60, 0x4F, 0xC0, 0xE0, 0x4F, 0xD0, 0x37, 0x60, 0x2F, 0xC0, 0xE0, 0x5F,
  0xD0, 0x17, 0x60, 0x1F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0,
  0xE0, 0x7F, 0xD7, 0x71, 0xFC, 0x0E, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xC0,
  0xE7, 0x71, 0x0E, 0xFB, 0x0E, 0x06, 0xFD, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC,
  0x0E, 0x05, 0xFD, 0x01, 0x77, 0xFC, 0x0E, 0x04, 0xFD, 0x02, 0x76, 0x01, 0xFC, 0x0E, 0x03, 0xFD,
  0x04, 0x76, 0x02, 0xFC, 0x0E, 0x01, 0xFD, 0x06, 0x76, 0x04, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0x97,
  0x60, 0x7F, 0xC8, 0x1E, 0x0C, 0xFC, 0x0D, 0x76, 0x0A, 0xFC, 0x81, 0xE0, 0x9F, 0xD0, 0x27, 0x50,
  0xEF, 0xC8, 0x1E, 0x06, 0xFD, 0x08, 0x74, 0x05, 0xFD, 0x81, 0xE0, 0x2F, 0xD0, 0xE0, 0x17, 0x30,
  0xCF, 0xD0, 0xE2, 0x0E, 0xFD, 0x0A, 0x72, 0x08, 0xFE, 0x0E, 0x20, 0x9F, 0xE0, 0x97, 0x08, 0xFF,
  0x0E, 0x20, 0x3F, 0xF8, 0x5D, 0x63, 0x24, 0x7D, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0xFF, 0xF0, 0xE3,
  0x05, 0xFF, 0xFF, 0xF0, 0xE4, 0x0D, 0xFF, 0xF9, 0x0E, 0xFC, 0x0E, 0x40, 0x4F, 0xFF, 0x90, 0x40,
  0xEF, 0xB0, 0xE5, 0x09, 0xFF, 0xE0, 0xA1, 0xFC, 0x0E, 0x60, 0xBF, 0xFC, 0x81, 0xC0, 0x1F, 0xC0,
  0xE6, 0x01, 0x0C, 0xFF, 0xA8, 0x2D, 0x10, 0x2F, 0xC0, 0xE7, 0x10, 0xAF, 0xF0, 0xB0, 0x12, 0x02,
  0xFC, 0x0E, 0x72, 0x04, 0x0C, 0xFB, 0x0D, 0x06, 0x40, 0x3F, 0xC0, 0xE7, 0x48, 0x23, 0x8B, 0xEA,
  0x82, 0xEC, 0x94, 0x60, 0x3F, 0xC0, 0xD7, 0x77, 0x60, 0x3F, 0xC0, 0xC7, 0x77, 0x60, 0x4F, 0xC0,
  0xB7, 0x77, 0x60, 0x5F, 0xC0, 0x97, 0x77, 0x60, 0x7F, 0xC0, 0x77, 0x77, 0x60, 0xAF, 0xC0, 0x57,
  0x77, 0x60, 0xEF, 0xC0, 0x27, 0x77, 0x50, 0x6F, 0xC0, 0xD4, 0x09, 0x02, 0x77, 0x60, 0x10, 0xEF,
  0xC0, 0x93, 0x01, 0xA0, 0xB0, 0x47, 0x73, 0x01, 0x0C, 0xFD, 0x04, 0x30, 0x1C, 0x82, 0xEA, 0x51,
  0x75, 0x06, 0x0E, 0xFD, 0x0D, 0x40, 0x1F, 0x98, 0x92, 0xDA, 0x75, 0x43, 0x23, 0x46, 0x9E, 0xFF,
  0x07, 0x40, 0x1F, 0xFF, 0xFD, 0x0E, 0x50, 0x1F, 0xFF, 0xFD, 0x05, 0x50, 0x1F, 0xFF, 0xFC, 0x0B,
  0x60, 0x1F, 0xFF, 0xFB, 0x0D, 0x01, 0x60, 0x1F, 0xFF, 0xFA, 0x0D, 0x02, 0x70, 0x1F, 0xFF, 0xF9,
  0x0C, 0x02, 0x72, 0x0E, 0xFF, 0xFE, 0x09, 0x75, 0x06, 0x0C, 0xFF, 0xFA, 0x0B, 0x03, 0x77, 0x18,
  0x13, 0x7C, 0xFF, 0xB8, 0x1D, 0x82, 0x77, 0x68, 0x61, 0x46, 0x9B, 0xCD, 0xEA, 0x85, 0xEE, 0xCA,
  0x85, 0x27, 0x70,
  // "h" (U+0068)
  0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05,
  0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC,
  0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C,
  0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77,
  0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75, 0x05, 0xFC, 0x0C, 0x77, 0x75,
  0x05, 0xFC, 0x0B, 0x77, 0x75, 0x05, 0xFC, 0x0B, 0x77, 0x75, 0x05, 0xFC, 0x0A, 0x68, 0x91, 0x27,
  0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xC0, 0x94, 0x03, 0x0B, 0xFC, 0x0D, 0x06, 0x70, 0x5F,
  0xC0, 0x93, 0x09, 0xFF, 0x90, 0xC0, 0x15, 0x05, 0xFC, 0x07, 0x20, 0xBF, 0xFB, 0x0E, 0x03, 0x40,
  0x5F, 0xC8, 0x16, 0x0A, 0xFF, 0xD0, 0xE0, 0x23, 0x05, 0xFC, 0x03, 0x07, 0xFF, 0xF0, 0xC3, 0x05,
  0xFC, 0x03, 0x0E, 0xFF, 0xF9, 0x06, 0x20, 0x5F, 0xFF, 0xFF, 0x0E, 0x20, 0x58, 0x0C, 0x0F, 0x81,
  0x50, 0x58, 0x0C, 0x0F, 0x81, 0xB0, 0x5F, 0xFA, 0x85, 0xE8, 0x53, 0x36, 0xCF, 0xF1, 0x05, 0xFF,
  0x90, 0x87, 0x0A, 0xFE, 0x03, 0x05, 0xFF, 0x08, 0x72, 0x0D, 0xFD, 0x06, 0x05, 0xFE, 0x0D, 0x73,
  0x07, 0xFD, 0x08, 0x05, 0xFE, 0x06, 0x73, 0x01, 0xFD, 0x0A, 0x05, 0xFE, 0x75, 0x0D, 0xFC, 0x0B,
  0x05, 0xFD, 0x0B, 0x75, 0x0A, 0xFC, 0x0C, 0x05, 0xFD, 0x08, 0x75, 0x09, 0xFC, 0x0C, 0x05, 0xFD,
  0x05, 0x75, 0x07, 0xFC, 0x0C, 0x05, 0xFD, 0x03, 0x75, 0x07, 0xFC, 0x0C, 0x05, 0xFD, 0x01, 0x75,
  0x06, 0xFC, 0x0C, 0x05, 0xFD, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0E, 0x76, 0x06, 0xFC, 0x0C,
  0x05, 0xFC, 0x0D, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76,
  0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06,
  0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C,
  0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76,
  0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C,
  // "i" (U+0069)
  0x38, 0x66, 0xBE, 0xFE, 0xD9, 0x34, 0x02, 0x0D, 0xF9, 0x08, 0x30, 0xDF, 0xB8, 0x16, 0x05, 0xFC,
  0x81, 0xE0, 0xAF, 0xD0, 0x30, 0xCF, 0xD0, 0x50, 0xDF, 0xD0, 0x60, 0xCF, 0xD0, 0x50, 0xAF, 0xD0,
  0x30, 0x5F, 0xC0, 0xE2, 0x0C, 0xFB, 0x06, 0x20, 0x10, 0xCF, 0x90, 0x85, 0x86, 0x5B, 0xEF, 0xED,
  0x93, 0x80, 0x9A, 0x30, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F,
  0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E,
  0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC,
  0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0,
  0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8,
  0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05,
  0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81,
  0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F,
  0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E,
  0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC,
  0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x10,
  // "j" (U+006A)
  0x75, 0x86, 0x6B, 0xEF, 0xED, 0x93, 0x76, 0x02, 0x0D, 0xF9, 0x08, 0x75, 0x0D, 0xFB, 0x06, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x0A, 0xFD, 0x03, 0x72, 0x0C, 0xFD, 0x05, 0x72, 0x0D, 0xFD, 0x06, 0x72,
  0x0C, 0xFD, 0x05, 0x72, 0x0A, 0xFD, 0x03, 0x72, 0x05, 0xFC, 0x0E, 0x74, 0x0C, 0xFB, 0x06, 0x74,
  0x01, 0x0C, 0xF9, 0x08, 0x77, 0x86, 0x5B, 0xEF, 0xED, 0x93, 0x80, 0xAA, 0x20, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E,
  0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x06, 0xFC, 0x0D, 0x73, 0x08, 0xFC, 0x0C,
  0x73, 0x0B, 0xFC, 0x0B, 0x72, 0x02, 0xFD, 0x0A, 0x72, 0x0C, 0xFD, 0x89, 0x07, 0x07, 0xA6, 0x43,
  0x36, 0xDF, 0xE8, 0x14, 0x08, 0xFF, 0xE8, 0x11, 0x08, 0xFF, 0xD0, 0xB2, 0x08, 0xFF, 0xD0, 0x42,
  0x08, 0xFF, 0xC0, 0xD3, 0x08, 0xFF, 0xC0, 0x33, 0x08, 0xFF, 0xB0, 0x84, 0x08, 0xFF, 0xA0, 0xA5,
  0x08, 0xFF, 0x90, 0x86, 0x08, 0xFE, 0x0A, 0x02, 0x78, 0x51, 0x47, 0xAC, 0xDE, 0xA8, 0x3E, 0xC9,
  0x61, 0x72,
  // "k" (U+006B)
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77,
  0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7,
  0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0,
  0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x70, 0xCF, 0xD8, 0x18,
  0x05, 0xFC, 0x0C, 0x76, 0x08, 0xFD, 0x0C, 0x20, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD0, 0xE0, 0x22,
  0x05, 0xFC, 0x0C, 0x75, 0x0D, 0xFD, 0x06, 0x30, 0x5F, 0xC0, 0xC7, 0x40, 0x9F, 0xD0, 0xA4, 0x05,
  0xFC, 0x0C, 0x73, 0x04, 0xFD, 0x0D, 0x01, 0x40, 0x5F, 0xC0, 0xC7, 0x30, 0xDF, 0xD0, 0x45, 0x05,
  0xFC, 0x0C, 0x72, 0x09, 0xFD, 0x08, 0x60, 0x5F, 0xC0, 0xC7, 0x10, 0x4F, 0xD0, 0xC7, 0x05, 0xFC,
  0x0C, 0x70, 0x10, 0xEF, 0xC0, 0xE0, 0x27, 0x05, 0xFC, 0x0C, 0x70, 0xAF, 0xD0, 0x67, 0x10, 0x5F,
  0xC0, 0xC6, 0x05, 0xFD, 0x0A, 0x72, 0x05, 0xFC, 0x0C, 0x50, 0x10, 0xEF, 0xC0, 0xD0, 0x17, 0x20,
  0x5F, 0xC0, 0xB5, 0x0B, 0xFD, 0x04, 0x73, 0x05, 0xFC, 0x0B, 0x40, 0x6F, 0xD0, 0x87, 0x40, 0x5F,
  0xC0, 0xB3, 0x02, 0x0E, 0xFC, 0x0C, 0x75, 0x05, 0xFC, 0x0A, 0x30, 0xBF, 0xC0, 0xE0, 0x27, 0x50,
  0x5F, 0xC0, 0xA2, 0x05, 0xFD, 0x06, 0x76, 0x05, 0xFC, 0x82, 0x80, 0x1E, 0xFC, 0x0A, 0x77, 0x05,
  0xFC, 0x81, 0x70, 0x8F, 0xC0, 0xE0, 0x17, 0x70, 0x5F, 0xC0, 0x60, 0x2F, 0xD0, 0x47, 0x71, 0x05,
  0xFC, 0x05, 0x0A, 0xFD, 0x06, 0x77, 0x10, 0x5F, 0xC0, 0x9F, 0xE0, 0xE7, 0x71, 0x05, 0xFF, 0xFD,
  0x08, 0x77, 0x05, 0xFF, 0xFE, 0x01, 0x76, 0x05, 0xFF, 0xFE, 0x09, 0x76, 0x05, 0xFF, 0xFF, 0x03,
  0x75, 0x05, 0xFF, 0xFF, 0x0B, 0x75, 0x05, 0xFF, 0xFF, 0x90, 0x47, 0x40, 0x5F, 0xFA, 0x08, 0xFD,
  0x0C, 0x74, 0x05, 0xFF, 0x98, 0x15, 0x08, 0xFD, 0x06, 0x73, 0x05, 0xFE, 0x0E, 0x03, 0x20, 0x10,
  0xEF, 0xC0, 0xE7, 0x30, 0x5F, 0xD0, 0xD0, 0x24, 0x07, 0xFD, 0x07, 0x72, 0x05, 0xFC, 0x0E, 0x01,
  0x60, 0xEF, 0xC0, 0xE0, 0x17, 0x10, 0x5F, 0xC0, 0xC7, 0x07, 0xFD, 0x09, 0x71, 0x05, 0xFC, 0x0C,
  0x71, 0x0D, 0xFD, 0x02, 0x70, 0x5F, 0xC0, 0xC7, 0x10, 0x6F, 0xD0, 0xB7, 0x05, 0xFC, 0x0C, 0x72,
  0x0D, 0xFD, 0x04, 0x60, 0x5F, 0xC0, 0xC7, 0x20, 0x5F, 0xD0, 0xC6, 0x05, 0xFC, 0x0C, 0x73, 0x0C,
  0xFD, 0x05, 0x50, 0x5F, 0xC0, 0xC7, 0x30, 0x5F, 0xD0, 0xD5, 0x05, 0xFC, 0x0C, 0x74, 0x0C, 0xFD,
  0x07, 0x40, 0x5F, 0xC0, 0xC7, 0x40, 0x4F, 0xD0, 0xE0, 0x13, 0x05, 0xFC, 0x0C, 0x75, 0x0B, 0xFD,
  0x09, 0x30, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xE0, 0x22, 0x05, 0xFC, 0x0C, 0x76, 0x0B, 0xFD, 0x0A,
  0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x2F, 0xE8, 0x13, 0x05, 0xFC, 0x0C, 0x77, 0x0A, 0xFD, 0x81, 0xC0,
  0x5F, 0xC0, 0xC7, 0x70, 0x2F, 0xE0, 0x50,
  // "l" (U+006C)
  0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05,
  0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC,
  0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C, 0x05, 0xFC, 0x0C,
  // "m" (U+006D)
  0x77, 0x58, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x47, 0x78, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB7,
  0x37, 0x20, 0x5F, 0xA0, 0x56, 0x05, 0x0C, 0xFC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xFC, 0x0C, 0x05,
  0x70, 0x5F, 0xA0, 0x84, 0x02, 0x0B, 0xFF, 0x90, 0xB0, 0x16, 0x02, 0x0C, 0xFF, 0x90, 0xA6, 0x05,
  0xFA, 0x0C, 0x30, 0x20, 0xEF, 0xFB, 0x0D, 0x01, 0x40, 0x30, 0xEF, 0xFB, 0x0C, 0x50, 0x5F, 0xB2,
  0x01, 0x0E, 0xFF, 0xD0, 0xC3, 0x01, 0x0E, 0xFF, 0xD0, 0xB4, 0x05, 0xFB, 0x81, 0x40, 0xBF, 0xFF,
  0x08, 0x20, 0xCF, 0xFF, 0x06, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x20, 0x6F, 0xFF, 0x90,
  0xE0, 0x12, 0x05, 0x80, 0xF0, 0xF0, 0x62, 0x05, 0x80, 0xF0, 0xF0, 0xC2, 0x05, 0x80, 0xF1, 0xF8,
  0x12, 0x05, 0xFF, 0xA8, 0x4B, 0x63, 0x35, 0xBF, 0xFD, 0x84, 0xC6, 0x43, 0x5B, 0xFF, 0x81, 0x60,
  0x5F, 0xF9, 0x05, 0x60, 0x8F, 0xFB, 0x06, 0x60, 0x7F, 0xE8, 0x19, 0x05, 0xFF, 0x05, 0x71, 0x0C,
  0xFF, 0x90, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x05, 0xFE, 0x0B, 0x72, 0x05, 0xFF, 0x0D, 0x72, 0x02,
  0xFD, 0x81, 0xD0, 0x5F, 0xE0, 0x57, 0x30, 0xEF, 0xE0, 0x67, 0x30, 0xCF, 0xD1, 0x05, 0xFE, 0x74,
  0x0B, 0xFE, 0x01, 0x73, 0x08, 0xFD, 0x10, 0x5F, 0xD0, 0xB7, 0x40, 0x8F, 0xD0, 0xC7, 0x40, 0x5F,
  0xD0, 0x10, 0x5F, 0xD0, 0x87, 0x40, 0x6F, 0xD0, 0x97, 0x40, 0x3F, 0xD0, 0x10, 0x5F, 0xD0, 0x57,
  0x40, 0x4F, 0xD0, 0x67, 0x40, 0x1F, 0xD0, 0x10, 0x5F, 0xD0, 0x37, 0x40, 0x4F, 0xD0, 0x57, 0x40,
  0x1F, 0xD0, 0x10, 0x5F, 0xD0, 0x17, 0x40, 0x3F, 0xD0, 0x37, 0x5F, 0xD0, 0x10, 0x5F, 0xD7, 0x50,
  0x3F, 0xD0, 0x17, 0x5F, 0xD0, 0x10, 0x5F, 0xC0, 0xE7, 0x50, 0x3F, 0xD0, 0x17, 0x5F, 0xD0, 0x10,
  0x5F, 0xC0, 0xD7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xD7, 0x50, 0x3F, 0xD7, 0x6F,
  0xD0, 0x10, 0x5F, 0xC0, 0xD7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F,
  0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7,
  0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F,
  0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0,
  0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7,
  0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50,
  0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0,
  0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10,
  0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F,
  0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F,
  0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7,
  0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F,
  0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0,
  0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7, 0x6F, 0xD0, 0x10, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD7,
  0x6F, 0xD0, 0x10,
  // "n" (U+006E)
  0x77, 0x58, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56, 0x04, 0x0C, 0xFC,
  0x0D, 0x05, 0x70, 0x5F, 0xA0, 0x84, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x15, 0x05, 0xFA, 0x0C, 0x30,
  0x20, 0xDF, 0xFB, 0x0D, 0x02, 0x40, 0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0, 0x13, 0x05, 0xFB,
  0x81, 0x40, 0xAF, 0xFF, 0x0B, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62, 0x05, 0xFF, 0xFF,
  0xF0, 0xD2, 0x05, 0x80, 0xC0, 0xF8, 0x15, 0x05, 0x80, 0xC0, 0xF8, 0x1A, 0x05, 0xFF, 0xA8, 0x5D,
  0x74, 0x33, 0x6D, 0xFF, 0x10, 0x5F, 0xF9, 0x07, 0x70, 0xAF, 0xE0, 0x30, 0x5F, 0xF0, 0x67, 0x10,
  0x10, 0xDF, 0xD0, 0x60, 0x5F, 0xE0, 0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0, 0x47, 0x30, 0x2F,
  0xD0, 0xA0, 0x5F, 0xD0, 0xE7, 0x50, 0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50, 0xAF, 0xC0, 0xC0,
  0x5F, 0xD0, 0x77, 0x50, 0x9F, 0xC0, 0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0,
  0x27, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  // "o" (U+006F)
  0x77, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x77, 0x74, 0x81, 0x16, 0xCF, 0xE8, 0x1E,
  0x82, 0x77, 0x70, 0x60, 0xEF, 0xFC, 0x09, 0x01, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x0D, 0x04, 0x77,
  0x10, 0x30, 0xEF, 0xFF, 0xB0, 0x67, 0x60, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x40, 0x20, 0xEF, 0xFF,
  0xF0, 0x67, 0x30, 0xCF, 0xFF, 0xFA, 0x03, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x01, 0xFF, 0xFF,
  0xD0, 0x76, 0x08, 0xFE, 0x85, 0xE8, 0x43, 0x36, 0xBF, 0xE0, 0xE0, 0x14, 0x01, 0x0E, 0xFD, 0x0B,
  0x70, 0x40, 0xEF, 0xD0, 0x74, 0x06, 0xFD, 0x0B, 0x72, 0x03, 0xFD, 0x0E, 0x40, 0xBF, 0xC0, 0xE0,
  0x27, 0x30, 0x8F, 0xD0, 0x42, 0x01, 0xFD, 0x09, 0x74, 0x01, 0xFD, 0x09, 0x20, 0x5F, 0xD0, 0x37,
  0x50, 0xBF, 0xC0, 0xD2, 0x08, 0xFC, 0x0D, 0x76, 0x06, 0xFD, 0x81, 0x10, 0xCF, 0xC0, 0xA7, 0x60,
  0x3F, 0xD8, 0x14, 0x0E, 0xFC, 0x07, 0x77, 0xFD, 0x07, 0x01, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x0A,
  0x03, 0xFD, 0x03, 0x77, 0x0B, 0xFC, 0x0B, 0x05, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0D, 0x05, 0xFD,
  0x77, 0x10, 0x9F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0x08, 0xFC, 0x0E, 0x07, 0xFD, 0x77, 0x10, 0x8F,
  0xD0, 0x7F, 0xC0, 0xE7, 0x71, 0x07, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xD0, 0x6F, 0xD7, 0x71,
  0x08, 0xFC, 0x0E, 0x05, 0xFD, 0x77, 0x10, 0x9F, 0xC0, 0xD0, 0x4F, 0xD0, 0x17, 0x70, 0xAF, 0xC0,
  0xC0, 0x2F, 0xD0, 0x37, 0x70, 0xCF, 0xC0, 0xA1, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x81, 0x80, 0xDF,
  0xC0, 0x77, 0x7F, 0xD8, 0x16, 0x09, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x30, 0x6F, 0xC0, 0xE7,
  0x60, 0x7F, 0xC0, 0xE2, 0x02, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0B, 0x30, 0xDF, 0xC0, 0x97, 0x40,
  0x1F, 0xD0, 0x63, 0x08, 0xFC, 0x0E, 0x02, 0x73, 0x09, 0xFD, 0x01, 0x30, 0x2F, 0xD0, 0xB7, 0x20,
  0x4F, 0xD0, 0xB5, 0x0B, 0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x55, 0x03, 0xFE, 0x85, 0xE8, 0x43,
  0x35, 0xBF, 0xE0, 0xD7, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x02, 0x0E, 0xFF, 0xFF, 0xA0, 0xB7, 0x20,
  0x6F, 0xFF, 0xF9, 0x0E, 0x02, 0x73, 0x09, 0xFF, 0xFF, 0x04, 0x75, 0x0B, 0xFF, 0xFD, 0x06, 0x77,
  0x0A, 0xFF, 0xFB, 0x06, 0x77, 0x20, 0x8F, 0xFF, 0x0E, 0x04, 0x77, 0x40, 0x30, 0xCF, 0xFC, 0x09,
  0x01, 0x77, 0x70, 0x40, 0xBF, 0xE8, 0x1E, 0x82, 0x77, 0x74, 0x89, 0x31, 0x59, 0xCD, 0xEF, 0xED,
  0xCA, 0x73, 0x77,
  // "p" (U+0070)
  0x77, 0x58, 0x91, 0x16, 0xAD, 0xEF, 0xED, 0xA6, 0x17, 0x40, 0x5F, 0xA0, 0x96, 0x01, 0x09, 0xFC,
  0x09, 0x01, 0x72, 0x05, 0xFA, 0x0D, 0x50, 0x30, 0xEF, 0xE0, 0xE0, 0x47, 0x10, 0x5F, 0xB0, 0x23,
  0x04, 0xFF, 0xB0, 0x67, 0x05, 0xFB, 0x07, 0x20, 0x20, 0xEF, 0xFC, 0x05, 0x60, 0x5F, 0xB0, 0xB2,
  0x0D, 0xFF, 0xE0, 0x35, 0x05, 0xFC, 0x10, 0x8F, 0xFF, 0x0D, 0x50, 0x5F, 0xC0, 0xAF, 0xFF, 0xA0,
  0x64, 0x05, 0xFF, 0xFF, 0xF0, 0xE4, 0x05, 0x80, 0xC0, 0xF0, 0x63, 0x05, 0xFF, 0xA8, 0x5C, 0x64,
  0x24, 0x8E, 0xFE, 0x0C, 0x30, 0x5F, 0xF9, 0x06, 0x60, 0x10, 0xDF, 0xE0, 0x22, 0x05, 0xFF, 0x06,
  0x71, 0x01, 0x0E, 0xFD, 0x07, 0x20, 0x5F, 0xE0, 0xB7, 0x30, 0x6F, 0xD0, 0xB2, 0x05, 0xFE, 0x04,
  0x74, 0x0E, 0xFD, 0x20, 0x5F, 0xD0, 0xD7, 0x50, 0x9F, 0xD8, 0x13, 0x05, 0xFD, 0x0A, 0x75, 0x04,
  0xFD, 0x81, 0x60, 0x5F, 0xD0, 0x67, 0x50, 0x1F, 0xD8, 0x18, 0x05, 0xFD, 0x03, 0x76, 0x0D, 0xFC,
  0x81, 0xA0, 0x5F, 0xD0, 0x17, 0x60, 0xBF, 0xC8, 0x1C, 0x05, 0xFD, 0x77, 0x09, 0xFC, 0x81, 0xD0,
  0x5F, 0xC0, 0xE7, 0x70, 0x7F, 0xC8, 0x1E, 0x05, 0xFC, 0x0D, 0x77, 0x06, 0xFD, 0x10, 0x5F, 0xC0,
  0xD7, 0x70, 0x6F, 0xD1, 0x05, 0xFC, 0x0C, 0x77, 0x05, 0xFD, 0x01, 0x05, 0xFC, 0x0C, 0x77, 0x05,
  0xFD, 0x01, 0x05, 0xFC, 0x0C, 0x77, 0x05, 0xFD, 0x01, 0x05, 0xFC, 0x0D, 0x77, 0x06, 0xFD, 0x10,
  0x5F, 0xC0, 0xD7, 0x70, 0x6F, 0xD1, 0x05, 0xFC, 0x0E, 0x77, 0x07, 0xFC, 0x81, 0xE0, 0x5F, 0xD7,
  0x70, 0x9F, 0xC8, 0x1D, 0x05, 0xFD, 0x01, 0x76, 0x0A, 0xFC, 0x81, 0xC0, 0x5F, 0xD0, 0x37, 0x60,
  0xCF, 0xC8, 0x1A, 0x05, 0xFD, 0x06, 0x76, 0xFD, 0x81, 0x80, 0x5F, 0xD0, 0x97, 0x50, 0x3F, 0xD8,
  0x15, 0x05, 0xFD, 0x0D, 0x75, 0x08, 0xFD, 0x81, 0x20, 0x5F, 0xE0, 0x47, 0x40, 0xDF, 0xC0, 0xE2,
  0x05, 0xFE, 0x0B, 0x73, 0x05, 0xFD, 0x0B, 0x20, 0x5F, 0xF0, 0x67, 0x10, 0x10, 0xEF, 0xD0, 0x72,
  0x05, 0xFF, 0x90, 0x76, 0x01, 0x0C, 0xFE, 0x01, 0x20, 0x5F, 0xFA, 0x85, 0xC7, 0x42, 0x48, 0xEF,
  0xE0, 0xB3, 0x05, 0x80, 0xC0, 0xF0, 0x53, 0x05, 0xFF, 0xFF, 0xF0, 0xD4, 0x05, 0xFF, 0xFF, 0xF0,
  0x54, 0x05, 0xFC, 0x08, 0x0D, 0xFF, 0xF0, 0xB5, 0x05, 0xFC, 0x07, 0x04, 0xFF, 0xE0, 0xE0, 0x15,
  0x05, 0xFC, 0x81, 0x90, 0x7F, 0xFD, 0x04, 0x60, 0x5F, 0xC0, 0xA2, 0x08, 0xFF, 0xB0, 0x57, 0x05,
  0xFC, 0x0A, 0x30, 0x6F, 0xF0, 0xD0, 0x37, 0x10, 0x5F, 0xC0, 0xB4, 0x02, 0x0A, 0xFB, 0x81, 0xE8,
  0x17, 0x20, 0x5F, 0xC0, 0xC6, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDA, 0x61, 0x74, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05,
  0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC,
  0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  // "q" (U+0071)
  0x74, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDA, 0x61, 0x77, 0x76, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x50,
  0x9F, 0xA0, 0xE7, 0x10, 0x7F, 0xF0, 0xD0, 0x34, 0x0B, 0xFA, 0x0E, 0x70, 0x9F, 0xFA, 0x0E, 0x04,
  0x30, 0xEF, 0xA0, 0xE6, 0x09, 0xFF, 0xC8, 0x2E, 0x20, 0x1F, 0xB0, 0xE5, 0x06, 0xFF, 0xE8, 0x1D,
  0x03, 0xFB, 0x0E, 0x40, 0x20, 0xEF, 0xFF, 0x07, 0x06, 0xFB, 0x0E, 0x40, 0xBF, 0xFF, 0xFE, 0x0E,
  0x30, 0x4F, 0xFF, 0xFF, 0x0E, 0x30, 0xBF, 0xFF, 0xFF, 0x0E, 0x20, 0x2F, 0xF8, 0x5D, 0x63, 0x35,
  0x8E, 0xFF, 0x90, 0xE2, 0x07, 0xFE, 0x08, 0x70, 0xAF, 0xF0, 0xE2, 0x0C, 0xFD, 0x0A, 0x72, 0x0A,
  0xFE, 0x81, 0xE0, 0x1F, 0xD0, 0xE0, 0x17, 0x20, 0x10, 0xEF, 0xD8, 0x1E, 0x05, 0xFD, 0x08, 0x74,
  0x07, 0xFD, 0x81, 0xE0, 0x8F, 0xD0, 0x37, 0x40, 0x1F, 0xD8, 0x1E, 0x0B, 0xFC, 0x0D, 0x76, 0x0C,
  0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0xA7, 0x60, 0x9F, 0xC0, 0xE1, 0xFD, 0x07, 0x76, 0x06, 0xFC, 0x0E,
  0x02, 0xFD, 0x05, 0x76, 0x04, 0xFC, 0x0E, 0x04, 0xFD, 0x03, 0x76, 0x02, 0xFC, 0x0E, 0x05, 0xFD,
  0x01, 0x76, 0x01, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E,
  0x07, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x7F, 0xC0, 0xE7, 0x71, 0x0E, 0xFB, 0x0E, 0x07, 0xFC, 0x0E,
  0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0,
  0xE0, 0x5F, 0xD0, 0x17, 0x7F, 0xC0, 0xE0, 0x4F, 0xD0, 0x27, 0x60, 0x1F, 0xC0, 0xE0, 0x3F, 0xD0,
  0x47, 0x60, 0x3F, 0xC0, 0xE0, 0x1F, 0xD0, 0x67, 0x60, 0x5F, 0xC8, 0x1E, 0x0E, 0xFC, 0x09, 0x76,
  0x08, 0xFC, 0x81, 0xE0, 0xCF, 0xC0, 0xD7, 0x60, 0xCF, 0xC8, 0x1E, 0x09, 0xFD, 0x02, 0x74, 0x01,
  0xFD, 0x81, 0xE0, 0x6F, 0xD0, 0x87, 0x40, 0x6F, 0xD8, 0x1E, 0x02, 0xFD, 0x0E, 0x01, 0x73, 0x0D,
  0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0xA7, 0x20, 0x9F, 0xE0, 0xE2, 0x09, 0xFE, 0x09, 0x70, 0x9F, 0xF0,
  0xE2, 0x03, 0xFF, 0x85, 0xD6, 0x32, 0x48, 0xDF, 0xF9, 0x0E, 0x30, 0xCF, 0xFF, 0xFF, 0x0E, 0x30,
  0x5F, 0xFF, 0xFF, 0x0E, 0x40, 0xCF, 0xFF, 0x90, 0x0E, 0xFB, 0x0E, 0x40, 0x4F, 0xFF, 0x90, 0x40,
  0xCF, 0xB0, 0xE5, 0x08, 0xFF, 0xE8, 0x1A, 0x0D, 0xFB, 0x0E, 0x60, 0xBF, 0xFC, 0x0D, 0x20, 0xEF,
  0xB0, 0xE7, 0x0B, 0xFF, 0xA0, 0xD0, 0x12, 0xFC, 0x0E, 0x71, 0x09, 0xFF, 0x0B, 0x01, 0x20, 0x1F,
  0xC0, 0xE7, 0x20, 0x40, 0xCF, 0xB0, 0xD0, 0x54, 0x02, 0xFC, 0x0E, 0x74, 0x82, 0x38, 0xBE, 0xA8,
  0x2E, 0xB8, 0x46, 0x02, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E,
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77,
  0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76,
  0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03,
  0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC,
  0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E,
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x76, 0x03, 0xFC, 0x0E,
  // "r" (U+0072)
  0x77, 0x68, 0x76, 0xAD, 0xEE, 0xDB, 0x75, 0xFA, 0x02, 0x70, 0x60, 0xEF, 0x0E, 0x05, 0xFA, 0x05,
  0x60, 0xAF, 0xA0, 0xD0, 0x5F, 0xA0, 0x95, 0x0C, 0xFB, 0x0C, 0x05, 0xFA, 0x0C, 0x40, 0xBF, 0xC0,
  0xB0, 0x5F, 0xB0, 0x12, 0x08, 0xFD, 0x0A, 0x05, 0xFB, 0x81, 0x40, 0x4F, 0xE0, 0x80, 0x5F, 0xB8,
  0x18, 0x0D, 0xFE, 0x07, 0x05, 0xFB, 0x0C, 0x07, 0xFF, 0x06, 0x05, 0xFF, 0xFD, 0x00, 0x5F, 0xFF,
  0xD0, 0x30, 0x5F, 0xFF, 0xD0, 0x20, 0x5F, 0xFB, 0x82, 0xE9, 0x42, 0x28, 0x32, 0x5C, 0x15, 0xFF,
  0xA0, 0x90, 0x17, 0x20, 0x5F, 0xF9, 0x07, 0x74, 0x05, 0xFF, 0x08, 0x75, 0x05, 0xFE, 0x0C, 0x76,
  0x05, 0xFE, 0x04, 0x76, 0x05, 0xFD, 0x0D, 0x77, 0x05, 0xFD, 0x08, 0x77, 0x05, 0xFD, 0x05, 0x77,
  0x05, 0xFD, 0x02, 0x77, 0x05, 0xFD, 0x77, 0x10, 0x5F, 0xD7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10,
  0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E,
  0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05,
  0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7,
  0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F,
  0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77,
  0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC,
  0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0E, 0x77, 0x10, 0x5F, 0xC0, 0xE7, 0x71,
  // "s" (U+0073)
  0x73, 0x89, 0x34, 0x7A, 0xCD, 0xEF, 0xEE, 0xCA, 0x74, 0x77, 0x20, 0x30, 0x9F, 0xF9, 0x0A, 0x04,
  0x74, 0x02, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x70, 0x60, 0xEF, 0xFF, 0x90, 0xE0, 0x75, 0x08, 0xFF,
  0xFD, 0x09, 0x30, 0x6F, 0xFF, 0xE0, 0x42, 0x02, 0xFF, 0xFE, 0x0D, 0x30, 0xAF, 0xFF, 0xE0, 0x82,
  0x01, 0xFF, 0xFF, 0x02, 0x20, 0x7F, 0xFF, 0xE0, 0xC3, 0x0A, 0xFD, 0x87, 0xD7, 0x32, 0x34, 0x6A,
  0xEE, 0x07, 0x30, 0xDF, 0xC0, 0xB7, 0x20, 0x60, 0xDC, 0x01, 0x3F, 0xD0, 0x27, 0x48, 0x25, 0xDF,
  0xB4, 0xFD, 0x77, 0x07, 0x05, 0x4F, 0xD7, 0x76, 0x0E, 0xFC, 0x04, 0x77, 0x50, 0xDF, 0xC0, 0xD0,
  0x17, 0x74, 0x0A, 0xFD, 0x0D, 0x04, 0x77, 0x30, 0x6F, 0xF0, 0xA0, 0x17, 0x71, 0x02, 0xFF, 0x90,
  0xE0, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0xD0, 0x67, 0x60, 0x3F, 0xFC, 0x0C, 0x04, 0x75, 0x09, 0xFF,
  0xD0, 0xB0, 0x17, 0x40, 0xBF, 0xFD, 0x0E, 0x06, 0x74, 0x0C, 0xFF, 0xE0, 0x97, 0x40, 0xAF, 0xFE,
  0x0C, 0x01, 0x73, 0x07, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0x20, 0xBF, 0xFD, 0x0B, 0x75, 0x04, 0x0D,
  0xFF, 0xC0, 0x77, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x77, 0x10, 0x60, 0xDF, 0xF9, 0x06, 0x77, 0x20,
  0x8F, 0xF0, 0xB7, 0x73, 0x03, 0x0D, 0xFD, 0x0E, 0x77, 0x40, 0x10, 0xDF, 0xD0, 0x27, 0x74, 0x05,
  0xFD, 0x03, 0x77, 0x5F, 0xD0, 0x47, 0x75, 0x0D, 0xFC, 0x81, 0x4A, 0x47, 0x73, 0xFD, 0x83, 0x3E,
  0xFC, 0x57, 0x70, 0x5F, 0xD0, 0x10, 0xEB, 0x81, 0xE9, 0x47, 0x30, 0x20, 0xEF, 0xC8, 0x1E, 0x0E,
  0xE8, 0x90, 0xEB, 0x85, 0x32, 0x23, 0x5A, 0xFE, 0x81, 0xB0, 0xEF, 0xFF, 0xF9, 0x81, 0x60, 0xEF,
  0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0x92, 0x0E, 0xFF, 0xFE, 0x0E, 0x01, 0x20, 0xEF, 0xFF,
  0xE0, 0x43, 0x0E, 0xFF, 0xFD, 0x05, 0x40, 0xEF, 0xFF, 0xB0, 0xD0, 0x45, 0x05, 0x0C, 0xFF, 0xF9,
  0x09, 0x72, 0x81, 0x28, 0xCF, 0xFA, 0x81, 0xE8, 0x17, 0x68, 0x61, 0x47, 0x9B, 0xDD, 0xEA, 0x84,
  0xED, 0xC9, 0x62, 0x74,
  // "t" (U+0074)
  0x72, 0x02, 0x80, 0x37, 0x06, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x60, 0xDF, 0x0C, 0x77, 0x50, 0x2F,
  0x90, 0xC7, 0x75, 0x07, 0xF9, 0x0C, 0x77, 0x50, 0xBF, 0x90, 0xC7, 0x75, 0xFA, 0x0C, 0x77, 0x40,
  0x5F, 0xA0, 0xC7, 0x74, 0x09, 0xFA, 0x0C, 0x77, 0x40, 0xDF, 0xA0, 0xC7, 0x73, 0x03, 0xFB, 0x0C,
  0x77, 0x20, 0x10, 0xAF, 0xFF, 0x02, 0x40, 0x60, 0xEF, 0xFF, 0x90, 0x22, 0x04, 0x0D, 0xFF, 0xFB,
  0x81, 0x22, 0xBF, 0xFF, 0xD0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF,
  0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE8, 0x52, 0x12, 0x22,
  0x26, 0xFC, 0x0D, 0x80, 0x62, 0x60, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F,
  0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77,
  0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC,
  0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72,
  0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0,
  0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20,
  0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C,
  0x77, 0x20, 0x4F, 0xC0, 0xD7, 0x72, 0x04, 0xFD, 0x01, 0x77, 0x10, 0x3F, 0xD0, 0x67, 0x71, 0x01,
  0xFD, 0x0E, 0x02, 0x71, 0x04, 0x60, 0xEF, 0xD8, 0x90, 0xE7, 0x32, 0x35, 0x7B, 0xFC, 0x60, 0xBF,
  0xFF, 0x0C, 0x60, 0x8F, 0xFF, 0x0C, 0x60, 0x3F, 0xFF, 0x0C, 0x70, 0xCF, 0xFE, 0x0C, 0x70, 0x5F,
  0xFE, 0x0C, 0x71, 0x0B, 0xFF, 0xD0, 0xC7, 0x10, 0x10, 0xCF, 0xFC, 0x0C, 0x73, 0x0A, 0xFF, 0xB0,
  0xB7, 0x40, 0x50, 0xCF, 0xE0, 0xB0, 0x57, 0x78, 0x92, 0x37, 0xBD, 0xEF, 0xEE, 0xCA, 0x74, 0x40,
  // "u" (U+0075)
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B,
  0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07,
  0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A,
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x08, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x08, 0xFC, 0x0A, 0x08, 0xFC, 0x0B,
  0x76, 0x09, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x09, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x0B,
  0xFC, 0x0A, 0x08, 0xFC, 0x0C, 0x76, 0x0D, 0xFC, 0x0A, 0x08, 0xFC, 0x0C, 0x76, 0xFD, 0x0A, 0x07,
  0xFC, 0x0E, 0x75, 0x02, 0xFD, 0x0A, 0x07, 0xFD, 0x75, 0x05, 0xFD, 0x0A, 0x06, 0xFD, 0x03, 0x74,
  0x0A, 0xFD, 0x0A, 0x05, 0xFD, 0x07, 0x74, 0x0E, 0xFD, 0x0A, 0x03, 0xFD, 0x0C, 0x73, 0x07, 0xFE,
  0x0A, 0x01, 0xFE, 0x04, 0x71, 0x02, 0x0E, 0xFE, 0x81, 0xA0, 0xDF, 0xD0, 0xD0, 0x26, 0x03, 0x0E,
  0xFF, 0x81, 0xA0, 0xAF, 0xE8, 0x5E, 0x84, 0x24, 0x6B, 0xFF, 0xA8, 0x1A, 0x05, 0x80, 0xC0, 0xF0,
  0xA2, 0x0E, 0xFF, 0xFF, 0xF0, 0xA2, 0x09, 0xFF, 0xFF, 0xF0, 0xA2, 0x01, 0x0E, 0xFF, 0xF9, 0x0C,
  0x04, 0xFB, 0x0A, 0x30, 0x7F, 0xFF, 0x98, 0x12, 0x0E, 0xFA, 0x0A, 0x40, 0xAF, 0xFE, 0x05, 0x20,
  0xBF, 0xA0, 0xA5, 0x0B, 0xFF, 0xC0, 0x63, 0x06, 0xFA, 0x0A, 0x60, 0x8F, 0xF9, 0x0D, 0x04, 0x40,
  0x2F, 0xA0, 0xA7, 0x03, 0x0B, 0xFC, 0x0E, 0x08, 0x70, 0xEF, 0x90, 0xA7, 0x28, 0x32, 0x6A, 0xDE,
  0xA8, 0x2E, 0xC9, 0x47, 0x75,
  // "v" (U+0076)
  0x0A, 0xFD, 0x77, 0x30, 0xBF, 0xC0, 0xE0, 0x5F, 0xD0, 0x37, 0x72, 0x0E, 0xFC, 0x0A, 0x01, 0xFD,
  0x07, 0x77, 0x10, 0x3F, 0xD8, 0x15, 0x0B, 0xFC, 0x0B, 0x77, 0x10, 0x7F, 0xD2, 0x06, 0xFD, 0x77,
  0x10, 0xBF, 0xC0, 0xB2, 0x02, 0xFD, 0x04, 0x77, 0xFD, 0x06, 0x30, 0xCF, 0xC0, 0x87, 0x60, 0x4F,
  0xD0, 0x13, 0x08, 0xFC, 0x0C, 0x76, 0x08, 0xFC, 0x0C, 0x40, 0x3F, 0xD7, 0x60, 0xCF, 0xC0, 0x85,
  0x0E, 0xFC, 0x04, 0x75, 0xFD, 0x03, 0x50, 0x9F, 0xC0, 0x87, 0x40, 0x4F, 0xC0, 0xD6, 0x04, 0xFC,
  0x0C, 0x74, 0x08, 0xFC, 0x09, 0x70, 0xEF, 0xC7, 0x40, 0xCF, 0xC0, 0x47, 0x0A, 0xFC, 0x04, 0x72,
  0x01, 0xFC, 0x0E, 0x71, 0x06, 0xFC, 0x08, 0x72, 0x05, 0xFC, 0x0A, 0x71, 0x01, 0xFC, 0x0C, 0x72,
  0x09, 0xFC, 0x05, 0x72, 0x0C, 0xFC, 0x01, 0x71, 0x0D, 0xFC, 0x01, 0x72, 0x07, 0xFC, 0x04, 0x70,
  0x1F, 0xC0, 0xC7, 0x30, 0x2F, 0xC0, 0x87, 0x05, 0xFC, 0x07, 0x74, 0x0D, 0xFB, 0x0C, 0x70, 0x9F,
  0xC0, 0x27, 0x40, 0x8F, 0xC0, 0x16, 0x0D, 0xFB, 0x0D, 0x75, 0x04, 0xFC, 0x05, 0x50, 0x2F, 0xC0,
  0x87, 0x60, 0xEF, 0xB0, 0x95, 0x06, 0xFC, 0x03, 0x76, 0x0A, 0xFB, 0x0C, 0x50, 0xAF, 0xB0, 0xE7,
  0x70, 0x5F, 0xC0, 0x14, 0x0E, 0xFB, 0x09, 0x77, 0x1F, 0xC0, 0x53, 0x03, 0xFC, 0x05, 0x77, 0x10,
  0xBF, 0xB0, 0x93, 0x07, 0xFC, 0x77, 0x20, 0x6F, 0xB0, 0xD3, 0x0A, 0xFB, 0x0B, 0x77, 0x20, 0x1F,
  0xC0, 0x12, 0x0E, 0xFB, 0x06, 0x77, 0x30, 0xCF, 0xB8, 0x14, 0x02, 0xFC, 0x01, 0x77, 0x30, 0x8F,
  0xB8, 0x17, 0x05, 0xFB, 0x0C, 0x77, 0x40, 0x3F, 0xB8, 0x1A, 0x08, 0xFB, 0x07, 0x77, 0x50, 0xDF,
  0xA8, 0x1C, 0x0B, 0xFB, 0x03, 0x77, 0x50, 0x9F, 0xA8, 0x1E, 0x0D, 0xFA, 0x0D, 0x77, 0x60, 0x4F,
  0xB0, 0x1F, 0xB0, 0x97, 0x77, 0x0E, 0xFA, 0x04, 0xFB, 0x04, 0x77, 0x70, 0xAF, 0xA0, 0x8F, 0xA0,
  0xE7, 0x77, 0x10, 0x5F, 0xFD, 0x0A, 0x77, 0x71, 0x01, 0xFF, 0xD0, 0x57, 0x77, 0x20, 0xCF, 0xFC,
  0x01, 0x77, 0x72, 0x07, 0xFF, 0xB0, 0xB7, 0x77, 0x30, 0x2F, 0xFB, 0x07, 0x77, 0x74, 0x0D, 0xFF,
  0xA0, 0x27, 0x77, 0x40, 0x8F, 0xF9, 0x0D, 0x77, 0x75, 0x03, 0xFF, 0x90, 0x87, 0x77, 0x60, 0xEF,
  0xF0, 0x37, 0x77, 0x60, 0x9F, 0xE0, 0xE7, 0x77, 0x70, 0x5F, 0xE0, 0x97, 0x77, 0x71, 0xFE, 0x05,
  0x77,
  // "w" (U+0077)
  0x04, 0xFC, 0x0E, 0x76, 0x0C, 0xFE, 0x02, 0x75, 0x08, 0xFC, 0x06, 0x1F, 0xD0, 0x27, 0x5F, 0xF0,
  0x57, 0x50, 0xCF, 0xC8, 0x12, 0x0C, 0xFC, 0x06, 0x74, 0x04, 0xFF, 0x08, 0x75, 0xFC, 0x0E, 0x20,
  0x8F, 0xC0, 0x97, 0x40, 0x7F, 0xF0, 0xB7, 0x40, 0x3F, 0xC0, 0xA2, 0x05, 0xFC, 0x0C, 0x74, 0x0A,
  0xFF, 0x0E, 0x74, 0x06, 0xFC, 0x06, 0x20, 0x1F, 0xD7, 0x40, 0xEF, 0xF9, 0x02, 0x73, 0x0A, 0xFC,
  0x03, 0x30, 0xDF, 0xC0, 0x37, 0x20, 0x1F, 0xFA, 0x05, 0x73, 0x0D, 0xFB, 0x0E, 0x40, 0x9F, 0xC0,
  0x67, 0x20, 0x5F, 0xFA, 0x09, 0x72, 0x01, 0xFC, 0x0B, 0x40, 0x6F, 0xC0, 0xA7, 0x20, 0x8F, 0xFA,
  0x0C, 0x72, 0x04, 0xFC, 0x07, 0x40, 0x2F, 0xC0, 0xD7, 0x20, 0xCF, 0xFB, 0x72, 0x08, 0xFC, 0x04,
  0x50, 0xEF, 0xC0, 0x17, 0x1F, 0xFC, 0x03, 0x71, 0x0B, 0xFC, 0x60, 0xAF, 0xC0, 0x47, 0x03, 0xFA,
  0x0E, 0xF9, 0x06, 0x71, 0x0E, 0xFB, 0x0C, 0x60, 0x7F, 0xC0, 0x77, 0x06, 0xF9, 0x0C, 0x0A, 0xF9,
  0x09, 0x70, 0x2F, 0xC0, 0x86, 0x03, 0xFC, 0x0A, 0x70, 0x9F, 0x90, 0x90, 0x7F, 0x90, 0xC7, 0x06,
  0xFC, 0x04, 0x7F, 0xC0, 0xE7, 0x0D, 0xF9, 0x06, 0x05, 0xFA, 0x70, 0x9F, 0xC0, 0x17, 0x0B, 0xFC,
  0x01, 0x50, 0x1F, 0xA0, 0x30, 0x2F, 0xA0, 0x36, 0x0C, 0xFB, 0x0D, 0x71, 0x08, 0xFC, 0x05, 0x50,
  0x4F, 0xA2, 0xFA, 0x06, 0x6F, 0xC0, 0x97, 0x10, 0x4F, 0xC0, 0x85, 0x07, 0xF9, 0x0D, 0x20, 0xCF,
  0x90, 0x95, 0x03, 0xFC, 0x05, 0x71, 0x01, 0xFC, 0x0B, 0x50, 0xBF, 0x90, 0xA2, 0x0A, 0xF9, 0x0D,
  0x50, 0x7F, 0xC0, 0x27, 0x20, 0xCF, 0xB0, 0xE5, 0x0E, 0xF9, 0x07, 0x20, 0x7F, 0xA5, 0x0A, 0xFB,
  0x0D, 0x73, 0x09, 0xFC, 0x02, 0x30, 0x2F, 0xA0, 0x52, 0x04, 0xFA, 0x04, 0x40, 0xEF, 0xB0, 0xA7,
  0x30, 0x5F, 0xC0, 0x43, 0x05, 0xFA, 0x02, 0x20, 0x1F, 0xA0, 0x73, 0x01, 0xFC, 0x06, 0x73, 0x01,
  0xFC, 0x07, 0x30, 0x8F, 0x90, 0xE4, 0x0E, 0xF9, 0x09, 0x30, 0x4F, 0xC0, 0x27, 0x40, 0xDF, 0xB0,
  0xA3, 0x0B, 0xF9, 0x0C, 0x40, 0xBF, 0x90, 0xC3, 0x07, 0xFB, 0x0E, 0x75, 0x0A, 0xFB, 0x0C, 0x30,
  0xDF, 0x90, 0x94, 0x08, 0xF9, 0x0E, 0x30, 0xAF, 0xB0, 0xB7, 0x50, 0x6F, 0xB0, 0xE3, 0xFA, 0x06,
  0x40, 0x5F, 0xA0, 0x22, 0x0C, 0xFB, 0x07, 0x75, 0x03, 0xFC, 0x81, 0x10, 0x3F, 0xA0, 0x34, 0x02,
  0xFA, 0x04, 0x20, 0xEF, 0xB0, 0x37, 0x60, 0xEF, 0xB8, 0x13, 0x05, 0xFA, 0x6F, 0xA8, 0x16, 0x01,
  0xFC, 0x77, 0x0B, 0xFB, 0x81, 0x50, 0x8F, 0x90, 0xC6, 0x0C, 0xF9, 0x81, 0x90, 0x4F, 0xB0, 0xB7,
  0x70, 0x7F, 0xB8, 0x17, 0x0A, 0xF9, 0x09, 0x60, 0x9F, 0x98, 0x1B, 0x06, 0xFB, 0x08, 0x77, 0x04,
  0xFB, 0x81, 0x90, 0xCF, 0x90, 0x66, 0x06, 0xF9, 0x81, 0xD0, 0x8F, 0xB0, 0x47, 0x71, 0xFB, 0x81,
  0xB0, 0xEF, 0x90, 0x36, 0x03, 0xFA, 0x10, 0xAF, 0xB7, 0x72, 0x0C, 0xFA, 0x0D, 0x01, 0xFA, 0x71,
  0xFA, 0x02, 0x0C, 0xFA, 0x0C, 0x77, 0x20, 0x8F, 0xB0, 0x3F, 0x90, 0xC7, 0x10, 0xCF, 0x90, 0x40,
  0xDF, 0xA0, 0x87, 0x72, 0x05, 0xFB, 0x06, 0xF9, 0x09, 0x71, 0x09, 0xF9, 0x05, 0xFB, 0x05, 0x77,
  0x20, 0x1F, 0xB0, 0x9F, 0x90, 0x67, 0x10, 0x6F, 0x90, 0x8F, 0xB0, 0x17, 0x73, 0x0D, 0xFA, 0x0E,
  0xF9, 0x03, 0x71, 0x03, 0xF9, 0x0E, 0xFA, 0x0D, 0x77, 0x40, 0x9F, 0xFC, 0x72, 0x01, 0xFF, 0xC0,
  0x97, 0x74, 0x06, 0xFF, 0xB0, 0xC7, 0x30, 0xDF, 0xFB, 0x06, 0x77, 0x40, 0x2F, 0xFB, 0x09, 0x73,
  0x0A, 0xFF, 0xB0, 0x27, 0x75, 0x0E, 0xFF, 0xA0, 0x67, 0x30, 0x7F, 0xFA, 0x0E, 0x77, 0x60, 0xAF,
  0xFA, 0x03, 0x73, 0x04, 0xFF, 0xA0, 0xA7, 0x76, 0x07, 0xFF, 0xA7, 0x40, 0x1F, 0xFA, 0x06, 0x77,
  0x60, 0x3F, 0xF9, 0x0C, 0x75, 0x0E, 0xFF, 0x90, 0x37, 0x77, 0xFF, 0x90, 0x97, 0x50, 0xBF, 0xF0,
  0xE7, 0x77, 0x10, 0xBF, 0xF0, 0x67, 0x50, 0x8F, 0xF0, 0xB7, 0x77, 0x10, 0x8F, 0xF0, 0x37, 0x50,
  0x5F, 0xF0, 0x77, 0x77, 0x10, 0x4F, 0xF7, 0x60, 0x2F, 0xF0, 0x47, 0x77, 0x10, 0x1F, 0xE0, 0xC7,
  0x70, 0xEF, 0xE7, 0x50,
  // "x" (U+0078)
  0x10, 0x8F, 0xD0, 0xD7, 0x60, 0xCF, 0xD0, 0x72, 0x01, 0x0E, 0xFD, 0x05, 0x74, 0x03, 0xFD, 0x0E,
  0x01, 0x30, 0x8F, 0xD0, 0xC7, 0x40, 0xAF, 0xD0, 0x74, 0x01, 0x0E, 0xFD, 0x03, 0x72, 0x02, 0xFD,
  0x0E, 0x60, 0x7F, 0xD0, 0xA7, 0x20, 0x9F, 0xD0, 0x77, 0x0E, 0xFD, 0x01, 0x70, 0x10, 0xEF, 0xC0,
  0xE7, 0x10, 0x6F, 0xD0, 0x87, 0x07, 0xFD, 0x07, 0x72, 0x0D, 0xFC, 0x0E, 0x70, 0xEF, 0xC0, 0xE7,
  0x30, 0x5F, 0xD0, 0x65, 0x05, 0xFD, 0x06, 0x74, 0x0D, 0xFC, 0x0D, 0x50, 0xCF, 0xC0, 0xD7, 0x50,
  0x5F, 0xD0, 0x53, 0x04, 0xFD, 0x06, 0x76, 0x0C, 0xFC, 0x0C, 0x30, 0xBF, 0xC0, 0xD7, 0x70, 0x4F,
  0xD8, 0x13, 0x02, 0xFD, 0x06, 0x77, 0x10, 0xBF, 0xC8, 0x1A, 0x09, 0xFC, 0x0D, 0x77, 0x20, 0x3F,
  0xD0, 0x3F, 0xD0, 0x67, 0x73, 0x0B, 0xFC, 0x0E, 0xFC, 0x0D, 0x77, 0x40, 0x3F, 0xFF, 0xA0, 0x57,
  0x75, 0x0A, 0xFF, 0xF0, 0xD7, 0x76, 0x02, 0xFF, 0xF0, 0x57, 0x77, 0x09, 0xFF, 0xD0, 0xD7, 0x77,
  0x10, 0x1F, 0xFD, 0x05, 0x77, 0x72, 0x09, 0xFF, 0xB0, 0xC7, 0x77, 0x30, 0x10, 0xEF, 0xFA, 0x05,
  0x77, 0x74, 0x08, 0xFF, 0x90, 0xC7, 0x77, 0x50, 0x9F, 0xF9, 0x07, 0x77, 0x74, 0x02, 0xFF, 0xA0,
  0xD7, 0x77, 0x40, 0xAF, 0xFB, 0x06, 0x77, 0x72, 0x02, 0xFF, 0xC0, 0xE7, 0x77, 0x20, 0xAF, 0xFD,
  0x07, 0x77, 0x70, 0x3F, 0xFE, 0x0E, 0x01, 0x77, 0x60, 0xBF, 0xFF, 0x08, 0x77, 0x50, 0x4F, 0xFF,
  0xA0, 0x17, 0x74, 0x0C, 0xFF, 0xFA, 0x09, 0x77, 0x30, 0x4F, 0xD0, 0xAF, 0xD0, 0x27, 0x72, 0x0C,
  0xFC, 0x81, 0xA1, 0xEF, 0xC0, 0xA7, 0x71, 0x05, 0xFD, 0x81, 0x30, 0x8F, 0xD0, 0x37, 0x70, 0xDF,
  0xC0, 0xB2, 0x01, 0xFD, 0x0B, 0x76, 0x06, 0xFD, 0x04, 0x30, 0x9F, 0xD0, 0x47, 0x50, 0xDF, 0xC0,
  0xC4, 0x02, 0xFD, 0x0C, 0x74, 0x06, 0xFD, 0x05, 0x50, 0xAF, 0xD0, 0x57, 0x30, 0xEF, 0xC0, 0xD6,
  0x02, 0xFD, 0x0D, 0x72, 0x07, 0xFD, 0x06, 0x70, 0xAF, 0xD0, 0x67, 0x10, 0xEF, 0xC0, 0xD7, 0x10,
  0x3F, 0xD0, 0xD7, 0x07, 0xFD, 0x07, 0x72, 0x0B, 0xFD, 0x07, 0x50, 0x10, 0xEF, 0xC0, 0xE7, 0x30,
  0x4F, 0xD0, 0xE0, 0x14, 0x08, 0xFD, 0x07, 0x74, 0x0C, 0xFD, 0x08, 0x30, 0x1F, 0xD0, 0xE0, 0x17,
  0x40, 0x4F, 0xD0, 0xE0, 0x12, 0x09, 0xFD, 0x08, 0x76, 0x0C, 0xFD, 0x81, 0x90, 0x2F, 0xE0, 0x17,
  0x60, 0x5F, 0xE0, 0x20,
  // "y" (U+0079)
  0x0A, 0xFD, 0x04, 0x77, 0x20, 0xCF, 0xC0, 0xE0, 0x5F, 0xD0, 0x87, 0x71, 0x01, 0xFD, 0x0A, 0x1F,
  0xD0, 0xC7, 0x71, 0x04, 0xFD, 0x81, 0x50, 0xAF, 0xD0, 0x17, 0x70, 0x8F, 0xD8, 0x11, 0x05, 0xFD,
  0x05, 0x77, 0x0C, 0xFC, 0x0B, 0x20, 0x1F, 0xD0, 0x97, 0x60, 0x1F, 0xD0, 0x63, 0x0B, 0xFC, 0x0D,
  0x76, 0x05, 0xFD, 0x02, 0x30, 0x6F, 0xD0, 0x27, 0x50, 0x8F, 0xC0, 0xD4, 0x01, 0xFD, 0x06, 0x75,
  0x0C, 0xFC, 0x08, 0x50, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0x35, 0x07, 0xFC, 0x0E, 0x74, 0x05,
  0xFC, 0x0E, 0x60, 0x2F, 0xD0, 0x37, 0x30, 0x9F, 0xC0, 0x97, 0x0C, 0xFC, 0x07, 0x73, 0x0D, 0xFC,
  0x05, 0x70, 0x7F, 0xC0, 0xB7, 0x20, 0x1F, 0xD7, 0x10, 0x2F, 0xD7, 0x20, 0x5F, 0xC0, 0xB7, 0x20,
  0xDF, 0xC0, 0x47, 0x10, 0x9F, 0xC0, 0x67, 0x20, 0x8F, 0xC0, 0x87, 0x10, 0xDF, 0xC0, 0x27, 0x20,
  0x3F, 0xC0, 0xD7, 0x01, 0xFC, 0x0C, 0x74, 0x0E, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x87, 0x40, 0x9F,
  0xC0, 0x56, 0x09, 0xFC, 0x03, 0x74, 0x04, 0xFC, 0x0A, 0x60, 0xDF, 0xB0, 0xE7, 0x60, 0xEF, 0xB0,
  0xE5, 0x01, 0xFC, 0x09, 0x76, 0x09, 0xFC, 0x02, 0x40, 0x5F, 0xC0, 0x47, 0x60, 0x4F, 0xC0, 0x74,
  0x09, 0xFC, 0x77, 0x10, 0xEF, 0xB0, 0xB4, 0x0D, 0xFB, 0x0B, 0x77, 0x10, 0xAF, 0xB0, 0xE3, 0x02,
  0xFC, 0x06, 0x77, 0x10, 0x5F, 0xC0, 0x32, 0x06, 0xFC, 0x01, 0x77, 0x2F, 0xC0, 0x62, 0x0A, 0xFB,
  0x0C, 0x77, 0x30, 0xBF, 0xB0, 0xA2, 0x0D, 0xFB, 0x07, 0x77, 0x30, 0x6F, 0xB8, 0x1D, 0x01, 0xFC,
  0x03, 0x77, 0x30, 0x1F, 0xC0, 0x10, 0x5F, 0xB0, 0xD7, 0x75, 0x0B, 0xFB, 0x03, 0x07, 0xFB, 0x09,
  0x77, 0x50, 0x6F, 0xB0, 0x60, 0xAF, 0xB0, 0x47, 0x75, 0x01, 0xFB, 0x08, 0x0D, 0xFA, 0x0E, 0x77,
  0x70, 0xCF, 0xA0, 0xBF, 0xB0, 0xA7, 0x77, 0x07, 0xFF, 0xE0, 0x67, 0x77, 0x02, 0xFF, 0xE0, 0x17,
  0x77, 0x10, 0xDF, 0xFC, 0x0C, 0x77, 0x72, 0x08, 0xFF, 0xC0, 0x77, 0x77, 0x20, 0x3F, 0xFC, 0x02,
  0x77, 0x73, 0x0D, 0xFF, 0xA0, 0xD7, 0x77, 0x40, 0x8F, 0xFA, 0x09, 0x77, 0x74, 0x03, 0xFF, 0xA0,
  0x47, 0x77, 0x50, 0xEF, 0xF0, 0xE7, 0x77, 0x60, 0x9F, 0xF0, 0xA7, 0x77, 0x60, 0x4F, 0xF0, 0x57,
  0x77, 0x70, 0xEF, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0xD0, 0xC7, 0x77, 0x71, 0x05, 0xFD, 0x07, 0x77,
  0x77, 0x10, 0x2F, 0xD0, 0x27, 0x77, 0x71, 0x05, 0xFC, 0x0D, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87,
  0x77, 0x72, 0x0E, 0xFC, 0x04, 0x77, 0x77, 0x10, 0x4F, 0xC0, 0xE7, 0x77, 0x72, 0x09, 0xFC, 0x0A,
  0x77, 0x77, 0x10, 0x1F, 0xD0, 0x57, 0x77, 0x71, 0x07, 0xFC, 0x0E, 0x77, 0x77, 0x10, 0x10, 0xEF,
  0xC0, 0xA7, 0x77, 0x71, 0x0A, 0xFD, 0x04, 0x77, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x78, 0x68, 0x74,
  0x32, 0x47, 0xDF, 0xE0, 0x67, 0x77, 0x0B, 0xFF, 0xD0, 0xD7, 0x77, 0x10, 0xBF, 0xFD, 0x05, 0x77,
  0x71, 0x0B, 0xFF, 0xC0, 0xB7, 0x77, 0x20, 0xBF, 0xFB, 0x0E, 0x01, 0x77, 0x72, 0x0B, 0xFF, 0xB0,
  0x47, 0x77, 0x30, 0xBF, 0xFA, 0x05, 0x77, 0x74, 0x0B, 0xFF, 0x0E, 0x04, 0x77, 0x75, 0x0B, 0xFE,
  0x0C, 0x01, 0x77, 0x76, 0x0B, 0xFC, 0x0C, 0x04, 0x77, 0x77, 0x18, 0x34, 0x8B, 0xDE, 0xA8, 0x3D,
  0xCA, 0x62, 0x77, 0x77,
  // "z" (U+007A)
  0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10,
  0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF,
  0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0xE2, 0x0E, 0xFF, 0xFF,
  0x07, 0x28, 0x09, 0x42, 0x0B, 0xFC, 0x0D, 0x77, 0x40, 0x3F, 0xD0, 0x57, 0x74, 0x0C, 0xFC, 0x0C,
  0x77, 0x40, 0x5F, 0xD0, 0x47, 0x74, 0x0D, 0xFC, 0x0B, 0x77, 0x40, 0x7F, 0xD0, 0x27, 0x73, 0x01,
  0x0E, 0xFC, 0x09, 0x77, 0x40, 0x9F, 0xC0, 0xE0, 0x17, 0x73, 0x02, 0xFD, 0x07, 0x77, 0x40, 0xBF,
  0xC0, 0xE7, 0x74, 0x04, 0xFD, 0x06, 0x77, 0x40, 0xCF, 0xC0, 0xD7, 0x74, 0x06, 0xFD, 0x04, 0x77,
  0x40, 0xEF, 0xC0, 0xB7, 0x74, 0x08, 0xFD, 0x03, 0x77, 0x30, 0x10, 0xEF, 0xC0, 0xA7, 0x74, 0x09,
  0xFD, 0x01, 0x77, 0x30, 0x3F, 0xD0, 0x87, 0x74, 0x0B, 0xFC, 0x0E, 0x01, 0x77, 0x30, 0x5F, 0xD0,
  0x67, 0x74, 0x0D, 0xFC, 0x0D, 0x77, 0x40, 0x6F, 0xD0, 0x57, 0x73, 0x01, 0x0E, 0xFC, 0x0C, 0x77,
  0x40, 0x8F, 0xD0, 0x37, 0x73, 0x02, 0xFD, 0x0A, 0x77, 0x40, 0xAF, 0xD0, 0x27, 0x73, 0x03, 0xFD,
  0x09, 0x77, 0x40, 0xCF, 0xC0, 0xE0, 0x17, 0x73, 0x05, 0xFD, 0x09, 0x80, 0x95, 0x21, 0x0D, 0xFF,
  0xFF, 0x90, 0xE0, 0x7F, 0xFF, 0xFA, 0x00, 0xEF, 0xFF, 0xFA, 0x0E, 0xFF, 0xFF, 0xB0, 0xEF, 0xFF,
  0xFB, 0x0E, 0xFF, 0xFF, 0xB0, 0xEF, 0xFF, 0xFB, 0x0E, 0xFF, 0xFF, 0xB0, 0xEF, 0xFF, 0xFB, 0x0E,
  0xFF, 0xFF, 0xB0, 0xE0,
  // "{" (U+007B)
  0x77, 0x68, 0x90, 0x35, 0x8A, 0xBD, 0xEE, 0xFB, 0x77, 0x38, 0x14, 0xAE, 0xFA, 0x0C, 0x77, 0x10,
  0x40, 0xDF, 0xD0, 0xC7, 0x70, 0x9F, 0xF0, 0xC7, 0x60, 0x9F, 0xF9, 0x0C, 0x75, 0x05, 0xFF, 0xA0,
  0xC7, 0x50, 0xDF, 0xFA, 0x0C, 0x74, 0x05, 0xFF, 0xB0, 0xC7, 0x40, 0x9F, 0xFB, 0x0C, 0x74, 0x0D,
  0xFF, 0xB0, 0xC7, 0x4F, 0xE8, 0x2E, 0x95, 0x27, 0x50, 0x2F, 0xD0, 0xA7, 0x72, 0x03, 0xFC, 0x0C,
  0x77, 0x30, 0x4F, 0xC0, 0x57, 0x73, 0x04, 0xFC, 0x01, 0x77, 0x30, 0x4F, 0xC7, 0x74, 0x04, 0xFB,
  0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74,
  0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0,
  0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40,
  0x5F, 0xB0, 0xE7, 0x74, 0x06, 0xFB, 0x0E, 0x77, 0x40, 0x9F, 0xB0, 0xE7, 0x74, 0x0D, 0xFB, 0x0D,
  0x77, 0x30, 0x6F, 0xC0, 0xC7, 0x72, 0x03, 0x0E, 0xFC, 0x09, 0x77, 0x10, 0x70, 0xEF, 0xD0, 0x57,
  0x38, 0x31, 0x25, 0x9E, 0xFE, 0x0E, 0x72, 0x01, 0xFF, 0xD0, 0x77, 0x20, 0x1F, 0xFC, 0x0B, 0x73,
  0x01, 0xFF, 0xB0, 0xA7, 0x40, 0x1F, 0xF9, 0x0D, 0x05, 0x75, 0x01, 0xFD, 0x81, 0xB7, 0x37, 0x70,
  0x1F, 0xD8, 0x19, 0x51, 0x77, 0x01, 0xFF, 0x90, 0xA0, 0x37, 0x50, 0x1F, 0xFB, 0x08, 0x74, 0x01,
  0xFF, 0xC0, 0x97, 0x30, 0x1F, 0xFD, 0x05, 0x73, 0x83, 0x33, 0x57, 0xBF, 0xF0, 0xE7, 0x71, 0x01,
  0x09, 0xFE, 0x04, 0x77, 0x20, 0x5F, 0xD0, 0x97, 0x73, 0x08, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xB0,
  0xD7, 0x74, 0x0A, 0xFB, 0x0E, 0x77, 0x40, 0x6F, 0xB0, 0xE7, 0x74, 0x05, 0xFB, 0x0E, 0x77, 0x40,
  0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E,
  0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04,
  0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7,
  0x74, 0x04, 0xFC, 0x77, 0x40, 0x4F, 0xC0, 0x27, 0x73, 0x04, 0xFC, 0x06, 0x77, 0x30, 0x3F, 0xC0,
  0xD7, 0x73, 0x02, 0xFD, 0x0C, 0x02, 0x77, 0x2F, 0xF8, 0x3B, 0x74, 0x32, 0x74, 0x0D, 0xFF, 0xB0,
  0xC7, 0x40, 0x9F, 0xFB, 0x0C, 0x74, 0x05, 0xFF, 0xB0, 0xC7, 0x50, 0xDF, 0xFA, 0x0C, 0x75, 0x05,
  0xFF, 0xA0, 0xC7, 0x60, 0x9F, 0xF9, 0x0C, 0x77, 0x09, 0xFF, 0x0C, 0x77, 0x10, 0x50, 0xDF, 0xD0,
  0xC7, 0x73, 0x81, 0x5A, 0xEF, 0xA0, 0xC7, 0x76, 0x89, 0x03, 0x68, 0xAB, 0xDE, 0xEF, 0xC0,
  // "|" (U+007C)
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  // "}" (U+007D)
  0x89, 0x11, 0xFE, 0xED, 0xCB, 0x97, 0x51, 0x77, 0x50, 0x1F, 0xB8, 0x1D, 0x82, 0x77, 0x20, 0x1F,
  0xE0, 0xA0, 0x27, 0x70, 0x1F, 0xF0, 0xE0, 0x47, 0x60, 0x1F, 0xFA, 0x04, 0x75, 0x01, 0xFF, 0xA0,
  0xE0, 0x17, 0x40, 0x1F, 0xFB, 0x08, 0x74, 0x01, 0xFF, 0xB0, 0xE7, 0x40, 0x1F, 0xFC, 0x04, 0x73,
  0x01, 0xFF, 0xC0, 0x87, 0x58, 0x21, 0x36, 0xBF, 0xE0, 0xA7, 0x72, 0x03, 0x0D, 0xFC, 0x0C, 0x77,
  0x30, 0x2F, 0xC0, 0xD7, 0x74, 0x0A, 0xFB, 0x0E, 0x77, 0x40, 0x6F, 0xB0, 0xE7, 0x74, 0x05, 0xFB,
  0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74,
  0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0,
  0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40,
  0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFC, 0x77, 0x40, 0x4F, 0xC0, 0x17, 0x73, 0x04, 0xFC, 0x04, 0x77,
  0x30, 0x3F, 0xC0, 0x87, 0x73, 0x01, 0xFD, 0x01, 0x77, 0x30, 0xEF, 0xC0, 0xC7, 0x73, 0x0A, 0xFD,
  0x0C, 0x03, 0x77, 0x10, 0x4F, 0xF8, 0x2C, 0x74, 0x17, 0x50, 0xCF, 0xFC, 0x0A, 0x73, 0x02, 0x0E,
  0xFF, 0xB0, 0xA7, 0x40, 0x30, 0xEF, 0xFA, 0x0A, 0x75, 0x81, 0x19, 0xEF, 0xF0, 0xA7, 0x71, 0x81,
  0x59, 0xDF, 0xC0, 0xA7, 0x71, 0x81, 0x26, 0xCF, 0xC0, 0xA7, 0x60, 0x60, 0xCF, 0xF0, 0xA7, 0x40,
  0x20, 0xCF, 0xFA, 0x0A, 0x73, 0x02, 0x0D, 0xFF, 0xB0, 0xA7, 0x30, 0xBF, 0xFC, 0x0A, 0x72, 0x04,
  0xFF, 0x84, 0xEA, 0x74, 0x31, 0x72, 0x0A, 0xFD, 0x0E, 0x06, 0x77, 0x10, 0xEF, 0xC0, 0xD0, 0x27,
  0x71, 0x02, 0xFD, 0x03, 0x77, 0x20, 0x3F, 0xC0, 0x97, 0x73, 0x04, 0xFC, 0x04, 0x77, 0x30, 0x4F,
  0xC0, 0x17, 0x73, 0x04, 0xFC, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40,
  0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E,
  0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04, 0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x04,
  0xFB, 0x0E, 0x77, 0x40, 0x4F, 0xB0, 0xE7, 0x74, 0x05, 0xFB, 0x0E, 0x77, 0x40, 0x7F, 0xB0, 0xE7,
  0x74, 0x0B, 0xFB, 0x0E, 0x77, 0x30, 0x3F, 0xC0, 0xD7, 0x72, 0x04, 0x0E, 0xFC, 0x0C, 0x74, 0x83,
  0x23, 0x58, 0xCF, 0xE0, 0xA7, 0x30, 0x1F, 0xFC, 0x07, 0x73, 0x01, 0xFF, 0xC0, 0x37, 0x30, 0x1F,
  0xFB, 0x0E, 0x74, 0x01, 0xFF, 0xB0, 0x77, 0x40, 0x1F, 0xFA, 0x0D, 0x01, 0x74, 0x01, 0xFF, 0xA0,
  0x37, 0x50, 0x1F, 0xF0, 0xE0, 0x47, 0x60, 0x1F, 0xE0, 0xA0, 0x17, 0x70, 0x1F, 0xB8, 0x1D, 0x82,
  0x77, 0x28, 0x91, 0x1F, 0xEE, 0xDC, 0xB9, 0x74, 0x17, 0x75,
  // "~" (U+007E)
  0x68, 0x23, 0x8B, 0xDA, 0x83, 0xED, 0xA7, 0x47, 0x77, 0x10, 0x60, 0x34, 0x05, 0x0C, 0xFC, 0x81,
  0xE9, 0x47, 0x74, 0x81, 0x7F, 0x32, 0x01, 0x0B, 0xFF, 0xA8, 0x1D, 0x71, 0x76, 0x01, 0x0A, 0xA8,
  0x23, 0x02, 0xDF, 0xFE, 0x0A, 0x04, 0x73, 0x05, 0x0E, 0xB8, 0x13, 0x1E, 0xFF, 0xFA, 0x83, 0xEA,
  0x63, 0x12, 0x81, 0x27, 0xDD, 0x03, 0x01, 0x80, 0xC3, 0xF0, 0x30, 0x18, 0x0C, 0x3F, 0x03, 0x01,
  0x80, 0xC3, 0xF0, 0x30, 0x18, 0x0C, 0x3F, 0x03, 0x01, 0x80, 0xC3, 0xF0, 0x30, 0x1D, 0x87, 0xEA,
  0x53, 0x23, 0x58, 0xBF, 0xFF, 0xC0, 0x20, 0x1C, 0x08, 0x01, 0x71, 0x81, 0x15, 0xBF, 0xFF, 0x81,
  0x50, 0x1A, 0x0C, 0x02, 0x76, 0x81, 0x28, 0xEF, 0xFA, 0x0D, 0x03, 0x28, 0x11, 0xFA, 0x77, 0x48,
  0x15, 0xAE, 0xFC, 0x0E, 0x07, 0x40, 0x10, 0x97, 0x77, 0x18, 0x34, 0x8A, 0xDE, 0xA8, 0x2E, 0xC9,
  0x56,
  // "¡" (U+00A1)
  0x48, 0x63, 0x9D, 0xEE, 0xD9, 0x37, 0x0A, 0xF9, 0x09, 0x50, 0xAF, 0xB0, 0x93, 0x04, 0xFD, 0x04,
  0x20, 0xBF, 0xD0, 0xB2, 0x0E, 0xFD, 0x81, 0xE0, 0x1F, 0xF0, 0x01, 0xFF, 0x02, 0x01, 0xFF, 0x81,
  0x10, 0xEF, 0xE2, 0x0B, 0xFD, 0x0B, 0x20, 0x5F, 0xD0, 0x53, 0x0B, 0xFB, 0x0B, 0x40, 0x10, 0xBF,
  0x90, 0xB0, 0x16, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x48, 0x09, 0xE2, 0x00, 0x2F, 0xA0, 0xE5, 0x03,
  0xFB, 0x50, 0x4F, 0xB5, 0x04, 0xFB, 0x01, 0x40, 0x5F, 0xB0, 0x24, 0x06, 0xFB, 0x02, 0x40, 0x7F,
  0xB0, 0x34, 0x07, 0xFB, 0x04, 0x40, 0x8F, 0xB0, 0x44, 0x09, 0xFB, 0x05, 0x40, 0x9F, 0xB0, 0x64,
  0x0A, 0xFB, 0x07, 0x40, 0xBF, 0xB0, 0x74, 0x0B, 0xFB, 0x08, 0x40, 0xCF, 0xB0, 0x94, 0x0D, 0xFB,
  0x0A, 0x40, 0xEF, 0xB0, 0xA4, 0x0E, 0xFB, 0x0B, 0x4F, 0xC0, 0xC4, 0xFC, 0x0C, 0x30, 0x1F, 0xC0,
  0xD3, 0x02, 0xFC, 0x0E, 0x30, 0x2F, 0xD3, 0x03, 0xFD, 0x30, 0x4F, 0xD0, 0x12, 0x04, 0xFD, 0x01,
  0x20, 0x5F, 0xD0, 0x22, 0x06, 0xFD, 0x03, 0x20, 0x6F, 0xD0, 0x32, 0x07, 0xFD, 0x04, 0x20, 0x8F,
  0xD0, 0x52, 0x09, 0xFD, 0x06, 0x20, 0x9F, 0xD0, 0x62, 0x0A, 0xFD, 0x07, 0x20, 0xBF, 0xD0, 0x82,
  0x0B, 0xFD, 0x09, 0x20, 0xCF, 0xD0, 0x92, 0x0D, 0xFD, 0x0A, 0x20, 0xDF, 0xD0, 0xB2, 0x0E, 0xFD,
  0x0B, 0x2F, 0xE0, 0xC2, 0xFE, 0x81, 0xD0, 0x1F, 0xE8, 0x1E, 0x01, 0xFE, 0x0E, 0x10,
  // "¢" (U+00A2)
  0x77, 0x20, 0x7E, 0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x75, 0x07,
  0xE0, 0x67, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x7E, 0x06, 0x77,
  0x73, 0x81, 0x48, 0xCF, 0x83, 0xED, 0xB8, 0x47, 0x72, 0x03, 0x0A, 0xFF, 0xA8, 0x1E, 0x93, 0x74,
  0x02, 0x0B, 0xFF, 0xF0, 0xB0, 0x37, 0x10, 0x50, 0xEF, 0xFF, 0xA0, 0xD7, 0x07, 0xFF, 0xFC, 0x08,
  0x60, 0x6F, 0xFF, 0xD0, 0x35, 0x04, 0xFF, 0xFD, 0x0D, 0x50, 0x10, 0xDF, 0xFF, 0xD0, 0x75, 0x08,
  0xFF, 0xFE, 0x02, 0x40, 0x2F, 0xFF, 0xE0, 0xC5, 0x09, 0xFF, 0x87, 0xD7, 0x43, 0x34, 0x7A, 0xEC,
  0x06, 0x50, 0xEF, 0xE0, 0x77, 0x20, 0x50, 0xBA, 0x01, 0x40, 0x5F, 0xE0, 0x57, 0x50, 0x30, 0x85,
  0x0A, 0xFD, 0x09, 0x77, 0x60, 0xEF, 0xC0, 0xE0, 0x17, 0x75, 0x03, 0xFD, 0x09, 0x77, 0x60, 0x6F,
  0xD0, 0x47, 0x76, 0x09, 0xFD, 0x77, 0x70, 0xBF, 0xC0, 0xC7, 0x77, 0x0D, 0xFC, 0x09, 0x77, 0x7F,
  0xD0, 0x77, 0x76, 0x01, 0xFD, 0x06, 0x77, 0x60, 0x2F, 0xD0, 0x57, 0x76, 0x03, 0xFD, 0x04, 0x77,
  0x60, 0x3F, 0xD0, 0x47, 0x76, 0x03, 0xFD, 0x04, 0x77, 0x60, 0x3F, 0xD0, 0x47, 0x76, 0x03, 0xFD,
  0x04, 0x77, 0x60, 0x2F, 0xD0, 0x57, 0x76, 0x01, 0xFD, 0x07, 0x77, 0x7F, 0xD0, 0x87, 0x77, 0x0D,
  0xFC, 0x0B, 0x77, 0x70, 0xCF, 0xC0, 0xD7, 0x77, 0x09, 0xFD, 0x02, 0x77, 0x60, 0x6F, 0xD0, 0x67,
  0x76, 0x03, 0xFD, 0x0C, 0x77, 0x70, 0xEF, 0xD0, 0x57, 0x72, 0x03, 0x30, 0xBF, 0xD0, 0xE0, 0x27,
  0x68, 0x13, 0xBD, 0x30, 0x5F, 0xE0, 0xD0, 0x37, 0x30, 0x50, 0xBA, 0x0D, 0x30, 0x10, 0xEF, 0xF8,
  0x1A, 0x42, 0x28, 0x32, 0x37, 0xAE, 0xC0, 0xD4, 0x09, 0xFF, 0xFF, 0x0D, 0x40, 0x2F, 0xFF, 0xF0,
  0xD5, 0x09, 0xFF, 0xFE, 0x0D, 0x50, 0x10, 0xDF, 0xFF, 0xD0, 0xD6, 0x04, 0xFF, 0xFD, 0x0D, 0x70,
  0x6F, 0xFF, 0xC0, 0xD7, 0x10, 0x6F, 0xFF, 0xB0, 0xD7, 0x20, 0x30, 0xDF, 0xFF, 0x0D, 0x05, 0x74,
  0x07, 0x0E, 0xFF, 0xB0, 0xD0, 0x77, 0x71, 0x81, 0x5A, 0xEF, 0xC8, 0x1D, 0x94, 0x77, 0x60, 0x20,
  0x9E, 0x81, 0xA5, 0x27, 0x77, 0x30, 0x7E, 0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x7E,
  0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77,
  0x50, 0x7E, 0x06, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x30,
  // "£" (U+00A3)
  0x77, 0x48, 0x34, 0x7B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77, 0x72, 0x81, 0x18, 0xEF, 0xF8,
  0x1C, 0x72, 0x77, 0x50, 0x70, 0xEF, 0xFD, 0x0B, 0x04, 0x77, 0x10, 0x10, 0xCF, 0xFF, 0xA0, 0xC7,
  0x60, 0x20, 0xDF, 0xFF, 0xB0, 0xB7, 0x50, 0x10, 0xDF, 0xFF, 0xC0, 0x57, 0x50, 0xAF, 0xFF, 0xC0,
  0xE7, 0x50, 0x4F, 0xFF, 0xD0, 0x97, 0x50, 0xCF, 0xFF, 0xD0, 0x47, 0x40, 0x3F, 0xFF, 0xD0, 0xD7,
  0x50, 0x8F, 0xE8, 0x6C, 0x63, 0x34, 0x69, 0xDD, 0x08, 0x75, 0x0C, 0xFD, 0x09, 0x71, 0x81, 0x38,
  0xEA, 0x02, 0x74, 0x01, 0xFD, 0x0C, 0x75, 0x06, 0x0A, 0x75, 0x03, 0xFD, 0x05, 0x77, 0x75, 0x06,
  0xFD, 0x01, 0x77, 0x75, 0x07, 0xFC, 0x0D, 0x77, 0x76, 0x09, 0xFC, 0x0B, 0x77, 0x76, 0x09, 0xFC,
  0x0B, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A,
  0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77,
  0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76,
  0x0A, 0xFC, 0x0A, 0x77, 0x60, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F,
  0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF,
  0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB, 0x08, 0x70, 0x3F, 0xFF, 0xFB,
  0x08, 0x77, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77,
  0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x0A, 0x77, 0x76,
  0x0A, 0xFC, 0x0A, 0x77, 0x76, 0x0A, 0xFC, 0x09, 0x77, 0x76, 0x0B, 0xFC, 0x08, 0x77, 0x76, 0x0D,
  0xFC, 0x05, 0x77, 0x76, 0xFD, 0x01, 0x77, 0x75, 0x05, 0xFC, 0x0B, 0x77, 0x76, 0x0B, 0xFC, 0x03,
  0x77, 0x75, 0x04, 0xFC, 0x09, 0x77, 0x75, 0x01, 0x0E, 0xFB, 0x0B, 0x77, 0x75, 0x02, 0x0D, 0xFB,
  0x0A, 0x77, 0x75, 0x04, 0x0E, 0xFA, 0x0E, 0x07, 0x77, 0x75, 0x0A, 0x80, 0xC1, 0xF0, 0x31, 0x80,
  0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80,
  0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x31, 0x80,
  0xC2, 0xF0, 0x31, 0x80, 0xC2, 0xF0, 0x30,
  // "¤" (U+00A4)
  0x50, 0x70, 0x97, 0x77, 0x70, 0xB0, 0x47, 0x20, 0x7A, 0x08, 0x77, 0x75, 0x0B, 0xA0, 0x47, 0x07,
  0xC0, 0x87, 0x77, 0x30, 0xBC, 0x05, 0x50, 0x8E, 0x08, 0x58, 0x91, 0x26, 0xAC, 0xEF, 0xED, 0xB8,
  0x46, 0x0B, 0xE0, 0x53, 0x08, 0xF9, 0x07, 0x20, 0x50, 0xBF, 0xC8, 0x1E, 0x81, 0x20, 0xAF, 0x98,
  0x16, 0x07, 0xFB, 0x08, 0x0B, 0xFF, 0x98, 0x1E, 0x7A, 0xFB, 0x81, 0x41, 0xD8, 0x0C, 0x2F, 0x0A,
  0x20, 0x10, 0xD8, 0x0C, 0x0F, 0x0A, 0x40, 0x10, 0xDF, 0xFF, 0xFE, 0x0A, 0x60, 0x10, 0xDF, 0xFF,
  0xFC, 0x0A, 0x71, 0x01, 0x0D, 0xFF, 0xFF, 0xA0, 0xA7, 0x30, 0x1F, 0xC8, 0x1A, 0x51, 0x28, 0x12,
  0x6B, 0xFB, 0x0E, 0x74, 0x07, 0xFA, 0x0C, 0x02, 0x71, 0x03, 0x0D, 0xFA, 0x05, 0x72, 0x01, 0x0E,
  0xF9, 0x09, 0x74, 0x01, 0x0B, 0xF9, 0x0D, 0x72, 0x06, 0xF9, 0x0A, 0x77, 0x0C, 0xF9, 0x04, 0x71,
  0x0C, 0xF0, 0xD0, 0x17, 0x70, 0x20, 0xEF, 0x09, 0x70, 0x1F, 0x90, 0x57, 0x72, 0x08, 0xF0, 0xD7,
  0x04, 0xF0, 0xE7, 0x73, 0x02, 0xF9, 0x01, 0x60, 0x7F, 0x0B, 0x77, 0x40, 0xDF, 0x03, 0x60, 0x8F,
  0x08, 0x77, 0x40, 0xAF, 0x04, 0x60, 0x9F, 0x07, 0x77, 0x40, 0xAF, 0x05, 0x60, 0x8F, 0x08, 0x77,
  0x40, 0xBF, 0x05, 0x60, 0x7F, 0x0A, 0x77, 0x40, 0xDF, 0x04, 0x60, 0x5F, 0x0E, 0x77, 0x30, 0x1F,
  0x90, 0x16, 0x02, 0xF9, 0x05, 0x77, 0x20, 0x7F, 0x0E, 0x71, 0x0D, 0xF0, 0xD7, 0x71, 0x01, 0x0E,
  0xF0, 0xA7, 0x10, 0x7F, 0x90, 0x97, 0x70, 0xBF, 0x90, 0x57, 0x10, 0x2F, 0xA0, 0x77, 0x50, 0xAF,
  0x90, 0xE7, 0x30, 0x9F, 0xA0, 0xA0, 0x17, 0x10, 0x30, 0xCF, 0xA0, 0x77, 0x30, 0x1F, 0xB8, 0x2E,
  0x94, 0x12, 0x81, 0x25, 0xAF, 0xB0, 0xE7, 0x40, 0xAF, 0xFF, 0xFA, 0x07, 0x72, 0x0B, 0xFF, 0xFF,
  0xC0, 0x77, 0x0B, 0xFF, 0xFF, 0xE0, 0x75, 0x0B, 0x80, 0xC0, 0xF0, 0x72, 0x01, 0x0C, 0x80, 0xC2,
  0xF8, 0x17, 0x06, 0xFB, 0x09, 0x0D, 0xFF, 0xA0, 0xA0, 0xCF, 0xB8, 0x11, 0x07, 0xF9, 0x07, 0x20,
  0x60, 0xCF, 0xD8, 0x3A, 0x30, 0x1C, 0xF9, 0x04, 0x30, 0x6E, 0x07, 0x58, 0x91, 0x27, 0xAD, 0xEF,
  0xED, 0xC9, 0x55, 0x01, 0x0C, 0xE0, 0x45, 0x06, 0xC0, 0x77, 0x77, 0x20, 0x10, 0xCC, 0x04, 0x70,
  0x6A, 0x07, 0x77, 0x74, 0x01, 0x0C, 0xA0, 0x47, 0x20, 0x60, 0x87, 0x77, 0x68, 0x11, 0xB4, 0x50,
  // "¥" (U+00A5)
  0x0C, 0xFD, 0x01, 0x77, 0x10, 0x4F, 0xD0, 0xB0, 0x6F, 0xD0, 0x77, 0x71, 0x09, 0xFD, 0x81, 0x40,
  0xEF, 0xC0, 0xC7, 0x71, 0x0E, 0xFC, 0x0D, 0x20, 0x9F, 0xD0, 0x17, 0x60, 0x4F, 0xD0, 0x72, 0x02,
  0xFD, 0x07, 0x76, 0x09, 0xFC, 0x0E, 0x01, 0x30, 0xBF, 0xC0, 0xC7, 0x60, 0xEF, 0xC0, 0x94, 0x05,
  0xFD, 0x01, 0x74, 0x04, 0xFD, 0x03, 0x50, 0xEF, 0xC0, 0x77, 0x40, 0x9F, 0xC0, 0xC6, 0x08, 0xFC,
  0x0C, 0x74, 0x0D, 0xFC, 0x05, 0x60, 0x1F, 0xD0, 0x27, 0x20, 0x3F, 0xC0, 0xE7, 0x10, 0xAF, 0xC0,
  0x77, 0x20, 0x8F, 0xC0, 0x87, 0x10, 0x4F, 0xC0, 0xC7, 0x20, 0xDF, 0xC0, 0x17, 0x20, 0xDF, 0xC0,
  0x27, 0x03, 0xFC, 0x0A, 0x73, 0x07, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x47, 0x30, 0x1F, 0xC0, 0xC7,
  0x0D, 0xFB, 0x0D, 0x75, 0x0A, 0xFC, 0x02, 0x50, 0x3F, 0xC0, 0x67, 0x50, 0x3F, 0xC0, 0x75, 0x08,
  0xFB, 0x0E, 0x77, 0x0C, 0xFB, 0x0C, 0x50, 0xDF, 0xB0, 0x97, 0x70, 0x6F, 0xC0, 0x23, 0x02, 0xFC,
  0x02, 0x77, 0x10, 0xEF, 0xB0, 0x73, 0x08, 0xFB, 0x0B, 0x77, 0x20, 0x9F, 0xB0, 0xC3, 0x0D, 0xFB,
  0x05, 0x77, 0x20, 0x2F, 0xC8, 0x12, 0x02, 0xFB, 0x0D, 0x77, 0x40, 0xCF, 0xB8, 0x17, 0x07, 0xFB,
  0x07, 0x77, 0x40, 0x5F, 0xB8, 0x1C, 0x0C, 0xFB, 0x01, 0x77, 0x50, 0xEF, 0xB0, 0x4F, 0xB0, 0xA7,
  0x76, 0x08, 0xFB, 0x0D, 0xFB, 0x03, 0x77, 0x60, 0x2F, 0xFE, 0x0C, 0x77, 0x71, 0x0B, 0xFF, 0xD0,
  0x67, 0x77, 0x10, 0x4F, 0xFC, 0x0E, 0x77, 0x73, 0x0D, 0xFF, 0xB0, 0x87, 0x77, 0x30, 0x7F, 0xFB,
  0x02, 0x77, 0x73, 0x01, 0xFF, 0xA0, 0xB7, 0x73, 0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10, 0x6F, 0xFF,
  0xFD, 0x03, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10, 0x6F, 0xFF, 0xFD, 0x03, 0x71, 0x06, 0xFF,
  0xFF, 0xD0, 0x37, 0x10, 0x6F, 0xFF, 0xFD, 0x03, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10, 0x6F,
  0xFF, 0xFD, 0x03, 0x77, 0x50, 0x9F, 0xC0, 0x87, 0x77, 0x72, 0x09, 0xFC, 0x08, 0x77, 0x77, 0x20,
  0x9F, 0xC0, 0x87, 0x77, 0x72, 0x09, 0xFC, 0x08, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87, 0x77, 0x72,
  0x09, 0xFC, 0x08, 0x77, 0x50, 0x6F, 0xFF, 0xFD, 0x03, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10,
  0x6F, 0xFF, 0xFD, 0x03, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10, 0x6F, 0xFF, 0xFD, 0x03, 0x71,
  0x06, 0xFF, 0xFF, 0xD0, 0x37, 0x10, 0x6F, 0xFF, 0xFD, 0x03, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x37,
  0x75, 0x09, 0xFC, 0x08, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87, 0x77, 0x72, 0x09, 0xFC, 0x08, 0x77,
  0x77, 0x20, 0x9F, 0xC0, 0x87, 0x77, 0x72, 0x09, 0xFC, 0x08, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87,
  0x77, 0x72, 0x09, 0xFC, 0x08, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87, 0x77, 0x72, 0x09, 0xFC, 0x08,
  0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87, 0x71,
  // "¦" (U+00A6)
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x80, 0xB8, 0x20, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA,
  0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09,
  0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08, 0x09, 0xFA, 0x08,
  // "§" (U+00A7)
  0x73, 0x89, 0x43, 0x6A, 0xCD, 0xEF, 0xED, 0xCA, 0x74, 0x17, 0x78, 0x12, 0x8D, 0xFF, 0x81, 0xC7,
  0x27, 0x30, 0x8F, 0xFE, 0x0C, 0x05, 0x60, 0x30, 0xDF, 0xFF, 0xA0, 0xD0, 0x23, 0x03, 0x0E, 0xFF,
  0xFB, 0x0E, 0x30, 0x20, 0xEF, 0xFF, 0xC0, 0x93, 0x0B, 0xFF, 0xFD, 0x03, 0x20, 0x4F, 0xFF, 0xD0,
  0xC3, 0x0A, 0xFB, 0x82, 0xE8, 0x31, 0x28, 0x12, 0x5A, 0xF0, 0x63, 0x0E, 0xFA, 0x0D, 0x01, 0x71,
  0x81, 0x17, 0xEC, 0x01, 0x20, 0x2F, 0xB0, 0x57, 0x58, 0x27, 0xEF, 0x93, 0x04, 0xFB, 0x01, 0x76,
  0x81, 0x1A, 0x33, 0x04, 0xFB, 0x01, 0x77, 0x50, 0x4F, 0xB0, 0x37, 0x75, 0x02, 0xFB, 0x0B, 0x77,
  0x60, 0xEF, 0xB0, 0x87, 0x75, 0x09, 0xFC, 0x0B, 0x02, 0x77, 0x30, 0x3F, 0xE0, 0x80, 0x17, 0x72,
  0x0B, 0xFE, 0x0E, 0x07, 0x77, 0x10, 0x20, 0xEF, 0xF0, 0xE0, 0x77, 0x70, 0x4F, 0xFA, 0x0E, 0x06,
  0x76, 0x05, 0xFF, 0xB0, 0xD0, 0x47, 0x50, 0x30, 0xEF, 0xFB, 0x09, 0x74, 0x08, 0xFF, 0xD0, 0xC0,
  0x27, 0x01, 0x0C, 0xFF, 0xF0, 0xE0, 0x35, 0x01, 0x0C, 0xFF, 0xFA, 0x0E, 0x02, 0x40, 0xBF, 0xA0,
  0xB0, 0xCF, 0xF0, 0xD0, 0x12, 0x06, 0xFA, 0x06, 0x20, 0x40, 0xCF, 0xE0, 0x82, 0x0E, 0xF9, 0x07,
  0x50, 0x50, 0xDF, 0xD0, 0x10, 0x5F, 0x90, 0xE7, 0x01, 0x0A, 0xFC, 0x06, 0x09, 0xF9, 0x0A, 0x72,
  0x08, 0xFB, 0x0A, 0x0C, 0xF9, 0x08, 0x73, 0x0A, 0xFA, 0x0D, 0x0E, 0xF9, 0x08, 0x73, 0x02, 0xFA,
  0x00, 0xEF, 0x90, 0xB7, 0x40, 0xCF, 0xA0, 0xDF, 0xA0, 0x27, 0x30, 0x9F, 0x90, 0xE0, 0xCF, 0xA0,
  0xB7, 0x30, 0x8F, 0x90, 0xD0, 0x9F, 0xB0, 0xA7, 0x20, 0xAF, 0x90, 0xB0, 0x5F, 0xC0, 0xC0, 0x27,
  0x0D, 0xF9, 0x81, 0x70, 0xEF, 0xD0, 0x75, 0x05, 0xFA, 0x81, 0x20, 0x8F, 0xE0, 0xD0, 0x52, 0x01,
  0x0D, 0xF9, 0x0B, 0x30, 0xDF, 0xF8, 0x1C, 0x5C, 0xFA, 0x03, 0x30, 0x20, 0xEF, 0xFF, 0xB0, 0x85,
  0x02, 0x0D, 0xFF, 0xF9, 0x0B, 0x70, 0x10, 0xBF, 0xFE, 0x0B, 0x73, 0x07, 0xFF, 0xC0, 0xB7, 0x50,
  0x20, 0xBF, 0xFB, 0x07, 0x76, 0x05, 0x0D, 0xFF, 0xA0, 0x77, 0x70, 0x50, 0xDF, 0xF9, 0x04, 0x77,
  0x10, 0x60, 0xDF, 0xE0, 0xE7, 0x73, 0x07, 0x0E, 0xFD, 0x07, 0x77, 0x30, 0x10, 0xAF, 0xC0, 0xD7,
  0x75, 0x07, 0xFC, 0x03, 0x77, 0x50, 0x8F, 0xB0, 0x67, 0x75, 0x01, 0xFB, 0x07, 0x77, 0x60, 0xDF,
  0xA0, 0x80, 0x17, 0x75, 0x0C, 0xFA, 0x82, 0x7D, 0x91, 0x77, 0x30, 0xEF, 0xA8, 0x46, 0xDF, 0xE8,
  0x27, 0x70, 0x6F, 0xB0, 0x30, 0xDC, 0x0B, 0x05, 0x74, 0x04, 0x0E, 0xFA, 0x81, 0xE0, 0xDF, 0x82,
  0xB7, 0x42, 0x38, 0x12, 0x5B, 0xFC, 0x81, 0x90, 0xDF, 0xFF, 0xF8, 0x12, 0x0D, 0xFF, 0xFE, 0x09,
  0x20, 0xDF, 0xFF, 0xD0, 0xC3, 0x0D, 0xFF, 0xFC, 0x0C, 0x01, 0x30, 0xBF, 0xFF, 0xB0, 0xA6, 0x05,
  0x0C, 0xFF, 0xE0, 0xD0, 0x47, 0x28, 0x14, 0x9E, 0xFF, 0x90, 0xB0, 0x57, 0x78, 0x95, 0x36, 0x8B,
  0xDD, 0xEF, 0xED, 0xCB, 0x84, 0x17, 0x30,
  // "¨" (U+00A8)
  0x38, 0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x64, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC3, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x98, 0x1A, 0x03, 0xFB, 0x04, 0x50,
  0x7F, 0xB0, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x70,
  0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x00, 0x7F, 0xB0, 0x85, 0x0C, 0xFB, 0x06, 0x04, 0xFB, 0x04, 0x50,
  0x8F, 0xB8, 0x12, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA2, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC0, 0x14, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x30,
  // "©" (U+00A9)
  0x77, 0x74, 0x89, 0x72, 0x58, 0xAC, 0xDE, 0xEF, 0xEE, 0xDB, 0x97, 0x41, 0x80, 0xD3, 0x08, 0x15,
  0xAD, 0xFF, 0xB8, 0x1C, 0x83, 0x80, 0xC5, 0x08, 0x13, 0xAE, 0xFF, 0xFA, 0x81, 0xD7, 0x18, 0x0C,
  0x00, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xFF, 0xD0, 0x87,
  0x77, 0x72, 0x08, 0x80, 0xC0, 0xF0, 0xE0, 0x57, 0x77, 0x50, 0x20, 0xCF, 0xC8, 0x5E, 0xB9, 0x63,
  0x21, 0x28, 0x51, 0x23, 0x58, 0xAE, 0xFD, 0x09, 0x77, 0x73, 0x05, 0xFB, 0x81, 0xEA, 0x57, 0x72,
  0x81, 0x38, 0xDF, 0xB0, 0xC0, 0x17, 0x77, 0x06, 0xFA, 0x0E, 0x07, 0x77, 0x71, 0x05, 0x0C, 0xFA,
  0x0D, 0x02, 0x77, 0x50, 0x8F, 0xA0, 0x77, 0x77, 0x50, 0x40, 0xDF, 0x90, 0xE0, 0x37, 0x73, 0x07,
  0xF9, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x9F, 0x90, 0xE0, 0x27, 0x71, 0x05, 0xF9, 0x08, 0x77, 0x77,
  0x40, 0x40, 0xEF, 0x0D, 0x01, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x20, 0xDF, 0x0B, 0x76,
  0x0D, 0xF0, 0x47, 0x68, 0x94, 0x36, 0xAC, 0xDE, 0xFE, 0xDC, 0xA8, 0x51, 0x72, 0x01, 0x0C, 0xF0,
  0x77, 0x40, 0x9F, 0x05, 0x74, 0x81, 0x17, 0xDF, 0xF8, 0x1C, 0x72, 0x70, 0x10, 0xDF, 0x03, 0x72,
  0x03, 0xF0, 0x77, 0x40, 0x7F, 0xFE, 0x0B, 0x04, 0x60, 0x20, 0xEE, 0x0C, 0x72, 0x0C, 0xE0, 0xA7,
  0x30, 0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x05, 0xF0, 0x67, 0x05, 0xE0, 0xE0, 0x17, 0x20, 0x30, 0xEF,
  0xFF, 0xA0, 0x57, 0x10, 0xAE, 0x0D, 0x70, 0xDE, 0x06, 0x72, 0x03, 0x0E, 0xFF, 0xFA, 0x0D, 0x72,
  0x01, 0x0E, 0xE0, 0x65, 0x05, 0xE0, 0xC7, 0x20, 0x10, 0xDF, 0xFF, 0xB0, 0x67, 0x30, 0x6E, 0x0D,
  0x50, 0xBE, 0x05, 0x72, 0x0A, 0xFB, 0x89, 0x1E, 0xA5, 0x21, 0x01, 0x25, 0x9E, 0xB0, 0xD7, 0x50,
  0xDE, 0x04, 0x30, 0x1E, 0x0D, 0x72, 0x05, 0xFB, 0x0A, 0x01, 0x73, 0x82, 0x4B, 0xF6, 0x75, 0x06,
  0xE0, 0x93, 0x07, 0xE0, 0x67, 0x20, 0xCF, 0xA0, 0x77, 0x70, 0x37, 0x70, 0xED, 0x0E, 0x30, 0xBE,
  0x01, 0x71, 0x04, 0xFA, 0x08, 0x77, 0x77, 0x20, 0xAE, 0x04, 0x2E, 0x0C, 0x72, 0x0A, 0xF9, 0x0C,
  0x77, 0x77, 0x30, 0x5E, 0x81, 0x80, 0x3E, 0x07, 0x72, 0x0E, 0xF9, 0x04, 0x77, 0x77, 0x4E, 0x81,
  0xB0, 0x7E, 0x03, 0x71, 0x04, 0xF9, 0x0E, 0x77, 0x77, 0x50, 0xCD, 0x81, 0xE0, 0x9E, 0x01, 0x71,
  0x07, 0xF9, 0x09, 0x77, 0x77, 0x50, 0x9E, 0x01, 0x0B, 0xD0, 0xD7, 0x20, 0xAF, 0x90, 0x57, 0x77,
  0x75, 0x07, 0xE0, 0x30, 0xDD, 0x0B, 0x72, 0x0C, 0xF9, 0x02, 0x77, 0x77, 0x50, 0x4E, 0x05, 0x0E,
  0xD0, 0xA7, 0x20, 0xEF, 0x97, 0x77, 0x76, 0x03, 0xE0, 0x6E, 0x09, 0x72, 0xFA, 0x77, 0x77, 0x60,
  0x2E, 0x07, 0xE0, 0x87, 0x2F, 0x90, 0xE7, 0x77, 0x76, 0x02, 0xE0, 0x8E, 0x08, 0x72, 0xF9, 0x0E,
  0x77, 0x77, 0x60, 0x1E, 0x08, 0xE0, 0x97, 0x2F, 0x90, 0xE7, 0x77, 0x76, 0x02, 0xE0, 0x70, 0xED,
  0x0A, 0x72, 0x0E, 0xF9, 0x77, 0x77, 0x60, 0x3E, 0x07, 0x0D, 0xD0, 0xB7, 0x20, 0xCF, 0x90, 0x17,
  0x77, 0x75, 0x04, 0xE0, 0x60, 0xBD, 0x0C, 0x72, 0x0A, 0xF9, 0x04, 0x77, 0x77, 0x50, 0x6E, 0x04,
  0x09, 0xE7, 0x20, 0x8F, 0x90, 0x77, 0x77, 0x75, 0x09, 0xE0, 0x20, 0x7E, 0x03, 0x71, 0x04, 0xF9,
  0x0C, 0x77, 0x77, 0x50, 0xBE, 0x10, 0x4E, 0x05, 0x72, 0xFA, 0x02, 0x77, 0x77, 0x40, 0xED, 0x81,
  0xC0, 0x1E, 0x0A, 0x72, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x30, 0x4E, 0x08, 0x20, 0xCD, 0x0E, 0x72,
  0x05, 0xFA, 0x04, 0x77, 0x77, 0x20, 0x9E, 0x04, 0x20, 0x8E, 0x04, 0x72, 0x0D, 0xF9, 0x0E, 0x04,
  0x77, 0x20, 0x27, 0x50, 0xDE, 0x01, 0x20, 0x3E, 0x0B, 0x72, 0x06, 0xFB, 0x07, 0x75, 0x82, 0x39,
  0xE7, 0x74, 0x04, 0xE0, 0xA4, 0x0D, 0xE0, 0x37, 0x20, 0xCF, 0xB8, 0x92, 0xE9, 0x42, 0x10, 0x12,
  0x47, 0xAE, 0xB0, 0x77, 0x40, 0xCE, 0x05, 0x40, 0x7E, 0x0A, 0x72, 0x02, 0x0E, 0xFF, 0xFB, 0x07,
  0x73, 0x04, 0xE0, 0xE5, 0x01, 0x0E, 0xE0, 0x37, 0x20, 0x4F, 0xFF, 0xB0, 0x77, 0x30, 0xCE, 0x07,
  0x60, 0x8E, 0x0D, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x72, 0x07, 0xE0, 0xE7, 0x01, 0x0E, 0xE0, 0x87,
  0x30, 0x30, 0xDF, 0xFF, 0x07, 0x71, 0x02, 0xF0, 0x77, 0x10, 0x7F, 0x05, 0x73, 0x01, 0x09, 0xFF,
  0xD0, 0xE0, 0x57, 0x10, 0xCE, 0x0D, 0x73, 0x0D, 0xF0, 0x37, 0x48, 0x12, 0x8E, 0xFF, 0x0B, 0x06,
  0x72, 0x0B, 0xF0, 0x47, 0x30, 0x3F, 0x0E, 0x02, 0x76, 0x89, 0x33, 0x7A, 0xCE, 0xEF, 0xEE, 0xDA,
  0x84, 0x74, 0x09, 0xF0, 0x97, 0x50, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x0A,
  0xF9, 0x06, 0x77, 0x77, 0x40, 0x10, 0xCF, 0x0E, 0x02, 0x77, 0x10, 0xCF, 0x90, 0xA0, 0x17, 0x77,
  0x71, 0x05, 0x0E, 0xF0, 0xE0, 0x37, 0x72, 0x01, 0x0D, 0xF9, 0x0E, 0x06, 0x77, 0x75, 0x02, 0x0B,
  0xF9, 0x0E, 0x04, 0x77, 0x40, 0x10, 0xCF, 0xA0, 0xE0, 0x77, 0x77, 0x10, 0x20, 0xAF, 0xA0, 0xE0,
  0x37, 0x77, 0x0B, 0xFB, 0x81, 0xEA, 0x57, 0x72, 0x81, 0x27, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x20,
  0x8F, 0xE8, 0x4B, 0x96, 0x32, 0x13, 0x84, 0x12, 0x47, 0x9C, 0xFD, 0x0A, 0x77, 0x75, 0x04, 0x0D,
  0x80, 0xC0, 0xF0, 0xE0, 0x57, 0x77, 0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x73, 0x01,
  0x09, 0xFF, 0xFF, 0xA0, 0x90, 0x27, 0x77, 0x77, 0x81, 0x17, 0xDF, 0xFF, 0xB8, 0x1D, 0x81, 0x80,
  0xC4, 0x08, 0x13, 0x8C, 0xFF, 0xC8, 0x1C, 0x83, 0x80, 0xD3, 0x08, 0x54, 0x79, 0xBD, 0xDE, 0xA8,
  0x5E, 0xDD, 0xB9, 0x74, 0x77, 0x75,
  // "ª" (U+00AA)
  0x71, 0x89, 0x23, 0x7A, 0xCD, 0xEF, 0xEC, 0x95, 0x17, 0x48, 0x14, 0x9E, 0xFC, 0x0E, 0x07, 0x71,
  0x06, 0x0D, 0xFF, 0xA0, 0xB0, 0x15, 0x0D, 0xFF, 0xD0, 0xC5, 0x0A, 0xFF, 0xE0, 0x84, 0x04, 0xFF,
  0xF0, 0x14, 0x0D, 0xFF, 0xE0, 0x84, 0x07, 0xC8, 0x6C, 0x73, 0x10, 0x15, 0xDF, 0x90, 0xC4, 0x01,
  0xA0, 0x90, 0x27, 0x10, 0xDF, 0x95, 0x05, 0x01, 0x73, 0x06, 0xF9, 0x03, 0x77, 0x20, 0x2F, 0x90,
  0x47, 0x72, 0x01, 0xF9, 0x05, 0x73, 0x85, 0x23, 0x45, 0x55, 0x6F, 0x90, 0x55, 0x82, 0x16, 0xAE,
  0xFF, 0xA0, 0x53, 0x02, 0x0A, 0xFF, 0xE0, 0x52, 0x05, 0x0E, 0xFF, 0xF8, 0x15, 0x04, 0xFF, 0xFA,
  0x81, 0x50, 0xEF, 0xD8, 0x1D, 0xCB, 0xF9, 0x00, 0x5F, 0xA8, 0x1C, 0x62, 0x30, 0x1F, 0x90, 0x50,
  0xAF, 0x90, 0x96, 0x01, 0xF9, 0x05, 0x0D, 0xF0, 0xD7, 0x02, 0xF9, 0x05, 0x0E, 0xF0, 0x97, 0x05,
  0xF9, 0x05, 0xF9, 0x08, 0x70, 0xAF, 0x90, 0x50, 0xEF, 0x0A, 0x60, 0x2F, 0xA0, 0x50, 0xCF, 0x0E,
  0x01, 0x40, 0x10, 0xDF, 0xA0, 0x50, 0x9F, 0x98, 0x4D, 0x52, 0x37, 0xEF, 0xB0, 0x50, 0x3F, 0xFF,
  0xB8, 0x15, 0x0C, 0xFF, 0x90, 0xA0, 0xCE, 0x81, 0x50, 0x3F, 0xF8, 0x1C, 0x07, 0xE0, 0x52, 0x06,
  0xFD, 0x82, 0xB1, 0x03, 0xE0, 0x53, 0x05, 0x0E, 0xF9, 0x0E, 0x07, 0x40, 0xDD, 0x05, 0x58, 0x16,
  0xBD, 0xA8, 0x2D, 0xB6, 0x15, 0x04, 0x80, 0x17, 0x02,
  // "«" (U+00AB)
  0x77, 0x81, 0x2B, 0x37, 0x74, 0x08, 0x07, 0x77, 0x71, 0x0C, 0xA0, 0xA0, 0x27, 0x71, 0x05, 0xA0,
  0xE0, 0x67, 0x75, 0x09, 0xD0, 0x90, 0x27, 0x50, 0x10, 0xEC, 0x0D, 0x05, 0x77, 0x20, 0x4F, 0x90,
  0x90, 0x17, 0x30, 0xCF, 0x0D, 0x05, 0x76, 0x01, 0x0E, 0xFA, 0x0E, 0x07, 0x71, 0x08, 0xFB, 0x0C,
  0x02, 0x74, 0x0B, 0xFC, 0x06, 0x70, 0x4F, 0xC0, 0xD7, 0x40, 0x7F, 0xC0, 0xB7, 0x01, 0x0E, 0xFC,
  0x04, 0x73, 0x03, 0xFC, 0x0E, 0x02, 0x70, 0xBF, 0xC0, 0x97, 0x30, 0x10, 0xDF, 0xC0, 0x67, 0x07,
  0xFC, 0x0E, 0x01, 0x73, 0x0A, 0xFC, 0x0C, 0x70, 0x3F, 0xD0, 0x57, 0x30, 0x6F, 0xD0, 0x27, 0x0D,
  0xFC, 0x0A, 0x73, 0x03, 0xFD, 0x07, 0x70, 0xAF, 0xC0, 0xE0, 0x17, 0x30, 0xDF, 0xC0, 0xC7, 0x06,
  0xFD, 0x06, 0x73, 0x09, 0xFD, 0x03, 0x60, 0x20, 0xEF, 0xC0, 0xB7, 0x30, 0x5F, 0xD0, 0x87, 0x0C,
  0xFD, 0x02, 0x72, 0x02, 0x0E, 0xFC, 0x0D, 0x70, 0x9F, 0xD0, 0x77, 0x30, 0xCF, 0xD0, 0x36, 0x05,
  0xFD, 0x0C, 0x73, 0x09, 0xFD, 0x09, 0x60, 0x10, 0xEF, 0xD0, 0x37, 0x20, 0x4F, 0xD0, 0xD7, 0x0C,
  0xFD, 0x08, 0x72, 0x01, 0x0E, 0xFD, 0x04, 0x60, 0x7F, 0xD0, 0xD7, 0x30, 0x3F, 0xD0, 0xE7, 0x0A,
  0xFD, 0x08, 0x74, 0x0C, 0xFD, 0x07, 0x60, 0x4F, 0xD0, 0xE0, 0x27, 0x30, 0x20, 0xEF, 0xD0, 0x26,
  0x08, 0xFD, 0x0B, 0x74, 0x05, 0xFD, 0x0C, 0x70, 0xCF, 0xD0, 0x67, 0x40, 0x9F, 0xD0, 0x76, 0x02,
  0x0E, 0xFC, 0x0E, 0x01, 0x74, 0x0D, 0xFD, 0x02, 0x60, 0x5F, 0xD0, 0xA7, 0x40, 0x2F, 0xD0, 0xB7,
  0x09, 0xFD, 0x05, 0x74, 0x06, 0xFD, 0x06, 0x70, 0xDF, 0xC0, 0xE0, 0x17, 0x40, 0xAF, 0xC0, 0xE0,
  0x16, 0x03, 0xFD, 0x09, 0x74, 0x01, 0x0D, 0xFC, 0x0B, 0x70, 0x6F, 0xD0, 0x47, 0x40, 0x3F, 0xD0,
  0x67, 0x0A, 0xFC, 0x0D, 0x75, 0x07, 0xFC, 0x0E, 0x01, 0x60, 0x10, 0xDF, 0xC0, 0x97, 0x50, 0xBF,
  0xC0, 0xA7, 0x03, 0xFD, 0x03, 0x74, 0x01, 0x0E, 0xFC, 0x05, 0x70, 0x7F, 0xC0, 0xD7, 0x50, 0x4F,
  0xC0, 0xE0, 0x17, 0x0B, 0xFC, 0x08, 0x75, 0x08, 0xFC, 0x0A, 0x70, 0x10, 0xEF, 0xC0, 0x27, 0x50,
  0xCF, 0xA0, 0xA0, 0x27, 0x10, 0x4F, 0xA0, 0xE0, 0x67, 0x60, 0x20, 0xEE, 0x0B, 0x03, 0x74, 0x08,
  0xE0, 0xE0, 0x77, 0x72, 0x05, 0xC0, 0xC0, 0x47, 0x70, 0xCC, 0x08, 0x01, 0x77, 0x48, 0x29, 0xFD,
  0x57, 0x72, 0x83, 0x2E, 0xF9, 0x17, 0x77, 0x06, 0x77, 0x50, 0x40, 0x27, 0x10,
  // "¬" (U+00AC)
  0x0B, 0x80, 0xC1, 0xF0, 0x90, 0xB8, 0x0C, 0x1F, 0x09, 0x0B, 0x80, 0xC1, 0xF0, 0x90, 0xB8, 0x0C,
  0x1F, 0x09, 0x0B, 0x80, 0xC1, 0xF0, 0x90, 0xB8, 0x0C, 0x1F, 0x09, 0x0B, 0x80, 0xC1, 0xF0, 0x90,
  0xB8, 0x0C, 0x1F, 0x09, 0x0B, 0x80, 0xC1, 0xF0, 0x90, 0xB8, 0x0C, 0x1F, 0x09, 0x77, 0x77, 0x02,
  0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA,
  0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09,
  0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77,
  0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77,
  0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x09, 0x77, 0x77, 0x02, 0xFA, 0x08,
  // "®" (U+00AE)
  0x77, 0x74, 0x89, 0x72, 0x58, 0xAC, 0xDE, 0xEF, 0xEE, 0xDB, 0x97, 0x41, 0x80, 0xD3, 0x08, 0x15,
  0xAD, 0xFF, 0xB8, 0x1C, 0x83, 0x80, 0xC5, 0x08, 0x13, 0xAE, 0xFF, 0xFA, 0x81, 0xD7, 0x18, 0x0C,
  0x00, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x74, 0x02, 0x0B, 0xFF, 0xFF, 0xD0, 0x87,
  0x77, 0x72, 0x08, 0x80, 0xC0, 0xF0, 0xE0, 0x57, 0x77, 0x50, 0x20, 0xCF, 0xC8, 0x5E, 0xB9, 0x63,
  0x21, 0x28, 0x51, 0x23, 0x58, 0xAE, 0xFD, 0x09, 0x77, 0x73, 0x05, 0xFB, 0x81, 0xEA, 0x57, 0x72,
  0x81, 0x38, 0xDF, 0xB0, 0xC0, 0x17, 0x77, 0x06, 0xFA, 0x0E, 0x07, 0x77, 0x71, 0x05, 0x0C, 0xFA,
  0x0D, 0x02, 0x77, 0x50, 0x8F, 0xA0, 0x77, 0x77, 0x50, 0x40, 0xDF, 0x90, 0xE0, 0x37, 0x73, 0x07,
  0xF9, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x9F, 0x90, 0xE0, 0x27, 0x71, 0x05, 0xF9, 0x08, 0x77, 0x77,
  0x40, 0x40, 0xEF, 0x0D, 0x01, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x20, 0xDF, 0x0B, 0x76,
  0x0D, 0xF0, 0x44, 0x01, 0xFE, 0x84, 0xED, 0xCA, 0x74, 0x75, 0x01, 0x0C, 0xF0, 0x77, 0x40, 0x9F,
  0x05, 0x50, 0x1F, 0xFD, 0x81, 0xE9, 0x27, 0x30, 0x10, 0xDF, 0x03, 0x72, 0x03, 0xF0, 0x76, 0x01,
  0xFF, 0xF9, 0x08, 0x73, 0x02, 0x0E, 0xE0, 0xC7, 0x20, 0xCE, 0x0A, 0x70, 0x1F, 0xFF, 0xA0, 0xC7,
  0x30, 0x5F, 0x06, 0x70, 0x5E, 0x0E, 0x01, 0x70, 0x1F, 0xFF, 0xB0, 0xB7, 0x30, 0xAE, 0x0D, 0x70,
  0xDE, 0x06, 0x71, 0x01, 0xFF, 0xFC, 0x06, 0x72, 0x01, 0x0E, 0xE0, 0x65, 0x05, 0xE0, 0xC7, 0x20,
  0x1F, 0xFF, 0xC0, 0xE7, 0x30, 0x6E, 0x0D, 0x50, 0xBE, 0x05, 0x72, 0x01, 0xF9, 0x09, 0x48, 0x21,
  0x48, 0xEF, 0xA0, 0x57, 0x30, 0xDE, 0x04, 0x30, 0x1E, 0x0D, 0x73, 0x01, 0xF9, 0x09, 0x70, 0x20,
  0xDF, 0x90, 0x97, 0x30, 0x6E, 0x09, 0x30, 0x7E, 0x06, 0x73, 0x01, 0xF9, 0x09, 0x71, 0x05, 0xF9,
  0x0C, 0x74, 0x0E, 0xD0, 0xE3, 0x0B, 0xE0, 0x17, 0x30, 0x1F, 0x90, 0x97, 0x2F, 0x90, 0xE7, 0x40,
  0xAE, 0x04, 0x2E, 0x0C, 0x74, 0x01, 0xF9, 0x09, 0x72, 0x0D, 0xF9, 0x74, 0x05, 0xE8, 0x18, 0x03,
  0xE0, 0x77, 0x40, 0x1F, 0x90, 0x97, 0x20, 0xCF, 0x97, 0x5E, 0x81, 0xB0, 0x7E, 0x03, 0x74, 0x01,
  0xF9, 0x09, 0x72, 0x0E, 0xF0, 0xE7, 0x50, 0xCD, 0x81, 0xE0, 0x9E, 0x01, 0x74, 0x01, 0xF9, 0x09,
  0x71, 0x02, 0xF9, 0x0B, 0x75, 0x09, 0xE0, 0x10, 0xBD, 0x0D, 0x75, 0x01, 0xF9, 0x09, 0x71, 0x09,
  0xF9, 0x08, 0x75, 0x07, 0xE0, 0x30, 0xDD, 0x0B, 0x75, 0x01, 0xF9, 0x09, 0x70, 0x7F, 0xA0, 0x37,
  0x50, 0x4E, 0x05, 0x0E, 0xD0, 0xA7, 0x50, 0x1F, 0x90, 0x94, 0x81, 0x26, 0xCF, 0xA0, 0xB7, 0x60,
  0x3E, 0x06, 0xE0, 0x97, 0x50, 0x1F, 0xFF, 0xC0, 0x27, 0x60, 0x2E, 0x07, 0xE0, 0x87, 0x50, 0x1F,
  0xFF, 0xB0, 0x57, 0x70, 0x2E, 0x08, 0xE0, 0x87, 0x50, 0x1F, 0xFF, 0x90, 0xE0, 0x57, 0x71, 0x01,
  0xE0, 0x8E, 0x09, 0x75, 0x01, 0xFF, 0xF0, 0xB0, 0x27, 0x72, 0x02, 0xE0, 0x70, 0xED, 0x0A, 0x75,
  0x01, 0xFF, 0xE0, 0xB7, 0x74, 0x03, 0xE0, 0x70, 0xDD, 0x0B, 0x75, 0x01, 0xFF, 0xF0, 0x37, 0x73,
  0x04, 0xE0, 0x60, 0xBD, 0x0C, 0x75, 0x01, 0xF9, 0x09, 0x40, 0xDF, 0x0C, 0x77, 0x30, 0x6E, 0x04,
  0x09, 0xE7, 0x50, 0x1F, 0x90, 0x94, 0x05, 0xF9, 0x05, 0x77, 0x20, 0x9E, 0x02, 0x07, 0xE0, 0x37,
  0x40, 0x1F, 0x90, 0x95, 0x0D, 0xF0, 0xD7, 0x72, 0x0B, 0xE1, 0x04, 0xE0, 0x57, 0x40, 0x1F, 0x90,
  0x95, 0x05, 0xF9, 0x07, 0x77, 0x10, 0xED, 0x81, 0xC0, 0x1E, 0x0A, 0x74, 0x01, 0xF9, 0x09, 0x60,
  0xDF, 0x0E, 0x01, 0x76, 0x04, 0xE0, 0x82, 0x0C, 0xD0, 0xE7, 0x40, 0x1F, 0x90, 0x96, 0x06, 0xF9,
  0x08, 0x76, 0x09, 0xE0, 0x42, 0x08, 0xE0, 0x47, 0x30, 0x1F, 0x90, 0x97, 0x0D, 0xF9, 0x02, 0x75,
  0x0D, 0xE0, 0x12, 0x03, 0xE0, 0xB7, 0x30, 0x1F, 0x90, 0x97, 0x06, 0xF9, 0x0A, 0x74, 0x04, 0xE0,
  0xA4, 0x0D, 0xE0, 0x37, 0x20, 0x1F, 0x90, 0x97, 0x10, 0xDF, 0x90, 0x37, 0x30, 0xCE, 0x05, 0x40,
  0x7E, 0x0A, 0x72, 0x01, 0xF9, 0x09, 0x71, 0x06, 0xF9, 0x0C, 0x72, 0x04, 0xE0, 0xE5, 0x01, 0x0E,
  0xE0, 0x37, 0x10, 0x1F, 0x90, 0x97, 0x20, 0xDF, 0x90, 0x57, 0x10, 0xCE, 0x07, 0x60, 0x8E, 0x0D,
  0x71, 0x01, 0xF9, 0x09, 0x72, 0x06, 0xF9, 0x0D, 0x70, 0x7E, 0x0E, 0x70, 0x10, 0xEE, 0x08, 0x70,
  0x1F, 0x90, 0x97, 0x30, 0xEF, 0x90, 0x75, 0x02, 0xF0, 0x77, 0x10, 0x7F, 0x05, 0x60, 0x1F, 0x90,
  0x97, 0x30, 0x7F, 0x90, 0xE0, 0x14, 0x0C, 0xE0, 0xD7, 0x30, 0xDF, 0x03, 0x68, 0x04, 0xC0, 0x77,
  0x48, 0x05, 0xC0, 0x63, 0x0B, 0xF0, 0x47, 0x30, 0x3F, 0x0E, 0x02, 0x80, 0xC1, 0x00, 0x9F, 0x09,
  0x75, 0x07, 0xF0, 0xE0, 0x47, 0x77, 0x77, 0x0B, 0xF0, 0xC7, 0x70, 0xAF, 0x90, 0x67, 0x77, 0x74,
  0x01, 0x0C, 0xF0, 0xE0, 0x27, 0x71, 0x0C, 0xF9, 0x0A, 0x01, 0x77, 0x77, 0x10, 0x50, 0xEF, 0x0E,
  0x03, 0x77, 0x20, 0x10, 0xDF, 0x90, 0xE0, 0x67, 0x77, 0x50, 0x20, 0xBF, 0x90, 0xE0, 0x47, 0x74,
  0x01, 0x0C, 0xFA, 0x0E, 0x07, 0x77, 0x71, 0x02, 0x0A, 0xFA, 0x0E, 0x03, 0x77, 0x70, 0xBF, 0xB8,
  0x1E, 0xA5, 0x77, 0x28, 0x12, 0x7C, 0xFB, 0x0D, 0x02, 0x77, 0x72, 0x08, 0xFE, 0x84, 0xB9, 0x63,
  0x21, 0x38, 0x41, 0x24, 0x79, 0xCF, 0xD0, 0xA7, 0x77, 0x50, 0x40, 0xD8, 0x0C, 0x0F, 0x0E, 0x05,
  0x77, 0x77, 0x10, 0x7F, 0xFF, 0xFE, 0x09, 0x01, 0x77, 0x77, 0x30, 0x10, 0x9F, 0xFF, 0xFA, 0x09,
  0x02, 0x77, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0xFB, 0x81, 0xD8, 0x18, 0x0C, 0x40, 0x81, 0x38, 0xCF,
  0xFC, 0x81, 0xC8, 0x38, 0x0D, 0x30, 0x85, 0x47, 0x9B, 0xDD, 0xEA, 0x85, 0xED, 0xDB, 0x97, 0x47,
  0x77, 0x50,
  // "¯" (U+00AF)
  0x02, 0x80, 0xC7, 0xF0, 0x70, 0x28, 0x0C, 0x7F, 0x07, 0x02, 0x80, 0xC7, 0xF0, 0x70, 0x28, 0x0C,
  0x7F, 0x07, 0x02, 0x80, 0xC7, 0xF0, 0x70, 0x28, 0x0C, 0x7F, 0x07, 0x02, 0x80, 0xC7, 0xF0, 0x70,
  0x28, 0x0C, 0x7F, 0x07, 0x02, 0x80, 0xC7, 0xF0, 0x70,
  // "°" (U+00B0)
  0x72, 0x82, 0x59, 0xCE, 0xA8, 0x3D, 0xCA, 0x51, 0x77, 0x18, 0x11, 0x9E, 0xFC, 0x0A, 0x03, 0x75,
  0x06, 0x0E, 0xFF, 0x90, 0x97, 0x30, 0xAF, 0xFC, 0x0C, 0x01, 0x70, 0xAF, 0xFE, 0x0D, 0x01, 0x50,
  0x7F, 0xFF, 0x90, 0xB4, 0x02, 0xFF, 0xFB, 0x06, 0x30, 0xBF, 0x98, 0x1E, 0x72, 0x28, 0x12, 0x6D,
  0xF9, 0x0E, 0x20, 0x2F, 0x90, 0xC0, 0x17, 0x09, 0xF9, 0x81, 0x60, 0x7F, 0x0E, 0x01, 0x72, 0x0B,
  0xF8, 0x1B, 0x0B, 0xF0, 0x67, 0x30, 0x2F, 0x91, 0x0D, 0xF0, 0x17, 0x40, 0xCF, 0x02, 0xF0, 0xD7,
  0x50, 0x9F, 0x03, 0xF0, 0xC7, 0x50, 0x8F, 0x04, 0xF0, 0xD7, 0x50, 0x9F, 0x03, 0x0D, 0xF0, 0x17,
  0x40, 0xCF, 0x02, 0x0B, 0xF0, 0x57, 0x30, 0x1F, 0x91, 0x07, 0xF0, 0xD0, 0x17, 0x20, 0xAF, 0x81,
  0xB0, 0x2F, 0x90, 0xB0, 0x17, 0x08, 0xF9, 0x06, 0x20, 0xBF, 0x98, 0x1E, 0x72, 0x28, 0x12, 0x6C,
  0xF9, 0x0E, 0x30, 0x2F, 0xFF, 0xB0, 0x74, 0x07, 0xFF, 0xF9, 0x0B, 0x60, 0xAF, 0xFE, 0x0D, 0x01,
  0x70, 0xAF, 0xFC, 0x0C, 0x01, 0x72, 0x06, 0x0E, 0xFF, 0x90, 0x97, 0x58, 0x11, 0x9E, 0xFC, 0x0A,
  0x03, 0x77, 0x28, 0x25, 0x9C, 0xEA, 0x83, 0xEC, 0xA6, 0x17, 0x20,
  // "±" (U+00B1)
  0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77,
  0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02,
  0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA,
  0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07,
  0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77,
  0x77, 0x02, 0xFA, 0x07, 0x77, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80,
  0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E,
  0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C,
  0x1F, 0x0E, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07,
  0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77,
  0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77,
  0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02,
  0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x02, 0xFA,
  0x07, 0x80, 0xAC, 0x60, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1,
  0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B,
  0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F,
  0x0E,
  // "²" (U+00B2)
  0x78, 0x91, 0x26, 0xAC, 0xEF, 0xED, 0xC9, 0x57, 0x60, 0x40, 0xBF, 0xC0, 0xE0, 0x87, 0x20, 0x20,
  0xBF, 0xF9, 0x0D, 0x03, 0x60, 0x6F, 0xFC, 0x0E, 0x03, 0x40, 0x9F, 0xFE, 0x0E, 0x01, 0x20, 0x8F,
  0xFF, 0x90, 0x92, 0x05, 0xFF, 0xFA, 0x02, 0x20, 0x9F, 0xFF, 0x90, 0x63, 0x0C, 0xD8, 0x5D, 0x62,
  0x02, 0x6E, 0xFA, 0x0A, 0x30, 0x2C, 0x08, 0x60, 0x2F, 0xA0, 0xC4, 0x06, 0xA0, 0x57, 0x10, 0x9F,
  0x90, 0xD5, 0x0A, 0x04, 0x72, 0x07, 0xF9, 0x0D, 0x77, 0x20, 0x7F, 0x90, 0xC7, 0x72, 0x0A, 0xF9,
  0x0A, 0x77, 0x20, 0xEF, 0x90, 0x77, 0x71, 0x05, 0xFA, 0x02, 0x77, 0x10, 0xDF, 0x90, 0xC7, 0x71,
  0x08, 0xFA, 0x05, 0x77, 0x04, 0xFA, 0x0B, 0x77, 0x02, 0x0E, 0xFA, 0x02, 0x77, 0x0C, 0xFA, 0x07,
  0x77, 0x0A, 0xFA, 0x0A, 0x77, 0x08, 0xFA, 0x0C, 0x77, 0x07, 0xFA, 0x0E, 0x01, 0x76, 0x05, 0xFA,
  0x0E, 0x03, 0x76, 0x04, 0xFB, 0x04, 0x76, 0x03, 0x0E, 0xFA, 0x05, 0x76, 0x02, 0x0E, 0xFA, 0x06,
  0x76, 0x01, 0x0D, 0xFA, 0x07, 0x77, 0x0C, 0xFA, 0x07, 0x77, 0x0B, 0xFA, 0x08, 0x77, 0x09, 0xFA,
  0x09, 0x77, 0x06, 0xFF, 0xFB, 0x0E, 0x07, 0xFF, 0xFB, 0x0E, 0x07, 0xFF, 0xFB, 0x0E, 0x07, 0xFF,
  0xFB, 0x0E, 0x07, 0xFF, 0xFB, 0x0E, 0x07, 0xFF, 0xFB, 0x0E, 0x07, 0xFF, 0xFB, 0x0E, 0x07, 0xFF,
  0xFB, 0x0E,
  // "³" (U+00B3)
  0x78, 0x91, 0x26, 0xAC, 0xEF, 0xED, 0xC8, 0x57, 0x60, 0x40, 0xBF, 0xC0, 0xE0, 0x87, 0x20, 0x20,
  0xBF, 0xF9, 0x0D, 0x04, 0x60, 0x6F, 0xFD, 0x05, 0x40, 0xAF, 0xFF, 0x02, 0x20, 0x5F, 0xFF, 0x90,
  0xC3, 0x0B, 0xFF, 0xF9, 0x02, 0x20, 0x10, 0xEF, 0xFF, 0x07, 0x30, 0x5D, 0x81, 0xA5, 0x22, 0x03,
  0x0A, 0xFA, 0x09, 0x40, 0xAA, 0x09, 0x02, 0x70, 0x9F, 0x90, 0xA4, 0x81, 0x1C, 0x47, 0x20, 0x1F,
  0x90, 0xA7, 0x73, 0x0E, 0xF0, 0x87, 0x73, 0xF9, 0x05, 0x77, 0x20, 0x5F, 0x0E, 0x77, 0x20, 0x20,
  0xDF, 0x08, 0x76, 0x82, 0x14, 0x8E, 0xF0, 0xC7, 0x20, 0x8F, 0xF0, 0xD0, 0x17, 0x20, 0x8F, 0xE0,
  0x90, 0x17, 0x30, 0x8F, 0xC0, 0xB0, 0x37, 0x50, 0x8F, 0xC0, 0xC0, 0x57, 0x50, 0x8F, 0xE0, 0xE0,
  0x67, 0x30, 0x8F, 0xF9, 0x0B, 0x72, 0x08, 0xFF, 0xA0, 0xC7, 0x78, 0x12, 0x5B, 0xFA, 0x07, 0x77,
  0x20, 0x5F, 0x90, 0xE7, 0x73, 0x08, 0xF9, 0x05, 0x77, 0x20, 0x2F, 0x90, 0x97, 0x73, 0xF9, 0x0B,
  0x01, 0x77, 0x10, 0x1F, 0x98, 0x2C, 0x4D, 0x47, 0x60, 0x5F, 0x90, 0xB0, 0x4A, 0x0C, 0x05, 0x73,
  0x01, 0x0D, 0xF9, 0x09, 0x04, 0xC8, 0x91, 0xEA, 0x73, 0x21, 0x01, 0x37, 0xEF, 0xA0, 0x70, 0x4F,
  0xFF, 0xB0, 0x20, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0x20, 0x4F, 0xFF, 0x90, 0x72,
  0x04, 0xFF, 0xF0, 0x74, 0x06, 0x0E, 0xFF, 0xB0, 0xD0, 0x47, 0x06, 0x0C, 0xFE, 0x0D, 0x07, 0x74,
  0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xC9, 0x63, 0x71,
  // "´" (U+00B4)
  0x71, 0x06, 0xFE, 0x0B, 0x71, 0x0E, 0xFE, 0x03, 0x70, 0x8F, 0xE0, 0x57, 0x02, 0xFE, 0x06, 0x71,
  0x0B, 0xFD, 0x06, 0x71, 0x05, 0xFD, 0x06, 0x71, 0x01, 0x0E, 0xFC, 0x06, 0x72, 0x0A, 0xFC, 0x05,
  0x72, 0x06, 0xFC, 0x05, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x73, 0x0B, 0xFA, 0x0E, 0x03, 0x73,
  0x07, 0xFA, 0x0D, 0x02, 0x73, 0x02, 0xFA, 0x0C, 0x01, 0x74, 0x06, 0xF9, 0x0A, 0x76,
  // "µ" (U+00B5)
  0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC,
  0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76,
  0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC,
  0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06,
  0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C,
  0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07,
  0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B,
  0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC,
  0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76,
  0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC,
  0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x08, 0xFC, 0x0B, 0x06,
  0xFC, 0x0C, 0x76, 0x08, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x09, 0xFC, 0x0B, 0x06, 0xFC, 0x0C,
  0x76, 0x09, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x0B, 0xFC, 0x0B, 0x06, 0xFC, 0x0C, 0x76, 0x0C,
  0xFC, 0x0B, 0x06, 0xFC, 0x0D, 0x76, 0x0E, 0xFC, 0x0B, 0x06, 0xFC, 0x0D, 0x75, 0x01, 0xFD, 0x0B,
  0x06, 0xFD, 0x75, 0x04, 0xFD, 0x0B, 0x06, 0xFD, 0x01, 0x74, 0x07, 0xFD, 0x0B, 0x06, 0xFD, 0x04,
  0x74, 0x0C, 0xFD, 0x0B, 0x06, 0xFD, 0x08, 0x73, 0x01, 0xFE, 0x0B, 0x06, 0xFD, 0x0D, 0x73, 0x08,
  0xFE, 0x0B, 0x06, 0xFE, 0x06, 0x71, 0x03, 0xFF, 0x0B, 0x06, 0xFE, 0x0E, 0x03, 0x60, 0x40, 0xEF,
  0xF0, 0xB0, 0x6F, 0xF8, 0x5E, 0x84, 0x23, 0x6B, 0xFF, 0xA0, 0xB0, 0x68, 0x0C, 0x1F, 0x0B, 0x06,
  0x80, 0xC1, 0xF0, 0xB0, 0x68, 0x0C, 0x1F, 0x0B, 0x06, 0xFF, 0xFC, 0x0E, 0x02, 0xFB, 0x0B, 0x06,
  0xFF, 0xFC, 0x81, 0x80, 0xDF, 0xA0, 0xB0, 0x6F, 0xFF, 0xB8, 0x2E, 0x10, 0x9F, 0xA0, 0xB0, 0x6F,
  0xC0, 0x80, 0xEF, 0xC0, 0x42, 0x05, 0xFA, 0x0B, 0x06, 0xFC, 0x07, 0x06, 0xFB, 0x07, 0x30, 0x1F,
  0xA0, 0xB0, 0x6F, 0xC8, 0x18, 0x06, 0xF0, 0xE0, 0x65, 0x0C, 0xF9, 0x0B, 0x06, 0xFC, 0x09, 0x28,
  0x62, 0x9D, 0xEE, 0xC7, 0x17, 0x72, 0x06, 0xFC, 0x0A, 0x77, 0x75, 0x06, 0xFC, 0x0A, 0x77, 0x75,
  0x06, 0xFC, 0x0B, 0x77, 0x75, 0x06, 0xFC, 0x0B, 0x77, 0x75, 0x06, 0xFC, 0x0B, 0x77, 0x75, 0x06,
  0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC,
  0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C,
  0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77,
  0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75,
  0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75, 0x06, 0xFC, 0x0C, 0x77, 0x75,
  // "¶" (U+00B6)
  0x73, 0x83, 0x26, 0xAC, 0xEF, 0xFF, 0xA0, 0xE7, 0x10, 0x40, 0xBF, 0xFF, 0xF0, 0xE6, 0x01, 0x0A,
  0xFF, 0xFF, 0xA0, 0xE5, 0x02, 0x0D, 0xFF, 0xFF, 0xB0, 0xE4, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0xE4,
  0x0C, 0xFF, 0xFF, 0xD0, 0xE3, 0x07, 0xFF, 0xFF, 0xE0, 0xE2, 0x01, 0x0E, 0xFF, 0xF9, 0x01, 0x50,
  0xED, 0x0E, 0x20, 0x7F, 0xFF, 0xA0, 0x15, 0x0E, 0xD0, 0xE2, 0x0D, 0xFF, 0xFA, 0x01, 0x50, 0xED,
  0x81, 0xE0, 0x3F, 0xFF, 0xB0, 0x15, 0x0E, 0xD8, 0x1E, 0x08, 0xFF, 0xFB, 0x01, 0x50, 0xED, 0x81,
  0xE0, 0xCF, 0xFF, 0xB0, 0x15, 0x0E, 0xD0, 0xE1, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x02, 0xFF,
  0xFC, 0x01, 0x50, 0xED, 0x0E, 0x04, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x06, 0xFF, 0xFC, 0x01,
  0x50, 0xED, 0x0E, 0x08, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x09, 0xFF, 0xFC, 0x01, 0x50, 0xED,
  0x0E, 0x0A, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x0B, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x0B,
  0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x0B, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x0B, 0xFF, 0xFC,
  0x01, 0x50, 0xED, 0x0E, 0x0B, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x0A, 0xFF, 0xFC, 0x01, 0x50,
  0xED, 0x0E, 0x09, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x08, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E,
  0x07, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x05, 0xFF, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x03, 0xFF,
  0xFC, 0x01, 0x50, 0xED, 0x0E, 0x1F, 0xFF, 0xC0, 0x15, 0x0E, 0xD8, 0x1E, 0x0C, 0xFF, 0xFB, 0x01,
  0x50, 0xED, 0x81, 0xE0, 0x8F, 0xFF, 0xB0, 0x15, 0x0E, 0xD8, 0x1E, 0x04, 0xFF, 0xFB, 0x01, 0x50,
  0xED, 0x0E, 0x20, 0xEF, 0xFF, 0xA0, 0x15, 0x0E, 0xD0, 0xE2, 0x08, 0xFF, 0xFA, 0x01, 0x50, 0xED,
  0x0E, 0x20, 0x1F, 0xFF, 0xA0, 0x15, 0x0E, 0xD0, 0xE3, 0x07, 0xFF, 0xF9, 0x01, 0x50, 0xED, 0x0E,
  0x40, 0xCF, 0xFF, 0x01, 0x50, 0xED, 0x0E, 0x40, 0x20, 0xDF, 0xFE, 0x01, 0x50, 0xED, 0x0E, 0x50,
  0x20, 0xDF, 0xFD, 0x01, 0x50, 0xED, 0x0E, 0x70, 0x9F, 0xFC, 0x01, 0x50, 0xED, 0x0E, 0x71, 0x81,
  0x28, 0xDF, 0x00, 0xDE, 0x01, 0x50, 0xED, 0x0E, 0x74, 0x87, 0x14, 0x56, 0x54, 0x10, 0xAE, 0x01,
  0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED,
  0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77,
  0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE,
  0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50,
  0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E,
  0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50,
  0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01,
  0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED,
  0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77,
  0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE,
  0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50,
  0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E,
  0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50,
  0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01,
  0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED, 0x0E, 0x77, 0x50, 0xAE, 0x01, 0x50, 0xED,
  0x0E, 0x77, 0x50, 0x58, 0x02, 0x76, 0x06, 0x80, 0x27,
  // "·" (U+00B7)
  0x48, 0x64, 0xAD, 0xEE, 0xD9, 0x35, 0x01, 0x0B, 0xF9, 0x0A, 0x40, 0xCF, 0xB0, 0xA2, 0x06, 0xFD,
  0x81, 0x40, 0xCF, 0xD0, 0xA0, 0x1F, 0xE0, 0xE0, 0x2F, 0xF0, 0x3F, 0xF0, 0x2F, 0xF1, 0xFE, 0x81,
  0xD0, 0xCF, 0xD8, 0x19, 0x05, 0xFD, 0x03, 0x20, 0xBF, 0xB0, 0x84, 0x0A, 0xF9, 0x08, 0x68, 0x64,
  0x9D, 0xFE, 0xD9, 0x33,
  // "¸" (U+00B8)
  0x50, 0x18, 0x02, 0x70, 0x47, 0x40, 0x8E, 0x03, 0x74, 0x0E, 0xD0, 0xC7, 0x40, 0x6E, 0x05, 0x74,
  0x0D, 0xE8, 0x1E, 0xA4, 0x71, 0x04, 0xFB, 0x0C, 0x03, 0x60, 0xBF, 0xD0, 0x64, 0x01, 0x0D, 0xFE,
  0x05, 0x68, 0x13, 0x8E, 0xFA, 0x0E, 0x71, 0x01, 0x0C, 0xFA, 0x06, 0x71, 0x01, 0xFA, 0x0A, 0x72,
  0x0B, 0xF9, 0x0C, 0x72, 0x0C, 0xF9, 0x0C, 0x71, 0x02, 0xFA, 0x89, 0x0A, 0x67, 0x42, 0x10, 0x15,
  0xDF, 0xA0, 0x80, 0x9F, 0xFB, 0x04, 0x09, 0xFF, 0xA8, 0x1D, 0x09, 0xFF, 0xA8, 0x16, 0x09, 0xFF,
  0x90, 0x92, 0x09, 0xFF, 0x09, 0x30, 0x9F, 0xD0, 0xC0, 0x54, 0x84, 0x27, 0xAC, 0xEE, 0xA8, 0x3E,
  0xDA, 0x73, 0x60,
  // "¹" (U+00B9)
  0x75, 0x09, 0xF0, 0x67, 0x30, 0x10, 0xBF, 0x90, 0x67, 0x20, 0x20, 0xDF, 0xA0, 0x67, 0x10, 0x30,
  0xEF, 0xB0, 0x67, 0x05, 0xFD, 0x06, 0x60, 0x8F, 0xE0, 0x65, 0x0A, 0xFF, 0x06, 0x30, 0x10, 0xCF,
  0xF9, 0x06, 0x20, 0x20, 0xDF, 0xFA, 0x82, 0x60, 0x4E, 0xFF, 0xB0, 0x60, 0x5F, 0xFD, 0x81, 0x62,
  0xEF, 0x90, 0x0A, 0xF9, 0x81, 0x60, 0x4F, 0x81, 0x90, 0xBF, 0x90, 0x62, 0x08, 0xD0, 0x52, 0x0B,
  0xF9, 0x06, 0x30, 0xBA, 0x0D, 0x03, 0x30, 0xCF, 0x90, 0x63, 0x82, 0x1D, 0xB1, 0x40, 0xCF, 0x90,
  0x64, 0x02, 0x60, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF,
  0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF,
  0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF,
  0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF,
  0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF,
  0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x67, 0x40, 0xDF, 0x90, 0x60,
  // "º" (U+00BA)
  0x71, 0x83, 0x16, 0xAC, 0xEA, 0x82, 0xDB, 0x72, 0x77, 0x01, 0x09, 0xFC, 0x0B, 0x03, 0x74, 0x04,
  0x0E, 0xFF, 0x07, 0x72, 0x06, 0xFF, 0xB0, 0x97, 0x04, 0xFF, 0xD0, 0x85, 0x01, 0x0D, 0xFF, 0xE0,
  0x34, 0x09, 0xFF, 0xF0, 0xD3, 0x01, 0xFA, 0x83, 0xA3, 0x01, 0x7F, 0xA0, 0x52, 0x07, 0xF9, 0x09,
  0x50, 0x4F, 0x90, 0xC2, 0x0C, 0xF0, 0xE7, 0x0A, 0xF9, 0x01, 0x1F, 0x90, 0x97, 0x04, 0xF9, 0x05,
  0x03, 0xF9, 0x05, 0x71, 0xF9, 0x08, 0x06, 0xF9, 0x02, 0x71, 0x0C, 0xF0, 0xB0, 0x7F, 0x97, 0x20,
  0xAF, 0x0C, 0x08, 0xF0, 0xE7, 0x20, 0x9F, 0x0D, 0x09, 0xF0, 0xE7, 0x20, 0x9F, 0x0E, 0x09, 0xF0,
  0xE7, 0x20, 0x9F, 0x0E, 0x08, 0xF0, 0xE7, 0x20, 0x9F, 0x0D, 0x07, 0xF9, 0x72, 0x0A, 0xF0, 0xC0,
  0x6F, 0x90, 0x27, 0x10, 0xCF, 0x0B, 0x03, 0xF9, 0x04, 0x71, 0xF9, 0x08, 0x1F, 0x90, 0x87, 0x04,
  0xF9, 0x81, 0x50, 0xBF, 0x0E, 0x70, 0xAF, 0x98, 0x11, 0x06, 0xF9, 0x09, 0x50, 0x4F, 0x90, 0xB3,
  0x0E, 0xF9, 0x83, 0xA2, 0x01, 0x7F, 0xA0, 0x53, 0x07, 0xFF, 0xF0, 0xD5, 0x0C, 0xFF, 0xE0, 0x45,
  0x03, 0xFF, 0xD0, 0x97, 0x04, 0xFF, 0xB0, 0xB7, 0x20, 0x30, 0xEF, 0xF0, 0x97, 0x40, 0x10, 0x9F,
  0xC0, 0xC0, 0x47, 0x78, 0x31, 0x6A, 0xDE, 0xA8, 0x2D, 0xB8, 0x37, 0x10,
  // "»" (U+00BB)
  0x78, 0x13, 0xB2, 0x77, 0x38, 0x11, 0x87, 0x77, 0x50, 0x20, 0xAA, 0x0C, 0x77, 0x20, 0x70, 0xEA,
  0x04, 0x77, 0x20, 0x20, 0xAD, 0x08, 0x76, 0x06, 0x0E, 0xC0, 0xD0, 0x17, 0x60, 0x10, 0x9F, 0x90,
  0x47, 0x30, 0x50, 0xDF, 0x0B, 0x75, 0x07, 0x0E, 0xFA, 0x0E, 0x01, 0x70, 0x30, 0xCF, 0xB0, 0x77,
  0x40, 0x6F, 0xC0, 0xB7, 0x01, 0x0E, 0xFC, 0x03, 0x74, 0x0B, 0xFC, 0x07, 0x70, 0x5F, 0xC0, 0xD7,
  0x40, 0x2F, 0xD0, 0x37, 0x0A, 0xFC, 0x0A, 0x74, 0x07, 0xFC, 0x0D, 0x01, 0x60, 0x10, 0xEF, 0xC0,
  0x67, 0x40, 0xCF, 0xC0, 0xA7, 0x06, 0xFC, 0x0E, 0x02, 0x73, 0x03, 0xFD, 0x06, 0x70, 0xBF, 0xC0,
  0xC7, 0x40, 0x8F, 0xD0, 0x26, 0x02, 0x0E, 0xFC, 0x09, 0x74, 0x0D, 0xFC, 0x0D, 0x70, 0x6F, 0xD0,
  0x57, 0x30, 0x4F, 0xD0, 0x97, 0x0C, 0xFC, 0x0E, 0x01, 0x73, 0x09, 0xFD, 0x05, 0x60, 0x2F, 0xD0,
  0xC7, 0x30, 0x10, 0xEF, 0xC0, 0xE0, 0x26, 0x07, 0xFD, 0x08, 0x73, 0x05, 0xFD, 0x0C, 0x70, 0xCF,
  0xD0, 0x47, 0x30, 0xAF, 0xD0, 0x86, 0x03, 0xFD, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xFD, 0x04, 0x60,
  0x8F, 0xD0, 0xB7, 0x30, 0x6F, 0xD0, 0xE0, 0x16, 0x0D, 0xFD, 0x06, 0x72, 0x01, 0xFE, 0x02, 0x60,
  0x8F, 0xD0, 0x97, 0x20, 0x9F, 0xD0, 0xC6, 0x02, 0x0E, 0xFD, 0x03, 0x71, 0x04, 0xFD, 0x0E, 0x01,
  0x60, 0xBF, 0xD0, 0x77, 0x20, 0xDF, 0xD0, 0x56, 0x06, 0xFD, 0x0B, 0x72, 0x08, 0xFD, 0x09, 0x60,
  0x10, 0xEF, 0xC0, 0xE0, 0x17, 0x10, 0x3F, 0xD0, 0xC7, 0x0B, 0xFD, 0x04, 0x72, 0x0C, 0xFC, 0x0E,
  0x02, 0x60, 0x5F, 0xD0, 0x87, 0x20, 0x7F, 0xD0, 0x66, 0x01, 0x0E, 0xFC, 0x0C, 0x72, 0x02, 0xFD,
  0x0A, 0x70, 0xAF, 0xC0, 0xE0, 0x27, 0x20, 0xCF, 0xC0, 0xD7, 0x05, 0xFD, 0x05, 0x72, 0x06, 0xFD,
  0x03, 0x60, 0x10, 0xEF, 0xC0, 0x97, 0x20, 0x20, 0xEF, 0xC0, 0x77, 0x09, 0xFC, 0x0D, 0x73, 0x0B,
  0xFC, 0x0B, 0x70, 0x4F, 0xD0, 0x27, 0x20, 0x5F, 0xC0, 0xE0, 0x17, 0x0D, 0xFC, 0x06, 0x72, 0x01,
  0x0E, 0xFC, 0x04, 0x70, 0x9F, 0xC0, 0xA7, 0x30, 0xAF, 0xC0, 0x87, 0x03, 0xFC, 0x0D, 0x01, 0x73,
  0x02, 0x0A, 0xFA, 0x0C, 0x72, 0x07, 0x0E, 0xFA, 0x03, 0x76, 0x03, 0x0B, 0xE0, 0xE0, 0x17, 0x40,
  0x80, 0xEE, 0x07, 0x77, 0x20, 0x40, 0xCC, 0x05, 0x76, 0x01, 0x09, 0xC0, 0xB7, 0x75, 0x82, 0x5D,
  0xF9, 0x77, 0x28, 0x32, 0xAF, 0xE1, 0x77, 0x70, 0x67, 0x75, 0x00, 0x37, 0x70,
  // "¼" (U+00BC)
  0x75, 0x08, 0xF0, 0x77, 0x77, 0x40, 0xBF, 0x90, 0xE0, 0x17, 0x77, 0x20, 0x10, 0xBF, 0x90, 0x77,
  0x77, 0x30, 0x3F, 0xA0, 0x87, 0x77, 0x20, 0x20, 0xDF, 0xA0, 0x77, 0x77, 0x30, 0xBF, 0x90, 0xE0,
  0x17, 0x77, 0x10, 0x40, 0xEF, 0xB0, 0x77, 0x77, 0x20, 0x4F, 0xA0, 0x77, 0x77, 0x10, 0x7F, 0xD0,
  0x77, 0x77, 0x20, 0xCF, 0x90, 0xE7, 0x77, 0x10, 0x9F, 0xE0, 0x77, 0x77, 0x10, 0x4F, 0xA0, 0x77,
  0x76, 0x01, 0x0C, 0xFF, 0x07, 0x77, 0x71, 0x0C, 0xF9, 0x0E, 0x77, 0x60, 0x30, 0xDF, 0xF9, 0x07,
  0x77, 0x70, 0x5F, 0xA0, 0x67, 0x75, 0x05, 0xFF, 0xB0, 0x77, 0x77, 0x0D, 0xF9, 0x0D, 0x77, 0x50,
  0x8F, 0xFC, 0x07, 0x77, 0x60, 0x5F, 0xA0, 0x67, 0x74, 0x03, 0xFB, 0x0B, 0xF9, 0x07, 0x77, 0x60,
  0xDF, 0x90, 0xD7, 0x76, 0x08, 0xF8, 0x1E, 0x47, 0xF9, 0x07, 0x77, 0x50, 0x6F, 0xA0, 0x57, 0x77,
  0x0B, 0xD8, 0x2E, 0x30, 0x9F, 0x90, 0x77, 0x75, 0x0D, 0xF9, 0x0D, 0x77, 0x71, 0x01, 0x0D, 0xB0,
  0xB0, 0x12, 0x09, 0xF9, 0x07, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x77, 0x20, 0x3A, 0x08, 0x40, 0xAF,
  0x90, 0x77, 0x74, 0x0D, 0xF9, 0x0C, 0x77, 0x74, 0x06, 0x05, 0x50, 0xBF, 0x90, 0x77, 0x73, 0x06,
  0xFA, 0x04, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x77, 0x73, 0x0E, 0xF9, 0x0C, 0x77, 0x77, 0x50, 0xBF,
  0x90, 0x77, 0x72, 0x07, 0xFA, 0x04, 0x77, 0x77, 0x50, 0xBF, 0x90, 0x77, 0x72, 0x0E, 0xF9, 0x0B,
  0x77, 0x77, 0x60, 0xBF, 0x90, 0x77, 0x71, 0x07, 0xFA, 0x03, 0x77, 0x77, 0x60, 0xBF, 0x90, 0x77,
  0x70, 0x10, 0xEF, 0x90, 0xB7, 0x77, 0x77, 0x0B, 0xF9, 0x07, 0x77, 0x08, 0xFA, 0x03, 0x77, 0x77,
  0x70, 0xBF, 0x90, 0x77, 0x60, 0x10, 0xEF, 0x90, 0xA8, 0x0C, 0x00, 0x0B, 0xF9, 0x07, 0x76, 0x08,
  0xFA, 0x02, 0x80, 0xC0, 0x00, 0xBF, 0x90, 0x77, 0x50, 0x1F, 0xA0, 0xA8, 0x0C, 0x10, 0x0B, 0xF9,
  0x07, 0x75, 0x09, 0xFA, 0x02, 0x73, 0x03, 0x80, 0x5C, 0x07, 0x77, 0x20, 0xBF, 0x90, 0x77, 0x40,
  0x1F, 0xA0, 0x97, 0x40, 0xBF, 0xA0, 0x97, 0x72, 0x0B, 0xF9, 0x07, 0x74, 0x09, 0xFA, 0x02, 0x73,
  0x05, 0xFB, 0x09, 0x77, 0x20, 0xBF, 0x90, 0x77, 0x30, 0x2F, 0xA0, 0x97, 0x40, 0xDF, 0xB0, 0x97,
  0x72, 0x0B, 0xF9, 0x07, 0x73, 0x09, 0xFA, 0x01, 0x73, 0x07, 0xFC, 0x09, 0x77, 0x20, 0xBF, 0x90,
  0x77, 0x20, 0x2F, 0xA0, 0x87, 0x30, 0x10, 0xEF, 0xC0, 0x97, 0x72, 0x0B, 0xF9, 0x07, 0x72, 0x0A,
  0xF9, 0x0E, 0x01, 0x73, 0x09, 0xFD, 0x09, 0x77, 0x20, 0xBF, 0x90, 0x77, 0x10, 0x2F, 0xA0, 0x87,
  0x30, 0x3F, 0xE0, 0x97, 0x72, 0x0B, 0xF9, 0x07, 0x71, 0x0A, 0xF9, 0x0E, 0x01, 0x73, 0x0C, 0xFE,
  0x09, 0x77, 0x20, 0xBF, 0x90, 0x77, 0x03, 0xFA, 0x07, 0x73, 0x05, 0xD0, 0xEF, 0x90, 0x97, 0x72,
  0x0B, 0xF9, 0x07, 0x70, 0xBF, 0x90, 0xE7, 0x40, 0xDD, 0x0A, 0xF9, 0x09, 0x77, 0x20, 0xBF, 0x90,
  0x76, 0x03, 0xFA, 0x07, 0x73, 0x07, 0xD0, 0xE0, 0x5F, 0x90, 0x97, 0x72, 0x0B, 0xF9, 0x07, 0x60,
  0xBF, 0x90, 0xE7, 0x30, 0x10, 0xED, 0x09, 0x06, 0xF9, 0x09, 0x77, 0x77, 0x30, 0x3F, 0xA0, 0x67,
  0x30, 0xAE, 0x02, 0x06, 0xF9, 0x09, 0x77, 0x77, 0x30, 0xBF, 0x90, 0xD7, 0x30, 0x3E, 0x81, 0xA0,
  0x7F, 0x90, 0x97, 0x77, 0x72, 0x04, 0xFA, 0x06, 0x73, 0x0C, 0xE8, 0x12, 0x07, 0xF9, 0x09, 0x77,
  0x77, 0x20, 0xCF, 0x90, 0xD7, 0x30, 0x5E, 0x08, 0x20, 0x7F, 0x90, 0x97, 0x77, 0x71, 0x04, 0xFA,
  0x05, 0x73, 0x0D, 0xD0, 0xE0, 0x12, 0x07, 0xF9, 0x09, 0x77, 0x77, 0x10, 0xCF, 0x90, 0xD7, 0x30,
  0x7E, 0x07, 0x30, 0x7F, 0x90, 0x97, 0x77, 0x70, 0x5F, 0xA0, 0x57, 0x20, 0x10, 0xED, 0x0D, 0x40,
  0x7F, 0x90, 0x97, 0x77, 0x70, 0xDF, 0x90, 0xC7, 0x30, 0xAE, 0x05, 0x40, 0x7F, 0x90, 0x97, 0x77,
  0x60, 0x5F, 0xA0, 0x47, 0x20, 0x3E, 0x0C, 0x50, 0x7F, 0x90, 0x97, 0x77, 0x60, 0xDF, 0x90, 0xC7,
  0x30, 0xCE, 0x03, 0x50, 0x7F, 0x90, 0x97, 0x77, 0x50, 0x6F, 0xA0, 0x47, 0x20, 0x5E, 0x0A, 0x60,
  0x7F, 0x90, 0x97, 0x77, 0x50, 0xDF, 0x90, 0xB7, 0x30, 0xDE, 0x02, 0x60, 0x7F, 0x90, 0x97, 0x77,
  0x40, 0x6F, 0xA0, 0x37, 0x20, 0x7F, 0xFF, 0xF0, 0x87, 0x76, 0x0D, 0xF9, 0x0B, 0x73, 0x09, 0xFF,
  0xFF, 0x08, 0x77, 0x50, 0x6F, 0xA0, 0x37, 0x30, 0x9F, 0xFF, 0xF0, 0x87, 0x75, 0x0E, 0xF9, 0x0A,
  0x74, 0x09, 0xFF, 0xFF, 0x08, 0x77, 0x40, 0x7F, 0xA0, 0x37, 0x40, 0x9F, 0xFF, 0xF0, 0x87, 0x74,
  0x0E, 0xF9, 0x0A, 0x75, 0x09, 0xFF, 0xFF, 0x08, 0x77, 0x30, 0x7F, 0xA0, 0x27, 0x50, 0x9F, 0xFF,
  0xF0, 0x87, 0x72, 0x01, 0x0E, 0xF9, 0x09, 0x77, 0x77, 0x07, 0xF9, 0x09, 0x77, 0x70, 0x8F, 0xA0,
  0x27, 0x77, 0x70, 0x7F, 0x90, 0x97, 0x76, 0x01, 0x0E, 0xF9, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x90,
  0x97, 0x76, 0x08, 0xFA, 0x01, 0x77, 0x77, 0x10, 0x7F, 0x90, 0x97, 0x75, 0x01, 0xFA, 0x09, 0x77,
  0x77, 0x20, 0x7F, 0x90, 0x97, 0x75, 0x09, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x7F, 0x90, 0x97,
  0x74, 0x01, 0x0E, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x7F, 0x90, 0x95,
  // "½" (U+00BD)
  0x75, 0x08, 0xF0, 0x77, 0x77, 0x30, 0xAF, 0xA0, 0x27, 0x77, 0x30, 0x10, 0xBF, 0x90, 0x77, 0x77,
  0x20, 0x2F, 0xA0, 0xA7, 0x77, 0x30, 0x30, 0xDF, 0xA0, 0x77, 0x77, 0x20, 0xAF, 0xA0, 0x27, 0x77,
  0x20, 0x50, 0xEF, 0xB0, 0x77, 0x77, 0x10, 0x3F, 0xA0, 0x97, 0x77, 0x20, 0x8F, 0xD0, 0x77, 0x77,
  0x10, 0xBF, 0xA0, 0x17, 0x77, 0x01, 0x0B, 0xFE, 0x07, 0x77, 0x70, 0x3F, 0xA0, 0x97, 0x77, 0x02,
  0x0D, 0xFF, 0x07, 0x77, 0x70, 0xBF, 0xA0, 0x17, 0x76, 0x04, 0x0E, 0xFF, 0x90, 0x77, 0x76, 0x03,
  0xFA, 0x08, 0x77, 0x60, 0x7F, 0xFB, 0x07, 0x77, 0x60, 0xBF, 0x90, 0xE0, 0x17, 0x75, 0x0A, 0xFF,
  0xC0, 0x77, 0x75, 0x04, 0xFA, 0x08, 0x77, 0x50, 0x2F, 0xA0, 0xE0, 0x9F, 0x90, 0x77, 0x75, 0x0C,
  0xF9, 0x0E, 0x01, 0x77, 0x60, 0x5F, 0x81, 0xD2, 0x8F, 0x90, 0x77, 0x74, 0x04, 0xFA, 0x07, 0x77,
  0x71, 0x09, 0xD8, 0x2B, 0x10, 0x9F, 0x90, 0x77, 0x74, 0x0C, 0xF9, 0x0E, 0x77, 0x73, 0x0B, 0xB0,
  0x83, 0x09, 0xF9, 0x07, 0x77, 0x30, 0x5F, 0xA0, 0x77, 0x77, 0x38, 0x21, 0xDE, 0x44, 0x0A, 0xF9,
  0x07, 0x77, 0x30, 0xDF, 0x90, 0xD7, 0x77, 0x50, 0x30, 0x15, 0x0B, 0xF9, 0x07, 0x77, 0x20, 0x5F,
  0xA0, 0x67, 0x77, 0x75, 0x0B, 0xF9, 0x07, 0x77, 0x20, 0xDF, 0x90, 0xD7, 0x77, 0x76, 0x0B, 0xF9,
  0x07, 0x77, 0x10, 0x6F, 0xA0, 0x67, 0x77, 0x76, 0x0B, 0xF9, 0x07, 0x77, 0x10, 0xDF, 0x90, 0xD7,
  0x77, 0x77, 0x0B, 0xF9, 0x07, 0x77, 0x06, 0xFA, 0x05, 0x77, 0x77, 0x70, 0xBF, 0x90, 0x77, 0x70,
  0xEF, 0x90, 0xC8, 0x0C, 0x00, 0x0B, 0xF9, 0x07, 0x76, 0x07, 0xFA, 0x05, 0x80, 0xC0, 0x00, 0xBF,
  0x90, 0x77, 0x60, 0xEF, 0x90, 0xC8, 0x0C, 0x10, 0x0B, 0xF9, 0x07, 0x75, 0x07, 0xFA, 0x04, 0x80,
  0xC1, 0x00, 0xBF, 0x90, 0x77, 0x40, 0x10, 0xEF, 0x90, 0xC7, 0x83, 0x15, 0x9C, 0xEA, 0x83, 0xEC,
  0x96, 0x17, 0x75, 0x0B, 0xF9, 0x07, 0x74, 0x08, 0xFA, 0x04, 0x50, 0x20, 0x9F, 0xD0, 0x90, 0x27,
  0x73, 0x0B, 0xF9, 0x07, 0x73, 0x01, 0x0E, 0xF9, 0x0B, 0x50, 0x8F, 0xF9, 0x0E, 0x05, 0x77, 0x20,
  0xBF, 0x90, 0x77, 0x30, 0x8F, 0xA0, 0x33, 0x03, 0x0D, 0xFF, 0xC0, 0x57, 0x71, 0x0B, 0xF9, 0x07,
  0x72, 0x01, 0x0E, 0xF9, 0x0B, 0x30, 0x40, 0xEF, 0xFE, 0x03, 0x77, 0x0B, 0xF9, 0x07, 0x72, 0x08,
  0xFA, 0x03, 0x20, 0x3F, 0xFF, 0x90, 0xC7, 0x70, 0xBF, 0x90, 0x77, 0x10, 0x1F, 0xA0, 0xA3, 0x01,
  0x0E, 0xFF, 0xF9, 0x05, 0x76, 0x0B, 0xF9, 0x07, 0x71, 0x09, 0xFA, 0x02, 0x40, 0x4F, 0xFF, 0x90,
  0x97, 0x60, 0xBF, 0x90, 0x77, 0x02, 0xFA, 0x0A, 0x60, 0x8D, 0x81, 0xD7, 0x32, 0x04, 0x0C, 0xFA,
  0x0D, 0x76, 0x0B, 0xF9, 0x07, 0x70, 0x9F, 0xA0, 0x27, 0x0C, 0xB0, 0x97, 0x0D, 0xFA, 0x76, 0x0B,
  0xF9, 0x07, 0x60, 0x2F, 0xA0, 0x97, 0x18, 0x22, 0xEF, 0x57, 0x10, 0x5F, 0xA0, 0x17, 0x50, 0xBF,
  0x90, 0x76, 0x0A, 0xFA, 0x01, 0x72, 0x00, 0x57, 0x20, 0x2F, 0xA7, 0x60, 0xBF, 0x90, 0x75, 0x02,
  0xFA, 0x09, 0x77, 0x70, 0x3F, 0xA7, 0x60, 0xBF, 0x90, 0x75, 0x0A, 0xFA, 0x01, 0x77, 0x70, 0x5F,
  0x90, 0xD7, 0x77, 0x60, 0x3F, 0xA0, 0x87, 0x77, 0x10, 0x9F, 0x90, 0xA7, 0x77, 0x60, 0xBF, 0x90,
  0xE0, 0x17, 0x77, 0x10, 0xEF, 0x90, 0x67, 0x77, 0x50, 0x3F, 0xA0, 0x87, 0x77, 0x10, 0x7F, 0xA0,
  0x17, 0x77, 0x50, 0xBF, 0x90, 0xE0, 0x17, 0x77, 0x01, 0x0E, 0xF9, 0x09, 0x77, 0x75, 0x04, 0xFA,
  0x07, 0x77, 0x71, 0x0B, 0xF9, 0x0E, 0x01, 0x77, 0x75, 0x0C, 0xF9, 0x0E, 0x77, 0x71, 0x08, 0xFA,
  0x06, 0x77, 0x75, 0x04, 0xFA, 0x07, 0x77, 0x70, 0x6F, 0xA0, 0xB7, 0x77, 0x60, 0xCF, 0x90, 0xD7,
  0x77, 0x04, 0xFA, 0x0D, 0x01, 0x77, 0x75, 0x05, 0xFA, 0x06, 0x77, 0x60, 0x20, 0xEF, 0x90, 0xE0,
  0x37, 0x77, 0x60, 0xCF, 0x90, 0xD7, 0x76, 0x02, 0x0E, 0xFA, 0x05, 0x77, 0x76, 0x05, 0xFA, 0x06,
  0x77, 0x50, 0x10, 0xDF, 0xA0, 0x67, 0x77, 0x70, 0xDF, 0x90, 0xD7, 0x76, 0x0C, 0xFA, 0x08, 0x77,
  0x77, 0x05, 0xFA, 0x05, 0x77, 0x50, 0xBF, 0xA0, 0x97, 0x77, 0x71, 0x0D, 0xF9, 0x0C, 0x77, 0x50,
  0x9F, 0xA0, 0xA7, 0x77, 0x71, 0x06, 0xFA, 0x05, 0x77, 0x40, 0x8F, 0xA0, 0xB7, 0x77, 0x72, 0x0D,
  0xF9, 0x0C, 0x77, 0x40, 0x6F, 0xA0, 0xB7, 0x77, 0x72, 0x06, 0xFA, 0x04, 0x77, 0x30, 0x5F, 0xA0,
  0xC7, 0x77, 0x73, 0x0E, 0xF9, 0x0C, 0x77, 0x30, 0x4F, 0xA0, 0xC0, 0x17, 0x77, 0x72, 0x07, 0xFA,
  0x04, 0x77, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0x17, 0x72, 0x0E, 0xF9, 0x0B, 0x77, 0x30, 0x2F, 0xFF,
  0xC0, 0x17, 0x71, 0x07, 0xFA, 0x03, 0x77, 0x30, 0x2F, 0xFF, 0xC0, 0x17, 0x70, 0x10, 0xEF, 0x90,
  0xB7, 0x74, 0x02, 0xFF, 0xFC, 0x01, 0x77, 0x08, 0xFA, 0x03, 0x77, 0x40, 0x2F, 0xFF, 0xC0, 0x17,
  0x60, 0x10, 0xEF, 0x90, 0xA7, 0x75, 0x02, 0xFF, 0xFC, 0x01, 0x76, 0x08, 0xFA, 0x02, 0x77, 0x50,
  0x2F, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xA0, 0xA7, 0x76, 0x02, 0xFF, 0xFC, 0x01,
  // "¾" (U+00BE)
  0x78, 0x25, 0x9C, 0xEA, 0x83, 0xEC, 0x96, 0x18, 0x0E, 0x40, 0x81, 0x29, 0xEF, 0xC0, 0xA0, 0x27,
  0x77, 0x50, 0xAF, 0xA0, 0x27, 0x72, 0x08, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x3F, 0xA0, 0x97, 0x71,
  0x02, 0x0D, 0xFF, 0xC0, 0xA7, 0x77, 0x20, 0xBF, 0xA0, 0x17, 0x70, 0x40, 0xEF, 0xFE, 0x08, 0x77,
  0x70, 0x3F, 0xA0, 0x87, 0x71, 0x0D, 0xFF, 0xF9, 0x03, 0x77, 0x60, 0xBF, 0x90, 0xE0, 0x17, 0x71,
  0x04, 0xFF, 0xF9, 0x09, 0x77, 0x50, 0x4F, 0xA0, 0x87, 0x73, 0x08, 0xFF, 0xF0, 0xE7, 0x75, 0x0C,
  0xF9, 0x0E, 0x01, 0x77, 0x40, 0xCC, 0x86, 0xB6, 0x21, 0x01, 0x6E, 0xFA, 0x01, 0x77, 0x30, 0x4F,
  0xA0, 0x77, 0x75, 0x03, 0xA0, 0xC0, 0x37, 0x02, 0xFA, 0x02, 0x77, 0x30, 0xCF, 0x90, 0xE0, 0x17,
  0x76, 0x00, 0x77, 0x30, 0x9F, 0x90, 0x27, 0x72, 0x05, 0xFA, 0x07, 0x77, 0x77, 0x50, 0x7F, 0x97,
  0x73, 0x0C, 0xF9, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0x0C, 0x77, 0x20, 0x5F, 0xA0, 0x77, 0x77, 0x76,
  0x0D, 0xF0, 0x77, 0x72, 0x0D, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x9F, 0x0E, 0x01, 0x77, 0x10, 0x5F,
  0xA0, 0x67, 0x77, 0x72, 0x82, 0x13, 0x6C, 0xF9, 0x05, 0x77, 0x20, 0xDF, 0x90, 0xD7, 0x77, 0x50,
  0x2F, 0xF9, 0x07, 0x77, 0x20, 0x6F, 0xA0, 0x57, 0x77, 0x50, 0x2F, 0xE0, 0xD0, 0x47, 0x73, 0x0D,
  0xF9, 0x0D, 0x77, 0x76, 0x02, 0xFC, 0x0E, 0x07, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x77, 0x60, 0x2F,
  0xC8, 0x1E, 0x82, 0x77, 0x30, 0xEF, 0x90, 0xC7, 0x77, 0x70, 0x2F, 0xF0, 0xA0, 0x17, 0x70, 0x7F,
  0xA0, 0x57, 0x77, 0x70, 0x2F, 0xF9, 0x0E, 0x03, 0x76, 0x0E, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x2F,
  0xFA, 0x0E, 0x02, 0x74, 0x07, 0xFA, 0x04, 0x77, 0x77, 0x78, 0x21, 0x48, 0xEF, 0x90, 0xC7, 0x30,
  0x10, 0xEF, 0x90, 0xC8, 0x0C, 0x30, 0x01, 0x0D, 0xF9, 0x05, 0x72, 0x08, 0xFA, 0x04, 0x80, 0xC4,
  0x00, 0x3F, 0x90, 0xB7, 0x10, 0x10, 0xEF, 0x90, 0xB8, 0x0C, 0x60, 0x0C, 0xF0, 0xE7, 0x10, 0x8F,
  0xA0, 0x37, 0x30, 0x78, 0x05, 0xD0, 0x47, 0x77, 0x0A, 0xF9, 0x01, 0x60, 0x10, 0xEF, 0x90, 0xB7,
  0x30, 0x1F, 0xB0, 0x45, 0x02, 0x77, 0x10, 0xBF, 0x90, 0x26, 0x09, 0xFA, 0x03, 0x73, 0x0A, 0xFB,
  0x04, 0x58, 0x1D, 0x91, 0x76, 0x0E, 0xF9, 0x01, 0x50, 0x1F, 0xA0, 0xA7, 0x30, 0x3F, 0xC0, 0x45,
  0x83, 0xDF, 0xE9, 0x27, 0x30, 0x9F, 0xA6, 0x09, 0xFA, 0x02, 0x73, 0x0C, 0xFC, 0x04, 0x50, 0xDC,
  0x83, 0xC8, 0x52, 0x12, 0x81, 0x15, 0xBF, 0xA0, 0xD5, 0x02, 0xFA, 0x0A, 0x73, 0x05, 0xFD, 0x04,
  0x50, 0xDF, 0xFF, 0xA0, 0x85, 0x09, 0xFA, 0x02, 0x73, 0x0D, 0xFD, 0x04, 0x50, 0xDF, 0xFF, 0xA0,
  0x24, 0x02, 0xFA, 0x09, 0x73, 0x08, 0xFE, 0x04, 0x50, 0xDF, 0xFF, 0x90, 0x85, 0x0A, 0xFA, 0x01,
  0x72, 0x01, 0xFF, 0x04, 0x50, 0xDF, 0xFF, 0x0C, 0x50, 0x2F, 0xA0, 0x97, 0x30, 0xAF, 0xF0, 0x45,
  0x0D, 0xFF, 0xE0, 0xC0, 0x15, 0x0A, 0xFA, 0x01, 0x72, 0x03, 0xE0, 0xAF, 0x90, 0x45, 0x04, 0x0C,
  0xFF, 0xC0, 0x86, 0x03, 0xFA, 0x08, 0x73, 0x0C, 0xD0, 0xB0, 0x9F, 0x90, 0x47, 0x04, 0x0A, 0xFE,
  0x81, 0xE9, 0x27, 0x0B, 0xF9, 0x0E, 0x01, 0x72, 0x05, 0xE0, 0x50, 0xAF, 0x90, 0x47, 0x38, 0x35,
  0x8B, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x72, 0x03, 0xFA, 0x08, 0x73, 0x0D, 0xD8, 0x1D, 0x0B, 0xF9,
  0x04, 0x77, 0x77, 0x30, 0xBF, 0x90, 0xE0, 0x17, 0x20, 0x8E, 0x81, 0x50, 0xBF, 0x90, 0x47, 0x77,
  0x72, 0x04, 0xFA, 0x07, 0x72, 0x01, 0xE0, 0xC2, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x20, 0xCF, 0x90,
  0xE7, 0x30, 0xAE, 0x04, 0x20, 0xBF, 0x90, 0x47, 0x77, 0x71, 0x04, 0xFA, 0x07, 0x72, 0x03, 0xE0,
  0xB3, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x10, 0xCF, 0x90, 0xE7, 0x30, 0xCE, 0x02, 0x30, 0xBF, 0x90,
  0x47, 0x77, 0x70, 0x5F, 0xA0, 0x67, 0x20, 0x5E, 0x09, 0x40, 0xBF, 0x90, 0x47, 0x77, 0x70, 0xCF,
  0x90, 0xD7, 0x30, 0xDD, 0x0E, 0x01, 0x40, 0xBF, 0x90, 0x47, 0x77, 0x60, 0x5F, 0xA0, 0x67, 0x20,
  0x8E, 0x08, 0x50, 0xBF, 0x90, 0x47, 0x77, 0x60, 0xDF, 0x90, 0xD7, 0x20, 0x1E, 0x0E, 0x60, 0xBF,
  0x90, 0x47, 0x77, 0x50, 0x5F, 0xA0, 0x57, 0x20, 0xAE, 0x06, 0x60, 0xBF, 0x90, 0x47, 0x77, 0x50,
  0xDF, 0x90, 0xC7, 0x20, 0x3E, 0x0D, 0x70, 0xBF, 0x90, 0x47, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x20,
  0xBF, 0xFF, 0xF0, 0x47, 0x76, 0x0D, 0xF9, 0x0C, 0x73, 0x0D, 0xFF, 0xFF, 0x04, 0x77, 0x50, 0x6F,
  0xA0, 0x47, 0x30, 0xDF, 0xFF, 0xF0, 0x47, 0x75, 0x0E, 0xF9, 0x0C, 0x74, 0x0D, 0xFF, 0xFF, 0x04,
  0x77, 0x40, 0x7F, 0xA0, 0x47, 0x40, 0xDF, 0xFF, 0xF0, 0x47, 0x74, 0x0E, 0xF9, 0x0B, 0x75, 0x0D,
  0xFF, 0xFF, 0x04, 0x77, 0x30, 0x7F, 0xA0, 0x37, 0x50, 0xDF, 0xFF, 0xF0, 0x47, 0x72, 0x01, 0x0E,
  0xF9, 0x0B, 0x77, 0x77, 0x0B, 0xF9, 0x04, 0x77, 0x70, 0x8F, 0xA0, 0x37, 0x77, 0x70, 0xBF, 0x90,
  0x47, 0x76, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x77, 0x10, 0xBF, 0x90, 0x47, 0x76, 0x08, 0xFA, 0x02,
  0x77, 0x77, 0x10, 0xBF, 0x90, 0x47, 0x75, 0x01, 0xFA, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x90, 0x47,
  0x75, 0x09, 0xFA, 0x02, 0x77, 0x77, 0x20, 0xBF, 0x90, 0x47, 0x74, 0x01, 0x0E, 0xF9, 0x09, 0x77,
  0x77, 0x30, 0xBF, 0x90, 0x45,
  // "¿" (U+00BF)
  0x77, 0x28, 0x57, 0xBE, 0xFE, 0xB6, 0x77, 0x75, 0x04, 0x0E, 0xF0, 0xE0, 0x37, 0x77, 0x20, 0x3F,
  0xC0, 0x37, 0x77, 0x10, 0xCF, 0xC0, 0xC7, 0x77, 0x03, 0xFE, 0x04, 0x77, 0x60, 0x7F, 0xE0, 0x77,
  0x76, 0x09, 0xFE, 0x09, 0x77, 0x60, 0xAF, 0xE0, 0xA7, 0x76, 0x09, 0xFE, 0x0A, 0x77, 0x60, 0x8F,
  0xE0, 0x87, 0x76, 0x04, 0xFE, 0x04, 0x77, 0x70, 0xDF, 0xC0, 0xD7, 0x77, 0x10, 0x4F, 0xC0, 0x47,
  0x77, 0x20, 0x50, 0xEF, 0x0E, 0x04, 0x77, 0x74, 0x87, 0x17, 0xCE, 0xFE, 0xB7, 0x18, 0x0C, 0x92,
  0x00, 0x58, 0x05, 0xA0, 0x97, 0x77, 0x30, 0x8F, 0xA0, 0xC7, 0x77, 0x30, 0x8F, 0xA0, 0xC7, 0x77,
  0x30, 0x8F, 0xA0, 0xC7, 0x77, 0x30, 0xAF, 0xA0, 0xC7, 0x77, 0x30, 0xDF, 0xA0, 0xB7, 0x77, 0x20,
  0x4F, 0xB0, 0x97, 0x77, 0x20, 0xDF, 0xB0, 0x77, 0x77, 0x10, 0x9F, 0xC0, 0x47, 0x77, 0x07, 0xFC,
  0x0E, 0x77, 0x70, 0x7F, 0xD0, 0x97, 0x76, 0x07, 0xFE, 0x02, 0x77, 0x50, 0x8F, 0xE0, 0x97, 0x75,
  0x08, 0xFE, 0x0D, 0x77, 0x50, 0x8F, 0xE0, 0xE0, 0x37, 0x74, 0x06, 0xFF, 0x04, 0x77, 0x40, 0x4F,
  0xF0, 0x57, 0x74, 0x01, 0x0E, 0xFE, 0x04, 0x77, 0x50, 0xBF, 0xE0, 0x47, 0x75, 0x05, 0xFE, 0x04,
  0x77, 0x60, 0xCF, 0xD0, 0x67, 0x76, 0x04, 0xFD, 0x09, 0x77, 0x70, 0x9F, 0xC0, 0xD7, 0x77, 0x10,
  0xDF, 0xC0, 0x57, 0x77, 0x01, 0xFC, 0x0E, 0x77, 0x71, 0x04, 0xFC, 0x0A, 0x77, 0x71, 0x05, 0xFC,
  0x07, 0x77, 0x71, 0x06, 0xFC, 0x06, 0x77, 0x71, 0x07, 0xFC, 0x06, 0x77, 0x71, 0x06, 0xFC, 0x08,
  0x77, 0x30, 0x24, 0x05, 0xFC, 0x0C, 0x77, 0x18, 0x14, 0xDC, 0x40, 0x3F, 0xD0, 0x57, 0x50, 0x30,
  0xBB, 0x04, 0x4F, 0xD0, 0xE0, 0x47, 0x20, 0x40, 0xBD, 0x0B, 0x40, 0xCF, 0xE8, 0x7B, 0x63, 0x22,
  0x46, 0x9E, 0xF9, 0x03, 0x30, 0x7F, 0xFF, 0xFA, 0x0A, 0x30, 0x1F, 0xFF, 0xFB, 0x02, 0x30, 0x9F,
  0xFF, 0xFA, 0x09, 0x30, 0x10, 0xDF, 0xFF, 0xF9, 0x0E, 0x01, 0x30, 0x3F, 0xFF, 0xFA, 0x07, 0x40,
  0x5F, 0xFF, 0xE0, 0xE0, 0x76, 0x04, 0x0E, 0xFF, 0xFA, 0x81, 0xE8, 0x17, 0x10, 0x10, 0xAF, 0xFE,
  0x81, 0xD7, 0x17, 0x58, 0x12, 0x9E, 0xFF, 0x81, 0xE9, 0x47, 0x74, 0x84, 0x37, 0xAC, 0xEE, 0xA8,
  0x4E, 0xDB, 0x96, 0x37, 0x30,
  // "À" (U+00C0)
  0x73, 0x03, 0x80, 0x91, 0x70, 0x48, 0x0C, 0x10, 0x04, 0xFE, 0x0E, 0x80, 0xC2, 0x00, 0x8F, 0xE0,
  0x78, 0x0C, 0x20, 0x09, 0xFD, 0x0E, 0x01, 0x80, 0xC2, 0x00, 0xAF, 0xD0, 0xA8, 0x0C, 0x30, 0x0B,
  0xFD, 0x04, 0x80, 0xC3, 0x00, 0xBF, 0xC0, 0xD8, 0x0C, 0x40, 0x0B, 0xFC, 0x08, 0x80, 0xC4, 0x00,
  0xBF, 0xC0, 0x28, 0x0C, 0x40, 0x0B, 0xFB, 0x0C, 0x80, 0xC5, 0x00, 0xAF, 0xB0, 0x78, 0x0C, 0x50,
  0x0A, 0xFB, 0x02, 0x80, 0xC5, 0x00, 0x9F, 0xA0, 0xC8, 0x0C, 0x60, 0x07, 0xFA, 0x07, 0x80, 0xC6,
  0x00, 0x5F, 0x90, 0xB8, 0x0C, 0xC4, 0x00, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04,
  0x77, 0x77, 0x60, 0xEF, 0xFA, 0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F,
  0xFC, 0x01, 0x77, 0x77, 0x40, 0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x5F, 0xFD, 0x0E, 0x77, 0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07,
  0x77, 0x77, 0x10, 0x2F, 0xB0, 0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB,
  0x01, 0x77, 0x77, 0x0B, 0xFB, 0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09,
  0x77, 0x76, 0x04, 0xFC, 0x01, 0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27,
  0x77, 0x50, 0xDF, 0xB0, 0xA2, 0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0,
  0xB7, 0x77, 0x40, 0x6F, 0xC0, 0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0,
  0x47, 0x77, 0x30, 0xEF, 0xB0, 0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF,
  0xB0, 0xD7, 0x77, 0x20, 0x7F, 0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F,
  0xC0, 0x67, 0x77, 0x01, 0xFC, 0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF,
  0xB0, 0xE7, 0x77, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F,
  0xC0, 0x87, 0x75, 0x02, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D,
  0xFC, 0x01, 0x77, 0x40, 0xBF, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71,
  0x06, 0xFC, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B,
  0x73, 0x0E, 0xFC, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD,
  0x04, 0x73, 0x07, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0,
  0xC7, 0x5F, 0xD0, 0x57, 0x70, 0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60,
  0x78, 0x0C, 0x2F, 0x02, 0x75, 0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05,
  0x80, 0xC4, 0xF7, 0x40, 0x98, 0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28,
  0x0C, 0x5F, 0x0D, 0x72, 0x06, 0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E,
  0xFD, 0x03, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD,
  0x0B, 0x77, 0x40, 0xEF, 0xD0, 0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE,
  0x04, 0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C,
  0x77, 0x60, 0xEF, 0xD0, 0x54, 0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04,
  0x77, 0x60, 0x6F, 0xD0, 0xE3, 0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77,
  0x71, 0x0E, 0xFD, 0x07, 0x2F, 0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77,
  0x71, 0x07, 0xFE, 0x01, 0x09, 0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77,
  0x73, 0x0E, 0xFD, 0x09,
  // "Á" (U+00C1)
  0x77, 0x76, 0x06, 0xFE, 0x0B, 0x80, 0xC1, 0x00, 0xEF, 0xE0, 0x38, 0x0C, 0x00, 0x08, 0xFE, 0x05,
  0x80, 0xC0, 0x00, 0x2F, 0xE0, 0x68, 0x0C, 0x10, 0x0B, 0xFD, 0x06, 0x80, 0xC1, 0x00, 0x5F, 0xD0,
  0x68, 0x0C, 0x10, 0x01, 0x0E, 0xFC, 0x06, 0x80, 0xC2, 0x00, 0xAF, 0xC0, 0x58, 0x0C, 0x20, 0x06,
  0xFC, 0x05, 0x80, 0xC2, 0x00, 0x10, 0xEF, 0xA0, 0xE0, 0x48, 0x0C, 0x30, 0x0B, 0xFA, 0x0E, 0x03,
  0x80, 0xC3, 0x00, 0x7F, 0xA0, 0xD0, 0x28, 0x0C, 0x30, 0x02, 0xFA, 0x0C, 0x01, 0x80, 0xC4, 0x00,
  0x6F, 0x90, 0xA8, 0x0C, 0xD0, 0x00, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04, 0x77,
  0x77, 0x60, 0xEF, 0xFA, 0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F, 0xFC,
  0x01, 0x77, 0x77, 0x40, 0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77, 0x30,
  0x5F, 0xFD, 0x0E, 0x77, 0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07, 0x77,
  0x77, 0x10, 0x2F, 0xB0, 0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB, 0x01,
  0x77, 0x77, 0x0B, 0xFB, 0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09, 0x77,
  0x76, 0x04, 0xFC, 0x01, 0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27, 0x77,
  0x50, 0xDF, 0xB0, 0xA2, 0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0, 0xB7,
  0x77, 0x40, 0x6F, 0xC0, 0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0, 0x47,
  0x77, 0x30, 0xEF, 0xB0, 0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF, 0xB0,
  0xD7, 0x77, 0x20, 0x7F, 0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F, 0xC0,
  0x67, 0x77, 0x01, 0xFC, 0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF, 0xB0,
  0xE7, 0x77, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F, 0xC0,
  0x87, 0x75, 0x02, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D, 0xFC,
  0x01, 0x77, 0x40, 0xBF, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71, 0x06,
  0xFC, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B, 0x73,
  0x0E, 0xFC, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD, 0x04,
  0x73, 0x07, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xC7,
  0x5F, 0xD0, 0x57, 0x70, 0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60, 0x78,
  0x0C, 0x2F, 0x02, 0x75, 0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05, 0x80,
  0xC4, 0xF7, 0x40, 0x98, 0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28, 0x0C,
  0x5F, 0x0D, 0x72, 0x06, 0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E, 0xFD,
  0x03, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD, 0x0B,
  0x77, 0x40, 0xEF, 0xD0, 0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE, 0x04,
  0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C, 0x77,
  0x60, 0xEF, 0xD0, 0x54, 0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04, 0x77,
  0x60, 0x6F, 0xD0, 0xE3, 0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77, 0x71,
  0x0E, 0xFD, 0x07, 0x2F, 0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77, 0x71,
  0x07, 0xFE, 0x01, 0x09, 0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77, 0x73,
  0x0E, 0xFD, 0x09,
  // "Â" (U+00C2)
  0x77, 0x50, 0x18, 0x09, 0x07, 0x02, 0x80, 0xC2, 0x00, 0x9F, 0xD0, 0xB8, 0x0C, 0x10, 0x03, 0xFF,
  0x04, 0x80, 0xC0, 0x00, 0xCF, 0xF0, 0xD7, 0x77, 0x77, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x75, 0x03,
  0xFF, 0xC0, 0x37, 0x77, 0x74, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x73, 0x09, 0xFA, 0x00, 0xEF, 0xA0,
  0x97, 0x77, 0x71, 0x04, 0xFA, 0x81, 0xE3, 0x3F, 0xB0, 0x57, 0x77, 0x60, 0x10, 0xEF, 0xA0, 0x42,
  0x04, 0xFA, 0x0E, 0x02, 0x77, 0x75, 0x0B, 0xFA, 0x04, 0x40, 0x5F, 0xA0, 0xC7, 0x77, 0x40, 0x8F,
  0xA0, 0x46, 0x04, 0xFA, 0x09, 0x77, 0x72, 0x04, 0xF9, 0x0E, 0x04, 0x71, 0x03, 0x0E, 0xF9, 0x06,
  0x77, 0x70, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x77, 0x60, 0x6F, 0x0C, 0x01,
  0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0C, 0xB3, 0x00, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA,
  0x04, 0x77, 0x77, 0x60, 0xEF, 0xFA, 0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50,
  0x7F, 0xFC, 0x01, 0x77, 0x77, 0x40, 0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77,
  0x77, 0x30, 0x5F, 0xFD, 0x0E, 0x77, 0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE,
  0x07, 0x77, 0x77, 0x10, 0x2F, 0xB0, 0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C,
  0xFB, 0x01, 0x77, 0x77, 0x0B, 0xFB, 0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB,
  0x09, 0x77, 0x76, 0x04, 0xFC, 0x01, 0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0,
  0x27, 0x77, 0x50, 0xDF, 0xB0, 0xA2, 0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F,
  0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0, 0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F,
  0xC0, 0x47, 0x77, 0x30, 0xEF, 0xB0, 0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40,
  0xBF, 0xB0, 0xD7, 0x77, 0x20, 0x7F, 0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50,
  0x4F, 0xC0, 0x67, 0x77, 0x01, 0xFC, 0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60,
  0xCF, 0xB0, 0xE7, 0x77, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60,
  0x5F, 0xC0, 0x87, 0x75, 0x02, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71,
  0x0D, 0xFC, 0x01, 0x77, 0x40, 0xBF, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03,
  0x71, 0x06, 0xFC, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC,
  0x0B, 0x73, 0x0E, 0xFC, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01,
  0xFD, 0x04, 0x73, 0x07, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF,
  0xC0, 0xC7, 0x5F, 0xD0, 0x57, 0x70, 0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7,
  0x60, 0x78, 0x0C, 0x2F, 0x02, 0x75, 0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74,
  0x05, 0x80, 0xC4, 0xF7, 0x40, 0x98, 0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20,
  0x28, 0x0C, 0x5F, 0x0D, 0x72, 0x06, 0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71,
  0x0E, 0xFD, 0x03, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08,
  0xFD, 0x0B, 0x77, 0x40, 0xEF, 0xD0, 0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01,
  0xFE, 0x04, 0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD,
  0x0C, 0x77, 0x60, 0xEF, 0xD0, 0x54, 0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE,
  0x04, 0x77, 0x60, 0x6F, 0xD0, 0xE3, 0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C,
  0x77, 0x71, 0x0E, 0xFD, 0x07, 0x2F, 0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04,
  0x77, 0x71, 0x07, 0xFE, 0x01, 0x09, 0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C,
  0x77, 0x73, 0x0E, 0xFD, 0x09,
  // "Ã" (U+00C3)
  0x77, 0x28, 0x65, 0xAD, 0xFE, 0xC9, 0x47, 0x40, 0x6E, 0x77, 0x73, 0x01, 0x0C, 0xF9, 0x0D, 0x05,
  0x72, 0x0B, 0xE7, 0x77, 0x20, 0x10, 0xDF, 0xC0, 0xD0, 0x66, 0x03, 0xE0, 0xD7, 0x77, 0x20, 0xAF,
  0xF8, 0x5E, 0x83, 0x10, 0x4E, 0xE0, 0xB7, 0x77, 0x10, 0x4F, 0xFF, 0xF0, 0x87, 0x77, 0x10, 0xCF,
  0xFF, 0xF0, 0x57, 0x77, 0x02, 0xFF, 0xFF, 0x0E, 0x77, 0x71, 0x07, 0xFF, 0xFF, 0x09, 0x77, 0x71,
  0x0A, 0xFF, 0xFE, 0x0E, 0x01, 0x77, 0x71, 0x0E, 0xE8, 0x4D, 0x30, 0x15, 0xBF, 0xF9, 0x06, 0x77,
  0x71, 0x01, 0xE0, 0xE0, 0x15, 0x03, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x03, 0xE0, 0x77, 0x18, 0x12,
  0x9E, 0xF9, 0x07, 0x77, 0x73, 0x05, 0xE0, 0x27, 0x48, 0x65, 0xAD, 0xEE, 0xC8, 0x28, 0x0C, 0xC0,
  0x00, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xFA, 0x08,
  0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F, 0xFC, 0x01, 0x77, 0x77, 0x40, 0xCF,
  0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x5F, 0xFD, 0x0E, 0x77, 0x77,
  0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07, 0x77, 0x77, 0x10, 0x2F, 0xB0, 0xC0,
  0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB, 0x01, 0x77, 0x77, 0x0B, 0xFB, 0x07,
  0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09, 0x77, 0x76, 0x04, 0xFC, 0x01, 0x03,
  0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27, 0x77, 0x50, 0xDF, 0xB0, 0xA2, 0x0C,
  0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0, 0x32,
  0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0, 0x47, 0x77, 0x30, 0xEF, 0xB0, 0xB4,
  0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF, 0xB0, 0xD7, 0x77, 0x20, 0x7F, 0xC0,
  0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F, 0xC0, 0x67, 0x77, 0x01, 0xFC, 0x0C,
  0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF, 0xB0, 0xE7, 0x77, 0x09, 0xFC, 0x05,
  0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x87, 0x75, 0x02, 0xFC, 0x0D,
  0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D, 0xFC, 0x01, 0x77, 0x40, 0xBF, 0xC0,
  0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71, 0x06, 0xFC, 0x0A, 0x77, 0x30, 0x4F,
  0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B, 0x73, 0x0E, 0xFC, 0x03, 0x77, 0x20,
  0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD, 0x04, 0x73, 0x07, 0xFC, 0x0C, 0x77,
  0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xC7, 0x5F, 0xD0, 0x57, 0x70, 0xE8,
  0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60, 0x78, 0x0C, 0x2F, 0x02, 0x75, 0x0B,
  0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05, 0x80, 0xC4, 0xF7, 0x40, 0x98, 0x0C,
  0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28, 0x0C, 0x5F, 0x0D, 0x72, 0x06, 0x80,
  0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E, 0xFD, 0x03, 0x77, 0x20, 0x6F, 0xD0,
  0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD, 0x0B, 0x77, 0x40, 0xEF, 0xD0, 0x36,
  0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x6F, 0xD0, 0xC5,
  0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C, 0x77, 0x60, 0xEF, 0xD0, 0x54, 0x0E,
  0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04, 0x77, 0x60, 0x6F, 0xD0, 0xE3, 0x07,
  0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77, 0x71, 0x0E, 0xFD, 0x07, 0x2F, 0xE0,
  0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77, 0x71, 0x07, 0xFE, 0x01, 0x09, 0xFE,
  0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77, 0x73, 0x0E, 0xFD, 0x09,
  // "Ä" (U+00C4)
  0x77, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x76, 0x02, 0x0D, 0xE0,
  0xD0, 0x27, 0x04, 0x0E, 0xE0, 0xC7, 0x77, 0x50, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x77,
  0x73, 0x03, 0xFB, 0x04, 0x50, 0x7F, 0xB0, 0x17, 0x77, 0x20, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05,
  0x77, 0x72, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x77, 0x77, 0x20, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB,
  0x07, 0x77, 0x72, 0x07, 0xFB, 0x08, 0x50, 0xCF, 0xB0, 0x67, 0x77, 0x20, 0x4F, 0xB0, 0x45, 0x08,
  0xFB, 0x02, 0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA7, 0x77, 0x40, 0x20, 0xDE,
  0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x77, 0x76, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51,
  0x8D, 0xFE, 0xC6, 0x80, 0xDA, 0x40, 0x06, 0xFF, 0x90, 0xE7, 0x77, 0x77, 0x0A, 0xFF, 0xA0, 0x47,
  0x77, 0x76, 0x0E, 0xFF, 0xA0, 0x87, 0x77, 0x75, 0x03, 0xFF, 0xB0, 0xC7, 0x77, 0x75, 0x07, 0xFF,
  0xC0, 0x17, 0x77, 0x74, 0x0C, 0xFF, 0xC0, 0x57, 0x77, 0x73, 0x01, 0xFF, 0xD0, 0xA7, 0x77, 0x73,
  0x05, 0xFF, 0xD0, 0xE7, 0x77, 0x73, 0x09, 0xFF, 0xE0, 0x37, 0x77, 0x72, 0x0D, 0xFF, 0xE0, 0x77,
  0x77, 0x71, 0x02, 0xFB, 0x0C, 0x0E, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xB0, 0x90, 0xCF, 0xB0,
  0x17, 0x77, 0x70, 0xBF, 0xB0, 0x70, 0x9F, 0xB0, 0x57, 0x77, 0x7F, 0xC0, 0x40, 0x6F, 0xB0, 0x97,
  0x77, 0x60, 0x4F, 0xC0, 0x10, 0x3F, 0xB0, 0xD7, 0x77, 0x60, 0x8F, 0xB0, 0xD2, 0xFC, 0x02, 0x77,
  0x75, 0x0D, 0xFB, 0x0A, 0x20, 0xCF, 0xB0, 0x77, 0x77, 0x40, 0x1F, 0xC0, 0x62, 0x09, 0xFB, 0x0B,
  0x77, 0x74, 0x06, 0xFC, 0x03, 0x20, 0x5F, 0xC7, 0x77, 0x40, 0xAF, 0xB0, 0xE3, 0x02, 0xFC, 0x04,
  0x77, 0x73, 0x0E, 0xFB, 0x0B, 0x40, 0xEF, 0xB0, 0x97, 0x77, 0x20, 0x3F, 0xC0, 0x74, 0x0B, 0xFB,
  0x0D, 0x77, 0x72, 0x07, 0xFC, 0x04, 0x40, 0x8F, 0xC0, 0x27, 0x77, 0x10, 0xCF, 0xC5, 0x04, 0xFC,
  0x06, 0x77, 0x70, 0x1F, 0xC0, 0xC5, 0x01, 0xFC, 0x0A, 0x77, 0x70, 0x5F, 0xC0, 0x96, 0x0C, 0xFB,
  0x0E, 0x77, 0x70, 0x9F, 0xC0, 0x56, 0x09, 0xFC, 0x03, 0x77, 0x60, 0xDF, 0xC0, 0x16, 0x05, 0xFC,
  0x08, 0x77, 0x50, 0x2F, 0xC0, 0xD7, 0x01, 0xFC, 0x0C, 0x77, 0x50, 0x6F, 0xC0, 0xA7, 0x10, 0xDF,
  0xC0, 0x17, 0x74, 0x0B, 0xFC, 0x06, 0x71, 0x0A, 0xFC, 0x05, 0x77, 0x40, 0xEF, 0xC0, 0x37, 0x10,
  0x6F, 0xC0, 0xA7, 0x73, 0x04, 0xFC, 0x0E, 0x72, 0x02, 0xFC, 0x0E, 0x77, 0x30, 0x8F, 0xC0, 0xB7,
  0x30, 0xEF, 0xC0, 0x37, 0x72, 0x0C, 0xFC, 0x07, 0x73, 0x0A, 0xFC, 0x07, 0x77, 0x10, 0x1F, 0xD0,
  0x47, 0x30, 0x7F, 0xC0, 0xC7, 0x71, 0x05, 0xFD, 0x74, 0x03, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0C,
  0x75, 0xFD, 0x05, 0x77, 0x0E, 0x80, 0xC0, 0xF0, 0x97, 0x60, 0x38, 0x0C, 0x1F, 0x0D, 0x76, 0x07,
  0x80, 0xC2, 0xF0, 0x27, 0x50, 0xB8, 0x0C, 0x2F, 0x07, 0x75, 0x80, 0xC3, 0xF0, 0xB7, 0x40, 0x58,
  0x0C, 0x4F, 0x74, 0x09, 0x80, 0xC4, 0xF0, 0x47, 0x30, 0xD8, 0x0C, 0x4F, 0x08, 0x72, 0x02, 0x80,
  0xC5, 0xF0, 0xD7, 0x20, 0x68, 0x0C, 0x6F, 0x02, 0x71, 0x0B, 0x80, 0xC6, 0xF0, 0x67, 0x10, 0xEF,
  0xD0, 0x37, 0x72, 0x06, 0xFD, 0x0A, 0x70, 0x4F, 0xE7, 0x73, 0x02, 0xFD, 0x0E, 0x70, 0x8F, 0xD0,
  0xB7, 0x74, 0x0E, 0xFD, 0x03, 0x60, 0xCF, 0xD0, 0x77, 0x74, 0x0A, 0xFD, 0x08, 0x50, 0x1F, 0xE0,
  0x47, 0x74, 0x06, 0xFD, 0x0C, 0x50, 0x5F, 0xE7, 0x75, 0x02, 0xFE, 0x01, 0x40, 0xAF, 0xD0, 0xC7,
  0x76, 0x0E, 0xFD, 0x05, 0x40, 0xEF, 0xD0, 0x87, 0x76, 0x0A, 0xFD, 0x0A, 0x30, 0x3F, 0xE0, 0x47,
  0x76, 0x06, 0xFD, 0x0E, 0x30, 0x7F, 0xE7, 0x77, 0x03, 0xFE, 0x03, 0x20, 0xBF, 0xD0, 0xC7, 0x77,
  0x10, 0xEF, 0xD0, 0x72, 0xFE, 0x08, 0x77, 0x71, 0x0A, 0xFD, 0x81, 0xB0, 0x4F, 0xE0, 0x47, 0x77,
  0x10, 0x7F, 0xE0, 0x10, 0x9F, 0xE0, 0x17, 0x77, 0x10, 0x3F, 0xE0, 0x50, 0xDF, 0xD0, 0xC7, 0x77,
  0x30, 0xEF, 0xD0, 0x90,
  // "Å" (U+00C5)
  0x77, 0x78, 0x90, 0x16, 0xAD, 0xEF, 0xDC, 0x83, 0x80, 0xC5, 0x00, 0x80, 0xEF, 0xA0, 0xB0, 0x28,
  0x0C, 0x10, 0x02, 0x0C, 0xFD, 0x0E, 0x05, 0x77, 0x77, 0x70, 0x10, 0xDF, 0xF9, 0x05, 0x77, 0x77,
  0x60, 0xBF, 0xFB, 0x03, 0x77, 0x77, 0x40, 0x4F, 0xFC, 0x0B, 0x77, 0x77, 0x40, 0xBE, 0x84, 0xE6,
  0x10, 0x3B, 0xF0, 0x37, 0x77, 0x73, 0xE0, 0xE0, 0x25, 0x0A, 0xE0, 0x87, 0x77, 0x72, 0x03, 0xE0,
  0x76, 0x01, 0xE0, 0xB7, 0x77, 0x72, 0x05, 0xE0, 0x27, 0x0B, 0xD0, 0xD7, 0x77, 0x72, 0x05, 0xE0,
  0x17, 0x0A, 0xD0, 0xE7, 0x77, 0x72, 0x05, 0xE0, 0x27, 0x0B, 0xD0, 0xD7, 0x77, 0x72, 0x03, 0xE0,
  0x66, 0x01, 0x0E, 0xD0, 0xB7, 0x77, 0x73, 0xE0, 0xD0, 0x15, 0x09, 0xE0, 0x87, 0x77, 0x73, 0x0B,
  0xE8, 0x4D, 0x41, 0x03, 0xAF, 0x03, 0x77, 0x77, 0x30, 0x5F, 0xFC, 0x0B, 0x77, 0x77, 0x5F, 0xFC,
  0x03, 0x77, 0x77, 0x5F, 0xFB, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F,
  0xFC, 0x01, 0x77, 0x77, 0x40, 0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77,
  0x30, 0x5F, 0xFD, 0x0E, 0x77, 0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07,
  0x77, 0x77, 0x10, 0x2F, 0xB0, 0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB,
  0x01, 0x77, 0x77, 0x0B, 0xFB, 0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09,
  0x77, 0x76, 0x04, 0xFC, 0x01, 0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27,
  0x77, 0x50, 0xDF, 0xB0, 0xA2, 0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0,
  0xB7, 0x77, 0x40, 0x6F, 0xC0, 0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0,
  0x47, 0x77, 0x30, 0xEF, 0xB0, 0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF,
  0xB0, 0xD7, 0x77, 0x20, 0x7F, 0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F,
  0xC0, 0x67, 0x77, 0x01, 0xFC, 0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF,
  0xB0, 0xE7, 0x77, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F,
  0xC0, 0x87, 0x75, 0x02, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D,
  0xFC, 0x01, 0x77, 0x40, 0xBF, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71,
  0x06, 0xFC, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B,
  0x73, 0x0E, 0xFC, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD,
  0x04, 0x73, 0x07, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0,
  0xC7, 0x5F, 0xD0, 0x57, 0x70, 0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60,
  0x78, 0x0C, 0x2F, 0x02, 0x75, 0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05,
  0x80, 0xC4, 0xF7, 0x40, 0x98, 0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28,
  0x0C, 0x5F, 0x0D, 0x72, 0x06, 0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E,
  0xFD, 0x03, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD,
  0x0B, 0x77, 0x40, 0xEF, 0xD0, 0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE,
  0x04, 0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C,
  0x77, 0x60, 0xEF, 0xD0, 0x54, 0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04,
  0x77, 0x60, 0x6F, 0xD0, 0xE3, 0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77,
  0x71, 0x0E, 0xFD, 0x07, 0x2F, 0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77,
  0x71, 0x07, 0xFE, 0x01, 0x09, 0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77,
  0x73, 0x0E, 0xFD, 0x09,
  // "Æ" (U+00C6)
  0x77, 0x70, 0x18, 0x0C, 0x7F, 0x01, 0x77, 0x70, 0x58, 0x0C, 0x7F, 0x01, 0x77, 0x70, 0xB8, 0x0C,
  0x7F, 0x01, 0x77, 0x60, 0x18, 0x0D, 0x0F, 0x01, 0x77, 0x60, 0x68, 0x0D, 0x0F, 0x01, 0x77, 0x60,
  0xC8, 0x0D, 0x0F, 0x01, 0x77, 0x50, 0x28, 0x0D, 0x1F, 0x01, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x01,
  0x77, 0x50, 0xC8, 0x0D, 0x1F, 0x01, 0x77, 0x40, 0x28, 0x0D, 0x2F, 0x01, 0x77, 0x40, 0x88, 0x0D,
  0x2F, 0x01, 0x77, 0x40, 0xDF, 0xC0, 0x42, 0x08, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x3F, 0xC0, 0xE3,
  0x08, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0x8F, 0xC0, 0x93, 0x08, 0xFD, 0x01, 0x80, 0xC0, 0x00, 0xEF,
  0xC0, 0x43, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x70, 0x4F, 0xC0, 0xE4, 0x08, 0xFD, 0x01, 0x77, 0x77,
  0x70, 0x9F, 0xC0, 0xA4, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x70, 0xEF, 0xC0, 0x54, 0x08, 0xFD, 0x01,
  0x77, 0x77, 0x60, 0x4F, 0xD0, 0x14, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x60, 0xAF, 0xC0, 0xB5, 0x08,
  0xFD, 0x01, 0x77, 0x77, 0x60, 0xEF, 0xC0, 0x65, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x50, 0x5F, 0xD0,
  0x15, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x50, 0xBF, 0xC0, 0xC6, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x40,
  0x1F, 0xD0, 0x76, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x40, 0x6F, 0xD0, 0x26, 0x08, 0xFD, 0x01, 0x77,
  0x77, 0x40, 0xBF, 0xC0, 0xC7, 0x08, 0xFD, 0x03, 0x80, 0x94, 0x20, 0x17, 0x70, 0x1F, 0xD0, 0x77,
  0x08, 0xFF, 0xFF, 0x90, 0xB7, 0x70, 0x7F, 0xD0, 0x37, 0x08, 0xFF, 0xFF, 0x90, 0xB7, 0x70, 0xCF,
  0xC0, 0xD7, 0x10, 0x8F, 0xFF, 0xF9, 0x0B, 0x76, 0x02, 0xFD, 0x08, 0x71, 0x08, 0xFF, 0xFF, 0x90,
  0xB7, 0x60, 0x7F, 0xD0, 0x37, 0x10, 0x8F, 0xFF, 0xF9, 0x0B, 0x76, 0x0D, 0xFC, 0x0E, 0x72, 0x08,
  0xFF, 0xFF, 0x90, 0xB7, 0x50, 0x3F, 0xD0, 0x97, 0x20, 0x8F, 0xFF, 0xF9, 0x0B, 0x75, 0x08, 0xFD,
  0x04, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0xB7, 0x50, 0xDF, 0xC0, 0xE7, 0x30, 0x8F, 0xFF, 0xF9, 0x0B,
  0x74, 0x03, 0xFD, 0x0A, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0xB7, 0x40, 0x9F, 0xD0, 0x57, 0x30, 0x8F,
  0xD0, 0x17, 0x77, 0x70, 0xEF, 0xD7, 0x40, 0x8F, 0xD0, 0x17, 0x77, 0x60, 0x48, 0x0C, 0x1F, 0x01,
  0x77, 0x76, 0x09, 0x80, 0xC1, 0xF0, 0x17, 0x77, 0x60, 0xE8, 0x0C, 0x1F, 0x01, 0x77, 0x75, 0x05,
  0x80, 0xC2, 0xF0, 0x17, 0x77, 0x50, 0xA8, 0x0C, 0x2F, 0x01, 0x77, 0x74, 0x01, 0x80, 0xC3, 0xF0,
  0x17, 0x77, 0x40, 0x68, 0x0C, 0x3F, 0x01, 0x77, 0x74, 0x0B, 0x80, 0xC3, 0xF0, 0x17, 0x77, 0x30,
  0x18, 0x0C, 0x4F, 0x01, 0x77, 0x73, 0x06, 0x80, 0xC4, 0xF0, 0x17, 0x77, 0x30, 0xC8, 0x0C, 0x4F,
  0x01, 0x77, 0x72, 0x02, 0xFE, 0x02, 0x77, 0x08, 0xFD, 0x01, 0x77, 0x72, 0x07, 0xFD, 0x0D, 0x77,
  0x10, 0x8F, 0xD0, 0x17, 0x77, 0x20, 0xCF, 0xD0, 0x87, 0x71, 0x08, 0xFD, 0x01, 0x77, 0x71, 0x02,
  0xFE, 0x02, 0x77, 0x10, 0x8F, 0xD0, 0x17, 0x77, 0x10, 0x8F, 0xD0, 0xD7, 0x72, 0x08, 0xFF, 0xFF,
  0xB0, 0x13, 0x0D, 0xFD, 0x07, 0x77, 0x20, 0x8F, 0xFF, 0xFB, 0x01, 0x20, 0x3F, 0xE0, 0x27, 0x72,
  0x08, 0xFF, 0xFF, 0xB0, 0x12, 0x08, 0xFD, 0x0C, 0x77, 0x30, 0x8F, 0xFF, 0xFB, 0x01, 0x20, 0xEF,
  0xD0, 0x77, 0x73, 0x08, 0xFF, 0xFF, 0xB8, 0x11, 0x04, 0xFE, 0x02, 0x77, 0x30, 0x8F, 0xFF, 0xFB,
  0x81, 0x10, 0x9F, 0xD0, 0xC7, 0x74, 0x08, 0xFF, 0xFF, 0xB8, 0x11, 0x0E, 0xFD, 0x07, 0x77, 0x40,
  0x8F, 0xFF, 0xFB, 0x01, 0x04, 0xFE, 0x02, 0x77, 0x40, 0x8F, 0xFF, 0xFB, 0x01, 0x0A, 0xFD, 0x0C,
  0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x01, 0x0E, 0xFD, 0x07, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x01,
  // "Ç" (U+00C7)
  0x77, 0x48, 0x41, 0x58, 0xBC, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x37, 0x77, 0x30, 0x60, 0xBF, 0xF9,
  0x82, 0xEA, 0x51, 0x77, 0x40, 0x70, 0xEF, 0xFF, 0x0B, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFC, 0x0C,
  0x05, 0x74, 0x07, 0xFF, 0xFF, 0x0E, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x97, 0x20, 0xAF, 0xFF, 0xFA,
  0x04, 0x71, 0x09, 0xFF, 0xFF, 0xA0, 0xD7, 0x10, 0x7F, 0xFF, 0xFB, 0x08, 0x70, 0x4F, 0xFF, 0xFC,
  0x03, 0x70, 0xDF, 0xF9, 0x87, 0xC7, 0x43, 0x23, 0x69, 0xDF, 0x0D, 0x70, 0x8F, 0xF0, 0xC0, 0x47,
  0x20, 0x40, 0xBD, 0x07, 0x60, 0x2F, 0xF0, 0xA7, 0x60, 0x30, 0xBB, 0x02, 0x60, 0x9F, 0xE0, 0xA7,
  0x72, 0x81, 0x5D, 0xB6, 0x01, 0xFE, 0x0C, 0x77, 0x50, 0x36, 0x08, 0xFE, 0x03, 0x77, 0x75, 0x0E,
  0xFD, 0x09, 0x77, 0x75, 0x04, 0xFE, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0E, 0xFD,
  0x05, 0x77, 0x75, 0x02, 0xFE, 0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x76, 0x0D, 0xFD, 0x04, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x75, 0x02, 0xFD, 0x0E, 0x77, 0x76, 0x04,
  0xFD, 0x0C, 0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x09, 0x77, 0x76, 0x08, 0xFD,
  0x08, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07,
  0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77,
  0x76, 0x09, 0xFD, 0x08, 0x77, 0x76, 0x08, 0xFD, 0x09, 0x77, 0x76, 0x07, 0xFD, 0x0B, 0x77, 0x76,
  0x05, 0xFD, 0x0D, 0x77, 0x76, 0x04, 0xFD, 0x0E, 0x77, 0x76, 0x02, 0xFE, 0x02, 0x77, 0x76, 0xFE,
  0x05, 0x77, 0x76, 0x0D, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x0C, 0x77, 0x76, 0x06, 0xFE, 0x01,
  0x77, 0x75, 0x03, 0xFE, 0x07, 0x77, 0x76, 0x0E, 0xFD, 0x0D, 0x77, 0x76, 0x09, 0xFE, 0x05, 0x77,
  0x75, 0x05, 0xFE, 0x0D, 0x77, 0x76, 0x0E, 0xFE, 0x08, 0x77, 0x75, 0x08, 0xFF, 0x05, 0x77, 0x50,
  0x25, 0x02, 0xFF, 0x90, 0x67, 0x72, 0x82, 0x4B, 0xF1, 0x50, 0xAF, 0xF9, 0x0A, 0x01, 0x74, 0x81,
  0x28, 0xDB, 0x01, 0x50, 0x2F, 0xFB, 0x81, 0xA5, 0x22, 0x84, 0x12, 0x36, 0x9D, 0xE0, 0x16, 0x09,
  0xFF, 0xFF, 0xD0, 0x17, 0x0D, 0xFF, 0xFF, 0xC0, 0x17, 0x04, 0xFF, 0xFF, 0xC0, 0x17, 0x10, 0x7F,
  0xFF, 0xFB, 0x01, 0x72, 0x09, 0xFF, 0xFF, 0xA0, 0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x01, 0x74, 0x06,
  0xFF, 0xFF, 0x01, 0x75, 0x03, 0x0C, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x06, 0x0D, 0xFF, 0xF8, 0x1D,
  0x71, 0x77, 0x30, 0x40, 0xBF, 0xFA, 0x81, 0xD9, 0x47, 0x77, 0x20, 0x40, 0x9F, 0x84, 0xDC, 0xA8,
  0x52, 0x77, 0x76, 0x08, 0xE0, 0x37, 0x77, 0x75, 0x0E, 0xD0, 0xC7, 0x77, 0x75, 0x06, 0xE0, 0x57,
  0x77, 0x75, 0x0D, 0xE8, 0x1E, 0xA4, 0x77, 0x77, 0x20, 0x4F, 0xB0, 0xC0, 0x37, 0x77, 0x70, 0xBF,
  0xD0, 0x67, 0x77, 0x50, 0x10, 0xDF, 0xE0, 0x57, 0x77, 0x78, 0x13, 0x8E, 0xFA, 0x0E, 0x77, 0x77,
  0x20, 0x10, 0xCF, 0xA0, 0x67, 0x77, 0x72, 0x01, 0xFA, 0x0A, 0x77, 0x77, 0x30, 0xBF, 0x90, 0xC7,
  0x77, 0x73, 0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0x2F, 0xA0, 0xA7, 0x77, 0x18, 0x76, 0x74, 0x21,
  0x01, 0x5D, 0xFA, 0x08, 0x77, 0x71, 0x09, 0xFF, 0xB0, 0x47, 0x77, 0x10, 0x9F, 0xFA, 0x0D, 0x77,
  0x72, 0x09, 0xFF, 0xA0, 0x67, 0x77, 0x20, 0x9F, 0xF9, 0x09, 0x77, 0x73, 0x09, 0xFF, 0x09, 0x77,
  0x74, 0x09, 0xFD, 0x0C, 0x05, 0x77, 0x75, 0x84, 0x27, 0xAC, 0xEE, 0xA8, 0x3E, 0xDA, 0x73, 0x77,
  // "È" (U+00C8)
  0x10, 0x38, 0x09, 0x17, 0x04, 0x77, 0x30, 0x4F, 0xE0, 0xE7, 0x74, 0x08, 0xFE, 0x07, 0x77, 0x40,
  0x9F, 0xD0, 0xE0, 0x17, 0x74, 0x0A, 0xFD, 0x0A, 0x77, 0x50, 0xBF, 0xD0, 0x47, 0x75, 0x0B, 0xFC,
  0x0D, 0x77, 0x60, 0xBF, 0xC0, 0x87, 0x76, 0x0B, 0xFC, 0x02, 0x77, 0x60, 0xBF, 0xB0, 0xC7, 0x77,
  0x0A, 0xFB, 0x07, 0x77, 0x70, 0xAF, 0xB0, 0x27, 0x77, 0x09, 0xFA, 0x0C, 0x77, 0x71, 0x07, 0xFA,
  0x07, 0x77, 0x71, 0x05, 0xF9, 0x0B, 0x80, 0xAC, 0x40, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09,
  0x42, 0x81, 0x10, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70,
  0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F,
  0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0,
  // "É" (U+00C9)
  0x77, 0x30, 0x6F, 0xE0, 0xB7, 0x73, 0x0E, 0xFE, 0x03, 0x77, 0x20, 0x8F, 0xE0, 0x57, 0x72, 0x02,
  0xFE, 0x06, 0x77, 0x30, 0xBF, 0xD0, 0x67, 0x73, 0x05, 0xFD, 0x06, 0x77, 0x30, 0x10, 0xEF, 0xC0,
  0x67, 0x74, 0x0A, 0xFC, 0x05, 0x77, 0x40, 0x6F, 0xC0, 0x57, 0x74, 0x01, 0x0E, 0xFA, 0x0E, 0x04,
  0x77, 0x50, 0xBF, 0xA0, 0xE0, 0x37, 0x75, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x50, 0x2F, 0xA0, 0xC0,
  0x17, 0x76, 0x06, 0xF9, 0x0A, 0x80, 0xAD, 0x10, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F,
  0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42,
  0x81, 0x10, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70,
  0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F,
  0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0,
  // "Ê" (U+00CA)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x74, 0x09, 0xFD, 0x0B, 0x77, 0x30, 0x3F, 0xF0, 0x47, 0x72,
  0x0C, 0xFF, 0x0D, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x76, 0x03, 0xFF, 0xC0, 0x37, 0x50, 0xDF, 0xFC,
  0x0D, 0x74, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x20, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x70,
  0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x60, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x50,
  0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x98, 0x26,
  0x02, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xAB, 0x40, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F, 0xFF,
  0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "Ë" (U+00CB)
  0x58, 0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x67, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC6, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA4, 0x03, 0xFB, 0x04, 0x50,
  0x7F, 0xB0, 0x13, 0x07, 0xFB, 0x08, 0x50, 0xBF, 0xB0, 0x53, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0,
  0x73, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x73, 0x07, 0xFB, 0x08, 0x50, 0xCF, 0xB0, 0x63, 0x04,
  0xFB, 0x04, 0x50, 0x8F, 0xB0, 0x24, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA5, 0x02, 0x0D,
  0xE0, 0xD0, 0x27, 0x04, 0x0E, 0xE0, 0xC0, 0x17, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D,
  0xFE, 0xC6, 0x80, 0xB8, 0x00, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F,
  0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF,
  0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "Ì" (U+00CC)
  0x03, 0x80, 0x91, 0x70, 0x47, 0x70, 0x4F, 0xE0, 0xE7, 0x71, 0x08, 0xFE, 0x07, 0x77, 0x10, 0x9F,
  0xD0, 0xE0, 0x17, 0x71, 0x0A, 0xFD, 0x0A, 0x77, 0x20, 0xBF, 0xD0, 0x47, 0x72, 0x0B, 0xFC, 0x0D,
  0x77, 0x30, 0xBF, 0xC0, 0x87, 0x73, 0x0B, 0xFC, 0x02, 0x77, 0x30, 0xBF, 0xB0, 0xC7, 0x74, 0x0A,
  0xFB, 0x07, 0x77, 0x40, 0xAF, 0xB0, 0x27, 0x74, 0x09, 0xFA, 0x0C, 0x77, 0x50, 0x7F, 0xA0, 0x77,
  0x75, 0x05, 0xF9, 0x0B, 0x80, 0xAA, 0x50, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62,
  0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF,
  0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x3F, 0xFF, 0xC0, 0x63, 0x81, 0x28, 0xEF, 0xFD, 0x81,
  0xE9, 0x27, 0x06, 0x0C, 0xFF, 0x90, 0xD0, 0x67, 0x50, 0x30, 0xDF, 0xC0, 0xE0, 0x47, 0x71, 0x0C,
  0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7,
  0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF,
  0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77,
  0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC,
  0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72,
  0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0,
  0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20,
  0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D,
  0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C,
  0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7,
  0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF,
  0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77,
  0x10, 0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x48, 0x11, 0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x60, 0x30, 0xAF,
  0xFF, 0x0A, 0x04, 0x30, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0,
  0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F,
  0xFF, 0xC0, 0x60,
  // "Í" (U+00CD)
  0x77, 0x10, 0x6F, 0xE0, 0xB7, 0x71, 0x0E, 0xFE, 0x03, 0x77, 0x08, 0xFE, 0x05, 0x77, 0x02, 0xFE,
  0x06, 0x77, 0x10, 0xBF, 0xD0, 0x67, 0x71, 0x05, 0xFD, 0x06, 0x77, 0x10, 0x10, 0xEF, 0xC0, 0x67,
  0x72, 0x0A, 0xFC, 0x05, 0x77, 0x20, 0x6F, 0xC0, 0x57, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x77,
  0x30, 0xBF, 0xA0, 0xE0, 0x37, 0x73, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x30, 0x2F, 0xA0, 0xC0, 0x17,
  0x74, 0x06, 0xF9, 0x0A, 0x80, 0xAB, 0x70, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63,
  0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF,
  0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x3F, 0xFF, 0xC0, 0x64, 0x81, 0x28, 0xEF, 0xFD, 0x81,
  0xE9, 0x27, 0x10, 0x60, 0xCF, 0xF9, 0x0D, 0x06, 0x76, 0x03, 0x0D, 0xFC, 0x0E, 0x04, 0x77, 0x20,
  0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D,
  0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C,
  0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7,
  0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF,
  0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77,
  0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC,
  0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73,
  0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0,
  0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30,
  0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D,
  0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C,
  0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7,
  0x72, 0x05, 0x0E, 0xFC, 0x0E, 0x05, 0x75, 0x81, 0x17, 0xDF, 0xF9, 0x81, 0xE8, 0x27, 0x03, 0x0A,
  0xFF, 0xF0, 0xA0, 0x44, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC,
  0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04,
  0xFF, 0xFC, 0x06, 0x30,
  // "Î" (U+00CE)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x74, 0x09, 0xFD, 0x0B, 0x77, 0x30, 0x3F, 0xF0, 0x47, 0x72,
  0x0C, 0xFF, 0x0D, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x76, 0x03, 0xFF, 0xC0, 0x37, 0x50, 0xDF, 0xFC,
  0x0D, 0x74, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x20, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x70,
  0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x60, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x50,
  0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x98, 0x26,
  0x02, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xAB, 0x60, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC,
  0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04,
  0xFF, 0xFC, 0x06, 0x50, 0x3F, 0xFF, 0xC0, 0x66, 0x81, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x27, 0x30,
  0x60, 0xCF, 0xF9, 0x0D, 0x06, 0x77, 0x10, 0x30, 0xDF, 0xC0, 0xE0, 0x47, 0x74, 0x0C, 0xFC, 0x0D,
  0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C,
  0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7,
  0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF,
  0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77,
  0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC,
  0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75,
  0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0,
  0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50,
  0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D,
  0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C,
  0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7,
  0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x40, 0x50,
  0xEF, 0xC0, 0xE0, 0x57, 0x78, 0x11, 0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x72, 0x03, 0x0A, 0xFF, 0xF0,
  0xA0, 0x46, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50,
  0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC,
  0x06, 0x30,
  // "Ï" (U+00CF)
  0x38, 0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x64, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC3, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x98, 0x1A, 0x03, 0xFB, 0x04, 0x50,
  0x7F, 0xB0, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x70,
  0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x00, 0x7F, 0xB0, 0x85, 0x0C, 0xFB, 0x06, 0x04, 0xFB, 0x04, 0x50,
  0x8F, 0xB8, 0x12, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA2, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC0, 0x14, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80,
  0xAD, 0x60, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20,
  0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC,
  0x06, 0x20, 0x3F, 0xFF, 0xC0, 0x63, 0x81, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x27, 0x06, 0x0C, 0xFF,
  0x90, 0xD0, 0x67, 0x50, 0x30, 0xDF, 0xC0, 0xE0, 0x47, 0x71, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF,
  0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77,
  0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC,
  0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72,
  0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0,
  0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20,
  0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D,
  0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C,
  0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7,
  0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF,
  0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77,
  0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC,
  0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x72, 0x0C, 0xFC, 0x0D, 0x77, 0x10, 0x50, 0xEF, 0xC0, 0xE0,
  0x57, 0x48, 0x11, 0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x60, 0x30, 0xAF, 0xFF, 0x0A, 0x04, 0x30, 0x4F,
  0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06,
  0x20, 0x4F, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFC, 0x06, 0x20, 0x4F, 0xFF, 0xC0, 0x61,
  // "Ð" (U+00D0)
  0x50, 0x8F, 0xFC, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x30, 0x8F, 0xFF, 0xC8, 0x1D, 0x83, 0x77,
  0x70, 0x8F, 0xFF, 0xF0, 0xD0, 0x57, 0x75, 0x08, 0xFF, 0xFF, 0xA0, 0xD0, 0x57, 0x73, 0x08, 0xFF,
  0xFF, 0xC0, 0xA0, 0x17, 0x71, 0x08, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x70, 0x8F, 0xFF, 0xFF, 0x04,
  0x76, 0x08, 0x80, 0xC0, 0xF0, 0x47, 0x50, 0x88, 0x0C, 0x1F, 0x03, 0x74, 0x08, 0x80, 0xC1, 0xF0,
  0xD0, 0x17, 0x30, 0x88, 0x0C, 0x2F, 0x0B, 0x73, 0x08, 0xFD, 0x02, 0x58, 0x21, 0x37, 0xBF, 0xFB,
  0x05, 0x72, 0x08, 0xFD, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0x90, 0xE7, 0x20, 0x8F, 0xD0, 0x27, 0x40,
  0x40, 0xEF, 0xF0, 0x67, 0x10, 0x8F, 0xD0, 0x27, 0x50, 0x20, 0xEF, 0xE0, 0xD7, 0x10, 0x8F, 0xD0,
  0x27, 0x60, 0x3F, 0xF0, 0x57, 0x08, 0xFD, 0x02, 0x77, 0x07, 0xFE, 0x0B, 0x70, 0x8F, 0xD0, 0x27,
  0x71, 0x0D, 0xFE, 0x01, 0x60, 0x8F, 0xD0, 0x27, 0x71, 0x06, 0xFE, 0x05, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x0E, 0xFD, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x72, 0x09, 0xFD, 0x0D, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x05, 0xFE, 0x01, 0x50, 0x8F, 0xD0, 0x27, 0x72, 0x01, 0xFE, 0x03, 0x50, 0x8F, 0xD0, 0x27,
  0x73, 0x0D, 0xFD, 0x06, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0x0A, 0xFD, 0x08, 0x50, 0x8F, 0xD0, 0x27,
  0x73, 0x08, 0xFD, 0x09, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x07, 0xFD, 0x0B, 0x0E, 0xFF, 0xFC, 0x04,
  0x72, 0x05, 0xFD, 0x0C, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x04, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04,
  0x72, 0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x03, 0xFD, 0x00, 0xEF, 0xFF, 0xC0, 0x47,
  0x20, 0x3F, 0xD0, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72,
  0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x04, 0xFD, 0x0C, 0x0E, 0xFF, 0xFC, 0x04, 0x72,
  0x05, 0xFD, 0x0B, 0x80, 0x12, 0x09, 0xFD, 0x04, 0x80, 0x32, 0x73, 0x06, 0xFD, 0x0A, 0x50, 0x8F,
  0xD0, 0x27, 0x73, 0x08, 0xFD, 0x08, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0x0A, 0xFD, 0x07, 0x50, 0x8F,
  0xD0, 0x27, 0x73, 0x0D, 0xFD, 0x04, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0xFE, 0x02, 0x50, 0x8F, 0xD0,
  0x27, 0x72, 0x03, 0xFE, 0x60, 0x8F, 0xD0, 0x27, 0x72, 0x08, 0xFD, 0x0B, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x0D, 0xFD, 0x07, 0x60, 0x8F, 0xD0, 0x27, 0x71, 0x03, 0xFE, 0x04, 0x60, 0x8F, 0xD0, 0x27,
  0x71, 0x0A, 0xFD, 0x0E, 0x70, 0x8F, 0xD0, 0x27, 0x70, 0x2F, 0xE0, 0x97, 0x08, 0xFD, 0x02, 0x77,
  0x0B, 0xFE, 0x04, 0x70, 0x8F, 0xD0, 0x27, 0x60, 0x8F, 0xE0, 0xD7, 0x10, 0x8F, 0xD0, 0x27, 0x50,
  0x6F, 0xF0, 0x67, 0x10, 0x8F, 0xD0, 0x27, 0x40, 0x9F, 0xF0, 0xE7, 0x20, 0x8F, 0xD0, 0x27, 0x20,
  0x50, 0xDF, 0xF9, 0x05, 0x72, 0x08, 0xFD, 0x02, 0x48, 0x31, 0x35, 0x9E, 0xFF, 0xA0, 0xB7, 0x30,
  0x88, 0x0C, 0x1F, 0x0E, 0x02, 0x73, 0x08, 0x80, 0xC1, 0xF0, 0x57, 0x40, 0x88, 0x0C, 0x0F, 0x08,
  0x75, 0x08, 0xFF, 0xFF, 0xF0, 0x97, 0x60, 0x8F, 0xFF, 0xFE, 0x09, 0x77, 0x08, 0xFF, 0xFF, 0xD0,
  0x67, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0xC0, 0x37, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x77, 0x74,
  0x08, 0xFF, 0xFE, 0x0D, 0x07, 0x77, 0x60, 0x8F, 0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x71, 0x08, 0xFF,
  0xB8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x60,
  // "Ñ" (U+00D1)
  0x77, 0x86, 0x5A, 0xDF, 0xEC, 0x94, 0x74, 0x06, 0xE7, 0x77, 0x01, 0x0C, 0xF9, 0x0D, 0x05, 0x72,
  0x0B, 0xE7, 0x76, 0x01, 0x0D, 0xFC, 0x0D, 0x06, 0x60, 0x3E, 0x0D, 0x77, 0x60, 0xAF, 0xF8, 0x5E,
  0x83, 0x10, 0x4E, 0xE0, 0xB7, 0x75, 0x04, 0xFF, 0xFF, 0x08, 0x77, 0x50, 0xCF, 0xFF, 0xF0, 0x57,
  0x74, 0x02, 0xFF, 0xFF, 0x0E, 0x77, 0x50, 0x7F, 0xFF, 0xF0, 0x97, 0x75, 0x0A, 0xFF, 0xFE, 0x0E,
  0x01, 0x77, 0x50, 0xEE, 0x84, 0xD3, 0x01, 0x5B, 0xFF, 0x90, 0x67, 0x75, 0x01, 0xE0, 0xE0, 0x15,
  0x03, 0x0A, 0xFD, 0x08, 0x77, 0x60, 0x3E, 0x07, 0x71, 0x81, 0x29, 0xEF, 0x90, 0x77, 0x77, 0x05,
  0xE0, 0x27, 0x48, 0x65, 0xAD, 0xEE, 0xC8, 0x28, 0x0B, 0xF7, 0x00, 0x8F, 0xF0, 0xD7, 0x76, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0x90, 0x67, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0x90, 0xD7, 0x75, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0xA0, 0x57, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xA0, 0xC7, 0x74, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0xB0, 0x47, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xB0, 0xC7, 0x73, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0xC0, 0x47, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xC0, 0xB7, 0x72, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0xD0, 0x37, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xD0, 0xA7, 0x71, 0x02,
  0xFC, 0x0B, 0x08, 0xFF, 0xE0, 0x27, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xFE, 0x09, 0x77, 0x02, 0xFC,
  0x0B, 0x08, 0xFF, 0xF0, 0x27, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x09, 0x76, 0x02, 0xFC, 0x0B,
  0x08, 0xFF, 0xF9, 0x01, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x08, 0x75, 0x02, 0xFC, 0x0B,
  0x08, 0xFF, 0xF9, 0x0E, 0x01, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0xFD, 0x07, 0x74, 0x02,
  0xFC, 0x0B, 0x08, 0xFB, 0x07, 0x0D, 0xFC, 0x0E, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x08, 0x06,
  0xFD, 0x07, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x81, 0x90, 0xDF, 0xC0, 0xD7, 0x30, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB8, 0x1A, 0x07, 0xFD, 0x06, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0B, 0x20, 0xEF,
  0xC0, 0xD7, 0x20, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xC2, 0x07, 0xFD, 0x05, 0x71, 0x02, 0xFC, 0x0B,
  0x08, 0xFB, 0x0D, 0x20, 0x10, 0xEF, 0xC0, 0xC7, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xE3, 0x08,
  0xFD, 0x04, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xE3, 0x01, 0xFD, 0x0C, 0x70, 0x2F, 0xC0, 0xB0,
  0x8F, 0xC4, 0x09, 0xFD, 0x04, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xC4, 0x02, 0xFD, 0x0B, 0x60, 0x2F,
  0xC0, 0xB0, 0x8F, 0xC5, 0x09, 0xFD, 0x03, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xC0, 0x14, 0x02, 0xFD,
  0x0A, 0x50, 0x1F, 0xC0, 0xB0, 0x8F, 0xC0, 0x15, 0x0A, 0xFD, 0x02, 0x40, 0x1F, 0xC0, 0xB0, 0x8F,
  0xC0, 0x25, 0x03, 0xFD, 0x09, 0x5F, 0xC0, 0xB0, 0x8F, 0xC0, 0x26, 0x0B, 0xFD, 0x02, 0x4F, 0xC0,
  0xB0, 0x8F, 0xC0, 0x26, 0x03, 0xFD, 0x09, 0x40, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x0C, 0xFD,
  0x01, 0x30, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x04, 0xFD, 0x08, 0x30, 0xDF, 0xB0, 0xB0, 0x8F,
  0xC0, 0x27, 0x10, 0xCF, 0xC0, 0xE0, 0x12, 0x0C, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x71, 0x05, 0xFD,
  0x07, 0x20, 0xBF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x20, 0xDF, 0xC0, 0xE2, 0x0B, 0xFB, 0x0B, 0x08,
  0xFC, 0x02, 0x72, 0x06, 0xFD, 0x81, 0x70, 0xAF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x30, 0xDF, 0xC8,
  0x1D, 0x09, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x73, 0x06, 0xFD, 0x06, 0x09, 0xFB, 0x0B, 0x08, 0xFC,
  0x02, 0x74, 0x0E, 0xFC, 0x0D, 0x08, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74, 0x07, 0xFD, 0x0E, 0xFB,
  0x0B, 0x08, 0xFC, 0x02, 0x74, 0x01, 0x0E, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x75, 0x08, 0xFF,
  0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x75, 0x01, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x76, 0x09, 0xFF,
  0xF0, 0xB0, 0x8F, 0xC0, 0x27, 0x60, 0x1F, 0xFF, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x09, 0xFF, 0xE0,
  0xB0, 0x8F, 0xC0, 0x27, 0x70, 0x2F, 0xFE, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x10, 0xAF, 0xFD, 0x0B,
  0x08, 0xFC, 0x02, 0x77, 0x10, 0x3F, 0xFD, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x20, 0xBF, 0xFC, 0x0B,
  0x08, 0xFC, 0x02, 0x77, 0x20, 0x3F, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x30, 0xBF, 0xFB, 0x0B,
  0x08, 0xFC, 0x02, 0x77, 0x30, 0x4F, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x40, 0xCF, 0xFA, 0x0B,
  0x08, 0xFC, 0x02, 0x77, 0x40, 0x5F, 0xFA, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x50, 0xDF, 0xF9, 0x0B,
  0x08, 0xFC, 0x02, 0x77, 0x50, 0x6F, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x60, 0xDF, 0xF0, 0xB0,
  // "Ò" (U+00D2)
  0x73, 0x03, 0x80, 0x91, 0x70, 0x48, 0x0C, 0x00, 0x04, 0xFE, 0x0E, 0x80, 0xC1, 0x00, 0x8F, 0xE0,
  0x78, 0x0C, 0x10, 0x09, 0xFD, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0xAF, 0xD0, 0xA8, 0x0C, 0x20, 0x0B,
  0xFD, 0x04, 0x80, 0xC2, 0x00, 0xBF, 0xC0, 0xD8, 0x0C, 0x30, 0x0B, 0xFC, 0x08, 0x80, 0xC3, 0x00,
  0xBF, 0xC0, 0x28, 0x0C, 0x30, 0x0B, 0xFB, 0x0C, 0x80, 0xC4, 0x00, 0xAF, 0xB0, 0x78, 0x0C, 0x40,
  0x0A, 0xFB, 0x02, 0x80, 0xC4, 0x00, 0x9F, 0xA0, 0xC8, 0x0C, 0x50, 0x07, 0xFA, 0x07, 0x80, 0xC5,
  0x00, 0x5F, 0x90, 0xB8, 0x0B, 0xD4, 0x08, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85, 0x27,
  0x77, 0x75, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C, 0x03,
  0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0A, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x37,
  0x75, 0x08, 0xFF, 0xFF, 0xB0, 0x57, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF, 0xFF,
  0xF0, 0x47, 0x60, 0x48, 0x0C, 0x0F, 0x0E, 0x02, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7, 0x40,
  0xA8, 0x0C, 0x3F, 0x06, 0x72, 0x03, 0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9, 0x0E,
  0x01, 0x71, 0x0B, 0xFF, 0x0D, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7, 0x60,
  0xBF, 0xE0, 0xE7, 0x09, 0xFE, 0x0D, 0x77, 0x10, 0xCF, 0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02, 0x77,
  0x10, 0x2F, 0xE0, 0xD5, 0x05, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01, 0x77,
  0x30, 0x1F, 0xE0, 0x74, 0x0E, 0xFD, 0x0A, 0x77, 0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77,
  0x50, 0x5F, 0xE0, 0x12, 0x07, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77,
  0x70, 0xCF, 0xD0, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77, 0x70,
  0x6F, 0xD8, 0x1D, 0x02, 0xFE, 0x02, 0x77, 0x70, 0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE,
  0x01, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x03, 0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04,
  0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06,
  0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07,
  0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08,
  0x09, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07,
  0x08, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05,
  0x06, 0xFD, 0x0B, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02, 0x03,
  0xFE, 0x77, 0x71, 0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x17, 0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF, 0xD0,
  0x47, 0x77, 0x06, 0xFD, 0x0D, 0x20, 0xCF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F, 0xD0,
  0xA7, 0x77, 0x0C, 0xFD, 0x06, 0x20, 0x5F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F, 0xE0,
  0x47, 0x75, 0x05, 0xFE, 0x40, 0xDF, 0xD0, 0x97, 0x75, 0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0, 0xE0,
  0x17, 0x73, 0x02, 0xFE, 0x06, 0x40, 0x4F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF, 0xE0,
  0x27, 0x71, 0x03, 0xFE, 0x0C, 0x60, 0x8F, 0xE0, 0xC7, 0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F, 0xF0,
  0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x10, 0x9F, 0xF0, 0xD0, 0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87, 0x10,
  0x20, 0xEF, 0xF9, 0x81, 0xB6, 0x23, 0x81, 0x36, 0xBF, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC3,
  0xF0, 0x57, 0x40, 0xD8, 0x0C, 0x1F, 0x0B, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x60,
  0x4F, 0xFF, 0xFF, 0x03, 0x77, 0x10, 0x6F, 0xFF, 0xFD, 0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA, 0x0E,
  0x04, 0x77, 0x50, 0x40, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09, 0x01,
  0x77, 0x73, 0x04, 0x0C, 0xFF, 0xF0, 0xB0, 0x37, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D, 0x82,
  0x77, 0x77, 0x58, 0x43, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x27, 0x74,
  // "Ó" (U+00D3)
  0x77, 0x76, 0x06, 0xFE, 0x0B, 0x80, 0xC0, 0x00, 0xEF, 0xE0, 0x37, 0x77, 0x77, 0x08, 0xFE, 0x05,
  0x77, 0x77, 0x70, 0x2F, 0xE0, 0x68, 0x0C, 0x00, 0x0B, 0xFD, 0x06, 0x80, 0xC0, 0x00, 0x5F, 0xD0,
  0x68, 0x0C, 0x00, 0x01, 0x0E, 0xFC, 0x06, 0x80, 0xC1, 0x00, 0xAF, 0xC0, 0x58, 0x0C, 0x10, 0x06,
  0xFC, 0x05, 0x80, 0xC1, 0x00, 0x10, 0xEF, 0xA0, 0xE0, 0x48, 0x0C, 0x20, 0x0B, 0xFA, 0x0E, 0x03,
  0x80, 0xC2, 0x00, 0x7F, 0xA0, 0xD0, 0x28, 0x0C, 0x20, 0x02, 0xFA, 0x0C, 0x01, 0x80, 0xC3, 0x00,
  0x6F, 0x90, 0xA8, 0x0B, 0xE0, 0x08, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85, 0x27, 0x77,
  0x75, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C, 0x03, 0x77,
  0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0A, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x75,
  0x08, 0xFF, 0xFF, 0xB0, 0x57, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF, 0xFF, 0xF0,
  0x47, 0x60, 0x48, 0x0C, 0x0F, 0x0E, 0x02, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7, 0x40, 0xA8,
  0x0C, 0x3F, 0x06, 0x72, 0x03, 0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9, 0x0E, 0x01,
  0x71, 0x0B, 0xFF, 0x0D, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7, 0x60, 0xBF,
  0xE0, 0xE7, 0x09, 0xFE, 0x0D, 0x77, 0x10, 0xCF, 0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02, 0x77, 0x10,
  0x2F, 0xE0, 0xD5, 0x05, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01, 0x77, 0x30,
  0x1F, 0xE0, 0x74, 0x0E, 0xFD, 0x0A, 0x77, 0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77, 0x50,
  0x5F, 0xE0, 0x12, 0x07, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77, 0x70,
  0xCF, 0xD0, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77, 0x70, 0x6F,
  0xD8, 0x1D, 0x02, 0xFE, 0x02, 0x77, 0x70, 0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x01,
  0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x03, 0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x08,
  0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x09,
  0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A,
  0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x09,
  0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x08,
  0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05, 0x06,
  0xFD, 0x0B, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02, 0x03, 0xFE,
  0x77, 0x71, 0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x17, 0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0x47,
  0x77, 0x06, 0xFD, 0x0D, 0x20, 0xCF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F, 0xD0, 0xA7,
  0x77, 0x0C, 0xFD, 0x06, 0x20, 0x5F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F, 0xE0, 0x47,
  0x75, 0x05, 0xFE, 0x40, 0xDF, 0xD0, 0x97, 0x75, 0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0, 0xE0, 0x17,
  0x73, 0x02, 0xFE, 0x06, 0x40, 0x4F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF, 0xE0, 0x27,
  0x71, 0x03, 0xFE, 0x0C, 0x60, 0x8F, 0xE0, 0xC7, 0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F, 0xF0, 0xB7,
  0x60, 0xBF, 0xE0, 0xE7, 0x10, 0x9F, 0xF0, 0xD0, 0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87, 0x10, 0x20,
  0xEF, 0xF9, 0x81, 0xB6, 0x23, 0x81, 0x36, 0xBF, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC3, 0xF0,
  0x57, 0x40, 0xD8, 0x0C, 0x1F, 0x0B, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x60, 0x4F,
  0xFF, 0xFF, 0x03, 0x77, 0x10, 0x6F, 0xFF, 0xFD, 0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA, 0x0E, 0x04,
  0x77, 0x50, 0x40, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09, 0x01, 0x77,
  0x73, 0x04, 0x0C, 0xFF, 0xF0, 0xB0, 0x37, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D, 0x82, 0x77,
  0x77, 0x58, 0x43, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x27, 0x74,
  // "Ô" (U+00D4)
  0x77, 0x40, 0x18, 0x09, 0x07, 0x02, 0x80, 0xC1, 0x00, 0x9F, 0xD0, 0xB8, 0x0C, 0x00, 0x03, 0xFF,
  0x04, 0x77, 0x77, 0x70, 0xCF, 0xF0, 0xD7, 0x77, 0x76, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x74, 0x03,
  0xFF, 0xC0, 0x37, 0x77, 0x73, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x72, 0x09, 0xFA, 0x00, 0xEF, 0xA0,
  0x97, 0x77, 0x70, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x77, 0x75, 0x01, 0x0E, 0xFA, 0x04, 0x20,
  0x4F, 0xA0, 0xE0, 0x27, 0x77, 0x40, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x77, 0x73, 0x08, 0xFA,
  0x04, 0x60, 0x4F, 0xA0, 0x97, 0x77, 0x10, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67,
  0x76, 0x02, 0x0E, 0xF0, 0xE0, 0x37, 0x30, 0x20, 0xDF, 0x90, 0x37, 0x75, 0x06, 0xF0, 0xC0, 0x17,
  0x50, 0x10, 0xBF, 0x07, 0x80, 0xBC, 0x40, 0x89, 0x52, 0x69, 0xBD, 0xEE, 0xFE, 0xDC, 0xB8, 0x52,
  0x77, 0x77, 0x58, 0x13, 0x9E, 0xFF, 0x98, 0x1E, 0x82, 0x77, 0x77, 0x05, 0x0D, 0xFF, 0xF0, 0xC0,
  0x37, 0x77, 0x30, 0x20, 0xCF, 0xFF, 0xC0, 0xA0, 0x17, 0x77, 0x06, 0x0E, 0xFF, 0xFE, 0x0E, 0x03,
  0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x05, 0x77, 0x30, 0x9F, 0xFF, 0xFD, 0x06, 0x77, 0x10, 0x7F, 0xFF,
  0xFF, 0x04, 0x76, 0x04, 0x80, 0xC0, 0xF0, 0xE0, 0x27, 0x40, 0x10, 0xE8, 0x0C, 0x1F, 0x0C, 0x74,
  0x0A, 0x80, 0xC3, 0xF0, 0x67, 0x20, 0x3F, 0xFA, 0x82, 0xB6, 0x31, 0x28, 0x12, 0x6B, 0xFF, 0x90,
  0xE0, 0x17, 0x10, 0xBF, 0xF0, 0xD0, 0x47, 0x20, 0x30, 0xDF, 0xF0, 0x87, 0x03, 0xFF, 0x0B, 0x76,
  0x0B, 0xFE, 0x0E, 0x70, 0x9F, 0xE0, 0xD7, 0x71, 0x0C, 0xFE, 0x06, 0x50, 0x10, 0xEF, 0xE0, 0x27,
  0x71, 0x02, 0xFE, 0x0D, 0x50, 0x5F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x40, 0xAF, 0xE0, 0x17,
  0x73, 0x01, 0xFE, 0x07, 0x40, 0xEF, 0xD0, 0xA7, 0x75, 0x0A, 0xFD, 0x0C, 0x30, 0x3F, 0xE0, 0x47,
  0x75, 0x05, 0xFE, 0x01, 0x20, 0x7F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x04, 0x20, 0xAF, 0xD0, 0xB7,
  0x77, 0x0C, 0xFD, 0x07, 0x20, 0xDF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x0A, 0x2F, 0xE0, 0x47, 0x77,
  0x06, 0xFD, 0x81, 0xD0, 0x2F, 0xE0, 0x27, 0x77, 0x03, 0xFE, 0x10, 0x4F, 0xE7, 0x77, 0x10, 0x1F,
  0xE0, 0x10, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x30, 0x7F, 0xD0, 0xC7, 0x77, 0x20, 0xEF, 0xD0,
  0x40, 0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xD0, 0x60, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xCF, 0xD0,
  0x60, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xBF, 0xD0,
  0x70, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF, 0xD0, 0x80, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF, 0xD0,
  0x80, 0x9F, 0xD0, 0x87, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xD0,
  0x70, 0x8F, 0xD0, 0x97, 0x77, 0x20, 0xCF, 0xD0, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xD0,
  0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x20, 0xEF, 0xD0, 0x40, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x20,
  0x3F, 0xE7, 0x77, 0x10, 0x1F, 0xE0, 0x01, 0xFE, 0x01, 0x77, 0x70, 0x3F, 0xD0, 0xE2, 0x0E, 0xFD,
  0x04, 0x77, 0x70, 0x6F, 0xD0, 0xD2, 0x0C, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0x92, 0x09, 0xFD,
  0x0A, 0x77, 0x70, 0xCF, 0xD0, 0x62, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x32, 0x02, 0xFE,
  0x04, 0x77, 0x50, 0x5F, 0xE4, 0x0D, 0xFD, 0x09, 0x77, 0x50, 0xBF, 0xD0, 0xB4, 0x08, 0xFD, 0x0E,
  0x01, 0x77, 0x30, 0x2F, 0xE0, 0x64, 0x04, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x25, 0x0E, 0xFE,
  0x02, 0x77, 0x10, 0x3F, 0xE0, 0xC6, 0x08, 0xFE, 0x0C, 0x77, 0x10, 0xDF, 0xE0, 0x66, 0x01, 0xFF,
  0x0B, 0x76, 0x0B, 0xFE, 0x0E, 0x71, 0x09, 0xFF, 0x0D, 0x03, 0x72, 0x04, 0x0D, 0xFF, 0x08, 0x71,
  0x02, 0x0E, 0xFF, 0x98, 0x1B, 0x62, 0x38, 0x13, 0x6B, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C,
  0x3F, 0x05, 0x74, 0x0D, 0x80, 0xC1, 0xF0, 0xB7, 0x50, 0x20, 0xEF, 0xFF, 0xFF, 0x0E, 0x02, 0x76,
  0x04, 0xFF, 0xFF, 0xF0, 0x37, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x57, 0x73, 0x05, 0xFF, 0xFF, 0xA0,
  0xE0, 0x47, 0x75, 0x04, 0x0E, 0xFF, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x10, 0xBF, 0xFF, 0xC0, 0x90,
  0x17, 0x77, 0x30, 0x40, 0xCF, 0xFF, 0x0B, 0x03, 0x77, 0x77, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xD8,
  0x27, 0x77, 0x75, 0x84, 0x36, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x52, 0x77, 0x40,
  // "Õ" (U+00D5)
  0x77, 0x18, 0x65, 0xAD, 0xFE, 0xC9, 0x47, 0x40, 0x6E, 0x77, 0x72, 0x01, 0x0C, 0xF9, 0x0D, 0x05,
  0x72, 0x0B, 0xE7, 0x77, 0x10, 0x10, 0xDF, 0xC0, 0xD0, 0x66, 0x03, 0xE0, 0xD7, 0x77, 0x10, 0xAF,
  0xF8, 0x5E, 0x83, 0x10, 0x4E, 0xE0, 0xB7, 0x77, 0x04, 0xFF, 0xFF, 0x08, 0x77, 0x70, 0xCF, 0xFF,
  0xF0, 0x57, 0x76, 0x02, 0xFF, 0xFF, 0x0E, 0x77, 0x70, 0x7F, 0xFF, 0xF0, 0x97, 0x77, 0x0A, 0xFF,
  0xFE, 0x0E, 0x01, 0x77, 0x70, 0xEE, 0x84, 0xD3, 0x01, 0x5B, 0xFF, 0x90, 0x67, 0x77, 0x01, 0xE0,
  0xE0, 0x15, 0x03, 0x0A, 0xFD, 0x08, 0x77, 0x71, 0x03, 0xE0, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x07,
  0x77, 0x72, 0x05, 0xE0, 0x27, 0x48, 0x65, 0xAD, 0xEE, 0xC8, 0x28, 0x0B, 0xD1, 0x08, 0x95, 0x26,
  0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85, 0x27, 0x77, 0x75, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xE8, 0x27,
  0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C, 0x03, 0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0A, 0x01, 0x77,
  0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x75, 0x08, 0xFF, 0xFF, 0xB0, 0x57, 0x73, 0x09, 0xFF,
  0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF, 0xFF, 0xF0, 0x47, 0x60, 0x48, 0x0C, 0x0F, 0x0E, 0x02, 0x74,
  0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7, 0x40, 0xA8, 0x0C, 0x3F, 0x06, 0x72, 0x03, 0xFF, 0xA8, 0x2B,
  0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9, 0x0E, 0x01, 0x71, 0x0B, 0xFF, 0x0D, 0x04, 0x72, 0x03, 0x0D,
  0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x09, 0xFE, 0x0D, 0x77, 0x10, 0xCF,
  0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02, 0x77, 0x10, 0x2F, 0xE0, 0xD5, 0x05, 0xFE, 0x08, 0x77, 0x30,
  0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01, 0x77, 0x30, 0x1F, 0xE0, 0x74, 0x0E, 0xFD, 0x0A, 0x77, 0x50,
  0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77, 0x50, 0x5F, 0xE0, 0x12, 0x07, 0xFD, 0x0E, 0x77, 0x60,
  0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77, 0x70, 0xCF, 0xD0, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x70,
  0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77, 0x70, 0x6F, 0xD8, 0x1D, 0x02, 0xFE, 0x02, 0x77, 0x70, 0x3F,
  0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x01, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x03, 0x07,
  0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x06, 0x09,
  0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A,
  0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x0A,
  0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x09, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x09,
  0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x08, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x08,
  0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0B, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x05,
  0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x17,
  0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0x47, 0x77, 0x06, 0xFD, 0x0D, 0x20, 0xCF, 0xD0, 0x77,
  0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F, 0xD0, 0xA7, 0x77, 0x0C, 0xFD, 0x06, 0x20, 0x5F, 0xD0, 0xE7,
  0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F, 0xE0, 0x47, 0x75, 0x05, 0xFE, 0x40, 0xDF, 0xD0, 0x97, 0x75,
  0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFE, 0x06, 0x40, 0x4F, 0xE0, 0x87,
  0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF, 0xE0, 0x27, 0x71, 0x03, 0xFE, 0x0C, 0x60, 0x8F, 0xE0, 0xC7,
  0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x10, 0x9F, 0xF0, 0xD0,
  0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87, 0x10, 0x20, 0xEF, 0xF9, 0x81, 0xB6, 0x23, 0x81, 0x36, 0xBF,
  0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC3, 0xF0, 0x57, 0x40, 0xD8, 0x0C, 0x1F, 0x0B, 0x75, 0x02,
  0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x60, 0x4F, 0xFF, 0xFF, 0x03, 0x77, 0x10, 0x6F, 0xFF, 0xFD,
  0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x50, 0x40, 0xEF, 0xFF, 0xE0, 0xE0, 0x37,
  0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09, 0x01, 0x77, 0x73, 0x04, 0x0C, 0xFF, 0xF0, 0xB0, 0x37, 0x77,
  0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D, 0x82, 0x77, 0x77, 0x58, 0x43, 0x69, 0xBD, 0xEA, 0x85, 0xED,
  0xCB, 0x85, 0x27, 0x74,
  // "Ö" (U+00D6)
  0x77, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x75, 0x02, 0x0D, 0xE0,
  0xD0, 0x27, 0x04, 0x0E, 0xE0, 0xC7, 0x77, 0x40, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x77,
  0x72, 0x03, 0xFB, 0x04, 0x50, 0x7F, 0xB0, 0x17, 0x77, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05,
  0x77, 0x71, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x77, 0x77, 0x10, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB,
  0x07, 0x77, 0x71, 0x07, 0xFB, 0x08, 0x50, 0xCF, 0xB0, 0x67, 0x77, 0x10, 0x4F, 0xB0, 0x45, 0x08,
  0xFB, 0x02, 0x77, 0x72, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA7, 0x77, 0x30, 0x20, 0xDE,
  0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x77, 0x75, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51,
  0x8D, 0xFE, 0xC6, 0x80, 0xCB, 0x30, 0x89, 0x52, 0x69, 0xBD, 0xEE, 0xFE, 0xDC, 0xB8, 0x52, 0x77,
  0x77, 0x58, 0x13, 0x9E, 0xFF, 0x98, 0x1E, 0x82, 0x77, 0x77, 0x05, 0x0D, 0xFF, 0xF0, 0xC0, 0x37,
  0x77, 0x30, 0x20, 0xCF, 0xFF, 0xC0, 0xA0, 0x17, 0x77, 0x06, 0x0E, 0xFF, 0xFE, 0x0E, 0x03, 0x77,
  0x50, 0x8F, 0xFF, 0xFB, 0x05, 0x77, 0x30, 0x9F, 0xFF, 0xFD, 0x06, 0x77, 0x10, 0x7F, 0xFF, 0xFF,
  0x04, 0x76, 0x04, 0x80, 0xC0, 0xF0, 0xE0, 0x27, 0x40, 0x10, 0xE8, 0x0C, 0x1F, 0x0C, 0x74, 0x0A,
  0x80, 0xC3, 0xF0, 0x67, 0x20, 0x3F, 0xFA, 0x82, 0xB6, 0x31, 0x28, 0x12, 0x6B, 0xFF, 0x90, 0xE0,
  0x17, 0x10, 0xBF, 0xF0, 0xD0, 0x47, 0x20, 0x30, 0xDF, 0xF0, 0x87, 0x03, 0xFF, 0x0B, 0x76, 0x0B,
  0xFE, 0x0E, 0x70, 0x9F, 0xE0, 0xD7, 0x71, 0x0C, 0xFE, 0x06, 0x50, 0x10, 0xEF, 0xE0, 0x27, 0x71,
  0x02, 0xFE, 0x0D, 0x50, 0x5F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x40, 0xAF, 0xE0, 0x17, 0x73,
  0x01, 0xFE, 0x07, 0x40, 0xEF, 0xD0, 0xA7, 0x75, 0x0A, 0xFD, 0x0C, 0x30, 0x3F, 0xE0, 0x47, 0x75,
  0x05, 0xFE, 0x01, 0x20, 0x7F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x04, 0x20, 0xAF, 0xD0, 0xB7, 0x77,
  0x0C, 0xFD, 0x07, 0x20, 0xDF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x0A, 0x2F, 0xE0, 0x47, 0x77, 0x06,
  0xFD, 0x81, 0xD0, 0x2F, 0xE0, 0x27, 0x77, 0x03, 0xFE, 0x10, 0x4F, 0xE7, 0x77, 0x10, 0x1F, 0xE0,
  0x10, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x30, 0x7F, 0xD0, 0xC7, 0x77, 0x20, 0xEF, 0xD0, 0x40,
  0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xD0, 0x60, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xCF, 0xD0, 0x60,
  0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xBF, 0xD0, 0x70,
  0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF, 0xD0, 0x80, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF, 0xD0, 0x80,
  0x9F, 0xD0, 0x87, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xD0, 0x70,
  0x8F, 0xD0, 0x97, 0x77, 0x20, 0xCF, 0xD0, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xD0, 0x50,
  0x6F, 0xD0, 0xB7, 0x77, 0x20, 0xEF, 0xD0, 0x40, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x20, 0x3F,
  0xE7, 0x77, 0x10, 0x1F, 0xE0, 0x01, 0xFE, 0x01, 0x77, 0x70, 0x3F, 0xD0, 0xE2, 0x0E, 0xFD, 0x04,
  0x77, 0x70, 0x6F, 0xD0, 0xD2, 0x0C, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0x92, 0x09, 0xFD, 0x0A,
  0x77, 0x70, 0xCF, 0xD0, 0x62, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x32, 0x02, 0xFE, 0x04,
  0x77, 0x50, 0x5F, 0xE4, 0x0D, 0xFD, 0x09, 0x77, 0x50, 0xBF, 0xD0, 0xB4, 0x08, 0xFD, 0x0E, 0x01,
  0x77, 0x30, 0x2F, 0xE0, 0x64, 0x04, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x25, 0x0E, 0xFE, 0x02,
  0x77, 0x10, 0x3F, 0xE0, 0xC6, 0x08, 0xFE, 0x0C, 0x77, 0x10, 0xDF, 0xE0, 0x66, 0x01, 0xFF, 0x0B,
  0x76, 0x0B, 0xFE, 0x0E, 0x71, 0x09, 0xFF, 0x0D, 0x03, 0x72, 0x04, 0x0D, 0xFF, 0x08, 0x71, 0x02,
  0x0E, 0xFF, 0x98, 0x1B, 0x62, 0x38, 0x13, 0x6B, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78, 0x0C, 0x3F,
  0x05, 0x74, 0x0D, 0x80, 0xC1, 0xF0, 0xB7, 0x50, 0x20, 0xEF, 0xFF, 0xFF, 0x0E, 0x02, 0x76, 0x04,
  0xFF, 0xFF, 0xF0, 0x37, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x57, 0x73, 0x05, 0xFF, 0xFF, 0xA0, 0xE0,
  0x47, 0x75, 0x04, 0x0E, 0xFF, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x10, 0xBF, 0xFF, 0xC0, 0x90, 0x17,
  0x77, 0x30, 0x40, 0xCF, 0xFF, 0x0B, 0x03, 0x77, 0x77, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xD8, 0x27,
  0x77, 0x75, 0x84, 0x36, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x52, 0x77, 0x40,
  // "×" (U+00D7)
  0x60, 0x27, 0x77, 0x20, 0x37, 0x58, 0x16, 0xF5, 0x77, 0x78, 0x15, 0xF9, 0x73, 0x06, 0xB0, 0x57,
  0x75, 0x05, 0xB0, 0xA7, 0x10, 0x6D, 0x05, 0x77, 0x30, 0x5D, 0x0A, 0x60, 0x6F, 0x06, 0x77, 0x10,
  0x6F, 0x0A, 0x40, 0x6F, 0xA0, 0x67, 0x60, 0x6F, 0xA0, 0xA2, 0x05, 0xFC, 0x06, 0x74, 0x06, 0xFC,
  0x81, 0xA0, 0xCF, 0xD0, 0x67, 0x20, 0x6F, 0xD8, 0x2C, 0x11, 0xCF, 0xD0, 0x77, 0x07, 0xFD, 0x0C,
  0x01, 0x20, 0x10, 0xCF, 0xD0, 0x75, 0x07, 0xFD, 0x0C, 0x01, 0x40, 0x10, 0xCF, 0xD0, 0x73, 0x07,
  0xFD, 0x0C, 0x01, 0x60, 0x10, 0xDF, 0xD8, 0x17, 0x07, 0xFD, 0x0C, 0x01, 0x71, 0x01, 0x0D, 0xFD,
  0x0B, 0xFD, 0x0C, 0x01, 0x73, 0x01, 0x0D, 0xFF, 0xFA, 0x0C, 0x01, 0x75, 0x01, 0x0D, 0xFF, 0xF0,
  0xC0, 0x17, 0x70, 0x10, 0xDF, 0xFD, 0x0C, 0x01, 0x77, 0x20, 0x10, 0xDF, 0xFB, 0x0C, 0x01, 0x77,
  0x40, 0x10, 0xDF, 0xF9, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xDF, 0xE0, 0xC0, 0x17, 0x77, 0x10, 0x8F,
  0xE0, 0x77, 0x77, 0x10, 0x7F, 0xF9, 0x06, 0x77, 0x60, 0x7F, 0xFB, 0x06, 0x77, 0x40, 0x7F, 0xFD,
  0x06, 0x77, 0x20, 0x7F, 0xFF, 0x06, 0x77, 0x06, 0xFF, 0xFA, 0x05, 0x75, 0x06, 0xFF, 0xFC, 0x05,
  0x73, 0x06, 0xFD, 0x81, 0xC2, 0xCF, 0xD0, 0x57, 0x10, 0x6F, 0xD8, 0x3C, 0x10, 0x1C, 0xFD, 0x05,
  0x60, 0x6F, 0xD0, 0xC0, 0x13, 0x01, 0x0C, 0xFD, 0x05, 0x40, 0x5F, 0xD0, 0xC6, 0x01, 0x0C, 0xFD,
  0x05, 0x20, 0x5F, 0xD0, 0xB7, 0x10, 0x10, 0xCF, 0xD8, 0x15, 0x0B, 0xFC, 0x0B, 0x74, 0x0C, 0xFC,
  0x0C, 0x20, 0xBF, 0xA0, 0xB7, 0x60, 0xCF, 0xA0, 0xC0, 0x13, 0x0C, 0xF0, 0xB7, 0x71, 0x0C, 0xF0,
  0xC0, 0x14, 0x01, 0x0C, 0xD0, 0xB7, 0x73, 0x0B, 0xD0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0xB7, 0x75,
  0x0B, 0xB0, 0xC0, 0x17, 0x18, 0x21, 0xDF, 0xA7, 0x77, 0x82, 0xBF, 0xC1, 0x73, 0x01, 0x09, 0x77,
  0x72, 0x09, 0x01, 0x60,
  // "Ø" (U+00D8)
  0x80, 0xC5, 0x00, 0x58, 0x0D, 0x50, 0x82, 0x7F, 0xC4, 0x80, 0xD2, 0x00, 0x10, 0xEB, 0x0B, 0x02,
  0x77, 0x72, 0x89, 0x52, 0x69, 0xBD, 0xEE, 0xFE, 0xDC, 0xA7, 0x41, 0x60, 0x9E, 0x09, 0x01, 0x77,
  0x48, 0x13, 0x9E, 0xFF, 0x98, 0x1B, 0x61, 0x20, 0x2F, 0x90, 0x27, 0x72, 0x04, 0x0C, 0xFF, 0xE8,
  0x2E, 0x81, 0xAF, 0x08, 0x77, 0x10, 0x20, 0xBF, 0xFF, 0xB0, 0xEF, 0x0E, 0x01, 0x77, 0x05, 0x0E,
  0xFF, 0xFF, 0xD0, 0x67, 0x70, 0x7F, 0xFF, 0xFE, 0x0C, 0x77, 0x08, 0xFF, 0xFF, 0xF0, 0x47, 0x60,
  0x6F, 0xFF, 0xFF, 0x0C, 0x76, 0x04, 0x80, 0xC1, 0xF0, 0x37, 0x50, 0xD8, 0x0C, 0x1F, 0x0D, 0x01,
  0x73, 0x09, 0xFF, 0x98, 0x6D, 0x85, 0x32, 0x46, 0xBF, 0xFA, 0x09, 0x72, 0x02, 0xFF, 0x0E, 0x05,
  0x71, 0x02, 0x0B, 0xFF, 0x90, 0x37, 0x10, 0xAF, 0xE0, 0xC0, 0x17, 0x40, 0x8F, 0xF0, 0xB7, 0x02,
  0xFE, 0x0D, 0x01, 0x76, 0x0A, 0xFF, 0x02, 0x60, 0x8F, 0xE0, 0x27, 0x70, 0xEF, 0xF0, 0x96, 0x0E,
  0xFD, 0x08, 0x77, 0x08, 0xFF, 0x90, 0xE5, 0x05, 0xFD, 0x0E, 0x01, 0x76, 0x01, 0x0E, 0xFF, 0xA0,
  0x44, 0x09, 0xFD, 0x09, 0x77, 0x09, 0xFF, 0xB0, 0x94, 0x0E, 0xFD, 0x03, 0x76, 0x02, 0xFF, 0xC0,
  0xE3, 0x03, 0xFD, 0x0D, 0x77, 0x0A, 0xFF, 0xD0, 0x22, 0x06, 0xFD, 0x09, 0x76, 0x03, 0xFF, 0xE0,
  0x52, 0x09, 0xFD, 0x05, 0x76, 0x0C, 0xF0, 0xCF, 0xD0, 0x92, 0x0C, 0xFD, 0x02, 0x75, 0x05, 0xF0,
  0x80, 0x7F, 0xD0, 0xB2, 0xFE, 0x76, 0x0D, 0xE8, 0x1E, 0x13, 0xFD, 0x81, 0xD0, 0x2F, 0xD0, 0xC7,
  0x50, 0x6F, 0x81, 0x70, 0x1F, 0xE1, 0x04, 0xFD, 0x0A, 0x75, 0x0E, 0xE0, 0xD3, 0x0E, 0xFD, 0x02,
  0x05, 0xFD, 0x09, 0x74, 0x08, 0xF0, 0x63, 0x0C, 0xFD, 0x03, 0x06, 0xFD, 0x07, 0x73, 0x01, 0x0E,
  0xE0, 0xD4, 0x0A, 0xFD, 0x05, 0x08, 0xFD, 0x06, 0x73, 0x09, 0xF0, 0x44, 0x09, 0xFD, 0x06, 0x09,
  0xFD, 0x05, 0x72, 0x02, 0xF0, 0xB5, 0x08, 0xFD, 0x07, 0x09, 0xFD, 0x05, 0x72, 0x0A, 0xF0, 0x35,
  0x07, 0xFD, 0x07, 0x0A, 0xFD, 0x04, 0x71, 0x03, 0xF0, 0xA6, 0x07, 0xFD, 0x07, 0x0A, 0xFD, 0x04,
  0x71, 0x0C, 0xF0, 0x26, 0x06, 0xFD, 0x08, 0x0A, 0xFD, 0x04, 0x70, 0x5F, 0x09, 0x70, 0x6F, 0xD0,
  0x80, 0xAF, 0xD0, 0x47, 0x0D, 0xE0, 0xE0, 0x17, 0x06, 0xFD, 0x07, 0x09, 0xFD, 0x05, 0x60, 0x6F,
  0x07, 0x71, 0x07, 0xFD, 0x07, 0x09, 0xFD, 0x05, 0x60, 0xEE, 0x0E, 0x72, 0x07, 0xFD, 0x06, 0x08,
  0xFD, 0x07, 0x50, 0x7F, 0x06, 0x72, 0x08, 0xFD, 0x05, 0x07, 0xFD, 0x08, 0x40, 0x10, 0xEE, 0x0D,
  0x73, 0x09, 0xFD, 0x04, 0x05, 0xFD, 0x09, 0x40, 0x9F, 0x05, 0x73, 0x0B, 0xFD, 0x03, 0x04, 0xFD,
  0x0B, 0x30, 0x2F, 0x0C, 0x74, 0x0C, 0xFD, 0x01, 0x02, 0xFD, 0x0E, 0x30, 0xAF, 0x03, 0x74, 0x0E,
  0xFD, 0x2F, 0xE8, 0x11, 0x03, 0xF0, 0xB7, 0x40, 0x1F, 0xD0, 0xC2, 0x0D, 0xFD, 0x81, 0x40, 0xCF,
  0x02, 0x74, 0x04, 0xFD, 0x0A, 0x20, 0xAF, 0xD0, 0x80, 0x5F, 0x09, 0x75, 0x07, 0xFD, 0x07, 0x20,
  0x7F, 0xD0, 0xC0, 0xDF, 0x01, 0x75, 0x0B, 0xFD, 0x04, 0x20, 0x4F, 0xFE, 0x08, 0x76, 0xFE, 0x4F,
  0xFD, 0x0E, 0x01, 0x75, 0x05, 0xFD, 0x0B, 0x40, 0xBF, 0xFC, 0x07, 0x76, 0x0A, 0xFD, 0x07, 0x40,
  0x6F, 0xFB, 0x0D, 0x76, 0x02, 0xFE, 0x02, 0x40, 0x1F, 0xFB, 0x05, 0x76, 0x0A, 0xFD, 0x0C, 0x60,
  0xAF, 0xF9, 0x0C, 0x76, 0x04, 0xFE, 0x06, 0x60, 0x4F, 0xF9, 0x04, 0x75, 0x01, 0x0E, 0xFD, 0x0E,
  0x71, 0x0C, 0xFF, 0x03, 0x74, 0x02, 0x0D, 0xFE, 0x07, 0x71, 0x04, 0xFF, 0x90, 0x77, 0x20, 0x60,
  0xEF, 0xE0, 0xE7, 0x30, 0xBF, 0xF9, 0x87, 0xE9, 0x53, 0x23, 0x59, 0xEF, 0xF9, 0x06, 0x73, 0x02,
  0x80, 0xC2, 0xF0, 0xB7, 0x50, 0x68, 0x0C, 0x0F, 0x0E, 0x02, 0x76, 0x0A, 0xFF, 0xFF, 0xF0, 0x47,
  0x70, 0xBF, 0xFF, 0xFE, 0x06, 0x77, 0x04, 0xFF, 0xFF, 0xE0, 0x57, 0x71, 0x0C, 0xFF, 0xFF, 0xC0,
  0xE0, 0x47, 0x71, 0x06, 0xFF, 0xFF, 0xC0, 0xA0, 0x17, 0x72, 0x0E, 0xF0, 0x70, 0xBF, 0xFF, 0x0B,
  0x03, 0x77, 0x30, 0x8F, 0x0A, 0x28, 0x13, 0x9D, 0xFF, 0x98, 0x1D, 0x82, 0x77, 0x40, 0x2F, 0x90,
  0x25, 0x89, 0x52, 0x68, 0xBD, 0xEE, 0xFE, 0xED, 0xB8, 0x62, 0x77, 0x70, 0x10, 0x9E, 0x09, 0x80,
  0xD0, 0x00, 0x20, 0xAC, 0x02, 0x80, 0xD2, 0x08, 0x22, 0xAF, 0x98, 0x0D, 0x50, 0x03, 0x01, 0x80,
  0xC4, 0x00,
  // "Ù" (U+00D9)
  0x60, 0x38, 0x09, 0x17, 0x04, 0x77, 0x77, 0x10, 0x4F, 0xE0, 0xE7, 0x77, 0x72, 0x08, 0xFE, 0x07,
  0x77, 0x77, 0x20, 0x9F, 0xD0, 0xE0, 0x17, 0x77, 0x72, 0x0A, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0xBF,
  0xD0, 0x47, 0x77, 0x73, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0xC0, 0x87, 0x77, 0x74, 0x0B,
  0xFC, 0x02, 0x77, 0x77, 0x40, 0xBF, 0xB0, 0xC7, 0x77, 0x75, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x50,
  0xAF, 0xB0, 0x27, 0x77, 0x75, 0x09, 0xFA, 0x0C, 0x77, 0x77, 0x60, 0x7F, 0xA0, 0x77, 0x77, 0x76,
  0x05, 0xF9, 0x0B, 0x80, 0xBC, 0x70, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0D, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xD7, 0x74, 0xFD, 0x0B, 0x0C,
  0xFC, 0x0E, 0x77, 0x4F, 0xD0, 0xA0, 0xBF, 0xD7, 0x73, 0x02, 0xFD, 0x09, 0x0A, 0xFD, 0x03, 0x77,
  0x20, 0x5F, 0xD0, 0x08, 0xFD, 0x06, 0x77, 0x20, 0x8F, 0xD0, 0x06, 0xFD, 0x0B, 0x77, 0x20, 0xDF,
  0xD0, 0x03, 0xFE, 0x01, 0x77, 0x03, 0xFE, 0x20, 0xEF, 0xD0, 0xA7, 0x70, 0xBF, 0xD0, 0xC2, 0x0A,
  0xFE, 0x06, 0x75, 0x08, 0xFE, 0x08, 0x20, 0x5F, 0xF0, 0x87, 0x20, 0x10, 0x9F, 0xF0, 0x33, 0x0E,
  0xFF, 0x82, 0xE8, 0x41, 0x28, 0x21, 0x48, 0xEF, 0xF0, 0xC4, 0x08, 0x80, 0xC2, 0xF0, 0x54, 0x01,
  0x0E, 0x80, 0xC0, 0xF0, 0xD6, 0x07, 0x80, 0xC0, 0xF0, 0x37, 0x0C, 0xFF, 0xFF, 0xE0, 0x87, 0x10,
  0x10, 0xDF, 0xFF, 0xFC, 0x0B, 0x73, 0x02, 0x0E, 0xFF, 0xFF, 0xA0, 0xB7, 0x50, 0x20, 0xDF, 0xFF,
  0xF0, 0xA7, 0x71, 0x09, 0xFF, 0xFC, 0x0E, 0x06, 0x77, 0x30, 0x30, 0xBF, 0xFF, 0x90, 0x90, 0x17,
  0x76, 0x81, 0x28, 0xDF, 0xFA, 0x81, 0xC7, 0x17, 0x77, 0x48, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x5E,
  0xDC, 0xA7, 0x41, 0x77,
  // "Ú" (U+00DA)
  0x77, 0x72, 0x06, 0xFE, 0x0B, 0x77, 0x77, 0x10, 0xEF, 0xE0, 0x37, 0x77, 0x70, 0x8F, 0xE0, 0x57,
  0x77, 0x70, 0x2F, 0xE0, 0x67, 0x77, 0x71, 0x0B, 0xFD, 0x06, 0x77, 0x77, 0x10, 0x5F, 0xD0, 0x67,
  0x77, 0x71, 0x01, 0x0E, 0xFC, 0x06, 0x77, 0x77, 0x20, 0xAF, 0xC0, 0x57, 0x77, 0x72, 0x06, 0xFC,
  0x05, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x73, 0x0B, 0xFA, 0x0E, 0x03, 0x77,
  0x77, 0x30, 0x7F, 0xA0, 0xD0, 0x27, 0x77, 0x73, 0x02, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x40, 0x6F,
  0x90, 0xA8, 0x0B, 0xD3, 0x00, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xD7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0D, 0x77, 0x4F, 0xD0, 0xB0, 0xCF, 0xC0,
  0xE7, 0x74, 0xFD, 0x0A, 0x0B, 0xFD, 0x77, 0x30, 0x2F, 0xD0, 0x90, 0xAF, 0xD0, 0x37, 0x72, 0x05,
  0xFD, 0x00, 0x8F, 0xD0, 0x67, 0x72, 0x08, 0xFD, 0x00, 0x6F, 0xD0, 0xB7, 0x72, 0x0D, 0xFD, 0x00,
  0x3F, 0xE0, 0x17, 0x70, 0x3F, 0xE2, 0x0E, 0xFD, 0x0A, 0x77, 0x0B, 0xFD, 0x0C, 0x20, 0xAF, 0xE0,
  0x67, 0x50, 0x8F, 0xE0, 0x82, 0x05, 0xFF, 0x08, 0x72, 0x01, 0x09, 0xFF, 0x03, 0x30, 0xEF, 0xF8,
  0x2E, 0x84, 0x12, 0x82, 0x14, 0x8E, 0xFF, 0x0C, 0x40, 0x88, 0x0C, 0x2F, 0x05, 0x40, 0x10, 0xE8,
  0x0C, 0x0F, 0x0D, 0x60, 0x78, 0x0C, 0x0F, 0x03, 0x70, 0xCF, 0xFF, 0xFE, 0x08, 0x71, 0x01, 0x0D,
  0xFF, 0xFF, 0xC0, 0xB7, 0x30, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x75, 0x02, 0x0D, 0xFF, 0xFF, 0x0A,
  0x77, 0x10, 0x9F, 0xFF, 0xC0, 0xE0, 0x67, 0x73, 0x03, 0x0B, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x68,
  0x12, 0x8D, 0xFF, 0xA8, 0x1C, 0x71, 0x77, 0x74, 0x85, 0x26, 0x9B, 0xDE, 0xEA, 0x85, 0xED, 0xCA,
  0x74, 0x17, 0x70,
  // "Û" (U+00DB)
  0x77, 0x10, 0x18, 0x09, 0x07, 0x02, 0x77, 0x77, 0x20, 0x9F, 0xD0, 0xB7, 0x77, 0x71, 0x03, 0xFF,
  0x04, 0x77, 0x77, 0x0C, 0xFF, 0x0D, 0x77, 0x76, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x40, 0x3F, 0xFC,
  0x03, 0x77, 0x73, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x70,
  0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x77, 0x50, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02,
  0x77, 0x40, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x77, 0x30, 0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09,
  0x77, 0x10, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x60, 0x20, 0xEF, 0x0E, 0x03,
  0x73, 0x02, 0x0D, 0xF9, 0x03, 0x75, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF, 0x07, 0x80, 0xBB,
  0x60, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0D, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xD7, 0x74, 0xFD, 0x0B, 0x0C, 0xFC, 0x0E, 0x77, 0x4F, 0xD0,
  0xA0, 0xBF, 0xD7, 0x73, 0x02, 0xFD, 0x09, 0x0A, 0xFD, 0x03, 0x77, 0x20, 0x5F, 0xD0, 0x08, 0xFD,
  0x06, 0x77, 0x20, 0x8F, 0xD0, 0x06, 0xFD, 0x0B, 0x77, 0x20, 0xDF, 0xD0, 0x03, 0xFE, 0x01, 0x77,
  0x03, 0xFE, 0x20, 0xEF, 0xD0, 0xA7, 0x70, 0xBF, 0xD0, 0xC2, 0x0A, 0xFE, 0x06, 0x75, 0x08, 0xFE,
  0x08, 0x20, 0x5F, 0xF0, 0x87, 0x20, 0x10, 0x9F, 0xF0, 0x33, 0x0E, 0xFF, 0x82, 0xE8, 0x41, 0x28,
  0x21, 0x48, 0xEF, 0xF0, 0xC4, 0x08, 0x80, 0xC2, 0xF0, 0x54, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xD6,
  0x07, 0x80, 0xC0, 0xF0, 0x37, 0x0C, 0xFF, 0xFF, 0xE0, 0x87, 0x10, 0x10, 0xDF, 0xFF, 0xFC, 0x0B,
  0x73, 0x02, 0x0E, 0xFF, 0xFF, 0xA0, 0xB7, 0x50, 0x20, 0xDF, 0xFF, 0xF0, 0xA7, 0x71, 0x09, 0xFF,
  0xFC, 0x0E, 0x06, 0x77, 0x30, 0x30, 0xBF, 0xFF, 0x90, 0x90, 0x17, 0x76, 0x81, 0x28, 0xDF, 0xFA,
  0x81, 0xC7, 0x17, 0x77, 0x48, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x5E, 0xDC, 0xA7, 0x41, 0x77,
  // "Ü" (U+00DC)
  0x74, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x50, 0x20, 0xDE, 0x0D,
  0x02, 0x70, 0x40, 0xEE, 0x0C, 0x77, 0x40, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x20,
  0x3F, 0xB0, 0x45, 0x07, 0xFB, 0x01, 0x77, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x77, 0x10,
  0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x77, 0x10, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x77, 0x10,
  0x7F, 0xB0, 0x85, 0x0C, 0xFB, 0x06, 0x77, 0x10, 0x4F, 0xB0, 0x45, 0x08, 0xFB, 0x02, 0x77, 0x20,
  0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x40, 0xEE,
  0x0C, 0x01, 0x77, 0x58, 0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x68, 0x0C, 0x96,
  0x00, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E,
  0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC,
  0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B,
  0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D,
  0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC,
  0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C,
  0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77,
  0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40,
  0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF,
  0xC0, 0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0,
  0xB0, 0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0,
  0xDF, 0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF,
  0xC0, 0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0,
  0xC7, 0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xC7,
  0x74, 0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0C, 0x77, 0x40, 0xEF, 0xC0, 0xB0, 0xDF, 0xC0, 0xD7, 0x74,
  0x0E, 0xFC, 0x0B, 0x0D, 0xFC, 0x0D, 0x77, 0x4F, 0xD0, 0xB0, 0xCF, 0xC0, 0xE7, 0x74, 0xFD, 0x0A,
  0x0B, 0xFD, 0x77, 0x30, 0x2F, 0xD0, 0x90, 0xAF, 0xD0, 0x37, 0x72, 0x05, 0xFD, 0x00, 0x8F, 0xD0,
  0x67, 0x72, 0x08, 0xFD, 0x00, 0x6F, 0xD0, 0xB7, 0x72, 0x0D, 0xFD, 0x00, 0x3F, 0xE0, 0x17, 0x70,
  0x3F, 0xE2, 0x0E, 0xFD, 0x0A, 0x77, 0x0B, 0xFD, 0x0C, 0x20, 0xAF, 0xE0, 0x67, 0x50, 0x8F, 0xE0,
  0x82, 0x05, 0xFF, 0x08, 0x72, 0x01, 0x09, 0xFF, 0x03, 0x30, 0xEF, 0xF8, 0x2E, 0x84, 0x12, 0x82,
  0x14, 0x8E, 0xFF, 0x0C, 0x40, 0x88, 0x0C, 0x2F, 0x05, 0x40, 0x10, 0xE8, 0x0C, 0x0F, 0x0D, 0x60,
  0x78, 0x0C, 0x0F, 0x03, 0x70, 0xCF, 0xFF, 0xFE, 0x08, 0x71, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0xB7,
  0x30, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x75, 0x02, 0x0D, 0xFF, 0xFF, 0x0A, 0x77, 0x10, 0x9F, 0xFF,
  0xC0, 0xE0, 0x67, 0x73, 0x03, 0x0B, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x68, 0x12, 0x8D, 0xFF, 0xA8,
  0x1C, 0x71, 0x77, 0x74, 0x85, 0x26, 0x9B, 0xDE, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x70,
  // "Ý" (U+00DD)
  0x77, 0x74, 0x06, 0xFE, 0x0B, 0x77, 0x77, 0x40, 0xEF, 0xE0, 0x37, 0x77, 0x73, 0x08, 0xFE, 0x05,
  0x77, 0x77, 0x30, 0x2F, 0xE0, 0x67, 0x77, 0x74, 0x0B, 0xFD, 0x06, 0x77, 0x77, 0x40, 0x5F, 0xD0,
  0x67, 0x77, 0x74, 0x01, 0x0E, 0xFC, 0x06, 0x77, 0x77, 0x50, 0xAF, 0xC0, 0x57, 0x77, 0x75, 0x06,
  0xFC, 0x05, 0x77, 0x77, 0x50, 0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x76, 0x0B, 0xFA, 0x0E, 0x03,
  0x77, 0x77, 0x60, 0x7F, 0xA0, 0xD0, 0x27, 0x77, 0x76, 0x02, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x70,
  0x6F, 0x90, 0xA8, 0x0B, 0xF3, 0x00, 0xCF, 0xD0, 0x97, 0x75, 0x0C, 0xFD, 0x07, 0x05, 0xFD, 0x0E,
  0x77, 0x40, 0x2F, 0xE8, 0x11, 0x0E, 0xFD, 0x05, 0x77, 0x30, 0x8F, 0xD0, 0x92, 0x07, 0xFD, 0x0B,
  0x77, 0x30, 0xEF, 0xD0, 0x32, 0x01, 0xFE, 0x01, 0x77, 0x10, 0x5F, 0xD0, 0xB4, 0x0A, 0xFD, 0x07,
  0x77, 0x10, 0xBF, 0xD0, 0x54, 0x03, 0xFD, 0x0D, 0x77, 0x01, 0xFD, 0x0D, 0x60, 0xCF, 0xD0, 0x47,
  0x60, 0x7F, 0xD0, 0x76, 0x05, 0xFD, 0x0A, 0x76, 0x0D, 0xFD, 0x01, 0x70, 0xEF, 0xD0, 0x17, 0x40,
  0x3F, 0xD0, 0x97, 0x10, 0x8F, 0xD0, 0x67, 0x40, 0x9F, 0xD0, 0x37, 0x10, 0x1F, 0xD0, 0xC7, 0x40,
  0xEF, 0xC0, 0xB7, 0x30, 0xAF, 0xD0, 0x27, 0x20, 0x5F, 0xD0, 0x57, 0x30, 0x3F, 0xD0, 0x87, 0x20,
  0xBF, 0xC0, 0xD7, 0x50, 0xCF, 0xC0, 0xE7, 0x10, 0x2F, 0xD0, 0x77, 0x50, 0x6F, 0xD0, 0x57, 0x08,
  0xFD, 0x01, 0x76, 0x0E, 0xFC, 0x0A, 0x70, 0xDF, 0xC0, 0x97, 0x70, 0x8F, 0xD0, 0x15, 0x04, 0xFD,
  0x02, 0x77, 0x02, 0xFD, 0x07, 0x50, 0xAF, 0xC0, 0xB7, 0x72, 0x0A, 0xFC, 0x0D, 0x40, 0x1F, 0xD0,
  0x57, 0x72, 0x04, 0xFD, 0x03, 0x30, 0x6F, 0xC0, 0xD7, 0x74, 0x0D, 0xFC, 0x09, 0x30, 0xCF, 0xC0,
  0x77, 0x74, 0x06, 0xFC, 0x0E, 0x20, 0x2F, 0xD0, 0x17, 0x75, 0x0E, 0xFC, 0x81, 0x50, 0x8F, 0xC0,
  0x97, 0x76, 0x08, 0xFC, 0x81, 0xB0, 0xEF, 0xC0, 0x27, 0x76, 0x02, 0xFD, 0x07, 0xFC, 0x0B, 0x77,
  0x71, 0x0B, 0xFF, 0xFA, 0x05, 0x77, 0x71, 0x04, 0xFF, 0xF9, 0x0D, 0x77, 0x73, 0x0D, 0xFF, 0xF0,
  0x77, 0x77, 0x30, 0x6F, 0xFE, 0x0E, 0x01, 0x77, 0x74, 0x0E, 0xFF, 0xD0, 0x97, 0x77, 0x50, 0x9F,
  0xFD, 0x02, 0x77, 0x75, 0x02, 0xFF, 0xC0, 0xB7, 0x77, 0x70, 0xBF, 0xFB, 0x04, 0x77, 0x77, 0x04,
  0xFF, 0xA0, 0xD7, 0x77, 0x72, 0x0D, 0xFF, 0x90, 0x77, 0x77, 0x72, 0x07, 0xFF, 0x0E, 0x01, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0xE0, 0x97, 0x77, 0x74, 0x09, 0xFE, 0x02, 0x77, 0x77, 0x40, 0x2F, 0xD0,
  0xC7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77,
  0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A,
  0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76,
  0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7,
  0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F,
  0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77,
  0x77, 0x6F, 0xD0, 0xA7, 0x77, 0x76, 0xFD, 0x0A, 0x77, 0x77, 0x6F, 0xD0, 0xA7, 0x73,
  // "Þ" (U+00DE)
  0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x74, 0x08, 0xFF, 0xC8, 0x5E, 0xEC, 0xB8, 0x62, 0x76, 0x08, 0xFF, 0xFC, 0x81, 0xD8, 0x27,
  0x30, 0x8F, 0xFF, 0xF0, 0xA0, 0x27, 0x10, 0x8F, 0xFF, 0xFA, 0x07, 0x70, 0x8F, 0xFF, 0xFB, 0x0A,
  0x60, 0x8F, 0xFF, 0xFC, 0x0A, 0x50, 0x8F, 0xFF, 0xFD, 0x08, 0x40, 0x8F, 0xFF, 0xFE, 0x03, 0x30,
  0x8F, 0xFF, 0xFE, 0x0C, 0x30, 0x8F, 0xFF, 0xFF, 0x04, 0x20, 0x8F, 0xD8, 0x64, 0x22, 0x23, 0x46,
  0xAF, 0xF9, 0x0B, 0x20, 0x8F, 0xD0, 0x27, 0x01, 0x0A, 0xFF, 0x81, 0x10, 0x8F, 0xD0, 0x27, 0x20,
  0x8F, 0xE8, 0x15, 0x08, 0xFD, 0x02, 0x73, 0x0C, 0xFD, 0x81, 0x90, 0x8F, 0xD0, 0x27, 0x30, 0x4F,
  0xD8, 0x1C, 0x08, 0xFD, 0x02, 0x74, 0x0D, 0xFD, 0x10, 0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD0, 0x10,
  0x8F, 0xD0, 0x27, 0x40, 0x7F, 0xD0, 0x30, 0x8F, 0xD0, 0x27, 0x40, 0x6F, 0xD0, 0x30, 0x8F, 0xD0,
  0x27, 0x40, 0x5F, 0xD0, 0x40, 0x8F, 0xD0, 0x27, 0x40, 0x5F, 0xD0, 0x30, 0x8F, 0xD0, 0x27, 0x40,
  0x6F, 0xD0, 0x30, 0x8F, 0xD0, 0x27, 0x40, 0x7F, 0xD0, 0x20, 0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD1,
  0x08, 0xFD, 0x02, 0x74, 0x0D, 0xFC, 0x81, 0xD0, 0x8F, 0xD0, 0x27, 0x30, 0x2F, 0xD8, 0x1B, 0x08,
  0xFD, 0x02, 0x73, 0x08, 0xFD, 0x81, 0x70, 0x8F, 0xD0, 0x27, 0x20, 0x2F, 0xE8, 0x13, 0x08, 0xFD,
  0x02, 0x71, 0x01, 0x0D, 0xFD, 0x0E, 0x20, 0x8F, 0xD0, 0x27, 0x05, 0x0E, 0xFE, 0x08, 0x20, 0x8F,
  0xD8, 0x64, 0x22, 0x23, 0x59, 0xDF, 0xF9, 0x03, 0x20, 0x8F, 0xFF, 0xFE, 0x0A, 0x30, 0x8F, 0xFF,
  0xFE, 0x03, 0x30, 0x8F, 0xFF, 0xFD, 0x08, 0x40, 0x8F, 0xFF, 0xFC, 0x0C, 0x50, 0x8F, 0xFF, 0xFB,
  0x0C, 0x01, 0x50, 0x8F, 0xFF, 0xFA, 0x0C, 0x01, 0x60, 0x8F, 0xFF, 0xF9, 0x08, 0x71, 0x08, 0xFF,
  0xFE, 0x0B, 0x03, 0x72, 0x08, 0xFF, 0xFB, 0x81, 0xE9, 0x37, 0x40, 0x8F, 0xFB, 0x85, 0xEE, 0xDB,
  0x96, 0x37, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x77, 0x40,
  // "ß" (U+00DF)
  0x77, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x41, 0x77, 0x77, 0x81, 0x4A, 0xEF, 0xF9,
  0x81, 0xC7, 0x17, 0x77, 0x20, 0x50, 0xDF, 0xFF, 0x09, 0x02, 0x77, 0x50, 0x10, 0xBF, 0xFF, 0xB0,
  0xE0, 0x77, 0x73, 0x04, 0x0E, 0xFF, 0xFE, 0x0B, 0x77, 0x10, 0x5F, 0xFF, 0xFA, 0x0C, 0x76, 0x04,
  0xFF, 0xFF, 0xC0, 0xB7, 0x40, 0x10, 0xEF, 0xFF, 0xFD, 0x07, 0x73, 0x0B, 0xFF, 0xFF, 0xF0, 0x17,
  0x10, 0x48, 0x0C, 0x0F, 0x08, 0x71, 0x0B, 0xFF, 0x86, 0xC7, 0x43, 0x34, 0x7C, 0xFF, 0x0E, 0x70,
  0x2F, 0xE0, 0xE0, 0x57, 0x10, 0x40, 0xEF, 0xE0, 0x26, 0x07, 0xFD, 0x0E, 0x02, 0x73, 0x02, 0x0E,
  0xFD, 0x05, 0x60, 0xBF, 0xD0, 0x57, 0x50, 0x6F, 0xD0, 0x76, 0x0E, 0xFC, 0x0C, 0x77, 0xFD, 0x08,
  0x50, 0x1F, 0xD0, 0x67, 0x70, 0xDF, 0xC0, 0x75, 0x03, 0xFD, 0x02, 0x77, 0x0C, 0xFC, 0x06, 0x50,
  0x4F, 0xD7, 0x71, 0x0E, 0xFC, 0x04, 0x50, 0x4F, 0xC0, 0xD7, 0x70, 0x2F, 0xD0, 0x15, 0x05, 0xFC,
  0x0D, 0x77, 0x08, 0xFC, 0x0C, 0x60, 0x5F, 0xC0, 0xC7, 0x60, 0x3F, 0xD0, 0x66, 0x05, 0xFC, 0x0C,
  0x75, 0x01, 0x0D, 0xFC, 0x0D, 0x70, 0x5F, 0xC0, 0xC7, 0x40, 0x10, 0xDF, 0xD0, 0x47, 0x05, 0xFC,
  0x0C, 0x73, 0x01, 0x0D, 0xFD, 0x09, 0x71, 0x05, 0xFC, 0x0C, 0x72, 0x01, 0x0D, 0xFD, 0x0B, 0x72,
  0x05, 0xFC, 0x0C, 0x71, 0x01, 0x0D, 0xFD, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x71, 0x0C, 0xFD, 0x0B,
  0x74, 0x05, 0xFC, 0x0C, 0x70, 0xAF, 0xD0, 0xB7, 0x50, 0x5F, 0xC0, 0xC6, 0x05, 0xFD, 0x0A, 0x76,
  0x05, 0xFC, 0x0C, 0x60, 0xCF, 0xC0, 0xB7, 0x70, 0x5F, 0xC0, 0xC5, 0x02, 0xFD, 0x02, 0x77, 0x05,
  0xFC, 0x0C, 0x50, 0x5F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x50, 0x7F, 0xC0, 0xB7, 0x71, 0x05,
  0xFC, 0x0C, 0x50, 0x7F, 0xC0, 0xE7, 0x71, 0x05, 0xFC, 0x0C, 0x50, 0x6F, 0xD0, 0x87, 0x70, 0x5F,
  0xC0, 0xC5, 0x04, 0xFE, 0x05, 0x76, 0x05, 0xFC, 0x0C, 0x50, 0x1F, 0xF0, 0x67, 0x50, 0x5F, 0xC0,
  0xC6, 0x0C, 0xFF, 0x09, 0x74, 0x05, 0xFC, 0x0C, 0x60, 0x6F, 0xF9, 0x0C, 0x01, 0x72, 0x05, 0xFC,
  0x0C, 0x70, 0xDF, 0xF9, 0x0E, 0x04, 0x71, 0x05, 0xFC, 0x0C, 0x70, 0x4F, 0xFB, 0x06, 0x70, 0x5F,
  0xC0, 0xC7, 0x10, 0x8F, 0xFB, 0x07, 0x60, 0x5F, 0xC0, 0xC7, 0x20, 0xAF, 0xFB, 0x08, 0x50, 0x5F,
  0xC0, 0xC7, 0x30, 0xAF, 0xFB, 0x07, 0x40, 0x5F, 0xC0, 0xC7, 0x40, 0x8F, 0xFB, 0x04, 0x30, 0x5F,
  0xC0, 0xC7, 0x50, 0x50, 0xEF, 0xF9, 0x0E, 0x01, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x20, 0xCF, 0xF9,
  0x09, 0x20, 0x5F, 0xC0, 0xC7, 0x71, 0x08, 0xFF, 0x98, 0x12, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F,
  0xF8, 0x18, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x30, 0xEF, 0xD8, 0x1C, 0x05, 0xFC, 0x0C, 0x77, 0x40,
  0x5F, 0xE1, 0x05, 0xFC, 0x0C, 0x77, 0x50, 0xBF, 0xD0, 0x20, 0x5F, 0xC0, 0xC7, 0x75, 0x05, 0xFD,
  0x03, 0x05, 0xFC, 0x0C, 0x77, 0x50, 0x2F, 0xD0, 0x40, 0x5F, 0xC0, 0xC7, 0x75, 0x02, 0xFD, 0x04,
  0x05, 0xFC, 0x0C, 0x40, 0x37, 0x70, 0x4F, 0xD0, 0x30, 0x5F, 0xC0, 0xC4, 0x81, 0x9D, 0x57, 0x50,
  0x9F, 0xD0, 0x10, 0x5F, 0xC0, 0xC4, 0x09, 0xA8, 0x1D, 0x61, 0x71, 0x05, 0xFD, 0x81, 0xE0, 0x5F,
  0xC0, 0xC4, 0x09, 0xD8, 0x6C, 0x75, 0x32, 0x36, 0xBF, 0xE8, 0x1B, 0x05, 0xFC, 0x0C, 0x40, 0x9F,
  0xFF, 0xD8, 0x17, 0x05, 0xFC, 0x0C, 0x40, 0x9F, 0xFF, 0xD8, 0x12, 0x05, 0xFC, 0x0C, 0x40, 0x9F,
  0xFF, 0xC0, 0xA2, 0x05, 0xFC, 0x0C, 0x40, 0x9F, 0xFF, 0xC0, 0x22, 0x05, 0xFC, 0x0C, 0x40, 0x9F,
  0xFF, 0xB0, 0x73, 0x05, 0xFC, 0x0C, 0x40, 0x9F, 0xFF, 0xA0, 0x94, 0x05, 0xFC, 0x0C, 0x40, 0x9F,
  0xFF, 0x90, 0x75, 0x05, 0xFC, 0x0C, 0x40, 0x40, 0xCF, 0xFD, 0x0D, 0x03, 0x60, 0x5F, 0xC0, 0xC6,
  0x04, 0x0B, 0xFF, 0x90, 0xB0, 0x47, 0x77, 0x72, 0x89, 0x44, 0x7A, 0xCD, 0xEF, 0xED, 0xCB, 0x85,
  0x17, 0x30,
  // "à" (U+00E0)
  0x50, 0x38, 0x09, 0x17, 0x04, 0x77, 0x71, 0x04, 0xFE, 0x0E, 0x77, 0x72, 0x08, 0xFE, 0x07, 0x77,
  0x72, 0x09, 0xFD, 0x0E, 0x01, 0x77, 0x72, 0x0A, 0xFD, 0x0A, 0x77, 0x73, 0x0B, 0xFD, 0x04, 0x77,
  0x73, 0x0B, 0xFC, 0x0D, 0x77, 0x74, 0x0B, 0xFC, 0x08, 0x77, 0x74, 0x0B, 0xFC, 0x02, 0x77, 0x74,
  0x0B, 0xFB, 0x0C, 0x77, 0x75, 0x0A, 0xFB, 0x07, 0x77, 0x75, 0x0A, 0xFB, 0x02, 0x77, 0x75, 0x09,
  0xFA, 0x0C, 0x77, 0x76, 0x07, 0xFA, 0x07, 0x77, 0x76, 0x05, 0xF9, 0x0B, 0x80, 0xAC, 0x60, 0x85,
  0x47, 0x9B, 0xDE, 0xEA, 0x83, 0xEC, 0xA7, 0x47, 0x75, 0x81, 0x27, 0xCF, 0xF9, 0x81, 0xE9, 0x27,
  0x70, 0x50, 0xBF, 0xFF, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0xFB, 0x0C, 0x01, 0x71, 0x0B, 0xFF, 0xFE,
  0x0D, 0x01, 0x70, 0x9F, 0xFF, 0xF0, 0xC7, 0x02, 0xFF, 0xFF, 0x90, 0x77, 0x0C, 0xFF, 0xFF, 0x0E,
  0x01, 0x60, 0x6F, 0xFF, 0xF9, 0x07, 0x70, 0xEF, 0xFF, 0xF0, 0xD7, 0x09, 0xF8, 0x6B, 0x85, 0x42,
  0x35, 0xAF, 0xF0, 0x26, 0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F, 0xE0, 0x67, 0x82, 0xCF, 0x91, 0x75,
  0x06, 0xFD, 0x09, 0x70, 0x30, 0x17, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x73, 0x08, 0xFC, 0x0D, 0x77,
  0x73, 0x04, 0xFD, 0x77, 0x73, 0x02, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77,
  0x73, 0x01, 0xFD, 0x73, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xFE, 0x71, 0x06, 0x0B, 0xFF, 0xFE, 0x60,
  0x60, 0xEF, 0xFF, 0xF9, 0x40, 0x10, 0xCF, 0xFF, 0xFB, 0x30, 0x20, 0xDF, 0xFF, 0xFC, 0x20, 0x10,
  0xDF, 0xFF, 0xFD, 0x20, 0xAF, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xFF, 0x10, 0xBF, 0xF8, 0x2A, 0x52,
  0x14, 0x01, 0xFD, 0x02, 0xFE, 0x0B, 0x02, 0x71, 0x01, 0xFD, 0x06, 0xFD, 0x0B, 0x73, 0x01, 0xFD,
  0x0A, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x0E, 0xFC, 0x07, 0x74,
  0x03, 0xFF, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFB, 0x04, 0x74, 0x08, 0xFF, 0xFB, 0x06, 0x74, 0x0E,
  0xFD, 0x0E, 0xFC, 0x08, 0x73, 0x07, 0xFE, 0x0D, 0xFC, 0x0E, 0x72, 0x03, 0xFF, 0x0A, 0xFD, 0x09,
  0x70, 0x40, 0xEF, 0xF0, 0x7F, 0xE8, 0x5B, 0x41, 0x01, 0x5B, 0xFF, 0xA0, 0x38, 0x0C, 0x0F, 0x10,
  0xDF, 0xFF, 0xFF, 0x10, 0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB1, 0x01, 0x0E, 0xFF, 0xF8, 0x1E, 0x17,
  0xFB, 0x20, 0x7F, 0xFF, 0x81, 0x40, 0x2F, 0xB3, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA, 0x30, 0x20,
  0xEF, 0xFB, 0x06, 0x40, 0x8F, 0xA4, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA5, 0x01, 0x09,
  0xFD, 0x09, 0x01, 0x70, 0xEF, 0x97, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x17, 0x74,
  // "á" (U+00E1)
  0x77, 0x70, 0x6F, 0xE0, 0xB7, 0x77, 0x10, 0xEF, 0xE0, 0x37, 0x77, 0x08, 0xFE, 0x05, 0x77, 0x70,
  0x2F, 0xE0, 0x67, 0x77, 0x10, 0xBF, 0xD0, 0x67, 0x77, 0x10, 0x5F, 0xD0, 0x67, 0x77, 0x10, 0x10,
  0xEF, 0xC0, 0x67, 0x77, 0x20, 0xAF, 0xC0, 0x57, 0x77, 0x20, 0x6F, 0xC0, 0x57, 0x77, 0x20, 0x10,
  0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x30, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x30, 0x7F, 0xA0, 0xD0, 0x27,
  0x77, 0x30, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x40, 0x6F, 0x90, 0xA8, 0x0A, 0xD3, 0x08, 0x54, 0x79,
  0xBD, 0xEE, 0xA8, 0x3E, 0xCA, 0x74, 0x77, 0x58, 0x12, 0x7C, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x05,
  0x0B, 0xFF, 0xF0, 0x87, 0x40, 0x50, 0xDF, 0xFF, 0xB0, 0xC0, 0x17, 0x10, 0xBF, 0xFF, 0xE0, 0xD0,
  0x17, 0x09, 0xFF, 0xFF, 0x0C, 0x70, 0x2F, 0xFF, 0xF9, 0x07, 0x70, 0xCF, 0xFF, 0xF0, 0xE0, 0x16,
  0x06, 0xFF, 0xFF, 0x90, 0x77, 0x0E, 0xFF, 0xFF, 0x0D, 0x70, 0x9F, 0x86, 0xB8, 0x54, 0x23, 0x5A,
  0xFF, 0x02, 0x60, 0x2C, 0x0B, 0x05, 0x72, 0x04, 0xFE, 0x06, 0x78, 0x2C, 0xF9, 0x17, 0x50, 0x6F,
  0xD0, 0x97, 0x03, 0x01, 0x77, 0x10, 0xDF, 0xC0, 0xC7, 0x77, 0x30, 0x8F, 0xC0, 0xD7, 0x77, 0x30,
  0x4F, 0xD7, 0x77, 0x30, 0x2F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30,
  0x1F, 0xD7, 0x38, 0x51, 0x58, 0xAC, 0xDE, 0xFF, 0xE7, 0x10, 0x60, 0xBF, 0xFF, 0xE6, 0x06, 0x0E,
  0xFF, 0xFF, 0x94, 0x01, 0x0C, 0xFF, 0xFF, 0xB3, 0x02, 0x0D, 0xFF, 0xFF, 0xC2, 0x01, 0x0D, 0xFF,
  0xFF, 0xD2, 0x0A, 0xFF, 0xFF, 0xE1, 0x04, 0xFF, 0xFF, 0xF1, 0x0B, 0xFF, 0x82, 0xA5, 0x21, 0x40,
  0x1F, 0xD0, 0x2F, 0xE0, 0xB0, 0x27, 0x10, 0x1F, 0xD0, 0x6F, 0xD0, 0xB7, 0x30, 0x1F, 0xD0, 0xAF,
  0xD0, 0x27, 0x30, 0x1F, 0xD0, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0xEF, 0xC0, 0x77, 0x40, 0x3F,
  0xFF, 0xB0, 0x57, 0x40, 0x5F, 0xFF, 0xB0, 0x47, 0x40, 0x8F, 0xFF, 0xB0, 0x67, 0x40, 0xEF, 0xD0,
  0xEF, 0xC0, 0x87, 0x30, 0x7F, 0xE0, 0xDF, 0xC0, 0xE7, 0x20, 0x3F, 0xF0, 0xAF, 0xD0, 0x97, 0x04,
  0x0E, 0xFF, 0x07, 0xFE, 0x85, 0xB4, 0x10, 0x15, 0xBF, 0xFA, 0x03, 0x80, 0xC0, 0xF1, 0x0D, 0xFF,
  0xFF, 0xF1, 0x08, 0xFF, 0xFA, 0x0B, 0x0C, 0xFB, 0x10, 0x10, 0xEF, 0xFF, 0x81, 0xE1, 0x7F, 0xB2,
  0x07, 0xFF, 0xF8, 0x14, 0x02, 0xFB, 0x30, 0xDF, 0xFD, 0x06, 0x30, 0xDF, 0xA3, 0x02, 0x0E, 0xFF,
  0xB0, 0x64, 0x08, 0xFA, 0x40, 0x30, 0xDF, 0xF0, 0xE0, 0x45, 0x03, 0xFA, 0x50, 0x10, 0x9F, 0xD0,
  0x90, 0x17, 0x0E, 0xF9, 0x78, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x77, 0x40,
  // "â" (U+00E2)
  0x76, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x20, 0x9F, 0xD0, 0xB7, 0x77, 0x10, 0x3F, 0xF0, 0x47,
  0x77, 0x0C, 0xFF, 0x0D, 0x77, 0x60, 0x7F, 0xFA, 0x08, 0x77, 0x40, 0x3F, 0xFC, 0x03, 0x77, 0x30,
  0xDF, 0xFC, 0x0D, 0x77, 0x20, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x04, 0xFA, 0x81, 0xE3, 0x3F,
  0xB0, 0x57, 0x50, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x74, 0x0B, 0xFA, 0x04, 0x40,
  0x5F, 0xA0, 0xC7, 0x30, 0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x71, 0x04, 0xF9, 0x0E, 0x04, 0x71,
  0x03, 0x0E, 0xF9, 0x06, 0x60, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x50, 0x6F,
  0x0C, 0x01, 0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xB6, 0x08, 0x54, 0x79, 0xBD, 0xEE, 0xA8, 0x3E,
  0xCA, 0x74, 0x77, 0x58, 0x12, 0x7C, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x05, 0x0B, 0xFF, 0xF0, 0x87,
  0x40, 0x50, 0xDF, 0xFF, 0xB0, 0xC0, 0x17, 0x10, 0xBF, 0xFF, 0xE0, 0xD0, 0x17, 0x09, 0xFF, 0xFF,
  0x0C, 0x70, 0x2F, 0xFF, 0xF9, 0x07, 0x70, 0xCF, 0xFF, 0xF0, 0xE0, 0x16, 0x06, 0xFF, 0xFF, 0x90,
  0x77, 0x0E, 0xFF, 0xFF, 0x0D, 0x70, 0x9F, 0x86, 0xB8, 0x54, 0x23, 0x5A, 0xFF, 0x02, 0x60, 0x2C,
  0x0B, 0x05, 0x72, 0x04, 0xFE, 0x06, 0x78, 0x2C, 0xF9, 0x17, 0x50, 0x6F, 0xD0, 0x97, 0x03, 0x01,
  0x77, 0x10, 0xDF, 0xC0, 0xC7, 0x77, 0x30, 0x8F, 0xC0, 0xD7, 0x77, 0x30, 0x4F, 0xD7, 0x77, 0x30,
  0x2F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x38, 0x51,
  0x58, 0xAC, 0xDE, 0xFF, 0xE7, 0x10, 0x60, 0xBF, 0xFF, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0x94, 0x01,
  0x0C, 0xFF, 0xFF, 0xB3, 0x02, 0x0D, 0xFF, 0xFF, 0xC2, 0x01, 0x0D, 0xFF, 0xFF, 0xD2, 0x0A, 0xFF,
  0xFF, 0xE1, 0x04, 0xFF, 0xFF, 0xF1, 0x0B, 0xFF, 0x82, 0xA5, 0x21, 0x40, 0x1F, 0xD0, 0x2F, 0xE0,
  0xB0, 0x27, 0x10, 0x1F, 0xD0, 0x6F, 0xD0, 0xB7, 0x30, 0x1F, 0xD0, 0xAF, 0xD0, 0x27, 0x30, 0x1F,
  0xD0, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0xEF, 0xC0, 0x77, 0x40, 0x3F, 0xFF, 0xB0, 0x57, 0x40,
  0x5F, 0xFF, 0xB0, 0x47, 0x40, 0x8F, 0xFF, 0xB0, 0x67, 0x40, 0xEF, 0xD0, 0xEF, 0xC0, 0x87, 0x30,
  0x7F, 0xE0, 0xDF, 0xC0, 0xE7, 0x20, 0x3F, 0xF0, 0xAF, 0xD0, 0x97, 0x04, 0x0E, 0xFF, 0x07, 0xFE,
  0x85, 0xB4, 0x10, 0x15, 0xBF, 0xFA, 0x03, 0x80, 0xC0, 0xF1, 0x0D, 0xFF, 0xFF, 0xF1, 0x08, 0xFF,
  0xFA, 0x0B, 0x0C, 0xFB, 0x10, 0x10, 0xEF, 0xFF, 0x81, 0xE1, 0x7F, 0xB2, 0x07, 0xFF, 0xF8, 0x14,
  0x02, 0xFB, 0x30, 0xDF, 0xFD, 0x06, 0x30, 0xDF, 0xA3, 0x02, 0x0E, 0xFF, 0xB0, 0x64, 0x08, 0xFA,
  0x40, 0x30, 0xDF, 0xF0, 0xE0, 0x45, 0x03, 0xFA, 0x50, 0x10, 0x9F, 0xD0, 0x90, 0x17, 0x0E, 0xF9,
  0x78, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x77, 0x40,
  // "ã" (U+00E3)
  0x73, 0x86, 0x5A, 0xDF, 0xEC, 0x94, 0x74, 0x06, 0xE7, 0x20, 0x10, 0xCF, 0x90, 0xD0, 0x57, 0x20,
  0xBE, 0x71, 0x01, 0x0D, 0xFC, 0x0D, 0x06, 0x60, 0x3E, 0x0D, 0x71, 0x0A, 0xFF, 0x85, 0xE8, 0x31,
  0x04, 0xEE, 0x0B, 0x70, 0x4F, 0xFF, 0xF0, 0x87, 0x0C, 0xFF, 0xFF, 0x05, 0x60, 0x2F, 0xFF, 0xF0,
  0xE7, 0x07, 0xFF, 0xFF, 0x09, 0x70, 0xAF, 0xFF, 0xE0, 0xE0, 0x17, 0x0E, 0xE8, 0x4D, 0x30, 0x15,
  0xBF, 0xF9, 0x06, 0x70, 0x1E, 0x0E, 0x01, 0x50, 0x30, 0xAF, 0xD0, 0x87, 0x10, 0x3E, 0x07, 0x71,
  0x81, 0x29, 0xEF, 0x90, 0x77, 0x20, 0x5E, 0x02, 0x74, 0x86, 0x5A, 0xDE, 0xEC, 0x82, 0x80, 0xAC,
  0x30, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x83, 0xEC, 0xA7, 0x47, 0x75, 0x81, 0x27, 0xCF, 0xF9, 0x81,
  0xE9, 0x27, 0x70, 0x50, 0xBF, 0xFF, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0xFB, 0x0C, 0x01, 0x71, 0x0B,
  0xFF, 0xFE, 0x0D, 0x01, 0x70, 0x9F, 0xFF, 0xF0, 0xC7, 0x02, 0xFF, 0xFF, 0x90, 0x77, 0x0C, 0xFF,
  0xFF, 0x0E, 0x01, 0x60, 0x6F, 0xFF, 0xF9, 0x07, 0x70, 0xEF, 0xFF, 0xF0, 0xD7, 0x09, 0xF8, 0x6B,
  0x85, 0x42, 0x35, 0xAF, 0xF0, 0x26, 0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F, 0xE0, 0x67, 0x82, 0xCF,
  0x91, 0x75, 0x06, 0xFD, 0x09, 0x70, 0x30, 0x17, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x73, 0x08, 0xFC,
  0x0D, 0x77, 0x73, 0x04, 0xFD, 0x77, 0x73, 0x02, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01,
  0xFD, 0x77, 0x73, 0x01, 0xFD, 0x73, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xFE, 0x71, 0x06, 0x0B, 0xFF,
  0xFE, 0x60, 0x60, 0xEF, 0xFF, 0xF9, 0x40, 0x10, 0xCF, 0xFF, 0xFB, 0x30, 0x20, 0xDF, 0xFF, 0xFC,
  0x20, 0x10, 0xDF, 0xFF, 0xFD, 0x20, 0xAF, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xFF, 0x10, 0xBF, 0xF8,
  0x2A, 0x52, 0x14, 0x01, 0xFD, 0x02, 0xFE, 0x0B, 0x02, 0x71, 0x01, 0xFD, 0x06, 0xFD, 0x0B, 0x73,
  0x01, 0xFD, 0x0A, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x0E, 0xFC,
  0x07, 0x74, 0x03, 0xFF, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFB, 0x04, 0x74, 0x08, 0xFF, 0xFB, 0x06,
  0x74, 0x0E, 0xFD, 0x0E, 0xFC, 0x08, 0x73, 0x07, 0xFE, 0x0D, 0xFC, 0x0E, 0x72, 0x03, 0xFF, 0x0A,
  0xFD, 0x09, 0x70, 0x40, 0xEF, 0xF0, 0x7F, 0xE8, 0x5B, 0x41, 0x01, 0x5B, 0xFF, 0xA0, 0x38, 0x0C,
  0x0F, 0x10, 0xDF, 0xFF, 0xFF, 0x10, 0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB1, 0x01, 0x0E, 0xFF, 0xF8,
  0x1E, 0x17, 0xFB, 0x20, 0x7F, 0xFF, 0x81, 0x40, 0x2F, 0xB3, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA,
  0x30, 0x20, 0xEF, 0xFB, 0x06, 0x40, 0x8F, 0xA4, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA5,
  0x01, 0x09, 0xFD, 0x09, 0x01, 0x70, 0xEF, 0x97, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x17,
  0x74,
  // "ä" (U+00E4)
  0x72, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x75, 0x02, 0x0D, 0xE0, 0xD0,
  0x27, 0x04, 0x0E, 0xE0, 0xC7, 0x40, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x72, 0x03, 0xFB,
  0x04, 0x50, 0x7F, 0xB0, 0x17, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x71, 0x09, 0xFB, 0x0A,
  0x50, 0xDF, 0xB0, 0x77, 0x10, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x71, 0x07, 0xFB, 0x08, 0x50,
  0xCF, 0xB0, 0x67, 0x10, 0x4F, 0xB0, 0x45, 0x08, 0xFB, 0x02, 0x72, 0x0C, 0xF9, 0x0C, 0x60, 0x10,
  0xEF, 0x90, 0xA7, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x75, 0x85, 0x7C,
  0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80, 0xB8, 0x70, 0x85, 0x47, 0x9B, 0xDE, 0xEA,
  0x83, 0xEC, 0xA7, 0x47, 0x75, 0x81, 0x27, 0xCF, 0xF9, 0x81, 0xE9, 0x27, 0x70, 0x50, 0xBF, 0xFF,
  0x08, 0x74, 0x05, 0x0D, 0xFF, 0xFB, 0x0C, 0x01, 0x71, 0x0B, 0xFF, 0xFE, 0x0D, 0x01, 0x70, 0x9F,
  0xFF, 0xF0, 0xC7, 0x02, 0xFF, 0xFF, 0x90, 0x77, 0x0C, 0xFF, 0xFF, 0x0E, 0x01, 0x60, 0x6F, 0xFF,
  0xF9, 0x07, 0x70, 0xEF, 0xFF, 0xF0, 0xD7, 0x09, 0xF8, 0x6B, 0x85, 0x42, 0x35, 0xAF, 0xF0, 0x26,
  0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F, 0xE0, 0x67, 0x82, 0xCF, 0x91, 0x75, 0x06, 0xFD, 0x09, 0x70,
  0x30, 0x17, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x73, 0x08, 0xFC, 0x0D, 0x77, 0x73, 0x04, 0xFD, 0x77,
  0x73, 0x02, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x73,
  0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xFE, 0x71, 0x06, 0x0B, 0xFF, 0xFE, 0x60, 0x60, 0xEF, 0xFF, 0xF9,
  0x40, 0x10, 0xCF, 0xFF, 0xFB, 0x30, 0x20, 0xDF, 0xFF, 0xFC, 0x20, 0x10, 0xDF, 0xFF, 0xFD, 0x20,
  0xAF, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xFF, 0x10, 0xBF, 0xF8, 0x2A, 0x52, 0x14, 0x01, 0xFD, 0x02,
  0xFE, 0x0B, 0x02, 0x71, 0x01, 0xFD, 0x06, 0xFD, 0x0B, 0x73, 0x01, 0xFD, 0x0A, 0xFD, 0x02, 0x73,
  0x01, 0xFD, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x0E, 0xFC, 0x07, 0x74, 0x03, 0xFF, 0xFB, 0x05,
  0x74, 0x05, 0xFF, 0xFB, 0x04, 0x74, 0x08, 0xFF, 0xFB, 0x06, 0x74, 0x0E, 0xFD, 0x0E, 0xFC, 0x08,
  0x73, 0x07, 0xFE, 0x0D, 0xFC, 0x0E, 0x72, 0x03, 0xFF, 0x0A, 0xFD, 0x09, 0x70, 0x40, 0xEF, 0xF0,
  0x7F, 0xE8, 0x5B, 0x41, 0x01, 0x5B, 0xFF, 0xA0, 0x38, 0x0C, 0x0F, 0x10, 0xDF, 0xFF, 0xFF, 0x10,
  0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB1, 0x01, 0x0E, 0xFF, 0xF8, 0x1E, 0x17, 0xFB, 0x20, 0x7F, 0xFF,
  0x81, 0x40, 0x2F, 0xB3, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA, 0x30, 0x20, 0xEF, 0xFB, 0x06, 0x40,
  0x8F, 0xA4, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA5, 0x01, 0x09, 0xFD, 0x09, 0x01, 0x70,
  0xEF, 0x97, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x17, 0x74,
  // "å" (U+00E5)
  0x77, 0x18, 0x90, 0x16, 0xAD, 0xEF, 0xDC, 0x83, 0x77, 0x75, 0x08, 0x0E, 0xFA, 0x0B, 0x02, 0x77,
  0x71, 0x02, 0x0C, 0xFD, 0x0E, 0x05, 0x77, 0x60, 0x10, 0xDF, 0xF9, 0x05, 0x77, 0x50, 0xBF, 0xFB,
  0x03, 0x77, 0x30, 0x4F, 0xFC, 0x0B, 0x77, 0x30, 0xBE, 0x84, 0xE6, 0x10, 0x3B, 0xF0, 0x37, 0x72,
  0xE0, 0xE0, 0x25, 0x0A, 0xE0, 0x87, 0x71, 0x03, 0xE0, 0x76, 0x01, 0xE0, 0xB7, 0x71, 0x05, 0xE0,
  0x27, 0x0B, 0xD0, 0xD7, 0x71, 0x05, 0xE0, 0x17, 0x0A, 0xD0, 0xE7, 0x71, 0x05, 0xE0, 0x27, 0x0B,
  0xD0, 0xD7, 0x71, 0x03, 0xE0, 0x66, 0x01, 0x0E, 0xD0, 0xB7, 0x72, 0xE0, 0xD0, 0x15, 0x09, 0xE0,
  0x87, 0x72, 0x0B, 0xE8, 0x4D, 0x41, 0x03, 0xAF, 0x03, 0x77, 0x20, 0x5F, 0xFC, 0x0B, 0x77, 0x40,
  0xCF, 0xFB, 0x03, 0x77, 0x40, 0x10, 0xDF, 0xF9, 0x06, 0x77, 0x60, 0x20, 0xDF, 0xE0, 0x67, 0x77,
  0x20, 0x9F, 0xB0, 0xB0, 0x37, 0x77, 0x48, 0x90, 0x16, 0xAD, 0xEF, 0xDC, 0x83, 0x80, 0xAD, 0x10,
  0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x83, 0xEC, 0xA7, 0x47, 0x75, 0x81, 0x27, 0xCF, 0xF9, 0x81, 0xE9,
  0x27, 0x70, 0x50, 0xBF, 0xFF, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0xFB, 0x0C, 0x01, 0x71, 0x0B, 0xFF,
  0xFE, 0x0D, 0x01, 0x70, 0x9F, 0xFF, 0xF0, 0xC7, 0x02, 0xFF, 0xFF, 0x90, 0x77, 0x0C, 0xFF, 0xFF,
  0x0E, 0x01, 0x60, 0x6F, 0xFF, 0xF9, 0x07, 0x70, 0xEF, 0xFF, 0xF0, 0xD7, 0x09, 0xF8, 0x6B, 0x85,
  0x42, 0x35, 0xAF, 0xF0, 0x26, 0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F, 0xE0, 0x67, 0x82, 0xCF, 0x91,
  0x75, 0x06, 0xFD, 0x09, 0x70, 0x30, 0x17, 0x71, 0x0D, 0xFC, 0x0C, 0x77, 0x73, 0x08, 0xFC, 0x0D,
  0x77, 0x73, 0x04, 0xFD, 0x77, 0x73, 0x02, 0xFD, 0x77, 0x73, 0x01, 0xFD, 0x77, 0x73, 0x01, 0xFD,
  0x77, 0x73, 0x01, 0xFD, 0x73, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xFE, 0x71, 0x06, 0x0B, 0xFF, 0xFE,
  0x60, 0x60, 0xEF, 0xFF, 0xF9, 0x40, 0x10, 0xCF, 0xFF, 0xFB, 0x30, 0x20, 0xDF, 0xFF, 0xFC, 0x20,
  0x10, 0xDF, 0xFF, 0xFD, 0x20, 0xAF, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xFF, 0x10, 0xBF, 0xF8, 0x2A,
  0x52, 0x14, 0x01, 0xFD, 0x02, 0xFE, 0x0B, 0x02, 0x71, 0x01, 0xFD, 0x06, 0xFD, 0x0B, 0x73, 0x01,
  0xFD, 0x0A, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x0E, 0xFC, 0x07,
  0x74, 0x03, 0xFF, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFB, 0x04, 0x74, 0x08, 0xFF, 0xFB, 0x06, 0x74,
  0x0E, 0xFD, 0x0E, 0xFC, 0x08, 0x73, 0x07, 0xFE, 0x0D, 0xFC, 0x0E, 0x72, 0x03, 0xFF, 0x0A, 0xFD,
  0x09, 0x70, 0x40, 0xEF, 0xF0, 0x7F, 0xE8, 0x5B, 0x41, 0x01, 0x5B, 0xFF, 0xA0, 0x38, 0x0C, 0x0F,
  0x10, 0xDF, 0xFF, 0xFF, 0x10, 0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB1, 0x01, 0x0E, 0xFF, 0xF8, 0x1E,
  0x17, 0xFB, 0x20, 0x7F, 0xFF, 0x81, 0x40, 0x2F, 0xB3, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA, 0x30,
  0x20, 0xEF, 0xFB, 0x06, 0x40, 0x8F, 0xA4, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA5, 0x01,
  0x09, 0xFD, 0x09, 0x01, 0x70, 0xEF, 0x97, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x17, 0x74,
  // "æ" (U+00E6)
  0x75, 0x89, 0x42, 0x58, 0xBC, 0xEE, 0xFE, 0xEC, 0x95, 0x17, 0x58, 0x32, 0x6A, 0xCE, 0xA8, 0x3E,
  0xDB, 0x84, 0x77, 0x71, 0x81, 0x28, 0xDF, 0xF0, 0xA0, 0x37, 0x10, 0x50, 0xCF, 0xD8, 0x1E, 0x92,
  0x77, 0x30, 0x60, 0xCF, 0xFD, 0x09, 0x50, 0x20, 0xCF, 0xFB, 0x09, 0x77, 0x06, 0x0D, 0xFF, 0xF9,
  0x0C, 0x01, 0x20, 0x40, 0xEF, 0xFD, 0x0D, 0x02, 0x74, 0x0C, 0xFF, 0xFC, 0x81, 0xC0, 0x5F, 0xFF,
  0x90, 0xE0, 0x37, 0x30, 0x8F, 0xFF, 0xD0, 0xBF, 0xFF, 0xB0, 0xE0, 0x27, 0x20, 0x28, 0x0E, 0x0F,
  0x0D, 0x73, 0x0B, 0x80, 0xE0, 0xF0, 0x97, 0x20, 0x58, 0x0E, 0x1F, 0x03, 0x72, 0x0E, 0x80, 0xE0,
  0xF0, 0xB7, 0x20, 0x9E, 0x87, 0xC8, 0x52, 0x10, 0x14, 0x9F, 0xFC, 0x81, 0xD6, 0x22, 0x81, 0x27,
  0xEF, 0xD0, 0x37, 0x10, 0x3B, 0x81, 0xE8, 0x27, 0x20, 0x4F, 0xFA, 0x09, 0x70, 0x10, 0xCF, 0xC0,
  0x97, 0x28, 0x1C, 0xD6, 0x76, 0x07, 0xFF, 0x0A, 0x72, 0x01, 0x0E, 0xFB, 0x0E, 0x72, 0x02, 0x77,
  0x20, 0xEF, 0xD0, 0xE0, 0x17, 0x30, 0x6F, 0xC0, 0x37, 0x77, 0x40, 0xBF, 0xD0, 0x87, 0x50, 0xEF,
  0xB0, 0x77, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x50, 0x9F, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0, 0xE7,
  0x60, 0x6F, 0xB0, 0xD7, 0x77, 0x40, 0x5F, 0xC0, 0xB7, 0x60, 0x3F, 0xC7, 0x77, 0x40, 0x5F, 0xC0,
  0x97, 0x60, 0x2F, 0xC0, 0x27, 0x77, 0x30, 0x5F, 0xC0, 0x87, 0x60, 0x1F, 0xC0, 0x37, 0x38, 0x51,
  0x58, 0xBC, 0xEE, 0x80, 0xD1, 0xF0, 0x47, 0x81, 0x17, 0xC8, 0x0E, 0x0F, 0x04, 0x60, 0x70, 0xE8,
  0x0E, 0x2F, 0x05, 0x40, 0x20, 0xC8, 0x0E, 0x4F, 0x05, 0x30, 0x30, 0xE8, 0x0E, 0x5F, 0x05, 0x20,
  0x10, 0xE8, 0x0E, 0x6F, 0x05, 0x20, 0xB8, 0x0E, 0x7F, 0x81, 0x50, 0x58, 0x0F, 0x0F, 0x81, 0x50,
  0xCF, 0xE8, 0x3E, 0x95, 0x21, 0x40, 0x58, 0x0C, 0x1F, 0x05, 0x02, 0xFE, 0x0A, 0x01, 0x71, 0x05,
  0xFC, 0x07, 0x77, 0x75, 0x07, 0xFD, 0x0A, 0x73, 0x05, 0xFC, 0x08, 0x77, 0x75, 0x0A, 0xFD, 0x01,
  0x73, 0x05, 0xFC, 0x09, 0x77, 0x75, 0x0C, 0xFC, 0x0A, 0x74, 0x06, 0xFC, 0x0B, 0x77, 0x75, 0x0E,
  0xFC, 0x06, 0x74, 0x07, 0xFC, 0x0E, 0x77, 0x75, 0xFD, 0x05, 0x74, 0x09, 0xFD, 0x03, 0x77, 0x74,
  0xFD, 0x05, 0x74, 0x0D, 0xFD, 0x09, 0x77, 0x74, 0xFD, 0x06, 0x73, 0x04, 0xFF, 0x02, 0x77, 0x73,
  0x0D, 0xFC, 0x09, 0x73, 0x0B, 0xFF, 0x0C, 0x77, 0x60, 0x53, 0x0C, 0xFC, 0x0E, 0x72, 0x08, 0xFF,
  0xA0, 0xA7, 0x73, 0x81, 0x6D, 0xE3, 0x09, 0xFD, 0x0A, 0x70, 0x9F, 0xFC, 0x0C, 0x04, 0x75, 0x81,
  0x49, 0xEA, 0x0E, 0x30, 0x6F, 0xE8, 0x5C, 0x63, 0x24, 0x8E, 0xFF, 0xF8, 0x91, 0xC8, 0x53, 0x23,
  0x45, 0x69, 0xCE, 0x0E, 0x30, 0x28, 0x0E, 0x6F, 0x0E, 0x40, 0xCF, 0xFF, 0xD0, 0x70, 0xAF, 0xFF,
  0xF9, 0x0E, 0x40, 0x5F, 0xFF, 0xC8, 0x2B, 0x01, 0xEF, 0xFF, 0xF0, 0xE5, 0x0D, 0xFF, 0xFA, 0x0D,
  0x01, 0x20, 0x4F, 0xFF, 0xF0, 0xE5, 0x03, 0xFF, 0xF9, 0x0E, 0x02, 0x40, 0x6F, 0xFF, 0xE0, 0xE6,
  0x08, 0xFF, 0xE0, 0xE0, 0x36, 0x06, 0xFF, 0xFD, 0x0E, 0x70, 0xAF, 0xFC, 0x0C, 0x02, 0x71, 0x04,
  0x0D, 0xFF, 0xFB, 0x09, 0x71, 0x09, 0xFF, 0xA0, 0x87, 0x50, 0x8F, 0xFF, 0x0A, 0x03, 0x73, 0x04,
  0x0C, 0xFD, 0x0A, 0x02, 0x77, 0x81, 0x17, 0xDF, 0xF9, 0x81, 0xC7, 0x27, 0x78, 0x23, 0x8B, 0xDA,
  0x83, 0xED, 0xB8, 0x57, 0x76, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x72,
  // "ç" (U+00E7)
  0x77, 0x89, 0x42, 0x69, 0xBD, 0xEF, 0xED, 0xCB, 0x95, 0x27, 0x73, 0x81, 0x17, 0xDF, 0xF8, 0x1D,
  0x83, 0x76, 0x07, 0x0E, 0xFF, 0xD0, 0xC0, 0x47, 0x20, 0x20, 0xCF, 0xFF, 0xA0, 0x97, 0x03, 0x0E,
  0xFF, 0xFB, 0x06, 0x60, 0x30, 0xEF, 0xFF, 0xC0, 0x15, 0x01, 0x0D, 0xFF, 0xFC, 0x0A, 0x60, 0xBF,
  0xFF, 0xD0, 0x55, 0x06, 0xFF, 0xFD, 0x0E, 0x60, 0xEF, 0xFF, 0xD0, 0x95, 0x07, 0xFF, 0x86, 0xC6,
  0x42, 0x45, 0x9E, 0xD0, 0x45, 0x0E, 0xFD, 0x0E, 0x04, 0x71, 0x05, 0x0B, 0xA0, 0xD5, 0x05, 0xFE,
  0x03, 0x74, 0x81, 0x3B, 0x85, 0x0A, 0xFD, 0x06, 0x77, 0x6F, 0xD0, 0xD7, 0x76, 0x04, 0xFD, 0x06,
  0x77, 0x60, 0x8F, 0xD0, 0x17, 0x76, 0x0B, 0xFC, 0x0C, 0x77, 0x70, 0xEF, 0xC0, 0x87, 0x76, 0x01,
  0xFD, 0x06, 0x77, 0x60, 0x3F, 0xD0, 0x47, 0x76, 0x04, 0xFD, 0x02, 0x77, 0x60, 0x5F, 0xD7, 0x77,
  0x06, 0xFD, 0x77, 0x70, 0x7F, 0xD7, 0x77, 0x07, 0xFC, 0x0E, 0x77, 0x70, 0x7F, 0xD7, 0x77, 0x06,
  0xFD, 0x77, 0x70, 0x6F, 0xD7, 0x77, 0x05, 0xFD, 0x01, 0x77, 0x60, 0x4F, 0xD0, 0x37, 0x76, 0x03,
  0xFD, 0x05, 0x77, 0x60, 0x1F, 0xD0, 0x77, 0x77, 0x0E, 0xFC, 0x0B, 0x77, 0x70, 0xBF, 0xD7, 0x77,
  0x08, 0xFD, 0x05, 0x77, 0x60, 0x5F, 0xD0, 0xC7, 0x76, 0x01, 0xFE, 0x06, 0x77, 0x10, 0x30, 0x73,
  0x0C, 0xFD, 0x0E, 0x02, 0x75, 0x82, 0x19, 0xF9, 0x30, 0x6F, 0xE0, 0xE0, 0x47, 0x20, 0x30, 0xAB,
  0x09, 0x30, 0x10, 0xEF, 0xF8, 0x7C, 0x64, 0x23, 0x56, 0xAE, 0xD0, 0x94, 0x09, 0xFF, 0xFF, 0x09,
  0x40, 0x10, 0xEF, 0xFF, 0xE0, 0x95, 0x07, 0xFF, 0xFE, 0x09, 0x60, 0xBF, 0xFF, 0xD0, 0x96, 0x01,
  0x0C, 0xFF, 0xFC, 0x09, 0x70, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x20, 0xAF, 0xFF, 0xA0, 0x67, 0x30,
  0x40, 0xDF, 0xFD, 0x0A, 0x01, 0x76, 0x05, 0x0B, 0xFF, 0x81, 0xE8, 0x27, 0x73, 0x81, 0x15, 0xAF,
  0x82, 0xC9, 0x63, 0x77, 0x71, 0x08, 0xE0, 0x37, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x75, 0x06, 0xE0,
  0x57, 0x77, 0x50, 0xDE, 0x81, 0xEA, 0x47, 0x77, 0x20, 0x4F, 0xB0, 0xC0, 0x37, 0x77, 0x0B, 0xFD,
  0x06, 0x77, 0x50, 0x10, 0xDF, 0xE0, 0x57, 0x77, 0x81, 0x38, 0xEF, 0xA0, 0xE7, 0x77, 0x20, 0x10,
  0xCF, 0xA0, 0x67, 0x77, 0x20, 0x1F, 0xA0, 0xA7, 0x77, 0x30, 0xBF, 0x90, 0xC7, 0x77, 0x30, 0xCF,
  0x90, 0xC7, 0x77, 0x20, 0x2F, 0xA0, 0xA7, 0x71, 0x87, 0x67, 0x42, 0x10, 0x15, 0xDF, 0xA0, 0x87,
  0x71, 0x09, 0xFF, 0xB0, 0x47, 0x71, 0x09, 0xFF, 0xA0, 0xD7, 0x72, 0x09, 0xFF, 0xA0, 0x67, 0x72,
  0x09, 0xFF, 0x90, 0x97, 0x73, 0x09, 0xFF, 0x09, 0x77, 0x40, 0x9F, 0xD0, 0xC0, 0x57, 0x75, 0x84,
  0x27, 0xAC, 0xEE, 0xA8, 0x3E, 0xDA, 0x73, 0x74,
  // "è" (U+00E8)
  0x50, 0x38, 0x09, 0x17, 0x04, 0x77, 0x73, 0x04, 0xFE, 0x0E, 0x77, 0x74, 0x08, 0xFE, 0x07, 0x77,
  0x74, 0x09, 0xFD, 0x0E, 0x01, 0x77, 0x74, 0x0A, 0xFD, 0x0A, 0x77, 0x75, 0x0B, 0xFD, 0x04, 0x77,
  0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x76, 0x0B, 0xFC, 0x08, 0x77, 0x76, 0x0B, 0xFC, 0x02, 0x77, 0x76,
  0x0B, 0xFB, 0x0C, 0x77, 0x77, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x0A, 0xFB, 0x02, 0x77, 0x77, 0x09,
  0xFA, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xA0, 0x77, 0x77, 0x71, 0x05, 0xF9, 0x0B, 0x80, 0xAE, 0x10,
  0x83, 0x48, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x77, 0x30, 0x30, 0xAF, 0xE8, 0x1E, 0x92, 0x77,
  0x50, 0x20, 0xAF, 0xFC, 0x09, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x0D, 0x03, 0x77, 0x07, 0xFF, 0xFA,
  0x0E, 0x04, 0x75, 0x07, 0xFF, 0xFD, 0x03, 0x73, 0x05, 0xFF, 0xFE, 0x0E, 0x01, 0x71, 0x01, 0x0E,
  0xFF, 0xFF, 0x0B, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0x56, 0x03, 0xFE, 0x85, 0x83, 0x10, 0x27, 0xEF,
  0xC0, 0xD6, 0x0B, 0xFC, 0x0D, 0x02, 0x60, 0x10, 0xCF, 0xC0, 0x54, 0x02, 0xFC, 0x0E, 0x02, 0x71,
  0x01, 0x0E, 0xFB, 0x0C, 0x40, 0x8F, 0xC0, 0x67, 0x30, 0x6F, 0xC0, 0x23, 0x0D, 0xFB, 0x0E, 0x75,
  0x0E, 0xFB, 0x07, 0x20, 0x2F, 0xC0, 0x87, 0x50, 0x9F, 0xB0, 0xB2, 0x06, 0xFC, 0x04, 0x75, 0x04,
  0xFB, 0x0E, 0x20, 0x9F, 0xC0, 0x17, 0x50, 0x2F, 0xC8, 0x11, 0x0C, 0xFB, 0x0E, 0x77, 0xFC, 0x81,
  0x40, 0xEF, 0xB0, 0xD7, 0x70, 0xEF, 0xB0, 0x50, 0x1F, 0xC0, 0xC7, 0x70, 0xDF, 0xB0, 0x70, 0x38,
  0x0C, 0x1F, 0x08, 0x04, 0x80, 0xC1, 0xF0, 0x80, 0x58, 0x0C, 0x1F, 0x08, 0x06, 0x80, 0xC1, 0xF0,
  0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x06, 0x80,
  0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F, 0x09, 0x05, 0xFC, 0x0A, 0x77, 0x75, 0x03, 0xFC, 0x0B, 0x77,
  0x75, 0x02, 0xFC, 0x0D, 0x77, 0x76, 0xFD, 0x77, 0x76, 0x0D, 0xFC, 0x03, 0x77, 0x75, 0x09, 0xFC,
  0x07, 0x77, 0x75, 0x06, 0xFC, 0x0D, 0x77, 0x75, 0x02, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFC, 0x0E,
  0x01, 0x77, 0x50, 0x30, 0x14, 0x07, 0xFD, 0x0D, 0x01, 0x77, 0x28, 0x24, 0xBF, 0x24, 0x01, 0xFE,
  0x0E, 0x06, 0x75, 0x81, 0x27, 0xDB, 0x02, 0x50, 0xAF, 0xF8, 0x92, 0xD9, 0x54, 0x23, 0x34, 0x58,
  0xBE, 0xE0, 0x25, 0x02, 0xFF, 0xFF, 0xC0, 0x26, 0x08, 0xFF, 0xFF, 0xB0, 0x27, 0x0D, 0xFF, 0xFF,
  0xA0, 0x27, 0x02, 0x0E, 0xFF, 0xFF, 0x90, 0x27, 0x10, 0x4F, 0xFF, 0xF9, 0x02, 0x72, 0x04, 0x0E,
  0xFF, 0xFE, 0x02, 0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x06, 0x0E, 0xFF, 0xF0, 0xC0,
  0x57, 0x72, 0x06, 0x0B, 0xFF, 0xA8, 0x1D, 0x83, 0x77, 0x68, 0x96, 0x15, 0x8B, 0xDE, 0xEF, 0xEE,
  0xDC, 0xA7, 0x52, 0x72,
  // "é" (U+00E9)
  0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x77, 0x30, 0xEF, 0xE0, 0x37, 0x77, 0x20, 0x8F, 0xE0, 0x57, 0x77,
  0x20, 0x2F, 0xE0, 0x67, 0x77, 0x30, 0xBF, 0xD0, 0x67, 0x77, 0x30, 0x5F, 0xD0, 0x67, 0x77, 0x30,
  0x10, 0xEF, 0xC0, 0x67, 0x77, 0x40, 0xAF, 0xC0, 0x57, 0x77, 0x40, 0x6F, 0xC0, 0x57, 0x77, 0x40,
  0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x50, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x50, 0x7F, 0xA0, 0xD0,
  0x27, 0x77, 0x50, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x60, 0x6F, 0x90, 0xA8, 0x0A, 0xE7, 0x08, 0x34,
  0x8B, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x73, 0x03, 0x0A, 0xFE, 0x81, 0xE9, 0x27, 0x75, 0x02,
  0x0A, 0xFF, 0xC0, 0x97, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xD0, 0x37, 0x70, 0x7F, 0xFF, 0xA0, 0xE0,
  0x47, 0x50, 0x7F, 0xFF, 0xD0, 0x37, 0x30, 0x5F, 0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x10, 0xEF, 0xFF,
  0xF0, 0xB7, 0x10, 0xAF, 0xFF, 0xFA, 0x05, 0x60, 0x3F, 0xE8, 0x58, 0x31, 0x02, 0x7E, 0xFC, 0x0D,
  0x60, 0xBF, 0xC0, 0xD0, 0x26, 0x01, 0x0C, 0xFC, 0x05, 0x40, 0x2F, 0xC0, 0xE0, 0x27, 0x10, 0x10,
  0xEF, 0xB0, 0xC4, 0x08, 0xFC, 0x06, 0x73, 0x06, 0xFC, 0x02, 0x30, 0xDF, 0xB0, 0xE7, 0x50, 0xEF,
  0xB0, 0x72, 0x02, 0xFC, 0x08, 0x75, 0x09, 0xFB, 0x0B, 0x20, 0x6F, 0xC0, 0x47, 0x50, 0x4F, 0xB0,
  0xE2, 0x09, 0xFC, 0x01, 0x75, 0x02, 0xFC, 0x81, 0x10, 0xCF, 0xB0, 0xE7, 0x7F, 0xC8, 0x14, 0x0E,
  0xFB, 0x0D, 0x77, 0x0E, 0xFB, 0x05, 0x01, 0xFC, 0x0C, 0x77, 0x0D, 0xFB, 0x07, 0x03, 0x80, 0xC1,
  0xF0, 0x80, 0x48, 0x0C, 0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F, 0x09, 0x07,
  0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F,
  0x09, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x5F, 0xC0, 0xA7, 0x77, 0x50, 0x3F, 0xC0, 0xB7, 0x77, 0x50,
  0x2F, 0xC0, 0xD7, 0x77, 0x6F, 0xD7, 0x77, 0x60, 0xDF, 0xC0, 0x37, 0x77, 0x50, 0x9F, 0xC0, 0x77,
  0x77, 0x50, 0x6F, 0xC0, 0xD7, 0x77, 0x50, 0x2F, 0xD0, 0x57, 0x77, 0x50, 0xCF, 0xC0, 0xE0, 0x17,
  0x75, 0x03, 0x01, 0x40, 0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x82, 0x4B, 0xF2, 0x40, 0x1F, 0xE0, 0xE0,
  0x67, 0x58, 0x12, 0x7D, 0xB0, 0x25, 0x0A, 0xFF, 0x89, 0x2D, 0x95, 0x42, 0x33, 0x45, 0x8B, 0xEE,
  0x02, 0x50, 0x2F, 0xFF, 0xFC, 0x02, 0x60, 0x8F, 0xFF, 0xFB, 0x02, 0x70, 0xDF, 0xFF, 0xFA, 0x02,
  0x70, 0x20, 0xEF, 0xFF, 0xF9, 0x02, 0x71, 0x04, 0xFF, 0xFF, 0x90, 0x27, 0x20, 0x40, 0xEF, 0xFF,
  0xE0, 0x27, 0x30, 0x20, 0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x60, 0xEF, 0xFF, 0x0C, 0x05, 0x77,
  0x20, 0x60, 0xBF, 0xFA, 0x81, 0xD8, 0x37, 0x76, 0x89, 0x61, 0x58, 0xBD, 0xEE, 0xFE, 0xED, 0xCA,
  0x75, 0x27, 0x20,
  // "ê" (U+00EA)
  0x76, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x40, 0x9F, 0xD0, 0xB7, 0x77, 0x30, 0x3F, 0xF0, 0x47,
  0x77, 0x20, 0xCF, 0xF0, 0xD7, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x77, 0x60, 0x3F, 0xFC, 0x03, 0x77,
  0x50, 0xDF, 0xFC, 0x0D, 0x77, 0x40, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x20, 0x4F, 0xA8, 0x1E,
  0x33, 0xFB, 0x05, 0x77, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x60, 0xBF, 0xA0,
  0x44, 0x05, 0xFA, 0x0C, 0x75, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x97, 0x30, 0x4F, 0x90, 0xE0,
  0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x10, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03,
  0x70, 0x6F, 0x0C, 0x01, 0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xD1, 0x08, 0x34, 0x8B, 0xDE, 0xA8,
  0x3E, 0xDB, 0x84, 0x77, 0x73, 0x03, 0x0A, 0xFE, 0x81, 0xE9, 0x27, 0x75, 0x02, 0x0A, 0xFF, 0xC0,
  0x97, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xD0, 0x37, 0x70, 0x7F, 0xFF, 0xA0, 0xE0, 0x47, 0x50, 0x7F,
  0xFF, 0xD0, 0x37, 0x30, 0x5F, 0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0xB7, 0x10,
  0xAF, 0xFF, 0xFA, 0x05, 0x60, 0x3F, 0xE8, 0x58, 0x31, 0x02, 0x7E, 0xFC, 0x0D, 0x60, 0xBF, 0xC0,
  0xD0, 0x26, 0x01, 0x0C, 0xFC, 0x05, 0x40, 0x2F, 0xC0, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0xB0, 0xC4,
  0x08, 0xFC, 0x06, 0x73, 0x06, 0xFC, 0x02, 0x30, 0xDF, 0xB0, 0xE7, 0x50, 0xEF, 0xB0, 0x72, 0x02,
  0xFC, 0x08, 0x75, 0x09, 0xFB, 0x0B, 0x20, 0x6F, 0xC0, 0x47, 0x50, 0x4F, 0xB0, 0xE2, 0x09, 0xFC,
  0x01, 0x75, 0x02, 0xFC, 0x81, 0x10, 0xCF, 0xB0, 0xE7, 0x7F, 0xC8, 0x14, 0x0E, 0xFB, 0x0D, 0x77,
  0x0E, 0xFB, 0x05, 0x01, 0xFC, 0x0C, 0x77, 0x0D, 0xFB, 0x07, 0x03, 0x80, 0xC1, 0xF0, 0x80, 0x48,
  0x0C, 0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0,
  0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F, 0x09, 0x06, 0x80,
  0xC1, 0xF0, 0x90, 0x5F, 0xC0, 0xA7, 0x77, 0x50, 0x3F, 0xC0, 0xB7, 0x77, 0x50, 0x2F, 0xC0, 0xD7,
  0x77, 0x6F, 0xD7, 0x77, 0x60, 0xDF, 0xC0, 0x37, 0x77, 0x50, 0x9F, 0xC0, 0x77, 0x77, 0x50, 0x6F,
  0xC0, 0xD7, 0x77, 0x50, 0x2F, 0xD0, 0x57, 0x77, 0x50, 0xCF, 0xC0, 0xE0, 0x17, 0x75, 0x03, 0x01,
  0x40, 0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x82, 0x4B, 0xF2, 0x40, 0x1F, 0xE0, 0xE0, 0x67, 0x58, 0x12,
  0x7D, 0xB0, 0x25, 0x0A, 0xFF, 0x89, 0x2D, 0x95, 0x42, 0x33, 0x45, 0x8B, 0xEE, 0x02, 0x50, 0x2F,
  0xFF, 0xFC, 0x02, 0x60, 0x8F, 0xFF, 0xFB, 0x02, 0x70, 0xDF, 0xFF, 0xFA, 0x02, 0x70, 0x20, 0xEF,
  0xFF, 0xF9, 0x02, 0x71, 0x04, 0xFF, 0xFF, 0x90, 0x27, 0x20, 0x40, 0xEF, 0xFF, 0xE0, 0x27, 0x30,
  0x20, 0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x60, 0xEF, 0xFF, 0x0C, 0x05, 0x77, 0x20, 0x60, 0xBF,
  0xFA, 0x81, 0xD8, 0x37, 0x76, 0x89, 0x61, 0x58, 0xBD, 0xEE, 0xFE, 0xED, 0xCA, 0x75, 0x27, 0x20,
  // "ë" (U+00EB)
  0x71, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x02, 0x0D, 0xE0, 0xD0,
  0x27, 0x04, 0x0E, 0xE0, 0xC7, 0x60, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x74, 0x03, 0xFB,
  0x04, 0x50, 0x7F, 0xB0, 0x17, 0x30, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x73, 0x09, 0xFB, 0x0A,
  0x50, 0xDF, 0xB0, 0x77, 0x30, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x73, 0x07, 0xFB, 0x08, 0x50,
  0xCF, 0xB0, 0x67, 0x30, 0x4F, 0xB0, 0x45, 0x08, 0xFB, 0x02, 0x74, 0x0C, 0xF9, 0x0C, 0x60, 0x10,
  0xEF, 0x90, 0xA7, 0x50, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x77, 0x85, 0x7C,
  0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80, 0xBA, 0x50, 0x83, 0x48, 0xBD, 0xEA, 0x83,
  0xED, 0xB8, 0x47, 0x77, 0x30, 0x30, 0xAF, 0xE8, 0x1E, 0x92, 0x77, 0x50, 0x20, 0xAF, 0xFC, 0x09,
  0x77, 0x30, 0x50, 0xEF, 0xFE, 0x0D, 0x03, 0x77, 0x07, 0xFF, 0xFA, 0x0E, 0x04, 0x75, 0x07, 0xFF,
  0xFD, 0x03, 0x73, 0x05, 0xFF, 0xFE, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0x0B, 0x71, 0x0A,
  0xFF, 0xFF, 0xA0, 0x56, 0x03, 0xFE, 0x85, 0x83, 0x10, 0x27, 0xEF, 0xC0, 0xD6, 0x0B, 0xFC, 0x0D,
  0x02, 0x60, 0x10, 0xCF, 0xC0, 0x54, 0x02, 0xFC, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xFB, 0x0C, 0x40,
  0x8F, 0xC0, 0x67, 0x30, 0x6F, 0xC0, 0x23, 0x0D, 0xFB, 0x0E, 0x75, 0x0E, 0xFB, 0x07, 0x20, 0x2F,
  0xC0, 0x87, 0x50, 0x9F, 0xB0, 0xB2, 0x06, 0xFC, 0x04, 0x75, 0x04, 0xFB, 0x0E, 0x20, 0x9F, 0xC0,
  0x17, 0x50, 0x2F, 0xC8, 0x11, 0x0C, 0xFB, 0x0E, 0x77, 0xFC, 0x81, 0x40, 0xEF, 0xB0, 0xD7, 0x70,
  0xEF, 0xB0, 0x50, 0x1F, 0xC0, 0xC7, 0x70, 0xDF, 0xB0, 0x70, 0x38, 0x0C, 0x1F, 0x08, 0x04, 0x80,
  0xC1, 0xF0, 0x80, 0x58, 0x0C, 0x1F, 0x08, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09,
  0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C,
  0x1F, 0x09, 0x05, 0xFC, 0x0A, 0x77, 0x75, 0x03, 0xFC, 0x0B, 0x77, 0x75, 0x02, 0xFC, 0x0D, 0x77,
  0x76, 0xFD, 0x77, 0x76, 0x0D, 0xFC, 0x03, 0x77, 0x75, 0x09, 0xFC, 0x07, 0x77, 0x75, 0x06, 0xFC,
  0x0D, 0x77, 0x75, 0x02, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFC, 0x0E, 0x01, 0x77, 0x50, 0x30, 0x14,
  0x07, 0xFD, 0x0D, 0x01, 0x77, 0x28, 0x24, 0xBF, 0x24, 0x01, 0xFE, 0x0E, 0x06, 0x75, 0x81, 0x27,
  0xDB, 0x02, 0x50, 0xAF, 0xF8, 0x92, 0xD9, 0x54, 0x23, 0x34, 0x58, 0xBE, 0xE0, 0x25, 0x02, 0xFF,
  0xFF, 0xC0, 0x26, 0x08, 0xFF, 0xFF, 0xB0, 0x27, 0x0D, 0xFF, 0xFF, 0xA0, 0x27, 0x02, 0x0E, 0xFF,
  0xFF, 0x90, 0x27, 0x10, 0x4F, 0xFF, 0xF9, 0x02, 0x72, 0x04, 0x0E, 0xFF, 0xFE, 0x02, 0x73, 0x02,
  0x0C, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x06, 0x0E, 0xFF, 0xF0, 0xC0, 0x57, 0x72, 0x06, 0x0B, 0xFF,
  0xA8, 0x1D, 0x83, 0x77, 0x68, 0x96, 0x15, 0x8B, 0xDE, 0xEF, 0xEE, 0xDC, 0xA7, 0x52, 0x72,
  // "ì" (U+00EC)
  0x03, 0x80, 0x91, 0x70, 0x47, 0x10, 0x4F, 0xE0, 0xE7, 0x20, 0x8F, 0xE0, 0x77, 0x20, 0x9F, 0xD0,
  0xE0, 0x17, 0x20, 0xAF, 0xD0, 0xA7, 0x30, 0xBF, 0xD0, 0x47, 0x30, 0xBF, 0xC0, 0xD7, 0x40, 0xBF,
  0xC0, 0x87, 0x40, 0xBF, 0xC0, 0x27, 0x40, 0xBF, 0xB0, 0xC7, 0x50, 0xAF, 0xB0, 0x77, 0x50, 0xAF,
  0xB0, 0x27, 0x50, 0x9F, 0xA0, 0xC7, 0x60, 0x7F, 0xA0, 0x77, 0x60, 0x5F, 0x90, 0xB8, 0x09, 0xE7,
  0x00, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7, 0x30, 0x5F, 0xC0, 0xE7,
  0x30, 0x5F, 0xC0, 0xE2,
  // "í" (U+00ED)
  0x71, 0x06, 0xFE, 0x0B, 0x71, 0x0E, 0xFE, 0x03, 0x70, 0x8F, 0xE0, 0x57, 0x02, 0xFE, 0x06, 0x71,
  0x0B, 0xFD, 0x06, 0x71, 0x05, 0xFD, 0x06, 0x71, 0x01, 0x0E, 0xFC, 0x06, 0x72, 0x0A, 0xFC, 0x05,
  0x72, 0x06, 0xFC, 0x05, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x73, 0x0B, 0xFA, 0x0E, 0x03, 0x73,
  0x07, 0xFA, 0x0D, 0x02, 0x73, 0x02, 0xFA, 0x0C, 0x01, 0x74, 0x06, 0xF9, 0x0A, 0x80, 0x9F, 0x50,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73, 0x05, 0xFC, 0x0E, 0x73,
  0x05, 0xFC, 0x0E, 0x72,
  // "î" (U+00EE)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x74, 0x09, 0xFD, 0x0B, 0x77, 0x30, 0x3F, 0xF0, 0x47, 0x72,
  0x0C, 0xFF, 0x0D, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x76, 0x03, 0xFF, 0xC0, 0x37, 0x50, 0xDF, 0xFC,
  0x0D, 0x74, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x20, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x70,
  0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x60, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x50,
  0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x98, 0x26,
  0x02, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xAC, 0x50, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75,
  0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0,
  0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50,
  0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x73,
  // "ï" (U+00EF)
  0x38, 0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x64, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC3, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x98, 0x1A, 0x03, 0xFB, 0x04, 0x50,
  0x7F, 0xB0, 0x10, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x70,
  0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x00, 0x7F, 0xB0, 0x85, 0x0C, 0xFB, 0x06, 0x04, 0xFB, 0x04, 0x50,
  0x8F, 0xB8, 0x12, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xEF, 0x90, 0xA2, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x04, 0x0E, 0xE0, 0xC0, 0x14, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80,
  0xAE, 0x50, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20,
  0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E,
  0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05,
  0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7,
  0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F,
  0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77,
  0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC,
  0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72,
  0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0,
  0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20,
  0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E,
  0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05,
  0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7,
  0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x71,
  // "ð" (U+00F0)
  0x77, 0x81, 0x6B, 0x37, 0x58, 0x11, 0xB2, 0x77, 0x71, 0x02, 0x0E, 0xA0, 0x90, 0x17, 0x28, 0x25,
  0xEF, 0xC7, 0x77, 0x10, 0xCC, 0x0E, 0x06, 0x60, 0x10, 0xAC, 0x09, 0x77, 0x60, 0x8F, 0x0C, 0x02,
  0x30, 0x30, 0xDE, 0x05, 0x77, 0x40, 0x4F, 0xA8, 0x2E, 0x50, 0x8F, 0x90, 0xE0, 0x27, 0x72, 0x01,
  0x0D, 0xFC, 0x0D, 0xFB, 0x0D, 0x77, 0x20, 0xAF, 0xFF, 0xA0, 0x77, 0x72, 0x03, 0x0D, 0xFF, 0xE0,
  0xD0, 0x37, 0x75, 0x09, 0xFF, 0xC0, 0x97, 0x77, 0x10, 0x50, 0xEF, 0xF0, 0xD0, 0x47, 0x77, 0x30,
  0x30, 0xDF, 0xE0, 0x47, 0x77, 0x40, 0x40, 0xDF, 0xE0, 0xE0, 0x27, 0x77, 0x20, 0x8F, 0xFA, 0x0D,
  0x77, 0x70, 0x20, 0xCF, 0xFC, 0x0B, 0x77, 0x50, 0x60, 0xEF, 0xFE, 0x06, 0x77, 0x30, 0x7F, 0xFF,
  0x90, 0xE0, 0x27, 0x72, 0x01, 0x0E, 0xFA, 0x0B, 0xFD, 0x0C, 0x77, 0x30, 0x4F, 0x82, 0xE5, 0x07,
  0xFD, 0x06, 0x77, 0x30, 0x8D, 0x0B, 0x01, 0x30, 0xAF, 0xC0, 0xE7, 0x74, 0x0B, 0xB0, 0x66, 0x0D,
  0xFC, 0x07, 0x77, 0x38, 0x21, 0xEC, 0x27, 0x05, 0xFC, 0x0E, 0x01, 0x77, 0x30, 0x27, 0x30, 0xAF,
  0xC0, 0x77, 0x77, 0x70, 0x2F, 0xC0, 0xE7, 0x77, 0x71, 0x09, 0xFC, 0x06, 0x77, 0x77, 0x02, 0xFC,
  0x0C, 0x77, 0x28, 0x91, 0x37, 0xBD, 0xEF, 0xED, 0xB7, 0x22, 0x0B, 0xFC, 0x02, 0x76, 0x07, 0x0D,
  0xFC, 0x81, 0xA2, 0x5F, 0xC0, 0x77, 0x40, 0x60, 0xEF, 0xF0, 0xE0, 0x6F, 0xC0, 0xC7, 0x20, 0x10,
  0xBF, 0xFF, 0xFA, 0x01, 0x70, 0x10, 0xDF, 0xFF, 0xFB, 0x05, 0x60, 0x10, 0xDF, 0xFF, 0xFC, 0x09,
  0x60, 0xBF, 0xFF, 0xFD, 0x0C, 0x50, 0x7F, 0xFF, 0xFF, 0x40, 0x28, 0x0C, 0x0F, 0x03, 0x30, 0xA8,
  0x0C, 0x0F, 0x05, 0x20, 0x3F, 0xF8, 0x5D, 0x74, 0x23, 0x5A, 0xFF, 0xA0, 0x62, 0x09, 0xFE, 0x08,
  0x70, 0x20, 0xCF, 0xF0, 0x82, 0x0E, 0xFD, 0x07, 0x73, 0x0D, 0xFE, 0x81, 0xA0, 0x4F, 0xD0, 0xC7,
  0x40, 0x3F, 0xE8, 0x1C, 0x08, 0xFD, 0x04, 0x75, 0x0B, 0xFD, 0x81, 0xD0, 0xCF, 0xC0, 0xD7, 0x60,
  0x5F, 0xD0, 0xD1, 0xFD, 0x09, 0x77, 0xFD, 0x0E, 0x02, 0xFD, 0x05, 0x77, 0x0C, 0xFC, 0x0E, 0x04,
  0xFD, 0x03, 0x77, 0x0A, 0xFD, 0x05, 0xFD, 0x01, 0x77, 0x08, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x7F,
  0xD0, 0x6F, 0xD7, 0x71, 0x06, 0xFC, 0x0E, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0x6F, 0xC0, 0xE0, 0x6F,
  0xD7, 0x71, 0x07, 0xFC, 0x0C, 0x06, 0xFD, 0x77, 0x10, 0x7F, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70,
  0x9F, 0xC0, 0x90, 0x3F, 0xD0, 0x37, 0x70, 0xBF, 0xC0, 0x71, 0xFD, 0x06, 0x77, 0x0D, 0xFC, 0x81,
  0x40, 0xEF, 0xC0, 0xA7, 0x60, 0x2F, 0xD8, 0x11, 0x0A, 0xFC, 0x0E, 0x76, 0x06, 0xFC, 0x0D, 0x20,
  0x6F, 0xD0, 0x57, 0x50, 0xCF, 0xC0, 0x82, 0x02, 0xFD, 0x0C, 0x74, 0x03, 0xFD, 0x03, 0x30, 0xBF,
  0xD0, 0x87, 0x30, 0xDF, 0xC0, 0xD4, 0x05, 0xFE, 0x08, 0x70, 0x20, 0xCF, 0xD0, 0x75, 0x0D, 0xFE,
  0x85, 0xD7, 0x42, 0x35, 0xAF, 0xE0, 0xE0, 0x15, 0x05, 0xFF, 0xFF, 0xD0, 0x77, 0x0B, 0xFF, 0xFF,
  0xB0, 0xD7, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x03, 0x72, 0x04, 0xFF, 0xFF, 0x90, 0x67, 0x40, 0x5F,
  0xFF, 0xE0, 0x87, 0x60, 0x5F, 0xFF, 0xC0, 0x77, 0x71, 0x02, 0x0D, 0xFF, 0xF0, 0xE0, 0x57, 0x74,
  0x07, 0x0E, 0xFF, 0xC0, 0xA0, 0x17, 0x76, 0x81, 0x17, 0xDF, 0xE8, 0x1E, 0x92, 0x77, 0x74, 0x89,
  0x32, 0x69, 0xCD, 0xEF, 0xEE, 0xCA, 0x73, 0x77,
  // "ñ" (U+00F1)
  0x73, 0x86, 0x5A, 0xDF, 0xEC, 0x94, 0x74, 0x06, 0xE7, 0x40, 0x10, 0xCF, 0x90, 0xD0, 0x57, 0x20,
  0xBE, 0x73, 0x01, 0x0D, 0xFC, 0x0D, 0x06, 0x60, 0x3E, 0x0D, 0x73, 0x0A, 0xFF, 0x85, 0xE8, 0x31,
  0x04, 0xEE, 0x0B, 0x72, 0x04, 0xFF, 0xFF, 0x08, 0x72, 0x0C, 0xFF, 0xFF, 0x05, 0x71, 0x02, 0xFF,
  0xFF, 0x0E, 0x72, 0x07, 0xFF, 0xFF, 0x09, 0x72, 0x0A, 0xFF, 0xFE, 0x0E, 0x01, 0x72, 0x0E, 0xE8,
  0x4D, 0x30, 0x15, 0xBF, 0xF9, 0x06, 0x72, 0x01, 0xE0, 0xE0, 0x15, 0x03, 0x0A, 0xFD, 0x08, 0x73,
  0x03, 0xE0, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x07, 0x74, 0x05, 0xE0, 0x27, 0x48, 0x65, 0xAD, 0xEE,
  0xC8, 0x28, 0x0A, 0xE3, 0x08, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56,
  0x04, 0x0C, 0xFC, 0x0D, 0x05, 0x70, 0x5F, 0xA0, 0x84, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x15, 0x05,
  0xFA, 0x0C, 0x30, 0x20, 0xDF, 0xFB, 0x0D, 0x02, 0x40, 0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0,
  0x13, 0x05, 0xFB, 0x81, 0x40, 0xAF, 0xFF, 0x0B, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62,
  0x05, 0xFF, 0xFF, 0xF0, 0xD2, 0x05, 0x80, 0xC0, 0xF8, 0x15, 0x05, 0x80, 0xC0, 0xF8, 0x1A, 0x05,
  0xFF, 0xA8, 0x5D, 0x74, 0x33, 0x6D, 0xFF, 0x10, 0x5F, 0xF9, 0x07, 0x70, 0xAF, 0xE0, 0x30, 0x5F,
  0xF0, 0x67, 0x10, 0x10, 0xDF, 0xD0, 0x60, 0x5F, 0xE0, 0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0,
  0x47, 0x30, 0x2F, 0xD0, 0xA0, 0x5F, 0xD0, 0xE7, 0x50, 0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50,
  0xAF, 0xC0, 0xC0, 0x5F, 0xD0, 0x77, 0x50, 0x9F, 0xC0, 0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0,
  0xC0, 0x5F, 0xD0, 0x27, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC0, 0x5F,
  0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  // "ò" (U+00F2)
  0x60, 0x38, 0x09, 0x17, 0x04, 0x77, 0x75, 0x04, 0xFE, 0x0E, 0x77, 0x76, 0x08, 0xFE, 0x07, 0x77,
  0x76, 0x09, 0xFD, 0x0E, 0x01, 0x77, 0x76, 0x0A, 0xFD, 0x0A, 0x77, 0x77, 0x0B, 0xFD, 0x04, 0x77,
  0x77, 0x0B, 0xFC, 0x0D, 0x77, 0x77, 0x10, 0xBF, 0xC0, 0x87, 0x77, 0x71, 0x0B, 0xFC, 0x02, 0x77,
  0x77, 0x10, 0xBF, 0xB0, 0xC7, 0x77, 0x72, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x20, 0xAF, 0xB0, 0x27,
  0x77, 0x72, 0x09, 0xFA, 0x0C, 0x77, 0x77, 0x30, 0x7F, 0xA0, 0x77, 0x77, 0x73, 0x05, 0xF9, 0x0B,
  0x80, 0xAF, 0x20, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x77, 0x74, 0x81, 0x16, 0xCF,
  0xE8, 0x1E, 0x82, 0x77, 0x70, 0x60, 0xEF, 0xFC, 0x09, 0x01, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x0D,
  0x04, 0x77, 0x10, 0x30, 0xEF, 0xFF, 0xB0, 0x67, 0x60, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x40, 0x20,
  0xEF, 0xFF, 0xF0, 0x67, 0x30, 0xCF, 0xFF, 0xFA, 0x03, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x01,
  0xFF, 0xFF, 0xD0, 0x76, 0x08, 0xFE, 0x85, 0xE8, 0x43, 0x36, 0xBF, 0xE0, 0xE0, 0x14, 0x01, 0x0E,
  0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x74, 0x06, 0xFD, 0x0B, 0x72, 0x03, 0xFD, 0x0E, 0x40, 0xBF,
  0xC0, 0xE0, 0x27, 0x30, 0x8F, 0xD0, 0x42, 0x01, 0xFD, 0x09, 0x74, 0x01, 0xFD, 0x09, 0x20, 0x5F,
  0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xD2, 0x08, 0xFC, 0x0D, 0x76, 0x06, 0xFD, 0x81, 0x10, 0xCF, 0xC0,
  0xA7, 0x60, 0x3F, 0xD8, 0x14, 0x0E, 0xFC, 0x07, 0x77, 0xFD, 0x07, 0x01, 0xFD, 0x04, 0x77, 0x0D,
  0xFC, 0x0A, 0x03, 0xFD, 0x03, 0x77, 0x0B, 0xFC, 0x0B, 0x05, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0D,
  0x05, 0xFD, 0x77, 0x10, 0x9F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0x08, 0xFC, 0x0E, 0x07, 0xFD, 0x77,
  0x10, 0x8F, 0xD0, 0x7F, 0xC0, 0xE7, 0x71, 0x07, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xD0, 0x6F,
  0xD7, 0x71, 0x08, 0xFC, 0x0E, 0x05, 0xFD, 0x77, 0x10, 0x9F, 0xC0, 0xD0, 0x4F, 0xD0, 0x17, 0x70,
  0xAF, 0xC0, 0xC0, 0x2F, 0xD0, 0x37, 0x70, 0xCF, 0xC0, 0xA1, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x81,
  0x80, 0xDF, 0xC0, 0x77, 0x7F, 0xD8, 0x16, 0x09, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x30, 0x6F,
  0xC0, 0xE7, 0x60, 0x7F, 0xC0, 0xE2, 0x02, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0B, 0x30, 0xDF, 0xC0,
  0x97, 0x40, 0x1F, 0xD0, 0x63, 0x08, 0xFC, 0x0E, 0x02, 0x73, 0x09, 0xFD, 0x01, 0x30, 0x2F, 0xD0,
  0xB7, 0x20, 0x4F, 0xD0, 0xB5, 0x0B, 0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x55, 0x03, 0xFE, 0x85,
  0xE8, 0x43, 0x35, 0xBF, 0xE0, 0xD7, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x02, 0x0E, 0xFF, 0xFF, 0xA0,
  0xB7, 0x20, 0x6F, 0xFF, 0xF9, 0x0E, 0x02, 0x73, 0x09, 0xFF, 0xFF, 0x04, 0x75, 0x0B, 0xFF, 0xFD,
  0x06, 0x77, 0x0A, 0xFF, 0xFB, 0x06, 0x77, 0x20, 0x8F, 0xFF, 0x0E, 0x04, 0x77, 0x40, 0x30, 0xCF,
  0xFC, 0x09, 0x01, 0x77, 0x70, 0x40, 0xBF, 0xE8, 0x1E, 0x82, 0x77, 0x74, 0x89, 0x31, 0x59, 0xCD,
  0xEF, 0xED, 0xCA, 0x73, 0x77,
  // "ó" (U+00F3)
  0x77, 0x70, 0x6F, 0xE0, 0xB7, 0x77, 0x50, 0xEF, 0xE0, 0x37, 0x77, 0x40, 0x8F, 0xE0, 0x57, 0x77,
  0x40, 0x2F, 0xE0, 0x67, 0x77, 0x50, 0xBF, 0xD0, 0x67, 0x77, 0x50, 0x5F, 0xD0, 0x67, 0x77, 0x50,
  0x10, 0xEF, 0xC0, 0x67, 0x77, 0x60, 0xAF, 0xC0, 0x57, 0x77, 0x60, 0x6F, 0xC0, 0x57, 0x77, 0x60,
  0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x70, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x70, 0x7F, 0xA0, 0xD0,
  0x27, 0x77, 0x70, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x71, 0x06, 0xF9, 0x0A, 0x80, 0xB8, 0x00, 0x84,
  0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x77, 0x74, 0x81, 0x16, 0xCF, 0xE8, 0x1E, 0x82, 0x77,
  0x70, 0x60, 0xEF, 0xFC, 0x09, 0x01, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x0D, 0x04, 0x77, 0x10, 0x30,
  0xEF, 0xFF, 0xB0, 0x67, 0x60, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x40, 0x20, 0xEF, 0xFF, 0xF0, 0x67,
  0x30, 0xCF, 0xFF, 0xFA, 0x03, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x01, 0xFF, 0xFF, 0xD0, 0x76,
  0x08, 0xFE, 0x85, 0xE8, 0x43, 0x36, 0xBF, 0xE0, 0xE0, 0x14, 0x01, 0x0E, 0xFD, 0x0B, 0x70, 0x40,
  0xEF, 0xD0, 0x74, 0x06, 0xFD, 0x0B, 0x72, 0x03, 0xFD, 0x0E, 0x40, 0xBF, 0xC0, 0xE0, 0x27, 0x30,
  0x8F, 0xD0, 0x42, 0x01, 0xFD, 0x09, 0x74, 0x01, 0xFD, 0x09, 0x20, 0x5F, 0xD0, 0x37, 0x50, 0xBF,
  0xC0, 0xD2, 0x08, 0xFC, 0x0D, 0x76, 0x06, 0xFD, 0x81, 0x10, 0xCF, 0xC0, 0xA7, 0x60, 0x3F, 0xD8,
  0x14, 0x0E, 0xFC, 0x07, 0x77, 0xFD, 0x07, 0x01, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x0A, 0x03, 0xFD,
  0x03, 0x77, 0x0B, 0xFC, 0x0B, 0x05, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0D, 0x05, 0xFD, 0x77, 0x10,
  0x9F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0x08, 0xFC, 0x0E, 0x07, 0xFD, 0x77, 0x10, 0x8F, 0xD0, 0x7F,
  0xC0, 0xE7, 0x71, 0x07, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFC,
  0x0E, 0x05, 0xFD, 0x77, 0x10, 0x9F, 0xC0, 0xD0, 0x4F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xC0, 0x2F,
  0xD0, 0x37, 0x70, 0xCF, 0xC0, 0xA1, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x81, 0x80, 0xDF, 0xC0, 0x77,
  0x7F, 0xD8, 0x16, 0x09, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x30, 0x6F, 0xC0, 0xE7, 0x60, 0x7F,
  0xC0, 0xE2, 0x02, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0B, 0x30, 0xDF, 0xC0, 0x97, 0x40, 0x1F, 0xD0,
  0x63, 0x08, 0xFC, 0x0E, 0x02, 0x73, 0x09, 0xFD, 0x01, 0x30, 0x2F, 0xD0, 0xB7, 0x20, 0x4F, 0xD0,
  0xB5, 0x0B, 0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x55, 0x03, 0xFE, 0x85, 0xE8, 0x43, 0x35, 0xBF,
  0xE0, 0xD7, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x02, 0x0E, 0xFF, 0xFF, 0xA0, 0xB7, 0x20, 0x6F, 0xFF,
  0xF9, 0x0E, 0x02, 0x73, 0x09, 0xFF, 0xFF, 0x04, 0x75, 0x0B, 0xFF, 0xFD, 0x06, 0x77, 0x0A, 0xFF,
  0xFB, 0x06, 0x77, 0x20, 0x8F, 0xFF, 0x0E, 0x04, 0x77, 0x40, 0x30, 0xCF, 0xFC, 0x09, 0x01, 0x77,
  0x70, 0x40, 0xBF, 0xE8, 0x1E, 0x82, 0x77, 0x74, 0x89, 0x31, 0x59, 0xCD, 0xEF, 0xED, 0xCA, 0x73,
  0x77,
  // "ô" (U+00F4)
  0x77, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x60, 0x9F, 0xD0, 0xB7, 0x77, 0x50, 0x3F, 0xF0, 0x47,
  0x77, 0x40, 0xCF, 0xF0, 0xD7, 0x77, 0x30, 0x7F, 0xFA, 0x08, 0x77, 0x71, 0x03, 0xFF, 0xC0, 0x37,
  0x77, 0x0D, 0xFF, 0xC0, 0xD7, 0x76, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x74, 0x04, 0xFA, 0x81,
  0xE3, 0x3F, 0xB0, 0x57, 0x72, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x71, 0x0B,
  0xFA, 0x04, 0x40, 0x5F, 0xA0, 0xC7, 0x70, 0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x75, 0x04, 0xF9,
  0x0E, 0x04, 0x71, 0x03, 0x0E, 0xF9, 0x06, 0x73, 0x02, 0x0E, 0xF0, 0xE0, 0x37, 0x30, 0x20, 0xDF,
  0x90, 0x37, 0x20, 0x6F, 0x0C, 0x01, 0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xE2, 0x08, 0x42, 0x69,
  0xCD, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x6C, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x06,
  0x0E, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x01, 0x0C, 0xFF, 0xF0, 0xD0, 0x47, 0x71, 0x03, 0x0E, 0xFF,
  0xFB, 0x06, 0x76, 0x03, 0x0E, 0xFF, 0xFD, 0x07, 0x74, 0x02, 0x0E, 0xFF, 0xFF, 0x06, 0x73, 0x0C,
  0xFF, 0xFF, 0xA0, 0x37, 0x10, 0x7F, 0xFF, 0xFB, 0x0D, 0x70, 0x1F, 0xFF, 0xFD, 0x07, 0x60, 0x8F,
  0xE8, 0x5E, 0x84, 0x33, 0x6B, 0xFE, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD,
  0x07, 0x40, 0x6F, 0xD0, 0xB7, 0x20, 0x3F, 0xD0, 0xE4, 0x0B, 0xFC, 0x0E, 0x02, 0x73, 0x08, 0xFD,
  0x04, 0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xD0, 0x92, 0x05, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0D,
  0x20, 0x8F, 0xC0, 0xD7, 0x60, 0x6F, 0xD8, 0x11, 0x0C, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x40,
  0xEF, 0xC0, 0x77, 0x7F, 0xD0, 0x70, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0xA0, 0x3F, 0xD0, 0x37,
  0x70, 0xBF, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xD0, 0x5F, 0xD7, 0x71, 0x09, 0xFC,
  0x0E, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0x08, 0xFD, 0x07, 0xFC, 0x0E,
  0x77, 0x10, 0x7F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0,
  0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0D, 0x04, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0C, 0x02, 0xFD, 0x03,
  0x77, 0x0C, 0xFC, 0x0A, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC8, 0x18, 0x0D, 0xFC, 0x07, 0x77, 0xFD,
  0x81, 0x60, 0x9F, 0xC0, 0xA7, 0x60, 0x3F, 0xD8, 0x13, 0x06, 0xFC, 0x0E, 0x76, 0x07, 0xFC, 0x0E,
  0x20, 0x2F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xB3, 0x0D, 0xFC, 0x09, 0x74, 0x01, 0xFD, 0x06, 0x30,
  0x8F, 0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x13, 0x02, 0xFD, 0x0B, 0x72, 0x04, 0xFD, 0x0B, 0x50,
  0xBF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x05, 0x50, 0x3F, 0xE8, 0x5E, 0x84, 0x33, 0x5B, 0xFE, 0x0D,
  0x70, 0xBF, 0xFF, 0xFC, 0x05, 0x70, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x72, 0x06, 0xFF, 0xFF, 0x90,
  0xE0, 0x27, 0x30, 0x9F, 0xFF, 0xF0, 0x47, 0x50, 0xBF, 0xFF, 0xD0, 0x67, 0x70, 0xAF, 0xFF, 0xB0,
  0x67, 0x72, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x74, 0x03, 0x0C, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x04,
  0x0B, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x48, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x70,
  // "õ" (U+00F5)
  0x73, 0x86, 0x5A, 0xDF, 0xEC, 0x94, 0x74, 0x06, 0xE7, 0x60, 0x10, 0xCF, 0x90, 0xD0, 0x57, 0x20,
  0xBE, 0x75, 0x01, 0x0D, 0xFC, 0x0D, 0x06, 0x60, 0x3E, 0x0D, 0x75, 0x0A, 0xFF, 0x85, 0xE8, 0x31,
  0x04, 0xEE, 0x0B, 0x74, 0x04, 0xFF, 0xFF, 0x08, 0x74, 0x0C, 0xFF, 0xFF, 0x05, 0x73, 0x02, 0xFF,
  0xFF, 0x0E, 0x74, 0x07, 0xFF, 0xFF, 0x09, 0x74, 0x0A, 0xFF, 0xFE, 0x0E, 0x01, 0x74, 0x0E, 0xE8,
  0x4D, 0x30, 0x15, 0xBF, 0xF9, 0x06, 0x74, 0x01, 0xE0, 0xE0, 0x15, 0x03, 0x0A, 0xFD, 0x08, 0x75,
  0x03, 0xE0, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x07, 0x76, 0x05, 0xE0, 0x27, 0x48, 0x65, 0xAD, 0xEE,
  0xC8, 0x28, 0x0A, 0xF0, 0x08, 0x42, 0x69, 0xCD, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11,
  0x6C, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x06, 0x0E, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x01, 0x0C, 0xFF,
  0xF0, 0xD0, 0x47, 0x71, 0x03, 0x0E, 0xFF, 0xFB, 0x06, 0x76, 0x03, 0x0E, 0xFF, 0xFD, 0x07, 0x74,
  0x02, 0x0E, 0xFF, 0xFF, 0x06, 0x73, 0x0C, 0xFF, 0xFF, 0xA0, 0x37, 0x10, 0x7F, 0xFF, 0xFB, 0x0D,
  0x70, 0x1F, 0xFF, 0xFD, 0x07, 0x60, 0x8F, 0xE8, 0x5E, 0x84, 0x33, 0x6B, 0xFE, 0x0E, 0x01, 0x40,
  0x10, 0xEF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x07, 0x40, 0x6F, 0xD0, 0xB7, 0x20, 0x3F, 0xD0, 0xE4,
  0x0B, 0xFC, 0x0E, 0x02, 0x73, 0x08, 0xFD, 0x04, 0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xD0, 0x92,
  0x05, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0D, 0x20, 0x8F, 0xC0, 0xD7, 0x60, 0x6F, 0xD8, 0x11, 0x0C,
  0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x40, 0xEF, 0xC0, 0x77, 0x7F, 0xD0, 0x70, 0x1F, 0xD0, 0x47,
  0x70, 0xDF, 0xC0, 0xA0, 0x3F, 0xD0, 0x37, 0x70, 0xBF, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70, 0xAF,
  0xC0, 0xD0, 0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x7F,
  0xD7, 0x71, 0x08, 0xFD, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0x7F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFD,
  0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0D, 0x04, 0xFD, 0x01,
  0x77, 0x0A, 0xFC, 0x0C, 0x02, 0xFD, 0x03, 0x77, 0x0C, 0xFC, 0x0A, 0x1F, 0xD0, 0x47, 0x70, 0xDF,
  0xC8, 0x18, 0x0D, 0xFC, 0x07, 0x77, 0xFD, 0x81, 0x60, 0x9F, 0xC0, 0xA7, 0x60, 0x3F, 0xD8, 0x13,
  0x06, 0xFC, 0x0E, 0x76, 0x07, 0xFC, 0x0E, 0x20, 0x2F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xB3, 0x0D,
  0xFC, 0x09, 0x74, 0x01, 0xFD, 0x06, 0x30, 0x8F, 0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x13, 0x02,
  0xFD, 0x0B, 0x72, 0x04, 0xFD, 0x0B, 0x50, 0xBF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x05, 0x50, 0x3F,
  0xE8, 0x5E, 0x84, 0x33, 0x5B, 0xFE, 0x0D, 0x70, 0xBF, 0xFF, 0xFC, 0x05, 0x70, 0x20, 0xEF, 0xFF,
  0xFA, 0x0B, 0x72, 0x06, 0xFF, 0xFF, 0x90, 0xE0, 0x27, 0x30, 0x9F, 0xFF, 0xF0, 0x47, 0x50, 0xBF,
  0xFF, 0xD0, 0x67, 0x70, 0xAF, 0xFF, 0xB0, 0x67, 0x72, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x74, 0x03,
  0x0C, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x04, 0x0B, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x48, 0x93, 0x15,
  0x9C, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x70,
  // "ö" (U+00F6)
  0x72, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x20, 0x20, 0xDE, 0x0D,
  0x02, 0x70, 0x40, 0xEE, 0x0C, 0x77, 0x10, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x76, 0x03,
  0xFB, 0x04, 0x50, 0x7F, 0xB0, 0x17, 0x50, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x75, 0x09, 0xFB,
  0x0A, 0x50, 0xDF, 0xB0, 0x77, 0x50, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x75, 0x07, 0xFB, 0x08,
  0x50, 0xCF, 0xB0, 0x67, 0x50, 0x4F, 0xB0, 0x45, 0x08, 0xFB, 0x02, 0x76, 0x0C, 0xF9, 0x0C, 0x60,
  0x10, 0xEF, 0x90, 0xA7, 0x70, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x77, 0x28,
  0x57, 0xCE, 0xEC, 0x71, 0x72, 0x85, 0x18, 0xDF, 0xEC, 0x68, 0x0B, 0xC0, 0x08, 0x42, 0x69, 0xCD,
  0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x6C, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x06, 0x0E,
  0xFF, 0xC0, 0x90, 0x17, 0x73, 0x01, 0x0C, 0xFF, 0xF0, 0xD0, 0x47, 0x71, 0x03, 0x0E, 0xFF, 0xFB,
  0x06, 0x76, 0x03, 0x0E, 0xFF, 0xFD, 0x07, 0x74, 0x02, 0x0E, 0xFF, 0xFF, 0x06, 0x73, 0x0C, 0xFF,
  0xFF, 0xA0, 0x37, 0x10, 0x7F, 0xFF, 0xFB, 0x0D, 0x70, 0x1F, 0xFF, 0xFD, 0x07, 0x60, 0x8F, 0xE8,
  0x5E, 0x84, 0x33, 0x6B, 0xFE, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x07,
  0x40, 0x6F, 0xD0, 0xB7, 0x20, 0x3F, 0xD0, 0xE4, 0x0B, 0xFC, 0x0E, 0x02, 0x73, 0x08, 0xFD, 0x04,
  0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xD0, 0x92, 0x05, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0D, 0x20,
  0x8F, 0xC0, 0xD7, 0x60, 0x6F, 0xD8, 0x11, 0x0C, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x40, 0xEF,
  0xC0, 0x77, 0x7F, 0xD0, 0x70, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0xA0, 0x3F, 0xD0, 0x37, 0x70,
  0xBF, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xD0, 0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0E,
  0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0x08, 0xFD, 0x07, 0xFC, 0x0E, 0x77,
  0x10, 0x7F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x5F,
  0xD7, 0x71, 0x09, 0xFC, 0x0D, 0x04, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0C, 0x02, 0xFD, 0x03, 0x77,
  0x0C, 0xFC, 0x0A, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC8, 0x18, 0x0D, 0xFC, 0x07, 0x77, 0xFD, 0x81,
  0x60, 0x9F, 0xC0, 0xA7, 0x60, 0x3F, 0xD8, 0x13, 0x06, 0xFC, 0x0E, 0x76, 0x07, 0xFC, 0x0E, 0x20,
  0x2F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xB3, 0x0D, 0xFC, 0x09, 0x74, 0x01, 0xFD, 0x06, 0x30, 0x8F,
  0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x13, 0x02, 0xFD, 0x0B, 0x72, 0x04, 0xFD, 0x0B, 0x50, 0xBF,
  0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x05, 0x50, 0x3F, 0xE8, 0x5E, 0x84, 0x33, 0x5B, 0xFE, 0x0D, 0x70,
  0xBF, 0xFF, 0xFC, 0x05, 0x70, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x72, 0x06, 0xFF, 0xFF, 0x90, 0xE0,
  0x27, 0x30, 0x9F, 0xFF, 0xF0, 0x47, 0x50, 0xBF, 0xFF, 0xD0, 0x67, 0x70, 0xAF, 0xFF, 0xB0, 0x67,
  0x72, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x74, 0x03, 0x0C, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x04, 0x0B,
  0xFE, 0x81, 0xE8, 0x27, 0x77, 0x48, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x70,
  // "÷" (U+00F7)
  0x77, 0x28, 0x54, 0xAD, 0xFE, 0xB5, 0x77, 0x77, 0x30, 0x9F, 0x0A, 0x77, 0x77, 0x10, 0x6F, 0xA0,
  0x87, 0x77, 0x70, 0xEF, 0xB0, 0x17, 0x77, 0x50, 0x3F, 0xC0, 0x57, 0x77, 0x50, 0x6F, 0xC0, 0x87,
  0x77, 0x50, 0x7F, 0xC0, 0x97, 0x77, 0x50, 0x7F, 0xC0, 0x97, 0x77, 0x50, 0x6F, 0xC0, 0x87, 0x77,
  0x50, 0x3F, 0xC0, 0x57, 0x77, 0x60, 0xEF, 0xA0, 0xE0, 0x17, 0x77, 0x60, 0x6F, 0xA0, 0x87, 0x77,
  0x71, 0x09, 0xF0, 0xA7, 0x77, 0x73, 0x85, 0x4A, 0xEF, 0xEB, 0x58, 0x0B, 0x97, 0x00, 0xB8, 0x0C,
  0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0,
  0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1,
  0xF0, 0xE0, 0xB8, 0x0C, 0x1F, 0x0E, 0x0B, 0x80, 0xC1, 0xF0, 0xE8, 0x0A, 0xD0, 0x08, 0x54, 0xAD,
  0xFE, 0xB5, 0x77, 0x77, 0x30, 0x9F, 0x0A, 0x77, 0x77, 0x10, 0x6F, 0xA0, 0x87, 0x77, 0x70, 0xEF,
  0xB0, 0x17, 0x77, 0x50, 0x3F, 0xC0, 0x57, 0x77, 0x50, 0x6F, 0xC0, 0x87, 0x77, 0x50, 0x7F, 0xC0,
  0x97, 0x77, 0x50, 0x7F, 0xC0, 0x97, 0x77, 0x50, 0x6F, 0xC0, 0x77, 0x77, 0x50, 0x3F, 0xC0, 0x57,
  0x77, 0x60, 0xEF, 0xA0, 0xE7, 0x77, 0x70, 0x6F, 0xA0, 0x77, 0x77, 0x71, 0x08, 0xF0, 0x97, 0x77,
  0x73, 0x85, 0x4A, 0xEF, 0xEB, 0x47, 0x72,
  // "ø" (U+00F8)
  0x77, 0x77, 0x40, 0x58, 0x0C, 0x30, 0x82, 0x3F, 0xE6, 0x80, 0xC1, 0x00, 0xBB, 0x0D, 0x04, 0x77,
  0x48, 0x92, 0x26, 0x9B, 0xDE, 0xFE, 0xDC, 0x95, 0x40, 0x4E, 0x0B, 0x02, 0x77, 0x06, 0x0C, 0xFE,
  0x82, 0xA3, 0x0D, 0xF0, 0x27, 0x50, 0x60, 0xEF, 0xFB, 0x0C, 0xF0, 0x97, 0x40, 0x10, 0xBF, 0xFF,
  0xE0, 0x27, 0x30, 0x30, 0xEF, 0xFF, 0xE0, 0x97, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0x27, 0x20, 0x20,
  0xEF, 0xFF, 0xF0, 0x97, 0x30, 0xCF, 0xFF, 0xF9, 0x0C, 0x72, 0x07, 0xFF, 0xFF, 0xB0, 0x87, 0x01,
  0x0E, 0xFF, 0xFF, 0xC0, 0x26, 0x09, 0xFE, 0x85, 0xD7, 0x43, 0x36, 0xCF, 0xE0, 0xB5, 0x01, 0xFE,
  0x07, 0x70, 0x6F, 0xE0, 0x24, 0x07, 0xFD, 0x06, 0x71, 0x04, 0xFE, 0x09, 0x40, 0xCF, 0xC0, 0xB7,
  0x20, 0xCF, 0xE0, 0xE3, 0x02, 0xFD, 0x03, 0x71, 0x06, 0xFF, 0x90, 0x52, 0x06, 0xFC, 0x0C, 0x72,
  0x0E, 0xFF, 0x90, 0xA2, 0x09, 0xFC, 0x07, 0x71, 0x08, 0xFF, 0xA0, 0xE2, 0x0C, 0xFC, 0x03, 0x70,
  0x2F, 0xFC, 0x02, 0x1F, 0xD7, 0x10, 0xAF, 0xFC, 0x05, 0x02, 0xFC, 0x0D, 0x70, 0x3F, 0x09, 0xFC,
  0x08, 0x03, 0xFC, 0x0B, 0x70, 0xCE, 0x09, 0x05, 0xFC, 0x0A, 0x05, 0xFC, 0x0A, 0x60, 0x5E, 0x81,
  0xE1, 0x3F, 0xC0, 0xC0, 0x6F, 0xC0, 0x96, 0x0D, 0xE8, 0x17, 0x02, 0xFC, 0x0D, 0x06, 0xFC, 0x08,
  0x50, 0x7E, 0x0D, 0x20, 0x1F, 0xC0, 0xE0, 0x7F, 0xC0, 0x84, 0x01, 0x0E, 0xE0, 0x52, 0x01, 0xFD,
  0x07, 0xFC, 0x07, 0x40, 0x9E, 0x0B, 0x4F, 0xD0, 0x6F, 0xC0, 0x73, 0x03, 0xF0, 0x33, 0x01, 0xFD,
  0x06, 0xFC, 0x08, 0x30, 0xBE, 0x09, 0x40, 0x1F, 0xC0, 0xE0, 0x5F, 0xC0, 0x92, 0x05, 0xE0, 0xE0,
  0x14, 0x02, 0xFC, 0x0E, 0x04, 0xFC, 0x0A, 0x20, 0xDE, 0x07, 0x50, 0x3F, 0xC0, 0xC0, 0x2F, 0xC8,
  0x1C, 0x07, 0xE0, 0xD6, 0x05, 0xFC, 0x0B, 0x1F, 0xC8, 0x1E, 0x1E, 0xE0, 0x56, 0x07, 0xFC, 0x81,
  0x90, 0xDF, 0xC0, 0xBE, 0x0C, 0x70, 0x9F, 0xC8, 0x17, 0x0A, 0xFF, 0xC0, 0x37, 0x0D, 0xFC, 0x81,
  0x40, 0x7F, 0xFB, 0x0A, 0x70, 0x1F, 0xD8, 0x11, 0x03, 0xFF, 0xA0, 0xE0, 0x17, 0x06, 0xFC, 0x0D,
  0x30, 0xDF, 0xF9, 0x07, 0x71, 0x0C, 0xFC, 0x09, 0x30, 0x8F, 0xF0, 0xD7, 0x10, 0x5F, 0xD0, 0x33,
  0x02, 0xFF, 0x05, 0x70, 0x10, 0xEF, 0xC0, 0xD5, 0x0B, 0xFD, 0x0E, 0x01, 0x60, 0x30, 0xDF, 0xD0,
  0x75, 0x03, 0xFE, 0x85, 0xE7, 0x42, 0x35, 0xBF, 0xE0, 0xE0, 0x16, 0x0A, 0xFF, 0xFF, 0xC0, 0x77,
  0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xD7, 0x20, 0x4F, 0xFF, 0xFA, 0x03, 0x73, 0x0C, 0xFF, 0xFF, 0x07,
  0x73, 0x02, 0xFF, 0xFF, 0x08, 0x74, 0x0A, 0xFF, 0xFE, 0x08, 0x74, 0x02, 0xFF, 0xFD, 0x0E, 0x05,
  0x75, 0x0A, 0xFF, 0xFC, 0x0A, 0x01, 0x75, 0x02, 0xF8, 0x1B, 0x29, 0xFE, 0x81, 0xE9, 0x27, 0x70,
  0xAF, 0x03, 0x38, 0x92, 0x58, 0xBD, 0xEF, 0xEE, 0xCA, 0x73, 0x77, 0x20, 0x10, 0xEE, 0x0A, 0x77,
  0x77, 0x50, 0x10, 0x9D, 0x02, 0x77, 0x77, 0x70, 0x20, 0xAA, 0x09, 0x80, 0xC2, 0x08, 0x13, 0xB2,
  0x77, 0x77, 0x30,
  // "ù" (U+00F9)
  0x50, 0x38, 0x09, 0x17, 0x04, 0x77, 0x73, 0x04, 0xFE, 0x0E, 0x77, 0x74, 0x08, 0xFE, 0x07, 0x77,
  0x74, 0x09, 0xFD, 0x0E, 0x01, 0x77, 0x74, 0x0A, 0xFD, 0x0A, 0x77, 0x75, 0x0B, 0xFD, 0x04, 0x77,
  0x75, 0x0B, 0xFC, 0x0D, 0x77, 0x76, 0x0B, 0xFC, 0x08, 0x77, 0x76, 0x0B, 0xFC, 0x02, 0x77, 0x76,
  0x0B, 0xFB, 0x0C, 0x77, 0x77, 0x0A, 0xFB, 0x07, 0x77, 0x77, 0x0A, 0xFB, 0x02, 0x77, 0x77, 0x09,
  0xFA, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xA0, 0x77, 0x77, 0x71, 0x05, 0xF9, 0x0B, 0x80, 0xB9, 0x20,
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B,
  0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07,
  0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A,
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x08, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x08, 0xFC, 0x0A, 0x08, 0xFC, 0x0B,
  0x76, 0x09, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x09, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x0B,
  0xFC, 0x0A, 0x08, 0xFC, 0x0C, 0x76, 0x0D, 0xFC, 0x0A, 0x08, 0xFC, 0x0C, 0x76, 0xFD, 0x0A, 0x07,
  0xFC, 0x0E, 0x75, 0x02, 0xFD, 0x0A, 0x07, 0xFD, 0x75, 0x05, 0xFD, 0x0A, 0x06, 0xFD, 0x03, 0x74,
  0x0A, 0xFD, 0x0A, 0x05, 0xFD, 0x07, 0x74, 0x0E, 0xFD, 0x0A, 0x03, 0xFD, 0x0C, 0x73, 0x07, 0xFE,
  0x0A, 0x01, 0xFE, 0x04, 0x71, 0x02, 0x0E, 0xFE, 0x81, 0xA0, 0xDF, 0xD0, 0xD0, 0x26, 0x03, 0x0E,
  0xFF, 0x81, 0xA0, 0xAF, 0xE8, 0x5E, 0x84, 0x24, 0x6B, 0xFF, 0xA8, 0x1A, 0x05, 0x80, 0xC0, 0xF0,
  0xA2, 0x0E, 0xFF, 0xFF, 0xF0, 0xA2, 0x09, 0xFF, 0xFF, 0xF0, 0xA2, 0x01, 0x0E, 0xFF, 0xF9, 0x0C,
  0x04, 0xFB, 0x0A, 0x30, 0x7F, 0xFF, 0x98, 0x12, 0x0E, 0xFA, 0x0A, 0x40, 0xAF, 0xFE, 0x05, 0x20,
  0xBF, 0xA0, 0xA5, 0x0B, 0xFF, 0xC0, 0x63, 0x06, 0xFA, 0x0A, 0x60, 0x8F, 0xF9, 0x0D, 0x04, 0x40,
  0x2F, 0xA0, 0xA7, 0x03, 0x0B, 0xFC, 0x0E, 0x08, 0x70, 0xEF, 0x90, 0xA7, 0x28, 0x32, 0x6A, 0xDE,
  0xA8, 0x2E, 0xC9, 0x47, 0x75,
  // "ú" (U+00FA)
  0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x77, 0x30, 0xEF, 0xE0, 0x37, 0x77, 0x20, 0x8F, 0xE0, 0x57, 0x77,
  0x20, 0x2F, 0xE0, 0x67, 0x77, 0x30, 0xBF, 0xD0, 0x67, 0x77, 0x30, 0x5F, 0xD0, 0x67, 0x77, 0x30,
  0x10, 0xEF, 0xC0, 0x67, 0x77, 0x40, 0xAF, 0xC0, 0x57, 0x77, 0x40, 0x6F, 0xC0, 0x57, 0x77, 0x40,
  0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x50, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x50, 0x7F, 0xA0, 0xD0,
  0x27, 0x77, 0x50, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x60, 0x6F, 0x90, 0xA8, 0x0B, 0xA0, 0x00, 0x8F,
  0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7,
  0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F,
  0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0,
  0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0,
  0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60,
  0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0,
  0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F,
  0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7,
  0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F,
  0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0,
  0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0,
  0xB7, 0x60, 0x8F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x8F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60,
  0x9F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x9F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0xBF, 0xC0,
  0xA0, 0x8F, 0xC0, 0xC7, 0x60, 0xDF, 0xC0, 0xA0, 0x8F, 0xC0, 0xC7, 0x6F, 0xD0, 0xA0, 0x7F, 0xC0,
  0xE7, 0x50, 0x2F, 0xD0, 0xA0, 0x7F, 0xD7, 0x50, 0x5F, 0xD0, 0xA0, 0x6F, 0xD0, 0x37, 0x40, 0xAF,
  0xD0, 0xA0, 0x5F, 0xD0, 0x77, 0x40, 0xEF, 0xD0, 0xA0, 0x3F, 0xD0, 0xC7, 0x30, 0x7F, 0xE0, 0xA0,
  0x1F, 0xE0, 0x47, 0x10, 0x20, 0xEF, 0xE8, 0x1A, 0x0D, 0xFD, 0x0D, 0x02, 0x60, 0x30, 0xEF, 0xF8,
  0x1A, 0x0A, 0xFE, 0x85, 0xE8, 0x42, 0x46, 0xBF, 0xFA, 0x81, 0xA0, 0x58, 0x0C, 0x0F, 0x0A, 0x20,
  0xEF, 0xFF, 0xFF, 0x0A, 0x20, 0x9F, 0xFF, 0xFF, 0x0A, 0x20, 0x10, 0xEF, 0xFF, 0x90, 0xC0, 0x4F,
  0xB0, 0xA3, 0x07, 0xFF, 0xF9, 0x81, 0x20, 0xEF, 0xA0, 0xA4, 0x0A, 0xFF, 0xE0, 0x52, 0x0B, 0xFA,
  0x0A, 0x50, 0xBF, 0xFC, 0x06, 0x30, 0x6F, 0xA0, 0xA6, 0x08, 0xFF, 0x90, 0xD0, 0x44, 0x02, 0xFA,
  0x0A, 0x70, 0x30, 0xBF, 0xC0, 0xE0, 0x87, 0x0E, 0xF9, 0x0A, 0x72, 0x83, 0x26, 0xAD, 0xEA, 0x82,
  0xEC, 0x94, 0x77, 0x50,
  // "û" (U+00FB)
  0x76, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x40, 0x9F, 0xD0, 0xB7, 0x77, 0x30, 0x3F, 0xF0, 0x47,
  0x77, 0x20, 0xCF, 0xF0, 0xD7, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x77, 0x60, 0x3F, 0xFC, 0x03, 0x77,
  0x50, 0xDF, 0xFC, 0x0D, 0x77, 0x40, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x20, 0x4F, 0xA8, 0x1E,
  0x33, 0xFB, 0x05, 0x77, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x60, 0xBF, 0xA0,
  0x44, 0x05, 0xFA, 0x0C, 0x75, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x97, 0x30, 0x4F, 0x90, 0xE0,
  0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x10, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03,
  0x70, 0x6F, 0x0C, 0x01, 0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0B, 0x82, 0x00, 0x8F, 0xC0, 0xB7, 0x60,
  0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0,
  0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F,
  0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7,
  0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F,
  0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0,
  0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0,
  0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60,
  0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0,
  0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F,
  0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7,
  0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x7F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x8F,
  0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x8F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0x9F, 0xC0, 0xA0,
  0x8F, 0xC0, 0xB7, 0x60, 0x9F, 0xC0, 0xA0, 0x8F, 0xC0, 0xB7, 0x60, 0xBF, 0xC0, 0xA0, 0x8F, 0xC0,
  0xC7, 0x60, 0xDF, 0xC0, 0xA0, 0x8F, 0xC0, 0xC7, 0x6F, 0xD0, 0xA0, 0x7F, 0xC0, 0xE7, 0x50, 0x2F,
  0xD0, 0xA0, 0x7F, 0xD7, 0x50, 0x5F, 0xD0, 0xA0, 0x6F, 0xD0, 0x37, 0x40, 0xAF, 0xD0, 0xA0, 0x5F,
  0xD0, 0x77, 0x40, 0xEF, 0xD0, 0xA0, 0x3F, 0xD0, 0xC7, 0x30, 0x7F, 0xE0, 0xA0, 0x1F, 0xE0, 0x47,
  0x10, 0x20, 0xEF, 0xE8, 0x1A, 0x0D, 0xFD, 0x0D, 0x02, 0x60, 0x30, 0xEF, 0xF8, 0x1A, 0x0A, 0xFE,
  0x85, 0xE8, 0x42, 0x46, 0xBF, 0xFA, 0x81, 0xA0, 0x58, 0x0C, 0x0F, 0x0A, 0x20, 0xEF, 0xFF, 0xFF,
  0x0A, 0x20, 0x9F, 0xFF, 0xFF, 0x0A, 0x20, 0x10, 0xEF, 0xFF, 0x90, 0xC0, 0x4F, 0xB0, 0xA3, 0x07,
  0xFF, 0xF9, 0x81, 0x20, 0xEF, 0xA0, 0xA4, 0x0A, 0xFF, 0xE0, 0x52, 0x0B, 0xFA, 0x0A, 0x50, 0xBF,
  0xFC, 0x06, 0x30, 0x6F, 0xA0, 0xA6, 0x08, 0xFF, 0x90, 0xD0, 0x44, 0x02, 0xFA, 0x0A, 0x70, 0x30,
  0xBF, 0xC0, 0xE0, 0x87, 0x0E, 0xF9, 0x0A, 0x72, 0x83, 0x26, 0xAD, 0xEA, 0x82, 0xEC, 0x94, 0x77,
  0x50,
  // "ü" (U+00FC)
  0x71, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x02, 0x0D, 0xE0, 0xD0,
  0x27, 0x04, 0x0E, 0xE0, 0xC7, 0x60, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x74, 0x03, 0xFB,
  0x04, 0x50, 0x7F, 0xB0, 0x17, 0x30, 0x7F, 0xB0, 0x85, 0x0B, 0xFB, 0x05, 0x73, 0x09, 0xFB, 0x0A,
  0x50, 0xDF, 0xB0, 0x77, 0x30, 0x9F, 0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x73, 0x07, 0xFB, 0x08, 0x50,
  0xCF, 0xB0, 0x67, 0x30, 0x4F, 0xB0, 0x45, 0x08, 0xFB, 0x02, 0x74, 0x0C, 0xF9, 0x0C, 0x60, 0x10,
  0xEF, 0x90, 0xA7, 0x50, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x40, 0xEE, 0x0C, 0x01, 0x77, 0x85, 0x7C,
  0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80, 0xBD, 0x60, 0x08, 0xFC, 0x0B, 0x76, 0x07,
  0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A,
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B,
  0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07,
  0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A,
  0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC,
  0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76,
  0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x07, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x08, 0xFC,
  0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x08, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x09, 0xFC, 0x0A, 0x08,
  0xFC, 0x0B, 0x76, 0x09, 0xFC, 0x0A, 0x08, 0xFC, 0x0B, 0x76, 0x0B, 0xFC, 0x0A, 0x08, 0xFC, 0x0C,
  0x76, 0x0D, 0xFC, 0x0A, 0x08, 0xFC, 0x0C, 0x76, 0xFD, 0x0A, 0x07, 0xFC, 0x0E, 0x75, 0x02, 0xFD,
  0x0A, 0x07, 0xFD, 0x75, 0x05, 0xFD, 0x0A, 0x06, 0xFD, 0x03, 0x74, 0x0A, 0xFD, 0x0A, 0x05, 0xFD,
  0x07, 0x74, 0x0E, 0xFD, 0x0A, 0x03, 0xFD, 0x0C, 0x73, 0x07, 0xFE, 0x0A, 0x01, 0xFE, 0x04, 0x71,
  0x02, 0x0E, 0xFE, 0x81, 0xA0, 0xDF, 0xD0, 0xD0, 0x26, 0x03, 0x0E, 0xFF, 0x81, 0xA0, 0xAF, 0xE8,
  0x5E, 0x84, 0x24, 0x6B, 0xFF, 0xA8, 0x1A, 0x05, 0x80, 0xC0, 0xF0, 0xA2, 0x0E, 0xFF, 0xFF, 0xF0,
  0xA2, 0x09, 0xFF, 0xFF, 0xF0, 0xA2, 0x01, 0x0E, 0xFF, 0xF9, 0x0C, 0x04, 0xFB, 0x0A, 0x30, 0x7F,
  0xFF, 0x98, 0x12, 0x0E, 0xFA, 0x0A, 0x40, 0xAF, 0xFE, 0x05, 0x20, 0xBF, 0xA0, 0xA5, 0x0B, 0xFF,
  0xC0, 0x63, 0x06, 0xFA, 0x0A, 0x60, 0x8F, 0xF9, 0x0D, 0x04, 0x40, 0x2F, 0xA0, 0xA7, 0x03, 0x0B,
  0xFC, 0x0E, 0x08, 0x70, 0xEF, 0x90, 0xA7, 0x28, 0x32, 0x6A, 0xDE, 0xA8, 0x2E, 0xC9, 0x47, 0x75,
  // "ý" (U+00FD)
  0x77, 0x71, 0x06, 0xFE, 0x0B, 0x77, 0x77, 0x0E, 0xFE, 0x03, 0x77, 0x76, 0x08, 0xFE, 0x05, 0x77,
  0x76, 0x02, 0xFE, 0x06, 0x77, 0x77, 0x0B, 0xFD, 0x06, 0x77, 0x77, 0x05, 0xFD, 0x06, 0x77, 0x77,
  0x01, 0x0E, 0xFC, 0x06, 0x77, 0x77, 0x10, 0xAF, 0xC0, 0x57, 0x77, 0x71, 0x06, 0xFC, 0x05, 0x77,
  0x77, 0x10, 0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x72, 0x0B, 0xFA, 0x0E, 0x03, 0x77, 0x77, 0x20,
  0x7F, 0xA0, 0xD0, 0x27, 0x77, 0x72, 0x02, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x30, 0x6F, 0x90, 0xA8,
  0x0B, 0xC6, 0x00, 0xAF, 0xD0, 0x47, 0x72, 0x0C, 0xFC, 0x0E, 0x05, 0xFD, 0x08, 0x77, 0x10, 0x1F,
  0xD0, 0xA1, 0xFD, 0x0C, 0x77, 0x10, 0x4F, 0xD8, 0x15, 0x0A, 0xFD, 0x01, 0x77, 0x08, 0xFD, 0x81,
  0x10, 0x5F, 0xD0, 0x57, 0x70, 0xCF, 0xC0, 0xB2, 0x01, 0xFD, 0x09, 0x76, 0x01, 0xFD, 0x06, 0x30,
  0xBF, 0xC0, 0xD7, 0x60, 0x5F, 0xD0, 0x23, 0x06, 0xFD, 0x02, 0x75, 0x08, 0xFC, 0x0D, 0x40, 0x1F,
  0xD0, 0x67, 0x50, 0xCF, 0xC0, 0x85, 0x0C, 0xFC, 0x0A, 0x74, 0x01, 0xFD, 0x03, 0x50, 0x7F, 0xC0,
  0xE7, 0x40, 0x5F, 0xC0, 0xE6, 0x02, 0xFD, 0x03, 0x73, 0x09, 0xFC, 0x09, 0x70, 0xCF, 0xC0, 0x77,
  0x30, 0xDF, 0xC0, 0x57, 0x07, 0xFC, 0x0B, 0x72, 0x01, 0xFD, 0x71, 0x02, 0xFD, 0x72, 0x05, 0xFC,
  0x0B, 0x72, 0x0D, 0xFC, 0x04, 0x71, 0x09, 0xFC, 0x06, 0x72, 0x08, 0xFC, 0x08, 0x71, 0x0D, 0xFC,
  0x02, 0x72, 0x03, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x40, 0xEF, 0xC0, 0x16, 0x05, 0xFC, 0x08,
  0x74, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x40, 0x4F, 0xC0, 0xA6, 0x0D, 0xFB, 0x0E, 0x76,
  0x0E, 0xFB, 0x0E, 0x50, 0x1F, 0xC0, 0x97, 0x60, 0x9F, 0xC0, 0x24, 0x05, 0xFC, 0x04, 0x76, 0x04,
  0xFC, 0x07, 0x40, 0x9F, 0xC7, 0x71, 0x0E, 0xFB, 0x0B, 0x40, 0xDF, 0xB0, 0xB7, 0x71, 0x0A, 0xFB,
  0x0E, 0x30, 0x2F, 0xC0, 0x67, 0x71, 0x05, 0xFC, 0x03, 0x20, 0x6F, 0xC0, 0x17, 0x72, 0xFC, 0x06,
  0x20, 0xAF, 0xB0, 0xC7, 0x73, 0x0B, 0xFB, 0x0A, 0x20, 0xDF, 0xB0, 0x77, 0x73, 0x06, 0xFB, 0x81,
  0xD0, 0x1F, 0xC0, 0x37, 0x73, 0x01, 0xFC, 0x01, 0x05, 0xFB, 0x0D, 0x77, 0x50, 0xBF, 0xB0, 0x30,
  0x7F, 0xB0, 0x97, 0x75, 0x06, 0xFB, 0x06, 0x0A, 0xFB, 0x04, 0x77, 0x50, 0x1F, 0xB0, 0x80, 0xDF,
  0xA0, 0xE7, 0x77, 0x0C, 0xFA, 0x0B, 0xFB, 0x0A, 0x77, 0x70, 0x7F, 0xFE, 0x06, 0x77, 0x70, 0x2F,
  0xFE, 0x01, 0x77, 0x71, 0x0D, 0xFF, 0xC0, 0xC7, 0x77, 0x20, 0x8F, 0xFC, 0x07, 0x77, 0x72, 0x03,
  0xFF, 0xC0, 0x27, 0x77, 0x30, 0xDF, 0xFA, 0x0D, 0x77, 0x74, 0x08, 0xFF, 0xA0, 0x97, 0x77, 0x40,
  0x3F, 0xFA, 0x04, 0x77, 0x75, 0x0E, 0xFF, 0x0E, 0x77, 0x76, 0x09, 0xFF, 0x0A, 0x77, 0x76, 0x04,
  0xFF, 0x05, 0x77, 0x77, 0x0E, 0xFE, 0x01, 0x77, 0x77, 0x0A, 0xFD, 0x0C, 0x77, 0x77, 0x10, 0x5F,
  0xD0, 0x77, 0x77, 0x71, 0x02, 0xFD, 0x02, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xD7, 0x77, 0x72, 0x09,
  0xFC, 0x08, 0x77, 0x77, 0x20, 0xEF, 0xC0, 0x47, 0x77, 0x71, 0x04, 0xFC, 0x0E, 0x77, 0x77, 0x20,
  0x9F, 0xC0, 0xA7, 0x77, 0x71, 0x01, 0xFD, 0x05, 0x77, 0x77, 0x10, 0x7F, 0xC0, 0xE7, 0x77, 0x71,
  0x01, 0x0E, 0xFC, 0x0A, 0x77, 0x77, 0x10, 0xAF, 0xD0, 0x47, 0x77, 0x70, 0x9F, 0xD0, 0xD7, 0x77,
  0x86, 0x87, 0x43, 0x24, 0x7D, 0xFE, 0x06, 0x77, 0x70, 0xBF, 0xFD, 0x0D, 0x77, 0x71, 0x0B, 0xFF,
  0xD0, 0x57, 0x77, 0x10, 0xBF, 0xFC, 0x0B, 0x77, 0x72, 0x0B, 0xFF, 0xB0, 0xE0, 0x17, 0x77, 0x20,
  0xBF, 0xFB, 0x04, 0x77, 0x73, 0x0B, 0xFF, 0xA0, 0x57, 0x77, 0x40, 0xBF, 0xF0, 0xE0, 0x47, 0x77,
  0x50, 0xBF, 0xE0, 0xC0, 0x17, 0x77, 0x60, 0xBF, 0xC0, 0xC0, 0x47, 0x77, 0x71, 0x83, 0x48, 0xBD,
  0xEA, 0x83, 0xDC, 0xA6, 0x27, 0x77, 0x70,
  // "þ" (U+00FE)
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05,
  0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC,
  0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFC, 0x0B, 0x68, 0x91, 0x16,
  0xAD, 0xEF, 0xED, 0xA5, 0x17, 0x40, 0x5F, 0xC0, 0xB4, 0x01, 0x09, 0xFB, 0x81, 0xE8, 0x17, 0x20,
  0x5F, 0xC0, 0xA3, 0x04, 0x0E, 0xFE, 0x0D, 0x04, 0x71, 0x05, 0xFC, 0x0A, 0x20, 0x5F, 0xFB, 0x05,
  0x70, 0x5F, 0xC8, 0x19, 0x03, 0xFF, 0xD0, 0x46, 0x05, 0xFC, 0x81, 0x81, 0xEF, 0xFD, 0x0E, 0x02,
  0x50, 0x5F, 0xC0, 0x60, 0xAF, 0xFF, 0x0C, 0x50, 0x5F, 0xC0, 0xCF, 0xFF, 0xA0, 0x64, 0x05, 0xFF,
  0xFF, 0xF0, 0xE4, 0x05, 0x80, 0xC0, 0xF0, 0x63, 0x05, 0xFF, 0xA8, 0x5C, 0x64, 0x24, 0x8E, 0xFE,
  0x0C, 0x30, 0x5F, 0xF9, 0x06, 0x60, 0x10, 0xCF, 0xE0, 0x22, 0x05, 0xFF, 0x06, 0x71, 0x01, 0x0E,
  0xFD, 0x07, 0x20, 0x5F, 0xE0, 0xB7, 0x30, 0x5F, 0xD0, 0xB2, 0x05, 0xFE, 0x04, 0x74, 0x0D, 0xFD,
  0x20, 0x5F, 0xD0, 0xD7, 0x50, 0x8F, 0xD8, 0x13, 0x05, 0xFD, 0x0A, 0x75, 0x03, 0xFD, 0x81, 0x60,
  0x5F, 0xD0, 0x67, 0x6F, 0xD8, 0x18, 0x05, 0xFD, 0x03, 0x76, 0x0C, 0xFC, 0x81, 0xA0, 0x5F, 0xD0,
  0x17, 0x60, 0xAF, 0xC8, 0x1C, 0x05, 0xFD, 0x77, 0x08, 0xFC, 0x81, 0xD0, 0x5F, 0xC0, 0xE7, 0x70,
  0x7F, 0xC8, 0x1E, 0x05, 0xFC, 0x0D, 0x77, 0x06, 0xFD, 0x10, 0x5F, 0xC0, 0xD7, 0x70, 0x5F, 0xD1,
  0x05, 0xFC, 0x0C, 0x77, 0x05, 0xFD, 0x01, 0x05, 0xFC, 0x0C, 0x77, 0x05, 0xFD, 0x01, 0x05, 0xFC,
  0x0C, 0x77, 0x05, 0xFD, 0x01, 0x05, 0xFC, 0x0D, 0x77, 0x05, 0xFD, 0x10, 0x5F, 0xC0, 0xD7, 0x70,
  0x6F, 0xD1, 0x05, 0xFC, 0x0E, 0x77, 0x07, 0xFC, 0x81, 0xE0, 0x5F, 0xD7, 0x70, 0x9F, 0xC8, 0x1D,
  0x05, 0xFD, 0x01, 0x76, 0x0A, 0xFC, 0x81, 0xC0, 0x5F, 0xD0, 0x37, 0x60, 0xDF, 0xC8, 0x1A, 0x05,
  0xFD, 0x06, 0x76, 0xFD, 0x81, 0x80, 0x5F, 0xD0, 0x97, 0x50, 0x3F, 0xD8, 0x15, 0x05, 0xFD, 0x0D,
  0x75, 0x08, 0xFD, 0x81, 0x30, 0x5F, 0xE0, 0x47, 0x40, 0xDF, 0xC0, 0xE2, 0x05, 0xFE, 0x0B, 0x73,
  0x04, 0xFD, 0x0B, 0x20, 0x5F, 0xF0, 0x67, 0x20, 0xDF, 0xD0, 0x72, 0x05, 0xFF, 0x90, 0x77, 0x0B,
  0xFE, 0x02, 0x20, 0x5F, 0xFA, 0x85, 0xC7, 0x42, 0x37, 0xDF, 0xE0, 0xC3, 0x05, 0x80, 0xC0, 0xF0,
  0x53, 0x05, 0xFF, 0xFF, 0xF0, 0xD4, 0x05, 0xFF, 0xFF, 0xF0, 0x64, 0x05, 0xFC, 0x08, 0x0E, 0xFF,
  0xF0, 0xC5, 0x05, 0xFC, 0x07, 0x04, 0xFF, 0xE0, 0xE0, 0x25, 0x05, 0xFC, 0x81, 0x90, 0x7F, 0xFD,
  0x05, 0x60, 0x5F, 0xC0, 0xA2, 0x08, 0xFF, 0xB0, 0x67, 0x05, 0xFC, 0x0B, 0x30, 0x60, 0xEF, 0xE0,
  0xE0, 0x47, 0x10, 0x5F, 0xC0, 0xC4, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x72, 0x05, 0xFC, 0x0D, 0x68,
  0x91, 0x16, 0xAD, 0xEF, 0xED, 0xA6, 0x17, 0x40, 0x5F, 0xC0, 0xD7, 0x77, 0x70, 0x5F, 0xC0, 0xE7,
  0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77,
  0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70,
  0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F,
  0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0,
  0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7,
  0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77, 0x70, 0x5F, 0xC0, 0xE7, 0x77,
  0x70,
  // "ÿ" (U+00FF)
  0x73, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x77, 0x40, 0x20, 0xDE, 0x0D,
  0x02, 0x70, 0x40, 0xEE, 0x0C, 0x77, 0x30, 0xCF, 0x90, 0xC6, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x10,
  0x3F, 0xB0, 0x45, 0x07, 0xFB, 0x01, 0x77, 0x07, 0xFB, 0x08, 0x50, 0xBF, 0xB0, 0x57, 0x70, 0x9F,
  0xB0, 0xA5, 0x0D, 0xFB, 0x07, 0x77, 0x09, 0xFB, 0x0A, 0x50, 0xDF, 0xB0, 0x77, 0x70, 0x7F, 0xB0,
  0x85, 0x0C, 0xFB, 0x06, 0x77, 0x04, 0xFB, 0x04, 0x50, 0x8F, 0xB0, 0x27, 0x71, 0x0C, 0xF9, 0x0C,
  0x60, 0x10, 0xEF, 0x90, 0xA7, 0x72, 0x02, 0x0D, 0xE0, 0xD0, 0x27, 0x04, 0x0E, 0xE0, 0xC0, 0x17,
  0x74, 0x85, 0x7C, 0xEE, 0xC7, 0x17, 0x28, 0x51, 0x8D, 0xFE, 0xC6, 0x80, 0xC9, 0x00, 0x0A, 0xFD,
  0x04, 0x77, 0x20, 0xCF, 0xC0, 0xE0, 0x5F, 0xD0, 0x87, 0x71, 0x01, 0xFD, 0x0A, 0x1F, 0xD0, 0xC7,
  0x71, 0x04, 0xFD, 0x81, 0x50, 0xAF, 0xD0, 0x17, 0x70, 0x8F, 0xD8, 0x11, 0x05, 0xFD, 0x05, 0x77,
  0x0C, 0xFC, 0x0B, 0x20, 0x1F, 0xD0, 0x97, 0x60, 0x1F, 0xD0, 0x63, 0x0B, 0xFC, 0x0D, 0x76, 0x05,
  0xFD, 0x02, 0x30, 0x6F, 0xD0, 0x27, 0x50, 0x8F, 0xC0, 0xD4, 0x01, 0xFD, 0x06, 0x75, 0x0C, 0xFC,
  0x08, 0x50, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0x35, 0x07, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x0E,
  0x60, 0x2F, 0xD0, 0x37, 0x30, 0x9F, 0xC0, 0x97, 0x0C, 0xFC, 0x07, 0x73, 0x0D, 0xFC, 0x05, 0x70,
  0x7F, 0xC0, 0xB7, 0x20, 0x1F, 0xD7, 0x10, 0x2F, 0xD7, 0x20, 0x5F, 0xC0, 0xB7, 0x20, 0xDF, 0xC0,
  0x47, 0x10, 0x9F, 0xC0, 0x67, 0x20, 0x8F, 0xC0, 0x87, 0x10, 0xDF, 0xC0, 0x27, 0x20, 0x3F, 0xC0,
  0xD7, 0x01, 0xFC, 0x0C, 0x74, 0x0E, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x87, 0x40, 0x9F, 0xC0, 0x56,
  0x09, 0xFC, 0x03, 0x74, 0x04, 0xFC, 0x0A, 0x60, 0xDF, 0xB0, 0xE7, 0x60, 0xEF, 0xB0, 0xE5, 0x01,
  0xFC, 0x09, 0x76, 0x09, 0xFC, 0x02, 0x40, 0x5F, 0xC0, 0x47, 0x60, 0x4F, 0xC0, 0x74, 0x09, 0xFC,
  0x77, 0x10, 0xEF, 0xB0, 0xB4, 0x0D, 0xFB, 0x0B, 0x77, 0x10, 0xAF, 0xB0, 0xE3, 0x02, 0xFC, 0x06,
  0x77, 0x10, 0x5F, 0xC0, 0x32, 0x06, 0xFC, 0x01, 0x77, 0x2F, 0xC0, 0x62, 0x0A, 0xFB, 0x0C, 0x77,
  0x30, 0xBF, 0xB0, 0xA2, 0x0D, 0xFB, 0x07, 0x77, 0x30, 0x6F, 0xB8, 0x1D, 0x01, 0xFC, 0x03, 0x77,
  0x30, 0x1F, 0xC0, 0x10, 0x5F, 0xB0, 0xD7, 0x75, 0x0B, 0xFB, 0x03, 0x07, 0xFB, 0x09, 0x77, 0x50,
  0x6F, 0xB0, 0x60, 0xAF, 0xB0, 0x47, 0x75, 0x01, 0xFB, 0x08, 0x0D, 0xFA, 0x0E, 0x77, 0x70, 0xCF,
  0xA0, 0xBF, 0xB0, 0xA7, 0x77, 0x07, 0xFF, 0xE0, 0x67, 0x77, 0x02, 0xFF, 0xE0, 0x17, 0x77, 0x10,
  0xDF, 0xFC, 0x0C, 0x77, 0x72, 0x08, 0xFF, 0xC0, 0x77, 0x77, 0x20, 0x3F, 0xFC, 0x02, 0x77, 0x73,
  0x0D, 0xFF, 0xA0, 0xD7, 0x77, 0x40, 0x8F, 0xFA, 0x09, 0x77, 0x74, 0x03, 0xFF, 0xA0, 0x47, 0x77,
  0x50, 0xEF, 0xF0, 0xE7, 0x77, 0x60, 0x9F, 0xF0, 0xA7, 0x77, 0x60, 0x4F, 0xF0, 0x57, 0x77, 0x70,
  0xEF, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0xD0, 0xC7, 0x77, 0x71, 0x05, 0xFD, 0x07, 0x77, 0x77, 0x10,
  0x2F, 0xD0, 0x27, 0x77, 0x71, 0x05, 0xFC, 0x0D, 0x77, 0x77, 0x20, 0x9F, 0xC0, 0x87, 0x77, 0x72,
  0x0E, 0xFC, 0x04, 0x77, 0x77, 0x10, 0x4F, 0xC0, 0xE7, 0x77, 0x72, 0x09, 0xFC, 0x0A, 0x77, 0x77,
  0x10, 0x1F, 0xD0, 0x57, 0x77, 0x71, 0x07, 0xFC, 0x0E, 0x77, 0x77, 0x10, 0x10, 0xEF, 0xC0, 0xA7,
  0x77, 0x71, 0x0A, 0xFD, 0x04, 0x77, 0x77, 0x09, 0xFD, 0x0D, 0x77, 0x78, 0x68, 0x74, 0x32, 0x47,
  0xDF, 0xE0, 0x67, 0x77, 0x0B, 0xFF, 0xD0, 0xD7, 0x77, 0x10, 0xBF, 0xFD, 0x05, 0x77, 0x71, 0x0B,
  0xFF, 0xC0, 0xB7, 0x77, 0x20, 0xBF, 0xFB, 0x0E, 0x01, 0x77, 0x72, 0x0B, 0xFF, 0xB0, 0x47, 0x77,
  0x30, 0xBF, 0xFA, 0x05, 0x77, 0x74, 0x0B, 0xFF, 0x0E, 0x04, 0x77, 0x75, 0x0B, 0xFE, 0x0C, 0x01,
  0x77, 0x76, 0x0B, 0xFC, 0x0C, 0x04, 0x77, 0x77, 0x18, 0x34, 0x8B, 0xDE, 0xA8, 0x3D, 0xCA, 0x62,
  0x77, 0x77,
  // "Ā" (U+0100)
  0x75, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC,
  0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06,
  0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x77,
  0x74, 0x06, 0xFF, 0xFC, 0x0D, 0x80, 0xDA, 0x20, 0x06, 0xFF, 0x90, 0xE7, 0x77, 0x77, 0x0A, 0xFF,
  0xA0, 0x47, 0x77, 0x76, 0x0E, 0xFF, 0xA0, 0x87, 0x77, 0x75, 0x03, 0xFF, 0xB0, 0xC7, 0x77, 0x75,
  0x07, 0xFF, 0xC0, 0x17, 0x77, 0x74, 0x0C, 0xFF, 0xC0, 0x57, 0x77, 0x73, 0x01, 0xFF, 0xD0, 0xA7,
  0x77, 0x73, 0x05, 0xFF, 0xD0, 0xE7, 0x77, 0x73, 0x09, 0xFF, 0xE0, 0x37, 0x77, 0x72, 0x0D, 0xFF,
  0xE0, 0x77, 0x77, 0x71, 0x02, 0xFB, 0x0C, 0x0E, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xB0, 0x90,
  0xCF, 0xB0, 0x17, 0x77, 0x70, 0xBF, 0xB0, 0x70, 0x9F, 0xB0, 0x57, 0x77, 0x7F, 0xC0, 0x40, 0x6F,
  0xB0, 0x97, 0x77, 0x60, 0x4F, 0xC0, 0x10, 0x3F, 0xB0, 0xD7, 0x77, 0x60, 0x8F, 0xB0, 0xD2, 0xFC,
  0x02, 0x77, 0x75, 0x0D, 0xFB, 0x0A, 0x20, 0xCF, 0xB0, 0x77, 0x77, 0x40, 0x1F, 0xC0, 0x62, 0x09,
  0xFB, 0x0B, 0x77, 0x74, 0x06, 0xFC, 0x03, 0x20, 0x5F, 0xC7, 0x77, 0x40, 0xAF, 0xB0, 0xE3, 0x02,
  0xFC, 0x04, 0x77, 0x73, 0x0E, 0xFB, 0x0B, 0x40, 0xEF, 0xB0, 0x97, 0x77, 0x20, 0x3F, 0xC0, 0x74,
  0x0B, 0xFB, 0x0D, 0x77, 0x72, 0x07, 0xFC, 0x04, 0x40, 0x8F, 0xC0, 0x27, 0x77, 0x10, 0xCF, 0xC5,
  0x04, 0xFC, 0x06, 0x77, 0x70, 0x1F, 0xC0, 0xC5, 0x01, 0xFC, 0x0A, 0x77, 0x70, 0x5F, 0xC0, 0x96,
  0x0C, 0xFB, 0x0E, 0x77, 0x70, 0x9F, 0xC0, 0x56, 0x09, 0xFC, 0x03, 0x77, 0x60, 0xDF, 0xC0, 0x16,
  0x05, 0xFC, 0x08, 0x77, 0x50, 0x2F, 0xC0, 0xD7, 0x01, 0xFC, 0x0C, 0x77, 0x50, 0x6F, 0xC0, 0xA7,
  0x10, 0xDF, 0xC0, 0x17, 0x74, 0x0B, 0xFC, 0x06, 0x71, 0x0A, 0xFC, 0x05, 0x77, 0x40, 0xEF, 0xC0,
  0x37, 0x10, 0x6F, 0xC0, 0xA7, 0x73, 0x04, 0xFC, 0x0E, 0x72, 0x02, 0xFC, 0x0E, 0x77, 0x30, 0x8F,
  0xC0, 0xB7, 0x30, 0xEF, 0xC0, 0x37, 0x72, 0x0C, 0xFC, 0x07, 0x73, 0x0A, 0xFC, 0x07, 0x77, 0x10,
  0x1F, 0xD0, 0x47, 0x30, 0x7F, 0xC0, 0xC7, 0x71, 0x05, 0xFD, 0x74, 0x03, 0xFD, 0x01, 0x77, 0x0A,
  0xFC, 0x0C, 0x75, 0xFD, 0x05, 0x77, 0x0E, 0x80, 0xC0, 0xF0, 0x97, 0x60, 0x38, 0x0C, 0x1F, 0x0D,
  0x76, 0x07, 0x80, 0xC2, 0xF0, 0x27, 0x50, 0xB8, 0x0C, 0x2F, 0x07, 0x75, 0x80, 0xC3, 0xF0, 0xB7,
  0x40, 0x58, 0x0C, 0x4F, 0x74, 0x09, 0x80, 0xC4, 0xF0, 0x47, 0x30, 0xD8, 0x0C, 0x4F, 0x08, 0x72,
  0x02, 0x80, 0xC5, 0xF0, 0xD7, 0x20, 0x68, 0x0C, 0x6F, 0x02, 0x71, 0x0B, 0x80, 0xC6, 0xF0, 0x67,
  0x10, 0xEF, 0xD0, 0x37, 0x72, 0x06, 0xFD, 0x0A, 0x70, 0x4F, 0xE7, 0x73, 0x02, 0xFD, 0x0E, 0x70,
  0x8F, 0xD0, 0xB7, 0x74, 0x0E, 0xFD, 0x03, 0x60, 0xCF, 0xD0, 0x77, 0x74, 0x0A, 0xFD, 0x08, 0x50,
  0x1F, 0xE0, 0x47, 0x74, 0x06, 0xFD, 0x0C, 0x50, 0x5F, 0xE7, 0x75, 0x02, 0xFE, 0x01, 0x40, 0xAF,
  0xD0, 0xC7, 0x76, 0x0E, 0xFD, 0x05, 0x40, 0xEF, 0xD0, 0x87, 0x76, 0x0A, 0xFD, 0x0A, 0x30, 0x3F,
  0xE0, 0x47, 0x76, 0x06, 0xFD, 0x0E, 0x30, 0x7F, 0xE7, 0x77, 0x03, 0xFE, 0x03, 0x20, 0xBF, 0xD0,
  0xC7, 0x77, 0x10, 0xEF, 0xD0, 0x72, 0xFE, 0x08, 0x77, 0x71, 0x0A, 0xFD, 0x81, 0xB0, 0x4F, 0xE0,
  0x47, 0x77, 0x10, 0x7F, 0xE0, 0x10, 0x9F, 0xE0, 0x17, 0x77, 0x10, 0x3F, 0xE0, 0x50, 0xDF, 0xD0,
  0xC7, 0x77, 0x30, 0xEF, 0xD0, 0x90,
  // "ā" (U+0101)
  0x60, 0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD7, 0x30,
  0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F,
  0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD7, 0x30, 0x6F, 0xFF, 0xC0, 0xD8, 0x0B, 0x86, 0x08,
  0x54, 0x79, 0xBD, 0xEE, 0xA8, 0x3E, 0xCA, 0x74, 0x77, 0x58, 0x12, 0x7C, 0xFF, 0x98, 0x1E, 0x92,
  0x77, 0x05, 0x0B, 0xFF, 0xF0, 0x87, 0x40, 0x50, 0xDF, 0xFF, 0xB0, 0xC0, 0x17, 0x10, 0xBF, 0xFF,
  0xE0, 0xD0, 0x17, 0x09, 0xFF, 0xFF, 0x0C, 0x70, 0x2F, 0xFF, 0xF9, 0x07, 0x70, 0xCF, 0xFF, 0xF0,
  0xE0, 0x16, 0x06, 0xFF, 0xFF, 0x90, 0x77, 0x0E, 0xFF, 0xFF, 0x0D, 0x70, 0x9F, 0x86, 0xB8, 0x54,
  0x23, 0x5A, 0xFF, 0x02, 0x60, 0x2C, 0x0B, 0x05, 0x72, 0x04, 0xFE, 0x06, 0x78, 0x2C, 0xF9, 0x17,
  0x50, 0x6F, 0xD0, 0x97, 0x03, 0x01, 0x77, 0x10, 0xDF, 0xC0, 0xC7, 0x77, 0x30, 0x8F, 0xC0, 0xD7,
  0x77, 0x30, 0x4F, 0xD7, 0x77, 0x30, 0x2F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7,
  0x77, 0x30, 0x1F, 0xD7, 0x38, 0x51, 0x58, 0xAC, 0xDE, 0xFF, 0xE7, 0x10, 0x60, 0xBF, 0xFF, 0xE6,
  0x06, 0x0E, 0xFF, 0xFF, 0x94, 0x01, 0x0C, 0xFF, 0xFF, 0xB3, 0x02, 0x0D, 0xFF, 0xFF, 0xC2, 0x01,
  0x0D, 0xFF, 0xFF, 0xD2, 0x0A, 0xFF, 0xFF, 0xE1, 0x04, 0xFF, 0xFF, 0xF1, 0x0B, 0xFF, 0x82, 0xA5,
  0x21, 0x40, 0x1F, 0xD0, 0x2F, 0xE0, 0xB0, 0x27, 0x10, 0x1F, 0xD0, 0x6F, 0xD0, 0xB7, 0x30, 0x1F,
  0xD0, 0xAF, 0xD0, 0x27, 0x30, 0x1F, 0xD0, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0xEF, 0xC0, 0x77,
  0x40, 0x3F, 0xFF, 0xB0, 0x57, 0x40, 0x5F, 0xFF, 0xB0, 0x47, 0x40, 0x8F, 0xFF, 0xB0, 0x67, 0x40,
  0xEF, 0xD0, 0xEF, 0xC0, 0x87, 0x30, 0x7F, 0xE0, 0xDF, 0xC0, 0xE7, 0x20, 0x3F, 0xF0, 0xAF, 0xD0,
  0x97, 0x04, 0x0E, 0xFF, 0x07, 0xFE, 0x85, 0xB4, 0x10, 0x15, 0xBF, 0xFA, 0x03, 0x80, 0xC0, 0xF1,
  0x0D, 0xFF, 0xFF, 0xF1, 0x08, 0xFF, 0xFA, 0x0B, 0x0C, 0xFB, 0x10, 0x10, 0xEF, 0xFF, 0x81, 0xE1,
  0x7F, 0xB2, 0x07, 0xFF, 0xF8, 0x14, 0x02, 0xFB, 0x30, 0xDF, 0xFD, 0x06, 0x30, 0xDF, 0xA3, 0x02,
  0x0E, 0xFF, 0xB0, 0x64, 0x08, 0xFA, 0x40, 0x30, 0xDF, 0xF0, 0xE0, 0x45, 0x03, 0xFA, 0x50, 0x10,
  0x9F, 0xD0, 0x90, 0x17, 0x0E, 0xF9, 0x78, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x77, 0x40,
  // "Ă" (U+0102)
  0x74, 0x03, 0x80, 0x27, 0x06, 0x77, 0x80, 0x37, 0x01, 0x77, 0x71, 0x04, 0xE0, 0xE7, 0x60, 0x3F,
  0x01, 0x77, 0x71, 0x03, 0xF0, 0x37, 0x50, 0x7F, 0x77, 0x72, 0x01, 0xF0, 0xB7, 0x40, 0x10, 0xEE,
  0x0D, 0x77, 0x73, 0x0E, 0xF0, 0x87, 0x20, 0x20, 0xCF, 0x09, 0x77, 0x73, 0x0A, 0xF9, 0x82, 0xD7,
  0x31, 0x28, 0x12, 0x59, 0xFA, 0x05, 0x77, 0x73, 0x05, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x74, 0x0D,
  0xFF, 0xFB, 0x08, 0x77, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x77, 0x77, 0x0C, 0xFF, 0xF9, 0x04, 0x77,
  0x77, 0x02, 0x0E, 0xFF, 0xE0, 0x67, 0x77, 0x72, 0x03, 0x0E, 0xFF, 0xC0, 0x67, 0x77, 0x74, 0x01,
  0x0C, 0xFF, 0x90, 0xD0, 0x37, 0x77, 0x77, 0x05, 0x0C, 0xFC, 0x0E, 0x06, 0x80, 0xC3, 0x08, 0x91,
  0x37, 0xBC, 0xEF, 0xED, 0xB8, 0x38, 0x0D, 0xB2, 0x00, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF,
  0xFA, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xFA, 0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77,
  0x50, 0x7F, 0xFC, 0x01, 0x77, 0x77, 0x40, 0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A,
  0x77, 0x77, 0x30, 0x5F, 0xFD, 0x0E, 0x77, 0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF,
  0xFE, 0x07, 0x77, 0x77, 0x10, 0x2F, 0xB0, 0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09,
  0x0C, 0xFB, 0x01, 0x77, 0x77, 0x0B, 0xFB, 0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06,
  0xFB, 0x09, 0x77, 0x76, 0x04, 0xFC, 0x01, 0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F,
  0xC0, 0x27, 0x77, 0x50, 0xDF, 0xB0, 0xA2, 0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20,
  0x9F, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0, 0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30,
  0x2F, 0xC0, 0x47, 0x77, 0x30, 0xEF, 0xB0, 0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07,
  0x40, 0xBF, 0xB0, 0xD7, 0x77, 0x20, 0x7F, 0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC,
  0x50, 0x4F, 0xC0, 0x67, 0x77, 0x01, 0xFC, 0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09,
  0x60, 0xCF, 0xB0, 0xE7, 0x77, 0x09, 0xFC, 0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01,
  0x60, 0x5F, 0xC0, 0x87, 0x75, 0x02, 0xFC, 0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A,
  0x71, 0x0D, 0xFC, 0x01, 0x77, 0x40, 0xBF, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC,
  0x03, 0x71, 0x06, 0xFC, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08,
  0xFC, 0x0B, 0x73, 0x0E, 0xFC, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71,
  0x01, 0xFD, 0x04, 0x73, 0x07, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70,
  0xAF, 0xC0, 0xC7, 0x5F, 0xD0, 0x57, 0x70, 0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0,
  0xD7, 0x60, 0x78, 0x0C, 0x2F, 0x02, 0x75, 0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B,
  0x74, 0x05, 0x80, 0xC4, 0xF7, 0x40, 0x98, 0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87,
  0x20, 0x28, 0x0C, 0x5F, 0x0D, 0x72, 0x06, 0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06,
  0x71, 0x0E, 0xFD, 0x03, 0x77, 0x20, 0x6F, 0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7,
  0x08, 0xFD, 0x0B, 0x77, 0x40, 0xEF, 0xD0, 0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85,
  0x01, 0xFE, 0x04, 0x77, 0x40, 0x6F, 0xD0, 0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A,
  0xFD, 0x0C, 0x77, 0x60, 0xEF, 0xD0, 0x54, 0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03,
  0xFE, 0x04, 0x77, 0x60, 0x6F, 0xD0, 0xE3, 0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD,
  0x0C, 0x77, 0x71, 0x0E, 0xFD, 0x07, 0x2F, 0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE,
  0x04, 0x77, 0x71, 0x07, 0xFE, 0x01, 0x09, 0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD,
  0x0C, 0x77, 0x73, 0x0E, 0xFD, 0x09,
  // "ă" (U+0103)
  0x50, 0x38, 0x02, 0x70, 0x67, 0x78, 0x03, 0x70, 0x17, 0x04, 0xE0, 0xE7, 0x60, 0x3F, 0x01, 0x70,
  0x3F, 0x03, 0x75, 0x07, 0xF7, 0x10, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x20, 0xEF, 0x08,
  0x72, 0x02, 0x0C, 0xF0, 0x97, 0x20, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0, 0x57,
  0x20, 0x5F, 0xFF, 0xC0, 0xE0, 0x17, 0x30, 0xDF, 0xFF, 0xB0, 0x87, 0x40, 0x6F, 0xFF, 0xA0, 0xE7,
  0x60, 0xCF, 0xFF, 0x90, 0x47, 0x60, 0x20, 0xEF, 0xFE, 0x06, 0x77, 0x10, 0x30, 0xEF, 0xFC, 0x06,
  0x77, 0x30, 0x10, 0xCF, 0xF9, 0x0D, 0x03, 0x77, 0x60, 0x50, 0xCF, 0xC0, 0xE0, 0x67, 0x77, 0x38,
  0x91, 0x37, 0xBC, 0xEF, 0xED, 0xB8, 0x38, 0x0B, 0x96, 0x08, 0x54, 0x79, 0xBD, 0xEE, 0xA8, 0x3E,
  0xCA, 0x74, 0x77, 0x58, 0x12, 0x7C, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x05, 0x0B, 0xFF, 0xF0, 0x87,
  0x40, 0x50, 0xDF, 0xFF, 0xB0, 0xC0, 0x17, 0x10, 0xBF, 0xFF, 0xE0, 0xD0, 0x17, 0x09, 0xFF, 0xFF,
  0x0C, 0x70, 0x2F, 0xFF, 0xF9, 0x07, 0x70, 0xCF, 0xFF, 0xF0, 0xE0, 0x16, 0x06, 0xFF, 0xFF, 0x90,
  0x77, 0x0E, 0xFF, 0xFF, 0x0D, 0x70, 0x9F, 0x86, 0xB8, 0x54, 0x23, 0x5A, 0xFF, 0x02, 0x60, 0x2C,
  0x0B, 0x05, 0x72, 0x04, 0xFE, 0x06, 0x78, 0x2C, 0xF9, 0x17, 0x50, 0x6F, 0xD0, 0x97, 0x03, 0x01,
  0x77, 0x10, 0xDF, 0xC0, 0xC7, 0x77, 0x30, 0x8F, 0xC0, 0xD7, 0x77, 0x30, 0x4F, 0xD7, 0x77, 0x30,
  0x2F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x77, 0x30, 0x1F, 0xD7, 0x38, 0x51,
  0x58, 0xAC, 0xDE, 0xFF, 0xE7, 0x10, 0x60, 0xBF, 0xFF, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0x94, 0x01,
  0x0C, 0xFF, 0xFF, 0xB3, 0x02, 0x0D, 0xFF, 0xFF, 0xC2, 0x01, 0x0D, 0xFF, 0xFF, 0xD2, 0x0A, 0xFF,
  0xFF, 0xE1, 0x04, 0xFF, 0xFF, 0xF1, 0x0B, 0xFF, 0x82, 0xA5, 0x21, 0x40, 0x1F, 0xD0, 0x2F, 0xE0,
  0xB0, 0x27, 0x10, 0x1F, 0xD0, 0x6F, 0xD0, 0xB7, 0x30, 0x1F, 0xD0, 0xAF, 0xD0, 0x27, 0x30, 0x1F,
  0xD0, 0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD0, 0xEF, 0xC0, 0x77, 0x40, 0x3F, 0xFF, 0xB0, 0x57, 0x40,
  0x5F, 0xFF, 0xB0, 0x47, 0x40, 0x8F, 0xFF, 0xB0, 0x67, 0x40, 0xEF, 0xD0, 0xEF, 0xC0, 0x87, 0x30,
  0x7F, 0xE0, 0xDF, 0xC0, 0xE7, 0x20, 0x3F, 0xF0, 0xAF, 0xD0, 0x97, 0x04, 0x0E, 0xFF, 0x07, 0xFE,
  0x85, 0xB4, 0x10, 0x15, 0xBF, 0xFA, 0x03, 0x80, 0xC0, 0xF1, 0x0D, 0xFF, 0xFF, 0xF1, 0x08, 0xFF,
  0xFA, 0x0B, 0x0C, 0xFB, 0x10, 0x10, 0xEF, 0xFF, 0x81, 0xE1, 0x7F, 0xB2, 0x07, 0xFF, 0xF8, 0x14,
  0x02, 0xFB, 0x30, 0xDF, 0xFD, 0x06, 0x30, 0xDF, 0xA3, 0x02, 0x0E, 0xFF, 0xB0, 0x64, 0x08, 0xFA,
  0x40, 0x30, 0xDF, 0xF0, 0xE0, 0x45, 0x03, 0xFA, 0x50, 0x10, 0x9F, 0xD0, 0x90, 0x17, 0x0E, 0xF9,
  0x78, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x77, 0x40,
  // "Ą" (U+0104)
  0x77, 0x30, 0x6F, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04, 0x77, 0x77, 0x60, 0xEF, 0xFA,
  0x08, 0x77, 0x77, 0x50, 0x3F, 0xFB, 0x0C, 0x77, 0x77, 0x50, 0x7F, 0xFC, 0x01, 0x77, 0x77, 0x40,
  0xCF, 0xFC, 0x05, 0x77, 0x77, 0x30, 0x1F, 0xFD, 0x0A, 0x77, 0x77, 0x30, 0x5F, 0xFD, 0x0E, 0x77,
  0x77, 0x30, 0x9F, 0xFE, 0x03, 0x77, 0x77, 0x20, 0xDF, 0xFE, 0x07, 0x77, 0x77, 0x10, 0x2F, 0xB0,
  0xC0, 0xEF, 0xA0, 0xC7, 0x77, 0x71, 0x07, 0xFB, 0x09, 0x0C, 0xFB, 0x01, 0x77, 0x77, 0x0B, 0xFB,
  0x07, 0x09, 0xFB, 0x05, 0x77, 0x77, 0xFC, 0x04, 0x06, 0xFB, 0x09, 0x77, 0x76, 0x04, 0xFC, 0x01,
  0x03, 0xFB, 0x0D, 0x77, 0x76, 0x08, 0xFB, 0x0D, 0x2F, 0xC0, 0x27, 0x77, 0x50, 0xDF, 0xB0, 0xA2,
  0x0C, 0xFB, 0x07, 0x77, 0x74, 0x01, 0xFC, 0x06, 0x20, 0x9F, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xC0,
  0x32, 0x05, 0xFC, 0x77, 0x74, 0x0A, 0xFB, 0x0E, 0x30, 0x2F, 0xC0, 0x47, 0x77, 0x30, 0xEF, 0xB0,
  0xB4, 0x0E, 0xFB, 0x09, 0x77, 0x72, 0x03, 0xFC, 0x07, 0x40, 0xBF, 0xB0, 0xD7, 0x77, 0x20, 0x7F,
  0xC0, 0x44, 0x08, 0xFC, 0x02, 0x77, 0x71, 0x0C, 0xFC, 0x50, 0x4F, 0xC0, 0x67, 0x77, 0x01, 0xFC,
  0x0C, 0x50, 0x1F, 0xC0, 0xA7, 0x77, 0x05, 0xFC, 0x09, 0x60, 0xCF, 0xB0, 0xE7, 0x77, 0x09, 0xFC,
  0x05, 0x60, 0x9F, 0xC0, 0x37, 0x76, 0x0D, 0xFC, 0x01, 0x60, 0x5F, 0xC0, 0x87, 0x75, 0x02, 0xFC,
  0x0D, 0x70, 0x1F, 0xC0, 0xC7, 0x75, 0x06, 0xFC, 0x0A, 0x71, 0x0D, 0xFC, 0x01, 0x77, 0x40, 0xBF,
  0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x57, 0x74, 0x0E, 0xFC, 0x03, 0x71, 0x06, 0xFC, 0x0A, 0x77, 0x30,
  0x4F, 0xC0, 0xE7, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x08, 0xFC, 0x0B, 0x73, 0x0E, 0xFC, 0x03, 0x77,
  0x20, 0xCF, 0xC0, 0x77, 0x30, 0xAF, 0xC0, 0x77, 0x71, 0x01, 0xFD, 0x04, 0x73, 0x07, 0xFC, 0x0C,
  0x77, 0x10, 0x5F, 0xD7, 0x40, 0x3F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xC7, 0x5F, 0xD0, 0x57, 0x70,
  0xE8, 0x0C, 0x0F, 0x09, 0x76, 0x03, 0x80, 0xC1, 0xF0, 0xD7, 0x60, 0x78, 0x0C, 0x2F, 0x02, 0x75,
  0x0B, 0x80, 0xC2, 0xF0, 0x77, 0x58, 0x0C, 0x3F, 0x0B, 0x74, 0x05, 0x80, 0xC4, 0xF7, 0x40, 0x98,
  0x0C, 0x4F, 0x04, 0x73, 0x0D, 0x80, 0xC4, 0xF0, 0x87, 0x20, 0x28, 0x0C, 0x5F, 0x0D, 0x72, 0x06,
  0x80, 0xC6, 0xF0, 0x27, 0x10, 0xB8, 0x0C, 0x6F, 0x06, 0x71, 0x0E, 0xFD, 0x03, 0x77, 0x20, 0x6F,
  0xD0, 0xA7, 0x04, 0xFE, 0x77, 0x30, 0x2F, 0xD0, 0xE7, 0x08, 0xFD, 0x0B, 0x77, 0x40, 0xEF, 0xD0,
  0x36, 0x0C, 0xFD, 0x07, 0x77, 0x40, 0xAF, 0xD0, 0x85, 0x01, 0xFE, 0x04, 0x77, 0x40, 0x6F, 0xD0,
  0xC5, 0x05, 0xFE, 0x77, 0x50, 0x2F, 0xE0, 0x14, 0x0A, 0xFD, 0x0C, 0x77, 0x60, 0xEF, 0xD0, 0x54,
  0x0E, 0xFD, 0x08, 0x77, 0x60, 0xAF, 0xD0, 0xA3, 0x03, 0xFE, 0x04, 0x77, 0x60, 0x6F, 0xD0, 0xE3,
  0x07, 0xFE, 0x77, 0x70, 0x3F, 0xE0, 0x32, 0x0B, 0xFD, 0x0C, 0x77, 0x71, 0x0E, 0xFD, 0x07, 0x2F,
  0xE0, 0x87, 0x77, 0x10, 0xAF, 0xD8, 0x1B, 0x04, 0xFE, 0x04, 0x77, 0x71, 0x07, 0xFE, 0x01, 0x09,
  0xFE, 0x01, 0x77, 0x71, 0x03, 0xFE, 0x05, 0x0D, 0xFD, 0x0C, 0x77, 0x73, 0xFE, 0x09, 0x80, 0xC2,
  0x00, 0xBF, 0x05, 0x80, 0xC6, 0x00, 0xCF, 0x06, 0x80, 0xC6, 0x00, 0xAF, 0x08, 0x80, 0xC6, 0x00,
  0x7F, 0x0C, 0x80, 0xC6, 0x00, 0x3F, 0x90, 0x28, 0x0C, 0x60, 0x0C, 0xF0, 0x98, 0x0C, 0x60, 0x04,
  0xF9, 0x03, 0x80, 0xC6, 0x00, 0xAF, 0x0E, 0x80, 0xC7, 0x0F, 0x90, 0xC8, 0x0C, 0x60, 0x03, 0xF9,
  0x0D, 0x80, 0xC6, 0x00, 0x5F, 0xA8, 0x0C, 0x60, 0x05, 0xFA, 0x07, 0x80, 0xC5, 0x00, 0x4F, 0xB8,
  0x58, 0x10, 0x14, 0x93, 0x77, 0x77, 0x60, 0x3F, 0xFA, 0x03, 0x77, 0x77, 0x70, 0xEF, 0xF9, 0x03,
  0x77, 0x77, 0x70, 0x9F, 0xF9, 0x03, 0x77, 0x77, 0x70, 0x2F, 0xF9, 0x03, 0x80, 0xC0, 0x00, 0x7F,
  0xF0, 0x38, 0x0C, 0x10, 0x08, 0xFE, 0x03, 0x80, 0xC2, 0x00, 0x40, 0xDF, 0xC0, 0x38, 0x0C, 0x40,
  0x89, 0x14, 0x8C, 0xDE, 0xFE, 0xCA, 0x61, 0x30,
  // "ą" (U+0105)
  0x76, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x83, 0xEC, 0xA7, 0x47, 0x77, 0x81, 0x27, 0xCF, 0xF9, 0x81,
  0xE9, 0x27, 0x72, 0x05, 0x0B, 0xFF, 0xF0, 0x87, 0x60, 0x50, 0xDF, 0xFF, 0xB0, 0xC0, 0x17, 0x30,
  0xBF, 0xFF, 0xE0, 0xD0, 0x17, 0x20, 0x9F, 0xFF, 0xF0, 0xC7, 0x20, 0x2F, 0xFF, 0xF9, 0x07, 0x72,
  0x0C, 0xFF, 0xFF, 0x0E, 0x01, 0x71, 0x06, 0xFF, 0xFF, 0x90, 0x77, 0x20, 0xEF, 0xFF, 0xF0, 0xD7,
  0x20, 0x9F, 0x86, 0xB8, 0x54, 0x23, 0x5A, 0xFF, 0x02, 0x71, 0x02, 0xC0, 0xB0, 0x57, 0x20, 0x4F,
  0xE0, 0x67, 0x28, 0x2C, 0xF9, 0x17, 0x50, 0x6F, 0xD0, 0x97, 0x20, 0x30, 0x17, 0x71, 0x0D, 0xFC,
  0x0C, 0x77, 0x75, 0x08, 0xFC, 0x0D, 0x77, 0x75, 0x04, 0xFD, 0x77, 0x75, 0x02, 0xFD, 0x77, 0x75,
  0x01, 0xFD, 0x77, 0x75, 0x01, 0xFD, 0x77, 0x75, 0x01, 0xFD, 0x75, 0x85, 0x15, 0x8A, 0xCD, 0xEF,
  0xFE, 0x73, 0x06, 0x0B, 0xFF, 0xFE, 0x71, 0x06, 0x0E, 0xFF, 0xFF, 0x96, 0x01, 0x0C, 0xFF, 0xFF,
  0xB5, 0x02, 0x0D, 0xFF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFF, 0xD4, 0x0A, 0xFF, 0xFF, 0xE3, 0x04,
  0xFF, 0xFF, 0xF3, 0x0B, 0xFF, 0x82, 0xA5, 0x21, 0x40, 0x1F, 0xD2, 0x02, 0xFE, 0x0B, 0x02, 0x71,
  0x01, 0xFD, 0x20, 0x6F, 0xD0, 0xB7, 0x30, 0x1F, 0xD2, 0x0A, 0xFD, 0x02, 0x73, 0x01, 0xFD, 0x20,
  0xCF, 0xC0, 0xA7, 0x40, 0x1F, 0xD2, 0x0E, 0xFC, 0x07, 0x74, 0x03, 0xFD, 0x2F, 0xD0, 0x57, 0x40,
  0x5F, 0xD2, 0xFD, 0x04, 0x74, 0x08, 0xFD, 0x2F, 0xD0, 0x67, 0x40, 0xEF, 0xD2, 0x0E, 0xFC, 0x08,
  0x73, 0x07, 0xFE, 0x20, 0xDF, 0xC0, 0xE7, 0x20, 0x3F, 0xF2, 0x0A, 0xFD, 0x09, 0x70, 0x40, 0xEF,
  0xF2, 0x07, 0xFE, 0x85, 0xB4, 0x10, 0x15, 0xBF, 0xFA, 0x20, 0x38, 0x0C, 0x0F, 0x30, 0xDF, 0xFF,
  0xFF, 0x30, 0x8F, 0xFF, 0xA0, 0xB0, 0xCF, 0xB3, 0x01, 0x0E, 0xFF, 0xF8, 0x1E, 0x17, 0xFB, 0x40,
  0x7F, 0xFF, 0x81, 0x40, 0x2F, 0xB5, 0x0D, 0xFF, 0xD0, 0x63, 0x0D, 0xFA, 0x50, 0x20, 0xEF, 0xFB,
  0x06, 0x40, 0x8F, 0xA6, 0x03, 0x0D, 0xFF, 0x0E, 0x04, 0x50, 0x3F, 0xA7, 0x01, 0x09, 0xFD, 0x09,
  0x01, 0x7F, 0xA7, 0x28, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x71, 0x0B, 0xF0, 0x57, 0x77,
  0x71, 0x0C, 0xF0, 0x67, 0x77, 0x71, 0x0A, 0xF0, 0x87, 0x77, 0x71, 0x07, 0xF0, 0xC7, 0x77, 0x71,
  0x03, 0xF9, 0x02, 0x77, 0x77, 0x10, 0xCF, 0x09, 0x77, 0x77, 0x10, 0x4F, 0x90, 0x37, 0x77, 0x71,
  0x0A, 0xF0, 0xE7, 0x77, 0x72, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x90, 0xD7, 0x77, 0x71, 0x05,
  0xFA, 0x77, 0x77, 0x10, 0x5F, 0xA0, 0x77, 0x77, 0x70, 0x4F, 0xB8, 0x58, 0x10, 0x14, 0x93, 0x77,
  0x70, 0x3F, 0xFA, 0x03, 0x77, 0x71, 0x0E, 0xFF, 0x90, 0x37, 0x77, 0x10, 0x9F, 0xF9, 0x03, 0x77,
  0x71, 0x02, 0xFF, 0x90, 0x37, 0x77, 0x20, 0x7F, 0xF0, 0x37, 0x77, 0x30, 0x8F, 0xE0, 0x37, 0x77,
  0x40, 0x40, 0xDF, 0xC0, 0x37, 0x77, 0x68, 0x91, 0x48, 0xCD, 0xEF, 0xEC, 0xA6, 0x11,
  // "Ć" (U+0106)
  0x77, 0x74, 0x06, 0xFE, 0x0B, 0x77, 0x75, 0x0E, 0xFE, 0x03, 0x77, 0x74, 0x08, 0xFE, 0x05, 0x77,
  0x74, 0x02, 0xFE, 0x06, 0x77, 0x75, 0x0B, 0xFD, 0x06, 0x77, 0x75, 0x05, 0xFD, 0x06, 0x77, 0x75,
  0x01, 0x0E, 0xFC, 0x06, 0x77, 0x76, 0x0A, 0xFC, 0x05, 0x77, 0x76, 0x06, 0xFC, 0x05, 0x77, 0x76,
  0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x77, 0x77, 0x0B, 0xFA, 0x0E, 0x03, 0x77, 0x77, 0x07, 0xFA, 0x0D,
  0x02, 0x77, 0x77, 0x02, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xA8, 0x0B, 0x80, 0x08,
  0x41, 0x58, 0xBC, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x37, 0x77, 0x30, 0x60, 0xBF, 0xF9, 0x82, 0xEA,
  0x51, 0x77, 0x40, 0x70, 0xEF, 0xFF, 0x0B, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFC, 0x0C, 0x05, 0x74,
  0x07, 0xFF, 0xFF, 0x0E, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x97, 0x20, 0xAF, 0xFF, 0xFA, 0x04, 0x71,
  0x09, 0xFF, 0xFF, 0xA0, 0xD7, 0x10, 0x7F, 0xFF, 0xFB, 0x08, 0x70, 0x4F, 0xFF, 0xFC, 0x03, 0x70,
  0xDF, 0xF9, 0x87, 0xC7, 0x43, 0x23, 0x69, 0xDF, 0x0D, 0x70, 0x8F, 0xF0, 0xC0, 0x47, 0x20, 0x40,
  0xBD, 0x07, 0x60, 0x2F, 0xF0, 0xA7, 0x60, 0x30, 0xBB, 0x02, 0x60, 0x9F, 0xE0, 0xA7, 0x72, 0x81,
  0x5D, 0xB6, 0x01, 0xFE, 0x0C, 0x77, 0x50, 0x36, 0x08, 0xFE, 0x03, 0x77, 0x75, 0x0E, 0xFD, 0x09,
  0x77, 0x75, 0x04, 0xFE, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x0A, 0x77, 0x76, 0x0E, 0xFD, 0x05, 0x77,
  0x75, 0x02, 0xFE, 0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x0D,
  0xFD, 0x04, 0x77, 0x76, 0xFE, 0x01, 0x77, 0x75, 0x02, 0xFD, 0x0E, 0x77, 0x76, 0x04, 0xFD, 0x0C,
  0x77, 0x76, 0x06, 0xFD, 0x0B, 0x77, 0x76, 0x07, 0xFD, 0x09, 0x77, 0x76, 0x08, 0xFD, 0x08, 0x77,
  0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76,
  0x0A, 0xFD, 0x07, 0x77, 0x76, 0x0A, 0xFD, 0x07, 0x77, 0x76, 0x09, 0xFD, 0x07, 0x77, 0x76, 0x09,
  0xFD, 0x08, 0x77, 0x76, 0x08, 0xFD, 0x09, 0x77, 0x76, 0x07, 0xFD, 0x0B, 0x77, 0x76, 0x05, 0xFD,
  0x0D, 0x77, 0x76, 0x04, 0xFD, 0x0E, 0x77, 0x76, 0x02, 0xFE, 0x02, 0x77, 0x76, 0xFE, 0x05, 0x77,
  0x76, 0x0D, 0xFD, 0x08, 0x77, 0x76, 0x0A, 0xFD, 0x0C, 0x77, 0x76, 0x06, 0xFE, 0x01, 0x77, 0x75,
  0x03, 0xFE, 0x07, 0x77, 0x76, 0x0E, 0xFD, 0x0D, 0x77, 0x76, 0x09, 0xFE, 0x05, 0x77, 0x75, 0x05,
  0xFE, 0x0D, 0x77, 0x76, 0x0E, 0xFE, 0x08, 0x77, 0x75, 0x08, 0xFF, 0x05, 0x77, 0x50, 0x25, 0x02,
  0xFF, 0x90, 0x67, 0x72, 0x82, 0x4B, 0xF1, 0x50, 0xAF, 0xF9, 0x0A, 0x01, 0x74, 0x81, 0x28, 0xDB,
  0x01, 0x50, 0x2F, 0xFB, 0x81, 0xA5, 0x22, 0x84, 0x12, 0x36, 0x9D, 0xE0, 0x16, 0x09, 0xFF, 0xFF,
  0xD0, 0x17, 0x0D, 0xFF, 0xFF, 0xC0, 0x17, 0x04, 0xFF, 0xFF, 0xC0, 0x17, 0x10, 0x7F, 0xFF, 0xFB,
  0x01, 0x72, 0x09, 0xFF, 0xFF, 0xA0, 0x17, 0x30, 0x8F, 0xFF, 0xF9, 0x01, 0x74, 0x06, 0xFF, 0xFF,
  0x01, 0x75, 0x03, 0x0C, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x06, 0x0D, 0xFF, 0xF8, 0x1D, 0x71, 0x77,
  0x30, 0x40, 0xBF, 0xFA, 0x81, 0xD9, 0x47, 0x77, 0x28, 0x44, 0x7A, 0xCD, 0xEA, 0x85, 0xED, 0xCA,
  0x85, 0x27, 0x10,
  // "ć" (U+0107)
  0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x76, 0x0E, 0xFE, 0x03, 0x77, 0x50, 0x8F, 0xE0, 0x57, 0x75, 0x02,
  0xFE, 0x06, 0x77, 0x60, 0xBF, 0xD0, 0x67, 0x76, 0x05, 0xFD, 0x06, 0x77, 0x60, 0x10, 0xEF, 0xC0,
  0x67, 0x77, 0x0A, 0xFC, 0x05, 0x77, 0x70, 0x6F, 0xC0, 0x57, 0x77, 0x01, 0x0E, 0xFA, 0x0E, 0x04,
  0x77, 0x71, 0x0B, 0xFA, 0x0E, 0x03, 0x77, 0x71, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x71, 0x02, 0xFA,
  0x0C, 0x01, 0x77, 0x72, 0x06, 0xF9, 0x0A, 0x80, 0xAC, 0x30, 0x89, 0x42, 0x69, 0xBD, 0xEF, 0xED,
  0xCB, 0x95, 0x27, 0x74, 0x81, 0x17, 0xDF, 0xF8, 0x1D, 0x83, 0x77, 0x07, 0x0E, 0xFF, 0xD0, 0xC0,
  0x47, 0x30, 0x20, 0xCF, 0xFF, 0xA0, 0x97, 0x10, 0x30, 0xEF, 0xFF, 0xB0, 0x67, 0x03, 0x0E, 0xFF,
  0xFC, 0x01, 0x60, 0x10, 0xDF, 0xFF, 0xC0, 0xA7, 0x0B, 0xFF, 0xFD, 0x05, 0x60, 0x6F, 0xFF, 0xD0,
  0xE7, 0x0E, 0xFF, 0xFD, 0x09, 0x60, 0x7F, 0xF8, 0x6C, 0x64, 0x24, 0x59, 0xED, 0x04, 0x60, 0xEF,
  0xD0, 0xE0, 0x47, 0x10, 0x50, 0xBA, 0x0D, 0x60, 0x5F, 0xE0, 0x37, 0x48, 0x13, 0xB8, 0x60, 0xAF,
  0xD0, 0x67, 0x77, 0xFD, 0x0D, 0x77, 0x70, 0x4F, 0xD0, 0x67, 0x77, 0x08, 0xFD, 0x01, 0x77, 0x70,
  0xBF, 0xC0, 0xC7, 0x77, 0x10, 0xEF, 0xC0, 0x87, 0x77, 0x01, 0xFD, 0x06, 0x77, 0x70, 0x3F, 0xD0,
  0x47, 0x77, 0x04, 0xFD, 0x02, 0x77, 0x70, 0x5F, 0xD7, 0x77, 0x10, 0x6F, 0xD7, 0x77, 0x10, 0x7F,
  0xD7, 0x77, 0x10, 0x7F, 0xC0, 0xE7, 0x77, 0x10, 0x7F, 0xD7, 0x77, 0x10, 0x6F, 0xD7, 0x77, 0x10,
  0x6F, 0xD7, 0x77, 0x10, 0x5F, 0xD0, 0x17, 0x77, 0x04, 0xFD, 0x03, 0x77, 0x70, 0x3F, 0xD0, 0x57,
  0x77, 0x01, 0xFD, 0x07, 0x77, 0x71, 0x0E, 0xFC, 0x0B, 0x77, 0x71, 0x0B, 0xFD, 0x77, 0x71, 0x08,
  0xFD, 0x05, 0x77, 0x70, 0x5F, 0xD0, 0xC7, 0x77, 0x01, 0xFE, 0x06, 0x77, 0x10, 0x30, 0x74, 0x0C,
  0xFD, 0x0E, 0x02, 0x75, 0x82, 0x19, 0xF9, 0x40, 0x6F, 0xE0, 0xE0, 0x47, 0x20, 0x30, 0xAB, 0x09,
  0x40, 0x10, 0xEF, 0xF8, 0x7C, 0x64, 0x23, 0x56, 0xAE, 0xD0, 0x95, 0x09, 0xFF, 0xFF, 0x09, 0x50,
  0x10, 0xEF, 0xFF, 0xE0, 0x96, 0x07, 0xFF, 0xFE, 0x09, 0x70, 0xBF, 0xFF, 0xD0, 0x97, 0x01, 0x0C,
  0xFF, 0xFC, 0x09, 0x71, 0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x73, 0x0A, 0xFF, 0xFA, 0x06, 0x74, 0x04,
  0x0D, 0xFF, 0xD0, 0xA0, 0x17, 0x70, 0x50, 0xBF, 0xF8, 0x1E, 0x82, 0x77, 0x48, 0x41, 0x58, 0xBD,
  0xEA, 0x84, 0xED, 0xC9, 0x63, 0x71,
  // "Ĉ" (U+0108)
  0x77, 0x30, 0x18, 0x09, 0x07, 0x02, 0x77, 0x76, 0x09, 0xFD, 0x0B, 0x77, 0x75, 0x03, 0xFF, 0x04,
  0x77, 0x74, 0x0C, 0xFF, 0x0D, 0x77, 0x73, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x10, 0x3F, 0xFC, 0x03,
  0x77, 0x70, 0xDF, 0xFC, 0x0D, 0x77, 0x60, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x40, 0x4F, 0xA8,
  0x1E, 0x33, 0xFB, 0x05, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x77, 0x10,
  0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x77, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x97, 0x50, 0x4F,
  0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x30, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D,
  0xF9, 0x03, 0x72, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF, 0x07, 0x80, 0xAE, 0x30, 0x84, 0x15,
  0x8B, 0xCE, 0xA8, 0x5E, 0xDC, 0xB8, 0x53, 0x77, 0x73, 0x06, 0x0B, 0xFF, 0x98, 0x2E, 0xA5, 0x17,
  0x74, 0x07, 0x0E, 0xFF, 0xF0, 0xB0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xC0, 0xC0, 0x57, 0x40, 0x7F,
  0xFF, 0xF0, 0xE7, 0x30, 0x9F, 0xFF, 0xF9, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0xA0, 0x47, 0x10, 0x9F,
  0xFF, 0xFA, 0x0D, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x87, 0x04, 0xFF, 0xFF, 0xC0, 0x37, 0x0D, 0xFF,
  0x98, 0x7C, 0x74, 0x32, 0x36, 0x9D, 0xF0, 0xD7, 0x08, 0xFF, 0x0C, 0x04, 0x72, 0x04, 0x0B, 0xD0,
  0x76, 0x02, 0xFF, 0x0A, 0x76, 0x03, 0x0B, 0xB0, 0x26, 0x09, 0xFE, 0x0A, 0x77, 0x28, 0x15, 0xDB,
  0x60, 0x1F, 0xE0, 0xC7, 0x75, 0x03, 0x60, 0x8F, 0xE0, 0x37, 0x77, 0x50, 0xEF, 0xD0, 0x97, 0x77,
  0x50, 0x4F, 0xE0, 0x27, 0x77, 0x50, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0xEF, 0xD0, 0x57, 0x77, 0x50,
  0x2F, 0xE7, 0x77, 0x60, 0x6F, 0xD0, 0xB7, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xDF, 0xD0,
  0x47, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x50, 0x2F, 0xD0, 0xE7, 0x77, 0x60, 0x4F, 0xD0, 0xC7, 0x77,
  0x60, 0x6F, 0xD0, 0xB7, 0x77, 0x60, 0x7F, 0xD0, 0x97, 0x77, 0x60, 0x8F, 0xD0, 0x87, 0x77, 0x60,
  0x9F, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0xAF,
  0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0,
  0x87, 0x77, 0x60, 0x8F, 0xD0, 0x97, 0x77, 0x60, 0x7F, 0xD0, 0xB7, 0x77, 0x60, 0x5F, 0xD0, 0xD7,
  0x77, 0x60, 0x4F, 0xD0, 0xE7, 0x77, 0x60, 0x2F, 0xE0, 0x27, 0x77, 0x6F, 0xE0, 0x57, 0x77, 0x60,
  0xDF, 0xD0, 0x87, 0x77, 0x60, 0xAF, 0xD0, 0xC7, 0x77, 0x60, 0x6F, 0xE0, 0x17, 0x77, 0x50, 0x3F,
  0xE0, 0x77, 0x77, 0x60, 0xEF, 0xD0, 0xD7, 0x77, 0x60, 0x9F, 0xE0, 0x57, 0x77, 0x50, 0x5F, 0xE0,
  0xD7, 0x77, 0x60, 0xEF, 0xE0, 0x87, 0x77, 0x50, 0x8F, 0xF0, 0x57, 0x75, 0x02, 0x50, 0x2F, 0xF9,
  0x06, 0x77, 0x28, 0x24, 0xBF, 0x15, 0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x48, 0x12, 0x8D, 0xB0, 0x15,
  0x02, 0xFF, 0xB8, 0x1A, 0x52, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x01, 0x60, 0x9F, 0xFF, 0xFD, 0x01,
  0x70, 0xDF, 0xFF, 0xFC, 0x01, 0x70, 0x4F, 0xFF, 0xFC, 0x01, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x17,
  0x20, 0x9F, 0xFF, 0xFA, 0x01, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0x17, 0x40, 0x6F, 0xFF, 0xF0, 0x17,
  0x50, 0x30, 0xCF, 0xFF, 0xC0, 0xE0, 0x17, 0x70, 0x60, 0xDF, 0xFF, 0x81, 0xD7, 0x17, 0x73, 0x04,
  0x0B, 0xFF, 0xA8, 0x1D, 0x94, 0x77, 0x72, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x52,
  0x71,
  // "ĉ" (U+0109)
  0x75, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x09, 0xFD, 0x0B, 0x77, 0x60, 0x3F, 0xF0, 0x47, 0x75,
  0x0C, 0xFF, 0x0D, 0x77, 0x40, 0x7F, 0xFA, 0x08, 0x77, 0x20, 0x3F, 0xFC, 0x03, 0x77, 0x10, 0xDF,
  0xFC, 0x0D, 0x77, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x50, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05,
  0x73, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xA0, 0x44, 0x05, 0xFA,
  0x0C, 0x71, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x96, 0x04, 0xF9, 0x0E, 0x04, 0x71, 0x03, 0x0E,
  0xF9, 0x06, 0x40, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x30, 0x6F, 0x0C, 0x01,
  0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xA6, 0x08, 0x94, 0x26, 0x9B, 0xDE, 0xFE, 0xDC, 0xB9, 0x52,
  0x77, 0x48, 0x11, 0x7D, 0xFF, 0x81, 0xD8, 0x37, 0x70, 0x70, 0xEF, 0xFD, 0x0C, 0x04, 0x73, 0x02,
  0x0C, 0xFF, 0xFA, 0x09, 0x71, 0x03, 0x0E, 0xFF, 0xFB, 0x06, 0x70, 0x30, 0xEF, 0xFF, 0xC0, 0x16,
  0x01, 0x0D, 0xFF, 0xFC, 0x0A, 0x70, 0xBF, 0xFF, 0xD0, 0x56, 0x06, 0xFF, 0xFD, 0x0E, 0x70, 0xEF,
  0xFF, 0xD0, 0x96, 0x07, 0xFF, 0x86, 0xC6, 0x42, 0x45, 0x9E, 0xD0, 0x46, 0x0E, 0xFD, 0x0E, 0x04,
  0x71, 0x05, 0x0B, 0xA0, 0xD6, 0x05, 0xFE, 0x03, 0x74, 0x81, 0x3B, 0x86, 0x0A, 0xFD, 0x06, 0x77,
  0x7F, 0xD0, 0xD7, 0x77, 0x04, 0xFD, 0x06, 0x77, 0x70, 0x8F, 0xD0, 0x17, 0x77, 0x0B, 0xFC, 0x0C,
  0x77, 0x71, 0x0E, 0xFC, 0x08, 0x77, 0x70, 0x1F, 0xD0, 0x67, 0x77, 0x03, 0xFD, 0x04, 0x77, 0x70,
  0x4F, 0xD0, 0x27, 0x77, 0x05, 0xFD, 0x77, 0x71, 0x06, 0xFD, 0x77, 0x71, 0x07, 0xFD, 0x77, 0x71,
  0x07, 0xFC, 0x0E, 0x77, 0x71, 0x07, 0xFD, 0x77, 0x71, 0x06, 0xFD, 0x77, 0x71, 0x06, 0xFD, 0x77,
  0x71, 0x05, 0xFD, 0x01, 0x77, 0x70, 0x4F, 0xD0, 0x37, 0x77, 0x03, 0xFD, 0x05, 0x77, 0x70, 0x1F,
  0xD0, 0x77, 0x77, 0x10, 0xEF, 0xC0, 0xB7, 0x77, 0x10, 0xBF, 0xD7, 0x77, 0x10, 0x8F, 0xD0, 0x57,
  0x77, 0x05, 0xFD, 0x0C, 0x77, 0x70, 0x1F, 0xE0, 0x67, 0x71, 0x03, 0x07, 0x40, 0xCF, 0xD0, 0xE0,
  0x27, 0x58, 0x21, 0x9F, 0x94, 0x06, 0xFE, 0x0E, 0x04, 0x72, 0x03, 0x0A, 0xB0, 0x94, 0x01, 0x0E,
  0xFF, 0x87, 0xC6, 0x42, 0x35, 0x6A, 0xED, 0x09, 0x50, 0x9F, 0xFF, 0xF0, 0x95, 0x01, 0x0E, 0xFF,
  0xFE, 0x09, 0x60, 0x7F, 0xFF, 0xE0, 0x97, 0x0B, 0xFF, 0xFD, 0x09, 0x70, 0x10, 0xCF, 0xFF, 0xC0,
  0x97, 0x10, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x30, 0xAF, 0xFF, 0xA0, 0x67, 0x40, 0x40, 0xDF, 0xFD,
  0x0A, 0x01, 0x77, 0x05, 0x0B, 0xFF, 0x81, 0xE8, 0x27, 0x74, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E,
  0xDC, 0x96, 0x37, 0x10,
  // "Ċ" (U+010A)
  0x77, 0x78, 0x63, 0x9D, 0xEF, 0xEB, 0x67, 0x77, 0x74, 0x08, 0xF9, 0x0D, 0x02, 0x77, 0x77, 0x10,
  0x6F, 0xB0, 0xD7, 0x77, 0x71, 0x0E, 0xFC, 0x06, 0x77, 0x76, 0x03, 0xFD, 0x0A, 0x77, 0x76, 0x05,
  0xFD, 0x0D, 0x77, 0x76, 0x06, 0xFD, 0x0E, 0x77, 0x76, 0x05, 0xFD, 0x0D, 0x77, 0x76, 0x02, 0xFD,
  0x0A, 0x77, 0x77, 0x0D, 0xFC, 0x06, 0x77, 0x77, 0x05, 0xFB, 0x0C, 0x77, 0x77, 0x20, 0x7F, 0x90,
  0xC0, 0x17, 0x77, 0x73, 0x86, 0x28, 0xCE, 0xFE, 0xB5, 0x80, 0xBC, 0x70, 0x84, 0x15, 0x8B, 0xCE,
  0xA8, 0x5E, 0xDC, 0xB8, 0x53, 0x77, 0x73, 0x06, 0x0B, 0xFF, 0x98, 0x2E, 0xA5, 0x17, 0x74, 0x07,
  0x0E, 0xFF, 0xF0, 0xB0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xC0, 0xC0, 0x57, 0x40, 0x7F, 0xFF, 0xF0,
  0xE7, 0x30, 0x9F, 0xFF, 0xF9, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0xA0, 0x47, 0x10, 0x9F, 0xFF, 0xFA,
  0x0D, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x87, 0x04, 0xFF, 0xFF, 0xC0, 0x37, 0x0D, 0xFF, 0x98, 0x7C,
  0x74, 0x32, 0x36, 0x9D, 0xF0, 0xD7, 0x08, 0xFF, 0x0C, 0x04, 0x72, 0x04, 0x0B, 0xD0, 0x76, 0x02,
  0xFF, 0x0A, 0x76, 0x03, 0x0B, 0xB0, 0x26, 0x09, 0xFE, 0x0A, 0x77, 0x28, 0x15, 0xDB, 0x60, 0x1F,
  0xE0, 0xC7, 0x75, 0x03, 0x60, 0x8F, 0xE0, 0x37, 0x77, 0x50, 0xEF, 0xD0, 0x97, 0x77, 0x50, 0x4F,
  0xE0, 0x27, 0x77, 0x50, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0xEF, 0xD0, 0x57, 0x77, 0x50, 0x2F, 0xE7,
  0x77, 0x60, 0x6F, 0xD0, 0xB7, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0x47, 0x77,
  0x6F, 0xE0, 0x17, 0x77, 0x50, 0x2F, 0xD0, 0xE7, 0x77, 0x60, 0x4F, 0xD0, 0xC7, 0x77, 0x60, 0x6F,
  0xD0, 0xB7, 0x77, 0x60, 0x7F, 0xD0, 0x97, 0x77, 0x60, 0x8F, 0xD0, 0x87, 0x77, 0x60, 0x9F, 0xD0,
  0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77,
  0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x87, 0x77,
  0x60, 0x8F, 0xD0, 0x97, 0x77, 0x60, 0x7F, 0xD0, 0xB7, 0x77, 0x60, 0x5F, 0xD0, 0xD7, 0x77, 0x60,
  0x4F, 0xD0, 0xE7, 0x77, 0x60, 0x2F, 0xE0, 0x27, 0x77, 0x6F, 0xE0, 0x57, 0x77, 0x60, 0xDF, 0xD0,
  0x87, 0x77, 0x60, 0xAF, 0xD0, 0xC7, 0x77, 0x60, 0x6F, 0xE0, 0x17, 0x77, 0x50, 0x3F, 0xE0, 0x77,
  0x77, 0x60, 0xEF, 0xD0, 0xD7, 0x77, 0x60, 0x9F, 0xE0, 0x57, 0x77, 0x50, 0x5F, 0xE0, 0xD7, 0x77,
  0x60, 0xEF, 0xE0, 0x87, 0x77, 0x50, 0x8F, 0xF0, 0x57, 0x75, 0x02, 0x50, 0x2F, 0xF9, 0x06, 0x77,
  0x28, 0x24, 0xBF, 0x15, 0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x48, 0x12, 0x8D, 0xB0, 0x15, 0x02, 0xFF,
  0xB8, 0x1A, 0x52, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x01, 0x60, 0x9F, 0xFF, 0xFD, 0x01, 0x70, 0xDF,
  0xFF, 0xFC, 0x01, 0x70, 0x4F, 0xFF, 0xFC, 0x01, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x17, 0x20, 0x9F,
  0xFF, 0xFA, 0x01, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0x17, 0x40, 0x6F, 0xFF, 0xF0, 0x17, 0x50, 0x30,
  0xCF, 0xFF, 0xC0, 0xE0, 0x17, 0x70, 0x60, 0xDF, 0xFF, 0x81, 0xD7, 0x17, 0x73, 0x04, 0x0B, 0xFF,
  0xA8, 0x1D, 0x94, 0x77, 0x72, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x52, 0x71,
  // "ċ" (U+010B)
  0x77, 0x28, 0x63, 0x9D, 0xEF, 0xEB, 0x67, 0x77, 0x40, 0x8F, 0x90, 0xD0, 0x27, 0x77, 0x10, 0x6F,
  0xB0, 0xD7, 0x77, 0x10, 0xEF, 0xC0, 0x67, 0x76, 0x03, 0xFD, 0x0A, 0x77, 0x60, 0x5F, 0xD0, 0xD7,
  0x76, 0x06, 0xFD, 0x0E, 0x77, 0x60, 0x5F, 0xD0, 0xD7, 0x76, 0x02, 0xFD, 0x0A, 0x77, 0x70, 0xDF,
  0xC0, 0x67, 0x77, 0x05, 0xFB, 0x0C, 0x77, 0x72, 0x07, 0xF9, 0x0C, 0x01, 0x77, 0x73, 0x86, 0x28,
  0xCE, 0xFE, 0xB5, 0x80, 0xAF, 0x60, 0x89, 0x42, 0x69, 0xBD, 0xEF, 0xED, 0xCB, 0x95, 0x27, 0x73,
  0x81, 0x17, 0xDF, 0xF8, 0x1D, 0x83, 0x76, 0x07, 0x0E, 0xFF, 0xD0, 0xC0, 0x47, 0x20, 0x20, 0xCF,
  0xFF, 0xA0, 0x97, 0x03, 0x0E, 0xFF, 0xFB, 0x06, 0x60, 0x30, 0xEF, 0xFF, 0xC0, 0x15, 0x01, 0x0D,
  0xFF, 0xFC, 0x0A, 0x60, 0xBF, 0xFF, 0xD0, 0x55, 0x06, 0xFF, 0xFD, 0x0E, 0x60, 0xEF, 0xFF, 0xD0,
  0x95, 0x07, 0xFF, 0x86, 0xC6, 0x42, 0x45, 0x9E, 0xD0, 0x45, 0x0E, 0xFD, 0x0E, 0x04, 0x71, 0x05,
  0x0B, 0xA0, 0xD5, 0x05, 0xFE, 0x03, 0x74, 0x81, 0x3B, 0x85, 0x0A, 0xFD, 0x06, 0x77, 0x6F, 0xD0,
  0xD7, 0x76, 0x04, 0xFD, 0x06, 0x77, 0x60, 0x8F, 0xD0, 0x17, 0x76, 0x0B, 0xFC, 0x0C, 0x77, 0x70,
  0xEF, 0xC0, 0x87, 0x76, 0x01, 0xFD, 0x06, 0x77, 0x60, 0x3F, 0xD0, 0x47, 0x76, 0x04, 0xFD, 0x02,
  0x77, 0x60, 0x5F, 0xD7, 0x77, 0x06, 0xFD, 0x77, 0x70, 0x7F, 0xD7, 0x77, 0x07, 0xFC, 0x0E, 0x77,
  0x70, 0x7F, 0xD7, 0x77, 0x06, 0xFD, 0x77, 0x70, 0x6F, 0xD7, 0x77, 0x05, 0xFD, 0x01, 0x77, 0x60,
  0x4F, 0xD0, 0x37, 0x76, 0x03, 0xFD, 0x05, 0x77, 0x60, 0x1F, 0xD0, 0x77, 0x77, 0x0E, 0xFC, 0x0B,
  0x77, 0x70, 0xBF, 0xD7, 0x77, 0x08, 0xFD, 0x05, 0x77, 0x60, 0x5F, 0xD0, 0xC7, 0x76, 0x01, 0xFE,
  0x06, 0x77, 0x10, 0x30, 0x73, 0x0C, 0xFD, 0x0E, 0x02, 0x75, 0x82, 0x19, 0xF9, 0x30, 0x6F, 0xE0,
  0xE0, 0x47, 0x20, 0x30, 0xAB, 0x09, 0x30, 0x10, 0xEF, 0xF8, 0x7C, 0x64, 0x23, 0x56, 0xAE, 0xD0,
  0x94, 0x09, 0xFF, 0xFF, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xE0, 0x95, 0x07, 0xFF, 0xFE, 0x09, 0x60,
  0xBF, 0xFF, 0xD0, 0x96, 0x01, 0x0C, 0xFF, 0xFC, 0x09, 0x70, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x20,
  0xAF, 0xFF, 0xA0, 0x67, 0x30, 0x40, 0xDF, 0xFD, 0x0A, 0x01, 0x76, 0x05, 0x0B, 0xFF, 0x81, 0xE8,
  0x27, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0x96, 0x37,
  // "Č" (U+010C)
  0x71, 0x03, 0x80, 0x37, 0x04, 0x77, 0x03, 0x80, 0x37, 0x03, 0x72, 0x06, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x07, 0x73, 0x0C, 0xF9, 0x07, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x73, 0x01, 0x0E, 0xF9, 0x09,
  0x71, 0x0A, 0xF9, 0x0E, 0x02, 0x75, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x70, 0x7F, 0xA0,
  0xA4, 0x0B, 0xFA, 0x09, 0x77, 0x20, 0xBF, 0xA0, 0x92, 0x0A, 0xFA, 0x0C, 0x77, 0x30, 0x10, 0xEF,
  0xA0, 0x08, 0xFA, 0x0E, 0x02, 0x77, 0x40, 0x4F, 0xFE, 0x06, 0x77, 0x60, 0x9F, 0xFC, 0x0A, 0x77,
  0x71, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x77, 0x10, 0x3F, 0xFA, 0x05, 0x77, 0x73, 0x08, 0xFF, 0x0A,
  0x77, 0x75, 0x0D, 0xFD, 0x0E, 0x01, 0x77, 0x75, 0x05, 0xFD, 0x07, 0x80, 0xAF, 0x40, 0x84, 0x15,
  0x8B, 0xCE, 0xA8, 0x5E, 0xDC, 0xB8, 0x53, 0x77, 0x73, 0x06, 0x0B, 0xFF, 0x98, 0x2E, 0xA5, 0x17,
  0x74, 0x07, 0x0E, 0xFF, 0xF0, 0xB0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xC0, 0xC0, 0x57, 0x40, 0x7F,
  0xFF, 0xF0, 0xE7, 0x30, 0x9F, 0xFF, 0xF9, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0xA0, 0x47, 0x10, 0x9F,
  0xFF, 0xFA, 0x0D, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x87, 0x04, 0xFF, 0xFF, 0xC0, 0x37, 0x0D, 0xFF,
  0x98, 0x7C, 0x74, 0x32, 0x36, 0x9D, 0xF0, 0xD7, 0x08, 0xFF, 0x0C, 0x04, 0x72, 0x04, 0x0B, 0xD0,
  0x76, 0x02, 0xFF, 0x0A, 0x76, 0x03, 0x0B, 0xB0, 0x26, 0x09, 0xFE, 0x0A, 0x77, 0x28, 0x15, 0xDB,
  0x60, 0x1F, 0xE0, 0xC7, 0x75, 0x03, 0x60, 0x8F, 0xE0, 0x37, 0x77, 0x50, 0xEF, 0xD0, 0x97, 0x77,
  0x50, 0x4F, 0xE0, 0x27, 0x77, 0x50, 0x9F, 0xD0, 0xA7, 0x77, 0x60, 0xEF, 0xD0, 0x57, 0x77, 0x50,
  0x2F, 0xE7, 0x77, 0x60, 0x6F, 0xD0, 0xB7, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xDF, 0xD0,
  0x47, 0x77, 0x6F, 0xE0, 0x17, 0x77, 0x50, 0x2F, 0xD0, 0xE7, 0x77, 0x60, 0x4F, 0xD0, 0xC7, 0x77,
  0x60, 0x6F, 0xD0, 0xB7, 0x77, 0x60, 0x7F, 0xD0, 0x97, 0x77, 0x60, 0x8F, 0xD0, 0x87, 0x77, 0x60,
  0x9F, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0xAF,
  0xD0, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0, 0x77, 0x77, 0x60, 0x9F, 0xD0,
  0x87, 0x77, 0x60, 0x8F, 0xD0, 0x97, 0x77, 0x60, 0x7F, 0xD0, 0xB7, 0x77, 0x60, 0x5F, 0xD0, 0xD7,
  0x77, 0x60, 0x4F, 0xD0, 0xE7, 0x77, 0x60, 0x2F, 0xE0, 0x27, 0x77, 0x6F, 0xE0, 0x57, 0x77, 0x60,
  0xDF, 0xD0, 0x87, 0x77, 0x60, 0xAF, 0xD0, 0xC7, 0x77, 0x60, 0x6F, 0xE0, 0x17, 0x77, 0x50, 0x3F,
  0xE0, 0x77, 0x77, 0x60, 0xEF, 0xD0, 0xD7, 0x77, 0x60, 0x9F, 0xE0, 0x57, 0x77, 0x50, 0x5F, 0xE0,
  0xD7, 0x77, 0x60, 0xEF, 0xE0, 0x87, 0x77, 0x50, 0x8F, 0xF0, 0x57, 0x75, 0x02, 0x50, 0x2F, 0xF9,
  0x06, 0x77, 0x28, 0x24, 0xBF, 0x15, 0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x48, 0x12, 0x8D, 0xB0, 0x15,
  0x02, 0xFF, 0xB8, 0x1A, 0x52, 0x28, 0x41, 0x23, 0x69, 0xDE, 0x01, 0x60, 0x9F, 0xFF, 0xFD, 0x01,
  0x70, 0xDF, 0xFF, 0xFC, 0x01, 0x70, 0x4F, 0xFF, 0xFC, 0x01, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0x17,
  0x20, 0x9F, 0xFF, 0xFA, 0x01, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0x17, 0x40, 0x6F, 0xFF, 0xF0, 0x17,
  0x50, 0x30, 0xCF, 0xFF, 0xC0, 0xE0, 0x17, 0x70, 0x60, 0xDF, 0xFF, 0x81, 0xD7, 0x17, 0x73, 0x04,
  0x0B, 0xFF, 0xA8, 0x1D, 0x94, 0x77, 0x72, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x52,
  0x71,
  // "č" (U+010D)
  0x30, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x33, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x07, 0x40, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x90, 0xD0, 0x14, 0x01, 0x0E, 0xF9, 0x09, 0x71, 0x0A,
  0xF9, 0x0E, 0x02, 0x60, 0x3F, 0xA0, 0x96, 0x0B, 0xFA, 0x05, 0x71, 0x07, 0xFA, 0x0A, 0x40, 0xBF,
  0xA0, 0x97, 0x30, 0xBF, 0xA0, 0x92, 0x0A, 0xFA, 0x0C, 0x74, 0x01, 0x0E, 0xFA, 0x00, 0x8F, 0xA0,
  0xE0, 0x27, 0x50, 0x4F, 0xFE, 0x06, 0x77, 0x09, 0xFF, 0xC0, 0xA7, 0x72, 0x0D, 0xFF, 0xA0, 0xD0,
  0x17, 0x72, 0x03, 0xFF, 0xA0, 0x57, 0x74, 0x08, 0xFF, 0x0A, 0x77, 0x60, 0xDF, 0xD0, 0xE0, 0x17,
  0x76, 0x05, 0xFD, 0x07, 0x80, 0xAB, 0x70, 0x89, 0x42, 0x69, 0xBD, 0xEF, 0xED, 0xCB, 0x95, 0x27,
  0x74, 0x81, 0x17, 0xDF, 0xF8, 0x1D, 0x83, 0x77, 0x07, 0x0E, 0xFF, 0xD0, 0xC0, 0x47, 0x30, 0x20,
  0xCF, 0xFF, 0xA0, 0x97, 0x10, 0x30, 0xEF, 0xFF, 0xB0, 0x67, 0x03, 0x0E, 0xFF, 0xFC, 0x01, 0x60,
  0x10, 0xDF, 0xFF, 0xC0, 0xA7, 0x0B, 0xFF, 0xFD, 0x05, 0x60, 0x6F, 0xFF, 0xD0, 0xE7, 0x0E, 0xFF,
  0xFD, 0x09, 0x60, 0x7F, 0xF8, 0x6C, 0x64, 0x24, 0x59, 0xED, 0x04, 0x60, 0xEF, 0xD0, 0xE0, 0x47,
  0x10, 0x50, 0xBA, 0x0D, 0x60, 0x5F, 0xE0, 0x37, 0x48, 0x13, 0xB8, 0x60, 0xAF, 0xD0, 0x67, 0x77,
  0xFD, 0x0D, 0x77, 0x70, 0x4F, 0xD0, 0x67, 0x77, 0x08, 0xFD, 0x01, 0x77, 0x70, 0xBF, 0xC0, 0xC7,
  0x77, 0x10, 0xEF, 0xC0, 0x87, 0x77, 0x01, 0xFD, 0x06, 0x77, 0x70, 0x3F, 0xD0, 0x47, 0x77, 0x04,
  0xFD, 0x02, 0x77, 0x70, 0x5F, 0xD7, 0x77, 0x10, 0x6F, 0xD7, 0x77, 0x10, 0x7F, 0xD7, 0x77, 0x10,
  0x7F, 0xC0, 0xE7, 0x77, 0x10, 0x7F, 0xD7, 0x77, 0x10, 0x6F, 0xD7, 0x77, 0x10, 0x6F, 0xD7, 0x77,
  0x10, 0x5F, 0xD0, 0x17, 0x77, 0x04, 0xFD, 0x03, 0x77, 0x70, 0x3F, 0xD0, 0x57, 0x77, 0x01, 0xFD,
  0x07, 0x77, 0x71, 0x0E, 0xFC, 0x0B, 0x77, 0x71, 0x0B, 0xFD, 0x77, 0x71, 0x08, 0xFD, 0x05, 0x77,
  0x70, 0x5F, 0xD0, 0xC7, 0x77, 0x01, 0xFE, 0x06, 0x77, 0x10, 0x30, 0x74, 0x0C, 0xFD, 0x0E, 0x02,
  0x75, 0x82, 0x19, 0xF9, 0x40, 0x6F, 0xE0, 0xE0, 0x47, 0x20, 0x30, 0xAB, 0x09, 0x40, 0x10, 0xEF,
  0xF8, 0x7C, 0x64, 0x23, 0x56, 0xAE, 0xD0, 0x95, 0x09, 0xFF, 0xFF, 0x09, 0x50, 0x10, 0xEF, 0xFF,
  0xE0, 0x96, 0x07, 0xFF, 0xFE, 0x09, 0x70, 0xBF, 0xFF, 0xD0, 0x97, 0x01, 0x0C, 0xFF, 0xFC, 0x09,
  0x71, 0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x73, 0x0A, 0xFF, 0xFA, 0x06, 0x74, 0x04, 0x0D, 0xFF, 0xD0,
  0xA0, 0x17, 0x70, 0x50, 0xBF, 0xF8, 0x1E, 0x82, 0x77, 0x48, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED,
  0xC9, 0x63, 0x71,
  // "Ď" (U+010E)
  0x50, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x37, 0x60, 0x6F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x77, 0x70, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x70, 0x10, 0xEF, 0x90, 0x97,
  0x10, 0xAF, 0x90, 0xE0, 0x27, 0x72, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x74, 0x07, 0xFA,
  0x0A, 0x40, 0xBF, 0xA0, 0x97, 0x76, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7, 0x77, 0x01, 0x0E,
  0xFA, 0x00, 0x8F, 0xA0, 0xE0, 0x27, 0x77, 0x10, 0x4F, 0xFE, 0x06, 0x77, 0x73, 0x09, 0xFF, 0xC0,
  0xA7, 0x77, 0x50, 0xDF, 0xFA, 0x0D, 0x01, 0x77, 0x75, 0x03, 0xFF, 0xA0, 0x57, 0x77, 0x70, 0x8F,
  0xF0, 0xA7, 0x77, 0x72, 0x0D, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x5F, 0xD0, 0x78, 0x0B, 0xD6,
  0x00, 0x8F, 0xFC, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x75, 0x08, 0xFF, 0xFC, 0x81, 0xD8, 0x37, 0x72,
  0x08, 0xFF, 0xFF, 0x0D, 0x05, 0x77, 0x08, 0xFF, 0xFF, 0xA0, 0xD0, 0x57, 0x50, 0x8F, 0xFF, 0xFC,
  0x0A, 0x01, 0x73, 0x08, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x20, 0x8F, 0xFF, 0xFF, 0x04, 0x71, 0x08,
  0x80, 0xC0, 0xF0, 0x47, 0x08, 0x80, 0xC1, 0xF0, 0x36, 0x08, 0x80, 0xC1, 0xF0, 0xD0, 0x15, 0x08,
  0x80, 0xC2, 0xF0, 0xB5, 0x08, 0xFD, 0x02, 0x58, 0x21, 0x36, 0xBF, 0xFB, 0x05, 0x40, 0x8F, 0xD0,
  0x27, 0x20, 0x10, 0x9F, 0xF9, 0x0E, 0x40, 0x8F, 0xD0, 0x27, 0x40, 0x30, 0xEF, 0xF0, 0x63, 0x08,
  0xFD, 0x02, 0x75, 0x02, 0x0D, 0xFE, 0x0D, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0x30, 0xEF, 0xE0, 0x52,
  0x08, 0xFD, 0x02, 0x77, 0x06, 0xFE, 0x0B, 0x20, 0x8F, 0xD0, 0x27, 0x71, 0x0D, 0xFE, 0x81, 0x10,
  0x8F, 0xD0, 0x27, 0x71, 0x05, 0xFE, 0x81, 0x50, 0x8F, 0xD0, 0x27, 0x72, 0x0E, 0xFD, 0x81, 0x90,
  0x8F, 0xD0, 0x27, 0x72, 0x09, 0xFD, 0x81, 0xD0, 0x8F, 0xD0, 0x27, 0x72, 0x05, 0xFE, 0x01, 0x08,
  0xFD, 0x02, 0x77, 0x20, 0x1F, 0xE0, 0x30, 0x8F, 0xD0, 0x27, 0x73, 0x0D, 0xFD, 0x06, 0x08, 0xFD,
  0x02, 0x77, 0x30, 0xAF, 0xD0, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x8F, 0xD0, 0x90, 0x8F, 0xD0, 0x27,
  0x73, 0x06, 0xFD, 0x0B, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x5F, 0xD0, 0xC0, 0x8F, 0xD0, 0x27, 0x73,
  0x04, 0xFD, 0x0D, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x3F, 0xD0, 0xD0, 0x8F, 0xD0, 0x27, 0x73, 0x03,
  0xFD, 0x0E, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x3F, 0xD0, 0xE0, 0x8F, 0xD0, 0x27, 0x73, 0x03, 0xFD,
  0x0D, 0x08, 0xFD, 0x02, 0x77, 0x30, 0x3F, 0xD0, 0xD0, 0x8F, 0xD0, 0x27, 0x73, 0x04, 0xFD, 0x0C,
  0x08, 0xFD, 0x02, 0x77, 0x30, 0x5F, 0xD0, 0xB0, 0x8F, 0xD0, 0x27, 0x73, 0x06, 0xFD, 0x0A, 0x08,
  0xFD, 0x02, 0x77, 0x30, 0x8F, 0xD0, 0x08, 0xFD, 0x02, 0x77, 0x30, 0xAF, 0xD0, 0x70, 0x8F, 0xD0,
  0x27, 0x73, 0x0C, 0xFD, 0x04, 0x08, 0xFD, 0x02, 0x77, 0x3F, 0xE0, 0x20, 0x8F, 0xD0, 0x27, 0x72,
  0x03, 0xFE, 0x10, 0x8F, 0xD0, 0x27, 0x72, 0x07, 0xFD, 0x81, 0xB0, 0x8F, 0xD0, 0x27, 0x72, 0x0C,
  0xFD, 0x81, 0x70, 0x8F, 0xD0, 0x27, 0x71, 0x02, 0xFE, 0x81, 0x40, 0x8F, 0xD0, 0x27, 0x71, 0x09,
  0xFD, 0x0E, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0x2F, 0xE0, 0x92, 0x08, 0xFD, 0x02, 0x77, 0x0B, 0xFE,
  0x04, 0x20, 0x8F, 0xD0, 0x27, 0x60, 0x7F, 0xE0, 0xD3, 0x08, 0xFD, 0x02, 0x75, 0x06, 0xFF, 0x06,
  0x30, 0x8F, 0xD0, 0x27, 0x40, 0x8F, 0xF0, 0xE4, 0x08, 0xFD, 0x02, 0x72, 0x05, 0x0D, 0xFF, 0x90,
  0x54, 0x08, 0xFD, 0x02, 0x48, 0x31, 0x35, 0x9E, 0xFF, 0xA0, 0xB5, 0x08, 0x80, 0xC1, 0xF0, 0xE0,
  0x25, 0x08, 0x80, 0xC1, 0xF0, 0x56, 0x08, 0x80, 0xC0, 0xF0, 0x87, 0x08, 0xFF, 0xFF, 0xF0, 0x97,
  0x10, 0x8F, 0xFF, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xFF, 0xD0, 0x67, 0x30, 0x8F, 0xFF, 0xFB, 0x0C,
  0x03, 0x74, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x77, 0x60, 0x8F, 0xFF, 0xE0, 0xD0, 0x77, 0x71, 0x08,
  0xFF, 0xFB, 0x81, 0xD9, 0x47, 0x73, 0x08, 0xFF, 0xB8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x60,
  // "ď" (U+010F)
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x40, 0x1F, 0xC0, 0x97, 0x77, 0x60, 0x3F, 0xC0, 0xE4, 0x03, 0xFC,
  0x07, 0x77, 0x76, 0x03, 0xFC, 0x0E, 0x40, 0x5F, 0xC0, 0x17, 0x77, 0x60, 0x3F, 0xC0, 0xE4, 0x07,
  0xFB, 0x0B, 0x77, 0x77, 0x03, 0xFC, 0x0E, 0x40, 0xAF, 0xB0, 0x57, 0x77, 0x70, 0x3F, 0xC0, 0xE4,
  0x0C, 0xFA, 0x0E, 0x77, 0x77, 0x10, 0x3F, 0xC0, 0xE4, 0xFB, 0x07, 0x77, 0x77, 0x10, 0x3F, 0xC0,
  0xE3, 0x02, 0xFB, 0x01, 0x77, 0x77, 0x10, 0x3F, 0xC0, 0xE3, 0x04, 0xFA, 0x08, 0x77, 0x77, 0x20,
  0x3F, 0xC0, 0xE3, 0x07, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x3F, 0xC0, 0xE3, 0x0A, 0xF9, 0x08,
  0x77, 0x77, 0x30, 0x3F, 0xC0, 0xE3, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x73, 0x03, 0xFC, 0x0E, 0x3F,
  0x90, 0x67, 0x77, 0x74, 0x03, 0xFC, 0x0E, 0x20, 0x1F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0xC0, 0xE8,
  0x0D, 0x00, 0x03, 0xFC, 0x0E, 0x80, 0xD0, 0x00, 0x3F, 0xC0, 0xE8, 0x0D, 0x00, 0x03, 0xFC, 0x0E,
  0x77, 0x77, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xC9, 0x46, 0x02, 0xFC, 0x0E, 0x77, 0x75, 0x03, 0x0B,
  0xFB, 0x0D, 0x06, 0x40, 0x1F, 0xC0, 0xE7, 0x77, 0x40, 0x8F, 0xF0, 0xB0, 0x13, 0xFC, 0x0E, 0x77,
  0x73, 0x0B, 0xFF, 0xA0, 0xD0, 0x22, 0x0E, 0xFB, 0x0E, 0x77, 0x72, 0x0A, 0xFF, 0xC8, 0x2E, 0x10,
  0xDF, 0xB0, 0xE7, 0x77, 0x10, 0x7F, 0xFE, 0x81, 0xC0, 0xCF, 0xB0, 0xE7, 0x77, 0x03, 0xFF, 0xF9,
  0x08, 0x0B, 0xFB, 0x0E, 0x77, 0x70, 0xCF, 0xFF, 0xFE, 0x0E, 0x77, 0x60, 0x5F, 0xFF, 0xFF, 0x0E,
  0x77, 0x60, 0xCF, 0xFF, 0xFF, 0x0E, 0x77, 0x50, 0x2F, 0xF8, 0x5C, 0x63, 0x35, 0x8E, 0xFF, 0x90,
  0xE7, 0x75, 0x08, 0xFE, 0x08, 0x70, 0xAF, 0xF0, 0xE7, 0x75, 0x0D, 0xFD, 0x09, 0x72, 0x09, 0xFE,
  0x0E, 0x77, 0x40, 0x2F, 0xD0, 0xE0, 0x17, 0x30, 0xDF, 0xD0, 0xE7, 0x74, 0x05, 0xFD, 0x07, 0x74,
  0x07, 0xFD, 0x0E, 0x77, 0x40, 0x9F, 0xD0, 0x17, 0x40, 0x1F, 0xD0, 0xE7, 0x74, 0x0C, 0xFC, 0x0C,
  0x76, 0x0C, 0xFC, 0x0E, 0x77, 0x40, 0xEF, 0xC0, 0x97, 0x60, 0x8F, 0xC0, 0xE7, 0x73, 0x01, 0xFD,
  0x05, 0x76, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x3F, 0xD0, 0x37, 0x60, 0x4F, 0xC0, 0xE7, 0x73, 0x04,
  0xFD, 0x01, 0x76, 0x02, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xD7, 0x71, 0xFC, 0x0E, 0x77, 0x30, 0x6F,
  0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x77, 0x30, 0x6F, 0xC0, 0xD7, 0x71, 0xFC, 0x0E, 0x77, 0x30, 0x7F,
  0xC0, 0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x77, 0x30, 0x7F, 0xC0, 0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x77,
  0x30, 0x7F, 0xC0, 0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x77, 0x30, 0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E,
  0x77, 0x30, 0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xD7, 0x70, 0x1F, 0xC0, 0xE7,
  0x73, 0x04, 0xFD, 0x01, 0x76, 0x02, 0xFC, 0x0E, 0x77, 0x30, 0x3F, 0xD0, 0x37, 0x60, 0x4F, 0xC0,
  0xE7, 0x73, 0x01, 0xFD, 0x05, 0x76, 0x06, 0xFC, 0x0E, 0x77, 0x40, 0xEF, 0xC0, 0x97, 0x60, 0x9F,
  0xC0, 0xE7, 0x74, 0x0C, 0xFC, 0x0C, 0x76, 0x0C, 0xFC, 0x0E, 0x77, 0x40, 0x9F, 0xD0, 0x27, 0x40,
  0x1F, 0xD0, 0xE7, 0x74, 0x06, 0xFD, 0x07, 0x74, 0x07, 0xFD, 0x0E, 0x77, 0x40, 0x2F, 0xD0, 0xE0,
  0x17, 0x30, 0xDF, 0xD0, 0xE7, 0x75, 0x0D, 0xFD, 0x09, 0x72, 0x09, 0xFE, 0x0E, 0x77, 0x50, 0x8F,
  0xE0, 0x87, 0x09, 0xFF, 0x0E, 0x77, 0x50, 0x3F, 0xF8, 0x5D, 0x63, 0x34, 0x8E, 0xFF, 0x90, 0xE7,
  0x76, 0x0C, 0xFF, 0xFF, 0xF0, 0xE7, 0x76, 0x05, 0xFF, 0xFF, 0xF0, 0xE7, 0x77, 0x0C, 0xFF, 0xFF,
  0xE0, 0xE7, 0x77, 0x03, 0xFF, 0xF9, 0x00, 0xBF, 0xB0, 0xE7, 0x77, 0x10, 0x7F, 0xFE, 0x81, 0xD1,
  0x3F, 0xB0, 0xE7, 0x77, 0x20, 0xAF, 0xFC, 0x0E, 0x03, 0x20, 0xDF, 0xA0, 0xE7, 0x77, 0x30, 0xAF,
  0xFA, 0x0E, 0x03, 0x30, 0x8F, 0xA0, 0xE7, 0x77, 0x40, 0x8F, 0xF0, 0xD0, 0x34, 0x03, 0xFA, 0x0E,
  0x77, 0x75, 0x03, 0x0B, 0xFC, 0x08, 0x01, 0x60, 0xDF, 0x90, 0xE7, 0x77, 0x78, 0x91, 0x27, 0xBD,
  0xEF, 0xED, 0xA6, 0x17, 0x77, 0x77,
  // "Đ" (U+0110)
  0x50, 0x8F, 0xFC, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x30, 0x8F, 0xFF, 0xC8, 0x1D, 0x83, 0x77,
  0x70, 0x8F, 0xFF, 0xF0, 0xD0, 0x57, 0x75, 0x08, 0xFF, 0xFF, 0xA0, 0xD0, 0x57, 0x73, 0x08, 0xFF,
  0xFF, 0xC0, 0xA0, 0x17, 0x71, 0x08, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x70, 0x8F, 0xFF, 0xFF, 0x04,
  0x76, 0x08, 0x80, 0xC0, 0xF0, 0x47, 0x50, 0x88, 0x0C, 0x1F, 0x03, 0x74, 0x08, 0x80, 0xC1, 0xF0,
  0xD0, 0x17, 0x30, 0x88, 0x0C, 0x2F, 0x0B, 0x73, 0x08, 0xFD, 0x02, 0x58, 0x21, 0x37, 0xBF, 0xFB,
  0x05, 0x72, 0x08, 0xFD, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0x90, 0xE7, 0x20, 0x8F, 0xD0, 0x27, 0x40,
  0x40, 0xEF, 0xF0, 0x67, 0x10, 0x8F, 0xD0, 0x27, 0x50, 0x20, 0xEF, 0xE0, 0xD7, 0x10, 0x8F, 0xD0,
  0x27, 0x60, 0x3F, 0xF0, 0x57, 0x08, 0xFD, 0x02, 0x77, 0x07, 0xFE, 0x0B, 0x70, 0x8F, 0xD0, 0x27,
  0x71, 0x0D, 0xFE, 0x01, 0x60, 0x8F, 0xD0, 0x27, 0x71, 0x06, 0xFE, 0x05, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x0E, 0xFD, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x72, 0x09, 0xFD, 0x0D, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x05, 0xFE, 0x01, 0x50, 0x8F, 0xD0, 0x27, 0x72, 0x01, 0xFE, 0x03, 0x50, 0x8F, 0xD0, 0x27,
  0x73, 0x0D, 0xFD, 0x06, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0x0A, 0xFD, 0x08, 0x50, 0x8F, 0xD0, 0x27,
  0x73, 0x08, 0xFD, 0x09, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x07, 0xFD, 0x0B, 0x0E, 0xFF, 0xFC, 0x04,
  0x72, 0x05, 0xFD, 0x0C, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x04, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04,
  0x72, 0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x03, 0xFD, 0x00, 0xEF, 0xFF, 0xC0, 0x47,
  0x20, 0x3F, 0xD0, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72,
  0x03, 0xFD, 0x0D, 0x0E, 0xFF, 0xFC, 0x04, 0x72, 0x04, 0xFD, 0x0C, 0x0E, 0xFF, 0xFC, 0x04, 0x72,
  0x05, 0xFD, 0x0B, 0x80, 0x12, 0x09, 0xFD, 0x04, 0x80, 0x32, 0x73, 0x06, 0xFD, 0x0A, 0x50, 0x8F,
  0xD0, 0x27, 0x73, 0x08, 0xFD, 0x08, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0x0A, 0xFD, 0x07, 0x50, 0x8F,
  0xD0, 0x27, 0x73, 0x0D, 0xFD, 0x04, 0x50, 0x8F, 0xD0, 0x27, 0x73, 0xFE, 0x02, 0x50, 0x8F, 0xD0,
  0x27, 0x72, 0x03, 0xFE, 0x60, 0x8F, 0xD0, 0x27, 0x72, 0x08, 0xFD, 0x0B, 0x60, 0x8F, 0xD0, 0x27,
  0x72, 0x0D, 0xFD, 0x07, 0x60, 0x8F, 0xD0, 0x27, 0x71, 0x03, 0xFE, 0x04, 0x60, 0x8F, 0xD0, 0x27,
  0x71, 0x0A, 0xFD, 0x0E, 0x70, 0x8F, 0xD0, 0x27, 0x70, 0x2F, 0xE0, 0x97, 0x08, 0xFD, 0x02, 0x77,
  0x0B, 0xFE, 0x04, 0x70, 0x8F, 0xD0, 0x27, 0x60, 0x8F, 0xE0, 0xD7, 0x10, 0x8F, 0xD0, 0x27, 0x50,
  0x6F, 0xF0, 0x67, 0x10, 0x8F, 0xD0, 0x27, 0x40, 0x9F, 0xF0, 0xE7, 0x20, 0x8F, 0xD0, 0x27, 0x20,
  0x50, 0xDF, 0xF9, 0x05, 0x72, 0x08, 0xFD, 0x02, 0x48, 0x31, 0x35, 0x9E, 0xFF, 0xA0, 0xB7, 0x30,
  0x88, 0x0C, 0x1F, 0x0E, 0x02, 0x73, 0x08, 0x80, 0xC1, 0xF0, 0x57, 0x40, 0x88, 0x0C, 0x0F, 0x08,
  0x75, 0x08, 0xFF, 0xFF, 0xF0, 0x97, 0x60, 0x8F, 0xFF, 0xFE, 0x09, 0x77, 0x08, 0xFF, 0xFF, 0xD0,
  0x67, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0xC0, 0x37, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x77, 0x74,
  0x08, 0xFF, 0xFE, 0x0D, 0x07, 0x77, 0x60, 0x8F, 0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x71, 0x08, 0xFF,
  0xB8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x60,
  // "đ" (U+0111)
  0x77, 0x76, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xC0, 0xE7, 0x77, 0x75, 0x03, 0xFC, 0x0E,
  0x77, 0x77, 0x50, 0x3F, 0xC0, 0xE7, 0x77, 0x75, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x50, 0x3F, 0xC0,
  0xE7, 0x77, 0x75, 0x03, 0xFC, 0x0E, 0x77, 0x72, 0x03, 0xFF, 0xFE, 0x0C, 0x77, 0x30, 0x3F, 0xFF,
  0xE0, 0xC7, 0x73, 0x03, 0xFF, 0xFE, 0x0C, 0x77, 0x30, 0x3F, 0xFF, 0xE0, 0xC7, 0x73, 0x03, 0xFF,
  0xFE, 0x0C, 0x77, 0x30, 0x3F, 0xFF, 0xE0, 0xC7, 0x73, 0x03, 0xFF, 0xFE, 0x0C, 0x77, 0x30, 0x3F,
  0xFF, 0xE0, 0xC7, 0x77, 0x60, 0x3F, 0xC0, 0xE7, 0x77, 0x75, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x50,
  0x3F, 0xC0, 0xE7, 0x77, 0x75, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0xC0, 0xE7, 0x73, 0x82,
  0x38, 0xBD, 0xA8, 0x2E, 0xC9, 0x46, 0x02, 0xFC, 0x0E, 0x77, 0x10, 0x40, 0xCF, 0xB0, 0xD0, 0x64,
  0x01, 0xFC, 0x0E, 0x77, 0x0A, 0xFF, 0x0B, 0x01, 0x3F, 0xC0, 0xE7, 0x50, 0x10, 0xCF, 0xFA, 0x0D,
  0x02, 0x2F, 0xC0, 0xE7, 0x50, 0xCF, 0xFC, 0x82, 0xE1, 0x0D, 0xFB, 0x0E, 0x74, 0x0A, 0xFF, 0xE8,
  0x1C, 0x0C, 0xFB, 0x0E, 0x73, 0x05, 0xFF, 0xF9, 0x08, 0x0B, 0xFB, 0x0E, 0x73, 0x0E, 0xFF, 0xFF,
  0xE0, 0xE7, 0x20, 0x7F, 0xFF, 0xFF, 0x0E, 0x72, 0x0E, 0xFF, 0xFF, 0xF0, 0xE7, 0x10, 0x5F, 0xF8,
  0x5B, 0x53, 0x34, 0x8D, 0xFF, 0x90, 0xE7, 0x10, 0xBF, 0xE0, 0x67, 0x08, 0xFF, 0x0E, 0x71, 0xFE,
  0x06, 0x72, 0x07, 0xFE, 0x0E, 0x70, 0x4F, 0xD0, 0xC7, 0x40, 0xCF, 0xD0, 0xE7, 0x08, 0xFD, 0x05,
  0x74, 0x05, 0xFD, 0x0E, 0x70, 0xBF, 0xC0, 0xE7, 0x60, 0xEF, 0xC0, 0xE7, 0x0E, 0xFC, 0x0A, 0x76,
  0x0A, 0xFC, 0x0E, 0x7F, 0xD0, 0x67, 0x60, 0x7F, 0xC0, 0xE6, 0x02, 0xFD, 0x03, 0x76, 0x04, 0xFC,
  0x0E, 0x60, 0x4F, 0xD0, 0x27, 0x60, 0x2F, 0xC0, 0xE6, 0x05, 0xFD, 0x77, 0x01, 0xFC, 0x0E, 0x60,
  0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x60, 0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x60, 0x7F, 0xC0,
  0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x60, 0x7F, 0xC0, 0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x60, 0x7F, 0xC0,
  0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x60, 0x6F, 0xC0, 0xE7, 0x71, 0xFC, 0x0E, 0x60, 0x6F, 0xC0, 0xE7,
  0x71, 0xFC, 0x0E, 0x60, 0x5F, 0xD7, 0x70, 0x1F, 0xC0, 0xE6, 0x04, 0xFD, 0x02, 0x76, 0x03, 0xFC,
  0x0E, 0x60, 0x2F, 0xD0, 0x47, 0x60, 0x5F, 0xC0, 0xE7, 0xFD, 0x07, 0x76, 0x07, 0xFC, 0x0E, 0x70,
  0xDF, 0xC0, 0xB7, 0x60, 0xBF, 0xC0, 0xE7, 0x0A, 0xFC, 0x0E, 0x76, 0xFD, 0x0E, 0x70, 0x7F, 0xD0,
  0x57, 0x40, 0x6F, 0xD0, 0xE7, 0x03, 0xFD, 0x0C, 0x74, 0x0C, 0xFD, 0x0E, 0x71, 0x0E, 0xFD, 0x07,
  0x72, 0x08, 0xFE, 0x0E, 0x71, 0x0A, 0xFE, 0x07, 0x70, 0x8F, 0xF0, 0xE7, 0x10, 0x4F, 0xF8, 0x5C,
  0x63, 0x34, 0x8D, 0xFF, 0x90, 0xE7, 0x20, 0xDF, 0xFF, 0xFF, 0x0E, 0x72, 0x07, 0xFF, 0xFF, 0xF0,
  0xE7, 0x30, 0xDF, 0xFF, 0xFE, 0x0E, 0x73, 0x05, 0xFF, 0xF9, 0x00, 0xBF, 0xB0, 0xE7, 0x40, 0x9F,
  0xFE, 0x81, 0xD1, 0x4F, 0xB0, 0xE7, 0x50, 0xCF, 0xFC, 0x0E, 0x03, 0x20, 0xEF, 0xA0, 0xE7, 0x50,
  0x10, 0xCF, 0xFA, 0x0E, 0x03, 0x30, 0x9F, 0xA0, 0xE7, 0x70, 0x9F, 0xF0, 0xD0, 0x34, 0x03, 0xFA,
  0x0E, 0x77, 0x10, 0x40, 0xCF, 0xC0, 0x80, 0x16, 0x0D, 0xF9, 0x0E, 0x77, 0x38, 0x91, 0x37, 0xBD,
  0xEF, 0xED, 0xA6, 0x17, 0x77, 0x30,
  // "Ē" (U+0112)
  0x20, 0x6F, 0xFF, 0xC0, 0xD5, 0x06, 0xFF, 0xFC, 0x0D, 0x50, 0x6F, 0xFF, 0xC0, 0xD5, 0x06, 0xFF,
  0xFC, 0x0D, 0x50, 0x6F, 0xFF, 0xC0, 0xD5, 0x06, 0xFF, 0xFC, 0x0D, 0x50, 0x6F, 0xFF, 0xC0, 0xD5,
  0x06, 0xFF, 0xFC, 0x0D, 0x50, 0x6F, 0xFF, 0xC0, 0xD8, 0x0A, 0xF7, 0x00, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xD0, 0x48, 0x09, 0x52, 0x01, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x04, 0x80, 0x94, 0x28, 0x11, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08,
  0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF,
  0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFF, 0xFF,
  0x98, 0x17, 0x08, 0xFF, 0xFF, 0x98, 0x17, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F,
  0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  // "ē" (U+0113)
  0x60, 0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD7, 0x50,
  0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F,
  0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD7, 0x50, 0x6F, 0xFF, 0xC0, 0xD8, 0x0B, 0xA3, 0x08,
  0x34, 0x8B, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x73, 0x03, 0x0A, 0xFE, 0x81, 0xE9, 0x27, 0x75,
  0x02, 0x0A, 0xFF, 0xC0, 0x97, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xD0, 0x37, 0x70, 0x7F, 0xFF, 0xA0,
  0xE0, 0x47, 0x50, 0x7F, 0xFF, 0xD0, 0x37, 0x30, 0x5F, 0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x10, 0xEF,
  0xFF, 0xF0, 0xB7, 0x10, 0xAF, 0xFF, 0xFA, 0x05, 0x60, 0x3F, 0xE8, 0x58, 0x31, 0x02, 0x7E, 0xFC,
  0x0D, 0x60, 0xBF, 0xC0, 0xD0, 0x26, 0x01, 0x0C, 0xFC, 0x05, 0x40, 0x2F, 0xC0, 0xE0, 0x27, 0x10,
  0x10, 0xEF, 0xB0, 0xC4, 0x08, 0xFC, 0x06, 0x73, 0x06, 0xFC, 0x02, 0x30, 0xDF, 0xB0, 0xE7, 0x50,
  0xEF, 0xB0, 0x72, 0x02, 0xFC, 0x08, 0x75, 0x09, 0xFB, 0x0B, 0x20, 0x6F, 0xC0, 0x47, 0x50, 0x4F,
  0xB0, 0xE2, 0x09, 0xFC, 0x01, 0x75, 0x02, 0xFC, 0x81, 0x10, 0xCF, 0xB0, 0xE7, 0x7F, 0xC8, 0x14,
  0x0E, 0xFB, 0x0D, 0x77, 0x0E, 0xFB, 0x05, 0x01, 0xFC, 0x0C, 0x77, 0x0D, 0xFB, 0x07, 0x03, 0x80,
  0xC1, 0xF0, 0x80, 0x48, 0x0C, 0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F, 0x09,
  0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C,
  0x1F, 0x09, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x5F, 0xC0, 0xA7, 0x77, 0x50, 0x3F, 0xC0, 0xB7, 0x77,
  0x50, 0x2F, 0xC0, 0xD7, 0x77, 0x6F, 0xD7, 0x77, 0x60, 0xDF, 0xC0, 0x37, 0x77, 0x50, 0x9F, 0xC0,
  0x77, 0x77, 0x50, 0x6F, 0xC0, 0xD7, 0x77, 0x50, 0x2F, 0xD0, 0x57, 0x77, 0x50, 0xCF, 0xC0, 0xE0,
  0x17, 0x75, 0x03, 0x01, 0x40, 0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x82, 0x4B, 0xF2, 0x40, 0x1F, 0xE0,
  0xE0, 0x67, 0x58, 0x12, 0x7D, 0xB0, 0x25, 0x0A, 0xFF, 0x89, 0x2D, 0x95, 0x42, 0x33, 0x45, 0x8B,
  0xEE, 0x02, 0x50, 0x2F, 0xFF, 0xFC, 0x02, 0x60, 0x8F, 0xFF, 0xFB, 0x02, 0x70, 0xDF, 0xFF, 0xFA,
  0x02, 0x70, 0x20, 0xEF, 0xFF, 0xF9, 0x02, 0x71, 0x04, 0xFF, 0xFF, 0x90, 0x27, 0x20, 0x40, 0xEF,
  0xFF, 0xE0, 0x27, 0x30, 0x20, 0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x60, 0xEF, 0xFF, 0x0C, 0x05,
  0x77, 0x20, 0x60, 0xBF, 0xFA, 0x81, 0xD8, 0x37, 0x76, 0x89, 0x61, 0x58, 0xBD, 0xEE, 0xFE, 0xED,
  0xCA, 0x75, 0x27, 0x20,
  // "Ĕ" (U+0114)
  0x10, 0x38, 0x02, 0x70, 0x67, 0x78, 0x03, 0x70, 0x12, 0x04, 0xE0, 0xE7, 0x60, 0x3F, 0x01, 0x20,
  0x3F, 0x03, 0x75, 0x07, 0xF3, 0x01, 0xF0, 0xB7, 0x40, 0x10, 0xEE, 0x0D, 0x40, 0xEF, 0x08, 0x72,
  0x02, 0x0C, 0xF0, 0x94, 0x0A, 0xF9, 0x82, 0xD7, 0x31, 0x28, 0x12, 0x59, 0xFA, 0x05, 0x40, 0x5F,
  0xFF, 0xC0, 0xE0, 0x15, 0x0D, 0xFF, 0xFB, 0x08, 0x60, 0x6F, 0xFF, 0xA0, 0xE7, 0x10, 0xCF, 0xFF,
  0x90, 0x47, 0x10, 0x20, 0xEF, 0xFE, 0x06, 0x73, 0x03, 0x0E, 0xFF, 0xC0, 0x67, 0x50, 0x10, 0xCF,
  0xF9, 0x0D, 0x03, 0x77, 0x10, 0x50, 0xCF, 0xC0, 0xE0, 0x67, 0x75, 0x89, 0x13, 0x7B, 0xCE, 0xFE,
  0xDB, 0x83, 0x80, 0xB8, 0x70, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF,
  0xFA, 0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F,
  0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF,
  0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "ĕ" (U+0115)
  0x50, 0x38, 0x02, 0x70, 0x67, 0x78, 0x03, 0x70, 0x17, 0x20, 0x4E, 0x0E, 0x76, 0x03, 0xF0, 0x17,
  0x20, 0x3F, 0x03, 0x75, 0x07, 0xF7, 0x30, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x40, 0xEF,
  0x08, 0x72, 0x02, 0x0C, 0xF0, 0x97, 0x40, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0,
  0x57, 0x40, 0x5F, 0xFF, 0xC0, 0xE0, 0x17, 0x50, 0xDF, 0xFF, 0xB0, 0x87, 0x60, 0x6F, 0xFF, 0xA0,
  0xE7, 0x71, 0x0C, 0xFF, 0xF9, 0x04, 0x77, 0x10, 0x20, 0xEF, 0xFE, 0x06, 0x77, 0x30, 0x30, 0xEF,
  0xFC, 0x06, 0x77, 0x50, 0x10, 0xCF, 0xF9, 0x0D, 0x03, 0x77, 0x71, 0x05, 0x0C, 0xFC, 0x0E, 0x06,
  0x77, 0x75, 0x89, 0x13, 0x7B, 0xCE, 0xFE, 0xDB, 0x83, 0x80, 0xBB, 0x30, 0x83, 0x48, 0xBD, 0xEA,
  0x83, 0xED, 0xB8, 0x47, 0x77, 0x30, 0x30, 0xAF, 0xE8, 0x1E, 0x92, 0x77, 0x50, 0x20, 0xAF, 0xFC,
  0x09, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x0D, 0x03, 0x77, 0x07, 0xFF, 0xFA, 0x0E, 0x04, 0x75, 0x07,
  0xFF, 0xFD, 0x03, 0x73, 0x05, 0xFF, 0xFE, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0x0B, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0x56, 0x03, 0xFE, 0x85, 0x83, 0x10, 0x27, 0xEF, 0xC0, 0xD6, 0x0B, 0xFC,
  0x0D, 0x02, 0x60, 0x10, 0xCF, 0xC0, 0x54, 0x02, 0xFC, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xFB, 0x0C,
  0x40, 0x8F, 0xC0, 0x67, 0x30, 0x6F, 0xC0, 0x23, 0x0D, 0xFB, 0x0E, 0x75, 0x0E, 0xFB, 0x07, 0x20,
  0x2F, 0xC0, 0x87, 0x50, 0x9F, 0xB0, 0xB2, 0x06, 0xFC, 0x04, 0x75, 0x04, 0xFB, 0x0E, 0x20, 0x9F,
  0xC0, 0x17, 0x50, 0x2F, 0xC8, 0x11, 0x0C, 0xFB, 0x0E, 0x77, 0xFC, 0x81, 0x40, 0xEF, 0xB0, 0xD7,
  0x70, 0xEF, 0xB0, 0x50, 0x1F, 0xC0, 0xC7, 0x70, 0xDF, 0xB0, 0x70, 0x38, 0x0C, 0x1F, 0x08, 0x04,
  0x80, 0xC1, 0xF0, 0x80, 0x58, 0x0C, 0x1F, 0x08, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F,
  0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x68,
  0x0C, 0x1F, 0x09, 0x05, 0xFC, 0x0A, 0x77, 0x75, 0x03, 0xFC, 0x0B, 0x77, 0x75, 0x02, 0xFC, 0x0D,
  0x77, 0x76, 0xFD, 0x77, 0x76, 0x0D, 0xFC, 0x03, 0x77, 0x75, 0x09, 0xFC, 0x07, 0x77, 0x75, 0x06,
  0xFC, 0x0D, 0x77, 0x75, 0x02, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFC, 0x0E, 0x01, 0x77, 0x50, 0x30,
  0x14, 0x07, 0xFD, 0x0D, 0x01, 0x77, 0x28, 0x24, 0xBF, 0x24, 0x01, 0xFE, 0x0E, 0x06, 0x75, 0x81,
  0x27, 0xDB, 0x02, 0x50, 0xAF, 0xF8, 0x92, 0xD9, 0x54, 0x23, 0x34, 0x58, 0xBE, 0xE0, 0x25, 0x02,
  0xFF, 0xFF, 0xC0, 0x26, 0x08, 0xFF, 0xFF, 0xB0, 0x27, 0x0D, 0xFF, 0xFF, 0xA0, 0x27, 0x02, 0x0E,
  0xFF, 0xFF, 0x90, 0x27, 0x10, 0x4F, 0xFF, 0xF9, 0x02, 0x72, 0x04, 0x0E, 0xFF, 0xFE, 0x02, 0x73,
  0x02, 0x0C, 0xFF, 0xFC, 0x0C, 0x01, 0x75, 0x06, 0x0E, 0xFF, 0xF0, 0xC0, 0x57, 0x72, 0x06, 0x0B,
  0xFF, 0xA8, 0x1D, 0x83, 0x77, 0x68, 0x96, 0x15, 0x8B, 0xDE, 0xEF, 0xEE, 0xDC, 0xA7, 0x52, 0x72,
  // "Ė" (U+0116)
  0x76, 0x86, 0x39, 0xDE, 0xFE, 0xB6, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x02, 0x77, 0x60, 0x6F, 0xB0,
  0xD7, 0x76, 0x0E, 0xFC, 0x06, 0x77, 0x40, 0x3F, 0xD0, 0xA7, 0x74, 0x05, 0xFD, 0x0D, 0x77, 0x40,
  0x6F, 0xD0, 0xE7, 0x74, 0x05, 0xFD, 0x0D, 0x77, 0x40, 0x2F, 0xD0, 0xA7, 0x75, 0x0D, 0xFC, 0x06,
  0x77, 0x50, 0x5F, 0xB0, 0xC7, 0x77, 0x07, 0xF9, 0x0C, 0x01, 0x77, 0x71, 0x86, 0x28, 0xCE, 0xFE,
  0xB5, 0x80, 0xB8, 0x70, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA,
  0x0C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F, 0xFF,
  0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "ė" (U+0117)
  0x77, 0x38, 0x63, 0x9D, 0xEF, 0xEB, 0x67, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x02, 0x77, 0x76, 0x06,
  0xFB, 0x0D, 0x77, 0x76, 0x0E, 0xFC, 0x06, 0x77, 0x74, 0x03, 0xFD, 0x0A, 0x77, 0x74, 0x05, 0xFD,
  0x0D, 0x77, 0x74, 0x06, 0xFD, 0x0E, 0x77, 0x74, 0x05, 0xFD, 0x0D, 0x77, 0x74, 0x02, 0xFD, 0x0A,
  0x77, 0x75, 0x0D, 0xFC, 0x06, 0x77, 0x75, 0x05, 0xFB, 0x0C, 0x77, 0x77, 0x07, 0xF9, 0x0C, 0x01,
  0x77, 0x77, 0x18, 0x62, 0x8C, 0xEF, 0xEB, 0x58, 0x0B, 0xB3, 0x08, 0x34, 0x8B, 0xDE, 0xA8, 0x3E,
  0xDB, 0x84, 0x77, 0x73, 0x03, 0x0A, 0xFE, 0x81, 0xE9, 0x27, 0x75, 0x02, 0x0A, 0xFF, 0xC0, 0x97,
  0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xD0, 0x37, 0x70, 0x7F, 0xFF, 0xA0, 0xE0, 0x47, 0x50, 0x7F, 0xFF,
  0xD0, 0x37, 0x30, 0x5F, 0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0xB7, 0x10, 0xAF,
  0xFF, 0xFA, 0x05, 0x60, 0x3F, 0xE8, 0x58, 0x31, 0x02, 0x7E, 0xFC, 0x0D, 0x60, 0xBF, 0xC0, 0xD0,
  0x26, 0x01, 0x0C, 0xFC, 0x05, 0x40, 0x2F, 0xC0, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0xB0, 0xC4, 0x08,
  0xFC, 0x06, 0x73, 0x06, 0xFC, 0x02, 0x30, 0xDF, 0xB0, 0xE7, 0x50, 0xEF, 0xB0, 0x72, 0x02, 0xFC,
  0x08, 0x75, 0x09, 0xFB, 0x0B, 0x20, 0x6F, 0xC0, 0x47, 0x50, 0x4F, 0xB0, 0xE2, 0x09, 0xFC, 0x01,
  0x75, 0x02, 0xFC, 0x81, 0x10, 0xCF, 0xB0, 0xE7, 0x7F, 0xC8, 0x14, 0x0E, 0xFB, 0x0D, 0x77, 0x0E,
  0xFB, 0x05, 0x01, 0xFC, 0x0C, 0x77, 0x0D, 0xFB, 0x07, 0x03, 0x80, 0xC1, 0xF0, 0x80, 0x48, 0x0C,
  0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90,
  0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F, 0x09, 0x06, 0x80, 0xC1,
  0xF0, 0x90, 0x5F, 0xC0, 0xA7, 0x77, 0x50, 0x3F, 0xC0, 0xB7, 0x77, 0x50, 0x2F, 0xC0, 0xD7, 0x77,
  0x6F, 0xD7, 0x77, 0x60, 0xDF, 0xC0, 0x37, 0x77, 0x50, 0x9F, 0xC0, 0x77, 0x77, 0x50, 0x6F, 0xC0,
  0xD7, 0x77, 0x50, 0x2F, 0xD0, 0x57, 0x77, 0x50, 0xCF, 0xC0, 0xE0, 0x17, 0x75, 0x03, 0x01, 0x40,
  0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x82, 0x4B, 0xF2, 0x40, 0x1F, 0xE0, 0xE0, 0x67, 0x58, 0x12, 0x7D,
  0xB0, 0x25, 0x0A, 0xFF, 0x89, 0x2D, 0x95, 0x42, 0x33, 0x45, 0x8B, 0xEE, 0x02, 0x50, 0x2F, 0xFF,
  0xFC, 0x02, 0x60, 0x8F, 0xFF, 0xFB, 0x02, 0x70, 0xDF, 0xFF, 0xFA, 0x02, 0x70, 0x20, 0xEF, 0xFF,
  0xF9, 0x02, 0x71, 0x04, 0xFF, 0xFF, 0x90, 0x27, 0x20, 0x40, 0xEF, 0xFF, 0xE0, 0x27, 0x30, 0x20,
  0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x60, 0xEF, 0xFF, 0x0C, 0x05, 0x77, 0x20, 0x60, 0xBF, 0xFA,
  0x81, 0xD8, 0x37, 0x76, 0x89, 0x61, 0x58, 0xBD, 0xEE, 0xFE, 0xED, 0xCA, 0x75, 0x27, 0x20,
  // "Ę" (U+0118)
  0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08,
  0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF,
  0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF, 0xA8, 0x1C, 0x08, 0xFF, 0xFF,
  0xA8, 0x1C, 0x08, 0xFD, 0x04, 0x80, 0x95, 0x28, 0x11, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0,
  0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50,
  0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02,
  0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08,
  0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x04, 0x80, 0x94, 0x20, 0x12, 0x08,
  0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF,
  0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF,
  0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90, 0x72, 0x08, 0xFF, 0xFF, 0x90,
  0x72, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F,
  0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77,
  0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD,
  0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75,
  0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xFF,
  0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA,
  0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81,
  0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0, 0x8F, 0xFF, 0xFA, 0x81, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x77, 0x71, 0x0B, 0xF0, 0x57, 0x77, 0x20, 0xCF, 0x06, 0x77, 0x72, 0x0A,
  0xF0, 0x87, 0x77, 0x20, 0x7F, 0x0C, 0x77, 0x72, 0x03, 0xF9, 0x02, 0x77, 0x72, 0x0C, 0xF0, 0x97,
  0x77, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x20, 0xAF, 0x0E, 0x77, 0x73, 0xF9, 0x0C, 0x77, 0x72, 0x03,
  0xF9, 0x0D, 0x77, 0x72, 0x05, 0xFA, 0x77, 0x72, 0x05, 0xFA, 0x07, 0x77, 0x71, 0x04, 0xFB, 0x85,
  0x81, 0x01, 0x49, 0x37, 0x71, 0x03, 0xFF, 0xA0, 0x37, 0x72, 0x0E, 0xFF, 0x90, 0x37, 0x72, 0x09,
  0xFF, 0x90, 0x37, 0x72, 0x02, 0xFF, 0x90, 0x37, 0x73, 0x07, 0xFF, 0x03, 0x77, 0x40, 0x8F, 0xE0,
  0x37, 0x75, 0x04, 0x0D, 0xFC, 0x03, 0x77, 0x78, 0x91, 0x48, 0xCD, 0xEF, 0xEC, 0xA6, 0x11,
  // "ę" (U+0119)
  0x77, 0x83, 0x48, 0xBD, 0xEA, 0x83, 0xED, 0xA7, 0x47, 0x77, 0x30, 0x30, 0xAF, 0xE8, 0x1E, 0x81,
  0x77, 0x50, 0x20, 0xAF, 0xFC, 0x08, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x0C, 0x02, 0x77, 0x07, 0xFF,
  0xFA, 0x0E, 0x03, 0x75, 0x07, 0xFF, 0xFC, 0x0E, 0x02, 0x73, 0x05, 0xFF, 0xFE, 0x0D, 0x72, 0x01,
  0x0E, 0xFF, 0xFF, 0x09, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0x36, 0x03, 0xFE, 0x85, 0x93, 0x10, 0x28,
  0xEF, 0xC0, 0xB6, 0x0B, 0xFC, 0x0E, 0x04, 0x60, 0x20, 0xDF, 0xC0, 0x34, 0x02, 0xFD, 0x04, 0x71,
  0x03, 0xFC, 0x0A, 0x40, 0x8F, 0xC0, 0x97, 0x30, 0x8F, 0xB0, 0xE4, 0x0D, 0xFC, 0x01, 0x73, 0x01,
  0xFC, 0x05, 0x20, 0x2F, 0xC0, 0xB7, 0x50, 0xBF, 0xB0, 0x92, 0x06, 0xFC, 0x06, 0x75, 0x07, 0xFB,
  0x0C, 0x20, 0x9F, 0xC0, 0x37, 0x50, 0x3F, 0xC2, 0x0C, 0xFC, 0x76, 0x01, 0xFC, 0x81, 0x20, 0xEF,
  0xB0, 0xE7, 0x70, 0xEF, 0xB0, 0x40, 0x1F, 0xC0, 0xD7, 0x70, 0xEF, 0xB0, 0x60, 0x3F, 0xC0, 0xC7,
  0x70, 0xDF, 0xB0, 0x70, 0x48, 0x0C, 0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F,
  0x08, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68,
  0x0C, 0x1F, 0x09, 0x06, 0x80, 0xC1, 0xF0, 0x90, 0x58, 0x0C, 0x1F, 0x09, 0x03, 0xFC, 0x0A, 0x77,
  0x75, 0x02, 0xFC, 0x0C, 0x77, 0x76, 0xFC, 0x0D, 0x77, 0x76, 0x0D, 0xFC, 0x01, 0x77, 0x75, 0x09,
  0xFC, 0x04, 0x77, 0x75, 0x06, 0xFC, 0x0A, 0x77, 0x75, 0x02, 0xFD, 0x02, 0x77, 0x75, 0x0C, 0xFC,
  0x0C, 0x77, 0x75, 0x07, 0xFD, 0x0A, 0x77, 0x38, 0x21, 0x8E, 0x24, 0x01, 0xFE, 0x0C, 0x04, 0x75,
  0x81, 0x16, 0xBB, 0x02, 0x50, 0xAF, 0xF8, 0x92, 0xD8, 0x53, 0x22, 0x34, 0x58, 0xAD, 0xE0, 0x25,
  0x02, 0xFF, 0xFF, 0xC0, 0x26, 0x08, 0xFF, 0xFF, 0xB0, 0x27, 0x0D, 0xFF, 0xFF, 0xA0, 0x27, 0x02,
  0x0E, 0xFF, 0xFF, 0x90, 0x27, 0x10, 0x4F, 0xFF, 0xF9, 0x02, 0x72, 0x04, 0x0E, 0xFF, 0xFE, 0x02,
  0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0E, 0x01, 0x75, 0x06, 0x0E, 0xFF, 0xF9, 0x0E, 0x03, 0x77, 0x10,
  0x60, 0xBF, 0xFD, 0x0E, 0x03, 0x77, 0x48, 0x92, 0x15, 0x8B, 0xDE, 0xEF, 0xEE, 0xDE, 0xF0, 0x47,
  0x77, 0x71, 0x05, 0xF0, 0x67, 0x77, 0x71, 0x06, 0xF0, 0xA7, 0x77, 0x71, 0x04, 0xF0, 0xD7, 0x77,
  0x71, 0x02, 0x0E, 0xF0, 0x47, 0x77, 0x71, 0x0B, 0xF0, 0xB7, 0x77, 0x71, 0x04, 0xF9, 0x04, 0x77,
  0x77, 0x10, 0xBF, 0x0E, 0x77, 0x77, 0x10, 0x1F, 0x90, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x77,
  0x77, 0x10, 0x8F, 0x90, 0x67, 0x77, 0x71, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x10, 0xAF, 0x90, 0xE0,
  0x17, 0x77, 0x70, 0x9F, 0xA8, 0x5C, 0x41, 0x02, 0x49, 0x77, 0x71, 0x06, 0xFF, 0xA0, 0x17, 0x77,
  0x03, 0xFF, 0xA0, 0x17, 0x77, 0x10, 0xDF, 0xF9, 0x01, 0x77, 0x71, 0x06, 0xFF, 0x90, 0x17, 0x77,
  0x20, 0xBF, 0xF0, 0x17, 0x77, 0x20, 0x10, 0xCF, 0xE0, 0x17, 0x77, 0x40, 0x80, 0xEF, 0xC0, 0x17,
  0x77, 0x58, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xCA, 0x73, 0x30,
  // "Ě" (U+011A)
  0x03, 0x80, 0x37, 0x04, 0x77, 0x03, 0x80, 0x37, 0x03, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x81,
  0x70, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x3D, 0x10, 0x1E, 0xF9, 0x09, 0x71, 0x0A, 0xF9, 0x0E,
  0x02, 0x30, 0x3F, 0xA0, 0x96, 0x0B, 0xFA, 0x05, 0x50, 0x7F, 0xA0, 0xA4, 0x0B, 0xFA, 0x09, 0x70,
  0xBF, 0xA0, 0x92, 0x0A, 0xFA, 0x0C, 0x71, 0x01, 0x0E, 0xFA, 0x00, 0x8F, 0xA0, 0xE0, 0x27, 0x20,
  0x4F, 0xFE, 0x06, 0x74, 0x09, 0xFF, 0xC0, 0xA7, 0x60, 0xDF, 0xFA, 0x0D, 0x01, 0x76, 0x03, 0xFF,
  0xA0, 0x57, 0x71, 0x08, 0xFF, 0x0A, 0x77, 0x30, 0xDF, 0xD0, 0xE0, 0x17, 0x73, 0x05, 0xFD, 0x07,
  0x80, 0xAC, 0x50, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0,
  0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF,
  0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C,
  0x08, 0xFD, 0x04, 0x80, 0x95, 0x20, 0x10, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40,
  0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02,
  0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08,
  0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27,
  0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x48, 0x09, 0x42, 0x81, 0x10, 0x8F, 0xFF, 0xF9,
  0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81,
  0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70,
  0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F, 0xFF, 0xF9, 0x81, 0x70, 0x8F,
  0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77,
  0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD,
  0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74,
  0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0,
  0x27, 0x74, 0x08, 0xFD, 0x02, 0x77, 0x40, 0x8F, 0xD0, 0x27, 0x74, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF,
  0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08,
  0xFF, 0xFF, 0xA0, 0xC0, 0x8F, 0xFF, 0xFA, 0x0C, 0x08, 0xFF, 0xFF, 0xA0, 0xC0,
  // "ě" (U+011B)
  0x40, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x37, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x07, 0x71, 0x0C, 0xF9, 0x07, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x71, 0x01, 0x0E, 0xF9, 0x09, 0x71,
  0x0A, 0xF9, 0x0E, 0x02, 0x73, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x50, 0x7F, 0xA0, 0xA4,
  0x0B, 0xFA, 0x09, 0x77, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7, 0x71, 0x01, 0x0E, 0xFA, 0x00,
  0x8F, 0xA0, 0xE0, 0x27, 0x72, 0x04, 0xFF, 0xE0, 0x67, 0x74, 0x09, 0xFF, 0xC0, 0xA7, 0x76, 0x0D,
  0xFF, 0xA0, 0xD0, 0x17, 0x76, 0x03, 0xFF, 0xA0, 0x57, 0x77, 0x10, 0x8F, 0xF0, 0xA7, 0x77, 0x30,
  0xDF, 0xD0, 0xE0, 0x17, 0x77, 0x30, 0x5F, 0xD0, 0x78, 0x0A, 0xE2, 0x08, 0x34, 0x8B, 0xDE, 0xA8,
  0x3E, 0xDB, 0x84, 0x77, 0x73, 0x03, 0x0A, 0xFE, 0x81, 0xE9, 0x27, 0x75, 0x02, 0x0A, 0xFF, 0xC0,
  0x97, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xD0, 0x37, 0x70, 0x7F, 0xFF, 0xA0, 0xE0, 0x47, 0x50, 0x7F,
  0xFF, 0xD0, 0x37, 0x30, 0x5F, 0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0xB7, 0x10,
  0xAF, 0xFF, 0xFA, 0x05, 0x60, 0x3F, 0xE8, 0x58, 0x31, 0x02, 0x7E, 0xFC, 0x0D, 0x60, 0xBF, 0xC0,
  0xD0, 0x26, 0x01, 0x0C, 0xFC, 0x05, 0x40, 0x2F, 0xC0, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0xB0, 0xC4,
  0x08, 0xFC, 0x06, 0x73, 0x06, 0xFC, 0x02, 0x30, 0xDF, 0xB0, 0xE7, 0x50, 0xEF, 0xB0, 0x72, 0x02,
  0xFC, 0x08, 0x75, 0x09, 0xFB, 0x0B, 0x20, 0x6F, 0xC0, 0x47, 0x50, 0x4F, 0xB0, 0xE2, 0x09, 0xFC,
  0x01, 0x75, 0x02, 0xFC, 0x81, 0x10, 0xCF, 0xB0, 0xE7, 0x7F, 0xC8, 0x14, 0x0E, 0xFB, 0x0D, 0x77,
  0x0E, 0xFB, 0x05, 0x01, 0xFC, 0x0C, 0x77, 0x0D, 0xFB, 0x07, 0x03, 0x80, 0xC1, 0xF0, 0x80, 0x48,
  0x0C, 0x1F, 0x08, 0x05, 0x80, 0xC1, 0xF0, 0x80, 0x68, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0,
  0x90, 0x78, 0x0C, 0x1F, 0x09, 0x07, 0x80, 0xC1, 0xF0, 0x90, 0x68, 0x0C, 0x1F, 0x09, 0x06, 0x80,
  0xC1, 0xF0, 0x90, 0x5F, 0xC0, 0xA7, 0x77, 0x50, 0x3F, 0xC0, 0xB7, 0x77, 0x50, 0x2F, 0xC0, 0xD7,
  0x77, 0x6F, 0xD7, 0x77, 0x60, 0xDF, 0xC0, 0x37, 0x77, 0x50, 0x9F, 0xC0, 0x77, 0x77, 0x50, 0x6F,
  0xC0, 0xD7, 0x77, 0x50, 0x2F, 0xD0, 0x57, 0x77, 0x50, 0xCF, 0xC0, 0xE0, 0x17, 0x75, 0x03, 0x01,
  0x40, 0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x82, 0x4B, 0xF2, 0x40, 0x1F, 0xE0, 0xE0, 0x67, 0x58, 0x12,
  0x7D, 0xB0, 0x25, 0x0A, 0xFF, 0x89, 0x2D, 0x95, 0x42, 0x33, 0x45, 0x8B, 0xEE, 0x02, 0x50, 0x2F,
  0xFF, 0xFC, 0x02, 0x60, 0x8F, 0xFF, 0xFB, 0x02, 0x70, 0xDF, 0xFF, 0xFA, 0x02, 0x70, 0x20, 0xEF,
  0xFF, 0xF9, 0x02, 0x71, 0x04, 0xFF, 0xFF, 0x90, 0x27, 0x20, 0x40, 0xEF, 0xFF, 0xE0, 0x27, 0x30,
  0x20, 0xCF, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x60, 0xEF, 0xFF, 0x0C, 0x05, 0x77, 0x20, 0x60, 0xBF,
  0xFA, 0x81, 0xD8, 0x37, 0x76, 0x89, 0x61, 0x58, 0xBD, 0xEE, 0xFE, 0xED, 0xCA, 0x75, 0x27, 0x20,
  // "Ĝ" (U+011C)
  0x77, 0x60, 0x18, 0x09, 0x07, 0x02, 0x77, 0x77, 0x50, 0x9F, 0xD0, 0xB7, 0x77, 0x74, 0x03, 0xFF,
  0x04, 0x77, 0x77, 0x30, 0xCF, 0xF0, 0xD7, 0x77, 0x72, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x70, 0x3F,
  0xFC, 0x03, 0x77, 0x76, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x50, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77,
  0x73, 0x04, 0xFA, 0x81, 0xE3, 0x3F, 0xB0, 0x57, 0x77, 0x10, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA,
  0x0E, 0x02, 0x77, 0x70, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x77, 0x60, 0x8F, 0xA0, 0x46, 0x04,
  0xFA, 0x09, 0x77, 0x40, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x72, 0x02, 0x0E,
  0xF0, 0xE0, 0x37, 0x30, 0x20, 0xDF, 0x90, 0x37, 0x71, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xBA, 0x10, 0x85, 0x36, 0x9B, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x86, 0x37, 0x77, 0x70,
  0x50, 0xBF, 0xFC, 0x81, 0xB7, 0x27, 0x77, 0x02, 0x0A, 0xFF, 0xFB, 0x81, 0xD7, 0x17, 0x72, 0x01,
  0x09, 0xFF, 0xFF, 0x90, 0xA0, 0x37, 0x60, 0x6F, 0xFF, 0xFC, 0x06, 0x75, 0x0A, 0xFF, 0xFF, 0xD0,
  0x17, 0x30, 0x10, 0xDF, 0xFF, 0xFD, 0x0A, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0x47, 0x20, 0x10,
  0xDF, 0xFF, 0xFE, 0x0D, 0x73, 0x0B, 0xFF, 0xFF, 0xF0, 0x87, 0x20, 0x7F, 0xFB, 0x89, 0x1D, 0x85,
  0x32, 0x23, 0x46, 0x9C, 0xF9, 0x02, 0x71, 0x03, 0xFF, 0xA0, 0x90, 0x27, 0x48, 0x11, 0x7D, 0xC0,
  0xB7, 0x20, 0xCF, 0xF0, 0xD0, 0x37, 0x72, 0x03, 0x0B, 0xA0, 0x67, 0x10, 0x5F, 0xF0, 0xB7, 0x76,
  0x04, 0x0C, 0x72, 0x0D, 0xFE, 0x0B, 0x77, 0x77, 0x30, 0x6F, 0xE0, 0xD0, 0x17, 0x77, 0x73, 0x0C,
  0xFE, 0x04, 0x77, 0x77, 0x30, 0x2F, 0xE0, 0xA7, 0x77, 0x74, 0x08, 0xFE, 0x02, 0x77, 0x77, 0x40,
  0xDF, 0xD0, 0xA7, 0x77, 0x74, 0x02, 0xFE, 0x04, 0x77, 0x77, 0x40, 0x5F, 0xD0, 0xE7, 0x77, 0x75,
  0x09, 0xFD, 0x0A, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0x67, 0x77, 0x75, 0xFE, 0x03, 0x77, 0x77, 0x40,
  0x2F, 0xE7, 0x77, 0x75, 0x04, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0x07,
  0xFD, 0x0A, 0x77, 0x77, 0x50, 0x8F, 0xD0, 0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x07, 0x73,
  0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04, 0x0A, 0xFD, 0x07, 0x73, 0x05,
  0xFF, 0xF0, 0x40, 0xAF, 0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x08, 0x73, 0x05, 0xFF,
  0xF0, 0x40, 0x9F, 0xD0, 0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x09, 0x73, 0x05, 0xFF, 0xF0,
  0x40, 0x7F, 0xD0, 0xA7, 0x30, 0x5F, 0xFF, 0x04, 0x06, 0xFD, 0x0C, 0x73, 0x05, 0xFF, 0xF0, 0x40,
  0x5F, 0xD0, 0xE7, 0x48, 0x04, 0x20, 0x3F, 0xD0, 0x40, 0x3F, 0xE0, 0x17, 0x74, 0x01, 0xFD, 0x04,
  0x01, 0xFE, 0x03, 0x77, 0x40, 0x1F, 0xD8, 0x14, 0x0E, 0xFD, 0x06, 0x77, 0x40, 0x1F, 0xD8, 0x14,
  0x0B, 0xFD, 0x0A, 0x77, 0x40, 0x1F, 0xD8, 0x14, 0x08, 0xFD, 0x0E, 0x77, 0x40, 0x1F, 0xD8, 0x14,
  0x05, 0xFE, 0x03, 0x77, 0x30, 0x1F, 0xD8, 0x14, 0x01, 0xFE, 0x09, 0x77, 0x30, 0x1F, 0xD0, 0x42,
  0x0C, 0xFE, 0x01, 0x77, 0x20, 0x1F, 0xD0, 0x42, 0x07, 0xFE, 0x07, 0x77, 0x20, 0x1F, 0xD0, 0x42,
  0x02, 0xFE, 0x0E, 0x01, 0x77, 0x10, 0x1F, 0xD0, 0x43, 0x0B, 0xFE, 0x09, 0x77, 0x10, 0x1F, 0xD0,
  0x43, 0x05, 0xFF, 0x06, 0x77, 0x01, 0xFD, 0x04, 0x40, 0xDF, 0xF0, 0x77, 0x60, 0x1F, 0xD0, 0x44,
  0x06, 0xFF, 0x90, 0xB0, 0x27, 0x40, 0x1F, 0xD0, 0x45, 0x0D, 0xFF, 0xA8, 0x2B, 0x63, 0x13, 0x83,
  0x23, 0x7A, 0xEF, 0xD0, 0x45, 0x03, 0x80, 0xC4, 0xF0, 0x46, 0x09, 0x80, 0xC3, 0xF0, 0x47, 0x0C,
  0x80, 0xC2, 0xF0, 0x47, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0x30, 0xE8, 0x0C, 0x0F, 0x04,
  0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xF0, 0x47, 0x30, 0x10, 0xBF, 0xFF, 0xFE, 0x04, 0x75, 0x06, 0x0E,
  0xFF, 0xFF, 0xA8, 0x1E, 0xA2, 0x76, 0x81, 0x18, 0xEF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x50, 0x60,
  0xBF, 0xFD, 0x82, 0xDA, 0x63, 0x77, 0x74, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x90, 0xEE, 0xDC, 0xBA,
  0x85, 0x31, 0x73,
  // "ĝ" (U+011D)
  0x77, 0x10, 0x18, 0x09, 0x07, 0x02, 0x77, 0x75, 0x09, 0xFD, 0x0B, 0x77, 0x74, 0x03, 0xFF, 0x04,
  0x77, 0x73, 0x0C, 0xFF, 0x0D, 0x77, 0x72, 0x07, 0xFF, 0xA0, 0x87, 0x77, 0x03, 0xFF, 0xC0, 0x37,
  0x76, 0x0D, 0xFF, 0xC0, 0xD7, 0x75, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x73, 0x04, 0xFA, 0x81,
  0xE3, 0x3F, 0xB0, 0x57, 0x71, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x70, 0xBF,
  0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x76, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x97, 0x40, 0x4F, 0x90,
  0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x20, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9,
  0x03, 0x71, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF, 0x07, 0x80, 0xAD, 0x10, 0x89, 0x12, 0x7A,
  0xDE, 0xFE, 0xDA, 0x61, 0x77, 0x76, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x50, 0x9F, 0xA0, 0xE7, 0x10,
  0x7F, 0xF0, 0xD0, 0x34, 0x0B, 0xFA, 0x0E, 0x70, 0xAF, 0xFA, 0x0E, 0x04, 0x30, 0xEF, 0xA0, 0xE6,
  0x09, 0xFF, 0xC8, 0x2E, 0x20, 0x1F, 0xB0, 0xE5, 0x06, 0xFF, 0xE8, 0x1D, 0x03, 0xFB, 0x0E, 0x40,
  0x2F, 0xFF, 0x90, 0x70, 0x6F, 0xB0, 0xE4, 0x0B, 0xFF, 0xFF, 0xE0, 0xE3, 0x04, 0xFF, 0xFF, 0xF0,
  0xE3, 0x0B, 0xFF, 0xFF, 0xF0, 0xE2, 0x02, 0xFF, 0x85, 0xD6, 0x33, 0x59, 0xEF, 0xF9, 0x0E, 0x20,
  0x7F, 0xE0, 0x86, 0x01, 0x0B, 0xFF, 0x0E, 0x20, 0xCF, 0xD0, 0xA7, 0x20, 0xBF, 0xE8, 0x1E, 0x01,
  0xFD, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xFD, 0x81, 0xE0, 0x5F, 0xD0, 0x87, 0x40, 0x7F, 0xD8, 0x1E,
  0x08, 0xFD, 0x03, 0x74, 0x01, 0xFD, 0x81, 0xE0, 0xBF, 0xC0, 0xD7, 0x60, 0xCF, 0xC8, 0x1E, 0x0E,
  0xFC, 0x0A, 0x76, 0x09, 0xFC, 0x0E, 0x1F, 0xD0, 0x77, 0x60, 0x6F, 0xC0, 0xE0, 0x2F, 0xD0, 0x57,
  0x60, 0x4F, 0xC0, 0xE0, 0x4F, 0xD0, 0x37, 0x60, 0x2F, 0xC0, 0xE0, 0x5F, 0xD0, 0x17, 0x60, 0x1F,
  0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71,
  0xFC, 0x0E, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xC0, 0xE7, 0x71, 0x0E, 0xFB,
  0x0E, 0x06, 0xFD, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x05, 0xFD, 0x01,
  0x77, 0xFC, 0x0E, 0x04, 0xFD, 0x02, 0x76, 0x01, 0xFC, 0x0E, 0x03, 0xFD, 0x04, 0x76, 0x02, 0xFC,
  0x0E, 0x01, 0xFD, 0x06, 0x76, 0x04, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0x97, 0x60, 0x7F, 0xC8, 0x1E,
  0x0C, 0xFC, 0x0D, 0x76, 0x0A, 0xFC, 0x81, 0xE0, 0x9F, 0xD0, 0x27, 0x50, 0xEF, 0xC8, 0x1E, 0x06,
  0xFD, 0x08, 0x74, 0x05, 0xFD, 0x81, 0xE0, 0x2F, 0xD0, 0xE0, 0x17, 0x30, 0xCF, 0xD0, 0xE2, 0x0E,
  0xFD, 0x0A, 0x72, 0x08, 0xFE, 0x0E, 0x20, 0x9F, 0xE0, 0x97, 0x08, 0xFF, 0x0E, 0x20, 0x3F, 0xF8,
  0x5D, 0x63, 0x24, 0x7D, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0xFF, 0xF0, 0xE3, 0x05, 0xFF, 0xFF, 0xF0,
  0xE4, 0x0D, 0xFF, 0xF9, 0x0E, 0xFC, 0x0E, 0x40, 0x4F, 0xFF, 0x90, 0x40, 0xEF, 0xB0, 0xE5, 0x09,
  0xFF, 0xE0, 0xA1, 0xFC, 0x0E, 0x60, 0xBF, 0xFC, 0x81, 0xC0, 0x1F, 0xC0, 0xE6, 0x01, 0x0C, 0xFF,
  0xA8, 0x2D, 0x10, 0x2F, 0xC0, 0xE7, 0x10, 0xAF, 0xF0, 0xB0, 0x12, 0x02, 0xFC, 0x0E, 0x72, 0x04,
  0x0C, 0xFB, 0x0D, 0x06, 0x40, 0x3F, 0xC0, 0xE7, 0x48, 0x23, 0x8B, 0xEA, 0x82, 0xEC, 0x94, 0x60,
  0x3F, 0xC0, 0xD7, 0x77, 0x60, 0x3F, 0xC0, 0xC7, 0x77, 0x60, 0x4F, 0xC0, 0xB7, 0x77, 0x60, 0x5F,
  0xC0, 0x97, 0x77, 0x60, 0x7F, 0xC0, 0x77, 0x77, 0x60, 0xAF, 0xC0, 0x57, 0x77, 0x60, 0xEF, 0xC0,
  0x27, 0x77, 0x50, 0x6F, 0xC0, 0xD4, 0x09, 0x02, 0x77, 0x60, 0x10, 0xEF, 0xC0, 0x93, 0x01, 0xA0,
  0xB0, 0x47, 0x73, 0x01, 0x0C, 0xFD, 0x04, 0x30, 0x1C, 0x82, 0xEA, 0x51, 0x75, 0x06, 0x0E, 0xFD,
  0x0D, 0x40, 0x1F, 0x98, 0x92, 0xDA, 0x75, 0x43, 0x23, 0x46, 0x9E, 0xFF, 0x07, 0x40, 0x1F, 0xFF,
  0xFD, 0x0E, 0x50, 0x1F, 0xFF, 0xFD, 0x05, 0x50, 0x1F, 0xFF, 0xFC, 0x0B, 0x60, 0x1F, 0xFF, 0xFB,
  0x0D, 0x01, 0x60, 0x1F, 0xFF, 0xFA, 0x0D, 0x02, 0x70, 0x1F, 0xFF, 0xF9, 0x0C, 0x02, 0x72, 0x0E,
  0xFF, 0xFE, 0x09, 0x75, 0x06, 0x0C, 0xFF, 0xFA, 0x0B, 0x03, 0x77, 0x18, 0x13, 0x7C, 0xFF, 0xB8,
  0x1D, 0x82, 0x77, 0x68, 0x61, 0x46, 0x9B, 0xCD, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x27, 0x70,
  // "Ğ" (U+011E)
  0x75, 0x03, 0x80, 0x27, 0x06, 0x77, 0x80, 0x37, 0x01, 0x77, 0x30, 0x4E, 0x0E, 0x76, 0x03, 0xF0,
  0x17, 0x73, 0x03, 0xF0, 0x37, 0x50, 0x7F, 0x77, 0x40, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD7,
  0x75, 0x0E, 0xF0, 0x87, 0x20, 0x20, 0xCF, 0x09, 0x77, 0x50, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81,
  0x25, 0x9F, 0xA0, 0x57, 0x75, 0x05, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x60, 0xDF, 0xFF, 0xB0, 0x87,
  0x77, 0x06, 0xFF, 0xFA, 0x0E, 0x77, 0x72, 0x0C, 0xFF, 0xF9, 0x04, 0x77, 0x72, 0x02, 0x0E, 0xFF,
  0xE0, 0x67, 0x77, 0x40, 0x30, 0xEF, 0xFC, 0x06, 0x77, 0x76, 0x01, 0x0C, 0xFF, 0x90, 0xD0, 0x37,
  0x77, 0x72, 0x05, 0x0C, 0xFC, 0x0E, 0x06, 0x77, 0x77, 0x68, 0x91, 0x37, 0xBC, 0xEF, 0xED, 0xB8,
  0x38, 0x0C, 0x93, 0x08, 0x53, 0x69, 0xBC, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x63, 0x77, 0x77, 0x05,
  0x0B, 0xFF, 0xC8, 0x1B, 0x72, 0x77, 0x70, 0x20, 0xAF, 0xFF, 0xB8, 0x1D, 0x71, 0x77, 0x20, 0x10,
  0x9F, 0xFF, 0xF9, 0x0A, 0x03, 0x76, 0x06, 0xFF, 0xFF, 0xC0, 0x67, 0x50, 0xAF, 0xFF, 0xFD, 0x01,
  0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xD0, 0xA7, 0x30, 0x10, 0xDF, 0xFF, 0xFE, 0x04, 0x72, 0x01, 0x0D,
  0xFF, 0xFF, 0xE0, 0xD7, 0x30, 0xBF, 0xFF, 0xFF, 0x08, 0x72, 0x07, 0xFF, 0xB8, 0x91, 0xD8, 0x53,
  0x22, 0x34, 0x69, 0xCF, 0x90, 0x27, 0x10, 0x3F, 0xFA, 0x09, 0x02, 0x74, 0x81, 0x17, 0xDC, 0x0B,
  0x72, 0x0C, 0xFF, 0x0D, 0x03, 0x77, 0x20, 0x30, 0xBA, 0x06, 0x71, 0x05, 0xFF, 0x0B, 0x77, 0x60,
  0x40, 0xC7, 0x20, 0xDF, 0xE0, 0xB7, 0x77, 0x73, 0x06, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x30, 0xCF,
  0xE0, 0x47, 0x77, 0x73, 0x02, 0xFE, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0xE0, 0x27, 0x77, 0x74, 0x0D,
  0xFD, 0x0A, 0x77, 0x77, 0x40, 0x2F, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x50,
  0x9F, 0xD0, 0xA7, 0x77, 0x75, 0x0D, 0xFD, 0x06, 0x77, 0x77, 0x5F, 0xE0, 0x37, 0x77, 0x74, 0x02,
  0xFE, 0x77, 0x77, 0x50, 0x4F, 0xD0, 0xD7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F,
  0xD0, 0xA7, 0x77, 0x75, 0x08, 0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x77, 0x30,
  0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0xAF, 0xD0, 0x77, 0x30, 0x5F,
  0xFF, 0x04, 0x0A, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x87, 0x30, 0x5F, 0xFF,
  0x04, 0x09, 0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x97, 0x30, 0x5F, 0xFF, 0x04,
  0x07, 0xFD, 0x0A, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x6F, 0xD0, 0xC7, 0x30, 0x5F, 0xFF, 0x04, 0x05,
  0xFD, 0x0E, 0x74, 0x80, 0x42, 0x03, 0xFD, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x40,
  0x1F, 0xE0, 0x37, 0x74, 0x01, 0xFD, 0x81, 0x40, 0xEF, 0xD0, 0x67, 0x74, 0x01, 0xFD, 0x81, 0x40,
  0xBF, 0xD0, 0xA7, 0x74, 0x01, 0xFD, 0x81, 0x40, 0x8F, 0xD0, 0xE7, 0x74, 0x01, 0xFD, 0x81, 0x40,
  0x5F, 0xE0, 0x37, 0x73, 0x01, 0xFD, 0x81, 0x40, 0x1F, 0xE0, 0x97, 0x73, 0x01, 0xFD, 0x04, 0x20,
  0xCF, 0xE0, 0x17, 0x72, 0x01, 0xFD, 0x04, 0x20, 0x7F, 0xE0, 0x77, 0x72, 0x01, 0xFD, 0x04, 0x20,
  0x2F, 0xE0, 0xE0, 0x17, 0x71, 0x01, 0xFD, 0x04, 0x30, 0xBF, 0xE0, 0x97, 0x71, 0x01, 0xFD, 0x04,
  0x30, 0x5F, 0xF0, 0x67, 0x70, 0x1F, 0xD0, 0x44, 0x0D, 0xFF, 0x07, 0x76, 0x01, 0xFD, 0x04, 0x40,
  0x6F, 0xF9, 0x0B, 0x02, 0x74, 0x01, 0xFD, 0x04, 0x50, 0xDF, 0xFA, 0x82, 0xB6, 0x31, 0x38, 0x32,
  0x37, 0xAE, 0xFD, 0x04, 0x50, 0x38, 0x0C, 0x4F, 0x04, 0x60, 0x98, 0x0C, 0x3F, 0x04, 0x70, 0xC8,
  0x0C, 0x2F, 0x04, 0x70, 0x10, 0xE8, 0x0C, 0x1F, 0x04, 0x71, 0x03, 0x0E, 0x80, 0xC0, 0xF0, 0x47,
  0x20, 0x20, 0xDF, 0xFF, 0xFF, 0x04, 0x73, 0x01, 0x0B, 0xFF, 0xFF, 0xE0, 0x47, 0x50, 0x60, 0xEF,
  0xFF, 0xFA, 0x81, 0xEA, 0x27, 0x68, 0x11, 0x8E, 0xFF, 0xFC, 0x81, 0xEA, 0x57, 0x75, 0x06, 0x0B,
  0xFF, 0xD8, 0x2D, 0xA6, 0x37, 0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x89, 0x0E, 0xED, 0xCB, 0xA8,
  0x53, 0x17, 0x30,
  // "ğ" (U+011F)
  0x70, 0x38, 0x02, 0x70, 0x67, 0x78, 0x03, 0x70, 0x17, 0x30, 0x4E, 0x0E, 0x76, 0x03, 0xF0, 0x17,
  0x30, 0x3F, 0x03, 0x75, 0x07, 0xF7, 0x40, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x50, 0xEF,
  0x08, 0x72, 0x02, 0x0C, 0xF0, 0x97, 0x50, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0,
  0x57, 0x50, 0x5F, 0xFF, 0xC0, 0xE0, 0x17, 0x60, 0xDF, 0xFF, 0xB0, 0x87, 0x70, 0x6F, 0xFF, 0xA0,
  0xE7, 0x72, 0x0C, 0xFF, 0xF9, 0x04, 0x77, 0x20, 0x20, 0xEF, 0xFE, 0x06, 0x77, 0x40, 0x30, 0xEF,
  0xFC, 0x06, 0x77, 0x60, 0x10, 0xCF, 0xF9, 0x0D, 0x03, 0x77, 0x72, 0x05, 0x0C, 0xFC, 0x0E, 0x06,
  0x77, 0x76, 0x89, 0x13, 0x7B, 0xCE, 0xFE, 0xDB, 0x83, 0x80, 0xBB, 0x40, 0x89, 0x12, 0x7A, 0xDE,
  0xFE, 0xDA, 0x61, 0x77, 0x76, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x50, 0x9F, 0xA0, 0xE7, 0x10, 0x7F,
  0xF0, 0xD0, 0x34, 0x0B, 0xFA, 0x0E, 0x70, 0xAF, 0xFA, 0x0E, 0x04, 0x30, 0xEF, 0xA0, 0xE6, 0x09,
  0xFF, 0xC8, 0x2E, 0x20, 0x1F, 0xB0, 0xE5, 0x06, 0xFF, 0xE8, 0x1D, 0x03, 0xFB, 0x0E, 0x40, 0x2F,
  0xFF, 0x90, 0x70, 0x6F, 0xB0, 0xE4, 0x0B, 0xFF, 0xFF, 0xE0, 0xE3, 0x04, 0xFF, 0xFF, 0xF0, 0xE3,
  0x0B, 0xFF, 0xFF, 0xF0, 0xE2, 0x02, 0xFF, 0x85, 0xD6, 0x33, 0x59, 0xEF, 0xF9, 0x0E, 0x20, 0x7F,
  0xE0, 0x86, 0x01, 0x0B, 0xFF, 0x0E, 0x20, 0xCF, 0xD0, 0xA7, 0x20, 0xBF, 0xE8, 0x1E, 0x01, 0xFD,
  0x0E, 0x01, 0x72, 0x01, 0x0E, 0xFD, 0x81, 0xE0, 0x5F, 0xD0, 0x87, 0x40, 0x7F, 0xD8, 0x1E, 0x08,
  0xFD, 0x03, 0x74, 0x01, 0xFD, 0x81, 0xE0, 0xBF, 0xC0, 0xD7, 0x60, 0xCF, 0xC8, 0x1E, 0x0E, 0xFC,
  0x0A, 0x76, 0x09, 0xFC, 0x0E, 0x1F, 0xD0, 0x77, 0x60, 0x6F, 0xC0, 0xE0, 0x2F, 0xD0, 0x57, 0x60,
  0x4F, 0xC0, 0xE0, 0x4F, 0xD0, 0x37, 0x60, 0x2F, 0xC0, 0xE0, 0x5F, 0xD0, 0x17, 0x60, 0x1F, 0xC0,
  0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0xFC,
  0x0E, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xC0, 0xE7, 0x71, 0x0E, 0xFB, 0x0E,
  0x06, 0xFD, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x05, 0xFD, 0x01, 0x77,
  0xFC, 0x0E, 0x04, 0xFD, 0x02, 0x76, 0x01, 0xFC, 0x0E, 0x03, 0xFD, 0x04, 0x76, 0x02, 0xFC, 0x0E,
  0x01, 0xFD, 0x06, 0x76, 0x04, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0x97, 0x60, 0x7F, 0xC8, 0x1E, 0x0C,
  0xFC, 0x0D, 0x76, 0x0A, 0xFC, 0x81, 0xE0, 0x9F, 0xD0, 0x27, 0x50, 0xEF, 0xC8, 0x1E, 0x06, 0xFD,
  0x08, 0x74, 0x05, 0xFD, 0x81, 0xE0, 0x2F, 0xD0, 0xE0, 0x17, 0x30, 0xCF, 0xD0, 0xE2, 0x0E, 0xFD,
  0x0A, 0x72, 0x08, 0xFE, 0x0E, 0x20, 0x9F, 0xE0, 0x97, 0x08, 0xFF, 0x0E, 0x20, 0x3F, 0xF8, 0x5D,
  0x63, 0x24, 0x7D, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0xFF, 0xF0, 0xE3, 0x05, 0xFF, 0xFF, 0xF0, 0xE4,
  0x0D, 0xFF, 0xF9, 0x0E, 0xFC, 0x0E, 0x40, 0x4F, 0xFF, 0x90, 0x40, 0xEF, 0xB0, 0xE5, 0x09, 0xFF,
  0xE0, 0xA1, 0xFC, 0x0E, 0x60, 0xBF, 0xFC, 0x81, 0xC0, 0x1F, 0xC0, 0xE6, 0x01, 0x0C, 0xFF, 0xA8,
  0x2D, 0x10, 0x2F, 0xC0, 0xE7, 0x10, 0xAF, 0xF0, 0xB0, 0x12, 0x02, 0xFC, 0x0E, 0x72, 0x04, 0x0C,
  0xFB, 0x0D, 0x06, 0x40, 0x3F, 0xC0, 0xE7, 0x48, 0x23, 0x8B, 0xEA, 0x82, 0xEC, 0x94, 0x60, 0x3F,
  0xC0, 0xD7, 0x77, 0x60, 0x3F, 0xC0, 0xC7, 0x77, 0x60, 0x4F, 0xC0, 0xB7, 0x77, 0x60, 0x5F, 0xC0,
  0x97, 0x77, 0x60, 0x7F, 0xC0, 0x77, 0x77, 0x60, 0xAF, 0xC0, 0x57, 0x77, 0x60, 0xEF, 0xC0, 0x27,
  0x77, 0x50, 0x6F, 0xC0, 0xD4, 0x09, 0x02, 0x77, 0x60, 0x10, 0xEF, 0xC0, 0x93, 0x01, 0xA0, 0xB0,
  0x47, 0x73, 0x01, 0x0C, 0xFD, 0x04, 0x30, 0x1C, 0x82, 0xEA, 0x51, 0x75, 0x06, 0x0E, 0xFD, 0x0D,
  0x40, 0x1F, 0x98, 0x92, 0xDA, 0x75, 0x43, 0x23, 0x46, 0x9E, 0xFF, 0x07, 0x40, 0x1F, 0xFF, 0xFD,
  0x0E, 0x50, 0x1F, 0xFF, 0xFD, 0x05, 0x50, 0x1F, 0xFF, 0xFC, 0x0B, 0x60, 0x1F, 0xFF, 0xFB, 0x0D,
  0x01, 0x60, 0x1F, 0xFF, 0xFA, 0x0D, 0x02, 0x70, 0x1F, 0xFF, 0xF9, 0x0C, 0x02, 0x72, 0x0E, 0xFF,
  0xFE, 0x09, 0x75, 0x06, 0x0C, 0xFF, 0xFA, 0x0B, 0x03, 0x77, 0x18, 0x13, 0x7C, 0xFF, 0xB8, 0x1D,
  0x82, 0x77, 0x68, 0x61, 0x46, 0x9B, 0xCD, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x27, 0x70,
  // "Ġ" (U+0120)
  0x77, 0x73, 0x86, 0x39, 0xDE, 0xFE, 0xB6, 0x80, 0xC2, 0x00, 0x8F, 0x90, 0xD0, 0x27, 0x77, 0x77,
  0x06, 0xFB, 0x0D, 0x77, 0x77, 0x70, 0xEF, 0xC0, 0x67, 0x77, 0x75, 0x03, 0xFD, 0x0A, 0x77, 0x77,
  0x50, 0x5F, 0xD0, 0xD7, 0x77, 0x75, 0x06, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0xD0, 0xD7, 0x77,
  0x75, 0x02, 0xFD, 0x0A, 0x77, 0x77, 0x60, 0xDF, 0xC0, 0x67, 0x77, 0x76, 0x05, 0xFB, 0x0C, 0x80,
  0xC0, 0x00, 0x7F, 0x90, 0xC0, 0x18, 0x0C, 0x10, 0x86, 0x28, 0xCE, 0xFE, 0xB5, 0x80, 0xC9, 0x30,
  0x85, 0x36, 0x9B, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x86, 0x37, 0x77, 0x70, 0x50, 0xBF, 0xFC, 0x81,
  0xB7, 0x27, 0x77, 0x02, 0x0A, 0xFF, 0xFB, 0x81, 0xD7, 0x17, 0x72, 0x01, 0x09, 0xFF, 0xFF, 0x90,
  0xA0, 0x37, 0x60, 0x6F, 0xFF, 0xFC, 0x06, 0x75, 0x0A, 0xFF, 0xFF, 0xD0, 0x17, 0x30, 0x10, 0xDF,
  0xFF, 0xFD, 0x0A, 0x73, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0x47, 0x20, 0x10, 0xDF, 0xFF, 0xFE, 0x0D,
  0x73, 0x0B, 0xFF, 0xFF, 0xF0, 0x87, 0x20, 0x7F, 0xFB, 0x89, 0x1D, 0x85, 0x32, 0x23, 0x46, 0x9C,
  0xF9, 0x02, 0x71, 0x03, 0xFF, 0xA0, 0x90, 0x27, 0x48, 0x11, 0x7D, 0xC0, 0xB7, 0x20, 0xCF, 0xF0,
  0xD0, 0x37, 0x72, 0x03, 0x0B, 0xA0, 0x67, 0x10, 0x5F, 0xF0, 0xB7, 0x76, 0x04, 0x0C, 0x72, 0x0D,
  0xFE, 0x0B, 0x77, 0x77, 0x30, 0x6F, 0xE0, 0xD0, 0x17, 0x77, 0x73, 0x0C, 0xFE, 0x04, 0x77, 0x77,
  0x30, 0x2F, 0xE0, 0xA7, 0x77, 0x74, 0x08, 0xFE, 0x02, 0x77, 0x77, 0x40, 0xDF, 0xD0, 0xA7, 0x77,
  0x74, 0x02, 0xFE, 0x04, 0x77, 0x77, 0x40, 0x5F, 0xD0, 0xE7, 0x77, 0x75, 0x09, 0xFD, 0x0A, 0x77,
  0x77, 0x50, 0xDF, 0xD0, 0x67, 0x77, 0x75, 0xFE, 0x03, 0x77, 0x77, 0x40, 0x2F, 0xE7, 0x77, 0x75,
  0x04, 0xFD, 0x0D, 0x77, 0x77, 0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x75, 0x07, 0xFD, 0x0A, 0x77, 0x77,
  0x50, 0x8F, 0xD0, 0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40,
  0x9F, 0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04, 0x0A, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0xAF,
  0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0,
  0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09, 0xFD, 0x09, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x7F, 0xD0, 0xA7,
  0x30, 0x5F, 0xFF, 0x04, 0x06, 0xFD, 0x0C, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x5F, 0xD0, 0xE7, 0x48,
  0x04, 0x20, 0x3F, 0xD0, 0x40, 0x3F, 0xE0, 0x17, 0x74, 0x01, 0xFD, 0x04, 0x01, 0xFE, 0x03, 0x77,
  0x40, 0x1F, 0xD8, 0x14, 0x0E, 0xFD, 0x06, 0x77, 0x40, 0x1F, 0xD8, 0x14, 0x0B, 0xFD, 0x0A, 0x77,
  0x40, 0x1F, 0xD8, 0x14, 0x08, 0xFD, 0x0E, 0x77, 0x40, 0x1F, 0xD8, 0x14, 0x05, 0xFE, 0x03, 0x77,
  0x30, 0x1F, 0xD8, 0x14, 0x01, 0xFE, 0x09, 0x77, 0x30, 0x1F, 0xD0, 0x42, 0x0C, 0xFE, 0x01, 0x77,
  0x20, 0x1F, 0xD0, 0x42, 0x07, 0xFE, 0x07, 0x77, 0x20, 0x1F, 0xD0, 0x42, 0x02, 0xFE, 0x0E, 0x01,
  0x77, 0x10, 0x1F, 0xD0, 0x43, 0x0B, 0xFE, 0x09, 0x77, 0x10, 0x1F, 0xD0, 0x43, 0x05, 0xFF, 0x06,
  0x77, 0x01, 0xFD, 0x04, 0x40, 0xDF, 0xF0, 0x77, 0x60, 0x1F, 0xD0, 0x44, 0x06, 0xFF, 0x90, 0xB0,
  0x27, 0x40, 0x1F, 0xD0, 0x45, 0x0D, 0xFF, 0xA8, 0x2B, 0x63, 0x13, 0x83, 0x23, 0x7A, 0xEF, 0xD0,
  0x45, 0x03, 0x80, 0xC4, 0xF0, 0x46, 0x09, 0x80, 0xC3, 0xF0, 0x47, 0x0C, 0x80, 0xC2, 0xF0, 0x47,
  0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x47, 0x10, 0x30, 0xE8, 0x0C, 0x0F, 0x04, 0x72, 0x02, 0x0D, 0xFF,
  0xFF, 0xF0, 0x47, 0x30, 0x10, 0xBF, 0xFF, 0xFE, 0x04, 0x75, 0x06, 0x0E, 0xFF, 0xFF, 0xA8, 0x1E,
  0xA2, 0x76, 0x81, 0x18, 0xEF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x50, 0x60, 0xBF, 0xFD, 0x82, 0xDA,
  0x63, 0x77, 0x74, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x90, 0xEE, 0xDC, 0xBA, 0x85, 0x31, 0x73,
  // "ġ" (U+0121)
  0x77, 0x58, 0x63, 0x9D, 0xEF, 0xEB, 0x67, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x02, 0x77, 0x77, 0x06,
  0xFB, 0x0D, 0x77, 0x77, 0x0E, 0xFC, 0x06, 0x77, 0x75, 0x03, 0xFD, 0x0A, 0x77, 0x75, 0x05, 0xFD,
  0x0D, 0x77, 0x75, 0x06, 0xFD, 0x0E, 0x77, 0x75, 0x05, 0xFD, 0x0D, 0x77, 0x75, 0x02, 0xFD, 0x0A,
  0x77, 0x76, 0x0D, 0xFC, 0x06, 0x77, 0x76, 0x05, 0xFB, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0x90, 0xC0,
  0x17, 0x77, 0x72, 0x86, 0x28, 0xCE, 0xFE, 0xB5, 0x80, 0xBB, 0x40, 0x89, 0x12, 0x7A, 0xDE, 0xFE,
  0xDA, 0x61, 0x77, 0x76, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x50, 0x9F, 0xA0, 0xE7, 0x10, 0x7F, 0xF0,
  0xD0, 0x34, 0x0B, 0xFA, 0x0E, 0x70, 0xAF, 0xFA, 0x0E, 0x04, 0x30, 0xEF, 0xA0, 0xE6, 0x09, 0xFF,
  0xC8, 0x2E, 0x20, 0x1F, 0xB0, 0xE5, 0x06, 0xFF, 0xE8, 0x1D, 0x03, 0xFB, 0x0E, 0x40, 0x2F, 0xFF,
  0x90, 0x70, 0x6F, 0xB0, 0xE4, 0x0B, 0xFF, 0xFF, 0xE0, 0xE3, 0x04, 0xFF, 0xFF, 0xF0, 0xE3, 0x0B,
  0xFF, 0xFF, 0xF0, 0xE2, 0x02, 0xFF, 0x85, 0xD6, 0x33, 0x59, 0xEF, 0xF9, 0x0E, 0x20, 0x7F, 0xE0,
  0x86, 0x01, 0x0B, 0xFF, 0x0E, 0x20, 0xCF, 0xD0, 0xA7, 0x20, 0xBF, 0xE8, 0x1E, 0x01, 0xFD, 0x0E,
  0x01, 0x72, 0x01, 0x0E, 0xFD, 0x81, 0xE0, 0x5F, 0xD0, 0x87, 0x40, 0x7F, 0xD8, 0x1E, 0x08, 0xFD,
  0x03, 0x74, 0x01, 0xFD, 0x81, 0xE0, 0xBF, 0xC0, 0xD7, 0x60, 0xCF, 0xC8, 0x1E, 0x0E, 0xFC, 0x0A,
  0x76, 0x09, 0xFC, 0x0E, 0x1F, 0xD0, 0x77, 0x60, 0x6F, 0xC0, 0xE0, 0x2F, 0xD0, 0x57, 0x60, 0x4F,
  0xC0, 0xE0, 0x4F, 0xD0, 0x37, 0x60, 0x2F, 0xC0, 0xE0, 0x5F, 0xD0, 0x17, 0x60, 0x1F, 0xC0, 0xE0,
  0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0xFC, 0x0E,
  0x07, 0xFC, 0x0E, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x7F, 0xC0, 0xE7, 0x71, 0x0E, 0xFB, 0x0E, 0x06,
  0xFD, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x05, 0xFD, 0x01, 0x77, 0xFC,
  0x0E, 0x04, 0xFD, 0x02, 0x76, 0x01, 0xFC, 0x0E, 0x03, 0xFD, 0x04, 0x76, 0x02, 0xFC, 0x0E, 0x01,
  0xFD, 0x06, 0x76, 0x04, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0x97, 0x60, 0x7F, 0xC8, 0x1E, 0x0C, 0xFC,
  0x0D, 0x76, 0x0A, 0xFC, 0x81, 0xE0, 0x9F, 0xD0, 0x27, 0x50, 0xEF, 0xC8, 0x1E, 0x06, 0xFD, 0x08,
  0x74, 0x05, 0xFD, 0x81, 0xE0, 0x2F, 0xD0, 0xE0, 0x17, 0x30, 0xCF, 0xD0, 0xE2, 0x0E, 0xFD, 0x0A,
  0x72, 0x08, 0xFE, 0x0E, 0x20, 0x9F, 0xE0, 0x97, 0x08, 0xFF, 0x0E, 0x20, 0x3F, 0xF8, 0x5D, 0x63,
  0x24, 0x7D, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0xFF, 0xF0, 0xE3, 0x05, 0xFF, 0xFF, 0xF0, 0xE4, 0x0D,
  0xFF, 0xF9, 0x0E, 0xFC, 0x0E, 0x40, 0x4F, 0xFF, 0x90, 0x40, 0xEF, 0xB0, 0xE5, 0x09, 0xFF, 0xE0,
  0xA1, 0xFC, 0x0E, 0x60, 0xBF, 0xFC, 0x81, 0xC0, 0x1F, 0xC0, 0xE6, 0x01, 0x0C, 0xFF, 0xA8, 0x2D,
  0x10, 0x2F, 0xC0, 0xE7, 0x10, 0xAF, 0xF0, 0xB0, 0x12, 0x02, 0xFC, 0x0E, 0x72, 0x04, 0x0C, 0xFB,
  0x0D, 0x06, 0x40, 0x3F, 0xC0, 0xE7, 0x48, 0x23, 0x8B, 0xEA, 0x82, 0xEC, 0x94, 0x60, 0x3F, 0xC0,
  0xD7, 0x77, 0x60, 0x3F, 0xC0, 0xC7, 0x77, 0x60, 0x4F, 0xC0, 0xB7, 0x77, 0x60, 0x5F, 0xC0, 0x97,
  0x77, 0x60, 0x7F, 0xC0, 0x77, 0x77, 0x60, 0xAF, 0xC0, 0x57, 0x77, 0x60, 0xEF, 0xC0, 0x27, 0x77,
  0x50, 0x6F, 0xC0, 0xD4, 0x09, 0x02, 0x77, 0x60, 0x10, 0xEF, 0xC0, 0x93, 0x01, 0xA0, 0xB0, 0x47,
  0x73, 0x01, 0x0C, 0xFD, 0x04, 0x30, 0x1C, 0x82, 0xEA, 0x51, 0x75, 0x06, 0x0E, 0xFD, 0x0D, 0x40,
  0x1F, 0x98, 0x92, 0xDA, 0x75, 0x43, 0x23, 0x46, 0x9E, 0xFF, 0x07, 0x40, 0x1F, 0xFF, 0xFD, 0x0E,
  0x50, 0x1F, 0xFF, 0xFD, 0x05, 0x50, 0x1F, 0xFF, 0xFC, 0x0B, 0x60, 0x1F, 0xFF, 0xFB, 0x0D, 0x01,
  0x60, 0x1F, 0xFF, 0xFA, 0x0D, 0x02, 0x70, 0x1F, 0xFF, 0xF9, 0x0C, 0x02, 0x72, 0x0E, 0xFF, 0xFE,
  0x09, 0x75, 0x06, 0x0C, 0xFF, 0xFA, 0x0B, 0x03, 0x77, 0x18, 0x13, 0x7C, 0xFF, 0xB8, 0x1D, 0x82,
  0x77, 0x68, 0x61, 0x46, 0x9B, 0xCD, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x27, 0x70,
  // "Ģ" (U+0122)
  0x77, 0x78, 0x53, 0x69, 0xBC, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x63, 0x77, 0x77, 0x05, 0x0B, 0xFF,
  0xC8, 0x1B, 0x72, 0x77, 0x70, 0x20, 0xAF, 0xFF, 0xB8, 0x1D, 0x71, 0x77, 0x20, 0x10, 0x9F, 0xFF,
  0xF9, 0x0A, 0x03, 0x76, 0x06, 0xFF, 0xFF, 0xC0, 0x67, 0x50, 0xAF, 0xFF, 0xFD, 0x01, 0x73, 0x01,
  0x0D, 0xFF, 0xFF, 0xD0, 0xA7, 0x30, 0x10, 0xDF, 0xFF, 0xFE, 0x04, 0x72, 0x01, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD7, 0x30, 0xBF, 0xFF, 0xFF, 0x08, 0x72, 0x07, 0xFF, 0xB8, 0x91, 0xD8, 0x53, 0x22, 0x34,
  0x69, 0xCF, 0x90, 0x27, 0x10, 0x3F, 0xFA, 0x09, 0x02, 0x74, 0x81, 0x17, 0xDC, 0x0B, 0x72, 0x0C,
  0xFF, 0x0D, 0x03, 0x77, 0x20, 0x30, 0xBA, 0x06, 0x71, 0x05, 0xFF, 0x0B, 0x77, 0x60, 0x40, 0xC7,
  0x20, 0xDF, 0xE0, 0xB7, 0x77, 0x73, 0x06, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xE0, 0x47,
  0x77, 0x73, 0x02, 0xFE, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0xE0, 0x27, 0x77, 0x74, 0x0D, 0xFD, 0x0A,
  0x77, 0x77, 0x40, 0x2F, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xFD, 0x0E, 0x77, 0x77, 0x50, 0x9F, 0xD0,
  0xA7, 0x77, 0x75, 0x0D, 0xFD, 0x06, 0x77, 0x77, 0x5F, 0xE0, 0x37, 0x77, 0x74, 0x02, 0xFE, 0x77,
  0x77, 0x50, 0x4F, 0xD0, 0xD7, 0x77, 0x75, 0x06, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0xA7,
  0x77, 0x75, 0x08, 0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x77, 0x30, 0x5F, 0xFF,
  0x04, 0x09, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0xAF, 0xD0, 0x77, 0x30, 0x5F, 0xFF, 0x04,
  0x0A, 0xFD, 0x07, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x87, 0x30, 0x5F, 0xFF, 0x04, 0x09,
  0xFD, 0x08, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x9F, 0xD0, 0x97, 0x30, 0x5F, 0xFF, 0x04, 0x07, 0xFD,
  0x0A, 0x73, 0x05, 0xFF, 0xF0, 0x40, 0x6F, 0xD0, 0xC7, 0x30, 0x5F, 0xFF, 0x04, 0x05, 0xFD, 0x0E,
  0x74, 0x80, 0x42, 0x03, 0xFD, 0x04, 0x03, 0xFE, 0x01, 0x77, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xE0,
  0x37, 0x74, 0x01, 0xFD, 0x81, 0x40, 0xEF, 0xD0, 0x67, 0x74, 0x01, 0xFD, 0x81, 0x40, 0xBF, 0xD0,
  0xA7, 0x74, 0x01, 0xFD, 0x81, 0x40, 0x8F, 0xD0, 0xE7, 0x74, 0x01, 0xFD, 0x81, 0x40, 0x5F, 0xE0,
  0x37, 0x73, 0x01, 0xFD, 0x81, 0x40, 0x1F, 0xE0, 0x97, 0x73, 0x01, 0xFD, 0x04, 0x20, 0xCF, 0xE0,
  0x17, 0x72, 0x01, 0xFD, 0x04, 0x20, 0x7F, 0xE0, 0x77, 0x72, 0x01, 0xFD, 0x04, 0x20, 0x2F, 0xE0,
  0xE0, 0x17, 0x71, 0x01, 0xFD, 0x04, 0x30, 0xBF, 0xE0, 0x97, 0x71, 0x01, 0xFD, 0x04, 0x30, 0x5F,
  0xF0, 0x67, 0x70, 0x1F, 0xD0, 0x44, 0x0D, 0xFF, 0x07, 0x76, 0x01, 0xFD, 0x04, 0x40, 0x6F, 0xF9,
  0x0B, 0x02, 0x74, 0x01, 0xFD, 0x04, 0x50, 0xDF, 0xFA, 0x82, 0xB6, 0x31, 0x38, 0x32, 0x37, 0xAE,
  0xFD, 0x04, 0x50, 0x38, 0x0C, 0x4F, 0x04, 0x60, 0x98, 0x0C, 0x3F, 0x04, 0x70, 0xC8, 0x0C, 0x2F,
  0x04, 0x70, 0x10, 0xE8, 0x0C, 0x1F, 0x04, 0x71, 0x03, 0x0E, 0x80, 0xC0, 0xF0, 0x47, 0x20, 0x20,
  0xDF, 0xFF, 0xFF, 0x04, 0x73, 0x01, 0x0B, 0xFF, 0xFF, 0xE0, 0x47, 0x50, 0x60, 0xEF, 0xFF, 0xFA,
  0x81, 0xEA, 0x27, 0x68, 0x11, 0x8E, 0xFF, 0xFC, 0x81, 0xEA, 0x57, 0x75, 0x06, 0x0B, 0xFF, 0xD8,
  0x2D, 0xA6, 0x37, 0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x89, 0x0E, 0xED, 0xCB, 0xA8, 0x53, 0x18,
  0x0C, 0x86, 0x00, 0x1F, 0xC0, 0x97, 0x77, 0x76, 0x03, 0xFC, 0x07, 0x77, 0x77, 0x60, 0x5F, 0xC0,
  0x17, 0x77, 0x76, 0x07, 0xFB, 0x0B, 0x77, 0x77, 0x70, 0x9F, 0xB0, 0x57, 0x77, 0x77, 0x0C, 0xFA,
  0x0D, 0x80, 0xC0, 0x0F, 0xB0, 0x67, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x80, 0xC0, 0x00, 0x5F, 0xA0,
  0x78, 0x0C, 0x00, 0x08, 0xF9, 0x0E, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x68, 0x0C, 0x10, 0x0E, 0xF0,
  0xD8, 0x0C, 0x10, 0x03, 0xF9, 0x03, 0x80, 0xC1, 0x00, 0x4F, 0x0A, 0x77, 0x50,
  // "ģ" (U+0123)
  0x77, 0x60, 0xBF, 0x02, 0x77, 0x77, 0x20, 0x6F, 0x90, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xF0, 0xD7,
  0x77, 0x72, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x10, 0x3F, 0xA0, 0x57, 0x77, 0x71, 0x0B, 0xFA, 0x02,
  0x77, 0x77, 0x04, 0xFA, 0x0E, 0x77, 0x77, 0x10, 0xBF, 0xA0, 0xB7, 0x77, 0x70, 0x2F, 0xB0, 0x87,
  0x77, 0x70, 0x9F, 0xB0, 0x57, 0x77, 0x70, 0xEF, 0xB0, 0x27, 0x77, 0x60, 0x5F, 0xC7, 0x77, 0x70,
  0xBF, 0xB0, 0xE7, 0x77, 0x70, 0xEF, 0xB0, 0xC8, 0x0A, 0xE5, 0x08, 0x91, 0x27, 0xAD, 0xEF, 0xED,
  0xA6, 0x17, 0x77, 0x60, 0x20, 0xAF, 0xC0, 0x90, 0x15, 0x09, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0x0D,
  0x03, 0x40, 0xBF, 0xA0, 0xE7, 0x0A, 0xFF, 0xA0, 0xE0, 0x43, 0x0E, 0xFA, 0x0E, 0x60, 0x9F, 0xFC,
  0x82, 0xE2, 0x01, 0xFB, 0x0E, 0x50, 0x6F, 0xFE, 0x81, 0xD0, 0x3F, 0xB0, 0xE4, 0x02, 0xFF, 0xF9,
  0x07, 0x06, 0xFB, 0x0E, 0x40, 0xBF, 0xFF, 0xFE, 0x0E, 0x30, 0x4F, 0xFF, 0xFF, 0x0E, 0x30, 0xBF,
  0xFF, 0xFF, 0x0E, 0x20, 0x2F, 0xF8, 0x5D, 0x63, 0x35, 0x9E, 0xFF, 0x90, 0xE2, 0x07, 0xFE, 0x08,
  0x60, 0x10, 0xBF, 0xF0, 0xE2, 0x0C, 0xFD, 0x0A, 0x72, 0x0B, 0xFE, 0x81, 0xE0, 0x1F, 0xD0, 0xE0,
  0x17, 0x20, 0x10, 0xEF, 0xD8, 0x1E, 0x05, 0xFD, 0x08, 0x74, 0x07, 0xFD, 0x81, 0xE0, 0x8F, 0xD0,
  0x37, 0x40, 0x1F, 0xD8, 0x1E, 0x0B, 0xFC, 0x0D, 0x76, 0x0C, 0xFC, 0x81, 0xE0, 0xEF, 0xC0, 0xA7,
  0x60, 0x9F, 0xC0, 0xE1, 0xFD, 0x07, 0x76, 0x06, 0xFC, 0x0E, 0x02, 0xFD, 0x05, 0x76, 0x04, 0xFC,
  0x0E, 0x04, 0xFD, 0x03, 0x76, 0x02, 0xFC, 0x0E, 0x05, 0xFD, 0x01, 0x76, 0x01, 0xFC, 0x0E, 0x06,
  0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x6F, 0xD7, 0x71, 0xFC, 0x0E, 0x07, 0xFD, 0x77, 0x1F, 0xC0, 0xE0,
  0x7F, 0xC0, 0xE7, 0x71, 0x0E, 0xFB, 0x0E, 0x07, 0xFC, 0x0E, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x6F,
  0xD7, 0x71, 0x0E, 0xFB, 0x0E, 0x06, 0xFD, 0x77, 0x1F, 0xC0, 0xE0, 0x5F, 0xD0, 0x17, 0x7F, 0xC0,
  0xE0, 0x4F, 0xD0, 0x27, 0x60, 0x1F, 0xC0, 0xE0, 0x3F, 0xD0, 0x47, 0x60, 0x2F, 0xC0, 0xE0, 0x1F,
  0xD0, 0x67, 0x60, 0x4F, 0xC8, 0x1E, 0x0E, 0xFC, 0x09, 0x76, 0x07, 0xFC, 0x81, 0xE0, 0xCF, 0xC0,
  0xD7, 0x60, 0xAF, 0xC8, 0x1E, 0x09, 0xFD, 0x02, 0x75, 0x0E, 0xFC, 0x81, 0xE0, 0x6F, 0xD0, 0x87,
  0x40, 0x5F, 0xD8, 0x1E, 0x02, 0xFD, 0x0E, 0x01, 0x73, 0x0C, 0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0xA7,
  0x20, 0x8F, 0xE0, 0xE2, 0x09, 0xFE, 0x09, 0x70, 0x8F, 0xF0, 0xE2, 0x03, 0xFF, 0x85, 0xD6, 0x32,
  0x47, 0xDF, 0xF9, 0x0E, 0x30, 0xCF, 0xFF, 0xFF, 0x0E, 0x30, 0x5F, 0xFF, 0xFF, 0x0E, 0x40, 0xDF,
  0xFF, 0x90, 0xEF, 0xC0, 0xE4, 0x04, 0xFF, 0xF9, 0x04, 0x0E, 0xFB, 0x0E, 0x50, 0x9F, 0xFE, 0x0A,
  0x1F, 0xC0, 0xE6, 0x0B, 0xFF, 0xC8, 0x1C, 0x01, 0xFC, 0x0E, 0x60, 0x10, 0xCF, 0xFA, 0x82, 0xD1,
  0x02, 0xFC, 0x0E, 0x71, 0x0A, 0xFF, 0x0B, 0x01, 0x20, 0x2F, 0xC0, 0xE7, 0x20, 0x40, 0xCF, 0xB0,
  0xD0, 0x64, 0x03, 0xFC, 0x0E, 0x74, 0x82, 0x38, 0xBE, 0xA8, 0x2E, 0xC9, 0x46, 0x03, 0xFC, 0x0D,
  0x77, 0x76, 0x03, 0xFC, 0x0C, 0x77, 0x76, 0x04, 0xFC, 0x0B, 0x77, 0x76, 0x05, 0xFC, 0x09, 0x77,
  0x76, 0x07, 0xFC, 0x07, 0x77, 0x76, 0x0A, 0xFC, 0x05, 0x77, 0x76, 0x0E, 0xFC, 0x02, 0x77, 0x75,
  0x06, 0xFC, 0x0D, 0x40, 0x90, 0x27, 0x76, 0x01, 0x0E, 0xFC, 0x09, 0x30, 0x1A, 0x0B, 0x04, 0x77,
  0x30, 0x10, 0xCF, 0xD0, 0x43, 0x01, 0xC8, 0x2E, 0xA5, 0x17, 0x50, 0x60, 0xEF, 0xD0, 0xD4, 0x01,
  0xF9, 0x89, 0x2D, 0xA7, 0x54, 0x32, 0x34, 0x69, 0xEF, 0xF0, 0x74, 0x01, 0xFF, 0xFF, 0xD0, 0xE5,
  0x01, 0xFF, 0xFF, 0xD0, 0x55, 0x01, 0xFF, 0xFF, 0xC0, 0xB6, 0x01, 0xFF, 0xFF, 0xB0, 0xD0, 0x16,
  0x01, 0xFF, 0xFF, 0xA0, 0xD0, 0x27, 0x01, 0xFF, 0xFF, 0x90, 0xC0, 0x27, 0x20, 0xEF, 0xFF, 0xE0,
  0x97, 0x50, 0x60, 0xCF, 0xFF, 0xA0, 0xB0, 0x37, 0x71, 0x81, 0x37, 0xCF, 0xFB, 0x81, 0xD8, 0x27,
  0x76, 0x86, 0x14, 0x69, 0xBC, 0xDE, 0xA8, 0x5E, 0xEC, 0xA8, 0x52, 0x77,
  // "Ĥ" (U+0124)
  0x77, 0x20, 0x18, 0x09, 0x07, 0x02, 0x77, 0x77, 0x30, 0x9F, 0xD0, 0xB7, 0x77, 0x72, 0x03, 0xFF,
  0x04, 0x77, 0x77, 0x10, 0xCF, 0xF0, 0xD7, 0x77, 0x70, 0x7F, 0xFA, 0x08, 0x77, 0x75, 0x03, 0xFF,
  0xC0, 0x37, 0x77, 0x40, 0xDF, 0xFC, 0x0D, 0x77, 0x73, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x77,
  0x10, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x77, 0x60, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E,
  0x02, 0x77, 0x50, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x77, 0x40, 0x8F, 0xA0, 0x46, 0x04, 0xFA,
  0x09, 0x77, 0x20, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x90, 0x67, 0x70, 0x20, 0xEF, 0x0E,
  0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x76, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF, 0x07, 0x80,
  0xBC, 0x30, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08,
  0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77,
  0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0,
  0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27,
  0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A,
  0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02,
  0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0,
  0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0,
  0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD,
  0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C,
  0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0,
  0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7, 0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0x80, 0xC7,
  0xF0, 0xA0, 0x88, 0x0C, 0x7F, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27,
  0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A,
  0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02,
  0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0,
  0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0,
  0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD,
  0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F,
  0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F,
  0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74,
  0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A, 0x08,
  0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xA0, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0A,
  // "ĥ" (U+0125)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x76, 0x09, 0xFD, 0x0B, 0x77, 0x77, 0x50, 0x3F, 0xF0,
  0x47, 0x77, 0x74, 0x0C, 0xFF, 0x0D, 0x77, 0x77, 0x30, 0x7F, 0xFA, 0x08, 0x77, 0x77, 0x10, 0x3F,
  0xFC, 0x03, 0x77, 0x77, 0x0D, 0xFF, 0xC0, 0xD7, 0x77, 0x60, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77,
  0x74, 0x04, 0xFA, 0x81, 0xE3, 0x3F, 0xB0, 0x57, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA,
  0x0E, 0x02, 0x77, 0x71, 0x0B, 0xFA, 0x04, 0x40, 0x5F, 0xA0, 0xC7, 0x77, 0x08, 0xFA, 0x04, 0x60,
  0x4F, 0xA0, 0x97, 0x75, 0x04, 0xF9, 0x0E, 0x04, 0x71, 0x03, 0x0E, 0xF9, 0x06, 0x77, 0x30, 0x20,
  0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x77, 0x20, 0x6F, 0x0C, 0x01, 0x75, 0x01, 0x0B,
  0xF0, 0x78, 0x0C, 0x85, 0x00, 0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70,
  0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xC7, 0x77, 0x77,
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x70, 0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xC7, 0x77,
  0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x70, 0x5F, 0xC0, 0xC7, 0x77, 0x77, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xB7,
  0x77, 0x77, 0x05, 0xFC, 0x0B, 0x77, 0x77, 0x70, 0x5F, 0xC0, 0xA6, 0x89, 0x12, 0x7A, 0xDE, 0xFE,
  0xDB, 0x83, 0x77, 0x40, 0x5F, 0xC0, 0x94, 0x03, 0x0B, 0xFC, 0x0D, 0x06, 0x77, 0x20, 0x5F, 0xC0,
  0x93, 0x09, 0xFF, 0x90, 0xC0, 0x17, 0x70, 0x5F, 0xC0, 0x72, 0x0B, 0xFF, 0xB0, 0xE0, 0x37, 0x60,
  0x5F, 0xC8, 0x16, 0x0A, 0xFF, 0xD0, 0xE0, 0x27, 0x50, 0x5F, 0xC0, 0x30, 0x7F, 0xFF, 0x0C, 0x75,
  0x05, 0xFC, 0x03, 0x0E, 0xFF, 0xF9, 0x06, 0x74, 0x05, 0xFF, 0xFF, 0xF0, 0xE7, 0x40, 0x58, 0x0C,
  0x0F, 0x05, 0x73, 0x05, 0x80, 0xC0, 0xF0, 0xB7, 0x30, 0x5F, 0xFA, 0x85, 0xE8, 0x53, 0x36, 0xCF,
  0xF7, 0x30, 0x5F, 0xF9, 0x08, 0x70, 0xAF, 0xE0, 0x37, 0x20, 0x5F, 0xF0, 0x87, 0x20, 0xDF, 0xD0,
  0x67, 0x20, 0x5F, 0xE0, 0xD7, 0x30, 0x7F, 0xD0, 0x87, 0x20, 0x5F, 0xE0, 0x67, 0x30, 0x1F, 0xD0,
  0xA7, 0x20, 0x5F, 0xE7, 0x50, 0xDF, 0xC0, 0xB7, 0x20, 0x5F, 0xD0, 0xB7, 0x50, 0xAF, 0xC0, 0xC7,
  0x20, 0x5F, 0xD0, 0x87, 0x50, 0x9F, 0xC0, 0xC7, 0x20, 0x5F, 0xD0, 0x57, 0x50, 0x7F, 0xC0, 0xC7,
  0x20, 0x5F, 0xD0, 0x37, 0x50, 0x7F, 0xC0, 0xC7, 0x20, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC7,
  0x20, 0x5F, 0xD7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x20,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  // "Ħ" (U+0126)
  0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70,
  0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F,
  0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0,
  0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x02, 0x80, 0xE5, 0xF0,
  0x60, 0x28, 0x0E, 0x5F, 0x06, 0x02, 0x80, 0xE5, 0xF0, 0x60, 0x28, 0x0E, 0x5F, 0x06, 0x02, 0x80,
  0xE5, 0xF0, 0x60, 0x28, 0x0E, 0x5F, 0x06, 0x02, 0x80, 0xE5, 0xF0, 0x60, 0x28, 0x0E, 0x5F, 0x06,
  0x02, 0x80, 0xE5, 0xF0, 0x67, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27,
  0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74,
  0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B,
  0x77, 0x08, 0x80, 0xC7, 0xF0, 0xB7, 0x70, 0x88, 0x0C, 0x7F, 0x0B, 0x77, 0x08, 0x80, 0xC7, 0xF0,
  0xB7, 0x70, 0x88, 0x0C, 0x7F, 0x0B, 0x77, 0x08, 0x80, 0xC7, 0xF0, 0xB7, 0x70, 0x88, 0x0C, 0x7F,
  0x0B, 0x77, 0x08, 0x80, 0xC7, 0xF0, 0xB7, 0x70, 0x88, 0x0C, 0x7F, 0x0B, 0x77, 0x08, 0x80, 0xC7,
  0xF0, 0xB7, 0x70, 0x88, 0x0C, 0x7F, 0x0B, 0x77, 0x08, 0x80, 0xC7, 0xF0, 0xB7, 0x70, 0x8F, 0xD0,
  0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27,
  0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74,
  0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD,
  0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B,
  0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77,
  0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08,
  0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD,
  0x02, 0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02,
  0x77, 0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77,
  0x4F, 0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F,
  0xD0, 0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0,
  0xB7, 0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7,
  0x70, 0x8F, 0xD0, 0x27, 0x74, 0xFD, 0x0B, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x4F, 0xD0, 0xB7,
  // "ħ" (U+0127)
  0x60, 0x6F, 0xC0, 0xC7, 0x77, 0x74, 0x06, 0xFC, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0xC0, 0xC7, 0x77,
  0x74, 0x06, 0xFC, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0xC0, 0xC7, 0x77, 0x74, 0x06, 0xFC, 0x0C, 0x77,
  0x77, 0x40, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x1F, 0xFF, 0xF0, 0x47, 0x71, 0x01, 0xFF, 0xFF, 0x04,
  0x77, 0x10, 0x1F, 0xFF, 0xF0, 0x47, 0x71, 0x01, 0xFF, 0xFF, 0x04, 0x77, 0x10, 0x1F, 0xFF, 0xF0,
  0x47, 0x71, 0x01, 0xFF, 0xFF, 0x04, 0x77, 0x10, 0x1F, 0xFF, 0xF0, 0x47, 0x71, 0x01, 0xFF, 0xFF,
  0x04, 0x77, 0x70, 0x6F, 0xC0, 0xC7, 0x77, 0x74, 0x06, 0xFC, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0xC0,
  0xC7, 0x77, 0x74, 0x06, 0xFC, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0xC0, 0xB7, 0x77, 0x74, 0x06, 0xFC,
  0x0A, 0x68, 0x91, 0x37, 0xBD, 0xEF, 0xED, 0xB8, 0x37, 0x71, 0x06, 0xFC, 0x0A, 0x40, 0x40, 0xCF,
  0xC0, 0xD0, 0x67, 0x60, 0x6F, 0xC0, 0x93, 0x09, 0xFF, 0x90, 0xC0, 0x27, 0x40, 0x6F, 0xC0, 0x72,
  0x0B, 0xFF, 0xB0, 0xE0, 0x37, 0x30, 0x6F, 0xC8, 0x16, 0x0A, 0xFF, 0xD0, 0xE0, 0x27, 0x20, 0x6F,
  0xC0, 0x30, 0x6F, 0xFF, 0x0C, 0x72, 0x06, 0xFC, 0x02, 0x0E, 0xFF, 0xF9, 0x06, 0x71, 0x06, 0xFF,
  0xFF, 0xF0, 0xE7, 0x10, 0x68, 0x0C, 0x0F, 0x05, 0x70, 0x68, 0x0C, 0x0F, 0x0B, 0x70, 0x6F, 0xFA,
  0x85, 0xD7, 0x43, 0x37, 0xEF, 0xF7, 0x06, 0xFF, 0x90, 0x86, 0x01, 0x0C, 0xFE, 0x03, 0x60, 0x6F,
  0xF0, 0x87, 0x10, 0x2F, 0xE0, 0x66, 0x06, 0xFE, 0x0D, 0x73, 0x09, 0xFD, 0x08, 0x60, 0x6F, 0xE0,
  0x57, 0x30, 0x3F, 0xD0, 0xA6, 0x06, 0xFD, 0x0E, 0x75, 0xFD, 0x0B, 0x60, 0x6F, 0xD0, 0xB7, 0x50,
  0xCF, 0xC0, 0xC6, 0x06, 0xFD, 0x07, 0x75, 0x0A, 0xFC, 0x0C, 0x60, 0x6F, 0xD0, 0x57, 0x50, 0x9F,
  0xC0, 0xC6, 0x06, 0xFD, 0x02, 0x75, 0x08, 0xFC, 0x0C, 0x60, 0x6F, 0xD0, 0x17, 0x50, 0x7F, 0xC0,
  0xC6, 0x06, 0xFD, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xE7, 0x60, 0x7F, 0xC0, 0xC6, 0x06,
  0xFC, 0x0D, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xD7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC,
  0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C,
  0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76,
  0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07,
  0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC,
  0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C,
  0x60, 0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60,
  0x6F, 0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F,
  0xC0, 0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0,
  0xC7, 0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7,
  0x60, 0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C, 0x60, 0x6F, 0xC0, 0xC7, 0x60,
  0x7F, 0xC0, 0xC6, 0x06, 0xFC, 0x0C, 0x76, 0x07, 0xFC, 0x0C,
  // "Ĩ" (U+0128)
  0x68, 0x65, 0xAD, 0xFE, 0xC9, 0x47, 0x40, 0x6E, 0x40, 0x10, 0xCF, 0x90, 0xD0, 0x57, 0x20, 0xBE,
  0x30, 0x10, 0xDF, 0xC0, 0xD0, 0x66, 0x03, 0xE0, 0xD3, 0x0A, 0xFF, 0x85, 0xE8, 0x31, 0x04, 0xEE,
  0x0B, 0x20, 0x4F, 0xFF, 0xF0, 0x82, 0x0C, 0xFF, 0xFF, 0x81, 0x50, 0x2F, 0xFF, 0xF0, 0xE2, 0x07,
  0xFF, 0xFF, 0x09, 0x20, 0xAF, 0xFF, 0xE0, 0xE0, 0x12, 0x0E, 0xE8, 0x4D, 0x30, 0x15, 0xBF, 0xF9,
  0x06, 0x20, 0x1E, 0x0E, 0x01, 0x50, 0x30, 0xAF, 0xD0, 0x83, 0x03, 0xE0, 0x77, 0x18, 0x12, 0x9E,
  0xF9, 0x07, 0x40, 0x5E, 0x02, 0x74, 0x86, 0x5A, 0xDE, 0xEC, 0x82, 0x80, 0xAC, 0x40, 0x04, 0xFF,
  0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65,
  0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x3F, 0xFF,
  0xC0, 0x66, 0x81, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x27, 0x30, 0x60, 0xCF, 0xF9, 0x0D, 0x06, 0x77,
  0x10, 0x30, 0xDF, 0xC0, 0xE0, 0x47, 0x74, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75,
  0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0,
  0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50,
  0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D,
  0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C,
  0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7,
  0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF,
  0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77,
  0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC,
  0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75,
  0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0,
  0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50, 0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x50,
  0xCF, 0xC0, 0xD7, 0x75, 0x0C, 0xFC, 0x0D, 0x77, 0x40, 0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x78, 0x11,
  0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x72, 0x03, 0x0A, 0xFF, 0xF0, 0xA0, 0x46, 0x04, 0xFF, 0xFC, 0x06,
  0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF,
  0xFC, 0x06, 0x50, 0x4F, 0xFF, 0xC0, 0x65, 0x04, 0xFF, 0xFC, 0x06, 0x20,
  // "ĩ" (U+0129)
  0x68, 0x65, 0xAD, 0xFE, 0xC9, 0x47, 0x40, 0x6E, 0x40, 0x10, 0xCF, 0x90, 0xD0, 0x57, 0x20, 0xBE,
  0x30, 0x10, 0xDF, 0xC0, 0xD0, 0x66, 0x03, 0xE0, 0xD3, 0x0A, 0xFF, 0x85, 0xE8, 0x31, 0x04, 0xEE,
  0x0B, 0x20, 0x4F, 0xFF, 0xF0, 0x82, 0x0C, 0xFF, 0xFF, 0x81, 0x50, 0x2F, 0xFF, 0xF0, 0xE2, 0x07,
  0xFF, 0xFF, 0x09, 0x20, 0xAF, 0xFF, 0xE0, 0xE0, 0x12, 0x0E, 0xE8, 0x4D, 0x30, 0x15, 0xBF, 0xF9,
  0x06, 0x20, 0x1E, 0x0E, 0x01, 0x50, 0x30, 0xAF, 0xD0, 0x83, 0x03, 0xE0, 0x77, 0x18, 0x12, 0x9E,
  0xF9, 0x07, 0x40, 0x5E, 0x02, 0x74, 0x86, 0x5A, 0xDE, 0xEC, 0x82, 0x80, 0xAD, 0x30, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75,
  0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0,
  0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50,
  0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75,
  0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0,
  0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50,
  0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x72,
  // "Ī" (U+012A)
  0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D,
  0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D,
  0x06, 0xFF, 0xFC, 0x0D, 0x80, 0xAB, 0x60, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04,
  0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04,
  0xFF, 0xFC, 0x06, 0x03, 0xFF, 0xFC, 0x83, 0x60, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x25, 0x06, 0x0C,
  0xFF, 0x90, 0xD0, 0x67, 0x30, 0x30, 0xDF, 0xC0, 0xE0, 0x47, 0x60, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF,
  0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x60, 0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x28, 0x11, 0x7D, 0xFF,
  0x98, 0x1E, 0x82, 0x40, 0x30, 0xAF, 0xFF, 0x82, 0xA4, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC,
  0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC,
  0x06, 0x04, 0xFF, 0xFC, 0x06,
  // "ī" (U+012B)
  0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D,
  0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D, 0x06, 0xFF, 0xFC, 0x0D,
  0x06, 0xFF, 0xFC, 0x0D, 0x80, 0xAC, 0x50, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05,
  0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x77, 0x05, 0xFC, 0x0E, 0x70,
  // "Ĭ" (U+012C)
  0x03, 0x80, 0x27, 0x06, 0x77, 0x80, 0x37, 0x01, 0x04, 0xE0, 0xE7, 0x60, 0x3F, 0x01, 0x03, 0xF0,
  0x37, 0x50, 0x7F, 0x10, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD2, 0x0E, 0xF0, 0x87, 0x20, 0x20,
  0xCF, 0x09, 0x20, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0, 0x52, 0x05, 0xFF, 0xFC,
  0x0E, 0x01, 0x30, 0xDF, 0xFF, 0xB0, 0x84, 0x06, 0xFF, 0xFA, 0x0E, 0x60, 0xCF, 0xFF, 0x90, 0x46,
  0x02, 0x0E, 0xFF, 0xE0, 0x67, 0x10, 0x30, 0xEF, 0xFC, 0x06, 0x73, 0x01, 0x0C, 0xFF, 0x90, 0xD0,
  0x37, 0x60, 0x50, 0xCF, 0xC0, 0xE0, 0x67, 0x73, 0x89, 0x13, 0x7B, 0xCE, 0xFE, 0xDB, 0x83, 0x80,
  0xAF, 0x30, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30,
  0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC,
  0x06, 0x30, 0x3F, 0xFF, 0xC0, 0x64, 0x81, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x27, 0x10, 0x60, 0xCF,
  0xF9, 0x0D, 0x06, 0x76, 0x03, 0x0D, 0xFC, 0x0E, 0x04, 0x77, 0x20, 0xCF, 0xC0, 0xD7, 0x73, 0x0C,
  0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7,
  0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF,
  0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77,
  0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC,
  0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73,
  0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0,
  0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30,
  0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D,
  0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C,
  0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7,
  0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF,
  0xC0, 0xD7, 0x73, 0x0C, 0xFC, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xD7, 0x72, 0x05, 0x0E, 0xFC, 0x0E,
  0x05, 0x75, 0x81, 0x17, 0xDF, 0xF9, 0x81, 0xE8, 0x27, 0x03, 0x0A, 0xFF, 0xF0, 0xA0, 0x44, 0x04,
  0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0,
  0x63, 0x04, 0xFF, 0xFC, 0x06, 0x30, 0x4F, 0xFF, 0xC0, 0x63, 0x04, 0xFF, 0xFC, 0x06, 0x20,
  // "ĭ" (U+012D)
  0x03, 0x80, 0x27, 0x06, 0x77, 0x80, 0x37, 0x01, 0x04, 0xE0, 0xE7, 0x60, 0x3F, 0x01, 0x03, 0xF0,
  0x37, 0x50, 0x7F, 0x10, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD2, 0x0E, 0xF0, 0x87, 0x20, 0x20,
  0xCF, 0x09, 0x20, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0, 0x52, 0x05, 0xFF, 0xFC,
  0x0E, 0x01, 0x30, 0xDF, 0xFF, 0xB0, 0x84, 0x06, 0xFF, 0xFA, 0x0E, 0x60, 0xCF, 0xFF, 0x90, 0x46,
  0x02, 0x0E, 0xFF, 0xE0, 0x67, 0x10, 0x30, 0xEF, 0xFC, 0x06, 0x73, 0x01, 0x0C, 0xFF, 0x90, 0xD0,
  0x37, 0x60, 0x50, 0xCF, 0xC0, 0xE0, 0x67, 0x73, 0x89, 0x13, 0x7B, 0xCE, 0xFE, 0xDB, 0x83, 0x80,
  0xB8, 0x20, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30,
  0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E,
  0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05,
  0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7,
  0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F,
  0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77,
  0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC,
  0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73,
  0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0,
  0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30,
  0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E,
  0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05,
  0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7,
  0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x72,
  // "Į" (U+012E)
  0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06,
  0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x03, 0xFF, 0xFC, 0x83,
  0x60, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x25, 0x06, 0x0C, 0xFF, 0x90, 0xD0, 0x67, 0x30, 0x30, 0xDF,
  0xC0, 0xE0, 0x47, 0x60, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70,
  0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x70, 0xCF, 0xC0, 0xD7, 0x60,
  0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x28, 0x11, 0x7D, 0xFF, 0x98, 0x1E, 0x82, 0x40, 0x30, 0xAF, 0xFF,
  0x82, 0xA4, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF,
  0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x04, 0xFF, 0xFC, 0x06, 0x77, 0x10,
  0xBF, 0x05, 0x77, 0x30, 0xCF, 0x06, 0x77, 0x30, 0xAF, 0x08, 0x77, 0x30, 0x7F, 0x0C, 0x77, 0x30,
  0x3F, 0x90, 0x27, 0x73, 0x0C, 0xF0, 0x97, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x30, 0xAF, 0x0E, 0x77,
  0x4F, 0x90, 0xC7, 0x73, 0x03, 0xF9, 0x0D, 0x77, 0x30, 0x5F, 0xA7, 0x73, 0x05, 0xFA, 0x07, 0x77,
  0x20, 0x4F, 0xB8, 0x58, 0x10, 0x14, 0x93, 0x72, 0x03, 0xFF, 0xA0, 0x37, 0x30, 0xEF, 0xF9, 0x03,
  0x73, 0x09, 0xFF, 0x90, 0x37, 0x30, 0x2F, 0xF9, 0x03, 0x74, 0x07, 0xFF, 0x03, 0x75, 0x08, 0xFE,
  0x03, 0x76, 0x04, 0x0D, 0xFC, 0x03, 0x77, 0x18, 0x91, 0x48, 0xCD, 0xEF, 0xEC, 0xA6, 0x11,
  // "į" (U+012F)
  0x78, 0x66, 0xBE, 0xFE, 0xD9, 0x37, 0x10, 0x20, 0xDF, 0x90, 0x87, 0x0D, 0xFB, 0x06, 0x50, 0x5F,
  0xC0, 0xE5, 0x0A, 0xFD, 0x03, 0x40, 0xCF, 0xD0, 0x54, 0x0D, 0xFD, 0x06, 0x40, 0xCF, 0xD0, 0x54,
  0x0A, 0xFD, 0x03, 0x40, 0x5F, 0xC0, 0xE6, 0x0C, 0xFB, 0x06, 0x60, 0x10, 0xCF, 0x90, 0x87, 0x28,
  0x65, 0xBE, 0xFE, 0xD9, 0x38, 0x09, 0xD7, 0x00, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F,
  0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5,
  0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC,
  0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50,
  0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0,
  0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05,
  0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E,
  0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F,
  0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5,
  0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC,
  0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50, 0x5F, 0xC0, 0xE5, 0x05, 0xFC, 0x0E, 0x50,
  0x5F, 0xC0, 0xE7, 0x0B, 0xF0, 0x57, 0x10, 0xCF, 0x06, 0x71, 0x0A, 0xF0, 0x87, 0x10, 0x7F, 0x0C,
  0x71, 0x03, 0xF9, 0x02, 0x71, 0x0C, 0xF0, 0x97, 0x10, 0x4F, 0x90, 0x37, 0x10, 0xAF, 0x0E, 0x72,
  0xF9, 0x0C, 0x71, 0x03, 0xF9, 0x0D, 0x71, 0x05, 0xFA, 0x71, 0x05, 0xFA, 0x07, 0x70, 0x4F, 0xB8,
  0x68, 0x10, 0x14, 0x93, 0x3F, 0xFA, 0x81, 0x30, 0xEF, 0xF9, 0x81, 0x30, 0x9F, 0xF9, 0x81, 0x30,
  0x2F, 0xF9, 0x03, 0x20, 0x7F, 0xF0, 0x33, 0x08, 0xFE, 0x03, 0x40, 0x40, 0xDF, 0xC0, 0x36, 0x89,
  0x14, 0x8C, 0xDE, 0xFE, 0xCA, 0x61, 0x10,
  // "İ" (U+0130)
  0x73, 0x86, 0x39, 0xDE, 0xFE, 0xB6, 0x77, 0x40, 0x8F, 0x90, 0xD0, 0x27, 0x71, 0x06, 0xFB, 0x0D,
  0x77, 0x10, 0xEF, 0xC0, 0x67, 0x60, 0x3F, 0xD0, 0xA7, 0x60, 0x5F, 0xD0, 0xD7, 0x60, 0x6F, 0xD0,
  0xE7, 0x60, 0x5F, 0xD0, 0xD7, 0x60, 0x2F, 0xD0, 0xA7, 0x70, 0xDF, 0xC0, 0x67, 0x70, 0x5F, 0xB0,
  0xC7, 0x72, 0x07, 0xF9, 0x0C, 0x01, 0x77, 0x38, 0x62, 0x8C, 0xEF, 0xEB, 0x58, 0x0A, 0xC7, 0x00,
  0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60,
  0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x3F, 0xFF, 0xC8, 0x36,
  0x02, 0x8E, 0xFF, 0xD8, 0x1E, 0x92, 0x50, 0x60, 0xCF, 0xF9, 0x0D, 0x06, 0x73, 0x03, 0x0D, 0xFC,
  0x0E, 0x04, 0x76, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C,
  0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x77, 0x0C, 0xFC, 0x0D, 0x76, 0x05,
  0x0E, 0xFC, 0x0E, 0x05, 0x72, 0x81, 0x17, 0xDF, 0xF9, 0x81, 0xE8, 0x24, 0x03, 0x0A, 0xFF, 0xF8,
  0x2A, 0x40, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF,
  0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60, 0x4F, 0xFF, 0xC0, 0x60,
  // "ı" (U+0131)
  0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05,
  0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC,
  0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E,
  0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05,
  0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC,
  0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E,
  0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05,
  0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC,
  0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E, 0x05, 0xFC, 0x0E,
  0x05, 0xFC, 0x0E,
  // "Ĳ" (U+0132)
  0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02,
  0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02,
  0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02,
  0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x03, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x83,
  0x20, 0x28, 0xEF, 0xFD, 0x81, 0xE9, 0x27, 0x20, 0x8F, 0xD0, 0x24, 0x06, 0x0C, 0xFF, 0x90, 0xD0,
  0x67, 0x50, 0x8F, 0xD0, 0x26, 0x03, 0x0D, 0xFC, 0x0E, 0x04, 0x77, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF, 0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x70, 0xCF,
  0xC0, 0xD7, 0x71, 0x08, 0xFD, 0x02, 0x60, 0x50, 0xEF, 0xC0, 0xE0, 0x57, 0x70, 0x8F, 0xD0, 0x23,
  0x81, 0x17, 0xDF, 0xF9, 0x81, 0xE8, 0x27, 0x40, 0x8F, 0xD8, 0x22, 0x03, 0xAF, 0xFF, 0x0A, 0x04,
  0x72, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06,
  0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06,
  0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x02, 0x04, 0xFF, 0xFC, 0x06,
  0x71, 0x08, 0xFD, 0x01, 0x04, 0xFF, 0xFC, 0x06, 0x71, 0x08, 0xFD, 0x01, 0x77, 0x77, 0x70, 0x9F,
  0xD8, 0x0C, 0x00, 0x0B, 0xFC, 0x0E, 0x80, 0xC0, 0x00, 0xDF, 0xC0, 0xC8, 0x0C, 0x00, 0xFD, 0x0B,
  0x77, 0x77, 0x70, 0x4F, 0xD0, 0x87, 0x77, 0x77, 0x0A, 0xFD, 0x05, 0x77, 0x77, 0x60, 0x3F, 0xE0,
  0x27, 0x77, 0x75, 0x03, 0x0E, 0xFD, 0x0D, 0x77, 0x74, 0x87, 0x7C, 0x85, 0x32, 0x35, 0xAF, 0xF0,
  0x87, 0x77, 0x40, 0x7F, 0xFF, 0x90, 0x37, 0x77, 0x40, 0x7F, 0xFF, 0x0B, 0x77, 0x75, 0x07, 0xFF,
  0xF0, 0x37, 0x77, 0x50, 0x7F, 0xFE, 0x0A, 0x77, 0x76, 0x07, 0xFF, 0xD0, 0xD7, 0x77, 0x70, 0x7F,
  0xFC, 0x0E, 0x02, 0x77, 0x77, 0x07, 0xFF, 0xB0, 0xD0, 0x27, 0x77, 0x71, 0x07, 0xFF, 0xA0, 0x87,
  0x77, 0x73, 0x07, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x74, 0x89, 0x41, 0x59, 0xBC, 0xDE, 0xFE, 0xEC,
  0xA7, 0x37, 0x50,
  // "ĳ" (U+0133)
  0x38, 0x66, 0xBE, 0xFE, 0xD9, 0x37, 0x72, 0x86, 0x6B, 0xEF, 0xED, 0x93, 0x40, 0x20, 0xDF, 0x90,
  0x87, 0x60, 0x20, 0xDF, 0x90, 0x83, 0x0D, 0xFB, 0x06, 0x75, 0x0D, 0xFB, 0x81, 0x60, 0x5F, 0xC0,
  0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x0A, 0xFD, 0x03, 0x73, 0x0A, 0xFD, 0x03, 0x0C, 0xFD, 0x05, 0x73,
  0x0C, 0xFD, 0x05, 0x0D, 0xFD, 0x06, 0x73, 0x0D, 0xFD, 0x06, 0x0C, 0xFD, 0x05, 0x73, 0x0C, 0xFD,
  0x05, 0x0A, 0xFD, 0x03, 0x73, 0x0A, 0xFD, 0x03, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x0E, 0x20,
  0xCF, 0xB0, 0x67, 0x50, 0xCF, 0xB0, 0x62, 0x01, 0x0C, 0xF9, 0x08, 0x76, 0x01, 0x0C, 0xF9, 0x08,
  0x58, 0x65, 0xBE, 0xFE, 0xD9, 0x37, 0x72, 0x86, 0x5B, 0xEF, 0xED, 0x93, 0x80, 0xBC, 0x30, 0x05,
  0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC,
  0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E,
  0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74,
  0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05,
  0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC,
  0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81,
  0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0,
  0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F,
  0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0,
  0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7,
  0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40,
  0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F,
  0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8,
  0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E,
  0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05,
  0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC,
  0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E,
  0x74, 0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74,
  0x05, 0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05,
  0xFC, 0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC,
  0x81, 0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81,
  0xE0, 0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x81, 0xE0,
  0x5F, 0xC0, 0xE7, 0x40, 0x5F, 0xC8, 0x1E, 0x05, 0xFC, 0x0E, 0x74, 0x05, 0xFC, 0x0E, 0x77, 0x74,
  0x05, 0xFC, 0x0E, 0x77, 0x74, 0x05, 0xFC, 0x0E, 0x77, 0x74, 0x05, 0xFC, 0x0E, 0x77, 0x74, 0x05,
  0xFC, 0x0E, 0x77, 0x74, 0x05, 0xFC, 0x0E, 0x77, 0x74, 0x05, 0xFC, 0x0E, 0x77, 0x74, 0x06, 0xFC,
  0x0D, 0x77, 0x74, 0x08, 0xFC, 0x0C, 0x77, 0x74, 0x0B, 0xFC, 0x0B, 0x77, 0x73, 0x02, 0xFD, 0x0A,
  0x77, 0x73, 0x0C, 0xFD, 0x07, 0x77, 0x28, 0x67, 0xA6, 0x43, 0x36, 0xDF, 0xE0, 0x47, 0x72, 0x08,
  0xFF, 0xE0, 0x17, 0x72, 0x08, 0xFF, 0xD0, 0xB7, 0x73, 0x08, 0xFF, 0xD0, 0x47, 0x73, 0x08, 0xFF,
  0xC0, 0xD7, 0x74, 0x08, 0xFF, 0xC0, 0x37, 0x74, 0x08, 0xFF, 0xB0, 0x87, 0x75, 0x08, 0xFF, 0xA0,
  0xA7, 0x76, 0x08, 0xFF, 0x90, 0x87, 0x77, 0x08, 0xFE, 0x0A, 0x02, 0x77, 0x71, 0x85, 0x14, 0x7A,
  0xCD, 0xEA, 0x83, 0xEC, 0x96, 0x17, 0x20,
  // "Ĵ" (U+0134)
  0x75, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x09, 0xFD, 0x0B, 0x77, 0x60, 0x3F, 0xF0, 0x47, 0x75,
  0x0C, 0xFF, 0x0D, 0x77, 0x40, 0x7F, 0xFA, 0x08, 0x77, 0x20, 0x3F, 0xFC, 0x03, 0x77, 0x10, 0xDF,
  0xFC, 0x0D, 0x77, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x50, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05,
  0x73, 0x01, 0x0E, 0xFA, 0x04, 0x20, 0x4F, 0xA0, 0xE0, 0x27, 0x20, 0xBF, 0xA0, 0x44, 0x05, 0xFA,
  0x0C, 0x71, 0x08, 0xFA, 0x04, 0x60, 0x4F, 0xA0, 0x96, 0x04, 0xF9, 0x0E, 0x04, 0x71, 0x03, 0x0E,
  0xF9, 0x06, 0x40, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x30, 0x6F, 0x0C, 0x01,
  0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xE7, 0x00, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77,
  0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD,
  0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77,
  0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0,
  0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70,
  0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02,
  0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08,
  0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27,
  0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F,
  0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77,
  0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD,
  0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77,
  0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0,
  0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70,
  0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02,
  0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08,
  0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27,
  0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F, 0xD0, 0x27, 0x77, 0x08, 0xFD, 0x02, 0x77, 0x70, 0x8F,
  0xD0, 0x17, 0x77, 0x08, 0xFD, 0x01, 0x77, 0x70, 0x9F, 0xD7, 0x77, 0x10, 0xBF, 0xC0, 0xE7, 0x77,
  0x10, 0xDF, 0xC0, 0xC7, 0x77, 0x1F, 0xD0, 0xB7, 0x77, 0x04, 0xFD, 0x08, 0x77, 0x70, 0xAF, 0xD0,
  0x57, 0x76, 0x03, 0xFE, 0x02, 0x77, 0x50, 0x30, 0xEF, 0xD0, 0xD7, 0x48, 0x77, 0xC8, 0x53, 0x23,
  0x5A, 0xFF, 0x08, 0x74, 0x07, 0xFF, 0xF9, 0x03, 0x74, 0x07, 0xFF, 0xF0, 0xB7, 0x50, 0x7F, 0xFF,
  0x03, 0x75, 0x07, 0xFF, 0xE0, 0xA7, 0x60, 0x7F, 0xFD, 0x0D, 0x77, 0x07, 0xFF, 0xC0, 0xE0, 0x27,
  0x70, 0x7F, 0xFB, 0x0D, 0x02, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x77, 0x30, 0x7F, 0xE8, 0x1E, 0x82,
  0x77, 0x48, 0x94, 0x15, 0x9B, 0xCD, 0xEF, 0xEE, 0xCA, 0x73, 0x77, 0x70,
  // "ĵ" (U+0135)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x74, 0x09, 0xFD, 0x0B, 0x77, 0x30, 0x3F, 0xF0, 0x47, 0x72,
  0x0C, 0xFF, 0x0D, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x76, 0x03, 0xFF, 0xC0, 0x37, 0x50, 0xDF, 0xFC,
  0x0D, 0x74, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x20, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x70,
  0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x60, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x50,
  0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x98, 0x26,
  0x02, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xAC, 0x50, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75,
  0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0,
  0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50,
  0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x6F, 0xC0, 0xD7, 0x75,
  0x08, 0xFC, 0x0C, 0x77, 0x50, 0xBF, 0xC0, 0xB7, 0x74, 0x01, 0xFD, 0x09, 0x77, 0x40, 0xBF, 0xD0,
  0x67, 0x38, 0x67, 0xA6, 0x43, 0x36, 0xCF, 0xE0, 0x37, 0x30, 0x8F, 0xFD, 0x0E, 0x74, 0x08, 0xFF,
  0xD0, 0x87, 0x40, 0x8F, 0xFD, 0x02, 0x74, 0x08, 0xFF, 0xC0, 0xA7, 0x50, 0x8F, 0xFB, 0x0E, 0x01,
  0x75, 0x08, 0xFF, 0xB0, 0x57, 0x60, 0x8F, 0xFA, 0x07, 0x77, 0x08, 0xFF, 0x0E, 0x05, 0x77, 0x10,
  0x8F, 0xE0, 0x90, 0x17, 0x72, 0x85, 0x15, 0x8A, 0xCE, 0xEA, 0x82, 0xEC, 0x95, 0x77, 0x50,
  // "Ķ" (U+0136)
  0x08, 0xFD, 0x02, 0x77, 0x20, 0xBF, 0xD8, 0x1E, 0x28, 0xFD, 0x02, 0x77, 0x10, 0x5F, 0xE8, 0x17,
  0x08, 0xFD, 0x02, 0x77, 0x01, 0x0E, 0xFD, 0x0D, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0x9F, 0xE0, 0x42,
  0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x09, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0xCF, 0xD0, 0xE0, 0x13,
  0x08, 0xFD, 0x02, 0x75, 0x06, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27, 0x40, 0x10, 0xEF, 0xD0, 0xC5,
  0x08, 0xFD, 0x02, 0x74, 0x09, 0xFE, 0x03, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x3F, 0xE0, 0x86, 0x08,
  0xFD, 0x02, 0x73, 0x0C, 0xFD, 0x0E, 0x70, 0x8F, 0xD0, 0x27, 0x20, 0x6F, 0xE0, 0x57, 0x08, 0xFD,
  0x02, 0x71, 0x01, 0x0E, 0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x0A, 0xFE, 0x02, 0x71, 0x08,
  0xFD, 0x02, 0x70, 0x4F, 0xE0, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x0D, 0xFD, 0x0D, 0x73, 0x08, 0xFD,
  0x02, 0x60, 0x7F, 0xE0, 0x47, 0x30, 0x8F, 0xD0, 0x25, 0x01, 0x0E, 0xFD, 0x0A, 0x74, 0x08, 0xFD,
  0x02, 0x50, 0xAF, 0xD0, 0xE0, 0x17, 0x40, 0x8F, 0xD0, 0x24, 0x04, 0xFE, 0x06, 0x75, 0x08, 0xFD,
  0x02, 0x40, 0xDF, 0xD0, 0xC7, 0x60, 0x8F, 0xD0, 0x23, 0x07, 0xFE, 0x03, 0x76, 0x08, 0xFD, 0x02,
  0x20, 0x1F, 0xE0, 0x97, 0x70, 0x8F, 0xD0, 0x22, 0x0A, 0xFD, 0x0E, 0x01, 0x77, 0x08, 0xFD, 0x81,
  0x20, 0x3F, 0xE0, 0x57, 0x71, 0x08, 0xFD, 0x81, 0x20, 0xCF, 0xD0, 0xB7, 0x72, 0x08, 0xFD, 0x02,
  0x05, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xD0, 0x20, 0xCF, 0xD0, 0x87, 0x73, 0x08, 0xFD, 0x06, 0xFD,
  0x0D, 0x77, 0x40, 0x8F, 0xD0, 0xDF, 0xD0, 0xE7, 0x74, 0x08, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x8F,
  0xFF, 0xD0, 0xE7, 0x73, 0x08, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0x8F, 0xFF, 0xE0, 0xE0, 0x17, 0x71,
  0x08, 0xFF, 0xFF, 0x08, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0xE0, 0x17, 0x70, 0x8F, 0xFF, 0xF9, 0x08,
  0x77, 0x08, 0xFF, 0xFF, 0x90, 0xE0, 0x17, 0x60, 0x8F, 0xF9, 0x0D, 0x04, 0xFE, 0x08, 0x76, 0x08,
  0xFF, 0x82, 0xC1, 0x09, 0xFE, 0x01, 0x75, 0x08, 0xFE, 0x09, 0x30, 0x2F, 0xE0, 0x97, 0x50, 0x8F,
  0xD0, 0x75, 0x09, 0xFE, 0x01, 0x74, 0x08, 0xFD, 0x02, 0x50, 0x2F, 0xE0, 0x97, 0x40, 0x8F, 0xD0,
  0x26, 0x0A, 0xFE, 0x02, 0x73, 0x08, 0xFD, 0x02, 0x60, 0x2F, 0xE0, 0x97, 0x30, 0x8F, 0xD0, 0x27,
  0x0A, 0xFE, 0x02, 0x72, 0x08, 0xFD, 0x02, 0x70, 0x2F, 0xE0, 0xA7, 0x20, 0x8F, 0xD0, 0x27, 0x10,
  0xAF, 0xE0, 0x27, 0x10, 0x8F, 0xD0, 0x27, 0x10, 0x3F, 0xE0, 0xA7, 0x10, 0x8F, 0xD0, 0x27, 0x20,
  0xBF, 0xE0, 0x27, 0x08, 0xFD, 0x02, 0x72, 0x03, 0xFE, 0x0A, 0x70, 0x8F, 0xD0, 0x27, 0x30, 0xBF,
  0xE0, 0x36, 0x08, 0xFD, 0x02, 0x73, 0x03, 0xFE, 0x0B, 0x60, 0x8F, 0xD0, 0x27, 0x40, 0xBF, 0xE0,
  0x35, 0x08, 0xFD, 0x02, 0x74, 0x04, 0xFE, 0x0B, 0x50, 0x8F, 0xD0, 0x27, 0x50, 0xCF, 0xE0, 0x34,
  0x08, 0xFD, 0x02, 0x75, 0x04, 0xFE, 0x0B, 0x40, 0x8F, 0xD0, 0x27, 0x60, 0xCF, 0xE0, 0x43, 0x08,
  0xFD, 0x02, 0x76, 0x05, 0xFE, 0x0B, 0x30, 0x8F, 0xD0, 0x27, 0x70, 0xCF, 0xE0, 0x42, 0x08, 0xFD,
  0x02, 0x77, 0x05, 0xFE, 0x0C, 0x20, 0x8F, 0xD0, 0x27, 0x71, 0x0D, 0xFE, 0x81, 0x40, 0x8F, 0xD0,
  0x27, 0x71, 0x05, 0xFE, 0x81, 0xC0, 0x8F, 0xD0, 0x27, 0x72, 0x0D, 0xFE, 0x05, 0x80, 0xCB, 0x10,
  0x01, 0xFC, 0x09, 0x77, 0x77, 0x40, 0x3F, 0xC0, 0x77, 0x77, 0x74, 0x05, 0xFC, 0x01, 0x77, 0x77,
  0x40, 0x7F, 0xB0, 0xB7, 0x77, 0x75, 0x09, 0xFB, 0x05, 0x77, 0x77, 0x50, 0xCF, 0xA0, 0xD7, 0x77,
  0x76, 0xFB, 0x06, 0x77, 0x77, 0x50, 0x2F, 0xA0, 0xE7, 0x77, 0x76, 0x05, 0xFA, 0x07, 0x77, 0x77,
  0x60, 0x8F, 0x90, 0xE7, 0x77, 0x77, 0x0B, 0xF9, 0x06, 0x77, 0x77, 0x70, 0xEF, 0x0D, 0x77, 0x77,
  0x70, 0x3F, 0x90, 0x37, 0x77, 0x77, 0x04, 0xF0, 0xA7, 0x77, 0x20,
  // "ķ" (U+0137)
  0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77,
  0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77,
  0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77,
  0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7,
  0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C,
  0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0,
  0xC7, 0x77, 0x71, 0x05, 0xFC, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x70, 0xCF, 0xD8, 0x18,
  0x05, 0xFC, 0x0C, 0x76, 0x08, 0xFD, 0x0C, 0x20, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xD0, 0xE0, 0x22,
  0x05, 0xFC, 0x0C, 0x75, 0x0D, 0xFD, 0x06, 0x30, 0x5F, 0xC0, 0xC7, 0x40, 0x9F, 0xD0, 0xA4, 0x05,
  0xFC, 0x0C, 0x73, 0x04, 0xFD, 0x0D, 0x01, 0x40, 0x5F, 0xC0, 0xC7, 0x30, 0xDF, 0xD0, 0x45, 0x05,
  0xFC, 0x0C, 0x72, 0x09, 0xFD, 0x08, 0x60, 0x5F, 0xC0, 0xC7, 0x10, 0x4F, 0xD0, 0xC7, 0x05, 0xFC,
  0x0C, 0x70, 0x10, 0xEF, 0xC0, 0xE0, 0x27, 0x05, 0xFC, 0x0C, 0x70, 0xAF, 0xD0, 0x67, 0x10, 0x5F,
  0xC0, 0xC6, 0x05, 0xFD, 0x0A, 0x72, 0x05, 0xFC, 0x0C, 0x50, 0x10, 0xEF, 0xC0, 0xD0, 0x17, 0x20,
  0x5F, 0xC0, 0xB5, 0x0B, 0xFD, 0x04, 0x73, 0x05, 0xFC, 0x0B, 0x40, 0x6F, 0xD0, 0x87, 0x40, 0x5F,
  0xC0, 0xB3, 0x02, 0x0E, 0xFC, 0x0C, 0x75, 0x05, 0xFC, 0x0A, 0x30, 0xBF, 0xC0, 0xE0, 0x27, 0x50,
  0x5F, 0xC0, 0xA2, 0x05, 0xFD, 0x06, 0x76, 0x05, 0xFC, 0x82, 0x80, 0x1E, 0xFC, 0x0A, 0x77, 0x05,
  0xFC, 0x81, 0x70, 0x8F, 0xC0, 0xE0, 0x17, 0x70, 0x5F, 0xC0, 0x60, 0x2F, 0xD0, 0x47, 0x71, 0x05,
  0xFC, 0x05, 0x0A, 0xFD, 0x06, 0x77, 0x10, 0x5F, 0xC0, 0x9F, 0xE0, 0xE7, 0x71, 0x05, 0xFF, 0xFD,
  0x08, 0x77, 0x05, 0xFF, 0xFE, 0x01, 0x76, 0x05, 0xFF, 0xFE, 0x09, 0x76, 0x05, 0xFF, 0xFF, 0x03,
  0x75, 0x05, 0xFF, 0xFF, 0x0B, 0x75, 0x05, 0xFF, 0xFF, 0x90, 0x47, 0x40, 0x5F, 0xFA, 0x08, 0xFD,
  0x0C, 0x74, 0x05, 0xFF, 0x98, 0x15, 0x08, 0xFD, 0x06, 0x73, 0x05, 0xFE, 0x0E, 0x03, 0x20, 0x10,
  0xEF, 0xC0, 0xE7, 0x30, 0x5F, 0xD0, 0xD0, 0x24, 0x07, 0xFD, 0x07, 0x72, 0x05, 0xFC, 0x0E, 0x01,
  0x60, 0xEF, 0xC0, 0xE0, 0x17, 0x10, 0x5F, 0xC0, 0xC7, 0x07, 0xFD, 0x09, 0x71, 0x05, 0xFC, 0x0C,
  0x71, 0x0D, 0xFD, 0x02, 0x70, 0x5F, 0xC0, 0xC7, 0x10, 0x6F, 0xD0, 0xB7, 0x05, 0xFC, 0x0C, 0x72,
  0x0D, 0xFD, 0x04, 0x60, 0x5F, 0xC0, 0xC7, 0x20, 0x5F, 0xD0, 0xC6, 0x05, 0xFC, 0x0C, 0x73, 0x0C,
  0xFD, 0x05, 0x50, 0x5F, 0xC0, 0xC7, 0x30, 0x5F, 0xD0, 0xD5, 0x05, 0xFC, 0x0C, 0x74, 0x0C, 0xFD,
  0x07, 0x40, 0x5F, 0xC0, 0xC7, 0x40, 0x4F, 0xD0, 0xE0, 0x13, 0x05, 0xFC, 0x0C, 0x75, 0x0B, 0xFD,
  0x09, 0x30, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xE0, 0x22, 0x05, 0xFC, 0x0C, 0x76, 0x0B, 0xFD, 0x0A,
  0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x2F, 0xE8, 0x13, 0x05, 0xFC, 0x0C, 0x77, 0x0A, 0xFD, 0x81, 0xC0,
  0x5F, 0xC0, 0xC7, 0x70, 0x2F, 0xE0, 0x58, 0x0C, 0x85, 0x00, 0x1F, 0xC0, 0x97, 0x77, 0x71, 0x03,
  0xFC, 0x07, 0x77, 0x77, 0x10, 0x5F, 0xC0, 0x17, 0x77, 0x71, 0x07, 0xFB, 0x0B, 0x77, 0x77, 0x20,
  0x9F, 0xB0, 0x57, 0x77, 0x72, 0x0C, 0xFA, 0x0D, 0x77, 0x77, 0x3F, 0xB0, 0x67, 0x77, 0x72, 0x02,
  0xFA, 0x0E, 0x77, 0x77, 0x30, 0x5F, 0xA0, 0x77, 0x77, 0x73, 0x08, 0xF9, 0x0E, 0x77, 0x77, 0x40,
  0xBF, 0x90, 0x67, 0x77, 0x74, 0x0E, 0xF0, 0xD7, 0x77, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x40,
  0x4F, 0x0A, 0x77, 0x71,
  // "ĸ" (U+0138)
  0x05, 0xFC, 0x0C, 0x77, 0x08, 0xFD, 0x81, 0x80, 0x5F, 0xC0, 0xC7, 0x60, 0x3F, 0xD0, 0xC2, 0x05,
  0xFC, 0x0C, 0x76, 0x0D, 0xFD, 0x02, 0x20, 0x5F, 0xC0, 0xC7, 0x50, 0x8F, 0xD0, 0x73, 0x05, 0xFC,
  0x0C, 0x74, 0x03, 0xFD, 0x0B, 0x40, 0x5F, 0xC0, 0xC7, 0x40, 0xDF, 0xC0, 0xE0, 0x14, 0x05, 0xFC,
  0x0C, 0x73, 0x08, 0xFD, 0x05, 0x50, 0x5F, 0xC0, 0xC7, 0x20, 0x3F, 0xD0, 0xA6, 0x05, 0xFC, 0x0C,
  0x72, 0x0D, 0xFC, 0x0D, 0x01, 0x60, 0x5F, 0xC0, 0xC7, 0x10, 0x9F, 0xD0, 0x47, 0x05, 0xFC, 0x0C,
  0x70, 0x3F, 0xD0, 0x87, 0x10, 0x5F, 0xC0, 0xC7, 0x0D, 0xFC, 0x0D, 0x72, 0x05, 0xFC, 0x0C, 0x60,
  0x9F, 0xD0, 0x37, 0x20, 0x5F, 0xC0, 0xC5, 0x03, 0xFD, 0x07, 0x73, 0x05, 0xFC, 0x0B, 0x50, 0xDF,
  0xC0, 0xB7, 0x40, 0x5F, 0xC0, 0xB4, 0x09, 0xFC, 0x0E, 0x02, 0x74, 0x05, 0xFC, 0x0B, 0x30, 0x3F,
  0xD0, 0x67, 0x50, 0x5F, 0xC0, 0xB3, 0x0D, 0xFC, 0x0A, 0x76, 0x05, 0xFC, 0x0A, 0x20, 0x7F, 0xC0,
  0xE0, 0x17, 0x60, 0x5F, 0xC8, 0x19, 0x02, 0xFD, 0x04, 0x77, 0x05, 0xFC, 0x81, 0x80, 0xAF, 0xC0,
  0x97, 0x71, 0x05, 0xFC, 0x07, 0x04, 0xFD, 0x05, 0x77, 0x10, 0x5F, 0xC0, 0x60, 0xDF, 0xD0, 0xD7,
  0x71, 0x05, 0xFC, 0x0E, 0xFF, 0x06, 0x77, 0x05, 0xFF, 0xFD, 0x0E, 0x01, 0x76, 0x05, 0xFF, 0xFE,
  0x08, 0x76, 0x05, 0xFF, 0xFF, 0x02, 0x75, 0x05, 0xFF, 0xFF, 0x0A, 0x75, 0x05, 0xFF, 0xFF, 0x90,
  0x37, 0x40, 0x5F, 0xFA, 0x0C, 0x0E, 0xFC, 0x0C, 0x74, 0x05, 0xFF, 0x98, 0x1A, 0x07, 0xFD, 0x05,
  0x73, 0x05, 0xFF, 0x08, 0x30, 0xEF, 0xC0, 0xD7, 0x30, 0x5F, 0xE0, 0x54, 0x07, 0xFD, 0x06, 0x72,
  0x05, 0xFC, 0x0E, 0x03, 0x60, 0xEF, 0xC0, 0xE0, 0x17, 0x10, 0x5F, 0xC0, 0xC7, 0x06, 0xFD, 0x08,
  0x71, 0x05, 0xFC, 0x0C, 0x71, 0x0D, 0xFD, 0x02, 0x70, 0x5F, 0xC0, 0xC7, 0x10, 0x6F, 0xD0, 0xA7,
  0x05, 0xFC, 0x0C, 0x72, 0x0D, 0xFD, 0x03, 0x60, 0x5F, 0xC0, 0xC7, 0x20, 0x5F, 0xD0, 0xC6, 0x05,
  0xFC, 0x0C, 0x73, 0x0C, 0xFD, 0x05, 0x50, 0x5F, 0xC0, 0xC7, 0x30, 0x4F, 0xD0, 0xD5, 0x05, 0xFC,
  0x0C, 0x74, 0x0C, 0xFD, 0x07, 0x40, 0x5F, 0xC0, 0xC7, 0x40, 0x4F, 0xD0, 0xE0, 0x13, 0x05, 0xFC,
  0x0C, 0x75, 0x0B, 0xFD, 0x08, 0x30, 0x5F, 0xC0, 0xC7, 0x50, 0x3F, 0xE0, 0x22, 0x05, 0xFC, 0x0C,
  0x76, 0x0A, 0xFD, 0x0A, 0x20, 0x5F, 0xC0, 0xC7, 0x60, 0x2F, 0xE8, 0x13, 0x05, 0xFC, 0x0C, 0x77,
  0x0A, 0xFD, 0x81, 0xC0, 0x5F, 0xC0, 0xC7, 0x70, 0x2F, 0xE0, 0x50,
  // "Ĺ" (U+0139)
  0x71, 0x06, 0xFE, 0x0B, 0x77, 0x50, 0xEF, 0xE0, 0x37, 0x74, 0x08, 0xFE, 0x05, 0x77, 0x40, 0x2F,
  0xE0, 0x67, 0x75, 0x0B, 0xFD, 0x06, 0x77, 0x50, 0x5F, 0xD0, 0x67, 0x75, 0x01, 0x0E, 0xFC, 0x06,
  0x77, 0x60, 0xAF, 0xC0, 0x57, 0x76, 0x06, 0xFC, 0x05, 0x77, 0x60, 0x10, 0xEF, 0xA0, 0xE0, 0x47,
  0x77, 0x0B, 0xFA, 0x0E, 0x03, 0x77, 0x70, 0x7F, 0xA0, 0xD0, 0x27, 0x77, 0x02, 0xFA, 0x0C, 0x01,
  0x77, 0x71, 0x06, 0xF9, 0x0A, 0x80, 0xAF, 0x70, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27,
  0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F,
  0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77,
  0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD,
  0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76,
  0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0,
  0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60,
  0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02,
  0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08,
  0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27,
  0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F,
  0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77,
  0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD,
  0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76,
  0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0,
  0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F,
  0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F,
  0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F,
  0xFF, 0xFC,
  // "ĺ" (U+013A)
  0x71, 0x06, 0xFE, 0x0B, 0x71, 0x0E, 0xFE, 0x03, 0x70, 0x8F, 0xE0, 0x57, 0x02, 0xFE, 0x06, 0x71,
  0x0B, 0xFD, 0x06, 0x71, 0x05, 0xFD, 0x06, 0x71, 0x01, 0x0E, 0xFC, 0x06, 0x72, 0x0A, 0xFC, 0x05,
  0x72, 0x06, 0xFC, 0x05, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x73, 0x0B, 0xFA, 0x0E, 0x03, 0x73,
  0x07, 0xFA, 0x0D, 0x02, 0x73, 0x02, 0xFA, 0x0C, 0x01, 0x74, 0x06, 0xF9, 0x0A, 0x80, 0x9F, 0x50,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73,
  0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x73, 0x05, 0xFC, 0x0C, 0x72,
  // "Ļ" (U+013B)
  0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0,
  0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50,
  0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02,
  0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08,
  0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27,
  0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F,
  0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77,
  0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD,
  0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75,
  0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0,
  0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50,
  0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02,
  0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08,
  0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27,
  0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x02, 0x77, 0x50, 0x8F,
  0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC,
  0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF, 0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x08, 0xFF,
  0xFF, 0xC0, 0x8F, 0xFF, 0xFC, 0x80, 0xB9, 0x50, 0x01, 0xFC, 0x09, 0x77, 0x60, 0x3F, 0xC0, 0x77,
  0x76, 0x05, 0xFC, 0x01, 0x77, 0x60, 0x7F, 0xB0, 0xB7, 0x77, 0x09, 0xFB, 0x05, 0x77, 0x70, 0xCF,
  0xA0, 0xD7, 0x77, 0x1F, 0xB0, 0x67, 0x77, 0x02, 0xFA, 0x0E, 0x77, 0x71, 0x05, 0xFA, 0x07, 0x77,
  0x71, 0x08, 0xF9, 0x0E, 0x77, 0x72, 0x0B, 0xF9, 0x06, 0x77, 0x72, 0x0E, 0xF0, 0xD7, 0x77, 0x20,
  0x3F, 0x90, 0x37, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x10,
  // "ļ" (U+013C)
  0x10, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F,
  0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2,
  0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC,
  0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20,
  0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0,
  0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05,
  0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C,
  0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F,
  0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2,
  0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC,
  0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20,
  0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0,
  0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05,
  0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C,
  0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x20, 0x5F, 0xC0, 0xC2, 0x05, 0xFC, 0x0C, 0x80, 0x9B,
  0x10, 0x01, 0xFC, 0x09, 0x20, 0x3F, 0xC0, 0x72, 0x05, 0xFC, 0x01, 0x20, 0x7F, 0xB0, 0xB3, 0x09,
  0xFB, 0x05, 0x30, 0xCF, 0xA0, 0xD4, 0xFB, 0x06, 0x30, 0x2F, 0xA0, 0xE4, 0x05, 0xFA, 0x07, 0x40,
  0x8F, 0x90, 0xE5, 0x0B, 0xF9, 0x06, 0x50, 0xEF, 0x0D, 0x50, 0x3F, 0x90, 0x35, 0x04, 0xF0, 0xA6,
  // "Ľ" (U+013D)
  0x08, 0xFD, 0x02, 0x73, 0x01, 0xFC, 0x09, 0x08, 0xFD, 0x02, 0x73, 0x03, 0xFC, 0x07, 0x08, 0xFD,
  0x02, 0x73, 0x05, 0xFC, 0x01, 0x08, 0xFD, 0x02, 0x73, 0x07, 0xFB, 0x81, 0xB0, 0x8F, 0xD0, 0x27,
  0x30, 0xAF, 0xB8, 0x15, 0x08, 0xFD, 0x02, 0x73, 0x0C, 0xFA, 0x0E, 0x20, 0x8F, 0xD0, 0x27, 0x3F,
  0xB0, 0x72, 0x08, 0xFD, 0x02, 0x72, 0x02, 0xFB, 0x01, 0x20, 0x8F, 0xD0, 0x27, 0x20, 0x4F, 0xA0,
  0x83, 0x08, 0xFD, 0x02, 0x72, 0x07, 0xF9, 0x0E, 0x01, 0x30, 0x8F, 0xD0, 0x27, 0x20, 0xAF, 0x90,
  0x84, 0x08, 0xFD, 0x02, 0x72, 0x0D, 0xF0, 0xE0, 0x14, 0x08, 0xFD, 0x02, 0x72, 0xF9, 0x06, 0x50,
  0x8F, 0xD0, 0x27, 0x10, 0x1F, 0x0C, 0x60, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77,
  0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20,
  0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F,
  0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0,
  0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27,
  0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77,
  0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20,
  0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F,
  0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0,
  0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27,
  0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77,
  0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20,
  0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xD0, 0x27, 0x77, 0x20, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF,
  0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF,
  0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40, 0x8F, 0xFF,
  0xFC, 0x40, 0x8F, 0xFF, 0xFC, 0x40,
  // "ľ" (U+013E)
  0x05, 0xFC, 0x0C, 0x40, 0x1F, 0xC0, 0x90, 0x5F, 0xC0, 0xC4, 0x03, 0xFC, 0x07, 0x05, 0xFC, 0x0C,
  0x40, 0x5F, 0xC0, 0x10, 0x5F, 0xC0, 0xC4, 0x07, 0xFB, 0x81, 0xB0, 0x5F, 0xC0, 0xC4, 0x0A, 0xFB,
  0x81, 0x50, 0x5F, 0xC0, 0xC4, 0x0C, 0xFA, 0x0E, 0x20, 0x5F, 0xC0, 0xC4, 0xFB, 0x07, 0x20, 0x5F,
  0xC0, 0xC3, 0x02, 0xFB, 0x01, 0x20, 0x5F, 0xC0, 0xC3, 0x04, 0xFA, 0x08, 0x30, 0x5F, 0xC0, 0xC3,
  0x07, 0xF9, 0x0E, 0x01, 0x30, 0x5F, 0xC0, 0xC3, 0x0A, 0xF9, 0x08, 0x40, 0x5F, 0xC0, 0xC3, 0x0D,
  0xF0, 0xE0, 0x14, 0x05, 0xFC, 0x0C, 0x3F, 0x90, 0x65, 0x05, 0xFC, 0x0C, 0x20, 0x1F, 0x0C, 0x60,
  0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C,
  0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05,
  0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7,
  0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F,
  0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77,
  0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC,
  0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73,
  0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0,
  0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30,
  0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C,
  0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05,
  0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7,
  0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F,
  0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77,
  0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC, 0x0C, 0x77, 0x30, 0x5F, 0xC0, 0xC7, 0x73, 0x05, 0xFC,
  0x0C, 0x77, 0x30,
  // "Ŀ" (U+013F)
  0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0,
  0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60,
  0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02,
  0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08,
  0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27,
  0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F,
  0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x28, 0x63, 0x9D, 0xEF, 0xEB,
  0x63, 0x08, 0xFD, 0x02, 0x71, 0x08, 0xF9, 0x82, 0xD2, 0x08, 0xFD, 0x02, 0x70, 0x6F, 0xB8, 0x1D,
  0x08, 0xFD, 0x02, 0x70, 0xEF, 0xC0, 0x60, 0x8F, 0xD0, 0x26, 0x03, 0xFD, 0x0A, 0x08, 0xFD, 0x02,
  0x60, 0x5F, 0xD0, 0xD0, 0x8F, 0xD0, 0x26, 0x06, 0xFD, 0x0E, 0x08, 0xFD, 0x02, 0x60, 0x5F, 0xD0,
  0xD0, 0x8F, 0xD0, 0x26, 0x02, 0xFD, 0x0A, 0x08, 0xFD, 0x02, 0x70, 0xDF, 0xC0, 0x60, 0x8F, 0xD0,
  0x27, 0x05, 0xFB, 0x81, 0xC0, 0x8F, 0xD0, 0x27, 0x10, 0x7F, 0x98, 0x2C, 0x10, 0x8F, 0xD0, 0x27,
  0x28, 0x62, 0x8C, 0xEF, 0xEB, 0x53, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08,
  0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27,
  0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F,
  0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77,
  0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD, 0x02, 0x77, 0x60, 0x8F, 0xD0, 0x27, 0x76, 0x08, 0xFD,
  0x02, 0x77, 0x60, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F,
  0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F,
  0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10, 0x8F, 0xFF, 0xFC, 0x10,
  // "ŀ" (U+0140)
  0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0,
  0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20,
  0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C,
  0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05,
  0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7,
  0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F,
  0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77,
  0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC5, 0x86, 0x39, 0xDE,
  0xFE, 0xB6, 0x30, 0x5F, 0xC0, 0xC4, 0x08, 0xF9, 0x82, 0xD2, 0x05, 0xFC, 0x0C, 0x30, 0x6F, 0xB8,
  0x1D, 0x05, 0xFC, 0x0C, 0x30, 0xEF, 0xC0, 0x60, 0x5F, 0xC0, 0xC2, 0x03, 0xFD, 0x0A, 0x05, 0xFC,
  0x0C, 0x20, 0x5F, 0xD0, 0xD0, 0x5F, 0xC0, 0xC2, 0x06, 0xFD, 0x0E, 0x05, 0xFC, 0x0C, 0x20, 0x5F,
  0xD0, 0xD0, 0x5F, 0xC0, 0xC2, 0x02, 0xFD, 0x0A, 0x05, 0xFC, 0x0C, 0x30, 0xDF, 0xC0, 0x60, 0x5F,
  0xC0, 0xC3, 0x05, 0xFB, 0x81, 0xC0, 0x5F, 0xC0, 0xC4, 0x07, 0xF9, 0x82, 0xC1, 0x05, 0xFC, 0x0C,
  0x58, 0x62, 0x8C, 0xEF, 0xEB, 0x53, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05,
  0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7,
  0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F,
  0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77,
  0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC,
  0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72,
  0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0,
  0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0xFC, 0x0C, 0x77, 0x20,
  0x5F, 0xC0, 0xC7, 0x72,
  // "Ł" (U+0141)
  0x71, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76,
  0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06,
  0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD,
  0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03,
  0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x77,
  0x76, 0x06, 0xFD, 0x03, 0x77, 0x76, 0x06, 0xFD, 0x03, 0x60, 0x27, 0x76, 0x06, 0xFD, 0x03, 0x48,
  0x23, 0xDD, 0x17, 0x75, 0x06, 0xFD, 0x03, 0x30, 0x8B, 0x0A, 0x77, 0x50, 0x6F, 0xD8, 0x23, 0x03,
  0xDD, 0x06, 0x77, 0x40, 0x6F, 0xD0, 0x40, 0x8F, 0x0E, 0x02, 0x77, 0x30, 0x6F, 0xD0, 0xEF, 0xA0,
  0xC7, 0x73, 0x06, 0xFF, 0xFA, 0x08, 0x77, 0x20, 0x6F, 0xFF, 0xB0, 0x47, 0x71, 0x06, 0xFF, 0xFA,
  0x0E, 0x05, 0x77, 0x10, 0x6F, 0xFF, 0x90, 0xB0, 0x17, 0x72, 0x06, 0xFF, 0xE0, 0xE0, 0x67, 0x74,
  0x06, 0xFF, 0xD0, 0xC0, 0x27, 0x75, 0x06, 0xFF, 0xC0, 0x77, 0x77, 0x06, 0xFF, 0xA0, 0xD0, 0x37,
  0x77, 0x05, 0x0E, 0xFF, 0x90, 0x87, 0x77, 0x10, 0x9F, 0xF9, 0x0D, 0x04, 0x77, 0x70, 0x30, 0xDF,
  0xF9, 0x0A, 0x01, 0x77, 0x70, 0x7F, 0xFB, 0x03, 0x77, 0x60, 0x20, 0xCF, 0xFC, 0x03, 0x77, 0x50,
  0x50, 0xEF, 0xFD, 0x03, 0x77, 0x50, 0xDF, 0xFE, 0x03, 0x77, 0x50, 0x2F, 0xFE, 0x03, 0x77, 0x60,
  0x6F, 0xFD, 0x03, 0x77, 0x70, 0xAF, 0xFC, 0x03, 0x77, 0x70, 0x10, 0xDF, 0xFB, 0x03, 0x77, 0x71,
  0x03, 0xC0, 0xCF, 0xD0, 0x37, 0x77, 0x28, 0x37, 0xFC, 0x36, 0xFD, 0x03, 0x77, 0x73, 0x06, 0x20,
  0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F,
  0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0,
  0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xD0, 0x37, 0x77, 0x60, 0x6F, 0xFF, 0xFC,
  0x71, 0x06, 0xFF, 0xFF, 0xC7, 0x10, 0x6F, 0xFF, 0xFC, 0x71, 0x06, 0xFF, 0xFF, 0xC7, 0x10, 0x6F,
  0xFF, 0xFC, 0x71, 0x06, 0xFF, 0xFF, 0xC7, 0x10, 0x6F, 0xFF, 0xFC, 0x71, 0x06, 0xFF, 0xFF, 0xC7,
  0x10, 0x6F, 0xFF, 0xFC, 0x71, 0x06, 0xFF, 0xFF, 0xC7, 0x10, 0x6F, 0xFF, 0xFC,
  // "ł" (U+0142)
  0x72, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD,
  0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77,
  0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0,
  0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73,
  0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04,
  0x77, 0x3F, 0xD8, 0x24, 0x01, 0x77, 0x7F, 0xD8, 0x34, 0x3D, 0xF7, 0x76, 0xFD, 0x0B, 0xC0, 0x37,
  0x5F, 0xFB, 0x0D, 0x01, 0x74, 0xFF, 0xC0, 0xB7, 0x4F, 0xFD, 0x07, 0x73, 0xFF, 0xE0, 0x37, 0x2F,
  0xFE, 0x0D, 0x72, 0xFF, 0xD0, 0xE0, 0x47, 0x2F, 0xFC, 0x0B, 0x01, 0x73, 0xFF, 0xB0, 0x77, 0x40,
  0x9F, 0xF9, 0x0D, 0x03, 0x73, 0x02, 0x0C, 0xFF, 0x90, 0xA0, 0x17, 0x30, 0x60, 0xEF, 0xF9, 0x06,
  0x73, 0x01, 0x0A, 0xFF, 0xA0, 0x57, 0x30, 0x30, 0xDF, 0xFB, 0x04, 0x72, 0x07, 0xFF, 0xD0, 0x47,
  0x10, 0x9F, 0xFE, 0x04, 0x71, 0x03, 0xFF, 0xE0, 0x47, 0x20, 0x7F, 0xFD, 0x04, 0x73, 0x0B, 0xFF,
  0xC0, 0x47, 0x30, 0x10, 0xEF, 0xFB, 0x04, 0x74, 0x04, 0xC0, 0xEF, 0xD0, 0x47, 0x50, 0x8A, 0x0B,
  0x01, 0xFD, 0x04, 0x76, 0x0C, 0x07, 0x2F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47,
  0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD,
  0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77,
  0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0,
  0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x73, 0xFD, 0x04, 0x77, 0x3F, 0xD0, 0x47, 0x10,
  // "Ń" (U+0143)
  0x77, 0x74, 0x06, 0xFE, 0x0B, 0x77, 0x77, 0x60, 0xEF, 0xE0, 0x37, 0x77, 0x75, 0x08, 0xFE, 0x05,
  0x77, 0x77, 0x50, 0x2F, 0xE0, 0x67, 0x77, 0x76, 0x0B, 0xFD, 0x06, 0x77, 0x77, 0x60, 0x5F, 0xD0,
  0x67, 0x77, 0x76, 0x01, 0x0E, 0xFC, 0x06, 0x77, 0x77, 0x70, 0xAF, 0xC0, 0x57, 0x77, 0x77, 0x06,
  0xFC, 0x05, 0x77, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xE0, 0x48, 0x0C, 0x00, 0x0B, 0xFA, 0x0E, 0x03,
  0x80, 0xC0, 0x00, 0x7F, 0xA0, 0xD0, 0x28, 0x0C, 0x00, 0x02, 0xFA, 0x0C, 0x01, 0x80, 0xC1, 0x00,
  0x6F, 0x90, 0xA8, 0x0C, 0x87, 0x00, 0x8F, 0xF0, 0xD7, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0x90,
  0x67, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0x90, 0xD7, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xA0,
  0x57, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xA0, 0xC7, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xB0,
  0x47, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xB0, 0xC7, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xC0,
  0x47, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xC0, 0xB7, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xD0,
  0x37, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xD0, 0xA7, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xE0,
  0x27, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xFE, 0x09, 0x77, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF0, 0x27,
  0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x09, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x01, 0x75,
  0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x08, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x0E, 0x01,
  0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0xFD, 0x07, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x07,
  0x0D, 0xFC, 0x0E, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x08, 0x06, 0xFD, 0x07, 0x73, 0x02, 0xFC,
  0x0B, 0x08, 0xFB, 0x81, 0x90, 0xDF, 0xC0, 0xD7, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xB8, 0x1A, 0x07,
  0xFD, 0x06, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0B, 0x20, 0xEF, 0xC0, 0xD7, 0x20, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xC2, 0x07, 0xFD, 0x05, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0D, 0x20, 0x10,
  0xEF, 0xC0, 0xC7, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xE3, 0x08, 0xFD, 0x04, 0x70, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xE3, 0x01, 0xFD, 0x0C, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xC4, 0x09, 0xFD, 0x04,
  0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xC4, 0x02, 0xFD, 0x0B, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xC5, 0x09,
  0xFD, 0x03, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xC0, 0x14, 0x02, 0xFD, 0x0A, 0x50, 0x1F, 0xC0, 0xB0,
  0x8F, 0xC0, 0x15, 0x0A, 0xFD, 0x02, 0x40, 0x1F, 0xC0, 0xB0, 0x8F, 0xC0, 0x25, 0x03, 0xFD, 0x09,
  0x5F, 0xC0, 0xB0, 0x8F, 0xC0, 0x26, 0x0B, 0xFD, 0x02, 0x4F, 0xC0, 0xB0, 0x8F, 0xC0, 0x26, 0x03,
  0xFD, 0x09, 0x40, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x0C, 0xFD, 0x01, 0x30, 0xEF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x04, 0xFD, 0x08, 0x30, 0xDF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x10, 0xCF, 0xC0,
  0xE0, 0x12, 0x0C, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x71, 0x05, 0xFD, 0x07, 0x20, 0xBF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x20, 0xDF, 0xC0, 0xE2, 0x0B, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x72, 0x06, 0xFD,
  0x81, 0x70, 0xAF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x30, 0xDF, 0xC8, 0x1D, 0x09, 0xFB, 0x0B, 0x08,
  0xFC, 0x02, 0x73, 0x06, 0xFD, 0x06, 0x09, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74, 0x0E, 0xFC, 0x0D,
  0x08, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74, 0x07, 0xFD, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74,
  0x01, 0x0E, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x75, 0x08, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02,
  0x75, 0x01, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x76, 0x09, 0xFF, 0xF0, 0xB0, 0x8F, 0xC0, 0x27,
  0x60, 0x1F, 0xFF, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x09, 0xFF, 0xE0, 0xB0, 0x8F, 0xC0, 0x27, 0x70,
  0x2F, 0xFE, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x10, 0xAF, 0xFD, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x10,
  0x3F, 0xFD, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x20, 0xBF, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x20,
  0x3F, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x30, 0xBF, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x30,
  0x4F, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x40, 0xCF, 0xFA, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x40,
  0x5F, 0xFA, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x50, 0xDF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x50,
  0x6F, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x60, 0xDF, 0xF0, 0xB0,
  // "ń" (U+0144)
  0x77, 0x70, 0x6F, 0xE0, 0xB7, 0x77, 0x30, 0xEF, 0xE0, 0x37, 0x77, 0x20, 0x8F, 0xE0, 0x57, 0x77,
  0x20, 0x2F, 0xE0, 0x67, 0x77, 0x30, 0xBF, 0xD0, 0x67, 0x77, 0x30, 0x5F, 0xD0, 0x67, 0x77, 0x30,
  0x10, 0xEF, 0xC0, 0x67, 0x77, 0x40, 0xAF, 0xC0, 0x57, 0x77, 0x40, 0x6F, 0xC0, 0x57, 0x77, 0x40,
  0x10, 0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x50, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x50, 0x7F, 0xA0, 0xD0,
  0x27, 0x77, 0x50, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x60, 0x6F, 0x90, 0xA8, 0x0A, 0xF3, 0x08, 0x91,
  0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56, 0x04, 0x0C, 0xFC, 0x0D, 0x05, 0x70,
  0x5F, 0xA0, 0x84, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x15, 0x05, 0xFA, 0x0C, 0x30, 0x20, 0xDF, 0xFB,
  0x0D, 0x02, 0x40, 0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0, 0x13, 0x05, 0xFB, 0x81, 0x40, 0xAF,
  0xFF, 0x0B, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62, 0x05, 0xFF, 0xFF, 0xF0, 0xD2, 0x05,
  0x80, 0xC0, 0xF8, 0x15, 0x05, 0x80, 0xC0, 0xF8, 0x1A, 0x05, 0xFF, 0xA8, 0x5D, 0x74, 0x33, 0x6D,
  0xFF, 0x10, 0x5F, 0xF9, 0x07, 0x70, 0xAF, 0xE0, 0x30, 0x5F, 0xF0, 0x67, 0x10, 0x10, 0xDF, 0xD0,
  0x60, 0x5F, 0xE0, 0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0, 0x47, 0x30, 0x2F, 0xD0, 0xA0, 0x5F,
  0xD0, 0xE7, 0x50, 0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50, 0xAF, 0xC0, 0xC0, 0x5F, 0xD0, 0x77,
  0x50, 0x9F, 0xC0, 0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0, 0x27, 0x50, 0x7F,
  0xC0, 0xC0, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0,
  // "Ņ" (U+0145)
  0x08, 0xFF, 0x0D, 0x77, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xF9, 0x06, 0x77, 0x50, 0x2F, 0xC0, 0xB0,
  0x8F, 0xF9, 0x0D, 0x77, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFA, 0x05, 0x77, 0x40, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFA, 0x0C, 0x77, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xFB, 0x04, 0x77, 0x30, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFB, 0x0C, 0x77, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xFC, 0x04, 0x77, 0x20, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFC, 0x0B, 0x77, 0x20, 0x2F, 0xC0, 0xB0, 0x8F, 0xFD, 0x03, 0x77, 0x10, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFD, 0x0A, 0x77, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xFE, 0x02, 0x77, 0x02, 0xFC, 0x0B, 0x08,
  0xFF, 0xE0, 0x97, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x02, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF,
  0xF0, 0x97, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x90, 0x17, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF,
  0x90, 0x87, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x90, 0xE0, 0x17, 0x40, 0x2F, 0xC0, 0xB0, 0x8F,
  0xB0, 0xEF, 0xD0, 0x77, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0x70, 0xDF, 0xC0, 0xE7, 0x40, 0x2F,
  0xC0, 0xB0, 0x8F, 0xB0, 0x80, 0x6F, 0xD0, 0x77, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xB8, 0x19, 0x0D,
  0xFC, 0x0D, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x81, 0xA0, 0x7F, 0xD0, 0x67, 0x20, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xB2, 0x0E, 0xFC, 0x0D, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0C, 0x20, 0x7F,
  0xD0, 0x57, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xD2, 0x01, 0x0E, 0xFC, 0x0C, 0x71, 0x02, 0xFC,
  0x0B, 0x08, 0xFB, 0x0E, 0x30, 0x8F, 0xD0, 0x47, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0x30, 0x1F,
  0xD0, 0xC7, 0x02, 0xFC, 0x0B, 0x08, 0xFC, 0x40, 0x9F, 0xD0, 0x46, 0x02, 0xFC, 0x0B, 0x08, 0xFC,
  0x40, 0x2F, 0xD0, 0xB6, 0x02, 0xFC, 0x0B, 0x08, 0xFC, 0x50, 0x9F, 0xD0, 0x35, 0x02, 0xFC, 0x0B,
  0x08, 0xFC, 0x01, 0x40, 0x2F, 0xD0, 0xA5, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x50, 0xAF, 0xD0,
  0x24, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x50, 0x3F, 0xD0, 0x95, 0xFC, 0x0B, 0x08, 0xFC, 0x02,
  0x60, 0xBF, 0xD0, 0x24, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x60, 0x3F, 0xD0, 0x94, 0x0E, 0xFB, 0x0B,
  0x08, 0xFC, 0x02, 0x70, 0xCF, 0xD0, 0x13, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x70, 0x4F, 0xD0,
  0x83, 0x0D, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x71, 0x0C, 0xFC, 0x0E, 0x01, 0x20, 0xCF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x10, 0x5F, 0xD0, 0x72, 0x0B, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x72, 0x0D, 0xFC,
  0x0E, 0x20, 0xBF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x20, 0x6F, 0xD8, 0x17, 0x0A, 0xFB, 0x0B, 0x08,
  0xFC, 0x02, 0x73, 0x0D, 0xFC, 0x81, 0xD0, 0x9F, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x30, 0x6F, 0xD0,
  0x60, 0x9F, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x40, 0xEF, 0xC0, 0xD0, 0x8F, 0xB0, 0xB0, 0x8F, 0xC0,
  0x27, 0x40, 0x7F, 0xD0, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x40, 0x10, 0xEF, 0xFF, 0x90, 0xB0,
  0x8F, 0xC0, 0x27, 0x50, 0x8F, 0xFF, 0x90, 0xB0, 0x8F, 0xC0, 0x27, 0x50, 0x1F, 0xFF, 0x90, 0xB0,
  0x8F, 0xC0, 0x27, 0x60, 0x9F, 0xFF, 0x0B, 0x08, 0xFC, 0x02, 0x76, 0x01, 0xFF, 0xF0, 0xB0, 0x8F,
  0xC0, 0x27, 0x70, 0x9F, 0xFE, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x02, 0xFF, 0xE0, 0xB0, 0x8F, 0xC0,
  0x27, 0x71, 0x0A, 0xFF, 0xD0, 0xB0, 0x8F, 0xC0, 0x27, 0x71, 0x03, 0xFF, 0xD0, 0xB0, 0x8F, 0xC0,
  0x27, 0x72, 0x0B, 0xFF, 0xC0, 0xB0, 0x8F, 0xC0, 0x27, 0x72, 0x03, 0xFF, 0xC0, 0xB0, 0x8F, 0xC0,
  0x27, 0x73, 0x0B, 0xFF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x73, 0x04, 0xFF, 0xB0, 0xB0, 0x8F, 0xC0,
  0x27, 0x74, 0x0C, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0, 0x27, 0x74, 0x05, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0,
  0x27, 0x75, 0x0D, 0xFF, 0x90, 0xB0, 0x8F, 0xC0, 0x27, 0x75, 0x06, 0xFF, 0x90, 0xB0, 0x8F, 0xC0,
  0x27, 0x76, 0x0D, 0xFF, 0x0B, 0x80, 0xCE, 0x50, 0x01, 0xFC, 0x09, 0x80, 0xC0, 0x00, 0x3F, 0xC0,
  0x78, 0x0C, 0x00, 0x05, 0xFC, 0x01, 0x80, 0xC0, 0x00, 0x7F, 0xB0, 0xB8, 0x0C, 0x10, 0x09, 0xFB,
  0x05, 0x80, 0xC1, 0x00, 0xCF, 0xA0, 0xD8, 0x0C, 0x20, 0xFB, 0x06, 0x80, 0xC1, 0x00, 0x2F, 0xA0,
  0xE8, 0x0C, 0x20, 0x05, 0xFA, 0x07, 0x80, 0xC2, 0x00, 0x8F, 0x90, 0xE8, 0x0C, 0x30, 0x0B, 0xF9,
  0x06, 0x80, 0xC3, 0x00, 0xEF, 0x0D, 0x80, 0xC3, 0x00, 0x3F, 0x90, 0x38, 0x0C, 0x30, 0x04, 0xF0,
  0xA7, 0x77, 0x20,
  // "ņ" (U+0146)
  0x77, 0x58, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56, 0x04, 0x0C, 0xFC,
  0x0D, 0x05, 0x70, 0x5F, 0xA0, 0x84, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x15, 0x05, 0xFA, 0x0C, 0x30,
  0x20, 0xDF, 0xFB, 0x0D, 0x02, 0x40, 0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0, 0x13, 0x05, 0xFB,
  0x81, 0x40, 0xAF, 0xFF, 0x0B, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62, 0x05, 0xFF, 0xFF,
  0xF0, 0xD2, 0x05, 0x80, 0xC0, 0xF8, 0x15, 0x05, 0x80, 0xC0, 0xF8, 0x1A, 0x05, 0xFF, 0xA8, 0x5D,
  0x74, 0x33, 0x6D, 0xFF, 0x10, 0x5F, 0xF9, 0x07, 0x70, 0xAF, 0xE0, 0x30, 0x5F, 0xF0, 0x67, 0x10,
  0x10, 0xDF, 0xD0, 0x60, 0x5F, 0xE0, 0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0, 0x47, 0x30, 0x2F,
  0xD0, 0xA0, 0x5F, 0xD0, 0xE7, 0x50, 0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50, 0xAF, 0xC0, 0xC0,
  0x5F, 0xD0, 0x77, 0x50, 0x9F, 0xC0, 0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0,
  0x27, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC8, 0x0B, 0xE4, 0x00, 0x1F, 0xC0, 0x97, 0x77, 0x50, 0x3F, 0xC0,
  0x77, 0x77, 0x50, 0x5F, 0xC0, 0x17, 0x77, 0x50, 0x7F, 0xB0, 0xB7, 0x77, 0x60, 0x9F, 0xB0, 0x57,
  0x77, 0x60, 0xCF, 0xA0, 0xD7, 0x77, 0x7F, 0xB0, 0x67, 0x77, 0x60, 0x2F, 0xA0, 0xE7, 0x77, 0x70,
  0x5F, 0xA0, 0x77, 0x77, 0x70, 0x8F, 0x90, 0xE7, 0x77, 0x71, 0x0B, 0xF9, 0x06, 0x77, 0x77, 0x10,
  0xEF, 0x0D, 0x77, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x77, 0x71, 0x04, 0xF0, 0xA7, 0x74,
  // "Ň" (U+0147)
  0x72, 0x03, 0x80, 0x37, 0x04, 0x77, 0x03, 0x80, 0x37, 0x03, 0x77, 0x30, 0x6F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x77, 0x74, 0x0C, 0xF9, 0x07, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xEF,
  0x90, 0x97, 0x10, 0xAF, 0x90, 0xE0, 0x27, 0x76, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x77,
  0x10, 0x7F, 0xA0, 0xA4, 0x0B, 0xFA, 0x09, 0x77, 0x73, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7,
  0x77, 0x40, 0x10, 0xEF, 0xA0, 0x08, 0xFA, 0x0E, 0x02, 0x77, 0x75, 0x04, 0xFF, 0xE0, 0x67, 0x77,
  0x70, 0x9F, 0xFC, 0x0A, 0x77, 0x77, 0x20, 0xDF, 0xFA, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x3F, 0xFA,
  0x05, 0x77, 0x77, 0x40, 0x8F, 0xF0, 0xA7, 0x77, 0x76, 0x0D, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x60,
  0x5F, 0xD0, 0x78, 0x0C, 0x82, 0x00, 0x8F, 0xF0, 0xD7, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0x90,
  0x67, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0x90, 0xD7, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xA0,
  0x57, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xA0, 0xC7, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xB0,
  0x47, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xB0, 0xC7, 0x73, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xC0,
  0x47, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xC0, 0xB7, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xD0,
  0x37, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xD0, 0xA7, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xE0,
  0x27, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xFE, 0x09, 0x77, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF0, 0x27,
  0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x09, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x01, 0x75,
  0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x08, 0x75, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF9, 0x0E, 0x01,
  0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0xFD, 0x07, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x07,
  0x0D, 0xFC, 0x0E, 0x74, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x08, 0x06, 0xFD, 0x07, 0x73, 0x02, 0xFC,
  0x0B, 0x08, 0xFB, 0x81, 0x90, 0xDF, 0xC0, 0xD7, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xB8, 0x1A, 0x07,
  0xFD, 0x06, 0x72, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0B, 0x20, 0xEF, 0xC0, 0xD7, 0x20, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xC2, 0x07, 0xFD, 0x05, 0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0D, 0x20, 0x10,
  0xEF, 0xC0, 0xC7, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xE3, 0x08, 0xFD, 0x04, 0x70, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0xE3, 0x01, 0xFD, 0x0C, 0x70, 0x2F, 0xC0, 0xB0, 0x8F, 0xC4, 0x09, 0xFD, 0x04,
  0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xC4, 0x02, 0xFD, 0x0B, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xC5, 0x09,
  0xFD, 0x03, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xC0, 0x14, 0x02, 0xFD, 0x0A, 0x50, 0x1F, 0xC0, 0xB0,
  0x8F, 0xC0, 0x15, 0x0A, 0xFD, 0x02, 0x40, 0x1F, 0xC0, 0xB0, 0x8F, 0xC0, 0x25, 0x03, 0xFD, 0x09,
  0x5F, 0xC0, 0xB0, 0x8F, 0xC0, 0x26, 0x0B, 0xFD, 0x02, 0x4F, 0xC0, 0xB0, 0x8F, 0xC0, 0x26, 0x03,
  0xFD, 0x09, 0x40, 0xEF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x0C, 0xFD, 0x01, 0x30, 0xEF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x04, 0xFD, 0x08, 0x30, 0xDF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x10, 0xCF, 0xC0,
  0xE0, 0x12, 0x0C, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x71, 0x05, 0xFD, 0x07, 0x20, 0xBF, 0xB0, 0xB0,
  0x8F, 0xC0, 0x27, 0x20, 0xDF, 0xC0, 0xE2, 0x0B, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x72, 0x06, 0xFD,
  0x81, 0x70, 0xAF, 0xB0, 0xB0, 0x8F, 0xC0, 0x27, 0x30, 0xDF, 0xC8, 0x1D, 0x09, 0xFB, 0x0B, 0x08,
  0xFC, 0x02, 0x73, 0x06, 0xFD, 0x06, 0x09, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74, 0x0E, 0xFC, 0x0D,
  0x08, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74, 0x07, 0xFD, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x74,
  0x01, 0x0E, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x75, 0x08, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02,
  0x75, 0x01, 0xFF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x76, 0x09, 0xFF, 0xF0, 0xB0, 0x8F, 0xC0, 0x27,
  0x60, 0x1F, 0xFF, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x09, 0xFF, 0xE0, 0xB0, 0x8F, 0xC0, 0x27, 0x70,
  0x2F, 0xFE, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x10, 0xAF, 0xFD, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x10,
  0x3F, 0xFD, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x20, 0xBF, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x20,
  0x3F, 0xFC, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x30, 0xBF, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x30,
  0x4F, 0xFB, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x40, 0xCF, 0xFA, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x40,
  0x5F, 0xFA, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x50, 0xDF, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x50,
  0x6F, 0xF9, 0x0B, 0x08, 0xFC, 0x02, 0x77, 0x60, 0xDF, 0xF0, 0xB0,
  // "ň" (U+0148)
  0x40, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x37, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x07, 0x71, 0x0C, 0xF9, 0x07, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x71, 0x01, 0x0E, 0xF9, 0x09, 0x71,
  0x0A, 0xF9, 0x0E, 0x02, 0x73, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x50, 0x7F, 0xA0, 0xA4,
  0x0B, 0xFA, 0x09, 0x77, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7, 0x71, 0x01, 0x0E, 0xFA, 0x00,
  0x8F, 0xA0, 0xE0, 0x27, 0x72, 0x04, 0xFF, 0xE0, 0x67, 0x74, 0x09, 0xFF, 0xC0, 0xA7, 0x76, 0x0D,
  0xFF, 0xA0, 0xD0, 0x17, 0x76, 0x03, 0xFF, 0xA0, 0x57, 0x77, 0x10, 0x8F, 0xF0, 0xA7, 0x77, 0x30,
  0xDF, 0xD0, 0xE0, 0x17, 0x77, 0x30, 0x5F, 0xD0, 0x78, 0x0A, 0xE7, 0x08, 0x91, 0x27, 0xAD, 0xEF,
  0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56, 0x04, 0x0C, 0xFC, 0x0D, 0x05, 0x70, 0x5F, 0xA0, 0x84,
  0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x15, 0x05, 0xFA, 0x0C, 0x30, 0x20, 0xDF, 0xFB, 0x0D, 0x02, 0x40,
  0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0, 0x13, 0x05, 0xFB, 0x81, 0x40, 0xAF, 0xFF, 0x0B, 0x30,
  0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62, 0x05, 0xFF, 0xFF, 0xF0, 0xD2, 0x05, 0x80, 0xC0, 0xF8,
  0x15, 0x05, 0x80, 0xC0, 0xF8, 0x1A, 0x05, 0xFF, 0xA8, 0x5D, 0x74, 0x33, 0x6D, 0xFF, 0x10, 0x5F,
  0xF9, 0x07, 0x70, 0xAF, 0xE0, 0x30, 0x5F, 0xF0, 0x67, 0x10, 0x10, 0xDF, 0xD0, 0x60, 0x5F, 0xE0,
  0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0, 0x47, 0x30, 0x2F, 0xD0, 0xA0, 0x5F, 0xD0, 0xE7, 0x50,
  0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50, 0xAF, 0xC0, 0xC0, 0x5F, 0xD0, 0x77, 0x50, 0x9F, 0xC0,
  0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC0, 0x5F, 0xD0, 0x27, 0x50, 0x7F, 0xC0, 0xC0, 0x5F,
  0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xE7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  // "ŉ" (U+0149)
  0x40, 0xDF, 0xC0, 0x48, 0x0C, 0x50, 0x0E, 0xFC, 0x06, 0x80, 0xC5, 0x0F, 0xD0, 0x38, 0x0C, 0x40,
  0x02, 0xFD, 0x80, 0xC5, 0x00, 0x4F, 0xC0, 0xC8, 0x0C, 0x50, 0x06, 0xFC, 0x09, 0x80, 0xC5, 0x00,
  0x8F, 0xC0, 0x68, 0x0C, 0x50, 0x0A, 0xFC, 0x03, 0x80, 0xC5, 0x00, 0xDF, 0xB0, 0xE8, 0x0C, 0x60,
  0xFC, 0x0A, 0x80, 0xC5, 0x00, 0x2F, 0xC0, 0x68, 0x0C, 0x50, 0x05, 0xFC, 0x02, 0x80, 0xC5, 0x00,
  0x7F, 0xB0, 0xD8, 0x0C, 0x60, 0x0A, 0xFB, 0x08, 0x80, 0xC6, 0x00, 0xCF, 0xB0, 0x37, 0x76, 0x89,
  0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x83, 0x74, 0xFB, 0x0E, 0x20, 0x5F, 0xA0, 0x56, 0x04, 0x0C, 0xFC,
  0x0D, 0x05, 0x71, 0x02, 0xFB, 0x09, 0x20, 0x5F, 0xA0, 0x84, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x16,
  0x05, 0xFB, 0x04, 0x20, 0x5F, 0xA0, 0xC3, 0x02, 0x0D, 0xFF, 0xB0, 0xD0, 0x25, 0x08, 0xFA, 0x0E,
  0x30, 0x5F, 0xB2, 0x01, 0x0D, 0xFF, 0xD0, 0xD0, 0x14, 0x0B, 0xFA, 0x09, 0x30, 0x5F, 0xB8, 0x14,
  0x0A, 0xFF, 0xF0, 0xB4, 0x0D, 0xFA, 0x03, 0x30, 0x5F, 0xB0, 0x80, 0x4F, 0xFF, 0xA0, 0x62, 0x01,
  0xFA, 0x0C, 0x40, 0x5F, 0xFF, 0xFF, 0x0D, 0x20, 0x5F, 0xA0, 0x64, 0x05, 0x80, 0xC0, 0xF8, 0x15,
  0x08, 0xFA, 0x01, 0x40, 0x58, 0x0C, 0x0F, 0x0A, 0x77, 0x20, 0x5F, 0xFA, 0x85, 0xD7, 0x43, 0x36,
  0xDF, 0xF7, 0x72, 0x05, 0xFF, 0x90, 0x77, 0x0A, 0xFE, 0x03, 0x77, 0x10, 0x5F, 0xF0, 0x67, 0x10,
  0x10, 0xDF, 0xD0, 0x67, 0x71, 0x05, 0xFE, 0x0C, 0x73, 0x07, 0xFD, 0x08, 0x77, 0x10, 0x5F, 0xE0,
  0x47, 0x30, 0x2F, 0xD0, 0xA7, 0x71, 0x05, 0xFD, 0x0E, 0x75, 0x0D, 0xFC, 0x0B, 0x77, 0x10, 0x5F,
  0xD0, 0xA7, 0x50, 0xAF, 0xC0, 0xC7, 0x71, 0x05, 0xFD, 0x07, 0x75, 0x09, 0xFC, 0x0C, 0x77, 0x10,
  0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC7, 0x71, 0x05, 0xFD, 0x02, 0x75, 0x07, 0xFC, 0x0C, 0x77,
  0x10, 0x5F, 0xD0, 0x17, 0x50, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFD, 0x76, 0x06, 0xFC, 0x0C, 0x77,
  0x10, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0D, 0x76, 0x06, 0xFC, 0x0C,
  0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC,
  0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06,
  0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76,
  0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C,
  0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC,
  0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05,
  0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71,
  0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7,
  0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C, 0x77, 0x10, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x71, 0x05, 0xFC, 0x0C, 0x76, 0x06, 0xFC, 0x0C,
  // "Ŋ" (U+014A)
  0x08, 0xFF, 0x0E, 0x77, 0x60, 0x2F, 0xC0, 0xB0, 0x8F, 0xF9, 0x07, 0x77, 0x50, 0x2F, 0xC0, 0xB0,
  0x8F, 0xF9, 0x0E, 0x01, 0x77, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xFA, 0x08, 0x77, 0x40, 0x2F, 0xC0,
  0xB0, 0x8F, 0xFB, 0x02, 0x77, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xFB, 0x0A, 0x77, 0x30, 0x2F, 0xC0,
  0xB0, 0x8F, 0xFC, 0x03, 0x77, 0x20, 0x2F, 0xC0, 0xB0, 0x8F, 0xFC, 0x0B, 0x77, 0x20, 0x2F, 0xC0,
  0xB0, 0x8F, 0xFD, 0x04, 0x77, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xFD, 0x0C, 0x77, 0x10, 0x2F, 0xC0,
  0xB0, 0x8F, 0xFE, 0x05, 0x77, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xE0, 0xD7, 0x70, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFF, 0x06, 0x76, 0x02, 0xFC, 0x0B, 0x08, 0xFF, 0xF0, 0xE7, 0x60, 0x2F, 0xC0, 0xB0, 0x8F,
  0xFF, 0x90, 0x77, 0x50, 0x2F, 0xC0, 0xB0, 0x8F, 0xFF, 0x90, 0xE0, 0x17, 0x40, 0x2F, 0xC0, 0xB0,
  0x8F, 0xFF, 0xA0, 0x97, 0x40, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xEF, 0xE0, 0x27, 0x30, 0x2F, 0xC0,
  0xB0, 0x8F, 0xB0, 0x80, 0xDF, 0xD0, 0xA7, 0x30, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0x80, 0x5F, 0xE0,
  0x37, 0x20, 0x2F, 0xC0, 0xB0, 0x8F, 0xB8, 0x19, 0x0C, 0xFD, 0x0B, 0x72, 0x02, 0xFC, 0x0B, 0x08,
  0xFB, 0x81, 0xA0, 0x4F, 0xE0, 0x47, 0x10, 0x2F, 0xC0, 0xB0, 0x8F, 0xB0, 0xB2, 0x0B, 0xFD, 0x0C,
  0x71, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0C, 0x20, 0x2F, 0xE0, 0x57, 0x02, 0xFC, 0x0B, 0x08, 0xFB,
  0x0D, 0x30, 0x9F, 0xD0, 0xD7, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0D, 0x30, 0x10, 0xEF, 0xD0, 0x66,
  0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E, 0x40, 0x7F, 0xD0, 0xE6, 0x02, 0xFC, 0x0B, 0x08, 0xFB, 0x0E,
  0x50, 0xEF, 0xD0, 0x85, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x50, 0x6F, 0xD0, 0xE0, 0x14, 0x01, 0xFC,
  0x0B, 0x08, 0xFC, 0x60, 0xDF, 0xD0, 0x94, 0x01, 0xFC, 0x0B, 0x08, 0xFC, 0x60, 0x4F, 0xE0, 0x24,
  0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x60, 0xBF, 0xD0, 0xA4, 0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x60, 0x3F,
  0xE0, 0x33, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x01, 0x70, 0xAF, 0xD0, 0xB3, 0x0D, 0xFB, 0x0B, 0x08,
  0xFC, 0x01, 0x70, 0x1F, 0xE0, 0x42, 0x0D, 0xFB, 0x0B, 0x08, 0xFC, 0x01, 0x71, 0x08, 0xFD, 0x0C,
  0x20, 0xCF, 0xB0, 0xB0, 0x8F, 0xC0, 0x17, 0x10, 0x10, 0xEF, 0xD8, 0x15, 0x0B, 0xFB, 0x0B, 0x08,
  0xFC, 0x01, 0x72, 0x06, 0xFD, 0x81, 0xD0, 0xAF, 0xB0, 0xB0, 0x8F, 0xC0, 0x17, 0x30, 0xDF, 0xD0,
  0x70, 0x9F, 0xB0, 0xB0, 0x8F, 0xC0, 0x17, 0x30, 0x5F, 0xD0, 0xE0, 0xAF, 0xB0, 0xB0, 0x8F, 0xC0,
  0x17, 0x40, 0xCF, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0, 0x17, 0x40, 0x3F, 0xFF, 0xA0, 0xB0, 0x8F, 0xC0,
  0x17, 0x50, 0xAF, 0xFF, 0x90, 0xB0, 0x8F, 0xC0, 0x17, 0x50, 0x2F, 0xFF, 0x90, 0xB0, 0x8F, 0xC0,
  0x17, 0x60, 0x9F, 0xFF, 0x0B, 0x08, 0xFC, 0x01, 0x76, 0x01, 0x0E, 0xFF, 0xE0, 0xB0, 0x8F, 0xC0,
  0x17, 0x70, 0x7F, 0xFE, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x10, 0xDF, 0xFD, 0x0B, 0x08, 0xFC, 0x01,
  0x77, 0x10, 0x5F, 0xFD, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x20, 0xCF, 0xFC, 0x0B, 0x08, 0xFC, 0x01,
  0x77, 0x20, 0x4F, 0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x30, 0xBF, 0xFB, 0x0B, 0x08, 0xFC, 0x01,
  0x77, 0x30, 0x2F, 0xFB, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x40, 0x9F, 0xFA, 0x0B, 0x08, 0xFC, 0x01,
  0x77, 0x40, 0x10, 0xEF, 0xF9, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x50, 0x8F, 0xF9, 0x0B, 0x08, 0xFC,
  0x01, 0x77, 0x60, 0xEF, 0xF0, 0xB0, 0x8F, 0xC0, 0x17, 0x76, 0x06, 0xFF, 0x0B, 0x08, 0xFC, 0x01,
  0x77, 0x70, 0xDF, 0xE0, 0xB0, 0x8F, 0xC0, 0x17, 0x77, 0x04, 0xFE, 0x0B, 0x08, 0xFC, 0x01, 0x77,
  0x71, 0x0B, 0xFD, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x71, 0x03, 0xFD, 0x0B, 0x08, 0xFC, 0x01, 0x77,
  0x72, 0x0A, 0xFC, 0x0B, 0x08, 0xFC, 0x01, 0x77, 0x72, 0x02, 0xFC, 0x0A, 0x80, 0xC1, 0x0F, 0xC0,
  0xA8, 0x0C, 0x00, 0x01, 0xFC, 0x09, 0x80, 0xC0, 0x00, 0x3F, 0xC0, 0x88, 0x0C, 0x00, 0x06, 0xFC,
  0x06, 0x80, 0xC0, 0x00, 0xBF, 0xC0, 0x47, 0x77, 0x77, 0x01, 0xFD, 0x01, 0x77, 0x77, 0x70, 0xAF,
  0xC0, 0xD7, 0x77, 0x77, 0x09, 0xFD, 0x0A, 0x77, 0x74, 0x89, 0x0B, 0xB7, 0x54, 0x23, 0x48, 0xDF,
  0xE0, 0x57, 0x77, 0x40, 0xBF, 0xFF, 0x0E, 0x77, 0x75, 0x0B, 0xFF, 0xF0, 0x87, 0x77, 0x50, 0xBF,
  0xFE, 0x0E, 0x01, 0x77, 0x75, 0x0B, 0xFF, 0xE0, 0x77, 0x77, 0x60, 0xBF, 0xFD, 0x0B, 0x77, 0x77,
  0x0B, 0xFF, 0xC0, 0xC0, 0x17, 0x77, 0x70, 0xBF, 0xFB, 0x0B, 0x01, 0x77, 0x77, 0x10, 0xBF, 0xF9,
  0x0E, 0x07, 0x77, 0x77, 0x30, 0xBF, 0xE8, 0x1E, 0x81, 0x77, 0x77, 0x48, 0x42, 0x69, 0xCD, 0xEB,
  0x83, 0xEC, 0xA7, 0x37, 0x40,
  // "ŋ" (U+014B)
  0x77, 0x58, 0x91, 0x37, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x5F, 0xA0, 0x56, 0x05, 0x0C, 0xFC,
  0x0D, 0x06, 0x70, 0x5F, 0xA0, 0x84, 0x01, 0x0B, 0xFF, 0x90, 0xB0, 0x15, 0x05, 0xFA, 0x0C, 0x30,
  0x20, 0xDF, 0xFB, 0x0D, 0x02, 0x40, 0x5F, 0xB8, 0x21, 0x01, 0xDF, 0xFD, 0x0D, 0x01, 0x30, 0x5F,
  0xB8, 0x14, 0x0C, 0xFF, 0xF0, 0xB3, 0x05, 0xFB, 0x08, 0x06, 0xFF, 0xFA, 0x05, 0x20, 0x5F, 0xFF,
  0xFF, 0x0D, 0x20, 0x58, 0x0C, 0x0F, 0x81, 0x40, 0x58, 0x0C, 0x0F, 0x81, 0x90, 0x5F, 0xFA, 0x85,
  0xD8, 0x43, 0x36, 0xDF, 0xE8, 0x1E, 0x05, 0xFF, 0x90, 0x87, 0x0A, 0xFE, 0x02, 0x05, 0xFF, 0x08,
  0x71, 0x01, 0x0D, 0xFD, 0x00, 0x5F, 0xE0, 0xC7, 0x30, 0x7F, 0xD0, 0x80, 0x5F, 0xE0, 0x57, 0x30,
  0x1F, 0xD0, 0x90, 0x5F, 0xD0, 0xE7, 0x50, 0xDF, 0xC0, 0xB0, 0x5F, 0xD0, 0xA7, 0x50, 0xAF, 0xC0,
  0xC0, 0x5F, 0xD0, 0x77, 0x50, 0x8F, 0xC0, 0xC0, 0x5F, 0xD0, 0x47, 0x50, 0x7F, 0xC0, 0xC0, 0x5F,
  0xD0, 0x27, 0x50, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xD7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xE7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xD7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7,
  0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F,
  0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0,
  0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0,
  0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60,
  0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0,
  0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F, 0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC0, 0x5F,
  0xC0, 0xC7, 0x60, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x6F, 0xC0, 0xC7,
  0x77, 0x50, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x6F, 0xC0, 0xC7, 0x77,
  0x50, 0x6F, 0xC0, 0xC7, 0x77, 0x50, 0x7F, 0xC0, 0xC7, 0x77, 0x50, 0x9F, 0xC0, 0xB7, 0x77, 0x50,
  0xDF, 0xC0, 0xA7, 0x77, 0x40, 0x3F, 0xD0, 0x87, 0x77, 0x40, 0xCF, 0xD0, 0x57, 0x74, 0x85, 0xC9,
  0x53, 0x35, 0xDF, 0xE0, 0x27, 0x74, 0x0E, 0xFF, 0xC0, 0xD7, 0x75, 0x0E, 0xFF, 0xC0, 0x87, 0x75,
  0x0E, 0xFF, 0xC0, 0x27, 0x75, 0x0E, 0xFF, 0xB0, 0xA7, 0x76, 0x0E, 0xFF, 0xA0, 0xE0, 0x17, 0x76,
  0x0E, 0xFF, 0xA0, 0x57, 0x77, 0x0E, 0xFF, 0x90, 0x67, 0x77, 0x10, 0xEF, 0xE0, 0xE0, 0x57, 0x77,
  0x20, 0xEF, 0xD0, 0x90, 0x17, 0x77, 0x38, 0x42, 0x59, 0xBD, 0xEA, 0x83, 0xEC, 0x96, 0x17, 0x10,
  // "Ō" (U+014C)
  0x75, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC,
  0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06,
  0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x77,
  0x73, 0x06, 0xFF, 0xFC, 0x0D, 0x80, 0xCB, 0x10, 0x89, 0x52, 0x69, 0xBD, 0xEE, 0xFE, 0xDC, 0xB8,
  0x52, 0x77, 0x77, 0x58, 0x13, 0x9E, 0xFF, 0x98, 0x1E, 0x82, 0x77, 0x77, 0x05, 0x0D, 0xFF, 0xF0,
  0xC0, 0x37, 0x77, 0x30, 0x20, 0xCF, 0xFF, 0xC0, 0xA0, 0x17, 0x77, 0x06, 0x0E, 0xFF, 0xFE, 0x0E,
  0x03, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x05, 0x77, 0x30, 0x9F, 0xFF, 0xFD, 0x06, 0x77, 0x10, 0x7F,
  0xFF, 0xFF, 0x04, 0x76, 0x04, 0x80, 0xC0, 0xF0, 0xE0, 0x27, 0x40, 0x10, 0xE8, 0x0C, 0x1F, 0x0C,
  0x74, 0x0A, 0x80, 0xC3, 0xF0, 0x67, 0x20, 0x3F, 0xFA, 0x82, 0xB6, 0x31, 0x28, 0x12, 0x6B, 0xFF,
  0x90, 0xE0, 0x17, 0x10, 0xBF, 0xF0, 0xD0, 0x47, 0x20, 0x30, 0xDF, 0xF0, 0x87, 0x03, 0xFF, 0x0B,
  0x76, 0x0B, 0xFE, 0x0E, 0x70, 0x9F, 0xE0, 0xD7, 0x71, 0x0C, 0xFE, 0x06, 0x50, 0x10, 0xEF, 0xE0,
  0x27, 0x71, 0x02, 0xFE, 0x0D, 0x50, 0x5F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x40, 0xAF, 0xE0,
  0x17, 0x73, 0x01, 0xFE, 0x07, 0x40, 0xEF, 0xD0, 0xA7, 0x75, 0x0A, 0xFD, 0x0C, 0x30, 0x3F, 0xE0,
  0x47, 0x75, 0x05, 0xFE, 0x01, 0x20, 0x7F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x04, 0x20, 0xAF, 0xD0,
  0xB7, 0x77, 0x0C, 0xFD, 0x07, 0x20, 0xDF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x0A, 0x2F, 0xE0, 0x47,
  0x77, 0x06, 0xFD, 0x81, 0xD0, 0x2F, 0xE0, 0x27, 0x77, 0x03, 0xFE, 0x10, 0x4F, 0xE7, 0x77, 0x10,
  0x1F, 0xE0, 0x10, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0, 0x30, 0x7F, 0xD0, 0xC7, 0x77, 0x20, 0xEF,
  0xD0, 0x40, 0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF, 0xD0, 0x60, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xCF,
  0xD0, 0x60, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xBF,
  0xD0, 0x70, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF, 0xD0, 0x80, 0xAF, 0xD0, 0x87, 0x77, 0x20, 0xAF,
  0xD0, 0x80, 0x9F, 0xD0, 0x87, 0x77, 0x20, 0xBF, 0xD0, 0x70, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF,
  0xD0, 0x70, 0x8F, 0xD0, 0x97, 0x77, 0x20, 0xCF, 0xD0, 0x60, 0x8F, 0xD0, 0xA7, 0x77, 0x20, 0xDF,
  0xD0, 0x50, 0x6F, 0xD0, 0xB7, 0x77, 0x20, 0xEF, 0xD0, 0x40, 0x5F, 0xD0, 0xD7, 0x77, 0x2F, 0xE0,
  0x20, 0x3F, 0xE7, 0x77, 0x10, 0x1F, 0xE0, 0x01, 0xFE, 0x01, 0x77, 0x70, 0x3F, 0xD0, 0xE2, 0x0E,
  0xFD, 0x04, 0x77, 0x70, 0x6F, 0xD0, 0xD2, 0x0C, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0x92, 0x09,
  0xFD, 0x0A, 0x77, 0x70, 0xCF, 0xD0, 0x62, 0x05, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x32, 0x02,
  0xFE, 0x04, 0x77, 0x50, 0x5F, 0xE4, 0x0D, 0xFD, 0x09, 0x77, 0x50, 0xBF, 0xD0, 0xB4, 0x08, 0xFD,
  0x0E, 0x01, 0x77, 0x30, 0x2F, 0xE0, 0x64, 0x04, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x25, 0x0E,
  0xFE, 0x02, 0x77, 0x10, 0x3F, 0xE0, 0xC6, 0x08, 0xFE, 0x0C, 0x77, 0x10, 0xDF, 0xE0, 0x66, 0x01,
  0xFF, 0x0B, 0x76, 0x0B, 0xFE, 0x0E, 0x71, 0x09, 0xFF, 0x0D, 0x03, 0x72, 0x04, 0x0D, 0xFF, 0x08,
  0x71, 0x02, 0x0E, 0xFF, 0x98, 0x1B, 0x62, 0x38, 0x13, 0x6B, 0xFF, 0x90, 0xE0, 0x17, 0x20, 0x78,
  0x0C, 0x3F, 0x05, 0x74, 0x0D, 0x80, 0xC1, 0xF0, 0xB7, 0x50, 0x20, 0xEF, 0xFF, 0xFF, 0x0E, 0x02,
  0x76, 0x04, 0xFF, 0xFF, 0xF0, 0x37, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x57, 0x73, 0x05, 0xFF, 0xFF,
  0xA0, 0xE0, 0x47, 0x75, 0x04, 0x0E, 0xFF, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x10, 0xBF, 0xFF, 0xC0,
  0x90, 0x17, 0x77, 0x30, 0x40, 0xCF, 0xFF, 0x0B, 0x03, 0x77, 0x77, 0x81, 0x39, 0xEF, 0xF9, 0x81,
  0xD8, 0x27, 0x77, 0x75, 0x84, 0x36, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xB8, 0x52, 0x77, 0x40,
  // "ō" (U+014D)
  0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70,
  0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F,
  0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD7, 0x70, 0x6F, 0xFF, 0xC0, 0xD8, 0x0B, 0xB6, 0x08,
  0x42, 0x69, 0xCD, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x6C, 0xFE, 0x81, 0xE8, 0x27,
  0x77, 0x06, 0x0E, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x01, 0x0C, 0xFF, 0xF0, 0xD0, 0x47, 0x71, 0x03,
  0x0E, 0xFF, 0xFB, 0x06, 0x76, 0x03, 0x0E, 0xFF, 0xFD, 0x07, 0x74, 0x02, 0x0E, 0xFF, 0xFF, 0x06,
  0x73, 0x0C, 0xFF, 0xFF, 0xA0, 0x37, 0x10, 0x7F, 0xFF, 0xFB, 0x0D, 0x70, 0x1F, 0xFF, 0xFD, 0x07,
  0x60, 0x8F, 0xE8, 0x5E, 0x84, 0x33, 0x6B, 0xFE, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xD0, 0xB7, 0x04,
  0x0E, 0xFD, 0x07, 0x40, 0x6F, 0xD0, 0xB7, 0x20, 0x3F, 0xD0, 0xE4, 0x0B, 0xFC, 0x0E, 0x02, 0x73,
  0x08, 0xFD, 0x04, 0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xD0, 0x92, 0x05, 0xFD, 0x03, 0x75, 0x0B,
  0xFC, 0x0D, 0x20, 0x8F, 0xC0, 0xD7, 0x60, 0x6F, 0xD8, 0x11, 0x0C, 0xFC, 0x0A, 0x76, 0x03, 0xFD,
  0x81, 0x40, 0xEF, 0xC0, 0x77, 0x7F, 0xD0, 0x70, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0xA0, 0x3F,
  0xD0, 0x37, 0x70, 0xBF, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xD0, 0x5F, 0xD7, 0x71,
  0x09, 0xFC, 0x0E, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0x08, 0xFD, 0x07,
  0xFC, 0x0E, 0x77, 0x10, 0x7F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F,
  0xC0, 0xE0, 0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0D, 0x04, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0C, 0x02,
  0xFD, 0x03, 0x77, 0x0C, 0xFC, 0x0A, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC8, 0x18, 0x0D, 0xFC, 0x07,
  0x77, 0xFD, 0x81, 0x60, 0x9F, 0xC0, 0xA7, 0x60, 0x3F, 0xD8, 0x13, 0x06, 0xFC, 0x0E, 0x76, 0x07,
  0xFC, 0x0E, 0x20, 0x2F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xB3, 0x0D, 0xFC, 0x09, 0x74, 0x01, 0xFD,
  0x06, 0x30, 0x8F, 0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x13, 0x02, 0xFD, 0x0B, 0x72, 0x04, 0xFD,
  0x0B, 0x50, 0xBF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x05, 0x50, 0x3F, 0xE8, 0x5E, 0x84, 0x33, 0x5B,
  0xFE, 0x0D, 0x70, 0xBF, 0xFF, 0xFC, 0x05, 0x70, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x72, 0x06, 0xFF,
  0xFF, 0x90, 0xE0, 0x27, 0x30, 0x9F, 0xFF, 0xF0, 0x47, 0x50, 0xBF, 0xFF, 0xD0, 0x67, 0x70, 0xAF,
  0xFF, 0xB0, 0x67, 0x72, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x74, 0x03, 0x0C, 0xFF, 0xC0, 0x90, 0x17,
  0x77, 0x04, 0x0B, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x48, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0xA7,
  0x37, 0x70,
  // "Ŏ" (U+014E)
  0x74, 0x03, 0x80, 0x27, 0x06, 0x77, 0x80, 0x37, 0x01, 0x77, 0x70, 0x4E, 0x0E, 0x76, 0x03, 0xF0,
  0x17, 0x77, 0x03, 0xF0, 0x37, 0x50, 0x7F, 0x77, 0x71, 0x01, 0xF0, 0xB7, 0x40, 0x10, 0xEE, 0x0D,
  0x77, 0x72, 0x0E, 0xF0, 0x87, 0x20, 0x20, 0xCF, 0x09, 0x77, 0x72, 0x0A, 0xF9, 0x82, 0xD7, 0x31,
  0x28, 0x12, 0x59, 0xFA, 0x05, 0x77, 0x72, 0x05, 0xFF, 0xFC, 0x0E, 0x01, 0x77, 0x73, 0x0D, 0xFF,
  0xFB, 0x08, 0x77, 0x74, 0x06, 0xFF, 0xFA, 0x0E, 0x77, 0x76, 0x0C, 0xFF, 0xF9, 0x04, 0x77, 0x76,
  0x02, 0x0E, 0xFF, 0xE0, 0x67, 0x77, 0x71, 0x03, 0x0E, 0xFF, 0xC0, 0x67, 0x77, 0x73, 0x01, 0x0C,
  0xFF, 0x90, 0xD0, 0x37, 0x77, 0x76, 0x05, 0x0C, 0xFC, 0x0E, 0x06, 0x80, 0xC2, 0x08, 0x91, 0x37,
  0xBC, 0xEF, 0xED, 0xB8, 0x38, 0x0C, 0xC1, 0x08, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85,
  0x27, 0x77, 0x75, 0x81, 0x39, 0xEF, 0xF9, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C,
  0x03, 0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFC, 0x0A, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0,
  0x37, 0x75, 0x08, 0xFF, 0xFF, 0xB0, 0x57, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF,
  0xFF, 0xF0, 0x47, 0x60, 0x48, 0x0C, 0x0F, 0x0E, 0x02, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7,
  0x40, 0xA8, 0x0C, 0x3F, 0x06, 0x72, 0x03, 0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9,
  0x0E, 0x01, 0x71, 0x0B, 0xFF, 0x0D, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7,
  0x60, 0xBF, 0xE0, 0xE7, 0x09, 0xFE, 0x0D, 0x77, 0x10, 0xCF, 0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02,
  0x77, 0x10, 0x2F, 0xE0, 0xD5, 0x05, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01,
  0x77, 0x30, 0x1F, 0xE0, 0x74, 0x0E, 0xFD, 0x0A, 0x77, 0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04,
  0x77, 0x50, 0x5F, 0xE0, 0x12, 0x07, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B,
  0x77, 0x70, 0xCF, 0xD0, 0x72, 0x0D, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77,
  0x70, 0x6F, 0xD8, 0x1D, 0x02, 0xFE, 0x02, 0x77, 0x70, 0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01,
  0xFE, 0x01, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x03, 0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD,
  0x04, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD,
  0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD,
  0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD,
  0x08, 0x09, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD,
  0x07, 0x08, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD,
  0x05, 0x06, 0xFD, 0x0B, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02,
  0x03, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x17, 0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF,
  0xD0, 0x47, 0x77, 0x06, 0xFD, 0x0D, 0x20, 0xCF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F,
  0xD0, 0xA7, 0x77, 0x0C, 0xFD, 0x06, 0x20, 0x5F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F,
  0xE0, 0x47, 0x75, 0x05, 0xFE, 0x40, 0xDF, 0xD0, 0x97, 0x75, 0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0,
  0xE0, 0x17, 0x73, 0x02, 0xFE, 0x06, 0x40, 0x4F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF,
  0xE0, 0x27, 0x71, 0x03, 0xFE, 0x0C, 0x60, 0x8F, 0xE0, 0xC7, 0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F,
  0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x10, 0x9F, 0xF0, 0xD0, 0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87,
  0x10, 0x20, 0xEF, 0xF9, 0x81, 0xB6, 0x23, 0x81, 0x36, 0xBF, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80,
  0xC3, 0xF0, 0x57, 0x40, 0xD8, 0x0C, 0x1F, 0x0B, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27,
  0x60, 0x4F, 0xFF, 0xFF, 0x03, 0x77, 0x10, 0x6F, 0xFF, 0xFD, 0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA,
  0x0E, 0x04, 0x77, 0x50, 0x40, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09,
  0x01, 0x77, 0x73, 0x04, 0x0C, 0xFF, 0xF0, 0xB0, 0x37, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D,
  0x82, 0x77, 0x77, 0x58, 0x43, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x27, 0x74,
  // "ŏ" (U+014F)
  0x60, 0x38, 0x02, 0x70, 0x67, 0x78, 0x03, 0x70, 0x17, 0x40, 0x4E, 0x0E, 0x76, 0x03, 0xF0, 0x17,
  0x40, 0x3F, 0x03, 0x75, 0x07, 0xF7, 0x50, 0x1F, 0x0B, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60, 0xEF,
  0x08, 0x72, 0x02, 0x0C, 0xF0, 0x97, 0x60, 0xAF, 0x98, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0xA0,
  0x57, 0x60, 0x5F, 0xFF, 0xC0, 0xE0, 0x17, 0x70, 0xDF, 0xFF, 0xB0, 0x87, 0x71, 0x06, 0xFF, 0xFA,
  0x0E, 0x77, 0x30, 0xCF, 0xFF, 0x90, 0x47, 0x73, 0x02, 0x0E, 0xFF, 0xE0, 0x67, 0x75, 0x03, 0x0E,
  0xFF, 0xC0, 0x67, 0x77, 0x01, 0x0C, 0xFF, 0x90, 0xD0, 0x37, 0x77, 0x30, 0x50, 0xCF, 0xC0, 0xE0,
  0x67, 0x77, 0x78, 0x91, 0x37, 0xBC, 0xEF, 0xED, 0xB8, 0x38, 0x0B, 0xC6, 0x08, 0x42, 0x69, 0xCD,
  0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x6C, 0xFE, 0x81, 0xE8, 0x27, 0x77, 0x06, 0x0E,
  0xFF, 0xC0, 0x90, 0x17, 0x73, 0x01, 0x0C, 0xFF, 0xF0, 0xD0, 0x47, 0x71, 0x03, 0x0E, 0xFF, 0xFB,
  0x06, 0x76, 0x03, 0x0E, 0xFF, 0xFD, 0x07, 0x74, 0x02, 0x0E, 0xFF, 0xFF, 0x06, 0x73, 0x0C, 0xFF,
  0xFF, 0xA0, 0x37, 0x10, 0x7F, 0xFF, 0xFB, 0x0D, 0x70, 0x1F, 0xFF, 0xFD, 0x07, 0x60, 0x8F, 0xE8,
  0x5E, 0x84, 0x33, 0x6B, 0xFE, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x07,
  0x40, 0x6F, 0xD0, 0xB7, 0x20, 0x3F, 0xD0, 0xE4, 0x0B, 0xFC, 0x0E, 0x02, 0x73, 0x08, 0xFD, 0x04,
  0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xD0, 0x92, 0x05, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0D, 0x20,
  0x8F, 0xC0, 0xD7, 0x60, 0x6F, 0xD8, 0x11, 0x0C, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x81, 0x40, 0xEF,
  0xC0, 0x77, 0x7F, 0xD0, 0x70, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0xA0, 0x3F, 0xD0, 0x37, 0x70,
  0xBF, 0xC0, 0xB0, 0x5F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xD0, 0x5F, 0xD7, 0x71, 0x09, 0xFC, 0x0E,
  0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x7F, 0xD7, 0x71, 0x08, 0xFD, 0x07, 0xFC, 0x0E, 0x77,
  0x10, 0x7F, 0xD0, 0x6F, 0xD7, 0x71, 0x08, 0xFD, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE0, 0x5F,
  0xD7, 0x71, 0x09, 0xFC, 0x0D, 0x04, 0xFD, 0x01, 0x77, 0x0A, 0xFC, 0x0C, 0x02, 0xFD, 0x03, 0x77,
  0x0C, 0xFC, 0x0A, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC8, 0x18, 0x0D, 0xFC, 0x07, 0x77, 0xFD, 0x81,
  0x60, 0x9F, 0xC0, 0xA7, 0x60, 0x3F, 0xD8, 0x13, 0x06, 0xFC, 0x0E, 0x76, 0x07, 0xFC, 0x0E, 0x20,
  0x2F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xB3, 0x0D, 0xFC, 0x09, 0x74, 0x01, 0xFD, 0x06, 0x30, 0x8F,
  0xC0, 0xE0, 0x27, 0x30, 0x9F, 0xD0, 0x13, 0x02, 0xFD, 0x0B, 0x72, 0x04, 0xFD, 0x0B, 0x50, 0xBF,
  0xD0, 0xB7, 0x04, 0x0E, 0xFD, 0x05, 0x50, 0x3F, 0xE8, 0x5E, 0x84, 0x33, 0x5B, 0xFE, 0x0D, 0x70,
  0xBF, 0xFF, 0xFC, 0x05, 0x70, 0x20, 0xEF, 0xFF, 0xFA, 0x0B, 0x72, 0x06, 0xFF, 0xFF, 0x90, 0xE0,
  0x27, 0x30, 0x9F, 0xFF, 0xF0, 0x47, 0x50, 0xBF, 0xFF, 0xD0, 0x67, 0x70, 0xAF, 0xFF, 0xB0, 0x67,
  0x72, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x74, 0x03, 0x0C, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x04, 0x0B,
  0xFE, 0x81, 0xE8, 0x27, 0x77, 0x48, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x70,
  // "Ő" (U+0150)
  0x77, 0x60, 0x7F, 0xC0, 0x63, 0x0D, 0xFC, 0x77, 0x72, 0x0E, 0xFB, 0x0E, 0x01, 0x20, 0x5F, 0xC0,
  0x97, 0x77, 0x10, 0x7F, 0xC0, 0x63, 0x0D, 0xFB, 0x0D, 0x77, 0x71, 0x01, 0x0E, 0xFB, 0x0A, 0x30,
  0x7F, 0xB0, 0xE0, 0x27, 0x77, 0x10, 0x8F, 0xB0, 0xC3, 0x01, 0x0E, 0xFB, 0x05, 0x77, 0x71, 0x02,
  0xFB, 0x0C, 0x01, 0x30, 0x9F, 0xB0, 0x67, 0x77, 0x20, 0xAF, 0xA0, 0xD0, 0x13, 0x02, 0xFB, 0x07,
  0x77, 0x72, 0x04, 0xFA, 0x0D, 0x01, 0x40, 0xBF, 0xA0, 0x87, 0x77, 0x30, 0xCF, 0x90, 0xC0, 0x14,
  0x04, 0xFA, 0x08, 0x77, 0x73, 0x06, 0xF9, 0x0C, 0x01, 0x50, 0xDF, 0x90, 0x87, 0x77, 0x30, 0x10,
  0xEF, 0x0B, 0x60, 0x7F, 0x90, 0x87, 0x77, 0x40, 0x9F, 0x09, 0x60, 0x10, 0xEF, 0x07, 0x77, 0x74,
  0x03, 0xF0, 0x77, 0x09, 0xF0, 0x57, 0x77, 0x50, 0x6D, 0x0E, 0x04, 0x71, 0x0C, 0xD0, 0xE0, 0x38,
  0x0B, 0xD0, 0x08, 0x95, 0x26, 0x9B, 0xDE, 0xEF, 0xED, 0xCB, 0x85, 0x27, 0x77, 0x75, 0x81, 0x39,
  0xEF, 0xF9, 0x81, 0xE8, 0x27, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x0C, 0x03, 0x77, 0x73, 0x02, 0x0C,
  0xFF, 0xFC, 0x0A, 0x01, 0x77, 0x70, 0x60, 0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x75, 0x08, 0xFF, 0xFF,
  0xB0, 0x57, 0x73, 0x09, 0xFF, 0xFF, 0xD0, 0x67, 0x71, 0x07, 0xFF, 0xFF, 0xF0, 0x47, 0x60, 0x48,
  0x0C, 0x0F, 0x0E, 0x02, 0x74, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0xC7, 0x40, 0xA8, 0x0C, 0x3F, 0x06,
  0x72, 0x03, 0xFF, 0xA8, 0x2B, 0x63, 0x12, 0x81, 0x26, 0xBF, 0xF9, 0x0E, 0x01, 0x71, 0x0B, 0xFF,
  0x0D, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x08, 0x70, 0x3F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0, 0xE7, 0x09,
  0xFE, 0x0D, 0x77, 0x10, 0xCF, 0xE0, 0x65, 0x01, 0x0E, 0xFE, 0x02, 0x77, 0x10, 0x2F, 0xE0, 0xD5,
  0x05, 0xFE, 0x08, 0x77, 0x30, 0x9F, 0xE0, 0x24, 0x0A, 0xFE, 0x01, 0x77, 0x30, 0x1F, 0xE0, 0x74,
  0x0E, 0xFD, 0x0A, 0x77, 0x50, 0xAF, 0xD0, 0xC3, 0x03, 0xFE, 0x04, 0x77, 0x50, 0x5F, 0xE0, 0x12,
  0x07, 0xFD, 0x0E, 0x77, 0x60, 0x1F, 0xE0, 0x42, 0x0A, 0xFD, 0x0B, 0x77, 0x70, 0xCF, 0xD0, 0x72,
  0x0D, 0xFD, 0x07, 0x77, 0x70, 0x9F, 0xD0, 0xA2, 0xFE, 0x04, 0x77, 0x70, 0x6F, 0xD8, 0x1D, 0x02,
  0xFE, 0x02, 0x77, 0x70, 0x3F, 0xE1, 0x04, 0xFE, 0x77, 0x71, 0x01, 0xFE, 0x01, 0x05, 0xFD, 0x0D,
  0x77, 0x72, 0xFE, 0x03, 0x07, 0xFD, 0x0C, 0x77, 0x72, 0x0E, 0xFD, 0x04, 0x08, 0xFD, 0x0A, 0x77,
  0x72, 0x0D, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0C, 0xFD, 0x06, 0x09, 0xFD, 0x09, 0x77,
  0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x0A, 0xFD, 0x08, 0x77,
  0x72, 0x0A, 0xFD, 0x08, 0x0A, 0xFD, 0x08, 0x77, 0x72, 0x0A, 0xFD, 0x08, 0x09, 0xFD, 0x08, 0x77,
  0x72, 0x0B, 0xFD, 0x07, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07, 0x08, 0xFD, 0x09, 0x77,
  0x72, 0x0C, 0xFD, 0x06, 0x08, 0xFD, 0x0A, 0x77, 0x72, 0x0D, 0xFD, 0x05, 0x06, 0xFD, 0x0B, 0x77,
  0x72, 0x0E, 0xFD, 0x04, 0x05, 0xFD, 0x0D, 0x77, 0x72, 0xFE, 0x02, 0x03, 0xFE, 0x77, 0x71, 0x01,
  0xFE, 0x00, 0x1F, 0xE0, 0x17, 0x77, 0x03, 0xFD, 0x0E, 0x20, 0xEF, 0xD0, 0x47, 0x77, 0x06, 0xFD,
  0x0D, 0x20, 0xCF, 0xD0, 0x77, 0x77, 0x09, 0xFD, 0x09, 0x20, 0x9F, 0xD0, 0xA7, 0x77, 0x0C, 0xFD,
  0x06, 0x20, 0x5F, 0xD0, 0xE7, 0x76, 0x01, 0xFE, 0x03, 0x20, 0x2F, 0xE0, 0x47, 0x75, 0x05, 0xFE,
  0x40, 0xDF, 0xD0, 0x97, 0x75, 0x0B, 0xFD, 0x0B, 0x40, 0x8F, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFE,
  0x06, 0x40, 0x4F, 0xE0, 0x87, 0x73, 0x09, 0xFE, 0x02, 0x50, 0xEF, 0xE0, 0x27, 0x71, 0x03, 0xFE,
  0x0C, 0x60, 0x8F, 0xE0, 0xC7, 0x71, 0x0D, 0xFE, 0x06, 0x60, 0x1F, 0xF0, 0xB7, 0x60, 0xBF, 0xE0,
  0xE7, 0x10, 0x9F, 0xF0, 0xD0, 0x37, 0x20, 0x40, 0xDF, 0xF0, 0x87, 0x10, 0x20, 0xEF, 0xF9, 0x81,
  0xB6, 0x23, 0x81, 0x36, 0xBF, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0x80, 0xC3, 0xF0, 0x57, 0x40, 0xD8,
  0x0C, 0x1F, 0x0B, 0x75, 0x02, 0x0E, 0xFF, 0xFF, 0xF0, 0xE0, 0x27, 0x60, 0x4F, 0xFF, 0xFF, 0x03,
  0x77, 0x10, 0x6F, 0xFF, 0xFD, 0x05, 0x77, 0x30, 0x5F, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x50, 0x40,
  0xEF, 0xFF, 0xE0, 0xE0, 0x37, 0x77, 0x01, 0x0B, 0xFF, 0xFC, 0x09, 0x01, 0x77, 0x73, 0x04, 0x0C,
  0xFF, 0xF0, 0xB0, 0x37, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0x98, 0x1D, 0x82, 0x77, 0x77, 0x58, 0x43,
  0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCB, 0x85, 0x27, 0x74,
  // "ő" (U+0151)
  0x77, 0x10, 0x7F, 0xC0, 0x63, 0x0D, 0xFC, 0x77, 0x10, 0xEF, 0xB0, 0xE0, 0x12, 0x05, 0xFC, 0x09,
  0x77, 0x07, 0xFC, 0x06, 0x30, 0xDF, 0xB0, 0xD7, 0x70, 0x10, 0xEF, 0xB0, 0xA3, 0x07, 0xFB, 0x0E,
  0x02, 0x77, 0x08, 0xFB, 0x0C, 0x30, 0x10, 0xEF, 0xB0, 0x57, 0x70, 0x2F, 0xB0, 0xC0, 0x13, 0x09,
  0xFB, 0x06, 0x77, 0x10, 0xAF, 0xA0, 0xD0, 0x13, 0x02, 0xFB, 0x07, 0x77, 0x10, 0x4F, 0xA0, 0xD0,
  0x14, 0x0B, 0xFA, 0x08, 0x77, 0x20, 0xCF, 0x90, 0xC0, 0x14, 0x04, 0xFA, 0x08, 0x77, 0x20, 0x6F,
  0x90, 0xC0, 0x15, 0x0D, 0xF9, 0x08, 0x77, 0x20, 0x10, 0xEF, 0x0B, 0x60, 0x7F, 0x90, 0x87, 0x73,
  0x09, 0xF0, 0x96, 0x01, 0x0E, 0xF0, 0x77, 0x73, 0x03, 0xF0, 0x77, 0x09, 0xF0, 0x57, 0x74, 0x06,
  0xD0, 0xE0, 0x47, 0x10, 0xCD, 0x0E, 0x03, 0x80, 0xB8, 0x10, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E,
  0xCA, 0x73, 0x77, 0x76, 0x81, 0x16, 0xCF, 0xE8, 0x1E, 0x82, 0x77, 0x72, 0x06, 0x0E, 0xFF, 0xC0,
  0x90, 0x17, 0x75, 0x01, 0x0C, 0xFF, 0xF0, 0xD0, 0x47, 0x73, 0x03, 0x0E, 0xFF, 0xFB, 0x06, 0x77,
  0x10, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x60, 0x20, 0xEF, 0xFF, 0xF0, 0x67, 0x50, 0xCF, 0xFF, 0xFA,
  0x03, 0x73, 0x07, 0xFF, 0xFF, 0xB0, 0xD7, 0x20, 0x1F, 0xFF, 0xFD, 0x07, 0x71, 0x08, 0xFE, 0x85,
  0xE8, 0x43, 0x36, 0xBF, 0xE0, 0xE0, 0x16, 0x01, 0x0E, 0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x76,
  0x06, 0xFD, 0x0B, 0x72, 0x03, 0xFD, 0x0E, 0x60, 0xBF, 0xC0, 0xE0, 0x27, 0x30, 0x8F, 0xD0, 0x44,
  0x01, 0xFD, 0x09, 0x74, 0x01, 0xFD, 0x09, 0x40, 0x5F, 0xD0, 0x37, 0x50, 0xBF, 0xC0, 0xD4, 0x08,
  0xFC, 0x0D, 0x76, 0x06, 0xFD, 0x01, 0x30, 0xCF, 0xC0, 0xA7, 0x60, 0x3F, 0xD0, 0x43, 0x0E, 0xFC,
  0x07, 0x77, 0xFD, 0x07, 0x20, 0x1F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0xA2, 0x03, 0xFD, 0x03, 0x77,
  0x0B, 0xFC, 0x0B, 0x20, 0x5F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0xD2, 0x05, 0xFD, 0x77, 0x10, 0x9F,
  0xC0, 0xE2, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xC0, 0xE2, 0x07, 0xFD, 0x77, 0x10, 0x8F, 0xD2, 0x07,
  0xFC, 0x0E, 0x77, 0x10, 0x7F, 0xD2, 0x06, 0xFD, 0x77, 0x10, 0x8F, 0xD2, 0x06, 0xFD, 0x77, 0x10,
  0x8F, 0xC0, 0xE2, 0x05, 0xFD, 0x77, 0x10, 0x9F, 0xC0, 0xD2, 0x04, 0xFD, 0x01, 0x77, 0x0A, 0xFC,
  0x0C, 0x20, 0x2F, 0xD0, 0x37, 0x70, 0xCF, 0xC0, 0xA3, 0xFD, 0x04, 0x77, 0x0D, 0xFC, 0x08, 0x30,
  0xDF, 0xC0, 0x77, 0x7F, 0xD0, 0x63, 0x09, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x03, 0x30, 0x6F, 0xC0,
  0xE7, 0x60, 0x7F, 0xC0, 0xE4, 0x02, 0xFD, 0x03, 0x75, 0x0B, 0xFC, 0x0B, 0x50, 0xDF, 0xC0, 0x97,
  0x40, 0x1F, 0xD0, 0x65, 0x08, 0xFC, 0x0E, 0x02, 0x73, 0x09, 0xFD, 0x01, 0x50, 0x2F, 0xD0, 0xB7,
  0x20, 0x4F, 0xD0, 0xB7, 0x0B, 0xFD, 0x0B, 0x70, 0x40, 0xEF, 0xD0, 0x57, 0x03, 0xFE, 0x85, 0xE8,
  0x43, 0x35, 0xBF, 0xE0, 0xD7, 0x20, 0xBF, 0xFF, 0xFC, 0x05, 0x72, 0x02, 0x0E, 0xFF, 0xFF, 0xA0,
  0xB7, 0x40, 0x6F, 0xFF, 0xF9, 0x0E, 0x02, 0x75, 0x09, 0xFF, 0xFF, 0x04, 0x77, 0x0B, 0xFF, 0xFD,
  0x06, 0x77, 0x20, 0xAF, 0xFF, 0xB0, 0x67, 0x74, 0x08, 0xFF, 0xF0, 0xE0, 0x47, 0x76, 0x03, 0x0C,
  0xFF, 0xC0, 0x90, 0x17, 0x77, 0x20, 0x40, 0xBF, 0xE8, 0x1E, 0x82, 0x77, 0x76, 0x89, 0x31, 0x59,
  0xCD, 0xEF, 0xED, 0xCA, 0x73, 0x77, 0x20,
  // "Œ" (U+0152)
  0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB8, 0x62, 0x80, 0xD2, 0x00, 0x50, 0xB8, 0x0D,
  0x1F, 0x0A, 0x76, 0x06, 0x0E, 0x80, 0xD3, 0xF0, 0xA7, 0x40, 0x30, 0xD8, 0x0D, 0x5F, 0x0A, 0x73,
  0x06, 0x80, 0xD7, 0xF0, 0xA7, 0x20, 0x88, 0x0E, 0x0F, 0x0A, 0x71, 0x09, 0x80, 0xE1, 0xF0, 0xA7,
  0x06, 0x80, 0xE2, 0xF0, 0xA6, 0x04, 0x80, 0xE3, 0xF0, 0xA5, 0x01, 0x0E, 0x80, 0xE3, 0xF0, 0xA5,
  0x09, 0x80, 0xE4, 0xF0, 0xA4, 0x02, 0xFF, 0xA8, 0x1A, 0x52, 0x28, 0x41, 0x23, 0x59, 0xEF, 0xC0,
  0xB8, 0x09, 0x62, 0x01, 0x40, 0xBF, 0xF0, 0xB0, 0x27, 0x30, 0xCF, 0xC0, 0xA7, 0x77, 0x10, 0x2F,
  0xF0, 0x97, 0x50, 0xCF, 0xC0, 0xA7, 0x77, 0x10, 0x8F, 0xE0, 0xA7, 0x60, 0xCF, 0xC0, 0xA7, 0x77,
  0x10, 0xEF, 0xD0, 0xE0, 0x17, 0x60, 0xCF, 0xC0, 0xA7, 0x77, 0x04, 0xFE, 0x06, 0x77, 0x0C, 0xFC,
  0x0A, 0x77, 0x70, 0x9F, 0xD0, 0xE7, 0x71, 0x0C, 0xFC, 0x0A, 0x77, 0x70, 0xEF, 0xD0, 0x87, 0x71,
  0x0C, 0xFC, 0x0A, 0x77, 0x60, 0x3F, 0xE0, 0x27, 0x71, 0x0C, 0xFC, 0x0A, 0x77, 0x60, 0x6F, 0xD0,
  0xD7, 0x72, 0x0C, 0xFC, 0x0A, 0x77, 0x60, 0x9F, 0xD0, 0x97, 0x72, 0x0C, 0xFC, 0x0A, 0x77, 0x60,
  0xCF, 0xD0, 0x67, 0x72, 0x0C, 0xFC, 0x0A, 0x77, 0x6F, 0xE0, 0x37, 0x72, 0x0C, 0xFC, 0x0A, 0x77,
  0x50, 0x1F, 0xE7, 0x73, 0x0C, 0xFC, 0x0A, 0x77, 0x50, 0x3F, 0xD0, 0xD7, 0x73, 0x0C, 0xFC, 0x0A,
  0x77, 0x50, 0x5F, 0xD0, 0xC7, 0x73, 0x0C, 0xFC, 0x0B, 0x80, 0x95, 0x28, 0x11, 0x07, 0xFD, 0x0A,
  0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x81, 0x60, 0x8F, 0xD0, 0x97, 0x73, 0x0C, 0xFF, 0xFF, 0x98, 0x16,
  0x08, 0xFD, 0x08, 0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x81, 0x60, 0x9F, 0xD0, 0x77, 0x73, 0x0C, 0xFF,
  0xFF, 0x98, 0x16, 0x09, 0xFD, 0x07, 0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x81, 0x60, 0xAF, 0xD0, 0x77,
  0x73, 0x0C, 0xFF, 0xFF, 0x98, 0x16, 0x0A, 0xFD, 0x07, 0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x81, 0x60,
  0x9F, 0xD0, 0x77, 0x73, 0x0C, 0xFF, 0xFF, 0x98, 0x16, 0x09, 0xFD, 0x07, 0x77, 0x30, 0xCF, 0xFF,
  0xF9, 0x81, 0x60, 0x8F, 0xD0, 0x87, 0x73, 0x0C, 0xFF, 0xFF, 0x98, 0x16, 0x08, 0xFD, 0x09, 0x77,
  0x30, 0xCF, 0xC0, 0xA7, 0x75, 0x06, 0xFD, 0x0A, 0x77, 0x30, 0xCF, 0xC0, 0xA7, 0x75, 0x05, 0xFD,
  0x0C, 0x77, 0x30, 0xCF, 0xC0, 0xA7, 0x75, 0x03, 0xFD, 0x0D, 0x77, 0x30, 0xCF, 0xC0, 0xA7, 0x75,
  0x01, 0xFE, 0x77, 0x30, 0xCF, 0xC0, 0xA7, 0x76, 0x0E, 0xFD, 0x03, 0x77, 0x20, 0xCF, 0xC0, 0xA7,
  0x76, 0x0B, 0xFD, 0x06, 0x77, 0x20, 0xCF, 0xC0, 0xA7, 0x76, 0x08, 0xFD, 0x09, 0x77, 0x20, 0xCF,
  0xC0, 0xA7, 0x76, 0x05, 0xFD, 0x0D, 0x77, 0x20, 0xCF, 0xC0, 0xA7, 0x76, 0x02, 0xFE, 0x02, 0x77,
  0x10, 0xCF, 0xC0, 0xA7, 0x77, 0x0D, 0xFD, 0x08, 0x77, 0x10, 0xCF, 0xC0, 0xA7, 0x77, 0x08, 0xFD,
  0x0E, 0x77, 0x10, 0xCF, 0xC0, 0xA7, 0x77, 0x04, 0xFE, 0x06, 0x77, 0x0C, 0xFC, 0x0A, 0x77, 0x71,
  0x0E, 0xFD, 0x0E, 0x01, 0x76, 0x0C, 0xFC, 0x0A, 0x77, 0x71, 0x08, 0xFE, 0x0B, 0x76, 0x0C, 0xFC,
  0x0A, 0x77, 0x71, 0x01, 0xFF, 0x09, 0x75, 0x0C, 0xFC, 0x0A, 0x77, 0x72, 0x0A, 0xFF, 0x0C, 0x02,
  0x73, 0x0D, 0xFC, 0x0A, 0x77, 0x72, 0x02, 0xFF, 0xA8, 0x1B, 0x52, 0x38, 0x22, 0x48, 0xDF, 0xFF,
  0xFB, 0x0A, 0x50, 0x88, 0x0E, 0x4F, 0x0A, 0x60, 0xD8, 0x0E, 0x3F, 0x0A, 0x60, 0x38, 0x0E, 0x3F,
  0x0A, 0x70, 0x68, 0x0E, 0x2F, 0x0A, 0x71, 0x08, 0x80, 0xE1, 0xF0, 0xA7, 0x20, 0x78, 0x0E, 0x0F,
  0x0A, 0x73, 0x06, 0x80, 0xD7, 0xF0, 0xA7, 0x40, 0x30, 0xD8, 0x0D, 0x5F, 0x0A, 0x76, 0x07, 0x0E,
  0x80, 0xD3, 0xF0, 0xA7, 0x71, 0x05, 0x0B, 0x80, 0xD1, 0xF0, 0xA7, 0x74, 0x84, 0x48, 0xAC, 0xEE,
  0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x73,
  // "œ" (U+0153)
  0x77, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x62, 0x77, 0x18, 0x33, 0x7A, 0xDE, 0xA8, 0x4E,
  0xDB, 0x85, 0x17, 0x77, 0x28, 0x11, 0x7D, 0xFE, 0x0C, 0x06, 0x73, 0x81, 0x17, 0xDF, 0xE0, 0xA0,
  0x37, 0x76, 0x08, 0x0E, 0xFF, 0xB0, 0xD0, 0x57, 0x06, 0x0E, 0xFF, 0xB0, 0xB0, 0x27, 0x72, 0x03,
  0x0D, 0xFF, 0xF0, 0x95, 0x0A, 0xFF, 0xE0, 0xE0, 0x57, 0x70, 0x40, 0xEF, 0xFF, 0xA0, 0xB2, 0x01,
  0x0C, 0xFF, 0xFA, 0x07, 0x75, 0x04, 0xFF, 0xFD, 0x81, 0xA0, 0xCF, 0xFF, 0xC0, 0x67, 0x30, 0x20,
  0xEF, 0xFF, 0xE0, 0xDF, 0xFF, 0xE0, 0x37, 0x20, 0xC8, 0x0E, 0x4F, 0x0D, 0x71, 0x07, 0x80, 0xE6,
  0xF0, 0x76, 0x01, 0x0E, 0x80, 0xC3, 0xF8, 0x1E, 0x73, 0x28, 0x12, 0x7D, 0xFD, 0x01, 0x50, 0x9F,
  0xE8, 0x5E, 0x84, 0x33, 0x6B, 0xFF, 0xD0, 0xC0, 0x16, 0x01, 0x0B, 0xFC, 0x07, 0x40, 0x10, 0xEF,
  0xD0, 0xB7, 0x04, 0x0E, 0xFF, 0xA0, 0xC0, 0x17, 0x10, 0x10, 0xDF, 0xB0, 0xD4, 0x06, 0xFD, 0x0B,
  0x72, 0x03, 0xFF, 0xA0, 0x37, 0x30, 0x4F, 0xC0, 0x33, 0x0C, 0xFC, 0x0E, 0x02, 0x73, 0x08, 0xFF,
  0x0B, 0x75, 0x0C, 0xFB, 0x08, 0x20, 0x1F, 0xD0, 0x97, 0x40, 0x1F, 0xF0, 0x57, 0x50, 0x7F, 0xB0,
  0xC2, 0x05, 0xFD, 0x03, 0x75, 0x0B, 0xFE, 0x01, 0x75, 0x03, 0xFC, 0x20, 0x9F, 0xC0, 0xD7, 0x60,
  0x6F, 0xD0, 0xE7, 0x7F, 0xC8, 0x13, 0x0C, 0xFC, 0x0A, 0x76, 0x03, 0xFD, 0x0B, 0x77, 0x0D, 0xFB,
  0x81, 0x50, 0xEF, 0xC0, 0x77, 0x7F, 0xD0, 0xA7, 0x70, 0xDF, 0xB0, 0x70, 0x1F, 0xD0, 0x47, 0x70,
  0xDF, 0xC0, 0x97, 0x70, 0xCF, 0xB0, 0x80, 0x3F, 0xD0, 0x37, 0x70, 0xB8, 0x0C, 0x1F, 0x09, 0x04,
  0xFD, 0x01, 0x77, 0x0A, 0x80, 0xC1, 0xF0, 0x90, 0x6F, 0xD7, 0x71, 0x09, 0x80, 0xC1, 0xF0, 0xA0,
  0x6F, 0xD7, 0x71, 0x08, 0x80, 0xC1, 0xF0, 0xA0, 0x7F, 0xD7, 0x71, 0x08, 0x80, 0xC1, 0xF0, 0xA0,
  0x7F, 0xC0, 0xE7, 0x71, 0x07, 0x80, 0xC1, 0xF0, 0xA0, 0x6F, 0xD7, 0x71, 0x08, 0x80, 0xC1, 0xF0,
  0xA0, 0x6F, 0xD7, 0x71, 0x08, 0x80, 0xC1, 0xF0, 0xA0, 0x5F, 0xD7, 0x71, 0x09, 0x80, 0xC1, 0xF0,
  0xA0, 0x4F, 0xD0, 0x17, 0x70, 0xAF, 0xC0, 0x77, 0x77, 0x50, 0x2F, 0xD0, 0x37, 0x70, 0xCF, 0xC0,
  0x87, 0x77, 0x6F, 0xD0, 0x47, 0x70, 0xDF, 0xC0, 0x97, 0x77, 0x60, 0xEF, 0xC0, 0x77, 0x7F, 0xD0,
  0xC7, 0x77, 0x60, 0xAF, 0xC0, 0xA7, 0x60, 0x3F, 0xE7, 0x77, 0x60, 0x7F, 0xC0, 0xE7, 0x60, 0x7F,
  0xE0, 0x47, 0x77, 0x50, 0x3F, 0xD0, 0x37, 0x50, 0xBF, 0xE0, 0xA7, 0x77, 0x60, 0xEF, 0xC0, 0x97,
  0x40, 0x1F, 0xF9, 0x02, 0x77, 0x75, 0x09, 0xFC, 0x0E, 0x02, 0x73, 0x09, 0xFF, 0x90, 0xC7, 0x77,
  0x50, 0x4F, 0xD0, 0xB7, 0x20, 0x4F, 0xFB, 0x0B, 0x77, 0x38, 0x22, 0x8E, 0x35, 0x0D, 0xFD, 0x0B,
  0x70, 0x40, 0xEF, 0xFC, 0x0C, 0x04, 0x75, 0x81, 0x26, 0xBB, 0x03, 0x50, 0x5F, 0xE8, 0x5E, 0x84,
  0x33, 0x5B, 0xFF, 0xF9, 0x89, 0x2D, 0x85, 0x32, 0x33, 0x45, 0x8A, 0xDE, 0x03, 0x60, 0xD8, 0x0E,
  0x7F, 0x03, 0x60, 0x38, 0x0E, 0x7F, 0x03, 0x70, 0x88, 0x0E, 0x6F, 0x03, 0x71, 0x0B, 0xFF, 0xFE,
  0x04, 0x0D, 0xFF, 0xFF, 0x03, 0x71, 0x01, 0x0C, 0xFF, 0xFC, 0x82, 0x60, 0x2E, 0xFF, 0xFE, 0x03,
  0x72, 0x01, 0x0C, 0xFF, 0xFA, 0x07, 0x30, 0x20, 0xDF, 0xFF, 0xD0, 0x37, 0x40, 0x9F, 0xFF, 0x06,
  0x50, 0x10, 0xBF, 0xFF, 0xB0, 0xC0, 0x17, 0x50, 0x40, 0xDF, 0xFB, 0x0C, 0x03, 0x71, 0x06, 0x0E,
  0xFF, 0xE0, 0xC0, 0x57, 0x72, 0x05, 0x0B, 0xFE, 0x0C, 0x05, 0x75, 0x06, 0x0D, 0xFF, 0x98, 0x1D,
  0x93, 0x77, 0x68, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xEC, 0xA6, 0x27, 0x72, 0x89, 0x52, 0x69, 0xCD,
  0xEF, 0xEE, 0xDC, 0xA7, 0x52, 0x72,
  // "Ŕ" (U+0154)
  0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x77, 0x71, 0x0E, 0xFE, 0x03, 0x77, 0x77, 0x08, 0xFE, 0x05, 0x77,
  0x77, 0x02, 0xFE, 0x06, 0x77, 0x77, 0x10, 0xBF, 0xD0, 0x67, 0x77, 0x71, 0x05, 0xFD, 0x06, 0x77,
  0x77, 0x10, 0x10, 0xEF, 0xC0, 0x67, 0x77, 0x72, 0x0A, 0xFC, 0x05, 0x77, 0x77, 0x20, 0x6F, 0xC0,
  0x57, 0x77, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x77, 0x77, 0x30, 0xBF, 0xA0, 0xE0, 0x37, 0x77,
  0x73, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x77, 0x30, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x74, 0x06, 0xF9,
  0x0A, 0x80, 0xBD, 0x60, 0x08, 0xFF, 0xB8, 0x5E, 0xEC, 0xB9, 0x74, 0x77, 0x50, 0x8F, 0xFF, 0xC8,
  0x1C, 0x72, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0xB0, 0x47, 0x60, 0x8F, 0xFF, 0xFA, 0x0B, 0x01, 0x74,
  0x08, 0xFF, 0xFF, 0xB0, 0xE0, 0x47, 0x30, 0x8F, 0xFF, 0xFD, 0x05, 0x72, 0x08, 0xFF, 0xFF, 0xE0,
  0x47, 0x10, 0x8F, 0xFF, 0xFE, 0x0E, 0x01, 0x70, 0x8F, 0xFF, 0xFF, 0x09, 0x70, 0x88, 0x0C, 0x0F,
  0x02, 0x60, 0x8F, 0xD8, 0x64, 0x22, 0x23, 0x47, 0xBF, 0xFA, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x01,
  0x08, 0xFF, 0x0E, 0x60, 0x8F, 0xD0, 0x27, 0x20, 0x4F, 0xF0, 0x35, 0x08, 0xFD, 0x02, 0x73, 0x05,
  0xFE, 0x07, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0xCF, 0xD0, 0xA5, 0x08, 0xFD, 0x02, 0x74, 0x06, 0xFD,
  0x0C, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0x3F, 0xD0, 0xE5, 0x08, 0xFD, 0x02, 0x74, 0x01, 0xFD, 0x0E,
  0x50, 0x8F, 0xD0, 0x27, 0x5F, 0xE5, 0x08, 0xFD, 0x02, 0x75, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27,
  0x5F, 0xD0, 0xD5, 0x08, 0xFD, 0x02, 0x74, 0x02, 0xFD, 0x0C, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0x5F,
  0xD0, 0xA5, 0x08, 0xFD, 0x02, 0x74, 0x0A, 0xFD, 0x07, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x1F, 0xE0,
  0x45, 0x08, 0xFD, 0x02, 0x73, 0x0A, 0xFD, 0x0E, 0x60, 0x8F, 0xD0, 0x27, 0x20, 0x8F, 0xE0, 0x96,
  0x08, 0xFD, 0x02, 0x70, 0x20, 0xBF, 0xF0, 0x26, 0x08, 0xFD, 0x86, 0x42, 0x22, 0x34, 0x7B, 0xFF,
  0x90, 0xA7, 0x08, 0xFF, 0xFF, 0xE0, 0xE0, 0x17, 0x08, 0xFF, 0xFF, 0xE0, 0x57, 0x10, 0x8F, 0xFF,
  0xFD, 0x07, 0x72, 0x08, 0xFF, 0xFF, 0xC0, 0x87, 0x30, 0x8F, 0xFF, 0xFB, 0x07, 0x74, 0x08, 0xFF,
  0xFF, 0x90, 0xD0, 0x47, 0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x70, 0x8F, 0xFF, 0xF0, 0x57, 0x70, 0x8F,
  0xFF, 0xF0, 0xD7, 0x70, 0x8F, 0xFF, 0xF9, 0x06, 0x76, 0x08, 0xFD, 0x02, 0x40, 0xCF, 0xC0, 0xE7,
  0x60, 0x8F, 0xD0, 0x24, 0x05, 0xFD, 0x07, 0x75, 0x08, 0xFD, 0x02, 0x50, 0xDF, 0xC0, 0xE0, 0x17,
  0x40, 0x8F, 0xD0, 0x25, 0x06, 0xFD, 0x08, 0x74, 0x08, 0xFD, 0x02, 0x60, 0xDF, 0xC0, 0xE0, 0x17,
  0x30, 0x8F, 0xD0, 0x26, 0x06, 0xFD, 0x09, 0x73, 0x08, 0xFD, 0x02, 0x70, 0xEF, 0xD0, 0x27, 0x20,
  0x8F, 0xD0, 0x27, 0x07, 0xFD, 0x0A, 0x72, 0x08, 0xFD, 0x02, 0x71, 0x0E, 0xFD, 0x03, 0x71, 0x08,
  0xFD, 0x02, 0x71, 0x08, 0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x01, 0x0E, 0xFD, 0x03, 0x70,
  0x8F, 0xD0, 0x27, 0x20, 0x8F, 0xD0, 0xC7, 0x08, 0xFD, 0x02, 0x72, 0x01, 0xFE, 0x04, 0x60, 0x8F,
  0xD0, 0x27, 0x30, 0x9F, 0xD0, 0xC6, 0x08, 0xFD, 0x02, 0x73, 0x02, 0xFE, 0x05, 0x50, 0x8F, 0xD0,
  0x27, 0x40, 0xAF, 0xD0, 0xD5, 0x08, 0xFD, 0x02, 0x74, 0x02, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27,
  0x50, 0xAF, 0xD0, 0xE4, 0x08, 0xFD, 0x02, 0x75, 0x03, 0xFE, 0x07, 0x30, 0x8F, 0xD0, 0x27, 0x60,
  0xBF, 0xD0, 0xE0, 0x12, 0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x08, 0x20, 0x8F, 0xD0, 0x27, 0x70,
  0xBF, 0xE8, 0x11, 0x08, 0xFD, 0x02, 0x77, 0x04, 0xFE, 0x81, 0x90, 0x8F, 0xD0, 0x27, 0x71, 0x0C,
  0xFE, 0x02, 0x08, 0xFD, 0x02, 0x77, 0x10, 0x5F, 0xE0, 0xA0,
  // "ŕ" (U+0155)
  0x77, 0x10, 0x6F, 0xE0, 0xB7, 0x71, 0x0E, 0xFE, 0x03, 0x77, 0x08, 0xFE, 0x05, 0x77, 0x02, 0xFE,
  0x06, 0x77, 0x10, 0xBF, 0xD0, 0x67, 0x71, 0x05, 0xFD, 0x06, 0x77, 0x10, 0x10, 0xEF, 0xC0, 0x67,
  0x72, 0x0A, 0xFC, 0x05, 0x77, 0x20, 0x6F, 0xC0, 0x57, 0x72, 0x01, 0x0E, 0xFA, 0x0E, 0x04, 0x77,
  0x30, 0xBF, 0xA0, 0xE0, 0x37, 0x73, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x30, 0x2F, 0xA0, 0xC0, 0x17,
  0x74, 0x06, 0xF9, 0x0A, 0x80, 0xAA, 0x50, 0x86, 0x6A, 0xDE, 0xED, 0xB7, 0x20, 0x5F, 0xA0, 0x27,
  0x06, 0x0E, 0xF0, 0xE2, 0x05, 0xFA, 0x05, 0x60, 0xAF, 0xA0, 0xD2, 0x05, 0xFA, 0x09, 0x50, 0xCF,
  0xB0, 0xC2, 0x05, 0xFA, 0x0C, 0x40, 0xBF, 0xC0, 0xB2, 0x05, 0xFB, 0x01, 0x20, 0x8F, 0xD0, 0xA2,
  0x05, 0xFB, 0x81, 0x40, 0x4F, 0xE0, 0x82, 0x05, 0xFB, 0x81, 0x80, 0xDF, 0xE0, 0x72, 0x05, 0xFB,
  0x0C, 0x07, 0xFF, 0x06, 0x20, 0x5F, 0xFF, 0xD0, 0x52, 0x05, 0xFF, 0xFD, 0x03, 0x20, 0x5F, 0xFF,
  0xD0, 0x22, 0x05, 0xFF, 0xB8, 0x2E, 0x94, 0x22, 0x82, 0x25, 0xC1, 0x20, 0x5F, 0xFA, 0x09, 0x01,
  0x74, 0x05, 0xFF, 0x90, 0x77, 0x60, 0x5F, 0xF0, 0x87, 0x70, 0x5F, 0xE0, 0xC7, 0x71, 0x05, 0xFE,
  0x04, 0x77, 0x10, 0x5F, 0xD0, 0xD7, 0x72, 0x05, 0xFD, 0x08, 0x77, 0x20, 0x5F, 0xD0, 0x57, 0x72,
  0x05, 0xFD, 0x02, 0x77, 0x20, 0x5F, 0xD7, 0x73, 0x05, 0xFD, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73,
  0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0,
  0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30,
  0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E,
  0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05,
  0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7,
  0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F,
  0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77, 0x30, 0x5F, 0xC0, 0xE7, 0x73, 0x05, 0xFC, 0x0E, 0x77,
  0x30,
  // "Ŗ" (U+0156)
  0x08, 0xFF, 0xB8, 0x5E, 0xEC, 0xB9, 0x74, 0x77, 0x50, 0x8F, 0xFF, 0xC8, 0x1C, 0x72, 0x77, 0x10,
  0x8F, 0xFF, 0xF0, 0xB0, 0x47, 0x60, 0x8F, 0xFF, 0xFA, 0x0B, 0x01, 0x74, 0x08, 0xFF, 0xFF, 0xB0,
  0xE0, 0x47, 0x30, 0x8F, 0xFF, 0xFD, 0x05, 0x72, 0x08, 0xFF, 0xFF, 0xE0, 0x47, 0x10, 0x8F, 0xFF,
  0xFE, 0x0E, 0x01, 0x70, 0x8F, 0xFF, 0xFF, 0x09, 0x70, 0x88, 0x0C, 0x0F, 0x02, 0x60, 0x8F, 0xD8,
  0x64, 0x22, 0x23, 0x47, 0xBF, 0xFA, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x01, 0x08, 0xFF, 0x0E, 0x60,
  0x8F, 0xD0, 0x27, 0x20, 0x4F, 0xF0, 0x35, 0x08, 0xFD, 0x02, 0x73, 0x05, 0xFE, 0x07, 0x50, 0x8F,
  0xD0, 0x27, 0x40, 0xCF, 0xD0, 0xA5, 0x08, 0xFD, 0x02, 0x74, 0x06, 0xFD, 0x0C, 0x50, 0x8F, 0xD0,
  0x27, 0x40, 0x3F, 0xD0, 0xE5, 0x08, 0xFD, 0x02, 0x74, 0x01, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27,
  0x5F, 0xE5, 0x08, 0xFD, 0x02, 0x75, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xD5, 0x08,
  0xFD, 0x02, 0x74, 0x02, 0xFD, 0x0C, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0x5F, 0xD0, 0xA5, 0x08, 0xFD,
  0x02, 0x74, 0x0A, 0xFD, 0x07, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x1F, 0xE0, 0x45, 0x08, 0xFD, 0x02,
  0x73, 0x0A, 0xFD, 0x0E, 0x60, 0x8F, 0xD0, 0x27, 0x20, 0x8F, 0xE0, 0x96, 0x08, 0xFD, 0x02, 0x70,
  0x20, 0xBF, 0xF0, 0x26, 0x08, 0xFD, 0x86, 0x42, 0x22, 0x34, 0x7B, 0xFF, 0x90, 0xA7, 0x08, 0xFF,
  0xFF, 0xE0, 0xE0, 0x17, 0x08, 0xFF, 0xFF, 0xE0, 0x57, 0x10, 0x8F, 0xFF, 0xFD, 0x07, 0x72, 0x08,
  0xFF, 0xFF, 0xC0, 0x87, 0x30, 0x8F, 0xFF, 0xFB, 0x07, 0x74, 0x08, 0xFF, 0xFF, 0x90, 0xD0, 0x47,
  0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x70, 0x8F, 0xFF, 0xF0, 0x57, 0x70, 0x8F, 0xFF, 0xF0, 0xD7, 0x70,
  0x8F, 0xFF, 0xF9, 0x06, 0x76, 0x08, 0xFD, 0x02, 0x40, 0xCF, 0xC0, 0xE7, 0x60, 0x8F, 0xD0, 0x24,
  0x05, 0xFD, 0x07, 0x75, 0x08, 0xFD, 0x02, 0x50, 0xDF, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0xD0, 0x25,
  0x06, 0xFD, 0x08, 0x74, 0x08, 0xFD, 0x02, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x30, 0x8F, 0xD0, 0x26,
  0x06, 0xFD, 0x09, 0x73, 0x08, 0xFD, 0x02, 0x70, 0xEF, 0xD0, 0x27, 0x20, 0x8F, 0xD0, 0x27, 0x07,
  0xFD, 0x0A, 0x72, 0x08, 0xFD, 0x02, 0x71, 0x0E, 0xFD, 0x03, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x08,
  0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x01, 0x0E, 0xFD, 0x03, 0x70, 0x8F, 0xD0, 0x27, 0x20,
  0x8F, 0xD0, 0xC7, 0x08, 0xFD, 0x02, 0x72, 0x01, 0xFE, 0x04, 0x60, 0x8F, 0xD0, 0x27, 0x30, 0x9F,
  0xD0, 0xC6, 0x08, 0xFD, 0x02, 0x73, 0x02, 0xFE, 0x05, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD0,
  0xD5, 0x08, 0xFD, 0x02, 0x74, 0x02, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27, 0x50, 0xAF, 0xD0, 0xE4,
  0x08, 0xFD, 0x02, 0x75, 0x03, 0xFE, 0x07, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0xBF, 0xD0, 0xE0, 0x12,
  0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x08, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0xBF, 0xE8, 0x11, 0x08,
  0xFD, 0x02, 0x77, 0x04, 0xFE, 0x81, 0x90, 0x8F, 0xD0, 0x27, 0x71, 0x0C, 0xFE, 0x02, 0x08, 0xFD,
  0x02, 0x77, 0x10, 0x5F, 0xE0, 0xA8, 0x0C, 0xA3, 0x00, 0x1F, 0xC0, 0x97, 0x77, 0x73, 0x03, 0xFC,
  0x07, 0x77, 0x77, 0x30, 0x5F, 0xC0, 0x17, 0x77, 0x73, 0x07, 0xFB, 0x0B, 0x77, 0x77, 0x40, 0x9F,
  0xB0, 0x57, 0x77, 0x74, 0x0C, 0xFA, 0x0D, 0x77, 0x77, 0x5F, 0xB0, 0x67, 0x77, 0x74, 0x02, 0xFA,
  0x0E, 0x77, 0x77, 0x50, 0x5F, 0xA0, 0x77, 0x77, 0x75, 0x08, 0xF9, 0x0E, 0x77, 0x77, 0x60, 0xBF,
  0x90, 0x67, 0x77, 0x76, 0x0E, 0xF0, 0xD7, 0x77, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x60, 0x4F,
  0x0A, 0x77, 0x71,
  // "ŗ" (U+0157)
  0x77, 0x78, 0x90, 0x6A, 0xDE, 0xED, 0xB7, 0x05, 0xFA, 0x02, 0x70, 0x60, 0xEF, 0x81, 0xE0, 0x5F,
  0xA0, 0x56, 0x0A, 0xFA, 0x81, 0xD0, 0x5F, 0xA0, 0x95, 0x0C, 0xFB, 0x81, 0xC0, 0x5F, 0xA0, 0xC4,
  0x0B, 0xFC, 0x81, 0xB0, 0x5F, 0xB0, 0x12, 0x08, 0xFD, 0x81, 0xA0, 0x5F, 0xB8, 0x14, 0x04, 0xFE,
  0x81, 0x80, 0x5F, 0xB8, 0x18, 0x0D, 0xFE, 0x81, 0x70, 0x5F, 0xB0, 0xC0, 0x7F, 0xF8, 0x16, 0x05,
  0xFF, 0xFD, 0x81, 0x50, 0x5F, 0xFF, 0xD8, 0x13, 0x05, 0xFF, 0xFD, 0x81, 0x20, 0x5F, 0xFB, 0x82,
  0xE9, 0x42, 0x28, 0x42, 0x5C, 0x10, 0x5F, 0xFA, 0x09, 0x01, 0x73, 0x05, 0xFF, 0x90, 0x77, 0x50,
  0x5F, 0xF0, 0x87, 0x60, 0x5F, 0xE0, 0xC7, 0x70, 0x5F, 0xE0, 0x47, 0x70, 0x5F, 0xD0, 0xD7, 0x71,
  0x05, 0xFD, 0x08, 0x77, 0x10, 0x5F, 0xD0, 0x57, 0x71, 0x05, 0xFD, 0x02, 0x77, 0x10, 0x5F, 0xD7,
  0x72, 0x05, 0xFD, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0,
  0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20,
  0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E,
  0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05,
  0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7,
  0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F,
  0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77, 0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x77,
  0x20, 0x5F, 0xC0, 0xE7, 0x72, 0x05, 0xFC, 0x0E, 0x80, 0xAF, 0x30, 0x01, 0xFC, 0x09, 0x77, 0x20,
  0x3F, 0xC0, 0x77, 0x72, 0x05, 0xFC, 0x01, 0x77, 0x20, 0x7F, 0xB0, 0xB7, 0x73, 0x09, 0xFB, 0x05,
  0x77, 0x30, 0xCF, 0xA0, 0xD7, 0x74, 0xFB, 0x06, 0x77, 0x30, 0x2F, 0xA0, 0xE7, 0x74, 0x05, 0xFA,
  0x07, 0x77, 0x40, 0x8F, 0x90, 0xE7, 0x75, 0x0B, 0xF9, 0x06, 0x77, 0x50, 0xEF, 0x0D, 0x77, 0x50,
  0x3F, 0x90, 0x37, 0x75, 0x04, 0xF0, 0xA7, 0x76,
  // "Ř" (U+0158)
  0x40, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x37, 0x50, 0x6F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x77, 0x60, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x60, 0x10, 0xEF, 0x90, 0x97,
  0x10, 0xAF, 0x90, 0xE0, 0x27, 0x71, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x73, 0x07, 0xFA,
  0x0A, 0x40, 0xBF, 0xA0, 0x97, 0x75, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7, 0x76, 0x01, 0x0E,
  0xFA, 0x00, 0x8F, 0xA0, 0xE0, 0x27, 0x77, 0x04, 0xFF, 0xE0, 0x67, 0x77, 0x20, 0x9F, 0xFC, 0x0A,
  0x77, 0x74, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x77, 0x40, 0x3F, 0xFA, 0x05, 0x77, 0x76, 0x08, 0xFF,
  0x0A, 0x77, 0x77, 0x10, 0xDF, 0xD0, 0xE0, 0x17, 0x77, 0x71, 0x05, 0xFD, 0x07, 0x80, 0xBD, 0x10,
  0x08, 0xFF, 0xB8, 0x5E, 0xEC, 0xB9, 0x74, 0x77, 0x50, 0x8F, 0xFF, 0xC8, 0x1C, 0x72, 0x77, 0x10,
  0x8F, 0xFF, 0xF0, 0xB0, 0x47, 0x60, 0x8F, 0xFF, 0xFA, 0x0B, 0x01, 0x74, 0x08, 0xFF, 0xFF, 0xB0,
  0xE0, 0x47, 0x30, 0x8F, 0xFF, 0xFD, 0x05, 0x72, 0x08, 0xFF, 0xFF, 0xE0, 0x47, 0x10, 0x8F, 0xFF,
  0xFE, 0x0E, 0x01, 0x70, 0x8F, 0xFF, 0xFF, 0x09, 0x70, 0x88, 0x0C, 0x0F, 0x02, 0x60, 0x8F, 0xD8,
  0x64, 0x22, 0x23, 0x47, 0xBF, 0xFA, 0x09, 0x60, 0x8F, 0xD0, 0x27, 0x01, 0x08, 0xFF, 0x0E, 0x60,
  0x8F, 0xD0, 0x27, 0x20, 0x4F, 0xF0, 0x35, 0x08, 0xFD, 0x02, 0x73, 0x05, 0xFE, 0x07, 0x50, 0x8F,
  0xD0, 0x27, 0x40, 0xCF, 0xD0, 0xA5, 0x08, 0xFD, 0x02, 0x74, 0x06, 0xFD, 0x0C, 0x50, 0x8F, 0xD0,
  0x27, 0x40, 0x3F, 0xD0, 0xE5, 0x08, 0xFD, 0x02, 0x74, 0x01, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27,
  0x5F, 0xE5, 0x08, 0xFD, 0x02, 0x75, 0xFD, 0x0E, 0x50, 0x8F, 0xD0, 0x27, 0x5F, 0xD0, 0xD5, 0x08,
  0xFD, 0x02, 0x74, 0x02, 0xFD, 0x0C, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0x5F, 0xD0, 0xA5, 0x08, 0xFD,
  0x02, 0x74, 0x0A, 0xFD, 0x07, 0x50, 0x8F, 0xD0, 0x27, 0x30, 0x1F, 0xE0, 0x45, 0x08, 0xFD, 0x02,
  0x73, 0x0A, 0xFD, 0x0E, 0x60, 0x8F, 0xD0, 0x27, 0x20, 0x8F, 0xE0, 0x96, 0x08, 0xFD, 0x02, 0x70,
  0x20, 0xBF, 0xF0, 0x26, 0x08, 0xFD, 0x86, 0x42, 0x22, 0x34, 0x7B, 0xFF, 0x90, 0xA7, 0x08, 0xFF,
  0xFF, 0xE0, 0xE0, 0x17, 0x08, 0xFF, 0xFF, 0xE0, 0x57, 0x10, 0x8F, 0xFF, 0xFD, 0x07, 0x72, 0x08,
  0xFF, 0xFF, 0xC0, 0x87, 0x30, 0x8F, 0xFF, 0xFB, 0x07, 0x74, 0x08, 0xFF, 0xFF, 0x90, 0xD0, 0x47,
  0x50, 0x8F, 0xFF, 0xF0, 0x87, 0x70, 0x8F, 0xFF, 0xF0, 0x57, 0x70, 0x8F, 0xFF, 0xF0, 0xD7, 0x70,
  0x8F, 0xFF, 0xF9, 0x06, 0x76, 0x08, 0xFD, 0x02, 0x40, 0xCF, 0xC0, 0xE7, 0x60, 0x8F, 0xD0, 0x24,
  0x05, 0xFD, 0x07, 0x75, 0x08, 0xFD, 0x02, 0x50, 0xDF, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0xD0, 0x25,
  0x06, 0xFD, 0x08, 0x74, 0x08, 0xFD, 0x02, 0x60, 0xDF, 0xC0, 0xE0, 0x17, 0x30, 0x8F, 0xD0, 0x26,
  0x06, 0xFD, 0x09, 0x73, 0x08, 0xFD, 0x02, 0x70, 0xEF, 0xD0, 0x27, 0x20, 0x8F, 0xD0, 0x27, 0x07,
  0xFD, 0x0A, 0x72, 0x08, 0xFD, 0x02, 0x71, 0x0E, 0xFD, 0x03, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x08,
  0xFD, 0x0B, 0x71, 0x08, 0xFD, 0x02, 0x71, 0x01, 0x0E, 0xFD, 0x03, 0x70, 0x8F, 0xD0, 0x27, 0x20,
  0x8F, 0xD0, 0xC7, 0x08, 0xFD, 0x02, 0x72, 0x01, 0xFE, 0x04, 0x60, 0x8F, 0xD0, 0x27, 0x30, 0x9F,
  0xD0, 0xC6, 0x08, 0xFD, 0x02, 0x73, 0x02, 0xFE, 0x05, 0x50, 0x8F, 0xD0, 0x27, 0x40, 0xAF, 0xD0,
  0xD5, 0x08, 0xFD, 0x02, 0x74, 0x02, 0xFE, 0x06, 0x40, 0x8F, 0xD0, 0x27, 0x50, 0xAF, 0xD0, 0xE4,
  0x08, 0xFD, 0x02, 0x75, 0x03, 0xFE, 0x07, 0x30, 0x8F, 0xD0, 0x27, 0x60, 0xBF, 0xD0, 0xE0, 0x12,
  0x08, 0xFD, 0x02, 0x76, 0x03, 0xFE, 0x08, 0x20, 0x8F, 0xD0, 0x27, 0x70, 0xBF, 0xE8, 0x11, 0x08,
  0xFD, 0x02, 0x77, 0x04, 0xFE, 0x81, 0x90, 0x8F, 0xD0, 0x27, 0x71, 0x0C, 0xFE, 0x02, 0x08, 0xFD,
  0x02, 0x77, 0x10, 0x5F, 0xE0, 0xA0,
  // "ř" (U+0159)
  0x03, 0x80, 0x37, 0x04, 0x77, 0x03, 0x80, 0x37, 0x03, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x81,
  0x70, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x3D, 0x10, 0x1E, 0xF9, 0x09, 0x71, 0x0A, 0xF9, 0x0E,
  0x02, 0x30, 0x3F, 0xA0, 0x96, 0x0B, 0xFA, 0x05, 0x50, 0x7F, 0xA0, 0xA4, 0x0B, 0xFA, 0x09, 0x70,
  0xBF, 0xA0, 0x92, 0x0A, 0xFA, 0x0C, 0x71, 0x01, 0x0E, 0xFA, 0x00, 0x8F, 0xA0, 0xE0, 0x27, 0x20,
  0x4F, 0xFE, 0x06, 0x74, 0x09, 0xFF, 0xC0, 0xA7, 0x60, 0xDF, 0xFA, 0x0D, 0x01, 0x76, 0x03, 0xFF,
  0xA0, 0x57, 0x71, 0x08, 0xFF, 0x0A, 0x77, 0x30, 0xDF, 0xD0, 0xE0, 0x17, 0x73, 0x05, 0xFD, 0x07,
  0x80, 0xAB, 0x30, 0x86, 0x6A, 0xDE, 0xED, 0xB7, 0x40, 0x5F, 0xA0, 0x27, 0x06, 0x0E, 0xF0, 0xE4,
  0x05, 0xFA, 0x05, 0x60, 0xAF, 0xA0, 0xD4, 0x05, 0xFA, 0x09, 0x50, 0xCF, 0xB0, 0xC4, 0x05, 0xFA,
  0x0C, 0x40, 0xBF, 0xC0, 0xB4, 0x05, 0xFB, 0x01, 0x20, 0x8F, 0xD0, 0xA4, 0x05, 0xFB, 0x81, 0x40,
  0x4F, 0xE0, 0x84, 0x05, 0xFB, 0x81, 0x80, 0xDF, 0xE0, 0x74, 0x05, 0xFB, 0x0C, 0x07, 0xFF, 0x06,
  0x40, 0x5F, 0xFF, 0xD0, 0x54, 0x05, 0xFF, 0xFD, 0x03, 0x40, 0x5F, 0xFF, 0xD0, 0x24, 0x05, 0xFF,
  0xB8, 0x2E, 0x94, 0x22, 0x82, 0x25, 0xC1, 0x40, 0x5F, 0xFA, 0x09, 0x01, 0x76, 0x05, 0xFF, 0x90,
  0x77, 0x71, 0x05, 0xFF, 0x08, 0x77, 0x20, 0x5F, 0xE0, 0xC7, 0x73, 0x05, 0xFE, 0x04, 0x77, 0x30,
  0x5F, 0xD0, 0xD7, 0x74, 0x05, 0xFD, 0x08, 0x77, 0x40, 0x5F, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x02,
  0x77, 0x40, 0x5F, 0xD7, 0x75, 0x05, 0xFD, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E,
  0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05,
  0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7,
  0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F,
  0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77,
  0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC,
  0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75,
  0x05, 0xFC, 0x0E, 0x77, 0x50, 0x5F, 0xC0, 0xE7, 0x75, 0x05, 0xFC, 0x0E, 0x77, 0x30,
  // "Ś" (U+015A)
  0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x77, 0x10, 0xEF, 0xE0, 0x37, 0x77, 0x08, 0xFE, 0x05, 0x77, 0x70,
  0x2F, 0xE0, 0x67, 0x77, 0x10, 0xBF, 0xD0, 0x67, 0x77, 0x10, 0x5F, 0xD0, 0x67, 0x77, 0x10, 0x10,
  0xEF, 0xC0, 0x67, 0x77, 0x20, 0xAF, 0xC0, 0x57, 0x77, 0x20, 0x6F, 0xC0, 0x57, 0x77, 0x20, 0x10,
  0xEF, 0xA0, 0xE0, 0x47, 0x77, 0x30, 0xBF, 0xA0, 0xE0, 0x37, 0x77, 0x30, 0x7F, 0xA0, 0xD0, 0x27,
  0x77, 0x30, 0x2F, 0xA0, 0xC0, 0x17, 0x77, 0x40, 0x6F, 0x90, 0xA8, 0x0A, 0xD4, 0x08, 0x42, 0x69,
  0xBD, 0xEA, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x75, 0x81, 0x28, 0xDF, 0xF9, 0x81, 0xD8, 0x37, 0x70,
  0x10, 0x9F, 0xFF, 0x81, 0xD8, 0x27, 0x30, 0x50, 0xEF, 0xFF, 0xC0, 0xA0, 0x37, 0x09, 0xFF, 0xFF,
  0x90, 0x25, 0x09, 0xFF, 0xFF, 0x90, 0xD5, 0x08, 0xFF, 0xFF, 0xA0, 0x84, 0x04, 0xFF, 0xFF, 0xB0,
  0x34, 0x0D, 0xFF, 0xFF, 0xA0, 0xD4, 0x06, 0xFF, 0xFF, 0xB0, 0x84, 0x0D, 0xFF, 0xFF, 0xB0, 0x23,
  0x03, 0xFF, 0x81, 0xD6, 0x22, 0x83, 0x12, 0x59, 0xEF, 0x0D, 0x40, 0x8F, 0xE0, 0x87, 0x30, 0x40,
  0xAD, 0x08, 0x40, 0xBF, 0xD0, 0x87, 0x60, 0x20, 0xAB, 0x02, 0x40, 0xEF, 0xC0, 0xE7, 0x72, 0x81,
  0x3C, 0xD4, 0x01, 0xFD, 0x09, 0x77, 0x40, 0x24, 0x02, 0xFD, 0x06, 0x77, 0x72, 0x03, 0xFD, 0x06,
  0x77, 0x72, 0x03, 0xFD, 0x07, 0x77, 0x72, 0x02, 0xFD, 0x0A, 0x77, 0x72, 0x01, 0xFD, 0x0E, 0x77,
  0x73, 0xFE, 0x07, 0x77, 0x72, 0x0D, 0xFE, 0x04, 0x77, 0x71, 0x0A, 0xFF, 0x05, 0x77, 0x70, 0x6F,
  0xF9, 0x09, 0x77, 0x60, 0x1F, 0xFA, 0x0D, 0x05, 0x77, 0x50, 0xAF, 0xFB, 0x0B, 0x02, 0x77, 0x30,
  0x3F, 0xFD, 0x09, 0x01, 0x77, 0x20, 0x9F, 0xFD, 0x0E, 0x06, 0x77, 0x10, 0x10, 0xDF, 0xFE, 0x0C,
  0x03, 0x77, 0x03, 0x0E, 0xFF, 0xF0, 0x77, 0x70, 0x4F, 0xFF, 0x90, 0xB0, 0x17, 0x60, 0x30, 0xEF,
  0xFF, 0x0D, 0x02, 0x76, 0x01, 0x0B, 0xFF, 0xF0, 0xE0, 0x37, 0x70, 0x7F, 0xFF, 0x0E, 0x02, 0x77,
  0x03, 0x0C, 0xFF, 0xE0, 0xE0, 0x17, 0x71, 0x06, 0x0E, 0xFF, 0xD0, 0xB7, 0x72, 0x01, 0x09, 0xFF,
  0xD0, 0x57, 0x73, 0x03, 0x0C, 0xFF, 0xB0, 0xD7, 0x75, 0x07, 0xFF, 0xB0, 0x47, 0x75, 0x02, 0x0D,
  0xFF, 0x90, 0xA7, 0x77, 0x0A, 0xFF, 0x0E, 0x77, 0x71, 0x08, 0xFF, 0x01, 0x77, 0x71, 0x0A, 0xFE,
  0x04, 0x77, 0x71, 0x01, 0xFE, 0x05, 0x77, 0x72, 0x0A, 0xFD, 0x06, 0x77, 0x72, 0x06, 0xFD, 0x07,
  0x77, 0x72, 0x04, 0xFD, 0x07, 0x77, 0x72, 0x04, 0xFD, 0x06, 0x77, 0x72, 0x06, 0xFD, 0x81, 0x47,
  0x37, 0x77, 0x0A, 0xFD, 0x83, 0x2B, 0xFB, 0x37, 0x74, 0x02, 0xFD, 0x81, 0xE0, 0xBB, 0x0B, 0x05,
  0x77, 0x20, 0xBF, 0xD8, 0x1B, 0x0B, 0xD8, 0x1E, 0x94, 0x75, 0x0A, 0xFE, 0x81, 0x60, 0xBF, 0x98,
  0x4E, 0xA7, 0x42, 0x12, 0x82, 0x14, 0x8E, 0xFF, 0x81, 0x10, 0xBF, 0xFF, 0xFD, 0x09, 0x20, 0xBF,
  0xFF, 0xFD, 0x02, 0x20, 0xBF, 0xFF, 0xFC, 0x07, 0x30, 0xBF, 0xFF, 0xFB, 0x0C, 0x40, 0xBF, 0xFF,
  0xFA, 0x0E, 0x02, 0x40, 0xBF, 0xFF, 0xF9, 0x0E, 0x03, 0x50, 0xBF, 0xFF, 0xF0, 0xD0, 0x26, 0x08,
  0xFF, 0xFE, 0x09, 0x01, 0x71, 0x81, 0x28, 0xEF, 0xFF, 0x90, 0xC0, 0x47, 0x68, 0x14, 0x9D, 0xFF,
  0xA8, 0x1E, 0xA3, 0x77, 0x48, 0x61, 0x47, 0x9B, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77,
  // "ś" (U+015B)
  0x77, 0x20, 0x6F, 0xE0, 0xB7, 0x73, 0x0E, 0xFE, 0x03, 0x77, 0x20, 0x8F, 0xE0, 0x57, 0x72, 0x02,
  0xFE, 0x06, 0x77, 0x30, 0xBF, 0xD0, 0x67, 0x73, 0x05, 0xFD, 0x06, 0x77, 0x30, 0x10, 0xEF, 0xC0,
  0x67, 0x74, 0x0A, 0xFC, 0x05, 0x77, 0x40, 0x6F, 0xC0, 0x57, 0x74, 0x01, 0x0E, 0xFA, 0x0E, 0x04,
  0x77, 0x50, 0xBF, 0xA0, 0xE0, 0x37, 0x75, 0x07, 0xFA, 0x0D, 0x02, 0x77, 0x50, 0x2F, 0xA0, 0xC0,
  0x17, 0x76, 0x06, 0xF9, 0x0A, 0x80, 0xAA, 0x40, 0x89, 0x34, 0x7A, 0xCD, 0xEF, 0xEE, 0xCA, 0x74,
  0x77, 0x20, 0x30, 0x9F, 0xF9, 0x0A, 0x04, 0x74, 0x02, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x70, 0x60,
  0xEF, 0xFF, 0x90, 0xE0, 0x75, 0x08, 0xFF, 0xFD, 0x09, 0x30, 0x6F, 0xFF, 0xE0, 0x42, 0x02, 0xFF,
  0xFE, 0x0D, 0x30, 0xAF, 0xFF, 0xE0, 0x82, 0x01, 0xFF, 0xFF, 0x02, 0x20, 0x7F, 0xFF, 0xE0, 0xC3,
  0x0A, 0xFD, 0x87, 0xD7, 0x32, 0x34, 0x6A, 0xEE, 0x07, 0x30, 0xDF, 0xC0, 0xB7, 0x20, 0x60, 0xDC,
  0x01, 0x3F, 0xD0, 0x27, 0x48, 0x25, 0xDF, 0xB4, 0xFD, 0x77, 0x07, 0x05, 0x4F, 0xD7, 0x76, 0x0E,
  0xFC, 0x04, 0x77, 0x50, 0xDF, 0xC0, 0xD0, 0x17, 0x74, 0x0A, 0xFD, 0x0D, 0x04, 0x77, 0x30, 0x6F,
  0xF0, 0xA0, 0x17, 0x71, 0x02, 0xFF, 0x90, 0xE0, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0xD0, 0x67, 0x60,
  0x3F, 0xFC, 0x0C, 0x04, 0x75, 0x09, 0xFF, 0xD0, 0xB0, 0x17, 0x40, 0xBF, 0xFD, 0x0E, 0x06, 0x74,
  0x0C, 0xFF, 0xE0, 0x97, 0x40, 0xAF, 0xFE, 0x0C, 0x01, 0x73, 0x07, 0xFF, 0xE0, 0xC0, 0x17, 0x30,
  0x20, 0xBF, 0xFD, 0x0B, 0x75, 0x04, 0x0D, 0xFF, 0xC0, 0x77, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x77,
  0x10, 0x60, 0xDF, 0xF9, 0x06, 0x77, 0x20, 0x8F, 0xF0, 0xB7, 0x73, 0x03, 0x0D, 0xFD, 0x0E, 0x77,
  0x40, 0x10, 0xDF, 0xD0, 0x27, 0x74, 0x05, 0xFD, 0x03, 0x77, 0x5F, 0xD0, 0x47, 0x75, 0x0D, 0xFC,
  0x81, 0x4A, 0x47, 0x73, 0xFD, 0x83, 0x3E, 0xFC, 0x57, 0x70, 0x5F, 0xD0, 0x10, 0xEB, 0x81, 0xE9,
  0x47, 0x30, 0x20, 0xEF, 0xC8, 0x1E, 0x0E, 0xE8, 0x90, 0xEB, 0x85, 0x32, 0x23, 0x5A, 0xFE, 0x81,
  0xB0, 0xEF, 0xFF, 0xF9, 0x81, 0x60, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0x92, 0x0E,
  0xFF, 0xFE, 0x0E, 0x01, 0x20, 0xEF, 0xFF, 0xE0, 0x43, 0x0E, 0xFF, 0xFD, 0x05, 0x40, 0xEF, 0xFF,
  0xB0, 0xD0, 0x45, 0x05, 0x0C, 0xFF, 0xF9, 0x09, 0x72, 0x81, 0x28, 0xCF, 0xFA, 0x81, 0xE8, 0x17,
  0x68, 0x61, 0x47, 0x9B, 0xDD, 0xEA, 0x84, 0xED, 0xC9, 0x62, 0x74,
  // "Ŝ" (U+015C)
  0x75, 0x01, 0x80, 0x90, 0x70, 0x27, 0x77, 0x20, 0x9F, 0xD0, 0xB7, 0x77, 0x10, 0x3F, 0xF0, 0x47,
  0x77, 0x0C, 0xFF, 0x0D, 0x77, 0x60, 0x7F, 0xFA, 0x08, 0x77, 0x40, 0x3F, 0xFC, 0x03, 0x77, 0x30,
  0xDF, 0xFC, 0x0D, 0x77, 0x20, 0x9F, 0xA0, 0x0E, 0xFA, 0x09, 0x77, 0x04, 0xFA, 0x81, 0xE3, 0x3F,
  0xB0, 0x57, 0x50, 0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x74, 0x0B, 0xFA, 0x04, 0x40,
  0x5F, 0xA0, 0xC7, 0x30, 0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x71, 0x04, 0xF9, 0x0E, 0x04, 0x71,
  0x03, 0x0E, 0xF9, 0x06, 0x60, 0x20, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x50, 0x6F,
  0x0C, 0x01, 0x75, 0x01, 0x0B, 0xF0, 0x78, 0x0A, 0xB7, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x85, 0xED,
  0xCA, 0x85, 0x17, 0x75, 0x81, 0x28, 0xDF, 0xF9, 0x81, 0xD8, 0x37, 0x70, 0x10, 0x9F, 0xFF, 0x81,
  0xD8, 0x27, 0x30, 0x50, 0xEF, 0xFF, 0xC0, 0xA0, 0x37, 0x09, 0xFF, 0xFF, 0x90, 0x25, 0x09, 0xFF,
  0xFF, 0x90, 0xD5, 0x08, 0xFF, 0xFF, 0xA0, 0x84, 0x04, 0xFF, 0xFF, 0xB0, 0x34, 0x0D, 0xFF, 0xFF,
  0xA0, 0xD4, 0x06, 0xFF, 0xFF, 0xB0, 0x84, 0x0D, 0xFF, 0xFF, 0xB0, 0x23, 0x03, 0xFF, 0x81, 0xD6,
  0x22, 0x83, 0x12, 0x59, 0xEF, 0x0D, 0x40, 0x8F, 0xE0, 0x87, 0x30, 0x40, 0xAD, 0x08, 0x40, 0xBF,
  0xD0, 0x87, 0x60, 0x20, 0xAB, 0x02, 0x40, 0xEF, 0xC0, 0xE7, 0x72, 0x81, 0x3C, 0xD4, 0x01, 0xFD,
  0x09, 0x77, 0x40, 0x24, 0x02, 0xFD, 0x06, 0x77, 0x72, 0x03, 0xFD, 0x06, 0x77, 0x72, 0x03, 0xFD,
  0x07, 0x77, 0x72, 0x02, 0xFD, 0x0A, 0x77, 0x72, 0x01, 0xFD, 0x0E, 0x77, 0x73, 0xFE, 0x07, 0x77,
  0x72, 0x0D, 0xFE, 0x04, 0x77, 0x71, 0x0A, 0xFF, 0x05, 0x77, 0x70, 0x6F, 0xF9, 0x09, 0x77, 0x60,
  0x1F, 0xFA, 0x0D, 0x05, 0x77, 0x50, 0xAF, 0xFB, 0x0B, 0x02, 0x77, 0x30, 0x3F, 0xFD, 0x09, 0x01,
  0x77, 0x20, 0x9F, 0xFD, 0x0E, 0x06, 0x77, 0x10, 0x10, 0xDF, 0xFE, 0x0C, 0x03, 0x77, 0x03, 0x0E,
  0xFF, 0xF0, 0x77, 0x70, 0x4F, 0xFF, 0x90, 0xB0, 0x17, 0x60, 0x30, 0xEF, 0xFF, 0x0D, 0x02, 0x76,
  0x01, 0x0B, 0xFF, 0xF0, 0xE0, 0x37, 0x70, 0x7F, 0xFF, 0x0E, 0x02, 0x77, 0x03, 0x0C, 0xFF, 0xE0,
  0xE0, 0x17, 0x71, 0x06, 0x0E, 0xFF, 0xD0, 0xB7, 0x72, 0x01, 0x09, 0xFF, 0xD0, 0x57, 0x73, 0x03,
  0x0C, 0xFF, 0xB0, 0xD7, 0x75, 0x07, 0xFF, 0xB0, 0x47, 0x75, 0x02, 0x0D, 0xFF, 0x90, 0xA7, 0x77,
  0x0A, 0xFF, 0x0E, 0x77, 0x71, 0x08, 0xFF, 0x01, 0x77, 0x71, 0x0A, 0xFE, 0x04, 0x77, 0x71, 0x01,
  0xFE, 0x05, 0x77, 0x72, 0x0A, 0xFD, 0x06, 0x77, 0x72, 0x06, 0xFD, 0x07, 0x77, 0x72, 0x04, 0xFD,
  0x07, 0x77, 0x72, 0x04, 0xFD, 0x06, 0x77, 0x72, 0x06, 0xFD, 0x81, 0x47, 0x37, 0x77, 0x0A, 0xFD,
  0x83, 0x2B, 0xFB, 0x37, 0x74, 0x02, 0xFD, 0x81, 0xE0, 0xBB, 0x0B, 0x05, 0x77, 0x20, 0xBF, 0xD8,
  0x1B, 0x0B, 0xD8, 0x1E, 0x94, 0x75, 0x0A, 0xFE, 0x81, 0x60, 0xBF, 0x98, 0x4E, 0xA7, 0x42, 0x12,
  0x82, 0x14, 0x8E, 0xFF, 0x81, 0x10, 0xBF, 0xFF, 0xFD, 0x09, 0x20, 0xBF, 0xFF, 0xFD, 0x02, 0x20,
  0xBF, 0xFF, 0xFC, 0x07, 0x30, 0xBF, 0xFF, 0xFB, 0x0C, 0x40, 0xBF, 0xFF, 0xFA, 0x0E, 0x02, 0x40,
  0xBF, 0xFF, 0xF9, 0x0E, 0x03, 0x50, 0xBF, 0xFF, 0xF0, 0xD0, 0x26, 0x08, 0xFF, 0xFE, 0x09, 0x01,
  0x71, 0x81, 0x28, 0xEF, 0xFF, 0x90, 0xC0, 0x47, 0x68, 0x14, 0x9D, 0xFF, 0xA8, 0x1E, 0xA3, 0x77,
  0x48, 0x61, 0x47, 0x9B, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77,
  // "ŝ" (U+015D)
  0x72, 0x01, 0x80, 0x90, 0x70, 0x27, 0x74, 0x09, 0xFD, 0x0B, 0x77, 0x30, 0x3F, 0xF0, 0x47, 0x72,
  0x0C, 0xFF, 0x0D, 0x77, 0x10, 0x7F, 0xFA, 0x08, 0x76, 0x03, 0xFF, 0xC0, 0x37, 0x50, 0xDF, 0xFC,
  0x0D, 0x74, 0x09, 0xFA, 0x00, 0xEF, 0xA0, 0x97, 0x20, 0x4F, 0xA8, 0x1E, 0x33, 0xFB, 0x05, 0x70,
  0x10, 0xEF, 0xA0, 0x42, 0x04, 0xFA, 0x0E, 0x02, 0x60, 0xBF, 0xA0, 0x44, 0x05, 0xFA, 0x0C, 0x50,
  0x8F, 0xA0, 0x46, 0x04, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0xE0, 0x47, 0x10, 0x30, 0xEF, 0x98, 0x26,
  0x02, 0xEF, 0x0E, 0x03, 0x73, 0x02, 0x0D, 0xF9, 0x03, 0x06, 0xF0, 0xC0, 0x17, 0x50, 0x10, 0xBF,
  0x07, 0x80, 0xA8, 0x60, 0x89, 0x34, 0x7A, 0xCD, 0xEF, 0xEE, 0xCA, 0x74, 0x77, 0x20, 0x30, 0x9F,
  0xF9, 0x0A, 0x04, 0x74, 0x02, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x70, 0x60, 0xEF, 0xFF, 0x90, 0xE0,
  0x75, 0x08, 0xFF, 0xFD, 0x09, 0x30, 0x6F, 0xFF, 0xE0, 0x42, 0x02, 0xFF, 0xFE, 0x0D, 0x30, 0xAF,
  0xFF, 0xE0, 0x82, 0x01, 0xFF, 0xFF, 0x02, 0x20, 0x7F, 0xFF, 0xE0, 0xC3, 0x0A, 0xFD, 0x87, 0xD7,
  0x32, 0x34, 0x6A, 0xEE, 0x07, 0x30, 0xDF, 0xC0, 0xB7, 0x20, 0x60, 0xDC, 0x01, 0x3F, 0xD0, 0x27,
  0x48, 0x25, 0xDF, 0xB4, 0xFD, 0x77, 0x07, 0x05, 0x4F, 0xD7, 0x76, 0x0E, 0xFC, 0x04, 0x77, 0x50,
  0xDF, 0xC0, 0xD0, 0x17, 0x74, 0x0A, 0xFD, 0x0D, 0x04, 0x77, 0x30, 0x6F, 0xF0, 0xA0, 0x17, 0x71,
  0x02, 0xFF, 0x90, 0xE0, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0xD0, 0x67, 0x60, 0x3F, 0xFC, 0x0C, 0x04,
  0x75, 0x09, 0xFF, 0xD0, 0xB0, 0x17, 0x40, 0xBF, 0xFD, 0x0E, 0x06, 0x74, 0x0C, 0xFF, 0xE0, 0x97,
  0x40, 0xAF, 0xFE, 0x0C, 0x01, 0x73, 0x07, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0x20, 0xBF, 0xFD, 0x0B,
  0x75, 0x04, 0x0D, 0xFF, 0xC0, 0x77, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x77, 0x10, 0x60, 0xDF, 0xF9,
  0x06, 0x77, 0x20, 0x8F, 0xF0, 0xB7, 0x73, 0x03, 0x0D, 0xFD, 0x0E, 0x77, 0x40, 0x10, 0xDF, 0xD0,
  0x27, 0x74, 0x05, 0xFD, 0x03, 0x77, 0x5F, 0xD0, 0x47, 0x75, 0x0D, 0xFC, 0x81, 0x4A, 0x47, 0x73,
  0xFD, 0x83, 0x3E, 0xFC, 0x57, 0x70, 0x5F, 0xD0, 0x10, 0xEB, 0x81, 0xE9, 0x47, 0x30, 0x20, 0xEF,
  0xC8, 0x1E, 0x0E, 0xE8, 0x90, 0xEB, 0x85, 0x32, 0x23, 0x5A, 0xFE, 0x81, 0xB0, 0xEF, 0xFF, 0xF9,
  0x81, 0x60, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0x92, 0x0E, 0xFF, 0xFE, 0x0E, 0x01,
  0x20, 0xEF, 0xFF, 0xE0, 0x43, 0x0E, 0xFF, 0xFD, 0x05, 0x40, 0xEF, 0xFF, 0xB0, 0xD0, 0x45, 0x05,
  0x0C, 0xFF, 0xF9, 0x09, 0x72, 0x81, 0x28, 0xCF, 0xFA, 0x81, 0xE8, 0x17, 0x68, 0x61, 0x47, 0x9B,
  0xDD, 0xEA, 0x84, 0xED, 0xC9, 0x62, 0x74,
  // "Ş" (U+015E)
  0x76, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x58, 0x12, 0x8D, 0xFF, 0x98,
  0x1D, 0x83, 0x77, 0x01, 0x09, 0xFF, 0xF8, 0x1D, 0x82, 0x73, 0x05, 0x0E, 0xFF, 0xFC, 0x0A, 0x03,
  0x70, 0x9F, 0xFF, 0xF9, 0x02, 0x50, 0x9F, 0xFF, 0xF9, 0x0D, 0x50, 0x8F, 0xFF, 0xFA, 0x08, 0x40,
  0x4F, 0xFF, 0xFB, 0x03, 0x40, 0xDF, 0xFF, 0xFA, 0x0D, 0x40, 0x6F, 0xFF, 0xFB, 0x08, 0x40, 0xDF,
  0xFF, 0xFB, 0x02, 0x30, 0x3F, 0xF8, 0x1D, 0x62, 0x28, 0x31, 0x25, 0x9E, 0xF0, 0xD4, 0x08, 0xFE,
  0x08, 0x73, 0x04, 0x0A, 0xD0, 0x84, 0x0B, 0xFD, 0x08, 0x76, 0x02, 0x0A, 0xB0, 0x24, 0x0E, 0xFC,
  0x0E, 0x77, 0x28, 0x13, 0xCD, 0x40, 0x1F, 0xD0, 0x97, 0x74, 0x02, 0x40, 0x2F, 0xD0, 0x67, 0x77,
  0x20, 0x3F, 0xD0, 0x67, 0x77, 0x20, 0x3F, 0xD0, 0x77, 0x77, 0x20, 0x2F, 0xD0, 0xA7, 0x77, 0x20,
  0x1F, 0xD0, 0xE7, 0x77, 0x3F, 0xE0, 0x77, 0x77, 0x20, 0xDF, 0xE0, 0x47, 0x77, 0x10, 0xAF, 0xF0,
  0x57, 0x77, 0x06, 0xFF, 0x90, 0x97, 0x76, 0x01, 0xFF, 0xA0, 0xD0, 0x57, 0x75, 0x0A, 0xFF, 0xB0,
  0xB0, 0x27, 0x73, 0x03, 0xFF, 0xD0, 0x90, 0x17, 0x72, 0x09, 0xFF, 0xD0, 0xE0, 0x67, 0x71, 0x01,
  0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x70, 0x30, 0xEF, 0xFF, 0x07, 0x77, 0x04, 0xFF, 0xF9, 0x0B, 0x01,
  0x76, 0x03, 0x0E, 0xFF, 0xF0, 0xD0, 0x27, 0x60, 0x10, 0xBF, 0xFF, 0x0E, 0x03, 0x77, 0x07, 0xFF,
  0xF0, 0xE0, 0x27, 0x70, 0x30, 0xCF, 0xFE, 0x0E, 0x01, 0x77, 0x10, 0x60, 0xEF, 0xFD, 0x0B, 0x77,
  0x20, 0x10, 0x9F, 0xFD, 0x05, 0x77, 0x30, 0x30, 0xCF, 0xFB, 0x0D, 0x77, 0x50, 0x7F, 0xFB, 0x04,
  0x77, 0x50, 0x20, 0xDF, 0xF9, 0x0A, 0x77, 0x70, 0xAF, 0xF0, 0xE7, 0x77, 0x10, 0x8F, 0xF0, 0x17,
  0x77, 0x10, 0xAF, 0xE0, 0x47, 0x77, 0x10, 0x1F, 0xE0, 0x57, 0x77, 0x20, 0xAF, 0xD0, 0x67, 0x77,
  0x20, 0x6F, 0xD0, 0x77, 0x77, 0x20, 0x4F, 0xD0, 0x77, 0x77, 0x20, 0x4F, 0xD0, 0x67, 0x77, 0x20,
  0x6F, 0xD8, 0x14, 0x73, 0x77, 0x70, 0xAF, 0xD8, 0x32, 0xBF, 0xB3, 0x77, 0x40, 0x2F, 0xD8, 0x1E,
  0x0B, 0xB0, 0xB0, 0x57, 0x72, 0x0B, 0xFD, 0x81, 0xB0, 0xBD, 0x81, 0xE9, 0x47, 0x50, 0xAF, 0xE8,
  0x16, 0x0B, 0xF9, 0x84, 0xEA, 0x74, 0x21, 0x28, 0x21, 0x48, 0xEF, 0xF8, 0x11, 0x0B, 0xFF, 0xFF,
  0xD0, 0x92, 0x0B, 0xFF, 0xFF, 0xD0, 0x22, 0x0B, 0xFF, 0xFF, 0xC0, 0x73, 0x0B, 0xFF, 0xFF, 0xB0,
  0xC4, 0x0B, 0xFF, 0xFF, 0xA0, 0xE0, 0x24, 0x0B, 0xFF, 0xFF, 0x90, 0xE0, 0x35, 0x0B, 0xFF, 0xFF,
  0x0D, 0x02, 0x60, 0x8F, 0xFF, 0xE0, 0x90, 0x17, 0x18, 0x12, 0x8E, 0xFF, 0xF9, 0x0C, 0x04, 0x76,
  0x81, 0x49, 0xDF, 0xFA, 0x81, 0xEA, 0x37, 0x74, 0x84, 0x14, 0x79, 0xBC, 0xF8, 0x1D, 0x73, 0x77,
  0x76, 0x08, 0xE0, 0x37, 0x77, 0x71, 0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x06, 0xE0, 0x57, 0x77, 0x71,
  0x0D, 0xE8, 0x1E, 0xA4, 0x77, 0x75, 0x04, 0xFB, 0x0C, 0x03, 0x77, 0x73, 0x0B, 0xFD, 0x06, 0x77,
  0x71, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x73, 0x81, 0x38, 0xEF, 0xA0, 0xE7, 0x77, 0x50, 0x10, 0xCF,
  0xA0, 0x67, 0x77, 0x50, 0x1F, 0xA0, 0xA7, 0x77, 0x60, 0xBF, 0x90, 0xC7, 0x77, 0x60, 0xCF, 0x90,
  0xC7, 0x77, 0x50, 0x2F, 0xA0, 0xA7, 0x74, 0x87, 0x67, 0x42, 0x10, 0x15, 0xDF, 0xA0, 0x87, 0x74,
  0x09, 0xFF, 0xB0, 0x47, 0x74, 0x09, 0xFF, 0xA0, 0xD7, 0x75, 0x09, 0xFF, 0xA0, 0x67, 0x75, 0x09,
  0xFF, 0x90, 0x97, 0x76, 0x09, 0xFF, 0x09, 0x77, 0x70, 0x9F, 0xD0, 0xC0, 0x57, 0x77, 0x18, 0x42,
  0x7A, 0xCE, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x72,
  // "ş" (U+015F)
  0x73, 0x89, 0x34, 0x7A, 0xCD, 0xEF, 0xEE, 0xCA, 0x74, 0x77, 0x20, 0x30, 0x9F, 0xF9, 0x0A, 0x04,
  0x74, 0x02, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x70, 0x60, 0xEF, 0xFF, 0x90, 0xE0, 0x75, 0x08, 0xFF,
  0xFD, 0x09, 0x30, 0x6F, 0xFF, 0xE0, 0x42, 0x02, 0xFF, 0xFE, 0x0D, 0x30, 0xAF, 0xFF, 0xE0, 0x82,
  0x01, 0xFF, 0xFF, 0x02, 0x20, 0x7F, 0xFF, 0xE0, 0xC3, 0x0A, 0xFD, 0x87, 0xD7, 0x32, 0x34, 0x6A,
  0xEE, 0x07, 0x30, 0xDF, 0xC0, 0xB7, 0x20, 0x60, 0xDC, 0x01, 0x3F, 0xD0, 0x27, 0x48, 0x25, 0xDF,
  0xB4, 0xFD, 0x77, 0x07, 0x05, 0x4F, 0xD7, 0x76, 0x0E, 0xFC, 0x04, 0x77, 0x50, 0xDF, 0xC0, 0xD0,
  0x17, 0x74, 0x0A, 0xFD, 0x0D, 0x04, 0x77, 0x30, 0x6F, 0xF0, 0xA0, 0x17, 0x71, 0x02, 0xFF, 0x90,
  0xE0, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0xD0, 0x67, 0x60, 0x3F, 0xFC, 0x0C, 0x04, 0x75, 0x09, 0xFF,
  0xD0, 0xB0, 0x17, 0x40, 0xBF, 0xFD, 0x0E, 0x06, 0x74, 0x0C, 0xFF, 0xE0, 0x97, 0x40, 0xAF, 0xFE,
  0x0C, 0x01, 0x73, 0x07, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0x20, 0xBF, 0xFD, 0x0B, 0x75, 0x04, 0x0D,
  0xFF, 0xC0, 0x77, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x77, 0x10, 0x60, 0xDF, 0xF9, 0x06, 0x77, 0x20,
  0x8F, 0xF0, 0xB7, 0x73, 0x03, 0x0D, 0xFD, 0x0E, 0x77, 0x40, 0x10, 0xDF, 0xD0, 0x27, 0x74, 0x05,
  0xFD, 0x03, 0x77, 0x5F, 0xD0, 0x47, 0x75, 0x0D, 0xFC, 0x81, 0x4A, 0x47, 0x73, 0xFD, 0x83, 0x3E,
  0xFC, 0x57, 0x70, 0x5F, 0xD0, 0x10, 0xEB, 0x81, 0xE9, 0x47, 0x30, 0x20, 0xEF, 0xC8, 0x1E, 0x0E,
  0xE8, 0x90, 0xEB, 0x85, 0x32, 0x23, 0x5A, 0xFE, 0x81, 0xB0, 0xEF, 0xFF, 0xF9, 0x81, 0x60, 0xEF,
  0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0x92, 0x0E, 0xFF, 0xFE, 0x0E, 0x01, 0x20, 0xEF, 0xFF,
  0xE0, 0x43, 0x0E, 0xFF, 0xFD, 0x05, 0x40, 0xEF, 0xFF, 0xB0, 0xD0, 0x45, 0x05, 0x0C, 0xFF, 0xF9,
  0x09, 0x72, 0x81, 0x28, 0xCF, 0xFA, 0x81, 0xE8, 0x17, 0x68, 0x31, 0x47, 0x9B, 0xF9, 0x81, 0x96,
  0x27, 0x77, 0x08, 0xE0, 0x37, 0x77, 0x30, 0xED, 0x0C, 0x77, 0x73, 0x06, 0xE0, 0x57, 0x77, 0x30,
  0xDE, 0x81, 0xEA, 0x47, 0x77, 0x04, 0xFB, 0x0C, 0x03, 0x77, 0x50, 0xBF, 0xD0, 0x67, 0x73, 0x01,
  0x0D, 0xFE, 0x05, 0x77, 0x58, 0x13, 0x8E, 0xFA, 0x0E, 0x77, 0x70, 0x10, 0xCF, 0xA0, 0x67, 0x77,
  0x01, 0xFA, 0x0A, 0x77, 0x71, 0x0B, 0xF9, 0x0C, 0x77, 0x71, 0x0C, 0xF9, 0x0C, 0x77, 0x70, 0x2F,
  0xA0, 0xA7, 0x68, 0x76, 0x74, 0x21, 0x01, 0x5D, 0xFA, 0x08, 0x76, 0x09, 0xFF, 0xB0, 0x47, 0x60,
  0x9F, 0xFA, 0x0D, 0x77, 0x09, 0xFF, 0xA0, 0x67, 0x70, 0x9F, 0xF9, 0x09, 0x77, 0x10, 0x9F, 0xF0,
  0x97, 0x72, 0x09, 0xFD, 0x0C, 0x05, 0x77, 0x38, 0x42, 0x7A, 0xCE, 0xEA, 0x83, 0xED, 0xA7, 0x37,
  0x70,
  // "Š" (U+0160)
  0x30, 0x38, 0x03, 0x70, 0x47, 0x70, 0x38, 0x03, 0x70, 0x35, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x07, 0x60, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x90, 0xD0, 0x16, 0x01, 0x0E, 0xF9, 0x09, 0x71, 0x0A,
  0xF9, 0x0E, 0x02, 0x71, 0x03, 0xFA, 0x09, 0x60, 0xBF, 0xA0, 0x57, 0x30, 0x7F, 0xA0, 0xA4, 0x0B,
  0xFA, 0x09, 0x75, 0x0B, 0xFA, 0x09, 0x20, 0xAF, 0xA0, 0xC7, 0x60, 0x10, 0xEF, 0xA0, 0x08, 0xFA,
  0x0E, 0x02, 0x77, 0x04, 0xFF, 0xE0, 0x67, 0x72, 0x09, 0xFF, 0xC0, 0xA7, 0x74, 0x0D, 0xFF, 0xA0,
  0xD0, 0x17, 0x74, 0x03, 0xFF, 0xA0, 0x57, 0x76, 0x08, 0xFF, 0x0A, 0x77, 0x71, 0x0D, 0xFD, 0x0E,
  0x01, 0x77, 0x71, 0x05, 0xFD, 0x07, 0x80, 0xAD, 0x00, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC,
  0xA8, 0x51, 0x77, 0x58, 0x12, 0x8D, 0xFF, 0x98, 0x1D, 0x83, 0x77, 0x01, 0x09, 0xFF, 0xF8, 0x1D,
  0x82, 0x73, 0x05, 0x0E, 0xFF, 0xFC, 0x0A, 0x03, 0x70, 0x9F, 0xFF, 0xF9, 0x02, 0x50, 0x9F, 0xFF,
  0xF9, 0x0D, 0x50, 0x8F, 0xFF, 0xFA, 0x08, 0x40, 0x4F, 0xFF, 0xFB, 0x03, 0x40, 0xDF, 0xFF, 0xFA,
  0x0D, 0x40, 0x6F, 0xFF, 0xFB, 0x08, 0x40, 0xDF, 0xFF, 0xFB, 0x02, 0x30, 0x3F, 0xF8, 0x1D, 0x62,
  0x28, 0x31, 0x25, 0x9E, 0xF0, 0xD4, 0x08, 0xFE, 0x08, 0x73, 0x04, 0x0A, 0xD0, 0x84, 0x0B, 0xFD,
  0x08, 0x76, 0x02, 0x0A, 0xB0, 0x24, 0x0E, 0xFC, 0x0E, 0x77, 0x28, 0x13, 0xCD, 0x40, 0x1F, 0xD0,
  0x97, 0x74, 0x02, 0x40, 0x2F, 0xD0, 0x67, 0x77, 0x20, 0x3F, 0xD0, 0x67, 0x77, 0x20, 0x3F, 0xD0,
  0x77, 0x77, 0x20, 0x2F, 0xD0, 0xA7, 0x77, 0x20, 0x1F, 0xD0, 0xE7, 0x77, 0x3F, 0xE0, 0x77, 0x77,
  0x20, 0xDF, 0xE0, 0x47, 0x77, 0x10, 0xAF, 0xF0, 0x57, 0x77, 0x06, 0xFF, 0x90, 0x97, 0x76, 0x01,
  0xFF, 0xA0, 0xD0, 0x57, 0x75, 0x0A, 0xFF, 0xB0, 0xB0, 0x27, 0x73, 0x03, 0xFF, 0xD0, 0x90, 0x17,
  0x72, 0x09, 0xFF, 0xD0, 0xE0, 0x67, 0x71, 0x01, 0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x70, 0x30, 0xEF,
  0xFF, 0x07, 0x77, 0x04, 0xFF, 0xF9, 0x0B, 0x01, 0x76, 0x03, 0x0E, 0xFF, 0xF0, 0xD0, 0x27, 0x60,
  0x10, 0xBF, 0xFF, 0x0E, 0x03, 0x77, 0x07, 0xFF, 0xF0, 0xE0, 0x27, 0x70, 0x30, 0xCF, 0xFE, 0x0E,
  0x01, 0x77, 0x10, 0x60, 0xEF, 0xFD, 0x0B, 0x77, 0x20, 0x10, 0x9F, 0xFD, 0x05, 0x77, 0x30, 0x30,
  0xCF, 0xFB, 0x0D, 0x77, 0x50, 0x7F, 0xFB, 0x04, 0x77, 0x50, 0x20, 0xDF, 0xF9, 0x0A, 0x77, 0x70,
  0xAF, 0xF0, 0xE7, 0x77, 0x10, 0x8F, 0xF0, 0x17, 0x77, 0x10, 0xAF, 0xE0, 0x47, 0x77, 0x10, 0x1F,
  0xE0, 0x57, 0x77, 0x20, 0xAF, 0xD0, 0x67, 0x77, 0x20, 0x6F, 0xD0, 0x77, 0x77, 0x20, 0x4F, 0xD0,
  0x77, 0x77, 0x20, 0x4F, 0xD0, 0x67, 0x77, 0x20, 0x6F, 0xD8, 0x14, 0x73, 0x77, 0x70, 0xAF, 0xD8,
  0x32, 0xBF, 0xB3, 0x77, 0x40, 0x2F, 0xD8, 0x1E, 0x0B, 0xB0, 0xB0, 0x57, 0x72, 0x0B, 0xFD, 0x81,
  0xB0, 0xBD, 0x81, 0xE9, 0x47, 0x50, 0xAF, 0xE8, 0x16, 0x0B, 0xF9, 0x84, 0xEA, 0x74, 0x21, 0x28,
  0x21, 0x48, 0xEF, 0xF8, 0x11, 0x0B, 0xFF, 0xFF, 0xD0, 0x92, 0x0B, 0xFF, 0xFF, 0xD0, 0x22, 0x0B,
  0xFF, 0xFF, 0xC0, 0x73, 0x0B, 0xFF, 0xFF, 0xB0, 0xC4, 0x0B, 0xFF, 0xFF, 0xA0, 0xE0, 0x24, 0x0B,
  0xFF, 0xFF, 0x90, 0xE0, 0x35, 0x0B, 0xFF, 0xFF, 0x0D, 0x02, 0x60, 0x8F, 0xFF, 0xE0, 0x90, 0x17,
  0x18, 0x12, 0x8E, 0xFF, 0xF9, 0x0C, 0x04, 0x76, 0x81, 0x49, 0xDF, 0xFA, 0x81, 0xEA, 0x37, 0x74,
  0x86, 0x14, 0x79, 0xBC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x37, 0x70,
  // "š" (U+0161)
  0x03, 0x80, 0x37, 0x04, 0x77, 0x03, 0x80, 0x37, 0x03, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x81,
  0x70, 0xCF, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x3D, 0x10, 0x1E, 0xF9, 0x09, 0x71, 0x0A, 0xF9, 0x0E,
  0x02, 0x30, 0x3F, 0xA0, 0x96, 0x0B, 0xFA, 0x05, 0x50, 0x7F, 0xA0, 0xA4, 0x0B, 0xFA, 0x09, 0x70,
  0xBF, 0xA0, 0x92, 0x0A, 0xFA, 0x0C, 0x71, 0x01, 0x0E, 0xFA, 0x00, 0x8F, 0xA0, 0xE0, 0x27, 0x20,
  0x4F, 0xFE, 0x06, 0x74, 0x09, 0xFF, 0xC0, 0xA7, 0x60, 0xDF, 0xFA, 0x0D, 0x01, 0x76, 0x03, 0xFF,
  0xA0, 0x57, 0x71, 0x08, 0xFF, 0x0A, 0x77, 0x30, 0xDF, 0xD0, 0xE0, 0x17, 0x73, 0x05, 0xFD, 0x07,
  0x80, 0xA9, 0x70, 0x89, 0x34, 0x7A, 0xCD, 0xEF, 0xEE, 0xCA, 0x74, 0x77, 0x20, 0x30, 0x9F, 0xF9,
  0x0A, 0x04, 0x74, 0x02, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x70, 0x60, 0xEF, 0xFF, 0x90, 0xE0, 0x75,
  0x08, 0xFF, 0xFD, 0x09, 0x30, 0x6F, 0xFF, 0xE0, 0x42, 0x02, 0xFF, 0xFE, 0x0D, 0x30, 0xAF, 0xFF,
  0xE0, 0x82, 0x01, 0xFF, 0xFF, 0x02, 0x20, 0x7F, 0xFF, 0xE0, 0xC3, 0x0A, 0xFD, 0x87, 0xD7, 0x32,
  0x34, 0x6A, 0xEE, 0x07, 0x30, 0xDF, 0xC0, 0xB7, 0x20, 0x60, 0xDC, 0x01, 0x3F, 0xD0, 0x27, 0x48,
  0x25, 0xDF, 0xB4, 0xFD, 0x77, 0x07, 0x05, 0x4F, 0xD7, 0x76, 0x0E, 0xFC, 0x04, 0x77, 0x50, 0xDF,
  0xC0, 0xD0, 0x17, 0x74, 0x0A, 0xFD, 0x0D, 0x04, 0x77, 0x30, 0x6F, 0xF0, 0xA0, 0x17, 0x71, 0x02,
  0xFF, 0x90, 0xE0, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0xD0, 0x67, 0x60, 0x3F, 0xFC, 0x0C, 0x04, 0x75,
  0x09, 0xFF, 0xD0, 0xB0, 0x17, 0x40, 0xBF, 0xFD, 0x0E, 0x06, 0x74, 0x0C, 0xFF, 0xE0, 0x97, 0x40,
  0xAF, 0xFE, 0x0C, 0x01, 0x73, 0x07, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0x20, 0xBF, 0xFD, 0x0B, 0x75,
  0x04, 0x0D, 0xFF, 0xC0, 0x77, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x77, 0x10, 0x60, 0xDF, 0xF9, 0x06,
  0x77, 0x20, 0x8F, 0xF0, 0xB7, 0x73, 0x03, 0x0D, 0xFD, 0x0E, 0x77, 0x40, 0x10, 0xDF, 0xD0, 0x27,
  0x74, 0x05, 0xFD, 0x03, 0x77, 0x5F, 0xD0, 0x47, 0x75, 0x0D, 0xFC, 0x81, 0x4A, 0x47, 0x73, 0xFD,
  0x83, 0x3E, 0xFC, 0x57, 0x70, 0x5F, 0xD0, 0x10, 0xEB, 0x81, 0xE9, 0x47, 0x30, 0x20, 0xEF, 0xC8,
  0x1E, 0x0E, 0xE8, 0x90, 0xEB, 0x85, 0x32, 0x23, 0x5A, 0xFE, 0x81, 0xB0, 0xEF, 0xFF, 0xF9, 0x81,
  0x60, 0xEF, 0xFF, 0xF9, 0x81, 0x10, 0xEF, 0xFF, 0xF0, 0x92, 0x0E, 0xFF, 0xFE, 0x0E, 0x01, 0x20,
  0xEF, 0xFF, 0xE0, 0x43, 0x0E, 0xFF, 0xFD, 0x05, 0x40, 0xEF, 0xFF, 0xB0, 0xD0, 0x45, 0x05, 0x0C,
  0xFF, 0xF9, 0x09, 0x72, 0x81, 0x28, 0xCF, 0xFA, 0x81, 0xE8, 0x17, 0x68, 0x61, 0x47, 0x9B, 0xDD,
  0xEA, 0x84, 0xED, 0xC9, 0x62, 0x74,
  // "Ţ" (U+0162)
  0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C,
  0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30,
  0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3, 0xF0, 0x30, 0x88, 0x0C, 0x3F, 0x03, 0x08, 0x80, 0xC3,
  0xF0, 0x37, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x7F, 0xD0,
  0x97, 0x77, 0x7F, 0xD0, 0x97, 0x77, 0x72, 0x01, 0x80, 0x27, 0x04, 0x77, 0x77, 0x50, 0x8E, 0x03,
  0x77, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x77, 0x50, 0x6E, 0x05, 0x77, 0x77, 0x50, 0xDE, 0x81, 0xEA,
  0x47, 0x77, 0x72, 0x04, 0xFB, 0x0C, 0x03, 0x77, 0x77, 0x0B, 0xFD, 0x06, 0x77, 0x75, 0x01, 0x0D,
  0xFE, 0x05, 0x77, 0x77, 0x81, 0x38, 0xEF, 0xA0, 0xE7, 0x77, 0x72, 0x01, 0x0C, 0xFA, 0x06, 0x77,
  0x77, 0x20, 0x1F, 0xA0, 0xA7, 0x77, 0x73, 0x0B, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xC7,
  0x77, 0x72, 0x02, 0xFA, 0x0A, 0x77, 0x71, 0x87, 0x67, 0x42, 0x10, 0x15, 0xDF, 0xA0, 0x87, 0x77,
  0x10, 0x9F, 0xFB, 0x04, 0x77, 0x71, 0x09, 0xFF, 0xA0, 0xD7, 0x77, 0x20, 0x9F, 0xFA, 0x06, 0x77,
  0x72, 0x09, 0xFF, 0x90, 0x97, 0x77, 0x30, 0x9F, 0xF0, 0x97, 0x77, 0x40, 0x9F, 0xD0, 0xC0, 0x57,
  0x77, 0x58, 0x42, 0x7A, 0xCE, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x73,
  // "ţ" (U+0163)
  0x72, 0x02, 0x80, 0x37, 0x06, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x60, 0xDF, 0x0C, 0x77, 0x50, 0x2F,
  0x90, 0xC7, 0x75, 0x07, 0xF9, 0x0C, 0x77, 0x50, 0xBF, 0x90, 0xC7, 0x75, 0xFA, 0x0C, 0x77, 0x40,
  0x5F, 0xA0, 0xC7, 0x74, 0x09, 0xFA, 0x0C, 0x77, 0x40, 0xDF, 0xA0, 0xC7, 0x73, 0x03, 0xFB, 0x0C,
  0x77, 0x20, 0x10, 0xAF, 0xFF, 0x02, 0x40, 0x60, 0xEF, 0xFF, 0x90, 0x22, 0x04, 0x0D, 0xFF, 0xFB,
  0x81, 0x22, 0xBF, 0xFF, 0xD0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF,
  0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE0, 0x20, 0xAF, 0xFF, 0xE8, 0x52, 0x12, 0x22,
  0x26, 0xFC, 0x0D, 0x80, 0x62, 0x60, 0x5F, 0xC0, 0xC7, 0x72, 0x05, 0