#include "27.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:06 CET 2022
static const uint8_t font_NotoSansMono_Bold_27_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFA, 0xFB, 0x2A, 0x1B, 0x15, 0xFA, 0x06, 0x00, 0x31, 0x08, 0x10, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x05, 0x01, 0x0A, 0x13, 0x10, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x03, 0x0D, 0x0C, 0x13, 0x10, 0x00, 0x30, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x00, 0x54, // "#" (U+0023)
  0x00, 0x24, 0x02, 0x00, 0x0D, 0x15, 0x10, 0x00, 0xB9, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x10, 0x13, 0x10, 0x01, 0x15, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x01, 0x9F, // "&" (U+0026)
  0x00, 0x27, 0x06, 0x0D, 0x09, 0x13, 0x10, 0x02, 0x0A, // "'" (U+0027)
  0x00, 0x28, 0x05, 0xFC, 0x0B, 0x13, 0x10, 0x02, 0x1C, // "(" (U+0028)
  0x00, 0x29, 0x04, 0xFD, 0x0A, 0x14, 0x10, 0x02, 0x64, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x0A, 0x0D, 0x15, 0x10, 0x02, 0xAC, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x0E, 0x10, 0x10, 0x02, 0xE8, // "+" (U+002B)
  0x00, 0x2C, 0x05, 0xFD, 0x0A, 0x04, 0x10, 0x03, 0x18, // "," (U+002C)
  0x00, 0x2D, 0x04, 0x07, 0x0C, 0x0A, 0x10, 0x03, 0x2F, // "-" (U+002D)
  0x00, 0x2E, 0x05, 0x01, 0x0A, 0x05, 0x10, 0x03, 0x39, // "." (U+002E)
  0x00, 0x2F, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x03, 0x47, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x03, 0x84, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x03, 0xF4, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x04, 0x3C, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x04, 0x87, // "3" (U+0033)
  0x00, 0x34, 0x01, 0x01, 0x0F, 0x13, 0x10, 0x04, 0xDF, // "4" (U+0034)
  0x00, 0x35, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x05, 0x34, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x05, 0x82, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x05, 0xE8, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x06, 0x2D, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x06, 0x91, // "9" (U+0039)
  0x00, 0x3A, 0x05, 0x01, 0x0A, 0x0F, 0x10, 0x06, 0xF4, // ":" (U+003A)
  0x00, 0x3B, 0x05, 0xFC, 0x0B, 0x0F, 0x10, 0x07, 0x12, // ";" (U+003B)
  0x00, 0x3C, 0x02, 0x04, 0x0D, 0x11, 0x10, 0x07, 0x3C, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x06, 0x0E, 0x0E, 0x10, 0x07, 0x76, // "=" (U+003D)
  0x00, 0x3E, 0x02, 0x04, 0x0D, 0x11, 0x10, 0x07, 0x90, // ">" (U+003E)
  0x00, 0x3F, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x07, 0xC9, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFE, 0x10, 0x13, 0x10, 0x08, 0x0D, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x08, 0xAF, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x0F, 0x13, 0x10, 0x09, 0x0E, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x09, 0x6F, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x0F, 0x13, 0x10, 0x09, 0xC2, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x0A, 0x2A, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x0A, 0x6E, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x0E, 0x13, 0x10, 0x0A, 0xB2, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x0B, 0x0B, // "H" (U+0048)
  0x00, 0x49, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x0B, 0x5B, // "I" (U+0049)
  0x00, 0x4A, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x0B, 0x9F, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x0B, 0xE0, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x0C, 0x3F, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0F, 0x13, 0x10, 0x0C, 0x82, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x0D, 0x05, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x0D, 0x76, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x0F, 0x13, 0x10, 0x0D, 0xDA, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFC, 0x0F, 0x13, 0x10, 0x0E, 0x31, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x0F, 0x13, 0x10, 0x0E, 0xA7, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x0F, 0x10, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x0F, 0x6B, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x0F, 0xA1, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x0F, 0xFA, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x10, 0x60, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x10, 0xE9, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x11, 0x51, // "Y" (U+0059)
  0x00, 0x5A, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x11, 0xA8, // "Z" (U+005A)
  0x00, 0x5B, 0x06, 0xFB, 0x0C, 0x13, 0x10, 0x11, 0xEB, // "[" (U+005B)
  0x00, 0x5C, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x12, 0x35, // "\" (U+005C)
  0x00, 0x5D, 0x03, 0xFD, 0x09, 0x15, 0x10, 0x12, 0x78, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x08, 0x0E, 0x13, 0x10, 0x12, 0xC2, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFC, 0x10, 0xFF, 0x10, 0x12, 0xFE, // "_" (U+005F)
  0x00, 0x60, 0x03, 0x11, 0x0A, 0x15, 0x10, 0x13, 0x09, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x13, 0x18, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x13, 0x68, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0D, 0x0F, 0x10, 0x13, 0xD4, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x14, 0x13, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x14, 0x78, // "e" (U+0065)
  0x00, 0x66, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x14, 0xBF, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x15, 0x13, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x15, 0x81, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x15, 0xEA, // "i" (U+0069)
  0x00, 0x6A, 0x01, 0xFB, 0x0B, 0x15, 0x10, 0x16, 0x36, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x16, 0x8D, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x16, 0xF9, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x17, 0x47, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x17, 0xB6, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0F, 0x0F, 0x10, 0x18, 0x09, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFB, 0x0F, 0x0F, 0x10, 0x18, 0x59, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x18, 0xC2, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x0F, 0x0F, 0x10, 0x19, 0x27, // "r" (U+0072)
  0x00, 0x73, 0x02, 0x01, 0x0D, 0x0F, 0x10, 0x19, 0x65, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x19, 0xA7, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x19, 0xF2, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x1A, 0x45, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x10, 0x0F, 0x10, 0x1A, 0x95, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x1B, 0x06, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFB, 0x0F, 0x0F, 0x10, 0x1B, 0x56, // "y" (U+0079)
  0x00, 0x7A, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x1B, 0xBD, // "z" (U+007A)
  0x00, 0x7B, 0x03, 0xFB, 0x0C, 0x13, 0x10, 0x1B, 0xF8, // "{" (U+007B)
  0x00, 0x7C, 0x06, 0xFB, 0x09, 0x15, 0x10, 0x1C, 0x4C, // "|" (U+007C)
  0x00, 0x7D, 0x03, 0xFD, 0x0C, 0x15, 0x10, 0x1C, 0x90, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x08, 0x0E, 0x0C, 0x10, 0x1C, 0xE3, // "~" (U+007E)
  0x00, 0xA1, 0x05, 0xFC, 0x0A, 0x0E, 0x10, 0x1D, 0x04, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x1D, 0x34, // "¢" (U+00A2)
  0x00, 0xA3, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x1D, 0x84, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x05, 0x0E, 0x11, 0x10, 0x1D, 0xCB, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x1E, 0x1C, // "¥" (U+00A5)
  0x00, 0xA6, 0x06, 0xFB, 0x09, 0x15, 0x10, 0x1E, 0x79, // "¦" (U+00A6)
  0x00, 0xA7, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x1E, 0xB2, // "§" (U+00A7)
  0x00, 0xA8, 0x03, 0x11, 0x0D, 0x14, 0x10, 0x1F, 0x18, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x03, 0x0F, 0x11, 0x10, 0x1F, 0x30, // "©" (U+00A9)
  0x00, 0xAA, 0x03, 0x0B, 0x0C, 0x14, 0x10, 0x1F, 0x9E, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x0E, 0x0E, 0x10, 0x1F, 0xCF, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x04, 0x0D, 0x0C, 0x10, 0x20, 0x20, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x03, 0x0F, 0x11, 0x10, 0x20, 0x36, // "®" (U+00AE)
  0x00, 0xAF, 0x04, 0x12, 0x0C, 0x15, 0x10, 0x20, 0xA7, // "¯" (U+00AF)
  0x00, 0xB0, 0x03, 0x0C, 0x0C, 0x14, 0x10, 0x20, 0xB0, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0E, 0x11, 0x10, 0x20, 0xD8, // "±" (U+00B1)
  0x00, 0xB2, 0x04, 0x0C, 0x0C, 0x17, 0x10, 0x21, 0x14, // "²" (U+00B2)
  0x00, 0xB3, 0x04, 0x0C, 0x0C, 0x17, 0x10, 0x21, 0x3F, // "³" (U+00B3)
  0x00, 0xB4, 0x06, 0x11, 0x0C, 0x15, 0x10, 0x21, 0x6D, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x21, 0x7E, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFE, 0x0E, 0x15, 0x10, 0x21, 0xE5, // "¶" (U+00B6)
  0x00, 0xB7, 0x05, 0x08, 0x0A, 0x0C, 0x10, 0x22, 0x5F, // "·" (U+00B7)
  0x00, 0xB8, 0x05, 0xFB, 0x0A, 0x01, 0x10, 0x22, 0x6D, // "¸" (U+00B8)
  0x00, 0xB9, 0x04, 0x0C, 0x0C, 0x17, 0x10, 0x22, 0x82, // "¹" (U+00B9)
  0x00, 0xBA, 0x03, 0x0B, 0x0C, 0x14, 0x10, 0x22, 0xAC, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x0E, 0x0E, 0x10, 0x22, 0xE0, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0F, 0x14, 0x10, 0x23, 0x31, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x23, 0xA9, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x0F, 0x14, 0x10, 0x24, 0x19, // "¾" (U+00BE)
  0x00, 0xBF, 0x02, 0xFC, 0x0D, 0x0E, 0x10, 0x24, 0x91, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x24, 0xD6, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x25, 0x49, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x25, 0xBD, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x26, 0x39, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x26, 0xB1, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0F, 0x1B, 0x10, 0x27, 0x2C, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x27, 0xAC, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x28, 0x11, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x28, 0x7C, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x28, 0xD4, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x29, 0x2C, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x0E, 0x19, 0x10, 0x29, 0x8B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x29, 0xEB, // "Ì" (U+00CC)
  0x00, 0xCD, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x2A, 0x43, // "Í" (U+00CD)
  0x00, 0xCE, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x2A, 0x99, // "Î" (U+00CE)
  0x00, 0xCF, 0x02, 0x01, 0x0D, 0x19, 0x10, 0x2A, 0xF8, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x2B, 0x58, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x2B, 0xC1, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x2C, 0x4B, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x2C, 0xC2, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x2D, 0x3A, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x2D, 0xBA, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x2E, 0x37, // "Ö" (U+00D6)
  0x00, 0xD7, 0x02, 0x04, 0x0D, 0x10, 0x10, 0x2E, 0xB7, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0F, 0x14, 0x10, 0x2F, 0x02, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x2F, 0x81, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x2F, 0xEE, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x30, 0x5C, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x30, 0xD1, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x31, 0x47, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x0F, 0x13, 0x10, 0x31, 0xB3, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x32, 0x09, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x32, 0x84, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x32, 0xE6, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x33, 0x49, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x33, 0xB3, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x34, 0x1B, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x0E, 0x16, 0x10, 0x34, 0x86, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x34, 0xF4, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFB, 0x0D, 0x0F, 0x10, 0x35, 0x50, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x35, 0xA7, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x36, 0x00, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x36, 0x5A, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x36, 0xBB, // "ë" (U+00EB)
  0x00, 0xEC, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x37, 0x1D, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x37, 0x67, // "í" (U+00ED)
  0x00, 0xEE, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x37, 0xB2, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x38, 0x04, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x38, 0x57, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x38, 0xC3, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x39, 0x2F, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x39, 0x92, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x39, 0xF5, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0F, 0x14, 0x10, 0x3A, 0x60, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0F, 0x14, 0x10, 0x3A, 0xC8, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x04, 0x0E, 0x11, 0x10, 0x3B, 0x33, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x0F, 0x10, 0x10, 0x3B, 0x5F, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x3B, 0xC0, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x3C, 0x26, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x3C, 0x8C, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x3C, 0xFA, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFB, 0x0F, 0x15, 0x10, 0x3D, 0x68, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFB, 0x0F, 0x15, 0x10, 0x3D, 0xE3, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFB, 0x0F, 0x14, 0x10, 0x3E, 0x60, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x3E, 0xE2, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x3F, 0x4E, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x3F, 0xAA, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x40, 0x23, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFB, 0x10, 0x13, 0x10, 0x40, 0x8B, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x41, 0x02, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x41, 0x6A, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0D, 0x15, 0x10, 0x41, 0xD1, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x42, 0x23, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0D, 0x15, 0x10, 0x42, 0x91, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x42, 0xEA, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0D, 0x15, 0x10, 0x43, 0x51, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x43, 0xA2, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x0D, 0x15, 0x10, 0x44, 0x0F, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x0F, 0x1A, 0x10, 0x44, 0x68, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x12, 0x15, 0x10, 0x44, 0xEC, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x45, 0x60, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x10, 0x15, 0x10, 0x45, 0xC9, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x46, 0x38, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x46, 0x89, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x46, 0xDC, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x47, 0x3A, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x47, 0x99, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x47, 0xF1, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xFB, 0x0E, 0x13, 0x10, 0x48, 0x4B, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x48, 0xA7, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x49, 0x01, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x49, 0x60, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x0E, 0x1A, 0x10, 0x49, 0xC0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x4A, 0x35, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x0E, 0x1A, 0x10, 0x4A, 0xBD, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x4B, 0x30, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x0E, 0x1A, 0x10, 0x4B, 0xB6, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x4C, 0x23, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFB, 0x0E, 0x13, 0x10, 0x4C, 0xA4, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x4D, 0x0D, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x4D, 0x8A, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFE, 0x01, 0x0E, 0x1B, 0x10, 0x4D, 0xF6, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x10, 0x13, 0x10, 0x4E, 0x81, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0E, 0x15, 0x10, 0x4E, 0xE6, // "ħ" (U+0127)
  0x01, 0x28, 0x02, 0x01, 0x0D, 0x19, 0x10, 0x4F, 0x56, // "Ĩ" (U+0128)
  0x01, 0x29, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x4F, 0xB3, // "ĩ" (U+0129)
  0x01, 0x2A, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x50, 0x03, // "Ī" (U+012A)
  0x01, 0x2B, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x50, 0x54, // "ī" (U+012B)
  0x01, 0x2C, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x50, 0x98, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x50, 0xF5, // "ĭ" (U+012D)
  0x01, 0x2E, 0x02, 0xFB, 0x0D, 0x13, 0x10, 0x51, 0x45, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x51, 0xA0, // "į" (U+012F)
  0x01, 0x30, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x52, 0x04, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x0E, 0x0F, 0x10, 0x52, 0x5A, // "ı" (U+0131)
  0x01, 0x32, 0x02, 0x01, 0x0D, 0x13, 0x10, 0x52, 0x92, // "Ĳ" (U+0132)
  0x01, 0x33, 0x02, 0xFB, 0x0E, 0x15, 0x10, 0x52, 0xE6, // "ĳ" (U+0133)
  0x01, 0x34, 0x02, 0x01, 0x0F, 0x1A, 0x10, 0x53, 0x7B, // "Ĵ" (U+0134)
  0x01, 0x35, 0x01, 0xFB, 0x0D, 0x15, 0x10, 0x53, 0xDF, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x54, 0x48, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFB, 0x0F, 0x15, 0x10, 0x54, 0xB7, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x0F, 0x0F, 0x10, 0x55, 0x33, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x55, 0x8A, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x0E, 0x1B, 0x10, 0x55, 0xE0, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFB, 0x0E, 0x13, 0x10, 0x56, 0x41, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFB, 0x0E, 0x15, 0x10, 0x56, 0x94, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x56, 0xF2, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x57, 0x3F, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x0E, 0x13, 0x10, 0x57, 0x97, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x12, 0x15, 0x10, 0x57, 0xE5, // "ŀ" (U+0140)
  0x01, 0x41, 0x01, 0x01, 0x0F, 0x13, 0x10, 0x58, 0x43, // "Ł" (U+0141)
  0x01, 0x42, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x58, 0x8D, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x58, 0xE0, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x59, 0x65, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x59, 0xCC, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x5A, 0x4D, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x5A, 0xB0, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x5B, 0x3C, // "ň" (U+0148)
  0x01, 0x49, 0xFD, 0x01, 0x0E, 0x13, 0x10, 0x5B, 0xA9, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x5C, 0x17, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x5C, 0x9F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x5D, 0x09, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x5D, 0x79, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x5D, 0xD5, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x5E, 0x52, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x5E, 0xBB, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0F, 0x14, 0x10, 0x5F, 0x39, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x5F, 0xA2, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x60, 0x00, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x0F, 0x1A, 0x10, 0x60, 0x68, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x60, 0xE5, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xFB, 0x0F, 0x13, 0x10, 0x61, 0x37, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFB, 0x0F, 0x0F, 0x10, 0x61, 0xB0, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x0F, 0x1A, 0x10, 0x61, 0xFE, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x62, 0x82, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x62, 0xDB, // "Ś" (U+015A)
  0x01, 0x5B, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x63, 0x4A, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x63, 0x9D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x64, 0x14, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x64, 0x70, // "Ş" (U+015E)
  0x01, 0x5F, 0x02, 0xFB, 0x0D, 0x0F, 0x10, 0x64, 0xE4, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x65, 0x3C, // "Š" (U+0160)
  0x01, 0x61, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x65, 0xB2, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFB, 0x0F, 0x13, 0x10, 0x66, 0x0D, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x66, 0x5B, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x66, 0xBF, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x67, 0x11, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x67, 0x6A, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x67, 0xA7, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x67, 0xF5, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x68, 0x68, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x68, 0xD3, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x69, 0x39, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x69, 0x98, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x6A, 0x0B, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0E, 0x1B, 0x10, 0x6A, 0x76, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0E, 0x16, 0x10, 0x6A, 0xEF, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x6B, 0x61, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x6B, 0xD5, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFB, 0x0E, 0x13, 0x10, 0x6C, 0x41, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x6C, 0xB3, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x6D, 0x1E, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x10, 0x15, 0x10, 0x6D, 0xC4, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0F, 0x1A, 0x10, 0x6E, 0x51, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFB, 0x0F, 0x15, 0x10, 0x6E, 0xC5, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0F, 0x19, 0x10, 0x6F, 0x48, // "Ÿ" (U+0178)
  0x01, 0x79, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x6F, 0xBB, // "Ź" (U+0179)
  0x01, 0x7A, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x70, 0x12, // "ź" (U+017A)
  0x01, 0x7B, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x70, 0x60, // "Ż" (U+017B)
  0x01, 0x7C, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x70, 0xB7, // "ż" (U+017C)
  0x01, 0x7D, 0x02, 0x01, 0x0E, 0x1A, 0x10, 0x71, 0x05, // "Ž" (U+017D)
  0x01, 0x7E, 0x01, 0x01, 0x0E, 0x15, 0x10, 0x71, 0x63, // "ž" (U+017E)
  0x01, 0x7F, 0x05, 0x01, 0x0D, 0x15, 0x10, 0x71, 0xB8, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x71, 0xFA, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFB, 0x0E, 0x0F, 0x10, 0x72, 0x63, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x72, 0xCA, // "π" (U+03C0)
  0x20, 0x13, 0x02, 0x07, 0x0D, 0x0A, 0x10, 0x73, 0x1B, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x07, 0x10, 0x0A, 0x10, 0x73, 0x28, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x01, 0x0F, 0x13, 0x10, 0x73, 0x33, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFE, 0x0F, 0x16, 0x10, 0x73, 0x89, // "₿" (U+20BF)
  0x20, 0x18, 0x05, 0x0D, 0x0A, 0x13, 0x10, 0x74, 0x07, // "‘" (U+2018)
  0x20, 0x19, 0x05, 0x0D, 0x0A, 0x13, 0x10, 0x74, 0x1D, // "’" (U+2019)
  0x20, 0x1A, 0x05, 0xFD, 0x0A, 0x04, 0x10, 0x74, 0x32, // "‚" (U+201A)
  0x20, 0x1B, 0x05, 0x0D, 0x0A, 0x13, 0x10, 0x74, 0x49, // "‛" (U+201B)
  0x20, 0x1C, 0x02, 0x0D, 0x0D, 0x13, 0x10, 0x74, 0x5E, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x0E, 0x0D, 0x14, 0x10, 0x74, 0x89, // "”" (U+201D)
  0x20, 0x1E, 0x03, 0xFD, 0x0E, 0x04, 0x10, 0x74, 0xB4, // "„" (U+201E)
  0x20, 0x1F, 0x02, 0x0E, 0x0D, 0x14, 0x10, 0x74, 0xE1, // "‟" (U+201F)
  0x20, 0x20, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x75, 0x0B, // "†" (U+2020)
  0x20, 0x21, 0x02, 0x01, 0x0D, 0x15, 0x10, 0x75, 0x5B, // "‡" (U+2021)
  0x20, 0x22, 0x04, 0x07, 0x0B, 0x0E, 0x10, 0x75, 0xB5, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x0F, 0x05, 0x10, 0x75, 0xCE, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x75, 0xF0, // "‰" (U+2030)
  0x20, 0x39, 0x04, 0x02, 0x0B, 0x0E, 0x10, 0x76, 0x6E, // "‹" (U+2039)
  0x20, 0x3A, 0x04, 0x02, 0x0B, 0x0E, 0x10, 0x76, 0x9A, // "›" (U+203A)
  0x20, 0x44, 0xFA, 0x01, 0x05, 0x13, 0x00, 0x76, 0xC6, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x0A, 0x10, 0x13, 0x10, 0x77, 0x07, // "™" (U+2122)
  0x21, 0x52, 0x07, 0x01, 0x2A, 0x13, 0x31, 0x77, 0x65, // "⅒" (U+2152)
  0x22, 0x02, 0x01, 0x01, 0x0E, 0x14, 0x10, 0x78, 0x3F, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x0F, 0x13, 0x10, 0x78, 0xA5, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x10, 0x17, 0x10, 0x79, 0x04, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x06, 0x0F, 0x0E, 0x10, 0x79, 0x68, // "∞" (U+221E)
  0x22, 0x48, 0x01, 0x05, 0x0E, 0x0F, 0x10, 0x79, 0xAE, // "≈" (U+2248)
  0x22, 0x60, 0x01, 0x02, 0x0E, 0x12, 0x10, 0x79, 0xE3, // "≠" (U+2260)
  0x22, 0x64, 0x01, 0x01, 0x0E, 0x12, 0x10, 0x7A, 0x1C, // "≤" (U+2264)
  0x22, 0x65, 0x01, 0x01, 0x0E, 0x12, 0x10, 0x7A, 0x6B, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x02, 0xC0, 0x50, 0x1C, 0x05, 0x01, 0xC0, 0x41, 0xC0, 0x31, 0xC8, 0x13, 0x0E, 0xB8, 0x12, 0x0D,
  0xB8, 0x11, 0x0D, 0xB8, 0x11, 0x0C, 0xB2, 0x0B, 0xB2, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xD2, 0x09,
  0xA0, 0xD7, 0x18, 0x47, 0xEE, 0x90, 0x2C, 0x00, 0x5C, 0x07, 0x02, 0xC8, 0x44, 0x06, 0xEE, 0x81,
  // """ (U+0022)
  0x07, 0xB0, 0x31, 0xB0, 0xA0, 0x5B, 0x81, 0x20, 0xEA, 0x08, 0x04, 0xB8, 0x11, 0x0D, 0xA0, 0x70,
  0x3B, 0x20, 0xCA, 0x06, 0x02, 0xA0, 0xE2, 0x0B, 0xA0, 0x50, 0x1A, 0x0D, 0x20, 0xAA, 0x04, 0x1A,
  0x0C, 0x20, 0x9A, 0x03,
  // "#" (U+0023)
  0x50, 0x4A, 0x81, 0x60, 0x4A, 0x06, 0x70, 0x7A, 0x81, 0x30, 0x6A, 0x04, 0x70, 0xAA, 0x20, 0x9A,
  0x01, 0x78, 0x1D, 0xFD, 0x28, 0x1C, 0xFD, 0x40, 0x10, 0xF2, 0xA8, 0x91, 0xB2, 0x2E, 0xFC, 0x22,
  0x10, 0xCF, 0xE8, 0x1C, 0x0C, 0xFE, 0x81, 0xC0, 0xCF, 0xE0, 0xC4, 0x09, 0xA8, 0x11, 0x08, 0xA0,
  0x27, 0x81, 0xCF, 0xE2, 0x81, 0xBF, 0xE4, 0x01, 0x0F, 0x2A, 0x89, 0x1C, 0x22, 0xEF, 0xC2, 0x22,
  0x09, 0xFF, 0x10, 0x9F, 0xF1, 0x09, 0xFF, 0x40, 0x8A, 0x81, 0x10, 0x8A, 0x02, 0x78, 0x1B, 0xFE,
  0x20, 0xBA, 0x71, 0x81, 0xEF, 0xC2, 0x81, 0xEF, 0xC7, 0x01, 0xA8, 0x19, 0x01, 0xA0, 0xA7, 0x03,
  0xA8, 0x17, 0x04, 0xA0, 0x75,
  // "$" (U+0024)
  0x50, 0xA9, 0x73, 0x81, 0xBF, 0x16, 0x81, 0x2A, 0xEB, 0x81, 0xEB, 0x62, 0x06, 0xFA, 0x0A, 0x03,
  0xFB, 0x05, 0x09, 0xB8, 0x75, 0xBF, 0x35, 0x9D, 0x0C, 0xA8, 0x1A, 0x0A, 0x95, 0x0B, 0xA8, 0x1B,
  0x0A, 0x95, 0x08, 0xB0, 0xA0, 0xC9, 0x50, 0x10, 0xED, 0x04, 0x50, 0x30, 0xDD, 0x0C, 0x04, 0x50,
  0x70, 0xED, 0x09, 0x60, 0xCD, 0x06, 0x58, 0x2A, 0xF5, 0xEA, 0x0D, 0x58, 0x2A, 0xF0, 0x6B, 0x04,
  0x48, 0x2A, 0xF0, 0x6B, 0x87, 0xCD, 0x83, 0x1A, 0xF5, 0xEA, 0x00, 0xCF, 0xB0, 0x50, 0xCF, 0xA8,
  0x39, 0x02, 0x8D, 0xD0, 0xC0, 0x56, 0x82, 0x1B, 0xF1, 0x72, 0x0A, 0x95,
  // "%" (U+0025)
  0x18, 0x44, 0xCF, 0xEA, 0x24, 0x0C, 0xA0, 0x12, 0x04, 0xD0, 0xE0, 0x12, 0x05, 0xA0, 0x83, 0x83,
  0xBF, 0xE4, 0x7A, 0x07, 0x28, 0x2C, 0xFE, 0x13, 0x81, 0xEF, 0xA2, 0xA8, 0x1A, 0x05, 0xA0, 0x84,
  0xA0, 0xA2, 0x86, 0xEF, 0xA0, 0xDF, 0xE1, 0x48, 0x3C, 0xFE, 0x14, 0xA0, 0x80, 0x6A, 0x07, 0x50,
  0x6E, 0x82, 0x2D, 0xFE, 0x70, 0x70, 0xEA, 0x81, 0xD4, 0x6A, 0x07, 0x72, 0x02, 0x01, 0x28, 0x1E,
  0xFE, 0x76, 0x07, 0xA0, 0x67, 0x58, 0x90, 0x1E, 0xFD, 0x18, 0xDF, 0xC5, 0x70, 0x8A, 0x06, 0x0A,
  0xD0, 0x65, 0x83, 0x1E, 0xFD, 0x3A, 0x83, 0xA3, 0xDF, 0xD5, 0x08, 0xA0, 0x50, 0x6A, 0x81, 0x30,
  0x8A, 0x01, 0x30, 0x1A, 0x81, 0xC0, 0x7A, 0x81, 0x20, 0x7A, 0x02, 0x30, 0x9A, 0x81, 0x50, 0x6A,
  0x81, 0x30, 0x8A, 0x01, 0x20, 0x2A, 0x0C, 0x20, 0x3A, 0x83, 0x93, 0xDF, 0xD3, 0x09, 0xA0, 0x43,
  0x0A, 0xD0, 0x62, 0x02, 0xA0, 0xC5, 0x83, 0x8E, 0xFD, 0x52,
  // "&" (U+0026)
  0x48, 0x47, 0xDF, 0xEB, 0x47, 0x20, 0xBE, 0x05, 0x70, 0x4F, 0x0D, 0x70, 0x8A, 0x81, 0xE4, 0x6B,
  0x02, 0x60, 0x9A, 0x09, 0x20, 0xEA, 0x02, 0x60, 0x8A, 0x81, 0xB0, 0x2A, 0x0E, 0x70, 0x4B, 0x04,
  0x0D, 0xA0, 0x77, 0x10, 0xCD, 0x0B, 0x72, 0x04, 0xC0, 0xC0, 0x17, 0x10, 0x10, 0xCC, 0x07, 0x20,
  0x8A, 0x0E, 0x30, 0xCE, 0x81, 0x40, 0xCA, 0x0B, 0x20, 0x7B, 0x07, 0x0D, 0xA0, 0xE0, 0x4B, 0x06,
  0x20, 0xEA, 0x82, 0x90, 0x2E, 0xE8, 0x11, 0x01, 0xB0, 0x42, 0x05, 0xD0, 0xA2, 0x02, 0xB0, 0x63,
  0x09, 0xC0, 0x23, 0xB8, 0x3E, 0x53, 0x6D, 0xC0, 0x43, 0x0A, 0xFC, 0x0E, 0x01, 0x20, 0x10, 0xDF,
  0x0C, 0xB0, 0xB3, 0x89, 0x01, 0x8D, 0xEE, 0xC8, 0x20, 0xCB, 0x06,
  // "'" (U+0027)
  0x0B, 0xA0, 0xE0, 0xAA, 0x0D, 0x09, 0xA0, 0xC0, 0x8A, 0x0B, 0x07, 0xA0, 0x90, 0x6A, 0x08, 0x04,
  0xA0, 0x70,
  // "(" (U+0028)
  0x30, 0x5A, 0x0D, 0x20, 0x10, 0xEA, 0x04, 0x20, 0x9A, 0x0A, 0x20, 0x1B, 0x04, 0x20, 0x7A, 0x0D,
  0x30, 0xDA, 0x07, 0x20, 0x1B, 0x03, 0x20, 0x5B, 0x30, 0x9A, 0x0C, 0x30, 0xAA, 0x0B, 0x30, 0xBA,
  0x09, 0x30, 0xCA, 0x08, 0x30, 0xDA, 0x08, 0x30, 0xCA, 0x09, 0x30, 0xAA, 0x0A, 0x30, 0x9A, 0x0C,
  0x30, 0x6B, 0x30, 0x2B, 0x04, 0x30, 0xEA, 0x08, 0x30, 0x8A, 0x0D, 0x30, 0x1B, 0x04, 0x30, 0xAA,
  0x0B, 0x30, 0x10, 0xEA, 0x04, 0x30, 0x6A, 0x0C,
  // ")" (U+0029)
  0x0C, 0xA0, 0x53, 0x04, 0xA0, 0xE0, 0x13, 0x0B, 0xA0, 0xA3, 0x04, 0xB0, 0x13, 0x0D, 0xA0, 0x73,
  0x08, 0xA0, 0xD3, 0x04, 0xB0, 0x23, 0xB0, 0x53, 0x0C, 0xA0, 0x93, 0x0B, 0xA0, 0xA3, 0x09, 0xA0,
  0xB3, 0x08, 0xA0, 0xD3, 0x08, 0xA0, 0xC3, 0x09, 0xA0, 0xB3, 0x0B, 0xA0, 0xA3, 0x0C, 0xA0, 0x83,
  0xB0, 0x52, 0x03, 0xB0, 0x12, 0x07, 0xA0, 0xD3, 0x0D, 0xA0, 0x72, 0x04, 0xB0, 0x12, 0x0A, 0xA0,
  0x92, 0x04, 0xA0, 0xE0, 0x12, 0x0D, 0xA0, 0x53,
  // "*" (U+002A)
  0x40, 0x6A, 0x09, 0x71, 0x05, 0xA0, 0x87, 0x10, 0x4A, 0x07, 0x48, 0x34, 0x72, 0x02, 0xA8, 0x46,
  0x02, 0x66, 0x9A, 0x0E, 0x0B, 0xA0, 0xB0, 0xDA, 0x00, 0xCF, 0xC8, 0x23, 0x57, 0x9C, 0x82, 0xA8,
  0x64, 0x30, 0x8C, 0x0B, 0x50, 0x4A, 0x0B, 0x08, 0xA0, 0x73, 0x01, 0x0E, 0xA8, 0x13, 0x1E, 0xA0,
  0x42, 0x82, 0x2B, 0xFA, 0x28, 0x27, 0xFD, 0x44, 0x05, 0x02, 0x30, 0x73,
  // "+" (U+002B)
  0x50, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A,
  0x09, 0x50, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xD8, 0x54, 0x02, 0x22, 0x26, 0xA0, 0x98,
  0x00, 0x26, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x50,
  // "," (U+002C)
  0x10, 0x5B, 0x81, 0x70, 0x8B, 0x81, 0x40, 0xBB, 0x20, 0xDA, 0x0A, 0x2B, 0x81, 0x60, 0x3B, 0x81,
  0x10, 0x6A, 0x0A, 0x20, 0xAA, 0x04, 0x20,
  // "-" (U+002D)
  0x80, 0x42, 0x10, 0xEF, 0x02, 0x0E, 0xF0, 0x20, 0xEF, 0x02,
  // "." (U+002E)
  0x18, 0x47, 0xEE, 0x90, 0x2C, 0x00, 0x5C, 0x07, 0x02, 0xC8, 0x44, 0x06, 0xEE, 0x81,
  // "/" (U+002F)
  0x70, 0x1B, 0x04, 0x70, 0x7A, 0x0D, 0x71, 0x0D, 0xA0, 0x87, 0x03, 0xB0, 0x27, 0x09, 0xA0, 0xB7,
  0x10, 0xEA, 0x05, 0x70, 0x6A, 0x0E, 0x71, 0x0C, 0xA0, 0x97, 0x03, 0xB0, 0x37, 0x09, 0xA0, 0xC7,
  0x10, 0xEA, 0x06, 0x70, 0x5A, 0x0E, 0x71, 0x0B, 0xA0, 0x97, 0x02, 0xB0, 0x37, 0x08, 0xA0, 0xD7,
  0x10, 0xEA, 0x07, 0x70, 0x5B, 0x01, 0x70, 0xBA, 0x0A, 0x70, 0x1B, 0x04, 0x70,
  // "0" (U+0030)
  0x38, 0x61, 0x8C, 0xEE, 0xD8, 0x25, 0x04, 0x0E, 0xE0, 0xE0, 0x53, 0x01, 0x0E, 0xFA, 0x03, 0x20,
  0x9B, 0x82, 0xB3, 0x3B, 0xB0, 0xB2, 0x0E, 0xA0, 0xD3, 0x06, 0xC0, 0x10, 0x4B, 0x08, 0x20, 0x10,
  0xEC, 0x00, 0x6B, 0x05, 0x20, 0xAD, 0x09, 0x08, 0xB8, 0x13, 0x04, 0xA0, 0xEB, 0x0B, 0x09, 0xB8,
  0x12, 0x0D, 0xA0, 0x4B, 0x0C, 0x0A, 0xB0, 0x20, 0x9A, 0x09, 0x1B, 0x0C, 0x09, 0xB0, 0x6A, 0x0D,
  0x2B, 0x0C, 0x08, 0xB0, 0xEA, 0x81, 0x40, 0x1B, 0x0B, 0x06, 0xD0, 0x92, 0x03, 0xB0, 0x90, 0x3C,
  0x0E, 0x01, 0x20, 0x6B, 0x81, 0x60, 0xEB, 0x05, 0x30, 0xBB, 0x81, 0x20, 0x8B, 0x82, 0xB4, 0x39,
  0xB0, 0xB2, 0x01, 0x0E, 0xFA, 0x03, 0x30, 0x30, 0xEF, 0x06, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x33,
  // "1" (U+0031)
  0x40, 0x70, 0xEA, 0x0A, 0x60, 0x60, 0xDC, 0x0A, 0x40, 0x50, 0xDE, 0x0A, 0x40, 0xDF, 0x0A, 0x40,
  0x4B, 0x09, 0xB0, 0xA5, 0x82, 0xB9, 0x12, 0xB0, 0xA7, 0x10, 0x3B, 0x0A, 0x71, 0x03, 0xB0, 0xA7,
  0x10, 0x3B, 0x0A, 0x71, 0x03, 0xB0, 0xA7, 0x10, 0x3B, 0x0A, 0x71, 0x03, 0xB0, 0xA7, 0x10, 0x3B,
  0x0A, 0x71, 0x03, 0xB0, 0xA7, 0x10, 0x3B, 0x0A, 0x71, 0x03, 0xB0, 0xA5, 0x81, 0xAD, 0xEE, 0x83,
  0xDC, 0x30, 0xEF, 0xB8, 0x14, 0x0E, 0xFB, 0x04,
  // "2" (U+0032)
  0x38, 0x65, 0xAD, 0xEF, 0xDA, 0x44, 0x03, 0x0C, 0xF9, 0x0A, 0x20, 0x3F, 0xC0, 0x92, 0x0A, 0xA8,
  0x3D, 0x63, 0x3A, 0xC0, 0x22, 0x0C, 0x08, 0x50, 0xDB, 0x05, 0x72, 0x0A, 0xB0, 0x67, 0x20, 0xBB,
  0x04, 0x71, 0x02, 0xB0, 0xE7, 0x20, 0xBB, 0x08, 0x71, 0x09, 0xB0, 0xD7, 0x10, 0x9B, 0x0E, 0x02,
  0x70, 0x9B, 0x0E, 0x02, 0x70, 0x9B, 0x0D, 0x02, 0x70, 0x9B, 0x0C, 0x01, 0x70, 0x9B, 0x0B, 0x71,
  0x09, 0xB0, 0xC8, 0x04, 0x20, 0x6F, 0xE0, 0x7F, 0xE0, 0x7F, 0xE0,
  // "3" (U+0033)
  0x28, 0x71, 0x6A, 0xDE, 0xFD, 0xA4, 0x40, 0x8F, 0xA0, 0xA3, 0x09, 0xFB, 0x07, 0x38, 0x5D, 0xD8,
  0x42, 0x39, 0xB0, 0xC3, 0x01, 0x60, 0xEA, 0x0C, 0x73, 0xB0, 0x97, 0x81, 0x14, 0xCA, 0x0E, 0x01,
  0x40, 0x4E, 0x0C, 0x02, 0x50, 0x4D, 0x0B, 0x03, 0x60, 0x4F, 0x0C, 0x01, 0x58, 0x32, 0x23, 0x6C,
  0xB0, 0xC7, 0x30, 0xDB, 0x03, 0x72, 0x09, 0xB0, 0x67, 0x20, 0xAB, 0x81, 0x50, 0x36, 0x01, 0x0E,
  0xB8, 0x90, 0x31, 0xFD, 0x84, 0x33, 0x5D, 0xB8, 0x1D, 0x01, 0xFC, 0x81, 0x50, 0x1F, 0xA0, 0xE0,
  0x63, 0x89, 0x02, 0x6A, 0xCE, 0xFE, 0xB7, 0x13,
  // "4" (U+0034)
  0x70, 0x5B, 0x09, 0x72, 0x01, 0x0E, 0xB0, 0x97, 0x20, 0x9C, 0x09, 0x71, 0x04, 0xD0, 0x97, 0x18,
  0x2D, 0xFE, 0xEA, 0x09, 0x70, 0x9A, 0x06, 0xB0, 0x96, 0x03, 0xA0, 0xC1, 0xB0, 0x96, 0x0D, 0xA0,
  0x41, 0xB0, 0x95, 0x08, 0xA8, 0x1A, 0x01, 0xB0, 0x94, 0x03, 0xA8, 0x2E, 0x10, 0x1B, 0x09, 0x40,
  0xCA, 0x07, 0x20, 0x1B, 0x09, 0x30, 0x7A, 0x83, 0xE2, 0x22, 0x3B, 0x83, 0xA2, 0x20, 0xEF, 0xE0,
  0x10, 0xEF, 0xE0, 0x10, 0xEF, 0xE0, 0x17, 0x01, 0xB0, 0x97, 0x30, 0x1B, 0x09, 0x73, 0x01, 0xB0,
  0x97, 0x30, 0x1B, 0x09, 0x30,
  // "5" (U+0035)
  0x10, 0xEF, 0xA0, 0x12, 0xFB, 0x81, 0x10, 0x1F, 0xB8, 0x11, 0x02, 0xB0, 0xA8, 0x02, 0x22, 0x03,
  0xB0, 0x87, 0x10, 0x4B, 0x07, 0x71, 0x06, 0xB8, 0x26, 0x23, 0x15, 0x07, 0xF0, 0xD0, 0x63, 0x08,
  0xFA, 0x0A, 0x20, 0x6B, 0x0E, 0xE0, 0x62, 0x02, 0x04, 0x30, 0x40, 0xDB, 0x0C, 0x71, 0x04, 0xC7,
  0x2C, 0x02, 0x71, 0xC1, 0x01, 0x60, 0x4B, 0x89, 0x0E, 0x0E, 0xB7, 0x42, 0x37, 0xEB, 0x81, 0x70,
  0xEF, 0xA0, 0xC2, 0x0E, 0xF9, 0x0B, 0x01, 0x28, 0x73, 0x8C, 0xDF, 0xED, 0x94, 0x40,
  // "6" (U+0036)
  0x58, 0x62, 0x7B, 0xDE, 0xFE, 0x44, 0x01, 0x0A, 0xF0, 0x53, 0x01, 0x0D, 0xF9, 0x05, 0x30, 0xCB,
  0x85, 0xE8, 0x42, 0x34, 0x22, 0x05, 0xB0, 0xB0, 0x17, 0x10, 0xCA, 0x0E, 0x01, 0x71, 0x01, 0xB8,
  0x69, 0x19, 0xDF, 0xDA, 0x22, 0x04, 0xB0, 0x70, 0xDD, 0x82, 0xE3, 0x06, 0xB0, 0xEF, 0x81, 0xD0,
  0x7C, 0x82, 0xD5, 0x37, 0xC0, 0x40, 0x7C, 0x02, 0x30, 0x9B, 0x08, 0x06, 0xB0, 0xA4, 0x05, 0xB0,
  0xA0, 0x5B, 0x08, 0x40, 0x4B, 0x0A, 0x02, 0xB0, 0xA4, 0x05, 0xB8, 0x19, 0x0D, 0xA0, 0xE0, 0x13,
  0x0A, 0xB8, 0x16, 0x07, 0xB8, 0x2C, 0x43, 0x8C, 0x01, 0x20, 0xCF, 0xA0, 0x83, 0x01, 0x0C, 0xF0,
  0x96, 0x85, 0x6B, 0xEF, 0xEA, 0x43,
  // "7" (U+0037)
  0x0A, 0xFD, 0x0D, 0x0A, 0xFD, 0x0D, 0x0A, 0xFD, 0x0C, 0x01, 0x80, 0x42, 0x0B, 0xB0, 0x57, 0x10,
  0x1B, 0x0E, 0x72, 0x08, 0xB0, 0x77, 0x20, 0xEB, 0x01, 0x71, 0x07, 0xB0, 0x97, 0x20, 0xDB, 0x02,
  0x71, 0x05, 0xB0, 0xB7, 0x20, 0xCB, 0x04, 0x71, 0x04, 0xB0, 0xD7, 0x20, 0xBB, 0x06, 0x71, 0x03,
  0xB0, 0xE7, 0x20, 0xAB, 0x08, 0x71, 0x01, 0xC0, 0x17, 0x10, 0x8B, 0x0A, 0x71, 0x01, 0x0E, 0xB0,
  0x37, 0x10, 0x7B, 0x0C, 0x70,
  // "8" (U+0038)
  0x38, 0x62, 0x8C, 0xEF, 0xDA, 0x45, 0x06, 0xF9, 0x0A, 0x30, 0x4F, 0xB0, 0x72, 0x0A, 0xB8, 0x2B,
  0x33, 0x9B, 0x0D, 0x20, 0xCB, 0x01, 0x30, 0xEB, 0x20, 0xAB, 0x01, 0x30, 0xEA, 0x0D, 0x20, 0x5B,
  0x0A, 0x20, 0x7B, 0x07, 0x30, 0xBB, 0x0B, 0x0A, 0xB0, 0xB5, 0x0A, 0xE0, 0x86, 0x08, 0xE0, 0x84,
  0x01, 0x0C, 0xB0, 0xD0, 0xEB, 0x0C, 0x01, 0x20, 0xAB, 0x82, 0x90, 0x1B, 0xB8, 0x1C, 0x02, 0xB0,
  0xB4, 0x0A, 0xB0, 0x40, 0x5B, 0x06, 0x40, 0x3B, 0x08, 0x05, 0xB0, 0x84, 0x05, 0xB0, 0x80, 0x2C,
  0x83, 0x73, 0x36, 0xEB, 0x81, 0x50, 0xBF, 0xB0, 0xC2, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x48, 0x65,
  0xAD, 0xEF, 0xDA, 0x53,
  // "9" (U+0039)
  0x38, 0x53, 0xAD, 0xFE, 0xC7, 0x60, 0x8F, 0x0D, 0x02, 0x30, 0x7F, 0xA0, 0xE0, 0x12, 0x0E, 0xB8,
  0x29, 0x33, 0xAB, 0x81, 0xA0, 0x4B, 0x0B, 0x40, 0xBB, 0x01, 0x07, 0xB0, 0x74, 0x06, 0xB0, 0x50,
  0x7B, 0x07, 0x40, 0x6B, 0x08, 0x06, 0xB0, 0xA4, 0x0B, 0xB0, 0xA0, 0x3C, 0x82, 0x83, 0x4A, 0xC8,
  0x1A, 0x0C, 0xF0, 0xEB, 0x82, 0xA0, 0x2E, 0xE0, 0x6B, 0x09, 0x28, 0x61, 0x9D, 0xFE, 0xA3, 0x5B,
  0x07, 0x72, 0x09, 0xB0, 0x37, 0x10, 0x10, 0xEA, 0x0E, 0x72, 0x0B, 0xB0, 0x82, 0x85, 0x14, 0x32,
  0x47, 0xEB, 0x0D, 0x01, 0x20, 0x3F, 0x90, 0xE0, 0x33, 0x03, 0xF0, 0xB0, 0x24, 0x03, 0x0E, 0xA8,
  0x2D, 0xC8, 0x35,
  // ":" (U+003A)
  0x18, 0x47, 0xEE, 0x90, 0x2C, 0x00, 0x5C, 0x07, 0x02, 0xC8, 0x44, 0x06, 0xEE, 0x87, 0x77, 0x74,
  0x84, 0x7E, 0xE9, 0x02, 0xC0, 0x05, 0xC0, 0x70, 0x2C, 0x84, 0x40, 0x6E, 0xE8, 0x10,
  // ";" (U+003B)
  0x18, 0x31, 0xBE, 0xD4, 0x20, 0x9B, 0x0E, 0x20, 0xBC, 0x81, 0x10, 0x8B, 0x0E, 0x28, 0x31, 0xBE,
  0xD4, 0x80, 0xD7, 0x00, 0x5B, 0x07, 0x20, 0x8B, 0x04, 0x20, 0xBB, 0x30, 0xDA, 0x0A, 0x3B, 0x06,
  0x20, 0x3B, 0x01, 0x20, 0x6A, 0x0A, 0x30, 0xAA, 0x04, 0x30,
  // "<" (U+003C)
  0x74, 0x03, 0x72, 0x81, 0x5D, 0xA7, 0x05, 0x0C, 0xA0, 0xA5, 0x04, 0x0C, 0xC0, 0x93, 0x03, 0x0C,
  0xC0, 0xC0, 0x42, 0x03, 0x0B, 0xC0, 0xB0, 0x43, 0x0A, 0xC0, 0xB0, 0x35, 0x0E, 0xB0, 0xA7, 0x08,
  0xC8, 0x1E, 0x81, 0x58, 0x11, 0x8E, 0xC0, 0x90, 0x25, 0x81, 0x18, 0xEC, 0x0A, 0x03, 0x58, 0x11,
  0x7E, 0xB0, 0xA7, 0x18, 0x27, 0xEF, 0xA7, 0x30, 0x60, 0x90,
  // "=" (U+003D)
  0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x18, 0x09, 0x02, 0x77, 0x28, 0x09, 0x02,
  0x10, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x40,
  // ">" (U+003E)
  0x03, 0x74, 0x81, 0xAD, 0x57, 0x20, 0xAA, 0x0C, 0x05, 0x70, 0x9C, 0x0C, 0x04, 0x60, 0x40, 0xCC,
  0x0C, 0x04, 0x60, 0x40, 0xBC, 0x0B, 0x03, 0x60, 0x40, 0xBC, 0x0A, 0x70, 0xAB, 0x0E, 0x48, 0x11,
  0x8E, 0xC0, 0x82, 0x02, 0x09, 0xC8, 0x4E, 0x81, 0x03, 0xAC, 0x81, 0xE8, 0x13, 0x0A, 0xB8, 0x1E,
  0x71, 0x58, 0x2A, 0xFE, 0x77, 0x10, 0x90, 0x77, 0x30,
  // "?" (U+003F)
  0x28, 0x65, 0xAD, 0xEF, 0xDA, 0x52, 0x07, 0x0E, 0xF9, 0x81, 0xB0, 0x6F, 0xB8, 0x78, 0x0D, 0xEA,
  0x53, 0x38, 0xB8, 0x2E, 0x02, 0x15, 0x0D, 0xB7, 0x10, 0xEA, 0x0E, 0x70, 0x9B, 0x09, 0x50, 0x10,
  0xBB, 0x0C, 0x50, 0x30, 0xEB, 0x09, 0x60, 0xEB, 0x05, 0x60, 0x4B, 0x05, 0x70, 0x6B, 0x01, 0x70,
  0x10, 0xF3, 0x77, 0x68, 0x34, 0xDE, 0xB1, 0x70, 0xEB, 0x09, 0x7C, 0x0B, 0x70, 0xDB, 0x09, 0x78,
  0x33, 0xDE, 0xB1, 0x40,
  // "@" (U+0040)
  0x58, 0x54, 0xAD, 0xEE, 0xC7, 0x71, 0x01, 0x0B, 0xF0, 0xD0, 0x25, 0x01, 0x0D, 0xA8, 0x3A, 0x52,
  0x38, 0xA0, 0xE0, 0x24, 0x0C, 0xA0, 0x55, 0x03, 0xA0, 0xB3, 0x06, 0xA0, 0x77, 0x07, 0xA0, 0x42,
  0x81, 0xDF, 0xD2, 0x85, 0x5C, 0xED, 0xB7, 0x1A, 0x81, 0x90, 0x4A, 0x81, 0x60, 0x7E, 0x18, 0x3B,
  0xFE, 0x08, 0xA0, 0x20, 0x1A, 0x85, 0xB3, 0xBF, 0xE0, 0x8A, 0x18, 0x3B, 0xFD, 0x07, 0xA8, 0x51,
  0x0B, 0xFD, 0x07, 0xA8, 0x62, 0xDF, 0xB0, 0xBF, 0xD2, 0x83, 0xBF, 0xD0, 0x6A, 0x86, 0x2E, 0xFA,
  0x0C, 0xFB, 0x28, 0x3C, 0xFC, 0x07, 0xA0, 0x1A, 0x83, 0xA0, 0xCF, 0xB2, 0x83, 0xEF, 0xB0, 0x8A,
  0x18, 0x7E, 0xFB, 0x0A, 0xFC, 0x01, 0xA8, 0x91, 0xB0, 0xBF, 0xC0, 0xDF, 0xC0, 0x7A, 0x02, 0x07,
  0xA8, 0x5D, 0x2E, 0xF6, 0x0A, 0xA1, 0x01, 0xFA, 0x0D, 0x20, 0x6A, 0x86, 0x50, 0x5E, 0xFE, 0x45,
  0xA0, 0xC0, 0x23, 0x81, 0xEF, 0xD3, 0x01, 0x40, 0x15, 0x06, 0xA0, 0xA7, 0x70, 0xAA, 0x81, 0xC5,
  0x12, 0x82, 0x26, 0xB5, 0x60, 0x8F, 0xA0, 0x67, 0x81, 0x3A, 0xEC, 0x81, 0xC7, 0x17, 0x38, 0x11,
  0x21, 0x70,
  // "A" (U+0041)
  0x50, 0x8C, 0x0B, 0x73, 0x0C, 0xD7, 0x20, 0x1E, 0x04, 0x71, 0x06, 0xA0, 0xE0, 0xCA, 0x08, 0x71,
  0x0A, 0xA0, 0xB0, 0x8A, 0x0D, 0x71, 0x0E, 0xA0, 0x70, 0x4B, 0x02, 0x60, 0x3B, 0x03, 0x1B, 0x06,
  0x60, 0x7A, 0x0E, 0x20, 0xCA, 0x0A, 0x60, 0xCA, 0x0B, 0x20, 0x8A, 0x0E, 0x50, 0x1B, 0x07, 0x20,
  0x4B, 0x03, 0x40, 0x5B, 0x03, 0x3B, 0x08, 0x40, 0x9F, 0xB0, 0xC4, 0x0E, 0xFC, 0x01, 0x20, 0x3F,
  0xD0, 0x52, 0x07, 0xB8, 0x44, 0x22, 0x22, 0x3B, 0x0A, 0x20, 0xBA, 0x0E, 0x60, 0xCA, 0x0E, 0x2B,
  0x0A, 0x60, 0x9B, 0x03, 0x04, 0xB0, 0x66, 0x05, 0xB0, 0x70, 0x9B, 0x03, 0x60, 0x1B, 0x0C,
  // "B" (U+0042)
  0x0D, 0xE8, 0x2E, 0xC9, 0x33, 0x0D, 0xFB, 0x08, 0x20, 0xDF, 0xC8, 0x14, 0x0D, 0xA8, 0x4D, 0x22,
  0x35, 0xDB, 0x81, 0x90, 0xDA, 0x0C, 0x40, 0x5B, 0x81, 0xA0, 0xDA, 0x0C, 0x40, 0x5B, 0x81, 0x80,
  0xDA, 0x0C, 0x30, 0x30, 0xCB, 0x81, 0x30, 0xDF, 0xB0, 0x72, 0x0D, 0xF9, 0x0E, 0x05, 0x30, 0xDF,
  0xB0, 0x92, 0x0D, 0xA8, 0x4D, 0x22, 0x25, 0xDB, 0x81, 0x70, 0xDA, 0x0C, 0x40, 0x3B, 0x81, 0xD0,
  0xDA, 0x0C, 0x5C, 0x10, 0xDA, 0x0C, 0x5C, 0x01, 0x0D, 0xA0, 0xC4, 0x04, 0xC1, 0x0D, 0xA8, 0x4D,
  0x22, 0x25, 0xDB, 0x81, 0xB0, 0xDF, 0xC8, 0x13, 0x0D, 0xFB, 0x05, 0x20, 0xDE, 0x82, 0xED, 0x82,
  0x30,
  // "C" (U+0043)
  0x58, 0x74, 0x9C, 0xEF, 0xEC, 0x82, 0x30, 0x20, 0xCF, 0x90, 0xE2, 0x03, 0x0E, 0xFA, 0x82, 0x70,
  0x1E, 0xB8, 0x90, 0xD7, 0x43, 0x48, 0xE1, 0x08, 0xB0, 0xC0, 0x17, 0x10, 0xEB, 0x02, 0x71, 0x04,
  0xB0, 0xB7, 0x20, 0x7B, 0x07, 0x72, 0x09, 0xB0, 0x67, 0x20, 0x9B, 0x05, 0x72, 0x09, 0xB0, 0x57,
  0x20, 0x8B, 0x06, 0x72, 0x06, 0xB0, 0x97, 0x20, 0x2B, 0x0E, 0x73, 0x0C, 0xB0, 0x97, 0x20, 0x4C,
  0x86, 0xB5, 0x33, 0x58, 0xD5, 0x20, 0x9F, 0xB0, 0x53, 0x08, 0xFA, 0x05, 0x48, 0x72, 0x8C, 0xEF,
  0xEC, 0x95, 0x10,
  // "D" (U+0044)
  0x0C, 0xE8, 0x1D, 0xA6, 0x50, 0xCF, 0xA0, 0xD0, 0x33, 0x0C, 0xFC, 0x04, 0x20, 0xCB, 0x83, 0x32,
  0x36, 0xDB, 0x82, 0xE1, 0x0C, 0xB0, 0x14, 0x0C, 0xB8, 0x17, 0x0C, 0xB0, 0x14, 0x03, 0xB8, 0x1D,
  0x0C, 0xB0, 0x15, 0x0D, 0xB0, 0x10, 0xCB, 0x01, 0x50, 0xAB, 0x04, 0x0C, 0xB0, 0x15, 0x09, 0xB0,
  0x50, 0xCB, 0x01, 0x50, 0x9B, 0x05, 0x0C, 0xB0, 0x15, 0x09, 0xB0, 0x40, 0xCB, 0x01, 0x50, 0xBB,
  0x03, 0x0C, 0xB0, 0x15, 0x0E, 0xB1, 0x0C, 0xB0, 0x14, 0x05, 0xB8, 0x1C, 0x0C, 0xB0, 0x13, 0x01,
  0x0D, 0xB8, 0x15, 0x0C, 0xB8, 0x33, 0x23, 0x7E, 0xB0, 0xC2, 0x0C, 0xFB, 0x0E, 0x02, 0x20, 0xCF,
  0xA0, 0xC0, 0x13, 0x0C, 0xD8, 0x2E, 0xD9, 0x45,
  // "E" (U+0045)
  0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0,
  0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0,
  0xDF, 0xB8, 0x1E, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xFC, 0x04, 0x0D, 0xFC,
  0x04, 0x0D, 0xFC, 0x04,
  // "F" (U+0046)
  0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0,
  0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xFB, 0x81, 0xE0,
  0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7,
  0x20, 0xDA, 0x0E, 0x72,
  // "G" (U+0047)
  0x58, 0x73, 0x8C, 0xEF, 0xED, 0xA5, 0x50, 0x9F, 0xA0, 0xA3, 0x0C, 0xFB, 0x03, 0x20, 0x9C, 0x85,
  0xA5, 0x33, 0x59, 0xC2, 0x02, 0xC0, 0x57, 0x20, 0x8B, 0x09, 0x73, 0x0C, 0xB0, 0x27, 0x3B, 0x0E,
  0x73, 0x01, 0xB0, 0xC3, 0x03, 0xE0, 0x2B, 0x0B, 0x30, 0x3E, 0x02, 0xB0, 0xB3, 0x03, 0xE0, 0x1B,
  0x0D, 0x48, 0x12, 0x29, 0xB1, 0x0D, 0xB0, 0x15, 0x08, 0xB1, 0x0A, 0xB0, 0x75, 0x08, 0xB1, 0x04,
  0xB0, 0xE0, 0x34, 0x08, 0xB2, 0x0B, 0xB8, 0x4E, 0x83, 0x23, 0xBB, 0x20, 0x20, 0xEF, 0xC3, 0x02,
  0x0C, 0xFB, 0x58, 0x90, 0x59, 0xDE, 0xFE, 0xDB, 0x72,
  // "H" (U+0048)
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xCF, 0xE0, 0xCF, 0xE0, 0xCF, 0xE0, 0xCB, 0x04, 0x80, 0x12, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB,
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  // "I" (U+0049)
  0x08, 0xFB, 0x0B, 0x08, 0xFB, 0x82, 0xB6, 0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E, 0x01, 0x70,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC, 0x88, 0xFB,
  0x0B, 0x08, 0xFB, 0x0B,
  // "J" (U+004A)
  0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70,
  0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B,
  0x03, 0x70, 0x9B, 0x03, 0x70, 0x9B, 0x03, 0x70, 0xBB, 0x02, 0x60, 0x1B, 0x87, 0xE0, 0x67, 0x42,
  0x35, 0xDB, 0x81, 0xA0, 0xAF, 0xA8, 0x13, 0x0A, 0xF9, 0x05, 0x28, 0x76, 0xBD, 0xEF, 0xEC, 0x82,
  0x30,
  // "K" (U+004B)
  0x0C, 0xB5, 0x05, 0xB0, 0xD0, 0xCB, 0x40, 0x10, 0xEB, 0x03, 0x0C, 0xB4, 0x0A, 0xB8, 0x17, 0x0C,
  0xB3, 0x05, 0xB0, 0xB2, 0x0C, 0xB2, 0x01, 0x0E, 0xA0, 0xE0, 0x12, 0x0C, 0xB2, 0x0B, 0xB0, 0x53,
  0x0C, 0xB1, 0x05, 0xB0, 0x94, 0x0C, 0xB0, 0x10, 0xEA, 0x0D, 0x50, 0xCB, 0x09, 0xB0, 0x55, 0x0C,
  0xF0, 0xB5, 0x0C, 0xF9, 0x05, 0x40, 0xCC, 0x08, 0xB0, 0xD4, 0x0C, 0xB8, 0x15, 0x0A, 0xB0, 0x73,
  0x0C, 0xB2, 0x02, 0xB0, 0xE0, 0x12, 0x0C, 0xB3, 0x09, 0xB0, 0x92, 0x0C, 0xB3, 0x01, 0x0E, 0xB8,
  0x12, 0x0C, 0xB4, 0x08, 0xB8, 0x1B, 0x0C, 0xB5, 0x0E, 0xB0, 0x40, 0xCB, 0x50, 0x6B, 0x0C,
  // "L" (U+004C)
  0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0,
  0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10,
  0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05,
  0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x06, 0x80, 0x32, 0x10, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40,
  0x8F, 0xC0, 0x40,
  // "M" (U+004D)
  0x0E, 0xC0, 0x63, 0xD0, 0x10, 0xEC, 0x09, 0x20, 0x2D, 0x01, 0x0E, 0xC0, 0xB2, 0x05, 0xD0, 0x10,
  0xEA, 0x81, 0xEF, 0xD2, 0x08, 0xD0, 0x10, 0xEA, 0x0B, 0xA2, 0x82, 0xBF, 0xDD, 0xA0, 0x10, 0xEA,
  0x09, 0xA8, 0x42, 0x0D, 0xFA, 0xEA, 0x01, 0x0E, 0xA0, 0x8A, 0x05, 0x01, 0xA0, 0x8B, 0x01, 0x0E,
  0xA0, 0x6A, 0x07, 0x03, 0xA0, 0x6B, 0x01, 0x0E, 0xA0, 0x5A, 0x09, 0x06, 0xA0, 0x4B, 0x01, 0x0E,
  0xA8, 0x35, 0xCF, 0xC9, 0xA0, 0x3B, 0x01, 0x0E, 0xA8, 0x66, 0x9F, 0xEB, 0xFC, 0x4B, 0x01, 0x0E,
  0xA0, 0x07, 0xC0, 0x90, 0x4B, 0x01, 0x0E, 0xA0, 0x80, 0x4C, 0x07, 0x05, 0xB0, 0x10, 0xEA, 0x08,
  0x01, 0xC0, 0x40, 0x6B, 0x01, 0x0E, 0xA8, 0x19, 0x0D, 0xB0, 0x10, 0x6B, 0x01, 0x0E, 0xA0, 0x96,
  0x06, 0xB0, 0x10, 0xEA, 0x09, 0x60, 0x6B, 0x01, 0x0E, 0xA0, 0x96, 0x06, 0xB0, 0x10, 0xEA, 0x09,
  0x60, 0x6B, 0x01,
  // "N" (U+004E)
  0x0C, 0xC0, 0xA4, 0x07, 0xB0, 0xCD, 0x40, 0x7B, 0x0C, 0xD0, 0x53, 0x07, 0xB0, 0xCA, 0x0E, 0xA0,
  0xA3, 0x07, 0xB0, 0xCA, 0x0A, 0xB3, 0x07, 0xB0, 0xCA, 0x08, 0x0D, 0xA0, 0x52, 0x07, 0xB0, 0xCA,
  0x09, 0x08, 0xA0, 0xA2, 0x07, 0xB0, 0xCA, 0x09, 0x02, 0xB2, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0xDA,
  0x81, 0x50, 0x7B, 0x0C, 0xA8, 0x1A, 0x08, 0xA8, 0x1A, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0x3A, 0x81,
  0xE0, 0x7B, 0x0C, 0xA0, 0xA2, 0x0D, 0xA0, 0x50, 0x7B, 0x0C, 0xA0, 0xA2, 0x08, 0xA0, 0xA0, 0x6B,
  0x0C, 0xA0, 0xA2, 0x03, 0xA0, 0xE0, 0x7B, 0x0C, 0xA0, 0xA3, 0x0D, 0xA0, 0xAB, 0x0C, 0xA0, 0xA3,
  0x08, 0xA0, 0xEB, 0x0C, 0xA0, 0xA3, 0x03, 0xE0, 0xCA, 0x0A, 0x40, 0xDD, 0x0C, 0xA0, 0xA4, 0x08,
  0xD0,
  // "O" (U+004F)
  0x48, 0x62, 0x8D, 0xEE, 0xD9, 0x47, 0x07, 0xF9, 0x09, 0x50, 0x5F, 0xB0, 0x84, 0x0E, 0xB8, 0x2A,
  0x33, 0x8C, 0x02, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20,
  0xEB, 0x60, 0xCB, 0x00, 0x1B, 0x0D, 0x60, 0xAB, 0x04, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B,
  0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x1B, 0x0D, 0x60, 0xAB, 0x81, 0x40,
  0xEB, 0x60, 0xDB, 0x81, 0x10, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09,
  0x30, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x23, 0x05, 0xFB, 0x08, 0x50, 0x7F, 0x90, 0x97, 0x86, 0x29,
  0xDE, 0xED, 0xA4, 0x40,
  // "P" (U+0050)
  0x0D, 0xE8, 0x2E, 0xC9, 0x23, 0x0D, 0xFB, 0x06, 0x20, 0xDF, 0xC8, 0x14, 0x0D, 0xA8, 0x4E, 0x22,
  0x25, 0xCB, 0x81, 0xB0, 0xDA, 0x0E, 0x40, 0x1C, 0x10, 0xDA, 0x0E, 0x50, 0xCB, 0x01, 0x0D, 0xA0,
  0xE5, 0x0D, 0xB1, 0x0D, 0xA0, 0xE4, 0x03, 0xB8, 0x1E, 0x0D, 0xA8, 0x4E, 0x22, 0x36, 0xEB, 0x81,
  0x90, 0xDF, 0xB8, 0x2E, 0x20, 0xDF, 0xA0, 0xE0, 0x42, 0x0D, 0xE8, 0x2D, 0xC7, 0x13, 0x0D, 0xA0,
  0xE7, 0x30, 0xDA, 0x0E, 0x73, 0x0D, 0xA0, 0xE7, 0x30, 0xDA, 0x0E, 0x73, 0x0D, 0xA0, 0xE7, 0x30,
  0xDA, 0x0E, 0x73, 0x0D, 0xA0, 0xE7, 0x30,
  // "Q" (U+0051)
  0x48, 0x62, 0x8D, 0xEE, 0xD9, 0x47, 0x07, 0xF9, 0x09, 0x50, 0x5F, 0xB0, 0x84, 0x0E, 0xB8, 0x2A,
  0x33, 0x8C, 0x02, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20,
  0xEB, 0x60, 0xCB, 0x00, 0x1B, 0x0D, 0x60, 0xAB, 0x04, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B,
  0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x40, 0x1B, 0x0D, 0x60, 0xAB, 0x81, 0x30,
  0xEB, 0x60, 0xDB, 0x81, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0D, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09,
  0x30, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x33, 0x05, 0xFB, 0x09, 0x50, 0x7F, 0x90, 0xA7, 0x82, 0x29,
  0xDE, 0xC0, 0x17, 0x40, 0x5B, 0x09, 0x75, 0x0C, 0xB0, 0x37, 0x40, 0x4B, 0x0B, 0x75, 0x0C, 0xB0,
  0x57, 0x48, 0x33, 0x77, 0x75, 0x10,
  // "R" (U+0052)
  0x0D, 0xD8, 0x2E, 0xC8, 0x24, 0x0D, 0xFA, 0x06, 0x30, 0xDF, 0xB0, 0x52, 0x0D, 0xB8, 0x23, 0x35,
  0xCB, 0x0D, 0x20, 0xDB, 0x01, 0x30, 0xDB, 0x81, 0x30, 0xDB, 0x01, 0x30, 0xAB, 0x81, 0x40, 0xDB,
  0x01, 0x30, 0xBB, 0x81, 0x40, 0xDB, 0x01, 0x20, 0x10, 0xEB, 0x81, 0x10, 0xDB, 0x82, 0x33, 0x5C,
  0xB0, 0xB2, 0x0D, 0xFA, 0x0E, 0x02, 0x20, 0xDF, 0x90, 0xD0, 0x33, 0x0D, 0xF9, 0x04, 0x40, 0xDB,
  0x01, 0x02, 0xB0, 0xD4, 0x0D, 0xB8, 0x11, 0x08, 0xB0, 0x73, 0x0D, 0xB0, 0x12, 0x0D, 0xA0, 0xE0,
  0x12, 0x0D, 0xB0, 0x12, 0x05, 0xB0, 0xA2, 0x0D, 0xB0, 0x13, 0x0C, 0xB8, 0x14, 0x0D, 0xB0, 0x13,
  0x03, 0xB8, 0x1D, 0x0D, 0xB0, 0x14, 0x0A, 0xB0, 0x70,
  // "S" (U+0053)
  0x38, 0x90, 0x17, 0xCE, 0xFE, 0xDA, 0x71, 0x30, 0x50, 0xEF, 0xA8, 0x12, 0x02, 0xFB, 0x0D, 0x20,
  0x8B, 0x86, 0xE6, 0x33, 0x6A, 0xF7, 0x20, 0xAB, 0x06, 0x50, 0x13, 0x0A, 0xB0, 0x57, 0x20, 0x7B,
  0x0C, 0x72, 0x01, 0x0E, 0xB0, 0xE0, 0x67, 0x10, 0x40, 0xEC, 0x0E, 0x07, 0x70, 0x20, 0xBD, 0x0D,
  0x04, 0x70, 0x50, 0xDD, 0x07, 0x71, 0x06, 0x0D, 0xC0, 0x37, 0x20, 0xBB, 0x09, 0x72, 0x05, 0xB8,
  0x1A, 0x04, 0x70, 0x7B, 0x89, 0x09, 0x1F, 0xD9, 0x53, 0x23, 0x7C, 0x05, 0x01, 0xFC, 0x81, 0xC0,
  0x1F, 0xB0, 0xB0, 0x12, 0x89, 0x02, 0x7B, 0xDE, 0xFE, 0xC9, 0x33,
  // "T" (U+0054)
  0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x18, 0x01, 0x20, 0xDB, 0x03, 0x80, 0x02,
  0x70, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50,
  0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB,
  0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x60,
  // "U" (U+0055)
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15,
  0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0B, 0xB0, 0x25, 0xC0, 0xAB, 0x04, 0x40, 0x1B, 0x0D, 0x08,
  0xB0, 0x94, 0x06, 0xB0, 0xA0, 0x2C, 0x82, 0x94, 0x37, 0xC8, 0x15, 0x09, 0xFB, 0x0C, 0x30, 0xAF,
  0x90, 0xC0, 0x14, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x53,
  // "V" (U+0056)
  0x09, 0xB0, 0x56, 0x02, 0xB0, 0xC0, 0x4B, 0x09, 0x60, 0x6B, 0x81, 0x70, 0xEA, 0x0D, 0x60, 0xAB,
  0x81, 0x30, 0xAB, 0x01, 0x50, 0xEA, 0x0D, 0x20, 0x6B, 0x05, 0x40, 0x2B, 0x09, 0x20, 0x1B, 0x09,
  0x40, 0x6B, 0x04, 0x30, 0xCA, 0x0D, 0x40, 0xAA, 0x0E, 0x40, 0x7B, 0x02, 0x30, 0xEA, 0x0A, 0x40,
  0x3B, 0x06, 0x20, 0x2B, 0x06, 0x50, 0xEA, 0x09, 0x20, 0x6B, 0x01, 0x50, 0x9A, 0x0D, 0x20, 0xAA,
  0x0C, 0x60, 0x5B, 0x81, 0x20, 0xDA, 0x07, 0x7B, 0x06, 0x01, 0xB0, 0x37, 0x0B, 0xA0, 0x90, 0x4A,
  0x0E, 0x71, 0x06, 0xA0, 0xC0, 0x7A, 0x09, 0x71, 0x02, 0xB0, 0xBA, 0x05, 0x72, 0x0D, 0xD7, 0x30,
  0x8C, 0x0B, 0x73, 0x03, 0xC0, 0x65,
  // "W" (U+0057)
  0x0A, 0xA0, 0xB7, 0x10, 0x7A, 0x0D, 0x09, 0xA0, 0xC7, 0x10, 0x9A, 0x0C, 0x08, 0xA0, 0xE7, 0x10,
  0xAA, 0x0B, 0x07, 0xB7, 0x10, 0xBA, 0x0A, 0x06, 0xB8, 0x11, 0x0C, 0xB2, 0x0C, 0xA0, 0x90, 0x5B,
  0x81, 0x20, 0xEB, 0x81, 0x30, 0xDA, 0x08, 0x03, 0xB0, 0x40, 0x1C, 0x81, 0x50, 0xEA, 0x07, 0x02,
  0xB0, 0x50, 0x4C, 0x07, 0x1B, 0x06, 0x01, 0xB0, 0x50, 0x6A, 0x82, 0xCF, 0xA1, 0xB0, 0x51, 0xB8,
  0x66, 0x9F, 0xD9, 0xFC, 0x2B, 0x81, 0x30, 0xEA, 0x86, 0x6B, 0xFB, 0x7F, 0xE2, 0xB8, 0x12, 0x0D,
  0xA8, 0x37, 0xDF, 0x95, 0xA0, 0x4B, 0x81, 0x10, 0xCA, 0x07, 0xA0, 0x70, 0x3A, 0x06, 0xB2, 0x0B,
  0xA0, 0x8A, 0x04, 0x01, 0xA0, 0x8B, 0x20, 0x9A, 0x0A, 0xA8, 0x32, 0x0E, 0xFA, 0xA0, 0xD2, 0x08,
  0xA0, 0xDA, 0x28, 0x1C, 0xFC, 0xA0, 0xC2, 0x07, 0xC0, 0xD2, 0x0A, 0xC0, 0xB2, 0x06, 0xC0, 0xB2,
  0x07, 0xC0, 0xA2, 0x05, 0xC0, 0x82, 0x05, 0xC0, 0x91,
  // "X" (U+0058)
  0x10, 0xCB, 0x02, 0x40, 0x10, 0xEA, 0x82, 0xE1, 0x03, 0xB0, 0xA4, 0x08, 0xB0, 0x63, 0x09, 0xB0,
  0x32, 0x01, 0xB0, 0xC4, 0x01, 0x0E, 0xA0, 0xB2, 0x09, 0xB0, 0x35, 0x07, 0xB0, 0x40, 0x2B, 0x09,
  0x70, 0xDA, 0x0C, 0x0A, 0xA0, 0xE0, 0x17, 0x04, 0xE0, 0x77, 0x20, 0xAC, 0x0D, 0x73, 0x02, 0xC0,
  0x47, 0x40, 0xDB, 0x01, 0x73, 0x06, 0xC0, 0xA7, 0x20, 0x10, 0xED, 0x03, 0x71, 0x09, 0xA0, 0xE0,
  0xDA, 0x0C, 0x70, 0x3B, 0x07, 0x05, 0xB0, 0x66, 0x0C, 0xA0, 0xE2, 0x0C, 0xA0, 0xE0, 0x14, 0x06,
  0xB0, 0x62, 0x04, 0xB0, 0x93, 0x01, 0x0E, 0xA0, 0xD4, 0x0C, 0xB0, 0x32, 0x08, 0xB0, 0x54, 0x03,
  0xB8, 0x1B, 0x02, 0xB0, 0xC6, 0x0B, 0xB0, 0x50,
  // "Y" (U+0059)
  0x03, 0xB0, 0xD6, 0x0A, 0xB8, 0x16, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x03, 0xB0, 0xB4, 0x07,
  0xB0, 0x73, 0x0B, 0xB0, 0x23, 0x0E, 0xA0, 0xE4, 0x04, 0xB0, 0x92, 0x05, 0xB0, 0x75, 0x0C, 0xA8,
  0x2E, 0x10, 0xCA, 0x0E, 0x01, 0x50, 0x4B, 0x07, 0x03, 0xB0, 0x87, 0x0C, 0xA0, 0xD0, 0x9B, 0x01,
  0x70, 0x5E, 0x08, 0x72, 0x0D, 0xD0, 0x17, 0x20, 0x6C, 0x09, 0x74, 0x0E, 0xB0, 0x27, 0x40, 0xDB,
  0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74,
  0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x50,
  // "Z" (U+005A)
  0x02, 0xFC, 0x03, 0x02, 0xFC, 0x03, 0x02, 0xFC, 0x02, 0x18, 0x02, 0x20, 0x7B, 0x0A, 0x71, 0x0D,
  0xB0, 0x27, 0x07, 0xB0, 0x77, 0x01, 0x0E, 0xA0, 0xD7, 0x10, 0x9B, 0x05, 0x70, 0x3B, 0x0B, 0x71,
  0x0C, 0xB0, 0x27, 0x05, 0xB0, 0x97, 0x10, 0xDA, 0x0E, 0x01, 0x70, 0x7B, 0x06, 0x70, 0x10, 0xEA,
  0x0C, 0x71, 0x0A, 0xB0, 0x37, 0x03, 0xB0, 0xB8, 0x03, 0x21, 0x0B, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  0x0D, 0xFC, 0x04,
  // "[" (U+005B)
  0x0C, 0xD0, 0xA0, 0xCD, 0x0A, 0x0C, 0xD0, 0xA0, 0xCA, 0x83, 0x92, 0x21, 0xCA, 0x08, 0x30, 0xCA,
  0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08,
  0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30,
  0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCA, 0x08, 0x30, 0xCD,
  0x0A, 0x0C, 0xD0, 0xA0, 0xCD, 0x0A, 0x01, 0x80, 0x12, 0x01,
  // "\" (U+005C)
  0x04, 0xB0, 0x17, 0x10, 0xDA, 0x07, 0x71, 0x08, 0xA0, 0xD7, 0x10, 0x2B, 0x03, 0x71, 0x0B, 0xA0,
  0x97, 0x10, 0x5A, 0x0E, 0x72, 0x0E, 0xA0, 0x67, 0x10, 0x9A, 0x0C, 0x71, 0x03, 0xB0, 0x37, 0x10,
  0xCA, 0x09, 0x71, 0x06, 0xA0, 0xE7, 0x10, 0x10, 0xEA, 0x05, 0x71, 0x09, 0xA0, 0xB7, 0x10, 0x3B,
  0x02, 0x71, 0x0D, 0xA0, 0x87, 0x10, 0x7A, 0x0E, 0x71, 0x01, 0xB0, 0x47, 0x10, 0xAA, 0x0A, 0x71,
  0x04, 0xB0, 0x10,
  // "]" (U+005D)
  0x01, 0x80, 0x12, 0x01, 0x0A, 0xD0, 0xC0, 0xAD, 0x0C, 0x0A, 0xD0, 0xC3, 0x08, 0xA0, 0xC3, 0x08,
  0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0,
  0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3,
  0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA0, 0xC3, 0x08, 0xA8, 0x3C, 0x12,
  0x29, 0xA0, 0xC0, 0xAD, 0x0C, 0x0A, 0xD0, 0xC0, 0xAD, 0x0C,
  // "^" (U+005E)
  0x50, 0x4A, 0x01, 0x73, 0x0B, 0xA0, 0x97, 0x20, 0x4C, 0x02, 0x71, 0x0B, 0xC0, 0xA7, 0x03, 0xA0,
  0xD0, 0xEA, 0x03, 0x60, 0xBA, 0x06, 0x07, 0xA0, 0xB5, 0x03, 0xA0, 0xD2, 0x0E, 0xA0, 0x34, 0x0B,
  0xA0, 0x62, 0x06, 0xA0, 0xB3, 0x03, 0xA0, 0xE4, 0x0D, 0xA0, 0x42, 0x0A, 0xA0, 0x74, 0x05, 0xA8,
  0x1C, 0x02, 0xA0, 0xE6, 0x0D, 0xA0, 0x50, 0xAA, 0x07, 0x60, 0x5A, 0x0D,
  // "_" (U+005F)
  0x80, 0x94, 0x21, 0xFF, 0xA0, 0x3F, 0xFA, 0x03, 0xFF, 0xA0, 0x30,
  // "`" (U+0060)
  0x02, 0x80, 0x07, 0x40, 0xAB, 0x08, 0x40, 0xAB, 0x02, 0x40, 0xAA, 0x0C, 0x50, 0x8A, 0x07,
  // "a" (U+0061)
  0x28, 0x23, 0x8B, 0xEA, 0x81, 0xDA, 0x54, 0x08, 0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86,
  0xBB, 0x74, 0x33, 0x7E, 0xB0, 0x27, 0x20, 0x7B, 0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05,
  0x0B, 0xFA, 0x81, 0x60, 0x9F, 0xC0, 0x60, 0x4B, 0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04,
  0x40, 0x5B, 0x06, 0x09, 0xB0, 0x34, 0x0B, 0xB0, 0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04,
  0xFD, 0x81, 0x60, 0xAE, 0x81, 0xE3, 0xEA, 0x06, 0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0A, 0xA0, 0x60,
  // "b" (U+0062)
  0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0,
  0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB8, 0x64, 0x18, 0xDF, 0xEA, 0x23, 0x08, 0xB0, 0x60, 0xEE,
  0x03, 0x20, 0x8F, 0xC0, 0xE2, 0x08, 0xC8, 0x2C, 0x43, 0x7C, 0x81, 0x60, 0x8B, 0x0D, 0x40, 0x6B,
  0x81, 0xB0, 0x8B, 0x07, 0x40, 0x1B, 0x81, 0xE0, 0x8B, 0x05, 0x50, 0xDB, 0x10, 0x8B, 0x05, 0x50,
  0xDB, 0x01, 0x08, 0xB0, 0x55, 0x0E, 0xB1, 0x08, 0xB0, 0x84, 0x01, 0xB8, 0x1E, 0x08, 0xB0, 0xD4,
  0x07, 0xB8, 0x1B, 0x08, 0xC8, 0x2C, 0x42, 0x7C, 0x81, 0x60, 0x8F, 0xC0, 0xD2, 0x08, 0xA8, 0x1D,
  0x3E, 0xD0, 0xE0, 0x32, 0x08, 0xA8, 0x79, 0x01, 0x9D, 0xFD, 0x92, 0x30,
  // "c" (U+0063)
  0x48, 0x73, 0x9D, 0xEF, 0xDC, 0x94, 0x30, 0xAF, 0x90, 0xC2, 0x0A, 0xFA, 0x81, 0x60, 0x4C, 0x87,
  0xA4, 0x23, 0x6B, 0x10, 0xAB, 0x09, 0x71, 0x0E, 0xB0, 0x27, 0x1B, 0x0E, 0x71, 0x01, 0xB0, 0xD7,
  0x2B, 0x0E, 0x72, 0x0E, 0xB0, 0x17, 0x10, 0xBB, 0x09, 0x68, 0x11, 0x06, 0xC8, 0x5A, 0x42, 0x47,
  0xC9, 0x20, 0xCF, 0xA0, 0x92, 0x01, 0x0C, 0xF9, 0x09, 0x48, 0x75, 0xAD, 0xEF, 0xDB, 0x71,
  // "d" (U+0064)
  0x72, 0x01, 0xB0, 0xB7, 0x20, 0x1B, 0x0B, 0x72, 0x01, 0xB0, 0xB7, 0x20, 0x1B, 0x0B, 0x72, 0x01,
  0xB0, 0xB7, 0x20, 0x1B, 0x0B, 0x38, 0x47, 0xCE, 0xEB, 0x41, 0xB8, 0x2B, 0x01, 0xCE, 0x07, 0x0E,
  0xA8, 0x1B, 0x0B, 0xFC, 0x0B, 0x03, 0xC8, 0x3A, 0x33, 0x6E, 0xB0, 0xB0, 0x8B, 0x0B, 0x40, 0x6B,
  0x00, 0xBB, 0x04, 0x5B, 0x0B, 0x0D, 0xB0, 0x15, 0x0D, 0xA0, 0xB0, 0xEB, 0x60, 0xDA, 0x0B, 0x0D,
  0xB0, 0x15, 0x0D, 0xA0, 0x0B, 0xB0, 0x35, 0xB0, 0xB0, 0x8B, 0x09, 0x40, 0x6B, 0x0B, 0x04, 0xC8,
  0x29, 0x43, 0x7C, 0x81, 0xB0, 0xCF, 0xC8, 0x2B, 0x02, 0xEE, 0x04, 0x0D, 0xA0, 0xB2, 0x87, 0x19,
  0xDF, 0xEA, 0x20, 0x7A, 0x0B,
  // "e" (U+0065)
  0x38, 0x61, 0x7C, 0xEF, 0xDA, 0x45, 0x04, 0x0E, 0xF0, 0xA3, 0x02, 0xFB, 0x09, 0x20, 0xCB, 0x83,
  0xB4, 0x35, 0xDB, 0x00, 0x2B, 0x0B, 0x40, 0x10, 0xEA, 0x00, 0x7B, 0x07, 0x80, 0x12, 0x0C, 0xA0,
  0xB0, 0x8F, 0xD0, 0xC0, 0x9F, 0xD0, 0xD0, 0x8F, 0xD0, 0xD0, 0x6B, 0x04, 0x72, 0x02, 0xB0, 0xB7,
  0x30, 0xAB, 0x89, 0x2D, 0x73, 0x23, 0x58, 0xC6, 0x01, 0xDF, 0xB0, 0x62, 0x02, 0x0C, 0xFA, 0x06,
  0x48, 0x74, 0x9D, 0xEF, 0xEC, 0xA5, 0x10,
  // "f" (U+0066)
  0x68, 0x71, 0x8C, 0xEF, 0xEC, 0x94, 0x50, 0x20, 0xEF, 0x05, 0x50, 0xBF, 0x0E, 0x50, 0x1C, 0x83,
  0x93, 0x24, 0x65, 0x03, 0xB0, 0xD7, 0x30, 0x3B, 0x0A, 0x78, 0x25, 0x8B, 0xEF, 0x98, 0x16, 0x02,
  0xFD, 0x81, 0x60, 0x2F, 0xD0, 0x62, 0x0F, 0x20, 0x5B, 0x84, 0xB2, 0x22, 0x21, 0x50, 0x3B, 0x0A,
  0x73, 0x03, 0xB0, 0xA7, 0x30, 0x3B, 0x0A, 0x73, 0x03, 0xB0, 0xA7, 0x30, 0x3B, 0x0A, 0x73, 0x03,
  0xB0, 0xA7, 0x30, 0x3B, 0x0A, 0x73, 0x03, 0xB0, 0xA7, 0x30, 0x3B, 0x0A, 0x73, 0x03, 0xB0, 0xA7,
  0x30, 0x3B, 0x0A, 0x60,
  // "g" (U+0067)
  0x28, 0x71, 0x8D, 0xFE, 0xA3, 0x07, 0xA8, 0x2B, 0x01, 0xDE, 0x05, 0x0D, 0xA8, 0x1B, 0x0B, 0xFC,
  0x0B, 0x03, 0xC8, 0x29, 0x33, 0x7C, 0x0B, 0x08, 0xB0, 0xA4, 0x08, 0xB0, 0x0B, 0xB0, 0x44, 0x02,
  0xB0, 0xB0, 0xDB, 0x02, 0x5B, 0x0B, 0x0E, 0xB0, 0x15, 0x0E, 0xA0, 0xB0, 0xDB, 0x02, 0x5B, 0x00,
  0xBB, 0x04, 0x40, 0x2B, 0x0B, 0x08, 0xB0, 0xA4, 0x07, 0xB0, 0xB0, 0x3C, 0x82, 0x93, 0x37, 0xC8,
  0x1B, 0x0B, 0xFC, 0x82, 0xB0, 0x1D, 0xE0, 0x7B, 0x0B, 0x28, 0x61, 0x8D, 0xFE, 0xA3, 0x3B, 0x0B,
  0x72, 0x05, 0xB8, 0x19, 0x01, 0x70, 0x9B, 0x89, 0x07, 0x0D, 0xC7, 0x43, 0x24, 0x9C, 0x81, 0x20,
  0xDF, 0xB0, 0x82, 0x0D, 0xFA, 0x08, 0x38, 0x24, 0x9C, 0xDA, 0x82, 0xEB, 0x82, 0x30,
  // "h" (U+0068)
  0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0,
  0x67, 0x20, 0x8B, 0x05, 0x72, 0x08, 0xB8, 0x65, 0x18, 0xDF, 0xEB, 0x52, 0x08, 0xB0, 0x60, 0xDE,
  0x81, 0x80, 0x8F, 0xD0, 0x30, 0x8C, 0x83, 0xC4, 0x36, 0xEB, 0x09, 0x08, 0xB0, 0xE0, 0x13, 0x05,
  0xB0, 0xC0, 0x8B, 0x0A, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x74, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64,
  0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06,
  0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0,
  // "i" (U+0069)
  0x58, 0x32, 0xCE, 0xC3, 0x72, 0x0A, 0xB0, 0xB7, 0x20, 0xCB, 0x0D, 0x72, 0x0A, 0xB0, 0xB7, 0x28,
  0x32, 0xCE, 0xC3, 0x77, 0x50, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39,
  0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77,
  0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13,
  0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "j" (U+006A)
  0x68, 0x34, 0xDE, 0xB1, 0x60, 0xDB, 0x09, 0x6C, 0x0B, 0x60, 0xDB, 0x08, 0x68, 0x34, 0xDE, 0xB1,
  0x76, 0x08, 0xF0, 0x92, 0x08, 0xF0, 0x92, 0x07, 0xF0, 0x94, 0x81, 0x23, 0x8B, 0x09, 0x60, 0x5B,
  0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09,
  0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60, 0x5B, 0x09, 0x60,
  0x6B, 0x08, 0x60, 0xAB, 0x85, 0x78, 0x53, 0x24, 0x9C, 0x03, 0x0E, 0xF9, 0x81, 0xC0, 0xEF, 0x89,
  0x1D, 0x20, 0x7B, 0xDE, 0xFE, 0xB7, 0x30,
  // "k" (U+006B)
  0x05, 0xB0, 0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0, 0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0,
  0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0, 0x84, 0x07, 0xB8, 0x1D, 0x15, 0xB0, 0x83, 0x05, 0xB8,
  0x2E, 0x30, 0x5B, 0x08, 0x20, 0x30, 0xEB, 0x04, 0x20, 0x5B, 0x82, 0x80, 0x1D, 0xB0, 0x63, 0x05,
  0xB8, 0x17, 0x0C, 0xB0, 0x84, 0x05, 0xB0, 0x60, 0x9B, 0x0A, 0x50, 0x5B, 0x0A, 0xC0, 0x45, 0x05,
  0xF9, 0x0D, 0x50, 0x5D, 0x0E, 0xB0, 0x84, 0x05, 0xC8, 0x19, 0x1D, 0xB0, 0x33, 0x05, 0xB0, 0x92,
  0x04, 0xB0, 0xC3, 0x05, 0xB0, 0x83, 0x0A, 0xB0, 0x72, 0x05, 0xB0, 0x83, 0x01, 0x0E, 0xB8, 0x12,
  0x05, 0xB0, 0x84, 0x05, 0xB8, 0x1C, 0x05, 0xB0, 0x85, 0x0B, 0xB0, 0x70,
  // "l" (U+006C)
  0x10, 0x6F, 0x06, 0x50, 0x6F, 0x06, 0x50, 0x40, 0xDE, 0x06, 0x71, 0x04, 0x0B, 0xB0, 0x67, 0x20,
  0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06,
  0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08,
  0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x71, 0x01, 0x09, 0xB0,
  0x80, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "m" (U+006D)
  0x02, 0xA8, 0x94, 0x81, 0xAE, 0xD6, 0x02, 0xCE, 0xD4, 0x02, 0xA0, 0xC0, 0xAC, 0x04, 0x0D, 0xB8,
  0x1D, 0x02, 0xF9, 0x0E, 0xD0, 0x02, 0xB8, 0x1A, 0x3D, 0xB0, 0x05, 0xB0, 0x40, 0x2B, 0x81, 0x30,
  0x9A, 0x0D, 0x2B, 0x05, 0x02, 0xB8, 0x13, 0x09, 0xA0, 0xC2, 0xB0, 0x60, 0x2B, 0x81, 0x20, 0x9A,
  0x0C, 0x2B, 0x06, 0x02, 0xB8, 0x12, 0x09, 0xA0, 0xC2, 0xB0, 0x60, 0x2B, 0x81, 0x20, 0x9A, 0x0C,
  0x2B, 0x06, 0x02, 0xB8, 0x12, 0x09, 0xA0, 0xC2, 0xB0, 0x60, 0x2B, 0x81, 0x20, 0x9A, 0x0C, 0x2B,
  0x06, 0x02, 0xB8, 0x12, 0x09, 0xA0, 0xC2, 0xB0, 0x60, 0x2B, 0x81, 0x20, 0x9A, 0x0C, 0x2B, 0x06,
  0x02, 0xB8, 0x12, 0x09, 0xA0, 0xC2, 0xB0, 0x60, 0x2B, 0x81, 0x20, 0x9A, 0x0C, 0x2B, 0x06,
  // "n" (U+006E)
  0x08, 0xA8, 0x79, 0x02, 0x9D, 0xFE, 0xB5, 0x20, 0x8A, 0x0E, 0x04, 0xF8, 0x19, 0x08, 0xFD, 0x03,
  0x08, 0xC8, 0x3D, 0x53, 0x6E, 0xB0, 0x90, 0x8C, 0x02, 0x30, 0x6B, 0x0C, 0x08, 0xB0, 0xB4, 0x02,
  0xB0, 0xD0, 0x8B, 0x08, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x74, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64,
  0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06,
  0x40, 0x1B, 0x0D,
  // "o" (U+006F)
  0x38, 0x61, 0x7C, 0xEF, 0xDA, 0x36, 0x05, 0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92, 0x01, 0x0E, 0xB8,
  0x2A, 0x33, 0x7C, 0x81, 0x30, 0x6B, 0x0B, 0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05, 0x40, 0x1B, 0x81,
  0xE0, 0xCB, 0x02, 0x50, 0xEB, 0x10, 0xDB, 0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0, 0x25, 0x0E, 0xB1,
  0x0B, 0xB0, 0x54, 0x01, 0xB8, 0x1E, 0x06, 0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xA3,
  0x37, 0xC0, 0x32, 0x06, 0xFB, 0x09, 0x40, 0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE, 0xED, 0x93, 0x40,
  // "p" (U+0070)
  0x08, 0xA8, 0x79, 0x01, 0x9D, 0xFE, 0xA3, 0x30, 0x8A, 0x81, 0xE4, 0xEE, 0x03, 0x20, 0x8F, 0xC0,
  0xE2, 0x08, 0xC8, 0x2B, 0x42, 0x7C, 0x81, 0x60, 0x8B, 0x0E, 0x40, 0x8B, 0x81, 0xB0, 0x8B, 0x08,
  0x40, 0x2B, 0x81, 0xE0, 0x8B, 0x05, 0x5C, 0x10, 0x8B, 0x04, 0x50, 0xEB, 0x01, 0x08, 0xB0, 0x55,
  0xC0, 0x10, 0x8B, 0x08, 0x40, 0x2B, 0x81, 0xE0, 0x8B, 0x0D, 0x40, 0x7B, 0x81, 0xB0, 0x8C, 0x82,
  0xC4, 0x26, 0xC8, 0x16, 0x08, 0xFC, 0x0D, 0x20, 0x8B, 0x08, 0xE0, 0xE0, 0x32, 0x08, 0xB8, 0x64,
  0x29, 0xDF, 0xD9, 0x13, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0, 0x47, 0x30, 0x8B,
  0x04, 0x73, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73,
  // "q" (U+0071)
  0x28, 0x71, 0x8D, 0xFE, 0xA4, 0x06, 0xA8, 0x2B, 0x01, 0xDE, 0x08, 0x0A, 0xA8, 0x1B, 0x0B, 0xFC,
  0x0B, 0x03, 0xC8, 0x2A, 0x33, 0x8C, 0x0B, 0x08, 0xB0, 0xC4, 0x09, 0xB0, 0x0B, 0xB0, 0x64, 0x02,
  0xB0, 0xB0, 0xDB, 0x03, 0x5B, 0x0B, 0x0E, 0xB0, 0x25, 0x0E, 0xA0, 0xB0, 0xDB, 0x02, 0x5B, 0x00,
  0xBB, 0x05, 0x40, 0x2B, 0x0B, 0x08, 0xB0, 0xB4, 0x08, 0xB0, 0xB0, 0x4C, 0x82, 0x93, 0x37, 0xC8,
  0x1B, 0x0C, 0xFC, 0x82, 0xB0, 0x2E, 0xE0, 0x5B, 0x0B, 0x28, 0x61, 0x9D, 0xFD, 0xA3, 0x1B, 0x0B,
  0x72, 0x01, 0xB0, 0xB7, 0x20, 0x1B, 0x0B, 0x72, 0x01, 0xB0, 0xB7, 0x20, 0x1B, 0x0B, 0x72, 0x01,
  0xB0, 0xB7, 0x20, 0x1B, 0x0B,
  // "r" (U+0072)
  0x02, 0xE2, 0x85, 0x5B, 0xEF, 0xE8, 0x2E, 0x04, 0x09, 0xD8, 0x35, 0x19, 0xBD, 0xB0, 0xEE, 0x40,
  0x1D, 0x83, 0xB4, 0x24, 0x54, 0x01, 0xC0, 0xB7, 0x20, 0x1C, 0x03, 0x72, 0x01, 0xC7, 0x30, 0x1B,
  0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x20, 0x10, 0x5B, 0x0E,
  0x03, 0x60, 0x80, 0xDF, 0x90, 0xC0, 0x73, 0x0D, 0xFB, 0x0B, 0x30, 0xDF, 0xB0, 0xB3,
  // "s" (U+0073)
  0x28, 0x73, 0x9D, 0xEF, 0xEC, 0x95, 0x20, 0x9F, 0xA0, 0xC0, 0x5F, 0xB0, 0x70, 0x9B, 0x87, 0xA3,
  0x34, 0x6B, 0xE1, 0xAB, 0x06, 0x70, 0x8C, 0x0A, 0x04, 0x50, 0x10, 0xDD, 0x81, 0xD7, 0x13, 0x01,
  0x0A, 0xF0, 0x64, 0x81, 0x29, 0xED, 0x06, 0x60, 0x50, 0xDB, 0x0D, 0x02, 0x60, 0x1C, 0x86, 0xDD,
  0x95, 0x32, 0x38, 0xB0, 0xE0, 0xDF, 0xB0, 0xA0, 0xDF, 0xA8, 0x92, 0xC1, 0x48, 0xCD, 0xEF, 0xED,
  0xA5, 0x20,
  // "t" (U+0074)
  0x48, 0x22, 0x77, 0x57, 0x30, 0x6A, 0x0B, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0xCA, 0x0B, 0x68, 0x22,
  0x69, 0xDF, 0xA0, 0x30, 0x8F, 0xD0, 0x30, 0x8F, 0xD8, 0x33, 0x12, 0x24, 0xB0, 0xB8, 0x01, 0x24,
  0x02, 0xB0, 0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x02, 0xB0, 0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x02, 0xB0,
  0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x01, 0xB0, 0xD7, 0x30, 0xEB, 0x84, 0xA4, 0x24, 0x63, 0x40, 0x9F,
  0x90, 0x64, 0x01, 0x0D, 0xF0, 0x66, 0x86, 0x7C, 0xEF, 0xED, 0x92,
  // "u" (U+0075)
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0,
  0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04,
  0xB0, 0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x09, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0x6C, 0x82, 0x73,
  0x4B, 0xC0, 0xB0, 0x1F, 0xD8, 0x1B, 0x06, 0xF0, 0x60, 0xBA, 0x0B, 0x28, 0x74, 0xBE, 0xFD, 0x93,
  0x06, 0xA0, 0xB0,
  // "v" (U+0076)
  0x04, 0xB0, 0xD6, 0x09, 0xB8, 0x17, 0x0D, 0xB0, 0x35, 0x0E, 0xB8, 0x11, 0x08, 0xB0, 0x84, 0x03,
  0xB0, 0xB2, 0x02, 0xB0, 0xD4, 0x08, 0xB0, 0x53, 0x0C, 0xB0, 0x23, 0x0D, 0xA0, 0xE4, 0x07, 0xB0,
  0x72, 0x02, 0xB0, 0x94, 0x01, 0xB0, 0xC2, 0x07, 0xB0, 0x45, 0x0B, 0xB8, 0x11, 0x0C, 0xA0, 0xD6,
  0x05, 0xB0, 0x60, 0x1B, 0x08, 0x70, 0xEA, 0x0A, 0x05, 0xB0, 0x27, 0x09, 0xA0, 0xE0, 0x9A, 0x0C,
  0x71, 0x04, 0xB0, 0xDA, 0x06, 0x72, 0x0D, 0xD0, 0x17, 0x20, 0x8C, 0x0A, 0x73, 0x02, 0xC0, 0x55,
  // "w" (U+0077)
  0x0D, 0xA0, 0xA7, 0x10, 0x6B, 0x01, 0x0B, 0xA0, 0xB7, 0x10, 0x7A, 0x81, 0xE0, 0x9A, 0x0D, 0x20,
  0xAA, 0x0D, 0x20, 0x9A, 0x81, 0xC0, 0x6A, 0x0E, 0x20, 0xDB, 0x81, 0x10, 0xAA, 0x81, 0xA0, 0x4B,
  0x2C, 0x81, 0x40, 0xBA, 0x81, 0x80, 0x2B, 0x01, 0x03, 0xC8, 0x17, 0x0D, 0xA0, 0x52, 0xB0, 0x30,
  0x6A, 0x83, 0xDF, 0xA0, 0xEA, 0x03, 0x20, 0xDA, 0x85, 0x49, 0xFD, 0xAF, 0xD1, 0xB0, 0x12, 0x0B,
  0xA8, 0x36, 0xCF, 0xB7, 0xA0, 0x2A, 0x0E, 0x30, 0x9A, 0x83, 0x7E, 0xF8, 0x5A, 0x05, 0xA0, 0xC3,
  0x07, 0xA0, 0xAA, 0x05, 0x02, 0xA0, 0x9A, 0x0A, 0x30, 0x5A, 0x0E, 0xA0, 0x21, 0xA0, 0xEA, 0x08,
  0x30, 0x3D, 0x20, 0xCC, 0x06, 0x4C, 0x0C, 0x20, 0xAC, 0x04, 0x40, 0xEB, 0x0A, 0x20, 0x7C, 0x02,
  0x20,
  // "x" (U+0078)
  0x10, 0xDB, 0x0B, 0x40, 0x5C, 0x81, 0x40, 0x3C, 0x05, 0x30, 0xDB, 0x09, 0x30, 0x8B, 0x0D, 0x20,
  0x7B, 0x0D, 0x50, 0xCB, 0x07, 0x02, 0xC0, 0x35, 0x03, 0xB0, 0xE0, 0xBB, 0x08, 0x70, 0x8E, 0x0D,
  0x72, 0x0C, 0xD0, 0x37, 0x20, 0x6C, 0x0B, 0x72, 0x01, 0x0E, 0xD0, 0x57, 0x10, 0xAE, 0x0E, 0x01,
  0x60, 0x5B, 0x0D, 0x09, 0xB0, 0xA5, 0x01, 0x0E, 0xB8, 0x15, 0x1E, 0xB0, 0x54, 0x0B, 0xB0, 0xB2,
  0x06, 0xB0, 0xE0, 0x12, 0x06, 0xC0, 0x23, 0x0D, 0xB8, 0x2A, 0x02, 0xEB, 0x08, 0x40, 0x4C, 0x05,
  // "y" (U+0079)
  0x04, 0xB0, 0xE6, 0x0A, 0xB8, 0x17, 0x0D, 0xB0, 0x45, 0x0E, 0xB8, 0x11, 0x07, 0xB0, 0x94, 0x04,
  0xB0, 0xB2, 0x01, 0xB0, 0xE4, 0x09, 0xB0, 0x53, 0x0A, 0xB0, 0x43, 0x0D, 0xA0, 0xE4, 0x04, 0xB0,
  0x92, 0x02, 0xB0, 0x95, 0x0D, 0xA0, 0xE2, 0x07, 0xB0, 0x35, 0x07, 0xB8, 0x14, 0x0C, 0xA0, 0xD6,
  0x01, 0xB0, 0x90, 0x1B, 0x07, 0x70, 0xAA, 0x0E, 0x05, 0xB0, 0x27, 0x04, 0xB0, 0xAA, 0x0C, 0x72,
  0x0D, 0xD0, 0x67, 0x20, 0x7D, 0x01, 0x72, 0x01, 0xC0, 0xA7, 0x40, 0xBB, 0x04, 0x74, 0x0E, 0xA0,
  0xD7, 0x40, 0x8B, 0x07, 0x78, 0x21, 0x23, 0x8B, 0x0E, 0x01, 0x70, 0x6E, 0x05, 0x71, 0x06, 0xD0,
  0x77, 0x28, 0x45, 0xEF, 0xEA, 0x37, 0x20,
  // "z" (U+007A)
  0x10, 0xDF, 0xC8, 0x13, 0x0D, 0xFC, 0x81, 0x30, 0xDF, 0xC0, 0x21, 0x80, 0x22, 0x04, 0x0E, 0xB0,
  0x87, 0x10, 0xCB, 0x0B, 0x71, 0x09, 0xB0, 0xD0, 0x17, 0x06, 0xB0, 0xE0, 0x27, 0x03, 0xC0, 0x47,
  0x01, 0x0D, 0xB0, 0x77, 0x10, 0xBB, 0x0A, 0x71, 0x09, 0xB0, 0xC7, 0x10, 0x5B, 0x0E, 0x04, 0x80,
  0x22, 0x01, 0x02, 0xFD, 0x06, 0x03, 0xFD, 0x06, 0x03, 0xFD, 0x06,
  // "{" (U+007B)
  0x58, 0x34, 0xAD, 0xF7, 0x40, 0x7C, 0x07, 0x40, 0xEC, 0x07, 0x30, 0x2B, 0x81, 0xC4, 0x13, 0x03,
  0xB0, 0x35, 0x03, 0xB0, 0x25, 0x03, 0xB0, 0x25, 0x03, 0xB0, 0x25, 0x04, 0xB0, 0x25, 0x08, 0xB0,
  0x13, 0x03, 0x08, 0xB0, 0xD3, 0x04, 0xC0, 0xE0, 0x33, 0x04, 0xB0, 0xC0, 0x34, 0x04, 0xD0, 0x64,
  0x81, 0x15, 0xEA, 0x0E, 0x60, 0x6B, 0x02, 0x50, 0x4B, 0x02, 0x50, 0x3B, 0x02, 0x50, 0x3B, 0x02,
  0x50, 0x3B, 0x03, 0x50, 0x3B, 0x0A, 0x01, 0x40, 0x1D, 0x07, 0x40, 0xAC, 0x07, 0x50, 0x80, 0xDA,
  0x07, 0x71, 0x00, 0x10,
  // "|" (U+007C)
  0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06,
  0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0,
  0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90,
  0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A,
  0x09, 0x06, 0xA0, 0x90,
  // "}" (U+007D)
  0x00, 0x17, 0x10, 0x7A, 0x0D, 0x07, 0x50, 0x7C, 0x0A, 0x40, 0x7D, 0x01, 0x40, 0x10, 0xAB, 0x03,
  0x50, 0x3B, 0x03, 0x50, 0x2B, 0x03, 0x50, 0x2B, 0x03, 0x50, 0x2B, 0x04, 0x50, 0x2B, 0x06, 0x6B,
  0x81, 0xE5, 0x14, 0x06, 0xD0, 0x44, 0x03, 0x0C, 0xB0, 0x43, 0x03, 0x0E, 0xC0, 0x43, 0x0D, 0xB0,
  0x80, 0x33, 0x01, 0xB0, 0x85, 0x02, 0xB0, 0x45, 0x02, 0xB0, 0x35, 0x02, 0xB0, 0x35, 0x02, 0xB0,
  0x35, 0x03, 0xB0, 0x33, 0x81, 0x14, 0xCB, 0x02, 0x30, 0x7C, 0x0E, 0x40, 0x7C, 0x07, 0x48, 0x37,
  0xFD, 0xA4, 0x50,
  // "~" (U+007E)
  0x28, 0x36, 0xDF, 0xC4, 0x48, 0x3A, 0xF4, 0x06, 0xD0, 0x73, 0x87, 0xDF, 0x30, 0xDF, 0x60, 0x7A,
  0x87, 0x91, 0x4F, 0xE0, 0x1F, 0xE3, 0x05, 0x0E, 0xC8, 0x38, 0x02, 0xFC, 0x48, 0x32, 0xAE, 0xE8,
  0x20,
  // "¡" (U+00A1)
  0x18, 0x48, 0xEE, 0x60, 0x5C, 0x02, 0x07, 0xC0, 0x05, 0xC8, 0x42, 0x09, 0xEE, 0x77, 0x10, 0xDA,
  0x09, 0x20, 0xDA, 0x0A, 0x20, 0xEA, 0x0A, 0x2B, 0x0B, 0x2B, 0x81, 0xC0, 0x1B, 0x81, 0xD0, 0x1B,
  0x81, 0xD0, 0x2B, 0x81, 0xE0, 0x3C, 0x10, 0x3C, 0x10, 0x4C, 0x10, 0x5C, 0x01, 0x05, 0xC0, 0x20,
  // "¢" (U+00A2)
  0x78, 0x1E, 0xF3, 0x74, 0x81, 0xEF, 0x37, 0x18, 0x12, 0x8C, 0xA8, 0x2E, 0xCA, 0x64, 0x09, 0xFA,
  0x01, 0x20, 0xAF, 0xA0, 0xB2, 0x04, 0xB8, 0x6E, 0x72, 0x01, 0x38, 0x52, 0x0A, 0xB0, 0x47, 0x20,
  0xEA, 0x0C, 0x73, 0xB0, 0xA7, 0x20, 0x1B, 0x09, 0x73, 0xB0, 0xC7, 0x30, 0xCB, 0x03, 0x72, 0x07,
  0xB8, 0x6E, 0x72, 0x01, 0x36, 0xB2, 0x01, 0x0E, 0xFA, 0x0E, 0x30, 0x30, 0xEF, 0x90, 0xE4, 0x81,
  0x19, 0xED, 0x0E, 0x07, 0x78, 0x32, 0xEF, 0x72, 0x73, 0x81, 0xEF, 0x37, 0x48, 0x1E, 0xF3, 0x40,
  // "£" (U+00A3)
  0x48, 0x63, 0x9D, 0xFE, 0xD9, 0x34, 0x06, 0xF9, 0x02, 0x20, 0x2F, 0x90, 0xC3, 0x08, 0xB8, 0x4C,
  0x43, 0x5A, 0x63, 0x0B, 0xB0, 0x27, 0x10, 0xBB, 0x72, 0x0B, 0xB7, 0x81, 0x22, 0xCB, 0x80, 0x02,
  0x01, 0x20, 0xDF, 0xA0, 0x62, 0x0D, 0xFA, 0x06, 0x20, 0xDF, 0xA0, 0x64, 0x0B, 0xB7, 0x20, 0xBB,
  0x72, 0x0D, 0xA0, 0xE7, 0x10, 0x2B, 0x08, 0x70, 0x20, 0xDA, 0x0B, 0x80, 0x32, 0x01, 0x0C, 0xFC,
  0x09, 0x0C, 0xFC, 0x09, 0x0C, 0xFC, 0x09,
  // "¤" (U+00A4)
  0x18, 0x12, 0xC2, 0x20, 0x01, 0x28, 0x90, 0x1C, 0x40, 0x1D, 0xFD, 0x6D, 0xA8, 0x1D, 0x6C, 0xA8,
  0x13, 0x0C, 0xFB, 0x83, 0xD1, 0x01, 0xDF, 0x90, 0xE0, 0x23, 0x0D, 0xA8, 0x67, 0x11, 0x5E, 0xFE,
  0x12, 0x03, 0xA0, 0x94, 0x06, 0xA0, 0x62, 0x05, 0xA0, 0x64, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0xA4,
  0x07, 0xA0, 0x63, 0x0C, 0xA8, 0x29, 0x33, 0x7A, 0x0E, 0x01, 0x20, 0x10, 0xDF, 0x98, 0x3E, 0x30,
  0x1D, 0xFB, 0x8A, 0x2D, 0x11, 0xCF, 0xC4, 0xBE, 0xEC, 0x6C, 0xFD, 0x10, 0x1A, 0x17, 0x0A, 0x02,
  0x10,
  // "¥" (U+00A5)
  0x01, 0xB0, 0xD6, 0x0A, 0xB8, 0x14, 0x09, 0xB0, 0x44, 0x01, 0xB0, 0xB2, 0x01, 0xB0, 0xB4, 0x08,
  0xB0, 0x43, 0x09, 0xB0, 0x23, 0x0E, 0xA0, 0xB4, 0x01, 0xB0, 0x92, 0x06, 0xB0, 0x45, 0x09, 0xB8,
  0x11, 0x0D, 0xA0, 0xB6, 0x01, 0xB0, 0x70, 0x5B, 0x03, 0x70, 0x9A, 0x0E, 0x0C, 0xA0, 0xB7, 0x10,
  0x1E, 0x03, 0x68, 0x21, 0x22, 0xAC, 0x0C, 0x0F, 0x24, 0x09, 0xFB, 0x0C, 0x40, 0x9F, 0xB0, 0xC7,
  0x10, 0xBA, 0x0E, 0x71, 0x83, 0x12, 0x22, 0xCA, 0x0E, 0x80, 0x02, 0x40, 0x9F, 0xB0, 0xC4, 0x09,
  0xFB, 0x0C, 0x71, 0x0B, 0xA0, 0xE7, 0x50, 0xBA, 0x0E, 0x75, 0x0B, 0xA0, 0xE6,
  // "¦" (U+00A6)
  0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06,
  0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x97, 0x76, 0x06, 0xA0, 0x90,
  0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90, 0x6A,
  0x09, 0x06, 0xA0, 0x90, 0x6A, 0x09, 0x06, 0xA0, 0x90,
  // "§" (U+00A7)
  0x38, 0x66, 0xBD, 0xFD, 0xC9, 0x42, 0x02, 0x0E, 0xF0, 0xE2, 0x0C, 0xA8, 0x5D, 0x42, 0x48, 0xE7,
  0x2B, 0x07, 0x71, 0x0D, 0xA0, 0xD0, 0x27, 0x06, 0xC0, 0x90, 0x26, 0x07, 0xD0, 0xA0, 0x13, 0x02,
  0x0D, 0xE0, 0xE0, 0x32, 0x0B, 0xA8, 0x27, 0x17, 0xEA, 0x81, 0xE1, 0x1B, 0x30, 0x3B, 0x05, 0x02,
  0xB0, 0x53, 0x0D, 0xA8, 0x16, 0x0E, 0xB8, 0x27, 0x01, 0xEA, 0x81, 0x40, 0x6C, 0x0E, 0x0D, 0xA0,
  0xC3, 0x05, 0x0E, 0xD0, 0xD0, 0x15, 0x07, 0x0E, 0xC0, 0x57, 0x07, 0xB0, 0xE7, 0x10, 0x6B, 0x81,
  0x41, 0x25, 0x03, 0xB8, 0x73, 0x3F, 0xC7, 0x32, 0x4C, 0xA8, 0x1D, 0x03, 0xF9, 0x0E, 0x03, 0x28,
  0x75, 0xAD, 0xEF, 0xEC, 0x71, 0x20,
  // "¨" (U+00A8)
  0x82, 0x5E, 0xE5, 0x28, 0x42, 0xCE, 0x90, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x0D, 0xA0, 0xD2, 0x08,
  0xB8, 0x32, 0x5E, 0xE4, 0x28, 0x21, 0xCE, 0x91,
  // "©" (U+00A9)
  0x58, 0x56, 0xAC, 0xCA, 0x71, 0x70, 0x50, 0xEF, 0x07, 0x50, 0x6A, 0x87, 0x93, 0x10, 0x28, 0xEF,
  0x93, 0x02, 0xA8, 0x91, 0x41, 0x9E, 0xFD, 0x72, 0xDF, 0x52, 0x83, 0xAF, 0x70, 0xDA, 0x85, 0xDF,
  0xA0, 0x4F, 0xD2, 0xA8, 0x61, 0x7F, 0xE2, 0x01, 0x22, 0x89, 0x0C, 0xF3, 0x2F, 0xC0, 0xBF, 0x76,
  0x89, 0x09, 0xF5, 0x4F, 0xA0, 0xCF, 0x56, 0x89, 0x07, 0xF7, 0x3F, 0xB0, 0xBF, 0x76, 0x89, 0x19,
  0xF6, 0x1F, 0xE0, 0x7F, 0xD1, 0x20, 0x12, 0x87, 0xCF, 0x40, 0xBF, 0x61, 0xDA, 0x85, 0xDE, 0xA0,
  0x3F, 0xE2, 0x89, 0x44, 0xFE, 0x21, 0x9E, 0xFD, 0x61, 0xDF, 0x73, 0x83, 0x9F, 0xE6, 0x13, 0x82,
  0x5D, 0xFB, 0x50, 0x8B, 0x0E, 0x0D, 0xB0, 0xA7, 0x86, 0x39, 0xDF, 0xED, 0x93, 0x40,
  // "ª" (U+00AA)
  0x28, 0x44, 0xAC, 0xDC, 0x73, 0x02, 0xE0, 0x93, 0x83, 0x75, 0x11, 0xAA, 0x01, 0x60, 0x4A, 0x04,
  0x28, 0x17, 0xCE, 0xC8, 0x14, 0x0B, 0xB0, 0x0E, 0xA0, 0x40, 0x1A, 0x0B, 0x20, 0x4A, 0x04, 0x01,
  0xA8, 0x29, 0x01, 0xBA, 0x81, 0x40, 0xCA, 0x89, 0x6E, 0xFE, 0xDF, 0x40, 0x1A, 0xEE, 0xA2, 0x8F,
  0x40,
  // "«" (U+00AB)
  0x50, 0x44, 0x00, 0x26, 0x82, 0xAF, 0xB3, 0x28, 0x2D, 0xF9, 0x13, 0x06, 0xB8, 0x16, 0x09, 0xB0,
  0x32, 0x03, 0xB8, 0x1B, 0x06, 0xB0, 0x73, 0x0D, 0xA8, 0x1E, 0x13, 0xB0, 0xC3, 0x0A, 0xB8, 0x15,
  0x0D, 0xA0, 0xE0, 0x22, 0x04, 0xB8, 0x1B, 0x08, 0xB0, 0x84, 0x0C, 0xB8, 0x13, 0x2E, 0xA0, 0xD0,
  0x13, 0x02, 0x0E, 0xA8, 0x1D, 0x05, 0xB0, 0xA4, 0x05, 0xB8, 0x18, 0x08, 0xB0, 0x54, 0x08, 0xB8,
  0x14, 0x0C, 0xA0, 0xE0, 0x14, 0x89, 0x0C, 0xFE, 0x50, 0x1E, 0xFC, 0x34, 0x01, 0x07, 0x40, 0x40,
  0x52,
  // "¬" (U+00AC)
  0x18, 0x09, 0x02, 0x01, 0xFD, 0x01, 0xFD, 0x01, 0xFD, 0x73, 0x0D, 0xA7, 0x30, 0xDA, 0x73, 0x0D,
  0xA7, 0x30, 0xDA, 0x73, 0x0C, 0xA0,
  // "®" (U+00AE)
  0x58, 0x56, 0xAC, 0xCA, 0x71, 0x70, 0x50, 0xEF, 0x07, 0x50, 0x6A, 0x87, 0x93, 0x10, 0x28, 0xEF,
  0x83, 0x02, 0xA8, 0x91, 0x5A, 0xDD, 0xB9, 0x12, 0xEF, 0x42, 0x83, 0x9F, 0x80, 0xCC, 0x83, 0xD0,
  0x4F, 0xC2, 0x86, 0xEF, 0x10, 0xCF, 0x12, 0xA8, 0x61, 0x0C, 0xF2, 0x2F, 0xC2, 0x82, 0xCF, 0x12,
  0xA2, 0x84, 0x9F, 0x53, 0xFB, 0x20, 0xCC, 0x05, 0x28, 0x48, 0xF6, 0x2F, 0xC2, 0x84, 0xCF, 0x4C,
  0xF2, 0x28, 0x49, 0xF5, 0x0F, 0xE2, 0x84, 0xCF, 0x16, 0xF8, 0x28, 0xA0, 0xCF, 0x30, 0xAF, 0x60,
  0xCF, 0x11, 0xFE, 0x03, 0xFE, 0x28, 0x94, 0x3F, 0xE2, 0x89, 0x10, 0x79, 0x4D, 0xF7, 0x38, 0x38,
  0xFE, 0x61, 0x38, 0x25, 0xDF, 0xB5, 0x08, 0xB0, 0xE0, 0xDB, 0x0A, 0x78, 0x63, 0x9D, 0xFE, 0xD9,
  0x44,
  // "¯" (U+00AF)
  0x80, 0x42, 0x1F, 0x90, 0x3F, 0x90, 0x3F, 0x90, 0x30,
  // "°" (U+00B0)
  0x40, 0x01, 0x60, 0x40, 0xCA, 0x0D, 0x06, 0x30, 0x4E, 0x08, 0x28, 0x4D, 0xFC, 0x21, 0xAA, 0x00,
  0x2A, 0x04, 0x20, 0x1A, 0x05, 0x01, 0xA0, 0x52, 0x02, 0xA8, 0x65, 0x0D, 0xFD, 0x43, 0xBA, 0x81,
  0x10, 0x3E, 0x07, 0x38, 0x43, 0xAE, 0xEC, 0x52,
  // "±" (U+00B1)
  0x50, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x96, 0x80, 0x02,
  0x06, 0xA8, 0x59, 0x22, 0x22, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x50, 0x4A,
  0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x73, 0x04, 0xA0, 0x97, 0x30, 0x4A, 0x09, 0x68,
  0x09, 0x02, 0x10, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x40,
  // "²" (U+00B2)
  0x18, 0x45, 0xBE, 0xEC, 0x52, 0x0A, 0xE8, 0x55, 0x04, 0xF9, 0x47, 0xA0, 0xB2, 0x03, 0x38, 0x1E,
  0xFD, 0x50, 0x1A, 0x0B, 0x50, 0xAA, 0x05, 0x40, 0x8A, 0x0A, 0x40, 0x7A, 0x0B, 0x40, 0x7A, 0x0B,
  0x40, 0x7A, 0x85, 0xD4, 0x44, 0x41, 0xDF, 0x06, 0x0D, 0xF0, 0x60,
  // "³" (U+00B3)
  0x18, 0x46, 0xCE, 0xEC, 0x42, 0x0A, 0xE8, 0x55, 0x03, 0xE8, 0x57, 0xA0, 0xB6, 0x81, 0xDF, 0xA3,
  0x81, 0x44, 0x9A, 0x04, 0x3B, 0x0E, 0x03, 0x4C, 0x0E, 0x03, 0x58, 0x43, 0xDF, 0xD0, 0x14, 0x09,
  0xA8, 0x51, 0xDA, 0x54, 0x6E, 0xA1, 0x0D, 0xE8, 0x78, 0x04, 0xAD, 0xFE, 0xB5, 0x20,
  // "´" (U+00B4)
  0x20, 0x38, 0x00, 0x72, 0x0D, 0xB8, 0x15, 0x08, 0xB8, 0x15, 0x03, 0xB0, 0x52, 0x82, 0xDF, 0xE3,
  0x30,
  // "µ" (U+00B5)
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0,
  0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04,
  0xB0, 0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x0A, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0xAC, 0x82, 0x73,
  0x4B, 0xC0, 0xB0, 0xAF, 0xD0, 0xB0, 0xAF, 0x90, 0x60, 0xBA, 0x0B, 0x0A, 0xD8, 0x3D, 0x93, 0x06,
  0xA0, 0xB0, 0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20, 0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20,
  0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20,
  // "¶" (U+00B6)
  0x28, 0x21, 0x7C, 0xEF, 0x82, 0xD0, 0x3E, 0xFB, 0x81, 0xD1, 0xEF, 0x84, 0xD2, 0x5F, 0xD6, 0xF9,
  0x84, 0xD0, 0x3F, 0xDB, 0xF9, 0x84, 0xD0, 0x3F, 0xDD, 0xF9, 0x84, 0xD0, 0x3F, 0xDE, 0xF9, 0x84,
  0xD0, 0x3F, 0xDD, 0xF9, 0x84, 0xD0, 0x3F, 0xDC, 0xF9, 0x84, 0xD0, 0x3F, 0xD8, 0xF9, 0x84, 0xD0,
  0x3F, 0xD2, 0xF9, 0x85, 0xD0, 0x3F, 0xD0, 0x7F, 0x83, 0xD0, 0x3F, 0xD2, 0x04, 0x0C, 0xD8, 0x3D,
  0x03, 0xFD, 0x58, 0x72, 0x23, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD,
  0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03,
  0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x53, 0xFD, 0x03, 0xFD,
  0x78, 0x53, 0xFD, 0x03, 0xFD, 0x78, 0x52, 0x98, 0x02, 0x98,
  // "·" (U+00B7)
  0x18, 0x47, 0xEE, 0x90, 0x2C, 0x00, 0x5C, 0x07, 0x02, 0xC8, 0x44, 0x06, 0xEE, 0x81,
  // "¸" (U+00B8)
  0x20, 0x07, 0x38, 0x23, 0xFE, 0x22, 0x08, 0xB0, 0x52, 0x86, 0x1D, 0xFE, 0x10, 0x2E, 0xA0, 0x9C,
  0x85, 0xA8, 0xEF, 0xE9, 0x10,
  // "¹" (U+00B9)
  0x28, 0x21, 0xBF, 0xE4, 0x05, 0x0E, 0xA0, 0xE3, 0x0A, 0xC0, 0xE3, 0x84, 0x9F, 0xBB, 0xFE, 0x38,
  0x41, 0x60, 0xAF, 0xE6, 0x81, 0xAF, 0xE6, 0x81, 0xAF, 0xE6, 0x81, 0xAF, 0xE6, 0x81, 0xAF, 0xE6,
  0x81, 0xAF, 0xE3, 0x81, 0x4D, 0xEC, 0x81, 0xD6, 0x6F, 0x08,
  // "º" (U+00BA)
  0x28, 0x41, 0x9D, 0xD9, 0x23, 0x01, 0x0E, 0xC0, 0xE0, 0x22, 0x86, 0x9F, 0xE3, 0x2D, 0xFC, 0x28,
  0x1E, 0xFA, 0x20, 0x7A, 0x00, 0x1A, 0x08, 0x20, 0x5A, 0x03, 0x01, 0xA0, 0x82, 0x05, 0xA8, 0x33,
  0x0E, 0xF9, 0x20, 0x7A, 0x89, 0x02, 0x0A, 0xFE, 0x21, 0xDF, 0xD2, 0x02, 0x0E, 0xD0, 0x43, 0x84,
  0x2A, 0xEE, 0xB3, 0x20,
  // "»" (U+00BB)
  0x20, 0x50, 0x44, 0x07, 0x01, 0x48, 0x90, 0x3C, 0xFE, 0x10, 0x5E, 0xFC, 0x40, 0x10, 0xEA, 0x81,
  0xC0, 0x4B, 0x08, 0x40, 0x5B, 0x81, 0x80, 0x9B, 0x05, 0x40, 0xAB, 0x81, 0x40, 0xDA, 0x0E, 0x02,
  0x30, 0x10, 0xEA, 0x81, 0xE2, 0x3B, 0x0C, 0x40, 0x8B, 0x81, 0x80, 0xBB, 0x04, 0x20, 0x20, 0xEA,
  0x81, 0xD0, 0x5B, 0x0A, 0x30, 0xCB, 0x81, 0x31, 0xEA, 0x0D, 0x30, 0x7B, 0x81, 0x60, 0xBB, 0x03,
  0x20, 0x3B, 0x81, 0x90, 0x6B, 0x06, 0x38, 0x21, 0x9F, 0xD2, 0x82, 0x3B, 0xFA, 0x60, 0x02, 0x40,
  0x45,
  // "¼" (U+00BC)
  0x20, 0x8A, 0x01, 0x73, 0x05, 0x0E, 0xB0, 0x17, 0x38, 0x15, 0xFB, 0xA0, 0x16, 0x81, 0x56, 0x62,
  0x05, 0x1A, 0x01, 0x50, 0x5A, 0x09, 0x4A, 0x01, 0x48, 0x22, 0xEF, 0xD4, 0x01, 0xA0, 0x14, 0x0C,
  0xA0, 0x24, 0x01, 0xA0, 0x13, 0x08, 0xA0, 0x63, 0x81, 0x1A, 0xCA, 0x82, 0xCA, 0x14, 0xA0, 0xA4,
  0x02, 0xE8, 0x33, 0xEF, 0xD1, 0x74, 0x0B, 0xA0, 0x37, 0x40, 0x7A, 0x84, 0x70, 0x4B, 0xB2, 0x60,
  0x3A, 0x0B, 0x20, 0xDA, 0x03, 0x58, 0x51, 0xDF, 0xE1, 0x08, 0xB0, 0x35, 0x0A, 0xA8, 0x34, 0x03,
  0xFA, 0xA0, 0x34, 0x06, 0xA0, 0x82, 0x81, 0xCE, 0x1A, 0x03, 0x30, 0x2A, 0x0C, 0x28, 0x16, 0xF7,
  0x1A, 0x03, 0x38, 0x2D, 0xFE, 0x22, 0x82, 0xDF, 0xCC, 0xA8, 0x5D, 0x70, 0x5A, 0xA5, 0x30, 0xEE,
  0x09, 0x75, 0xA0, 0x37, 0x68, 0x17, 0x71, 0x10,
  // "½" (U+00BD)
  0x20, 0x8A, 0x01, 0x73, 0x05, 0x0E, 0xB0, 0x17, 0x38, 0x15, 0xFB, 0xA0, 0x16, 0x81, 0x56, 0x62,
  0x05, 0x1A, 0x01, 0x50, 0x5A, 0x09, 0x4A, 0x01, 0x48, 0x22, 0xEF, 0xC4, 0x01, 0xA0, 0x14, 0x82,
  0xDF, 0xE2, 0x40, 0x1A, 0x01, 0x30, 0xAA, 0x04, 0x38, 0x11, 0xAC, 0xA8, 0x2C, 0xA1, 0x7A, 0x08,
  0x40, 0x2E, 0x05, 0xA0, 0xB7, 0x48, 0x31, 0xDF, 0xD1, 0x74, 0x0B, 0xA8, 0x44, 0x8D, 0xFD, 0x56,
  0x08, 0xA0, 0x70, 0x8A, 0x0E, 0xA0, 0x24, 0x04, 0xA0, 0xA2, 0x84, 0x81, 0x0E, 0xF5, 0x38, 0x32,
  0xEF, 0xD1, 0x40, 0x2A, 0x03, 0x30, 0xCA, 0x03, 0x48, 0x21, 0xDF, 0x93, 0x09, 0xA0, 0x64, 0x82,
  0x2D, 0xFA, 0x30, 0x5A, 0x09, 0x48, 0x22, 0xDF, 0x97, 0x50, 0xAD, 0x0B, 0x72, 0x0B, 0xD0, 0xB0,
  // "¾" (U+00BE)
  0x84, 0x18, 0xBB, 0x81, 0x72, 0x0D, 0xC0, 0xB7, 0x28, 0x24, 0x61, 0x5A, 0x75, 0x81, 0x6F, 0xD4,
  0x82, 0x1D, 0xEC, 0x20, 0x9A, 0x0E, 0x03, 0x40, 0xBA, 0x03, 0x20, 0x70, 0xDA, 0x0B, 0x30, 0x8A,
  0x06, 0x50, 0x1A, 0x81, 0x30, 0x4A, 0x0A, 0x38, 0x28, 0x20, 0x3A, 0x83, 0x31, 0xEF, 0xD4, 0xD8,
  0x1C, 0x0C, 0xA0, 0x34, 0x85, 0x7C, 0xDC, 0x91, 0x8A, 0x06, 0x73, 0x05, 0xA0, 0xA2, 0x00, 0x16,
  0x82, 0x2E, 0xFD, 0x20, 0x9A, 0x03, 0x50, 0xCA, 0x81, 0x20, 0x4B, 0x03, 0x40, 0x9A, 0x83, 0x60,
  0x1D, 0xDA, 0x03, 0x30, 0x5A, 0x09, 0x28, 0x1A, 0xF3, 0xA0, 0x32, 0x82, 0x2E, 0xFD, 0x28, 0x15,
  0xF8, 0x1A, 0x03, 0x28, 0x2C, 0xFE, 0x22, 0x82, 0xDF, 0xCC, 0xA8, 0x4D, 0x75, 0xAA, 0x53, 0x0E,
  0xE0, 0x97, 0x4A, 0x03, 0x75, 0x81, 0x77, 0x11,
  // "¿" (U+00BF)
  0x48, 0x31, 0xBE, 0xC3, 0x70, 0x9B, 0x0D, 0x70, 0xBC, 0x70, 0x9B, 0x0E, 0x78, 0x31, 0xBE, 0xD4,
  0x77, 0x60, 0xF3, 0x01, 0x70, 0x1B, 0x06, 0x70, 0x5B, 0x04, 0x60, 0x50, 0xEA, 0x0E, 0x60, 0x9B,
  0x0E, 0x03, 0x50, 0xCB, 0x0B, 0x01, 0x50, 0x9B, 0x09, 0x70, 0xEA, 0x0E, 0x71, 0xB0, 0xC5, 0x82,
  0x12, 0x0E, 0xB8, 0x78, 0x33, 0x59, 0xED, 0x08, 0xFB, 0x81, 0x60, 0xBF, 0x90, 0xE0, 0x72, 0x86,
  0x5A, 0xDF, 0xED, 0xA5, 0x20,
  // "À" (U+00C0)
  0x30, 0x28, 0x00, 0x77, 0x50, 0xAB, 0x08, 0x75, 0x0A, 0xB0, 0x27, 0x50, 0xAA, 0x0C, 0x76, 0x08,
  0xA0, 0x78, 0x0C, 0x60, 0x08, 0xC0, 0xB7, 0x30, 0xCD, 0x72, 0x01, 0xE0, 0x47, 0x10, 0x6A, 0x0E,
  0x0C, 0xA0, 0x87, 0x10, 0xAA, 0x0B, 0x08, 0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x04, 0xB0, 0x26, 0x03,
  0xB0, 0x31, 0xB0, 0x66, 0x07, 0xA0, 0xE2, 0x0C, 0xA0, 0xA6, 0x0C, 0xA0, 0xB2, 0x08, 0xA0, 0xE5,
  0x01, 0xB0, 0x72, 0x04, 0xB0, 0x34, 0x05, 0xB0, 0x33, 0xB0, 0x84, 0x09, 0xFB, 0x0C, 0x40, 0xEF,
  0xC0, 0x12, 0x03, 0xFD, 0x05, 0x20, 0x7B, 0x84, 0x42, 0x22, 0x23, 0xB0, 0xA2, 0x0B, 0xA0, 0xE6,
  0x0C, 0xA0, 0xE2, 0xB0, 0xA6, 0x09, 0xB0, 0x30, 0x4B, 0x06, 0x60, 0x5B, 0x07, 0x09, 0xB0, 0x36,
  0x01, 0xB0, 0xC0,
  // "Á" (U+00C1)
  0x71, 0x03, 0x80, 0x07, 0x74, 0x0D, 0xB0, 0x57, 0x30, 0x8B, 0x05, 0x73, 0x03, 0xB0, 0x57, 0x48,
  0x2D, 0xFE, 0x38, 0x0C, 0x70, 0x08, 0xC0, 0xB7, 0x30, 0xCD, 0x72, 0x01, 0xE0, 0x47, 0x10, 0x6A,
  0x0E, 0x0C, 0xA0, 0x87, 0x10, 0xAA, 0x0B, 0x08, 0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x04, 0xB0, 0x26,
  0x03, 0xB0, 0x31, 0xB0, 0x66, 0x07, 0xA0, 0xE2, 0x0C, 0xA0, 0xA6, 0x0C, 0xA0, 0xB2, 0x08, 0xA0,
  0xE5, 0x01, 0xB0, 0x72, 0x04, 0xB0, 0x34, 0x05, 0xB0, 0x33, 0xB0, 0x84, 0x09, 0xFB, 0x0C, 0x40,
  0xEF, 0xC0, 0x12, 0x03, 0xFD, 0x05, 0x20, 0x7B, 0x84, 0x42, 0x22, 0x23, 0xB0, 0xA2, 0x0B, 0xA0,
  0xE6, 0x0C, 0xA0, 0xE2, 0xB0, 0xA6, 0x09, 0xB0, 0x30, 0x4B, 0x06, 0x60, 0x5B, 0x07, 0x09, 0xB0,
  0x36, 0x01, 0xB0, 0xC0,
  // "Â" (U+00C2)
  0x68, 0x00, 0x70, 0x27, 0x30, 0x6C, 0x0C, 0x72, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x71, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x36, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE8, 0x0C, 0x40, 0x08, 0xC0, 0xB7,
  0x30, 0xCD, 0x72, 0x01, 0xE0, 0x47, 0x10, 0x6A, 0x0E, 0x0C, 0xA0, 0x87, 0x10, 0xAA, 0x0B, 0x08,
  0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x04, 0xB0, 0x26, 0x03, 0xB0, 0x31, 0xB0, 0x66, 0x07, 0xA0, 0xE2,
  0x0C, 0xA0, 0xA6, 0x0C, 0xA0, 0xB2, 0x08, 0xA0, 0xE5, 0x01, 0xB0, 0x72, 0x04, 0xB0, 0x34, 0x05,
  0xB0, 0x33, 0xB0, 0x84, 0x09, 0xFB, 0x0C, 0x40, 0xEF, 0xC0, 0x12, 0x03, 0xFD, 0x05, 0x20, 0x7B,
  0x84, 0x42, 0x22, 0x23, 0xB0, 0xA2, 0x0B, 0xA0, 0xE6, 0x0C, 0xA0, 0xE2, 0xB0, 0xA6, 0x09, 0xB0,
  0x30, 0x4B, 0x06, 0x60, 0x5B, 0x07, 0x09, 0xB0, 0x36, 0x01, 0xB0, 0xC0,
  // "Ã" (U+00C3)
  0x48, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x50, 0x5D, 0x82, 0xCB, 0xFE, 0x68, 0x2B, 0xFC, 0xBD,
  0x08, 0x68, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x80, 0xC5, 0x00, 0x8C, 0x0B, 0x73, 0x0C, 0xD7, 0x20,
  0x1E, 0x04, 0x71, 0x06, 0xA0, 0xE0, 0xCA, 0x08, 0x71, 0x0A, 0xA0, 0xB0, 0x8A, 0x0D, 0x71, 0x0E,
  0xA0, 0x70, 0x4B, 0x02, 0x60, 0x3B, 0x03, 0x1B, 0x06, 0x60, 0x7A, 0x0E, 0x20, 0xCA, 0x0A, 0x60,
  0xCA, 0x0B, 0x20, 0x8A, 0x0E, 0x50, 0x1B, 0x07, 0x20, 0x4B, 0x03, 0x40, 0x5B, 0x03, 0x3B, 0x08,
  0x40, 0x9F, 0xB0, 0xC4, 0x0E, 0xFC, 0x01, 0x20, 0x3F, 0xD0, 0x52, 0x07, 0xB8, 0x44, 0x22, 0x22,
  0x3B, 0x0A, 0x20, 0xBA, 0x0E, 0x60, 0xCA, 0x0E, 0x2B, 0x0A, 0x60, 0x9B, 0x03, 0x04, 0xB0, 0x66,
  0x05, 0xB0, 0x70, 0x9B, 0x03, 0x60, 0x1B, 0x0C,
  // "Ä" (U+00C4)
  0x38, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x60, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x50, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x58, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x80, 0xC4, 0x00, 0x8C, 0x0B, 0x73,
  0x0C, 0xD7, 0x20, 0x1E, 0x04, 0x71, 0x06, 0xA0, 0xE0, 0xCA, 0x08, 0x71, 0x0A, 0xA0, 0xB0, 0x8A,
  0x0D, 0x71, 0x0E, 0xA0, 0x70, 0x4B, 0x02, 0x60, 0x3B, 0x03, 0x1B, 0x06, 0x60, 0x7A, 0x0E, 0x20,
  0xCA, 0x0A, 0x60, 0xCA, 0x0B, 0x20, 0x8A, 0x0E, 0x50, 0x1B, 0x07, 0x20, 0x4B, 0x03, 0x40, 0x5B,
  0x03, 0x3B, 0x08, 0x40, 0x9F, 0xB0, 0xC4, 0x0E, 0xFC, 0x01, 0x20, 0x3F, 0xD0, 0x52, 0x07, 0xB8,
  0x44, 0x22, 0x22, 0x3B, 0x0A, 0x20, 0xBA, 0x0E, 0x60, 0xCA, 0x0E, 0x2B, 0x0A, 0x60, 0x9B, 0x03,
  0x04, 0xB0, 0x66, 0x05, 0xB0, 0x70, 0x9B, 0x03, 0x60, 0x1B, 0x0C,
  // "Å" (U+00C5)
  0x58, 0x41, 0x9E, 0xEA, 0x17, 0x38, 0x4B, 0xFE, 0xEF, 0xC7, 0x39, 0x84, 0xE1, 0x0D, 0xF3, 0x72,
  0x90, 0xE2, 0x81, 0xDF, 0x37, 0x28, 0x4B, 0xFE, 0xEF, 0xC7, 0x38, 0x41, 0x9E, 0xEA, 0x18, 0x0C,
  0x60, 0x08, 0xC0, 0xB7, 0x30, 0xCD, 0x72, 0x01, 0xE0, 0x47, 0x10, 0x6A, 0x0E, 0x0C, 0xA0, 0x87,
  0x10, 0xAA, 0x0B, 0x08, 0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x04, 0xB0, 0x26, 0x03, 0xB0, 0x31, 0xB0,
  0x66, 0x07, 0xA0, 0xE2, 0x0C, 0xA0, 0xA6, 0x0C, 0xA0, 0xB2, 0x08, 0xA0, 0xE5, 0x01, 0xB0, 0x72,
  0x04, 0xB0, 0x34, 0x05, 0xB0, 0x33, 0xB0, 0x84, 0x09, 0xFB, 0x0C, 0x40, 0xEF, 0xC0, 0x12, 0x03,
  0xFD, 0x05, 0x20, 0x7B, 0x84, 0x42, 0x22, 0x23, 0xB0, 0xA2, 0x0B, 0xA0, 0xE6, 0x0C, 0xA0, 0xE2,
  0xB0, 0xA6, 0x09, 0xB0, 0x30, 0x4B, 0x06, 0x60, 0x5B, 0x07, 0x09, 0xB0, 0x36, 0x01, 0xB0, 0xC0,
  // "Æ" (U+00C6)
  0x40, 0x4F, 0xB0, 0x64, 0x07, 0xFB, 0x06, 0x40, 0xBF, 0xB0, 0x64, 0x0E, 0xA0, 0x60, 0xBA, 0x0A,
  0x0F, 0x24, 0x03, 0xB0, 0x10, 0xAA, 0x09, 0x70, 0x7A, 0x81, 0xD0, 0xAA, 0x09, 0x70, 0xBA, 0x81,
  0xA0, 0xAA, 0x09, 0x70, 0xEA, 0x81, 0x60, 0xAD, 0x0E, 0x30, 0x3B, 0x81, 0x30, 0xAD, 0x0E, 0x30,
  0x6B, 0x20, 0xAD, 0x0E, 0x30, 0xAA, 0x0C, 0x20, 0xAA, 0x0A, 0x0F, 0x23, 0x0E, 0xF9, 0x09, 0x50,
  0x2F, 0xA0, 0x95, 0x06, 0xFA, 0x09, 0x50, 0xAA, 0x83, 0xD2, 0x22, 0xBA, 0x09, 0x50, 0xDA, 0x0A,
  0x30, 0xAA, 0x84, 0xA2, 0x22, 0x02, 0xB0, 0x63, 0x0A, 0xE0, 0x60, 0x5B, 0x03, 0x30, 0xAE, 0x06,
  0x09, 0xB4, 0x0A, 0xE0, 0x60,
  // "Ç" (U+00C7)
  0x58, 0x74, 0x9C, 0xEF, 0xEC, 0x82, 0x30, 0x20, 0xCF, 0x90, 0xE2, 0x03, 0x0E, 0xFA, 0x82, 0x70,
  0x1E, 0xB8, 0x90, 0xD7, 0x43, 0x48, 0xE1, 0x08, 0xB0, 0xC0, 0x17, 0x10, 0xEB, 0x02, 0x71, 0x04,
  0xB0, 0xB7, 0x20, 0x7B, 0x07, 0x72, 0x09, 0xB0, 0x67, 0x20, 0x9B, 0x05, 0x72, 0x09, 0xB0, 0x57,
  0x20, 0x8B, 0x06, 0x72, 0x06, 0xB0, 0x97, 0x20, 0x2B, 0x0E, 0x73, 0x0C, 0xB0, 0x97, 0x20, 0x4C,
  0x86, 0xB5, 0x33, 0x58, 0xD5, 0x20, 0x9F, 0xB0, 0x53, 0x08, 0xFA, 0x05, 0x48, 0x12, 0x8C, 0xB8,
  0x1C, 0x95, 0x78, 0x23, 0xFE, 0x27, 0x30, 0x8B, 0x05, 0x73, 0x82, 0x1D, 0xFE, 0x71, 0x82, 0x10,
  0x2E, 0xA7, 0x10, 0x9C, 0x0A, 0x71, 0x84, 0x8E, 0xFE, 0x91, 0x30,
  // "È" (U+00C8)
  0x10, 0x28, 0x00, 0x77, 0x20, 0xAB, 0x08, 0x72, 0x0A, 0xB0, 0x27, 0x20, 0xAA, 0x0C, 0x73, 0x08,
  0xA0, 0x77, 0x77, 0x72, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8,
  0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E,
  0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20,
  0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D,
  0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  // "É" (U+00C9)
  0x60, 0x38, 0x00, 0x77, 0x10, 0xDB, 0x05, 0x70, 0x8B, 0x05, 0x70, 0x3B, 0x05, 0x71, 0x82, 0xDF,
  0xE3, 0x77, 0x77, 0x30, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDA, 0x0E, 0x80,
  0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xFB, 0x81, 0xE0,
  0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDF,
  0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // "Ê" (U+00CA)
  0x48, 0x00, 0x70, 0x27, 0x06, 0xC0, 0xC6, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x50, 0xCA, 0x81, 0x51,
  0xDA, 0x03, 0x38, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x77, 0x0D, 0xFC, 0x04, 0x0D, 0xFC,
  0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72,
  0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D, 0xA0,
  0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E,
  0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  // "Ë" (U+00CB)
  0x18, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x30, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x20, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x28, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x77, 0x0D, 0xFC, 0x04, 0x0D,
  0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E,
  0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D,
  0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA,
  0x0E, 0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  // "Ì" (U+00CC)
  0x10, 0x28, 0x00, 0x77, 0x10, 0xAB, 0x08, 0x71, 0x0A, 0xB0, 0x27, 0x10, 0xAA, 0x0C, 0x72, 0x08,
  0xA0, 0x77, 0x77, 0x60, 0x8F, 0xB0, 0xB0, 0x8F, 0xB8, 0x2B, 0x6C, 0xEE, 0x81, 0xED, 0x84, 0x0C,
  0xA0, 0xE0, 0x17, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x48, 0x16, 0xCD, 0xE8,
  0x2E, 0xC8, 0x8F, 0xB0, 0xB0, 0x8F, 0xB0, 0xB0,
  // "Í" (U+00CD)
  0x60, 0x38, 0x00, 0x77, 0x0D, 0xB0, 0x56, 0x08, 0xB0, 0x56, 0x03, 0xB0, 0x57, 0x82, 0xDF, 0xE3,
  0x77, 0x77, 0x08, 0xFB, 0x0B, 0x08, 0xFB, 0x82, 0xB6, 0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E,
  0x01, 0x70, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC,
  0x88, 0xFB, 0x0B, 0x08, 0xFB, 0x0B,
  // "Î" (U+00CE)
  0x48, 0x00, 0x70, 0x26, 0x06, 0xC0, 0xC5, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x40, 0xCA, 0x81, 0x51,
  0xDA, 0x03, 0x28, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x74, 0x08, 0xFB, 0x0B, 0x08, 0xFB,
  0x82, 0xB6, 0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E, 0x01, 0x70, 0xCA, 0x0E, 0x71, 0x0C, 0xA0,
  0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC, 0x88, 0xFB, 0x0B, 0x08, 0xFB, 0x0B,
  // "Ï" (U+00CF)
  0x18, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x20, 0xDA, 0x0D, 0x20, 0x8B, 0x81, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x84, 0x20, 0x5E, 0xE4, 0x28, 0x21, 0xCE, 0x97, 0x77, 0x40, 0x8F, 0xB0, 0xB0, 0x8F,
  0xB8, 0x2B, 0x6C, 0xEE, 0x81, 0xED, 0x84, 0x0C, 0xA0, 0xE0, 0x17, 0x0C, 0xA0, 0xE7, 0x10, 0xCA,
  0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71,
  0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0,
  0xE7, 0x10, 0xCA, 0x0E, 0x48, 0x16, 0xCD, 0xE8, 0x2E, 0xC8, 0x8F, 0xB0, 0xB0, 0x8F, 0xB0, 0xB0,
  // "Ð" (U+00D0)
  0x10, 0xCE, 0x81, 0xDA, 0x66, 0x0C, 0xFA, 0x0D, 0x03, 0x40, 0xCF, 0xC0, 0x43, 0x0C, 0xB8, 0x33,
  0x23, 0x6D, 0xB0, 0xE0, 0x12, 0x0C, 0xB0, 0x14, 0x0C, 0xB0, 0x72, 0x0C, 0xB0, 0x14, 0x03, 0xB0,
  0xD2, 0x0C, 0xB0, 0x15, 0x0D, 0xB8, 0x11, 0x2C, 0xB8, 0x13, 0x22, 0x30, 0xAB, 0x04, 0xF0, 0xE3,
  0x09, 0xB0, 0x5F, 0x0E, 0x30, 0x9B, 0x05, 0xF0, 0xE3, 0x09, 0xB8, 0x14, 0x0C, 0xB0, 0x15, 0x0B,
  0xB8, 0x13, 0x0C, 0xB0, 0x15, 0x0E, 0xB2, 0x0C, 0xB0, 0x14, 0x05, 0xB0, 0xC2, 0x0C, 0xB0, 0x13,
  0x01, 0x0D, 0xB0, 0x52, 0x0C, 0xB8, 0x33, 0x23, 0x7E, 0xB0, 0xC3, 0x0C, 0xFB, 0x0E, 0x02, 0x30,
  0xCF, 0xA0, 0xC0, 0x14, 0x0C, 0xD8, 0x2E, 0xD9, 0x45,
  // "Ñ" (U+00D1)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x77, 0x30, 0xCC, 0x0A, 0x40, 0x7B, 0x0C, 0xD4,
  0x07, 0xB0, 0xCD, 0x05, 0x30, 0x7B, 0x0C, 0xA0, 0xEA, 0x0A, 0x30, 0x7B, 0x0C, 0xA0, 0xAB, 0x30,
  0x7B, 0x0C, 0xA0, 0x80, 0xDA, 0x05, 0x20, 0x7B, 0x0C, 0xA0, 0x90, 0x8A, 0x0A, 0x20, 0x7B, 0x0C,
  0xA0, 0x90, 0x2B, 0x20, 0x7B, 0x0C, 0xA8, 0x1A, 0x0D, 0xA8, 0x15, 0x07, 0xB0, 0xCA, 0x81, 0xA0,
  0x8A, 0x81, 0xA0, 0x7B, 0x0C, 0xA8, 0x1A, 0x03, 0xA8, 0x1E, 0x07, 0xB0, 0xCA, 0x0A, 0x20, 0xDA,
  0x05, 0x07, 0xB0, 0xCA, 0x0A, 0x20, 0x8A, 0x0A, 0x06, 0xB0, 0xCA, 0x0A, 0x20, 0x3A, 0x0E, 0x07,
  0xB0, 0xCA, 0x0A, 0x30, 0xDA, 0x0A, 0xB0, 0xCA, 0x0A, 0x30, 0x8A, 0x0E, 0xB0, 0xCA, 0x0A, 0x30,
  0x3E, 0x0C, 0xA0, 0xA4, 0x0D, 0xD0, 0xCA, 0x0A, 0x40, 0x8D,
  // "Ò" (U+00D2)
  0x30, 0x28, 0x00, 0x77, 0x50, 0xAB, 0x08, 0x75, 0x0A, 0xB0, 0x27, 0x50, 0xAA, 0x0C, 0x76, 0x08,
  0xA0, 0x78, 0x0C, 0x50, 0x86, 0x28, 0xDE, 0xED, 0x94, 0x70, 0x7F, 0x90, 0x95, 0x05, 0xFB, 0x08,
  0x40, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x22, 0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x92, 0x0B, 0xB0, 0x44,
  0x01, 0xB0, 0xE2, 0x0E, 0xB6, 0x0C, 0xB0, 0x01, 0xB0, 0xD6, 0x0A, 0xB0, 0x40, 0x2B, 0x0C, 0x60,
  0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x01, 0xB0, 0xD6,
  0x0A, 0xB8, 0x14, 0x0E, 0xB6, 0x0D, 0xB8, 0x11, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x06, 0xB0,
  0xB4, 0x08, 0xB0, 0x93, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02, 0x30, 0x5F, 0xB0, 0x85, 0x07, 0xF9,
  0x09, 0x78, 0x62, 0x9D, 0xEE, 0xDA, 0x44,
  // "Ó" (U+00D3)
  0x71, 0x03, 0x80, 0x07, 0x74, 0x0D, 0xB0, 0x57, 0x30, 0x8B, 0x05, 0x73, 0x03, 0xB0, 0x57, 0x48,
  0x2D, 0xFE, 0x38, 0x0C, 0x60, 0x86, 0x28, 0xDE, 0xED, 0x94, 0x70, 0x7F, 0x90, 0x95, 0x05, 0xFB,
  0x08, 0x40, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x22, 0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x92, 0x0B, 0xB0,
  0x44, 0x01, 0xB0, 0xE2, 0x0E, 0xB6, 0x0C, 0xB0, 0x01, 0xB0, 0xD6, 0x0A, 0xB0, 0x40, 0x2B, 0x0C,
  0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x01, 0xB0,
  0xD6, 0x0A, 0xB8, 0x14, 0x0E, 0xB6, 0x0D, 0xB8, 0x11, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x06,
  0xB0, 0xB4, 0x08, 0xB0, 0x93, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02, 0x30, 0x5F, 0xB0, 0x85, 0x07,
  0xF9, 0x09, 0x78, 0x62, 0x9D, 0xEE, 0xDA, 0x44,
  // "Ô" (U+00D4)
  0x68, 0x00, 0x70, 0x27, 0x30, 0x6C, 0x0C, 0x72, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x71, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x36, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE8, 0x0C, 0x30, 0x86, 0x28, 0xDE,
  0xED, 0x94, 0x70, 0x7F, 0x90, 0x95, 0x05, 0xFB, 0x08, 0x40, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x22,
  0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x92, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x0E, 0xB6, 0x0C, 0xB0,
  0x01, 0xB0, 0xD6, 0x0A, 0xB0, 0x40, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0,
  0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x01, 0xB0, 0xD6, 0x0A, 0xB8, 0x14, 0x0E, 0xB6, 0x0D, 0xB8,
  0x11, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x93, 0x0E, 0xB8, 0x2A,
  0x33, 0x8C, 0x02, 0x30, 0x5F, 0xB0, 0x85, 0x07, 0xF9, 0x09, 0x78, 0x62, 0x9D, 0xEE, 0xDA, 0x44,
  // "Õ" (U+00D5)
  0x48, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x50, 0x5D, 0x82, 0xCB, 0xFE, 0x68, 0x2B, 0xFC, 0xBD,
  0x08, 0x68, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x80, 0xC4, 0x08, 0x62, 0x8D, 0xEE, 0xD9, 0x47, 0x07,
  0xF9, 0x09, 0x50, 0x5F, 0xB0, 0x84, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02, 0x20, 0x6B, 0x0B, 0x40,
  0x8B, 0x09, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0xEB, 0x60, 0xCB, 0x00, 0x1B, 0x0D, 0x60,
  0xAB, 0x04, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6,
  0x09, 0xB0, 0x50, 0x1B, 0x0D, 0x60, 0xAB, 0x81, 0x40, 0xEB, 0x60, 0xDB, 0x81, 0x10, 0xBB, 0x04,
  0x40, 0x1B, 0x0E, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x30, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x23,
  0x05, 0xFB, 0x08, 0x50, 0x7F, 0x90, 0x97, 0x86, 0x29, 0xDE, 0xED, 0xA4, 0x40,
  // "Ö" (U+00D6)
  0x38, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x60, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x50, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x58, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x80, 0xC3, 0x08, 0x62, 0x8D, 0xEE,
  0xD9, 0x47, 0x07, 0xF9, 0x09, 0x50, 0x5F, 0xB0, 0x84, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02, 0x20,
  0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0xEB, 0x60, 0xCB, 0x00,
  0x1B, 0x0D, 0x60, 0xAB, 0x04, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05,
  0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x1B, 0x0D, 0x60, 0xAB, 0x81, 0x40, 0xEB, 0x60, 0xDB, 0x81,
  0x10, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x30, 0xEB, 0x82, 0xA3,
  0x38, 0xC0, 0x23, 0x05, 0xFB, 0x08, 0x50, 0x7F, 0x90, 0x97, 0x86, 0x29, 0xDE, 0xED, 0xA4, 0x40,
  // "×" (U+00D7)
  0x20, 0x26, 0x00, 0x12, 0x81, 0xAE, 0x34, 0x83, 0x2D, 0xD1, 0x9A, 0x0E, 0x04, 0x20, 0x20, 0xDA,
  0x81, 0xC1, 0xDA, 0x82, 0xE4, 0x2D, 0xA8, 0x3E, 0x30, 0x1D, 0xB0, 0xEA, 0x0E, 0x03, 0x30, 0x10,
  0xDC, 0x0E, 0x03, 0x50, 0x3C, 0x06, 0x50, 0x20, 0xDC, 0x0E, 0x03, 0x30, 0x10, 0xDA, 0x0E, 0x0D,
  0xA8, 0x3E, 0x30, 0x1D, 0xA8, 0x2E, 0x31, 0xDA, 0x81, 0xE3, 0x8A, 0x0E, 0x03, 0x20, 0x10, 0xDA,
  0x83, 0xB0, 0xAE, 0x34, 0x82, 0x1D, 0xC1, 0x20, 0x26, 0x00, 0x11,
  // "Ø" (U+00D8)
  0x76, 0x04, 0x03, 0x58, 0x92, 0x28, 0xDE, 0xFD, 0xA4, 0x1E, 0xF7, 0x30, 0x7F, 0x90, 0xDA, 0x04,
  0x20, 0x5F, 0xC0, 0x83, 0x0E, 0xB8, 0x2A, 0x33, 0x9C, 0x03, 0x20, 0x6B, 0x0B, 0x40, 0xDB, 0x0A,
  0x20, 0xBB, 0x04, 0x30, 0x6C, 0x0E, 0x20, 0xEB, 0x30, 0x20, 0xED, 0x02, 0x01, 0xB0, 0xD3, 0x0C,
  0xA0, 0xDB, 0x04, 0x02, 0xB0, 0xC2, 0x08, 0xA0, 0x60, 0x9B, 0x05, 0x02, 0xB8, 0x1C, 0x03, 0xA8,
  0x1B, 0x09, 0xB0, 0x50, 0x2B, 0x86, 0xC0, 0xDF, 0xE1, 0x09, 0xB0, 0x50, 0x1B, 0x0D, 0x0A, 0xA0,
  0x52, 0x0A, 0xB8, 0x14, 0x0E, 0xD0, 0x93, 0x0C, 0xB8, 0x11, 0x0B, 0xC0, 0xD3, 0x01, 0xB0, 0xE2,
  0x07, 0xC0, 0x33, 0x08, 0xB0, 0x92, 0x01, 0x0E, 0xB8, 0x2A, 0x43, 0x8C, 0x02, 0x20, 0x3F, 0xC0,
  0x83, 0x0D, 0xFB, 0x09, 0x30, 0x6A, 0x87, 0x63, 0x9D, 0xFE, 0xDA, 0x45, 0x04, 0x09, 0x76,
  // "Ù" (U+00D9)
  0x20, 0x28, 0x00, 0x77, 0x30, 0xAB, 0x08, 0x73, 0x0A, 0xB0, 0x27, 0x30, 0xAA, 0x0C, 0x74, 0x08,
  0xA0, 0x77, 0x77, 0x74, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15,
  0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C,
  0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50,
  0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0B, 0xB0, 0x25, 0xC0, 0xAB, 0x04,
  0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x94, 0x06, 0xB0, 0xA0, 0x2C, 0x82, 0x94, 0x37, 0xC8, 0x15, 0x09,
  0xFB, 0x0C, 0x30, 0xAF, 0x90, 0xC0, 0x14, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x53,
  // "Ú" (U+00DA)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x77, 0x50, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15,
  0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xBB, 0x02, 0x5C, 0x0A, 0xB0,
  0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B, 0x0A, 0x02, 0xC8, 0x29, 0x43, 0x7C, 0x81, 0x50,
  0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48, 0x14, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "Û" (U+00DB)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x72, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB,
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0B, 0xB0, 0x25, 0xC0, 0xAB, 0x04, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x94, 0x06, 0xB0,
  0xA0, 0x2C, 0x82, 0x94, 0x37, 0xC8, 0x15, 0x09, 0xFB, 0x0C, 0x30, 0xAF, 0x90, 0xC0, 0x14, 0x81,
  0x4A, 0xDA, 0x81, 0xDA, 0x53,
  // "Ü" (U+00DC)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x40, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x38, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x77, 0x20, 0xCB, 0x01, 0x50,
  0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB,
  0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xBB, 0x02, 0x5C, 0x0A, 0xB0, 0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B,
  0x0A, 0x02, 0xC8, 0x29, 0x43, 0x7C, 0x81, 0x50, 0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48,
  0x14, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "Ý" (U+00DD)
  0x71, 0x03, 0x80, 0x07, 0x74, 0x0D, 0xB0, 0x57, 0x30, 0x8B, 0x05, 0x73, 0x03, 0xB0, 0x57, 0x48,
  0x2D, 0xFE, 0x38, 0x0C, 0x20, 0x03, 0xB0, 0xD6, 0x0A, 0xB8, 0x16, 0x0B, 0xB0, 0x44, 0x01, 0xB0,
  0xE2, 0x03, 0xB0, 0xB4, 0x07, 0xB0, 0x73, 0x0B, 0xB0, 0x23, 0x0E, 0xA0, 0xE4, 0x04, 0xB0, 0x92,
  0x05, 0xB0, 0x75, 0x0C, 0xA8, 0x2E, 0x10, 0xCA, 0x0E, 0x01, 0x50, 0x4B, 0x07, 0x03, 0xB0, 0x87,
  0x0C, 0xA0, 0xD0, 0x9B, 0x01, 0x70, 0x5E, 0x08, 0x72, 0x0D, 0xD0, 0x17, 0x20, 0x6C, 0x09, 0x74,
  0x0E, 0xB0, 0x27, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0,
  0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x50,
  // "Þ" (U+00DE)
  0x0D, 0xA0, 0xE7, 0x30, 0xDA, 0x0E, 0x73, 0x0D, 0xA0, 0xE7, 0x30, 0xDE, 0x82, 0xEC, 0x82, 0x30,
  0xDF, 0xB0, 0x62, 0x0D, 0xFC, 0x81, 0x40, 0xDA, 0x84, 0xE2, 0x22, 0x5C, 0xB8, 0x1B, 0x0D, 0xA0,
  0xE4, 0x01, 0xC1, 0x0D, 0xA0, 0xE5, 0x0D, 0xB0, 0x10, 0xDA, 0x0E, 0x50, 0xDB, 0x10, 0xDA, 0x0E,
  0x40, 0x2B, 0x81, 0xE0, 0xDA, 0x0E, 0x28, 0x11, 0x4D, 0xB8, 0x1A, 0x0D, 0xFC, 0x81, 0x30, 0xDF,
  0xB0, 0x62, 0x0D, 0xF8, 0x1E, 0x93, 0x30, 0xDA, 0x0E, 0x0F, 0x27, 0x0D, 0xA0, 0xE7, 0x30, 0xDA,
  0x0E, 0x73, 0x0D, 0xA0, 0xE7, 0x30,
  // "ß" (U+00DF)
  0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x26, 0x0B, 0xF9, 0x07, 0x40, 0x9F, 0xB0, 0x52, 0x02, 0xC8, 0x28,
  0x33, 0xAB, 0x0B, 0x20, 0x6B, 0x09, 0x4B, 0x0D, 0x20, 0x7B, 0x05, 0x4B, 0x0B, 0x20, 0x8B, 0x04,
  0x30, 0xAB, 0x05, 0x20, 0x8B, 0x04, 0x20, 0xAB, 0x08, 0x30, 0x8B, 0x81, 0x40, 0x8B, 0x08, 0x40,
  0x8B, 0x81, 0x40, 0xEA, 0x0C, 0x50, 0x8B, 0x04, 0x1B, 0x0E, 0x01, 0x40, 0x8B, 0x81, 0x40, 0xCB,
  0x0E, 0x04, 0x30, 0x8B, 0x82, 0x40, 0x3E, 0xC0, 0x72, 0x08, 0xB0, 0x42, 0x02, 0x0D, 0xC8, 0x16,
  0x08, 0xB0, 0x44, 0x0A, 0xC0, 0x10, 0x8B, 0x04, 0x50, 0xBB, 0x04, 0x08, 0xB0, 0x45, 0x07, 0xB0,
  0x60, 0x8B, 0x85, 0x46, 0xB5, 0x24, 0xDB, 0x04, 0x08, 0xB0, 0x40, 0x6F, 0x81, 0xE0, 0x8B, 0x04,
  0x06, 0xF8, 0x15, 0x08, 0xB8, 0x74, 0x3A, 0xDE, 0xFD, 0xA3, 0x20,
  // "à" (U+00E0)
  0x20, 0x28, 0x00, 0x77, 0x30, 0xAB, 0x08, 0x73, 0x0A, 0xB0, 0x27, 0x30, 0xAA, 0x0C, 0x74, 0x08,
  0xA0, 0x77, 0x76, 0x82, 0x38, 0xBE, 0xA8, 0x1D, 0xA5, 0x40, 0x8F, 0xA0, 0xC0, 0x12, 0x03, 0xFB,
  0x0B, 0x38, 0x6B, 0xB7, 0x43, 0x37, 0xEB, 0x02, 0x72, 0x07, 0xB0, 0x55, 0x83, 0x12, 0x22, 0x6B,
  0x06, 0x20, 0x50, 0xBF, 0xA8, 0x16, 0x09, 0xFC, 0x06, 0x04, 0xB8, 0x1D, 0x51, 0x20, 0x4B, 0x06,
  0x08, 0xB0, 0x44, 0x05, 0xB0, 0x60, 0x9B, 0x03, 0x40, 0xBB, 0x06, 0x08, 0xB8, 0x3C, 0x42, 0x5B,
  0xC0, 0x60, 0x4F, 0xD8, 0x16, 0x0A, 0xE8, 0x1E, 0x3E, 0xA0, 0x62, 0x87, 0x7C, 0xFE, 0xC8, 0x10,
  0xAA, 0x06,
  // "á" (U+00E1)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x78, 0x23, 0x8B, 0xEA, 0x81, 0xDA, 0x54, 0x08, 0xFA, 0x0C, 0x01, 0x20, 0x3F,
  0xB0, 0xB3, 0x86, 0xBB, 0x74, 0x33, 0x7E, 0xB0, 0x27, 0x20, 0x7B, 0x05, 0x58, 0x31, 0x22, 0x26,
  0xB0, 0x62, 0x05, 0x0B, 0xFA, 0x81, 0x60, 0x9F, 0xC0, 0x60, 0x4B, 0x81, 0xD5, 0x12, 0x04, 0xB0,
  0x60, 0x8B, 0x04, 0x40, 0x5B, 0x06, 0x09, 0xB0, 0x34, 0x0B, 0xB0, 0x60, 0x8B, 0x83, 0xC4, 0x25,
  0xBC, 0x06, 0x04, 0xFD, 0x81, 0x60, 0xAE, 0x81, 0xE3, 0xEA, 0x06, 0x28, 0x77, 0xCF, 0xEC, 0x81,
  0x0A, 0xA0, 0x60,
  // "â" (U+00E2)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x74, 0x82, 0x38, 0xBE, 0xA8, 0x1D,
  0xA5, 0x40, 0x8F, 0xA0, 0xC0, 0x12, 0x03, 0xFB, 0x0B, 0x38, 0x6B, 0xB7, 0x43, 0x37, 0xEB, 0x02,
  0x72, 0x07, 0xB0, 0x55, 0x83, 0x12, 0x22, 0x6B, 0x06, 0x20, 0x50, 0xBF, 0xA8, 0x16, 0x09, 0xFC,
  0x06, 0x04, 0xB8, 0x1D, 0x51, 0x20, 0x4B, 0x06, 0x08, 0xB0, 0x44, 0x05, 0xB0, 0x60, 0x9B, 0x03,
  0x40, 0xBB, 0x06, 0x08, 0xB8, 0x3C, 0x42, 0x5B, 0xC0, 0x60, 0x4F, 0xD8, 0x16, 0x0A, 0xE8, 0x1E,
  0x3E, 0xA0, 0x62, 0x87, 0x7C, 0xFE, 0xC8, 0x10, 0xAA, 0x06,
  // "ã" (U+00E3)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x58, 0x23, 0x8B, 0xEA, 0x81, 0xDA, 0x54, 0x08,
  0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86, 0xBB, 0x74, 0x33, 0x7E, 0xB0, 0x27, 0x20, 0x7B,
  0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05, 0x0B, 0xFA, 0x81, 0x60, 0x9F, 0xC0, 0x60, 0x4B,
  0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04, 0x40, 0x5B, 0x06, 0x09, 0xB0, 0x34, 0x0B, 0xB0,
  0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04, 0xFD, 0x81, 0x60, 0xAE, 0x81, 0xE3, 0xEA, 0x06,
  0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0A, 0xA0, 0x60,
  // "ä" (U+00E4)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x40, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x38, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x48, 0x23, 0x8B, 0xEA, 0x81,
  0xDA, 0x54, 0x08, 0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86, 0xBB, 0x74, 0x33, 0x7E, 0xB0,
  0x27, 0x20, 0x7B, 0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05, 0x0B, 0xFA, 0x81, 0x60, 0x9F,
  0xC0, 0x60, 0x4B, 0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04, 0x40, 0x5B, 0x06, 0x09, 0xB0,
  0x34, 0x0B, 0xB0, 0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04, 0xFD, 0x81, 0x60, 0xAE, 0x81,
  0xE3, 0xEA, 0x06, 0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0A, 0xA0, 0x60,
  // "å" (U+00E5)
  0x48, 0x41, 0x9E, 0xEA, 0x17, 0x18, 0x4B, 0xFE, 0xEF, 0xC7, 0x19, 0x84, 0xE1, 0x0D, 0xF3, 0x79,
  0x0E, 0x28, 0x1D, 0xF3, 0x78, 0x4B, 0xFE, 0xEF, 0xC7, 0x18, 0x41, 0x9E, 0xEA, 0x17, 0x76, 0x82,
  0x38, 0xBE, 0xA8, 0x1D, 0xA5, 0x40, 0x8F, 0xA0, 0xC0, 0x12, 0x03, 0xFB, 0x0B, 0x38, 0x6B, 0xB7,
  0x43, 0x37, 0xEB, 0x02, 0x72, 0x07, 0xB0, 0x55, 0x83, 0x12, 0x22, 0x6B, 0x06, 0x20, 0x50, 0xBF,
  0xA8, 0x16, 0x09, 0xFC, 0x06, 0x04, 0xB8, 0x1D, 0x51, 0x20, 0x4B, 0x06, 0x08, 0xB0, 0x44, 0x05,
  0xB0, 0x60, 0x9B, 0x03, 0x40, 0xBB, 0x06, 0x08, 0xB8, 0x3C, 0x42, 0x5B, 0xC0, 0x60, 0x4F, 0xD8,
  0x16, 0x0A, 0xE8, 0x1E, 0x3E, 0xA0, 0x62, 0x87, 0x7C, 0xFE, 0xC8, 0x10, 0xAA, 0x06,
  // "æ" (U+00E6)
  0x18, 0x93, 0x29, 0xDF, 0xEB, 0x50, 0x7D, 0xFD, 0x63, 0x0C, 0xE0, 0xDD, 0x07, 0x20, 0x5F, 0xE0,
  0x12, 0x83, 0x84, 0x25, 0xEB, 0x81, 0x84, 0xEA, 0x07, 0x60, 0x9B, 0x20, 0x8A, 0x0A, 0x60, 0x8A,
  0x0D, 0x20, 0x6A, 0x83, 0xD0, 0x18, 0xDF, 0xC8, 0x1E, 0x0C, 0xFE, 0x0E, 0x06, 0xB8, 0x18, 0x29,
  0xA0, 0xE8, 0x01, 0xD0, 0xC0, 0xAA, 0x0C, 0x20, 0x8A, 0x0D, 0x60, 0xBA, 0x0B, 0x20, 0xAB, 0x03,
  0x50, 0xAB, 0x04, 0x05, 0xC8, 0x5E, 0x63, 0x38, 0x47, 0xE0, 0xD0, 0xEE, 0x81, 0x41, 0xEC, 0x81,
  0xE2, 0x5E, 0x86, 0x40, 0x2B, 0xEE, 0xB2, 0x28, 0x43, 0xAE, 0xFD, 0x71,
  // "ç" (U+00E7)
  0x48, 0x73, 0x9D, 0xEF, 0xDC, 0x94, 0x30, 0xAF, 0x90, 0xC2, 0x0A, 0xFA, 0x81, 0x60, 0x4C, 0x87,
  0xA4, 0x23, 0x6B, 0x10, 0xAB, 0x09, 0x71, 0x0E, 0xB0, 0x27, 0x1B, 0x0E, 0x71, 0x01, 0xB0, 0xD7,
  0x2B, 0x0E, 0x72, 0x0E, 0xB0, 0x17, 0x10, 0xBB, 0x09, 0x68, 0x11, 0x06, 0xC8, 0x5A, 0x42, 0x47,
  0xC9, 0x20, 0xCF, 0xA0, 0x92, 0x01, 0x0C, 0xF9, 0x09, 0x48, 0x15, 0xAD, 0xA8, 0x2E, 0xB7, 0x16,
  0x82, 0x3F, 0xE2, 0x72, 0x08, 0xB0, 0x57, 0x28, 0x21, 0xDF, 0xE7, 0x82, 0x10, 0x2E, 0xA7, 0x09,
  0xC0, 0xA7, 0x84, 0x8E, 0xFE, 0x91, 0x20,
  // "è" (U+00E8)
  0x20, 0x28, 0x00, 0x77, 0x30, 0xAB, 0x08, 0x73, 0x0A, 0xB0, 0x27, 0x30, 0xAA, 0x0C, 0x74, 0x08,
  0xA0, 0x77, 0x77, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x50, 0x40, 0xEF, 0x0A, 0x30, 0x2F, 0xB0, 0x92,
  0x0C, 0xB8, 0x3B, 0x43, 0x5D, 0xB0, 0x02, 0xB0, 0xB4, 0x01, 0x0E, 0xA0, 0x07, 0xB0, 0x78, 0x01,
  0x20, 0xCA, 0x0B, 0x08, 0xFD, 0x0C, 0x09, 0xFD, 0x0D, 0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x47, 0x20,
  0x2B, 0x0B, 0x73, 0x0A, 0xB8, 0x92, 0xD7, 0x32, 0x35, 0x8C, 0x60, 0x1D, 0xFB, 0x06, 0x20, 0x20,
  0xCF, 0xA0, 0x64, 0x87, 0x49, 0xDE, 0xFE, 0xCA, 0x51,
  // "é" (U+00E9)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x71, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x50, 0x40, 0xEF, 0x0A, 0x30, 0x2F, 0xB0,
  0x92, 0x0C, 0xB8, 0x3B, 0x43, 0x5D, 0xB0, 0x02, 0xB0, 0xB4, 0x01, 0x0E, 0xA0, 0x07, 0xB0, 0x78,
  0x01, 0x20, 0xCA, 0x0B, 0x08, 0xFD, 0x0C, 0x09, 0xFD, 0x0D, 0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x47,
  0x20, 0x2B, 0x0B, 0x73, 0x0A, 0xB8, 0x92, 0xD7, 0x32, 0x35, 0x8C, 0x60, 0x1D, 0xFB, 0x06, 0x20,
  0x20, 0xCF, 0xA0, 0x64, 0x87, 0x49, 0xDE, 0xFE, 0xCA, 0x51,
  // "ê" (U+00EA)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x75, 0x86, 0x17, 0xCE, 0xFD, 0xA4,
  0x50, 0x40, 0xEF, 0x0A, 0x30, 0x2F, 0xB0, 0x92, 0x0C, 0xB8, 0x3B, 0x43, 0x5D, 0xB0, 0x02, 0xB0,
  0xB4, 0x01, 0x0E, 0xA0, 0x07, 0xB0, 0x78, 0x01, 0x20, 0xCA, 0x0B, 0x08, 0xFD, 0x0C, 0x09, 0xFD,
  0x0D, 0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x47, 0x20, 0x2B, 0x0B, 0x73, 0x0A, 0xB8, 0x92, 0xD7, 0x32,
  0x35, 0x8C, 0x60, 0x1D, 0xFB, 0x06, 0x20, 0x20, 0xCF, 0xA0, 0x64, 0x87, 0x49, 0xDE, 0xFE, 0xCA,
  0x51,
  // "ë" (U+00EB)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x40, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x38, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x58, 0x61, 0x7C, 0xEF, 0xDA,
  0x45, 0x04, 0x0E, 0xF0, 0xA3, 0x02, 0xFB, 0x09, 0x20, 0xCB, 0x83, 0xB4, 0x35, 0xDB, 0x00, 0x2B,
  0x0B, 0x40, 0x10, 0xEA, 0x00, 0x7B, 0x07, 0x80, 0x12, 0x0C, 0xA0, 0xB0, 0x8F, 0xD0, 0xC0, 0x9F,
  0xD0, 0xD0, 0x8F, 0xD0, 0xD0, 0x6B, 0x04, 0x72, 0x02, 0xB0, 0xB7, 0x30, 0xAB, 0x89, 0x2D, 0x73,
  0x23, 0x58, 0xC6, 0x01, 0xDF, 0xB0, 0x62, 0x02, 0x0C, 0xFA, 0x06, 0x48, 0x74, 0x9D, 0xEF, 0xEC,
  0xA5, 0x10,
  // "ì" (U+00EC)
  0x20, 0x28, 0x00, 0x77, 0x30, 0xAB, 0x08, 0x73, 0x0A, 0xB0, 0x27, 0x30, 0xAA, 0x0C, 0x74, 0x08,
  0xA0, 0x77, 0x75, 0x0A, 0xF0, 0x75, 0x0A, 0xF0, 0x75, 0x08, 0xF0, 0x77, 0x81, 0x13, 0x9B, 0x07,
  0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07,
  0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x10, 0x10, 0x9B, 0x09, 0x01, 0x38, 0x22,
  0x9C, 0xEF, 0x82, 0xDB, 0x75, 0xFD, 0x0D, 0x05, 0xFD, 0x0D,
  // "í" (U+00ED)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x60, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39, 0xB0,
  0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20,
  0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13, 0x82,
  0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "î" (U+00EE)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x73, 0x0A, 0xF0, 0x75, 0x0A, 0xF0,
  0x75, 0x08, 0xF0, 0x77, 0x81, 0x13, 0x9B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72,
  0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0,
  0x77, 0x10, 0x10, 0x9B, 0x09, 0x01, 0x38, 0x22, 0x9C, 0xEF, 0x82, 0xDB, 0x75, 0xFD, 0x0D, 0x05,
  0xFD, 0x0D,
  // "ï" (U+00EF)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x40, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x38, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x30, 0xAF, 0x07, 0x50, 0xAF,
  0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77,
  0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B,
  0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0,
  0x5F, 0xD0, 0xD0,
  // "ð" (U+00F0)
  0x40, 0x50, 0x44, 0x04, 0x03, 0x68, 0x71, 0xEF, 0xC3, 0x2B, 0xFC, 0x60, 0x5F, 0x0C, 0x02, 0x60,
  0x30, 0xDC, 0x07, 0x70, 0x10, 0xAD, 0x0B, 0x70, 0xAA, 0x0D, 0x09, 0xB0, 0x96, 0x81, 0x2E, 0x72,
  0x0A, 0xB0, 0x47, 0x01, 0x02, 0x20, 0xDA, 0x0C, 0x48, 0x11, 0x8E, 0xB0, 0xB0, 0x8B, 0x04, 0x20,
  0x20, 0xDE, 0x0E, 0xB0, 0x92, 0x0D, 0xFC, 0x81, 0xD0, 0x5B, 0x84, 0xE5, 0x11, 0x5D, 0xC1, 0x0A,
  0xB0, 0x64, 0x03, 0xC0, 0x10, 0xCB, 0x01, 0x50, 0xEB, 0x01, 0x0D, 0xB6, 0x0D, 0xB1, 0x0C, 0xB0,
  0x25, 0xB8, 0x1D, 0x09, 0xB0, 0x84, 0x06, 0xB8, 0x19, 0x03, 0xC8, 0x28, 0x33, 0x7C, 0x03, 0x20,
  0x9F, 0xB0, 0x84, 0x09, 0xF9, 0x08, 0x68, 0x63, 0x9D, 0xEE, 0xD9, 0x34,
  // "ñ" (U+00F1)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x30, 0x8A, 0x87, 0x90, 0x29, 0xDF, 0xEB, 0x52,
  0x08, 0xA0, 0xE0, 0x4F, 0x81, 0x90, 0x8F, 0xD0, 0x30, 0x8C, 0x83, 0xD5, 0x36, 0xEB, 0x09, 0x08,
  0xC0, 0x23, 0x06, 0xB0, 0xC0, 0x8B, 0x0B, 0x40, 0x2B, 0x0D, 0x08, 0xB0, 0x84, 0x01, 0xB0, 0xD0,
  0x8B, 0x07, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D,
  0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0,
  0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0,
  // "ò" (U+00F2)
  0x20, 0x28, 0x00, 0x77, 0x40, 0xAB, 0x08, 0x74, 0x0A, 0xB0, 0x27, 0x40, 0xAA, 0x0C, 0x75, 0x08,
  0xA0, 0x77, 0x77, 0x28, 0x61, 0x7C, 0xEF, 0xDA, 0x36, 0x05, 0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92,
  0x01, 0x0E, 0xB8, 0x2A, 0x33, 0x7C, 0x81, 0x30, 0x6B, 0x0B, 0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05,
  0x40, 0x1B, 0x81, 0xE0, 0xCB, 0x02, 0x50, 0xEB, 0x10, 0xDB, 0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0,
  0x25, 0x0E, 0xB1, 0x0B, 0xB0, 0x54, 0x01, 0xB8, 0x1E, 0x06, 0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01,
  0xEB, 0x82, 0xA3, 0x37, 0xC0, 0x32, 0x06, 0xFB, 0x09, 0x40, 0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE,
  0xED, 0x93, 0x40,
  // "ó" (U+00F3)
  0x70, 0x38, 0x00, 0x77, 0x30, 0xDB, 0x05, 0x72, 0x08, 0xB0, 0x57, 0x20, 0x3B, 0x05, 0x73, 0x82,
  0xDF, 0xE3, 0x77, 0x73, 0x86, 0x17, 0xCE, 0xFD, 0xA3, 0x60, 0x5F, 0x90, 0x94, 0x05, 0xFB, 0x09,
  0x20, 0x10, 0xEB, 0x82, 0xA3, 0x37, 0xC8, 0x13, 0x06, 0xB0, 0xB4, 0x07, 0xB8, 0x1A, 0x0A, 0xB0,
  0x54, 0x01, 0xB8, 0x1E, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0D, 0xB0, 0x15, 0x0D, 0xB0, 0x10, 0xCB,
  0x02, 0x50, 0xEB, 0x10, 0xBB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0x6B, 0x0B, 0x40, 0x8B, 0x82, 0x90,
  0x1E, 0xB8, 0x2A, 0x33, 0x7C, 0x03, 0x20, 0x6F, 0xB0, 0x94, 0x06, 0xF9, 0x09, 0x68, 0x62, 0x8C,
  0xEE, 0xD9, 0x34,
  // "ô" (U+00F4)
  0x58, 0x00, 0x70, 0x27, 0x20, 0x6C, 0x0C, 0x71, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x70, 0xCA, 0x81,
  0x51, 0xDA, 0x03, 0x58, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xDA,
  0x36, 0x05, 0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92, 0x01, 0x0E, 0xB8, 0x2A, 0x33, 0x7C, 0x81, 0x30,
  0x6B, 0x0B, 0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0xCB, 0x02, 0x50, 0xEB,
  0x10, 0xDB, 0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0B, 0xB0, 0x54, 0x01, 0xB8,
  0x1E, 0x06, 0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xA3, 0x37, 0xC0, 0x32, 0x06, 0xFB,
  0x09, 0x40, 0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE, 0xED, 0x93, 0x40,
  // "õ" (U+00F5)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x40, 0x5D, 0x82, 0xCB, 0xFE, 0x58, 0x2B, 0xFC, 0xBD,
  0x08, 0x58, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x71, 0x86, 0x17, 0xCE, 0xFD, 0xA3, 0x60, 0x5F,
  0x90, 0x94, 0x05, 0xFB, 0x09, 0x20, 0x10, 0xEB, 0x82, 0xA3, 0x37, 0xC8, 0x13, 0x06, 0xB0, 0xB4,
  0x07, 0xB8, 0x1A, 0x0A, 0xB0, 0x54, 0x01, 0xB8, 0x1E, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0D, 0xB0,
  0x15, 0x0D, 0xB0, 0x10, 0xCB, 0x02, 0x50, 0xEB, 0x10, 0xBB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0x6B,
  0x0B, 0x40, 0x8B, 0x82, 0x90, 0x1E, 0xB8, 0x2A, 0x33, 0x7C, 0x03, 0x20, 0x6F, 0xB0, 0x94, 0x06,
  0xF9, 0x09, 0x68, 0x62, 0x8C, 0xEE, 0xD9, 0x34,
  // "ö" (U+00F6)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x50, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x40, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x48, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xDA,
  0x36, 0x05, 0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92, 0x01, 0x0E, 0xB8, 0x2A, 0x33, 0x7C, 0x81, 0x30,
  0x6B, 0x0B, 0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0xCB, 0x02, 0x50, 0xEB,
  0x10, 0xDB, 0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0B, 0xB0, 0x54, 0x01, 0xB8,
  0x1E, 0x06, 0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xA3, 0x37, 0xC0, 0x32, 0x06, 0xFB,
  0x09, 0x40, 0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE, 0xED, 0x93, 0x40,
  // "÷" (U+00F7)
  0x58, 0x23, 0xDE, 0x57, 0x30, 0x9A, 0x0D, 0x73, 0x09, 0xA0, 0xD7, 0x38, 0x23, 0xDE, 0x57, 0x76,
  0x80, 0x90, 0x21, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x77, 0x58, 0x23, 0xDE,
  0x57, 0x30, 0x9A, 0x0D, 0x73, 0x09, 0xA0, 0xD7, 0x38, 0x22, 0xDE, 0x55,
  // "ø" (U+00F8)
  0x74, 0x04, 0x68, 0x90, 0x17, 0xCE, 0xED, 0x98, 0xFA, 0x40, 0x5F, 0xA0, 0xC3, 0x05, 0xFB, 0x09,
  0x20, 0x10, 0xEB, 0x82, 0xA3, 0x3B, 0xC8, 0x13, 0x06, 0xB0, 0xB2, 0x01, 0x0E, 0xC8, 0x19, 0x0A,
  0xB0, 0x52, 0x0B, 0xD8, 0x1E, 0x0C, 0xB8, 0x12, 0x07, 0xA0, 0x60, 0xEB, 0x10, 0xDB, 0x01, 0x03,
  0xA8, 0x1B, 0x0D, 0xB0, 0x10, 0xDB, 0x85, 0x2D, 0xFE, 0x10, 0xEB, 0x10, 0xBB, 0x0C, 0xA8, 0x14,
  0x01, 0xB8, 0x1E, 0x07, 0xD0, 0x82, 0x07, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xE4, 0x37, 0xC0, 0x32,
  0x06, 0xFB, 0x09, 0x30, 0x6F, 0xA0, 0x94, 0x89, 0x0A, 0xFC, 0x8D, 0xEE, 0xD9, 0x36, 0x06, 0x02,
  0x74,
  // "ù" (U+00F9)
  0x20, 0x28, 0x00, 0x77, 0x30, 0xAB, 0x08, 0x73, 0x0A, 0xB0, 0x27, 0x30, 0xAA, 0x0C, 0x74, 0x08,
  0xA0, 0x77, 0x74, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0,
  0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB,
  0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A,
  0xB0, 0x44, 0x04, 0xB0, 0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x09, 0xB0, 0x94, 0x0C, 0xB0, 0xB0,
  0x6C, 0x82, 0x73, 0x4B, 0xC0, 0xB0, 0x1F, 0xD8, 0x1B, 0x06, 0xF0, 0x60, 0xBA, 0x0B, 0x28, 0x74,
  0xBE, 0xFD, 0x93, 0x06, 0xA0, 0xB0,
  // "ú" (U+00FA)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x50, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB,
  0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A,
  0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0,
  0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0, 0x54, 0x07, 0xB0, 0xB0, 0x9B, 0x09, 0x40, 0xCB, 0x0B,
  0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01, 0xFD, 0x81, 0xB0, 0x6F, 0x06, 0x0B, 0xA0, 0xB2, 0x87,
  0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "û" (U+00FB)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x72, 0x0A, 0xB0, 0x44, 0x03, 0xB0,
  0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03,
  0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04, 0xB0, 0xB0, 0xAB, 0x05, 0x40,
  0x7B, 0x0B, 0x09, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0x6C, 0x82, 0x73, 0x4B, 0xC0, 0xB0, 0x1F, 0xD8,
  0x1B, 0x06, 0xF0, 0x60, 0xBA, 0x0B, 0x28, 0x74, 0xBE, 0xFD, 0x93, 0x06, 0xA0, 0xB0,
  // "ü" (U+00FC)
  0x28, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x40, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x30, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x38, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x20, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03,
  0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40,
  0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0, 0x54,
  0x07, 0xB0, 0xB0, 0x9B, 0x09, 0x40, 0xCB, 0x0B, 0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01, 0xFD,
  0x81, 0xB0, 0x6F, 0x06, 0x0B, 0xA0, 0xB2, 0x87, 0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "ý" (U+00FD)
  0x71, 0x03, 0x80, 0x07, 0x74, 0x0D, 0xB0, 0x57, 0x30, 0x8B, 0x05, 0x73, 0x03, 0xB0, 0x57, 0x48,
  0x2D, 0xFE, 0x37, 0x77, 0x10, 0x4B, 0x0E, 0x60, 0xAB, 0x81, 0x70, 0xDB, 0x04, 0x50, 0xEB, 0x81,
  0x10, 0x7B, 0x09, 0x40, 0x4B, 0x0B, 0x20, 0x1B, 0x0E, 0x40, 0x9B, 0x05, 0x30, 0xAB, 0x04, 0x30,
  0xDA, 0x0E, 0x40, 0x4B, 0x09, 0x20, 0x2B, 0x09, 0x50, 0xDA, 0x0E, 0x20, 0x7B, 0x03, 0x50, 0x7B,
  0x81, 0x40, 0xCA, 0x0D, 0x60, 0x1B, 0x09, 0x01, 0xB0, 0x77, 0x0A, 0xA0, 0xE0, 0x5B, 0x02, 0x70,
  0x4B, 0x0A, 0xA0, 0xC7, 0x20, 0xDD, 0x06, 0x72, 0x07, 0xD0, 0x17, 0x20, 0x1C, 0x0A, 0x74, 0x0B,
  0xB0, 0x47, 0x40, 0xEA, 0x0D, 0x74, 0x08, 0xB0, 0x77, 0x82, 0x12, 0x38, 0xB0, 0xE0, 0x17, 0x06,
  0xE0, 0x57, 0x10, 0x6D, 0x07, 0x72, 0x84, 0x5E, 0xFE, 0xA3, 0x72,
  // "þ" (U+00FE)
  0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0,
  0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB8, 0x64, 0x18, 0xDF, 0xEA, 0x33, 0x08, 0xB0, 0x60, 0xEE,
  0x03, 0x20, 0x8F, 0xC0, 0xE2, 0x08, 0xC8, 0x2B, 0x42, 0x7C, 0x81, 0x60, 0x8B, 0x0E, 0x40, 0x8B,
  0x81, 0xB0, 0x8B, 0x08, 0x40, 0x2B, 0x81, 0xE0, 0x8B, 0x05, 0x5C, 0x10, 0x8B, 0x04, 0x50, 0xEB,
  0x01, 0x08, 0xB0, 0x55, 0xC0, 0x10, 0x8B, 0x08, 0x40, 0x2B, 0x81, 0xE0, 0x8B, 0x0D, 0x40, 0x7B,
  0x81, 0xB0, 0x8C, 0x82, 0xC4, 0x26, 0xC8, 0x16, 0x08, 0xFC, 0x0D, 0x20, 0x8B, 0x08, 0xE0, 0xE0,
  0x32, 0x08, 0xB8, 0x64, 0x29, 0xDF, 0xD9, 0x13, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08,
  0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73, 0x08, 0xB0, 0x47, 0x30, 0x8B, 0x04, 0x73,
  // "ÿ" (U+00FF)
  0x38, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x60, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x50, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x58, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x50, 0x4B, 0x0E, 0x60, 0xAB,
  0x81, 0x70, 0xDB, 0x04, 0x50, 0xEB, 0x81, 0x10, 0x7B, 0x09, 0x40, 0x4B, 0x0B, 0x20, 0x1B, 0x0E,
  0x40, 0x9B, 0x05, 0x30, 0xAB, 0x04, 0x30, 0xDA, 0x0E, 0x40, 0x4B, 0x09, 0x20, 0x2B, 0x09, 0x50,
  0xDA, 0x0E, 0x20, 0x7B, 0x03, 0x50, 0x7B, 0x81, 0x40, 0xCA, 0x0D, 0x60, 0x1B, 0x09, 0x01, 0xB0,
  0x77, 0x0A, 0xA0, 0xE0, 0x5B, 0x02, 0x70, 0x4B, 0x0A, 0xA0, 0xC7, 0x20, 0xDD, 0x06, 0x72, 0x07,
  0xD0, 0x17, 0x20, 0x1C, 0x0A, 0x74, 0x0B, 0xB0, 0x47, 0x40, 0xEA, 0x0D, 0x74, 0x08, 0xB0, 0x77,
  0x82, 0x12, 0x38, 0xB0, 0xE0, 0x17, 0x06, 0xE0, 0x57, 0x10, 0x6D, 0x07, 0x72, 0x84, 0x5E, 0xFE,
  0xA3, 0x72,
  // "Ā" (U+0100)
  0x48, 0x04, 0x27, 0x1F, 0x90, 0x37, 0xF9, 0x03, 0x7F, 0x90, 0x38, 0x0E, 0x40, 0x08, 0xC0, 0xB7,
  0x30, 0xCD, 0x72, 0x01, 0xE0, 0x47, 0x10, 0x6A, 0x0E, 0x0C, 0xA0, 0x87, 0x10, 0xAA, 0x0B, 0x08,
  0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x04, 0xB0, 0x26, 0x03, 0xB0, 0x31, 0xB0, 0x66, 0x07, 0xA0, 0xE2,
  0x0C, 0xA0, 0xA6, 0x0C, 0xA0, 0xB2, 0x08, 0xA0, 0xE5, 0x01, 0xB0, 0x72, 0x04, 0xB0, 0x34, 0x05,
  0xB0, 0x33, 0xB0, 0x84, 0x09, 0xFB, 0x0C, 0x40, 0xEF, 0xC0, 0x12, 0x03, 0xFD, 0x05, 0x20, 0x7B,
  0x84, 0x42, 0x22, 0x23, 0xB0, 0xA2, 0x0B, 0xA0, 0xE6, 0x0C, 0xA0, 0xE2, 0xB0, 0xA6, 0x09, 0xB0,
  0x30, 0x4B, 0x06, 0x60, 0x5B, 0x07, 0x09, 0xB0, 0x36, 0x01, 0xB0, 0xC0,
  // "ā" (U+0101)
  0x38, 0x04, 0x26, 0xF9, 0x03, 0x5F, 0x90, 0x35, 0xF9, 0x03, 0x77, 0x77, 0x48, 0x23, 0x8B, 0xEA,
  0x81, 0xDA, 0x54, 0x08, 0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86, 0xBB, 0x74, 0x33, 0x7E,
  0xB0, 0x27, 0x20, 0x7B, 0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05, 0x0B, 0xFA, 0x81, 0x60,
  0x9F, 0xC0, 0x60, 0x4B, 0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04, 0x40, 0x5B, 0x06, 0x09,
  0xB0, 0x34, 0x0B, 0xB0, 0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04, 0xFD, 0x81, 0x60, 0xAE,
  0x81, 0xE3, 0xEA, 0x06, 0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0A, 0xA0, 0x60,
  // "Ă" (U+0102)
  0x38, 0x12, 0x77, 0x48, 0x14, 0x75, 0x60, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x97, 0x0E, 0xF0, 0x37,
  0x05, 0xE0, 0x97, 0x28, 0x43, 0xBE, 0xFC, 0x68, 0x0C, 0x60, 0x08, 0xC0, 0xB7, 0x30, 0xCD, 0x72,
  0x01, 0xE0, 0x47, 0x10, 0x6A, 0x0E, 0x0C, 0xA0, 0x87, 0x10, 0xAA, 0x0B, 0x08, 0xA0, 0xD7, 0x10,
  0xEA, 0x07, 0x04, 0xB0, 0x26, 0x03, 0xB0, 0x31, 0xB0, 0x66, 0x07, 0xA0, 0xE2, 0x0C, 0xA0, 0xA6,
  0x0C, 0xA0, 0xB2, 0x08, 0xA0, 0xE5, 0x01, 0xB0, 0x72, 0x04, 0xB0, 0x34, 0x05, 0xB0, 0x33, 0xB0,
  0x84, 0x09, 0xFB, 0x0C, 0x40, 0xEF, 0xC0, 0x12, 0x03, 0xFD, 0x05, 0x20, 0x7B, 0x84, 0x42, 0x22,
  0x23, 0xB0, 0xA2, 0x0B, 0xA0, 0xE6, 0x0C, 0xA0, 0xE2, 0xB0, 0xA6, 0x09, 0xB0, 0x30, 0x4B, 0x06,
  0x60, 0x5B, 0x07, 0x09, 0xB0, 0x36, 0x01, 0xB0, 0xC0,
  // "ă" (U+0103)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x68, 0x23, 0x8B, 0xEA, 0x81, 0xDA, 0x54, 0x08,
  0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86, 0xBB, 0x74, 0x33, 0x7E, 0xB0, 0x27, 0x20, 0x7B,
  0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05, 0x0B, 0xFA, 0x81, 0x60, 0x9F, 0xC0, 0x60, 0x4B,
  0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04, 0x40, 0x5B, 0x06, 0x09, 0xB0, 0x34, 0x0B, 0xB0,
  0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04, 0xFD, 0x81, 0x60, 0xAE, 0x81, 0xE3, 0xEA, 0x06,
  0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0A, 0xA0, 0x60,
  // "Ą" (U+0104)
  0x50, 0x8C, 0x0B, 0x74, 0x0C, 0xD7, 0x30, 0x1E, 0x04, 0x72, 0x06, 0xA0, 0xE0, 0xCA, 0x08, 0x72,
  0x0A, 0xA0, 0xB0, 0x8A, 0x0D, 0x72, 0x0E, 0xA0, 0x70, 0x4B, 0x02, 0x70, 0x3B, 0x03, 0x1B, 0x06,
  0x70, 0x7A, 0x0E, 0x20, 0xCA, 0x0A, 0x70, 0xCA, 0x0B, 0x20, 0x8A, 0x0E, 0x60, 0x1B, 0x07, 0x20,
  0x4B, 0x03, 0x50, 0x5B, 0x03, 0x3B, 0x08, 0x50, 0x9F, 0xB0, 0xC5, 0x0E, 0xFC, 0x01, 0x30, 0x3F,
  0xD0, 0x53, 0x07, 0xB8, 0x44, 0x22, 0x22, 0x3B, 0x0A, 0x30, 0xBA, 0x0E, 0x60, 0xCA, 0x0E, 0x3B,
  0x0A, 0x60, 0x9B, 0x81, 0x30, 0x4B, 0x06, 0x60, 0x5B, 0x81, 0x70, 0x9B, 0x03, 0x60, 0x1C, 0x76,
  0x82, 0x1D, 0xF8, 0x76, 0x81, 0xBF, 0xC7, 0x60, 0x2A, 0x08, 0x76, 0x03, 0xA8, 0x1B, 0x23, 0x75,
  0x0D, 0xB0, 0xC7, 0x58, 0x32, 0xBE, 0xEA,
  // "ą" (U+0105)
  0x28, 0x23, 0x8B, 0xEA, 0x81, 0xDA, 0x54, 0x08, 0xFA, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0xB3, 0x86,
  0xBB, 0x74, 0x33, 0x7E, 0xB0, 0x27, 0x20, 0x7B, 0x05, 0x58, 0x31, 0x22, 0x26, 0xB0, 0x62, 0x05,
  0x0B, 0xFA, 0x81, 0x60, 0x9F, 0xC0, 0x60, 0x4B, 0x81, 0xD5, 0x12, 0x04, 0xB0, 0x60, 0x8B, 0x04,
  0x40, 0x5B, 0x06, 0x09, 0xB0, 0x34, 0x0B, 0xB0, 0x60, 0x8B, 0x83, 0xC4, 0x25, 0xBC, 0x06, 0x04,
  0xFD, 0x81, 0x60, 0xAE, 0x81, 0xE3, 0xEA, 0x06, 0x28, 0x77, 0xCF, 0xEC, 0x81, 0x0B, 0xA0, 0x77,
  0x28, 0x21, 0xDF, 0x87, 0x38, 0x1B, 0xFC, 0x73, 0x02, 0xA0, 0x87, 0x30, 0x3A, 0x81, 0xB2, 0x37,
  0x20, 0xDB, 0x0C, 0x72, 0x83, 0x2B, 0xEE, 0xA0,
  // "Ć" (U+0106)
  0x72, 0x03, 0x80, 0x07, 0x72, 0x0D, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x03, 0xB0, 0x57, 0x28,
  0x2D, 0xFE, 0x38, 0x0C, 0x00, 0x87, 0x49, 0xCE, 0xFE, 0xC8, 0x23, 0x02, 0x0C, 0xF9, 0x0E, 0x20,
  0x30, 0xEF, 0xA8, 0x27, 0x01, 0xEB, 0x89, 0x0D, 0x74, 0x34, 0x8E, 0x10, 0x8B, 0x0C, 0x01, 0x71,
  0x0E, 0xB0, 0x27, 0x10, 0x4B, 0x0B, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x9B, 0x06, 0x72, 0x09, 0xB0,
  0x57, 0x20, 0x9B, 0x05, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x6B, 0x09, 0x72, 0x02, 0xB0, 0xE7, 0x30,
  0xCB, 0x09, 0x72, 0x04, 0xC8, 0x6B, 0x53, 0x35, 0x8D, 0x52, 0x09, 0xFB, 0x05, 0x30, 0x8F, 0xA0,
  0x54, 0x87, 0x28, 0xCE, 0xFE, 0xC9, 0x51,
  // "ć" (U+0107)
  0x71, 0x03, 0x80, 0x07, 0x71, 0x0D, 0xB0, 0x57, 0x08, 0xB0, 0x57, 0x03, 0xB0, 0x57, 0x18, 0x2D,
  0xFE, 0x37, 0x76, 0x87, 0x39, 0xDE, 0xFD, 0xC9, 0x43, 0x0A, 0xF9, 0x0C, 0x20, 0xAF, 0xA8, 0x16,
  0x04, 0xC8, 0x7A, 0x42, 0x36, 0xB1, 0x0A, 0xB0, 0x97, 0x10, 0xEB, 0x02, 0x71, 0xB0, 0xE7, 0x10,
  0x1B, 0x0D, 0x72, 0xB0, 0xE7, 0x20, 0xEB, 0x01, 0x71, 0x0B, 0xB0, 0x96, 0x81, 0x10, 0x6C, 0x85,
  0xA4, 0x24, 0x7C, 0x92, 0x0C, 0xFA, 0x09, 0x20, 0x10, 0xCF, 0x90, 0x94, 0x87, 0x5A, 0xDE, 0xFD,
  0xB7, 0x10,
  // "Ĉ" (U+0108)
  0x78, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x75, 0x87, 0x49, 0xCE, 0xFE,
  0xC8, 0x23, 0x02, 0x0C, 0xF9, 0x0E, 0x20, 0x30, 0xEF, 0xA8, 0x27, 0x01, 0xEB, 0x89, 0x0D, 0x74,
  0x34, 0x8E, 0x10, 0x8B, 0x0C, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x10, 0x4B, 0x0B, 0x72, 0x07, 0xB0,
  0x77, 0x20, 0x9B, 0x06, 0x72, 0x09, 0xB0, 0x57, 0x20, 0x9B, 0x05, 0x72, 0x08, 0xB0, 0x67, 0x20,
  0x6B, 0x09, 0x72, 0x02, 0xB0, 0xE7, 0x30, 0xCB, 0x09, 0x72, 0x04, 0xC8, 0x6B, 0x53, 0x35, 0x8D,
  0x52, 0x09, 0xFB, 0x05, 0x30, 0x8F, 0xA0, 0x54, 0x87, 0x28, 0xCE, 0xFE, 0xC9, 0x51,
  // "ĉ" (U+0109)
  0x68, 0x00, 0x70, 0x27, 0x06, 0xC0, 0xC6, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x50, 0xCA, 0x81, 0x51,
  0xDA, 0x03, 0x38, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x38, 0x73, 0x9D, 0xEF, 0xDC, 0x94,
  0x30, 0xAF, 0x90, 0xC2, 0x0A, 0xFA, 0x81, 0x60, 0x4C, 0x87, 0xA4, 0x23, 0x6B, 0x10, 0xAB, 0x09,
  0x71, 0x0E, 0xB0, 0x27, 0x1B, 0x0E, 0x71, 0x01, 0xB0, 0xD7, 0x2B, 0x0E, 0x72, 0x0E, 0xB0, 0x17,
  0x10, 0xBB, 0x09, 0x68, 0x11, 0x06, 0xC8, 0x5A, 0x42, 0x47, 0xC9, 0x20, 0xCF, 0xA0, 0x92, 0x01,
  0x0C, 0xF9, 0x09, 0x48, 0x75, 0xAD, 0xEF, 0xDB, 0x71,
  // "Ċ" (U+010A)
  0x78, 0x27, 0xEE, 0x97, 0x20, 0x2C, 0x04, 0x71, 0x04, 0xC0, 0x67, 0x10, 0x2C, 0x04, 0x72, 0x82,
  0x7E, 0xE9, 0x80, 0xC0, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x82, 0x30, 0x20, 0xCF, 0x90, 0xE2, 0x03,
  0x0E, 0xFA, 0x82, 0x70, 0x1E, 0xB8, 0x90, 0xD7, 0x43, 0x48, 0xE1, 0x08, 0xB0, 0xC0, 0x17, 0x10,
  0xEB, 0x02, 0x71, 0x04, 0xB0, 0xB7, 0x20, 0x7B, 0x07, 0x72, 0x09, 0xB0, 0x67, 0x20, 0x9B, 0x05,
  0x72, 0x09, 0xB0, 0x57, 0x20, 0x8B, 0x06, 0x72, 0x06, 0xB0, 0x97, 0x20, 0x2B, 0x0E, 0x73, 0x0C,
  0xB0, 0x97, 0x20, 0x4C, 0x86, 0xB5, 0x33, 0x58, 0xD5, 0x20, 0x9F, 0xB0, 0x53, 0x08, 0xFA, 0x05,
  0x48, 0x72, 0x8C, 0xEF, 0xEC, 0x95, 0x10,
  // "ċ" (U+010B)
  0x68, 0x27, 0xEE, 0x97, 0x10, 0x2C, 0x04, 0x70, 0x4C, 0x06, 0x70, 0x2C, 0x04, 0x71, 0x82, 0x7E,
  0xE9, 0x77, 0x68, 0x73, 0x9D, 0xEF, 0xDC, 0x94, 0x30, 0xAF, 0x90, 0xC2, 0x0A, 0xFA, 0x81, 0x60,
  0x4C, 0x87, 0xA4, 0x23, 0x6B, 0x10, 0xAB, 0x09, 0x71, 0x0E, 0xB0, 0x27, 0x1B, 0x0E, 0x71, 0x01,
  0xB0, 0xD7, 0x2B, 0x0E, 0x72, 0x0E, 0xB0, 0x17, 0x10, 0xBB, 0x09, 0x68, 0x11, 0x06, 0xC8, 0x5A,
  0x42, 0x47, 0xC9, 0x20, 0xCF, 0xA0, 0x92, 0x01, 0x0C, 0xF9, 0x09, 0x48, 0x75, 0xAD, 0xEF, 0xDB,
  0x71,
  // "Č" (U+010C)
  0x48, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x77, 0x77, 0x87, 0x49, 0xCE, 0xFE, 0xC8,
  0x23, 0x02, 0x0C, 0xF9, 0x0E, 0x20, 0x30, 0xEF, 0xA8, 0x27, 0x01, 0xEB, 0x89, 0x0D, 0x74, 0x34,
  0x8E, 0x10, 0x8B, 0x0C, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x10, 0x4B, 0x0B, 0x72, 0x07, 0xB0, 0x77,
  0x20, 0x9B, 0x06, 0x72, 0x09, 0xB0, 0x57, 0x20, 0x9B, 0x05, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x6B,
  0x09, 0x72, 0x02, 0xB0, 0xE7, 0x30, 0xCB, 0x09, 0x72, 0x04, 0xC8, 0x6B, 0x53, 0x35, 0x8D, 0x52,
  0x09, 0xFB, 0x05, 0x30, 0x8F, 0xA0, 0x54, 0x87, 0x28, 0xCE, 0xFE, 0xC9, 0x51,
  // "č" (U+010D)
  0x38, 0x16, 0x76, 0x48, 0x15, 0x77, 0x30, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x40, 0x8A, 0x0A, 0x08,
  0xA0, 0xB6, 0x0C, 0xC0, 0xE0, 0x16, 0x03, 0xC0, 0x67, 0x75, 0x87, 0x39, 0xDE, 0xFD, 0xC9, 0x43,
  0x0A, 0xF9, 0x0C, 0x20, 0xAF, 0xA8, 0x16, 0x04, 0xC8, 0x7A, 0x42, 0x36, 0xB1, 0x0A, 0xB0, 0x97,
  0x10, 0xEB, 0x02, 0x71, 0xB0, 0xE7, 0x10, 0x1B, 0x0D, 0x72, 0xB0, 0xE7, 0x20, 0xEB, 0x01, 0x71,
  0x0B, 0xB0, 0x96, 0x81, 0x10, 0x6C, 0x85, 0xA4, 0x24, 0x7C, 0x92, 0x0C, 0xFA, 0x09, 0x20, 0x10,
  0xCF, 0x90, 0x94, 0x87, 0x5A, 0xDE, 0xFD, 0xB7, 0x10,
  // "Ď" (U+010E)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x50, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x60, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x10, 0xCC, 0x0E, 0x01, 0x71, 0x03, 0xC0, 0x67, 0x77, 0x77, 0x0C, 0xE8, 0x1D, 0xA6,
  0x50, 0xCF, 0xA0, 0xD0, 0x33, 0x0C, 0xFC, 0x04, 0x20, 0xCB, 0x83, 0x32, 0x36, 0xDB, 0x82, 0xE1,
  0x0C, 0xB0, 0x14, 0x0C, 0xB8, 0x17, 0x0C, 0xB0, 0x14, 0x03, 0xB8, 0x1D, 0x0C, 0xB0, 0x15, 0x0D,
  0xB0, 0x10, 0xCB, 0x01, 0x50, 0xAB, 0x04, 0x0C, 0xB0, 0x15, 0x09, 0xB0, 0x50, 0xCB, 0x01, 0x50,
  0x9B, 0x05, 0x0C, 0xB0, 0x15, 0x09, 0xB0, 0x40, 0xCB, 0x01, 0x50, 0xBB, 0x03, 0x0C, 0xB0, 0x15,
  0x0E, 0xB1, 0x0C, 0xB0, 0x14, 0x05, 0xB8, 0x1C, 0x0C, 0xB0, 0x13, 0x01, 0x0D, 0xB8, 0x15, 0x0C,
  0xB8, 0x33, 0x23, 0x7E, 0xB0, 0xC2, 0x0C, 0xFB, 0x0E, 0x02, 0x20, 0xCF, 0xA0, 0xC0, 0x13, 0x0C,
  0xD8, 0x2E, 0xD9, 0x45,
  // "ď" (U+010F)
  0x72, 0x07, 0xB0, 0x50, 0x4B, 0x03, 0x72, 0x07, 0xB0, 0x50, 0x7A, 0x0B, 0x73, 0x07, 0xB0, 0x50,
  0xBA, 0x02, 0x73, 0x07, 0xB8, 0x25, 0xEF, 0x87, 0x40, 0x7B, 0x05, 0x77, 0x06, 0xB0, 0x57, 0x18,
  0x54, 0xBE, 0xEB, 0x35, 0xB0, 0x57, 0x06, 0xE0, 0x7B, 0x05, 0x60, 0x1F, 0xC0, 0x56, 0x08, 0xB8,
  0x2D, 0x43, 0x7C, 0x05, 0x60, 0xDB, 0x03, 0x30, 0xAB, 0x05, 0x6B, 0x0E, 0x40, 0x6B, 0x05, 0x50,
  0x1B, 0x0C, 0x40, 0x3B, 0x05, 0x50, 0x2B, 0x0C, 0x40, 0x2B, 0x05, 0x50, 0x1B, 0x0C, 0x40, 0x3B,
  0x05, 0x6B, 0x0E, 0x40, 0x5B, 0x05, 0x60, 0xDB, 0x04, 0x30, 0xAB, 0x05, 0x60, 0x8B, 0x82, 0xD4,
  0x39, 0xC0, 0x56, 0x02, 0xFC, 0x05, 0x70, 0x7D, 0x0D, 0x04, 0xB0, 0x57, 0x18, 0x65, 0xCE, 0xE9,
  0x10, 0xCA, 0x05, 0x50,
  // "Đ" (U+0110)
  0x10, 0xCE, 0x81, 0xDA, 0x66, 0x0C, 0xFA, 0x0D, 0x03, 0x40, 0xCF, 0xC0, 0x43, 0x0C, 0xB8, 0x33,
  0x23, 0x6D, 0xB0, 0xE0, 0x12, 0x0C, 0xB0, 0x14, 0x0C, 0xB0, 0x72, 0x0C, 0xB0, 0x14, 0x03, 0xB0,
  0xD2, 0x0C, 0xB0, 0x15, 0x0D, 0xB8, 0x11, 0x2C, 0xB8, 0x13, 0x22, 0x30, 0xAB, 0x04, 0xF0, 0xE3,
  0x09, 0xB0, 0x5F, 0x0E, 0x30, 0x9B, 0x05, 0xF0, 0xE3, 0x09, 0xB8, 0x14, 0x0C, 0xB0, 0x15, 0x0B,
  0xB8, 0x13, 0x0C, 0xB0, 0x15, 0x0E, 0xB2, 0x0C, 0xB0, 0x14, 0x05, 0xB0, 0xC2, 0x0C, 0xB0, 0x13,
  0x01, 0x0D, 0xB0, 0x52, 0x0C, 0xB8, 0x33, 0x23, 0x7E, 0xB0, 0xC3, 0x0C, 0xFB, 0x0E, 0x02, 0x30,
  0xCF, 0xA0, 0xC0, 0x14, 0x0C, 0xD8, 0x2E, 0xD9, 0x45,
  // "đ" (U+0111)
  0x72, 0x01, 0xB0, 0xB7, 0x40, 0x1B, 0x0B, 0x71, 0x0C, 0x0F, 0xDB, 0x81, 0xED, 0x26, 0x0E, 0xF9,
  0x03, 0x60, 0xEF, 0x90, 0x37, 0x20, 0x1B, 0x0B, 0x58, 0x47, 0xCE, 0xEB, 0x41, 0xB0, 0xB3, 0x01,
  0x0D, 0xE0, 0x70, 0xEA, 0x0B, 0x30, 0xBF, 0xC0, 0xB2, 0x03, 0xC8, 0x3A, 0x33, 0x6E, 0xB0, 0xB2,
  0x08, 0xB0, 0xB4, 0x06, 0xB0, 0xB2, 0x0B, 0xB0, 0x45, 0xB0, 0xB2, 0x0D, 0xB0, 0x15, 0x0D, 0xA0,
  0xB2, 0x0E, 0xB6, 0x0D, 0xA0, 0xB2, 0x0D, 0xB0, 0x15, 0x0D, 0xA0, 0xB2, 0x0B, 0xB0, 0x35, 0xB0,
  0xB2, 0x08, 0xB0, 0x94, 0x06, 0xB0, 0xB2, 0x03, 0xC8, 0x29, 0x43, 0x7C, 0x0B, 0x30, 0xCF, 0xC0,
  0xB3, 0x01, 0x0D, 0xE0, 0x40, 0xDA, 0x0B, 0x48, 0x71, 0x8D, 0xFE, 0xA2, 0x07, 0xA0, 0xB2,
  // "Ē" (U+0112)
  0x28, 0x04, 0x25, 0xF9, 0x03, 0x4F, 0x90, 0x34, 0xF9, 0x03, 0x80, 0xC5, 0x00, 0xDF, 0xC0, 0x40,
  0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0,
  0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0,
  0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0,
  0x40,
  // "ē" (U+0113)
  0x38, 0x04, 0x26, 0xF9, 0x03, 0x5F, 0x90, 0x35, 0xF9, 0x03, 0x77, 0x77, 0x58, 0x61, 0x7C, 0xEF,
  0xDA, 0x45, 0x04, 0x0E, 0xF0, 0xA3, 0x02, 0xFB, 0x09, 0x20, 0xCB, 0x83, 0xB4, 0x35, 0xDB, 0x00,
  0x2B, 0x0B, 0x40, 0x10, 0xEA, 0x00, 0x7B, 0x07, 0x80, 0x12, 0x0C, 0xA0, 0xB0, 0x8F, 0xD0, 0xC0,
  0x9F, 0xD0, 0xD0, 0x8F, 0xD0, 0xD0, 0x6B, 0x04, 0x72, 0x02, 0xB0, 0xB7, 0x30, 0xAB, 0x89, 0x2D,
  0x73, 0x23, 0x58, 0xC6, 0x01, 0xDF, 0xB0, 0x62, 0x02, 0x0C, 0xFA, 0x06, 0x48, 0x74, 0x9D, 0xEF,
  0xEC, 0xA5, 0x10,
  // "Ĕ" (U+0114)
  0x18, 0x12, 0x77, 0x48, 0x14, 0x75, 0x30, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x94, 0x0E, 0xF0, 0x34,
  0x05, 0xE0, 0x96, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x77, 0x20, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  0xDF, 0xC0, 0x40, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA,
  0x0E, 0x72, 0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDA, 0x0E, 0x80,
  0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20,
  0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // "ĕ" (U+0115)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xDA, 0x45, 0x04, 0x0E,
  0xF0, 0xA3, 0x02, 0xFB, 0x09, 0x20, 0xCB, 0x83, 0xB4, 0x35, 0xDB, 0x00, 0x2B, 0x0B, 0x40, 0x10,
  0xEA, 0x00, 0x7B, 0x07, 0x80, 0x12, 0x0C, 0xA0, 0xB0, 0x8F, 0xD0, 0xC0, 0x9F, 0xD0, 0xD0, 0x8F,
  0xD0, 0xD0, 0x6B, 0x04, 0x72, 0x02, 0xB0, 0xB7, 0x30, 0xAB, 0x89, 0x2D, 0x73, 0x23, 0x58, 0xC6,
  0x01, 0xDF, 0xB0, 0x62, 0x02, 0x0C, 0xFA, 0x06, 0x48, 0x74, 0x9D, 0xEF, 0xEC, 0xA5, 0x10,
  // "Ė" (U+0116)
  0x48, 0x27, 0xEE, 0x97, 0x10, 0x2C, 0x04, 0x70, 0x4C, 0x06, 0x70, 0x2C, 0x04, 0x71, 0x82, 0x7E,
  0xE9, 0x77, 0x77, 0x30, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDA, 0x0E, 0x80,
  0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xFB, 0x81, 0xE0,
  0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x80, 0x42, 0x10, 0xDF,
  0xC0, 0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // "ė" (U+0117)
  0x58, 0x27, 0xEE, 0x97, 0x20, 0x2C, 0x04, 0x71, 0x04, 0xC0, 0x67, 0x10, 0x2C, 0x04, 0x72, 0x82,
  0x7E, 0xE9, 0x77, 0x71, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x50, 0x40, 0xEF, 0x0A, 0x30, 0x2F, 0xB0,
  0x92, 0x0C, 0xB8, 0x3B, 0x43, 0x5D, 0xB0, 0x02, 0xB0, 0xB4, 0x01, 0x0E, 0xA0, 0x07, 0xB0, 0x78,
  0x01, 0x20, 0xCA, 0x0B, 0x08, 0xFD, 0x0C, 0x09, 0xFD, 0x0D, 0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x47,
  0x20, 0x2B, 0x0B, 0x73, 0x0A, 0xB8, 0x92, 0xD7, 0x32, 0x35, 0x8C, 0x60, 0x1D, 0xFB, 0x06, 0x20,
  0x20, 0xCF, 0xA0, 0x64, 0x87, 0x49, 0xDE, 0xFE, 0xCA, 0x51,
  // "Ę" (U+0118)
  0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0,
  0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0,
  0xDF, 0xB8, 0x1E, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D,
  0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xFC, 0x04, 0x0D, 0xFC,
  0x04, 0x0D, 0xFC, 0x04, 0x78, 0x21, 0xDF, 0x87, 0x28, 0x1B, 0xFC, 0x72, 0x02, 0xA0, 0x87, 0x20,
  0x3A, 0x81, 0xB2, 0x37, 0x10, 0xDB, 0x0C, 0x71, 0x83, 0x2B, 0xEE, 0xA1,
  // "ę" (U+0119)
  0x38, 0x61, 0x7C, 0xEF, 0xDA, 0x45, 0x04, 0x0E, 0xF0, 0xA3, 0x02, 0xFB, 0x08, 0x20, 0xCB, 0x83,
  0xB4, 0x35, 0xDB, 0x00, 0x2B, 0x0C, 0x40, 0x2B, 0x00, 0x7B, 0x05, 0x50, 0xBA, 0x0B, 0x08, 0xFD,
  0x0C, 0x09, 0xFD, 0x0D, 0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x58, 0x06, 0x2B, 0x0B, 0x73, 0x0A, 0xB8,
  0x92, 0xD7, 0x32, 0x35, 0x7B, 0x50, 0x1D, 0xFB, 0x06, 0x20, 0x20, 0xCF, 0xA0, 0x64, 0x82, 0x49,
  0xDE, 0xC0, 0xA7, 0x28, 0x21, 0xDF, 0x97, 0x38, 0x19, 0xFE, 0x74, 0x81, 0xEF, 0xB7, 0x48, 0x3E,
  0xFE, 0x33, 0x72, 0x0A, 0xC7, 0x28, 0x31, 0x9D, 0xFD, 0x10,
  // "Ě" (U+011A)
  0x18, 0x16, 0x76, 0x48, 0x15, 0x77, 0x30, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x40, 0x8A, 0x0A, 0x08,
  0xA0, 0xB6, 0x0C, 0xC0, 0xE0, 0x16, 0x03, 0xC0, 0x67, 0x77, 0x72, 0x0D, 0xFC, 0x04, 0x0D, 0xFC,
  0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72,
  0x0D, 0xA0, 0xE7, 0x20, 0xDF, 0xB8, 0x1E, 0x0D, 0xFB, 0x81, 0xE0, 0xDF, 0xB8, 0x1E, 0x0D, 0xA0,
  0xE8, 0x04, 0x21, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E, 0x72, 0x0D, 0xA0, 0xE7, 0x20, 0xDA, 0x0E,
  0x72, 0x0D, 0xA0, 0xE8, 0x04, 0x21, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  // "ě" (U+011B)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x77, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x50,
  0x40, 0xEF, 0x0A, 0x30, 0x2F, 0xB0, 0x92, 0x0C, 0xB8, 0x3B, 0x43, 0x5D, 0xB0, 0x02, 0xB0, 0xB4,
  0x01, 0x0E, 0xA0, 0x07, 0xB0, 0x78, 0x01, 0x20, 0xCA, 0x0B, 0x08, 0xFD, 0x0C, 0x09, 0xFD, 0x0D,
  0x08, 0xFD, 0x0D, 0x06, 0xB0, 0x47, 0x20, 0x2B, 0x0B, 0x73, 0x0A, 0xB8, 0x92, 0xD7, 0x32, 0x35,
  0x8C, 0x60, 0x1D, 0xFB, 0x06, 0x20, 0x20, 0xCF, 0xA0, 0x64, 0x87, 0x49, 0xDE, 0xFE, 0xCA, 0x51,
  // "Ĝ" (U+011C)
  0x78, 0x00, 0x70, 0x27, 0x20, 0x6C, 0x0C, 0x71, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x70, 0xCA, 0x81,
  0x51, 0xDA, 0x03, 0x58, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x80, 0xC0, 0x08, 0x73, 0x8C, 0xEF,
  0xED, 0xA5, 0x50, 0x9F, 0xA0, 0xA3, 0x0C, 0xFB, 0x03, 0x20, 0x9C, 0x85, 0xA5, 0x33, 0x59, 0xC2,
  0x02, 0xC0, 0x57, 0x20, 0x8B, 0x09, 0x73, 0x0C, 0xB0, 0x27, 0x3B, 0x0E, 0x73, 0x01, 0xB0, 0xC3,
  0x03, 0xE0, 0x2B, 0x0B, 0x30, 0x3E, 0x02, 0xB0, 0xB3, 0x03, 0xE0, 0x1B, 0x0D, 0x48, 0x12, 0x29,
  0xB1, 0x0D, 0xB0, 0x15, 0x08, 0xB1, 0x0A, 0xB0, 0x75, 0x08, 0xB1, 0x04, 0xB0, 0xE0, 0x34, 0x08,
  0xB2, 0x0B, 0xB8, 0x4E, 0x83, 0x23, 0xBB, 0x20, 0x20, 0xEF, 0xC3, 0x02, 0x0C, 0xFB, 0x58, 0x90,
  0x59, 0xDE, 0xFE, 0xDB, 0x72,
  // "ĝ" (U+011D)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x74, 0x87, 0x18, 0xDF, 0xEA, 0x30,
  0x7A, 0x82, 0xB0, 0x1D, 0xE0, 0x50, 0xDA, 0x81, 0xB0, 0xBF, 0xC0, 0xB0, 0x3C, 0x82, 0x93, 0x37,
  0xC0, 0xB0, 0x8B, 0x0A, 0x40, 0x8B, 0x00, 0xBB, 0x04, 0x40, 0x2B, 0x0B, 0x0D, 0xB0, 0x25, 0xB0,
  0xB0, 0xEB, 0x01, 0x50, 0xEA, 0x0B, 0x0D, 0xB0, 0x25, 0xB0, 0x0B, 0xB0, 0x44, 0x02, 0xB0, 0xB0,
  0x8B, 0x0A, 0x40, 0x7B, 0x0B, 0x03, 0xC8, 0x29, 0x33, 0x7C, 0x81, 0xB0, 0xBF, 0xC8, 0x2B, 0x01,
  0xDE, 0x07, 0xB0, 0xB2, 0x86, 0x18, 0xDF, 0xEA, 0x33, 0xB0, 0xB7, 0x20, 0x5B, 0x81, 0x90, 0x17,
  0x09, 0xB8, 0x90, 0x70, 0xDC, 0x74, 0x32, 0x49, 0xC8, 0x12, 0x0D, 0xFB, 0x08, 0x20, 0xDF, 0xA0,
  0x83, 0x82, 0x49, 0xCD, 0xA8, 0x2E, 0xB8, 0x23,
  // "Ğ" (U+011E)
  0x48, 0x12, 0x77, 0x48, 0x14, 0x75, 0x50, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x96, 0x0E, 0xF0, 0x36,
  0x05, 0xE0, 0x97, 0x18, 0x43, 0xBE, 0xFC, 0x68, 0x0C, 0x20, 0x87, 0x38, 0xCE, 0xFE, 0xDA, 0x55,
  0x09, 0xFA, 0x0A, 0x30, 0xCF, 0xB0, 0x32, 0x09, 0xC8, 0x5A, 0x53, 0x35, 0x9C, 0x20, 0x2C, 0x05,
  0x72, 0x08, 0xB0, 0x97, 0x30, 0xCB, 0x02, 0x73, 0xB0, 0xE7, 0x30, 0x1B, 0x0C, 0x30, 0x3E, 0x02,
  0xB0, 0xB3, 0x03, 0xE0, 0x2B, 0x0B, 0x30, 0x3E, 0x01, 0xB0, 0xD4, 0x81, 0x22, 0x9B, 0x10, 0xDB,
  0x01, 0x50, 0x8B, 0x10, 0xAB, 0x07, 0x50, 0x8B, 0x10, 0x4B, 0x0E, 0x03, 0x40, 0x8B, 0x20, 0xBB,
  0x84, 0xE8, 0x32, 0x3B, 0xB2, 0x02, 0x0E, 0xFC, 0x30, 0x20, 0xCF, 0xB5, 0x89, 0x05, 0x9D, 0xEF,
  0xED, 0xB7, 0x20,
  // "ğ" (U+011F)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x68, 0x71, 0x8D, 0xFE, 0xA3, 0x07, 0xA8, 0x2B,
  0x01, 0xDE, 0x05, 0x0D, 0xA8, 0x1B, 0x0B, 0xFC, 0x0B, 0x03, 0xC8, 0x29, 0x33, 0x7C, 0x0B, 0x08,
  0xB0, 0xA4, 0x08, 0xB0, 0x0B, 0xB0, 0x44, 0x02, 0xB0, 0xB0, 0xDB, 0x02, 0x5B, 0x0B, 0x0E, 0xB0,
  0x15, 0x0E, 0xA0, 0xB0, 0xDB, 0x02, 0x5B, 0x00, 0xBB, 0x04, 0x40, 0x2B, 0x0B, 0x08, 0xB0, 0xA4,
  0x07, 0xB0, 0xB0, 0x3C, 0x82, 0x93, 0x37, 0xC8, 0x1B, 0x0B, 0xFC, 0x82, 0xB0, 0x1D, 0xE0, 0x7B,
  0x0B, 0x28, 0x61, 0x8D, 0xFE, 0xA3, 0x3B, 0x0B, 0x72, 0x05, 0xB8, 0x19, 0x01, 0x70, 0x9B, 0x89,
  0x07, 0x0D, 0xC7, 0x43, 0x24, 0x9C, 0x81, 0x20, 0xDF, 0xB0, 0x82, 0x0D, 0xFA, 0x08, 0x38, 0x24,
  0x9C, 0xDA, 0x82, 0xEB, 0x82, 0x30,
  // "Ġ" (U+0120)
  0x78, 0x27, 0xEE, 0x97, 0x30, 0x2C, 0x04, 0x72, 0x04, 0xC0, 0x67, 0x20, 0x2C, 0x04, 0x73, 0x82,
  0x7E, 0xE9, 0x80, 0xC3, 0x08, 0x73, 0x8C, 0xEF, 0xED, 0xA5, 0x50, 0x9F, 0xA0, 0xA3, 0x0C, 0xFB,
  0x03, 0x20, 0x9C, 0x85, 0xA5, 0x33, 0x59, 0xC2, 0x02, 0xC0, 0x57, 0x20, 0x8B, 0x09, 0x73, 0x0C,
  0xB0, 0x27, 0x3B, 0x0E, 0x73, 0x01, 0xB0, 0xC3, 0x03, 0xE0, 0x2B, 0x0B, 0x30, 0x3E, 0x02, 0xB0,
  0xB3, 0x03, 0xE0, 0x1B, 0x0D, 0x48, 0x12, 0x29, 0xB1, 0x0D, 0xB0, 0x15, 0x08, 0xB1, 0x0A, 0xB0,
  0x75, 0x08, 0xB1, 0x04, 0xB0, 0xE0, 0x34, 0x08, 0xB2, 0x0B, 0xB8, 0x4E, 0x83, 0x23, 0xBB, 0x20,
  0x20, 0xEF, 0xC3, 0x02, 0x0C, 0xFB, 0x58, 0x90, 0x59, 0xDE, 0xFE, 0xDB, 0x72,
  // "ġ" (U+0121)
  0x58, 0x27, 0xEE, 0x97, 0x20, 0x2C, 0x04, 0x71, 0x04, 0xC0, 0x67, 0x10, 0x2C, 0x04, 0x72, 0x82,
  0x7E, 0xE9, 0x77, 0x78, 0x71, 0x8D, 0xFE, 0xA3, 0x07, 0xA8, 0x2B, 0x01, 0xDE, 0x05, 0x0D, 0xA8,
  0x1B, 0x0B, 0xFC, 0x0B, 0x03, 0xC8, 0x29, 0x33, 0x7C, 0x0B, 0x08, 0xB0, 0xA4, 0x08, 0xB0, 0x0B,
  0xB0, 0x44, 0x02, 0xB0, 0xB0, 0xDB, 0x02, 0x5B, 0x0B, 0x0E, 0xB0, 0x15, 0x0E, 0xA0, 0xB0, 0xDB,
  0x02, 0x5B, 0x00, 0xBB, 0x04, 0x40, 0x2B, 0x0B, 0x08, 0xB0, 0xA4, 0x07, 0xB0, 0xB0, 0x3C, 0x82,
  0x93, 0x37, 0xC8, 0x1B, 0x0B, 0xFC, 0x82, 0xB0, 0x1D, 0xE0, 0x7B, 0x0B, 0x28, 0x61, 0x8D, 0xFE,
  0xA3, 0x3B, 0x0B, 0x72, 0x05, 0xB8, 0x19, 0x01, 0x70, 0x9B, 0x89, 0x07, 0x0D, 0xC7, 0x43, 0x24,
  0x9C, 0x81, 0x20, 0xDF, 0xB0, 0x82, 0x0D, 0xFA, 0x08, 0x38, 0x24, 0x9C, 0xDA, 0x82, 0xEB, 0x82,
  0x30,
  // "Ģ" (U+0122)
  0x58, 0x73, 0x8C, 0xEF, 0xED, 0xA5, 0x50, 0x9F, 0xA0, 0xA3, 0x0C, 0xFB, 0x03, 0x20, 0x9C, 0x85,
  0xA5, 0x33, 0x59, 0xC2, 0x02, 0xC0, 0x57, 0x20, 0x8B, 0x09, 0x73, 0x0C, 0xB0, 0x27, 0x3B, 0x0E,
  0x73, 0x01, 0xB0, 0xC3, 0x03, 0xE0, 0x2B, 0x0B, 0x30, 0x3E, 0x02, 0xB0, 0xB3, 0x03, 0xE0, 0x1B,
  0x0D, 0x48, 0x12, 0x29, 0xB1, 0x0D, 0xB0, 0x15, 0x08, 0xB1, 0x0A, 0xB0, 0x75, 0x08, 0xB1, 0x04,
  0xB0, 0xE0, 0x34, 0x08, 0xB2, 0x0B, 0xB8, 0x4E, 0x83, 0x23, 0xBB, 0x20, 0x20, 0xEF, 0xC3, 0x02,
  0x0C, 0xFB, 0x58, 0x90, 0x59, 0xDE, 0xFE, 0xDB, 0x72, 0x80, 0xC1, 0x00, 0xEA, 0x09, 0x73, 0x01,
  0xB0, 0x27, 0x30, 0x5A, 0x08, 0x74, 0x81, 0x9F, 0xD6,
  // "ģ" (U+0123)
  0x60, 0x3A, 0x03, 0x73, 0x81, 0xDF, 0xE7, 0x30, 0x7A, 0x0B, 0x73, 0x0E, 0xA0, 0x87, 0x77, 0x77,
  0x87, 0x18, 0xDF, 0xEA, 0x30, 0x7A, 0x82, 0xB0, 0x1D, 0xE0, 0x50, 0xDA, 0x81, 0xB0, 0xBF, 0xC0,
  0xB0, 0x3C, 0x82, 0x93, 0x37, 0xC0, 0xB0, 0x8B, 0x0A, 0x40, 0x8B, 0x00, 0xBB, 0x04, 0x40, 0x2B,
  0x0B, 0x0D, 0xB0, 0x25, 0xB0, 0xB0, 0xEB, 0x01, 0x50, 0xEA, 0x0B, 0x0D, 0xB0, 0x25, 0xB0, 0x0B,
  0xB0, 0x44, 0x02, 0xB0, 0xB0, 0x8B, 0x0A, 0x40, 0x7B, 0x0B, 0x03, 0xC8, 0x29, 0x33, 0x7C, 0x81,
  0xB0, 0xBF, 0xC8, 0x2B, 0x01, 0xDE, 0x07, 0xB0, 0xB2, 0x86, 0x18, 0xDF, 0xEA, 0x33, 0xB0, 0xB7,
  0x20, 0x5B, 0x81, 0x90, 0x17, 0x09, 0xB8, 0x90, 0x70, 0xDC, 0x74, 0x32, 0x49, 0xC8, 0x12, 0x0D,
  0xFB, 0x08, 0x20, 0xDF, 0xA0, 0x83, 0x82, 0x49, 0xCD, 0xA8, 0x2E, 0xB8, 0x23,
  // "Ĥ" (U+0124)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x72, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCF, 0xE0, 0xCF, 0xE0,
  0xCF, 0xE0, 0xCB, 0x04, 0x80, 0x12, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  // "ĥ" (U+0125)
  0x38, 0x00, 0x70, 0x27, 0x40, 0x6C, 0x0C, 0x73, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x72, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x37, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x60, 0x8B, 0x06, 0x75,
  0x08, 0xB0, 0x67, 0x50, 0x8B, 0x06, 0x75, 0x08, 0xB0, 0x67, 0x50, 0x8B, 0x06, 0x75, 0x08, 0xB0,
  0x57, 0x50, 0x8B, 0x86, 0x51, 0x8D, 0xFE, 0xB5, 0x50, 0x8B, 0x06, 0x0D, 0xE0, 0x84, 0x08, 0xFD,
  0x03, 0x30, 0x8C, 0x83, 0xC4, 0x36, 0xEB, 0x09, 0x30, 0x8B, 0x0E, 0x01, 0x30, 0x5B, 0x0C, 0x30,
  0x8B, 0x0A, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x07, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B,
  0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06,
  0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x30,
  0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x30, 0x8B, 0x06, 0x40, 0x1B, 0x0D,
  // "Ħ" (U+0126)
  0x10, 0x7B, 0x07, 0x40, 0x3B, 0x0A, 0x30, 0x7B, 0x07, 0x40, 0x3B, 0x0A, 0x2F, 0xFA, 0x03, 0xFF,
  0xA0, 0x3F, 0xFA, 0x81, 0x32, 0x8B, 0x84, 0x82, 0x22, 0x25, 0xB0, 0xB0, 0x22, 0x07, 0xB0, 0x74,
  0x03, 0xB0, 0xA3, 0x07, 0xFD, 0x0A, 0x30, 0x7F, 0xD0, 0xA3, 0x07, 0xFD, 0x0A, 0x30, 0x7B, 0x84,
  0x82, 0x22, 0x25, 0xB0, 0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0, 0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0,
  0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0, 0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0, 0xA3, 0x07, 0xB0, 0x74,
  0x03, 0xB0, 0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0, 0xA3, 0x07, 0xB0, 0x74, 0x03, 0xB0, 0xA3, 0x07,
  0xB0, 0x74, 0x03, 0xB0, 0xA2,
  // "ħ" (U+0127)
  0x10, 0x8B, 0x06, 0x73, 0x08, 0xB0, 0x67, 0x20, 0xD0, 0xEB, 0x83, 0xED, 0xDD, 0x55, 0xFA, 0x06,
  0x5F, 0xA0, 0x66, 0x08, 0xB0, 0x67, 0x30, 0x8B, 0x86, 0x51, 0x8D, 0xFE, 0xB5, 0x30, 0x8B, 0x06,
  0x0D, 0xE0, 0x82, 0x08, 0xFD, 0x81, 0x30, 0x8C, 0x83, 0xC4, 0x36, 0xEB, 0x81, 0x90, 0x8B, 0x0E,
  0x01, 0x30, 0x5B, 0x81, 0xB0, 0x8B, 0x0A, 0x40, 0x2B, 0x81, 0xC0, 0x8B, 0x07, 0x40, 0x1B, 0x81,
  0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B,
  0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x81, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D,
  // "Ĩ" (U+0128)
  0x28, 0x38, 0xEE, 0x92, 0x28, 0x3D, 0xF2, 0x05, 0xD8, 0x2C, 0xBF, 0xE2, 0x82, 0xBF, 0xCB, 0xD0,
  0x82, 0x87, 0xEF, 0x10, 0x18, 0xDE, 0x97, 0x77, 0x50, 0x8F, 0xB0, 0xB0, 0x8F, 0xB8, 0x2B, 0x6C,
  0xEE, 0x81, 0xED, 0x84, 0x0C, 0xA0, 0xE0, 0x17, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7,
  0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA,
  0x0E, 0x48, 0x16, 0xCD, 0xE8, 0x2E, 0xC8, 0x8F, 0xB0, 0xB0, 0x8F, 0xB0, 0xB0,
  // "ĩ" (U+0129)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x40, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F,
  0x07, 0x78, 0x11, 0x39, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07,
  0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01,
  0x09, 0xB0, 0x90, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "Ī" (U+012A)
  0x28, 0x04, 0x24, 0xF9, 0x03, 0x3F, 0x90, 0x33, 0xF9, 0x03, 0x80, 0xC1, 0x00, 0x8F, 0xB0, 0xB0,
  0x8F, 0xB8, 0x2B, 0x6C, 0xEE, 0x81, 0xED, 0x84, 0x0C, 0xA0, 0xE0, 0x17, 0x0C, 0xA0, 0xE7, 0x10,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x48, 0x16, 0xCD, 0xE8, 0x2E, 0xC8, 0x8F, 0xB0, 0xB0, 0x8F, 0xB0,
  0xB0,
  // "ī" (U+012B)
  0x38, 0x04, 0x26, 0xF9, 0x03, 0x5F, 0x90, 0x35, 0xF9, 0x03, 0x77, 0x77, 0x30, 0xAF, 0x07, 0x50,
  0xAF, 0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0,
  0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20,
  0x7B, 0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0,
  0xD0, 0x5F, 0xD0, 0xD0,
  // "Ĭ" (U+012C)
  0x18, 0x12, 0x77, 0x48, 0x14, 0x75, 0x20, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x93, 0x0E, 0xF0, 0x33,
  0x05, 0xE0, 0x95, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x76, 0x08, 0xFB, 0x0B, 0x08, 0xFB, 0x82, 0xB6,
  0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E, 0x01, 0x70, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC, 0x88, 0xFB, 0x0B, 0x08, 0xFB, 0x0B,
  // "ĭ" (U+012D)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x50, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F,
  0x07, 0x78, 0x11, 0x39, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07,
  0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01,
  0x09, 0xB0, 0x90, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "Į" (U+012E)
  0x08, 0xFB, 0x0B, 0x08, 0xFB, 0x82, 0xB6, 0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E, 0x01, 0x70,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C,
  0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC, 0x88, 0xFB,
  0x0B, 0x08, 0xFB, 0x0B, 0x58, 0x21, 0xDF, 0x87, 0x18, 0x1B, 0xFC, 0x71, 0x02, 0xA0, 0x87, 0x10,
  0x3A, 0x81, 0xB2, 0x37, 0x0D, 0xB0, 0xC7, 0x83, 0x2B, 0xEE, 0xA2,
  // "į" (U+012F)
  0x58, 0x32, 0xCE, 0xC3, 0x72, 0x0A, 0xB0, 0xB7, 0x20, 0xCB, 0x0D, 0x72, 0x0A, 0xB0, 0xB7, 0x28,
  0x32, 0xCE, 0xC3, 0x77, 0x50, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39,
  0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77,
  0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13,
  0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD7, 0x18, 0x21, 0xDF, 0x87,
  0x38, 0x1B, 0xFC, 0x73, 0x02, 0xA0, 0x87, 0x30, 0x3A, 0x81, 0xB2, 0x37, 0x20, 0xDB, 0x0C, 0x72,
  0x83, 0x2B, 0xEE, 0xA1,
  // "İ" (U+0130)
  0x48, 0x27, 0xEE, 0x97, 0x02, 0xC0, 0x46, 0x04, 0xC0, 0x66, 0x02, 0xC0, 0x47, 0x82, 0x7E, 0xE9,
  0x77, 0x77, 0x08, 0xFB, 0x0B, 0x08, 0xFB, 0x82, 0xB6, 0xCE, 0xE8, 0x1E, 0xD8, 0x40, 0xCA, 0x0E,
  0x01, 0x70, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10,
  0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E,
  0x71, 0x0C, 0xA0, 0xE7, 0x10, 0xCA, 0x0E, 0x71, 0x0C, 0xA0, 0xE4, 0x81, 0x6C, 0xDE, 0x82, 0xEC,
  0x88, 0xFB, 0x0B, 0x08, 0xFB, 0x0B,
  // "ı" (U+0131)
  0x10, 0xAF, 0x07, 0x50, 0xAF, 0x07, 0x50, 0x8F, 0x07, 0x78, 0x11, 0x39, 0xB0, 0x77, 0x20, 0x7B,
  0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72, 0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x72,
  0x07, 0xB0, 0x77, 0x20, 0x7B, 0x07, 0x71, 0x01, 0x09, 0xB0, 0x90, 0x13, 0x82, 0x29, 0xCE, 0xF8,
  0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD0,
  // "Ĳ" (U+0132)
  0x0A, 0xB4, 0x0E, 0xA0, 0xE0, 0xAB, 0x40, 0xEA, 0x0E, 0x0A, 0xB4, 0x0E, 0xA0, 0xE0, 0xAB, 0x40,
  0xEA, 0x0E, 0x0A, 0xB4, 0x0E, 0xA0, 0xE0, 0xAB, 0x40, 0xEA, 0x0E, 0x0A, 0xB4, 0x0E, 0xA0, 0xE0,
  0xAB, 0x40, 0xEA, 0x0E, 0x0A, 0xB4, 0x0E, 0xA0, 0xE0, 0xAB, 0x40, 0xEA, 0x0E, 0x0A, 0xB4, 0x0E,
  0xA0, 0xE0, 0xAB, 0x40, 0xEA, 0x0E, 0x0A, 0xB4, 0x0E, 0xA0, 0xD7, 0x01, 0xB0, 0xC7, 0x06, 0xB8,
  0x7A, 0x67, 0x53, 0x23, 0x7E, 0xB0, 0x50, 0xAF, 0xA8, 0x1C, 0x0A, 0xF9, 0x89, 0x2C, 0x10, 0x5A,
  0xDE, 0xFE, 0xDA, 0x53,
  // "ĳ" (U+0133)
  0x83, 0x3C, 0xEB, 0x23, 0x84, 0xAE, 0xD5, 0x0C, 0xB0, 0x92, 0x06, 0xB8, 0x1E, 0x0E, 0xB0, 0xB2,
  0x08, 0xC0, 0x20, 0xCB, 0x09, 0x20, 0x6B, 0x85, 0xE0, 0x3D, 0xEB, 0x13, 0x82, 0xAE, 0xD5, 0x77,
  0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02,
  0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0,
  0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B,
  0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02,
  0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0,
  0x42, 0x02, 0xB8, 0x1B, 0x09, 0xB0, 0x42, 0x02, 0xB0, 0xB7, 0x10, 0x4B, 0x0B, 0x71, 0x08, 0xB0,
  0x92, 0x84, 0x65, 0x32, 0x38, 0xC0, 0x52, 0x0B, 0xF9, 0x0E, 0x30, 0xBF, 0x0E, 0x03, 0x38, 0x76,
  0xBD, 0xEF, 0xEC, 0x71, 0x30,
  // "Ĵ" (U+0134)
  0x78, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x77, 0x09, 0xB0, 0x37, 0x20,
  0x9B, 0x03, 0x72, 0x09, 0xB0, 0x37, 0x20, 0x9B, 0x03, 0x72, 0x09, 0xB0, 0x37, 0x20, 0x9B, 0x03,
  0x72, 0x09, 0xB0, 0x37, 0x20, 0x9B, 0x03, 0x72, 0x09, 0xB0, 0x37, 0x20, 0x9B, 0x03, 0x72, 0x09,
  0xB0, 0x37, 0x20, 0x9B, 0x03, 0x72, 0x09, 0xB0, 0x37, 0x20, 0xBB, 0x02, 0x71, 0x01, 0xB0, 0xE3,
  0x85, 0x67, 0x42, 0x35, 0xDB, 0x0A, 0x30, 0xAF, 0xA0, 0x33, 0x0A, 0xF9, 0x05, 0x48, 0x76, 0xBD,
  0xEF, 0xEC, 0x82, 0x50,
  // "ĵ" (U+0135)
  0x68, 0x00, 0x70, 0x27, 0x06, 0xC0, 0xC6, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x50, 0xCA, 0x81, 0x51,
  0xDA, 0x03, 0x38, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x10, 0x8F, 0x09, 0x40, 0x8F, 0x09,
  0x40, 0x7F, 0x09, 0x68, 0x12, 0x38, 0xB0, 0x97, 0x10, 0x5B, 0x09, 0x71, 0x05, 0xB0, 0x97, 0x10,
  0x5B, 0x09, 0x71, 0x05, 0xB0, 0x97, 0x10, 0x5B, 0x09, 0x71, 0x05, 0xB0, 0x97, 0x10, 0x5B, 0x09,
  0x71, 0x05, 0xB0, 0x97, 0x10, 0x5B, 0x09, 0x71, 0x05, 0xB0, 0x97, 0x10, 0x5B, 0x09, 0x71, 0x06,
  0xB0, 0x87, 0x10, 0xAB, 0x07, 0x28, 0x48, 0x53, 0x24, 0x9C, 0x03, 0x20, 0xEF, 0x90, 0xC3, 0x0E,
  0xF0, 0xD0, 0x23, 0x86, 0x7B, 0xDE, 0xFE, 0xB7, 0x50,
  // "Ķ" (U+0136)
  0x0C, 0xB5, 0x05, 0xB0, 0xD0, 0xCB, 0x40, 0x10, 0xEB, 0x03, 0x0C, 0xB4, 0x0A, 0xB8, 0x17, 0x0C,
  0xB3, 0x05, 0xB0, 0xB2, 0x0C, 0xB2, 0x01, 0x0E, 0xA0, 0xE0, 0x12, 0x0C, 0xB2, 0x0B, 0xB0, 0x53,
  0x0C, 0xB1, 0x05, 0xB0, 0x94, 0x0C, 0xB0, 0x10, 0xEA, 0x0D, 0x50, 0xCB, 0x09, 0xB0, 0x55, 0x0C,
  0xF0, 0xB5, 0x0C, 0xF9, 0x05, 0x40, 0xCC, 0x08, 0xB0, 0xD4, 0x0C, 0xB8, 0x15, 0x0A, 0xB0, 0x73,
  0x0C, 0xB2, 0x02, 0xB0, 0xE0, 0x12, 0x0C, 0xB3, 0x09, 0xB0, 0x92, 0x0C, 0xB3, 0x01, 0x0E, 0xB8,
  0x12, 0x0C, 0xB4, 0x08, 0xB8, 0x1B, 0x0C, 0xB5, 0x0E, 0xB0, 0x40, 0xCB, 0x50, 0x6B, 0x0C, 0x77,
  0x77, 0x50, 0xEA, 0x09, 0x72, 0x01, 0xB0, 0x27, 0x20, 0x5A, 0x08, 0x73, 0x81, 0x9F, 0xD7,
  // "ķ" (U+0137)
  0x05, 0xB0, 0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0, 0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0,
  0x87, 0x30, 0x5B, 0x08, 0x73, 0x05, 0xB0, 0x84, 0x07, 0xB8, 0x1D, 0x15, 0xB0, 0x83, 0x05, 0xB8,
  0x2E, 0x30, 0x5B, 0x08, 0x20, 0x30, 0xEB, 0x04, 0x20, 0x5B, 0x82, 0x80, 0x1D, 0xB0, 0x63, 0x05,
  0xB8, 0x17, 0x0C, 0xB0, 0x84, 0x05, 0xB0, 0x60, 0x9B, 0x0A, 0x50, 0x5B, 0x0A, 0xC0, 0x45, 0x05,
  0xF9, 0x0D, 0x50, 0x5D, 0x0E, 0xB0, 0x84, 0x05, 0xC8, 0x19, 0x1D, 0xB0, 0x33, 0x05, 0xB0, 0x92,
  0x04, 0xB0, 0xC3, 0x05, 0xB0, 0x83, 0x0A, 0xB0, 0x72, 0x05, 0xB0, 0x83, 0x01, 0x0E, 0xB8, 0x12,
  0x05, 0xB0, 0x84, 0x05, 0xB8, 0x1C, 0x05, 0xB0, 0x85, 0x0B, 0xB0, 0x78, 0x0C, 0x00, 0x0E, 0xA0,
  0x97, 0x30, 0x1B, 0x02, 0x73, 0x05, 0xA0, 0x87, 0x48, 0x19, 0xFD, 0x70,
  // "ĸ" (U+0138)
  0x05, 0xB0, 0x84, 0x07, 0xB8, 0x1D, 0x15, 0xB0, 0x83, 0x05, 0xB8, 0x2E, 0x30, 0x5B, 0x08, 0x20,
  0x30, 0xEB, 0x04, 0x20, 0x5B, 0x82, 0x80, 0x1D, 0xB0, 0x63, 0x05, 0xB8, 0x17, 0x0C, 0xB0, 0x84,
  0x05, 0xB0, 0x60, 0x9B, 0x0A, 0x50, 0x5B, 0x0A, 0xC0, 0x45, 0x05, 0xF9, 0x0D, 0x50, 0x5D, 0x0E,
  0xB0, 0x84, 0x05, 0xC8, 0x19, 0x1D, 0xB0, 0x33, 0x05, 0xB0, 0x92, 0x04, 0xB0, 0xC3, 0x05, 0xB0,
  0x83, 0x0A, 0xB0, 0x72, 0x05, 0xB0, 0x83, 0x01, 0x0E, 0xB8, 0x12, 0x05, 0xB0, 0x84, 0x05, 0xB8,
  0x1C, 0x05, 0xB0, 0x85, 0x0B, 0xB0, 0x70,
  // "Ĺ" (U+0139)
  0x20, 0x38, 0x00, 0x77, 0x10, 0xDB, 0x05, 0x70, 0x8B, 0x05, 0x70, 0x3B, 0x05, 0x71, 0x82, 0xDF,
  0xE3, 0x77, 0x77, 0x70, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0,
  0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10,
  0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05,
  0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x68, 0x03, 0x21, 0x08, 0xFC, 0x04,
  0x08, 0xFC, 0x04, 0x08, 0xFC, 0x04,
  // "ĺ" (U+013A)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x60, 0x6F, 0x06, 0x50, 0x6F, 0x06, 0x50, 0x40, 0xDE, 0x06, 0x71, 0x04, 0x0B,
  0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67,
  0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B,
  0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x71,
  0x01, 0x09, 0xB0, 0x80, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0,
  0xD0,
  // "Ļ" (U+013B)
  0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0,
  0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10,
  0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05,
  0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x06, 0x80, 0x32, 0x10, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40,
  0x8F, 0xC0, 0x47, 0x77, 0x73, 0x0E, 0xA0, 0x97, 0x10, 0x1B, 0x02, 0x71, 0x05, 0xA0, 0x87, 0x28,
  0x19, 0xFD, 0x60,
  // "ļ" (U+013C)
  0x10, 0x6F, 0x06, 0x50, 0x6F, 0x06, 0x50, 0x40, 0xDE, 0x06, 0x71, 0x04, 0x0B, 0xB0, 0x67, 0x20,
  0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06,
  0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08,
  0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x71, 0x01, 0x09, 0xB0,
  0x80, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0, 0x5F, 0xD0, 0xD7, 0x77, 0x76,
  0x0E, 0xA0, 0x97, 0x20, 0x1B, 0x02, 0x72, 0x05, 0xA0, 0x87, 0x38, 0x19, 0xFD, 0x60,
  // "Ľ" (U+013D)
  0x08, 0xB0, 0x53, 0x07, 0xA8, 0x1E, 0x18, 0xB0, 0x53, 0x0A, 0xA8, 0x18, 0x08, 0xB0, 0x53, 0x81,
  0xEF, 0xD2, 0x08, 0xB0, 0x52, 0x02, 0xA0, 0x52, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08,
  0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57,
  0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B,
  0x06, 0x80, 0x32, 0x10, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40,
  // "ľ" (U+013E)
  0x10, 0x6F, 0x81, 0x60, 0x9A, 0x81, 0xD0, 0x6F, 0x81, 0x60, 0xCA, 0x84, 0x60, 0x16, 0x9C, 0xC0,
  0x61, 0xA0, 0xC6, 0x08, 0xB0, 0x60, 0x4A, 0x03, 0x60, 0x8B, 0x06, 0x73, 0x08, 0xB0, 0x67, 0x30,
  0x8B, 0x06, 0x73, 0x08, 0xB0, 0x67, 0x30, 0x8B, 0x06, 0x73, 0x08, 0xB0, 0x67, 0x30, 0x8B, 0x06,
  0x73, 0x08, 0xB0, 0x67, 0x30, 0x8B, 0x06, 0x73, 0x08, 0xB0, 0x67, 0x30, 0x8B, 0x06, 0x73, 0x08,
  0xB0, 0x67, 0x30, 0x8B, 0x06, 0x72, 0x03, 0x0A, 0xB0, 0x90, 0x24, 0x81, 0x3A, 0xDF, 0xA8, 0x2C,
  0x80, 0x5F, 0xD8, 0x1D, 0x05, 0xFD, 0x0D, 0x10,
  // "Ŀ" (U+013F)
  0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0,
  0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x53, 0x84, 0x7E, 0xE9, 0x08, 0xB0, 0x52, 0x02, 0xC0,
  0x50, 0x8B, 0x05, 0x20, 0x5C, 0x07, 0x08, 0xB0, 0x52, 0x02, 0xC0, 0x40, 0x8B, 0x05, 0x38, 0x46,
  0xEE, 0x80, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10,
  0x8B, 0x06, 0x80, 0x32, 0x10, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40, 0x8F, 0xC0, 0x40,
  // "ŀ" (U+0140)
  0x10, 0x6F, 0x06, 0x72, 0x06, 0xF0, 0x67, 0x20, 0x40, 0xDE, 0x06, 0x75, 0x04, 0x0B, 0xB0, 0x67,
  0x60, 0x8B, 0x06, 0x76, 0x08, 0xB0, 0x67, 0x60, 0x8B, 0x06, 0x76, 0x08, 0xB0, 0x67, 0x60, 0x8B,
  0x06, 0x38, 0x27, 0xEE, 0x96, 0x08, 0xB0, 0x62, 0x02, 0xC0, 0x55, 0x08, 0xB0, 0x62, 0x05, 0xC0,
  0x75, 0x08, 0xB0, 0x62, 0x02, 0xC0, 0x45, 0x08, 0xB0, 0x63, 0x82, 0x6E, 0xE8, 0x60, 0x8B, 0x06,
  0x76, 0x08, 0xB0, 0x67, 0x60, 0x8B, 0x06, 0x76, 0x08, 0xB0, 0x67, 0x50, 0x10, 0x9B, 0x08, 0x01,
  0x78, 0x22, 0x9C, 0xEF, 0x81, 0xDB, 0x74, 0x05, 0xFD, 0x0D, 0x40, 0x5F, 0xD0, 0xD4,
  // "Ł" (U+0141)
  0x20, 0x7B, 0x06, 0x73, 0x07, 0xB0, 0x67, 0x30, 0x7B, 0x06, 0x73, 0x07, 0xB0, 0x67, 0x30, 0x7B,
  0x06, 0x73, 0x07, 0xB0, 0x67, 0x30, 0x7B, 0x81, 0x8A, 0xD7, 0x10, 0x7E, 0x07, 0x70, 0x7E, 0x07,
  0x60, 0x10, 0xBC, 0x0B, 0x02, 0x60, 0x50, 0xEC, 0x08, 0x71, 0x08, 0xD0, 0x67, 0x18, 0x11, 0xEE,
  0xB0, 0x67, 0x20, 0x20, 0x7B, 0x06, 0x73, 0x07, 0xB0, 0x67, 0x30, 0x7B, 0x07, 0x80, 0x32, 0x30,
  0x7F, 0xC0, 0x62, 0x07, 0xFC, 0x06, 0x20, 0x7F, 0xC0, 0x60,
  // "ł" (U+0142)
  0x10, 0x6F, 0x06, 0x50, 0x6F, 0x06, 0x50, 0x40, 0xDE, 0x06, 0x71, 0x04, 0x0B, 0xB0, 0x67, 0x20,
  0x8B, 0x06, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x72, 0x08, 0xB8, 0x16, 0x74, 0x70, 0x8B,
  0x81, 0xEF, 0xD7, 0x08, 0xE0, 0x56, 0x09, 0xC0, 0xE0, 0x55, 0x02, 0x0B, 0xC0, 0xA6, 0x06, 0x0E,
  0xD0, 0x66, 0x07, 0xE0, 0x67, 0x81, 0xDA, 0x9B, 0x06, 0x78, 0x11, 0x08, 0xB0, 0x67, 0x20, 0x8B,
  0x06, 0x71, 0x01, 0x09, 0xB0, 0x80, 0x13, 0x82, 0x29, 0xCE, 0xF8, 0x2D, 0xB7, 0x5F, 0xD0, 0xD0,
  0x5F, 0xD0, 0xD0,
  // "Ń" (U+0143)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x77, 0x50, 0xCC, 0x0A, 0x40, 0x7B, 0x0C, 0xD4, 0x07, 0xB0, 0xCD, 0x05, 0x30,
  0x7B, 0x0C, 0xA0, 0xEA, 0x0A, 0x30, 0x7B, 0x0C, 0xA0, 0xAB, 0x30, 0x7B, 0x0C, 0xA0, 0x80, 0xDA,
  0x05, 0x20, 0x7B, 0x0C, 0xA0, 0x90, 0x8A, 0x0A, 0x20, 0x7B, 0x0C, 0xA0, 0x90, 0x2B, 0x20, 0x7B,
  0x0C, 0xA8, 0x1A, 0x0D, 0xA8, 0x15, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0x8A, 0x81, 0xA0, 0x7B, 0x0C,
  0xA8, 0x1A, 0x03, 0xA8, 0x1E, 0x07, 0xB0, 0xCA, 0x0A, 0x20, 0xDA, 0x05, 0x07, 0xB0, 0xCA, 0x0A,
  0x20, 0x8A, 0x0A, 0x06, 0xB0, 0xCA, 0x0A, 0x20, 0x3A, 0x0E, 0x07, 0xB0, 0xCA, 0x0A, 0x30, 0xDA,
  0x0A, 0xB0, 0xCA, 0x0A, 0x30, 0x8A, 0x0E, 0xB0, 0xCA, 0x0A, 0x30, 0x3E, 0x0C, 0xA0, 0xA4, 0x0D,
  0xD0, 0xCA, 0x0A, 0x40, 0x8D,
  // "ń" (U+0144)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x50, 0x8A, 0x87, 0x90, 0x29, 0xDF, 0xEB, 0x52, 0x08, 0xA0, 0xE0, 0x4F, 0x81,
  0x90, 0x8F, 0xD0, 0x30, 0x8C, 0x83, 0xD5, 0x36, 0xEB, 0x09, 0x08, 0xC0, 0x23, 0x06, 0xB0, 0xC0,
  0x8B, 0x0B, 0x40, 0x2B, 0x0D, 0x08, 0xB0, 0x84, 0x01, 0xB0, 0xD0, 0x8B, 0x07, 0x40, 0x1B, 0x0D,
  0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0,
  0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B,
  0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0,
  // "Ņ" (U+0145)
  0x0C, 0xC0, 0xA4, 0x07, 0xB0, 0xCD, 0x40, 0x7B, 0x0C, 0xD0, 0x53, 0x07, 0xB0, 0xCA, 0x0E, 0xA0,
  0xA3, 0x07, 0xB0, 0xCA, 0x0A, 0xB3, 0x07, 0xB0, 0xCA, 0x08, 0x0D, 0xA0, 0x52, 0x07, 0xB0, 0xCA,
  0x09, 0x08, 0xA0, 0xA2, 0x07, 0xB0, 0xCA, 0x09, 0x02, 0xB2, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0xDA,
  0x81, 0x50, 0x7B, 0x0C, 0xA8, 0x1A, 0x08, 0xA8, 0x1A, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0x3A, 0x81,
  0xE0, 0x7B, 0x0C, 0xA0, 0xA2, 0x0D, 0xA0, 0x50, 0x7B, 0x0C, 0xA0, 0xA2, 0x08, 0xA0, 0xA0, 0x6B,
  0x0C, 0xA0, 0xA2, 0x03, 0xA0, 0xE0, 0x7B, 0x0C, 0xA0, 0xA3, 0x0D, 0xA0, 0xAB, 0x0C, 0xA0, 0xA3,
  0x08, 0xA0, 0xEB, 0x0C, 0xA0, 0xA3, 0x03, 0xE0, 0xCA, 0x0A, 0x40, 0xDD, 0x0C, 0xA0, 0xA4, 0x08,
  0xD7, 0x77, 0x75, 0x0E, 0xA0, 0x97, 0x20, 0x1B, 0x02, 0x72, 0x05, 0xA0, 0x87, 0x38, 0x19, 0xFD,
  0x70,
  // "ņ" (U+0146)
  0x08, 0xA8, 0x79, 0x02, 0x9D, 0xFE, 0xB5, 0x20, 0x8A, 0x0E, 0x04, 0xF8, 0x19, 0x08, 0xFD, 0x03,
  0x08, 0xC8, 0x3D, 0x53, 0x6E, 0xB0, 0x90, 0x8C, 0x02, 0x30, 0x6B, 0x0C, 0x08, 0xB0, 0xB4, 0x02,
  0xB0, 0xD0, 0x8B, 0x08, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x74, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64,
  0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06,
  0x40, 0x1B, 0x0D, 0x77, 0x77, 0x50, 0xEA, 0x09, 0x72, 0x01, 0xB0, 0x27, 0x20, 0x5A, 0x08, 0x73,
  0x81, 0x9F, 0xD7,
  // "Ň" (U+0147)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x77, 0x74, 0x0C, 0xC0, 0xA4, 0x07, 0xB0,
  0xCD, 0x40, 0x7B, 0x0C, 0xD0, 0x53, 0x07, 0xB0, 0xCA, 0x0E, 0xA0, 0xA3, 0x07, 0xB0, 0xCA, 0x0A,
  0xB3, 0x07, 0xB0, 0xCA, 0x08, 0x0D, 0xA0, 0x52, 0x07, 0xB0, 0xCA, 0x09, 0x08, 0xA0, 0xA2, 0x07,
  0xB0, 0xCA, 0x09, 0x02, 0xB2, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0xDA, 0x81, 0x50, 0x7B, 0x0C, 0xA8,
  0x1A, 0x08, 0xA8, 0x1A, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0x3A, 0x81, 0xE0, 0x7B, 0x0C, 0xA0, 0xA2,
  0x0D, 0xA0, 0x50, 0x7B, 0x0C, 0xA0, 0xA2, 0x08, 0xA0, 0xA0, 0x6B, 0x0C, 0xA0, 0xA2, 0x03, 0xA0,
  0xE0, 0x7B, 0x0C, 0xA0, 0xA3, 0x0D, 0xA0, 0xAB, 0x0C, 0xA0, 0xA3, 0x08, 0xA0, 0xEB, 0x0C, 0xA0,
  0xA3, 0x03, 0xE0, 0xCA, 0x0A, 0x40, 0xDD, 0x0C, 0xA0, 0xA4, 0x08, 0xD0,
  // "ň" (U+0148)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x74, 0x08, 0xA8, 0x79, 0x02, 0x9D, 0xFE,
  0xB5, 0x20, 0x8A, 0x0E, 0x04, 0xF8, 0x19, 0x08, 0xFD, 0x03, 0x08, 0xC8, 0x3D, 0x53, 0x6E, 0xB0,
  0x90, 0x8C, 0x02, 0x30, 0x6B, 0x0C, 0x08, 0xB0, 0xB4, 0x02, 0xB0, 0xD0, 0x8B, 0x08, 0x40, 0x1B,
  0x0D, 0x08, 0xB0, 0x74, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01,
  0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D,
  // "ŉ" (U+0149)
  0x10, 0xCB, 0x77, 0xB0, 0xC7, 0x60, 0x2B, 0x07, 0x76, 0x05, 0xB0, 0x27, 0x60, 0x8A, 0x0C, 0x03,
  0xA0, 0xD2, 0x84, 0x5C, 0xEE, 0xC6, 0x20, 0xBA, 0x06, 0x03, 0xB0, 0x10, 0x8E, 0x85, 0x90, 0xEF,
  0xE0, 0x3B, 0x09, 0xF9, 0x04, 0x40, 0x3C, 0x83, 0xE6, 0x35, 0xEB, 0x09, 0x40, 0x3C, 0x06, 0x30,
  0x6B, 0x0C, 0x40, 0x3B, 0x0E, 0x40, 0x2B, 0x0D, 0x40, 0x3B, 0x0C, 0x40, 0x1B, 0x0D, 0x40, 0x3B,
  0x0B, 0x40, 0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D,
  0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40,
  0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D, 0x40, 0x3B, 0x0A, 0x40, 0x1B, 0x0D,
  // "Ŋ" (U+014A)
  0x0C, 0xC0, 0xA4, 0x07, 0xB0, 0xCD, 0x40, 0x7B, 0x0C, 0xD0, 0x53, 0x07, 0xB0, 0xCA, 0x0E, 0xA0,
  0xA3, 0x07, 0xB0, 0xCA, 0x0A, 0xB3, 0x07, 0xB0, 0xCA, 0x08, 0x0D, 0xA0, 0x52, 0x07, 0xB0, 0xCA,
  0x09, 0x08, 0xA0, 0xA2, 0x07, 0xB0, 0xCA, 0x09, 0x02, 0xB2, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0xDA,
  0x81, 0x50, 0x7B, 0x0C, 0xA8, 0x1A, 0x08, 0xA8, 0x1A, 0x07, 0xB0, 0xCA, 0x81, 0xA0, 0x3A, 0x81,
  0xE0, 0x7B, 0x0C, 0xA0, 0xA2, 0x0D, 0xA0, 0x50, 0x7B, 0x0C, 0xA0, 0xA2, 0x08, 0xA0, 0xA0, 0x6B,
  0x0C, 0xA0, 0xA2, 0x03, 0xA0, 0xE0, 0x7B, 0x0C, 0xA0, 0xA3, 0x0D, 0xA0, 0xAB, 0x0C, 0xA0, 0xA3,
  0x08, 0xA0, 0xEB, 0x0C, 0xA0, 0xA3, 0x03, 0xE0, 0xCA, 0x0A, 0x40, 0xDD, 0x0C, 0xA0, 0xA4, 0x08,
  0xD7, 0x30, 0x4B, 0x73, 0x09, 0xA0, 0xD5, 0x83, 0x33, 0x24, 0x9B, 0x0A, 0x50, 0x9F, 0x03, 0x50,
  0x9E, 0x06, 0x60, 0x60, 0xDA, 0x81, 0xD9, 0x22,
  // "ŋ" (U+014B)
  0x08, 0xA8, 0x79, 0x02, 0x9D, 0xFE, 0xC6, 0x20, 0x8A, 0x0E, 0x04, 0xF8, 0x19, 0x08, 0xFD, 0x04,
  0x08, 0xC8, 0x3D, 0x53, 0x6E, 0xB0, 0x90, 0x8C, 0x02, 0x30, 0x6B, 0x0C, 0x08, 0xB0, 0xB4, 0x02,
  0xB0, 0xD0, 0x8B, 0x08, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x74, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40,
  0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64,
  0x01, 0xB0, 0xD0, 0x8B, 0x06, 0x40, 0x1B, 0x0D, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0xD0, 0x8B, 0x06,
  0x40, 0x1B, 0x0D, 0x72, 0x01, 0xB0, 0xD7, 0x20, 0x2B, 0x0C, 0x68, 0x21, 0x33, 0xBB, 0x0A, 0x60,
  0x4E, 0x06, 0x60, 0x4D, 0x0B, 0x78, 0x43, 0xDE, 0xED, 0x72,
  // "Ō" (U+014C)
  0x48, 0x04, 0x27, 0x1F, 0x90, 0x37, 0xF9, 0x03, 0x7F, 0x90, 0x38, 0x0E, 0x30, 0x86, 0x28, 0xDE,
  0xED, 0x94, 0x70, 0x7F, 0x90, 0x95, 0x05, 0xFB, 0x08, 0x40, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x22,
  0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x92, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x0E, 0xB6, 0x0C, 0xB0,
  0x01, 0xB0, 0xD6, 0x0A, 0xB0, 0x40, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0,
  0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x01, 0xB0, 0xD6, 0x0A, 0xB8, 0x14, 0x0E, 0xB6, 0x0D, 0xB8,
  0x11, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x93, 0x0E, 0xB8, 0x2A,
  0x33, 0x8C, 0x02, 0x30, 0x5F, 0xB0, 0x85, 0x07, 0xF9, 0x09, 0x78, 0x62, 0x9D, 0xEE, 0xDA, 0x44,
  // "ō" (U+014D)
  0x38, 0x04, 0x27, 0xF9, 0x03, 0x6F, 0x90, 0x36, 0xF9, 0x03, 0x80, 0xC0, 0x08, 0x61, 0x7C, 0xEF,
  0xDA, 0x36, 0x05, 0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92, 0x01, 0x0E, 0xB8, 0x2A, 0x33, 0x7C, 0x81,
  0x30, 0x6B, 0x0B, 0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0xCB, 0x02, 0x50,
  0xEB, 0x10, 0xDB, 0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0B, 0xB0, 0x54, 0x01,
  0xB8, 0x1E, 0x06, 0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xA3, 0x37, 0xC0, 0x32, 0x06,
  0xFB, 0x09, 0x40, 0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE, 0xED, 0x93, 0x40,
  // "Ŏ" (U+014E)
  0x38, 0x12, 0x77, 0x48, 0x14, 0x75, 0x60, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x97, 0x0E, 0xF0, 0x37,
  0x05, 0xE0, 0x97, 0x28, 0x43, 0xBE, 0xFC, 0x68, 0x0C, 0x50, 0x86, 0x28, 0xDE, 0xED, 0x94, 0x70,
  0x7F, 0x90, 0x95, 0x05, 0xFB, 0x08, 0x40, 0xEB, 0x82, 0xA3, 0x38, 0xC0, 0x22, 0x06, 0xB0, 0xB4,
  0x08, 0xB0, 0x92, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x0E, 0xB6, 0x0C, 0xB0, 0x01, 0xB0, 0xD6,
  0x0A, 0xB0, 0x40, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C,
  0x60, 0x9B, 0x05, 0x01, 0xB0, 0xD6, 0x0A, 0xB8, 0x14, 0x0E, 0xB6, 0x0D, 0xB8, 0x11, 0x0B, 0xB0,
  0x44, 0x01, 0xB0, 0xE2, 0x06, 0xB0, 0xB4, 0x08, 0xB0, 0x93, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02,
  0x30, 0x5F, 0xB0, 0x85, 0x07, 0xF9, 0x09, 0x78, 0x62, 0x9D, 0xEE, 0xDA, 0x44,
  // "ŏ" (U+014F)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x50, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x96, 0x0E, 0xF0, 0x36,
  0x05, 0xE0, 0x97, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x77, 0x28, 0x61, 0x7C, 0xEF, 0xDA, 0x36, 0x05,
  0xF9, 0x09, 0x40, 0x5F, 0xB0, 0x92, 0x01, 0x0E, 0xB8, 0x2A, 0x33, 0x7C, 0x81, 0x30, 0x6B, 0x0B,
  0x40, 0x7B, 0x81, 0xA0, 0xAB, 0x05, 0x40, 0x1B, 0x81, 0xE0, 0xCB, 0x02, 0x50, 0xEB, 0x10, 0xDB,
  0x01, 0x50, 0xDB, 0x01, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0B, 0xB0, 0x54, 0x01, 0xB8, 0x1E, 0x06,
  0xB0, 0xB4, 0x08, 0xB8, 0x29, 0x01, 0xEB, 0x82, 0xA3, 0x37, 0xC0, 0x32, 0x06, 0xFB, 0x09, 0x40,
  0x6F, 0x90, 0x96, 0x86, 0x28, 0xCE, 0xED, 0x93, 0x40,
  // "Ő" (U+0150)
  0x50, 0xDA, 0x81, 0xC1, 0xEA, 0x09, 0x60, 0x7A, 0x81, 0xD1, 0xAA, 0x0B, 0x60, 0x2A, 0x81, 0xC1,
  0x4A, 0x0A, 0x78, 0x1B, 0xF9, 0x28, 0x1D, 0xF8, 0x80, 0xC5, 0x08, 0x62, 0x8D, 0xEE, 0xD9, 0x47,
  0x07, 0xF9, 0x09, 0x50, 0x5F, 0xB0, 0x84, 0x0E, 0xB8, 0x2A, 0x33, 0x8C, 0x02, 0x20, 0x6B, 0x0B,
  0x40, 0x8B, 0x09, 0x20, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0xEB, 0x60, 0xCB, 0x00, 0x1B, 0x0D,
  0x60, 0xAB, 0x04, 0x02, 0xB0, 0xC6, 0x09, 0xB0, 0x50, 0x2B, 0x0C, 0x60, 0x9B, 0x05, 0x02, 0xB0,
  0xC6, 0x09, 0xB0, 0x50, 0x1B, 0x0D, 0x60, 0xAB, 0x81, 0x40, 0xEB, 0x60, 0xDB, 0x81, 0x10, 0xBB,
  0x04, 0x40, 0x1B, 0x0E, 0x20, 0x6B, 0x0B, 0x40, 0x8B, 0x09, 0x30, 0xEB, 0x82, 0xA3, 0x38, 0xC0,
  0x23, 0x05, 0xFB, 0x08, 0x50, 0x7F, 0x90, 0x97, 0x86, 0x29, 0xDE, 0xED, 0xA4, 0x40,
  // "ő" (U+0151)
  0x40, 0xDA, 0x81, 0xC1, 0xEA, 0x09, 0x50, 0x7A, 0x81, 0xD1, 0xAA, 0x0B, 0x50, 0x2A, 0x81, 0xC1,
  0x4A, 0x0A, 0x68, 0x1B, 0xF9, 0x28, 0x1D, 0xF8, 0x77, 0x72, 0x86, 0x17, 0xCE, 0xFD, 0xA3, 0x60,
  0x5F, 0x90, 0x94, 0x05, 0xFB, 0x09, 0x20, 0x10, 0xEB, 0x82, 0xA3, 0x37, 0xC8, 0x13, 0x06, 0xB0,
  0xB4, 0x07, 0xB8, 0x1A, 0x0A, 0xB0, 0x54, 0x01, 0xB8, 0x1E, 0x0C, 0xB0, 0x25, 0x0E, 0xB1, 0x0D,
  0xB0, 0x15, 0x0D, 0xB0, 0x10, 0xCB, 0x02, 0x50, 0xEB, 0x10, 0xBB, 0x05, 0x40, 0x1B, 0x81, 0xE0,
  0x6B, 0x0B, 0x40, 0x8B, 0x82, 0x90, 0x1E, 0xB8, 0x2A, 0x33, 0x7C, 0x03, 0x20, 0x6F, 0xB0, 0x94,
  0x06, 0xF9, 0x09, 0x68, 0x62, 0x8C, 0xEE, 0xD9, 0x34,
  // "Œ" (U+0152)
  0x40, 0x70, 0xDF, 0xA0, 0xA3, 0x0C, 0xFC, 0x0A, 0x20, 0xAF, 0xD8, 0x1A, 0x02, 0xB8, 0x2E, 0x52,
  0xBB, 0x0F, 0x28, 0x11, 0x08, 0xB0, 0x62, 0x0B, 0xB5, 0x0C, 0xB3, 0x0B, 0xB5, 0xB0, 0xD3, 0x0B,
  0xB4, 0x01, 0xB0, 0xB3, 0x0B, 0xE0, 0x02, 0xB0, 0xA3, 0x0B, 0xE0, 0x02, 0xB0, 0xA3, 0x0B, 0xE0,
  0x02, 0xB0, 0xA3, 0x0B, 0xB0, 0xF2, 0x10, 0x1B, 0x0B, 0x30, 0xBB, 0x5B, 0x0C, 0x30, 0xBB, 0x50,
  0xCA, 0x0E, 0x30, 0xBB, 0x50, 0x9B, 0x04, 0x20, 0xBB, 0x50, 0x3B, 0x82, 0xD4, 0x2C, 0xB0, 0xF2,
  0x01, 0x20, 0xBF, 0xD0, 0xA2, 0x01, 0x0D, 0xFC, 0x0A, 0x38, 0x11, 0x8D, 0xFA, 0x0A,
  // "œ" (U+0153)
  0x28, 0x92, 0x19, 0xEE, 0xA2, 0x01, 0xAE, 0xE8, 0x30, 0x10, 0xDC, 0x81, 0xD1, 0xCC, 0x0A, 0x20,
  0x9E, 0x0D, 0xE8, 0x14, 0x0E, 0xA8, 0x17, 0x4E, 0xB8, 0x1C, 0x39, 0xA0, 0x90, 0x3A, 0x0E, 0x20,
  0x7B, 0x81, 0x40, 0x1A, 0x0C, 0x06, 0xA0, 0xB2, 0x03, 0xB0, 0x12, 0xA0, 0xD0, 0x7A, 0x0A, 0x20,
  0x2F, 0x90, 0xE0, 0x7A, 0x0A, 0x20, 0x1F, 0x90, 0xE0, 0x7A, 0x0A, 0x20, 0x2B, 0x03, 0x80, 0x12,
  0x05, 0xA0, 0xC2, 0x03, 0xB0, 0x25, 0x02, 0xA0, 0xE2, 0x07, 0xB0, 0x76, 0x0E, 0xA8, 0x18, 0x3E,
  0xB8, 0x6E, 0x62, 0x4A, 0x80, 0x8E, 0x0D, 0xE0, 0x82, 0x0C, 0xC8, 0x1D, 0x1B, 0xD0, 0x82, 0x89,
  0x31, 0x9D, 0xEA, 0x20, 0x19, 0xEE, 0xC5, 0x10,
  // "Ŕ" (U+0154)
  0x60, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x77, 0x60, 0xDD, 0x82, 0xEC, 0x82, 0x40, 0xDF, 0xA0, 0x63, 0x0D, 0xFB, 0x05,
  0x20, 0xDB, 0x82, 0x33, 0x5C, 0xB0, 0xD2, 0x0D, 0xB0, 0x13, 0x0D, 0xB8, 0x13, 0x0D, 0xB0, 0x13,
  0x0A, 0xB8, 0x14, 0x0D, 0xB0, 0x13, 0x0B, 0xB8, 0x14, 0x0D, 0xB0, 0x12, 0x01, 0x0E, 0xB8, 0x11,
  0x0D, 0xB8, 0x23, 0x35, 0xCB, 0x0B, 0x20, 0xDF, 0xA0, 0xE0, 0x22, 0x0D, 0xF9, 0x0D, 0x03, 0x30,
  0xDF, 0x90, 0x44, 0x0D, 0xB0, 0x10, 0x2B, 0x0D, 0x40, 0xDB, 0x81, 0x10, 0x8B, 0x07, 0x30, 0xDB,
  0x01, 0x20, 0xDA, 0x0E, 0x01, 0x20, 0xDB, 0x01, 0x20, 0x5B, 0x0A, 0x20, 0xDB, 0x01, 0x30, 0xCB,
  0x81, 0x40, 0xDB, 0x01, 0x30, 0x3B, 0x81, 0xD0, 0xDB, 0x01, 0x40, 0xAB, 0x07,
  // "ŕ" (U+0155)
  0x71, 0x03, 0x80, 0x07, 0x73, 0x0D, 0xB0, 0x57, 0x20, 0x8B, 0x05, 0x72, 0x03, 0xB0, 0x57, 0x38,
  0x2D, 0xFE, 0x37, 0x76, 0x02, 0xE2, 0x85, 0x5B, 0xEF, 0xE8, 0x2E, 0x04, 0x09, 0xD8, 0x35, 0x19,
  0xBD, 0xB0, 0xEE, 0x40, 0x1D, 0x83, 0xB4, 0x24, 0x54, 0x01, 0xC0, 0xB7, 0x20, 0x1C, 0x03, 0x72,
  0x01, 0xC7, 0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7,
  0x20, 0x10, 0x5B, 0x0E, 0x03, 0x60, 0x80, 0xDF, 0x90, 0xC0, 0x73, 0x0D, 0xFB, 0x0B, 0x30, 0xDF,
  0xB0, 0xB3,
  // "Ŗ" (U+0156)
  0x0D, 0xD8, 0x2E, 0xC8, 0x24, 0x0D, 0xFA, 0x06, 0x30, 0xDF, 0xB0, 0x52, 0x0D, 0xB8, 0x23, 0x35,
  0xCB, 0x0D, 0x20, 0xDB, 0x01, 0x30, 0xDB, 0x81, 0x30, 0xDB, 0x01, 0x30, 0xAB, 0x81, 0x40, 0xDB,
  0x01, 0x30, 0xBB, 0x81, 0x40, 0xDB, 0x01, 0x20, 0x10, 0xEB, 0x81, 0x10, 0xDB, 0x82, 0x33, 0x5C,
  0xB0, 0xB2, 0x0D, 0xFA, 0x0E, 0x02, 0x20, 0xDF, 0x90, 0xD0, 0x33, 0x0D, 0xF9, 0x04, 0x40, 0xDB,
  0x01, 0x02, 0xB0, 0xD4, 0x0D, 0xB8, 0x11, 0x08, 0xB0, 0x73, 0x0D, 0xB0, 0x12, 0x0D, 0xA0, 0xE0,
  0x12, 0x0D, 0xB0, 0x12, 0x05, 0xB0, 0xA2, 0x0D, 0xB0, 0x13, 0x0C, 0xB8, 0x14, 0x0D, 0xB0, 0x13,
  0x03, 0xB8, 0x1D, 0x0D, 0xB0, 0x14, 0x0A, 0xB0, 0x77, 0x77, 0x75, 0x0E, 0xA0, 0x97, 0x20, 0x1B,
  0x02, 0x72, 0x05, 0xA0, 0x87, 0x38, 0x19, 0xFD, 0x70,
  // "ŗ" (U+0157)
  0x02, 0xE2, 0x85, 0x5B, 0xEF, 0xE8, 0x2E, 0x04, 0x09, 0xD8, 0x35, 0x19, 0xBD, 0xB0, 0xEE, 0x40,
  0x1D, 0x83, 0xB4, 0x24, 0x54, 0x01, 0xC0, 0xB7, 0x20, 0x1C, 0x03, 0x72, 0x01, 0xC7, 0x30, 0x1B,
  0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x20, 0x10, 0x5B, 0x0E,
  0x03, 0x60, 0x80, 0xDF, 0x90, 0xC0, 0x73, 0x0D, 0xFB, 0x0B, 0x30, 0xDF, 0xB0, 0xB8, 0x0C, 0x10,
  0x0E, 0xA0, 0x97, 0x30, 0x1B, 0x02, 0x73, 0x05, 0xA0, 0x87, 0x48, 0x19, 0xFD, 0x72,
  // "Ř" (U+0158)
  0x18, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x77, 0x75, 0x0D, 0xD8, 0x2E, 0xC8, 0x24,
  0x0D, 0xFA, 0x06, 0x30, 0xDF, 0xB0, 0x52, 0x0D, 0xB8, 0x23, 0x35, 0xCB, 0x0D, 0x20, 0xDB, 0x01,
  0x30, 0xDB, 0x81, 0x30, 0xDB, 0x01, 0x30, 0xAB, 0x81, 0x40, 0xDB, 0x01, 0x30, 0xBB, 0x81, 0x40,
  0xDB, 0x01, 0x20, 0x10, 0xEB, 0x81, 0x10, 0xDB, 0x82, 0x33, 0x5C, 0xB0, 0xB2, 0x0D, 0xFA, 0x0E,
  0x02, 0x20, 0xDF, 0x90, 0xD0, 0x33, 0x0D, 0xF9, 0x04, 0x40, 0xDB, 0x01, 0x02, 0xB0, 0xD4, 0x0D,
  0xB8, 0x11, 0x08, 0xB0, 0x73, 0x0D, 0xB0, 0x12, 0x0D, 0xA0, 0xE0, 0x12, 0x0D, 0xB0, 0x12, 0x05,
  0xB0, 0xA2, 0x0D, 0xB0, 0x13, 0x0C, 0xB8, 0x14, 0x0D, 0xB0, 0x13, 0x03, 0xB8, 0x1D, 0x0D, 0xB0,
  0x14, 0x0A, 0xB0, 0x70,
  // "ř" (U+0159)
  0x38, 0x16, 0x76, 0x48, 0x15, 0x77, 0x50, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x60, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x10, 0xCC, 0x0E, 0x01, 0x71, 0x03, 0xC0, 0x67, 0x75, 0x02, 0xE2, 0x85, 0x5B, 0xEF,
  0xE8, 0x2E, 0x04, 0x09, 0xD8, 0x35, 0x19, 0xBD, 0xB0, 0xEE, 0x40, 0x1D, 0x83, 0xB4, 0x24, 0x54,
  0x01, 0xC0, 0xB7, 0x20, 0x1C, 0x03, 0x72, 0x01, 0xC7, 0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7,
  0x30, 0x1B, 0x0D, 0x73, 0x01, 0xB0, 0xD7, 0x20, 0x10, 0x5B, 0x0E, 0x03, 0x60, 0x80, 0xDF, 0x90,
  0xC0, 0x73, 0x0D, 0xFB, 0x0B, 0x30, 0xDF, 0xB0, 0xB3,
  // "Ś" (U+015A)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x80, 0xC0, 0x08, 0x90, 0x17, 0xCE, 0xFE, 0xDA, 0x71, 0x30, 0x50, 0xEF, 0xA8, 0x12,
  0x02, 0xFB, 0x0D, 0x20, 0x8B, 0x86, 0xE6, 0x33, 0x6A, 0xF7, 0x20, 0xAB, 0x06, 0x50, 0x13, 0x0A,
  0xB0, 0x57, 0x20, 0x7B, 0x0C, 0x72, 0x01, 0x0E, 0xB0, 0xE0, 0x67, 0x10, 0x40, 0xEC, 0x0E, 0x07,
  0x70, 0x20, 0xBD, 0x0D, 0x04, 0x70, 0x50, 0xDD, 0x07, 0x71, 0x06, 0x0D, 0xC0, 0x37, 0x20, 0xBB,
  0x09, 0x72, 0x05, 0xB8, 0x1A, 0x04, 0x70, 0x7B, 0x89, 0x09, 0x1F, 0xD9, 0x53, 0x23, 0x7C, 0x05,
  0x01, 0xFC, 0x81, 0xC0, 0x1F, 0xB0, 0xB0, 0x12, 0x89, 0x02, 0x7B, 0xDE, 0xFE, 0xC9, 0x33,
  // "ś" (U+015B)
  0x60, 0x38, 0x00, 0x77, 0x0D, 0xB0, 0x56, 0x08, 0xB0, 0x56, 0x03, 0xB0, 0x57, 0x82, 0xDF, 0xE3,
  0x77, 0x48, 0x73, 0x9D, 0xEF, 0xEC, 0x95, 0x20, 0x9F, 0xA0, 0xC0, 0x5F, 0xB0, 0x70, 0x9B, 0x87,
  0xA3, 0x34, 0x6B, 0xE1, 0xAB, 0x06, 0x70, 0x8C, 0x0A, 0x04, 0x50, 0x10, 0xDD, 0x81, 0xD7, 0x13,
  0x01, 0x0A, 0xF0, 0x64, 0x81, 0x29, 0xED, 0x06, 0x60, 0x50, 0xDB, 0x0D, 0x02, 0x60, 0x1C, 0x86,
  0xDD, 0x95, 0x32, 0x38, 0xB0, 0xE0, 0xDF, 0xB0, 0xA0, 0xDF, 0xA8, 0x92, 0xC1, 0x48, 0xCD, 0xEF,
  0xED, 0xA5, 0x20,
  // "Ŝ" (U+015C)
  0x58, 0x00, 0x70, 0x27, 0x10, 0x6C, 0x0C, 0x70, 0x20, 0xEA, 0x0D, 0xA0, 0x76, 0x0C, 0xA8, 0x15,
  0x1D, 0xA0, 0x34, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x75, 0x89, 0x01, 0x7C, 0xEF,
  0xED, 0xA7, 0x13, 0x05, 0x0E, 0xFA, 0x81, 0x20, 0x2F, 0xB0, 0xD2, 0x08, 0xB8, 0x6E, 0x63, 0x36,
  0xAF, 0x72, 0x0A, 0xB0, 0x65, 0x01, 0x30, 0xAB, 0x05, 0x72, 0x07, 0xB0, 0xC7, 0x20, 0x10, 0xEB,
  0x0E, 0x06, 0x71, 0x04, 0x0E, 0xC0, 0xE0, 0x77, 0x02, 0x0B, 0xD0, 0xD0, 0x47, 0x05, 0x0D, 0xD0,
  0x77, 0x10, 0x60, 0xDC, 0x03, 0x72, 0x0B, 0xB0, 0x97, 0x20, 0x5B, 0x81, 0xA0, 0x47, 0x07, 0xB8,
  0x90, 0x91, 0xFD, 0x95, 0x32, 0x37, 0xC0, 0x50, 0x1F, 0xC8, 0x1C, 0x01, 0xFB, 0x0B, 0x01, 0x28,
  0x90, 0x27, 0xBD, 0xEF, 0xEC, 0x93, 0x30,
  // "ŝ" (U+015D)
  0x48, 0x00, 0x70, 0x26, 0x06, 0xC0, 0xC5, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x40, 0xCA, 0x81, 0x51,
  0xDA, 0x03, 0x28, 0x29, 0xFE, 0x42, 0x82, 0x1C, 0xFE, 0x77, 0x18, 0x73, 0x9D, 0xEF, 0xEC, 0x95,
  0x20, 0x9F, 0xA0, 0xC0, 0x5F, 0xB0, 0x70, 0x9B, 0x87, 0xA3, 0x34, 0x6B, 0xE1, 0xAB, 0x06, 0x70,
  0x8C, 0x0A, 0x04, 0x50, 0x10, 0xDD, 0x81, 0xD7, 0x13, 0x01, 0x0A, 0xF0, 0x64, 0x81, 0x29, 0xED,
  0x06, 0x60, 0x50, 0xDB, 0x0D, 0x02, 0x60, 0x1C, 0x86, 0xDD, 0x95, 0x32, 0x38, 0xB0, 0xE0, 0xDF,
  0xB0, 0xA0, 0xDF, 0xA8, 0x92, 0xC1, 0x48, 0xCD, 0xEF, 0xED, 0xA5, 0x20,
  // "Ş" (U+015E)
  0x38, 0x90, 0x17, 0xCE, 0xFE, 0xDA, 0x71, 0x30, 0x50, 0xEF, 0xA8, 0x12, 0x02, 0xFB, 0x0D, 0x20,
  0x8B, 0x86, 0xE6, 0x33, 0x6A, 0xF7, 0x20, 0xAB, 0x06, 0x50, 0x13, 0x0A, 0xB0, 0x57, 0x20, 0x7B,
  0x0C, 0x72, 0x01, 0x0E, 0xB0, 0xE0, 0x67, 0x10, 0x40, 0xEC, 0x0E, 0x07, 0x70, 0x20, 0xBD, 0x0D,
  0x04, 0x70, 0x50, 0xDD, 0x07, 0x71, 0x06, 0x0D, 0xC0, 0x37, 0x20, 0xBB, 0x09, 0x72, 0x05, 0xB8,
  0x1A, 0x04, 0x70, 0x7B, 0x89, 0x09, 0x1F, 0xD9, 0x53, 0x23, 0x7C, 0x05, 0x01, 0xFC, 0x81, 0xC0,
  0x1F, 0xB0, 0xB0, 0x12, 0x83, 0x27, 0xBD, 0xEA, 0x81, 0xD9, 0x37, 0x18, 0x23, 0xFE, 0x27, 0x30,
  0x8B, 0x05, 0x73, 0x82, 0x1D, 0xFE, 0x71, 0x82, 0x10, 0x2E, 0xA7, 0x10, 0x9C, 0x0A, 0x71, 0x84,
  0x8E, 0xFE, 0x91, 0x40,
  // "ş" (U+015F)
  0x28, 0x73, 0x9D, 0xEF, 0xEC, 0x95, 0x20, 0x9F, 0xA0, 0xC0, 0x5F, 0xB0, 0x70, 0x9B, 0x87, 0xA3,
  0x34, 0x6B, 0xE1, 0xAB, 0x06, 0x70, 0x8C, 0x0A, 0x04, 0x50, 0x10, 0xDD, 0x81, 0xD7, 0x13, 0x01,
  0x0A, 0xF0, 0x64, 0x81, 0x29, 0xED, 0x06, 0x60, 0x50, 0xDB, 0x0D, 0x02, 0x60, 0x1C, 0x86, 0xDD,
  0x95, 0x32, 0x38, 0xB0, 0xE0, 0xDF, 0xB0, 0xA0, 0xDF, 0xA8, 0x5C, 0x14, 0x8C, 0xDE, 0xA8, 0x1E,
  0xA5, 0x68, 0x23, 0xFE, 0x27, 0x10, 0x8B, 0x05, 0x71, 0x82, 0x1D, 0xFE, 0x68, 0x21, 0x02, 0xEA,
  0x60, 0x9C, 0x0A, 0x68, 0x48, 0xEF, 0xE9, 0x13,
  // "Š" (U+0160)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x77, 0x77, 0x89, 0x01, 0x7C, 0xEF, 0xED,
  0xA7, 0x13, 0x05, 0x0E, 0xFA, 0x81, 0x20, 0x2F, 0xB0, 0xD2, 0x08, 0xB8, 0x6E, 0x63, 0x36, 0xAF,
  0x72, 0x0A, 0xB0, 0x65, 0x01, 0x30, 0xAB, 0x05, 0x72, 0x07, 0xB0, 0xC7, 0x20, 0x10, 0xEB, 0x0E,
  0x06, 0x71, 0x04, 0x0E, 0xC0, 0xE0, 0x77, 0x02, 0x0B, 0xD0, 0xD0, 0x47, 0x05, 0x0D, 0xD0, 0x77,
  0x10, 0x60, 0xDC, 0x03, 0x72, 0x0B, 0xB0, 0x97, 0x20, 0x5B, 0x81, 0xA0, 0x47, 0x07, 0xB8, 0x90,
  0x91, 0xFD, 0x95, 0x32, 0x37, 0xC0, 0x50, 0x1F, 0xC8, 0x1C, 0x01, 0xFB, 0x0B, 0x01, 0x28, 0x90,
  0x27, 0xBD, 0xEF, 0xEC, 0x93, 0x30,
  // "š" (U+0161)
  0x18, 0x16, 0x76, 0x48, 0x15, 0x77, 0x20, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x30, 0x8A, 0x0A, 0x08,
  0xA0, 0xB5, 0x0C, 0xC0, 0xE0, 0x15, 0x03, 0xC0, 0x67, 0x73, 0x87, 0x39, 0xDE, 0xFE, 0xC9, 0x52,
  0x09, 0xFA, 0x0C, 0x05, 0xFB, 0x07, 0x09, 0xB8, 0x7A, 0x33, 0x46, 0xBE, 0x1A, 0xB0, 0x67, 0x08,
  0xC0, 0xA0, 0x45, 0x01, 0x0D, 0xD8, 0x1D, 0x71, 0x30, 0x10, 0xAF, 0x06, 0x48, 0x12, 0x9E, 0xD0,
  0x66, 0x05, 0x0D, 0xB0, 0xD0, 0x26, 0x01, 0xC8, 0x6D, 0xD9, 0x53, 0x23, 0x8B, 0x0E, 0x0D, 0xFB,
  0x0A, 0x0D, 0xFA, 0x89, 0x2C, 0x14, 0x8C, 0xDE, 0xFE, 0xDA, 0x52,
  // "Ţ" (U+0162)
  0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x18, 0x01, 0x20, 0xDB, 0x03, 0x80, 0x02,
  0x70, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50,
  0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB,
  0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x82, 0x3F, 0xE2, 0x75, 0x08, 0xB0, 0x57, 0x58, 0x21, 0xDF,
  0xE7, 0x38, 0x21, 0x02, 0xEA, 0x73, 0x09, 0xC0, 0xA7, 0x38, 0x48, 0xEF, 0xE9, 0x15,
  // "ţ" (U+0163)
  0x48, 0x22, 0x77, 0x57, 0x30, 0x6A, 0x0B, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0xCA, 0x0B, 0x68, 0x22,
  0x69, 0xDF, 0xA0, 0x30, 0x8F, 0xD0, 0x30, 0x8F, 0xD8, 0x33, 0x12, 0x24, 0xB0, 0xB8, 0x01, 0x24,
  0x02, 0xB0, 0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x02, 0xB0, 0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x02, 0xB0,
  0xB7, 0x20, 0x2B, 0x0B, 0x72, 0x01, 0xB0, 0xD7, 0x30, 0xEB, 0x84, 0xA4, 0x24, 0x63, 0x40, 0x9F,
  0x90, 0x64, 0x01, 0x0D, 0xF0, 0x66, 0x07, 0x0C, 0xB8, 0x1D, 0x92, 0x78, 0x23, 0xFE, 0x27, 0x30,
  0x8B, 0x05, 0x73, 0x82, 0x1D, 0xFE, 0x71, 0x82, 0x10, 0x2E, 0xA7, 0x10, 0x9C, 0x0A, 0x71, 0x84,
  0x8E, 0xFE, 0x91, 0x20,
  // "Ť" (U+0164)
  0x38, 0x16, 0x76, 0x48, 0x15, 0x77, 0x60, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x70, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x20, 0xCC, 0x0E, 0x01, 0x72, 0x03, 0xC0, 0x68, 0x0C, 0x10, 0x02, 0xFF, 0x06, 0x02,
  0xFF, 0x06, 0x02, 0xFF, 0x06, 0x18, 0x01, 0x20, 0xDB, 0x03, 0x80, 0x02, 0x70, 0xDB, 0x75, 0x0D,
  0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7,
  0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50,
  0xDB, 0x60,
  // "ť" (U+0165)
  0x73, 0x03, 0xB0, 0x57, 0x30, 0x6A, 0x0C, 0x58, 0x23, 0xCC, 0x82, 0x09, 0xA0, 0x45, 0x07, 0xA0,
  0xB2, 0x81, 0xDF, 0x96, 0x09, 0xA0, 0xB7, 0x40, 0xCA, 0x0B, 0x78, 0x22, 0x6A, 0xDF, 0xA8, 0x13,
  0x08, 0xFD, 0x81, 0x30, 0x8F, 0xD8, 0x43, 0x01, 0x22, 0x4B, 0x0B, 0x80, 0x12, 0x50, 0x2B, 0x0B,
  0x73, 0x02, 0xB0, 0xB7, 0x30, 0x2B, 0x0B, 0x73, 0x02, 0xB0, 0xB7, 0x30, 0x2B, 0x0B, 0x73, 0x02,
  0xB0, 0xB7, 0x30, 0x1B, 0x0D, 0x74, 0x0E, 0xB8, 0x4A, 0x42, 0x46, 0x35, 0x09, 0xF9, 0x06, 0x50,
  0x10, 0xDF, 0x06, 0x78, 0x67, 0xCE, 0xFE, 0xD9, 0x21,
  // "Ŧ" (U+0166)
  0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x02, 0xFF, 0x06, 0x18, 0x01, 0x20, 0xDB, 0x03, 0x80, 0x02,
  0x70, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x72, 0x0F, 0x20, 0xDB, 0x81, 0x32, 0x25, 0x02, 0xFB,
  0x06, 0x40, 0x2F, 0xB0, 0x64, 0x02, 0xFB, 0x06, 0x71, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7,
  0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x75, 0x0D, 0xB7, 0x50, 0xDB, 0x60,
  // "ŧ" (U+0167)
  0x48, 0x22, 0x77, 0x57, 0x30, 0x6A, 0x0B, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0xCA, 0x0B, 0x68, 0x22,
  0x69, 0xDF, 0xA0, 0x30, 0x8F, 0xD0, 0x30, 0x8F, 0xD8, 0x33, 0x12, 0x24, 0xB0, 0xB8, 0x01, 0x24,
  0x02, 0xB0, 0xB6, 0x07, 0x0F, 0xDB, 0x0E, 0x80, 0x1D, 0x05, 0x08, 0xFD, 0x06, 0x08, 0xFD, 0x06,
  0x30, 0x2B, 0x0B, 0x72, 0x02, 0xB0, 0xB7, 0x20, 0x1B, 0x0E, 0x73, 0x0E, 0xB8, 0x4A, 0x42, 0x46,
  0x34, 0x09, 0xF9, 0x06, 0x40, 0x10, 0xDF, 0x06, 0x68, 0x67, 0xCE, 0xFE, 0xD9, 0x20,
  // "Ũ" (U+0168)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x77, 0x30, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB,
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xBB, 0x02, 0x5C, 0x0A, 0xB0, 0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B, 0x0A, 0x02, 0xC8,
  0x29, 0x43, 0x7C, 0x81, 0x50, 0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48, 0x14, 0xAD, 0xA8,
  0x1D, 0xA5, 0x30,
  // "ũ" (U+0169)
  0x38, 0x38, 0xEE, 0x92, 0x28, 0x1D, 0xF2, 0x30, 0x5D, 0x82, 0xCB, 0xFE, 0x48, 0x2B, 0xFC, 0xBD,
  0x08, 0x48, 0x7E, 0xF1, 0x01, 0x8D, 0xE9, 0x77, 0x30, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0,
  0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB,
  0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A,
  0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0, 0x54, 0x07, 0xB0, 0xB0,
  0x9B, 0x09, 0x40, 0xCB, 0x0B, 0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01, 0xFD, 0x81, 0xB0, 0x6F,
  0x06, 0x0B, 0xA0, 0xB2, 0x87, 0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "Ū" (U+016A)
  0x38, 0x04, 0x26, 0xF9, 0x03, 0x5F, 0x90, 0x35, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0xCB, 0x01, 0x50,
  0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB,
  0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xBB, 0x02, 0x5C, 0x0A, 0xB0, 0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B,
  0x0A, 0x02, 0xC8, 0x29, 0x43, 0x7C, 0x81, 0x50, 0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48,
  0x14, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "ū" (U+016B)
  0x38, 0x04, 0x26, 0xF9, 0x03, 0x5F, 0x90, 0x35, 0xF9, 0x03, 0x77, 0x77, 0x20, 0xAB, 0x04, 0x40,
  0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44,
  0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04,
  0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0,
  0x54, 0x07, 0xB0, 0xB0, 0x9B, 0x09, 0x40, 0xCB, 0x0B, 0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01,
  0xFD, 0x81, 0xB0, 0x6F, 0x06, 0x0B, 0xA0, 0xB2, 0x87, 0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "Ŭ" (U+016C)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x77, 0x40, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0,
  0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB,
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xBB, 0x02, 0x5C, 0x0A, 0xB0, 0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B, 0x0A, 0x02, 0xC8,
  0x29, 0x43, 0x7C, 0x81, 0x50, 0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48, 0x14, 0xAD, 0xA8,
  0x1D, 0xA5, 0x30,
  // "ŭ" (U+016D)
  0x28, 0x12, 0x77, 0x48, 0x14, 0x75, 0x40, 0x3A, 0x85, 0x93, 0x25, 0xEF, 0x95, 0x0E, 0xF0, 0x35,
  0x05, 0xE0, 0x97, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x40, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0,
  0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB,
  0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A,
  0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0, 0x54, 0x07, 0xB0, 0xB0,
  0x9B, 0x09, 0x40, 0xCB, 0x0B, 0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01, 0xFD, 0x81, 0xB0, 0x6F,
  0x06, 0x0B, 0xA0, 0xB2, 0x87, 0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "Ů" (U+016E)
  0x48, 0x41, 0x9E, 0xEA, 0x17, 0x18, 0x4B, 0xFE, 0xEF, 0xC7, 0x19, 0x84, 0xE1, 0x0D, 0xF3, 0x79,
  0x0E, 0x28, 0x1D, 0xF3, 0x78, 0x4B, 0xFE, 0xEF, 0xC7, 0x18, 0x41, 0x9E, 0xEA, 0x17, 0x77, 0x74,
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15,
  0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0B, 0xB0, 0x25, 0xC0, 0xAB, 0x04, 0x40, 0x1B, 0x0D, 0x08,
  0xB0, 0x94, 0x06, 0xB0, 0xA0, 0x2C, 0x82, 0x94, 0x37, 0xC8, 0x15, 0x09, 0xFB, 0x0C, 0x30, 0xAF,
  0x90, 0xC0, 0x14, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x53,
  // "ů" (U+016F)
  0x48, 0x41, 0x9E, 0xEA, 0x17, 0x18, 0x4B, 0xFE, 0xEF, 0xC7, 0x19, 0x84, 0xE1, 0x0D, 0xF3, 0x79,
  0x0E, 0x28, 0x1D, 0xF3, 0x78, 0x4B, 0xFE, 0xEF, 0xC7, 0x18, 0x41, 0x9E, 0xEA, 0x17, 0x74, 0x0A,
  0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0,
  0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B,
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04, 0xB0,
  0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x09, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0x6C, 0x82, 0x73, 0x4B,
  0xC0, 0xB0, 0x1F, 0xD8, 0x1B, 0x06, 0xF0, 0x60, 0xBA, 0x0B, 0x28, 0x74, 0xBE, 0xFD, 0x93, 0x06,
  0xA0, 0xB0,
  // "Ű" (U+0170)
  0x40, 0xDA, 0x81, 0xC1, 0xEA, 0x09, 0x40, 0x7A, 0x81, 0xD1, 0xAA, 0x0B, 0x40, 0x2A, 0x81, 0xC1,
  0x4A, 0x0A, 0x58, 0x1B, 0xF9, 0x28, 0x1D, 0xF8, 0x77, 0x77, 0x40, 0xCB, 0x01, 0x50, 0xEB, 0x0C,
  0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50,
  0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB,
  0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E,
  0xB0, 0xBB, 0x02, 0x5C, 0x0A, 0xB0, 0x44, 0x01, 0xB0, 0xD0, 0x8B, 0x09, 0x40, 0x6B, 0x0A, 0x02,
  0xC8, 0x29, 0x43, 0x7C, 0x81, 0x50, 0x9F, 0xB0, 0xC3, 0x0A, 0xF9, 0x0C, 0x01, 0x48, 0x14, 0xAD,
  0xA8, 0x1D, 0xA5, 0x30,
  // "ű" (U+0171)
  0x40, 0xDA, 0x81, 0xC1, 0xEA, 0x09, 0x40, 0x7A, 0x81, 0xD1, 0xAA, 0x0B, 0x40, 0x2A, 0x81, 0xC1,
  0x4A, 0x0A, 0x58, 0x1B, 0xF9, 0x28, 0x1D, 0xF8, 0x77, 0x40, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A,
  0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0,
  0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B,
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x4B, 0x0B, 0x0A, 0xB0, 0x54, 0x07, 0xB0,
  0xB0, 0x9B, 0x09, 0x40, 0xCB, 0x0B, 0x06, 0xC8, 0x27, 0x34, 0xBC, 0x0B, 0x01, 0xFD, 0x81, 0xB0,
  0x6F, 0x06, 0x0B, 0xA0, 0xB2, 0x87, 0x4B, 0xEF, 0xD9, 0x30, 0x6A, 0x0B,
  // "Ų" (U+0172)
  0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01,
  0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0,
  0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15, 0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0C, 0xB0, 0x15,
  0x0E, 0xB0, 0xCB, 0x01, 0x50, 0xEB, 0x0B, 0xB0, 0x25, 0xC0, 0xAB, 0x04, 0x40, 0x1B, 0x0D, 0x08,
  0xB0, 0x94, 0x06, 0xB0, 0xB0, 0x3C, 0x82, 0x94, 0x37, 0xC8, 0x15, 0x0B, 0xFB, 0x0C, 0x20, 0x10,
  0xCF, 0x90, 0xD0, 0x24, 0x81, 0x6B, 0xEC, 0x08, 0x71, 0x83, 0x1C, 0xFE, 0x37, 0x28, 0x2B, 0xFE,
  0x27, 0x20, 0x1A, 0x09, 0x73, 0x02, 0xA8, 0x1C, 0x33, 0x72, 0x0D, 0xB0, 0xD7, 0x28, 0x32, 0xAE,
  0xEB, 0x40,
  // "ų" (U+0173)
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0,
  0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04,
  0xB0, 0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x09, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0x6C, 0x82, 0x73,
  0x4B, 0xC0, 0xB0, 0x1F, 0xD8, 0x1B, 0x06, 0xF0, 0x60, 0xBA, 0x0B, 0x28, 0x74, 0xBE, 0xFD, 0x93,
  0x07, 0xA0, 0xB7, 0x28, 0x21, 0xDF, 0x87, 0x38, 0x1B, 0xFC, 0x73, 0x02, 0xA0, 0x87, 0x30, 0x3A,
  0x81, 0xB2, 0x37, 0x20, 0xDB, 0x0C, 0x72, 0x83, 0x2B, 0xEE, 0xA0,
  // "Ŵ" (U+0174)
  0x68, 0x00, 0x70, 0x27, 0x30, 0x6C, 0x0C, 0x72, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x71, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x36, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x77, 0x0A, 0xA0, 0xB7,
  0x10, 0x7A, 0x0D, 0x09, 0xA0, 0xC7, 0x10, 0x9A, 0x0C, 0x08, 0xA0, 0xE7, 0x10, 0xAA, 0x0B, 0x07,
  0xB7, 0x10, 0xBA, 0x0A, 0x06, 0xB8, 0x11, 0x0C, 0xB2, 0x0C, 0xA0, 0x90, 0x5B, 0x81, 0x20, 0xEB,
  0x81, 0x30, 0xDA, 0x08, 0x03, 0xB0, 0x40, 0x1C, 0x81, 0x50, 0xEA, 0x07, 0x02, 0xB0, 0x50, 0x4C,
  0x07, 0x1B, 0x06, 0x01, 0xB0, 0x50, 0x6A, 0x82, 0xCF, 0xA1, 0xB0, 0x51, 0xB8, 0x66, 0x9F, 0xD9,
  0xFC, 0x2B, 0x81, 0x30, 0xEA, 0x86, 0x6B, 0xFB, 0x7F, 0xE2, 0xB8, 0x12, 0x0D, 0xA8, 0x37, 0xDF,
  0x95, 0xA0, 0x4B, 0x81, 0x10, 0xCA, 0x07, 0xA0, 0x70, 0x3A, 0x06, 0xB2, 0x0B, 0xA0, 0x8A, 0x04,
  0x01, 0xA0, 0x8B, 0x20, 0x9A, 0x0A, 0xA8, 0x32, 0x0E, 0xFA, 0xA0, 0xD2, 0x08, 0xA0, 0xDA, 0x28,
  0x1C, 0xFC, 0xA0, 0xC2, 0x07, 0xC0, 0xD2, 0x0A, 0xC0, 0xB2, 0x06, 0xC0, 0xB2, 0x07, 0xC0, 0xA2,
  0x05, 0xC0, 0x82, 0x05, 0xC0, 0x91,
  // "ŵ" (U+0175)
  0x68, 0x00, 0x70, 0x27, 0x40, 0x6C, 0x0C, 0x73, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x72, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x37, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x0D, 0xA0, 0xA7, 0x10,
  0x6B, 0x01, 0x0B, 0xA0, 0xB7, 0x10, 0x7A, 0x81, 0xE0, 0x9A, 0x0D, 0x20, 0xAA, 0x0D, 0x20, 0x9A,
  0x81, 0xC0, 0x6A, 0x0E, 0x20, 0xDB, 0x81, 0x10, 0xAA, 0x81, 0xA0, 0x4B, 0x2C, 0x81, 0x40, 0xBA,
  0x81, 0x80, 0x2B, 0x01, 0x03, 0xC8, 0x17, 0x0D, 0xA0, 0x52, 0xB0, 0x30, 0x6A, 0x83, 0xDF, 0xA0,
  0xEA, 0x03, 0x20, 0xDA, 0x85, 0x49, 0xFD, 0xAF, 0xD1, 0xB0, 0x12, 0x0B, 0xA8, 0x36, 0xCF, 0xB7,
  0xA0, 0x2A, 0x0E, 0x30, 0x9A, 0x83, 0x7E, 0xF8, 0x5A, 0x05, 0xA0, 0xC3, 0x07, 0xA0, 0xAA, 0x05,
  0x02, 0xA0, 0x9A, 0x0A, 0x30, 0x5A, 0x0E, 0xA0, 0x21, 0xA0, 0xEA, 0x08, 0x30, 0x3D, 0x20, 0xCC,
  0x06, 0x4C, 0x0C, 0x20, 0xAC, 0x04, 0x40, 0xEB, 0x0A, 0x20, 0x7C, 0x02, 0x20,
  // "Ŷ" (U+0176)
  0x68, 0x00, 0x70, 0x27, 0x30, 0x6C, 0x0C, 0x72, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x71, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x36, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x77, 0x77, 0x03, 0xB0, 0xD6,
  0x0A, 0xB8, 0x16, 0x0B, 0xB0, 0x44, 0x01, 0xB0, 0xE2, 0x03, 0xB0, 0xB4, 0x07, 0xB0, 0x73, 0x0B,
  0xB0, 0x23, 0x0E, 0xA0, 0xE4, 0x04, 0xB0, 0x92, 0x05, 0xB0, 0x75, 0x0C, 0xA8, 0x2E, 0x10, 0xCA,
  0x0E, 0x01, 0x50, 0x4B, 0x07, 0x03, 0xB0, 0x87, 0x0C, 0xA0, 0xD0, 0x9B, 0x01, 0x70, 0x5E, 0x08,
  0x72, 0x0D, 0xD0, 0x17, 0x20, 0x6C, 0x09, 0x74, 0x0E, 0xB0, 0x27, 0x40, 0xDB, 0x01, 0x74, 0x0D,
  0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17,
  0x40, 0xDB, 0x01, 0x50,
  // "ŷ" (U+0177)
  0x68, 0x00, 0x70, 0x27, 0x30, 0x6C, 0x0C, 0x72, 0x02, 0x0E, 0xA0, 0xDA, 0x07, 0x71, 0x0C, 0xA8,
  0x15, 0x1D, 0xA0, 0x36, 0x82, 0x9F, 0xE4, 0x28, 0x21, 0xCF, 0xE7, 0x75, 0x04, 0xB0, 0xE6, 0x0A,
  0xB8, 0x17, 0x0D, 0xB0, 0x45, 0x0E, 0xB8, 0x11, 0x07, 0xB0, 0x94, 0x04, 0xB0, 0xB2, 0x01, 0xB0,
  0xE4, 0x09, 0xB0, 0x53, 0x0A, 0xB0, 0x43, 0x0D, 0xA0, 0xE4, 0x04, 0xB0, 0x92, 0x02, 0xB0, 0x95,
  0x0D, 0xA0, 0xE2, 0x07, 0xB0, 0x35, 0x07, 0xB8, 0x14, 0x0C, 0xA0, 0xD6, 0x01, 0xB0, 0x90, 0x1B,
  0x07, 0x70, 0xAA, 0x0E, 0x05, 0xB0, 0x27, 0x04, 0xB0, 0xAA, 0x0C, 0x72, 0x0D, 0xD0, 0x67, 0x20,
  0x7D, 0x01, 0x72, 0x01, 0xC0, 0xA7, 0x40, 0xBB, 0x04, 0x74, 0x0E, 0xA0, 0xD7, 0x40, 0x8B, 0x07,
  0x78, 0x21, 0x23, 0x8B, 0x0E, 0x01, 0x70, 0x6E, 0x05, 0x71, 0x06, 0xD0, 0x77, 0x28, 0x45, 0xEF,
  0xEA, 0x37, 0x20,
  // "Ÿ" (U+0178)
  0x38, 0x25, 0xEE, 0x52, 0x82, 0x2C, 0xE9, 0x60, 0xDA, 0x0D, 0x20, 0x8B, 0x03, 0x50, 0xDA, 0x0D,
  0x20, 0x8B, 0x02, 0x58, 0x25, 0xEE, 0x42, 0x82, 0x1C, 0xE9, 0x77, 0x77, 0x70, 0x3B, 0x0D, 0x60,
  0xAB, 0x81, 0x60, 0xBB, 0x04, 0x40, 0x1B, 0x0E, 0x20, 0x3B, 0x0B, 0x40, 0x7B, 0x07, 0x30, 0xBB,
  0x02, 0x30, 0xEA, 0x0E, 0x40, 0x4B, 0x09, 0x20, 0x5B, 0x07, 0x50, 0xCA, 0x82, 0xE1, 0x0C, 0xA0,
  0xE0, 0x15, 0x04, 0xB0, 0x70, 0x3B, 0x08, 0x70, 0xCA, 0x0D, 0x09, 0xB0, 0x17, 0x05, 0xE0, 0x87,
  0x20, 0xDD, 0x01, 0x72, 0x06, 0xC0, 0x97, 0x40, 0xEB, 0x02, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB,
  0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74, 0x0D, 0xB0, 0x17, 0x40, 0xDB, 0x01, 0x74,
  0x0D, 0xB0, 0x15,
  // "Ź" (U+0179)
  0x60, 0x38, 0x00, 0x77, 0x10, 0xDB, 0x05, 0x70, 0x8B, 0x05, 0x70, 0x3B, 0x05, 0x71, 0x82, 0xDF,
  0xE3, 0x77, 0x77, 0x30, 0x2F, 0xC0, 0x30, 0x2F, 0xC0, 0x30, 0x2F, 0xC0, 0x21, 0x80, 0x22, 0x07,
  0xB0, 0xA7, 0x10, 0xDB, 0x02, 0x70, 0x7B, 0x07, 0x70, 0x10, 0xEA, 0x0D, 0x71, 0x09, 0xB0, 0x57,
  0x03, 0xB0, 0xB7, 0x10, 0xCB, 0x02, 0x70, 0x5B, 0x09, 0x71, 0x0D, 0xA0, 0xE0, 0x17, 0x07, 0xB0,
  0x67, 0x01, 0x0E, 0xA0, 0xC7, 0x10, 0xAB, 0x03, 0x70, 0x3B, 0x0B, 0x80, 0x32, 0x10, 0xBF, 0xC0,
  0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // "ź" (U+017A)
  0x70, 0x38, 0x00, 0x77, 0x20, 0xDB, 0x05, 0x71, 0x08, 0xB0, 0x57, 0x10, 0x3B, 0x05, 0x72, 0x82,
  0xDF, 0xE3, 0x77, 0x60, 0xDF, 0xC8, 0x13, 0x0D, 0xFC, 0x81, 0x30, 0xDF, 0xC0, 0x21, 0x80, 0x22,
  0x04, 0x0E, 0xB0, 0x87, 0x10, 0xCB, 0x0B, 0x71, 0x09, 0xB0, 0xD0, 0x17, 0x06, 0xB0, 0xE0, 0x27,
  0x03, 0xC0, 0x47, 0x01, 0x0D, 0xB0, 0x77, 0x10, 0xBB, 0x0A, 0x71, 0x09, 0xB0, 0xC7, 0x10, 0x5B,
  0x0E, 0x04, 0x80, 0x22, 0x01, 0x02, 0xFD, 0x06, 0x03, 0xFD, 0x06, 0x03, 0xFD, 0x06,
  // "Ż" (U+017B)
  0x48, 0x27, 0xEE, 0x97, 0x10, 0x2C, 0x04, 0x70, 0x4C, 0x06, 0x70, 0x2C, 0x04, 0x71, 0x82, 0x7E,
  0xE9, 0x77, 0x77, 0x30, 0x2F, 0xC0, 0x30, 0x2F, 0xC0, 0x30, 0x2F, 0xC0, 0x21, 0x80, 0x22, 0x07,
  0xB0, 0xA7, 0x10, 0xDB, 0x02, 0x70, 0x7B, 0x07, 0x70, 0x10, 0xEA, 0x0D, 0x71, 0x09, 0xB0, 0x57,
  0x03, 0xB0, 0xB7, 0x10, 0xCB, 0x02, 0x70, 0x5B, 0x09, 0x71, 0x0D, 0xA0, 0xE0, 0x17, 0x07, 0xB0,
  0x67, 0x01, 0x0E, 0xA0, 0xC7, 0x10, 0xAB, 0x03, 0x70, 0x3B, 0x0B, 0x80, 0x32, 0x10, 0xBF, 0xC0,
  0x40, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // "ż" (U+017C)
  0x58, 0x27, 0xEE, 0x97, 0x20, 0x2C, 0x04, 0x71, 0x04, 0xC0, 0x67, 0x10, 0x2C, 0x04, 0x72, 0x82,
  0x7E, 0xE9, 0x77, 0x60, 0xDF, 0xC8, 0x13, 0x0D, 0xFC, 0x81, 0x30, 0xDF, 0xC0, 0x21, 0x80, 0x22,
  0x04, 0x0E, 0xB0, 0x87, 0x10, 0xCB, 0x0B, 0x71, 0x09, 0xB0, 0xD0, 0x17, 0x06, 0xB0, 0xE0, 0x27,
  0x03, 0xC0, 0x47, 0x01, 0x0D, 0xB0, 0x77, 0x10, 0xBB, 0x0A, 0x71, 0x09, 0xB0, 0xC7, 0x10, 0x5B,
  0x0E, 0x04, 0x80, 0x22, 0x01, 0x02, 0xFD, 0x06, 0x03, 0xFD, 0x06, 0x03, 0xFD, 0x06,
  // "Ž" (U+017D)
  0x18, 0x16, 0x76, 0x48, 0x15, 0x77, 0x30, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x40, 0x8A, 0x0A, 0x08,
  0xA0, 0xB6, 0x0C, 0xC0, 0xE0, 0x16, 0x03, 0xC0, 0x67, 0x77, 0x72, 0x02, 0xFC, 0x03, 0x02, 0xFC,
  0x03, 0x02, 0xFC, 0x02, 0x18, 0x02, 0x20, 0x7B, 0x0A, 0x71, 0x0D, 0xB0, 0x27, 0x07, 0xB0, 0x77,
  0x01, 0x0E, 0xA0, 0xD7, 0x10, 0x9B, 0x05, 0x70, 0x3B, 0x0B, 0x71, 0x0C, 0xB0, 0x27, 0x05, 0xB0,
  0x97, 0x10, 0xDA, 0x0E, 0x01, 0x70, 0x7B, 0x06, 0x70, 0x10, 0xEA, 0x0C, 0x71, 0x0A, 0xB0, 0x37,
  0x03, 0xB0, 0xB8, 0x03, 0x21, 0x0B, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04,
  // "ž" (U+017E)
  0x28, 0x16, 0x76, 0x48, 0x15, 0x77, 0x40, 0x5A, 0x0A, 0x20, 0x8A, 0x08, 0x50, 0x8A, 0x0A, 0x08,
  0xA0, 0xB7, 0x0C, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0x67, 0x75, 0x0D, 0xFC, 0x81, 0x30, 0xDF, 0xC8,
  0x13, 0x0D, 0xFC, 0x02, 0x18, 0x02, 0x20, 0x40, 0xEB, 0x08, 0x71, 0x0C, 0xB0, 0xB7, 0x10, 0x9B,
  0x0D, 0x01, 0x70, 0x6B, 0x0E, 0x02, 0x70, 0x3C, 0x04, 0x70, 0x10, 0xDB, 0x07, 0x71, 0x0B, 0xB0,
  0xA7, 0x10, 0x9B, 0x0C, 0x71, 0x05, 0xB0, 0xE0, 0x48, 0x02, 0x20, 0x10, 0x2F, 0xD0, 0x60, 0x3F,
  0xD0, 0x60, 0x3F, 0xD0, 0x60,
  // "ſ" (U+017F)
  0x28, 0x75, 0xBE, 0xFE, 0xC8, 0x09, 0xE0, 0xC0, 0x3F, 0x08, 0x07, 0xB8, 0x4C, 0x33, 0x73, 0x9B,
  0x05, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03,
  0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40,
  0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B, 0x03, 0x40, 0x9B,
  0x03, 0x40,
  // "Ω" (U+03A9)
  0x48, 0x62, 0x9D, 0xEE, 0xD9, 0x37, 0x07, 0xF9, 0x08, 0x50, 0x6F, 0xB0, 0x84, 0x0E, 0xB8, 0x29,
  0x33, 0x7C, 0x02, 0x20, 0x6B, 0x09, 0x40, 0x6B, 0x08, 0x20, 0xAB, 0x02, 0x50, 0xEA, 0x0C, 0x20,
  0xCA, 0x0E, 0x60, 0xAA, 0x0E, 0x20, 0xDA, 0x0C, 0x60, 0x9B, 0x20, 0xDA, 0x0B, 0x60, 0x8B, 0x20,
  0xCA, 0x0C, 0x60, 0x9A, 0x0E, 0x20, 0xBA, 0x0D, 0x60, 0xAA, 0x0D, 0x20, 0x7B, 0x60, 0xCA, 0x09,
  0x20, 0x2B, 0x03, 0x5B, 0x05, 0x30, 0xBA, 0x08, 0x40, 0x6A, 0x0D, 0x48, 0x32, 0xEF, 0xE1, 0x30,
  0xDA, 0x04, 0x28, 0x21, 0x22, 0x6A, 0x0C, 0x20, 0xAA, 0x83, 0x72, 0x21, 0x9E, 0x20, 0xED, 0x0C,
  0x09, 0xE2, 0x0E, 0xD0, 0xC0, 0x9E, 0x20, 0xED, 0x0C,
  // "μ" (U+03BC)
  0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0,
  0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B,
  0x0B, 0x0A, 0xB0, 0x44, 0x03, 0xB0, 0xB0, 0xAB, 0x04, 0x40, 0x3B, 0x0B, 0x0A, 0xB0, 0x44, 0x04,
  0xB0, 0xB0, 0xAB, 0x05, 0x40, 0x7B, 0x0B, 0x0A, 0xB0, 0x94, 0x0C, 0xB0, 0xB0, 0xAC, 0x82, 0x73,
  0x4B, 0xC0, 0xB0, 0xAF, 0xD0, 0xB0, 0xAF, 0x90, 0x60, 0xBA, 0x0B, 0x0A, 0xD8, 0x3D, 0x93, 0x06,
  0xA0, 0xB0, 0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20, 0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20,
  0xAB, 0x04, 0x72, 0x0A, 0xB0, 0x47, 0x20,
  // "π" (U+03C0)
  0x10, 0x50, 0xEF, 0xE0, 0xAF, 0xF9, 0x0C, 0xFF, 0x98, 0x11, 0x23, 0xB8, 0x2A, 0x22, 0xBB, 0x81,
  0x32, 0x22, 0x01, 0xB0, 0x92, 0x0A, 0xB5, 0x01, 0xB0, 0x92, 0x0A, 0xB5, 0x01, 0xB0, 0x92, 0x0A,
  0xB5, 0x01, 0xB0, 0x92, 0x0A, 0xB5, 0x01, 0xB0, 0x92, 0x0A, 0xB5, 0x01, 0xB0, 0x92, 0x0A, 0xB5,
  0x01, 0xB0, 0x92, 0x0A, 0xB5, 0x01, 0xB0, 0x92, 0x09, 0xB8, 0x17, 0x35, 0x20, 0x1B, 0x09, 0x20,
  0x6D, 0x0E, 0x20, 0x1B, 0x09, 0x20, 0x10, 0xEC, 0x0E, 0x20, 0x1B, 0x09, 0x38, 0x42, 0xAE, 0xED,
  0x90,
  // "–" (U+2013)
  0x18, 0x06, 0x20, 0x10, 0x4F, 0xB0, 0x70, 0x4F, 0xB0, 0x70, 0x4F, 0xB0, 0x70,
  // "—" (U+2014)
  0x80, 0x94, 0x21, 0xFF, 0xA0, 0x3F, 0xFA, 0x03, 0xFF, 0xA0, 0x30,
  // "€" (U+20AC)
  0x58, 0x71, 0x6B, 0xEF, 0xED, 0xA4, 0x50, 0x50, 0xEF, 0x90, 0x43, 0x06, 0xFA, 0x0D, 0x30, 0x3C,
  0x85, 0xB5, 0x33, 0x59, 0x53, 0x0A, 0xB0, 0x87, 0x30, 0xEA, 0x0E, 0x72, 0x0D, 0xFB, 0x02, 0x30,
  0xDF, 0xB0, 0x23, 0x02, 0x06, 0xB0, 0x98, 0x01, 0x25, 0x05, 0xB0, 0x77, 0x20, 0xDF, 0xB0, 0x23,
  0x0D, 0xFB, 0x02, 0x38, 0x12, 0x2E, 0xA0, 0xE8, 0x01, 0x26, 0x0B, 0xB0, 0x37, 0x30, 0x5B, 0x0C,
  0x74, 0x0C, 0xB8, 0x5D, 0x63, 0x35, 0x89, 0x40, 0x20, 0xEF, 0x90, 0xB5, 0x02, 0x0C, 0xF0, 0xB7,
  0x81, 0x5A, 0xDA, 0x81, 0xDA, 0x41,
  // "₿" (U+20BF)
  0x28, 0x51, 0xFB, 0x03, 0xF9, 0x78, 0x51, 0xFB, 0x03, 0xF9, 0x78, 0x51, 0xFB, 0x03, 0xF9, 0x50,
  0xDF, 0x81, 0xD8, 0x23, 0x0D, 0xFB, 0x07, 0x20, 0xDF, 0xC8, 0x14, 0x0D, 0xA8, 0x4D, 0x22, 0x35,
  0xDB, 0x81, 0x90, 0xDA, 0x0C, 0x40, 0x5B, 0x81, 0xA0, 0xDA, 0x0C, 0x40, 0x5B, 0x81, 0x80, 0xDA,
  0x0C, 0x30, 0x30, 0xCB, 0x81, 0x30, 0xDF, 0xB0, 0x72, 0x0D, 0xF9, 0x0E, 0x05, 0x30, 0xDF, 0xB0,
  0x92, 0x0D, 0xA8, 0x4D, 0x22, 0x25, 0xDB, 0x81, 0x70, 0xDA, 0x0C, 0x40, 0x3B, 0x81, 0xD0, 0xDA,
  0x0C, 0x5C, 0x10, 0xDA, 0x0C, 0x5C, 0x01, 0x0D, 0xA0, 0xC4, 0x04, 0xC1, 0x0D, 0xA8, 0x4D, 0x22,
  0x25, 0xDB, 0x81, 0xB0, 0xDF, 0xC8, 0x13, 0x0D, 0xFB, 0x06, 0x20, 0xDF, 0x81, 0xE9, 0x25, 0x85,
  0x1F, 0xB0, 0x3F, 0x97, 0x85, 0x1F, 0xB0, 0x3F, 0x97, 0x18, 0x47, 0x50, 0x17, 0x45,
  // "‘" (U+2018)
  0x20, 0x5A, 0x08, 0x20, 0xBA, 0x81, 0x50, 0x1B, 0x81, 0x10, 0x7A, 0x0E, 0x20, 0xCA, 0x81, 0xB0,
  0x2B, 0x81, 0x80, 0x5B, 0x06, 0x10,
  // "’" (U+2019)
  0x10, 0x1B, 0x81, 0xC0, 0x3B, 0x81, 0x80, 0x6B, 0x81, 0x30, 0x9A, 0x0D, 0x20, 0xCA, 0x08, 0x2B,
  0x81, 0x20, 0x3A, 0x0B, 0x20,
  // "‚" (U+201A)
  0x10, 0x5B, 0x81, 0x70, 0x8B, 0x81, 0x40, 0xBB, 0x20, 0xDA, 0x0A, 0x2B, 0x81, 0x60, 0x3B, 0x81,
  0x10, 0x6A, 0x0A, 0x20, 0xAA, 0x04, 0x20,
  // "‛" (U+201B)
  0x05, 0xB8, 0x16, 0x02, 0xB0, 0x82, 0x0C, 0xA0, 0xB2, 0x07, 0xA0, 0xE2, 0x01, 0xB0, 0x12, 0x0B,
  0xA0, 0x52, 0x05, 0xA0, 0x80,
  // "“" (U+201C)
  0x20, 0x5A, 0x08, 0x20, 0x5A, 0x08, 0x20, 0xBA, 0x05, 0x20, 0xBA, 0x81, 0x50, 0x1B, 0x81, 0x10,
  0x1B, 0x81, 0x10, 0x7A, 0x0E, 0x20, 0x7A, 0x0E, 0x20, 0xCA, 0x0B, 0x20, 0xCA, 0x81, 0xB0, 0x2B,
  0x81, 0x80, 0x2B, 0x81, 0x80, 0x5B, 0x81, 0x60, 0x5B, 0x06, 0x10,
  // "”" (U+201D)
  0x10, 0x6B, 0x81, 0x50, 0x6B, 0x81, 0x50, 0x8B, 0x81, 0x20, 0x8B, 0x81, 0x20, 0xBA, 0x0C, 0x20,
  0xBA, 0x0C, 0x20, 0xEA, 0x07, 0x20, 0xEA, 0x81, 0x70, 0x2B, 0x81, 0x10, 0x2B, 0x81, 0x10, 0x5A,
  0x0B, 0x20, 0x5A, 0x0B, 0x20, 0x8A, 0x05, 0x20, 0x8A, 0x05, 0x20,
  // "„" (U+201E)
  0x10, 0x5B, 0x81, 0x70, 0x5B, 0x81, 0x70, 0x8B, 0x81, 0x40, 0x8B, 0x81, 0x40, 0xBB, 0x20, 0xBB,
  0x20, 0xDA, 0x0A, 0x20, 0xDA, 0x0A, 0x2B, 0x06, 0x2B, 0x81, 0x60, 0x3B, 0x81, 0x10, 0x3B, 0x81,
  0x10, 0x6A, 0x0A, 0x20, 0x6A, 0x0A, 0x20, 0xAA, 0x04, 0x20, 0xAA, 0x04, 0x20,
  // "‟" (U+201F)
  0x05, 0xB8, 0x16, 0x05, 0xB8, 0x16, 0x02, 0xB8, 0x18, 0x02, 0xB0, 0x82, 0x0C, 0xA0, 0xB2, 0x0C,
  0xA0, 0xB2, 0x07, 0xA0, 0xE2, 0x07, 0xA0, 0xE2, 0x01, 0xB8, 0x11, 0x01, 0xB0, 0x12, 0x0B, 0xA0,
  0x52, 0x0B, 0xA0, 0x52, 0x05, 0xA0, 0x82, 0x05, 0xA0, 0x80,
  // "†" (U+2020)
  0x40, 0xBA, 0x0A, 0x71, 0x09, 0xA0, 0x87, 0x10, 0x7A, 0x06, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x4A,
  0x02, 0x48, 0x32, 0x87, 0x56, 0xA8, 0x45, 0x57, 0x84, 0x3F, 0xB0, 0x60, 0x3F, 0xB8, 0x46, 0x16,
  0x53, 0x3A, 0x83, 0x23, 0x46, 0x34, 0x02, 0xA0, 0x17, 0x10, 0x3A, 0x02, 0x71, 0x04, 0xA0, 0x37,
  0x10, 0x5A, 0x04, 0x71, 0x06, 0xA0, 0x57, 0x10, 0x7A, 0x05, 0x71, 0x08, 0xA0, 0x67, 0x10, 0x8A,
  0x07, 0x71, 0x09, 0xA0, 0x87, 0x10, 0xAA, 0x09, 0x71, 0x0B, 0xA0, 0xA7, 0x10, 0xCA, 0x0B, 0x40,
  // "‡" (U+2021)
  0x40, 0x9A, 0x0C, 0x71, 0x07, 0xA0, 0xA7, 0x10, 0x5A, 0x08, 0x71, 0x03, 0xA0, 0x64, 0x00, 0x12,
  0x01, 0xA0, 0x32, 0x81, 0x11, 0x5A, 0x0E, 0x0C, 0xA0, 0xD0, 0xEA, 0x08, 0x05, 0xFB, 0x84, 0x85,
  0xDB, 0xA9, 0xA8, 0x3A, 0xAB, 0xD7, 0x40, 0x2A, 0x05, 0x71, 0x06, 0xA0, 0x87, 0x10, 0x8A, 0x0B,
  0x71, 0x06, 0xA0, 0x87, 0x10, 0x3A, 0x05, 0x48, 0x34, 0xB9, 0x87, 0xA8, 0x48, 0x79, 0xA6, 0x5F,
  0xB0, 0x80, 0x5F, 0xB8, 0x48, 0x24, 0x21, 0x1A, 0x83, 0x31, 0x24, 0x24, 0x03, 0xA0, 0x57, 0x10,
  0x5A, 0x08, 0x71, 0x07, 0xA0, 0xA7, 0x10, 0x9A, 0x0C, 0x40,
  // "•" (U+2022)
  0x18, 0x72, 0xAE, 0xEB, 0x30, 0x1E, 0xD0, 0x30, 0x6E, 0x09, 0x08, 0xE0, 0xB0, 0x8E, 0x0B, 0x06,
  0xE8, 0x19, 0x1D, 0xD8, 0x62, 0x01, 0xAE, 0xEB, 0x31,
  // "…" (U+2026)
  0x18, 0x96, 0x7E, 0xE9, 0x07, 0xEE, 0x90, 0x7E, 0xE9, 0x02, 0xC0, 0x8C, 0x08, 0xC0, 0x05, 0xC0,
  0xCC, 0x0C, 0xC0, 0x70, 0x2C, 0x07, 0xC0, 0x7C, 0x89, 0x64, 0x06, 0xEE, 0x80, 0x6E, 0xE8, 0x06,
  0xEE, 0x81,
  // "‰" (U+2030)
  0x18, 0x34, 0xCE, 0xB2, 0x73, 0x01, 0x0E, 0xB0, 0xD7, 0x38, 0x55, 0xFD, 0x2E, 0xF4, 0x72, 0x85,
  0x7F, 0xB0, 0xDF, 0x57, 0x28, 0x93, 0x6F, 0xD1, 0xEF, 0x40, 0x1B, 0xFE, 0x53, 0x01, 0xC8, 0x5E,
  0x02, 0xDF, 0xD2, 0x58, 0x90, 0x5E, 0xFD, 0x45, 0xEF, 0xB1, 0x73, 0x08, 0xA0, 0x77, 0x38, 0x31,
  0xBF, 0xE4, 0x73, 0x83, 0x3D, 0xFC, 0x27, 0x30, 0x6A, 0x81, 0xA0, 0x15, 0x01, 0x38, 0x95, 0x15,
  0x54, 0x5E, 0xFD, 0x30, 0x2C, 0xFE, 0x64, 0x01, 0x0E, 0xB8, 0x1D, 0x0B, 0xC0, 0x23, 0x82, 0x5F,
  0xD2, 0xA0, 0x4A, 0x82, 0x4B, 0xF8, 0x38, 0x57, 0xFB, 0x0D, 0xF7, 0xA1, 0x81, 0x8F, 0xA3, 0x85,
  0x7F, 0xB0, 0xDF, 0x7A, 0x18, 0x18, 0xFA, 0x38, 0x24, 0xFE, 0x3A, 0x03, 0xA8, 0x25, 0xCF, 0x84,
  0x0E, 0xB8, 0x1C, 0x09, 0xC0, 0x24, 0x89, 0x13, 0xCF, 0xC2, 0x01, 0xAF, 0xD5, 0x10,
  // "‹" (U+2039)
  0x50, 0x36, 0x82, 0x9F, 0xB2, 0x30, 0x7B, 0x08, 0x20, 0x4B, 0x0B, 0x20, 0x20, 0xEA, 0x0D, 0x01,
  0x20, 0xDA, 0x0E, 0x02, 0x20, 0x9B, 0x07, 0x30, 0x30, 0xEA, 0x0D, 0x01, 0x30, 0x5B, 0x0B, 0x40,
  0x7B, 0x08, 0x40, 0xAB, 0x05, 0x48, 0x2C, 0xFE, 0x64, 0x81, 0x18, 0x11,
  // "›" (U+203A)
  0x18, 0x11, 0x81, 0x48, 0x26, 0xEF, 0xC4, 0x05, 0xB0, 0xA4, 0x08, 0xB0, 0x74, 0x0B, 0xB0, 0x53,
  0x01, 0x0D, 0xA0, 0xE0, 0x23, 0x07, 0xB0, 0x92, 0x02, 0x0E, 0xA0, 0xD2, 0x01, 0x0D, 0xA0, 0xE0,
  0x22, 0x0B, 0xB0, 0x42, 0x08, 0xB0, 0x73, 0x82, 0x2B, 0xF9, 0x60, 0x45,
  // "⁄" (U+2044)
  0x71, 0x0A, 0xA0, 0x37, 0x01, 0xA0, 0xC7, 0x10, 0x8A, 0x05, 0x71, 0x81, 0xEF, 0xE7, 0x10, 0x5A,
  0x08, 0x71, 0x0C, 0xA0, 0x27, 0x03, 0xA0, 0xA7, 0x10, 0x9A, 0x04, 0x78, 0x21, 0xEF, 0xD7, 0x10,
  0x6A, 0x07, 0x71, 0x0D, 0xA0, 0x17, 0x04, 0xA0, 0x97, 0x10, 0xAA, 0x03, 0x70, 0x1A, 0x0C, 0x71,
  0x08, 0xA0, 0x57, 0x18, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x87, 0x10, 0xCA, 0x02, 0x70, 0x3A, 0x0B,
  0x71,
  // "™" (U+2122)
  0x80, 0x2D, 0x83, 0x88, 0xDD, 0x42, 0x82, 0x9D, 0xD2, 0xE0, 0x09, 0xA8, 0x19, 0x01, 0xB0, 0x32,
  0x81, 0x8F, 0x62, 0x89, 0x09, 0xFD, 0xE0, 0x6F, 0xDF, 0x32, 0x81, 0x8F, 0x62, 0x89, 0x09, 0xF9,
  0xF4, 0xBC, 0xCF, 0x32, 0x81, 0x8F, 0x62, 0x89, 0x09, 0xF5, 0xFA, 0xF7, 0xCF, 0x32, 0x81, 0x8F,
  0x62, 0x82, 0x9F, 0x4B, 0xA8, 0x21, 0xCF, 0x32, 0x81, 0x8F, 0x62, 0x89, 0x09, 0xF4, 0x6F, 0xB0,
  0xCF, 0x32, 0x81, 0x8F, 0x62, 0x89, 0x09, 0xF4, 0x03, 0x10, 0xCF, 0x32, 0x81, 0x8F, 0x62, 0x81,
  0x9F, 0x44, 0x81, 0xCF, 0x32, 0x81, 0x47, 0x32, 0x81, 0x47, 0x14, 0x81, 0x57, 0x10,
  // "⅒" (U+2152)
  0x28, 0x21, 0xBF, 0xE7, 0x20, 0xAA, 0x03, 0x77, 0x40, 0x50, 0xEA, 0x0E, 0x71, 0x01, 0xA0, 0xC7,
  0x74, 0x0A, 0xC0, 0xE7, 0x10, 0x8A, 0x05, 0x77, 0x48, 0x49, 0xFB, 0xBF, 0xE7, 0x18, 0x1E, 0xFE,
  0x77, 0x58, 0x41, 0x60, 0xAF, 0xE7, 0x05, 0xA0, 0x87, 0x77, 0x18, 0x1A, 0xFE, 0x70, 0xCA, 0x02,
  0x77, 0x71, 0x81, 0xAF, 0xE6, 0x03, 0xA0, 0xA7, 0x77, 0x28, 0x1A, 0xFE, 0x60, 0x9A, 0x04, 0x38,
  0x21, 0xBF, 0xE5, 0x84, 0x5C, 0xEE, 0xB5, 0x58, 0x1A, 0xFE, 0x58, 0x21, 0xEF, 0xD3, 0x05, 0x0E,
  0xA0, 0xE4, 0x06, 0xE0, 0x74, 0x81, 0xAF, 0xE5, 0x06, 0xA0, 0x72, 0x0A, 0xC0, 0xE4, 0x84, 0xEF,
  0xE6, 0x5D, 0xA8, 0x22, 0x4D, 0xEC, 0x0D, 0x06, 0x20, 0xDA, 0x01, 0x28, 0x49, 0xFB, 0xBF, 0xE3,
  0x05, 0xA0, 0x62, 0x02, 0xA0, 0x70, 0x6F, 0x81, 0x80, 0x4A, 0x09, 0x38, 0x41, 0x60, 0xAF, 0xE3,
  0x08, 0xA0, 0x13, 0x81, 0xDF, 0xB7, 0x30, 0xAA, 0x03, 0x68, 0x1A, 0xFE, 0x30, 0x9A, 0x48, 0x1B,
  0xFC, 0x72, 0x01, 0xA0, 0xC7, 0x81, 0xAF, 0xE3, 0x09, 0xA4, 0x81, 0xBF, 0xC7, 0x20, 0x8A, 0x05,
  0x78, 0x1A, 0xFE, 0x30, 0x7A, 0x02, 0x38, 0x1D, 0xFB, 0x72, 0x81, 0xEF, 0xE7, 0x18, 0x1A, 0xFE,
  0x30, 0x4A, 0x06, 0x20, 0x2A, 0x07, 0x71, 0x05, 0xA0, 0x87, 0x18, 0x1A, 0xFE, 0x48, 0x4E, 0xFE,
  0x65, 0xDA, 0x02, 0x71, 0x0C, 0xA0, 0x25, 0x81, 0x4D, 0xEC, 0x82, 0xD6, 0x04, 0xE0, 0x87, 0x10,
  0x3A, 0x0B, 0x60, 0x6F, 0x08, 0x28, 0x44, 0xBE, 0xEC, 0x62,
  // "∂" (U+2202)
  0x48, 0x54, 0x9D, 0xFE, 0xC7, 0x60, 0x7F, 0x0C, 0x50, 0x8F, 0x90, 0x94, 0x84, 0x8E, 0x61, 0x16,
  0xC0, 0x13, 0x03, 0x01, 0x40, 0x7B, 0x06, 0x72, 0x01, 0xB0, 0x94, 0x85, 0x39, 0xCD, 0xA2, 0xEA,
  0x0B, 0x30, 0x9D, 0x00, 0xEA, 0x0B, 0x20, 0x8F, 0xB8, 0x1B, 0x03, 0xC8, 0x25, 0x02, 0xCB, 0x81,
  0xA0, 0xBB, 0x05, 0x30, 0x5B, 0x08, 0x01, 0xB0, 0xD4, 0x07, 0xB0, 0x05, 0xB0, 0x84, 0x0B, 0xB0,
  0x10, 0x7B, 0x05, 0x30, 0x1B, 0x81, 0xC0, 0x8B, 0x03, 0x30, 0x7B, 0x81, 0x60, 0x8B, 0x03, 0x20,
  0x20, 0xEA, 0x0E, 0x20, 0x5B, 0x82, 0xA0, 0x3D, 0xB0, 0x53, 0x0E, 0xF9, 0x09, 0x40, 0x4F, 0x08,
  0x68, 0x53, 0xAD, 0xFD, 0x93, 0x50,
  // "∆" (U+2206)
  0x50, 0x4C, 0x07, 0x73, 0x09, 0xC0, 0xC7, 0x30, 0xED, 0x02, 0x71, 0x04, 0xB0, 0xDA, 0x07, 0x71,
  0x09, 0xA0, 0xB0, 0x8A, 0x0C, 0x71, 0x0E, 0xA0, 0x70, 0x4B, 0x02, 0x60, 0x4B, 0x81, 0x20, 0xEA,
  0x07, 0x60, 0x9A, 0x0D, 0x20, 0xAA, 0x0C, 0x60, 0xEA, 0x08, 0x20, 0x5B, 0x02, 0x40, 0x4B, 0x03,
  0x3B, 0x07, 0x40, 0x9A, 0x0E, 0x40, 0xBA, 0x0C, 0x40, 0xEA, 0x09, 0x40, 0x6B, 0x02, 0x20, 0x4B,
  0x04, 0x40, 0x1B, 0x07, 0x20, 0x9B, 0x60, 0xCA, 0x0C, 0x20, 0xEA, 0x0A, 0x60, 0x7B, 0x02, 0x04,
  0xB0, 0x78, 0x02, 0x20, 0x5B, 0x07, 0x09, 0xFF, 0x0C, 0x0B, 0xFF, 0x0E, 0x0B, 0xFF, 0x0E,
  // "√" (U+221A)
  0x76, 0x0C, 0xA0, 0x47, 0x50, 0x1A, 0x0E, 0x76, 0x06, 0xA0, 0xA7, 0x60, 0xBA, 0x05, 0x75, 0x01,
  0xB7, 0x60, 0x5A, 0x0B, 0x76, 0x0A, 0xA0, 0x67, 0x60, 0xEA, 0x01, 0x75, 0x04, 0xA0, 0xC4, 0x80,
  0x02, 0x50, 0x9A, 0x07, 0x30, 0x2C, 0x04, 0x40, 0xEA, 0x02, 0x30, 0x2C, 0x0A, 0x30, 0x3A, 0x0C,
  0x40, 0x2C, 0x0E, 0x30, 0x8A, 0x08, 0x70, 0xAA, 0x05, 0x20, 0xDA, 0x03, 0x70, 0x4A, 0x81, 0xA0,
  0x2A, 0x0D, 0x72, 0x0E, 0xA0, 0x10, 0x7A, 0x09, 0x72, 0x09, 0xA0, 0x50, 0xCA, 0x04, 0x72, 0x03,
  0xA0, 0xCA, 0x0E, 0x74, 0x0D, 0xC0, 0x97, 0x40, 0x8C, 0x05, 0x74, 0x02, 0xC7, 0x60, 0xCA, 0x0A,
  0x76, 0x07, 0xA0, 0x67,
  // "∞" (U+221E)
  0x28, 0x38, 0xEE, 0xA2, 0x38, 0x39, 0xEE, 0xA1, 0x20, 0xBC, 0x82, 0xE3, 0x0C, 0xC8, 0x1D, 0x14,
  0xB0, 0xDA, 0x0E, 0x0A, 0xA0, 0xEB, 0x07, 0x09, 0xA8, 0x13, 0x05, 0xC8, 0x77, 0x02, 0xEF, 0xCA,
  0xFE, 0x30, 0x8A, 0x0C, 0x38, 0x2C, 0xFD, 0x9A, 0x82, 0x30, 0x4E, 0xB8, 0x57, 0x02, 0xEF, 0xB5,
  0xB0, 0xDA, 0x00, 0xDA, 0x0E, 0xB8, 0x17, 0x0B, 0xC8, 0x2E, 0x23, 0xEC, 0x0D, 0x38, 0x38, 0xEE,
  0xB2, 0x28, 0x43, 0xCE, 0xE9, 0x11,
  // "≈" (U+2248)
  0x18, 0x53, 0xBE, 0xFC, 0x71, 0x48, 0x11, 0x63, 0xE8, 0x6E, 0x94, 0x36, 0xD9, 0x6F, 0xD8, 0x69,
  0x6E, 0x73, 0x48, 0xEE, 0x81, 0x65, 0x25, 0x84, 0x6C, 0xEE, 0xC5, 0x77, 0x18, 0x11, 0x8D, 0xA8,
  0x90, 0xDA, 0x73, 0x10, 0x26, 0x76, 0xFD, 0x09, 0x06, 0xFD, 0x87, 0x96, 0xB5, 0x23, 0x59, 0xDC,
  0x0C, 0x03, 0x72, 0x00, 0x23,
  // "≠" (U+2260)
  0x71, 0x03, 0x02, 0x75, 0x82, 0xCF, 0xC3, 0x72, 0x02, 0xB0, 0x17, 0x20, 0x8A, 0x0B, 0x30, 0x1F,
  0xD0, 0x40, 0x1F, 0xD0, 0x40, 0x1F, 0xD0, 0x45, 0x01, 0xB0, 0x27, 0x20, 0x6A, 0x0D, 0x73, 0x0B,
  0xA0, 0x85, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x01, 0xFD, 0x04, 0x30, 0x4A, 0x0E, 0x73, 0x0A,
  0xA0, 0x97, 0x38, 0x25, 0xBF, 0x37, 0x50, 0x17, 0x10,
  // "≤" (U+2264)
  0x75, 0x02, 0x03, 0x73, 0x82, 0x2A, 0xF6, 0x71, 0x02, 0x0A, 0xB0, 0x66, 0x02, 0x0A, 0xC0, 0xD0,
  0x34, 0x02, 0x0A, 0xC0, 0xC0, 0x44, 0x02, 0x0A, 0xC0, 0xB0, 0x34, 0x02, 0x0A, 0xC0, 0xA0, 0x26,
  0x09, 0xB0, 0xC0, 0x27, 0x10, 0x8C, 0x0C, 0x06, 0x71, 0x03, 0x0A, 0xC8, 0x1E, 0x92, 0x78, 0x11,
  0x8E, 0xC0, 0xB0, 0x57, 0x10, 0x60, 0xDC, 0x0E, 0x04, 0x71, 0x04, 0x0B, 0xB0, 0x67, 0x38, 0x23,
  0x9F, 0x67, 0x58, 0x11, 0x27, 0x80, 0x90, 0xD0, 0x50, 0x9F, 0xD0, 0x60, 0x9F, 0xD0, 0x60,
  // "≥" (U+2265)
  0x03, 0x02, 0x75, 0x82, 0x6F, 0xA2, 0x73, 0x06, 0xB0, 0xA0, 0x27, 0x10, 0x30, 0xDC, 0x0A, 0x02,
  0x71, 0x04, 0x0C, 0xC0, 0xA0, 0x27, 0x10, 0x30, 0xBC, 0x0A, 0x02, 0x71, 0x02, 0x0A, 0xC0, 0xA0,
  0x27, 0x10, 0x20, 0xCB, 0x09, 0x70, 0x60, 0xCC, 0x08, 0x48, 0x12, 0x9E, 0xC0, 0xA0, 0x33, 0x05,
  0x0C, 0xC8, 0x1E, 0x81, 0x30, 0x40, 0xEC, 0x0D, 0x06, 0x60, 0x6B, 0x0B, 0x04, 0x71, 0x82, 0x6F,
  0x92, 0x73, 0x02, 0x01, 0x75, 0x05, 0x80, 0x90, 0xD0, 0x70, 0x6F, 0xD0, 0x90, 0x6F, 0xD0, 0x90,
};

const Font& font_NotoSansMono_Bold_27() {
  static SmoothFont font(font_NotoSansMono_Bold_27_data);
  return font;
}

}  // namespace roo_display
