#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:06 CET 2022
static const uint8_t font_NotoSansMono_Bold_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFD, 0xFD, 0x12, 0x0E, 0x0A, 0xFD, 0x05, 0x00, 0x16, 0x05, 0x07, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x02, 0x01, 0x04, 0x09, 0x07, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x07, 0x05, 0x09, 0x07, 0x00, 0x0F, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x18, // "#" (U+0023)
  0x00, 0x24, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x00, 0x36, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x07, 0x09, 0x07, 0x00, 0x54, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x7B, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x07, 0x04, 0x09, 0x07, 0x00, 0x9C, // "'" (U+0027)
  0x00, 0x28, 0x02, 0xFF, 0x05, 0x09, 0x07, 0x00, 0xA2, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFF, 0x04, 0x09, 0x07, 0x00, 0xBD, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x05, 0x06, 0x0A, 0x07, 0x00, 0xD8, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x06, 0x07, 0x07, 0x00, 0xEB, // "+" (U+002B)
  0x00, 0x2C, 0x02, 0xFF, 0x04, 0x02, 0x07, 0x00, 0xFC, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x03, 0x05, 0x05, 0x07, 0x01, 0x04, // "-" (U+002D)
  0x00, 0x2E, 0x02, 0x01, 0x04, 0x03, 0x07, 0x01, 0x0C, // "." (U+002E)
  0x00, 0x2F, 0x01, 0x01, 0x05, 0x09, 0x07, 0x01, 0x12, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0x2B, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x06, 0x09, 0x07, 0x01, 0x4D, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0x65, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0x86, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xA7, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xC6, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xE5, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x07, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x23, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x46, // "9" (U+0039)
  0x00, 0x3A, 0x02, 0x01, 0x04, 0x07, 0x07, 0x02, 0x68, // ":" (U+003A)
  0x00, 0x3B, 0x02, 0xFF, 0x04, 0x07, 0x07, 0x02, 0x73, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x08, 0x07, 0x02, 0x80, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x06, 0x08, 0x07, 0x02, 0x92, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x02, 0x06, 0x08, 0x07, 0x02, 0xA4, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x06, 0x09, 0x07, 0x02, 0xB7, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x07, 0x09, 0x07, 0x02, 0xD3, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0xFF, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x06, 0x09, 0x07, 0x03, 0x20, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x3C, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x5A, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x06, 0x09, 0x07, 0x03, 0x7D, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x06, 0x09, 0x07, 0x03, 0x93, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0xA8, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0xCB, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x06, 0x09, 0x07, 0x03, 0xEC, // "I" (U+0049)
  0x00, 0x4A, 0x01, 0x01, 0x05, 0x09, 0x07, 0x04, 0x07, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x1E, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x06, 0x09, 0x07, 0x04, 0x40, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x58, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x7A, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x9C, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x06, 0x09, 0x07, 0x04, 0xC0, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x06, 0x09, 0x07, 0x04, 0xD8, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x06, 0x09, 0x07, 0x05, 0x01, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x1D, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x3D, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x59, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x7A, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x9B, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0xBD, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0xDF, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x06, 0x09, 0x07, 0x05, 0xFE, // "Z" (U+005A)
  0x00, 0x5B, 0x02, 0xFE, 0x05, 0x09, 0x07, 0x06, 0x19, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x05, 0x09, 0x07, 0x06, 0x33, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0xFF, 0x04, 0x0A, 0x07, 0x06, 0x4B, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x06, 0x09, 0x07, 0x06, 0x65, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x07, 0x00, 0x07, 0x06, 0x78, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x09, 0x04, 0x0A, 0x07, 0x06, 0x7F, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x85, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x9F, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0xC2, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0xDA, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0xFD, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x17, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x07, 0x39, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x5E, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x81, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFE, 0x05, 0x0A, 0x07, 0x07, 0x9F, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0xC4, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0xE8, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0x07, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0x21, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0x3C, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x08, 0x56, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x08, 0x78, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0x9B, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x06, 0x07, 0x07, 0x08, 0xB3, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x06, 0x09, 0x07, 0x08, 0xCB, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0xE7, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0x01, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x07, 0x07, 0x07, 0x09, 0x1C, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0x3A, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x09, 0x55, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0x79, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFE, 0x05, 0x09, 0x07, 0x09, 0x8F, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x04, 0x0A, 0x07, 0x09, 0xAE, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFF, 0x05, 0x0A, 0x07, 0x09, 0xC3, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x06, 0x06, 0x07, 0x09, 0xE2, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFE, 0x04, 0x06, 0x07, 0x09, 0xF2, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0x01, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x06, 0x09, 0x07, 0x0A, 0x1F, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x06, 0x08, 0x07, 0x0A, 0x3A, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0x55, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x04, 0x0A, 0x07, 0x0A, 0x76, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x0A, 0x89, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x08, 0x05, 0x09, 0x07, 0x0A, 0xA6, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0xAD, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x05, 0x05, 0x09, 0x07, 0x0A, 0xCB, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x06, 0x06, 0x07, 0x0A, 0xD9, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x06, 0x06, 0x07, 0x0A, 0xF1, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0xFF, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x08, 0x05, 0x0A, 0x07, 0x0B, 0x1D, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x05, 0x05, 0x0A, 0x07, 0x0B, 0x25, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0B, 0x35, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x06, 0x05, 0x0A, 0x07, 0x0B, 0x4C, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x06, 0x05, 0x0A, 0x07, 0x0B, 0x5B, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x09, 0x05, 0x0A, 0x07, 0x0B, 0x6A, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x0B, 0x6F, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x06, 0x0A, 0x07, 0x0B, 0x92, // "¶" (U+00B6)
  0x00, 0xB7, 0x02, 0x04, 0x04, 0x06, 0x07, 0x0B, 0xBE, // "·" (U+00B7)
  0x00, 0xB8, 0x02, 0xFE, 0x04, 0x00, 0x07, 0x0B, 0xC4, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x06, 0x05, 0x0A, 0x07, 0x0B, 0xCA, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x06, 0x05, 0x09, 0x07, 0x0B, 0xD8, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0B, 0xE4, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0B, 0xFC, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x06, 0x09, 0x07, 0x0C, 0x1D, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0C, 0x40, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x05, 0x06, 0x07, 0x0C, 0x64, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x80, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0xA8, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0xD0, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0xF9, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0D, 0x25, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x0D, 0x4E, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0D, 0x7C, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x0D, 0x9D, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0xC4, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0xE1, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0xFE, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x0E, 0x1C, // "Ë" (U+00CB)
  0x00, 0xCC, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0x3A, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0x5C, // "Í" (U+00CD)
  0x00, 0xCE, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0x7E, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x0E, 0xA1, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0E, 0xC3, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0xE5, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x13, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x3D, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x67, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x92, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0F, 0xC1, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x02, 0x05, 0x07, 0x07, 0x0F, 0xED, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x06, 0x0A, 0x07, 0x0F, 0xFD, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0x21, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0x49, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0x71, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x10, 0x9A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0xC3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x06, 0x09, 0x07, 0x10, 0xE9, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x11, 0x02, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x11, 0x29, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x11, 0x4A, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x11, 0x6B, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x11, 0x8D, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x09, 0x07, 0x11, 0xB2, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x11, 0xD4, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x07, 0x07, 0x07, 0x11, 0xFB, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x12, 0x18, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x38, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x59, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x7A, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x09, 0x07, 0x12, 0x9C, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xBE, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xDB, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xF8, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x06, 0x09, 0x07, 0x13, 0x16, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0x34, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0x59, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0x7F, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xA0, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xC1, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xE3, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x09, 0x07, 0x14, 0x08, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x06, 0x08, 0x07, 0x14, 0x2A, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x07, 0x07, 0x14, 0x3E, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x5A, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x7B, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x9C, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x06, 0x09, 0x07, 0x14, 0xBE, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x14, 0xE0, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x15, 0x0B, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x15, 0x36, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x61, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x15, 0x8B, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0xAE, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x15, 0xDA, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x07, 0x09, 0x07, 0x15, 0xFF, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x06, 0x07, 0x07, 0x16, 0x2C, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x51, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0x76, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x94, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0xBA, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x16, 0xD9, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0xFF, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x1F, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x45, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x64, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x17, 0x8F, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x06, 0x09, 0x07, 0x17, 0xB8, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x17, 0xDA, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x03, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x18, 0x22, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x45, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x18, 0x65, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x18, 0x8A, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0xA9, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x06, 0x09, 0x07, 0x18, 0xCB, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x18, 0xEC, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x19, 0x0F, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x19, 0x2D, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x19, 0x4F, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x19, 0x7A, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x19, 0xA6, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x19, 0xD4, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x1A, 0x04, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x06, 0x0B, 0x07, 0x1A, 0x2F, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1A, 0x5C, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x1A, 0x86, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1A, 0xB1, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x06, 0x0D, 0x07, 0x1A, 0xDA, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x07, 0x09, 0x07, 0x1B, 0x09, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0x2C, // "ħ" (U+0127)
  0x01, 0x28, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x1B, 0x50, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0x75, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x1B, 0x96, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0xBA, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x1B, 0xD9, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0xFE, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFD, 0x06, 0x09, 0x07, 0x1C, 0x1F, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x1C, 0x45, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x1C, 0x6E, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x06, 0x07, 0x07, 0x1C, 0x92, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0x01, 0x06, 0x09, 0x07, 0x1C, 0xA8, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFE, 0x06, 0x0A, 0x07, 0x1C, 0xC5, // "ĳ" (U+0133)
  0x01, 0x34, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x1C, 0xEE, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFE, 0x05, 0x0A, 0x07, 0x1D, 0x0E, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1D, 0x34, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x1D, 0x5D, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x06, 0x07, 0x07, 0x1D, 0x87, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x1D, 0xA2, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x1D, 0xC1, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x06, 0x09, 0x07, 0x1D, 0xE7, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x1E, 0x05, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x06, 0x09, 0x07, 0x1E, 0x2B, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1E, 0x44, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x06, 0x09, 0x07, 0x1E, 0x66, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x08, 0x0A, 0x07, 0x1E, 0x80, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x06, 0x09, 0x07, 0x1E, 0xA6, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1E, 0xC4, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1E, 0xE5, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1F, 0x0E, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1F, 0x30, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x1F, 0x59, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1F, 0x7A, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1F, 0xA4, // "ň" (U+0148)
  0x01, 0x49, 0xFE, 0x01, 0x06, 0x09, 0x07, 0x1F, 0xC7, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1F, 0xEF, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x20, 0x1C, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x41, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x20, 0x6E, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x91, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x20, 0xC0, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0xE5, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x21, 0x13, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x06, 0x09, 0x07, 0x21, 0x38, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x07, 0x07, 0x07, 0x21, 0x5A, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x21, 0x79, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x21, 0x9C, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFE, 0x06, 0x09, 0x07, 0x21, 0xBB, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x21, 0xDE, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x21, 0xFC, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x22, 0x20, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x22, 0x40, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x22, 0x66, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x22, 0x84, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x22, 0xAB, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x22, 0xCA, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFE, 0x06, 0x07, 0x07, 0x22, 0xF2, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0x12, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x23, 0x39, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x23, 0x58, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x23, 0x7D, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0xA2, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x23, 0xC6, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x09, 0x07, 0x23, 0xE7, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x06, 0x09, 0x07, 0x24, 0x05, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x24, 0x24, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x24, 0x51, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x24, 0x77, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x24, 0xA1, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x24, 0xC4, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x24, 0xF1, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x25, 0x17, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x25, 0x46, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x25, 0x6E, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x25, 0x9A, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x25, 0xBF, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x06, 0x07, 0x07, 0x25, 0xE9, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x26, 0x0E, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x26, 0x38, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x26, 0x5E, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x26, 0x85, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x26, 0xB1, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x26, 0xD8, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x26, 0xF9, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x27, 0x15, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x27, 0x38, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x27, 0x56, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x27, 0x78, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x06, 0x0A, 0x07, 0x27, 0x95, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x06, 0x09, 0x07, 0x27, 0xB3, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x27, 0xD7, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x07, 0x07, 0x27, 0xFA, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x03, 0x05, 0x05, 0x07, 0x28, 0x16, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x05, 0x07, 0x28, 0x1E, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x06, 0x09, 0x07, 0x28, 0x25, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x06, 0x0B, 0x07, 0x28, 0x46, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x07, 0x04, 0x09, 0x07, 0x28, 0x6E, // "‘" (U+2018)
  0x20, 0x19, 0x02, 0x07, 0x04, 0x09, 0x07, 0x28, 0x74, // "’" (U+2019)
  0x20, 0x1A, 0x02, 0xFF, 0x04, 0x02, 0x07, 0x28, 0x7A, // "‚" (U+201A)
  0x20, 0x1B, 0x02, 0x07, 0x04, 0x09, 0x07, 0x28, 0x82, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x07, 0x05, 0x09, 0x07, 0x28, 0x88, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x06, 0x05, 0x08, 0x07, 0x28, 0x91, // "”" (U+201D)
  0x20, 0x1E, 0x01, 0xFF, 0x06, 0x02, 0x07, 0x28, 0x9A, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x06, 0x05, 0x08, 0x07, 0x28, 0xA8, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x28, 0xB1, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x28, 0xCD, // "‡" (U+2021)
  0x20, 0x22, 0x02, 0x04, 0x05, 0x07, 0x07, 0x28, 0xE9, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x06, 0x03, 0x07, 0x28, 0xF2, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x06, 0x09, 0x07, 0x28, 0xFE, // "‰" (U+2030)
  0x20, 0x39, 0x02, 0x01, 0x05, 0x06, 0x07, 0x29, 0x1F, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x04, 0x07, 0x07, 0x29, 0x2D, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x02, 0x09, 0x00, 0x29, 0x3B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x05, 0x07, 0x09, 0x07, 0x29, 0x54, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x12, 0x09, 0x16, 0x29, 0x6A, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x00, 0x06, 0x08, 0x07, 0x29, 0xAA, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x07, 0x09, 0x07, 0x29, 0xCA, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x29, 0xED, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x02, 0x06, 0x06, 0x07, 0x2A, 0x12, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x03, 0x06, 0x07, 0x07, 0x2A, 0x25, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x01, 0x06, 0x08, 0x07, 0x2A, 0x38, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x00, 0x06, 0x08, 0x07, 0x2A, 0x52, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x00, 0x06, 0x08, 0x07, 0x2A, 0x6E, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x8B, 0x16, 0xF9, 0x5F, 0x84, 0xF8, 0x4F, 0x73, 0xF6, 0x2F, 0x60, 0x10, 0x5F, 0x84, 0xE7,
  // """ (U+0022)
  0x89, 0x56, 0xF3, 0xF9, 0x5F, 0x1E, 0x83, 0xF0, 0xD6,
  // "#" (U+0023)
  0x28, 0x27, 0xB4, 0xE3, 0x89, 0x39, 0x86, 0xC0, 0x12, 0xC8, 0x9B, 0x27, 0xE8, 0x64, 0x8F, 0x7E,
  0x96, 0xCD, 0x89, 0x3A, 0x4A, 0xC7, 0xF5, 0x30, 0x99, 0x5D, 0x38, 0x2B, 0x78, 0xA2,
  // "$" (U+0024)
  0x20, 0xB3, 0x89, 0x53, 0xCF, 0xEA, 0x0D, 0xDD, 0x8A, 0x0F, 0x9B, 0x30, 0x9A, 0x04, 0x38, 0x26,
  0xEF, 0x93, 0x89, 0x1B, 0x8F, 0x29, 0x4C, 0x9F, 0x2E, 0xB0, 0x92, 0x81, 0x3D, 0x32,
  // "%" (U+0025)
  0x89, 0x46, 0xEB, 0x02, 0xF2, 0x0E, 0xAE, 0x59, 0xA2, 0x84, 0xE6, 0xD8, 0xF2, 0x28, 0x3A, 0xFE,
  0xBA, 0x48, 0x34, 0x3F, 0x31, 0x48, 0x39, 0xAB, 0xFB, 0x28, 0xA4, 0x1F, 0x6F, 0x6F, 0x20, 0x8B,
  0x2F, 0x8F, 0x11, 0xE3, 0x09, 0xE9, 0x10,
  // "&" (U+0026)
  0x18, 0x25, 0xEE, 0x53, 0x82, 0xDC, 0xCE, 0x38, 0x2D, 0x89, 0xC3, 0x07, 0xA0, 0x33, 0x8C, 0x0C,
  0xFD, 0x0E, 0x86, 0xF6, 0xFC, 0xF5, 0x9E, 0x07, 0xFE, 0x07, 0xF9, 0xBF, 0xE1, 0x0A, 0xFD, 0x7F,
  0xA0,
  // "'" (U+0027)
  0x87, 0x3F, 0x51, 0xF4, 0x0F, 0x30,
  // "(" (U+0028)
  0x18, 0x92, 0x5F, 0x20, 0xD9, 0x03, 0xF3, 0x07, 0x92, 0x0A, 0x0D, 0x20, 0xA0, 0xC2, 0x0A, 0x0D,
  0x20, 0x89, 0x28, 0x14, 0xF3, 0x20, 0xD0, 0x92, 0x81, 0x5F, 0x20,
  // ")" (U+0029)
  0x81, 0x2F, 0x52, 0x09, 0x0D, 0x28, 0x14, 0xF4, 0x29, 0x07, 0x20, 0xD0, 0xA2, 0x0C, 0x0A, 0x20,
  0xD0, 0xA2, 0x98, 0x92, 0x70, 0x3F, 0x40, 0x9D, 0x02, 0xF5, 0x10,
  // "*" (U+002A)
  0x29, 0x04, 0x28, 0x54, 0x1F, 0x34, 0x0E, 0xC8, 0x33, 0x09, 0xEC, 0x28, 0x33, 0xF3, 0xE6, 0x28,
  0x13, 0x02, 0x20,
  // "+" (U+002B)
  0x39, 0x04, 0x38, 0x52, 0x2F, 0x52, 0x02, 0xD8, 0x65, 0x05, 0x5F, 0x75, 0x13, 0x90, 0x45, 0x90,
  0x42,
  // "," (U+002C)
  0x89, 0x11, 0xF9, 0x3F, 0x56, 0xF1, 0x9C, 0x10,
  // "-" (U+002D)
  0x10, 0xF2, 0x10, 0x3B, 0x84, 0x61, 0x55, 0x52,
  // "." (U+002E)
  0x18, 0x61, 0x05, 0xF8, 0x4E, 0x70,
  // "/" (U+002F)
  0x30, 0xA0, 0xC2, 0x81, 0x1F, 0x72, 0x81, 0x6F, 0x12, 0x0C, 0x0B, 0x28, 0x12, 0xF5, 0x20, 0x80,
  0xE3, 0x0D, 0x09, 0x28, 0x13, 0xF4, 0x20, 0x90, 0xD3,
  // "0" (U+0030)
  0x18, 0x32, 0xCF, 0xD4, 0x28, 0xE4, 0xDE, 0x8D, 0xE1, 0x3F, 0x81, 0xEF, 0x55, 0xF5, 0x9E, 0xF8,
  0x6F, 0x7F, 0x5F, 0x95, 0xFE, 0x92, 0xF8, 0x2F, 0xE1, 0x5F, 0x50, 0xCE, 0x8D, 0xE1, 0x02, 0xCF,
  0xD4, 0x10,
  // "1" (U+0031)
  0x18, 0x18, 0xFB, 0x20, 0xDA, 0x0B, 0x28, 0x28, 0x5F, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4,
  0x90, 0xB2, 0x85, 0x36, 0xFD, 0x51, 0x9C, 0x05,
  // "2" (U+0032)
  0x18, 0x95, 0x6C, 0xFD, 0x60, 0x1E, 0xC8, 0xDF, 0x30, 0x22, 0x81, 0x6F, 0x64, 0x81, 0x9F, 0x33,
  0x81, 0x4F, 0xA3, 0x82, 0x3E, 0xC1, 0x28, 0x22, 0xEC, 0x12, 0x86, 0x1E, 0xF8, 0x77, 0x44, 0xD0,
  0xA0,
  // "3" (U+0033)
  0x18, 0x37, 0xDE, 0xC5, 0x28, 0x4C, 0xB7, 0xDF, 0x14, 0x81, 0x8F, 0x12, 0x82, 0x23, 0xDB, 0x38,
  0x2E, 0xFD, 0x33, 0x83, 0x46, 0xCF, 0x24, 0x89, 0x66, 0xF5, 0x2B, 0x88, 0xDF, 0x21, 0xBE, 0xFC,
  0x51,
  // "4" (U+0034)
  0x38, 0x14, 0xF9, 0x48, 0x1D, 0xF9, 0x38, 0x27, 0xEF, 0x92, 0x83, 0x1E, 0x7F, 0x92, 0x89, 0x49,
  0xD1, 0xF9, 0x03, 0xF6, 0x2F, 0xA1, 0x7D, 0x86, 0xB2, 0x55, 0x5F, 0xB3, 0x49, 0x09, 0x10,
  // "5" (U+0035)
  0x10, 0xAB, 0x0C, 0x28, 0x3B, 0xF8, 0x87, 0x20, 0xC0, 0xD5, 0x83, 0xDE, 0xB9, 0x22, 0x83, 0xAB,
  0xCF, 0xD5, 0x81, 0xBF, 0x34, 0x87, 0x9F, 0x31, 0xD9, 0x9F, 0xD2, 0x83, 0xBE, 0xEB, 0x21,
  // "6" (U+0036)
  0x28, 0x26, 0xCF, 0xE2, 0x83, 0x7F, 0xC8, 0x72, 0x82, 0xEB, 0x01, 0x28, 0xC7, 0x3F, 0xAE, 0xFA,
  0x05, 0xFE, 0x6B, 0xF5, 0x4F, 0x80, 0x4F, 0x72, 0xF8, 0x04, 0xF6, 0x0B, 0xE8, 0xCF, 0x20, 0x1B,
  0xFD, 0x51,
  // "7" (U+0037)
  0x06, 0xD8, 0x69, 0x27, 0x77, 0xAF, 0x64, 0x81, 0xBE, 0x13, 0x81, 0x2F, 0x94, 0x81, 0x9F, 0x33,
  0x81, 0x1E, 0xC4, 0x81, 0x7F, 0x54, 0x0D, 0x0E, 0x48, 0x14, 0xF8, 0x30,
  // "8" (U+0038)
  0x18, 0x33, 0xBE, 0xC5, 0x28, 0xA1, 0xDE, 0x8D, 0xF1, 0x0F, 0xC0, 0x8F, 0x20, 0x9F, 0xBF, 0xB2,
  0x02, 0x0E, 0xA0, 0x32, 0x8B, 0x0E, 0xD3, 0xCE, 0x24, 0xF6, 0x03, 0xF6, 0x2F, 0xD7, 0xCF, 0x40,
  0x4C, 0xED, 0x61,
  // "9" (U+0039)
  0x18, 0xB3, 0x4C, 0xFC, 0x30, 0x1E, 0xD7, 0xDE, 0x04, 0xF7, 0x05, 0xF5, 0x3F, 0xA2, 0xAF, 0x70,
  0xBA, 0x81, 0xCF, 0x82, 0x83, 0x33, 0x5F, 0x64, 0x87, 0xBF, 0x20, 0x68, 0xCF, 0xA2, 0x82, 0xBF,
  0xD7, 0x20,
  // ":" (U+003A)
  0x86, 0x4E, 0x75, 0xF8, 0x01, 0x58, 0x61, 0x05, 0xF8, 0x4E, 0x70,
  // ";" (U+003B)
  0x86, 0x1E, 0xB2, 0xFC, 0x01, 0x78, 0x91, 0x1F, 0x93, 0xF5, 0x6F, 0x19, 0xC1,
  // "<" (U+003C)
  0x50, 0x13, 0x89, 0x31, 0x8E, 0x01, 0x8E, 0xC5, 0x2E, 0xE5, 0x38, 0x27, 0xED, 0x64, 0x81, 0x7E,
  0xD5, 0x06,
  // "=" (U+003D)
  0x18, 0x01, 0x21, 0x02, 0xD0, 0x51, 0x80, 0x15, 0x01, 0x18, 0x01, 0x21, 0x02, 0xD0, 0x51, 0x80,
  0x15, 0x01,
  // ">" (U+003E)
  0x01, 0x58, 0x1E, 0x81, 0x38, 0x35, 0xCE, 0x81, 0x38, 0x93, 0x5E, 0xE2, 0x06, 0xDE, 0x70, 0xDE,
  0x73, 0x06, 0x50,
  // "?" (U+003F)
  0x89, 0x27, 0xCE, 0xD5, 0x0A, 0xB8, 0xDF, 0x13, 0x81, 0x8F, 0x22, 0x81, 0x4E, 0xC2, 0x81, 0x3F,
  0xB3, 0x81, 0x7F, 0x14, 0x01, 0x48, 0x1A, 0xF3, 0x38, 0x19, 0xE2, 0x20,
  // "@" (U+0040)
  0x18, 0x31, 0xAE, 0xD6, 0x38, 0xA0, 0xCD, 0x89, 0xF5, 0x06, 0xE1, 0x10, 0x7C, 0x0B, 0x76, 0xA8,
  0xC7, 0x5F, 0x1E, 0x3E, 0x8E, 0x4F, 0x2F, 0x4F, 0x0E, 0x3F, 0x1E, 0x5F, 0x5F, 0x8F, 0x0B, 0x9C,
  0xFB, 0xF9, 0x04, 0xF9, 0x63, 0x83, 0x07, 0xB0, 0xC4, 0x81, 0x14, 0x33,
  // "A" (U+0041)
  0x28, 0x1A, 0xFC, 0x48, 0x2E, 0xEF, 0x12, 0x83, 0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83,
  0xAE, 0x0B, 0xD2, 0x85, 0xED, 0x8C, 0xF2, 0x3D, 0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C,
  0x0E,
  // "B" (U+0042)
  0xB8, 0xA3, 0xD8, 0x0F, 0xC7, 0xCF, 0x5F, 0x90, 0x4F, 0x7F, 0x92, 0x8F, 0x4C, 0x8A, 0x2A, 0x0F,
  0xB5, 0x9F, 0x7F, 0x90, 0x2F, 0xAF, 0xC7, 0xBF, 0x7B, 0x0E, 0x09, 0x10,
  // "C" (U+0043)
  0x28, 0x95, 0x6C, 0xFD, 0x60, 0x7F, 0xB7, 0xA4, 0x0F, 0xC4, 0x81, 0x4F, 0x74, 0x81, 0x5F, 0x64,
  0x81, 0x5F, 0x64, 0x81, 0x2F, 0xB5, 0x84, 0xAF, 0xB7, 0xA5, 0x28, 0x39, 0xEF, 0xD3,
  // "D" (U+0044)
  0x07, 0xB8, 0xA2, 0xB3, 0x07, 0xF9, 0x8E, 0xE2, 0x7F, 0x30, 0x4F, 0x87, 0xF3, 0x29, 0x82, 0xC7,
  0xF3, 0x28, 0x3E, 0xC7, 0xF3, 0x29, 0x89, 0x6B, 0x7F, 0x30, 0x5F, 0x87, 0xF9, 0x8E, 0xE1, 0x7A,
  0x81, 0xEB, 0x21,
  // "E" (U+0045)
  0xD8, 0x75, 0xFC, 0x77, 0x72, 0xF9, 0x49, 0x0A, 0x0F, 0x21, 0xD8, 0x72, 0xFB, 0x55, 0x50, 0xF9,
  0x49, 0x83, 0xC7, 0x77, 0x2D, 0x05,
  // "F" (U+0046)
  0xD8, 0x75, 0xFC, 0x77, 0x72, 0xF9, 0x49, 0x0A, 0x0F, 0x21, 0xD8, 0x72, 0xFB, 0x55, 0x50, 0xF9,
  0x49, 0x09, 0x49, 0x09, 0x40,
  // "G" (U+0047)
  0x18, 0x96, 0x19, 0xEE, 0xC4, 0x0B, 0xFA, 0x7A, 0x34, 0xF9, 0x48, 0x91, 0x7F, 0x30, 0x22, 0x19,
  0xF1, 0x1A, 0x89, 0x1A, 0x8F, 0x30, 0x5E, 0xA5, 0xF8, 0x28, 0x96, 0xEA, 0x0D, 0xF9, 0x7E, 0xA0,
  0x2A, 0xEF, 0xD6,
  // "H" (U+0048)
  0x8B, 0x37, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x52, 0x3F, 0xA7,
  0xD8, 0xB3, 0xA7, 0xF8, 0x55, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F,
  0xA0,
  // "I" (U+0049)
  0x0E, 0xC8, 0x41, 0x48, 0xFA, 0x52, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81,
  0x3F, 0x63, 0x81, 0x3F, 0x62, 0x85, 0x48, 0xFA, 0x50, 0xEC, 0x01,
  // "J" (U+004A)
  0x30, 0xC0, 0xD3, 0x0C, 0x0D, 0x30, 0xC0, 0xD3, 0x0C, 0x0D, 0x30, 0xC0, 0xD3, 0x0C, 0x0D, 0x38,
  0x91, 0xEC, 0xB9, 0xBF, 0x8D, 0xFE, 0x91,
  // "K" (U+004B)
  0x8B, 0x07, 0xF3, 0x06, 0xF7, 0x7F, 0x31, 0xEC, 0x07, 0xF3, 0xAF, 0x20, 0x7F, 0x8F, 0x72, 0x07,
  0xB0, 0x52, 0x83, 0x7F, 0xBE, 0xD2, 0x8A, 0x37, 0xF3, 0x7F, 0x60, 0x7F, 0x30, 0xED, 0x07, 0xF3,
  0x06, 0xF7,
  // "L" (U+004C)
  0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E,
  0x0C, 0x48, 0x5E, 0xE9, 0x99, 0x3E, 0xC0, 0x50,
  // "M" (U+004D)
  0x86, 0x8F, 0xD0, 0x9F, 0xA8, 0xA1, 0x8C, 0x5C, 0xFA, 0x8D, 0xF2, 0xED, 0xA8, 0xDD, 0x6F, 0xBA,
  0x8E, 0xAB, 0xDB, 0xA8, 0xF7, 0xFB, 0xCA, 0x8F, 0x5F, 0x8D, 0xA8, 0x93, 0x81, 0xDA, 0x89, 0x30,
  0xD0, 0xA0,
  // "N" (U+004E)
  0x07, 0xA8, 0x31, 0x0D, 0xA7, 0xA8, 0xD1, 0x50, 0xDA, 0x7F, 0xBA, 0x0D, 0xA7, 0xF7, 0xE0, 0xDA,
  0x7F, 0x3F, 0x4D, 0xA7, 0xF1, 0xC9, 0xDA, 0x7F, 0x17, 0xED, 0xA7, 0xF1, 0x3A, 0x86, 0xA7, 0xF1,
  0x0D, 0xFA,
  // "O" (U+004F)
  0x18, 0x33, 0xCF, 0xD5, 0x28, 0x96, 0xEE, 0x8D, 0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82,
  0xB9, 0xF2, 0x28, 0x3E, 0xC8, 0xF3, 0x29, 0x8A, 0x3B, 0x5F, 0x60, 0x3F, 0x80, 0xEE, 0x8D, 0xF2,
  0x03, 0xCF, 0xD5, 0x10,
  // "P" (U+0050)
  0xB8, 0x91, 0xE9, 0x0F, 0xC7, 0xAF, 0x7F, 0x92, 0x98, 0x5A, 0xFA, 0x27, 0xF8, 0xC8, 0x4D, 0x1F,
  0xB5, 0x32, 0x90, 0x94, 0x90, 0x94, 0x90, 0x94,
  // "Q" (U+0051)
  0x18, 0x33, 0xCF, 0xD5, 0x28, 0x96, 0xEE, 0x8D, 0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82,
  0xB9, 0xF2, 0x28, 0x3E, 0xC8, 0xF3, 0x29, 0x8A, 0x0C, 0x5F, 0x60, 0x3F, 0x90, 0xEE, 0x8D, 0xF3,
  0x03, 0xCA, 0x08, 0x50, 0xE0, 0xB5, 0x81, 0x7F, 0x50,
  // "R" (U+0052)
  0xA8, 0xA4, 0xEC, 0x40, 0xFD, 0x7D, 0xF2, 0xFA, 0x06, 0xF5, 0xFB, 0x2B, 0xF3, 0xC8, 0xB0, 0x70,
  0xFC, 0x9F, 0x30, 0xFA, 0x1E, 0xB0, 0xFA, 0x08, 0xF3, 0xFA, 0x01, 0xFB,
  // "S" (U+0053)
  0x18, 0x92, 0x2B, 0xEE, 0xB2, 0x0C, 0xF8, 0x8C, 0x20, 0xE0, 0xD5, 0x82, 0xAF, 0x91, 0x48, 0x2A,
  0xFE, 0x64, 0x82, 0x4D, 0xF5, 0x48, 0x96, 0x4F, 0x82, 0xD9, 0x8C, 0xF4, 0x1B, 0xEF, 0xD6, 0x10,
  // "T" (U+0054)
  0x09, 0xD8, 0x6D, 0x47, 0x9F, 0xB7, 0x62, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74,
  0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x72,
  // "U" (U+0055)
  0x8F, 0x47, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7,
  0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6, 0x03, 0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED,
  0x61,
  // "V" (U+0056)
  0x0B, 0x93, 0x83, 0xCE, 0x7F, 0x32, 0x98, 0xA3, 0xA2, 0xF7, 0x04, 0xF5, 0x0D, 0xB0, 0x7F, 0x10,
  0x9E, 0x0B, 0xC2, 0x83, 0x5F, 0x3E, 0x82, 0x83, 0x1F, 0x8F, 0x43, 0x81, 0xCD, 0xE4, 0x81, 0x8F,
  0xB2,
  // "W" (U+0057)
  0x0D, 0x0A, 0x38, 0x27, 0xFC, 0xB3, 0x8C, 0x48, 0xFA, 0xD4, 0xF7, 0x9E, 0x9E, 0x6F, 0xAA, 0xD8,
  0xE9, 0xCC, 0xBC, 0x7F, 0xB8, 0xEB, 0xB6, 0xFD, 0x4F, 0xCA, 0x5A, 0x89, 0x11, 0xDE, 0x94, 0xFE,
  0x0B, 0xF8,
  // "X" (U+0058)
  0x89, 0x35, 0xF6, 0x04, 0xF8, 0x0B, 0xD0, 0xBE, 0x28, 0x33, 0xFA, 0xF6, 0x38, 0x1A, 0xFD, 0x48,
  0x15, 0xF8, 0x48, 0x2C, 0xFE, 0x12, 0x83, 0x5F, 0x6F, 0x82, 0x89, 0x3D, 0xC0, 0x9F, 0x27, 0xF4,
  0x02, 0xFA,
  // "Y" (U+0059)
  0x8A, 0x28, 0xF4, 0x01, 0xFB, 0x1F, 0xA0, 0x7F, 0x40, 0x9F, 0x1D, 0xC2, 0x83, 0x2F, 0xBF, 0x53,
  0x81, 0xBF, 0xD4, 0x81, 0x5F, 0x84, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x72,
  // "Z" (U+005A)
  0x0B, 0xC8, 0x55, 0x57, 0x7D, 0xF2, 0x28, 0x12, 0xF9, 0x38, 0x1A, 0xE1, 0x28, 0x13, 0xF8, 0x30,
  0xC0, 0xE3, 0x81, 0x4F, 0x63, 0x84, 0xDF, 0x77, 0x72, 0xD0, 0x50,
  // "[" (U+005B)
  0x03, 0xA8, 0xC4, 0x93, 0xF9, 0x43, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x03,
  0xF3, 0x03, 0xF3, 0x03, 0xF5, 0x13, 0xA8, 0x39, 0x15, 0x53,
  // "\" (U+005C)
  0x0C, 0x0A, 0x38, 0x17, 0xF1, 0x28, 0x11, 0xF6, 0x30, 0xB0, 0xC3, 0x81, 0x5F, 0x23, 0x0E, 0x07,
  0x30, 0x90, 0xD3, 0x81, 0x4F, 0x33, 0x0D, 0x09,
  // "]" (U+005D)
  0x83, 0x35, 0x51, 0x9A, 0x8C, 0x43, 0x15, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x03, 0xF3,
  0x03, 0xF3, 0x03, 0xF3, 0x03, 0xF3, 0x49, 0xF3, 0x9A, 0x03,
  // "^" (U+005E)
  0x30, 0x75, 0x81, 0x5F, 0x64, 0x0F, 0xD3, 0x83, 0x5F, 0x2E, 0x62, 0x87, 0xC9, 0x07, 0xE0, 0x4F,
  0x22, 0x0E, 0x07,
  // "_" (U+005F)
  0x80, 0x32, 0x1F, 0x03, 0x80, 0x35, 0x01,
  // "`" (U+0060)
  0x81, 0x1D, 0xC2, 0x81, 0x2D, 0x70,
  // "a" (U+0061)
  0x18, 0x38, 0xDF, 0xD6, 0x28, 0x48, 0x97, 0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64,
  0xFA, 0x57, 0xF6, 0x4F, 0xB8, 0xCF, 0x60, 0xAE, 0xC5, 0xF6,
  // "b" (U+0062)
  0x81, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x8D, 0x65, 0xF7, 0xCE, 0x90, 0x5F, 0xE8,
  0xCF, 0x55, 0xF7, 0x03, 0xF8, 0x5F, 0x50, 0x1F, 0xA5, 0xF7, 0x03, 0xF9, 0x5F, 0xE8, 0xCF, 0x55,
  0xF4, 0xCE, 0x81,
  // "c" (U+0063)
  0x18, 0x92, 0x19, 0xDE, 0xC1, 0x0A, 0xFA, 0x79, 0x29, 0x0C, 0x48, 0x11, 0xF9, 0x59, 0x0C, 0x58,
  0x3B, 0xFA, 0x7C, 0x28, 0x31, 0xAE, 0xEB, 0x10,
  // "d" (U+0064)
  0x48, 0x12, 0xF8, 0x48, 0x12, 0xF8, 0x48, 0xB1, 0x2F, 0x80, 0x6E, 0xD7, 0xF8, 0x2F, 0xE8, 0xCF,
  0x86, 0xF6, 0x03, 0xF8, 0x7F, 0x42, 0x98, 0xA4, 0x85, 0xF5, 0x02, 0xF8, 0x2F, 0xD8, 0xCF, 0x80,
  0x7E, 0xD5, 0xE8,
  // "e" (U+0065)
  0x18, 0x32, 0xBE, 0xD5, 0x28, 0x94, 0xDE, 0x8B, 0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA4, 0x93,
  0xF9, 0x55, 0x53, 0x0C, 0xE9, 0x79, 0x40, 0x1A, 0xDF, 0xC3,
  // "f" (U+0066)
  0x38, 0x28, 0xEE, 0xA2, 0x83, 0x4F, 0xC7, 0x62, 0x81, 0x6F, 0x52, 0x01, 0x0B, 0xC8, 0x66, 0x17,
  0xAF, 0x97, 0x22, 0x81, 0x6F, 0x44, 0x81, 0x6F, 0x44, 0x81, 0x6F, 0x44, 0x81, 0x6F, 0x44, 0x81,
  0x6F, 0x42,
  // "g" (U+0067)
  0x18, 0xD6, 0x6D, 0xD5, 0xE8, 0x2F, 0xE8, 0xCF, 0x86, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0x86,
  0xF6, 0x03, 0xF8, 0x2F, 0xE8, 0xCF, 0x80, 0x6D, 0xD8, 0xF8, 0x48, 0x96, 0x4F, 0x71, 0xD8, 0x7D,
  0xF2, 0x0C, 0xEE, 0xC4, 0x10,
  // "h" (U+0068)
  0x81, 0x5F, 0x64, 0x81, 0x5F, 0x64, 0x81, 0x5F, 0x64, 0x8D, 0x75, 0xF8, 0xCE, 0xA0, 0x5F, 0xE8,
  0xCF, 0x65, 0xF8, 0x03, 0xF8, 0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x95,
  0xF6, 0x02, 0xF9,
  // "i" (U+0069)
  0x28, 0x11, 0xEA, 0x48, 0x12, 0xFB, 0x50, 0x14, 0x0E, 0xA0, 0x93, 0x82, 0x58, 0xF9, 0x48, 0x11,
  0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38, 0x54, 0x7F, 0xC5, 0x14, 0xD0, 0x90,
  // "j" (U+006A)
  0x38, 0x1A, 0xE1, 0x38, 0x1C, 0xF1, 0x70, 0x7B, 0x85, 0x20, 0x27, 0xCF, 0x23, 0x81, 0x9F, 0x23,
  0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x89, 0x4A, 0xF1, 0x69,
  0xAF, 0xD0, 0x6E, 0xFC, 0x31,
  // "k" (U+006B)
  0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x8A, 0x14, 0xF7, 0x08, 0xF6, 0x4F, 0x75,
  0xF9, 0x04, 0xF8, 0xEC, 0x20, 0x4B, 0x0C, 0x28, 0xA3, 0x4F, 0xC7, 0xF7, 0x04, 0xF7, 0x0B, 0xE1,
  0x4F, 0x70, 0x2F, 0xA0,
  // "l" (U+006C)
  0x10, 0xDA, 0x09, 0x38, 0x25, 0x9F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94,
  0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x48, 0xFC, 0x51, 0x4D, 0x09,
  // "m" (U+006D)
  0x8D, 0x79, 0xAC, 0xD5, 0xE6, 0x9F, 0xAF, 0xBD, 0xB9, 0xD2, 0xF5, 0xAC, 0x9D, 0x2F, 0x5A, 0xD9,
  0xD2, 0xF5, 0xAD, 0x9D, 0x2F, 0x5A, 0xD9, 0xD2, 0xF5, 0xAD,
  // "n" (U+006E)
  0x86, 0x5F, 0x5C, 0xEA, 0x05, 0xA8, 0xC5, 0x8C, 0xF6, 0x5F, 0x90, 0x3F, 0x85, 0xF6, 0x02, 0xF9,
  0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x90,
  // "o" (U+006F)
  0x18, 0xD5, 0x3C, 0xED, 0x50, 0x1E, 0xE8, 0xCF, 0x36, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0xA6,
  0xF6, 0x03, 0xF9, 0x1E, 0xE8, 0xCF, 0x30, 0x3C, 0xFD, 0x51,
  // "p" (U+0070)
  0x8E, 0x25, 0xF5, 0xCE, 0x90, 0x5F, 0xE8, 0xCF, 0x55, 0xF7, 0x03, 0xF8, 0x5F, 0x50, 0x1F, 0xA5,
  0xF7, 0x03, 0xF9, 0x5F, 0xE8, 0xCF, 0x45, 0xF8, 0xCE, 0x80, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x81,
  0x5F, 0x54,
  // "q" (U+0071)
  0x18, 0xD6, 0x6E, 0xD6, 0xE8, 0x2F, 0xE8, 0xDF, 0x85, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0x85,
  0xF6, 0x03, 0xF8, 0x2F, 0xE8, 0xCF, 0x80, 0x7E, 0xE7, 0xF8, 0x48, 0x12, 0xF8, 0x48, 0x12, 0xF8,
  0x48, 0x12, 0xF8,
  // "r" (U+0072)
  0x02, 0xA8, 0x91, 0x98, 0xED, 0x04, 0xDF, 0xD8, 0x62, 0x81, 0xCF, 0x24, 0x0C, 0x0E, 0x50, 0xC0,
  0xE3, 0x86, 0x16, 0xEF, 0x62, 0x08, 0xC0, 0xA1,
  // "s" (U+0073)
  0x89, 0x63, 0xCE, 0xEA, 0x1D, 0xE7, 0x9B, 0x0D, 0xE6, 0x12, 0x83, 0x3C, 0xFE, 0x73, 0x89, 0x54,
  0xDF, 0x2D, 0x97, 0xDF, 0x1C, 0xEF, 0xD6, 0x10,
  // "t" (U+0074)
  0x20, 0x30, 0x65, 0x09, 0x0D, 0x30, 0x30, 0xCC, 0x86, 0x52, 0x7E, 0xE7, 0x72, 0x20, 0x0D, 0x50,
  0x0D, 0x50, 0xD0, 0xE5, 0x83, 0xAF, 0x98, 0x32, 0x83, 0x2B, 0xFE, 0x40,
  // "u" (U+0075)
  0x8D, 0x76, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF6, 0x05, 0xF8, 0x3F, 0xD8, 0xEF, 0x80, 0x8E, 0xD5, 0xE8,
  // "v" (U+0076)
  0x81, 0x9F, 0x32, 0x98, 0xA3, 0xC3, 0xF8, 0x04, 0xF6, 0x0D, 0xD0, 0x9F, 0x10, 0x8F, 0x2D, 0xB2,
  0x83, 0x3F, 0x9F, 0x53, 0x82, 0xDE, 0xF1, 0x38, 0x17, 0xFA, 0x20,
  // "w" (U+0077)
  0x0E, 0x0A, 0x38, 0xD2, 0x6F, 0x1C, 0xB3, 0xF7, 0x7F, 0x09, 0xC6, 0xF9, 0x9D, 0x07, 0xE9, 0xCC,
  0xAB, 0x05, 0xFB, 0x7F, 0xB9, 0x03, 0xFE, 0x3F, 0xE6, 0x01, 0xA1, 0x81, 0xCF, 0x41,
  // "x" (U+0078)
  0x89, 0x75, 0xFA, 0x06, 0xF9, 0x0A, 0xF4, 0xEE, 0x10, 0x1E, 0xA0, 0x43, 0x81, 0x9F, 0xD3, 0x83,
  0x2F, 0xEF, 0x52, 0x89, 0x3C, 0xF3, 0xDE, 0x16, 0xF9, 0x06, 0xF9,
  // "y" (U+0079)
  0x8B, 0x19, 0xF4, 0x01, 0xFC, 0x3F, 0x90, 0x5F, 0x60, 0xCE, 0x09, 0xF1, 0x07, 0xF3, 0xDB, 0x28,
  0x31, 0xFA, 0xF6, 0x30, 0xBA, 0x01, 0x38, 0x15, 0xFB, 0x48, 0x16, 0xF5, 0x28, 0x22, 0x9E, 0xD3,
  0x82, 0x4F, 0xC2, 0x30,
  // "z" (U+007A)
  0x1D, 0x86, 0x40, 0x77, 0x8F, 0xE2, 0x38, 0x1A, 0xF5, 0x38, 0x16, 0xF8, 0x38, 0x13, 0xFC, 0x48,
  0x5D, 0xF8, 0x77, 0x33, 0xD0, 0x60,
  // "{" (U+007B)
  0x28, 0x16, 0xD8, 0x28, 0x1E, 0xD4, 0x29, 0x08, 0x39, 0x08, 0x28, 0x56, 0xF6, 0x05, 0xFB, 0x28,
  0x21, 0x9F, 0x53, 0x90, 0x73, 0x90, 0x83, 0x90, 0xB0, 0x12, 0x81, 0xBF, 0x83, 0x03, 0x02,
  // "|" (U+007C)
  0x8C, 0x51, 0xF4, 0x1F, 0x41, 0xF4, 0x1F, 0x41, 0xF4, 0x1F, 0x41, 0xF4, 0x1F, 0x41, 0xF4, 0x1F,
  0x41, 0xF4, 0x1F, 0x41, 0xF4,
  // "}" (U+007D)
  0x02, 0x03, 0x38, 0x18, 0xFB, 0x20, 0x10, 0xB9, 0x30, 0x89, 0x30, 0x79, 0x38, 0x25, 0xF9, 0x12,
  0x85, 0xBF, 0x50, 0x6F, 0x62, 0x08, 0x93, 0x08, 0x92, 0x81, 0x4D, 0xE2, 0x81, 0x8E, 0x62,
  // "~" (U+007E)
  0x20, 0x12, 0x01, 0x28, 0x92, 0xAE, 0xC4, 0xB4, 0x1C, 0x0A, 0xFE, 0x20, 0x32, 0x03, 0x02, 0x10,
  // "¡" (U+00A1)
  0x8B, 0x17, 0xE4, 0x8F, 0x50, 0x10, 0x6F, 0x26, 0xF3, 0x7F, 0x48, 0xF4, 0x8F, 0x59, 0xF5,
  // "¢" (U+00A2)
  0x30, 0x60, 0x84, 0x89, 0x19, 0xEF, 0xD2, 0x0A, 0xE5, 0x36, 0x29, 0x09, 0x48, 0x11, 0xF8, 0x59,
  0x82, 0xD1, 0x01, 0x28, 0x48, 0xFE, 0xDF, 0x22, 0x82, 0x5C, 0xD8, 0x40, 0x60, 0x82,
  // "£" (U+00A3)
  0x18, 0x94, 0x3C, 0xEC, 0x20, 0xEE, 0x8A, 0x01, 0xF9, 0x38, 0x33, 0xF9, 0x21, 0x1C, 0x89, 0x18,
  0x06, 0xFA, 0x52, 0x02, 0xF7, 0x38, 0x4C, 0xF7, 0x77, 0x3D, 0x07,
  // "¤" (U+00A4)
  0x10, 0x23, 0x89, 0x52, 0x01, 0xFB, 0xEB, 0xF3, 0x09, 0xE8, 0xCC, 0x28, 0x2C, 0x60, 0x39, 0x28,
  0x6A, 0xB2, 0x9D, 0x01, 0xDB, 0x86, 0xE2, 0x07, 0x14, 0x27, 0x10,
  // "¥" (U+00A5)
  0x8A, 0x27, 0xF4, 0x01, 0xFA, 0x1E, 0xA0, 0x7F, 0x30, 0x9F, 0x1D, 0xB2, 0x83, 0x2F, 0xBF, 0x42,
  0x83, 0x2B, 0xFD, 0x22, 0x0E, 0xC8, 0x12, 0x0E, 0xC8, 0x52, 0x04, 0x7F, 0x95, 0x38, 0x13, 0xF6,
  0x20,
  // "¦" (U+00A6)
  0x89, 0x51, 0xF4, 0x1F, 0x41, 0xF4, 0x1F, 0x41, 0xF4, 0x72, 0x89, 0x51, 0xF4, 0x1F, 0x41, 0xF4,
  0x1F, 0x41, 0xF4,
  // "§" (U+00A7)
  0x89, 0x31, 0xBE, 0xD7, 0x9F, 0x89, 0x88, 0xF4, 0x20, 0x1A, 0x89, 0x7C, 0x39, 0xC2, 0xCD, 0x9E,
  0x59, 0xC0, 0x8E, 0xF5, 0x28, 0x93, 0x1C, 0xCA, 0x97, 0xEC, 0x7D, 0xFC, 0x20,
  // "¨" (U+00A8)
  0x89, 0x07, 0xE0, 0xBC, 0x13, 0x02, 0x20,
  // "©" (U+00A9)
  0x30, 0x14, 0x8D, 0x15, 0xEF, 0xE7, 0x02, 0xF9, 0x67, 0xF5, 0x88, 0x9F, 0xB4, 0xBA, 0x4E, 0x64,
  0x0D, 0x87, 0xE3, 0x23, 0xC3, 0xEC, 0xFD, 0xD7, 0x08, 0xB0, 0xA3, 0x81, 0x24, 0x22,
  // "ª" (U+00AA)
  0x18, 0xA6, 0x9E, 0xC1, 0x02, 0x0C, 0x60, 0xAD, 0xE7, 0x3E, 0x1C, 0x70, 0xCC, 0x96,
  // "«" (U+00AB)
  0x28, 0xA0, 0x97, 0x2C, 0x20, 0x6F, 0x5C, 0xD0, 0x2F, 0xA8, 0xF3, 0x28, 0x3B, 0xE4, 0xF9, 0x28,
  0x41, 0xDA, 0x6F, 0x32, 0x82, 0x21, 0x03, 0x10,
  // "¬" (U+00AC)
  0x18, 0x01, 0x21, 0x02, 0xD8, 0x63, 0x05, 0x55, 0x5F, 0x35, 0x90, 0x35, 0x0C, 0x02,
  // "®" (U+00AE)
  0x30, 0x14, 0x8D, 0x15, 0xEF, 0xE7, 0x02, 0xFA, 0x78, 0xF5, 0x88, 0xAF, 0xC4, 0xBA, 0x3A, 0xFB,
  0x0D, 0x86, 0xA9, 0xA3, 0xB3, 0xEA, 0x3A, 0xE7, 0x08, 0xB0, 0xA3, 0x81, 0x24, 0x22,
  // "¯" (U+00AF)
  0x10, 0xF2, 0x10, 0x3B, 0x84, 0x61, 0x55, 0x52,
  // "°" (U+00B0)
  0x20, 0x13, 0x8A, 0x19, 0xFC, 0x02, 0xE6, 0xD6, 0x3E, 0x3B, 0x60, 0xCF, 0xE1, 0x20, 0x40, 0x11,
  // "±" (U+00B1)
  0x39, 0x04, 0x59, 0x04, 0x38, 0x52, 0x2F, 0x52, 0x02, 0xD8, 0x65, 0x05, 0x5F, 0x75, 0x13, 0x90,
  0x42, 0x01, 0x80, 0x17, 0x00, 0x2D, 0x05,
  // "²" (U+00B2)
  0x18, 0x1A, 0xEC, 0x28, 0x24, 0x1F, 0x32, 0x07, 0x0C, 0x28, 0x38, 0xC1, 0x02, 0xB0, 0x80,
  // "³" (U+00B3)
  0x18, 0x1B, 0xEB, 0x28, 0x62, 0x2F, 0x20, 0x5F, 0xB2, 0x87, 0x21, 0xE5, 0x1D, 0xFC, 0x10,
  // "´" (U+00B4)
  0x18, 0x46, 0xF6, 0x2E, 0x61,
  // "µ" (U+00B5)
  0x8D, 0x16, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF6, 0x05, 0xF8, 0x6F, 0xD7, 0xDF, 0x86, 0xA8, 0x5D, 0x5E, 0x86, 0xF5, 0x48, 0x16, 0xF5, 0x48,
  0x16, 0xF5, 0x40,
  // "¶" (U+00B6)
  0x10, 0x60, 0xDB, 0x09, 0x02, 0xB8, 0x2E, 0x99, 0x6B, 0x82, 0xC5, 0x97, 0xB8, 0x2C, 0x59, 0x5B,
  0x83, 0xC5, 0x91, 0xEA, 0x89, 0x0C, 0x59, 0x01, 0x79, 0xC5, 0x93, 0x82, 0x1C, 0x59, 0x38, 0x21,
  0xC5, 0x93, 0x82, 0x1C, 0x59, 0x38, 0x21, 0xC5, 0x94, 0x81, 0x52, 0x40,
  // "·" (U+00B7)
  0x18, 0x61, 0x05, 0xF8, 0x4E, 0x70,
  // "¸" (U+00B8)
  0x87, 0x1E, 0x30, 0x8D, 0x8E, 0x70,
  // "¹" (U+00B9)
  0x18, 0x65, 0xE6, 0x01, 0xBC, 0x63, 0x0B, 0x06, 0x30, 0xB0, 0x62, 0x82, 0xBE, 0xD6,
  // "º" (U+00BA)
  0x18, 0xA0, 0x9E, 0xB0, 0x2E, 0x0C, 0x52, 0xE0, 0xC5, 0x08, 0xDA, 0x10,
  // "»" (U+00BB)
  0x18, 0x23, 0x01, 0x22, 0x84, 0x3F, 0x6A, 0xD1, 0x28, 0x39, 0xF4, 0xEB, 0x28, 0xA0, 0x3F, 0x8A,
  0xF2, 0x0D, 0xC5, 0xF6, 0x03, 0xC2, 0x79, 0x20,
  // "¼" (U+00BC)
  0x81, 0x6E, 0x44, 0x81, 0x4B, 0x42, 0x89, 0x5B, 0x60, 0xA4, 0x08, 0xC0, 0x7E, 0xD6, 0xE1, 0x38,
  0x31, 0xE5, 0x62, 0x28, 0xA1, 0xB9, 0x5F, 0x40, 0x7C, 0x1B, 0xA4, 0x2C, 0x25, 0xCD, 0xB5, 0x08,
  0x04,
  // "½" (U+00BD)
  0x81, 0x6E, 0x44, 0x81, 0x4B, 0x42, 0x89, 0x5B, 0x60, 0xA4, 0x08, 0xC0, 0x7E, 0xD6, 0xE1, 0x38,
  0x21, 0xE5, 0x13, 0x8A, 0x1B, 0x98, 0xFA, 0x07, 0xC0, 0x58, 0xA2, 0xC2, 0x04, 0xB2, 0x40, 0xDA,
  0x48, 0x14, 0x55,
  // "¾" (U+00BE)
  0x81, 0x5F, 0xD4, 0x8B, 0x02, 0x8E, 0x10, 0x44, 0x0E, 0xB0, 0x2E, 0x32, 0x7E, 0x3C, 0x70, 0x8F,
  0xE9, 0xC3, 0x84, 0x45, 0xE2, 0x21, 0x28, 0xA1, 0xC7, 0x3F, 0x40, 0x8C, 0x1B, 0xA4, 0x2C, 0x25,
  0xCD, 0xB5, 0x08, 0x04,
  // "¿" (U+00BF)
  0x28, 0x12, 0xE9, 0x38, 0x13, 0xFA, 0x40, 0x14, 0x81, 0x1F, 0x73, 0x81, 0xBF, 0x32, 0x81, 0xCE,
  0x42, 0x81, 0x2F, 0x83, 0x89, 0x21, 0xFD, 0x8A, 0xA0, 0x5D, 0xED, 0x70,
  // "À" (U+00C0)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x74, 0x81, 0xAF, 0xC4, 0x82, 0xEE, 0xF1, 0x28, 0x32, 0xF8,
  0xF5, 0x28, 0x36, 0xF2, 0xE9, 0x28, 0x3A, 0xE0, 0xBD, 0x28, 0x5E, 0xD8, 0xCF, 0x23, 0xD8, 0x26,
  0x7F, 0x32, 0x98, 0x1A, 0xBE, 0x30, 0xC0, 0xE0,
  // "Á" (U+00C1)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x73, 0x81, 0xAF, 0xC4, 0x82, 0xEE, 0xF1, 0x28, 0x32, 0xF8,
  0xF5, 0x28, 0x36, 0xF2, 0xE9, 0x28, 0x3A, 0xE0, 0xBD, 0x28, 0x5E, 0xD8, 0xCF, 0x23, 0xD8, 0x26,
  0x7F, 0x32, 0x98, 0x1A, 0xBE, 0x30, 0xC0, 0xE0,
  // "Â" (U+00C2)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x73, 0x81, 0xAF, 0xC4, 0x82, 0xEE, 0xF1, 0x28, 0x32,
  0xF8, 0xF5, 0x28, 0x36, 0xF2, 0xE9, 0x28, 0x3A, 0xE0, 0xBD, 0x28, 0x5E, 0xD8, 0xCF, 0x23, 0xD8,
  0x26, 0x7F, 0x32, 0x98, 0x1A, 0xBE, 0x30, 0xC0, 0xE0,
  // "Ã" (U+00C3)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x48, 0x1A, 0xFC, 0x48, 0x2E,
  0xEF, 0x12, 0x83, 0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83, 0xAE, 0x0B, 0xD2, 0x85, 0xED,
  0x8C, 0xF2, 0x3D, 0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C, 0x0E,
  // "Ä" (U+00C4)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x38, 0x1A, 0xFC, 0x48, 0x2E, 0xEF, 0x12, 0x83,
  0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83, 0xAE, 0x0B, 0xD2, 0x85, 0xED, 0x8C, 0xF2, 0x3D,
  0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C, 0x0E,
  // "Å" (U+00C5)
  0x30, 0x15, 0x81, 0x7F, 0xA4, 0x81, 0xC9, 0xE4, 0x81, 0x9F, 0xC5, 0x04, 0x01, 0x48, 0x1A, 0xFC,
  0x48, 0x2E, 0xEF, 0x12, 0x83, 0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83, 0xAE, 0x0B, 0xD2,
  0x85, 0xED, 0x8C, 0xF2, 0x3D, 0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C, 0x0E,
  // "Æ" (U+00C6)
  0x20, 0xEB, 0x89, 0x4D, 0x02, 0xFB, 0xF8, 0x60, 0x6F, 0x5F, 0x22, 0x89, 0x49, 0xC4, 0xF4, 0x10,
  0xDA, 0x6F, 0xD8, 0x1C, 0x8A, 0x22, 0x04, 0xF6, 0x8F, 0x20, 0x8F, 0x04, 0xF8, 0x6B, 0xC0, 0x4A,
  0x0D,
  // "Ç" (U+00C7)
  0x28, 0x95, 0x6C, 0xFD, 0x60, 0x7F, 0xB7, 0xA4, 0x0F, 0xC4, 0x81, 0x4F, 0x74, 0x81, 0x5F, 0x64,
  0x81, 0x5F, 0x64, 0x81, 0x2F, 0xB5, 0x84, 0xAF, 0xB7, 0xA5, 0x28, 0x39, 0xEF, 0xD3, 0x28, 0x11,
  0xE3, 0x50, 0x80, 0xD4, 0x81, 0x8E, 0x72,
  // "È" (U+00C8)
  0x81, 0x1D, 0xC4, 0x81, 0x2D, 0x77, 0x1D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90, 0xA0, 0xF2,
  0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "É" (U+00C9)
  0x38, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x7D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90, 0xA0, 0xF2,
  0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "Ê" (U+00CA)
  0x18, 0x18, 0xFC, 0x28, 0x34, 0xD3, 0xB8, 0x7D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90, 0xA0,
  0xF2, 0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "Ë" (U+00CB)
  0x89, 0x17, 0xE0, 0xBC, 0x01, 0x30, 0x22, 0x1D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90, 0xA0,
  0xF2, 0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "Ì" (U+00CC)
  0x81, 0x1D, 0xC4, 0x81, 0x2D, 0x77, 0x10, 0xEC, 0x84, 0x14, 0x8F, 0xA5, 0x28, 0x13, 0xF6, 0x38,
  0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x28, 0x54, 0x8F, 0xA5, 0x0E,
  0xC0, 0x10,
  // "Í" (U+00CD)
  0x38, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x70, 0xEC, 0x84, 0x14, 0x8F, 0xA5, 0x28, 0x13, 0xF6, 0x38,
  0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x28, 0x54, 0x8F, 0xA5, 0x0E,
  0xC0, 0x10,
  // "Î" (U+00CE)
  0x18, 0x18, 0xFC, 0x28, 0x34, 0xD3, 0xB8, 0x70, 0xEC, 0x84, 0x14, 0x8F, 0xA5, 0x28, 0x13, 0xF6,
  0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x28, 0x54, 0x8F, 0xA5,
  0x0E, 0xC0, 0x10,
  // "Ï" (U+00CF)
  0x89, 0x37, 0xE0, 0xBC, 0x01, 0x30, 0x22, 0x0E, 0xC8, 0x41, 0x48, 0xFA, 0x52, 0x81, 0x3F, 0x63,
  0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x62, 0x85, 0x48, 0xFA, 0x50,
  0xEC, 0x01,
  // "Ð" (U+00D0)
  0x07, 0xB8, 0xA6, 0xB3, 0x07, 0xF9, 0x8E, 0xE2, 0x7F, 0x30, 0x4F, 0x88, 0xF5, 0x10, 0xFC, 0xB8,
  0xB0, 0x80, 0xEC, 0x9F, 0x72, 0x0F, 0xB7, 0xF3, 0x05, 0xF8, 0x7F, 0x98, 0xEE, 0x17, 0xA8, 0x1E,
  0xB2, 0x10,
  // "Ñ" (U+00D1)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x20, 0x7A, 0x83, 0x10, 0xDA,
  0x7A, 0x8D, 0x15, 0x0D, 0xA7, 0xFB, 0xA0, 0xDA, 0x7F, 0x7E, 0x0D, 0xA7, 0xF3, 0xF4, 0xDA, 0x7F,
  0x1C, 0x9D, 0xA7, 0xF1, 0x7E, 0xDA, 0x7F, 0x13, 0xA8, 0x6A, 0x7F, 0x10, 0xDF, 0xA0,
  // "Ò" (U+00D2)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x73, 0x83, 0x3C, 0xFD, 0x52, 0x89, 0x6E, 0xE8, 0xDF, 0x25,
  0xF6, 0x03, 0xF8, 0x8F, 0x32, 0x98, 0x2B, 0x9F, 0x22, 0x83, 0xEC, 0x8F, 0x32, 0x98, 0xA3, 0xB5,
  0xF6, 0x03, 0xF8, 0x0E, 0xE8, 0xDF, 0x20, 0x3C, 0xFD, 0x51,
  // "Ó" (U+00D3)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x83, 0x3C, 0xFD, 0x52, 0x89, 0x6E, 0xE8, 0xDF, 0x25,
  0xF6, 0x03, 0xF8, 0x8F, 0x32, 0x98, 0x2B, 0x9F, 0x22, 0x83, 0xEC, 0x8F, 0x32, 0x98, 0xA3, 0xB5,
  0xF6, 0x03, 0xF8, 0x0E, 0xE8, 0xDF, 0x20, 0x3C, 0xFD, 0x51,
  // "Ô" (U+00D4)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x83, 0x3C, 0xFD, 0x52, 0x89, 0x6E, 0xE8, 0xDF,
  0x25, 0xF6, 0x03, 0xF8, 0x8F, 0x32, 0x98, 0x2B, 0x9F, 0x22, 0x83, 0xEC, 0x8F, 0x32, 0x98, 0xA3,
  0xB5, 0xF6, 0x03, 0xF8, 0x0E, 0xE8, 0xDF, 0x20, 0x3C, 0xFD, 0x51,
  // "Õ" (U+00D5)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x38, 0x33, 0xCF, 0xD5, 0x28,
  0x96, 0xEE, 0x8D, 0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82, 0xB9, 0xF2, 0x28, 0x3E, 0xC8,
  0xF3, 0x29, 0x8A, 0x3B, 0x5F, 0x60, 0x3F, 0x80, 0xEE, 0x8D, 0xF2, 0x03, 0xCF, 0xD5, 0x10,
  // "Ö" (U+00D6)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x28, 0x33, 0xCF, 0xD5, 0x28, 0x96, 0xEE, 0x8D,
  0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82, 0xB9, 0xF2, 0x28, 0x3E, 0xC8, 0xF3, 0x29, 0x8A,
  0x3B, 0x5F, 0x60, 0x3F, 0x80, 0xEE, 0x8D, 0xF2, 0x03, 0xCF, 0xD5, 0x10,
  // "×" (U+00D7)
  0x8B, 0x07, 0x40, 0x29, 0x9F, 0x6E, 0xB0, 0xAF, 0xC0, 0x2E, 0xEF, 0x4C, 0xB0, 0x9E, 0x13, 0x02,
  // "Ø" (U+00D8)
  0x68, 0x98, 0x01, 0x03, 0xCF, 0xD9, 0xC0, 0xEE, 0x8D, 0xF5, 0x5F, 0x60, 0xBF, 0x98, 0xF3, 0x5D,
  0xFB, 0x9F, 0x3E, 0x4E, 0xC8, 0xFC, 0xA0, 0xFB, 0x6F, 0xE1, 0x3F, 0x82, 0xFE, 0x8D, 0xF2, 0x9C,
  0xCF, 0xD5, 0x01, 0x15,
  // "Ù" (U+00D9)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x72, 0x8F, 0x47, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7,
  0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6, 0x03,
  0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "Ú" (U+00DA)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x8F, 0x47, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7,
  0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6, 0x03,
  0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "Û" (U+00DB)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x8F, 0x47, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6,
  0x03, 0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "Ü" (U+00DC)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x98, 0x21, 0x30, 0x22, 0x07, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6,
  0x03, 0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "Ý" (U+00DD)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x8A, 0x28, 0xF4, 0x01, 0xFB, 0x1F, 0xA0, 0x7F, 0x40,
  0x9F, 0x1D, 0xC2, 0x83, 0x2F, 0xBF, 0x53, 0x81, 0xBF, 0xD4, 0x81, 0x5F, 0x84, 0x81, 0x4F, 0x74,
  0x81, 0x4F, 0x74, 0x81, 0x4F, 0x72,
  // "Þ" (U+00DE)
  0x90, 0x94, 0x90, 0xA0, 0x23, 0xC8, 0x90, 0xB1, 0xFB, 0x59, 0xF8, 0xF9, 0x29, 0x85, 0xAF, 0xA2,
  0x7F, 0x8C, 0x84, 0xD1, 0xFB, 0x53, 0x29, 0x09, 0x40,
  // "ß" (U+00DF)
  0x18, 0xB6, 0x4C, 0xEC, 0x40, 0x1E, 0xD8, 0xDF, 0x14, 0xF6, 0x09, 0xF1, 0x5F, 0x54, 0xF9, 0x05,
  0xF5, 0xCD, 0x28, 0x97, 0x5F, 0x5B, 0xF6, 0x05, 0xF5, 0x1C, 0xF6, 0x5F, 0x52, 0x89, 0x6E, 0xC5,
  0xF6, 0xA8, 0xFB, 0x5F, 0x6D, 0xFC, 0x20,
  // "à" (U+00E0)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x73, 0x83, 0x8D, 0xFD, 0x62, 0x84, 0x89, 0x7C, 0xF3, 0x38,
  0x42, 0x5F, 0x60, 0xAC, 0x8A, 0x46, 0x4F, 0xA5, 0x7F, 0x64, 0xFB, 0x8C, 0xF6, 0x0A, 0xEC, 0x5F,
  0x60,
  // "á" (U+00E1)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x83, 0x8D, 0xFD, 0x62, 0x84, 0x89, 0x7C, 0xF3, 0x38,
  0x42, 0x5F, 0x60, 0xAC, 0x8A, 0x46, 0x4F, 0xA5, 0x7F, 0x64, 0xFB, 0x8C, 0xF6, 0x0A, 0xEC, 0x5F,
  0x60,
  // "â" (U+00E2)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x83, 0x8D, 0xFD, 0x62, 0x84, 0x89, 0x7C, 0xF3,
  0x38, 0x42, 0x5F, 0x60, 0xAC, 0x8A, 0x46, 0x4F, 0xA5, 0x7F, 0x64, 0xFB, 0x8C, 0xF6, 0x0A, 0xEC,
  0x5F, 0x60,
  // "ã" (U+00E3)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x38, 0x38, 0xDF, 0xD6, 0x28,
  0x48, 0x97, 0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64, 0xFA, 0x57, 0xF6, 0x4F, 0xB8,
  0xCF, 0x60, 0xAE, 0xC5, 0xF6,
  // "ä" (U+00E4)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x28, 0x38, 0xDF, 0xD6, 0x28, 0x48, 0x97, 0xCF,
  0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64, 0xFA, 0x57, 0xF6, 0x4F, 0xB8, 0xCF, 0x60, 0xAE,
  0xC5, 0xF6,
  // "å" (U+00E5)
  0x30, 0x15, 0x81, 0x7F, 0xA4, 0x81, 0xC9, 0xE4, 0x81, 0x9F, 0xC5, 0x04, 0x01, 0x38, 0x38, 0xDF,
  0xD6, 0x28, 0x48, 0x97, 0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64, 0xFA, 0x57, 0xF6,
  0x4F, 0xB8, 0xCF, 0x60, 0xAE, 0xC5, 0xF6,
  // "æ" (U+00E6)
  0x89, 0x14, 0xDE, 0x9C, 0xE3, 0x02, 0x9A, 0x90, 0xFC, 0x38, 0x54, 0xF8, 0x7F, 0x06, 0xE8, 0xA6,
  0x1C, 0xD7, 0xF9, 0x55, 0x0C, 0xDA, 0xFD, 0x77, 0x05, 0xEC, 0x3B, 0xE9, 0x10,
  // "ç" (U+00E7)
  0x18, 0x92, 0x19, 0xDE, 0xC1, 0x0A, 0xFA, 0x79, 0x29, 0x0C, 0x48, 0x11, 0xF9, 0x59, 0x0C, 0x58,
  0x3B, 0xFA, 0x7C, 0x28, 0x31, 0xAE, 0xEB, 0x38, 0x11, 0xE3, 0x50, 0x80, 0xD4, 0x81, 0x8E, 0x72,
  // "è" (U+00E8)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x73, 0x83, 0x2B, 0xED, 0x52, 0x89, 0x4D, 0xE8, 0xBF, 0x24,
  0xF8, 0x23, 0xF7, 0x5D, 0x8A, 0x49, 0x3F, 0x95, 0x55, 0x30, 0xCE, 0x97, 0x94, 0x01, 0xAD, 0xFC,
  0x30,
  // "é" (U+00E9)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x83, 0x2B, 0xED, 0x52, 0x89, 0x4D, 0xE8, 0xBF, 0x24,
  0xF8, 0x23, 0xF7, 0x5D, 0x8A, 0x49, 0x3F, 0x95, 0x55, 0x30, 0xCE, 0x97, 0x94, 0x01, 0xAD, 0xFC,
  0x30,
  // "ê" (U+00EA)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x83, 0x2B, 0xED, 0x52, 0x89, 0x4D, 0xE8, 0xBF,
  0x24, 0xF8, 0x23, 0xF7, 0x5D, 0x8A, 0x49, 0x3F, 0x95, 0x55, 0x30, 0xCE, 0x97, 0x94, 0x01, 0xAD,
  0xFC, 0x30,
  // "ë" (U+00EB)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x28, 0x32, 0xBE, 0xD5, 0x28, 0x94, 0xDE, 0x8B,
  0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA4, 0x93, 0xF9, 0x55, 0x53, 0x0C, 0xE9, 0x79, 0x40, 0x1A,
  0xDF, 0xC3,
  // "ì" (U+00EC)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x73, 0x0E, 0xA0, 0x93, 0x82, 0x58, 0xF9, 0x48, 0x11, 0xF9,
  0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38, 0x54, 0x7F, 0xC5, 0x14, 0xD0, 0x90,
  // "í" (U+00ED)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x0E, 0xA0, 0x93, 0x82, 0x58, 0xF9, 0x48, 0x11, 0xF9,
  0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38, 0x54, 0x7F, 0xC5, 0x14, 0xD0, 0x90,
  // "î" (U+00EE)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x0E, 0xA0, 0x93, 0x82, 0x58, 0xF9, 0x48, 0x11,
  0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38, 0x54, 0x7F, 0xC5, 0x14, 0xD0, 0x90,
  // "ï" (U+00EF)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x20, 0xEA, 0x09, 0x38, 0x25, 0x8F, 0x94, 0x81,
  0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x47, 0xFC, 0x51, 0x4D, 0x09,
  // "ð" (U+00F0)
  0x28, 0x25, 0x22, 0x53, 0x82, 0xBF, 0xE7, 0x38, 0x2C, 0xDF, 0x53, 0x85, 0x51, 0xAE, 0x10, 0x8A,
  0x8C, 0x3D, 0xF6, 0x3F, 0xC5, 0xAF, 0x97, 0xF4, 0x01, 0xFA, 0x7F, 0x50, 0x2F, 0x82, 0xFD, 0x7C,
  0xF2, 0x04, 0xCF, 0xC4, 0x10,
  // "ñ" (U+00F1)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x28, 0x65, 0xF5, 0xCE, 0xA0,
  0x5A, 0x8C, 0x58, 0xCF, 0x65, 0xF9, 0x03, 0xF8, 0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F,
  0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9,
  // "ò" (U+00F2)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x73, 0x8D, 0x53, 0xCE, 0xD5, 0x01, 0xEE, 0x8C, 0xF3, 0x6F,
  0x60, 0x3F, 0x87, 0xF4, 0x01, 0xFA, 0x6F, 0x60, 0x3F, 0x91, 0xEE, 0x8C, 0xF3, 0x03, 0xCF, 0xD5,
  0x10,
  // "ó" (U+00F3)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x8D, 0x53, 0xCE, 0xD5, 0x01, 0xEE, 0x8C, 0xF3, 0x6F,
  0x60, 0x3F, 0x87, 0xF4, 0x01, 0xFA, 0x6F, 0x60, 0x3F, 0x91, 0xEE, 0x8C, 0xF3, 0x03, 0xCF, 0xD5,
  0x10,
  // "ô" (U+00F4)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x8D, 0x53, 0xCE, 0xD5, 0x01, 0xEE, 0x8C, 0xF3,
  0x6F, 0x60, 0x3F, 0x87, 0xF4, 0x01, 0xFA, 0x6F, 0x60, 0x3F, 0x91, 0xEE, 0x8C, 0xF3, 0x03, 0xCF,
  0xD5, 0x10,
  // "õ" (U+00F5)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x38, 0xD5, 0x3C, 0xED, 0x50,
  0x1E, 0xE8, 0xCF, 0x36, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0xA6, 0xF6, 0x03, 0xF9, 0x1E, 0xE8,
  0xCF, 0x30, 0x3C, 0xFD, 0x51,
  // "ö" (U+00F6)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0x31, 0x30, 0x22, 0x28, 0xD5, 0x3C, 0xED, 0x50, 0x1E, 0xE8, 0xCF,
  0x36, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0xA6, 0xF6, 0x03, 0xF9, 0x1E, 0xE8, 0xCF, 0x30, 0x3C,
  0xFD, 0x51,
  // "÷" (U+00F7)
  0x28, 0x11, 0xF4, 0x38, 0x52, 0x26, 0x22, 0x02, 0xD0, 0x51, 0x80, 0x15, 0x01, 0x30, 0x15, 0x81,
  0x1F, 0x45, 0x03, 0x30,
  // "ø" (U+00F8)
  0x18, 0xD5, 0x3C, 0xFD, 0xE1, 0x1E, 0xE8, 0xEF, 0x36, 0xF6, 0x5E, 0xF8, 0x7F, 0x5E, 0x5F, 0xA5,
  0xFE, 0x93, 0xF9, 0x1E, 0xF9, 0xCF, 0x30, 0xDD, 0xFD, 0x52, 0x01, 0x50,
  // "ù" (U+00F9)
  0x18, 0x11, 0xDC, 0x58, 0x12, 0xD7, 0x72, 0x8D, 0x76, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF6, 0x05, 0xF8, 0x3F, 0xD8, 0xEF, 0x80, 0x8E, 0xD5,
  0xE8,
  // "ú" (U+00FA)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x8D, 0x76, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF6, 0x05, 0xF8, 0x3F, 0xD8, 0xEF, 0x80, 0x8E, 0xD5,
  0xE8,
  // "û" (U+00FB)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x8D, 0x76, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F,
  0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF6, 0x05, 0xF8, 0x3F, 0xD8, 0xEF, 0x80, 0x8E,
  0xD5, 0xE8,
  // "ü" (U+00FC)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0xE5, 0x13, 0x02, 0x20, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8,
  0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x60, 0x5F, 0x83, 0xFD, 0x8E, 0xF8, 0x08, 0xED,
  0x5E, 0x80,
  // "ý" (U+00FD)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x8B, 0x19, 0xF4, 0x01, 0xFC, 0x3F, 0x90, 0x5F, 0x60,
  0xCE, 0x09, 0xF1, 0x07, 0xF3, 0xDB, 0x28, 0x31, 0xFA, 0xF6, 0x30, 0xBA, 0x01, 0x38, 0x15, 0xFB,
  0x48, 0x16, 0xF5, 0x28, 0x22, 0x9E, 0xD3, 0x82, 0x4F, 0xC2, 0x30,
  // "þ" (U+00FE)
  0x81, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x8E, 0x25, 0xF8, 0xCE, 0x90, 0x5F, 0xE8,
  0xCF, 0x55, 0xF7, 0x03, 0xF8, 0x5F, 0x50, 0x1F, 0xA5, 0xF7, 0x03, 0xF9, 0x5F, 0xE8, 0xCF, 0x45,
  0xF8, 0xCE, 0x80, 0x5F, 0x54, 0x81, 0x5F, 0x54, 0x81, 0x5F, 0x54,
  // "ÿ" (U+00FF)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0xB7, 0x13, 0x02, 0x20, 0x9F, 0x40, 0x1F, 0xC3, 0xF9, 0x05, 0xF6,
  0x0C, 0xE0, 0x9F, 0x10, 0x7F, 0x3D, 0xB2, 0x83, 0x1F, 0xAF, 0x63, 0x0B, 0xA0, 0x13, 0x81, 0x5F,
  0xB4, 0x81, 0x6F, 0x52, 0x82, 0x29, 0xED, 0x38, 0x24, 0xFC, 0x23,
  // "Ā" (U+0100)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x38, 0x1A, 0xFC, 0x48, 0x2E, 0xEF, 0x12,
  0x83, 0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83, 0xAE, 0x0B, 0xD2, 0x85, 0xED, 0x8C, 0xF2,
  0x3D, 0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C, 0x0E,
  // "ā" (U+0101)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x28, 0x38, 0xDF, 0xD6, 0x28, 0x48, 0x97,
  0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64, 0xFA, 0x57, 0xF6, 0x4F, 0xB8, 0xCF, 0x60,
  0xAE, 0xC5, 0xF6,
  // "Ă" (U+0102)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x48, 0x1A, 0xFC, 0x48, 0x2E,
  0xEF, 0x12, 0x83, 0x2F, 0x8F, 0x52, 0x83, 0x6F, 0x2E, 0x92, 0x83, 0xAE, 0x0B, 0xD2, 0x85, 0xED,
  0x8C, 0xF2, 0x3D, 0x82, 0x67, 0xF3, 0x29, 0x81, 0xAB, 0xE3, 0x0C, 0x0E,
  // "ă" (U+0103)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0x38, 0xDF, 0xD6, 0x28,
  0x48, 0x97, 0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64, 0xFA, 0x57, 0xF6, 0x4F, 0xB8,
  0xCF, 0x60, 0xAE, 0xC5, 0xF6,
  // "Ą" (U+0104)
  0x28, 0x1A, 0xFC, 0x58, 0x2E, 0xEF, 0x13, 0x83, 0x2F, 0x8F, 0x53, 0x83, 0x6F, 0x2E, 0x93, 0x83,
  0xAE, 0x0B, 0xD3, 0x86, 0xED, 0x8C, 0xF2, 0x03, 0xD8, 0x36, 0x07, 0xF3, 0x29, 0x82, 0xA0, 0xBE,
  0x30, 0xC9, 0x70, 0xC0, 0x25, 0x81, 0x6D, 0x25, 0x81, 0x4F, 0xC6, 0x00, 0x30,
  // "ą" (U+0105)
  0x18, 0x38, 0xDF, 0xD6, 0x28, 0x48, 0x97, 0xCF, 0x33, 0x84, 0x25, 0xF6, 0x0A, 0xC8, 0xA4, 0x64,
  0xFA, 0x57, 0xF6, 0x4F, 0xB8, 0xCF, 0x60, 0xAE, 0xC5, 0xF6, 0x50, 0xC0, 0x24, 0x81, 0x6D, 0x24,
  0x81, 0x4F, 0xC5, 0x00, 0x30,
  // "Ć" (U+0106)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x73, 0x89, 0x56, 0xCF, 0xD6, 0x07, 0xFB, 0x7A, 0x40, 0xFC,
  0x48, 0x14, 0xF7, 0x48, 0x15, 0xF6, 0x48, 0x15, 0xF6, 0x48, 0x12, 0xFB, 0x58, 0x4A, 0xFB, 0x7A,
  0x52, 0x83, 0x9E, 0xFD, 0x30,
  // "ć" (U+0107)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x89, 0x21, 0x9D, 0xEC, 0x10, 0xAF, 0xA7, 0x92, 0x90,
  0xC4, 0x81, 0x1F, 0x95, 0x90, 0xC5, 0x83, 0xBF, 0xA7, 0xC2, 0x83, 0x1A, 0xEE, 0xB1,
  // "Ĉ" (U+0108)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x73, 0x89, 0x56, 0xCF, 0xD6, 0x07, 0xFB, 0x7A, 0x40,
  0xFC, 0x48, 0x14, 0xF7, 0x48, 0x15, 0xF6, 0x48, 0x15, 0xF6, 0x48, 0x12, 0xFB, 0x58, 0x4A, 0xFB,
  0x7A, 0x52, 0x83, 0x9E, 0xFD, 0x30,
  // "ĉ" (U+0109)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x89, 0x21, 0x9D, 0xEC, 0x10, 0xAF, 0xA7, 0x92,
  0x90, 0xC4, 0x81, 0x1F, 0x95, 0x90, 0xC5, 0x83, 0xBF, 0xA7, 0xC2, 0x83, 0x1A, 0xEE, 0xB1,
  // "Ċ" (U+010A)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x48, 0x95, 0x6C, 0xFD, 0x60, 0x7F, 0xB7, 0xA4,
  0x0F, 0xC4, 0x81, 0x4F, 0x74, 0x81, 0x5F, 0x64, 0x81, 0x5F, 0x64, 0x81, 0x2F, 0xB5, 0x84, 0xAF,
  0xB7, 0xA5, 0x28, 0x39, 0xEF, 0xD3,
  // "ċ" (U+010B)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x38, 0x92, 0x19, 0xDE, 0xC1, 0x0A, 0xFA, 0x79,
  0x29, 0x0C, 0x48, 0x11, 0xF9, 0x59, 0x0C, 0x58, 0x3B, 0xFA, 0x7C, 0x28, 0x31, 0xAE, 0xEB, 0x10,
  // "Č" (U+010C)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x74, 0x89, 0x56, 0xCF, 0xD6, 0x07, 0xFB, 0x7A, 0x40,
  0xFC, 0x48, 0x14, 0xF7, 0x48, 0x15, 0xF6, 0x48, 0x15, 0xF6, 0x48, 0x12, 0xFB, 0x58, 0x4A, 0xFB,
  0x7A, 0x52, 0x83, 0x9E, 0xFD, 0x30,
  // "č" (U+010D)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x73, 0x89, 0x21, 0x9D, 0xEC, 0x10, 0xAF, 0xA7, 0x92,
  0x90, 0xC4, 0x81, 0x1F, 0x95, 0x90, 0xC5, 0x83, 0xBF, 0xA7, 0xC2, 0x83, 0x1A, 0xEE, 0xB1,
  // "Ď" (U+010E)
  0x83, 0x5D, 0x3C, 0x83, 0x81, 0x9F, 0xC7, 0x30, 0x7B, 0x8A, 0x2B, 0x30, 0x7F, 0x98, 0xEE, 0x27,
  0xF3, 0x04, 0xF8, 0x7F, 0x32, 0x98, 0x2C, 0x7F, 0x32, 0x83, 0xEC, 0x7F, 0x32, 0x98, 0x96, 0xB7,
  0xF3, 0x05, 0xF8, 0x7F, 0x98, 0xEE, 0x17, 0xA8, 0x1E, 0xB2, 0x10,
  // "ď" (U+010F)
  0x48, 0x2B, 0xE8, 0xD4, 0x82, 0xBE, 0x52, 0x40, 0xB0, 0xE3, 0x83, 0x9E, 0xBB, 0xE2, 0x84, 0x4F,
  0xC8, 0xFE, 0x28, 0x47, 0xF3, 0x0B, 0xE2, 0x84, 0x9F, 0x20, 0x9E, 0x28, 0x48, 0xF3, 0x0B, 0xE2,
  0x84, 0x4F, 0xC9, 0xFE, 0x38, 0x39, 0xE9, 0x9E, 0x20,
  // "Đ" (U+0110)
  0x07, 0xB8, 0xA6, 0xB3, 0x07, 0xF9, 0x8E, 0xE2, 0x7F, 0x30, 0x4F, 0x88, 0xF5, 0x10, 0xFC, 0xB8,
  0xB0, 0x80, 0xEC, 0x9F, 0x72, 0x0F, 0xB7, 0xF3, 0x05, 0xF8, 0x7F, 0x98, 0xEE, 0x17, 0xA8, 0x1E,
  0xB2, 0x10,
  // "đ" (U+0111)
  0x38, 0x21, 0x4F, 0x94, 0x0D, 0xB0, 0x33, 0x8B, 0x64, 0x6F, 0xA1, 0x06, 0xED, 0x8F, 0x80, 0x2F,
  0xE8, 0xCF, 0x80, 0x6F, 0x60, 0x3F, 0x80, 0x7F, 0x42, 0x98, 0x97, 0x80, 0x5F, 0x50, 0x2F, 0x80,
  0x2F, 0xD8, 0xCF, 0x82, 0x84, 0x6E, 0xD5, 0xE8, 0x10,
  // "Ē" (U+0112)
  0x10, 0xF2, 0x20, 0x3B, 0x85, 0x60, 0x15, 0x55, 0x21, 0xD8, 0x75, 0xFC, 0x77, 0x72, 0xF9, 0x49,
  0x0A, 0x0F, 0x21, 0xD8, 0x72, 0xFB, 0x55, 0x50, 0xF9, 0x49, 0x83, 0xC7, 0x77, 0x2D, 0x05,
  // "ē" (U+0113)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x28, 0x32, 0xBE, 0xD5, 0x28, 0x94, 0xDE,
  0x8B, 0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA4, 0x93, 0xF9, 0x55, 0x53, 0x0C, 0xE9, 0x79, 0x40,
  0x1A, 0xDF, 0xC3,
  // "Ĕ" (U+0114)
  0x86, 0x38, 0x27, 0x60, 0x1E, 0xA0, 0x32, 0x81, 0x14, 0x12, 0xD8, 0x75, 0xFC, 0x77, 0x72, 0xF9,
  0x49, 0x0A, 0x0F, 0x21, 0xD8, 0x72, 0xFB, 0x55, 0x50, 0xF9, 0x49, 0x83, 0xC7, 0x77, 0x2D, 0x05,
  // "ĕ" (U+0115)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0x32, 0xBE, 0xD5, 0x28,
  0x94, 0xDE, 0x8B, 0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA4, 0x93, 0xF9, 0x55, 0x53, 0x0C, 0xE9,
  0x79, 0x40, 0x1A, 0xDF, 0xC3,
  // "Ė" (U+0116)
  0x20, 0x14, 0x81, 0x5F, 0x83, 0x81, 0x4E, 0x77, 0x1D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90,
  0xA0, 0xF2, 0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "ė" (U+0117)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x38, 0x32, 0xBE, 0xD5, 0x28, 0x94, 0xDE, 0x8B,
  0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA4, 0x93, 0xF9, 0x55, 0x53, 0x0C, 0xE9, 0x79, 0x40, 0x1A,
  0xDF, 0xC3,
  // "Ę" (U+0118)
  0xD8, 0x75, 0xFC, 0x77, 0x72, 0xF9, 0x49, 0x0A, 0x0F, 0x21, 0xD8, 0x72, 0xFB, 0x55, 0x50, 0xF9,
  0x49, 0x83, 0xC7, 0x77, 0x2D, 0x05, 0x30, 0xC0, 0x23, 0x81, 0x6D, 0x23, 0x81, 0x4F, 0xC4, 0x00,
  0x31,
  // "ę" (U+0119)
  0x18, 0x32, 0xBE, 0xD5, 0x28, 0x94, 0xDE, 0x8B, 0xF2, 0x4F, 0x82, 0x3F, 0x75, 0xD8, 0xA1, 0x93,
  0xF9, 0x55, 0x53, 0x0C, 0xE9, 0x79, 0x40, 0x1A, 0xDA, 0x04, 0x40, 0xA0, 0x65, 0x90, 0xA0, 0x14,
  0x81, 0x9F, 0x30,
  // "Ě" (U+011A)
  0x83, 0x5D, 0x3C, 0x82, 0x81, 0x9F, 0xC7, 0x1D, 0x87, 0x5F, 0xC7, 0x77, 0x2F, 0x94, 0x90, 0xA0,
  0xF2, 0x1D, 0x87, 0x2F, 0xB5, 0x55, 0x0F, 0x94, 0x98, 0x3C, 0x77, 0x72, 0xD0, 0x50,
  // "ě" (U+011B)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x73, 0x83, 0x2B, 0xED, 0x52, 0x89, 0x4D, 0xE8, 0xBF,
  0x24, 0xF8, 0x23, 0xF7, 0x5D, 0x8A, 0x49, 0x3F, 0x95, 0x55, 0x30, 0xCE, 0x97, 0x94, 0x01, 0xAD,
  0xFC, 0x30,
  // "Ĝ" (U+011C)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x89, 0x61, 0x9E, 0xEC, 0x40, 0xBF, 0xA7, 0xA3,
  0x4F, 0x94, 0x89, 0x17, 0xF3, 0x02, 0x21, 0x9F, 0x11, 0xA8, 0x91, 0xA8, 0xF3, 0x05, 0xEA, 0x5F,
  0x82, 0x89, 0x6E, 0xA0, 0xDF, 0x97, 0xEA, 0x02, 0xAE, 0xFD, 0x60,
  // "ĝ" (U+011D)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x8D, 0x66, 0xDD, 0x5E, 0x82, 0xFE, 0x8C, 0xF8,
  0x6F, 0x60, 0x3F, 0x87, 0xF4, 0x01, 0xF8, 0x6F, 0x60, 0x3F, 0x82, 0xFE, 0x8C, 0xF8, 0x06, 0xDD,
  0x8F, 0x84, 0x89, 0x64, 0xF7, 0x1D, 0x87, 0xDF, 0x20, 0xCE, 0xEC, 0x41,
  // "Ğ" (U+011E)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0x96, 0x19, 0xEE, 0xC4,
  0x0B, 0xFA, 0x7A, 0x34, 0xF9, 0x48, 0x91, 0x7F, 0x30, 0x22, 0x19, 0xF1, 0x1A, 0x89, 0x1A, 0x8F,
  0x30, 0x5E, 0xA5, 0xF8, 0x28, 0x96, 0xEA, 0x0D, 0xF9, 0x7E, 0xA0, 0x2A, 0xEF, 0xD6,
  // "ğ" (U+011F)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0xD6, 0x6D, 0xD5, 0xE8,
  0x2F, 0xE8, 0xCF, 0x86, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0x86, 0xF6, 0x03, 0xF8, 0x2F, 0xE8,
  0xCF, 0x80, 0x6D, 0xD8, 0xF8, 0x48, 0x96, 0x4F, 0x71, 0xD8, 0x7D, 0xF2, 0x0C, 0xEE, 0xC4, 0x10,
  // "Ġ" (U+0120)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x38, 0x96, 0x19, 0xEE, 0xC4, 0x0B, 0xFA, 0x7A,
  0x34, 0xF9, 0x48, 0x91, 0x7F, 0x30, 0x22, 0x19, 0xF1, 0x1A, 0x89, 0x1A, 0x8F, 0x30, 0x5E, 0xA5,
  0xF8, 0x28, 0x96, 0xEA, 0x0D, 0xF9, 0x7E, 0xA0, 0x2A, 0xEF, 0xD6,
  // "ġ" (U+0121)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x38, 0xD6, 0x6D, 0xD5, 0xE8, 0x2F, 0xE8, 0xCF,
  0x86, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0x86, 0xF6, 0x03, 0xF8, 0x2F, 0xE8, 0xCF, 0x80, 0x6D,
  0xD8, 0xF8, 0x48, 0x96, 0x4F, 0x71, 0xD8, 0x7D, 0xF2, 0x0C, 0xEE, 0xC4, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x96, 0x19, 0xEE, 0xC4, 0x0B, 0xFA, 0x7A, 0x34, 0xF9, 0x48, 0x91, 0x7F, 0x30, 0x22, 0x19,
  0xF1, 0x1A, 0x89, 0x1A, 0x8F, 0x30, 0x5E, 0xA5, 0xF8, 0x28, 0x96, 0xEA, 0x0D, 0xF9, 0x7E, 0xA0,
  0x2A, 0xEF, 0xD6, 0x30, 0x01, 0x50, 0xE0, 0x65, 0x04, 0x30,
  // "ģ" (U+0123)
  0x30, 0xC0, 0x74, 0x81, 0x27, 0x17, 0x38, 0xD6, 0x6D, 0xD5, 0xE8, 0x2F, 0xE8, 0xCF, 0x86, 0xF6,
  0x03, 0xF8, 0x7F, 0x40, 0x1F, 0x86, 0xF6, 0x03, 0xF8, 0x2F, 0xE8, 0xCF, 0x80, 0x6D, 0xD8, 0xF8,
  0x48, 0x96, 0x4F, 0x71, 0xD8, 0x7D, 0xF2, 0x0C, 0xEE, 0xC4, 0x10,
  // "Ĥ" (U+0124)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x8B, 0x37, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x52, 0x3F, 0xA7, 0xD8, 0xB3, 0xA7, 0xF8, 0x55, 0xFA, 0x7F, 0x40,
  0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA0,
  // "ĥ" (U+0125)
  0x18, 0x18, 0xFC, 0x48, 0x34, 0xD3, 0xB8, 0x75, 0x81, 0x5F, 0x65, 0x81, 0x5F, 0x65, 0x81, 0x5F,
  0x65, 0x84, 0x5F, 0x8C, 0xEA, 0x28, 0xD5, 0x5F, 0xE8, 0xCF, 0x60, 0x5F, 0x80, 0x3F, 0x80, 0x5F,
  0x60, 0x2F, 0x90, 0x5F, 0x60, 0x2F, 0x90, 0x5F, 0x60, 0x2F, 0x90, 0x5F, 0x60, 0x2F, 0x90,
  // "Ħ" (U+0126)
  0x85, 0x6F, 0x72, 0x5F, 0x91, 0xF8, 0xA0, 0x38, 0xF9, 0x57, 0xFA, 0x14, 0xF7, 0x25, 0xF8, 0x04,
  0xD8, 0xB7, 0x80, 0x4F, 0x95, 0x7F, 0x80, 0x4F, 0x60, 0x3F, 0x80, 0x4F, 0x60, 0x3F, 0x80, 0x4F,
  0x60, 0x3F, 0x81,
  // "ħ" (U+0127)
  0x82, 0x6F, 0x72, 0x3C, 0x02, 0x28, 0x28, 0xF9, 0x53, 0x86, 0x5F, 0x8C, 0xEA, 0x05, 0xA8, 0xC5,
  0x8C, 0xF6, 0x5F, 0x80, 0x3F, 0x85, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9,
  0x5F, 0x60, 0x2F, 0x90,
  // "Ĩ" (U+0128)
  0x89, 0x33, 0xE9, 0x3C, 0x08, 0x7A, 0xF7, 0x02, 0x20, 0x22, 0x0E, 0xC8, 0x41, 0x48, 0xFA, 0x52,
  0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x62, 0x85,
  0x48, 0xFA, 0x50, 0xEC, 0x01,
  // "ĩ" (U+0129)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x30, 0xEA, 0x09, 0x38, 0x25,
  0x8F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x47, 0xFC, 0x51, 0x4D,
  0x09,
  // "Ī" (U+012A)
  0x10, 0xF2, 0x20, 0x3B, 0x87, 0x60, 0x15, 0x55, 0x20, 0xEC, 0x84, 0x14, 0x8F, 0xA5, 0x28, 0x13,
  0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x28, 0x54, 0x8F,
  0xA5, 0x0E, 0xC0, 0x10,
  // "ī" (U+012B)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x20, 0xEA, 0x09, 0x38, 0x25, 0x8F, 0x94,
  0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x47, 0xFC, 0x51, 0x4D, 0x09,
  // "Ĭ" (U+012C)
  0x86, 0x38, 0x27, 0x60, 0x1E, 0xA0, 0x32, 0x81, 0x14, 0x12, 0x0E, 0xC8, 0x41, 0x48, 0xFA, 0x52,
  0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x62, 0x85,
  0x48, 0xFA, 0x50, 0xEC, 0x01,
  // "ĭ" (U+012D)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x30, 0xEA, 0x09, 0x38, 0x25,
  0x8F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x47, 0xFC, 0x51, 0x4D,
  0x09,
  // "Į" (U+012E)
  0x0E, 0xC8, 0x41, 0x48, 0xFA, 0x52, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81, 0x3F, 0x63, 0x81,
  0x3F, 0x63, 0x81, 0x3F, 0x62, 0x85, 0x48, 0xFA, 0x50, 0xEC, 0x01, 0x30, 0xC0, 0x23, 0x81, 0x6D,
  0x23, 0x81, 0x4F, 0xC4, 0x00, 0x31,
  // "į" (U+012F)
  0x28, 0x11, 0xEA, 0x48, 0x12, 0xFB, 0x50, 0x14, 0x0E, 0xA0, 0x93, 0x82, 0x58, 0xF9, 0x48, 0x11,
  0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38, 0x54, 0x7F, 0xC5, 0x14, 0xD0, 0x94, 0x0C, 0x02,
  0x48, 0x16, 0xD2, 0x48, 0x14, 0xFC, 0x50, 0x03, 0x10,
  // "İ" (U+0130)
  0x20, 0x14, 0x81, 0x5F, 0x83, 0x81, 0x4E, 0x77, 0x10, 0xEC, 0x84, 0x14, 0x8F, 0xA5, 0x28, 0x13,
  0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x28, 0x54, 0x8F,
  0xA5, 0x0E, 0xC0, 0x10,
  // "ı" (U+0131)
  0x10, 0xEA, 0x09, 0x38, 0x25, 0x8F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93,
  0x85, 0x47, 0xFC, 0x51, 0x4D, 0x09,
  // "Ĳ" (U+0132)
  0x98, 0xC1, 0xA0, 0x8F, 0x2F, 0xA0, 0x8F, 0x2F, 0xA0, 0x8F, 0x2F, 0xA0, 0x8F, 0x2F, 0xA0, 0x8F,
  0x2F, 0xA0, 0x8F, 0x23, 0x89, 0x4A, 0xF1, 0xB9, 0xAF, 0xC0, 0xCF, 0xEB, 0x21,
  // "ĳ" (U+0133)
  0x89, 0x2D, 0xC0, 0x9E, 0x2E, 0xD0, 0xAF, 0x24, 0x8D, 0x21, 0x0E, 0xC0, 0x9F, 0x1E, 0xC0, 0x9F,
  0x1E, 0xC0, 0x9F, 0x1E, 0xC0, 0x9F, 0x1E, 0xC0, 0x9F, 0x1E, 0xC0, 0x9F, 0x1E, 0xC0, 0x9F, 0x13,
  0x89, 0x4B, 0xF0, 0x69, 0xAF, 0xD0, 0x6E, 0xEC, 0x31,
  // "Ĵ" (U+0134)
  0x28, 0x18, 0xFC, 0x28, 0x34, 0xD3, 0xB8, 0x72, 0x0C, 0x0D, 0x40, 0xC0, 0xD4, 0x0C, 0x0D, 0x40,
  0xC0, 0xD4, 0x0C, 0x0D, 0x40, 0xC0, 0xD4, 0x89, 0x3E, 0xC0, 0xB9, 0xBF, 0x80, 0xDF, 0xE9, 0x20,
  // "ĵ" (U+0135)
  0x28, 0x18, 0xFC, 0x28, 0x34, 0xD3, 0xB8, 0x70, 0x7B, 0x85, 0x20, 0x27, 0xCF, 0x23, 0x81, 0x9F,
  0x23, 0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x81, 0x9F, 0x23, 0x89, 0x4A, 0xF1,
  0x69, 0xAF, 0xD0, 0x6E, 0xFC, 0x31,
  // "Ķ" (U+0136)
  0x8B, 0x07, 0xF3, 0x06, 0xF7, 0x7F, 0x31, 0xEC, 0x07, 0xF3, 0xAF, 0x20, 0x7F, 0x8F, 0x72, 0x07,
  0xB0, 0x52, 0x83, 0x7F, 0xBE, 0xD2, 0x8A, 0x37, 0xF3, 0x7F, 0x60, 0x7F, 0x30, 0xED, 0x07, 0xF3,
  0x06, 0xF7, 0x30, 0x01, 0x50, 0xE0, 0x65, 0x04, 0x30,
  // "ķ" (U+0137)
  0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x8A, 0x14, 0xF7, 0x08, 0xF6, 0x4F, 0x75,
  0xF9, 0x04, 0xF8, 0xEC, 0x20, 0x4B, 0x0C, 0x28, 0xA3, 0x4F, 0xC7, 0xF7, 0x04, 0xF7, 0x0B, 0xE1,
  0x4F, 0x70, 0x2F, 0xA3, 0x00, 0x15, 0x0E, 0x06, 0x50, 0x43,
  // "ĸ" (U+0138)
  0x8A, 0x14, 0xF7, 0x08, 0xF6, 0x4F, 0x75, 0xF9, 0x04, 0xF8, 0xEC, 0x20, 0x4B, 0x0C, 0x28, 0xA3,
  0x4F, 0xC7, 0xF7, 0x04, 0xF7, 0x0B, 0xE1, 0x4F, 0x70, 0x2F, 0xA0,
  // "Ĺ" (U+0139)
  0x18, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x72, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0,
  0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x48, 0x5E, 0xE9, 0x99, 0x3E, 0xC0, 0x50,
  // "ĺ" (U+013A)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x0D, 0xA0, 0x93, 0x82, 0x59, 0xF9, 0x48, 0x11, 0xF9,
  0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11, 0xF9, 0x38,
  0x54, 0x8F, 0xC5, 0x14, 0xD0, 0x90,
  // "Ļ" (U+013B)
  0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E,
  0x0C, 0x48, 0x5E, 0xE9, 0x99, 0x3E, 0xC0, 0x52, 0x00, 0x14, 0x0E, 0x06, 0x40, 0x43,
  // "ļ" (U+013C)
  0x10, 0xDA, 0x09, 0x38, 0x25, 0x9F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94,
  0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x93, 0x85, 0x48, 0xFC, 0x51, 0x4D, 0x09, 0x30,
  0x01, 0x50, 0xE0, 0x65, 0x04, 0x30,
  // "Ľ" (U+013D)
  0x89, 0x4E, 0xC0, 0x6E, 0x1E, 0xC0, 0x43, 0x0E, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C,
  0x40, 0xE0, 0xC4, 0x85, 0xEE, 0x99, 0x93, 0xEC, 0x05,
  // "ľ" (U+013E)
  0x10, 0xBA, 0x81, 0x98, 0xD2, 0x83, 0x2F, 0x95, 0x22, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81,
  0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x94, 0x81, 0x1F, 0x92, 0x86, 0x16, 0xAF, 0xD7, 0x34,
  0xD0, 0x90,
  // "Ŀ" (U+013F)
  0x0E, 0x0C, 0x40, 0xE0, 0xC4, 0x0E, 0x0C, 0x40, 0xE0, 0xC2, 0x89, 0x61, 0x0E, 0xC0, 0x5F, 0x8E,
  0xC0, 0x4E, 0x7E, 0xC4, 0x85, 0xEE, 0x99, 0x93, 0xEC, 0x05,
  // "ŀ" (U+0140)
  0x10, 0xDA, 0x09, 0x58, 0x25, 0x9F, 0x96, 0x81, 0x1F, 0x96, 0x81, 0x1F, 0x96, 0x81, 0x1F, 0x92,
  0x01, 0x38, 0x51, 0xF9, 0x05, 0xF8, 0x28, 0x51, 0xF9, 0x04, 0xE7, 0x28, 0x11, 0xF9, 0x58, 0x44,
  0x8F, 0xC5, 0x12, 0x04, 0xD0, 0x92,
  // "Ł" (U+0141)
  0x18, 0x16, 0xF4, 0x48, 0x16, 0xF4, 0x48, 0x26, 0xF4, 0x13, 0x82, 0x6F, 0xE9, 0x38, 0x2A, 0xFB,
  0x22, 0x04, 0xA0, 0x44, 0x81, 0x7F, 0x44, 0x86, 0x6F, 0xB9, 0x97, 0x06, 0xC0, 0xD0,
  // "ł" (U+0142)
  0x10, 0xDA, 0x09, 0x38, 0x25, 0x9F, 0x94, 0x81, 0x1F, 0x94, 0x82, 0x1F, 0xA3, 0x30, 0x1A, 0x0C,
  0x28, 0x31, 0xAF, 0xC1, 0x28, 0x25, 0xEF, 0x94, 0x81, 0x3F, 0x93, 0x85, 0x48, 0xFC, 0x51, 0x4D,
  0x09,
  // "Ń" (U+0143)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x07, 0xA8, 0x31, 0x0D, 0xA7, 0xA8, 0xD1, 0x50, 0xDA,
  0x7F, 0xBA, 0x0D, 0xA7, 0xF7, 0xE0, 0xDA, 0x7F, 0x3F, 0x4D, 0xA7, 0xF1, 0xC9, 0xDA, 0x7F, 0x17,
  0xED, 0xA7, 0xF1, 0x3A, 0x86, 0xA7, 0xF1, 0x0D, 0xFA,
  // "ń" (U+0144)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x86, 0x5F, 0x5C, 0xEA, 0x05, 0xA8, 0xC5, 0x8C, 0xF6,
  0x5F, 0x90, 0x3F, 0x85, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F, 0x60,
  0x2F, 0x90,
  // "Ņ" (U+0145)
  0x07, 0xA8, 0x31, 0x0D, 0xA7, 0xA8, 0xD1, 0x50, 0xDA, 0x7F, 0xBA, 0x0D, 0xA7, 0xF7, 0xE0, 0xDA,
  0x7F, 0x3F, 0x4D, 0xA7, 0xF1, 0xC9, 0xDA, 0x7F, 0x17, 0xED, 0xA7, 0xF1, 0x3A, 0x86, 0xA7, 0xF1,
  0x0D, 0xFA, 0x30, 0x01, 0x50, 0xE0, 0x65, 0x04, 0x30,
  // "ņ" (U+0146)
  0x86, 0x5F, 0x5C, 0xEA, 0x05, 0xA8, 0xC5, 0x8C, 0xF6, 0x5F, 0x90, 0x3F, 0x85, 0xF6, 0x02, 0xF9,
  0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x93, 0x00, 0x15, 0x0E, 0x06, 0x50,
  0x43,
  // "Ň" (U+0147)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x72, 0x07, 0xA8, 0x31, 0x0D, 0xA7, 0xA8, 0xD1, 0x50,
  0xDA, 0x7F, 0xBA, 0x0D, 0xA7, 0xF7, 0xE0, 0xDA, 0x7F, 0x3F, 0x4D, 0xA7, 0xF1, 0xC9, 0xDA, 0x7F,
  0x17, 0xED, 0xA7, 0xF1, 0x3A, 0x86, 0xA7, 0xF1, 0x0D, 0xFA,
  // "ň" (U+0148)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x72, 0x86, 0x5F, 0x5C, 0xEA, 0x05, 0xA8, 0xC5, 0x8C,
  0xF6, 0x5F, 0x90, 0x3F, 0x85, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F,
  0x60, 0x2F, 0x90,
  // "ŉ" (U+0149)
  0x10, 0xD0, 0xC7, 0x90, 0x76, 0x86, 0x4F, 0x5F, 0x6C, 0xEA, 0x30, 0x3A, 0x82, 0x9B, 0xF6, 0x28,
  0x53, 0xFA, 0x03, 0xF8, 0x28, 0x53, 0xF8, 0x02, 0xF9, 0x28, 0x53, 0xF8, 0x02, 0xF9, 0x28, 0x53,
  0xF8, 0x02, 0xF9, 0x28, 0x53, 0xF8, 0x02, 0xF9,
  // "Ŋ" (U+014A)
  0x07, 0xA8, 0x31, 0x0D, 0xA7, 0xA8, 0xD1, 0x50, 0xDA, 0x7F, 0xBA, 0x0D, 0xA7, 0xF7, 0xE0, 0xDA,
  0x7F, 0x3F, 0x4D, 0xA7, 0xF1, 0xC9, 0xDA, 0x7F, 0x17, 0xED, 0xA7, 0xF1, 0x3A, 0x86, 0xA7, 0xF1,
  0x0D, 0xFA, 0x38, 0x22, 0x3E, 0x82, 0x02, 0xA0, 0xD0, 0x13, 0x04, 0x03, 0x20,
  // "ŋ" (U+014B)
  0x86, 0x5F, 0x5C, 0xEA, 0x05, 0xA8, 0xC5, 0x8C, 0xF6, 0x5F, 0x90, 0x3F, 0x85, 0xF6, 0x02, 0xF9,
  0x5F, 0x60, 0x2F, 0x95, 0xF6, 0x02, 0xF9, 0x5F, 0x60, 0x2F, 0x94, 0x81, 0x2F, 0x93, 0x82, 0x4A,
  0xF6, 0x38, 0x28, 0xFB, 0x10,
  // "Ō" (U+014C)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x28, 0x33, 0xCF, 0xD5, 0x28, 0x96, 0xEE,
  0x8D, 0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82, 0xB9, 0xF2, 0x28, 0x3E, 0xC8, 0xF3, 0x29,
  0x8A, 0x3B, 0x5F, 0x60, 0x3F, 0x80, 0xEE, 0x8D, 0xF2, 0x03, 0xCF, 0xD5, 0x10,
  // "ō" (U+014D)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x31, 0x55, 0x52, 0x28, 0xD5, 0x3C, 0xED, 0x50, 0x1E, 0xE8,
  0xCF, 0x36, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0xA6, 0xF6, 0x03, 0xF9, 0x1E, 0xE8, 0xCF, 0x30,
  0x3C, 0xFD, 0x51,
  // "Ŏ" (U+014E)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0x33, 0xCF, 0xD5, 0x28,
  0x96, 0xEE, 0x8D, 0xF2, 0x5F, 0x60, 0x3F, 0x88, 0xF3, 0x29, 0x82, 0xB9, 0xF2, 0x28, 0x3E, 0xC8,
  0xF3, 0x29, 0x8A, 0x3B, 0x5F, 0x60, 0x3F, 0x80, 0xEE, 0x8D, 0xF2, 0x03, 0xCF, 0xD5, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x38, 0xD5, 0x3C, 0xED, 0x50,
  0x1E, 0xE8, 0xCF, 0x36, 0xF6, 0x03, 0xF8, 0x7F, 0x40, 0x1F, 0xA6, 0xF6, 0x03, 0xF9, 0x1E, 0xE8,
  0xCF, 0x30, 0x3C, 0xFD, 0x51,
  // "Ő" (U+0150)
  0x28, 0x21, 0x21, 0x22, 0x83, 0x2E, 0x7D, 0x82, 0x0F, 0x20, 0x33, 0x83, 0x3C, 0xFD, 0x52, 0x89,
  0x6E, 0xE8, 0xDF, 0x25, 0xF6, 0x03, 0xF8, 0x8F, 0x32, 0x98, 0x2B, 0x9F, 0x22, 0x83, 0xEC, 0x8F,
  0x32, 0x98, 0xA3, 0xB5, 0xF6, 0x03, 0xF8, 0x0E, 0xE8, 0xDF, 0x20, 0x3C, 0xFD, 0x51,
  // "ő" (U+0151)
  0x28, 0x21, 0x21, 0x22, 0x83, 0x2E, 0x7D, 0x82, 0x0F, 0x20, 0x33, 0x8D, 0x53, 0xCE, 0xD5, 0x01,
  0xEE, 0x8C, 0xF3, 0x6F, 0x60, 0x3F, 0x87, 0xF4, 0x01, 0xFA, 0x6F, 0x60, 0x3F, 0x91, 0xEE, 0x8C,
  0xF3, 0x03, 0xCF, 0xD5, 0x10,
  // "Œ" (U+0152)
  0x10, 0x50, 0xDB, 0x8B, 0x0E, 0x2F, 0xDA, 0xF9, 0x67, 0xF4, 0x4F, 0x40, 0x9F, 0x14, 0xF6, 0x19,
  0xF1, 0x4A, 0x8A, 0x7B, 0x9F, 0x14, 0xF8, 0x36, 0xF4, 0x4F, 0x40, 0x2F, 0xCA, 0xF9, 0x60, 0x6E,
  0xB0, 0xE0,
  // "œ" (U+0153)
  0x18, 0xB1, 0xBE, 0x5A, 0xE4, 0x07, 0xEA, 0xFD, 0xBC, 0x0A, 0xA0, 0xF9, 0x5F, 0x0B, 0x90, 0xEB,
  0x89, 0x61, 0xAA, 0x0F, 0xA5, 0x50, 0x7E, 0xAF, 0xE7, 0x82, 0x84, 0xBE, 0x5A, 0xE9, 0x10,
  // "Ŕ" (U+0154)
  0x38, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x7A, 0x8A, 0x4E, 0xC4, 0x0F, 0xD7, 0xDF, 0x2F, 0xA0, 0x6F,
  0x5F, 0xB2, 0xBF, 0x3C, 0x8B, 0x07, 0x0F, 0xC9, 0xF3, 0x0F, 0xA1, 0xEB, 0x0F, 0xA0, 0x8F, 0x3F,
  0xA0, 0x1F, 0xB0,
  // "ŕ" (U+0155)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x71, 0x02, 0xA8, 0x91, 0x98, 0xED, 0x04, 0xDF, 0xD8, 0x62,
  0x81, 0xCF, 0x24, 0x0C, 0x0E, 0x50, 0xC0, 0xE3, 0x86, 0x16, 0xEF, 0x62, 0x08, 0xC0, 0xA1,
  // "Ŗ" (U+0156)
  0xA8, 0xA4, 0xEC, 0x40, 0xFD, 0x7D, 0xF2, 0xFA, 0x06, 0xF5, 0xFB, 0x2B, 0xF3, 0xC8, 0xB0, 0x70,
  0xFC, 0x9F, 0x30, 0xFA, 0x1E, 0xB0, 0xFA, 0x08, 0xF3, 0xFA, 0x01, 0xFB, 0x20, 0x01, 0x40, 0xE0,
  0x64, 0x04, 0x30,
  // "ŗ" (U+0157)
  0x02, 0xA8, 0x91, 0x98, 0xED, 0x04, 0xDF, 0xD8, 0x62, 0x81, 0xCF, 0x24, 0x0C, 0x0E, 0x50, 0xC0,
  0xE3, 0x86, 0x16, 0xEF, 0x62, 0x08, 0xC0, 0xA3, 0x00, 0x15, 0x0E, 0x06, 0x50, 0x44,
  // "Ř" (U+0158)
  0x83, 0x5D, 0x3C, 0x82, 0x81, 0x9F, 0xC7, 0x1A, 0x8A, 0x4E, 0xC4, 0x0F, 0xD7, 0xDF, 0x2F, 0xA0,
  0x6F, 0x5F, 0xB2, 0xBF, 0x3C, 0x8B, 0x07, 0x0F, 0xC9, 0xF3, 0x0F, 0xA1, 0xEB, 0x0F, 0xA0, 0x8F,
  0x3F, 0xA0, 0x1F, 0xB0,
  // "ř" (U+0159)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x72, 0x02, 0xA8, 0x91, 0x98, 0xED, 0x04, 0xDF, 0xD8,
  0x62, 0x81, 0xCF, 0x24, 0x0C, 0x0E, 0x50, 0xC0, 0xE3, 0x86, 0x16, 0xEF, 0x62, 0x08, 0xC0, 0xA1,
  // "Ś" (U+015A)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0x89, 0x22, 0xBE, 0xEB, 0x20, 0xCF, 0x88, 0xC2, 0x0E,
  0x0D, 0x58, 0x2A, 0xF9, 0x14, 0x82, 0xAF, 0xE6, 0x48, 0x24, 0xDF, 0x54, 0x89, 0x64, 0xF8, 0x2D,
  0x98, 0xCF, 0x41, 0xBE, 0xFD, 0x61,
  // "ś" (U+015B)
  0x38, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x78, 0x96, 0x3C, 0xEE, 0xA1, 0xDE, 0x79, 0xB0, 0xDE, 0x61,
  0x28, 0x33, 0xCF, 0xE7, 0x38, 0x95, 0x4D, 0xF2, 0xD9, 0x7D, 0xF1, 0xCE, 0xFD, 0x61,
  // "Ŝ" (U+015C)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x72, 0x89, 0x22, 0xBE, 0xEB, 0x20, 0xCF, 0x88, 0xC2,
  0x0E, 0x0D, 0x58, 0x2A, 0xF9, 0x14, 0x82, 0xAF, 0xE6, 0x48, 0x24, 0xDF, 0x54, 0x89, 0x64, 0xF8,
  0x2D, 0x98, 0xCF, 0x41, 0xBE, 0xFD, 0x61,
  // "ŝ" (U+015D)
  0x18, 0x18, 0xFC, 0x28, 0x34, 0xD3, 0xB8, 0x78, 0x96, 0x3C, 0xEE, 0xA1, 0xDE, 0x79, 0xB0, 0xDE,
  0x61, 0x28, 0x33, 0xCF, 0xE7, 0x38, 0x95, 0x4D, 0xF2, 0xD9, 0x7D, 0xF1, 0xCE, 0xFD, 0x61,
  // "Ş" (U+015E)
  0x18, 0x92, 0x2B, 0xEE, 0xB2, 0x0C, 0xF8, 0x8C, 0x20, 0xE0, 0xD5, 0x82, 0xAF, 0x91, 0x48, 0x2A,
  0xFE, 0x64, 0x82, 0x4D, 0xF5, 0x48, 0x96, 0x4F, 0x82, 0xD9, 0x8C, 0xF4, 0x1B, 0xEF, 0xD6, 0x38,
  0x11, 0xE3, 0x50, 0x80, 0xD4, 0x81, 0x8E, 0x72,
  // "ş" (U+015F)
  0x89, 0x63, 0xCE, 0xEA, 0x1D, 0xE7, 0x9B, 0x0D, 0xE6, 0x12, 0x83, 0x3C, 0xFE, 0x73, 0x89, 0x54,
  0xDF, 0x2D, 0x97, 0xDF, 0x1C, 0xEF, 0xD6, 0x28, 0x11, 0xE3, 0x40, 0x80, 0xD3, 0x81, 0x8E, 0x72,
  // "Š" (U+0160)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x73, 0x89, 0x22, 0xBE, 0xEB, 0x20, 0xCF, 0x88, 0xC2,
  0x0E, 0x0D, 0x58, 0x2A, 0xF9, 0x14, 0x82, 0xAF, 0xE6, 0x48, 0x24, 0xDF, 0x54, 0x89, 0x64, 0xF8,
  0x2D, 0x98, 0xCF, 0x41, 0xBE, 0xFD, 0x61,
  // "š" (U+0161)
  0x83, 0x5D, 0x3C, 0x82, 0x81, 0x9F, 0xC7, 0x18, 0x96, 0x3C, 0xEE, 0xA1, 0xDE, 0x79, 0xB0, 0xDE,
  0x61, 0x28, 0x33, 0xCF, 0xE7, 0x38, 0x95, 0x4D, 0xF2, 0xD9, 0x7D, 0xF1, 0xCE, 0xFD, 0x61,
  // "Ţ" (U+0162)
  0x09, 0xD8, 0x6D, 0x47, 0x9F, 0xB7, 0x62, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74,
  0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x1E, 0x35, 0x08,
  0x0D, 0x48, 0x18, 0xE7, 0x20,
  // "ţ" (U+0163)
  0x20, 0x30, 0x65, 0x09, 0x0D, 0x30, 0x30, 0xCC, 0x86, 0x52, 0x7E, 0xE7, 0x72, 0x20, 0x0D, 0x50,
  0x0D, 0x50, 0xD0, 0xE5, 0x83, 0xAF, 0x98, 0x32, 0x83, 0x2C, 0xFE, 0x42, 0x81, 0x1E, 0x35, 0x08,
  0x0D, 0x48, 0x18, 0xE7, 0x20,
  // "Ť" (U+0164)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x72, 0x09, 0xD8, 0x6D, 0x47, 0x9F, 0xB7, 0x62, 0x81,
  0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F,
  0x74, 0x81, 0x4F, 0x72,
  // "ť" (U+0165)
  0x28, 0x31, 0x20, 0xC9, 0x28, 0x28, 0xD0, 0x73, 0x0A, 0x0D, 0x30, 0x30, 0xDC, 0x86, 0x52, 0x7E,
  0xE7, 0x72, 0x20, 0x0D, 0x50, 0x0D, 0x50, 0xD0, 0xE5, 0x83, 0xAF, 0x98, 0x32, 0x83, 0x2B, 0xFE,
  0x40,
  // "Ŧ" (U+0166)
  0x09, 0xD8, 0x6D, 0x47, 0x9F, 0xB7, 0x62, 0x81, 0x4F, 0x73, 0x83, 0x15, 0xF8, 0x22, 0x0B, 0xB0,
  0xE2, 0x83, 0x38, 0xF9, 0x43, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x72,
  // "ŧ" (U+0167)
  0x20, 0x30, 0x65, 0x09, 0x0D, 0x30, 0x30, 0xCC, 0x89, 0x65, 0x27, 0xEE, 0x77, 0x20, 0x2D, 0xD2,
  0x20, 0x5D, 0x86, 0x61, 0x5E, 0xE5, 0x51, 0x28, 0x3B, 0xF9, 0x83, 0x28, 0x33, 0xCF, 0xE4,
  // "Ũ" (U+0168)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x28, 0xF4, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4,
  0x01, 0xFA, 0x5F, 0x60, 0x3F, 0x81, 0xEE, 0x9D, 0xF4, 0x04, 0xCE, 0xD6, 0x10,
  // "ũ" (U+0169)
  0x18, 0x33, 0xE9, 0x3C, 0x28, 0x38, 0x7A, 0xF7, 0x20, 0x22, 0x02, 0x28, 0xD7, 0x6F, 0x50, 0x3F,
  0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x60, 0x5F, 0x83, 0xFD,
  0x8E, 0xF8, 0x08, 0xED, 0x5E, 0x80,
  // "Ū" (U+016A)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0x98, 0x21, 0x55, 0x52, 0x07, 0xF4, 0x01, 0xFA, 0x7F, 0x40,
  0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5,
  0xF6, 0x03, 0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "ū" (U+016B)
  0x20, 0xF2, 0x30, 0x3B, 0x06, 0x28, 0xE5, 0x15, 0x55, 0x20, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03,
  0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x60, 0x5F, 0x83, 0xFD, 0x8E, 0xF8, 0x08,
  0xED, 0x5E, 0x80,
  // "Ŭ" (U+016C)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x28, 0xF4, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4,
  0x01, 0xFA, 0x5F, 0x60, 0x3F, 0x81, 0xEE, 0x9D, 0xF4, 0x04, 0xCE, 0xD6, 0x10,
  // "ŭ" (U+016D)
  0x18, 0x33, 0x82, 0x76, 0x20, 0x10, 0xEA, 0x03, 0x38, 0x11, 0x41, 0x28, 0xD7, 0x6F, 0x50, 0x3F,
  0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x60, 0x5F, 0x83, 0xFD,
  0x8E, 0xF8, 0x08, 0xED, 0x5E, 0x80,
  // "Ů" (U+016E)
  0x30, 0x15, 0x81, 0x7F, 0xA4, 0x81, 0xC9, 0xE4, 0x81, 0x9F, 0xC5, 0x04, 0x01, 0x28, 0xF4, 0x7F,
  0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F,
  0xA7, 0xF4, 0x01, 0xFA, 0x5F, 0x60, 0x3F, 0x81, 0xEE, 0x9D, 0xF4, 0x04, 0xCE, 0xD6, 0x10,
  // "ů" (U+016F)
  0x30, 0x15, 0x81, 0x7F, 0xA4, 0x81, 0xC9, 0xE4, 0x81, 0x9F, 0xC5, 0x04, 0x01, 0x28, 0xD7, 0x6F,
  0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x60, 0x5F,
  0x83, 0xFD, 0x8E, 0xF8, 0x08, 0xED, 0x5E, 0x80,
  // "Ű" (U+0170)
  0x28, 0x21, 0x21, 0x22, 0x83, 0x2E, 0x7D, 0x82, 0x0F, 0x20, 0x32, 0x8F, 0x47, 0xF4, 0x01, 0xFA,
  0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40,
  0x1F, 0xA5, 0xF6, 0x03, 0xF8, 0x1E, 0xE9, 0xDF, 0x40, 0x4C, 0xED, 0x61,
  // "ű" (U+0171)
  0x28, 0x21, 0x21, 0x22, 0x83, 0x2E, 0x7D, 0x82, 0x0F, 0x20, 0x32, 0x8D, 0x76, 0xF5, 0x03, 0xF8,
  0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF6, 0x05, 0xF8, 0x3F, 0xD8,
  0xEF, 0x80, 0x8E, 0xD5, 0xE8,
  // "Ų" (U+0172)
  0x8F, 0x47, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7, 0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA7,
  0xF4, 0x01, 0xFA, 0x7F, 0x40, 0x1F, 0xA5, 0xF6, 0x03, 0xF8, 0x1F, 0xE8, 0xDF, 0x30, 0x5D, 0xFD,
  0x43, 0x81, 0x1D, 0x14, 0x81, 0x5E, 0x64, 0x81, 0x2D, 0xC2,
  // "ų" (U+0173)
  0x8D, 0x76, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF6, 0x05, 0xF8, 0x3F, 0xD8, 0xEF, 0x80, 0x8E, 0xD5, 0xF8, 0x50, 0xC0, 0x24, 0x81, 0x6D, 0x24,
  0x81, 0x4F, 0xC5, 0x00, 0x30,
  // "Ŵ" (U+0174)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x0D, 0x0A, 0x38, 0x27, 0xFC, 0xB3, 0x8C, 0x48,
  0xFA, 0xD4, 0xF7, 0x9E, 0x9E, 0x6F, 0xAA, 0xD8, 0xE9, 0xCC, 0xBC, 0x7F, 0xB8, 0xEB, 0xB6, 0xFD,
  0x4F, 0xCA, 0x5A, 0x89, 0x11, 0xDE, 0x94, 0xFE, 0x0B, 0xF8,
  // "ŵ" (U+0175)
  0x28, 0x18, 0xFC, 0x48, 0x34, 0xD3, 0xB8, 0x73, 0x0E, 0x0A, 0x38, 0xD2, 0x6F, 0x1C, 0xB3, 0xF7,
  0x7F, 0x09, 0xC6, 0xF9, 0x9D, 0x07, 0xE9, 0xCC, 0xAB, 0x05, 0xFB, 0x7F, 0xB9, 0x03, 0xFE, 0x3F,
  0xE6, 0x01, 0xA1, 0x81, 0xCF, 0x41,
  // "Ŷ" (U+0176)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x8A, 0x28, 0xF4, 0x01, 0xFB, 0x1F, 0xA0, 0x7F,
  0x40, 0x9F, 0x1D, 0xC2, 0x83, 0x2F, 0xBF, 0x53, 0x81, 0xBF, 0xD4, 0x81, 0x5F, 0x84, 0x81, 0x4F,
  0x74, 0x81, 0x4F, 0x74, 0x81, 0x4F, 0x72,
  // "ŷ" (U+0177)
  0x28, 0x18, 0xFC, 0x38, 0x34, 0xD3, 0xB8, 0x71, 0x8B, 0x19, 0xF4, 0x01, 0xFC, 0x3F, 0x90, 0x5F,
  0x60, 0xCE, 0x09, 0xF1, 0x07, 0xF3, 0xDB, 0x28, 0x31, 0xFA, 0xF6, 0x30, 0xBA, 0x01, 0x38, 0x15,
  0xFB, 0x48, 0x16, 0xF5, 0x28, 0x22, 0x9E, 0xD3, 0x82, 0x4F, 0xC2, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x37, 0xE0, 0xBC, 0x28, 0xB0, 0x13, 0x02, 0x20, 0x8F, 0x40, 0x1F, 0xB1, 0xFA, 0x07, 0xF4,
  0x09, 0xF1, 0xDC, 0x28, 0x32, 0xFB, 0xF5, 0x38, 0x1B, 0xFD, 0x48, 0x15, 0xF8, 0x48, 0x14, 0xF7,
  0x48, 0x14, 0xF7, 0x48, 0x14, 0xF7, 0x20,
  // "Ź" (U+0179)
  0x38, 0x16, 0xF6, 0x28, 0x12, 0xE6, 0x70, 0xBC, 0x85, 0x55, 0x77, 0xDF, 0x22, 0x81, 0x2F, 0x93,
  0x81, 0xAE, 0x12, 0x81, 0x3F, 0x83, 0x0C, 0x0E, 0x38, 0x14, 0xF6, 0x38, 0x4D, 0xF7, 0x77, 0x2D,
  0x05,
  // "ź" (U+017A)
  0x48, 0x16, 0xF6, 0x38, 0x12, 0xE6, 0x72, 0xD8, 0x64, 0x07, 0x78, 0xFE, 0x23, 0x81, 0xAF, 0x53,
  0x81, 0x6F, 0x83, 0x81, 0x3F, 0xC4, 0x85, 0xDF, 0x87, 0x73, 0x3D, 0x06,
  // "Ż" (U+017B)
  0x20, 0x14, 0x81, 0x5F, 0x83, 0x81, 0x4E, 0x77, 0x10, 0xBC, 0x85, 0x55, 0x77, 0xDF, 0x22, 0x81,
  0x2F, 0x93, 0x81, 0xAE, 0x12, 0x81, 0x3F, 0x83, 0x0C, 0x0E, 0x38, 0x14, 0xF6, 0x38, 0x4D, 0xF7,
  0x77, 0x2D, 0x05,
  // "ż" (U+017C)
  0x30, 0x15, 0x81, 0x5F, 0x84, 0x81, 0x4E, 0x77, 0x3D, 0x86, 0x40, 0x77, 0x8F, 0xE2, 0x38, 0x1A,
  0xF5, 0x38, 0x16, 0xF8, 0x38, 0x13, 0xFC, 0x48, 0x5D, 0xF8, 0x77, 0x33, 0xD0, 0x60,
  // "Ž" (U+017D)
  0x83, 0x5D, 0x3C, 0x82, 0x81, 0x9F, 0xC7, 0x10, 0xBC, 0x85, 0x55, 0x77, 0xDF, 0x22, 0x81, 0x2F,
  0x93, 0x81, 0xAE, 0x12, 0x81, 0x3F, 0x83, 0x0C, 0x0E, 0x38, 0x14, 0xF6, 0x38, 0x4D, 0xF7, 0x77,
  0x2D, 0x05,
  // "ž" (U+017E)
  0x18, 0x35, 0xD3, 0xC8, 0x38, 0x19, 0xFC, 0x73, 0xD8, 0x64, 0x07, 0x78, 0xFE, 0x23, 0x81, 0xAF,
  0x53, 0x81, 0x6F, 0x83, 0x81, 0x3F, 0xC4, 0x85, 0xDF, 0x87, 0x73, 0x3D, 0x06,
  // "ſ" (U+017F)
  0x89, 0x31, 0xBE, 0xE1, 0x7F, 0xA8, 0x09, 0xF2, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19,
  0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x20,
  // "Ω" (U+03A9)
  0x18, 0x33, 0xBE, 0xC4, 0x28, 0x96, 0xEE, 0x8C, 0xF2, 0x5F, 0x50, 0x2F, 0x87, 0xF2, 0x28, 0x3E,
  0xA7, 0xF1, 0x28, 0x3E, 0xA4, 0xF3, 0x29, 0x89, 0x67, 0x0D, 0x70, 0x5F, 0x25, 0xAE, 0x1D, 0xB7,
  0xCA, 0x01, 0x0E, 0xA0,
  // "μ" (U+03BC)
  0x8D, 0x16, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86, 0xF5, 0x03, 0xF8, 0x6F, 0x50, 0x3F, 0x86,
  0xF6, 0x05, 0xF8, 0x6F, 0xD7, 0xDF, 0x86, 0xA8, 0x5D, 0x5E, 0x86, 0xF5, 0x48, 0x16, 0xF5, 0x48,
  0x16, 0xF5, 0x40,
  // "π" (U+03C0)
  0x08, 0xE8, 0x61, 0x6D, 0xE7, 0xED, 0x72, 0x83, 0xBE, 0x0D, 0xC3, 0x83, 0xBE, 0x0D, 0xC3, 0x83,
  0xBE, 0x0D, 0xC3, 0x84, 0xBE, 0x0C, 0xE8, 0x28, 0x5B, 0xE0, 0x5E, 0xD1,
  // "–" (U+2013)
  0x84, 0x12, 0x22, 0x2C, 0xC0, 0x48, 0x00, 0x50,
  // "—" (U+2014)
  0x80, 0x32, 0x1F, 0x03, 0x80, 0x35, 0x01,
  // "€" (U+20AC)
  0x28, 0x97, 0x3B, 0xEE, 0x80, 0x2E, 0xD8, 0x86, 0x19, 0xF4, 0x22, 0x08, 0xC8, 0x90, 0x60, 0x3D,
  0xE7, 0x72, 0x08, 0xC8, 0x66, 0x02, 0xBF, 0x65, 0x22, 0x84, 0x3F, 0xD8, 0x85, 0x28, 0x34, 0xCE,
  0xE6,
  // "₿" (U+20BF)
  0x18, 0x16, 0x05, 0x38, 0x1C, 0x1A, 0x2B, 0x8A, 0x3E, 0x90, 0xFC, 0x7C, 0xF6, 0xF9, 0x04, 0xF7,
  0xF9, 0x28, 0xF4, 0xC8, 0xA2, 0xA0, 0xFB, 0x59, 0xF7, 0xF9, 0x02, 0xFA, 0xFC, 0x7B, 0xF7, 0xB0,
  0xE0, 0x92, 0x81, 0xC1, 0xA3, 0x81, 0x20, 0x22,
  // "‘" (U+2018)
  0x18, 0x6B, 0x91, 0xF6, 0x6F, 0x30,
  // "’" (U+2019)
  0x19, 0x84, 0xB2, 0xF6, 0x5E, 0x10,
  // "‚" (U+201A)
  0x89, 0x11, 0xF9, 0x3F, 0x56, 0xF1, 0x9C, 0x10,
  // "‛" (U+201B)
  0x87, 0x6F, 0x31, 0xF6, 0x0B, 0x90,
  // "“" (U+201C)
  0x18, 0x94, 0xB9, 0xB9, 0x1F, 0x8F, 0x66, 0xFA, 0xF3,
  // "”" (U+201D)
  0x89, 0x43, 0xFA, 0xF6, 0x6F, 0x8F, 0x19, 0xB9, 0xB1,
  // "„" (U+201E)
  0x8A, 0x51, 0xF9, 0x1F, 0x93, 0xF5, 0x3F, 0x56, 0xF1, 0x6F, 0x19, 0xC0, 0x9C, 0x10,
  // "‟" (U+201F)
  0x89, 0x56, 0xFA, 0xF3, 0x1F, 0x8F, 0x60, 0xB9, 0xB9,
  // "†" (U+2020)
  0x18, 0x13, 0xF4, 0x28, 0x93, 0x1F, 0x20, 0x44, 0xF4, 0x5C, 0xEF, 0xE9, 0x29, 0x49, 0x01, 0x28,
  0x11, 0xF2, 0x28, 0x11, 0xF3, 0x28, 0x12, 0xF3, 0x28, 0x13, 0xF4, 0x10,
  // "‡" (U+2021)
  0x18, 0x12, 0xF5, 0x39, 0x89, 0x23, 0x08, 0x8E, 0x89, 0xAA, 0xFB, 0xB2, 0x90, 0x32, 0x89, 0x41,
  0xF3, 0x08, 0x8E, 0x99, 0xAA, 0xEA, 0xB2, 0x90, 0x22, 0x81, 0x2F, 0x51,
  // "•" (U+2022)
  0x81, 0x7E, 0xA1, 0xB0, 0x2B, 0x82, 0x27, 0xEA, 0x10,
  // "…" (U+2026)
  0x18, 0xA2, 0x10, 0x10, 0x10, 0x5F, 0xEF, 0xEF, 0x84, 0xEB, 0xEB, 0xE7,
  // "‰" (U+2030)
  0x81, 0x5E, 0x54, 0x0F, 0xB4, 0x86, 0xB8, 0xC5, 0xC3, 0x08, 0xA0, 0xB0, 0x12, 0x81, 0x1F, 0x92,
  0x8B, 0x41, 0x01, 0x4E, 0xC4, 0xF9, 0x06, 0xBE, 0xBA, 0xE0, 0x6C, 0xEA, 0xBE, 0x01, 0xDA, 0x3E,
  0x70,
  // "‹" (U+2039)
  0x18, 0x75, 0xB1, 0x2E, 0x90, 0xDD, 0x28, 0x18, 0xF4, 0x28, 0x1A, 0xE1, 0x20, 0x31,
  // "›" (U+203A)
  0x10, 0x32, 0x81, 0x1E, 0xA2, 0x81, 0x4F, 0x82, 0x87, 0xDD, 0x09, 0xE2, 0x1B, 0x51,
  // "⁄" (U+2044)
  0x38, 0x11, 0xF3, 0x30, 0x70, 0xC4, 0x0D, 0x06, 0x38, 0x14, 0xF1, 0x30, 0x0A, 0x38, 0x11, 0xF3,
  0x30, 0x60, 0xD4, 0x0C, 0x07, 0x38, 0x13, 0xF1, 0x30,
  // "™" (U+2122)
  0x8C, 0x2C, 0xDB, 0xA9, 0x2E, 0x20, 0xD0, 0xBC, 0x8D, 0x30, 0xD0, 0xB8, 0xCA, 0x30, 0xD0, 0xB2,
  0x3A, 0x30, 0x50, 0x42, 0x04, 0x01,
  // "⅒" (U+2152)
  0x78, 0x11, 0xF3, 0x71, 0x81, 0x5E, 0x63, 0x07, 0x0C, 0x71, 0x82, 0x1B, 0xC6, 0x30, 0xD0, 0x67,
  0x30, 0xB0, 0x62, 0x81, 0x4F, 0x17, 0x30, 0xB0, 0x62, 0x8B, 0x2A, 0xA0, 0x5E, 0x60, 0xAE, 0xB1,
  0x0B, 0xED, 0x61, 0xF3, 0x1B, 0xC6, 0x5D, 0x1A, 0x85, 0x06, 0x0D, 0x38, 0x5B, 0x67, 0xA0, 0x6A,
  0x50, 0xC0, 0x73, 0x85, 0xB6, 0x5D, 0x1A, 0x84, 0x81, 0x3F, 0x12, 0x86, 0xBE, 0xD7, 0xAE, 0xC1,
  // "∂" (U+2202)
  0x20, 0xCA, 0x08, 0x38, 0xC5, 0x75, 0x9F, 0x40, 0x1C, 0xFC, 0xF7, 0x0B, 0xF5, 0x9F, 0x82, 0xF8,
  0x05, 0xF6, 0x5F, 0x50, 0xAF, 0x24, 0xF8, 0x5F, 0xA2, 0x0C, 0xA0, 0xB0, 0x13, 0x03, 0x02, 0x30,
  // "∆" (U+2206)
  0x28, 0x18, 0xFB, 0x50, 0xDA, 0x01, 0x38, 0x32, 0xFA, 0xF5, 0x38, 0x37, 0xF2, 0xEA, 0x38, 0x3C,
  0xC0, 0x9E, 0x28, 0x91, 0x1F, 0x70, 0x4F, 0x40, 0x6F, 0x32, 0x98, 0x91, 0x90, 0xBF, 0x88, 0x8D,
  0xE0, 0xDE, 0x01,
  // "√" (U+221A)
  0x58, 0x13, 0xF2, 0x50, 0x70, 0xD6, 0x0C, 0x09, 0x58, 0x41, 0xF4, 0x01, 0x22, 0x05, 0x0E, 0x28,
  0x49, 0xF7, 0x0A, 0xB2, 0x84, 0x3A, 0xC0, 0xE6, 0x38, 0x33, 0xF5, 0xF2, 0x40, 0xFD, 0x58, 0x18,
  0xF8, 0x58, 0x12, 0xF3, 0x30,
  // "∞" (U+221E)
  0x8B, 0x43, 0xEC, 0x2A, 0xE6, 0xB8, 0x8F, 0xA6, 0xEC, 0x65, 0xF8, 0x3E, 0x5F, 0xE6, 0xEF, 0x80,
  0x13, 0x01, 0x10,
  // "≈" (U+2248)
  0x89, 0x11, 0xCE, 0xA4, 0x45, 0x4B, 0x8D, 0xA8, 0x75, 0x12, 0x22, 0x65, 0x14, 0xD0, 0x70, 0x18,
  0x01, 0x50, 0x20,
  // "≠" (U+2260)
  0x40, 0x70, 0x22, 0x85, 0x11, 0x4F, 0x60, 0x2D, 0x89, 0x65, 0x04, 0x4F, 0xA4, 0x10, 0x14, 0xF5,
  0x10, 0x2D, 0x86, 0x50, 0x5E, 0xA4, 0x41, 0x20, 0x80, 0x23,
  // "≤" (U+2264)
  0x50, 0x30, 0x23, 0x89, 0x53, 0xAF, 0x30, 0x3A, 0xE9, 0x20, 0x6F, 0xB1, 0x38, 0x31, 0x8E, 0xD6,
  0x58, 0x26, 0xDE, 0x35, 0x81, 0x52, 0x7D, 0x04, 0x01, 0x80, 0x13, 0x10,
  // "≥" (U+2265)
  0x02, 0x03, 0x58, 0x23, 0xFA, 0x34, 0x83, 0x29, 0xEA, 0x34, 0x82, 0x1B, 0xF6, 0x28, 0x76, 0xDE,
  0x81, 0x3E, 0xD6, 0x30, 0x20, 0x55, 0x04, 0xD0, 0x71, 0x80, 0x13, 0x01,
};

const Font& font_NotoSansMono_Bold_12() {
  static SmoothFont font(font_NotoSansMono_Bold_12_data);
  return font;
}

}  // namespace roo_display
