[![Shellminator](extras/Assets/DocuImages/banner.png)](https://www.shellminator.org)

# 🚀 About  

**Shellminator** is an easy-to-use **terminal interface library** designed for **microcontroller environments**. Thanks to its **low resource usage**, it can run on almost any microcontroller. It’s **Arduino-compatible out of the box**, making it accessible for both hobbyists and beginner programmers.  

# 🔄 What's New?  

### 🌐 Wireless Device Support
We’re super proud of this one! It wasn’t easy, but we made it happen. Instead of relying on existing generic libraries (which weren’t flexible enough), we built our own **WebSocket and TCP support** for **ESP8266, ESP32, Raspberry Pi Pico W, and Arduino Uno R4 WiFi**.  
💡 **Bonus:** **Bluetooth Low Energy (BLE)** is now supported for **ESP32, Arduino Uno R4, and nRF52840 (Arduino Nano 33 BLE)** platforms!  

### 🖥 Built-in Web Server for WebSocket
If your device is **offline**, you can now **host the necessary web pages directly from the microcontroller**. No external server needed!  

### 📖 Better Documentation & More Examples
If we had to highlight **one** area where we put **tons of effort**, it’s the documentation. We knew it wasn’t great before—so we **fixed it**. Now, it’s **interactive, example-rich, and beginner-friendly**. Hope you like it! 😊  

### 🖼 GUI (Because Why Not?)
Totally unnecessary, but **super cool**! You don’t **have to** use it, but now you **can** create **progress bars, buttons, selection lists, plots, level meters, and even notifications**! 🎨  

### 🔐 Password Protection  
With wireless support, **security became a must**. Now, you can **password-protect your terminal** and keep unwanted fingers away.  

### 🖼 Neofetch Support
A real developer’s **terminal isn’t complete without Neofetch!** We provide a built-in solution, but feel free to **customize** it. We can't wait to see your **awesome ASCII art** in the **Show & Tell section**! 🎨  

### 🚀 Enhanced Commander-API Integration 
With Commander-API evolving, we needed to step up our game. Now, Shellminator plays even better with Commander-API!  

### 🎨 Prompt Colorizer & Syntax Highlighting
Now you can **create your own syntax highlighter** or use ours, which is **fully compatible with the new Commander-API argument parser**.  

### 📦 Abstraction Layers 
Shellminator reached a critical size where **better abstraction** was needed. This change made the **GUI possible** and keeps the project **scalable**.  

### 🛠 Major Refactoring
We know **"refactoring"** isn't what you want to hear when it comes to **backward compatibility**, but trust us, it was worth it.  
- **Buffering system reworked**  
- **Memory issues in formatting commands fixed**  
- **Performance & scalability improvements**  

# 📚 Documentation  

The **Shellminator documentation** is packed with **examples** and covers how to use it alongside **Commander-API**.  

💡 **Tip:** If you're new to Shellminator, go through the examples **in order**—they build on each other.  

🎮 **Interactive Demos:** Every example comes with a browser-based interactive demo, so you can **test things out instantly**! No setup needed.  

We hope you like it! 😊  

# 🤝 Feedback and Contributions  

We've poured **a lot of time and effort** into making this project **stable and easy to use**, but no software is perfect. Bugs happen. Features can improve. And that’s where you come in!  

If you have **feature suggestions, bug reports, or ideas for enhancements**, we’d love to hear from you. Your feedback makes Commander-API better for everyone!  

**Ways to contribute:**  
- 🐛 [Submit an issue](https://github.com/dani007200964/Shellminator/issues/new?template=bug_report.md) 
- 💬 [Join discussions](https://github.com/dani007200964/Shellminator/discussions)
- 🛠 [Share your use cases](https://github.com/dani007200964/Shellminator/discussions/categories/show-and-tell) 

Every contribution, big or small, helps us grow!  

# ❤️ Support  

If this project has been helpful to you and you’d like to **buy us a coffee**, we’d really appreciate it! ☕ Every little bit helps keep this small team motivated.
[![Support](extras/Assets/DocuImages/support.png)](https://ko-fi.com/danielhajnal)

# 🌐 Useful Links  

- [Discussions](https://github.com/dani007200964/Shellminator/discussions) – Join the conversation and share your ideas!  
- [Technical Documentation](https://www.shellminator.org/html/index.html) – Deep dive into Shellminator.  
- [Commander-API](https://www.commanderapi.org/html/index.html) – Companion project with additional resources.  
- [Discord](https://discord.gg/GhMGqhBS) – Come chat with us!  

# 🗨️ Contact  

Have a question? Need help? Just want to say hi?  
- 🗨️ [Join the discussions](https://github.com/dani007200964/Shellminator/discussions)
- 🎧 [Find us on Discord](https://discord.gg/GhMGqhBS)

We’d love to hear from you! 🚀

# 📃 License  

Shellminator is licensed under the **MIT License**.

© Daniel Hajnal

✉️ hajnal.daniel96@gmail.com