/* ===========================================================================

 Crystalfontz packet communications types/structures/definitions.

 https://www.crystalfontz.com/c/usb-lcds/1
 
 Mark Williams (2025)

 Distributed under the "The Unlicense".
 http://unlicense.org
 This is free and unencumbered software released into the public domain.
 For more details, see the website above.

=========================================================================== */

// Crystalfontz America Inc (Mark Williams)
#ifndef CFPKT_COMMANDS_H_
#define CFPKT_COMMANDS_H_

#define CFAALL

///////////////////////////////////////////////////////////////////////
//UNIVERSAL (CFTEST/CC2/FWARES)

//debugging use: set PACKET_EXT_LENGTH for packet length range testing
#ifndef PACKET_EXT_LENGTH
# define PACKET_EXT_LENGTH 0
#else
# warning PACKET_EXT_LENGTH is defined!!
#endif

#define PACKET_HEADER_SIZE          4 /*command,length,crc,data*/

#define PACKET_CFA533_DATA_SIZE			(22 +PACKET_EXT_LENGTH)
#define PACKET_CFA631_DATA_SIZE			(22 +PACKET_EXT_LENGTH)
#define PACKET_CFA633_DATA_SIZE			(22 +PACKET_EXT_LENGTH)
#define PACKET_CFA635_DATA_SIZE			(22 +PACKET_EXT_LENGTH)
#define PACKET_CFA735_DATA_SIZE			(124 +PACKET_EXT_LENGTH)
#define PACKET_CFA835_DATA_SIZE			(124 +PACKET_EXT_LENGTH)
#define PACKET_CFA039_DATA_SIZE			(124 +PACKET_EXT_LENGTH)

#if defined(CFA735)
# define PACKET_MAX_DATA_SIZE			PACKET_CFA735_DATA_SIZE
#endif
#if defined(CFA835)
# define PACKET_MAX_DATA_SIZE			PACKET_CFA835_DATA_SIZE
#endif
#if defined(CFA039)
# define PACKET_MAX_DATA_SIZE			PACKET_CFA039_DATA_SIZE
#endif
#ifndef PACKET_MAX_DATA_SIZE
#define PACKET_MAX_DATA_SIZE			(124)
#endif

#define PACKET_MAX_SIZE(d)				(PACKET_HEADER_SIZE+(d))

///////////////////////////////////////////////////////////////////////
// CFA533 through to CFA735 commands

#if defined(CFAALL) || defined(CFA533) || defined(CFA631) || defined(CFA633) || defined(CFA635) || defined(CFA735)
typedef enum
{
	PCMD1_INDEX_START							= 0,

	PCMD1_PING									= 0,
	PCMD1_GET_VER								= 1,
	PCMD1_WRITE_USER_FLASH						= 2,
	PCMD1_READ_USER_FLASH						= 3,
	PCMD1_STORE_BOOT_STATE						= 4,
	PCMD1_REBOOT								= 5,
	PCMD1_CLEAR_LCD								= 6,
#if defined(CFAALL) || defined(CFA633) || defined(CFA533)
	PCMD1_PRINT_LINE1							= 7,
	PCMD1_PRINT_LINE2							= 8,
#endif
	PCMD1_SET_LCD_SPECIAL_CHAR_DATA				= 9,
	PCMD1_READ_8_BYTES_LCD_MEMORY				= 10,
	PCMD1_SET_LCD_CURSOR_POSITION				= 11,
	PCMD1_SET_LCD_CURSOR_STYLE					= 12,
	PCMD1_SET_LCD_CONTRAST						= 13,
	PCMD1_SET_LCD_AND_KEYPAD_BACKLIGHT			= 14,
	PCMD1_READ_FBSCAB_INFORMATION				= 15,
	PCMD1_SET_FAN_REPORTING						= 16,
	PCMD1_SET_FAN_POWER							= 17,
	PCMD1_READ_DOW_DEVICE_INFORMATION			= 18,
	PCMD1_SET_TEMPERATURE_REPORTING				= 19,
#if defined(CFAALL) || defined(CFA533) || defined(CFA635) || defined(CFA633)
	PCMD1_ARBITRARY_DOW_TRANSACTION				= 20,
#endif
#if defined(CFAALL) || defined(CFA635) || defined(CFA533)
	PCMD1_LIVE_DATA_DISPLAY						= 21,
#endif
	PCMD1_SEND_COMMAND_TO_CFACONTROLLER			= 22,
	PCMD1_SET_KEY_REPORTING						= 23,
	PCMD1_READ_KEYPAD_STATE						= 24,
	PCMD1_SET_FAN_POWER_FAIL_SAFE				= 25,
	PCMD1_FAN_TACH_GLITCH_FILTER				= 26,
	PCMD1_READ_FAN_POWER_FAIL_SAFE_MASK			= 27,
	PCMD1_SET_ATX_POWER_SWITCH_FUNCTIONALITY	= 28,
	PCMD1_ENABLE_DISABLE_RESET_WATCHDOG			= 29,
	PCMD1_READ_REPORTING_AND_STATUS				= 30,
	PCMD1_LCD_PRINT								= 31,
#if defined(CFAALL) || defined(CFA631)
	PCMD1_KEY_LEGENDS							= 32,
#endif
	PCMD1_CONFIGURE_INTERFACE					= 33,
	PCMD1_CONFIGURE_GPIO_PIN					= 34,
	PCMD1_READ_GPIO_PIN_AND_CONFIGURATION		= 35,

	PCMD1_INDEX_END
} PacketCommands_t;
#endif

///////////////////////////////////////////////////////////////////////
// CFA835 commands

#if defined(CFAALL) || defined(CFA835) || defined(CFA039)
typedef enum
{
	PCMD2_INDEX_START							= 0,
	PCMD3_INDEX_START							= 0,
	//
	PCMD2_PING									= 0,
	PCMD2_GET_VER								= 1,
	PCMD2_WRITE_USER_FLASH						= 2,
	PCMD2_READ_USER_FLASH						= 3,
	PCMD2_STORE_BOOT_STATE						= 4,
	PCMD2_REBOOT								= 5,
	PCMD2_CLEAR_LCD								= 6,
	PCMD2_SET_LCD_SPECIAL_CHAR_DATA				= 9,
	PCMD2_LCD_CURSOR_POSITION					= 11,
	PCMD2_LCD_CURSOR_STYLE						= 12,
	PCMD2_LCD_CONTRAST							= 13,
	PCMD2_LCD_AND_KEYPAD_BACKLIGHT				= 14,
	PCMD2_LIVE_DATA_DISPLAY						= 21,

	PCMD2_KEY_REPORTING							= 23,
	PCMD2_READ_KEYPAD_STATE						= 24,
#if defined(CFAALL)	|| defined(CFA039)
	PCMD3_TOUCH_REPORTING						= 25,
	//PCMD3_READ_TOUCH_STATE					= 26, //NOT USED
#endif
	PCMD2_ATX_POWER_CONTROL						= 28,
	PCMD2_RESET_WATCHDOG						= 29,
	PCMD2_LCD_WRITE								= 31,
	PCMD2_LCD_READ								= 32,
	PCMD2_CONFIGURE_INTERFACE					= 33,
	PCMD2_GPIO_PIN								= 34,
	PCMD2_INTERFACE_BRIDGE						= 36,
	PCMD2_FBSCAB_PORTAL							= 37, //keep
	PCMD2_FONT_PORTAL							= 38, //keep, maybe implement later on 835 layer
	PCMD2_FILE_PORTAL							= 39, //keep
	PCMD2_GFX_PORTAL							= 40, //keep
#if defined(CFAALL)	|| defined(CFA039)
	PCMD3_GFX_PORTAL							= 40, //new/moved
#endif
	PCMD2_VIDEO_PORTAL							= 41, //keep
#if defined(CFAALL)	|| defined(CFA039)
	PCMD3_VIDEO_PORTAL							= 41,
	PCMD3_IMAGE_PORTAL							= 42,
	PCMD3_TTFONT_PORTAL							= 43,
	PCMD3_SKETCH_PORTAL							= 44,
	//leave at 47 (gap from 42-47 for future additions)
	PCMD3_BUTTON_PORTAL							= 47,
	PCMD3_SLIDER_PORTAL							= 48,
	PCMD3_NUMEDIT_PORTAL						= 49,
	PCMD3_CHECKBOX_PORTAL						= 50,
	PCMD3_PROGRESSBAR_PORTAL					= 51,
	PCMD3_HISTOGRAM_PORTAL						= 52,
#endif

	PCMD2_DEBUG									= 0x3E, /* 62 = highest command number */
	//
	PCMD2_INDEX_END,
	PCMD3_INDEX_END = PCMD2_INDEX_END
} PacketCommands2_t;

#if defined(CFAALL)	|| defined(CFA039)
typedef enum
{
	SCMD3_GFX_OPTIONS				= 0,
	SCMD3_GFX_BUFFERFLUSH			= 1,
	SCMD3_GFX_BACKGROUNDCOLOR		= 2,
	//gap for later additions
	SCMD3_GFX_OBJ_REMOVE			= 10,
	SCMD3_GFX_OBJ_LOCATION			= 11,
	SCMD3_GFX_OBJ_TOUCHREPORTING	= 12,
	SCMD3_GFX_OBJ_ZINDEX			= 13,
	//SCMD3_GFX_OBJ_MANY ?? 14
	SCMD3_GFX_OBJ_FONTSLOT			= 15,
	SCMD3_GFX_OBJ_FONTSIZE			= 16,
	SCMD3_GFX_OBJ_CORNERRADIUS		= 17,
	SCMD3_GFX_OBJ_OPACITY			= 18,
	SCMD3_GFX_OBJ_FILLACOLOR		= 19,
	SCMD3_GFX_OBJ_BORDERACOLOR		= 20,
	SCMD3_GFX_OBJ_CONTROLACOLOR		= 21,
	SCMD3_GFX_OBJ_TEXTACOLOR		= 22,
	SCMD3_GFX_OBJ_FILLBCOLOR		= 23,
	SCMD3_GFX_OBJ_BORDERBCOLOR		= 24,
	SCMD3_GFX_OBJ_CONTROLBCOLOR		= 25,
	SCMD3_GFX_OBJ_TEXTBCOLOR		= 26,
	SCMD3_GFX_OBJ_FILLCCOLOR		= 27,
	SCMD3_GFX_OBJ_BORDERCCOLOR		= 28,
	SCMD3_GFX_OBJ_CONTROLCCOLOR		= 29,
	SCMD3_GFX_OBJ_TEXTCCOLOR		= 30,
} SubCommand3_GFXCore_t;

typedef enum
{
	SCMD3_TTFONT_LOAD		= 0,
	SCMD3_TTFONT_UNLOAD		= 1,
	SCMD3_TTFONT_NEWTEXT	= 2,
	SCMD3_TTFONT_SETTEXT	= 3,
} SubCommand3_TTFont_t;

typedef enum
{
	SCMD3_SKETCH_NEW	= 0,
	SCMD3_SKETCH_LINE	= 1,
	SCMD3_SKETCH_RECT	= 2,
	SCMD3_SKETCH_CIRCLE	= 3,
	SCMD3_SKETCH_PIXEL	= 4,
} SubCommand3_Sketch_t;

typedef enum
{
	SCMD3_VIDEO_LOAD		= 0,
	SCMD3_VIDEO_CONTROL		= 1,
} SubCommand3_Video_t;

typedef enum
{
	SCMD3_IMAGE_LOAD			= 0,
	SCMD3_IMAGE_LOADDOWN		= 1,
	SCMD3_IMAGE_LOADDISABLED	= 2,
	SCMD3_IMAGE_FROMHOST		= 3,
	SCMD3_IMAGE_BUTTONSTATE		= 4,
} SubCommand3_Image_t;

typedef enum
{
	SCMD3_BUTTON_NEW		= 0,
	SCMD3_BUTTON_UP			= 1,
	SCMD3_BUTTON_DOWN		= 2,
	SCMD3_BUTTON_DISABLED	= 3,
	SCMD3_BUTTON_STATE		= 4,
} SubCommand3_Button_t;

typedef enum
{
	SCMD3_SLIDER_NEW		= 0,
	SCMD3_SLIDER_VALUE		= 1,
} SubCommand3_Slider_t;

typedef enum
{
	SCMD3_NUMEDIT_NEW		= 0,
	SCMD3_NUMEDIT_VALUE		= 1,
} SubCommand3_NumEdit_t;

typedef enum
{
	SCMD3_CHECKBOX_NEW		= 0,
	SCMD3_CHECKBOX_VALUE	= 1,
} SubCommand3_Checkbox_t;

typedef enum
{
	SCMD3_PROGRESSBAR_NEW		= 0,
	SCMD3_PROGRESSBAR_VALUE	= 1,
} SubCommand3_ProgressBar_t;

#endif

typedef enum
{
	SCMD_FBSCAB_QUERY			= 0,
	SCMD_FBSCAB_FAN				= 1,
	SCMD_FBSCAB_FAN_RPM			= 2,
	SCMD_FBSCAB_DOW_QUERY		= 3,
	SCMD_FBSCAB_TEMP_VALUE		= 4,
	SCMD_FBSCAB_GPIO			= 5,
	SCMD_FBSCAB_RESET			= 6,
	SCMD_FBSCAB_LIVE_DISPLAY	= 7,
	SCMD_FBSCAB_AUTO_FAN_CONT	= 8
} SubCommand_FBSCAB_t;

typedef enum
{
	SCMD_FONT_LOAD		= 0,
	SCMD_FONT_PRINT		= 1
} SubCommand_Font_t;

typedef enum
{
	SCMD_FILE_FILE		= 0,
	SCMD_FILE_SEEK		= 1,
	SCMD_FILE_READ		= 2,
	SCMD_FILE_WRITE		= 3,
	SCMD_FILE_DELETE	= 4,
	SCMD_FILE_COPY		= 5,
	SCMD_FILE_FORMATFS	= 6,
	SCMD_FILE_SIZESTATS	= 7, //also ram/heap
	//add copy & move
} SubCommand_File_t;

typedef enum
{
	SCMD_GFX_OPTIONS		= 0,
	SCMD_GFX_FLUSH			= 1,
	SCMD_GFX_SEND_IMG		= 2,
	SCMD_GFX_LOAD_IMG		= 3,
	SCMD_GFX_SCREENSHOT		= 4,
	SCMD_GFX_PIXEL			= 5,
	SCMD_GFX_LINE			= 6,
	SCMD_GFX_RECT			= 7,
	SCMD_GFX_CIRC			= 8,
	SCMD_GFX_RRECT			= 9,
	SCMD_GFX_CRAW_LOAD		= 10,
	SCMD_GFX_CRAW_DISPLAY	= 11,

#ifdef LCD_DEBUG_FULL_LCD_WRITE
	SCMD_GFX_TIMG		= 0xF0
#endif
} SubCommand_GFX_t;

typedef enum
{
	SCMD_VIDEO_LOAD		= 0,
	SCMD_VIDEO_CONTROL	= 1
} SubCommand_Video_t;

#endif

///////////////////////////////////////////////////////////////////////
// Common

typedef enum
{
	PCMD_REPLY									= 0x40,
	PCMD_REPORT									= 0x80,
	PCMD_ERROR									= 0xC0
} PacketTypes_t;

typedef enum
{
	PRPT_INDEX_START							= PCMD_REPORT,
	PRPT_KEY									= PCMD_REPORT + 0,
	PRPT_FAN									= PCMD_REPORT + 1,
	PRPT_TEMP									= PCMD_REPORT + 2,
#if defined(CFAALL)	|| defined(CFA039)
	PRPT_TOUCH									= PCMD_REPORT + 3,
	PRPT_OBJTOUCH								= PCMD_REPORT + 4,
	PRPT_IMAGE									= PCMD_REPORT + 5,
	PRPT_BUTTON									= PCMD_REPORT + 6,
	PRPT_SLIDER									= PCMD_REPORT + 7,
	PRPT_NUMEDIT								= PCMD_REPORT + 8,
	PRPT_CHECKBOX								= PCMD_REPORT + 9,
#endif
#if defined(CFAALL) || defined(CFA835) || defined(CFA039)
	PRPT_DEBUG									= PCMD_REPORT + PCMD2_DEBUG,
#endif
	PRPT_INDEX_END
} PacketReports_t;

///////////////////////////////////////////////////////////////////////////////

#endif
