# Arduino CFA039A0-N-V Library

This library provides an easy to use interface for the CFA039A0-N-V modules SPI/I2C packet based communications interface, and command system.

This library has been tested with the Seeeduino v4.2 development board and the Arduino Uno.  
It may also be used with other development boards with minor modifications.

See "CFA039A0-N-V.h" for library configuration.

See the library examples for usage information.

[https://www.crystalfontz.com/product/cfa039a0nvdct-480x128-graphic-usb-tft-display-module](https://www.crystalfontz.com/product/cfa039a0nvdct-480x128-graphic-usb-tft-display-module)

## Connections Guide

**NOTE:** The I2C and SPI interfaces on the CFA039A0-N-V modules are not enabled by default. They must be enabled via the "Interface Options" command on the USB or Serial interface before they can be used. We suggest doing this using the [Crystalfontz cfTest software](https://www.crystalfontz.com/product/cfautilities-cfa-lcd-utilities).

The default I2C and SPI Arduino to CFA039A0-N-V connection configurations are listed below.

### Default I2C Interface Connections
| Description | Arduino Uno / Seeeduino | CFA039A0-N-V Header-1 |
| --- | --- | --- |
| I2C Clock | SCL | Pin 4 |
| I2C Data | SDA | Pin 3 |
| Data Ready | Pin 9 | Pin 13 |
| 5V Power | 5V | Pin 16 |
| Ground | GND | Pin 15 |

### Default SPI Interface Connections
| Description | Arduino Uno / Seeeduino | CFA039A0-N-V Header-1 |
| --- | --- | --- |
| SPI MOSI | Pin 11 | Pin 8 |
| SPI MISO | Pin 12 | Pin 7 |
| SPI Clock | Pin 13 | Pin 10 |
| SPI Slave Select | Pin 10 | Pin 9 |
| Data Ready | Pin 9 | Pin 12 |
| 5V Power | 5V | Pin 16 |
| Ground | GND | Pin 15 |

