# ESPNowAdhoc Library

A package library that enables simple and secure construction of an ad-hoc network environment using ESP_NOW. It packages the necessary functions for using it as an ad-hoc network: group settings, role settings, security settings, automatic peer pairing via broadcasting, and status monitoring of connected peers via heartbeat. With just three steps, you can easily implement an ad-hoc network environment using only ESP32. This makes wireless communication in ESP32 environments—previously expensive and complex—simple and affordable.

## Features

- **No Complex Development Required** - Easy construction of ad-hoc networks without using complex ESP_NOW library classes
- **UUID Group Management** - Separation of group UUID for connection advertisement packets and unicast communication, providing strong protection against interference
- **Configurable Roles** - Server and client can be set with one parameter, enabling various ad-hoc network configurations
- **Bidirectional Communication** - Possible without complex coding
- **Auto-pairing for Multiple Devices** - Up to 20 peers without encryption (according to ESP_NOW specifications)
- **One Source, Multiple Uses** - Both client and server configurable by simply changing parameters
- **Simple Encrypted Communication** - Easy security settings
- **Peer Status Display** - Function to display the status of connected peers
- **Configurable Data Area** - Enabling memory optimization
- **High Security** - Independent group UUID for unicast communication prevents exposure even under encryption
- **Heartbeat Monitoring** - Status monitoring of connected peers with automatic reconnection
- **Built-in Wi-Fi** - Uses ESP32's built-in Wi-Fi, no additional modules needed
- **Large Packet Support** - Up to 1470 bytes in ESP_NOW V2 environments (verify via serial at startup)

## Application Examples

- Remote control systems
- Low-cost remote control systems requiring bidirectional communication
- Remote control systems controllable from multiple locations
- Autonomous group drone/robot management (no Wi-Fi AP needed)
- Autonomous outdoor sensor networks (no Wi-Fi AP needed)
- Autonomous disaster relief systems (no Wi-Fi AP needed)

## ESPNowAdhoc Payload Specifications

- **Group UUID** - char, 37 bytes
- **Role** (server/client) - bool, 1 byte
- **Wi-Fi Channel** - int (reserved for future automatic channel change)
- **Security Mode** - bool, 1 byte
- **Command** (register, heartbeat, data) - int
- **Actual Data** - Configurable, must not exceed ESP_NOW's maximum transmission size

## Optional Configurable Parameters

- Broadcast interval setting
- Heartbeat transmission interval setting
- Heartbeat timeout setting
- Actual data size setting
- Debug mode setting (for checking peer registration and heartbeat status)

## Compatible Models & Usage Notes

### Supported Devices:
- **ESP32-S series**: ESP32-S2, ESP32-S3, etc.
- **ESP32-C series**: ESP32-C3, etc.
- **M5Stack series**: All ESP32 microcontroller-equipped models

### Important Notes:
- Clients do not peer with each other → at least one device must be set as server
- For ESP_NOW v2 compatible environments
- Inquiries accepted via GitHub

## Installation

### STEP 1: Library Installation

#### Arduino IDE
1. **Sketch** → **Include Library** → **Manage Libraries...**
2. Search for "ESPNowAdhoc"
3. Click **Install**

#### Manual Installation
1. Download ZIP from [Releases](https://github.com/yourusername/ESPNowAdhoc/releases)
2. **Sketch** → **Include Library** → **Add .ZIP Library...**

### STEP 2: Initial Setup

```cpp
// Required Group UUIDs
```
#define ADV_GROUP_ID "906b868f-7e9b-4c21-b587-70c8d5fadfee"
#define GROUP_ID "73f8e3bb-aab2-4808-8efe-c061c88e48c2"
```
// Security Settings (Required)
```
#define SECURITY true
#define PMK_STRING "hogehoge54321" // Public key (max 16 chars, required if SECURITY=true)
#define LMK_STRING "hogehoge12345" // Private key (max 16 chars, required if SECURITY=true)
```
// Role Setting (Required)
```
#define ROLE true  // true: Server, false: Client
```
## STEP3 コーディング・リリース
Refer to the sample file for coding and uploading.
In the void setup() section:
espnow.begin() - ESP_NOW initialization
espnow.setDataCallback() - Callback (required if data reception from peers is needed)
In the void loop() section:
espnow.update() - Heartbeat transmission, reception, and status log monitoring
Refer to the sample program.
