# ESPNowAdhoc Library
ESP_NOWを利用したアドホックネットワーク環境を簡単に安全に構築できるパッケージライブラリ。アドホックネットワークとして利用するのに必要な、グループ設定、ロール設定、セキュリティー設定、ブロードキャストによる自動ピアリング、ハートビートによる接続済みピアの状態監視を、パッケージ化。３ステップで、簡単にアドホックネットワーク環境をESP32だけで実現。これまで高額で、複雑だった、ESP32環境での無線通信を簡単に低価格で実現可能。

## 特徴
- 複雑なESP_NOWライブラリクラスを利用した開発不要で、アドホックネットワークが簡単に構築可能
- UUIDグループ管理（接続のためのアドバタイジングパケットのグループUUIDと、ユニキャスト通信のグループUUIDを分離し、他のESP_NOWとの混信を強力に防御）
- ロール設定可能（サーバー、クライアントを１パラメーターで設定可能。様々なアドホックネットワーク形態を簡単に構築可能）
- 複雑なコーディング不要で、双方向通信可能
- 複雑なコーディング不要で、複数台オートピアリング（ESP_NOWの仕様で暗号化なし時、最大20ピアまで）
- クライアント、サーバーも、パラメーター変更するだけのワンソースマルチユース
- 簡単な暗号化通信設定
- 接続ピア状態を表示するファンクション
- 実データ領域の設定が可能（必要メモリーの最適化が可能）
- 高セキュリテイー（ユニキャスト通信時、グループUUIDを独立しているので暗号化通信下でのグループ UUID露出なし）
- ハートビートによる状態監視（ハートビートで接続ピアの状態監視。接続が切れた場合も、相手がが復旧すれば自動接続。）
- ESP32内蔵Wi-Fi機能を利用しているので、別途通信モジュールが不要
- ESP_NOW V2の環境の場合1470byteまで送信可能(1470byteまで送信可能かどうかは、起動時にシリアルで確認してください)

## 応用例
- リモコンシステム
- 双方向通信を必要とする、低価格なリモートコントロールシステム
- 双方向通信を必要とする、複数箇所でコントロールできるリモートコントロールシステム
- 自動接続・Wi-FI AP不要を活かした自立型集団ドローン・ロボット管理
- 自動接続・Wi-FI AP不要を活かした野外での自立型センサーネットワーク
- 自動接続・Wi-FI AP不要を活かした自立型災害救援システム

## ESPNowAdhocペイロード（送信パケット）仕様
- グループUUID（char 37 Bytes）
- ロール（サーバー、クライアント）（bool 1 byte）
- Wi-Fiチャンネル（将来自動チャンネル変更機能実装のために保留）（int）
- セキュリテイーモードの有無（bool 1 byte）
- コマンド（レジスト、ハートビート、データ）（int）
- 実データ(可変設定可能、ただしESP_NOWの最大送信送信バイトを超えないこと)

## オプションで設定可能なパラメータ
- ブロードキャスト間隔設定
- ハートビート送信間隔設定
- ハートビートタイムアウト設定
- 実データのデータサイズ設定
- ピア登録、ハートビート状態を確認できるデバックモード設定

## 対応機種・利用に際して
- ESP_NOWが利用できる環境
-- ESP32-Sシリーズ: ESP32-S2、ESP32-S3なども対応。
-- ESP32-Cシリーズ: ESP32-C3なども対応。
-- M5Stackシリーズ: ESP32マイコン搭載のため、ESP-NOWが利用可能。 
- クラアント同士はピアリングしないため、最低１台サーバーロール設定の機器が必要
- ESP_NOW v2が利用できる環境の場合、
- 本ライブラリ利用に関するお問い合わせは、　GITにて受け付け

##導入方法

## STEP1 ライブラリインストール

### Arduino IDE
1. Sketch → Include Library → Manage Libraries...
2. "ESPNowAdhoc"を検索
3. インストールをクリック

### 手動インストール
1. [Releases](https://github.com/yourusername/ESPNowAdhoc/releases)からZIPをダウンロード
2. Arduino IDE: Sketch → Include Library → Add .ZIP Library...

## STEP2 初期設定
ブロードキャストと、ユニキャスト用のグループUUID（必須）
```
#define ADV_GROUP_ID "906b868f-7e9b-4c21-b587-70c8d5fadfee"
#define GROUP_ID "73f8e3bb-aab2-4808-8efe-c061c88e48c2"
```
暗号化通信の有無の設定（必須）と、暗号化の場合に必要な公開鍵、秘密鍵を設定
```
#define SECURITY true//（必須）
#define PMK_STRING "hogehoge54321"//公開鍵16文字以内（セキュリティーモードの場合は必須）
#define LMK_STRING "hogehoge12345"//秘密鍵16文字以内（セキュリティーモードの場合は必須）
```
ロールの設定
```
#define ROLE true// ロール設定 (true: サーバー, false: クライアント)（必須）
```
## STEP3 コーディング・リリース
サンプルファイルを参照してコーディング・書き込み
void setup()セクションに、
espnow.begin()　ESP_NOW初期化
espnow.setDataCallback()　コールバック（ピア相手からのデータ受信が必要な場合）
void loop()セクションに、
espnow.update()　ハートビート送信、受信、状態記録監視
が必要。サンプルプログラムを参照。



