/*===============================================================================================*/
/*         >>> Copyright (C) Telit Communications S.p.A. Italy All Rights Reserved. <<<          */
/*!
  @file
    TLTRootCerts.h

  @brief
   TLT Root Certs struct
  @details
    
  
  @version 
    1.1.0

  @note
    Dependencies:
    stddef.h
    stdint.h

  @author
    Cristina Desogus

  @date
    08/03/2021
*/
#ifndef __TLTROOTCERTS__H
#define __TLTROOTCERTS__H
/* Include files ================================================================================*/
#include <stddef.h>
#include <stdint.h>

/* Using namespace ================================================================================*/
//using namespace std;
//using namespace me310;

/* Class definition ================================================================================*/

struct TLTRootCert {
  const char* name;
  const uint8_t* data;
  const int size;
  const int dataType;
};

static const TLTRootCert TLT_ROOT_CERTS[] = {
  {
    "http_bin",
    (const uint8_t[]){
      0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
      0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0d, 0x0a, 0x4d, 0x49, 0x49,
      0x45, 0x44, 0x7a, 0x43, 0x43, 0x41, 0x76, 0x65, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49,
      0x42, 0x41, 0x44, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30,
      0x42, 0x41, 0x51, 0x55, 0x46, 0x41, 0x44, 0x42, 0x6f, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59,
      0x44, 0x56, 0x51, 0x51, 0x47, 0x45, 0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x6c, 0x0d, 0x0a, 0x4d,
      0x43, 0x4d, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x68, 0x4d, 0x63, 0x55, 0x33, 0x52, 0x68, 0x63,
      0x6d, 0x5a, 0x70, 0x5a, 0x57, 0x78, 0x6b, 0x49, 0x46, 0x52, 0x6c, 0x59, 0x32, 0x68, 0x75, 0x62,
      0x32, 0x78, 0x76, 0x5a, 0x32, 0x6c, 0x6c, 0x63, 0x79, 0x77, 0x67, 0x53, 0x57, 0x35, 0x6a, 0x4c,
      0x6a, 0x45, 0x79, 0x4d, 0x44, 0x41, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x78, 0x4d, 0x70, 0x0d,
      0x0a, 0x55, 0x33, 0x52, 0x68, 0x63, 0x6d, 0x5a, 0x70, 0x5a, 0x57, 0x78, 0x6b, 0x49, 0x45, 0x4e,
      0x73, 0x59, 0x58, 0x4e, 0x7a, 0x49, 0x44, 0x49, 0x67, 0x51, 0x32, 0x56, 0x79, 0x64, 0x47, 0x6c,
      0x6d, 0x61, 0x57, 0x4e, 0x68, 0x64, 0x47, 0x6c, 0x76, 0x62, 0x69, 0x42, 0x42, 0x64, 0x58, 0x52,
      0x6f, 0x62, 0x33, 0x4a, 0x70, 0x64, 0x48, 0x6b, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x44, 0x51,
      0x77, 0x0d, 0x0a, 0x4e, 0x6a, 0x49, 0x35, 0x4d, 0x54, 0x63, 0x7a, 0x4f, 0x54, 0x45, 0x32, 0x57,
      0x68, 0x63, 0x4e, 0x4d, 0x7a, 0x51, 0x77, 0x4e, 0x6a, 0x49, 0x35, 0x4d, 0x54, 0x63, 0x7a, 0x4f,
      0x54, 0x45, 0x32, 0x57, 0x6a, 0x42, 0x6f, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56,
      0x51, 0x51, 0x47, 0x45, 0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x6c, 0x4d, 0x43, 0x4d, 0x47, 0x41,
      0x31, 0x55, 0x45, 0x0d, 0x0a, 0x43, 0x68, 0x4d, 0x63, 0x55, 0x33, 0x52, 0x68, 0x63, 0x6d, 0x5a,
      0x70, 0x5a, 0x57, 0x78, 0x6b, 0x49, 0x46, 0x52, 0x6c, 0x59, 0x32, 0x68, 0x75, 0x62, 0x32, 0x78,
      0x76, 0x5a, 0x32, 0x6c, 0x6c, 0x63, 0x79, 0x77, 0x67, 0x53, 0x57, 0x35, 0x6a, 0x4c, 0x6a, 0x45,
      0x79, 0x4d, 0x44, 0x41, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x78, 0x4d, 0x70, 0x55, 0x33, 0x52,
      0x68, 0x63, 0x6d, 0x5a, 0x70, 0x0d, 0x0a, 0x5a, 0x57, 0x78, 0x6b, 0x49, 0x45, 0x4e, 0x73, 0x59,
      0x58, 0x4e, 0x7a, 0x49, 0x44, 0x49, 0x67, 0x51, 0x32, 0x56, 0x79, 0x64, 0x47, 0x6c, 0x6d, 0x61,
      0x57, 0x4e, 0x68, 0x64, 0x47, 0x6c, 0x76, 0x62, 0x69, 0x42, 0x42, 0x64, 0x58, 0x52, 0x6f, 0x62,
      0x33, 0x4a, 0x70, 0x64, 0x48, 0x6b, 0x77, 0x67, 0x67, 0x45, 0x67, 0x4d, 0x41, 0x30, 0x47, 0x43,
      0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x0d, 0x0a, 0x44, 0x51, 0x45, 0x42, 0x41, 0x51, 0x55,
      0x41, 0x41, 0x34, 0x49, 0x42, 0x44, 0x51, 0x41, 0x77, 0x67, 0x67, 0x45, 0x49, 0x41, 0x6f, 0x49,
      0x42, 0x41, 0x51, 0x43, 0x33, 0x4d, 0x73, 0x6a, 0x2b, 0x36, 0x58, 0x47, 0x6d, 0x42, 0x49, 0x57,
      0x74, 0x44, 0x42, 0x46, 0x6b, 0x33, 0x38, 0x35, 0x4e, 0x37, 0x38, 0x67, 0x44, 0x47, 0x49, 0x63,
      0x2f, 0x6f, 0x61, 0x76, 0x37, 0x50, 0x4b, 0x61, 0x66, 0x0d, 0x0a, 0x38, 0x4d, 0x4f, 0x68, 0x32,
      0x74, 0x54, 0x59, 0x62, 0x69, 0x74, 0x54, 0x6b, 0x50, 0x73, 0x6b, 0x70, 0x44, 0x36, 0x45, 0x38,
      0x4a, 0x37, 0x6f, 0x58, 0x2b, 0x7a, 0x6c, 0x4a, 0x30, 0x54, 0x31, 0x4b, 0x4b, 0x59, 0x2f, 0x65,
      0x39, 0x37, 0x67, 0x4b, 0x76, 0x44, 0x49, 0x72, 0x31, 0x4d, 0x76, 0x6e, 0x73, 0x6f, 0x46, 0x41,
      0x5a, 0x4d, 0x65, 0x6a, 0x32, 0x59, 0x63, 0x4f, 0x61, 0x64, 0x4e, 0x0d, 0x0a, 0x2b, 0x6c, 0x71,
      0x32, 0x63, 0x77, 0x51, 0x6c, 0x5a, 0x75, 0x74, 0x33, 0x66, 0x2b, 0x64, 0x5a, 0x78, 0x6b, 0x71,
      0x5a, 0x4a, 0x52, 0x52, 0x55, 0x36, 0x79, 0x62, 0x48, 0x38, 0x33, 0x38, 0x5a, 0x31, 0x54, 0x42,
      0x77, 0x6a, 0x36, 0x2b, 0x77, 0x52, 0x69, 0x72, 0x2f, 0x72, 0x65, 0x73, 0x70, 0x37, 0x64, 0x65,
      0x66, 0x71, 0x67, 0x53, 0x48, 0x6f, 0x39, 0x54, 0x35, 0x69, 0x61, 0x55, 0x30, 0x0d, 0x0a, 0x58,
      0x39, 0x74, 0x44, 0x6b, 0x59, 0x49, 0x32, 0x32, 0x57, 0x59, 0x38, 0x73, 0x62, 0x69, 0x35, 0x67,
      0x76, 0x32, 0x63, 0x4f, 0x6a, 0x34, 0x51, 0x79, 0x44, 0x76, 0x76, 0x42, 0x6d, 0x56, 0x6d, 0x65,
      0x70, 0x73, 0x5a, 0x47, 0x44, 0x33, 0x2f, 0x63, 0x56, 0x45, 0x38, 0x4d, 0x43, 0x35, 0x66, 0x76,
      0x6a, 0x31, 0x33, 0x63, 0x37, 0x4a, 0x64, 0x42, 0x6d, 0x7a, 0x44, 0x49, 0x31, 0x61, 0x61, 0x0d,
      0x0a, 0x4b, 0x34, 0x55, 0x6d, 0x6b, 0x68, 0x79, 0x6e, 0x41, 0x72, 0x50, 0x6b, 0x50, 0x77, 0x32,
      0x76, 0x43, 0x48, 0x6d, 0x43, 0x75, 0x44, 0x59, 0x39, 0x36, 0x70, 0x7a, 0x54, 0x4e, 0x62, 0x4f,
      0x38, 0x61, 0x63, 0x72, 0x31, 0x7a, 0x4a, 0x33, 0x6f, 0x2f, 0x57, 0x53, 0x4e, 0x46, 0x34, 0x41,
      0x7a, 0x62, 0x6c, 0x35, 0x4b, 0x58, 0x5a, 0x6e, 0x4a, 0x48, 0x6f, 0x65, 0x30, 0x6e, 0x52, 0x72,
      0x41, 0x0d, 0x0a, 0x31, 0x57, 0x34, 0x54, 0x4e, 0x53, 0x4e, 0x65, 0x33, 0x35, 0x74, 0x66, 0x50,
      0x65, 0x2f, 0x57, 0x39, 0x33, 0x62, 0x43, 0x36, 0x6a, 0x36, 0x37, 0x65, 0x41, 0x30, 0x63, 0x51,
      0x6d, 0x64, 0x72, 0x42, 0x4e, 0x6a, 0x34, 0x31, 0x74, 0x70, 0x76, 0x69, 0x2f, 0x4a, 0x45, 0x6f,
      0x41, 0x47, 0x72, 0x41, 0x67, 0x45, 0x44, 0x6f, 0x34, 0x48, 0x46, 0x4d, 0x49, 0x48, 0x43, 0x4d,
      0x42, 0x30, 0x47, 0x0d, 0x0a, 0x41, 0x31, 0x55, 0x64, 0x44, 0x67, 0x51, 0x57, 0x42, 0x42, 0x53,
      0x2f, 0x58, 0x37, 0x66, 0x52, 0x7a, 0x74, 0x30, 0x66, 0x68, 0x76, 0x52, 0x62, 0x56, 0x61, 0x7a,
      0x63, 0x31, 0x78, 0x44, 0x43, 0x44, 0x71, 0x6d, 0x49, 0x35, 0x7a, 0x43, 0x42, 0x6b, 0x67, 0x59,
      0x44, 0x56, 0x52, 0x30, 0x6a, 0x42, 0x49, 0x47, 0x4b, 0x4d, 0x49, 0x47, 0x48, 0x67, 0x42, 0x53,
      0x2f, 0x58, 0x37, 0x66, 0x52, 0x0d, 0x0a, 0x7a, 0x74, 0x30, 0x66, 0x68, 0x76, 0x52, 0x62, 0x56,
      0x61, 0x7a, 0x63, 0x31, 0x78, 0x44, 0x43, 0x44, 0x71, 0x6d, 0x49, 0x35, 0x36, 0x46, 0x73, 0x70,
      0x47, 0x6f, 0x77, 0x61, 0x44, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47, 0x41, 0x31, 0x55, 0x45, 0x42,
      0x68, 0x4d, 0x43, 0x56, 0x56, 0x4d, 0x78, 0x4a, 0x54, 0x41, 0x6a, 0x42, 0x67, 0x4e, 0x56, 0x42,
      0x41, 0x6f, 0x54, 0x48, 0x46, 0x4e, 0x30, 0x0d, 0x0a, 0x59, 0x58, 0x4a, 0x6d, 0x61, 0x57, 0x56,
      0x73, 0x5a, 0x43, 0x42, 0x55, 0x5a, 0x57, 0x4e, 0x6f, 0x62, 0x6d, 0x39, 0x73, 0x62, 0x32, 0x64,
      0x70, 0x5a, 0x58, 0x4d, 0x73, 0x49, 0x45, 0x6c, 0x75, 0x59, 0x79, 0x34, 0x78, 0x4d, 0x6a, 0x41,
      0x77, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x73, 0x54, 0x4b, 0x56, 0x4e, 0x30, 0x59, 0x58, 0x4a,
      0x6d, 0x61, 0x57, 0x56, 0x73, 0x5a, 0x43, 0x42, 0x44, 0x0d, 0x0a, 0x62, 0x47, 0x46, 0x7a, 0x63,
      0x79, 0x41, 0x79, 0x49, 0x45, 0x4e, 0x6c, 0x63, 0x6e, 0x52, 0x70, 0x5a, 0x6d, 0x6c, 0x6a, 0x59,
      0x58, 0x52, 0x70, 0x62, 0x32, 0x34, 0x67, 0x51, 0x58, 0x56, 0x30, 0x61, 0x47, 0x39, 0x79, 0x61,
      0x58, 0x52, 0x35, 0x67, 0x67, 0x45, 0x41, 0x4d, 0x41, 0x77, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45,
      0x77, 0x51, 0x46, 0x4d, 0x41, 0x4d, 0x42, 0x41, 0x66, 0x38, 0x77, 0x0d, 0x0a, 0x44, 0x51, 0x59,
      0x4a, 0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x46, 0x42, 0x51, 0x41,
      0x44, 0x67, 0x67, 0x45, 0x42, 0x41, 0x41, 0x57, 0x64, 0x50, 0x34, 0x69, 0x64, 0x30, 0x63, 0x6b,
      0x61, 0x56, 0x61, 0x47, 0x73, 0x61, 0x66, 0x50, 0x7a, 0x57, 0x64, 0x71, 0x62, 0x41, 0x59, 0x63,
      0x61, 0x54, 0x31, 0x65, 0x70, 0x6f, 0x58, 0x6b, 0x4a, 0x4b, 0x74, 0x76, 0x33, 0x0d, 0x0a, 0x4c,
      0x37, 0x49, 0x65, 0x7a, 0x4d, 0x64, 0x65, 0x61, 0x74, 0x69, 0x44, 0x68, 0x36, 0x47, 0x58, 0x37,
      0x30, 0x6b, 0x31, 0x50, 0x6e, 0x63, 0x47, 0x51, 0x56, 0x68, 0x69, 0x76, 0x34, 0x35, 0x59, 0x75,
      0x41, 0x70, 0x6e, 0x50, 0x2b, 0x79, 0x7a, 0x33, 0x53, 0x46, 0x6d, 0x48, 0x38, 0x6c, 0x55, 0x2b,
      0x6e, 0x4c, 0x4d, 0x50, 0x55, 0x78, 0x41, 0x32, 0x49, 0x47, 0x76, 0x64, 0x35, 0x36, 0x44, 0x0d,
      0x0a, 0x65, 0x72, 0x75, 0x69, 0x78, 0x2f, 0x55, 0x30, 0x46, 0x34, 0x37, 0x5a, 0x45, 0x55, 0x44,
      0x30, 0x2f, 0x43, 0x77, 0x71, 0x54, 0x52, 0x56, 0x2f, 0x70, 0x32, 0x4a, 0x64, 0x4c, 0x69, 0x58,
      0x54, 0x41, 0x41, 0x73, 0x67, 0x47, 0x68, 0x31, 0x6f, 0x2b, 0x52, 0x65, 0x34, 0x39, 0x4c, 0x32,
      0x4c, 0x37, 0x53, 0x68, 0x5a, 0x33, 0x55, 0x30, 0x57, 0x69, 0x78, 0x65, 0x44, 0x79, 0x4c, 0x4a,
      0x6c, 0x0d, 0x0a, 0x78, 0x79, 0x31, 0x36, 0x70, 0x61, 0x71, 0x38, 0x55, 0x34, 0x5a, 0x74, 0x33,
      0x56, 0x65, 0x6b, 0x79, 0x76, 0x67, 0x67, 0x51, 0x51, 0x74, 0x6f, 0x38, 0x50, 0x54, 0x37, 0x64,
      0x4c, 0x35, 0x57, 0x58, 0x58, 0x70, 0x35, 0x39, 0x66, 0x6b, 0x64, 0x68, 0x65, 0x4d, 0x74, 0x6c,
      0x62, 0x37, 0x31, 0x63, 0x5a, 0x42, 0x44, 0x7a, 0x49, 0x30, 0x66, 0x6d, 0x67, 0x41, 0x4b, 0x68,
      0x79, 0x6e, 0x70, 0x0d, 0x0a, 0x56, 0x53, 0x4a, 0x59, 0x41, 0x43, 0x50, 0x71, 0x34, 0x78, 0x4a,
      0x44, 0x4b, 0x56, 0x74, 0x48, 0x43, 0x4e, 0x32, 0x4d, 0x51, 0x57, 0x70, 0x6c, 0x42, 0x71, 0x6a,
      0x6c, 0x49, 0x61, 0x70, 0x42, 0x74, 0x4a, 0x55, 0x68, 0x6c, 0x62, 0x6c, 0x39, 0x30, 0x54, 0x53,
      0x72, 0x45, 0x39, 0x61, 0x74, 0x76, 0x4e, 0x7a, 0x69, 0x50, 0x54, 0x6e, 0x4e, 0x76, 0x54, 0x35,
      0x31, 0x63, 0x4b, 0x45, 0x59, 0x0d, 0x0a, 0x57, 0x51, 0x50, 0x4a, 0x49, 0x72, 0x53, 0x50, 0x6e,
      0x4e, 0x56, 0x65, 0x4b, 0x74, 0x65, 0x6c, 0x74, 0x74, 0x51, 0x4b, 0x62, 0x66, 0x69, 0x33, 0x51,
      0x42, 0x46, 0x47, 0x6d, 0x68, 0x39, 0x35, 0x44, 0x6d, 0x4b, 0x2f, 0x44, 0x35, 0x66, 0x73, 0x34,
      0x43, 0x38, 0x66, 0x46, 0x35, 0x51, 0x3d, 0x0d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e,
      0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d,
      0x2d, 0x2d, 0x0d, 0x0a, 0x00
    },
    1492
  }
};

#define TLT_NUM_ROOT_CERTS (sizeof(TLT_ROOT_CERTS) / sizeof(TLT_ROOT_CERTS[0]))

#endif //__TLTROOTCERTS__H