# SlimLoRa User-Configurable Defines

This document lists important `#define` directives in `SlimLoRa.h` that you can modify to customize the library's behavior, features, and resource usage. These settings should typically be defined in your main sketch (.ino file) *before* including `SlimLoRa.h`, or by directly editing `SlimLoRa.h`.

Arduino IDE has the limitation that you can't define in your sketch the library behaviour. First is compiled the library and THEN your sketch. But not everything is lost. You can comppile with arduino-cli with the options you want.

Example usage with `arduino-cli -v compile ./ -b adafruit:avr:32u4 --build-property "compiler.cpp.extra_flags=-DNON_BLOCKING=1 -DSLIMLORA_UPLINK_PACKET_SIZE=24 -DEEPROM_OFFSET=192 -DDEBUG_SLIM=1 -UMAC_REQUESTS -DEPOCH_RX2_WINDOW_OFFSET"`

With -U flag you undefine a variable.

With platformIO add: `build_flags = -DDEBUG_SLIM=1` e.t.c.

## General Network & LoRaWAN Settings

| Define                | Default | Description                                                                                                                                                                                                                                                                          | Example Usage                                |
| :-------------------- | :------ | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------- |
| `EU863`, `US902`, `AS920`, `AU915` | `EU863` | **Region Selection.** Curently ONY EU836. Define the appropriate region for your LoRaWAN deployment. This affects frequency plans, data rates, and other regional parameters.                                                                                | `#define US902`                              |
| `NBTRANS`             | `1`     | **Number of Re-transmissions.** Defines how many times a confirmed uplink will be re-transmitted if no acknowledgment is received. Values range from 1 to 15. Higher values increase reliability but also airtime and power consumption.                                       | `#define NBTRANS 4`                          |
| `NETWORK`             | `NET_HELIUM` | **Network Selection.** Determines some default RX2 window settings and delays. Valid values are `NET_TTN` (for The Things Network) or `NET_HELIUM` (for Helium Network).                                                                                                      | `#define NETWORK NET_TTN`                      |
| `LORAWAN_OTAA_ENABLED`| `1`     | **LoRaWAN Over-The-Air Activation.** Set to `1` to enable OTAA, `0` for ABP (Activation By Personalization). OTAA is recommended for most applications. ABP is UNTESTED                                                                                                                          | `#define LORAWAN_OTAA_ENABLED 0`             
| `LORAWAN_KEEP_SESSION`| `1`     | **Session Data Storage.** Set to `1` to enable storing LoRaWAN session data (keys, frame counters, etc.) to EEPROM. This allows the device to resume a session after a power cycle without re-joining. Disabling saves some Flash/RAM but requires re-joining every boot.      | `#define LORAWAN_KEEP_SESSION 0`             |
| `NON_BLOCKING`| `0`     | **Non blocking beheviour.** Set to `1` to enable non blocking behaviour. Check example with `NON_BLOCKING` in it's name.      | `#define NON_BLOCKING 1`             |
| `SLIMLORA_FREE_MICROS`| `500`     | **After 500ms the variable RFstatus will advance and rxTimerTiggered will be set.** Don't go more than 500ms. Consult the DRIFT table in README.md | `#define SLIMLORA_FREE_MICROS`             |

## Debugging & Optimization

| Define                | Default | Description                                                                                                                                                                                                                                                                          | Example Usage                                |
| :-------------------- | :------ | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------- |
| `DEBUG_SLIM`          | `0`     | **Serial Debugging Level.** Controls the verbosity of debug messages printed to the Serial monitor. `0` disables debugging, `1` provides basic info, `2` provides more detailed debugging.                                                                                      | `#define DEBUG_SLIM 2`                       |
| `SLIMLORA_USE_PROGMEM`| (defined if AVR) | **PROGMEM Optimization.** If defined (typically automatically for AVR MCUs), stores large constant arrays (like frequency and data rate tables) in program memory (Flash) instead of RAM, saving valuable RAM. Undefined for non-AVR MCUs.                              | (Usually left default)                       |
| `SLIM_DEBUG_VARS`     | (undefined) | **Enable Debug Variables.** If defined, enables internal debug variables (`LoRaWANreceived`, etc.) to track RX/join window status, MAC command processing, etc. Adds ~96 bytes of Program Flash and 1 byte of RAM.                                                              | `#define SLIM_DEBUG_VARS`                    |
| `COUNT_TX_DURATION`   | `1`     | **Transmit Duration Counting.** Set to `1` to enable tracking of uplink transmission duration in milliseconds. Useful for duty cycle enforcement or performance analysis. Adds some Flash/RAM.                                                                                    | `#define COUNT_TX_DURATION 0`                |
| `SLIMLORA_DRIFT`      | `1`     | **Clock Drift Adjustment.** A percentage value used to adjust RX window timing to compensate for clock drift between the end-device and the gateway. Higher values open the window earlier/wider. This is a critical parameter for reliable downlink reception.                 | `#define SLIMLORA_DRIFT 2`                   |
| `CATCH_DIVIDER`       | (defined if AVR) | **AVR Clock Divider Handling.** If defined (typically automatically for AVR MCUs), it enables code that accounts for the MCU's `clock_prescale_get()` value, which impacts timer calculations if the main CPU clock has been divided down from the crystal frequency. | (Usually left default)                       |
| `DYNAMIC_ADR_ACK_LIMIT` | (defined) | If defined, allows dynamic adjustment of `adr_ack_limit` via a variable.                                                                                                                                                                                                           | (Can be `// #undef DYNAMIC_ADR_ACK_LIMIT` to disable) |
| `ATOMIC_ENABLE`       | (defined) | If defined, uses `ATOMIC_BLOCK` macros to protect critical sections of code (like `micros()` reads after TX) from interrupts, ensuring atomicity. Adds ~64 bytes of code.                                                                                                        | (Usually left default)                       |
| `ENABLE_CONF_UPLINKS` | `0`     | **Confirmed Uplinks.** Set to `1` to enable sending confirmed uplink messages. Confirmed uplinks require an acknowledgment from the LNS, increasing reliability but also airtime and power consumption.                                                                            | `#define ENABLE_CONF_UPLINKS 1`              |

## EEPROM & Storage

| Define                | Default | Description                                                                                                                                                                                                                                                                          | Example Usage                                |
| :-------------------- | :------ | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------- |
| `ARDUINO_EEPROM`      | `1`     | **EEPROM Handling Method.** `1` uses the standard Arduino `EEPROM.h` library (internal EEPROM). `2` uses an external I2C EEPROM (requires SparkFun External EEPROM library). `0` uses `avr/eeprom.h` (direct AVR EEPROM access, less portable).                                | `#define ARDUINO_EEPROM 2`                   |
| `EEPROM_WRITE_TX_COUNT` | `200`   | **Tx Counter Write Frequency.** The number of uplinks after which the transmit frame counter (`tx_frame_counter_`) is saved to EEPROM. A higher value reduces EEPROM wear but increases risk of data loss on power failure.                                                           | `#define EEPROM_WRITE_TX_COUNT 10`           |
| `EEPROM_WRITE_RX_COUNT` | `10`    | **Rx Counter Write Frequency.** Similar to `EEPROM_WRITE_TX_COUNT`, but for the receive frame counter (`rx_frame_counter_`).                                                                                                                                                    | `#define EEPROM_WRITE_RX_COUNT 3`            |
| `SLIMLORA_EEPROM_MEMORY_TYPE` | `2`     | **External EEPROM Size.** (Only relevant if `ARDUINO_EEPROM` is `2`). Defines the memory type/size of the external I2C EEPROM. `2` is for 2kbit EEPROM (512 bytes).                                                                                                      | `#define SLIMLORA_EEPROM_MEMORY_TYPE 2`      |
| `EXTERNAL_EEPROM_ADDRESS` | `0x50`  | **External EEPROM I2C Address.** (Only relevant if `ARDUINO_EEPROM` is `2`). The I2C address of your external EEPROM.                                                                                                                                                        | `#define EXTERNAL_EEPROM_ADDRESS 0x51`       |
| `EXTERNAL_EEPROM_EUI_ADDRESS` | `0xF8`  | **External EEPROM EUI Address.** (Only relevant if `ARDUINO_EEPROM` is `2`). The address within the external EEPROM where EUI is stored.                                                                                                                                | `#define EXTERNAL_EEPROM_EUI_ADDRESS 0xF8`   |
| `EEPROM_OFFSET`       | `0`     | **EEPROM Start Offset.** If you want to use a specific area of the EEPROM and avoid overwriting other data, you can define an offset.                                                                                                                                       | `#define EEPROM_OFFSET 100`                  |

## Packet & Buffer Sizes

| Define                     | Default | Description                                                                                                                                                                                                                                                                          | Example Usage                                |
| :------------------------- | :------ | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------- |
| `SLIMLORA_DOWNLINK_PAYLOAD_SIZE` | `51`    | **Downlink Payload Buffer Size.** Maximum size in bytes for the downlink application payload. Adjusting this can save RAM. LoRaWAN has limits based on SF/BW (e.g., SF12 in EU868 is 51 bytes without MAC commands).                                                       | `#define SLIMLORA_DOWNLINK_PAYLOAD_SIZE 36`  |
| `SLIMLORA_UPLINK_PACKET_SIZE` | `64`    | **Uplink Packet Buffer Size.** Safest maximum size for the entire uplink packet (LoRaWAN headers + payload + MIC + MAC commands). Adjusting this can save RAM. The absolute maximum for LoRaWAN is ~255 bytes for SF7.                                                  | `#define SLIMLORA_UPLINK_PACKET_SIZE 255`    |

## Advanced/Experimental Settings

| Define                | Default | Description                                                                                                                                                                                                                                                                          | Example Usage                                |
| :-------------------- | :------ | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------- |
| `MAC_REQUESTS`        | (defined) | **Enable MAC Requests.** If defined, enables support for LoRaWAN MAC requests like `TimeReq` and `LinkCheck`. Adds significant Flash and RAM but provides network diagnostic features.                                                                                        | `#undef MAC_REQUESTS` (to disable)         |
| `EPOCH_RX2_WINDOW_OFFSET` | (undefined) | **Epoch RX2 Window Offset.** If defined, adds one second to the epoch time if it's received in the RX2 window, to improve epoch accuracy. Requires `SLIM_DEBUG_VARS` to be enabled.                                                                                            | `#define EPOCH_RX2_WINDOW_OFFSET`            |
| `EU_DR6`              | (undefined) | **Enable EU Data Rate 6.** If defined, enables specific handling for EU DR6 (SF7BW250). Note: TTN generally does not allow this, and Helium does not support it. Use only for experiments without ADR.                                                                         | `#define EU_DR6`                             |
| `DEBUG_RXSYMBOLS`     | `0`     | **RX Symbol Debugging.** `0` disables, `1` shows RX duration, `2` adds more debugging but might break timing.                                                                                                                                                                       | `#define DEBUG_RXSYMBOLS 1`                  |
