/******************************************************************************/
/* Arduino eForth.C, 1.0: For Atmega328 on arduino Uno                        */
/******************************************************************************/
/* Chen-Hanson Ting                                                           */
/* Version 2.0, 06nov11cht                                                    */
/* Compile new commands in RAM                                                */
/*                                                                            */
/* Version 1.0, 21sep11cht                                                    */
/* Adopted from eForth_11.c                                                   */
/* Compiled by Arduino as a sketch                                            */
/* Follow closely the original eForth model                                   */
/* Kernel has 32 primitives                                                   */
/* code[] array must be filled with rom.mif produced by cefMETA328            */
/* @, !, C@ and C! access RAM memory                                          */
/******************************************************************************/
#include <avr/pgmspace.h>


#define	LOGICAL ? 0xFFFF: 0
#define 	LOWER(x,y) ((unsigned int)(x)<(unsigned int)(y))
#define	pop	top = *S--
#define	push	*++S = top; top =
#define data    ((unsigned int*) (0))
#define cData    ((unsigned char*) (0))

unsigned char* cCode;
int n;
int  I, P, IP, top ;
unsigned char I1, I2;
int w, clock;
int phase;
int rack[32] = {0};
int stack[32] = {0};
int* R = rack;
int* S = stack;
const int code[] PROGMEM = {

/* WIDTH=16; */
/* DEPTH=8192; */
/* ADDRESS_RADIX=HEX; */
/* DATA_RADIX=HEX; */
/* CONTENT BEGIN; */
/* 0000 */ 0x0000,
/* 0002 */ 0x0000,
/* 0004 */ 0x0000,
/* 0006 */ 0x0000,
/* 0008 */ 0x0000,
/* 000A */ 0x0000,
/* 000C */ 0x0000,
/* 000E */ 0x0000,
/* 0010 */ 0x0000,
/* 0012 */ 0x0000,
/* 0014 */ 0x0000,
/* 0016 */ 0x0000,
/* 0018 */ 0x0000,
/* 001A */ 0x0000,
/* 001C */ 0x0000,
/* 001E */ 0x0000,
/* 0020 */ 0x0000,
/* 0022 */ 0x0000,
/* 0024 */ 0x0000,
/* 0026 */ 0x0000,
/* 0028 */ 0x0000,
/* 002A */ 0x0000,
/* 002C */ 0x0000,
/* 002E */ 0x0000,
/* 0030 */ 0x0000,
/* 0032 */ 0x0000,
/* 0034 */ 0x0000,
/* 0036 */ 0x0000,
/* 0038 */ 0x0000,
/* 003A */ 0x0000,
/* 003C */ 0x0000,
/* 003E */ 0x0000,
/* 0040 */ 0x0000,
/* 0042 */ 0x0000,
/* 0044 */ 0x0000,
/* 0046 */ 0x0000,
/* 0048 */ 0x0000,
/* 004A */ 0x0000,
/* 004C */ 0x0000,
/* 004E */ 0x0000,
/* 0050 */ 0x0000,
/* 0052 */ 0x0000,
/* 0054 */ 0x0000,
/* 0056 */ 0x0000,
/* 0058 */ 0x0000,
/* 005A */ 0x0000,
/* 005C */ 0x0000,
/* 005E */ 0x0000,
/* 0060 */ 0x0000,
/* 0062 */ 0x0000,
/* 0064 */ 0x0000,
/* 0066 */ 0x0000,
/* 0068 */ 0x0000,
/* 006A */ 0x0000,
/* 006C */ 0x0000,
/* 006E */ 0x0000,
/* 0070 */ 0x0000,
/* 0072 */ 0x0000,
/* 0074 */ 0x0000,
/* 0076 */ 0x0000,
/* 0078 */ 0x0000,
/* 007A */ 0x0000,
/* 007C */ 0x0000,
/* 007E */ 0x0000,
/* 0080 */ 0x0000,
/* 0082 */ 0x0000,
/* 0084 */ 0x0000,
/* 0086 */ 0x0000,
/* 0088 */ 0x0000,
/* 008A */ 0x0000,
/* 008C */ 0x0000,
/* 008E */ 0x0000,
/* 0090 */ 0x0000,
/* 0092 */ 0x0000,
/* 0094 */ 0x0000,
/* 0096 */ 0x0000,
/* 0098 */ 0x0000,
/* 009A */ 0x0000,
/* 009C */ 0x0000,
/* 009E */ 0x0000,
/* 00A0 */ 0x0000,
/* 00A2 */ 0x0000,
/* 00A4 */ 0x0000,
/* 00A6 */ 0x0000,
/* 00A8 */ 0x0000,
/* 00AA */ 0x0000,
/* 00AC */ 0x0000,
/* 00AE */ 0x0000,
/* 00B0 */ 0x0000,
/* 00B2 */ 0x0000,
/* 00B4 */ 0x0000,
/* 00B6 */ 0x0000,
/* 00B8 */ 0x0000,
/* 00BA */ 0x0000,
/* 00BC */ 0x0000,
/* 00BE */ 0x0000,
/* 00C0 */ 0x0000,
/* 00C2 */ 0x0000,
/* 00C4 */ 0x0000,
/* 00C6 */ 0x0000,
/* 00C8 */ 0x0000,
/* 00CA */ 0x0000,
/* 00CC */ 0x0000,
/* 00CE */ 0x0000,
/* 00D0 */ 0x0000,
/* 00D2 */ 0x0000,
/* 00D4 */ 0x0000,
/* 00D6 */ 0x0000,
/* 00D8 */ 0x0000,
/* 00DA */ 0x0000,
/* 00DC */ 0x0000,
/* 00DE */ 0x0000,
/* 00E0 */ 0x0000,
/* 00E2 */ 0x0000,
/* 00E4 */ 0x0000,
/* 00E6 */ 0x0000,
/* 00E8 */ 0x0000,
/* 00EA */ 0x0000,
/* 00EC */ 0x0000,
/* 00EE */ 0x0000,
/* 00F0 */ 0x0000,
/* 00F2 */ 0x0000,
/* 00F4 */ 0x0000,
/* 00F6 */ 0x0000,
/* 00F8 */ 0x0000,
/* 00FA */ 0x0000,
/* 00FC */ 0x0000,
/* 00FE */ 0x0000,
/* 0100 */ 0x0000,
/* 0102 */ 0x0000,
/* 0104 */ 0x0000,
/* 0106 */ 0x0000,
/* 0108 */ 0x0000,
/* 010A */ 0x0000,
/* 010C */ 0x0000,
/* 010E */ 0x0000,
/* 0110 */ 0x0000,
/* 0112 */ 0x0000,
/* 0114 */ 0x0000,
/* 0116 */ 0x0000,
/* 0118 */ 0x0000,
/* 011A */ 0x0000,
/* 011C */ 0x0000,
/* 011E */ 0x0000,
/* 0120 */ 0x0000,
/* 0122 */ 0x0000,
/* 0124 */ 0x0000,
/* 0126 */ 0x0000,
/* 0128 */ 0x0000,
/* 012A */ 0x0000,
/* 012C */ 0x0000,
/* 012E */ 0x0000,
/* 0130 */ 0x0000,
/* 0132 */ 0x0000,
/* 0134 */ 0x0000,
/* 0136 */ 0x0000,
/* 0138 */ 0x0000,
/* 013A */ 0x0000,
/* 013C */ 0x0000,
/* 013E */ 0x0000,
/* 0140 */ 0x0000,
/* 0142 */ 0x0000,
/* 0144 */ 0x0000,
/* 0146 */ 0x0000,
/* 0148 */ 0x0000,
/* 014A */ 0x0000,
/* 014C */ 0x0000,
/* 014E */ 0x0000,
/* 0150 */ 0x0000,
/* 0152 */ 0x0000,
/* 0154 */ 0x0000,
/* 0156 */ 0x0000,
/* 0158 */ 0x0000,
/* 015A */ 0x0000,
/* 015C */ 0x0000,
/* 015E */ 0x0000,
/* 0160 */ 0x0000,
/* 0162 */ 0x0000,
/* 0164 */ 0x0000,
/* 0166 */ 0x0000,
/* 0168 */ 0x0000,
/* 016A */ 0x0000,
/* 016C */ 0x0000,
/* 016E */ 0x0000,
/* 0170 */ 0x0000,
/* 0172 */ 0x0000,
/* 0174 */ 0x0000,
/* 0176 */ 0x0000,
/* 0178 */ 0x0000,
/* 017A */ 0x0000,
/* 017C */ 0x0000,
/* 017E */ 0x0000,
/* 0180 */ 0x0000,
/* 0182 */ 0x0000,
/* 0184 */ 0x0000,
/* 0186 */ 0x0000,
/* 0188 */ 0x0000,
/* 018A */ 0x0000,
/* 018C */ 0x0000,
/* 018E */ 0x0000,
/* 0190 */ 0x0000,
/* 0192 */ 0x0000,
/* 0194 */ 0x0000,
/* 0196 */ 0x0000,
/* 0198 */ 0x0000,
/* 019A */ 0x0000,
/* 019C */ 0x0000,
/* 019E */ 0x0000,
/* 01A0 */ 0x0000,
/* 01A2 */ 0x0000,
/* 01A4 */ 0x0000,
/* 01A6 */ 0x0000,
/* 01A8 */ 0x0000,
/* 01AA */ 0x0000,
/* 01AC */ 0x0000,
/* 01AE */ 0x0000,
/* 01B0 */ 0x0000,
/* 01B2 */ 0x0000,
/* 01B4 */ 0x0000,
/* 01B6 */ 0x0000,
/* 01B8 */ 0x0000,
/* 01BA */ 0x0000,
/* 01BC */ 0x0000,
/* 01BE */ 0x0000,
/* 01C0 */ 0x0000,
/* 01C2 */ 0x0000,
/* 01C4 */ 0x0000,
/* 01C6 */ 0x0000,
/* 01C8 */ 0x0000,
/* 01CA */ 0x0000,
/* 01CC */ 0x0000,
/* 01CE */ 0x0000,
/* 01D0 */ 0x0000,
/* 01D2 */ 0x0000,
/* 01D4 */ 0x0000,
/* 01D6 */ 0x0000,
/* 01D8 */ 0x0000,
/* 01DA */ 0x0000,
/* 01DC */ 0x0000,
/* 01DE */ 0x0000,
/* 01E0 */ 0x0000,
/* 01E2 */ 0x0000,
/* 01E4 */ 0x0000,
/* 01E6 */ 0x0000,
/* 01E8 */ 0x0000,
/* 01EA */ 0x0000,
/* 01EC */ 0x0000,
/* 01EE */ 0x0000,
/* 01F0 */ 0x0000,
/* 01F2 */ 0x0000,
/* 01F4 */ 0x0000,
/* 01F6 */ 0x0000,
/* 01F8 */ 0x0000,
/* 01FA */ 0x0000,
/* 01FC */ 0x0000,
/* 01FE */ 0x0000,
/* 0200 */ 0x0000,
/* 0202 */ 0x0000,
/* 0204 */ 0x0000,
/* 0206 */ 0x0000,
/* 0208 */ 0x0000,
/* 020A */ 0x0000,
/* 020C */ 0x0000,
/* 020E */ 0x0000,
/* 0210 */ 0x0000,
/* 0212 */ 0x0000,
/* 0214 */ 0x0000,
/* 0216 */ 0x0000,
/* 0218 */ 0x0000,
/* 021A */ 0x0000,
/* 021C */ 0x0000,
/* 021E */ 0x0000,
/* 0220 */ 0x0000,
/* 0222 */ 0x0000,
/* 0224 */ 0x0000,
/* 0226 */ 0x0000,
/* 0228 */ 0x0000,
/* 022A */ 0x0000,
/* 022C */ 0x0000,
/* 022E */ 0x0000,
/* 0230 */ 0x0000,
/* 0232 */ 0x0000,
/* 0234 */ 0x0000,
/* 0236 */ 0x0000,
/* 0238 */ 0x0000,
/* 023A */ 0x0000,
/* 023C */ 0x0000,
/* 023E */ 0x0000,
/* 0240 */ 0x0000,
/* 0242 */ 0x0000,
/* 0244 */ 0x0000,
/* 0246 */ 0x0000,
/* 0248 */ 0x0000,
/* 024A */ 0x0000,
/* 024C */ 0x0000,
/* 024E */ 0x0000,
/* 0250 */ 0x0000,
/* 0252 */ 0x0000,
/* 0254 */ 0x0000,
/* 0256 */ 0x0000,
/* 0258 */ 0x0000,
/* 025A */ 0x0000,
/* 025C */ 0x0000,
/* 025E */ 0x0000,
/* 0260 */ 0x0000,
/* 0262 */ 0x0000,
/* 0264 */ 0x0000,
/* 0266 */ 0x0000,
/* 0268 */ 0x0000,
/* 026A */ 0x0000,
/* 026C */ 0x0000,
/* 026E */ 0x0000,
/* 0270 */ 0x0000,
/* 0272 */ 0x0000,
/* 0274 */ 0x0000,
/* 0276 */ 0x0000,
/* 0278 */ 0x0000,
/* 027A */ 0x0000,
/* 027C */ 0x0000,
/* 027E */ 0x0000,
/* 0280 */ 0x0000,
/* 0282 */ 0x0000,
/* 0284 */ 0x0000,
/* 0286 */ 0x0000,
/* 0288 */ 0x0000,
/* 028A */ 0x0000,
/* 028C */ 0x0000,
/* 028E */ 0x0000,
/* 0290 */ 0x0000,
/* 0292 */ 0x0000,
/* 0294 */ 0x0000,
/* 0296 */ 0x0000,
/* 0298 */ 0x0000,
/* 029A */ 0x0000,
/* 029C */ 0x0000,
/* 029E */ 0x0000,
/* 02A0 */ 0x0000,
/* 02A2 */ 0x0000,
/* 02A4 */ 0x0000,
/* 02A6 */ 0x0000,
/* 02A8 */ 0x0000,
/* 02AA */ 0x0000,
/* 02AC */ 0x0000,
/* 02AE */ 0x0000,
/* 02B0 */ 0x0000,
/* 02B2 */ 0x0000,
/* 02B4 */ 0x0000,
/* 02B6 */ 0x0000,
/* 02B8 */ 0x0000,
/* 02BA */ 0x0000,
/* 02BC */ 0x0000,
/* 02BE */ 0x0000,
/* 02C0 */ 0x0000,
/* 02C2 */ 0x0000,
/* 02C4 */ 0x0000,
/* 02C6 */ 0x0000,
/* 02C8 */ 0x0000,
/* 02CA */ 0x0000,
/* 02CC */ 0x0000,
/* 02CE */ 0x0000,
/* 02D0 */ 0x0000,
/* 02D2 */ 0x0000,
/* 02D4 */ 0x0000,
/* 02D6 */ 0x0000,
/* 02D8 */ 0x0000,
/* 02DA */ 0x0000,
/* 02DC */ 0x0000,
/* 02DE */ 0x0000,
/* 02E0 */ 0x0000,
/* 02E2 */ 0x0000,
/* 02E4 */ 0x0000,
/* 02E6 */ 0x0000,
/* 02E8 */ 0x0000,
/* 02EA */ 0x0000,
/* 02EC */ 0x0000,
/* 02EE */ 0x0000,
/* 02F0 */ 0x0000,
/* 02F2 */ 0x0000,
/* 02F4 */ 0x0000,
/* 02F6 */ 0x0000,
/* 02F8 */ 0x0000,
/* 02FA */ 0x0000,
/* 02FC */ 0x0000,
/* 02FE */ 0x0000,
/* 0300 */ 0x0000,
/* 0302 */ 0x0000,
/* 0304 */ 0x0000,
/* 0306 */ 0x0000,
/* 0308 */ 0x0000,
/* 030A */ 0x0000,
/* 030C */ 0x0000,
/* 030E */ 0x0000,
/* 0310 */ 0x0000,
/* 0312 */ 0x0000,
/* 0314 */ 0x0000,
/* 0316 */ 0x0000,
/* 0318 */ 0x0000,
/* 031A */ 0x0000,
/* 031C */ 0x0000,
/* 031E */ 0x0000,
/* 0320 */ 0x0000,
/* 0322 */ 0x0000,
/* 0324 */ 0x0000,
/* 0326 */ 0x0000,
/* 0328 */ 0x0000,
/* 032A */ 0x0000,
/* 032C */ 0x0000,
/* 032E */ 0x0000,
/* 0330 */ 0x0000,
/* 0332 */ 0x0000,
/* 0334 */ 0x0000,
/* 0336 */ 0x0000,
/* 0338 */ 0x0000,
/* 033A */ 0x0000,
/* 033C */ 0x0000,
/* 033E */ 0x0000,
/* 0340 */ 0x0000,
/* 0342 */ 0x0000,
/* 0344 */ 0x0000,
/* 0346 */ 0x0000,
/* 0348 */ 0x0000,
/* 034A */ 0x0000,
/* 034C */ 0x0000,
/* 034E */ 0x0000,
/* 0350 */ 0x0000,
/* 0352 */ 0x0000,
/* 0354 */ 0x0000,
/* 0356 */ 0x0000,
/* 0358 */ 0x0000,
/* 035A */ 0x0000,
/* 035C */ 0x0000,
/* 035E */ 0x0000,
/* 0360 */ 0x0000,
/* 0362 */ 0x0000,
/* 0364 */ 0x0000,
/* 0366 */ 0x0000,
/* 0368 */ 0x0000,
/* 036A */ 0x0000,
/* 036C */ 0x0000,
/* 036E */ 0x0000,
/* 0370 */ 0x0000,
/* 0372 */ 0x0000,
/* 0374 */ 0x0000,
/* 0376 */ 0x0000,
/* 0378 */ 0x0000,
/* 037A */ 0x0000,
/* 037C */ 0x0000,
/* 037E */ 0x0000,
/* 0380 */ 0x0000,
/* 0382 */ 0x0000,
/* 0384 */ 0x0000,
/* 0386 */ 0x0000,
/* 0388 */ 0x0000,
/* 038A */ 0x0000,
/* 038C */ 0x0000,
/* 038E */ 0x0000,
/* 0390 */ 0x0000,
/* 0392 */ 0x0000,
/* 0394 */ 0x0000,
/* 0396 */ 0x0000,
/* 0398 */ 0x0000,
/* 039A */ 0x0000,
/* 039C */ 0x0000,
/* 039E */ 0x0000,
/* 03A0 */ 0x0000,
/* 03A2 */ 0x0000,
/* 03A4 */ 0x0000,
/* 03A6 */ 0x0000,
/* 03A8 */ 0x0000,
/* 03AA */ 0x0000,
/* 03AC */ 0x0000,
/* 03AE */ 0x0000,
/* 03B0 */ 0x0000,
/* 03B2 */ 0x0000,
/* 03B4 */ 0x0000,
/* 03B6 */ 0x0000,
/* 03B8 */ 0x0000,
/* 03BA */ 0x0000,
/* 03BC */ 0x0000,
/* 03BE */ 0x0000,
/* 03C0 */ 0x0000,
/* 03C2 */ 0x0000,
/* 03C4 */ 0x0000,
/* 03C6 */ 0x0000,
/* 03C8 */ 0x0000,
/* 03CA */ 0x0000,
/* 03CC */ 0x0000,
/* 03CE */ 0x0000,
/* 03D0 */ 0x0000,
/* 03D2 */ 0x0000,
/* 03D4 */ 0x0000,
/* 03D6 */ 0x0000,
/* 03D8 */ 0x0000,
/* 03DA */ 0x0000,
/* 03DC */ 0x0000,
/* 03DE */ 0x0000,
/* 03E0 */ 0x0000,
/* 03E2 */ 0x0000,
/* 03E4 */ 0x0000,
/* 03E6 */ 0x0000,
/* 03E8 */ 0x0000,
/* 03EA */ 0x0000,
/* 03EC */ 0x0000,
/* 03EE */ 0x0000,
/* 03F0 */ 0x0000,
/* 03F2 */ 0x0000,
/* 03F4 */ 0x0000,
/* 03F6 */ 0x0000,
/* 03F8 */ 0x0000,
/* 03FA */ 0x0000,
/* 03FC */ 0x0000,
/* 03FE */ 0x0000,
/* 0400 */ 0x0000,
/* 0402 */ 0x0000,
/* 0404 */ 0x0000,
/* 0406 */ 0x0000,
/* 0408 */ 0x0000,
/* 040A */ 0x0000,
/* 040C */ 0x0000,
/* 040E */ 0x0000,
/* 0410 */ 0x0000,
/* 0412 */ 0x0000,
/* 0414 */ 0x0000,
/* 0416 */ 0x0000,
/* 0418 */ 0x0000,
/* 041A */ 0x0000,
/* 041C */ 0x0000,
/* 041E */ 0x0000,
/* 0420 */ 0x0000,
/* 0422 */ 0x0000,
/* 0424 */ 0x0000,
/* 0426 */ 0x0000,
/* 0428 */ 0x0000,
/* 042A */ 0x0000,
/* 042C */ 0x0000,
/* 042E */ 0x0000,
/* 0430 */ 0x0000,
/* 0432 */ 0x0000,
/* 0434 */ 0x0000,
/* 0436 */ 0x0000,
/* 0438 */ 0x0000,
/* 043A */ 0x0000,
/* 043C */ 0x0000,
/* 043E */ 0x0000,
/* 0440 */ 0x0000,
/* 0442 */ 0x0000,
/* 0444 */ 0x0000,
/* 0446 */ 0x0000,
/* 0448 */ 0x0000,
/* 044A */ 0x0000,
/* 044C */ 0x0000,
/* 044E */ 0x0000,
/* 0450 */ 0x0000,
/* 0452 */ 0x0000,
/* 0454 */ 0x0000,
/* 0456 */ 0x0000,
/* 0458 */ 0x0000,
/* 045A */ 0x0000,
/* 045C */ 0x0000,
/* 045E */ 0x0000,
/* 0460 */ 0x0000,
/* 0462 */ 0x0000,
/* 0464 */ 0x0000,
/* 0466 */ 0x0000,
/* 0468 */ 0x0000,
/* 046A */ 0x0000,
/* 046C */ 0x0000,
/* 046E */ 0x0000,
/* 0470 */ 0x0000,
/* 0472 */ 0x0000,
/* 0474 */ 0x0000,
/* 0476 */ 0x0000,
/* 0478 */ 0x0000,
/* 047A */ 0x0000,
/* 047C */ 0x0000,
/* 047E */ 0x0000,
/* 0480 */ 0x0000,
/* 0482 */ 0x0000,
/* 0484 */ 0x0000,
/* 0486 */ 0x0000,
/* 0488 */ 0x0000,
/* 048A */ 0x0000,
/* 048C */ 0x0000,
/* 048E */ 0x0000,
/* 0490 */ 0x0000,
/* 0492 */ 0x0000,
/* 0494 */ 0x0000,
/* 0496 */ 0x0000,
/* 0498 */ 0x0000,
/* 049A */ 0x0000,
/* 049C */ 0x0000,
/* 049E */ 0x0000,
/* 04A0 */ 0x0000,
/* 04A2 */ 0x0000,
/* 04A4 */ 0x0000,
/* 04A6 */ 0x0000,
/* 04A8 */ 0x0000,
/* 04AA */ 0x0000,
/* 04AC */ 0x0000,
/* 04AE */ 0x0000,
/* 04B0 */ 0x0000,
/* 04B2 */ 0x0000,
/* 04B4 */ 0x0000,
/* 04B6 */ 0x0000,
/* 04B8 */ 0x0000,
/* 04BA */ 0x0000,
/* 04BC */ 0x0000,
/* 04BE */ 0x0000,
/* 04C0 */ 0x0000,
/* 04C2 */ 0x0000,
/* 04C4 */ 0x0000,
/* 04C6 */ 0x0000,
/* 04C8 */ 0x0000,
/* 04CA */ 0x0000,
/* 04CC */ 0x0000,
/* 04CE */ 0x0000,
/* 04D0 */ 0x0000,
/* 04D2 */ 0x0000,
/* 04D4 */ 0x0000,
/* 04D6 */ 0x0000,
/* 04D8 */ 0x0000,
/* 04DA */ 0x0000,
/* 04DC */ 0x0000,
/* 04DE */ 0x0000,
/* 04E0 */ 0x0000,
/* 04E2 */ 0x0000,
/* 04E4 */ 0x0000,
/* 04E6 */ 0x0000,
/* 04E8 */ 0x0000,
/* 04EA */ 0x0000,
/* 04EC */ 0x0000,
/* 04EE */ 0x0000,
/* 04F0 */ 0x0000,
/* 04F2 */ 0x0000,
/* 04F4 */ 0x0000,
/* 04F6 */ 0x0000,
/* 04F8 */ 0x0000,
/* 04FA */ 0x0000,
/* 04FC */ 0x0000,
/* 04FE */ 0x0000,
/* 0500 */ 0x0000,
/* 0502 */ 0x0000,
/* 0504 */ 0x0000,
/* 0506 */ 0x0000,
/* 0508 */ 0x0000,
/* 050A */ 0x0000,
/* 050C */ 0x0000,
/* 050E */ 0x0000,
/* 0510 */ 0x0000,
/* 0512 */ 0x0000,
/* 0514 */ 0x0000,
/* 0516 */ 0x0000,
/* 0518 */ 0x0000,
/* 051A */ 0x0000,
/* 051C */ 0x0000,
/* 051E */ 0x0000,
/* 0520 */ 0x0000,
/* 0522 */ 0x0000,
/* 0524 */ 0x0000,
/* 0526 */ 0x0000,
/* 0528 */ 0x0000,
/* 052A */ 0x0000,
/* 052C */ 0x0000,
/* 052E */ 0x0000,
/* 0530 */ 0x0000,
/* 0532 */ 0x0000,
/* 0534 */ 0x0000,
/* 0536 */ 0x0000,
/* 0538 */ 0x0000,
/* 053A */ 0x0000,
/* 053C */ 0x0000,
/* 053E */ 0x0000,
/* 0540 */ 0x0000,
/* 0542 */ 0x0000,
/* 0544 */ 0x0000,
/* 0546 */ 0x0000,
/* 0548 */ 0x0000,
/* 054A */ 0x0000,
/* 054C */ 0x0000,
/* 054E */ 0x0000,
/* 0550 */ 0x0000,
/* 0552 */ 0x0000,
/* 0554 */ 0x0000,
/* 0556 */ 0x0000,
/* 0558 */ 0x0000,
/* 055A */ 0x0000,
/* 055C */ 0x0000,
/* 055E */ 0x0000,
/* 0560 */ 0x0000,
/* 0562 */ 0x0000,
/* 0564 */ 0x0000,
/* 0566 */ 0x0000,
/* 0568 */ 0x0000,
/* 056A */ 0x0000,
/* 056C */ 0x0000,
/* 056E */ 0x0000,
/* 0570 */ 0x0000,
/* 0572 */ 0x0000,
/* 0574 */ 0x0000,
/* 0576 */ 0x0000,
/* 0578 */ 0x0000,
/* 057A */ 0x0000,
/* 057C */ 0x0000,
/* 057E */ 0x0000,
/* 0580 */ 0x0000,
/* 0582 */ 0x0000,
/* 0584 */ 0x0000,
/* 0586 */ 0x0000,
/* 0588 */ 0x0000,
/* 058A */ 0x0000,
/* 058C */ 0x0000,
/* 058E */ 0x0000,
/* 0590 */ 0x0000,
/* 0592 */ 0x0000,
/* 0594 */ 0x0000,
/* 0596 */ 0x0000,
/* 0598 */ 0x0000,
/* 059A */ 0x0000,
/* 059C */ 0x0000,
/* 059E */ 0x0000,
/* 05A0 */ 0x0000,
/* 05A2 */ 0x0000,
/* 05A4 */ 0x0000,
/* 05A6 */ 0x0000,
/* 05A8 */ 0x0000,
/* 05AA */ 0x0000,
/* 05AC */ 0x0000,
/* 05AE */ 0x0000,
/* 05B0 */ 0x0000,
/* 05B2 */ 0x0000,
/* 05B4 */ 0x0000,
/* 05B6 */ 0x0000,
/* 05B8 */ 0x0000,
/* 05BA */ 0x0000,
/* 05BC */ 0x0000,
/* 05BE */ 0x0000,
/* 05C0 */ 0x0000,
/* 05C2 */ 0x0000,
/* 05C4 */ 0x0000,
/* 05C6 */ 0x0000,
/* 05C8 */ 0x0000,
/* 05CA */ 0x0000,
/* 05CC */ 0x0000,
/* 05CE */ 0x0000,
/* 05D0 */ 0x0000,
/* 05D2 */ 0x0000,
/* 05D4 */ 0x0000,
/* 05D6 */ 0x0000,
/* 05D8 */ 0x0000,
/* 05DA */ 0x0000,
/* 05DC */ 0x0000,
/* 05DE */ 0x0000,
/* 05E0 */ 0x0000,
/* 05E2 */ 0x0000,
/* 05E4 */ 0x0000,
/* 05E6 */ 0x0000,
/* 05E8 */ 0x0000,
/* 05EA */ 0x0000,
/* 05EC */ 0x0000,
/* 05EE */ 0x0000,
/* 05F0 */ 0x0000,
/* 05F2 */ 0x0000,
/* 05F4 */ 0x0000,
/* 05F6 */ 0x0000,
/* 05F8 */ 0x0000,
/* 05FA */ 0x0000,
/* 05FC */ 0x0000,
/* 05FE */ 0x0000,
/* 0600 */ 0x0000,
/* 0602 */ 0x0000,
/* 0604 */ 0x0000,
/* 0606 */ 0x0000,
/* 0608 */ 0x0000,
/* 060A */ 0x0000,
/* 060C */ 0x0000,
/* 060E */ 0x0000,
/* 0610 */ 0x0000,
/* 0612 */ 0x0000,
/* 0614 */ 0x0000,
/* 0616 */ 0x0000,
/* 0618 */ 0x0000,
/* 061A */ 0x0000,
/* 061C */ 0x0000,
/* 061E */ 0x0000,
/* 0620 */ 0x0000,
/* 0622 */ 0x0000,
/* 0624 */ 0x0000,
/* 0626 */ 0x0000,
/* 0628 */ 0x0000,
/* 062A */ 0x0000,
/* 062C */ 0x0000,
/* 062E */ 0x0000,
/* 0630 */ 0x0000,
/* 0632 */ 0x0000,
/* 0634 */ 0x0000,
/* 0636 */ 0x0000,
/* 0638 */ 0x0000,
/* 063A */ 0x0000,
/* 063C */ 0x0000,
/* 063E */ 0x0000,
/* 0640 */ 0x0000,
/* 0642 */ 0x0000,
/* 0644 */ 0x0000,
/* 0646 */ 0x0000,
/* 0648 */ 0x0000,
/* 064A */ 0x0000,
/* 064C */ 0x0000,
/* 064E */ 0x0000,
/* 0650 */ 0x0000,
/* 0652 */ 0x0000,
/* 0654 */ 0x0000,
/* 0656 */ 0x0000,
/* 0658 */ 0x0000,
/* 065A */ 0x0000,
/* 065C */ 0x0000,
/* 065E */ 0x0000,
/* 0660 */ 0x0000,
/* 0662 */ 0x0000,
/* 0664 */ 0x0000,
/* 0666 */ 0x0000,
/* 0668 */ 0x0000,
/* 066A */ 0x0000,
/* 066C */ 0x0000,
/* 066E */ 0x0000,
/* 0670 */ 0x0000,
/* 0672 */ 0x0000,
/* 0674 */ 0x0000,
/* 0676 */ 0x0000,
/* 0678 */ 0x0000,
/* 067A */ 0x0000,
/* 067C */ 0x0000,
/* 067E */ 0x0000,
/* 0680 */ 0x0000,
/* 0682 */ 0x0000,
/* 0684 */ 0x0000,
/* 0686 */ 0x0000,
/* 0688 */ 0x0000,
/* 068A */ 0x0000,
/* 068C */ 0x0000,
/* 068E */ 0x0000,
/* 0690 */ 0x0000,
/* 0692 */ 0x0000,
/* 0694 */ 0x0000,
/* 0696 */ 0x0000,
/* 0698 */ 0x0000,
/* 069A */ 0x0000,
/* 069C */ 0x0000,
/* 069E */ 0x0000,
/* 06A0 */ 0x0000,
/* 06A2 */ 0x0000,
/* 06A4 */ 0x0000,
/* 06A6 */ 0x0000,
/* 06A8 */ 0x0000,
/* 06AA */ 0x0000,
/* 06AC */ 0x0000,
/* 06AE */ 0x0000,
/* 06B0 */ 0x0000,
/* 06B2 */ 0x0000,
/* 06B4 */ 0x0000,
/* 06B6 */ 0x0000,
/* 06B8 */ 0x0000,
/* 06BA */ 0x0000,
/* 06BC */ 0x0000,
/* 06BE */ 0x0000,
/* 06C0 */ 0x0000,
/* 06C2 */ 0x0000,
/* 06C4 */ 0x0000,
/* 06C6 */ 0x0000,
/* 06C8 */ 0x0000,
/* 06CA */ 0x0000,
/* 06CC */ 0x0000,
/* 06CE */ 0x0000,
/* 06D0 */ 0x0000,
/* 06D2 */ 0x0000,
/* 06D4 */ 0x0000,
/* 06D6 */ 0x0000,
/* 06D8 */ 0x0000,
/* 06DA */ 0x0000,
/* 06DC */ 0x0000,
/* 06DE */ 0x0000,
/* 06E0 */ 0x0000,
/* 06E2 */ 0x0000,
/* 06E4 */ 0x0000,
/* 06E6 */ 0x0000,
/* 06E8 */ 0x0000,
/* 06EA */ 0x0000,
/* 06EC */ 0x0000,
/* 06EE */ 0x0000,
/* 06F0 */ 0x0000,
/* 06F2 */ 0x0000,
/* 06F4 */ 0x0000,
/* 06F6 */ 0x0000,
/* 06F8 */ 0x0000,
/* 06FA */ 0x0000,
/* 06FC */ 0x0000,
/* 06FE */ 0x0000,
/* 0700 */ 0x0000,
/* 0702 */ 0x0000,
/* 0704 */ 0x0000,
/* 0706 */ 0x0000,
/* 0708 */ 0x0000,
/* 070A */ 0x0000,
/* 070C */ 0x0000,
/* 070E */ 0x0000,
/* 0710 */ 0x0000,
/* 0712 */ 0x0000,
/* 0714 */ 0x0000,
/* 0716 */ 0x0000,
/* 0718 */ 0x0000,
/* 071A */ 0x0000,
/* 071C */ 0x0000,
/* 071E */ 0x0000,
/* 0720 */ 0x0000,
/* 0722 */ 0x0000,
/* 0724 */ 0x0000,
/* 0726 */ 0x0000,
/* 0728 */ 0x0000,
/* 072A */ 0x0000,
/* 072C */ 0x0000,
/* 072E */ 0x0000,
/* 0730 */ 0x0000,
/* 0732 */ 0x0000,
/* 0734 */ 0x0000,
/* 0736 */ 0x0000,
/* 0738 */ 0x0000,
/* 073A */ 0x0000,
/* 073C */ 0x0000,
/* 073E */ 0x0000,
/* 0740 */ 0x0000,
/* 0742 */ 0x0000,
/* 0744 */ 0x0000,
/* 0746 */ 0x0000,
/* 0748 */ 0x0000,
/* 074A */ 0x0000,
/* 074C */ 0x0000,
/* 074E */ 0x0000,
/* 0750 */ 0x0000,
/* 0752 */ 0x0000,
/* 0754 */ 0x0000,
/* 0756 */ 0x0000,
/* 0758 */ 0x0000,
/* 075A */ 0x0000,
/* 075C */ 0x0000,
/* 075E */ 0x0000,
/* 0760 */ 0x0000,
/* 0762 */ 0x0000,
/* 0764 */ 0x0000,
/* 0766 */ 0x0000,
/* 0768 */ 0x0000,
/* 076A */ 0x0000,
/* 076C */ 0x0000,
/* 076E */ 0x0000,
/* 0770 */ 0x0000,
/* 0772 */ 0x0000,
/* 0774 */ 0x0000,
/* 0776 */ 0x0000,
/* 0778 */ 0x0000,
/* 077A */ 0x0000,
/* 077C */ 0x0000,
/* 077E */ 0x0000,
/* 0780 */ 0x0000,
/* 0782 */ 0x0000,
/* 0784 */ 0x0000,
/* 0786 */ 0x0000,
/* 0788 */ 0x0000,
/* 078A */ 0x0000,
/* 078C */ 0x0000,
/* 078E */ 0x0000,
/* 0790 */ 0x0000,
/* 0792 */ 0x0000,
/* 0794 */ 0x0000,
/* 0796 */ 0x0000,
/* 0798 */ 0x0000,
/* 079A */ 0x0000,
/* 079C */ 0x0000,
/* 079E */ 0x0000,
/* 07A0 */ 0x0000,
/* 07A2 */ 0x0000,
/* 07A4 */ 0x0000,
/* 07A6 */ 0x0000,
/* 07A8 */ 0x0000,
/* 07AA */ 0x0000,
/* 07AC */ 0x0000,
/* 07AE */ 0x0000,
/* 07B0 */ 0x0000,
/* 07B2 */ 0x0000,
/* 07B4 */ 0x0000,
/* 07B6 */ 0x0000,
/* 07B8 */ 0x0000,
/* 07BA */ 0x0000,
/* 07BC */ 0x0000,
/* 07BE */ 0x0000,
/* 07C0 */ 0x0000,
/* 07C2 */ 0x0000,
/* 07C4 */ 0x0000,
/* 07C6 */ 0x0000,
/* 07C8 */ 0x0000,
/* 07CA */ 0x0000,
/* 07CC */ 0x0000,
/* 07CE */ 0x0000,
/* 07D0 */ 0x0000,
/* 07D2 */ 0x0000,
/* 07D4 */ 0x0000,
/* 07D6 */ 0x0000,
/* 07D8 */ 0x0000,
/* 07DA */ 0x0000,
/* 07DC */ 0x0000,
/* 07DE */ 0x0000,
/* 07E0 */ 0x0000,
/* 07E2 */ 0x0000,
/* 07E4 */ 0x0000,
/* 07E6 */ 0x0000,
/* 07E8 */ 0x0000,
/* 07EA */ 0x0000,
/* 07EC */ 0x0000,
/* 07EE */ 0x0000,
/* 07F0 */ 0x0000,
/* 07F2 */ 0x0000,
/* 07F4 */ 0x0000,
/* 07F6 */ 0x0000,
/* 07F8 */ 0x0000,
/* 07FA */ 0x0000,
/* 07FC */ 0x0000,
/* 07FE */ 0x0000,
/* 0800 */ 0x0000,
/* 0802 */ 0x0000,
/* 0804 */ 0x0000,
/* 0806 */ 0x0000,
/* 0808 */ 0x0000,
/* 080A */ 0x0000,
/* 080C */ 0x0000,
/* 080E */ 0x0000,
/* 0810 */ 0x0000,
/* 0812 */ 0x0000,
/* 0814 */ 0x0000,
/* 0816 */ 0x0000,
/* 0818 */ 0x0000,
/* 081A */ 0x0000,
/* 081C */ 0x0000,
/* 081E */ 0x0000,
/* 0820 */ 0x0000,
/* 0822 */ 0x0000,
/* 0824 */ 0x0000,
/* 0826 */ 0x0000,
/* 0828 */ 0x0000,
/* 082A */ 0x0000,
/* 082C */ 0x0000,
/* 082E */ 0x0000,
/* 0830 */ 0x0000,
/* 0832 */ 0x0000,
/* 0834 */ 0x0000,
/* 0836 */ 0x0000,
/* 0838 */ 0x0000,
/* 083A */ 0x0000,
/* 083C */ 0x0000,
/* 083E */ 0x0000,
/* 0840 */ 0x0000,
/* 0842 */ 0x0000,
/* 0844 */ 0x0000,
/* 0846 */ 0x0000,
/* 0848 */ 0x0000,
/* 084A */ 0x0000,
/* 084C */ 0x0000,
/* 084E */ 0x0000,
/* 0850 */ 0x0000,
/* 0852 */ 0x0000,
/* 0854 */ 0x0000,
/* 0856 */ 0x0000,
/* 0858 */ 0x0000,
/* 085A */ 0x0000,
/* 085C */ 0x0000,
/* 085E */ 0x0000,
/* 0860 */ 0x0000,
/* 0862 */ 0x0000,
/* 0864 */ 0x0000,
/* 0866 */ 0x0000,
/* 0868 */ 0x0000,
/* 086A */ 0x0000,
/* 086C */ 0x0000,
/* 086E */ 0x0000,
/* 0870 */ 0x0000,
/* 0872 */ 0x0000,
/* 0874 */ 0x0000,
/* 0876 */ 0x0000,
/* 0878 */ 0x0000,
/* 087A */ 0x0000,
/* 087C */ 0x0000,
/* 087E */ 0x0000,
/* 0880 */ 0x0000,
/* 0882 */ 0x0000,
/* 0884 */ 0x0000,
/* 0886 */ 0x0000,
/* 0888 */ 0x0000,
/* 088A */ 0x0000,
/* 088C */ 0x0000,
/* 088E */ 0x0000,
/* 0890 */ 0x0000,
/* 0892 */ 0x0000,
/* 0894 */ 0x0000,
/* 0896 */ 0x0000,
/* 0898 */ 0x0000,
/* 089A */ 0x0000,
/* 089C */ 0x0000,
/* 089E */ 0x0000,
/* 08A0 */ 0x0000,
/* 08A2 */ 0x0000,
/* 08A4 */ 0x0000,
/* 08A6 */ 0x0000,
/* 08A8 */ 0x0000,
/* 08AA */ 0x0000,
/* 08AC */ 0x0000,
/* 08AE */ 0x0000,
/* 08B0 */ 0x0000,
/* 08B2 */ 0x0000,
/* 08B4 */ 0x0000,
/* 08B6 */ 0x0000,
/* 08B8 */ 0x0000,
/* 08BA */ 0x0000,
/* 08BC */ 0x0000,
/* 08BE */ 0x0000,
/* 08C0 */ 0x0000,
/* 08C2 */ 0x0000,
/* 08C4 */ 0x0000,
/* 08C6 */ 0x0000,
/* 08C8 */ 0x0000,
/* 08CA */ 0x0000,
/* 08CC */ 0x0000,
/* 08CE */ 0x0000,
/* 08D0 */ 0x0000,
/* 08D2 */ 0x0000,
/* 08D4 */ 0x0000,
/* 08D6 */ 0x0000,
/* 08D8 */ 0x0000,
/* 08DA */ 0x0000,
/* 08DC */ 0x0000,
/* 08DE */ 0x0000,
/* 08E0 */ 0x0000,
/* 08E2 */ 0x0000,
/* 08E4 */ 0x0000,
/* 08E6 */ 0x0000,
/* 08E8 */ 0x0000,
/* 08EA */ 0x0000,
/* 08EC */ 0x0000,
/* 08EE */ 0x0000,
/* 08F0 */ 0x0000,
/* 08F2 */ 0x0000,
/* 08F4 */ 0x0000,
/* 08F6 */ 0x0000,
/* 08F8 */ 0x0000,
/* 08FA */ 0x0000,
/* 08FC */ 0x0000,
/* 08FE */ 0x0000,
/* 0900 */ 0x1ACC,
/* 0902 */ 0x0000,
/* 0904 */ 0x0000,
/* 0906 */ 0x0000,
/* 0908 */ 0x0000,
/* 090A */ 0x0880,
/* 090C */ 0x0010,
/* 090E */ 0x15F8,
/* 0910 */ 0x0000,
/* 0912 */ 0x1C7C,
/* 0914 */ 0x0320,
/* 0916 */ 0x1C7C,
/* 0918 */ 0x16A6,
/* 091A */ 0x0000,
/* 091C */ 0x0000,
/* 091E */ 0x0000,
/* 0920 */ 0x0000,
/* 0922 */ 0x7403,
/* 0924 */ 0x706D,
/* 0926 */ 0x1604,
/* 0928 */ 0x031E,
/* 092A */ 0x0922,
/* 092C */ 0x5304,
/* 092E */ 0x4150,
/* 0930 */ 0x004E,
/* 0932 */ 0x1604,
/* 0934 */ 0x0304,
/* 0936 */ 0x092C,
/* 0938 */ 0x3E03,
/* 093A */ 0x4E49,
/* 093C */ 0x1604,
/* 093E */ 0x0306,
/* 0940 */ 0x0938,
/* 0942 */ 0x2304,
/* 0944 */ 0x4954,
/* 0946 */ 0x0042,
/* 0948 */ 0x1604,
/* 094A */ 0x0308,
/* 094C */ 0x0942,
/* 094E */ 0x2704,
/* 0950 */ 0x4954,
/* 0952 */ 0x0042,
/* 0954 */ 0x1604,
/* 0956 */ 0x030A,
/* 0958 */ 0x094E,
/* 095A */ 0x4204,
/* 095C */ 0x5341,
/* 095E */ 0x0045,
/* 0960 */ 0x1604,
/* 0962 */ 0x030C,
/* 0964 */ 0x095A,
/* 0966 */ 0x2705,
/* 0968 */ 0x5645,
/* 096A */ 0x4C41,
/* 096C */ 0x1604,
/* 096E */ 0x030E,
/* 0970 */ 0x0966,
/* 0972 */ 0x4803,
/* 0974 */ 0x444C,
/* 0976 */ 0x1604,
/* 0978 */ 0x0310,
/* 097A */ 0x0972,
/* 097C */ 0x4307,
/* 097E */ 0x4E4F,
/* 0980 */ 0x4554,
/* 0982 */ 0x5458,
/* 0984 */ 0x1604,
/* 0986 */ 0x0312,
/* 0988 */ 0x097C,
/* 098A */ 0x4302,
/* 098C */ 0x0050,
/* 098E */ 0x1604,
/* 0990 */ 0x0314,
/* 0992 */ 0x098A,
/* 0994 */ 0x4C04,
/* 0996 */ 0x5341,
/* 0998 */ 0x0054,
/* 099A */ 0x1604,
/* 099C */ 0x0316,
/* 099E */ 0x0994,
/* 09A0 */ 0x2706,
/* 09A2 */ 0x4241,
/* 09A4 */ 0x524F,
/* 09A6 */ 0x0054,
/* 09A8 */ 0x1604,
/* 09AA */ 0x0318,
/* 09AC */ 0x09A0,
/* 09AE */ 0x3F03,
/* 09B0 */ 0x5852,
/* 09B2 */ 0x1602,
/* 09B4 */ 0x09AE,
/* 09B6 */ 0x5403,
/* 09B8 */ 0x2158,
/* 09BA */ 0x1603,
/* 09BC */ 0x09B6,
/* 09BE */ 0x2103,
/* 09C0 */ 0x4F49,
/* 09C2 */ 0x1600,
/* 09C4 */ 0x09BE,
/* 09C6 */ 0x6405,
/* 09C8 */ 0x4C6F,
/* 09CA */ 0x5449,
/* 09CC */ 0x1605,
/* 09CE */ 0x09C6,
/* 09D0 */ 0x4504,
/* 09D2 */ 0x4958,
/* 09D4 */ 0x0054,
/* 09D6 */ 0x1607,
/* 09D8 */ 0x09D0,
/* 09DA */ 0x4507,
/* 09DC */ 0x4558,
/* 09DE */ 0x5543,
/* 09E0 */ 0x4554,
/* 09E2 */ 0x1608,
/* 09E4 */ 0x09DA,
/* 09E6 */ 0x5107,
/* 09E8 */ 0x5242,
/* 09EA */ 0x4E41,
/* 09EC */ 0x4843,
/* 09EE */ 0x160A,
/* 09F0 */ 0x09E6,
/* 09F2 */ 0x4206,
/* 09F4 */ 0x4152,
/* 09F6 */ 0x434E,
/* 09F8 */ 0x0048,
/* 09FA */ 0x160B,
/* 09FC */ 0x09F2,
/* 09FE */ 0x6406,
/* 0A00 */ 0x4E6F,
/* 0A02 */ 0x5845,
/* 0A04 */ 0x0054,
/* 0A06 */ 0x1609,
/* 0A08 */ 0x09FE,
/* 0A0A */ 0x2101,
/* 0A0C */ 0x160C,
/* 0A0E */ 0x0A0A,
/* 0A10 */ 0x4001,
/* 0A12 */ 0x160D,
/* 0A14 */ 0x0A10,
/* 0A16 */ 0x4302,
/* 0A18 */ 0x0021,
/* 0A1A */ 0x160E,
/* 0A1C */ 0x0A16,
/* 0A1E */ 0x4302,
/* 0A20 */ 0x0040,
/* 0A22 */ 0x160F,
/* 0A24 */ 0x0A1E,
/* 0A26 */ 0x5004,
/* 0A28 */ 0x4B4F,
/* 0A2A */ 0x0045,
/* 0A2C */ 0x160E,
/* 0A2E */ 0x0A26,
/* 0A30 */ 0x5004,
/* 0A32 */ 0x4545,
/* 0A34 */ 0x004B,
/* 0A36 */ 0x160F,
/* 0A38 */ 0x0A30,
/* 0A3A */ 0x5202,
/* 0A3C */ 0x003E,
/* 0A3E */ 0x1612,
/* 0A40 */ 0x0A3A,
/* 0A42 */ 0x5202,
/* 0A44 */ 0x0040,
/* 0A46 */ 0x1613,
/* 0A48 */ 0x0A42,
/* 0A4A */ 0x3E02,
/* 0A4C */ 0x0052,
/* 0A4E */ 0x1614,
/* 0A50 */ 0x0A4A,
/* 0A52 */ 0x4404,
/* 0A54 */ 0x4F52,
/* 0A56 */ 0x0050,
/* 0A58 */ 0x1617,
/* 0A5A */ 0x0A52,
/* 0A5C */ 0x4403,
/* 0A5E */ 0x5055,
/* 0A60 */ 0x1618,
/* 0A62 */ 0x0A5C,
/* 0A64 */ 0x5304,
/* 0A66 */ 0x4157,
/* 0A68 */ 0x0050,
/* 0A6A */ 0x1619,
/* 0A6C */ 0x0A64,
/* 0A6E */ 0x4F04,
/* 0A70 */ 0x4556,
/* 0A72 */ 0x0052,
/* 0A74 */ 0x161A,
/* 0A76 */ 0x0A6E,
/* 0A78 */ 0x3002,
/* 0A7A */ 0x003C,
/* 0A7C */ 0x161B,
/* 0A7E */ 0x0A78,
/* 0A80 */ 0x4103,
/* 0A82 */ 0x444E,
/* 0A84 */ 0x161C,
/* 0A86 */ 0x0A80,
/* 0A88 */ 0x4F02,
/* 0A8A */ 0x0052,
/* 0A8C */ 0x161D,
/* 0A8E */ 0x0A88,
/* 0A90 */ 0x5803,
/* 0A92 */ 0x524F,
/* 0A94 */ 0x161E,
/* 0A96 */ 0x0A90,
/* 0A98 */ 0x5503,
/* 0A9A */ 0x2B4D,
/* 0A9C */ 0x161F,
/* 0A9E */ 0x0A98,
/* 0AA0 */ 0x6406,
/* 0AA2 */ 0x4C6F,
/* 0AA4 */ 0x5349,
/* 0AA6 */ 0x0054,
/* 0AA8 */ 0x1606,
/* 0AAA */ 0x0AA0,
/* 0AAC */ 0x6405,
/* 0AAE */ 0x436F,
/* 0AB0 */ 0x4E4F,
/* 0AB2 */ 0x1604,
/* 0AB4 */ 0x0AAC,
/* 0AB6 */ 0x6405,
/* 0AB8 */ 0x566F,
/* 0ABA */ 0x5241,
/* 0ABC */ 0x1615,
/* 0ABE */ 0x0AB6,
/* 0AC0 */ 0x3F04,
/* 0AC2 */ 0x454B,
/* 0AC4 */ 0x0059,
/* 0AC6 */ 0x0006,
/* 0AC8 */ 0x09B2,
/* 0ACA */ 0x09D6,
/* 0ACC */ 0x0AC0,
/* 0ACE */ 0x4B03,
/* 0AD0 */ 0x5945,
/* 0AD2 */ 0x0006,
/* 0AD4 */ 0x09B2,
/* 0AD6 */ 0x09EE,
/* 0AD8 */ 0x0AD4,
/* 0ADA */ 0x09D6,
/* 0ADC */ 0x0ACE,
/* 0ADE */ 0x4504,
/* 0AE0 */ 0x494D,
/* 0AE2 */ 0x0054,
/* 0AE4 */ 0x0006,
/* 0AE6 */ 0x09BA,
/* 0AE8 */ 0x09D6,
/* 0AEA */ 0x0ADE,
/* 0AEC */ 0x3F04,
/* 0AEE */ 0x5544,
/* 0AF0 */ 0x0050,
/* 0AF2 */ 0x0006,
/* 0AF4 */ 0x0A60,
/* 0AF6 */ 0x09EE,
/* 0AF8 */ 0x0AFC,
/* 0AFA */ 0x0A60,
/* 0AFC */ 0x09D6,
/* 0AFE */ 0x0AEC,
/* 0B00 */ 0x5203,
/* 0B02 */ 0x544F,
/* 0B04 */ 0x0006,
/* 0B06 */ 0x0A4E,
/* 0B08 */ 0x0A6A,
/* 0B0A */ 0x0A3E,
/* 0B0C */ 0x0A6A,
/* 0B0E */ 0x09D6,
/* 0B10 */ 0x0B00,
/* 0B12 */ 0x3205,
/* 0B14 */ 0x5244,
/* 0B16 */ 0x504F,
/* 0B18 */ 0x0006,
/* 0B1A */ 0x0A58,
/* 0B1C */ 0x0A58,
/* 0B1E */ 0x09D6,
/* 0B20 */ 0x0B12,
/* 0B22 */ 0x3204,
/* 0B24 */ 0x5544,
/* 0B26 */ 0x0050,
/* 0B28 */ 0x0006,
/* 0B2A */ 0x0A74,
/* 0B2C */ 0x0A74,
/* 0B2E */ 0x09D6,
/* 0B30 */ 0x0B22,
/* 0B32 */ 0x2B01,
/* 0B34 */ 0x0006,
/* 0B36 */ 0x0A9C,
/* 0B38 */ 0x0A58,
/* 0B3A */ 0x09D6,
/* 0B3C */ 0x0B32,
/* 0B3E */ 0x4E03,
/* 0B40 */ 0x544F,
/* 0B42 */ 0x0006,
/* 0B44 */ 0x09CC,
/* 0B46 */ 0xFFFF,
/* 0B48 */ 0x0A94,
/* 0B4A */ 0x09D6,
/* 0B4C */ 0x0B3E,
/* 0B4E */ 0x4E06,
/* 0B50 */ 0x4745,
/* 0B52 */ 0x5441,
/* 0B54 */ 0x0045,
/* 0B56 */ 0x0006,
/* 0B58 */ 0x0B42,
/* 0B5A */ 0x09CC,
/* 0B5C */ 0x0001,
/* 0B5E */ 0x0B34,
/* 0B60 */ 0x09D6,
/* 0B62 */ 0x0B4E,
/* 0B64 */ 0x4407,
/* 0B66 */ 0x454E,
/* 0B68 */ 0x4147,
/* 0B6A */ 0x4554,
/* 0B6C */ 0x0006,
/* 0B6E */ 0x0B42,
/* 0B70 */ 0x0A4E,
/* 0B72 */ 0x0B42,
/* 0B74 */ 0x09CC,
/* 0B76 */ 0x0001,
/* 0B78 */ 0x0A9C,
/* 0B7A */ 0x0A3E,
/* 0B7C */ 0x0B34,
/* 0B7E */ 0x09D6,
/* 0B80 */ 0x0B64,
/* 0B82 */ 0x2D01,
/* 0B84 */ 0x0006,
/* 0B86 */ 0x0B56,
/* 0B88 */ 0x0B34,
/* 0B8A */ 0x09D6,
/* 0B8C */ 0x0B82,
/* 0B8E */ 0x4103,
/* 0B90 */ 0x5342,
/* 0B92 */ 0x0006,
/* 0B94 */ 0x0A60,
/* 0B96 */ 0x0A7C,
/* 0B98 */ 0x09EE,
/* 0B9A */ 0x0B9E,
/* 0B9C */ 0x0B56,
/* 0B9E */ 0x09D6,
/* 0BA0 */ 0x0B8E,
/* 0BA2 */ 0x3002,
/* 0BA4 */ 0x003D,
/* 0BA6 */ 0x0006,
/* 0BA8 */ 0x09EE,
/* 0BAA */ 0x0BB2,
/* 0BAC */ 0x09CC,
/* 0BAE */ 0x0000,
/* 0BB0 */ 0x09D6,
/* 0BB2 */ 0x09CC,
/* 0BB4 */ 0xFFFF,
/* 0BB6 */ 0x09D6,
/* 0BB8 */ 0x0BA2,
/* 0BBA */ 0x3D01,
/* 0BBC */ 0x0006,
/* 0BBE */ 0x0A94,
/* 0BC0 */ 0x09EE,
/* 0BC2 */ 0x0BCA,
/* 0BC4 */ 0x09CC,
/* 0BC6 */ 0x0000,
/* 0BC8 */ 0x09D6,
/* 0BCA */ 0x09CC,
/* 0BCC */ 0xFFFF,
/* 0BCE */ 0x09D6,
/* 0BD0 */ 0x0BBA,
/* 0BD2 */ 0x5502,
/* 0BD4 */ 0x003C,
/* 0BD6 */ 0x0006,
/* 0BD8 */ 0x0B28,
/* 0BDA */ 0x0A94,
/* 0BDC */ 0x0A7C,
/* 0BDE */ 0x09EE,
/* 0BE0 */ 0x0BEA,
/* 0BE2 */ 0x0A6A,
/* 0BE4 */ 0x0A58,
/* 0BE6 */ 0x0A7C,
/* 0BE8 */ 0x09D6,
/* 0BEA */ 0x0B84,
/* 0BEC */ 0x0A7C,
/* 0BEE */ 0x09D6,
/* 0BF0 */ 0x0BD2,
/* 0BF2 */ 0x3C01,
/* 0BF4 */ 0x0006,
/* 0BF6 */ 0x0B28,
/* 0BF8 */ 0x0A94,
/* 0BFA */ 0x0A7C,
/* 0BFC */ 0x09EE,
/* 0BFE */ 0x0C06,
/* 0C00 */ 0x0A58,
/* 0C02 */ 0x0A7C,
/* 0C04 */ 0x09D6,
/* 0C06 */ 0x0B84,
/* 0C08 */ 0x0A7C,
/* 0C0A */ 0x09D6,
/* 0C0C */ 0x0BF2,
/* 0C0E */ 0x4D03,
/* 0C10 */ 0x5841,
/* 0C12 */ 0x0006,
/* 0C14 */ 0x0B28,
/* 0C16 */ 0x0BF4,
/* 0C18 */ 0x09EE,
/* 0C1A */ 0x0C1E,
/* 0C1C */ 0x0A6A,
/* 0C1E */ 0x0A58,
/* 0C20 */ 0x09D6,
/* 0C22 */ 0x0C0E,
/* 0C24 */ 0x4D03,
/* 0C26 */ 0x4E49,
/* 0C28 */ 0x0006,
/* 0C2A */ 0x0B28,
/* 0C2C */ 0x0A6A,
/* 0C2E */ 0x0BF4,
/* 0C30 */ 0x09EE,
/* 0C32 */ 0x0C36,
/* 0C34 */ 0x0A6A,
/* 0C36 */ 0x0A58,
/* 0C38 */ 0x09D6,
/* 0C3A */ 0x0C24,
/* 0C3C */ 0x5706,
/* 0C3E */ 0x5449,
/* 0C40 */ 0x4948,
/* 0C42 */ 0x004E,
/* 0C44 */ 0x0006,
/* 0C46 */ 0x0A74,
/* 0C48 */ 0x0B84,
/* 0C4A */ 0x0A4E,
/* 0C4C */ 0x0B84,
/* 0C4E */ 0x0A3E,
/* 0C50 */ 0x0BD6,
/* 0C52 */ 0x09D6,
/* 0C54 */ 0x0C3C,
/* 0C56 */ 0x5506,
/* 0C58 */ 0x2F4D,
/* 0C5A */ 0x4F4D,
/* 0C5C */ 0x0044,
/* 0C5E */ 0x0006,
/* 0C60 */ 0x0B28,
/* 0C62 */ 0x0BD6,
/* 0C64 */ 0x09EE,
/* 0C66 */ 0x0CB4,
/* 0C68 */ 0x0B56,
/* 0C6A */ 0x09CC,
/* 0C6C */ 0x000F,
/* 0C6E */ 0x0A4E,
/* 0C70 */ 0x0A4E,
/* 0C72 */ 0x0A60,
/* 0C74 */ 0x0A9C,
/* 0C76 */ 0x0A4E,
/* 0C78 */ 0x0A4E,
/* 0C7A */ 0x0A60,
/* 0C7C */ 0x0A9C,
/* 0C7E */ 0x0A3E,
/* 0C80 */ 0x0B34,
/* 0C82 */ 0x0A60,
/* 0C84 */ 0x0A3E,
/* 0C86 */ 0x0A46,
/* 0C88 */ 0x0A6A,
/* 0C8A */ 0x0A4E,
/* 0C8C */ 0x0A9C,
/* 0C8E */ 0x0A3E,
/* 0C90 */ 0x0A8C,
/* 0C92 */ 0x09EE,
/* 0C94 */ 0x0CA6,
/* 0C96 */ 0x0A4E,
/* 0C98 */ 0x0A58,
/* 0C9A */ 0x09CC,
/* 0C9C */ 0x0001,
/* 0C9E */ 0x0B34,
/* 0CA0 */ 0x0A3E,
/* 0CA2 */ 0x09FA,
/* 0CA4 */ 0x0CA8,
/* 0CA6 */ 0x0A58,
/* 0CA8 */ 0x0A3E,
/* 0CAA */ 0x0A06,
/* 0CAC */ 0x0C70,
/* 0CAE */ 0x0A58,
/* 0CB0 */ 0x0A6A,
/* 0CB2 */ 0x09D6,
/* 0CB4 */ 0x0A58,
/* 0CB6 */ 0x0B18,
/* 0CB8 */ 0x09CC,
/* 0CBA */ 0xFFFF,
/* 0CBC */ 0x0A60,
/* 0CBE */ 0x09D6,
/* 0CC0 */ 0x0C56,
/* 0CC2 */ 0x4D05,
/* 0CC4 */ 0x4D2F,
/* 0CC6 */ 0x444F,
/* 0CC8 */ 0x0006,
/* 0CCA */ 0x0A60,
/* 0CCC */ 0x0A7C,
/* 0CCE */ 0x0A60,
/* 0CD0 */ 0x0A4E,
/* 0CD2 */ 0x09EE,
/* 0CD4 */ 0x0CDE,
/* 0CD6 */ 0x0B56,
/* 0CD8 */ 0x0A4E,
/* 0CDA */ 0x0B6C,
/* 0CDC */ 0x0A3E,
/* 0CDE */ 0x0A4E,
/* 0CE0 */ 0x0A60,
/* 0CE2 */ 0x0A7C,
/* 0CE4 */ 0x09EE,
/* 0CE6 */ 0x0CEC,
/* 0CE8 */ 0x0A46,
/* 0CEA */ 0x0B34,
/* 0CEC */ 0x0A3E,
/* 0CEE */ 0x0C5E,
/* 0CF0 */ 0x0A3E,
/* 0CF2 */ 0x09EE,
/* 0CF4 */ 0x0CFC,
/* 0CF6 */ 0x0A6A,
/* 0CF8 */ 0x0B56,
/* 0CFA */ 0x0A6A,
/* 0CFC */ 0x09D6,
/* 0CFE */ 0x0CC2,
/* 0D00 */ 0x2F04,
/* 0D02 */ 0x4F4D,
/* 0D04 */ 0x0044,
/* 0D06 */ 0x0006,
/* 0D08 */ 0x0A74,
/* 0D0A */ 0x0A7C,
/* 0D0C */ 0x0A6A,
/* 0D0E */ 0x0CC8,
/* 0D10 */ 0x09D6,
/* 0D12 */ 0x0D00,
/* 0D14 */ 0x4D03,
/* 0D16 */ 0x444F,
/* 0D18 */ 0x0006,
/* 0D1A */ 0x0D06,
/* 0D1C */ 0x0A58,
/* 0D1E */ 0x09D6,
/* 0D20 */ 0x0D14,
/* 0D22 */ 0x2F01,
/* 0D24 */ 0x0006,
/* 0D26 */ 0x0D06,
/* 0D28 */ 0x0A6A,
/* 0D2A */ 0x0A58,
/* 0D2C */ 0x09D6,
/* 0D2E */ 0x0D22,
/* 0D30 */ 0x5503,
/* 0D32 */ 0x2A4D,
/* 0D34 */ 0x0006,
/* 0D36 */ 0x09CC,
/* 0D38 */ 0x0000,
/* 0D3A */ 0x0A6A,
/* 0D3C */ 0x09CC,
/* 0D3E */ 0x000F,
/* 0D40 */ 0x0A4E,
/* 0D42 */ 0x0A60,
/* 0D44 */ 0x0A9C,
/* 0D46 */ 0x0A4E,
/* 0D48 */ 0x0A4E,
/* 0D4A */ 0x0A60,
/* 0D4C */ 0x0A9C,
/* 0D4E */ 0x0A3E,
/* 0D50 */ 0x0B34,
/* 0D52 */ 0x0A3E,
/* 0D54 */ 0x09EE,
/* 0D56 */ 0x0D62,
/* 0D58 */ 0x0A4E,
/* 0D5A */ 0x0A74,
/* 0D5C */ 0x0A9C,
/* 0D5E */ 0x0A3E,
/* 0D60 */ 0x0B34,
/* 0D62 */ 0x0A06,
/* 0D64 */ 0x0D42,
/* 0D66 */ 0x0B04,
/* 0D68 */ 0x0A58,
/* 0D6A */ 0x09D6,
/* 0D6C */ 0x0D30,
/* 0D6E */ 0x2A01,
/* 0D70 */ 0x0006,
/* 0D72 */ 0x0D34,
/* 0D74 */ 0x0A58,
/* 0D76 */ 0x09D6,
/* 0D78 */ 0x0D6E,
/* 0D7A */ 0x4D02,
/* 0D7C */ 0x002A,
/* 0D7E */ 0x0006,
/* 0D80 */ 0x0B28,
/* 0D82 */ 0x0A94,
/* 0D84 */ 0x0A7C,
/* 0D86 */ 0x0A4E,
/* 0D88 */ 0x0B92,
/* 0D8A */ 0x0A6A,
/* 0D8C */ 0x0B92,
/* 0D8E */ 0x0D34,
/* 0D90 */ 0x0A3E,
/* 0D92 */ 0x09EE,
/* 0D94 */ 0x0D98,
/* 0D96 */ 0x0B6C,
/* 0D98 */ 0x09D6,
/* 0D9A */ 0x0D7A,
/* 0D9C */ 0x2A05,
/* 0D9E */ 0x4D2F,
/* 0DA0 */ 0x444F,
/* 0DA2 */ 0x0006,
/* 0DA4 */ 0x0A4E,
/* 0DA6 */ 0x0D7E,
/* 0DA8 */ 0x0A3E,
/* 0DAA */ 0x0CC8,
/* 0DAC */ 0x09D6,
/* 0DAE */ 0x0D9C,
/* 0DB0 */ 0x2A02,
/* 0DB2 */ 0x002F,
/* 0DB4 */ 0x0006,
/* 0DB6 */ 0x0DA2,
/* 0DB8 */ 0x0A6A,
/* 0DBA */ 0x0A58,
/* 0DBC */ 0x09D6,
/* 0DBE */ 0x0DB0,
/* 0DC0 */ 0x3102,
/* 0DC2 */ 0x002D,
/* 0DC4 */ 0x0006,
/* 0DC6 */ 0x09CC,
/* 0DC8 */ 0xFFFF,
/* 0DCA */ 0x0B34,
/* 0DCC */ 0x09D6,
/* 0DCE */ 0x0DC0,
/* 0DD0 */ 0x3102,
/* 0DD2 */ 0x002B,
/* 0DD4 */ 0x0006,
/* 0DD6 */ 0x09CC,
/* 0DD8 */ 0x0001,
/* 0DDA */ 0x0B34,
/* 0DDC */ 0x09D6,
/* 0DDE */ 0x0DD0,
/* 0DE0 */ 0x3202,
/* 0DE2 */ 0x002D,
/* 0DE4 */ 0x0006,
/* 0DE6 */ 0x09CC,
/* 0DE8 */ 0xFFFE,
/* 0DEA */ 0x0B34,
/* 0DEC */ 0x09D6,
/* 0DEE */ 0x0DE0,
/* 0DF0 */ 0x3202,
/* 0DF2 */ 0x002B,
/* 0DF4 */ 0x0006,
/* 0DF6 */ 0x09CC,
/* 0DF8 */ 0x0002,
/* 0DFA */ 0x0B34,
/* 0DFC */ 0x09D6,
/* 0DFE */ 0x0DF0,
/* 0E00 */ 0x3202,
/* 0E02 */ 0x002A,
/* 0E04 */ 0x0006,
/* 0E06 */ 0x0A60,
/* 0E08 */ 0x0B34,
/* 0E0A */ 0x09D6,
/* 0E0C */ 0x0E00,
/* 0E0E */ 0x3202,
/* 0E10 */ 0x002F,
/* 0E12 */ 0x0006,
/* 0E14 */ 0x09CC,
/* 0E16 */ 0x0002,
/* 0E18 */ 0x0D24,
/* 0E1A */ 0x09D6,
/* 0E1C */ 0x0E0E,
/* 0E1E */ 0x4202,
/* 0E20 */ 0x004C,
/* 0E22 */ 0x0006,
/* 0E24 */ 0x09CC,
/* 0E26 */ 0x0020,
/* 0E28 */ 0x09D6,
/* 0E2A */ 0x0E1E,
/* 0E2C */ 0x3E05,
/* 0E2E */ 0x4843,
/* 0E30 */ 0x5241,
/* 0E32 */ 0x0006,
/* 0E34 */ 0x09CC,
/* 0E36 */ 0x007F,
/* 0E38 */ 0x0A84,
/* 0E3A */ 0x0A60,
/* 0E3C */ 0x09CC,
/* 0E3E */ 0x007F,
/* 0E40 */ 0x0E22,
/* 0E42 */ 0x0C44,
/* 0E44 */ 0x09EE,
/* 0E46 */ 0x0E4E,
/* 0E48 */ 0x0A58,
/* 0E4A */ 0x09CC,
/* 0E4C */ 0x005F,
/* 0E4E */ 0x09D6,
/* 0E50 */ 0x0E2C,
/* 0E52 */ 0x4107,
/* 0E54 */ 0x494C,
/* 0E56 */ 0x4E47,
/* 0E58 */ 0x4445,
/* 0E5A */ 0x0006,
/* 0E5C */ 0x0DD4,
/* 0E5E */ 0x09CC,
/* 0E60 */ 0xFFFE,
/* 0E62 */ 0x0A84,
/* 0E64 */ 0x09D6,
/* 0E66 */ 0x0E52,
/* 0E68 */ 0x2B02,
/* 0E6A */ 0x0021,
/* 0E6C */ 0x0006,
/* 0E6E */ 0x0A6A,
/* 0E70 */ 0x0A74,
/* 0E72 */ 0x0A12,
/* 0E74 */ 0x0B34,
/* 0E76 */ 0x0A6A,
/* 0E78 */ 0x0A0C,
/* 0E7A */ 0x09D6,
/* 0E7C */ 0x0E68,
/* 0E7E */ 0x3202,
/* 0E80 */ 0x0021,
/* 0E82 */ 0x0006,
/* 0E84 */ 0x0A6A,
/* 0E86 */ 0x0A74,
/* 0E88 */ 0x0A0C,
/* 0E8A */ 0x0DF4,
/* 0E8C */ 0x0A0C,
/* 0E8E */ 0x09D6,
/* 0E90 */ 0x0E7E,
/* 0E92 */ 0x3202,
/* 0E94 */ 0x0040,
/* 0E96 */ 0x0006,
/* 0E98 */ 0x0A60,
/* 0E9A */ 0x0DF4,
/* 0E9C */ 0x0A12,
/* 0E9E */ 0x0A6A,
/* 0EA0 */ 0x0A12,
/* 0EA2 */ 0x09D6,
/* 0EA4 */ 0x0E92,
/* 0EA6 */ 0x4305,
/* 0EA8 */ 0x554F,
/* 0EAA */ 0x544E,
/* 0EAC */ 0x0006,
/* 0EAE */ 0x0A60,
/* 0EB0 */ 0x0DD4,
/* 0EB2 */ 0x0A6A,
/* 0EB4 */ 0x0A22,
/* 0EB6 */ 0x09D6,
/* 0EB8 */ 0x0EA6,
/* 0EBA */ 0x4804,
/* 0EBC */ 0x5245,
/* 0EBE */ 0x0045,
/* 0EC0 */ 0x0006,
/* 0EC2 */ 0x098E,
/* 0EC4 */ 0x0A12,
/* 0EC6 */ 0x09D6,
/* 0EC8 */ 0x0EBA,
/* 0ECA */ 0x5003,
/* 0ECC */ 0x4441,
/* 0ECE */ 0x0006,
/* 0ED0 */ 0x0EC0,
/* 0ED2 */ 0x09CC,
/* 0ED4 */ 0x0050,
/* 0ED6 */ 0x0B34,
/* 0ED8 */ 0x09D6,
/* 0EDA */ 0x0ECA,
/* 0EDC */ 0x5403,
/* 0EDE */ 0x4249,
/* 0EE0 */ 0x0006,
/* 0EE2 */ 0x0948,
/* 0EE4 */ 0x0DF4,
/* 0EE6 */ 0x0A12,
/* 0EE8 */ 0x09D6,
/* 0EEA */ 0x0EDC,
/* 0EEC */ 0x4008,
/* 0EEE */ 0x5845,
/* 0EF0 */ 0x4345,
/* 0EF2 */ 0x5455,
/* 0EF4 */ 0x0045,
/* 0EF6 */ 0x0006,
/* 0EF8 */ 0x0A12,
/* 0EFA */ 0x0AF2,
/* 0EFC */ 0x09EE,
/* 0EFE */ 0x0F02,
/* 0F00 */ 0x09E2,
/* 0F02 */ 0x09D6,
/* 0F04 */ 0x0EEC,
/* 0F06 */ 0x4305,
/* 0F08 */ 0x4F4D,
/* 0F0A */ 0x4556,
/* 0F0C */ 0x0006,
/* 0F0E */ 0x0A4E,
/* 0F10 */ 0x09FA,
/* 0F12 */ 0x0F20,
/* 0F14 */ 0x0A4E,
/* 0F16 */ 0x0EAC,
/* 0F18 */ 0x0A46,
/* 0F1A */ 0x0A1A,
/* 0F1C */ 0x0A3E,
/* 0F1E */ 0x0DD4,
/* 0F20 */ 0x0A06,
/* 0F22 */ 0x0F14,
/* 0F24 */ 0x0B18,
/* 0F26 */ 0x09D6,
/* 0F28 */ 0x0F06,
/* 0F2A */ 0x4604,
/* 0F2C */ 0x4C49,
/* 0F2E */ 0x004C,
/* 0F30 */ 0x0006,
/* 0F32 */ 0x0A6A,
/* 0F34 */ 0x0A4E,
/* 0F36 */ 0x0A6A,
/* 0F38 */ 0x09FA,
/* 0F3A */ 0x0F42,
/* 0F3C */ 0x0B28,
/* 0F3E */ 0x0A1A,
/* 0F40 */ 0x0DD4,
/* 0F42 */ 0x0A06,
/* 0F44 */ 0x0F3C,
/* 0F46 */ 0x0B18,
/* 0F48 */ 0x09D6,
/* 0F4A */ 0x0F2A,
/* 0F4C */ 0x4505,
/* 0F4E */ 0x4152,
/* 0F50 */ 0x4553,
/* 0F52 */ 0x0006,
/* 0F54 */ 0x09CC,
/* 0F56 */ 0x0000,
/* 0F58 */ 0x0F30,
/* 0F5A */ 0x09D6,
/* 0F5C */ 0x0F4C,
/* 0F5E */ 0x4405,
/* 0F60 */ 0x4749,
/* 0F62 */ 0x5449,
/* 0F64 */ 0x0006,
/* 0F66 */ 0x09CC,
/* 0F68 */ 0x0009,
/* 0F6A */ 0x0A74,
/* 0F6C */ 0x0BF4,
/* 0F6E */ 0x09CC,
/* 0F70 */ 0x0007,
/* 0F72 */ 0x0A84,
/* 0F74 */ 0x0B34,
/* 0F76 */ 0x09CC,
/* 0F78 */ 0x0030,
/* 0F7A */ 0x0B34,
/* 0F7C */ 0x09D6,
/* 0F7E */ 0x0F5E,
/* 0F80 */ 0x4507,
/* 0F82 */ 0x5458,
/* 0F84 */ 0x4152,
/* 0F86 */ 0x5443,
/* 0F88 */ 0x0006,
/* 0F8A */ 0x09CC,
/* 0F8C */ 0x0000,
/* 0F8E */ 0x0A6A,
/* 0F90 */ 0x0C5E,
/* 0F92 */ 0x0A6A,
/* 0F94 */ 0x0F64,
/* 0F96 */ 0x09D6,
/* 0F98 */ 0x0F80,
/* 0F9A */ 0x3C02,
/* 0F9C */ 0x0023,
/* 0F9E */ 0x0006,
/* 0FA0 */ 0x0ECE,
/* 0FA2 */ 0x0976,
/* 0FA4 */ 0x0A0C,
/* 0FA6 */ 0x09D6,
/* 0FA8 */ 0x0F9A,
/* 0FAA */ 0x4804,
/* 0FAC */ 0x4C4F,
/* 0FAE */ 0x0044,
/* 0FB0 */ 0x0006,
/* 0FB2 */ 0x0976,
/* 0FB4 */ 0x0A12,
/* 0FB6 */ 0x0DC4,
/* 0FB8 */ 0x0A60,
/* 0FBA */ 0x0976,
/* 0FBC */ 0x0A0C,
/* 0FBE */ 0x0A1A,
/* 0FC0 */ 0x09D6,
/* 0FC2 */ 0x0FAA,
/* 0FC4 */ 0x2301,
/* 0FC6 */ 0x0006,
/* 0FC8 */ 0x0960,
/* 0FCA */ 0x0A12,
/* 0FCC */ 0x0F88,
/* 0FCE */ 0x0FB0,
/* 0FD0 */ 0x09D6,
/* 0FD2 */ 0x0FC4,
/* 0FD4 */ 0x2302,
/* 0FD6 */ 0x0053,
/* 0FD8 */ 0x0006,
/* 0FDA */ 0x0FC6,
/* 0FDC */ 0x0A60,
/* 0FDE */ 0x09EE,
/* 0FE0 */ 0x0FE6,
/* 0FE2 */ 0x09FA,
/* 0FE4 */ 0x0FDA,
/* 0FE6 */ 0x09D6,
/* 0FE8 */ 0x0FD4,
/* 0FEA */ 0x5304,
/* 0FEC */ 0x4749,
/* 0FEE */ 0x004E,
/* 0FF0 */ 0x0006,
/* 0FF2 */ 0x0A7C,
/* 0FF4 */ 0x09EE,
/* 0FF6 */ 0x0FFE,
/* 0FF8 */ 0x09CC,
/* 0FFA */ 0x002D,
/* 0FFC */ 0x0FB0,
/* 0FFE */ 0x09D6,
/* 1000 */ 0x0FEA,
/* 1002 */ 0x2302,
/* 1004 */ 0x003E,
/* 1006 */ 0x0006,
/* 1008 */ 0x0A58,
/* 100A */ 0x0976,
/* 100C */ 0x0A12,
/* 100E */ 0x0ECE,
/* 1010 */ 0x0A74,
/* 1012 */ 0x0B84,
/* 1014 */ 0x09D6,
/* 1016 */ 0x1002,
/* 1018 */ 0x7303,
/* 101A */ 0x7274,
/* 101C */ 0x0006,
/* 101E */ 0x0A60,
/* 1020 */ 0x0A4E,
/* 1022 */ 0x0B92,
/* 1024 */ 0x0F9E,
/* 1026 */ 0x0FD8,
/* 1028 */ 0x0A3E,
/* 102A */ 0x0FF0,
/* 102C */ 0x1006,
/* 102E */ 0x09D6,
/* 1030 */ 0x1018,
/* 1032 */ 0x4803,
/* 1034 */ 0x5845,
/* 1036 */ 0x0006,
/* 1038 */ 0x09CC,
/* 103A */ 0x0010,
/* 103C */ 0x0960,
/* 103E */ 0x0A0C,
/* 1040 */ 0x09D6,
/* 1042 */ 0x1032,
/* 1044 */ 0x4407,
/* 1046 */ 0x4345,
/* 1048 */ 0x4D49,
/* 104A */ 0x4C41,
/* 104C */ 0x0006,
/* 104E */ 0x09CC,
/* 1050 */ 0x000A,
/* 1052 */ 0x0960,
/* 1054 */ 0x0A0C,
/* 1056 */ 0x09D6,
/* 1058 */ 0x1044,
/* 105A */ 0x5505,
/* 105C */ 0x5050,
/* 105E */ 0x5245,
/* 1060 */ 0x0006,
/* 1062 */ 0x0A60,
/* 1064 */ 0x09CC,
/* 1066 */ 0x0061,
/* 1068 */ 0x09CC,
/* 106A */ 0x007B,
/* 106C */ 0x0C44,
/* 106E */ 0x09EE,
/* 1070 */ 0x1078,
/* 1072 */ 0x09CC,
/* 1074 */ 0x005F,
/* 1076 */ 0x0A84,
/* 1078 */ 0x09D6,
/* 107A */ 0x105A,
/* 107C */ 0x3E06,
/* 107E */ 0x5055,
/* 1080 */ 0x4550,
/* 1082 */ 0x0052,
/* 1084 */ 0x0006,
/* 1086 */ 0x0EAC,
/* 1088 */ 0x0A4E,
/* 108A */ 0x09FA,
/* 108C */ 0x109A,
/* 108E */ 0x0A60,
/* 1090 */ 0x0A22,
/* 1092 */ 0x1060,
/* 1094 */ 0x0A74,
/* 1096 */ 0x0A1A,
/* 1098 */ 0x0DD4,
/* 109A */ 0x0A06,
/* 109C */ 0x108E,
/* 109E */ 0x0A58,
/* 10A0 */ 0x09D6,
/* 10A2 */ 0x107C,
/* 10A4 */ 0x4406,
/* 10A6 */ 0x4749,
/* 10A8 */ 0x5449,
/* 10AA */ 0x003F,
/* 10AC */ 0x0006,
/* 10AE */ 0x0A4E,
/* 10B0 */ 0x09CC,
/* 10B2 */ 0x0030,
/* 10B4 */ 0x0B84,
/* 10B6 */ 0x09CC,
/* 10B8 */ 0x0009,
/* 10BA */ 0x0A74,
/* 10BC */ 0x0BF4,
/* 10BE */ 0x09EE,
/* 10C0 */ 0x10D2,
/* 10C2 */ 0x09CC,
/* 10C4 */ 0x0007,
/* 10C6 */ 0x0B84,
/* 10C8 */ 0x0A60,
/* 10CA */ 0x09CC,
/* 10CC */ 0x000A,
/* 10CE */ 0x0BF4,
/* 10D0 */ 0x0A8C,
/* 10D2 */ 0x0A60,
/* 10D4 */ 0x0A3E,
/* 10D6 */ 0x0BD6,
/* 10D8 */ 0x09D6,
/* 10DA */ 0x10A4,
/* 10DC */ 0x4E07,
/* 10DE */ 0x4D55,
/* 10E0 */ 0x4542,
/* 10E2 */ 0x3F52,
/* 10E4 */ 0x0006,
/* 10E6 */ 0x0960,
/* 10E8 */ 0x0A12,
/* 10EA */ 0x0A4E,
/* 10EC */ 0x09CC,
/* 10EE */ 0x0000,
/* 10F0 */ 0x0A74,
/* 10F2 */ 0x0EAC,
/* 10F4 */ 0x0A74,
/* 10F6 */ 0x0A22,
/* 10F8 */ 0x09CC,
/* 10FA */ 0x0024,
/* 10FC */ 0x0BBC,
/* 10FE */ 0x09EE,
/* 1100 */ 0x110C,
/* 1102 */ 0x1036,
/* 1104 */ 0x0A6A,
/* 1106 */ 0x0DD4,
/* 1108 */ 0x0A6A,
/* 110A */ 0x0DC4,
/* 110C */ 0x0A74,
/* 110E */ 0x0A22,
/* 1110 */ 0x09CC,
/* 1112 */ 0x002D,
/* 1114 */ 0x0BBC,
/* 1116 */ 0x0A4E,
/* 1118 */ 0x0A6A,
/* 111A */ 0x0A46,
/* 111C */ 0x0B84,
/* 111E */ 0x0A6A,
/* 1120 */ 0x0A46,
/* 1122 */ 0x0B34,
/* 1124 */ 0x0AF2,
/* 1126 */ 0x09EE,
/* 1128 */ 0x116E,
/* 112A */ 0x0DC4,
/* 112C */ 0x0A4E,
/* 112E */ 0x0A60,
/* 1130 */ 0x0A4E,
/* 1132 */ 0x0A22,
/* 1134 */ 0x0960,
/* 1136 */ 0x0A12,
/* 1138 */ 0x10AC,
/* 113A */ 0x09EE,
/* 113C */ 0x1160,
/* 113E */ 0x0A6A,
/* 1140 */ 0x0960,
/* 1142 */ 0x0A12,
/* 1144 */ 0x0D70,
/* 1146 */ 0x0B34,
/* 1148 */ 0x0A3E,
/* 114A */ 0x0DD4,
/* 114C */ 0x0A06,
/* 114E */ 0x112E,
/* 1150 */ 0x0A58,
/* 1152 */ 0x0A46,
/* 1154 */ 0x09EE,
/* 1156 */ 0x115A,
/* 1158 */ 0x0B56,
/* 115A */ 0x0A6A,
/* 115C */ 0x09FA,
/* 115E */ 0x116C,
/* 1160 */ 0x0A3E,
/* 1162 */ 0x0A3E,
/* 1164 */ 0x0B18,
/* 1166 */ 0x0B18,
/* 1168 */ 0x09CC,
/* 116A */ 0x0000,
/* 116C */ 0x0A60,
/* 116E */ 0x0A3E,
/* 1170 */ 0x0B18,
/* 1172 */ 0x0A3E,
/* 1174 */ 0x0960,
/* 1176 */ 0x0A0C,
/* 1178 */ 0x09D6,
/* 117A */ 0x10DC,
/* 117C */ 0x5305,
/* 117E */ 0x4150,
/* 1180 */ 0x4543,
/* 1182 */ 0x0006,
/* 1184 */ 0x0E22,
/* 1186 */ 0x0AE4,
/* 1188 */ 0x09D6,
/* 118A */ 0x117C,
/* 118C */ 0x4305,
/* 118E */ 0x4148,
/* 1190 */ 0x5352,
/* 1192 */ 0x0006,
/* 1194 */ 0x0A6A,
/* 1196 */ 0x09CC,
/* 1198 */ 0x0000,
/* 119A */ 0x0C12,
/* 119C */ 0x0A4E,
/* 119E */ 0x09FA,
/* 11A0 */ 0x11A6,
/* 11A2 */ 0x0A60,
/* 11A4 */ 0x0AE4,
/* 11A6 */ 0x0A06,
/* 11A8 */ 0x11A2,
/* 11AA */ 0x0A58,
/* 11AC */ 0x09D6,
/* 11AE */ 0x118C,
/* 11B0 */ 0x5306,
/* 11B2 */ 0x4150,
/* 11B4 */ 0x4543,
/* 11B6 */ 0x0053,
/* 11B8 */ 0x0006,
/* 11BA */ 0x0E22,
/* 11BC */ 0x1192,
/* 11BE */ 0x09D6,
/* 11C0 */ 0x11B0,
/* 11C2 */ 0x5404,
/* 11C4 */ 0x5059,
/* 11C6 */ 0x0045,
/* 11C8 */ 0x0006,
/* 11CA */ 0x0A4E,
/* 11CC */ 0x09FA,
/* 11CE */ 0x11D6,
/* 11D0 */ 0x0EAC,
/* 11D2 */ 0x0E32,
/* 11D4 */ 0x0AE4,
/* 11D6 */ 0x0A06,
/* 11D8 */ 0x11D0,
/* 11DA */ 0x0A58,
/* 11DC */ 0x09D6,
/* 11DE */ 0x11C2,
/* 11E0 */ 0x4302,
/* 11E2 */ 0x0052,
/* 11E4 */ 0x0006,
/* 11E6 */ 0x09CC,
/* 11E8 */ 0x000D,
/* 11EA */ 0x0AE4,
/* 11EC */ 0x09CC,
/* 11EE */ 0x000A,
/* 11F0 */ 0x0AE4,
/* 11F2 */ 0x09D6,
/* 11F4 */ 0x11E0,
/* 11F6 */ 0x6403,
/* 11F8 */ 0x246F,
/* 11FA */ 0x0006,
/* 11FC */ 0x0A3E,
/* 11FE */ 0x0A46,
/* 1200 */ 0x0A3E,
/* 1202 */ 0x0EAC,
/* 1204 */ 0x0B34,
/* 1206 */ 0x0E5A,
/* 1208 */ 0x0A4E,
/* 120A */ 0x0A6A,
/* 120C */ 0x0A4E,
/* 120E */ 0x09D6,
/* 1210 */ 0x11F6,
/* 1212 */ 0x2443,
/* 1214 */ 0x7C22,
/* 1216 */ 0x0006,
/* 1218 */ 0x11FA,
/* 121A */ 0x09D6,
/* 121C */ 0x1212,
/* 121E */ 0x2E43,
/* 1220 */ 0x7C22,
/* 1222 */ 0x0006,
/* 1224 */ 0x11FA,
/* 1226 */ 0x0EAC,
/* 1228 */ 0x11C8,
/* 122A */ 0x09D6,
/* 122C */ 0x121E,
/* 122E */ 0x2E02,
/* 1230 */ 0x0052,
/* 1232 */ 0x0006,
/* 1234 */ 0x0A4E,
/* 1236 */ 0x101C,
/* 1238 */ 0x0A3E,
/* 123A */ 0x0A74,
/* 123C */ 0x0B84,
/* 123E */ 0x11B8,
/* 1240 */ 0x11C8,
/* 1242 */ 0x09D6,
/* 1244 */ 0x122E,
/* 1246 */ 0x5503,
/* 1248 */ 0x522E,
/* 124A */ 0x0006,
/* 124C */ 0x0A4E,
/* 124E */ 0x0F9E,
/* 1250 */ 0x0FD8,
/* 1252 */ 0x1006,
/* 1254 */ 0x0A3E,
/* 1256 */ 0x0A74,
/* 1258 */ 0x0B84,
/* 125A */ 0x11B8,
/* 125C */ 0x11C8,
/* 125E */ 0x09D6,
/* 1260 */ 0x1246,
/* 1262 */ 0x5502,
/* 1264 */ 0x002E,
/* 1266 */ 0x0006,
/* 1268 */ 0x0F9E,
/* 126A */ 0x0FD8,
/* 126C */ 0x1006,
/* 126E */ 0x1182,
/* 1270 */ 0x11C8,
/* 1272 */ 0x09D6,
/* 1274 */ 0x1262,
/* 1276 */ 0x2E01,
/* 1278 */ 0x0006,
/* 127A */ 0x0960,
/* 127C */ 0x0A12,
/* 127E */ 0x09CC,
/* 1280 */ 0x000A,
/* 1282 */ 0x0A94,
/* 1284 */ 0x09EE,
/* 1286 */ 0x128C,
/* 1288 */ 0x1266,
/* 128A */ 0x09D6,
/* 128C */ 0x101C,
/* 128E */ 0x1182,
/* 1290 */ 0x11C8,
/* 1292 */ 0x09D6,
/* 1294 */ 0x1276,
/* 1296 */ 0x3F01,
/* 1298 */ 0x0006,
/* 129A */ 0x0A12,
/* 129C */ 0x1278,
/* 129E */ 0x09D6,
/* 12A0 */ 0x1296,
/* 12A2 */ 0x2807,
/* 12A4 */ 0x6170,
/* 12A6 */ 0x7372,
/* 12A8 */ 0x2965,
/* 12AA */ 0x0006,
/* 12AC */ 0x0926,
/* 12AE */ 0x0A0C,
/* 12B0 */ 0x0A74,
/* 12B2 */ 0x0A4E,
/* 12B4 */ 0x0A60,
/* 12B6 */ 0x09EE,
/* 12B8 */ 0x1334,
/* 12BA */ 0x0DC4,
/* 12BC */ 0x0926,
/* 12BE */ 0x0A22,
/* 12C0 */ 0x0E22,
/* 12C2 */ 0x0BBC,
/* 12C4 */ 0x09EE,
/* 12C6 */ 0x12EE,
/* 12C8 */ 0x0A4E,
/* 12CA */ 0x0E22,
/* 12CC */ 0x0A74,
/* 12CE */ 0x0A22,
/* 12D0 */ 0x0B84,
/* 12D2 */ 0x0A7C,
/* 12D4 */ 0x0B42,
/* 12D6 */ 0x09EE,
/* 12D8 */ 0x12EC,
/* 12DA */ 0x0DD4,
/* 12DC */ 0x0A06,
/* 12DE */ 0x12CA,
/* 12E0 */ 0x0A3E,
/* 12E2 */ 0x0A58,
/* 12E4 */ 0x09CC,
/* 12E6 */ 0x0000,
/* 12E8 */ 0x0A60,
/* 12EA */ 0x09D6,
/* 12EC */ 0x0A3E,
/* 12EE */ 0x0A74,
/* 12F0 */ 0x0A6A,
/* 12F2 */ 0x0A4E,
/* 12F4 */ 0x0926,
/* 12F6 */ 0x0A22,
/* 12F8 */ 0x0A74,
/* 12FA */ 0x0A22,
/* 12FC */ 0x0B84,
/* 12FE */ 0x0926,
/* 1300 */ 0x0A22,
/* 1302 */ 0x0E22,
/* 1304 */ 0x0BBC,
/* 1306 */ 0x09EE,
/* 1308 */ 0x130C,
/* 130A */ 0x0A7C,
/* 130C */ 0x09EE,
/* 130E */ 0x131E,
/* 1310 */ 0x0DD4,
/* 1312 */ 0x0A06,
/* 1314 */ 0x12F4,
/* 1316 */ 0x0A60,
/* 1318 */ 0x0A4E,
/* 131A */ 0x09FA,
/* 131C */ 0x1328,
/* 131E */ 0x0A3E,
/* 1320 */ 0x0A58,
/* 1322 */ 0x0A60,
/* 1324 */ 0x0DD4,
/* 1326 */ 0x0A4E,
/* 1328 */ 0x0A74,
/* 132A */ 0x0B84,
/* 132C */ 0x0A3E,
/* 132E */ 0x0A3E,
/* 1330 */ 0x0B84,
/* 1332 */ 0x09D6,
/* 1334 */ 0x0A74,
/* 1336 */ 0x0A3E,
/* 1338 */ 0x0B84,
/* 133A */ 0x09D6,
/* 133C */ 0x12A2,
/* 133E */ 0x5005,
/* 1340 */ 0x5241,
/* 1342 */ 0x4553,
/* 1344 */ 0x0006,
/* 1346 */ 0x0A4E,
/* 1348 */ 0x0EE0,
/* 134A */ 0x093C,
/* 134C */ 0x0A12,
/* 134E */ 0x0B34,
/* 1350 */ 0x0948,
/* 1352 */ 0x0A12,
/* 1354 */ 0x093C,
/* 1356 */ 0x0A12,
/* 1358 */ 0x0B84,
/* 135A */ 0x0A3E,
/* 135C */ 0x12AA,
/* 135E */ 0x093C,
/* 1360 */ 0x0E6C,
/* 1362 */ 0x09D6,
/* 1364 */ 0x133E,
/* 1366 */ 0x4304,
/* 1368 */ 0x4148,
/* 136A */ 0x0052,
/* 136C */ 0x0006,
/* 136E */ 0x0E22,
/* 1370 */ 0x1344,
/* 1372 */ 0x0A58,
/* 1374 */ 0x0A22,
/* 1376 */ 0x09D6,
/* 1378 */ 0x1366,
/* 137A */ 0x5005,
/* 137C */ 0x4341,
/* 137E */ 0x244B,
/* 1380 */ 0x0006,
/* 1382 */ 0x0EC0,
/* 1384 */ 0x0DF4,
/* 1386 */ 0x0B28,
/* 1388 */ 0x0A1A,
/* 138A */ 0x0B28,
/* 138C */ 0x0B34,
/* 138E */ 0x0DD4,
/* 1390 */ 0x09CC,
/* 1392 */ 0x0000,
/* 1394 */ 0x0A6A,
/* 1396 */ 0x0A1A,
/* 1398 */ 0x0DD4,
/* 139A */ 0x0A6A,
/* 139C */ 0x0F0C,
/* 139E */ 0x0EC0,
/* 13A0 */ 0x0DF4,
/* 13A2 */ 0x09D6,
/* 13A4 */ 0x137A,
/* 13A6 */ 0x5405,
/* 13A8 */ 0x4B4F,
/* 13AA */ 0x4E45,
/* 13AC */ 0x0006,
/* 13AE */ 0x0E22,
/* 13B0 */ 0x1344,
/* 13B2 */ 0x09CC,
/* 13B4 */ 0x001F,
/* 13B6 */ 0x0A84,
/* 13B8 */ 0x1380,
/* 13BA */ 0x0A60,
/* 13BC */ 0x1084,
/* 13BE */ 0x09D6,
/* 13C0 */ 0x13A6,
/* 13C2 */ 0x5704,
/* 13C4 */ 0x524F,
/* 13C6 */ 0x0044,
/* 13C8 */ 0x0006,
/* 13CA */ 0x1344,
/* 13CC */ 0x1380,
/* 13CE */ 0x09D6,
/* 13D0 */ 0x13C2,
/* 13D2 */ 0x4E05,
/* 13D4 */ 0x4D41,
/* 13D6 */ 0x3E45,
/* 13D8 */ 0x0006,
/* 13DA */ 0x0EAC,
/* 13DC */ 0x09CC,
/* 13DE */ 0x001F,
/* 13E0 */ 0x0A84,
/* 13E2 */ 0x0B34,
/* 13E4 */ 0x0E5A,
/* 13E6 */ 0x09D6,
/* 13E8 */ 0x13D2,
/* 13EA */ 0x5305,
/* 13EC */ 0x4D41,
/* 13EE */ 0x3F45,
/* 13F0 */ 0x0006,
/* 13F2 */ 0x09CC,
/* 13F4 */ 0x001F,
/* 13F6 */ 0x0A84,
/* 13F8 */ 0x0E12,
/* 13FA */ 0x0A4E,
/* 13FC */ 0x09FA,
/* 13FE */ 0x1422,
/* 1400 */ 0x0A74,
/* 1402 */ 0x0A46,
/* 1404 */ 0x0E04,
/* 1406 */ 0x0B34,
/* 1408 */ 0x0A12,
/* 140A */ 0x0A74,
/* 140C */ 0x0A46,
/* 140E */ 0x0E04,
/* 1410 */ 0x0B34,
/* 1412 */ 0x0A12,
/* 1414 */ 0x0B84,
/* 1416 */ 0x0AF2,
/* 1418 */ 0x09EE,
/* 141A */ 0x1422,
/* 141C */ 0x0A3E,
/* 141E */ 0x0A58,
/* 1420 */ 0x09D6,
/* 1422 */ 0x0A06,
/* 1424 */ 0x1400,
/* 1426 */ 0x09CC,
/* 1428 */ 0x0000,
/* 142A */ 0x09D6,
/* 142C */ 0x13EA,
/* 142E */ 0x6604,
/* 1430 */ 0x6E69,
/* 1432 */ 0x0064,
/* 1434 */ 0x0006,
/* 1436 */ 0x0A6A,
/* 1438 */ 0x0A60,
/* 143A */ 0x0A22,
/* 143C */ 0x0926,
/* 143E */ 0x0A0C,
/* 1440 */ 0x0A60,
/* 1442 */ 0x0A12,
/* 1444 */ 0x0A4E,
/* 1446 */ 0x0DF4,
/* 1448 */ 0x0A6A,
/* 144A */ 0x0A60,
/* 144C */ 0x09EE,
/* 144E */ 0x1478,
/* 1450 */ 0x0A60,
/* 1452 */ 0x0A12,
/* 1454 */ 0x09CC,
/* 1456 */ 0xFF1F,
/* 1458 */ 0x0A84,
/* 145A */ 0x0A46,
/* 145C */ 0x0A94,
/* 145E */ 0x09EE,
/* 1460 */ 0x146C,
/* 1462 */ 0x0DF4,
/* 1464 */ 0x09CC,
/* 1466 */ 0xFFFF,
/* 1468 */ 0x09FA,
/* 146A */ 0x1474,
/* 146C */ 0x0DF4,
/* 146E */ 0x0926,
/* 1470 */ 0x0A12,
/* 1472 */ 0x13F0,
/* 1474 */ 0x09FA,
/* 1476 */ 0x1484,
/* 1478 */ 0x0A3E,
/* 147A */ 0x0A58,
/* 147C */ 0x0A6A,
/* 147E */ 0x0DE4,
/* 1480 */ 0x0A6A,
/* 1482 */ 0x09D6,
/* 1484 */ 0x09EE,
/* 1486 */ 0x1492,
/* 1488 */ 0x0DE4,
/* 148A */ 0x0DE4,
/* 148C */ 0x0A12,
/* 148E */ 0x09FA,
/* 1490 */ 0x144A,
/* 1492 */ 0x0A3E,
/* 1494 */ 0x0A58,
/* 1496 */ 0x0A6A,
/* 1498 */ 0x0A58,
/* 149A */ 0x0DE4,
/* 149C */ 0x0A60,
/* 149E */ 0x13D8,
/* 14A0 */ 0x0A6A,
/* 14A2 */ 0x09D6,
/* 14A4 */ 0x142E,
/* 14A6 */ 0x4E05,
/* 14A8 */ 0x4D41,
/* 14AA */ 0x3F45,
/* 14AC */ 0x0006,
/* 14AE */ 0x0984,
/* 14B0 */ 0x0A12,
/* 14B2 */ 0x1434,
/* 14B4 */ 0x09D6,
/* 14B6 */ 0x14A6,
/* 14B8 */ 0x5E02,
/* 14BA */ 0x0048,
/* 14BC */ 0x0006,
/* 14BE */ 0x0A4E,
/* 14C0 */ 0x0A74,
/* 14C2 */ 0x0A3E,
/* 14C4 */ 0x0A6A,
/* 14C6 */ 0x0A74,
/* 14C8 */ 0x0A94,
/* 14CA */ 0x09EE,
/* 14CC */ 0x14E0,
/* 14CE */ 0x09CC,
/* 14D0 */ 0x0008,
/* 14D2 */ 0x0AE4,
/* 14D4 */ 0x0DC4,
/* 14D6 */ 0x0E22,
/* 14D8 */ 0x0AE4,
/* 14DA */ 0x09CC,
/* 14DC */ 0x0008,
/* 14DE */ 0x0AE4,
/* 14E0 */ 0x09D6,
/* 14E2 */ 0x14B8,
/* 14E4 */ 0x5403,
/* 14E6 */ 0x5041,
/* 14E8 */ 0x0006,
/* 14EA */ 0x0A60,
/* 14EC */ 0x0AE4,
/* 14EE */ 0x0A74,
/* 14F0 */ 0x0A1A,
/* 14F2 */ 0x0DD4,
/* 14F4 */ 0x09D6,
/* 14F6 */ 0x14E4,
/* 14F8 */ 0x6B04,
/* 14FA */ 0x4154,
/* 14FC */ 0x0050,
/* 14FE */ 0x0006,
/* 1500 */ 0x0A60,
/* 1502 */ 0x09CC,
/* 1504 */ 0x000D,
/* 1506 */ 0x0A94,
/* 1508 */ 0x09EE,
/* 150A */ 0x1522,
/* 150C */ 0x09CC,
/* 150E */ 0x0008,
/* 1510 */ 0x0A94,
/* 1512 */ 0x09EE,
/* 1514 */ 0x151E,
/* 1516 */ 0x0E22,
/* 1518 */ 0x14E8,
/* 151A */ 0x09FA,
/* 151C */ 0x1520,
/* 151E */ 0x14BC,
/* 1520 */ 0x09D6,
/* 1522 */ 0x0A58,
/* 1524 */ 0x0A6A,
/* 1526 */ 0x0A58,
/* 1528 */ 0x0A60,
/* 152A */ 0x09D6,
/* 152C */ 0x14F8,
/* 152E */ 0x6106,
/* 1530 */ 0x6363,
/* 1532 */ 0x7065,
/* 1534 */ 0x0074,
/* 1536 */ 0x0006,
/* 1538 */ 0x0A74,
/* 153A */ 0x0B34,
/* 153C */ 0x0A74,
/* 153E */ 0x0B28,
/* 1540 */ 0x0A94,
/* 1542 */ 0x09EE,
/* 1544 */ 0x1564,
/* 1546 */ 0x0AD2,
/* 1548 */ 0x0A60,
/* 154A */ 0x0E22,
/* 154C */ 0x0B84,
/* 154E */ 0x09CC,
/* 1550 */ 0x005F,
/* 1552 */ 0x0BD6,
/* 1554 */ 0x09EE,
/* 1556 */ 0x155E,
/* 1558 */ 0x14E8,
/* 155A */ 0x09FA,
/* 155C */ 0x1560,
/* 155E */ 0x14FE,
/* 1560 */ 0x09FA,
/* 1562 */ 0x153E,
/* 1564 */ 0x0A58,
/* 1566 */ 0x0A74,
/* 1568 */ 0x0B84,
/* 156A */ 0x09D6,
/* 156C */ 0x152E,
/* 156E */ 0x4506,
/* 1570 */ 0x5058,
/* 1572 */ 0x4345,
/* 1574 */ 0x0054,
/* 1576 */ 0x0006,
/* 1578 */ 0x1536,
/* 157A */ 0x0932,
/* 157C */ 0x0A0C,
/* 157E */ 0x0A58,
/* 1580 */ 0x09D6,
/* 1582 */ 0x156E,
/* 1584 */ 0x5105,
/* 1586 */ 0x4555,
/* 1588 */ 0x5952,
/* 158A */ 0x0006,
/* 158C */ 0x0EE0,
/* 158E */ 0x09CC,
/* 1590 */ 0x0050,
/* 1592 */ 0x1536,
/* 1594 */ 0x0948,
/* 1596 */ 0x0A0C,
/* 1598 */ 0x0A58,
/* 159A */ 0x09CC,
/* 159C */ 0x0000,
/* 159E */ 0x093C,
/* 15A0 */ 0x0A0C,
/* 15A2 */ 0x09D6,
/* 15A4 */ 0x1584,
/* 15A6 */ 0x4105,
/* 15A8 */ 0x4F42,
/* 15AA */ 0x5452,
/* 15AC */ 0x0006,
/* 15AE */ 0x09A8,
/* 15B0 */ 0x0EF6,
/* 15B2 */ 0x09D6,
/* 15B4 */ 0x15A6,
/* 15B6 */ 0x6146,
/* 15B8 */ 0x6F62,
/* 15BA */ 0x7472,
/* 15BC */ 0x0022,
/* 15BE */ 0x0006,
/* 15C0 */ 0x09EE,
/* 15C2 */ 0x15CC,
/* 15C4 */ 0x11FA,
/* 15C6 */ 0x0EAC,
/* 15C8 */ 0x11C8,
/* 15CA */ 0x15AC,
/* 15CC */ 0x11FA,
/* 15CE */ 0x0A58,
/* 15D0 */ 0x09D6,
/* 15D2 */ 0x15B6,
/* 15D4 */ 0x4505,
/* 15D6 */ 0x5252,
/* 15D8 */ 0x524F,
/* 15DA */ 0x0006,
/* 15DC */ 0x1182,
/* 15DE */ 0x0EAC,
/* 15E0 */ 0x11C8,
/* 15E2 */ 0x09CC,
/* 15E4 */ 0x003F,
/* 15E6 */ 0x0AE4,
/* 15E8 */ 0x15AC,
/* 15EA */ 0x15D4,
/* 15EC */ 0x240A,
/* 15EE */ 0x4E49,
/* 15F0 */ 0x4554,
/* 15F2 */ 0x5052,
/* 15F4 */ 0x4552,
/* 15F6 */ 0x0054,
/* 15F8 */ 0x0006,
/* 15FA */ 0x14AC,
/* 15FC */ 0x0AF2,
/* 15FE */ 0x09EE,
/* 1600 */ 0x161E,
/* 1602 */ 0x0A22,
/* 1604 */ 0x09CC,
/* 1606 */ 0x0040,
/* 1608 */ 0x0A84,
/* 160A */ 0x15BE,
/* 160C */ 0x630C,
/* 160E */ 0x6D6F,
/* 1610 */ 0x6970,
/* 1612 */ 0x656C,
/* 1614 */ 0x6F20,
/* 1616 */ 0x6C6E,
/* 1618 */ 0x0079,
/* 161A */ 0x09E2,
/* 161C */ 0x09D6,
/* 161E */ 0x10E4,
/* 1620 */ 0x09EE,
/* 1622 */ 0x162A,
/* 1624 */ 0x09D6,
/* 1626 */ 0x09FA,
/* 1628 */ 0x162C,
/* 162A */ 0x15DA,
/* 162C */ 0x09D6,
/* 162E */ 0x15EC,
/* 1630 */ 0x5B81,
/* 1632 */ 0x0006,
/* 1634 */ 0x09CC,
/* 1636 */ 0x15F8,
/* 1638 */ 0x096C,
/* 163A */ 0x0A0C,
/* 163C */ 0x09D6,
/* 163E */ 0x1630,
/* 1640 */ 0x2E03,
/* 1642 */ 0x4B4F,
/* 1644 */ 0x0006,
/* 1646 */ 0x09CC,
/* 1648 */ 0x15F8,
/* 164A */ 0x096C,
/* 164C */ 0x0A12,
/* 164E */ 0x0BBC,
/* 1650 */ 0x09EE,
/* 1652 */ 0x167A,
/* 1654 */ 0x11E4,
/* 1656 */ 0x0A4E,
/* 1658 */ 0x0A4E,
/* 165A */ 0x0A4E,
/* 165C */ 0x0A60,
/* 165E */ 0x1278,
/* 1660 */ 0x0A3E,
/* 1662 */ 0x0A60,
/* 1664 */ 0x1278,
/* 1666 */ 0x0A3E,
/* 1668 */ 0x0A60,
/* 166A */ 0x1278,
/* 166C */ 0x0A3E,
/* 166E */ 0x0A60,
/* 1670 */ 0x1278,
/* 1672 */ 0x1222,
/* 1674 */ 0x2004,
/* 1676 */ 0x6B6F,
/* 1678 */ 0x003E,
/* 167A */ 0x09D6,
/* 167C */ 0x1640,
/* 167E */ 0x4504,
/* 1680 */ 0x4156,
/* 1682 */ 0x004C,
/* 1684 */ 0x0006,
/* 1686 */ 0x13AC,
/* 1688 */ 0x0A60,
/* 168A */ 0x0A22,
/* 168C */ 0x09EE,
/* 168E */ 0x1698,
/* 1690 */ 0x096C,
/* 1692 */ 0x0EF6,
/* 1694 */ 0x09FA,
/* 1696 */ 0x1686,
/* 1698 */ 0x0A58,
/* 169A */ 0x1644,
/* 169C */ 0x09D6,
/* 169E */ 0x167E,
/* 16A0 */ 0x5104,
/* 16A2 */ 0x4955,
/* 16A4 */ 0x0054,
/* 16A6 */ 0x0006,
/* 16A8 */ 0x09CC,
/* 16AA */ 0x0880,
/* 16AC */ 0x0954,
/* 16AE */ 0x0A0C,
/* 16B0 */ 0x1632,
/* 16B2 */ 0x158A,
/* 16B4 */ 0x1684,
/* 16B6 */ 0x09FA,
/* 16B8 */ 0x16B2,
/* 16BA */ 0x09D6,
/* 16BC */ 0x16A0,
/* 16BE */ 0x2701,
/* 16C0 */ 0x0006,
/* 16C2 */ 0x13AC,
/* 16C4 */ 0x14AC,
/* 16C6 */ 0x09EE,
/* 16C8 */ 0x16CC,
/* 16CA */ 0x09D6,
/* 16CC */ 0x15DA,
/* 16CE */ 0x16BE,
/* 16D0 */ 0x4105,
/* 16D2 */ 0x4C4C,
/* 16D4 */ 0x544F,
/* 16D6 */ 0x0006,
/* 16D8 */ 0x098E,
/* 16DA */ 0x0E6C,
/* 16DC */ 0x09D6,
/* 16DE */ 0x16D0,
/* 16E0 */ 0x2C01,
/* 16E2 */ 0x0006,
/* 16E4 */ 0x098E,
/* 16E6 */ 0x0A12,
/* 16E8 */ 0x0A0C,
/* 16EA */ 0x09CC,
/* 16EC */ 0x0002,
/* 16EE */ 0x098E,
/* 16F0 */ 0x0E6C,
/* 16F2 */ 0x09D6,
/* 16F4 */ 0x16E0,
/* 16F6 */ 0x5B89,
/* 16F8 */ 0x4F43,
/* 16FA */ 0x504D,
/* 16FC */ 0x4C49,
/* 16FE */ 0x5D45,
/* 1700 */ 0x0006,
/* 1702 */ 0x16C0,
/* 1704 */ 0x16E2,
/* 1706 */ 0x09D6,
/* 1708 */ 0x16F6,
/* 170A */ 0x4307,
/* 170C */ 0x4D4F,
/* 170E */ 0x4950,
/* 1710 */ 0x454C,
/* 1712 */ 0x0006,
/* 1714 */ 0x0A3E,
/* 1716 */ 0x0A60,
/* 1718 */ 0x0A12,
/* 171A */ 0x16E2,
/* 171C */ 0x0DF4,
/* 171E */ 0x0A4E,
/* 1720 */ 0x09D6,
/* 1722 */ 0x170A,
/* 1724 */ 0x4C87,
/* 1726 */ 0x5449,
/* 1728 */ 0x5245,
/* 172A */ 0x4C41,
/* 172C */ 0x0006,
/* 172E */ 0x09CC,
/* 1730 */ 0x09CC,
/* 1732 */ 0x16E2,
/* 1734 */ 0x16E2,
/* 1736 */ 0x09D6,
/* 1738 */ 0x1724,
/* 173A */ 0x2403,
/* 173C */ 0x222C,
/* 173E */ 0x0006,
/* 1740 */ 0x09CC,
/* 1742 */ 0xFFFE,
/* 1744 */ 0x16D6,
/* 1746 */ 0x09CC,
/* 1748 */ 0x0022,
/* 174A */ 0x13C8,
/* 174C */ 0x0EAC,
/* 174E */ 0x0B34,
/* 1750 */ 0x0E5A,
/* 1752 */ 0x098E,
/* 1754 */ 0x0A0C,
/* 1756 */ 0x09D6,
/* 1758 */ 0x173A,
/* 175A */ 0x3F07,
/* 175C */ 0x4E55,
/* 175E */ 0x5149,
/* 1760 */ 0x4555,
/* 1762 */ 0x0006,
/* 1764 */ 0x0A60,
/* 1766 */ 0x14AC,
/* 1768 */ 0x0AF2,
/* 176A */ 0x09EE,
/* 176C */ 0x1784,
/* 176E */ 0x0EAC,
/* 1770 */ 0x09CC,
/* 1772 */ 0x001F,
/* 1774 */ 0x0A84,
/* 1776 */ 0x1182,
/* 1778 */ 0x11C8,
/* 177A */ 0x1222,
/* 177C */ 0x2007,
/* 177E */ 0x6572,
/* 1780 */ 0x6544,
/* 1782 */ 0x2066,
/* 1784 */ 0x0A58,
/* 1786 */ 0x09D6,
/* 1788 */ 0x175A,
/* 178A */ 0x2403,
/* 178C */ 0x6E2C,
/* 178E */ 0x0006,
/* 1790 */ 0x0A60,
/* 1792 */ 0x0A12,
/* 1794 */ 0x09EE,
/* 1796 */ 0x17B4,
/* 1798 */ 0x1762,
/* 179A */ 0x0A60,
/* 179C */ 0x13D8,
/* 179E */ 0x098E,
/* 17A0 */ 0x0A0C,
/* 17A2 */ 0x0A60,
/* 17A4 */ 0x099A,
/* 17A6 */ 0x0A0C,
/* 17A8 */ 0x0DE4,
/* 17AA */ 0x0984,
/* 17AC */ 0x0A12,
/* 17AE */ 0x0A6A,
/* 17B0 */ 0x0A0C,
/* 17B2 */ 0x09D6,
/* 17B4 */ 0x15DA,
/* 17B6 */ 0x178A,
/* 17B8 */ 0x2408,
/* 17BA */ 0x4F43,
/* 17BC */ 0x504D,
/* 17BE */ 0x4C49,
/* 17C0 */ 0x0045,
/* 17C2 */ 0x0006,
/* 17C4 */ 0x14AC,
/* 17C6 */ 0x0AF2,
/* 17C8 */ 0x09EE,
/* 17CA */ 0x17E2,
/* 17CC */ 0x0A22,
/* 17CE */ 0x09CC,
/* 17D0 */ 0x0080,
/* 17D2 */ 0x0A84,
/* 17D4 */ 0x09EE,
/* 17D6 */ 0x17DE,
/* 17D8 */ 0x09E2,
/* 17DA */ 0x09FA,
/* 17DC */ 0x17E0,
/* 17DE */ 0x16E2,
/* 17E0 */ 0x09D6,
/* 17E2 */ 0x10E4,
/* 17E4 */ 0x09EE,
/* 17E6 */ 0x17EC,
/* 17E8 */ 0x172C,
/* 17EA */ 0x09D6,
/* 17EC */ 0x15DA,
/* 17EE */ 0x17B8,
/* 17F0 */ 0x4F05,
/* 17F2 */ 0x4556,
/* 17F4 */ 0x5452,
/* 17F6 */ 0x0006,
/* 17F8 */ 0x099A,
/* 17FA */ 0x0A12,
/* 17FC */ 0x0984,
/* 17FE */ 0x0A0C,
/* 1800 */ 0x09D6,
/* 1802 */ 0x17F0,
/* 1804 */ 0x3BC1,
/* 1806 */ 0x0006,
/* 1808 */ 0x09CC,
/* 180A */ 0x09D6,
/* 180C */ 0x16E2,
/* 180E */ 0x1632,
/* 1810 */ 0x17F6,
/* 1812 */ 0x09D6,
/* 1814 */ 0x1804,
/* 1816 */ 0x5D01,
/* 1818 */ 0x0006,
/* 181A */ 0x09CC,
/* 181C */ 0x17C2,
/* 181E */ 0x096C,
/* 1820 */ 0x0A0C,
/* 1822 */ 0x09D6,
/* 1824 */ 0x1816,
/* 1826 */ 0x3A01,
/* 1828 */ 0x0006,
/* 182A */ 0x13AC,
/* 182C */ 0x178E,
/* 182E */ 0x09CC,
/* 1830 */ 0x0006,
/* 1832 */ 0x16E2,
/* 1834 */ 0x1818,
/* 1836 */ 0x09D6,
/* 1838 */ 0x1826,
/* 183A */ 0x4304,
/* 183C */ 0x444F,
/* 183E */ 0x0045,
/* 1840 */ 0x0006,
/* 1842 */ 0x13AC,
/* 1844 */ 0x178E,
/* 1846 */ 0x17F6,
/* 1848 */ 0x09D6,
/* 184A */ 0x183A,
/* 184C */ 0x4306,
/* 184E */ 0x4552,
/* 1850 */ 0x5441,
/* 1852 */ 0x0045,
/* 1854 */ 0x0006,
/* 1856 */ 0x1840,
/* 1858 */ 0x09CC,
/* 185A */ 0x1615,
/* 185C */ 0x16E2,
/* 185E */ 0x09D6,
/* 1860 */ 0x184C,
/* 1862 */ 0x5608,
/* 1864 */ 0x5241,
/* 1866 */ 0x4149,
/* 1868 */ 0x4C42,
/* 186A */ 0x0045,
/* 186C */ 0x0006,
/* 186E */ 0x1854,
/* 1870 */ 0x09CC,
/* 1872 */ 0x0000,
/* 1874 */ 0x16E2,
/* 1876 */ 0x09D6,
/* 1878 */ 0x1862,
/* 187A */ 0x4308,
/* 187C */ 0x4E4F,
/* 187E */ 0x5453,
/* 1880 */ 0x4E41,
/* 1882 */ 0x0054,
/* 1884 */ 0x0006,
/* 1886 */ 0x1840,
/* 1888 */ 0x09CC,
/* 188A */ 0x1604,
/* 188C */ 0x16E2,
/* 188E */ 0x16E2,
/* 1890 */ 0x09D6,
/* 1892 */ 0x187A,
/* 1894 */ 0x6403,
/* 1896 */ 0x2B6D,
/* 1898 */ 0x0006,
/* 189A */ 0x0A74,
/* 189C */ 0x09CC,
/* 189E */ 0x0005,
/* 18A0 */ 0x124A,
/* 18A2 */ 0x1182,
/* 18A4 */ 0x0A4E,
/* 18A6 */ 0x09FA,
/* 18A8 */ 0x18B2,
/* 18AA */ 0x0EAC,
/* 18AC */ 0x09CC,
/* 18AE */ 0x0003,
/* 18B0 */ 0x124A,
/* 18B2 */ 0x0A06,
/* 18B4 */ 0x18AA,
/* 18B6 */ 0x09D6,
/* 18B8 */ 0x1894,
/* 18BA */ 0x4404,
/* 18BC */ 0x4D55,
/* 18BE */ 0x0050,
/* 18C0 */ 0x0006,
/* 18C2 */ 0x09CC,
/* 18C4 */ 0x0010,
/* 18C6 */ 0x0A4E,
/* 18C8 */ 0x09FA,
/* 18CA */ 0x18DE,
/* 18CC */ 0x11E4,
/* 18CE */ 0x09CC,
/* 18D0 */ 0x0010,
/* 18D2 */ 0x0B28,
/* 18D4 */ 0x1898,
/* 18D6 */ 0x0B04,
/* 18D8 */ 0x0B04,
/* 18DA */ 0x1182,
/* 18DC */ 0x11C8,
/* 18DE */ 0x0A06,
/* 18E0 */ 0x18CC,
/* 18E2 */ 0x0A58,
/* 18E4 */ 0x09D6,
/* 18E6 */ 0x18BA,
/* 18E8 */ 0x3E05,
/* 18EA */ 0x414E,
/* 18EC */ 0x454D,
/* 18EE */ 0x0006,
/* 18F0 */ 0x0984,
/* 18F2 */ 0x0A12,
/* 18F4 */ 0x0A60,
/* 18F6 */ 0x09EE,
/* 18F8 */ 0x1914,
/* 18FA */ 0x0B28,
/* 18FC */ 0x13D8,
/* 18FE */ 0x0A94,
/* 1900 */ 0x09EE,
/* 1902 */ 0x190A,
/* 1904 */ 0x0DE4,
/* 1906 */ 0x09FA,
/* 1908 */ 0x1910,
/* 190A */ 0x0A6A,
/* 190C */ 0x0A58,
/* 190E */ 0x09D6,
/* 1910 */ 0x09FA,
/* 1912 */ 0x18F2,
/* 1914 */ 0x0A6A,
/* 1916 */ 0x0A58,
/* 1918 */ 0x09D6,
/* 191A */ 0x18E8,
/* 191C */ 0x2E03,
/* 191E */ 0x4449,
/* 1920 */ 0x0006,
/* 1922 */ 0x0AF2,
/* 1924 */ 0x09EE,
/* 1926 */ 0x1938,
/* 1928 */ 0x0EAC,
/* 192A */ 0x09CC,
/* 192C */ 0x001F,
/* 192E */ 0x0A84,
/* 1930 */ 0x11C8,
/* 1932 */ 0x1182,
/* 1934 */ 0x09FA,
/* 1936 */ 0x1946,
/* 1938 */ 0x1182,
/* 193A */ 0x1222,
/* 193C */ 0x7B08,
/* 193E */ 0x6F6E,
/* 1940 */ 0x614E,
/* 1942 */ 0x656D,
/* 1944 */ 0x007D,
/* 1946 */ 0x09D6,
/* 1948 */ 0x191C,
/* 194A */ 0x5303,
/* 194C */ 0x4545,
/* 194E */ 0x0006,
/* 1950 */ 0x16C0,
/* 1952 */ 0x11E4,
/* 1954 */ 0x09CC,
/* 1956 */ 0x0020,
/* 1958 */ 0x0A4E,
/* 195A */ 0x0DF4,
/* 195C */ 0x0A60,
/* 195E */ 0x0A12,
/* 1960 */ 0x0A60,
/* 1962 */ 0x09EE,
/* 1964 */ 0x1968,
/* 1966 */ 0x18EE,
/* 1968 */ 0x0AF2,
/* 196A */ 0x09EE,
/* 196C */ 0x1976,
/* 196E */ 0x1182,
/* 1970 */ 0x1920,
/* 1972 */ 0x09FA,
/* 1974 */ 0x197C,
/* 1976 */ 0x0A60,
/* 1978 */ 0x0A12,
/* 197A */ 0x1266,
/* 197C */ 0x0A06,
/* 197E */ 0x195A,
/* 1980 */ 0x0AD2,
/* 1982 */ 0x09CC,
/* 1984 */ 0x000D,
/* 1986 */ 0x0BBC,
/* 1988 */ 0x09EE,
/* 198A */ 0x1954,
/* 198C */ 0x0A58,
/* 198E */ 0x09D6,
/* 1990 */ 0x194A,
/* 1992 */ 0x5705,
/* 1994 */ 0x524F,
/* 1996 */ 0x5344,
/* 1998 */ 0x0006,
/* 199A */ 0x11E4,
/* 199C */ 0x0984,
/* 199E */ 0x0A12,
/* 19A0 */ 0x0AF2,
/* 19A2 */ 0x09EE,
/* 19A4 */ 0x19B2,
/* 19A6 */ 0x0A60,
/* 19A8 */ 0x1182,
/* 19AA */ 0x1920,
/* 19AC */ 0x0DE4,
/* 19AE */ 0x09FA,
/* 19B0 */ 0x199E,
/* 19B2 */ 0x09D6,
/* 19B4 */ 0x1992,
/* 19B6 */ 0x4606,
/* 19B8 */ 0x524F,
/* 19BA */ 0x4547,
/* 19BC */ 0x0054,
/* 19BE */ 0x0006,
/* 19C0 */ 0x13AC,
/* 19C2 */ 0x14AC,
/* 19C4 */ 0x0AF2,
/* 19C6 */ 0x09EE,
/* 19C8 */ 0x19E2,
/* 19CA */ 0x0DE4,
/* 19CC */ 0x0A60,
/* 19CE */ 0x098E,
/* 19D0 */ 0x0A0C,
/* 19D2 */ 0x0A12,
/* 19D4 */ 0x0A60,
/* 19D6 */ 0x0984,
/* 19D8 */ 0x0A0C,
/* 19DA */ 0x099A,
/* 19DC */ 0x0A0C,
/* 19DE */ 0x0A58,
/* 19E0 */ 0x09D6,
/* 19E2 */ 0x15DA,
/* 19E4 */ 0x19B6,
/* 19E6 */ 0x4408,
/* 19E8 */ 0x4149,
/* 19EA */ 0x4E47,
/* 19EC */ 0x534F,
/* 19EE */ 0x0045,
/* 19F0 */ 0x0006,
/* 19F2 */ 0x09CC,
/* 19F4 */ 0x0065,
/* 19F6 */ 0x09CC,
/* 19F8 */ 0x0000,
/* 19FA */ 0x0A7C,
/* 19FC */ 0x09CC,
/* 19FE */ 0xFFFE,
/* 1A00 */ 0x0A7C,
/* 1A02 */ 0x0A9C,
/* 1A04 */ 0x0A58,
/* 1A06 */ 0x09CC,
/* 1A08 */ 0x0003,
/* 1A0A */ 0x0A9C,
/* 1A0C */ 0x0A9C,
/* 1A0E */ 0x0A58,
/* 1A10 */ 0x09CC,
/* 1A12 */ 0x0043,
/* 1A14 */ 0x0A9C,
/* 1A16 */ 0x0A58,
/* 1A18 */ 0x09CC,
/* 1A1A */ 0x004F,
/* 1A1C */ 0x09CC,
/* 1A1E */ 0x006F,
/* 1A20 */ 0x0A94,
/* 1A22 */ 0x09CC,
/* 1A24 */ 0x00F0,
/* 1A26 */ 0x0A84,
/* 1A28 */ 0x09CC,
/* 1A2A */ 0x004F,
/* 1A2C */ 0x0A8C,
/* 1A2E */ 0x09CC,
/* 1A30 */ 0x0008,
/* 1A32 */ 0x09CC,
/* 1A34 */ 0x0006,
/* 1A36 */ 0x0A6A,
/* 1A38 */ 0x0A74,
/* 1A3A */ 0x0A94,
/* 1A3C */ 0x09CC,
/* 1A3E */ 0x0003,
/* 1A40 */ 0x0A84,
/* 1A42 */ 0x0A84,
/* 1A44 */ 0x09CC,
/* 1A46 */ 0x0070,
/* 1A48 */ 0x0A9C,
/* 1A4A */ 0x0A58,
/* 1A4C */ 0x09CC,
/* 1A4E */ 0x0000,
/* 1A50 */ 0x09EE,
/* 1A52 */ 0x1A58,
/* 1A54 */ 0x09CC,
/* 1A56 */ 0x003F,
/* 1A58 */ 0x09CC,
/* 1A5A */ 0xFFFF,
/* 1A5C */ 0x09EE,
/* 1A5E */ 0x1A68,
/* 1A60 */ 0x09CC,
/* 1A62 */ 0x0074,
/* 1A64 */ 0x09FA,
/* 1A66 */ 0x1A6C,
/* 1A68 */ 0x09CC,
/* 1A6A */ 0x0021,
/* 1A6C */ 0x09CC,
/* 1A6E */ 0x0068,
/* 1A70 */ 0x09CC,
/* 1A72 */ 0x0080,
/* 1A74 */ 0x0A0C,
/* 1A76 */ 0x09CC,
/* 1A78 */ 0x0080,
/* 1A7A */ 0x0A12,
/* 1A7C */ 0x09CC,
/* 1A7E */ 0x004D,
/* 1A80 */ 0x0A4E,
/* 1A82 */ 0x0A46,
/* 1A84 */ 0x0A3E,
/* 1A86 */ 0x0A84,
/* 1A88 */ 0x09CC,
/* 1A8A */ 0x0061,
/* 1A8C */ 0x09CC,
/* 1A8E */ 0x000A,
/* 1A90 */ 0x0A4E,
/* 1A92 */ 0x09CC,
/* 1A94 */ 0x0001,
/* 1A96 */ 0x0A9C,
/* 1A98 */ 0x0A58,
/* 1A9A */ 0x0A06,
/* 1A9C */ 0x1A92,
/* 1A9E */ 0x09CC,
/* 1AA0 */ 0x656D,
/* 1AA2 */ 0x09CC,
/* 1AA4 */ 0x0100,
/* 1AA6 */ 0x0D34,
/* 1AA8 */ 0x0A6A,
/* 1AAA */ 0x09CC,
/* 1AAC */ 0x0100,
/* 1AAE */ 0x0D34,
/* 1AB0 */ 0x0A6A,
/* 1AB2 */ 0x0A58,
/* 1AB4 */ 0x09CC,
/* 1AB6 */ 0x2043,
/* 1AB8 */ 0x09CC,
/* 1ABA */ 0x0000,
/* 1ABC */ 0x09CC,
/* 1ABE */ 0x0100,
/* 1AC0 */ 0x0C5E,
/* 1AC2 */ 0x09D6,
/* 1AC4 */ 0x19E6,
/* 1AC6 */ 0x4304,
/* 1AC8 */ 0x4C4F,
/* 1ACA */ 0x0044,
/* 1ACC */ 0x0006,
/* 1ACE */ 0x09CC,
/* 1AD0 */ 0x090A,
/* 1AD2 */ 0x09CC,
/* 1AD4 */ 0x030A,
/* 1AD6 */ 0x09CC,
/* 1AD8 */ 0x0010,
/* 1ADA */ 0x0F0C,
/* 1ADC */ 0x11E4,
/* 1ADE */ 0x1222,
/* 1AE0 */ 0x4118,
/* 1AE2 */ 0x6472,
/* 1AE4 */ 0x6975,
/* 1AE6 */ 0x6F6E,
/* 1AE8 */ 0x6520,
/* 1AEA */ 0x6F46,
/* 1AEC */ 0x7472,
/* 1AEE */ 0x2068,
/* 1AF0 */ 0x2E32,
/* 1AF2 */ 0x2C30,
/* 1AF4 */ 0x3220,
/* 1AF6 */ 0x3130,
/* 1AF8 */ 0x0031,
/* 1AFA */ 0x11E4,
/* 1AFC */ 0x16A6,
/* 1AFE */ 0x09D6,
/* 1B00 */ 0x1AC6,
/* 1B02 */ 0x3C05,
/* 1B04 */ 0x414D,
/* 1B06 */ 0x4B52,
/* 1B08 */ 0x0006,
/* 1B0A */ 0x0EC0,
/* 1B0C */ 0x09D6,
/* 1B0E */ 0x1B02,
/* 1B10 */ 0x3C08,
/* 1B12 */ 0x4552,
/* 1B14 */ 0x4F53,
/* 1B16 */ 0x564C,
/* 1B18 */ 0x0045,
/* 1B1A */ 0x0006,
/* 1B1C */ 0x16E2,
/* 1B1E */ 0x09D6,
/* 1B20 */ 0x1B10,
/* 1B22 */ 0x3E05,
/* 1B24 */ 0x414D,
/* 1B26 */ 0x4B52,
/* 1B28 */ 0x0006,
/* 1B2A */ 0x0EC0,
/* 1B2C */ 0x09CC,
/* 1B2E */ 0x0000,
/* 1B30 */ 0x16E2,
/* 1B32 */ 0x09D6,
/* 1B34 */ 0x1B22,
/* 1B36 */ 0x3E08,
/* 1B38 */ 0x4552,
/* 1B3A */ 0x4F53,
/* 1B3C */ 0x564C,
/* 1B3E */ 0x0045,
/* 1B40 */ 0x0006,
/* 1B42 */ 0x1B08,
/* 1B44 */ 0x0A6A,
/* 1B46 */ 0x0A0C,
/* 1B48 */ 0x09D6,
/* 1B4A */ 0x1B36,
/* 1B4C */ 0x4683,
/* 1B4E */ 0x524F,
/* 1B50 */ 0x0006,
/* 1B52 */ 0x1712,
/* 1B54 */ 0x0A4E,
/* 1B56 */ 0x1B08,
/* 1B58 */ 0x09D6,
/* 1B5A */ 0x1B4C,
/* 1B5C */ 0x4285,
/* 1B5E */ 0x4745,
/* 1B60 */ 0x4E49,
/* 1B62 */ 0x0006,
/* 1B64 */ 0x1B08,
/* 1B66 */ 0x09D6,
/* 1B68 */ 0x1B5C,
/* 1B6A */ 0x4E84,
/* 1B6C */ 0x5845,
/* 1B6E */ 0x0054,
/* 1B70 */ 0x0006,
/* 1B72 */ 0x1712,
/* 1B74 */ 0x0A06,
/* 1B76 */ 0x1B1A,
/* 1B78 */ 0x09D6,
/* 1B7A */ 0x1B6A,
/* 1B7C */ 0x5585,
/* 1B7E */ 0x544E,
/* 1B80 */ 0x4C49,
/* 1B82 */ 0x0006,
/* 1B84 */ 0x1712,
/* 1B86 */ 0x09EE,
/* 1B88 */ 0x1B1A,
/* 1B8A */ 0x09D6,
/* 1B8C */ 0x1B7C,
/* 1B8E */ 0x4185,
/* 1B90 */ 0x4147,
/* 1B92 */ 0x4E49,
/* 1B94 */ 0x0006,
/* 1B96 */ 0x1712,
/* 1B98 */ 0x09FA,
/* 1B9A */ 0x1B1A,
/* 1B9C */ 0x09D6,
/* 1B9E */ 0x1B8E,
/* 1BA0 */ 0x4982,
/* 1BA2 */ 0x0046,
/* 1BA4 */ 0x0006,
/* 1BA6 */ 0x1712,
/* 1BA8 */ 0x09EE,
/* 1BAA */ 0x1B28,
/* 1BAC */ 0x09D6,
/* 1BAE */ 0x1BA0,
/* 1BB0 */ 0x4185,
/* 1BB2 */ 0x4548,
/* 1BB4 */ 0x4441,
/* 1BB6 */ 0x0006,
/* 1BB8 */ 0x1712,
/* 1BBA */ 0x09FA,
/* 1BBC */ 0x1B28,
/* 1BBE */ 0x09D6,
/* 1BC0 */ 0x1BB0,
/* 1BC2 */ 0x5286,
/* 1BC4 */ 0x5045,
/* 1BC6 */ 0x4145,
/* 1BC8 */ 0x0054,
/* 1BCA */ 0x0006,
/* 1BCC */ 0x1B94,
/* 1BCE */ 0x1B40,
/* 1BD0 */ 0x09D6,
/* 1BD2 */ 0x1BC2,
/* 1BD4 */ 0x5484,
/* 1BD6 */ 0x4548,
/* 1BD8 */ 0x004E,
/* 1BDA */ 0x0006,
/* 1BDC */ 0x1B40,
/* 1BDE */ 0x09D6,
/* 1BE0 */ 0x1BD4,
/* 1BE2 */ 0x4183,
/* 1BE4 */ 0x5446,
/* 1BE6 */ 0x0006,
/* 1BE8 */ 0x0A58,
/* 1BEA */ 0x1BB6,
/* 1BEC */ 0x1B62,
/* 1BEE */ 0x0A6A,
/* 1BF0 */ 0x09D6,
/* 1BF2 */ 0x1BE2,
/* 1BF4 */ 0x4584,
/* 1BF6 */ 0x534C,
/* 1BF8 */ 0x0045,
/* 1BFA */ 0x0006,
/* 1BFC */ 0x1BB6,
/* 1BFE */ 0x0A6A,
/* 1C00 */ 0x1BDA,
/* 1C02 */ 0x09D6,
/* 1C04 */ 0x1BF4,
/* 1C06 */ 0x5785,
/* 1C08 */ 0x4948,
/* 1C0A */ 0x454C,
/* 1C0C */ 0x0006,
/* 1C0E */ 0x1BA4,
/* 1C10 */ 0x0A6A,
/* 1C12 */ 0x09D6,
/* 1C14 */ 0x1C06,
/* 1C16 */ 0x4186,
/* 1C18 */ 0x4F42,
/* 1C1A */ 0x5452,
/* 1C1C */ 0x0022,
/* 1C1E */ 0x0006,
/* 1C20 */ 0x1712,
/* 1C22 */ 0x15BE,
/* 1C24 */ 0x173E,
/* 1C26 */ 0x09D6,
/* 1C28 */ 0x1C16,
/* 1C2A */ 0x2482,
/* 1C2C */ 0x0022,
/* 1C2E */ 0x0006,
/* 1C30 */ 0x1712,
/* 1C32 */ 0x1216,
/* 1C34 */ 0x173E,
/* 1C36 */ 0x09D6,
/* 1C38 */ 0x1C2A,
/* 1C3A */ 0x2E82,
/* 1C3C */ 0x0022,
/* 1C3E */ 0x0006,
/* 1C40 */ 0x1712,
/* 1C42 */ 0x1222,
/* 1C44 */ 0x173E,
/* 1C46 */ 0x09D6,
/* 1C48 */ 0x1C3A,
/* 1C4A */ 0x2E82,
/* 1C4C */ 0x0028,
/* 1C4E */ 0x0006,
/* 1C50 */ 0x09CC,
/* 1C52 */ 0x0029,
/* 1C54 */ 0x1344,
/* 1C56 */ 0x11C8,
/* 1C58 */ 0x09D6,
/* 1C5A */ 0x1C4A,
/* 1C5C */ 0x5C81,
/* 1C5E */ 0x0006,
/* 1C60 */ 0x09CC,
/* 1C62 */ 0x000A,
/* 1C64 */ 0x13C8,
/* 1C66 */ 0x0A58,
/* 1C68 */ 0x09D6,
/* 1C6A */ 0x1C5C,
/* 1C6C */ 0x2881,
/* 1C6E */ 0x0006,
/* 1C70 */ 0x09CC,
/* 1C72 */ 0x0029,
/* 1C74 */ 0x1344,
/* 1C76 */ 0x0B18,
/* 1C78 */ 0x09D6,
/* 1C7A */ 0x1C6C,
/* 1C7C */ 0x4909,
/* 1C7E */ 0x4D4D,
/* 1C80 */ 0x4445,
/* 1C82 */ 0x4149,
/* 1C84 */ 0x4554,
/* 1C86 */ 0x0006,
/* 1C88 */ 0x09CC,
/* 1C8A */ 0x0080,
/* 1C8C */ 0x099A,
/* 1C8E */ 0x0A12,
/* 1C90 */ 0x0A12,
/* 1C92 */ 0x0A8C,
/* 1C94 */ 0x099A,
/* 1C96 */ 0x0A12,
/* 1C98 */ 0x0A0C,
/* 1C9A */ 0x09D6,
/* 1C9C */ 0x0000,
/* 1C9E */ 0x0000,
/* 1CA0 */ 0x0000,
/* 1CA2 */ 0x0000,
/* 1CA4 */ 0x0000,
/* 1CA6 */ 0x0000,
/* 1CA8 */ 0x0000,
/* 1CAA */ 0x0000,
/* 1CAC */ 0x0000,
/* 1CAE */ 0x0000,
/* 1CB0 */ 0x0000,
/* 1CB2 */ 0x0000,
/* 1CB4 */ 0x0000,
/* 1CB6 */ 0x0000,
/* 1CB8 */ 0x0000,
/* 1CBA */ 0x0000,
/* 1CBC */ 0x0000,
/* 1CBE */ 0x0000,
/* 1CC0 */ 0x0000,
/* 1CC2 */ 0x0000,
/* 1CC4 */ 0x0000,
/* 1CC6 */ 0x0000,
/* 1CC8 */ 0x0000,
/* 1CCA */ 0x0000,
/* 1CCC */ 0x0000,
/* 1CCE */ 0x0000,
/* 1CD0 */ 0x0000,
/* 1CD2 */ 0x0000,
/* 1CD4 */ 0x0000,
/* 1CD6 */ 0x0000,
/* 1CD8 */ 0x0000,
/* 1CDA */ 0x0000,
/* 1CDC */ 0x0000,
/* 1CDE */ 0x0000,
/* 1CE0 */ 0x0000,
/* 1CE2 */ 0x0000,
/* 1CE4 */ 0x0000,
/* 1CE6 */ 0x0000,
/* 1CE8 */ 0x0000,
/* 1CEA */ 0x0000,
/* 1CEC */ 0x0000,
/* 1CEE */ 0x0000,
/* 1CF0 */ 0x0000,
/* 1CF2 */ 0x0000,
/* 1CF4 */ 0x0000,
/* 1CF6 */ 0x0000,
/* 1CF8 */ 0x0000,
/* 1CFA */ 0x0000,
/* 1CFC */ 0x0000,
/* 1CFE */ 0x0000,
/* 1D00 */ 0x0000,
/* 1D02 */ 0x0000,
/* 1D04 */ 0x0000,
/* 1D06 */ 0x0000,
/* 1D08 */ 0x0000,
/* 1D0A */ 0x0000,
/* 1D0C */ 0x0000,
/* 1D0E */ 0x0000,
/* 1D10 */ 0x0000,
/* 1D12 */ 0x0000,
/* 1D14 */ 0x0000,
/* 1D16 */ 0x0000,
/* 1D18 */ 0x0000,
/* 1D1A */ 0x0000,
/* 1D1C */ 0x0000,
/* 1D1E */ 0x0000,
/* 1D20 */ 0x0000,
/* 1D22 */ 0x0000,
/* 1D24 */ 0x0000,
/* 1D26 */ 0x0000,
/* 1D28 */ 0x0000,
/* 1D2A */ 0x0000,
/* 1D2C */ 0x0000,
/* 1D2E */ 0x0000,
/* 1D30 */ 0x0000,
/* 1D32 */ 0x0000,
/* 1D34 */ 0x0000,
/* 1D36 */ 0x0000,
/* 1D38 */ 0x0000,
/* 1D3A */ 0x0000,
/* 1D3C */ 0x0000,
/* 1D3E */ 0x0000,
/* 1D40 */ 0x0000,
/* 1D42 */ 0x0000,
/* 1D44 */ 0x0000,
/* 1D46 */ 0x0000,
/* 1D48 */ 0x0000,
/* 1D4A */ 0x0000,
/* 1D4C */ 0x0000,
/* 1D4E */ 0x0000,
/* 1D50 */ 0x0000,
/* 1D52 */ 0x0000,
/* 1D54 */ 0x0000,
/* 1D56 */ 0x0000,
/* 1D58 */ 0x0000,
/* 1D5A */ 0x0000,
/* 1D5C */ 0x0000,
/* 1D5E */ 0x0000,
/* 1D60 */ 0x0000,
/* 1D62 */ 0x0000,
/* 1D64 */ 0x0000,
/* 1D66 */ 0x0000,
/* 1D68 */ 0x0000,
/* 1D6A */ 0x0000,
/* 1D6C */ 0x0000,
/* 1D6E */ 0x0000,
/* 1D70 */ 0x0000,
/* 1D72 */ 0x0000,
/* 1D74 */ 0x0000,
/* 1D76 */ 0x0000,
/* 1D78 */ 0x0000,
/* 1D7A */ 0x0000,
/* 1D7C */ 0x0000,
/* 1D7E */ 0x0000,
/* 1D80 */ 0x0000,
/* 1D82 */ 0x0000,
/* 1D84 */ 0x0000,
/* 1D86 */ 0x0000,
/* 1D88 */ 0x0000,
/* 1D8A */ 0x0000,
/* 1D8C */ 0x0000,
/* 1D8E */ 0x0000,
/* 1D90 */ 0x0000,
/* 1D92 */ 0x0000,
/* 1D94 */ 0x0000,
/* 1D96 */ 0x0000,
/* 1D98 */ 0x0000,
/* 1D9A */ 0x0000,
/* 1D9C */ 0x0000,
/* 1D9E */ 0x0000,
/* 1DA0 */ 0x0000,
/* 1DA2 */ 0x0000,
/* 1DA4 */ 0x0000,
/* 1DA6 */ 0x0000,
/* 1DA8 */ 0x0000,
/* 1DAA */ 0x0000,
/* 1DAC */ 0x0000,
/* 1DAE */ 0x0000,
/* 1DB0 */ 0x0000,
/* 1DB2 */ 0x0000,
/* 1DB4 */ 0x0000,
/* 1DB6 */ 0x0000,
/* 1DB8 */ 0x0000,
/* 1DBA */ 0x0000,
/* 1DBC */ 0x0000,
/* 1DBE */ 0x0000,
/* 1DC0 */ 0x0000,
/* 1DC2 */ 0x0000,
/* 1DC4 */ 0x0000,
/* 1DC6 */ 0x0000,
/* 1DC8 */ 0x0000,
/* 1DCA */ 0x0000,
/* 1DCC */ 0x0000,
/* 1DCE */ 0x0000,
/* 1DD0 */ 0x0000,
/* 1DD2 */ 0x0000,
/* 1DD4 */ 0x0000,
/* 1DD6 */ 0x0000,
/* 1DD8 */ 0x0000,
/* 1DDA */ 0x0000,
/* 1DDC */ 0x0000,
/* 1DDE */ 0x0000,
/* 1DE0 */ 0x0000,
/* 1DE2 */ 0x0000,
/* 1DE4 */ 0x0000,
/* 1DE6 */ 0x0000,
/* 1DE8 */ 0x0000,
/* 1DEA */ 0x0000,
/* 1DEC */ 0x0000,
/* 1DEE */ 0x0000,
/* 1DF0 */ 0x0000,
/* 1DF2 */ 0x0000,
/* 1DF4 */ 0x0000,
/* 1DF6 */ 0x0000,
/* 1DF8 */ 0x0000,
/* 1DFA */ 0x0000,
/* 1DFC */ 0x0000,
/* 1DFE */ 0x0000,
/* 1E00 */ 0x0000,
/* 1E02 */ 0x0000,
/* 1E04 */ 0x0000,
/* 1E06 */ 0x0000,
/* 1E08 */ 0x0000,
/* 1E0A */ 0x0000,
/* 1E0C */ 0x0000,
/* 1E0E */ 0x0000,
/* 1E10 */ 0x0000,
/* 1E12 */ 0x0000,
/* 1E14 */ 0x0000,
/* 1E16 */ 0x0000,
/* 1E18 */ 0x0000,
/* 1E1A */ 0x0000,
/* 1E1C */ 0x0000,
/* 1E1E */ 0x0000,
/* 1E20 */ 0x0000,
/* 1E22 */ 0x0000,
/* 1E24 */ 0x0000,
/* 1E26 */ 0x0000,
/* 1E28 */ 0x0000,
/* 1E2A */ 0x0000,
/* 1E2C */ 0x0000,
/* 1E2E */ 0x0000,
/* 1E30 */ 0x0000,
/* 1E32 */ 0x0000,
/* 1E34 */ 0x0000,
/* 1E36 */ 0x0000,
/* 1E38 */ 0x0000,
/* 1E3A */ 0x0000,
/* 1E3C */ 0x0000,
/* 1E3E */ 0x0000,
/* 1E40 */ 0x0000,
/* 1E42 */ 0x0000,
/* 1E44 */ 0x0000,
/* 1E46 */ 0x0000,
/* 1E48 */ 0x0000,
/* 1E4A */ 0x0000,
/* 1E4C */ 0x0000,
/* 1E4E */ 0x0000,
/* 1E50 */ 0x0000,
/* 1E52 */ 0x0000,
/* 1E54 */ 0x0000,
/* 1E56 */ 0x0000,
/* 1E58 */ 0x0000,
/* 1E5A */ 0x0000,
/* 1E5C */ 0x0000,
/* 1E5E */ 0x0000,
/* 1E60 */ 0x0000,
/* 1E62 */ 0x0000,
/* 1E64 */ 0x0000,
/* 1E66 */ 0x0000,
/* 1E68 */ 0x0000,
/* 1E6A */ 0x0000,
/* 1E6C */ 0x0000,
/* 1E6E */ 0x0000,
/* 1E70 */ 0x0000,
/* 1E72 */ 0x0000,
/* 1E74 */ 0x0000,
/* 1E76 */ 0x0000,
/* 1E78 */ 0x0000,
/* 1E7A */ 0x0000,
/* 1E7C */ 0x0000,
/* 1E7E */ 0x0000,
/* 1E80 */ 0x0000,
/* 1E82 */ 0x0000,
/* 1E84 */ 0x0000,
/* 1E86 */ 0x0000,
/* 1E88 */ 0x0000,
/* 1E8A */ 0x0000,
/* 1E8C */ 0x0000,
/* 1E8E */ 0x0000,
/* 1E90 */ 0x0000,
/* 1E92 */ 0x0000,
/* 1E94 */ 0x0000,
/* 1E96 */ 0x0000,
/* 1E98 */ 0x0000,
/* 1E9A */ 0x0000,
/* 1E9C */ 0x0000,
/* 1E9E */ 0x0000,
/* 1EA0 */ 0x0000,
/* 1EA2 */ 0x0000,
/* 1EA4 */ 0x0000,
/* 1EA6 */ 0x0000,
/* 1EA8 */ 0x0000,
/* 1EAA */ 0x0000,
/* 1EAC */ 0x0000,
/* 1EAE */ 0x0000,
/* 1EB0 */ 0x0000,
/* 1EB2 */ 0x0000,
/* 1EB4 */ 0x0000,
/* 1EB6 */ 0x0000,
/* 1EB8 */ 0x0000,
/* 1EBA */ 0x0000,
/* 1EBC */ 0x0000,
/* 1EBE */ 0x0000,
/* 1EC0 */ 0x0000,
/* 1EC2 */ 0x0000,
/* 1EC4 */ 0x0000,
/* 1EC6 */ 0x0000,
/* 1EC8 */ 0x0000,
/* 1ECA */ 0x0000,
/* 1ECC */ 0x0000,
/* 1ECE */ 0x0000,
/* 1ED0 */ 0x0000,
/* 1ED2 */ 0x0000,
/* 1ED4 */ 0x0000,
/* 1ED6 */ 0x0000,
/* 1ED8 */ 0x0000,
/* 1EDA */ 0x0000,
/* 1EDC */ 0x0000,
/* 1EDE */ 0x0000,
/* 1EE0 */ 0x0000,
/* 1EE2 */ 0x0000,
/* 1EE4 */ 0x0000,
/* 1EE6 */ 0x0000,
/* 1EE8 */ 0x0000,
/* 1EEA */ 0x0000,
/* 1EEC */ 0x0000,
/* 1EEE */ 0x0000,
/* 1EF0 */ 0x0000,
/* 1EF2 */ 0x0000,
/* 1EF4 */ 0x0000,
/* 1EF6 */ 0x0000,
/* 1EF8 */ 0x0000,
/* 1EFA */ 0x0000,
/* 1EFC */ 0x0000,
/* 1EFE */ 0x0000,
/* 1F00 */ 0x0000,
/* 1F02 */ 0x0000,
/* 1F04 */ 0x0000,
/* 1F06 */ 0x0000,
/* 1F08 */ 0x0000,
/* 1F0A */ 0x0000,
/* 1F0C */ 0x0000,
/* 1F0E */ 0x0000,
/* 1F10 */ 0x0000,
/* 1F12 */ 0x0000,
/* 1F14 */ 0x0000,
/* 1F16 */ 0x0000,
/* 1F18 */ 0x0000,
/* 1F1A */ 0x0000,
/* 1F1C */ 0x0000,
/* 1F1E */ 0x0000,
/* 1F20 */ 0x0000,
/* 1F22 */ 0x0000,
/* 1F24 */ 0x0000,
/* 1F26 */ 0x0000,
/* 1F28 */ 0x0000,
/* 1F2A */ 0x0000,
/* 1F2C */ 0x0000,
/* 1F2E */ 0x0000,
/* 1F30 */ 0x0000,
/* 1F32 */ 0x0000,
/* 1F34 */ 0x0000,
/* 1F36 */ 0x0000,
/* 1F38 */ 0x0000,
/* 1F3A */ 0x0000,
/* 1F3C */ 0x0000,
/* 1F3E */ 0x0000,
/* 1F40 */ 0x0000,
/* 1F42 */ 0x0000,
/* 1F44 */ 0x0000,
/* 1F46 */ 0x0000,
/* 1F48 */ 0x0000,
/* 1F4A */ 0x0000,
/* 1F4C */ 0x0000,
/* 1F4E */ 0x0000,
/* 1F50 */ 0x0000,
/* 1F52 */ 0x0000,
/* 1F54 */ 0x0000,
/* 1F56 */ 0x0000,
/* 1F58 */ 0x0000,
/* 1F5A */ 0x0000,
/* 1F5C */ 0x0000,
/* 1F5E */ 0x0000,
/* 1F60 */ 0x0000,
/* 1F62 */ 0x0000,
/* 1F64 */ 0x0000,
/* 1F66 */ 0x0000,
/* 1F68 */ 0x0000,
/* 1F6A */ 0x0000,
/* 1F6C */ 0x0000,
/* 1F6E */ 0x0000,
/* 1F70 */ 0x0000,
/* 1F72 */ 0x0000,
/* 1F74 */ 0x0000,
/* 1F76 */ 0x0000,
/* 1F78 */ 0x0000,
/* 1F7A */ 0x0000,
/* 1F7C */ 0x0000,
/* 1F7E */ 0x0000,
/* 1F80 */ 0x0000,
/* 1F82 */ 0x0000,
/* 1F84 */ 0x0000,
/* 1F86 */ 0x0000,
/* 1F88 */ 0x0000,
/* 1F8A */ 0x0000,
/* 1F8C */ 0x0000,
/* 1F8E */ 0x0000,
/* 1F90 */ 0x0000,
/* 1F92 */ 0x0000,
/* 1F94 */ 0x0000,
/* 1F96 */ 0x0000,
/* 1F98 */ 0x0000,
/* 1F9A */ 0x0000,
/* 1F9C */ 0x0000,
/* 1F9E */ 0x0000,
/* 1FA0 */ 0x0000,
/* 1FA2 */ 0x0000,
/* 1FA4 */ 0x0000,
/* 1FA6 */ 0x0000,
/* 1FA8 */ 0x0000,
/* 1FAA */ 0x0000,
/* 1FAC */ 0x0000,
/* 1FAE */ 0x0000,
/* 1FB0 */ 0x0000,
/* 1FB2 */ 0x0000,
/* 1FB4 */ 0x0000,
/* 1FB6 */ 0x0000,
/* 1FB8 */ 0x0000,
/* 1FBA */ 0x0000,
/* 1FBC */ 0x0000,
/* 1FBE */ 0x0000,
/* 1FC0 */ 0x0000,
/* 1FC2 */ 0x0000,
/* 1FC4 */ 0x0000,
/* 1FC6 */ 0x0000,
/* 1FC8 */ 0x0000,
/* 1FCA */ 0x0000,
/* 1FCC */ 0x0000,
/* 1FCE */ 0x0000,
/* 1FD0 */ 0x0000,
/* 1FD2 */ 0x0000,
/* 1FD4 */ 0x0000,
/* 1FD6 */ 0x0000,
/* 1FD8 */ 0x0000,
/* 1FDA */ 0x0000,
/* 1FDC */ 0x0000,
/* 1FDE */ 0x0000,
/* 1FE0 */ 0x0000,
/* 1FE2 */ 0x0000,
/* 1FE4 */ 0x0000,
/* 1FE6 */ 0x0000,
/* 1FE8 */ 0x0000,
/* 1FEA */ 0x0000,
/* 1FEC */ 0x0000,
/* 1FEE */ 0x0000,
/* 1FF0 */ 0x0000,
/* 1FF2 */ 0x0000,
/* 1FF4 */ 0x0000,
/* 1FF6 */ 0x0000,
/* 1FF8 */ 0x0000,
/* 1FFA */ 0x0000,
/* 1FFC */ 0x0000,
/* 1FFE */ 0x0000
/* END; */

};

void setup()
{ 
        Serial.begin(115200);
	clock = 0;
	P = pgm_read_word(&code[0x480]);
	IP = 0;
	S = stack;
	R = rack;
	top = 0;
	phase = 0;
	cCode = (unsigned char *) code;
	Serial.println("");
	Serial.println("Start Arduino");
	Serial.println("");
}

/* Main Program */

void loop()
{	phase = clock & 3;
	  switch(phase) {
		case 0: fetch_decode(); break;
		case 1: execute(I1); break;
		case 2: execute(I2); break;
		case 3: jump(); break;
	    } 
	  clock += 1; 
/*	if ( Serial.available()>0 ) 
	{
	  n = Serial.read();
	  switch(phase) {
		case 0: fetch_decode(); break;
		case 1: execute(I1); break;
		case 2: execute(I2); break;
		case 3: jump(); break;
	    } 
	  Serial.println(n, HEX);
	  Serial.print("clock=");
	  Serial.print(clock,HEX);
  	  Serial.print(" IP=");
	  Serial.print(IP,HEX);
	  Serial.print(" P=");
	  Serial.print(P,HEX);
	  Serial.print(" I=");
	  Serial.print(I,HEX);
	  Serial.print(" I1=");
	  Serial.print(I1,HEX);
	  Serial.print(" I2=");
	  Serial.println(I2,HEX);
	  dumpStack(); 
          clock += 1; 
	 } */
}
void dumpStack(void)
{ int n;
  Serial.print("S=" );
  for ( n = 0; n <= (S-stack) ; n++ )
  { Serial.print(stack[n],HEX);
    Serial.print(" "); } 
  Serial.println(top,HEX );
  Serial.print("R=" );
  for ( n = 0; n <= (R-rack) ; n++ )
  { Serial.print(rack[n],HEX);
    Serial.print(" "); } 
  Serial.println(""); 
}
void jump(void) { clock |= 3; } 
void fetch_decode(void) 
{ if ( P < 0x900) { I = data[P>>1]; }
  else { I = pgm_read_word(&code[P>>1]); }
  P += 2; 
  I1= (unsigned char) (I & 0xFF); 
  I2= (unsigned char) (I >> 8 );
}
void next(void) 
{ if ( IP < 0x900) { P = data[IP>>1]; }
  else { P = pgm_read_word(&code[IP>>1]); }
  IP += 2; jump(); } 
void bye() { exit(0); } 
void qrx(void)
  { while (Serial.available() == 0) {};
    push Serial.read();
    push 0xFFFF; }
void txsto(void) { Serial.write( (char) top); pop; } 
void emit(void) { txsto(); } 
void docon(void) 
{ if ( P < 0x900) { push data[P>>1]; }
  else { push pgm_read_word(&code[P>>1]); }
  P += 2; } 
void dolit(void) 
{ if ( IP < 0x900) { push data[IP>>1]; }
  else  { push pgm_read_word(&code[IP>>1]); }
  IP += 2; next(); } 
void dolist(void) { *++R = IP; IP = P; next(); }
void exitt(void) { IP = *R--; next(); } 
void execu(void) { *++R = IP; P = top; pop; jump(); } 
void donext(void)
  { if(*R) { *R -= 1 ; 
    { if ( IP < 0x900) { IP = data[IP>>1]; }
      else { IP = pgm_read_word(&code[IP>>1]); }
    }}
    else { IP += 2; R-- ; } next(); } 
void qbran(void) 
  { if(top == 0) 
    { if ( IP < 0x900) { IP = data[IP>>1]; }
      else { IP = pgm_read_word(&code[IP>>1]); }
    } 
    else IP += 2; pop; next(); } 
void bran(void) 
{ if ( IP < 0x900) { IP = data[IP>>1]; }
  else { IP = pgm_read_word(&code[IP>>1]); }
  next(); } 
void store(void) 
  { data[top>>1] = *S--; pop; } 
void cstore(void) 
  { cData[top] = (char) *S--; pop; } 
void at(void) 
{ if ( top < 0x900) { top = data[top>>1]; }
  else { top = pgm_read_word(&code[top>>1]); }
  } 
void cat(void) 
  { if (top < 0x900) top = (int) cData[top];
    else top = (int) pgm_read_byte(&cCode[top]); } 
void icat(void) { top = (int) pgm_read_byte(&cCode[top]); } 
void iat(void) { top = pgm_read_word(&code[top]); } 
void istore(void) { pop; pop; } 
void icstore(void) { pop; pop; } 
void rfrom(void) { push *R--; } 
void rat(void) { push *R; } 
void tor(void) { *++R = top; pop; } 
void rpsto(void) { R = rack; } 
void spsto(void) { S = stack; } 
void drop(void) { pop; } 
void dup(void) { *++S = top; } 
void swap(void) { w = top; top = *S; *S = w; } 
void over(void) { push S[-1]; } 
void zless(void) { top = (top & 0X8000) LOGICAL ; } 
void andd(void) { top &= *S--; } 
void orr(void) { top |= *S--; } 
void xorr(void) { top ^= *S--; } 
void uplus(void) { *S += top; top = LOWER(*S, top) ; } 
void nop(void) { jump(); } 
void dovar(void) { push P; } 
void (*primitives[64])(void) = {
    /* case 0 */ nop,
    /* case 1 */ bye, 
    /* case 2 */ qrx,    
    /* case 3 */ txsto,  
    /* case 4 */ docon, 	
    /* case 5 */ dolit,
    /* case 6 */ dolist,
    /* case 7 */ exitt,
    /* case 8 */ execu,
    /* case 9 */ donext,
    /* case 10 */ qbran,
    /* case 11 */ bran,
    /* case 12 */ store,
    /* case 13 */ at,
    /* case 14 */ cstore,
    /* case 15 */ cat,
    /* case 16 */ icat,
    /* case 17 */ iat,
    /* case 18 */ rfrom,
    /* case 19 */ rat,
    /* case 20 */ tor,
    /* case 21 */ dovar, 
    /* case 22 */ next,
    /* case 23 */ drop,
    /* case 24 */ dup,
    /* case 25 */ swap,
    /* case 26 */ over,
    /* case 27 */ zless,
    /* case 28 */ andd,
    /* case 29 */ orr,
    /* case 30 */ xorr,
    /* case 31 */ uplus,
    /* case 32 */ icat
};

void execute(unsigned char icode)
{   if(icode < 33) {
    primitives[icode]();
  } else {
    Serial.println ("");
    Serial.print ("Illegal code=");
    Serial.print(icode, HEX) ;
    Serial.print(" P=" ) ;
    Serial.println(P, HEX ) ;
  }
} 	 

/* End of eforth.c */
