// FILE: ChipNorm_LED_Matrix.h
// VERSION: 1.0.0
//
// ChipNorm invests time and resources providing this open code,
// please support ChipNorm by purchasing products from ChipNorm.
//
// Written by Enrique Fernandez for ChipNorm by FMH.
//
// Copyright   Copyright (c) 2025 Enrique Fernandez - ChipNorm by FMH
// See the LICENSE file for details.

#include "ChipNorm_LED_Matrix.h" 
#include <array>

const std::array<ByteBlock, 128> CharTable = {
	// 0-31: Steuerzeichen (leer)
	ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{},
	ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{},
	ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{},
	ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{}, ByteBlock{},

	// 32: Leerzeichen (Space)
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // ' '

	// 33-47: Sonderzeichen (Optimierter Font 5x7, zentriert)
	ByteBlock{0x00, 0x3E, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00}, // ! 
	ByteBlock{0x00, 0x00, 0x54, 0x54, 0x00, 0x00, 0x00, 0x00}, // "
	ByteBlock{0x00, 0x00, 0x14, 0x7E, 0x14, 0x7E, 0x14, 0x00}, // #
	ByteBlock{0x00, 0x00, 0x28, 0x4C, 0x7E, 0x4C, 0x24, 0x00}, // $
	ByteBlock{0x00, 0x00, 0x62, 0x64, 0x08, 0x12, 0x36, 0x00}, // %
	ByteBlock{0x00, 0x00, 0x28, 0x44, 0x2A, 0x52, 0x4C, 0x00}, // &
	ByteBlock{0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00}, // '
	ByteBlock{0x00, 0x00, 0x10, 0x20, 0x20, 0x20, 0x10, 0x00}, // (
	ByteBlock{0x00, 0x00, 0x20, 0x10, 0x10, 0x10, 0x20, 0x00}, // )
	ByteBlock{0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00}, // *
	ByteBlock{0x00, 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00}, // +
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00}, // ,
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00}, // - (Mitte)
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00}, // .
	ByteBlock{0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00}, // /

	// 48-57: Ziffern (0-9) 
	ByteBlock{0x00, 0x3C, 0x46, 0x4A, 0x52, 0x62, 0x3C, 0x00}, // 0
	ByteBlock{0x00, 0x08, 0x18, 0x38, 0x08, 0x08, 0x7E, 0x00}, // 1
	ByteBlock{0x00, 0x3C, 0x42, 0x04, 0x08, 0x10, 0x7E, 0x00}, // 2
	ByteBlock{0x00, 0x3C, 0x42, 0x04, 0x18, 0x42, 0x3C, 0x00}, // 3
	ByteBlock{0x00, 0x20, 0x30, 0x50, 0x7E, 0x00, 0x10, 0x00}, // 4 
	ByteBlock{0x00, 0x7E, 0x40, 0x7C, 0x02, 0x02, 0x3C, 0x00}, // 5 
	ByteBlock{0x00, 0x3C, 0x40, 0x7C, 0x44, 0x44, 0x3C, 0x00}, // 6
	ByteBlock{0x00, 0x7E, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00}, // 7
	ByteBlock{0x00, 0x3C, 0x42, 0x3C, 0x42, 0x42, 0x3C, 0x00}, // 8 
	ByteBlock{0x00, 0x3C, 0x44, 0x3C, 0x04, 0x04, 0x3C, 0x00}, // 9

	// 58-64: Weitere Sonderzeichen
	ByteBlock{0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00}, // :
	ByteBlock{0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00}, // ;
	ByteBlock{0x00, 0x00, 0x10, 0x20, 0x40, 0x20, 0x10, 0x00}, // <
	ByteBlock{0x00, 0x00, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x00}, // =
	ByteBlock{0x00, 0x00, 0x40, 0x20, 0x10, 0x20, 0x40, 0x00}, // >
	ByteBlock{0x00, 0x00, 0x3C, 0x42, 0x04, 0x08, 0x08, 0x00}, // ?
	ByteBlock{0x00, 0x3C, 0x42, 0x5A, 0x5A, 0x42, 0x3C, 0x00}, // @ (Verbessert)

	// 65-90: Großbuchstaben (A-Z)
	ByteBlock{0x00, 0x3C, 0x42, 0x42, 0x7E, 0x42, 0x42, 0x00}, // A
	ByteBlock{0x00, 0x7C, 0x42, 0x7C, 0x42, 0x42, 0x7C, 0x00}, // B
	ByteBlock{0x00, 0x3C, 0x42, 0x40, 0x40, 0x42, 0x3C, 0x00}, // C
	ByteBlock{0x00, 0x7C, 0x42, 0x42, 0x42, 0x42, 0x7C, 0x00}, // D
	ByteBlock{0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x7E, 0x00}, // E
	ByteBlock{0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x40, 0x00}, // F
	ByteBlock{0x00, 0x3C, 0x42, 0x40, 0x4E, 0x42, 0x3C, 0x00}, // G 
	ByteBlock{0x00, 0x42, 0x42, 0x7E, 0x42, 0x42, 0x42, 0x00}, // H
	ByteBlock{0x00, 0x7E, 0x08, 0x08, 0x08, 0x08, 0x7E, 0x00}, // I
	ByteBlock{0x00, 0x04, 0x02, 0x02, 0x42, 0x42, 0x3C, 0x00}, // J
	ByteBlock{0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x42, 0x00}, // K
	ByteBlock{0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7E, 0x00}, // L
	ByteBlock{0x00, 0x42, 0x66, 0x5A, 0x42, 0x42, 0x42, 0x00}, // M 
	ByteBlock{0x00, 0x42, 0x62, 0x52, 0x4A, 0x46, 0x42, 0x00}, // N
	ByteBlock{0x00, 0x3C, 0x42, 0x42, 0x42, 0x42, 0x3C, 0x00}, // O
	ByteBlock{0x00, 0x7C, 0x42, 0x42, 0x7C, 0x40, 0x40, 0x00}, // P
	ByteBlock{0x00, 0x3C, 0x42, 0x42, 0x4A, 0x46, 0x3E, 0x00}, // Q 
	ByteBlock{0x00, 0x7C, 0x42, 0x7C, 0x48, 0x44, 0x42, 0x00}, // R
	ByteBlock{0x00, 0x3C, 0x40, 0x3C, 0x02, 0x02, 0x7C, 0x00}, // S
	ByteBlock{0x00, 0x7E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00}, // T
	ByteBlock{0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7C, 0x00}, // U
	ByteBlock{0x00, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00}, // V
	ByteBlock{0x00, 0x42, 0x42, 0x42, 0x5A, 0x66, 0x42, 0x00}, // W 
	ByteBlock{0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00}, // X
	ByteBlock{0x00, 0x42, 0x42, 0x24, 0x18, 0x08, 0x08, 0x00}, // Y
	ByteBlock{0x00, 0x7E, 0x04, 0x08, 0x10, 0x20, 0x7E, 0x00}, // Z
	ByteBlock{0x00, 0x7C, 0x40, 0x40, 0x40, 0x40, 0x7C, 0x00}, // [
	ByteBlock{0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00}, // 
	ByteBlock{0x00, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x00}, // ]
	ByteBlock{0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00}, // ^
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E}, // _
	ByteBlock{0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00}, // `
    
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x7E, 0x00}, // a 
	ByteBlock{0x00, 0x40, 0x40, 0x7C, 0x44, 0x44, 0x7C, 0x00}, // b
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x40, 0x40, 0x3C, 0x00}, // c
	ByteBlock{0x00, 0x04, 0x04, 0x3C, 0x44, 0x44, 0x3C, 0x00}, // d
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x44, 0x7C, 0x40, 0x00}, // e
	ByteBlock{0x00, 0x18, 0x20, 0x7C, 0x20, 0x20, 0x20, 0x00}, // f
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x44, 0x3C, 0x04, 0x38}, // g 
	ByteBlock{0x00, 0x40, 0x40, 0x7C, 0x44, 0x44, 0x44, 0x00}, // h
	ByteBlock{0x00, 0x08, 0x00, 0x18, 0x08, 0x08, 0x38, 0x00}, // i
	ByteBlock{0x00, 0x04, 0x00, 0x04, 0x02, 0x02, 0x3C, 0x00}, // j 
	ByteBlock{0x00, 0x40, 0x40, 0x44, 0x48, 0x50, 0x44, 0x00}, // k
	ByteBlock{0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x3E, 0x00}, // l
	ByteBlock{0x00, 0x00, 0x00, 0x7E, 0x5A, 0x5A, 0x5A, 0x00}, // m
	ByteBlock{0x00, 0x00, 0x00, 0x7C, 0x44, 0x44, 0x44, 0x00}, // n
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x00}, // o
	ByteBlock{0x00, 0x00, 0x00, 0x7C, 0x44, 0x44, 0x7C, 0x40}, // p 
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x44, 0x3C, 0x04, 0x02}, // q 
	ByteBlock{0x00, 0x00, 0x00, 0x7C, 0x40, 0x40, 0x40, 0x00}, // r
	ByteBlock{0x00, 0x00, 0x00, 0x3C, 0x40, 0x1C, 0x04, 0x00}, // s
	ByteBlock{0x00, 0x20, 0x20, 0x7E, 0x20, 0x20, 0x1C, 0x00}, // t 
	ByteBlock{0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x3C, 0x00}, // u
	ByteBlock{0x00, 0x00, 0x00, 0x44, 0x44, 0x24, 0x18, 0x00}, // v
	ByteBlock{0x00, 0x00, 0x00, 0x44, 0x4A, 0x52, 0x24, 0x00}, // w ('s' entfernt)
	ByteBlock{0x00, 0x00, 0x00, 0x44, 0x24, 0x18, 0x24, 0x00}, // x
	ByteBlock{0x00, 0x00, 0x00, 0x44, 0x24, 0x18, 0x24, 0x18}, // y (hängt)
	ByteBlock{0x00, 0x00, 0x00, 0x7E, 0x04, 0x08, 0x7E, 0x00}, // z
    
	// 123-127: Letzte Sonderzeichen
	ByteBlock{0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00}, // {
	ByteBlock{0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x7E, 0x00}, // |
	ByteBlock{0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x38, 0x00}, // }
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // ~
	ByteBlock{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // DEL
};


ByteBlock MAX72XX_Helper::getCharBlock(char c) noexcept {
	unsigned int index = static_cast<unsigned int>(c);
    
	if (index >= CharTable.size()) {
		index = 32; // Fallback: Leerzeichen (' ')
	}
    
	return CharTable[index];
}