#include <Arduino.h>
#include "Simple_Esp32WiFiManager.h"

// Variables para controlar el tiempo de conexión
unsigned long previousMillis = 0;
const long interval = 10000;  // Tiempo máximo para intentar conectar (10 seg)

// Pin del LED integrado en la ESP32
const int ledPin = 2;
String ledState;   // Estado actual del LED (ON / OFF)


String processor(const String& var) {
  if(var == "STATE") {
    if(digitalRead(ledPin)) {
      ledState = "ON";
    }
    else {
      ledState = "OFF";
    }
    return ledState;
  }
  return String();
}

void setup() {
  Serial.begin(115200);

  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, LOW);   // LED apagado por defecto

startWiFiManager();  // 🔹 se encarga de todo el manejo WiFi
 if (WiFi.status() == WL_CONNECTED)
   { 
    // Si conecta, configura el servidor para controlar el LED y servir la página principal
    server.on("/", HTTP_GET, [](AsyncWebServerRequest *request) {
      request->send(LittleFS, "/index.html", "text/html", false, processor);
    });
    server.serveStatic("/", LittleFS, "/");
    
    // Endpoints para controlar el LED
    server.on("/on", HTTP_GET, [](AsyncWebServerRequest *request) {
      digitalWrite(ledPin, HIGH);
      request->send(LittleFS, "/index.html", "text/html", false, processor);
    });

    server.on("/off", HTTP_GET, [](AsyncWebServerRequest *request) {
      digitalWrite(ledPin, LOW);
      request->send(LittleFS, "/index.html", "text/html", false, processor);
    });

    server.begin();  // Inicia el servidor web
  // Acá tu lógica principal, ya con WiFi funcionando
    // Configura el pin del LED como salida
  }

}

void loop() {
  // Acá tu lógica principal, ya con WiFi funcionando
}
