#include <Arduino.h>
#include "Simple_Esp32WiFiManager.h"
#include <WiFiUdp.h>
#include <NTPClient.h>

// Cliente UDP para NTP
WiFiUDP ntpUDP;
// Cliente NTP configurado para hora de Argentina (GMT-3)
NTPClient timeClient(ntpUDP, "pool.ntp.org", -3 * 3600, 60000);

void setup() {
  Serial.begin(115200);
  delay(1000);

  // Inicia WiFi Manager
  startWiFiManager();

  // Si está conectado, inicia NTP
  if (WiFi.status() == WL_CONNECTED) {
    timeClient.begin();
    Serial.println("⌛ Sincronizando con servidor NTP...");
  }
}

void loop() {
  if (WiFi.status() == WL_CONNECTED) {
    timeClient.update();

    // Obtiene la hora en formato HH:MM:SS
    String formattedTime = timeClient.getFormattedTime();
    Serial.print("⏰ Hora actual: ");
    Serial.println(formattedTime);

    delay(2000);
  } 
  else {
    Serial.println("⚠️ No hay conexión WiFi...");
    delay(2000);
  }
}
