#include <LittleFS.h>

// Serial para depuración
#define SerialMon Serial

void setup() {
    SerialMon.begin(115200);
    while (!SerialMon) {
        delay(5000); // Esperar a que se inicie el puerto serie
    }

    SerialMon.println("Iniciando LittleFS...");

    // Inicializar LittleFS
    if (!LittleFS.begin()) {
        SerialMon.println("Error al montar LittleFS");
        return;
    }
    delay(1000);
    SerialMon.println("LittleFS montado correctamente.");
    
    listarArchivos();

    SerialMon.println("\nIngresa el nombre del archivo para leer su contenido, 'BORRAR' para eliminar un archivo, o 'BORRAR_TODO' para eliminar todos los archivos:");
}

void loop() {
    if (SerialMon.available()) {
        String entrada = SerialMon.readStringUntil('\n');
        entrada.trim(); // Eliminar espacios y saltos de línea

        if (entrada.equalsIgnoreCase("BORRAR_TODO")) {
            borrarTodosArchivos();
        } else if (entrada.equalsIgnoreCase("BORRAR")) {
            SerialMon.println("Ingresa el nombre del archivo que deseas borrar:");
            while (!SerialMon.available()) {
                delay(100); // Esperar a que el usuario ingrese el nombre del archivo
            }
            String archivoABorrar = SerialMon.readStringUntil('\n');
            archivoABorrar.trim();
            borrarArchivo(archivoABorrar);
        } else if (entrada.length() > 0) {
            imprimirContenidoArchivo(entrada);
        }

        SerialMon.println("\nIngresa otro comando o nombre de archivo:");
    }
}

// Función para listar todos los archivos en el sistema LittleFS con tamaños
void listarArchivos() {
    SerialMon.println("Archivos disponibles en LittleFS:");

    File root = LittleFS.open("/", "r");
    if (!root || !root.isDirectory()) {
        SerialMon.println("Error: No se pudo abrir el directorio raíz.");
        return;
    }

    File archivo = root.openNextFile();
    while (archivo) {
        SerialMon.print("- ");
        SerialMon.print(archivo.name()); // Nombre del archivo
        SerialMon.print(" (");
        SerialMon.print(archivo.size() / 1024.0, 2); // Tamaño en KB con 2 decimales
        SerialMon.println(" KB)");
        archivo = root.openNextFile();
    }
}

// Función para leer e imprimir el contenido de un archivo
void imprimirContenidoArchivo(const String& nombreArchivo) {
    SerialMon.print("Abriendo archivo: ");
    SerialMon.println(nombreArchivo);

    File archivo = LittleFS.open("/" + nombreArchivo, "r");

    if (!archivo) {
        SerialMon.println("Error: No se pudo abrir el archivo.");
        return;
    }

    SerialMon.println("Contenido del archivo:");
    while (archivo.available()) {
        char c = archivo.read();
        SerialMon.print(c); // Imprime carácter por carácter
    }

    archivo.close();
    SerialMon.println("\n--- Fin del archivo ---");
}

// Función para borrar un archivo específico
void borrarArchivo(const String& nombreArchivo) {
    SerialMon.print("Intentando borrar el archivo: ");
    SerialMon.println(nombreArchivo);

    if (LittleFS.remove("/" + nombreArchivo)) {
        SerialMon.println("Archivo eliminado exitosamente.");
    } else {
        SerialMon.println("Error: No se pudo eliminar el archivo. Verifica que exista.");
    }
}

// Función para borrar todos los archivos en LittleFS
void borrarTodosArchivos() {
    SerialMon.println("Borrando todos los archivos en LittleFS...");

    File root = LittleFS.open("/", "r");
    if (!root || !root.isDirectory()) {
        SerialMon.println("Error: No se pudo abrir el directorio raíz.");
        return;
    }

    File archivo = root.openNextFile();
    while (archivo) {
        String nombreArchivo = archivo.name();
        archivo.close();

        if (LittleFS.remove(nombreArchivo)) {
            SerialMon.print("Archivo eliminado: ");
            SerialMon.println(nombreArchivo);
        } else {
            SerialMon.print("Error al eliminar: ");
            SerialMon.println(nombreArchivo);
        }

        archivo = root.openNextFile();
    }

    SerialMon.println("Todos los archivos han sido eliminados.");
}
