# Leeme y sigue los paso para usar "Simple_Esp32WiFiManager"

 **Simple_Esp32WiFiManager**
Es un gestor WiFi para ESP32 que permite configurar redes inalámbricas sin necesidad de reprogramar el dispositivo, mediante un portal web alojado en LittleFS.

---

## 1) Lo Primero de todo, necesitamos la Instalación del "LittleFS Uploader" 

Para subir los archivos de la carpeta `data/` (HTML, CSS, JS, etc.) a la memoria flash del ESP32, necesitas el plugin **LittleFS Uploader**.

Tutorial detallado con imágenes: [Random Nerd Tutorials](https://randomnerdtutorials.com/arduino-ide-2-install-esp32-littlefs/)

### Pasos para Windows (Arduino IDE 2.x)

1. Descargá el archivo `.vsix` del plugin desde la página del tutorial de [Random Nerd Tutorials]
2. **Windows:** Localizá la carpeta de plugins de Arduino IDE.
   * Windows: `C:\Users\<tu_usuario>\.arduinoIDE\plugins\`
3. Mové el archivo `.vsix` a esa carpeta.
4. Reiniciá Arduino IDE.
5. Abrí el **Command Palette**:
   * Windows/Linux: `Ctrl+Shift+P`
6. Seleccioná **Upload LittleFS to Pico/ESP8266/ESP32**.
7. Cerrá el Serial Monitor antes de subir para evitar conflictos.
8. El plugin subirá automáticamente todos los archivos de la carpeta `data/` a la memoria LittleFS del ESP32.

### Pasos para Linux o macOS (Arduino IDE 2.x)

9. Descargá el archivo `.vsix` del plugin desde la página del tutorial de [Random Nerd Tutorials]
10. **Linux/macOS:** Localizá la carpeta de plugins de Arduino IDE.
   * Linux/macOS: `~/.arduinoIDE/plugins/`
11. Mové el archivo `.vsix` a esa carpeta.
12. Reiniciá Arduino IDE.
13. Abrí el **Command Palette**:   
   * macOS: `⌘+Shift+P`
14. Seleccioná **Upload LittleFS to Pico/ESP8266/ESP32**.
15. Cerrá el Serial Monitor antes de subir para evitar conflictos.
16. El plugin subirá automáticamente todos los archivos de la carpeta `data/` a la memoria LittleFS del ESP32.

---

## 2) Despues instalamos las librerías para trabajar con la carpeta "data" que despues crearemos. 

* ESPAsyncWebServer by ESP32Async
* AsyncTCP by ESP32Async

1. Instala las liberias desde Arduino: 

* Async TCP Library for ESP32** AsyncTCP -> **by ESP32 Async** (#include <AsyncTCP.h>)
* Async Web Server for ESP32** ESPAsyncWebServer -> **by ESP32 Async** (#include <ESPAsyncWebServer.h>) 

2. Ó descarga desde los repositorios e instala el archivo .zip
  # Async TCP Library for ESP32*
  * https://github.com/ESP32Async/AsyncTCP.git
  * `https://github.com/ESP32Async/AsyncTCP/archive/refs/heads/main.zip`.

  # Async Web Server for ESP32*
  * https://github.com/ESP32Async/ESPAsyncWebServer.git
  * `https://github.com/ESP32Async/ESPAsyncWebServer/archive/refs/heads/main.zip`.


3. Reiniciá Arduino IDE para que reconozca la nueva librería.

---

## 3) Preparar la carpeta `data/`

Dentro de **"Sketch"** en la barra de Arduino ide, dirigete a "Mostrar carpeta de Sketch", crea una carpeta llamada `data/` y colocá allí tus archivos HTML, CSS o JS:

```
MiSketch/
├─ MiSketch.ino
└─ data/
   ├─ wifimanager.html
   └─ index.html
```

Sube los archivos a la memoria del ESP32 usando **LittleFS Uploader**. siguiendo los pasos del punto 1.

Estos son los archivos... que tienen que estar dentro de la carpeta "data"

### wifimanager.html ###
### index.html ###

## 4) Uso básico

```cpp
#include <Arduino.h>
#include "Simple_Esp32WiFiManager.h"

void setup() {
  Serial.begin(115200);
  startWiFiManager();   // 🔹 se encarga de todo el manejo WiFi
}

void loop() {
  // Acá tu lógica principal, ya con WiFi funcionando
    if (WiFi.status() == WL_CONNECTED)
   {   
    Serial.print("Conectado !!!");
    delay(2000);

    //Pon aqui Tu codigo ya que Estas conectado a WIFI...
    //

   } 
  else
   {
    Serial.println("⚠️ No hay conexión WiFi...");
    delay(2000);
   }
}
```

* Si hay WiFi guardada → conecta automáticamente.
* Si no hay WiFi guardada o falla → crea un Access Point con el nombre configurado y un portal web para ingresar SSID y contraseña.
* Una vez guardada la configuración, reiniciá el ESP32 y se conectará automáticamente.

---

## 5) Ejemplo incluido

* Carpeta `examples/basic/` → ejemplo mínimo usando la librería.
* Carpeta `examples/horaNTP/` → ejemplo Mostrando la Hora.
* Carpeta `examples/ledWebserver/` → ejemplo usando index.html creando WebServer para encender un led.
---

## 6) Enlaces útiles

* Tutorial LittleFS Uploader: [Random Nerd Tutorials](https://randomnerdtutorials.com/arduino-ide-2-install-esp32-littlefs/)

* Tutorial ESP32 Web Server using LittleFS Filesystem (serve files from filesystem)
https://randomnerdtutorials.com/esp32-web-server-littlefs/#more-170074

---

### 7) Info

* exzelente@gmail.com 
* Carlos Jimeno Lorenzo 
