// This file was generated by the following script:
//
//   $ /home/brian/src/AceTimeSuite/compiler/src/acetimecompiler/tzcompiler.py
//     --input_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/testingzonedbc/tzfiles
//     --output_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/testingzonedbc
//     --tz_version 2025b
//     --action zonedb
//     --language arduino
//     --scope complete
//     --db_namespace testingzonedbc
//     --zi_namespace complete::Info
//     --include_list include_list.txt
//     --nocompress
//     --start_year 1980
//     --until_year 2200
//
// using the TZ Database files
//
//   africa
//   antarctica
//   asia
//   australasia
//   backward
//   etcetera
//   europe
//   northamerica
//   southamerica
//
// from https://github.com/eggert/tz/releases/tag/2025b
//
// Supported Zones: 16 (15 zones, 1 links)
// Unsupported Zones: 581 (325 zones, 256 links)
//
// Requested Years: [1980,2200]
// Accurate Years: [1980,32767]
//
// Original Years:  [1844,2087]
// Generated Years: [1945,2087]
// Lower/Upper Truncated: [True,False]
//
// Estimator Years: [1945,2090]
// Max Buffer Size: 7
//
// Records:
//   Infos: 16
//   Eras: 30
//   Policies: 11
//   Rules: 220
//
// Memory (8-bits):
//   Context: 20
//   Rules: 2640
//   Policies: 33
//   Eras: 450
//   Zones: 195
//   Links: 13
//   Registry: 32
//   Formats: 47
//   Letters: 23
//   Fragments: 0
//   Names: 260 (original: 260)
//   TOTAL: 3713
//
// Memory (32-bits):
//   Context: 28
//   Rules: 2640
//   Policies: 88
//   Eras: 600
//   Zones: 360
//   Links: 24
//   Registry: 64
//   Formats: 47
//   Letters: 33
//   Fragments: 0
//   Names: 260 (original: 260)
//   TOTAL: 4144
//
// DO NOT EDIT

#include <zoneinfo/compat.h>
#include "zone_policies.h"

namespace ace_time {
namespace testingzonedbc {

//---------------------------------------------------------------------------
// Policies: 11
// Rules: 220
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Policy name: Aus
// Rules: 1
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesAus[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Aus    1943    1944    -    Mar    lastSun    2:00s    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyAus ACE_TIME_PROGMEM = {
  kZoneRulesAus /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Canada
// Rules: 7
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesCanada[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Canada    1945    only    -    Sep    30    2:00    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1945    only    -    Sep    30    2:00    0    S
  {
    1945 /*fromYear*/,
    1945 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1974    1986    -    Apr    lastSun    2:00    1:00    D
  {
    1974 /*fromYear*/,
    1986 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    1974    2006    -    Oct    lastSun    2:00    0    S
  {
    1974 /*fromYear*/,
    2006 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    1987 /*fromYear*/,
    2006 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    2007 /*fromYear*/,
    32766 /*toYear*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    2007 /*fromYear*/,
    32766 /*toYear*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyCanada ACE_TIME_PROGMEM = {
  kZoneRulesCanada /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: EU
// Rules: 6
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesEU[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    EU    1978    only    -    Oct     1     1:00u    0    -
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1977    1980    -    Apr    Sun>=1     1:00u    1:00    S
  {
    1977 /*fromYear*/,
    1980 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    32 /*atTimeModifier (kAtcSuffixU + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    60 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    EU    1978    only    -    Oct     1     1:00u    0    -
  {
    1978 /*fromYear*/,
    1978 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    32 /*atTimeModifier (kAtcSuffixU + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    1979 /*fromYear*/,
    1995 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    32 /*atTimeModifier (kAtcSuffixU + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1981    max    -    Mar    lastSun     1:00u    1:00    S
  {
    1981 /*fromYear*/,
    32766 /*toYear*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    32 /*atTimeModifier (kAtcSuffixU + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    60 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    EU    1996    max    -    Oct    lastSun     1:00u    0    -
  {
    1996 /*fromYear*/,
    32766 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    32 /*atTimeModifier (kAtcSuffixU + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyEU ACE_TIME_PROGMEM = {
  kZoneRulesEU /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Edm
// Rules: 4
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesEdm[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Edm    1947    only    -    Sep    lastSun    2:00    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Edm    1947    only    -    Sep    lastSun    2:00    0    S
  {
    1947 /*fromYear*/,
    1947 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Edm    1972    1986    -    Apr    lastSun    2:00    1:00    D
  {
    1972 /*fromYear*/,
    1986 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Edm    1972    2006    -    Oct    lastSun    2:00    0    S
  {
    1972 /*fromYear*/,
    2006 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyEdm ACE_TIME_PROGMEM = {
  kZoneRulesEdm /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Morocco
// Rules: 170
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesMorocco[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Morocco    1978    only    -    Aug     4     0:00    0    -
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    1978    only    -    Aug     4     0:00    0    -
  {
    1978 /*fromYear*/,
    1978 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2008    only    -    Jun     1     0:00    1:00    -
  {
    2008 /*fromYear*/,
    2008 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2008    only    -    Sep     1     0:00    0    -
  {
    2008 /*fromYear*/,
    2008 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2009    only    -    Jun     1     0:00    1:00    -
  {
    2009 /*fromYear*/,
    2009 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2009    only    -    Aug    21     0:00    0    -
  {
    2009 /*fromYear*/,
    2009 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2010    only    -    May     2     0:00    1:00    -
  {
    2010 /*fromYear*/,
    2010 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2010    only    -    Aug     8     0:00    0    -
  {
    2010 /*fromYear*/,
    2010 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2011    only    -    Apr     3     0:00    1:00    -
  {
    2011 /*fromYear*/,
    2011 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2011    only    -    Jul    31     0:00    0    -
  {
    2011 /*fromYear*/,
    2011 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    2013    -    Apr    lastSun     2:00    1:00    -
  {
    2012 /*fromYear*/,
    2013 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Jul    20     3:00    0    -
  {
    2012 /*fromYear*/,
    2012 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Aug    20     2:00    1:00    -
  {
    2012 /*fromYear*/,
    2012 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Sep    30     3:00    0    -
  {
    2012 /*fromYear*/,
    2012 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    only    -    Jul     7     3:00    0    -
  {
    2013 /*fromYear*/,
    2013 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    only    -    Aug    10     2:00    1:00    -
  {
    2013 /*fromYear*/,
    2013 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    2018    -    Oct    lastSun     3:00    0    -
  {
    2013 /*fromYear*/,
    2018 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    2018    -    Mar    lastSun     2:00    1:00    -
  {
    2014 /*fromYear*/,
    2018 /*toYear*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    only    -    Jun    28     3:00    0    -
  {
    2014 /*fromYear*/,
    2014 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    only    -    Aug     2     2:00    1:00    -
  {
    2014 /*fromYear*/,
    2014 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2015    only    -    Jun    14     3:00    0    -
  {
    2015 /*fromYear*/,
    2015 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2015    only    -    Jul    19     2:00    1:00    -
  {
    2015 /*fromYear*/,
    2015 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2016    only    -    Jun     5     3:00    0    -
  {
    2016 /*fromYear*/,
    2016 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2016    only    -    Jul    10     2:00    1:00    -
  {
    2016 /*fromYear*/,
    2016 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2017    only    -    May    21     3:00    0    -
  {
    2017 /*fromYear*/,
    2017 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2017    only    -    Jul     2     2:00    1:00    -
  {
    2017 /*fromYear*/,
    2017 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2018    only    -    May    13     3:00    0    -
  {
    2018 /*fromYear*/,
    2018 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2018    only    -    Jun    17     2:00    1:00    -
  {
    2018 /*fromYear*/,
    2018 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2019    only    -    May     5     3:00    -1:00    -
  {
    2019 /*fromYear*/,
    2019 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2019    only    -    Jun     9     2:00    0    -
  {
    2019 /*fromYear*/,
    2019 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2020    only    -    Apr    19     3:00    -1:00    -
  {
    2020 /*fromYear*/,
    2020 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2020    only    -    May    31     2:00    0    -
  {
    2020 /*fromYear*/,
    2020 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2021    only    -    Apr    11     3:00    -1:00    -
  {
    2021 /*fromYear*/,
    2021 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2021    only    -    May    16     2:00    0    -
  {
    2021 /*fromYear*/,
    2021 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2022    only    -    Mar    27     3:00    -1:00    -
  {
    2022 /*fromYear*/,
    2022 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2022    only    -    May     8     2:00    0    -
  {
    2022 /*fromYear*/,
    2022 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2023    only    -    Mar    19     3:00    -1:00    -
  {
    2023 /*fromYear*/,
    2023 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2023    only    -    Apr    23     2:00    0    -
  {
    2023 /*fromYear*/,
    2023 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2024    only    -    Mar    10     3:00    -1:00    -
  {
    2024 /*fromYear*/,
    2024 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2024    only    -    Apr    14     2:00    0    -
  {
    2024 /*fromYear*/,
    2024 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2025    only    -    Feb    23     3:00    -1:00    -
  {
    2025 /*fromYear*/,
    2025 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2025    only    -    Apr     6     2:00    0    -
  {
    2025 /*fromYear*/,
    2025 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2026    only    -    Feb    15     3:00    -1:00    -
  {
    2026 /*fromYear*/,
    2026 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2026    only    -    Mar    22     2:00    0    -
  {
    2026 /*fromYear*/,
    2026 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2027    only    -    Feb     7     3:00    -1:00    -
  {
    2027 /*fromYear*/,
    2027 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2027    only    -    Mar    14     2:00    0    -
  {
    2027 /*fromYear*/,
    2027 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2028    only    -    Jan    23     3:00    -1:00    -
  {
    2028 /*fromYear*/,
    2028 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2028    only    -    Mar     5     2:00    0    -
  {
    2028 /*fromYear*/,
    2028 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Jan    14     3:00    -1:00    -
  {
    2029 /*fromYear*/,
    2029 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Feb    18     2:00    0    -
  {
    2029 /*fromYear*/,
    2029 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Dec    30     3:00    -1:00    -
  {
    2029 /*fromYear*/,
    2029 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2030    only    -    Feb    10     2:00    0    -
  {
    2030 /*fromYear*/,
    2030 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2030    only    -    Dec    22     3:00    -1:00    -
  {
    2030 /*fromYear*/,
    2030 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2031    only    -    Jan    26     2:00    0    -
  {
    2031 /*fromYear*/,
    2031 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2031    only    -    Dec    14     3:00    -1:00    -
  {
    2031 /*fromYear*/,
    2031 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2032    only    -    Jan    18     2:00    0    -
  {
    2032 /*fromYear*/,
    2032 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2032    only    -    Nov    28     3:00    -1:00    -
  {
    2032 /*fromYear*/,
    2032 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Jan     9     2:00    0    -
  {
    2033 /*fromYear*/,
    2033 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Nov    20     3:00    -1:00    -
  {
    2033 /*fromYear*/,
    2033 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Dec    25     2:00    0    -
  {
    2033 /*fromYear*/,
    2033 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2034    only    -    Nov     5     3:00    -1:00    -
  {
    2034 /*fromYear*/,
    2034 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2034    only    -    Dec    17     2:00    0    -
  {
    2034 /*fromYear*/,
    2034 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2035    only    -    Oct    28     3:00    -1:00    -
  {
    2035 /*fromYear*/,
    2035 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2035    only    -    Dec     9     2:00    0    -
  {
    2035 /*fromYear*/,
    2035 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2036    only    -    Oct    19     3:00    -1:00    -
  {
    2036 /*fromYear*/,
    2036 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2036    only    -    Nov    23     2:00    0    -
  {
    2036 /*fromYear*/,
    2036 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2037    only    -    Oct     4     3:00    -1:00    -
  {
    2037 /*fromYear*/,
    2037 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2037    only    -    Nov    15     2:00    0    -
  {
    2037 /*fromYear*/,
    2037 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2038    only    -    Sep    26     3:00    -1:00    -
  {
    2038 /*fromYear*/,
    2038 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2038    only    -    Oct    31     2:00    0    -
  {
    2038 /*fromYear*/,
    2038 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2039    only    -    Sep    18     3:00    -1:00    -
  {
    2039 /*fromYear*/,
    2039 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2039    only    -    Oct    23     2:00    0    -
  {
    2039 /*fromYear*/,
    2039 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2040    only    -    Sep     2     3:00    -1:00    -
  {
    2040 /*fromYear*/,
    2040 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2040    only    -    Oct    14     2:00    0    -
  {
    2040 /*fromYear*/,
    2040 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2041    only    -    Aug    25     3:00    -1:00    -
  {
    2041 /*fromYear*/,
    2041 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2041    only    -    Sep    29     2:00    0    -
  {
    2041 /*fromYear*/,
    2041 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    29 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2042    only    -    Aug    10     3:00    -1:00    -
  {
    2042 /*fromYear*/,
    2042 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2042    only    -    Sep    21     2:00    0    -
  {
    2042 /*fromYear*/,
    2042 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2043    only    -    Aug     2     3:00    -1:00    -
  {
    2043 /*fromYear*/,
    2043 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2043    only    -    Sep    13     2:00    0    -
  {
    2043 /*fromYear*/,
    2043 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2044    only    -    Jul    24     3:00    -1:00    -
  {
    2044 /*fromYear*/,
    2044 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2044    only    -    Aug    28     2:00    0    -
  {
    2044 /*fromYear*/,
    2044 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2045    only    -    Jul     9     3:00    -1:00    -
  {
    2045 /*fromYear*/,
    2045 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2045    only    -    Aug    20     2:00    0    -
  {
    2045 /*fromYear*/,
    2045 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2046    only    -    Jul     1     3:00    -1:00    -
  {
    2046 /*fromYear*/,
    2046 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2046    only    -    Aug     5     2:00    0    -
  {
    2046 /*fromYear*/,
    2046 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2047    only    -    Jun    23     3:00    -1:00    -
  {
    2047 /*fromYear*/,
    2047 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2047    only    -    Jul    28     2:00    0    -
  {
    2047 /*fromYear*/,
    2047 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2048    only    -    Jun     7     3:00    -1:00    -
  {
    2048 /*fromYear*/,
    2048 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2048    only    -    Jul    19     2:00    0    -
  {
    2048 /*fromYear*/,
    2048 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2049    only    -    May    30     3:00    -1:00    -
  {
    2049 /*fromYear*/,
    2049 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2049    only    -    Jul     4     2:00    0    -
  {
    2049 /*fromYear*/,
    2049 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2050    only    -    May    15     3:00    -1:00    -
  {
    2050 /*fromYear*/,
    2050 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2050    only    -    Jun    26     2:00    0    -
  {
    2050 /*fromYear*/,
    2050 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2051    only    -    May     7     3:00    -1:00    -
  {
    2051 /*fromYear*/,
    2051 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2051    only    -    Jun    18     2:00    0    -
  {
    2051 /*fromYear*/,
    2051 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2052    only    -    Apr    28     3:00    -1:00    -
  {
    2052 /*fromYear*/,
    2052 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2052    only    -    Jun     2     2:00    0    -
  {
    2052 /*fromYear*/,
    2052 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2053    only    -    Apr    13     3:00    -1:00    -
  {
    2053 /*fromYear*/,
    2053 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2053    only    -    May    25     2:00    0    -
  {
    2053 /*fromYear*/,
    2053 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2054    only    -    Apr     5     3:00    -1:00    -
  {
    2054 /*fromYear*/,
    2054 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2054    only    -    May    10     2:00    0    -
  {
    2054 /*fromYear*/,
    2054 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2055    only    -    Mar    28     3:00    -1:00    -
  {
    2055 /*fromYear*/,
    2055 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2055    only    -    May     2     2:00    0    -
  {
    2055 /*fromYear*/,
    2055 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2056    only    -    Mar    12     3:00    -1:00    -
  {
    2056 /*fromYear*/,
    2056 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2056    only    -    Apr    23     2:00    0    -
  {
    2056 /*fromYear*/,
    2056 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2057    only    -    Mar     4     3:00    -1:00    -
  {
    2057 /*fromYear*/,
    2057 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2057    only    -    Apr     8     2:00    0    -
  {
    2057 /*fromYear*/,
    2057 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2058    only    -    Feb    17     3:00    -1:00    -
  {
    2058 /*fromYear*/,
    2058 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2058    only    -    Mar    31     2:00    0    -
  {
    2058 /*fromYear*/,
    2058 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2059    only    -    Feb     9     3:00    -1:00    -
  {
    2059 /*fromYear*/,
    2059 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2059    only    -    Mar    23     2:00    0    -
  {
    2059 /*fromYear*/,
    2059 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2060    only    -    Feb     1     3:00    -1:00    -
  {
    2060 /*fromYear*/,
    2060 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2060    only    -    Mar     7     2:00    0    -
  {
    2060 /*fromYear*/,
    2060 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2061    only    -    Jan    16     3:00    -1:00    -
  {
    2061 /*fromYear*/,
    2061 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2061    only    -    Feb    27     2:00    0    -
  {
    2061 /*fromYear*/,
    2061 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Jan     8     3:00    -1:00    -
  {
    2062 /*fromYear*/,
    2062 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Feb    12     2:00    0    -
  {
    2062 /*fromYear*/,
    2062 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Dec    31     3:00    -1:00    -
  {
    2062 /*fromYear*/,
    2062 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2063    only    -    Feb     4     2:00    0    -
  {
    2063 /*fromYear*/,
    2063 /*toYear*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2063    only    -    Dec    16     3:00    -1:00    -
  {
    2063 /*fromYear*/,
    2063 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2064    only    -    Jan    27     2:00    0    -
  {
    2064 /*fromYear*/,
    2064 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2064    only    -    Dec     7     3:00    -1:00    -
  {
    2064 /*fromYear*/,
    2064 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2065    only    -    Jan    11     2:00    0    -
  {
    2065 /*fromYear*/,
    2065 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2065    only    -    Nov    22     3:00    -1:00    -
  {
    2065 /*fromYear*/,
    2065 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Jan     3     2:00    0    -
  {
    2066 /*fromYear*/,
    2066 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Nov    14     3:00    -1:00    -
  {
    2066 /*fromYear*/,
    2066 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Dec    26     2:00    0    -
  {
    2066 /*fromYear*/,
    2066 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2067    only    -    Nov     6     3:00    -1:00    -
  {
    2067 /*fromYear*/,
    2067 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2067    only    -    Dec    11     2:00    0    -
  {
    2067 /*fromYear*/,
    2067 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2068    only    -    Oct    21     3:00    -1:00    -
  {
    2068 /*fromYear*/,
    2068 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2068    only    -    Dec     2     2:00    0    -
  {
    2068 /*fromYear*/,
    2068 /*toYear*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2069    only    -    Oct    13     3:00    -1:00    -
  {
    2069 /*fromYear*/,
    2069 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2069    only    -    Nov    17     2:00    0    -
  {
    2069 /*fromYear*/,
    2069 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2070    only    -    Oct     5     3:00    -1:00    -
  {
    2070 /*fromYear*/,
    2070 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2070    only    -    Nov     9     2:00    0    -
  {
    2070 /*fromYear*/,
    2070 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2071    only    -    Sep    20     3:00    -1:00    -
  {
    2071 /*fromYear*/,
    2071 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2071    only    -    Nov     1     2:00    0    -
  {
    2071 /*fromYear*/,
    2071 /*toYear*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2072    only    -    Sep    11     3:00    -1:00    -
  {
    2072 /*fromYear*/,
    2072 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2072    only    -    Oct    16     2:00    0    -
  {
    2072 /*fromYear*/,
    2072 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2073    only    -    Aug    27     3:00    -1:00    -
  {
    2073 /*fromYear*/,
    2073 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2073    only    -    Oct     8     2:00    0    -
  {
    2073 /*fromYear*/,
    2073 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2074    only    -    Aug    19     3:00    -1:00    -
  {
    2074 /*fromYear*/,
    2074 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2074    only    -    Sep    30     2:00    0    -
  {
    2074 /*fromYear*/,
    2074 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2075    only    -    Aug    11     3:00    -1:00    -
  {
    2075 /*fromYear*/,
    2075 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2075    only    -    Sep    15     2:00    0    -
  {
    2075 /*fromYear*/,
    2075 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2076    only    -    Jul    26     3:00    -1:00    -
  {
    2076 /*fromYear*/,
    2076 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2076    only    -    Sep     6     2:00    0    -
  {
    2076 /*fromYear*/,
    2076 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2077    only    -    Jul    18     3:00    -1:00    -
  {
    2077 /*fromYear*/,
    2077 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2077    only    -    Aug    22     2:00    0    -
  {
    2077 /*fromYear*/,
    2077 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2078    only    -    Jul    10     3:00    -1:00    -
  {
    2078 /*fromYear*/,
    2078 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2078    only    -    Aug    14     2:00    0    -
  {
    2078 /*fromYear*/,
    2078 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2079    only    -    Jun    25     3:00    -1:00    -
  {
    2079 /*fromYear*/,
    2079 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2079    only    -    Aug     6     2:00    0    -
  {
    2079 /*fromYear*/,
    2079 /*toYear*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2080    only    -    Jun    16     3:00    -1:00    -
  {
    2080 /*fromYear*/,
    2080 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2080    only    -    Jul    21     2:00    0    -
  {
    2080 /*fromYear*/,
    2080 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2081    only    -    Jun     1     3:00    -1:00    -
  {
    2081 /*fromYear*/,
    2081 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2081    only    -    Jul    13     2:00    0    -
  {
    2081 /*fromYear*/,
    2081 /*toYear*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2082    only    -    May    24     3:00    -1:00    -
  {
    2082 /*fromYear*/,
    2082 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2082    only    -    Jun    28     2:00    0    -
  {
    2082 /*fromYear*/,
    2082 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2083    only    -    May    16     3:00    -1:00    -
  {
    2083 /*fromYear*/,
    2083 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2083    only    -    Jun    20     2:00    0    -
  {
    2083 /*fromYear*/,
    2083 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2084    only    -    Apr    30     3:00    -1:00    -
  {
    2084 /*fromYear*/,
    2084 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2084    only    -    Jun    11     2:00    0    -
  {
    2084 /*fromYear*/,
    2084 /*toYear*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2085    only    -    Apr    22     3:00    -1:00    -
  {
    2085 /*fromYear*/,
    2085 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2085    only    -    May    27     2:00    0    -
  {
    2085 /*fromYear*/,
    2085 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2086    only    -    Apr    14     3:00    -1:00    -
  {
    2086 /*fromYear*/,
    2086 /*toYear*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2086    only    -    May    19     2:00    0    -
  {
    2086 /*fromYear*/,
    2086 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2087    only    -    Mar    30     3:00    -1:00    -
  {
    2087 /*fromYear*/,
    2087 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    -60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2087    only    -    May    11     2:00    0    -
  {
    2087 /*fromYear*/,
    2087 /*toYear*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyMorocco ACE_TIME_PROGMEM = {
  kZoneRulesMorocco /*rules*/,
  170 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Namibia
// Rules: 4
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesNamibia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1994    only    -    Mar    21    0:00    -1:00    WAT
  {
    1994 /*fromYear*/,
    1994 /*toYear*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    -60 /*deltaMinutes*/,
    4 /*letterIndex ("WAT")*/,
  },
  // Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    1994 /*fromYear*/,
    2017 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1995    2017    -    Apr    Sun>=1    2:00    -1:00    WAT
  {
    1995 /*fromYear*/,
    2017 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    -60 /*deltaMinutes*/,
    4 /*letterIndex ("WAT")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyNamibia ACE_TIME_PROGMEM = {
  kZoneRulesNamibia /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Port
// Rules: 6
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesPort[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Port    1978    only    -    Oct     1     1:00s    0    -
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1978    1980    -    Apr    Sun>=1     1:00s    1:00    S
  {
    1978 /*fromYear*/,
    1980 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    60 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Port    1978    only    -    Oct     1     1:00s    0    -
  {
    1978 /*fromYear*/,
    1978 /*toYear*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1979    1980    -    Sep    lastSun     1:00s    0    -
  {
    1979 /*fromYear*/,
    1980 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    240 /*atTimeCode (3600/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1981    1986    -    Mar    lastSun     0:00s    1:00    S
  {
    1981 /*fromYear*/,
    1986 /*toYear*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Port    1981    1985    -    Sep    lastSun     0:00s    0    -
  {
    1981 /*fromYear*/,
    1985 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyPort ACE_TIME_PROGMEM = {
  kZoneRulesPort /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: US
// Rules: 7
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesUS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    1967 /*fromYear*/,
    2006 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    US    1975    only    -    Feb    lastSun    2:00    1:00    D
  {
    1975 /*fromYear*/,
    1975 /*toYear*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    1976    1986    -    Apr    lastSun    2:00    1:00    D
  {
    1976 /*fromYear*/,
    1986 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    1987 /*fromYear*/,
    2006 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    2007 /*fromYear*/,
    32766 /*toYear*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    2007 /*fromYear*/,
    32766 /*toYear*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyUS ACE_TIME_PROGMEM = {
  kZoneRulesUS /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Vanc
// Rules: 4
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesVanc[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Vanc    1947    1961    -    Sep    lastSun    2:00    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Vanc    1946    1986    -    Apr    lastSun    2:00    1:00    D
  {
    1946 /*fromYear*/,
    1986 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Vanc    1947    1961    -    Sep    lastSun    2:00    0    S
  {
    1947 /*fromYear*/,
    1961 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Vanc    1962    2006    -    Oct    lastSun    2:00    0    S
  {
    1962 /*fromYear*/,
    2006 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyVanc ACE_TIME_PROGMEM = {
  kZoneRulesVanc /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: WS
// Rules: 6
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesWS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    WS    2011    only    -    Apr    Sat>=1    4:00    0    -
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2010    only    -    Sep    lastSun    0:00    1    -
  {
    2010 /*fromYear*/,
    2010 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2011    only    -    Apr    Sat>=1    4:00    0    -
  {
    2011 /*fromYear*/,
    2011 /*toYear*/,
    4 /*inMonth*/,
    6 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    960 /*atTimeCode (14400/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2011    only    -    Sep    lastSat    3:00    1    -
  {
    2011 /*fromYear*/,
    2011 /*toYear*/,
    9 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2012    2021    -    Apr    Sun>=1    4:00    0    -
  {
    2012 /*fromYear*/,
    2021 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    960 /*atTimeCode (14400/15)*/,
    0 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2012    2020    -    Sep    lastSun    3:00    1    -
  {
    2012 /*fromYear*/,
    2020 /*toYear*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    720 /*atTimeCode (10800/15)*/,
    60 /*deltaMinutes*/,
    0 /*letterIndex ("")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyWS ACE_TIME_PROGMEM = {
  kZoneRulesWS /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Winn
// Rules: 5
//---------------------------------------------------------------------------

static const complete::Info::ZoneRule kZoneRulesWinn[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Winn    1963    only    -    Sep    22    2:00    0    S
  {
    -32767 /*fromYear*/,
    -32767 /*toYear*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    0 /*atTimeCode (0/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1963    only    -    Sep    22    2:00    0    S
  {
    1963 /*fromYear*/,
    1963 /*toYear*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeModifier (kAtcSuffixW + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1966    1986    -    Apr    lastSun    2:00s    1:00    D
  {
    1966 /*fromYear*/,
    1986 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Winn    1966    2005    -    Oct    lastSun    2:00s    0    S
  {
    1966 /*fromYear*/,
    2005 /*toYear*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    0 /*deltaMinutes*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1987    2005    -    Apr    Sun>=1    2:00s    1:00    D
  {
    1987 /*fromYear*/,
    2005 /*toYear*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    16 /*atTimeModifier (kAtcSuffixS + seconds=0)*/,
    480 /*atTimeCode (7200/15)*/,
    60 /*deltaMinutes*/,
    2 /*letterIndex ("D")*/,
  },

};

const complete::Info::ZonePolicy kZonePolicyWinn ACE_TIME_PROGMEM = {
  kZoneRulesWinn /*rules*/,
  5 /*numRules*/,
};



}
}
