#!/usr/bin/gawk -f
#
# Usage: generate_table.awk < ${board}.txt
#
# Takes the *.txt file generated by AutoBenchmark.ino and generates an ASCII
# table that can be inserted into the README.md. Collects both sizeof()
# information as well as CPU benchmarks.

BEGIN {
  # Set to 1 when 'SIZEOF' is detected
  collect_sizeof = 0

  # Set to 1 when 'BENCHMARKS' is detected
  collect_benchmarks = 0
}

/^SIZEOF/ {
  collect_sizeof = 1
  collect_benchmarks = 0
  sizeof_index = 0
  next
}

/^BENCHMARKS/ {
  collect_sizeof = 0
  collect_benchmarks = 1
  benchmark_index = 0
  next
}

!/^END/ {
  if (collect_sizeof) {
    s[sizeof_index] = $0
    sizeof_index++
  }
  if (collect_benchmarks) {
    u[benchmark_index]["name"] = $1
    u[benchmark_index]["micros"] = $2
    benchmark_index++
  }
}

END {
  TOTAL_BENCHMARKS = benchmark_index
  TOTAL_SIZEOF = sizeof_index

  printf("Sizes of Objects:\n")
  for (i = 0; i < TOTAL_SIZEOF; i++) {
    print s[i]
  }


  print ""
  print "CPU:"

  printf("+--------------------------------------------------+----------+\n")
  printf("| Method                                           |   micros |\n")

  for (i = 0; i < TOTAL_BENCHMARKS - 1; i++) {
    name = u[i]["name"]
    if (name ~ /^EmptyLoop/ \
        || name ~ /^PlainDate::forEpochDays\(\)/ \
        || name ~ /^OffsetDateTime::forEpochSeconds\(\)/ \
        || name ~ /^ZonedDateTime::toEpochSeconds\(\)/ \
        || name ~ /^ZonedDateTime::forEpochSeconds\(Basic_nocache\)/ \
        || name ~ /^ZonedDateTime::forComponents\(Basic_nocache\)/ \
        || name ~ /^ZonedExtra::forEpochSeconds\(Basic_nocache\)/ \
        || name ~ /^ZonedExtra::forComponents\(Basic_nocache\)/ \
        || name ~ /^BasicZoneRegistrar::findIndexForName\(binary\)/ \
        || name ~ /^ExtendedZoneRegistrar::findIndexForName\(binary\)/ \
        || name ~ /^CompleteZoneRegistrar::findIndexForName\(binary\)/ \
      ) {
      printf(\
        "|--------------------------------------------------+----------|\n")
    }
    printf("| %-48s | %8.3f |\n", name, u[i]["micros"])
  }
  printf("+--------------------------------------------------+----------+\n")
  printf("%s: %d\n", u[i]["name"], u[i]["micros"])
}
