// This file was generated by the following script:
//
//   $ /home/brian/src/AceTimeSuite/compiler/src/acetimecompiler/tzcompiler.py
//     --input_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/zonedb/tzfiles
//     --output_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/zonedb
//     --tz_version 2025b
//     --action zonedb
//     --language arduino
//     --scope basic
//     --db_namespace zonedb
//     --zi_namespace basic::Info
//     --start_year 2000
//     --until_year 2200
//
// using the TZ Database files
//
//   africa
//   antarctica
//   asia
//   australasia
//   backward
//   etcetera
//   europe
//   northamerica
//   southamerica
//
// from https://github.com/eggert/tz/releases/tag/2025b
//
// Supported Zones: 446 (215 zones, 231 links)
// Unsupported Zones: 151 (125 zones, 26 links)
//
// Requested Years: [2000,2200]
// Accurate Years: [2000,32767]
//
// Original Years:  [1844,2087]
// Generated Years: [1950,2023]
// Lower/Upper Truncated: [True,False]
//
// Estimator Years: [1950,2025]
// Max Buffer Size: 6
//
// Records:
//   Infos: 446
//   Eras: 227
//   Policies: 63
//   Rules: 352
//
// Memory (8-bits):
//   Context: 16
//   Rules: 3168
//   Policies: 189
//   Eras: 2497
//   Zones: 2795
//   Links: 3003
//   Registry: 892
//   Formats: 175
//   Letters: 29
//   Fragments: 116
//   Names: 4142 (original: 6494)
//   TOTAL: 17022
//
// Memory (32-bits):
//   Context: 24
//   Rules: 4224
//   Policies: 504
//   Eras: 3632
//   Zones: 5160
//   Links: 5544
//   Registry: 1784
//   Formats: 175
//   Letters: 41
//   Fragments: 138
//   Names: 4142 (original: 6494)
//   TOTAL: 25368
//
// DO NOT EDIT

#include <zoneinfo/compat.h>
#include "zone_policies.h"

namespace ace_time {
namespace zonedb {

//---------------------------------------------------------------------------
// Policies: 63
// Rules: 352
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Policy name: AN
// Rules: 10
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAN[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AN    1990    1995    -    Mar    Sun>=1    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    1987    1999    -    Oct    lastSun    2:00s    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AN    1990    1995    -    Mar    Sun>=1    2:00s    0    S
  {
    -110 /*fromYearTiny (1990)*/,
    -105 /*toYearTiny (1995)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    1996    2005    -    Mar    lastSun    2:00s    0    S
  {
    -104 /*fromYearTiny (1996)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    2000    only    -    Aug    lastSun    2:00s    1:00    D
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AN    2001    2007    -    Oct    lastSun    2:00s    1:00    D
  {
    -99 /*fromYearTiny (2001)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AN    2006    only    -    Apr    Sun>=1    2:00s    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    2007    only    -    Mar    lastSun    2:00s    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    2008    max    -    Apr    Sun>=1    2:00s    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AN    2008    max    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAN ACE_TIME_PROGMEM = {
  kZoneRulesAN /*rules*/,
  10 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: AQ
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAQ[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AQ    1990    1992    -    Mar    Sun>=1    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAQ ACE_TIME_PROGMEM = {
  kZoneRulesAQ /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: AS
// Rules: 8
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AS    1994    only    -    Mar    20    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    1987    2007    -    Oct    lastSun    2:00s    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AS    1994    only    -    Mar    20    2:00s    0    S
  {
    -106 /*fromYearTiny (1994)*/,
    -106 /*toYearTiny (1994)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    1995    2005    -    Mar    lastSun    2:00s    0    S
  {
    -105 /*fromYearTiny (1995)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    2006    only    -    Apr    2    2:00s    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    2007    only    -    Mar    lastSun    2:00s    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    2008    max    -    Apr    Sun>=1    2:00s    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AS    2008    max    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAS ACE_TIME_PROGMEM = {
  kZoneRulesAS /*rules*/,
  8 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: AT
// Rules: 9
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAT[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AT    1991    2005    -    Mar    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AT    1988    1990    -    Oct    lastSun    2:00s    1:00    D
  {
    -112 /*fromYearTiny (1988)*/,
    -110 /*toYearTiny (1990)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AT    1991    1999    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -109 /*fromYearTiny (1991)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AT    1991    2005    -    Mar    lastSun    2:00s    0    S
  {
    -109 /*fromYearTiny (1991)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AT    2000    only    -    Aug    lastSun    2:00s    1:00    D
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AT    2001    max    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -99 /*fromYearTiny (2001)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AT    2006    only    -    Apr    Sun>=1    2:00s    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AT    2007    only    -    Mar    lastSun    2:00s    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AT    2008    max    -    Apr    Sun>=1    2:00s    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAT ACE_TIME_PROGMEM = {
  kZoneRulesAT /*rules*/,
  9 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: AV
// Rules: 10
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAV[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AV    1991    1994    -    Mar    Sun>=1    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    1988    1999    -    Oct    lastSun    2:00s    1:00    D
  {
    -112 /*fromYearTiny (1988)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AV    1991    1994    -    Mar    Sun>=1    2:00s    0    S
  {
    -109 /*fromYearTiny (1991)*/,
    -106 /*toYearTiny (1994)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    1995    2005    -    Mar    lastSun    2:00s    0    S
  {
    -105 /*fromYearTiny (1995)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    2000    only    -    Aug    lastSun    2:00s    1:00    D
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AV    2001    2007    -    Oct    lastSun    2:00s    1:00    D
  {
    -99 /*fromYearTiny (2001)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AV    2006    only    -    Apr    Sun>=1    2:00s    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    2007    only    -    Mar    lastSun    2:00s    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    2008    max    -    Apr    Sun>=1    2:00s    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AV    2008    max    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAV ACE_TIME_PROGMEM = {
  kZoneRulesAV /*rules*/,
  10 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: AW
// Rules: 5
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAW[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    AW    1992    only    -    Mar    Sun>=1    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AW    1992    only    -    Mar    Sun>=1    2:00s    0    S
  {
    -108 /*fromYearTiny (1992)*/,
    -108 /*toYearTiny (1992)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AW    2006    only    -    Dec     3    2:00s    1:00    D
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    AW    2007    2009    -    Mar    lastSun    2:00s    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -91 /*toYearTiny (2009)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    AW    2007    2008    -    Oct    lastSun    2:00s    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    -92 /*toYearTiny (2008)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAW ACE_TIME_PROGMEM = {
  kZoneRulesAW /*rules*/,
  5 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Armenia
// Rules: 3
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesArmenia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule Armenia    2011    only    -    Oct    lastSun     2:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Armenia    2011    only    -    Mar    lastSun     2:00s    1:00    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Armenia    2011    only    -    Oct    lastSun     2:00s    0    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyArmenia ACE_TIME_PROGMEM = {
  kZoneRulesArmenia /*rules*/,
  3 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Aus
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAus[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Aus    1943    1944    -    Mar    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAus ACE_TIME_PROGMEM = {
  kZoneRulesAus /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Azer
// Rules: 3
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesAzer[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Azer    1997    2015    -    Oct    lastSun     5:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Azer    1997    2015    -    Mar    lastSun     4:00    1:00    -
  {
    -103 /*fromYearTiny (1997)*/,
    -85 /*toYearTiny (2015)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Azer    1997    2015    -    Oct    lastSun     5:00    0    -
  {
    -103 /*fromYearTiny (1997)*/,
    -85 /*toYearTiny (2015)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    20 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyAzer ACE_TIME_PROGMEM = {
  kZoneRulesAzer /*rules*/,
  3 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Barb
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesBarb[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Barb    1980    only    -    Sep    25    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyBarb ACE_TIME_PROGMEM = {
  kZoneRulesBarb /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Belize
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesBelize[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Belize    1983    only    -    Feb    12    0:00    0    CST
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    2 /*letterIndex ("CST")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyBelize ACE_TIME_PROGMEM = {
  kZoneRulesBelize /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Brazil
// Rules: 21
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesBrazil[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Brazil    1999    only    -    Feb    21     0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    1998    only    -    Oct    11     0:00    1:00    -
  {
    -102 /*fromYearTiny (1998)*/,
    -102 /*toYearTiny (1998)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    1999    only    -    Feb    21     0:00    0    -
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    1999    only    -    Oct     3     0:00    1:00    -
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2000    only    -    Feb    27     0:00    0    -
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2000    2001    -    Oct    Sun>=8     0:00    1:00    -
  {
    -100 /*fromYearTiny (2000)*/,
    -99 /*toYearTiny (2001)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2001    2006    -    Feb    Sun>=15     0:00    0    -
  {
    -99 /*fromYearTiny (2001)*/,
    -94 /*toYearTiny (2006)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2002    only    -    Nov     3     0:00    1:00    -
  {
    -98 /*fromYearTiny (2002)*/,
    -98 /*toYearTiny (2002)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2003    only    -    Oct    19     0:00    1:00    -
  {
    -97 /*fromYearTiny (2003)*/,
    -97 /*toYearTiny (2003)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2004    only    -    Nov     2     0:00    1:00    -
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2005    only    -    Oct    16     0:00    1:00    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2006    only    -    Nov     5     0:00    1:00    -
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2007    only    -    Feb    25     0:00    0    -
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2007    only    -    Oct    Sun>=8     0:00    1:00    -
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2008    2017    -    Oct    Sun>=15    0:00    1:00    -
  {
    -92 /*fromYearTiny (2008)*/,
    -83 /*toYearTiny (2017)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2008    2011    -    Feb    Sun>=15    0:00    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    -89 /*toYearTiny (2011)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2012    only    -    Feb    Sun>=22    0:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2013    2014    -    Feb    Sun>=15    0:00    0    -
  {
    -87 /*fromYearTiny (2013)*/,
    -86 /*toYearTiny (2014)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2015    only    -    Feb    Sun>=22    0:00    0    -
  {
    -85 /*fromYearTiny (2015)*/,
    -85 /*toYearTiny (2015)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2016    2019    -    Feb    Sun>=15    0:00    0    -
  {
    -84 /*fromYearTiny (2016)*/,
    -81 /*toYearTiny (2019)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Brazil    2018    only    -    Nov    Sun>=1    0:00    1:00    -
  {
    -82 /*fromYearTiny (2018)*/,
    -82 /*toYearTiny (2018)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyBrazil ACE_TIME_PROGMEM = {
  kZoneRulesBrazil /*rules*/,
  21 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: CO
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesCO[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    CO    1993    only    -    Feb     6    24:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyCO ACE_TIME_PROGMEM = {
  kZoneRulesCO /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: CR
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesCR[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    CR    1992    only    -    Mar    15    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyCR ACE_TIME_PROGMEM = {
  kZoneRulesCR /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Canada
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesCanada[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Canada    1974    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1974    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -126 /*fromYearTiny (1974)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Canada    1974    2006    -    Oct    lastSun    2:00    0    S
  {
    -126 /*fromYearTiny (1974)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyCanada ACE_TIME_PROGMEM = {
  kZoneRulesCanada /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Chatham
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesChatham[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Chatham    1990    2007    -    Mar    Sun>=15    2:45s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chatham    1989    only    -    Oct    Sun>=8    2:45s    1:00    -
  {
    -111 /*fromYearTiny (1989)*/,
    -111 /*toYearTiny (1989)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    11 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chatham    1990    2006    -    Oct    Sun>=1    2:45s    1:00    -
  {
    -110 /*fromYearTiny (1990)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    11 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chatham    1990    2007    -    Mar    Sun>=15    2:45s    0    -
  {
    -110 /*fromYearTiny (1990)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    11 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chatham    2007    max    -    Sep    lastSun    2:45s    1:00    -
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    11 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chatham    2008    max    -    Apr    Sun>=1    2:45s    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    11 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyChatham ACE_TIME_PROGMEM = {
  kZoneRulesChatham /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Chile
// Rules: 18
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesChile[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Chile    1999    only    -    Apr     4    3:00u    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    1998    only    -    Sep    27    4:00u    1:00    -
  {
    -102 /*fromYearTiny (1998)*/,
    -102 /*toYearTiny (1998)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    1999    only    -    Apr     4    3:00u    0    -
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    1999    2010    -    Oct    Sun>=9    4:00u    1:00    -
  {
    -101 /*fromYearTiny (1999)*/,
    -90 /*toYearTiny (2010)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2000    2007    -    Mar    Sun>=9    3:00u    0    -
  {
    -100 /*fromYearTiny (2000)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2008    only    -    Mar    30    3:00u    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2009    only    -    Mar    Sun>=9    3:00u    0    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2010    only    -    Apr    Sun>=1    3:00u    0    -
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2011    only    -    May    Sun>=2    3:00u    0    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    5 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2011    only    -    Aug    Sun>=16    4:00u    1:00    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2012    2014    -    Apr    Sun>=23    3:00u    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -86 /*toYearTiny (2014)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2012    2014    -    Sep    Sun>=2    4:00u    1:00    -
  {
    -88 /*fromYearTiny (2012)*/,
    -86 /*toYearTiny (2014)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2016    2018    -    May    Sun>=9    3:00u    0    -
  {
    -84 /*fromYearTiny (2016)*/,
    -82 /*toYearTiny (2018)*/,
    5 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2016    2018    -    Aug    Sun>=9    4:00u    1:00    -
  {
    -84 /*fromYearTiny (2016)*/,
    -82 /*toYearTiny (2018)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2019    max    -    Apr    Sun>=2    3:00u    0    -
  {
    -81 /*fromYearTiny (2019)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2019    2021    -    Sep    Sun>=2    4:00u    1:00    -
  {
    -81 /*fromYearTiny (2019)*/,
    -79 /*toYearTiny (2021)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2022    only    -    Sep    Sun>=9    4:00u    1:00    -
  {
    -78 /*fromYearTiny (2022)*/,
    -78 /*toYearTiny (2022)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Chile    2023    max    -    Sep    Sun>=2    4:00u    1:00    -
  {
    -77 /*fromYearTiny (2023)*/,
    126 /*toYearTiny (32766)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyChile ACE_TIME_PROGMEM = {
  kZoneRulesChile /*rules*/,
  18 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Cook
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesCook[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Cook    1979    1991    -    Mar    Sun>=1    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyCook ACE_TIME_PROGMEM = {
  kZoneRulesCook /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Cuba
// Rules: 15
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesCuba[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Cuba    1997    only    -    Oct    12    0:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    1997    only    -    Oct    12    0:00s    0    S
  {
    -103 /*fromYearTiny (1997)*/,
    -103 /*toYearTiny (1997)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    1998    1999    -    Mar    lastSun    0:00s    1:00    D
  {
    -102 /*fromYearTiny (1998)*/,
    -101 /*toYearTiny (1999)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    1998    2003    -    Oct    lastSun    0:00s    0    S
  {
    -102 /*fromYearTiny (1998)*/,
    -97 /*toYearTiny (2003)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    2000    2003    -    Apr    Sun>=1    0:00s    1:00    D
  {
    -100 /*fromYearTiny (2000)*/,
    -97 /*toYearTiny (2003)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2004    only    -    Mar    lastSun    0:00s    1:00    D
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2006    2010    -    Oct    lastSun    0:00s    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -90 /*toYearTiny (2010)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    2007    only    -    Mar    Sun>=8    0:00s    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2008    only    -    Mar    Sun>=15    0:00s    1:00    D
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2009    2010    -    Mar    Sun>=8    0:00s    1:00    D
  {
    -91 /*fromYearTiny (2009)*/,
    -90 /*toYearTiny (2010)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2011    only    -    Mar    Sun>=15    0:00s    1:00    D
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2011    only    -    Nov    13    0:00s    0    S
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    2012    only    -    Apr    1    0:00s    1:00    D
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Cuba    2012    max    -    Nov    Sun>=1    0:00s    0    S
  {
    -88 /*fromYearTiny (2012)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Cuba    2013    max    -    Mar    Sun>=8    0:00s    1:00    D
  {
    -87 /*fromYearTiny (2013)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyCuba ACE_TIME_PROGMEM = {
  kZoneRulesCuba /*rules*/,
  15 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Dhaka
// Rules: 3
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesDhaka[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Dhaka    2009    only    -    Dec    31    24:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Dhaka    2009    only    -    Jun    19    23:00    1:00    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    92 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Dhaka    2009    only    -    Dec    31    24:00    0    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyDhaka ACE_TIME_PROGMEM = {
  kZoneRulesDhaka /*rules*/,
  3 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: EU
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesEU[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    EU    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    -121 /*fromYearTiny (1979)*/,
    -105 /*toYearTiny (1995)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1981    max    -    Mar    lastSun     1:00u    1:00    S
  {
    -119 /*fromYearTiny (1981)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    EU    1996    max    -    Oct    lastSun     1:00u    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyEU ACE_TIME_PROGMEM = {
  kZoneRulesEU /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: EUAsia
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesEUAsia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    EUAsia    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EUAsia    1981    max    -    Mar    lastSun     1:00u    1:00    S
  {
    -119 /*fromYearTiny (1981)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    EUAsia    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    -121 /*fromYearTiny (1979)*/,
    -105 /*toYearTiny (1995)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EUAsia    1996    max    -    Oct    lastSun     1:00u    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyEUAsia ACE_TIME_PROGMEM = {
  kZoneRulesEUAsia /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Ecuador
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesEcuador[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Ecuador    1993    only    -    Feb     5    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyEcuador ACE_TIME_PROGMEM = {
  kZoneRulesEcuador /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Eire
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesEire[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Eire    1981    max    -    Mar    lastSun     1:00u    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Eire    1981    max    -    Mar    lastSun     1:00u    0    -
  {
    -119 /*fromYearTiny (1981)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Eire    1990    1995    -    Oct    Sun>=22     1:00u    -1:00    -
  {
    -110 /*fromYearTiny (1990)*/,
    -105 /*toYearTiny (1995)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Eire    1996    max    -    Oct    lastSun     1:00u    -1:00    -
  {
    -104 /*fromYearTiny (1996)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyEire ACE_TIME_PROGMEM = {
  kZoneRulesEire /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Fiji
// Rules: 13
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesFiji[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Fiji    1999    2000    -    Feb    lastSun    3:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    1998    1999    -    Nov    Sun>=1    2:00    1:00    -
  {
    -102 /*fromYearTiny (1998)*/,
    -101 /*toYearTiny (1999)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    1999    2000    -    Feb    lastSun    3:00    0    -
  {
    -101 /*fromYearTiny (1999)*/,
    -100 /*toYearTiny (2000)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2009    only    -    Nov    29    2:00    1:00    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    29 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2010    only    -    Mar    lastSun    3:00    0    -
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2010    2013    -    Oct    Sun>=21    2:00    1:00    -
  {
    -90 /*fromYearTiny (2010)*/,
    -87 /*toYearTiny (2013)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2011    only    -    Mar    Sun>=1    3:00    0    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2012    2013    -    Jan    Sun>=18    3:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -87 /*toYearTiny (2013)*/,
    1 /*inMonth*/,
    7 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2014    only    -    Jan    Sun>=18    2:00    0    -
  {
    -86 /*fromYearTiny (2014)*/,
    -86 /*toYearTiny (2014)*/,
    1 /*inMonth*/,
    7 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2014    2018    -    Nov    Sun>=1    2:00    1:00    -
  {
    -86 /*fromYearTiny (2014)*/,
    -82 /*toYearTiny (2018)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2015    2021    -    Jan    Sun>=12    3:00    0    -
  {
    -85 /*fromYearTiny (2015)*/,
    -79 /*toYearTiny (2021)*/,
    1 /*inMonth*/,
    7 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2019    only    -    Nov    Sun>=8    2:00    1:00    -
  {
    -81 /*fromYearTiny (2019)*/,
    -81 /*toYearTiny (2019)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Fiji    2020    only    -    Dec    20    2:00    1:00    -
  {
    -80 /*fromYearTiny (2020)*/,
    -80 /*toYearTiny (2020)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyFiji ACE_TIME_PROGMEM = {
  kZoneRulesFiji /*rules*/,
  13 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Guat
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesGuat[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Guat    1991    only    -    Sep     7    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Guat    1991    only    -    Sep     7    0:00    0    S
  {
    -109 /*fromYearTiny (1991)*/,
    -109 /*toYearTiny (1991)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Guat    2006    only    -    Apr    30    0:00    1:00    D
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Guat    2006    only    -    Oct     1    0:00    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyGuat ACE_TIME_PROGMEM = {
  kZoneRulesGuat /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: HK
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesHK[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    HK    1979    only    -    Oct    21    3:30    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyHK ACE_TIME_PROGMEM = {
  kZoneRulesHK /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Haiti
// Rules: 8
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesHaiti[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Haiti    1988    1997    -    Oct    lastSun    1:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Haiti    1988    1997    -    Oct    lastSun    1:00s    0    S
  {
    -112 /*fromYearTiny (1988)*/,
    -103 /*toYearTiny (1997)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Haiti    2005    2006    -    Apr    Sun>=1    0:00    1:00    D
  {
    -95 /*fromYearTiny (2005)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Haiti    2005    2006    -    Oct    lastSun    0:00    0    S
  {
    -95 /*fromYearTiny (2005)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Haiti    2012    2015    -    Mar    Sun>=8    2:00    1:00    D
  {
    -88 /*fromYearTiny (2012)*/,
    -85 /*toYearTiny (2015)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Haiti    2012    2015    -    Nov    Sun>=1    2:00    0    S
  {
    -88 /*fromYearTiny (2012)*/,
    -85 /*toYearTiny (2015)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Haiti    2017    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -83 /*fromYearTiny (2017)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Haiti    2017    max    -    Nov    Sun>=1    2:00    0    S
  {
    -83 /*fromYearTiny (2017)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyHaiti ACE_TIME_PROGMEM = {
  kZoneRulesHaiti /*rules*/,
  8 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Holiday
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesHoliday[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Holiday    1993    1994    -    Mar    Sun>=1    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyHoliday ACE_TIME_PROGMEM = {
  kZoneRulesHoliday /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Hond
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesHond[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Hond    1987    1988    -    Sep    lastSun    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Hond    1987    1988    -    Sep    lastSun    0:00    0    S
  {
    -113 /*fromYearTiny (1987)*/,
    -112 /*toYearTiny (1988)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Hond    2006    only    -    May    Sun>=1    0:00    1:00    D
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    5 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Hond    2006    only    -    Aug    Mon>=1    0:00    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    8 /*inMonth*/,
    1 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyHond ACE_TIME_PROGMEM = {
  kZoneRulesHond /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Iran
// Rules: 28
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesIran[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Iran    1996    only    -    Sep    20    24:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    1996    only    -    Sep    20    24:00    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    -104 /*toYearTiny (1996)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    1997    1999    -    Mar    21    24:00    1:00    -
  {
    -103 /*fromYearTiny (1997)*/,
    -101 /*toYearTiny (1999)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    1997    1999    -    Sep    21    24:00    0    -
  {
    -103 /*fromYearTiny (1997)*/,
    -101 /*toYearTiny (1999)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2000    only    -    Mar    20    24:00    1:00    -
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2000    only    -    Sep    20    24:00    0    -
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2001    2003    -    Mar    21    24:00    1:00    -
  {
    -99 /*fromYearTiny (2001)*/,
    -97 /*toYearTiny (2003)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2001    2003    -    Sep    21    24:00    0    -
  {
    -99 /*fromYearTiny (2001)*/,
    -97 /*toYearTiny (2003)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2004    only    -    Mar    20    24:00    1:00    -
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2004    only    -    Sep    20    24:00    0    -
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2005    only    -    Mar    21    24:00    1:00    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2005    only    -    Sep    21    24:00    0    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2008    only    -    Mar    20    24:00    1:00    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2008    only    -    Sep    20    24:00    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2009    2011    -    Mar    21    24:00    1:00    -
  {
    -91 /*fromYearTiny (2009)*/,
    -89 /*toYearTiny (2011)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2009    2011    -    Sep    21    24:00    0    -
  {
    -91 /*fromYearTiny (2009)*/,
    -89 /*toYearTiny (2011)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2012    only    -    Mar    20    24:00    1:00    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2012    only    -    Sep    20    24:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2013    2015    -    Mar    21    24:00    1:00    -
  {
    -87 /*fromYearTiny (2013)*/,
    -85 /*toYearTiny (2015)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2013    2015    -    Sep    21    24:00    0    -
  {
    -87 /*fromYearTiny (2013)*/,
    -85 /*toYearTiny (2015)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2016    only    -    Mar    20    24:00    1:00    -
  {
    -84 /*fromYearTiny (2016)*/,
    -84 /*toYearTiny (2016)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2016    only    -    Sep    20    24:00    0    -
  {
    -84 /*fromYearTiny (2016)*/,
    -84 /*toYearTiny (2016)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2017    2019    -    Mar    21    24:00    1:00    -
  {
    -83 /*fromYearTiny (2017)*/,
    -81 /*toYearTiny (2019)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2017    2019    -    Sep    21    24:00    0    -
  {
    -83 /*fromYearTiny (2017)*/,
    -81 /*toYearTiny (2019)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2020    only    -    Mar    20    24:00    1:00    -
  {
    -80 /*fromYearTiny (2020)*/,
    -80 /*toYearTiny (2020)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2020    only    -    Sep    20    24:00    0    -
  {
    -80 /*fromYearTiny (2020)*/,
    -80 /*toYearTiny (2020)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2021    2022    -    Mar    21    24:00    1:00    -
  {
    -79 /*fromYearTiny (2021)*/,
    -78 /*toYearTiny (2022)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iran    2021    2022    -    Sep    21    24:00    0    -
  {
    -79 /*fromYearTiny (2021)*/,
    -78 /*toYearTiny (2022)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyIran ACE_TIME_PROGMEM = {
  kZoneRulesIran /*rules*/,
  28 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Iraq
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesIraq[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Iraq    1985    1990    -    Sep    lastSun    1:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iraq    1985    1990    -    Sep    lastSun    1:00s    0    -
  {
    -115 /*fromYearTiny (1985)*/,
    -110 /*toYearTiny (1990)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iraq    1991    2007    -    Apr     1    3:00s    1:00    -
  {
    -109 /*fromYearTiny (1991)*/,
    -93 /*toYearTiny (2007)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Iraq    1991    2007    -    Oct     1    3:00s    0    -
  {
    -109 /*fromYearTiny (1991)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyIraq ACE_TIME_PROGMEM = {
  kZoneRulesIraq /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Japan
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesJapan[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Japan    1948    1951    -    Sep    Sat>=8    25:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyJapan ACE_TIME_PROGMEM = {
  kZoneRulesJapan /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Jordan
// Rules: 14
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesJordan[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Jordan    1995    1998    -    Sep    Fri>=15    0:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    1995    1998    -    Sep    Fri>=15    0:00s    0    -
  {
    -105 /*fromYearTiny (1995)*/,
    -102 /*toYearTiny (1998)*/,
    9 /*inMonth*/,
    5 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    1999    only    -    Jul     1    0:00s    1:00    S
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Jordan    1999    2002    -    Sep    lastFri    0:00s    0    -
  {
    -101 /*fromYearTiny (1999)*/,
    -98 /*toYearTiny (2002)*/,
    9 /*inMonth*/,
    5 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2000    2001    -    Mar    lastThu    0:00s    1:00    S
  {
    -100 /*fromYearTiny (2000)*/,
    -99 /*toYearTiny (2001)*/,
    3 /*inMonth*/,
    4 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Jordan    2002    2012    -    Mar    lastThu    24:00    1:00    S
  {
    -98 /*fromYearTiny (2002)*/,
    -88 /*toYearTiny (2012)*/,
    3 /*inMonth*/,
    4 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Jordan    2003    only    -    Oct    24    0:00s    0    -
  {
    -97 /*fromYearTiny (2003)*/,
    -97 /*toYearTiny (2003)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2004    only    -    Oct    15    0:00s    0    -
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2005    only    -    Sep    lastFri    0:00s    0    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    9 /*inMonth*/,
    5 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2006    2011    -    Oct    lastFri    0:00s    0    -
  {
    -94 /*fromYearTiny (2006)*/,
    -89 /*toYearTiny (2011)*/,
    10 /*inMonth*/,
    5 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2013    only    -    Dec    20    0:00    0    -
  {
    -87 /*fromYearTiny (2013)*/,
    -87 /*toYearTiny (2013)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2014    2021    -    Mar    lastThu    24:00    1:00    S
  {
    -86 /*fromYearTiny (2014)*/,
    -79 /*toYearTiny (2021)*/,
    3 /*inMonth*/,
    4 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Jordan    2014    2022    -    Oct    lastFri    0:00s    0    -
  {
    -86 /*fromYearTiny (2014)*/,
    -78 /*toYearTiny (2022)*/,
    10 /*inMonth*/,
    5 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Jordan    2022    only    -    Feb    lastThu    24:00    1:00    S
  {
    -78 /*fromYearTiny (2022)*/,
    -78 /*toYearTiny (2022)*/,
    2 /*inMonth*/,
    4 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    96 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyJordan ACE_TIME_PROGMEM = {
  kZoneRulesJordan /*rules*/,
  14 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: LH
// Rules: 10
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesLH[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    LH    1990    1995    -    Mar    Sun>=1    2:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    1987    1999    -    Oct    lastSun    2:00    0:30    -
  {
    -113 /*fromYearTiny (1987)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    6 /*deltaCode ((deltaMinutes=30)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    1990    1995    -    Mar    Sun>=1    2:00    0    -
  {
    -110 /*fromYearTiny (1990)*/,
    -105 /*toYearTiny (1995)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    1996    2005    -    Mar    lastSun    2:00    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2000    only    -    Aug    lastSun    2:00    0:30    -
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    8 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    6 /*deltaCode ((deltaMinutes=30)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2001    2007    -    Oct    lastSun    2:00    0:30    -
  {
    -99 /*fromYearTiny (2001)*/,
    -93 /*toYearTiny (2007)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    6 /*deltaCode ((deltaMinutes=30)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2006    only    -    Apr    Sun>=1    2:00    0    -
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2007    only    -    Mar    lastSun    2:00    0    -
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2008    max    -    Apr    Sun>=1    2:00    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    LH    2008    max    -    Oct    Sun>=1    2:00    0:30    -
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    6 /*deltaCode ((deltaMinutes=30)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyLH ACE_TIME_PROGMEM = {
  kZoneRulesLH /*rules*/,
  10 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Lebanon
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesLebanon[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Lebanon    1993    1998    -    Sep    lastSun    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Lebanon    1993    max    -    Mar    lastSun    0:00    1:00    S
  {
    -107 /*fromYearTiny (1993)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Lebanon    1993    1998    -    Sep    lastSun    0:00    0    -
  {
    -107 /*fromYearTiny (1993)*/,
    -102 /*toYearTiny (1998)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Lebanon    1999    max    -    Oct    lastSun    0:00    0    -
  {
    -101 /*fromYearTiny (1999)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyLebanon ACE_TIME_PROGMEM = {
  kZoneRulesLebanon /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Macau
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMacau[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Macau    1979    only    -    Oct    Sun>=16    03:30    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMacau ACE_TIME_PROGMEM = {
  kZoneRulesMacau /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Mauritius
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMauritius[] ACE_TIME_PROGMEM = {
  // Anchor: Rule Mauritius    1983    only    -    Mar    21    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Mauritius    1983    only    -    Mar    21    0:00    0    -
  {
    -117 /*fromYearTiny (1983)*/,
    -117 /*toYearTiny (1983)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Mauritius    2008    only    -    Oct    lastSun    2:00    1:00    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Mauritius    2009    only    -    Mar    lastSun    2:00    0    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMauritius ACE_TIME_PROGMEM = {
  kZoneRulesMauritius /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Mexico
// Rules: 8
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMexico[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Mexico    1950    only    -    Jul    30    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Mexico    1950    only    -    Jul    30    0:00    0    S
  {
    -127 /*fromYearTiny (1950)*/,
    -127 /*toYearTiny (1950)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Mexico    1996    2000    -    Apr    Sun>=1    2:00    1:00    D
  {
    -104 /*fromYearTiny (1996)*/,
    -100 /*toYearTiny (2000)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Mexico    1996    2000    -    Oct    lastSun    2:00    0    S
  {
    -104 /*fromYearTiny (1996)*/,
    -100 /*toYearTiny (2000)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Mexico    2001    only    -    May    Sun>=1    2:00    1:00    D
  {
    -99 /*fromYearTiny (2001)*/,
    -99 /*toYearTiny (2001)*/,
    5 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Mexico    2001    only    -    Sep    lastSun    2:00    0    S
  {
    -99 /*fromYearTiny (2001)*/,
    -99 /*toYearTiny (2001)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Mexico    2002    2022    -    Apr    Sun>=1    2:00    1:00    D
  {
    -98 /*fromYearTiny (2002)*/,
    -78 /*toYearTiny (2022)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Mexico    2002    2022    -    Oct    lastSun    2:00    0    S
  {
    -98 /*fromYearTiny (2002)*/,
    -78 /*toYearTiny (2022)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMexico ACE_TIME_PROGMEM = {
  kZoneRulesMexico /*rules*/,
  8 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Moldova
// Rules: 3
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMoldova[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Moldova    1997    max    -    Oct    lastSun     3:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Moldova    1997    max    -    Mar    lastSun     2:00    1:00    S
  {
    -103 /*fromYearTiny (1997)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Moldova    1997    max    -    Oct    lastSun     3:00    0    -
  {
    -103 /*fromYearTiny (1997)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMoldova ACE_TIME_PROGMEM = {
  kZoneRulesMoldova /*rules*/,
  3 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Moncton
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMoncton[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Moncton    1957    1972    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Moncton    1957    1972    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1957)*/,
    -127 /*toYearTiny (1972)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Moncton    1993    2006    -    Apr    Sun>=1    0:01    1:00    D
  {
    -107 /*fromYearTiny (1993)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    1 /*atTimeModifier (kSuffixW + minute=1)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Moncton    1993    2006    -    Oct    lastSun    0:01    0    S
  {
    -107 /*fromYearTiny (1993)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    1 /*atTimeModifier (kSuffixW + minute=1)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMoncton ACE_TIME_PROGMEM = {
  kZoneRulesMoncton /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Mongol
// Rules: 7
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesMongol[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Mongol    1984    1998    -    Sep    lastSun    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    1984    1998    -    Sep    lastSun    0:00    0    -
  {
    -116 /*fromYearTiny (1984)*/,
    -102 /*toYearTiny (1998)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    2001    only    -    Apr    lastSat    2:00    1:00    -
  {
    -99 /*fromYearTiny (2001)*/,
    -99 /*toYearTiny (2001)*/,
    4 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    2001    2006    -    Sep    lastSat    2:00    0    -
  {
    -99 /*fromYearTiny (2001)*/,
    -94 /*toYearTiny (2006)*/,
    9 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    2002    2006    -    Mar    lastSat    2:00    1:00    -
  {
    -98 /*fromYearTiny (2002)*/,
    -94 /*toYearTiny (2006)*/,
    3 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    2015    2016    -    Mar    lastSat    2:00    1:00    -
  {
    -85 /*fromYearTiny (2015)*/,
    -84 /*toYearTiny (2016)*/,
    3 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Mongol    2015    2016    -    Sep    lastSat    0:00    0    -
  {
    -85 /*fromYearTiny (2015)*/,
    -84 /*toYearTiny (2016)*/,
    9 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyMongol ACE_TIME_PROGMEM = {
  kZoneRulesMongol /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: NC
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesNC[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    NC    1997    only    -    Mar     2    2:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyNC ACE_TIME_PROGMEM = {
  kZoneRulesNC /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: NZ
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesNZ[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    NZ    1990    2007    -    Mar    Sun>=15    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    NZ    1989    only    -    Oct    Sun>=8    2:00s    1:00    D
  {
    -111 /*fromYearTiny (1989)*/,
    -111 /*toYearTiny (1989)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    NZ    1990    2006    -    Oct    Sun>=1    2:00s    1:00    D
  {
    -110 /*fromYearTiny (1990)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    NZ    1990    2007    -    Mar    Sun>=15    2:00s    0    S
  {
    -110 /*fromYearTiny (1990)*/,
    -93 /*toYearTiny (2007)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    NZ    2007    max    -    Sep    lastSun    2:00s    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    NZ    2008    max    -    Apr    Sun>=1    2:00s    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    126 /*toYearTiny (32766)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyNZ ACE_TIME_PROGMEM = {
  kZoneRulesNZ /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Namibia
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesNamibia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1994    only    -    Mar    21    0:00    -1:00    WAT
  {
    -106 /*fromYearTiny (1994)*/,
    -106 /*toYearTiny (1994)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    5 /*letterIndex ("WAT")*/,
  },
  // Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    -106 /*fromYearTiny (1994)*/,
    -83 /*toYearTiny (2017)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1995    2017    -    Apr    Sun>=1    2:00    -1:00    WAT
  {
    -105 /*fromYearTiny (1995)*/,
    -83 /*toYearTiny (2017)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    5 /*letterIndex ("WAT")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyNamibia ACE_TIME_PROGMEM = {
  kZoneRulesNamibia /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Nic
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesNic[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Nic    1979    1980    -    Jun    Mon>=23    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Nic    1979    1980    -    Jun    Mon>=23    0:00    0    S
  {
    -121 /*fromYearTiny (1979)*/,
    -120 /*toYearTiny (1980)*/,
    6 /*inMonth*/,
    1 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Nic    2005    only    -    Apr    10    0:00    1:00    D
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Nic    2005    only    -    Oct    Sun>=1    0:00    0    S
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Nic    2006    only    -    Apr    30    2:00    1:00    D
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Nic    2006    only    -    Oct    Sun>=1    1:00    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyNic ACE_TIME_PROGMEM = {
  kZoneRulesNic /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: PRC
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesPRC[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    PRC    1986    1991    -    Sep    Sun>=11     2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyPRC ACE_TIME_PROGMEM = {
  kZoneRulesPRC /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Pakistan
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesPakistan[] ACE_TIME_PROGMEM = {
  // Anchor: Rule Pakistan    2002    only    -    Oct    Sun>=2    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Pakistan    2002    only    -    Apr    Sun>=2    0:00    1:00    S
  {
    -98 /*fromYearTiny (2002)*/,
    -98 /*toYearTiny (2002)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule Pakistan    2002    only    -    Oct    Sun>=2    0:00    0    -
  {
    -98 /*fromYearTiny (2002)*/,
    -98 /*toYearTiny (2002)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Pakistan    2008    only    -    Jun    1    0:00    1:00    S
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule Pakistan    2008    2009    -    Nov    1    0:00    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    -91 /*toYearTiny (2009)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule Pakistan    2009    only    -    Apr    15    0:00    1:00    S
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyPakistan ACE_TIME_PROGMEM = {
  kZoneRulesPakistan /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Peru
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesPeru[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Peru    1994    only    -    Apr     1    0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyPeru ACE_TIME_PROGMEM = {
  kZoneRulesPeru /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Phil
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesPhil[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Phil    1990    only    -    Jul    28    24:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyPhil ACE_TIME_PROGMEM = {
  kZoneRulesPhil /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: ROK
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesROK[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    ROK    1987    1988    -    Oct    Sun>=8     3:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyROK ACE_TIME_PROGMEM = {
  kZoneRulesROK /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: RussiaAsia
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesRussiaAsia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule RussiaAsia    1984    1995    -    Sep    lastSun     2:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule RussiaAsia    1984    1995    -    Sep    lastSun     2:00s    0    -
  {
    -116 /*fromYearTiny (1984)*/,
    -105 /*toYearTiny (1995)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule RussiaAsia    1985    2010    -    Mar    lastSun     2:00s    1:00    -
  {
    -115 /*fromYearTiny (1985)*/,
    -90 /*toYearTiny (2010)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule RussiaAsia    1996    2010    -    Oct    lastSun     2:00s    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    -90 /*toYearTiny (2010)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyRussiaAsia ACE_TIME_PROGMEM = {
  kZoneRulesRussiaAsia /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: SA
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesSA[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    SA    1943    1944    -    Mar    Sun>=15    2:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicySA ACE_TIME_PROGMEM = {
  kZoneRulesSA /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Salv
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesSalv[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Salv    1987    1988    -    Sep    lastSun    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicySalv ACE_TIME_PROGMEM = {
  kZoneRulesSalv /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Taiwan
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesTaiwan[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Taiwan    1979    only    -    Oct    1    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyTaiwan ACE_TIME_PROGMEM = {
  kZoneRulesTaiwan /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Thule
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesThule[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Thule    1991    1992    -    Sep    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Thule    1991    1992    -    Sep    lastSun    2:00    0    S
  {
    -109 /*fromYearTiny (1991)*/,
    -108 /*toYearTiny (1992)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Thule    1993    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    -107 /*fromYearTiny (1993)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Thule    1993    2006    -    Oct    lastSun    2:00    0    S
  {
    -107 /*fromYearTiny (1993)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Thule    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Thule    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyThule ACE_TIME_PROGMEM = {
  kZoneRulesThule /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Tonga
// Rules: 7
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesTonga[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Tonga    2000    only    -    Mar    19    2:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    1999    only    -    Oct     7    2:00s    1:00    -
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    2000    only    -    Mar    19    2:00s    0    -
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    2000    2001    -    Nov    Sun>=1    2:00    1:00    -
  {
    -100 /*fromYearTiny (2000)*/,
    -99 /*toYearTiny (2001)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    2001    2002    -    Jan    lastSun    2:00    0    -
  {
    -99 /*fromYearTiny (2001)*/,
    -98 /*toYearTiny (2002)*/,
    1 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    2016    only    -    Nov    Sun>=1    2:00    1:00    -
  {
    -84 /*fromYearTiny (2016)*/,
    -84 /*toYearTiny (2016)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tonga    2017    only    -    Jan    Sun>=15    3:00    0    -
  {
    -83 /*fromYearTiny (2017)*/,
    -83 /*toYearTiny (2017)*/,
    1 /*inMonth*/,
    7 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyTonga ACE_TIME_PROGMEM = {
  kZoneRulesTonga /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Tunisia
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesTunisia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Tunisia    1988    1990    -    Sep    lastSun     0:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tunisia    1988    1990    -    Sep    lastSun     0:00s    0    -
  {
    -112 /*fromYearTiny (1988)*/,
    -110 /*toYearTiny (1990)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tunisia    2005    only    -    May     1     0:00s    1:00    S
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Tunisia    2005    only    -    Sep    30     1:00s    0    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Tunisia    2006    2008    -    Mar    lastSun     2:00s    1:00    S
  {
    -94 /*fromYearTiny (2006)*/,
    -92 /*toYearTiny (2008)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Tunisia    2006    2008    -    Oct    lastSun     2:00s    0    -
  {
    -94 /*fromYearTiny (2006)*/,
    -92 /*toYearTiny (2008)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyTunisia ACE_TIME_PROGMEM = {
  kZoneRulesTunisia /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: US
// Rules: 6
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesUS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1967)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    US    1976    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -124 /*fromYearTiny (1976)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    US    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyUS ACE_TIME_PROGMEM = {
  kZoneRulesUS /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Uruguay
// Rules: 7
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesUruguay[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Uruguay    1993    only    -    Feb    28     0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    1993    only    -    Feb    28     0:00    0    -
  {
    -107 /*fromYearTiny (1993)*/,
    -107 /*toYearTiny (1993)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    2004    only    -    Sep    19     0:00    1:00    -
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    2005    only    -    Mar    27     2:00    0    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    2005    only    -    Oct     9     2:00    1:00    -
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    2006    2015    -    Mar    Sun>=8     2:00    0    -
  {
    -94 /*fromYearTiny (2006)*/,
    -85 /*toYearTiny (2015)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Uruguay    2006    2014    -    Oct    Sun>=1     2:00    1:00    -
  {
    -94 /*fromYearTiny (2006)*/,
    -86 /*toYearTiny (2014)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyUruguay ACE_TIME_PROGMEM = {
  kZoneRulesUruguay /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Vanuatu
// Rules: 1
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesVanuatu[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Vanuatu    1992    1993    -    Jan    Sat>=22    24:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyVanuatu ACE_TIME_PROGMEM = {
  kZoneRulesVanuatu /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Winn
// Rules: 4
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesWinn[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Winn    1966    2005    -    Oct    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1966    1986    -    Apr    lastSun    2:00s    1:00    D
  {
    -127 /*fromYearTiny (1966)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Winn    1966    2005    -    Oct    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (1966)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1987    2005    -    Apr    Sun>=1    2:00s    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -95 /*toYearTiny (2005)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyWinn ACE_TIME_PROGMEM = {
  kZoneRulesWinn /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Zion
// Rules: 25
//---------------------------------------------------------------------------

static const basic::Info::ZoneRule kZoneRulesZion[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Zion    1998    only    -    Sep     6    0:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    1998    only    -    Sep     6    0:00    0    S
  {
    -102 /*fromYearTiny (1998)*/,
    -102 /*toYearTiny (1998)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    1999    only    -    Apr     2    2:00    1:00    D
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    1999    only    -    Sep     3    2:00    0    S
  {
    -101 /*fromYearTiny (1999)*/,
    -101 /*toYearTiny (1999)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2000    only    -    Apr    14    2:00    1:00    D
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2000    only    -    Oct     6    1:00    0    S
  {
    -100 /*fromYearTiny (2000)*/,
    -100 /*toYearTiny (2000)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2001    only    -    Apr     9    1:00    1:00    D
  {
    -99 /*fromYearTiny (2001)*/,
    -99 /*toYearTiny (2001)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2001    only    -    Sep    24    1:00    0    S
  {
    -99 /*fromYearTiny (2001)*/,
    -99 /*toYearTiny (2001)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2002    only    -    Mar    29    1:00    1:00    D
  {
    -98 /*fromYearTiny (2002)*/,
    -98 /*toYearTiny (2002)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    29 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2002    only    -    Oct     7    1:00    0    S
  {
    -98 /*fromYearTiny (2002)*/,
    -98 /*toYearTiny (2002)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2003    only    -    Mar    28    1:00    1:00    D
  {
    -97 /*fromYearTiny (2003)*/,
    -97 /*toYearTiny (2003)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2003    only    -    Oct     3    1:00    0    S
  {
    -97 /*fromYearTiny (2003)*/,
    -97 /*toYearTiny (2003)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2004    only    -    Apr     7    1:00    1:00    D
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2004    only    -    Sep    22    1:00    0    S
  {
    -96 /*fromYearTiny (2004)*/,
    -96 /*toYearTiny (2004)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2005    2012    -    Apr    Fri<=1    2:00    1:00    D
  {
    -95 /*fromYearTiny (2005)*/,
    -88 /*toYearTiny (2012)*/,
    4 /*inMonth*/,
    5 /*onDayOfWeek*/,
    -1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2005    only    -    Oct     9    2:00    0    S
  {
    -95 /*fromYearTiny (2005)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2006    only    -    Oct     1    2:00    0    S
  {
    -94 /*fromYearTiny (2006)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2007    only    -    Sep    16    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    -93 /*toYearTiny (2007)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2008    only    -    Oct     5    2:00    0    S
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2009    only    -    Sep    27    2:00    0    S
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2010    only    -    Sep    12    2:00    0    S
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2011    only    -    Oct     2    2:00    0    S
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2012    only    -    Sep    23    2:00    0    S
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },
  // Rule    Zion    2013    max    -    Mar    Fri>=23    2:00    1:00    D
  {
    -87 /*fromYearTiny (2013)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    5 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("D")*/,
  },
  // Rule    Zion    2013    max    -    Oct    lastSun    2:00    0    S
  {
    -87 /*fromYearTiny (2013)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    4 /*letterIndex ("S")*/,
  },

};

const basic::Info::ZonePolicy kZonePolicyZion ACE_TIME_PROGMEM = {
  kZoneRulesZion /*rules*/,
  25 /*numRules*/,
};



}
}
