// This file was generated by the following script:
//
//   $ /home/brian/src/AceTimeSuite/compiler/src/acetimecompiler/tzcompiler.py
//     --input_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/zonedb/tzfiles
//     --output_dir /home/brian/src/AceTimeSuite/libraries/AceTimeLib/src/zonedb
//     --tz_version 2025b
//     --action zonedb
//     --language arduino
//     --scope basic
//     --db_namespace zonedb
//     --zi_namespace basic::Info
//     --start_year 2000
//     --until_year 2200
//
// using the TZ Database files
//
//   africa
//   antarctica
//   asia
//   australasia
//   backward
//   etcetera
//   europe
//   northamerica
//   southamerica
//
// from https://github.com/eggert/tz/releases/tag/2025b
//
// Supported Zones: 446 (215 zones, 231 links)
// Unsupported Zones: 151 (125 zones, 26 links)
//
// Requested Years: [2000,2200]
// Accurate Years: [2000,32767]
//
// Original Years:  [1844,2087]
// Generated Years: [1950,2023]
// Lower/Upper Truncated: [True,False]
//
// Estimator Years: [1950,2025]
// Max Buffer Size: 6
//
// Records:
//   Infos: 446
//   Eras: 227
//   Policies: 63
//   Rules: 352
//
// Memory (8-bits):
//   Context: 16
//   Rules: 3168
//   Policies: 189
//   Eras: 2497
//   Zones: 2795
//   Links: 3003
//   Registry: 892
//   Formats: 175
//   Letters: 29
//   Fragments: 116
//   Names: 4142 (original: 6494)
//   TOTAL: 17022
//
// Memory (32-bits):
//   Context: 24
//   Rules: 4224
//   Policies: 504
//   Eras: 3632
//   Zones: 5160
//   Links: 5544
//   Registry: 1784
//   Formats: 175
//   Letters: 41
//   Fragments: 138
//   Names: 4142 (original: 6494)
//   TOTAL: 25368
//
// DO NOT EDIT

#include <zoneinfo/compat.h>
#include "zone_infos.h"
#include "zone_registry.h"

namespace ace_time {
namespace zonedb {

//---------------------------------------------------------------------------
// Zone Info registry. Sorted by zoneId.
//---------------------------------------------------------------------------
const basic::Info::ZoneInfo* const kZoneRegistry[215] ACE_TIME_PROGMEM = {
  &kZoneAsia_Jakarta, // 0x0506ab50, Asia/Jakarta
  &kZoneAmerica_Mazatlan, // 0x0532189e, America/Mazatlan
  &kZoneAmerica_Hermosillo, // 0x065d21c4, America/Hermosillo
  &kZoneAmerica_Guatemala, // 0x0c8259f7, America/Guatemala
  &kZoneAfrica_Monrovia, // 0x0ce90385, Africa/Monrovia
  &kZoneAntarctica_Rothera, // 0x0e86d203, Antarctica/Rothera
  &kZoneAustralia_Melbourne, // 0x0fe559a3, Australia/Melbourne
  &kZoneAmerica_Sao_Paulo, // 0x1063bfc9, America/Sao_Paulo
  &kZoneAmerica_Indiana_Vevay, // 0x10aca054, America/Indiana/Vevay
  &kZoneAsia_Samarkand, // 0x13ae5104, Asia/Samarkand
  &kZoneAsia_Dhaka, // 0x14c07b8b, Asia/Dhaka
  &kZoneAsia_Dubai, // 0x14c79f77, Asia/Dubai
  &kZoneAsia_Kabul, // 0x153b5601, Asia/Kabul
  &kZoneAsia_Macau, // 0x155f88b9, Asia/Macau
  &kZoneAsia_Qatar, // 0x15a8330b, Asia/Qatar
  &kZoneAsia_Seoul, // 0x15ce82da, Asia/Seoul
  &kZoneAsia_Tokyo, // 0x15e606a8, Asia/Tokyo
  &kZoneAsia_Thimphu, // 0x170380d1, Asia/Thimphu
  &kZoneAmerica_Guayaquil, // 0x17e64958, America/Guayaquil
  &kZoneAmerica_Kentucky_Louisville, // 0x1a21024b, America/Kentucky/Louisville
  &kZoneAsia_Pontianak, // 0x1a76c057, Asia/Pontianak
  &kZoneAmerica_New_York, // 0x1e2a7654, America/New_York
  &kZoneAsia_Baku, // 0x1fa788b5, Asia/Baku
  &kZoneAsia_Hovd, // 0x1fab0fe3, Asia/Hovd
  &kZoneAsia_Ho_Chi_Minh, // 0x20f2d127, Asia/Ho_Chi_Minh
  &kZonePacific_Fiji, // 0x23383ba5, Pacific/Fiji
  &kZonePacific_Niue, // 0x233ca014, Pacific/Niue
  &kZoneAustralia_Adelaide, // 0x2428e8a3, Australia/Adelaide
  &kZonePacific_Auckland, // 0x25062f86, Pacific/Auckland
  &kZonePacific_Tongatapu, // 0x262ca836, Pacific/Tongatapu
  &kZoneAmerica_Monterrey, // 0x269a1deb, America/Monterrey
  &kZoneAustralia_Darwin, // 0x2876bdff, Australia/Darwin
  &kZoneAmerica_Indiana_Indianapolis, // 0x28a669a4, America/Indiana/Indianapolis
  &kZoneAmerica_Vancouver, // 0x2c6f6b1f, America/Vancouver
  &kZonePacific_Chatham, // 0x2f0de999, Pacific/Chatham
  &kZoneAmerica_Indiana_Marengo, // 0x2feeee72, America/Indiana/Marengo
  &kZoneAsia_Ulaanbaatar, // 0x30f0cc4e, Asia/Ulaanbaatar
  &kZoneAustralia_Hobart, // 0x32bf951a, Australia/Hobart
  &kZoneAsia_Dushanbe, // 0x32fc5c3c, Asia/Dushanbe
  &kZoneAtlantic_South_Georgia, // 0x33013174, Atlantic/South_Georgia
  &kZoneAmerica_Phoenix, // 0x34b5af01, America/Phoenix
  &kZoneAmerica_Cayenne, // 0x3c617269, America/Cayenne
  &kZoneAtlantic_Bermuda, // 0x3d4bb1c4, Atlantic/Bermuda
  &kZoneAmerica_Managua, // 0x3d5e7600, America/Managua
  &kZoneEtc_GMT_PLUS_10, // 0x3f8f1cc4, Etc/GMT+10
  &kZoneEtc_GMT_PLUS_11, // 0x3f8f1cc5, Etc/GMT+11
  &kZoneEtc_GMT_PLUS_12, // 0x3f8f1cc6, Etc/GMT+12
  &kZoneEtc_GMT_10, // 0x3f8f2546, Etc/GMT-10
  &kZoneEtc_GMT_11, // 0x3f8f2547, Etc/GMT-11
  &kZoneEtc_GMT_12, // 0x3f8f2548, Etc/GMT-12
  &kZoneEtc_GMT_13, // 0x3f8f2549, Etc/GMT-13
  &kZoneEtc_GMT_14, // 0x3f8f254a, Etc/GMT-14
  &kZoneEurope_Athens, // 0x4318fa27, Europe/Athens
  &kZoneEurope_Berlin, // 0x44644c20, Europe/Berlin
  &kZoneIndian_Chagos, // 0x456f7c3c, Indian/Chagos
  &kZoneEurope_Dublin, // 0x4a275f62, Europe/Dublin
  &kZoneAsia_Nicosia, // 0x4b0fcf78, Asia/Nicosia
  &kZoneAmerica_Chicago, // 0x4b92b5d4, America/Chicago
  &kZoneAustralia_Sydney, // 0x4d1e9776, Australia/Sydney
  &kZoneAustralia_Brisbane, // 0x4fedc9c0, Australia/Brisbane
  &kZoneAsia_Karachi, // 0x527f5245, Asia/Karachi
  &kZonePacific_Gambier, // 0x53720c3a, Pacific/Gambier
  &kZoneAmerica_Martinique, // 0x551e84c5, America/Martinique
  &kZoneAmerica_Jamaica, // 0x565dad6c, America/Jamaica
  &kZoneAsia_Hong_Kong, // 0x577f28ac, Asia/Hong_Kong
  &kZonePacific_Marquesas, // 0x57ca7135, Pacific/Marquesas
  &kZoneAmerica_Miquelon, // 0x59674330, America/Miquelon
  &kZoneAmerica_Anchorage, // 0x5a79260e, America/Anchorage
  &kZoneAsia_Jerusalem, // 0x5becd23a, Asia/Jerusalem
  &kZoneEurope_Lisbon, // 0x5c00a70b, Europe/Lisbon
  &kZoneAtlantic_Cape_Verde, // 0x5c5e1772, Atlantic/Cape_Verde
  &kZoneEurope_London, // 0x5c6a84ae, Europe/London
  &kZoneEurope_Madrid, // 0x5dbd1535, Europe/Madrid
  &kZoneAmerica_Moncton, // 0x5e07fe24, America/Moncton
  &kZonePacific_Pago_Pago, // 0x603aebd0, Pacific/Pago_Pago
  &kZoneAmerica_Costa_Rica, // 0x63ff66be, America/Costa_Rica
  &kZoneEurope_Prague, // 0x65ee5d48, Europe/Prague
  &kZoneAmerica_Puerto_Rico, // 0x6752ca31, America/Puerto_Rico
  &kZoneAsia_Makassar, // 0x6aa21c85, Asia/Makassar
  &kZoneEurope_Helsinki, // 0x6ab2975b, Europe/Helsinki
  &kZoneAmerica_Porto_Velho, // 0x6b1aac77, America/Porto_Velho
  &kZoneAmerica_Edmonton, // 0x6cb9484a, America/Edmonton
  &kZoneAmerica_Dawson_Creek, // 0x6cf24e5b, America/Dawson_Creek
  &kZoneEurope_Tirane, // 0x6ea95b47, Europe/Tirane
  &kZoneAsia_Kolkata, // 0x72c06cd9, Asia/Kolkata
  &kZoneEurope_Vienna, // 0x734cc2e5, Europe/Vienna
  &kZoneAmerica_Santiago, // 0x7410c9bc, America/Santiago
  &kZoneEurope_Warsaw, // 0x75185c19, Europe/Warsaw
  &kZoneAmerica_El_Salvador, // 0x752ad652, America/El_Salvador
  &kZoneAfrica_Bissau, // 0x75564141, Africa/Bissau
  &kZoneAfrica_Ceuta, // 0x77fb46ec, Africa/Ceuta
  &kZoneAfrica_Lagos, // 0x789bb5d0, Africa/Lagos
  &kZoneAfrica_Windhoek, // 0x789c9bd3, Africa/Windhoek
  &kZoneAmerica_Toronto, // 0x792e851b, America/Toronto
  &kZoneAfrica_Tunis, // 0x79378e6d, Africa/Tunis
  &kZoneIndian_Mauritius, // 0x7b09c02a, Indian/Mauritius
  &kZoneEurope_Zurich, // 0x7d8195b9, Europe/Zurich
  &kZoneAsia_Kuching, // 0x801b003b, Asia/Kuching
  &kZoneAtlantic_Madeira, // 0x81b5c037, Atlantic/Madeira
  &kZonePacific_Kiritimati, // 0x8305073a, Pacific/Kiritimati
  &kZonePacific_Pitcairn, // 0x8837d8bd, Pacific/Pitcairn
  &kZonePacific_Efate, // 0x8a2bce28, Pacific/Efate
  &kZonePacific_Nauru, // 0x8acc41ae, Pacific/Nauru
  &kZonePacific_Palau, // 0x8af04a36, Pacific/Palau
  &kZoneAmerica_Winnipeg, // 0x8c7dafc7, America/Winnipeg
  &kZoneAustralia_Eucla, // 0x8cf99e44, Australia/Eucla
  &kZoneAustralia_Perth, // 0x8db8269d, Australia/Perth
  &kZonePacific_Kwajalein, // 0x8e216759, Pacific/Kwajalein
  &kZoneAmerica_Port_au_Prince, // 0x8e4a7bdc, America/Port-au-Prince
  &kZoneAfrica_Maputo, // 0x8e6ca1f0, Africa/Maputo
  &kZoneAsia_Yerevan, // 0x9185c8cc, Asia/Yerevan
  &kZoneAmerica_Detroit, // 0x925cfbc1, America/Detroit
  &kZoneAmerica_Belize, // 0x93256c81, America/Belize
  &kZoneAmerica_Bogota, // 0x93d7bc62, America/Bogota
  &kZoneAmerica_Glace_Bay, // 0x9681f8dd, America/Glace_Bay
  &kZoneAmerica_Denver, // 0x97d10b2a, America/Denver
  &kZoneAmerica_Belem, // 0x97da580b, America/Belem
  &kZoneAmerica_Boise, // 0x97dfc8d8, America/Boise
  &kZoneEurope_Andorra, // 0x97f6764b, Europe/Andorra
  &kZoneAmerica_Adak, // 0x97fe49d7, America/Adak
  &kZoneAmerica_Lima, // 0x980468c9, America/Lima
  &kZoneAmerica_Nome, // 0x98059b15, America/Nome
  &kZoneIndian_Maldives, // 0x9869681c, Indian/Maldives
  &kZoneAmerica_Sitka, // 0x99104ce2, America/Sitka
  &kZoneAmerica_Thule, // 0x9921dd68, America/Thule
  &kZonePacific_Rarotonga, // 0x9981a3b0, Pacific/Rarotonga
  &kZoneAsia_Kathmandu, // 0x9a96ce6f, Asia/Kathmandu
  &kZoneEurope_Budapest, // 0x9ce0197c, Europe/Budapest
  &kZoneAsia_Baghdad, // 0x9ceffbed, Asia/Baghdad
  &kZoneEtc_GMT_PLUS_1, // 0x9d13da14, Etc/GMT+1
  &kZoneEtc_GMT_PLUS_2, // 0x9d13da15, Etc/GMT+2
  &kZoneEtc_GMT_PLUS_3, // 0x9d13da16, Etc/GMT+3
  &kZoneEtc_GMT_PLUS_4, // 0x9d13da17, Etc/GMT+4
  &kZoneEtc_GMT_PLUS_5, // 0x9d13da18, Etc/GMT+5
  &kZoneEtc_GMT_PLUS_6, // 0x9d13da19, Etc/GMT+6
  &kZoneEtc_GMT_PLUS_7, // 0x9d13da1a, Etc/GMT+7
  &kZoneEtc_GMT_PLUS_8, // 0x9d13da1b, Etc/GMT+8
  &kZoneEtc_GMT_PLUS_9, // 0x9d13da1c, Etc/GMT+9
  &kZoneEtc_GMT_1, // 0x9d13da56, Etc/GMT-1
  &kZoneEtc_GMT_2, // 0x9d13da57, Etc/GMT-2
  &kZoneEtc_GMT_3, // 0x9d13da58, Etc/GMT-3
  &kZoneEtc_GMT_4, // 0x9d13da59, Etc/GMT-4
  &kZoneEtc_GMT_5, // 0x9d13da5a, Etc/GMT-5
  &kZoneEtc_GMT_6, // 0x9d13da5b, Etc/GMT-6
  &kZoneEtc_GMT_7, // 0x9d13da5c, Etc/GMT-7
  &kZoneEtc_GMT_8, // 0x9d13da5d, Etc/GMT-8
  &kZoneEtc_GMT_9, // 0x9d13da5e, Etc/GMT-9
  &kZoneAsia_Bangkok, // 0x9d6e3aaf, Asia/Bangkok
  &kZoneAmerica_North_Dakota_Center, // 0x9da42814, America/North_Dakota/Center
  &kZoneAfrica_Ndjamena, // 0x9fe09898, Africa/Ndjamena
  &kZoneAmerica_Guyana, // 0x9ff7bd0b, America/Guyana
  &kZoneAmerica_Havana, // 0xa0e15675, America/Havana
  &kZoneEurope_Kyiv, // 0xa2c1e347, Europe/Kyiv
  &kZoneEurope_Rome, // 0xa2c58fd7, Europe/Rome
  &kZoneAmerica_Inuvik, // 0xa42189fc, America/Inuvik
  &kZoneAmerica_Juneau, // 0xa6f13e2e, America/Juneau
  &kZoneAustralia_Lord_Howe, // 0xa748b67d, Australia/Lord_Howe
  &kZonePacific_Port_Moresby, // 0xa7ba7f68, Pacific/Port_Moresby
  &kZoneAsia_Beirut, // 0xa7f3d5fd, Asia/Beirut
  &kZoneAfrica_Nairobi, // 0xa87ab57e, Africa/Nairobi
  &kZonePacific_Galapagos, // 0xa952f752, Pacific/Galapagos
  &kZoneAmerica_La_Paz, // 0xaa29125d, America/La_Paz
  &kZoneAmerica_Manaus, // 0xac86bf8b, America/Manaus
  &kZoneAmerica_Merida, // 0xacd172d8, America/Merida
  &kZoneEurope_Chisinau, // 0xad58aa18, Europe/Chisinau
  &kZoneAustralia_Broken_Hill, // 0xb06eada3, Australia/Broken_Hill
  &kZoneAmerica_Paramaribo, // 0xb319e4c4, America/Paramaribo
  &kZoneAmerica_Panama, // 0xb3863854, America/Panama
  &kZoneAmerica_Los_Angeles, // 0xb7f7e8f2, America/Los_Angeles
  &kZoneAmerica_Regina, // 0xb875371c, America/Regina
  &kZoneAsia_Ashgabat, // 0xba87598d, Asia/Ashgabat
  &kZoneAmerica_Halifax, // 0xbc5b7183, America/Halifax
  &kZoneAmerica_Tegucigalpa, // 0xbfd6fd4c, America/Tegucigalpa
  &kZoneAsia_Manila, // 0xc156c944, Asia/Manila
  &kZoneAfrica_Abidjan, // 0xc21305a3, Africa/Abidjan
  &kZoneAsia_Jayapura, // 0xc6833c2f, Asia/Jayapura
  &kZoneAmerica_Barbados, // 0xcbbc3b04, America/Barbados
  &kZoneAsia_Riyadh, // 0xcd973d93, Asia/Riyadh
  &kZonePacific_Easter, // 0xcf54f7e7, Pacific/Easter
  &kZoneAsia_Singapore, // 0xcf8581fa, Asia/Singapore
  &kZoneAsia_Taipei, // 0xd1a844ae, Asia/Taipei
  &kZoneAsia_Tehran, // 0xd1f02254, Asia/Tehran
  &kZoneAsia_Urumqi, // 0xd5379735, Asia/Urumqi
  &kZoneAfrica_Johannesburg, // 0xd5d157a0, Africa/Johannesburg
  &kZoneEtc_GMT, // 0xd8e2de58, Etc/GMT
  &kZoneEtc_UTC, // 0xd8e31abc, Etc/UTC
  &kZoneAmerica_Yakutat, // 0xd8ee31e9, America/Yakutat
  &kZoneAfrica_Algiers, // 0xd94515c1, Africa/Algiers
  &kZoneAmerica_Matamoros, // 0xdd1b0259, America/Matamoros
  &kZonePacific_Kanton, // 0xdd512f0e, Pacific/Kanton
  &kZoneAsia_Yangon, // 0xdd54a8be, Asia/Yangon
  &kZonePacific_Kosrae, // 0xde5139a8, Pacific/Kosrae
  &kZoneEurope_Brussels, // 0xdee07337, Europe/Brussels
  &kZoneAmerica_Swift_Current, // 0xdef98e55, America/Swift_Current
  &kZoneAustralia_Lindeman, // 0xe05029e2, Australia/Lindeman
  &kZoneEurope_Belgrade, // 0xe0532b3a, Europe/Belgrade
  &kZoneAmerica_Menominee, // 0xe0e9c583, America/Menominee
  &kZoneAtlantic_Faroe, // 0xe110a971, Atlantic/Faroe
  &kZonePacific_Noumea, // 0xe551b788, Pacific/Noumea
  &kZonePacific_Honolulu, // 0xe6e70af9, Pacific/Honolulu
  &kZonePacific_Tahiti, // 0xf24c2446, Pacific/Tahiti
  &kZonePacific_Tarawa, // 0xf2517e63, Pacific/Tarawa
  &kZoneAsia_Tashkent, // 0xf3924254, Asia/Tashkent
  &kZonePacific_Guadalcanal, // 0xf4dd25f0, Pacific/Guadalcanal
  &kZoneAmerica_Danmarkshavn, // 0xf554d204, America/Danmarkshavn
  &kZoneAsia_Shanghai, // 0xf895a7f5, Asia/Shanghai
  &kZoneEurope_Gibraltar, // 0xf8e325fc, Europe/Gibraltar
  &kZoneAtlantic_Azores, // 0xf93ed918, Atlantic/Azores
  &kZoneAmerica_Montevideo, // 0xfa214780, America/Montevideo
  &kZoneEurope_Malta, // 0xfb1560f3, Europe/Malta
  &kZoneEurope_Bucharest, // 0xfb349ec5, Europe/Bucharest
  &kZoneEurope_Paris, // 0xfb4bc2a3, Europe/Paris
  &kZoneEurope_Sofia, // 0xfb898656, Europe/Sofia
  &kZoneAtlantic_Canary, // 0xfc23f2c2, Atlantic/Canary
  &kZoneAmerica_Campo_Grande, // 0xfec3e7a6, America/Campo_Grande

};

//---------------------------------------------------------------------------
// Zone and Link (fat) Info registry. Sorted by zoneId. Links act like Zones.
//---------------------------------------------------------------------------
const basic::Info::ZoneInfo* const kZoneAndLinkRegistry[446] ACE_TIME_PROGMEM = {
  &kZoneGB, // 0x005973ae, GB -> Europe/London
  &kZoneNZ, // 0x005974ad, NZ -> Pacific/Auckland
  &kZoneAsia_Kuala_Lumpur, // 0x014763c4, Asia/Kuala_Lumpur -> Asia/Singapore
  &kZoneAfrica_Libreville, // 0x01d96de4, Africa/Libreville -> Africa/Lagos
  &kZoneIndian_Cocos, // 0x021e86de, Indian/Cocos -> Asia/Yangon
  &kZoneAustralia_Victoria, // 0x0260d5db, Australia/Victoria -> Australia/Melbourne
  &kZoneAtlantic_Faeroe, // 0x031ec516, Atlantic/Faeroe -> Atlantic/Faroe
  &kZoneAmerica_St_Kitts, // 0x04c0507b, America/St_Kitts -> America/Puerto_Rico
  &kZoneAfrica_Ouagadougou, // 0x04d7219a, Africa/Ouagadougou -> Africa/Abidjan
  &kZoneAmerica_St_Lucia, // 0x04d8b3ba, America/St_Lucia -> America/Puerto_Rico
  &kZoneAsia_Jakarta, // 0x0506ab50, Asia/Jakarta
  &kZoneAfrica_Bujumbura, // 0x05232a47, Africa/Bujumbura -> Africa/Maputo
  &kZoneAmerica_Mazatlan, // 0x0532189e, America/Mazatlan
  &kZoneAmerica_St_Barthelemy, // 0x054e6a79, America/St_Barthelemy -> America/Puerto_Rico
  &kZoneAfrica_Addis_Ababa, // 0x05ae1e65, Africa/Addis_Ababa -> Africa/Nairobi
  &kZoneAmerica_Hermosillo, // 0x065d21c4, America/Hermosillo
  &kZoneMexico_BajaSur, // 0x08ee3641, Mexico/BajaSur -> America/Mazatlan
  &kZoneUS_Hawaii, // 0x09c8de2f, US/Hawaii -> Pacific/Honolulu
  &kZoneCET, // 0x0b87d921, CET -> Europe/Brussels
  &kZoneEET, // 0x0b87e1a3, EET -> Europe/Athens
  &kZoneEST, // 0x0b87e371, EST -> America/Panama
  &kZoneGMT, // 0x0b87eb2d, GMT -> Etc/GMT
  &kZoneHST, // 0x0b87f034, HST -> Pacific/Honolulu
  &kZoneMET, // 0x0b8803ab, MET -> Europe/Brussels
  &kZoneMST, // 0x0b880579, MST -> America/Phoenix
  &kZonePRC, // 0x0b88120a, PRC -> Asia/Shanghai
  &kZoneROC, // 0x0b881a29, ROC -> Asia/Taipei
  &kZoneROK, // 0x0b881a31, ROK -> Asia/Seoul
  &kZoneUCT, // 0x0b882571, UCT -> Etc/UTC
  &kZoneUTC, // 0x0b882791, UTC -> Etc/UTC
  &kZoneWET, // 0x0b882e35, WET -> Europe/Lisbon
  &kZoneAmerica_Guatemala, // 0x0c8259f7, America/Guatemala
  &kZoneEurope_Mariehamn, // 0x0caa6496, Europe/Mariehamn -> Europe/Helsinki
  &kZoneAfrica_Monrovia, // 0x0ce90385, Africa/Monrovia
  &kZoneGMT_PLUS_0, // 0x0d2f7028, GMT+0 -> Etc/GMT
  &kZoneGMT_0, // 0x0d2f706a, GMT-0 -> Etc/GMT
  &kZoneJapan, // 0x0d712f8f, Japan -> Asia/Tokyo
  &kZoneKwajalein, // 0x0e57afbb, Kwajalein -> Pacific/Kwajalein
  &kZoneAntarctica_Rothera, // 0x0e86d203, Antarctica/Rothera
  &kZoneAmerica_Yellowknife, // 0x0f76c76f, America/Yellowknife -> America/Edmonton
  &kZoneAustralia_Melbourne, // 0x0fe559a3, Australia/Melbourne
  &kZoneAmerica_Sao_Paulo, // 0x1063bfc9, America/Sao_Paulo
  &kZoneEurope_Amsterdam, // 0x109395c2, Europe/Amsterdam -> Europe/Brussels
  &kZoneAmerica_Indiana_Vevay, // 0x10aca054, America/Indiana/Vevay
  &kZoneAsia_Samarkand, // 0x13ae5104, Asia/Samarkand
  &kZoneAsia_Dacca, // 0x14bcac5e, Asia/Dacca -> Asia/Dhaka
  &kZoneAsia_Dhaka, // 0x14c07b8b, Asia/Dhaka
  &kZoneAsia_Dubai, // 0x14c79f77, Asia/Dubai
  &kZoneAsia_Kabul, // 0x153b5601, Asia/Kabul
  &kZoneAsia_Ashkhabad, // 0x15454f09, Asia/Ashkhabad -> Asia/Ashgabat
  &kZoneAsia_Macao, // 0x155f88b3, Asia/Macao -> Asia/Macau
  &kZoneAsia_Macau, // 0x155f88b9, Asia/Macau
  &kZoneAsia_Qatar, // 0x15a8330b, Asia/Qatar
  &kZoneAsia_Seoul, // 0x15ce82da, Asia/Seoul
  &kZoneAsia_Tokyo, // 0x15e606a8, Asia/Tokyo
  &kZoneAsia_Tel_Aviv, // 0x166d7c2c, Asia/Tel_Aviv -> Asia/Jerusalem
  &kZoneAsia_Thimphu, // 0x170380d1, Asia/Thimphu
  &kZoneAmerica_Guayaquil, // 0x17e64958, America/Guayaquil
  &kZoneAmerica_Montserrat, // 0x199b0a35, America/Montserrat -> America/Puerto_Rico
  &kZoneAmerica_Kentucky_Louisville, // 0x1a21024b, America/Kentucky/Louisville
  &kZoneAsia_Pontianak, // 0x1a76c057, Asia/Pontianak
  &kZoneEurope_Podgorica, // 0x1c1a499c, Europe/Podgorica -> Europe/Belgrade
  &kZoneAtlantic_Reykjavik, // 0x1c2b4f74, Atlantic/Reykjavik -> Africa/Abidjan
  &kZoneAmerica_New_York, // 0x1e2a7654, America/New_York
  &kZoneEurope_Luxembourg, // 0x1f8bc6ce, Europe/Luxembourg -> Europe/Brussels
  &kZoneAsia_Aden, // 0x1fa7084a, Asia/Aden -> Asia/Riyadh
  &kZoneAsia_Baku, // 0x1fa788b5, Asia/Baku
  &kZoneAsia_Hovd, // 0x1fab0fe3, Asia/Hovd
  &kZoneAmerica_Montreal, // 0x203a1ea8, America/Montreal -> America/Toronto
  &kZoneAsia_Ho_Chi_Minh, // 0x20f2d127, Asia/Ho_Chi_Minh
  &kZonePacific_Fiji, // 0x23383ba5, Pacific/Fiji
  &kZonePacific_Niue, // 0x233ca014, Pacific/Niue
  &kZonePacific_Truk, // 0x234010a9, Pacific/Truk -> Pacific/Port_Moresby
  &kZonePacific_Wake, // 0x23416c2b, Pacific/Wake -> Pacific/Tarawa
  &kZoneAustralia_Adelaide, // 0x2428e8a3, Australia/Adelaide
  &kZonePacific_Auckland, // 0x25062f86, Pacific/Auckland
  &kZonePacific_Tongatapu, // 0x262ca836, Pacific/Tongatapu
  &kZoneAmerica_Monterrey, // 0x269a1deb, America/Monterrey
  &kZoneEtc_Greenwich, // 0x26daa98c, Etc/Greenwich -> Etc/GMT
  &kZoneAustralia_Currie, // 0x278b6a24, Australia/Currie -> Australia/Hobart
  &kZoneAustralia_Darwin, // 0x2876bdff, Australia/Darwin
  &kZonePacific_Pohnpei, // 0x28929f96, Pacific/Pohnpei -> Pacific/Guadalcanal
  &kZoneAmerica_Indiana_Indianapolis, // 0x28a669a4, America/Indiana/Indianapolis
  &kZoneAustralia_Canberra, // 0x2a09ae58, Australia/Canberra -> Australia/Sydney
  &kZoneAmerica_Vancouver, // 0x2c6f6b1f, America/Vancouver
  &kZoneJamaica, // 0x2e44fdab, Jamaica -> America/Jamaica
  &kZonePacific_Chatham, // 0x2f0de999, Pacific/Chatham
  &kZoneEtc_Universal, // 0x2f8cb9a9, Etc/Universal -> Etc/UTC
  &kZoneAmerica_Indiana_Marengo, // 0x2feeee72, America/Indiana/Marengo
  &kZoneAfrica_Djibouti, // 0x30ea01d4, Africa/Djibouti -> Africa/Nairobi
  &kZoneAsia_Ulaanbaatar, // 0x30f0cc4e, Asia/Ulaanbaatar
  &kZoneAfrica_Gaborone, // 0x317c0aa7, Africa/Gaborone -> Africa/Maputo
  &kZoneAsia_Calcutta, // 0x328a44c3, Asia/Calcutta -> Asia/Kolkata
  &kZoneAustralia_Hobart, // 0x32bf951a, Australia/Hobart
  &kZoneAsia_Dushanbe, // 0x32fc5c3c, Asia/Dushanbe
  &kZoneAtlantic_South_Georgia, // 0x33013174, Atlantic/South_Georgia
  &kZoneAmerica_Phoenix, // 0x34b5af01, America/Phoenix
  &kZoneAsia_Ulan_Bator, // 0x394db4d9, Asia/Ulan_Bator -> Asia/Ulaanbaatar
  &kZoneAfrica_Brazzaville, // 0x39cda760, Africa/Brazzaville -> Africa/Lagos
  &kZoneAmerica_Cayenne, // 0x3c617269, America/Cayenne
  &kZoneAfrica_Porto_Novo, // 0x3d1bf95d, Africa/Porto-Novo -> Africa/Lagos
  &kZoneAtlantic_Bermuda, // 0x3d4bb1c4, Atlantic/Bermuda
  &kZoneAmerica_Managua, // 0x3d5e7600, America/Managua
  &kZoneAmerica_Marigot, // 0x3dab3a59, America/Marigot -> America/Puerto_Rico
  &kZoneEurope_Guernsey, // 0x3db12c16, Europe/Guernsey -> Europe/London
  &kZoneAfrica_Nouakchott, // 0x3dc49dba, Africa/Nouakchott -> Africa/Abidjan
  &kZoneAmerica_Louisville, // 0x3dcb47ee, America/Louisville -> America/Kentucky/Louisville
  &kZoneEtc_GMT_PLUS_10, // 0x3f8f1cc4, Etc/GMT+10
  &kZoneEtc_GMT_PLUS_11, // 0x3f8f1cc5, Etc/GMT+11
  &kZoneEtc_GMT_PLUS_12, // 0x3f8f1cc6, Etc/GMT+12
  &kZoneEtc_GMT_10, // 0x3f8f2546, Etc/GMT-10
  &kZoneEtc_GMT_11, // 0x3f8f2547, Etc/GMT-11
  &kZoneEtc_GMT_12, // 0x3f8f2548, Etc/GMT-12
  &kZoneEtc_GMT_13, // 0x3f8f2549, Etc/GMT-13
  &kZoneEtc_GMT_14, // 0x3f8f254a, Etc/GMT-14
  &kZoneCanada_Pacific, // 0x40fa3c7b, Canada/Pacific -> America/Vancouver
  &kZoneEurope_Athens, // 0x4318fa27, Europe/Athens
  &kZoneIndian_Kerguelen, // 0x4351b389, Indian/Kerguelen -> Indian/Maldives
  &kZoneEurope_Berlin, // 0x44644c20, Europe/Berlin
  &kZoneAtlantic_St_Helena, // 0x451fc5f7, Atlantic/St_Helena -> Africa/Abidjan
  &kZoneIndian_Chagos, // 0x456f7c3c, Indian/Chagos
  &kZoneIndian_Mahe, // 0x45e725e2, Indian/Mahe -> Asia/Dubai
  &kZoneIndian_Comoro, // 0x45f4deb6, Indian/Comoro -> Africa/Nairobi
  &kZoneEurope_Dublin, // 0x4a275f62, Europe/Dublin
  &kZoneAsia_Nicosia, // 0x4b0fcf78, Asia/Nicosia
  &kZoneAmerica_Chicago, // 0x4b92b5d4, America/Chicago
  &kZoneAustralia_Sydney, // 0x4d1e9776, Australia/Sydney
  &kZoneNZ_CHAT, // 0x4d42afda, NZ-CHAT -> Pacific/Chatham
  &kZoneUS_Arizona, // 0x4ec52670, US/Arizona -> America/Phoenix
  &kZoneUS_Aleutian, // 0x4fe013ef, US/Aleutian -> America/Adak
  &kZoneAustralia_Brisbane, // 0x4fedc9c0, Australia/Brisbane
  &kZoneAsia_Karachi, // 0x527f5245, Asia/Karachi
  &kZoneAsia_Kashgar, // 0x52955193, Asia/Kashgar -> Asia/Urumqi
  &kZoneCanada_Atlantic, // 0x536b119c, Canada/Atlantic -> America/Halifax
  &kZonePacific_Gambier, // 0x53720c3a, Pacific/Gambier
  &kZoneAmerica_Martinique, // 0x551e84c5, America/Martinique
  &kZoneAmerica_Jamaica, // 0x565dad6c, America/Jamaica
  &kZoneUS_Samoa, // 0x566821cd, US/Samoa -> Pacific/Pago_Pago
  &kZoneHongkong, // 0x56d36560, Hongkong -> Asia/Hong_Kong
  &kZoneEurope_Jersey, // 0x570dae76, Europe/Jersey -> Europe/London
  &kZoneAsia_Hong_Kong, // 0x577f28ac, Asia/Hong_Kong
  &kZonePacific_Marquesas, // 0x57ca7135, Pacific/Marquesas
  &kZoneAmerica_Miquelon, // 0x59674330, America/Miquelon
  &kZoneAntarctica_DumontDUrville, // 0x5a3c656c, Antarctica/DumontDUrville -> Pacific/Port_Moresby
  &kZoneAtlantic_Jan_Mayen, // 0x5a7535b6, Atlantic/Jan_Mayen -> Europe/Berlin
  &kZoneAmerica_Anchorage, // 0x5a79260e, America/Anchorage
  &kZoneUS_Eastern, // 0x5bb7e78e, US/Eastern -> America/New_York
  &kZoneAsia_Jerusalem, // 0x5becd23a, Asia/Jerusalem
  &kZoneEurope_Stockholm, // 0x5bf6fbb8, Europe/Stockholm -> Europe/Berlin
  &kZoneEurope_Lisbon, // 0x5c00a70b, Europe/Lisbon
  &kZoneAtlantic_Cape_Verde, // 0x5c5e1772, Atlantic/Cape_Verde
  &kZoneEurope_London, // 0x5c6a84ae, Europe/London
  &kZoneAsia_Ujung_Pandang, // 0x5d001eb3, Asia/Ujung_Pandang -> Asia/Makassar
  &kZoneAfrica_Mbabane, // 0x5d3bdd40, Africa/Mbabane -> Africa/Johannesburg
  &kZoneEurope_Madrid, // 0x5dbd1535, Europe/Madrid
  &kZoneAmerica_Moncton, // 0x5e07fe24, America/Moncton
  &kZoneEurope_Monaco, // 0x5ebf9f01, Europe/Monaco -> Europe/Paris
  &kZonePacific_Pago_Pago, // 0x603aebd0, Pacific/Pago_Pago
  &kZonePacific_Enderbury, // 0x61599a93, Pacific/Enderbury -> Pacific/Kanton
  &kZoneCanada_Central, // 0x626710f5, Canada/Central -> America/Winnipeg
  &kZoneAmerica_Creston, // 0x62a70204, America/Creston -> America/Phoenix
  &kZoneAmerica_Costa_Rica, // 0x63ff66be, America/Costa_Rica
  &kZoneEurope_Prague, // 0x65ee5d48, Europe/Prague
  &kZoneBrazil_East, // 0x669578c5, Brazil/East -> America/Sao_Paulo
  &kZoneAfrica_Kinshasa, // 0x6695d70c, Africa/Kinshasa -> Africa/Lagos
  &kZoneBrazil_West, // 0x669f689b, Brazil/West -> America/Manaus
  &kZoneAfrica_Mogadishu, // 0x66bc159b, Africa/Mogadishu -> Africa/Nairobi
  &kZoneAmerica_Puerto_Rico, // 0x6752ca31, America/Puerto_Rico
  &kZoneAfrica_Freetown, // 0x6823dd64, Africa/Freetown -> Africa/Abidjan
  &kZoneIndian_Christmas, // 0x68c207d5, Indian/Christmas -> Asia/Bangkok
  &kZoneAmerica_Indianapolis, // 0x6a009ae1, America/Indianapolis -> America/Indiana/Indianapolis
  &kZoneEurope_Sarajevo, // 0x6a576c3f, Europe/Sarajevo -> Europe/Belgrade
  &kZoneAmerica_Curacao, // 0x6a879184, America/Curacao -> America/Puerto_Rico
  &kZoneAsia_Makassar, // 0x6aa21c85, Asia/Makassar
  &kZoneEurope_Helsinki, // 0x6ab2975b, Europe/Helsinki
  &kZoneAmerica_Lower_Princes, // 0x6ae45b62, America/Lower_Princes -> America/Puerto_Rico
  &kZoneAmerica_Porto_Velho, // 0x6b1aac77, America/Porto_Velho
  &kZoneEurope_Skopje, // 0x6c76fdd0, Europe/Skopje -> Europe/Belgrade
  &kZoneAmerica_Edmonton, // 0x6cb9484a, America/Edmonton
  &kZoneAmerica_Dawson_Creek, // 0x6cf24e5b, America/Dawson_Creek
  &kZoneAsia_Rangoon, // 0x6d1217c6, Asia/Rangoon -> Asia/Yangon
  &kZoneUS_East_Indiana, // 0x6dcf558a, US/East-Indiana -> America/Indiana/Indianapolis
  &kZoneAmerica_Blanc_Sablon, // 0x6e299892, America/Blanc-Sablon -> America/Puerto_Rico
  &kZoneEurope_Tirane, // 0x6ea95b47, Europe/Tirane
  &kZoneUS_Mountain, // 0x6eb88247, US/Mountain -> America/Denver
  &kZoneAntarctica_McMurdo, // 0x6eeb5585, Antarctica/McMurdo -> Pacific/Auckland
  &kZoneAfrica_Lubumbashi, // 0x6fd88566, Africa/Lubumbashi -> Africa/Maputo
  &kZoneIndian_Reunion, // 0x7076c047, Indian/Reunion -> Asia/Dubai
  &kZoneAsia_Kolkata, // 0x72c06cd9, Asia/Kolkata
  &kZoneEurope_Vienna, // 0x734cc2e5, Europe/Vienna
  &kZoneAfrica_Asmara, // 0x73b278ef, Africa/Asmara -> Africa/Nairobi
  &kZoneAfrica_Asmera, // 0x73b289f3, Africa/Asmera -> Africa/Nairobi
  &kZoneAmerica_Santiago, // 0x7410c9bc, America/Santiago
  &kZoneAfrica_Bamako, // 0x74c1e7a5, Africa/Bamako -> Africa/Abidjan
  &kZoneAfrica_Bangui, // 0x74c28ed0, Africa/Bangui -> Africa/Lagos
  &kZoneAfrica_Banjul, // 0x74c29b96, Africa/Banjul -> Africa/Abidjan
  &kZoneEurope_Nicosia, // 0x74efab8a, Europe/Nicosia -> Asia/Nicosia
  &kZoneEurope_Warsaw, // 0x75185c19, Europe/Warsaw
  &kZoneAmerica_El_Salvador, // 0x752ad652, America/El_Salvador
  &kZoneAfrica_Bissau, // 0x75564141, Africa/Bissau
  &kZoneUS_Michigan, // 0x766bb7bc, US/Michigan -> America/Detroit
  &kZoneCanada_Saskatchewan, // 0x77311f49, Canada/Saskatchewan -> America/Regina
  &kZoneAfrica_Accra, // 0x77d5b054, Africa/Accra -> Africa/Abidjan
  &kZoneAfrica_Ceuta, // 0x77fb46ec, Africa/Ceuta
  &kZoneAfrica_Dakar, // 0x780b00fd, Africa/Dakar -> Africa/Abidjan
  &kZoneAfrica_Lagos, // 0x789bb5d0, Africa/Lagos
  &kZoneAfrica_Windhoek, // 0x789c9bd3, Africa/Windhoek
  &kZoneAmerica_Toronto, // 0x792e851b, America/Toronto
  &kZoneAmerica_Tortola, // 0x7931462b, America/Tortola -> America/Puerto_Rico
  &kZoneAfrica_Tunis, // 0x79378e6d, Africa/Tunis
  &kZoneAfrica_Douala, // 0x7a6df310, Africa/Douala -> Africa/Lagos
  &kZoneAfrica_Conakry, // 0x7ab36b31, Africa/Conakry -> Africa/Abidjan
  &kZoneIndian_Mauritius, // 0x7b09c02a, Indian/Mauritius
  &kZoneEurope_Zagreb, // 0x7c11c9ff, Europe/Zagreb -> Europe/Belgrade
  &kZoneCuba, // 0x7c83cba0, Cuba -> America/Havana
  &kZoneEire, // 0x7c84b36a, Eire -> Europe/Dublin
  &kZoneGMT0, // 0x7c8550fd, GMT0 -> Etc/GMT
  &kZoneIran, // 0x7c87090f, Iran -> Asia/Tehran
  &kZoneZulu, // 0x7c9069b5, Zulu -> Etc/UTC
  &kZoneEurope_Zurich, // 0x7d8195b9, Europe/Zurich
  &kZoneChile_Continental, // 0x7e2bdb18, Chile/Continental -> America/Santiago
  &kZoneAmerica_Fort_Wayne, // 0x7eaaaf24, America/Fort_Wayne -> America/Indiana/Indianapolis
  &kZoneAsia_Kuching, // 0x801b003b, Asia/Kuching
  &kZoneAtlantic_Madeira, // 0x81b5c037, Atlantic/Madeira
  &kZoneAmerica_Atikokan, // 0x81b92098, America/Atikokan -> America/Panama
  &kZoneAfrica_Harare, // 0x82c39a2d, Africa/Harare -> Africa/Maputo
  &kZoneAmerica_Shiprock, // 0x82fb7049, America/Shiprock -> America/Denver
  &kZonePacific_Kiritimati, // 0x8305073a, Pacific/Kiritimati
  &kZoneAmerica_St_Vincent, // 0x8460e523, America/St_Vincent -> America/Puerto_Rico
  &kZonePacific_Pitcairn, // 0x8837d8bd, Pacific/Pitcairn
  &kZoneAsia_Vientiane, // 0x89d68d75, Asia/Vientiane -> Asia/Bangkok
  &kZonePacific_Chuuk, // 0x8a090b23, Pacific/Chuuk -> Pacific/Port_Moresby
  &kZonePacific_Efate, // 0x8a2bce28, Pacific/Efate
  &kZoneAfrica_Kigali, // 0x8a4dcf2b, Africa/Kigali -> Africa/Maputo
  &kZoneAustralia_ACT, // 0x8a970eb2, Australia/ACT -> Australia/Sydney
  &kZoneAustralia_LHI, // 0x8a973e17, Australia/LHI -> Australia/Lord_Howe
  &kZoneAustralia_NSW, // 0x8a974812, Australia/NSW -> Australia/Sydney
  &kZonePacific_Nauru, // 0x8acc41ae, Pacific/Nauru
  &kZoneEST5EDT, // 0x8adc72a3, EST5EDT -> America/New_York
  &kZonePacific_Palau, // 0x8af04a36, Pacific/Palau
  &kZonePacific_Samoa, // 0x8b2699b4, Pacific/Samoa -> Pacific/Pago_Pago
  &kZoneAmerica_Winnipeg, // 0x8c7dafc7, America/Winnipeg
  &kZoneAustralia_Eucla, // 0x8cf99e44, Australia/Eucla
  &kZoneAfrica_Luanda, // 0x8d7909cf, Africa/Luanda -> Africa/Lagos
  &kZoneAfrica_Lusaka, // 0x8d82b23b, Africa/Lusaka -> Africa/Maputo
  &kZoneAustralia_North, // 0x8d997165, Australia/North -> Australia/Darwin
  &kZoneAustralia_Perth, // 0x8db8269d, Australia/Perth
  &kZoneAustralia_South, // 0x8df3f8ad, Australia/South -> Australia/Adelaide
  &kZonePacific_Kwajalein, // 0x8e216759, Pacific/Kwajalein
  &kZoneAmerica_Port_au_Prince, // 0x8e4a7bdc, America/Port-au-Prince
  &kZoneAfrica_Malabo, // 0x8e6a1906, Africa/Malabo -> Africa/Lagos
  &kZoneAfrica_Maputo, // 0x8e6ca1f0, Africa/Maputo
  &kZoneAfrica_Maseru, // 0x8e6e02c7, Africa/Maseru -> Africa/Johannesburg
  &kZoneAustralia_Yancowinna, // 0x90bac131, Australia/Yancowinna -> Australia/Broken_Hill
  &kZoneAfrica_Niamey, // 0x914a30fd, Africa/Niamey -> Africa/Lagos
  &kZoneAsia_Yerevan, // 0x9185c8cc, Asia/Yerevan
  &kZoneAmerica_Detroit, // 0x925cfbc1, America/Detroit
  &kZoneAsia_Choibalsan, // 0x928aa4a6, Asia/Choibalsan -> Asia/Ulaanbaatar
  &kZoneAmerica_Belize, // 0x93256c81, America/Belize
  &kZoneAmerica_Bogota, // 0x93d7bc62, America/Bogota
  &kZoneAmerica_Cayman, // 0x953961df, America/Cayman -> America/Panama
  &kZoneAmerica_Glace_Bay, // 0x9681f8dd, America/Glace_Bay
  &kZoneAmerica_Grenada, // 0x968ce4d8, America/Grenada -> America/Puerto_Rico
  &kZoneAmerica_Aruba, // 0x97cf8651, America/Aruba -> America/Puerto_Rico
  &kZoneAmerica_Denver, // 0x97d10b2a, America/Denver
  &kZoneAmerica_Belem, // 0x97da580b, America/Belem
  &kZoneAmerica_Boise, // 0x97dfc8d8, America/Boise
  &kZoneEurope_Andorra, // 0x97f6764b, Europe/Andorra
  &kZoneAmerica_Adak, // 0x97fe49d7, America/Adak
  &kZoneAmerica_Atka, // 0x97fe8f27, America/Atka -> America/Adak
  &kZoneAmerica_Lima, // 0x980468c9, America/Lima
  &kZoneAmerica_Nome, // 0x98059b15, America/Nome
  &kZoneIndian_Maldives, // 0x9869681c, Indian/Maldives
  &kZoneAmerica_Sitka, // 0x99104ce2, America/Sitka
  &kZoneAmerica_Thule, // 0x9921dd68, America/Thule
  &kZonePacific_Rarotonga, // 0x9981a3b0, Pacific/Rarotonga
  &kZoneAsia_Kathmandu, // 0x9a96ce6f, Asia/Kathmandu
  &kZoneAmerica_Rainy_River, // 0x9cd58a10, America/Rainy_River -> America/Winnipeg
  &kZoneEurope_Budapest, // 0x9ce0197c, Europe/Budapest
  &kZoneAsia_Baghdad, // 0x9ceffbed, Asia/Baghdad
  &kZoneAsia_Bahrain, // 0x9d078487, Asia/Bahrain -> Asia/Qatar
  &kZoneEtc_GMT_PLUS_0, // 0x9d13da13, Etc/GMT+0 -> Etc/GMT
  &kZoneEtc_GMT_PLUS_1, // 0x9d13da14, Etc/GMT+1
  &kZoneEtc_GMT_PLUS_2, // 0x9d13da15, Etc/GMT+2
  &kZoneEtc_GMT_PLUS_3, // 0x9d13da16, Etc/GMT+3
  &kZoneEtc_GMT_PLUS_4, // 0x9d13da17, Etc/GMT+4
  &kZoneEtc_GMT_PLUS_5, // 0x9d13da18, Etc/GMT+5
  &kZoneEtc_GMT_PLUS_6, // 0x9d13da19, Etc/GMT+6
  &kZoneEtc_GMT_PLUS_7, // 0x9d13da1a, Etc/GMT+7
  &kZoneEtc_GMT_PLUS_8, // 0x9d13da1b, Etc/GMT+8
  &kZoneEtc_GMT_PLUS_9, // 0x9d13da1c, Etc/GMT+9
  &kZoneEtc_GMT_0, // 0x9d13da55, Etc/GMT-0 -> Etc/GMT
  &kZoneEtc_GMT_1, // 0x9d13da56, Etc/GMT-1
  &kZoneEtc_GMT_2, // 0x9d13da57, Etc/GMT-2
  &kZoneEtc_GMT_3, // 0x9d13da58, Etc/GMT-3
  &kZoneEtc_GMT_4, // 0x9d13da59, Etc/GMT-4
  &kZoneEtc_GMT_5, // 0x9d13da5a, Etc/GMT-5
  &kZoneEtc_GMT_6, // 0x9d13da5b, Etc/GMT-6
  &kZoneEtc_GMT_7, // 0x9d13da5c, Etc/GMT-7
  &kZoneEtc_GMT_8, // 0x9d13da5d, Etc/GMT-8
  &kZoneEtc_GMT_9, // 0x9d13da5e, Etc/GMT-9
  &kZoneAmerica_Nipigon, // 0x9d2a8b1a, America/Nipigon -> America/Toronto
  &kZoneAsia_Bangkok, // 0x9d6e3aaf, Asia/Bangkok
  &kZoneAmerica_North_Dakota_Center, // 0x9da42814, America/North_Dakota/Center
  &kZoneIndian_Antananarivo, // 0x9ebf5289, Indian/Antananarivo -> Africa/Nairobi
  &kZoneAfrica_Ndjamena, // 0x9fe09898, Africa/Ndjamena
  &kZoneAmerica_Guyana, // 0x9ff7bd0b, America/Guyana
  &kZoneAfrica_Dar_es_Salaam, // 0xa04c47b6, Africa/Dar_es_Salaam -> Africa/Nairobi
  &kZoneAmerica_Havana, // 0xa0e15675, America/Havana
  &kZoneEurope_Kiev, // 0xa2c19eb3, Europe/Kiev -> Europe/Kyiv
  &kZoneEurope_Kyiv, // 0xa2c1e347, Europe/Kyiv
  &kZoneEurope_Oslo, // 0xa2c3fba1, Europe/Oslo -> Europe/Berlin
  &kZoneEurope_Rome, // 0xa2c58fd7, Europe/Rome
  &kZoneAmerica_Inuvik, // 0xa42189fc, America/Inuvik
  &kZoneAmerica_Juneau, // 0xa6f13e2e, America/Juneau
  &kZoneAustralia_Lord_Howe, // 0xa748b67d, Australia/Lord_Howe
  &kZonePacific_Port_Moresby, // 0xa7ba7f68, Pacific/Port_Moresby
  &kZoneAsia_Katmandu, // 0xa7ec12c7, Asia/Katmandu -> Asia/Kathmandu
  &kZoneAsia_Beirut, // 0xa7f3d5fd, Asia/Beirut
  &kZoneSingapore, // 0xa8598c8d, Singapore -> Asia/Singapore
  &kZoneAfrica_Nairobi, // 0xa87ab57e, Africa/Nairobi
  &kZoneAsia_Brunei, // 0xa8e595f7, Asia/Brunei -> Asia/Kuching
  &kZoneUS_Pacific, // 0xa950f6ab, US/Pacific -> America/Los_Angeles
  &kZonePacific_Galapagos, // 0xa952f752, Pacific/Galapagos
  &kZoneAmerica_La_Paz, // 0xaa29125d, America/La_Paz
  &kZoneAmerica_Coral_Harbour, // 0xabcb7569, America/Coral_Harbour -> America/Panama
  &kZoneAmerica_Manaus, // 0xac86bf8b, America/Manaus
  &kZoneAmerica_Merida, // 0xacd172d8, America/Merida
  &kZoneEurope_Chisinau, // 0xad58aa18, Europe/Chisinau
  &kZoneAmerica_Nassau, // 0xaedef011, America/Nassau -> America/Toronto
  &kZoneAmerica_Anguilla, // 0xafe31333, America/Anguilla -> America/Puerto_Rico
  &kZoneEurope_Uzhgorod, // 0xb066f5d6, Europe/Uzhgorod -> Europe/Kyiv
  &kZoneAustralia_Broken_Hill, // 0xb06eada3, Australia/Broken_Hill
  &kZoneChile_EasterIsland, // 0xb0982af8, Chile/EasterIsland -> Pacific/Easter
  &kZonePacific_Johnston, // 0xb15d7b36, Pacific/Johnston -> Pacific/Honolulu
  &kZoneAfrica_Timbuktu, // 0xb164d56f, Africa/Timbuktu -> Africa/Abidjan
  &kZoneAmerica_St_Thomas, // 0xb1b3d778, America/St_Thomas -> America/Puerto_Rico
  &kZoneAmerica_Paramaribo, // 0xb319e4c4, America/Paramaribo
  &kZoneAmerica_Panama, // 0xb3863854, America/Panama
  &kZoneAsia_Harbin, // 0xb5af1186, Asia/Harbin -> Asia/Shanghai
  &kZoneAmerica_Los_Angeles, // 0xb7f7e8f2, America/Los_Angeles
  &kZoneAmerica_Regina, // 0xb875371c, America/Regina
  &kZoneAsia_Ashgabat, // 0xba87598d, Asia/Ashgabat
  &kZoneIsrael, // 0xba88c9e5, Israel -> Asia/Jerusalem
  &kZonePacific_Yap, // 0xbb40138d, Pacific/Yap -> Pacific/Port_Moresby
  &kZoneAmerica_Halifax, // 0xbc5b7183, America/Halifax
  &kZoneEurope_Ljubljana, // 0xbd98cdb7, Europe/Ljubljana -> Europe/Belgrade
  &kZoneAsia_Kuwait, // 0xbe1b2f27, Asia/Kuwait -> Asia/Riyadh
  &kZoneEurope_Tiraspol, // 0xbe704472, Europe/Tiraspol -> Europe/Chisinau
  &kZoneAmerica_Tegucigalpa, // 0xbfd6fd4c, America/Tegucigalpa
  &kZoneAmerica_Antigua, // 0xc067a32f, America/Antigua -> America/Puerto_Rico
  &kZoneEurope_Busingen, // 0xc06d2cdf, Europe/Busingen -> Europe/Zurich
  &kZoneAsia_Manila, // 0xc156c944, Asia/Manila
  &kZoneAfrica_Kampala, // 0xc1d30e31, Africa/Kampala -> Africa/Nairobi
  &kZoneAfrica_Abidjan, // 0xc21305a3, Africa/Abidjan
  &kZoneAmerica_Virgin, // 0xc2183ab5, America/Virgin -> America/Puerto_Rico
  &kZoneAsia_Phnom_Penh, // 0xc224945e, Asia/Phnom_Penh -> Asia/Bangkok
  &kZoneAsia_Muscat, // 0xc2c3565f, Asia/Muscat -> Asia/Dubai
  &kZonePortugal, // 0xc3274593, Portugal -> Europe/Lisbon
  &kZoneNavajo, // 0xc4ef0e24, Navajo -> America/Denver
  &kZoneAsia_Jayapura, // 0xc6833c2f, Asia/Jayapura
  &kZoneAsia_Chungking, // 0xc7121dd0, Asia/Chungking -> Asia/Shanghai
  &kZoneGreenwich, // 0xc84d4221, Greenwich -> Etc/GMT
  &kZonePoland, // 0xca913b23, Poland -> Europe/Warsaw
  &kZoneUS_Central, // 0xcabdcb25, US/Central -> America/Chicago
  &kZoneEurope_Vatican, // 0xcb485dca, Europe/Vatican -> Europe/Rome
  &kZoneAmerica_Barbados, // 0xcbbc3b04, America/Barbados
  &kZoneAmerica_Guadeloupe, // 0xcd1f8a31, America/Guadeloupe -> America/Puerto_Rico
  &kZoneAntarctica_South_Pole, // 0xcd96b290, Antarctica/South_Pole -> Pacific/Auckland
  &kZoneAsia_Riyadh, // 0xcd973d93, Asia/Riyadh
  &kZoneAmerica_Dominica, // 0xcecb4c4a, America/Dominica -> America/Puerto_Rico
  &kZoneEurope_San_Marino, // 0xcef7724b, Europe/San_Marino -> Europe/Rome
  &kZoneAsia_Saigon, // 0xcf52f713, Asia/Saigon -> Asia/Ho_Chi_Minh
  &kZonePacific_Easter, // 0xcf54f7e7, Pacific/Easter
  &kZoneAsia_Singapore, // 0xcf8581fa, Asia/Singapore
  &kZoneEurope_Belfast, // 0xd07dd1e5, Europe/Belfast -> Europe/London
  &kZoneUniversal, // 0xd0ff523e, Universal -> Etc/UTC
  &kZoneAsia_Taipei, // 0xd1a844ae, Asia/Taipei
  &kZoneAsia_Tehran, // 0xd1f02254, Asia/Tehran
  &kZoneAsia_Thimbu, // 0xd226e31b, Asia/Thimbu -> Asia/Thimphu
  &kZoneArctic_Longyearbyen, // 0xd23e7859, Arctic/Longyearbyen -> Europe/Berlin
  &kZoneAustralia_Queensland, // 0xd326ed0a, Australia/Queensland -> Australia/Brisbane
  &kZoneAfrica_Lome, // 0xd51c3a07, Africa/Lome -> Africa/Abidjan
  &kZoneAsia_Urumqi, // 0xd5379735, Asia/Urumqi
  &kZoneAfrica_Johannesburg, // 0xd5d157a0, Africa/Johannesburg
  &kZoneAmerica_Port_of_Spain, // 0xd8b28d59, America/Port_of_Spain -> America/Puerto_Rico
  &kZoneEtc_GMT, // 0xd8e2de58, Etc/GMT
  &kZoneEtc_UCT, // 0xd8e3189c, Etc/UCT -> Etc/UTC
  &kZoneEtc_UTC, // 0xd8e31abc, Etc/UTC
  &kZoneAmerica_Yakutat, // 0xd8ee31e9, America/Yakutat
  &kZoneAfrica_Algiers, // 0xd94515c1, Africa/Algiers
  &kZonePST8PDT, // 0xd99ee2dc, PST8PDT -> America/Los_Angeles
  &kZoneEurope_Bratislava, // 0xda493bed, Europe/Bratislava -> Europe/Prague
  &kZonePacific_Funafuti, // 0xdb402d65, Pacific/Funafuti -> Pacific/Tarawa
  &kZoneAmerica_Matamoros, // 0xdd1b0259, America/Matamoros
  &kZonePacific_Kanton, // 0xdd512f0e, Pacific/Kanton
  &kZoneAsia_Yangon, // 0xdd54a8be, Asia/Yangon
  &kZoneAustralia_West, // 0xdd858a5d, Australia/West -> Australia/Perth
  &kZonePacific_Kosrae, // 0xde5139a8, Pacific/Kosrae
  &kZoneEurope_Brussels, // 0xdee07337, Europe/Brussels
  &kZoneAmerica_Swift_Current, // 0xdef98e55, America/Swift_Current
  &kZoneAustralia_Lindeman, // 0xe05029e2, Australia/Lindeman
  &kZoneEurope_Belgrade, // 0xe0532b3a, Europe/Belgrade
  &kZoneAfrica_Blantyre, // 0xe08d813b, Africa/Blantyre -> Africa/Maputo
  &kZoneAmerica_Menominee, // 0xe0e9c583, America/Menominee
  &kZoneEurope_Copenhagen, // 0xe0ed30bc, Europe/Copenhagen -> Europe/Berlin
  &kZoneAtlantic_Faroe, // 0xe110a971, Atlantic/Faroe
  &kZonePacific_Majuro, // 0xe1f95371, Pacific/Majuro -> Pacific/Tarawa
  &kZonePacific_Midway, // 0xe286d38e, Pacific/Midway -> Pacific/Pago_Pago
  &kZoneAntarctica_Syowa, // 0xe330c7e1, Antarctica/Syowa -> Asia/Riyadh
  &kZonePacific_Noumea, // 0xe551b788, Pacific/Noumea
  &kZoneIceland, // 0xe56a35b5, Iceland -> Africa/Abidjan
  &kZoneIndian_Mayotte, // 0xe6880bca, Indian/Mayotte -> Africa/Nairobi
  &kZoneAustralia_Tasmania, // 0xe6d76648, Australia/Tasmania -> Australia/Hobart
  &kZonePacific_Honolulu, // 0xe6e70af9, Pacific/Honolulu
  &kZoneAmerica_Kralendijk, // 0xe7c456c5, America/Kralendijk -> America/Puerto_Rico
  &kZonePacific_Ponape, // 0xe9f80086, Pacific/Ponape -> Pacific/Guadalcanal
  &kZoneEurope_Zaporozhye, // 0xeab9767f, Europe/Zaporozhye -> Europe/Kyiv
  &kZoneEurope_Isle_of_Man, // 0xeaf84580, Europe/Isle_of_Man -> Europe/London
  &kZoneCST6CDT, // 0xf0e87d00, CST6CDT -> America/Chicago
  &kZonePacific_Tahiti, // 0xf24c2446, Pacific/Tahiti
  &kZonePacific_Tarawa, // 0xf2517e63, Pacific/Tarawa
  &kZoneMST7MDT, // 0xf2af9375, MST7MDT -> America/Denver
  &kZoneCanada_Eastern, // 0xf3612d5e, Canada/Eastern -> America/Toronto
  &kZoneAsia_Tashkent, // 0xf3924254, Asia/Tashkent
  &kZonePacific_Guadalcanal, // 0xf4dd25f0, Pacific/Guadalcanal
  &kZoneEtc_GMT0, // 0xf53ea988, Etc/GMT0 -> Etc/GMT
  &kZoneEtc_Zulu, // 0xf549c240, Etc/Zulu -> Etc/UTC
  &kZoneAmerica_Danmarkshavn, // 0xf554d204, America/Danmarkshavn
  &kZoneAsia_Shanghai, // 0xf895a7f5, Asia/Shanghai
  &kZoneEurope_Gibraltar, // 0xf8e325fc, Europe/Gibraltar
  &kZoneAsia_Chongqing, // 0xf937fb90, Asia/Chongqing -> Asia/Shanghai
  &kZoneAtlantic_Azores, // 0xf93ed918, Atlantic/Azores
  &kZonePacific_Wallis, // 0xf94ddb0f, Pacific/Wallis -> Pacific/Tarawa
  &kZoneAmerica_Thunder_Bay, // 0xf962e71b, America/Thunder_Bay -> America/Toronto
  &kZoneAmerica_Montevideo, // 0xfa214780, America/Montevideo
  &kZoneUS_Alaska, // 0xfa300bc9, US/Alaska -> America/Anchorage
  &kZoneGB_Eire, // 0xfa70e300, GB-Eire -> Europe/London
  &kZoneEurope_Malta, // 0xfb1560f3, Europe/Malta
  &kZoneEurope_Bucharest, // 0xfb349ec5, Europe/Bucharest
  &kZoneEurope_Paris, // 0xfb4bc2a3, Europe/Paris
  &kZoneEurope_Sofia, // 0xfb898656, Europe/Sofia
  &kZoneCanada_Mountain, // 0xfb8a8217, Canada/Mountain -> America/Edmonton
  &kZoneEurope_Vaduz, // 0xfbb81bae, Europe/Vaduz -> Europe/Zurich
  &kZoneAtlantic_Canary, // 0xfc23f2c2, Atlantic/Canary
  &kZoneAmerica_Campo_Grande, // 0xfec3e7a6, America/Campo_Grande

};

}
}
