#!/usr/bin/gawk -f
#
# Usage: generate_table.awk < ${board}.txt
#
# Takes the *.txt file generated by AutoBenchmark.ino and generates an ASCII
# table that can be inserted into the README.md. Collects both sizeof()
# information as well as CPU benchmarks.

BEGIN {
  # Set to 1 when 'BENCHMARKS' is detected
  collect_benchmarks = 0
}

/^BENCHMARKS/ {
  collect_benchmarks = 1
  benchmark_index = 0
  next
}

!/^END/ {
  if (collect_benchmarks) {
    u[benchmark_index]["name"] = $1
    u[benchmark_index]["micros"] = $2
    benchmark_index++
  }
}

END {
  TOTAL_BENCHMARKS = benchmark_index

  printf("Sizes of Objects:\n")
  for (i = 0; i < TOTAL_SIZEOF; i++) {
    print s[i]
  }


  print ""
  print "CPU:"

  printf("+----------------------------------------+----------+\n")
  printf("| Method                                 |   micros |\n")

  for (i = 0; i < TOTAL_BENCHMARKS - 2; i++) {
    name = u[i]["name"]
    if (name ~ /^EmptyLoop/ \
        || name ~ /^LocalDateTime::forEpochSeconds\(\)/ \
        || name ~ /^LocalDateTime::toEpochSeconds\(\)/) {
      printf("|----------------------------------------+----------|\n")
    }
    printf("| %-38s | %8.3f |\n", name, u[i]["micros"])
  }
  printf("+----------------------------------------+----------+\n")
  printf("%s: %d\n", u[i]["name"], u[i]["micros"])
  printf("%s: %d\n", u[i+1]["name"], u[i]["micros"])
}
