// This file was generated by the following script:
//
//   $ /home/brian/src/AceTimeTools/src/acetimetools/tzcompiler.py
//     --input_dir /home/brian/src/AceTime/src/zonedbxtesting/tzfiles
//     --output_dir /home/brian/src/AceTime/src/zonedbxtesting
//     --tz_version 2024b
//     --action zonedb
//     --language arduino
//     --scope extended
//     --db_namespace zonedbxtesting
//     --include_list include_list.txt
//     --nocompress
//     --start_year 1980
//     --until_year 2200
//
// using the TZ Database files
//
//   africa
//   antarctica
//   asia
//   australasia
//   backward
//   etcetera
//   europe
//   northamerica
//   southamerica
//
// from https://github.com/eggert/tz/releases/tag/2024b
//
// Supported Zones: 16 (15 zones, 1 links)
// Unsupported Zones: 580 (324 zones, 256 links)
//
// Requested Years: [1980,2200]
// Accurate Years: [1980,32767]
//
// Original Years:  [1844,2087]
// Generated Years: [1945,2087]
// Lower/Upper Truncated: [True,False]
//
// Estimator Years: [1945,2090]
// Max Buffer Size: 7
//
// Records:
//   Infos: 16
//   Eras: 30
//   Policies: 11
//   Rules: 220
//
// Memory (8-bits):
//   Context: 16
//   Rules: 1980
//   Policies: 33
//   Eras: 330
//   Zones: 195
//   Links: 13
//   Registry: 32
//   Formats: 47
//   Letters: 23
//   Fragments: 0
//   Names: 260 (original: 260)
//   TOTAL: 2929
//
// Memory (32-bits):
//   Context: 24
//   Rules: 2640
//   Policies: 88
//   Eras: 480
//   Zones: 360
//   Links: 24
//   Registry: 64
//   Formats: 47
//   Letters: 33
//   Fragments: 0
//   Names: 260 (original: 260)
//   TOTAL: 4020
//
// DO NOT EDIT

#include <zoneinfo/compat.h>
#include "zone_policies.h"

namespace ace_time {
namespace zonedbxtesting {

//---------------------------------------------------------------------------
// Policies: 11
// Rules: 220
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Policy name: Aus
// Rules: 1
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesAus[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Aus    1943    1944    -    Mar    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },

};

const extended::ZonePolicy kZonePolicyAus ACE_TIME_PROGMEM = {
  kZoneRulesAus /*rules*/,
  1 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Canada
// Rules: 7
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesCanada[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Canada    1945    only    -    Sep    30    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1945    only    -    Sep    30    2:00    0    S
  {
    -127 /*fromYearTiny (1945)*/,
    -127 /*toYearTiny (1945)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1974    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -126 /*fromYearTiny (1974)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    1974    2006    -    Oct    lastSun    2:00    0    S
  {
    -126 /*fromYearTiny (1974)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Canada    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Canada    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },

};

const extended::ZonePolicy kZonePolicyCanada ACE_TIME_PROGMEM = {
  kZoneRulesCanada /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: EU
// Rules: 6
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesEU[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    EU    1978    only    -    Oct     1     1:00u    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1977    1980    -    Apr    Sun>=1     1:00u    1:00    S
  {
    -123 /*fromYearTiny (1977)*/,
    -120 /*toYearTiny (1980)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    EU    1978    only    -    Oct     1     1:00u    0    -
  {
    -122 /*fromYearTiny (1978)*/,
    -122 /*toYearTiny (1978)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1979    1995    -    Sep    lastSun     1:00u    0    -
  {
    -121 /*fromYearTiny (1979)*/,
    -105 /*toYearTiny (1995)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    EU    1981    max    -    Mar    lastSun     1:00u    1:00    S
  {
    -119 /*fromYearTiny (1981)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    EU    1996    max    -    Oct    lastSun     1:00u    0    -
  {
    -104 /*fromYearTiny (1996)*/,
    126 /*toYearTiny (32766)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    32 /*atTimeModifier (kSuffixU + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const extended::ZonePolicy kZonePolicyEU ACE_TIME_PROGMEM = {
  kZoneRulesEU /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Edm
// Rules: 4
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesEdm[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Edm    1947    only    -    Sep    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Edm    1947    only    -    Sep    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1947)*/,
    -127 /*toYearTiny (1947)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Edm    1972    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -127 /*fromYearTiny (1972)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Edm    1972    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1972)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },

};

const extended::ZonePolicy kZonePolicyEdm ACE_TIME_PROGMEM = {
  kZoneRulesEdm /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Morocco
// Rules: 170
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesMorocco[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Morocco    1978    only    -    Aug     4     0:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    1978    only    -    Aug     4     0:00    0    -
  {
    -122 /*fromYearTiny (1978)*/,
    -122 /*toYearTiny (1978)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2008    only    -    Jun     1     0:00    1:00    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2008    only    -    Sep     1     0:00    0    -
  {
    -92 /*fromYearTiny (2008)*/,
    -92 /*toYearTiny (2008)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2009    only    -    Jun     1     0:00    1:00    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2009    only    -    Aug    21     0:00    0    -
  {
    -91 /*fromYearTiny (2009)*/,
    -91 /*toYearTiny (2009)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2010    only    -    May     2     0:00    1:00    -
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2010    only    -    Aug     8     0:00    0    -
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2011    only    -    Apr     3     0:00    1:00    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2011    only    -    Jul    31     0:00    0    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    2013    -    Apr    lastSun     2:00    1:00    -
  {
    -88 /*fromYearTiny (2012)*/,
    -87 /*toYearTiny (2013)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Jul    20     3:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Aug    20     2:00    1:00    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2012    only    -    Sep    30     3:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -88 /*toYearTiny (2012)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    only    -    Jul     7     3:00    0    -
  {
    -87 /*fromYearTiny (2013)*/,
    -87 /*toYearTiny (2013)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    only    -    Aug    10     2:00    1:00    -
  {
    -87 /*fromYearTiny (2013)*/,
    -87 /*toYearTiny (2013)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2013    2018    -    Oct    lastSun     3:00    0    -
  {
    -87 /*fromYearTiny (2013)*/,
    -82 /*toYearTiny (2018)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    2018    -    Mar    lastSun     2:00    1:00    -
  {
    -86 /*fromYearTiny (2014)*/,
    -82 /*toYearTiny (2018)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    only    -    Jun    28     3:00    0    -
  {
    -86 /*fromYearTiny (2014)*/,
    -86 /*toYearTiny (2014)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2014    only    -    Aug     2     2:00    1:00    -
  {
    -86 /*fromYearTiny (2014)*/,
    -86 /*toYearTiny (2014)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2015    only    -    Jun    14     3:00    0    -
  {
    -85 /*fromYearTiny (2015)*/,
    -85 /*toYearTiny (2015)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2015    only    -    Jul    19     2:00    1:00    -
  {
    -85 /*fromYearTiny (2015)*/,
    -85 /*toYearTiny (2015)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2016    only    -    Jun     5     3:00    0    -
  {
    -84 /*fromYearTiny (2016)*/,
    -84 /*toYearTiny (2016)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2016    only    -    Jul    10     2:00    1:00    -
  {
    -84 /*fromYearTiny (2016)*/,
    -84 /*toYearTiny (2016)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2017    only    -    May    21     3:00    0    -
  {
    -83 /*fromYearTiny (2017)*/,
    -83 /*toYearTiny (2017)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2017    only    -    Jul     2     2:00    1:00    -
  {
    -83 /*fromYearTiny (2017)*/,
    -83 /*toYearTiny (2017)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2018    only    -    May    13     3:00    0    -
  {
    -82 /*fromYearTiny (2018)*/,
    -82 /*toYearTiny (2018)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2018    only    -    Jun    17     2:00    1:00    -
  {
    -82 /*fromYearTiny (2018)*/,
    -82 /*toYearTiny (2018)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2019    only    -    May     5     3:00    -1:00    -
  {
    -81 /*fromYearTiny (2019)*/,
    -81 /*toYearTiny (2019)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2019    only    -    Jun     9     2:00    0    -
  {
    -81 /*fromYearTiny (2019)*/,
    -81 /*toYearTiny (2019)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2020    only    -    Apr    19     3:00    -1:00    -
  {
    -80 /*fromYearTiny (2020)*/,
    -80 /*toYearTiny (2020)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2020    only    -    May    31     2:00    0    -
  {
    -80 /*fromYearTiny (2020)*/,
    -80 /*toYearTiny (2020)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2021    only    -    Apr    11     3:00    -1:00    -
  {
    -79 /*fromYearTiny (2021)*/,
    -79 /*toYearTiny (2021)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2021    only    -    May    16     2:00    0    -
  {
    -79 /*fromYearTiny (2021)*/,
    -79 /*toYearTiny (2021)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2022    only    -    Mar    27     3:00    -1:00    -
  {
    -78 /*fromYearTiny (2022)*/,
    -78 /*toYearTiny (2022)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2022    only    -    May     8     2:00    0    -
  {
    -78 /*fromYearTiny (2022)*/,
    -78 /*toYearTiny (2022)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2023    only    -    Mar    19     3:00    -1:00    -
  {
    -77 /*fromYearTiny (2023)*/,
    -77 /*toYearTiny (2023)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2023    only    -    Apr    23     2:00    0    -
  {
    -77 /*fromYearTiny (2023)*/,
    -77 /*toYearTiny (2023)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2024    only    -    Mar    10     3:00    -1:00    -
  {
    -76 /*fromYearTiny (2024)*/,
    -76 /*toYearTiny (2024)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2024    only    -    Apr    14     2:00    0    -
  {
    -76 /*fromYearTiny (2024)*/,
    -76 /*toYearTiny (2024)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2025    only    -    Feb    23     3:00    -1:00    -
  {
    -75 /*fromYearTiny (2025)*/,
    -75 /*toYearTiny (2025)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2025    only    -    Apr     6     2:00    0    -
  {
    -75 /*fromYearTiny (2025)*/,
    -75 /*toYearTiny (2025)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2026    only    -    Feb    15     3:00    -1:00    -
  {
    -74 /*fromYearTiny (2026)*/,
    -74 /*toYearTiny (2026)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2026    only    -    Mar    22     2:00    0    -
  {
    -74 /*fromYearTiny (2026)*/,
    -74 /*toYearTiny (2026)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2027    only    -    Feb     7     3:00    -1:00    -
  {
    -73 /*fromYearTiny (2027)*/,
    -73 /*toYearTiny (2027)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2027    only    -    Mar    14     2:00    0    -
  {
    -73 /*fromYearTiny (2027)*/,
    -73 /*toYearTiny (2027)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2028    only    -    Jan    23     3:00    -1:00    -
  {
    -72 /*fromYearTiny (2028)*/,
    -72 /*toYearTiny (2028)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2028    only    -    Mar     5     2:00    0    -
  {
    -72 /*fromYearTiny (2028)*/,
    -72 /*toYearTiny (2028)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Jan    14     3:00    -1:00    -
  {
    -71 /*fromYearTiny (2029)*/,
    -71 /*toYearTiny (2029)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Feb    18     2:00    0    -
  {
    -71 /*fromYearTiny (2029)*/,
    -71 /*toYearTiny (2029)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2029    only    -    Dec    30     3:00    -1:00    -
  {
    -71 /*fromYearTiny (2029)*/,
    -71 /*toYearTiny (2029)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2030    only    -    Feb    10     2:00    0    -
  {
    -70 /*fromYearTiny (2030)*/,
    -70 /*toYearTiny (2030)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2030    only    -    Dec    22     3:00    -1:00    -
  {
    -70 /*fromYearTiny (2030)*/,
    -70 /*toYearTiny (2030)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2031    only    -    Jan    26     2:00    0    -
  {
    -69 /*fromYearTiny (2031)*/,
    -69 /*toYearTiny (2031)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2031    only    -    Dec    14     3:00    -1:00    -
  {
    -69 /*fromYearTiny (2031)*/,
    -69 /*toYearTiny (2031)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2032    only    -    Jan    18     2:00    0    -
  {
    -68 /*fromYearTiny (2032)*/,
    -68 /*toYearTiny (2032)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2032    only    -    Nov    28     3:00    -1:00    -
  {
    -68 /*fromYearTiny (2032)*/,
    -68 /*toYearTiny (2032)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Jan     9     2:00    0    -
  {
    -67 /*fromYearTiny (2033)*/,
    -67 /*toYearTiny (2033)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Nov    20     3:00    -1:00    -
  {
    -67 /*fromYearTiny (2033)*/,
    -67 /*toYearTiny (2033)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2033    only    -    Dec    25     2:00    0    -
  {
    -67 /*fromYearTiny (2033)*/,
    -67 /*toYearTiny (2033)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2034    only    -    Nov     5     3:00    -1:00    -
  {
    -66 /*fromYearTiny (2034)*/,
    -66 /*toYearTiny (2034)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2034    only    -    Dec    17     2:00    0    -
  {
    -66 /*fromYearTiny (2034)*/,
    -66 /*toYearTiny (2034)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2035    only    -    Oct    28     3:00    -1:00    -
  {
    -65 /*fromYearTiny (2035)*/,
    -65 /*toYearTiny (2035)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2035    only    -    Dec     9     2:00    0    -
  {
    -65 /*fromYearTiny (2035)*/,
    -65 /*toYearTiny (2035)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2036    only    -    Oct    19     3:00    -1:00    -
  {
    -64 /*fromYearTiny (2036)*/,
    -64 /*toYearTiny (2036)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2036    only    -    Nov    23     2:00    0    -
  {
    -64 /*fromYearTiny (2036)*/,
    -64 /*toYearTiny (2036)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2037    only    -    Oct     4     3:00    -1:00    -
  {
    -63 /*fromYearTiny (2037)*/,
    -63 /*toYearTiny (2037)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2037    only    -    Nov    15     2:00    0    -
  {
    -63 /*fromYearTiny (2037)*/,
    -63 /*toYearTiny (2037)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2038    only    -    Sep    26     3:00    -1:00    -
  {
    -62 /*fromYearTiny (2038)*/,
    -62 /*toYearTiny (2038)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2038    only    -    Oct    31     2:00    0    -
  {
    -62 /*fromYearTiny (2038)*/,
    -62 /*toYearTiny (2038)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2039    only    -    Sep    18     3:00    -1:00    -
  {
    -61 /*fromYearTiny (2039)*/,
    -61 /*toYearTiny (2039)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2039    only    -    Oct    23     2:00    0    -
  {
    -61 /*fromYearTiny (2039)*/,
    -61 /*toYearTiny (2039)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2040    only    -    Sep     2     3:00    -1:00    -
  {
    -60 /*fromYearTiny (2040)*/,
    -60 /*toYearTiny (2040)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2040    only    -    Oct    14     2:00    0    -
  {
    -60 /*fromYearTiny (2040)*/,
    -60 /*toYearTiny (2040)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2041    only    -    Aug    25     3:00    -1:00    -
  {
    -59 /*fromYearTiny (2041)*/,
    -59 /*toYearTiny (2041)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2041    only    -    Sep    29     2:00    0    -
  {
    -59 /*fromYearTiny (2041)*/,
    -59 /*toYearTiny (2041)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    29 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2042    only    -    Aug    10     3:00    -1:00    -
  {
    -58 /*fromYearTiny (2042)*/,
    -58 /*toYearTiny (2042)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2042    only    -    Sep    21     2:00    0    -
  {
    -58 /*fromYearTiny (2042)*/,
    -58 /*toYearTiny (2042)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2043    only    -    Aug     2     3:00    -1:00    -
  {
    -57 /*fromYearTiny (2043)*/,
    -57 /*toYearTiny (2043)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2043    only    -    Sep    13     2:00    0    -
  {
    -57 /*fromYearTiny (2043)*/,
    -57 /*toYearTiny (2043)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2044    only    -    Jul    24     3:00    -1:00    -
  {
    -56 /*fromYearTiny (2044)*/,
    -56 /*toYearTiny (2044)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2044    only    -    Aug    28     2:00    0    -
  {
    -56 /*fromYearTiny (2044)*/,
    -56 /*toYearTiny (2044)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2045    only    -    Jul     9     3:00    -1:00    -
  {
    -55 /*fromYearTiny (2045)*/,
    -55 /*toYearTiny (2045)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2045    only    -    Aug    20     2:00    0    -
  {
    -55 /*fromYearTiny (2045)*/,
    -55 /*toYearTiny (2045)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2046    only    -    Jul     1     3:00    -1:00    -
  {
    -54 /*fromYearTiny (2046)*/,
    -54 /*toYearTiny (2046)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2046    only    -    Aug     5     2:00    0    -
  {
    -54 /*fromYearTiny (2046)*/,
    -54 /*toYearTiny (2046)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2047    only    -    Jun    23     3:00    -1:00    -
  {
    -53 /*fromYearTiny (2047)*/,
    -53 /*toYearTiny (2047)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2047    only    -    Jul    28     2:00    0    -
  {
    -53 /*fromYearTiny (2047)*/,
    -53 /*toYearTiny (2047)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2048    only    -    Jun     7     3:00    -1:00    -
  {
    -52 /*fromYearTiny (2048)*/,
    -52 /*toYearTiny (2048)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2048    only    -    Jul    19     2:00    0    -
  {
    -52 /*fromYearTiny (2048)*/,
    -52 /*toYearTiny (2048)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2049    only    -    May    30     3:00    -1:00    -
  {
    -51 /*fromYearTiny (2049)*/,
    -51 /*toYearTiny (2049)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2049    only    -    Jul     4     2:00    0    -
  {
    -51 /*fromYearTiny (2049)*/,
    -51 /*toYearTiny (2049)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2050    only    -    May    15     3:00    -1:00    -
  {
    -50 /*fromYearTiny (2050)*/,
    -50 /*toYearTiny (2050)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2050    only    -    Jun    26     2:00    0    -
  {
    -50 /*fromYearTiny (2050)*/,
    -50 /*toYearTiny (2050)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2051    only    -    May     7     3:00    -1:00    -
  {
    -49 /*fromYearTiny (2051)*/,
    -49 /*toYearTiny (2051)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2051    only    -    Jun    18     2:00    0    -
  {
    -49 /*fromYearTiny (2051)*/,
    -49 /*toYearTiny (2051)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2052    only    -    Apr    28     3:00    -1:00    -
  {
    -48 /*fromYearTiny (2052)*/,
    -48 /*toYearTiny (2052)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2052    only    -    Jun     2     2:00    0    -
  {
    -48 /*fromYearTiny (2052)*/,
    -48 /*toYearTiny (2052)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2053    only    -    Apr    13     3:00    -1:00    -
  {
    -47 /*fromYearTiny (2053)*/,
    -47 /*toYearTiny (2053)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2053    only    -    May    25     2:00    0    -
  {
    -47 /*fromYearTiny (2053)*/,
    -47 /*toYearTiny (2053)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2054    only    -    Apr     5     3:00    -1:00    -
  {
    -46 /*fromYearTiny (2054)*/,
    -46 /*toYearTiny (2054)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2054    only    -    May    10     2:00    0    -
  {
    -46 /*fromYearTiny (2054)*/,
    -46 /*toYearTiny (2054)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2055    only    -    Mar    28     3:00    -1:00    -
  {
    -45 /*fromYearTiny (2055)*/,
    -45 /*toYearTiny (2055)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2055    only    -    May     2     2:00    0    -
  {
    -45 /*fromYearTiny (2055)*/,
    -45 /*toYearTiny (2055)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2056    only    -    Mar    12     3:00    -1:00    -
  {
    -44 /*fromYearTiny (2056)*/,
    -44 /*toYearTiny (2056)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2056    only    -    Apr    23     2:00    0    -
  {
    -44 /*fromYearTiny (2056)*/,
    -44 /*toYearTiny (2056)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2057    only    -    Mar     4     3:00    -1:00    -
  {
    -43 /*fromYearTiny (2057)*/,
    -43 /*toYearTiny (2057)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2057    only    -    Apr     8     2:00    0    -
  {
    -43 /*fromYearTiny (2057)*/,
    -43 /*toYearTiny (2057)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2058    only    -    Feb    17     3:00    -1:00    -
  {
    -42 /*fromYearTiny (2058)*/,
    -42 /*toYearTiny (2058)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2058    only    -    Mar    31     2:00    0    -
  {
    -42 /*fromYearTiny (2058)*/,
    -42 /*toYearTiny (2058)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2059    only    -    Feb     9     3:00    -1:00    -
  {
    -41 /*fromYearTiny (2059)*/,
    -41 /*toYearTiny (2059)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2059    only    -    Mar    23     2:00    0    -
  {
    -41 /*fromYearTiny (2059)*/,
    -41 /*toYearTiny (2059)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    23 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2060    only    -    Feb     1     3:00    -1:00    -
  {
    -40 /*fromYearTiny (2060)*/,
    -40 /*toYearTiny (2060)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2060    only    -    Mar     7     2:00    0    -
  {
    -40 /*fromYearTiny (2060)*/,
    -40 /*toYearTiny (2060)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2061    only    -    Jan    16     3:00    -1:00    -
  {
    -39 /*fromYearTiny (2061)*/,
    -39 /*toYearTiny (2061)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2061    only    -    Feb    27     2:00    0    -
  {
    -39 /*fromYearTiny (2061)*/,
    -39 /*toYearTiny (2061)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Jan     8     3:00    -1:00    -
  {
    -38 /*fromYearTiny (2062)*/,
    -38 /*toYearTiny (2062)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Feb    12     2:00    0    -
  {
    -38 /*fromYearTiny (2062)*/,
    -38 /*toYearTiny (2062)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    12 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2062    only    -    Dec    31     3:00    -1:00    -
  {
    -38 /*fromYearTiny (2062)*/,
    -38 /*toYearTiny (2062)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    31 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2063    only    -    Feb     4     2:00    0    -
  {
    -37 /*fromYearTiny (2063)*/,
    -37 /*toYearTiny (2063)*/,
    2 /*inMonth*/,
    0 /*onDayOfWeek*/,
    4 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2063    only    -    Dec    16     3:00    -1:00    -
  {
    -37 /*fromYearTiny (2063)*/,
    -37 /*toYearTiny (2063)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2064    only    -    Jan    27     2:00    0    -
  {
    -36 /*fromYearTiny (2064)*/,
    -36 /*toYearTiny (2064)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2064    only    -    Dec     7     3:00    -1:00    -
  {
    -36 /*fromYearTiny (2064)*/,
    -36 /*toYearTiny (2064)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    7 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2065    only    -    Jan    11     2:00    0    -
  {
    -35 /*fromYearTiny (2065)*/,
    -35 /*toYearTiny (2065)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2065    only    -    Nov    22     3:00    -1:00    -
  {
    -35 /*fromYearTiny (2065)*/,
    -35 /*toYearTiny (2065)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Jan     3     2:00    0    -
  {
    -34 /*fromYearTiny (2066)*/,
    -34 /*toYearTiny (2066)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    3 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Nov    14     3:00    -1:00    -
  {
    -34 /*fromYearTiny (2066)*/,
    -34 /*toYearTiny (2066)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2066    only    -    Dec    26     2:00    0    -
  {
    -34 /*fromYearTiny (2066)*/,
    -34 /*toYearTiny (2066)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2067    only    -    Nov     6     3:00    -1:00    -
  {
    -33 /*fromYearTiny (2067)*/,
    -33 /*toYearTiny (2067)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2067    only    -    Dec    11     2:00    0    -
  {
    -33 /*fromYearTiny (2067)*/,
    -33 /*toYearTiny (2067)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2068    only    -    Oct    21     3:00    -1:00    -
  {
    -32 /*fromYearTiny (2068)*/,
    -32 /*toYearTiny (2068)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2068    only    -    Dec     2     2:00    0    -
  {
    -32 /*fromYearTiny (2068)*/,
    -32 /*toYearTiny (2068)*/,
    12 /*inMonth*/,
    0 /*onDayOfWeek*/,
    2 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2069    only    -    Oct    13     3:00    -1:00    -
  {
    -31 /*fromYearTiny (2069)*/,
    -31 /*toYearTiny (2069)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2069    only    -    Nov    17     2:00    0    -
  {
    -31 /*fromYearTiny (2069)*/,
    -31 /*toYearTiny (2069)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    17 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2070    only    -    Oct     5     3:00    -1:00    -
  {
    -30 /*fromYearTiny (2070)*/,
    -30 /*toYearTiny (2070)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    5 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2070    only    -    Nov     9     2:00    0    -
  {
    -30 /*fromYearTiny (2070)*/,
    -30 /*toYearTiny (2070)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    9 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2071    only    -    Sep    20     3:00    -1:00    -
  {
    -29 /*fromYearTiny (2071)*/,
    -29 /*toYearTiny (2071)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2071    only    -    Nov     1     2:00    0    -
  {
    -29 /*fromYearTiny (2071)*/,
    -29 /*toYearTiny (2071)*/,
    11 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2072    only    -    Sep    11     3:00    -1:00    -
  {
    -28 /*fromYearTiny (2072)*/,
    -28 /*toYearTiny (2072)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2072    only    -    Oct    16     2:00    0    -
  {
    -28 /*fromYearTiny (2072)*/,
    -28 /*toYearTiny (2072)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2073    only    -    Aug    27     3:00    -1:00    -
  {
    -27 /*fromYearTiny (2073)*/,
    -27 /*toYearTiny (2073)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2073    only    -    Oct     8     2:00    0    -
  {
    -27 /*fromYearTiny (2073)*/,
    -27 /*toYearTiny (2073)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2074    only    -    Aug    19     3:00    -1:00    -
  {
    -26 /*fromYearTiny (2074)*/,
    -26 /*toYearTiny (2074)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2074    only    -    Sep    30     2:00    0    -
  {
    -26 /*fromYearTiny (2074)*/,
    -26 /*toYearTiny (2074)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2075    only    -    Aug    11     3:00    -1:00    -
  {
    -25 /*fromYearTiny (2075)*/,
    -25 /*toYearTiny (2075)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2075    only    -    Sep    15     2:00    0    -
  {
    -25 /*fromYearTiny (2075)*/,
    -25 /*toYearTiny (2075)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    15 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2076    only    -    Jul    26     3:00    -1:00    -
  {
    -24 /*fromYearTiny (2076)*/,
    -24 /*toYearTiny (2076)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    26 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2076    only    -    Sep     6     2:00    0    -
  {
    -24 /*fromYearTiny (2076)*/,
    -24 /*toYearTiny (2076)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2077    only    -    Jul    18     3:00    -1:00    -
  {
    -23 /*fromYearTiny (2077)*/,
    -23 /*toYearTiny (2077)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    18 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2077    only    -    Aug    22     2:00    0    -
  {
    -23 /*fromYearTiny (2077)*/,
    -23 /*toYearTiny (2077)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2078    only    -    Jul    10     3:00    -1:00    -
  {
    -22 /*fromYearTiny (2078)*/,
    -22 /*toYearTiny (2078)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    10 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2078    only    -    Aug    14     2:00    0    -
  {
    -22 /*fromYearTiny (2078)*/,
    -22 /*toYearTiny (2078)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2079    only    -    Jun    25     3:00    -1:00    -
  {
    -21 /*fromYearTiny (2079)*/,
    -21 /*toYearTiny (2079)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    25 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2079    only    -    Aug     6     2:00    0    -
  {
    -21 /*fromYearTiny (2079)*/,
    -21 /*toYearTiny (2079)*/,
    8 /*inMonth*/,
    0 /*onDayOfWeek*/,
    6 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2080    only    -    Jun    16     3:00    -1:00    -
  {
    -20 /*fromYearTiny (2080)*/,
    -20 /*toYearTiny (2080)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2080    only    -    Jul    21     2:00    0    -
  {
    -20 /*fromYearTiny (2080)*/,
    -20 /*toYearTiny (2080)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2081    only    -    Jun     1     3:00    -1:00    -
  {
    -19 /*fromYearTiny (2081)*/,
    -19 /*toYearTiny (2081)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2081    only    -    Jul    13     2:00    0    -
  {
    -19 /*fromYearTiny (2081)*/,
    -19 /*toYearTiny (2081)*/,
    7 /*inMonth*/,
    0 /*onDayOfWeek*/,
    13 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2082    only    -    May    24     3:00    -1:00    -
  {
    -18 /*fromYearTiny (2082)*/,
    -18 /*toYearTiny (2082)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    24 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2082    only    -    Jun    28     2:00    0    -
  {
    -18 /*fromYearTiny (2082)*/,
    -18 /*toYearTiny (2082)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    28 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2083    only    -    May    16     3:00    -1:00    -
  {
    -17 /*fromYearTiny (2083)*/,
    -17 /*toYearTiny (2083)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    16 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2083    only    -    Jun    20     2:00    0    -
  {
    -17 /*fromYearTiny (2083)*/,
    -17 /*toYearTiny (2083)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    20 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2084    only    -    Apr    30     3:00    -1:00    -
  {
    -16 /*fromYearTiny (2084)*/,
    -16 /*toYearTiny (2084)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2084    only    -    Jun    11     2:00    0    -
  {
    -16 /*fromYearTiny (2084)*/,
    -16 /*toYearTiny (2084)*/,
    6 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2085    only    -    Apr    22     3:00    -1:00    -
  {
    -15 /*fromYearTiny (2085)*/,
    -15 /*toYearTiny (2085)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2085    only    -    May    27     2:00    0    -
  {
    -15 /*fromYearTiny (2085)*/,
    -15 /*toYearTiny (2085)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    27 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2086    only    -    Apr    14     3:00    -1:00    -
  {
    -14 /*fromYearTiny (2086)*/,
    -14 /*toYearTiny (2086)*/,
    4 /*inMonth*/,
    0 /*onDayOfWeek*/,
    14 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2086    only    -    May    19     2:00    0    -
  {
    -14 /*fromYearTiny (2086)*/,
    -14 /*toYearTiny (2086)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    19 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2087    only    -    Mar    30     3:00    -1:00    -
  {
    -13 /*fromYearTiny (2087)*/,
    -13 /*toYearTiny (2087)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    30 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Morocco    2087    only    -    May    11     2:00    0    -
  {
    -13 /*fromYearTiny (2087)*/,
    -13 /*toYearTiny (2087)*/,
    5 /*inMonth*/,
    0 /*onDayOfWeek*/,
    11 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const extended::ZonePolicy kZonePolicyMorocco ACE_TIME_PROGMEM = {
  kZoneRulesMorocco /*rules*/,
  170 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Namibia
// Rules: 4
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesNamibia[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1994    only    -    Mar    21    0:00    -1:00    WAT
  {
    -106 /*fromYearTiny (1994)*/,
    -106 /*toYearTiny (1994)*/,
    3 /*inMonth*/,
    0 /*onDayOfWeek*/,
    21 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    4 /*letterIndex ("WAT")*/,
  },
  // Rule    Namibia    1994    2017    -    Sep    Sun>=1    2:00    0    CAT
  {
    -106 /*fromYearTiny (1994)*/,
    -83 /*toYearTiny (2017)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    1 /*letterIndex ("CAT")*/,
  },
  // Rule    Namibia    1995    2017    -    Apr    Sun>=1    2:00    -1:00    WAT
  {
    -105 /*fromYearTiny (1995)*/,
    -83 /*toYearTiny (2017)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    0 /*deltaCode ((deltaMinutes=-60)/15 + 4)*/,
    4 /*letterIndex ("WAT")*/,
  },

};

const extended::ZonePolicy kZonePolicyNamibia ACE_TIME_PROGMEM = {
  kZoneRulesNamibia /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Port
// Rules: 6
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesPort[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Port    1978    only    -    Oct     1     1:00s    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1978    1980    -    Apr    Sun>=1     1:00s    1:00    S
  {
    -122 /*fromYearTiny (1978)*/,
    -120 /*toYearTiny (1980)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Port    1978    only    -    Oct     1     1:00s    0    -
  {
    -122 /*fromYearTiny (1978)*/,
    -122 /*toYearTiny (1978)*/,
    10 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1979    1980    -    Sep    lastSun     1:00s    0    -
  {
    -121 /*fromYearTiny (1979)*/,
    -120 /*toYearTiny (1980)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    4 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    Port    1981    1986    -    Mar    lastSun     0:00s    1:00    S
  {
    -119 /*fromYearTiny (1981)*/,
    -114 /*toYearTiny (1986)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Port    1981    1985    -    Sep    lastSun     0:00s    0    -
  {
    -119 /*fromYearTiny (1981)*/,
    -115 /*toYearTiny (1985)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const extended::ZonePolicy kZonePolicyPort ACE_TIME_PROGMEM = {
  kZoneRulesPort /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: US
// Rules: 7
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesUS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    US    1967    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1967)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    US    1975    only    -    Feb    lastSun    2:00    1:00    D
  {
    -125 /*fromYearTiny (1975)*/,
    -125 /*toYearTiny (1975)*/,
    2 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    1976    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -124 /*fromYearTiny (1976)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    1987    2006    -    Apr    Sun>=1    2:00    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -94 /*toYearTiny (2006)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Mar    Sun>=8    2:00    1:00    D
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    3 /*inMonth*/,
    7 /*onDayOfWeek*/,
    8 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    US    2007    max    -    Nov    Sun>=1    2:00    0    S
  {
    -93 /*fromYearTiny (2007)*/,
    126 /*toYearTiny (32766)*/,
    11 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },

};

const extended::ZonePolicy kZonePolicyUS ACE_TIME_PROGMEM = {
  kZoneRulesUS /*rules*/,
  7 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Vanc
// Rules: 4
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesVanc[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Vanc    1947    1961    -    Sep    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Vanc    1946    1986    -    Apr    lastSun    2:00    1:00    D
  {
    -127 /*fromYearTiny (1946)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Vanc    1947    1961    -    Sep    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1947)*/,
    -127 /*toYearTiny (1961)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Vanc    1962    2006    -    Oct    lastSun    2:00    0    S
  {
    -127 /*fromYearTiny (1962)*/,
    -94 /*toYearTiny (2006)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },

};

const extended::ZonePolicy kZonePolicyVanc ACE_TIME_PROGMEM = {
  kZoneRulesVanc /*rules*/,
  4 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: WS
// Rules: 6
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesWS[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    WS    2011    only    -    Apr    Sat>=1    4:00    0    -
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2010    only    -    Sep    lastSun    0:00    1    -
  {
    -90 /*fromYearTiny (2010)*/,
    -90 /*toYearTiny (2010)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2011    only    -    Apr    Sat>=1    4:00    0    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    4 /*inMonth*/,
    6 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2011    only    -    Sep    lastSat    3:00    1    -
  {
    -89 /*fromYearTiny (2011)*/,
    -89 /*toYearTiny (2011)*/,
    9 /*inMonth*/,
    6 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2012    2021    -    Apr    Sun>=1    4:00    0    -
  {
    -88 /*fromYearTiny (2012)*/,
    -79 /*toYearTiny (2021)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    16 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },
  // Rule    WS    2012    2020    -    Sep    lastSun    3:00    1    -
  {
    -88 /*fromYearTiny (2012)*/,
    -80 /*toYearTiny (2020)*/,
    9 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    12 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    0 /*letterIndex ("")*/,
  },

};

const extended::ZonePolicy kZonePolicyWS ACE_TIME_PROGMEM = {
  kZoneRulesWS /*rules*/,
  6 /*numRules*/,
};

//---------------------------------------------------------------------------
// Policy name: Winn
// Rules: 5
//---------------------------------------------------------------------------

static const extended::ZoneRule kZoneRulesWinn[] ACE_TIME_PROGMEM = {
  // Anchor: Rule    Winn    1963    only    -    Sep    22    2:00    0    S
  {
    -127 /*fromYearTiny (-32767)*/,
    -127 /*toYearTiny (-32767)*/,
    1 /*inMonth*/,
    0 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    0 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1963    only    -    Sep    22    2:00    0    S
  {
    -127 /*fromYearTiny (1963)*/,
    -127 /*toYearTiny (1963)*/,
    9 /*inMonth*/,
    0 /*onDayOfWeek*/,
    22 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    0 /*atTimeModifier (kSuffixW + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1966    1986    -    Apr    lastSun    2:00s    1:00    D
  {
    -127 /*fromYearTiny (1966)*/,
    -114 /*toYearTiny (1986)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },
  // Rule    Winn    1966    2005    -    Oct    lastSun    2:00s    0    S
  {
    -127 /*fromYearTiny (1966)*/,
    -95 /*toYearTiny (2005)*/,
    10 /*inMonth*/,
    7 /*onDayOfWeek*/,
    0 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    4 /*deltaCode ((deltaMinutes=0)/15 + 4)*/,
    3 /*letterIndex ("S")*/,
  },
  // Rule    Winn    1987    2005    -    Apr    Sun>=1    2:00s    1:00    D
  {
    -113 /*fromYearTiny (1987)*/,
    -95 /*toYearTiny (2005)*/,
    4 /*inMonth*/,
    7 /*onDayOfWeek*/,
    1 /*onDayOfMonth*/,
    8 /*atTimeCode*/,
    16 /*atTimeModifier (kSuffixS + minute=0)*/,
    8 /*deltaCode ((deltaMinutes=60)/15 + 4)*/,
    2 /*letterIndex ("D")*/,
  },

};

const extended::ZonePolicy kZonePolicyWinn ACE_TIME_PROGMEM = {
  kZoneRulesWinn /*rules*/,
  5 /*numRules*/,
};



}
}
