/*
 *
 * System5x7TR
 *
 *
 * File Name           : System5x7TR.h
 * Date                : 20 May 2022
 * Font size in bytes  : 530
 * Font width          : 5
 * Font height         : 7
 * Font first char     : 20
 * Font last char      : 127
 * Font used chars     : 106
 * TR Char Support	   : YES 
 * 						 modified by HakkanR hakkanr@gmail.com | www.devrelerim.com 
 *						 This font file can be used with DMD2 library.
 *						 to use Turkish char support DMD2TUR library should be 
 *						 download at https://github.com/HakkanR/DMD2TUR	
 * 
 * The font data are defined as
 * 
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef SYSTEM5x7TR_H
#define SYSTEM5x7TR_H

#define SYSTEM5x7TR_WIDTH 5
#define SYSTEM5x7TR_HEIGHT 7

/*
 * added to allow fontname to match header file name.
 * as well as keep the old name for backward compability
 */

#define SystemFont5x7TR System5x7TR

static const uint8_t System5x7TR[] PROGMEM = {
    0x0, 0x0, // size of zero indicates fixed width font, actual length is width * height
    0x05, // width
    0x07, // height
    0x14, // first char
    0x6c, // char countc

    // Fixed width; char width table not used !!!!

    // font data
	0x48, 0x54, 0xd4, 0x54, 0x20,// ş		0x14
	0x46, 0x49, 0xc9, 0x49, 0x31,// Ş		0x15
	0x38, 0x44, 0xc4, 0x44, 0x20,// ç		0x16
	0x3E, 0x41, 0xc1, 0x41, 0x22,// Ç		0x17
	0x3C, 0x41, 0x40, 0x21, 0x7C,// ü		0x18
	0x3d, 0x40, 0x40, 0x40, 0x3d,// Ü		0x19
	0x3c, 0x43, 0x42, 0x43, 0x3c,// Ö		0x1a
	0x38, 0x45, 0x44, 0x45, 0x38,// ö		0x1b
	0x08, 0x15, 0x55, 0x55, 0x3C,// ğ		0x1c
	0x3c, 0x43, 0x43, 0x53, 0x34,// Ğ		0x1D
	0x00, 0x42, 0x7F, 0x42, 0x00,// İ		0x1E
 	0x00, 0x44, 0x7c, 0x40, 0x00,// ı		0x1F
    0x00, 0x00, 0x00, 0x00, 0x00,// (space) 0x20
	0x00, 0x00, 0x5F, 0x00, 0x00,// !		0x21
	0x00, 0x07, 0x00, 0x07, 0x00,// "		0x22
	0x14, 0x7F, 0x14, 0x7F, 0x14,// #		0x23
	0x24, 0x2A, 0x7F, 0x2A, 0x12,// $		0x24
	0x23, 0x13, 0x08, 0x64, 0x62,// %		0x25	
	0x36, 0x49, 0x55, 0x22, 0x50,// &		0x26
	0x00, 0x05, 0x03, 0x00, 0x00,// '		0x27
	0x00, 0x1C, 0x22, 0x41, 0x00,// (		0x28
	0x00, 0x41, 0x22, 0x1C, 0x00,// )		0x29
	0x08, 0x2A, 0x1C, 0x2A, 0x08,// *		0x2A
	0x08, 0x08, 0x3E, 0x08, 0x08,// +		0x2B
	0x00, 0x50, 0x30, 0x00, 0x00,// ,		0x2C
	0x08, 0x08, 0x08, 0x08, 0x08,// -		0x2D
	0x00, 0x60, 0x60, 0x00, 0x00,// .		0x2E
	0x20, 0x10, 0x08, 0x04, 0x02,// /		0x2F
	0x3E, 0x51, 0x49, 0x45, 0x3E,// 0		0x30
	0x00, 0x42, 0x7F, 0x40, 0x00,// 1		0x31
	0x42, 0x61, 0x51, 0x49, 0x46,// 2		0x32
	0x21, 0x41, 0x45, 0x4B, 0x31,// 3		0x33
	0x18, 0x14, 0x12, 0x7F, 0x10,// 4		0x34
	0x27, 0x45, 0x45, 0x45, 0x39,// 5		0x35
	0x3C, 0x4A, 0x49, 0x49, 0x30,// 6		0x36
	0x01, 0x71, 0x09, 0x05, 0x03,// 7		0x37
	0x36, 0x49, 0x49, 0x49, 0x36,// 8		0x38
	0x06, 0x49, 0x49, 0x29, 0x1E,// 9		0x39
	0x00, 0x36, 0x36, 0x00, 0x00,// :		0x3A
	0x00, 0x56, 0x36, 0x00, 0x00,// ;		0x3B
	0x00, 0x08, 0x14, 0x22, 0x41,// <		0x3C
	0x14, 0x14, 0x14, 0x14, 0x14,// =		0x3d
	0x41, 0x22, 0x14, 0x08, 0x00,// >		0x3e
	0x02, 0x01, 0x51, 0x09, 0x06,// ?		0x3f
	0x32, 0x49, 0x79, 0x41, 0x3E,// @		0x40
	0x7E, 0x11, 0x11, 0x11, 0x7E,// A		0x41
	0x7F, 0x49, 0x49, 0x49, 0x36,// B		0x42
	0x3E, 0x41, 0x41, 0x41, 0x22,// C		0x43 67
	0x7F, 0x41, 0x41, 0x22, 0x1C,// D		0x44
	0x7F, 0x49, 0x49, 0x49, 0x41,// E		0x45
	0x7F, 0x09, 0x09, 0x01, 0x01,// F		0x46
	0x3E, 0x41, 0x41, 0x51, 0x32,// G		0x47  71
	0x7F, 0x08, 0x08, 0x08, 0x7F,// H		0x48
	0x00, 0x41, 0x7F, 0x41, 0x00,// I		0x49  73
	0x20, 0x40, 0x41, 0x3F, 0x01,// J		0x4A
	0x7F, 0x08, 0x14, 0x22, 0x41,// K		0x4B
	0x7F, 0x40, 0x40, 0x40, 0x40,// L		0x4c
	0x7F, 0x02, 0x04, 0x02, 0x7F,// M		0x4d
	0x7F, 0x04, 0x08, 0x10, 0x7F,// N		0x4e
	0x3E, 0x41, 0x41, 0x41, 0x3E,// O		0x4f 79
	0x7F, 0x09, 0x09, 0x09, 0x06,// P		0x50
	0x3E, 0x41, 0x51, 0x21, 0x5E,// Q		0x51
	0x7F, 0x09, 0x19, 0x29, 0x46,// R		0x52
	0x46, 0x49, 0x49, 0x49, 0x31,// S		0x53 83
	0x01, 0x01, 0x7F, 0x01, 0x01,// T		0x54
	0x3F, 0x40, 0x40, 0x40, 0x3F,// U		0x55 85
	0x1F, 0x20, 0x40, 0x20, 0x1F,// V		0x56	
	0x7F, 0x20, 0x18, 0x20, 0x7F,// W		0x57
	0x63, 0x14, 0x08, 0x14, 0x63,// X		0x58
	0x03, 0x04, 0x78, 0x04, 0x03,// Y		0x59
	0x61, 0x51, 0x49, 0x45, 0x43,// Z		0x5a
	0x00, 0x00, 0x7F, 0x41, 0x41,// [		0x5b
	0x02, 0x04, 0x08, 0x10, 0x20,// "\"		0x5c
	0x41, 0x41, 0x7F, 0x00, 0x00,// ]		0x5d
	0x04, 0x02, 0x01, 0x02, 0x04,// ^		0x5e
	0x40, 0x40, 0x40, 0x40, 0x40,// _		0x5f
	0x00, 0x01, 0x02, 0x04, 0x00,// `		0x60
	0x20, 0x54, 0x54, 0x54, 0x78,// a		0x61
	0x7F, 0x48, 0x44, 0x44, 0x38,// b		0x62
	0x38, 0x44, 0x44, 0x44, 0x20,// c		0x63 99 
	0x38, 0x44, 0x44, 0x48, 0x7F,// d		0x64
	0x38, 0x54, 0x54, 0x54, 0x18,// e		0x65
	0x08, 0x7E, 0x09, 0x01, 0x02,// f		0x66
	0x08, 0x14, 0x54, 0x54, 0x3C,// g		0x67 103
	0x7F, 0x08, 0x04, 0x04, 0x78,// h		0x68
	0x00, 0x44, 0x7D, 0x40, 0x00,// i		0x69
	0x20, 0x40, 0x44, 0x3D, 0x00,// j		0x6a
	0x00, 0x7F, 0x10, 0x28, 0x44,// k		0x6b
	0x00, 0x41, 0x7F, 0x40, 0x00,// l		0x6c
	0x7C, 0x04, 0x18, 0x04, 0x78,// m		0x6d
	0x7C, 0x08, 0x04, 0x04, 0x78,// n		0x6e
	0x38, 0x44, 0x44, 0x44, 0x38,// o		0x6f 111
	0x7C, 0x14, 0x14, 0x14, 0x08,// p		0x70
	0x08, 0x14, 0x14, 0x18, 0x7C,// q  		0x71
	0x7C, 0x08, 0x04, 0x04, 0x08,// r		0x72
	0x48, 0x54, 0x54, 0x54, 0x20,// s		0x73 115
	0x04, 0x3F, 0x44, 0x40, 0x20,// t		0x74
	0x3C, 0x40, 0x40, 0x20, 0x7C,// u		0x75 117
	0x1C, 0x20, 0x40, 0x20, 0x1C,// v
	0x3C, 0x40, 0x30, 0x40, 0x3C,// w
	0x44, 0x28, 0x10, 0x28, 0x44,// x
	0x0C, 0x50, 0x50, 0x50, 0x3C,// y
	0x44, 0x64, 0x54, 0x4C, 0x44,// z
	0x00, 0x08, 0x36, 0x41, 0x00,// {
	0x00, 0x00, 0x7F, 0x00, 0x00,// |
	0x00, 0x41, 0x36, 0x08, 0x00,// }
	0x08, 0x08, 0x2A, 0x1C, 0x08,// ->
	0x08, 0x1C, 0x2A, 0x08, 0x08 // <-		0x7f


};

#endif
