#include "TSYS01.h"

#define TSYS01_ADDR                        0x77  
#define TSYS01_RESET                       0x1E
#define TSYS01_ADC_READ                    0x00
#define TSYS01_ADC_TEMP_CONV               0x48
#define TSYS01_PROM_READ                   0XA0

TSYS01::TSYS01(TwoWire *wire) {
	_wire = wire;
}

bool TSYS01::init() {
	// Reset the TSYS01, per datasheet
	_wire->beginTransmission(TSYS01_ADDR);
	_wire->write(TSYS01_RESET);
	_wire->endTransmission();
	
	delay(10);
	int received_bytes = 0;
		// Read calibration values
	for ( uint8_t i = 0 ; i < 8 ; i++ ) {
		_wire->beginTransmission(TSYS01_ADDR);
		_wire->write(TSYS01_PROM_READ+i*2);
		_wire->endTransmission();

		received_bytes += _wire->requestFrom(TSYS01_ADDR,2);
		C[i] = (_wire->read() << 8) | _wire->read();
	}
	return received_bytes > 0;

}

void TSYS01::read() {
	
	_wire->beginTransmission(TSYS01_ADDR);
	_wire->write(TSYS01_ADC_TEMP_CONV);
	_wire->endTransmission();
 
	delay(10); // Max conversion time per datasheet
	
	_wire->beginTransmission(TSYS01_ADDR);
	_wire->write(TSYS01_ADC_READ);
	_wire->endTransmission();

	_wire->requestFrom(TSYS01_ADDR,3);
	D1 = 0;
	D1 = _wire->read();
	D1 = (D1 << 8) | _wire->read();
	D1 = (D1 << 8) | _wire->read();

	calculate();
}

void TSYS01::readTestCase() {
	C[0] = 0;
	C[1] = 28446;  //0xA2 K4
	C[2] = 24926;  //0XA4 k3
 	C[3] = 36016;  //0XA6 K2
	C[4] = 32791;  //0XA8 K1
	C[5] = 40781;  //0XAA K0
	C[6] = 0;
	C[7] = 0;

	D1 = 9378708.0f;
	
	adc = D1/256;

	calculate();
}

void TSYS01::calculate() {	
	adc = D1/256; 

TEMP = (-2) * float(C[1]) / 1000000000000000000000.0f * pow(adc,4) + 
        4 * float(C[2]) / 10000000000000000.0f * pow(adc,3) +
	  (-2) * float(C[3]) / 100000000000.0f * pow(adc,2) +
   	    1 * float(C[4]) / 1000000.0f * adc +
      (-1.5) * float(C[5]) / 100 ;

}

float TSYS01::temperature() {
	return TEMP;
}
