/*
  GBALib_UltrasonicSensor.h - HC-SR04 Ultrasonic Sensor library.
  Copyright (c) 2024 Graziano Blasilli.
  
  This library provides a simple interface to read the HC-SR04 Ultrasonic Sensor inputs.
*/

#ifndef GBALib_UltrasonicSensor_h
#define GBALib_UltrasonicSensor_h


#include <Arduino.h>

/**
 * UltrasonicSensor class for reading distance using an HC-SR04 ultrasonic sensor.
 * This class manages the trigger and echo pins and provides a method to read distance in centimeters.
 */
class UltrasonicSensor {
  private:
    int triggerPin;  // Pin connected to the trigger signal of the ultrasonic sensor
    int echoPin;     // Pin connected to the echo signal of the ultrasonic sensor

  public:
    /**
     * Constructor to initialize the UltrasonicSensor object.
     * 
     * @param triggerPin The pin number connected to the trigger signal of the sensor.
     * @param echoPin    The pin number connected to the echo signal of the sensor.
     */
    UltrasonicSensor(int triggerPin, int echoPin);

    /**
     * Reads the distance in centimeters using the ultrasonic sensor.
     * 
     * @return The calculated distance in centimeters.
     */
    int readDistance();

    /**
    * Executes `n` subsequent readings and returns the average distance.
    * This helps to reduce noise and provides a more stable measurement.
    * 
    * @param n The number of readings to average.
    * @return The average distance in centimeters.
    */
    int readDistance(int n);
};

#endif
