//
// OneBitDisplay library demo
//
// Demonstrates how to use virtual displays
// these allow you to create a display of any size in memory
// and draw it across multiple physical displays
//
//#include <random.h>
#include <OneBitDisplay.h>
OBDISP obLeft;
OBDISP obRight;
OBDISP obVirt;

// define a 256x64 framebuffer
static uint8_t ucBackBuffer[2048];

// Toaster animation images
const uint8_t toastermask0[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0x00, 0x43, 0xF8, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x00, 0x7C, 0x3F, 0x80,
  0x01, 0xF1, 0xF8, 0xF0, 0x07, 0xC7, 0xC7, 0x00,
  0x0F, 0x1F, 0x08, 0x2B, 0x1E, 0x7C, 0x11, 0x00,
  0x04, 0xF0, 0x20, 0x56, 0x61, 0xE4, 0x22, 0x00,
  0x78, 0x48, 0x40, 0xA8, 0x4E, 0x10, 0x44, 0x00,
  0x53, 0x90, 0x81, 0xF8, 0x5C, 0xA0, 0x90, 0x58,
  0x7C, 0xA1, 0x07, 0x90, 0x74, 0xA1, 0x21, 0x38,
  0x7F, 0xB5, 0x0E, 0x30, 0x77, 0xB0, 0x90, 0x78,
  0x7F, 0xB4, 0x60, 0xF0, 0x77, 0xBB, 0x03, 0xE0,
  0x7F, 0xBC, 0x0F, 0xC0, 0x77, 0xBF, 0xFF, 0x00,
  0x7F, 0xBF, 0xFC, 0x00, 0x3F, 0xBF, 0xF0, 0x00,
  0x1F, 0xBF, 0xC0, 0x00, 0x07, 0xBE, 0x00, 0x00,
  0x01, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
const uint8_t toastermask1[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0xF8, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x00, 0x7C, 0x3F, 0x80,
  0x01, 0xF1, 0xF8, 0x00, 0x07, 0xC7, 0xC1, 0xE0,
  0x0F, 0x1F, 0x06, 0x10, 0x1E, 0x7C, 0x00, 0x00,
  0x04, 0xF0, 0x07, 0xF0, 0x61, 0xE4, 0x18, 0x08,
  0x78, 0x48, 0x20, 0x80, 0x4E, 0x10, 0x40, 0x2B,
  0x53, 0x90, 0x81, 0x00, 0x5C, 0xA0, 0x80, 0x58,
  0x7C, 0xA1, 0x02, 0x00, 0x74, 0xA1, 0x28, 0xB8,
  0x7F, 0xB5, 0x0F, 0xF0, 0x77, 0xB0, 0x90, 0x78,
  0x7F, 0xB4, 0x60, 0xF0, 0x77, 0xBB, 0x03, 0xE0,
  0x7F, 0xBC, 0x0F, 0xC0, 0x77, 0xBF, 0xFF, 0x00,
  0x7F, 0xBF, 0xFC, 0x00, 0x3F, 0xBF, 0xF0, 0x00,
  0x1F, 0xBF, 0xC0, 0x00, 0x07, 0xBE, 0x00, 0x00,
  0x01, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
const uint8_t toastermask2[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x00, 0x7C, 0x3F, 0x80,
  0x01, 0xF1, 0xF8, 0x00, 0x07, 0xC7, 0xC1, 0xE0,
  0x0F, 0x1F, 0x06, 0x10, 0x1E, 0x7C, 0x00, 0x00,
  0x04, 0xF0, 0x00, 0x00, 0x61, 0xE4, 0x00, 0x08,
  0x78, 0x48, 0x00, 0x10, 0x4E, 0x10, 0x00, 0x18,
  0x53, 0x90, 0x60, 0x70, 0x5C, 0xA0, 0x9F, 0xC8,
  0x7C, 0xA1, 0x04, 0x92, 0x74, 0xA1, 0x09, 0x24,
  0x7F, 0xB5, 0x02, 0x48, 0x77, 0xB0, 0x80, 0x10,
  0x7F, 0xB4, 0x41, 0x00, 0x77, 0xBB, 0x20, 0x40,
  0x7F, 0xBC, 0x10, 0x00, 0x77, 0xBF, 0xF8, 0x00,
  0x7F, 0xBF, 0xFC, 0x00, 0x3F, 0xBF, 0xF0, 0x00,
  0x1F, 0xBF, 0xC0, 0x00, 0x07, 0xBE, 0x00, 0x00,
  0x01, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
  const uint8_t toaster0[] = {
  0x00, 0x30, 0x00, 0x00, 0x00, 0xE8, 0x00, 0x00,
  0x01, 0xD8, 0x00, 0x00, 0x03, 0x74, 0xF0, 0x00,
  0x07, 0xEF, 0xFE, 0x00, 0x07, 0xBC, 0x07, 0x80,
  0x0F, 0xE0, 0x7F, 0xE0, 0x0F, 0x83, 0xC0, 0x70,
  0x1E, 0x0E, 0x07, 0x08, 0x18, 0x38, 0x38, 0xFF,
  0x30, 0xE0, 0xF7, 0xD4, 0x61, 0x83, 0xEE, 0xFF,
  0x7B, 0x0F, 0xDF, 0xA8, 0x9E, 0x1B, 0xDD, 0xFE,
  0x87, 0xB7, 0xBF, 0x50, 0xB1, 0xEF, 0xBB, 0xF8,
  0xAC, 0x6F, 0x7E, 0x00, 0xA3, 0x5F, 0x6F, 0xA0,
  0x83, 0x5E, 0xF8, 0x68, 0x8B, 0x5E, 0xDE, 0xC0,
  0x80, 0x4A, 0xF1, 0xC8, 0x88, 0x4F, 0x6F, 0x80,
  0x80, 0x4B, 0x9F, 0x08, 0x88, 0x44, 0xFC, 0x10,
  0x80, 0x43, 0xF0, 0x20, 0x88, 0x40, 0x00, 0xC0,
  0x80, 0x40, 0x03, 0x00, 0x40, 0x40, 0x0C, 0x00,
  0x20, 0x40, 0x30, 0x00, 0x18, 0x41, 0xC0, 0x00,
  0x06, 0x4E, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00 };
 const uint8_t toaster1[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xF0, 0x00,
  0x00, 0xF7, 0xFE, 0x00, 0x01, 0xBC, 0x07, 0x80,
  0x03, 0xE0, 0x7F, 0xE0, 0x07, 0x83, 0xC0, 0x70,
  0x0E, 0x0E, 0x07, 0xF8, 0x18, 0x38, 0x3E, 0x18,
  0x30, 0xE0, 0xF9, 0xE8, 0x61, 0x83, 0xFF, 0xF8,
  0x7B, 0x0F, 0xF8, 0x08, 0x9E, 0x1B, 0xE7, 0xF0,
  0x87, 0xB7, 0xDF, 0x7F, 0xB1, 0xEF, 0xBF, 0xD4,
  0xAC, 0x6F, 0x7E, 0xFF, 0xA3, 0x5F, 0x7F, 0xA6,
  0x83, 0x5E, 0xFD, 0xF8, 0x8B, 0x5E, 0xD7, 0x40,
  0x80, 0x4A, 0xF0, 0x08, 0x88, 0x4F, 0x6F, 0x80,
  0x80, 0x4B, 0x9F, 0x08, 0x88, 0x44, 0xFC, 0x10,
  0x80, 0x43, 0xF0, 0x20, 0x88, 0x40, 0x00, 0xC0,
  0x80, 0x40, 0x03, 0x00, 0x40, 0x40, 0x0C, 0x00,
  0x20, 0x40, 0x30, 0x00, 0x18, 0x41, 0xC0, 0x00,
  0x06, 0x4E, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00 };
 const uint8_t toaster2[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00,
  0x00, 0x07, 0xFE, 0x00, 0x00, 0x3C, 0x07, 0x80,
  0x00, 0xE0, 0x7F, 0xE0, 0x03, 0x83, 0xC0, 0x70,
  0x0E, 0x0E, 0x07, 0xF8, 0x18, 0x38, 0x3E, 0x18,
  0x30, 0xE0, 0xF9, 0xE8, 0x61, 0x83, 0xFF, 0xF8,
  0x7B, 0x0F, 0xFF, 0xF8, 0x9E, 0x1B, 0xFF, 0xF0,
  0x87, 0xB7, 0xFF, 0xE8, 0xB1, 0xEF, 0xFF, 0xE0,
  0xAC, 0x6F, 0x9F, 0x88, 0xA3, 0x5F, 0x60, 0x36,
  0x83, 0x5E, 0xFB, 0x6D, 0x8B, 0x5E, 0xF6, 0xDB,
  0x80, 0x4A, 0xFD, 0xB6, 0x88, 0x4F, 0x7F, 0xEE,
  0x80, 0x4B, 0xBE, 0xFC, 0x88, 0x44, 0xDF, 0xBC,
  0x80, 0x43, 0xEF, 0xF8, 0x88, 0x40, 0x07, 0xF0,
  0x80, 0x40, 0x03, 0xE0, 0x40, 0x40, 0x0C, 0xC0,
  0x20, 0x40, 0x30, 0x00, 0x18, 0x41, 0xC0, 0x00,
  0x06, 0x4E, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00 };
uint8_t * toasters[] = {(uint8_t *)toaster0, (uint8_t *)toaster1, (uint8_t *)toaster2, (uint8_t *)toaster1};
uint8_t * masks[] = {(uint8_t *)toastermask0, (uint8_t *)toastermask1, (uint8_t *)toastermask2, (uint8_t *)toastermask1};

void setup() {
int rc;
//int obdI2CInit(OBDISP *pOBD, int iType, int iAddr, int bFlip, int bInvert, int bWire, int iSDAPin, int iSCLPin, int iResetPin, int32_t iSpeed);
// Create a virtual display (memory only)
  obdCreateVirtualDisplay(&obVirt, 256, 64, ucBackBuffer);
// Initialize 2 physical OLED displays
// In this case, they are defined on the W600-PICO using bit banging
// Change the SDA and SCL pin definitions to match your setup
rc = obdI2CInit(&obLeft, OLED_128x64, -1, 0, 0,0,WM_IO_PB_12, WM_IO_PA_00,-1,1200000L);
rc = obdI2CInit(&obRight, OLED_128x64, -1, 0, 0,0,WM_IO_PB_11, WM_IO_PA_00,-1,1200000L);
  if (rc != OLED_NOT_FOUND)
  {
    char *msgs[] = {(char *)"SSD1306 @ 0x3C", (char *)"SSD1306 @ 0x3D",(char *)"SH1106 @ 0x3C",(char *)"SH1106 @ 0x3D"};
    obdFill(&obLeft, OBD_WHITE, 1);
    obdWriteString(&obLeft,0,0,0,msgs[rc], FONT_8x8, OBD_BLACK, 1);
    delay(2000);
  }
}
#define NUM_SPRITES 10
void loop() {
int i, x, y;
char szTemp[32];
unsigned long ms;
int xpos[NUM_SPRITES], ypos[NUM_SPRITES], index[NUM_SPRITES], velocity[NUM_SPRITES];

  obdFill(&obLeft, OBD_WHITE, 1);
  obdWriteString(&obLeft,0,16,0,(char *)"ss_oled Demo", FONT_8x8, OBD_BLACK, 1);
  obdWriteString(&obLeft,0,0,1,(char *)"Written by Larry Bank", FONT_6x8, OBD_WHITE, 1);
  obdWriteString(&obLeft,0,0,3,(char *)"**Demo**", FONT_16x32, OBD_BLACK, 1);
  delay(2000);

// Sprites
// generate random starting positions, speed and animation frame index
  for (i=0; i<NUM_SPRITES; i++)
  {
    xpos[i] = 4*((rand()&255) +31);
    ypos[i] = 4*((rand()&63) - 31);
    index[i] = rand() & 3;
    velocity[i] = 1+(rand() & 3);
  }
  while (1)
  {
    obdFill(&obVirt, OBD_WHITE, 0); // erase the virtual display
    for (i=0; i<NUM_SPRITES; i++)
    {
      int x, y;
      obdDrawSprite(&obVirt,masks[index[i] & 3], 32, 32, 4, xpos[i]>>2, ypos[i]>>2, 0);
      obdDrawSprite(&obVirt,toasters[index[i] & 3], 32, 32, 4, xpos[i]>>2, ypos[i]>>2, 1);
      xpos[i]-= velocity[i];
      ypos[i]+= velocity[i];
      index[i]++;
      x = xpos[i] >> 2; y = ypos[i] >> 2;
      if (x < -31 || y >= 64)
      {
        xpos[i] = 4*((rand()&255) + 31);
        ypos[i] = 4*((rand()&63) - 31);
      }
    }
    // Show the left half of the virtual display on the left OLED
    obdDumpWindow(&obVirt, &obLeft,0,0,0,0,128,64);
    // and the right half on the right OLED
    obdDumpWindow(&obVirt, &obRight,128,0,0,0,128,64);
  } // while (1)
} /* main() */
