# Universal Debug Library

A universal debug class for Arduino (Uno/Nano) and ESP32 boards that supports both standard `Serial.print()` calls and `printf`-style formatting to simultaneous outputs (Hardware Serial Monitor and Bluetooth Serial).

## Features

*   **Dual Output:** Sends data to Hardware Serial and Bluetooth Serial simultaneously.
*   **Platform Agnostic:** Automatically uses `SoftwareSerial` (Uno/Nano) or `BluetoothSerial` (ESP32).
*   **Memory Efficient:** Inherits from Arduino's `Print` class and uses stack memory buffers for formatting.
*   **Configurable:** Use `#define` flags to enable/disable Bluetooth output or force platform detection.

## Usage Example (ESP32)

```cpp
#define FORCE_ESP32 1
#define DEBUG_BLUETOOTH_ENABLED 1
#include <UniversalDebug.h>

UniversalDebug Debug(Serial);

void setup() {
    Debug.begin(115200, "MyESP32Device");
    Debug.println("System Booted.");
    Debug.printf("Voltage is %.2fV\n", 3.3);
}

void loop() {
    Debug.println("Heartbeat...");
    delay(2000);
}
