#ifndef EEPROMHANDLER_H
#define EEPROMHANDLER_H

#include <Wire.h>

class EEPROMHandler {
private:
    uint8_t deviceAddress;
    int baseAddress;

public:
    EEPROMHandler(uint8_t deviceAddress, int baseAddr = 0x0000);

    void saveInt(int address, int value);
    int readInt(int address);
    void validateInt(int address, int minValue, int maxValue, int defaultValue);
    void validateInt(int address, int minValue, int maxValue);

    void saveLong(int address, long value);
    long readLong(int address);
    void validateLong(int address, long minValue, long maxValue, long defaultValue);
    void validateLong(int address, long minValue, long maxValue);

    void saveFloat(int address, float value);
    float readFloat(int address);
    void validateFloat(int address, float minValue, float maxValue, float defaultValue);
    void validateFloat(int address, float minValue, float maxValue);

    void saveDouble(int address, double value);
    double readDouble(int address);
    void validateDouble(int address, double minValue, double maxValue, double defaultValue);
    void validateDouble(int address, double minValue, double maxValue);

    void saveChar(int address, char value);
    char readChar(int address);
    void validateChar(int address, char defaultValue);
    void validateChar(int address);

    void saveBool(int address, bool value);
    bool readBool(int address);
    void validateBool(int address, bool defaultValue);
    void validateBool(int address);

    void saveString(int address, const String &value);
    String readString(int address);
    void validateString(int address, int maxLength, const String &defaultValue);
    void validateString(int address, int maxLength);

    void saveBytes(int address, const uint8_t *data, int length);
    void readBytes(int address, uint8_t *data, int length);
    void validateBytes(int address, const uint8_t *defaultData, int length);
    void validateBytes(int address, int length);

    void saveIntArray(int startAddress, int values[], int size);
    void readIntArray(int startAddress, int values[], int size);
    void validateIntArray(int startAddress, int values[], int size, int defaultValues[]);
    void validateIntArray(int startAddress, int values[], int size);

    void clearEEPROM(int length);
};

#endif
