#include <Wire.h>
#include "EEPROMHandler.h"

// Inisialisasi library dengan alamat EEPROM (0x50 default untuk AT24C256)
EEPROMHandler eeprom(0x50);

void setup() {
    Serial.begin(9600);
    Wire.begin();

    Serial.println("EEPROM Handler Example");

    // Data untuk disimpan
    int value1 = 1234;
    long value2 = 987654321;
    float fval = 3.14f;
    double dval = 2.718281828;
    char cval = 'Z';
    bool flag = true;
    String str = "Hello EEPROM";
    int numbers[5] = {10, 20, 30, 40, 50};
    uint8_t bytes[3] = {0xAA, 0xBB, 0xCC};

    // Menyimpan data
    eeprom.saveInt(0, value1);
    eeprom.saveLong(4, value2);
    eeprom.saveFloat(8, fval);
    eeprom.saveDouble(12, dval);
    eeprom.saveChar(20, cval);
    eeprom.saveBool(21, flag);
    eeprom.saveString(22, str);
    eeprom.saveIntArray(40, numbers, 5);
    eeprom.saveBytes(60, bytes, 3);

    Serial.println("Data saved!");

    // Reset nilai untuk pengujian baca
    value1 = 0;
    value2 = 0;
    fval = 0.0f;
    dval = 0.0;
    cval = 0;
    flag = false;
    str = "";
    for (int i = 0; i < 5; i++) numbers[i] = 0;
    for (int i = 0; i < 3; i++) bytes[i] = 0;

    // Membaca kembali data
    value1 = eeprom.readInt(0);
    value2 = eeprom.readLong(4);
    fval = eeprom.readFloat(8);
    dval = eeprom.readDouble(12);
    cval = eeprom.readChar(20);
    flag = eeprom.readBool(21);
    str = eeprom.readString(22);
    eeprom.readIntArray(40, numbers, 5);
    eeprom.readBytes(60, bytes, 3);

    // Menampilkan hasil baca
    Serial.println("Data read:");
    Serial.print("value1 (int): "); Serial.println(value1);
    Serial.print("value2 (long): "); Serial.println(value2);
    Serial.print("fval (float): "); Serial.println(fval, 6);
    Serial.print("dval (double): "); Serial.println(dval, 9);
    Serial.print("cval (char): "); Serial.println(cval);
    Serial.print("flag (bool): "); Serial.println(flag);
    Serial.print("str (String): "); Serial.println(str);

    Serial.print("numbers (int array): ");
    for (int i = 0; i < 5; i++) {
        Serial.print(numbers[i]); Serial.print(" ");
    }
    Serial.println();

    Serial.print("bytes (byte array): ");
    for (int i = 0; i < 3; i++) {
        Serial.print(bytes[i], HEX); Serial.print(" ");
    }
    Serial.println();
}

void loop() {
    // Kosong
}
