EEPROMHandler Library
=====================

EEPROMHandler adalah library sederhana untuk mempermudah penyimpanan dan pembacaan data dari semua modul EEPROM seri AT24Cxx (AT24C01 hingga AT24C512, dsb) menggunakan Arduino dan perangkat berbasis I2C lainnya. Library ini mendukung penyimpanan berbagai tipe data seperti integer, long, float, double, char, boolean, string, array, dan byte array, serta dapat diperluas sesuai kebutuhan proyek Anda.

Fitur
--------

*   Menyimpan dan membaca nilai integer, long, float, double, char, boolean, string, array, dan byte array ke/dari EEPROM.
*   Mendukung validasi dan penulisan ulang nilai default jika data tidak valid.
*   Mudah digunakan dengan antarmuka yang intuitif.
*   Kompatibel dengan semua modul EEPROM berbasis I2C seri AT24Cxx (AT24C01, AT24C02, AT24C04, AT24C08, AT24C16, AT24C32, AT24C64, AT24C128, AT24C256, AT24C512, dst).
*   Mendukung semua board/platform yang kompatibel dengan Arduino dan library Wire/I2C (Arduino UNO, Mega, Nano, Leonardo, ESP8266, ESP32, STM32, Teensy, dsb).

Instalasi
------------

### Download atau Clone Repository

Anda dapat mengunduh file ZIP dari repository ini atau menggunakan perintah git:

```bash
git clone https://github.com/yourgithub/EEPROMHandler.git
```

### Pindahkan ke Folder Library Arduino

Ekstrak folder dan tempatkan di direktori library Arduino Anda:

```bash
Documents/Arduino/libraries/EEPROMHandler
```

### Restart Arduino IDE

Setelah instalasi, restart Arduino IDE agar library dikenali.

Cara Penggunaan
----------------

### 1. Inisialisasi

Tambahkan library di bagian awal program Anda:

```cpp
#include <Wire.h>
#include "EEPROMHandler.h"
```

Inisialisasi library dengan alamat EEPROM (contoh: 0x50 untuk AT24C256):

```cpp
EEPROMHandler eeprom(0x50); // 0x50 adalah alamat I2C default
```

### 2. Menyimpan Data

Gunakan fungsi `saveInt()`, `saveLong()`, `saveFloat()`, `saveDouble()`, `saveChar()`, `saveBool()`, `saveString()`, `saveIntArray()`, atau `saveBytes()` untuk menyimpan data:

```cpp
eeprom.saveInt(0, 1234); // Simpan integer 1234 di alamat 0
eeprom.saveBool(10, true); // Simpan nilai boolean true di alamat 10
eeprom.saveFloat(12, 3.14f); // Simpan float di alamat 12
eeprom.saveString(20, "Hello"); // Simpan string di alamat 20

int numbers[] = {10, 20, 30, 40, 50};
eeprom.saveIntArray(40, numbers, 5); // Simpan array integer di alamat 40

uint8_t data[] = {0xAA, 0xBB, 0xCC};
eeprom.saveBytes(100, data, 3); // Simpan byte array di alamat 100
```

### 3. Membaca Data

Gunakan fungsi `readInt()`, `readLong()`, `readFloat()`, `readDouble()`, `readChar()`, `readBool()`, `readString()`, `readIntArray()`, atau `readBytes()` untuk membaca data:

```cpp
int value = eeprom.readInt(0); // Baca integer dari alamat 0
bool flag = eeprom.readBool(10); // Baca boolean dari alamat 10
float fval = eeprom.readFloat(12); // Baca float dari alamat 12
String str = eeprom.readString(20); // Baca string dari alamat 20

int readNumbers[5];
eeprom.readIntArray(40, readNumbers, 5); // Baca array dari alamat 40

uint8_t readData[3];
eeprom.readBytes(100, readData, 3); // Baca byte array dari alamat 100
```

### 4. Contoh Program Lengkap

Berikut adalah program lengkap yang dapat dicoba:

```cpp
#include <Wire.h>
#include "EEPROMHandler.h"

EEPROMHandler eeprom(0x50);

void setup() {
    Serial.begin(9600);
    Wire.begin();

    // Menyimpan data
    eeprom.saveInt(0, 1234);
    eeprom.saveBool(10, true);
    eeprom.saveFloat(12, 3.14f);
    eeprom.saveString(20, "Hello");

    int numbers[] = {10, 20, 30, 40, 50};
    eeprom.saveIntArray(40, numbers, 5);

    uint8_t data[] = {0xAA, 0xBB, 0xCC};
    eeprom.saveBytes(100, data, 3);

    Serial.println("Data saved!");

    // Membaca data
    int value = eeprom.readInt(0);
    bool flag = eeprom.readBool(10);
    float fval = eeprom.readFloat(12);
    String str = eeprom.readString(20);

    int readNumbers[5];
    eeprom.readIntArray(40, readNumbers, 5);

    uint8_t readData[3];
    eeprom.readBytes(100, readData, 3);

    // Menampilkan data yang dibaca
    Serial.println("Data read:");
    Serial.print("value: "); Serial.println(value);
    Serial.print("flag: "); Serial.println(flag);
    Serial.print("float: "); Serial.println(fval);
    Serial.print("string: "); Serial.println(str);

    Serial.print("numbers: ");
    for (int i = 0; i < 5; i++) {
        Serial.print(readNumbers[i]); Serial.print(" ");
    }
    Serial.println();

    Serial.print("bytes: ");
    for (int i = 0; i < 3; i++) {
        Serial.print(readData[i], HEX); Serial.print(" ");
    }
    Serial.println();
}

void loop() {
    // Kosong
}
```

Struktur File
--------------

```text
EEPROMHandler/
├── examples/
│   └── EEPROMHandlerExample/
│       └── EEPROMHandlerExample.ino
├── src/
│   ├── EEPROMHandler.cpp
│   └── EEPROMHandler.h
├── library.properties
```

Platform yang Didukung
----------------------

- Semua board Arduino (UNO, Mega, Nano, Leonardo, Micro, dsb)
- ESP8266, ESP32
- STM32 (dengan core Arduino)
- Teensy, Seeeduino, dan board lain yang kompatibel dengan Arduino dan mendukung I2C (`Wire.h`)
- Semua IC EEPROM seri AT24Cxx (AT24C01, AT24C02, AT24C04, AT24C08, AT24C16, AT24C32, AT24C64, AT24C128, AT24C256, AT24C512, dst)

**Catatan:**  
Pastikan kapasitas alamat memori yang digunakan sesuai dengan tipe IC EEPROM yang Anda pakai.

Kontribusi
------------

Kontribusi dalam bentuk peningkatan fitur, optimasi, atau pelaporan bug sangat diterima! Anda dapat melakukan pull request atau membuat issue di repository ini untuk membantu meningkatkan kualitas library ini.

Lisensi
--------

Proyek ini dilisensikan di bawah GPL-3.0 License. Anda bebas menggunakan, memodifikasi, dan mendistribusikan library ini sesuai dengan ketentuan lisensi. Perlu diingat bahwa setiap penggunaan, modifikasi, atau pendistribusian harus mematuhi ketentuan lisensi dan menyertakan keterangan tentang sumber asli library ini.

Kontak
--------

Jika Anda memiliki pertanyaan, saran, atau ingin berkontribusi, jangan ragu untuk menghubungi kami melalui email atau issue di GitHub. Kami senang membantu dan menerima umpan balik dari Anda!