<p align="center"><a href="https://netwizard.pro?ref=ghfeature" target="_blank"><img src="https://raw.githubusercontent.com/ayushsharma82/NetWizard/main/docs/netwizard-feature.png" width="1200"></a></p>
<br/>
<p>
<img src="https://img.shields.io/github/last-commit/ayushsharma82/NetWizard.svg?style=for-the-badge" />
&nbsp;
<img src="https://img.shields.io/github/actions/workflow/status/ayushsharma82/NetWizard/ci.yml?branch=main&style=for-the-badge" />
&nbsp;
<img src="https://img.shields.io/github/license/ayushsharma82/NetWizard.svg?style=for-the-badge" />
</p>
<br/>

<b>NetWizard</b> is a user-friendly yet robust WiFi manager and captive portal library for wireless microcontrollers. Eliminate the trouble of hard-coding WiFi credentials by letting NetWizard handle the networking for your device!

Additionally, NetWizard lets you create a custom configuration page of your choice which is shown at the time of setup. The possibilities are endless!

<br/>

## Features

- 🛜 No hard-coded WiFi credentials
- ⚙️ Create a custom configuration page using just C++
- ⚡ Intuitive step-by-step setup flow which makes user interaction easier
- 🎷 No need to learn HTML/CSS/JS
- 🛫 Ready to use within 4-5 lines of code

<br/>

## Supported MCUs

NetWizard works on the following microcontrollers/boards:

- ESP32
- RP2040 + W (Pico W etc.)
- *( more coming soon )*

<br/>

<h2>Documentation</h2>
<p>Learn more about Installation & Usage: <a href="https://docs.netwizard.pro?ref=gitreadme">Click Here</a></p>

<br>

<h2>OSS Preview</h2>
<p>Once you have integrated NetWizard library in your code, you can connect to your device's AP and then this captive portal will pop up for you to configure your device:

<br/>
<br/>

<img src="https://raw.githubusercontent.com/ayushsharma82/NetWizard/main/docs/netwizard-lite-preview.gif" width="1200">

<br/>
<br/>

## Looking for more? Upgrade to Pro

Netwizard Pro comes with the following extended functionality:

- Exclusive Parameters (Password Input, Toggle and more)
- Links
- Statistics
- Whitelabel / Branding
- UI Source
- Softt Commercial License 1.2

<br> <b>Available here: </b>

- [Official Website ( netwizard.pro )](https://netwizard.pro?ref=ghrepo)

<br/>

<a href="https://netwizard.pro?ref=ghpropreview" target="_blank">
  <img src="https://raw.githubusercontent.com/ayushsharma82/NetWizard/main/docs/pro-preview.png" alt="NetWizard Pro" width="1200">
</a>

<br>
<br>

<h2>Contributions</h2>
<p>Every contribution to this repository is highly appreciated! If you spot any bug or problem, open a issue or pull request so that it can be rectified for everyone.</p>

**For feature requests:** Please open a issue and I'll add the feature in a future release once I get some time in my hands.

<br/>

<h2>License</h2>

NetWizard open-source edition is licensed under Affero General Public License v3.0 ( AGPL-3.0 ).

If you are intending to use NetWizard in a commercial project, please consider purchasing [NetWizard Pro](https://netwizard.pro?ref=ghlicense) which comes with a less restrictive SOFTT Commercial License 1.2 (SCL-1.2).
