#ifndef DWIN_DEFINES_H
#define DWIN_DEFINES_H

// --- DGUS II Protocol Headers ---
#define DWIN_HEADER_1           0x5A
#define DWIN_HEADER_2           0xA5

// --- Commands ---
#define CMD_WRITE_VP            0x82 // Write Variable Memory
#define CMD_READ_VP             0x83 // Read Variable Memory
#define CMD_WRITE_CURVE         0x84 // Write Curve Buffer

// --- System Variable Addresses (0x0000 - 0x00FF) ---
// Reference: T5L_DGUSII Application Development Guide, Chapter 5

#define ADDR_SYS_RESET          0x0004 // Reset HMI (Write 0x55AA 0x5AA5)
#define ADDR_RTC_SET            0x009C // Set RTC (Year, Month, Day...)
#define ADDR_RTC_NOW            0x0010 // Read Current RTC
#define ADDR_PIC_NOW            0x0014 // Current Page ID (Read Only)
#define ADDR_TP_STATUS          0x0016 // Touch Status and Coordinate

#define ADDR_BRIGHTNESS         0x0082 // Backlight Brightness (LED_Config)
#define ADDR_PAGE_SWITCH        0x0084 // Page Switching (PIC_Set)
#define ADDR_PWM0_SET           0x0086 // PWM0 Setting
#define ADDR_BUZZER             0x00A0 // Buzzer / Sound Control

#define ADDR_ICL_SWITCH         0x00DE // Background ICL Switch (For Multi-language)
#define ADDR_TP_CALIB           0x0021 // Touch Calibration

// --- Common Colors (RGB565 Format) ---
#define COLOR_BLACK             0x0000
#define COLOR_WHITE             0xFFFF
#define COLOR_RED               0xF800
#define COLOR_GREEN             0x07E0
#define COLOR_BLUE              0x001F
#define COLOR_YELLOW            0xFFE0
#define COLOR_CYAN              0x07FF
#define COLOR_MAGENTA           0xF81F

#endif