/* -------------------------------------------------------------------------- */
/* FILE NAME:   AnalogExpansionAddress.h
   AUTHOR:      Daniele Aimo
   EMAIL:       d.aimo@arduino.cc
   DATE:        20240219
   DESCRIPTION:
   LICENSE:     Copyright (c) 2024 Arduino SA
                his Source Code Form is subject to the terms fo the Mozilla
                Public License (MPL), v 2.0. You can obtain a copy of the MPL
                at http://mozilla.org/MPL/2.0/.
   NOTES:                                                                     */
/* -------------------------------------------------------------------------- */

#ifndef ANALOGEXPANSIONADDRESS
#define ANALOGEXPANSIONADDRESS

#define ANALOG_EXPANSION_ADDRESS 4000

#define ADD_OA_PIN (ANALOG_EXPANSION_ADDRESS + 0)
#define ADD_UPDATE_ANALOG_OUTPUT (ANALOG_EXPANSION_ADDRESS + 1)
#define ADD_FLAG_ADD_ADC_ON_CHANNEL (ANALOG_EXPANSION_ADDRESS + 2)
#define ADD_SET_DEFAULT_VALUE_FLAG  (ANALOG_EXPANSION_ADDRESS + 3)

#define ADD_CH_FUNCTION (ANALOG_EXPANSION_ADDRESS + 4)
#define ADD_OA_PIN_OUTPUT (ANALOG_EXPANSION_ADDRESS + 5)

#define BASE_OA_ADD_BEGIN_FUNCTION (ANALOG_EXPANSION_ADDRESS + 10)
#define ADD_OA_ADC_TYPE (BASE_OA_ADD_BEGIN_FUNCTION + 0)
#define ADD_OA_ADC_USE_PULL_DOWN (BASE_OA_ADD_BEGIN_FUNCTION + 1)
#define ADD_OA_ADC_USE_REJECTION (BASE_OA_ADD_BEGIN_FUNCTION + 2)
#define ADD_OA_ADC_USE_DIAGNOSTIC (BASE_OA_ADD_BEGIN_FUNCTION + 3)
#define ADD_OA_ADC_MOVE_AVERAGE (BASE_OA_ADD_BEGIN_FUNCTION + 4)

#define ADD_OA_DI_USE_FILTER (BASE_OA_ADD_BEGIN_FUNCTION + 5)
#define ADD_OA_DI_INVERT (BASE_OA_ADD_BEGIN_FUNCTION + 6)
#define ADD_OA_DI_SIMPLE_DEB (BASE_OA_ADD_BEGIN_FUNCTION + 7)
#define ADD_OA_DI_SINK_CURRENT (BASE_OA_ADD_BEGIN_FUNCTION + 8)
#define ADD_OA_DI_DEB_TIME (BASE_OA_ADD_BEGIN_FUNCTION + 9)
#define ADD_OA_DI_SCALE_TH_WITH_VCC (BASE_OA_ADD_BEGIN_FUNCTION + 10)
#define ADD_OA_DI_THRESHOLD (BASE_OA_ADD_BEGIN_FUNCTION + 11)
#define ADD_OA_DI_VCC (BASE_OA_ADD_BEGIN_FUNCTION + 12)

#define ADD_OA_RTD_USE_3_WIRES (BASE_OA_ADD_BEGIN_FUNCTION + 13)
#define ADD_OA_RTD_CURRENT (BASE_OA_ADD_BEGIN_FUNCTION + 14)
#define ADD_OA_RTD_TIME (BASE_OA_ADD_BEGIN_FUNCTION + 15)

#define ADD_OA_DAC_TYPE (BASE_OA_ADD_BEGIN_FUNCTION + 16)
#define ADD_OA_DAC_LIMIT_CURRENT (BASE_OA_ADD_BEGIN_FUNCTION + 17)
#define ADD_OA_DAC_USE_SLEW (BASE_OA_ADD_BEGIN_FUNCTION + 18)
#define ADD_OA_DAC_SLEW_RATE (BASE_OA_ADD_BEGIN_FUNCTION + 19)

/* ------------------ PWM ----------------- */
#define BASE_OA_PWM_ADDRESS (BASE_OA_ADD_BEGIN_FUNCTION + 30)
#define ADD_OA_PWM_PERIOD_0 (BASE_OA_PWM_ADDRESS + 0)
#define ADD_OA_PWM_PERIOD_1 (BASE_OA_PWM_ADDRESS + 1)
#define ADD_OA_PWM_PERIOD_2 (BASE_OA_PWM_ADDRESS + 2)
#define ADD_OA_PWM_PERIOD_3 (BASE_OA_PWM_ADDRESS + 3)
#define ADD_OA_PWM_PULSE_0 (BASE_OA_PWM_ADDRESS + 4)
#define ADD_OA_PWM_PULSE_1 (BASE_OA_PWM_ADDRESS + 5)
#define ADD_OA_PWM_PULSE_2 (BASE_OA_PWM_ADDRESS + 6)
#define ADD_OA_PWM_PULSE_3 (BASE_OA_PWM_ADDRESS + 7)

/* ------------------ ADC ----------------- */
#define BASE_OA_ADC_ADDRESS (BASE_OA_PWM_ADDRESS + 10)
#define ADD_OA_ADC_VALUE_0 (BASE_OA_ADC_ADDRESS + 0)
#define ADD_OA_ADC_VALUE_1 (BASE_OA_ADC_ADDRESS + 1)
#define ADD_OA_ADC_VALUE_2 (BASE_OA_ADC_ADDRESS + 2)
#define ADD_OA_ADC_VALUE_3 (BASE_OA_ADC_ADDRESS + 3)
#define ADD_OA_ADC_VALUE_4 (BASE_OA_ADC_ADDRESS + 4)
#define ADD_OA_ADC_VALUE_5 (BASE_OA_ADC_ADDRESS + 5)
#define ADD_OA_ADC_VALUE_6 (BASE_OA_ADC_ADDRESS + 6)
#define ADD_OA_ADC_VALUE_7 (BASE_OA_ADC_ADDRESS + 7)
/* ------------------ DAC ----------------- */
#define BASE_OA_DAC_ADDRESS (BASE_OA_ADC_ADDRESS + 10)
#define ADD_OA_DAC_VALUE_0 (BASE_OA_DAC_ADDRESS + 0)
#define ADD_OA_DAC_VALUE_1 (BASE_OA_DAC_ADDRESS + 1)
#define ADD_OA_DAC_VALUE_2 (BASE_OA_DAC_ADDRESS + 2)
#define ADD_OA_DAC_VALUE_3 (BASE_OA_DAC_ADDRESS + 3)
#define ADD_OA_DAC_VALUE_4 (BASE_OA_DAC_ADDRESS + 4)
#define ADD_OA_DAC_VALUE_5 (BASE_OA_DAC_ADDRESS + 5)
#define ADD_OA_DAC_VALUE_6 (BASE_OA_DAC_ADDRESS + 6)
#define ADD_OA_DAC_VALUE_7 (BASE_OA_DAC_ADDRESS + 7)
/* ------------------ RTD ----------------- */
#define BASE_OA_RTD_ADDRESS (BASE_OA_DAC_ADDRESS + 10)
#define ADD_OA_RTD_VALUE_0 (BASE_OA_RTD_ADDRESS + 0)
#define ADD_OA_RTD_VALUE_1 (BASE_OA_RTD_ADDRESS + 1)
#define ADD_OA_RTD_VALUE_2 (BASE_OA_RTD_ADDRESS + 2)
#define ADD_OA_RTD_VALUE_3 (BASE_OA_RTD_ADDRESS + 3)
#define ADD_OA_RTD_VALUE_4 (BASE_OA_RTD_ADDRESS + 4)
#define ADD_OA_RTD_VALUE_5 (BASE_OA_RTD_ADDRESS + 5)
#define ADD_OA_RTD_VALUE_6 (BASE_OA_RTD_ADDRESS + 6)
#define ADD_OA_RTD_VALUE_7 (BASE_OA_RTD_ADDRESS + 7)
/* ------------------ DI ----------------- */
#define BASE_OA_DI_ADDRESS (BASE_OA_RTD_ADDRESS + 10)
#define ADD_OA_DI_VALUE_0 (BASE_OA_DI_ADDRESS + 0)
#define ADD_OA_DI_VALUE_1 (BASE_OA_DI_ADDRESS + 1)
#define ADD_OA_DI_VALUE_2 (BASE_OA_DI_ADDRESS + 2)
#define ADD_OA_DI_VALUE_3 (BASE_OA_DI_ADDRESS + 3)
#define ADD_OA_DI_VALUE_4 (BASE_OA_DI_ADDRESS + 4)
#define ADD_OA_DI_VALUE_5 (BASE_OA_DI_ADDRESS + 5)
#define ADD_OA_DI_VALUE_6 (BASE_OA_DI_ADDRESS + 6)
#define ADD_OA_DI_VALUE_7 (BASE_OA_DI_ADDRESS + 7)
#define ADD_OA_DI_VALUE (BASE_OA_DI_ADDRESS + 8)
/* ------------------ LED ----------------- */
#define BASE_OA_LED_ADDRESS (BASE_OA_DI_ADDRESS + 10)
#define ADD_OA_LED_PIN_0 (BASE_OA_LED_ADDRESS + 0)
#define ADD_OA_LED_PIN_1 (BASE_OA_LED_ADDRESS + 1)
#define ADD_OA_LED_PIN_2 (BASE_OA_LED_ADDRESS + 2)
#define ADD_OA_LED_PIN_3 (BASE_OA_LED_ADDRESS + 3)
#define ADD_OA_LED_PIN_4 (BASE_OA_LED_ADDRESS + 4)
#define ADD_OA_LED_PIN_5 (BASE_OA_LED_ADDRESS + 5)
#define ADD_OA_LED_PIN_6 (BASE_OA_LED_ADDRESS + 6)
#define ADD_OA_LED_PIN_7 (BASE_OA_LED_ADDRESS + 7)
#define ADD_OA_LED_VALUE (BASE_OA_LED_ADDRESS + 8)
/* ------------  TIMEOUT -----------------------*/
#define BASE_TIMEOUT_ADDRESS        (BASE_OA_LED_ADDRESS + 10)
#define ADD_OA_TIMEOUT_ADDRESS      (BASE_TIMEOUT_ADDRESS + 0)


#endif
