/*
    This file is part of the Arduino_AlvikCarrier library.

    Copyright (c) 2024 Arduino SA

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
    
*/

#ifndef __ARDUINO_APDS9999_h__
#define __ARDUINO_APDS9999_h__

#include <Arduino.h>
#include <Wire.h>

#define APDS9999_ADDRESS          0x52
#define APDS9999_MAIN_CTRL        0x00
#define APDS9999_SOFT_RST         0x01
#define APDS9999_LS_ENABLE        0x02
#define APDS9999_PS_ENABLE        0x01
#define APDS9999_CS_ENABLE        0x04
#define APDS9999_IR_DATA          0x0A
#define APDS9999_RED_DATA         0x13
#define APDS9999_GREEN_DATA       0x0D
#define APDS9999_BLUE_DATA        0x10
#define APDS9999_PS_DATA_L        0x08
#define APDS9999_PS_DATA_H        0x09
#define APDS9999_ID               0x06
#define APDS9999_DEFAULT_ID       0xC2
#define APDS9999_LS_GAIN          0x05
#define APDS9999_GAIN_1X          0x00
#define APDS9999_GAIN_3X          0x01
#define APDS9999_GAIN_6X          0x02
#define APDS9999_GAIN_9X          0x03
#define APDS9999_GAIN_18X         0x04
#define APDS9999_LS_MEAS_R        0x04
#define APDS9999_LS_RES_13B       0x05
#define APDS9999_LS_RES_16B       0x04
#define APDS9999_LS_RES_17B       0x03
#define APDS9999_LS_RES_18B       0x02
#define APDS9999_LS_RES_19B       0x01
#define APDS9999_LS_RES_20B       0x00
#define APDS9999_LS_RATE_25MS     0x00
#define APDS9999_LS_RATE_50MS     0x01
#define APDS9999_LS_RATE_100MS    0x02
#define APDS9999_LS_RATE_200MS    0x03
#define APDS9999_LS_RATE_500MS    0x04
#define APDS9999_LS_RATE_1000MS   0x05
#define APDS9999_LS_RATE_2000MS   0x06
#define APDS9999_PS_MEAS_R        0x05
#define APDS9999_PS_RES_8B        0x00
#define APDS9999_PS_RES_9B        0x01
#define APDS9999_PS_RES_10B       0x02
#define APDS9999_PS_RES_11B       0x03
#define APDS9999_PS_RATE_6_25MS   0x01
#define APDS9999_PS_RATE_12_5MS   0x02
#define APDS9999_PS_RATE_25MS     0x03
#define APDS9999_PS_RATE_50MS     0x04
#define APDS9999_PS_RATE_100MS    0x05
#define APDS9999_PS_RATE_200MS    0x06
#define APDS9999_PS_RATE_400MS    0x07


















class Arduino_APDS9999{
  public:
    Arduino_APDS9999(TwoWire & wire = Wire);

    int begin();
    void end();

    void enableLightSensor();
    void disableLightSensor();
    void enableColorSensor();
    void disableColorSensor();
    void enableProximitySensor();
    void disableProximitySensor();

    void setGain(const uint8_t gain = APDS9999_GAIN_3X);
    void setLSResolution(const uint8_t resolution = APDS9999_LS_RES_18B);
    void setLSRate(const uint8_t rate = APDS9999_LS_RATE_100MS);
    void setPSResolution(const uint8_t resolution = APDS9999_PS_RES_8B);
    void setPSRate(const uint8_t rate = APDS9999_PS_RATE_100MS);

    int getIR();
    int getRed();
    int getGreen();
    int getBlue();
    void readColor(int & red, int & green, int & blue);
    void readColor(int & red, int & green, int & blue, int & ir);
    int getProximity();

    uint8_t getID();


  private:
    TwoWire & _wire;

    void writeRegister(uint8_t reg, uint8_t value);
    uint8_t readRegister(uint8_t reg);
    uint32_t readRegister24(uint8_t reg);
};


#endif