// sans8.cpp - Bitmap data for a font: 10 pixel high (A=8px,x=6px), variable width, sans serif
// Reused from https://github.com/bonezegei/Bonezegei_SSD1306/blob/main/src/arial8.h


#include <stdint.h>


static const uint8_t toled_sans8_bmp[] = {
  
  // @0 ' ' (4 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @10 '!' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x80, // #
  0x00, //
  0x00, //

  // @20 '"' (3 pixels wide)
  0xA0, // # #
  0xA0, // # #
  0xA0, // # #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @30 '#' (5 pixels wide)
  0x28, //   # #
  0x28, //   # #
  0xF8, // #####
  0x50, //  # #
  0x50, //  # #
  0xF8, // #####
  0xA0, // # #
  0xA0, // # #
  0x00, //
  0x00, //

  // @40 '$' (5 pixels wide)
  0x70, //  ###
  0xA8, // # # #
  0xA0, // # #
  0x70, //  ###
  0x28, //   # #
  0x28, //   # #
  0xA8, // # # #
  0x70, //  ###
  0x20, //   #
  0x00, //

  // @50 '%' (9 pixels wide)
  0x62, 0x00, //  ##   #
  0x94, 0x00, // #  # #
  0x94, 0x00, // #  # #
  0x68, 0x00, //  ## #
  0x0B, 0x00, //     # ##
  0x14, 0x80, //    # #  #
  0x14, 0x80, //    # #  #
  0x23, 0x00, //   #   ##
  0x00, 0x00, //
  0x00, 0x00, //

  // @70 '&' (6 pixels wide)
  0x30, //   ##
  0x48, //  #  #
  0x48, //  #  #
  0x30, //   ##
  0x50, //  # #
  0x8C, // #   ##
  0x88, // #   #
  0x74, //  ### #
  0x00, //
  0x00, //

  // @80 ''' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @90 '(' (3 pixels wide)
  0x20, //   #
  0x40, //  #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x40, //  #
  0x20, //   #

  // @100 ')' (3 pixels wide)
  0x80, // #
  0x40, //  #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x40, //  #
  0x80, // #

  // @110 '*' (3 pixels wide)
  0x40, //  #
  0xE0, // ###
  0x40, //  #
  0xA0, // # #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @120 '+' (5 pixels wide)
  0x00, //
  0x00, //
  0x20, //   #
  0x20, //   #
  0xF8, // #####
  0x20, //   #
  0x20, //   #
  0x00, //
  0x00, //
  0x00, //

  // @130 ',' (1 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x80, // #
  0x80, // #
  0x80, // #

  // @140 '-' (3 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0xE0, // ###
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @150 '.' (1 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x80, // #
  0x00, //
  0x00, //

  // @160 '/' (3 pixels wide)
  0x20, //   #
  0x20, //   #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @170 '0' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @180 '1' (3 pixels wide)
  0x20, //   #
  0x60, //  ##
  0xA0, // # #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x00, //
  0x00, //

  // @190 '2' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x08, //     #
  0x08, //     #
  0x10, //    #
  0x20, //   #
  0x40, //  #
  0xF8, // #####
  0x00, //
  0x00, //

  // @200 '3' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x08, //     #
  0x30, //   ##
  0x08, //     #
  0x08, //     #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @210 '4' (5 pixels wide)
  0x10, //    #
  0x30, //   ##
  0x50, //  # #
  0x50, //  # #
  0x90, // #  #
  0xF8, // #####
  0x10, //    #
  0x10, //    #
  0x00, //
  0x00, //

  // @220 '5' (5 pixels wide)
  0x78, //  ####
  0x40, //  #
  0x80, // #
  0xF0, // ####
  0x08, //     #
  0x08, //     #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @230 '6' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x80, // #
  0xF0, // ####
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @240 '7' (5 pixels wide)
  0xF8, // #####
  0x10, //    #
  0x10, //    #
  0x20, //   #
  0x20, //   #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x00, //
  0x00, //

  // @250 '8' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x88, // #   #
  0x70, //  ###
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @260 '9' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x78, //  ####
  0x08, //     #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @270 ':' (1 pixels wide)
  0x00, //
  0x00, //
  0x80, // #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x80, // #
  0x00, //
  0x00, //

  // @280 ';' (1 pixels wide)
  0x00, //
  0x00, //
  0x80, // #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x80, // #
  0x80, // #
  0x80, // #

  // @290 '<' (5 pixels wide) - patched by Maarten
  0x00, //
  0x00, //
  0x18, //    ##
  0x60, //  ##
  0x80, // #
  0x60, //  ##
  0x18, //    ##
  0x00, //
  0x00, //
  0x00, //

  // @300 '=' (5 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0xF8, // #####
  0x00, //
  0xF8, // #####
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @310 '>' (5 pixels wide) - patched by Maarten
  0x00, //
  0x00, //
  0xC0, // ##
  0x30, //   ##
  0x08, //     #
  0x30, //   ##
  0xC0, // ##
  0x00, //
  0x00, //
  0x00, //

  // @320 '?' (5 pixels wide)
  0x70, //  ###
  0x88, // #   #
  0x08, //     #
  0x10, //    #
  0x20, //   #
  0x20, //   #
  0x00, //
  0x20, //   #
  0x00, //
  0x00, //

  // @330 '@' (10 pixels wide)
  0x1F, 0x00, //    #####
  0x60, 0x80, //  ##     #
  0x4D, 0x40, //  #  ## # #
  0x93, 0x40, // #  #  ## #
  0xA2, 0x40, // # #   #  #
  0xA2, 0x40, // # #   #  #
  0xA6, 0x80, // # #  ## #
  0x9B, 0x00, // #  ## ##
  0x40, 0x40, //  #       #
  0x3F, 0x80, //   #######

  // @350 'A' (7 pixels wide)
  0x10, //    #
  0x28, //   # #
  0x28, //   # #
  0x28, //   # #
  0x44, //  #   #
  0x7C, //  #####
  0x82, // #     #
  0x82, // #     #
  0x00, //
  0x00, //

  // @360 'B' (6 pixels wide)
  0xF8, // #####
  0x84, // #    #
  0x84, // #    #
  0xFC, // ######
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0xF8, // #####
  0x00, //
  0x00, //

  // @370 'C' (6 pixels wide)
  0x38, //   ###
  0x44, //  #   #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x44, //  #   #
  0x38, //   ###
  0x00, //
  0x00, //

  // @380 'D' (6 pixels wide)
  0xF0, // ####
  0x88, // #   #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x88, // #   #
  0xF0, // ####
  0x00, //
  0x00, //

  // @390 'E' (5 pixels wide)
  0xF8, // #####
  0x80, // #
  0x80, // #
  0xF8, // #####
  0x80, // #
  0x80, // #
  0x80, // #
  0xF8, // #####
  0x00, //
  0x00, //

  // @400 'F' (5 pixels wide)
  0xF8, // #####
  0x80, // #
  0x80, // #
  0xF0, // ####
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @410 'G' (7 pixels wide)
  0x38, //   ###
  0x44, //  #   #
  0x82, // #     #
  0x80, // #
  0x8E, // #   ###
  0x82, // #     #
  0x44, //  #   #
  0x38, //   ###
  0x00, //
  0x00, //

  // @420 'H' (6 pixels wide)
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0xFC, // ######
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x00, //
  0x00, //

  // @430 'I' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @440 'J' (4 pixels wide)
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x90, // #  #
  0x90, // #  #
  0x60, //  ##
  0x00, //
  0x00, //

  // @450 'K' (6 pixels wide)
  0x84, // #    #
  0x88, // #   #
  0x90, // #  #
  0xB0, // # ##
  0xD0, // ## #
  0x88, // #   #
  0x88, // #   #
  0x84, // #    #
  0x00, //
  0x00, //

  // @460 'L' (5 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0xF8, // #####
  0x00, //
  0x00, //

  // @470 'M' (7 pixels wide)
  0x82, // #     #
  0xC6, // ##   ##
  0xC6, // ##   ##
  0xAA, // # # # #
  0xAA, // # # # #
  0xAA, // # # # #
  0x92, // #  #  #
  0x92, // #  #  #
  0x00, //
  0x00, //

  // @480 'N' (6 pixels wide)
  0x84, // #    #
  0xC4, // ##   #
  0xA4, // # #  #
  0xA4, // # #  #
  0x94, // #  # #
  0x94, // #  # #
  0x8C, // #   ##
  0x84, // #    #
  0x00, //
  0x00, //

  // @490 'O' (7 pixels wide)
  0x38, //   ###
  0x44, //  #   #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   #
  0x38, //   ###
  0x00, //
  0x00, //

  // @500 'P' (5 pixels wide)
  0xF0, // ####
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0xF0, // ####
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @510 'Q' (7 pixels wide)
  0x38, //   ###
  0x44, //  #   #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x9A, // #  ## #
  0x44, //  #   #
  0x3A, //   ### #
  0x00, //
  0x00, //

  // @520 'R' (6 pixels wide)
  0xF8, // #####
  0x84, // #    #
  0x84, // #    #
  0xF8, // #####
  0x90, // #  #
  0x88, // #   #
  0x88, // #   #
  0x84, // #    #
  0x00, //
  0x00, //

  // @530 'S' (6 pixels wide)
  0x78, //  ####
  0x84, // #    #
  0x80, // #
  0x60, //  ##
  0x18, //    ##
  0x04, //      #
  0x84, // #    #
  0x78, //  ####
  0x00, //
  0x00, //

  // @540 'T' (5 pixels wide)
  0xF8, // #####
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x00, //
  0x00, //

  // @550 'U' (6 pixels wide)
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  ####
  0x00, //
  0x00, //

  // @560 'V' (7 pixels wide)
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   #
  0x44, //  #   #
  0x28, //   # #
  0x28, //   # #
  0x10, //    #
  0x10, //    #
  0x00, //
  0x00, //

  // @570 'W' (11 pixels wide)
  0x84, 0x20, // #    #    #
  0x8A, 0x20, // #   # #   #
  0x4A, 0x40, //  #  # #  #
  0x4A, 0x40, //  #  # #  #
  0x51, 0x40, //  # #   # #
  0x51, 0x40, //  # #   # #
  0x20, 0x80, //   #     #
  0x20, 0x80, //   #     #
  0x00, 0x00, //
  0x00, 0x00, //

  // @590 'X' (6 pixels wide)
  0x84, // #    #
  0x48, //  #  #
  0x48, //  #  #
  0x30, //   ##
  0x30, //   ##
  0x48, //  #  #
  0x48, //  #  #
  0x84, // #    #
  0x00, //
  0x00, //

  // @600 'Y' (7 pixels wide)
  0x82, // #     #
  0x44, //  #   #
  0x44, //  #   #
  0x28, //   # #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x00, //
  0x00, //

  // @610 'Z' (6 pixels wide)
  0x7C, //  #####
  0x08, //     #
  0x10, //    #
  0x10, //    #
  0x20, //   #
  0x20, //   #
  0x40, //  #
  0xFC, // ######
  0x00, //
  0x00, //

  // @620 '[' (2 pixels wide)
  0xC0, // ##
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0xC0, // ##

  // @630 '\' (3 pixels wide)
  0x80, // #
  0x80, // #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x20, //   #
  0x20, //   #
  0x00, //
  0x00, //

  // @640 ']' (2 pixels wide)
  0xC0, // ##
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0xC0, // ##

  // @650 '^' (5 pixels wide)
  0x20, //   #
  0x50, //  # #
  0x50, //  # #
  0x88, // #   #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @660 '_' (6 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0xFC, // ######

  // @670 '`' (2 pixels wide)
  0x80, // #
  0x40, //  #
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //

  // @680 'a' (5 pixels wide)
  0x00, //
  0x00, //
  0x70, //  ###
  0x88, // #   #
  0x78, //  ####
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x00, //
  0x00, //

  // @690 'b' (5 pixels wide)
  0x80, // #
  0x80, // #
  0xB0, // # ##
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0xC8, // ##  #
  0xB0, // # ##
  0x00, //
  0x00, //

  // @700 'c' (5 pixels wide)
  0x00, //
  0x00, //
  0x70, //  ###
  0x88, // #   #
  0x80, // #
  0x80, // #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @710 'd' (5 pixels wide)
  0x08, //     #
  0x08, //     #
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x00, //
  0x00, //

  // @720 'e' (5 pixels wide)
  0x00, //
  0x00, //
  0x70, //  ###
  0x88, // #   #
  0xF8, // #####
  0x80, // #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @730 'f' (3 pixels wide)
  0x20, //   #
  0x40, //  #
  0xE0, // ###
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x00, //
  0x00, //

  // @740 'g' (5 pixels wide)
  0x00, //
  0x00, //
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x08, //     #
  0xF0, // ####

  // @750 'h' (5 pixels wide)
  0x80, // #
  0x80, // #
  0xB0, // # ##
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x00, //
  0x00, //

  // @760 'i' (1 pixels wide)
  0x80, // #
  0x00, //
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @770 'j' (2 pixels wide)
  0x40, //  #
  0x00, //
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x80, // #

  // @780 'k' (4 pixels wide)
  0x80, // #
  0x80, // #
  0x90, // #  #
  0xA0, // # #
  0xC0, // ##
  0xA0, // # #
  0xA0, // # #
  0x90, // #  #
  0x00, //
  0x00, //

  // @790 'l' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @800 'm' (7 pixels wide)
  0x00, //
  0x00, //
  0xBC, // # ####
  0xD2, // ## #  #
  0x92, // #  #  #
  0x92, // #  #  #
  0x92, // #  #  #
  0x92, // #  #  #
  0x00, //
  0x00, //

  // @810 'n' (5 pixels wide)
  0x00, //
  0x00, //
  0xF0, // ####
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x00, //
  0x00, //

  // @820 'o' (5 pixels wide)
  0x00, //
  0x00, //
  0x70, //  ###
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @830 'p' (5 pixels wide)
  0x00, //
  0x00, //
  0xB0, // # ##
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0xC8, // ##  #
  0xB0, // # ##
  0x80, // #
  0x80, // #

  // @840 'q' (5 pixels wide)
  0x00, //
  0x00, //
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x08, //     #
  0x08, //     #

  // @850 'r' (3 pixels wide)
  0x00, //
  0x00, //
  0xA0, // # #
  0xC0, // ##
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //
  0x00, //

  // @860 's' (5 pixels wide)
  0x00, //
  0x00, //
  0x70, //  ###
  0x88, // #   #
  0x60, //  ##
  0x10, //    #
  0x88, // #   #
  0x70, //  ###
  0x00, //
  0x00, //

  // @870 't' (3 pixels wide)
  0x40, //  #
  0x40, //  #
  0xE0, // ###
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x60, //  ##
  0x00, //
  0x00, //

  // @880 'u' (5 pixels wide)
  0x00, //
  0x00, //
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x00, //
  0x00, //

  // @890 'v' (5 pixels wide)
  0x00, //
  0x00, //
  0x88, // #   #
  0x88, // #   #
  0x50, //  # #
  0x50, //  # #
  0x20, //   #
  0x20, //   #
  0x00, //
  0x00, //

  // @900 'w' (9 pixels wide)
  0x00, 0x00, //
  0x00, 0x00, //
  0x88, 0x80, // #   #   #
  0x94, 0x80, // #  # #  #
  0x55, 0x00, //  # # # #
  0x55, 0x00, //  # # # #
  0x22, 0x00, //   #   #
  0x22, 0x00, //   #   #
  0x00, 0x00, //
  0x00, 0x00, //

  // @920 'x' (5 pixels wide)
  0x00, //
  0x00, //
  0x88, // #   #
  0x50, //  # #
  0x20, //   #
  0x20, //   #
  0x50, //  # #
  0x88, // #   #
  0x00, //
  0x00, //

  // @930 'y' (5 pixels wide)
  0x00, //
  0x00, //
  0x88, // #   #
  0x88, // #   #
  0x50, //  # #
  0x50, //  # #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x40, //  #

  // @940 'z' (5 pixels wide)
  0x00, //
  0x00, //
  0xF8, // #####
  0x10, //    #
  0x20, //   #
  0x20, //   #
  0x40, //  #
  0xF8, // #####
  0x00, //
  0x00, //

  // @950 '{' (3 pixels wide)
  0x20, //   #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x80, // #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x20, //   #

  // @960 '|' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #

  // @970 '}' (3 pixels wide)
  0x80, // #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x20, //   #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x80, // #

  // @980 '~' (5 pixels wide)
  0x00, //
  0x00, //
  0x00, //
  0xE8, // ### #
  0xB0, // # ##
  0x00, //
  0x00, //
  0x00, //
  0x00, //
  0x00, //
};


// Font descriptor: dsc[ch][0] width of ch, dsc[ch][1] height of ch, dsc[ch][2] offset in toled_sans8_bmp of ch
static const int toled_sans8_dsc[95][3] = {
  {4, 10, 0},     //
  {1, 10, 10},    // !
  {3, 10, 20},    // "
  {5, 10, 30},    // #
  {5, 10, 40},    // $
  {9, 10, 50},    // %
  {6, 10, 70},    // &
  {1, 10, 80},    // '
  {3, 10, 90},    // (
  {3, 10, 100},     // )
  {3, 10, 110},     // *
  {5, 10, 120},     // +
  {1, 10, 130},     // ,
  {3, 10, 140},     // -
  {1, 10, 150},     // .
  {3, 10, 160},     // /
  {5, 10, 170},     // 0
  {3, 10, 180},     // 1
  {5, 10, 190},     // 2
  {5, 10, 200},     // 3
  {5, 10, 210},     // 4
  {5, 10, 220},     // 5
  {5, 10, 230},     // 6
  {5, 10, 240},     // 7
  {5, 10, 250},     // 8
  {5, 10, 260},     // 9
  {1, 10, 270},     // :
  {1, 10, 280},     // ;
  {5, 10, 290},     // <
  {5, 10, 300},     // =
  {5, 10, 310},     // >
  {5, 10, 320},     // ?
  {10, 10, 330},    // @
  {7, 10, 350},     // A
  {6, 10, 360},     // B
  {6, 10, 370},     // C
  {6, 10, 380},     // D
  {5, 10, 390},     // E
  {5, 10, 400},     // F
  {7, 10, 410},     // G
  {6, 10, 420},     // H
  {1, 10, 430},     // I
  {4, 10, 440},     // J
  {6, 10, 450},     // K
  {5, 10, 460},     // L
  {7, 10, 470},     // M
  {6, 10, 480},     // N
  {7, 10, 490},     // O
  {5, 10, 500},     // P
  {7, 10, 510},     // Q
  {6, 10, 520},     // R
  {6, 10, 530},     // S
  {5, 10, 540},     // T
  {6, 10, 550},     // U
  {7, 10, 560},     // V
  {11, 10, 570},    // W
  {6, 10, 590},     // X
  {7, 10, 600},     // Y
  {6, 10, 610},     // Z
  {2, 10, 620},     // [
  {3, 10, 630},     //
  {2, 10, 640},     // ]
  {5, 10, 650},     // ^
  {6, 10, 660},     // _
  {2, 10, 670},     // `
  {5, 10, 680},     // a
  {5, 10, 690},     // b
  {5, 10, 700},     // c
  {5, 10, 710},     // d
  {5, 10, 720},     // e
  {3, 10, 730},     // f
  {5, 10, 740},     // g
  {5, 10, 750},     // h
  {1, 10, 760},     // i
  {2, 10, 770},     // j
  {4, 10, 780},     // k
  {1, 10, 790},     // l
  {7, 10, 800},     // m
  {5, 10, 810},     // n
  {5, 10, 820},     // o
  {5, 10, 830},     // p
  {5, 10, 840},     // q
  {3, 10, 850},     // r
  {5, 10, 860},     // s
  {3, 10, 870},     // t
  {5, 10, 880},     // u
  {5, 10, 890},     // v
  {9, 10, 900},     // w
  {5, 10, 920},     // x
  {5, 10, 930},     // y
  {5, 10, 940},     // z
  {3, 10, 950},     // {
  {1, 10, 960},     // |
  {3, 10, 970},     // }
  {5, 10, 980},     // ~
};


void toled_sans8(char ch, int * width, int * height, const uint8_t ** bmp ) {
  if( ch<' ' || ch> '~' ) {
    *width = 0;
    *height= 0;
    *bmp   = 0;
  } else {
    int ix = ch - ' ';
    *width = toled_sans8_dsc[ix][0];
    *height= toled_sans8_dsc[ix][1];
    *bmp   = &toled_sans8_bmp[ toled_sans8_dsc[ix][2] ];
  }
}
