// sans12px.cpp - Bitmap data for a font: 16 pixel high (A=12px,x=9px), variable width, sans serif
// Reused from https://github.com/bonezegei/Bonezegei_SSD1306/blob/main/src/arial12.h


#include <stdint.h>


static const uint8_t toled_sans12_bmp[] = {

  // @0 ' ' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     

  // @16 '!' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @32 '"' (4 pixels wide)
  0x00, //     
  0x90, // #  #
  0x90, // #  #
  0x90, // #  #
  0x90, // #  #
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     

  // @48 '#' (9 pixels wide)
  0x00, 0x00, //          
  0x11, 0x00, //    #   # 
  0x11, 0x00, //    #   # 
  0x11, 0x00, //    #   # 
  0x22, 0x00, //   #   #  
  0xFF, 0x80, // #########
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0xFF, 0x80, // #########
  0x44, 0x00, //  #   #   
  0x44, 0x00, //  #   #   
  0x44, 0x00, //  #   #   
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @80 '$' (7 pixels wide)
  0x10, //    #   
  0x3C, //   #### 
  0x52, //  # #  #
  0x92, // #  #  #
  0x90, // #  #   
  0x90, // #  #   
  0x70, //  ###   
  0x1C, //    ### 
  0x12, //    #  #
  0x12, //    #  #
  0x92, // #  #  #
  0x54, //  # # # 
  0x38, //   ###  
  0x10, //    #   
  0x00, //        
  0x00, //        

  // @96 '%' (12 pixels wide)
  0x00, 0x00, //             
  0x70, 0x80, //  ###    #   
  0x89, 0x00, // #   #  #    
  0x89, 0x00, // #   #  #    
  0x8A, 0x00, // #   # #     
  0x8A, 0x00, // #   # #     
  0x72, 0x00, //  ###  #     
  0x04, 0xE0, //      #  ### 
  0x05, 0x10, //      # #   #
  0x09, 0x10, //     #  #   #
  0x09, 0x10, //     #  #   #
  0x11, 0x10, //    #   #   #
  0x10, 0xE0, //    #    ### 
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             

  // @128 '&' (9 pixels wide)
  0x00, 0x00, //          
  0x38, 0x00, //   ###    
  0x44, 0x00, //  #   #   
  0x44, 0x00, //  #   #   
  0x44, 0x00, //  #   #   
  0x28, 0x00, //   # #    
  0x30, 0x00, //   ##     
  0x50, 0x00, //  # #     
  0x88, 0x80, // #   #   #
  0x85, 0x00, // #    # # 
  0x82, 0x00, // #     #  
  0x45, 0x00, //  #   # # 
  0x38, 0x80, //   ###   #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @160 ''' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  

  // @176 '(' (3 pixels wide)
  0x00, //    
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x20, //   #

  // @192 ')' (3 pixels wide)
  0x00, //    
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x80, // #  

  // @208 '*' (5 pixels wide)
  0x00, //      
  0x20, //   #  
  0xF8, // #####
  0x20, //   #  
  0x50, //  # # 
  0x50, //  # # 
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @224 '+' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0xFE, // #######
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @240 ',' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  

  // @256 '-' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0xF0, // ####
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     

  // @272 '.' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @288 '/' (4 pixels wide)
  0x00, //     
  0x10, //    #
  0x10, //    #
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x80, // #   
  0x80, // #   
  0x00, //     
  0x00, //     
  0x00, //     

  // @304 '0' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @320 '1' (4 pixels wide)
  0x00, //     
  0x10, //    #
  0x30, //   ##
  0x50, //  # #
  0x90, // #  #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x10, //    #
  0x00, //     
  0x00, //     
  0x00, //     

  // @336 '2' (7 pixels wide)
  0x00, //        
  0x3C, //   #### 
  0x44, //  #   # 
  0x82, // #     #
  0x02, //       #
  0x02, //       #
  0x04, //      # 
  0x04, //      # 
  0x08, //     #  
  0x10, //    #   
  0x20, //   #    
  0x40, //  #     
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        

  // @352 '3' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x84, // #    # 
  0x04, //      # 
  0x0C, //     ## 
  0x38, //   ###  
  0x04, //      # 
  0x02, //       #
  0x02, //       #
  0x82, // #     #
  0xC4, // ##   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @368 '4' (8 pixels wide)
  0x00, //         
  0x02, //       # 
  0x06, //      ## 
  0x0A, //     # # 
  0x12, //    #  # 
  0x12, //    #  # 
  0x22, //   #   # 
  0x42, //  #    # 
  0x82, // #     # 
  0xFF, // ########
  0x02, //       # 
  0x02, //       # 
  0x02, //       # 
  0x00, //         
  0x00, //         
  0x00, //         

  // @384 '5' (7 pixels wide)
  0x00, //        
  0x7E, //  ######
  0x40, //  #     
  0x40, //  #     
  0x80, // #      
  0xF8, // #####  
  0x84, // #    # 
  0x02, //       #
  0x02, //       #
  0x02, //       #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @400 '6' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x80, // #      
  0xB8, // # ###  
  0xC4, // ##   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @416 '7' (7 pixels wide)
  0x00, //        
  0xFE, // #######
  0x04, //      # 
  0x04, //      # 
  0x08, //     #  
  0x08, //     #  
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x20, //   #    
  0x20, //   #    
  0x20, //   #    
  0x00, //        
  0x00, //        
  0x00, //        

  // @432 '8' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @448 '9' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x46, //  #   ##
  0x3A, //   ### #
  0x02, //       #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @464 ':' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @480 ';' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  

  // @496 '<' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x02, //       #
  0x1C, //    ### 
  0x60, //  ##    
  0x80, // #      
  0x60, //  ##    
  0x1C, //    ### 
  0x02, //       #
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @512 '=' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @528 '>' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x80, // #      
  0x70, //  ###   
  0x0C, //     ## 
  0x02, //       #
  0x0C, //     ## 
  0x70, //  ###   
  0x80, // #      
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @544 '?' (7 pixels wide)
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x02, //       #
  0x04, //      # 
  0x08, //     #  
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        

  // @560 '@' (15 pixels wide)
  0x00, 0x00, //                
  0x07, 0xE0, //      ######    
  0x18, 0x18, //    ##      ##  
  0x20, 0x04, //   #          # 
  0x43, 0xA4, //  #    ### #  # 
  0x44, 0x62, //  #   #   ##   #
  0x88, 0x22, // #   #     #   #
  0x90, 0x22, // #  #      #   #
  0x90, 0x42, // #  #     #    #
  0x90, 0x42, // #  #     #    #
  0x90, 0x44, // #  #     #   # 
  0x88, 0xC8, // #   #   ##  #  
  0x47, 0x70, //  #   ### ###   
  0x20, 0x02, //   #           #
  0x18, 0x0C, //    ##       ## 
  0x07, 0xF0, //      #######   

  // @592 'A' (9 pixels wide)
  0x00, 0x00, //          
  0x08, 0x00, //     #    
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x7F, 0x00, //  ####### 
  0x41, 0x00, //  #     # 
  0x41, 0x00, //  #     # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @624 'B' (9 pixels wide)
  0x00, 0x00, //          
  0xFF, 0x00, // ######## 
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x81, 0x00, // #      # 
  0xFE, 0x00, // #######  
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x81, 0x00, // #      # 
  0xFE, 0x00, // #######  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @656 'C' (10 pixels wide)
  0x00, 0x00, //           
  0x1F, 0x00, //    #####  
  0x20, 0x80, //   #     # 
  0x40, 0x40, //  #       #
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x40, 0x40, //  #       #
  0x20, 0x80, //   #     # 
  0x1F, 0x00, //    #####  
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @688 'D' (10 pixels wide)
  0x00, 0x00, //           
  0xFE, 0x00, // #######   
  0x81, 0x00, // #      #  
  0x80, 0x80, // #       # 
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x80, // #       # 
  0x81, 0x00, // #      #  
  0xFE, 0x00, // #######   
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @720 'E' (9 pixels wide)
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0xFF, 0x00, // ######## 
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @752 'F' (8 pixels wide)
  0x00, //         
  0xFF, // ########
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0xFE, // ####### 
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0x80, // #       
  0x00, //         
  0x00, //         
  0x00, //         

  // @768 'G' (10 pixels wide)
  0x00, 0x00, //           
  0x1E, 0x00, //    ####   
  0x21, 0x00, //   #    #  
  0x40, 0x80, //  #      # 
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x80, 0x00, // #         
  0x87, 0xC0, // #    #####
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x40, 0x80, //  #      # 
  0x21, 0x00, //   #    #  
  0x1E, 0x00, //    ####   
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @800 'H' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0xFF, 0x80, // #########
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @832 'I' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @848 'J' (6 pixels wide)
  0x00, //       
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @864 'K' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0x81, 0x00, // #      # 
  0x82, 0x00, // #     #  
  0x84, 0x00, // #    #   
  0x88, 0x00, // #   #    
  0x98, 0x00, // #  ##    
  0xA8, 0x00, // # # #    
  0xC4, 0x00, // ##   #   
  0x82, 0x00, // #     #  
  0x82, 0x00, // #     #  
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @896 'L' (7 pixels wide)
  0x00, //        
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        

  // @912 'M' (11 pixels wide)
  0x00, 0x00, //            
  0x80, 0x20, // #         #
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xA0, 0xA0, // # #     # #
  0xA0, 0xA0, // # #     # #
  0x91, 0x20, // #  #   #  #
  0x91, 0x20, // #  #   #  #
  0x8A, 0x20, // #   # #   #
  0x8A, 0x20, // #   # #   #
  0x8A, 0x20, // #   # #   #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @944 'N' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0xC0, 0x80, // ##      #
  0xA0, 0x80, // # #     #
  0xA0, 0x80, // # #     #
  0x90, 0x80, // #  #    #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x84, 0x80, // #    #  #
  0x82, 0x80, // #     # #
  0x82, 0x80, // #     # #
  0x81, 0x80, // #      ##
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @976 'O' (10 pixels wide)
  0x00, 0x00, //           
  0x1E, 0x00, //    ####   
  0x21, 0x00, //   #    #  
  0x40, 0x80, //  #      # 
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x40, 0x80, //  #      # 
  0x21, 0x00, //   #    #  
  0x1E, 0x00, //    ####   
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1008 'P' (9 pixels wide)
  0x00, 0x00, //          
  0xFE, 0x00, // #######  
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x81, 0x00, // #      # 
  0xFE, 0x00, // #######  
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x80, 0x00, // #        
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1040 'Q' (10 pixels wide)
  0x00, 0x00, //           
  0x1E, 0x00, //    ####   
  0x21, 0x00, //   #    #  
  0x40, 0x80, //  #      # 
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x80, 0x40, // #        #
  0x46, 0xC0, //  #   ## ##
  0x21, 0x80, //   #    ## 
  0x1E, 0xC0, //    #### ##
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1072 'R' (9 pixels wide)
  0x00, 0x00, //          
  0xFE, 0x00, // #######  
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x81, 0x00, // #      # 
  0xFE, 0x00, // #######  
  0x84, 0x00, // #    #   
  0x82, 0x00, // #     #  
  0x82, 0x00, // #     #  
  0x81, 0x00, // #      # 
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1104 'S' (9 pixels wide)
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x41, 0x00, //  #     # 
  0x80, 0x80, // #       #
  0x80, 0x00, // #        
  0x40, 0x00, //  #       
  0x38, 0x00, //   ###    
  0x07, 0x00, //      ### 
  0x00, 0x80, //         #
  0x00, 0x80, //         #
  0x80, 0x80, // #       #
  0x41, 0x00, //  #     # 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1136 'T' (9 pixels wide)
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1168 'U' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x41, 0x00, //  #     # 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1200 'V' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x41, 0x00, //  #     # 
  0x41, 0x00, //  #     # 
  0x41, 0x00, //  #     # 
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1232 'W' (15 pixels wide)
  0x00, 0x00, //                
  0x81, 0x02, // #      #      #
  0x82, 0x82, // #     # #     #
  0x42, 0x84, //  #    # #    # 
  0x42, 0x84, //  #    # #    # 
  0x44, 0x44, //  #   #   #   # 
  0x44, 0x44, //  #   #   #   # 
  0x24, 0x48, //   #  #   #  #  
  0x28, 0x28, //   # #     # #  
  0x28, 0x28, //   # #     # #  
  0x28, 0x28, //   # #     # #  
  0x10, 0x10, //    #       #   
  0x10, 0x10, //    #       #   
  0x00, 0x00, //                
  0x00, 0x00, //                
  0x00, 0x00, //                

  // @1264 'X' (11 pixels wide)
  0x00, 0x00, //            
  0x40, 0x40, //  #       # 
  0x20, 0x80, //   #     #  
  0x11, 0x00, //    #   #   
  0x11, 0x00, //    #   #   
  0x0A, 0x00, //     # #    
  0x04, 0x00, //      #     
  0x0A, 0x00, //     # #    
  0x11, 0x00, //    #   #   
  0x11, 0x00, //    #   #   
  0x20, 0x80, //   #     #  
  0x40, 0x40, //  #       # 
  0x80, 0x20, // #         #
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1296 'Y' (9 pixels wide)
  0x00, 0x00, //          
  0x80, 0x80, // #       #
  0x41, 0x00, //  #     # 
  0x41, 0x00, //  #     # 
  0x22, 0x00, //   #   #  
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1328 'Z' (9 pixels wide)
  0x00, 0x00, //          
  0x7F, 0x80, //  ########
  0x01, 0x00, //        # 
  0x02, 0x00, //       #  
  0x02, 0x00, //       #  
  0x04, 0x00, //      #   
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x10, 0x00, //    #     
  0x20, 0x00, //   #      
  0x20, 0x00, //   #      
  0x40, 0x00, //  #       
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1360 '[' (3 pixels wide)
  0x00, //    
  0xE0, // ###
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0xE0, // ###

  // @1376 '\' (4 pixels wide)
  0x00, //     
  0x80, // #   
  0x80, // #   
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x10, //    #
  0x10, //    #
  0x00, //     
  0x00, //     
  0x00, //     

  // @1392 ']' (3 pixels wide)
  0x00, //    
  0xE0, // ###
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0xE0, // ###

  // @1408 '^' (7 pixels wide)
  0x00, //        
  0x10, //    #   
  0x28, //   # #  
  0x28, //   # #  
  0x44, //  #   # 
  0x44, //  #   # 
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @1424 '_' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xFF, 0x80, // #########

  // @1456 '`' (2 pixels wide)
  0x00, //   
  0x80, // # 
  0x40, //  #
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @1472 'a' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x3C, //   #### 
  0x42, //  #    #
  0x82, // #     #
  0x0E, //     ###
  0x72, //  ###  #
  0x82, // #     #
  0x82, // #     #
  0x86, // #    ##
  0x7A, //  #### #
  0x00, //        
  0x00, //        
  0x00, //        

  // @1488 'b' (7 pixels wide)
  0x00, //        
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0xB8, // # ###  
  0xC4, // ##   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xC4, // ##   # 
  0xB8, // # ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @1504 'c' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       
  0x38, //   ### 
  0x44, //  #   #
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x44, //  #   #
  0x38, //   ### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @1520 'd' (7 pixels wide)
  0x00, //        
  0x02, //       #
  0x02, //       #
  0x02, //       #
  0x3A, //   ### #
  0x46, //  #   ##
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x46, //  #   ##
  0x3A, //   ### #
  0x00, //        
  0x00, //        
  0x00, //        

  // @1536 'e' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0xFE, // #######
  0x80, // #      
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @1552 'f' (4 pixels wide)
  0x00, //     
  0x30, //   ##
  0x40, //  #  
  0x40, //  #  
  0xF0, // ####
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x00, //     
  0x00, //     
  0x00, //     

  // @1568 'g' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x3A, //   ### #
  0x46, //  #   ##
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x46, //  #   ##
  0x3A, //   ### #
  0x02, //       #
  0x84, // #    # 
  0x78, //  ####  

  // @1584 'h' (6 pixels wide)
  0x00, //       
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0xB8, // # ### 
  0xC4, // ##   #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x00, //       
  0x00, //       
  0x00, //       

  // @1600 'i' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @1616 'j' (3 pixels wide)
  0x00, //    
  0x20, //   #
  0x00, //    
  0x00, //    
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0xC0, // ## 

  // @1632 'k' (7 pixels wide)
  0x00, //        
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x82, // #     #
  0x84, // #    # 
  0x88, // #   #  
  0x90, // #  #   
  0xB0, // # ##   
  0xC8, // ##  #  
  0x88, // #   #  
  0x84, // #    # 
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @1648 'l' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @1664 'm' (11 pixels wide)
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0xB9, 0xC0, // # ###  ### 
  0xC6, 0x20, // ##   ##   #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1696 'n' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       
  0xB8, // # ### 
  0xC4, // ##   #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x00, //       
  0x00, //       
  0x00, //       

  // @1712 'o' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @1728 'p' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0xB8, // # ###  
  0xC4, // ##   # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xC4, // ##   # 
  0xB8, // # ###  
  0x80, // #      
  0x80, // #      
  0x80, // #      

  // @1744 'q' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x3A, //   ### #
  0x46, //  #   ##
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x46, //  #   ##
  0x3A, //   ### #
  0x02, //       #
  0x02, //       #
  0x02, //       #

  // @1760 'r' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0xB0, // # ##
  0xC0, // ##  
  0x80, // #   
  0x80, // #   
  0x80, // #   
  0x80, // #   
  0x80, // #   
  0x80, // #   
  0x80, // #   
  0x00, //     
  0x00, //     
  0x00, //     

  // @1776 's' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       
  0x78, //  #### 
  0x84, // #    #
  0x80, // #     
  0x80, // #     
  0x78, //  #### 
  0x04, //      #
  0x04, //      #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @1792 't' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x40, //  #  
  0x40, //  #  
  0xF0, // ####
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x70, //  ###
  0x00, //     
  0x00, //     
  0x00, //     

  // @1808 'u' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x8C, // #   ##
  0x74, //  ### #
  0x00, //       
  0x00, //       
  0x00, //       

  // @1824 'v' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x44, //  #   # 
  0x28, //   # #  
  0x28, //   # #  
  0x28, //   # #  
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        

  // @1840 'w' (11 pixels wide)
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x84, 0x20, // #    #    #
  0x84, 0x20, // #    #    #
  0x4A, 0x40, //  #  # #  # 
  0x4A, 0x40, //  #  # #  # 
  0x51, 0x40, //  # #   # # 
  0x51, 0x40, //  # #   # # 
  0x51, 0x40, //  # #   # # 
  0x20, 0x80, //   #     #  
  0x20, 0x80, //   #     #  
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1872 'x' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x82, // #     #
  0x44, //  #   # 
  0x28, //   # #  
  0x28, //   # #  
  0x10, //    #   
  0x28, //   # #  
  0x28, //   # #  
  0x44, //  #   # 
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @1888 'y' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x82, // #     #
  0x82, // #     #
  0x84, // #    # 
  0x44, //  #   # 
  0x44, //  #   # 
  0x28, //   # #  
  0x28, //   # #  
  0x28, //   # #  
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x60, //  ##    

  // @1904 'z' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0xFE, // #######
  0x04, //      # 
  0x08, //     #  
  0x08, //     #  
  0x10, //    #   
  0x20, //   #    
  0x20, //   #    
  0x40, //  #     
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        

  // @1920 '{' (5 pixels wide)
  0x00, //      
  0x18, //    ##
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0xC0, // ##   
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x18, //    ##

  // @1936 '|' (1 pixels wide)
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #

  // @1952 '}' (5 pixels wide)
  0x00, //      
  0xC0, // ##   
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x18, //    ##
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0xC0, // ##   

  // @1968 '~' (8 pixels wide)
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x71, //  ###   #
  0x8E, // #   ### 
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
};


// Font descriptor: dsc[ch][0] width of ch, dsc[ch][1] height of ch, dsc[ch][2] offset in toled_sans12_bmp of ch
static const int toled_sans12_dsc[95][3] = {
  {4, 16, 0},     //   
  {1, 16, 16},    // ! 
  {4, 16, 32},    // " 
  {9, 16, 48},    // # 
  {7, 16, 80},    // $ 
  {12, 16, 96},     // % 
  {9, 16, 128},     // & 
  {1, 16, 160},     // ' 
  {3, 16, 176},     // ( 
  {3, 16, 192},     // ) 
  {5, 16, 208},     // * 
  {7, 16, 224},     // + 
  {1, 16, 240},     // , 
  {4, 16, 256},     // - 
  {1, 16, 272},     // . 
  {4, 16, 288},     // / 
  {7, 16, 304},     // 0 
  {4, 16, 320},     // 1 
  {7, 16, 336},     // 2 
  {7, 16, 352},     // 3 
  {8, 16, 368},     // 4 
  {7, 16, 384},     // 5 
  {7, 16, 400},     // 6 
  {7, 16, 416},     // 7 
  {7, 16, 432},     // 8 
  {7, 16, 448},     // 9 
  {1, 16, 464},     // : 
  {1, 16, 480},     // ; 
  {7, 16, 496},     // < 
  {7, 16, 512},     // = 
  {7, 16, 528},     // > 
  {7, 16, 544},     // ? 
  {15, 16, 560},    // @ 
  {9, 16, 592},     // A 
  {9, 16, 624},     // B 
  {10, 16, 656},    // C 
  {10, 16, 688},    // D 
  {9, 16, 720},     // E 
  {8, 16, 752},     // F 
  {10, 16, 768},    // G 
  {9, 16, 800},     // H 
  {1, 16, 832},     // I 
  {6, 16, 848},     // J 
  {9, 16, 864},     // K 
  {7, 16, 896},     // L 
  {11, 16, 912},    // M 
  {9, 16, 944},     // N 
  {10, 16, 976},    // O 
  {9, 16, 1008},    // P 
  {10, 16, 1040},   // Q 
  {9, 16, 1072},    // R 
  {9, 16, 1104},    // S 
  {9, 16, 1136},    // T 
  {9, 16, 1168},    // U 
  {9, 16, 1200},    // V 
  {15, 16, 1232},   // W 
  {11, 16, 1264},   // X 
  {9, 16, 1296},    // Y 
  {9, 16, 1328},    // Z 
  {3, 16, 1360},    // [ 
  {4, 16, 1376},    // 
  {3, 16, 1392},    // ] 
  {7, 16, 1408},    // ^ 
  {9, 16, 1424},    // _ 
  {2, 16, 1456},    // ` 
  {7, 16, 1472},    // a 
  {7, 16, 1488},    // b 
  {6, 16, 1504},    // c 
  {7, 16, 1520},    // d 
  {7, 16, 1536},    // e 
  {4, 16, 1552},    // f 
  {7, 16, 1568},    // g 
  {6, 16, 1584},    // h 
  {1, 16, 1600},    // i 
  {3, 16, 1616},    // j 
  {7, 16, 1632},    // k 
  {1, 16, 1648},    // l 
  {11, 16, 1664},   // m 
  {6, 16, 1696},    // n 
  {7, 16, 1712},    // o 
  {7, 16, 1728},    // p 
  {7, 16, 1744},    // q 
  {4, 16, 1760},    // r 
  {6, 16, 1776},    // s 
  {4, 16, 1792},    // t 
  {6, 16, 1808},    // u 
  {7, 16, 1824},    // v 
  {11, 16, 1840},   // w 
  {7, 16, 1872},    // x 
  {7, 16, 1888},    // y 
  {7, 16, 1904},    // z 
  {5, 16, 1920},    // { 
  {1, 16, 1936},    // | 
  {5, 16, 1952},    // } 
  {8, 16, 1968},    // ~ 
};


void toled_sans12(char ch, int * width, int * height, const uint8_t ** bmp ) {
  if( ch<' ' || ch> '~' ) {
    *width = 0;
    *height= 0;
    *bmp   = 0;
  } else {
    int ix = ch - ' ';
    *width = toled_sans12_dsc[ix][0];
    *height= toled_sans12_dsc[ix][1];
    *bmp   = &toled_sans12_bmp[ toled_sans12_dsc[ix][2] ];
  }
}
