// sans10px.cpp - Bitmap data for a font: 13 pixel high (A=10px,x=7px), variable width, sans serif
// Reused from https://github.com/bonezegei/Bonezegei_SSD1306/blob/main/src/arial10.h


#include <stdint.h>


static const uint8_t toled_sans10_bmp[] = {

  // @0 ' ' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     

  // @13 '!' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @26 '"' (3 pixels wide)
  0xA0, // # #
  0xA0, // # #
  0xA0, // # #
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    

  // @39 '#' (8 pixels wide)
  0x12, //    #  # 
  0x12, //    #  # 
  0x22, //   #   # 
  0xFF, // ########
  0x24, //   #  #  
  0x24, //   #  #  
  0xFF, // ########
  0x48, //  #  #   
  0x48, //  #  #   
  0x48, //  #  #   
  0x00, //         
  0x00, //         
  0x00, //         

  // @52 '$' (5 pixels wide)
  0x70, //  ### 
  0xA8, // # # #
  0xA0, // # #  
  0xA0, // # #  
  0xE0, // ###  
  0x38, //   ###
  0x28, //   # #
  0xA8, // # # #
  0xA8, // # # #
  0x70, //  ### 
  0x20, //   #  
  0x00, //      
  0x00, //      

  // @65 '%' (10 pixels wide)
  0x61, 0x00, //  ##    #  
  0x92, 0x00, // #  #  #   
  0x92, 0x00, // #  #  #   
  0x94, 0x00, // #  # #    
  0x64, 0x00, //  ##  #    
  0x09, 0x80, //     #  ## 
  0x0A, 0x40, //     # #  #
  0x12, 0x40, //    #  #  #
  0x12, 0x40, //    #  #  #
  0x21, 0x80, //   #    ## 
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @91 '&' (8 pixels wide)
  0x30, //   ##    
  0x48, //  #  #   
  0x48, //  #  #   
  0x48, //  #  #   
  0x30, //   ##    
  0x60, //  ##     
  0x92, // #  #  # 
  0x8A, // #   # # 
  0x8C, // #   ##  
  0x73, //  ###  ##
  0x00, //         
  0x00, //         
  0x00, //         

  // @104 ''' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  

  // @117 '(' (3 pixels wide)
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x20, //   #

  // @130 ')' (3 pixels wide)
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x80, // #  

  // @143 '*' (5 pixels wide)
  0x20, //   #  
  0xF8, // #####
  0x20, //   #  
  0x50, //  # # 
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @156 '+' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0xFE, // #######
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @169 ',' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  

  // @182 '-' (3 pixels wide)
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0xE0, // ###
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    

  // @195 '.' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @208 '/' (4 pixels wide)
  0x10, //    #
  0x10, //    #
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x80, // #   
  0x80, // #   
  0x00, //     
  0x00, //     
  0x00, //     

  // @221 '0' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @234 '1' (3 pixels wide)
  0x20, //   #
  0x60, //  ##
  0xA0, // # #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x00, //    
  0x00, //    
  0x00, //    

  // @247 '2' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x08, //     # 
  0x10, //    #  
  0x20, //   #   
  0x40, //  #    
  0xFC, // ######
  0x00, //       
  0x00, //       
  0x00, //       

  // @260 '3' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x04, //      #
  0x04, //      #
  0x38, //   ### 
  0x04, //      #
  0x04, //      #
  0x04, //      #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @273 '4' (6 pixels wide)
  0x08, //     # 
  0x18, //    ## 
  0x18, //    ## 
  0x28, //   # # 
  0x28, //   # # 
  0x48, //  #  # 
  0x48, //  #  # 
  0xFC, // ######
  0x08, //     # 
  0x08, //     # 
  0x00, //       
  0x00, //       
  0x00, //       

  // @286 '5' (6 pixels wide)
  0x7C, //  #####
  0x40, //  #    
  0x40, //  #    
  0x80, // #     
  0xF8, // ##### 
  0x84, // #    #
  0x04, //      #
  0x04, //      #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @299 '6' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x80, // #     
  0x80, // #     
  0xB8, // # ### 
  0xC4, // ##   #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @312 '7' (6 pixels wide)
  0xFC, // ######
  0x08, //     # 
  0x08, //     # 
  0x10, //    #  
  0x10, //    #  
  0x20, //   #   
  0x20, //   #   
  0x40, //  #    
  0x40, //  #    
  0x40, //  #    
  0x00, //       
  0x00, //       
  0x00, //       

  // @325 '8' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  #### 
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x78, //  #### 
  0x00, //       
  0x00, //       
  0x00, //       

  // @338 '9' (6 pixels wide)
  0x78, //  #### 
  0x84, // #    #
  0x84, // #    #
  0x84, // #    #
  0x8C, // #   ##
  0x74, //  ### #
  0x04, //      #
  0x04, //      #
  0x88, // #   # 
  0x70, //  ###  
  0x00, //       
  0x00, //       
  0x00, //       

  // @351 ':' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @364 ';' (1 pixels wide)
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  

  // @377 '<' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x04, //      #
  0x18, //    ## 
  0x60, //  ##   
  0x80, // #     
  0x60, //  ##   
  0x18, //    ## 
  0x04, //      #
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       

  // @390 '=' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0xFE, // #######
  0x00, //        
  0x00, //        
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @403 '>' (6 pixels wide)
  0x00, //       
  0x00, //       
  0x80, // #     
  0x60, //  ##   
  0x18, //    ## 
  0x04, //      #
  0x18, //    ## 
  0x60, //  ##   
  0x80, // #     
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       

  // @416 '?' (5 pixels wide)
  0x70, //  ### 
  0x88, // #   #
  0x88, // #   #
  0x08, //     #
  0x10, //    # 
  0x20, //   #  
  0x40, //  #   
  0x40, //  #   
  0x00, //      
  0x40, //  #   
  0x00, //      
  0x00, //      
  0x00, //      

  // @429 '@' (12 pixels wide)
  0x0F, 0x80, //     #####   
  0x30, 0x40, //   ##     #  
  0x40, 0x20, //  #        # 
  0x4E, 0x90, //  #  ### #  #
  0x91, 0x90, // #  #   ##  #
  0xA0, 0x90, // # #     #  #
  0xA1, 0x10, // # #    #   #
  0xA1, 0x20, // # #    #  # 
  0xA3, 0x20, // # #   ##  # 
  0x9D, 0xC0, // #  ### ###  
  0x40, 0x10, //  #         #
  0x20, 0x60, //   #      ## 
  0x1F, 0x80, //    ######   

  // @455 'A' (9 pixels wide)
  0x08, 0x00, //     #    
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x7F, 0x00, //  ####### 
  0x41, 0x00, //  #     # 
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @481 'B' (7 pixels wide)
  0xFC, // ###### 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xFC, // ###### 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xFC, // ###### 
  0x00, //        
  0x00, //        
  0x00, //        

  // @494 'C' (7 pixels wide)
  0x38, //   ###  
  0x44, //  #   # 
  0x82, // #     #
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @507 'D' (7 pixels wide)
  0xF8, // #####  
  0x84, // #    # 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x84, // #    # 
  0xF8, // #####  
  0x00, //        
  0x00, //        
  0x00, //        

  // @520 'E' (7 pixels wide)
  0xFE, // #######
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0xFE, // #######
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        

  // @533 'F' (6 pixels wide)
  0xFC, // ######
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0xF8, // ##### 
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x00, //       
  0x00, //       
  0x00, //       

  // @546 'G' (8 pixels wide)
  0x3C, //   ####  
  0x42, //  #    # 
  0x81, // #      #
  0x80, // #       
  0x80, // #       
  0x8F, // #   ####
  0x81, // #      #
  0x81, // #      #
  0x42, //  #    # 
  0x3C, //   ####  
  0x00, //         
  0x00, //         
  0x00, //         

  // @559 'H' (7 pixels wide)
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xFE, // #######
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @572 'I' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @585 'J' (5 pixels wide)
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @598 'K' (8 pixels wide)
  0x81, // #      #
  0x82, // #     # 
  0x84, // #    #  
  0x88, // #   #   
  0x90, // #  #    
  0xB0, // # ##    
  0xC8, // ##  #   
  0x84, // #    #  
  0x82, // #     # 
  0x81, // #      #
  0x00, //         
  0x00, //         
  0x00, //         

  // @611 'L' (6 pixels wide)
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0x80, // #     
  0xFC, // ######
  0x00, //       
  0x00, //       
  0x00, //       

  // @624 'M' (9 pixels wide)
  0x80, 0x80, // #       #
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xA2, 0x80, // # #   # #
  0xA2, 0x80, // # #   # #
  0x94, 0x80, // #  # #  #
  0x94, 0x80, // #  # #  #
  0x94, 0x80, // #  # #  #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @650 'N' (7 pixels wide)
  0x82, // #     #
  0xC2, // ##    #
  0xA2, // # #   #
  0xA2, // # #   #
  0x92, // #  #  #
  0x92, // #  #  #
  0x8A, // #   # #
  0x8A, // #   # #
  0x86, // #    ##
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @663 'O' (8 pixels wide)
  0x3C, //   ####  
  0x42, //  #    # 
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x42, //  #    # 
  0x3C, //   ####  
  0x00, //         
  0x00, //         
  0x00, //         

  // @676 'P' (7 pixels wide)
  0xFC, // ###### 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xFC, // ###### 
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x80, // #      
  0x00, //        
  0x00, //        
  0x00, //        

  // @689 'Q' (8 pixels wide)
  0x3C, //   ####  
  0x42, //  #    # 
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x81, // #      #
  0x8D, // #   ## #
  0x42, //  #    # 
  0x3D, //   #### #
  0x00, //         
  0x00, //         
  0x00, //         

  // @702 'R' (7 pixels wide)
  0xFC, // ###### 
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0xFC, // ###### 
  0x88, // #   #  
  0x84, // #    # 
  0x84, // #    # 
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @715 'S' (7 pixels wide)
  0x7C, //  ##### 
  0x82, // #     #
  0x82, // #     #
  0x80, // #      
  0x70, //  ###   
  0x0C, //     ## 
  0x02, //       #
  0x82, // #     #
  0x82, // #     #
  0x7C, //  ##### 
  0x00, //        
  0x00, //        
  0x00, //        

  // @728 'T' (7 pixels wide)
  0xFE, // #######
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        

  // @741 'U' (7 pixels wide)
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x82, // #     #
  0x44, //  #   # 
  0x38, //   ###  
  0x00, //        
  0x00, //        
  0x00, //        

  // @754 'V' (9 pixels wide)
  0x80, 0x80, // #       #
  0x80, 0x80, // #       #
  0x41, 0x00, //  #     # 
  0x41, 0x00, //  #     # 
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x14, 0x00, //    # #   
  0x14, 0x00, //    # #   
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @780 'W' (13 pixels wide)
  0x82, 0x08, // #     #     #
  0x85, 0x08, // #    # #    #
  0x45, 0x10, //  #   # #   # 
  0x45, 0x10, //  #   # #   # 
  0x45, 0x10, //  #   # #   # 
  0x28, 0xA0, //   # #   # #  
  0x28, 0xA0, //   # #   # #  
  0x28, 0xA0, //   # #   # #  
  0x10, 0x40, //    #     #   
  0x10, 0x40, //    #     #   
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @806 'X' (7 pixels wide)
  0x82, // #     #
  0x44, //  #   # 
  0x44, //  #   # 
  0x28, //   # #  
  0x10, //    #   
  0x10, //    #   
  0x28, //   # #  
  0x44, //  #   # 
  0x44, //  #   # 
  0x82, // #     #
  0x00, //        
  0x00, //        
  0x00, //        

  // @819 'Y' (7 pixels wide)
  0x82, // #     #
  0x44, //  #   # 
  0x44, //  #   # 
  0x28, //   # #  
  0x28, //   # #  
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x10, //    #   
  0x00, //        
  0x00, //        
  0x00, //        

  // @832 'Z' (7 pixels wide)
  0x7E, //  ######
  0x04, //      # 
  0x08, //     #  
  0x08, //     #  
  0x10, //    #   
  0x10, //    #   
  0x20, //   #    
  0x20, //   #    
  0x40, //  #     
  0xFE, // #######
  0x00, //        
  0x00, //        
  0x00, //        

  // @845 '[' (2 pixels wide)
  0xC0, // ##
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0x80, // # 
  0xC0, // ##

  // @858 '\' (4 pixels wide)
  0x80, // #   
  0x80, // #   
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x20, //   # 
  0x20, //   # 
  0x20, //   # 
  0x10, //    #
  0x10, //    #
  0x00, //     
  0x00, //     
  0x00, //     

  // @871 ']' (2 pixels wide)
  0xC0, // ##
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0x40, //  #
  0xC0, // ##

  // @884 '^' (5 pixels wide)
  0x00, //      
  0x20, //   #  
  0x50, //  # # 
  0x50, //  # # 
  0x50, //  # # 
  0x88, // #   #
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @897 '_' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0xFE, // #######

  // @910 '`' (2 pixels wide)
  0x80, // # 
  0x40, //  #
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @923 'a' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x70, //  ### 
  0x88, // #   #
  0x08, //     #
  0x78, //  ####
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x00, //      
  0x00, //      
  0x00, //      

  // @936 'b' (5 pixels wide)
  0x80, // #    
  0x80, // #    
  0x80, // #    
  0xB0, // # ## 
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0xF0, // #### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @949 'c' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x70, //  ### 
  0x88, // #   #
  0x80, // #    
  0x80, // #    
  0x80, // #    
  0x88, // #   #
  0x70, //  ### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @962 'd' (5 pixels wide)
  0x08, //     #
  0x08, //     #
  0x08, //     #
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x78, //  ####
  0x00, //      
  0x00, //      
  0x00, //      

  // @975 'e' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x70, //  ### 
  0x88, // #   #
  0x88, // #   #
  0xF8, // #####
  0x80, // #    
  0x88, // #   #
  0x70, //  ### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @988 'f' (4 pixels wide)
  0x30, //   ##
  0x40, //  #  
  0x40, //  #  
  0xE0, // ### 
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x40, //  #  
  0x00, //     
  0x00, //     
  0x00, //     

  // @1001 'g' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x08, //     #
  0x88, // #   #
  0x70, //  ### 

  // @1014 'h' (5 pixels wide)
  0x80, // #    
  0x80, // #    
  0x80, // #    
  0xB0, // # ## 
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x00, //      
  0x00, //      
  0x00, //      

  // @1027 'i' (1 pixels wide)
  0x80, // #
  0x00, //  
  0x00, //  
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @1040 'j' (3 pixels wide)
  0x20, //   #
  0x00, //    
  0x00, //    
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0x20, //   #
  0xC0, // ## 

  // @1053 'k' (5 pixels wide)
  0x80, // #    
  0x80, // #    
  0x80, // #    
  0x88, // #   #
  0x90, // #  # 
  0xA0, // # #  
  0xE0, // ###  
  0x90, // #  # 
  0x90, // #  # 
  0x88, // #   #
  0x00, //      
  0x00, //      
  0x00, //      

  // @1066 'l' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  
  0x00, //  
  0x00, //  

  // @1079 'm' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xB3, 0x00, // # ##  ## 
  0xCC, 0x80, // ##  ##  #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1105 'n' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0xB0, // # ## 
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x00, //      
  0x00, //      
  0x00, //      

  // @1118 'o' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x70, //  ### 
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x70, //  ### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @1131 'p' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0xB0, // # ## 
  0xC8, // ##  #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0xC8, // ##  #
  0xB0, // # ## 
  0x80, // #    
  0x80, // #    
  0x80, // #    

  // @1144 'q' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x68, //  ## #
  0x98, // #  ##
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x98, // #  ##
  0x68, //  ## #
  0x08, //     #
  0x08, //     #
  0x08, //     #

  // @1157 'r' (3 pixels wide)
  0x00, //    
  0x00, //    
  0x00, //    
  0xA0, // # #
  0xC0, // ## 
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x80, // #  
  0x00, //    
  0x00, //    
  0x00, //    

  // @1170 's' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x70, //  ### 
  0x88, // #   #
  0x80, // #    
  0x70, //  ### 
  0x08, //     #
  0x88, // #   #
  0x70, //  ### 
  0x00, //      
  0x00, //      
  0x00, //      

  // @1183 't' (3 pixels wide)
  0x00, //    
  0x40, //  # 
  0x40, //  # 
  0xE0, // ###
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x60, //  ##
  0x00, //    
  0x00, //    
  0x00, //    

  // @1196 'u' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x88, // #   #
  0x78, //  ####
  0x00, //      
  0x00, //      
  0x00, //      

  // @1209 'v' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x88, // #   #
  0x88, // #   #
  0x50, //  # # 
  0x50, //  # # 
  0x50, //  # # 
  0x20, //   #  
  0x20, //   #  
  0x00, //      
  0x00, //      
  0x00, //      

  // @1222 'w' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x88, 0x80, // #   #   #
  0x88, 0x80, // #   #   #
  0x55, 0x00, //  # # # # 
  0x55, 0x00, //  # # # # 
  0x55, 0x00, //  # # # # 
  0x22, 0x00, //   #   #  
  0x22, 0x00, //   #   #  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1248 'x' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x88, // #   #
  0x50, //  # # 
  0x50, //  # # 
  0x20, //   #  
  0x50, //  # # 
  0x50, //  # # 
  0x88, // #   #
  0x00, //      
  0x00, //      
  0x00, //      

  // @1261 'y' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x88, // #   #
  0x88, // #   #
  0x50, //  # # 
  0x50, //  # # 
  0x50, //  # # 
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0x20, //   #  
  0xC0, // ##   

  // @1274 'z' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0xF8, // #####
  0x10, //    # 
  0x10, //    # 
  0x20, //   #  
  0x40, //  #   
  0x40, //  #   
  0xF8, // #####
  0x00, //      
  0x00, //      
  0x00, //      

  // @1287 '{' (3 pixels wide)
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x20, //   #

  // @1300 '|' (1 pixels wide)
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x80, // #
  0x00, //  

  // @1313 '}' (3 pixels wide)
  0x80, // #  
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x20, //   #
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x40, //  # 
  0x80, // #  

  // @1326 '~' (7 pixels wide)
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x72, //  ###  #
  0x9E, // #  ####
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
};


// Font descriptor: dsc[ch][0] width of ch, dsc[ch][1] height of ch, dsc[ch][2] offset in toled_sans10_bmp of ch
static const int toled_sans10_dsc[95][3] = {
  {4, 13, 0},     //   
  {1, 13, 13},    // ! 
  {3, 13, 26},    // " 
  {8, 13, 39},    // # 
  {5, 13, 52},    // $ 
  {10, 13, 65},     // % 
  {8, 13, 91},    // & 
  {1, 13, 104},     // ' 
  {3, 13, 117},     // ( 
  {3, 13, 130},     // ) 
  {5, 13, 143},     // * 
  {7, 13, 156},     // + 
  {1, 13, 169},     // , 
  {3, 13, 182},     // - 
  {1, 13, 195},     // . 
  {4, 13, 208},     // / 
  {6, 13, 221},     // 0 
  {3, 13, 234},     // 1 
  {6, 13, 247},     // 2 
  {6, 13, 260},     // 3 
  {6, 13, 273},     // 4 
  {6, 13, 286},     // 5 
  {6, 13, 299},     // 6 
  {6, 13, 312},     // 7 
  {6, 13, 325},     // 8 
  {6, 13, 338},     // 9 
  {1, 13, 351},     // : 
  {1, 13, 364},     // ; 
  {6, 13, 377},     // < 
  {7, 13, 390},     // = 
  {6, 13, 403},     // > 
  {5, 13, 416},     // ? 
  {12, 13, 429},    // @ 
  {9, 13, 455},     // A 
  {7, 13, 481},     // B 
  {7, 13, 494},     // C 
  {7, 13, 507},     // D 
  {7, 13, 520},     // E 
  {6, 13, 533},     // F 
  {8, 13, 546},     // G 
  {7, 13, 559},     // H 
  {1, 13, 572},     // I 
  {5, 13, 585},     // J 
  {8, 13, 598},     // K 
  {6, 13, 611},     // L 
  {9, 13, 624},     // M 
  {7, 13, 650},     // N 
  {8, 13, 663},     // O 
  {7, 13, 676},     // P 
  {8, 13, 689},     // Q 
  {7, 13, 702},     // R 
  {7, 13, 715},     // S 
  {7, 13, 728},     // T 
  {7, 13, 741},     // U 
  {9, 13, 754},     // V 
  {13, 13, 780},    // W 
  {7, 13, 806},     // X 
  {7, 13, 819},     // Y 
  {7, 13, 832},     // Z 
  {2, 13, 845},     // [ 
  {4, 13, 858},     // 
  {2, 13, 871},     // ] 
  {5, 13, 884},     // ^ 
  {7, 13, 897},     // _ 
  {2, 13, 910},     // ` 
  {5, 13, 923},     // a 
  {5, 13, 936},     // b 
  {5, 13, 949},     // c 
  {5, 13, 962},     // d 
  {5, 13, 975},     // e 
  {4, 13, 988},     // f 
  {5, 13, 1001},    // g 
  {5, 13, 1014},    // h 
  {1, 13, 1027},    // i 
  {3, 13, 1040},    // j 
  {5, 13, 1053},    // k 
  {1, 13, 1066},    // l 
  {9, 13, 1079},    // m 
  {5, 13, 1105},    // n 
  {5, 13, 1118},    // o 
  {5, 13, 1131},    // p 
  {5, 13, 1144},    // q 
  {3, 13, 1157},    // r 
  {5, 13, 1170},    // s 
  {3, 13, 1183},    // t 
  {5, 13, 1196},    // u 
  {5, 13, 1209},    // v 
  {9, 13, 1222},    // w 
  {5, 13, 1248},    // x 
  {5, 13, 1261},    // y 
  {5, 13, 1274},    // z 
  {3, 13, 1287},    // { 
  {1, 13, 1300},    // | 
  {3, 13, 1313},    // } 
  {7, 13, 1326},    // ~ 
};


void toled_sans10(char ch, int * width, int * height, const uint8_t ** bmp ) {
  if( ch<' ' || ch> '~' ) {
    *width = 0;
    *height= 0;
    *bmp   = 0;
  } else {
    int ix = ch - ' ';
    *width = toled_sans10_dsc[ix][0];
    *height= toled_sans10_dsc[ix][1];
    *bmp   = &toled_sans10_bmp[ toled_sans10_dsc[ix][2] ];
  }
}

