// sans14px.cpp - Bitmap data for a font: 19 pixel high (A=14px,x=10px), variable width, sans serif
// Reused from https://github.com/bonezegei/Bonezegei_SSD1306/blob/main/src/arial14.h


#include <stdint.h>


static const uint8_t toled_sans14_bmp[] = {

  // @0 ' ' (4 pixels wide)
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     
  0x00, //     

  // @19 '!' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @38 '"' (5 pixels wide)
  0x00, //      
  0xD8, // ## ##
  0xD8, // ## ##
  0xD8, // ## ##
  0xD8, // ## ##
  0xD8, // ## ##
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @57 '#' (11 pixels wide)
  0x00, 0x00, //            
  0x0C, 0xC0, //     ##  ## 
  0x0C, 0xC0, //     ##  ## 
  0x19, 0x80, //    ##  ##  
  0xFF, 0xE0, // ###########
  0xFF, 0xE0, // ###########
  0x19, 0x80, //    ##  ##  
  0x19, 0x80, //    ##  ##  
  0x33, 0x00, //   ##  ##   
  0xFF, 0xE0, // ###########
  0xFF, 0xE0, // ###########
  0x33, 0x00, //   ##  ##   
  0x33, 0x00, //   ##  ##   
  0x66, 0x00, //  ##  ##    
  0x66, 0x00, //  ##  ##    
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @95 '$' (9 pixels wide)
  0x08, 0x00, //     #    
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE9, 0x80, // ### #  ##
  0xC8, 0x00, // ##  #    
  0xC8, 0x00, // ##  #    
  0x78, 0x00, //  ####    
  0x3E, 0x00, //   #####  
  0x0F, 0x00, //     #### 
  0x0B, 0x80, //     # ###
  0x09, 0x80, //     #  ##
  0xC9, 0x80, // ##  #  ##
  0xEB, 0x80, // ### # ###
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x08, 0x00, //     #    
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @133 '%' (15 pixels wide)
  0x00, 0x00, //                
  0x78, 0x18, //  ####      ##  
  0xCC, 0x30, // ##  ##    ##   
  0xCC, 0x30, // ##  ##    ##   
  0xCC, 0x60, // ##  ##   ##    
  0xCC, 0xC0, // ##  ##  ##     
  0xCC, 0xC0, // ##  ##  ##     
  0x79, 0x80, //  ####  ##      
  0x01, 0xBC, //        ## #### 
  0x03, 0x66, //       ## ##  ##
  0x03, 0x66, //       ## ##  ##
  0x06, 0x66, //      ##  ##  ##
  0x0C, 0x66, //     ##   ##  ##
  0x0C, 0x66, //     ##   ##  ##
  0x18, 0x3C, //    ##     #### 
  0x00, 0x00, //                
  0x00, 0x00, //                
  0x00, 0x00, //                
  0x00, 0x00, //                

  // @171 '&' (12 pixels wide)
  0x00, 0x00, //             
  0x1E, 0x00, //    ####     
  0x3F, 0x00, //   ######    
  0x63, 0x00, //  ##   ##    
  0x63, 0x00, //  ##   ##    
  0x73, 0x00, //  ###  ##    
  0x3E, 0x00, //   #####     
  0x3C, 0x00, //   ####      
  0x7C, 0x00, //  #####      
  0xE6, 0x60, // ###  ##  ## 
  0xC3, 0x60, // ##    ## ## 
  0xC1, 0xC0, // ##     ###  
  0xE3, 0xC0, // ###   ####  
  0x7F, 0x60, //  ####### ## 
  0x3C, 0x30, //   ####    ##
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             

  // @209 ''' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @228 '(' (5 pixels wide)
  0x00, //      
  0x08, //     #
  0x10, //    # 
  0x30, //   ## 
  0x60, //  ##  
  0x60, //  ##  
  0x40, //  #   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0x40, //  #   
  0x60, //  ##  
  0x60, //  ##  
  0x30, //   ## 
  0x10, //    # 
  0x08, //     #

  // @247 ')' (5 pixels wide)
  0x00, //      
  0x80, // #    
  0x40, //  #   
  0x60, //  ##  
  0x30, //   ## 
  0x30, //   ## 
  0x10, //    # 
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x10, //    # 
  0x30, //   ## 
  0x30, //   ## 
  0x60, //  ##  
  0x40, //  #   
  0x80, // #    

  // @266 '*' (5 pixels wide)
  0x00, //      
  0x20, //   #  
  0x20, //   #  
  0xF8, // #####
  0x20, //   #  
  0x50, //  # # 
  0x50, //  # # 
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @285 '+' (10 pixels wide)
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0xFF, 0xC0, // ##########
  0xFF, 0xC0, // ##########
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @323 ',' (2 pixels wide)
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x40, //  #
  0x40, //  #
  0x80, // # 
  0x00, //   

  // @342 '-' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0xF8, // #####
  0xF8, // #####
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @361 '.' (2 pixels wide)
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @380 '/' (6 pixels wide)
  0x00, //       
  0x0C, //     ##
  0x0C, //     ##
  0x18, //    ## 
  0x18, //    ## 
  0x18, //    ## 
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0xC0, // ##    
  0xC0, // ##    
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       

  // @399 '0' (9 pixels wide)
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0x63, 0x00, //  ##   ## 
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0x63, 0x00, //  ##   ## 
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @437 '1' (5 pixels wide)
  0x00, //      
  0x18, //    ##
  0x18, //    ##
  0x38, //   ###
  0xF8, // #####
  0xD8, // ## ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x18, //    ##
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @456 '2' (9 pixels wide)
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x03, 0x00, //       ## 
  0x06, 0x00, //      ##  
  0x0C, 0x00, //     ##   
  0x18, 0x00, //    ##    
  0x30, 0x00, //   ##     
  0x60, 0x00, //  ##      
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @494 '3' (9 pixels wide)
  0x00, 0x00, //          
  0x3C, 0x00, //   ####   
  0x7E, 0x00, //  ######  
  0xE3, 0x00, // ###   ## 
  0xC3, 0x00, // ##    ## 
  0x03, 0x00, //       ## 
  0x1E, 0x00, //    ####  
  0x1F, 0x00, //    ##### 
  0x03, 0x80, //       ###
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @532 '4' (10 pixels wide)
  0x00, 0x00, //           
  0x01, 0x00, //        #  
  0x03, 0x00, //       ##  
  0x07, 0x00, //      ###  
  0x0F, 0x00, //     ####  
  0x1B, 0x00, //    ## ##  
  0x1B, 0x00, //    ## ##  
  0x33, 0x00, //   ##  ##  
  0x63, 0x00, //  ##   ##  
  0xC3, 0x00, // ##    ##  
  0xFF, 0xC0, // ##########
  0xFF, 0xC0, // ##########
  0x03, 0x00, //       ##  
  0x03, 0x00, //       ##  
  0x03, 0x00, //       ##  
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @570 '5' (9 pixels wide)
  0x00, 0x00, //          
  0x7F, 0x00, //  ####### 
  0x7F, 0x00, //  ####### 
  0x60, 0x00, //  ##      
  0x60, 0x00, //  ##      
  0xC0, 0x00, // ##       
  0xDE, 0x00, // ## ####  
  0xFF, 0x00, // ######## 
  0xC1, 0x80, // ##     ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @608 '6' (9 pixels wide)
  0x00, 0x00, //          
  0x1E, 0x00, //    ####  
  0x3F, 0x00, //   ###### 
  0x63, 0x80, //  ##   ###
  0xE1, 0x80, // ###    ##
  0xC0, 0x00, // ##       
  0xDE, 0x00, // ## ####  
  0xFF, 0x00, // ######## 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0x63, 0x80, //  ##   ###
  0x7F, 0x00, //  ####### 
  0x1E, 0x00, //    ####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @646 '7' (9 pixels wide)
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0x01, 0x00, //        # 
  0x03, 0x00, //       ## 
  0x06, 0x00, //      ##  
  0x04, 0x00, //      #   
  0x0C, 0x00, //     ##   
  0x0C, 0x00, //     ##   
  0x18, 0x00, //    ##    
  0x18, 0x00, //    ##    
  0x18, 0x00, //    ##    
  0x30, 0x00, //   ##     
  0x30, 0x00, //   ##     
  0x30, 0x00, //   ##     
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @684 '8' (9 pixels wide)
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x00, //  ####### 
  0x7F, 0x00, //  ####### 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC3, 0x80, // ##    ###
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @722 '9' (9 pixels wide)
  0x00, 0x00, //          
  0x3C, 0x00, //   ####   
  0x7F, 0x00, //  ####### 
  0xE3, 0x00, // ###   ## 
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x80, //  ########
  0x3D, 0x80, //   #### ##
  0x01, 0x80, //        ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x00, // ###   ## 
  0x7F, 0x00, //  ####### 
  0x3C, 0x00, //   ####   
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @760 ':' (2 pixels wide)
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @779 ';' (2 pixels wide)
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x40, //  #
  0x40, //  #
  0x80, // # 
  0x00, //   

  // @798 '<' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x80, //         #
  0x03, 0x80, //       ###
  0x1F, 0x00, //    ##### 
  0x78, 0x00, //  ####    
  0xC0, 0x00, // ##       
  0x78, 0x00, //  ####    
  0x1F, 0x00, //    ##### 
  0x03, 0x80, //       ###
  0x00, 0x80, //         #
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @836 '=' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @874 '>' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x80, 0x00, // #        
  0xE0, 0x00, // ###      
  0x7C, 0x00, //  #####   
  0x0F, 0x00, //     #### 
  0x01, 0x80, //        ##
  0x0F, 0x00, //     #### 
  0x7C, 0x00, //  #####   
  0xE0, 0x00, // ###      
  0x80, 0x00, // #        
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @912 '?' (9 pixels wide)
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0x01, 0x80, //        ##
  0x03, 0x00, //       ## 
  0x07, 0x00, //      ### 
  0x0E, 0x00, //     ###  
  0x1C, 0x00, //    ###   
  0x18, 0x00, //    ##    
  0x18, 0x00, //    ##    
  0x00, 0x00, //          
  0x18, 0x00, //    ##    
  0x18, 0x00, //    ##    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @950 '@' (18 pixels wide)
  0x00, 0x00, 0x00, //                   
  0x03, 0xF8, 0x00, //       #######     
  0x0F, 0xFE, 0x00, //     ###########   
  0x1E, 0x0F, 0x00, //    ####     ####  
  0x38, 0x03, 0x80, //   ###         ### 
  0x71, 0xED, 0x80, //  ###   #### ## ## 
  0x63, 0xFC, 0xC0, //  ##   ########  ##
  0xE7, 0x38, 0xC0, // ###  ###  ###   ##
  0xC6, 0x18, 0xC0, // ##   ##    ##   ##
  0xCC, 0x18, 0xC0, // ##  ##     ##   ##
  0xCC, 0x10, 0xC0, // ##  ##     #    ##
  0xCC, 0x31, 0x80, // ##  ##    ##   ## 
  0xCE, 0x73, 0x00, // ##  ###  ###  ##  
  0xE7, 0xFF, 0x00, // ###  ###########  
  0x63, 0xBC, 0x00, //  ##   ### ####    
  0x70, 0x01, 0xC0, //  ###           ###
  0x3C, 0x07, 0x80, //   ####       #### 
  0x0F, 0xFF, 0x00, //     ############  
  0x03, 0xF8, 0x00, //       #######     

  // @1007 'A' (13 pixels wide)
  0x00, 0x00, //              
  0x07, 0x00, //      ###     
  0x07, 0x00, //      ###     
  0x0D, 0x80, //     ## ##    
  0x0D, 0x80, //     ## ##    
  0x0D, 0x80, //     ## ##    
  0x18, 0xC0, //    ##   ##   
  0x18, 0xC0, //    ##   ##   
  0x30, 0x60, //   ##     ##  
  0x3F, 0xE0, //   #########  
  0x3F, 0xE0, //   #########  
  0x60, 0x30, //  ##       ## 
  0x60, 0x30, //  ##       ## 
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1045 'B' (10 pixels wide)
  0x00, 0x00, //           
  0xFE, 0x00, // #######   
  0xFF, 0x00, // ########  
  0xC3, 0x80, // ##    ### 
  0xC1, 0x80, // ##     ## 
  0xC1, 0x80, // ##     ## 
  0xC3, 0x80, // ##    ### 
  0xFF, 0x00, // ########  
  0xFF, 0x00, // ########  
  0xC1, 0x80, // ##     ## 
  0xC0, 0xC0, // ##      ##
  0xC0, 0xC0, // ##      ##
  0xC1, 0xC0, // ##     ###
  0xFF, 0x80, // ######### 
  0xFF, 0x00, // ########  
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1083 'C' (12 pixels wide)
  0x00, 0x00, //             
  0x0F, 0x00, //     ####    
  0x3F, 0xC0, //   ########  
  0x70, 0x60, //  ###     ## 
  0x60, 0x30, //  ##       ##
  0xC0, 0x00, // ##          
  0xC0, 0x00, // ##          
  0xC0, 0x00, // ##          
  0xC0, 0x00, // ##          
  0xC0, 0x00, // ##          
  0xC0, 0x30, // ##        ##
  0x60, 0x60, //  ##      ## 
  0x70, 0xE0, //  ###    ### 
  0x3F, 0xC0, //   ########  
  0x0F, 0x00, //     ####    
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             

  // @1121 'D' (11 pixels wide)
  0x00, 0x00, //            
  0xFF, 0x00, // ########   
  0xFF, 0x80, // #########  
  0xC1, 0xC0, // ##     ### 
  0xC0, 0xC0, // ##      ## 
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0xC0, // ##      ## 
  0xC1, 0xC0, // ##     ### 
  0xFF, 0x80, // #########  
  0xFF, 0x00, // ########   
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1159 'E' (10 pixels wide)
  0x00, 0x00, //           
  0xFF, 0xC0, // ##########
  0xFF, 0xC0, // ##########
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xFF, 0x80, // ######### 
  0xFF, 0x80, // ######### 
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xFF, 0xC0, // ##########
  0xFF, 0xC0, // ##########
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1197 'F' (9 pixels wide)
  0x00, 0x00, //          
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xFF, 0x00, // ######## 
  0xFF, 0x00, // ######## 
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @1235 'G' (13 pixels wide)
  0x00, 0x00, //              
  0x0F, 0xC0, //     ######   
  0x3F, 0xE0, //   #########  
  0x70, 0x70, //  ###     ### 
  0x60, 0x38, //  ##       ###
  0xE0, 0x10, // ###        # 
  0xC0, 0x00, // ##           
  0xC0, 0x00, // ##           
  0xC1, 0xF8, // ##     ######
  0xC1, 0xF8, // ##     ######
  0xC0, 0x18, // ##         ##
  0x60, 0x18, //  ##        ##
  0x78, 0x38, //  ####     ###
  0x3F, 0xF0, //   ########## 
  0x0F, 0xC0, //     ######   
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1273 'H' (11 pixels wide)
  0x00, 0x00, //            
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xFF, 0xE0, // ###########
  0xFF, 0xE0, // ###########
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1311 'I' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @1330 'J' (7 pixels wide)
  0x00, //        
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0x06, //      ##
  0xC6, // ##   ##
  0xC6, // ##   ##
  0xFC, // ###### 
  0x78, //  ####  
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @1349 'K' (11 pixels wide)
  0x00, 0x00, //            
  0xC1, 0xC0, // ##     ### 
  0xC3, 0x80, // ##    ###  
  0xC7, 0x00, // ##   ###   
  0xCE, 0x00, // ##  ###    
  0xDC, 0x00, // ## ###     
  0xD8, 0x00, // ## ##      
  0xF8, 0x00, // #####      
  0xFC, 0x00, // ######     
  0xCE, 0x00, // ##  ###    
  0xC6, 0x00, // ##   ##    
  0xC3, 0x00, // ##    ##   
  0xC3, 0x80, // ##    ###  
  0xC1, 0xC0, // ##     ### 
  0xC0, 0xE0, // ##      ###
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1387 'L' (8 pixels wide)
  0x00, //         
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xFF, // ########
  0xFF, // ########
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @1406 'M' (13 pixels wide)
  0x00, 0x00, //              
  0xE0, 0x38, // ###       ###
  0xF0, 0x78, // ####     ####
  0xF0, 0x78, // ####     ####
  0xF0, 0x78, // ####     ####
  0xD8, 0xD8, // ## ##   ## ##
  0xD8, 0xD8, // ## ##   ## ##
  0xD8, 0xD8, // ## ##   ## ##
  0xD8, 0xD8, // ## ##   ## ##
  0xCD, 0x98, // ##  ## ##  ##
  0xCD, 0x98, // ##  ## ##  ##
  0xCD, 0x98, // ##  ## ##  ##
  0xC5, 0x18, // ##   # #   ##
  0xC7, 0x18, // ##   ###   ##
  0xC7, 0x18, // ##   ###   ##
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1444 'N' (11 pixels wide)
  0x00, 0x00, //            
  0xC0, 0x60, // ##       ##
  0xE0, 0x60, // ###      ##
  0xF0, 0x60, // ####     ##
  0xF0, 0x60, // ####     ##
  0xD8, 0x60, // ## ##    ##
  0xCC, 0x60, // ##  ##   ##
  0xCC, 0x60, // ##  ##   ##
  0xC6, 0x60, // ##   ##  ##
  0xC6, 0x60, // ##   ##  ##
  0xC3, 0x60, // ##    ## ##
  0xC1, 0xE0, // ##     ####
  0xC1, 0xE0, // ##     ####
  0xC0, 0xE0, // ##      ###
  0xC0, 0x60, // ##       ##
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1482 'O' (13 pixels wide)
  0x00, 0x00, //              
  0x0F, 0x80, //     #####    
  0x3F, 0xE0, //   #########  
  0x70, 0x70, //  ###     ### 
  0x60, 0x30, //  ##       ## 
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0x60, 0x30, //  ##       ## 
  0x70, 0x70, //  ###     ### 
  0x3F, 0xE0, //   #########  
  0x0F, 0x80, //     #####    
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1520 'P' (10 pixels wide)
  0x00, 0x00, //           
  0xFF, 0x00, // ########  
  0xFF, 0x80, // ######### 
  0xC1, 0xC0, // ##     ###
  0xC0, 0xC0, // ##      ##
  0xC0, 0xC0, // ##      ##
  0xC0, 0xC0, // ##      ##
  0xC1, 0xC0, // ##     ###
  0xFF, 0x80, // ######### 
  0xFF, 0x00, // ########  
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0xC0, 0x00, // ##        
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1558 'Q' (13 pixels wide)
  0x00, 0x00, //              
  0x0F, 0x80, //     #####    
  0x3F, 0xE0, //   #########  
  0x70, 0x70, //  ###     ### 
  0x60, 0x30, //  ##       ## 
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0x61, 0xB0, //  ##    ## ## 
  0x70, 0xE0, //  ###    ###  
  0x3F, 0xE0, //   #########  
  0x0F, 0xB8, //     ##### ###
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1596 'R' (11 pixels wide)
  0x00, 0x00, //            
  0xFF, 0x00, // ########   
  0xFF, 0x80, // #########  
  0xC1, 0xC0, // ##     ### 
  0xC0, 0xC0, // ##      ## 
  0xC0, 0xC0, // ##      ## 
  0xC1, 0xC0, // ##     ### 
  0xFF, 0x80, // #########  
  0xFF, 0x00, // ########   
  0xC6, 0x00, // ##   ##    
  0xC3, 0x00, // ##    ##   
  0xC3, 0x80, // ##    ###  
  0xC1, 0xC0, // ##     ### 
  0xC0, 0xC0, // ##      ## 
  0xC0, 0xE0, // ##      ###
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1634 'S' (11 pixels wide)
  0x00, 0x00, //            
  0x1F, 0x80, //    ######  
  0x3F, 0xC0, //   ######## 
  0x70, 0xE0, //  ###    ###
  0x60, 0x60, //  ##      ##
  0x60, 0x00, //  ##        
  0x38, 0x00, //   ###      
  0x1F, 0x00, //    #####   
  0x03, 0xC0, //       #### 
  0x00, 0x60, //          ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0x70, 0xE0, //  ###    ###
  0x7F, 0xC0, //  ######### 
  0x1F, 0x00, //    #####   
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1672 'T' (10 pixels wide)
  0x00, 0x00, //           
  0xFF, 0xC0, // ##########
  0xFF, 0xC0, // ##########
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x0C, 0x00, //     ##    
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           
  0x00, 0x00, //           

  // @1710 'U' (11 pixels wide)
  0x00, 0x00, //            
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0xC0, 0x60, // ##       ##
  0x60, 0xC0, //  ##     ## 
  0x7F, 0xC0, //  ######### 
  0x1F, 0x00, //    #####   
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1748 'V' (13 pixels wide)
  0x00, 0x00, //              
  0xC0, 0x18, // ##         ##
  0xC0, 0x18, // ##         ##
  0x60, 0x30, //  ##       ## 
  0x60, 0x30, //  ##       ## 
  0x60, 0x30, //  ##       ## 
  0x30, 0x60, //   ##     ##  
  0x30, 0x60, //   ##     ##  
  0x18, 0xC0, //    ##   ##   
  0x18, 0xC0, //    ##   ##   
  0x18, 0xC0, //    ##   ##   
  0x0D, 0x80, //     ## ##    
  0x0D, 0x80, //     ## ##    
  0x07, 0x00, //      ###     
  0x07, 0x00, //      ###     
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1786 'W' (19 pixels wide)
  0x00, 0x00, 0x00, //                    
  0xC0, 0xE0, 0x60, // ##      ###      ##
  0xC0, 0xE0, 0x60, // ##      ###      ##
  0x61, 0xB0, 0xC0, //  ##    ## ##    ## 
  0x61, 0xB0, 0xC0, //  ##    ## ##    ## 
  0x61, 0xB0, 0xC0, //  ##    ## ##    ## 
  0x63, 0x18, 0xC0, //  ##   ##   ##   ## 
  0x63, 0x18, 0xC0, //  ##   ##   ##   ## 
  0x33, 0x19, 0x80, //   ##  ##   ##  ##  
  0x33, 0x19, 0x80, //   ##  ##   ##  ##  
  0x36, 0x0D, 0x80, //   ## ##     ## ##  
  0x36, 0x0D, 0x80, //   ## ##     ## ##  
  0x36, 0x0D, 0x80, //   ## ##     ## ##  
  0x1C, 0x07, 0x00, //    ###       ###   
  0x1C, 0x07, 0x00, //    ###       ###   
  0x00, 0x00, 0x00, //                    
  0x00, 0x00, 0x00, //                    
  0x00, 0x00, 0x00, //                    
  0x00, 0x00, 0x00, //                    

  // @1843 'X' (13 pixels wide)
  0x00, 0x00, //              
  0x70, 0x70, //  ###     ### 
  0x38, 0xE0, //   ###   ###  
  0x18, 0xC0, //    ##   ##   
  0x1D, 0xC0, //    ### ###   
  0x0D, 0x80, //     ## ##    
  0x07, 0x00, //      ###     
  0x07, 0x00, //      ###     
  0x07, 0x00, //      ###     
  0x0D, 0x80, //     ## ##    
  0x1D, 0xC0, //    ### ###   
  0x38, 0xE0, //   ###   ###  
  0x30, 0x60, //   ##     ##  
  0x70, 0x70, //  ###     ### 
  0xE0, 0x38, // ###       ###
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @1881 'Y' (12 pixels wide)
  0x00, 0x00, //             
  0xE0, 0x70, // ###      ###
  0x60, 0x60, //  ##      ## 
  0x30, 0xC0, //   ##    ##  
  0x39, 0xC0, //   ###  ###  
  0x19, 0x80, //    ##  ##   
  0x1D, 0x80, //    ### ##   
  0x0F, 0x00, //     ####    
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x06, 0x00, //      ##     
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             
  0x00, 0x00, //             

  // @1919 'Z' (11 pixels wide)
  0x00, 0x00, //            
  0x7F, 0xE0, //  ##########
  0x7F, 0xE0, //  ##########
  0x00, 0xC0, //         ## 
  0x01, 0x80, //        ##  
  0x03, 0x00, //       ##   
  0x03, 0x00, //       ##   
  0x06, 0x00, //      ##    
  0x0C, 0x00, //     ##     
  0x18, 0x00, //    ##      
  0x18, 0x00, //    ##      
  0x30, 0x00, //   ##       
  0x60, 0x00, //  ##        
  0xFF, 0xE0, // ###########
  0xFF, 0xE0, // ###########
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            

  // @1957 '[' (4 pixels wide)
  0x00, //     
  0xF0, // ####
  0xF0, // ####
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xC0, // ##  
  0xF0, // ####
  0xF0, // ####

  // @1976 '\' (6 pixels wide)
  0x00, //       
  0xC0, // ##    
  0xC0, // ##    
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x18, //    ## 
  0x18, //    ## 
  0x18, //    ## 
  0x0C, //     ##
  0x0C, //     ##
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       

  // @1995 ']' (4 pixels wide)
  0x00, //     
  0xF0, // ####
  0xF0, // ####
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0xF0, // ####
  0xF0, // ####

  // @2014 '^' (7 pixels wide)
  0x00, //        
  0x10, //    #   
  0x38, //   ###  
  0x28, //   # #  
  0x6C, //  ## ## 
  0x6C, //  ## ## 
  0x44, //  #   # 
  0xC6, // ##   ##
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        
  0x00, //        

  // @2033 '_' (11 pixels wide)
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0x00, 0x00, //            
  0xFF, 0xE0, // ###########
  0xFF, 0xE0, // ###########

  // @2071 '`' (3 pixels wide)
  0x00, //    
  0xC0, // ## 
  0x60, //  ##
  0x20, //   #
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    
  0x00, //    

  // @2090 'a' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0xFF, 0x00, // ######## 
  0xC3, 0x00, // ##    ## 
  0x0F, 0x00, //     #### 
  0x7F, 0x00, //  ####### 
  0xF3, 0x00, // ####  ## 
  0xC3, 0x00, // ##    ## 
  0xC7, 0x00, // ##   ### 
  0xFF, 0x00, // ######## 
  0x79, 0x80, //  ####  ##
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2128 'b' (9 pixels wide)
  0x00, 0x00, //          
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xDE, 0x00, // ## ####  
  0xFF, 0x00, // ######## 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0xFF, 0x00, // ######## 
  0xDE, 0x00, // ## ####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2166 'c' (8 pixels wide)
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x3C, //   ####  
  0x7E, //  ###### 
  0xE7, // ###  ###
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xE7, // ###  ###
  0x7E, //  ###### 
  0x3C, //   ####  
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2185 'd' (9 pixels wide)
  0x00, 0x00, //          
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x3D, 0x80, //   #### ##
  0x7F, 0x80, //  ########
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x80, //  ########
  0x3D, 0x80, //   #### ##
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2223 'e' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE3, 0x00, // ###   ## 
  0xC1, 0x80, // ##     ##
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0xC0, 0x00, // ##       
  0xE1, 0x80, // ###    ##
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2261 'f' (6 pixels wide)
  0x00, //       
  0x3C, //   ####
  0x7C, //  #####
  0x60, //  ##   
  0x60, //  ##   
  0xF8, // ##### 
  0xF8, // ##### 
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x60, //  ##   
  0x00, //       
  0x00, //       
  0x00, //       
  0x00, //       

  // @2280 'g' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x3D, 0x80, //   #### ##
  0x7F, 0x80, //  ########
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x80, //  ########
  0x3D, 0x80, //   #### ##
  0x01, 0x80, //        ##
  0xC3, 0x80, // ##    ###
  0xFF, 0x00, // ######## 
  0x3E, 0x00, //   #####  

  // @2318 'h' (8 pixels wide)
  0x00, //         
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xDE, // ## #### 
  0xFF, // ########
  0xE3, // ###   ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2337 'i' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @2356 'j' (4 pixels wide)
  0x00, //     
  0x30, //   ##
  0x30, //   ##
  0x00, //     
  0x00, //     
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0x30, //   ##
  0xF0, // ####
  0xE0, // ### 

  // @2375 'k' (8 pixels wide)
  0x00, //         
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC0, // ##      
  0xC7, // ##   ###
  0xCE, // ##  ### 
  0xDC, // ## ###  
  0xF8, // #####   
  0xF8, // #####   
  0xDC, // ## ###  
  0xCC, // ##  ##  
  0xCE, // ##  ### 
  0xC6, // ##   ## 
  0xC7, // ##   ###
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2394 'l' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0x00, //   
  0x00, //   
  0x00, //   
  0x00, //   

  // @2413 'm' (14 pixels wide)
  0x00, 0x00, //               
  0x00, 0x00, //               
  0x00, 0x00, //               
  0x00, 0x00, //               
  0x00, 0x00, //               
  0xDE, 0x78, // ## ####  #### 
  0xFE, 0xFC, // ####### ######
  0xE3, 0x8C, // ###   ###   ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0xC3, 0x0C, // ##    ##    ##
  0x00, 0x00, //               
  0x00, 0x00, //               
  0x00, 0x00, //               
  0x00, 0x00, //               

  // @2451 'n' (8 pixels wide)
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0xDE, // ## #### 
  0xFF, // ########
  0xE3, // ###   ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2470 'o' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x3E, 0x00, //   #####  
  0x7F, 0x00, //  ####### 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x80, // ###   ###
  0x7F, 0x00, //  ####### 
  0x3E, 0x00, //   #####  
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2508 'p' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xDE, 0x00, // ## ####  
  0xFF, 0x00, // ######## 
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xE3, 0x00, // ###   ## 
  0xFF, 0x00, // ######## 
  0xDE, 0x00, // ## ####  
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       
  0xC0, 0x00, // ##       

  // @2546 'q' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x3D, 0x80, //   #### ##
  0x7F, 0x80, //  ########
  0xE3, 0x80, // ###   ###
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0x63, 0x80, //  ##   ###
  0x7F, 0x80, //  ########
  0x3D, 0x80, //   #### ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##
  0x01, 0x80, //        ##

  // @2584 'r' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      
  0xD8, // ## ##
  0xF8, // #####
  0xE0, // ###  
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0xC0, // ##   
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @2603 's' (8 pixels wide)
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x7C, //  #####  
  0xFE, // ####### 
  0xC3, // ##    ##
  0xE0, // ###     
  0x78, //  ####   
  0x1E, //    #### 
  0x07, //      ###
  0xC3, // ##    ##
  0x7F, //  #######
  0x3E, //   ##### 
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2622 't' (5 pixels wide)
  0x00, //      
  0x00, //      
  0x60, //  ##  
  0x60, //  ##  
  0x60, //  ##  
  0xF8, // #####
  0xF8, // #####
  0x60, //  ##  
  0x60, //  ##  
  0x60, //  ##  
  0x60, //  ##  
  0x60, //  ##  
  0x60, //  ##  
  0x78, //  ####
  0x38, //   ###
  0x00, //      
  0x00, //      
  0x00, //      
  0x00, //      

  // @2641 'u' (8 pixels wide)
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC3, // ##    ##
  0xC7, // ##   ###
  0xFF, // ########
  0x7B, //  #### ##
  0x00, //         
  0x00, //         
  0x00, //         
  0x00, //         

  // @2660 'v' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0x63, 0x00, //  ##   ## 
  0x63, 0x00, //  ##   ## 
  0x63, 0x00, //  ##   ## 
  0x36, 0x00, //   ## ##  
  0x36, 0x00, //   ## ##  
  0x1C, 0x00, //    ###   
  0x1C, 0x00, //    ###   
  0x08, 0x00, //     #    
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2698 'w' (13 pixels wide)
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0xC2, 0x18, // ##    #    ##
  0xC7, 0x18, // ##   ###   ##
  0xC7, 0x18, // ##   ###   ##
  0x65, 0x30, //  ##  # #  ## 
  0x6D, 0xB0, //  ## ## ## ## 
  0x6D, 0xB0, //  ## ## ## ## 
  0x28, 0xA0, //   # #   # #  
  0x38, 0xE0, //   ###   ###  
  0x38, 0xE0, //   ###   ###  
  0x18, 0xC0, //    ##   ##   
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              
  0x00, 0x00, //              

  // @2736 'x' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xC1, 0x80, // ##     ##
  0x63, 0x00, //  ##   ## 
  0x36, 0x00, //   ## ##  
  0x36, 0x00, //   ## ##  
  0x1C, 0x00, //    ###   
  0x1C, 0x00, //    ###   
  0x36, 0x00, //   ## ##  
  0x36, 0x00, //   ## ##  
  0x63, 0x00, //  ##   ## 
  0xC1, 0x80, // ##     ##
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2774 'y' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0xC1, 0x80, // ##     ##
  0xC1, 0x80, // ##     ##
  0x63, 0x00, //  ##   ## 
  0x63, 0x00, //  ##   ## 
  0x33, 0x00, //   ##  ## 
  0x36, 0x00, //   ## ##  
  0x1E, 0x00, //    ####  
  0x1E, 0x00, //    ####  
  0x0C, 0x00, //     ##   
  0x0C, 0x00, //     ##   
  0x0C, 0x00, //     ##   
  0x18, 0x00, //    ##    
  0x78, 0x00, //  ####    
  0x70, 0x00, //  ###     

  // @2812 'z' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x7F, 0x80, //  ########
  0x7F, 0x80, //  ########
  0x03, 0x80, //       ###
  0x07, 0x00, //      ### 
  0x1E, 0x00, //    ####  
  0x38, 0x00, //   ###    
  0x70, 0x00, //  ###     
  0xE0, 0x00, // ###      
  0xFF, 0x80, // #########
  0xFF, 0x80, // #########
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          

  // @2850 '{' (6 pixels wide)
  0x00, //       
  0x1C, //    ###
  0x3C, //   ####
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x70, //  ###  
  0xE0, // ###   
  0xE0, // ###   
  0x70, //  ###  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x3C, //   ####
  0x1C, //    ###

  // @2869 '|' (2 pixels wide)
  0x00, //   
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##
  0xC0, // ##

  // @2888 '}' (6 pixels wide)
  0x00, //       
  0xE0, // ###   
  0xF0, // ####  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x38, //   ### 
  0x1C, //    ###
  0x1C, //    ###
  0x38, //   ### 
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0x30, //   ##  
  0xF0, // ####  
  0xE0, // ###   

  // @2907 '~' (9 pixels wide)
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x70, 0x00, //  ###     
  0xF8, 0x80, // #####   #
  0x8F, 0x80, // #   #####
  0x07, 0x00, //      ### 
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
  0x00, 0x00, //          
};


// Font descriptor: dsc[ch][0] width of ch, dsc[ch][1] height of ch, dsc[ch][2] offset in toled_sans14_bmp of ch
static const int toled_sans14_dsc[95][3] = {
  {4, 19, 0},     //   
  {2, 19, 19},    // ! 
  {5, 19, 38},    // " 
  {11, 19, 57},     // # 
  {9, 19, 95},    // $ 
  {15, 19, 133},    // % 
  {12, 19, 171},    // & 
  {2, 19, 209},     // ' 
  {5, 19, 228},     // ( 
  {5, 19, 247},     // ) 
  {5, 19, 266},     // * 
  {10, 19, 285},    // + 
  {2, 19, 323},     // , 
  {5, 19, 342},     // - 
  {2, 19, 361},     // . 
  {6, 19, 380},     // / 
  {9, 19, 399},     // 0 
  {5, 19, 437},     // 1 
  {9, 19, 456},     // 2 
  {9, 19, 494},     // 3 
  {10, 19, 532},    // 4 
  {9, 19, 570},     // 5 
  {9, 19, 608},     // 6 
  {9, 19, 646},     // 7 
  {9, 19, 684},     // 8 
  {9, 19, 722},     // 9 
  {2, 19, 760},     // : 
  {2, 19, 779},     // ; 
  {9, 19, 798},     // < 
  {9, 19, 836},     // = 
  {9, 19, 874},     // > 
  {9, 19, 912},     // ? 
  {18, 19, 950},    // @ 
  {13, 19, 1007},   // A 
  {10, 19, 1045},   // B 
  {12, 19, 1083},   // C 
  {11, 19, 1121},   // D 
  {10, 19, 1159},   // E 
  {9, 19, 1197},    // F 
  {13, 19, 1235},   // G 
  {11, 19, 1273},   // H 
  {2, 19, 1311},    // I 
  {7, 19, 1330},    // J 
  {11, 19, 1349},   // K 
  {8, 19, 1387},    // L 
  {13, 19, 1406},   // M 
  {11, 19, 1444},   // N 
  {13, 19, 1482},   // O 
  {10, 19, 1520},   // P 
  {13, 19, 1558},   // Q 
  {11, 19, 1596},   // R 
  {11, 19, 1634},   // S 
  {10, 19, 1672},   // T 
  {11, 19, 1710},   // U 
  {13, 19, 1748},   // V 
  {19, 19, 1786},   // W 
  {13, 19, 1843},   // X 
  {12, 19, 1881},   // Y 
  {11, 19, 1919},   // Z 
  {4, 19, 1957},    // [ 
  {6, 19, 1976},    //  
  {4, 19, 1995},    // ] 
  {7, 19, 2014},    // ^ 
  {11, 19, 2033},   // _ 
  {3, 19, 2071},    // ` 
  {9, 19, 2090},    // a 
  {9, 19, 2128},    // b 
  {8, 19, 2166},    // c 
  {9, 19, 2185},    // d 
  {9, 19, 2223},    // e 
  {6, 19, 2261},    // f 
  {9, 19, 2280},    // g 
  {8, 19, 2318},    // h 
  {2, 19, 2337},    // i 
  {4, 19, 2356},    // j 
  {8, 19, 2375},    // k 
  {2, 19, 2394},    // l 
  {14, 19, 2413},   // m 
  {8, 19, 2451},    // n 
  {9, 19, 2470},    // o 
  {9, 19, 2508},    // p 
  {9, 19, 2546},    // q 
  {5, 19, 2584},    // r 
  {8, 19, 2603},    // s 
  {5, 19, 2622},    // t 
  {8, 19, 2641},    // u 
  {9, 19, 2660},    // v 
  {13, 19, 2698},   // w 
  {9, 19, 2736},    // x 
  {9, 19, 2774},    // y 
  {9, 19, 2812},    // z 
  {6, 19, 2850},    // { 
  {2, 19, 2869},    // | 
  {6, 19, 2888},    // } 
  {9, 19, 2907},    // ~ 
};


void toled_sans14(char ch, int * width, int * height, const uint8_t ** bmp ) {
  if( ch<' ' || ch> '~' ) {
    *width = 0;
    *height= 0;
    *bmp   = 0;
  } else {
    int ix = ch - ' ';
    *width = toled_sans14_dsc[ix][0];
    *height= toled_sans14_dsc[ix][1];
    *bmp   = &toled_sans14_bmp[ toled_sans14_dsc[ix][2] ];
  }
}
