// saidbasic.ino - the demo application for the SAIDbasic board
/*****************************************************************************
 * Copyright 2024,2025 by ams OSRAM AG                                       *
 * All rights are reserved.                                                  *
 *                                                                           *
 * IMPORTANT - PLEASE READ CAREFULLY BEFORE COPYING, INSTALLING OR USING     *
 * THE SOFTWARE.                                                             *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         *
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         *
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  *
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     *
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT          *
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     *
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY     *
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT       *
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE     *
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.      *
 *****************************************************************************/
#include <aospi.h>     // aospi_init()
#include <aoosp.h>     // aoosp_init()
#include <aocmd.h>     // aocmd_cint_pollserial()
#include <aoui32.h>    // aoui32_oled_splash()
#include <aomw.h>      // aomw_init()
#include <aoapps.h>    // aoapps_mngr_start()


/*
DESCRIPTION
This is a template for a sketch using multiple apps and the app manager.
It contains two apps ("runled" and "sensors"). The "A" button switches to 
the next app. For simplicity the command interpreter has not been added. 

HARDWARE
The demo should run on the OSP32 board, connected to the SAIDsense board. 
In Arduino select board "ESP32S3 Dev Module".

BEHAVIOR
The behavior depends on the app chosen and the buttons pressed.

OUTPUT
Welcome to aoapps_sensors.ino

spi: init(MCU-B)
osp: init
mw: init
apps: init
ui32: init
sensors: using temp sensor 48 on SAID 003 
sensors: using rotation sensor 36 on SAID 003
sensors: using light sensor 26 on SAID 003
sensors: using display 38 on SAID 003
sensors: using selector 3F on SAID 003
*/


void setup() {
  // Identify over Serial
  Serial.begin(115200);
  do delay(250); while( ! Serial );
  Serial.printf("\n\nWelcome to aoapps_sensors.ino\n\n");

  // Initialize all libraries
  aospi_init(); 
  aoosp_init();
  aomw_init();
  aoapps_init();
  aoui32_init();

  // Splash screen
  aoui32_oled_splash("aoapps_sensors", "1.0");
  delay(1000);

  // App registration
  aoapps_runled_register();  // First app registered
  aoapps_sensors_register(); // Second  app registered
  aoapps_sensors_resethw();  // Switch off display on SAISsense

  // Start
  aoapps_mngr_start();
}


void loop() {
  // Check physical buttons
  aoui32_but_scan();

  // Switch to next app when A was pressed
  if( aoui32_but_wentdown(AOUI32_BUT_A) ) aoapps_mngr_switchnext();

  // Animation step in current application
  aoapps_mngr_step();
}



