// caldb.hpp - calibration data base, a table with triplet instance data
/*****************************************************************************
 * Copyright 2025 by ams OSRAM AG                                            *
 * All rights are reserved.                                                  *
 *                                                                           *
 * IMPORTANT - PLEASE READ CAREFULLY BEFORE COPYING, INSTALLING OR USING     *
 * THE SOFTWARE.                                                             *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         *
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         *
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  *
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     *
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT          *
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     *
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY     *
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT       *
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE     *
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.      *
 *****************************************************************************/

// This file comes with reel of RGB triplets; it contains the calibration data for those triplets.

// This file is given an extension .hpp because (1) that is tabbed in the 
// Arduino IDE, and (2) is not automatically compiled. Each line has the 
// calibration data for one triplet, wrapped in a TRIPLET() tag.
// The tagging allows a .cpp file to #include this .hpp file with an 
// appropriate definition of the TRIPLET macro, matching an array definition.
// The .cpp file could even include this file multiple times with different 
// definitions of TRIPLET. It also means that the cpp file _must_ define 
// TRIPLET before #including this file.

// The first line is the header of the columns. Abbreviations used
//   CX CY IV       denote a color point
//   RED GRN BLU    denote one of the LEDs of a triplet
//   20 50          denote drive currents
//   A B            denote temperature coefficients
//   UF LDOM        denote forward voltage and dominant wavelength

// There are 52 columns in total; not all are actually stored in flash (see caldb.cpp)
//   4 = 4     administrative fields (index,calweek,pocket,DMC)
//  18 = 3x3x2 floats Cx,Cy,Iv for R,G,B for 20,50 mA
//  12 = 2x3x2 floats Uf,Ldom for R,G,B for 20,50 mA
//  18 = 2x3x3 floats a,b for Cx,Cy,Iv for R,G,B

//TRIPLET(index,calweek,pocket,DMC,CX_BLU_20,CX_BLU_50,CX_GRN_20,CX_GRN_50,CX_RED_20,CX_RED_50,CY_BLU_20,CY_BLU_50,CY_GRN_20,CY_GRN_50,CY_RED_20,CY_RED_50,IV_BLU_20,IV_BLU_50,IV_GRN_20,IV_GRN_50,IV_RED_20,IV_RED_50,UF_BLU_20,UF_BLU_50,UF_GRN_20,UF_GRN_50,UF_RED_20,UF_RED_50,LDOM_RED_20,LDOM_GRN_20,LDOM_BLU_20,LDOM_RED_50,LDOM_GRN_50,LDOM_BLU_50,CX_A_RED_20,CX_B_RED_20,CY_A_RED_20,CY_B_RED_20,IV_A_RED_20,IV_B_RED_20,CX_A_GRN_20,CX_B_GRN_20,CY_A_GRN_20,CY_B_GRN_20,IV_A_GRN_20,IV_B_GRN_20,CX_A_BLU_20,CX_B_BLU_20,CY_A_BLU_20,CY_B_BLU_20,IV_A_BLU_20,IV_B_BLU_20)

TRIPLET(  0,202447,1,0ECLTD0510,0.1538,0.1549,0.1379,0.1255,0.6973,0.698,0.0235,0.0223,0.7401,0.7216,0.3024,0.3018,0.4054,0.8572,2.7084,5.0629,1.0992,2.553,2.8659,3.0163,2.5908,2.8865,2.1239,2.4299,623.1715555505127,523.1459203329947,453.65452300273074,623.5186451117542,520.00001326365,452.6324510183392,0.00013029481473596702,-8.352048904957737e-07,-0.0003495894864130287,1.117933317355124e-06,-0.006431525921355887,5.2754184209989185e-06,0.0022068075654756336,2.6913508316171434e-06,-0.00019740191196339764,-8.300986668287956e-07,-0.0012302910414404605,-2.1882017743424295e-06,-0.0003142716928864792,-3.581492148321527e-07,0.0025126128914878913,6.651581651104691e-06,0.0012858957727819274,-3.684776527060959e-06)
TRIPLET(  1,202447,2,0ECJ5C0403,0.154,0.1551,0.1362,0.1239,0.6964,0.6973,0.0232,0.0221,0.7387,0.7198,0.3031,0.3025,0.4042,0.8561,2.6487,4.9615,1.1157,2.5744,2.8561,3.0055,2.5892,2.8837,2.1376,2.4548,622.7844078282682,522.7525994248292,453.44713336833604,623.1078562815069,520.00001326365,452.44663414036876,0.00013310471984263048,-8.324572859346598e-07,-0.00035302426525291134,1.050571637008401e-06,-0.0064163689948456,5.202205024840179e-06,0.002235354894284225,2.7230635745647283e-06,-0.00019147152656174752,-8.392762273528737e-07,-0.001216700803606224,-2.243866753257241e-06,-0.00030854825684369525,-3.525403782466303e-07,0.0024534918964817555,6.444165404517953e-06,0.0012279812248001398,-3.920837130901806e-06)
TRIPLET(  2,202447,3,0ECJTJ0419,0.1535,0.1547,0.1446,0.1316,0.697,0.6978,0.0237,0.0225,0.741,0.7238,0.3026,0.3019,0.4067,0.8605,2.7169,5.0589,1.1155,2.5685,2.8743,3.0315,2.5996,2.9077,2.147,2.4752,623.0571483010252,524.3691194435115,453.8894971884302,623.4649735019518,520.8633107311092,452.8180763481897,0.00012938020189483167,-8.171463569575574e-07,-0.00034714232723885737,1.0396993379743445e-06,-0.006420255920299812,5.426824260357033e-06,0.0021167900760049327,2.5766487413096622e-06,-0.00021575208526564835,-7.98758100180387e-07,-0.0012729809619898202,-2.000169437065584e-06,-0.0003195219475418691,-3.6745569907129455e-07,0.002565457008574268,6.884557550349025e-06,0.0013344201806420354,-3.4229903225020122e-06)
TRIPLET(  3,202447,4,0ECJJZ0310,0.1542,0.1552,0.1383,0.1255,0.6971,0.6978,0.0229,0.0219,0.7392,0.7205,0.3026,0.3019,0.4054,0.8544,2.6989,5.0348,1.1138,2.5774,2.8247,2.9862,2.5821,2.8725,2.1357,2.4524,623.0527597757919,523.1488671521162,453.2395236104917,623.4649735019518,520.00001326365,452.32212005834464,0.00013046127598055775,-8.274852615236467e-07,-0.0003492630080979472,1.074007135725463e-06,-0.006424167369076412,5.3219477728754525e-06,0.0022094126809720444,2.727741165231308e-06,-0.00019765796094616683,-8.364065670735224e-07,-0.001229424001840805,-2.221771239667878e-06,-0.0002929606450250077,-3.7049682619423293e-07,0.002281384538164897,6.220330203383028e-06,0.001033501020161462,-4.202447451155224e-06)
TRIPLET(  4,202447,5,0ECJI60212,0.1535,0.1546,0.1377,0.1244,0.6966,0.6973,0.0237,0.0226,0.738,0.718,0.303,0.3024,0.4154,0.8724,2.758,5.1349,1.1121,2.5795,2.8226,2.9861,2.6101,2.9269,2.1302,2.4406,622.8350151847785,522.9587691908345,453.8894971884302,623.1715555505127,520.00001326365,452.91081911335084,0.00013325117156196524,-8.378942078527787e-07,-0.00035359461596095546,1.0765499700863529e-06,-0.006420349678871701,5.160828318047431e-06,0.0022138996664843825,2.6220964107279233e-06,-0.00019409280069222144,-8.197818631506759e-07,-0.0012260555114992015,-2.1364268317020726e-06,-0.00029591503225926785,-4.2390107505100034e-07,0.002295042030059039,6.8457667355884515e-06,0.001007537469217147,-3.531466942768532e-06)
TRIPLET(  5,202447,6,0ECIBD0209,0.1543,0.1553,0.147,0.1338,0.6969,0.6977,0.0229,0.0218,0.7421,0.7256,0.3027,0.302,0.4039,0.8571,2.678,5.0059,1.109,2.5579,2.8568,3.0069,2.6108,2.9276,2.1454,2.471,622.9976910754363,524.8672851343766,453.18103990740934,623.4066843302342,521.3662147189402,452.22909530497844,0.0001301510012636753,-8.200774906539085e-07,-0.00034834295457893393,1.0406942476209955e-06,-0.0064192484576644825,5.381937377473854e-06,0.0020776647560877973,2.4979142850824132e-06,-0.0002230404637574609,-7.804196827338187e-07,-0.001291214038155645,-1.893879307883647e-06,-0.0003072658257272918,-3.3085153073061443e-07,0.0024470652219377494,6.187997354115711e-06,0.001237600605495992,-4.1958657709158045e-06)
TRIPLET(  6,202447,7,0ECKX30311,0.1531,0.1542,0.145,0.1316,0.6973,0.698,0.0243,0.0231,0.7422,0.7254,0.3025,0.3018,0.4121,0.8769,2.7081,5.0565,1.0954,2.5457,2.8741,3.0193,2.5912,2.8921,2.1225,2.4281,623.1078562815069,524.5237454501938,454.2899975335142,623.5186451117542,520.9845147706442,453.30007321329265,0.0001310918334455016,-8.380607576011396e-07,-0.0003508186833960569,1.1180374009699572e-06,-0.006430334599472992,5.230182439810935e-06,0.002108488858704023,2.6021423102373484e-06,-0.00021830281221009874,-8.017588309520299e-07,-0.001277319568402381,-2.013509145499208e-06,-0.0003218419046821816,-3.991679090020696e-07,0.0025795944800724186,7.270759489953629e-06,0.001325338843233919,-3.007250563769993e-06)
TRIPLET(  7,202447,8,0ECKM60407,0.1535,0.1545,0.1437,0.1306,0.6971,0.6978,0.0237,0.0227,0.7425,0.7266,0.3028,0.302,0.4166,0.877,2.7553,5.1743,1.0833,2.5103,2.819,2.9868,2.5812,2.8879,2.1296,2.4414,622.9317368619229,524.3193137164619,453.8894971884302,623.4022841735936,520.9100739219368,453.00336413382723,0.00013229063082744288,-8.360253698049796e-07,-0.0003522235387935619,1.0847371250683613e-06,-0.006423130202706912,5.204757363547382e-06,0.0021262932411448016,2.6571720430606553e-06,-0.0002154431500490635,-8.132396599260114e-07,-0.0012692363161358078,-2.078208455575922e-06,-0.0002942712238450055,-4.2783150742096055e-07,0.002276212360375193,6.843065634367213e-06,0.000984775810394526,-3.539020440504692e-06)
TRIPLET(  8,202447,9,0ECN3B0306,0.1533,0.1544,0.139,0.1266,0.6967,0.6976,0.0241,0.0229,0.7407,0.7228,0.3029,0.3021,0.4186,0.8795,2.7214,5.0986,1.1159,2.5783,2.8173,2.9742,2.6154,2.9446,2.1331,2.4463,622.889401436803,523.3774061430661,454.12122012721716,623.3482088450268,520.00001326365,453.1225079615919,0.0001324145425617245,-8.339126902958782e-07,-0.0003522353426542643,1.0712420667125376e-06,-0.006420759188445714,5.214934032711927e-06,0.0021823509822069234,2.573219496140951e-06,-0.00020031752154505778,-8.073807869693094e-07,-0.0012409205070485685,-2.0631465894325316e-06,-0.00029489010799147353,-4.4790937210696723e-07,0.0022761055334605904,7.065327052894804e-06,0.000969504576389519,-3.301804360001157e-06)
TRIPLET(  9,202447,10,0ECI5B0417,0.1533,0.1545,0.1356,0.1234,0.6965,0.6973,0.0241,0.0228,0.7382,0.7189,0.3031,0.3023,0.4109,0.8628,2.6635,4.9856,1.1115,2.5695,2.8722,3.0173,2.5913,2.8869,2.1327,2.4456,622.7804419790724,522.6133758254336,454.12122012721716,623.2350475116187,520.00001326365,453.03364338318573,0.00013359516248249938,-8.369919702905752e-07,-0.00035397542009694716,1.0653130338096897e-06,-0.006418010368750086,5.155674469986525e-06,0.0022445970083881527,2.7230787404431945e-06,-0.0001893075843609669,-8.405731922552762e-07,-0.0012121867988993708,-2.25316869907228e-06,-0.0003199581863089745,-3.8797027846507435e-07,0.00256325799613924,7.1065188465187006e-06,0.0013166198734345137,-3.186613519524717e-06)
TRIPLET( 10,202447,11,0ECI6X0313,0.1536,0.1548,0.135,0.1245,0.6969,0.6977,0.0237,0.0225,0.7418,0.7254,0.3026,0.302,0.4139,0.8739,2.6573,5.0319,1.0973,2.5492,2.8616,3.0113,2.6331,2.954,2.1266,2.4346,623.0615620161075,522.7756517807755,453.8314170616765,623.4066843302342,520.00001326365,452.7568378144337,0.0001312023540189361,-8.35503644143365e-07,-0.0003507820319771127,1.1024454756450924e-06,-0.006427644660478049,5.243787726841503e-06,0.0022195070738843933,2.5370297840985574e-06,-0.00019075503303809006,-8.06674767352059e-07,-0.001222369009245642,-2.069710878796724e-06,-0.00031337327555486217,-3.767541866147392e-07,0.002496828214238637,6.819000316315286e-06,0.0012552556904584546,-3.509988369553392e-06)
TRIPLET( 11,202447,12,0ECM4T0218,0.1539,0.155,0.1386,0.1262,0.6965,0.6974,0.0233,0.0221,0.7401,0.7218,0.303,0.3024,0.4088,0.8626,2.6708,5.0108,1.1112,2.5743,2.8705,3.0255,2.5956,2.9,2.1317,2.4442,622.838982512759,523.2654174753243,453.5357202154199,623.1671524279715,520.00001326365,452.508031085015,0.00013307212880048756,-8.364373789774045e-07,-0.0003532613129872858,1.0722180633527e-06,-0.006419920280162167,5.176477987620539e-06,0.0021967385574510768,2.663579029259793e-06,-0.00019909887107191738,-8.241528622328032e-07,-0.0012348997196666876,-2.1544608451678638e-06,-0.00031565684254450214,-3.4378478783896324e-07,0.0025321690344585687,6.540427178002104e-06,0.0013172988584898536,-3.7985726601987333e-06)
TRIPLET( 12,202447,13,0ECIB80219,0.154,0.1551,0.144,0.1309,0.6965,0.6974,0.0232,0.0221,0.7409,0.7236,0.303,0.3023,0.4095,0.867,2.7262,5.0927,1.1112,2.5762,2.8729,3.0295,2.6093,2.9249,2.1377,2.457,622.838982512759,524.2579225127539,453.44713336833604,623.2306448187245,520.7328253801646,452.44663414036876,0.00013252257220450808,-8.310058042284931e-07,-0.0003521709462226955,1.0538485463310803e-06,-0.006417781569656502,5.23097499980133e-06,0.0021215757155704272,2.5429307178636985e-06,-0.00021382888386056758,-7.939218023518459e-07,-0.001270267866510947,-1.9763011416745472e-06,-0.0003162193627769196,-3.341983605201495e-07,0.0025413636883397026,6.456770543550402e-06,0.0013342022993057118,-3.885587474799727e-06)
TRIPLET( 13,202447,14,0ECK6B0605,0.1534,0.1545,0.1451,0.1315,0.697,0.6977,0.0239,0.0228,0.7419,0.7252,0.3028,0.3021,0.4097,0.8721,2.7105,5.0739,1.1127,2.5802,2.8681,3.0153,2.5871,2.892,2.1328,2.4471,622.9357003143722,524.5199579431654,454.0077409373861,623.3438062032577,520.9528336555517,453.03364338318573,0.00013195592105359405,-8.330296913967559e-07,-0.00035158135787645856,1.0752002673995951e-06,-0.006422094733177817,5.235845874686291e-06,0.002110085436028343,2.6196206000241274e-06,-0.00021834492159688099,-8.048368872645885e-07,-0.0012767344530461883,-2.029979664405329e-06,-0.000317402850581757,-3.8352302420552227e-07,0.002537510929545673,6.993972244629571e-06,0.0012929117132044511,-3.313132195510482e-06)
TRIPLET( 14,202447,15,0ECJML0108,0.154,0.155,0.1424,0.1281,0.697,0.6978,0.0233,0.0222,0.7394,0.7204,0.3025,0.3019,0.4003,0.8482,2.7903,5.1852,1.0968,2.5474,2.8551,3.0132,2.6036,2.918,2.1266,2.4355,623.1210610789501,523.8727296261246,453.47741497196233,623.4649735019518,520.0374022491424,452.53956127768106,0.00013057766381965354,-8.340198870641071e-07,-0.0003498715288798789,1.1063518506704864e-06,-0.006429223556128303,5.2741634320692125e-06,0.002150870473934669,2.591364812709097e-06,-0.00020812144432776108,-8.059348662442322e-07,-0.001256498834630265,-2.046939380215935e-06,-0.00030827395889374085,-3.560133973223641e-07,0.002449409453350709,6.472626953972478e-06,0.0012210675179244283,-3.891469749031926e-06)
TRIPLET( 15,202447,16,0ECN4L0106,0.1536,0.1548,0.1374,0.1252,0.6966,0.6974,0.0237,0.0225,0.7396,0.7212,0.303,0.3023,0.4098,0.8618,2.7072,5.0702,1.1103,2.5737,2.8168,2.9734,2.6149,2.9437,2.1266,2.4333,622.8350151847785,523.0246566646196,453.8314170616765,623.2306448187245,520.00001326365,452.7568378144337,0.0001335809055195529,-8.411531527021255e-07,-0.00035424883601970966,1.0875716802993238e-06,-0.0064216329051751,5.128130110738958e-06,0.0022076510958140777,2.5977301802775163e-06,-0.0001949761505838675,-8.149273389687451e-07,-0.0012288360919939577,-2.1094222863368237e-06,-0.0002929169930662638,-4.2566623388535464e-07,0.002262503435950778,6.785386612228755e-06,0.0009719994917769294,-3.6039874524922713e-06)
TRIPLET( 16,202447,17,0ECN4U0218,0.1538,0.1549,0.1372,0.1251,0.6969,0.6977,0.0234,0.0223,0.7398,0.7217,0.3027,0.302,0.405,0.851,2.6833,5.0267,1.0985,2.5506,2.8156,2.9738,2.6083,2.9296,2.1263,2.4332,622.9976910754363,523.0052198072563,453.62424516763923,623.4066843302342,520.00001326365,452.6324510183392,0.00013190042309420988,-8.373680036046082e-07,-0.00035181395544621295,1.0991705434731483e-06,-0.006426056686107517,5.208455222031675e-06,0.0022111718496484654,2.6267133850632856e-06,-0.0001948414829939973,-8.20153806283638e-07,-0.0012274393065686937,-2.137612044216857e-06,-0.00029112174362229425,-4.1068515337186777e-07,0.0022483726844949037,6.584633044652475e-06,0.0009684557678825527,-3.821777335791401e-06)
TRIPLET( 17,202447,18,0ECJUC0809,0.1537,0.1548,0.1403,0.1275,0.698,0.6987,0.0236,0.0225,0.7395,0.7205,0.3016,0.301,0.4095,0.8621,2.6663,4.9604,1.1091,2.5247,2.8385,2.9978,2.6043,2.9125,2.1377,2.4507,623.6430409868206,523.514321613045,453.74300271511225,623.980639418667,520.00001326365,452.7568378144337,0.00012408063338398102,-8.109546068477705e-07,-0.0003398665888763213,1.1066385196847857e-06,-0.006439118450719735,5.6414662248230395e-06,0.00217618554506689,2.6111897804005766e-06,-0.00020266504791760018,-8.127182745093652e-07,-0.0012443549146378089,-2.089244761721199e-06,-0.0003022931914213737,-3.9502188671361045e-07,0.002372652580944006,6.716377288196815e-06,0.001110927347819965,-3.650327881382444e-06)
TRIPLET( 18,202447,19,0ECJPU0516,0.1538,0.1549,0.1405,0.1267,0.6971,0.6978,0.0234,0.0223,0.739,0.7194,0.3027,0.302,0.4002,0.8432,2.7574,5.1254,1.0961,2.5453,2.8285,2.9924,2.623,2.9484,2.127,2.4364,622.989757323568,523.5125819412151,453.62424516763923,623.4022841735936,520.00001326365,452.6324510183392,0.00013191960589076362,-8.369321677143909e-07,-0.0003518081547202227,1.0965065474681184e-06,-0.006425596636039534,5.210762835291407e-06,0.0021702586362301185,2.5326796229622103e-06,-0.00020218441526647423,-7.99066392558316e-07,-0.001246375217650567,-2.0165124026207955e-06,-0.0002970120571067344,-3.9660110404617677e-07,0.0023158456675286855,6.594311990695248e-06,0.0010500183786636176,-3.7947106355701607e-06)
TRIPLET( 19,202447,20,0ECKHL0619,0.1536,0.1547,0.1351,0.1228,0.6967,0.6973,0.0236,0.0225,0.7376,0.7176,0.3031,0.3025,0.4118,0.8703,2.6619,4.9775,1.1132,2.5823,2.8638,3.0204,2.6082,2.9231,2.1267,2.434,622.772537655011,522.484179060501,453.80113607150946,623.1078562815069,520.00001326365,452.8180763481897,0.00013422770784396863,-8.426206590144392e-07,-0.00035518674526315865,1.0831635972103463e-06,-0.006419939326323815,5.097142109915478e-06,0.0022483356350285516,2.6602331020469235e-06,-0.00018693631690341032,-8.308333252639963e-07,-0.0012096606180244983,-2.20347412331134e-06,-0.00031419551333633933,-3.719710716558311e-07,0.0025071872371881226,6.791439725722249e-06,0.0012697566049684646,-3.536837281399812e-06)
TRIPLET( 20,202447,21,0ECM6I0319,0.1532,0.1543,0.1349,0.1231,0.6967,0.6975,0.0242,0.0229,0.7381,0.7189,0.303,0.3023,0.422,0.8902,2.6863,5.024,1.1063,2.5697,2.8695,3.0236,2.606,2.9157,2.1341,2.4504,622.8310453574378,522.4871201375809,454.20563924370344,623.2262369903721,520.00001326365,453.18103990740934,0.00013293563962824594,-8.344626817818905e-07,-0.0003529466270937378,1.064349147406562e-06,-0.006418854171801918,5.194224683453434e-06,0.0022488379110181147,2.6692957598202984e-06,-0.0001870343911508902,-8.323837265627915e-07,-0.001209516247301578,-2.2116870247577013e-06,-0.0003192335895175213,-3.975565070333876e-07,0.002552336198246836,7.185929890655953e-06,0.0012979009717662762,-3.1045588466138464e-06)
TRIPLET( 21,202447,22,0ECKJ20116,0.154,0.1551,0.1358,0.1234,0.6969,0.6976,0.0232,0.0221,0.737,0.7171,0.3029,0.3022,0.4074,0.862,2.6637,4.9851,1.1118,2.5652,2.866,3.0166,2.6049,2.9165,2.1308,2.4398,622.8814782279493,522.5588838561985,453.44713336833604,623.2851115333052,520.00001326365,452.44663414036876,0.00013270839296346845,-8.361923788638337e-07,-0.00035277456397277883,1.0777635214135615e-06,-0.006421368773405049,5.189998522344186e-06,0.002244079678535344,2.6693616912176488e-06,-0.0001881502354522787,-8.317280366145835e-07,-0.0012118410699151145,-2.2069607060749723e-06,-0.0003130687299829169,-3.4173168922923985e-07,0.0025052734881123324,6.451593432876361e-06,0.0012905757865623521,-3.9000650121273665e-06)
TRIPLET( 22,202447,23,0ECLZH0509,0.1536,0.1547,0.1421,0.1292,0.6967,0.6976,0.0237,0.0225,0.7407,0.7233,0.3026,0.302,0.411,0.8686,2.701,5.0589,1.0902,2.5336,2.8611,3.0147,2.597,2.9048,2.1283,2.4386,623.0703619436376,523.9146253649286,453.8314170616765,623.4111040503278,520.4329385837325,452.8180763481897,0.0001309542544668559,-8.337452498900994e-07,-0.00035033843107214234,1.0978185330812678e-06,-0.006427272211596299,5.263721122000269e-06,0.002150020423998156,2.6164518440590184e-06,-0.0002089175932657931,-8.099128449420858e-07,-0.001257193499925798,-2.0674223210418484e-06,-0.00031314496883065894,-3.7730007999945583e-07,0.0024942129823381023,6.818625163367892e-06,0.0012520943489553113,-3.5110374664611917e-06)
TRIPLET( 23,202447,24,0ECLSU0701,0.1533,0.1545,0.1363,0.1239,0.6967,0.6974,0.0241,0.0228,0.7385,0.7191,0.3031,0.3023,0.4166,0.8793,2.692,5.0268,1.108,2.5591,2.8672,3.0173,2.5929,2.8907,2.131,2.4427,622.772537655011,522.7549726458902,454.12122012721716,623.2306448187245,520.00001326365,453.03364338318573,0.0001338338589501834,-8.387280304443865e-07,-0.0003544053157485357,1.0699987766781868e-06,-0.0064184065837947545,5.136198301978374e-06,0.002233988535270297,2.707356853337056e-06,-0.00019141766936849438,-8.365197366570995e-07,-0.0012171932076185984,-2.229134396393596e-06,-0.0003176751190669435,-3.9342921231224133e-07,0.002537105677133899,7.102767317044757e-06,0.001285006458403095,-3.197104488602717e-06)
TRIPLET( 24,202447,25,0ECKE10304,0.154,0.1551,0.1354,0.1236,0.6971,0.6978,0.0232,0.0221,0.7395,0.7208,0.3027,0.302,0.4121,0.8705,2.7151,5.0931,1.1168,2.5693,2.8529,3.0133,2.5949,2.8952,2.1457,2.4727,622.989757323568,522.6750090839872,453.44713336833604,623.4022841735936,520.00001326365,452.44663414036876,0.00013020682116662762,-8.200037597469513e-07,-0.00034840984497058297,1.0392548860840727e-06,-0.006418930988296877,5.380611856588205e-06,0.002239039902017317,2.7040279371482086e-06,-0.0001901555184682516,-8.366835961139225e-07,-0.0012146888580760347,-2.231380066952617e-06,-0.0003070870938087953,-3.560340959088174e-07,0.0024367544123183368,6.44176442565463e-06,0.00120774863918003,-3.927551351111727e-06)
TRIPLET( 25,202447,26,0ECK4W0201,0.154,0.1551,0.1432,0.1307,0.6971,0.6978,0.0231,0.022,0.7424,0.726,0.3027,0.302,0.4067,0.8608,2.7161,5.0905,1.1053,2.5639,2.8553,3.0136,2.5924,2.8956,2.1293,2.4404,622.989757323568,524.2259195681621,453.41685591193294,623.4022841735936,520.8812939254034,452.41509992157165,0.00013170894252897145,-8.348500640606412e-07,-0.00035139018079379636,1.0894648992764971e-06,-0.0064247767970123625,5.23165335662738e-06,0.0021293248188205974,2.616016621067966e-06,-0.00021375369766550033,-8.069430566475588e-07,-0.0012672971131331573,-2.0462514500820293e-06,-0.00030800067555557557,-3.5103290147803525e-07,0.0024481596619982896,6.414357305168368e-06,0.0012235140213207492,-3.953976952265458e-06)
TRIPLET( 26,202447,27,0ECM5A0209,0.1543,0.1553,0.1356,0.1237,0.6968,0.6977,0.0228,0.0218,0.7386,0.7193,0.3027,0.302,0.4027,0.854,2.6867,5.0298,1.104,2.566,2.8593,3.0101,2.6047,2.9148,2.1288,2.4396,623.001849756772,522.6428452567682,453.150767759369,623.4066843302342,520.00001326365,452.22909530497844,0.00013162777851718216,-8.350011403993582e-07,-0.00035129599643362463,1.0917896137581595e-06,-0.006425275913491392,5.233285417466841e-06,0.002238160971863961,2.6648688782934534e-06,-0.00018942933698882242,-8.30165303389849e-07,-0.0012146819242670613,-2.197190665060276e-06,-0.00030822510077880487,-3.2574157505271917e-07,0.0024589937192457407,6.1606703850549205e-06,0.001253998152330904,-4.222076036774999e-06)
TRIPLET( 27,202447,28,0ECJ4D0114,0.1538,0.1549,0.1367,0.1242,0.6966,0.6975,0.0234,0.0223,0.7387,0.7197,0.3029,0.3022,0.4103,0.8672,2.6458,4.9433,1.1195,2.5831,2.8569,3.0162,2.5989,2.9046,2.1332,2.4453,622.8933791442231,522.8382657436491,453.62424516763923,623.2895288683295,520.00001326365,452.6324510183392,0.00013236362069724215,-8.337229700247819e-07,-0.0003521562997576994,1.0711970620730987e-06,-0.006420829097621286,5.217873031730165e-06,0.002226111278814478,2.6768397481456585e-06,-0.00019253602791008244,-8.304325738673131e-07,-0.0012207007744404674,-2.1952613825753504e-06,-0.00030997987904147106,-3.6559435979426863e-07,0.002464390839479025,6.615620678107246e-06,0.0012295825760420855,-3.735121931207121e-06)
TRIPLET( 28,202447,29,0ECLUM0505,0.1541,0.1551,0.1446,0.1324,0.697,0.6977,0.0231,0.022,0.7424,0.7262,0.3028,0.3021,0.4057,0.8602,2.6286,4.9402,1.1151,2.5746,2.8554,3.006,2.618,2.9348,2.1398,2.4625,622.9357003143722,524.4682761850646,453.35849700008356,623.3438062032577,521.1775564750897,452.41509992157165,0.000131314771691618,-8.266928541896928e-07,-0.0003503092633177699,1.0537691642077064e-06,-0.006419599570921208,5.2994257222305475e-06,0.0021037699620683617,2.492990400056738e-06,-0.00021680999807064625,-7.832719493413267e-07,-0.0012784084848342949,-1.9159291607578993e-06,-0.00030769497723551133,-3.463345957531569e-07,0.0024464702351583607,6.358135050041822e-06,0.0012252853148302968,-4.014407803714274e-06)
TRIPLET( 29,202447,30,0ECHY50407,0.1534,0.1546,0.1345,0.1245,0.6963,0.6973,0.0239,0.0227,0.7409,0.7244,0.3031,0.3024,0.4139,0.8751,2.5861,4.9085,1.1157,2.5832,2.8656,3.0193,2.6505,2.9782,2.1408,2.4636,622.7883743535851,522.6250048404513,454.0077409373861,623.1715555505127,520.00001326365,452.94237210214044,0.00013276997780625133,-8.294615308968388e-07,-0.00035238203731228584,1.0410349810869043e-06,-0.006415333606859597,5.233295104752086e-06,0.002224612536635576,2.473444618211502e-06,-0.0001880460809612688,-7.970055704832046e-07,-0.0012191669791508054,-2.0207610887795927e-06,-0.0003162613169607415,-3.8625249112910534e-07,0.0025244347700430023,6.992096479892599e-06,0.0012771050056887417,-3.3183776800494818e-06)
TRIPLET( 30,202447,31,0ECI1D0418,0.1533,0.1545,0.1357,0.1237,0.6968,0.6976,0.024,0.0228,0.7399,0.7213,0.3029,0.3021,0.4116,0.8699,2.7174,5.0928,1.1193,2.5708,2.859,3.0069,2.5949,2.8954,2.1299,2.4359,622.8854397517534,522.7555111176763,454.09222882960137,623.3482088450268,520.00001326365,453.03364338318573,0.00013274923377936033,-8.369083246295963e-07,-0.0003528774965251776,1.080779040418868e-06,-0.006421794704875372,5.183846423873117e-06,0.002233303008189223,2.698914018860207e-06,-0.00019137726070924687,-8.350448937111235e-07,-0.0012174339894891115,-2.221264492447429e-06,-0.0003137563417963721,-4.0010209636488503e-07,0.0024931167707167006,7.068647677151561e-06,0.001233726297959637,-3.2444344982472e-06)
TRIPLET( 31,202447,32,0ECI3W0101,0.1531,0.1543,0.1361,0.124,0.6969,0.6977,0.0243,0.0231,0.7393,0.7201,0.3027,0.3021,0.4151,0.8779,2.6233,4.9101,1.1167,2.5641,2.8652,3.0141,2.5948,2.8956,2.1335,2.4434,622.9976910754363,522.7796897177109,454.2899975335142,623.3438062032577,520.00001326365,453.24160807825444,0.00013124095517903452,-8.30850113905915e-07,-0.0003505055153287046,1.0771271230472056e-06,-0.006423490233500718,5.273851636648625e-06,0.0022316123030400765,2.6977984966983256e-06,-0.0001917466372116347,-8.34625907315977e-07,-0.0012182473623786713,-2.2186164150728e-06,-0.00031777804499136643,-4.088848112500264e-07,0.0025330433522429124,7.2640817674900095e-06,0.0012690669644779932,-3.025924488728832e-06)
TRIPLET( 32,202447,33,0ECI5B0208,0.1539,0.155,0.1449,0.1327,0.6964,0.6973,0.0233,0.0222,0.7442,0.7294,0.3031,0.3024,0.4089,0.8661,2.6966,5.0762,1.108,2.5567,2.868,3.026,2.6088,2.9183,2.132,2.4422,622.7844078282682,524.6474708060101,453.5357202154199,623.1715555505127,521.4687129966012,452.53956127768106,0.0001336176393322113,-8.375267557003097e-07,-0.00035404194089986223,1.067716519561911e-06,-0.006418365124650887,5.151341146804777e-06,0.0020939767493662964,2.5202866907973697e-06,-0.00021975302386260034,-7.863581132015979e-07,-0.0012834959167143936,-1.92930256871761e-06,-0.00031451530892348664,-3.4651425476254673e-07,0.0025190928749558982,6.5385514132651325e-06,0.0013014921509741442,-3.803818144737733e-06)
TRIPLET( 33,202447,34,0ECJLP0809,0.1539,0.155,0.1399,0.1269,0.6967,0.6974,0.0232,0.0222,0.7387,0.7193,0.303,0.3023,0.4015,0.8478,2.6892,5.0059,1.1175,2.5785,2.8318,2.9914,2.5885,2.885,2.1279,2.4356,622.8310453574378,523.3870666875846,453.5054451575055,623.2306448187245,520.00001326365,452.53956127768106,0.00013350351477742475,-8.400753090224319e-07,-0.00035407333941714776,1.0833309816622357e-06,-0.006421064172657772,5.137911104199947e-06,0.0021903667474161793,2.6857018518275093e-06,-0.00020111754689680443,-8.268733466964476e-07,-0.0012382583853836992,-2.166872833090637e-06,-0.000297803626002292,-3.836562182400962e-07,0.0023286023128448914,6.482184798998154e-06,0.001073201922259577,-3.911231534907032e-06)
TRIPLET( 34,202447,35,0ECJA10218,0.1541,0.1552,0.1343,0.1225,0.6968,0.6976,0.023,0.0219,0.7387,0.7194,0.3027,0.3021,0.4051,0.8565,2.6305,4.9226,1.1025,2.559,2.8694,3.0237,2.5951,2.8943,2.1291,2.4403,623.001849756772,522.4298122226705,453.32821848556557,623.3482088450268,520.00001326365,452.32212005834464,0.00013160030068738317,-8.347295616619128e-07,-0.0003512414780953951,1.090871137907078e-06,-0.006425168977966109,5.236010268075881e-06,0.0022564488863530113,2.7187632859886186e-06,-0.00018642942069926617,-8.415284443963093e-07,-0.0012063498503493831,-2.2614103329743478e-06,-0.00031390526861324467,-3.2866859159073943e-07,0.002518548824815992,6.339430457199961e-06,0.0013143938404957603,-4.01649545609289e-06)
TRIPLET( 35,202447,36,0ECJLP0218,0.1533,0.1545,0.1403,0.1273,0.6971,0.6978,0.024,0.0228,0.7391,0.7206,0.3026,0.302,0.4063,0.8571,2.7194,5.0698,1.0943,2.5385,2.8409,3.0011,2.5837,2.8772,2.1229,2.4275,623.0527597757919,523.4852431099112,454.09222882960137,623.4022841735936,520.00001326365,453.03364338318573,0.0001316336633853139,-8.390726209879902e-07,-0.0003515891238624064,1.1131954387049156e-06,-0.0064287299514884984,5.205687480223101e-06,0.002184923474913285,2.6996458690706406e-06,-0.00020272411909676592,-8.283881800848609e-07,-0.0012410724083334644,-2.173261743189593e-06,-0.00030549163838021975,-4.1986343689162915e-07,0.002398445375917364,7.055067140455887e-06,0.0011192857355458927,-3.28241180630956e-06)
TRIPLET( 36,202447,37,0ECN2Z0120,0.1531,0.1542,0.1464,0.1324,0.6968,0.6975,0.0243,0.0231,0.7427,0.7264,0.3028,0.3021,0.4202,0.8832,2.7625,5.1599,1.0979,2.5442,2.8216,2.9883,2.5909,2.9076,2.1335,2.4503,622.943631654591,524.8040853442052,454.2899975335142,623.3526184885561,521.1926605213864,453.30007321329265,0.00013180853370493959,-8.321982199860351e-07,-0.0003513327765957353,1.0735778844308603e-06,-0.006422055686797794,5.246252999730277e-06,0.0020886078003124107,2.5855949200276714e-06,-0.00022256468861959626,-7.962718038739819e-07,-0.0012868458378154704,-1.9794530538597487e-06,-0.00029786969864085554,-4.5648671439732206e-07,0.0023049951305163345,7.231368430477225e-06,0.000993397985404005,-3.1174057390889924e-06)
TRIPLET( 37,202447,38,0ECJU50204,0.1536,0.1547,0.1397,0.1268,0.6976,0.6983,0.0237,0.0225,0.7391,0.7199,0.302,0.3013,0.4063,0.8602,2.7037,5.0262,1.1098,2.5498,2.8663,3.0283,2.6132,2.928,2.1417,2.4626,623.4111040503278,523.3816829732066,453.8314170616765,623.81491185967,520.00001326365,452.8180763481897,0.00012614940539883285,-8.131174812489388e-07,-0.00034268896551977243,1.0791644955597654e-06,-0.006431537853998839,5.559388171612179e-06,0.002182758067141823,2.5821972997598123e-06,-0.0002004358679007433,-8.08903997628941e-07,-0.0012408216857051938,-2.0711916453104467e-06,-0.00031551935876237116,-3.716227887984027e-07,0.002521411394103657,6.822526754020793e-06,0.0012849723005879873,-3.5001268586200726e-06)
TRIPLET( 38,202447,39,0ECJ970516,0.1539,0.155,0.1388,0.1267,0.6967,0.6975,0.0233,0.0221,0.74,0.722,0.303,0.3022,0.4078,0.8617,2.6783,5.0363,1.1029,2.5512,2.8664,3.0186,2.6011,2.907,2.1292,2.4385,622.8310453574378,523.2924065990054,453.5357202154199,623.2895288683295,520.00001326365,452.508031085015,0.00013338444418162918,-8.388984678268344e-07,-0.00035383709328481983,1.0793509196408843e-06,-0.006420600785381545,5.149718790172454e-06,0.002193035533597361,2.638740809594223e-06,-0.0001993748753633642,-8.195777956896385e-07,-0.0012364317075591442,-2.1296133315973574e-06,-0.0003137847274060368,-3.4826111359363964e-07,0.0025107241328741897,6.537350923833471e-06,0.0012913758581640927,-3.8071752548426927e-06)
TRIPLET( 39,202447,40,0ECJJU0701,0.1534,0.1545,0.1401,0.1267,0.6968,0.6974,0.0239,0.0227,0.7398,0.721,0.3031,0.3024,0.4122,0.867,2.6975,5.0183,1.1139,2.5753,2.8477,3.0053,2.5812,2.8742,2.1298,2.4394,622.7685689635899,523.5015319225372,454.0077409373861,623.1671524279715,520.00001326365,453.00336413382723,0.00013398543819684357,-8.39913314583095e-07,-0.0003546841212484526,1.0734121180448858e-06,-0.006418729010798092,5.123272786945022e-06,0.0021845716114082692,2.709121901715158e-06,-0.00020303205289077478,-8.298864566497553e-07,-0.0012413498344077151,-2.180967756010251e-06,-0.0003080879362342703,-4.057954743019629e-07,0.0024308094680038795,6.9786660043758824e-06,0.001163928979876258,-3.3559353493487215e-06)
TRIPLET( 40,202447,41,0ECLTD0308,0.1536,0.1548,0.1374,0.1258,0.6964,0.6973,0.0236,0.0225,0.741,0.7236,0.3031,0.3024,0.411,0.8675,2.6703,5.0221,1.1124,2.5752,2.8643,3.0202,2.6128,2.9223,2.1326,2.4453,622.7844078282682,523.1259953396188,453.80113607150946,623.1715555505127,520.00001326365,452.7568378144337,0.00013356268367261336,-8.369835982254185e-07,-0.00035393290422340324,1.065879567859749e-06,-0.006418151253600322,5.156790848022855e-06,0.0022011088115031015,2.6001216667385216e-06,-0.0001965651307580893,-8.144015610015427e-07,-0.0012320582151013467,-2.104880813739573e-06,-0.00031442382006054257,-3.714251782711145e-07,0.002509802469088657,6.791814878669643e-06,0.0012729179464716078,-3.5357881844920114e-06)
TRIPLET( 41,202447,42,0ECND00209,0.1533,0.1544,0.139,0.127,0.6969,0.6976,0.024,0.0228,0.7432,0.7273,0.3028,0.3021,0.4196,0.8807,2.7773,5.2432,1.108,2.5662,2.8223,2.9923,2.5728,2.8623,2.1324,2.4462,622.9396701312091,523.5579208180841,454.09222882960137,623.3482088450268,520.3788218571204,453.09223229082085,0.00013195087841660685,-8.332927991260457e-07,-0.00035159329962506963,1.0766855377938204e-06,-0.006422342658840566,5.23423942769001e-06,0.002183271159811477,2.740856015585302e-06,-0.000204091880502532,-8.348869057227204e-07,-0.0012423385406084477,-2.206651560255196e-06,-0.00029699862823986413,-4.401706708030903e-07,0.002301158749217493,7.041111450812818e-06,0.0010016838316290085,-3.3214382112797207e-06)
TRIPLET( 42,202447,43,0ECL220215,0.1543,0.1553,0.1458,0.1325,0.6966,0.6973,0.0228,0.0218,0.7433,0.728,0.3031,0.3024,0.4009,0.8454,2.7788,5.2236,1.119,2.5945,2.8216,2.981,2.6139,2.9471,2.1297,2.4395,622.7764890791112,524.7411953970811,453.150767759369,623.1715555505127,521.3299732307817,452.22909530497844,0.0001339114429108846,-8.398063330546383e-07,-0.00035458109397246607,1.0742382670616367e-06,-0.006418974827954873,5.126407913219697e-06,0.002085647322424674,2.4928908040921737e-06,-0.00022105155772635292,-7.807173533519457e-07,-0.0012872591100656398,-1.8976297825034748e-06,-0.00029101077377389063,-3.669019362603581e-07,0.002261805233945466,6.132383852821388e-06,0.0010156330029939924,-4.3011779436231195e-06)
TRIPLET( 43,202447,44,0ECJA70510,0.1533,0.1545,0.1385,0.1256,0.6968,0.6976,0.024,0.0229,0.7395,0.7208,0.3028,0.3021,0.415,0.8787,2.6593,4.9713,1.1007,2.5549,2.8667,3.018,2.5922,2.8933,2.1281,2.437,622.943631654591,523.2048035157785,454.09222882960137,623.3482088450268,520.00001326365,453.0639370276687,0.0001323031346413211,-8.370866372600549e-07,-0.0003523141066838666,1.090110449750318e-06,-0.006423980526252893,5.19720568876756e-06,0.002202158309191834,2.68172421846066e-06,-0.00019826154831589313,-8.278753213060865e-07,-0.001232454660729136,-2.175341171946416e-06,-0.00031727226534910007,-3.91695338240248e-07,0.002533391341984924,7.074425032541433e-06,0.0012824109571080225,-3.228278405867081e-06)
TRIPLET( 44,202447,45,0ECI5B0820,0.1538,0.1549,0.1356,0.1233,0.697,0.6978,0.0234,0.0222,0.7384,0.719,0.3026,0.3019,0.4113,0.869,2.6697,4.9941,1.086,2.5213,2.8527,3.0068,2.5912,2.8875,2.1251,2.4327,623.0571483010252,522.6281126833857,453.62424516763923,623.4649735019518,520.00001326365,452.6009050782737,0.00013138608347015664,-8.369716047910819e-07,-0.00035112216592961173,1.1067480751032516e-06,-0.006428062213645489,5.227910165897151e-06,0.0022435791591831067,2.7225630080666696e-06,-0.0001895336678979188,-8.403464023144091e-07,-0.0012126782069689485,-2.251707034526225e-06,-0.0003080621025581649,-3.7017986422588895e-07,0.002442422891514537,6.6124693933491335e-06,0.0012030273074156925,-3.7439343452326404e-06)
TRIPLET( 45,202447,46,0ECKC80506,0.1538,0.1549,0.1377,0.1252,0.6968,0.6976,0.0236,0.0223,0.7383,0.7191,0.3028,0.3022,0.403,0.8477,2.6893,5.0381,1.1106,2.5581,2.8691,3.0143,2.6082,2.9241,2.1295,2.4381,622.943631654591,522.98093929854,453.68481433452183,623.2851115333052,520.00001326365,452.6324510183392,0.0001321749047689259,-8.358192698186421e-07,-0.0003520596877721288,1.0858242291119392e-06,-0.006423481493801571,5.209921658276415e-06,0.00221293453255882,2.628676243795715e-06,-0.00019447541795026608,-8.207212553151333e-07,-0.0012266002165876215,-2.1410531512088797e-06,-0.0003159152299898867,-3.570374944628442e-07,0.0025304987651305396,6.6832038698184254e-06,0.001305537144662295,-3.646586622641894e-06)
TRIPLET( 46,202447,47,0ECKN50204,0.1538,0.1548,0.1441,0.1308,0.6972,0.6978,0.0234,0.0223,0.7426,0.7268,0.3026,0.3019,0.4035,0.8515,2.7876,5.2331,1.1156,2.5943,2.8236,2.9794,2.5804,2.8876,2.1261,2.4345,623.0483483860381,524.3956236003654,453.62424516763923,623.4649735019518,520.9580815555428,452.6937351425863,0.00013138688242235369,-8.362857900945452e-07,-0.00035107510159857277,1.1031087358308535e-06,-0.006427472243132538,5.232500432623255e-06,0.0021211139578969393,2.655687883624364e-06,-0.00021662070228490327,-8.122718457984123e-07,-0.0012717495266521836,-2.0717405470797734e-06,-0.000294774651209544,-4.019508592164007e-07,0.0022902163949034497,6.5906354918107835e-06,0.0010190372319328275,-3.8049917852666012e-06)
TRIPLET( 47,202447,48,0ECKRM0616,0.1536,0.1547,0.1358,0.1244,0.6972,0.6979,0.0235,0.0225,0.742,0.7256,0.3026,0.3018,0.4079,0.8615,2.7596,5.2306,1.0945,2.5377,2.8248,2.9809,2.5817,2.8789,2.1255,2.4336,623.0483483860381,522.9265844330682,453.7708657805191,623.5230655825276,520.00001326365,452.8180763481897,0.00013144183808195165,-8.368289475694364e-07,-0.00035118413827503177,1.1049456875330154e-06,-0.006427686114183104,5.2270507314051736e-06,0.002225382858790229,2.743543473976877e-06,-0.00019429419478647956,-8.41224138758795e-07,-0.0012217996438289257,-2.251262875607674e-06,-0.0002962053414596773,-4.1217041294091033e-07,0.002302051557155311,6.732976853474332e-06,0.0010237627707974442,-3.650120660948151e-06)
TRIPLET( 48,202447,49,0ECLLU0416,0.1538,0.1548,0.1397,0.1269,0.6966,0.6975,0.0234,0.0224,0.7412,0.7237,0.3029,0.3022,0.4073,0.8616,2.793,5.2291,1.1163,2.5767,2.8349,2.9905,2.5747,2.868,2.1298,2.4382,622.8933791442231,523.5339712028737,453.62424516763923,623.2895288683295,520.0940247015525,452.72528564973686,0.00013267503610163051,-8.368008623824982e-07,-0.0003527741742576339,1.0816064550520156e-06,-0.006422041033574496,5.186991391494385e-06,0.002184363108491328,2.7343892263197144e-06,-0.00020368225647972185,-8.339837372794596e-07,-0.0012417331540474272,-2.2022488467856936e-06,-0.0002999343831765343,-3.89613668721803e-07,0.002349320635855523,6.599113948421896e-06,0.0010904835499038375,-3.78128219515032e-06)
TRIPLET( 49,202447,50,0ECKE10301,0.1544,0.1555,0.1368,0.1248,0.697,0.6977,0.0226,0.0216,0.7394,0.7203,0.3028,0.3021,0.4037,0.8532,2.6624,4.9823,1.0965,2.5371,2.8483,3.0098,2.5986,2.9039,2.132,2.4462,622.9357003143722,522.9070236010489,453.03169222260203,623.3438062032577,520.00001326365,452.0429068637268,0.0001320291952663913,-8.337539013632771e-07,-0.00035172674011173726,1.077649536335811e-06,-0.006422379894578572,5.2285796063955205e-06,0.002221308394530373,2.6737331767185266e-06,-0.0001935868213230611,-8.292525186245811e-07,-0.0012230120646967713,-2.1877918721341944e-06,-0.00030248543850761966,-3.283875736632948e-07,0.0023969442865818657,6.037548025868091e-06,0.0011867727065523574,-4.36888740704794e-06)
TRIPLET( 50,202447,51,0ECLUD0710,0.1536,0.1548,0.1455,0.1327,0.6968,0.6976,0.0236,0.0225,0.7431,0.7275,0.3028,0.3022,0.4093,0.8636,2.6921,5.0569,1.0883,2.5208,2.8563,3.0094,2.6054,2.9147,2.1312,2.4435,622.943631654591,524.6746067681405,453.80113607150946,623.2851115333052,521.3256506124778,452.7568378144337,0.0001320191970667317,-8.34280323639784e-07,-0.0003517507505221616,1.0806195326224807e-06,-0.006422875525824966,5.225362478394307e-06,0.0020931430940686183,2.532857537231148e-06,-0.00022024744120111754,-7.882943315936621e-07,-0.0012840431432564682,-1.9391565793913133e-06,-0.0003107709124732928,-3.801594724265816e-07,0.002467958758680111,6.7858124315113345e-06,0.0012223364824213365,-3.5525737350168117e-06)
TRIPLET( 51,202447,52,0ECI150303,0.1536,0.1547,0.1346,0.1226,0.6968,0.6977,0.0237,0.0225,0.7381,0.7183,0.3028,0.3021,0.4151,0.8766,2.6992,5.0466,1.1075,2.5702,2.8668,3.0207,2.6084,2.9196,2.1297,2.4417,622.943631654591,522.4363569351541,453.8314170616765,623.3438062032577,520.00001326365,452.8180763481897,0.00013215658621572657,-8.35638217327012e-07,-0.00035202334221330915,1.0852119118778852e-06,-0.0064234102034513825,5.211738225349108e-06,0.002251678913782444,2.6624301555721584e-06,-0.00018620568448094187,-8.316604060532684e-07,-0.0012080521183735914,-2.208703042638466e-06,-0.0003157476654865744,-3.710768954136857e-07,0.0025240266260041916,6.822901906968187e-06,0.0012881336420911306,-3.499077761712272e-06)
TRIPLET( 52,202447,53,0ECNBI0517,0.1531,0.1542,0.1387,0.1261,0.6965,0.6974,0.0243,0.0231,0.741,0.7235,0.3031,0.3023,0.4195,0.8825,2.7811,5.2153,1.1072,2.5506,2.8266,2.9826,2.5716,2.8594,2.1278,2.4342,622.7804419790724,523.3477002586815,454.2899975335142,623.2306448187245,520.00001326365,453.30007321329265,0.00013404396703588255,-8.414277563355186e-07,-0.0003548658862880292,1.0803148060440103e-06,-0.006419756982329713,5.111168576705549e-06,0.0021986406017286816,2.7592555228055497e-06,-0.0002009306084960864,-8.400444923536695e-07,-0.0012350365360873797,-2.2377484084852356e-06,-0.00030015276588288655,-4.510277805501551e-07,0.0023311474495216755,7.2351199599511685e-06,0.0010250114004354272,-3.1069147700109926e-06)
TRIPLET( 53,202447,54,0ECJ4J0516,0.1539,0.155,0.1359,0.1237,0.6969,0.6977,0.0233,0.0222,0.7389,0.7198,0.3028,0.302,0.4082,0.8621,2.6242,4.9093,1.0948,2.5293,2.8684,3.0234,2.5938,2.8936,2.1264,2.4337,622.9396701312091,522.7160814926489,453.5357202154199,623.4066843302342,520.00001326365,452.53956127768106,0.00013250043501258633,-8.387243738749566e-07,-0.00035268366638965994,1.09505505481544e-06,-0.006424481369346231,5.179742415509219e-06,0.0022364688538651055,2.706043544150945e-06,-0.0001908055749120365,-8.366526596168412e-07,-0.001215967102420582,-2.230510299692189e-06,-0.00031469795430284905,-3.460775400547732e-07,0.0025211850604763258,6.538851535623048e-06,0.0013040212241766588,-3.8029788672114935e-06)
TRIPLET( 54,202447,55,0ECJTY0217,0.1533,0.1544,0.1429,0.13,0.6977,0.6984,0.0241,0.0229,0.7404,0.7226,0.302,0.3013,0.422,0.8855,2.6993,5.0252,1.1181,2.5516,2.8285,2.9959,2.6081,2.9203,2.14,2.4554,623.4066843302342,524.032508806462,454.12122012721716,623.810499244757,520.5099940015405,453.1225079615919,0.00012635151645083118,-8.147666441381756e-07,-0.00034306553692466557,1.084079017996591e-06,-0.0064320265381646105,5.541690977892057e-06,0.0021380278813223526,2.5622953747599143e-06,-0.0002104370324702544,-7.993886612480114e-07,-0.0012624477734040653,-2.00930710203858e-06,-0.000300004178613623,-4.3568136028931305e-07,0.002334686728032557,7.073730478916437e-06,0.0010403186260599002,-3.278304589266437e-06)
TRIPLET( 55,202447,56,0ECJMP0118,0.1538,0.1549,0.1416,0.1276,0.6965,0.6973,0.0234,0.0223,0.7392,0.7202,0.3031,0.3024,0.4071,0.8593,2.798,5.203,1.1113,2.5724,2.8512,3.0092,2.6025,2.9158,2.1302,2.4392,622.7804419790724,523.7182887980254,453.62424516763923,623.1715555505127,520.00001326365,452.6324510183392,0.00013382414439749082,-8.392551264359545e-07,-0.0003544297395821931,1.0729669992353642e-06,-0.006418901498127447,5.132967381577863e-06,0.002162232473556333,2.605800462674715e-06,-0.000205804286540077,-8.098838044928829e-07,-0.0012511100483010588,-2.0706370508520885e-06,-0.0003073771823855556,-3.718175443800392e-07,0.002434577195812934,6.611343934506951e-06,0.0011935432829062662,-3.7470816359560406e-06)
TRIPLET( 56,202447,57,0ECJJ50315,0.1536,0.1547,0.1393,0.126,0.6977,0.6984,0.0237,0.0226,0.7393,0.72,0.302,0.3013,0.4104,0.8641,2.7067,5.0292,1.1051,2.5258,2.8309,2.9949,2.5865,2.8834,2.1356,2.4464,623.4066843302342,523.3274025479287,453.8314170616765,623.810499244757,520.00001326365,452.8496316579241,0.0001267545246212161,-8.187497989540436e-07,-0.0003438651392186985,1.0975499971457778e-06,-0.006433594925868764,5.501726502292811e-06,0.0021952658038149634,2.6979006638909342e-06,-0.00020026063256117316,-8.295517539446576e-07,-0.0012360014093780749,-2.1821722400083112e-06,-0.00029935524268879144,-4.1027204043634386e-07,0.0023362529755458408,6.795965925345275e-06,0.0010611493221655346,-3.5744029196923115e-06)
TRIPLET( 57,202447,58,0ECLSU0303,0.1531,0.1541,0.1355,0.1231,0.6968,0.6976,0.0242,0.0234,0.7377,0.7178,0.3028,0.3022,0.4055,0.8564,2.6709,4.9908,1.116,2.5654,2.8107,2.9739,2.5954,2.8958,2.1314,2.4402,622.943631654591,522.5594981333054,454.2610100768561,623.2851115333052,520.00001326365,453.44934908116875,0.00013200087851353238,-8.340992711481539e-07,-0.00035171440496334187,1.0800072153884267e-06,-0.0064228042354747775,5.2271790454669996e-06,0.0022471098815954192,2.709263651485454e-06,-0.00018839031683945797,-8.386689708893082e-07,-0.0012108055223224396,-2.243944166282213e-06,-0.00029271808818472035,-4.6610772476600846e-07,0.0022468841174526754,7.19522666993748e-06,0.0009250465058773492,-3.1703968809013496e-06)
TRIPLET( 58,202447,59,0ECL300804,0.1539,0.155,0.1457,0.1328,0.6968,0.6976,0.0233,0.0222,0.7433,0.7276,0.3028,0.3021,0.4044,0.8511,2.7597,5.1737,1.0985,2.5418,2.8156,2.9742,2.6127,2.9442,2.1254,2.4321,622.943631654591,524.7236915305906,453.5357202154199,623.3482088450268,521.3498924026289,452.53956127768106,0.00013255043510951187,-8.395308458970648e-07,-0.0003528047717279322,1.0983767324100455e-06,-0.006424942945980443,5.172682033286206e-06,0.0020872830093611253,2.4990479197215077e-06,-0.0002208150580950396,-7.819519917881403e-07,-0.0012865287736539839,-1.9045105957315372e-06,-0.00029058876422700095,-4.037238814808561e-07,0.002245016571779921,6.499235384378208e-06,0.0009701835614448588,-3.913763500675173e-06)
TRIPLET( 59,202447,60,0ECJ9T0816,0.153,0.1542,0.1389,0.1262,0.6965,0.6974,0.0244,0.0231,0.7402,0.7217,0.3029,0.3023,0.4201,0.8907,2.6631,4.9833,1.1016,2.5498,2.8685,3.0229,2.5869,2.8832,2.1361,2.4531,622.8973470238635,523.3240391653047,454.37429026639455,623.2306448187245,520.00001326365,453.30007321329265,0.00013205634227140254,-8.309987599509876e-07,-0.0003515685694303435,1.062578970919967e-06,-0.006419900681099541,5.246238952447839e-06,0.002195376061095043,2.696432598307644e-06,-0.0002001998718947012,-8.293274427280615e-07,-0.001235931201506934,-2.1810344213407963e-06,-0.00031979236797654935,-4.1191038086659114e-07,0.002553499545766287,7.3478727281022315e-06,0.0012882866275506326,-2.931411977968029e-06)
TRIPLET( 60,202447,61,0ECLZP0316,0.1541,0.1551,0.1403,0.1275,0.6965,0.6974,0.0231,0.022,0.74,0.7222,0.303,0.3023,0.4076,0.8618,2.6759,5.018,1.1167,2.5722,2.8558,3.0155,2.5982,2.9047,2.1343,2.447,622.838982512759,523.5506208563711,453.35849700008356,623.2306448187245,520.077084239565,452.41509992157165,0.00013283398760889644,-8.340836965862094e-07,-0.00035278882072263,1.064257939309998e-06,-0.006418993505609712,5.200093359565549e-06,0.002175572535206441,2.6345301740051367e-06,-0.0002033641162253361,-8.164442052295267e-07,-0.0012449143435743135,-2.1084803761292854e-06,-0.00030787762261487374,-3.4589788104538337e-07,0.0024485624206787883,6.358435172399737e-06,0.0012278143880328114,-4.013568526188033e-06)
TRIPLET( 61,202447,62,0ECLR60220,0.1538,0.1549,0.1356,0.123,0.6966,0.6975,0.0234,0.0223,0.7376,0.7176,0.3029,0.3022,0.4045,0.8571,2.6907,5.0229,1.0988,2.5493,2.8594,3.0092,2.6129,2.9311,2.1304,2.4415,622.8933791442231,522.5691260909722,453.62424516763923,623.2895288683295,520.00001326365,452.6324510183392,0.00013262008044203258,-8.362577049076075e-07,-0.0003526651375811749,1.0797695033498545e-06,-0.00642182716252393,5.192441092712462e-06,0.0022407611625171126,2.635076538354687e-06,-0.00018811135393724228,-8.256640181244085e-07,-0.0012130800112634757,-2.1744647397793883e-06,-0.00031112141266248657,-3.6286489287068514e-07,0.0024774669989816936,6.617496442844218e-06,0.0012453892835577948,-3.729876446668121e-06)
TRIPLET( 62,202447,63,0ECJMC0305,0.1534,0.1546,0.1421,0.1283,0.6966,0.6974,0.0239,0.0228,0.7393,0.7201,0.3029,0.3023,0.4055,0.8559,2.7717,5.1492,1.094,2.536,2.8405,3.0008,2.6006,2.9113,2.1248,2.4303,622.8933791442231,523.8129051506121,454.0077409373861,623.2306448187245,520.0467627592645,452.973943334463,0.0001331329999316134,-8.413271746732574e-07,-0.0003536828132281258,1.0969143859033645e-06,-0.006423823292329218,5.14157721467706e-06,0.002156104533225998,2.6077781241001613e-06,-0.0002072863870473861,-8.093484781922237e-07,-0.0012541251811969464,-2.0661600551489053e-06,-0.0003048003194057456,-4.1365633904188374e-07,0.002393150128636187,6.973263801933403e-06,0.0011184056622310125,-3.3710423448210416e-06)
TRIPLET( 63,202447,64,0ECLRW0209,0.1543,0.1553,0.1363,0.1236,0.697,0.6978,0.0229,0.0218,0.7379,0.7179,0.3025,0.3019,0.4036,0.8552,2.6966,5.0411,1.0903,2.5371,2.8597,3.0113,2.6054,2.9192,2.1259,2.4346,623.1210610789501,522.710707387169,453.18103990740934,623.4649735019518,520.00001326365,452.22909530497844,0.00013064177875585112,-8.34653570784813e-07,-0.00034999873833574765,1.1084949609896741e-06,-0.006429473072353963,5.26780544731479e-06,0.0022330983439099853,2.657614894280511e-06,-0.0001904422459675999,-8.282715407022461e-07,-0.0012170738800494252,-2.185932587381802e-06,-0.00030859000472766994,-3.276853490992574e-07,0.0024622335669608492,6.190173241210599e-06,0.001255936386214216,-4.189781008850564e-06)
TRIPLET( 64,202447,65,0ECIB80718,0.154,0.1551,0.145,0.1318,0.6969,0.6977,0.0232,0.0221,0.7412,0.7241,0.3028,0.3021,0.4056,0.8571,2.6966,5.0328,1.1088,2.5734,2.8714,3.0272,2.6131,2.9321,2.1295,2.4409,622.9396701312091,524.4529253490753,453.44713336833604,623.3438062032577,520.9191551619626,452.44663414036876,0.00013221649743799693,-8.359180602546856e-07,-0.0003521203102279549,1.0855641376876028e-06,-0.006423376368918304,5.2078992051359625e-06,0.0021064494494017504,2.5145667052877823e-06,-0.00021669604846521996,-7.871709419275369e-07,-0.001277340090266853,-1.936973579567083e-06,-0.0003155344426043103,-3.3583604067429975e-07,0.002533517992638099,6.45564508470822e-06,0.0013247182747962855,-3.888734765523126e-06)
TRIPLET( 65,202447,66,0ECKH60209,0.1539,0.155,0.136,0.1236,0.6972,0.6979,0.0233,0.0222,0.7381,0.7186,0.3026,0.3019,0.4089,0.8654,2.6455,4.9439,1.0889,2.5288,2.8705,3.0256,2.603,2.9121,2.1264,2.4355,623.0483483860381,522.6741955780155,453.5357202154199,623.4605597689591,520.00001326365,452.53956127768106,0.00013135940459255474,-8.360142113570999e-07,-0.0003510205832603433,1.1021902599797737e-06,-0.006427365307607254,5.235225283232292e-06,0.0022364769042093093,2.67002467247498e-06,-0.0001899464200345253,-8.307714346053438e-07,-0.001215561918003227,-2.1998832102382117e-06,-0.00031565684254450214,-3.4378478783896324e-07,0.0025321690344585687,6.540427178002104e-06,0.0013172988584898536,-3.7985726601987333e-06)
TRIPLET( 66,202447,67,0ECKJI0718,0.1542,0.1553,0.1416,0.1292,0.6972,0.6978,0.0229,0.0218,0.7425,0.7264,0.3027,0.302,0.4005,0.8421,2.7864,5.2359,1.1088,2.5541,2.8151,2.9743,2.608,2.9325,2.1346,2.451,622.9857914141784,523.9575349416542,453.2395236104917,623.4022841735936,520.6661094168032,452.22909530497844,0.0001312651395876602,-8.301510728444894e-07,-0.0003504877130591652,1.0729781131890368e-06,-0.006422782361459884,5.277767691750604e-06,0.002143403173608639,2.5674785456871546e-06,-0.00020930161773886126,-8.00988026128414e-07,-0.0012598800323832125,-2.019118140285285e-06,-0.00028857715592030806,-3.8097797918079335e-07,0.0022311720856746427,6.213127266793057e-06,0.0009728032633011356,-4.222590111784984e-06)
TRIPLET( 67,202447,68,0ECK6B0702,0.1532,0.1543,0.1434,0.1301,0.6971,0.6977,0.024,0.023,0.7413,0.7235,0.3028,0.3021,0.4114,0.8764,2.7217,5.0888,1.096,2.5387,2.8717,3.0166,2.5841,2.8849,2.1248,2.4307,622.9317368619229,524.1825401562812,454.14767069366417,623.3438062032577,520.5942956862698,453.2113265159408,0.00013273027610422643,-8.403706296041082e-07,-0.0003530958322052341,1.0994327386856562e-06,-0.006424841171111444,5.16115975380275e-06,0.0021351018943691073,2.653668118237011e-06,-0.0002132969586446994,-8.139011990210201e-07,-0.0012648948260941175,-2.0840816422649657e-06,-0.0003198891296781821,-3.905961456887204e-07,0.002561645544586459,7.13165984953494e-06,0.001312942280667969,-3.1601778665912373e-06)
TRIPLET( 68,202447,69,0ECMAK0708,0.1543,0.1553,0.1363,0.1237,0.6967,0.6975,0.0229,0.0218,0.7383,0.7186,0.3029,0.3022,0.4046,0.8546,2.6626,4.9712,1.1193,2.5761,2.8554,3.0143,2.6061,2.9193,2.1316,2.4412,622.889401436803,522.740223204663,453.18103990740934,623.2895288683295,520.00001326365,452.22909530497844,0.00013255193171071936,-8.352705839831058e-07,-0.00035250793434541186,1.075834445967943e-06,-0.0064212938660721305,5.2013097796667315e-06,0.0022307684261220033,2.652796872464607e-06,-0.00019087319063917089,-8.271583569915838e-07,-0.001218158220814968,-2.179492959218595e-06,-0.00030662656689952315,-3.323800322078212e-07,0.0024397425726162547,6.186946925863008e-06,0.0012287488492871944,-4.198803242257645e-06)
TRIPLET( 69,202447,70,0ECJJZ0209,0.1541,0.1552,0.138,0.1253,0.6976,0.6984,0.023,0.0219,0.7398,0.7209,0.3021,0.3014,0.4018,0.8465,2.7056,5.0479,1.1164,2.5611,2.8264,2.9919,2.576,2.8622,2.1447,2.4691,623.3482088450268,523.141211456099,453.32821848556557,623.7489876126402,520.00001326365,452.32212005834464,0.00012653497394424392,-8.119701422106113e-07,-0.000343106255771377,1.0658503903421887e-06,-0.006428799481431659,5.554527159918878e-06,0.0022119320742159257,2.7538738108803786e-06,-0.0001976899454097426,-8.410272461797313e-07,-0.0012284845607584863,-2.2465300619183287e-06,-0.0002942708903317774,-3.7561542267637496e-07,0.002293638881370054,6.3071673037240506e-06,0.001042518471225544,-4.10671779016369e-06)
TRIPLET( 70,202447,71,0ECN4U0318,0.1539,0.155,0.1365,0.1244,0.6971,0.6979,0.0233,0.0222,0.7396,0.7213,0.3025,0.3018,0.4071,0.8556,2.6917,5.0436,1.0913,2.5364,2.815,2.9737,2.6076,2.9283,2.1242,2.4298,623.1166602778858,522.8702516852353,453.5357202154199,623.5230655825276,520.00001326365,452.53956127768106,0.00013084369117392677,-8.363022618810112e-07,-0.00035037502022625095,1.1134107255439392e-06,-0.006429962258564166,5.250117912215035e-06,0.0022210167164045114,2.63823029936574e-06,-0.00019281013732698715,-8.234135810416313e-07,-0.00122275902641538,-2.157302401514499e-06,-0.00029031479615795734,-4.043789535425158e-07,0.0022418782934992797,6.498785200841334e-06,0.0009663899516410904,-3.915022416964533e-06)
TRIPLET( 71,202447,72,0ECJP60510,0.1539,0.1549,0.1382,0.1249,0.6972,0.698,0.0234,0.0223,0.7387,0.7188,0.3024,0.3017,0.4048,0.8541,2.7517,5.1203,1.12,2.5783,2.8505,3.0078,2.5926,2.8952,2.1431,2.4675,623.1759534640657,523.0954740054442,453.56599601375945,623.5809381183982,520.00001326365,452.6324510183392,0.00012849005922939508,-8.177141783891919e-07,-0.00034603301231285195,1.0594396052433263e-06,-0.006424798752879777,5.45205410081526e-06,0.0022098201325155232,2.6869876861514167e-06,-0.00019659258859648193,-8.298080605407248e-07,-0.0012287709920226675,-2.1875186474492335e-06,-0.00030670685412312174,-3.680012990278486e-07,0.0024287075590201605,6.554627315250395e-06,0.0011902542877999349,-3.809076993091248e-06)
TRIPLET( 72,202447,73,0ECKBS0213,0.1537,0.1548,0.1377,0.1253,0.6974,0.698,0.0235,0.0224,0.7388,0.7193,0.3025,0.3017,0.4118,0.8705,2.6978,5.0498,1.1155,2.5442,2.858,3.0166,2.6089,2.9254,2.1344,2.4427,623.1034559026549,523.0175819508254,453.7127245505845,623.5809381183982,520.00001326365,452.72528564973686,0.00013004807981314875,-8.273978687375588e-07,-0.00034872346082578574,1.0813156213286479e-06,-0.006425976053074381,5.336021681203888e-06,0.0022100967282907714,2.6234054874449806e-06,-0.00019501452330685483,-8.194629974894236e-07,-0.0012279275834876033,-2.1337179925228493e-06,-0.00031101485887251616,-3.7135108284123263e-07,0.0024734987347761663,6.701799715402487e-06,0.0012348106231890275,-3.640875104100837e-06)
TRIPLET( 73,202447,74,0ECKBA0209,0.1541,0.1551,0.1363,0.1239,0.6971,0.6978,0.023,0.022,0.7375,0.7178,0.3028,0.302,0.4032,0.8559,2.7077,5.0729,1.1189,2.5804,2.8632,3.0178,2.6098,2.9263,2.142,2.4643,622.9317368619229,522.6811686533531,453.32821848556557,623.4022841735936,520.00001326365,452.41509992157165,0.00013115488052908535,-8.248001153238972e-07,-0.000349970114146742,1.0467734565570166e-06,-0.006418710200995203,5.317384522054348e-06,0.002233779653512285,2.640992370772564e-06,-0.00018988707247266396,-8.256522923232034e-07,-0.0012165559285837405,-2.172479378883078e-06,-0.000311074265233126,-3.354376695612266e-07,0.002486119949249367,6.334778560652272e-06,0.0012751932058567977,-4.02950425774961e-06)
TRIPLET( 74,202447,75,0ECI2U0314,0.1541,0.1552,0.1378,0.1253,0.6966,0.6973,0.023,0.022,0.7385,0.7194,0.3031,0.3024,0.4059,0.8589,2.6875,5.0308,1.1117,2.572,2.8657,3.021,2.6104,2.9267,2.1315,2.4427,622.7764890791112,523.0127929131455,453.32821848556557,623.1715555505127,520.00001326365,452.3536553110712,0.00013374657593209077,-8.381768606299649e-07,-0.000354253983943089,1.0687274119551517e-06,-0.0064183332148031735,5.142757016873933e-06,0.0022099526490011925,2.617403241736845e-06,-0.0001949054066925815,-8.18462571973554e-07,-0.0012279310915114525,-2.128468083246985e-06,-0.0003122157988541415,-3.3270820263764313e-07,0.0024991961087520373,6.336654325389244e-06,0.001290999913372507,-4.0242587732106105e-06)
TRIPLET( 75,202447,76,0ECJKE0109,0.1538,0.1549,0.1361,0.1233,0.6968,0.6976,0.0235,0.0223,0.7382,0.7183,0.3027,0.302,0.401,0.8494,2.7126,5.0585,1.0995,2.5553,2.8735,3.0308,2.5814,2.8739,2.1297,2.4409,623.001849756772,522.6986483528945,453.65452300273074,623.4111040503278,520.00001326365,452.6324510183392,0.00013154534502778523,-8.341864041870217e-07,-0.0003511324414189361,1.0890341862049161e-06,-0.006424955106915543,5.241459969293959e-06,0.002241723559845507,2.7592844829618968e-06,-0.0001908422011322274,-8.460835963844679e-07,-0.0012139936263505235,-2.281074778979669e-06,-0.0003177419550943665,-3.498516353844592e-07,0.0025523644163760097,6.657283975905085e-06,0.0013339481636296842,-3.6688302540623994e-06)
TRIPLET( 76,202447,77,0ECJLP0410,0.1535,0.1546,0.1401,0.1271,0.6967,0.6976,0.0238,0.0227,0.7387,0.7197,0.3029,0.3022,0.4109,0.8639,2.7048,5.0378,1.1081,2.5573,2.846,3.0046,2.5893,2.8858,2.1286,2.4365,622.889401436803,523.4215860962362,453.91977333286565,623.2851115333052,520.00001326365,452.94237210214044,0.0001328267100087091,-8.379863713575615e-07,-0.000353053117727707,1.0850192044787527e-06,-0.006422363221324963,5.174061273576336e-06,0.002187647896228246,2.680145543836199e-06,-0.0002016219997240564,-8.255851156076967e-07,-0.001239524470352667,-2.159414360912614e-06,-0.00030678206958244594,-4.007340676621602e-07,0.0024185826967080062,6.892530482540058e-06,0.0011548973342450086,-3.4509093044362602e-06)
TRIPLET( 77,202447,78,0ECI5B0104,0.1537,0.1548,0.1443,0.1321,0.6968,0.6976,0.0236,0.0224,0.7441,0.7293,0.3028,0.3021,0.4143,0.8751,2.7088,5.1033,1.1033,2.5601,2.8647,3.0212,2.6063,2.9145,2.1337,2.4499,622.943631654591,524.5361127502659,453.74300271511225,623.3482088450268,521.3611028941299,452.72528564973686,0.00013179021515174027,-8.320171674944046e-07,-0.0003512964310369156,1.0729655671968063e-06,-0.006421984396447605,5.248069566802969e-06,0.0021027215073721995,2.5378715329296783e-06,-0.00021812372000096187,-7.904547741839099e-07,-0.0012794205654476723,-1.9530481938086763e-06,-0.0003142564637696164,-3.6641707335445533e-07,0.002509690732531997,6.736035302640278e-06,0.0012765816425846094,-3.5953552034137237e-06)
TRIPLET( 78,202447,79,0ECKIK0309,0.1542,0.1552,0.1351,0.1225,0.6972,0.698,0.023,0.0219,0.7369,0.7163,0.3025,0.3018,0.4061,0.8588,2.696,5.0407,1.1186,2.5742,2.8543,3.0141,2.6093,2.9248,2.1444,2.4709,623.1122562789869,522.4325383839714,453.269794769221,623.5186451117542,520.00001326365,452.32212005834464,0.00012903975559125543,-8.181257848896444e-07,-0.00034677151236186724,1.0512775430173997e-06,-0.00642264506656942,5.431342839003537e-06,0.0022516598198150427,2.6588888477522592e-06,-0.00018612587073185374,-8.310793898162959e-07,-0.0012080219941618627,-2.20567185827781e-06,-0.0003066586557110202,-3.405603487775821e-07,0.0024373538913649434,6.271741037304564e-06,0.0012200616171372386,-4.108886191807142e-06)
TRIPLET( 79,202447,80,0ECIB80314,0.154,0.1551,0.1449,0.132,0.6966,0.6975,0.0232,0.022,0.7413,0.7243,0.3029,0.3022,0.4096,0.8646,2.7083,5.0638,1.1032,2.5562,2.8636,3.0192,2.6107,2.9268,2.1293,2.4387,622.8933791442231,524.4425977342026,453.44713336833604,623.2895288683295,520.9674746402321,452.41509992157165,0.00013272083248462877,-8.372534936115741e-07,-0.0003528650381546831,1.0831372481371502e-06,-0.006422219259449968,5.182449973812655e-06,0.002107962020288387,2.525313123889287e-06,-0.0002165976079736462,-7.891378293944367e-07,-0.0012767210131696739,-1.947633997742091e-06,-0.00031197285770674177,-3.4435197747588027e-07,0.002492720374989767,6.449792698728868e-06,0.001275401347347268,-3.905100677284806e-06)
TRIPLET( 80,202447,81,0ECKT60219,0.1536,0.1547,0.1378,0.1263,0.6971,0.6979,0.0236,0.0225,0.7431,0.727,0.3025,0.3019,0.4157,0.8748,2.7713,5.2411,1.1185,2.5683,2.8183,2.9837,2.5786,2.8764,2.1303,2.4365,623.1166602778858,523.345492213669,453.80113607150946,623.4605597689591,520.2449374755407,452.8180763481897,0.00013028497530134767,-8.307801608862851e-07,-0.0003492664806822508,1.094735049905293e-06,-0.006427787902883406,5.30552320793217e-06,0.0021965329186938143,2.729965592018949e-06,-0.00020072706522491563,-8.349658531206714e-07,-0.0012357397110782406,-2.2107180170725656e-06,-0.00029341960143385655,-4.2164736966505057e-07,0.0022692011342395155,6.7573008075093655e-06,0.0009820745281825388,-3.6323051000096124e-06)
TRIPLET( 81,202447,82,0ECI8T0414,0.1536,0.1547,0.1381,0.1253,0.6966,0.6974,0.0237,0.0225,0.7394,0.7203,0.303,0.3023,0.4137,0.8723,2.6787,5.005,1.11,2.5773,2.8599,3.0137,2.5953,2.8985,2.135,2.4517,622.8350151847785,523.1292527431276,453.8314170616765,623.2306448187245,520.00001326365,452.8180763481897,0.00013281152628518168,-8.3354894805365e-07,-0.00035272232254928326,1.061854356469058e-06,-0.0064186387104671686,5.2044259277920624e-06,0.002206539268698904,2.673490233043282e-06,-0.00019703964884465632,-8.271442188733619e-07,-0.001230223118907435,-2.1727411155442463e-06,-0.0003125970326925715,-3.7861022412277604e-07,0.0024879364257768214,6.8177247962941454e-06,0.001244507129347771,-3.5135552990399116e-06)
TRIPLET( 82,202447,83,0ECNB10308,0.1532,0.1544,0.1384,0.1259,0.6967,0.6975,0.0242,0.023,0.7405,0.7226,0.303,0.3022,0.4168,0.8764,2.7677,5.1837,1.1164,2.5817,2.8194,2.9767,2.5828,2.8816,2.1383,2.457,622.8310453574378,523.2601828462288,454.20563924370344,623.2895288683295,520.00001326365,453.1527960355205,0.00013255095001106035,-8.306605794576525e-07,-0.0003521833703585246,1.0514904854914292e-06,-0.006417357074447952,5.232372591979984e-06,0.0022012533799274283,2.7177267792265e-06,-0.0001993303446223594,-8.336282620209437e-07,-0.001233297730657824,-2.205052955071653e-06,-0.00029635725575237015,-4.5225502418200007e-07,0.0022902899618133157,7.148339565327043e-06,0.0009811345531514463,-3.209678356775406e-06)
TRIPLET( 83,202447,84,0ECI3C0720,0.1536,0.1547,0.1397,0.1271,0.6969,0.6978,0.0237,0.0225,0.74,0.7218,0.3027,0.302,0.4145,0.8766,2.6844,5.0297,1.0993,2.5497,2.8674,3.0204,2.6027,2.9132,2.1265,2.4336,622.9976910754363,523.447032806872,453.8314170616765,623.4022841735936,520.00001326365,452.8180763481897,0.00013188210454101055,-8.371869511129777e-07,-0.00035177760988739325,1.0985582262390944e-06,-0.0064259853957573275,5.210271789104368e-06,0.0021814985347169843,2.622191226347946e-06,-0.0002016827013749835,-8.152591133949743e-07,-0.0012418824203416765,-2.1039418064404e-06,-0.000316021633555618,-3.7042182335202557e-07,0.002527164904284833,6.8233520905050606e-06,0.0012919272518949025,-3.497818845422912e-06)
TRIPLET( 84,202447,85,0ECL5B0315,0.1542,0.1552,0.1446,0.1314,0.6965,0.6973,0.0229,0.0219,0.7437,0.7284,0.303,0.3023,0.4039,0.8536,2.7821,5.2266,1.1124,2.5795,2.821,2.9787,2.5733,2.8716,2.1272,2.4351,622.838982512759,524.5600490671994,453.2395236104917,623.2350475116187,521.1773712441527,452.32212005834464,0.00013348429624747212,-8.405110600390873e-07,-0.00035407908806072845,1.0859952011189134e-06,-0.006421524313041415,5.135605228484948e-06,0.0021116937425037265,2.6750933304869908e-06,-0.0002192885735987644,-8.141215752271789e-07,-0.0012765668690607377,-2.078777436134051e-06,-0.0002912711752659047,-3.745364372411362e-07,0.0022620318221009458,6.21755407157231e-06,0.0010101070930382122,-4.210210768272944e-06)
TRIPLET( 85,202447,86,0ECI7F0519,0.1534,0.1545,0.1376,0.1255,0.6967,0.6975,0.024,0.0228,0.7387,0.7197,0.3029,0.3022,0.4144,0.8803,2.66,4.981,1.1125,2.5799,2.8707,3.0282,2.6102,2.9234,2.1351,2.4517,622.889401436803,522.9932129366446,454.0367280096829,623.2895288683295,520.00001326365,453.03364338318573,0.00013223135702973137,-8.321021653795747e-07,-0.00035187188706606754,1.0651188943719994e-06,-0.006420046284943826,5.2330997034388565e-06,0.0022114127110372285,2.6194879290011713e-06,-0.00019461310849844726,-8.190075308855205e-07,-0.0012272411693882669,-2.1317086516061126e-06,-0.0003187645671020086,-3.8296381379839536e-07,0.002552209078488757,7.023886095459467e-06,0.0013087849312807508,-3.2775564617568943e-06)
TRIPLET( 86,202447,87,0ECIA20510,0.1533,0.1544,0.1422,0.1292,0.697,0.6978,0.024,0.0229,0.7413,0.724,0.3027,0.302,0.4106,0.8752,2.7243,5.0847,1.1197,2.5676,2.8746,3.0193,2.5902,2.8888,2.1313,2.4382,622.993725490559,523.9756435113519,454.09222882960137,623.4022841735936,520.4856680409197,453.1225079615919,0.0001314840945755905,-8.329405830333795e-07,-0.00035096600108385824,1.0836022545424314e-06,-0.006424169194691738,5.251844872217266e-06,0.002147872350886454,2.6411649809347523e-06,-0.0002100088122454989,-8.136479553760495e-07,-0.0012585180001966991,-2.0862826381787288e-06,-0.0003208795115915092,-3.83070222761724e-07,0.002574712006013365,7.080352449110263e-06,0.0013323601528576687,-3.21170267472384e-06)
TRIPLET( 87,202447,88,0ECKCT0219,0.1535,0.1547,0.1375,0.1251,0.6967,0.6975,0.0237,0.0225,0.7382,0.719,0.303,0.3023,0.4155,0.8756,2.6779,5.0117,1.0937,2.5302,2.8636,3.0195,2.611,2.9288,2.1277,2.4362,622.8310453574378,522.9390237323629,453.8894971884302,623.2262369903721,520.00001326365,452.8180763481897,0.00013352183333062407,-8.402563615140624e-07,-0.0003541096849759674,1.0839432988962888e-06,-0.0064211354630079615,5.136094537127255e-06,0.0022150155870245495,2.619566864955805e-06,-0.00019377127161605994,-8.195250556330024e-07,-0.0012254822773620651,-2.1353969609720778e-06,-0.00031463618364392263,-3.791378175042317e-07,0.002509491045902838,6.8765292772747855e-06,0.001266767472474794,-3.445440996328932e-06)
TRIPLET( 88,202447,89,0ECKML0408,0.1538,0.1548,0.1441,0.131,0.6969,0.6977,0.0234,0.0223,0.743,0.727,0.3028,0.3021,0.4101,0.8626,2.7648,5.1935,1.1084,2.5616,2.8264,3.0034,2.5771,2.8808,2.1357,2.4534,622.9396701312091,524.4238732734282,453.62424516763923,623.3438062032577,521.0061387072641,452.6937351425863,0.00013164862228881818,-8.303054330141446e-07,-0.000350993597904545,1.0665823034319308e-06,-0.00642116636806245,5.264212784389442e-06,0.0021201685774738465,2.6677675498092553e-06,-0.00021712959286077955,-8.141121993594546e-07,-0.0012723458518990498,-2.0810645010578296e-06,-0.00029605316886508154,-3.988938562619867e-07,0.002304861693546441,6.592736348316193e-06,0.0010367407443504228,-3.799116842582921e-06)
TRIPLET( 89,202447,90,0ECKRM0520,0.1531,0.1542,0.1352,0.1238,0.697,0.6976,0.0242,0.023,0.7416,0.725,0.3029,0.3022,0.4151,0.8748,2.7486,5.2081,1.1075,2.5487,2.8282,2.9832,2.5895,2.8916,2.1301,2.4386,622.8775232635484,522.7950169004614,454.2610100768561,623.2851115333052,520.00001326365,453.269794769221,0.00013281403170494564,-8.369246894560888e-07,-0.00035296229551360936,1.0796469709343457e-06,-0.006421513338799701,5.181621432967117e-06,0.0022322349839173105,2.7191076962286344e-06,-0.00019210798990859773,-8.381931933663918e-07,-0.001218180608867378,-2.23736640091497e-06,-0.0003007088235318289,-4.4700145630092445e-07,0.002338417233971367,7.208357023096282e-06,0.0010356934584873183,-3.1336784891283504e-06)
TRIPLET( 90,202447,91,0ECKH60612,0.1539,0.155,0.1362,0.1236,0.6967,0.6975,0.0233,0.0221,0.7381,0.7179,0.303,0.3023,0.4054,0.8564,2.705,5.0499,1.1118,2.5692,2.8693,3.0243,2.6077,2.9228,2.1291,2.4382,622.8310453574378,522.7083648485036,453.5357202154199,623.2262369903721,520.00001326365,452.508031085015,0.00013339360345822882,-8.389889940726496e-07,-0.00035385526606422965,1.079657078257911e-06,-0.006420636430556639,5.148810506636109e-06,0.0022325210560294813,2.6480937827626606e-06,-0.000190350826421754,-8.266357614434326e-07,-0.0012172497820170706,-2.177254363827835e-06,-0.0003151089064064147,-3.45094931962283e-07,0.0025258924778972878,6.539526810928358e-06,0.0013097116388823132,-3.801090492777453e-06)
TRIPLET( 91,202447,92,0ECM900306,0.1539,0.1551,0.1379,0.1253,0.6967,0.6974,0.0233,0.0221,0.7387,0.7199,0.303,0.3023,0.4061,0.857,2.683,5.0262,1.1086,2.5683,2.8692,3.0247,2.5987,2.9062,2.1378,2.4576,622.8310453574378,523.0443531840941,453.5357202154199,623.2306448187245,520.00001326365,452.44663414036876,0.00013259674639405864,-8.311132106867288e-07,-0.00035227423425557384,1.0530212785765645e-06,-0.006417535300323424,5.227831174298251e-06,0.002211489386741388,2.6645888381878908e-06,-0.00019566858003419122,-8.263838384160872e-07,-0.001227706145054337,-2.170145455267217e-06,-0.0003150632450615743,-3.452041106392261e-07,0.0025253694315171826,6.539451780338879e-06,0.001309079370581688,-3.8013003121590124e-06)
TRIPLET( 92,202447,93,0ECI4W0106,0.1546,0.1556,0.1351,0.1228,0.6967,0.6975,0.0225,0.0215,0.7369,0.7165,0.3029,0.3022,0.4006,0.8477,2.6668,4.9846,1.1092,2.5724,2.8568,3.0148,2.6025,2.9109,2.137,2.4554,622.889401436803,522.4325383839714,452.87926248047864,623.2895288683295,520.00001326365,451.9476976871855,0.00013205733077433786,-8.30382166709086e-07,-0.0003515266042572806,1.059301880648486e-06,-0.006419369026617032,5.250357090629441e-06,0.00225386014153979,2.6874781825399496e-06,-0.00018629104544241036,-8.360565879165713e-07,-0.0012072657664953643,-2.232199479928979e-06,-0.00030544892386531524,-3.0712088002969266e-07,0.0024356243904634003,5.8968807193434755e-06,0.001243490573041038,-4.509442310138955e-06)
TRIPLET( 93,202447,94,0ECI0M0509,0.154,0.1551,0.1356,0.1248,0.6964,0.6973,0.0232,0.022,0.741,0.7239,0.3032,0.3024,0.4085,0.8615,2.6968,5.1,1.1082,2.5602,2.8623,3.0196,2.6129,2.9229,2.1375,2.4536,622.7257139516769,522.8191967455434,453.44713336833604,623.1715555505127,520.00001326365,452.41509992157165,0.00013373011553897778,-8.340114899384228e-07,-0.00035394061951404235,1.047024284616921e-06,-0.006414847111178743,5.171332103058607e-06,0.002222940137021804,2.619190717399601e-06,-0.00019190656093913102,-8.205735705451803e-07,-0.0012216074580607011,-2.1430418275627076e-06,-0.0003113792602238137,-3.4577130027614355e-07,0.0024859207720483775,6.448817301065643e-06,0.001267181859439099,-3.907828329245087e-06)
TRIPLET( 94,202447,95,0ECI9K0218,0.1539,0.155,0.1338,0.1223,0.6965,0.6974,0.0232,0.0221,0.7381,0.7191,0.303,0.3023,0.4109,0.869,2.6679,5.0227,1.1174,2.5911,2.8564,3.0165,2.6007,2.9029,2.1302,2.441,622.838982512759,522.301479495141,453.5054451575055,623.2306448187245,520.00001326365,452.508031085015,0.00013320951794948242,-8.377952726646321e-07,-0.00035353390467843335,1.0768104426081053e-06,-0.006420454957788584,5.16285373457534e-06,0.002263782355248963,2.7033715068456667e-06,-0.0001843457478432257,-8.400419211646197e-07,-0.001202596460833646,-2.2556898510027562e-06,-0.0003090363168330849,-3.5679826371203524e-07,0.0024572717223511707,6.500642324009955e-06,0.001228739924214163,-3.859615967043273e-06)
TRIPLET( 95,202447,96,0ECJLA0303,0.1542,0.1553,0.1371,0.1239,0.6973,0.698,0.0229,0.0219,0.7371,0.7167,0.3023,0.3017,0.4011,0.847,2.7373,5.0925,1.0821,2.5198,2.8283,2.9919,2.5916,2.8928,2.1198,2.4222,623.2350475116187,522.788790519571,453.2395236104917,623.5809381183982,520.00001326365,452.26062195118374,0.00013000373279828853,-8.373331366482084e-07,-0.0003493629646917916,1.1346543470018559e-06,-0.006434672226647177,5.270592972009895e-06,0.0022319991893643863,2.71067416985923e-06,-0.0001919624851600976,-8.367828619243107e-07,-0.0012182018292429184,-2.2299564301346083e-06,-0.00029460445343927003,-3.665663938242727e-07,0.0023002142078487435,6.223031304604267e-06,0.001056262678984083,-4.194893953419064e-06)
TRIPLET( 96,202447,97,0ECLX40103,0.1533,0.1545,0.1354,0.1235,0.6968,0.6975,0.0241,0.0228,0.7393,0.7199,0.303,0.3023,0.4058,0.8574,2.6958,5.045,1.1164,2.5924,2.8624,3.0112,2.6007,2.9063,2.1299,2.4408,622.8270924030855,522.6603131478605,454.12122012721716,623.2262369903721,520.00001326365,453.03364338318573,0.0001333618319468868,-8.383633608521134e-07,-0.0003537703751545107,1.0769482804918174e-06,-0.006420246371664489,5.154058696482508e-06,0.0022382104476428803,2.680576480497878e-06,-0.00018979160071088563,-8.3273748993512e-07,-0.0012148327421672783,-2.2106002006832222e-06,-0.0003154833745145937,-3.986697888055213e-07,0.0025119994508887716,7.099165848749772e-06,0.00125465757997293,-3.2071758189175964e-06)
TRIPLET( 97,202447,98,0ECI8E0815,0.1534,0.1546,0.1368,0.1253,0.697,0.6978,0.0238,0.0227,0.7398,0.7219,0.3027,0.302,0.4137,0.874,2.6989,5.0865,1.0934,2.5057,2.8659,3.0171,2.6097,2.9213,2.1309,2.4372,622.993725490559,522.9364741557148,453.9777988040977,623.4022841735936,520.00001326365,452.94237210214044,0.00013152073168198913,-8.333026880166401e-07,-0.0003510386922014976,1.0848268890105394e-06,-0.006424311775392116,5.2482117380718775e-06,0.0022156179296980924,2.6251944357759357e-06,-0.00019376415538522853,-8.205284780766524e-07,-0.0012252507634800363,-2.1407887880028523e-06,-0.0003162180293351975,-3.8357041747253953e-07,0.002524868758339141,6.963437194292327e-06,0.001279586208817799,-3.3488610543953863e-06)
TRIPLET( 98,202447,99,0ECK4W0302,0.1543,0.1553,0.1432,0.1306,0.6971,0.6977,0.0228,0.0217,0.7424,0.726,0.3028,0.3021,0.404,0.8556,2.7119,5.0917,1.1057,2.5619,2.8441,3.0008,2.5886,2.8899,2.1336,2.4495,622.9317368619229,524.2259195681621,453.150767759369,623.3438062032577,520.8648503394621,452.19757558272363,0.00013192425976345657,-8.324043199723722e-07,-0.00035149662761716833,1.0724907803872824e-06,-0.006421704395703135,5.24108870500124e-06,0.0021305544103726623,2.6319930140375573e-06,-0.00021384600118022314,-8.09724432056536e-07,-0.0012668745153195258,-2.0610757092400342e-06,-0.0003012845763630304,-3.423367339481067e-07,0.002379490669469502,6.149265735454133e-06,0.0011578933706353836,-4.25396858277212e-06)
TRIPLET( 99,202447,100,0ECJSS0219,0.1537,0.1548,0.1442,0.1314,0.697,0.6977,0.0235,0.0224,0.7415,0.7247,0.3026,0.302,0.4049,0.8564,2.6834,5.0131,1.0921,2.5357,2.8647,3.0259,2.5918,2.8906,2.1241,2.4306,623.0571483010252,524.3351288947896,453.7127245505845,623.4066843302342,520.8984510885125,452.72528564973686,0.00013147767623615324,-8.37876867249234e-07,-0.0003513038937237102,1.1098096612735223e-06,-0.006428418665396434,5.218827330533685e-06,0.0021217362756088026,2.611601650874767e-06,-0.00021542569149193868,-8.051591520563618e-07,-0.0012709544415670233,-2.0348693005656484e-06,-0.00031407416897683764,-3.640361114860288e-07,0.0025085428422433245,6.706826764897571e-06,0.00127717259933113,-3.6268172055363177e-06)
TRIPLET(100,202447,101,0ECM6I0118,0.1532,0.1544,0.1351,0.123,0.6966,0.6974,0.0241,0.0229,0.738,0.7186,0.3029,0.3022,0.4222,0.8908,2.7012,5.0498,1.1042,2.5585,2.8727,3.0265,2.6092,2.9215,2.1363,2.4536,622.8933791442231,522.5136665010401,454.176656157667,623.293937503014,520.00001326365,453.1225079615919,0.00013207968312265277,-8.309166564045114e-07,-0.0003515929435959945,1.0617061449452623e-06,-0.006419724097193359,5.246029821356905e-06,0.0022459106664775197,2.654155588704642e-06,-0.00018735954379143856,-8.295011369265593e-07,-0.001210777354116916,-2.195867724637344e-06,-0.0003205202549979784,-3.9178366764244817e-07,0.002567974890475014,7.160371659454881e-06,0.0013186992373242362,-3.1279609141188275e-06)
TRIPLET(101,202447,102,0ECI9N0610,0.1535,0.1546,0.144,0.1316,0.6969,0.6976,0.0238,0.0227,0.7437,0.7283,0.3029,0.3021,0.4028,0.8535,2.7167,5.1102,1.1094,2.5671,2.8561,3.0035,2.6011,2.9072,2.1332,2.4492,622.8814782279493,524.4559252935017,453.91977333286565,623.3482088450268,521.2029650998462,452.94237210214044,0.00013248857032507663,-8.340197489642691e-07,-0.0003523384172669427,1.0704157146049137e-06,-0.006420513289202783,5.211797327216503e-06,0.00211011858216843,2.564827900099299e-06,-0.0002170330620216609,-7.958931657120021e-07,-0.001276107869409905,-1.9834100681144537e-06,-0.00031139386541134857,-3.897070212908832e-07,0.002471410381098795,6.900108572077423e-06,0.0012187564326084782,-3.4297175468986997e-06)
TRIPLET(102,202447,103,0ECJA10319,0.1534,0.1545,0.1357,0.1236,0.6969,0.6979,0.0239,0.0228,0.7396,0.721,0.3024,0.3018,0.4013,0.8588,2.6721,5.0134,1.0899,2.52,2.8861,3.0254,2.5922,2.8897,2.1247,2.4298,623.1891784930976,522.7334666978361,454.0077409373861,623.5230655825276,520.00001326365,453.03364338318573,0.0001300365144237765,-8.340412086356054e-07,-0.00034917442356364786,1.1166410720676664e-06,-0.0064317084108064665,5.291681626109045e-06,0.0022357476380310405,2.7116660455503285e-06,-0.00019110828679158291,-8.374698711664444e-07,-0.0012163820046013356,-2.2345675353119616e-06,-0.00032562189265306876,-3.638708623557212e-07,0.002631659277964901,7.007477750735766e-06,0.0014067200073175634,-3.275364706829682e-06)
TRIPLET(103,202447,104,0ECM3E0605,0.1541,0.1551,0.1404,0.128,0.6968,0.6976,0.0231,0.022,0.7408,0.7228,0.303,0.3022,0.4013,0.8487,2.6944,5.0486,1.1154,2.5815,2.8564,3.0061,2.5965,2.9037,2.1328,2.4471,622.8270924030855,523.6259374075842,453.35849700008356,623.2851115333052,520.2020591923159,452.41509992157165,0.00013309621292549673,-8.357380997234734e-07,-0.0003532433645516254,1.068069680598035e-06,-0.006419212661586751,5.180398919036555e-06,0.002170755259832972,2.6368929989016246e-06,-0.0002045484544677684,-8.161553582266437e-07,-0.0012472935923412208,-2.105648294728882e-06,-0.0003081515906839176,-3.452428089837237e-07,0.002451700698959428,6.358885355936611e-06,0.0012316079978365799,-4.012309609898674e-06)
TRIPLET(104,202447,105,0ECJKK0418,0.1538,0.1549,0.1366,0.1238,0.6967,0.6975,0.0234,0.0223,0.7382,0.7181,0.303,0.3023,0.4075,0.8595,2.7229,5.0695,1.1044,2.5562,2.8317,2.9915,2.5776,2.8674,2.1269,2.4341,622.8310453574378,522.7842275164045,453.62424516763923,623.2262369903721,520.00001326365,452.6324510183392,0.0001335951075434213,-8.409805714805836e-07,-0.0003542550672112461,1.0863925678325048e-06,-0.006421420624408716,5.128828268836484e-06,0.0022368544411854713,2.7698244312941224e-06,-0.0001922333001458707,-8.471229191464883e-07,-0.0012164892908377374,-2.2851454911164834e-06,-0.00029847322014163436,-3.931073863839897e-07,0.0023325831516921042,6.596712969558572e-06,0.0010702509642837275,-3.7879964153602408e-06)
TRIPLET(105,202447,106,0ECJ7F0108,0.1543,0.1554,0.1355,0.1236,0.6968,0.6975,0.0228,0.0217,0.7381,0.7186,0.3028,0.3022,0.4023,0.8507,2.6728,5.0042,1.1188,2.5697,2.8493,3.0083,2.6071,2.9172,2.1334,2.4421,622.943631654591,522.5889913182895,453.150767759369,623.2895288683295,520.00001326365,452.13602822440146,0.00013181769298153926,-8.322887462318504e-07,-0.0003513509493751452,1.0738840430478877e-06,-0.006422091331972889,5.245344716193925e-06,0.002241222232723248,2.6581996140741974e-06,-0.00018855372364313602,-8.295048980187737e-07,-0.0012131124007765148,-2.1945950528911705e-06,-0.0003036589662947426,-3.3665944274705356e-07,0.002406689081235057,6.153167326107034e-06,0.0011907713222680597,-4.243057974931e-06)
TRIPLET(106,202447,107,0ECLMW0710,0.1534,0.1546,0.1444,0.131,0.6968,0.6976,0.024,0.0228,0.7424,0.7258,0.3027,0.3021,0.41,0.8613,2.7798,5.1899,1.1116,2.5764,2.8308,2.9825,2.6002,2.922,2.1311,2.4426,623.001849756772,524.4335366589274,454.0367280096829,623.3482088450268,520.9156098842099,452.973943334463,0.00013141711515539004,-8.329190367456093e-07,-0.0003508780225071984,1.084747965566539e-06,-0.006424456074464221,5.25417593880281e-06,0.002112005304012182,2.570034028053271e-06,-0.00021671514139821651,-7.970076564005187e-07,-0.0012752443246598364,-1.9897343461765637e-06,-0.0003005456905106007,-4.2652610589878687e-07,0.002343513572826134,6.9939488902574e-06,0.0010565098793300191,-3.361274394999334e-06)
TRIPLET(107,202447,108,0ECI3L0306,0.1539,0.155,0.1352,0.1234,0.697,0.6978,0.0234,0.0223,0.739,0.7199,0.3026,0.3019,0.4086,0.8626,2.6219,4.9136,1.1167,2.5609,2.8634,3.0133,2.5897,2.8853,2.132,2.4393,623.0571483010252,522.6042479536085,453.56599601375945,623.4649735019518,520.00001326365,452.57111332358465,0.00013075409338478028,-8.307252938298345e-07,-0.00034986824415033296,1.0856231305283902e-06,-0.006425602696563974,5.29058172990506e-06,0.002245765219453081,2.730385493819728e-06,-0.0001892079194974616,-8.419301049902383e-07,-0.0012116976011806715,-2.260557465506742e-06,-0.0003125971676075619,-3.5391724970215803e-07,0.0024961805420539423,6.564306261293168e-06,0.0012718168985809998,-3.782010292870008e-06)
TRIPLET(108,202447,109,0ECJBU0308,0.1532,0.1544,0.1343,0.1223,0.6971,0.698,0.0241,0.0229,0.7378,0.7184,0.3023,0.3018,0.4185,0.8818,2.6241,4.9292,1.0941,2.5425,2.8684,3.0229,2.5924,2.8887,2.1236,2.4298,623.2438666031982,522.3636000262844,454.176656157667,623.5186451117542,520.00001326365,453.1225079615919,0.00012956308723118987,-8.33673213329605e-07,-0.000348537442155331,1.1235993316845423e-06,-0.006433551737634845,5.3096101051408324e-06,0.002262041086921373,2.734321085276871e-06,-0.00018549013280537058,-8.448525027597185e-07,-0.0012037917376622753,-2.28026332798176e-06,-0.0003185568171698316,-3.96478350751012e-07,0.0025454838961304193,7.15714534410729e-06,0.0012915117003972146,-3.136983147525908e-06)
TRIPLET(109,202447,110,0ECJLA0710,0.1536,0.1547,0.1369,0.124,0.6976,0.6983,0.0237,0.0226,0.7372,0.7167,0.302,0.3014,0.4055,0.8544,2.7107,5.0472,1.1102,2.5399,2.8362,2.9979,2.5886,2.8875,2.1333,2.4424,623.4111040503278,522.761821629863,453.8314170616765,623.7534062396797,520.00001326365,452.8496316579241,0.00012691878463320407,-8.207216858974143e-07,-0.0003442154789901988,1.1048818193900312e-06,-0.00643453204870677,5.483092354559071e-06,0.0022348918294544484,2.7250003193065575e-06,-0.0001916260619538004,-8.395276643412128e-07,-0.0012169485562093707,-2.245048599104592e-06,-0.00030177529396534426,-4.0448557055834725e-07,0.0023639744336915007,6.799942546587654e-06,0.0010946595420988393,-3.563282492469632e-06)
TRIPLET(110,202447,111,0ECI2I0220,0.1538,0.155,0.1357,0.1237,0.6967,0.6975,0.0233,0.0222,0.7375,0.7175,0.303,0.3023,0.4084,0.8637,2.6645,4.9928,1.1086,2.5616,2.8668,3.0181,2.6155,2.9341,2.1333,2.4464,622.8310453574378,522.578777894165,453.5939806564536,623.2262369903721,520.00001326365,452.53956127768106,0.0001330089138410432,-8.351868917484117e-07,-0.00035309200932901645,1.0667984163427772e-06,-0.006419139333202674,5.18695841516266e-06,0.002239232037303152,2.6235321881255487e-06,-0.00018819467986688684,-8.235644993258702e-07,-0.001213698285071286,-2.163109017322609e-06,-0.0003143181395901609,-3.5240578255632257e-07,0.0025150250584394483,6.593853339737898e-06,0.0012927678280705117,-3.7457976273849017e-06)
TRIPLET(111,202447,112,0ECJT50320,0.154,0.155,0.1455,0.1323,0.697,0.698,0.0232,0.0221,0.7416,0.7246,0.3024,0.3018,0.4004,0.8517,2.7135,5.0578,1.0829,2.5086,2.8639,3.0232,2.5931,2.8943,2.1255,2.4339,623.1847754919078,524.5685322238321,453.44713336833604,623.5186451117542,521.0399878077081,452.508031085015,0.00013000946802633182,-8.334267984520275e-07,-0.0003490964196370168,1.1139027267483388e-06,-0.0064313064092557225,5.296700056200822e-06,0.0021046823800164997,2.5913090191596105e-06,-0.00021893636866238445,-7.994564620115353e-07,-0.001279058103002146,-2.000469282994415e-06,-0.0003121098417412638,-3.440244414450498e-07,0.0024942895141300877,6.450017790497305e-06,0.0012772981522491539,-3.904471219140126e-06)
TRIPLET(112,202447,113,0ECLE40116,0.1534,0.1545,0.1442,0.1309,0.6967,0.6974,0.0239,0.0228,0.7424,0.7259,0.303,0.3023,0.4152,0.8737,2.7742,5.1975,1.109,2.5698,2.8223,2.992,2.6017,2.9274,2.1264,2.4341,622.8310453574378,524.398824115897,454.0077409373861,623.2306448187245,520.9066772226507,453.03364338318573,0.0001336409039264196,-8.414332027096595e-07,-0.00035434593110829533,1.0879233609176402e-06,-0.006421598850284188,5.124286851154751e-06,0.0021139936922553258,2.565932682909266e-06,-0.0002161518895427582,-7.966163548765666e-07,-0.0012742274366668058,-1.9882445089629595e-06,-0.0002964899546447524,-4.3352685824557134e-07,0.0022979556874567434,6.959608234648251e-06,0.0010033328315166394,-3.4092294722649626e-06)
TRIPLET(113,202447,114,0ECM900607,0.1535,0.1546,0.1371,0.1249,0.6971,0.6977,0.0238,0.0226,0.7392,0.7206,0.3029,0.3022,0.4131,0.8717,2.6763,5.0117,1.1007,2.5538,2.8656,3.0203,2.5946,2.8966,2.1318,2.446,622.8735543333753,522.9438754086573,453.91977333286565,623.2807246824516,520.00001326365,452.91081911335084,0.00013269999443691114,-8.354847184200298e-07,-0.00035271409406421845,1.074181696732146e-06,-0.006420802049389664,5.195036018599148e-06,0.002219976495629316,2.6882094092218156e-06,-0.00019424326580700686,-8.314301254416776e-07,-0.0012238238770551184,-2.1987656997043826e-06,-0.0003157316931712076,-3.7933504698126584e-07,0.0025210997872089445,6.907236478077915e-06,0.0012788219211681759,-3.4097847056505e-06)
TRIPLET(114,202447,115,0ECM7T0419,0.1534,0.1545,0.1377,0.1253,0.6968,0.6975,0.024,0.0228,0.7384,0.7191,0.3028,0.3022,0.4005,0.8562,2.7136,5.0814,1.0952,2.5415,2.8911,3.0294,2.6109,2.9289,2.1274,2.4358,622.943631654591,522.9883319238427,454.0367280096829,623.2895288683295,520.00001326365,453.03364338318573,0.0001323672495775187,-8.377203209807613e-07,-0.00035244131613973537,1.0922535600695056e-06,-0.006424230042478554,5.190847704013138e-06,0.002211534047638583,2.616854977194543e-06,-0.00019452202833905352,-8.185945303363478e-07,-0.0012271525730859067,-2.129591196233532e-06,-0.0003280794814494953,-3.606913637019543e-07,0.0026589105400305502,7.0391923357131544e-06,0.0014377676646089473,-3.234753307918654e-06)
TRIPLET(115,202447,116,0ECJET0320,0.1534,0.1545,0.1368,0.1238,0.6966,0.6974,0.024,0.0228,0.7384,0.7182,0.303,0.3023,0.4182,0.8781,2.7711,5.1595,1.1064,2.5596,2.8292,2.9902,2.5857,2.8848,2.1373,2.4555,622.8350151847785,522.8332951230195,454.0367280096829,623.2306448187245,520.00001326365,453.03364338318573,0.0001326008629233895,-8.314668443999004e-07,-0.00035230434862285694,1.0548127082774359e-06,-0.006417818871439996,5.225316449128035e-06,0.002230736717691373,2.732652452463078e-06,-0.00019278122435470636,-8.401953758481052e-07,-0.0012190633041794683,-2.2473807665278207e-06,-0.0002998151089931508,-4.282729647298802e-07,0.0023351448307444254,6.992748400825738e-06,0.0010463935865199642,-3.3646315051042937e-06)
TRIPLET(116,202447,117,0ECI3L0313,0.1541,0.1552,0.1373,0.125,0.6967,0.6974,0.023,0.0219,0.7391,0.7203,0.303,0.3023,0.4053,0.8561,2.6696,4.9984,1.1146,2.5852,2.8565,3.0157,2.5993,2.9048,2.1382,2.4584,622.8310453574378,522.9709647022186,453.32821848556557,623.2306448187245,520.00001326365,452.32212005834464,0.00013256010928766002,-8.307511057034682e-07,-0.0003522015431379345,1.0517966441084566e-06,-0.006417392719623047,5.231464308443636e-06,0.0022165251946524986,2.6667282773829963e-06,-0.0001945402226494183,-8.274385725543728e-07,-0.001225270312794735,-2.177026495838614e-06,-0.0003080149551288043,-3.427526409164304e-07,0.0024510758417822104,6.329751511157188e-06,0.0012328312297146954,-4.04356215631413e-06)
TRIPLET(117,202447,118,0ECKIK0707,0.1535,0.1546,0.1357,0.1231,0.697,0.6979,0.0239,0.0227,0.7372,0.717,0.3027,0.302,0.4141,0.8744,2.6855,5.0201,1.1194,2.5814,2.8617,3.0146,2.6055,2.9187,2.1403,2.4624,622.993725490559,522.5566371442493,453.95005738617095,623.3978745786332,520.00001326365,452.94237210214044,0.00013065975968162133,-8.247932209100133e-07,-0.0003493304509369729,1.0560479790100037e-06,-0.00642096112893324,5.3335903904884485e-06,0.00224404564209462,2.666981825972916e-06,-0.00018810156390195164,-8.313346062286292e-07,-0.001211831182671523,-2.2049023467189036e-06,-0.00031413323096958034,-3.859744403219723e-07,0.002501849091925773,6.933524503577563e-06,0.001253572385762413,-3.3864995403874957e-06)
TRIPLET(118,202447,119,0ECM3E0320,0.1541,0.1551,0.139,0.1264,0.6968,0.6976,0.0231,0.022,0.7396,0.7212,0.3028,0.3021,0.4045,0.8547,2.7031,5.0613,1.119,2.5721,2.8617,3.0175,2.6021,2.9128,2.1332,2.4423,622.943631654591,523.2976815869843,453.35849700008356,623.3482088450268,520.00001326365,452.41509992157165,0.00013183601153473855,-8.324697987234805e-07,-0.0003513872949339648,1.0744963602819417e-06,-0.006422162622323078,5.243528149121233e-06,0.0021923360403329874,2.6342014003006426e-06,-0.0001994306410246956,-8.187384769403342e-07,-0.0012367227953907042,-2.1250493761586683e-06,-0.0003105716419604706,-3.3945633910572666e-07,0.0024794221571050913,6.36286197717899e-06,0.001265118217769888,-4.001189182675994e-06)
TRIPLET(119,202447,120,0ECL3M0120,0.1538,0.1549,0.1423,0.1297,0.697,0.6979,0.0235,0.0223,0.7421,0.7257,0.3025,0.3019,0.4078,0.8566,2.7547,5.1739,1.0902,2.5326,2.8154,2.9716,2.6146,2.9448,2.1238,2.4295,623.1210610789501,524.0499573613976,453.65452300273074,623.4605597689591,520.6949135488044,452.6324510183392,0.00013083412356444392,-8.365546219469318e-07,-0.0003503803667033543,1.1149242919472406e-06,-0.006430221621030946,5.248731493051513e-06,0.002134681179468015,2.5338589089367422e-06,-0.00021054395355096442,-7.942758619812684e-07,-0.00126376563642347,-1.981757298642219e-06,-0.0002912127137419654,-4.132844466885387e-07,0.0022484744695339433,6.613691203417865e-06,0.0009666002809645795,-3.7907353147487593e-06)
TRIPLET(120,202447,121,0ECNCP0218,0.1536,0.1547,0.1418,0.1292,0.6971,0.6979,0.0237,0.0225,0.742,0.725,0.3025,0.3019,0.4101,0.861,2.742,5.1378,1.1013,2.5589,2.8226,2.9765,2.6102,2.9354,2.1254,2.4324,623.1166602778858,523.9563284344713,453.8314170616765,623.4605597689591,520.5609159594333,452.8180763481897,0.0001307337798547309,-8.35215946931229e-07,-0.0003501569468733329,1.1097368221396153e-06,-0.006429534516463033,5.2610173146511905e-06,0.0021427772852967535,2.558305698787981e-06,-0.00020922986825879246,-7.994023158600497e-07,-0.001260083552199565,-2.01068727948781e-06,-0.00029556535106701966,-4.193338706226414e-07,0.002292840125996974,6.789738386418529e-06,0.0010086710532133739,-3.5918179283617922e-06)
TRIPLET(121,202447,122,0ECI430605,0.1541,0.1552,0.137,0.1243,0.6965,0.6975,0.0231,0.022,0.7387,0.7193,0.3029,0.3023,0.4093,0.8657,2.6872,5.0203,1.1097,2.5735,2.8713,3.0267,2.6029,2.9135,2.1294,2.4391,622.8973470238635,522.8898031847709,453.35849700008356,623.2262369903721,520.00001326365,452.3536553110712,0.0001326700138035796,-8.370640184206049e-07,-0.0003527861456508026,1.0830915982607744e-06,-0.006422288907830866,5.185383955512626e-06,0.002221144209698547,2.6567485594129396e-06,-0.00019322102629254706,-8.264557122036211e-07,-0.0012229030487100985,-2.1731809035329655e-06,-0.00031495513106517023,-3.289751861191658e-07,0.0025296346095953475,6.370064913768961e-06,0.0013258159746302144,-3.981046522046233e-06)
TRIPLET(122,202447,123,0ECLE40216,0.1533,0.1544,0.144,0.1307,0.6968,0.6975,0.024,0.0229,0.7426,0.7258,0.3028,0.3022,0.4178,0.8807,2.7779,5.1999,1.1049,2.5659,2.8223,2.9903,2.6003,2.9249,2.1267,2.4344,622.943631654591,524.3783018784791,454.09222882960137,623.2895288683295,520.8662101296825,453.1225079615919,0.0001324313645137163,-8.383540047014677e-07,-0.0003525685255956043,1.094396670388695e-06,-0.006424479558704215,5.184489719258712e-06,0.0021159091956061337,2.573122404336913e-06,-0.00021587443956755202,-7.980588235634504e-07,-0.0012733719313639908,-1.996284823185425e-06,-0.00029699862823986413,-4.401706708030903e-07,0.002301158749217493,7.041111450812818e-06,0.0010016838316290085,-3.3214382112797207e-06)
TRIPLET(123,202447,124,0ECJNF0410,0.1542,0.1552,0.1381,0.1248,0.6975,0.6984,0.023,0.0219,0.7382,0.7182,0.3019,0.3014,0.4002,0.8481,2.7734,5.1564,1.117,2.5571,2.8499,3.0085,2.6083,2.9235,2.1344,2.4447,623.4782135692715,523.0420719877328,453.269794769221,623.7489876126402,520.00001326365,452.32212005834464,0.00012611343899266296,-8.180523544675461e-07,-0.00034298861392460084,1.105920109525693e-06,-0.006435920802141874,5.5273444999022275e-06,0.002208545617278427,2.6243723381225386e-06,-0.00019540077154234464,-8.194036419222191e-07,-0.0012286959714457237,-2.132981341609656e-06,-0.0003046495565380328,-3.4536421056308896e-07,0.0024143398506402437,6.268439691367495e-06,0.0011922418119095883,-4.118118244595782e-06)
TRIPLET(124,202447,125,0ECJSJ0105,0.1538,0.1549,0.1423,0.13,0.6976,0.6984,0.0234,0.0223,0.7417,0.7248,0.3019,0.3012,0.4028,0.8494,2.6829,5.025,1.1196,2.5625,2.8377,2.9992,2.5907,2.8849,2.1369,2.4491,623.473792640619,524.0216476563811,453.62424516763923,623.8718294897606,520.6760710532348,452.6324510183392,0.00012593087311632824,-8.158994451709669e-07,-0.00034260194708863093,1.0979758907001861e-06,-0.006434912356882782,5.547794597710237e-06,0.002144432124904932,2.6361403954523013e-06,-0.00021069485074003673,-8.123455228340162e-07,-0.0012601423534119912,-2.078551374652173e-06,-0.0003012129008320716,-3.865566657673899e-07,0.0023639659344985124,6.601214804927304e-06,0.0011081870623214328,-3.7754072524666405e-06)
TRIPLET(125,202447,126,0ECN1N0613,0.1541,0.1552,0.1402,0.1273,0.6976,0.6983,0.0231,0.022,0.7413,0.7241,0.3021,0.3015,0.4003,0.8424,2.7941,5.2398,1.1132,2.5622,2.8186,2.9724,2.57,2.8601,2.139,2.4568,623.3482088450268,523.6275364121789,453.35849700008356,623.6917034734264,520.1876632917157,452.3536553110712,0.0001270570527104244,-8.171301382220764e-07,-0.00034414210419773776,1.083301431512726e-06,-0.006430831256412041,5.502754998347125e-06,0.002179216091623153,2.748205740999639e-06,-0.000205216417386304,-8.355192426025557e-07,-0.001244401054937208,-2.208827072012753e-06,-0.00029089160233416273,-3.8651234886830526e-07,0.002253989167279048,6.3305237931136e-06,0.000992610580199043,-4.091621336128354e-06)
TRIPLET(126,202447,127,0ECI820212,0.1539,0.155,0.1399,0.1275,0.6965,0.6973,0.0233,0.0222,0.7409,0.7232,0.3031,0.3024,0.4129,0.8713,2.7025,5.0795,1.1097,2.5741,2.8642,3.0207,2.6005,2.9073,2.1319,2.4436,622.7804419790724,523.5467605834051,453.5357202154199,623.1715555505127,520.1521335385681,452.53956127768106,0.00013366843669529663,-8.377161802570964e-07,-0.00035412080233222586,1.0677623027459048e-06,-0.006418295530150841,5.148408201695755e-06,0.0021751034070846766,2.6251054770601926e-06,-0.00020324966272592797,-8.148393210267921e-07,-0.0012450384905748587,-2.0999928652032338e-06,-0.0003127801778195431,-3.506630444863935e-07,0.002499217112511838,6.535700250864936e-06,0.0012774659555502658,-3.811791281237014e-06)
TRIPLET(127,202447,128,0ECICJ0713,0.1547,0.1557,0.1436,0.1313,0.6967,0.6977,0.0223,0.0213,0.7422,0.7258,0.3028,0.302,0.4011,0.8492,2.7016,5.072,1.0862,2.5104,2.8449,3.0069,2.5982,2.9055,2.1322,2.4458,622.9476062506113,524.280817862599,452.7549825793871,623.4066843302342,520.9651318943668,451.81789540289253,0.00013188587437993588,-8.332759447468426e-07,-0.00035150820022407847,1.077818896152732e-06,-0.006422624545859095,5.236474440795172e-06,0.002123535803879867,2.5881441679271246e-06,-0.00021444597945133504,-8.015802877135525e-07,-0.0012698141709162221,-2.016726641702027e-06,-0.0002992669757379777,-3.1034023494356915e-07,0.00236867023517991,5.768062573397829e-06,0.0011706762891965442,-4.663549903174203e-06)
TRIPLET(128,202447,129,0ECLZZ0508,0.1533,0.1545,0.1379,0.1254,0.6965,0.6974,0.0241,0.0228,0.7393,0.7206,0.3032,0.3024,0.4201,0.8862,2.6909,5.041,1.1061,2.5604,2.8694,3.0214,2.5965,2.9015,2.1321,2.4443,622.7217488054146,523.0879126325138,454.12122012721716,623.1671524279715,520.00001326365,453.03364338318573,0.00013426634718163394,-8.389987879940201e-07,-0.00035498262749826667,1.0632965206540167e-06,-0.006416666729612078,5.120260489387688e-06,0.0022090970366802987,2.6710712005015717e-06,-0.00019638310057193642,-8.271074106316633e-07,-0.0012289468668813005,-2.1732544091145037e-06,-0.0003186796686534374,-3.9102728141948747e-07,0.0025486126974962504,7.104417990013292e-06,0.0012989163610169219,-3.1924884622083966e-06)
TRIPLET(129,202447,130,0ECM9B0820,0.1541,0.1552,0.1367,0.1247,0.6971,0.6978,0.023,0.0219,0.7396,0.7209,0.3027,0.3019,0.4038,0.8532,2.7064,5.0667,1.0911,2.5201,2.8605,3.0177,2.5927,2.8925,2.1258,2.4315,622.989757323568,522.9045721992608,453.32821848556557,623.4649735019518,520.00001326365,452.32212005834464,0.0001320295172099595,-8.380184826641727e-07,-0.0003520262280731407,1.1001804508724423e-06,-0.006426024378140667,5.199863432855249e-06,0.0022233921938059234,2.6986943550693153e-06,-0.0001936929308804179,-8.336208707437731e-07,-0.0012222723328177837,-2.2111165187142528e-06,-0.0003098414089224293,-3.3838549383869667e-07,0.0024719976969864825,6.332752734736343e-06,0.001258121961739831,-4.03516938105173e-06)
TRIPLET(130,202447,131,0ECJN50401,0.1539,0.155,0.1399,0.1263,0.6973,0.698,0.0233,0.0222,0.7391,0.7195,0.3023,0.3017,0.405,0.8525,2.777,5.1602,1.0808,2.5161,2.8274,2.9922,2.608,2.923,2.1201,2.4221,623.2350475116187,523.4161577514586,453.5357202154199,623.5809381183982,520.00001326365,452.53956127768106,0.0001299762549684896,-8.370615579107631e-07,-0.0003493084463535621,1.1337358711507753e-06,-0.0064345652911218945,5.2733178226189325e-06,0.0021819838568383305,2.6018697105655767e-06,-0.0002010853857846709,-8.120083204208637e-07,-0.001241418989065116,-2.087145506202326e-06,-0.00029597680291819427,-3.9084079760154184e-07,0.002306736044632527,6.508088993936714e-06,0.001044791220919012,-3.889004813651093e-06)
TRIPLET(131,202447,132,0ECM900618,0.1537,0.1548,0.1373,0.1251,0.697,0.6978,0.0236,0.0224,0.7383,0.7188,0.3026,0.3019,0.4105,0.8683,2.6865,5.0274,1.117,2.5621,2.8658,3.0165,2.6069,2.9198,2.1312,2.4381,623.0571483010252,522.9119260627394,453.74300271511225,623.4649735019518,520.00001326365,452.72528564973686,0.00013082736759757754,-8.314495037963557e-07,-0.00035001362638561166,1.0880723994646062e-06,-0.0064258878579647296,5.2833154616142894e-06,0.0022182733388781983,2.6385259405231164e-06,-0.00019345961341484747,-8.230776144854821e-07,-0.00122410228196805,-2.1547965448428125e-06,-0.00031475873856286326,-3.652161079080786e-07,0.002515444242713173,6.736860639124545e-06,0.001283536593891521,-3.593047190216563e-06)
TRIPLET(132,202447,133,0ECLIA0518,0.1542,0.1553,0.1433,0.1301,0.6966,0.6973,0.0229,0.0219,0.7423,0.7258,0.303,0.3023,0.4026,0.8474,2.7886,5.216,1.1193,2.5901,2.8158,2.9757,2.5964,2.9116,2.1297,2.4382,622.8350151847785,524.2360925663769,453.2395236104917,623.2350475116187,520.7677760961143,452.26062195118374,0.0001332969679449635,-8.383468390818546e-07,-0.00035368547985800464,1.0780807631714866e-06,-0.006420527904747173,5.156286900365701e-06,0.002127305543770747,2.5985531222377477e-06,-0.0002138109269735831,-8.038082111277572e-07,-0.0012680888537006604,-2.0293686671091313e-06,-0.0002888967853341923,-3.802137284421902e-07,0.0022348334103353892,6.213652480919408e-06,0.0009772291414055327,-4.221121376114065e-06)
TRIPLET(133,202447,134,0ECJPU0301,0.154,0.1551,0.1394,0.1258,0.6968,0.6975,0.0231,0.0221,0.7385,0.7189,0.303,0.3023,0.4013,0.8493,2.7614,5.1429,1.1024,2.5566,2.8526,3.0128,2.6214,2.9457,2.1397,2.4606,622.8270924030855,523.2864257005626,453.41685591193294,623.2262369903721,520.00001326365,452.44663414036876,0.00013246422284012038,-8.294917887622256e-07,-0.00035198944277234665,1.0469447360231746e-06,-0.006416753144505236,5.243070483044464e-06,0.0021868931486118018,2.553773175174757e-06,-0.00019879101093404046,-8.048411428704829e-07,-0.001238485320030327,-2.05117211531596e-06,-0.00030676781924487864,-3.539807257555057e-07,0.002434037409735402,6.412331479252437e-06,0.001206442777203779,-3.959642075567579e-06)
TRIPLET(134,202447,135,0ECKAY0703,0.1539,0.155,0.1356,0.1232,0.6969,0.6978,0.0233,0.0222,0.7371,0.7169,0.3027,0.302,0.4072,0.8634,2.7208,5.0895,1.1004,2.5442,2.859,3.0101,2.6134,2.9325,2.1278,2.4362,622.9976910754363,522.5322231552163,453.5357202154199,623.4022841735936,520.00001326365,452.53956127768106,0.00013176303394521498,-8.360101099173801e-07,-0.0003515413637550654,1.094578164217743e-06,-0.006425522008481101,5.222079475076871e-06,0.0022432292235473024,2.635318652571639e-06,-0.0001875391499001217,-8.260492452136383e-07,-0.001211877220599293,-2.177151259683345e-06,-0.00031040578788783064,-3.5634033568744704e-07,0.002472018700746285,6.531798660212035e-06,0.0012445880039175898,-3.822701889078133e-06)
TRIPLET(135,202447,136,0ECICJ0813,0.1544,0.1554,0.1435,0.1313,0.697,0.6976,0.0227,0.0216,0.743,0.7275,0.3029,0.3022,0.4041,0.8537,2.7201,5.1173,1.0849,2.5155,2.8503,3.0114,2.5874,2.8845,2.1311,2.4438,622.8775232635484,524.3200662880209,453.0619642855558,623.2851115333052,521.0932096314762,452.10451316388196,0.0001327224389389491,-8.36019426997937e-07,-0.000352780567719511,1.0765853847640766e-06,-0.006421156887048757,5.190704268330583e-06,0.002124233434223995,2.631057489279649e-06,-0.00021530397100916868,-8.086863069892479e-07,-0.001269951480634678,-2.0539269411891096e-06,-0.00030358092346165666,-3.285844821878435e-07,0.002408552873152921,6.068251289374659e-06,0.0011988272349064168,-4.333235357431871e-06)
TRIPLET(136,202447,137,0ECJET0520,0.1535,0.1546,0.1374,0.1242,0.6967,0.6975,0.0238,0.0226,0.7385,0.7187,0.3028,0.3022,0.4177,0.8767,2.7655,5.1477,1.1127,2.5798,2.826,2.9944,2.5836,2.8807,2.1347,2.4512,622.9476062506113,522.9439334742598,453.91977333286565,623.2895288683295,520.00001326365,452.91081911335084,0.00013165689246494444,-8.310127886014632e-07,-0.00035105388073883255,1.0701649307270575e-06,-0.006421733416481734,5.259181529203834e-06,0.0022235317016109615,2.7344531739182533e-06,-0.0001945113414266023,-8.394802933241976e-07,-0.001222602547640355,-2.2416707325467227e-06,-0.00029764980061432146,-4.2256980305082815e-07,0.0023139734206866405,6.877524364644284e-06,0.0010284436741193267,-3.49287318074826e-06)
TRIPLET(137,202447,138,0ECJET0108,0.1539,0.155,0.137,0.1239,0.6965,0.6973,0.0232,0.0221,0.7378,0.7176,0.3031,0.3024,0.4121,0.8626,2.7674,5.1493,1.0806,2.5023,2.8309,3.0073,2.5868,2.8867,2.1382,2.457,622.7804419790724,522.823357654069,453.5054451575055,623.1715555505127,520.00001326365,452.508031085015,0.0001330914022695182,-8.320130267707401e-07,-0.0003529759172294061,1.0484743098732055e-06,-0.006416049884119893,5.205630064485582e-06,0.0022310889666992454,2.728658988128204e-06,-0.00019260368853273415,-8.395925283502032e-07,-0.0012188467659450498,-2.244338237565044e-06,-0.0002973926738987266,-3.846388263325859e-07,0.002323894895423931,6.481509523692845e-06,0.0010675115075539227,-3.913119909341071e-06)
TRIPLET(138,202447,139,0ECM1F0206,0.1537,0.1548,0.1454,0.1321,0.6966,0.6973,0.0237,0.0225,0.7424,0.726,0.303,0.3023,0.4139,0.8735,2.7291,5.1096,1.1177,2.5892,2.8674,3.0224,2.5931,2.9032,2.133,2.4466,622.8350151847785,524.6076794383944,453.7732877646936,623.2350475116187,521.1126283726628,452.7568378144337,0.0001329947118171748,-8.353594729699535e-07,-0.00035308577813748,1.067977528809597e-06,-0.006419351613969056,5.186260257065133e-06,0.002101892594425779,2.5888221794202874e-06,-0.00021953048788467407,-7.986595798505961e-07,-0.0012803930288854382,-1.9955501952716755e-06,-0.00031567165632571796,-3.658507523603268e-07,0.0025249611361061845,6.767276308126464e-06,0.0012930617955754196,-3.5582209237386185e-06)
TRIPLET(139,202447,140,0ECLMW0511,0.153,0.1542,0.1449,0.1315,0.6969,0.6977,0.0244,0.0232,0.7426,0.7263,0.3026,0.302,0.4179,0.8808,2.7871,5.2159,1.083,2.5121,2.8293,2.9843,2.592,2.9088,2.1249,2.4307,623.0615620161075,524.5346129755349,454.37429026639455,623.4066843302342,521.0359200588601,453.3303591007478,0.00013135806172113028,-8.370425903222231e-07,-0.0003510909692270799,1.1076501721345509e-06,-0.006428250628454654,5.228346906723611e-06,0.0021074555344173223,2.59808849594793e-06,-0.00021844831131164396,-8.009520584828388e-07,-0.0012777791206059173,-2.009022677590541e-06,-0.00030189312079902564,-4.547084222283799e-07,0.002348465364764409,7.318460737026517e-06,0.001040437453704298,-3.013661175539549e-06)
TRIPLET(140,202447,141,0ECKSI0412,0.1544,0.1554,0.1466,0.1333,0.6969,0.6976,0.0226,0.0216,0.7419,0.7253,0.303,0.3023,0.4013,0.8502,2.6842,5.0088,1.1043,2.5508,2.8475,3.009,2.5997,2.908,2.1301,2.4396,622.8231238400823,524.7826729401287,453.03169222260203,623.2218333397777,521.2596346140207,452.10451316388196,0.00013338517997287265,-8.382812743469918e-07,-0.00035379475977753624,1.076075409651336e-06,-0.006420069769624265,5.153849216518408e-06,0.002087286257878568,2.5499571874048826e-06,-0.00022202596692968857,-7.902665956761829e-07,-0.0012870943191959441,-1.947813790508298e-06,-0.00030212014774889484,-3.2926100307884147e-07,0.0023927599155410106,6.03694778115226e-06,0.0011817145601473317,-4.37056596210042e-06)
TRIPLET(141,202447,142,0ECM5A0610,0.1542,0.1552,0.1365,0.1243,0.6969,0.6976,0.0229,0.0219,0.7395,0.7209,0.3029,0.3022,0.4053,0.8585,2.7027,5.0559,1.0995,2.5503,2.8596,3.0116,2.5927,2.8927,2.1343,2.4522,622.8814782279493,522.8628908380538,453.2395236104917,623.2851115333052,520.00001326365,452.32212005834464,0.0001323878182824804,-8.330239602603021e-07,-0.00035213851669343445,1.0670479698176163e-06,-0.006420121192276744,5.2217884461163175e-06,0.0022263625727255254,2.7013421773115335e-06,-0.00019306035208314869,-8.344693380884078e-07,-0.0012208509921541322,-2.216354037512784e-06,-0.0003088964543743846,-3.32393467941008e-07,0.002463927724822179,6.246515879111152e-06,0.0012541626570807748,-4.129220486990784e-06)
TRIPLET(142,202447,143,0ECKSI0203,0.154,0.155,0.1449,0.1326,0.6973,0.6981,0.0231,0.0221,0.744,0.7288,0.3023,0.3017,0.4032,0.8582,2.687,5.057,1.1013,2.5616,2.8624,3.0103,2.5821,2.8742,2.1217,2.4264,623.2350475116187,524.633383694467,453.41685591193294,623.5765224137052,521.4068746463221,452.508031085015,0.00012982970654289505,-8.356131379777198e-07,-0.0003490176818830047,1.1288373332783434e-06,-0.006433994968320383,5.28785035920048e-06,0.002103620151277582,2.6334367613936043e-06,-0.000220187783910043,-8.061876929225703e-07,-0.0012800462384091223,-2.0352326269126907e-06,-0.00031124263103925946,-3.432812154150583e-07,0.0024852959549858736,6.4196844770213664e-06,0.0012684050706653627,-3.939079776174698e-06)
TRIPLET(143,202447,144,0ECK8F0410,0.1541,0.1551,0.1386,0.1262,0.697,0.6978,0.0231,0.022,0.7393,0.7206,0.3027,0.302,0.4022,0.8504,2.6881,5.0409,1.1194,2.5856,2.85,3.0056,2.6007,2.9095,2.1386,2.4578,622.993725490559,523.2073881408824,453.35849700008356,623.4022841735936,520.00001326365,452.41509992157165,0.00013081546738381552,-8.263321670888715e-07,-0.0003496393881869401,1.0612526754994622e-06,-0.006421567096909846,5.3181495703705566e-06,0.0021992237164120496,2.6458233608123666e-06,-0.00019809430559097218,-8.21601210955648e-07,-0.0012334880814156397,-2.141856870878531e-06,-0.0003052292646141179,-3.52230244308097e-07,0.002418225730632592,6.354083398209963e-06,0.0011911428265963635,-4.025738050318513e-06)
TRIPLET(144,202447,145,0ECKPR0313,0.154,0.155,0.1386,0.127,0.697,0.6976,0.0232,0.0221,0.7429,0.7272,0.3028,0.3021,0.4078,0.8564,2.7268,5.1759,1.1148,2.5663,2.8258,3.0006,2.5781,2.8726,2.1303,2.4383,622.9357003143722,523.4677369269542,453.44713336833604,623.3482088450268,520.3713705319954,452.508031085015,0.0001321849029685855,-8.352928475421352e-07,-0.0003520356773617045,1.0828542328252695e-06,-0.0064229858625551774,5.213138786277629e-06,0.0021879830645169115,2.7243021131874855e-06,-0.00020259446206339978,-8.328434056223692e-07,-0.0012398526691457523,-2.197307779152514e-06,-0.00029471286935698693,-3.8562151736046184e-07,0.002295008843309387,6.421431135905858e-06,0.001036403929709731,-3.984412403514487e-06)
TRIPLET(145,202447,146,0ECMZ20806,0.1543,0.1553,0.1448,0.1316,0.6967,0.6976,0.0228,0.0218,0.7428,0.7267,0.3029,0.3021,0.4006,0.8467,2.7861,5.2184,1.1059,2.5556,2.818,2.9753,2.5917,2.9064,2.1349,2.4497,622.889401436803,524.5313290089367,453.150767759369,623.3482088450268,521.0825843772682,452.22909530497844,0.00013224967558293066,-8.322832178712048e-07,-0.00035190823262488724,1.0657312116060526e-06,-0.006420117575294014,5.231283136366164e-06,0.00210778663590375,2.599558405192913e-06,-0.00021840575918460181,-8.012384892986272e-07,-0.0012776337738674886,-2.010605664393817e-06,-0.0002893669653596283,-3.708323686303183e-07,0.0022429755642616213,6.12968275160015e-06,0.0009928713441713713,-4.30873144135928e-06)
TRIPLET(146,202447,147,0ECLSM0209,0.1533,0.1545,0.1349,0.1224,0.6968,0.6976,0.0241,0.0229,0.7363,0.7156,0.3027,0.3021,0.4172,0.8818,2.6483,4.9583,1.115,2.5631,2.8679,3.0193,2.6037,2.9142,2.1318,2.4397,623.001849756772,522.3543432453527,454.12122012721716,623.3482088450268,520.00001326365,453.0639370276687,0.0001313530002191924,-8.32285353024903e-07,-0.0003507508130513295,1.0826048552473497e-06,-0.0064242065582385596,5.260533923557236e-06,0.002259044344817372,2.6874003778291757e-06,-0.00018507516540571586,-8.367700020006872e-07,-0.00120473275249105,-2.2373438339158686e-06,-0.0003179947484808279,-3.9266496157363773e-07,0.002540767001794647,7.1032925311711095e-06,0.0012894323365074956,-3.195635752931797e-06)
TRIPLET(147,202447,148,0ECI5W0210,0.1536,0.1548,0.1354,0.1235,0.6968,0.6976,0.0237,0.0225,0.7389,0.7195,0.3027,0.302,0.4142,0.8746,2.6825,5.0204,1.1038,2.5614,2.8682,3.02,2.6062,2.9149,2.1269,2.4348,623.001849756772,522.6308895169717,453.8314170616765,623.4111040503278,520.00001326365,452.7568378144337,0.00013180180477257564,-8.367211390698469e-07,-0.00035164127924241156,1.097606627481672e-06,-0.006425953171818186,5.216028030276256e-06,0.002238527620157968,2.6593218997051566e-06,-0.00018921145464152137,-8.293107635297874e-07,-0.001214441046674712,-2.1928412958812742e-06,-0.00031638692431434304,-3.695483939364789e-07,0.0025313492753256863,6.823952335220892e-06,0.0012969853982999283,-3.4961402903704326e-06)
TRIPLET(148,202447,149,0ECLLI0109,0.1542,0.1552,0.1392,0.1265,0.6969,0.6977,0.023,0.0219,0.7409,0.7234,0.3027,0.302,0.4012,0.8435,2.7833,5.2203,1.1024,2.5615,2.8183,2.9733,2.5751,2.8682,2.1284,2.4386,622.9976910754363,523.4262213163349,453.269794769221,623.4066843302342,520.0081211239379,452.32212005834464,0.00013170807828561705,-8.354669524424894e-07,-0.0003514323270786063,1.0927412125155819e-06,-0.006425308137430534,5.2275291762949524e-06,0.002191912361565693,2.7395523478869435e-06,-0.00020203726998219748,-8.3588432163315e-07,-0.0012381033507491135,-2.2142278328657897e-06,-0.00029022057156839645,-3.798646724771842e-07,0.0022490571945264857,6.244730025092174e-06,0.0009924450289110105,-4.184421169168743e-06)
TRIPLET(149,202447,150,0ECJBU0506,0.1534,0.1544,0.135,0.1231,0.6966,0.6974,0.0239,0.0228,0.7382,0.719,0.303,0.3023,0.4062,0.8667,2.6251,4.9225,1.098,2.5383,2.8745,3.0173,2.5942,2.8912,2.1307,2.4405,622.8350151847785,522.511437695725,454.0077409373861,623.2306448187245,520.00001326365,453.09223229082085,0.00013320537517896692,-8.374415766237028e-07,-0.00035350375206390623,1.0750191770012175e-06,-0.006420171452996228,5.165369735729164e-06,0.002250923150837059,2.7173618833891773e-06,-0.00018769007422017575,-8.405256200272406e-07,-0.001209033202257319,-2.2546646001672705e-06,-0.00032032517665155666,-3.765355888811485e-07,0.0025709858978725086,6.998774202356217e-06,0.0013333768844446675,-3.299703755090643e-06)
TRIPLET(150,202447,151,0ECJKE0608,0.1536,0.1547,0.1365,0.1238,0.6976,0.6982,0.0236,0.0225,0.738,0.718,0.3022,0.3016,0.4058,0.8599,2.6994,5.0311,1.0818,2.5168,2.8633,3.022,2.5798,2.8694,2.1187,2.4216,623.2851115333052,522.7523270614173,453.80113607150946,623.6342155694762,520.00001326365,452.8180763481897,0.00012957885465126432,-8.370804544848315e-07,-0.00034879674484881475,1.14130901488749e-06,-0.006436392846449016,5.286160742487585e-06,0.0022384159251876623,2.7626014275704977e-06,-0.00019169572277479284,-8.461620160253857e-07,-0.0012156461424340783,-2.2805715132031195e-06,-0.0003139672066121363,-3.7251696504054774e-07,0.00250457200528759,6.791064572774855e-06,0.0012665952634653248,-3.537886378307611e-06)
TRIPLET(151,202447,152,0ECIAT0209,0.1537,0.1548,0.1443,0.1311,0.6965,0.6974,0.0236,0.0225,0.7415,0.7244,0.303,0.3023,0.4148,0.8754,2.7061,5.0527,1.1104,2.5651,2.8648,3.0226,2.6019,2.9111,2.1322,2.4438,622.838982512759,524.3524689055284,453.74300271511225,623.2306448187245,520.8262640327644,452.7568378144337,0.00013302633241748924,-8.359847477483282e-07,-0.00035317044909023655,1.0706872702675645e-06,-0.006419742054286695,5.181019405302272e-06,0.0021172324328367033,2.5680365501758377e-06,-0.00021544351981243266,-7.974135750897821e-07,-0.0012726689590364937,-1.993289101421848e-06,-0.000314302125114457,-3.6630789467751226e-07,0.002510213778912102,6.736110333229757e-06,0.0012772139108852346,-3.5951453840321644e-06)
TRIPLET(152,202447,153,0ECJJ50110,0.1535,0.1546,0.1408,0.127,0.697,0.6977,0.0238,0.0227,0.7397,0.7209,0.3027,0.302,0.405,0.8618,2.6991,5.0196,1.1001,2.5509,2.8607,3.0164,2.5809,2.8747,2.1251,2.4311,622.993725490559,523.6154631537182,453.91977333286565,623.4066843302342,520.00001326365,452.94237210214044,0.00013205196972476926,-8.385532102739205e-07,-0.00035209271340726813,1.1025840887981034e-06,-0.006426379195547592,5.195531292963783e-06,0.0021765494935549806,2.7031456767932697e-06,-0.0002047684217654858,-8.277868505240763e-07,-0.0012452015434797803,-2.1678219339631074e-06,-0.0003134942872740172,-3.8468480215148975e-07,0.0024954705145837086,6.9035599791934505e-06,0.0012478407744373858,-3.4200658553469405e-06)
TRIPLET(153,202447,154,0ECJLA0510,0.1536,0.1547,0.1372,0.1243,0.6976,0.6983,0.0236,0.0225,0.7372,0.7167,0.3022,0.3015,0.4083,0.859,2.6973,5.0193,1.1178,2.5617,2.8305,2.9943,2.5886,2.8861,2.1322,2.4414,623.2851115333052,522.8133965208007,453.80113607150946,623.6917034734264,520.00001326365,452.8180763481897,0.00012834235231031055,-8.248594112997817e-07,-0.0003463434196284866,1.099977601588848e-06,-0.00643158074781127,5.408779019894362e-06,0.0022312163984131955,2.721724007319378e-06,-0.00019240879028929427,-8.384778039360705e-07,-0.0012187072677195142,-2.238567897587264e-06,-0.0002989902855044125,-4.0832757107796317e-07,0.0023330127926125474,6.766454539425787e-06,0.0010592112608592032,-3.6067071354592925e-06)
TRIPLET(154,202447,155,0ECJKK0505,0.1538,0.1549,0.1376,0.1244,0.6972,0.698,0.0234,0.0223,0.7379,0.7182,0.3024,0.3017,0.4042,0.8519,2.7086,5.0402,1.1072,2.5238,2.8442,3.0029,2.5792,2.8702,2.136,2.4448,623.1759534640657,522.9341072622138,453.62424516763923,623.5809381183982,520.00001326365,452.6324510183392,0.00012914036786797076,-8.241415418420699e-07,-0.0003473232796509504,1.0811768670522416e-06,-0.006427329560311481,5.387565969734658e-06,0.002225655693994322,2.7535763686182705e-06,-0.00019446909129172495,-8.429008560106391e-07,-0.001221778148552796,-2.2600703880419937e-06,-0.0003041808882467119,-3.7946005176607265e-07,0.0023979639492054568,6.60609179324343e-06,0.0011492845018622778,-3.7617689926652414e-06)
TRIPLET(155,202447,156,0ECICB0309,0.1543,0.1553,0.1436,0.1312,0.697,0.6978,0.0229,0.0218,0.7423,0.7257,0.3025,0.3019,0.4055,0.8589,2.6978,5.06,1.0951,2.5485,2.8609,3.0157,2.6003,2.9096,2.1249,2.4332,623.1210610789501,524.2878897395444,453.18103990740934,623.4649735019518,520.9410554934514,452.22909530497844,0.00013073337152184772,-8.355588332429652e-07,-0.0003501804661298461,1.111556547159945e-06,-0.006429829524104908,5.258722611951321e-06,0.002122352322792737,2.5788658653349432e-06,-0.00021450229622938828,-7.998992564385589e-07,-0.0012702888638768802,-2.007645663224559e-06,-0.0003091379408657574,-3.263752049759376e-07,0.00246851012352213,6.191073608284345e-06,0.0012635236058217564,-4.187263176271844e-06)
TRIPLET(156,202447,157,0ECJB90320,0.1533,0.1546,0.1364,0.124,0.697,0.6978,0.024,0.0227,0.738,0.7187,0.3026,0.3019,0.41,0.8626,2.6526,4.9693,1.0938,2.5362,2.8699,3.0143,2.5869,2.8808,2.1265,2.435,623.0571483010252,522.7352046241969,454.09222882960137,623.4649735019518,520.00001326365,452.94237210214044,0.00013125785359776145,-8.357042373496695e-07,-0.00035086774701787403,1.1024618544648745e-06,-0.006427563181194167,5.240626135406002e-06,0.00223733874315221,2.733838507082694e-06,-0.00019126340161113806,-8.413137806271962e-07,-0.0012158518554106234,-2.25502509460515e-06,-0.0003187334283839998,-3.8820162057806134e-07,0.0025501288261483446,7.076826011404757e-06,0.0013026435427281324,-3.22156418565716e-06)
TRIPLET(157,202447,158,0ECL4R0509,0.1532,0.1544,0.1427,0.13,0.6965,0.6974,0.0241,0.0229,0.7431,0.7272,0.3029,0.3023,0.4164,0.8747,2.7571,5.1804,1.1119,2.5691,2.8181,2.9746,2.5754,2.8728,2.1299,2.4387,622.8973470238635,524.189294521815,454.176656157667,623.2306448187245,520.8567529375292,453.1225079615919,0.0001326242174205813,-8.366113871915286e-07,-0.0003526952817537534,1.081560805175639e-06,-0.006422110681955394,5.189925373194359e-06,0.002137435669024645,2.689816576207318e-06,-0.00021361079300348055,-8.201315927088489e-07,-0.0012641576243977348,-2.1171726660200624e-06,-0.000295589160714999,-4.513952252535114e-07,0.002282391566936685,7.1194049575994216e-06,0.0009734807451811239,-3.242522296450588e-06)
TRIPLET(158,202447,159,0ECKM60118,0.1539,0.1549,0.1435,0.1303,0.6973,0.6981,0.0232,0.0222,0.7428,0.7269,0.3024,0.3017,0.4049,0.8575,2.7573,5.1799,1.0914,2.5396,2.8368,2.9903,2.5829,2.8909,2.1222,2.4267,623.1715555505127,524.3059469525479,453.5054451575055,623.5765224137052,520.8833721911103,452.6009050782737,0.0001304505224381612,-8.367438366746318e-07,-0.000349898423662996,1.1231380138445825e-06,-0.006432131889332492,5.259977600881027e-06,0.002126695729262335,2.6508738374577563e-06,-0.0002151989951597153,-8.122674547461394e-07,-0.0012689695643997808,-2.0732561660693277e-06,-0.00030008669324432325,-3.781972843929292e-07,0.002354754631850234,6.485936328472098e-06,0.0011048153372909993,-3.900740565829031e-06)
TRIPLET(159,202447,160,0ECJ800516,0.1539,0.155,0.1356,0.1237,0.6964,0.6974,0.0233,0.0222,0.7376,0.7183,0.3029,0.3022,0.4091,0.8652,2.6781,5.0137,1.1052,2.555,2.87,3.0245,2.6101,2.922,2.1372,2.4549,622.9013083740905,522.5691260909722,453.5357202154199,623.293937503014,520.00001326365,452.53956127768106,0.0001319139993777159,-8.299041851290223e-07,-0.0003513080490507646,1.0594713061886246e-06,-0.00641961370446185,5.258252436088332e-06,0.0022416671773449496,2.64684861738491e-06,-0.00018817936705335382,-8.277134526362863e-07,-0.0012127686234007999,-2.185387878106338e-06,-0.00031542853582029913,-3.4433068122367943e-07,0.002529553802558036,6.54005202505471e-06,0.0013141375169867138,-3.799621757106533e-06)
TRIPLET(160,202447,161,0ECJSJ0210,0.1539,0.155,0.1447,0.1317,0.697,0.6977,0.0232,0.0222,0.7418,0.725,0.3026,0.3019,0.4084,0.8589,2.6946,5.0342,1.0983,2.5495,2.8281,2.9954,2.5892,2.8871,2.1298,2.4405,623.0571483010252,524.443208710928,453.5054451575055,623.4693808272704,520.9707971563759,452.53956127768106,0.00013095559746997276,-8.327168712377685e-07,-0.0003502680452973494,1.0923586201029841e-06,-0.006426386890416052,5.270599492105435e-06,0.002114875379237449,2.6156670610873105e-06,-0.00021712912405579319,-8.048621216170419e-07,-0.001274350833622029,-2.0314313226351634e-06,-0.00029611415624318906,-3.8769582928699945e-07,0.00230924959678094,6.479408667187437e-06,0.0010498079951363273,-3.918994852024752e-06)
TRIPLET(161,202447,162,0ECMZ20505,0.1539,0.155,0.1467,0.1333,0.6968,0.6975,0.0233,0.0223,0.7436,0.7284,0.3029,0.3022,0.4068,0.8578,2.7906,5.228,1.1141,2.5772,2.8172,2.9747,2.5863,2.8941,2.1358,2.4526,622.8854397517534,524.9203678093519,453.5357202154199,623.2895288683295,521.4939363305024,452.57111332358465,0.00013220883645998052,-8.315672761265007e-07,-0.0003518053025399972,1.0627156820142767e-06,-0.006419691639544802,5.23743515251756e-06,0.0020818095041265374,2.597547882130537e-06,-0.00022444118980193998,-7.972716817994556e-07,-0.0012902995215290202,-1.9827866044108364e-06,-0.00029131934574445103,-4.0197702264976236e-07,0.0022533853138616312,6.50043587380987e-06,0.0009802998542549173,-3.910406390570213e-06)
TRIPLET(162,202447,163,0ECJKE0708,0.1535,0.1546,0.1372,0.1241,0.6971,0.6978,0.0238,0.0226,0.7383,0.7186,0.3027,0.302,0.4066,0.8615,2.7025,5.0281,1.1051,2.5679,2.8662,3.0282,2.5772,2.866,2.1241,2.4305,622.989757323568,522.8946948655218,453.91977333286565,623.4022841735936,520.00001326365,452.91081911335084,0.00013218522491215368,-8.395574288430308e-07,-0.00035233516532310797,1.1053851473619008e-06,-0.006426630346117273,5.18442261273736e-06,0.0022291115309625736,2.764488682018731e-06,-0.00019391952831976594,-8.451670180231087e-07,-0.0012202117600172279,-2.2728250391886414e-06,-0.0003160056612402514,-3.7867997491960616e-07,0.002524238065489584,6.907686661614788e-06,0.0012826155309719478,-3.40852578936114e-06)
TRIPLET(163,202447,164,0ECM9I0210,0.1542,0.1553,0.1367,0.1248,0.6968,0.6976,0.023,0.0218,0.7398,0.7215,0.3029,0.3022,0.406,0.8582,2.673,5.0121,1.113,2.5725,2.8537,3.0128,2.5947,2.8954,2.14,2.4608,622.8854397517534,522.9192879062417,453.269794769221,623.2851115333052,520.00001326365,452.22909530497844,0.00013182414684279493,-8.277651738022627e-07,-0.000351042045804784,1.049857020099143e-06,-0.006418194542190836,5.275583061044114e-06,0.0022216963407819907,2.689350907042548e-06,-0.00019386768358175283,-8.318574354689533e-07,-0.0012229965605330877,-2.201465158172278e-06,-0.0003063846876419766,-3.412154208392422e-07,0.002434215613084302,6.271290853767692e-06,0.0012162680073334667,-4.110145108096502e-06)
TRIPLET(164,202447,165,0ECJ800208,0.1541,0.1551,0.1369,0.1252,0.6967,0.6975,0.0231,0.022,0.739,0.7202,0.3028,0.3022,0.4046,0.8552,2.6872,5.0367,1.0998,2.5529,2.8657,3.0208,2.6071,2.9157,2.1325,2.4458,622.9476062506113,522.8947290405905,453.35849700008356,623.2895288683295,520.00001326365,452.41509992157165,0.00013185839655013694,-8.330043660093973e-07,-0.00035145368188584905,1.0769004203016522e-06,-0.006422517610333812,5.239199291404209e-06,0.002219434151457391,2.6387775242491567e-06,-0.00019319376406054696,-8.232812895308656e-07,-0.0012235381029257646,-2.156177232033043e-06,-0.0003123980957540954,-3.350891920279929e-07,0.0025003440123093634,6.365863200758145e-06,0.0012904089497950237,-3.992796407413594e-06)
TRIPLET(165,202447,166,0ECJA70104,0.154,0.1551,0.1391,0.1265,0.6965,0.6973,0.0232,0.0221,0.7401,0.722,0.3031,0.3023,0.4036,0.8546,2.6623,4.9802,1.1177,2.5779,2.8579,3.0073,2.5869,2.8826,2.1387,2.4579,622.7804419790724,523.3511013495613,453.44713336833604,623.2350475116187,520.00001326365,452.44663414036876,0.0001330456058865199,-8.315603955416638e-07,-0.00035288505333235686,1.0469435167880701e-06,-0.006415871658244421,5.2101714821673155e-06,0.0021934475026385413,2.694713464111385e-06,-0.00020061058218517105,-8.287765638951432e-07,-0.0012368540260457015,-2.1776338918314775e-06,-0.0003093701610508263,-3.505751620616504e-07,0.0024629067313236778,6.445515955128573e-06,0.0012393620542114486,-3.917060382033727e-06)
TRIPLET(166,202447,167,0ECI430409,0.1533,0.1545,0.1362,0.1237,0.6967,0.6975,0.0241,0.0229,0.7382,0.7187,0.3027,0.3021,0.415,0.8751,2.6503,4.9505,1.1031,2.5613,2.8738,3.0268,2.6054,2.9168,2.1294,2.4402,623.0062421338827,522.7157414959735,454.12122012721716,623.3526184885561,520.00001326365,453.0639370276687,0.00013152670658614203,-8.343484480793587e-07,-0.00035111974402682637,1.0902410409216048e-06,-0.006425178600665158,5.240977533035425e-06,0.0022327395933740405,2.6572951008554325e-06,-0.00019051864631539637,-8.281690661955064e-07,-0.001217245543914083,-2.185300020720492e-06,-0.0003206887678264246,-3.862234196339806e-07,0.00257162673822095,7.107719335950363e-06,0.0013267361662445687,-3.1832564094197567e-06)
TRIPLET(167,202447,168,0ECLHE0706,0.1541,0.1551,0.1453,0.1322,0.6977,0.6985,0.0231,0.022,0.7431,0.7275,0.3018,0.3012,0.4076,0.861,2.7995,5.2456,1.1178,2.552,2.8241,2.9806,2.5914,2.9028,2.1388,2.452,623.5318846627109,524.6396681268351,453.35849700008356,623.8674015852085,521.2423431510621,452.41509992157165,0.00012514692940806117,-8.127307774810144e-07,-0.00034136769286563534,1.095972873591624e-06,-0.006435776656298473,5.5947093619222575e-06,0.002100163034196045,2.593937421114939e-06,-0.00022005725913487953,-7.992527164396746e-07,-0.0012812947910385653,-1.9981625256946645e-06,-0.000293402976300397,-3.8050752163642166e-07,0.0022827567181849234,6.3346504755349374e-06,0.001027385336733605,-4.080081270142553e-06)
TRIPLET(168,202447,169,0ECKNT0606,0.1532,0.1544,0.1467,0.1334,0.6972,0.698,0.0241,0.0229,0.7441,0.7291,0.3024,0.3018,0.4131,0.8688,2.7605,5.1861,1.1182,2.5596,2.817,2.9732,2.5716,2.8719,2.1425,2.4621,623.1759534640657,524.9555883848764,454.176656157667,623.5186451117542,521.5634804891762,453.1225079615919,0.00012854501488899302,-8.182573358640831e-07,-0.00034614204898931095,1.0612765569454882e-06,-0.006425012623930344,5.446604399597182e-06,0.0020840561242351082,2.6571138983421384e-06,-0.00022533278509394576,-8.07314261636705e-07,-0.0012898657621536176,-2.03570739919413e-06,-0.00029508688592175237,-4.525961906998877e-07,0.002276638056755511,7.1185796211151545e-06,0.0009665257938742157,-3.2448303096477477e-06)
TRIPLET(169,202447,170,0ECHYD0606,0.1533,0.1545,0.1462,0.1332,0.6967,0.6975,0.024,0.0228,0.7439,0.7286,0.3029,0.3022,0.4169,0.8791,2.7142,5.094,1.1188,2.5653,2.8643,3.0171,2.5993,2.9051,2.1332,2.4416,622.889401436803,524.8536216368472,454.09222882960137,623.2895288683295,521.492230646535,453.03364338318573,0.00013240538328512485,-8.338221640500629e-07,-0.00035221716987485446,1.0709359080955119e-06,-0.00642072354327062,5.215842316248272e-06,0.0020823596033780678,2.5471318735801096e-06,-0.00022311243874054173,-7.891151377162089e-07,-0.0012894691964062469,-1.9404590997465463e-06,-0.00031617639307292516,-3.94315626486888e-07,0.0025208382288623623,7.07262429839394e-06,0.0012672365178929418,-3.23331407102452e-06)
TRIPLET(170,202447,171,0ECJF50420,0.1541,0.1551,0.1376,0.1247,0.6966,0.6974,0.0231,0.022,0.7376,0.7172,0.3031,0.3024,0.4028,0.8508,2.7373,5.0947,1.1125,2.5749,2.8297,2.9931,2.5945,2.8976,2.1311,2.4428,622.7764890791112,522.9119205954107,453.35849700008356,623.1671524279715,520.00001326365,452.41509992157165,0.0001337832130384894,-8.385389656132259e-07,-0.00035432667506072837,1.0699520464232596e-06,-0.006418475795503551,5.139123882728548e-06,0.002222286079882127,2.6906597806851215e-06,-0.0001937607313825004,-8.321537929026613e-07,-0.0012227230921394694,-2.203171130151288e-06,-0.0002959600116114716,-3.74393515727595e-07,0.0023120473154709057,6.338852188545754e-06,0.0010627923615687956,-4.0683313847751935e-06)
TRIPLET(171,202447,172,0ECLKX0520,0.1537,0.1548,0.1376,0.125,0.6974,0.6982,0.0236,0.0224,0.7397,0.7213,0.3021,0.3016,0.4096,0.8601,2.7682,5.181,1.1073,2.5493,2.8147,2.9725,2.5855,2.8902,2.1386,2.4561,623.357035302104,523.0658813797,453.74300271511225,623.6342155694762,520.00001326365,452.72528564973686,0.00012700101942896913,-8.172721335507067e-07,-0.00034407972568364784,1.0851055616878561e-06,-0.006431208060208056,5.5036279832155806e-06,0.002214226414998739,2.7187181964487287e-06,-0.00019631593679263296,-8.356072295044278e-07,-0.001226972288398165,-2.2189351003591156e-06,-0.00029142579134930585,-4.210064118261243e-07,0.0022481675424785835,6.6985200079008455e-06,0.0009604474922704047,-3.700264894193723e-06)
TRIPLET(172,202447,173,0ECI4W0309,0.1539,0.155,0.1361,0.1236,0.6971,0.6979,0.0233,0.0222,0.7378,0.7177,0.3026,0.3019,0.4107,0.8665,2.6639,4.9772,1.0953,2.5459,2.8525,3.0067,2.6076,2.9206,2.1249,2.4325,623.0527597757919,522.6691379042147,453.5357202154199,623.4605597689591,520.00001326365,452.53956127768106,0.00013145047785332077,-8.372620960716867e-07,-0.0003512256682742097,1.1070722663643766e-06,-0.00642801704798661,5.22385315095003e-06,0.002235348881148791,2.6510061187531504e-06,-0.000189757926218034,-8.275074606753738e-07,-0.0012159010163430566,-2.182573582163061e-06,-0.00030743780047319037,-3.6343694968876386e-07,0.0024380206860393407,6.526921671895908e-06,0.0012034905643767413,-3.836340148879533e-06)
TRIPLET(173,202447,174,0ECN4U0219,0.1544,0.1554,0.1366,0.1246,0.6968,0.6975,0.0227,0.0217,0.7395,0.7211,0.3028,0.3021,0.4009,0.8437,2.7,5.0627,1.1073,2.5717,2.8177,2.9781,2.61,2.9337,2.1266,2.4342,622.943631654591,522.8800455129959,453.0619642855558,623.3526184885561,520.00001326365,452.13602822440146,0.00013244052379031597,-8.38444530947283e-07,-0.0003525866983750142,1.0947028290057224e-06,-0.00642451520387931,5.1835814357223644e-06,0.0022195421853020655,2.627517789766884e-06,-0.00019290047677772448,-8.214575593651076e-07,-0.0012233599012920434,-2.1467090569654972e-06,-0.00028869532504361404,-3.641767308713715e-07,0.002238039753238096,6.043791317204549e-06,0.000992707768901556,-4.401636475820432e-06)
TRIPLET(174,202447,175,0ECLUM0116,0.1533,0.1545,0.146,0.1332,0.6967,0.6974,0.024,0.0228,0.7431,0.7274,0.3031,0.3024,0.4192,0.8839,2.6876,5.0484,1.1078,2.5622,2.8696,3.0241,2.6075,2.9185,2.1337,2.4462,622.772537655011,524.7621263299919,454.09222882960137,623.1671524279715,521.4017199804108,453.03364338318573,0.0001335865584819926,-8.362838218073761e-07,-0.00035391465070446995,1.0617324940184575e-06,-0.006417444164067205,5.160721957459735e-06,0.0020862265922629774,2.518468768875371e-06,-0.00022152467539374708,-7.84975704241728e-07,-0.0012872611143285558,-1.9199668556667343e-06,-0.0003185964443494782,-3.8852915660889097e-07,0.002548559687008024,7.0766009196363206e-06,0.0013007467378262465,-3.2221936438018397e-06)
TRIPLET(175,202447,176,0ECM3E0207,0.1541,0.1552,0.1404,0.1278,0.6969,0.6976,0.023,0.0219,0.7408,0.723,0.3029,0.3021,0.4064,0.8577,2.6916,5.0496,1.1041,2.5493,2.8584,3.0149,2.5911,2.8929,2.1362,2.4539,622.8814782279493,523.6259374075842,453.32821848556557,623.3482088450268,520.1850680095978,452.32212005834464,0.0001322137920270869,-8.313039615898139e-07,-0.00035179323388464753,1.0612309560941038e-06,-0.006419443933949951,5.239045833306902e-06,0.002172502574143801,2.659596294174202e-06,-0.00020467962262026924,-8.201078390709796e-07,-0.0012466930586060604,-2.126714347216572e-06,-0.0003088825206807762,-3.406782460545066e-07,0.0024610137230042396,6.331177092357286e-06,0.0012448443274266328,-4.03957558806449e-06)
TRIPLET(176,202447,177,0ECNA30305,0.1539,0.1549,0.1431,0.1298,0.6967,0.6976,0.0234,0.0223,0.7418,0.725,0.3029,0.3022,0.4009,0.851,2.7549,5.1473,1.1114,2.5746,2.8463,2.9971,2.593,2.9038,2.1372,2.4561,622.889401436803,524.1662371555274,453.56599601375945,623.2851115333052,520.6585153595411,452.6324510183392,0.00013203901222113854,-8.302011142174559e-07,-0.00035149025869846097,1.0586895634144321e-06,-0.006419297736266843,5.2521736577021335e-06,0.0021333838779412553,2.6172853776860638e-06,-0.000212833350972907,-8.077187895287493e-07,-0.001265328659888698,-2.0514102389508856e-06,-0.00030478907763981555,-3.725868034594689e-07,0.0024067396110556746,6.551476030492282e-06,0.001163699019173542,-3.817889407116768e-06)
TRIPLET(177,202447,178,0ECKN50212,0.1538,0.155,0.1445,0.1314,0.6968,0.6975,0.0233,0.0222,0.7431,0.7271,0.303,0.3023,0.405,0.8525,2.7846,5.2331,1.1055,2.5568,2.8185,2.9716,2.577,2.8806,2.1302,2.4407,622.8270924030855,524.5003511507153,453.5939806564536,623.2262369903721,521.0796341778359,452.53956127768106,0.00013333435411708785,-8.38091782114668e-07,-0.0003537158568162812,1.0760298046407377e-06,-0.006420139436139206,5.156783547091545e-06,0.0021147508186449985,2.6633296987802058e-06,-0.00021829269137570466,-8.126286069242992e-07,-0.0012749426379806542,-2.07184469858045e-06,-0.0002922637100321406,-4.0513908351995514e-07,0.00226239365684785,6.557613565019606e-06,0.0009873822388669906,-3.847140388678382e-06)
TRIPLET(178,202447,179,0ECN290510,0.1542,0.1552,0.1463,0.1339,0.6971,0.6978,0.0229,0.0219,0.7454,0.7314,0.3025,0.3018,0.4018,0.8477,2.7765,5.2674,1.0981,2.549,2.8161,2.9737,2.5776,2.8756,2.1262,2.4347,623.1166602778858,524.9766588068906,453.2395236104917,623.5274722684073,521.8208093192799,452.32212005834464,0.00013066050564193365,-8.344917369647077e-07,-0.00035001156463805426,1.1072875532034002e-06,-0.006429249355062277,5.268283582941964e-06,0.002080613102146902,2.6305495091858098e-06,-0.00022550681878035536,-8.024937059570601e-07,-0.0012912515264077132,-2.0096530463905564e-06,-0.0002890337693687143,-3.798861924113601e-07,0.00223640254947571,6.213877572687845e-06,0.0009791259463074187,-4.220491917969384e-06)
TRIPLET(179,202447,180,0ECJ9F0220,0.1536,0.1547,0.1413,0.1287,0.6964,0.6973,0.0236,0.0225,0.7409,0.7234,0.303,0.3023,0.407,0.867,2.6874,5.0382,1.1115,2.5582,2.8686,3.0147,2.5995,2.9073,2.1347,2.4474,622.8429386224767,523.7894558854355,453.80113607150946,623.2350475116187,520.3596784190725,452.8180763481897,0.00013275581467235442,-8.336229361700827e-07,-0.0003526555899934602,1.0632930408353793e-06,-0.006418955906133017,5.205746183045384e-06,0.002158131555152994,2.6138924917514576e-06,-0.00020695722780213153,-8.106309472962966e-07,-0.001253203226794193,-2.0733978321206e-06,-0.00031638725788868914,-3.667304951625511e-07,0.00253229346343325,6.795041194017234e-06,0.0013001054833986295,-3.5267659510849317e-06)
TRIPLET(180,202447,181,0ECI9D0419,0.1538,0.1549,0.1353,0.1228,0.6966,0.6975,0.0235,0.0223,0.7372,0.7174,0.3029,0.3022,0.4149,0.876,2.6477,4.9625,1.1126,2.5757,2.8677,3.0213,2.5909,2.8878,2.1305,2.4402,622.8933791442231,522.4886148509212,453.65452300273074,623.2895288683295,520.00001326365,452.6324510183392,0.0001326109211654329,-8.361671786617918e-07,-0.00035264696480176503,1.0794633447328262e-06,-0.006421791517348835,5.19334937624881e-06,0.002253617400360034,2.7326859481459255e-06,-0.00018742386074498417,-8.434056076684385e-07,-0.0012078879469910552,-2.270406129403635e-06,-0.00031509359709361046,-3.561839986471724e-07,0.0025220277263298153,6.6529322017153105e-06,0.0012972766021932397,-3.6809997781928785e-06)
TRIPLET(181,202447,182,0ECJ640116,0.1533,0.1545,0.1448,0.1327,0.6969,0.6977,0.0241,0.0229,0.7439,0.7287,0.3027,0.302,0.418,0.881,2.7103,5.102,1.0944,2.5416,2.8711,3.0246,2.6089,2.9181,2.1285,2.439,622.9976910754363,524.6089193952131,454.12122012721716,623.4066843302342,521.4160547129636,453.0639370276687,0.00013169891900901743,-8.353764261966742e-07,-0.00035141415429919655,1.0924350538985553e-06,-0.00642527249225544,5.228437459831294e-06,0.002096691717948013,2.5223152505117142e-06,-0.00021916551783943494,-7.870696730691395e-07,-0.0012821924288238782,-1.9337566779581928e-06,-0.00031945591151572787,-3.8917124391145064e-07,0.002557504485958066,7.105693510034433e-06,0.0013096649221276055,-3.188921532721876e-06)
TRIPLET(182,202447,183,0ECL4R0819,0.1536,0.1546,0.141,0.1287,0.6968,0.6976,0.0237,0.0226,0.7438,0.7282,0.3029,0.3022,0.4176,0.8779,2.7827,5.2538,1.1163,2.5882,2.8223,2.9909,2.5675,2.8555,2.1338,2.4478,622.8854397517534,523.9467595329543,453.8314170616765,623.2851115333052,520.7197944011889,452.91081911335084,0.0001323920219919737,-8.333778010428046e-07,-0.000352168758128194,1.0688388543548165e-06,-0.00642040454304669,5.219269481790631e-06,0.002157275929250412,2.738437771629348e-06,-0.0002101218454739643,-8.308509770826621e-07,-0.0012550085863180062,-2.1784675301655968e-06,-0.00029542836703249785,-4.1966140665347147e-07,0.0022912709868566517,6.789513294650093e-06,0.001006774248311488,-3.5924473865064726e-06)
TRIPLET(183,202447,184,0ECN060411,0.1532,0.1544,0.1428,0.1295,0.6971,0.6979,0.0241,0.023,0.7418,0.7246,0.3024,0.3018,0.418,0.8786,2.7695,5.1773,1.0836,2.5206,2.8194,2.9763,2.5978,2.9165,2.1242,2.4309,623.1803659497215,524.1145911967783,454.176656157667,623.5230655825276,520.5795445552112,453.1527960355205,0.00013017483511245018,-8.3471360254658e-07,-0.0003494001441736447,1.1175932829414103e-06,-0.006431652782806942,5.282641192693082e-06,0.00213551120527999,2.6003854973704845e-06,-0.000211932950160679,-8.052567802868393e-07,-0.0012641013327201237,-2.0391744905857414e-06,-0.00029618275819792727,-4.499759024532477e-07,0.0022891911698780746,7.120380355262647e-06,0.0009817002330892964,-3.239794644490308e-06)
TRIPLET(184,202447,185,0ECM6I0406,0.1534,0.1546,0.1354,0.1232,0.6967,0.6974,0.0239,0.0227,0.7373,0.717,0.3031,0.3024,0.4134,0.8733,2.6993,5.0488,1.115,2.5739,2.8662,3.0187,2.6125,2.9317,2.1333,2.4448,622.772537655011,522.5129809474071,454.0077409373861,623.1671524279715,520.00001326365,452.94237210214044,0.00013362319558839122,-8.366459267906368e-07,-0.0003539873418221093,1.0629571284865647e-06,-0.006417586744767583,5.1570888233143466e-06,0.002244891718555268,2.640324902725787e-06,-0.0001872689811446822,-8.270996871214767e-07,-0.001211120969473442,-2.1830801699155086e-06,-0.0003165352850297853,-3.8559741906744565e-07,0.002527573048323642,6.992546663429472e-06,0.0012808986154925137,-3.317118763760122e-06)
TRIPLET(185,202447,186,0ECHYM0207,0.1536,0.1547,0.1457,0.1325,0.6968,0.6977,0.0236,0.0226,0.7424,0.7257,0.3027,0.302,0.404,0.8647,2.7064,5.0553,1.1069,2.5711,2.8816,3.0236,2.5983,2.9048,2.1273,2.4368,623.001849756772,524.6601293662624,453.80113607150946,623.4066843302342,521.1564213832312,452.8496316579241,0.00013176516766617703,-8.363590340865862e-07,-0.0003515685881247722,1.096381993013564e-06,-0.006425810591117809,5.2196611644216415e-06,0.002096472205820445,2.5636278479382925e-06,-0.0002202001861793489,-7.937858144961194e-07,-0.00128275987103101,-1.968673711673216e-06,-0.0003223232327179701,-3.5253726715991664e-07,0.0026002894928471385,6.804795170649487e-06,0.001382300362480323,-3.4994894314821316e-06)
TRIPLET(186,202447,187,0ECKPR0220,0.1541,0.1551,0.1394,0.1283,0.6971,0.6978,0.023,0.022,0.7435,0.728,0.3027,0.302,0.4087,0.8593,2.6984,5.1279,1.0913,2.534,2.8254,2.9988,2.6018,2.9161,2.1272,2.4368,622.989757323568,523.6482902495984,453.32821848556557,623.4022841735936,520.6400468528582,452.41509992157165,0.00013190128733756427,-8.367511152227599e-07,-0.00035177180916140294,1.0958942302340636e-06,-0.006425525345689345,5.212579402364103e-06,0.0021674473511222336,2.6131901633486437e-06,-0.00020475895413014605,-8.118210561855768e-07,-0.0012486452403438362,-2.0821635825649146e-06,-0.00029381427688337115,-3.767072094458082e-07,0.002288408417568987,6.306416997829261e-06,0.0010361957882192609,-4.10881598397929e-06)
TRIPLET(187,202447,188,0ECJBU0409,0.1538,0.1549,0.1336,0.122,0.697,0.6977,0.0234,0.0223,0.738,0.7189,0.3027,0.302,0.4104,0.8676,2.6405,4.9689,1.096,2.5472,2.8676,3.0204,2.6048,2.9093,2.1286,2.4381,622.993725490559,522.2605235894981,453.62424516763923,623.4066843302342,520.00001326365,452.6324510183392,0.00013173139504378127,-8.353847916703894e-07,-0.00035145666612792386,1.0918685372021599e-06,-0.006425131614419288,5.227321216735911e-06,0.002265374370761854,2.6887355571320816e-06,-0.00018362458831619563,-8.378746634306048e-07,-0.001201655819112363,-2.2448416164508463e-06,-0.00031486564293941753,-3.539122413613315e-07,0.0025203568021504533,6.623648951181484e-06,0.0012972352842093235,-3.712671257380201e-06)
TRIPLET(188,202447,189,0ECI3C0120,0.1543,0.1553,0.1399,0.1273,0.6967,0.6974,0.0228,0.0218,0.74,0.7217,0.3029,0.3023,0.406,0.8605,2.6946,5.0462,1.1168,2.5941,2.8509,3.0057,2.6022,2.9131,2.1293,2.4391,622.889401436803,523.4815202624507,453.150767759369,623.2306448187245,520.0076920547984,452.22909530497844,0.00013276259507251148,-8.373526876368551e-07,-0.00035292590827183814,1.0828760941595634e-06,-0.006422113705099302,5.180419258330762e-06,0.0021792026103731026,2.6221025563073317e-06,-0.00020221824678337777,-8.149230559103981e-07,-0.0012430028427698253,-2.1015588064424428e-06,-0.0003043895478121927,-3.349125839159598e-07,0.002415057823316767,6.154367815538696e-06,0.001200887615078118,-4.239700864826039e-06)
TRIPLET(189,202447,190,0ECK9M0606,0.1541,0.1551,0.1371,0.125,0.6968,0.6976,0.023,0.022,0.7404,0.7222,0.3028,0.3022,0.4009,0.8546,2.7053,5.08,1.1086,2.5726,2.8654,3.0129,2.5908,2.8906,2.1313,2.4439,622.943631654591,523.0317174042963,453.32821848556557,623.2851115333052,520.00001326365,452.41509992157165,0.00013201003779013206,-8.341897973939691e-07,-0.00035173257774275175,1.0803133740054541e-06,-0.006422839880649871,5.226270761930652e-06,0.0022149461185876043,2.6986056103954065e-06,-0.00019566870678034277,-8.324233859084112e-07,-0.0012263967044570463,-2.202552073099123e-06,-0.0003120788148196197,-3.330357386684732e-07,0.0024976269696117184,6.336429233620807e-06,0.0012891031084706212,-4.02488823135529e-06)
TRIPLET(190,202447,191,0ECI250317,0.1535,0.1546,0.1344,0.1225,0.6967,0.6975,0.0238,0.0227,0.7374,0.7176,0.303,0.3024,0.4059,0.8582,2.6625,4.984,1.1143,2.5787,2.8606,3.0093,2.6087,2.9189,2.1314,2.443,622.8310453574378,522.3510171091119,453.91977333286565,623.1627501956018,520.00001326365,452.94237210214044,0.0001331829400964367,-8.369068904189003e-07,-0.0003534372921378034,1.0726154300662905e-06,-0.006419816591529468,5.169701027972079e-06,0.0022576634948411824,2.666590102035991e-06,-0.00018490323417681438,-8.331780044686669e-07,-0.0012051753805015536,-2.218256179188907e-06,-0.00031344862592917635,-3.8479398082843325e-07,0.0024949474682036017,6.903484948603972e-06,0.0012472085061367537,-3.4202756747285006e-06)
TRIPLET(191,202447,192,0ECJ800508,0.1541,0.1551,0.1367,0.1249,0.6967,0.6975,0.0231,0.022,0.738,0.719,0.3029,0.3022,0.4031,0.852,2.6382,4.9442,1.1059,2.5593,2.8689,3.0235,2.6115,2.9227,2.1338,2.4495,622.889401436803,522.7866184670803,453.35849700008356,623.2895288683295,520.00001326365,452.41509992157165,0.0001323504276255269,-8.332790065751722e-07,-0.00035210813319839547,1.06909895639335e-06,-0.0064205096722200535,5.221292017466353e-06,0.0022257148016172883,2.6271463028179596e-06,-0.00019144614198874561,-8.222614524536146e-07,-0.0012203408399514915,-2.152597057320121e-06,-0.0003138592587889953,-3.3159547436580624e-07,0.002517081496472782,6.368264179621468e-06,0.0013106415354151336,-3.986082187203673e-06)
TRIPLET(192,202447,193,0ECJBU0218,0.1541,0.1552,0.1359,0.1233,0.6968,0.6976,0.023,0.0219,0.7377,0.7182,0.3029,0.3021,0.4031,0.8525,2.6431,4.9525,1.1044,2.5606,2.8661,3.0199,2.5866,2.8803,2.1313,2.4443,622.8854397517534,522.6276274176009,453.32821848556557,623.3482088450268,520.00001326365,452.32212005834464,0.00013262100390696514,-8.35640957188184e-07,-0.0003526230776134399,1.076492819780491e-06,-0.00642129567242405,5.1965623933819684e-06,0.002245102194076743,2.7419336788570562e-06,-0.00018963803907650072,-8.437232085294951e-07,-0.0012121500935585688,-2.2697131669725795e-06,-0.0003123984442335039,-3.3227148792987e-07,0.002501288294272465,6.3369544477471585e-06,0.0012935289865750182,-4.02341949568437e-06)
TRIPLET(193,202447,194,0ECJ7N0516,0.1541,0.1552,0.1364,0.1246,0.6967,0.6976,0.0231,0.022,0.7384,0.7194,0.3028,0.3022,0.4026,0.8523,2.6692,4.9981,1.1142,2.5692,2.8671,3.0162,2.6052,2.9131,2.1429,2.468,622.9476062506113,522.7647155794979,453.35849700008356,623.2851115333052,520.00001326365,452.3536553110712,0.00013090583178377254,-8.235896364446183e-07,-0.00034956371282722585,1.0450599241308457e-06,-0.006418810512123992,5.333660779184246e-06,0.002229314221516958,2.6550248688063627e-06,-0.00019126676147588945,-8.273185361025715e-07,-0.0012188933255114776,-2.1799263507797846e-06,-0.00031303735458186425,-3.3356069055078613e-07,0.00250766666163086,6.366913629010849e-06,0.0012992607060038214,-3.989858936071753e-06)
TRIPLET(194,202447,195,0ECKLT0409,0.1531,0.1542,0.1442,0.1312,0.6968,0.6975,0.0244,0.0232,0.7436,0.7282,0.3029,0.3023,0.4081,0.8592,2.766,5.2016,1.1061,2.5642,2.891,3.0275,2.5719,2.8691,2.1302,2.4408,622.8854397517534,524.4835446324018,454.3189858008191,623.2262369903721,521.129290684818,453.3303591007478,0.0001327217559495614,-8.36636745892151e-07,-0.00035282297818694814,1.0798605645677883e-06,-0.006421687769350089,5.186571274482154e-06,0.0021175987590123105,2.6858393394997167e-06,-0.00021816150763066892,-8.167036196136585e-07,-0.0012738023624376165,-2.0938522569721533e-06,-0.00032973320070938924,-3.829962417630117e-07,0.0026690883066753154,7.3114038678714365e-06,0.001431626404976405,-2.9416694167219975e-06)
TRIPLET(195,202447,196,0ECLTD0211,0.153,0.1542,0.1394,0.127,0.6971,0.6977,0.0243,0.0231,0.7412,0.7237,0.3027,0.3021,0.418,0.8801,2.7246,5.1055,1.0937,2.545,2.868,3.0192,2.5939,2.8934,2.1267,2.4358,622.989757323568,523.4823213773848,454.3453110224926,623.3438062032577,520.1099211269458,453.30007321329265,0.00013194708372056256,-8.372037464518362e-07,-0.00035186267305845217,1.097425023319199e-06,-0.006425703571564818,5.20803798468237e-06,0.0021818312065603864,2.6569474709131866e-06,-0.00020243201524376535,-8.209818578308186e-07,-0.001242107118316203,-2.1338374443329632e-06,-0.0003193895868301216,-4.101774546536719e-07,0.002549785667591545,7.3195420714950906e-06,0.001285690890996137,-2.9625733702337218e-06)
TRIPLET(196,202447,197,0ECJ6B0508,0.1536,0.1547,0.1456,0.1332,0.6967,0.6975,0.0237,0.0225,0.743,0.7279,0.3029,0.3022,0.4124,0.8714,2.6565,4.9994,1.116,2.5671,2.8598,3.0169,2.615,2.9297,2.1325,2.442,622.889401436803,524.6850269109759,453.8314170616765,623.2895288683295,521.4394527934555,452.8180763481897,0.00013246949822132248,-8.344558477707693e-07,-0.0003523443793307234,1.0730790184147013e-06,-0.006420973059496281,5.209484331493846e-06,0.002089294176858361,2.4918341803967946e-06,-0.00022017239507691002,-7.810555861649822e-07,-0.0012854660872179244,-1.9003964645264178e-06,-0.0003125513713477309,-3.7871940279971953e-07,0.0024874133793967128,6.817649765704667e-06,0.0012438748610471423,-3.5137651184214726e-06)
TRIPLET(197,202447,198,0ECKSI0217,0.1539,0.1549,0.1463,0.1328,0.6972,0.6979,0.0233,0.0223,0.7418,0.7251,0.3027,0.302,0.4067,0.8673,2.6828,5.0102,1.0943,2.5355,2.865,3.0126,2.6011,2.911,2.1288,2.4399,622.9857914141784,524.7228587805024,453.5357202154199,623.3978745786332,521.1609903638717,452.6324510183392,0.00013179637763044034,-8.354015951017698e-07,-0.0003515417342649357,1.0907353129766008e-06,-0.00642484978161536,5.225087246642509e-06,0.0020910958444323767,2.547870862142649e-06,-0.00022108418845487174,-7.904594576863719e-07,-0.0012852103413200935,-1.9498682375302245e-06,-0.0003131454685782681,-3.497896150708464e-07,0.002503401483552695,6.536300495580767e-06,0.001282524101955295,-3.810112726184533e-06)
TRIPLET(198,202447,199,0ECL3M0610,0.1537,0.1547,0.142,0.1294,0.6969,0.6977,0.0235,0.0225,0.7429,0.7267,0.3028,0.3021,0.4112,0.865,2.7841,5.2342,1.1034,2.5651,2.823,2.9917,2.6049,2.9267,2.1254,2.4318,622.9396701312091,524.0551050948001,453.7127245505845,623.3438062032577,520.7211724929542,452.8180763481897,0.0001325920277785829,-8.396296363331083e-07,-0.0003528653941837583,1.098116640985709e-06,-0.006424837821097176,5.170659580145753e-06,0.0021374530258181043,2.5743137426833813e-06,-0.0002108576951934165,-8.012709012298331e-07,-0.0012628624383796807,-2.018951326414168e-06,-0.00029503338817829863,-4.095636197714011e-07,0.0022904325017387758,6.675539009084885e-06,0.0010135167179690825,-3.714311887646838e-06)
TRIPLET(199,202447,200,0ECM6Z0607,0.1532,0.1543,0.1369,0.1244,0.697,0.6976,0.0241,0.023,0.7381,0.7184,0.3029,0.3022,0.4039,0.8621,2.7036,5.0543,1.1065,2.5652,2.8714,3.0146,2.6129,2.9324,2.1301,2.4418,622.8775232635484,522.8283295236938,454.176656157667,623.2851115333052,520.00001326365,453.2113265159408,0.00013281403170494564,-8.369246894560888e-07,-0.00035296229551360936,1.0796469709343457e-06,-0.006421513338799701,5.181621432967117e-06,0.002222289299071465,2.618610554650128e-06,-0.0001920451649014489,-8.203876633722371e-07,-0.001221918887164297,-2.1418942379480627e-06,-0.0003199266575150503,-3.932029904427119e-07,0.0025611752875336243,7.159396261791656e-06,0.0013104797494160672,-3.1306885660791076e-06)
TRIPLET(200,202447,201,0ECKEF0307,0.1542,0.1552,0.1369,0.1247,0.6975,0.6982,0.0229,0.0219,0.7399,0.7216,0.3022,0.3016,0.4055,0.8573,2.7066,5.0668,1.0691,2.4873,2.8514,3.0124,2.5918,2.8913,2.1194,2.422,623.2895288683295,522.9610284422101,453.2395236104917,623.6342155694762,520.00001326365,452.32212005834464,0.0001294683614064886,-8.363366135313769e-07,-0.0003486019377362931,1.1394559220306506e-06,-0.006436260550742845,5.294773883208818e-06,0.0022196601173347275,2.6988918361282257e-06,-0.00019457160260305908,-8.331303921622547e-07,-0.0012240974102072015,-2.2075334541119194e-06,-0.00030515222409745364,-3.413461194503616e-07,0.0024210379216534194,6.240363370773884e-06,0.0012023166564292462,-4.1464256762787045e-06)
TRIPLET(201,202447,202,0ECIBD0107,0.1545,0.1555,0.1463,0.133,0.6965,0.6973,0.0226,0.0216,0.7417,0.7249,0.3031,0.3024,0.4018,0.8488,2.7056,5.0557,1.1192,2.5886,2.8565,3.0143,2.6121,2.9315,2.1391,2.4601,622.7804419790724,524.7157744529292,452.9719510658492,623.1715555505127,521.179196238478,452.0429068637268,0.00013300896878012128,-8.311982905584032e-07,-0.0003528123622147175,1.0457188823199621e-06,-0.006415729077544043,5.213804616312704e-06,0.00208804135771318,2.502073443059379e-06,-0.00022070947849757612,-7.825523166548092e-07,-0.0012861920741486779,-1.9078460976186733e-06,-0.0003058699870812343,-3.147371005249737e-07,0.002437569213568719,5.986069833698154e-06,0.0012397847104996182,-4.4137591775056715e-06)
TRIPLET(202,202447,203,0ECKW90109,0.1537,0.1548,0.1413,0.1285,0.6971,0.6978,0.0236,0.0224,0.7411,0.7233,0.3027,0.302,0.4086,0.8649,2.7056,5.0515,1.1168,2.5818,2.8653,3.0216,2.5943,2.8961,2.1401,2.4613,622.989757323568,523.8039509175072,453.74300271511225,623.4022841735936,520.3199321313899,452.72528564973686,0.00013071974065620846,-8.250732295126016e-07,-0.0003494275206175339,1.0563997686375843e-06,-0.006420927118102165,5.329747978552799e-06,0.002158781180711722,2.6348341225346375e-06,-0.00020730352229213764,-8.1414197854728e-07,-0.0012531192178151388,-2.091862270718642e-06,-0.00031453043183866025,-3.6576200129279565e-07,0.0025128290108126367,6.73648548617715e-06,0.0012803752523883778,-3.5940962871243637e-06)
TRIPLET(203,202447,204,0ECJM70312,0.1541,0.1552,0.1406,0.1272,0.697,0.6977,0.023,0.022,0.7388,0.7195,0.3025,0.302,0.4023,0.8505,2.7423,5.1032,1.0992,2.5562,2.8308,2.9942,2.6004,2.909,2.125,2.4306,623.1210610789501,523.5153530975155,453.32821848556557,623.4066843302342,520.00001326365,452.3536553110712,0.00013072421224524805,-8.3546830699715e-07,-0.0003501622933504362,1.1112503885429175e-06,-0.006429793878929813,5.259630895487669e-06,0.002177373986621808,2.6275210793723156e-06,-0.00020277543483631201,-8.155518470716679e-07,-0.0012439563696041065,-2.1043295206092605e-06,-0.00029627998950476457,-3.708115608908681e-07,0.0023166529220947554,6.31046864966112e-06,0.0010703382764531942,-4.0974857373750505e-06)
TRIPLET(204,202447,205,0ECK7B0420,0.154,0.1551,0.1399,0.1273,0.6973,0.698,0.0231,0.022,0.7402,0.7216,0.3024,0.3017,0.4095,0.8659,2.7184,5.0841,1.0915,2.5391,2.854,3.0139,2.5997,2.9111,2.1225,2.429,623.1715555505127,523.4960314432575,453.41685591193294,623.5809381183982,520.0001809778234,452.41509992157165,0.0001304230446083622,-8.364722579371861e-07,-0.0003498439053247664,1.122219537993501e-06,-0.006432024953807209,5.262702451490067e-06,0.0021789774279535896,2.631691513600492e-06,-0.00020249920227903787,-8.164575180149611e-07,-0.0012432196513326385,-2.1094881896089906e-06,-0.0003074070780726473,-3.5245222427829853e-07,0.0024413600590569,6.413381907505142e-06,0.0012152945334125767,-3.956704604225738e-06)
TRIPLET(205,202447,206,0ECK3Z0309,0.1538,0.1549,0.1463,0.1332,0.6969,0.6976,0.0235,0.0223,0.7419,0.7253,0.3029,0.3022,0.4088,0.8622,2.687,5.0244,1.1091,2.5737,2.8556,3.0103,2.6046,2.9156,2.1346,2.4512,622.8814782279493,524.7299458731356,453.65452300273074,623.2851115333052,521.2429014482836,452.6324510183392,0.00013236034045268144,-8.327523815228568e-07,-0.000352083998355205,1.0661294939665366e-06,-0.006420014256751461,5.224513296725355e-06,0.00208945827160114,2.5327055534537645e-06,-0.00022110672959634557,-7.877533994243321e-07,-0.0012858412470693247,-1.935323777944733e-06,-0.0003095685743678951,-3.6939461855731673e-07,0.0024587391143368886,6.643853500388368e-06,0.0012207721378172005,-3.706387923361639e-06)
TRIPLET(206,202447,207,0ECJMW0511,0.1537,0.1548,0.1406,0.1268,0.6969,0.6977,0.0237,0.0225,0.7393,0.72,0.3027,0.302,0.4012,0.8472,2.7959,5.1979,1.0998,2.5519,2.8409,2.9996,2.6057,2.9219,2.1304,2.4428,622.9976910754363,523.5517211538828,453.7732877646936,623.4066843302342,520.00001326365,452.7568378144337,0.00013152489275362393,-8.336564275261859e-07,-0.00035106887149040963,1.0866180401750429e-06,-0.0064245952339286455,5.245694847021878e-06,0.002173067298215239,2.602927922696917e-06,-0.00020319863694367323,-8.109322508040596e-07,-0.0012457859385165237,-2.079083710762448e-06,-0.0003035713999429534,-3.9478310175031154e-07,0.0023863538453778744,6.747393201914565e-06,0.0011255106959088892,-3.6138230598520185e-06)
TRIPLET(207,202447,208,0ECI330117,0.1543,0.1554,0.1393,0.1269,0.6967,0.6975,0.0228,0.0217,0.7394,0.7208,0.3029,0.3022,0.4038,0.8535,2.7015,5.0589,1.1176,2.5743,2.8558,3.0154,2.6036,2.9155,2.1341,2.4459,622.889401436803,523.3346625188453,453.150767759369,623.2895288683295,520.00001326365,452.13602822440146,0.00013232294979572792,-8.330074278377264e-07,-0.00035205361486016594,1.0681804805422685e-06,-0.00642040273669477,5.224016868075394e-06,0.0021892152675429062,2.6255457034766042e-06,-0.00019995544797551463,-8.168877803652763e-07,-0.0012381506656356745,-2.1145508139033863e-06,-0.0003066269537093829,-3.295628287457363e-07,0.0024406870959420013,6.15804431442316e-06,0.0012318687618089082,-4.2294197151296e-06)
TRIPLET(208,202447,209,0ECKI50110,0.1534,0.1545,0.1359,0.1232,0.6978,0.6985,0.024,0.0228,0.737,0.7166,0.302,0.3013,0.4151,0.877,2.6872,5.0231,1.1071,2.5307,2.8663,3.0185,2.6023,2.9137,2.1418,2.4608,623.4022841735936,522.5759259567214,454.0367280096829,623.8060899458046,520.00001326365,453.03364338318573,0.00012623284742201068,-8.132469005605372e-07,-0.00034280576167432757,1.0782792732641608e-06,-0.006431268160347245,5.5557936955582615e-06,0.002243706490423081,2.679210302393563e-06,-0.0001884720305891731,-8.33284173312639e-07,-0.001212133062224446,-2.2149621757322054e-06,-0.0003167554679290212,-3.8776767558390224e-07,0.002529195037764057,7.020584749522396e-06,0.0012809651260531005,-3.286788514545534e-06)
TRIPLET(209,202447,210,0ECICB0511,0.1542,0.1553,0.144,0.1318,0.6966,0.6975,0.0229,0.0218,0.7435,0.7279,0.303,0.3023,0.4038,0.8562,2.7309,5.1302,1.1181,2.5877,2.8601,3.0128,2.5854,2.8812,2.1382,2.4586,622.8350151847785,524.4418289762606,453.2395236104917,623.2262369903721,521.206033044492,452.22909530497844,0.00013251842943399263,-8.306521081875643e-07,-0.00035214079360816847,1.0520572807241942e-06,-0.006417498064864147,5.23349100095515e-06,0.0021162032961477167,2.631731102157517e-06,-0.00021720048797374593,-8.076715829564141e-07,-0.0012738811866494643,-2.0464289539203986e-06,-0.00030912476109858783,-3.3184757455629136e-07,0.0024665429567227153,6.246891032058545e-06,0.001257323998583918,-4.128171390082984e-06)
TRIPLET(210,202447,211,0ECJLH0109,0.1538,0.1549,0.1388,0.1258,0.6968,0.6976,0.0234,0.0223,0.7381,0.7184,0.3028,0.3021,0.4057,0.8563,2.715,5.0539,1.1123,2.5613,2.8504,3.0083,2.593,2.8934,2.1288,2.4346,622.943631654591,523.1543750989265,453.62424516763923,623.3482088450268,520.00001326365,452.6324510183392,0.0001322390197051235,-8.364529535393485e-07,-0.0003521868972279977,1.0879673394311285e-06,-0.006423731010027232,5.2035636735219894e-06,0.002205493176568622,2.6815642491512615e-06,-0.0001974767871700005,-8.28316291324267e-07,-0.001230824012117891,-2.1785569152951133e-06,-0.0003070118916268306,-3.7269097379558546e-07,0.0024303928247720805,6.61074368979112e-06,0.0011884851365012404,-3.748760191008521e-06)
TRIPLET(211,202447,212,0ECKSI0717,0.1533,0.1545,0.1463,0.1332,0.6969,0.6977,0.0241,0.0228,0.7418,0.7252,0.3028,0.3021,0.4111,0.8656,2.6827,5.0137,1.1073,2.5641,2.865,3.0115,2.6003,2.9092,2.1341,2.4511,622.9396701312091,524.7228587805024,454.12122012721716,623.3438062032577,521.2353308735303,453.03364338318573,0.00013179517071441267,-8.317538529471875e-07,-0.0003512843623751024,1.071480841304362e-06,-0.006421736690863961,5.249680247807902e-06,0.002091354705811759,2.5512343132941446e-06,-0.00022110362077376074,-7.910450104040514e-07,-0.0012851213733593289,-1.9529891341950704e-06,-0.00031667056948045,-3.9583114320499434e-07,0.002525598656771549,7.101116644076222e-06,0.0012710965557892716,-3.2017205149970364e-06)
TRIPLET(212,202447,213,0ECJHJ0709,0.1536,0.1547,0.1421,0.128,0.6964,0.6973,0.0236,0.0225,0.7399,0.7207,0.3031,0.3024,0.4144,0.8706,2.787,5.1771,1.1164,2.5821,2.8233,2.986,2.6013,2.9141,2.1313,2.4431,622.7844078282682,523.856539919933,453.80113607150946,623.1715555505127,520.0440447145327,452.8180763481897,0.0001336817542684089,-8.381604394210161e-07,-0.0003541691503557311,1.0698596298811003e-06,-0.0064186146408765484,5.1449831620503514e-06,0.002152768442998851,2.602063191204549e-06,-0.0002079316085397388,-8.079478885711365e-07,-0.0012556909803356933,-2.0579462940527276e-06,-0.0002957026686758878,-4.1618843581788317e-07,0.0022953534532448583,6.761052336983309e-06,0.001013687943213961,-3.6218141309316117e-06)
TRIPLET(213,202447,214,0ECKSI0316,0.1541,0.1551,0.1469,0.1336,0.6972,0.6979,0.023,0.022,0.7424,0.726,0.3026,0.3019,0.4001,0.8534,2.694,5.0384,1.0888,2.5282,2.8596,3.007,2.5947,2.8987,2.1264,2.4354,623.0483483860381,524.8708722519208,453.32821848556557,623.4605597689591,521.3629256352363,452.41509992157165,0.00013135940459255474,-8.360142113570999e-07,-0.0003510205832603433,1.1021902599797737e-06,-0.006427365307607254,5.235225283232292e-06,0.0020826187091413538,2.5653758666790303e-06,-0.00022348597920383555,-7.921309116784865e-07,-0.0012895458791910895,-1.9562366099331247e-06,-0.00030943045681886363,-3.3936810193118683e-07,0.0024672902795655205,6.3320774594310334e-06,0.0012524315470341732,-4.03705775548577e-06)
TRIPLET(214,202447,215,0ECIB80409,0.1536,0.1548,0.1454,0.1322,0.6972,0.6979,0.0236,0.0225,0.7411,0.7243,0.3024,0.3018,0.4141,0.8749,2.7145,5.0684,1.1178,2.5771,2.8637,3.0202,2.613,2.932,2.1413,2.4639,623.1759534640657,524.5156195258771,453.80113607150946,623.5230655825276,521.0006865916343,452.7568378144337,0.00012865492620818889,-8.193436508138653e-07,-0.000346360122342229,1.0649504603498113e-06,-0.006425440366031477,5.435704997161027e-06,0.0021020139716733752,2.5110044683861952e-06,-0.0002176499581143686,-7.859679310139858e-07,-0.0012794668500962394,-1.929485783634467e-06,-0.00031414985199149895,-3.720802503327742e-07,0.0025066641908080157,6.79136469513277e-06,0.0012691243366678394,-3.5370471007813713e-06)
TRIPLET(215,202447,216,0ECI990213,0.154,0.1551,0.1361,0.1235,0.6969,0.6977,0.0232,0.0221,0.7375,0.7177,0.3026,0.302,0.4102,0.8664,2.6732,5.0027,1.1185,2.5628,2.8711,3.0265,2.593,2.8934,2.1434,2.4628,623.0615620161075,522.646993540794,453.44713336833604,623.4066843302342,520.00001326365,452.44663414036876,0.0001296635955501936,-8.202952348464136e-07,-0.0003477290050362599,1.051010827984559e-06,-0.006421656271062186,5.396379360947716e-06,0.0022416511963843835,2.713795830270698e-06,-0.00018977649124621217,-8.386445692614307e-07,-0.0012135222249478354,-2.2423125214412767e-06,-0.0003153974585697885,-3.361635767051294e-07,0.0025319488534977803,6.455419992939783e-06,0.001322821469894403,-3.889364223667806e-06)
TRIPLET(216,202447,217,0ECN4U0518,0.1533,0.1544,0.1377,0.1254,0.6973,0.698,0.0241,0.0229,0.7397,0.7215,0.3023,0.3017,0.4148,0.872,2.7251,5.1065,1.0903,2.5352,2.8173,2.9747,2.6093,2.9334,2.1225,2.4267,623.2350475116187,523.0828928747484,454.12122012721716,623.5809381183982,520.00001326365,453.1225079615919,0.0001297564323300978,-8.348889280111985e-07,-0.000348872299647726,1.1263880643421274e-06,-0.0064337098069196285,5.29511662749125e-06,0.0022053129824342365,2.617574863848263e-06,-0.00019599600092101564,-8.178407495252455e-07,-0.0012301991797614522,-2.1239508258422008e-06,-0.00029489010799147353,-4.4790937210696723e-07,0.0022761055334605904,7.065327052894804e-06,0.000969504576389519,-3.301804360001157e-06)
TRIPLET(217,202447,218,0ECNAS0406,0.1535,0.1546,0.1389,0.1263,0.6969,0.6977,0.0237,0.0226,0.741,0.7236,0.3027,0.302,0.4143,0.8693,2.769,5.1843,1.112,2.5385,2.8234,2.9958,2.5784,2.8717,2.1353,2.4444,622.9976910754363,523.3819749160525,453.8894971884302,623.4066843302342,520.00001326365,452.91081911335084,0.0001310760882002407,-8.292206414812416e-07,-0.00035017840529932755,1.0716162679407206e-06,-0.006422848620349019,5.290200740302858e-06,0.0021939977321412153,2.7284888790840047e-06,-0.0002012856044543565,-8.343695980485261e-07,-0.0012369615347067378,-2.2069139658211287e-06,-0.0002962803230179929,-4.230276456354537e-07,0.0022992264010998926,6.8463669803042825e-06,0.0010125956156221763,-3.529788387716052e-06)
TRIPLET(218,202447,219,0ECJBU0208,0.1535,0.1546,0.1338,0.122,0.697,0.6978,0.0238,0.0226,0.7379,0.7186,0.3025,0.3018,0.4127,0.8703,2.6156,4.9169,1.0965,2.546,2.8663,3.0221,2.5995,2.9001,2.1253,2.4331,623.1210610789501,522.2867739396492,453.91977333286565,623.5274722684073,520.00001326365,452.91081911335084,0.00013069673441544905,-8.351967282597042e-07,-0.0003501077750122067,1.110331912691836e-06,-0.006429686943404529,5.262355746096709e-06,0.0022652186234581946,2.7093508588442522e-06,-0.00018415171688747125,-8.412195970776692e-07,-0.0012019615472464065,-2.2622190392830033e-06,-0.0003160513225850918,-3.785707962426631e-07,0.002524761111869691,6.907761692204267e-06,0.001283247799272573,-3.4083159699795807e-06)
TRIPLET(219,202447,220,0ECKBA0606,0.1541,0.1551,0.1364,0.124,0.6969,0.6976,0.0231,0.022,0.7379,0.7178,0.3029,0.3022,0.4057,0.8564,2.7046,5.0599,1.109,2.5711,2.854,3.0115,2.6092,2.9254,2.1321,2.4453,622.8814782279493,522.7278221983155,453.35849700008356,623.2851115333052,520.00001326365,452.41509992157165,0.00013258932236767288,-8.350155376682366e-07,-0.0003525383178404509,1.0737834593922102e-06,-0.006420905386128822,5.2018062083166925e-06,0.002230649083115596,2.640551277278098e-06,-0.00019060968604898436,-8.251417755586982e-07,-0.001218080095488027,-2.168957747184278e-06,-0.00030705571840774267,-3.4786309723036327e-07,0.002439147585836866,6.357084621789118e-06,0.0012164335586214992,-4.017345275056113e-06)
TRIPLET(220,202447,221,0ECJH60218,0.1535,0.1545,0.1415,0.1278,0.6965,0.6973,0.0239,0.0227,0.7393,0.7201,0.3032,0.3025,0.416,0.8746,2.7782,5.1604,1.1107,2.5612,2.8288,2.9933,2.5984,2.9074,2.1316,2.4412,622.7217488054146,523.7081275835468,453.95005738617095,623.1078562815069,520.00001326365,453.00336413382723,0.0001343121435646322,-8.394514192230956e-07,-0.00035507349139531584,1.0648273137391513e-06,-0.00641684495548755,5.115719071705958e-06,0.002164283266522883,2.6236836443331384e-06,-0.0002057496651081848,-8.130916042322185e-07,-0.0012503075885656324,-2.0879084652093235e-06,-0.0002991106485170159,-4.2189422503633036e-07,0.002329766832870627,6.908839439639017e-06,0.0010455561148556662,-3.4555301169207347e-06)
TRIPLET(221,202447,222,0ECKIK0402,0.1539,0.155,0.1359,0.123,0.6969,0.6977,0.0234,0.0222,0.7371,0.717,0.3027,0.3021,0.4039,0.8538,2.6933,5.0385,1.1044,2.5631,2.8651,3.015,2.6028,2.9144,2.127,2.4352,622.9976910754363,522.5833163789666,453.56599601375945,623.3438062032577,520.00001326365,452.53956127768106,0.0001318363081580123,-8.367343198839022e-07,-0.00035168674599034413,1.0970274331539598e-06,-0.0064258071698818555,5.214813206786098e-06,0.002243018031294746,2.6766386664089596e-06,-0.0001885720464201174,-8.327677631529929e-07,-0.0012124406817060347,-2.2120829634128647e-06,-0.0003133734104698526,-3.520612121941212e-07,0.0025050723305157594,6.565581781314309e-06,0.0012825654596916834,-3.778443363383488e-06)
TRIPLET(222,202447,223,0ECNB10208,0.1532,0.1544,0.1388,0.1263,0.6966,0.6974,0.0241,0.0229,0.7406,0.7227,0.3029,0.3022,0.4188,0.8793,2.7551,5.1571,1.1128,2.5781,2.821,2.9762,2.581,2.8797,2.1382,2.4575,622.8933791442231,523.3358829761435,454.176656157667,623.293937503014,520.00001326365,453.1225079615919,0.0001319056568672593,-8.291966577340232e-07,-0.00035124766078720756,1.0558891312217498e-06,-0.006419046838866565,5.263287208547489e-06,0.0021964411268885625,2.7204856685531707e-06,-0.0002005229333017169,-8.33404800965402e-07,-0.0012356789385208438,-2.202562786736796e-06,-0.00029691333971537713,-4.4822904362215397e-07,0.002297559911959785,7.121580844694309e-06,0.0009918165258993514,-3.2364375343853475e-06)
TRIPLET(223,202447,224,0ECI940415,0.1535,0.1547,0.1362,0.1238,0.6965,0.6974,0.0238,0.0226,0.738,0.7185,0.3031,0.3024,0.4155,0.8765,2.6381,4.9435,1.1175,2.5802,2.8631,3.0196,2.5881,2.8834,2.1318,2.4428,622.7804419790724,522.7009927101044,453.91977333286565,623.1671524279715,520.00001326365,452.8496316579241,0.00013367759597189625,-8.378067065029116e-07,-0.00035413897511163563,1.0680684613629314e-06,-0.006418331175325935,5.14749991815941e-06,0.0022393885276112686,2.7309666535018076e-06,-0.00019071503468978473,-8.411318705510257e-07,-0.001214818675954117,-2.2546426865428605e-06,-0.0003145901595501921,-3.8206451390484933e-07,0.002508023627706274,6.9053607133409436e-06,0.0012630152136524665,-3.4150301901895e-06)
TRIPLET(224,202447,225,0ECLXC0618,0.1533,0.1543,0.1365,0.1244,0.6968,0.6976,0.0241,0.023,0.7399,0.7212,0.3029,0.3022,0.4008,0.8542,2.696,5.0481,1.1065,2.5634,2.8385,2.9854,2.5929,2.8925,2.1356,2.4533,622.8854397517534,522.892329481839,454.12122012721716,623.2851115333052,520.00001326365,453.2113265159408,0.00013222715501317984,-8.317483286181308e-07,-0.0003518416480988169,1.0633279992483298e-06,-0.00641976292989499,5.235618585444867e-06,0.002224199943003863,2.698631214950658e-06,-0.00019350227072423504,-8.337236957771922e-07,-0.0012218770963091658,-2.211874667115164e-06,-0.00030457031309768525,-4.247634925949795e-07,0.002386991366043237,7.0812335378643235e-06,0.0011035454561227412,-3.2573226511104372e-06)
TRIPLET(225,202447,226,0ECI430205,0.1539,0.155,0.1384,0.1256,0.6969,0.6977,0.0235,0.0223,0.7394,0.7205,0.3028,0.3021,0.4128,0.8717,2.6505,4.9556,1.1022,2.5567,2.8673,3.023,2.594,2.897,2.1266,2.4352,622.9396701312091,523.1804553984238,453.59628467252793,623.3438062032577,520.00001326365,452.57111332358465,0.000132482116459387,-8.385433213833265e-07,-0.0003526473208308403,1.094442737581386e-06,-0.0064244100789960425,5.181558982581912e-06,0.0022033110143855664,2.675703175569393e-06,-0.00019784830544967356,-8.270534588770607e-07,-0.0012318245641901784,-2.1713786447997237e-06,-0.0003145603180314707,-3.52041068397721e-07,0.002517727639019071,6.596451115539666e-06,0.001295884200736723,-3.7423544303144644e-06)
TRIPLET(226,202447,227,0ECM310618,0.1536,0.1547,0.1399,0.1273,0.6967,0.6975,0.0237,0.0225,0.7401,0.7215,0.303,0.3023,0.4161,0.8776,2.721,5.0886,1.112,2.5639,2.8686,3.0236,2.6016,2.9143,2.1309,2.4408,622.8310453574378,523.4887719125857,453.8314170616765,623.2262369903721,520.00001326365,452.8180763481897,0.000133228736479435,-8.373595216479762e-07,-0.0003535281560348526,1.0741462231514259e-06,-0.00641999481740494,5.1651596102903425e-06,0.002178879975091732,2.6241644812001755e-06,-0.00020234287597247391,-8.152146055878169e-07,-0.0012431833991556106,-2.1029882646044383e-06,-0.00031656956969370546,-3.691116792287058e-07,0.002533441460846114,6.824252457578806e-06,0.0012995144715024429,-3.495301012844192e-06)
TRIPLET(227,202447,228,0ECJN00318,0.1541,0.1551,0.1409,0.127,0.697,0.6979,0.0231,0.022,0.7394,0.72,0.3026,0.3018,0.4021,0.8488,2.7921,5.1905,1.0976,2.5331,2.8335,2.9967,2.6046,2.9196,2.1247,2.4308,623.0571483010252,523.6110282362201,453.35849700008356,623.5230655825276,520.00001326365,452.41509992157165,0.0001314227205765553,-8.373337097743429e-07,-0.0003511948570472512,1.1079727095713604e-06,-0.006428204794345867,5.224277031751762e-06,0.0021691967749805506,2.6037851660296615e-06,-0.00020412543262073556,-8.105301286089639e-07,-0.0012476859879661155,-2.075922644864067e-06,-0.0002976951427154154,-3.702447260037478e-07,0.0023319230779149658,6.341703350945951e-06,0.0010868185569926775,-4.060358248275914e-06)
TRIPLET(228,202447,229,0ECI2U0614,0.1542,0.1553,0.1368,0.1246,0.6965,0.6975,0.0229,0.0218,0.7377,0.7184,0.303,0.3023,0.4044,0.8531,2.6622,4.9909,1.1153,2.5691,2.864,3.0187,2.6089,2.9231,2.1299,2.4387,622.838982512759,522.7816135830552,453.2395236104917,623.2262369903721,520.00001326365,452.22909530497844,0.00013323699577928136,-8.380668514020774e-07,-0.0003535884230166628,1.077728918459185e-06,-0.006420561893313866,5.160128883966303e-06,0.0022269127689626706,2.6383954559716198e-06,-0.0001914333402083368,-8.24266378392112e-07,-0.0012198810267837073,-2.1633688658693026e-06,-0.0003109055535473718,-3.275896061555011e-07,0.0024869417655468806,6.2498172250482216e-06,0.0012819824623084251,-4.119988434202144e-06)
TRIPLET(229,202447,230,0ECLX40118,0.1542,0.1553,0.1354,0.1234,0.6965,0.6974,0.0229,0.0218,0.7398,0.7214,0.3031,0.3024,0.4078,0.861,2.7029,5.0709,1.1141,2.5619,2.8565,3.0171,2.5963,2.8975,2.1355,2.4473,622.7804419790724,522.6970647166926,453.2395236104917,623.1671524279715,520.00001326365,452.22909530497844,0.00013333870273770894,-8.3445723540775e-07,-0.00035346658227347166,1.056740592532934e-06,-0.006417012303847442,5.181106409004228e-06,0.002237015122843806,2.696740806278303e-06,-0.00019045624007659395,-8.352099135753282e-07,-0.0012155966523879477,-2.223147072203158e-06,-0.00030748095268432526,-3.3577800692625157e-07,0.002447713287038869,6.2441899308373064e-06,0.001234562339761297,-4.135724887819144e-06)
TRIPLET(230,202447,231,0ECI5W0110,0.1539,0.155,0.1357,0.1237,0.697,0.6978,0.0235,0.0223,0.7382,0.7191,0.3025,0.3018,0.4074,0.8596,2.6765,5.0124,1.0965,2.5492,2.8665,3.0173,2.6063,2.9158,2.1248,2.431,623.1210610789501,522.6304120147153,453.59628467252793,623.5274722684073,520.00001326365,452.57111332358465,0.00013074253079844737,-8.3564935948878e-07,-0.00035019863890925593,1.1118627057769715e-06,-0.006429865169280002,5.257814328414976e-06,0.0022385292911879565,2.6589318017998284e-06,-0.00018920177877011915,-8.292472894938337e-07,-0.0012144358847713023,-2.192511184886711e-06,-0.00031419502727274545,-3.529144978132681e-07,0.002513543267978216,6.595850870823835e-06,0.0012908260543316938,-3.7440329853669446e-06)
TRIPLET(231,202447,232,0ECJR00216,0.1541,0.1551,0.1398,0.1261,0.6964,0.6973,0.0231,0.022,0.7385,0.719,0.3031,0.3025,0.4002,0.8469,2.7532,5.1165,1.1165,2.5893,2.8445,3.003,2.6252,2.9518,2.1332,2.4463,622.7844078282682,523.355281649354,453.35849700008356,623.1078562815069,520.00001326365,452.41509992157165,0.0001335077280130154,-8.364404407505274e-07,-0.0003538238675469442,1.0640426161575878e-06,-0.006417937382549755,5.1622405492409325e-06,0.002180756609377215,2.5334226853081694e-06,-0.00019974370240052658,-8.006581331976165e-07,-0.0012412559160167075,-2.0276956836822306e-06,-0.00030271789064788366,-3.582350715399806e-07,0.0023894581797267167,6.349956715788626e-06,0.0011563680700618015,-4.037278116304314e-06)
TRIPLET(232,202447,233,0ECJBJ0319,0.1544,0.1554,0.1362,0.1237,0.6965,0.6974,0.0227,0.0216,0.7374,0.7176,0.3031,0.3023,0.402,0.8513,2.6572,4.9719,1.1158,2.5754,2.8451,3.0014,2.5961,2.8984,2.1302,2.4399,622.7804419790724,522.6566963627832,453.0619642855558,623.2306448187245,520.00001326365,452.10451316388196,0.00013382414439749082,-8.392551264359545e-07,-0.0003544297395821931,1.0729669992353642e-06,-0.006418901498127447,5.132967381577863e-06,0.002239956647006767,2.700146082085989e-06,-0.00018984844626529707,-8.361780414738192e-07,-0.001214197843479726,-2.228999827744151e-06,-0.00030120653352994444,-3.342617733888966e-07,0.002381354461387368,6.064349698721758e-06,0.0011659492832737373,-4.344145965272991e-06)
TRIPLET(233,202447,234,0ECKEF0619,0.1535,0.1546,0.1361,0.1243,0.6974,0.698,0.0238,0.0226,0.7398,0.7212,0.3025,0.3018,0.4005,0.8468,2.6572,4.9823,1.0997,2.5542,2.8657,3.0191,2.5879,2.8816,2.1242,2.4319,623.1034559026549,522.816475319535,453.91977333286565,623.5186451117542,520.00001326365,452.91081911335084,0.0001309823260263138,-8.366315458107072e-07,-0.00035057708432558913,1.1125438002653996e-06,-0.006429611860934012,5.243376760496547e-06,0.0022312234947257353,2.724471445370098e-06,-0.0001924725190768956,-8.389274904220771e-07,-0.0012187344082520853,-2.240911812216086e-06,-0.0003157773545160482,-3.7922586830432277e-07,0.0025216228335890496,6.907311508667394e-06,0.0012794541894688045,-3.4095748862689407e-06)
TRIPLET(234,202447,235,0ECM3E0608,0.1542,0.1552,0.1388,0.1263,0.6968,0.6977,0.023,0.0219,0.7393,0.7207,0.3027,0.302,0.4067,0.8599,2.7012,5.0554,1.1184,2.5777,2.8548,3.0146,2.6049,2.9185,2.145,2.4717,623.001849756772,523.2416217715595,453.269794769221,623.4066843302342,520.00001326365,452.32212005834464,0.00013014397570803763,-8.203358885772989e-07,-0.00034835200616923094,1.042191917799789e-06,-0.006419501395126096,5.3804273503549725e-06,0.0021954250700323024,2.6259905395674575e-06,-0.00019851183394241676,-8.178301981238753e-07,-0.0012351225351461001,-2.121170497630995e-06,-0.00030688696243522345,-3.4001445539286505e-07,0.002439969123265478,6.272116190251959e-06,0.0012232229586403819,-4.107837094899342e-06)
TRIPLET(235,202447,236,0ECHYM0314,0.1536,0.1547,0.1455,0.133,0.6971,0.6979,0.0237,0.0225,0.744,0.7294,0.3024,0.3018,0.4155,0.8765,2.7143,5.1124,1.1179,2.5748,2.867,3.0216,2.6011,2.9072,2.1421,2.4661,623.1803659497215,524.7380639282451,453.8314170616765,623.5230655825276,521.5189293915893,452.8180763481897,0.00012853532460111147,-8.185094045456621e-07,-0.0003461472166592837,1.0627908904935805e-06,-0.00642527229646504,5.445223945699105e-06,0.0020900122653693025,2.546904950108509e-06,-0.00022131494997016044,-7.901499411313366e-07,-0.0012857288391368064,-1.9479576174153592e-06,-0.0003158389881762556,-3.708585380597991e-07,0.0025250727187644054,6.823051968147144e-06,0.001289398178692388,-3.4986581229491525e-06)
TRIPLET(236,202447,237,0ECJHW0104,0.154,0.1551,0.1397,0.1259,0.6965,0.6974,0.0232,0.0221,0.739,0.7192,0.303,0.3022,0.4016,0.8471,2.7703,5.1489,1.1104,2.5796,2.8519,3.0105,2.6127,2.9318,2.1298,2.4394,622.838982512759,523.374414527359,453.44713336833604,623.293937503014,520.00001326365,452.44663414036876,0.00013324615505588104,-8.381573776478927e-07,-0.0003536065957960727,1.0780350770762124e-06,-0.006420597538488961,5.159220600429955e-06,0.002183437833748858,2.584761187153459e-06,-0.00020033770324933504,-8.094179248324844e-07,-0.001240518225637044,-2.074055530546967e-06,-0.0003066304803603893,-3.5712588267825063e-07,0.0024315239485172696,6.441014119759842e-06,0.0012014259561737468,-3.929649544927326e-06)
TRIPLET(237,202447,238,0ECJ640110,0.1544,0.1554,0.1438,0.1318,0.6969,0.6976,0.0229,0.0218,0.7438,0.7287,0.3027,0.3021,0.4002,0.844,2.6694,5.0356,1.1192,2.569,2.8609,3.0168,2.6108,2.9201,2.132,2.4404,622.9976910754363,524.4283467068559,453.1225079615919,623.3482088450268,521.2661701758782,452.16755322243233,0.0001313783443280294,-8.322080075931426e-07,-0.0003507781070198522,1.0817195023026101e-06,-0.006424024911127134,5.260227383603425e-06,0.002108945247279893,2.5257979937160997e-06,-0.00021637889766374578,-7.893547297493684e-07,-0.0012762461719965446,-1.9490346146914786e-06,-0.00030878553942068456,-3.217724711824706e-07,0.0024662910903267936,6.134609401314483e-06,0.0012646660082364092,-4.248083646477695e-06)
TRIPLET(238,202447,239,0ECJSS0320,0.1534,0.1545,0.1449,0.1315,0.6966,0.6974,0.0239,0.0228,0.7418,0.725,0.303,0.3023,0.41,0.8719,2.7151,5.0715,1.1156,2.582,2.8629,3.0204,2.5866,2.8832,2.1285,2.4363,622.8350151847785,524.4780217600555,454.0077409373861,623.2306448187245,520.9376917109779,453.03364338318573,0.00013340687926415942,-8.394331540316368e-07,-0.00035390355321092274,1.0817546665758114e-06,-0.006420955646848306,5.145387497929539e-06,0.002113235762928333,2.624386766881592e-06,-0.00021772062068441058,-8.060565122219408e-07,-0.0012752488179419773,-2.037199763555123e-06,-0.00031502846065004455,-3.892003154065758e-07,0.0025103125177801163,6.990070653976669e-06,0.001260033761571775,-3.3240428033516027e-06)
TRIPLET(239,202447,240,0ECLY40406,0.1546,0.1556,0.1357,0.1237,0.6964,0.6971,0.0225,0.0214,0.7372,0.7175,0.3032,0.3026,0.4007,0.8471,2.66,4.9792,1.1098,2.5691,2.8514,3.0109,2.6145,2.9321,2.1321,2.4436,622.7257139516769,522.5566371442493,452.87926248047864,623.0527597757919,520.00001326365,451.9148972603919,0.0001342247164753593,-8.38899907212443e-07,-0.0003549219496021736,1.0635568499363788e-06,-0.0064167719506338415,5.122284792095894e-06,0.002241133451576572,2.6291430005186223e-06,-0.00018788295031445023,-8.247471381547356e-07,-0.0012128320722301234,-2.169792259239418e-06,-0.0003029832112439218,-3.1301652858463277e-07,0.0024073798859376317,5.8928290675116175e-06,0.0012093480848071048,-4.520772556743195e-06)
TRIPLET(240,202447,241,0ECM9S0517,0.1537,0.1548,0.1362,0.1244,0.697,0.6977,0.0235,0.0223,0.7391,0.7201,0.3028,0.3022,0.4074,0.8615,2.6164,4.8954,1.1152,2.5636,2.8695,3.0241,2.593,2.8921,2.1306,2.4383,622.9357003143722,522.7820745646775,453.7127245505845,623.2807246824516,520.00001326365,452.6937351425863,0.00013215742513878652,-8.350212688046899e-07,-0.000351981159023475,1.0819357569741898e-06,-0.006422878927029894,5.215863636886666e-06,0.0022320247875013185,2.7052147635976786e-06,-0.0001918265536517512,-8.358948548968807e-07,-0.001218128508105913,-2.2253387619135725e-06,-0.00031626591352918744,-3.5879553499274883e-07,0.0025336490684884517,6.7104282331925556e-06,0.0013075214777612913,-3.6167458752214382e-06)
TRIPLET(241,202447,242,0ECLUM0316,0.1539,0.155,0.1455,0.1322,0.6966,0.6974,0.0233,0.0222,0.7423,0.7256,0.3032,0.3024,0.4014,0.8489,2.6959,5.0363,1.0888,2.5111,2.8699,3.0244,2.595,2.8977,2.1371,2.4535,622.7178053740447,524.6180821361274,453.5357202154199,623.1671524279715,521.0990099988429,452.53956127768106,0.00013384978606978775,-8.345708149699999e-07,-0.0003541343341249069,1.0477296861984434e-06,-0.006414779826072391,5.163661449472642e-06,0.002100536461199181,2.5801731481249466e-06,-0.00021964221307350083,-7.970571344427349e-07,-0.0012809590613439325,-1.986830902890045e-06,-0.0003153828744754583,-3.4443985990062334e-07,0.002529030756177929,6.539976994465231e-06,0.0013135052486860851,-3.7998315764880932e-06)
TRIPLET(242,202447,243,0ECI8E0110,0.1536,0.1547,0.1383,0.1256,0.6967,0.6973,0.0237,0.0225,0.7399,0.7216,0.3031,0.3024,0.4098,0.8674,2.6734,5.0042,1.1195,2.5947,2.8678,3.0244,2.5891,2.8867,2.1323,2.4455,622.772537655011,523.1996358547569,453.8314170616765,623.1715555505127,520.00001326365,452.8180763481897,0.00013371478835438782,-8.375511892487889e-07,-0.00035416906961620775,1.0660187146568355e-06,-0.006417943196518527,5.14800598795088e-06,0.0022035296650329333,2.6950858690464912e-06,-0.00019825842134338118,-8.302495311877505e-07,-0.0012319336918658965,-2.188083994839567e-06,-0.00031620427893498063,-3.6998510864425245e-07,0.0025292570898052587,6.823652212862975e-06,0.0012944563250974137,-3.4969795678966723e-06)
TRIPLET(243,202447,244,0ECM9B0318,0.1542,0.1553,0.1368,0.1247,0.6964,0.6972,0.0228,0.0218,0.7397,0.7212,0.3031,0.3025,0.4028,0.8548,2.7128,5.0817,1.1045,2.562,2.8577,3.0107,2.5921,2.8912,2.132,2.4447,622.7844078282682,522.929107396746,453.20924981048285,623.1122562789869,520.00001326365,452.22909530497844,0.0001336176393322113,-8.375267557003097e-07,-0.00035404194089986223,1.067716519561911e-06,-0.006418365124650887,5.151341146804777e-06,0.002221837864471907,2.6996583369062493e-06,-0.00019407986449716986,-8.335605958861613e-07,-0.0012230422607583758,-2.210374193097336e-06,-0.0003078466203069554,-3.3208724414398804e-07,0.002452842118776886,6.215885970503335e-06,0.001242740430930471,-4.164664522196993e-06)
TRIPLET(244,202447,245,0ECLXC0519,0.1539,0.155,0.1347,0.1226,0.6971,0.6978,0.0233,0.0222,0.7385,0.719,0.3027,0.302,0.4001,0.8493,2.7038,5.0622,1.0839,2.5149,2.8555,3.0032,2.6047,2.9129,2.1272,2.4359,622.989757323568,522.4826992855213,453.5357202154199,623.4022841735936,520.00001326365,452.53956127768106,0.00013190128733756427,-8.367511152227599e-07,-0.00035177180916140294,1.0958942302340636e-06,-0.006425525345689345,5.212579402364103e-06,0.0022495736081904966,2.675042204029204e-06,-0.00018699887543609638,-8.334252407585686e-07,-0.0012092209226475842,-2.2173139890263492e-06,-0.0003088076408184091,-3.6016158938046376e-07,0.0024537120774425457,6.529172589580275e-06,0.001222458613395594,-3.830045567432733e-06)
TRIPLET(245,202447,246,0ECKEX0317,0.1534,0.1545,0.1367,0.1248,0.6968,0.6975,0.0239,0.0227,0.7399,0.7215,0.303,0.3023,0.4093,0.8651,2.6541,4.9686,1.1048,2.5511,2.8653,3.0187,2.594,2.8948,2.1304,2.4408,622.8270924030855,522.9266442151318,454.0077409373861,623.2262369903721,520.00001326365,453.00336413382723,0.00013331603556388853,-8.37910729623038e-07,-0.0003536795112574616,1.0754174874066837e-06,-0.006420068145789017,5.158600114164237e-06,0.0022213986047755533,2.6918266148473315e-06,-0.00019399633016837077,-8.322200487985574e-07,-0.0012231695648030078,-2.203271577402596e-06,-0.00031612433292621967,-3.865800271599358e-07,0.00252286563090268,6.991871388124161e-06,0.0012752082007868558,-3.319007138194162e-06)
TRIPLET(246,202447,247,0ECJFL0620,0.154,0.155,0.14,0.1271,0.6967,0.6975,0.0232,0.0222,0.7389,0.7199,0.3029,0.3022,0.4038,0.8527,2.7099,5.0403,1.1185,2.5787,2.8465,3.0045,2.5871,2.8828,2.131,2.441,622.889401436803,523.4188766892172,453.44713336833604,623.2895288683295,520.00001326365,452.53956127768106,0.00013260688737031735,-8.358137414579974e-07,-0.00035261697102187097,1.0776713976701057e-06,-0.006421507737122697,5.195860078448647e-06,0.0021885528480989833,2.6895671504788727e-06,-0.00020163431918014332,-8.272505383717327e-07,-0.0012391874172751783,-2.168337280358189e-06,-0.0003041647677389954,-3.6302153123319116e-07,0.0024032794439914993,6.436962467927982e-06,0.00116728346793981,-3.940979791531567e-06)
TRIPLET(247,202447,248,0ECI6K0720,0.154,0.1551,0.1345,0.1225,0.6965,0.6973,0.0231,0.022,0.7376,0.7179,0.3031,0.3024,0.4065,0.8576,2.6583,4.9707,1.1019,2.5436,2.8619,3.0183,2.5962,2.8938,2.1392,2.4598,622.7804419790724,522.3826399289056,453.41685591193294,623.1715555505127,520.00001326365,452.41509992157165,0.0001329998095035216,-8.31107764312588e-07,-0.00035279418943530763,1.0454127237029347e-06,-0.006415693432368948,5.214712899849052e-06,0.0022594546364822768,2.717135176202481e-06,-0.00018568678911229115,-8.416835503822515e-07,-0.0012048635990086667,-2.2630465882277928e-06,-0.00031101432431505645,-3.4382710879977536e-07,0.0024826807230853374,6.4193093240739714e-06,0.0012652437291622194,-3.940128873082498e-06)
TRIPLET(248,202447,249,0ECKH60703,0.1532,0.1542,0.1356,0.1233,0.6971,0.6978,0.0242,0.0231,0.7379,0.7183,0.3027,0.302,0.4118,0.8782,2.6881,5.0291,1.1185,2.5648,2.8784,3.0216,2.6086,2.9241,2.13,2.436,622.989757323568,522.5912636922334,454.20563924370344,623.4022841735936,520.00001326365,453.30007321329265,0.00013164482759277387,-8.342163803399352e-07,-0.00035126297133792754,1.0873217889573086e-06,-0.006424527280786701,5.238011341381803e-06,0.0022405749292676923,2.6517487898595667e-06,-0.00018855177481663866,-8.283607301442985e-07,-0.001213356703994981,-2.188457833914926e-06,-0.0003232974492083367,-3.8783960478543036e-07,0.002598887326076344,7.192607613119573e-06,0.0013541728505222055,-3.0858849216550057e-06)
TRIPLET(249,202447,250,0ECLXY0303,0.154,0.1551,0.1363,0.1243,0.6967,0.6976,0.0231,0.022,0.7378,0.718,0.3029,0.3022,0.4067,0.8598,2.6794,5.0214,1.1132,2.5664,2.8562,3.0151,2.6118,2.9273,2.1331,2.445,622.889401436803,522.7033244468612,453.41685591193294,623.2851115333052,520.00001326365,452.41509992157165,0.0001324145425617245,-8.339126902958782e-07,-0.0003522353426542643,1.0712420667125376e-06,-0.006420759188445714,5.214934032711927e-06,0.002231553590448653,2.6311762887909474e-06,-0.0001901747399361521,-8.2373740636931e-07,-0.0012175338643646144,-2.161893125815526e-06,-0.000308411627659141,-3.500502933855455e-07,0.002452867079419248,6.4150325804736765e-06,0.0012292044360264001,-3.952088577831418e-06)
