[![Build](https://github.com/adbancroft/avr-fast-multiply/actions/workflows/build.yml/badge.svg)](https://github.com/adbancroft/avr-fast-multiply/actions/workflows/build.yml)
[![Unit Tests](https://github.com/adbancroft/avr-fast-multiply/actions/workflows/unit-tests.yml/badge.svg)](https://github.com/adbancroft/avr-fast-multiply/actions/workflows/unit-tests.yml)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=adbancroft_avr-fast-multiply&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=adbancroft_avr-fast-multiply)
[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=adbancroft_avr-fast-multiply&metric=sqale_rating)](https://sonarcloud.io/summary/new_code?id=adbancroft_avr-fast-multiply)

# avr-fast-multiply: optimized widening integer multiplication for avr-gcc

* AVR-GCC does not implement widening muliplication: it will only multiply types of the same width. I.e. 16 * 16 => 16, 32 * 32 => 32.
* This forces the developer to cast (at least) one of the operands to the next wider type to avoid result overflow. 
* AVR is an 8 bit CPU, so multiplying two k-byte numbers into a 2k-byte result has to perform k^2 multiplications and in the order of k^3 additions.

As a result, multiplication of 16 * 16 => 32 takes almost twice as many CPU instructions as needed.

The functions provided here implement widening multiplication for unsigned 16-bit values. These are 18% faster on a physical AtMega2560.  See timing unit tests.

## Using the library

### Installation
The library is available in both the [Arduino Library](https://www.arduino.cc/reference/en/libraries/avr-fast-multiply/) and [PlatformIO Library](https://registry.platformio.org/libraries/adbancroft/avr-fast-multiply) registries. 

The library can also be cloned & included locally or included directly from GitHub (if your tooling supports it). 

### Code
1. `#include <avr-fast-multiply.h>`
2. Replace all 16/32-bit multiply operations with `fast_multiply()`