/*!
 * @file src/components/display/assets/icons.h
 *
 * Icon assets for displays.
 *
 * Adafruit invests time and resources providing this open source code,
 * please support Adafruit and open-source hardware by purchasing
 * products from Adafruit!
 *
 * Copyright (c) Brent Rubell 2025 for Adafruit Industries.
 *
 * BSD license, all text here must be included in any redistribution.
 *
 */
#ifndef _ICONS_H_
#define _ICONS_H_
#include <Arduino.h>

/**
 * @brief cloud-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_cloud_online[] = {
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0d, 0xc0, 0x18, 0x78, 0x10,
    0x0c, 0x30, 0x04, 0x70, 0x0c, 0xc0, 0x06, 0xc0, 0x03, 0xc0, 0x03,
    0x40, 0x03, 0x70, 0x06, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00};

/**
 * @brief cloud-xmark-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_cloud_offline[] PROGMEM = {
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0d, 0xc0, 0x18, 0x78, 0x10,
    0x0c, 0x30, 0x04, 0x73, 0xcc, 0xe3, 0x86, 0xc3, 0xc3, 0xc3, 0xc3,
    0x40, 0x03, 0x70, 0x06, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00};

/**
 * @brief wifi-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_wifi_full[] = {
    0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x3c, 0x3c, 0x70, 0x0e, 0xc0,
    0x03, 0x03, 0xc0, 0x0f, 0xf0, 0x1c, 0x38, 0x18, 0x18, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00};

/**
 * @brief wifi-fair-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_wifi_fair[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x03, 0xc0, 0x0f, 0xf0, 0x1c, 0x38, 0x18, 0x18, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00};

/**
 * @brief wifi-weak-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_wifi_weak[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00};

/**
 * @brief wifi-slash-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_wifi_no_signal[] = {
    0x00, 0x00, 0x40, 0x00, 0x27, 0xc0, 0x1e, 0x38, 0x68, 0x00, 0x44,
    0x03, 0x03, 0x00, 0x01, 0xe0, 0x08, 0x90, 0x00, 0x40, 0x00, 0x20,
    0x01, 0x90, 0x03, 0x88, 0x01, 0x84, 0x00, 0x02, 0x00, 0x00};

/**
 * @brief battery-full-thin-full icon from FontAwesome (16x16px)
 */
const unsigned char epd_bmp_bat_full[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0xc0, 0x06, 0xff,
    0xfa, 0xf0, 0x0b, 0xf0, 0x0b, 0xf0, 0x0b, 0xf0, 0x0b, 0xff, 0xfa,
    0xc0, 0x06, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#endif // _ICONS_H_