# Adafruit Community Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and leaders pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level or type of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

We are committed to providing a friendly, safe and welcoming environment for all.

Examples of behavior that contributes to creating and maintaining a positive environment include:

* Be kind and courteous to others
* Using welcoming and inclusive language
* Respecting the identity of every community member, including asking for their pronouns if uncertain
* Being respectful of differing viewpoints and experiences
* Collaborating with other community members
* Providing desired assistance and knowledge to other community members
* Being open to new information and ideas
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by community members include:

* The use of sexualized language or imagery and sexual attention or advances
* The use of inappropriate images, including in a community member's avatar
* The use of inappropriate language or profanity, including in a community member's nickname
* Any spamming, flaming, baiting or other attention-stealing behavior
* Excessive or unwelcome helping; answering outside the scope of the question asked
* Discussion or promotion of activities or projects that intend or pose a risk of significant harm
* Trolling, insulting/derogatory comments, and attacks of any nature
* Promoting or spreading disinformation, lies, or conspiracy theories
* Public or private harassment
* Publishing others' private information without explicit permission
* Engaging in behavior that creates an unwelcoming or uninclusive environment
* Other conduct which could reasonably be considered inappropriate

## Our Responsibilities

Project leaders are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project leaders have the right and responsibility to remove, edit, or reject messages, comments, commits, code, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any community member for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct and the enforcement policies listed above apply to all Adafruit Community venues. This includes but is not limited to any community spaces (both public and private), the entire Adafruit Discord server, and Adafruit GitHub repositories. Examples of Adafruit Community spaces include but are not limited to meet-ups, audio chats on the Adafruit Discord, or interaction at a conference.

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. As a community member, you are representing our community, and are expected to behave accordingly.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 1.4, available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html, and the [Rust Code of Conduct](https://forge.rust-lang.org/policies/code-of-conduct.html).

For other projects adopting the Adafruit Community Code of Conduct, it is possible to make modifications and customizations suitable for your project. For example, contact information, or project-specific enforcement policies. Additional language or practices may also need to be added to the Code of Conduct, but should aim to be in line with the overall spirit of the Adafruit Code of Conduct.

For answers to common questions about this code of conduct, see the FAQ at https://www.contributor-covenant.org/faq. Translations are available at https://www.contributor-covenant.org/translations.